/*!
 * ASP.NET SignalR JavaScript Library v1.1.4
 * http://signalr.net/
 *
 * Copyright Microsoft Open Technologies, Inc. All rights reserved.
 * Licensed under the Apache 2.0
 * https://github.com/SignalR/SignalR/blob/master/LICENSE.md
 *
 */
 !function(e,n){"use strict";function t(n,t){if(e.isArray(n)){for(var o=n.length-1;o>=0;o--){var r=n[o];"object"===e.type(n)||"string"===e.type(r)&&i.transports[r]||(t.log("Invalid transport: "+r+", removing it from the transports list."),n.splice(o,1))}0===n.length&&(t.log("No transports remain within the specified transport array."),n=null)}else if("object"===e.type(n)||i.transports[n]||"auto"===n){if("auto"===n&&i._.ieVersion<=8)return["longPolling"]}else t.log("Invalid transport: "+n.toString()),n=null;return n}function o(e){return"http:"===e?80:"https:"===e?443:void 0}function r(e,n){return n.match(/:\d+$/)?n:n+":"+o(e)}if("function"!=typeof e)throw new Error("SignalR: jQuery not found. Please ensure jQuery is referenced before the SignalR.js file.");if(!n.JSON)throw new Error("SignalR: No JSON parser found. Please ensure json2.js is referenced before the SignalR.js file if you need to support clients without native JSON parsing support, e.g. IE<8.");var i,c,a="complete"===n.document.readyState,s=e(n),l={onStart:"onStart",onStarting:"onStarting",onReceived:"onReceived",onError:"onError",onConnectionSlow:"onConnectionSlow",onReconnecting:"onReconnecting",onReconnect:"onReconnect",onStateChanged:"onStateChanged",onDisconnect:"onDisconnect"},u=function(e,t){if(t!==!1){var o;"undefined"!=typeof n.console&&(o="["+(new Date).toTimeString()+"] SignalR: "+e,n.console.debug?n.console.debug(o):n.console.log&&n.console.log(o))}},d=function(n,t,o){return t===n.state?(n.state=o,e(n).triggerHandler(l.onStateChanged,[{oldState:t,newState:o}]),!0):!1},p=function(e){return e.state===i.connectionState.disconnected},g=function(e){var t,o;e._.configuredStopReconnectingTimeout||(o=function(e){e.log("Couldn't reconnect within the configured timeout ("+e.disconnectTimeout+"ms), disconnecting."),e.stop(!1,!1)},e.reconnecting(function(){var e=this;e.state===i.connectionState.reconnecting&&(t=n.setTimeout(function(){o(e)},e.disconnectTimeout))}),e.stateChanged(function(e){e.oldState===i.connectionState.reconnecting&&n.clearTimeout(t)}),e._.configuredStopReconnectingTimeout=!0)};i=function(e,n,t){return new i.fn.init(e,n,t)},i._={defaultContentType:"application/x-www-form-urlencoded; charset=UTF-8",ieVersion:function(){var e,t;return"Microsoft Internet Explorer"===n.navigator.appName&&(t=/MSIE ([0-9]+\.[0-9]+)/.exec(n.navigator.userAgent),t&&(e=n.parseFloat(t[1]))),e}()},i.events=l,i.changeState=d,i.isDisconnecting=p,i.connectionState={connecting:0,connected:1,reconnecting:2,disconnected:4},i.hub={start:function(){throw new Error("SignalR: Error loading hubs. Ensure your hubs reference is correct, e.g. <script src='/signalr/hubs'></script>.")}},s.on("load",function(){a=!0}),i.fn=i.prototype={init:function(e,n,t){this.url=e,this.qs=n,this._={pollTimeoutId:null,reconnectTimeoutId:null},"boolean"==typeof t&&(this.logging=t)},isCrossDomain:function(t,o){var i;return t=e.trim(t),0!==t.indexOf("http")?!1:(o=o||n.location,i=n.document.createElement("a"),i.href=t,i.protocol+r(i.protocol,i.host)!==o.protocol+r(o.protocol,o.host))},ajaxDataType:"json",contentType:"application/json; charset=UTF-8",logging:!1,state:i.connectionState.disconnected,keepAliveData:{},reconnectDelay:2e3,disconnectTimeout:3e4,keepAliveWarnAt:2/3,start:function(o,r){var c,u=this,p={waitForPageLoad:!0,transport:"auto",jsonp:!1},f=u._deferral||e.Deferred(),v=n.document.createElement("a");if("function"===e.type(o)?r=o:"object"===e.type(o)&&(e.extend(p,o),"function"===e.type(p.callback)&&(r=p.callback)),p.transport=t(p.transport,u),!p.transport)throw new Error("SignalR: Invalid transport(s) specified, aborting start.");if(!a&&p.waitForPageLoad===!0)return s.on("load",function(){u._deferral=f,u.start(o,r)}),f.promise();if(g(u),d(u,i.connectionState.disconnected,i.connectionState.connecting)===!1)return f.resolve(u),f.promise();v.href=u.url,v.protocol&&":"!==v.protocol?(u.protocol=v.protocol,u.host=v.host,u.baseUrl=v.protocol+"//"+v.host):(u.protocol=n.document.location.protocol,u.host=n.document.location.host,u.baseUrl=u.protocol+"//"+u.host),u.wsProtocol="https:"===u.protocol?"wss://":"ws://","auto"===p.transport&&p.jsonp===!0&&(p.transport="longPolling"),this.isCrossDomain(u.url)&&(u.log("Auto detected cross domain url."),"auto"===p.transport&&(p.transport=["webSockets","longPolling"]),p.jsonp||(p.jsonp=!e.support.cors,p.jsonp&&u.log("Using jsonp because this browser doesn't support CORS")),u.contentType=i._.defaultContentType),u.ajaxDataType=p.jsonp?"jsonp":"json",e(u).bind(l.onStart,function(n,t){"function"===e.type(r)&&r.call(u),f.resolve(u)}),c=function(n,t){if(t=t||0,t>=n.length)return void(u.transport||(e(u).triggerHandler(l.onError,["SignalR: No transport could be initialized successfully. Try specifying a different transport or none at all for auto initialization."]),f.reject("SignalR: No transport could be initialized successfully. Try specifying a different transport or none at all for auto initialization."),u.stop()));var o=n[t],r="object"===e.type(o)?o:i.transports[o];return 0===o.indexOf("_")?void c(n,t+1):void r.start(u,function(){r.supportsKeepAlive&&u.keepAliveData.activated&&i.transports._logic.monitorKeepAlive(u),u.transport=r,d(u,i.connectionState.connecting,i.connectionState.connected),e(u).triggerHandler(l.onStart),s.on("unload",function(){u.stop(!1)})},function(){c(n,t+1)})};var m=u.url+"/negotiate";return m=i.transports._logic.addQs(m,u),u.log("Negotiating with '"+m+"'."),e.ajax({url:m,global:!1,cache:!1,type:"GET",contentType:u.contentType,data:{},dataType:u.ajaxDataType,error:function(n){e(u).triggerHandler(l.onError,[n.responseText]),f.reject("SignalR: Error during negotiation request: "+n.responseText),u.stop()},success:function(n){var t=u.keepAliveData;if(u.appRelativeUrl=n.Url,u.id=n.ConnectionId,u.token=n.ConnectionToken,u.webSocketServerUrl=n.WebSocketServerUrl,u.disconnectTimeout=1e3*n.DisconnectTimeout,n.KeepAliveTimeout?(t.activated=!0,t.timeout=1e3*n.KeepAliveTimeout,t.timeoutWarning=t.timeout*u.keepAliveWarnAt,t.checkInterval=(t.timeout-t.timeoutWarning)/3):t.activated=!1,!n.ProtocolVersion||"1.2"!==n.ProtocolVersion)return e(u).triggerHandler(l.onError,["You are using a version of the client that isn't compatible with the server. Client version 1.2, server version "+n.ProtocolVersion+"."]),void f.reject("You are using a version of the client that isn't compatible with the server. Client version 1.2, server version "+n.ProtocolVersion+".");e(u).triggerHandler(l.onStarting);var o=[],r=[];e.each(i.transports,function(e){return"webSockets"!==e||n.TryWebSockets?void r.push(e):!0}),e.isArray(p.transport)?e.each(p.transport,function(){var n=this;("object"===e.type(n)||"string"===e.type(n)&&e.inArray(""+n,r)>=0)&&o.push("string"===e.type(n)?""+n:n)}):"object"===e.type(p.transport)||e.inArray(p.transport,r)>=0?o.push(p.transport):o=r,c(o)}}),f.promise()},starting:function(n){var t=this;return e(t).bind(l.onStarting,function(e,o){n.call(t)}),t},send:function(e){var n=this;if(n.state===i.connectionState.disconnected)throw new Error("SignalR: Connection must be started before data can be sent. Call .start() before .send()");if(n.state===i.connectionState.connecting)throw new Error("SignalR: Connection has not been fully initialized. Use .start().done() or .start().fail() to run logic after the connection has started.");return n.transport.send(n,e),n},received:function(n){var t=this;return e(t).bind(l.onReceived,function(e,o){n.call(t,o)}),t},stateChanged:function(n){var t=this;return e(t).bind(l.onStateChanged,function(e,o){n.call(t,o)}),t},error:function(n){var t=this;return e(t).bind(l.onError,function(e,o){n.call(t,o)}),t},disconnected:function(n){var t=this;return e(t).bind(l.onDisconnect,function(e,o){n.call(t)}),t},connectionSlow:function(n){var t=this;return e(t).bind(l.onConnectionSlow,function(e,o){n.call(t)}),t},reconnecting:function(n){var t=this;return e(t).bind(l.onReconnecting,function(e,o){n.call(t)}),t},reconnected:function(n){var t=this;return e(t).bind(l.onReconnect,function(e,o){n.call(t)}),t},stop:function(n,t){var o=this;if(o.state!==i.connectionState.disconnected){try{o.transport&&(t!==!1&&o.transport.abort(o,n),o.transport.supportsKeepAlive&&o.keepAliveData.activated&&i.transports._logic.stopMonitoringKeepAlive(o),o.transport.stop(o),o.transport=null),e(o).triggerHandler(l.onDisconnect),delete o.messageId,delete o.groupsToken,delete o.id,delete o._deferral}finally{d(o,o.state,i.connectionState.disconnected)}return o}},log:function(e){u(e,this.logging)}},i.fn.init.prototype=i.fn,i.noConflict=function(){return e.connection===i&&(e.connection=c),i},e.connection&&(c=e.connection),e.connection=e.signalR=i}(window.jQuery,window),function(e,n){"use strict";function t(o){var c,a,s=o.keepAliveData;o.state===r.connectionState.connected&&(c=new Date,c.setTime(c-s.lastKeepAlive),a=c.getTime(),a>=s.timeout?(o.log("Keep alive timed out.  Notifying transport that connection has been lost."),o.transport.lostConnection(o)):a>=s.timeoutWarning?s.userNotified||(o.log("Keep alive has been missed, connection may be dead/slow."),e(o).triggerHandler(i.onConnectionSlow),s.userNotified=!0):s.userNotified=!1),s.monitoring&&n.setTimeout(function(){t(o)},s.checkInterval)}function o(e){return e.state===r.connectionState.connected||e.state===r.connectionState.reconnecting}var r=e.signalR,i=e.signalR.events,c=e.signalR.changeState;r.transports={},r.transports._logic={pingServer:function(n,t){var o="webSockets"===t?"":n.baseUrl,r=o+n.appRelativeUrl+"/ping",i=e.Deferred();return r=this.addQs(r,n),e.ajax({url:r,global:!1,cache:!1,type:"GET",contentType:n.contentType,data:{},dataType:n.ajaxDataType,success:function(e){"pong"===e.Response?i.resolve():i.reject("SignalR: Invalid ping response when pinging server: "+(e.responseText||e.statusText))},error:function(e){i.reject("SignalR: Error pinging server: "+(e.responseText||e.statusText))}}),i.promise()},addQs:function(n,t){var o,r=-1!==n.indexOf("?")?"&":"?";if(!t.qs)return n;if("object"==typeof t.qs)return n+r+e.param(t.qs);if("string"==typeof t.qs)return o=t.qs.charAt(0),("?"===o||"&"===o)&&(r=""),n+r+t.qs;throw new Error("Connections query string property must be either a string or object.")},getUrl:function(e,t,o,r){var i="webSockets"===t?"":e.baseUrl,c=i+e.appRelativeUrl,a="transport="+t+"&connectionToken="+n.encodeURIComponent(e.token);return e.data&&(a+="&connectionData="+n.encodeURIComponent(e.data)),e.groupsToken&&(a+="&groupsToken="+n.encodeURIComponent(e.groupsToken)),o?(c+=r?"/poll":"/reconnect",e.messageId&&(a+="&messageId="+n.encodeURIComponent(e.messageId))):c+="/connect",c+="?"+a,c=this.addQs(c,e),c+="&tid="+Math.floor(11*Math.random())},maximizePersistentResponse:function(e){return{MessageId:e.C,Messages:e.M,Disconnect:"undefined"!=typeof e.D?!0:!1,TimedOut:"undefined"!=typeof e.T?!0:!1,LongPollDelay:e.L,GroupsToken:e.G}},updateGroups:function(e,n){n&&(e.groupsToken=n)},ajaxSend:function(t,o){var c=t.url+"/send?transport="+t.transport.name+"&connectionToken="+n.encodeURIComponent(t.token);return c=this.addQs(c,t),e.ajax({url:c,global:!1,type:"jsonp"===t.ajaxDataType?"GET":"POST",contentType:r._.defaultContentType,dataType:t.ajaxDataType,data:{data:o},success:function(n){n&&e(t).triggerHandler(i.onReceived,[n])},error:function(n,r){"abort"!==r&&"parsererror"!==r&&e(t).triggerHandler(i.onError,[n,o])}})},ajaxAbort:function(t,o){if("undefined"!=typeof t.transport){o="undefined"==typeof o?!0:o;var r=t.url+"/abort?transport="+t.transport.name+"&connectionToken="+n.encodeURIComponent(t.token);r=this.addQs(r,t),e.ajax({url:r,async:o,timeout:1e3,global:!1,type:"POST",contentType:t.contentType,dataType:t.ajaxDataType,data:{}}),t.log("Fired ajax abort async = "+o)}},processMessages:function(n,t){var o;if(n.transport){var r=e(n);if(n.transport.supportsKeepAlive&&n.keepAliveData.activated&&this.updateKeepAlive(n),!t)return;if(o=this.maximizePersistentResponse(t),o.Disconnect)return n.log("Disconnect command received from server"),void n.stop(!1,!1);this.updateGroups(n,o.GroupsToken),o.Messages&&e.each(o.Messages,function(e,n){r.triggerHandler(i.onReceived,[n])}),o.MessageId&&(n.messageId=o.MessageId)}},monitorKeepAlive:function(n){var o=n.keepAliveData,r=this;o.monitoring?n.log("Tried to monitor keep alive but it's already being monitored"):(o.monitoring=!0,r.updateKeepAlive(n),n.keepAliveData.reconnectKeepAliveUpdate=function(){r.updateKeepAlive(n)},e(n).bind(i.onReconnect,n.keepAliveData.reconnectKeepAliveUpdate),n.log("Now monitoring keep alive with a warning timeout of "+o.timeoutWarning+" and a connection lost timeout of "+o.timeout),t(n))},stopMonitoringKeepAlive:function(n){var t=n.keepAliveData;t.monitoring&&(t.monitoring=!1,e(n).unbind(i.onReconnect,n.keepAliveData.reconnectKeepAliveUpdate),n.keepAliveData={},n.log("Stopping the monitoring of the keep alive"))},updateKeepAlive:function(e){e.keepAliveData.lastKeepAlive=new Date},ensureReconnectingState:function(n){return c(n,r.connectionState.connected,r.connectionState.reconnecting)===!0&&e(n).triggerHandler(i.onReconnecting),n.state===r.connectionState.reconnecting},clearReconnectTimeout:function(e){e&&e._.reconnectTimeout&&(n.clearTimeout(e._.reconnectTimeout),delete e._.reconnectTimeout)},reconnect:function(e,t){var i=r.transports[t],c=this;o(e)&&!e._.reconnectTimeout&&(e._.reconnectTimeout=n.setTimeout(function(){i.stop(e),c.ensureReconnectingState(e)&&(e.log(t+" reconnecting"),i.start(e))},e.reconnectDelay))},foreverFrame:{count:0,connections:{}}}}(window.jQuery,window),function(e,n){"use strict";var t=e.signalR,o=e.signalR.events,r=e.signalR.changeState,i=t.transports._logic;t.transports.webSockets={name:"webSockets",supportsKeepAlive:!0,send:function(e,n){e.socket.send(n)},start:function(c,a,s){var l,u=!1,d=this,p=!a,g=e(c);return n.WebSocket?void(c.socket||(l=c.webSocketServerUrl?c.webSocketServerUrl:c.wsProtocol+c.host,l+=i.getUrl(c,this.name,p),c.log("Connecting to websocket endpoint '"+l+"'"),c.socket=new n.WebSocket(l),c.socket.onopen=function(){u=!0,c.log("Websocket opened"),i.clearReconnectTimeout(c),a?a():r(c,t.connectionState.reconnecting,t.connectionState.connected)===!0&&g.triggerHandler(o.onReconnect)},c.socket.onclose=function(n){if(this===c.socket){if(!u)return void(s?s():p&&d.reconnect(c));"undefined"!=typeof n.wasClean&&n.wasClean===!1?(e(c).triggerHandler(o.onError,[n.reason]),c.log("Unclean disconnect from websocket."+n.reason)):c.log("Websocket closed"),d.reconnect(c)}},c.socket.onmessage=function(t){var r=n.JSON.parse(t.data),a=e(c);r&&(e.isEmptyObject(r)||r.M?i.processMessages(c,r):a.triggerHandler(o.onReceived,[r]))})):void s()},reconnect:function(e){i.reconnect(e,this.name)},lostConnection:function(e){this.reconnect(e)},stop:function(e){i.clearReconnectTimeout(e),null!==e.socket&&(e.log("Closing the Websocket"),e.socket.close(),e.socket=null)},abort:function(e){}}}(window.jQuery,window),function(e,n){"use strict";var t=e.signalR,o=e.signalR.events,r=e.signalR.changeState,i=t.transports._logic;t.transports.serverSentEvents={name:"serverSentEvents",supportsKeepAlive:!0,timeOut:3e3,start:function(c,a,s){var l,u,d=this,p=!1,g=e(c),f=!a;if(c.eventSource&&(c.log("The connection already has an event source. Stopping it."),c.stop()),!n.EventSource)return void(s&&(c.log("This browser doesn't support SSE."),s()));l=i.getUrl(c,this.name,f);try{c.log("Attempting to connect to SSE endpoint '"+l+"'"),c.eventSource=new n.EventSource(l)}catch(v){return c.log("EventSource failed trying to connect with error "+v.Message),void(s?s():(g.triggerHandler(o.onError,[v]),f&&d.reconnect(c)))}u=n.setTimeout(function(){p===!1&&c.eventSource&&(c.log("EventSource timed out trying to connect"),c.log("EventSource readyState: "+c.eventSource.readyState),f||d.stop(c),f?c.eventSource.readyState!==n.EventSource.CONNECTING&&c.eventSource.readyState!==n.EventSource.OPEN&&d.reconnect(c):s&&s())},d.timeOut),c.eventSource.addEventListener("open",function(e){c.log("EventSource connected"),u&&n.clearTimeout(u),i.clearReconnectTimeout(c),p===!1&&(p=!0,a?a():r(c,t.connectionState.reconnecting,t.connectionState.connected)===!0&&g.triggerHandler(o.onReconnect))},!1),c.eventSource.addEventListener("message",function(e){"initialized"!==e.data&&i.processMessages(c,n.JSON.parse(e.data))},!1),c.eventSource.addEventListener("error",function(e){if(this===c.eventSource){if(!p)return void(s&&s());c.log("EventSource readyState: "+c.eventSource.readyState),e.eventPhase===n.EventSource.CLOSED?(c.log("EventSource reconnecting due to the server connection ending"),d.reconnect(c)):(c.log("EventSource error"),g.triggerHandler(o.onError))}},!1)},reconnect:function(e){i.reconnect(e,this.name)},lostConnection:function(e){this.reconnect(e)},send:function(e,n){i.ajaxSend(e,n)},stop:function(e){i.clearReconnectTimeout(e),e&&e.eventSource&&(e.log("EventSource calling close()"),e.eventSource.close(),e.eventSource=null,delete e.eventSource)},abort:function(e,n){i.ajaxAbort(e,n)}}}(window.jQuery,window),function(e,n){"use strict";var t=e.signalR,o=e.signalR.events,r=e.signalR.changeState,i=t.transports._logic,c=function(){var o=null,r=1e3,i=0;return{prevent:function(){t._.ieVersion<=8&&(0===i&&(o=n.setInterval(function(){var n=e("<iframe style='position:absolute;top:0;left:0;width:0;height:0;visibility:hidden;' src=''></iframe>");e("body").append(n),n.remove(),n=null},r)),i++)},cancel:function(){1===i&&n.clearInterval(o),i>0&&i--}}}();t.transports.foreverFrame={name:"foreverFrame",supportsKeepAlive:!0,timeOut:3e3,start:function(t,o,r){var a,s=this,l=i.foreverFrame.count+=1,u=e("<iframe data-signalr-connection-id='"+t.id+"' style='position:absolute;top:0;left:0;width:0;height:0;visibility:hidden;' src=''></iframe>");return n.EventSource?void(r&&(t.log("This browser supports SSE, skipping Forever Frame."),r())):(c.prevent(),a=i.getUrl(t,this.name),a+="&frameId="+l,e("body").append(u),u.prop("src",a),i.foreverFrame.connections[l]=t,t.log("Binding to iframe's readystatechange event."),u.bind("readystatechange",function(){e.inArray(this.readyState,["loaded","complete"])>=0&&(t.log("Forever frame iframe readyState changed to "+this.readyState+", reconnecting"),s.reconnect(t))}),t.frame=u[0],t.frameId=l,o&&(t.onSuccess=o),void n.setTimeout(function(){t.onSuccess&&(t.log("Failed to connect using forever frame source, it timed out after "+s.timeOut+"ms."),s.stop(t),r&&r())},s.timeOut))},reconnect:function(e){var t=this;n.setTimeout(function(){if(e.frame&&i.ensureReconnectingState(e)){var n=e.frame,o=i.getUrl(e,t.name,!0)+"&frameId="+e.frameId;e.log("Updating iframe src to '"+o+"'."),n.src=o}},e.reconnectDelay)},lostConnection:function(e){this.reconnect(e)},send:function(e,n){i.ajaxSend(e,n)},receive:function(n,t){var o;i.processMessages(n,t),n.frameMessageCount=(n.frameMessageCount||0)+1,n.frameMessageCount>50&&(n.frameMessageCount=0,o=n.frame.contentWindow||n.frame.contentDocument,o&&o.document&&e("body",o.document).empty())},stop:function(n){var t=null;if(c.cancel(),n.frame){if(n.frame.stop)n.frame.stop();else try{t=n.frame.contentWindow||n.frame.contentDocument,t.document&&t.document.execCommand&&t.document.execCommand("Stop")}catch(o){n.log("SignalR: Error occured when stopping foreverFrame transport. Message = "+o.message)}e(n.frame).remove(),delete i.foreverFrame.connections[n.frameId],n.frame=null,n.frameId=null,delete n.frame,delete n.frameId,n.log("Stopping forever frame")}},abort:function(e,n){i.ajaxAbort(e,n)},getConnection:function(e){return i.foreverFrame.connections[e]},started:function(n){n.onSuccess?(n.onSuccess(),n.onSuccess=null,delete n.onSuccess):r(n,t.connectionState.reconnecting,t.connectionState.connected)===!0&&e(n).triggerHandler(o.onReconnect)}}}(window.jQuery,window),function(e,n){"use strict";var t=e.signalR,o=e.signalR.events,r=e.signalR.changeState,i=e.signalR.isDisconnecting,c=t.transports._logic;t.transports.longPolling={name:"longPolling",supportsKeepAlive:!1,reconnectDelay:3e3,init:function(e,t){var o,r=this,a=function(t){i(e)===!1&&(e.log("SignalR: Server ping failed because '"+t+"', re-trying ping."),n.setTimeout(o,r.reconnectDelay))};e.log("SignalR: Initializing long polling connection with server."),(o=function(){c.pingServer(e,r.name).done(t).fail(a)})()},start:function(a,s,l){var u=this,d=!1,p=function(){d||(d=!0,s(),a.log("Longpolling connected"))},g=a._,f=0,v=function(i){n.clearTimeout(g.reconnectTimeoutId),g.reconnectTimeoutId=null,r(a,t.connectionState.reconnecting,t.connectionState.connected)===!0&&(a.log("Raising the reconnect event"),e(i).triggerHandler(o.onReconnect))},m=36e5;a.pollXhr&&(a.log("Polling xhr requests already exists, aborting."),a.stop()),g.reconnectTimeoutId=null,g.pollTimeoutId=null,u.init(a,function(){a.messageId=null,g.pollTimeoutId=n.setTimeout(function(){!function r(s,l){var d=s.messageId,h=null===d,S=!h,b=!l,y=c.getUrl(s,u.name,S,b);i(s)!==!0&&(a.log("Attempting to connect to '"+y+"' using longPolling."),s.pollXhr=e.ajax({url:y,global:!1,cache:!1,type:"GET",dataType:a.ajaxDataType,contentType:a.contentType,success:function(t){var o,a=0;f=0,null!==g.reconnectTimeoutId&&v(),p(),t&&(o=c.maximizePersistentResponse(t)),c.processMessages(s,t),o&&"number"===e.type(o.LongPollDelay)&&(a=o.LongPollDelay),o&&o.Disconnect||i(s)!==!0&&(a>0?g.pollTimeoutId=n.setTimeout(function(){r(s,!1)},a):r(s,!1))},error:function(i,l){return n.clearTimeout(g.reconnectTimeoutId),g.reconnectTimeoutId=null,"abort"===l?void a.log("Aborted xhr requst."):(f++,a.state!==t.connectionState.reconnecting&&(a.log("An error occurred using longPolling. Status = "+l+". "+i.responseText),e(s).triggerHandler(o.onError,[i.responseText])),void(c.ensureReconnectingState(s)&&(g.pollTimeoutId=n.setTimeout(function(){u.init(s,function(){r(s,!0)})},u.reconnectDelay))))}}),S&&l===!0&&(g.reconnectTimeoutId=n.setTimeout(function(){v(s)},Math.min(1e3*(Math.pow(2,f)-1),m))))}(a),n.setTimeout(function(){p()},250)},250)})},lostConnection:function(e){throw new Error("Lost Connection not handled for LongPolling")},send:function(e,n){c.ajaxSend(e,n)},stop:function(e){n.clearTimeout(e._.pollTimeoutId),n.clearTimeout(e._.reconnectTimeoutId),delete e._.pollTimeoutId,delete e._.reconnectTimeoutId,e.pollXhr&&(e.pollXhr.abort(),e.pollXhr=null,delete e.pollXhr)},abort:function(e,n){c.ajaxAbort(e,n)}}}(window.jQuery,window),function(e,n){"use strict";function t(e){return e+l}function o(e,n,t){var o,r=e.length,i=[];for(o=0;r>o;o+=1)e.hasOwnProperty(o)&&(i[o]=n.call(t,e[o],o,e));return i}function r(n){return e.isFunction(n)?null:"undefined"===e.type(n)?null:n}function i(e){for(var n in e)if(e.hasOwnProperty(n))return!0;return!1}function c(e,n){var t,o=e._.invocationCallbacks;e.log("Clearing hub invocation callbacks with error: "+n),e._.invocationCallbackId=0,delete e._.invocationCallbacks,e._.invocationCallbacks={};for(var r in o)t=o[r],t.method.call(t.scope,{E:n})}function a(e,n){return new a.fn.init(e,n)}function s(n,t){var o={qs:null,logging:!1,useDefaultPath:!0};return e.extend(o,t),(!n||o.useDefaultPath)&&(n=(n||"")+"/signalr"),new s.fn.init(n,o)}var l=".hubProxy";a.fn=a.prototype={init:function(e,n){this.state={},this.connection=e,this.hubName=n,this._={callbackMap:{}}},hasSubscriptions:function(){return i(this._.callbackMap)},on:function(n,o){var r=this,i=r._.callbackMap;return n=n.toLowerCase(),i[n]||(i[n]={}),i[n][o]=function(e,n){o.apply(r,n)},e(r).bind(t(n),i[n][o]),r},off:function(n,o){var r,c=this,a=c._.callbackMap;return n=n.toLowerCase(),r=a[n],r&&(r[o]?(e(c).unbind(t(n),r[o]),delete r[o],i(r)||delete a[n]):o||(e(c).unbind(t(n)),delete a[n])),c},invoke:function(t){var i=this,c=i.connection,a=e.makeArray(arguments).slice(1),s=o(a,r),l={H:i.hubName,M:t,A:s,I:c._.invocationCallbackId},u=e.Deferred(),d=function(n){var t=i._maximizeHubResponse(n);e.extend(i.state,t.State),t.Error?(t.StackTrace&&c.log(t.Error+"\n"+t.StackTrace),u.rejectWith(i,[t.Error])):u.resolveWith(i,[t.Result])};return c._.invocationCallbacks[c._.invocationCallbackId.toString()]={scope:i,method:d},c._.invocationCallbackId+=1,e.isEmptyObject(i.state)||(l.S=i.state),c.send(n.JSON.stringify(l)),u.promise()},_maximizeHubResponse:function(e){return{State:e.S,Result:e.R,Id:e.I,Error:e.E,StackTrace:e.T}}},a.fn.init.prototype=a.fn,s.fn=s.prototype=e.connection(),s.fn.init=function(o,r){var i={qs:null,logging:!1,useDefaultPath:!0},a=this;e.extend(i,r),e.signalR.fn.init.call(a,o,i.qs,i.logging),a.proxies={},a._.invocationCallbackId=0,a._.invocationCallbacks={},a.received(function(n){var o,r,i,c,s,l;n&&("undefined"!=typeof n.I?(i=n.I.toString(),c=a._.invocationCallbacks[i],c&&(a._.invocationCallbacks[i]=null,delete a._.invocationCallbacks[i],c.method.call(c.scope,n))):(o=this._maximizeClientHubInvocation(n),a.log("Triggering client hub event '"+o.Method+"' on hub '"+o.Hub+"'."),s=o.Hub.toLowerCase(),l=o.Method.toLowerCase(),r=this.proxies[s],e.extend(r.state,o.State),e(r).triggerHandler(t(l),[o.Args])))}),a.error(function(e,t){var o,r,i;if((!a.transport||"webSockets"!==a.transport.name)&&t){try{if(o=n.JSON.parse(t),!o.I)return}catch(c){return}r=o.I,i=a._.invocationCallbacks[r],i.method.call(i.scope,{E:e}),a._.invocationCallbacks[r]=null,delete a._.invocationCallbacks[r]}}),a.reconnecting(function(){a.transport&&"webSockets"===a.transport.name&&c(a,"Connection started reconnecting before invocation result was received.")}),a.disconnected(function(){c(a,"Connection was disconnected before invocation result was received.")})},s.fn._maximizeClientHubInvocation=function(e){return{Hub:e.H,Method:e.M,Args:e.A,State:e.S}},s.fn._registerSubscribedHubs=function(){this._subscribedToHubs||(this._subscribedToHubs=!0,this.starting(function(){var t=[];e.each(this.proxies,function(e){this.hasSubscriptions()&&t.push({name:e})}),this.data=n.JSON.stringify(t)}))},s.fn.createHubProxy=function(e){e=e.toLowerCase();var n=this.proxies[e];return n||(n=a(this,e),this.proxies[e]=n),this._registerSubscribedHubs(),n},s.fn.init.prototype=s.fn,e.hubConnection=s}(window.jQuery,window),function(e){e.signalR.version="1.1.4"}(window.jQuery);