/*!
*  filename: ej.chart.min.js
*  version : 17.4.0.39
*  Copyright Syncfusion Inc. 2001 - 2019. All rights reserved.
*  Use of this code is subject to the terms of our license.
*  A copy of the current license can be obtained at any time by e-mailing
*  licensing@syncfusion.com. Any infringement will be prosecuted under
*  applicable laws. 
*/
(function(n){typeof define=="function"&&define.amd?define(["./../common/ej.globalize.min","./../common/ej.core.min","./../common/ej.data.min","./../common/ej.scroller.min"],n):n()})(function(){ej.Ej3DRender=function(){},function(n){var r;ej.Ej3DRender.Polygons=[];ej.Ej3DRender.prototype={matrix3D:function(){},vector3D:function(){},BSPTreeBuilder:function(){},Graphics3D:function(){},polygon3D:function(){}};r=new ej.Ej3DRender;r.vector3D.prototype={x:"",y:"",z:"",Epsilon:1e-5,isValid:function(n){return!isNaN(n.x)&&!isNaN(n.y)&&!isNaN(n.z)},vector3D:function(n,t){this.x=n.x;this.y=n.y;this.z=t},vector3D:function(n,t,i){return this.x=n,this.y=t,this.z=i,{x:n,y:t,z:i}},vector3DMinus:function(n,t){return this.vector3D(n.x-t.x,n.y-t.y,n.z-t.z)},vector3DPlus:function(n,t){return this.vector3D(n.x+t.x,n.y+t.y,n.z+t.z)},vector3DMultiply:function(n,t){var i=n.y*t.z-t.y*n.z,r=n.z*t.x-t.z*n.x,u=n.x*t.y-t.x*n.y;return this.vector3D(i,r,u)},vector3dAND:function(n,t){return n.x*t.x+n.y*t.y+n.z*t.z},vector3DStarMultiply:function(n,t){var i=n.x*t,r=n.y*t,u=n.z*t;return this.vector3D(i,r,u)},getLength:function(n){var t=this.vector3dAND(n,n);return Math.sqrt(t)},normalize:function(){var n=this.getLength(),t,i,r;t/=n;i/=n;r/=n},getNormal:function(n,t,i){var f=this.vector3DMinus(n,t),e=this.vector3DMinus(i,t),u=this.vector3DMultiply(f,e),r=this.getLength(u);return r<this.Epsilon&&(r=0),{x:u.x/r,y:u.y/r,z:u.z/r}}};r.matrix3D.prototype={MATRIX_SIZE:4,matrix3D:function(n){for(var i=[],t=0;t<n;t++)i[t]=this.createArray(n);return i},isAffine:function(n){return n[0][3]==0&&n[1][3]==0&&n[2][3]==0&&n[3][3]==1},createArray:function(n){for(var i=[],t=0;t<n;++t)i[t]=0;return i},getIdentity:function(){for(var t=this.matrix3D(this.MATRIX_SIZE),n=0;n<this.MATRIX_SIZE;n++)t[n][n]=1;return t},getInvertal:function(n){for(var t,i=this.getIdentity(),r=0;r<this.MATRIX_SIZE;r++)for(t=0;t<this.MATRIX_SIZE;t++)i[r][t]=this.getMinor(n,r,t);return i=this.transposed(i),this.getMatrixMultiple(1/this.getDeterminant(n),i)},getMatrixMultiple:function(n,t){for(var r,i=0;i<t.length;i++)for(r=0;r<t[i].length;r++)t[i][r]=t[i][r]*n;return t},getMatrixVectorMutiple:function(n,t){var r=n[0][0]*t.x+n[1][0]*t.y+n[2][0]*t.z+n[3][0],u=n[0][1]*t.x+n[1][1]*t.y+n[2][1]*t.z+n[3][1],f=n[0][2]*t.x+n[1][2]*t.y+n[2][2]*t.z+n[3][2],i;return this.isAffine(n)||(i=1/(n[0][3]*t.x+n[1][3]*t.y+n[2][3]*t.z+n[3][3]),r*=i,u*=i,f*=i),{x:r,y:u,z:f}},getMatrixVectorAnd:function(n,t){var i=n[0][0]*t.x+n[1][0]*t.y+n[2][0]*t.z,u=n[0][1]*t.x+n[1][1]*t.y+n[2][1]*t.z,f=n[0][2]*t.x+n[1][2]*t.y+n[2][2]*t.z;return r.vector3D.prototype.vector3D(i,u,f)},getMatrixAdd:function(n,t){for(var i,u=this.matrix3D(4),r=0;r<4;r++)for(i=0;i<4;i++)u[r][i]=n[r][i]+t[r][i];return u},getMatrixMultiplication:function(n,t){for(var i,f,r,o,e=this.getIdentity(),u=0;u<this.MATRIX_SIZE;u++)for(i=0;i<this.MATRIX_SIZE;i++){for(f=0,r=0;r<this.MATRIX_SIZE;r++)f+=n[r][i]*t[u][r],o=f;e[u][i]=f}return e},getMatrixEqual:function(n,t){for(var i,u=!0,r=0;r<n.length;r++)for(i=0;i<n.length;i++)n[r][i]!=t[r][i]&&(u=!1);return u},getMatrixNotEqual:function(n,t){for(var i,u=!0,r=0;r<n.length;r++)for(i=0;i<n.length;i++)n[r][i]!=t[r][i]&&(u=!1);return!u},getMinor:function(n,t,i){return((t+i)%2==0?1:-1)*this.getDeterminant(this.getMMtr(n,t,i))},getMMtr:function(n,t,i){for(var o,u,s,f=n.length-1,e=this.createArray(f),r=0;r<f;r++)for(o=r>=t?r+1:r,e[r]=this.createArray(f),u=0;u<f;u++)s=u>=i?u+1:u,e[r][u]=n[o][s];return e},getDeterminant:function(n){var u=n.length,r=0,i,t,f;if(u<2)r=n[0][0];else for(i=1,t=0;t<u;t++)f=this.getMMtr(n,t,0),r+=i*n[t][0]*this.getDeterminant(f),i=i>0?-1:1;return r},transform:function(n,t,i){var r=this.getIdentity();return r[3][0]=n,r[3][1]=t,r[3][2]=i,r},turn:function(n){var t=this.getIdentity();return t[0][0]=Math.cos(n),t[2][0]=-Math.sin(n),t[0][2]=Math.sin(n),t[2][2]=Math.cos(n),t},tilt:function(n){var t=this.getIdentity();return t[1][1]=Math.cos(n),t[2][1]=Math.sin(n),t[1][2]=-Math.sin(n),t[2][2]=Math.cos(n),t},transposed:function(n){for(var t,r=this.getIdentity(),i=0;i<this.MATRIX_SIZE;i++)for(t=0;t<this.MATRIX_SIZE;t++)r[i][t]=n[t][i];return r},shear:function(n,t,i,r,u,f){var e=this.getIdentity();return e[0]=n,e[0]=t,e[1]=i,e[1]=r,e[2]=u,e[2]=f,e}};r.Graphics3D.prototype={addVisual:function(n){return n==null||f.test(n)?-1:(n.Graphics3D=this,e.add(n))},getVisualCount:function(){return ej.Ej3DRender.Polygons.length()},remove:function(n){ej.Ej3DRender.Polygons.Remove(n)},clearVisual:function(){ej.Ej3DRender.Polygons=null},getVisual:function(){return ej.Ej3DRender.Polygons},prepareView:function(n,t,i,r,u,f){arguments.length==0?e.build():(ej.Ej3DRender.transform==null?ej.Ej3DRender.transform=ej.EjSvgRender.chartTransform3D.transform3D(u):ej.Ej3DRender.transform.mViewport=u,ej.Ej3DRender.tree||(ej.Ej3DRender.tree=[]),ej.Ej3DRender.transform.Rotation=i,ej.Ej3DRender.transform.Tilt=r,ej.Ej3DRender.transform.Depth=t,ej.Ej3DRender.transform.PerspectiveAngle=n,ej.EjSvgRender.chartTransform3D.transform(ej.Ej3DRender.transform),ej.Ej3DRender.tree[f._id]=e.build())},view:function(n,i,r,u,f,e,o){var h=32767,s;if(arguments.length==2){if(n==null)return;s=t.vector3D(0,0,h);this.drawBspNode3D(ej.Ej3DRender.tree[i._id],s,n,i)}else{if(n==null)return;ej.Ej3DRender.transform==null?ej.Ej3DRender.transform=ej.EjSvgRender.chartTransform3D.transform3D(f):ej.Ej3DRender.transform.mViewport=f;ej.Ej3DRender.transform.Rotation=r;ej.Ej3DRender.transform.Tilt=u;ej.Ej3DRender.transform.Depth=o;ej.Ej3DRender.transform.PerspectiveAngle=e;ej.EjSvgRender.chartTransform3D.transform(ej.Ej3DRender.transform);s=t.vector3D(0,0,h);this.drawBspNode3D(ej.Ej3DRender.tree[i._id],s,n,i)}},draw3DElement:function(n,t){n.Plane.element?n.Plane.element.tag=="text"||n.Plane.element.tag=="dataLabel"?f.drawText(n.Plane,t):n.Plane.element.tag=="polyline"?f.drawPolyLine(n.Plane,t):n.Plane.element.tag=="template"?f.drawTemplate(n.Plane,t):f.drawLine(n.Plane,t):f.draw(n.Plane,t)},drawBspNode3D:function(n,i,r,u){if(n!=null&&ej.Ej3DRender.transform!=null)for(;;){var e=t.vector3dAND(f.getNormal(ej.EjSvgRender.chartTransform3D.result(ej.Ej3DRender.transform),n.Plane.VectorPoints),i);if(e>n.Plane.D){if(n.Front!=null&&this.drawBspNode3D(n.Front,i,r,u),this.draw3DElement(n,u),n.Back!=null){n=n.Back;continue}}else if(n.Back!=null&&this.drawBspNode3D(n.Back,i,r,u),this.draw3DElement(n,u),n.Front!=null){n=n.Front;continue}break}}};r.BSPTreeBuilder.prototype={EPSILON:.0005,Polygon:[],add:function(n){return ej.Ej3DRender.Polygons.push(n),ej.Ej3DRender.Polygons.length-1},remove:function(n){ej.Ej3DRender.Polygons.splice(n,1)},clear:function(){ej.Ej3DRender.Polygons=[]},count:function(){return ej.Ej3DRender.Polygons.length},getNext:function(n,t){return n>=t?n-t:n<0?n+t:n},getNodeCount:function(n){return n==null?0:1+this.getNodeCount(n.Back)+this.getNodeCount(n.Front)},vector3DIndexClassification:function(n,t,i){return{index:t,result:i,vector:n,isCuttingBackPoint:!1,cuttingBackPairIndex:null,alreadyCuttedBack:!1,isCuttingFrontPoint:!1,cuttingFrontPairIndex:null,alreadyCuttedFront:!1}},classifyPoint:function(n,t){var i="OnPlane",u=-t.D-r.vector3D.prototype.vector3dAND(n,t.normal);return u>this.EPSILON?i="OnBack":u<-this.EPSILON&&(i="OnFront"),i},classifyPolygon:function(n,t){var i=t.Points,f,h,s;if(i==null)return"Unknown";var e=0,o=0,u=0,c=n.normal,l=n.D;for(f=0,h=i.length;f<h;f++)if(s=-l-r.vector3D.prototype.vector3dAND(i[f],c),s>this.EPSILON?e++:s<-this.EPSILON?o++:u++,e>0&&o>0)break;return u==i.length?"OnPlane":o+u==i.length?"ToRight":e+u==i.length?"ToLeft":"Unknown"},splitPolygon:function(i,r){var w=[],b=[],rt,v,e,k,ut,u,o,ft;if(i.Points!=null){var l=[],s=[],h=[],k,d,g=i.Points.length;for(u=0;u<g;u++){var nt=i.Points[u],y=i.Points[this.getNext(u+1,g)],p=this.classifyPoint(nt,r),a=this.classifyPoint(y,r),c=this.vector3DIndexClassification(nt,l.length,p);if(l.push(c),p!=a&&p!="OnPlane"&&a!="OnPlane"){var it=t.vector3DMinus(nt,y),et=t.vector3DMinus(t.vector3DStarMultiply(r.normal,-r.D),y),ot=t.vector3dAND(et,r.normal),st=ot/t.vector3dAND(r.normal,it),ht=t.vector3DPlus(y,t.vector3DStarMultiply(it,st)),tt=this.vector3DIndexClassification(ht,l.length,"OnPlane");l.push(tt);s.push(tt);h.push(tt)}else if(p=="OnPlane"){if(rt=i.Points[this.getNext(u-1,g)],v=this.classifyPoint(rt,r),v==a)continue;if(v!="OnPlane"&&a!="OnPlane")s.push(c),h.push(c);else if(v=="OnPlane")switch(a){case"OnBack":s.push(c);break;case"OnFront":h.push(c)}else if(a=="OnPlane")switch(v){case"OnBack":s.push(c);break;case"OnFront":h.push(c)}}}if(h.length!=0||s.length!=0){for(u=0;u<s.length-1;u+=2)e=s[u],o=s[u+1],e.CuttingBackPoint=!0,o.CuttingBackPoint=!0,e.CuttingBackPairIndex=o.index,o.CuttingBackPairIndex=e.index;for(u=0;u<h.length-1;u+=2)e=h[u],o=h[u+1],e.CuttingFrontPoint=!0,o.CuttingFrontPoint=!0,e.CuttingFrontPairIndex=o.index,o.CuttingFrontPairIndex=e.index;for(u=0;u<s.length-1;u++)(e=s[u],e.alreadyCuttedBack)||(k=this.cutOutBackPolygon(l,e),k.length>2&&(ut=f.polygon3D(k,i),w.push(n.extend({},ut))));for(u=0;u<h.length-1;u++)(o=h[u],o.alreadyCuttedFront)||(d=this.cutOutFrontPolygon(l,o),d.length>2&&(ft=f.polygon3D(d,i),b.push(n.extend({},ft))))}}else w.push(i),b.push(i);return{BackP:w,FrontP:b}},cutOutFrontPolygon:function(n,t){for(var r=[],i=t,s,u,f,e,o;;)if(i.alreadyCuttedFront=!0,r.push(i.vector),s=n[i.CuttingFrontPairIndex],i.CuttingFrontPoint)if(s.alreadyCuttedFront)if(u=n[this.getNext(i.index-1,n.length)],f=n[this.getNext(i.index+1,n.length)],u.result!="OnFront"||u.alreadyCuttedFront){if(f.result!="OnFront"||f.alreadyCuttedFront)return r;i=f}else i=u;else i=s;else if(e=n[this.getNext(i.index-1,n.length)],o=n[this.getNext(i.index+1,n.length)],e.result=="OnBack"||e.alreadyCuttedFront){if(o.result=="OnBack"||o.alreadyCuttedFront)return r;i=o}else i=e;return r},cutOutBackPolygon:function(n,t){for(var f=[],i=t,e,r,u;;)if(i.alreadyCuttedBack=!0,f.push(i.vector),e=n[i.CuttingBackPairIndex],i.CuttingBackPoint)if(e.alreadyCuttedBack)if(r=n[this.getNext(i.index-1,n.length)],u=n[this.getNext(i.index+1,n.length)],r.result!="OnBack"||r.alreadyCuttedBack){if(u.result!="OnBack"||u.alreadyCuttedBack)return f;i=u}else i=r;else i=e;else if(r=n[this.getNext(i.index-1,n.length)],u=n[this.getNext(i.index+1,n.length)],r.result=="OnFront"||r.alreadyCuttedBack){if(u.result=="OnFront"||u.alreadyCuttedBack)return f;i=u}else i=r;return f},build:function(){var f,e,o,i,s,h,c,n,l,t,r,u;if(arguments[0]){if(f=arguments[0],f.length<1)return null;for(e={Back:null,Front:null,Plane:null},o=f[0],e.Plane=o,i=[],s=[],h=1,c=f.length;h<c;h++)if(n=f[h],n!=o){l=this.classifyPolygon(o,n);switch(l){case"OnPlane":case"ToRight":s.push(n);break;case"ToLeft":i.push(n);break;case"Unknown":if(n.element&&(n.element.tag=="line"||n.element.tag=="text"))i.push(n);else{for(t=this.splitPolygon(n,o),r=0;r<t.BackP.length;r++)t.BackP[r].Name=t.BackP[r].Name+"back",i.push(t.BackP[r]);for(u=0;u<t.FrontP.length;u++)t.FrontP[u].Name=t.FrontP[u].Name+"front",s.push(t.FrontP[u])}}}return i.length>0&&(e.Back=this.build(i)),s.length>0&&(e.Front=this.build(s)),e}return this.build(ej.Ej3DRender.Polygons)}};r.polygon3D.prototype={epsilon:1e-5,normal:{x:0,y:0,z:0},vector:new(new ej.Ej3DRender).vector3D,polygon3D:function(n,t,i,r,u,f,e,o){var h,s;if(arguments.length==3)this.calcNormal(arguments[0],arguments[1],arguments[2]);else return arguments.length==2?(n=arguments[0],this.calcNormal(n[0],n[1],n[2]),this.vectorPoints=n,this.calcNormal(this.vectorPoints),s=arguments[1],s.Normal=this.normal,s.normal=this.normal,s.Points=n,s.VectorPoints=this.vectorPoints,s.IsSplitted=!0,s.d=this.d,s.D=this.d,s):(this.calcNormal(n[0],n[1],n[2]),this.vectorPoints=n,this.calcNormal(this.vectorPoints),h={Tag:"path",Parent:arguments[arguments.length-1]},s={Normal:this.normal,normal:this.normal,Points:n,VectorPoints:this.vectorPoints,Index:i,Tag:t,Name:o?o:null,StrokeThickness:u,Opacity:f,Fill:e,d:this.d,D:this.d},arguments.length!=1&&(s.Element=h),s)},createLine:function(n,i,r,u,f,e){var s=n.width,o=[];return o[0]=t.vector3D(i,r,e),o[1]=t.vector3D(i+s,f+s,e),o[2]=t.vector3D(u,f,e),this.line3D(n,o)},createPolyline:function(n,i){if(n.length==2){var r=n[1];n.push(t.vector3D(r.x,r.y,r.z))}return this.polyLine3D(i,n)},polyLine3D:function(n,t){var i=this.polygon3D(t);return i.element=n,i},line3D:function(n,t){var i=this.polygon3D(t);return i.element=n,i},text3D:function(n,t){var i=this.polygon3D(t);return i.element=n,i},createCylinder:function(n,r,u,f,e,o,s,h,c,l,a,v){var y=0,rt,ut,k,d,b=24,g=360/b,nt=Math.PI/180,ft=parseFloat((n.z+r.z)/2),w=[],p=[],tt=[],it=[],et=r.y-n.y<r.z-n.z?parseFloat((r.y-n.y)/2):parseFloat((r.z-n.z)/2),ot=r.x-n.x<r.z-n.z?parseFloat((r.x-n.x)/2):parseFloat((r.z-n.z)/2),st=parseFloat((n.x+r.x)/2),ht=parseFloat((n.y+r.y)/2),e=e.toLowerCase();switch(e){case"bar":case"stackingbar":case"stackingbar100":for(b++;b--;)ut=parseFloat(ht+et*Math.cos(y*g*nt)),k=parseFloat(ft+et*Math.sin(y*g*nt)),p[y]={Y:ut,Z:k},tt.push(t.vector3D(n.x,p[y].Y,p[y].Z)),it.push(t.vector3D(r.x,p[y].Y,p[y].Z)),y>0&&(d=[t.vector3D(n.x,p[y-1].Y,p[y-1].Z),t.vector3D(r.x,p[y-1].Y,p[y-1].Z),t.vector3D(r.x,p[y].Y,p[y].Z),t.vector3D(n.x,p[y].Y,p[y].Z)],w[y+1]=this.polygon3D(d,u,f,s,0,c,s,"_"+(y+1).toString()+"_"+a,v),i.addVisual(w[y+1])),y++;break;case"column":case"stackingcolumn":case"stackingcolumn100":for(b++;b--;)rt=parseFloat(st+ot*Math.cos(y*g*nt)),k=parseFloat(ft+ot*Math.sin(y*g*nt)),p[y]={X:rt,Z:k},tt.push(t.vector3D(p[y].X,n.y,p[y].Z)),it.push(t.vector3D(p[y].X,r.y,p[y].Z)),y>0&&(d=[t.vector3D(p[y-1].X,n.y,p[y-1].Z),t.vector3D(p[y-1].X,r.y,p[y-1].Z),t.vector3D(p[y].X,r.y,p[y].Z),t.vector3D(p[y].X,n.y,p[y].Z)],w[y+1]=this.polygon3D(d,u,f,s,0,c,s,"_"+(y+1).toString()+"_"+a,v),i.addVisual(w[y+1])),y++}return w[0]=this.polygon3D(it,u,f,o,0,c,s,"_0_"+a,v),w[1]=this.polygon3D(tt,u,f,o,h,c,s,"_1_"+a,v),i.addVisual(w[0]),i.addVisual(w[1]),w},createBox:function(n,r,u,f,e,o,s,h,c,l,a,v){var y=[],p=[t.vector3D(n.x,n.y,n.z),t.vector3D(r.x,n.y,n.z),t.vector3D(r.x,r.y,n.z),t.vector3D(n.x,r.y,n.z)],w=[t.vector3D(n.x,n.y,r.z),t.vector3D(r.x,n.y,r.z),t.vector3D(r.x,r.y,r.z),t.vector3D(n.x,r.y,r.z)],b=[t.vector3D(n.x,n.y,r.z),t.vector3D(r.x,n.y,r.z),t.vector3D(r.x,n.y,n.z),t.vector3D(n.x,n.y,n.z)],k=[t.vector3D(n.x,r.y,r.z),t.vector3D(r.x,r.y,r.z),t.vector3D(r.x,r.y,n.z),t.vector3D(n.x,r.y,n.z)],d=[t.vector3D(n.x,n.y,n.z),t.vector3D(n.x,n.y,r.z),t.vector3D(n.x,r.y,r.z),t.vector3D(n.x,r.y,n.z)],g=[t.vector3D(r.x,n.y,n.z),t.vector3D(r.x,n.y,r.z),t.vector3D(r.x,r.y,r.z),t.vector3D(r.x,r.y,n.z)],v;return arguments[10]?(y[0]=this.polygon3D(p,u,f,o,h,c,s,"_0_"+a,v),y[1]=this.polygon3D(w,u,f,o,h,c,s,"_1_"+a,v),y[2]=this.polygon3D(b,u,f,o,h,c,s,"_2_"+a,v),y[3]=this.polygon3D(k,u,f,o,h,c,s,"_3_"+a,v),y[4]=this.polygon3D(d,u,f,o,h,c,s,"_4_"+a,v),y[5]=this.polygon3D(g,u,f,o,h,c,s,"_5_"+a,v)):(v=arguments[arguments.length-1],y[0]=this.polygon3D(p,u,f,o,h,c,s,"_0_"+f,v),y[1]=this.polygon3D(w,u,f,o,h,c,s,"_1_"+f,v),y[2]=this.polygon3D(b,u,f,o,h,c,s,"_2_"+f,v),y[3]=this.polygon3D(k,u,f,o,h,c,s,"_3_"+f,v),y[4]=this.polygon3D(d,u,f,o,h,c,s,"_4_"+f,v),y[5]=this.polygon3D(g,u,f,o,h,c,s,"_5_"+f,v)),l?(i.addVisual(y[0]),i.addVisual(y[1]),i.addVisual(y[2]),i.addVisual(y[3]),i.addVisual(y[4]),i.addVisual(y[5])):(i.addVisual(y[5]),i.addVisual(y[4]),i.addVisual(y[0]),i.addVisual(y[1]),i.addVisual(y[2]),i.addVisual(y[3])),y},calcNormal:function(){var n,r;if(arguments.length>=3){var u=arguments[0],e=arguments[1],o=arguments[2],s=t.vector3DMinus(u,e),h=t.vector3DMinus(o,e),f=t.vector3DMultiply(s,h),i=t.getLength(f);i<this.epsilon&&(i=1);this.normal=t.vector3D(f.x/i,f.y/i,f.z/i);this.d=-(this.normal.x*u.x+this.normal.y*u.y+this.normal.z*u.z);arguments[3]&&(arguments[3].normal=this.normal,arguments.d=this.d)}else for(n=arguments[0],this.calcNormal(n[0],n[1],n[2],arguments[1]),r=3;r<n.length&&this.test();r++)this.calcNormal(n[r],n[0],n[r/2])},test:function(){return!t.isValid(this.normal)},transform:function(n,i){var r,f;if(i.Points!=null){for(r=0;r<i.Points.length;r++)i.VectorPoints[r]=i.Points[r]=u.getMatrixVectorMutiple(n,i.Points[r]);this.calcNormal(i.VectorPoints,i)}else f=n*i.normal*-i.d,i.normal=u.getMatrixVectorAnd(n,i.normal),t.normalize(),i.d=-(i.normal&f)},getPoint:function(n,i,r,u){var f;if(typeof n=="number")return f=-(r.x*n+r.y*i+u)/r.z,t.vector3D(n,i,f);var e=n,o=i,s=t.vector3DMinus(t.vector3DStarMultiply(r,-u),e),h=t.vector3dAND(s,r),c=h/t.vector3dAND(r,o);return t.vector3DPlus(e,t.vector3DStarMultiply(o*c))},getNormal:function(n,i){var f,r;if(i!=null)for(f=t.getNormal(u.getMatrixVectorMutiple(n,i[0]),u.getMatrixVectorMutiple(n,i[1]),u.getMatrixVectorMutiple(n,i[2])),r=3;r<i.length&&!t.isValid(f)&&i[r/2];r++){var e=u.getMatrixVectorMutiple(n,i[r]),o=u.getMatrixVectorMutiple(n,i[0]),s=u.getMatrixVectorMutiple(n,i[r/2]);f=t.getNormal(e,o,s)}else f=u.getMatrixVectorAnd(n),t.normalize();return f},createTextElement:function(n,t,i,r){var u=[],f=n.x,e=n.y,o=t.Width,s=t.Height;return u[0]=this.vector.vector3D(f,e,n.z),u[1]=this.vector.vector3D(f+o,e+s+r,n.z),u[2]=this.vector.vector3D(f+o+i,e+s+r,n.z),this.text3D(t,u)},redraw:function(){},drawPolyLine:function(n,t){var e=ej.Ej3DRender.transform,u=ej.EjSvgRender.utils._getStringBuilder(),o=ej.EjSvgRender.chartTransform3D.toScreen(n.VectorPoints[0],e),i,f,s,r;for(u.append("M "+o.x+" "+o.y+" "),i=0;i<n.VectorPoints.length;i++)f=ej.EjSvgRender.chartTransform3D.toScreen(n.VectorPoints[i],e),u.append("L "+f.x+" "+f.y+" ");s=u.toString();r={id:n.element.id,"stroke-dasharray":n.element.dashArray,"stroke-width":n.element.width,stroke:n.element.stroke,d:s};r.id=r.id.replace(/[^a-zA-Z0-9]/g,"");t.svgRenderer.drawPath(r,n.element.child)},drawLine:function(n,t){var i=ej.Ej3DRender.transform;if(i!=null){var u=ej.EjSvgRender.chartTransform3D.toScreen(n.VectorPoints[0],i),f=ej.EjSvgRender.chartTransform3D.toScreen(n.VectorPoints[2],i),r={id:n.element.id,x1:u.x,y1:u.y,x2:f.x,y2:f.y,"stroke-dasharray":n.element.dashArray,"stroke-width":n.element.width,stroke:n.element.stroke,opacity:n.element.opacity};r.id=r.id.replace(/[^a-zA-Z0-9]/g,"");t.svgRenderer.drawLine(r,n.element.child)}},drawTemplate:function(n,t){var i=n.element,u=ej.Ej3DRender.transform,r;u!=null&&(r=ej.EjSvgRender.chartTransform3D.toScreen(n.VectorPoints[0],u),ej.EjSeriesRender.prototype.drawLabelTemplate(i.Label.series,i.Label.series.points[i.Label.pointIndex],i.Label.pointIndex,{X:r.x,Y:r.y},t))},drawText:function(t,i){var r=t.element,o=ej.Ej3DRender.transform,c,w;if(o!=null){var e=ej.EjSvgRender.chartTransform3D.toScreen(t.VectorPoints[0],o),s=e.x,h=e.y;if(r.tag=="text")c={id:r.id,x:s,y:h,fill:r.font.color,"font-size":r.font.size,"font-family":r.font.fontFamily,"font-style":r.font.fontStyle,"font-weight":r.font.fontWeight,opacity:r.font.opacity,"text-anchor":r.TextAnchor,cursor:"default",transform:r.Angle?"rotate("+r.Angle+","+s+","+h+")":null},i.svgRenderer.drawText(c,t.element.Label.Text,t.element.child,t.element.font);else{var u=r.series,l=u.yAxis&&u.yAxis.labelFormat?u.yAxis.labelFormat:"",b=r.point.text?r.point.text:r.point.y+l.substring(l.indexOf("}")+1),a=ej.EjSvgRender.utils._measureText(b,null,u.marker.dataLabel.font),f=u.marker.dataLabel.margin,k=a.width+f.left+f.right,v=a.height+f.top+f.bottom,y={X:e.x,Y:e.y},p;w=u.marker.dataLabel.shape?u.marker.dataLabel.shape:u.marker.dataLabel.shape?u.marker.dataLabel.shape:"None";n.each(i.model.symbolShape,function(n){w.toLowerCase()==n.toLowerCase()&&(p=n)});var d=y.X-f.left/2+f.right/2,g=y.Y-f.top/2-v/f.top+f.bottom/2,nt=n.inArray(u,i.model.series);ej.EjSeriesRender.prototype.dataLabelSymbol(nt,u,r.pointIndex,d,g,k,v,p,i)}}},draw:function(i,r){var o,s,a,h;if(i.VectorPoints!=null&&!(i.VectorPoints.length<=0)){var c=ej.Ej3DRender.transform,l=ej.EjSvgRender.utils._getStringBuilder(),u=i.Fill,y=r.svgRenderer.checkColorFormat(u);if(y||(u=r.colorNameToHex(u)),o={Segments:null,StartPoint:null},c!=null)for(o.StartPoint=ej.EjSvgRender.chartTransform3D.toScreen(i.VectorPoints[0],c),l.append("M "+o.StartPoint.x+" "+o.StartPoint.y+" "),s=0;s<i.VectorPoints.length;s++)a=ej.EjSvgRender.chartTransform3D.toScreen(i.VectorPoints[s],c),l.append("L "+a.x+" "+a.y+" ");var p=l.toString(),f="Light",e=2*(Math.abs(t.vector3dAND(i.normal,t.vector3D(0,0,1)))-1),v=2*(Math.abs(t.vector3dAND(i.normal,t.vector3D(0,1,0)))-1),w=2*(Math.abs(t.vector3dAND(i.normal,t.vector3D(1,0,0)))-1);e==w?(f="ZLight",u=this.applyZLight(u,r)):v==e||e!=0&&v<e?(f="XLight",u=this.applyXLight(u,r)):e<0?(f="ZLight",u=this.applyZLight(u,r)):(f="Light",u=u);r.model.AreaType=="none"&&(i.StrokeThickness=0);h={id:r.svgObject.id+"_"+i.Name,name:f,fill:u,stroke:i.Stroke,"stroke-width":i.StrokeThickness,opacity:i.Opacity,d:p};r.svgRenderer.drawPath(h,i.Element.Parent);r.model.previousID&&r.model.touchCross&&n("#"+h.id).insertAfter(n("#"+r.model.previousID));r.model.previousID=h.id}},applyXLight:function(n,t){var i=t.svgRenderer.hexToRGB(n);return i.R=parseInt(i.R*.7),i.G=parseInt(i.G*.7),i.B=parseInt(i.B*.7),t.svgRenderer.hexFromRGB(i)},applyZLight:function(n,t){var i=t.svgRenderer.hexToRGB(n);return i.R=parseInt(i.R*.9),i.G=parseInt(i.G*.9),i.B=parseInt(i.B*.9),t.svgRenderer.hexFromRGB(i)},update:function(t,i,r){var u,s,h,c;if(i.VectorPoints!=null&&!(i.VectorPoints.length<=0)){i.VectorPoints=t;var f=ej.Ej3DRender.transform,e=ej.EjSvgRender.utils._getStringBuilder(),l=i.Fill,o={Segments:null,StartPoint:null};if(f!=null)for(o.StartPoint=ej.EjSvgRender.chartTransform3D.toScreen(i.VectorPoints[0],f),e.append("M "+o.StartPoint.x+" "+o.StartPoint.y+" "),u=0;u<i.VectorPoints.length;u++)s=ej.EjSvgRender.chartTransform3D.toScreen(i.VectorPoints[u],f),e.append("L "+s.x+" "+s.y+" ");h=e.toString();n(r.chartObj.chart3D).find("#"+r.chartObj.svgObject.id+"_"+i.Name).length>0&&(c=n(r.chartObj.chart3D).find("#"+r.chartObj.svgObject.id+"_"+i.Name)[0],r.chartObj.svgRenderer._setAttr(n(c),{d:h}))}}};var r=new ej.Ej3DRender,t=new r.vector3D,u=new r.matrix3D,e=new r.BSPTreeBuilder,f=new r.polygon3D,i=new r.Graphics3D}(jQuery);ej.Ej3DAxisRenderer=function(){};ej.Ej3DSeriesRender=function(){};ej.Ej3DChart=function(){};ej.series3DTypes={},function(n){ej.Ej3DAxisRenderer.prototype={_drawAxes:function(n,t,i){t.majorGridLines.visible&&this._drawGridLines3D(t,i);t.visible&&t.majorTickLines.visible&&this._renderTicks3D(t,t.majorTickLines.size,t.majorTickLines.width,i);t.visible&&(this._drawAxisLabel(t,i),this._drawMultiLevelLabel(n,t,i),this._drawAxisTitle(t))},_drawAxisTitle:function(t){var i,tt,a,v,e,u,o,s;if(t.title.visible){i=t.title.font;this.gAxisTitleEle=this.svgRenderer.createGroup({id:this.svgObject.id+"axisTitle_"+t.name});var h=t._opposed,b={Width:n(this.svgObject).width(),Height:n(this.svgObject).height()},k=10,f=ej.EjSvgRender.chartTransform3D.transform3D(b);f.mViewport=b;f.Rotation=0;f.Tilt=0;f.Depth=100;f.PerspectiveAngle=90;ej.EjSvgRender.chartTransform3D.transform(f);var d=ej.EjSvgRender.chartTransform3D.result,g=ej.Ej3DRender.prototype.matrix3D.prototype,nt=t.orientation.toLowerCase(),y=!1,c,l;for(a=0;a<this.model._axes.length;a++)if(c=this.model._axes[a],c.orientation.toLowerCase()==nt)for(v=0;v<c.multiLevelLabels.length;v++)if(c.multiLevelLabels[v].visible){y=!0;break}if(nt=="horizontal"){var it=this.model.elementSpacing+t._LableMaxWidth.height,p=ej.EjSvgRender.utils._measureText(t.title.text,t.width,t.title.font).height/2,r=n.extend({},ej.EjSvgRender.commonChartEventArgs);r.data={Text:t.title.text,location:{x:t.width/2,y:it+p+t.majorTickLines.size+t.axisLine.width+this.model.wallSize+t._multiLevelLabelHeight},axes:t};this._trigger("axesTitleRendering",r);i=t.title.font;e=r.data.location.x+t.x;u=h?t.y-r.data.location.y:r.data.location.y+t.y;l={Width:p.width,Height:p.height,Label:r.data,TextAnchor:"middle",tag:"text",font:i,id:this.svgObject.id+"axisTitle",child:this.chart3D};y?(o={id:this.svgObject.id+"axisTitle",x:e,y:u,fill:i.color,"font-size":i.size,"font-family":i.fontFamily,"font-style":i.fontStyle,"font-weight":i.fontWeight,opacity:i.opacity,"text-anchor":"middle"},s=ej.EjSvgRender.chartTransform3D.toScreen({x:e,y:u,z:0},f,d,g),o.x=s.x,o.y=s.y,this.svgRenderer.drawText(o,r.data.Text,this.gAxisTitleEle),this.svgRenderer.append(this.gAxisTitleEle,this.svgObject)):this.graphics.addVisual(this.polygon.createTextElement(this.vector.vector3D(e,u,0),l,10,10))}else{var w=ej.EjSvgRender.utils._measureText(t.title.text,t.height,t.title.font),e=h?t.x+(4*this.model.elementSpacing+t._LableMaxWidth.width+t.majorTickLines.size+t.axisLine.width+this.model.wallSize+t._multiLevelLabelHeight):t.x-(3*this.model.elementSpacing+t._LableMaxWidth.width+t.majorTickLines.size+t.axisLine.width+this.model.wallSize+t._multiLevelLabelHeight),r=n.extend({},ej.EjSvgRender.commonChartEventArgs);r.data={Text:t.title.text,location:{x:w.width/2,y:0},axes:t};this._trigger("axesTitleRendering",r);i=t.title.font;var u=r.data.location.y+(t.y+t.height)+t.height/-2,ut=h?90:-90,rt=h?25:-25;l={Width:w.width,Height:w.height,Angle:-90,Label:r.data,TextAnchor:"middle",tag:"text",font:i,id:this.svgObject.id+"_YAxisTitle",child:this.chart3D};y?(o={id:tt,x:e,y:u,fill:i.color,"font-size":i.size,"font-family":i.fontFamily,"font-style":i.fontStyle,"font-weight":i.fontWeight,opacity:i.opacity,"text-anchor":"middle",transform:"rotate(-90,"+e+","+(h?u+k:u-k)+")"},s=ej.EjSvgRender.chartTransform3D.toScreen({x:e,y:u,z:0},f,d,g),o.x=s.x+rt,o.y=s.y,this.svgRenderer.drawText(o,r.data.Text,this.gAxisTitleEle),this.svgRenderer.append(this.gAxisTitleEle,this.svgObject)):this.graphics.addVisual(this.polygon.createTextElement(this.vector.vector3D(e,u,0),l,10,10))}}},_drawMultiLevelLabel:function(t,i,r){var vt,yt,rt,g,y,dt,pt,st,wi,wt,bi;this.gMultiLevelEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_axisMultiLevelLabels_"+t});var rt,w,ut,e,b,c,hi,ft,o,s,k,ci=0,ki,li,di=i.multiLevelLabels.length,bt=this.model,kt=bt.elementSpacing,f=10,u=0,h=0,ai,l,et,ii,ri,ui,y,dt,ct,a,lt,nt,fi,tt=bt.m_AreaBounds,d,ot=i.visibleRange,ei,gt=bt.wallSize,it=i._opposed,vi=r.axes[i.name]._validCross,oi,at=i.orientation.toLowerCase(),yi=vi?i.y:tt.Y+(!it&&tt.Height),si,gi=vi?i.x:tt.X+(it&&tt.Width),v,st,ni=[],ti,ht,pi={Width:n(this.svgObject).width(),Height:n(this.svgObject).height()},p=ej.EjSvgRender.chartTransform3D.transform3D(pi);for(p.mViewport=pi,p.Rotation=0,p.Tilt=0,p.Depth=100,p.PerspectiveAngle=bt.perspectiveAngle,ej.EjSvgRender.chartTransform3D.transform(p),vt=ej.EjSvgRender.chartTransform3D.result,yt=ej.Ej3DRender.prototype.matrix3D.prototype,rt=0;rt<di;rt++)if(e=i.multiLevelLabels[rt],b=this.svgObject.id+"_"+i.name+"MultiLevelLabels_"+t+"_"+rt,e.text!=""&&e.visible){if(l=e._level,et="middle",c=e.font,ht=e.border.width,ct=e.maximumTextWidth,si=e.textAlignment.toLowerCase(),dt=y=e.text,k=e.textOverflow.toLowerCase(),d=ej.EjSvgRender.utils._measureText(e.text,tt.Width,e.font),hi=(e.end-e.start)/2,ft=(e.start+hi-ot.min)/ot.delta,o=(e.start-ot.min)/ot.delta,s=(e.end-ot.min)/ot.delta,i.isInversed&&(ft=isNaN(ft)?0:1-ft,o=isNaN(o)?0:1-o,s=isNaN(s)?0:1-s),at=="horizontal"?(u=Math.round(i.width*ft)+tt.X+i.plotOffset,h=it?yi-gt-i.majorTickLines.size-kt-f/2-i._LableMaxWidth.height:yi+gt+i.majorTickLines.size+kt+i._LableMaxWidth.height,o=Math.round(i.width*o)+tt.X+i.plotOffset,s=Math.round(i.width*s)+tt.X+i.plotOffset,ut=ct?ct:s-o-f):(h=Math.round(i.plotOffset+i.y+i.height*(1-ft)),u=it?i.x+gt+i.majorTickLines.size+i.axisLine.width+kt/2+i._LableMaxWidth.width+i.prevHeight[l]+i.multiLevelLabelHeight[l]/2:gi-gt-i.majorTickLines.size-kt/2-i._LableMaxWidth.width-i.prevHeight[l]-i.multiLevelLabelHeight[l]/2,o=Math.round(i.plotOffset+i.y+i.height*(1-o)),s=Math.round(i.plotOffset+i.y+i.height*(1-s)),ut=ct?ct:i.multiLevelLabelHeight[l]+f),at=="horizontal"&&(h=it?h-i.prevHeight[l]:h+i.prevHeight[l]),si=="far"?(u=u+ut/2-ht/2,et="end"):si=="near"&&(et="start",u=u-ut/2+ht/2),g=ej.EjAxisRenderer.prototype._triggerMultiLevelLabelsRendering(dt,u,h,k,c,e.border,this),y=dt=g.text,u=g.location.x,h=g.location.y,k=g.textOverflow.toLowerCase(),c=g.font,c.color=c.color?c.color:i.multiLevelLabelsFontColor,ki=g.border,li=g.border.type.toLowerCase(),ht=g.border.width,v={id:b,x:u,y:h,fill:c.color,"font-size":c.size,"font-family":c.fontFamily,"font-style":c.fontStyle,"font-weight":c.fontWeight,opacity:c.opacity,"text-anchor":et},k!="none"&&(y=ej.EjAxisRenderer.prototype.textOverflowMultiLevelLabels(i,ut,y,dt,k,c,d,{x:u,y:h},null,this)),k=="wrap"||k=="wrapandtrim")for(pt=h,w=0;w<y.length;w++)d=ej.EjSvgRender.utils._measureText(y[w],null,c),w!=0&&(pt=it?pt-d.height:pt+d.height),ai={Width:d.width,Height:d.height,Label:{Text:y[w]},TextAnchor:et,tag:"text",font:c,id:b+"_"+w,child:this.chart3D},v.id=v.id+"_"+w,st=ej.EjSvgRender.chartTransform3D.toScreen({x:u,y:pt+f/2,z:0},p,vt,yt),v.x=st.x,v.y=st.y,this.svgRenderer.drawText(v,y[w],this.gMultiLevelEle);if(u=at=="horizontal"?u:it?u+f:u-f,k!="wrap"&&k!="wrapandtrim"&&(ai={Width:d.width,Height:d.height,Label:{Text:y},TextAnchor:et,tag:"text",font:c,id:b,child:this.chart3D},st=ej.EjSvgRender.chartTransform3D.toScreen({x:u,y:h+f/2,z:0},p,vt,yt),v.x=st.x,v.y=st.y,this.svgRenderer.drawText(v,y,this.gMultiLevelEle)),wi=at=="horizontal"?{bounds:{x:o,y:h-f,height:i.multiLevelLabelHeight[l],width:ut},axisIndex:t,multiLevelLabel:e}:{bounds:{x:u-a/2-f/2,y:s,height:o-s,width:a},axisIndex:t,multiLevelLabel:e},this.model.multiLevelLabelRegions.push(wi),li!="none"&&ht>0){for(b=this.svgObject.id+"_"+i.name+"MultiLevelLabelsBorder_"+t+"_"+rt,wt=h-f+i.multiLevelLabelHeight[l]+f/2,bi=e.border.color?e.border.color:i.multiLevelLabelsColor,at=="horizontal"?(ii={x1:o,y1:h-f,x2:s,y2:h-f},ri={x1:o,y1:wt,x2:s,y2:wt},ui={x1:o,y1:h-f,x2:o,y2:wt},fi={x1:s,y1:h-f,x2:s,y2:wt}):(a=i.multiLevelLabelHeight[l]-f/2,ii={x1:u-a/2-f/2,y1:s,x2:u+a/2+f/2,y2:s},ri={x1:u-a/2-f/2,y1:o,x2:u+a/2+f/2,y2:o},ui={x1:u-a/2-f/2,y1:s,x2:u-a/2-f/2,y2:o},fi={x1:u+a/2+f/2,y1:s,x2:u+a/2+f/2,y2:o}),ti=0;ti<4;ti++){switch(ti){case 0:lt=b+"_top";nt=ii;break;case 1:lt=b+"_bottom";nt=ri;break;case 2:lt=b+"_left";nt=ui;break;case 3:lt=b+"_right";nt=fi}ni[0]=ej.Ej3DRender.prototype.vector3D.prototype.vector3D(nt.x1,nt.y1,ci);ni[1]=ej.Ej3DRender.prototype.vector3D.prototype.vector3D(nt.x2,nt.y2,ci);ei=ej.EjSvgRender.chartTransform3D.toScreen(ni[0],p,vt,yt);oi=ej.EjSvgRender.chartTransform3D.toScreen(ni[1],p,vt,yt);v={id:lt,x1:ei.x,y1:ei.y,x2:oi.x,y2:oi.y,stroke:bi,"stroke-width":ht};this.svgRenderer.drawLine(v,this.gMultiLevelEle)}this.svgRenderer.append(this.gMultiLevelEle,this.svgObject)}}},_textTrim:function(n,t,i){var e=t.length,f,u,o=ej.EjSvgRender.utils._measureText(t,this.model.m_AreaBounds.Width,i),r;if(o.width>n){for(r=e-1;r>=0;--r)if(u=t.substring(0,r)+"...",f=ej.EjSvgRender.utils._measureText(u,this.model.m_AreaBounds.Width,i),f.width<=n)return u}else return t},_textWrap:function(n,t,i){for(var o=t.toString().split(" "),r="",f=[],s=o.length,u="",e=0;e<s;e++)u=o[e],ej.EjSvgRender.utils._measureText(r.concat(u),this.model.m_AreaBounds.Width,i).width<n?r=r.concat((r===""?"":" ")+u):r!==""?(f.push(this._textTrim(n,r,i)),r=u):(f.push(this._textTrim(n,u,i)),u=""),r&&e===s-1&&f.push(this._textTrim(n,r,i));return f},_textWrapByLength:function(n,t,i){var u=0,e=[],f="",o,r;for(t=t.toString(),o=t.length,r=0;r<=o;r++)f=u==0?t.slice(u,r):"-"+t.slice(u,r),ej.EjSvgRender.utils._measureText(f,this.model.m_AreaBounds.Width,i).width>n-5?(e.push(f),u=r++):r===o&&e.push(f);return e},_multipleRows:function(n,t,i,r){for(var u,e,o,s=[],h,f=n-1;f>=0;f--)u=r.visibleLabels[f],o=ej.EjSvgRender.utils._measureText(u.Text,this.model.m_AreaBounds.Width,r.font),e=ej.EjSvgRender.utils._valueToCoefficient(r,f)*r.width+r.x,h=t<e+o.width/2,h?(u.index=u.index?u.index:0,s.push(u.index),i.index=i.index>u.index?i.index:u.index+1):i.index=s.indexOf(u.index)>-1?i.index:u.index},_drawAxisLabel:function(n,t){for(var w,e,f,v,r,y,o=[],l=null,g=n.visibleLabels.length,a=this.model.m_AreaBounds,c=n._opposed,b,k=t.axes[n.name]._validCross,d=k?n.y:a.Y+(!c&&a.Height),nt=k?n.x:a.X+(c&&a.Width),i=0;i<g;i++)if(!ej.util.isNullOrUndefined(n.visibleLabels[i].Text)){var s=0,u=0,tt=0,it=0,p,h;if(n.visibleLabels[i].originalText=n.visibleLabels[i].Text,e=ej.EjSvgRender.utils._measureText(n.visibleLabels[i].Text,this.model.m_AreaBounds.Width,n.font),f=(n.visibleLabels[i].Value-n.visibleRange.min)/n.visibleRange.delta,f=n.isInversed?1-f:f,f=isNaN(f)?0:f,n.orientation.toLowerCase()=="horizontal"?(tt=s=Math.round(n.width*f)+this.model.m_AreaBounds.X+n.plotOffset,u=c?d-this.model.wallSize-n.majorTickLines.size-this.model.elementSpacing/2:d+this.model.wallSize+n.majorTickLines.size+this.model.elementSpacing,w="middle"):(u=it=Math.round(n.plotOffset+n.y+e.height/4+n.height*(1-f)),s=c?n.x+n.majorTickLines.size+n.axisLine.width+this.model.elementSpacing/2:nt-this.model.wallSize-n.majorTickLines.size-this.model.elementSpacing/2,w=c?"start":"end"),o.push({x:s,y:u,size:e}),v=n.width/n.visibleLabels.length-5,r=o[i],(r.x-r.size.width/2<n.x&&i===0||r.x+r.size.width/2>n.x+n.width&&i===n.visibleLabels.length-1)&&n.labelIntersectAction!="trim"&&n.labelIntersectAction.indexOf("wrap")<0)if(n.edgeLabelPlacement==="hide")continue;else n.edgeLabelPlacement==="shift"&&(i==0?r.x=s=n.x+r.size.width/2:i==n.visibleLabels.length-1&&(r.x=s=n.x+n.width-r.size.width/2));if(n.orientation.toLowerCase()=="horizontal")if(n.labelRotation)l=n.labelRotation,y=ej.EjSvgRender.utils.rotatedLabel(n,this,n.labelRotation,n.visibleLabels[i].Text,!0),u+=y.height/2;else if(n.labelIntersectAction=="trim")n.visibleLabels[i].Text=this._textTrim(v,n.visibleLabels[i].Text,n.font);else if(n.labelIntersectAction=="wrapByWord")n.visibleLabels[i].Text=this._textWrap(v,n.visibleLabels[i].Text,n.font);else if(n.labelIntersectAction=="wrap")n.visibleLabels[i].Text=this._textWrapByLength(v,n.visibleLabels[i].Text,n.font);else if(n.labelIntersectAction=="rotate45"||n.labelIntersectAction=="rotate90")l=n.labelIntersectAction.indexOf("45")>-1?45:90,y=ej.EjSvgRender.utils.rotatedLabel(n,this,l,n.visibleLabels[i].Text,!0),u+=y.height/2;else if(n.labelIntersectAction==="multipleRows")p=r.x,p-=e.width/2,this._multipleRows(i,p,n.visibleLabels[i],n),u=n.visibleLabels[i].index?u+n.visibleLabels[i].index*(e.height+5):u;else if(n.labelIntersectAction==="hide"){if(h=h?h:0,i!=0&&o[h].x+o[h].size.width/2>=o[i].x-o[i].size.width/2)continue;h=i}b={Width:e.width,Height:e.height,Label:n.visibleLabels[i],TextAnchor:w,tag:"text",font:n.font,id:this.svgObject.id+n.orientation+i,child:this.chart3D,Angle:l};this.graphics.addVisual(this.polygon.createTextElement(this.vector.vector3D(s,u,0),b,10,10))}},_renderTicks3D:function(n,t,i,r){for(var s,f,o,y=n.visibleLabels.length,p,h=this.model.m_AreaBounds,w=n.y,e=0;e<y;e++){var c=0,l=0,a=0,v=0,u=(n.visibleLabels[e].Value-n.visibleRange.min)/n.visibleRange.delta;if(u=n.isInversed?1-u:u,u=isNaN(u)?0:u,n.orientation.toLowerCase()=="horizontal"?l=c=Math.round(n.width*u)+h.X+n.plotOffset:a=v=Math.round(n.plotOffset+n.height*(1-u)+n.y),f=this._calculatePosition3D(n,n.tickLinesPosition,t,i,c,a,l,v,r),o={width:n.majorTickLines.width,stroke:n.majorTickLines.color,child:this.chart3D,tag:"line"},o.id=this.svgObject.id+n.name+"_majorTickLines_"+e,this.graphics.addVisual(this.polygon.createLine(o,f.X1,f.Y1,f.X2,f.Y2,0)),n.minorGridLines.visible&&n.minorTicksPerInterval>0&&e<y-1)for(p=n.visibleRange.interval/(n.minorTicksPerInterval+1),s=0;s<n.minorTicksPerInterval;s++)u=ej.EjSvgRender.utils._valueToCoefficient(n,n.visibleLabels[e].Value+p*(s+1)),u=isNaN(u)?0:u,n.orientation.toLowerCase()=="horizontal"?c=l=Math.round(n.plotOffset+h.Width*u+h.X):a=v=Math.round(n.plotOffset+h.Height*(1-u))+n.y,f=this._calculatePosition3D(n,n.tickLinesPosition,t,i,c,a,l,v,r),o={width:n.minorTickLines.width,stroke:n.minorTickLines.color,child:this.chart3D,tag:"line"},o.id=this.svgObject.id+n.name+"_minorTickLines_"+e+s,this.graphics.addVisual(this.polygon.createLine(o,f.X1,f.Y1,f.X2,f.Y2,0))}},_calculatePosition3D:function(n,t,i,r,u,f,e,o,s){var w=n.orientation,h=n._opposed,t="outside",c=this.model.m_AreaBounds,v=s.axes[n.name]._validCross,y=v?n.y:c.Y+(!h&&c.Height),p=v?n.x:c.X+(h&&c.Width),a,l;if(n.orientation.toLowerCase()=="horizontal"){switch(t){case"inside":f=h?r:0;o=h?f+i:i;break;case"outside":f=0;o=h?i:f+i}l=h?y-this.model.wallSize-i:y+this.model.wallSize-i/2;a=n.x;f+=l;o+=l;u=e=u}else{switch(t){case"inside":u=0;e=h?i:u+i;break;case"outside":u=0;e=h?u+i:i}a=h?p+this.model.wallSize:p-this.model.wallSize-i;l=this.model.m_AreaBounds.Y;u+=a;e+=a;f=o=f}return{X1:u,Y1:f,X2:e,Y2:o}},_drawGridLines3D:function(t,i){var v,u,a,b,c,r,f,y,h;if(t!=null){var p=t.visibleLabels.length,w,k=t._opposed,tt=t.orientation,d=i.axes[t.name]._validCross,l,e,o,s,g;if(tt.toLowerCase()=="horizontal")for(u=0;u<p;u++){r=ej.EjSvgRender.utils._valueToCoefficient(t,t.visibleLabels[u].Value);r=isNaN(r)?0:r;e=l=Math.round(t.width*r)+this.model.m_AreaBounds.X+t.plotOffset;o=this.model.m_AreaBounds.Y;s=this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height;var a=this.model.depth>2?this.model.depth-2:1,nt=d?t.y:this.model.m_AreaBounds.Y+(!k&&this.model.m_AreaBounds.Height),f={opacity:t.majorGridLines.opacity,width:t.majorGridLines.width,stroke:t.majorGridLines.color,child:this.chart3D,tag:"line"};if(f.id=this.svgObject.id+t.name+"_gridlines_"+u,this.graphics.addVisual(this.polygon.createLine(f,l,o,e,s,a)),v=n.extend({},f),v.id=this.svgObject.id+t.name+"_parallelGridlines_"+u,h=this.polygon.createLine(v,e,0,e,-a,nt),this.polygon.transform(this.matrixobj.tilt(parseFloat(Math.PI/2)),h),this.graphics.addVisual(h),t.minorGridLines.visible&&t.minorTicksPerInterval>0&&u<p-1)for(w=t.visibleRange.interval/(t.minorTicksPerInterval+1),c=0;c<t.minorTicksPerInterval;c++)r=ej.EjSvgRender.utils._valueToCoefficient(t,t.visibleLabels[u].Value+w*(c+1)),r=isNaN(r)?0:r,e=l=Math.round(this.model.m_AreaBounds.Width*r)+this.model.m_AreaBounds.X,o=this.model.m_AreaBounds.Y,s=this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height,f={opacity:t.minorGridLines.opacity,width:t.minorGridLines.width,stroke:t.minorGridLines.color,child:this.chart3D,tag:"line"},f.id=this.svgObject.id+t.name+"_minorgridlines_"+u+c,this.graphics.addVisual(this.polygon.createLine(f,l,o,e,s,a)),v=n.extend({},f),v.id=this.svgObject.id+t.name+"_parallelMinorGridlines_"+u+c,h=this.polygon.createLine(v,e,0,e,-a,nt),this.polygon.transform(this.matrixobj.tilt(parseFloat(Math.PI/2)),h),this.graphics.addVisual(h);g++}else for(u=0;u<p;u++){if(r=(t.visibleLabels[u].Value-t.visibleRange.min)/t.visibleRange.delta,r=t.isInversed?1-r:r,r=isNaN(r)?0:r,l=this.model.m_AreaBounds.X,o=Math.round(t.height*(1-r))+.5,o+=t.y,e=l+this.model.m_AreaBounds.Width,s=o,a=this.model.depth>2?this.model.depth-2:1,f={opacity:t.majorGridLines.opacity,width:t.majorGridLines.width,stroke:t.majorGridLines.color,axisName:t.name,child:this.chart3D,tag:"line"},f.id=this.svgObject.id+t.name+"_gridlines_"+u,this.graphics.addVisual(this.polygon.createLine(f,l,o,e,s,a)),b=d?t.x:this.model.m_AreaBounds.X+(k&&this.model.m_AreaBounds.Width+1),y=n.extend({},f),y.id=this.svgObject.id+t.name+"_parallelGridlines_"+u,h=this.polygon.createLine(y,-a,s,0,s,b),this.polygon.transform(this.matrixobj.turn(parseFloat(-Math.PI/2)),h),this.graphics.addVisual(h),t.minorGridLines.visible&&t.minorTicksPerInterval>0&&u<p-1)for(w=t.visibleRange.interval/(t.minorTicksPerInterval+1),c=0;c<t.minorTicksPerInterval;c++)r=ej.EjSvgRender.utils._valueToCoefficient(t,t.visibleLabels[u].Value+w*(c+1)),r=isNaN(r)?0:r,l=this.model.m_AreaBounds.X,o=Math.round(t.height*(1-r))+.5,o+=t.y,e=l+this.model.m_AreaBounds.Width,s=o,f={opacity:t.minorGridLines.opacity,width:t.minorGridLines.width,stroke:t.minorGridLines.color,axisName:t.name,child:this.chart3D,tag:"line"},f.id=this.svgObject.id+t.name+"_minorgridlines_"+u+c,this.graphics.addVisual(this.polygon.createLine(f,l,o,e,s,a)),y=n.extend({},f),y.id=this.svgObject.id+t.name+"_parallelMinorGridlines_"+u+c,h=this.polygon.createLine(y,-a,s,0,s,b),this.polygon.transform(this.matrixobj.turn(parseFloat(-Math.PI/2)),h),this.graphics.addVisual(h);g++}}}};ej.Ej3DSeriesRender.prototype={_getSegmentDepth:function(n){var u=this.chartObj.model.depth,i,r,t;if(this.chartObj.model._sideBySideSeriesPlacement)t=u/4,i=t,r=t*3;else{var e=n.position-1,f=n.all,t=u/(f*2+f+1);i=t+t*e*3;r=i+t*2}return{Start:i,End:r,Delta:r-i}},createSegment:function(n,t,i,r,u,f,e,o,s){return{StartValue:t,EndValue:i,depth:r,radius:u,index:f,YData:e,Center:n,inSideRadius:o,ActualEndValue:i,ActualStartValue:t,pointIndex:s}},calculateSize:function(t,i){var r=t.chartObj.model.legend,o=0,s=0,u=t.chartObj.model.title,h=t.chartObj.model.title.subTitle,e=t.chartObj.model._titleLocation,a=t.chartObj.model._subTitleLocation,v=t.chartObj.model.title.textOverflow,y=t.chartObj.model.title.subTitle.textOverflow,w=u.text&&u.visible&&u.enableTrim&&(v=="wrap"||v=="wrapandtrim")?!0:!1,c=h.text&&h.visible&&h.enableTrim&&(y=="wrap"||y=="wrapandtrim")?!0:!1,p,f,l;return r.visible&&r.position.toLowerCase()!="custom"&&(r.position.toLowerCase()=="right"||r.position.toLowerCase()=="left"?o=(r.position.toLowerCase()=="right"?t.chartObj.model.margin.right:t.chartObj.model.margin.left)+t.chartObj.model.LegendViewerBounds.Width:s=(r.position.toLowerCase()=="top"?t.chartObj.model.margin.top:t.chartObj.model.margin.bottom)+t.chartObj.model.LegendViewerBounds.Height),i.actualWidth=n(t.chartObj.svgObject).width()-o,p=i.actualWidth*.5+(r.position.toLowerCase()==="left"?o:0),w||c?(f=e.size.height+(c?a.size.height:0)+s,i.actualHeight=n(t.chartObj.svgObject).height()-f,l=i.actualHeight*.5+(r.position.toLowerCase()==="top"?f:e.size.height+(c?a.size.height:0))):(f=(u.text&&u.visible?e.Y:0)+s,i.actualHeight=n(t.chartObj.svgObject).height()-f,l=i.actualHeight*.5+(r.position.toLowerCase()==="top"?f:u.text&&u.visible?e.Y:0)),{centerX:p,centerY:l}},createPoints:function(t,i){var s,r;t.segments=[];var p=this.calculateSize(i,t),u=0,tt=this._calculateVisiblePoints(t).visiblePoints,w=t._visiblePoints.length;for(s=0;s<w;s++)u+=tt[s].YValues[0];u=u!=0?u:1;var b=360/u,k=n.inArray(t,i.chartObj.model._visibleSeries),ut=this.chartObj.model._visibleSeries.length,it=i.chartObj.model.innerRadius[k],d=i.chartObj._getYValues(t._visiblePoints),rt=i.chartObj.model.depth,l,a=0,v=0,h=0,g,f,e,o,y,nt=0,c=i.chartObj.model.circularRadius[k];for(r=0;r<w;r++)(t._visiblePoints[r].visible||t._visiblePoints[r].gapMode)&&(g=n.inArray(t._visiblePoints[r],t._visiblePoints),f=Math.abs(d[r]),v=Math.abs(f)*(Math.PI*2/u),e={},e.x=0,e.y=0,ej.util.isNullOrUndefined(f)||((t.explodeIndex==t._visiblePoints[r].actualIndex||t.explodeAll)&&(o={X:0,Y:0},o.X=Math.cos(2*Math.PI*(h+f/2)/u),o.Y=Math.sin(2*Math.PI*(h+f/2)/u),e.x=.01*c*o.X*t.explodeOffset,e.y=.01*c*o.Y*t.explodeOffset),l=i.chartObj.vector.vector3D(e.x+p.centerX,e.y+p.centerY,0),y=this.createSegment(l,parseFloat(b*h),parseFloat(b*f),rt,c,r,f,it,g,t),y.visible=t._visiblePoints[r].gapMode?!1:!0,t.segments.push(y)),t.marker.dataLabel.visible&&this._addPieDataLabel(nt,d[r],a,a+v,r,c,this._isChartRotated(i)?i.chartObj.model.depth+5:0,l,t._visiblePoints[r]),nt++,a+=v,h+=f);return t.segments},_addPieDataLabel:function(n,t,i,r,u,f,e,o,s){var h=(i+r)/2;s.symbolLocation={x:0,y:0,radius:0,angle:0,StartDepth:0};s.symbolLocation.x=n;s.symbolLocation.y=t;s.symbolLocation.radius=f;s.symbolLocation.angle=h;s.symbolLocation.center=o;s.startDepth=e},_isChartRotated:function(n){var t=Math.abs(n.chartObj.model.tilt%360),i=Math.abs(n.chartObj.model.rotattion%360);return(t>90&&t<270)^(i>90&&i<270)?!0:!1},createSector:function(n,t,i,r){var o=parseInt(Math.ceil(n.ActualEndValue/6)),v=Math.PI/180,s=0,rt=[],h=t.chartObj.model.depth,k,d,tt,it,g,p,nt,l,a,u,w,b;if(o<1)return null;var c=[],y=n.ActualEndValue/o,f=[],e=[];for(u=0;u<o+1;u++)k=parseFloat(n.Center.x+n.radius*Math.cos((n.ActualStartValue+u*y)*v)),d=parseFloat(n.Center.y+n.radius*Math.sin((n.ActualStartValue+u*y)*v)),f[u]={X:k,Y:d},tt=parseFloat(n.Center.x+n.inSideRadius*Math.cos((n.ActualStartValue+u*y)*v)),it=parseFloat(n.Center.y+n.inSideRadius*Math.sin((n.ActualStartValue+u*y)*v)),e[u]={X:tt,Y:it},rt.push({X:k,Y:d});for(g=[],u=0;u<o;u++)p=[t.chartObj.vector.vector3D(f[u].X,f[u].Y,0),t.chartObj.vector.vector3D(f[u].X,f[u].Y,h),t.chartObj.vector.vector3D(f[u+1].X,f[u+1].Y,h),t.chartObj.vector.vector3D(f[u+1].X,f[u+1].Y,0)],g[u]=t.chartObj.polygon.polygon3D(p,this,n.index,i.borderColor,i.borderWidth,i.opacity,i.interior,s.toString()+"_Region_Series_"+r+"_Point_"+n.index,t.chartObj.chart3D),s++;if(c[1]=g,n.inSideRadius>0){for(nt=[],u=0;u<o;u++)p=[t.chartObj.vector.vector3D(e[u].X,e[u].Y,0),t.chartObj.vector.vector3D(e[u].X,e[u].Y,h),t.chartObj.vector.vector3D(e[u+1].X,e[u+1].Y,h),t.chartObj.vector.vector3D(e[u+1].X,e[u+1].Y,0)],nt[u]=t.chartObj.polygon.polygon3D(p,this,n.index,i.borderColor,i.borderWidth,i.opacity,i.interior,s.toString()+"_Region_Series_"+r+"_Point_"+n.index,t.chartObj.chart3D),s++;c[3]=nt}for(l=[],a=[],u=0;u<o+1;u++)l.push(t.chartObj.vector.vector3D(f[u].X,f[u].Y,0)),a.push(t.chartObj.vector.vector3D(f[u].X,f[u].Y,h));if(n.inSideRadius>0)for(u=o;u>-1;u--)l.push(t.chartObj.vector.vector3D(e[u].X,e[u].Y,0)),a.push(t.chartObj.vector.vector3D(e[u].X,e[u].Y,h));else l.push(n.Center),a.push(t.chartObj.vector.vector3D(n.Center.x,n.Center.y,h));return c[0]=[],c[0].push(t.chartObj.polygon.polygon3D(l,this,n.index,i.borderColor,i.borderWidth,i.opacity,i.interior,s.toString()+"_Region_Series_"+r+"_Point_"+n.index,t.chartObj.chart3D)),s++,c[0].push(t.chartObj.polygon.polygon3D(a,this,n.index,i.borderColor,i.borderWidth,i.opacity,i.interior,s.toString()+"_Region_Series_"+r+"_Point_"+n.index,t.chartObj.chart3D)),s++,n.inSideRadius>0?(w=[t.chartObj.vector.vector3D(f[0].X,f[0].Y,0),t.chartObj.vector.vector3D(f[0].X,f[0].Y,h),t.chartObj.vector.vector3D(e[0].X,e[0].Y,h),t.chartObj.vector.vector3D(e[0].X,e[0].Y,0)],b=[t.chartObj.vector.vector3D(f[o].X,f[o].Y,0),t.chartObj.vector.vector3D(f[o].X,f[o].Y,h),t.chartObj.vector.vector3D(e[o].X,e[o].Y,h),t.chartObj.vector.vector3D(e[o].X,e[o].Y,0)],c[2]=[],c[2].push(t.chartObj.polygon.polygon3D(w,this,n.index,i.borderColor,i.borderWidth,i.opacity,i.interior,s.toString()+"_Region_Series_"+r+"_Point_"+n.index,t.chartObj.chart3D)),s++,c[2].push(t.chartObj.polygon.polygon3D(b,this,n.index,i.borderColor,i.borderWidth,i.opacity,i.interior,s.toString()+"_Region_Series_"+r+"_Point_"+n.index,t.chartObj.chart3D)),s++):(w=[t.chartObj.vector.vector3D(f[0].X,f[0].Y,0),t.chartObj.vector.vector3D(f[0].X,f[0].Y,h),t.chartObj.vector.vector3D(n.Center.x,n.Center.y,h),t.chartObj.vector.vector3D(n.Center.x,n.Center.y,0)],b=[t.chartObj.vector.vector3D(f[o].X,f[o].Y,0),t.chartObj.vector.vector3D(f[o].X,f[o].Y,h),t.chartObj.vector.vector3D(n.Center.x,n.Center.y,h),t.chartObj.vector.vector3D(n.Center.x,n.Center.y,0)],c[2]=[],c[2].push(t.chartObj.polygon.polygon3D(w,this,n.index,i.borderColor,i.borderWidth,i.opacity,i.interior,s.toString()+"_Region_Series_"+r+"_Point_"+n.index,t.chartObj.chart3D)),s++,c[2].push(t.chartObj.polygon.polygon3D(b,this,n.index,i.borderColor,i.borderWidth,i.opacity,i.interior,s.toString()+"_Region_Series_"+r+"_Point_"+n.index,t.chartObj.chart3D)),s++),c},createPolygons:function(t,i,r){var s,f=[],a,v,h,y,e,p=n.inArray(t,i.chartObj.model._visibleSeries),o,c,u,l;for(s=t.segments&&r?t.segments:this.createPoints(t,i),y=s.length,o=0;o<y;o++)if(a=s[o],a.visible&&(h=s[o].pointIndex,v=i.chartObj.setStyle(i,t,p,h),typeof i.chartObj.model.pointColors[h]=="object"&&(v.interior=i.chartObj.model.pointColors[h][0].color),e=this.createSector(a,i,v,p),e!=null))for(u=0;u<e.length;u++)if(f[u]||(f[u]=[]),e[u]!=null)for(c=0;c<e[u].length;c++)f[u].push(e[u][c]);if(r)return f;for(u=0;u<f.length;u++)for(l=0;l<f[u].length;l++)i.chartObj.graphics.addVisual(f[u][l])},draw3DDataLabel:function(t,i,r){var s=t.marker.dataLabel.connectorLine.height,nt,p,e,o,a,d=0,v=0,h,w,f,c,ut,y,k,ft;if(typeof t.marker.dataLabel.offset=="number"?v=t.marker.dataLabel.offset:(d=t.marker.dataLabel.offset.x,v=t.marker.dataLabel.offset.y),this.chartObj.model.AreaType=="none"){if(u={x:0,y:0},h=r.text?r.text:r.y,w=n.inArray(t,this.chartObj.model.series),t.type.toLowerCase()=="doughnut"||t.type.toLowerCase()=="pie"){var et=Math.min(t.actualWidth,t.actualHeight)/2,tt=r.symbolLocation.center,d=t.marker.dataLabel.offset.x,v=t.marker.dataLabel.offset.y,it=r.symbolLocation.radius*t._coefficient;ej.util.isNullOrUndefined(s)&&(s=ej.EjSvgRender.utils._measureText(h,null,t.marker.dataLabel.font).height);t!=null&&t.labelPosition!="inside"?p=r.symbolLocation.radius+s:t!=null&&(p=it+(r.symbolLocation.radius-it)/2);e=u.X=tt.x+p*Math.cos(r.symbolLocation.angle)+d;o=u.Y=tt.y+p*Math.sin(r.symbolLocation.angle)+v;f=n.extend({},ej.EjSvgRender.commonChartEventArgs);f.data={text:h,location:{x:e,y:o},series:t,pointIndex:i,seriesIndex:w};this.chartObj._trigger("displayTextRendering",f);f.data.Text=f.data.text;c=ej.EjSvgRender.utils._measureText(f.data.Text,null,t.marker.dataLabel.font);e=u.X=f.data.location.x;o=u.Y=f.data.location.y}}else{var l=t.yAxis.labelFormat?t.yAxis.labelFormat:"",w=n.inArray(t,this.chartObj.model.series),rt=20,h=r.text?r.text:r.y;l&&(l.indexOf("{value}")>-1?h=l.replace("{value}",r.y):l.indexOf("e")==0||l.indexOf("E")==0?(a=l.match(/(\d+)/g),a=a==null?6:a>rt?rt:a,h=r.y.toExponential(a)):h=ej.globalize.format(r.y,l,this.chartObj.model.locale));var g=0,f=n.extend({},ej.EjSvgRender.commonChartEventArgs),c=ej.EjSvgRender.utils._measureText(h,null,t.marker.dataLabel.font),u=ej.EjSvgRender.utils.Transform3DToVisible(t,r.symbolLocation.x,r.symbolLocation.y,this.chartObj),s=t.marker.dataLabel.connectorLine.height?t.marker.dataLabel.connectorLine.height:0,b=6.28*(1-90/360),o=u.Y,e=u.X;this.chartObj.model.requireInvertedAxes?(e=r.x>0?u.X-Math.sin(b)*s:u.X+Math.sin(b)*s,g=-c.height/3):o=r.y>0?u.Y+Math.sin(b)*s:u.Y+Math.sin(-b)*s;o=t.marker.dataLabel.textPosition=="bottom"?u.Y+v:u.Y-v;e=u.X+d;f.data={text:h,location:{x:e,y:o},series:t,pointIndex:i};f.data.Text=f.data.text;this.chartObj._trigger("displayTextRendering",f);e=f.data.location.x;o=f.data.location.y}ut=this._getSegmentDepth(t);t.marker.dataLabel.shape.toLowerCase()=="none"||r.marker.dataLabel.template||f.data.Text==""||(y={tag:"dataLabel",series:t,point:r,pointIndex:i,id:this.chartObj.svgObject.id+w+"_DataLabel"+i,child:this.chartObj.chart3D},this.chartObj.graphics.addVisual(this.chartObj.polygon.createTextElement(this.chartObj.vector.vector3D(e,o,r.symbolLocation.z?r.symbolLocation.z:0),y,0,-c.height)));nt=r.marker.dataLabel.template?"template":"text";y={Width:c.width,Height:c.height,Label:f.data,TextAnchor:"middle",tag:nt,font:t.marker.dataLabel.font,Angle:t.marker.dataLabel.angle,id:this.chartObj.svgObject.id+"_SeriesText"+i+w,child:this.chartObj.chart3D};this.chartObj.model.AreaType!="none"?(t.marker.dataLabel.connectorLine.height&&t.marker.dataLabel.connectorLine.height>0&&(k=[],k.push({x:u.X,y:u.Y+g,z:r.symbolLocation.z}),k.push({x:e,y:o+g,z:r.symbolLocation.z}),this.drawLineSegment(k,i,t)),this.chartObj.graphics.addVisual(this.chartObj.polygon.createTextElement(this.chartObj.vector.vector3D(e,o,r.symbolLocation.z),y,0,-c.height))):(t.labelPosition.toLowerCase()!="inside"&&this.updateConnectorLine(r,i,t,u,s),ft={x:t.actualWidth,y:t.actualHeight},this.chartObj.graphics.addVisual(this.chartObj.polygon.createTextElement(this.chartObj.vector.vector3D(u.X,u.Y,-1),y,0,-c.height)))},updateConnectorLine:function(n,t,i,r,u){var e=[],f=n.symbolLocation,o=f.center.x+Math.cos(f.angle)*f.radius,s=f.center.y+Math.sin(f.angle)*f.radius,h;e.push({x:o,y:s});h=f.radius+u;o=f.center.x+Math.cos(f.angle)*h;s=f.center.y+Math.sin(f.angle)*h;e.push({x:o,y:s});i.marker.dataLabel.connectorLine.type=="bezier"&&(e=this.getBezierApproximation(e,256,i));this.drawLineSegment(e,t,i)},getBezierApproximation:function(n,t,i){for(var f,u=[],r=0;r<=t;r++)f=r/t,u.push(this.GetBezierPoint(f,n,0,n.length,i));return u},drawLineSegment:function(t,i,r){for(var f=[],u=0;u<t.length;u++)f.push(this.chartObj.vector.vector3D(t[u].x,t[u].y,t[u].z?t[u].z:0));var e=n.inArray(r,this.chartObj.model._visibleSeries),o=this.chartObj.model.AreaType=="none"?this.chartObj.model.pointColors[i]:this.chartObj.model.seriesColors[e],s=r.marker.dataLabel.connectorLine.stroke?r.marker.dataLabel.connectorLine.stroke:o,h={width:r.marker.dataLabel.connectorLine.width,stroke:s,child:this.chartObj.chart3D,tag:"polyline",id:this.chartObj.svgObject.id+"_"+e+"_"+i};this.chartObj.graphics.addVisual(this.chartObj.polygon.createPolyline(f,h))}};ej.ejCircularSeries={draw:function(t,i,r){var e=i.chartObj.model._visibleSeries.length,u=n.inArray(t,i.chartObj.model._visibleSeries),f;if(i._calculateVisiblePoints(t),i.calculateSize(i,t),r=="pie"?(t._size=t.pieCoefficient,t._coefficient=u==0?0:t._size):(t._size=t.doughnutSize,t._coefficient=t.doughnutCoefficient),i.chartObj.model.circularRadius.length>1){for(f=u;f<i.chartObj.model.circularRadius.length;f++)if(!ej.util.isNullOrUndefined(i.chartObj.model.circularRadius[f])){i.chartObj.model.circularRadius[u]=i.chartObj.model.circularRadius[f]*t._size;break}}else i.chartObj.model.circularRadius[u]=(1-.03)*Math.min(t.actualWidth/2,t.actualHeight/2)*t._size;i.chartObj.model.innerRadius[u]=t._coefficient*i.chartObj.model.circularRadius[u];i.createPolygons(t,i)},doAnimation:function(t,i){var r=this;t.count=0;n.each(t.segments,function(r,u){var f=u.radius,e=u.inSideRadius;t.animate=!0;n(i.chartObj.element).each(function(){u.radius=0;u.inSideRadius=0}).animate({Radius:f,InsideRadius:e},{duration:1e3,queue:!1,step:function(n,r){var e,f,o;for(r.prop.toString()==="Radius"?u.radius=n:u.inSideRadius=n,e=i.createPolygons(t,i,!0),f=0;f<e.length;f++)for(o=0;o<e[f].length;o++)i.chartObj.polygon.update(e[f][o].VectorPoints,e[f][o],i)},complete:function(){i.chartObj.model.AnimationComplete=!0;var r=n.extend({},ej.EjSvgRender.commonChartEventArgs);r.data={series:t};i.chartObj._trigger("animationComplete",r)}})})}};ej.series3DTypes.doughnut=ej.ejCircularSeries;ej.series3DTypes.pie=ej.ejCircularSeries;ej.ej3DStackingColumn={draw:function(n,t,i,r){var f=t._isVisiblePoints(n),u;for(this.createSegments(n,t,r),u=0;u<f.length;u++)f[u].visible&&(n._visiblePoints[u].plans=null,ej.ej3DColumnSeries.update(n,n._visiblePoints[u],u,t))},createSegments:function(n,t,i){var c=t.chartObj._getXValues(n._visiblePoints),e,o,f,u,r;if(c!=null)for(o=t.getSideBySideInfo(n,i),f=t._getSegmentDepth(n),e=o.Delta/2,u=t._isVisiblePoints(n),r=0;r<u.length;r++){var s=c[r]+o.Start,a=c[r]+o.End,l=n.stackedValue.StartValues[r],h=n.stackedValue.EndValues[r];if(ej.ej3DColumnSeries._setData(s,h,a,l,f.Start,f.End,t,u[r]),n.marker.dataLabel.visible){u[r].symbolLocation={x:0,y:0,z:0};switch(n.marker.dataLabel.textPosition){case"top":u[r].symbolLocation.x=s+e;u[r].symbolLocation.y=h;u[r].symbolLocation.z=f.Start+f.Delta/2;break;case"bottom":u[r].symbolLocation.x=s+e;u[r].symbolLocation.y=l-.2;u[r].symbolLocation.z=f.Start+(f.End-f.Start)/2;break;default:u[r].symbolLocation.x=s+e;u[r].symbolLocation.y=h+(l-h)/2;u[r].symbolLocation.z=f.Start}}}},doAnimation:function(t,i){var r=this;n.each(t._visiblePoints,function(r,u){var f=u.Top,e=u.Bottom;n(u).each(function(){u.Top=0;u.Bottom=0}).animate({Top:f,Bottom:e},{duration:1200,queue:!1,step:function(n,f){f.prop.toString()==="Top"&&(u.Top=n);f.prop.toString()==="Bottom"&&(u.Bottom=n);ej.ej3DColumnSeries.update(t,u,r,i)},complete:function(){i.chartObj.model.AnimationComplete=!0;var r=n.extend({},ej.EjSvgRender.commonChartEventArgs);r.data={series:t};i.chartObj._trigger("animationComplete",r)}})})}};ej.series3DTypes.stackingcolumn=ej.ej3DStackingColumn;ej.series3DTypes.stackingbar=ej.ej3DStackingColumn;ej.series3DTypes.stackingbar100=ej.ej3DStackingColumn;ej.series3DTypes.stackingcolumn100=ej.ej3DStackingColumn;ej.ej3DColumnSeries={draw:function(n,t,i,r){var f=t._isVisiblePoints(n),u;for(this.createSegments(n,t,r),u=0;u<f.length;u++)f[u].visible&&(n._visiblePoints[u].plans=null,this.update(n,n._visiblePoints[u],u,t))},update:function(t,i,r,u){var v=t.xAxis._valueType.toLowerCase(),l=n.inArray(t,u.chartObj.model._visibleSeries),y=v=="logarithmic"?null:1,p=v=="logarithmic"?!0:!1,w=p?Math.log(i.Left,y):i.Left,b=p?Math.log(i.Right,y):i.Right,e=t.yAxis.visibleRange.min,k=t.yAxis.visibleRange.max,o=t.xAxis.visibleRange.min,s=t.xAxis.visibleRange.max,d,a;if(w>=o&&w<=s||b>=o&&b<=s){d=i.Top<0?i.Top>e?i.Top:e:t.yAxis.valueType&&t.yAxis.valueType.toLowerCase()=="logarithmic"?i.Top:i.Top<k?i.Top:k;var h=ej.EjSvgRender.utils.Transform3DToVisible(t,i.Left>o?i.Left:o,d,u.chartObj),c=ej.EjSvgRender.utils.Transform3DToVisible(t,s>i.Right?i.Right:s,e>i.Bottom?e:i.Bottom,u.chartObj),g=u.chartObj.vector.vector3D(Math.min(h.X,c.X),Math.min(h.Y,c.Y),i.StartDepth),nt=u.chartObj.vector.vector3D(Math.max(h.X,c.X),Math.max(h.Y,c.Y),i.EndDepth),f=u.chartObj.setStyle(u,t,l,r);f.interior.indexOf("url")>=0&&(f.interior=u.chartObj.model.seriesColors[l][0].color);a="Region_Series_"+l+"_Point_"+r;t.columnFacet=="cylinder"?u.chartObj.polygon.createCylinder(g,nt,this,r,t.type,f.borderColor,f.interior,f.borderWidth,f.opacity,u.chartObj.model.requireInvertedAxes,a,u.chartObj.chart3D):t.columnFacet=="rectangle"&&u.chartObj.polygon.createBox(g,nt,this,r,t.type,f.borderColor,f.interior,f.borderWidth,f.opacity,u.chartObj.model.requireInvertedAxes,a,u.chartObj.chart3D)}},_setData:function(){var t=arguments,n=arguments[arguments.length-1],i=arguments[arguments.length-2];n.Left=t[0];n.Bottom=t[3];n.Top=t[1];n.Right=t[2];n.StartDepth=t[4];n.EndDepth=t[5];n.XRange=i.getDoubleRange(n.Left,n.Right);isNaN(n.Top)||isNaN(n.Bottom)||(n.YRange=i.getDoubleRange(n.Top,n.Bottom))},createSegments:function(n,t,i){var e=t.chartObj._getXValues(n._visiblePoints),a=t.chartObj._getYValues(n._visiblePoints),r;if(e!=null){var s=t.getSideBySideInfo(n,i),f=t._getSegmentDepth(n),v=t.chartObj._getXCrossValue(n,n.xAxis,i),h=s.Delta/2,u=n._visiblePoints,y,p;for(r=0;r<u.length;r++){var o=e[r]+s.Start,w=e[r]+s.End,c=a[r],l=v;if(this._setData(o,c,w,l,f.Start,f.End,t,u[r]),y=e[r],p=a[r],n.marker.dataLabel.visible){u[r].symbolLocation={x:0,y:0,z:0};switch(n.marker.dataLabel.textPosition){case"top":u[r].symbolLocation.x=o+h;u[r].symbolLocation.y=c;u[r].symbolLocation.z=f.Start;break;case"bottom":u[r].symbolLocation.x=o+h;u[r].symbolLocation.y=l-.2;u[r].symbolLocation.z=f.Start+(f.End-f.Start)/2;break;default:u[r].symbolLocation.x=o+h;u[r].symbolLocation.y=Math.abs(l-c)/2;u[r].symbolLocation.z=f.Start}}}}},doAnimation:function(t,i){var r=this;n.each(t._visiblePoints,function(u,f){var e=f.Top;n(f).each(function(){f.Top=0}).animate({Top:e},{duration:1200,queue:!1,step:function(n,e){e.prop.toString()==="Top"&&(f.Top=n);r.update(t,f,u,i)},complete:function(){i.chartObj.model.AnimationComplete=!0;var r=n.extend({},ej.EjSvgRender.commonChartEventArgs);r.data={series:t};i.chartObj._trigger("animationComplete",r)}})})}};ej.series3DTypes.column=ej.ej3DColumnSeries;ej.series3DTypes.bar=ej.ej3DColumnSeries;ej.Ej3DChart.prototype={renderSeries:function(t,i,r){var i,u,f,e,o;(ej.Ej3DSeriesRender.prototype.chartObj=t,n.extend(ej.Ej3DSeriesRender.prototype,ej.EjSeriesRender.prototype),u=new ej.Ej3DSeriesRender,f=n.extend({},ej.EjSvgRender.commonChartEventArgs),f.data={series:i},u.chartObj._trigger("seriesRendering",f),e=i.type.toLowerCase(),o=ej.series3DTypes[e],ej.util.isNullOrUndefined(o))||(o.draw(i,u,e,r),i.marker.dataLabel.visible&&n.each(i._visiblePoints,function(r,f){f.marker=n.extend(!0,{},i.marker,f.marker);f.visible&&(ej.util.isNullOrUndefined(f.marker)||f.marker.dataLabel&&f.marker.dataLabel.visible)&&u.draw3DDataLabel(i,r,f,t)}))},update3DWall:function(t,i){var u,r,f;if(t.model.AreaType=="cartesianaxes")for(n.extend(ej.Ej3DRender.prototype,this),this.updateBackWall(t),u=0;u<t.model._axes.length;u++)r=t.model._axes[u],f=r._opposed,r.orientation.toLowerCase()=="vertical"?f?this.updateRightWall(t,r,i):this.updateLeftWall(t,r,i):f?this.updateTopWall(t,r,i):this.updateBottomWall(t,r,i)},updateTopWall:function(n,t,i){var e=0,r=n.model.m_AreaBounds,u=i.axes[t.name]._validCross?t.y:r.Y,f;e=n.model.wallSize<u?u-n.model.wallSize:-(n.model.wallSize-u);var s=n.vector.vector3D(r.X+r.Width,-n.model.depth,u-.1),h=n.vector.vector3D(r.X,-.1,e),o=n.polygon.createBox(s,h,this,0,"Graphics3D","#e2e1e1","#e2e1e1",0,.15,!1,"TopWallBrush",n.chart3D);for(f=0;f<o.length;f++)n.polygon.transform(n.matrixobj.tilt(parseFloat(Math.PI/2)),o[f])},updateRightWall:function(n,t,i){for(var f=i.axes[t.name]._validCross?t.x:n.model.m_AreaBounds.X+n.model.m_AreaBounds.Width,r={left:-n.model.depth,top:n.model.m_AreaBounds.Y,bottom:n.model.m_AreaBounds.Height+n.model.m_AreaBounds.Y,right:0},o=n.vector.vector3D(r.left,r.top,f+1.5),s=n.vector.vector3D(r.right,r.bottom,f+n.model.wallSize),e=n.polygon.createBox(o,s,n,0,"Graphics3D","#e2e1e1","#e2e1e1",0,.15,!1,"RightWallBrush",n.chart3D),u=0;u<e.length;u++)n.polygon.transform(n.matrixobj.turn(parseFloat(-Math.PI/2)),e[u])},updateBackWall:function(n){var t=n.model.m_AreaBounds,i=n.vector.vector3D(t.X,t.Y,n.model.depth==0?1.5:n.model.depth+n.model.wallSize),r=n.vector.vector3D(t.X+t.Width,t.Y+t.Height,n.model.depth==0?1.5:n.model.depth);n.polygon.createBox(i,r,n,0,"Graphics3D","#e2e1e1","#e2e1e1",0,.15,!1,"BackWallBrush",n.chart3D)},updateLeftWall:function(n,t,i){for(var r={left:-n.model.depth,top:n.model.m_AreaBounds.Y,bottom:n.model.m_AreaBounds.Height+n.model.m_AreaBounds.Y,right:0},f=i.axes[t.name]._validCross?t.x:n.model.m_AreaBounds.X,o=n.vector.vector3D(r.left,r.top,f-.1),s=n.vector.vector3D(r.right,r.bottom,f-n.model.wallSize),e=n.polygon.createBox(o,s,this,0,"Graphics3D","#e2e1e1","#e2e1e1",0,.15,!1,"LeftWallBrush",n.chart3D),u=0;u<e.length;u++)n.polygon.transform(n.matrixobj.turn(parseFloat(-Math.PI/2)),e[u])},updateBottomWall:function(n,t,i){for(var r=n.model.m_AreaBounds,f=i.axes[t.name]._validCross?t.y:r.Y+r.Height,o=n.vector.vector3D(r.X+r.Width,-n.model.depth,n.model.wallSize+f),s=n.vector.vector3D(r.X,-.1,f+1),e=n.polygon.createBox(s,o,this,0,"Graphics3D","#D3D3D3","#D3D3D3",0,.15,!1,"BottomWallBrush",n.chart3D),u=0;u<e.length;u++)n.polygon.transform(n.matrixobj.tilt(parseFloat(Math.PI/2)),e[u])}}}(jQuery);ej.EjVmlRender=function(n){var t=document,r,i;this.vmlNamespace="urn:schemas-microsoft-com:vml";this.vmStyle="#default#VML";t.namespaces.add("v","urn:schemas-microsoft-com:vml");this.isdocmode8=t.documentMode===8;t.getElementById("vml_chart")||(r=this.isdocmode8?"v\\:fill, v\\:path, v\\:polyline, v\\:line, v\\:rect,v\\:shape,v\\:oval, v\\:stroke{ behavior:url(#default#VML); display: inline-block; } ":"v\\:*{ behavior:url(#default#VML); display: inline-block; } ",i=t.createStyleSheet(),i.owningElement.id="vml_chart",i.cssText=r);this._rootId=jQuery(n).attr("id");this.svgObj=t.createElement("div");this.svgObj.style.position="relative";this.svgObj.setAttribute("id",this._rootId+"_vml");this.changeOptions={id:"id",fill:"fillcolor",stroke:"strokecolor","stroke-width":"strokeweight",d:"path","font-size":"font-size","font-family":"font-family","font-style":"font-style","font-weight":"font-weight",points:"points"}},function(n){ej.EjVmlRender.prototype={drawPath:function(t,i){var r=t.d.split(" "),f,e,o,u;n.inArray("A",r)!=-1&&(f=parseFloat(r[4]),e=parseFloat(r[5]),t.d=this.drawArc(f,e,t));n("#"+t.id).length>0?(t.d=this.changePathValue(t.d),this.applyVMLStyle(n("#"+t.id),t)):(t.d=this.changePathValue(t.d),o=document.createElement("v:shape"),u=n(o),this.applyVMLStyle(u,t),u.appendTo(i))},createLegendSvg:function(n){var t=document;return this._rootId=jQuery(n).attr("id"),this.legendsvgObj=t.createElement("div"),this.legendsvgObj.style.position="relative",this.legendsvgObj.setAttribute("id","legend_"+this._rootId+"_vml"),this.legendsvgObj},drawPolyline:function(t,i){var f=t.points.split(" "),u,r;n("#"+t.id).length>0?(t.points=this.changePathValue(t.points),this.applyVMLStyle(n("#"+t.id),t)):(t.points=this.changePathValue(t.points),u=document.createElement("v:polyline"),r=n(u),this.applyVMLStyle(r,t),r.appendTo(i))},setFillAttribute:function(t,i){var r=document.createElement("v:fill"),f=i["fill-opacity"]?i["fill-opacity"]:i.opacity,u,e;f=ej.util.isNullOrUndefined(f)?i.opacity?i.opacity:1:f;u=i.fill;u=="none"||ej.util.isNullOrUndefined(u)?u=="none"?(r.setAttribute("type","gradient"),r.setAttribute("color",i.color),r.setAttribute("color2",i.color2),r.setAttribute("colors",i.colors),r.setAttribute("angle",i.angle),f=i.fill_opacity):f=.1:u.match("gradient")?(e=u.replace("gradient",""),r.setAttribute("type","gradient"),r.setAttribute("colors",e)):n(t).attr("fillcolor",u);r.setAttribute("opacity",f);n(r).appendTo(t)},setStrokeAttribute:function(t,i){var f=i.stroke,r,u;f=="transparent"&&(i.opacity=.1);i.name&&n(t).attr("name",i.name);r=i.opacity;r&&(u=document.createElement("v:stroke"),u.setAttribute("opacity",r),n(u).appendTo(t))},changePathValue:function(n){var t,i,r;if(!n.d){for(t=n.split(" "),i=0;i<t.length;i++)r=t[i].match(/\d+/g),r!=null&&(t[i]=Math.round(parseFloat(t[i])));return t.join(" ")}},drawArc:function(n,t,i){var u=0,f=0,w,s=i.start,o=i.end,o=Number(Math.PI.toFixed(2))==Number((o+s).toFixed(2))?o-.01:o,e=i.r||n||t,l=Math.cos(s),a=Math.sin(s),h=Math.cos(o),v=Math.sin(o),r=i.innerR,y=.08/e,p=r&&.1/r||0,c;return o-s==0?"":(2*Math.PI-o+s<y?h=-y:o-s<p&&(h=Math.cos(s+p)),c=["wa",u-e,f-e,u+e,f+e,u+e*l,f+e*a,u+e*h,f+e*v],i.open&&!r&&c.push("e",w,u,f),c.push("at",u-r,f-r,u+r,f+r,u+r*h,f+r*v,u+r*l,f+r*a,"x","e"),c.join(" "))},changeVMLStyle:function(t,i){var r=this,u=i.stroke;t.css("width",i.width).css("visibility",i.visibility).css("height",i.height).css("position","absolute").css("left",i.x).css("top",i.y);n.each(i,function(n,u){(r.changeOptions[n]!=null||r.changeOptions[n]!=undefined)&&((n=="d"||n=="points")&&(u=r.changePathValue(i[n]).toLowerCase()),u!="transparent"||i.fill_opacity||(i[n]=u="white",n!="fill"||i.hasOwnProperty("opacity")&&i.opacity||(i.opacity=.1)),i.fill_opacity&&(i.opacity=i.fill_opacity),t[0].tagName==="SPAN"?n=="fill"?t.css("color",u):n=="id"?t.attr(r.changeOptions[n],u):t.css(r.changeOptions[n],u):r.isdocmode8?t.get(0)[r.changeOptions[n]]=u:t.get(0).setAttribute(r.changeOptions[n],u))});(i.hasOwnProperty("fill-opacity")||i.hasOwnProperty("opacity")||i.hasOwnProperty("fill"))&&(t[0].tagName==="SPAN"||(r.setFillAttribute(t,i),i.hasOwnProperty("stroke")&&(i.stroke=u,i.fill_opacity&&(i.opacity=i.fill_opacity),r.setStrokeAttribute(t,i))))},applyVMLStyle:function(n,t){n[0].tagName!=="SPAN"&&(ej.util.isNullOrUndefined(t.width)&&(t.width="1000px"),ej.util.isNullOrUndefined(t.height)&&(t.height="1000px"));ej.util.isNullOrUndefined(t.x)&&(t.x="0px");ej.util.isNullOrUndefined(t.y)&&(t.y="0px");this.changeVMLStyle(n,t)},drawLine:function(t,i){var r,u;if(n("#"+t.id).length>0)r=t.x1+","+t.y1,u=t.x2+","+t.y2,n(t).attr("from",r).attr("to",u),this.applyVMLStyle(n("#"+t.id),t);else{var e=document.createElement("v:line"),f=n(e),r=t.x1+","+t.y1,u=t.x2+","+t.y2;f.attr("from",r).attr("to",u);this.applyVMLStyle(f,t);f.appendTo(i)}},drawCircle:function(t,i){if(n("#"+t.id).length>0)t.x=t.cx-t.r,t.y=t.cy-t.r,t.width=t.height=2*t.r,this.applyVMLStyle(n("#"+t.id),t);else{var u=document.createElement("v:oval"),r=n(u);t.x=t.cx-t.r;t.y=t.cy-t.r;t.width=t.height=2*t.r;this.applyVMLStyle(r,t);n("#"+t.id).length==0&&r.appendTo(i)}},drawEllipse:function(t,i){if(n("#"+t.id).length>0)t.x=t.cx-t.rx,t.y=t.cy-t.ry,t.width=2*t.rx,t.height=2*t.ry,this.applyVMLStyle(n("#"+t.id),t);else{var u=document.createElement("v:oval"),r=n(u);t.x=t.cx-t.rx;t.y=t.cy-t.ry;t.width=2*t.rx;t.height=2*t.ry;this.applyVMLStyle(r,t);r.appendTo(i)}},drawRect:function(t,i){if(n("#"+t.id).length>0)this.applyVMLStyle(n("#"+t.id),t);else{var u=document.createElement("v:rect"),r=n(u);this.applyVMLStyle(r,t);r.appendTo(i)}},drawCylinder:function(t,i,r){var a=t.x,v=t.y,d=t.width,wt=t.height,bt=t.id,s,f,e,h,g,c,nt,tt,it,rt,ut,ft,y,p,w,et,ot,b,k,st,ht,ct,lt,at,vt,yt,l=t.fill,ti=ej.EjSvgRender.prototype.checkColorFormat(l),u,ni,pt;ti||(l=ej.datavisualization.Chart.prototype.colorNameToHex(t.fill));var ii=t.opacity,kt={svgRenderer:ej.EjSvgRender.prototype},dt=ej.Ej3DRender.prototype.polygon3D.prototype.applyZLight(l,kt),gt=ej.Ej3DRender.prototype.polygon3D.prototype.applyXLight(l,kt),o=65535;for(r.isColumn==!0?(t.rx=f=d/2,t.ry=e=f/4,h=g=a+f,tt=c=v-e,ft=k=y=v+wt-e,it=h+f,nt=ut=b=h-f,at=-Math.round(o*180),vt=Math.round(o*180),et=Math.round(o*360),ot=-Math.round(o*180),yt="90",r.stacking==!0&&(r.isLastSeries||(c=v+e)),rt=c):(t.ry=e=wt/2,t.rx=f=e/4,it=nt=g=a+f,b=h=a+d+f,at=Math.round(o*90),vt=Math.round(o*180),et=Math.round(o*270),ot=-Math.round(o*180),y=c=v+e,k=rt=c+e,tt=ft=y-e,yt="0",r.stacking==!0&&(r.isLastSeries||(h=a+d-f)),ut=h),delete t.x,delete t.y,t.width=1e3,t.x=0,t.y=0,delete t.stacking,t.height=1e3,delete t.isColumn,t.fill=dt,t.fill_opacity=ii,t.stroke=dt,t["stroke-width"]=0,u=1;u<=4;u++)u%2==0?(st=g,ht=c,ct=ut,lt=ft,p=et,w=ot):(st=h,ht=y,ct=it,lt=rt,p=at,w=vt),u<3&&(p=o,w=23592600),u<4&&(s=["M",Math.round(b),Math.round(k)]),s.push("ae",Math.round(st),Math.round(ht),Math.round(f),Math.round(e),p,w),u>2&&(s.push("l",Math.round(ct),Math.round(lt)),t.fill="none",t.color=l,t.color2=l,t.colors="30% "+gt+",70% "+gt,t.angle=yt),u!=3&&(s.push("e"),s=s.join(" "),t.d=s,t.id=bt+"_Region_"+(u-1).toString(),u==4&&(t.id=bt+"_Region_"+(u-2).toString()),ni=document.createElement("v:shape"),pt=n(ni),this.applyVMLStyle(pt,t),pt.appendTo(i)),b=nt,k=tt},_getAttrVal:function(t,i,r){i=i=="x"?"left":i;i=i=="y"?"top":i;var u=n(t).attr(i),f=u?u:n(t).css(i);return f!=null?f:r},_setAttr:function(t,i){var r,u,f;i.transform&&(r=i.transform,u=r.slice(r.indexOf("(")+1,r.indexOf(")")).split(","),i.x=u[0],i.y=u[1]);f=n(t);f.length>0&&this.changeVMLStyle(f,i)},createGradientElement:function(n,t){var i,f,r,u;if(Object.prototype.toString.call(t)=="[object Array]")for(i="gradient ",f="",r=0,u=t.length-1;u>=0,r<t.length;r++,u--)i+=f+t[r].colorStop+" "+t[u].color,f=",";else i=t;return i},setSpanAttr:function(t,i,r){var e=t["font-size"]>0?t["font-size"]+"px":t["font-size"],u={size:e,fontStyle:t["font-style"],fontFamily:t["font-family"]},f=ej.EjSvgRender.utils._measureText(i,null,u);n(r).css("white-space","nowrap");t["text-anchor"]==="middle"?t.x=Math.round(t.x-f.width/2):t["text-anchor"]==="end"&&(t.x=Math.round(t.x-f.width));t.y=Math.round(t.y-u.size.replace("px",""));this.applyVMLStyle(r,t)},drawText:function(t,i,r,u){var c=document,v=n("#"+t.id),f,y,l,e,s,o,h,a,p;if(v.length>0)this._textAttrReplace(t,i,u,v);else if(t.id.indexOf("YAxisTitle")>0&&!this.isdocmode8)t.on=!0,f=document.createElement("v:line"),f.style.behavior="url(#default#VML)",f.style.display="inline-block",y=ej.EjSvgRender.utils._measureText(i,null,null),f.setAttribute("to",(t.x-1).toString()+","+(t.y-y.width/2).toString()),f.setAttribute("from",t.x.toString()+","+t.y.toString()),l=document.createElement("v:path"),l.setAttribute("textpathok",!0),e=document.createElement("v:textpath"),e.setAttribute("on",!0),e.setAttribute("string",i),e.style["font-style"]=t["font-style"],e.style["font-size"]=t["font-size"],e.style["font-family"]=t["font-family"],f.appendChild(l),f.appendChild(e),n(f).appendTo(r);else{if(s=c.createElement("span"),o=n(s),jQuery.type(i)=="array")for(this.setSpanAttr(t,i,o),h=0;h<i.length;h++)a=c.createElement("span"),n(a).html(i[h]),n(a).appendTo(s),p=c.createElement("br"),n(p).appendTo(s);else this.setSpanAttr(t,i,o),o.html(i);o.appendTo(r)}},_textAttrReplace:function(t,i,r,u){var f,e,o;if(jQuery.type(i)=="array")if(f=n("#"+t.id).children("span"),this.setSpanAttr(t,i,u),f.length>0&&f.length==i.length)for(e=0;e<f.length;e++)o=f[e],n(o).text(i[e]);else n("#"+t.id).remove(),this.drawText(t,i,this.gTransToolEle,r);else this.setSpanAttr(t,i,u),u.text(i)},drawImage:function(t,i){var u=document.createElement("img"),r=n(u);r.css({position:"absolute"});n.each(t,function(n,t){n=="href"&&(n="src");r.attr(n,t)});r.appendTo(i)},createDefs:function(){},createGroup:function(t){var i=document.createElement("div"),r;return ej.util.isNullOrUndefined(t.transform)||(r=t.transform.slice(t.transform.indexOf("(")+1,t.transform.indexOf(")")).split(","),n(i).css({position:"absolute",left:r[0]+"px",top:r[1]+"px"})),t.cursor&&n(i).css({cursor:t.cursor}),n.each(t,function(t,r){t!=="transform"&&t!="clip-path"&&n(i).attr(t,r)}),i},createText:function(t,i){var r=document.createElement("span");return n(r).attr(t),ej.util.isNullOrUndefined(i)||(r.textContent=i),r},drawAxesBoundsClipPath:function(t,i,r){var u,e=n(t),f;e.removeAttr("clip-path");f=this._getTransform(i.xAxis,i.yAxis,r);u={id:t.id+"_ClipRect",x:0,y:0,width:f.width,height:f.height,fill:"white","stroke-width":1,stroke:"transparent"};this.drawClipPath(u,t);e.attr("clip-path","url(#"+u.id+")")},getAttrVal:function(t,i,r){var u=n(t).attr(i);return u!=null?u:r},round:function(n,t,i){return t*(i?Math.ceil(n/t):Math.floor(n/t))},hexFromRGB:function(t){var r=t.R,u=t.G,f=t.B;if(t.A)return"rgba("+r.toString()+","+u.toString()+","+f.toString()+","+t.A+")";var r=t.R,u=t.G,f=t.B,i=[r.toString(16),u.toString(16),f.toString(16)];return n.each(i,function(n,t){t.length===1&&(i[n]="0"+t)}),"#"+i.join("").toUpperCase()},hexToRGB:function(n){var i=/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/.test(n),t;return i==!0?(t=/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/.exec(n),t?{R:parseInt(t[1]),G:parseInt(t[2]),B:parseInt(t[3]),A:t[4]}:null):(t=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(n),t?{R:parseInt(t[1],16),G:parseInt(t[2],16),B:parseInt(t[3],16)}:null)},checkColorFormat:function(n){return/(rgba?\((?:\d{1,3}[,\)]){3}(?:\d+\.\d+\))?)|(^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$)/gmi.test(n)},createDelegate:function(n,t){return function(i){t.apply(n,[i,this])}},drawClipPath:function(t,i){if(t.id.indexOf("ChartAreaClipRect")==-1){var r=Math.round(t.x)+"px",u=Math.round(t.y)+"px",f=Math.round(t.width)+Math.round(t.x)+"px",e=Math.round(t.y)+Math.round(t.height)+"px",o="rect("+u+" "+f+" "+e+" "+r+")";n(i).css("position","absolute").css("clip",o)}},drawCircularClipPath:function(t,i){var r=Math.round(t.r),u=Math.round(t.cx),f=Math.round(t.cy);if(t.id.indexOf("_ClipRect")==-1){var e=u-r+"px",o=f-r+"px",s=u+r+"px",h=f+r+"px",c="rect("+o+" "+s+" "+h+" "+e+")";n(i).css("position","absolute").css("clip",c)}},append:function(t,i){n(t).appendTo(i)}}}(jQuery);ej.EjCanvasRender=function(n){this.svgObj=document.createElement("canvas");this._rootId=jQuery(n).attr("id");this.svgObj.setAttribute("id",this._rootId+"_canvas");this.ctx=this.svgObj.getContext("2d")},function(n){ej.EjCanvasRender.prototype={drawPath:function(n,t,i){var h=n.hasStackingInnerRadius?n.hasStackingInnerRadius:!1,p=n.d,u=p.split(" "),c=n["stroke-width"],l,o,s,a,r,f,e,v,y;if(n.lgndCtx){for(a=this.lgndCtx,this.lgndCtx=t!=undefined?t:this.lgndCtx,this.lgndCtx.save(),this.lgndCtx.beginPath(),i&&this.lgndCtx.translate(i[0],i[1]),this.lgndCtx.globalAlpha=n.opacity?n.opacity:n["fill-opacity"],this.lgndCtx.lineWidth=n["stroke-width"],this.lgndCtx.strokeStyle=n.stroke,r=0;r<u.length;r=r+3){f=parseFloat(u[r+1]);e=parseFloat(u[r+2]);switch(u[r]){case"M":this.lgndCtx.moveTo(f,e);break;case"L":this.lgndCtx.lineTo(f,e);break;case"C":this.lgndCtx.bezierCurveTo(f,e,parseFloat(u[r+3]),parseFloat(u[r+4]),parseFloat(u[r+5]),parseFloat(u[r+6]));r=r+4;break;case"A":this.lgndCtx.arc(parseFloat(u[r-5]),parseFloat(u[r-4]),f,0,2*Math.PI,!1);r=r+5;break;case"a":this.lgndCtx.beginPath();v=parseFloat(u[r-2])+f;y=u[r-1];this.lgndCtx.arc(v,y,f,0,2*Math.PI,!1);r=r+5;break;case"Z":this.lgndCtx.fillStyle=n.fill;this.lgndCtx.fill();r=r-2;break;case"Q":this.lgndCtx.quadraticCurveTo(f,e,parseFloat(u[r+3]),parseFloat(u[r+4]));r=r+2}}n.fill!="none"&&n.fill!=undefined&&(this.lgndCtx.fillStyle=n.fill,this.lgndCtx.fill());this.lgndCtx.stroke();this.lgndCtx.restore();this.lgndCtx=a}else{for(l=this.ctx,this.ctx=t!=undefined?t:this.ctx,this.ctx.save(),this.ctx.beginPath(),i&&this.ctx.translate(i[0],i[1]),this.ctx.globalAlpha=n.opacity?n.opacity:n["fill-opacity"],o=!0,this.ctx.lineWidth=c,s=n["stroke-dasharray"]?n["stroke-dasharray"].split(","):!1,s&&this.ctx.setLineDash(s),this.ctx.strokeStyle=n.stroke,r=0;r<u.length;r=r+3){f=parseFloat(u[r+1]);e=parseFloat(u[r+2]);switch(u[r]){case"M":n.innerR&&!h||n.cx||this.ctx.moveTo(f,e);break;case"L":(!n.innerR||h)&&this.ctx.lineTo(f,e);break;case"C":this.ctx.bezierCurveTo(f,e,parseFloat(u[r+3]),parseFloat(u[r+4]),parseFloat(u[r+5]),parseFloat(u[r+6]));r=r+4;break;case"A":n.innerR?o&&(this.ctx.arc(n.x,n.y,n.radius,n.start,n.end,n.counterClockWise),this.ctx.arc(n.x,n.y,n.innerR,n.end,n.start,!n.counterClockWise),o=!1):n.cx?this.ctx.arc(n.cx,n.cy,n.radius,0,2*Math.PI,n.counterClockWise):(this.ctx.moveTo(n.x,n.y),this.ctx.arc(n.x,n.y,n.radius,n.start,n.end,n.counterClockWise),this.ctx.lineTo(n.x,n.y));r=r+5;break;case"Q":this.ctx.bezierCurveTo(f,e,parseFloat(u[r+1]),parseFloat(u[r+2]),parseFloat(u[r+3]),parseFloat(u[r+4]));r=r+2;break;case"z":this.ctx.closePath()}}n.fill!="none"&&n.fill!=undefined&&(this.ctx.fillStyle=n.fill,this.ctx.fill());c>0&&this.ctx.stroke();this.ctx.restore();this.ctx=l}},_setLinePathStyle:function(n,t){var r=n["stroke-width"],i;t&&this.ctx.translate(t[0],t[1]);this.ctx.globalAlpha=n.opacity?n.opacity:n["fill-opacity"];this.ctx.lineWidth=r;i=n["stroke-dasharray"]?n["stroke-dasharray"].split(","):!1;i&&this.ctx.setLineDash(i);this.ctx.strokeStyle=n.stroke;n.fill!="none"&&n.fill!=undefined&&(this.ctx.fillStyle=n.fill,this.ctx.fill())},drawRect:function(n,t){var u=this.ctx,r=n.rx,i;this.ctx=t?t.canvas?t:this.ctx:this.ctx;this.ctx.save();this.ctx.beginPath();this.ctx.globalAlpha=n.opacity;this.ctx.lineWidth=n["stroke-width"];i=n["stroke-dasharray"]?n["stroke-dasharray"].split(","):!1;i&&this.ctx.setLineDash(i);this.ctx.strokeStyle=n.stroke;this.ctx.rect(n.x,n.y,n.width,n.height);r!=null&&r>=0?this.drawCornerRadius(n):(n.fill=="none"&&(n.fill="transparent"),this.ctx.fillStyle=n.fill,this.ctx.fillRect(n.x,n.y,n.width,n.height),this.ctx.stroke());n.id.indexOf("Series")>=0&&this.ctx.clip();this.ctx.restore();this.ctx=u},drawCylinder:function(n,t,i){var kt=this.ctx,h,a,wt,c,f,s;this.ctx=t?t.canvas?t:this.ctx:this.ctx;this.ctx.save();h=ej.datavisualization.Chart.prototype.colorNameToHex(n.fill);a={svgRenderer:ej.EjSvgRender.prototype};"use strict";var s,d,g,v=Math.PI,dt=2*v+.1,r,u,nt,y,p,tt,w,it,rt,b,ut,ft,et,ot,st,ht,ct,lt,at,vt,yt,pt,e=n.x,o=n.y,l=n.width,k=n.height,bt=dt;for(this.ctx.fillStyle=ej.Ej3DRender.prototype.polygon3D.prototype.applyZLight(h,a),this.ctx.lineWidth=0,this.ctx.strokeStyle=ej.Ej3DRender.prototype.polygon3D.prototype.applyZLight(h,a),this.ctx.globalAlpha=n.opacity,i.isColumn==!0?(ct=e,at=l+e,vt=lt=0,r=l/2,u=r/4,y=nt=e+r,b=p=o-u,it=e,w=e+l,tt=rt=o+k-u,ht=0,st=v,yt=-r,pt=u,(i.stacking=!0)&&(i.isLastSeries||(b=p=o+u))):(ct=at=0,lt=k+o,vt=o,u=k/2,r=u/4,it=nt=e+r,w=y=e+l+r,rt=o+k,b=o,tt=p=o+u,ht=v/2,st=v*1.5,(i.stacking=!0)&&(i.isLastSeries||(w=y=e+l-r)),u=-u,r=-r,yt=r,pt=-u),wt=ej.Ej3DRender.prototype.polygon3D.prototype.applyXLight(h,a),c=this.ctx.createLinearGradient(ct,vt,at,lt),c.addColorStop(0,h),c.addColorStop(.3,wt),c.addColorStop(.7,wt),c.addColorStop(1,h),f=1;f<=4;f++){for(s=0,f<4?this.ctx.beginPath():"",f%2==0?(ut=y,ft=tt,et=it,ot=b):(ut=nt,ft=p,et=w,ot=rt),f==4&&(r=yt,u=pt,this.ctx.fillStyle=c),f>2&&(s=ht,bt=st);s<=bt;s+=.1)d=ut-r*Math.cos(s),g=ft+u*Math.sin(s),s===0?this.ctx.moveTo(d,g):this.ctx.lineTo(d,g);f>2&&this.ctx.lineTo(et,ot);f!=3&&(this.ctx.stroke(),this.ctx.fill())}n.id.indexOf("Series")>=0&&this.ctx.clip();this.ctx.restore();this.ctx=kt},drawCornerRadius:function(n){var t=n.rx,i=n.x,r=n.y,u=n.width,f=n.height;n.fill=="none"&&(n.fill="transparent");this.ctx.fillStyle=n.fill;u<2*t&&(t=u/2);f<2*t&&(t=f/2);this.ctx.beginPath();this.ctx.moveTo(i+u-t,r);this.ctx.arcTo(i+u,r,i+u,r+f,t);this.ctx.arcTo(i+u,r+f,i,r+f,t);this.ctx.arcTo(i,r+f,i,r,t);this.ctx.arcTo(i,r,i+u,r,t);this.ctx.closePath();this.ctx.fill();this.ctx.stroke()},createGradientElement:function(n,t){var u,o=this.ctx,f,i,e,r;if(Object.prototype.toString.call(t)=="[object Array]"){for(f=o.createLinearGradient(0,0,0,this.svgObj.height),i=0;i<=t.length-1;i++)e=t[i].color,r=t[i].colorStop.slice(0,-1),r=parseInt(r)/100,f.addColorStop(r,e);u=f}else u=t;return u},drawLine:function(n){this.ctx.save();this.ctx.beginPath();this.ctx.lineWidth=n["stroke-width"];this.ctx.strokeStyle=n.stroke;this.ctx.moveTo(n.x1,n.y1);this.ctx.lineTo(n.x2,n.y2);this.ctx.stroke();this.ctx.restore()},drawText:function(t,i,r){var o,u,k,g,w,a,e,y;ej.util.isNullOrUndefined(t["font-weight"])||t["font-weight"].toLowerCase()!="regular"||(t["font-weight"]="normal");var l=t["font-style"].toLowerCase()+" "+t["font-weight"]+" "+t["font-size"]+" "+t["font-family"],f=t["text-anchor"],b=t.opacity!==undefined?t.opacity:1;if(f=="middle"&&(f="center"),t.lgndCtx)this.lgndCtx.save(),this.lgndCtx.fillStyle=t.fill,this.lgndCtx.font=l,this.lgndCtx.textAlign=f,this.lgndCtx.globalAlpha=b,t["dominant-baseline"]=="middle"&&(this.lgndCtx.textBaseline="center"),t.labelRotation?(this.lgndCtx.translate(t.x,t.y),this.lgndCtx.rotate(t.labelRotation*Math.PI/180),this.lgndCtx.fillText(i,0,0)):this.lgndCtx.fillText(i,t.x,t.y),this.lgndCtx.restore();else{if(this.ctx.save(),this.ctx.fillStyle=t.fill,this.ctx.font=l,this.ctx.textAlign=f,this.ctx.globalAlpha=b,t.baseline&&(this.ctx.textBaseline=t.baseline),t.labelRotation)if(o=0,u=t.labelRotation,u&&(t.id.indexOf("XLabel")!=-1||t.id.indexOf("YLabel")!=-1)){k="rotate("+t.labelRotation.toString()+"deg)";n(t).attr("rotateAngle",k);var d=r?r:i,v=ej.EjSvgRender.utils._measureText(d,null,l).height,p=this.createText(t,d);n(document.body).append(p);g=p.getBoundingClientRect();n(p).remove();o=g.height;u<0&&(u=360+u);w=t.transform.split(",");f=f!=undefined?f:"center";var s=parseFloat(w[1]),h=parseFloat(w[2]),c=o/2;if(t.labelPosition=="outside"?f=="start"?this.ctx.translate(s,h+c-(u<0&&u>-180||u>180?o/2:(o-v)/2)):f=="end"?this.ctx.translate(s,h+c-(u<0&&u>-180||u>180?o/2:-(o-v)/2)):this.ctx.translate(s,h+c):f=="start"?this.ctx.translate(s,h-c-(u<0&&u>-180||u>180?o/2:(o-v)/2)):f=="end"?this.ctx.translate(s,h-c-(u<0&&u>-180||u>180?o/2:-(o-v)/2)):this.ctx.translate(s,h-c),this.ctx.textAlign=f,this.ctx.rotate(u*(Math.PI/180)),typeof i=="object")for(a=i.length,e=0;e<a;e++)y=ej.EjSvgRender.utils._measureText(i[e],null,l).height,this.ctx.fillText(i[e],0,e*y);else this.ctx.fillText(i,0,0)}else this.ctx.translate(t.x,t.y),this.ctx.rotate(t.labelRotation*Math.PI/180),this.ctx.fillText(i,0,0);else if(typeof i=="object"||t.isTrackball)if(t.isTrackball&&typeof i=="string")this.ctx.fillText(i,t.x,t.y);else for(a=i.length,e=0;e<a;e++){var nt=ej.util.isNullOrUndefined(t.padding)?0:t.padding,y=ej.EjSvgRender.utils._measureText(i[e],null,l).height,tt=t.isTrackball?Number(parseInt(t["font-size"])):y;this.ctx.fillText(i[e],t.x,t.y+(tt+nt)*e)}else this.ctx.fillText(i,t.x,t.y);this.ctx.restore()}},drawZoomRect:function(t,i){var r={left:0,top:0},f,e,o,s,h=n("<div id="+t.id+"><\/div>"),u=i.model.m_AreaBounds;t.x<u.X||t.x+r.left+t.width>r.left+n(this.svgObj).width()-20?(f=this.prevWidth,o=this.prevX):(f=this.prevWidth=t.width,o=this.prevX=t.x+r.left);t.y<u.Y||t.y+r.top+t.height>r.top+u.Y+u.Height?(e=this.prevHeight,s=this.prevY):(e=this.prevHeight=t.height,s=this.prevY=t.y+r.top);n(h).css({width:f,height:e,top:s,left:o,"background-color":t.fill,"border-style":"solid",position:"absolute","border-color":t.stroke,"border-width":t["stroke-width"]});document.getElementById("chartContainer_"+this._rootId).appendChild(h[0])},zoomButton:function(t,i,r){var l=r.svgObj?r.svgObj:r.svgObject,y=r._rootId?r._rootId:r._id,o,e,c,f,s,h,a,v,u;o=i=="zoom"?"_Zoom":i=="zoomIn"?"_ZoomIn":"_ZoomOut";e={left:0,top:0};n("#"+t.zoomId).length<=0?(u=n("<div id="+l.id+o+"Btn><\/div>"),n(u).css({width:t.width,height:t.height,top:t.top+e.top,left:t.left+e.left,"background-color":t.fill,"border-style":"solid",position:"absolute","border-radius":"0.4em","border-color":t.fill,"box-sizing":"content-box","z-index":2e3}),c="http://www.w3.org/2000/svg",f=document.createElementNS(c,"svg"),f.setAttribute("id",t.zoomId),f.setAttribute("width",25),f.setAttribute("height",25),i=="zoom"?(s="M26.101,22.893l-6.605-6.174c1.414-2.781,0.897-6.267-1.496-8.504c-2.901-2.711-7.448-2.56-10.161,0.341    c-2.712,2.9-2.56,7.45,0.341,10.163c2.426,2.266,6,2.523,8.694,0.853l6.579,6.151L26.101,22.893z M10.186,16.571    c-1.715-1.604-1.805-4.293-0.203-6.009c1.605-1.715,4.295-1.805,6.009-0.201c1.715,1.603,1.805,4.293,0.202,6.007    C14.59,18.084,11.901,18.175,10.186,16.571",h="translate(-3,-3)"):i=="zoomIn"?(s="M9.0983096,4.2999878L9.0983096,9.3999634 3.9983783,9.3999634 3.9983783,12.699951 9.0983096,12.699951 9.0983096,17.799988 12.398249,17.799988 12.398249,12.699951 17.49818,12.699951 17.49818,9.5 12.398249,9.5 12.398249,4.2999878z M10.998276,0C14.298215,0 17.49818,1.3999634 19.69813,4.1999512 22.79809,8.0999756 22.79809,13.5 19.998144,17.399963L28.597992,28.299988 23.898081,32 15.398205,21.199951C10.898271,23.099976 5.5983606,21.899963 2.3983956,17.899963 -1.4015366,13.099976 -0.60156059,6.0999756 4.1983567,2.3999634 6.1983276,0.79998779 8.5983163,0 10.998276,0z",h="translate(4,4) scale(0.6)"):(s="M3.9983433,9.5L3.9983433,12.799988 17.598165,12.799988 17.598165,9.5z M10.998234,0C14.298169,0 17.498131,1.3999634 19.698108,4.1999512 22.798034,8.0999756 22.798034,13.5 19.998092,17.399963L28.597994,28.299988 23.898054,32 15.398188,21.199951C10.898259,23.099976 5.5983546,21.899963 2.398393,17.899963 -1.4015351,13.099976 -0.60155994,6.0999756 4.1983522,2.3999634 6.1983207,0.79998779 8.5983074,0 10.998234,0z",h="translate(4,4) scale(0.6)"),a={id:o+"Path",fill:t.iconColor,transform:h,d:s},v=document.createElementNS(c,"path"),n(v).attr(a).appendTo(f),u[0].appendChild(f),document.getElementById("chartContainer_"+y).appendChild(u[0])):(u=document.getElementById(l.id+o+"Btn"),n(u).css({top:t.top+e.top,left:t.left+e.left}))},panButton:function(t,i){var s=i.svgObj?i.svgObj:i.svgObject,c=i._rootId?i._rootId:i._id,f={left:0,top:0},e,u,o,h,r;n("#"+t.panId).length<=0?(r=n("<div id="+s.id+"_PanBtn><\/div>"),n(r).css({width:t.width,height:t.height,top:t.top+f.top,left:t.left+f.left,"background-color":t.fill,"border-style":"solid",position:"absolute","border-radius":"0.4em","border-color":t.fill,"box-sizing":"content-box","z-index":2e3}),e="http://www.w3.org/2000/svg",u=document.createElementNS(e,"svg"),u.setAttribute("id",t.panId),u.setAttribute("width",25),u.setAttribute("height",25),o={id:"panPath",fill:t.iconColor,transform:"translate(-3,-3)"},o.points="26.105,16 21.053,12.211 21.053,14.737 17.263,14.737 17.263,10.947 19.834,10.947 16.044,5.895 12.255,10.947 14.737,10.947 14.737,14.737 10.947,14.737 10.947,12.211 5.895,16 10.947,19.789 10.947,17.263 14.737,17.263 14.737,21.053 12.255,21.053 16.044,26.105 19.834,21.053 17.263,21.053 17.263,17.263 21.053,17.263 21.053,19.789",h=document.createElementNS(e,"polygon"),n(h).attr(o).appendTo(u),r[0].appendChild(u),document.getElementById("chartContainer_"+c).appendChild(r[0])):(r=document.getElementById(s.id+"_PanBtn"),n(r).css({top:t.top+f.top,left:t.left+f.left}))},resetZoom:function(t,i){var l=i.svgObj?i.svgObj:i.svgObject,w=i._rootId?i._rootId:i._id,e={left:0,top:0},f,r,o,a,s,v,h,y,c,p,u;n("#"+t.resetZoomId).length<=0?(u=n("<div id="+l.id+"_ResetZoom><\/div>"),n(u).css({width:t.width,height:t.height,top:t.top+e.top,left:t.left+e.left,"background-color":t.fill,"border-style":"solid","border-radius":"0.4em",position:"absolute","border-color":t.fill,"box-sizing":"content-box","z-index":2e3}),f="http://www.w3.org/2000/svg",r=document.createElementNS(f,"svg"),r.setAttribute("id",t.resetZoomId),r.setAttribute("width",25),r.setAttribute("height",25),o={id:"p1",fill:t.iconColor,transform:"translate(-3,-3)"},o.points="11.895,18.398 8.061,22.23 5.796,19.967 5.796,26.283 12.112,26.283 9.848,24.018 13.682,20.186",a=document.createElementNS(f,"polygon"),n(a).attr(o).appendTo(r),s={id:"p2",fill:t.iconColor,transform:"translate(-3,-3)"},s.points="19.691,6.072 21.955,8.337 18.121,12.172 19.908,13.959 23.742,10.123 26.007,12.389 26.007,6.072",v=document.createElementNS(f,"polygon"),n(v).attr(s).appendTo(r),h={id:"p3",fill:t.iconColor,transform:"translate(-3,-3)"},h.points="11.895,13.958 13.682,12.172 9.848,8.337 12.112,6.072 5.796,6.072 5.796,12.389 8.061,10.123",y=document.createElementNS(f,"polygon"),n(y).attr(h).appendTo(r),c={id:"p4",fill:t.iconColor,transform:"translate(-3,-3)"},c.points="19.908,18.396 18.121,20.186 21.955,24.018 19.691,26.283 26.007,26.283 26.007,19.967 23.741,22.23",p=document.createElementNS(f,"polygon"),n(p).attr(c).appendTo(r),u[0].appendChild(r),document.getElementById("chartContainer_"+w).appendChild(u[0])):(u=document.getElementById(l.id+"_ResetZoom"),n(u).css({top:t.top+e.top,left:t.left+e.left}))},drawCrosshairLine:function(t,i){var r=n("<div id="+t.id+"><\/div>");n(r).css({width:t.width,height:t.height,left:t.left,top:t.top,"border-style":t.style,opacity:t.opacity,visibility:"visible","border-color":t.stroke,"border-width":t["stroke-width"],position:t.position});n(i).append(r[0])},drawCrosshairlabel:function(t,i,r){var e=n("#"+this._rootId).offset(),f={left:0,top:0},u;n("#"+t.id).length>0?(u=document.getElementById(t.id),n(u).css({width:t.width-5,height:t.height-5,left:i.x+f.left-5,top:i.y+f.top-15,visibility:"visible",display:t.display}),document.getElementById(t.id).textContent=r):(u=n("<div id="+t.id+" style='position: absolute; z-index: 13000;'><\/div>"),n(u).css({color:i.fill,"font-family":i["font-family"],"font-size":i["font-size"],"font-weight":i["font-weight"],"font-style":i["font-style"],"background-color":t.fill,"border-style":"solid","border-color":t.stroke,"border-width":t["stroke-width"],opacity:t["fill-opacity"],"text-align":"center"}),document.getElementById(this._rootId).appendChild(u[0]))},createCrosshairCanvas:function(){var i=document.getElementById(this._rootId+"_canvas"),u=n("#"+this._rootId).offset(),t,r={left:0,top:0};return n("#secondCanvas").length?t=document.getElementById("secondCanvas"):(t=document.createElement("canvas"),n(document).find("#"+this.svgObj.id+"_CrosshairGroup").append(t),n(t).attr({id:"secondCanvas",width:i.width,height:i.height,top:r.top,left:r.left}),n(t).css({width:i.width,height:i.height,top:r.top,left:r.left})),t},drawTrackToolTip:function(t,i,r,u){var s={left:this.svgObj.offsetLeft,top:this.svgObj.offsetTop},h,e,o,f;if(n("#"+t.id).length>0)if(f=document.getElementById(t.id),n(f).css({left:t.x+s.left,top:t.y+s.top,visibility:"visible","border-box":"content-box","background-color":t.fill,color:i.fill,"border-color":t.stroke,"border-width":t["stroke-width"]}),jQuery.type(r)=="array"){for(h=0,e="",o=0;o<r.length;o++)e=e+r[o]+"<\/br>";n("#"+t.id).html(e)}else n("#"+t.id).html(r);else f=n("<div id="+t.id+" style='position: absolute; z-index: 13000;'><\/div>"),n(f).css({color:i.fill,"font-family":i["font-family"],"font-size":i["font-size"],"font-weight":i["font-weight"],"font-style":i["font-style"],width:t.width,height:t.height-u-2*t["stroke-width"],"background-color":t.fill,"border-style":"solid","text-align":"center",padding:"0px","padding-top":u/2+"px","padding-bottom":u/2+"px","border-color":t.stroke,"border-width":t["stroke-width"],opacity:t["fill-opacity"]}),document.getElementById(this._rootId).appendChild(f[0])},trackSymbol:function(t,i,r,u,f){var l=f.model.m_AreaBounds,ht=n("#"+this._rootId).offset(),d,b,h,g,nt,tt,v,e,o,w,s;if(i.startX>=l.X&&i.startX<=l.X+l.Width&&i.startY>=l.Y&&i.startY<=l.Y+l.Height)if(b=t.SeriesIndex,g=t.PointIndex,f.model.series[b].type.toLowerCase()=="bubble"&&(nt=f.model.series[b]._visiblePoints[g],h=nt.radius*2+5,t.Style.BorderColor=t.Style.Color),f.model.series[b].type.toLowerCase()=="scatter"&&ej.util.isNullOrUndefined(u))tt={cx:i.startX-2,cy:i.startY-2,r:t.ShapeSize.width/2,fill:t.Style.Color,opacity:t.Style.Opacity,stroke:t.Style.BorderColor},this.drawCircle(tt,null);else{n("#canvas_trackSymbol").length>0?(v=n("#canvas_trackSymbol"),n(v).css({visibility:"visible",display:"block"})):v=n("<div id=canvas_trackSymbol><\/div>");var y={left:i.startX,top:i.startY},c=n("<div id="+t.ID+"><\/div>"),a=y.left-(h||t.ShapeSize.width),p=y.top-(h||t.ShapeSize.height);n(c).css({left:a,top:p,"box-sizing":"content-box",position:"absolute",visibility:"visible",opacity:t.Style.Opacity,"z-index":200});e=t.ShapeSize;t.symbol=c;o={};switch(r.toLowerCase()){case"circle":n(c).css({width:h||t.ShapeSize.width+"px",height:h||t.ShapeSize.height+"px",left:h?a+h/2:a+t.ShapeSize.width/2-t.Style.BorderWidth+"px",top:h?p+h/2:p+t.ShapeSize.height/2-t.Style.BorderWidth+"px","border-style":"solid","background-color":t.Style.Color,"border-color":t.Style.BorderColor,"border-width":t.Style.BorderWidth,"border-radius":"100%"});break;case"rectangle":n(c).css({width:t.ShapeSize.width,height:t.ShapeSize.height,left:a+t.ShapeSize.width/2-t.Style.BorderWidth/2,top:p+t.Style.BorderWidth/2,"border-style":"solid","background-color":t.Style.Color,"border-color":t.Style.BorderColor,"border-width":t.Style.BorderWidth});break;case"diamond":s="M "+(i.startX+-e.width/2)+" "+i.startY+" L "+i.startX+" "+(i.startY+-t.ShapeSize.height/2)+" L "+(i.startX+t.ShapeSize.width/2)+" "+i.startY+" L "+i.startX+" "+(i.startY+t.ShapeSize.height/2)+" L "+(i.startX+-t.ShapeSize.width/2)+" "+i.startY+"z";o.direction=s;this.drawSvgShape(t,o);break;case"triangle":s="M "+(i.startX+-e.width/2)+" "+(i.startY+e.height/2)+" L "+i.startX+" "+(i.startY+-e.height/2)+" L "+(i.startX+e.width/2)+" "+(i.startY+e.height/2)+" L "+(i.startX+-e.width/2)+" "+(i.startY+e.height/2)+"z";o.direction=s;this.drawSvgShape(t,o);break;case"invertedtriangle":var s="M "+(i.startX+-e.width/2)+" "+(i.startY+e.height/2)+" L "+i.startX+" "+(i.startY+-e.height/2)+" L "+(i.startX+e.width/2)+" "+(i.startY+e.height/2)+" L "+(i.startX+-e.width/2)+" "+(i.startY+e.height/2)+"z",ft=i.startX,et=i.startY,ot="rotate(180,"+ft+","+et+")";o.direction=s;o.rotate=ot;this.drawSvgShape(t,o);break;case"cross":s="M "+(i.startX+-e.width/2)+" "+i.startY+" L "+(i.startX+e.width/2)+" "+i.startY+" M "+i.startX+" "+(i.startY+e.height/2)+" L "+i.startX+" "+(i.startY+-e.height/2)+"z";o.direction=s;this.drawSvgShape(t,o);break;case"star":s="M "+(i.startX+e.width/3)+" "+(i.startY+-e.height/2)+" L "+(i.startX+-e.width/2)+" "+(i.startY+e.height/6)+" L "+(i.startX+e.width/2)+" "+(i.startY+e.height/6)+" L "+(i.startX+-e.width/3)+" "+(i.startY+-e.height/2)+" L "+i.startX+" "+(i.startY+e.height/2)+" L "+(i.startX+e.width/3)+" "+(i.startY+-e.height/2)+"z";o.direction=s;this.drawSvgShape(t,o);break;case"hexagon":s="M "+(i.startX+-e.width/2)+" "+i.startY+" L "+(i.startX+-e.width/4)+" "+(i.startY+-e.height/2)+" L "+(i.startX+e.width/4)+" "+(i.startY+-e.height/2)+" L "+(i.startX+e.width/2)+" "+i.startY+" L "+(i.startX+e.width/4)+" "+(i.startY+e.height/2)+" L "+(i.startX+-e.width/4)+" "+(i.startY+e.height/2)+" L "+(i.startX+-e.width/2)+" "+i.startY+"z";o.direction=s;this.drawSvgShape(t,o);break;case"wedge":s="M "+(i.startX-e.width)+" "+i.startY+" L "+(i.startX+e.width)+" "+(i.startY+-e.height/2)+" L "+(i.startX+3*(e.width/4))+" "+i.startY+" L "+(i.startX+e.width)+" "+(i.startY+e.height/2)+" L "+(i.startX-e.width)+" "+i.startY+"z";o.direction=s;this.drawSvgShape(t,o);break;case"trapezoid":s="M "+(i.startX+-e.width/2)+" "+i.startY+" L "+(i.startX+-e.width/2)+" "+(i.startY+-e.height/4)+" L "+(i.startX+-e.width/2+e.width)+" "+(i.startY+-e.height/2)+" L "+(i.startX+-e.width/2+e.width)+" "+(i.startY+e.height/2)+" L "+(i.startX+-e.width/2)+" "+(i.startY+e.height/4)+" L "+(i.startX+-e.width/2)+" "+i.startY+"z";o.direction=s;this.drawSvgShape(t,o);break;case"uparrow":s="M "+(i.startX-e.width/2+e.width/4)+" "+(i.startY-e.height/2+e.height)+" L "+(i.startX-e.width/2+e.width/4)+" "+(i.startY-e.height/2+e.height/2)+" L "+(i.startX-e.width/2)+" "+(i.startY-e.height/2+e.height/2)+" L "+i.startX+" "+(i.startY-e.height/2)+" L "+(i.startX+e.width/2)+" "+(i.startY-e.height/2+e.height/2)+" L "+(i.startX+e.width/2-e.width/4)+" "+(i.startY-e.height/2+e.height/2)+" L "+(i.startX+e.width/2-e.width/4)+" "+(i.startY-e.height/2+e.height)+" L "+(i.startX-e.width/2+e.width/4)+" "+(i.startY-e.height/2+e.height)+"z";o.direction=s;this.drawSvgShape(t,o);break;case"downarrow":s="M "+(i.startX-e.width/2+e.width/4)+" "+(i.startY-e.height/2)+" L "+(i.startX+e.width/2-e.width/4)+" "+(i.startY-e.height/2)+" L "+(i.startX+e.width/2-e.width/4)+" "+(i.startY-e.height/2+e.height/2)+" L "+(i.startX+e.width/2)+" "+(i.startY-e.height/2+e.height/2)+" L "+i.startX+" "+(i.startY-e.height/2+e.height)+" L "+(i.startX-e.width/2)+" "+(i.startY-e.height/2+e.height/2)+" L "+(i.startX-e.width/2+e.width/4)+" "+(i.startY-e.height/2+e.height/2)+" L "+(i.startX-e.width/2+e.width/4)+" "+(i.startY-e.height/2)+"z";o.direction=s;this.drawSvgShape(t,o);break;case"leftarrow":s="M "+(i.startX-e.width/2+e.width)+" "+(i.startY+e.height/4)+" L "+(i.startX-e.width/2+e.width)+" "+(i.startY+-e.height/4)+" L "+(i.startX-e.width/2+e.width/2)+" "+(i.startY+-e.height/4)+" L "+(i.startX-e.width/2+e.width/2)+" "+(i.startY+-e.height/2)+" L "+(i.startX-e.width/2)+" "+i.startY+" L "+(i.startX-e.width/2+e.width/2)+" "+(i.startY+e.height/2)+" L "+(i.startX-e.width/2+e.width/2)+" "+(i.startY+e.height/4)+" L "+(i.startX-e.width/2+e.width)+" "+(i.startY+e.height/4)+"z";o.direction=s;this.drawSvgShape(t,o);break;case"rightarrow":s="M "+(i.startX-e.width/2)+" "+(i.startY+e.height/4)+" L "+(i.startX-e.width/2)+" "+(i.startY+-e.height/4)+" L "+(i.startX-e.width/2+e.width/2)+" "+(i.startY+-e.height/4)+" L "+(i.startX-e.width/2+e.width/2)+" "+(i.startY+-e.height/2)+" L "+(i.startX-e.width/2+e.width)+" "+i.startY+" L "+(i.startX-e.width/2+e.width/2)+" "+(i.startY+e.height/2)+" L "+(i.startX-e.width/2+e.width/2)+" "+(i.startY+e.height/4)+" L "+(i.startX-e.width/2)+" "+(i.startY+e.height/4)+"z";o.direction=s;this.drawSvgShape(t,o);break;case"pentagon":var h=Math.sqrt(e.height*e.height+e.width*e.width)/2,k=ej.EjSvgRender.utils._getStringBuilder();for(w=0;w<=5;w++){var st=w*72,it=Math.PI/180*st,rt=h*Math.cos(it),ut=h*Math.sin(it);w==0?k.append("M "+(i.startX+rt)+" "+(i.startY+ut)+" "):k.append("L "+(i.startX+rt)+" "+(i.startY+ut)+" ")}k.append("z");s=k.toString();o.direction=s;this.drawSvgShape(t,o);break;case"ellipse":n(c).css({width:t.ShapeSize.width,height:t.ShapeSize.height/2,"border-style":"solid",left:a+t.ShapeSize.height/2-t.Style.BorderWidth/2,top:i.startY+y.top-t.ShapeSize.height+4,"background-color":t.Style.Color,"border-color":t.Style.BorderColor,"border-width":t.Style.BorderWidth,"-moz-border-radius":"50%","-webkit-border-radius":"50%","border-radius":"50%","border-box":"content-box"});break;case"horizline":n(c).css({width:t.ShapeSize.width,height:0,"border-style":"solid",left:a+t.ShapeSize.width/2,top:i.startY+y.top-1,"border-color":t.Style.BorderColor,"border-width":"2px","border-box":"content-box"});break;case"vertline":n(c).css({width:0,height:t.ShapeSize.height,"border-style":"solid",left:i.startX+y.left-1,top:p+t.ShapeSize.height/2-2,"border-color":t.Style.BorderColor,"border-width":"2px","border-box":"content-box"});break;default:n(c).css({width:t.ShapeSize.width,height:t.ShapeSize.height,"border-style":"solid","background-color":t.Style.Color,"border-color":t.Style.BorderColor,"border-width":t.Style.BorderWidth,"border-radius":"50px"})}v[0].appendChild(c[0]);d=document.getElementById(this.svgObj.id+"_CrosshairGroup")||document.getElementById("chartContainer_"+this._rootId);d.appendChild(v[0])}},drawSvgShape:function(t,i){var f=document.getElementById(this._rootId+"_canvas"),e={left:0,top:0},o="http://www.w3.org/2000/svg",r=document.createElementNS(o,"svg"),u,s;r.setAttribute("id","mySVG");r.setAttribute("width",n(f).width());r.setAttribute("height",n(f).height());n(t.symbol).css({left:e.left+"px",top:e.top+"px"});u={id:"svgPath","fill-opacity":t.Style.Opacity,"stroke-width":t.Style.BorderWidth,fill:t.Style.Color,transform:i.rotate,stroke:t.Style.BorderColor};u.d=i.direction;s=document.createElementNS(o,"path");n(s).attr(u).appendTo(r);t.symbol[0].appendChild(r)},drawCircle:function(n,t){var r,i,u;n.lgndCtx?(u=this.lgndCtx,this.lgndCtx=t!=undefined?t:this.lgndCtx,this.lgndCtx.save(),this.lgndCtx.beginPath(),this.lgndCtx.arc(n.cx,n.cy,n.r,0,2*Math.PI),this.lgndCtx.fillStyle=n.fill,this.lgndCtx.globalAlpha=n.opacity,this.lgndCtx.fill(),this.lgndCtx.lineWidth=n["stroke-width"],this.lgndCtx.strokeStyle=n.stroke,this.lgndCtx.stroke(),this.lgndCtx.restore(),this.lgndCtx=u):(r=this.ctx,this.ctx=t!=undefined?t:this.ctx,this.ctx.save(),this.ctx.beginPath(),this.ctx.arc(n.cx,n.cy,n.r,0,2*Math.PI),this.ctx.fillStyle=n.fill,this.ctx.globalAlpha=n.opacity,this.ctx.fill(),this.ctx.lineWidth=n["stroke-width"],i=n["stroke-dasharray"]?n["stroke-dasharray"].split(","):!1,i&&this.ctx.setLineDash(i),this.ctx.strokeStyle=n.stroke,this.ctx.stroke(),this.ctx.restore(),this.ctx=r)},drawPolyline:function(n){var i,t;for(this.ctx.save(),this.ctx.beginPath(),i=n.points.split(" "),t=0;t<i.length-1;t++){var r=i[t].split(","),u=r[0],f=r[1];t==0?this.ctx.moveTo(u,f):this.ctx.lineTo(u,f)}this.ctx.lineWidth=n["stroke-width"];this.ctx.strokeStyle=n.stroke;this.ctx.stroke();this.ctx.restore()},drawPolygon:function(){},setFillAttribute:function(){},setStrokeAttribute:function(){},changePathValue:function(){},drawArc:function(){},changeVMLStyle:function(){},applyVMLStyle:function(){},drawEllipse:function(n,t){var f=this.ctx;this.ctx=t!=undefined?t:this.ctx;var i=Math.max(n.rx,n.ry),r=n.rx/i,u=n.ry/i;n.lgndCtx?(this.lgndCtx.save(),this.lgndCtx.beginPath(),this.lgndCtx.translate(n.rx,n.ry),this.lgndCtx.scale(r,u),this.lgndCtx.arc(n.cx-n.rx,n.cy*2-n.rx,n.rx,0,2*Math.PI,!1),this.lgndCtx.fillStyle=n.fill,this.lgndCtx.fill(),this.lgndCtx.restore(),this.lgndCtx.lineWidth=n["stroke-width"],this.lgndCtx.strokeStyle=n.stroke,this.lgndCtx.stroke(),this.lgndCtx.restore()):(this.ctx.save(),this.ctx.beginPath(),this.ctx.translate(n.cx,n.cy),this.ctx.save(),this.ctx.scale(r,u),this.ctx.arc(0,0,i,0,2*Math.PI,!1),this.ctx.fillStyle=n.fill,this.ctx.fill(),this.ctx.restore(),this.ctx.lineWidth=n["stroke-width"],this.ctx.strokeStyle=n.stroke,this.ctx.stroke(),this.ctx.restore(),this.ctx=f)},_getAttrVal:function(t,i,r){var u=n(t).attr(i);return u!=null?u:r},_setAttr:function(){},setSpanAttr:function(){},_textAttrReplace:function(){},drawImage:function(n){this.ctx.save();var i=this,t=new Image;t.src=n.href;t.onload=function(){i.ctx.drawImage(t,n.x,n.y,n.width,n.height)};this.ctx.restore()},createDefs:function(){},createGroup:function(){},createText:function(t,i){var r=document.createElement("div");return n(r).css({transform:t.rotateAngle,"font-family":parseFloat(t["font-family"]),"font-size":parseFloat(t["font-size"])*1.1,position:"absolute"}),ej.util.isNullOrUndefined(i)||(r.textContent=i),r},drawAxesBoundsClipPath:function(n,t){var i=t},getAttrVal:function(){},hexFromRGB:function(){},createDelegate:function(){},drawClipPath:function(){},drawCircularClipPath:function(){},append:function(t,i){n(t).appendTo(i)},createLegendCanvas:function(n){return this.legendsvgObj=document.createElement("canvas"),this._rootId=jQuery(n).attr("id"),this.legendsvgObj.setAttribute("id","legend_"+this._rootId+"_canvas"),this.lgndCtx=this.legendsvgObj.getContext("2d"),this.legendsvgObj}}}(jQuery);ej.EjSvgRender=function(n){var t,i;if(this.svgLink="http://www.w3.org/2000/svg",this.svgObj=document.createElementNS(this.svgLink,"svg"),this._rootId=jQuery(n).attr("id"),t=this._rootId+"_svg",$(document).find("#"+t).length>0){i=0;do i++;while($(document).find("#"+this._rootId+"_svg"+i).length>0);t=this._rootId+"_svg"+i}this.svgObj.setAttribute("id",t)},function(n){function t(n,t,i,r){var u=r*Math.PI/180,f=n+i*Math.cos(u),e=t+i*Math.sin(u);return[f,e]}ej.EjSvgRender.prototype={drawPath:function(t,i){if(n("#"+t.id).length>0)n("#"+t.id).attr(t);else{var r=document.createElementNS(this.svgLink,"path");n(r).attr(t).appendTo(i)}},createLegendSvg:function(n){return this.svgLink="http://www.w3.org/2000/svg",this.legendsvgObj=document.createElementNS(this.svgLink,"svg"),this._rootId=jQuery(n).attr("id"),this.legendsvgObj.setAttribute("id","legend_"+this._rootId+"_svg"),this.legendsvgObj},drawPolyline:function(t,i){if(n("#"+t.id).length>0)n("#"+t.id).attr(t);else{var r=document.createElementNS(this.svgLink,"polyline");n(r).attr(t).appendTo(i)}},drawLine:function(t,i){if(n("#"+t.id).length>0)n("#"+t.id).attr(t);else{var r=document.createElementNS(this.svgLink,"line");n(r).attr(t);n(r).appendTo(i)}},drawPolygon:function(t,i){if(n("#"+t.id).length>0)n("#"+t.id).attr(t);else{var r=document.createElementNS(this.svgLink,"polygon");n(r).attr(t);n(r).appendTo(i)}},drawCircle:function(t,i){if(n("#"+t.id).length>0)n("#"+t.id).attr(t);else{var r=document.createElementNS(this.svgLink,"circle");n(r).attr(t).appendTo(i)}},drawEllipse:function(t,i){if(n("#"+t.id).length>0)n("#"+t.id).attr(t);else{var r=document.createElementNS(this.svgLink,"ellipse");n(r).attr(t).appendTo(i)}},drawRect:function(t,i){if(n("#"+t.id).length>0)n("#"+t.id).attr(t);else{var r=document.createElementNS(this.svgLink,"rect");n(r).attr(t).appendTo(i)}},drawCylinder:function(t,i,r){var d,ot,y;if(n("#"+t.id).length>0)n("#"+t.id).attr(t);else{var rt=t.x,s=t.y,g=t.id,h=t.fill,st=h,ht=this.checkColorFormat(h);ht||(h=ej.datavisualization.Chart.prototype.colorNameToHex(h));var a,v,p,w,l,e,b,nt,ut=2,tt,k,ft=0,et=0,c,it={svgRenderer:this};if(r.isColumn==!0){var o=t.width/2,u=t.height,f=o/4;l=tt=rt;e=f<s?s-f:r.stacking?s+f:s-f;k=e;a=2*o;v=0;p=0;w=f<s?u:u<2*f?u:r.stacking?u-2*f:u;b=l;nt=f<s?e+u:u<e?u+e:r.stacking?u+(s-f):u+e;ft=100;(r.stacking=!0)&&(r.isLastSeries||(e=k=s+f,w=u<o/2?u:u-o/2))}else{var f=t.height/2,u=t.width,o=f/4;e=k=s;l=tt=rt+o;a=0;v=2*f;p=u;w=0;b=l+u;nt=e;et=100;(r.stacking=!0)&&(r.isLastSeries||(b=l+u-o*2,p=u-o*2))}for(delete t.x,delete t.y,delete t.width,delete t.height,delete t.isColumn;ut--;)c="M"+l.toString()+","+e.toString(),c+="a"+o.toString()+","+f.toString()+" 0 1,0 "+a.toString()+","+v.toString(),c+="a"+o.toString()+","+f.toString()+" 0 1,0 "+(-1*a).toString()+","+(-1*v).toString(),t.d=c,t.id=g+"_Region_"+ut,t.fill=ej.Ej3DRender.prototype.polygon3D.prototype.applyZLight(h,it),this.drawPath(t,i),l=b,e=nt;c="M"+tt.toString()+","+k.toString();c+="a"+o.toString()+","+f.toString()+" 0 1,0 "+a.toString()+","+v.toString();c+="l"+p.toString()+" "+w.toString();c+="a"+o.toString()+","+f.toString()+" 0 1,1 "+(-1*a).toString()+","+(-1*v).toString()+" z";t.d=c;t.id=g+"_Region_2";st.indexOf("url")==-1&&(d=g,n("#"+d).length==0&&(ot={id:d,x1:"0%",y1:"0%",x2:ft.toString()+"%",y2:et.toString()+"%"},y=[],y[0]={colorStop:"0%",color:h},y[1]={colorStop:"30%",color:ej.Ej3DRender.prototype.polygon3D.prototype.applyXLight(h,it)},y[2]={colorStop:"70%",color:ej.Ej3DRender.prototype.polygon3D.prototype.applyXLight(h,it)},y[3]={colorStop:"100%",color:h},this.drawGradient(ot,y,i)),t.fill="url(#"+d+")");this.drawPath(t,i)}},createGradientElement:function(n,t,i,r,u,f,e){var o,s,h;return Object.prototype.toString.call(t)=="[object Array]"?(s={id:this.svgObj.id+"_"+n+"Gradient",x1:i+"%",y1:r+"%",x2:u+"%",y2:f+"%"},h="#"+this.svgObj.id+"_"+n+"Gradient",this.drawGradient(s,t,e),o="url(#"+this.svgObj.id+"_"+n+"Gradient)"):o=t,o},drawGradient:function(t,i,r){var o=this.createDefs(),f=document.createElementNS(this.svgLink,"linearGradient"),u,e;for(n(f).attr(t),u=0;u<i.length;u++)e=document.createElementNS(this.svgLink,"stop"),n(e).attr({offset:i[u].colorStop,"stop-color":i[u].color,"stop-opacity":1}),n(e).appendTo(f);n(f).appendTo(o);n(o).appendTo(r)},drawText:function(t,i,r,u){var e,o,h,f,s,c;if(n("#"+t.id).length>0)this._textAttrReplace(t,i,u);else{if(e=document.createElementNS(this.svgLink,"text"),o=n(e),jQuery.type(i)=="array")for(h=0,o.attr(t),f=0;f<i.length;f++)s=document.createElementNS(this.svgLink,"tspan"),s.textContent=i[f],n(s).attr({x:t.x,dy:h}),n(s).appendTo(e),u=this.enable3D?u.font:u,c=ej.EjSvgRender.utils._measureText(i[f],null,u),h=t.isTrackball?c.height+2:c.height;else e.textContent=i,o.attr(t);o.appendTo(r)}},_textAttrReplace:function(t,i,r){var f,e,u,o,s;if(n("#"+t.id).attr(t),jQuery.type(i)=="array")if(f=n("#"+t.id).children("tspan"),e=0,f.length>0&&f.length==i.length)for(u=0;u<f.length;u++)o=f[u],n(o).attr({x:t.x,dy:e}),o.textContent=i[u],s=ej.EjSvgRender.utils._measureText(i[u],null,r),e=s.height+2;else n("#"+t.id).remove(),this.drawText(t,i,this.gTransToolEle,r);else n("#"+t.id).text(i)},drawImage:function(t,i){var r=document.createElementNS(this.svgLink,"image");r.setAttributeNS(null,"height",t.height);r.setAttributeNS(null,"width",t.width);r.setAttributeNS("http://www.w3.org/1999/xlink","href",t.href);r.setAttributeNS(null,"x",t.x);r.setAttributeNS(null,"y",t.y);r.setAttributeNS(null,"id",t.id);r.setAttributeNS(null,"visibility",t.visibility);ej.util.isNullOrUndefined(t.clippath)&&ej.util.isNullOrUndefined(t.preserveAspectRatio)||(r.setAttributeNS(null,"clip-path",t.clippath),r.setAttributeNS(null,"preserveAspectRatio",t.preserveAspectRatio));n(r).appendTo(i)},createDefs:function(){return document.createElementNS(this.svgLink,"defs")},createClipPath:function(t){var i=document.createElementNS(this.svgLink,"clipPath");return n(i).attr(t),i},createForeignObject:function(t){var i=document.createElementNS(this.svgLink,"foreignObject");return n(i).attr(t),i},createGroup:function(t){var i=document.createElementNS(this.svgLink,"g");return n(i).attr(t),i},createPattern:function(n,t){var r=document.createElementNS(this.svgLink,t);for(var i in n)n.hasOwnProperty(i)&&r.setAttribute(i,n[i]);return r},createText:function(t,i){var r=document.createElementNS(this.svgLink,"text");return n(r).attr(t),ej.util.isNullOrUndefined(i)||(r.textContent=i),r},createPath:function(t){var i=document.createElementNS(this.svgLink,"path");return n(i).attr(t),i},createCircle:function(t){var i=document.createElementNS(this.svgLink,"circle");return n(i).attr(t),i},createLine:function(t){var i=document.createElementNS(this.svgLink,"line");return n(i).attr(t),i},_getAttrVal:function(t,i,r){var u=n(t).attr(i);return u!=null?u:r},hexFromRGB:function(t){var r=t.R,u=t.G,f=t.B,i;return t.A?"rgba("+r.toString()+","+u.toString()+","+f.toString()+","+t.A+")":(i=[r.toString(16),u.toString(16),f.toString(16)],n.each(i,function(n,t){t.length===1&&(i[n]="0"+t)}),"#"+i.join("").toUpperCase())},checkColorFormat:function(n){return/(rgba?\((?:\d{1,3}[,\)]){3}(?:\d+\.\d+\))?)|(^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$)/gmi.test(n)},hexToRGB:function(n){var i=/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/.test(n),t;return i==!0?(t=/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/.exec(n),t?{R:parseInt(t[1]),G:parseInt(t[2]),B:parseInt(t[3]),A:t[4]}:null):(t=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(n),t?{R:parseInt(t[1],16),G:parseInt(t[2],16),B:parseInt(t[3],16)}:null)},createDelegate:function(n,t){return function(i){t.apply(n,[i,this])}},drawClipPath:function(t,i){if(n(i).find("#"+t.id).length>0)n(i).find("#"+t.id).attr(t);else{var r=this.createDefs(),u=this.createClipPath({id:t.id});t.id=t.id+"_Rect";this.drawRect(t,u);this.append(u,r);this.append(r,i)}},drawCircularClipPath:function(n,t){var i=this.createDefs(),r=this.createClipPath({id:n.id});this.drawCircle(n,r);this.append(r,i);this.append(i,t)},append:function(t,i){n(t).appendTo(i)},_setAttr:function(t,i){n(t).attr(i)}};ej.EjSvgRender.commonChartEventArgs={cancel:!1,data:null};ej.EjSvgRender.utils={_decimalPlaces:function(n){var t=(""+n).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);return t?Math.max(0,(t[1]?t[1].length:0)-(t[2]?+t[2]:0)):0},_getLabelContent:function(n,t,i){switch(t._categoryValueType){case"number":var r=ej.util.isNullOrUndefined(t.labelFormat)?null:t.labelFormat.match("{value}");return ej.util.isNullOrUndefined(t.labelFormat)?t.labels[Math.floor(n)]:r!=null?t.labelFormat.replace("{value}",t.labels[Math.floor(n)]):ej.format(t.labels[Math.floor(n)],t.labelFormat,i);case"date":return ej.format(new Date(t.labels[Math.floor(n)]),ej.util.isNullOrUndefined(t.labelFormat)?"dd/MM/yyyy":t.labelFormat,i);case"string":return t.labels[Math.floor(n)];default:return""}},_getSeriesTemplateSize:function(t,i,r,u,f){var t,i,a=f.model.AreaType,o=f._id,v=n.inArray(r,f.model._visibleSeries),s,h,e,c,l;s=n("#template_group_"+o).length!=0?n("#template_group_"+o):n("<div><\/div>").attr("id","template_group_"+o);s.css("position","relative").css("z-index",1e3);h=n("#"+r.marker.dataLabel.template).clone();n(h).attr("id",r.marker.dataLabel.template+"_"+v+"_"+i+"_"+o);e=n(h);e.css("position","absolute");t.count=1;c={series:r,point:t};e.html(e.html().parseTemplate(c));l=a=="cartesianaxes"||!r.enableAnimation||r.type.toLowerCase()=="pyramid"||r.type.toLowerCase()=="funnel"?"block":"none";e.css("display",l).appendTo(n(s));n(s).appendTo("#"+o);t.size={height:e.height(),width:e.width()};u?((ej.util.isNullOrUndefined(r.LeftLabelMaxHeight)||r.LeftLabelMaxHeight<t.size.height)&&(r.LeftLabelMaxHeight=t.size.height),(ej.util.isNullOrUndefined(r.LeftLabelMaxWidth)||r.LeftLabelMaxWidth<t.size.width)&&(r.LeftLabelMaxWidth=t.size.width)):((ej.util.isNullOrUndefined(r.RightLabelMaxHeight)||r.RightLabelMaxHeight<t.size.height)&&(r.RightLabelMaxHeight=t.size.height),(ej.util.isNullOrUndefined(r.RightLabelMaxWidth)||r.RightLabelMaxWidth<t.size.width)&&(r.RightLabelMaxWidth=t.size.width))},getMinPointsDelta:function(t,i,r){var f=i,u=Number.MAX_VALUE;return n.each(f.model._visibleSeries,function(i,e){var o,h,s;e.visibility.toLowerCase()=="visible"&&t.name==e._xAxisName&&(o=ej.DataManager(e.points,ej.Query().sortBy("xValue")).executeLocal(),o.length!=1||f.currentSeries&&f.currentSeries._yAxisName.toLowerCase()!=e._yAxisName.toLowerCase()?n.each(o,function(n,t){if(n>0&&t.xValue){var i=t.xValue-o[n-1].xValue;i!=0&&(u=Math.min(u,i))}}):(h=ej.util.isNullOrUndefined(r)?e.xAxis.visibleRange.min:r,s=o[0].xValue-h,s!=0&&(u=Math.min(u,s))))}),u==Number.MAX_VALUE&&(u=1),u},_getSeriesMaxLabel:function(t){var i={width:0,height:0},s=n(this.svgObject).width(),e=[],o,h,r,f,u;if(t.labels.length>0){for(u=0;u<t.labels.length;u++)r=this._measureText(t.visibleLabels[u],s,t.marker.dataLabel.font),i.width<r.width&&(i.width=r.width),i.height<r.height&&(i.height=r.height);t.LabelMaxHeight=i.height;t.LabelMaxWidth=i.width}else for(e.push(t.rightsidePoints),e.push(t.leftsidePoints),f=0;f<e.length;f++){for(u=0;u<e[f].length;u++)o=e[f][u],h=o.text?o.text:o.y,r=this._measureText(h,s,t.marker.dataLabel.font),i.width<r.width&&(i.width=r.width),i.height<r.height&&(i.height=r.height);f==0?(t.RightLabelMaxHeight=i.height,t.RightLabelMaxWidth=i.width):(t.LeftLabelMaxHeight=i.height,t.LeftLabelMaxWidth=i.width)}},_getHighestLabel:function(t,i,r){var c,y=0,f=[],o,s,e=0,v,l,h,a,u;if(ej.isNullOrUndefined(r))for(l=t.labels.length==0?t.visibleLabels:t.labels,h=0;h<l.length;h++){for(a=t.labels.length==0?l[h].Text:l[h],e=0,a.indexOf("<br>")!=-1?f=a.split("<br>"):f.push(a),u=0;u<f.length;u++)o=f[u],s=this._measureText(o,n(i.svgObject).width(),t.font).width,e<s&&(e=s,c=o);y<e&&(y=e,v=c)}else if(r&&(typeof r=="string"&&r.indexOf("<br>")!=-1||typeof r=="object"))for(e=0,f=typeof r=="object"?r:r.split("<br>"),u=0;u<f.length;u++)o=typeof f[u]=="object"?f[u].Text:f[u],s=this._measureText(o,i,t.font).width,e<s&&(e=s,c=o),v=c;return v},_getMaxLabelWidth:function(t,i){var e,g,ot,yt,pi,nt,a,rt,st,kt,p,ei,tt,l,ct,u,d,it,oi,dt,gt,lt,c,ni,s,ti,at,tr,ir;this.chartObj=i;var r={width:0,height:0,maxHeight:0,maxWidth:0},o="",hi=1,rr=i.svgRenderer.vmlNamespace,y=t.visibleRange,h=t.labelIntersectAction?t.labelIntersectAction.toLowerCase():"",vt=t.labelPlacement,ur=t.opposedPosition,ii=t.orientation.toLowerCase(),ci=i.model.requireInvertedAxes?ii=="vertical":ii=="horizontal",li=t.roundingPlaces,f=t.labelRotation,ii=t.orientation,k=0,et=t.visibleLabels,fr=et.length,ai,vi,yi,ri,ui;if(t.visible){for(e=0;e<fr;e++)t.visibleLabels[e].y=0,typeof t.visibleLabels[e].Text=="string"&&t.visibleLabels[e].Text.indexOf("<br>")!=-1&&t.orientation=="vertical"?(ai=t.visibleLabels[e].Text.split("<br>"),vi=this._getHighestLabel(t,n(this.svgObject).width(),ai),g=this._measureText(vi,n(this.svgObject).width(),t.font,t.labelRotation)):g=this._measureText(t.visibleLabels[e].Text,n(this.svgObject).width(),t.font,t.labelRotation),r.width<g.width&&(r.width=g.width,o=t.visibleLabels[e].Text),r.height<g.height&&(r.height=g.height);if((t.enableTrim||h=="trim"&&t.orientation!="vertical")&&(ot=t.maximumLabelWidth,r.width=r.width>ot?ot:r.width),r.rows=1,r.maxWidth=r.width,r.maxHeight=r.height,!rr&&(f||h)&&(yt=0,h=="rotate45"?yt=45:h=="rotate90"&&(yt=90),f=f!=null||ii=="vertical"?f:yt,t.rotationValue=f,f)){if(o=ej.isNullOrUndefined(o)?"":o,pi=this._measureText(o,n(this.svgObject).width(),t.font,t.labelRotation),(t.enableTrim||h=="trim")&&pi.width>ot&&o!="")for(a=o,p=1;p<a.toString().length;p++)if(a=a.toString().substring(0,p)+"... ",nt=this._measureText(a,n(i.svgObject).width(),t.font),nt.width>=ot){a=a.toString().substring(0,p-1)+"... ";o=a;break}o=(h||t.enableTrim)&&f?typeof o=="string"&&o.indexOf("<br>")!=-1?this._getHighestLabel(t,i,null):o:this._getHighestLabel(t,i,null);tt=this.rotatedLabel(t,i,f,o);t.labelIntersectAction&&t.labelIntersectAction.toLowerCase()=="multiplerows"&&(k=r.height+tt.height);r.height=t.rowsCount&&t.rowsCount>1&&f!=90&&t.enableTrim?t.rowsCount*r.height:tt.height;r.width=tt.width}if(t.labelIntersectAction)if(t.rowsCount&&(h=="none"||h=="trim"||h=="hide"||f==0)&&(h!="wrap"||t.enableTrim)&&(h!="wrapbyword"||t.enableTrim)&&(h!="multiplerows"||t.enableTrim))f==0&&(r.rows=t.rowsCount,r.height=t.rowsCount*r.height);else if(h=="wrap"||h=="wrapbyword"){if(vt=vt?vt:ej.datavisualization.Chart.LabelPlacement.BetweenTicks,vt.toLowerCase()=="betweenticks"?(st=1+(t.labels.length>1?-.5:0),st=li?parseFloat(st.toFixed(li)):parseFloat(st.toFixed(ej.EjSvgRender.utils._decimalPlaces(y.interval)==0?1:ej.EjSvgRender.utils._decimalPlaces(y.interval))),rt=Math.ceil((st-y.min)/(y.max-y.min)*t.length)):rt=Math.ceil(t.length/et.length),t.orientation=="horizontal"){var ht=0,wi=0,bi,ut=t.labels.length>0&&t.valueType!="datetimecategory"?t.labels:t.visibleLabels,er=t.width?t.width/ut.length:(t.length-(i.svgWidth-t.length)-20)/ut.length;for(t.labelsCollection=[],c=0;c<ut.length;c++){var pt=0,fi=[],wt=[],bt=typeof ut[c]=="object"?ut[c].Text:ut[c];for(typeof bt=="string"&&bt.indexOf("<br>")!=-1?wt=bt.split("<br>"):wt.push(bt),s=0;s<wt.length;s++)for(kt=ej.EjAxisRenderer.prototype.rowscalculation(wt[s],i.model.m_AreaBounds,t,er,null),pt=kt.length+pt,p=0;p<kt.length;p++)fi.push(kt[p]);f&&(o=this._getHighestLabel(t,i,fi),ei=this._measureText(o,n(i.svgObject).width(),t.font).width,wi<ei&&(wi=ei,bi=o));ht=Math.max(pt,ht);t.labelsCollection[c]=fi}tt=this.rotatedLabel(t,i,f,bi)}rt=rt<0?Math.ceil(t.length/et.length):rt;l=Math.round(r.width/rt);r.rows=f?l-hi:l+hi;r.rows<0&&(r.rows=0);ct=ht&&!f?ht:r.rows;ht>l&&!f&&(ct=ct-1);r.height=f?tt.height+ct*tt.height:r.height+ct*r.height}else if(h=="multiplerows"){var or=i._getLegendSpace(),sr=i.model.border.width,wr=i.model._axes[1],hr=n(i.svgObject).width()-i.model.margin.left-i.model.margin.right;ri=t.title;ui=ri.text;var cr=ui==""||!t.visible?0:this._measureText(ui,hr,ri.font).height+2*i.model.elementSpacing,lr=i.model.elementSpacing+cr+t.majorTickLines.size+t.axisLine.width,ar=i._getYValues(i.model._visibleSeries[0].points),vr=Math.max.apply(Math,ar),ki=i.model._axes[1],g=this._measureText(vr,n(this.svgObject).width(),ki.font,ki.labelRotation),yr=or.rightLegendWidth+lr+g.width+i.model.margin.right+i.model.margin.left+2*sr,di=n(i.svgObject).width()-yr;if(ci){var ft=0,w=[],l=0,bi,wi=0;for(e=0;e<et.length;e++){u=et[e];d=[];typeof u.Text=="string"&&u.Text.indexOf("<br>")!=-1?d=u.Text.split("<br>"):d.push(u);it=d.length;oi=!1;k=Math.max(k,ft);ft=u.y=r.height;var a=this._measureText(u.Text,n(this.svgObject).width(),t.font),v=a.height,si=Math.abs(Math.floor((u.Value-y.min)/y.delta*di));if(w.length>0)for(dt=w,gt=!0,lt=0;lt<dt.length&&gt;lt++){var pt=0,b=dt[lt];for(c=0;b&&c<b.length;c++)for(s=0;s<it;s++){var nt=ej.EjSvgRender.utils._measureText(it==1?d[s].Text:d[s],n(this.svgObject).width(),t.font).width,v=ej.EjSvgRender.utils._measureText(d[s],n(this.svgObject).width(),t.font).height,gi=c==b.length?b[c-1]:b[c],pr=Math.abs(Math.floor((gi.Value-y.min)/y.delta*di)),nr=ej.EjSvgRender.utils._measureText(gi.Text,n(this.svgObject).width(),t.font).width;if(nt=nt/2,ni=pr+(t.isInversed?-nr/2:nr/2),ni>=si-nt)ft=u.y+v,u.y+=v,pt++,lt+1==dt.length&&(gt=!1);else if(c+1==b.length){gt=s==it-1?!1:!0;break}}}if(u.y=ft,l=ft/v-1,w[l]==undefined&&(w[l]=[]),it==1)w[l].push(u);else for(s=0;s<it;s++)w[l]==undefined&&(w[l]=[]),w[l].push({Text:d[s],Value:u.Value}),s!=it-1&&(l=l+1,ft=u.y+v)}k=w.length*v;r.height=r.height>k?r.height:k;v>0&&(r.rows=ur?Math.round((k+v)/v):Math.round(k/v));r.rows=f?r.rows-1:r.rows;r.rows<1&&(r.rows=1)}if(!ci){for(ti=0,e=0;e<t.visibleLabels.length;e++){for(u=t.visibleLabels[e],a=this._measureText(u.Text,n(this.svgObject).width(),t.font),nt=a.width,v=a.height,si=Math.abs(Math.floor((u.Value-t.visibleRange.min)/t.visibleRange.delta*t.length)),at=0;at<e;at++)b=t.visibleLabels[at],yi=Math.abs(Math.floor((b.Value-t.visibleRange.min)/t.visibleRange.delta*t.length)),tr=this._measureText(b.Text,n(this.svgObject).width(),t.font).height,ni=yi+tr/2,ni>si-v/2&&t.visibleLabels[at].y==u.y&&(ti=u.y+nt,u.y=ti,oi=!0);ir=ti}r.width=r.width+ir+(oi?5:0)}}}return r},rotatedLabel:function(n,t,i,r,u){var e={"font-size":n.font.size,transform:"rotate("+i+",0,0)","font-family":n.font.fontFamily,"font-style":n.font.fontStyle,rotateAngle:"rotate("+i+"deg)","text-anchor":"middle"};t=u?this.chartObj:t;var f=t.svgRenderer.createText(e,r),o=Math.ceil(this._measureBounds(f,t).height),s=Math.ceil(this._measureBounds(f,t).width);return{height:o,width:s}},_getTransform:function(n,t,i){var r,u,f,e;return i?(r=t.x,u=n.y,f=t.width,e=n.height):(r=n.x,u=t.y,f=n.width,e=t.height),{x:r,y:u,width:f,height:e}},_calculateroundedCorner:function(n,t,i,r,u,f){var e=t.x,o=t.y,c=5,l=this.chartObj.model.enableCanvasRendering&&!f?c/4:0,s=t.width,h=t.height,v,y,p,w,a;return typeof n!="object"||ej.util.isNullOrUndefined(n)?v=y=p=w=n:(v=n.topLeft,y=n.bottomLeft,p=n.topRight,w=n.bottomRight),v=ej.util.isNullOrUndefined(t.rx)?v:t.rx,y=ej.util.isNullOrUndefined(t.rx)?y:t.rx,p=ej.util.isNullOrUndefined(t.ry)?p:t.ry,w=ej.util.isNullOrUndefined(t.ry)?w:t.ry,a="M "+e+" "+(v+o)+" Q "+e+" "+o+" "+(e+v)+" "+o+" ",i&&r=="top"&&(a+="L "+(e+s/2-c/2+l)+" "+o+" L "+(e+s/2+l-u)+" "+(o-c)+" L "+(e+s/2+c/2+l)+" "+o+" "),a+="L "+(e+s-p)+" "+o+" Q "+(e+s)+" "+o+" "+(e+s)+" "+(o+p)+" ",i&&r=="right"&&(a+="L "+(e+s)+" "+(o+h/2-c/2+l)+" L "+(e+s+c)+" "+(o+h/2+l-u)+" L "+(e+s)+" "+(o+h/2+c/2+l)+" "),a+="L "+(e+s)+" "+(o+h-w)+" Q "+(e+s)+" "+(o+h)+" "+(e+s-w)+" "+(o+h)+" ",i&&r=="bottom"&&(a+="L "+(e+s/2-c/2+l)+" "+(o+h)+" L "+(e+s/2+l-u)+" "+(o+h+c)+" L "+(e+s/2+c/2+l)+" "+(o+h)+" "),a+="L "+(e+y)+" "+(o+h)+" Q "+e+" "+(o+h)+" "+e+" "+(o+h-y)+" ",i&&r=="left"&&(a+="L "+e+" "+(o+h/2-c/2+l)+" L "+(e-c)+" "+(o+h/2+l-u)+" L "+e+" "+(o+h/2+c/2+l)+" "),a+("L "+e+" "+(v+o)+" z")},browserInfo:function(){var n={},t=[],i={webkit:/(chrome)[ \/]([\w.]+)/i,safari:/(webkit)[ \/]([\w.]+)/i,msie:/(msie) ([\w.]+)/i,opera:/(opera)(?:.*version|)[ \/]([\w.]+)/i,mozilla:/(mozilla)(?:.*? rv:([\w.]+)|)/i};for(var r in i)if(i.hasOwnProperty(r)&&(t=navigator.userAgent.match(i[r]),t)){n.name=t[1].toLowerCase();n.version=t[2];!navigator.userAgent.match(/Trident\/7\./)||(n.name="msie");break}return n.isMSPointerEnabled=n.name=="msie"&&n.version>9&&window.navigator.msPointerEnabled,n.pointerEnabled=window.navigator.pointerEnabled,n},_measureText:function(t,i,r){var s=n(document).find("#measureTex"),u,e,o,f,v;n("#measureTex").css("display","block");s.length==0?(u=document.createElement("text"),n(u).attr({id:"measureTex"}),document.body.appendChild(u)):u=s[0];var h=null,c=null,l=null,a=null;if(typeof t=="string"&&(t.indexOf("<")>-1||t.indexOf(">")>-1)){for(e=t.split(" "),o=0;o<e.length;o++)e[o].indexOf("<br/>")==-1&&(e[o]=e[o].replace(/[<>]/g,"&"));t=e.join(" ")}return/<\/?[a-z][\s\S]*>/.test(t)?n(u).html(t):u.textContent=t,r!=undefined&&r.size==undefined&&(f=r,f=f.split(" "),h=f[0],c=f[1],l=f[2],a=f[3]),r!=null&&(u.style.fontSize=r.size>0?r.size+"px":r.size?r.size:c,u.style.fontStyle&&(u.style.fontStyle=r.fontStyle?r.fontStyle:h),u.style.fontFamily=r.fontFamily?r.fontFamily:l,window.navigator.userAgent.indexOf("MSIE 8.0")==-1&&(u.style.fontWeight=r.fontWeight?r.fontWeight:a)),u.style.backgroundColor="white",u.style.position="absolute",u.style.top=-100,u.style.left=0,u.style.visibility="hidden",u.style.whiteSpace="nowrap",i&&(u.style.maxwidth=i+"px"),v={width:u.offsetWidth,height:u.offsetHeight},n("#measureTex").css("display","none"),v},_trimText:function(n,t,i){var f,r,e,u;for(r=n.toString(),e=r.length,u=1;u<e;u++)if(r=n.substring(0,u)+"...",f=ej.EjSvgRender.utils._measureText(r,null,i).width,f>=t)return r.substring(0,u-1)+"... ";return n},_measureBounds:function(t,i){i.model.enableCanvasRendering?n(document.body).append(t):(i.svgRenderer.append(t,i.svgObject),i.svgRenderer.append(i.svgObject,i.element));var r=t.getBoundingClientRect(),u={left:r.left,right:r.right,top:r.top,bottom:r.bottom,width:r.right-r.left,height:r.bottom-r.top};return n(t).remove(),u},_drawAxesBoundsClipPath:function(t,i,r){var u,s=n(t),f=this._getTransform(i.xAxis,i.yAxis,r.model.requireInvertedAxes),h=r.model.AreaType=="polaraxes"?n(r.svgObject).width():f.width,c=r.model.AreaType=="polaraxes"?n(r.svgObject).height():f.height,e=r.model.requireInvertedAxes?i.yAxis.plotOffset:i.xAxis.plotOffset,o=r.model.requireInvertedAxes?i.xAxis.plotOffset:i.yAxis.plotOffset;r.model.AreaType=="polaraxes"?(u={id:t?t.id+"_ClipRect":"",cx:r.model.centerX,cy:r.model.centerY,r:r.model.Radius,fill:"white","stroke-width":1,stroke:"transparent"},r.svgRenderer.drawCircularClipPath(u,t)):(u={id:t?t.id+"_ClipRect":"",x:0-e,y:0-o,width:h+2*e,height:c+2*o,fill:"white","stroke-width":1,stroke:"transparent"},r.svgRenderer.drawClipPath(u,t));u.id.indexOf("_Rect")&&(u.id=u.id.replace("_Rect",""));s.attr("clip-path","url(#"+u.id+")")},_getStringBuilder:function(){var n=[],t=0;return{append:function(i){return n[t++]=i,this},remove:function(t,i){return n.splice(t,i||1),this},insert:function(t,i){return n.splice(t,0,i),this},toString:function(t){return n.join(t||"")}}},_addRegion:function(t,i,r,u,f){var s=r.type,e=n.inArray(r,t.model._visibleSeries),o;e>=0&&(o={SeriesIndex:e,Region:{PointIndex:f,Bounds:i},type:s},t.model.chartRegions.push(o))},AddRegion:function(n,t,i){if(i){var r={isStripLine:i,Region:{Bounds:t}};n.model.chartRegions.push(r)}},_getSvgXY:function(n,t,i,r){var u,f;return r.model.requireInvertedAxes?(u=n+i.yAxis.x,f=t+i.xAxis.y):(u=n+i.xAxis.x,f=t+i.yAxis.y),{X:u,Y:f}},_getPoint:function(n,t){var f=n.xValue,i,r,u,e=t.type=="boxandwhisker"?n.YValues:n.YValues[0],s=t._isTransposed?t.xAxis.height:t.xAxis.width,o=t._isTransposed?t.yAxis.width:t.yAxis.height;return n.location={},t._hiloTypes&&(i=n.YValues[1],i=t.yAxis._valueType=="logarithmic"?ej.EjSvgRender.utils._logBase(i==0?1:i,t.xAxis.logBase):i,i=this._getPointXY(i,t.yAxis.visibleRange,t.yAxis.isInversed),n.location.low=(t._isTransposed?i:1-i)*o),r=t.xAxis._valueType=="logarithmic"?ej.EjSvgRender.utils._logBase(f==0?1:f,t.xAxis.logBase):f,u=t.yAxis._valueType=="logarithmic"?ej.EjSvgRender.utils._logBase(e==0?1:e,t.xAxis.logBase):e,r=this._getPointXY(r,t.xAxis.visibleRange,t.xAxis.isInversed),u=this._getPointXY(u,t.yAxis.visibleRange,t.yAxis.isInversed),n.location.X=t._isTransposed?u*o:r*s,n.location.Y=t._isTransposed?(1-r)*s:(1-u)*o,n.location},_getPointXY:function(n,t,i){var r=0;return r=(n-t.min)/t.delta,r=isNaN(r)?0:r,i?1-r:r},_dateTimeLabelFormat:function(n,t){switch(n.toLowerCase()){case"years":return t._labelFormat="MMM, yyyy";case"months":return t._labelFormat="dd, MMM";case"days":return t._labelFormat="dd/MM/yyyy";case"hours":return t._labelFormat="dd, hh:mm";case"minutes":return t._labelFormat="hh:mm";case"seconds":return t._labelFormat="mm:ss";case"milliseconds":return t._labelFormat="ss:fff";default:return t._labelFormat="dd/MM/yyyy"}},_getFontString:function(n){return n==null&&(n={}),n.FontFamily||(n.FontFamily="Arial"),n.FontStyle||(n.FontStyle="Normal"),n.Size||(n.Size="12px"),n.FontStyle+" "+n.Size+" "+n.FontFamily},_valueToVector:function(n,t){return this._coefficientToVector(this._valueToPolarCoefficient(n,t))},TransformToVisible:function(n,t,i,r){t=n.xAxis._valueType=="logarithmic"&&t>0?Math.log(t,n.xAxis.logBase):t;i=n.xAxis._valueType=="logarithmic"&&i>0?Math.log(i,n.yAxis.logBase):i;var u=r.model.Radius*this._valueToCoefficient(n.yAxis,i),f=this._valueToVector(n.xAxis,t);return{X:r.model.centerX+u*f.X,Y:r.model.centerY+u*f.Y}},Transform3DToVisible:function(n,t,i,r){var u,s,h,f;if(n.xAxis!=null&&n.yAxis!=null){if(u=n.xAxis._valueType.toLowerCase(),f=u=="logarithmic"?!0:!1,t=t=f&&t>0?math.log(t,s):t,i=i,r.model.requireInvertedAxes){var e=r.model.m_AreaBounds.X,o=r.model.m_AreaBounds.Y,c=e+n.yAxis.width*ej.EjSvgRender.utils._valueToCoefficient(n.yAxis,i,r),l=o+n.xAxis.height*(1-ej.EjSvgRender.utils._valueToCoefficient(n.xAxis,t,r));return{X:c,Y:l}}var e=n.xAxis.x,o=n.yAxis.y,t=e+Math.round(n.xAxis.width*ej.EjSvgRender.utils._valueToCoefficient(n.xAxis,t,r)),i=o+Math.round(n.yAxis.height*(1-ej.EjSvgRender.utils._valueToCoefficient(n.yAxis,i,r)));return{X:t,Y:i}}return new h(0,0)},_valueToPolarCoefficient:function(n,t){var f=n.visibleRange.min,r,u,i;return n._valueType!="category"?(r=n.visibleRange.max-n.visibleRange.interval-n.visibleRange.min,u=n.visibleLabels.length-1):(r=n.visibleRange.delta,u=n.visibleLabels.length),i=(t-f)/r,i*=1-1/u,i=isNaN(i)?0:i,n.isInversed?i:1-i},_coefficientToVector:function(n){var t=Math.PI*(1.5-2*n);return{X:Math.cos(t),Y:Math.sin(t)}},_valueToCoefficient:function(n,t,i){var r;return r=i&&i.model.AreaType=="polaraxes"?t:n._valueType&&n._valueType.toLowerCase()=="logarithmic"?ej.EjSvgRender.utils._logBase(t==0?1:t,n.logBase):t,r=(r-n.visibleRange.min)/n.visibleRange.delta,n.isInversed?1-r:r},_getBoundingClientRect:function(t,i,r,u){var f=t.getBoundingClientRect(),s=n("#"+i.svgObject.id)[0].getBoundingClientRect(),e,o,h,c;return u?(e=this._getTransform(r.xAxis,r.yAxis,!0).x,o=this._getTransform(r.xAxis,r.yAxis,!0).y):(e=this._getTransform(r.xAxis,r.yAxis,!1).x,o=this._getTransform(r.xAxis,r.yAxis,!1).y),h=f.left-(e+s.left),c=f.top-(o+s.top),{x:h,y:c,width:f.right-f.left,height:f.bottom-f.top}},_minMax:function(n,t,i){return n>i?i:n<t?t:n},_inside:function(n,t){return n===""?!1:n<=t.max&&n>=t.min},_logBase:function(n,t){return Math.log(n)/Math.log(t)},_correctRect:function(n,t,i,r){return{X:Math.min(n,i),Y:Math.min(t,r),Width:Math.abs(i-n),Height:Math.abs(r-t)}},_getValuebyPoint:function(n,t,i,r){var e=r?i.xAxis.height:i.xAxis.width,o=r?i.yAxis.width:i.yAxis.height,u=i.xAxis.isInversed?1-n/e:n/e,f=i.yAxis.isInversed?1-t/o:t/o;return u=u*i.xAxis.visibleRange.delta+i.xAxis.visibleRange.min,f=f*i.yAxis.visibleRange.delta+i.yAxis.visibleRange.min,u=i.xAxis._valueType=="logarithmic"?Math.pow(i.xAxis.logBase,u):u,f=i.yAxis._valueType=="logarithmic"?Math.pow(i.yAxis.logBase,f):f,{PointX:u,PointY:f}}};ej.EjSvgRender.chartTransform3D={ToRadial:Math.PI/180,transform3D:function(n){return this.vector||(this.vector=new(new ej.Ej3DRender).vector3D,this.matrixobj=new(new ej.Ej3DRender).matrix3D,this.bsptreeobj=new(new ej.Ej3DRender).BSPTreeBuilder,this.polygon=new(new ej.Ej3DRender).polygon3D),{mViewport:n,Rotation:0,Tilt:0,Depth:0,PerspectiveAngle:0,needUpdate:!0,centeredMatrix:this.matrixobj.getIdentity(),Perspective:this.matrixobj.getIdentity(),resultMatrix:this.matrixobj.getIdentity(),viewMatrix:this.matrixobj.getIdentity(),Depth:0}},transform:function(n){this.setCenter(this.vector.vector3D(n.mViewport.Width/2,n.mViewport.Height/2,n.Depth/2),n);this.setViewMatrix(this.matrixobj.transform(0,0,n.Depth),n);this.setViewMatrix(this.matrixobj.getMatrixMultiplication(n.viewMatrix,this.matrixobj.turn(-this.ToRadial*n.Rotation)),n);this.setViewMatrix(this.matrixobj.getMatrixMultiplication(n.viewMatrix,this.matrixobj.tilt(-this.ToRadial*n.Tilt)),n);this.updatePerspective(n.PerspectiveAngle,n);n.needUpdate=!0},updatePerspective:function(n,t){var i=(t.mViewport.Width+t.mViewport.Height)*Math.tan(this.degreeToRadianConverter((180-Math.abs(n%181))/2))+t.Depth/1;t.Perspective[0][0]=i;t.Perspective[1][1]=i;t.Perspective[2][3]=1;t.Perspective[3][3]=i},degreeToRadianConverter:function(n){return n*Math.PI/180},toScreen:function(n,t,i,r){var i=i?i:this.result;return r?(this.matrixobj=r,n=r.getMatrixVectorMutiple(i(t,r),n)):(t.chartObj=this.matrixobj,n=this.matrixobj.getMatrixVectorMutiple(i(t),n)),{x:n.x,y:n.y}},setViewMatrix:function(n,t){t.viewMatrix!=n&&(t.viewMatrix=n,t.needUpdate=!0)},setCenteredMatrix:function(n,t){t.viewMatrix!=n&&(t.centeredMatrix=n,t.needUpdate=!0)},result:function(n,t){var i=n.chartObj?n.chartObj:this.matrixobj,r;return(i||(i=t),!n.needUpdate)?n.resultMatrix:(r=this.matrixobj?this.matrixobj:t,n.resultMatrix=i.getMatrixMultiplication(r.getInvertal(n.centeredMatrix),n.Perspective),n.resultMatrix=i.getMatrixMultiplication(n.resultMatrix,n.viewMatrix),n.resultMatrix=i.getMatrixMultiplication(n.resultMatrix,n.centeredMatrix),n.needUpdate=!1,n.resultMatrix)},setCenter:function(n,t){t.centeredMatrix=this.matrixobj.transform(-n.x,-n.y,-n.z);t.needUpdate=!0},toPlane:function(n,t,i){var r=this.vector.vector3D(n.x,n.y,0),u=this.vector.vector3DPlus(r,this.vector.vector3D(0,0,1));return r=this.vector.vector3DMultiply(i.centeredMatrix,r),u=this.vector.vector3DMultiply(i.centeredMatrix,u),r=this.vector.vector3DMultiply(this.matrixobj.getInvertal(i.Perspective),r),u=this.vector.vector3DMultiply(this.matrixobj.getInvertal(i.Perspective),u),r=this.polygon.getPoint(r,this.vector.vector3DMinus(u-r)),r=this.vector.vector3DMultiply(this.matrixobj.getInvertal(i.viewMatrix),r),this.vector.vector3DMultiply(this.matrixobj.getInvertal(i.centeredMatrix),r)}};ej.EjSvgRender.chartSymbol={_drawSeriesType:function(n,t,i){var r=i.model.series[t.SeriesIndex].type.toLowerCase(),u=i.legendItem.drawType;r=ej.util.isNullOrUndefined(u)?r:u;switch(r){case ej.datavisualization.Chart.Type.Line:return ej.util.isNullOrUndefined(u)?this._drawLine(n,t,i,i.gLegendItemEle):this._drawStraightLine(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.StepLine:return this._drawStepLine(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.StackingArea:case ej.datavisualization.Chart.Type.StackingArea100:case ej.datavisualization.Chart.Type.Area:case ej.datavisualization.Chart.Type.RangeArea:return this._drawArea(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.StepArea:return this._drawStepArea(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Bar:case ej.datavisualization.Chart.Type.StackingBar100:case ej.datavisualization.Chart.Type.StackingBar:return this._drawBar(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Pie:return this._drawPie(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Doughnut:return this._drawDoughnut(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Hilo:return this._drawHilo(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.HiloOpenClose:return this._drawHiloOpenClose(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Candle:return this._drawCandle(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Pyramid:return this._drawPyramid(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Funnel:return this._drawFunnel(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Spline:return this._drawSpline(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.SplineArea:case ej.datavisualization.Chart.Type.StackingSplineArea:case ej.datavisualization.Chart.Type.StackingSplineArea100:return this._drawSplineArea(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.RangeColumn:return this._drawRangeColumn(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Bubble:case ej.datavisualization.Chart.Type.Scatter:return this._drawCircle(n,t,i,i.gLegendItemEle);case ej.datavisualization.Chart.Type.Column:case ej.datavisualization.Chart.Type.StackingColumn:case ej.datavisualization.Chart.Type.StackingColumn100:case ej.datavisualization.Chart.Type.Waterfall:return this._drawColumn(n,t,i,i.gLegendItemEle);default:return this._drawRectangle(n,t,i,i.gLegendItemEle)}},_drawCircle:function(n,t,i,r){var o=i.svgRenderer,h=i.svgObject,f=t.ShapeSize,e=Math.sqrt(f.height*f.height+f.width*f.width)/2,u=t.Style,s={id:t.ID,cx:n.startX,cy:n.startY,r:e,fill:u.Color,"stroke-width":u.BorderWidth,stroke:u.BorderColor,opacity:u.Opacity,visibility:u.Visibility,lgndCtx:t.context};return o.drawCircle(s,r),n.startX-e},_drawLeftArrow:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX-u.width/2+u.width)+" "+(n.startY+u.height/4)+" L "+(n.startX-u.width/2+u.width)+" "+(n.startY+-u.height/4)+" L "+(n.startX-u.width/2+u.width/2)+" "+(n.startY+-u.height/4)+" L "+(n.startX-u.width/2+u.width/2)+" "+(n.startY+-u.height/2)+" L "+(n.startX-u.width/2)+" "+n.startY+" L "+(n.startX-u.width/2+u.width/2)+" "+(n.startY+u.height/2)+" L "+(n.startX-u.width/2+u.width/2)+" "+(n.startY+u.height/4)+" L "+(n.startX-u.width/2+u.width)+" "+(n.startY+u.height/4)+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawRightArrow:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX-u.width/2)+" "+(n.startY+u.height/4)+" L "+(n.startX-u.width/2)+" "+(n.startY+-u.height/4)+" L "+(n.startX-u.width/2+u.width/2)+" "+(n.startY+-u.height/4)+" L "+(n.startX-u.width/2+u.width/2)+" "+(n.startY+-u.height/2)+" L "+(n.startX-u.width/2+u.width)+" "+n.startY+" L "+(n.startX-u.width/2+u.width/2)+" "+(n.startY+u.height/2)+" L "+(n.startX-u.width/2+u.width/2)+" "+(n.startY+u.height/4)+" L "+(n.startX-u.width/2)+" "+(n.startY+u.height/4)+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawUpArrow:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX-u.width/2+u.width/4)+" "+(n.startY-u.height/2+u.height)+" L "+(n.startX-u.width/2+u.width/4)+" "+(n.startY-u.height/2+u.height/2)+" L "+(n.startX-u.width/2)+" "+(n.startY-u.height/2+u.height/2)+" L "+n.startX+" "+(n.startY-u.height/2)+" L "+(n.startX+u.width/2)+" "+(n.startY-u.height/2+u.height/2)+" L "+(n.startX+u.width/2-u.width/4)+" "+(n.startY-u.height/2+u.height/2)+" L "+(n.startX+u.width/2-u.width/4)+" "+(n.startY-u.height/2+u.height)+" L "+(n.startX-u.width/2+u.width/4)+" "+(n.startY-u.height/2+u.height)+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawDownArrow:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX-u.width/2+u.width/4)+" "+(n.startY-u.height/2)+" L "+(n.startX+u.width/2-u.width/4)+" "+(n.startY-u.height/2)+" L "+(n.startX+u.width/2-u.width/4)+" "+(n.startY-u.height/2+u.height/2)+" L "+(n.startX+u.width/2)+" "+(n.startY-u.height/2+u.height/2)+" L "+n.startX+" "+(n.startY-u.height/2+u.height)+" L "+(n.startX-u.width/2)+" "+(n.startY-u.height/2+u.height/2)+" L "+(n.startX-u.width/2+u.width/4)+" "+(n.startY-u.height/2+u.height/2)+" L "+(n.startX-u.width/2+u.width/4)+" "+(n.startY-u.height/2)+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawCross:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX+-u.width/2)+" "+n.startY+" L "+(n.startX+u.width/2)+" "+n.startY+" M "+n.startX+" "+(n.startY+u.height/2)+" L "+n.startX+" "+(n.startY+-u.height/2);e={id:t.ID,opacity:t.Style.Opacity,"stroke-width":t.Style.BorderWidth,stroke:t.Style.Color,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawHorizLine:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX+-u.width/2)+" "+n.startY+" L "+(n.startX+u.width/2)+" "+n.startY;e={id:t.ID,opacity:t.Style.Opacity,"stroke-width":t.Style.BorderWidth,stroke:t.Style.Color,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawVertLine:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+n.startX+" "+(n.startY+u.height/2)+" L "+n.startX+" "+(n.startY+-u.height/2);e={id:t.ID,opacity:t.Style.Opacity,"stroke-width":t.Style.BorderWidth,stroke:t.Style.Color,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawTriangle:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX+-u.width/2)+" "+(n.startY+u.height/2)+" L "+n.startX+" "+(n.startY+-u.height/2)+" L "+(n.startX+u.width/2)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2)+" "+(n.startY+u.height/2)+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawInvertedTriangle:function(n,t,i,r){var f=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,e="M "+(n.startX+u.width/2)+" "+(n.startY-u.height/2)+" L "+n.startX+" "+(n.startY+u.height/2)+" L "+(n.startX-u.width/2)+" "+(n.startY-u.height/2)+" L "+(n.startX+u.width/2)+" "+(n.startY-u.height/2)+" z";var h=n.startX,c=n.startY,o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:e};f.drawPath(o,r)},_drawHexagon:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX+-u.width/2)+" "+n.startY+" L "+(n.startX+-u.width/4)+" "+(n.startY+-u.height/2)+" L "+(n.startX+u.width/4)+" "+(n.startY+-u.height/2)+" L "+(n.startX+u.width/2)+" "+n.startY+" L "+(n.startX+u.width/4)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/4)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2)+" "+n.startY+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawWedge:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX-u.width)+" "+n.startY+" L "+(n.startX+u.width)+" "+(n.startY+-u.height/2)+" L "+(n.startX+3*(u.width/4))+" "+n.startY+" L "+(n.startX+u.width)+" "+(n.startY+u.height/2)+" L "+(n.startX-u.width)+" "+n.startY+" z";e={"stroke-linecap":"miter","stroke-miterlimit":u.width/4,id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawPentagon:function(n,t,i,r){for(var l,a,v=i.svgRenderer,p=i.svgObject,u=t.ShapeSize,o=Math.sqrt(u.height*u.height+u.width*u.width)/2,f=ej.EjSvgRender.utils._getStringBuilder(),e=0;e<=5;e++){var y=e*72,s=Math.PI/180*y,h=o*Math.cos(s),c=o*Math.sin(s);e==0?f.append("M "+(n.startX+h)+" "+(n.startY+c)+" "):f.append("L "+(n.startX+h)+" "+(n.startY+c)+" ")}f.append("z");l=f.toString();a={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:l};v.drawPath(a,r)},_drawStar:function(n,t,i,r){var o=i.svgRenderer,u=t.ShapeSize,s=i.svgObject,f,e;f="M "+(n.startX+u.width/3)+" "+(n.startY+-u.height/2)+" L "+(n.startX+-u.width/2)+" "+(n.startY+u.height/6)+" L "+(n.startX+u.width/2)+" "+(n.startY+u.height/6)+" L "+(n.startX+-u.width/3)+" "+(n.startY+-u.height/2)+" L "+n.startX+" "+(n.startY+u.height/2)+" L "+(n.startX+u.width/3)+" "+(n.startY+-u.height/2)+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawRectangle:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX+-u.width/2)+" "+(n.startY+-u.height/2)+" L "+(n.startX+u.width/2)+" "+(n.startY+-u.height/2)+" L "+(n.startX+u.width/2)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2)+" "+(n.startY+-u.height/2)+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawTrapezoid:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX+-u.width/2)+" "+n.startY+" L "+(n.startX+-u.width/2)+" "+(n.startY+-u.height/4)+" L "+(n.startX+-u.width/2+u.width)+" "+(n.startY+-u.height/2)+" L "+(n.startX+-u.width/2+u.width)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2)+" "+(n.startY+u.height/4)+" L "+(n.startX+-u.width/2)+" "+n.startY+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawDiamond:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;f="M "+(n.startX+-u.width/2)+" "+n.startY+" L "+n.startX+" "+(n.startY+-u.height/2)+" L "+(n.startX+u.width/2)+" "+n.startY+" L "+n.startX+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2)+" "+n.startY+" z";e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,d:f};o.drawPath(e,r)},_drawEllipse:function(n,t,i,r){var f=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,e=n.startX,o=n.startY,s={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,lgndCtx:t.context,cx:e,cy:o,rx:u.width,ry:u.height/2};f.drawEllipse(s,r)},_drawImage:function(n,t,i,r){var f=i.svgRenderer,e=i.svgObject,u=t.ShapeSize,o=n.startX+-u.width/2,s=n.startY+-u.width/2,h=u.width,c=u.height,l={id:e.id+"_image"+t.PointIndex,height:c,width:h,href:t.Imageurl,x:o,y:s,visibility:"visible",lgndCtx:t.context};f.drawImage(l,r)},_drawStraightLine:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+-u.width/2+-f/4)+" "+(n.startY+u.height/10)+" L "+(n.startX+u.width/2+f/4)+" "+(n.startY+u.height/10),o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth*2,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+-u.width/2+-f/4},_drawLine:function(n,t,i,r){var o=i.svgRenderer,l=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,s;if(i.model.enableCanvasRendering===!0){e="M "+(n.startX+-u.width/2+-f/4)+" "+(n.startY+u.height/10)+" L "+(n.startX-Math.floor(u.width/3))+" "+(n.startY+u.height/10)+" M "+(n.startX+Math.floor(u.width/3))+" "+(n.startY+u.height/10)+" L "+(n.startX+u.width/2+f/4)+" "+(n.startY+u.height/10);var s={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth*2,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},h="M "+(n.startX-Math.floor(u.width/3))+" "+(n.startY+u.height/10)+" a "+Math.floor(u.width/3)+" "+Math.floor(u.width/3)+" 0 1 0 "+2*Math.floor(u.width/3)+" 0 a"+Math.floor(u.width/3)+" "+Math.floor(u.width/3)+" 0 1 0 "+-2*Math.floor(u.width/3)+" 0",c={id:t.ID,fill:"transparent","stroke-width":t.Style.BorderWidth*2,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:h,lgndCtx:!0};o.drawPath(s,r);o.drawPath(c,r)}else e="M "+(n.startX+-u.width/2+-f/4)+" "+(n.startY+u.height/10)+" L "+(n.startX-Math.floor(u.width/3))+" "+(n.startY+u.height/10)+" M "+(n.startX+Math.floor(u.width/3))+" "+(n.startY+u.height/10)+" L "+(n.startX+u.width/2+f/4)+" "+(n.startY+u.height/10)+" M "+(n.startX-Math.floor(u.width/3))+" "+(n.startY+u.height/10)+" a "+Math.floor(u.width/3)+" "+Math.floor(u.width/3)+" 0 1 0 "+2*Math.floor(u.width/3)+" 0 a"+Math.floor(u.width/3)+" "+Math.floor(u.width/3)+" 0 1 0 "+-2*Math.floor(u.width/3)+" 0",s={id:t.ID,fill:"transparent","stroke-width":t.Style.BorderWidth*2,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},o.drawPath(s,r);return n.startX+-u.width/2+-f/4},_drawColumn:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX-3*(u.width/5))+" "+(n.startY-u.height/5)+" L "+(n.startX+3*(-u.width/10))+" "+(n.startY-u.height/5)+" L "+(n.startX+3*(-u.width/10))+" "+(n.startY+u.height/2)+" L "+(n.startX-3*(u.height/5))+" "+(n.startY+u.height/2)+" Z M "+(n.startX+-u.width/10-u.width/20)+" "+(n.startY-u.height/4-f/2)+" L "+(n.startX+u.width/10+u.width/20)+" "+(n.startY-u.height/4-f/2)+" L "+(n.startX+u.width/10+u.width/20)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/10-u.width/20)+" "+(n.startY+u.height/2)+" Z M "+(n.startX+3*(u.width/10))+" "+n.startY+" L "+(n.startX+3*(u.width/5))+" "+n.startY+" L "+(n.startX+3*(u.width/5))+" "+(n.startY+u.height/2)+" L "+(n.startX+3*(u.width/10))+" "+(n.startY+u.height/2)+" Z",o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX-3*(u.width/5)},_drawRangeColumn:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+-u.width/5)+" "+(n.startY+u.height/2+f/4)+" L "+(n.startX+-u.width/5)+" "+(n.startY-u.height/2-f/4)+" L "+(n.startX+u.width/2)+" "+(n.startY+-u.height/2+-f/4)+" L "+(n.startX+u.width/2)+" "+(n.startY+u.height/2+f/4)+" Z",o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+-u.width/5},_drawBar:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+-u.width/2+-f/4)+" "+(n.startY-3*(u.height/5))+" L "+(n.startX+3*(u.width/10))+" "+(n.startY-3*(u.height/5))+" L "+(n.startX+3*(u.width/10))+" "+(n.startY-3*(u.height/10))+" L "+(n.startX-u.width/2+-f/4)+" "+(n.startY-3*(u.height/10))+" Z M "+(n.startX+-u.width/2+-f/4)+" "+(n.startY-u.height/5+f/20)+" L "+(n.startX+u.width/2+f/4)+" "+(n.startY-u.height/5+f/20)+" L "+(n.startX+u.width/2+f/4)+" "+(n.startY+u.height/10+f/20)+" L "+(n.startX-u.width/2+-f/4)+" "+(n.startY+u.height/10+f/20)+" Z M "+(n.startX-u.width/2+-f/4)+" "+(n.startY+u.height/5+f/10)+" L "+(n.startX+-u.width/4)+" "+(n.startY+u.height/5+f/10)+" L "+(n.startX+-u.width/4)+" "+(n.startY+u.height/2+f/10)+" L "+(n.startX-u.width/2+-f/4)+" "+(n.startY+u.height/2+f/10)+" Z",o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+-u.width/2+-f/4},_drawStepLine:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+-u.width/2-f/4)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2+u.width/10)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2+u.width/10)+" "+n.startY+" L "+(n.startX+-u.width/10)+" "+n.startY+" L "+(n.startX+-u.width/10)+" "+(n.startY+u.height/2)+" L "+(n.startX+u.width/5)+" "+(n.startY+u.height/2)+" L "+(n.startX+u.width/5)+" "+(n.startY+-u.height/2)+" L "+(n.startX+u.width/2)+" "+(n.startY+-u.height/2)+"L "+(n.startX+u.width/2)+" "+(n.startY+u.height/2)+" L"+(n.startX+u.width/2+f/4)+" "+(n.startY+u.height/2),o={id:t.ID,fill:"transparent","stroke-width":t.Style.BorderWidth,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+-u.width/2-f/4},_drawSpline:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;return f="M "+(n.startX-u.width/2)+" "+(n.startY+u.height/5)+" Q "+n.startX+" "+(n.startY-u.height)+" "+n.startX+" "+(n.startY+u.height/5)+" M "+n.startX+" "+(n.startY+u.height/5)+" Q "+(n.startX+u.width/2)+" "+(n.startY+u.height/2)+" "+(n.startX+u.width/2)+" "+(n.startY-u.height/2),e={id:t.ID,fill:"transparent","stroke-width":t.Style.BorderWidth*2,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:f,lgndCtx:!0},o.drawPath(e,r),n.startX-u.width/2},_drawSplineArea:function(n,t,i,r){var o=i.svgRenderer,s=i.svgObject,u=t.ShapeSize,f,e;return f="M "+(n.startX-u.width/2)+" "+(n.startY+u.height/5)+" Q "+n.startX+" "+(n.startY-u.height)+" "+n.startX+" "+(n.startY+u.height/5)+" Z M "+n.startX+" "+(n.startY+u.height/5)+" Q "+(n.startX+u.width/2)+" "+(n.startY+u.height/2)+" "+(n.startX+u.width/2)+" "+(n.startY-u.height/2)+"  Z",e={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:f,lgndCtx:!0},o.drawPath(e,r),n.startX-u.width/2},_drawArea:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX-u.width/2-f/4)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/4+-f/8)+" "+(n.startY-u.height/2)+" L "+n.startX+" "+(n.startY+u.height/4)+" L "+(n.startX+u.width/4+f/8)+" "+(n.startY+-u.height/2+u.height/4)+" L "+(n.startX+u.height/2+f/4)+" "+(n.startY+u.height/2)+" Z",o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX-u.width/2-f/4},_drawStepArea:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+-u.width/2+-f/4)+" "+(n.startY+u.height/2)+" L "+(n.startX+-u.width/2+-f/4)+" "+(n.startY+-u.height/2)+" L "+(n.startX-u.width/4)+" "+(n.startY-u.height/2)+" L "+(n.startX-u.width/4)+" "+(n.startY-u.height/4)+" L "+(n.startX+u.width/4)+" "+(n.startY-u.height/4)+" L "+(n.startX+u.width/4)+" "+n.startX+" L "+(n.startX+u.width/2+f/4)+" "+n.startY+" L "+(n.startX+u.width/2+f/4)+" "+(n.startY+u.height/2)+" Z",o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+-u.width/2+-f/4},_drawPyramid:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+-u.width/2+-f/4)+" "+(n.startY+u.height/2+f/8)+" L "+n.startX+" "+(n.startY+-u.height/2+-f/8)+" L "+(n.startX+u.width/2+f/4)+" "+(n.startY+u.height/2+f/8)+" Z",o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+-u.width/2+-f/4},_drawFunnel:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+-u.width/2+-f/5)+" "+(n.startY+-u.height/2+-f/4)+" L "+(n.startX+-u.width/5)+" "+(n.startY+u.height/4)+" L "+(n.startX+-u.width/5)+" "+(n.startY+u.height/2+f/4)+" L "+(n.startX+u.width/5)+" "+(n.startY+u.height/2+f/4)+" L "+(n.startX+u.width/5)+" "+(n.startY+u.height/4)+" L "+(n.startX+u.width/2+f/5)+" "+(n.startY+-u.height/2+-f/4)+" Z",o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.BorderColor,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+-u.width/2+-f/5},_drawCandle:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+-u.width/2)+" "+(n.startY+u.height/4+f/8)+" L "+(n.startX+u.width/2)+" "+(n.startY+u.height/4+f/8)+" L "+(n.startX+u.width/2)+" "+(n.startY+-u.height/2+f/8)+" L "+(n.startX+-u.width/2)+" "+(n.startY+-u.height/2+f/8)+" Z M "+n.startX+" "+(n.startY+-u.height/2+f/8)+" L "+n.startX+" "+(n.startY+-u.height/2+-f/4)+" M "+n.startX+" "+(n.startY+u.height/4+f/8)+" L "+n.startX+" "+(n.startY+u.height/4+f/2),o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+-u.width/2},_drawHilo:function(n,t,i,r){var s=i.svgRenderer,h=i.svgObject,u=t.ShapeSize,f=t.ElementSpace,e,o;return e="M "+(n.startX+u.width/2)+" "+(n.startY+u.height/2+f/4)+" L "+(n.startX+u.width/2)+" "+(n.startY+-u.height/2+-f/4),o={id:t.ID,fill:t.Style.Color,"stroke-width":t.Style.BorderWidth,stroke:t.Style.Color,opacity:t.Style.Opacity,visibility:t.Style.Visibility,d:e,lgndCtx:!0},s.drawPath(o,r),n.startX+u.width/2},_drawHiloOpenClose:function(n,i,r,u){var h=r.svgRenderer,c=r.svgObject,f=i.ShapeSize,l=t(18,12,4.0710678118654755,270),e=i.ElementSpace,o,s;return o="M "+n.startX+" "+(n.startY-3*(f.height/10))+" L "+(n.startX-f.width/2-e/4)+" "+(n.startY-3*(f.height/10))+" M "+n.startX+" "+(n.startY-f.height/2-e/4)+" L "+n.startX+" "+(n.startY+f.height/2+e/4)+" M "+n.startX+" "+(n.startY+3*(f.height/10))+" L "+(n.startX+f.width/2+e/4)+" "+(n.startY+3*(f.height/10)),s={id:i.ID,fill:"transparent","stroke-width":i.Style.BorderWidth,stroke:i.Style.Color,opacity:i.Style.Opacity,visibility:i.Style.Visibility,d:o,lgndCtx:!0},h.drawPath(s,u),n.startX-f.width/2},_drawDoughnut:function(n,i,r,u){var o=r.svgRenderer,y=r.svgObject,e=i.ShapeSize,c=i.ElementSpace,f=Math.sqrt(e.height*e.width)/2;f=f+c/5;var s=t(n.startX,n.startY,f,270),h=t(n.startX+e.width/10,n.startY,f,270),c=i.ElementSpace,l="M "+n.startX+" "+n.startY+" L "+(n.startX+f)+" "+n.startY+" A "+f+" "+f+" 0 1 1 "+s[0]+" "+s[1]+" Z M "+(n.startX+e.width/10)+" "+(n.startY-e.height/10)+" L"+(n.startX+f)+" "+(n.startY-e.height/10)+" A "+f+" "+f+" 0 0 0 "+h[0]+" "+h[1]+" Z",a={id:i.ID,fill:i.Style.Color,"stroke-width":i.Style.BorderWidth,stroke:i.Style.BorderColor,opacity:i.Style.Opacity,visibility:i.Style.Visibility,d:l,lgndCtx:!0},v={id:i.ID,cx:n.startX,cy:n.startY,r:f/2,lgndCtx:!0,fill:"white","stroke-width":i.Style.BorderWidth,stroke:i.Style.BorderColor,opacity:i.Style.Opacity,visibility:i.Style.Visibility};return o.drawPath(a,u),o.drawCircle(v,u),n.startX-f},_drawPie:function(n,i,r,u){var h=r.svgRenderer,v=r.svgObject,e=i.ShapeSize,c=i.ElementSpace,f=Math.sqrt(e.height*e.width)/2;f=f+c/5;var o=t(n.startX,n.startY,f,270),s=t(n.startX+e.width/10,n.startY,f,270),c=i.ElementSpace,l="M "+n.startX+" "+n.startY+" L "+(n.startX+f)+" "+n.startY+" A "+f+" "+f+" 0 1 1 "+o[0]+" "+o[1]+" Z M "+(n.startX+e.width/10)+" "+(n.startY-e.height/10)+" L"+(n.startX+f)+" "+(n.startY-e.height/10)+" A "+f+" "+f+" 0 0 0 "+s[0]+" "+s[1]+" Z",a={id:i.ID,fill:i.Style.Color,"stroke-width":i.Style.BorderWidth,stroke:i.Style.BorderColor,opacity:i.Style.Opacity,visibility:i.Style.Visibility,d:l,lgndCtx:!0};return h.drawPath(a,u),n.startX-f}};ej.EjSvgRender.seriesPalette={defaultMetro:["#E94649","#F6B53F","#6FAAB0","#C4C24A","#FB954F","#005277","#8BC652","#69D2E7","#E27F2D","#6A4B82"],defaultHighContrast:["#F93A00","#44E2D6","#DDD10D","#0AA368","#0556CB","#AB40B2","#5F930A","#D12E41","#E0670E","#008FFF"],defaultOffice:["#005277","#8BC652","#6A4B82","#E94649","#6FAAB0","#F7B74F","#C4C24A","#EF863F","#69D2E7","#FFD13E"],defaultMaterial:["#663AB6","#EB3F79","#F8AB1D","#B82E3D","#049CB1","#F2424F","#C2C924","#3DA046","#074D67","#02A8F4"],defaultGradient:{borderColors:["#F34649","#F6D321","#6EB9B0","#CBC26A","#FBAF4F","#E2CDB1","#FFC0B7","#68E1E6","#E1A62D","#9C6EBF"],seriesColors:[[{color:"#F34649",colorStop:"0%"},{color:"#B74143",colorStop:"100%"}],[{color:"#F6D321",colorStop:"0%"},{color:"#F6AE26",colorStop:"100%"}],[{color:"#6EB9B0",colorStop:"0%"},{color:"#3F77BD",colorStop:"100%"}],[{color:"#CBC26A",colorStop:"0%"},{color:"#9AAD21",colorStop:"100%"}],[{color:"#FBAF4F",colorStop:"0%"},{color:"#F07542",colorStop:"100%"}],[{color:"#E2CDB1",colorStop:"0%"},{color:"#AAA089",colorStop:"100%"}],[{color:"#8BC652",colorStop:"0%"},{color:"#6F9E41",colorStop:"100%"}],[{color:"#68E1E6",colorStop:"0%"},{color:"#3D9CBE",colorStop:"100%"}],[{color:"#E1A62D",colorStop:"0%"},{color:"#B66824",colorStop:"100%"}],[{color:"#9C6EBF",colorStop:"0%"}],[{color:"#593F6D",colorStop:"100%"}]]},blueMetro:["#005378","#006691","#007EB5","#0D97D4","#00AEFF","#14B9FF","#54CCFF","#87DBFF","#ADE5FF","#C5EDFF"],blueGradient:{seriesColors:[[{color:"#005277",colorStop:"0%"},{color:"#00304F",colorStop:"100%"}],[{color:"#006590",colorStop:"0%"},{color:"#004068",colorStop:"100%"}],[{color:"#007DB4",colorStop:"0%"},{color:"#00558B",colorStop:"100%"}],[{color:"#0D97D4",colorStop:"0%"},{color:"#057FC7",colorStop:"100%"}],[{color:"#00ADFE",colorStop:"0%"},{color:"#008BE9",colorStop:"100%"}],[{color:"#14B8FE",colorStop:"0%"},{color:"#0798EB",colorStop:"100%"}],[{color:"#53CBFF",colorStop:"0%"},{color:"#35AFEB",colorStop:"100%"}],[{color:"#86DAFF",colorStop:"0%"},{color:"#64C0EC",colorStop:"100%"}],[{color:"#ACE5FF",colorStop:"0%"},{color:"#8DCEED",colorStop:"100%"}],[{color:"#C4ECFF",colorStop:"0%"}],[{color:"#A3D1E6",colorStop:"100%"}]],borderColors:["#005277","#006590","#007DB4","#0D97D4","#00ADFE","#14B8FE","#53CBFF","#86DAFF","#ACE5FF","#C4ECFF"]},greenMetro:["#496612","#597B15","#709A1B","#87B62A","#9AD926","#A6DC37","#BCE654","#C8E780","#D5EFA5","#E2F3BE"],greenGradient:{seriesColors:[[{color:"#5C7F16",colorStop:"0%"},{color:"#384C08",colorStop:"100%"}],[{color:"#6A9319",colorStop:"0%"},{color:"#486009",colorStop:"100%"}],[{color:"#739D1C",colorStop:"0%"},{color:"#57760B",colorStop:"100%"}],[{color:"#90B546",colorStop:"0%"},{color:"#6E9215",colorStop:"100%"}],[{color:"#9AD826",colorStop:"0%"},{color:"#75A010",colorStop:"100%"}],[{color:"#A5DB36",colorStop:"0%"},{color:"#8EB91D",colorStop:"100%"}],[{color:"#BBE554",colorStop:"0%"},{color:"#A4C849",colorStop:"100%"}],[{color:"#C8E780",colorStop:"0%"},{color:"#B4D072",colorStop:"100%"}],[{color:"#D4EEA5",colorStop:"0%"},{color:"#BFD593",colorStop:"100%"}],[{color:"#E1F2BD",colorStop:"0%"}],[{color:"#C8D7A8",colorStop:"100%"}]],borderColors:["#5C7F16","#6A9319","#739D1C","#90B546","#9AD826","#A5DB36","#BBE554","#C8E780","#D4EEA5","#E1F2BD"]},sandleMetro:["#6C450C","#82520D","#A36812","#C07F1F","#E69719","#E89A2B","#EEB564","#F3CB93","#F7DEB4","#F9E6CA"],sandleGradient:{seriesColors:[[{color:"#7F602F",colorStop:"0%"},{color:"#512D04",colorStop:"100%"}],[{color:"#986827",colorStop:"0%"},{color:"#673803",colorStop:"100%"}],[{color:"#A16C1F",colorStop:"0%"},{color:"#8A4B05",colorStop:"100%"}],[{color:"#BF812A",colorStop:"0%"},{color:"#AD630D",colorStop:"100%"}],[{color:"#E49519",colorStop:"0%"},{color:"#B86607",colorStop:"100%"}],[{color:"#E7992A",colorStop:"0%"},{color:"#D7780D",colorStop:"100%"}],[{color:"#EDB463",colorStop:"0%"},{color:"#D98F31",colorStop:"100%"}],[{color:"#F2CA92",colorStop:"0%"},{color:"#DAAC6F",colorStop:"100%"}],[{color:"#F6DDB3",colorStop:"0%"},{color:"#DABE8F",colorStop:"100%"}],[{color:"#F8E5C9",colorStop:"0%"}],[{color:"#DDBE92",colorStop:"100%"}]],borderColors:["#7F602F","#986827","#A16C1F","#BF812A","#E49519","#E7992A","#EDB463","#F2CA92","#F6DDB3","#F8E5C9"]}};ej.EjSvgRender.themes={flatlight:{highlightColor:"black",background:"transparent",legend:{font:{color:"#282828"},title:{font:{color:"#282828"}}},title:{font:{color:"#565656"},subTitle:{font:{color:"#565656"}}},primaryXAxis:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#282828",axisLine:{color:"#8E8E8E"},font:{color:"#282828"},title:{font:{color:"#282828"}},crosshairLabel:{rx:3,ry:3,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},secondaryX:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#282828",axisLine:{color:"#8E8E8E"},font:{color:"#282828"},title:{font:{color:"#282828"}},crosshairLabel:{rx:3,ry:3,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},primaryYAxis:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#282828",axisLine:{color:"#8E8E8E"},font:{color:"#282828"},title:{font:{color:"#282828"}},crosshairLabel:{rx:3,ry:3,border:{color:"#3D3D3D",borderWidth:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},secondaryY:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#282828",axisLine:{color:"#8E8E8E"},font:{color:"#282828"},title:{font:{color:"#282828"}},crosshairLabel:{rx:3,ry:3,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},commonSeriesOptions:{marker:{dataLabel:{font:{color:"#565656"}}},errorBar:{fill:"#000000",cap:{fill:"#000000"}},connectorLine:{color:"#565656"}},crosshair:{line:{width:1,color:"Black"}},seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.defaultMetro,colors:ej.EjSvgRender.seriesPalette.defaultMetro},flatdark:{highlightColor:"white",background:"#111111",legend:{font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}}},title:{font:{color:"#C9C9C9"},subTitle:{font:{color:"#C9C9C9"}}},primaryXAxis:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#C9C9C9",axisLine:{color:"#AAAAAA"},font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}},crosshairLabel:{rx:0,ry:0,fill:"#B5B5B5",border:{color:"#B5B5B5",width:1},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},secondaryX:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#C9C9C9",axisLine:{color:"#AAAAAA"},font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}},crosshairLabel:{rx:0,ry:0,fill:"#B5B5B5",border:{color:"#B5B5B5",width:1},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},primaryYAxis:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#C9C9C9",axisLine:{color:"#AAAAAA"},font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}},crosshairLabel:{rx:0,ry:0,fill:"#B5B5B5",border:{color:"#B5B5B5",width:1},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},secondaryY:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#C9C9C9",axisLine:{color:"#AAAAAA"},font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}},crosshairLabel:{rx:0,ry:0,fill:"#B5B5B5",border:{color:"#B5B5B5",width:1},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},commonSeriesOptions:{marker:{dataLabel:{font:{color:"#C9C9C9"}}},errorBar:{fill:"#ffffff",cap:{fill:"#ffffff"}},connectorLine:{color:"#C9C9C9"}},crosshair:{line:{width:1,color:"White"}},seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.defaultMetro,colors:ej.EjSvgRender.seriesPalette.defaultMetro},gradientlight:{highlightColor:"black",background:"transparent",legend:{font:{color:"#282828"},title:{font:{color:"#282828"}}},title:{font:{color:"#565656"},subTitle:{font:{color:"#565656"}}},primaryXAxis:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#282828",axisLine:{color:"#8E8E8E"},font:{color:"#282828"},title:{font:{color:"#282828"}},crosshairLabel:{rx:3,ry:3,fill:"#3D3D3D",border:{color:"#3D3D3D",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},secondaryX:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#282828",axisLine:{color:"#8E8E8E"},font:{color:"#282828"},title:{font:{color:"#282828"}},crosshairLabel:{rx:3,ry:3,fill:"#3D3D3D",border:{color:"#3D3D3D",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},primaryYAxis:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#282828",axisLine:{color:"#8E8E8E"},font:{color:"#282828"},title:{font:{color:"#282828"}},crosshairLabel:{rx:3,ry:3,fill:"#3D3D3D",border:{color:"#3D3D3D",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},secondaryY:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#282828",axisLine:{color:"#8E8E8E"},font:{color:"#282828"},title:{font:{color:"#282828"}},crosshairLabel:{rx:3,ry:3,fill:"#3D3D3D",border:{color:"#3D3D3D",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},commonSeriesOptions:{marker:{dataLabel:{font:{color:"#565656"}}},errorBar:{fill:"#000000",cap:{fill:"#000000"}},connectorLine:{color:"#565656"}},crosshair:{line:{width:1,color:"Black"}},seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.defaultGradient.borderColors,colors:ej.EjSvgRender.seriesPalette.defaultGradient.seriesColors},gradientdark:{highlightColor:"white",background:"#111111",legend:{font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}}},title:{font:{color:"#C9C9C9"},subTitle:{font:{color:"#C9C9C9"}}},primaryXAxis:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#C9C9C9",axisLine:{color:"#AAAAAA"},font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}},crosshairLabel:{rx:3,ry:3,fill:"#B5B5B5",border:{color:"#B5B5B5",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},secondaryX:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#C9C9C9",axisLine:{color:"#AAAAAA"},font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}},crosshairLabel:{rx:3,ry:3,fill:"#B5B5B5",border:{color:"#B5B5B5",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},primaryYAxis:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#C9C9C9",axisLine:{color:"#AAAAAA"},font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}},crosshairLabel:{rx:3,ry:3,fill:"#B5B5B5",border:{color:"#B5B5B5",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},secondaryY:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#C9C9C9",axisLine:{color:"#AAAAAA"},font:{color:"#C9C9C9"},title:{font:{color:"#C9C9C9"}},crosshairLabel:{rx:3,ry:3,fill:"#B5B5B5",border:{color:"#B5B5B5",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},commonSeriesOptions:{marker:{dataLabel:{font:{color:"#C9C9C9"}}},errorBar:{fill:"#ffffff",cap:{fill:"#ffffff"}},connectorLine:{color:"#C9C9C9"}},crosshair:{line:{width:1,color:"White"}},seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.defaultGradient.borderColors,colors:ej.EjSvgRender.seriesPalette.defaultGradient.seriesColors},highcontrast01:{highlightColor:"white",background:"#111111",legend:{font:{color:"#ffffff"},title:{font:{color:"#ffffff"}}},title:{font:{color:"#ffffff"},subTitle:{font:{color:"#ffffff"}}},primaryXAxis:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#ffffff",axisLine:{color:"#AAAAAA"},font:{color:"#ffffff"},title:{font:{color:"#ffffff"}},crosshairLabel:{rx:3,ry:3,fill:"#B5B5B5",border:{color:"#B5B5B5",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},secondaryX:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},axisLine:{color:"#AAAAAA"},font:{color:"#ffffff"},title:{font:{color:"#ffffff"}},crosshairLabel:{rx:3,ry:3,fill:"#B5B5B5",border:{color:"#B5B5B5",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},primaryYAxis:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},labelBorder:{color:"#AAAAAA"},multiLevelLabelsColor:"#AAAAAA",multiLevelLabelsFontColor:"#ffffff",axisLine:{color:"#AAAAAA"},font:{color:"#ffffff"},title:{font:{color:"#ffffff"}},crosshairLabel:{rx:3,ry:3,fill:"#B5B5B5",border:{color:"#B5B5B5",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},secondaryY:{majorGridLines:{color:"#333333"},majorTickLines:{color:"#AAAAAA"},minorGridLines:{color:"#333333"},minorTickLines:{color:"#AAAAAA"},axisLine:{color:"#AAAAAA"},font:{color:"#ffffff"},title:{font:{color:"#ffffff"}},crosshairLabel:{rx:3,ry:3,fill:"#B5B5B5",border:{color:"#B5B5B5",width:2},font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#444444"}}},commonSeriesOptions:{marker:{dataLabel:{font:{color:"#ffffff"}}},errorBar:{fill:"#ffffff",cap:{fill:"#ffffff"}},connectorLine:{color:"#C9C9C9"}},crosshair:{line:{width:1,color:"White"}},seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.defaultHighContrast,colors:ej.EjSvgRender.seriesPalette.defaultHighContrast},material:{highlightColor:"black",background:"transparent",legend:{font:{color:"#333333"},title:{font:{color:"#333333"}}},title:{font:{color:"#333333"},subTitle:{font:{color:"#333333"}}},primaryXAxis:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#333333",axisLine:{color:"#8E8E8E"},font:{color:"#333333"},title:{font:{color:"#333333"}},crosshairLabel:{rx:0,ry:0,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},secondaryX:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},axisLine:{color:"#8E8E8E"},font:{color:"#333333"},title:{font:{color:"#333333"}},crosshairLabel:{rx:0,ry:0,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},primaryYAxis:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#333333",axisLine:{color:"#8E8E8E"},font:{color:"#333333"},title:{font:{color:"#333333"}},crosshairLabel:{rx:0,ry:0,border:{color:"#3D3D3D",borderWidth:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},secondaryY:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},axisLine:{color:"#8E8E8E"},font:{color:"#333333"},title:{font:{color:"#333333"}},crosshairLabel:{rx:0,ry:0,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},commonSeriesOptions:{marker:{dataLabel:{font:{color:"#333333"}}},errorBar:{fill:"#000000",cap:{fill:"#000000"}},connectorLine:{color:"#565656"}},crosshair:{line:{width:1,color:"Black"}},seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.defaultMaterial,colors:ej.EjSvgRender.seriesPalette.defaultMaterial},office365:{highlightColor:"black",background:"transparent",legend:{font:{color:"#333333"},title:{font:{color:"#333333"}}},title:{font:{color:"#333333"},subTitle:{font:{color:"#333333"}}},primaryXAxis:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#333333",axisLine:{color:"#8E8E8E"},font:{color:"#333333"},title:{font:{color:"#333333"}},crosshairLabel:{rx:0,ry:0,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},secondaryX:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},axisLine:{color:"#8E8E8E"},font:{color:"#333333"},title:{font:{color:"#333333"}},crosshairLabel:{rx:0,ry:0,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},primaryYAxis:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},labelBorder:{color:"#8E8E8E"},multiLevelLabelsColor:"#8E8E8E",multiLevelLabelsFontColor:"#333333",axisLine:{color:"#8E8E8E"},font:{color:"#333333"},title:{font:{color:"#333333"}},crosshairLabel:{rx:0,ry:0,border:{color:"#3D3D3D",borderWidth:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},secondaryY:{majorGridLines:{color:"#DFDFDF"},majorTickLines:{color:"#8E8E8E"},minorGridLines:{color:"#DFDFDF"},minorTickLines:{color:"#8E8E8E"},axisLine:{color:"#8E8E8E"},font:{color:"#333333"},title:{font:{color:"#333333"}},crosshairLabel:{rx:0,ry:0,border:{color:"#3D3D3D",width:1},fill:"#3D3D3D",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:"#DBDBDB"}}},commonSeriesOptions:{marker:{dataLabel:{font:{color:"#333333"}}},errorBar:{fill:"#000000",cap:{fill:"#000000"}},connectorLine:{color:"#565656"}},crosshair:{line:{width:1,color:"Black"}},seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.defaultOffice,colors:ej.EjSvgRender.seriesPalette.defaultOffice}};n.extend(ej.EjSvgRender.themes,{azure:{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.blueMetro,colors:ej.EjSvgRender.seriesPalette.blueMetro},azuredark:{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.blueMetro,colors:ej.EjSvgRender.seriesPalette.blueMetro},"gradient-azure":{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.blueGradient.borderColors,colors:ej.EjSvgRender.seriesPalette.blueGradient.seriesColors},"gradient-azuredark":{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.blueGradient.borderColors,colors:ej.EjSvgRender.seriesPalette.blueGradient.seriesColors},lime:{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.greenMetro,colors:ej.EjSvgRender.seriesPalette.greenMetro},limedark:{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.greenMetro,colors:ej.EjSvgRender.seriesPalette.greenMetro},"gradient-lime":{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.greenGradient.borderColors,colors:ej.EjSvgRender.seriesPalette.greenGradient.seriesColors},"gradient-limedark":{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.greenGradient.borderColors,colors:ej.EjSvgRender.seriesPalette.greenGradient.seriesColors},saffron:{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.sandleMetro,colors:ej.EjSvgRender.seriesPalette.sandleMetro},saffrondark:{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.sandleMetro,colors:ej.EjSvgRender.seriesPalette.sandleMetro},"gradient-saffron":{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.sandleGradient.borderColors,colors:ej.EjSvgRender.seriesPalette.sandleGradient.seriesColors},"gradient-saffrondark":{seriesBorderDefaultColors:ej.EjSvgRender.seriesPalette.sandleGradient.borderColors,colors:ej.EjSvgRender.seriesPalette.sandleGradient.seriesColors}})}(jQuery);ej.axisTypes={};ej.EjAxisRenderer=function(){};var _sideBySeriesPadding=function(n,t,i,r){for(var u,f,o=ej.DataManager(n.model._visibleSeries,ej.Query().sortBy("_zOrder")).executeLocal(),s=!1,h=o.length,c=r.orientation.toLowerCase(),e=0;e<h;e++)if(u=o[e].type.toLowerCase(),u.indexOf("column")!=-1||u.indexOf("bar")!=-1||u.indexOf("waterfall")!=-1||u=="candle"||u.indexOf("hilo")!=-1||u.indexOf("box")!=-1){s=!0;break}return n.model.AreaType!="polaraxes"&&s?(r.m_minPointsDelta=undefined,f=ej.EjSvgRender.utils.getMinPointsDelta(r,n,t)*.5,t=t-f,i=i+f>Number.MAX_VALUE?Number.MAX_VALUE:i+f,r.padding=f):r.padding=0,{startPadding:t,endPadding:i}};ej.EjStripline=function(n){this.chart=n},function(n){function t(t,i){var r=function(){};return r.prototype=new t,n.extend(r.prototype,i),r}var i,r,u,f,e;ej.EjAxisRenderer.prototype={_seriesMinMax:function(t,i,r,u,f){var vt=i.orientation.toLowerCase(),ti=r.length,yt,d,e,l,w,lt,at,s,o,nt,tt,rt,ui,li,fi,y,ei,gt,oi,ni,ut;if(f.seriesCollection=ej.util.isNullOrUndefined(f.seriesCollection)?{}:f.seriesCollection,ti>0&&t.model._hasSeriesPoints&&r[0].points.length>0||this.chartObj.model.indicators[0]._points.length>0){var pt,a,wt,v,bt,kt,ii,si={maxX:null,minX:null},hi={maxY:null,minY:null},k=si.maxX,b=si.minX,c=hi.maxY,h=hi.minY,dt,ft,et,ot;for(e=0;e<ti;e++){if(dt=r[e].visibility.toLowerCase(),ft=r[e].points.length,yt=0,dt==="visible")for(r[e]._visiblePoints=[],s=0;s<ft;s++)d=r[e].points[s],(d.x!=null&&d.x!=undefined&&(typeof d.y=="object"||!isNaN(d.y))&&d.y!=null&&d.y!=undefined||d.showIntermediateSum||d.showTotalSum||d.isEmpty==!1)&&(r[e]._visiblePoints[yt]=d,r[e]._visiblePoints[yt].actualIndex=s,yt++);i.maxPointLength=ft}for(e=0;e<ti;e++)if(et=r[e]._visiblePoints.length,l=r[e],et>0&&(dt=r[e].visibility.toLowerCase(),ft=r[e].points.length,dt==="visible"&&ft>0))if(vt=="horizontal"&&!t.model.requireInvertedAxes||vt=="vertical"&&t.model.requireInvertedAxes){for(wt=pt=r[e]._visiblePoints[0].xValue,s=0;s<et;s++)o=r[e]._visiblePoints[s].xValue,wt>o&&(wt=o),pt<o&&(pt=o);r[e].minX=wt;r[e].maxX=pt;(b===null||b===undefined)&&et>0&&(k=r[e].maxX,b=r[e].minX);b>r[e].minX&&(b=r[e].minX);k<r[e].maxX&&(k=r[e].maxX)}else{var ri=l.type.toLowerCase().indexOf("spline")!=-1,g,st,ht,ct,ci,it=0,p=r[e]._visiblePoints;for(ri&&(w=l._name=l.name||"series"+e,f.seriesCollection[w]={},p=ej.ejSplineSeries.prototype._isVisiblePoints(l),st=f.seriesCollection[w].naturalSpline=ej.ejSplineSeries.prototype.naturalSpline(p,l,0),l.type.toLowerCase()=="splinerangearea"&&(ht=f.seriesCollection[w].naturalSpline1=ej.ejSplineSeries.prototype.naturalSpline(p,l,1)),f.seriesCollection[w].controlPoints=[],ct=ej.ejSplineSeries.prototype.getBezierControlPoints,ci=p.filter(function(n){return!ej.isNullOrUndefined(n.YValues[0])&&!isNaN(n.YValues[0])})),v=a=ri?ci[0].YValues[0]:p[0].YValues[0],s=0;s<p.length;s++)if(o=p[s],r[e]._hiloTypes&&l.type.toLowerCase()!="splinerangearea")for(nt=0;nt<2;nt++)a>o.YValues[nt]&&(a=o.YValues[nt]),v<o.YValues[nt]&&(v=o.YValues[nt]);else if(l.type.toLowerCase()=="boxandwhisker"){for(lt=p[s].YValues[0][0],at=p[s].YValues[0][0],tt=0;tt<o.YValues[0].length;tt++)lt>o.YValues[0][tt]&&(lt=o.YValues[0][tt]),at<o.YValues[0][tt]&&(at=o.YValues[0][tt]);a=lt>a?a:lt;v=at<v?v:at}else ri?s!=0&&o.visible&&p[s-1].visible?(f.seriesCollection[w].controlPoints.push(ct(p[s-1],o,st[s-1],st[s],0,l,this)),l.type.toLowerCase()=="splinerangearea"&&(rt=ct(p[s-1],o,ht[s-1],ht[s],1,l,this),f.seriesCollection[w].controlPoints[it].controlPoint1.YValues[1]=rt.controlPoint1.YValues[0],f.seriesCollection[w].controlPoints[it].controlPoint2.YValues[1]=rt.controlPoint2.YValues[0]),g=f.seriesCollection[w].controlPoints[it++],a=Math.min(a,o.YValues[0],g.controlPoint1.YValues[0],g.controlPoint2.YValues[0]),v=Math.max(v,o.YValues[0],g.controlPoint1.YValues[0],g.controlPoint2.YValues[0]),l.type.toLowerCase()=="splinerangearea"&&(a=Math.min(a,o.YValues[1],g.controlPoint1.YValues[1],g.controlPoint2.YValues[1]),v=Math.max(v,o.YValues[1],g.controlPoint1.YValues[1],g.controlPoint2.YValues[1]))):(s!=0&&(l.type.toLowerCase().indexOf("stacking")!=-1||l.type.toLowerCase()=="splinerangearea")&&(f.seriesCollection[w].controlPoints.push(ct(p[s-1],o,st[s-1],st[s],0,l,this)),l.type.toLowerCase()=="splinerangearea"&&(rt=ct(p[s-1],o,ht[s-1],ht[s],1,l,this),f.seriesCollection[w].controlPoints[it].controlPoint1.YValues[1]=rt.controlPoint1.YValues[0],f.seriesCollection[w].controlPoints[it].controlPoint2.YValues[1]=rt.controlPoint2.YValues[0]),g=f.seriesCollection[w].controlPoints[it++]),a=Math.min(a,isNaN(o.YValues[0])?a:o.YValues[0]||null),v=Math.max(v,o.YValues[0]||null),l.type.toLowerCase()=="splinerangearea"&&(a=Math.min(a,isNaN(o.YValues[1])?a:o.YValues[1]||null),v=Math.max(v,o.YValues[1]||null))):(a>o.YValues[0]&&(a=o.YValues[0]),v<o.YValues[0]&&(v=o.YValues[0]));r[e].minY=a;r[e].maxY=v;(h===null||h===undefined)&&et>0&&(c=r[e].maxY,h=r[e].minY);h>r[e].minY&&(h=r[e].minY);c<r[e].maxY&&(c=r[e].maxY);ot=r[e].type;(ot=="column"||ot=="bar")&&i.startFromZero&&(h=h<0?h:0)}vt=="horizontal"&&!t.model.requireInvertedAxes||vt=="vertical"&&t.model.requireInvertedAxes?(this.chartObj.model.indicatorRange&&this.chartObj.model.indicatorRange[i.name]&&(y=this.chartObj.model.indicatorRange[i.name],(h>y.min||h==null)&&(h=y.min),(c<y.max||c==null)&&(c=y.max)),k==b&&(k+=1),u=="double"?(ui=_sideBySeriesPadding(t,b,k,i),b=ui.startPadding,k=ui.endPadding,li=k-b,i.range=this._getDoubleAutoRange(i,b,k,li)):i.range=this._getLogAutoRange(i,b,k,k-b)):(this.chartObj.model.stackedValue[i.name]&&(y=this.chartObj.model.stackedValue[i.name],fi=!0,h>y.min&&(h=y.min),c<y.max&&(c=y.max)),this.chartObj.model.indicatorRange&&this.chartObj.model.indicatorRange[i.name]&&(y=this.chartObj.model.indicatorRange[i.name],(h>y.min||h==null)&&(h=y.min),(c<y.max||c==null)&&(c=y.max)),c==h&&(c<0?c=0:c<=1&&c>0?h=0:(h=0,c+=1)),ot!="column"&&ot!="bar"||i.startFromZero||(ei=i.range&&i.range.max||c,gt=i.range&&i.range.interval||this.calculateNumericNiceInterval(ei-h,i,null,ei),c+=gt,h-gt<0&&h>0||fi?h=0:h-=gt),oi=c-h,fi=!1,i.range=u=="double"?this._getDoubleAutoRange(i,h,c,oi):this._getLogAutoRange(i,h,c,oi))}else i.setRange?(bt=i.range.min==null||i.range.min==undefined?0:i.range.min,kt=i.range.max==null||i.range.max==undefined?5:i.range.max,ii=kt-bt,i.range=u=="double"?this._getDoubleAutoRange(i,bt,kt,ii):this._getLogAutoRange(i,bt,kt,ii)):i.range={min:0,max:5,interval:1,Delta:4};ni=n.extend({},ej.EjSvgRender.commonChartEventArgs);ni.data={range:i.range,axis:i};this.chartObj._trigger("axesRangeCalculate",ni);ut=ni.data.range;i.range={min:ut.min,max:ut.max,interval:ut.interval,delta:ut.max-ut.min}},_calculateTrendLineRange:function(n,t,i){for(var f,u,e,r,l,s,h,c,a=i.length,o=0;o<a;o++)if(u=i[o],e=u.trendlines,n.model.AreaType=="cartesianaxes"&&(t.name==u._xAxisName||t.name==u._yAxisName))for(s=e.length,f=0;f<s;f++)r=e[f],r.visibility.toLowerCase()==="visible"&&(t.name==u._xAxisName?(h=r.type.toLowerCase(),c=new ej.trendlineTypes[h],c.calculateTrendLineSegment(u,r,t,n)):t.name==u._yAxisName&&!t.setRange&&r.points&&r.points.length>1&&(l=r.points.length-1,t.range.min=t.range.min>r.minY?r.minY:t.range.min,t.range.max=t.range.max<r.maxY?r.maxY:t.range.max));return!1},AlignRangeStart:function(n,t,i){var r=new Date(n),u,f,e,o,s,h,c;return i.toLowerCase()=="days"?(u=Math.floor(Math.floor(n.getDate()/t)*t),r=new Date(n.getFullYear(),n.getMonth(),u,0,0,0)):i.toLowerCase()=="hours"?(f=Math.floor(Math.floor(n.getHours()/t)*t),r=new Date(n.getFullYear(),n.getMonth(),n.getDate(),f,0,0)):i.toLowerCase()=="milliseconds"?(e=Math.floor(Math.floor(n.getMilliseconds()/t)*t),r=new Date(n.getFullYear(),n.getMonth(),n.getDate(),n.getHours(),n.getMinutes(),n.getSeconds(),e)):i.toLowerCase()=="seconds"?(o=Math.floor(Math.floor(n.getSeconds()/t)*t),r=new Date(n.getFullYear(),n.getMonth(),n.getDate(),n.getHours(),n.getMinutes(),o,0)):i.toLowerCase()=="minutes"?(s=Math.floor(Math.floor(n.getMinutes()/t)*t),r=new Date(n.getFullYear(),n.getMonth(),n.getDate(),n.getHours(),s,0,0)):i.toLowerCase()=="months"?(h=Math.floor(Math.floor(n.getMonth()/t)*t),r=new Date(n.getFullYear(),h,n.getDate(),0,0,0)):i.toLowerCase()=="years"&&(c=Math.floor(Math.floor(n.getFullYear()/t)*t),r=new Date(c,n.getMonth(),n.getDate(),0,0,0)),r},_increaseDateTimeInterval:function(n,t,i){var r=new Date(n);return i.toLowerCase()=="days"?r.setDate(n.getDate()+t):i.toLowerCase()=="hours"?r.setHours(n.getHours()+t):i.toLowerCase()=="milliseconds"?r.setMilliseconds(n.getMilliseconds()+t):i.toLowerCase()=="seconds"?r.setSeconds(n.getSeconds()+t):i.toLowerCase()=="minutes"?r.setMinutes(n.getMinutes()+t):i.toLowerCase()=="months"?r.setMonth(n.getMonth()+t):i.toLowerCase()=="years"&&r.setYear(n.getFullYear()+t),r},_calculatePadding:function(n){var t=typeof n.range.min=="string"&&!isNaN(Date.parse(n.range.min))?Date.parse(n.range.min):n.range.min.getTime(),i=typeof n.range.max=="string"&&!isNaN(Date.parse(n.range.max))?Date.parse(n.range.max):n.range.max.getTime(),d=this._increaseDateTimeInterval(new Date(t),n.range.interval,n._intervalType).getTime()-t,r=n.rangePadding.toLowerCase(),b,h,c,l,f,a,v,e,y,u,k,o,p,s,w;if(!this.chartObj.zoomed&&!n.setRange)if(t=new Date(t),i=new Date(i),b=n._intervalType.toLowerCase(),n.rangePadding.toLowerCase()=="none")t=t.getTime(),i=i.getTime();else if(r=="additional"||r=="round")switch(b){case"years":h=t.getFullYear();c=i.getFullYear();n.rangePadding.toLowerCase()=="additional"?(t=new Date(h-n.range.interval,1,1,0,0,0).getTime(),i=new Date(c+n.range.interval,1,1,0,0,0).getTime()):(t=new Date(h,0,0,0,0,0).getTime(),i=new Date(c,11,30,23,59,59).getTime());break;case"months":l=t.getMonth();f=i.getMonth();r=="round"?(t=new Date(t.getFullYear(),l,0,0,0,0).getTime(),i=new Date(i.getFullYear(),f,new Date(i.getFullYear(),i.getMonth(),0).getDate(),23,59,59).getTime()):(t=new Date(t.getFullYear(),l+-n.range.interval,1,0,0,0).getTime(),i=new Date(i.getFullYear(),f+n.range.interval,f==2?28:30,0,0,0).getTime());break;case"days":a=t.getDate();v=i.getDate();r=="round"?(t=new Date(t.getFullYear(),t.getMonth(),a,0,0,0).getTime(),i=new Date(i.getFullYear(),i.getMonth(),v,23,59,59).getTime()):(t=new Date(t.getFullYear(),t.getMonth(),a+-n.range.interval,0,0,0).getTime(),i=new Date(i.getFullYear(),i.getMonth(),v+n.range.interval,0,0,0).getTime());break;case"hours":e=t.getHours()/n.range.interval*n.range.interval;y=i.getHours()+(t.getHours()-e);r=="round"?(t=new Date(t.getFullYear(),t.getMonth(),t.getDay(),e,0,0).getTime(),i=new Date(i.getFullYear(),i.getMonth(),i.getDay(),y,59,59).getTime()):(t=new Date(t.getFullYear(),t.getMonth(),t.getDay(),e+-n.range.interval,0,0).getTime(),i=new Date(i.getFullYear(),i.getMonth(),i.getDay(),y+n.range.interval,0,0).getTime());break;case"minutes":u=t.getMinutes()/n.range.interval*n.range.interval;k=i.getMinutes()+(t.getMinutes()-u);r=="round"?(t=new Date(t.getFullYear(),t.getMonth(),t.getDay(),t.getHour(),u,0).getTime(),i=new Date(i.getFullYear(),i.getMonth(),i.getDay(),i.getHour(),k,59).getTime()):(t=new Date(t.getFullYear(),t.getMonth(),t.getDay(),t.getHours(),u+-n.range.interval,0).getTime(),i=new Date(i.getFullYear(),i.getMonth(),i.getDay(),i.getHours(),u+n.range.interval,0).getTime());break;case"seconds":o=t.getSeconds()/n.range.interval*n.range.interval;p=i.getSeconds()+(t.getSeconds()-o);r=="round"?(t=new Date(t.getFullYear(),t.getMonth(),t.getDay(),t.getHours(),t.getMinutes(),o,0).getTime(),i=new Date(i.getFullYear(),i.getMonth(),i.getDay(),i.getHour(),i.getMinutes(),p,0).getTime()):(t=new Date(t.getFullYear(),t.getMonth(),t.getDay(),t.getHours(),t.getMinutes(),o+-n.range.interval,0).getTime(),i=new Date(i.getFullYear(),i.getMonth(),i.getDay(),i.getHours(),i.getMinutes(),p+n.range.interval,0).getTime());break;case"milliseconds":s=t.getMilliseconds()/n.range.interval*n.range.interval;w=i.getMilliseconds()+(t.getMilliseconds()-s);r=="round"?(t=new Date(t.getFullYear(),t.getMonth(),t.getDay(),t.getHours(),t.getMinutes(),t.getSeconds(),s).getTime(),i=new Date(i.getFullYear(),i.getMonth(),i.getDay(),i.getHours(),i.getMinutes(),i.getSeconds(),w).getTime()):(t=new Date(t.getFullYear(),t.getMonth(),t.getDay(),t.getHours(),t.getMinutes(),t.getSeconds(),s+-n.range.interval).getTime(),i=new Date(i.getFullYear(),i.getMonth(),i.getDay(),i.getHours(),i.getMinutes(),i.getSeconds(),w+n.range.interval).getTime())}n.actualRange.interval=d;n.actualRange.min=t;n.actualRange.max=i;n._interval=n.range.interval;n.actualRange.delta=n.actualRange.max-n.actualRange.min;n.range.min=new Date(t);n.range.max=new Date(i);this._calculateVisibleRange(n)},_calculateVisibleRange:function(t,i,r){var e,u,f,o,s;if(this.chartObj=i?i:this.chartObj,t.visibleRange=r?t.visibleRange:n.extend(!0,{},t.actualRange),(t.zoomFactor<1||t.zoomPosition>0)&&this.chartObj.model.AreaType!="polaraxes"&&!this.chartObj.model.disableZoom){t.zoomFactor=t.zoomFactor>1?1:t.zoomFactor<0?0:t.zoomFactor;t.zoomPosition=t.zoomPosition<0?0:t.zoomPosition>1?1:t.zoomPosition;e=t.actualRange;t.isInversed?(u=t.actualRange.max-t.zoomPosition*t.actualRange.delta,f=u-t.zoomFactor*t.actualRange.delta):(u=t.actualRange.min+t.zoomPosition*t.actualRange.delta,f=u+t.zoomFactor*t.actualRange.delta);u<e.min&&(f=f+(e.min-u),u=e.min);f>e.max&&(u=u-(f-e.max),f=e.max);o=new Date(u);s=new Date(f);u==f&&(o=new Date(Date.parse(o)-2592e6),s=new Date(Date.parse(s)+2592e6));var c=Math.min(o.getTime(),s.getTime()),l=Math.max(o.getTime(),s.getTime()),h=t.enableAutoIntervalOnZooming?this.calculateDateTimeNiceInterval(t,o,s):{interval:t._interval,intervalType:t._intervalType},a=this._increaseDateTimeInterval(o,h.interval,h.intervalType).getTime()-c;if(r)return{min:c,max:l,interval:a};t._intervalType=h.intervalType;t.visibleRange.min=c;t.visibleRange.max=l;t.visibleRange.interval=a;t.visibleRange.delta=Math.abs(t.visibleRange.max-t.visibleRange.min);t._interval=h.interval}},_calculateAxisLabels:function(t){for(var u,f=t.enableAutoIntervalOnZooming?t.visibleRange.min:t.actualRange.min,r,i=this.chartObj.zoomed||t.zoomed||!t.setRange?this.AlignRangeStart(new Date(f),t._interval,t._intervalType).getTime():t.visibleRange.min;i<=t.visibleRange.max;)i>=t.visibleRange.min&&i<=t.visibleRange.max&&(u=ej.format(new Date(i),t.labelFormat?t.labelFormat:ej.EjSvgRender.utils._dateTimeLabelFormat(t._intervalType,t),this.chartObj.model.locale),r=n.extend({},ej.EjSvgRender.commonChartEventArgs),r.data={label:{Text:u,Value:i},axis:t},this.chartObj._trigger("axesLabelRendering",r),t.visibleLabels.push({Value:i,Text:r.data.label.Text})),i=this._increaseDateTimeInterval(new Date(i),t._interval,t._intervalType).getTime(),t.visibleLabels[t.visibleLabels.length-1]=t.visibleLabels[t.visibleLabels.length-1];t._LableMaxWidth=ej.EjSvgRender.utils._getMaxLabelWidth(t,this.chartObj)},calculateDateTimeNiceInterval:function(n,t,i){var u=Math.abs((t.getTime()-i.getTime())/864e5),r=this.calculateNumericNiceInterval(u/365,n,"years"),f,e,o,s;return r>=1?{interval:r,intervalType:"Years"}:(r=this.calculateNumericNiceInterval(u/30,n,"months"),r>=1)?{interval:r,intervalType:"Months"}:(r=this.calculateNumericNiceInterval(u,n,"days"),r>=1)?{interval:r,intervalType:"Days"}:(f=u*24,r=this.calculateNumericNiceInterval(f,n,"hours"),r>=1)?{interval:r,intervalType:"Hours"}:(e=u*1440,r=this.calculateNumericNiceInterval(e,n,"minutes"),r>=1)?{interval:r,intervalType:"Minutes"}:(o=u*86400,r=this.calculateNumericNiceInterval(o,n,"seconds"),r>=1)?{interval:r,intervalType:"Seconds"}:(s=u*864e5,r=this.calculateNumericNiceInterval(s,n,"milliseconds"),r>=1?{interval:r,intervalType:"Milliseconds"}:void 0)},calculateNumericNiceInterval:function(n,t,i,r){var o=this.GetActualDesiredIntervalsCount(t,t.length),u=n/o,f,e;if(t._valueType=="double"&&t.desiredIntervals!=null)return u;var h=Math.pow(10,Math.floor(ej.EjSvgRender.utils._logBase(u,10))),s=[10,5,2,1],c=r||t.range&&t.range.max;for(f=0;f<s.length;f++){if(e=h*s[f],o<n/e)return t._valueType=="datetime"?!ej.util.isNullOrUndefined(t.intervalType)&&t.intervalType.toLowerCase()==i?Math.ceil(u):u:ej.util.isNullOrUndefined(t.range)||ej.util.isNullOrUndefined(t.range.max)?u:u>c?e:u;u=e}return u},GetActualDesiredIntervalsCount:function(n,t){if(ej.util.isNullOrUndefined(n.desiredIntervals)){var i=(n.orientation.toLowerCase()=="horizontal"?.533:1)*n.maximumLabels;return Math.max(t*(i/100),1)}return n.desiredIntervals},_calculateRange:function(t,i){var o,c,y,p,s,r,l,a,u,f,v,b,e,k,w,h;if(!this.chartObj.zoomed){if(o=new Date,i.length>0&&this.chartObj.model._hasSeriesPoints&&i[0].points.length>0||this.chartObj.model.indicators[0]._points.length>0){for(r={maxX:null,minX:null},l={maxY:null,minY:null},u=0;u<i.length;u++){if(a=i[u].points.length,a>0&&i[u].visibility.toLowerCase()==="visible"&&i[u].points.length>0){for(s=c=new Date(i[u].points[0].xValue),p=y=i[u].points[0].YValues[0],f=0;f<a;f++)s!=null&&s!=undefined?(s>i[u].points[f].xValue&&(s=i[u].points[f].xValue),c<i[u].points[f].xValue&&(c=i[u].points[f].xValue)):s=c=new Date(i[u].points[f+1].xValue),y>i[u].points[f].YValues[0]&&(y=i[u].points[f].YValues[0]),p<i[u].points[f].YValues[0]&&(p=i[u].points[f].YValues[0]);i[u].minX=s;i[u].maxX=c;i[u].minY=y;i[u].maxY=p;(!t.maxPointLength||t.maxPointLength<a)&&(t.maxPointLength=a)}(r.minX=r.minX==null&&typeof i[u].minX!="number"?i[u].minX:r.minX)>i[u].minX&&(r.minX=typeof i[u].minX!="number"?i[u].minX:r.minX);(r.maxX=r.maxX==null&&typeof i[u].maxX!="number"?i[u].maxX:r.maxX)<i[u].maxX&&(r.maxX=typeof i[u].maxX!="number"?i[u].maxX:r.maxX);l.minY>i[u].minY&&(l.minY=i[u].minY);l.maxY<i[u].maxY&&(l.maxY=i[u].maxY)}this.chartObj.model.indicatorRange&&this.chartObj.model.indicatorRange[t.name]&&(v=this.chartObj.model.indicatorRange[t.name],(r.minX>new Date(v.min)||r.minX==null)&&(r.minX=new Date(v.min)),(r.maxX<new Date(v.max)||r.maxX==null)&&(r.maxX=new Date(v.max)));r.minX=r.minX==null?o:r.minX;r.maxX=r.maxX==null?new Date((new Date).setMonth(o.getMonth()+5)):r.maxX;r.minX==r.maxX&&(r.minX=new Date(Date.parse(r.minX)-2592e6),r.maxX=new Date(Date.parse(r.maxX)+2592e6));b=_sideBySeriesPadding(this.chartObj,r.minX.getTime(),r.maxX.getTime(),t);r.minX=new Date(b.startPadding);r.maxX=new Date(b.endPadding);e=this.calculateDateTimeNiceInterval(t,r.minX,r.maxX);t._intervalType=t.intervalType?t.intervalType:e.intervalType;t.intervalType=="auto"&&(t._intervalType=t.intervalType=e.intervalType);(t.setAxisInterval==null||t.setAxisInterval==undefined)&&(t.setAxisInterval=t.range&&t.range.interval?!0:!1);t._setInterval&&!this.chartObj._chartResize&&t.range&&t._setInterval!=t.range.interval&&(t._setInterval=null);t.setRange?(t.range.max||(t.range.max=r.maxX),t.range.min||(t.range.min=r.minX),typeof t.range.min=="string"&&t.range.min.indexOf("/Date(")!=-1&&(t.range.min=new Date(parseInt(t.range.min.substr(6)))),typeof t.range.max=="string"&&t.range.max.indexOf("/Date(")!=-1&&(t.range.max=new Date(parseInt(t.range.max.substr(6)))),new Date(t.range.min).getTime()==new Date(t.range.max).getTime()&&(t.range.max=new Date(Date.parse(t.range.max)+864e5)),e=this.calculateDateTimeNiceInterval(t,new Date(t.range.min),new Date(t.range.max)),t._intervalType=t.intervalType?t.intervalType:e.intervalType,t.setAxisInterval||(t.range.interval=e.interval,t._setInterval=e.interval),t.actual_Range=n.extend(!0,{},t.range),t.setRange=!0,k=t._setInterval?e.interval:t.range.interval||t.actual_Range.interval,t.range={min:t.actual_Range.min,max:t.actual_Range.max,interval:k}):t.range={min:r.minX,max:r.maxX,interval:e.interval}}else t.setRange?(t.range.min=t.range.min===null||t.range.min===undefined?o:t.range.min,t.range.max=t.range.max===null||t.range.max===undefined?new Date((new Date).setMonth(o.getMonth()+5)):t.range.max,t.range.interval=t.range.interval===null||t.range.interval===undefined?1:t.range.interval,t._intervalType="Months"):(t.range={min:o,max:new Date((new Date).setMonth(o.getMonth()+5)),interval:1},t._intervalType=ej.util.isNullOrUndefined(t.intervalType)?"Months":t.intervalType);w=n.extend({},ej.EjSvgRender.commonChartEventArgs);w.data={range:t.range,axis:t};this.chartObj._trigger("axesRangeCalculate",w);h=w.data.range;t.range={min:h.min,max:h.max,interval:h.interval,delta:h.max-h.min}}},_calculateRanges:function(n,t,i){this.chartObj=n;this._saveRange(n,t);this._calculateRange(t,i);t._range=t.range;n.model._drawTrendline&&this._calculateTrendLineRange(n,t,i);this._calculatePadding(t);this._calculateAxisLabels(t)},_saveRange:function(n,t){(n.zoomed||n.resetZooming)&&(t.range=t.range!=null&&t.range.min!=null&&t.range.max!=null?t.range:t._range);t._initialRange&&(t._initialRange!=t.range&&t.range!=null?t.setRange=!0:t.range==null&&(t.setRange=!1));t._initialRange=t.range==null?{min:null,max:null,interval:null}:{min:t.range.min,max:t.range.max,interval:t.range.interval}}};i=t(ej.EjAxisRenderer);ej.axisTypes.datetime=i;r=t(ej.EjAxisRenderer,{_calculateRange:function(n,t,i,r){n.zoomed||this._seriesMinMax(n,t,i,"double",r)},_getDoubleAutoRange:function(t,i,r){var e,u,f;return t.setRange?(ej.util.isNullOrUndefined(t.range.max)&&(t.range.max=r),ej.util.isNullOrUndefined(t.range.min)&&(t.range.min=i),t.actual_Range=n.extend(!0,{},t.range),t.setRange=!0):t.range={min:i,max:r},e=t.range.max-t.range.min,u=this.calculateNumericNiceInterval(e,t),ej.EjSvgRender.utils._decimalPlaces(u)>20&&(f=u.toString(),u=parseFloat(f.substring(0,f.indexOf("."))+f.substring(f.indexOf("."),22))),(ej.util.isNullOrUndefined(t.range.interval)||t.range.interval<0)&&(t.range.interval=u),t.range.delta=e,t.range},_calculatePadding:function(n,t,i){var e=i.min,u=i.max,s=t.rangePadding.toLowerCase(),r=i.interval,o,h,f;t.setRange||n.zoomed||(s=="normal"?(o=0,e<0?(e=0,o=i.min+i.min/20,h=r+o%r,.365*r>=h&&(o-=r),o%r<0&&(o=o-r-o%r)):(o=e<5/6*u?0:e-(u-e)/2,o%r>0&&(o-=o%r)),f=u>0?u+(u-e)/20>Number.MAX_VALUE?Number.MAX_VALUE:u+(u-e)/20:u-(u-e)/20,h=r-f%r,.365*r>=h&&(f=f+r>Number.MAX_VALUE?Number.MAX_VALUE:f+r),f%r>0&&(f=f+r-f%r>Number.MAX_VALUE?Number.MAX_VALUE:f+r-f%r),o<=0&&(r=this.calculateNumericNiceInterval(f-o,t),f=Math.ceil(f/r)*r>Number.MAX_VALUE?Number.MAX_VALUE:Math.ceil(f/r)*r),e=t.roundingPlaces?parseFloat(o.toFixed(t.roundingPlaces)):parseFloat(o.toFixed(ej.EjSvgRender.utils._decimalPlaces(r)==0?1:ej.EjSvgRender.utils._decimalPlaces(r))),u=t.roundingPlaces?parseFloat(f.toFixed(t.roundingPlaces)):parseFloat(f.toFixed(ej.EjSvgRender.utils._decimalPlaces(r)==0?1:ej.EjSvgRender.utils._decimalPlaces(r)))):(s=="additional"||s=="round")&&(e=Math.floor(e/r)*r,u=Math.ceil(u/r)*r>Number.MAX_VALUE?Number.MAX_VALUE:Math.ceil(u/r)*r,s=="additional"&&(e-=r,u=u+r>=Number.MAX_VALUE?Number.MAX_VALUE:u+r)));t.actualRange.min=e;t.actualRange.max=u;t.actualRange.interval=r;t.range.min=e;t.range.max=u;t.range.interval=r;t.actualRange.delta=u-e>=Number.MAX_VALUE?u:u-e;this._calculateVisibleRange(t);t.rangePadding=t._rangePadding},_calculateVisibleRange:function(t,i,r){var e,u,f,o,s;if(this.chartObj=i?i:this.chartObj,t.visibleRange=r?t.visibleRange:n.extend(!0,{},t.actualRange),(t.zoomFactor<1||t.zoomPosition>0)&&this.chartObj.model.AreaType!="polaraxes"&&!this.chartObj.model.disableZoom){if(e=t.actualRange,t.zoomFactor=t.zoomFactor>1?1:t.zoomFactor<0?0:t.zoomFactor,t.zoomPosition=t.zoomPosition<0?0:t.zoomPosition>1?1:t.zoomPosition,t.isInversed?(u=t.actualRange.max-t.zoomPosition*t.actualRange.delta,f=u-t.zoomFactor*t.actualRange.delta):(u=t.actualRange.min+t.zoomPosition*t.actualRange.delta,f=u+t.zoomFactor*t.actualRange.delta),u<e.min&&(f=f+(e.min-u),u=e.min),f>e.max&&(u=u-(f-e.max),f=e.max),o=Math.abs(f-u),s=t.enableAutoIntervalOnZooming?this.calculateNumericNiceInterval(o,t):t.actualRange.interval,r)return{min:Math.min(u,f),max:Math.max(u,f),delta:o,interval:s};t.visibleRange.min=Math.min(u,f);t.visibleRange.max=Math.max(u,f);t.visibleRange.delta=o;t.visibleRange.interval=s;t.zoomed=this.chartObj.zoomed===null||this.chartObj.zoomed===undefined?!0:this.chartObj.zoomed}},_calculateAxisLabels:function(t,i){var r,u,e=i.roundingPlaces,a,y,h,f,v=this.chartObj.model.locale,p,k=i.labelFormat,o,w=20,c,l,s,b;for(i.visibleRange.min=parseFloat(i.visibleRange.min.toPrecision(14)),i.visibleRange.max=parseFloat(i.visibleRange.max.toPrecision(14)),r=t.zoomed||i.zoomed||i.padding?i.visibleRange.min-i.visibleRange.min%i.visibleRange.interval:i.visibleRange.min;r<=i.visibleRange.max;r+=i.visibleRange.interval)if(ej.EjSvgRender.utils._inside(r,i.visibleRange)){if(r==p)break;p=r;a=r.toString().split(0).length-1>10?10:20;r=parseFloat(r.toFixed(!e&&e>a?e:a));y=e?r:parseFloat(r.toFixed(ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval)==0?1:ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval)));f=e?parseFloat(r.toFixed(e)):parseFloat(r.toFixed(ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval)==0?1:ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval)));u=i.labelFormat;u?u.match("{value}")!=null?f=u.replace("{value}",f):(u.indexOf("e")==0||u.indexOf("E")==0)&&u.indexOf("ej.format")==-1?(o=u.match(/(\d+)/g),o=o==null?6:o>w?w:o,f=f.toExponential(o)):(u.indexOf("ej.format")!=-1&&(u=u.substring(u.indexOf("(")+1,u.indexOf(")"))),f=ej.format(f,u,v)):f=i.isStacked100?f+"%":v?f.toLocaleString(v):f;h=n.extend({},ej.EjSvgRender.commonChartEventArgs);h.data={label:{Text:f,Value:r},axis:i};t._trigger("axesLabelRendering",h);i.visibleLabels.push({Value:y,Text:h.data.label.Text})}for(c=0,l=i.visibleLabels,s=0;s<l.length;s++)typeof l[s].Text=="string"&&(b=l[s].Text.split("<br>").length,c=Math.max(b,c));i.rowsCount=c;i._LableMaxWidth=ej.EjSvgRender.utils._getMaxLabelWidth(i,this.chartObj)},_calculateRanges:function(n,t,i,r){this.chartObj=n;this._saveRange(n,t);this._calculateRange(n,t,i,r);t._range=t.range;n.model._drawTrendline&&this._calculateTrendLineRange(n,t,i);this._calculatePadding(n,t,t.range);t.maximumLabels>0&&this._calculateAxisLabels(n,t)}});ej.axisTypes.double=r;u=t(ej.EjAxisRenderer,{_getRoundValue:function(n,t,i){return(i?Math.ceil(n/t):Math.floor(n/t))*t},calculateLogNiceInterval:function(n,t){for(var u,e=this.GetActualDesiredIntervalsCount(t,t.length),i=n,o=Math.pow(10,Math.floor(ej.EjSvgRender.utils._logBase(i,10))),f=[10,5,2,1],r=0;r<f.length;r++){if(u=o*f[r],e<n/u)return i;i=u}return i},_getLogAutoRange:function(t,i,r,u){var s=ej.EjSvgRender.utils._logBase(i,t.logBase),o,f,e,h;return s=n.isNumeric(s)?s:i,o=ej.EjSvgRender.utils._logBase(r,t.logBase),o=n.isNumeric(o)?o:r,f=this._getRoundValue(s,1,!1),e=this._getRoundValue(o,1,!0),f==0&&e==0&&(f=ej.EjSvgRender.utils._logBase(r-r/2,t.logBase),e=ej.EjSvgRender.utils._logBase(r+r/2,t.logBase)),u=e-f,h=this.calculateLogNiceInterval(u,t),t.actual_Range={min:f,max:e,interval:h,Delta:u},f=Math.pow(t.logBase,Math.floor(s)),e=Math.pow(t.logBase,Math.ceil(o)),u=e-f,t.setRange?(ej.util.isNullOrUndefined(t.range.interval)&&(t.range.interval=h),ej.util.isNullOrUndefined(t.range.max)&&(t.range.max=e),ej.util.isNullOrUndefined(t.range.min)&&(t.range.min=f),t.actual_Range=n.extend(!0,{},t.range),ej.util.isNullOrUndefined(t.actual_Range.max)||(t.actual_Range.max=ej.EjSvgRender.utils._logBase(t.actual_Range.max,t.logBase),t.actual_Range.max=this._getRoundValue(t.actual_Range.max,1,!0)),ej.util.isNullOrUndefined(t.range.min)||(t.actual_Range.min=ej.EjSvgRender.utils._logBase(t.actual_Range.min,t.logBase),t.actual_Range.min=this._getRoundValue(t.actual_Range.min,1,!1)),t.setRange=!0,t.range):t.range={min:f,max:e,interval:h,Delta:u}},_calculateLogRange:function(n,t,i,r){n.zoomed||this._seriesMinMax(n,t,i,"logarithmic",r)},_calculateLogPadding:function(n,t,i){var r=i.min,u=i.max,f=i.interval;t.actualRange.min=r;t.actualRange.max=u;t.actualRange.interval=f;t.actualRange.delta=u-r;this._calculateVisibleRange(t)},_calculateVisibleRange:function(t,i,r){var e,u,f;if(this.chartObj=i?i:this.chartObj,t.visibleRange=r?t.visibleRange:n.extend(!0,{},t.actualRange),(t.zoomFactor<1||t.zoomPosition>0)&&this.chartObj.model.AreaType!="polaraxes"&&!this.chartObj.model.disableZoom){t.zoomFactor=t.zoomFactor>1?1:t.zoomFactor<0?0:t.zoomFactor;t.zoomPosition=t.zoomPosition<0?0:t.zoomPosition>1?1:t.zoomPosition;e=t.actualRange;t.isInversed?(u=t.actualRange.max-t.zoomPosition*t.actualRange.delta,f=u-t.zoomFactor*t.actualRange.delta):(u=t.actualRange.min+t.zoomPosition*t.actualRange.delta,f=u+t.zoomFactor*t.actualRange.delta);u<e.min&&(f=f+(e.min-u),u=e.min);f>e.max&&(u=u-(f-e.max),f=e.max);var s=Math.abs(f-u),o=t.enableAutoIntervalOnZooming?this.calculateLogNiceInterval(s,t):t.visibleRange.interval,h=ej.util.isNullOrUndefined(t.roundingPlaces)?ej.EjSvgRender.utils._decimalPlaces(t.visibleRange.interval)==0?1:ej.EjSvgRender.utils._decimalPlaces(t.visibleRange.interval):t.roundingPlaces;if(o=parseFloat(t.visibleRange.interval.toFixed(h)),r)return{min:Math.min(u,f),max:Math.max(u,f),interval:o};t.visibleRange.interval=o;t.visibleRange.min=Math.min(u,f);t.visibleRange.max=Math.max(u,f);t.visibleRange.delta=s;t.zoomed=this.chartObj.zoomed===null||this.chartObj.zoomed===undefined?!0:this.chartObj.zoomed}},_calculateAxisLabels:function(t,i){for(var e=i.roundingPlaces,s,f,r=t.zoomed||i.zoomed?i.visibleRange.min-i.visibleRange.min%i.visibleRange.interval:i.visibleRange.min;r<=i.visibleRange.max;r+=i.visibleRange.interval)if(ej.EjSvgRender.utils._inside(r,i.visibleRange)){var h=i.labelFormat?i.labelFormat.match("{value}"):null,u=Math.pow(i.logBase,r),o=u.toString().split(0).length-1>10?10:20;u=parseFloat(u.toFixed(!e&&e>o?e:o));s=i.labelFormat?h!=null?i.labelFormat.replace("{value}",u):ej.format(u,i.labelFormat,t.model.locale):u;f=n.extend({},ej.EjSvgRender.commonChartEventArgs);f.data={label:{Text:s,Value:r},axis:i};t._trigger("axesLabelRendering",f);i.visibleLabels.push({Value:r,Text:f.data.label.Text})}i._LableMaxWidth=ej.EjSvgRender.utils._getMaxLabelWidth(i,this.chartObj)},_calculateRanges:function(n,t,i,r){this.chartObj=n;this._calculateLogRange(n,t,i,r);n.model._drawTrendline&&this._calculateTrendLineRange(n,t,i);this._calculateLogPadding(n,t,t.actual_Range);this._calculateAxisLabels(n,t)}});ej.axisTypes.logarithmic=u;f=t(ej.EjAxisRenderer,{_calculateCategoryRange:function(t,i){var tt=this.chartObj.model.legendCollapsed==undefined?!this.chartObj.zoomed:this.chartObj.model.legendCollapsed,e,h,r,o,a,l;if(!this.chartObj.model.excludeDataUpdate||tt){var u={maxX:null,minX:0},f=[],s,y,c,b,p,k=t.isIndexed,d=this.chartObj.model.locale;if(i.length>0&&this.chartObj.model._hasSeriesPoints&&i[0].points.length>0||this.chartObj.model.indicators[0]._points.length>0){for(e=0;e<i.length;e++){for(p=i[e].points.length,h=0;h<p;h++)s=i[e]._xAxisValueType=="date"?ej.format(new Date(i[e].points[h].x),ej.util.isNullOrUndefined(t.labelFormat)?"dd/MM/yyyy":t.labelFormat,d):i[e].points[h].x,k?f[h]=e==0?s:f[h]+", "+s:(b=n.inArray(s,f),b<0&&f.push(s));(!t.maxPointLength||t.maxPointLength<p)&&(t.maxPointLength=p)}for(r=0;r<i.length;r++){for(i[r]._pointCollection=[],o=0;o<i[r].points.length;o++)i[r]._pointCollection.push(i[r].points[o].x),s=i[r]._xAxisValueType=="date"?ej.format(new Date(i[r].points[o].x),ej.util.isNullOrUndefined(t.labelFormat)?"dd/MM/yyyy":t.labelFormat,d):i[r].points[o].x,i[r].points[o].xValue=k?o:n.inArray(s,f);i[r].minX=0;i[r].maxX=i[r]._xAxisValueType=="date"?i[r]._pointCollection.length-1:f.length-1;r==0&&(u.maxX=i[r].maxX,t.labels=i[r]._xAxisValueType=="date"?i[r]._pointCollection:f,t._categoryValueType=i[r]._xAxisValueType);u.maxX<i[r].maxX&&(u.maxX=i[r].maxX,t.labels=[],t.labels=f)}this.chartObj.model.indicatorRange&&this.chartObj.model.indicatorRange[t.name]&&(a=this.chartObj.model.indicatorRange[t.name],(u.minX>a.min||u.minX==null)&&(u.minX=a.min),(u.maxX<a.max||u.maxX==null)&&(u.maxX=a.max));c=u.maxX-u.minX;y=t.setRange&&t.range.interval?Math.ceil(t.range.interval):this._calculateActualInterval(c,t);t.range={min:u.minX,max:u.maxX,interval:y,Delta:c}}else l=t.labels.length,l>0?(c=l-1,y=this._calculateActualInterval(c,t),t.range={min:0,max:l-1,interval:y,Delta:c}):t.range||(t.range={min:0,max:6,interval:1,Delta:6})}var w=0,v,g=t.labelIntersectAction,nt=t.labelRotation;if((g!="rotate45"||g!="rotate90")&&(nt==0||nt==null))for(v=0;v<t.labels.length;v++)typeof t.labels[v]=="string"&&(l=t.labels[v].split("<br>").length,w=Math.max(l,w));t.rowsCount=w},_calculateActualInterval:function(n,t){return t.categoryInterval==null?Math.max(1,Math.floor(n/this.GetActualDesiredIntervalsCount(t,t.length))):t.categoryInterval},_applyRangePadding:function(n){var t,i;this.chartObj.zoomed||this.chartObj._scrollBarEnabled||n.zoomed||(t=0,this.chartObj.model.AreaType!=="polaraxes"&&(t=n.labelPlacement===null||n.labelPlacement===undefined||n.labelPlacement===""?-.5:n.labelPlacement.toLowerCase()=="betweenticks"?-.5:0),this.chartObj.scrollsvgObj||(t<0?(n.range.min=n.range.min+t,n.range.max=n.range.max-t,n.range.delta=n.range.max-n.range.min,n.actualRange=n.range):(i=_sideBySeriesPadding(this.chartObj,n.range.min,n.range.max,n),n.range.min=i.startPadding,n.range.max=i.endPadding,n.range.delta=n.range.max-n.range.min,n.actualRange=n.range)));this._calculateVisibleRange(n)},_calculateVisibleRange:function(t,i,r){var e,u,f,o;if(this.chartObj=i?i:this.chartObj,t.visibleRange=r?t.visibleRange:n.extend(!0,{},t.actualRange),(t.zoomFactor<1||t.zoomPosition>0)&&this.chartObj.model.AreaType!="polaraxes"&&!this.chartObj.model.disableZoom){t.zoomFactor=t.zoomFactor>1?1:t.zoomFactor<0?0:t.zoomFactor;t.zoomPosition=t.zoomPosition<0?0:t.zoomPosition>1?1:t.zoomPosition;e=t.actualRange;t.isInversed?(u=t.actualRange.max-t.zoomPosition*t.actualRange.delta,f=u-t.zoomFactor*t.actualRange.delta):(u=t.actualRange.min+t.zoomPosition*t.actualRange.delta,f=u+t.zoomFactor*t.actualRange.delta);u<e.min&&(f=f+(e.min-u),u=e.min);f>e.max&&(u=u-(f-e.max),f=e.max);var o=Math.abs(f-u),s=this._calculateActualInterval(o,t),h=Math.min(u,f),c=Math.max(u,f);if(r)return{min:h,max:c,interval:s};o=Math.abs(f-u);t.visibleRange.interval=s;t.visibleRange.min=h;t.visibleRange.max=c;t.visibleRange.delta=o;t.zoomed=this.chartObj.zoomed===null||this.chartObj.zoomed===undefined?!0:this.chartObj.zoomed}},_calculateAxisLabels:function(t){for(var f=t.visibleRange.interval,i=t.visibleRange.min-t.visibleRange.min%t.range.interval,u,r;i<=t.visibleRange.max;i+=f)ej.EjSvgRender.utils._inside(i,t.visibleRange)&&(u=Math.round(i),t.visibleLabels.push({Value:u,Text:ej.EjSvgRender.utils._getLabelContent(u,t,this.chartObj.model.locale)}),r=n.extend({},ej.EjSvgRender.commonChartEventArgs),r.data={label:t.visibleLabels[t.visibleLabels.length-1],axis:t},this.chartObj._trigger("axesLabelRendering",r),t.visibleLabels[t.visibleLabels.length-1]=r.data.label);t._LableMaxWidth=ej.EjSvgRender.utils._getMaxLabelWidth(t,this.chartObj)},_calculateRanges:function(n,t,i){this.chartObj=n;this._saveRange(n,t);this._calculateCategoryRange(t,i);t._range=t.range;n.model._drawTrendline&&this._calculateTrendLineRange(n,t,i);this._applyRangePadding(t);this._calculateAxisLabels(t)}});ej.axisTypes.category=f;e=t(ej.EjAxisRenderer,{_calculateDateTimeCategoryRange:function(t,i){for(var v={minX:0,MaxX:null},w=[],a=[],e,st,g,it,nt,c,s,rt=[],b,tt=[],ut=[],o,f,h,l,ft,r,k,d,ht,et,ot,p,y,u=0;u<i.length;u++){for(i[u]._pointCollection=[],s=[],i[u]._points=[],i[u]._xPoints=[],i[u]._yPoints=[],ft=i[u].points.length,d=0;d<ft;d++)b=isNaN(new Date(i[u].points[d].x).getTime())?null:new Date(i[u].points[d].x).getTime(),s.indexOf(b)!=-1&&(i[u].points[d].xValue=s.indexOf(b)),s.push(b),i[u]._xPoints.push(b),i[u]._yPoints.push(i[u].points[d].y),b!=null&&tt.push(b);for(ej.isNullOrUndefined(t.intervalType)&&(nt=this.calculateDateTimeNiceInterval(t,new Date(Math.min.apply(null,tt)),new Date(Math.max.apply(null,tt))),t.intervalType=nt.intervalType.toLowerCase()),r=0;r<s.length;r++){if(e=new Date(s[r]),i[u]._points.indexOf(e.getTime())==-1&&i[u]._points.push(e.getTime()),ht=n.inArray(s[r],i[u]._xPoints),i[u]._pointCollection.push(new Date(i[u].points[r].x)),u==0)i[u].points[r].x==i[u].points[r].xValue&&(i[u].points[r].xValue=r);else for(y=0;y<u;y++)if(g=n.inArray(new Date(i[u].points[r].x).getTime(),i[y]._points),g>=0){i[u].points[r].xValue=y==0?g:i[y].points[g].xValue;break}else if(y==u-1){i[u].points[r].x==i[u].points[r].xValue?i[u].points[r].xValue=t.maxPointLength++:(et=i[u].points[r].xValue,i[u].points[r].xValue=i[u].points[et].xValue);break}st=u==0?-1:n.inArray(e.getTime(),rt);switch(t.intervalType){case"auto":w.indexOf(e.getTime())==-1&&w.push(e.getTime());break;case"years":f=e.getFullYear();break;case"months":l=e.getFullYear();o=e.getMonth();r<=0?f=r+1:(h=new Date(s[r-1]).getFullYear(),f+=l!=h?12-c+o:o-c);c=o;break;case"days":l=e.getMonth();o=e.getDate();r<=0?f=r+1:(h=new Date(s[r-1]).getMonth(),f+=l!=h?new Date(e.getFullYear(),h,1).getDate()-c+o:o-c,l==h&&(p=this._diffDate(e,new Date(s[r-1]),1),ot=new Date(e.getFullYear(),h,0).getDate(),f=p>ot?a[a.length-1]+1:f));c=o;break;case"hours":l=e.getDate();o=e.getHours();r<=0?f=r+1:(h=new Date(s[r-1]).getDate(),f+=l!=h?24-c+o:o-c,l==h&&(p=this._diffDate(e,new Date(s[r-1]),24),f=p>24?a[a.length-1]+1:f));c=o;break;case"minutes":l=e.getHours();o=e.getMinutes();r<=0?f=r+1:(h=new Date(s[r-1]).getHours(),f+=l!=h?60-c+o:o-c,l==h&&(p=this._diffDate(e,new Date(s[r-1]),1440),f=p>60?a[a.length-1]+1:f));c=o;break;case"seconds":l=e.getMinutes();o=e.getSeconds();r<=0?f=r+1:(h=new Date(s[r-1]).getMinutes(),f+=l!=h?60-c+o:o-c,l==h&&(p=this._diffDate(e,new Date(s[r-1]),86400),f=p>60?a[a.length-1]+1:f));c=o;break;case"milliseconds":l=e.getSeconds();o=e.getMilliseconds();r<=0?f=r+1:(h=new Date(s[r-1]).getSeconds(),f+=l!=h?1e3-c+o:o-c,l==h&&(p=this._diffDate(e,new Date(s[r-1]),864e5),f=p>1e3?a[a.length-1]+1:f));c=o}t.intervalType!="auto"&&w.indexOf(e.getTime())==-1&&w.push(e.getTime());f=u==0?f:a[a.length-1]+f;a.indexOf(f)==-1&&a.push(f);ut.push(f);rt.push(new Date(s[r]).getTime())}t.maxPointLength||(t.maxPointLength=t.intervalType!="auto"?a.length:w.length)}for(k=0;k<i.length;k++)t.setRange||(t.range={min:null,max:null,interval:null}),ej.isNullOrUndefined(t.m_minPointsDelta)||(t.m_minPointsDelta=undefined),i[k].minX=ej.isNullOrUndefined(t.range.min)?0:t.range.min<v.minX?0:t.range.min,i[k].maxX=ej.isNullOrUndefined(t.range.max)?w.length-1:t.range.max>w.length-1?w.length-1:t.range.max,v.MaxX=i[k].maxX,v.minX=i[k].minX,t.labels=w,t.dateLabels=ut,t._categoryValueType="date";if(v.minX==v.MaxX&&t.labelPlacement.toLowerCase()=="onticks"&&(v.MaxX+=1),i.length>0)it=v.MaxX-v.minX,nt=t.range.interval==null||t.range.interval==undefined?1:t.range.interval<1?1:Math.ceil(t.range.interval),t.range={min:v.minX,max:v.MaxX,interval:nt,Delta:it};else if(!t.setInterval)for(t.range={min:0,max:6,interval:1,Delta:6},t.dateLabels=[],y=0;y<=t.range.max;y++)t.labels.push(""),t.dateLabels.push("")},_diffDate:function(n,t,i){var r,u;return r=864e5,u=Math.abs(n.getTime()-t.getTime())/r,Math.round(u*i)},_calculateAxisLabels:function(t){for(var f=t.visibleRange.interval,o=[],c=this.chartObj.model.series.length,s,i,r,h,e,u=t.visibleRange.min-t.visibleRange.min%t.range.interval;u<=t.visibleRange.max;u+=f)ej.EjSvgRender.utils._inside(u,t.visibleRange)&&(i=Math.round(u),r=t.dateLabels,ej.util.isNullOrUndefined(r)||(r[r.length-1]-r[i]>=f&&t.visibleRange.max<u+f&&(t.visibleRange.max+=u+f-t.visibleRange.max),h=n.inArray(r[i],o)),(h<0||t.intervalType=="auto"||c==0)&&i<t.labels.length&&(t.intervalType!="auto"&&(s=r[i],o.push(s)),t.visibleLabels.push({Value:i,Text:!t.labelFormat&&t.labels[Math.floor(i)]!=""?ej.format(new Date(t.labels[Math.floor(i)]),ej.EjSvgRender.utils._dateTimeLabelFormat(t.intervalType,t),this.chartObj.model.locale):ej.EjSvgRender.utils._getLabelContent(i,t,this.chartObj.model.locale)}),e=n.extend({},ej.EjSvgRender.commonChartEventArgs),e.data={label:t.visibleLabels[t.visibleLabels.length-1],axis:t},this.chartObj._trigger("axesLabelRendering",e),t.visibleLabels[t.visibleLabels.length-1]=e.data.label));t._LableMaxWidth=ej.EjSvgRender.utils._getMaxLabelWidth(t,this.chartObj)},_calculateActualInterval:function(n,t){return t.categoryInterval==null?Math.max(1,Math.floor(n/this.GetActualDesiredIntervalsCount(t,t.length))):t.categoryInterval},_applyRangePadding:function(n){var t,i;this.chartObj.zoomed||this.chartObj._scrollBarEnabled||(t=0,this.chartObj.model.AreaType!=="polaraxes"&&(t=n.labelPlacement===null||n.labelPlacement===undefined?-.5:n.labelPlacement.toLowerCase()=="betweenticks"?-.5:0),t<0?(n.range.min=n.range.min+t,n.range.max=n.range.max-t,n.range.delta=n.range.max-n.range.min,n.actualRange=n.range):(i=_sideBySeriesPadding(this.chartObj,n.range.min,n.range.max,n),n.range.min=i.startPadding,n.range.max=i.endPadding,n.range.delta=n.range.max-n.range.min,n.actualRange=n.range));this._calculateVisibleRange(n)},_calculateVisibleRange:function(t,i,r){var e,u,f,o;if(this.chartObj=i?i:this.chartObj,t.visibleRange=r?t.visibleRange:n.extend(!0,{},t.actualRange),(t.zoomFactor<1||t.zoomPosition>0)&&this.chartObj.model.AreaType!="polaraxes"&&!this.chartObj.model.disableZoom){t.zoomFactor=t.zoomFactor>1?1:t.zoomFactor<0?0:t.zoomFactor;t.zoomPosition=t.zoomPosition<0?0:t.zoomPosition>1?1:t.zoomPosition;e=t.actualRange;t.isInversed?(u=t.actualRange.max-t.zoomPosition*t.actualRange.delta,f=u-t.zoomFactor*t.actualRange.delta):(u=t.actualRange.min+t.zoomPosition*t.actualRange.delta,f=u+t.zoomFactor*t.actualRange.delta);u<e.min&&(f=f+(e.min-u),u=e.min);f>e.max&&(u=u-(f-e.max),f=e.max);var o=Math.abs(f-u),s=this._calculateActualInterval(o,t),h=Math.min(u,f),c=Math.max(u,f);if(r)return{min:h,max:c,interval:s};o=Math.abs(f-u);t.visibleRange.interval=s;t.visibleRange.min=h;t.visibleRange.max=c;t.visibleRange.delta=o;t.zoomed=this.chartObj.zoomed===null||this.chartObj.zoomed===undefined?!0:this.chartObj.zoomed}},_calculateRanges:function(n,t,i){this.chartObj=n;this._saveRange(n,t);this._calculateDateTimeCategoryRange(t,i);n.model._drawTrendline&&this._calculateTrendLineRange(n,t,i);t._range=t.range;this._applyRangePadding(t);this._calculateAxisLabels(t)}});ej.axisTypes.datetimecategory=e;ej.EjAxisRenderer.prototype={_drawGridLines:function(n,t,i){this.model.AreaType=="cartesianaxes"?t.orientation.toLowerCase()=="horizontal"?this._drawXAxisGridLine(n,t,i):this._drawYAxisGridLine(n,t,i):t.orientation.toLowerCase()=="horizontal"&&n==0?(this._drawPolarGridLine(t),this._drawPolarLabels(t)):n==1&&this._drawPolarCircle(t)},_drawAxes:function(n,t){this.model.AreaType=="cartesianaxes"&&(t.visible&&t.orientation.toLowerCase()=="horizontal"&&(this._drawXAxisLabels(n,t),this._drawXTitle(n,t)),t.visible&&t.orientation.toLowerCase()=="vertical"&&(this._drawYAxisLabels(n,t),this._drawYTitle(n,t)))},_getSharpPath:function(n){return n%2==0?0:.5},_drawAxisLine:function(t){var u=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisLine"}),h=ej.EjSvgRender.utils._getStringBuilder(),y=this.model.centerX,p=this.model.centerY,w=this.model.centerX,b=this.model.centerY-this.model.Radius,k="M "+y+" "+p+" L "+w+" "+b,l,f,i;if(t.visible&&t.axisLine.visible&&(f={id:this.svgObject.id+"_YAxisLines",fill:"none","stroke-width":t.axisLine.width,stroke:t.axisLine.color,opacity:t.axisLine.opacity,"stroke-dasharray":t.axisLine.dashArray,d:k},this.svgRenderer.drawPath(f,u),n(u).appendTo(this.gPolarAxisEle)),t.visible&&t.majorTickLines.visible){for(u=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisMajorTicks"}),i=0;i<t.visibleLabels.length;i++){var d=t.visibleLabels[i],c=this.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t,d.Value,this),r={};r.X1=this.model.centerX;r.Y1=this.model.centerY-c;r.X2=r.X1-t.majorTickLines.size;r.Y2=r.Y1;h.append("M "+r.X1+" "+r.Y1+" L "+r.X2+" "+r.Y2+" ")}l=h.toString();f={id:this.svgObject.id+"_YAxisMajorTicks",fill:"none","stroke-width":t.majorTickLines.width,stroke:t.majorTickLines.color,d:l};this.svgRenderer.drawPath(f,u);n(u).appendTo(this.gPolarAxisEle)}if(t.visible){var u=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisLabels"}),e=t.font,a,v,g=t.visibleLabels.length;for(i=0;i<g;i++){var c=(this.model.Radius||this.model._radius)*ej.EjSvgRender.utils._valueToCoefficient(t,t.visibleLabels[i].Value,this),s=t.visibleLabels[i].Text,o=ej.EjSvgRender.utils._measureText(s,null,t.font),nt=this.model.centerX-t.majorTickLines.size-this.model.elementSpacing/3,tt=this.model.centerY-c+o.height/5,f={id:this.svgObject.id+"_"+t.name+"_YLabel_"+i,x:nt,y:tt,fill:e.color,"font-size":e.size,"font-family":e.fontFamily,"font-style":e.fontStyle,"font-weight":e.fontWeight,opacity:e.opacity,"text-anchor":"end"};this.svgRenderer.drawText(f,s,u);v=f.x-o.width;a={x:v,y:f.y,width:o.width,height:o.height};t.visibleLabels[i].region={bounds:a,labelText:s}}n(u).appendTo(this.gPolarAxisEle)}},_drawPolarLabels:function(t){var u,i,h,s;if(!t.visible)return 0;var v=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxisLabels"}),y=this.model.Radius+t.majorTickLines.size,e=t.font,p=t.visibleLabels.length,w,b,k,l;for(u=0;u<p;u++)if(i=ej.EjSvgRender.utils._valueToPolarCoefficient(t,t.visibleLabels[u].Value),h=ej.EjSvgRender.utils._valueToVector(t,t.visibleLabels[u].Value),!isNaN(h.X)&&!isNaN(h.Y)){var c=t.visibleLabels[u].Text,r=this.model.centerX+y*h.X,o=this.model.centerY+y*h.Y,a=r<this.model.centerX?"end":r>this.model.centerX?"start":"middle",f=ej.EjSvgRender.utils._measureText(c,this.model.m_AreaBounds.Height,t.font);i==.25?(r-=this.model.elementSpacing/2,o+=f.height/4):i==.5?o+=f.height:i==.75?(r+=this.model.elementSpacing/2,o+=f.height/4):i==1||i==0?o-=f.height/2:.25<i&&i<.5?(r-=this.model.elementSpacing/2,o+=f.height/2):.5<i&&i<=.75?(r+=this.model.elementSpacing/2,o+=f.height/2):0<i&&i<.25?r-=this.model.elementSpacing/2:r+=this.model.elementSpacing/2;u==0&&(w=r);u==p-1&&t._valueType!="category"&&(l=ej.EjSvgRender.utils._measureText(c,null,e).width,l+=r,l>w&&(c=""));s={id:this.svgObject.id+"_"+t.name+"_XLabel_"+u,x:r,y:o,fill:e.color,"font-size":e.size,"font-family":e.fontFamily,"font-style":e.fontStyle,"font-weight":e.fontWeight,opacity:e.opacity,"text-anchor":a};this.svgRenderer.drawText(s,c,v);k=a=="middle"?s.x-f.width/2:a=="end"?s.x-f.width:s.x;b={x:k,y:s.y,width:f.width,height:f.height};t.visibleLabels[u].region={bounds:b,labelText:c}}n(v).appendTo(this.gXaxisEle)},_drawPolarCircle:function(t){var s,o,i,h,u,f,r,e,l,a,v,y,c;if(t.majorGridLines.visible)if(s=ej.EjSvgRender.utils._getStringBuilder(),o=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisGrid"}),this.model.isPolar)for(i=0;i<t.visibleLabels.length;i++){var h=t.visibleLabels[i],u=this.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t,h.Value,this),c={id:this.svgObject.id+"_YAxisGridLines_"+i,cx:this.model.centerX,cy:this.model.centerY,r:u,fill:"transparent","stroke-width":t.majorGridLines.width,stroke:t.majorGridLines.color,opacity:this.vmlRendering?.3:t.majorGridLines.opacity};this.svgRenderer.drawCircle(c,o)}else{for(i=0;i<t.visibleLabels.length;i++)for(h=t.visibleLabels[i],u=this.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t,h.Value,this),f=0;f<this.model._axes[0].visibleLabels.length;f++)r=this.model._axes[0],e=ej.EjSvgRender.utils._valueToVector(r,r.visibleLabels[f].Value),isNaN(e.X)||isNaN(e.Y)||(l=f+1<r.visibleLabels.length?ej.EjSvgRender.utils._valueToVector(r,r.visibleLabels[f+1].Value):ej.EjSvgRender.utils._valueToVector(r,r.visibleLabels[0].Value),a={X:this.model.centerX+u*e.X,Y:this.model.centerY+u*e.Y},v={X:this.model.centerX+u*l.X,Y:this.model.centerY+u*l.Y},s.append("M "+a.X+" "+a.Y+" L "+v.X+" "+v.Y+" "));t.majorGridLines.visible&&(y=s.toString(),c={id:this.svgObject.id+"_YAxisGridLines",fill:"none","stroke-width":t.majorGridLines.width,stroke:t.majorGridLines.color,opacity:t.majorGridLines.opacity,"stroke-dasharray":t.majorGridLines.dashArray,d:y},this.svgRenderer.drawPath(c,o))}n(o).appendTo(this.gYaxisEle)},_drawPolarGridLine:function(t){var i=this.model,o=i.legend,ot=ej.EjSvgRender.utils._measureText(o.title.text,null,o.title.font).height,e=o.position.toLowerCase(),a=0,d=0,g=ej.EjSvgRender.utils._getStringBuilder(),nt=ej.EjSvgRender.utils._getStringBuilder(),tt=o.border.width,v,y,p,u,r,w,it,rt=t.visibleLabels.length,ut=i.border.width,s=i.title,h=i.title.subTitle,ft=s.enableTrim&&(s.textOverflow=="wrap"||s.textOverflow=="wrapandtrim")?!0:!1,et=h.text!=""&&h.visible&&h.enableTrim&&(h.textOverflow=="wrap"||h.textOverflow=="wrapandtrim")?!0:!1,c,st,b,f,k,l;if(o.visible&&e!="custom"&&(e=="right"||e=="left"?a=(e=="right"?i.margin.right:i.margin.left)+i.LegendActualBounds.Width+(tt+ut)*2:d=(e=="top"?i.margin.top:i.margin.bottom)+i.LegendActualBounds.Height+ot+(tt+ut)*2),v=(i.title.text&&i.title.visible?i._titleLocation.Y+(ft?i._titleLocation.size.height:0)+(et?i._subTitleLocation.size.height:0):0)+d,y=i.svgWidth-a,p=i.svgHeight-v,i.centerX=y*.5+(e==="left"?a:0),i.centerY=p*.5+(e==="top"?v:s.text&&s.visible?i._titleLocation.Y+(ft?i._titleLocation.size.height:0)+(et?i._subTitleLocation.size.height:0):0),c=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxisGrid"}),i.finalSize={width:y,height:p},i.Radius=Math.min(i.finalSize.width,i.finalSize.height)/2-2*i.elementSpacing-t.majorTickLines.size-t._LableMaxWidth.maxHeight,st=0,t.majorGridLines.visible)for(f=0;f<rt;f++)u=ej.EjSvgRender.utils._valueToVector(t,t.visibleLabels[f].Value),r={},r.X1=i.centerX,r.Y1=i.centerY,r.X2=i.centerX+i.Radius*u.X,r.Y2=i.centerY+i.Radius*u.Y,g.append("M "+r.X1+" "+r.Y1+" L "+r.X2+" "+r.Y2+" ");if(t.visible&&t.majorTickLines.visible)for(b=i.Radius,f=0;f<rt;f++)u=ej.EjSvgRender.utils._valueToVector(t,t.visibleLabels[f].Value),r={},r.X1=i.centerX+b*u.X,r.Y1=i.centerY+b*u.Y,r.X2=r.X1+t.majorTickLines.size*u.X,r.Y2=r.Y1+t.majorTickLines.size*u.Y,k="M "+r.X1+" "+r.Y1+" L "+r.X2+" "+r.Y2+" ",k.indexOf("NaN")==-1&&nt.append(k);t.majorGridLines.visible&&(w=g.toString(),l={id:this.svgObject.id+"_XAxisGridLines",fill:"none","stroke-width":t.majorGridLines.width,stroke:t.majorGridLines.color,opacity:t.majorGridLines.opacity,"stroke-dasharray":t.majorGridLines.dashArray,d:w},w.indexOf("NaN")==-1&&(this.svgRenderer.drawPath(l,c),n(c).appendTo(this.gXaxisEle)));t.visible&&t.majorTickLines.visible&&(it=nt.toString(),l={id:this.svgObject.id+"_XAxisMajorTicks",fill:"none","stroke-width":t.majorTickLines.width,stroke:t.majorTickLines.color,d:it},this.svgRenderer.drawPath(l,c),n(c).appendTo(this.gXaxisEle))},_drawXAxisTickLine:function(t,i,r,u){var wt,bt,st=ej.EjSvgRender.utils._getStringBuilder(),kt=ej.EjSvgRender.utils._getStringBuilder(),rt,c=Math.floor(i.x),li=Math.floor(i.x+i.width),o=i._opposed,ht,l=[],dt=i._isScroll&&!(i.scrollbarSettings.pointsLength!=null&&i.scrollbarSettings.pointsLength<i.maxPointLength),nt=i.labelBorder,gt=u.axes[i.name]._validCross,ct,f,ut,ft,b,e,k,p,ei,et,at,g,h,vt,w,v,fi,yt,pt;for(t==0||gt||(i.labelPosition!="inside"||i.tickLinesPosition!="inside")&&(i.labelPosition!="inside"||i.tickLinesPosition=="inside")||i.y==this.model.m_AreaBounds.Height+this.model.m_AreaBounds.Y||i.y==this.model.m_AreaBounds.Y?t==0||gt||i.labelPosition=="inside"||i.tickLinesPosition!="inside"||i.y==this.model.m_AreaBounds.Height+this.model.m_AreaBounds.Y||i.y==this.model.m_AreaBounds.Y?f=ct=i._y?i.showNextToAxisLine?i.y:i._y:Math.floor(i.y+i.majorTickLines.size-5):(f=o?Math.floor(i.y-i.majorTickLines.size):Math.floor(i.y+i.majorTickLines.size),ct=o?Math.floor(i.y-i.majorTickLines.size):Math.floor(i.y+i.majorTickLines.size)):(f=o?Math.floor(i.y-i._LableMaxWidth.height):Math.floor(i.y+i._LableMaxWidth.height),ct=o?Math.floor(i.y-i._LableMaxWidth.height):Math.floor(i.y+i._LableMaxWidth.height)),r||(ut=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxisTicklines_"+t})),i.labelPlacement=i.labelPlacement?i.labelPlacement:ej.datavisualization.Chart.LabelPlacement.BetweenTicks,ft=i.labels.length>0&&i.labelPlacement.toLowerCase()=="betweenticks"?-.5:0,b=i.visibleLabels.length,i._valueType.toLowerCase()==ej.datavisualization.Chart.ValueType.Category&&ft<0&&(b=b>0?i.visibleLabels.length+1:b),e=0;e<b;e++)if(ht=i.visibleLabels[e]?i.visibleLabels[e].Value:i.visibleLabels[e-1].Value+i.range.interval,k=i.labels.length>0&&ft<0?ht+ft:ht,k=i.roundingPlaces?k:parseFloat(k.toFixed(ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval)==0?1:ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval))),ej.EjSvgRender.utils._inside(k,i.visibleRange)){if(i.hidePartialLabels&&(e==0||e==b-1))continue;if(i.minorGridLines.visible||i.minorTickLines.visible)if(p=this._getSharpPath(i.minorTickLines.width),ei=this._getSharpPath(i.minorGridLines.width),i._valueType=="logarithmic"){h=k;var ni=i.visibleRange.max,lt=i.visibleRange.min,ti=Math.pow(i.logBase,h-i.visibleRange.interval),oi=Math.pow(i.logBase,h),si=(oi-ti)/(i.minorTicksPerInterval+1),hi=ti+si;for(h=ej.EjSvgRender.utils._logBase(hi,i.logBase),g=0;g<i.minorTicksPerInterval;g++)h<ni&&h>lt&&(rt=Math.ceil((h-lt)/(ni-lt)*i.width),i.minorTickLines&&i.minorTickLines.visible&&(at=Math.floor(rt+c),et=i.tickLinesPosition!="inside"&&i.labelPosition!="inside"||i.tickLinesPosition!="inside"&&i.labelPosition=="inside"?o?Math.floor(f-i.minorTickLines.size):Math.floor(i.minorTickLines.size+f):o?Math.floor(f+i.minorTickLines.size):f-Math.floor(i.minorTickLines.size),st.append("M "+(at+p)+" "+(et+p)+" L "+(at+p)+" "+(f+p)+" ")))}else for(g=0,h=k;g<i.minorTicksPerInterval;g++)h+=i.visibleRange.interval/(i.minorTicksPerInterval+1),h<i.visibleRange.max&&h>i.visibleRange.min&&(rt=Math.ceil((h-i.visibleRange.min)/(i.visibleRange.max-i.visibleRange.min)*i.width),i.minorTickLines&&i.minorTickLines.visible&&(et=i.tickLinesPosition!="inside"&&i.labelPosition!="inside"||i.tickLinesPosition!="inside"&&i.labelPosition=="inside"?o?Math.floor(f-i.minorTickLines.size):Math.floor(i.minorTickLines.size+f):o?Math.floor(f+i.minorTickLines.size):Math.floor(f-i.minorTickLines.size),vt=Math.floor(rt+c),st.append("M "+(vt+p)+" "+(et+p)+" L "+(vt+p)+" "+(f+p)+" ")));if(i.majorTickLines.visible||i.majorGridLines.visible||nt.width>0){var ot=this._getSharpPath(i.majorTickLines.width),ai=this._getSharpPath(i.majorGridLines.width),ii=l[e]=this.pointX=Math.ceil(ej.EjSvgRender.utils._getPointXY(k,i.visibleRange,i.isInversed)*i.width);i.majorTickLines.visible&&(w=i.majorTickLines.size+i.axisLine.width/2,v=i.tickLinesPosition=="inside"&&i.labelPosition=="inside"||i.tickLinesPosition=="inside"&&i.labelPosition!="inside"?o?f+w:f-w:(o?f-w:w+f)-(dt?o?this.model.scrollerSize:-this.model.scrollerSize:0),kt.append("M "+(Math.floor(ii+c)+ot)+" "+(Math.floor(v)+ot)+" L "+(Math.floor(ii+c)+ot)+" "+(Math.floor(f+(o?-i.axisLine.width/2:i.axisLine.width/2))+ot)+" "))}}if(nt.width>0){var d=ej.EjSvgRender.utils._getStringBuilder(),ri=dt?this.model.scrollerSize:0,w=i.axisLine.width,v,s,y,a,e,tt,ui=i.labelPosition.toLowerCase(),vi=this.model.m_AreaBounds.X,yi=this.model.m_AreaBounds.Width,ci=nt.width,it=i._LableMaxWidth.height+i.axisLine.width/2+2,b=i.visibleLabels.length;for(f=i.y,i.tickLinesPosition==ui&&(it+=i.majorTickLines.size),ui=="inside"?(v=o?f+w:f+w,s=o?f+it:f-it):(v=o?f-w:w+f+(i.zoomFactor<1&&this.model.zooming.enableScrollbar&&t==0?this.model.scrollerSize:0),s=o?f-it-ri:f+it+ri),e=0;e<b;e++)tt=(l[l.length-1]-l[l.length-2])/2,!ej.util.isNullOrUndefined(l[e])&&l.length>=1&&!isNaN(tt)&&(i._valueType=="category"&&i.labelPlacement.toLowerCase()=="betweenticks"?(y=l[e]+c,a=l[e]+tt*2+c):(y=l[e]-tt+c,a=l[e]+tt+c),a=Math.floor(a),s=Math.floor(s),y=Math.floor(y),v=Math.floor(v),y<i.x?d.append("M "+Math.floor(c)+" "+s+" L "+a+" "+s+" "):a>i.width+i.x?(d.append("M "+y+" "+v+" L "+y+" "+s+" L "+Math.floor(i.width+c)+" "+s+" "),a-ci<=i.width+i.x&&d.append("M "+Math.floor(i.width+c)+" "+s+" L "+(i.x+i.width)+" "+v)):(e==0&&d.append("M "+i.x+" "+s+" L "+y+" "+s+" "),d.append("M "+y+" "+v+" L "+y+" "+s+" L "+a+" "+s+" "),e==b-1&&d.append("M "+a+" "+v+" L "+a+" "+s+" M "+a+" "+s+" L "+(i.x+i.width)+" "+s)));fi={id:this.svgObject.id+"_XAxisLabelBorder_"+t,fill:"transparent","stroke-width":nt.width,stroke:nt.color,d:d.toString()};this.svgRenderer.drawPath(fi,r);n(r).appendTo(this.gXaxisEle)}i.minorTickLines.visible&&i.visible&&i.minorTicksPerInterval>0&&(bt=st.toString(),yt={id:this.svgObject.id+"_XAxisMinorTicks_"+t,fill:"none","stroke-width":i.minorTickLines.width,stroke:i.minorTickLines.color,d:bt},r?this.svgRenderer.drawPath(yt,r):this.svgRenderer.drawPath(yt,ut));i.majorTickLines.visible&&i.visible&&(wt=kt.toString(),pt={id:this.svgObject.id+"_XAxisMajorTicks_"+t,fill:"none","stroke-width":i.majorTickLines.width,stroke:i.majorTickLines.color,d:wt},r?this.svgRenderer.drawPath(pt,r):this.svgRenderer.drawPath(pt,ut));i.tickLinesPosition=="inside"&&n(ut).appendTo(this.gXaxisEle)},_drawXAxisGridLine:function(t,i,r){var ct,lt,ut=ej.EjSvgRender.utils._getStringBuilder(),at=ej.EjSvgRender.utils._getStringBuilder(),w,f=[],vt=this.model.elementSpacing+5,ft,l=i._opposed,b=Math.floor(i.x),ni=Math.floor(i.x+i.width),d=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxisGrid_"+t}),g=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxisAlternateGridBand_"+t}),yt=r.axes[i.name]._validCross,a,k,tt,s,c,ii,h,st,p,o,it,rt,dt,u,e,gt,ht;if(t==0||yt||i.labelPosition!="inside"||i.tickLinesPosition!="inside"||i.y==this.model.m_AreaBounds.Height+this.model.m_AreaBounds.Y||i.y==this.model.m_AreaBounds.Y?i.labelPosition!="inside"||i.tickLinesPosition=="inside"||i.y==this.model.m_AreaBounds.Height+this.model.m_AreaBounds.Y||i.y==this.model.m_AreaBounds.Y?t==0||yt||i.labelPosition=="inside"||i.tickLinesPosition!="inside"||i.y==this.model.m_AreaBounds.Height+this.model.m_AreaBounds.Y||i.y==this.model.m_AreaBounds.Y?(a=Math.floor(i.y),k=Math.floor(i.y)):(a=l?Math.floor(i.y-i.majorTickLines.size):Math.floor(i.y+i.majorTickLines.size),k=l?Math.floor(i.y-i.majorTickLines.size):Math.floor(i.y+i.majorTickLines.size)):a=k=l?Math.floor(i.y-i._LableMaxWidth.height)+vt:i.showNextToAxisLine?Math.floor(i.y+i._LableMaxWidth.height)-vt:Math.floor(i.y+i._LableMaxWidth.height):(a=l?Math.floor(i.y-i._LableMaxWidth.height):Math.floor(i.y+i._LableMaxWidth.height),k=l?Math.floor(i.y-i._LableMaxWidth.height):Math.floor(i.y+i._LableMaxWidth.height)),i.visible&&i.axisLine.visible){var pt=i.axisLine.offset>0?i.axisLine.offset:0,nt=this._getSharpPath(i.axisLine.width),ti={id:this.svgObject.id+"_XAxisLine_"+t,x1:b-i.plotOffset+nt+pt,y1:a+nt,x2:ni+i.plotOffset-pt+nt,y2:k+nt,"stroke-dasharray":i.axisLine.dashArray,"stroke-width":i.axisLine.width,stroke:i.axisLine.color,opacity:i.axisLine.opacity||1};r.axes[i.name]._lineOption=[ti,this.gXaxisEle]}else r.axes[i.name]._lineOption=[null,this.gXaxisEle];for(i.labelPlacement=i.labelPlacement?i.labelPlacement:ej.datavisualization.Chart.LabelPlacement.BetweenTicks,tt=i.labels.length>0&&i.labelPlacement.toLowerCase()=="betweenticks"?-.5:0,s=i.visibleLabels.length,i._valueType.toLowerCase()==ej.datavisualization.Chart.ValueType.Category&&tt<0&&(s=s>0?i.visibleLabels.length+1:s),u=0;u<s;u++)if(ft=i.visibleLabels[u]?i.visibleLabels[u].Value:i.visibleLabels[u-1].Value+i.range.interval,c=i.labels.length>0&&tt<0?ft+tt:ft,c=i.roundingPlaces?c:parseFloat(c.toFixed(ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval)==0?1:ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval))),ej.EjSvgRender.utils._inside(c,i.visibleRange)){if(i.hidePartialLabels&&(u==0||u==s-1))continue;if(i.minorGridLines.visible||i.minorTickLines.visible)if(ii=this._getSharpPath(i.minorTickLines.width),h=this._getSharpPath(i.minorGridLines.width),i._valueType=="logarithmic"){o=c;var wt=i.visibleRange.max,et=i.visibleRange.min,bt=Math.pow(i.logBase,o-i.visibleRange.interval),ri=Math.pow(i.logBase,o),kt=(ri-bt)/(i.minorTicksPerInterval+1),ot=bt+kt;for(o=ej.EjSvgRender.utils._logBase(ot,i.logBase),p=0;p<i.minorTicksPerInterval;p++)o<wt&&o>et&&(w=Math.ceil((o-et)/(wt-et)*i.width),i.minorGridLines&&i.minorGridLines.visible&&(st=Math.floor(w+b),ut.append("M "+(st+h)+" "+(a+h)+" L "+(st+h)+" "+(Math.floor(l?this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height:this.model.m_AreaBounds.Y)+h)+" "))),ot+=kt,o=ej.EjSvgRender.utils._logBase(ot,i.logBase)}else for(p=0,o=c;p<i.minorTicksPerInterval;p++)o+=i.visibleRange.interval/(i.minorTicksPerInterval+1),o<i.visibleRange.max&&o>i.visibleRange.min&&(w=Math.ceil((o-i.visibleRange.min)/(i.visibleRange.max-i.visibleRange.min)*i.width),i.minorGridLines&&i.minorGridLines.visible&&ut.append("M "+(Math.floor(w+b)+h)+" "+(a+h)+" L "+(Math.floor(w+b)+h)+" "+(Math.floor(l?this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height:this.model.m_AreaBounds.Y)+h)+" "));if(i.majorTickLines.visible||i.majorGridLines.visible){var fi=this._getSharpPath(i.majorTickLines.width),v=this._getSharpPath(i.majorGridLines.width),ui=this.pointX=Math.ceil(ej.EjSvgRender.utils._getPointXY(c,i.visibleRange,i.isInversed)*i.width),y=Math.floor(ui+b);if(i.zoomed&&(f[0]=i.x),u==0&&y==Math.floor(this.model.m_AreaBounds.X)){f.push(y+v);continue}if(u==s-1&&this.model.chartArea.border.color!="transparent"&&this.model.chartArea.border.width>0){if(y==Math.floor(this.model.m_AreaBounds.X+this.model.m_AreaBounds.Width))continue;i.zoomed&&(f[s]=y+v)}if(i.majorGridLines.visible&&at.append("M "+(y+v)+" "+(Math.floor(this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height)+v)+" L "+(y+v)+" "+(Math.floor(this.model.m_AreaBounds.Y)+v)+" "),i._valueType.toLowerCase()!="category"&&u==s-1)continue;f.push(y+v)}}if(i.alternateGridBand.odd.fill!="transparent"||i.alternateGridBand.even.fill!="transparent"){for(it=this.model.m_AreaBounds.Height,f.length===0&&(rt={id:this.svgObject.id+"_XAxis"+t+"_Alternateeven0",x:i.x,y:Math.floor(this.model.m_AreaBounds.Y),width:i.width,height:it,fill:i.alternateGridBand.even.fill,opacity:i.alternateGridBand.even.opacity,"clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)",stroke:"transparent"},this.svgRenderer.drawRect(rt,g)),u=1;u<f.length;u+=2)e=f[u+1]-f[u],e=e||i.labelPlacement.toLowerCase()=="onticks"?e:i.width+i.x-f[u],u==f.length-1&&i.zoomed&&(e=this.model.m_AreaBounds.X+this.model.m_AreaBounds.Width-f[f.length-1]-i.plotOffset),dt={id:this.svgObject.id+"_XAxis"+t+"_Alternateodd"+[u],x:f[u],y:Math.floor(this.model.m_AreaBounds.Y),width:e,height:it,fill:i.alternateGridBand.odd.fill,opacity:i.alternateGridBand.odd.opacity,stroke:"transparent","clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)"},e>0&&this.svgRenderer.drawRect(dt,g);for(u=0;u<f.length;u+=2)e=f[u+1]-f[u],e=e||i.labelPlacement.toLowerCase()=="onticks"?e:i.width+i.x-f[u],u==0&&i.zoomed&&(e=f[1]-i.x),u==f.length-1&&i.zoomed&&(e=this.model.m_AreaBounds.X+this.model.m_AreaBounds.Width-f[f.length-1]-i.plotOffset),rt={id:this.svgObject.id+"_XAxis"+t+"_Alternateeven"+[u],x:f[u],y:Math.floor(this.model.m_AreaBounds.Y),width:e,height:it,fill:i.alternateGridBand.even.fill,opacity:i.alternateGridBand.even.opacity,"clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)",stroke:"transparent"},e>0&&this.svgRenderer.drawRect(rt,g);n(g).appendTo(d)}i.minorGridLines.visible&&i.minorTicksPerInterval>0&&(lt=ut.toString(),gt={id:this.svgObject.id+"_XAxisMinorGridLines_"+t,fill:"none","stroke-width":i.minorGridLines.width,stroke:i.minorGridLines.color,"stroke-dasharray":i.minorGridLines.dashArray,d:lt},this.svgRenderer.drawPath(gt,d));ct=at.toString();i.majorGridLines.visible&&(ht={id:this.svgObject.id+"_XAxisMajorGridLines_"+t,fill:"none","stroke-width":i.majorGridLines.width,stroke:i.majorGridLines.color,opacity:i.majorGridLines.opacity,"stroke-dasharray":i.majorGridLines.dashArray,d:ct},ht.d!=""&&this.svgRenderer.drawPath(ht,d));n(d).appendTo(this.svgObject)},_drawYAxisTickLine:function(t,i,r,u){var at="",vt="",et=0,yt=i._isScroll&&!(i.scrollbarSettings.pointsLength!=null&&i.scrollbarSettings.pointsLength<i.maxPointLength),o=i._opposed,ot,c=[],rt=i.labelBorder,st,f,ut,y,v,b,l,ii,k,s,ft,nt,ui,d,e,gt,ni,ti;t==1||(i.labelPosition!="inside"||i.tickLinesPosition!="inside")&&(i.labelPosition!="inside"||i.tickLinesPosition=="inside")||i.x==this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X||i.x==this.model.m_AreaBounds.X?t==1||u||i.labelPosition=="inside"||i.tickLinesPosition!="inside"||i.x==this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X||i.x==this.model.m_AreaBounds.X?f=st=i.showNextToAxisLine?!i.showNextToAxisLine&&i.tickLinesPosition=="inside"?i.x+i.majorTickLines.size:i.x:i._x:(f=Math.floor(i.x+i.majorTickLines.size),st=Math.floor(i.x+i.majorTickLines.size)):(f=!o&&!u?Math.floor(i.x-i._LableMaxWidth.width-this.model.elementSpacing):i.showNextToAxisLine?i.x:Math.floor(i.x+i._LableMaxWidth.width+this.model.elementSpacing),st=!o&&!u?Math.floor(i.x-i._LableMaxWidth.width-this.model.elementSpacing):i.showNextToAxisLine?i.x:Math.floor(i.x+i._LableMaxWidth.width+this.model.elementSpacing));var h=Math.floor(i.y+i.height),fi=Math.floor(i.y),ht=ej.EjSvgRender.utils._getStringBuilder(),pt=ej.EjSvgRender.utils._getStringBuilder(),ei=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisTicklines_"+t});for(i.labelPlacement=i.labelPlacement?i.labelPlacement:ej.datavisualization.Chart.LabelPlacement.BetweenTicks,ut=i.labels.length>0&&i.labelPlacement.toLowerCase()=="betweenticks"?-.5:0,y=i.visibleLabels.length,i._valueType.toLowerCase()==ej.datavisualization.Chart.ValueType.Category&&ut<0&&(y=y>0?i.visibleLabels.length+1:y),e=0;e<y;e++)if(ot=i.visibleLabels[e]?i.visibleLabels[e].Value:i.visibleLabels[e-1].Value+i.range.interval,v=i.labels.length>0&&ut<0?ot+ut:ot,v=i.roundingPlaces?v:parseFloat(v.toFixed(ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval)==0?1:ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval))),ej.EjSvgRender.utils._inside(v,i.visibleRange)){if(i.hidePartialLabels&&(e==0||e==i.visibleLabels.length-1))continue;if(i.minorGridLines.visible||i.minorTickLines.visible)if(l=this._getSharpPath(i.minorTickLines.width),ii=this._getSharpPath(i.minorGridLines.width),i._valueType=="logarithmic"){s=v;var wt=i.visibleRange.max,ct=i.visibleRange.min,bt=Math.pow(i.logBase,s-i.visibleRange.interval),ri=Math.pow(i.logBase,s),kt=(ri-bt)/(i.minorTicksPerInterval+1),lt=bt+kt;for(s=ej.EjSvgRender.utils._logBase(lt,i.logBase),k=0;k<i.minorTicksPerInterval;k++)s<wt&&s>ct&&(b=Math.ceil((s-ct)/(wt-ct)*i.height),i.minorTickLines&&i.minorTickLines.visible&&i.minorTickLines.visible&&(ft=i.tickLinesPosition!="inside"&&i.labelPosition!="inside"||i.tickLinesPosition!="inside"&&i.labelPosition=="inside"?o?i.minorTickLines.size:-i.minorTickLines.size:o?-i.minorTickLines.size:i.minorTickLines.size,ht.append("M "+(Math.floor(ft+f)+l)+" "+(Math.floor(b*-1+h)+l)+" L "+(f+l)+" "+(Math.floor(b*-1+h)+l)+" "))),lt+=kt,s=ej.EjSvgRender.utils._logBase(lt,i.logBase)}else for(k=0,s=v;k<i.minorTicksPerInterval;k++)s+=i.visibleRange.interval/(i.minorTicksPerInterval+1),s<i.visibleRange.max&&s>i.visibleRange.min&&(b=(s-i.visibleRange.min)/i.visibleRange.delta*i.height,i.minorTickLines.visible&&(ft=i.tickLinesPosition!="inside"&&i.labelPosition!="inside"||i.tickLinesPosition!="inside"&&i.labelPosition=="inside"?o?i.minorTickLines.size:-i.minorTickLines.size:o?-i.minorTickLines.size:i.minorTickLines.size,ht.append("M "+(Math.floor(ft+f)+l)+" "+(Math.floor(b*-1+h)+l)+" L "+(f+l)+" "+(Math.floor(b*-1+h)+l)+" ")));(i.majorTickLines.visible||i.majorGridLines.visible||rt.width>0)&&(nt=this._getSharpPath(i.minorTickLines.width),ui=this._getSharpPath(i.majorGridLines.width),et=c[e]=ej.EjSvgRender.utils._getPointXY(v,i.visibleRange,i.isInversed)*i.height,i.majorTickLines.visible&&(i.tickLinesPosition!="inside"&&i.labelPosition!="inside"||i.tickLinesPosition!="inside"&&i.labelPosition=="inside"?d=(o?i.majorTickLines.size+i.axisLine.width/2:-(i.majorTickLines.size+i.axisLine.width/2))+(yt?o?this.model.scrollerSize:o-this.model.scrollerSize:0):(i.tickLinesPosition=="inside"&&i.labelPosition!="inside"||i.tickLinesPosition=="inside"&&i.labelPosition=="inside")&&(d=o?-(i.majorTickLines.size+i.axisLine.width/2):i.majorTickLines.size+i.axisLine.width/2),pt.append("M "+(Math.floor(d+f)+nt)+" "+(Math.floor(et*-1+h)+nt)+" L "+(Math.floor(f+(o?i.axisLine.width/2:i.axisLine.width/2))+nt)+" "+(Math.floor(et*-1+h)+nt)+" ")))}if(rt.width>0){var tt=ej.EjSvgRender.utils._getStringBuilder(),d=i.axisLine.width/2,e,p,w,a,it,dt=yt?this.model.scrollerSize:0,g=i._LableMaxWidth.maxWidth+10;for(f=i.x,i.tickLinesPosition==i.labelPosition&&(g+=i.majorTickLines.size),a=Math.floor(f-g),a=i.labelPosition=="outside"?o?Math.floor(f+g)+dt:Math.floor(f-g)-dt:o?Math.floor(f-g):Math.floor(f+g),e=0;e<y;e++)it=(c[c.length-1]-c[c.length-2])/2,!ej.util.isNullOrUndefined(c[e])&&c.length>1&&!isNaN(it)&&(i._valueType=="category"&&i.labelPlacement.toLowerCase()=="betweenticks"?(p=Math.floor(c[e]*-1+h),w=Math.floor(c[e]*-1-it*2+h)):(p=Math.floor(c[e]*-1+it+h),w=Math.floor(c[e]*-1-it+h)),p>h?tt.append("M "+a+" "+h+" L "+a+" "+w+" "):w<this.model.m_AreaBounds.Y?tt.append("M "+Math.floor(d+f)+" "+p+" L "+a+" "+p+" L "+a+" "+this.model.m_AreaBounds.Y+" "):(tt.append("M "+Math.floor(d+f)+" "+p+" L "+a+" "+p+" L "+a+" "+w+" "),e==y-1&&tt.append("M "+Math.floor(d+f)+" "+w+" L "+a+" "+w+" ")));gt={id:this.svgObject.id+"_YAxisLabelBorder_"+t,fill:"none","stroke-width":rt.width,stroke:rt.color,d:tt.toString()};this.svgRenderer.drawPath(gt,r);n(r).appendTo(this.gYaxisEle)}i.minorTickLines.visible&&i.visible&&i.minorTicksPerInterval>0&&(vt=ht.toString(),ni={id:this.svgObject.id+"_YAxisMinorTicks_"+t,fill:"none","stroke-width":i.minorTickLines.width,stroke:i.minorTickLines.color,d:vt},this.svgRenderer.drawPath(ni,r));i.majorTickLines.visible&&i.visible&&(at=pt.toString(),ti={id:this.svgObject.id+"_YAxisMajorTicks_"+t,fill:"none","stroke-width":i.majorTickLines.width,stroke:i.majorTickLines.color,d:at},this.svgRenderer.drawPath(ti,r))},_drawYAxisGridLine:function(t,i,r){var st="",ht="",ct=0,nt,s=Math.floor(i.y+i.height),ii=Math.floor(i.y),b=i._opposed,f=[],lt=r.axes[i.name]._validCross,at=i.name.replace(/[^a-zA-Z0-9]/g,""),k,d,pt,rt,wt,h,v,ui,o,y,e,ei,c,et,gt,u,a,p,ni,ti,ot;t==1||lt||(i.labelPosition!="inside"||i.tickLinesPosition!="inside")&&(i.labelPosition!="inside"||i.tickLinesPosition=="inside")||i.x==this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X||i.x==this.model.m_AreaBounds.X?t==1||lt||i.labelPosition=="inside"||i.tickLinesPosition!="inside"||i.x==this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X||i.x==this.model.m_AreaBounds.X?(k=Math.floor(i.x),d=Math.floor(i.x)):(k=b?Math.floor(i.x+i.majorTickLines.size):Math.floor(i.x-i.majorTickLines.size),d=b?Math.floor(i.x+i.majorTickLines.size):Math.floor(i.x-i.majorTickLines.size)):(k=b?Math.floor(i.x+i._LableMaxWidth.width+this.model.elementSpacing):Math.floor(i.x-i._LableMaxWidth.width-this.model.elementSpacing),d=b?Math.floor(i.x+i._LableMaxWidth.width+this.model.elementSpacing):Math.floor(i.x-i._LableMaxWidth.width-this.model.elementSpacing));var tt=ej.EjSvgRender.utils._getStringBuilder(),vt=ej.EjSvgRender.utils._getStringBuilder(),w=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisGrid_"+t}),it=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisAlternateGridBand_"+t});if(i.visible&&i.axisLine.visible){var yt=i.axisLine.offset>0?i.axisLine.offset:0,g=this._getSharpPath(i.axisLine.width),ri={id:this.svgObject.id+at+"_YAxisLine_"+t,x1:k+g,y1:ii-i.plotOffset+yt+g,x2:d+g,y2:s+i.plotOffset-yt+g,"stroke-width":i.axisLine.width,"stroke-dasharray":i.axisLine.dashArray,stroke:i.axisLine.color,opacity:i.axisLine.opacity||1};r.axes[i.name]._lineOption=[ri,this.gYaxisEle]}else r.axes[i.name]._lineOption=[null,this.gYaxisEle];for(i.axisBottomLine&&i.axisBottomLine.visible&&(pt={id:this.svgObject.id+at+"_YAxisBottomLine_"+t,x1:this.model.m_AreaBounds.X,y1:s,x2:this.model.m_AreaBounds.X+this.model.m_AreaBounds.Width,y2:s,"stroke-width":i.axisBottomLine.width,stroke:i.axisBottomLine.color},this.svgRenderer.drawLine(pt,w)),i.labelPlacement=i.labelPlacement?i.labelPlacement:ej.datavisualization.Chart.LabelPlacement.BetweenTicks,rt=i.labels.length>0&&i.labelPlacement.toLowerCase()=="betweenticks"?-.5:0,wt=i.visibleLabels.length,u=0;u<wt;u++)if(nt=i.visibleLabels[u].Value,h=i.labels.length>0&&rt<0?nt+rt:nt,h=i.roundingPlaces?h:parseFloat(h.toFixed(ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval)==0?1:ej.EjSvgRender.utils._decimalPlaces(i.visibleRange.interval))),ej.EjSvgRender.utils._inside(h,i.visibleRange)){if(i.hidePartialLabels&&(u==0||u==i.visibleLabels.length-1))continue;if(i.minorGridLines.visible||i.minorTickLines.visible)if(ui=this._getSharpPath(i.minorTickLines.width),o=this._getSharpPath(i.minorGridLines.width),i._valueType=="logarithmic"){e=h;var bt=i.visibleRange.max,ut=i.visibleRange.min,kt=Math.pow(i.logBase,e-i.visibleRange.interval),fi=Math.pow(i.logBase,e),dt=(fi-kt)/(i.minorTicksPerInterval+1),ft=kt+dt;for(e=ej.EjSvgRender.utils._logBase(ft,i.logBase),y=0;y<i.minorTicksPerInterval;y++)e<bt&&e>ut&&(v=Math.ceil((e-ut)/(bt-ut)*i.height),i.minorGridLines.visible&&tt.append("M "+(Math.floor(this.model.m_AreaBounds.X)+o)+" "+(Math.floor(v*-1+s)+o)+" L "+(Math.floor(this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X)+o)+" "+(Math.floor(v*-1+s)+o)+" ")),ft+=dt,e=ej.EjSvgRender.utils._logBase(ft,i.logBase)}else for(y=0,e=h;y<i.minorTicksPerInterval;y++)e+=i.visibleRange.interval/(i.minorTicksPerInterval+1),e<i.visibleRange.max&&e>i.visibleRange.min&&(v=(e-i.visibleRange.min)/i.visibleRange.delta*i.height,i.minorGridLines.visible&&tt.append("M "+(Math.floor(this.model.m_AreaBounds.X)+o)+" "+(Math.floor(v*-1+s)+o)+" L "+(Math.floor(this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X)+o)+" "+(Math.floor(v*-1+s)+o)+" "));if((i.majorTickLines.visible||i.majorGridLines.visible)&&(ei=this._getSharpPath(i.minorTickLines.width),c=this._getSharpPath(i.majorGridLines.width),i.majorGridLines.visible)){ct=ej.EjSvgRender.utils._getPointXY(h,i.visibleRange,i.isInversed)*i.height;var oi=Math.floor(this.model.m_AreaBounds.X)+c,l=Math.floor(ct*-1+s),si=Math.floor(this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X)+c;if(u==0){if(l==Math.floor(this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height))continue;i.zoomed&&(f[0]=l+c)}if(u==i.visibleLabels.length-1&&this.model.chartArea.border.color!="transparent"&&this.model.chartArea.border.width>0&&l==Math.floor(this.model.m_AreaBounds.Y)){f.push(l+c);continue}if(vt.append("M "+oi+" "+(l+c)+" L "+si+" "+(l+c)+" "),u==0)continue;f.push(l+c)}}if(i.alternateGridBand.odd.fill!="transparent"||i.alternateGridBand.even.fill!="transparent"){for(et=this.model.m_AreaBounds.Width,i.zoomed&&(f[f.length]=i.y),u=1;u<f.length;u+=2)a=f[0]-f[1],u==f.length-1&&i.zoomed&&(p=f[f.length-2]-i.y,a=p),gt={id:this.svgObject.id+"_YAxisAlternateodd"+[u],x:Math.floor(this.model.m_AreaBounds.X),y:f[u],width:et,height:a,fill:i.alternateGridBand.odd.fill,opacity:i.alternateGridBand.odd.opacity,stroke:"transparent","clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)"},this.svgRenderer.drawRect(gt,it);for(u=0;u<f.length;u+=2)a=f[0]-f[1],u==f.length-1&&i.zoomed&&(p=f[f.length-2]-i.y,a=p),u==0&&i.zoomed&&(p=i.y+i.height-f[0]-i.plotOffset,a=p),ni={id:this.svgObject.id+"_YAxisAlternateeven"+[u],x:Math.floor(this.model.m_AreaBounds.X),y:f[u],width:et,height:a,fill:i.alternateGridBand.even.fill,opacity:i.alternateGridBand.even.opacity,stroke:"transparent","clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)"},this.svgRenderer.drawRect(ni,it);n(it).appendTo(w)}i.minorGridLines.visible&&i.minorTicksPerInterval>0&&(ht=tt.toString(),ti={id:this.svgObject.id+"_YAxisMinorGridLines_"+t,fill:"none","stroke-width":i.minorGridLines.width,stroke:i.minorGridLines.color,"stroke-dasharray":i.minorGridLines.dashArray,d:ht},this.svgRenderer.drawPath(ti,w));st=vt.toString();i.majorGridLines.visible&&(ot={id:this.svgObject.id+"_YAxisMajorGridLines_"+t,fill:"none","stroke-width":i.majorGridLines.width,opacity:i.majorGridLines.opacity,"stroke-dasharray":i.majorGridLines.dashArray,stroke:i.majorGridLines.color,d:st},ot.d!=""&&this.svgRenderer.drawPath(ot,w));n(w).appendTo(this.svgObject)},textOverflowMultiLevelLabels:function(n,t,i,r,u,f,e,o,s,h){var v=o.y,y=0,a,p,l,w,b,c;if(u=="wrap"||u=="wrapandtrim"){for(p=h._wrap(n,t,i,u,f,e),l=p.text,w=l.length,c=0;c<w;c++)o.y+=e.height,h.model.enable3D||(o.id+="_"+c,h.svgRenderer.drawText(o,l[c],s)),u=="wrapandtrim"&&l[c].indexOf("...")>-1&&(h.model.enable3D&&y==0&&(o.y-=e.height),b=p.unTrimmedText,e=ej.EjSvgRender.utils._measureText(l[c],null,f),a={X:o.x-e.width/2,Y:o.y,Width:e.width,Height:e.height},h.model.axisMultiLevelLabelRegions.push({trimText:l[c],labelText:b[y],Bounds:a}),y++);return l}return i=u=="trim"?ej.EjSvgRender.utils._trimText(r,t,f):r,h.model.enable3D||(v=o.y+e.height),n.orientation.toLowerCase()=="vertical"&&(v=o.y-e.height/4),e=ej.EjSvgRender.utils._measureText(i,null,f),a={X:o.x-e.width/2,Y:v,Width:e.width,Height:e.height},h.model.axisMultiLevelLabelRegions.push({trimText:i,labelText:r,Bounds:a}),i},_triggerMultiLevelLabelsRendering:function(t,i,r,u,f,e,o){var s=n.extend({},ej.EjSvgRender.commonChartEventArgs);return s.data={text:t,location:{x:i,y:r},textOverflow:u,font:f,border:e},o._trigger("multiLevelLabelRendering",s),s.data},_drawXAxisMultiLevelLabels:function(t,i){var tt,u,r,ri,ui,st,vt,a,e,v,y,h,d,c,s,it,kt,ht,dt,gt,yt,o,f,ni,pt,w,ct,rt,wt=this.svgObject.id,g=i.visibleRange,et=this.svgRenderer.createGroup({id:wt+"_XAxisMultiLevelLabels_"+t,"clip-path":"url(#"+this.svgObject.id+"_XAxis_Clippath_"+t+")"}),bt=this.model.m_AreaBounds,nt=i.opposedPosition,b,p=i.labelPosition.toLowerCase(),fi=i.labelBorder,l=10,ot=i._isScroll?this.model.scrollerSize:0,ti,k,ft,ii,ut,ei,at,lt;for(h=i.majorTickLines.size+i._LableMaxWidth.height+fi.width,kt=i.x,ht=i.y+h+ot,dt=i.width+this.model.chartArea.border.width,gt=i._multiLevelLabelHeight+l-2,nt?ht=p=="outside"?i.y-h-i._multiLevelLabelHeight-l/2-ot:i.y+h-l/2:p=="inside"&&(ht=i.y-h-i._multiLevelLabelHeight),ti={id:this.svgObject.id+"_XAxis_Clippath_"+t,x:kt,y:ht,width:dt,height:gt,fill:"white","stroke-width":1,stroke:"Gray"},this.svgRenderer.drawClipPath(ti,et),tt=0;tt<i.multiLevelLabels.length;tt++)if(e=i.multiLevelLabels[tt],typeof e.start=="string"&&e.start.indexOf("/Date(")!=-1&&(e.start=parseInt(e.start.substr(6))),typeof e.end=="string"&&e.end.indexOf("/Date(")!=-1&&(e.end=parseInt(e.end.substr(6))),e.visible&&(e.start>=g.min&&e.start<=g.max||e.end>=g.min&&e.end<=g.max||e.start<g.min&&e.end>g.max)){if(v=e.font,w=e.border,b=w.width,s=e._level,it=e.textOverflow.toLowerCase(),ct=w.type.toLowerCase(),rt=e.textAlignment.toLowerCase(),y=Math.ceil(ej.EjSvgRender.utils._getPointXY(e.start,g,i.isInversed)*i.width),d=Math.ceil(ej.EjSvgRender.utils._getPointXY(e.end,g,i.isInversed)*i.width),i.isInversed&&(y=y-d,d=y+d,y=d-y),ft=e.text,a=ej.EjSvgRender.utils._measureText(ft,null,v),st=ej.util.isNullOrUndefined(e.maximumTextWidth)?d-y-b-l:e.maximumTextWidth-l,ri=1,ui=0,u=y+i.x+l/2,r=h+i.y,r=nt?p=="outside"?i.y-h-i.multiLevelLabelHeight[s]-l-i.prevHeight[s]-ot:i.y+h-l/2+i.prevHeight[s]:p=="inside"?i.y-h-i.multiLevelLabelHeight[s]-i.prevHeight[s]:h+i.y+i.prevHeight[s]+ot,this.model.enableCanvasRendering&&(this.svgRenderer.ctx.save(),this.svgRenderer.ctx.beginPath(),this.svgRenderer.ctx.rect(kt,ht,dt,gt),this.svgRenderer.ctx.clip()),rt=="center"?(u+=st/2,yt="middle"):rt=="far"?(u=u+st-b/2,yt="end"):(yt="start",u+=b/2),k=this._triggerMultiLevelLabelsRendering(ft,u,r,it,v,e.border,this),ft=k.text,u=k.location.x,r=k.location.y,it=k.textOverflow.toLowerCase(),v=k.font,w=k.border,ct=k.border.type.toLowerCase(),b=k.border.width,c={id:wt+"_XAxisMultiLevelLabels_Text_"+t+"_"+tt,x:u,y:ct=="curlybrace"?r+10:r,fill:v.color?v.color:i.multiLevelLabelsFontColor,"font-size":v.size,"font-family":v.fontFamily,"font-style":v.fontStyle,"font-weight":v.fontWeight,opacity:v.opacity,"text-anchor":yt},vt=ft,it!="none"&&(vt=this.textOverflowMultiLevelLabels(i,st,vt,ft,it,v,a,c,et,this)),it!="wrap"&&it!="wrapandtrim"&&(c.y+=a.height,a.height<i.multiLevelLabelHeight[s]&&(c.y=c.y+i.multiLevelLabelHeight[s]/2-a.height/2),this.svgRenderer.drawText(c,vt,et)),r=nt?p=="inside"?h+i.y+i.prevHeight[s]-l/2:i.y-h-i.multiLevelLabelHeight[s]-l+2-i.prevHeight[s]-ot:p=="inside"?i.y-h-i.multiLevelLabelHeight[s]-3-i.prevHeight[s]:h+i.y+i.prevHeight[s]+ot,u=y+i.x,r+=b,o=i.multiLevelLabelHeight[s]+l/2,f=st+l+b,ii={bounds:{x:u,y:r,height:o,width:f},axisIndex:t,multiLevelLabel:e},this.model.multiLevelLabelRegions.push(ii),ut="",ei=(f+b-a.width)/2-2,ct=="rectangle")pt={id:wt+"_XAxisMultiLevelLabels_Rect_"+t+"_"+tt,x:u,y:r,width:f,height:o,fill:"transparent",stroke:w.color?w.color:i.multiLevelLabelsColor,"stroke-width":b},this.svgRenderer.drawRect(pt,et);else{switch(ct){case"withouttopandbottomborder":ut="M "+u+" "+r+" L "+u+" "+(r+o)+" M "+(u+f)+" "+r+" L "+(u+f)+" "+(r+o);break;case"withouttopborder":ni=!nt&&p=="outside"||nt&&p=="inside"?o:0;ut="M "+u+" "+(r+ni)+" L "+(u+f)+" "+(r+ni)+" M "+u+" "+r+" L "+u+" "+(r+o)+" M "+(u+f)+" "+r+" L "+(u+f)+" "+(r+o);break;case"brace":rt=="near"?(lt=c.x,at=c.x+a.width+2):rt=="center"?(lt=c.x-a.width/2-2<=bt.X+y?bt.X+y+l:c.x-a.width/2-2,at=c.x+a.width/2+2>bt.X+d?bt.X+d-l:c.x+a.width/2+2):(lt=c.x-a.width-2,at=c.x);ut=!nt&&p=="outside"||nt&&p=="inside"?"M "+u+" "+r+" L "+u+" "+(r+o/2)+" M "+u+" "+(r+o/2)+" L "+(lt-2)+" "+(r+o/2)+" M "+at+" "+(r+o/2)+" L "+(u+f)+" "+(r+o/2)+" M "+(u+f)+" "+(r+o/2)+" L "+(u+f)+" "+r:"M "+u+" "+(r+o)+" L "+u+" "+(r+o/2)+" M "+u+" "+(r+o/2)+" L "+lt+" "+(r+o/2)+" M "+at+" "+(r+o/2)+" L "+(u+f)+" "+(r+o/2)+" M "+(u+f)+" "+(r+o)+" L "+(u+f)+" "+(r+o/2);break;case"curlybrace":r=i.y+h+i.prevHeight[s];ut=f<30?"M "+(u+f/2-5)+" "+(r+10)+" L "+(u+f/2)+" "+(r+15)+" L "+(u+f/2+5)+" "+(r+10):nt?"M "+u+" "+r+" C "+u+" "+r+" "+(u+5)+" "+(r+10)+" "+(u+10)+" "+(r+10)+" L "+(u+f/2-5)+" "+(r+10)+" L "+(u+f/2)+" "+(r+15)+" L "+(u+f/2+5)+" "+(r+10)+" L "+(u+f-10)+" "+(r+10)+" C "+(u+f-10)+" "+(r+10)+" "+(u+f)+" "+(r+5)+" "+(u+f)+" "+r:rt=="center"?"M "+u+" "+r+" C "+u+" "+r+" "+(u+5)+" "+(r+10)+" "+(u+10)+" "+(r+10)+" L "+(u+f/2-5)+" "+(r+10)+" L "+(u+f/2)+" "+(r+15)+" L "+(u+f/2+5)+" "+(r+10)+" L "+(u+f-10)+" "+(r+10)+" C "+(u+f-10)+" "+(r+10)+" "+(u+f)+" "+(r+5)+" "+(u+f)+" "+r:rt=="near"?"M "+u+" "+r+" C "+u+" "+r+" "+(u+5)+" "+(r+10)+" "+(u+10)+" "+(r+10)+" L "+(u+15)+" "+(r+15)+" L "+(u+15+5)+" "+(r+10)+" L "+(u+f-10)+" "+(r+10)+" C "+(u+f-10)+" "+(r+10)+" "+(u+f)+" "+(r+5)+" "+(u+f)+" "+r:"M "+u+" "+r+" C "+u+" "+r+" "+(u+5)+" "+(r+10)+" "+(u+10)+" "+(r+10)+" L "+(u+f-20)+" "+(r+10)+" L "+(u+f-15)+" "+(r+15)+" L "+(u+f-10)+" "+(r+10)+" L "+(u+f-10)+" "+(r+10)+" C "+(u+f-10)+" "+(r+10)+" "+(u+f)+" "+(r+5)+" "+(u+f)+" "+r}ut&&(pt={id:wt+"_XAxisMultiLevelLabels_Rect_"+t+"_"+tt,d:ut,stroke:w.color?w.color:i.multiLevelLabelsColor,"stroke-width":w.width,fill:"none"},this.svgRenderer.drawPath(pt,et))}this.model.enableCanvasRendering&&this.svgRenderer.ctx.restore();n(et).appendTo(this.gXaxisEle)}},_drawYAxisMultiLevelLabels:function(t,i){var g,r,u,fi,ht,nt,s,a,p,b,ft,tt,l=5,c,pt,ti,ei,ct,o,e,wt,bt,kt,lt,h,et,ot,at=this.svgObject.id,k=i.visibleRange,dt,ii,gt,ni,st,it,oi,y,si,f,ut=this.svgRenderer.createGroup({id:at+"_YAxisMultiLevelLabels_"+t,"clip-path":"url(#"+this.svgObject.id+"_YAxis_Clippath_"+t+")"}),ci=this.model.m_AreaBounds,w=i.opposedPosition,d=i.labelPosition.toLowerCase(),hi=i.labelBorder,vt=i._multiLevelLabelHeight,v=i.majorTickLines.size+i._LableMaxWidth.width+hi.width+2*l,yt=i._isScroll?this.model.scrollerSize:0,ri,rt,ui;for(ii=i.y,gt=vt+l,ni=i.height+l,dt=w?d=="outside"?i.x+v-l+yt:i.x-vt-v+l:d=="outside"?i.x-vt-v-yt:i.x+v-l,ri={id:this.svgObject.id+"_YAxis_Clippath_"+t,x:dt,y:i.y,width:gt,height:ni,fill:"white","stroke-width":1,stroke:"Gray"},this.svgRenderer.drawClipPath(ri,ut),g=0;g<i.multiLevelLabels.length;g++)if(s=n.extend(!0,{},this.model.multiLevelLabelsDefault,i.multiLevelLabels[g]),s.visible&&(s.start>=k.min&&s.start<=k.max||s.end>=k.min&&s.end<=k.max||s.start<k.min&&s.end>k.max)){if(a=s.font,h=s.border,c=s._level,pt=s.maximumTextWidth,tt=s.textOverflow.toLowerCase(),et=h.type.toLowerCase(),ot=s.textAlignment.toLowerCase(),p=Math.ceil(ej.EjSvgRender.utils._getPointXY(s.start,k,i.isInversed)*i.height),b=Math.ceil(ej.EjSvgRender.utils._getPointXY(s.end,k,i.isInversed)*i.height),i.isInversed&&(p=p-b,b=p+b,p=b-p),rt=s.text,nt=ej.EjSvgRender.utils._measureText(rt,null,a),ht=b-p-h.width,ti=ej.util.isNullOrUndefined(pt)?i.multiLevelLabelHeight[c]+l:pt-l,fi=1,ei=0,st=0,r=i.x-v-i.prevHeight[c]-i.multiLevelLabelHeight[c]/2+h.width-l/2,u=i.height+i.y-p-ht/2,r=w?d=="outside"?i.x+v+i.multiLevelLabelHeight[c]/2+i.prevHeight[c]+h.width+yt:i.x-v-i.multiLevelLabelHeight[c]/2-i.prevHeight[c]+h.width+l/2:d=="inside"?i.x+v+i.multiLevelLabelHeight[c]/2+i.prevHeight[c]-l/2:r+st-yt,this.model.enableCanvasRendering&&(this.svgRenderer.ctx.save(),this.svgRenderer.ctx.beginPath(),this.svgRenderer.ctx.rect(dt,ii,gt,ni),this.svgRenderer.ctx.clip()),u=ot=="far"?u+ht/2-nt.height/2:ot=="near"?u-ht/2+nt.height:u+nt.height/4,it=this._triggerMultiLevelLabelsRendering(rt,r,u,tt,a,s.border,this),rt=it.text,r=it.location.x,u=it.location.y,tt=it.textOverflow,a=it.font,h=it.border,et=h.type.toLowerCase(),oi=h.width,ft={id:at+"_YAxisMultiLevelLabels_Text_"+t+"_"+g,x:et=="curlybrace"?w?r+st+10:r+st-10:r+st,y:u,fill:a.color?a.color:i.multiLevelLabelsFontColor,"font-size":a.size,"font-family":a.fontFamily,"font-style":a.fontStyle,"font-weight":a.fontWeight,opacity:a.opacity,"text-anchor":"middle"},ct=rt,tt!="none"&&(ct=this.textOverflowMultiLevelLabels(i,ti,ct,rt,tt,a,nt,ft,ut,this)),tt!="wrap"&&tt!="wrapandtrim"&&this.svgRenderer.drawText(ft,ct,ut),r=r-l/2-i.multiLevelLabelHeight[c]/2,u=i.y+i.height-b+h.width,o=b-p,e=i.multiLevelLabelHeight[c]+l,y="",si=(e+h.width-vt)/2-2,ui={bounds:{x:r,y:u,height:o,width:e},axisIndex:t,multiLevelLabel:s},this.model.multiLevelLabelRegions.push(ui),et=="rectangle")lt={id:at+"_YAxisMultiLevelLabels_Rect_"+t+"_"+g,x:r,y:u,width:e,height:o,fill:"transparent",stroke:h.color?h.color:i.multiLevelLabelsColor,"stroke-width":h.width},this.svgRenderer.drawRect(lt,ut);else{switch(et){case"withouttopandbottomborder":y="M "+r+" "+(u+o)+" L "+(r+e)+" "+(u+o)+" M "+r+" "+u+" L "+(r+e)+" "+u;break;case"withouttopborder":kt=!w&&d=="outside"||w&&d=="inside"?0:e;y="M "+r+" "+(u+o)+" L "+(r+e)+" "+(u+o)+" M "+r+" "+u+" L "+(r+e)+" "+u+" M "+(r+kt)+" "+(u+o)+" L "+(r+kt)+" "+u;break;case"brace":wt=ft.y-nt.height/2-4;bt=ft.y+nt.height/4+2;y=!w&&d=="outside"||w&&d=="inside"?"M "+(r+e)+" "+u+" L "+(r+e/2)+" "+u+" M "+(r+e/2)+" "+u+" L "+(r+e/2)+" "+wt+" M "+(r+e/2)+" "+bt+" L "+(r+e/2)+" "+(u+o)+" M "+(r+e/2)+" "+(u+o)+" L "+(r+e)+" "+(u+o):"M "+r+" "+u+" L "+(r+e/2)+" "+u+" M "+(r+e/2)+" "+u+" L "+(r+e/2)+" "+wt+" M "+(r+e/2)+" "+bt+" L "+(r+e/2)+" "+(u+o)+" M "+(r+e/2)+" "+(u+o)+" L "+r+" "+(u+o);break;case"curlybrace":r=i.x-v-i.prevHeight[c];f=o-10;o<30?w?(r=i.x+v+i.prevHeight[c],f=o-10,y=" M "+(r+10)+" "+(u+f/2)+"  L "+(r+15)+" "+(u+f/2+5)+" L "+(r+10)+" "+(u+f/2+10)):y="M "+(r-10)+" "+(u+o/2-5)+" L "+(r-15)+" "+(u+o/2)+" L "+(r-10)+" "+(u+o/2+5):w?(r=i.x+v+i.prevHeight[c],f=o-10,y="M "+r+" "+u+" C "+r+" "+u+" "+(r+10)+" "+u+" "+(r+10)+" "+(u+10)+" L "+(r+10)+" "+(u+f/2)+"  L "+(r+15)+" "+(u+f/2+5)+" L "+(r+10)+" "+(u+f/2+10)+" L "+(r+10)+" "+(u+f)+" C"+(r+10)+" "+(u+f)+" "+(r+5)+" "+(u+f+10)+" "+r+" "+(u+f+10)):y=ot=="center"?"M "+r+" "+u+" C "+r+" "+u+" "+(r-10)+" "+u+" "+(r-10)+" "+(u+10)+" L "+(r-10)+" "+(u+f/2)+" L "+(r-15)+" "+(u+f/2+5)+" L "+(r-10)+" "+(u+f/2+10)+" L "+(r-10)+" "+(u+f)+" C "+(r-10)+" "+(u+f)+" "+(r-5)+" "+(u+f+10)+" "+r+" "+(u+f+10):ot=="far"?"M "+r+" "+u+" C "+r+" "+u+" "+(r-10)+" "+u+" "+(r-10)+" "+(u+10)+" L "+(r-10)+" "+(u+f-10)+"  L "+(r-15)+" "+(u+f-5)+" L "+(r-10)+" "+(u+f)+" L "+(r-10)+" "+(u+f)+" C"+(r-10)+" "+(u+f)+" "+(r-10)+" "+(u+f+10)+" "+r+" "+(u+f+10):"M "+r+" "+u+" C "+r+" "+u+" "+(r-10)+" "+u+" "+(r-10)+" "+(u+10)+" L "+(r-15)+" "+(u+10+5)+" L "+(r-10)+" "+(u+10+10)+" L "+(r-10)+" "+(u+f)+" C"+(r-10)+" "+(u+f)+" "+(r-5)+" "+(u+f+10)+" "+r+" "+(u+f+10)}y&&(lt={id:at+"_YAxisMultiLevelLabels_Rect_"+t+"_"+g,d:y,stroke:h.color?h.color:i.multiLevelLabelsColor,"stroke-width":h.width,fill:"none"},this.svgRenderer.drawPath(lt,ut))}this.model.enableCanvasRendering&&this.svgRenderer.ctx.restore();n(ut).appendTo(this.gYaxisEle)}},_getLabelCollection:function(n,t,i,r,u){var f=[],h=[],c,s,e,o;for(typeof n=="string"&&n.indexOf("<br>")!=-1?f=n.split("<br>"):f.push(n),r=r<=0?i.width/i.labels.length:r,c=f.length,e=0;e<c;e++)for(s=this.rowscalculation(f[e].toString(),t,i,r,u),o=0;o<s.length;o++)h.push(s[o]);return h},_drawXAxisLabels:function(t,i){var yt=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxisLabels_"+t,cursor:"default"}),sf=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxisLabels_"+t,cursor:"default"}),cu,ct=this.model.m_AreaBounds,ai=this.model.enableCanvasRendering,lu,tf=i.name.replace(/[^a-zA-Z0-9]/g,""),h=i._opposed,gt=i._valueType,dr=3,au=i.alignment.toLowerCase(),cr=i.labelIntersectAction,ni=i.labelPlacement.toLowerCase(),di,w,vi=!1,c=0,st=i.tickLinesPosition=="inside",gr=i._LableMaxWidth,pt=gr.height,ti=gr.rows==0?1:gr.rows,rf=this.svgRenderer.vmlNamespace,ii=i.axisLine.width,y=i.font,b=i.rotationValue,tt,ht,p,et=ct.Width,uf=ct.X,lr,l=i.labelIntersectAction.toLowerCase(),oi=n(this.svgObject).width(),nu,lt,ar,vr,vu,ri,yu,gi,si,tu,ff,yr,nr,u,e,ef=i.maximumLabelWidth,hi=i.visibleRange,ui=et,wt=i.majorTickLines.size,a=i.visibleLabels,gt=i.valueType&&i.valueType.toLowerCase(),bt=i.width,iu=i.isInversed,ru,tr=i.majorTickLines.width,uu,fu,yi,eu=!1,pr=this.model.scrollerSize,of,wr,ci,ir,pi,ou,fi,at=i.rotateOn.toLowerCase(),v=i.labelPosition=="inside",li=0,rt=[],ei=[],o=[],ut,su,s,it,pu,wu,wi,f,rr,ur,bu,d,r,ku,ft,vt,br,g,du,fr,er,or,ot,kt,dt,kr,bi,ki,sr,hr,k,nt,hu;for(su=i._isScroll&&!(i.scrollbarSettings.pointsLength!=null&&i.scrollbarSettings.pointsLength<i.maxPointLength),this.edgeLabel=!1,t==0||!(v&&st||v&&!st)||i.y==ct.Height+ct.Y||i.y==ct.Y?t==0||!v||!st||i.y==ct.Height+ct.Y||i.y==ct.Y?(i._y=Math.floor(i.y),i.y=i.showNextToAxisLine?Math.floor(i.y):h?Math.floor(ct.Y):Math.floor(ct.Height+ct.Y)):i.y=h?Math.floor(i.y-wt):Math.floor(i.y+wt):i.y=h?Math.floor(i.y-pt):Math.floor(i.y+pt),s=0;s<a.length;s++)if(u=a[s],e=u.displayText=ej.util.isNullOrUndefined(u.displayText)?u.Text:u.displayText,ej.EjSvgRender.utils._inside(u.Value,hi)){if(lt=bt/a.length,ej.isNullOrUndefined(gt)||s<a.length-1&&gt=="datetimecategory"&&l=="wrap"&&ni=="betweenticks"&&(ri=a[s+1],u.Value-=.5,yu=ri.Value-.5),it=Math.abs(Math.floor(ej.EjSvgRender.utils._getPointXY(u.Value,hi,iu)*bt)),ej.isNullOrUndefined(gt)||(s<a.length-1&&gt=="datetimecategory"&&l=="wrap"&&ni=="betweenticks"?(vu=Math.abs(Math.floor(ej.EjSvgRender.utils._getPointXY(yu,hi,iu)*bt)),ar=s==0?i.x+it+(tr-.5):i.x+it+(tr+.5),vr=i.x+vu+(tr+.5),lt=vr-ar):gt=="datetimecategory"&&l=="wrap"&&ni=="betweenticks"?(lt=bt+i.x-vr,ar=vr):gt=="datetimecategory"&&l=="wrap"&&ni=="onticks"&&(lt=bt/i.labels.length)),i._gap=ar,this.edgeLabel=!1,ut=typeof e=="string"&&e.indexOf("<br>")!=-1?ej.EjSvgRender.utils._getHighestLabel(i,oi,e):e,tt=ej.EjSvgRender.utils._measureText(ut,ui,i.font),f=tt.width,p=tt.height,c=0,vi=!1,l=="trim"||i.enableTrim){if(ni=="onticks")if(s!=a.length-1){for(pu=u,wu=a[s+1],o=[],ei=[],ri=a[s+1],typeof ri.Text=="string"&&ri.Text.indexOf("<br>")!=-1||typeof u.Text=="string"&&u.Text.indexOf("<br>")!=-1?(o=u.Text.split("<br>"),ei=ri.Text.split("<br>")):(ei.push(ri.Text),u.displayText?o.push(u.displayText):o.push(u.Text)),d=0;d<ei.length;d++)for(gi=Math.abs(Math.floor(ej.EjSvgRender.utils._getPointXY(ri.Value,hi,iu)*bt)),si=ej.EjSvgRender.utils._measureText(ei[d],et,y).width,k=gi-si/2,c=0,tu=!0,wi=0;wi<o.length&&tu;wi++)for(f=ej.EjSvgRender.utils._measureText(o[wi],ui,i.font).width;k<it+f/2&&c<2;)for(c++,si>f?(ff=yr=ei[d],eu=!1):(yr=o[wi],eu=!0),ht=yr,rr={},rr.displayText=yr,g=1;g<ht.length;g++)if(ht=rr.displayText.substring(0,g)+"... ",nr=ej.EjSvgRender.utils._measureText(ht,et,y).width,eu){if(k=gi-si/2,k<it+nr/2){g-1!=0&&(ht=ht.toString().substring(0,g-1)+"... ");f=nr;e=rr.displayText=pu.displayText=ht;o[wi]=ht;break}}else if(k=gi-nr/2,k<it+f/2){g-1!=0&&(ht=ht.toString().substring(0,g-1)+"... ");si=nr;rr.displayText=wu.displayText=ht;ei[d]=ht;tu=!1;break}}else s==a.length-1&&(o=ei);else if(ni=="betweenticks")for(ur=i.enableTrim?ef:lt,o=[],typeof e=="string"&&e.indexOf("<br>")!=-1?o=e.split("<br>"):o.push(e),bu=o.length,d=0;d<bu;d++)if(u.displayText=o[d],tt=ej.EjSvgRender.utils._measureText(o[d],ui,i.font),f=tt.width,f>ur&&o[d]!=""){for(g=1;g<o[d].toString().length;g++)if(o[d]=u.displayText.toString().substring(0,g)+"... ",f=ej.EjSvgRender.utils._measureText(o[d],et,y).width,f>=ur){if(o[d]=o[d].toString().substring(0,g-1)+"... ",u.displayText=o[d],s==a.length-1&&it+i.x+f/2>oi&&ur==lt){ur-=f/2;g=1;continue}break}u.displayText=o[d]}(i._valueType!="double"||typeof u.displayText=="string")&&(ut=o.length>0?ej.EjSvgRender.utils._getHighestLabel(i,oi,o,null):ut,tt=ej.EjSvgRender.utils._measureText(ut,et,y))}else tt=typeof e=="string"&&e.indexOf("<br>")!=-1?ej.EjSvgRender.utils._measureText(ut,et,y):ej.EjSvgRender.utils._measureText(u.displayText,et,y);if(lr=tt.width/2,p=tt.height,f=tt.width,nu=i.majorGridLines.width>tr?i.majorGridLines.width:tr,!ej.util.isNullOrUndefined(u.Text)){if(di=au=="near"?it+i.x+nu+(gt=="category"&&ni!="onticks"?-(bt/i.actualRange.delta)/2+dr:-tt.width-dr):au=="far"?it+i.x+(gt=="category"&&ni!="onticks"?+(bt/i.actualRange.delta/2)-tt.width:+nu+dr):it+i.x-lr,v&&st||v&&!st&&l=="multiplerows"?w=h?i.y+wt+p/2+ii/2+pt/(2*ti)-5:i.y-wt-ii/2-pt/(2*ti)+5:v&&!st?w=h?i.y+p/2+ii/2+pt/(2*ti)-5:i.y-ii/2-pt/(2*ti)+5:(v||st)&&(v||!st||l!="multiplerows")?!v&&st&&(w=h?i.y+p/2-ii/2-pt/(2*ti)-5:i.y+ii/2+pt/(2*ti)+5,w=w+(su?h?-pr:pr:0)):(w=h?i.y-wt+p/2-ii/2-pt/(2*ti)-5:i.y+wt+ii/2+pt/(2*ti)+5,w=w+(su?h?-pr:pr:0)),v&&!st?(b==90||l=="rotate90")&&(w=h?w:w-wt):!v&&st?(i.labelRotation==90||l=="rotate90")&&(w=h?w-wt:w-wt):v&&st&&(i.labelRotation==90||l=="rotate90")&&(w=h?w:w-wt),r={id:this.svgObject.id+"_"+tf+"_XLabel_"+s,x:di,y:w,fill:y.color,"font-size":y.size,"font-family":y.fontFamily,"font-style":y.fontStyle,"font-weight":y.fontWeight,opacity:y.opacity},i.edgeLabelPlacement){uu=i.edgeLabelPlacement.toLowerCase();fu=a.length-1;switch(uu){case"shift":s==0?r.x<i.x&&(yi=i.x-r.x,r.x=di=r.x+yi,this.diff=yi,this.edgeLabel=!0):s==fu&&r.x+tt.width>i.x+i.width&&(yi=r.x+tt.width-(i.x+i.width),r.x=di=r.x-yi,this.diff=yi,this.edgeLabel=!0);break;case"hide":(s==0&&r.x<i.x||s==fu&&r.x+f>et+uf)&&(e="")}}if((l=="wrap"||l=="wrapbyword")&&(vt=this._getLabelCollection(e,ui,i,lt,r),ku=ej.EjSvgRender.utils._getHighestLabel(i,n(this.svgObject).width(),vt,null),f=ej.EjSvgRender.utils._measureText(ku,et,y).width),b==0||rf||(u.displayText=typeof u.displayText=="string"&&u.displayText.indexOf("<br>")!=-1?ej.EjSvgRender.utils._getHighestLabel(i,oi,u.displayText):u.displayText,this.labelRotation(i,di+lr,w,r,u,b)),i.labelIntersectAction||i.enableTrim)if(this.diff=ej.util.isNullOrUndefined(this.diff)?0:this.diff,l!="none"||i.enableTrim)if(l!="wrap"&&l!="wrapbyword"||i.enableTrim){if(l=="hide")for(fr=a.length-1,er=0;er<s;er++){if(ir=a[er],pi=0,ou=Math.abs(Math.floor(ej.EjSvgRender.utils._getPointXY(ir.Value,hi,i.isInversed)*i.width)),fi=ej.EjSvgRender.utils._measureText(ir.displayText,ui,i.font).width,k=ou+(i.isInversed?-fi/2:fi/2),k=er==0?k+this.diff:k,or=fi==0?fi:f,(s!=fr||s==fr&&f<=fi)&&(or=or/2),uu=="shift"&&s==fr){var gu=a[s],gi=Math.abs(Math.floor(ej.EjSvgRender.utils._getPointXY(gu.Value,hi,i.isInversed)*i.width)),si=ej.EjSvgRender.utils._measureText(gu.displayText,ui,i.font).width,nf=gi+(i.isInversed?si/2:-si/2);(i.isInversed?k<=nf-this.diff:k>=nf-this.diff)&&(e=u.displayText="")}l=="hide"&&(i.isInversed?k<it+or:k>it-or)&&(u.displayText=e="")}else if(l=="multiplerows"&&!i.enableTrim){if(ot=[],kt=u,typeof kt.Text=="string"&&kt.Text.indexOf("<br>")!=-1?ot=kt.Text.split("<br>"):ot.push(kt.Text),dt=ot.length,e==""&&i.edgeLabelPlacement=="hide")for(kr=0;kr<dt;kr++)ot[kr]="";var hu=ej.EjSvgRender.utils._getHighestLabel(i,oi,ot),f=ej.EjSvgRender.utils._measureText(hu,et,y).width,fr=i.visibleLabels.length-1;if(f=f/2,rt.length>0)for(bi=rt,ki=0;ki<bi.length&&!vi;ki++)for(sr=bi[ki],hr=0;sr&&hr<sr.length;hr++)for(nt=0;nt<dt;nt++){var pi=0,f=ej.EjSvgRender.utils._measureText(ot[nt],et,y).width,ir=sr[hr],ou=Math.abs(Math.floor(ej.EjSvgRender.utils._getPointXY(ir.Value,hi,i.isInversed)*i.width)),fi=ej.EjSvgRender.utils._measureText(ir.Text,ui,i.font).width;if(s!=fr&&(f=f/2),k=ou+(i.isInversed?-fi/2:fi/2),(this.edgeLabel||bi.length==1)&&(k=k+this.diff),i.isInversed?k<it+f:k>it-f)if(h){pi=v?r.y+p:r.y-p;r.y=pi;c=c+1;c<li&&(c=c+li,li=0);ki+1==bi.length&&(vi=!0);break}else{pi=v?r.y-p:r.y+p;r.y=pi;c=c+1;c<li&&(c=c+li,li=0);ki+1==bi.length&&(vi=!0);break}else if(hr+1==sr.length){nt==dt-1?vi=!0:(li++,vi=!1);break}}if(pi==undefined)if(rt[0]==undefined&&(rt[0]=[]),dt==1)rt[0].push(kt);else for(nt=0;nt<dt;nt++)rt[nt]==undefined&&(rt[nt]=[]),rt[nt].push({Text:ot[nt],Value:kt.Value});else if(rt[c]==undefined&&(rt[c]=[]),dt==1)rt[c].push(kt);else for(nt=0;nt<dt;nt++)rt[c]==undefined&&(rt[c]=[]),rt[c].push({Text:ot[nt],Value:kt.Value}),nt!=dt-1&&(c=c+1);r.y=v?h?r.y:r.y-p*(ot.length-1):h?r.y-p*(ot.length-1):r.y;b!=0&&b!=-360&&b!=360&&(hu=ej.EjSvgRender.utils._getHighestLabel(i,oi,ot),f=ej.EjSvgRender.utils._measureText(hu,et,y).width,r["text-anchor"]=at,r.x=r.x+f/2);this.svgRenderer.drawText(r,ot,yt)}}else{for(of=0,ft=[],vt=[],typeof e=="string"&&e.indexOf("<br>")!=-1?ft=e.split("<br>"):ft.push(e),ci="",lt=lt<=0?bt/a.length:lt,br=0;br<ft.length;br++)for(wr=this.rowscalculation(ft[br].toString(),ui,i,lt,r),g=0;g<wr.length;g++)vt.push(wr[g]),ci=ci+wr[g];r.x=r.x+lr;ci.indexOf("...")!=-1||(ci=e);var ut=ej.EjSvgRender.utils._getHighestLabel(i,oi,vt,null),tt=ej.EjSvgRender.utils._measureText(ut,et,y),f=tt.width;r.x=r.x-f/2;r.y=v?h?r.y:r.y-p*(vt.length-1):h?r.y-p*(vt.length-1):r.y;b!=0&&b!=-360&&b!=360&&(r["text-anchor"]=at,r.x=r.x+f/2);this.svgRenderer.drawText(r,vt,ai?ut:yt);lu=ej.EjSvgRender.utils._measureText(vt[0],null,y);du=vt.length;ru=lu.height*vt.length;cu={x:r.x,y:r.y,width:f,height:ru-ru/du};a[s].region={bounds:cu,labelText:u.Text,displayText:ci};a[s].displayText=ci;this.model.xAxisLabelRegions.push(a[s].region);continue}else{typeof e=="string"&&e.indexOf("<br>")!=-1?(ft=e.split("<br>"),r.y=v?h?r.y:r.y-p*(ft.length-1):h?r.y-p*(ft.length-1):r.y,b!=0&&(r.x=r.x+f/2,r["text-anchor"]=at),this.svgRenderer.drawText(r,ft,ai?ut:yt)):((at=="start"||at=="end")&&b!=0&&b!=-360&&b!=360&&(r.x=r.x+f/2,r["text-anchor"]=at),this.svgRenderer.drawText(r,e,ai?ut:yt));a[s].region=this.calculateRegion(e,y,r,u);this.model.xAxisLabelRegions.push(a[s].region);v?n(yt).appendTo(this.gXaxisTickEle):n(yt).appendTo(this.gXaxisEle);continue}this.edgeLabel||this.zoomed||i.zoomed||b||cr=="rotate90"||cr=="rotate45"||!(it+i.x+f/2>n(this.svgObject).width())||(n(r).attr("x",n(this.svgObject).width()-2),n(r).attr("text-anchor","end"));i.visibleLabels[s].y=r.y;this.model.enableCanvasRendering&&v&&(i.labelIntersectAction=="rotate45"||i.labelIntersectAction=="rotate90")&&(r.y=r.y-f);(l=="trim"||i.enableTrim)&&(i._valueType!="double"||typeof u.displayText=="string")?(r.y=v?h?r.y:r.y-p*(o.length-1):h?r.y-p*(o.length-1):r.y,u.displayText=o.length>0?o.join(""):e,u.displayText.indexOf("...")!=-1||(u.displayText=e),b!=0&&at!="middle"&&(r.x=r.x+f/2,r["text-anchor"]=at),this.svgRenderer.drawText(r,o.length>0?o:e,ai?ut:yt)):l!="multiplerows"&&(typeof e=="string"&&e.indexOf("<br>")!=-1?(ft=e.split("<br>"),r.y=v?h?r.y:r.y-p*(ft.length-1):h?r.y-p*(ft.length-1):r.y,(b!=0||cr=="rotate45"||cr=="rotate90")&&(r.x=r.x+f/2,r["text-anchor"]=at),this.svgRenderer.drawText(r,ft,ai?ut:yt)):(at=="start"&&b!=0&&b!=-360&&b!=360&&(r.x=r.x+f/2,r["text-anchor"]=at),this.svgRenderer.drawText(r,e,ai?ut:yt)));s!=a.length-1&&(l=="trim"||i.enableTrim)&&(r.x=r.x-f/2);i.visibleLabels[s].region=this.calculateRegion(e,y,r,u,o?o:ft,ut,l);this.model.xAxisLabelRegions.push(i.visibleLabels[s].region)}}n(yt).appendTo(this.gXaxisEle)},calculateRegion:function(n,t,i,r,u,f,e){var o;e=="trim"&&u.length>0?(o=u.join(""),o.indexOf("...")!=-1||(o=r.Text)):o=f?f:n;var s=u?u.length>0?u.length:1:1,h=s>1&&f?ej.EjSvgRender.utils._measureText(f,null,t):ej.EjSvgRender.utils._measureText(o,null,t),c=h.height*s,l={x:i.x,y:i.y,width:h.width,height:c};return{bounds:l,trimText:o,labelText:r.Text}},rowscalculation:function(n,t,i,r,u){var h=ej.EjSvgRender.utils._measureText,s=i.font,nt=h(n,t,s),c=nt.width,rt=c/2,e=n.toString(),tt=e.length,a=[],f=0,w,d,it=i.labelIntersectAction,v=e.split(" "),g=v.length,l,b,y,o,p,k;if(this.edgeLabel&&(r=f==0?r-this.diff:r),c>r&&u&&(w=0,this.edgeLabel&&(u.x=f==0?u.x-this.diff:u.x+this.diff)),it=="wrap"){if(c>r)for(l=1;l<=e.length;l++)n=e.substring(0,l),c=h(n,t,s).width,c>r&&(w=w+1,n=e.substring(0,l-1),a[f]=n,e=e.slice(l-1,tt),d=e.split(" "),e=v.indexOf(d[0])>-1?e:"-"+e,b=h(n,t,s).width,f++,l=0);u&&(u.x=i.valueType=="datetimeCategory"&&i.labelPlacement.toLowerCase()=="betweenticks"?i._gap:u.x);a[f]=n}else for(y=0,f=0;f<g;f++)if(o=v[f],p=h(o,t,s).width,p<r&&c>r){while(f<g)if(p=h(o,t,s).width,k=v[f+1]?h(v[f+1],t,s).width:0,p+k<=r&&k>0)o=o.concat(" "+v[f+1]),f++;else{y=Math.max(y,p);break}a.push(o)}else if(c>r)o=ej.EjSvgRender.utils._trimText(o,r,s),b=h(o,t,s).width,y=Math.max(y,b),a.push(o);else{a.push(n);break}return a},labelRotation:function(t,i,r,u,f,e,o){var y=t._opposed,p=t.rotateOn.toLowerCase(),w=t.labelIntersectAction.toLowerCase(),c=0,l=f.displayText?f.displayText:f.Text,s=e>360?e-360:e<-360?e+360:e,v="rotate("+s+","+i+","+r+")",h;if(n(u).attr("transform",v),n(u).attr("labelRotation",s),n(u).attr("labelPosition",t.labelPosition),w=="wrap"||w=="wrapbyword")var d=t.width/t.labels.length,g=this._getLabelCollection(l,this.model.m_AreaBounds.width,t,d,u),l=ej.EjSvgRender.utils._getHighestLabel(t,n(this.svgObject).width(),g,null);var b=this.svgRenderer.createText(u,l),a=Math.round(ej.EjSvgRender.utils._measureBounds(b,this).height),k=ej.EjSvgRender.utils._measureText(l,null,t.font).height;c=Math.ceil(ej.EjSvgRender.utils._measureBounds(b,this).height-ej.EjSvgRender.utils._measureText(l,null,t.font).height);c=t._LableMaxWidth.height-c-ej.EjSvgRender.utils._measureText(l,null,t.font).height;h=t.labelPosition!="inside"?y?c/2:-c/2:y?-c/2:c/2;p=="end"&&(h=h+(s<0&&s>-180||s>180?-(a/2):(a-k)/2));p=="start"&&(h=h+(s<0&&s>-180||s>180?a/2:-((a-k)/2)));v="rotate("+s+","+i+","+(r+(this.model.enableCanvasRendering&&t.opposedPosition?-h:h))+")";this.edgeLabel&&e==90&&(r=o==0?u.y+this.diff:u.y-this.diff);n(u).attr({transform:v,y:r+(this.model.enableCanvasRendering&&t.opposedPosition?-h:h)})},_drawYAxisLabels:function(t,i){var wi=i.name.replace(/[^a-zA-Z0-9]/g,""),gt=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisLabels_"+t,cursor:"default"}),k,fi,et,yt,e=i._opposed,a=i.labelPosition=="inside",nt=i.tickLinesPosition=="inside",tt,pt,s=this.model.m_AreaBounds,di=this.model.requireInvertedAxes,bi=this.model.enableCanvasRendering,ei=i._isScroll&&!(i.scrollbarSettings.pointsLength!=null&&i.scrollbarSettings.pointsLength<i.maxPointLength),wt,oi,si,ni,v,ti,h=i.font,hi=i.visibleRange,d=i.axisLine.width,g=i._LableMaxWidth,gi=g.height,nr=g.rows,s=this.model.m_AreaBounds,ii=s.Width,ci=i.maximumLabelWidth,o,ot,it,bt,kt,li,u,dt=this.model.scrollerSize,y,ri=i.labelIntersectAction.toLowerCase(),f,rt=i.visibleLabels,ai=hi,st=i.isInversed,w=i.height,ut,ki,vi,ht,p,b=i.labelRotation,ui,yi=i.alignment.toLowerCase(),pi=3,ft,c,l,ct,lt,r,at,vt;for(t==1||(!a||!nt)&&(!a||nt||i.x==s.Width+s.X||i.x==s.X)?t==1||i.x==s.Width+s.X&&i.x!=s.X||a||!nt?(i._x=Math.floor(i.x),i.x=i.showNextToAxisLine?Math.floor(i.x):e?Math.floor(s.X+s.Width):Math.floor(s.X)):(i._x=Math.floor(i.x),i.x=e?Math.floor(i.x+i.majorTickLines.size):i.showNextToAxisLine?Math.floor(i.x-i.majorTickLines.size):Math.floor(s.X)):i.x=e?a&&nt?Math.floor(i.x):Math.floor(i.x+g.width+this.model.elementSpacing):i.showNextToAxisLine?Math.floor(i.x):Math.floor(i.x-g.width-this.model.elementSpacing),c=0;c<rt.length;c++)if(f=rt[c],ej.EjSvgRender.utils._inside(f.Value,ai)){if(wt=Math.abs(ej.EjSvgRender.utils._getPointXY(f.Value,ai,st)*w),oi=ej.EjSvgRender.utils._measureText(f.Text,s.Height,h),v=oi.height,r=f.displayText=f.Text,li=ej.EjSvgRender.utils._measureText(r,ii,h),y=li.width,a&&nt?(o=e?i.x-i.majorTickLines.size-d/2-5:i.x+d/2+5+i.majorTickLines.size,ot=e?"end":"start"):a&&!nt?(o=e?i.x-d/2-5:i.x+d/2+5,ot=e?"end":"start"):nt&&!a?(o=e?d/2+i.x+5:i.x-d/2-5,ot=e?"start":"end",o=o-(ei?e?-dt:dt:0)):(o=e?i.majorTickLines.size+d/2+i.x+5:i.x-d/2-5-i.majorTickLines.size,ot=e?"start":"end",o=o-(ei?e?-dt:dt:0)),ui=i.majorGridLines.width>i.majorTickLines.width?i.majorGridLines.width:i.majorTickLines.width,ft=yi=="far"?-wt+(i.y+w)-ui-pi:yi=="near"?-wt+(i.y+w)+v/2+ui+pi:-wt+(i.y+w)+v/4,u={id:this.svgObject.id+"_"+wi+"_YLabel_"+c,x:o,y:ft,fill:h.color,"font-size":h.size,"font-family":h.fontFamily,"font-style":h.fontStyle,"font-weight":h.fontWeight,opacity:h.opacity,"text-anchor":!ej.util.isNullOrUndefined(b)&&b!=0?"middle":ot},r=f.displayText?f.displayText:f.Text,l=[],typeof r=="string"&&r.indexOf("<br>")!=-1?(l=r.split("<br>"),ct=r=ej.EjSvgRender.utils._getHighestLabel(i,s.Height,l),y=ej.EjSvgRender.utils._measureText(r,ii,h).width):l.push(r),i.edgeLabelPlacement){si=i.edgeLabelPlacement.toLowerCase();ni=rt.length-1;switch(si){case"shift":c==0?u.y>i.y+w&&(it=u.y-(i.y+w),u.y=ft=u.y-it,this.diff=it,this.edgeLabel=!0):c==ni&&u.y-v/2<i.y&&(it=i.y-(u.y-v/2),u.y=ft=u.y+it,this.diff=it,this.edgeLabel=!0);break;case"hide":(c==0&&u.y>i.y+w||c==ni&&u.y-v/2<s.Y)&&(r=f.Text="",l.length==1&&(l[0]=r))}}if(ej.util.isNullOrUndefined(b)||b==0||this.svgRenderer.vmlNamespace||(o=a?e?o-y/2:o+y/2:e?o+y/2:o-y/2,r=f.displayText?f.displayText:f.Text,r=ct?ct:r,bt=b>360?b-360:b<-360?b+360:b,kt="rotate("+bt+","+o+","+ft+")",n(u).attr("transform",kt),n(u).attr("labelRotation",bt),fi=this.svgRenderer.createText(u,r),et=Math.ceil(ej.EjSvgRender.utils._measureBounds(fi,this).width-ej.EjSvgRender.utils._measureText(r,null,h).width),ti=a?e?-et/2:et/2:e?et/2:-et/2,kt="rotate("+bt+","+(o+ti)+","+ft+")",n(u).attr({transform:kt,x:o+ti})),i.labelIntersectAction||i.enableTrim){if(ri!="none"||i.enableTrim){if(i.enableTrim)for(lt=0;lt<l.length;lt++)if(r=l[lt],y=ej.EjSvgRender.utils._measureText(r,null,h).width,y>ci&&r!=""){for(at=1;at<r.toString().length;at++)if(r=f.displayText.toString().substring(0,at-1)+"...",y=ej.EjSvgRender.utils._measureText(r,ii,h).width,y>=ci){r=r.toString().substring(0,at-1)+"...";break}f.displayText=l[lt]=r}}else{this.svgRenderer.drawText(u,l.length>0?l:f.Text,bi&&ct?ct:gt);k=ej.EjSvgRender.utils._measureText(r,null,h);pt=i.opposedPosition?u.x:u.x-k.width;tt={x:pt,y:u.y,width:k.width,height:k.height};yt={bounds:tt,trimText:r,labelText:f.Text};i.visibleLabels[c].region={bounds:tt,trimText:r,labelText:f.Text};this.model.yAxisLabelRegions.push(yt);continue}for(vt=0;vt<c;vt++)ut=rt[vt],ki=0,vi=Math.abs(ej.EjSvgRender.utils._getPointXY(ut.Value,hi,st)*w),ht=ej.EjSvgRender.utils._measureText(ut.Text,s.Height,h).height,p=vi*-1+(i.y+w)+ht/4,p=p+(st?ht/2:-ht/2),this.edgeLabel&&(p=vt==0?p-ht/4:p),ri=="hide"&&ut.Text.toString()!=""&&(st?p>u.y-v/4:p<u.y+v/4)?r=f.Text="":ri=="multiplerows"&&(st?p>u.y-v/4:p<u.y+v/4)&&ut.x==u.x&&(u.x=ut.x+e?a?-g.maxWidth-5:g.maxWidth+5:a?g.maxWidth+5:-g.maxWidth-5)}rt[c].x=u.x;this.svgRenderer.drawText(u,l.length>0?l:r,gt);k=ej.EjSvgRender.utils._measureText(r,null,h);pt=e?u.x:u.x-k.width;tt={x:pt,y:u.y,width:k.width,height:k.height};yt={bounds:tt,trimText:r,labelText:f.Text};rt[c].region={bounds:tt,trimText:r,labelText:f.Text};this.model.yAxisLabelRegions.push(yt)}n(gt).appendTo(this.gYaxisEle)},trimText:function(n,t,i){return t--,n=n.substring(0,t-i.length),n+i},_drawXTitle:function(t,i){var et,f,w,o,st,ht;if(i.title.text!=""&&i.title.text&&i.title.visible){var g=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxis_Title_"+t,cursor:"default"}),pt=this.model.elementSpacing+i._LableMaxWidth.height,u=ej.EjSvgRender.utils._measureText(i.title.text,i.width,i.title.font),e=u.height/2,it=i._opposed,l=i.title.text,b=i._LableMaxWidth,p="middle",r=this.model.elementSpacing,rt=i.title.enableTrim,a=i._isScroll||this.model.zooming.enableScrollbar&&i.scrollbarSettings.visible&&(i.zoomFactor<1||i.zoomPosition>0),v=i.title.maximumTitleWidth,k=i.title.position.toLowerCase(),ft=i.title.alignment.toLowerCase(),w,nt=i.title.isReversed,s=i.tickLinesPosition.toLowerCase(),h=i.labelPosition.toLowerCase(),c=this.model.m_AreaBounds,d=i.title.offset,tt,ut,y=this.model.scrollerSize;if(rt&&(ej.util.isNullOrUndefined(v)||v>0||isNaN(v)))for(et=v?v:i.width-r*2;u.width>et;)if(l=this.trimText(l,l.length,"..."),u=ej.EjSvgRender.utils._measureText(l,i.width,i.title.font),l=="..."){l="";break}if(f=n.extend({},ej.EjSvgRender.commonChartEventArgs),w=r+b.height+e+i._multiLevelLabelHeight+i.majorTickLines.size+i.axisLine.width,s=="inside"&&h=="inside"&&(t==0||i.y==c.Height+c.Y||i.y==c.Y)?w=k=="inside"?r+b.height+e+i._multiLevelLabelHeight+i.majorTickLines.size+i.axisLine.width:r+e+i.axisLine.width:(t==0||i.y==c.Width+c.X||i.y==c.X)&&s!="inside"&&h=="inside"?w=k=="inside"?r+b.height+e+i._multiLevelLabelHeight+i.axisLine.width:r+i.majorTickLines.size+i.axisLine.width:(t==0||i.y==c.Width+c.X||i.y==c.X)&&s=="inside"&&h!="inside"?w=k=="inside"?r+e+i.majorTickLines.size+i.axisLine.width:r+b.height+e+i._multiLevelLabelHeight+i.axisLine.width:s!="inside"&&h!="inside"||t!=1?w=k=="inside"?r:r+b.height+e+i.majorTickLines.size+i.axisLine.width+i._multiLevelLabelHeight:s=="inside"||h!="inside"||i.showNextToAxisLine||(w=k=="inside"?r+b.height+e+i._multiLevelLabelHeight+i.axisLine.width:r+e+i.majorTickLines.size+i.axisLine.width+r+r),ft=="far"?(tt=nt?i.x+d:i.x+i.width+d,p=nt?"start":"end"):ft=="near"?(tt=nt?i.x+i.width+d:i.x+d,p=nt?"end":"start"):tt=i.x+i.width/2+d,f.data={title:i.title.text,location:{x:tt,y:w},axes:i},this._trigger("axesTitleRendering",f),ut=k=="inside"?(it?s=="inside"&&h=="outside"?i.y+f.data.location.y-(a?y:0)-i.majorTickLines.size:i.y+f.data.location.y-(a?y:0):s=="outside"&&h=="inside"?(a?y:0)+(i.y-f.data.location.y)+i.majorTickLines.size:(a?y:0)+(i.y-f.data.location.y))+u.height/3.5:(it?s=="inside"&&h=="outside"?i.y-f.data.location.y-(a?y:0)-i.majorTickLines.size:i.y-f.data.location.y-(a?y:0):s=="outside"&&h=="inside"?(a?y:0)+(f.data.location.y+i.y)-i.majorTickLines.size:(a?y:0)+(f.data.location.y+i.y))+u.height/3.5,o={id:this.svgObject.id+"_XAxisTitle_"+t,x:f.data.location.x,y:ut,fill:i.title.font.color,"font-size":i.title.font.size,"font-family":i.title.font.fontFamily,"font-style":i.title.font.fontStyle,"font-weight":i.title.font.fontWeight,opacity:i.title.font.opacity,"text-anchor":p},this.model.enableCanvasRendering){var ct=jQuery.uaMatch(navigator.userAgent),lt=!!navigator.userAgent.match(/Trident\/7\./),ot=ct.browser.toLowerCase();ot=="msie"||lt||(o.y=it?o.y+e/2+1:o.y+e/2+(ot=="mozilla"?1:-2))}if(n(this.svgObject).find("#"+this.svgObject.id+"_XAxisTitle_"+t).length>0)n(this.svgObject).find("#"+this.svgObject.id+"_XAxisTitle_"+t).attr(o);else if(rt){if(rt&&(ej.util.isNullOrUndefined(v)||v>0||isNaN(v))){var at=p=="middle"?o.x-u.width/2:p=="end"?o.x-u.width:o.x,vt={X:at,Y:o.y,Width:u.width,Height:u.height},yt={Bounds:vt,trimText:l,labelText:i.title.text};this.model.xAxisTitleRegion.push(yt);this.svgRenderer.drawText(o,l,g)}}else this.svgRenderer.drawText(o,f.data.title,g);this.model.enableCanvasRendering||(st=p=="start"?0:p=="end"?u.width:u.width/2,ht={id:this.svgObject.id+"_XAxisTitleBorder_"+t,x:f.data.location.x-st-r,y:ut-u.height+u.height/4,width:u.width+2*r,height:u.height,fill:"transparent","class":"e-xaxistitleborder"},this.svgRenderer.drawRect(ht,g));n(g).appendTo(this.gXaxisEle)}},_drawYTitle:function(t,i){var u,et,w,ut,o,st,ht,ct,lt;if(i.title.text!=""&&i.title.text&&i.title.visible){var e=i._opposed,r=this.model.elementSpacing,p="middle",ft=this.model.series.isTransposed,h=i.majorTickLines.size,b=i.title.position.toLowerCase(),c=i._LableMaxWidth,l=this.model.m_AreaBounds,s,f=i.axisLine,g=i.tickLinesPosition.toLowerCase(),k=i.labelPosition.toLowerCase(),a=i.title.text,nt=i.title.enableTrim,pt=this.model.requireInvertedAxes,y,at=i._isScroll,v=i.title.maximumTitleWidth,tt=i.title.offset,it=i.title.alignment.toLowerCase(),d=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisTitleGroup_"+t,cursor:"default"}),rt=ej.EjSvgRender.utils._measureText(i.title.text,i.height,i.title.font);if(g=="inside"&&k=="inside"&&(t==1||i.x==l.Width+l.X||i.x==l.X)?s=b=="inside"?e?i.x-(3*r+c.width+i._multiLevelLabelHeight+h+f.width):i.x+(3*r+c.width+i._multiLevelLabelHeight+h+f.width):e?i.x+(3*r+f.width-5):i.x-(3*r+f.width):(t==1||i.x==l.Width+l.X||i.x==l.X)&&g!="inside"&&k=="inside"?s=b=="inside"?e?i.x-(3*r+c.width+i._multiLevelLabelHeight+f.width):i.x+(3*r+c.width+i._multiLevelLabelHeight+f.width):e?i.x+(3*r+h+f.width):i.x-(3*r+h+f.width):(t==1||i.x==l.Width+l.X||i.x==l.X)&&g=="inside"&&k!="inside"?s=b=="inside"?e?i.x-(3*r+h+f.width):i.x+(3*r+h+f.width)+(i.showNextToAxisLine?k=="inside"?-i._multiLevelLabelHeight:i._multiLevelLabelHeight:-r):e?i.x+(3*r+i._multiLevelLabelHeight+c.width+f.width):i.x-(3*r+c.width+f.width+i._multiLevelLabelHeight):(i.tickLinesPosition!="inside"&&i.labelPosition!="inside"||t!=1)&&(s=b=="inside"?e?i.x-(r+f.width+h):i.x+(r+(i.showNextToAxisLine?0:c.width)+f.width+h):e?i.x+(3*r+i._multiLevelLabelHeight+c.width+h+f.width):i.x-(3*r+c.width+i._multiLevelLabelHeight+h+f.width)),u=ej.EjSvgRender.utils._measureText(a,i.height,i.title.font),nt&&(ej.util.isNullOrUndefined(v)||v>0||isNaN(v)))for(et=v?v:i.height-r*2;u.width>et;)if(a=this.trimText(a,a.length,"..."),u=ej.EjSvgRender.utils._measureText(a,i.height,i.title.font),a=="..."){a="";break}if(s=i.opposedPosition?s:s-(at?this.model.scrollerSize:0),document.documentMode===8&&(s=e?s+u.width/2-r:s-u.width/2+r),w=n.extend({},ej.EjSvgRender.commonChartEventArgs),w.data={title:i.title.text,location:{x:rt.width/2,y:0},axes:i},this._trigger("axesTitleRendering",w),y=w.data.location.y+(i.y+i.height)+i.height/-2,it=="near"?(y=i.y+i.height-tt,p=e||ft?"end":"start"):it=="far"?(y=i.y-tt,p=e||ft?"start":"end"):it=="center"&&(y=i.y+i.height/2-tt),ut=e?90:-90,o={id:this.svgObject.id+"_YAxisTitle_"+t,x:s,y:y,fill:i.title.font.color,labelRotation:ut,transform:"rotate("+ut+","+s+","+y+")","font-size":i.title.font.size,"font-family":i.title.font.fontFamily,"font-style":i.title.font.fontStyle,"font-weight":i.title.font.fontWeight,opacity:i.title.font.opacity,"text-anchor":p,"dominant-baseline":"middle"},this.model.enableCanvasRendering){var vt=jQuery.uaMatch(navigator.userAgent),yt=!!navigator.userAgent.match(/Trident\/7\./),ot=vt.browser.toLowerCase();ot=="msie"||yt||(o.x=e?o.x-rt.height/4+1:o.x+rt.height/4+(ot=="mozilla"?1:-2))}n(this.svgObject).find("#"+this.svgObject.id+"_YAxisTitle_"+t).length>0?n(this.svgObject).find("#"+this.svgObject.id+"_YAxisTitle_"+t).attr(o):nt?nt&&(ej.util.isNullOrUndefined(v)||v>0||isNaN(v))&&(st=this.svgRenderer.vmlNamespace?{X:o.x-u.width/2,Y:o.y+u.height/2,Width:u.width,Height:u.height}:{X:o.x-u.height/2,Y:o.y+u.width/2,Width:u.height/2,Height:u.width},ht={Bounds:st,trimText:a,labelText:i.title.text},this.model.yAxisTitleRegion.push(ht),this.svgRenderer.drawText(o,a,d)):this.svgRenderer.drawText(o,w.data.title,d);this.model.enableCanvasRendering||(ct=p=="start"?u.width:p=="end"?0:u.width/2,lt={id:this.svgObject.id+"_YAxisTitleBorder_"+t,x:o.x-u.height+u.height/2,y:o.y-ct-r,width:u.height,height:u.width+2*r,fill:"transparent","class":"e-yaxistitleborder"},this.svgRenderer.drawRect(lt,d));n(d).appendTo(this.gYaxisEle)}}};ej.EjStripline.prototype={_drawStripline:function(n,t,i,r){var p=ej.util.isNullOrUndefined(n.valueType)?n._valueType.toLowerCase():n.valueType.toLowerCase(),f,e,w,s,h,c,k,l,y;typeof t.start=="string"&&typeof t.end=="string"&&(t.start=t.start.indexOf("/Date(")!=-1?new Date(parseInt(t.start.substr(6))):t.start,t.end=t.end.indexOf("/Date(")!=-1?new Date(parseInt(t.end.substr(6))):t.end);p=="datetimecategory"?(f=t.start!=null&&typeof t.start!="number"?n.labels.indexOf(t.start.getTime()):t.start,e=t.end!=null&&typeof t.end!="number"?n.labels.indexOf(t.end.getTime()):t.end):(f=t.start<n.visibleRange.min?n.visibleRange.min:t.start,e=t.end>n.visibleRange.max?n.visibleRange.max:t.end);var l=0,b=t.isRepeat,a=t.repeatEvery,v=t.repeatUntil,o=t.width,u;if(t.visible)if(this.model._stripeline=!0,w=t.startFromAxis,s=t.zIndex=="over"?this.gStriplineOver:this.gStriplineBehind,s=ej.util.isNullOrUndefined(s)?"":s,h=!0,c=0,n.orientation.toLowerCase()=="horizontal")if(k=0,l=-90,ej.util.isNullOrUndefined(f)&&(ej.util.isNullOrUndefined(e)||ej.util.isNullOrUndefined(o)))h=!1;else if(f=w?ej.util.isNullOrUndefined(t.offset)?n.visibleRange.min:n.visibleRange.min+t.offset:jQuery.type(f)=="date"?f.getTime():f,ej.util.isNullOrUndefined(e)||jQuery.type(e)!="date"||(e=e.getTime()),b&&!ej.util.isNullOrUndefined(a)&&o)for(y=ej.util.isNullOrUndefined(v)?e?e:n.visibleRange.max:n._valueType=="datetime"?v.getTime():v;f<y;)e=n._valueType==="datetime"?this._getDatetimeValue(e,f,o,n,o?null:e,t,p):f+o,u=this._getHorizontalValue(f,e,n,o,t),h&&this._drawAxisStriplines(u.x,u.y,u.height,u.width,u.textX,u.textY,l,i,c,r,s,t,n),c++,f=n._valueType==="datetime"?this._getDatetimeValue(e,f,a,n,null,t,p):f+a;else u=this._getHorizontalValue(f,e,n,o,t),h&&this._drawAxisStriplines(u.x,u.y,u.height,u.width,u.textX,u.textY,l,i,c,r,s,t,n);else if(ej.util.isNullOrUndefined(f)&&(ej.util.isNullOrUndefined(e)||ej.util.isNullOrUndefined(o)))h=!1;else if(f=w?ej.util.isNullOrUndefined(t.offset)?n.visibleRange.min:n.visibleRange.min+t.offset:jQuery.type(f)=="date"?f.getTime():f,ej.util.isNullOrUndefined(e)||jQuery.type(e)!="date"||(e=e.getTime()),b&&!ej.util.isNullOrUndefined(a)&&o)for(y=ej.util.isNullOrUndefined(v)?e?e:n.visibleRange.max:v;f<y;)e=f+o,u=this._getVerticalValue(f,e,n,o,t),h&&this._drawAxisStriplines(u.x,u.y,u.height,u.width,u.textX,u.textY,l,i,c,r,s,t,n),c++,f=f+a;else u=this._getVerticalValue(f,e,n,o,t),h&&this._drawAxisStriplines(u.x,u.y,u.height,u.width,u.textX,u.textY,l,i,c,r,s,t,n)},_getHorizontalValue:function(n,t,i,r,u,f){var o=(f?(n-i.visibleRange.min)/i.visibleRange.delta:ej.EjSvgRender.utils._getPointXY(n,i.visibleRange,i.isInversed))*i.width+i.x,s=ej.EjSvgRender.utils._getPointXY(t,i.visibleRange,i.isInversed)*i.width+i.x,e=ej.EjSvgRender.utils._getPointXY(n,i.visibleRange,i.isInversed)*i.width+i.x,h;return e=e+(ej.util.isNullOrUndefined(r)?0:r),h=(i.isInversed?s<e:s>e)?Math.abs(o-s):Math.abs(o-e),this._calculateHorizontalStripline(h,o,i,u)},_getVerticalValue:function(n,t,i,r,u,f){var e=i.y+i.height-(f?(n-i.visibleRange.min)/i.visibleRange.delta:ej.EjSvgRender.utils._getPointXY(n,i.visibleRange,i.isInversed))*i.height,o=i.y+i.height-ej.EjSvgRender.utils._getPointXY(ej.util.isNullOrUndefined(t)?0:t,i.visibleRange,i.isInversed)*i.height,s=i.y+i.height-ej.EjSvgRender.utils._getPointXY(n+(ej.util.isNullOrUndefined(r)?0:r),i.visibleRange,i.isInversed)*i.height,h=(i.isInversed?o>s:o<s)?Math.abs(e-o):Math.abs(e-s);return this._calculateVerticalStripline(h,e,i,u)},_calculateHorizontalStripline:function(n,t,i,r){var o=n,u=this.chart.model.m_AreaBounds.Height,f=i.isInversed?t-n:t,e=this.chart.model.m_AreaBounds.Y,s=ej.EjSvgRender.utils._measureText(r.text,null,r.font).height;return r.textAlignment=="middletop"?(textX=f+s,textY=Math.abs(e+u/2)):r.textAlignment=="middlecenter"?(textX=Math.floor(f+o/2)+s/3,textY=Math.abs(e+u/2)):r.textAlignment=="middlebottom"&&(textX=f+o-s,textY=Math.abs(e+u/2)),{x:f,y:e,height:u,width:o,textX:textX,textY:textY}},_calculateVerticalStripline:function(n,t,i,r){var h=n,f=this.chart.model.m_AreaBounds.X,u=this.chart.model.m_AreaBounds.Width,e=t+(i.isInversed?0:-n),c=ej.EjSvgRender.utils._measureText(r.text,u,r.font).height,o,s;return r.textAlignment=="middletop"?(o=f+u/2,s=e+c):r.textAlignment=="middlecenter"?(o=f+u/2,s=Math.abs(e+h/2)+c/3):r.textAlignment=="middlebottom"&&(o=f+u/2,s=e+h-c),{x:f,y:e,height:h,width:u,textX:o,textY:s}},_getDatetimeValue:function(n,t,i,r,u,f,e){var h=f.sizeType.toLowerCase(),s=u===null,o;if(e==="datetime"){o=new Date(t);h==="auto"&&(h=r._intervalType.toLowerCase());switch(h){case"years":return s?new Date(o.setFullYear(o.getFullYear()+i)):n;case"months":return s?new Date(o.setMonth(o.getMonth()+i)):n;case"days":return s?new Date(o.setDate(o.getDate()+i)):n;case"hours":return s?new Date(o.setHours(o.getHours()+i)):n;case"minutes":return s?new Date(o.setMinutes(o.getMinutes()+i)):n;case"seconds":return s?new Date(o.setSeconds(o.getSeconds()+i)):n;default:return t}}else return f.sizeType==="pixel"?t:s?t+i:n},_drawAxisStriplines:function(n,t,i,r,u,f,e,o,s,h,c,l,a){var p,v,y;if(ej.util.isNullOrUndefined(l.imageUrl)){var w={id:c.id+"_striplineRect_"+o+"_"+h+"_"+s,x:n,y:t,width:r,height:i,fill:l.color,opacity:l.opacity,"stroke-width":l.borderWidth,stroke:l.borderWidth==0?"transparent":l.borderColor},b={id:c.id+"_striplineRectText_"+o+"_"+h+"_"+s,x:u,y:f,fill:l.font.color,transform:"rotate("+e+","+u+","+f+")",labelRotation:e,"font-size":l.font.size,"font-family":l.font.fontFamily,"font-style":l.font.fontStyle,"font-weight":l.font.fontWeight,opacity:l.font.opacity,"text-anchor":"middle"},k={X:n,Y:t,Width:r,Height:i},d=l.zIndex=="over"?!0:!1;ej.EjSvgRender.utils.AddRegion(this.chart,k,d);this.chart.model.enableCanvasRendering?(v=this.chart.svgObject.getContext("2d"),y=a.orientation.toLowerCase()=="horizontal"?{X:a.x,Y:t,Width:a.width,Height:this.chart.model.m_AreaBounds.Height}:{X:n,Y:a.y,Width:this.chart.model.m_AreaBounds.Width,Height:a.height},v.save(),v.beginPath(),v.rect(y.X,y.Y,y.Width,y.Height),v.clip(),this.svgRenderer.drawRect(w,c),this.svgRenderer.drawText(b,l.text,c),v.closePath(),v.restore()):(this.svgRenderer.drawRect(w,c),this.svgRenderer.drawText(b,l.text,c))}else p={height:i,width:r,href:l.imageUrl,x:n,y:t,id:c.id+"_backImage",visibility:"visible",preserveAspectRatio:"none"},this.svgRenderer.drawImage(p,c)}}}(jQuery);ej.EjLegendRender=function(n){this.chartObj=n},function(n){ej.EjLegendRender.prototype={sumofArray:function(n){for(var i=0,r=n.length,t=0;t<r;t++)i+=n[t];return i},legendRectSpace:function(n,t){var r=n.Width-10,u=n.Height-10,i=!1;return Math.ceil(t.Width)>=r&&Math.ceil(t.Height)>=u&&(i=!0),i},drawLegendTitle:function(){var f=this.chartObj,e=f.model,o=e.legend,s=o.isReversed,a=e.LegendBounds,v=e.elementSpacing,u=o.title,y=ej.EjSvgRender.utils._measureText,t=u.font,i=a.Width,h=y(u.text,null,t),r=h.width,p=h.height,c=u.textAlignment.toLowerCase(),n=0,w=v+p/2,l;switch(c){case"far":n=s?n:i-r-n;break;case"center":n=i/2-r/2}n<0&&(n=0,i=r);i<r+n&&(i=r+n);l={id:f.svgObject.id+"_LegendTitleText",x:s&&c=="near"?i-r-n:n,y:w,fill:t.color,"font-size":t.size,"font-style":t.fontStyle,"font-family":t.fontFamily,"font-weight":t.fontWeight,"text-anchor":"start",direction:"ltr",lgndCtx:!0};f.svgRenderer.drawText(l,u.text,this.chartObj.gLegendEle)},drawLegendItem:function(t,i,r){var f=this.chartObj,s=f.model,y=s.legend,w=y.isReversed,d=y.textOverflow.toLowerCase(),kt=y.textWidth,l=s.LegendBounds,p=s.elementSpacing,dt=y.border.width,ct=ej.EjSvgRender.utils._measureText,si=ej.EjSvgRender,g=f.svgRenderer,e=t.Font,hi=s.symbolShape,gt=s.enableCanvasRendering,nt=y.itemStyle,tt=t.PointIndex,lt=t.SeriesIndex,at=tt?tt:lt,it=s.series[lt],ci=f.svgObject,rt=t.LegendStyle,li=jQuery.uaMatch(navigator.userAgent),ai=!!navigator.userAgent.match(/Trident\/7\./),ni,a,ut,ti,vt,ft,h=it.type.toLowerCase(),ii=it.drawType,o,b,et,ot,yt,v,k,c,pt,wt,bt,ri,st,u,ht,ui,fi,ei,oi;if(v=ct(t.Text,l.Width,e).height,typeof t.Text=="object"&&w){for(pt=0,st=0;st<t.Text.length;st++)wt=t.Text[st],bt=ej.EjSvgRender.utils._measureText(wt,l.Width,e).width,pt<bt&&(pt=bt,ri=wt);k=ct(ri,null,e).width}else k=ct(t.Text,null,e).width;c={startX:w?k+i+p:i+nt.width/2,startY:r+(v>nt.height?v:nt.height)/2};for(ft in hi)if(t.Shape.toLowerCase()==ft.toLowerCase()){o=ft.toLowerCase()=="seriestype"?"SeriesType":ft;break}if(o=="SeriesType"&&((h=="radar"||h=="polar")&&(b=ii.toLowerCase()=="scatter"?it.marker.shape:b=ii,o=b.toLowerCase()=="rangecolumn"?"RangeColumn":b.capitalizeFirstString()),h=="scatter"&&(b=it.marker.shape,o=b.capitalizeFirstString()),t.drawType&&(o="SeriesType"),f.vmlRendering&&(h=="pie"||h=="doughnut"||h=="pieofpie")&&(o="Circle")),o=="None"&&(o=h=="pie"||h=="doughnut"||h=="pieofpie"?"Circle":"Rectangle"),at=ej.util.isNullOrUndefined(tt)?lt:tt,f.gLegendItemEle=g.createGroup({id:ci.id+"_Legend"+at,cursor:"pointer"}),t.CommonEventArgs.data.gLegendItemEle=f.gLegendItemEle,ut=n.extend(!0,{},t.CommonEventArgs.data),ut.model=f.model,ti=ut.style,!t.CommonEventArgs.cancel){if(vt=si.chartSymbol["_draw"+o](c,ti,ut,f.gLegendItemEle),ni=rt.Color&&rt.Color.toString().toLowerCase()!=="gray"&&gt?e.color:rt.Color&&rt.Color.toLowerCase()!=="gray"?e.color:"gray",a=t,yt=a.Text.length,(y.shape=="seriestype"||y.shape=="seriesType")&&(i=w?i-p/2:i+p/2),u={id:this.chartObj.svgObject.id+"_LegendItemText"+at,x:w?i:nt.width+i+p/2,y:c.startY,fill:ni,"font-size":e.size,"font-style":e.fontStyle,"font-family":e.fontFamily,"font-weight":e.fontWeight,"text-anchor":"start",direction:"ltr"},gt&&(u.lgndCtx=!0),u.y=c.startY+v/4,d=="wrap"||d=="wrapandtrim")for(u.y=u.y-v,ht=0;ht<yt;ht++)u.y=u.y+v,g.drawText(u,a.Text[ht],f.gLegendItemEle),d=="wrapandtrim"&&(et={x:u.x+l.X,y:u.y+l.Y,height:v*yt,width:kt},ot={bounds:et,trimText:a.Text,labelText:a.displayText},s.legendTextRegion.push(ot));else d=="trim"&&(et={x:u.x+l.X,y:u.y+l.Y,height:v+p,width:kt},ot={bounds:et,trimText:a.Text,labelText:a.displayText},s.legendTextRegion.push(ot)),g.drawText(u,a.Text,f.gLegendItemEle);g.append(f.gLegendItemEle,f.gLegendEle);ui={X:l.X+dt,Y:l.Y+dt};i=vt?w?c.startX-k-p:vt:i;fi={X:i,Y:r,_Width:t.Bounds._Width,Width:t.Bounds.Width,Height:t.Bounds.Height};ei={LegendBound:ui,ItemBound:fi};c.startX=w?Math.abs(c.startX-k-p/2):c.startX;oi={LegendItem:t,Location:c,SymbolShape:o,Style:t.CommonEventArgs.data.style,Bounds:ei};s.legendRegion.push(oi)}},drawLegend:function(t){var o=this.chartObj,u=o.model,e=u.legend,yt=e.isReversed,bi=u.LegendViewerBounds,i=u.LegendBounds,r=u.LegendActualBounds,ri=u.AreaType,l=e.position.toLowerCase(),pt=e.alignment.toLowerCase(),s=u.elementSpacing,ki=u.svgWidth,di=u.svgHeight,it=u.title,gi=it.font.size,nt=it.subTitle,nr=it.subTitle.font.size,ft=e.title,h=e.border.width,ui=ej.EjSvgRender.utils._measureText,fi=u.margin,p=u.border.width,y=u.legendCollection,wt=y.length,w=ki-p*2,tt=di-p*2,d=e.itemPadding>0?e.itemPadding:0,bt=10,et=10,tr=nt.text==""||!nt.visible||!it.visible?0:ui(nt.text,w-fi.left-fi.right,nt.font).height+s,ei=u._titleLocation?u._titleLocation.Y:0+tr,oi=ui(ft.text,null,ft.font),ot=oi.height,ir=oi.width,si=u._rowDefinitions,kt=0,hi,st,g,b,ht,ci,li=u._columnDefinitions,rr=this.sumofArray(si.farSizes),ur=this.sumofArray(si.nearSizes),cr=this.sumofArray(li.farSizes),fr=this.sumofArray(li.nearSizes),rt=!1,a=u.m_AreaBounds,ct=e.enableScrollbar,f=n(o.legendContainer),er=n("#ScrollerParent_vertical_"+o._id).length>0?18:0,or=n("#ScrollerParent_horizontal_"+o._id).length>0?18:0,sr=n(o.legendSvgContainer),ai=1.2,vi=10,dt=10,it=u.title,nt=u.title.subTitle,gt=it.visible?parseInt(gi)*ai:0,lt=nt.visible?parseInt(nr)*ai:0,gt=u.titleWrapTextCollection&&u.titleWrapTextCollection.length>1?u._titleLocation._height*u.titleWrapTextCollection.length-1:gt,lt=u.subTitleWrapTextCollection&&u.subTitleWrapTextCollection.length>1?u._subTitleLocation.size.height:lt,at,yi,ni,ti,c,ut;if(u.legend.border&&!nt.text&&(lt=0,dt=5),l=="right"||l=="left"?bt=10:et=ct?tt>200?10:tt>100?5:0:10,bi.Height+=ot,i.Height+=ot,e.visible){if(l!="custom"){if(ri=="cartesianaxes")switch(l){case"bottom":i.Y=a.Y+a.Height+fr-s/2+or;break;case"top":i.Y=ei==0?p+s:gt+vi+lt+dt+s;break;case"right":i.X=a.X+a.Width+rr+s*2;break;case"left":i.X=a.X-ur-r.Width-s/2-h*2-er}else switch(l){case"bottom":i.Y=tt-(r.Height+h)-s*2;break;case"top":i.Y=ei==0?p+s:gt+vi+lt+dt+s;break;case"right":i.X=w-r.Width-s*2;break;case"left":i.X=p+s*2}if(!u.enable3D&&ri=="cartesianaxes"&&t._crossAxisOverlap!=null)for(at=0,yi=u._axes.length;at<yi;at++){var v=u._axes[at],k=t.axes[v.name]._bounds,vt=v.orientation.toLowerCase()==="horizontal";l=="top"&&vt&&v._opposed&&v.y-k<i.Y+i.Height?i.Y-=i.Y+i.Height-v.y+k:l=="bottom"&&vt&&!v._opposed&&v.y+k>i.Y?i.Y+=v.y+k-i.Y:l=="left"&&!vt&&v._opposed&&v.x-k<i.X+i.Width?i.X+=v.x+k-i.X:l=="right"&&!vt&&!v._opposed&&v.x+k>i.X&&(i.X-=i.X+i.Width-v.x+k)}if(l=="left"||l=="right")if(ct)switch(pt){case"center":i.Y=a.Height/2-r.Height/2+a.Y-h;break;case"near":i.Y=a.Y;break;case"far":i.Y=a.Y+a.Height-r.Height-h*2}else switch(pt){case"center":i.Y=tt/2-(r.Height+h*2)/2+s/2;break;case"near":i.Y=p+s*2;break;case"far":i.Y=tt-(r.Height+h)-s*2}else switch(pt){case"center":i.X=w/2-(r.Width+h*2)/2+s/2;break;case"near":i.X=yt?w-(r.Width+h)-s*2:p+s*2;break;case"far":i.X=yt?p+s*2:w-(r.Width+h)-s*2}}else i.Y=e.location.y<tt?e.location.y:0,i.X=e.location.x<w?e.location.x:0;if(ct)if(l=="right"||l=="left"){if(i.Y<a.Y||r.Height+h*2>=a.Height)for(ni=h*2,c=0;c<wt;c++)if(ni+=y[c].Bounds.Height+d,ni>a.Height){r.Height=a.Height-h*2;i.Y=a.Y;break}}else if(h*2+r.Width>=w)for(ti=h*2,c=0;c<wt;c++)if(ti+=y[c].Bounds.Width+d,ti>w){r.Width=w-h*2-r.vScrollSize-p*2;i.X=w/2-(r.Width+h*2)/2+s/2;break}for(o.legendSvgContainer.setAttribute("height",i.Height),o.legendSvgContainer.setAttribute("width",Math.max(ir,i.Width)),g=hi=bt,b=st=et,ft.text!=""&&ft.text&&(this.drawLegendTitle(),b=st=et+ot),c=0;c<wt;c++)(e.rowCount<e.columnCount||e.rowCount==e.columnCount)&&(l=="top"||l=="bottom"||l=="custom")?(g+y[c].Bounds.Width>i.Width+hi&&(g=bt,b+=y[c].Bounds.Height+d),this.drawLegendItem(y[c],g,b),g+=y[c].Bounds.Width+d):(b+y[c].Bounds.Height+d+ot+p>i.Height+st&&(b=st,g+=kt+d),this.drawLegendItem(y[c],g,b),b+=y[c].Bounds.Height+d,kt=Math.max(kt,y[c].Bounds.Width));var pi=o.legendContainer[0].offsetLeft,wi=n(o.element).offset(),ii=o.vmlRendering?pi<=0?i.X:pi-wi.left:n(o.svgObject).offset().left-wi.left,hr=o.vmlRendering?ii:i.X+(ii<=0?0:ii);f.attr("style","");f.show();e._ejScroller||(yt?f.css({direction:"rtl"}):f.css({direction:"ltr"}));f.css({position:"absolute",background:e.background,left:hr,top:i.Y,width:r.Width,height:r.Height,"border-width":e.border.width,"border-color":e.border.color,"border-style":"solid"});f.addClass("e-legendborder");sr.css({height:i.Height,width:i.Width});i.Height=i.Height-(20-et*2);ut=this.legendRectSpace(i,r);ct&&(e._ejScroller?!ut&&(i.Width>Math.ceil(r.Width)||i.Height>Math.ceil(r.Height))?(n("#"+f[0].id).ejScroller({scrollTop:o.scrolltop,scrollLeft:o.scrollleft,height:r.Height,width:r.Width}),rt=!0,i.Height>Math.ceil(r.Height)&&r.vScrollSize==0&&(ht=f[0].offsetWidth+h*5-f[0].clientWidth,f.css({width:r.Width+ht}))):(n("#"+f[0].id).ejScroller("instance").destroy(),e._ejScroller=!1):!ut&&i.Width>Math.ceil(r.Width)&&i.Height>Math.ceil(r.Height)?(f.css({overflow:"scroll"}),rt=!0):(!ut&&i.Height>Math.ceil(r.Height)&&r.vScrollSize>=0&&(f[0].style.overflowY="scroll",f[0].style.overflowX="hidden",r.vScrollSize==0&&(ht=f[0].offsetWidth-h*2-f[0].clientWidth,f.css({width:r.Width+ht})),rt=!0),!ut&&i.Width>Math.ceil(r.Width)&&r.hScrollSize>=0&&(f[0].style.overflowX="scroll",f[0].style.overflowY="hidden",r.hScrollSize==0&&(ci=f[0].offsetHeight-h*2-f[0].clientHeight,f.css({height:r.Height+ci})),rt=!0)));o.svgRenderer.append(o.gLegendEle,o.legendSvgContainer);rt||f.css({width:r.Width-r.vScrollSize,height:r.Height-r.hScrollSize});e._ejScroller||(o.scrolltop!=undefined&&f.scrollTop(o.scrolltop),o.scrollleft!=undefined&&f.scrollLeft(o.scrollleft))}else f.hide()}}}(jQuery);ej.seriesTypes={};ej.EjSeriesRender=function(){};ej.indicatorTypes={};ej.EjIndicatorRender=function(){};ej.trendlineTypes={};ej.EjTrendLineRenderer=function(){},function(n){function t(t,i){var r=function(){};return r.prototype=new t,n.extend(r.prototype,i),r}ej.EjTrendLineRenderer.prototype={draw:function(t,i,r){var u,f;return this.chartObj=r,u=n.inArray(t,i.trendlines),t._isTransposed=r.model.requireInvertedAxes,t.xAxis=i.xAxis,t.yAxis=i.yAxis,f=t.type.toLowerCase(),t.points.length>1&&(f=="linear"||f=="movingaverage"?this.calculateLineDirection(t,i,u):this.calculateSplineDirection(t,i,u)),!1},calculateSplineDirection:function(n,t,i){for(var a="",h=ej.EjSvgRender.utils._getStringBuilder(),v=!0,c=n.points,y=ej.EjSeriesRender.prototype.naturalSpline(c,t),r=null,u=null,p=-1,l,g=c.length,f=0;f<g;f++){if(l=f,u=c[f],r!=null){var w=null,b=null,k=ej.EjSeriesRender.prototype.getBezierControlPoints(r,u,y[p],y[l],0,t,this);w=k.controlPoint1;b=k.controlPoint2;var d=ej.EjSvgRender.utils._getPoint(r,n),e=ej.EjSvgRender.utils._getPoint(u,n),o=ej.EjSvgRender.utils._getPoint(w,n),s=ej.EjSvgRender.utils._getPoint(b,n),nt=this.chartObj;v?(h.append("M "+d.X+" "+d.Y+" C "+o.X+" "+o.Y+" "+s.X+" "+s.Y+" "+e.X+" "+e.Y+" "),v=!1):h.append("C "+o.X+" "+o.Y+" "+s.X+" "+s.Y+" "+e.X+" "+e.Y+" ")}r=u;p=l}return a=h.toString(),this._drawLinePath(n,t,a,i),!1},calculateLineDirection:function(n,t,i){for(var r,e,u=ej.EjSvgRender.utils._getStringBuilder(),o=!1,s,h=n.points.length,f=0;f<h;f++)s=n.points[f],r=ej.EjSvgRender.utils._getPoint(s,n),o?u.append("L "+r.X+" "+r.Y+" "):(u.append("M "+r.X+" "+r.Y+" "),u.append("L "+r.X+" "+r.Y+" "),o=!0);return e=u.toString(),this._drawLinePath(n,t,e,i),!1},_drawLinePath:function(n,t,i,r){var u=[],f;return u[0]=n.xAxis.x,u[1]=n.yAxis.y,i!=""&&(f={id:this.chartObj.svgObject.id+"_"+n.seriesIndex+"_"+r+"_"+n.name.replace(/[^a-zA-Z ]/g,""),fill:"none","stroke-dasharray":n.dashArray,"stroke-width":n.width,stroke:n.fill,opacity:n.opacity,d:i},n.id=f.id,this.chartObj.svgRenderer.drawPath(f,t.gTrendGroupEle,u)),this.chartObj.svgRenderer.append(t.gTrendGroupEle,this.chartObj.gTrendlinesGroupEle[n.seriesIndex]),!1},calculateTrendLineSegment:function(t,i,r,u){var o=u.model,r,f=n.extend([],t.points),s=i.type.toLowerCase(),e;i.xAxis=t.xAxis?t.xAxis:o.primaryXAxis;i.yAxis=t.yAxis?t.yAxis:o.primaryYAxis;i.backwardForecast=i.backwardForecast<0?0:i.backwardForecast;i.forwardForecast=i.forwardForecast<0?0:i.forwardForecast;f=f.sort(function(n,t){return n.xValue>t.xValue?1:t.xValue>n.xValue?-1:0});switch(s){case"linear":this.updateTrendSource(f,i);this.calculateLinearTrendline(t,i,r);break;case"exponential":this.updateExponentialTrendSource(f,i);this.calculateExponentialTrendline(t,i,r);break;case"logarithmic":this.updateLogarithmicTrendSource(f,i);this.calculateLogarithmicTrendline(t,i,r);break;case"power":this.updatePowerTrendSource(f,i);this.calculatePowerTrendline(t,i,r);break;case"polynomial":e=t.points.length;i.polynomialOrder=e<=i.polynomialOrder?e:i.polynomialOrder;i.polynomialOrder=i.polynomialOrder<2?2:i.polynomialOrder;i.polynomialOrder=i.polynomialOrder>6?6:i.polynomialOrder;e>1&&(this.updateTrendSource(f,i),this.calculatePolynomialTrendline(t,i,r));break;case"movingaverage":this.updateMovingAverageTrendSource(f,i);this.calculateMovingAverageTrendline(t,i,r)}return t.points.length>1&&i.points&&this.calculateTrendLineRange(i,r),!1},updateTrendSource:function(n,t){var f=n.length,i,u,r;for(t.xPoints=[],t.xValues=[],t.yValues=[],r=0;r<f;r++)i=n[r],i.isEmpty||ej.isNullOrUndefined(i.y)||(t.xPoints.push(i.xValue),u=typeof i.xValue=="number"?i.xValue:Date.parse(i.xValue),t.xValues.push(u),t.yValues.push(i.y));return this.calculateSumXAndYValue(t),!1},calculateLinearTrendline:function(n,t,i){var f=t.xValues.length,r,u,e,o;return t.points=[],f>1&&(i._valueType.toLowerCase()=="datetime"?(r=this._increaseDateTimeInterval(t.xPoints[0],-t.backwardForecast,i._intervalType),u=this._increaseDateTimeInterval(t.xPoints[f-1],t.forwardForecast,i._intervalType)):(r=t.xPoints[0]-t.backwardForecast,u=t.xPoints[f-1]+t.forwardForecast),e=t.slope*r+t._intercept,o=t.slope*u+t._intercept,t.points.push({x:r,xValue:r,y:e,YValues:[],visible:!0}),t.points.push({x:u,xValue:u,y:o,YValues:[],visible:!0}),t.points[0].YValues[0]=t.points[0].y,t.points[1].YValues[0]=t.points[1].y),!1},calculateTrendLineRange:function(n,t){var i=n.points.length,u,r;for(n.minY=n.points[0].y,n.maxY=n.points[i-1].y,t.setRange||(n.backwardForecast>0&&t._valueType!="category"&&i>1&&(t.range.min=t.range.min>n.points[0].x?n.points[0].x:t.range.min,t.visibleRange.min=t.range.min),n.forwardForecast>0&&i>1&&(t.range.max=t.range.max<n.points[i-1].x?n.points[i-1].x:t.range.max,t.visibleRange.max=t.range.max)),r=0;r<i;r++)u=n.points[r].y,n.minY=Math.min(n.minY,u),n.maxY=Math.max(n.maxY,u);return!1},calculateSumXAndYValue:function(n){for(var y=n.points,e=n.xPoints.length,u=n.type.toLowerCase(),r,a,i=0,o=0,f=0,l=0,v=0,s=0,h=n.xValues,c=n.yValues,t=0;t<e;t++)i=i+h[t],o=o+c[t],s=s+h[t]*c[t],l=l+h[t]*c[t],f=f+h[t]*h[t],v=v+c[t]*c[t];if(ej.util.isNullOrUndefined(n.intercept)||u!="linear"&&u!="exponential"&&u!="polynomial")r=(e*l-i*o)/(e*f-i*i),a=u=="exponential"||u=="power"?Math.exp((o-r*i)/e):(o-r*i)/e,n._intercept=a;else{switch(u){case"polynomial":r=(s-Math.log(n.intercept)*i)/f*3;break;case"linear":r=(s-n.intercept*i)/f;break;case"exponential":r=(s-Math.log(n.intercept)*i)/f}n._intercept=n.intercept}return n.slope=r,!1},_increaseDateTimeInterval:function(n,t,i){var r=new Date(n);return n=typeof n=="object"?n:r,i.toLowerCase()=="days"?r.setDate(n.getDate()+t):i.toLowerCase()=="hours"?r.setHours(n.getHours()+t):i.toLowerCase()=="milliseconds"?r.setMilliseconds(n.getMilliseconds()+t):i.toLowerCase()=="seconds"?r.setSeconds(n.getSeconds()+t):i.toLowerCase()=="minutes"?r.setMinutes(n.getMinutes()+t):i.toLowerCase()=="months"?r.setMonth(n.getMonth()+t):i.toLowerCase()=="years"&&r.setYear(n.getFullYear()+t),r}};ej.ejLinear=t(ej.EjTrendLineRenderer);ej.trendlineTypes.linear=ej.ejLinear;ej.Exponential=t(ej.EjTrendLineRenderer,{updateExponentialTrendSource:function(n,t){var f=n.length,i,u,r;for(t.xPoints=[],t.xValues=[],t.yValues=[],r=0;r<f;r++)i=n[r],i.isEmpty||ej.isNullOrUndefined(i.y)||(t.xPoints.push(i.xValue),u=typeof i.xValue=="number"?i.xValue:Date.parse(i.xValue),t.xValues.push(u),t.yValues.push(Math.log(i.y)));return this.calculateSumXAndYValue(t),!1},calculateExponentialTrendline:function(n,t,i){var e=t.xValues.length,r,u,f,o,s,h,c=Math.round(e/2);if(t.points=[],e>1){i._valueType.toLowerCase()=="datetime"?(r=this._increaseDateTimeInterval(t.xPoints[0],-t.backwardForecast,i._intervalType),o=r.getTime(),u=t.xPoints[c-1],s=new Date(u).getTime(),f=this._increaseDateTimeInterval(t.xPoints[e-1],t.forwardForecast,i._intervalType),h=f.getTime()):(r=o=t.xPoints[0]-t.backwardForecast,u=s=t.xPoints[c-1],f=h=t.xPoints[e-1]+t.forwardForecast);var l=t._intercept*Math.exp(t.slope*r),a=t._intercept*Math.exp(t.slope*u),v=t._intercept*Math.exp(t.slope*f);t.points.push({x:r,xValue:o,y:l,YValues:[],visible:!0});t.points.push({x:u,xValue:s,y:a,YValues:[],visible:!0});t.points.push({x:f,xValue:h,y:v,YValues:[],visible:!0});t.points[0].YValues[0]=t.points[0].y;t.points[1].YValues[0]=t.points[1].y;t.points[2].YValues[0]=t.points[2].y}return!1}});ej.trendlineTypes.exponential=ej.Exponential;ej.Logarithmic=t(ej.EjTrendLineRenderer,{updateLogarithmicTrendSource:function(n,t){var e=n.length,i,r,u,f;for(t.xPoints=[],t.xValues=[],t.yValues=[],u=0;u<e;u++)i=n[u],i.isEmpty||ej.isNullOrUndefined(i.y)||(t.xPoints.push(i.xValue),r=typeof i.xValue=="number"?i.xValue:Date.parse(i.xValue),f=isFinite(Math.log(r))?Math.log(r):r,t.xValues.push(f),t.yValues.push(i.y));return this.calculateSumXAndYValue(t),!1},calculateLogarithmicTrendline:function(n,t,i){var e=t.xValues.length,r,u,f,o,s,h,c=Math.round(e/2);if(t.points=[],e>1){i._valueType.toLowerCase()=="datetime"?(r=this._increaseDateTimeInterval(t.xPoints[0],-t.backwardForecast,i._intervalType),o=r.getTime(),u=t.xPoints[c-1],s=new Date(u).getTime(),f=this._increaseDateTimeInterval(t.xPoints[e-1],t.forwardForecast,i._intervalType),h=f.getTime()):(r=o=t.xPoints[0]-t.backwardForecast,u=s=t.xPoints[c-1],f=h=t.xPoints[e-1]+t.forwardForecast);var l=t._intercept+t.slope*(isFinite(Math.log(r))?Math.log(r):r),a=t._intercept+t.slope*(isFinite(Math.log(u))?Math.log(u):u),v=t._intercept+t.slope*(isFinite(Math.log(f))?Math.log(f):f);t.points.push({x:r,xValue:o,y:l,YValues:[],visible:!0});t.points.push({x:u,xValue:s,y:a,YValues:[],visible:!0});t.points.push({x:f,xValue:h,y:v,YValues:[],visible:!0});t.points[0].YValues[0]=t.points[0].y;t.points[1].YValues[0]=t.points[1].y;t.points[2].YValues[0]=t.points[2].y}return!1}});ej.trendlineTypes.logarithmic=ej.Logarithmic;ej.Power=t(ej.EjTrendLineRenderer,{updatePowerTrendSource:function(n,t){var f=n.length,i,u,r;for(t.xPoints=[],t.xValues=[],t.yValues=[],r=0;r<f;r++)i=n[r],i.isEmpty||(t.xPoints.push(i.xValue),u=typeof i.xValue=="number"?i.xValue:Date.parse(i.xValue),t.xValues.push(Math.log(u)),t.yValues.push(Math.log(i.y)));return this.calculateSumXAndYValue(t),!1},calculatePowerTrendline:function(n,t,i){var e=t.xValues.length,r,u,f,o,s,h,l=Math.round(e/2),c;if(t.points=[],e>1){i._valueType.toLowerCase()=="datetime"?(r=this._increaseDateTimeInterval(t.xPoints[0],-t.backwardForecast,i._intervalType),o=r.getTime(),u=t.xPoints[l-1],s=new Date(u).getTime(),f=this._increaseDateTimeInterval(t.xPoints[e-1],t.forwardForecast,i._intervalType),h=f.getTime()):(c=t.xPoints[0]-t.backwardForecast,r=o=c>-1?c:0,u=s=t.xPoints[l-1],f=h=t.xPoints[e-1]+t.forwardForecast);var a=t._intercept*Math.pow(r,t.slope),v=t._intercept*Math.pow(u,t.slope),y=t._intercept*Math.pow(f,t.slope);t.points.push({x:r,xValue:o,y:a,YValues:[],visible:!0});t.points.push({x:u,xValue:s,y:v,YValues:[],visible:!0});t.points.push({x:f,xValue:h,y:y,YValues:[],visible:!0});t.points[0].YValues[0]=t.points[0].y;t.points[1].YValues[0]=t.points[1].y;t.points[2].YValues[0]=t.points[2].y}return!1}});ej.trendlineTypes.power=ej.Power;ej.Polynomial=t(ej.EjTrendLineRenderer,{calculatePolynomialTrendline:function(n,t,i){var f=t.polynomialOrder,c,l,e,s,h,a,o,v,u,r;for(t.polynomialSlopes=new Array(f+1),c=t.xValues.length,u=0;u<c;u++)for(o=t.xValues[u],l=t.yValues[u],r=0;r<=f;++r)t.polynomialSlopes[r]||(t.polynomialSlopes[r]=0),t.polynomialSlopes[r]+=Math.pow(o,r)*l;for(e=new Array(1+2*f),s=new Array(f+1),h=0;h<f+1;h++)s[h]=new Array(3);for(a=0,u=0;u<c;++u)for(o=1,v=t.xValues[u],r=0;r<e.length;++r)e[r]||(e[r]=0),e[r]+=o,o*=v,++a;for(u=0;u<=f;++u)for(r=0;r<=f;++r)s[u][r]=e[u+r];return this.gaussJordanEliminiation(s,t.polynomialSlopes)||(t.polynomialSlopes=null),this.createPolynomialSegments(n,i,t),!1},createPolynomialSegments:function(n,t,i){var f=i.polynomialSlopes,e,u,c;if(f!=null){var o=i.xValues.length,a=Math.round(o/2),s=1,r,l=f.length,h=t._valueType.toLowerCase();for(i.points=[],e=1;e<=l;e++)e==1?(h=="datetime"?(u=this._increaseDateTimeInterval(i.xPoints[0],-i.backwardForecast,t._intervalType),r=u.getTime()):u=r=i.xPoints[0]-i.backwardForecast,c=this.getPolynomialYValue(f,r)):e==f.length?(h=="datetime"?(u=this._increaseDateTimeInterval(i.xPoints[o-1],i.forwardForecast,t._intervalType),r=u.getTime()):u=r=i.xPoints[o-1]+i.forwardForecast,c=this.getPolynomialYValue(f,r)):(s+=(o+i.forwardForecast)/f.length,h=="category"?u=r=i.xPoints[0]+(s-1):(u=r=i.xPoints[parseInt(s)-1],h=="datetime"&&o>s&&(r=new Date(u).getTime())),c=this.getPolynomialYValue(f,r)),(e==1||e==f.length||h=="category"||o>s)&&(i.points.push({x:u,xValue:r,y:c,YValues:[],visible:!0}),i.points[i.points.length-1].YValues[0]=i.points[i.points.length-1].y)}return!1},getPolynomialYValue:function(n,t){for(var r=0,i=0;i<n.length;i++)r+=n[i]*Math.pow(t,i);return r},gaussJordanEliminiation:function(n,t){for(var p,v,i,s,o,u,f,w,e=n.length,h=new Array(e),c=new Array(e),l=new Array(e),a=0;a<e;++a)l[a]=0;for(u=0;u<e;++u){var y=0,f=0,r=0;for(i=0;i<e;++i)if(l[i]!=1)for(o=0;o<e;++o)l[o]==0&&Math.abs(n[i][o])>=y&&(y=Math.abs(n[i][o]),f=i,r=o);if(++l[r],f!=r){for(i=0;i<e;++i)s=n[(f,i)],n[f][i]=n[r][i],n[r][i]=s;p=t[f];t[f]=t[r];t[r]=p}if(c[u]=f,h[u]=r,n[r][r]==0)return!1;for(v=1/n[r][r],n[r][r]=1,i=0;i<e;++i)n[r][i]*=v;for(t[r]*=v,i=0;i<e;++i)if(i!=r){for(s=n[i][r],n[i][r]=0,o=0;o<e;++o)n[i][o]-=n[r][o]*s;t[i]-=t[r]*s}}for(u=e-1;u>=0;--u)if(c[u]!=h[u])for(f=0;f<e;++f)w=n[(f,c[u])],n[f][c[u]]=n[f][h[u]],n[f][h[u]]=w;return!0}});ej.trendlineTypes.polynomial=ej.Polynomial;ej.MovingAverage=t(ej.EjTrendLineRenderer,{updateMovingAverageTrendSource:function(n,t){var u=n.length,i,r;for(t.xPoints=[],t.xValues=[],t.yValues=[],i=0;i<u;i++)t.xPoints.push(n[i].xValue),t.xValues.push(i+1),r=n[i].isEmpty?null:n[i].y,t.yValues.push(r);return!1},calculateMovingAverageTrendline:function(n,t){var o=t.xPoints.length,i=t.period>=o?o-1:t.period,u,f,r,s,e,h,c;for(i=i<2?2:i,t.points=[],u=0;u<o-1;u++){for(r=s=e=0,f=u;s<i;f++)s++,ej.util.isNullOrUndefined(t.yValues[f])&&e++,r+=t.yValues[f];r=i-e<=0?null:r/(i-e);ej.util.isNullOrUndefined(r)||isNaN(r)||(h=t.xPoints[i-1+u],t.points.push({x:h,xValue:h,y:r,YValues:[],visible:!0}),c=t.points.length,t.points[c-1].YValues[0]=t.points[c-1].y)}}});ej.trendlineTypes.movingaverage=ej.MovingAverage;ej.EjIndicatorRender.prototype={draw:function(t,i){var f,s,h,e,c,u,r,o;if(this.chartObj=i,f=null,this.chartObj.model.AreaType=="cartesianaxes"&&(s=t.xAxis.x,h=t.yAxis.y,f="translate("+s+","+h+")"),e=n.inArray(t,this.chartObj.model.indicators),c={id:this.chartObj.svgObject.id+"_indicatorGroup_"+e,transform:f},this.gIndicatorGroupEle=this.chartObj.svgRenderer.createGroup(c),t._points.length>0)for(u=0;u<t.segment.length;u++)r=t.segment[u],o={fill:r.fill,width:r.width,opacity:t.opacity},r.isIndicator=!0,r.xAxis=t.xAxis,r.yAxis=t.yAxis,r.type=="line"?this.calculateDirection(r,o,e):this.drawColumn(r,o,t)},_drawLinePath:function(n,t,i,r){if(i!=""){var u={name:"line",id:this.chartObj.svgObject.id+"_"+r+"_"+n.name,fill:"none","stroke-dasharray":n.dashArray,"stroke-width":t.width,stroke:t.fill,"stroke-linecap":n.lineCap,"stroke-linejoin":n.lineJoin,opacity:t.opacity,d:i};this.chartObj.svgRenderer.drawPath(u,this.gIndicatorGroupEle)}this.chartObj.svgRenderer.append(this.gIndicatorGroupEle,this.chartObj.gIndicatorEle)},calculateDirection:function(n,t,i){var f=0,e=0,r,u;this.chartObj.model.enableCanvasRendering&&(f=n.xAxis.x,e=n.yAxis.y);n.points=ej.DataManager(n.points,ej.Query().sortBy("xValue")).executeLocal();var c=ej.EjSeriesRender.prototype._isVisiblePoints(n),l,o=ej.EjSvgRender.utils._getStringBuilder(),s=!1,h;for(u=0;u<c.length;u++)h=c[u],h.visible?(r=ej.EjSvgRender.utils._getPoint(h,n),s?o.append("L "+(r.X+f)+" "+(r.Y+e)+" "):(o.append("M "+(r.X+f)+" "+(r.Y+e)+" "),s=!0)):s=!1;l=o.toString();this._drawLinePath(n,t,l,i)},drawColumn:function(t,i,r){var f=t,l=n.inArray(r,this.chartObj.model.indicators),e,y,p,c;f.index=l;var w=Math.max(t.yAxis.visibleRange.min,0),b={Start:-.35,End:.35},o=ej.EjSeriesRender.prototype._isVisiblePoints(f),s=this,k=s.chartObj;for(e=0;e<o.length;e++){var d=e,h=o[e],a=h.YValues[0],g=w;if(h.visible){var v=ej.EjSeriesRender.prototype.calculateSides(h,b),nt=v.x1,tt=v.x2,u=ej.EjSeriesRender.prototype.getRectangle(nt,a,tt,g,f,k),it=Math.min(0,u.Width),rt=Math.min(0,u.Height);u.Width<.0001&&(u.Width=.0001);(it==0||rt==0)&&u.Width>0&&(p={id:this.chartObj.svgObject.id+"_"+l+"_"+f.name,x:u.X+s.chartObj.canvasX,y:u.Y+s.chartObj.canvasY,width:u.Width,height:u.Height,fill:o[e].fill?o[e].fill:i.fill,"stroke-width":f.border.width,plot:a<0?"negative":"positive",opacity:f.histogram.opacity,stroke:o[e].fill?o[e].fill:f.border.color},this.chartObj.svgRenderer.drawRect(p,this.gIndicatorGroupEle),c=ej.EjSvgRender.utils._getSvgXY(u.X,u.Y,f,s.chartObj),y={X:c.X,Y:c.Y,Width:u.Width,Height:u.Height},this._addRegion(s.chartObj,y,f,h,d))}}this.chartObj.svgRenderer.append(this.gIndicatorGroupEle,this.chartObj.gIndicatorEle)},_addRegion:function(n,t,i,r,u){var e=i.type,f;i.index>=0&&(f={SeriesIndex:i.index,Region:{PointIndex:u,Bounds:t},type:e,isIndicator:!0},n.model.chartRegions.push(f))},calculateSegment:function(t,i){var o,v,b,y,a,p,s,w,e,l;if(this.chartObj=i,t.segment=[],t.xRange={},t.yRange={},t.period=parseInt(t.period),t.period<t._points.length&&t.period>0){for(o=n.extend(!0,{},t),o.name="upperseries",o.fill=t.upperLine.fill,o.width=t.upperLine.width,o.type="line",v=0;v<t._points.length;v++)t._points[v].YValues.length=1,t._points[v].YValues[0]=t._points[v].y=70;for(o.points=n.extend(!0,[],t._points),b=i._getXValues(o.points),y=i._getYValues(o.points),t.xRange.min=Math.min.apply(Math,b),t.xRange.max=Math.max.apply(Math,b),t.yRange.min=Math.min.apply(Math,y),t.yRange.max=Math.max.apply(Math,y),t.segment.push(o),a=n.extend(!0,{},t),a.name="lowerSeries",a.width=t.lowerLine.width,a.fill=t.lowerLine.fill,a.type="line",p=0;p<t._points.length;p++)t._points[p].YValues[0]=t._points[p].y=30;a.points=n.extend(!0,[],t._points);y=i._getYValues(a.points);t.yRange.min=Math.min(Math.min.apply(Math,y),t.yRange.min);t.yRange.max=Math.max(Math.max.apply(Math,y),t.yRange.max);t.segment.push(a);s=n.extend(!0,{},t);s.name="signalSeries";s.width=t.width;s.fill=t.fill;s.type="line";var u=0,f=0,h=0,c=0,r=t.period;for(f=t._points[0].close,e=1;e<=r;++e)u=t._points[e].close,u>f?h+=u-f:u<f&&(c+=f-u),f=u,t._points[e-1].YValues[0]=t._points[e-1].y=null;for(h=h/r,c=c/r,t._points[r].YValues[0]=t._points[r].y=100-100/(1+h/c),l=r+1;l<t._points.length;l++)u=t._points[l].close,u>f?(h=(h*(r-1)+(u-f))/r,c=c*(r-1)/r):u<f&&(c=(c*(r-1)+(f-u))/r,h=h*(r-1)/r),f=u,t._points[l].YValues[0]=t._points[l].y=100-100/(1+h/c);for(s.points=n.extend(!0,[],t._points),w=[],e=r,l=0;e<s.points.length;e++,l++)w[l]=s.points[e].y;t.yRange.min=Math.min(Math.min.apply(Math,w),t.yRange.min);t.yRange.max=Math.max(Math.max.apply(Math,w),t.yRange.max);t.segment.push(s);this.calculateIndicatorRange(i,t)}},calculateIndicatorRange:function(n,t){n.model.indicatorRange[t.xAxisName]==undefined?(n.model.indicatorRange[t.xAxisName]={},n.model.indicatorRange[t.xAxisName]={min:t.xRange.min,max:t.xRange.max}):(n.model.indicatorRange[t.xAxisName].min>t.xRange.min&&(n.model.indicatorRange[t.xAxisName].min=t.xRange.min),n.model.indicatorRange[t.xAxisName].max<t.xRange.max&&(n.model.indicatorRange[t.xAxisName].max=t.xRange.max));n.model.indicatorRange[t.yAxisName]===undefined?(n.model.indicatorRange[t.yAxisName]={},n.model.indicatorRange[t.yAxisName]={min:t.yRange.min,max:t.yRange.max}):(n.model.indicatorRange[t.yAxisName].min>t.yRange.min&&(n.model.indicatorRange[t.yAxisName].min=t.yRange.min),n.model.indicatorRange[t.yAxisName].max<t.yRange.max&&(n.model.indicatorRange[t.yAxisName].max=t.yRange.max))}};ej.ejRSI=t(ej.EjIndicatorRender);ej.indicatorTypes.rsi=ej.ejRSI;ej.ejMACD=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){var f,o,y,r,e,u,l,h,it,b,k,p,w;this.chartObj=i;t.segment=[];t.xRange={};t.yRange={};var d=t._points.length,a=t.longPeriod,g=t.shortPeriod,nt=t.trigger,ft=a-g,rt=[],tt=[],s=[],c=[],v=[],ut=a+nt;if(ut<=t._points.length&&ut-2>=0&&g<=a&&g>0){for(rt=this.calculateEMA(t._points,g,!0),tt=this.calculateEMA(t._points,a,!0),e=0;e<tt.length;e++)s.push(rt[e+ft]-tt[e]);for(f=n.extend(!0,{},t),f.name="macdSeries",f.fill=t.macdLine.fill,f.width=t.macdLine.width,f.type="line",f.xAxis=t.xAxis,f.yAxis=t.yAxis,y=a-1,r=0,e=0;r<d;r++)r<y?t._points[r].YValues[0]=t._points[r].y=null:(t._points[r].YValues[0]=t._points[r].y=s[e],e+=1);for(f.points=n.extend(!0,[],t._points),c=this.calculateEMA(s,nt,!1),o=n.extend(!0,{},t),o.name="signalSeries",o.fill=t.fill,o.width=t.width,o.type="line",o.xAxis=t.xAxis,o.yAxis=t.yAxis,y=a+nt-2,r=0,e=0;r<d;r++)r<y?t._points[r].YValues[0]=t._points[r].y=null:(t._points[r].YValues[0]=t._points[r].y=c[e],e+=1);for(o.points=n.extend(!0,[],t._points),u=n.extend(!0,{},t),u.border={},u.name="histogramSeries",u.fill=t.histogram.fill,u.opacity=t.histogram.opacity,u.fill=t.histogram.fill,u.border=t.histogram.border,u.type="column",u.xAxis=t.xAxis,u.yAxis=t.yAxis,l=0,h=y;h<d;l++,h++)v.push(s[l+(nt-1)]-c[l]);for(l=0,h=y;h<d;l++,h++)t._points[h].YValues[0]=t._points[h].y=v[l];u.points=n.extend(!0,[],t._points);it=i._getXValues(f.points);t.xRange.min=Math.min.apply(Math,it);t.xRange.max=Math.max.apply(Math,it);switch(t.macdType){case"line":t.yRange.min=Math.min.apply(Math,s);t.yRange.max=Math.max.apply(Math,s);t.segment.push(f);p=Math.min.apply(Math,c);w=Math.max.apply(Math,c);t.yRange.min=t.yRange.min<p?t.yRange.min:p;t.yRange.max=t.yRange.max>w?t.yRange.max:w;t.segment.push(o);break;case"histogram":b=Math.min.apply(Math,v);k=Math.max.apply(Math,v);t.yRange.min=t.yRange.min<b?t.yRange.min:b;t.yRange.max=t.yRange.max>k?t.yRange.max:k;t.segment.push(u);break;case"both":b=Math.min.apply(Math,v);k=Math.max.apply(Math,v);t.yRange.min=t.yRange.min<b?t.yRange.min:b;t.yRange.max=t.yRange.max>k?t.yRange.max:k;t.segment.push(u);t.yRange.min=Math.min.apply(Math,s);t.yRange.max=Math.max.apply(Math,s);t.segment.push(f);p=Math.min.apply(Math,c);w=Math.max.apply(Math,c);t.yRange.min=t.yRange.min<p?t.yRange.min:p;t.yRange.max=t.yRange.max>w?t.yRange.max:w;t.segment.push(o)}this.calculateIndicatorRange(i,t)}},calculateEMA:function(n,t,i){var e=0,o=0,c=n.length,h=[],s=[],l=2/(t+1),r,u,f;if(i){for(r=0;r<t;r++)h.push(n[r].close),e=e+h[r];for(o=e/t,s.push(o),u=o,f=t;f<c;f++)u=(n[f].close-u)*l+u,s.push(u)}else{for(r=0;r<t;r++)h.push(n[r]),e=e+h[r];for(o=e/t,s.push(o),u=o,f=t;f<c;f++)u=(n[f]-u)*l+u,s.push(u)}return s}});ej.indicatorTypes.macd=ej.ejMACD;ej.ejSMA=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){var r,v,e,l,f,o;this.chartObj=i;t.segment=[];t.xRange={};t.yRange={};r=n.extend(!0,{},t);r.name="trendSeries";r.width=t.width;r.fill=t.fill;r.type="line";var h=[],y=[],c=[],s,l,a=t._points.length,u=t.period;if(!(u<=0)&&!(a<u)){for(f=0;f<a;f++)h.push(t._points[f].close);for(v=h.length;v>=u;){for(s=0,o=0;o<u;o++)s=s+h[o];s=s/u;y.push(s);h.splice(0,1);v=h.length}for(e=0;e<a;e++)t._points[e].YValues[0]=e<u-1?t._points[e].y=null:t._points[e].y=y[e-(u-1)];for(r.points=n.extend(!0,[],t._points),l=i._getXValues(r.points),f=u-1,o=0;f<r.points.length;f++,o++)c[o]=r.points[f].y;t.xRange.min=Math.min.apply(Math,l);t.xRange.max=Math.max.apply(Math,l);t.yRange.min=Math.min.apply(Math,c);t.yRange.max=Math.max.apply(Math,c);t.segment.push(r);this.calculateIndicatorRange(i,t)}}});ej.indicatorTypes.sma=ej.ejSMA;ej.ejEMA=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){var u,y,f,h,e,o;this.chartObj=i;t.segment=[];t.xRange={};t.yRange={};u=n.extend(!0,{},t);u.name="trendSeries";u.type="line";u.xAxis=t.xAxis;u.yAxis=t.yAxis;var v=[],s=[],c=t._points.length,r=t.period,l=0,a;if(!(c<r)&&!(r<=0)){for(y=2/(r+1),e=0;e<r;e++)v.push(t._points[e].close),l=l+v[e];for(s.push(l/r),o=r;o<c;o++)s.push((t._points[o].close-s[o-r])*y+s[o-r]);for(f=0;f<c;f++)f<r-1?t._points[f].YValues[0]=t._points[f].y=null:f>=r-1&&(t._points[f].YValues[0]=t._points[f].y=s[f-(r-1)]);for(u.points=n.extend(!0,[],t._points),a=i._getXValues(u.points),h=[],e=r,o=0;e<u.points.length;e++,o++)h[o]=u.points[e].y;t.xRange.min=Math.min.apply(Math,a);t.xRange.max=Math.max.apply(Math,a);t.yRange.min=Math.min.apply(Math,h);t.yRange.max=Math.max.apply(Math,h);t.segment.push(u);this.calculateIndicatorRange(i,t)}}});ej.indicatorTypes.ema=ej.ejEMA;ej.ejSTOCHASTIC=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){function d(n,i,r){t._points.length>=n+i&&g(n,i,r)}function g(n,i,r){for(var v,h,o,c,u,l=n+(i-1),e=[],a=[],f,s=0;s<t._points.length;s++)v=p[s].y,e.push(v);for(h=e.length;h>=l;){for(f=0,o=n-1;o<n+i-1;o++)f=f+e[o];f=f/i;a.push(f.toFixed(2));e.splice(0,1);h=e.length}for(c=l-1,u=0;u<t._points.length;u++)r[u].YValues[0]=u<c?r[u].y=null:r[u].y=Number(a[u-c])}function nt(n,i,r){t._points.length>n&&tt(n,i,r)}function tt(n,i,r){for(var f,a=n+i,e=[],h=[],o,s,c=0,l=0,u=0;u<n-1;++u)h.push(0),e.push(0);for(u=n-1;u<t._points.length;++u){for(s=Number.MAX_VALUE,o=Number.MIN_VALUE,f=0;f<n;++f)s=Math.min(s,b[u-f]),o=Math.max(o,w[u-f]);h.push(o);e.push(s)}for(u=0;u<a-1;++u)r[u].YValues.length=1,r[u].YValues[0]=r[u].y=null;for(u=n-1;u<t._points.length;++u)c=0,l=0,c+=k[u]-e[u],l+=h[u]-e[u],r[u].YValues.length=1,r[u].YValues[0]=r[u].y=c/l*100}var r,c,u,f,e,v,o,s,h;this.chartObj=i;t.segment=[];t.xRange={};t.yRange={};var l=t.kPeriod,y=t.dPeriod,a=t.period;if(!(a<1)&&!(y<1)&&!(l<1)&&!(a>t._points.length)&&!(y>t._points.length)&&!(l>t._points.length)){for(r=n.extend(!0,{},t),r.name="upperseries",r.type="line",r.fill=t.upperLine.fill,r.width=t.upperLine.width,c=0;c<t._points.length;c++)t._points[c].YValues.length=1,t._points[c].YValues[0]=t._points[c].y=80;for(r.points=n.extend(!0,[],t._points),u=i._getXValues(r.points),f=i._getYValues(r.points),t.xRange.min=Math.min.apply(Math,u),t.xRange.max=Math.max.apply(Math,u),t.yRange.min=Math.min.apply(Math,f),t.yRange.max=Math.max.apply(Math,f),t.segment.push(r),e=n.extend(!0,{},t),e.name="lowerSeries",e.width=t.lowerLine.width,e.fill=t.lowerLine.fill,e.type="line",v=0;v<t._points.length;v++)t._points[v].YValues[0]=t._points[v].y=20;e.points=n.extend(!0,[],t._points);u=i._getXValues(e.points);f=i._getYValues(e.points);t.xRange.min=Math.min(Math.min.apply(Math,u),t.xRange.min);t.xRange.max=Math.max(Math.max.apply(Math,u),t.xRange.max);t.yRange.min=Math.min(Math.min.apply(Math,f),t.yRange.min);t.yRange.max=Math.max(Math.max.apply(Math,f),t.yRange.max);t.segment.push(e);o=n.extend(!0,{},t);o.name="periodSeries";o.width=t.periodLine.width;o.fill=t.periodLine.fill;o.type="line";var w=[],b=[],k=[],p=[];for(s=0;s<t._points.length;s++)b[s]=t._points[s].low,w[s]=t._points[s].high,k[s]=t._points[s].close;nt(a,l,t._points);p=t._points;d(a,l,t._points);p=t._points;o.points=n.extend(!0,[],t._points);u=i._getXValues(o.points);f=i._getYValues(o.points);t.xRange.min=Math.min(Math.min.apply(Math,u),t.xRange.min);t.xRange.max=Math.max(Math.max.apply(Math,u),t.xRange.max);t.yRange.min=Math.min(Math.min.apply(Math,f),t.yRange.min);t.yRange.max=Math.max(Math.max.apply(Math,f),t.yRange.max);t.segment.push(o);h=n.extend(!0,{},t);h.name="trendSeries";h.width=t.width;h.fill=t.fill;h.type="line";d(a+l-1,y,t._points);h.points=n.extend(!0,[],t._points);t.segment.push(h);this.calculateIndicatorRange(i,t)}}});ej.indicatorTypes.stochastic=ej.ejSTOCHASTIC;ej.ejbollingerBand=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){var v,ft,d,f,e,l,tt,o,s,it,h,c,rt,r,a;this.chartObj=i;t.segment=[];t.xRange={};t.yRange={};var b=0,g=0,nt=t._points.length,ut=t.standardDeviations,w=t.period,u=Math.round(w),y=[],p=[],k=[];if(u<nt&&u>0){for(r=0;r<u;r++)b+=t._points[r].close;for(v=b/w,r=0;r<nt;++r)if(r>=u-1&&r<nt){r-w>=0?(ft=t._points[r].close-t._points[r-u].close,b=b+ft,v=b/w,y[r]=v,p[r]=Math.pow(t._points[r].close-v,2),g+=p[r]-p[r-u]):(y[r]=v,p[r]=Math.pow(t._points[r].close-v,2),g+=p[r]);var et=Math.sqrt(g/w),ot=y[r]-ut*et,st=y[r]+ut*et;if(r+1==u)for(d=0;d<u-1;d++)k[d]={X:t._points[d].X,mb:y[r],lb:ot,ub:st,visible:!0};k[r]={X:t._points[r].X,mb:y[r],lb:ot,ub:st,visible:!0}}else r<w-1&&(y[r]=v,p[r]=Math.pow(t._points[r].close-v,2),g+=p[r]);for(f=n.extend(!0,{},t),f.name="upperseries",f.fill=t.upperLine.fill,f.width=t.upperLine.width,f.type="line",e=0;e<t._points.length;e++)e>=u-1?(t._points[e].YValues.length=1,t._points[e].YValues[0]=t._points[e].y=k[e].ub):t._points[e].YValues[0]=t._points[e].y=null;for(f.points=n.extend(!0,[],t._points),l=i._getXValues(f.points),tt=[],r=u;r<f.points.length;r++)tt.push(f.points[r].y);for(a=tt,t.xRange.min=Math.min.apply(Math,l),t.xRange.max=Math.max.apply(Math,l),t.yRange.min=Math.min.apply(Math,a),t.yRange.max=Math.max.apply(Math,a),t.segment.push(f),o=n.extend(!0,{},t),o.name="lowerSeries",o.width=t.lowerLine.width,o.fill=t.lowerLine.fill,o.type="line",s=0;s<t._points.length;s++)s>=u-1?(t._points[s].YValues.length=1,t._points[s].YValues[0]=t._points[s].y=k[s].lb):t._points[s].YValues[0]=t._points[s].y=null;for(o.points=n.extend(!0,[],t._points),l=i._getXValues(o.points),it=[],r=u;r<o.points.length;r++)it.push(o.points[r].y);for(a=it,t.xRange.min=Math.min(Math.min.apply(Math,l),t.xRange.min),t.xRange.max=Math.max(Math.max.apply(Math,l),t.xRange.max),t.yRange.min=Math.min(Math.min.apply(Math,a),t.yRange.min),t.yRange.max=Math.max(Math.max.apply(Math,a),t.yRange.max),t.segment.push(o),h=n.extend(!0,{},t),h.name="trendSeries",h.width=t.width,h.fill=t.fill,h.type="line",c=0;c<t._points.length;c++)c>=u-1?(t._points[c].YValues.length=1,t._points[c].YValues[0]=t._points[c].y=k[c].mb):t._points[c].YValues[0]=t._points[c].y=null;for(h.points=n.extend(!0,[],t._points),l=i._getXValues(h.points),rt=[],r=u;r<h.points.length;r++)rt.push(h.points[r].y);a=rt;t.xRange.min=Math.min(Math.min.apply(Math,l),t.xRange.min);t.xRange.max=Math.max(Math.max.apply(Math,l),t.xRange.max);t.yRange.min=Math.min(Math.min.apply(Math,a),t.yRange.min);t.yRange.max=Math.max(Math.max.apply(Math,a),t.yRange.max);t.segment.push(h);this.calculateIndicatorRange(i,t)}}});ej.indicatorTypes.bollingerband=ej.ejbollingerBand;ej.ejATR=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){var o,s,h,c,u,f,y,v,r;this.chartObj=i;t.segment=[];t.xRange={};t.yRange={};o=[];s=h=c=0;var l,p=0,a,e=t.period;if(!(e<=0)&&!(e>t._points.length)){for(r=0;r<e;r++)s=t._points[r].high-t._points[r].low,r>0&&(h=Math.abs(t._points[r].high-t._points[r-1].close),c=Math.abs(t._points[r].low-t._points[r-1].close)),l=Math.max(s,h,c),p+=l,a=p/e,o[r]={X:t._points[r].X,YValues:a};for(r=e;r<t._points.length;++r)s=t._points[r].high-t._points[r].low,h=Math.abs(t._points[r].high-t._points[r-1].close),c=Math.abs(t._points[r].low-t._points[r-1].close),l=Math.max(s,h,c),a=(o[r-1].YValues*(e-1)+l)/e,o[r]={X:t._points[r].X,YValues:a};for(u=n.extend(!0,{},t),u.name="trendSeries",u.width=t.width,u.fill=t.fill,u.type="line",f=0;f<t._points.length;f++)f>=e-1?(t._points[f].YValues.length=1,t._points[f].YValues[0]=t._points[f].y=o[f].YValues):t._points[f].YValues[0]=t._points[f].y=null;for(u.points=n.extend(!0,[],t._points),y=i._getXValues(u.points),v=[],r=e;r<u.points.length;r++)v.push(u.points[r].y);t.xRange.min=Math.min.apply(Math,y);t.xRange.max=Math.max.apply(Math,y);t.yRange.min=Math.min.apply(Math,v);t.yRange.max=Math.max.apply(Math,v);t.segment.push(u);this.calculateIndicatorRange(i,t)}}});ej.indicatorTypes.atr=ej.ejATR;ej.ejaccumulationDistribution=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){var e,o,r,s,h,u,f,c,l;for(this.chartObj=i,t.segment=[],t.xRange={},t.yRange={},e=[],o=0,r=0;r<t._points.length;r++)s=t._points[r].close,h=(s-t._points[r].low-(t._points[r].high-s))/(t._points[r].high-t._points[r].low),o+=(isNaN(h)?0:h)*t._points[r].volume,e[r]=o;for(u=n.extend(!0,{},t),u.name="trendseries",u.fill=t.fill,u.width=t.width,u.type="line",f=0;f<t._points.length;f++)t._points[f].YValues[0]=t._points[f].y=e[f];u.points=n.extend(!0,[],t._points);c=i._getXValues(u.points);l=i._getYValues(u.points);t.xRange.min=Math.min.apply(Math,c);t.xRange.max=Math.max.apply(Math,c);t.yRange.min=Math.min.apply(Math,l);t.yRange.max=Math.max.apply(Math,l);t.segment.push(u);this.calculateIndicatorRange(i,t)}});ej.indicatorTypes.accumulationdistribution=ej.ejaccumulationDistribution;ej.ejTMA=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){var o,y,p,r,w,s,u;this.chartObj=i;t.segment=[];t.xRange={};t.yRange={};o=n.extend(!0,{},t);o.name="trendSeries";o.width=t.width;o.fill=t.fill;o.type="line";var l=[],b=[],k=[],h=[],v=[],e=0,c,a=t._points.length,f=t.period;if(!(f<1)&&f<a){for(s=0;s<a;s++)l.push(t._points[s].close);for(y=l.length;y>=f;){for(e=0,u=0;u<f;u++)e=e+l[u];e=e/f;b.push(parseFloat(e.toFixed(2)));l.splice(0,1);y=l.length}for(r=0;r<a;r++)if(r<f-1){for(e=0,u=0;u<r+1;u++)e=e+t._points[u].close;e=e/(r+1);h[r]=parseFloat(e.toFixed(2))}else h[r]=b[r-(f-1)];for(p=h.length;p>=f;){for(c=0,u=0;u<f;u++)c=c+h[u];c=c/f;k.push(c);h.splice(0,1);p=h.length}for(r=0;r<a;r++)t._points[r].YValues[0]=r<f-1?t._points[r].y=null:t._points[r].y=k[r-(f-1)];for(o.points=n.extend(!0,[],t._points),w=i._getXValues(o.points),s=f-1,u=0;s<o.points.length;s++,u++)v[u]=o.points[s].y;t.xRange.min=Math.min.apply(Math,w);t.xRange.max=Math.max.apply(Math,w);t.yRange.min=Math.min.apply(Math,v);t.yRange.max=Math.max.apply(Math,v);t.segment.push(o);this.calculateIndicatorRange(i,t)}}});ej.indicatorTypes.tma=ej.ejTMA;ej.ejMomentum=t(ej.EjIndicatorRender,{calculateSegment:function(t,i){var e,c,l,o,a,f,p,s,v,r,h,u,y;if(this.chartObj=i,t.segment=[],t.xRange={},t.yRange={},e=n.extend(!0,{},t),e.name="upperseries",e.fill=t.upperLine.fill,e.width=t.upperLine.width,e.type="line",c=t.period,l=t._points.length,c>0&&c<l-1){for(r=0;r<l;r++)t._points[r].YValues.length=1,t._points[r].YValues[0]=t._points[r].y=100;for(e.points=n.extend(!0,[],t._points),o=i._getXValues(e.points),a=i._getYValues(e.points),t.xRange.min=Math.min.apply(Math,o),t.xRange.max=Math.max.apply(Math,o),t.yRange.min=Math.min.apply(Math,a),t.yRange.max=Math.max.apply(Math,a),t.segment.push(e),f=n.extend(!0,{},t),f.name="trendSeries",f.width=t.width,f.fill=t.fill,f.type="line",p=[],s=t.period,u=0;u<t._points.length;++u)v=t._points,u<s||(t._points[u].YValues[0]=t._points[u].y=v[u].close/v[u-s].close*100);for(r=0;r<s&&r<t._points.length;r++)t._points[r].YValues[0]=t._points[r].y=null;for(f.points=n.extend(!0,[],t._points),o=i._getXValues(f.points),h=[],u=s,y=0;u<f.points.length;u++,y++)h[y]=f.points[u].y;t.xRange.min=Math.min(Math.min.apply(Math,o),t.xRange.min);t.xRange.max=Math.max(Math.max.apply(Math,o),t.xRange.max);t.yRange.min=Math.min(Math.min.apply(Math,h),t.yRange.min);t.yRange.max=Math.max(Math.max.apply(Math,h),t.yRange.max);t.segment.push(f);this.calculateIndicatorRange(i,t)}}});ej.indicatorTypes.momentum=ej.ejMomentum;ej.EjSeriesRender.prototype={getOrigin:function(n,t,i){if(i.axes[t.xAxis.name]._validCross){var r=n.chartObj._getCrossAxis(n.chartObj.model._axes,!0,t.xAxis.crossesInAxis);if(n.chartObj.model.requireInvertedAxes?t.xAxis.name:t.yAxis.name===r.name)return t.xAxis._crossValue}return t.type.toLowerCase()=="splinerangearea"?Math.max(t.points[0].YValues[1],0):Math.max(t.yAxis.visibleRange.min,0)},setLineSeriesStyle:function(t){var i=n.inArray(t,this.chartObj.model._visibleSeries),r=this.chartObj.model.seriesColors[i],u,f;return u=t.isTransposed?this.chartObj.svgRenderer.createGradientElement(this.getSeriesName(t)+i,r,100,0,0,0,this.chartObj.gSeriesEle):this.chartObj.svgRenderer.createGradientElement(this.getSeriesName(t)+i,r,0,0,0,100,this.chartObj.gSeriesEle),f=this.chartObj.model.seriesBorderColors[i],{SeriesInterior:u,SeriesBorder:f}},getSeriesName:function(n){return n.name?n.name.replace(/\s/g,""):"series"},drawAreaPath:function(t,i,r,u){var l=this.chartObj.model.requireInvertedAxes,e=n.inArray(t,this.chartObj.model._visibleSeries),h=null,a=this.chartObj.model.AreaType,o=t.border,s,c,f;a=="cartesianaxes"&&(s=ej.EjSvgRender.utils._getTransform(t.xAxis,t.yAxis,l),h="translate("+s.x+","+s.y+")");c={id:this.chartObj.svgObject.id+"_SeriesGroup_"+e,transform:h};this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(c);r!=""&&(f={id:this.chartObj.svgObject.id+"_Series"+e,fill:i.SeriesInterior,"fill-opacity":t.opacity,"stroke-width":o.width,stroke:o.color,"stroke-dasharray":o.dashArray,"stroke-linecap":t.lineCap,"stroke-linejoin":t.lineJoin,d:r},this.chartObj.dragPoint?(f.id=this.chartObj.svgObject.id+"_PreviewSeries"+e,f["fill-opacity"]=.6,this.chartObj.model.enableCanvasRendering?this.chartObj.svgRenderer.drawPath(f,this.chartObj.canvasElement,u):this.chartObj.svgRenderer.drawPath(f,this.chartObj.gPreviewSeriesGroupEle,u)):this.chartObj.svgRenderer.drawPath(f,this.gSeriesGroupEle,u))},setAreaSeriesStyle:function(t){var i=n.inArray(t,this.chartObj.model._visibleSeries),r=this.chartObj.model.seriesColors[i],u;return u=t.isTransposed?this.chartObj.svgRenderer.createGradientElement(this.getSeriesName(t)+i,r,100,0,0,0,this.chartObj.gSeriesEle):this.chartObj.svgRenderer.createGradientElement(this.getSeriesName(t)+i,r,0,0,0,100,this.chartObj.gSeriesEle),{SeriesInterior:u}},naturalSpline:function(n,t,i){var f=n.length,h=[],k=[],s=[],u=[],l=[],y=ej.util.isNullOrUndefined(t.cardinalSplineTension)?.5:t.cardinalSplineTension<0?0:t.cardinalSplineTension>1?1:t.cardinalSplineTension,e=t.type.toLowerCase()=="splinerangearea"?i:0,p,a,o,d,g,nt,r,b,c;if(t.splineType=="monotonic"){for(r=0;r<f-1;r++)h[r]=n[r+1].xValue-n[r].xValue,k[r]=n[r+1].YValues[e]-n[r].YValues[e],s[r]=k[r]/h[r];for(p=s.length,u[0]=s[0],u[f-1]=s[p-1],o=0;o<h.length;o++)p>o+1&&(s[o]*s[o+1]<=0?u[o+1]=0:(a=h[o]+h[o+1],u[o+1]=3*a/((a+h[o+1])/s[o]+(a+h[o])/s[o+1])))}else if(t.splineType=="cardinal")for(r=0;r<f;r++)u[r]=r==0?f>2?y*(n[r+2].xValue-n[r].xValue):0:r==f-1?f>2?y*(n[f-1].xValue-n[f-3].xValue):0:y*(n[r+1].xValue-n[r-1].xValue);else{for(d=6,t.splineType=="clamped"?(g=(n[1].xValue-n[0].xValue)/(n[1].YValues[e]-n[0].YValues[e]),nt=(n[f-1].xValue-n[f-2].xValue)/(n[f-1].YValues[e]-n[f-2].YValues[e]),u[0]=3*(n[1].YValues[e]-n[0].YValues[e])/(n[1].xValue-n[0].xValue)-3*g,l[0]=.5,u[n.length-1]=3*nt-3*(n[n.length-1].YValues[e]-n[n.length-2].YValues[e])/(n[n.length-1].xValue-n[n.length-2].xValue),u[0]=Math.abs(u[0])=="Infinity"?0:u[0],u[n.length-1]=Math.abs(u[n.length-1])=="Infinity"?0:u[n.length-1]):(u[0]=l[0]=0,u[n.length-1]=0),r=1;r<f-1;r++){var v=n[r].xValue-n[r-1].xValue,tt=n[r+1].xValue-n[r-1].xValue,w=n[r+1].xValue-n[r].xValue,it=n[r+1].YValues[e]-n[r].YValues[e]||null,rt=n[r].YValues[e]-n[r-1].YValues[e]||null;v==0||tt==0||w==0?(u[r]=0,l[r]=0):(b=1/(v*u[r-1]+2*tt),u[r]=-b*w,l[r]=b*(d*(it/w-rt/v)-v*l[r-1]))}for(c=f-2;c>=0;c--)u[c]=u[c]*u[c+1]+l[c]}return u},getDaysInMonth:function(n,t){return new Date(t,n+1,0).getDate()},getBezierControlPoints:function(t,i,r,u,f,e,o){var a,v,y,p,w=864e5,g=new Date(t.xValue),nt=o.chartObj.model.hAxes.length,k=n.inArray(e,o.chartObj.model._visibleSeries),b=k!=nt&&k<nt?k:0,c,d,l,s,h;if(e.splineType=="cardinal"){if(ej.util.isNullOrUndefined(o.chartObj.model.hAxes[b].intervalType)||o.chartObj.model.hAxes[b].intervalType.toLowerCase()=="years"||o.chartObj.model.hAxes[b].intervalType.toLowerCase()=="auto")c=new Date(g.getFullYear()),d=c%4==0&&(c%100==0||c%400!=0)?366:365,y=r/(w*d),p=u/(w*d);else if(o.chartObj.model.hAxes[b].intervalType.toLowerCase()=="months"){var tt=new Date(g),c=tt.getFullYear(),rt=tt.getMonth(),it=ej.EjSeriesRender.prototype.getDaysInMonth(rt,c);y=r/(w*it);p=u/(w*it)}else y=r,p=u;a={xValue:t.xValue+r/3,YValues:[t.YValues[f]+y/3]};v={xValue:i.xValue-u/3,YValues:[i.YValues[f]-p/3]}}else if(e.splineType=="monotonic")l=(i.xValue-t.xValue)/3,a={xValue:t.xValue+l,YValues:[t.YValues[f]+r*l]},v={xValue:i.xValue-l,YValues:[i.YValues[f]-u*l]};else{s=1/3;h=i.xValue-t.xValue;h=h*h;var ut=2*parseFloat(t.xValue)+parseFloat(i.xValue),ft=parseFloat(t.xValue)+2*parseFloat(i.xValue),et=2*t.YValues[f]+i.YValues[f],ot=t.YValues[f]+2*i.YValues[f],st=s*(et-s*h*(r+.5*u)),ht=s*(ot-s*h*(.5*r+u));a={xValue:ut*s,YValues:[st]};v={xValue:ft*s,YValues:[ht]}}return{controlPoint1:a,controlPoint2:v}},improveChartPerformance:function(n){for(var s=[],u=n.pointCollection&&n.dragPoint?n.pointCollection:n.points,v=this.chartObj.model.m_AreaBounds,y=0,f=n.xAxis.visibleRange.delta/v.Width,e=n.yAxis.visibleRange.delta/v.Height,p=u[0]&&u[0].xValue>f?0:f,w=u[0]&&u[0].y>e?0:e,i=0,r=0,t,h,c,b=u.length,k=0,d=0,o=!0,g=0,l=b>0&&u[0].xValue,a=0;a<b;a++)t=u[a],i=t.xValue,r=t.YValues[0],t.fill&&(n.pointFill=!0),o&&i!=l&&(o=l<i,l=i),(t.isEmpty||i==null||r==null||i!==i||r!==r||isNaN(i)||isNaN(r))&&(t.isEmpty=!0),i==null&&(t.xValue=n.xAxis.visibleRange.min),r==null&&(t.YValues[0]=n.yAxis.visibleRange.min),t.marker&&t.marker.visible&&k++,t.marker&&t.marker.dataLabel&&t.marker.dataLabel.visible&&d++,t.isEmpty&&y++,h=i-p,c=r-w,(h>=f||-h>=f||c>=e||-c>=e)&&(t.visible=t.isEmpty?t.visible||!1:!0,s[g++]=t,i===i&&(p=i),r===r&&(w=r));return o&&(n._sorted=o),n._pointMarker=k,n._dataLabels=d,y==0&&n.marker&&!n.marker.dataLabel.visible?s:this._calculateEmptyPoints(n,s)},_isVisiblePoints:function(n){for(var t=n.pointCollection&&n.dragPoint?n.pointCollection:n.points,r,f,u=ej.util.isNullOrUndefined,e=t.length,i=0;i<e;i++)f=u(t[i].isEmpty)?!1:t[i].isEmpty,t[i].visible=u(t[i].visible)?!0:t[i].visible,u(t[i].xValue)?(t[i].isEmpty=!0,t[i].visible=!1,t[i].xValue=n.xAxis?n.xAxis.visibleRange.min:null):t[i].isEmpty=f,typeof t[i].YValues[0]!="object"&&isNaN(t[i].YValues[0])||t[i].YValues[0]==null||t[i].YValues[0]=="undefined"||!n.isIndicator&&n._hiloTypes&&(isNaN(t[i].YValues[1])||t[i].YValues[1]==undefined||t[i].YValues[1]==null)?(t[i].isEmpty=!0,t[i].visible=!1):(t[i].isEmpty=t[i].isEmpty,t[i].visible=t[i].isEmpty?!t[i].isEmpty:t[i].visible),u(t[i].x)||jQuery.type(t[i].xValue)=="date"&&(t[i].xValue=t[i].xValue.getTime());return r=n.emptyPointSettings?this._calculateEmptyPoints(n,t):t,n.type.toLowerCase()=="waterfall"&&this.chartObj.calculateWaterfallSeriesPoints(r),n._visiblePoints=r,r},_calculateEmptyPoints:function(t,i,r){var f,l=t.emptyPointSettings,a=l.style,w=a.color,h=ej.util.isNullOrUndefined,b=a.border.color,k=a.border.width,c=l.displayMode.toLowerCase(),d=l.visible,v=i.length,e,y,s=[],o,p,u;if(f=n.extend(!0,{},i,f),o=t.type.toLowerCase(),f.length=i.length,c=o=="boxandwhisker"?"gap":c,d)if(c!="gap")for(u=0;u<v;u++)if(f[u].actualIndex=h(r)?u:r.model._isPieOfPie?f[u].actualIndex:u,e=f[u],e.isEmpty&&(!h(e.x)||t._xAxisValueType=="string")){w!=""&&(e.fill=w);b!=""&&(e.border=e.border?e.border:{},e.border.color=b,e.border.width=k);switch(c){case"average":t._hiloTypes?(o=="splinerangearea"&&this._setsraPoint(f[u]),n.each(e.YValues,function(n,t){t=((f[u-1]?f[u-1].YValues[n]:0)+(f[u+1]?f[u+1].isEmpty?0:f[u+1].YValues[n]:0))/2;e.YValues[n]=t;ej.EjSeriesRender.prototype._sethlocPoint(n,e,t)})):(y=((f[u-1]?f[u-1].y:0)+(f[u+1]?f[u+1].isEmpty?0:f[u+1].y:0))/2,e.YValues[0]=y,e.y=y);break;case"zero":t._hiloTypes?(o=="splinerangearea"&&this._setsraPoint(f[u]),n.each(e.YValues,function(n){e.y=0;e.YValues[n]=0;ej.EjSeriesRender.prototype._sethlocPoint(n,e,0)})):(p=o.indexOf("stackingspline")!=-1?f[u].YValues[0]:0,e.YValues[0]=p,e.y=p)}e.isEmpty=!1;e.visible=!0;s.push(e)}else h(f[u].x)&&t._xAxisValueType!="string"||s.push(e);else for(u=0;u<v;u++)f[u].actualIndex=h(r)?u:r.model._isPieOfPie?f[u].actualIndex:u,o=="splinerangearea"&&this._setsraPoint(f[u]),s[u]=f[u];else for(u=0;u<v;u++)f[u].actualIndex=u,f[u].visible&&s.push(f[u]);return s},_setsraPoint:function(n){var t=ej.util.isNullOrUndefined;t(n.YValues[0])&&(n.YValues[0]=0);t(n.YValues[1])&&(n.YValues[1]=0)},_sethlocPoint:function(n,t,i){switch(n){case 0:t.high=i;break;case 1:t.low=i;break;case 2:t.open=i;break;case 3:t.close=i}},_calculatePolarAxesSegment:function(t){var r=t._visiblePoints,l=ej.EjSvgRender.utils._getStringBuilder(),nt=n.inArray(t,this.chartObj.model._visibleSeries),d,o=this.chartObj.model.centerX,s=this.chartObj.model.centerY,yt=this._getSeriesPosition(t),ai=t.drawType.toLowerCase(),rr=ej.EjSvgRender.utils._getStringBuilder(),ur=this.setLineSeriesStyle(t),vi=0,ii=null,ri=null,ui=-1,st=null,ht=null,ct=null,lt=null,at=null,pt,fi,it,hi,yi,g=this.chartObj,e,pi,tt,ci,nr,ot,ei,wt,bt,wi,li,i,u,c,k,rt,si,ft,et;if(d=n.extend(!0,{},t.marker.size,d),d.width<=10&&(d.width=d.height=1.5*this.chartObj.model.elementSpacing),t.drawType.toLowerCase()=="column"||t.drawType.toLowerCase()=="rangecolumn"){e=0;pi={id:this.chartObj.svgObject.id+"_SeriesGroup_"+nt};this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(pi);tt=t.xAxis.visibleRange.interval;t.xAxis.labelPlacement=t.xAxis.labelPlacement?t.xAxis.labelPlacement:"betweenticks";ci=0;(t.xAxis._valueType!="category"||t.xAxis._valueType=="category"&&t.xAxis.labelPlacement=="onticks")&&(ci=tt/2);ei=t.xAxis.isInversed?0:1;tt=tt/yt.all;var wi=tt,h=t._visiblePoints,tr=h.length;for(wt=0;wt<tr;wt++)bt=nr=h[wt].xValue-t.xAxis.visibleRange.min+(tt*yt.pos-ci),bt=bt/this.chartObj.model.sumofYValues,ot=h[wt],wi=t.xAxis.visibleRange.interval/yt.all,ot.startAngle=2*Math.PI*bt,ot.endAngle=2*Math.PI*(bt+wi/this.chartObj.model.sumofYValues);h[h.length-1].startAngle||(h[h.length-1].startAngle=h[0].startAngle,h[h.length-1].endAngle=h[0].endAngle)}for(li=!1,i=0;i<r.length;i++){if(ai=="scatter")u=ej.EjSvgRender.utils.TransformToVisible(t,r[i].xValue,r[i].y,this.chartObj),this.drawSymbol(nt,t,i,u.X,u.Y);else if(t.drawType.toLowerCase()=="line")u=ej.EjSvgRender.utils.TransformToVisible(t,r[i].xValue,r[i].y,this.chartObj),i<r.length-1&&r[i+1].visible?(c=ej.EjSvgRender.utils.TransformToVisible(t,r[i+1].xValue,r[i+1].y,this.chartObj),l.append("M "+u.X+" "+u.Y+" L "+c.X+" "+c.Y+" ")):i==r.length-1&&t.isClosed&&(c=ej.EjSvgRender.utils.TransformToVisible(t,r[0].xValue,r[0].y,this.chartObj),l.append("M "+u.X+" "+u.Y+" L "+c.X+" "+c.Y+" "));else if(t.drawType.toLowerCase()=="column"){var tt=t.xAxis.visibleRange.interval,ei=t.xAxis.isInversed?0:1,tt=tt/yt.all,f=this.chartObj.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t.yAxis,r[i].y),oi=-.5*Math.PI,w=r[i].startAngle+oi,b=r[i].endAngle+oi-1e-6,a,v,y,p,kt;if(t.isStacking){k=t.stackedValue.StartValues[i];rt=t.stackedValue.EndValues[i];f=k==rt?0:this.chartObj.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t.yAxis,rt);a=o+f*Math.cos(w);v=s+f*Math.sin(w);y=o+f*Math.cos(b);p=s+f*Math.sin(b);e=this.chartObj.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t.yAxis,k==0&&t.yAxis.visibleRange.min!=0?t.yAxis.visibleRange.min:k);var dt=o+e*Math.cos(w),gt=s+e*Math.sin(w),ni=o+e*Math.cos(b),ti=s+e*Math.sin(b);kt=this.chartObj.model.isPolar?"M "+a+" "+v+" A "+f+" "+f+" 0 0 "+ei+" "+y+" "+p+" L "+ni+" "+ti+" A "+e+" "+e+" 1 0 0 "+dt+" "+gt+" z":"M "+a+" "+v+" L "+y+" "+p+" L "+ni+" "+ti+" L "+dt+" "+gt+" z"}else a=o+f*Math.cos(w),v=s+f*Math.sin(w),y=o+f*Math.cos(b),p=s+f*Math.sin(b),kt=this.chartObj.model.isPolar?"M "+a+" "+v+" A "+f+" "+f+" 0 0 "+ei+" "+y+" "+p+" L "+o+" "+s+" z":"M "+a+" "+v+" L "+y+" "+p+" L "+o+" "+s+" z";var bi=this.chartObj.svgRenderer.createGradientElement(this.getSeriesName(t)+"_"+nt+i,this.chartObj.model.seriesColors[nt],0,0,0,100,this.chartObj.gSeriesEle),vt=t.border,ut={id:this.chartObj.svgObject.id+"_Series"+nt+"_Point"+i,fill:bi,stroke:vt.color,"stroke-dasharray":vt.dashArray,"stroke-width":vt.width,opacity:t.opacity,pointIndex:i,d:kt,start:r[i].startAngle-1.57,end:r[i].endAngle-1.57,radius:f,innerR:e};if(this.chartObj.model.isPolar&&(ut.x=o,ut.y=s,et={PointIndex:i,StartAngle:r[i].startAngle,EndAngle:r[i].endAngle,CenterX:o,CenterY:s,Radius:f,DRadius:e}),t.type=="radar"){var ki={x:o,y:s},di={x:a,y:v},gi={x:y,y:p};et={PointIndex:i,Line1:ki,Line2:di,Line3:gi};si=e?!0:!1;ut.hasStackingInnerRadius=si}ot=t._visiblePoints[i];(!ej.util.isNullOrUndefined(t.marker)&&t.marker.visible||!ej.util.isNullOrUndefined(t.marker)&&t.marker.dataLabel.visible)&&(ot.symbolLocation={X:(a+y)/2,Y:(v+p)/2});this.chartObj.svgRenderer.drawPath(ut,this.gSeriesGroupEle)}else if(ai=="spline")h=this.chartObj.dragPoint?t.pointCollection:this._isVisiblePoints(t),u=ej.EjSvgRender.utils.TransformToVisible(t,r[i].xValue,r[i].y,this.chartObj),i<r.length-1&&r[i+1].visible&&(c=ej.EjSvgRender.utils.TransformToVisible(t,r[i+1].xValue,r[i+1].y,this.chartObj),pt=this.naturalSpline(r,t),fi=ui=i,ii=h[i],ri=h[i+1],ct=this.getBezierControlPoints(ii,ri,pt[ui],pt[fi],vi,t,this),st=ct.controlPoint1,ht=ct.controlPoint2,lt=ej.EjSvgRender.utils.TransformToVisible(t,st.xValue,st.YValues,g),at=ej.EjSvgRender.utils.TransformToVisible(t,ht.xValue,ht.YValues,g),l.append("M "+u.X+" "+u.Y+" C "+lt.X+" "+lt.Y+" "+at.X+" "+at.Y+" "+c.X+" "+c.Y+" "),t.isClosed&&i==r.length-1&&u!=null&&(it=ej.EjSvgRender.utils.TransformToVisible(t,r[0].xValue,r[0].y,g),ii=h[h.length-1],ri=h[0],fi=ui=0,ct=this.getBezierControlPoints(ii,ri,pt[ui],pt[fi],vi,t,this),st=ct.controlPoint1,ht=ct.controlPoint2,lt=ej.EjSvgRender.utils.TransformToVisible(t,st.xValue,st.YValues,g),at=ej.EjSvgRender.utils.TransformToVisible(t,ht.xValue,ht.YValues,g),l.append("M "+c.X+" "+c.Y+" C "+(lt.X+g.canvasX)+" "+(lt.Y+g.canvasY)+" "+(at.X+g.canvasX)+" "+(at.Y+g.canvasY)+" "+it.X+" "+it.Y+" ")));else if(t.drawType.toLowerCase()=="rangecolumn"){var tt=t.xAxis.visibleRange.interval,ei=t.xAxis.isInversed?0:1,tt=tt/yt.all,oi=-.5*Math.PI,w=r[i].startAngle+oi,b=r[i].endAngle+oi-1e-6,a,v,y,p,kt,k=r[i].YValues[1],rt=r[i].YValues[0];f=k==rt?0:this.chartObj.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t.yAxis,rt);a=o+f*Math.cos(w);v=s+f*Math.sin(w);y=o+f*Math.cos(b);p=s+f*Math.sin(b);e=this.chartObj.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t.yAxis,k==0&&t.yAxis.visibleRange.min!=0?t.yAxis.visibleRange.min:k);var dt=o+e*Math.cos(w),gt=s+e*Math.sin(w),ni=o+e*Math.cos(b),ti=s+e*Math.sin(b);kt=this.chartObj.model.isPolar?"M "+a+" "+v+" A "+f+" "+f+" 0 0 "+ei+" "+y+" "+p+" L "+ni+" "+ti+" A "+e+" "+e+" 1 0 0 "+dt+" "+gt+" z":"M "+a+" "+v+" L "+y+" "+p+" L "+ni+" "+ti+" L "+dt+" "+gt+" z";var bi=this.chartObj.svgRenderer.createGradientElement(this.getSeriesName(t)+"_"+nt+i,this.chartObj.model.seriesColors[nt],0,0,0,100,this.chartObj.gSeriesEle),vt=t.border,ut={id:this.chartObj.svgObject.id+"_Series"+nt+"_Point"+i,fill:bi,stroke:vt.color,"stroke-dasharray":vt.dashArray,"stroke-width":vt.width,opacity:t.opacity,pointIndex:i,d:kt,start:r[i].startAngle-1.57,end:r[i].endAngle-1.57,radius:f,innerR:e};if(this.chartObj.model.isPolar&&(ut.x=o,ut.y=s,et={PointIndex:i,StartAngle:r[i].startAngle,EndAngle:r[i].endAngle,CenterX:o,CenterY:s,Radius:f,DRadius:e}),t.type=="radar"){var ki={x:ni,y:ti},di={x:a,y:v},gi={x:y,y:p},ir={x:dt,y:gt};et={PointIndex:i,Line1:ki,Line2:di,Line3:gi,Line4:ir};si=e?!0:!1;ut.hasStackingInnerRadius=si}ot=t._visiblePoints[i];(!ej.util.isNullOrUndefined(t.marker)&&t.marker.visible||!ej.util.isNullOrUndefined(t.marker)||t.marker.dataLabel.visible)&&(ot.symbolLocation={X:(a+y)/2,Y:(v+p)/2},this.chartObj.svgRenderer.drawPath(ut,this.gSeriesGroupEle))}else if(t.isStacking){if(k=t.stackedValue.StartValues[i],rt=t.stackedValue.EndValues[i],i==0)for(u=ej.EjSvgRender.utils.TransformToVisible(t,r[i].xValue,rt,this.chartObj),ft=r.length-1;ft>=0;ft--)k=t.stackedValue.StartValues[ft],r[ft].y=Math.max(t.yAxis.actualRange.min,k),u=ej.EjSvgRender.utils.TransformToVisible(t,r[ft].xValue,r[ft].y,this.chartObj),yi=ft==r.length-1?"M":"L",l.append(""+yi+" "+u.X+" "+u.Y+" ");i<=r.length-1&&(r[i].y=rt,u=ej.EjSvgRender.utils.TransformToVisible(t,r[i].xValue,r[i].y,this.chartObj),l.append("L "+u.X+" "+u.Y+" "),i==r.length-1&&(t.isClosed?(c=ej.EjSvgRender.utils.TransformToVisible(t,r[0].xValue,t.stackedValue.EndValues[0],this.chartObj),it=ej.EjSvgRender.utils.TransformToVisible(t,r[0].xValue,t.stackedValue.StartValues[0],this.chartObj),hi=ej.EjSvgRender.utils.TransformToVisible(t,r[i].xValue,t.stackedValue.StartValues[i],this.chartObj),l.append("L "+c.X+" "+c.Y+"  L "+it.X+" "+it.Y+"  L "+hi.X+" "+hi.Y+"  L "+it.X+" "+it.Y+" z ")):l.append("L "+o+" "+s+" ")))}else u=ej.EjSvgRender.utils.TransformToVisible(t,r[i].xValue,r[i].y,this.chartObj),i==0||li?l.append("M "+u.X+" "+u.Y+" "):i==r.length-1?t.isClosed?(c=ej.EjSvgRender.utils.TransformToVisible(t,r[0].xValue,r[0].y,this.chartObj),l.append("L "+u.X+" "+u.Y+" z")):l.append("L "+u.X+" "+u.Y+" L "+o+" "+s):r[i+1].visible?l.append("L "+u.X+" "+u.Y+" "):l.append("L "+u.X+" "+u.Y+" L "+o+" "+s+" z"),li=r[i+1]&&r[i+1].visible?!1:!0;t.regionAdded||t.drawType.toLowerCase()=="column"||t.drawType.toLowerCase()=="rangecolumn"||(et={X:u.X-d.width/2,Y:u.Y-d.height/2,Width:d.width,Height:d.height},ej.EjSvgRender.utils._addRegion(this.chartObj,et,t,r[i],i));(!t.regionAdded&&t.drawType.toLowerCase()=="column"&&this.chartObj.model.enableCanvasRendering||t.drawType.toLowerCase()=="rangecolumn"&&this.chartObj.model.enableCanvasRendering)&&ej.EjSvgRender.utils._addRegion(this.chartObj,et,t,null,null)}return(t.regionAdded||t.drawType.toLowerCase()!="column"||this.chartObj.model.enableCanvasRendering)&&(t.drawType.toLowerCase()!="rangecolumn"||this.chartObj.model.enableCanvasRendering)||ej.EjSvgRender.utils._addRegion(this.chartObj,et,t,null,null),l.toString()},_calculateVisiblePoints:function(t,i){for(var r,c=[],h=[],v,s=ej.util.isNullOrUndefined,l=s(i)?t.points:i.model._isPieOfPie?t.pieCollections[t.collectionIndex]:t.points,e,a=l.length,u,f,o=0;o<a;o++)f=l[o],s(f._visibility)&&(f._visibility="visible"),f.actualIndex=s(i)?o:i.model._isPieOfPie?f.actualIndex:o,f.visible=f.isEmpty?!1:f.visible,s(f.visible)&&(f.visible=!0),f.y<0&&(f.YValues[0]=Math.abs(f.YValues[0])),s(f.x)&&t._xAxisValueType!="string"&&(f.visible=!1,f.isEmpty=!0),s(f.y)&&(f.visible=!1,f.isEmpty=!0);if(e=n.extend(!0,{},l,e),e.length=a,t.emptyPointSettings.visible)for(u=this._calculateEmptyPoints(t,e,i),v=u.length,r=0;r<v;r++)u[r].visible?(u[r].visible=u[r]._visibility=="hidden"?!1:!0,h.push(u[r]),u[r].visible&&c.push(u[r])):(u[r].y=((u[r-1]?u[r-1].y:0)+(u[r+1]?u[r+1].y:0))/2,isNaN(u[r].y)&&(u[r].y=((u[r-2]?u[r-2].y:0)+(u[r+2]?u[r+2].y:0))/2),u[r].YValues[0]=u[r].y,s(u[r].x)&&t._xAxisValueType!="string"||(u[r].gapMode=!0,c.push(u[r])));else for(r=0;r<a;r++)h.push(e[r]),e[r].visible&&(e[r].visible=e[r]._visibility=="hidden"?!1:!0,e[r].visible&&c.push(e[r]));if(t.visibility=="hidden")for(o=0;o<h.length;o++)h[o].visible=!1;return t._visiblePoints=c,t.visiblePoints=h,{visiblePoints:c,legendPoints:h}},getMinMaxValue:function(n,t,i){var u=Math.min(n.x,t.x),f=Math.min(n.y,t.y),e=Math.max(n.x,t.x),o=Math.max(n.y,t.y),r;switch(i){case 0:case 360:r=o;break;case 90:r=u;break;case 180:r=f;break;case 270:r=e}return r},pieDoughnutCenter:function(t){var p=t.startAngle,w=t.endAngle,y,v,e,r;this.chartObj.model.centerCount++;var i=n.inArray(t,this.chartObj.model._visibleSeries),o=[-630,-540,-450,-360,-270,-180,-90,0,90,180,270,360,450,540,630],u=[],nt=this.chartObj.model.circleCenterX[i],tt=this.chartObj.model.circleCenterY[i];if(t.startAngle<t.endAngle)for(r=0;r<o.length;r++)o[r]>p&&o[r]<w&&(u[u.length]=o[r]%360<0?o[r]%360+360:o[r]%360);else for(r=0;r<o.length;r++)o[r]<p&&o[r]>w&&(u[u.length]=o[r]%360<0?o[r]%360+360:o[r]%360);if(this.chartObj.model.centerCount==1){var f=this.chartObj.model.circularRadius[i],b=2*Math.PI*(p-90)/360,k=2*Math.PI*(w-90)/360,a={x:this.chartObj.model.circleCenterX[i],y:this.chartObj.model.circleCenterY[i]},s={x:this.chartObj.model.circleCenterX[i]+f*Math.cos(b),y:this.chartObj.model.circleCenterY[i]+f*Math.sin(b)},h={x:this.chartObj.model.circleCenterX[i]+f*Math.cos(k),y:this.chartObj.model.circleCenterY[i]+f*Math.sin(k)};switch(u.length){case 0:var it=Math.abs(a.x-s.x)>Math.abs(a.x-h.x)?s.x:h.x,rt=Math.abs(a.y-s.y)>Math.abs(a.y-h.y)?s.y:h.y,e={x:(a.x+it)/2,y:(a.y+rt)/2};this.chartObj.model.circleCenterX[i]=this.chartObj.model.circleCenterX[i]+(this.chartObj.model.circleCenterX[i]-e.x);this.chartObj.model.circleCenterY[i]=this.chartObj.model.circleCenterY[i]+(this.chartObj.model.circleCenterY[i]-e.y);break;case 1:y=2*Math.PI*(u[0]-90)/360;v={x:this.chartObj.model.circleCenterX[i]+f*Math.cos(y),y:this.chartObj.model.circleCenterY[i]+f*Math.sin(y)};switch(u[0]){case 0:case 360:c={x:s.x,y:v.y};l={x:h.x,y:a.y};break;case 90:c={x:a.x,y:h.y};l={x:v.x,y:s.y};break;case 180:c={x:h.x,y:a.y};l={x:s.x,y:v.y};break;case 270:c={x:v.x,y:s.y};l={x:a.x,y:h.y}}e={x:(c.x+l.x)/2,y:(c.y+l.y)/2};this.chartObj.model.circleCenterX[i]=this.chartObj.model.circleCenterX[i]+(this.chartObj.model.circleCenterX[i]-e.x>=f?0:this.chartObj.model.circleCenterX[i]-e.x);this.chartObj.model.circleCenterY[i]=this.chartObj.model.circleCenterY[i]+(this.chartObj.model.circleCenterY[i]-e.y>=f?0:this.chartObj.model.circleCenterY[i]-e.y);break;case 2:var d=2*Math.PI*(u[0]-90)/360,y=2*Math.PI*(u[1]-90)/360,v={x:this.chartObj.model.circleCenterX[i]+f*Math.cos(y),y:this.chartObj.model.circleCenterY[i]+f*Math.sin(y)},g={x:this.chartObj.model.circleCenterX[i]+f*Math.cos(d),y:this.chartObj.model.circleCenterY[i]+f*Math.sin(d)},c,l;c=u[0]==90&&u[1]==180||u[0]==270&&u[1]==0?{x:g.x,y:v.y}:{x:v.x,y:g.y};l=u[0]==90||u[0]==270?{x:this.getMinMaxValue(s,h,u[0]),y:this.getMinMaxValue(s,h,u[1])}:{x:this.getMinMaxValue(s,h,u[1]),y:this.getMinMaxValue(s,h,u[0])};e={x:Math.abs(c.x-l.x)/2>=f?0:(c.x+l.x)/2,y:Math.abs(c.y-l.y)/2>=f?0:(c.y+l.y)/2};this.chartObj.model.circleCenterX[i]=this.chartObj.model.circleCenterX[i]+(e.x==0?0:this.chartObj.model.circleCenterX[i]-e.x>=f?0:this.chartObj.model.circleCenterX[i]-e.x);this.chartObj.model.circleCenterY[i]=this.chartObj.model.circleCenterY[i]+(e.y==0?0:this.chartObj.model.circleCenterY[i]-e.y>=f?0:this.chartObj.model.circleCenterY[i]-e.y)}}for(r=0;r<t.points.length;r++)i<this.chartObj.model._visibleSeries.length&&this.chartObj.model.centerCount>1&&this.chartObj.model._visibleSeries[i+1].startAngle==p&&this.chartObj.model._visibleSeries[i+1].endAngle==w&&(this.chartObj.model.circleCenterX[i]=this.chartObj.model.circleCenterX[i+1],this.chartObj.model.circleCenterY[i]=this.chartObj.model.circleCenterY[i+1]),this.chartObj.model.startX[r]=this.chartObj.model.startX[r]-(nt-this.chartObj.model.circleCenterX[i]),this.chartObj.model.startY[r]=this.chartObj.model.startY[r]-(tt-this.chartObj.model.circleCenterY[i])},_drawEmptyPieOfPie:function(n){var u=-.5*Math.PI,f=2*Math.PI+-.5*Math.PI-1e-6,i=n.model.circleCenterX[1],r=n.model.circleCenterY[1],t=n.model.circularRadius[1],o="M "+(i+t*Math.cos(u))+" "+(r+t*Math.sin(u))+" A "+t+" "+t+" 0 1 1 "+(i+t*Math.cos(f))+" "+(r+t*Math.sin(f))+" z",e=n.model.theme.toLowerCase();return{id:n.svgObject.id+"_Series0_EmptyCircle",fill:"none","stroke-width":1.5,stroke:e.indexOf("dark")>=0||e.indexOf("contrast")>=0?" #FFFFFF":"#000000","stroke-dasharray":"",d:o,opacity:1,radius:t,start:0-1.57,end:2*Math.PI-1.57,cx:i,cy:r}},calculatingSliceAngle:function(t,i){var e=this.chartObj?this.chartObj:i,r=e.model,k=r.legend,f=n.inArray(t,r._visibleSeries),d=k.position.toLowerCase(),ct=r.LegendActualBounds,ut=t._visiblePoints,kt=ut.length,ft=0,s,et=0,lt=k.border.width,at=r.border.width,u,y=r.margin,vt=r.elementSpacing,a=0,p=r.title.subTitle.text?r.title.subTitle:"",o,v,st,wt,ht,it,l,w,rt,h,bt,b,nt,tt,c;for(r.arcData=[],t.rightsidePoints=[],t.leftsidePoints=[],t.labels=[],r.sumofYValues=0,r.midPoint=0,o=t.type.toLowerCase(),v=t.gapWidth,c=0;c<ut.length;c++)r.sumofYValues+=ut[c].YValues[0];s=t.endAngle!=null&&o!="pieofpie"?t.endAngle-t.startAngle:360;s=s!=360&&s!=-360?s%360:s;t.startAngle&&o!="pieofpie"?(t.startAngle=t.startAngle%360,t.endAngle=t.startAngle+s,a=t.startAngle?r.sumofYValues/360*t.startAngle:0,a=a/r.sumofYValues,r.itemCurrentXPos=a):t.endAngle=s;k.visible&&d!="custom"&&(d=="right"||d=="left"?ft+=ct.Width+lt*2+vt:et+=ct.Height+lt*2+vt);var yt=r.title.text&&r.title.visible?r._titleLocation.size.height+r.elementSpacing+(p==""?0:p.text&&p.visible&&p.enableTrim&&(p.textOverflow=="wrap"||p.textOverflow=="wrapandtrim")?r._subTitleLocation.size.height:0):0,ot=.1*Math.min(n(e.svgObject).width(),n(e.svgObject).height()),g=n(e.svgObject).width()-(ft+y.left+y.right+at*2)-(o=="pieofpie"?v:0),pt=n(e.svgObject).height()-(et+yt+y.top+y.bottom+at*2);for(f=e.model._isPieOfPie?t.collectionIndex:f,o=="pieofpie"&&(g<ot&&(st=ot-g,g=ot),v=st?v-st:n(e.svgObject).width()>=v?v:0),wt=o=="pieofpie"?f==0?.25:.25*3:.5,r.circleCenterX[f]=g*wt+(f==1&&o=="pieofpie"?v:0)+y.left+(k.visible&&d==="left"?ft:0),r.circleCenterY[f]=pt*.5+y.top+yt+(k.visible&&d==="top"?et:0),ej.util.isNullOrUndefined(e.model.pieGapWidth)||e.model.pieGapWidth==0||(r.circleCenterX[f]=f==0?r.circleCenterX[f]+e.model.pieGapWidth/2:r.circleCenterX[f]-e.model.pieGapWidth/2),t.startAngle=o=="pieofpie"?0:t.startAngle,s=t.endAngle-t.startAngle,ht=s/180,it=s/4*(Math.PI/180),l=0;l<kt;l++)u=t._visiblePoints[l],(u.visible||u.gapMode)&&(w=o=="pieofpie"?u.actualIndex:l,l==0&&f==0&&o=="pieofpie"?(rt=2*Math.PI*a,h=ht*Math.PI*(u.YValues[0]/r.sumofYValues)+rt,h=isNaN(h)?rt:h,b=(h+rt)/2,u.start=u.startAngle=it-b,u.end=u.endAngle=it+b,u.midAngle=it):(u.startAngle=l==0?2*Math.PI*a:o=="pieofpie"?t.pieCollections[f][l-1].endAngle:h,h=u.endAngle=ht*Math.PI*(u.YValues[0]/r.sumofYValues)+u.startAngle,h=u.endAngle=isNaN(h)?u.startAngle:h,u.start=u.startAngle,u.end=u.endAngle,u.midAngle=(u.endAngle+u.startAngle)/2),u.pointIndex=w,bt=-.5*Math.PI,u.radian=u.midAngle%(2*Math.PI),t.labelPosition.toLowerCase()=="outsideextended"&&o!="pieofpie"&&(u.radian<Math.PI?t.rightsidePoints.push(u):t.leftsidePoints.push(u)),a+=u.YValues[0]/r.sumofYValues,b=u.midAngle+bt,(u.actualIndex==t.explodeIndex||t.explodeAll)&&!e.vmlRendering?(r.startX[w]=r.circleCenterX[f]+Math.cos(b)*t.explodeOffset,r.startY[w]=r.circleCenterY[f]+Math.sin(b)*t.explodeOffset):(r.startX[w]=r.circleCenterX[f],r.startY[w]=r.circleCenterY[f]));if(t.labelPosition.toLowerCase()=="outsideextended"&&(t.rightsidePoints=ej.DataManager(t.rightsidePoints,ej.Query().sortBy("radian")).executeLocal(),t.leftsidePoints=ej.DataManager(t.leftsidePoints,ej.Query().sortBy("radian")).executeLocal()),t.marker.dataLabel.template)if(t.labelPosition.toLowerCase()=="outsideextended"){for(nt=0;nt<t.rightsidePoints.length;nt++)ej.EjSvgRender.utils._getSeriesTemplateSize(t.rightsidePoints[nt],t.rightsidePoints[nt].actualIndex,t,!1,e);for(tt=0;tt<t.leftsidePoints.length;tt++)ej.EjSvgRender.utils._getSeriesTemplateSize(t.leftsidePoints[tt],t.leftsidePoints[tt].actualIndex,t,!0,e)}else for(c=0;c<t._visiblePoints.length;c++)ej.EjSvgRender.utils._getSeriesTemplateSize(t._visiblePoints[c],t._visiblePoints[c].actualIndex,t,!0,e);else ej.EjSvgRender.utils._getSeriesMaxLabel(t);return t.finalSize={width:g,height:pt},t.finalSize},_drawHiloPath:function(t,i,r,u,f,e){var v=n.inArray(t,this.chartObj.model._visibleSeries),y={name:t.type,id:this.chartObj.svgObject.id+"_Series"+v+"_Point"+f,fill:"none","stroke-dasharray":t.dashArray,"stroke-width":i.borderWidth,stroke:r,"stroke-linecap":t.lineCap,"stroke-linejoin":t.lineJoin,opacity:t.opacity,d:u},o,s,c,l,h,a;this.chartObj.svgRenderer.drawPath(y,this.gSeriesGroupEle);h=ej.EjSvgRender.utils._getTransform(t.xAxis,t.yAxis,this.chartObj.model.requireInvertedAxes);c=Math.min(e.point2.X,e.point1.X)+h.x-i.borderWidth;l=Math.min(e.point2.Y,e.point1.Y)+h.y;e.point1.Y!=e.point2.Y?(o=i.borderWidth+i.borderWidth/2,s=Math.abs(e.point1.Y-e.point2.Y)):(o=Math.abs(e.point2.X-e.point1.X),s=i.borderWidth+i.borderWidth/2);a={X:c,Y:l,Width:o,Height:s};ej.EjSvgRender.utils._addRegion(this.chartObj,a,t,null,f)},isIntersec:function(n,t){return t.Bottom<n.Top||t.Right<n.Left||t.Top>n.Bottom||t.Left>n.Right?!1:!0},IntersectWith:function(t,i,r,u,f,e){var y=this,c,a,o,l,s,h,v;if((ej.util.isNullOrUndefined(t.model.rightsidebounds[f])||ej.util.isNullOrUndefined(t.model.leftsidebounds[f]))&&(t.model.leftsidebounds[f]=[],t.model.rightsidebounds[f]=[],t.model.leftsidebounds[f].points=[],t.model.rightsidebounds[f].points=[]),u=="outsideExtended"){for(o=f;o<t.model.bounds.length;o++)if(t.model._visibleSeries[o].labelPosition.toLowerCase()=="outsideextended"){if(!ej.util.isNullOrUndefined(t.model.bounds[o].points.left)&&t.model.bounds[o].points.left.length>0)for(l=t.model.bounds[o].points.left.length,s=l-1;s>=0&&!ej.util.isNullOrUndefined(t.model.bounds[o].points.left[s]);s--)t.model.leftsidebounds[o].points[s]=t.model.bounds[o].points.left[s];if(!ej.util.isNullOrUndefined(t.model.bounds[o].points.right)&&t.model.bounds[o].points.right.length>0)for(l=t.model.bounds[o].points.right.length,a=0;a<l&&!ej.util.isNullOrUndefined(t.model.bounds[o].points.right[a]);a++)t.model.rightsidebounds[o].points[a]=t.model.bounds[o].points.right[a]}}else if(t.model.bounds[f].points.length>0||f>=0)for(o=f;o<t.model.bounds.length&&!ej.util.isNullOrUndefined(t.model.bounds[o]);o++)if(t.model._visibleSeries[o].labelPosition.toLowerCase()!="outsideextended")for(l=t.model.bounds[o].points.length,s=0;s<l&&!ej.util.isNullOrUndefined(t.model.bounds[o].points[s]);s++)t.model.bounds[o].points[s].X<t.model.circleCenterX[f]?n.inArray(t.model.bounds[o].points[s],t.model.leftsidebounds[o].points)==-1&&(t.model.leftsidebounds[o].points[s]=t.model.bounds[o].points[s]):n.inArray(t.model.bounds[o].points[s],t.model.rightsidebounds[o].points)==-1&&(t.model.rightsidebounds[o].points[s]=t.model.bounds[o].points[s]);for(o=f;o<t.model.bounds.length&&!ej.util.isNullOrUndefined(t.model.bounds[o]);o++)if(t.model.leftsidebounds[o].points.length>0&&(c=t.model.leftsidebounds[o].points,c.length>0))for(s=c.length-1;s>=0;s--)if(h=c[s],!(ej.util.isNullOrUndefined(h)&&h!=r))if(h.SeriesIndex==r.SeriesIndex&&h.PointIndex==r.PointIndex)if(i.smartLabelPosition=="outside")continue;else break;else{if(this.isIntersec(h,r))return!0;r.X<t.model.circleCenterX[f]&&h.X<t.model.circleCenterX[f]&&t.model.series[f].marker.dataLabel.shape!="none"&&(v=Math.abs(h.Y-r.Y),e&&v<=e.height&&h.Bottom>r.Top&&h.Left<r.X&&(r.overlap=!0))}for(o=f;o<t.model.bounds.length&&!ej.util.isNullOrUndefined(t.model.bounds[o]);o++)if(c=t.model.rightsidebounds[o].points,c.length>0)for(s=c.length-1;s>=0;s--)if(h=c[s],!(ej.util.isNullOrUndefined(h)&&h!=r))if(h.SeriesIndex==r.SeriesIndex&&h.PointIndex==r.PointIndex)if(i.smartLabelPosition=="outside")continue;else break;else{if(this.isIntersec(h,r))return!0;r.X>t.model.circleCenterX[f]&&h.X>t.model.circleCenterX[f]&&t.model.series[f].marker.dataLabel.shape!="none"&&(v=Math.abs(h.Y-r.Y),e&&v<=e.height&&h.Bottom>r.Top&&h.X+(h.Right-h.Left)>r.X&&(r.overlap=!0))}return!1},_calculateArcData:function(n,t,i,r,u,f){var u=n.model._isPieOfPie?f:u,ct=r._visiblePoints,ut=i.actualIndex,l=n,p=-.5*Math.PI,e,o,it,rt;r.type.toLowerCase()=="doughnut"&&r._visiblePoints.length==1&&Math.abs(r.endAngle-r.startAngle)==360&&r.startAngle%90!=0?(e=parseFloat((i.startAngle+p).toFixed(3)),o=parseFloat((i.endAngle+p).toFixed(3))-1e-6):(e=i.startAngle+p,o=i.endAngle+p-1e-6);var ft=r.endAngle-r.startAngle,w=o-e<Math.PI?0:1,tt=(e+o)/2;ej.util.isNullOrUndefined(i.currentMidAngle)&&(i.currentMidAngle=(e+o)/2);var b,h,c,v=ft>0?1:0,w=v?o-e<Math.PI?0:1:o-e>-1*Math.PI?0:1,s=l.model.circularRadius[u],a=l.model.innerRadius[u];(ut==r.explodeIndex||r.explodeAll)&&!l.vmlRendering?(h=l.model.circleCenterX[u]+Math.cos(tt)*r.explodeOffset,c=l.model.circleCenterY[u]+Math.sin(tt)*r.explodeOffset):(h=l.model.circleCenterX[u],c=l.model.circleCenterY[u]);var k=h+s*Math.cos(e),d=c+s*Math.sin(e),y=h+s*Math.cos(o),g=c+s*Math.sin(o);if(r.type.toLowerCase()=="doughnut"){var et=h+a*Math.cos(e),ot=c+a*Math.sin(e),nt=h+a*Math.cos(o),st=c+a*Math.sin(o),ht=v?0:1;e<0&&Math.round(i.endAngle-i.startAngle)==6&&(nt=nt-.01,y=y-.01);b="M "+k+" "+d+" A "+s+" "+s+" 0 "+w+" "+v+" "+y+" "+g+" L "+nt+" "+st+" A "+a+" "+a+" 1 "+w+" "+ht+" "+et+" "+ot+" z"}else(i.endAngle-i.startAngle).toFixed(4)==(2*Math.PI).toFixed(4)?(it=h,rt=c,b="M "+k+" "+d+" A "+s+" "+s+" 0 "+w+" "+v+" "+y+" "+g):b="M "+k+" "+d+" A "+s+" "+s+" 0 "+w+" "+v+" "+y+" "+g+" L "+h+" "+c+" z";return{Direction:b,centerX:it,centerY:rt}},getXCordinate:function(n,t,i){return n+t*Math.cos(i)},getYCordinate:function(n,t,i){return n+t*Math.sin(i)},getDoubleRange:function(n,t){var i,r;n>t?(i=t,r=n):(i=n,r=t);var u=r-i,f=(i+r)/2,e=isNaN(i)||isNaN(r);return{Start:i,End:r,Delta:u,Median:f,IsEmpty:e}},isDependentSeries:function(n){var t=n.type.toLowerCase(),i=this.chartObj.model.requireInvertedAxes;return!i||i&&n.isTransposed?t.indexOf("bar")!=-1&&!n._isTransposed||t.indexOf("column")!=-1||t.indexOf("waterfall")!=-1||t.indexOf("hilo")!=-1||t.indexOf("candle")!=-1||t.indexOf("boxandwhisker")!=-1?!0:!1:t.indexOf("bar")!=-1?!0:!1},getPointXYOrgin:function(n,t,i,r){var e=r.model.requireInvertedAxes,u,f;return i.isTransposed&&e||i._isTransposed?(u=(1-ej.EjSvgRender.utils._valueToCoefficient(i.xAxis,n))*i.xAxis.height,f=ej.EjSvgRender.utils._valueToCoefficient(i.yAxis,t)*i.yAxis.width,{X:f,Y:u}):(u=ej.EjSvgRender.utils._valueToCoefficient(i.xAxis,n)*i.xAxis.width,f=(1-ej.EjSvgRender.utils._valueToCoefficient(i.yAxis,t))*i.yAxis.height,{X:u,Y:f})},getRectangle:function(n,t,i,r,u,f){var e=this.getPointXYOrgin(n,t,u,f),o=this.getPointXYOrgin(i,r,u,f);return ej.EjSvgRender.utils._correctRect(e.X,e.Y,o.X,o.Y)},calculateMean:function(n,t,i){var u,f,l,a,v,y,e,o,tt,p,it,rt,w,ut,ft,et,ot=0,c=0,s=[],r=0,b,h,ct;for(n.length>1&&n.sort(function(n,t){return n-t}),b=0;b<n.length;b++)ot=ot+n[b];c=ot/n.length;c=parseInt(c.toFixed(2));s[r]=c;r++;t.boxPlotMode.toLowerCase()=="normal"?(u=n.length%2==0?n.slice(0,n.length/2):n.slice(0,Math.floor(n.length/2)),a=Math.floor(u.length/2),e=u.length%2==0?(u[a-1]+u[a])/2:u[a],e=n.length<=3?n[0]:e,s[r]=e,r++,f=n.length%2==0?n.slice(n.length/2,n.length):n.slice(Math.ceil(n.length/2),n.length),v=Math.floor(f.length/2),o=f.length%2==0?(f[v-1]+f[v])/2:f[v],o=n.length<=3?n[n.length-1]:o,s[r]=o,r++):(t.boxPlotMode.toLowerCase()=="exclusive"||t.boxPlotMode.toLowerCase()=="inclusive")&&(tt=t.boxPlotMode.toLowerCase()=="exclusive"?(n.length+1)/4:(n.length-1)/4,p=Math.floor(tt),it=tt-p,ft=t.boxPlotMode.toLowerCase()=="exclusive"?p-1:p,u=(1-it)*n[ft]+it*n[ft+1],u=n.length<=3?n[0]:u,e=u,s[r]=e,r++,rt=t.boxPlotMode.toLowerCase()=="exclusive"?3*(n.length+1)/4:3*(n.length-1)/4,w=Math.floor(rt),ut=rt-w,et=t.boxPlotMode.toLowerCase()=="exclusive"?w-1:w,f=(1-ut)*n[et]+ut*n[et+1],f=n.length<=3?n[n.length-1]:f,o=f,s[r]=o,r++);y=Math.floor(n.length/2);l=n.length%2==0?(n[y-1]+n[y])/2:n[y];s[r]=l;r++;var st=o-e,lt=o+1.5*st,at=e-1.5*st,k=n[n.length-1],d=n[0],g=[],ht=0,nt=0;for(h=0;h<n.length;h++)lt<n[h]&&(ht++,g[nt]=n[h],nt++,k=n[h-ht]),at>n[h]&&(g[nt]=n[h],nt++,d=n[h+1]);return s[r]=d,r++,s[r]=k,r++,ct={Minimum:d,LowerQuartile:e,midvalue:l,UpperQuartile:o,Maximum:k,boxAverage:c,outliers:g},t._visiblePoints[i].boxPlotValues=ct,t._visiblePoints[i].boxPlotValues.quartileValues=s,{Minimum:d,LowerQuartile:e,midvalue:l,UpperQuartile:o,Maximum:k,boxAverage:c,outliers:g}},calculateBoxAndWhiskerPath:function(n,t,i,r,u,f,e){var y,p,b,k,d;u._visiblePoints[e].boxPlotLocation=[];u._visiblePoints[e].dataLabelLocation=[];var h=0,o=this,w=u._isTransposed,g=u.outlierSettings.shape.toLowerCase(),nt=this.chartObj.model.requireInvertedAxes,s,l,a,v,c;for(y=0;y<u._visiblePoints[e].boxPlotValues.quartileValues.length;y++)l={xValue:f.xValue,YValues:u._visiblePoints[e].boxPlotValues.quartileValues[y]},a=ej.EjSvgRender.utils._getPoint(l,u),u._visiblePoints[e].boxPlotLocation[h]=a,u._visiblePoints[e].boxPlotLocation[h].xValue=l.xValue,u._visiblePoints[e].boxPlotLocation[h].YValues=l.YValues,u._visiblePoints[e].dataLabelLocation[h]=w?{X:a.X,Y:t.Y+t.Height/2+5}:{X:t.X+t.Width/2,Y:a.Y},h++;for(p=0;p<r.outliers.length&&g!="none";p++)v={xValue:f.xValue,YValues:r.outliers[p]},c=ej.EjSvgRender.utils._getPoint(v,u),u._visiblePoints[e].boxPlotLocation[h]=c,u._visiblePoints[e].boxPlotLocation[h].xValue=v.xValue,u._visiblePoints[e].boxPlotLocation[h].YValues=v.YValues,u._visiblePoints[e].boxPlotLocation[h].outlier=!0,w?c.Y=t.Y+t.Height/2:c.X=t.X+t.Width/2,u._visiblePoints[e].dataLabelLocation[h]=w?{X:c.X-u.outlierSettings.size.height,Y:t.Y+t.Height/2+u.outlierSettings.size.width,outlier:!0}:{X:t.X+t.Width/2,Y:c.Y,outlier:!0},h++;return s=u._visiblePoints[e].boxPlotLocation,u._isTransposed?(b="M "+(o.chartObj.canvasX+s[4].X)+" "+(o.chartObj.canvasY+t.Y)+" L "+(s[4].X+o.chartObj.canvasX)+" "+(t.Height+t.Y+o.chartObj.canvasY)+" M "+(o.chartObj.canvasX+s[4].X)+" "+(o.chartObj.canvasY+t.Y+t.Height/2)+" L "+(o.chartObj.canvasX+s[1].X)+" "+(o.chartObj.canvasY+t.Y+t.Height/2)+"  z",k="M "+(o.chartObj.canvasX+s[5].X)+" "+(o.chartObj.canvasY+t.Y)+" L "+(o.chartObj.canvasX+s[5].X)+" "+(t.Height+t.Y+o.chartObj.canvasY)+" M "+(o.chartObj.canvasX+s[5].X)+" "+(o.chartObj.canvasY+t.Y+t.Height/2)+" L "+(o.chartObj.canvasX+s[2].X)+" "+(o.chartObj.canvasY+t.Y+t.Height/2)+"  z"):(b="M "+(o.chartObj.canvasX+t.X)+" "+(o.chartObj.canvasY+s[4].Y)+" L "+(o.chartObj.canvasX+t.X+t.Width)+" "+(o.chartObj.canvasY+s[4].Y)+" M "+(o.chartObj.canvasX+t.X+t.Width/2)+" "+(o.chartObj.canvasY+s[4].Y)+" L "+(o.chartObj.canvasX+t.X+t.Width/2)+" "+(o.chartObj.canvasY+s[1].Y)+"  z",k="M "+(o.chartObj.canvasX+t.X)+" "+(o.chartObj.canvasY+s[5].Y)+" L "+(o.chartObj.canvasX+t.X+t.Width)+" "+(o.chartObj.canvasY+s[5].Y)+" M "+(o.chartObj.canvasX+t.X+t.Width/2)+" "+(o.chartObj.canvasY+s[5].Y)+" L "+(o.chartObj.canvasX+t.X+t.Width/2)+" "+(o.chartObj.canvasY+s[2].Y)+"  z"),d=u._isTransposed?"M "+(o.chartObj.canvasX+s[0].X-5)+" "+(o.chartObj.canvasY+t.Y+t.Height/2-5)+" L "+(o.chartObj.canvasX+s[0].X+5)+" "+(o.chartObj.canvasY+t.Y+t.Height/2+5)+" M "+(o.chartObj.canvasX+s[0].X+5)+" "+(o.chartObj.canvasY+t.Y+t.Height/2-5)+" L "+(o.chartObj.canvasX+s[0].X-5)+" "+(o.chartObj.canvasY+t.Y+t.Height/2+5)+" z":"M "+(o.chartObj.canvasX+t.X+t.Width/2-5)+" "+(o.chartObj.canvasY+s[0].Y-5)+" L "+(o.chartObj.canvasX+t.X+t.Width/2+5)+" "+(o.chartObj.canvasY+s[0].Y+5)+" M "+(o.chartObj.canvasX+t.X+t.Width/2-5)+" "+(o.chartObj.canvasY+s[0].Y+5)+" L "+(o.chartObj.canvasX+t.X+t.Width/2+5)+" "+(o.chartObj.canvasY+s[0].Y-5)+" z",{upperWhisker:k,lowerWhisker:b,mean:d}},calculateSides:function(n,t){var i=n.xValue+t.Start,r=n.xValue+t.End;return{x1:i,x2:r}},_getSeriesPosition:function(n){var o,s,i,r,u,f,t,e;if(ej.util.isNullOrUndefined(n.position)||this.chartObj.model.legendCollapsed){for(i=0,r=[],u=0;u<this.chartObj.model._visibleSeries.length;u++)t=this.chartObj.model._visibleSeries[u],(t.visibility.toLowerCase()==="visible"&&t.drawType.toLowerCase()=="column"||t.drawType.toLowerCase()=="rangecolumn")&&r.push(t);for(f=0;f<r.length;f++)t=r[f],t._xAxisName==this.chartObj.model._axes[0].name&&t._yAxisName==this.chartObj.model._axes[1].name&&(t.isStacking?(o||(s=i,i++,o=!0),t.position=s):(t.position=i,i++));for(e=0;e<r.length;e++)r[e].all=i}return{all:n.all,pos:n.position}},getSideBySidePositions:function(t,i){var h=this,s=[],e=h.chartObj.model,r,u,f,o,c,l,a;return u=f=o=0,c=e._visibleSeries.length,(ej.util.isNullOrUndefined(t.position)||e.legendCollapsed||!i.spacingCalculated)&&(l=e.requireInvertedAxes?e.vAxes:e.hAxes,a=e.requireInvertedAxes?e.hAxes:e.vAxes,n.each(l,function(n,t){var a=[],l,v,y,n;for(r=[],f=0;f<c;f++)l=e._visibleSeries[f],l.visibility.toLowerCase()==="visible"&&h.isDependentSeries(l)&&t.name==l._xAxisName&&a.push(l);for(v=a.length,f=0;f<v;f++)n=e.requireInvertedAxes?a[f].yAxis.columnIndex:a[f].yAxis.rowIndex,r[n]||(r[n]=[],a[f].yAxis.position=null),r[n].push(a[f]);for(u=0;u<r.length;u++)if(!ej.util.isNullOrUndefined(r[u]))for(r[u].all=0,f=0;f<r[u].length;f++)l=r[u][f],l.type.toLowerCase().indexOf("stacking")!=-1?l.stackingGroup?ej.util.isNullOrUndefined(s[l.stackingGroup])?(r[u].all++,l.position=r[u].all,s[l.stackingGroup]=r[u].all):l.position=s[l.stackingGroup]:ej.util.isNullOrUndefined(l.yAxis.position)||e.legendCollapsed?(r[u].all++,l.position=r[u].all,l.yAxis.position=r[u].all,e.legendCollapsed=!1):l.position=l.yAxis.position:(r[u].all++,l.position=r[u].all);for(y=v>0&&a[0].columnWidth,o=0;o<v;o++)n=e.requireInvertedAxes?a[o].yAxis.columnIndex:a[o].yAxis.rowIndex,a[o].all=r[n].all,i.needSpace=i.needSpace||y!=a[o].columnWidth}),i.needSpace&&this.chartObj.model._sideBySideSeriesPlacement&&this._getColumnSpacing(r,i),i.spacingCalculated=!0),{all:t.all,pos:t.position}},getSideBySideInfo:function(n,t){var f;ej.util.isNullOrUndefined(n.xAxis.m_minPointsDelta)&&(this.chartObj.currentSeries=n,n.xAxis.m_minPointsDelta=ej.EjSvgRender.utils.getMinPointsDelta(n.xAxis,this.chartObj));var c=n.columnSpacing,e=n.columnWidth,o=this.getSideBySidePositions(n,t),l=o.pos,s=o.all,u=t.needSpace&&this.chartObj.model._sideBySideSeriesPlacement,r=n.xAxis.m_minPointsDelta*(u?1:e),h=u?t[n.name||n._name].loc:(l-1)/s-.5,i=this.getDoubleRange(h,h+(u?e:1)/s);return this.chartObj.model._sideBySideSeriesPlacement?(i.IsEmpty||(i=this.getDoubleRange(i.Start*r,i.End*r),f=c*i.Delta,i=this.getDoubleRange(i.Start+f/2,i.End-f/2)),i):this.getDoubleRange(-r/2,r/2)},_getColumnSpacing:function(n,t){for(var f=0,u=0,s,i,e,c,o,l=n.length;f<l;f++){var h=0,r={};for(s=n[f].length;u<s;u++)(i=n[f][u]).type.toLowerCase().indexOf("stacking")==-1?h+=i.columnWidth/i.all:r[e=i.stackingGroup]={width:Math.max(i.columnWidth,r[e]?r[e].width:0),all:i.all};for(c in r)h+=r[c].width/r[c].all;for(o=(1-h)/2-.5,u=0,s=n[f].length;u<s;u++)(i=n[f][u]).type.toLowerCase().indexOf("stacking")==-1?(t[i.name||(i._name="series"+f+u)]={loc:o},o+=i.columnWidth/i.all):r[e=i.stackingGroup].loc==null?(t[i.name||(i._name="series"+f+u)]={loc:o+(r[e].width-i.columnWidth)/2/i.all},r[e].loc=t[i.name||i._name].loc+i.columnWidth/2/i.all,o+=r[e].width/i.all):t[i.name||i._name]={loc:r[e].loc-i.columnWidth/2/i.all}}},_getPoint:function(n,t,i,r,u,f,e){var o=n.xValue,s=n.YValues[0];return o=(o-r.min)/r.delta,s=(s-f.min)/f.delta,{X:(u?1-o:o)*t,Y:(1-(e?1-s:s))*i}},_getLogPoint:function(n,t,i,r,u,f,e,o){var s=n.xValue,h=n.YValues[0];return s=o.xAxis._valueType.toLowerCase()=="logarithmic"?(ej.EjSvgRender.utils._logBase(s==0?1:s,o.xAxis.logBase)-r.min)/r.delta:(s-r.min)/r.delta,h=o.yAxis._valueType.toLowerCase()=="logarithmic"?(ej.EjSvgRender.utils._logBase(h==0?1:h,o.yAxis.logBase)-f.min)/f.delta:(h-f.min)/f.delta,{X:(u?1-s:s)*t,Y:(1-(e?1-h:h))*i}},_getTransposedPoint:function(n,t,i,r,u,f,e){var o=n.xValue,s=n.YValues[0];return o=(o-r.min)/r.delta,s=(s-f.min)/f.delta,{X:(e?1-s:s)*i,Y:(1-(u?1-o:o))*t}},_getTransposedLogPoint:function(n,t,i,r,u,f,e,o){var s=n.xValue,h=n.YValues[0];return s=o.xAxis._valueType.toLowerCase()=="logarithmic"?(ej.EjSvgRender.utils._logBase(s==0?1:s,o.xAxis.logBase)-r.min)/r.delta:(s-r.min)/r.delta,h=o.yAxis._valueType.toLowerCase()=="logarithmic"?(ej.EjSvgRender.utils._logBase(h==0?1:h,o.yAxis.logBase)-f.min)/f.delta:(h-f.min)/f.delta,{X:(e?1-h:h)*i,Y:(1-(u?1-s:s))*t}},draw:function(t,i){var v=ej.EjSvgRender.utils._getStringBuilder(),u,d,r,et,y,b,k,e,f,o=t.canvasX,s=t.canvasY,p,a,h,g,ot,c,w,nt,st=t.model.requireInvertedAxes,bt=0,tt=t.model.enableCanvasRendering,ht=t,l,kt=i.xAxis._valueType.toLowerCase()=="logarithmic"||i.yAxis._valueType.toLowerCase()=="logarithmic",it=i._isTransposed,ct=it?i.xAxis.height:i.xAxis.width,lt=it?i.yAxis.width:i.yAxis.height,at=i.xAxis.visibleRange,vt=i.yAxis.visibleRange,yt=i.xAxis.isInversed,pt=i.yAxis.isInversed,rt,wt=this["_get"+(it?"Transposed":"")+(kt?"Log":"")+"Point"],ut,ft;if(this.chartObj=t,rt=this.setLineSeriesStyle(i),i._animationType="path",i.sorting&&(i.points=ej.DataManager(i.points,ej.Query().sortBy("xValue")).executeLocal()),i._visiblePoints=undefined,u=this.improveChartPerformance(i),d={min:0,max:u.length},i.pointFill)for(p=n.inArray(i,this.chartObj.model._visibleSeries),g=u.length-1,l=ej.EjSvgRender.utils._getTransform(i.xAxis,i.yAxis,st),o=ht.canvasX,s=ht.canvasY,ot={id:this.chartObj.svgObject.id+"_SeriesGroup_"+p,transform:"translate("+l.x+","+l.y+")"},this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(ot),r=0;r<g;r++)(nt=u[r],a=u[r+1],c||(c=this.chartObj.setStyle(this,i,p,r,undefined,u)),a.visible&&nt.visible&&(e=ej.EjSvgRender.utils._getPoint(nt,i),f=ej.EjSvgRender.utils._getPoint(a,i),v.append("M "+(e.X+o)+" "+(e.Y+s)+" L "+(f.X+o)+" "+(f.Y+s)+" ")),w=this.chartObj.setStyle(this,i,p,r+1,undefined,u),w.interior==c.interior&&r!=g-1&&a.visible)||(et={name:i.type,id:this.chartObj.svgObject.id+"_Series"+p+"_Point"+bt++,"stroke-dasharray":c.dashArray,fill:"none","stroke-width":c.width,"stroke-linecap":i.lineCap,"stroke-linejoin":i.lineJoin,stroke:c.interior,opacity:c.opacity,d:v.toString()},this.chartObj.svgRenderer.drawPath(et,this.gSeriesGroupEle),v=ej.EjSvgRender.utils._getStringBuilder(),c=w);else{for(tt&&(h=t.svgRenderer.ctx,h.save(),h.beginPath(),t.model.AreaType=="cartesianaxes"&&(l=ej.EjSvgRender.utils._getTransform(i.xAxis,i.yAxis,st),l="translate("+l.x+","+l.y+")"),w={"stroke-dasharray":i.dashArray,"stroke-width":i.width,stroke:rt.SeriesInterior,"stroke-linecap":i.lineCap,"stroke-linejoin":i.lineJoin,opacity:i.opacity},t.svgRenderer._setLinePathStyle(w,l)),y=null,b,k=-1,ut="M ",r=d.min;r<d.max;r++)b=u[r],b.visible!==!1?(y!=null&&u.length>k+1&&(a=u[k+1],e=wt(y,ct,lt,at,yt,vt,pt,i),f=wt(a,ct,lt,at,yt,vt,pt,i),tt?(ft&&(h.lineTo(f.X+o,f.Y+s),ft=null),h.moveTo(e.X+o,e.Y+s),h.lineTo(f.X+o,f.Y+s),ft=f):(v.append(ut+(e.X+o)+" "+(e.Y+s)+" L "+(f.X+o)+" "+(f.Y+s)+" "),ut="L ")),y=b,k=r):y=null;tt?(h.stroke(),h.restore()):this._drawLinePath(i,rt,v.toString())}this.chartObj.dragPoint?this.chartObj.svgRenderer.append(this.chartObj.gPreviewSeriesGroupEle,this.chartObj.gSeriesEle):this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle);i._visiblePoints=i._dataLabels>0||i.marker&&i.marker.dataLabel.visible==!0&&i.enableSmartLabels?this._isVisiblePoints(i):u},doCircularAnimation:function(t,i,r,u,f){var e=i.type.toLowerCase();if(e=="pie"||e=="doughnut"||e=="pieofpie"){var o=this,h,c,s=i.points[0]?i.points[0].startAngle:0,l=t.model._isPieOfPie?i.collectionIndex:0,a=i.emptyPointSettings.visible?i.visiblePoints:i._visiblePoints;f=ej.util.isNullOrUndefined(f)?1200:f;n.each(a,function(r,a){h=a.startAngle;c=a.endAngle;t.model._radius=t.model._isPieOfPie?t.model.circularRadius[l]:t.model.circularRadius[u];a.startAngle=0;a.endAngle=a.startAngle;t.model.Radius=0;var v=n(t.gSeriesEle).find("#"+t.svgObject.id+"_SeriesGroup_"+u)[l].childNodes[r];e=="pie"||e=="pieofpie"?n(v).each(function(){this.StartAngle=s;this.EndAngle=s}).animate({StartAngle:h,EndAngle:c,pieRadius:t.model._radius},{duration:f,queue:!1,step:function(f,e){if(e.prop.toString()==="StartAngle"?(a.startAngle=f,a.endAngle=a.startAngle):e.prop.toString()=="pieRadius"&&t.model?t.model.Radius=f:a.endAngle=f,t.model){var s=o._calculateArcData(t,r,a,i,u,l);t.svgRenderer._setAttr(n(v),{d:s.Direction});t.model.Radius=t.model._radius}},complete:function(){o.circularAnimationComplete(r,t,i)}}):n(v).each(function(){this.StartAngle=s;this.EndAngle=s}).animate({StartAngle:h,EndAngle:c},{duration:f,queue:!1,step:function(f,e){if(e.prop.toString()==="StartAngle"?(a.startAngle=f,a.endAngle=a.startAngle):a.endAngle=f,t.model){var s=o._calculateArcData(t,r,a,i,u);t.svgRenderer._setAttr(n(v),{d:s.Direction});t.model.Radius=t.model._radius}},complete:function(){o.circularAnimationComplete(r,t,i)}})})}},circularAnimationComplete:function(t,i,r){if(!ej.util.isNullOrUndefined(i.model)){var e,f,u=n.inArray(r,i.model._visibleSeries),o;if(i.gSeriesTextEle[u]&&i.svgRenderer._setAttr(n(i.gSeriesEle).find("#"+i.gSeriesTextEle[u].id),{visibility:"visible"}),i.gSymbolGroupEle[u]&&i.svgRenderer._setAttr(n(i.gSeriesEle).find("#"+i.gSymbolGroupEle[u].id),{visibility:"visible"}),i.gDataLabelEle[u]&&i.svgRenderer._setAttr(n(i.gSeriesEle).find("#"+i.gDataLabelEle[u].id),{visibility:"visible"}),r.marker.dataLabel.template)for(o=n(i.element[0].childNodes[0].childNodes),f=0;f<o.length;f++)n(o[f]).css("display","block");i.gConnectorEle[u]&&i.svgRenderer._setAttr(n(i.gSeriesEle).find("#"+i.gConnectorEle[u].id),{visibility:"visible"});i.gConnectorLinesGroup&&i.svgRenderer._setAttr(n(i.gSeriesEle).find("#"+i.gConnectorLinesGroup.id),{visibility:"visible"});i.model.AnimationComplete=!0;r.AnimationComplete=!0;e=n.extend({},ej.EjSvgRender.commonChartEventArgs);e.data={series:r};i._trigger("animationComplete",e)}},_doLineSymbol:function(t,i,r,u,f,e,o){if(t.tagName!="defs"){var p=parseInt(r*i),s=this.chartObj==undefined?e:this.chartObj,h=ej.EjSvgRender.utils._getBoundingClientRect(t,s,u,f),a=h.x+h.width/2,v=h.y+h.height/2,y,c=n(t),l=s.svgRenderer._getAttrVal(c,"transform");l=ej.util.isNullOrUndefined(l)?" ":l;s.svgRenderer._setAttr(c,{transform:"scale(0)"});c.delay(p).animate({scales:1},{duration:o,step:function(n){y=n;s.svgRenderer._setAttr(c,{transform:"translate("+a+" "+v+") scale("+y+") translate("+-a+" "+-v+")"+l})}})}},animateSymbol:function(t,i,r,u,f,e){if(t.tagName!="defs"){var h=this.chartObj==undefined?f:this.chartObj,o=ej.EjSvgRender.utils._getBoundingClientRect(t,h,r,u),l=o.x+o.width/2,a=o.y+o.height/2,v,c=n(t),s=h.svgRenderer._getAttrVal(c,"transform");s=ej.util.isNullOrUndefined(s)?" ":s;c.delay(i).each(function(){this.scale=.5}).animate({scales:1},{duration:e,step:function(n){v=n;h.svgRenderer._setAttr(c,{transform:"translate("+l+" "+a+") scale("+v+") translate("+-l+" "+-a+")"+s})}})}},animateCylinder:function(t,i,r,u,f){var o,e;i.isTransposed&&r?(o=u[0].width.animVal.value,t.model.series[0].type.indexOf("bar")>-1?(t.svgRenderer._setAttr(n(u),{x:o}),n(u).animate({x:0},f,function(){})):(e=u[0].height.animVal.value,t.svgRenderer._setAttr(n(u),{y:0}),n(u).animate({y:parseFloat(t.svgRenderer._getAttrVal(u,"y")),height:parseFloat(t.svgRenderer._getAttrVal(u,"height"))},{duration:f,step:function(i){t.svgRenderer._setAttr(n(u),{y:e-i});t.svgRenderer._setAttr(n(u),{height:i})}}))):t.model.series[0].type.indexOf("bar")>-1?n(u).animate({width:parseFloat(t.svgRenderer._getAttrVal(u,"width"))},{duration:f,step:function(i){t.svgRenderer._setAttr(n(u),{width:i})}}):(e=u[0].height.animVal.value,t.svgRenderer._setAttr(n(u),{y:e}),n(u).animate({y:0},f,function(){}))},animateRect:function(t,i,r,u,f){var a=i.animationType.toLowerCase(),e=ej.EjSvgRender.utils._getBoundingClientRect(a=="smooth"?t[0]:t,u,i,r),h,c,y,p,w,s=n(t),o,v,l;i.isTransposed&&r||r?(o=a=="smooth"?parseFloat(u.svgRenderer._getAttrVal(t,"width")):0,v=!0,u.svgRenderer._getAttrVal(s,"plot")==="negative"?(h=e.x+e.width,c=e.y+e.height):(h=e.x,c=e.y),y=") scale(",p=",1) translate("):(o=a=="smooth"?parseFloat(u.svgRenderer._getAttrVal(t,"height")):0,v=!1,u.svgRenderer._getAttrVal(s,"plot")==="negative"?(h=e.x,c=e.y):(h=e.x+e.width,c=e.y+e.height),y=") scale(1,",p=") translate(");l=Math.abs(ej.EjSvgRender.utils._getPointXY(i.yAxis.visibleRange.min<0?0:i.yAxis.visibleRange.min,i.yAxis.visibleRange,i.yAxis.isInversed)*(v?i.yAxis.width:i.yAxis.height));s.animate({scales:a=="smooth"?o:1},{duration:f,complete:function(){i.type.toLowerCase()=="waterfall"&&n("#"+u.svgObject.id+"_SeriesGroup_waterfallLine_"+i.index).attr("visibility","visible")},step:function(n){w=n;a=="smooth"?(n&&(v?u.svgRenderer._setAttr(s,{width:l+n>=o?o:n}):u.svgRenderer._setAttr(s,{height:n})),v?u.svgRenderer._setAttr(s,{x:l+n>=o?o-n:l}):u.svgRenderer._setAttr(s,{y:o-l-n>=0?o-l-n:0})):u.svgRenderer._setAttr(s,{transform:"translate("+h+" "+c+y+w+p+-h+" "+-c+")"})}})},animateStackingRect:function(t,i,r,u,f){var e,o,s,h,c=n(t),l,a,v,y=ej.EjSvgRender.utils._getBoundingClientRect(t,u,i,r);i.isTransposed&&r||r?(l=ej.EjSvgRender.utils._valueToCoefficient(i.yAxis,0)*i.yAxis.width,e=l,o=y.y,s=") scale(",h=",1) translate("):(a=(1-ej.EjSvgRender.utils._valueToCoefficient(i.yAxis,0))*i.yAxis.height,e=y.x,o=a,s=") scale(1,",h=") translate(");c.animate({scales:1},{duration:f,step:function(n){v=n;u.svgRenderer._setAttr(c,{transform:"translate("+e+" "+o+s+v+h+-e+" "+-o+")"})}})},_doLineAnimation:function(t,i,r){var r=ej.util.isNullOrUndefined(r)?2e3:r,f=t.model.primaryXAxis.isInversed,e=parseFloat(t.svgRenderer._getAttrVal(i,"width")),u;t.model.requireInvertedAxes?(u=parseFloat(t.svgRenderer._getAttrVal(i,"height")),n(i).animate({clipRectHeight:parseFloat(t.svgRenderer._getAttrVal(i,"height"))},{duration:r,step:function(r){t.svgRenderer._setAttr(n(i),{y:u-r});t.svgRenderer._setAttr(n(i),{height:r})}})):n(i).animate({clipRectWidth:parseFloat(t.svgRenderer._getAttrVal(i,"width"))},{duration:r,step:function(r){f&&t.svgRenderer._setAttr(n(i),{x:e-r});t.svgRenderer._setAttr(n(i),{width:r})}})},_drawLinePath:function(t,i,r){var h=this.chartObj.model.requireInvertedAxes,f,e=n.inArray(t,this.chartObj.model._visibleSeries),o=null,s,u;this.chartObj.model.AreaType=="cartesianaxes"&&(f=ej.EjSvgRender.utils._getTransform(t.xAxis,t.yAxis,h),o="translate("+f.x+","+f.y+")");s={id:this.chartObj.svgObject.id+"_SeriesGroup_"+e,transform:o};this.chartObj.gSeriesGroupEle=this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(s);r!=""&&r.indexOf("NaN")==-1&&(u={id:this.chartObj.svgObject.id+"_Series"+e,fill:"none","stroke-dasharray":t.dashArray,"stroke-width":t.width,stroke:i.SeriesInterior,"stroke-linecap":t.lineCap,"stroke-linejoin":t.lineJoin,opacity:t.opacity,d:r},this.chartObj.dragPoint?(u.id=this.chartObj.svgObject.id+"_PreviewSeries"+e,u.opacity=.6,this.chartObj.model.enableCanvasRendering?this.chartObj.svgRenderer.drawPath(u,this.chartObj.canvasElement,o):this.chartObj.svgRenderer.drawPath(u,this.chartObj.gPreviewSeriesGroupEle)):this.chartObj.svgRenderer.drawPath(u,this.gSeriesGroupEle))},_applySaturation:function(n,t){var r,u,i;return r=ej.EjSvgRender.prototype.checkColorFormat(t),r||(t=n.colorNameToHex(t)),i=ej.EjSvgRender.prototype.hexToRGB(t),u=Math.round((parseInt(i.R)*299+parseInt(i.G)*587+parseInt(i.B)*114)/1e3),u>=128?"black":"white"},drawDataLabel:function(t,i,r,u,f,e,o,s){var ci,et,g,ii,yi,nt,pi,ri,ui;r.marker=r.marker?r.marker:{};var ct=t.yAxis.labelFormat,yt,fi=20,nr=t.yAxis.valueType,lt,rt,ot,tt,st,at,b,ei,wi=t._visiblePoints[i].boxPlotValues,dt=t.type.toLowerCase()=="waterfall"&&(r.showIntermediateSum||r.showTotalSum)?r.waterfallSum:r.y;r.text?lt=r.text:ct?ct.indexOf("{value}")>-1?lt=ct.replace("{value}",dt):ct.indexOf("e")==0||ct.indexOf("E")==0?(yt=ct.match(/(\d+)/g),yt=yt==null?6:yt>fi?fi:yt,lt=dt.toExponential(yt)):lt=ej.format(dt,ct,this.chartObj.model.locale):lt=dt;var c=this.chartObj,a=c.model,v=n.inArray(t,a._visibleSeries),oi,ut,ft,kt=n.extend(!0,{},t.marker,r.marker),it=kt.dataLabel,pt=a.m_AreaBounds,l=it.font,d=it.textPosition.toLowerCase(),vt=it.textAnchor.toLowerCase(),wt=t.type.toLowerCase(),si=a.enableCanvasRendering,bi=ej.seriesTypes[wt].prototype.isRegion,ki=ej.util.isNullOrUndefined(l.size)?"11px":l.size,di=ej.util.isNullOrUndefined(l.fontStyle)?"Normal":l.fontStyle,gi=ej.util.isNullOrUndefined(l.fontFamily)?"Segoe UI":l.fontFamily,hi={size:ki,fontStyle:di,fontFamily:gi},y=ej.EjSvgRender.utils._measureText(lt,null,hi);degree=it.angle;padding=10;angle=degree>360?degree-360:degree<-360?degree+360:degree;d=="middle"&&(angle==-90||angle==90)&&(ci=c.model.chartRegions[e].Region.Bounds,y.width>ci.Height?d="bottom":d=="middle");var li=this.textPosition(t,v,r,y,wt,u,f,e,i,o,d),h=n.extend({},ej.EjSvgRender.commonChartEventArgs),ni=it.enableContrastColor,k=a.chartArea.background.toLowerCase(),ht=a.background.toLowerCase();h.data={text:lt,location:{x:li.x+c.canvasX,y:li.y+c.canvasY},seriesIndex:v,pointIndex:i};t.isStacking&&t.drawType=="area"&&(t.type=="polar"||t.type=="radar")&&(h.data.text=t.stackedValue.EndValues[i]-t.stackedValue.StartValues[i]);c._trigger("displayTextRendering",h);var ai=kt.dataLabel.offset.y==undefined?kt.dataLabel.offset:kt.dataLabel.offset.y,vi=kt.dataLabel.offset.x,y=ej.EjSvgRender.utils._measureText(h.data.text,null,hi);if(h.data.location.y=d=="bottom"?h.data.location.y+ai:h.data.location.y-ai,vi&&(h.data.location.x=h.data.location.x+vi),(angle==90||angle==-90)&&(d=="bottom"?(vt=angle==-90?"start":"end",h.data.location.y=h.data.location.y+padding/2):d=="top"&&(vt=="middle"||vt=="start"?(vt=angle==-90?"start":"end",h.data.location.y=h.data.location.y+padding):(vt="end",h.data.location.y=h.data.location.y+padding*2))),!h.cancel){var p={id:c.svgObject.id+"_SeriesText"+i+v,x:h.data.location.x,y:h.data.location.y,fill:l.color,"font-size":l.size,"font-family":l.fontFamily,"font-style":l.fontStyle,"font-weight":l.fontWeight,opacity:l.opacity,"text-anchor":vt},w=it.margin,gt=y.width+w.left+w.right,bt=y.height+w.top+w.bottom,ti={X:h.data.location.x,Y:h.data.location.y};if(ej.util.isNullOrUndefined(it.template)?(oi=it.shape?it.shape:"None",n.each(a.symbolShape,function(n){oi.toLowerCase()==n.toLowerCase()&&(ft=n)}),et=h.data.location.x-w.left/2+w.right/2,g=h.data.location.y-w.top/2-bt/w.top+w.bottom/2,a.enableCanvasRendering&&degree%360!=0&&(p.y-=y.height/4,p.baseline="middle"),it.showEdgeLabels&&(rt=si?p.x-c.canvasX:p.x,ot=si?p.y-c.canvasY:p.y,(angle==90||angle==-90)&&(y.width=[y.height,y.height=y.width][0]),tt=y.width,st=y.height,ii=t._visiblePoints[t._visiblePoints.length-1]==r&&rt+tt/2>=c.model.m_AreaBounds.Width,(rt-tt/2<0||rt<-tt/2)&&ii?(at=rt-tt/2,p.x=et=Math.abs(at)+(ii?-10:rt+10)):(rt+tt/2>pt.textWidth||rt+tt/2>pt.textWidth+tt/2)&&(at=rt-tt/2,p.x=et=pt.textWidth-tt/2-10),ot+st/2>pt.textHeight||ot+st/2>pt.textHeight+st/2?(at=ot+st/2-pt.textHeight,g=ot-at-10,p.y=g+5):(ot-st/2<0||ot<-st/2)&&(at=ot-st/2,g+=Math.abs(at)+10,p.y=g+5)),t._enableSmartLabels&&(r.dataLabel={textX:p.x,textY:p.y,x:et,y:g,width:gt,height:bt},r.margin={top:w.top,bottom:w.bottom}),b=jQuery.type(a.seriesColors[v])=="array"?a.seriesColors[v][0].color:a.seriesColors[v],b=r.fill?jQuery.type(r.fill)=="array"?r.fill[0].color:r.fill:b,ni&&(ut=!bi||d=="top"?k==="transparent"&&ht==="transparent"?"white":k!="transparent"?k:ht:b,p.fill=this._applySaturation(c,ut)),r.y!=r.low||r.y===undefined&&r.low===undefined?wt.toLowerCase()=="boxandwhisker"&&wi.midvalue!=r.y?(yi={id:c.svgObject.id+"_SeriesText"+i+v,x:ej.util.isNullOrUndefined(s)?h.data.location.x:et,y:ej.util.isNullOrUndefined(s)?h.data.location.y:g,fill:l.color,"font-size":l.size,"font-family":l.fontFamily,"font-style":l.fontStyle,"font-weight":l.fontWeight,opacity:l.opacity,"text-anchor":vt},nt=r.textOptionsBoxValues.length,r.textOptionsBoxValues[nt]=yi,angle!=0&&(r.textOptionsBoxValues[nt].angle=angle),r.textOptionsBoxValues[nt].drawText=h.data.text,r.textOptionsBoxValues[nt].index=i,r.textOptionsBoxValues[nt].xPos=ej.util.isNullOrUndefined(s)?et:et-w.left/2+w.right/2,r.textOptionsBoxValues[nt].yPos=ej.util.isNullOrUndefined(s)?g:g-w.top/2-bt/w.top+w.bottom/2,r.textOptionsBoxValues[nt].seriesIndex=v,r.textOptionsBoxValues[nt].width=ft=="None"?y.width:gt,r.textOptionsBoxValues[nt].height=ft=="None"?y.height:bt,r.textOptionsBoxValues[nt].symbolName=ft):(r.textOptions=p,angle!=0&&(r.textOptions.angle=angle),r.drawText=h.data.text,r.index=i,r.xPos=et,r.yPos=g,r.seriesIndex=v,r.width=ft=="None"?y.width:gt,r.height=ft=="None"?y.height:bt,(angle==90||angle==-90)&&(r.width=[r.height,r.height=r.width][0]),r.symbolName=ft):(r.xPosLow=et,r.yPosLow=g,r.widthLow=ft=="None"?y.width:gt,r.heightLow=ft=="None"?y.height:bt,r.textOptionsLow=p,r.textOptionsLow.angle=angle,r.drawTextLow=h.data.text)):(ti.X-=c.canvasX,ti.Y-=c.canvasY,this.drawLabelTemplate(t,r,i,ti,c)),(wt.indexOf("column")>-1||wt.indexOf("bar")>-1)&&ni)if(pi=c.model.chartRegions[e],ri=o.stackingGroup,d=="top"&&wt.indexOf("stacking")>-1){if(ej.util.isNullOrUndefined(t.stackingGroup)||t.stackingGroup=="")v<a._visibleSeries.length-1?(b=jQuery.type(a.seriesColors[v+1])=="array"?a.seriesColors[v+1][0].color:a.seriesColors[v+1],b=r.fill?jQuery.type(r.fill)=="array"?r.fill[0].color:r.fill:b,ut=b):ut=k==="transparent"&&ht==="transparent"?"white":k!="transparent"?k:ht;else for(ui in ri)if(ui==t.stackingGroup&&v<ri[ui].length-1){b=jQuery.type(a.seriesColors[v+1])=="array"?a.seriesColors[v+1][0].color:a.seriesColors[v+1];b=r.fill?jQuery.type(r.fill)=="array"?r.fill[0].color:r.fill:b;ut=b;break}else{ut=k==="transparent"&&ht==="transparent"?"white":k!="transparent"?k:ht;break}p.fill=this._applySaturation(c,ut)}else ei=ej.ejChart.isCollide(pi,r,0,ni,c),d!="bottom"&&d!="middle"||ei.state||(ut=k==="transparent"&&ht==="transparent"?"white":k!="transparent"?k:ht,p.fill=this._applySaturation(c,ut))}},updateSmartLabelPosition:function(t,i,r,u,f,e,o,s,h,c){var a=[],d=h,y=d.model,ti=y.legend,ei=y.LegendActualBounds,oi=ti.position.toLowerCase(),g=new ej.seriesTypes[t.type.toLowerCase()],ut="",kt="",st=u.connector.connectorX,ht=u.connector.connectorY,v=u.midPoint.midX,p=u.midPoint.midY,pi=u.doughnutMidPoint.dMidX,wi=u.doughnutMidPoint.dMidY,b=e.startX,ct=e.startY,si=n.extend(!0,{},t.marker,i.marker),dt=si.dataLabel.template?0:4,lt,k,nt,at,rt=f,hi=t.startAngle>t.endAngle?-.01:.01,ii=si.dataLabel.connectorLine.type.toLowerCase(),vt,vi=t.type.toLowerCase(),w=y._isPieOfPie?y.circularRadius[t.collectionIndex]:y.circularRadius[c],ri=vi=="pieofpie"?"inside":t.labelPosition.toLowerCase(),ci,li,ft,et,yt,ai,tt,gt,it,pt,bt,ui,ni,fi,wt,ot;if(ej.util.isNullOrUndefined(y.bounds[c])&&(y.bounds[c]=[],y.bounds[c].points=[],ri=="outsideextended"&&(y.bounds[c].points.left=[],y.bounds[c].points.right=[])),ri=="inside"&&ej.util.isNullOrUndefined(i.smartLabelPosition)){k=(v+b)/2;nt=(p+ct)/2;k=(v+k)/2;nt=(p+nt)/2;l=i.isIntersected&&y.bounds[c].points[i.index]?y.bounds[c].points[i.index]:v>b?{X:k,Y:nt,Left:k,Top:nt,Right:k+s.width,Bottom:nt+s.height,SeriesIndex:c,PointIndex:r}:{X:k,Y:nt,Left:k-s.width,Top:nt,Right:k,Bottom:nt+s.height,SeriesIndex:c,PointIndex:r};do(at=!1,this.IntersectWith(d,i,l,"inside",c))&&((vt=l.Left,ci=f*180/Math.PI,li=rt*180/Math.PI,li-ci>=270)||(rt+=hi,i.isIntersected=!0,l.Angle=rt,v>b?(l.X=l.Left=g.getXCordinate(b,w+o,rt),l.Right=l.X+s.width):(l.X=l.Right=g.getXCordinate(b,w+o,rt),l.Left=l.Right-s.width),l.Y=l.Top=g.getYCordinate(ct,w+o,rt),l.Bottom=l.Y+s.height,at=!0));while(at);v>b&&l.X<b&&(l.Right=vt,l.Left=vt-s.width);y.bounds[c].points[r]=l;i.isIntersected&&y.bounds[c].points[r].Angle&&(k=g.getXCordinate(b,w+o,y.bounds[c].points[r].Angle),nt=g.getYCordinate(ct,w+o,y.bounds[c].points[r].Angle),ft=g.getXCordinate(b,w+o/3,f),et=g.getYCordinate(ct,w+o/3,f),a.push({X:v,Y:p}),a.push({X:ft,Y:et}),a.push({X:k,Y:nt}),i.isIntersected&&ii=="bezier"&&!d.vmlRendering&&(kt=g.drawBezierSegment(a,t,r,d,c)),ut="M "+v+" "+p+" L "+ft+" "+et+" M "+ft+" "+et+" L "+k+" "+nt)}else if(ri=="outside"||i.smartLabelPosition=="outside"){l=v>=b?{X:st,Y:ht,Left:st,Top:ht,Right:st+s.width,Bottom:ht+s.height,SeriesIndex:c,PointIndex:r}:{X:st,Y:ht,Left:st-s.width,Top:ht,Right:st,Bottom:ht+s.height,SeriesIndex:c,PointIndex:r};do(at=!1,this.IntersectWith(d,i,l,"outside",c,s))&&(vt=l.Left,rt+=hi,i.isIntersected=!0,v>b?(l.X=l.Left=g.getXCordinate(b,w+o,rt),l.Right=l.X+s.width):(l.X=l.Right=g.getXCordinate(b,w+o,rt),l.Left=l.Right-s.width),l.Y=l.Top=g.getYCordinate(ct,w+o,rt),l.Bottom=l.Y+s.height,at=!0);while(at);v>b&&l.X<b&&(l.Right=vt,l.Left=vt-s.width);y.bounds[c].points[r]=l;ft=g.getXCordinate(b,w+o/3,f);et=g.getYCordinate(ct,w+o/3,f);a.push({X:v,Y:p});a.push({X:ft,Y:et});a.push({X:l.X,Y:l.Y});k=l.X;nt=l.Y;o>0&&(v<b?(lt=l.X-y.elementSpacing,k=lt-dt):(lt=l.X+y.elementSpacing,k=lt+dt),a.push({X:lt,Y:l.Y}));ii!="bezier"||d.vmlRendering?ut="M "+v+" "+p+" L "+ft+" "+et+" M "+ft+" "+et+" L "+l.X+" "+l.Y+" M "+l.X+" "+l.Y+" L "+lt+" "+l.Y:kt=g.drawBezierSegment(a,t,r,d,c)}else{yt=v;ai=p;v=v+Math.cos(f)*-(w/10);p=p+Math.sin(f)*-(w/10);tt=w/4;a.push({X:v,Y:p});v=v+Math.cos(f)*tt;p=p+Math.sin(f)*tt;a.push({X:v,Y:p});gt=ti.visible&&oi=="left"?y.margin.left+ei.Width:0;it=y.circleCenterX[c];v<b?(v=(it-w-tt*2-t.LeftLabelMaxWidth>0?it-w-tt*2+gt:t.LeftLabelMaxWidth>yt?yt:t.LeftLabelMaxWidth+gt)-s.width/2,pt=a[1].X-t.LeftLabelMaxWidth,ni=it-w-tt*2-t.LeftLabelMaxWidth>0?tt:t.LeftLabelMaxWidth>yt?0:pt>3*(tt/2)?tt:pt/2,bt=+s.width/2):(ui=ti.visible&&oi=="right"?y.margin.right+ei.Width:0,v=(it+w+tt*2+t.RightLabelMaxWidth<n(d.svgObject).width()-ui?it+w+tt*2-gt:it+w+t.RightLabelMaxWidth>n(d.svgObject).width()?yt:n(d.svgObject).width()-t.RightLabelMaxWidth-ui)+s.width/2,pt=n(d.svgObject).width()-t.RightLabelMaxWidth-a[1].X,ni=it+w+tt*2+t.RightLabelMaxWidth<n(d.svgObject).width()?tt:it+w+t.RightLabelMaxWidth>n(d.svgObject).width()?0:pt>3*(tt/2)?tt:pt/2,bt=-s.width/2);fi=Math.sqrt(Math.pow(yt-v,2)+Math.pow(ai-p,2))/10;wt=v<b?!0:!1;v=wt?v+fi:v-fi;var bi=wt?1:-1,u=wt?y.bounds[c].points.left:y.bounds[c].points.right,l={X:v,Y:p,Left:v,Top:p,Right:v+s.width,Bottom:p+s.height,index:r,SeriesIndex:c,PointIndex:r},yi=t.endAngle>t.startAngle?!0:!1;if(this.IntersectWith(d,i,l,"outsideExtended",c)&&(a.push(v<b?{X:v+ni+bt,Y:p}:{X:v-ni+bt,Y:p}),p=yi||t.startAngle==null?u[u.length-1].Y+s.height+2:wt?u[u.length-1].Y-s.height-2:u[u.length-1].Y+s.height+2,l.Y=p,l.Top=p,l.Bottom=p+s.height),a.push({X:v+bt,Y:p}),it<a[0].X&&a[1].X>a[2].X&&(a[2].X=a[1].X),it>a[0].X&&a[1].X<a[2].X&&(a[2].X=a[1].X),wt?(y.bounds[c].points.left||(y.bounds[c].points.left=[]),y.bounds[c].points.left.push(l),a[a.length-1].X>a[a.length-2].X&&(a[a.length-2].X=a[a.length-1].X)):(y.bounds[c].points.right||(y.bounds[c].points.right=[]),y.bounds[c].points.right.push(l),a[a.length-1].X<a[a.length-2].X&&(a[a.length-2].X=a[a.length-1].X)),ut=ej.EjSvgRender.utils._getStringBuilder(),ii!="bezier"||d.vmlRendering){for(ot=0;ot<a.length;ot++)ot==a.length-1?ut.append(" "):ut.append("M "+a[ot].X+" "+a[ot].Y+" L "+a[ot+1].X+" "+a[ot+1].Y+" ");ut=ut.toString()}else kt=g.drawBezierSegment(a,t,r,d,c);k=a[a.length-1].X+(v<b?-dt:dt);nt=a[a.length-1].Y}return{positionX:k,positionY:nt,connectorDirection:ut,isInterSected:i.isIntersected,bezierPath:kt}},updateLabelPosition:function(t,i,r,u,f,e,o,s,h,c){var l=[],a=h,st=new ej.seriesTypes[t.type.toLowerCase()],g="",y=u.connector.connectorX,w=u.connector.connectorY,v=u.midPoint.midX,p=u.midPoint.midY,ct=u.doughnutMidPoint.dMidX,lt=u.doughnutMidPoint.dMidY,rt=e.startX,at=e.startY,et=n.extend(!0,{},t.marker,i.marker),ut=et.dataLabel.template?0:4,it,b,nt,ft,vt,yt=t.type.toLowerCase(),k=a.model.circularRadius[c],ht=yt=="pieofpie"?"inside":t.labelPosition.toLowerCase(),tt,ot,d;if(l.push({X:v,Y:p}),l.push({X:y,Y:w}),b=y,nt=w,ht=="outside")o>0&&(y<rt?(it=y-a.model.elementSpacing,b=it-ut):(it=y+a.model.elementSpacing,b=it+ut),l.push({X:it,Y:w})),et.dataLabel.connectorLine.type.toLowerCase()!="bezier"||a.vmlRendering?g="M "+v+" "+p+" L "+y+" "+w+" M "+y+" "+w+" L "+it+" "+w:st.drawBezierSegment(l,t,r,a,c);else if(ht=="outsideextended"){if(ft=v,vt=p,v=v+Math.cos(f)*-(k/10),p=p+Math.sin(f)*-(k/10),l=[],tt=k/4,l.push({X:v,Y:p}),y=v+Math.cos(f)*tt,w=p+Math.sin(f)*tt,l.push({X:y,Y:w}),ot=a.model.legend.visible&&(a.model.legend.position.toLowerCase()=="left"||a.model.legend.position.toLowerCase()=="right")?a.model.elementSpacing:0,y=v<rt?a.model.centerX-k-tt*2-t.LeftLabelMaxWidth>0?a.model.centerX-k-tt*2+ot:t.LeftLabelMaxWidth>ft?ft:t.LeftLabelMaxWidth:a.model.centerX+k+tt*2+t.RightLabelMaxWidth<n(a.svgObject).width()?a.model.centerX+k+tt*2-ot:a.model.centerX+k+t.RightLabelMaxWidth>n(a.svgObject).width()?ft:n(a.svgObject).width()-t.RightLabelMaxWidth,l.push({X:y,Y:w}),g=ej.EjSvgRender.utils._getStringBuilder(),et.dataLabel.connectorLine.type.toLowerCase()!="bezier"||a.vmlRendering){for(d=0;d<l.length;d++)d==l.length-1?g.append(" "):g.append("M "+l[d].X+" "+l[d].Y+" L "+l[d+1].X+" "+l[d+1].Y+" ");g=g.toString()}else st.drawBezierSegment(l,t,r,a,c);b=l[l.length-1].X+(v<rt?-ut:ut);nt=l[l.length-1].Y}else t.type.toLowerCase()=="doughnut"?(b=(v+ct)/2,nt=(p+lt)/2):(b=(v+rt)/2,nt=(p+at)/2,b=(v+b)/2,nt=(p+nt)/2);return{positionX:b,positionY:nt,connectorDirection:g,points:l[l.length-1]}},updateSmartLabel:function(t,i,r,u){var e=!0,h="",c=i.labelPosition.toLowerCase(),p=n.extend(!0,{},i.marker,u.marker),f=p.dataLabel,o=t.model.m_AreaBounds,b=t.model.svgHeight,w=i.type.toLowerCase(),l,a,s,v,y;return u._labelPlacement="",c=="inside"||c=="outsideextended"?this.calculateInsideConnectorLines(r,u,i,t):this.compareDataLabels(u,r,t.model.outsideDataRegionPoints,i,t),l=t.model.enableCanvasRendering&&!f.template?t.pyrX:0,a=t.model.enableCanvasRendering&&!f.template?t.pyrY:0,w=="pyramid"?(t.model.actualHeight<u.yPos-a||u.xPos-l>o.Width&&u._labelPlacement=="insideoverlap"||t.model.legend.position=="right"&&f.template&&u.xPos+u.width>o.Width+t.model.LegendActualBounds.Width)&&(e=!1,u.drawTextacc=""):(u.yPos-a<0||u.xPos-l>o.Width&&u._labelPlacement=="insideoverlap"||t.model.legend.position=="right"&&f.template&&u.xPos+u.width>o.Width+t.model.LegendActualBounds.Width)&&(e=!1,u.drawTextacc=""),(c=="outside"||u._labelPlacement=="insideoverlap")&&e&&(h=this.drawConnectorLines(r,u,i,t)),f.template&&(s=n("#"+u.id),e?(v=u._labelPlacement=="insidenooverlap"?u.textOptionsacc.x+t.pyrX-u.width/2:u.textOptionsacc.x+t.pyrX,y=u._labelPlacement=="insidenooverlap"?u.textOptionsacc.y+t.pyrY:u.textOptionsacc.y+t.pyrY-t.model.elementSpacing,s.css("left",v).css("top",y),s.css("height",u.height).css("overflow","hidden")):s.css("display","none")),{xPos:u.xPos,yPos:u.yPos,textOptionsacc:u.textOptionsacc,connectorDirection:h.connectorDirection,bezierPath:h.bezierdir,drawTextacc:u.drawTextacc}},compareDataLabels:function(t,i,r,u,f){for(var l,tt,w=n.extend(!0,{},u.marker,t.marker),a=w.dataLabel,b,o,k,e,d,v,y,s=f.model.elementSpacing,h=w.dataLabel.margin,it=u._visiblePoints.length,c=u.labelPosition.toLowerCase(),g=f.model.enableCanvasRendering?f.pyrX:0,nt=f.model.enableCanvasRendering?f.pyrY:0,p=0,rt=r.length;p<rt;p++)if(b=r[p],o=this.isCollide(b,t,u),o.state)if(c=="inside"||c=="outsideextended")for(t.textOptionsacc.y=t.yPos=t.textOptionsacc.y+o.height,y=a.template?{x:t.xPos,y:t.yPos}:{x:t.xPos-g,y:t.yPos-nt},l=0,tt=it;l<tt;l++)k=f.isPointInPolygon(f.model.chartRegions[0].Region[l].Polygon,y),k&&(t.textOptionsacc.x=t.xPos=t.textOptionsacc.x+t.width,y=a.template?{x:t.xPos,y:t.yPos}:{x:t.xPos-g,y:t.yPos-nt});else t._labelPlacement="outside",t.textOptionsacc.y=t.yPos=u.type.toLowerCase()=="pyramid"?t.yPos+o.height+s/2:t.yPos+o.height-s/2,t.textOptionsacc.y=t.textOptionsacc.y+t.height/4-s/2+h.top/2-h.bottom/2;e=a.angle;d=e>360?e-360:e<-360?e+360:e;v="rotate("+d+","+t.textOptionsacc.x+","+t.textOptionsacc.y+")";n(t.textOptionsacc).attr("transform",v);n(t.textOptionsacc).attr({transform:v});(c=="inside"||c=="outsideextended")&&(t.yPos=t.yPos+s/4,t.textOptionsacc.y=t.textOptionsacc.y+t.height/4+h.top/2-h.bottom/2);r[r.length]=t},calculateInsideConnectorLines:function(t,i,r,u){var s=i.Polygon,h=n.extend(!0,{},r.marker,i.marker),f=h.dataLabel,c=f.font,e,l=u.model.enableCanvasRendering?u.pyrX:0,a=u.model.enableCanvasRendering?u.pyrY:0,o=70,v=ej.EjSvgRender.utils._measureText(i.drawTextacc,null,c),y=f.template?{x:i.xPos,y:i.yPos}:{x:i.xPos+v.width/2-l,y:i.yPos-i.height/2-a},p=u.isPointInPolygon(s,y);p?i._labelPlacement="insidenooverlap":(i._labelPlacement="insideoverlap",i.textOptionsacc["text-anchor"]="start",e=i.startX+o<u.model.m_AreaBounds.Width?o:u.model.m_AreaBounds.Width-i.startX,i.textOptionsacc.x=i.xPos=i.startX+e,i.textOptionsacc.y=i.yPos=i.yLocation,u.model.enableCanvasRendering&&!f.template&&(i.textOptionsacc.x+=u.pyrX,i.textOptionsacc.y+=u.pyrY,i.xPos+=u.pyrX,i.yPos+=u.pyrY),this.compareDataLabels(i,t,u.model.outsideDataRegionPoints,r,u))},drawConnectorLines:function(t,i,r,u){var h="",v=new ej.seriesTypes[r.type.toLowerCase()],f=r._visiblePoints[t].startX,e=r._visiblePoints[t].startY,o="",y=n.inArray(r,u.model._visibleSeries),p=n.extend(!0,{},r.marker,i.marker),c=p.dataLabel,s=i.textOptionsacc.y-u.model.elementSpacing/2,l=u.model.enableCanvasRendering?u.pyrX:0,a=u.model.enableCanvasRendering?u.pyrY:0,w=[{X:f+l,Y:e+a},{X:i.textOptionsacc.x,Y:s}];return c.connectorLine.type.toLowerCase()!="bezier"||u.vmlRendering?(o="M "+f+" "+e+" L "+i.textOptionsacc.x+" "+s,u.model.enableCanvasRendering&&!c.template&&(o="M "+f+" "+e+" L "+(i.textOptionsacc.x-l)+" "+(s-a))):h=v.drawBezierSegment(w,r,t,u,y),{connectorDirection:o,bezierdir:h}},isCollide:function(n,t,i){var u=0,f=0,e=i.type.toLowerCase(),r;return r=!(n.yPos+n.height<t.yPos||n.yPos>t.yPos+t.height||n.xPos+n.width/2<t.xPos-t.width/2||n.xPos-n.width>t.xPos+t.width),r&&e=="pyramid"?(f=n.yPos+n.height-t.yPos,u=n.xPos+n.width-t.xPos):r&&e=="funnel"&&(f=n.yPos-(t.yPos+t.height),u=n.xPos+n.width-t.xPos),{state:r,height:f,width:u}},trimText:function(n,t,i){t--;var r=t-i.length,u=n.substr(0,r);return u+i},trimfunction:function(n,t,i,r,u,f){while(t<i)if(n=n.toString(),n=this.trimText(n,n.length,r),i=ej.EjSvgRender.utils._measureText(n,u,f).width,n==r){n="";break}return n},calculatePosition:function(n,t,i,r,u){var f,e,o,s;return f=t.x+i/2-r,e=t.y-u,o=t.x-i/2-r,s=t.y-u,{rightEndX:f,rightEndY:e,leftEndX:o,leftEndY:s}},textOption:function(t,i,r,u,f,e,o,s,h,c,l){var a;if(a=i.model._isPieOfPie?n.extend(!0,{},t.marker,l.marker):n.extend(!0,{},t.marker,t._visiblePoints[e].marker),!a.dataLabel.template){n("#"+i.svgObject.id+"series"+c+"_PointText"+e).remove();var y={id:i.svgObject.id+"series"+c+"_PointText"+e,x:s+u,y:h+r.height/4+f,fill:a.dataLabel.font.color,"font-size":a.dataLabel.font.size,"font-family":a.dataLabel.font.fontFamily,"font-style":a.dataLabel.font.fontStyle,"font-weight":a.dataLabel.font.fontWeight,opacity:a.dataLabel.font.opacity,"text-anchor":o,cursor:"default",degree:a.dataLabel.angle},v=a.dataLabel.angle,w=v>360?v-360:v<-360?v+360:v,p="rotate("+w+","+s+","+h+")";n(y).attr("transform",p);i.model.enableCanvasRendering&&n(y).attr("labelRotation",v);n(y).attr({transform:p})}return y},labelTrim:function(n,t,i,r,u,f,e,o,s,h){var d=-.5*Math.PI,ft=.5*Math.PI,p=this.calculatePosition(n,t,i,u,f),v=n.model.series[s].startAngle,a=n.model.series[s].endAngle,et=n.model.chartRegions.length<n.model._visibleSeries.length?n.model.chartRegions[0].Region:n.model.chartRegions[s].Region,c,l,b,g,y,it,rt="...",tt=a-v,s=n.model._isPieOfPie?h:s,w,k,ut,nt;if(tt<0?(a=a/360,w=a?2*Math.PI*(a<0?1+a:a):0):w=v?2*Math.PI*(n.model.itemCurrentXPos<0?1+n.model.itemCurrentXPos:n.model.itemCurrentXPos):0,v=(Math.atan2(p.rightEndY,p.rightEndX)-d-w)%(2*Math.PI),v<0&&(v=2*Math.PI+v),a=(Math.atan2(p.leftEndY,p.leftEndX)-d-w)%(2*Math.PI),a<0&&(a=2*Math.PI+a),c=parseFloat(e.start.toFixed(14)),l=parseFloat(e.end.toFixed(14)),tt>0?(ej.util.isNullOrUndefined(n.firstStartAngle[0])&&n.firstStartAngle.push(c),c=n.firstStartAngle[0]<0?n.model._isPieOfPie?c:2*Math.PI+c:c,l=n.firstStartAngle[0]<0?n.model._isPieOfPie?l:2*Math.PI+l:l):(c=c<0?n.model._isPieOfPie?c:2*Math.PI+c:c,l=l<0?n.model._isPieOfPie?l:2*Math.PI+l:l),c-=w,l-=w,c>2*Math.PI&&l>2*Math.PI?(v=v+2*Math.PI,a=a+2*Math.PI):c<2*Math.PI&&l>2*Math.PI&&(v<Math.PI/2&&(v=v+2*Math.PI),a<Math.PI/2&&(a=a+2*Math.PI)),v<0&&(a>0||a==null)&&(c=c<0?2*Math.PI+c:c,l=l<=0?2*Math.PI+l:l),b=n.model.circleCenterX[s]<t.x?Math.sqrt(Math.pow(Math.abs(p.rightEndX),2)+Math.pow(Math.abs(p.rightEndY),2)):Math.sqrt(Math.pow(Math.abs(p.leftEndX),2)+Math.pow(Math.abs(p.leftEndY),2)),tt<0&&(l=[c,c=l][0]),a>=c&&a<=l&&v>=c&&v<=l&&b<=n.model.circularRadius[s]&&b>0)g=!0;else for(g=!1;!g;){if(r=this.trimText(r,r.length,rt),r==rt){r="";break}it=ej.EjSvgRender.utils._measureText(r,null,o);y=this.calculatePosition(n,t,it.width,u,f);k=(Math.atan2(y.rightEndY,y.rightEndX)-d-w)%(2*Math.PI);k<0&&(k=2*Math.PI+k);a=(Math.atan2(y.leftEndY,y.leftEndX)-d-w)%(2*Math.PI);a<0&&(a=2*Math.PI+a);b=n.model.circleCenterX[s]<t.x?Math.sqrt(Math.pow(Math.abs(y.rightEndX),2)+Math.pow(Math.abs(y.rightEndY),2)):Math.sqrt(Math.pow(Math.abs(y.leftEndX),2)+Math.pow(Math.abs(y.leftEndY),2));c>2*Math.PI&&l>2*Math.PI&&n.model._isPieOfPie?(nt=c-2*Math.PI,c=nt,ut=l-2*Math.PI,l=ut):c!=0&&c<2*Math.PI&&l>=2*Math.PI&&n.model._isPieOfPie&&(nt=c-2*Math.PI,c=nt);a>=c&&a<=l&&k>=c&&k<=l&&b<=n.model.circularRadius[s]&&b>0&&(g=!0)}return r},drawDataLabelAcc:function(t,i,r,u,f,e){var wi=u.marker,ki,vu,ft,wt,dr,yu,it,ir,gr,nu,ri,gu,ti,ui,vi,fi,yi,fr,ar,ot,pu,wu,lt,at,pi,tu,yr,bu;if(u.visible&&(wi&&wi.dataLabel&&wi.dataLabel.visible||(!wi||!wi.dataLabel)&&i.marker.dataLabel.visible)){var o=t,c=i.type.toLowerCase(),rt=new ej.seriesTypes[c],dt=ej.util.isNullOrUndefined,k=c=="pieofpie"?"inside":i.labelPosition.toLowerCase(),h=o.model,ku=h.title,st=ej.EjSvgRender.utils._measureText,er=h.elementSpacing,gt=i.marker,ht=gt.dataLabel,y=ht.margin,g=ht.font,ei=ht.connectorLine,oi=ei.type.toLowerCase(),pr=h.legend,d=pr.position.toLowerCase(),bi=h.LegendActualBounds,iu=dt(u.text)?u.y:u.text,or=ht.enableWrap,sr,ct,ru=iu,p=h._isPieOfPie?e:f,v,wr,nt,ut,l,vt,br,w=0,si,hr,b=0,ni,hi,ci=h.background.toLowerCase(),cr,uu=ht.enableContrastColor;if((c=="pyramid"||c=="funnel")&&k=="outsideextended"&&(k="inside"),nt=n.extend({},ej.EjSvgRender.commonChartEventArgs),nt.data={text:iu,series:i,pointIndex:r},o._trigger("displayTextRendering",nt),wr={size:g.size,fontStyle:g.fontStyle,fontFamily:g.fontFamily},ut=st(nt.data.text,null,wr),si=ut.width+y.left+y.right,hr=ut.height+y.top+y.bottom,c=="pyramid"||c=="funnel"){var fu=h.title.text?st(h.title.text,n(this.svgObject).width()-h.margin.left-h.margin.right,h.title.font):0,kr=o.model.title.subTitle.text?ej.EjSvgRender.utils._measureText(o.model.title.subTitle.text,n(this.svgObject).width()-o.model.margin.left-o.model.margin.right,o.model.title.subTitle.font):0,dr=o.model.title.subTitle.text===""?0:kr.height,lt=er+h.margin.left+(d==="left")?bi.Width:0,at=(d==="top"?bi.Height:0)+(h.title.text&&h.title.visible?h._titleLocation.Y+fu.height+dr:h.margin.top+er);si=si+10;ki={X:u.xLocation+o.pyrX,Y:u.yLocation+o.pyrY};w=u.xLocation;b=u.yLocation;ft=u.marker?u.marker:gt;ft=n.extend(!0,{},gt,ft);v=u.connectorLine;vt={positionX:w,positionY:b}}if(c!="pyramid"&&c!="funnel"){var du=-.5*Math.PI,et=u.midAngle+du,eu,ou,su,ti,lr,fu=h.title.text?st(h.title.text,n(this.svgObject).width()-h.margin.left-h.margin.right,h.title.font):0,kr=o.model.title.subTitle.text?ej.EjSvgRender.utils._measureText(o.model.title.subTitle.text,n(this.svgObject).width()-o.model.margin.left-o.model.margin.right,o.model.title.subTitle.font):0,dr=o.model.title.subTitle.text===""?0:kr.height,li,yt,pt,di,hu,cu,lu,gi,au,nr=h.circularRadius[p];li=dt(ei.height)?st(nt.data.text,null,g).height:ei.height;vu=o.model._isPieOfPie?u.actualIndex:i._visiblePoints[r].actualIndex;(vu==i.explodeIndex||i.explodeAll)&&!o.vmlRendering?(yt=h.circleCenterX[p]+Math.cos(et)*i.explodeOffset,pt=h.circleCenterY[p]+Math.sin(et)*i.explodeOffset):(yt=h.circleCenterX[p],pt=h.circleCenterY[p]);di=rt.getXCordinate(yt,nr,et);di=u.y!=0?di:parseFloat(di.toFixed(12));hu=rt.getYCordinate(pt,nr,et);cu=rt.getXCordinate(yt,h.innerRadius[f],et);lu=rt.getYCordinate(pt,h.innerRadius[f],et);gi=this.getXCordinate(yt,nr+li,et);gi=u.y!=0?gi:parseFloat(gi.toFixed(12));au=this.getYCordinate(pt,nr+li,et);ht.template?ct=u.size:(ft=u.marker?u.marker:gt,ft=n.extend(!0,{},gt,ft),sr=ft.dataLabel.shape,ct=st(nt.data.text,n(o.svgObject).width(),g),sr.toLowerCase()!="none"&&(ct.height=ct.height+y.top+y.bottom,ct.width=ct.width+y.left+y.right));eu={midX:di,midY:hu};ou={dMidX:cu,dMidY:lu};su={connectorX:gi,connectorY:au};ti={midPoint:eu,doughnutMidPoint:ou,connector:su};lr={startX:yt,startY:pt};i._enableSmartLabels?(l=rt.updateSmartLabelPosition(i,u,r,ti,et,lr,li,ct,t,f),o.model.bounds[f].points[r]&&(wt=o.model.bounds[f].points[r].overlap),w=l.positionX,b=l.positionY,vt={positionX:w,positionY:b,isInterSected:l.isInterSected},v=o.model._isPieOfPie||wt?"":l.connectorDirection):(l=rt.updateLabelPosition(i,u,r,ti,et,lr,li,ct,t,f),w=l.positionX,b=l.positionY,v=l.connectorDirection)}var tr=k!="inside"&&k!="insidenooverlap"||(c=="pyramid"||c=="funnel")&&k=="outside"?w<h.circleCenterX[p]?"end":"start":"middle",ir=k=="inside"||k=="insidenooverlap"?0:w<h.circleCenterX[p]?-ut.width:ut.width,lt=0,at=0,s;if((c=="pie"||c=="doughnut"||c=="pieofpie")&&k=="inside"&&(tr=v!=""?w<h.circleCenterX[p]?"end":"start":"middle"),(c=="pyramid"||c=="funnel")&&k=="outside"&&(tr="start"),dr=o.model.title.subTitle.text===""?0:kr.height,this.chartObj&&h.enableCanvasRendering&&(c=="pyramid"||c=="funnel")&&(lt=(d==="left"?bi.Width:0)+er+h.margin.left,at=(d==="top"?bi.Height:0)+(ku.text?h._titleLocation.Y+fu.height+dr:h.margin.top+er)),r=o.model._isPieOfPie?u.actualIndex:r,s=this.textOption(i,o,ut,lt,at,r,tr,w,b,f,u),hi=jQuery.type(h.pointColors[u.actualIndex])=="array"?h.pointColors[u.actualIndex][0].color:h.pointColors[u.actualIndex],hi=u.fill?jQuery.type(u.fill)=="array"?u.fill[0].color:u.fill:hi,ht.template)ki=dt(ki)?{X:w,Y:b}:ki,yu=u.actualIndex,rt.drawLabelTemplate(i,u,yu,ki,t),oi=="bezier"&&l.bezierPath!=""&&t.svgRenderer.drawPolyline(l.bezierPath,t.gConnectorEle[f]);else{if(n.each(h.symbolShape,function(t){ft=u.marker?u.marker:gt;ft=n.extend(!0,{},gt,ft);sr=ft.dataLabel.shape;sr.toLowerCase()==t.toLowerCase()&&(ni=t)}),w=lt+w-y.left/2+y.right/2+ir/2,b=at+b-y.top/2+y.bottom/2,(c=="pyramid"||c=="funnel")&&(u.xPos=vt.positionX+lt,u.yPos=vt.positionY+at,u.width=ni=="None"?ut.width:si,u.height=ni=="None"?ut.height:hr,u.symbolName=ht.template?"none":ni,u.textOptionsacc=s,u.drawTextacc=nt.data.text),h.enableCanvasRendering&&s.degree%360!=0&&(s.y-=ut.height/4,s.baseline="middle"),uu&&!i._enableSmartLabels&&(cr=k!="inside"?ci==="transparent"?"white":ci:hi,s.fill=this._applySaturation(o,cr)),i._enableSmartLabels){var tt=h.m_AreaBounds.Width+h.m_AreaBounds.X+h.margin.left,bt=k,ai=h.enableCanvasRendering,a=typeof nt.data.text=="string"?nt.data.text:nt.data.text.toString(),rr=st(a,a.length,g).width,ur,ii,kt=0,fr=0;pr.visible?(d=="left"||d=="right")&&(ur=bi):ur={Width:0};c=="pie"||c=="doughnut"||c=="pieofpie"?((bt=="outside"||bt=="outsideextended"||v!="")&&(ii=h.circleCenterX[p]<s.x?tt-s.x:d=="left"?s.x-h.margin.left-h.elementSpacing*2-ur.Width:s.x-h.margin.left,a=this.trimfunction(a,ii,rr,"...",tt,g),pr.visible&&(d=="top"||d=="bottom")&&(a=this._overlapLegend(s,a,t,f))),bt=="inside"&&v==""&&(a=this.labelTrim(o,s,rr,a,yt,pt,u,g,f,e),a!=""||o.model._isPieOfPie||(u.smartLabelPosition="outside",l=rt.updateSmartLabelPosition(i,u,r,ti,et,lr,li,ct,t,f),vt={positionX:l.positionX,positionY:l.positionY,isInterSected:l.isInterSected},a=nt.data.text,v=l.connectorDirection,tr=h.circleCenterX[p]<l.positionX?"start":"end",s=this.textOption(i,o,ut,lt,at,r,tr,l.positionX,l.positionY,f,u),ii=h.circleCenterX[p]<l.positionX?d=="right"?tt-s.x-ur:tt-s.x:d=="left"?s.x-ur:s.x,a=this.trimfunction(a,ii,rr,"...",tt,g),delete u.smartLabelPosition))):(c=="pyramid"||c=="funnel")&&(l=rt.updateSmartLabel(t,i,r,u),w=l.xPos,b=l.yPos,v=l.connectorDirection,s=l.textOptionsacc,a=u.drawTextacc,(v!=""||oi=="bezier")&&a!=""&&(a=a.toString(),ii=d=="right"?ai?tt-s.x:tt-s.x-o.pyrX:d=="left"?ai?tt-s.x:tt-s.x-o.pyrX:d=="top"?ai?tt-s.x:tt-s.x-o.pyrX:ai?tt-s.x:tt-s.x-o.pyrX,ii<rr&&(a=this.trimfunction(a,ii,rr,"...",tt,g))));it=st(a,null,g);c=="pie"||c=="doughnut"||c=="pieofpie"?ir=(k=="inside"||k=="insidenooverlap")&&!vt.isInterSected&&v==""?0:w<h.circleCenterX[p]?-it.width:it.width:(c=="pyramid"||c=="funnel")&&(ir=u._labelPlacement=="insidenooverlap"?0:it.width);c=="pie"||c=="doughnut"||c=="pieofpie"?(w=lt+vt.positionX-y.left/2+y.right/2+ir/2,b=at+vt.positionY-y.top/2+y.bottom/2):(w=w-y.left/2+y.right/2+ir/2,b=b-y.top/2+y.bottom/2);gr=n("#"+o.svgObject.id+"_dataLabel_series"+f+"_point_"+r);nu=n("#"+o.svgObject.id+"_connectorLine_series"+f+"_point_"+r);a!==""?(gr.show(),nu.show(),uu&&(cr=bt!="inside"?ci==="transparent"?"white":ci:l.connectorDirection!=""&&!ej.util.isNullOrUndefined(l.connectorDirection)||l.bezierPath!=""&&!ej.util.isNullOrUndefined(l.bezierPath)?ci==="transparent"?"white":ci:hi,s.fill=this._applySaturation(o,cr)),or||wt||rt.dataLabelSymbol(f,i,r,w,b,si,hr,ni,o),oi!="bezier"||l.bezierPath==""||ej.util.isNullOrUndefined(l.bezierPath)||t.svgRenderer.drawPolyline(l.bezierPath,t.gConnectorEle[f])):(gr.hide(),nu.hide(),v="");or||wt||o.svgRenderer.drawText(s,a,o.gSeriesTextEle[f]);ri=st(a,a.length,g);gu=st(nt.data.text,null,g);(c=="pie"||c=="doughnut"||c=="pieofpie")&&(bt=="inside"&&l.connectorDirection==""?(ui=s.x-it.width/2,fi=s.x+it.width/2,vi=s.y-it.height/2,yi=s.y+it.height/2):(h.circleCenterX[p]<s.x?(ui=s.x,fi=s.x+it.width):(ui=s.x-it.width,fi=s.x),vi=s.y-it.height/2,yi=s.y+it.height/3),ti={centerX:h.circleCenterX[p],minX:ui,minY:vi,maxX:fi,maxY:yi,width:ri.width,height:ri.height,labelPosition:bt});(c=="funnel"||c=="pyramid")&&(kt=d=="left"?kt:0,fr=0,(v!=""||oi=="bezier")&&(ui=s.x-kt,fi=s.x+it.width-kt,vi=s.y-it.height,yi=s.y),ti=ai?{minX:ui+kt,maxX:fi+kt,minY:vi+fr,maxY:yi+fr,width:ri.width,height:ri.height,labelPosition:bt}:{minX:ui+o.pyrX+kt,maxX:fi+o.pyrX+kt,minY:vi+o.pyrY+fr,maxY:yi+o.pyrY+fr,width:ri.width,height:ri.height,labelPosition:bt});br={bounds:ti,trimmedText:a,text:nt.data.text,type:c,font:g};o.accDataLabelRegion.type=c;o.accDataLabelRegion.connectorDirection=v;ej.util.isNullOrUndefined(o.accDataLabelRegion[p])&&(o.accDataLabelRegion[p]=[]);o.accDataLabelRegion[p].length<i._visiblePoints.length&&o.accDataLabelRegion[p].push(br);dt(u.index)||!i.explode||ai||o.accDataLabelRegion[p].splice(u.index,1,br);e==1&&o.accDataLabelRegion[p].length==i._visiblePoints.length&&(o.accDataLabelRegion[f]=n.merge(n.merge([],o.accDataLabelRegion[0]),o.accDataLabelRegion[1]))}else or||wt||(rt.dataLabelSymbol(f,i,u.index,w,b,si,hr,ni,o),o.svgRenderer.drawText(s,nt.data.text,o.gSeriesTextEle[f]));if(or)if(ar=st(ru,null,wr),pu=5,ot=this.updateWrappedText(s,ru,ar,u,c,yt,pt,nr,h.innerRadius[f],k,ht,oi=="bezier"?i._enableSmartLabels?dt(l.bezierPath)?"":l.bezierPath.points:l.points:v),a=ot.text,s.x=parseFloat(ot.x),s.y=parseFloat(ot.y),a==""||wt||(wu=s["text-anchor"]=="start"?parseFloat(s.x+ot.width/2):dt(v)||v==""?parseFloat(s.x):parseFloat(s.x-ot.width/2),rt.dataLabelSymbol(f,i,r,wu,s.y+ot.height/2-ar.height/2-pu,ot.width,ot.height,ni,o)),dt(v)||v==""||((c=="funnel"||c=="pyramid")&&(lt=h.enableCanvasRendering?this.chartObj.pyrX:0,at=h.enableCanvasRendering?this.chartObj.pyrY:0),pi=v.split(" "),tu=k=="outsideextended"&&(c=="pie"||c=="doughnut")?pi.length-2:pi.length,pi[tu-1]=s.y-at+(ot.height/2-ar.height),pi[tu-2]=s.x-lt,v=pi.toString().replace(/,/g," ")),v=ot.exceed==!1?"":v,(h.enableCanvasRendering||this.chartObj.vmlRendering)&&typeof a=="object"&&!wt)for(var vr=0,nf=s.y,tf=s.x;vr<a.length;vr++)s.y=parseFloat(nf)+vr*ut.height,s.x=tf,o.svgRenderer.drawText(s,a[vr],o.gSeriesTextEle[f]);else wt||o.svgRenderer.drawText(s,a,o.gSeriesTextEle[f])}(c=="pyramid"||c=="funnel")&&ht.template&&i._enableSmartLabels&&(l=rt.updateSmartLabel(t,i,r,u),w=l.xPos,b=l.yPos,v=l.connectorDirection);yr=[];yr[0]=lt;yr[1]=at;(oi!="bezier"||o.vmlRendering||c=="pyramid"||c=="funnel")&&v!=""&&v&&(bu={id:o.svgObject.id+"_connectorLine_series"+f+"_point_"+r,stroke:ei.color?ei.color:hi,"stroke-width":ei.width,d:v},o.svgRenderer.drawPath(bu,o.gConnectorEle[f],yr))}},_overlapLegend:function(t,i,r,u){var c=n(r.svgObject).height(),y=n(r.svgObject).width(),p=r.model.LegendActualBounds,e=r.model.elementSpacing,o=r.model.series[u].marker.dataLabel.margin,l=r.model.series[u].marker.dataLabel.shape,w=l!="none"?o.top:0,b=l!="none"?o.bottom:0,k=ej.EjSvgRender.utils._measureText((i,t)).height,a=t.y+k+b,d=t.y-w,g=r.model.legend.position.toLowerCase(),nt=r.model.title,h=nt.subTitle,o=r.model.margin,tt=r.model.border.width,it=h.text==""?0:ej.EjSvgRender.utils._measureText(h.text,y-o.left-o.right,h.font).height+e,v=r.model._titleLocation?r.model._titleLocation.Y:0+it,f=i,s;return g=="bottom"?(s=c-r.model.LegendActualBounds.Height-e,f=a>s?"":f):(s=v==0?tt+e:v+e,f=d<s+p.Height?"":f),a>c&&(f=""),f},updateWrappedText:function(t,i,r,u,f,e,o,s,h,c,l,a){var w=this.chartObj,v=u,g={},bt=r.width,at=r.height,ui,kt,dt,gt,y,k,fi=t.x,ei=t.y,ni,b,nt=fi,st=!0,vt=w.model.m_AreaBounds.X,d=ei,tt,ot,it,ht,yt,wt,ii,et,p,rt;if(ej.util.isNullOrUndefined(a)||a==""||(typeof a=="object"?(it=a.X,ht=a.Y):(tt=a.split(" "),ot=c=="outsideextended"?tt.length-2:l.connectorLine.type.toLowerCase()=="bezier"?tt.length-2:tt.length,tt[ot-1].indexOf(",")>-1?(yt=tt[ot].split(","),it=yt[0],ht=yt[1]):(it=tt[ot-2],ht=tt[ot-1]))),f=="pie"||f=="doughnut"){if(c=="inside"){var h=ej.util.isNullOrUndefined(h)?0:h,pt=-.5*Math.PI,ct=v.startAngle+pt,lt=v.endAngle+pt,ut=v.midAngle+pt,oi=180/Math.PI*ut%360,ki=180/Math.PI*ct%360,di=180/Math.PI*lt%360,ti=f=="doughnut"?.75:.5;nt=this.getXCordinate(e,s*ti,ut);d=this.getYCordinate(o,s*ti,ut);var si=this.getXCordinate(e,s,ct),hi=this.getYCordinate(o,s,ct),ci=this.getXCordinate(e,s,lt),li=this.getYCordinate(o,s,lt),ai=this.getXCordinate(e,s,ut),vi=this.getYCordinate(o,s,ut),yi=this.getXCordinate(e,h,ut),pi=this.getYCordinate(o,h,ut),ft=this.getSegementMinMax([si,ci,f=="doughnut"?yi:e,ai],[hi,li,f=="doughnut"?pi:o,vi]);ft.width=ft.height>s?ft.height:ft.width;b=ft.width*.75}else if((c=="outside"||c=="outsideextended")&&(f=="pie"||f=="doughnut")&&a!=""){var gi=w.model.m_AreaBounds,wi=vt,bi=w.svgWidth-vt;b=it<=e?it-wi:bi-it;nt=it;d=ht}}else if(wt=w.svgWidth,c=="outside")b=wt-it;else if(b=v.width,ii=w.isPointInPolygon(v.Polygon,{x:nt+bt,y:d}),!ii){b=f=="funnel"?v.Polygon[3].x-v.Polygon[4].x:v.Polygon[1].x-v.Polygon[0].x;ni=v.Polygon[3].y-v.Polygon[0].y;var ri=Math.round(bt/b)*at,st=ri>=ni-10||b<=50?!0:!1;st?b=wt-nt-vt:(t["text-anchor"]="middle",nt=(f=="funnel"?v.Polygon[4].x:v.Polygon[0].x)+b/2+(w.model.enableCanvasRendering?w.pyrX:0),d=(v.Polygon[0].y+v.Polygon[3].y)/2-ri/2+(w.model.enableCanvasRendering?w.pyrY:0),v._labelPlacement="insidenooverlap")}if(c!="inside"&&a==""&&ej.util.isNullOrUndefined(a))y="";else{for(kt=l.maximumLabelWidth!=null?l.maximumLabelWidth:parseFloat(b),y=i,dt=w._rowsCalculation({text:y.toString(),font:l.font},kt,ui),y=dt.textCollection,k=n.extend([],y),et=0;et<k.length-1;et++)k[et+1]=k[et].concat("<br/>",k[et+1]);k=k[k.length-1]}return p=ej.EjSvgRender.utils._measureText(k,b,l.font),p.height+=at/2,(f=="pie"||f=="doughnut")&&c=="inside"&&(d=d-p.height/2+at/2,y=p.height>ft.height?"":y,y=p.width>ft.width?"":y,y==""&&(p.width=0,p.height=0)),g=this.currentBoundary=="undefined"?"undefined":this.currentBoundary,this.currentBoundary={X:nt-p.width/2,Y:parseFloat(d),Height:p.height,Width:p.width},!g||v._labelPlacement=="insidenooverlap"?gt=this.currentBoundary:(rt=this.checkOverlapping(w,this.currentBoundary,g,f,y,gt,oi,c,{startAngle:ct,endAngle:lt,radius:s,centerX:e,centerY:o}),rt[1]&&rt[2]!=""?(g=rt[0],nt=g.X+g.Width/2,d=g.Y,y=rt[2],p.height=rt[0].Height,p.width=rt[0].Width):y=rt[2]),st=y==""?!1:st,this.currentBoundary=y==""?g:this.currentBoundary,{text:y,x:nt,y:d,exceed:st,height:p.height,width:p.width}},checkOverlapping:function(n,t,i,r,u,f,e,o,s){var c=10,l=!1,h,y,a,p,v,w,b;return h=this.getOverlapArea(t,i),l=h.overlap,y=h.xOverlap,a=h.yOverlap,l&&(r=="pie"||r=="doughnut"?o.toLowerCase()=="inside"?(p=y>=a?"Y":"X",p=="X"?(v=e>0&&e<180?-1:1,t.X+=v*(y+c)):(v=e>90&&e<270?-1:1,t.Y+=v*(a+c))):t.Y-=a+c:t.Y=r=="funnel"?i.Y-t.Height-c:i.Y+i.Height+c),(r=="pie"||r=="doughnut"||r=="pieofpie")&&o.toLowerCase()=="inside"?(h=this.getOverlapArea(t,f),u=h.overlap==!0?"":u,l=h.overlap==!0?!0:l,w=this.checkSegmentExceeding(t,s),u=w?u:""):r=="funnel"?t.Y+t.Height>=i.Y&&(u=""):r=="pyramid"&&t.Y+t.Height<=i.Y+i.Height&&(u=""),b=n.model.m_AreaBounds,[{X:t.X,Y:t.Y,Height:t.Height,Width:t.Width},l,u]},getOverlapArea:function(n,t){var i=Math.max(0,Math.min(n.X+n.Width,t.X+t.Width)-Math.max(n.X,t.X)),r=Math.max(0,Math.min(n.Y+n.Height,t.Y+t.Height)-Math.max(n.Y,t.Y)),u=i*r,f=u>0?!0:!1;return{overlap:f,xOverlap:i,yOverlap:r}},getSegementMinMax:function(n,t){var i,r,u,f,e,o;return n.sort(function(n,t){return n-t}),t.sort(function(n,t){return n-t}),i=n[0],r=n[3],u=t[0],f=t[3],e=r-i,o=f-u,{minX:i,maxX:r,minY:u,maxY:f,width:e,height:o}},checkSegmentExceeding:function(n,t){var u=!1,o=n.X+n.Width/2,s=n.Y+n.Height/2,f=o-t.centerX,e=s-t.centerY,i=Math.atan2(e,f),h=Math.abs(Math.sqrt(f*f+e*e)),r;return h<=t.radius&&(r=2*Math.PI,i=i<0?r+i:i,t.startAngle=t.startAngle<0?r+t.startAngle:t.startAngle,t.endAngle=t.endAngle<0?r+t.endAngle:t.endAngle,i<=t.endAngle&&i>=t.startAngle?u=!0:(i<=r&&i>=t.startAngle&&t.endAngle<t.startAngle||i>0&&i<=t.endAngle&&t.startAngle>t.endAngle)&&(u=!0)),u},drawBezierSegment:function(n,t,i,r,u){for(var h,e,o,s=ej.EjSvgRender.utils._getStringBuilder(),c=new ej.seriesTypes[t.type.toLowerCase()],f=0;f<=16;f++)h=f/16,e=c.GetBezierPoint(h,n,0,n.length,t),s.append(e.X+","+e.Y+" ");if(o={id:r.svgObject.id+"_bezierLine_series"+u+"_point"+i,stroke:t.marker.dataLabel.connectorLine.color?t.marker.dataLabel.connectorLine.color:r.model.pointColors[i],"stroke-width":t.marker.dataLabel.connectorLine.width,fill:"none",points:s.toString()},t._enableSmartLabels)return o;r.svgRenderer.drawPolyline(o,r.gConnectorEle)},GetBezierPoint:function(n,t,i,r,u){var o=new ej.seriesTypes[u.type.toLowerCase()];if(r==1)return t[i];var f=o.GetBezierPoint(n,t,i,r-1,u),e=o.GetBezierPoint(n,t,i+1,r-1,u),c=f.X?f.X:f.x,l=f.Y?f.Y:f.y,a=e.X?e.X:e.x,v=e.Y?e.Y:e.y,s=(1-n)*c+n*a,h=(1-n)*l+n*v;return f.x?{x:s,y:h}:{X:s,Y:h}},drawLabelTemplate:function(t,i,r,u,f){var ut,ft,s,lt,at,vt,a,et,ot,st,d,g,yt,pt;f&&(this.chartObj=f);var tt=this.chartObj.model.m_AreaBounds.X,it=this.chartObj.model.m_AreaBounds.Y,ht=this.chartObj.model.m_AreaBounds.Width,ct=this.chartObj.model.m_AreaBounds.Height,p=n.inArray(t,this.chartObj.model._visibleSeries),nt=this.chartObj.model.AreaType,c=this.chartObj.model.series[p],w=0,rt=0,v=this.chartObj._id,l=n.extend(!0,{},t.marker,i.marker),k={interior:l.dataLabel.fill,opacity:l.dataLabel.opacity,borderColor:l.dataLabel.border.color,borderWidth:l.dataLabel.border.width},b,h,y,bt=this.chartObj.model.chartRegions[r]?this.chartObj.model.chartRegions[r].type:"";if(nt!="none"||this.chartObj.model.enable3D){if(ut=n("#template_group_"+v).length!=0?n("#template_group_"+v):n("<div><\/div>").attr("id","template_group_"+v),ut.css("position","relative").css("z-index",1e3),n("#"+l.dataLabel.template).length==0)return;ft=n("#"+l.dataLabel.template).clone();n(ft).attr("id",l.dataLabel.template+"_"+p+"_"+r+"_"+v);s=n(ft);s.css("position","absolute");lt=i.x;i.dataLabeltemplate=!0;i.id=l.dataLabel.template+"_"+p+"_"+r+"_"+v;t.xAxis._valueType.indexOf("datetime")>-1&&(i.x=ej.format(new Date(i.xValue),ej.util.isNullOrUndefined(t.xAxis.labelFormat)?t.xAxis._valueType=="datetime"?ej.EjSvgRender.utils._dateTimeLabelFormat(t.xAxis._intervalType,t.xAxis):ej.EjSvgRender.utils._dateTimeLabelFormat(t.xAxis.intervalType,t.xAxis):t.xAxis.labelFormat,this.chartObj.model.locale));t.xAxis._valueType.toLowerCase()=="category"&&(i.x=ej.EjSvgRender.utils._getLabelContent(r,t.xAxis,this.chartObj.model.locale));i.count=1;at={series:t,point:i};s.html(s.html().parseTemplate(at));i.x=lt;vt=nt=="cartesianaxes"||!t.enableAnimation||t.type.toLowerCase()=="pyramid"||t.type.toLowerCase()=="funnel"?"block":"none";s.css("display",vt).appendTo(n(ut));n(ut).appendTo("#chartContainer_"+v);a=this.chartObj.model.m_AreaBounds;nt!="cartesianaxes"||this.chartObj.model.enable3D||(w=a.X+(this.chartObj.model.requireInvertedAxes?c.yAxis.plotOffset:c.xAxis.plotOffset),rt=c.yAxis.y);h=s.width()/2;y=s.height();b=ej.util.isNullOrUndefined(k)&&k.interior?k.interior:nt=="none"?this.chartObj.model.pointColors[r]:this.chartObj.model.seriesColors[p]}else b=ej.util.isNullOrUndefined(k)&&k.interior?k.interior:this.chartObj.model.pointColors[r],h=this.chartObj.model.circleCenterX[p]>u.X?i.size.width:0,s=n("#template_group_"+v).find("#"+l.dataLabel.template+"_"+p+"_"+r+"_"+v),i.id=l.dataLabel.template+"_"+p+"_"+r+"_"+v,y=this.chartObj.model.enable3D?0:i.size.height/2;if((c.type=="hilo"||c.type=="hiloopenclose"||c.type=="candle")&&(b=c._visiblePoints[r]._hiloFill),b=jQuery.type(b)=="array"?b[0].color:b,c.type.indexOf("bar")!=-1)var e=u.X+w-h,o=u.Y+(this.chartObj.model.enable3D?0:a.Y)-y+c.xAxis.plotOffset,wt=u.X+w+h;else var e=u.X+w-h,o=rt+u.Y-y,wt=u.X+w+h;et=s[0].style.backgroundColor;s.css("left",e).css("top",o).css("background-color",et!=""?et:b).css("display","block").css("cursor","default");this.chartObj.model.AreaType!="cartesianaxes"?(i.xPos=e-this.chartObj.pyrX,i.yPos=o-this.chartObj.pyrY,i.textOptionsacc={x:e-this.chartObj.pyrX,y:o-this.chartObj.pyrY}):i.y==i.low?(i.xPosLow=e,i.yPosLow=o,i.textOptionsLow={x:e,y:o},i.dataLabelLow={textX:e,textY:o,x:e,y:o}):(i.xPos=e,i.yPos=o,i.seriesIndex=p,i.textOptions={x:e,y:o},i.dataLabel={textX:e,textY:o,x:e,y:o},i.margin={top:0,bottom:0,left:0,right:0});i.height=s.outerHeight();i.width=s.outerWidth();ot=st=d=0;g=0;nt=="cartesianaxes"&&(e>w+a.Width||o+y>a.Y+a.Height||e<w||o<rt||e>w+a.Width||o>rt+a.Height||wt>a.Width+a.X)&&(h=s.outerWidth(),e<tt&&(st=tt-e),ct+it<o+y&&(yt=o+y-(ct+it),g=y-yt),o<it&&(ot=it-o),ht+tt<e+h&&(pt=e+h-(ht+tt),d=h-pt),d=d==0?h:d,g=g==0?y:g,c.marker.dataLabel.showEdgeLabels||(document.getElementById(s[0].id).style.clip="rect("+ot+"px,"+d+"px,"+g+"px,"+st+"px)"))},animateLabelTemplate:function(t){for(var i,u=n.inArray(t,this.chartObj.model._visibleSeries),f=t._visiblePoints.length,r=0;r<f;r++)i=t.marker.dataLabel.template+"_"+u+"_"+r+"_"+this.chartObj._id,i=n("#"+i),i.css("display","none"),i.delay(1e3).fadeIn(300)},textPosition:function(t,i,r,u,f,e,o,s,h,c,l){var pt=n.extend(!0,{},t.marker,r.marker),st=pt.dataLabel,vt=st.isReversed,v=st.horizontalTextAlignment.toLowerCase(),y=st.verticalTextAlignment.toLowerCase(),wt=t._visiblePoints.length,ht=s,a=10,ct=3,nt=st.margin,g=t.yAxis.isInversed,rt=this.chartObj._getXCrossValue(t,t.xAxis,c),tt=f.indexOf("bar")!=-1||f.indexOf("column")!=-1&&f!="rangecolumn"?this.chartObj.model.requireInvertedAxes?"bar":"column":f,d,lt,yt,b,it,ot,at,et;if(tt=="column"||tt=="stackingcolumn"||tt=="stackingcolumn100")d=this.chartObj.model.chartRegions[ht].Region.Bounds,lt=c.axes[t.xAxis.name]._validCross||!1,w=d.Height,p=d.Width,lt?(b=Math.abs((g?t.yAxis.visibleRange.min:t.yAxis.visibleRange.max)-rt)/t.yAxis.visibleRange.delta*t.yAxis.height,l=="bottom"?o=o<=b?o+w-nt.bottom:o-w+u.height-nt.bottom:l=="middle"?o<b?o+=w/2+u.height/4:o-=w/2:o<b&&g||o<b&&!g?o-=a+u.height/1:o+=a+u.height/1):l=="bottom"?o=r.y>=rt&&!t.yAxis.isInversed||r.y<rt&&t.yAxis.isInversed?o+w-nt.bottom:u.height+nt.bottom:l=="middle"?r.y>rt&&!t.yAxis.isInversed||r.y<rt&&t.yAxis.isInversed?o+=w/2+u.height/4:o-=w/2:r.y>rt&&t.yAxis.isInversed||r.y<rt&&!t.yAxis.isInversed?o+=a:o-=a,v&&v=="far"?e=vt?e-p/2:e+p/2:v&&v=="near"&&(e=vt?e+p/2:e-p/2),y&&y=="near"?o+=l=="bottom"?a:a-ct:y&&y=="far"&&(o-=l=="bottom"?a:a);else if(tt.indexOf("bar")!=-1){var d=this.chartObj.model.chartRegions[ht].Region.Bounds,p=d.Width,lt=c.axes[t.xAxis.name]._validCross||!1,w=d.Height;o=o+u.height/4;lt?(yt=t.xAxis._crossValue||0,b=Math.abs(g?t.yAxis.visibleRange.max:t.yAxis.visibleRange.min-yt)/t.yAxis.visibleRange.delta*t.yAxis.width,l=="bottom"?e=e<b&&!g||e>=b&&g?e+p-u.width:e-p+nt.left:l=="middle"?e=e<b&&!g||e>=b&&g?e+p/2-u.width/2:e-p/2-u.width/2:e<b&&!g||e>=b&&g?e-=a+u.width/1:e+=a+u.width/1):l=="bottom"?r.y>=0&&!t.yAxis.isInversed||r.y<0&&t.yAxis.isInversed?e=tt.indexOf("stacking")==-1&&i>0?e-p+u.width/2:nt.left+u.width/4:e+=p-u.height-nt.right:l=="middle"?r.y>0&&!t.yAxis.isInversed||r.y<0&&t.yAxis.isInversed?e-=p/2+u.width/2:e+=p/2:r.y>=0&&!t.yAxis.isInversed||r.y<0&&t.yAxis.isInversed?e+=u.width/4+a:e-=u.width/4+a;v&&v=="far"?e+=l=="bottom"?u.width-u.width/4:u.width/4+a:v&&v=="near"?e-=l=="bottom"?u.width/4:a-u.width/4-ct:e+=u.width/4;y&&y=="near"?o+=w/2:y&&y=="far"&&(o-=w/2)}else if(tt=="rangecolumn"){var d=this.chartObj.model.chartRegions[ht].Region.Bounds,ut=0,ft=0;r.high!=r.y&&(ut=d.Height,ft=d.Width);this.chartObj.model.requireInvertedAxes?l=="top"?e=e-ft+(a+u.width/1):l=="bottom"?e=e-ft-(2*u.width+a):l=="middle"&&(e=e-ft):l=="top"?o+=ut-a:l=="bottom"?o=o+ut+(2*u.height+a):l=="middle"&&(o=o+ut);v&&v.toLowerCase()=="far"?e+=d.Width/2:v&&v.toLowerCase()=="near"&&(e-=d.Width/2);y&&y.toLowerCase()=="near"?o+=a-ct:y&&y.toLowerCase()=="far"&&(o-=a)}else if(tt=="boxandwhisker"){var d=this.chartObj.model.chartRegions[ht].Region.Bounds,ut=0,ft=0;this.chartObj.model.requireInvertedAxes?l=="top"?e=e-ft+(a+u.width/1):l=="bottom"?e=e-ft-(2*u.width+a):l=="middle"&&(e=e-ft):l=="top"?o+=ut-ct:l=="bottom"?o+=ut+a+u.width/2:l=="middle"&&(o+=ut+a);v&&v.toLowerCase()=="far"?e+=2*u.width:v&&v.toLowerCase()=="near"&&(e-=2*u.width);y&&y.toLowerCase()=="near"?o=l=="top"?o+a:o-a:y&&y.toLowerCase()=="far"&&(o=l=="top"?o-a:o+a)}else if(f=="waterfall"){var d=this.chartObj.model.chartRegions[ht].Region.Bounds,w=d.Height,p=d.Width,k=r.waterfallSum<0||!r.showIntermediateSum&&!r.showTotalSum&&r.y<0;switch(l){case"bottom":t.isTransposed?e=t.yAxis.isInversed?e+p-(a+u.height/1)-(k?p:0):e-p+(a+u.height/1)+(k?p:0):o=t.yAxis.isInversed?o-u.height+nt.bottom+(k?w:0):o+w-nt.bottom-(k?w:0);break;case"middle":t.isTransposed?e=t.yAxis.isInversed?e+p/2-(k?p:0):e-(p/2+u.width/4)+(k?p:0):o=t.yAxis.isInversed?o-w/2+(k?w:0):o+(w/2+u.height/4)-(k?w:0);break;default:t.isTransposed?e=t.yAxis.isInversed?e-(a+u.height/1)-(k?p:0):e+(a+u.height/1)+(k?p:0):o=t.yAxis.isInversed?o+(a+u.height/1)+(k?w:0):o-(a+u.height/1)-(k?w:0)}v&&v=="far"?e+=p/2:v&&v=="near"&&(e-=p/2);y&&y=="near"?o+=l=="bottom"?u.height/3:u.height+a:y&&y=="far"&&(o-=l=="bottom"?u.height/3:a+u.height/2)}else if(f=="polar"||f=="radar")o+=u.height/4,l=="bottom"?o+=u.height:l=="top"&&(o-=u.height),v&&v=="far"?e+=u.width:v&&v=="near"&&(e-=u.width),y&&y=="near"?o+=u.height/2:y&&y=="far"&&(o-=u.height/2);else{if((tt=="rangearea"||tt=="splinerangearea")&&r.high!=r.y)if(this.chartObj.model.series.length==1)et=this.chartObj.model.chartRegions[i][h].region.length,o=this.chartObj.model.chartRegions[i][h].region[et-1].Y,e=this.chartObj.model.chartRegions[i][h].region[et-1].X;else{for(it=0,ot=0;ot<i;ot++)at=this.chartObj.model.series[ot].type,it=at!="rangearea"&&at!="splinerangearea"?it+this.chartObj.model.series[ot].points.length:it+1,this.chartObj.model.series[ot].visibility=="hidden"&&(it=0);et=this.chartObj.model.chartRegions[it][h].region.length;o=this.chartObj.model.chartRegions[it][h].region[et-1].Y;e=this.chartObj.model.chartRegions[it][h].region[et-1].X}this.chartObj.model.requireInvertedAxes?l=="top"?e+=a:l=="bottom"&&(e-=a+u.width/1):l=="bottom"?o+=st.showEdgeLabels?2*u.height-a:2*u.height+a:l=="top"&&(o-=a);v&&v=="far"?e+=u.width+a:v&&v=="near"&&(e-=u.width+a);y&&y=="near"?o+=a-ct:y&&y=="far"?o-=a:(f=="bubble"||f=="scatter")&&l=="middle"&&(o+=u.height/4)}return{x:e,y:o}},changeCrossHairSymbol:function(t,i,r,u,f){var c=f.drawType,e,o,h,s;return ej.util.isNullOrUndefined(i)||(e={},t=n.extend(!0,{},f.marker,t),e=n.extend(!0,{},this.chartObj.model.crosshair.marker,e),o=f.points[r],h=f.type.toLowerCase(),ej.util.isNullOrUndefined(e.shape)&&(e.shape=t.shape,h=="bubble"&&(e.border.color=o.border&&o.border.color?o.border.color:f.border.color,e.border.width=o.border&&o.border.width?o.border.width:f.border.width)),(!this.chartObj.model.crosshair.visible||ej.util.isNullOrUndefined(e.fill))&&f.type.toLowerCase()!="bubble"&&f.type.toLowerCase()!="scatter"&&c!="scatter"&&(e.fill=e.shape.toLowerCase()=="cross"||e.shape.toLowerCase()=="horizline"||e.shape.toLowerCase()=="vertline"?jQuery.type(this.chartObj.model.seriesColors[u])=="array"?this.chartObj.model.seriesColors[u][0].color:this.chartObj.model.seriesColors[u]:t.border.color),f.type.toLowerCase()!="bubble"||this.chartObj.model.enableCanvasRendering?(e.size.width<=t.size.width&&(e.size.width=t.size.width+2),e.size.height<=t.size.height&&(e.size.height=t.size.height+2),(ej.util.isNullOrUndefined(e.border.color)||!this.chartObj.model.crosshair.visible)&&(ej.util.isNullOrUndefined(t.fill)?h=="scatter"?(e.border.color=o.border&&o.border.color?o.border.color:f.border.color,e.border.width=o.border&&o.border.width?o.border.width:f.border.width):e.border.color=o.fill?o.fill:jQuery.type(this.chartObj.model.seriesColors[u])=="array"?this.chartObj.model.seriesColors[u][0].color:this.chartObj.model.seriesColors[u]:e.border.color=jQuery.type(t.fill)=="array"?t.fill._gradientStop[0].color:t.fill)):(s=n(this.chartObj.gSeriesEle).find("#"+this.chartObj.svgObject.id+"_Series"+u+"_Point"+r)[0].getBoundingClientRect(),e.size.width=(s.right-s.left)/2+15,e.size.height=(s.bottom-s.top)/2+15)),f._trackMarker=e,e},dataLabelSymbol:function(t,i,r,u,f,e,o,s,h,c){var l=h,y,p,v;if(s!="None"){y=l.model._isPieOfPie?ej.ejChart._getPieOfPiePoint(r,i):i._visiblePoints[r];p={startX:u,startY:f};h.model.enable3D||(v=c?c:l.gDataLabelEle[t]);v=l.model.enableCanvasRendering?null:v;var a=n.extend(!0,{},i.marker,y.marker),w={interior:a.dataLabel.fill,opacity:a.dataLabel.opacity,borderColor:a.dataLabel.border.color,borderWidth:a.dataLabel.border.width},b={style:w,gradientName:"symbol",symbolEle:v,width:e,height:o,point:y,location:p,seriesIndex:t,pointIndex:r,element:a,symbolName:s,id:l.svgObject.id+"_dataLabel_series"+t+"_"+r};this.drawSymbolStyle(b,l)}},drawSymbolStyle:function(t,i){var r=i,tt,it,rt,f=t.style,ot=t.gradientName,o=t.symbolEle,st=t.width,lt=t.dashArray,ht=t.height,l=t.point,c=t.location,v=t.seriesIndex,ct=t.visibility,w=t.pointIndex,ut=t.element,y=t.symbolName,d=t.trackSymbol,g=r.model.enableCanvasRendering,ft=r.model.AreaType=="polaraxes",e=r.model.series[v],p,b,et,u,a,s,h;if(f!=null&&(f.borderColor!=""&&(tt=f.borderColor?f.borderColor:"transparent"),rt=f.opacity,it=f.borderWidth<0?0:f.borderWidth),p=null,f.interior?p=ej.util.isNullOrUndefined(f.interior._gradientStop)?f.interior:f.interior._gradientStop:l.fill?p=jQuery.type(l.fill)=="array"?l.fill[0].color:l.fill:(b=r.model.pointColors,p=r.model.AreaType!="none"?e.type.toLowerCase()=="waterfall"&&e.positiveFill&&(l.y>0||l.waterfallSum>0)?e.positiveFill:r.model.seriesColors[v]:jQuery.type(b[w])=="array"?b[w][0].color:b[w]),r.symbolColorName=r.svgRenderer.createGradientElement(ot+v,p,0,0,0,n(r.svgObject).height(),o),et={dashArray:t.dashArray,ShapeSize:{width:st,height:ht},Style:{BorderColor:tt,BorderWidth:it,Opacity:rt,Visibility:ct,Color:r.symbolColorName},PointIndex:w,SeriesIndex:v,Imageurl:ut.imageUrl,Image:ut.image,ID:t.id},u=n.extend({},ej.EjSvgRender.commonChartEventArgs),u.data={location:c,style:et},r._trigger("symbolRendering",u),!u.cancel)if(g)c.startY=r.model.requireInvertedAxes?c.startY:c.startY+(e.yAxis.y?e.yAxis.y-r.canvasY:0),c.startX=r.model.requireInvertedAxes?c.startX:c.startX+(e.xAxis.x?e.xAxis.x-r.canvasX:0),u.data.location.startY=c.startY,ej.util.isNullOrUndefined(d)?r.model.AreaType=="cartesianaxes"?(o=r.svgRenderer.ctx,r.svgRenderer.ctx.save(),r.svgRenderer.ctx.beginPath(),r.model.requireInvertedAxes?r.svgRenderer.ctx.rect(e.yAxis.x,e.xAxis.y,e.yAxis.width,e.xAxis.height):r.svgRenderer.ctx.rect(e.xAxis.x,e.yAxis.y,e.xAxis.width,e.yAxis.height),r.svgRenderer.ctx.clip(),ej.EjSvgRender.chartSymbol["_draw"+y](u.data.location,u.data.style,r,o),r.svgRenderer.ctx.restore()):(g&&ft&&(r.svgRenderer.ctx.save(),r.svgRenderer.ctx.beginPath(),r.svgRenderer.ctx.arc(r.model.centerX,r.model.centerY,r.model.Radius,0,2*Math.PI,!1),r.svgRenderer.ctx.clip()),ej.EjSvgRender.chartSymbol["_draw"+y](u.data.location,u.data.style,r,o),g&&ft&&r.svgRenderer.ctx.restore()):(a=u.data.style.PointIndex,s=u.data.style.SeriesIndex,r.model.series[s].highlightSettings.enable||n("#"+r._id+"_selection_"+s+"_"+a+"_canvas").length==0&&r.svgRenderer.trackSymbol(u.data.style,u.data.location,y,d,r));else{var a=u.data.style.PointIndex,s=u.data.style.SeriesIndex,nt=e.type,k;e.highlightSettings.enable&&d&&!r.model.crosshair.visible?(f=n.extend(!0,u.data.style),h=e.highlightSettings,f.Style.Color=h.pattern.toLowerCase()=="none"||h.pattern==""?h.color!=""?h.color:f.Style.Color:"url(#"+h.pattern.toLowerCase()+"_Highlight_2D_"+s+")",f.Style.Opacity=h.opacity,f.Style.BorderColor=h.border.color,f.Style.BorderWidth=h.border.width,k=nt=="bubble"?n("#"+this.chartObj.svgObject.id+"_Series"+s+"_Point"+a).attr("class"):n("#"+this.chartObj.svgObject.id+"_Series"+s+"_Point"+a+"_symbol").attr("class"),k!="SelectionStyleseries"+s&&ej.EjSvgRender.chartSymbol["_draw"+y](u.data.location,f,r,r.model.enable3D?i.chart3D:o)):(k=nt=="scatter"?n("#"+r.svgObject.id+"_Series"+s+"_Point"+a+"_symbol").attr("class"):n("#"+r.svgObject.id+"_Series"+s+"_Point"+a).attr("class"),k!="SelectionStyleseries"+s&&ej.EjSvgRender.chartSymbol["_draw"+y](u.data.location,u.data.style,r,r.model.enable3D?i.chart3D:o))}!i.chart3D&&nt!="pieofpie"&&r.model.AreaType=="none"&&n(o).children().not("defs").length>r.model._visibleSeries[v]._visiblePoints.length&&n(o.childNodes[t.pointIndex]).replaceWith(n(o.childNodes[n(o.childNodes).length-1]))},drawSymbol:function(t,i,r,u,f,e,o,s){var ht=i.drawType,c,y,p,w,b,g,nt,tt,rt;ej.util.isNullOrUndefined(this.chartObj)&&(this.chartObj=e);var h=i._visiblePoints[r],l=i.type.toLowerCase(),it=l=="boxandwhisker"?s:r,ut=l=="bubble"||l=="scatter"?i.border.dashArray:"",a="None",v=this.changeCrossHairSymbol(h.marker?h.marker:i.marker,o,r,t,i);if(c=l.toLowerCase()=="boxandwhisker"?v?v:n.extend(!0,{},i.outlierSettings,h.outlierSettings,i.border,h.border):v?v:n.extend(!0,{},i.marker,h.marker),n.each(this.chartObj.model.symbolShape,function(n){c.shape.toLowerCase()==n.toLowerCase()&&(a=n)}),a!="None"){y=this.chartObj.model.AreaType=="cartesianaxes"?{startX:u+this.chartObj.canvasX,startY:f+this.chartObj.canvasY}:{startX:u,startY:f};l=="scatter"||i.drawType=="scatter"?(p=h.border&&h.border.color?h.border.color:i.border.color,w=h.border&&h.border.width?h.border.width:i.border.width,b={interior:c.fill,opacity:c.opacity,borderColor:p,borderWidth:w}):l=="boxandwhisker"?(p=h.border&&h.border.color?h.border.color=="transparent"?this.chartObj._saturationColor(i.fill,-.6):h.border.color:i.border.color=="transparent"?this.chartObj._saturationColor(i.fill,-.6):i.border.color,w=h.border&&h.border.width?h.border.width:i.border.width,b={interior:i.fill,opacity:i.opacity,borderColor:p,borderWidth:w}):b={interior:c.fill,opacity:c.opacity,borderColor:c.border.color,borderWidth:c.border.width};var ft=o?this.chartObj.gTrackerEle:this.chartObj.gSymbolGroupEle[t],et=o?this.chartObj.svgObject.id+"_trackSymbol_"+t+"_"+it:this.chartObj.svgObject.id+"_Series"+t+"_Point"+it+"_symbol",ot=o?"TrackSymbol":"symbol",k=c.size.width,d=c.size.height,st={style:b,gradientName:ot,symbolEle:ft,width:k,height:d,point:h,location:y,seriesIndex:t,pointIndex:r,element:c,visibility:h.visible?"visible":"hidden",symbolName:a,trackSymbol:o,id:et,dashArray:ut};this.chartObj.model.enableCanvasRendering||(g=this.chartObj.gSymbolGroupEle[t].childNodes[r]);ej.util.isNullOrUndefined(g)||a.toLowerCase()!="image"?this.drawSymbolStyle(st,this.chartObj,o):(g.setAttribute("width",k),g.setAttribute("height",d));i.type.toLowerCase()=="scatter"&&(nt=i.xAxis.x,tt=i.yAxis.y,this.chartObj.model.enableCanvasRendering&&(nt=0,tt=0),rt={X:nt+y.startX-d/2,Y:tt+y.startY-k/2,Height:d,Width:k},ej.EjSvgRender.utils._addRegion(this.chartObj,rt,i,null,r))}},chartAreaType:"cartesianAxes",requireInvertedAxes:!1,stackingSeries:!1,hiloTypes:!1};ej.ejLineSeries=t(ej.EjSeriesRender);ej.seriesTypes.line=ej.ejLineSeries;ej.ejStepLineSeries=t(ej.EjSeriesRender,{draw:function(n,t){var r=this.chartObj=n,v,e;t._animationType="path";var y=ej.EjSvgRender.utils._getStringBuilder(),i=t,w=this.setLineSeriesStyle(i);i.sorting&&(i.points=ej.DataManager(i.points,ej.Query().sortBy("xValue")).executeLocal());var u=t._visiblePoints=i.points.length>100||!i.enableSmartLabels?this.improveChartPerformance(i):this._isVisiblePoints(i),f=null,s="M",h,p,c,l,a,o=-1;for(e=0;e<u.length;e++)h=u[e],h.visible?(f!=null&&(u.length>o+1&&(p={xValue:u[o+1].xValue,YValues:[f.YValues[0]]},c=ej.EjSvgRender.utils._getPoint(f,i),l=ej.EjSvgRender.utils._getPoint(p,i),a=ej.EjSvgRender.utils._getPoint(u[o+1],i),r=this.chartObj,y.append(s+" "+(c.X+r.canvasX)+" "+(c.Y+r.canvasY)+" L "+(l.X+r.canvasX)+" "+(l.Y+r.canvasY)+" L "+(a.X+r.canvasX)+" "+(a.Y+r.canvasY)+" ")),s="L"),f=h,o=e):(f=null,s="M");v=y.toString();this._drawLinePath(i,w,v);this.chartObj.dragPoint?this.chartObj.svgRenderer.append(this.chartObj.gPreviewSeriesGroupEle,this.chartObj.gSeriesEle):this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)}});ej.ejStepAreaSeries=t(ej.EjSeriesRender,{draw:function(n,t,i){var e,h,d,w,b,u;this.chartObj=n;t._animationType="path";var p=this.chartObj.model.requireInvertedAxes,k,s=ej.EjSvgRender.utils._getStringBuilder(),f=t,g=this.setAreaSeriesStyle(f);f.sorting&&(f.points=ej.DataManager(f.points,ej.Query().sortBy("xValue")).executeLocal());var o=t._visiblePoints=f.points.length>100||!f.enableSmartLabels?this.improveChartPerformance(f):this._calculateVisiblePoints(f).visiblePoints,c=0,v=null,l;f.xAxis._valueType.toLowerCase()=="category"&&f.xAxis.labelPlacement.toLowerCase()!="onticks"&&(c=.5);var nt=ej.EjSeriesRender.prototype.getOrigin(this,f,i),a=null,y=!0,r=this.chartObj;for(e=0;e<=o.length;e++)e<o.length?o[e].visible?(l={xValue:o[e].xValue-c,YValues:[o[e].y]},u=ej.EjSvgRender.utils._getPoint(l,f),a||(a={xValue:o[e].xValue-c,YValues:[nt]},h=ej.EjSvgRender.utils._getPoint(a,f),s.append("M "+(h.X+r.canvasX)+" "+(h.Y+r.canvasY)+" ")),v!=null&&(d={xValue:l.xValue,YValues:[v.YValues[0]]},w=ej.EjSvgRender.utils._getPoint(d,f),y&&(s.append("L "+(b.X+r.canvasX)+" "+(b.Y+r.canvasY)+" "),y=!1),s.append("L "+(w.X+r.canvasX)+" "+(w.Y+r.canvasY)+" L "+(u.X+r.canvasX)+" "+(u.Y+r.canvasY)+" "),(c==0&&e==o.length-1||e<o.length-1&&!o[e+1].visible)&&(c>0?(l={xValue:o[e].xValue+c,YValues:[o[e].y]},u=ej.EjSvgRender.utils._getPoint(l,f),p?s.append("L "+(u.X+r.canvasX)+" "+(u.Y+r.canvasY)+" L "+(u.Y+r.canvasX)+" "+(h.X+r.canvasY)+" "):s.append("L "+(u.X+r.canvasX)+" "+(u.Y+r.canvasY)+" L "+(u.X+r.canvasX)+" "+(h.Y+r.canvasY)+" ")):p?s.append("L "+(h.X+r.canvasY)+" "+(u.Y+r.canvasX)+" "):s.append("L "+(u.X+r.canvasX)+" "+(h.Y+r.canvasY)+" "),a=null,v=null,y=!0)),a&&(b=u,v=l)):(a=null,v=null,y=!0):o[e-1].visible&&c>0&&(l={xValue:o[e-1].xValue+c,YValues:[o[e-1].y]},u=ej.EjSvgRender.utils._getPoint(l,f),p?s.append("L "+(u.X+r.canvasX)+" "+(u.Y+r.canvasY)+" L "+(u.Y+r.canvasX)+" "+(h.X+r.canvasY)+" "):s.append("L "+(u.X+r.canvasX)+" "+(u.Y+r.canvasY)+" L "+(u.X+r.canvasX)+" "+(h.Y+r.canvasY)+" "));k=s.toString();this.drawAreaPath(f,g,k);this.chartObj.dragPoint?this.chartObj.svgRenderer.append(this.chartObj.gPreviewSeriesGroupEle,this.chartObj.gSeriesEle):this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)}});ej.seriesTypes.steparea=ej.ejStepAreaSeries;ej.seriesTypes.stepline=ej.ejStepLineSeries;ej.ejColumnSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var v,e,h,a,c,o,d,tt,it,w;this.chartObj=t;v=this.chartObj.model.requireInvertedAxes;i._animationType="rect";i.columnFacet=="cylinder"&&(i._animationType="cylinder");var u=i,s=u.cornerRadius,y=n.inArray(u,this.chartObj.model._visibleSeries),rt=ej.EjSeriesRender.prototype.getOrigin(this,u,r),b=this.getSideBySideInfo(u,r);u.dragSettings.enable&&(u.sidebysideInfo=b);var p=this._isVisiblePoints(u),k=ej.EjSvgRender.utils._getTransform(u.xAxis,u.yAxis,v),ut,ft={id:this.chartObj.svgObject.id+"_SeriesGroup_"+y,transform:"translate("+k.x+","+k.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(ft),e=this,h=0;h<p.length;h++)if(a=h,c=p[h],ut=p[h].marker,o=c.YValues[0],d=rt,c.visible){var g=e.calculateSides(c,b),et=g.x1,ot=g.x2,l=this.chartObj.setStyle(e,u,y,a),f=e.getRectangle(et,o,ot,d,u,t),st=Math.min(0,f.Width),ht=Math.min(0,f.Height),nt;(st==0||ht==0)&&f.Width>0&&(i={id:e.chartObj.svgObject.id+"_Series"+y+"_Point"+a,x:f.X+e.chartObj.canvasX,y:f.Y+e.chartObj.canvasY,width:f.Width,height:f.Height,fill:l.interior,plot:o<0?"negative":"positive","stroke-width":l.borderWidth,opacity:l.opacity,stroke:l.borderColor,"stroke-dasharray":l.dashArray},tt={isColumn:!0,stacking:!1,isLastSeries:!0},u.columnFacet=="cylinder"?e.chartObj.svgRenderer.drawCylinder(i,e.gSeriesGroupEle,tt):typeof s!="object"&&s>0||s.topLeft>0||s.bottomLeft>0||s.topRight>0||s.bottomRight>0?(it=ej.EjSvgRender.utils._calculateroundedCorner(s,i),i.d=it,u._animationType="path",e.chartObj.svgRenderer.drawPath(i,e.gSeriesGroupEle)):u.columnFacet=="rectangle"&&e.chartObj.svgRenderer.drawRect(i,e.gSeriesGroupEle),w=ej.EjSvgRender.utils._getSvgXY(f.X,f.Y,u,e.chartObj),nt={X:w.X,Y:w.Y,Width:f.Width,Height:f.Height},ej.EjSvgRender.utils._addRegion(e.chartObj,nt,u,c,a));i.plot=o<0?"negative":"positive";c.symbolLocation=v?{X:o<(u.xAxis._crossValue||0)&&!u.yAxis.isInversed||u.yAxis.isInversed&&o>(u.xAxis._crossValue||0)?f.X:f.X+f.Width,Y:f.Y+f.Height/2}:{X:f.X+f.Width/2,Y:o<(u.xAxis._crossValue||0)&&!u.yAxis.isInversed||u.yAxis.isInversed&&o>(u.xAxis._crossValue||0)?f.Y+f.Height:f.Y}}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},isRegion:!0});ej.seriesTypes.column=ej.ejColumnSeries;ej.ejStackingColumnSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var e,s,d,g,p;this.chartObj=t;i._animationType="rect";i.columnFacet=="cylinder"&&(i._animationType="cylinder");var w=this.chartObj.model.requireInvertedAxes,u=i,o=u.cornerRadius,a=n.inArray(u,this.chartObj.model._visibleSeries),tt=this.getSideBySideInfo(u,r),it=this._isVisiblePoints(u),b=ej.EjSvgRender.utils._getTransform(u.xAxis,u.yAxis,w),rt={id:this.chartObj.svgObject.id+"_SeriesGroup_"+a,transform:"translate("+b.x+","+b.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(rt),e=this,s=0;s<it.length;s++){var v=s,l=u._visiblePoints[s],ut=u.stackedValue.StartValues[s],h=u.stackedValue.EndValues[s];if(l.visible){var k=e.calculateSides(l,tt),ft=k.x1,et=k.x2,c=this.chartObj.setStyle(e,u,a,v),f=e.getRectangle(ft,h,et,ut,u,t),ot=Math.min(0,f.Width),st=Math.min(0,f.Height),y,ht=u.type=="stackingcolumn100"?!0:!1;if((ot==0||st==0)&&f.Width>0){i={id:e.chartObj.svgObject.id+"_Series"+a+"_Point"+v,x:f.X+e.chartObj.canvasX,y:f.Y+e.chartObj.canvasY,width:f.Width,height:f.Height,fill:c.interior,"stroke-width":c.borderWidth,plot:h<0?"negative":"positive",opacity:c.opacity,stroke:c.borderColor,"stroke-dasharray":c.dashArray};d={isColumn:!0,stacking:ht,isLastSeries:u.stackedValue.stackedSeries};u.columnFacet=="cylinder"?e.chartObj.svgRenderer.drawCylinder(i,e.gSeriesGroupEle,d):typeof o!="object"&&o>0||o.topLeft>0||o.bottomLeft>0||o.topRight>0||o.bottomRight>0?(g=ej.EjSvgRender.utils._calculateroundedCorner(o,i),i.d=g,u._animationType="path",e.chartObj.svgRenderer.drawPath(i,e.gSeriesGroupEle)):u.columnFacet=="rectangle"&&e.chartObj.svgRenderer.drawRect(i,e.gSeriesGroupEle);p=ej.EjSvgRender.utils._getSvgXY(f.X,f.Y,u,e.chartObj);y={X:p.X,Y:p.Y,Width:f.Width,Height:f.Height};var ct=f.Width/2,lt=Math.round(f.Height),nt=Math.round(ct/4);nt==lt&&(y.Height=f.Height+2*nt);ej.EjSvgRender.utils._addRegion(e.chartObj,y,u,l,v)}l.symbolLocation=w?{X:h<(u.xAxis._crossValue||0)&&!u.yAxis.isInversed||u.yAxis.isInversed&&h>(u.xAxis._crossValue||0)?f.X:f.X+f.Width,Y:f.Y+f.Height/2}:{X:f.X+f.Width/2,Y:h<(u.xAxis._crossValue||0)&&!u.yAxis.isInversed||u.yAxis.isInversed&&h>(u.xAxis._crossValue||0)?f.Y+f.Height:f.Y}}}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},stackingSeries:!0,isRegion:!0});ej.seriesTypes.stackingcolumn=ej.ejStackingColumnSeries;ej.seriesTypes.stackingcolumn100=ej.ejStackingColumnSeries;ej.seriesTypes.rangecolumn=ej.ejRangeColumnSeries;ej.ejRangeColumnSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var e,c,g,p;this.chartObj=t;i._animationType="rect";var w=this.chartObj.model.requireInvertedAxes,f=i,s=f.cornerRadius,v=n.inArray(f,this.chartObj.model._visibleSeries),nt=this.getSideBySideInfo(f,r),b=this._isVisiblePoints(f),a=ej.EjSvgRender.utils._getTransform(f.xAxis,f.yAxis,w),tt={id:this.chartObj.svgObject.id+"_SeriesGroup_"+v,transform:"translate("+a.x+","+a.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(tt),e=this,c=0;c<b.length;c++){var y=c,o=b[c],h=o.YValues[0],it=o.YValues[1];if(o.visible){var k=e.calculateSides(o,nt),rt=k.x1,ut=k.x2,l=this.chartObj.setStyle(e,f,v,y),u=e.getRectangle(rt,h,ut,it,f,t),ot=e.chartObj.model.m_AreaBounds.Width,ft=Math.min(0,u.Width),et=Math.min(0,u.Height),d;(ft==0||et==0)&&(i={id:e.chartObj.svgObject.id+"_Series"+v+"_Point"+y,x:u.X+e.chartObj.canvasX,y:u.Y+e.chartObj.canvasY,width:u.Width,height:u.Height,fill:l.interior,"stroke-width":l.borderWidth,opacity:l.opacity,stroke:l.borderColor,"stroke-dasharray":l.dashArray},typeof s!="object"&&s>0||s.topLeft>0||s.bottomLeft>0||s.topRight>0||s.bottomRight>0?(g=ej.EjSvgRender.utils._calculateroundedCorner(s,i),i.d=g,f._animationType="path",e.chartObj.svgRenderer.drawPath(i,e.gSeriesGroupEle)):e.chartObj.svgRenderer.drawRect(i,e.gSeriesGroupEle,a.y),e.chartObj.svgRenderer.drawRect(i,e.gSeriesGroupEle,a.y),p=ej.EjSvgRender.utils._getSvgXY(u.X,u.Y,f,e.chartObj),d={X:p.X,Y:p.Y,Width:u.Width,Height:u.Height},ej.EjSvgRender.utils._addRegion(e.chartObj,d,f,o,y));f.type.toLowerCase()=="waterfall"&&(h=o.waterfallSum?o.waterfallSum:o.y);o.symbolLocation=w?{X:h<0&&!f.yAxis.isInversed||f.yAxis.isInversed&&h>0?u.X:u.X+u.Width,Y:u.Y+u.Height/2}:{X:u.X+u.Width/2,Y:h<0&&!f.yAxis.isInversed||f.yAxis.isInversed&&h>0?u.Y+u.Height:u.Y}}}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},hiloTypes:!0,isRegion:!0});ej.seriesTypes.rangecolumn=ej.ejRangeColumnSeries;ej.ejBoxandwhiskerSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var ut,wt,u,a,rt,w;this.chartObj=t;ut=this.chartObj.model.requireInvertedAxes;i._animationType="rect";var f=i,l=n.inArray(f,this.chartObj.model._visibleSeries),ni=ej.EjSeriesRender.prototype.getOrigin(this,f,r),bt=this.getSideBySideInfo(f,r),b=this._isVisiblePoints(f),ft=ej.EjSvgRender.utils._getTransform(f.xAxis,f.yAxis,ut),kt,et=0,dt={id:this.chartObj.svgObject.id+"_SeriesGroup_"+l,transform:"translate("+ft.x+","+ft.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(dt),u=this,a=0;a<b.length;a++){var h=a,ot,v,k,st,d,ht,ct,o,e,lt,at,l,gt,vt,y,g,nt,p,yt,s,tt,pt,it,c=b[a];if(kt=b[a].marker,ot=c.YValues[0],v=u.calculateMean(ot,f,h),k=v.UpperQuartile,st=v.LowerQuartile,c.visible&&(d=u.calculateSides(c,bt),ht=d.x1,ct=d.x2,o=this.chartObj.setStyle(u,f,l,h),e=u.getRectangle(ht,k,ct,st,f,t),lt=Math.min(0,e.Width),at=Math.min(0,e.Height),l=n.inArray(f,this.chartObj.model._visibleSeries),wt=this.chartObj.setStyle(this,f,l,a),gt=ej.EjSvgRender.utils._getStringBuilder(),vt={xValue:c.xValue,YValues:v.midvalue},y=ej.EjSvgRender.utils._getPoint(vt,f),rt=o.borderColor=="transparent"?this.chartObj._saturationColor(o.interior,-.6):o.borderColor,g,(lt==0||at==0)&&e.Width>0)){for(i={id:u.chartObj.svgObject.id+"_Series"+l+"_Point"+h,x:e.X+u.chartObj.canvasX,y:e.Y+u.chartObj.canvasY,width:e.Width,height:e.Height,fill:o.interior,"stroke-width":o.borderWidth,plot:k<0?"negative":"positive",opacity:o.opacity,stroke:rt,"stroke-dasharray":o.dashArray},nt={id:this.chartObj.svgObject.id+"_Series"+l+"_Point"+h+"_median",x1:f._isTransposed?y.X+u.chartObj.canvasX:e.X+u.chartObj.canvasX,y1:f._isTransposed?e.Y+u.chartObj.canvasY:y.Y+u.chartObj.canvasY,x2:f._isTransposed?y.X+u.chartObj.canvasX:e.X+e.Width+u.chartObj.canvasX,y2:f._isTransposed?e.Y+e.Height+u.chartObj.canvasY:y.Y+u.chartObj.canvasY,"stroke-width":o.borderWidth,stroke:rt},u.chartObj.svgRenderer.drawRect(i,u.gSeriesGroupEle),u.chartObj.svgRenderer.drawLine(nt,u.gSeriesGroupEle),p=u.calculateBoxAndWhiskerPath(i,e,nt,v,f,c,h),i.d=p.lowerWhisker,i.id=i.id+"_whisker",u.chartObj.svgRenderer.drawPath(i,u.gSeriesGroupEle),i.d=p.upperWhisker,u.chartObj.svgRenderer.drawPath(i,u.gSeriesGroupEle),f.showMedian==!0&&(i.d=p.mean,u.chartObj.svgRenderer.drawPath(i,u.gSeriesGroupEle)),w=0;w<v.outliers.length;w++)yt={xValue:c.xValue,YValues:v.outliers[w]},s=ej.EjSvgRender.utils._getPoint(yt,f),s.X=f._isTransposed?s.X:e.X+e.Width/2,s.Y=f._isTransposed?e.Y+e.Height/2:s.Y,this.drawSymbol(l,f,h,s.X,s.Y,null,null,et),et++,tt=ej.EjSvgRender.utils._getSvgXY(s.X,s.Y,f,u.chartObj),pt={X:tt.X-f.outlierSettings.size.width/2,Y:tt.Y-f.outlierSettings.size.height/2,Width:f.outlierSettings.size.width,Height:f.outlierSettings.size.height},ej.EjSvgRender.utils._addRegion(u.chartObj,pt,f,c,h);it=ej.EjSvgRender.utils._getSvgXY(e.X,e.Y,f,u.chartObj);g={X:it.X,Y:it.Y,Width:e.Width,Height:e.Height};ej.EjSvgRender.utils._addRegion(u.chartObj,g,f,c,h)}}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},isRegion:!0});ej.seriesTypes.boxandwhisker=ej.ejBoxandwhiskerSeries;ej.ejWaterfallSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var o,v,g,c,u,f,y,nt,p,l,w,tt,b,k,it,rt,ut,ft,et,d,e;ej.ejRangeColumnSeries.prototype.draw.call(this,t,i,r);i._animationType="rect";var a=this.chartObj.model.chartRegions,s=[],ot=this.chartObj.model.m_AreaBounds,h=n.inArray(i,this.chartObj.model._visibleSeries);for(i.index=h,o=0,v=0;o<a.length;o++)h==a[o].SeriesIndex&&(s[v]=a[o],v+=1);for(g={id:this.chartObj.svgObject.id+"_SeriesGroup_waterfallLine_"+h},this.connectorLineGroup=this.chartObj.svgRenderer.createGroup(g),e=0;e<s.length-1;e++)c=ej.EjSvgRender.utils._getStringBuilder(),u=s[e].Region.Bounds,f=s[e+1].Region.Bounds,i.isTransposed?(k=Math.ceil(u.X),rt=Math.ceil(u.Width),it=Math.ceil(f.X),ut=Math.ceil(f.Width),l=Math.ceil(u.X+u.Width),w=Math.ceil(f.X+f.Width),b=l==w?u.X+u.Width:k==it?u.X:k==w?u.X:u.X+u.Width,c.append("M "+b+" "+(u.Y+u.Height)+" L "+b+" "+f.Y)):(nt=Math.ceil(u.Y),ft=Math.ceil(u.Height),p=Math.ceil(f.Y),et=Math.ceil(f.Height),l=Math.ceil(u.Y+u.Height),y=nt==p?u.Y:l==p?f.Y:f.Y+f.Height,c.append("M "+u.X+" "+y+" L "+(f.X+f.Width)+" "+y)),d=c.toString(),d!=""&&u.Height>=0&&(tt={id:this.chartObj.svgObject.id+"_waterFall_"+h+"_connectorLine_"+e,fill:"none","stroke-dasharray":i.connectorLine.dashArray,"stroke-width":i.connectorLine.width,stroke:i.connectorLine.color,opacity:i.connectorLine.opacity,d:d},this.chartObj.svgRenderer.drawPath(tt,this.connectorLineGroup));this.chartObj.svgRenderer.append(this.connectorLineGroup,this.chartObj.gSeriesEle);i.enableAnimation&&!i._animatedSeries&&this.chartObj.svgRenderer._setAttr(this.connectorLineGroup,{visibility:"hidden"})},hiloTypes:!1,isRegion:!0});ej.seriesTypes.waterfall=ej.ejWaterfallSeries;ej.ejStackingBarSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var e,s,d,g,nt,y;this.chartObj=t;i._animationType="rect";i.columnFacet=="cylinder"&&(i._animationType="cylinder");var p=this.chartObj.model.requireInvertedAxes,u=i,o=u.cornerRadius,a=n.inArray(u,this.chartObj.model._visibleSeries),tt=this.getSideBySideInfo(u,r),w=this._isVisiblePoints(u),b=ej.EjSvgRender.utils._getTransform(u.xAxis,u.yAxis,p),it={id:this.chartObj.svgObject.id+"_SeriesGroup_"+a,transform:"translate("+b.x+","+b.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(it),e=this,s=0;s<w.length;s++){var v=s,l=w[s],h=u.stackedValue.EndValues[s],rt=u.stackedValue.StartValues[s];if(l.visible){var k=e.calculateSides(l,tt),ut=k.x1,ft=k.x2,c=this.chartObj.setStyle(e,u,a,v),f=e.getRectangle(ut,h,ft,rt,u,t),et=Math.min(0,f.Width),ot=Math.min(0,f.Height),st=u.type=="stackingbar100"?!0:!1;(et==0||ot==0)&&(i={id:e.chartObj.svgObject.id+"_Series"+a+"_Point"+v,x:f.X+e.chartObj.canvasX,y:f.Y+e.chartObj.canvasY,width:f.Width,height:f.Height,fill:c.interior,"stroke-width":c.borderWidth,opacity:c.opacity,stroke:c.borderColor,"stroke-dasharray":c.dashArray},g={isColumn:!1,stacking:st,isLastSeries:u.stackedValue.stackedSeries},u.columnFacet=="cylinder"?e.chartObj.svgRenderer.drawCylinder(i,e.gSeriesGroupEle,g):typeof o!="object"&&o>0||o.topLeft>0||o.bottomLeft>0||o.topRight>0||o.bottomRight>0?(nt=ej.EjSvgRender.utils._calculateroundedCorner(o,i),i.d=nt,u._animationType="path",e.chartObj.svgRenderer.drawPath(i,e.gSeriesGroupEle)):u.columnFacet=="rectangle"&&e.chartObj.svgRenderer.drawRect(i,e.gSeriesGroupEle),y=ej.EjSvgRender.utils._getSvgXY(f.X,f.Y,u,e.chartObj),d={X:y.X,Y:y.Y,Width:f.Width,Height:f.Height},ej.EjSvgRender.utils._addRegion(e.chartObj,d,u,l,v));l.symbolLocation=p?{X:h<(u.yAxis._crossValue||0)&&!u.yAxis.isInversed||u.yAxis.isInversed&&h>(u.yAxis._crossValue||0)?f.X:f.X+f.Width,Y:f.Y+f.Height/2}:{X:f.X+f.Width/2,Y:h<(u.yAxis._crossValue||0)&&!u.yAxis.isInversed||u.yAxis.isInversed&&h>(u.yAxis._crossValue||0)?f.Y+f.Height:f.Y}}}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},stackingSeries:!0,requireInvertedAxes:!0,isRegion:!0});ej.seriesTypes.stackingbar=ej.ejStackingBarSeries;ej.seriesTypes.stackingbar100=ej.ejStackingBarSeries;ej.ejBarSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var e,h,g,nt,tt,y;this.chartObj=t;i._animationType="rect";i.columnFacet=="cylinder"&&(i._animationType="cylinder");var p=this.chartObj.model.requireInvertedAxes,u=i,o=u.cornerRadius,a=n.inArray(u,this.chartObj.model._visibleSeries),it=ej.EjSeriesRender.prototype.getOrigin(this,u,r),ht=n.extend(!0,{},this.chartObj.model.seriesStyle,u.style),w=this.getSideBySideInfo(u,r);u.dragSettings.enable&&(u.sidebysideInfo=w);var b=this._isVisiblePoints(u),k=ej.EjSvgRender.utils._getTransform(u.xAxis,u.yAxis,p),rt={id:this.chartObj.svgObject.id+"_SeriesGroup_"+a,transform:"translate("+k.x+","+k.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(rt),e=this,h=0;h<b.length;h++){var v=h,c=b[h],s=c.YValues[0],ut=it;if(c.visible){var d=e.calculateSides(c,w),ft=d.x1,et=d.x2,l=this.chartObj.setStyle(e,u,a,v),f=e.getRectangle(ft,s,et,ut,u,t),ot=Math.min(0,f.Width),st=Math.min(0,f.Height);(ot==0||st==0)&&(i={id:e.chartObj.svgObject.id+"_Series"+a+"_Point"+v,x:f.X+e.chartObj.canvasX,y:f.Y+e.chartObj.canvasY,width:f.Width,height:f.Height,fill:l.interior,"stroke-width":l.borderWidth,plot:s<0?"negative":"positive",opacity:l.opacity,stroke:l.borderColor,"stroke-dasharray":l.dashArray},nt={isColumn:!1,stacking:!1,isLastSeries:!0},u.columnFacet=="cylinder"?e.chartObj.svgRenderer.drawCylinder(i,e.gSeriesGroupEle,nt):typeof o!="object"&&o>0||o.topLeft>0||o.bottomLeft>0||o.topRight>0||o.bottomRight>0?(tt=ej.EjSvgRender.utils._calculateroundedCorner(o,i),i.d=tt,u._animationType="path",e.chartObj.svgRenderer.drawPath(i,e.gSeriesGroupEle)):u.columnFacet=="rectangle"&&e.chartObj.svgRenderer.drawRect(i,e.gSeriesGroupEle),y=ej.EjSvgRender.utils._getSvgXY(f.X,f.Y,u,e.chartObj),g={X:y.X,Y:y.Y,Width:f.Width,Height:f.Height},ej.EjSvgRender.utils._addRegion(e.chartObj,g,u,c,v));c.symbolLocation=p?{X:s<(u.xAxis._crossValue||0)&&!u.yAxis.isInversed||u.yAxis.isInversed&&s>(u.xAxis._crossValue||0)?f.X:f.X+f.Width,Y:f.Y+f.Height/2}:{X:f.X+f.Width/2,Y:s<(u.xAxis._crossValue||0)&&!u.yAxis.isInversed||u.yAxis.isInversed&&s>(u.xAxis._crossValue||0)?f.Y+f.Height:f.Y}}}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},requireInvertedAxes:!0,isRegion:!0});ej.seriesTypes.bar=ej.ejBarSeries;ej.ejStackingAreaSeries=t(ej.EjSeriesRender,{draw:function(n,t){var i,h,a,s;this.chartObj=n;t._animationType="path";var v,e,f,o=ej.EjSvgRender.utils._getStringBuilder(),r=t,b=this.setAreaSeriesStyle(r),u=this._isVisiblePoints(r),y=Math.max(t.yAxis.visibleRange.min,r.stackedValue.StartValues[0]),c=this.chartObj.canvasX,l=this.chartObj.canvasY,a={xValue:u[0].xValue,YValues:[y]},s=ej.EjSvgRender.utils._getPoint(a,r),p=0,w=r.stackedValue.EndValues.length;for(o.append("M "+(s.X+c)+" "+(s.Y+l)+" "),i=0;i<=w;i++)if(i!=w&&u[i].visible)e={xValue:u[i].xValue,YValues:[r.stackedValue.EndValues[i]]},u[i].visible&&(f=u[i].location=ej.EjSvgRender.utils._getPoint(e,r),o.append("L "+(f.X+c)+" "+(f.Y+l)+" "),u[i].YValues[0]=e.YValues[0]);else{for(y=r.stackedValue.StartValues[i+1],h=i-1;h>=p;h--)e={xValue:u[h].xValue,YValues:[r.stackedValue.StartValues[h]]},f=ej.EjSvgRender.utils._getPoint(e,r),o.append("L "+(f.X+c)+" "+(f.Y+l)+" ");u[i+1]&&u[i+1].visible&&(a={xValue:u[i+1].xValue,YValues:[r.stackedValue.StartValues[i+1]]},s=ej.EjSvgRender.utils._getPoint(a,r),o.append("M "+(s.X+c)+" "+(s.Y+l)+" "));p=i+1}v=o.toString();this.drawAreaPath(r,b,v);this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},stackingSeries:!0});ej.seriesTypes.stackingarea=ej.ejStackingAreaSeries;ej.seriesTypes.stackingarea100=ej.ejStackingAreaSeries;ej.ejAreaSeries=t(ej.EjSeriesRender,{draw:function(n,t,i){var a,f,e,w,l;this.chartObj=n;t._animationType="path";var o=ej.EjSvgRender.utils._getStringBuilder(),r=t,b=this.setAreaSeriesStyle(r),v=this.chartObj;r.sorting&&(r.points=ej.DataManager(r.points,ej.Query().sortBy("xValue")).executeLocal());var u=this.chartObj.dragPoint?r.pointCollection:this._isVisiblePoints(r),h=ej.EjSeriesRender.prototype.getOrigin(this,r,i),s,c=[];if(c[0]=v.canvasX,c[1]=v.canvasY,u.length>0){for(f=0;f<u.length;f++)if(u[f].visible)if(u.length>f+1){if(s||(s={xValue:u[f].xValue,YValues:[h]},e=ej.EjSvgRender.utils._getPoint(s,r),o.append("M "+e.X+" "+e.Y+" ")),e=ej.EjSvgRender.utils._getPoint(u[f],r),o.append("L "+e.X+" "+e.Y+" "),!u[f+1].visible){var k={xValue:u[f].xValue,YValues:[h]},y=ej.EjSvgRender.utils._getPoint(k,r),p=ej.EjSvgRender.utils._getPoint(s,r);o.append("L "+y.X+" "+y.Y+" L "+p.X+" "+p.Y+" ");s=null}}else u[f-1]&&u[f-1].visible&&(e=ej.EjSvgRender.utils._getPoint(u[f],r),o.append("L "+e.X+" "+e.Y+" "));w={xValue:u[u.length-1].xValue,YValues:[h]};l=ej.EjSvgRender.utils._getPoint(w,r);u.length>1&&o.append("L "+l.X+" "+l.Y+" ");a=o.toString();this.drawAreaPath(r,b,a,c)}this.chartObj.dragPoint?this.chartObj.svgRenderer.append(this.chartObj.gPreviewSeriesGroupEle,this.chartObj.gSeriesEle):this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)}});ej.seriesTypes.area=ej.ejAreaSeries;ej.ejRangeAreaSeries=t(ej.EjSeriesRender,{draw:function(t,i){var b,u,v,y,s,l,o,h,r,p,f,w,a;this.chartObj=t;i._animationType="path";var c=ej.EjSvgRender.utils._getStringBuilder(),e=i,k=this.setAreaSeriesStyle(e),d=n.inArray(e,this.chartObj.model._visibleSeries);for(e.points=ej.DataManager(e.points,ej.Query().sortBy("xValue")).executeLocal(),u=this._isVisiblePoints(e),v=[],v[0]=this.chartObj.canvasX,v[1]=this.chartObj.canvasY,s=[],r=0;r<u.length;r++)if(s[r]={Region:{PointIndex:r},SeriesIndex:d,region:[]},u[r].visible&&(y||(l=u[r].low,y={xValue:u[r].xValue,YValues:[l]},o=ej.EjSvgRender.utils._getPoint(y,e),c.append("M "+o.X+" "+o.Y+" ")),o=ej.EjSvgRender.utils._getPoint(u[r],e),c.append("L "+o.X+" "+o.Y+" "),s[r].region.push({X:o.X,Y:o.Y}),r!=0&&s[r-1].region.push({X:o.X,Y:o.Y}),r+1<u.length&&!u[r+1].visible&&r+1!=u.length-1)){for(h=r;h>=0;h--)if(u[h].visible)l=u[h].low,p={xValue:u[h].xValue,YValues:[l]},f=ej.EjSvgRender.utils._getPoint(p,e),c.append("L "+f.X+" "+f.Y+" "),s[h].region.push({X:f.X,Y:f.Y}),h!=0&&s[h-1].region.push({X:f.X,Y:f.Y});else break;y=null}for(r=u.length-1;r>=0;r--)if(u[r].visible)l=u[r].low,p={xValue:u[r].xValue,YValues:[l]},f=ej.EjSvgRender.utils._getPoint(p,e),c.append("L "+f.X+" "+f.Y+" "),s[r].region.push({X:f.X,Y:f.Y}),r!=0&&s[r-1].region.push({X:f.X,Y:f.Y});else if(u.length>r&&u[r].visible){f=ej.EjSvgRender.utils._getPoint(u[r],e);c.append("L "+f.X+" "+f.Y+" ");break}else if(r!=u.length-1){for(w=0,a=r-1;a>=0;a--)if(u[a].visible)w++;else if(!u[a].visible)break;r=r-w}b=c.toString();this.chartObj.model.chartRegions.push(s);this.drawAreaPath(e,k,b,v);this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},hiloTypes:!0});ej.seriesTypes.rangearea=ej.ejRangeAreaSeries;ej.ejSplineRangeAreaSeries=t(ej.EjSeriesRender,{draw:function(n,t,i){this.chartObj=n;var r=new ej.seriesTypes.splinearea;r.draw(n,t,i)},chartAreaType:"cartesianAxes",hiloTypes:!0});ej.seriesTypes.splinerangearea=ej.ejSplineRangeAreaSeries;ej.ejSplineSeries=t(ej.EjSeriesRender,{draw:function(n,t,i){var o,h;i.seriesCollection||(i.seriesCollection={},t._name=ej.util.isNullOrUndefined(t.name)?"":t.name.replace(/ /g,""));i.seriesCollection[t._name]||(i.seriesCollection[t._name]={});this.chartObj=n;t._animationType="path";var r=t,c="",l=ej.EjSvgRender.utils._getStringBuilder(),nt=this.setLineSeriesStyle(r),s=this.chartObj.dragPoint?r.pointCollection:this._isVisiblePoints(r),a=i.seriesCollection[r._name].naturalSpline||this.naturalSpline(s,r),f=null,e=null,v=-1,tt=0,it=i.seriesCollection[r._name].controlPoints||[];for(o=0;o<s.length;o++)if(h=o,e=s[o],e.visible){if(f!=null){var y=null,p=null,w=it[tt++]||this.getBezierControlPoints(f,e,a[v],a[h],0,r,this);y=w.controlPoint1;p=w.controlPoint2;var b=ej.EjSvgRender.utils._getPoint(f,r),k=ej.EjSvgRender.utils._getPoint(e,r),d=ej.EjSvgRender.utils._getPoint(y,r),g=ej.EjSvgRender.utils._getPoint(p,r),u=this.chartObj;l.append("M "+(b.X+u.canvasX)+" "+(b.Y+u.canvasY)+" C "+(d.X+u.canvasX)+" "+(d.Y+u.canvasY)+" "+(g.X+u.canvasX)+" "+(g.Y+u.canvasY)+" "+(k.X+u.canvasX)+" "+(k.Y+u.canvasY)+" ")}f=e;v=h}else f=null;c=l.toString();this._drawLinePath(r,nt,c);this.chartObj.dragPoint?this.chartObj.svgRenderer.append(this.chartObj.gPreviewSeriesGroupEle,this.chartObj.gSeriesEle):this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)}});ej.seriesTypes.spline=ej.ejSplineSeries;ej.ejSplineAreaSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var h,ni,ot,wt,k,it,bt,kt,dt,ti,tt,f,ii,ut;r.seriesCollection||(r.seriesCollection={},i._name=ej.util.isNullOrUndefined(i.name)?"":i.name.replace(/ /g,""));r.seriesCollection[i._name]||(r.seriesCollection[i._name]={});this.chartObj=t;i._animationType="path";var st=this.chartObj.model.requireInvertedAxes,u=i,p="",w=ej.EjSvgRender.utils._getStringBuilder(),ri=this.setAreaSeriesStyle(u),ht=0;u.sorting&&(u.points=ej.DataManager(u.points,ej.Query().sortBy("xValue")).executeLocal());var s=this.chartObj.dragPoint?u.pointCollection:this._isVisiblePoints(u),ft=r.seriesCollection[u._name].naturalSpline||this.naturalSpline(s,u,ht),fi=r.seriesCollection[u._name].naturalSpline1||this.naturalSpline(s,u,1),d=null,l=null,ct=-1,g=[],lt=ej.EjSeriesRender.prototype.getOrigin(this,u,r),b=null,at=!0,o=this.chartObj,vt=[],ui=0,et=r.seriesCollection[u._name].controlPoints||[];vt[0]=o.canvasX;vt[1]=o.canvasY;var gt,a=o.model._seriesIndex,yt=null,nt=[],e=u.type.toLowerCase(),pt=u.emptyPointSettings;for(o.model._previousSeries=ej.util.isNullOrUndefined(o.model._previousSeries)?null:o.model._previousSeries,u._prevpointIndex=null,f=0;f<s.length;f++)if(g[f]={Region:{PointIndex:f},SeriesIndex:a,region:[]},h=f,l=s[f],l.YValues[0]=e.indexOf("stackingsplinearea")!=-1?u.stackedValue.EndValues[f]:l.YValues[0],l.visible){if(!b){if(a==0||e.indexOf("stackingsplinearea")==-1)b={xValue:s[f].xValue,YValues:[lt]};else{for(ni=n.inArray(i,o.model._visibleSeries),ot=ni;ot>0;ot--)if(wt=o.model.series[ot-1],wt.visibility!="hidden"){yt=wt.points;break}b={xValue:s[f].xValue,YValues:[yt[f].YValues[0]]}}k=ej.EjSvgRender.utils._getPoint(b,u)}if(e=="splinerangearea"&&(it=ej.EjSvgRender.utils._getPoint(s[f],u),g[f].region.push({X:it.X,Y:it.Y}),f!=0&&g[f-1].region.push({X:it.X,Y:it.Y})),d!=null){bt=null;kt=null;dt=e.indexOf("stackingsplinearea")!=-1||e=="splinerangearea"?et[h-1]||this.getBezierControlPoints(d,l,ft[ct],ft[h],ht,u,this):et[ui++]||this.getBezierControlPoints(d,l,ft[ct],ft[h],ht,u,this);bt=dt.controlPoint1;kt=dt.controlPoint2;var c=ej.EjSvgRender.utils._getPoint(d,u),rt=ej.EjSvgRender.utils._getPoint(l,u),v=ej.EjSvgRender.utils._getPoint(bt,u),y=ej.EjSvgRender.utils._getPoint(kt,u);if(at&&(st?w.append("M "+k.X+" "+c.Y+" L "+c.X+" "+c.Y+" "):w.append("M "+c.X+" "+k.Y+" L "+c.X+" "+c.Y+" "),at=!1),w.append("C "+v.X+" "+v.Y+" "+y.X+" "+y.Y+" "+rt.X+" "+rt.Y+" "),e=="splinerangearea"&&(nt[h]=st?"C "+y.low+" "+y.Y+" "+v.low+" "+v.Y+" "+c.low+" "+c.Y+" ":"C "+y.X+" "+y.low+" "+v.X+" "+v.low+" "+c.X+" "+c.low+" "),e.indexOf("stackingsplinearea")!=-1&&(nt[h]="C "+y.X+" "+y.Y+" "+v.X+" "+v.Y+" "+c.X+" "+c.Y+" "),(h==s.length-1||h<s.length-1&&!s[f+1].visible)&&((a!=0&&e.indexOf("stackingsplinearea")!=-1||e=="splinerangearea")&&(b={xValue:s[f].xValue,YValues:e=="splinerangearea"?s[f].YValues:[yt[f].YValues[0]]},k=ej.EjSvgRender.utils._getPoint(b,u)),st?w.append("L "+(e=="splinerangearea"?rt.low:k.X)+" "+rt.Y+" "):w.append("L "+rt.X+" "+(e=="splinerangearea"?k.low:k.Y)+" "),b=null,at=!0,pt.displayMode.toLowerCase()=="gap"&&h!=s.length-1&&a!=0&&e.indexOf("stacking")!=-1)){for(ti=ej.util.isNullOrUndefined(u._prevpointIndex)?1:u._prevpointIndex,tt=h;tt>=ti;tt--)if(s[tt-1].visible&&!ej.util.isNullOrUndefined(o.model._previousSeries))w.append(o.model._previousSeries[tt]),o.model._previousSeries[tt]="";else break;u._prevpointIndex=h+3}}else(e.indexOf("stackingsplinearea")!=-1||e.indexOf("splinerangearea")!=-1)&&h>0&&pt.displayMode=="gap"&&this.drawbackCurve(et,u,nt,h,l);d=l;ct=h}else d=null,(e.indexOf("stackingsplinearea")!=-1||e.indexOf("splinerangearea")!=-1)&&h>0&&pt.displayMode=="gap"&&this.drawbackCurve(et,u,nt,h,l);if(o.model.series[a].type.toLowerCase()=="splinerangearea")for(f=s.length-1;f>=0;f--)lt=s[f].low,ii={xValue:s[f].xValue,YValues:[lt]},ut=ej.EjSvgRender.utils._getPoint(ii,u),g[f].region.push({X:ut.X,Y:ut.Y}),f!=0&&g[f-1].region.push({X:ut.X,Y:ut.Y});p=w.toString();e.indexOf("stackingsplinearea")!=-1&&a>0&&(o.model._previousSeries=this._getReversePath(o,a,o.model._previousSeries));e=="splinerangearea"?(gt=this._getReversePath(o,a,nt),p=p+gt+"Z"):(p=ej.util.isNullOrUndefined(o.model._previousSeries)?p:p+o.model._previousSeries+"Z",o.model._previousSeries=nt);e=="splinerangearea"&&this.chartObj.model.chartRegions.push(g);this.drawAreaPath(u,ri,p,vt);this.chartObj.dragPoint?this.chartObj.svgRenderer.append(this.chartObj.gPreviewSeriesGroupEle,this.chartObj.gSeriesEle):this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle);this.chartObj.gSeriesGroupEle=this.gSeriesGroupEle},stackingSeries:!0,_getReversePath:function(n,t,i){var s=n.model.series[t].emptyPointSettings,o="",u=n.model.series[t].points,f,r,e;if(!ej.util.isNullOrUndefined(i)){for(f=0;f<u.length;f++)r=f,u[r].visible||u[r].isEmpty&&s.displayMode!="gap"||(r==0?i[r+1]&&(i[r+1]=""):r==u.length-1?i[r]&&(i[r]=""):(i[r]&&(i[r]=""),i[r+1]&&(i[r+1]="")));for(e=i.length-1;e>0;e--)o=o+i[e]}return o},drawbackCurve:function(n,t,i,r,u){var f=n[r-1],h=f.controlPoint1,c=f.controlPoint2,e=ej.EjSvgRender.utils._getPoint(t.points[r-1],t),l=ej.EjSvgRender.utils._getPoint(u,t),o=ej.EjSvgRender.utils._getPoint(h,t),s=ej.EjSvgRender.utils._getPoint(c,t);i[r]="C "+s.X+" "+s.Y+" "+o.X+" "+o.Y+" "+e.X+" "+e.Y+" "}});ej.seriesTypes.splinearea=ej.ejSplineAreaSeries;ej.seriesTypes.stackingsplinearea=ej.ejSplineAreaSeries;ej.seriesTypes.stackingsplinearea100=ej.ejSplineAreaSeries;ej.ejScatterSeries=t(ej.EjSeriesRender,{draw:function(t,i){var r,u,s;this.chartObj=t;r=i;i._animationType="scatter";var h=n.inArray(i,this.chartObj.model._visibleSeries),f=r.points.length>100||!r.enableSmartLabels?this.improveChartPerformance(r):this._isVisiblePoints(r),c=f.length,o,e;for(i._visiblePoints=f,u=0;u<c;u++)o=f[u],s=u,e=ej.EjSvgRender.utils._getPoint(o,i),this.drawSymbol(h,i,s,e.X,e.Y)}});ej.seriesTypes.scatter=ej.ejScatterSeries;ej.ejBubbleSeries=t(ej.EjSeriesRender,{createBubbleGroup:function(t){var r=n.inArray(t,this.chartObj.model.series),u=this.chartObj.model.m_AreaBounds.X,f=this.chartObj.model.m_AreaBounds.Y,i=t._isTransposed,e=i?u:t.xAxis.x,o=i?f:t.yAxis.y,s={id:this.chartObj.svgObject.id+"_SeriesGroup_"+r,transform:"translate("+e+","+o+")"};this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(s)},draw:function(t,i){var r,f,e,l,o,s,it,ot,at;this.chartObj=t;i._animationType="bubble";r=i;f=r.cornerRadius;r.points=ej.DataManager(r.points,ej.Query().sortBy("xValue")).executeLocal();var rt=n.inArray(r,this.chartObj.model._visibleSeries),g=this._isVisiblePoints(r),h=1,nt=i.bubbleOptions,vt=nt.radiusMode.toLowerCase(),v,y,ut,p,ft=t.model.m_AreaBounds,c=t.model._visibleSeries,u=0,et=Math.max(ft.Height,ft.Width),w,b,tt;if(vt=="minmax")tt=et/100,v=nt.minRadius*tt,y=nt.maxRadius*tt,b=y-v,u=Math.max.apply(0,n.map(g,function(n){return n.YValues[h]}));else for(ut=et/10,v=y=1,b=ut*y,e=0;e<c.length;e++)if(c[e].type.toLowerCase()=="bubble"&&c[e].visibility=="visible"&&c[e].bubbleOptions.radiusMode.toLowerCase()=="auto")for(p=c[e]._visiblePoints,l=0;l<p.length;l++)u=u<p[l].YValues[h]?p[l].YValues[h]:u;for(this.createBubbleGroup(r),o=0;o<g.length;o++)if(s=g[o],it=o,s.visible){u=u?u:1;w=r.bubbleOptions.radiusMode.toLowerCase()=="minmax"?v+b*Math.abs(s.YValues[h]/u):b*Math.abs(s.YValues[h]/u);var k=ej.EjSvgRender.utils._getPoint(s,r),a=this.chartObj.setStyle(this,r,rt,it),i={id:this.chartObj.svgObject.id+"_Series"+rt+"_Point"+it,cx:k.X+this.chartObj.canvasX,cy:k.Y+this.chartObj.canvasY,r:w,fill:a.interior,cornerRadius:f,"stroke-width":a.borderWidth,"stroke-dasharray":a.dashArray,opacity:a.opacity,stroke:a.borderColor};typeof f!="object"&&f>0||f.topLeft>0||f.bottomLeft>0||f.topRight>0||f.bottomRight>0?(ot=ej.EjSvgRender.utils.calculateroundedCorner(i),i.d=ot,this.chartObj.svgRenderer.drawPath(i,this.gSeriesGroupEle)):s.radius=w;this.chartObj.svgRenderer.drawCircle(i,this.gSeriesGroupEle);var yt=k.X,pt=k.Y,d=w,st,ht,ct,lt;ht=yt-d+(r.isTransposed?this.chartObj.model.m_AreaBounds.X:r.xAxis.x);ct=pt-d+(r.isTransposed?this.chartObj.model.m_AreaBounds.Y:r.yAxis.y);lt=2*d;st=2*d;at={X:ht,Y:ct,Width:st,Height:lt};ej.EjSvgRender.utils._addRegion(this.chartObj,at,r,null,o)}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)}});ej.seriesTypes.bubble=ej.ejBubbleSeries;ej.ejhiloSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var p,f,e,l,a,s,h,k;this.chartObj=t;i._animationType="hilo";p=this.chartObj.model.requireInvertedAxes;f=i;f.points=ej.DataManager(f.points,ej.Query().sortBy("xValue")).executeLocal();var w=this._isVisiblePoints(f),o=this.getSideBySideInfo(f,r),u=null,c=n.inArray(f,this.chartObj.model._visibleSeries),b=ej.EjSvgRender.utils._getTransform(f.xAxis,f.yAxis,p),d={id:this.chartObj.svgObject.id+"_SeriesGroup_"+c,transform:"translate("+b.x+","+b.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(d),e=0;e<w.length;e++)if(u=w[e],l=e,u.visible){if(a="",ej.util.isNullOrUndefined(u.YValues[0])||ej.util.isNullOrUndefined(u.YValues[1]))continue;var g=this.chartObj.setStyle(this,f,c,l),nt=this.chartObj.setHiloStyle(f,l,c),v={},y={};u.YValues[0]<u.YValues[1]?(v={xValue:u.xValue+o.Median,YValues:[u.YValues[0]]},y={xValue:u.xValue+o.Median,YValues:[u.YValues[1]]}):(v={xValue:u.xValue+o.Median,YValues:[u.YValues[1]]},y={xValue:u.xValue+o.Median,YValues:[u.YValues[0]]});s=ej.EjSvgRender.utils._getPoint(v,f);h=ej.EjSvgRender.utils._getPoint(y,f);a="M "+(s.X+this.chartObj.canvasX)+" "+(s.Y+this.chartObj.canvasY)+" L "+(h.X+this.chartObj.canvasX)+" "+(h.Y+this.chartObj.canvasY)+" ";k={point1:s,point2:h};this._drawHiloPath(f,g,nt,a,e,k)}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},hiloTypes:!0});ej.seriesTypes.hilo=ej.ejhiloSeries;ej.ejhiloopencloseSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var et,u,a,o,g,w,b,h,c,ht,ct,k,d,lt;this.chartObj=t;et=this.chartObj.model.requireInvertedAxes;i._animationType="hilo";u=i;u.points=ej.DataManager(u.points,ej.Query().sortBy("xValue")).executeLocal();var ot=this._isVisiblePoints(u),e=this.getSideBySideInfo(u,r),f=null,l=this.chartObj.model.palette,p=n.inArray(u,this.chartObj.model._visibleSeries),st=ej.EjSvgRender.utils._getTransform(u.xAxis,u.yAxis,et),at={id:this.chartObj.svgObject.id+"_SeriesGroup_"+p,transform:"translate("+st.x+","+st.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(at),o=0;o<ot.length;o++)if(g=o,f=ot[o],f.visible){var s="",vt=ej.util.isNullOrUndefined(u.drawMode)?!0:u.drawMode.toLowerCase()=="both"||u.drawMode.toLowerCase()=="open"?!0:!1,yt=ej.util.isNullOrUndefined(u.drawMode)?!0:u.drawMode.toLowerCase()=="both"||u.drawMode.toLowerCase()=="close"?!0:!1,nt={},tt={},v={},y={};if(f.YValues[0]<f.YValues[1]?(nt={xValue:f.xValue+e.Median,YValues:[f.YValues[0]]},tt={xValue:f.xValue+e.Median,YValues:[f.YValues[1]]},v={xValue:f.xValue,YValues:[f.YValues[2]]},y={xValue:f.xValue,YValues:[f.YValues[3]]}):(nt={xValue:f.xValue+e.Median,YValues:[f.YValues[1]]},tt={xValue:f.xValue+e.Median,YValues:[f.YValues[0]]},v={xValue:f.xValue,YValues:[f.YValues[2]]},y={xValue:f.xValue,YValues:[f.YValues[3]]}),u.fill=u.isFill?u.fill:null,f.YValues[2]<f.YValues[3]?u.bearFillColor=a=ej.util.isNullOrUndefined(u.bearFillColor)?u.fill?u.fill:l&&l.length>0?l[p]:"#339933":u.bearFillColor:u.bullFillColor=a=ej.util.isNullOrUndefined(u.bullFillColor)?u.fill?u.fill:l&&l.length>0?l[p]:"#E51400":u.bullFillColor,w=this.chartObj.setStyle(this,u,p,g,a),b=this.chartObj.setHiloStyle(u,g,p,a),f.fill?a=jQuery.type(f.interior)=="array"?f.fill[0]:f.fill:f._hiloFill=a,h=this.chartObj.canvasX,c=this.chartObj.canvasY,vt){var pt={xValue:v.xValue+e.Median,YValues:v.YValues},it=ej.EjSvgRender.utils._getPoint(pt,u),wt={xValue:v.xValue+e.Start,YValues:v.YValues},rt=ej.EjSvgRender.utils._getPoint(wt,u);s="M "+(it.X+h)+" "+(it.Y+c)+" L "+(rt.X+h)+" "+(rt.Y+c)+" ";ht={point1:it,point2:rt};this._drawHiloPath(u,w,b,s,o,ht);s=""}if(yt){var bt={xValue:y.xValue+e.Median,YValues:y.YValues},ut=ej.EjSvgRender.utils._getPoint(bt,u),kt={xValue:y.xValue+e.End,YValues:y.YValues},ft=ej.EjSvgRender.utils._getPoint(kt,u);s="M "+(ut.X+h)+" "+(ut.Y+c)+" L "+(ft.X+h)+" "+(ft.Y+c)+" ";ct={point1:ut,point2:ft};this._drawHiloPath(u,w,b,s,o,ct);s=""}k=ej.EjSvgRender.utils._getPoint(nt,u);d=ej.EjSvgRender.utils._getPoint(tt,u);s="M "+(k.X+h)+" "+(k.Y+c)+" L "+(d.X+h)+" "+(d.Y+c)+" ";lt={point1:k,point2:d};this._drawHiloPath(u,w,b,s,o,lt)}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},hiloTypes:!0});ej.seriesTypes.hiloopenclose=ej.ejhiloopencloseSeries;ej.ejCandleSeries=t(ej.EjSeriesRender,{draw:function(t,i,r){var ft,f,y,b,c,k,v,nt,lt,vt,ut,yt;this.chartObj=t;i._animationType="hilo";ft=this.chartObj.model.requireInvertedAxes;f=i;f.points=ej.DataManager(f.points,ej.Query().sortBy("xValue")).executeLocal();var et=this._isVisiblePoints(f),h=this.getSideBySideInfo(f,r),u=null,l=this.chartObj.model.palette,a=n.inArray(f,this.chartObj.model._visibleSeries),ot=ej.EjSvgRender.utils._getTransform(f.xAxis,f.yAxis,ft),pt={id:this.chartObj.svgObject.id+"_SeriesGroup_"+a,transform:"translate("+ot.x+","+ot.y+")"};for(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(pt),b=1,c=0;c<et.length;c++)if(u=et[c],k=c,u.visible){var st="",d={},g={},o={},s={};u.YValues[0]<u.YValues[1]?(d={xValue:u.xValue+h.Median,YValues:[u.YValues[0]]},g={xValue:u.xValue+h.Median,YValues:[u.YValues[1]]},o={xValue:u.xValue,YValues:[u.YValues[2]]},s={xValue:u.xValue,YValues:[u.YValues[3]]}):(d={xValue:u.xValue+h.Median,YValues:[u.YValues[1]]},g={xValue:u.xValue+h.Median,YValues:[u.YValues[0]]},o={xValue:u.xValue,YValues:[u.YValues[2]]},s={xValue:u.xValue,YValues:[u.YValues[3]]});u.YValues[2]<u.YValues[3]?(o={xValue:u.xValue,YValues:[u.YValues[2]]},s={xValue:u.xValue,YValues:[u.YValues[3]]},f.bearFillColor=y=ej.util.isNullOrUndefined(f.bearFillColor)?l&&l.length>0?l[a]:"#339933":f.bearFillColor):(o={xValue:u.xValue,YValues:[u.YValues[3]]},s={xValue:u.xValue,YValues:[u.YValues[2]]},f.bullFillColor=y=ej.util.isNullOrUndefined(f.bullFillColor)?l&&l.length>0?l[a]:"#E51400":f.bullFillColor);v=this.chartObj.setStyle(this,f,a,k,y);nt=this.chartObj.setHiloStyle(f,k,a,y);u.style&&u.style.interior?y=jQuery.type(u.style.interior)=="array"?u.style.interior[0]:u.style.interior:u._hiloFill=nt;var tt=ej.EjSvgRender.utils._getPoint(d,f),it=ej.EjSvgRender.utils._getPoint({xValue:o.xValue+h.Median,YValues:[o.YValues[0]]},f),ht=ej.EjSvgRender.utils._getPoint({xValue:s.xValue+h.Median,YValues:[s.YValues[0]]},f),ct=ej.EjSvgRender.utils._getPoint(g,f),p=this.chartObj.canvasX,w=this.chartObj.canvasY;st="M "+(tt.X+p)+" "+(tt.Y+w)+" L "+(it.X+p)+" "+(it.Y+w)+" M "+(ht.X+p)+" "+(ht.Y+w)+" L "+(ct.X+p)+" "+(ct.Y+w)+" ";lt={point1:tt,point2:it};this._drawHiloPath(f,v,nt,st,c,lt);var wt={xValue:s.xValue+h.Start,YValues:s.YValues},rt=ej.EjSvgRender.utils._getPoint(wt,f),bt={xValue:o.xValue+h.End,YValues:o.YValues},at=ej.EjSvgRender.utils._getPoint(bt,f),e=ej.EjSvgRender.utils._correctRect(rt.X,rt.Y,at.X,at.Y);o.YValues[0]==s.YValues[0]&&(e.Y=rt.Y-b/2,e.Height=b);vt={id:this.chartObj.svgObject.id+"_Series"+a+"_Point"+c,x:e.X+this.chartObj.canvasX,y:e.Y+this.chartObj.canvasY,width:e.Width,height:e.Height,fill:v.interior,"stroke-width":v.borderWidth,"stroke-dasharray":v.dashArray,stroke:v.borderColor};this.chartObj.svgRenderer.drawRect(vt,this.gSeriesGroupEle);ut=ej.EjSvgRender.utils._getSvgXY(e.X,e.Y,f,this.chartObj);yt={X:ut.X,Y:ut.Y,Width:e.Width,Height:e.Height};ej.EjSvgRender.utils._addRegion(this.chartObj,yt,f,u,c)}this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},hiloTypes:!0});ej.seriesTypes.candle=ej.ejCandleSeries;ej.ejPieOfPieSeries=t(ej.EjSeriesRender,{draw:function(n,t){this.chartObj=n;var i=new ej.seriesTypes.pie;i.draw(n,t)},chartAreaType:"None"});ej.seriesTypes.pieofpie=ej.ejPieOfPieSeries;ej.ejPieSeries=t(ej.EjSeriesRender,{draw:function(t,i){var l,b,nt,tt,v,it,rt,ut,ft,h,f,c,ot,p,st,u,ht,ct,w;this.chartObj=t;var r=i,k=[],d=i.type.toLowerCase(),o=i.collectionIndex,lt=o==0?r.pieCoefficient:r.pieOfPieCoefficient,at=this.chartObj.model.enableCanvasRendering,g=this._calculateVisiblePoints(i,this.chartObj).visiblePoints,a=this.calculatingSliceAngle(r),u=n.inArray(r,this.chartObj.model._visibleSeries),vt=this.chartObj.model._visibleSeries.length,s=this.chartObj.model._visibleSeries[u];if(s._pieCoefficient=s.pieCoefficient,this.chartObj.model.circularRadius.length>1){for(l=u;ej.util.isNullOrUndefined(s.zOrder)?l<this.chartObj.model.circularRadius.length:l>=0;ej.util.isNullOrUndefined(s.zOrder)?l++:l--)if(!ej.util.isNullOrUndefined(this.chartObj.model.circularRadius[l])){this.chartObj.model.circularRadius[u]=this.chartObj.model.circularRadius[l]*s._pieCoefficient;break}}else d=="pieofpie"&&s.splitMode!=""?this.chartObj.model.circularRadius[o]=.25*lt*Math.min(a.width,a.height):this.chartObj.model.circularRadius[u]=.5*s._pieCoefficient*Math.min(a.width,a.height);if(b=Math.min(a.width,a.height),b<0)return b;for(nt=Math.abs(r.endAngle-r.startAngle),nt<270&&this.pieDoughnutCenter(r),tt={id:this.chartObj.svgObject.id+"_SeriesGroup_"+u},this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(tt),v=r.enableAnimation&&!r._animatedSeries?"hidden":"visible",it={id:this.chartObj.svgObject.id+"_TextGroup_"+u,visibility:v},this.chartObj.gSeriesTextEle||(this.chartObj.gSeriesTextEle=[]),this.chartObj.gSeriesTextEle[u]=o==1?this.chartObj.gSeriesTextEle[0]:this.chartObj.svgRenderer.createGroup(it),rt={id:this.chartObj.svgObject.id+"_symbolGroup_"+u,visibility:v},this.chartObj.gSymbolGroupEle||(this.chartObj.gSymbolGroupEle=[]),this.chartObj.gSymbolGroupEle[u]=this.chartObj.svgRenderer.createGroup(rt),ut={id:this.chartObj.svgObject.id+"_connectorGroup_"+u,visibility:v},this.chartObj.gConnectorEle||(this.chartObj.gConnectorEle=[]),this.chartObj.gConnectorEle[u]=this.chartObj.svgRenderer.createGroup(ut),ft={id:this.chartObj.svgObject.id+"_DataLabel_"+u,visibility:v},this.chartObj.gDataLabelEle||(this.chartObj.gDataLabelEle=[]),this.chartObj.gDataLabelEle[u]=o==1?this.chartObj.gDataLabelEle[0]:this.chartObj.svgRenderer.createGroup(ft),h=0;h<g.length;h++)if((f=this.chartObj.model._isPieOfPie?g[h].actualIndex:h,!isNaN(r._visiblePoints[h].startAngle))&&(c=r._visiblePoints[h],c.visible)){var y=this._calculateArcData(this.chartObj,f,c,r,u,o),et=y.Direction.split(" "),e=this.chartObj.setStyle(this,r,u,h);if(ot=r.startAngle<r.endAngle?!1:!0,!this.chartObj.model._isPieOfPie)for(p=0;p<r.visiblePoints.length;p++)if(c==r.visiblePoints[p]){f=p;break}i={id:this.chartObj.svgObject.id+"_Series"+u+"_Point"+f,fill:e.interior,"stroke-width":e.borderWidth,stroke:e.borderColor,"stroke-dasharray":e.dashArray,"stroke-linecap":r.lineCap,"stroke-linejoin":r.lineJoin,d:y.Direction,opacity:e.opacity,"data-pointIndex":f};st={id:this.chartObj.svgObject.id+"_Series"+u+"_Point"+f,fill:e.interior,"stroke-width":e.borderWidth,stroke:e.borderColor,"stroke-dasharray":e.dashArray,"stroke-linecap":r.lineCap,"stroke-linejoin":r.lineJoin,d:y.Direction,opacity:e.opacity,radius:d=="pieofpie"?this.chartObj.model.circularRadius[o]:this.chartObj.model.circularRadius[u],start:c.startAngle-1.57,end:c.endAngle-1.57,"data-pointIndex":f,counterClockWise:ot,innerR:0,cx:y.centerX,cy:y.centerY,x:et[12],y:et[13]};at?this.chartObj.svgRenderer.drawPath(st,this.gSeriesGroupEle):this.chartObj.svgRenderer.drawPath(i,this.gSeriesGroupEle);w={PointIndex:f,Index:h,StartAngle:c.startAngle,EndAngle:c.endAngle,StartX:this.chartObj.model.startX[f],StartY:this.chartObj.model.startY[f],PieSeriesIndex:o,SeriesIndex:n.inArray(r,this.chartObj.model._visibleSeries)};k.push(w)}u=this.chartObj.model._isPieOfPie?o:u;this.chartObj.model._isPieOfPie&&o==1&&s.pieCollections[0].length>0&&s.pieCollections[1].length==0&&(ht=this._drawEmptyPieOfPie(this.chartObj),this.chartObj.svgRenderer.drawPath(ht,this.gSeriesGroupEle));ct={Radius:this.chartObj.model.circularRadius[u],CenterX:this.chartObj.model.circleCenterX[u],CenterY:this.chartObj.model.circleCenterY[u]};w={Series:r,SeriesData:ct,Region:k,SeriesIndex:n.inArray(r,this.chartObj.model._visibleSeries)};this.chartObj.model.chartRegions.push(w);this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},chartAreaType:"None"});ej.seriesTypes.pie=ej.ejPieSeries;ej.ejDoughnutSeries=t(ej.EjSeriesRender,{draw:function(t,i){var h,p,d,l,g,nt,tt,it,c,e,o,s,et,a,ot,st,y;this.chartObj=t;var u=i,k=[],ht=this._calculateVisiblePoints(i).visiblePoints,v=this.calculatingSliceAngle(u),ct=this.chartObj.model.enableCanvasRendering,lt=ht.length,r=n.inArray(u,this.chartObj.model._visibleSeries),pt=this.chartObj.model._visibleSeries.length,pt=this.chartObj.model._visibleSeries.length,f=this.chartObj.model._visibleSeries[r];if(f._doughnutSize=f.doughnutSize,f._doughnutCoefficient=f.doughnutCoefficient,this.chartObj.model.circularRadius.length>1){for(h=r;ej.util.isNullOrUndefined(f.zOrder)?h<this.chartObj.model.circularRadius.length:h>=0;ej.util.isNullOrUndefined(f.zOrder)?h++:h--)if(!ej.util.isNullOrUndefined(this.chartObj.model.circularRadius[h])){this.chartObj.model.circularRadius[r]=this.chartObj.model.circularRadius[h]*f._doughnutSize;break}}else this.chartObj.model.circularRadius[r]=.5*f._doughnutSize*Math.min(v.width,v.height);if(p=Math.min(v.width,v.height),p<0)return p;d=Math.abs(u.endAngle-u.startAngle);d<270&&this.pieDoughnutCenter(u);this.chartObj.model.innerRadius[r]=f._doughnutCoefficient*this.chartObj.model.circularRadius[r];var wt=ej.util.isNullOrUndefined(this.chartObj.model.roundingPlaces)?2:this.chartObj.model.roundingPlaces,r=n.inArray(u,this.chartObj.model._visibleSeries),at={id:this.chartObj.svgObject.id+"_SeriesGroup_"+r};if(this.gSeriesGroupEle=this.chartObj.svgRenderer.createGroup(at),l=u.enableAnimation&&!u._animatedSeries?"hidden":"visible",g={id:this.chartObj.svgObject.id+"_TextGroup_"+r,visibility:l},this.chartObj.gSeriesTextEle||(this.chartObj.gSeriesTextEle=[]),this.chartObj.gSeriesTextEle[r]=this.chartObj.svgRenderer.createGroup(g),nt={id:this.chartObj.svgObject.id+"_symbolGroup_"+r,visibility:l},this.chartObj.gSymbolGroupEle||(this.chartObj.gSymbolGroupEle=[]),this.chartObj.gSymbolGroupEle[r]=this.chartObj.svgRenderer.createGroup(nt),tt={id:this.chartObj.svgObject.id+"_connectorGroup_"+r,visibility:l},this.chartObj.gConnectorEle||(this.chartObj.gConnectorEle=[]),this.chartObj.gConnectorEle[r]=this.chartObj.svgRenderer.createGroup(tt),it={id:this.chartObj.svgObject.id+"_DataLabel_"+r,visibility:l},this.chartObj.gDataLabelEle||(this.chartObj.gDataLabelEle=[]),this.chartObj.gDataLabelEle[r]=this.chartObj.svgRenderer.createGroup(it),u._doughnutSize>0&&f._doughnutCoefficient>=0&&u._doughnutSize<=1&&f._doughnutCoefficient<=1)for(c=0;c<lt;c++)if(e=u._visiblePoints[c],o=c,e.visible){var w=0,b=0,rt=this._calculateArcData(this.chartObj,o,e,u,r);if((e.actualIndex==u.explodeIndex||u.explodeAll)&&!this.chartObj.vmlRendering){var ut=-.5*Math.PI,vt=e.startAngle+ut,yt=e.endAngle+ut-1e-6,ft=(vt+yt)/2;w=this.chartObj.model.circleCenterX[r]+Math.cos(ft)*u.explodeOffset;b=this.chartObj.model.circleCenterY[r]+Math.sin(ft)*u.explodeOffset}for(s=this.chartObj.setStyle(this,u,r,o),et=u.startAngle<u.endAngle?!1:!0,a=0;a<u.visiblePoints.length;a++)if(e==u.visiblePoints[a]){o=a;break}i={id:this.chartObj.svgObject.id+"_Series"+r+"_Point"+o,fill:s.interior,"stroke-width":s.borderWidth,stroke:s.borderColor,"stroke-dasharray":s.dashArray,"stroke-linecap":u.lineCap,opacity:s.opacity,"stroke-linejoin":u.lineJoin,d:rt.Direction,"data-pointIndex":o};ot={id:this.chartObj.svgObject.id+"_Series"+r+"_Point"+o,fill:s.interior,"stroke-width":s.borderWidth,stroke:s.borderColor,"stroke-dasharray":s.dashArray,"stroke-linecap":u.lineCap,opacity:s.opacity,"stroke-linejoin":u.lineJoin,d:rt.Direction,start:e.startAngle-1.57,end:e.endAngle-1.57,"data-pointIndex":o,radius:this.chartObj.model.circularRadius[r],innerR:this.chartObj.model.innerRadius[r],counterClockWise:et,x:w!=0?w:this.chartObj.model.circleCenterX[r],y:b!=0?b:this.chartObj.model.circleCenterY[r]};ct?this.chartObj.svgRenderer.drawPath(ot,this.gSeriesGroupEle):this.chartObj.svgRenderer.drawPath(i,this.gSeriesGroupEle);y={PointIndex:o,Index:c,StartAngle:e.startAngle,EndAngle:e.endAngle,StartX:this.chartObj.model.startX[o],StartY:this.chartObj.model.startY[o],SeriesIndex:n.inArray(u,this.chartObj.model._visibleSeries)};k.push(y)}st={Radius:this.chartObj.model.circularRadius[r],DRadius:this.chartObj.model.innerRadius[r],CenterX:this.chartObj.model.circleCenterX[r],CenterY:this.chartObj.model.circleCenterY[r]};y={Series:u,SeriesData:st,Region:k,SeriesIndex:n.inArray(u,this.chartObj.model._visibleSeries)};this.chartObj.model.chartRegions.push(y);this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},chartAreaType:"None"});ej.seriesTypes.doughnut=ej.ejDoughnutSeries;ej.ejPyramidSeries=t(ej.EjSeriesRender,{draw:function(t,i){var a,ot,e,s,wt,ii,bt,kt,dt,gt,h,f,p,it;this.chartObj=t;var r=t.model,o,st=this,d=r.LegendActualBounds,u=i,w=this._calculateVisiblePoints(u).visiblePoints,rt=w.length,ht=[],ut=[],ct=r.legend,g=u.marker.dataLabel,l=ct.position.toLowerCase(),nt=ct.border.width,tt=0,c=r.title,b=r.title.subTitle,lt=r.border.width,at=c.text!=""&&c.visible&&c.enableTrim?!0:!1,vt=b.text!=""&&b.visible&&b.enableTrim?!0:!1,ft=r.title.text&&r.title.visible?ej.EjSvgRender.utils._measureText(r.title.text,n(this.svgObject).width()-r.margin.left-r.margin.right,r.title.font):0,et=r.title.subTitle.text&&r.title.subTitle.visible?ej.EjSvgRender.utils._measureText(r.title.subTitle.text,n(this.svgObject).width()-r.margin.left-r.margin.right,r.title.subTitle.font):0,yt=t.model.title.text==""||!t.model.title.visible?0:at&&c.textOverflow=="wrap"?ft.height*t.model.titleWrapTextCollection.length:at&&c.textOverflow=="wrapandtrim"?ft.height*t.model.titleWrapTextCollection.length:ft.height,pt=t.model.title.subTitle.text==""||!t.model.title.subTitle.visible?0:vt&&b.textOverflow=="wrap"?et.height*t.model.subTitleWrapTextCollection.length:vt&&b.textOverflow=="wrapandtrim"?et.height*t.model.subTitleWrapTextCollection.length:et.height,k=r.margin.left+r.elementSpacing+lt*2+r.elementSpacing+r.margin.right+(l==="right"||l==="left"?d.Width+2*nt:0),ni=(r.title.text&&r.title.visible?r._titleLocation.Y+yt+pt:r.elementSpacing)+lt*2+r.margin.top+r.elementSpacing+r.elementSpacing+(l==="top"||l==="bottom"?d.Height+2*nt+r.elementSpacing:0);if(g.visible&&g.shape!="none"&&u.labelPosition=="outside"&&(k=k+(g.margin.left+g.margin.right)),r.chartRegions=[],r.sumofYValues=0,u.labelPosition.toLowerCase()==="outside"){for(a=0;a<rt;a++)ot=ej.EjSvgRender.utils._measureText(ej.util.isNullOrUndefined(w[a].text)?w[a].y:w[a].text,null,u.marker.dataLabel.font).width,tt<ot&&(tt=ot);r.textSize=tt}u._enableSmartLabels?(r.actualWidth=(n(t.svgObject).width()-k)*.8,r.resWidth=(n(t.svgObject).width()-k-r.actualWidth)/2):(r.actualWidth=n(t.svgObject).width()-k-tt,r.resWidth=0);e=n.inArray(u,r._visibleSeries);r.actualHeight=n(t.svgObject).height()-ni;var ti=t.model.title.subTitle.text==""?0:pt,v=t.pyrX=(l==="left"?d.Width+2*nt:0)+r.elementSpacing+r.margin.left,y=t.pyrY=(l==="top"?d.Height+2*nt:0)+(c.text&&c.visible?r._titleLocation.Y+yt+ti:r.margin.top+r.elementSpacing);for(ut[0]=v,ut[1]=y,s=0;s<rt;s++)r.sumofYValues+=w[s].YValues[0];for(wt={id:t.svgObject.id+"_DataLabel_"+e,transform:"translate("+v+","+y+")"},t.gDataLabelEle=[],t.gDataLabelEle[e]=t.svgRenderer.createGroup(wt),ii=ej.util.isNullOrUndefined(r.roundingPlaces)?2:r.roundingPlaces,bt={id:t.svgObject.id+"_SeriesGroup_"+e,transform:"translate("+v+","+y+")"},this.gSeriesGroupEle=t.svgRenderer.createGroup(bt),kt={id:t.svgObject.id+"_textGroup_"+e,transform:"translate("+v+","+y+")"},t.gSeriesTextEle=[],t.gSeriesTextEle[e]=t.svgRenderer.createGroup(kt),dt={id:t.svgObject.id+"_symbolGroup_"+e,transform:"translate("+v+","+y+")"},t.gSymbolGroupEle=[],t.gSymbolGroupEle[e]=t.svgRenderer.createGroup(dt),gt={id:t.svgObject.id+"_connectorGroup_"+e,transform:"translate("+v+","+y+")"},t.gConnectorEle=[],t.gConnectorEle[e]=t.svgRenderer.createGroup(gt),u.pyramidMode.toLowerCase()=="linear"?this.calculateLinearSegments(u):this.calculateSurfaceSegments(u),s=0;s<rt;s++)h=s,o=u._visiblePoints[s],o.visible&&(f=this._getPyramidData(u,h),p=t.setStyle(this,u,0,h),i={id:t.svgObject.id+"_Series"+e+"_Point"+h,fill:p.interior,"stroke-width":p.borderWidth,stroke:p.borderColor,"stroke-dasharray":p.dashArray,"stroke-linecap":u.lineCap,"stroke-linejoin":u.lineJoin,opacity:p.opacity,pointIndex:h,d:f.Direction},t.svgRenderer.drawPath(i,this.gSeriesGroupEle,ut),u.marker.dataLabel.template&&ej.EjSvgRender.utils._getSeriesTemplateSize(o,h,u,!0,t),o.xLocation=f.PositionX,o.yLocation=f.PositionY,o.connectorLine=f.Connector,o.startX=f.startX,o.startY=f.startY,o.Polygon=f.Polygon,it={PointIndex:h,Line1:f.Line1,Line2:f.Line2,Line3:f.Line3,Line4:f.Line4,Polygon:f.Polygon},ht.push(it));it={Series:u,Region:ht,SeriesIndex:n.inArray(u,r._visibleSeries)};r.chartRegions.push(it);this.gSeriesGroupEle&&(n(this.gSeriesGroupEle.childNodes[h]).bind("mousemove",function(n){n.target=st.gSeriesGroupEle.childNodes[h];st.chartObj.chartInteractiveBehavior(n)}),t.svgRenderer.append(this.gSeriesGroupEle,t.gSeriesEle))},_getPyramidData:function(t,i){var r=this.chartObj.model,h=t._visiblePoints[i].marker,it=t._visiblePoints[i].actualIndex,a=t.explodeIndex==it||t.explodeAll?t.explodeOffset:0,c=r.resWidth,w=r.pyramidData[i].CurrY,v=r.pyramidData[i].CurrY+r.pyramidData[i].Height,b=.5*(1-r.pyramidData[i].CurrY),k=.5*(1-v),et=t.points[i],o={x:c+a+b*r.actualWidth,y:w*r.actualHeight},u={x:c+a+(1-b)*r.actualWidth,y:w*r.actualHeight},f={x:c+a+(1-k)*r.actualWidth,y:v*r.actualHeight},l={x:c+a+k*r.actualWidth,y:v*r.actualHeight},rt="M "+o.x+" "+o.y+" L "+u.x+" "+u.y+" L "+f.x+" "+f.y+" L "+l.x+" "+l.y+" z",ut=[{x:o.x,y:o.y},{x:u.x,y:u.y},{x:f.x,y:f.y},{x:l.x,y:l.y}],e,s,d,g,y,p;if(h&&h.dataLabel&&h.dataLabel.visible||(!h||!h.dataLabel)&&t.marker.dataLabel.visible)if(d=(u.x+f.x)/2,g=(u.y+f.y)/2,t.labelPosition.toLowerCase()==="outside"){e=(u.x+f.x)/2;s=(u.y+f.y)/2;y=(this.chartObj.model.legend.position.toLowerCase()=="left"||this.chartObj.model.legend.position.toLowerCase()=="right"?this.chartObj.model.LegendActualBounds.Width:0)+this.chartObj.model.elementSpacing+this.chartObj.model.margin.left;p=ej.util.isNullOrUndefined(t.marker.dataLabel.connectorLine.height)?t._enableSmartLabels?n(this.chartObj.svgObject).width()-(y+e+c+2*this.chartObj.model.elementSpacing):n(this.chartObj.svgObject).width()-(y+e+this.chartObj.model.textSize+this.chartObj.model.elementSpacing):t.marker.dataLabel.connectorLine.height;var nt=this.getXCordinate(e,p,0),tt=this.getYCordinate(s,p,0),ft="M "+e+" "+s+" L "+nt+" "+tt;e=nt;s=tt}else e=(o.x+u.x)/2,s=(f.y+o.y)/2;return{Direction:rt,PositionX:e,PositionY:s,Connector:ft,Line1:o,Line2:u,Line3:f,Line4:l,startX:d,startY:g,Polygon:ut}},calculateLinearSegments:function(n){var f=0,i=this.chartObj.model,t,u;i.pyramidData=[];var r=n.gapRatio>=0?n.gapRatio<=1?n.gapRatio:1:0,o=1/(i.sumofYValues*(1+r/(1-r))),e=n._visiblePoints.length;for(t=0;t<e;t++)(n._visiblePoints[t].visible||n._visiblePoints[t].gapMode)&&(u=o*n._visiblePoints[t].YValues[0],i.pyramidData[t]={CurrY:f,Height:u},f+=r/(e-1)+u)},calculateSurfaceSegments:function(n){var r=n._visiblePoints.length,u=this.chartObj.model,e,t,c;u.pyramidData=[];var i=0,o=[],f=[],l=n.gapRatio>=0?n.gapRatio<=1?n.gapRatio:1:0,s=l/(r-1),h=this.getSurfaceHeight(0,u.sumofYValues);for(t=0;t<r;t++)(n._visiblePoints[t].visible||n._visiblePoints[t].gapMode)&&(o[t]=i,f[t]=this.getSurfaceHeight(i,Math.abs(n._visiblePoints[t].YValues[0])),i+=f[t]+s*h);for(e=1/(i-s*h),t=0;t<r;t++)(n._visiblePoints[t].visible||n._visiblePoints[t].gapMode)&&(c=e*o[t],u.pyramidData[t]={CurrY:c,Height:e*f[t]})},getSurfaceHeight:function(n,t){var i=this.solveQuadraticEquation(1,2*n,-t);return i?i:0},solveQuadraticEquation:function(n,t,i){var r,u,f,e;if(n!=0){if(f=t*t-4*n*i,f>=0)return e=Math.sqrt(f),r=(-t-e)/(2*n),u=(-t+e)/(2*n),Math.max(r,u)}else if(t!=0)return r=-i/t,u=-i/t,Math.max(r,u);return!1},chartAreaType:"None"});ej.seriesTypes.pyramid=ej.ejPyramidSeries;ej.ejFunnelSeries=t(ej.EjSeriesRender,{draw:function(t,i){var st,gt,l,a,h,ni,ti,ii,ri,ht,rt,e,lt,c,f,y,ut;this.chartObj=t;var r=t.model,at=r.legend,v=at.position.toLowerCase(),g=r.LegendActualBounds,s,vt=this,u=i,p=this._calculateVisiblePoints(u).visiblePoints,w=p.length,yt=[],nt=u.marker,tt=at.border.width,ft=[],it=0,b=t.model.title.text==""?"":r.title,k=t.model.title.subTitle.text==""?"":r.title.subTitle,pt=r.border.width,wt=b.text!=""&&b.visible&&b.enableTrim?!0:!1,bt=k.text!=""&&k.visible&&k.enableTrim?!0:!1,et=r.title.text&&r.title.visible?ej.EjSvgRender.utils._measureText(r.title.text,n(this.svgObject).width()-r.margin.left-r.margin.right,r.title.font):0,ot=r.title.subTitle.text&&r.title.subTitle.visible?ej.EjSvgRender.utils._measureText(r.title.subTitle.text,n(this.svgObject).width()-r.margin.left-r.margin.right,r.title.subTitle.font):0,kt=t.model.title.text==""||!t.model.title.visible?0:wt&&b.textOverflow=="wrap"?et.height*t.model.titleWrapTextCollection.length:wt&&b.textOverflow=="wrapandtrim"?et.height*t.model.titleWrapTextCollection.length:et.height,dt=t.model.title.subTitle.text==""||!t.model.title.subTitle.visible?0:bt&&k.textOverflow=="wrap"?ot.height*t.model.subTitleWrapTextCollection.length:bt&&k.textOverflow=="wrapandtrim"?ot.height*t.model.subTitleWrapTextCollection.length:ot.height,d=r.margin.left+r.elementSpacing+r.elementSpacing+r.margin.right+pt*2+(v==="right"||v==="left"?g.Width+2*tt:0),ui=(r.title.text&&r.title.visible?r._titleLocation.Y+kt+dt:r.elementSpacing)+r.margin.top+pt*2+r.elementSpacing+r.elementSpacing+(v==="top"||v==="bottom"?g.Height+2*tt+r.elementSpacing:0);if(nt.visible&&nt.shape!="none"&&u.labelPosition=="outside"&&(d=d+(nt.margin.left+nt.margin.right)),r.chartRegions=[],r.sumofYValues=0,u.labelPosition.toLowerCase()==="outside"){for(e=0;e<w;e++)st=ej.EjSvgRender.utils._measureText(ej.util.isNullOrUndefined(p[e].text)?p[e].y:p[e].text,null,u.marker.dataLabel.font).width,it<st&&(it=st);r.textSize=it}for(u._enableSmartLabels?(r.actualWidth=(n(t.svgObject).width()-d)*.8,r.resWidth=(n(t.svgObject).width()-d-r.actualWidth)/2):(r.actualWidth=n(t.svgObject).width()-d-it,r.resWidth=0),gt=t.model.title.subTitle.text==""?0:dt,r.actualHeight=n(t.svgObject).height()-ui,l=t.pyrX=(v==="left"?g.Width+2*tt:0)+r.elementSpacing+r.margin.left,a=t.pyrY=(v==="top"?g.Height+2*tt:0)+(r.title.text&&r.title.visible?r._titleLocation.Y+kt+gt:r.margin.top+r.elementSpacing),ft[0]=l,ft[1]=a,h=0;h<w;h++)r.sumofYValues+=p[h].YValues[0];var si=ej.util.isNullOrUndefined(r.roundingPlaces)?2:r.roundingPlaces,o=n.inArray(u,r._visibleSeries),fi={id:t.svgObject.id+"_SeriesGroup_"+o,transform:"translate("+l+","+a+")"};this.gSeriesGroupEle=t.svgRenderer.createGroup(fi);ni={id:t.svgObject.id+"_DataLabel_"+o,transform:"translate("+l+","+a+")"};t.gDataLabelEle=[];t.gDataLabelEle[o]=t.svgRenderer.createGroup(ni);ti={id:t.svgObject.id+"_textGroup_"+o,transform:"translate("+l+","+a+")"};t.gSeriesTextEle=[];t.gSeriesTextEle[o]=t.svgRenderer.createGroup(ti);ii={id:t.svgObject.id+"_symbolGroup_"+o,transform:"translate("+l+","+a+")"};t.gSymbolGroupEle=[];t.gSymbolGroupEle[o]=t.svgRenderer.createGroup(ii);ri={id:t.svgObject.id+"_connectorGroup_"+o,transform:"translate("+l+","+a+")"};t.gConnectorEle=[];t.gConnectorEle[o]=t.svgRenderer.createGroup(ri);ht=0;rt=r;rt.funnelData=[];var ct=u.gapRatio>=0?u.gapRatio<=1?u.gapRatio:1:0,ei=1/(rt.sumofYValues*(1+ct/(1-ct))),oi=ct/w;for(e=w-1;e>=0;e--)(u._visiblePoints[e].visible||u._visiblePoints[e].gapMode)&&(lt=ei*u._visiblePoints[e].YValues[0],rt.funnelData[e]={CurrY:ht,Height:lt},ht+=lt+oi);for(h=0;h<w;h++)c=h,s=u._visiblePoints[h],s.visible&&(f=this._getFunnelData(u,c,t),y=t.setStyle(this,u,0,c),i={id:t.svgObject.id+"_Series"+o+"_Point"+c,fill:y.interior,"stroke-width":y.borderWidth,stroke:y.borderColor,"stroke-dasharray":y.dashArray,"stroke-linecap":u.lineCap,"stroke-linejoin":u.lineJoin,opacity:y.opacity,pointIndex:c,d:f.Direction},t.svgRenderer.drawPath(i,this.gSeriesGroupEle,ft),u.marker.dataLabel.template&&ej.EjSvgRender.utils._getSeriesTemplateSize(s,c,u,!0,t),s.xLocation=f.PositionX,s.yLocation=f.PositionY,s.connectorLine=f.Connector,s.startX=f.startX,s.startY=f.startY,s.Polygon=f.Polygon,ut={PointIndex:c,Line1:f.Line1,Line2:f.Line2,Line3:f.Line3,Line4:f.Line4,Line5:f.Line5,Line6:f.Line6,Polygon:f.Polygon},yt.push(ut));ut={Series:u,Region:yt,SeriesIndex:n.inArray(u,r._visibleSeries)};r.chartRegions.push(ut);this.gSeriesGroupEle&&n(this.gSeriesGroupEle.childNodes[c]).bind("mousemove",function(n){n.target=vt.gSeriesGroupEle.childNodes[c];vt.chartObj.chartInteractiveBehavior(n)});t.svgRenderer.append(this.gSeriesGroupEle,t.gSeriesEle)},_getFunnelData:function(t,i){var e=this.chartObj.model,pt=t._visiblePoints[i],tt=pt.marker,et=t.marker,ot=t.funnelWidth,st=t.funnelHeight,r=e.actualHeight,c=e.actualWidth,ht=e.elementSpacing,wt,bt=e.legend.position.toLowerCase(),ii=pt.actualIndex,kt,s=e.resWidth,dt,ct,gt,l=t.explodeIndex==ii||t.explodeAll?t.explodeOffset:0,rt,ut,d,lt,at,it,g,ft,a,vt,yt,h,w,ni,ti,v,u,f,b,nt,k,y,o,p;return o=st.indexOf("%")!=-1?r*(parseInt(st)/100):parseInt(st),p=ot.indexOf("%")!=-1?c*(parseInt(ot)/100):parseInt(ot),g=e.funnelData[i].CurrY*r,a=g+e.funnelData[i].Height*r,y=p+(c-p)*((r-o-g)/(r-o)),rt=c/2-y/2,lt=rt+y,y=a>r-o||r==o?p:p+(c-p)*((r-o-a)/(r-o)),d=c/2-y/2,it=d+y,g>=r-o?(rt=d=ut=c/2-p/2,lt=it=at=c/2+p/2):a>r-o&&(ut=d=c/2-y/2,at=it=ut+y,ft=r-o),v={x:s+l+rt,y:g},u={x:s+l+lt,y:g},b={x:s+l+it,y:a},nt={x:s+l+d,y:a},f={x:s+l+it,y:a},k={x:s+l+d,y:a},ft&&(f={x:s+l+at,y:ft},k={x:s+l+ut,y:ft}),kt="M "+v.x+" "+v.y+" L "+u.x+" "+u.y+" L "+f.x+" "+f.y+" L "+b.x+" "+b.y+" L "+nt.x+" "+nt.y+" L "+k.x+" "+k.y+" z",dt=[{x:v.x,y:v.y},{x:u.x,y:u.y},{x:f.x,y:f.y},{x:b.x,y:b.y},{x:nt.x,y:nt.y},{x:k.x,y:k.y}],(tt&&tt.dataLabel&&tt.dataLabel.visible||(!tt||!tt.dataLabel)&&et.dataLabel.visible)&&(h,w,ni=(u.x+f.x)/2,ti=(u.y+f.y)/2,t.labelPosition.toLowerCase()==="outside"?(h=(u.x+f.x)/2,w=(u.y+f.y)/2,wt=(bt=="left"||bt=="right"?e.LegendActualBounds.Width:0)+ht+e.margin.left,ct=ej.util.isNullOrUndefined(et.dataLabel.connectorLine.height)?t._enableSmartLabels?n(this.chartObj.svgObject).width()-(wt+h+s+2*ht):n(this.chartObj.svgObject).width()-(h+e.textSize+ht):et.dataLabel.connectorLine.height,vt=this.getXCordinate(h,ct,0),yt=this.getYCordinate(w,ct,0),gt="M "+h+" "+w+" L "+vt+" "+yt,h=vt,w=yt):(h=(v.x+u.x)/2,w=(v.y+b.y)/2)),{Direction:kt,PositionX:h,PositionY:w,Connector:gt,Line1:v,Line2:u,Line3:f,Line4:b,Line5:nt,Line6:k,startX:ni,startY:ti,Polygon:dt}},chartAreaType:"None"});ej.seriesTypes.funnel=ej.ejFunnelSeries;ej.ejPolarSeries=t(ej.EjSeriesRender,{draw:function(n,t){var r,o,s,e,u;this.chartObj=n;var h=this,i=t,c=this._isVisiblePoints(i),f=this.setLineSeriesStyle(i);if(i.drawType.toLowerCase()=="column"||i.drawType.toLowerCase()=="rangecolumn"){r=i.xAxis.visibleRange;r.interval=1;o=i.xAxis._valueType=="category"?r.max:r.max-1;this.chartObj.model.sumofYValues=0;s=r.interval;e=r.min;do this.chartObj.model.sumofYValues+=r.interval,e+=r.interval;while(e<=o)}u=this._calculatePolarAxesSegment(i);i.drawType.toLowerCase()=="area"?this.drawAreaPath(i,f,u):i.drawType.toLowerCase()=="line"?this._drawLinePath(i,f,u):i.drawType.toLowerCase()=="spline"&&this._drawLinePath(i,f,u);this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},chartAreaType:"PolarAxes"});ej.seriesTypes.polar=ej.ejPolarSeries;ej.ejRadarSeries=t(ej.EjSeriesRender,{draw:function(n,t){var r,o,s,e,u;this.chartObj=n;var h=this,i=t,c=this._isVisiblePoints(i),f=this.setLineSeriesStyle(i);if(i.drawType.toLowerCase()=="column"||i.drawType.toLowerCase()=="rangecolumn"){r=i.xAxis.visibleRange;r.interval=1;o=i.xAxis._valueType=="category"?r.max:r.max-1;this.chartObj.model.sumofYValues=0;s=r.interval;e=r.min;do this.chartObj.model.sumofYValues+=r.interval,e+=r.interval;while(e<=o)}u=this._calculatePolarAxesSegment(i);i.drawType.toLowerCase()=="area"?this.drawAreaPath(i,f,u):i.drawType.toLowerCase()=="line"?this._drawLinePath(i,f,u):i.drawType.toLowerCase()=="spline"&&this._drawLinePath(i,f,u);this.chartObj.svgRenderer.append(this.gSeriesGroupEle,this.chartObj.gSeriesEle)},doAnimation:function(t,i){var r=i.chartObj,o=t.drawType.toLowerCase();t.regionAdded=!0;r.model._radius=r.model.Radius||r.model._radius;r.model.Radius=0;var e=i,u=n.inArray(t,r.model._visibleSeries),f=n(r.gSeriesEle).find("#"+e.gSeriesGroupEle.id)[0].childNodes[0];n(f).animate({Radius:r.model._radius},{duration:1200,queue:!1,step:function(i){if(ej.util.isNullOrUndefined(r.model))n(f).stop(!0,!0);else{r.model.Radius=i;var u=e._calculatePolarAxesSegment(t);t.drawType.toLowerCase()!="column"&&t.drawType.toLowerCase()!="rangecolumn"&&o!="scatter"&&r.svgRenderer._setAttr(n(f),{d:u});r.model.Radius=r.model._radius}},complete:function(){if(!ej.util.isNullOrUndefined(r.model)){t.regionAdded=!1;r.svgRenderer._setAttr(n(r.gSeriesEle).find("#"+r.svgObject.id+"_TextGroup_"+u),{visibility:"visible"});r.svgRenderer._setAttr(n(r.gSeriesEle).find("#"+r.svgObject.id+"_symbolGroup_"+u),{visibility:"visible"});r.svgRenderer._setAttr(n(r.gSeriesEle).find("#"+r.svgObject.id+"_DataLabel_"+u),{visibility:"visible"});r.model.AnimationComplete=!0;var i=n.extend({},ej.EjSvgRender.commonChartEventArgs);i.data={series:t};r._trigger("animationComplete",i)}}})},chartAreaType:"PolarAxes"});ej.seriesTypes.radar=ej.ejRadarSeries}(jQuery);ej.ejChart={},function($){Object.keys||(Object.keys=function(){"use strict";var t=Object.prototype.hasOwnProperty,i=!{toString:null}.propertyIsEnumerable("toString"),n=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],r=n.length;return function(u){if(typeof u=="function"||typeof u=="object"&&u!==null){var e=[],o,f;for(o in u)t.call(u,o)&&e.push(o);if(i)for(f=0;f<r;f++)t.call(u,n[f])&&e.push(n[f]);return e}}}());Array.isArray||(Array.isArray=function(n){return Object.prototype.toString.call(n)==="[object Array]"});Array.prototype.map===undefined&&(Array.prototype.map=function(n){for(var i=[],t=0,r=this.length;t<r;t++)i.push(n(this[t]));return i});String.prototype.parseTemplate=function(){var str=this,substr,count=0,arabic=/[\u0600-\u06FF]/;for($.each(arguments[0],function(n,t){t.count>0?$.each(t,function(t,i){var e=new RegExp("#"+n+"."+t+"#","gm"),r,u,f;if(count++,arabic.test(str)&&count==2){for(r=str.split(" "),u=0;u<r.length;u++)f=r[u],arabic.test(f)&&(f=f+"&lrm;",r[u]=f);str=r.join(" ")}str=str.replace(e.source,i)}):str=str.replace(new RegExp("\\#"+n+"\\#","gm"),t)});str.indexOf("ej.")>=0;)substr=str.substring(str.indexOf("ej."),str.indexOf(")")+1),str=str.replace(substr,eval(substr));return str};String.prototype.capitalizeFirstString=function(){return this.charAt(0).toUpperCase()+this.slice(1)};var Gradient=function(n){this._gradientStop=[];for(var t=0;t<n.length;t++)this._gradientStop.push(n[t])};ej.ejChart={_renderSfChart:function(){var t=window.SVGSVGElement?!0:!1,n=this.model.enableCanvasRendering;return this.isChartElemId=!1,this.element[0].id||this._createChartId(),$("#chartContainer_"+this._id).remove(),t?(this.renderer=new ej.EjSvgRender(this.element),n?(this.svgRenderer=new ej.EjCanvasRender(this.element),this.legendSvgContainer=this.svgRenderer.createLegendCanvas(this.element)):(this.svgRenderer=new ej.EjSvgRender(this.element),this.legendSvgContainer=this.svgRenderer.createLegendSvg(this.element)),this._appendChartElements(),n||this.legendContainer.find("svg").attr("class","e-designerhide"),this._createChart(),$(this.svgObject).appendTo(this.element)):(n=!1,this.svgRenderer=new ej.EjVmlRender(this.element),this.legendSvgContainer=this.svgRenderer.createLegendSvg(this.element),this.renderer=new ej.EjVmlRender(this.element),this._appendChartElements(),this._createChart(),$(this.svgObject).appendTo(this.chartContainer)),!0},_appendChartElements:function(){this.legendContainer=$("<div><\/div>").attr("id","legend_"+this._id).css("height","0px");this.scrollerContainer=$("<div><\/div>").attr("id","legend_Scroller"+this._id).css("height","0px");this.templateContainer=$("<div><\/div>").attr("id",this._id+"_container_svg_TrackToolTip").css("height","0px");this.chartContainer=$("<div><\/div>").css("position","relative").attr("id","chartContainer_"+this._id);this.axisScroll=$("<div><\/div>").attr("id","axisScrollbar_"+this._id).css("height","0px");this.svgRenderer.append(this.legendSvgContainer,this.scrollerContainer);$(this.scrollerContainer).appendTo(this.legendContainer);$(this.axisScroll).appendTo(this.chartContainer);$(this.legendContainer).appendTo(this.chartContainer);$(this.templateContainer).appendTo(this.chartContainer);$(this.chartContainer).appendTo(this.element)},setSvgSize:function(n){var t=n,e=$(t.element).height(),i=450,f=ej.isTouchDevice()?250:600,o=$(t.element).width(),s=$(t.chartContainer).height(),r,u;t.model.size.width?(r=t.model.size.width,f=typeof r=="string"&&r.indexOf("%")!=-1?o/100*parseInt(r):parseInt(r)):o>0&&(f=o);$(t.svgObject).width(f);t.model.size.height?(u=t.model.size.height,i=typeof u=="string"&&u.indexOf("%")!=-1?this.vmlRendering?i:e/100*parseInt(u):parseInt(u)):e>0?i=e:$(t.svgObject).css("display","block");$(t.svgObject).height(i);$("#"+t._id).css("overflow","hidden");t.svgObject.setAttribute("width",f);t.svgObject.setAttribute("height",i)},compareExtend:function(n,t,i){var f,e,r,u;if(typeof i=="object"&&i!==null)for(f=Object.keys(i),e=f.length,u=0;u<e;u++)r=f[u],t.hasOwnProperty(r)&&t[r]!=null?(Array.isArray(t[r])||typeof t[r]=="object"&&t[r]!==null)&&this.compareExtend({},t[r],i[r]):t[r]=i[r];return t},setModelProperties:function(n){var r,l,o,u,s,h,c,t,i,e,f;if(n||this.setSvgSize(this),this.svgWidth=$(this.svgObject).width(),this.svgHeight=$(this.svgObject).height(),this.chartCross={visible:n?this.chartCross.visible:this.model.crosshair.visible,mArea:this.model.crosshair.type},this.serAnimation=[],this.model.series&&!n)for(s=!1,this.model._drawTrendline=!1,t=0;t<this.model.series.length;t++)for(c=null,ej.util.isNullOrUndefined(this.model.series[t].dataSource)&&ej.util.isNullOrUndefined(this.model.commonSeriesOptions.dataSource)||(c=ej.util.isNullOrUndefined(this.model.series[t].dataSource)?this.model.commonSeriesOptions.dataSource:this.model.series[t].dataSource),this.model.series[t]=ej.copyObject({},this.model.commonSeriesOptions,this.model.series[t]),this.model.series[t].dataSource=c,u=this.model.series[t],this.serAnimation.push(u.enableAnimation===null||u.enableAnimation===undefined?this.model.commonSeriesOptions.enableAnimation:u.enableAnimation),r=u.trendlines,l=r.length,i=0;i<l;i++)if(r[i]=ej.copyObject({},this.model.trendlineDefaults,r[i]),r[i]._visibility=r[i].visibility,r[i].visibility.toLowerCase()=="visible"){if(this.model._drawTrendline=!0,h=r[i].type.toLowerCase(),!ej.util.isNullOrUndefined(u.points))for(e=0;e<u.points.length;e++)if(o=u.points[e],ej.util.isNullOrUndefined(o.y)||o.y==0){s=!0;break}r[i].isNull=s&&(h=="power"||h=="exponential")?!0:!1}if(this.model.indicators)for(f=0;f<this.model.indicators.length;f++)this.model.indicators[f]=ej.copyObject({},this.model.indicatorDefaults,this.model.indicators[f])},_createChart:function(){var r,n,i,t;if(this.svgObject=this.svgRenderer.svgObj,r=$.extend({},ej.EjSvgRender.commonChartEventArgs),this._trigger("load",r),this.setTheme(ej.EjSvgRender.themes,this.model.theme),n=this.model,n.series[0]&&n.series[0]._isdesigntime){for(n.series[0]={},n.series[0].points=[],i=[],t=1;t<=10;t++)i.push({x:t,y:Math.floor(Math.random()*-30)+40});n.series[0].points=i}this.vmlRendering=this.svgRenderer.vmlNamespace?!0:!1;($(this.element).is(":visible")||$(this.element).css("visibility")!="hidden"||$(this.element).css("display")!="none")&&(this.bindEvents(),this.bindTo())},setTheme:function(n,t){var i=t.toLowerCase();(i.indexOf("azure")>=0||i.indexOf("lime")>=0||i.indexOf("saffron")>=0)&&i.indexOf("gradient")==-1&&i.indexOf("dark")==-1?n[i]=$.extend(!0,{},n.flatlight,n[i]):(i.indexOf("azuredark")>=0||i.indexOf("limedark")>=0||i.indexOf("saffrondark"))>=0&&i.indexOf("gradient")==-1?n[i]=$.extend(!0,{},n.flatdark,n[i]):(i.indexOf("azure")>=0||i.indexOf("lime")>=0||i.indexOf("saffron")>=0)&&i.indexOf("gradient")>=0&&i.indexOf("dark")==-1?n[i]=$.extend(!0,{},n.gradientlight,n[i]):(i.indexOf("azuredark")>=0||i.indexOf("limedark")>=0||i.indexOf("saffrondark")>=0)&&i.indexOf("gradient")>=0?n[i]=$.extend(!0,{},n.gradientdark,n[i]):i.indexOf("high")>=0?n[i]=$.extend(!0,{},n.highcontrast01,n[i]):i.indexOf("material")>=0||i.indexOf("office")>=0?n[i]=$.extend(!0,{},n.material,n[i]):n[i]||(i="flatlight");this.model=this.model._themeChanged?ej.copyObject({},this.model,n[i]):this.compareExtend({},this.model,n[i]);this.model.background=ej.util.isNullOrUndefined(this.model.background)?n[i].background:this.model.background},_drawBackInterior:function(){if(this.model.backInterior&&this.model.backInterior._gradientStop){var n={id:this.svgObject.id+"_backGradient",x1:"0%",y1:"0%",x2:"0%",y2:$(this.svgObject).height()+"%"};this.svgRenderer.drawGradient(n,this.model.backInterior._gradientStop)}},_drawBackImage:function(){var n={height:$(this.svgObject).height(),width:$(this.svgObject).width(),href:this.model.backGroundImageUrl,x:0,y:0,id:this.svgObject.id+"_backImage",visibility:"visible",preserveAspectRatio:"none"};this.svgRenderer.drawImage(n,this.svgObject)},_getDataType:function(n){var t=typeof n;return t==="number"||t==="string"?t:jQuery.type(n)=="date"?"date":n==null?null:!1},addedXYValues:function(n){var i,nt,t,o;n=n?n:!1;var e=this.model,f=e.series,k=f[0].type.toLowerCase(),p,a,u,l,i,s=ej.util.isNullOrUndefined,v=e.primaryXAxis.valueType,w,d=!1,h,r,y,g,b,t,c;if(c=e.AreaType=ej.seriesTypes[k].prototype.chartAreaType,c!="cartesianAxes"&&c!="None"&&(c=e.AreaType="polaraxes",e.isPolar=k=="polar"),c=e.AreaType=e.AreaType.toLowerCase(),!n){for(u=0;u<f.length;u++)if(f[u].visibility=="visible"){if(y=!0,w=!1,f[u].dataSource&&f[u].dataSource.length!=0)for(r=f[u],r._xAxisValueType=null,p=r.points.length,h=r.points[0].x,h!=null&&(r._xAxisValueType=this._getDataType(h)),nt=r.points.length,t=r.points,o=0;o<nt;o++)typeof t[o].x=="string"&&t[o].x.indexOf("<br>")!=-1&&(t[o].x=t[o].x.replace(/(<br>)+/g,"<br>"));else for(t=f[u].points,f[u].points=null,f[u]=$.extend(!0,{},e.commonSeriesOptions,f[u]),f[u].points=t,r=f[u],v=="datetime"&&(d=!0),p=t.length,i=0;i<p;i++)t[i].YValues=[],g=/^-?[0-9]*\.?[0-9]+$/.test(t[i].x)==!0,b=v!="category"&&v!="datetime"&&(typeof t[i].x=="string"||t[i].x instanceof String)&&parseFloat(t[i].x),!isNaN(b?t[i].x:parseFloat(t[i].x))&&b&&g&&v!="category"&&c!="none"&&(t[i].x=d?new Date(t[i].x):parseFloat(t[i].x)),typeof t[i].x=="string"&&t[i].x.indexOf("<br>")!=-1&&(t[i].x=t[i].x.replace(/(<br>)+/g,"<br>")),t[i].xValue=t[i].x,w||(h=t[i].x,s(h)||(r._xAxisValueType=this._getDataType(h),w=!0)),r._hiloTypes||r.drawType.toLowerCase()=="rangecolumn"?(s(t[i].high)||(t[i].YValues[0]=t[i].high,t[i].y=t[i].high),s(t[i].low)||(t[i].YValues[1]=t[i].low),s(t[i].open)||(t[i].YValues[2]=t[i].open),s(t[i].close)||(t[i].YValues[3]=t[i].close)):(t[i].YValues[0]=r.points[i].y,y=y&&!s(t[i].size),y&&(t[i].YValues[1]=t[i].size));if(r.type.toLowerCase()=="waterfall")this.calculateWaterfallSeriesPoints(r.points);else if(r._previousType&&r._previousType.toLowerCase()=="waterfall")for(a=r.points,l=0;l<a.length;l++)a[l].waterfallSum=undefined,a[l].textOptions=null}this._setInternalValues()}},calculateWaterfallSeriesPoints:function(n){for(var r=0,i=0,u=0,t=0;t<n.length;t++)n[t].isEmpty?(n[t].YValues[1]=0,n[t].YValues[0]=0):(i+=n[t].showIntermediateSum||n[t].showTotalSum?0:n[t].y,n[t].showIntermediateSum?(n[t].YValues[1]=r,n[t].YValues[0]=i,n[t].waterfallSum=i-r,r=i):n[t].showTotalSum?(n[t].YValues[1]=0,n[t].YValues[0]=i,n[t].waterfallSum=i):(n[t].YValues[1]=u,n[t].YValues[0]=u+n[t].y,u=i))},_setInternalValues:function(){for(var n,r,t,i=0;i<this.model.series.length;i++){if(n=this.model.series[i],this.model.AreaType=="cartesianaxes"&&ej.seriesTypes[n.type.toLowerCase()].prototype.chartAreaType=="cartesianAxes")n._zOrder=n.zOrder?n.zOrder:0,this.model._visibleSeries.push(n);else if(this.model.AreaType=="none"&&ej.seriesTypes[n.type.toLowerCase()].prototype.chartAreaType=="None")if(n._zOrder=n.zOrder?n.zOrder:0,r=this.model.series[i].type.toLowerCase(),r=="funnel"||r=="pyramid"){this.model._visibleSeries.push(n);break}else this.model._visibleSeries.push(n);else this.model.AreaType=="polaraxes"&&ej.seriesTypes[n.type.toLowerCase()].prototype.chartAreaType=="PolarAxes"&&(n._zOrder=n.zOrder?n.zOrder:0,this.model._visibleSeries.push(n));if((n._yAxisName||n._xAxisName)&&this.model._axes)for(t=0;t<this.model._axes.length;t++)n._yAxisName&&n._yAxisName==this.model._axes[t].name&&(this.model._axes[t].orientation=this.model._axes[t].orientation?this.model._axes[t].orientation:this.model.requireInvertedAxes?"horizontal":"vertical"),n._xAxisName&&n._xAxisName==this.model._axes[t].name&&(this.model._axes[t].orientation=this.model._axes[t].orientation?this.model._axes[t].orientation:this.model.requireInvertedAxes?"vertical":"horizontal")}},setHiloStyle:function(n,t,i,r){var e=n.points[t],f,u;return f=e.fill?e.fill:n.fill?n.fill:r,u=f?f:this.model.seriesColors[i],jQuery.type(u)=="array"?u[0].color:u},setStyle:function(n,t,i,r,u,f){var g=f||t._visiblePoints,e=g[r],s,y,p,w,b,k,c,o=e.border,l=t.border,a,v,h,d;return t._hiloTypes&&(c=t.isFill?t.fill:null),n.chartObj.model.AreaType=="cartesianaxes"?(e.fill?s=e.fill:t.type.toLowerCase()=="waterfall"?((e.showIntermediateSum||e.showTotalSum)&&e.waterfallSum>0||e.y>0&&!e.showIntermediateSum&&!e.showTotalSum)&&(s=t.positiveFill?t.positiveFill:u):s=c?c:u,a=s?s:this.model.seriesColors[i],v=n.chartObj.model.requireInvertedAxes?this.svgRenderer.createGradientElement(n.getSeriesName(t)+"_"+i+r,a,0,0,100,0,n.gSeriesGroupEle):this.svgRenderer.createGradientElement(n.getSeriesName(t)+"_"+i+r,a,0,0,0,100,n.gSeriesGroupEle)):(h=this.model.pointColors,s=e.fill?e.fill:jQuery.type(h[r])=="array"?h[r][0].color:h[r],d=this.svgRenderer.createGradientElement(n.getSeriesName(t)+r,s,0,0,0,$(n.svgObject).height()||parseFloat(this.model.size.height),n.chartObj.gSeriesEle)),y=o&&o.color?o.color:l.color,p=o&&!ej.util.isNullOrUndefined(o.width)?o.width:l.width,k=e.opacity?e.opacity:t.opacity,b=e.width?e.width:t.width,w=o&&o.dashArray?o.dashArray:l.dashArray,{interior:v?v:d,borderColor:y,borderWidth:p,width:b,opacity:k,dashArray:w}},colorNameToHex:function(n){var t=n,i={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4","indianred ":"#cd5c5c","indigo ":"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};return Object.prototype.toString.call(t)=="[object Array]"?t:typeof i[t.toLowerCase()]!="undefined"?i[t.toLowerCase()]:t},_getLocalizedLabels:function(){return ej.getLocalizedConstants(this.sfType,this.model.locale)},_setCulture:function(n){this.culture=ej.preferredCulture(n)},draw:function(n){var f,tt,kt,ot,st,u,v,y,it,h,e,d,w,ti,r,l,p,oi,rt,et,ht,ct,lt,g,at,si,ut,yt,a,o,nt,s,c,li,pt,b,wt,ai,bt,t,i;for(this.removeMultiRect(),f={},f.axes={},this._drawBackInterior(),this.model.chartRegions=[],this.model.outsideDataRegionPoints=[],this.model.regionCount=null,this.model.circularRadius=[],this.model.circleCenterX=[],this.model.circleCenterY=[],this.model.innerRadius=[],this.model.bounds=[],this.accDataLabelRegion=[],this.model.rightsidebounds=[],this.model.leftsidebounds=[],this.model.excludeDataUpdate=n,this.model.yAxisLabelRegions=[],this.model.xAxisLabelRegions=[],this.model.axisMultiLevelLabelRegions=[],this.model.multiLevelLabelRegions=[],this.model.minhightwidth=!1,this.model._isPieOfPie=!1,n||(this.model._visibleSeries=[]),this.model.stackedValue={},this.model._locale=this.model.locale||"en-US",this._setCulture(this.model._locale),this._localizedLabels=this._getLocalizedLabels(),tt=this.model.series.length,this.model._sideBySideSeriesPlacement=ej.util.isNullOrUndefined(this.model.sideBySideSeriesPlacement)?this.model.enable3D?!1:!0:this.model.sideBySideSeriesPlacement,t=0;t<tt;t++)r=this.model.series[t],kt=r.type.toLowerCase(),r._isTransposed=kt.indexOf("bar")==-1?r.isTransposed:!r.isTransposed;for(tt>0&&this.addedXYValues(n),this.model.AreaType=this.model.AreaType||"cartesianaxes",this._isEjScroller(),ot=$.extend({},ej.EjSvgRender.commonChartEventArgs),ot.data={},this._trigger("preRender",ot),this.gLegendEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_Legend"}),this.gTitleEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_ChartTitle",cursor:"default"}),this.gSubTitleEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_ChartsubTitle",cursor:"default"}),this._createAxisLabelAndRange(),t=0;t<this.model._axes.length;t++)f.axes[this.model._axes[t].name]={};for(this._initializeSeriesColors(),this._calculateLegendBounds(),this.legendRender=new ej.EjLegendRender(this),st=$.extend({},ej.EjSvgRender.commonChartEventArgs),st.data={legendBounds:this.model.LegendBounds},this._trigger("legendBoundsCalculate",st),e=0;e<this.model.indicators.length;e++)if(u=this.model.indicators[e],u._points=[],u.xAxisName=u.xAxisName?u.xAxisName:this.model._axes[0].name,u.yAxisName=u.yAxisName?u.yAxisName:this.model._axes[1].name,u.isIndicator=!0,u.dataSource&&u.dataSource.length>0)u._hiloTypes=!0,this._processJsonData(u.dataSource,u),u._points=u.points;else if(u.points.length>0)for(t=0;t<u.points.length;t++)u._points=u.points,u._points[t].xValue=u.points[t].x,u._points[t].YValues=[],u._points[t].YValues[0]=u.points[t].close;else if(u.seriesName!="")for(v=0;v<this.model._visibleSeries.length;v++)r=this.model._visibleSeries[v],u.seriesName==r.name&&(u._points=$.extend(!0,[],r.points));for(h=0;h<this.model._axes.length;h++)if(this.model._axes[h].valueType&&this.model._axes[h].valueType.toLowerCase()=="category")for(t=0;t<this.model.indicators.length;t++)if(u=this.model.indicators[t],this.model._axes[h].name==u.xAxisName)for(e=0;e<u._points.length;e++)u._points[e].xValue=e;for(this.model.indicatorRange=[],v=0;v<this.model.indicators.length;v++)u=this.model.indicators[v],u._points.length>0&&(p=u.type.toLowerCase(),y=new ej.indicatorTypes[p],y.calculateSegment(u,this));for(l=0;l<this.model._visibleSeries.length;l++)for(y=this.model._visibleSeries[l],t=0;t<y.points.length;t++)if(typeof y.points[t].xValue=="string"&&y.points[t].xValue.indexOf("/Date(")!=-1)y.points[t].xValue=new Date(parseInt(y.points[t].xValue.substr(6)));else break;this.model.hAxes=[];this.model.vAxes=[];var k=this,dt=!1,gt=!1;for(this._arrangeAxis(),this.model.crosshairLabelVisibility=!1,h=0;h<this.model._axes.length;h++){i=this.model._axes[h];this.model.crosshairLabelVisibility=i.crosshairLabel.visible||this.model.crosshairLabelVisibility;var c=[],tt=this.model.series.length,ni=this.model._axes[h].orientation.toLowerCase(),vi=this.model._axes[h].rangePadding.toLowerCase();if(ej.util.isNullOrUndefined(this.model._axes[h]._rangePadding)&&(this.model._axes[h]._rangePadding=this.model._axes[h].rangePadding),vi=="auto")for(ni=="vertical"&&(i.rangePadding=this.model.requireInvertedAxes?"none":"normal"),ni=="horizontal"&&(i.rangePadding=this.model.requireInvertedAxes?"normal":"none"),e=0;e<tt;e++)if(p=this.model.series[e].type.toLowerCase(),p.indexOf("100")!=-1&&i.name==this.model.series[e]._yAxisName){i.rangePadding="round";break}for(d=0;d<i.stripLine.length;d++)i.stripLine[d]=$.extend(!0,{},this.model.stripLineDefault,i.stripLine[d]),i.stripLine[d].zIndex.toLowerCase()=="over"?dt=!0:gt=!0;for(w=i.orientation.toLowerCase(),ti=this.model._visibleSeries.length-1,e=0;e<this.model._visibleSeries.length;++e){ti-=1;r=this.model._visibleSeries[e];this.model._hasSeriesPoints=r.points.length>0||this.model._hasSeriesPoints;r.xAxisName||(r._xAxisName=k.model._axes[0].name);r.yAxisName||(r._yAxisName=k.model._axes[1].name);r._xAxisName=r._xAxisName?r._xAxisName:r.xAxisName?r.xAxisName:k.model._axes[0].name;r._yAxisName=r._yAxisName?r._yAxisName:r.yAxisName?r.yAxisName:k.model._axes[1].name;var ii=r._xAxisName.toLowerCase(),ri=r._yAxisName.toLowerCase(),ui=i.name.toLowerCase();if((ii||ri)&&(ii==ui||ri==ui)){if((w=="horizontal"||r.type.toLowerCase().indexOf("bar")!=-1&&w=="vertical")&&i.valueType&&i.valueType.toLowerCase()=="datetime")for(l=0;l<r.points.length;l++)typeof r.points[l].xValue!="string"||isNaN(Date.parse(r.points[l].xValue))||(r.points[l].xValue=new Date(Date.parse(r.points[l].xValue)));else r._xAxisValueType!="string"||i.valueType||(i._valueType=w=="horizontal"&&!this.model.requireInvertedAxes?"category":w=="vertical"&&this.model.requireInvertedAxes?"category":"double"),r._xAxisValueType!="date"||i.valueType||(i._valueType=w=="horizontal"&&!this.model.requireInvertedAxes?"datetime":w=="vertical"&&this.model.requireInvertedAxes?"datetime":"double");this.model._visibleSeries[e].visibility.toLowerCase()=="visible"&&c.push(r)}}if(w==(this.model.requireInvertedAxes?"horizontal":"vertical")){var fi=!1,ei=!1,tt=c.length;for(i.isStacked100=c.length>0?!0:!1,t=0;t<tt;t++)p=c[t].type.toLowerCase(),p.indexOf("stacking")!=-1||this.model.AreaType=="polaraxes"&&(c[t].drawType.toLowerCase()=="column"||c[t].drawType.toLowerCase()=="area")&&c[t].isStacking?p.indexOf("100")==-1||fi?p.indexOf("100")!=-1||ei||(this._calculateStackingValues(c,i,f),ei=!0,i.isStacked100=!1):(this._calculateStackingCumulativeValues(c,i,f),fi=!0):i.isStacked100=!1}for(it=i.scrollbarSettings,it.visible&&(it.pointsLength!=null||it.range.min!=null||it.range.max!=null)&&(this.model.isLazyZooming=!0),i._valueType=i._valueType?i._valueType:i.valueType?i.valueType:"double",oi=new ej.axisTypes[i._valueType.toLowerCase()],rt=0;rt<c.length;rt++)for(et=0;et<c[rt].trendlines.length;et++)if(c[rt].trendlines[et].visibility=="visible"){this.model._drawTrendline=!0;break}oi._calculateRanges(k,i,c,f,n)}if(k._chartResize=!1,ht=$.extend({},ej.EjSvgRender.commonChartEventArgs),ht.data={axes:this.model._axes},this._trigger("axesLabelsInitialize",ht),this.model.isLazyZooming?0:this._updateScroll(),(this.svgHeight!=this.model.svgHeight||this.svgWidth!=this.model.svgWidth)&&(ct=ej.util.isNullOrUndefined(this.prevHeight)?this.svgHeight:this.prevHeight,lt=ej.util.isNullOrUndefined(this.prevWidth)?this.svgWidth:this.prevWidth,s=$.extend({},ej.EjSvgRender.commonChartEventArgs),s.data={currentHeight:ct,currentWidth:lt,newHeight:this.model.svgHeight,newWidth:this.model.svgWidth},this._trigger("beforeResize",s),s.cancel?(this.model.enableCanvasRendering&&(this.svgRenderer.svgObj.width=s.data.currentWidth,this.svgRenderer.svgObj.height=s.data.currentHeight),this.model.svgWidth=s.data.currentWidth,this.model.svgHeight=s.data.currentHeight,$(this.svgObject).width(s.data.currentWidth),$(this.svgObject).height(s.data.currentHeight)):(this.model.enableCanvasRendering&&(this.svgRenderer.svgObj.width=s.data.newWidth,this.svgRenderer.svgObj.height=s.data.newHeight),this.model.svgWidth=s.data.newWidth,this.model.svgHeight=s.data.newHeight,$(this.svgObject).width(s.data.newWidth),$(this.svgObject).height(s.data.newHeight))),this._calculateAreaBounds(f),this.model.enable3D&&(g=new ej.Ej3DRender,this.vector=new g.vector3D,this.matrixobj=new g.matrix3D,this.bsptreeobj=new g.BSPTreeBuilder,this.polygon=new g.polygon3D,this.graphics=new g.Graphics3D,this.chart3D=this.svgRenderer.createGroup({id:this.svgObject.id+"_Chart3D"}),ej.Ej3DRender.Polygons=[]),this.model.AreaType!="none"){for(this._calculateAxisSize(f),t=0,nt=this.model._axes.length;t<nt;t++)this._validateCrossing(this.model._axes[t])&&this._axisCrossing(this.model._axes[t],!1,f);if(f._crossAxisOverlap){for(t=0,nt=this.model._axes.length;t<nt;t++)f.axes[this.model._axes[t].name]._validCross&&this._axisCrossing(this.model._axes[t],!0,f);f._crossAxisOverlap=!1}if(at=$.extend({},ej.EjSvgRender.commonChartEventArgs),at.data={areaBounds:this.model.m_AreaBounds},this._trigger("chartAreaBoundsCalculate",at),this._drawChartAreaRect(),this.model.title.text!=""&&this.model.title.text&&this.model.title.visible&&this._drawTitle(),this.gXaxisEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxis"}),this.gYaxisEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxis"}),this.gPolarAxisEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_AxisLine"}),this.model.enable3D?($.extend(ej.Ej3DAxisRenderer.prototype,this),this.chartaxis=new ej.Ej3DAxisRenderer(this)):($.extend(ej.EjAxisRenderer.prototype,this),this.chartaxis=new ej.EjAxisRenderer(this)),a=this.chartaxis,this.model.xAxisTitleRegion=[],this.model.yAxisTitleRegion=[],this.model.enable3D){for(o=0;o<this.model._axes.length;o++)a._drawAxes(o,this.model._axes[o],f);ej.Ej3DChart.prototype.update3DWall(this,f)}else for(o=0;o<this.model._axes.length;o++)a._drawGridLines(o,this.model._axes[o],f);this.model.requireInvertedAxes?(this.svgRenderer.append(this.gYaxisEle,this.svgObject),this.svgRenderer.append(this.gXaxisEle,this.svgObject)):(this.svgRenderer.append(this.gXaxisEle,this.svgObject),this.svgRenderer.append(this.gYaxisEle,this.svgObject));var yi=this.model.AreaType=="polaraxes"?0:this.model.m_AreaBounds.X,pi=this.model.AreaType=="polaraxes"?0:this.model.m_AreaBounds.Y,wi=this.model.AreaType=="polaraxes"?$(this.svgObject).width():this.model.m_AreaBounds.Width,bi=this.model.AreaType=="polaraxes"?$(this.svgObject).height():this.model.m_AreaBounds.Height,vt={id:this.svgObject.id+"_ChartAreaClipRect",x:yi,y:pi,width:wi,height:bi,fill:"white","stroke-width":1,stroke:"Gray"};this.svgRenderer.drawClipPath(vt,this.svgObject);this._setZoomProperties()}else this._drawChartAreaRect(),vt={id:this.svgObject.id+"_ChartAreaClipRect",x:0,y:0,width:$(this.svgObject).width(),height:$(this.svgObject).height(),fill:"white","stroke-width":1,stroke:"Gray"},this.svgRenderer.drawClipPath(vt,this.svgObject),this.model.title.text!=""&&this.model.title.text&&this.model.title.visible&&this._drawTitle();for(gt&&this.model.AreaType=="cartesianaxes"&&!this.model.enable3D&&(this.gStriplineBehind=this.svgRenderer.createGroup({id:this.svgObject.id+"_StriplineBehind","clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)"}),this._renderStripline("behind")),this.model.initSeriesRender&&(this.seriesRender(f,n),this.indicatorRender()),si=this.model.annotations.length,$("#annotation_group_"+this._id).empty(),ut=0;ut<si;ut++)yt=this.model.annotations[ut],yt.visible&&this.annotationRender(yt,ut);if(this.model.AreaType=="polaraxes"&&this.model._axes[1].visible&&!this.model.enable3D&&this.chartaxis._drawAxisLine(this.model._axes[1]),this.model.AreaType==="cartesianaxes"&&(this.model.requireInvertedAxes?(this.svgRenderer.append(this.gYaxisEle,this.svgObject),this.svgRenderer.append(this.gXaxisEle,this.svgObject)):(this.svgRenderer.append(this.gXaxisEle,this.svgObject),this.svgRenderer.append(this.gYaxisEle,this.svgObject)),this.gXaxisTickEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_XAxisTick"}),this.gYaxisTickEle=this.svgRenderer.createGroup({id:this.svgObject.id+"_YAxisTick"})),$.extend(ej.EjAxisRenderer.prototype,this),this.chartaxis=new ej.EjAxisRenderer(this),a=this.chartaxis,dt&&this.model.AreaType=="cartesianaxes"&&!this.model.enable3D&&(this.gStriplineOver=this.svgRenderer.createGroup({id:this.svgObject.id+"_StriplineOver","clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)"}),this._renderStripline("over")),!this.model.enable3D){var ki=this.model.AreaType.toLowerCase()=="cartesianaxes",hi=this.model._axes,ci=this.model.enableCanvasRendering;for(o=0,nt=hi.length;o<nt;o++){var i=hi[o],ft=f.axes[i.name]._lineOption,di=f.axes[i.name]._validCross;ki&&(a._drawAxes(o,i),ft[0]&&this.svgRenderer.drawLine(ft[0],ft[1]),i.orientation.toLowerCase()==="horizontal"?(a._drawXAxisTickLine(o,i,ci?null:ft[1],f),a._drawXAxisMultiLevelLabels(o,i)):(a._drawYAxisTickLine(o,i,ci?null:ft[1],di),a._drawYAxisMultiLevelLabels(o,i)),i._crossValue=null)}}if(!this.resetZooming&&(this.model._chartAreaZoom||this.panning)&&this._enableZoomingButtons(),this.resetZooming=!1,(this.svgHeight!=this.model.svgHeight||this.svgWidth!=this.model.svgWidth)&&(this.prevHeight=this.model.svgHeight,this.prevWidth=this.model.svgWidth,s=$.extend({},ej.EjSvgRender.commonChartEventArgs),s.data={height:this.prevHeight,width:this.prevWidth,prevHeight:ct,prevWidth:lt,originalHeight:this.svgHeight,originalWidth:this.svgWidth},this._trigger("afterResize",s)),c=this.model._visibleSeries,li=$.grep(c,function(n){return n.selectionSettings.enable.toString()=="true"}),li.length==0?(this.model.selectionEnable=!1,this._removeSelection()):this.model.selectionEnable=!0,pt=this.remove_duplicates(this.model.selectedDataPointIndexes),this.model.selectionEnable)for(this._removeSelection(),this.model._isStateChaged=!0,ai=pt.length,t=0;t<ai;t++)b=pt[t],r=this.model._visibleSeries[b.seriesIndex],r&&(wt=r.selectionSettings.mode,(wt!="series"&&r.points[b.pointIndex]||wt=="series")&&this.segmentSelection(b.event,b.legendData,b.seriesIndex,b.pointIndex,b.data));for(this.chartUpdating=!1,$(document).find("#measureTex").remove(),bt=$.extend({},ej.EjSvgRender.commonChartEventArgs),bt.data={model:this.model},this._trigger("loaded",bt),t=0;t<this.model._axes.length;t++)i=$.extend(!0,{},this.model._axes[t]),i._valueType.toLowerCase()!="logarithmic"&&(this.model._axes[t].range=i._initialRange)},remove_duplicates:function(n){for(var i=[],r=[],e=n.length,u,f,o=this.model._visibleSeries,t=0;t<e;t++)f=o[n[t].seriesIndex],u=f?f.selectionSettings.mode:"",u=="series"?(i.indexOf(n[t].seriesIndex)>-1||r.push(n[t]),i.push(n[t].seriesIndex)):u=="cluster"?(i.indexOf(n[t].pointIndex)>-1||r.push(n[t]),i.push(n[t].pointIndex)):(n[t]in i||r.push(n[t]),i.push(n[t]));return r},_setZoomProperties:function(){for(var n,t,i,r,u=0;u<this.model._axes.length;u++)n=this.model._axes[u],r=n.orientation.toLowerCase(),t=n.zoomFactor.toFixed(3),i=n.zoomPosition.toFixed(3),r=="horizontal"&&(t!=this._xZoomFactor()||i!=this._xZoomPosition())&&(this._xZoomFactor(n.zoomFactor.toFixed(3)),this._xZoomPosition(n.zoomPosition.toFixed(3))),r=="vertical"&&(t!=this._yZoomFactor()||i!=this._yZoomPosition())&&(this._yZoomFactor(n.zoomFactor.toFixed(3)),this._yZoomPosition(n.zoomPosition.toFixed(3)))},annotationRender:function(n,t){var lt=this._id,d=!1,c=this.model.series[0],w=c.type.toLowerCase(),a=this.model.m_AreaBounds.X,y=this.model.m_AreaBounds.Y,ft=this.model.m_AreaBounds.Width,et=this.model.m_AreaBounds.Height,pi=this.model.margin.left,nr=this.model.margin.top,li=$.inArray(c,this.model._visibleSeries),at=this.model.circularRadius[li],vt=this.model.circleCenterX[li],yt=this.model.circleCenterY[li],wi=$(document),gt=!1,ni,ti,pt,ii,ri,ai,bi,o,i,r,st,tt,ht,g,vi,yi,ct,l,nt,di,gi,u,f,dt,rt,b,ut,h,v,p,e,bt;n=$.extend(!0,{},this.model.annotationsDefault,n);pt=$("#annotation_group_"+lt).length!=0?$("#annotation_group_"+lt):$("<div><\/div>").attr("id","annotation_group_"+lt);pt.css({position:"absolute",left:"0px",top:"0px"});ii=n.content;ri=$("#"+ii);ri.get(0).tagName=="SCRIPT"&&(ri=$($("#"+ii)[0].innerHTML));ai=ri.clone();bi="annotation_"+lt+"_"+ii+"_"+t;$(ai).attr("id",bi);o=$(ai);o.css({position:"absolute","z-index":2e3});var ot=n.region.toLowerCase(),kt=n.coordinateUnit.toLowerCase(),s=typeof n.x=="string"||typeof n.x=="object"?Date.parse(n.x):n.x,it=n.y,ui=n.horizontalAlignment.toLowerCase(),fi=n.verticalAlignment.toLowerCase();if(kt=="pixels")ot=="series"?ft+a+pi>s+a&&et+y+nr>it+y&&(i=s+a,r=it+y):ot=="chart"&&$(this.svgObject).width()>s&&$(this.svgObject).height()>it&&(i=s,r=it),o.css({left:i,top:r}),d=!0;else if(kt=="points")if(st={x:s,y:it},this.model.AreaType=="polaraxes")l=this.model._axes[0],nt=this.model._axes[1],s>=l.visibleRange.min&&s<=l.visibleRange.max&&it>=nt.visibleRange.min&&it<=nt.visibleRange.max&&(tt=this.TransformToVisibleAnnotation(l,nt,s,it,this),o.css({left:tt.X,top:tt.Y}),d=!0);else if(w=="pyramid"||w=="funnel")for(g=0;g<c._visiblePoints.length;g++)gt=c._visiblePoints[g].xValue<=s&&s<c._visiblePoints.length?!0:Date.parse(c._visiblePoints[g].xValue)<=s&&s<c._visiblePoints.length?!0:!1,gt&&(ht=c._visiblePoints[s],o.css({left:ht.xLocation+this.pyrX,top:ht.yLocation+this.pyrY-ht.height/2}),d=!0);else if(w=="pie"||w=="doughnut"||w=="pieofpie"){for(g=0;g<c._visiblePoints.length;g++)if(gt=c._visiblePoints[g].xValue<=s&&s<c._visiblePoints.length?!0:Date.parse(c._visiblePoints[g].xValue)<=s&&s<c._visiblePoints.length?!0:!1,gt){ht=c._visiblePoints[s];var tr=s,ei,oi,ki=new ej.seriesTypes[w],si=ht?ht.currentMidAngle:0;(tr==c.explodeIndex||c.explodeAll)&&!this.vmlRendering?(ei=vt+Math.cos(si)*c.explodeOffset,oi=yt+Math.sin(si)*c.explodeOffset):(ei=vt,oi=yt);vi=ki.getXCordinate(ei,at,si);yi=ki.getYCordinate(oi,at,si);ni=(vi+ei)/2;ti=(yi+oi)/2;ni=(vi+ni)/2;ti=(yi+ti)/2;o.css({left:ni,top:ti});d=!0}}else{var ir=n.xAxisName,rr=n.yAxisName,ur=this.model._axes.length;for(ct=0;ct<ur;ct++)this.model._axes[ct].name==ir&&(l=this.model._axes[ct]),this.model._axes[ct].name==rr&&(nt=this.model._axes[ct]);l||(l=this.model._axes[0]);nt||(nt=this.model._axes[1]);di=typeof l.range.min=="string"||typeof l.range.min=="object"?Date.parse(l.range.min):l.range.min;gi=typeof l.range.max=="string"||typeof l.range.max=="object"?Date.parse(l.range.max):l.range.max;di<=s&&gi>=s&&(this.model.requireInvertedAxes?(st.x=st.y+(st.y=st.x,0),tt=this._getAnnotationPoint(st,nt,l),o.css({left:tt.X+a,top:tt.Y+l.y})):(tt=this._getAnnotationPoint(st,l,nt),o.css({left:tt.X+a,top:tt.Y+nt.y})),d=!0)}else{if(o.css("display","block").appendTo($(pt)),$(pt).appendTo("#chartContainer_"+lt),u=o.outerWidth(),f=o.outerHeight(),ot=="chart"){switch(ui){case"middle":i=$(this.svgObject).width()/2-u/2;break;case"left":i=0;break;case"right":i=$(this.svgObject).width()-u}switch(fi){case"middle":r=$(this.svgObject).height()/2-f/2;break;case"top":r=0;break;case"bottom":r=$(this.svgObject).height()-f}}else if(w=="pie"||w=="doughnut"||w=="pieofpie"){i=vt;r=yt;switch(ui){case"middle":i=vt-u/2;break;case"left":i=vt-at;break;case"right":i=vt+at-u}switch(fi){case"middle":r=yt-f/2;break;case"top":r=yt-at;break;case"bottom":r=yt+at}}else{switch(ui){case"middle":i=a+ft/2-u/2;break;case"left":i=a;break;case"right":i=a+ft-u}switch(fi){case"middle":r=y+et/2-f/2;break;case"top":r=y;break;case"bottom":r=y+et-f}}(w=="pyramid"||w=="funnel")&&(i-=pi);o.css({left:i,top:r})}if(i=parseFloat(o.css("left")),r=parseFloat(o.css("top")),kt!="none"&&d){o.css("display","block").appendTo($(pt));$(pt).appendTo("#chartContainer_"+lt);u=o.outerWidth();f=o.outerHeight();switch(ui){case"middle":i-=u/2;break;case"left":i-=u}switch(fi){case"middle":r-=f/2;break;case"top":r-=f}}dt=n.margin;i=i+dt.left-dt.right;r=r+dt.top-dt.bottom;rt=$.extend({},ej.EjSvgRender.commonChartEventArgs);rt.data={content:o.html(),location:{x:i,y:r},opacity:n.opacity,angle:n.angle};this._trigger("annotationRendering",rt);o.html(rt.data.content);o.css({left:rt.data.location.x,top:rt.data.location.y,opacity:rt.data.opacity});b=rt.data.angle;b&&o.css({"-ms-transform":"rotate("+b+"deg)","-webkit-transform":"rotate("+b+"deg)","-moz-transform":"rotate("+b+"deg)","-o-transform":"rotate("+b+"deg)","-transform":"rotate("+b+"deg)"});var wt=o.attr("id"),k=e=v=h=0,hi=$("#"+this._id).width(),ci=$("#"+this._id).height();d&&b==0&&(ot=="series"||kt=="points")?(ft+a<i+u&&(ut=i+u-(ft+a),h=u-ut),i<a&&(v=a-i),et+y<r+f&&(p=r+f-(et+y),e=f-p),r<y&&(k=y-r),h=h==0?u:h,e=e==0?f:e,document.getElementById(wt).style.clip="rect("+k.toString()+"px,"+h.toString()+"px,"+e.toString()+"px,"+v+"px)"):d&&b==0&&ot=="chart"?(hi<i+u&&(ut=i+u-hi,h=u-ut),i<0&&(v=u+i,v=v==0?u:v),ci<r+f&&(p=r+f-ci,e=f-p),r<0&&(k=f+r,k=k==0?f:k),h=h==0?u:h,e=e==0?f:e,document.getElementById(wt).style.clip="rect("+k.toString()+"px,"+h.toString()+"px,"+e.toString()+"px,"+v+"px)"):d&&b==90&&(ot=="series"||kt=="points")?(bt=document.getElementById(wt).getBoundingClientRect(),i=bt.left-$(this.svgObject).offset().left+wi.scrollLeft(),r=bt.top-$(this.svgObject).offset().top+wi.scrollTop(),et+y<r+u&&(ut=r+u-(et+y),h=u-ut),i<a&&(p=a-i,e=f-p),r<y&&(v=y-r),ft+a<i+f&&(p=i+f-(ft+a),k=p),h=h==0?u:h,e=e==0?f:e,document.getElementById(wt).style.clip="rect("+k.toString()+"px,"+h.toString()+"px,"+e.toString()+"px,"+v+"px)"):d&&b==90&&ot=="chart"&&(bt=document.getElementById(wt).getBoundingClientRect(),i=bt.left-$(this.svgObject).offset().left,r=bt.top-$(this.svgObject).offset().top,ci<r+u&&(ut=r+u-ci,h=u-ut),i<0&&(p=0-i,e=f-p,e=e==0?f:e),r<0&&(v=0-r,v=v==0?u:v),hi<i+f&&(p=i+f-hi,k=p),h=h==0?u:h,e=e==0?f:e,document.getElementById(wt).style.clip="rect("+k.toString()+"px,"+h.toString()+"px,"+e.toString()+"px,"+v+"px)")},TransformToVisibleAnnotation:function(n,t,i,r,u){i=n._valueType=="logarithmic"&&i>0?Math.log(i,n.logBase):i;r=n._valueType=="logarithmic"&&r>0?Math.log(r,t.logBase):r;var f=u.model.Radius*ej.EjSvgRender.utils._valueToCoefficient(t,r,this),e=ej.EjSvgRender.utils._valueToVector(n,i);return{X:u.model.centerX+f*e.X,Y:u.model.centerY+f*e.Y}},_getAnnotationPoint:function(n,t,i){var o=this.model.requireInvertedAxes,r=n.x,u=n.y,f=t._valueType=="logarithmic"?ej.EjSvgRender.utils._logBase(r==0?1:r,t.logBase):r,e=i._valueType=="logarithmic"?ej.EjSvgRender.utils._logBase(u==0?1:u,t.logBase):u;return f=ej.EjSvgRender.utils._getPointXY(f,t.visibleRange,t.isInversed)*t.width,e=(1-ej.EjSvgRender.utils._getPointXY(e,i.visibleRange,i.isInversed))*i.height,n.location={X:f,Y:e},n.location},indicatorRender:function(){var e,i,n,r,o,u,t,s,f,h;for($(this.svgObject).find("#"+this.svgObject.id+"_IndicatorCollection").length>0&&$(this.svgObject).find("#"+this.svgObject.id+"_IndicatorCollection").remove(),e={id:this.svgObject.id+"_IndicatorCollection","clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)"},this.gIndicatorEle=this.svgRenderer.createGroup(e),i=0;i<this.model.indicators.length&&this.model.indicators[i].visible&&this.model.indicators[i]._points.length>0;i++){for(n=this.model.indicators[i],o=n.animationDuration,u=0;u<this.model._axes.length;u++)t=this.model._axes[u],t.name&&t.orientation.toLowerCase()=="horizontal"&&t.name.toLowerCase()==n.xAxisName.toLowerCase()?n.xAxis=t:t.name&&t.orientation.toLowerCase()=="vertical"&&t.name.toLowerCase()==n.yAxisName.toLowerCase()&&(n.yAxis=t);s=n.type.toLowerCase();r=new ej.indicatorTypes[s];this.model.enableCanvasRendering?(this.svgRenderer.ctx.save(),this.svgRenderer.ctx.beginPath(),this.svgRenderer.ctx.rect(this.model.m_AreaBounds.X,n.yAxis.y,n.xAxis.width,n.yAxis.height),this.svgRenderer.ctx.clip(),r.draw(n,this),this.svgRenderer.ctx.restore()):r.draw(n,this);f=r.gIndicatorGroupEle;f&&ej.EjSvgRender.utils._drawAxesBoundsClipPath(f,n,this);this.vmlRendering||this.model.enableCanvasRendering||n.enableAnimation&&(!n._animatedSeries||n.type!=n._previousType)&&(this.svgRenderer.append(this.gIndicatorEle,this.svgObject),h=$(this.gIndicatorEle).find("#"+this.svgObject.id+"_indicatorGroup_"+i+"_ClipRect").children(),ej.EjSeriesRender.prototype._doLineAnimation(this,h,o),this.model.AnimationComplete=!0,n._animatedSeries=!0,n._previousType=n.type);this.svgRenderer.append(this.gIndicatorEle,this.svgObject)}},doAnimation:function(n){var i=this,yt=i.model,f=yt.requireInvertedAxes,ot=n.type.toLowerCase(),l=$.inArray(n,yt._visibleSeries),a=this.svgObject.id+"_SeriesGroup_"+l,g=$(i.gSymbolGroupEle)[l].childNodes,nt=g.length,st=$(i.gDataLabelEle)[l].childNodes,tt=st.length,ht=$(i.gConnectorEle)[l].childNodes,ct=ht.length,lt=$(i.gErrorBarGroupEle)[l]==undefined?undefined:$(i.gErrorBarGroupEle)[l].childNodes,pt=ej.util.isNullOrUndefined(lt)?0:lt.length,s=n._animationType,it,rt,at,ut,ft,b,c,o,k,w,et,wt=0,bt,v,e,h,y,d,vt,u=ej.EjSeriesRender.prototype,p,r,t;i.gSeriesGroupEle=$("#"+a)[0];vt=i.model.series[l].animationDuration;ej.util.isNullOrUndefined(vt)?(e=2e3,h=200,y=500,d=1e3):(e=y=d=parseFloat(vt),h=e/10);switch(s){case"rect":if(o=$(this.gSeriesEle).find("#"+a).children("rect"),k=o.length,w=$(i.gSeriesEle).find("#"+a+"_ClipRect").children(),ot=="boxandwhisker"){for(at=$(this.gSeriesEle).find("#"+a).children("line"),ut=$(this.gSeriesEle).find("#"+a).children("path"),rt=e/ut.length,p=0;p<at.length;p++)u._doLineSymbol(at[p],rt,p,n,f,i,h),u._doLineSymbol(o[p],rt,p,n,f,i,h);for(r=0;r<ut.length;r++)u._doLineSymbol(ut[r],rt,r,n,f,i,h)}else if(!ot.indexOf("stacking")>-1&&n.animationType.toLowerCase()=="smooth")u.animateRect(w,n,f,i,d);else for(t=0;t<k;t++)ot.indexOf("stacking")>-1?u.animateStackingRect(o[t],n,f,i,d):u.animateRect(o[t],n,f,i,d);ft=b=it=e/4;break;case"path":w=$(i.gSeriesEle).find("#"+a+"_ClipRect").children();u._doLineAnimation(i,w,e);ft=e/nt;b=e/tt;it=e/pt;break;case"scatter":for(t=0;t<nt;t++)bt=Math.floor(Math.random()*(20-wt)+wt),v=parseInt(bt*50),u.animateSymbol(g[t],v,n,f,i,y);break;case"bubble":for(o=$(this.gSeriesGroupEle).children().not("defs"),v=0,t=0;t<o.length;t++)u.animateSymbol(o[t],v,n,f,i,y);for(t=0;t<nt;t++)u.animateSymbol(g[t],v,n,f,i,y);for(t=0;t<tt;t++)u.animateSymbol(st[t],v,n,f,i,y);for(t=0;t<ct;t++)u.animateSymbol(ht[t],v,n,f,i,y);break;case"hilo":for(o=$(this.gSeriesGroupEle).children().not("defs"),k=o.length,et=e/k,t=0;t<k;t++)u._doLineSymbol(o[t],et,t,n,f,i,h);b=e/tt;break;case"cylinder":w=$(i.gSeriesEle).find("#"+a+"_ClipRect").children();u.animateCylinder(i,n,f,w,e);ft=b=it=e/4}if(s!="bubble"){for(r=0;r<nt;r++)c=s=="rect"||s=="stackingRect"?2:r,u._doLineSymbol(g[r],ft,c,n,f,i,h);for(r=0;r<tt;r++)c=s=="rect"||s=="stackingRect"?2:r,u._doLineSymbol(st[r],b,c,n,f,i,h);for(et=e/ct,r=0;r<ct;r++)c=s=="rect"||s=="stackingRect"?2:r,u._doLineSymbol(ht[r],et,c,n,f,i,h)}if(n.errorBar.visibility=="visible")for(r=0;r<pt;r++)c=s=="rect"||s=="stackingRect"?2:r,u._doLineSymbol(lt[r],it,c,n,f,i,h)},_animationElements:function(n,t,i){var r=this,e=r.model.series[i].animationDuration,o=ej.util.isNullOrUndefined(e)?2e3:parseFloat(e),f,u;if(n._previousType=ej.util.isNullOrUndefined(n._previousType)?n.type:n._previousType,!n.enableAnimation||this.vmlRendering||this.model.enableCanvasRendering||n._animatedSeries&&n.type==n._previousType||(ej.EjSeriesRender.prototype.doCircularAnimation(this,n,t,i,o),n._previousType=n.type,n._animatedSeries=r.isSplitted?!1:!0),r.isSplitted=!1,this.drawAccDisplayText(t,n,i),n.enableAnimation&&n._visiblePoints.length>0&&n.AnimationComplete&&!this.vmlRendering&&!this.model.enableCanvasRendering){if(r.svgRenderer._setAttr($(r.gSeriesEle).find("#"+r.gSeriesTextEle[i].id),{visibility:"visible"}),r.gSymbolGroupEle&&r.svgRenderer._setAttr($(r.gSeriesEle).find("#"+r.gSymbolGroupEle[i].id),{visibility:"visible"}),n.marker.dataLabel.template)for(f=$(r.element[0].childNodes[0].childNodes),u=0;u<f.length;u++)$(f[u]).css("display","block");r.gConnectorEle&&r.svgRenderer._setAttr($(r.gSeriesEle).find("#"+r.gConnectorEle[i].id),{visibility:"visible"});r.gDataLabelEle&&r.svgRenderer._setAttr($(r.gSeriesEle).find("#"+r.gDataLabelEle[i].id),{visibility:"visible"})}},_appendConnectorElements:function(n){var i=ej.DataManager(this.model._visibleSeries,ej.Query().sortBy("_zOrder")).executeLocal(),t=i[n],r=t.type.toLowerCase();t.visibility=="visible"&&!this.model.enable3D&&t.connectorLine&&(t.connectorLines||this.model.AreaType=="none")&&(this.svgRenderer.append(this.gConnectorEle[n],this.gSeriesEle),t.connectorLines=!1)},_appendDataLabelElement:function(n){var t,i;t=this.model._visibleSeries[n];i=ej.util.isNullOrUndefined(t.zOrder)?i:t.zOrder;t.visibility!="visible"||this.model.enable3D||(this.svgRenderer.append(this.gSymbolGroupEle[n],this.gSeriesEle),this.model.enable3D||this.model.enableCanvasRendering||(this.gDataLabelEle[n].childNodes.length>0&&this.svgRenderer.append(this.gDataLabelEle[n],this.gSeriesEle),this.gSeriesTextEle[n].childNodes.length>0&&this.svgRenderer.append(this.gSeriesTextEle[n],this.gSeriesEle)));this.vmlRendering||t.visibility!="visible"||this.model.enableCanvasRendering||this.model.enable3D||(this.svgRenderer.append(this.gSeriesEle,this.svgObject),this.svgRenderer.append(this.svgObject,this.element))},_accSeriesDraw:function(n,t,i){var e=this,r=ej.DataManager(this.model._visibleSeries,ej.Query().sortBy("_zOrder")).executeLocal(),o=$.inArray(r[n],this.model._visibleSeries),u,f,s;this.model._visibleSeries[o]=r[n]=$.extend(!0,t,r[n]);u=$.extend({},ej.EjSvgRender.commonChartEventArgs);u.data={series:t};this._trigger("seriesRendering",u);f=new ej.seriesTypes[i.toLowerCase()];s=f.draw(e,t);s||(this.model.minhightwidth=!0,e._animationElements(t,f,o))},_splitSeries:function(n){var t=[],e,i,h,r,w;t[0]=$.extend(!0,[],n._visiblePoints);t[1]=[];for(var f=n,l=parseInt(f.splitValue),s=f.splitMode.toLowerCase(),a=t[0].length,u=0,o=0,v=[],r=0,y=0,p,c;r!=a;)y+=t[0][r].y,r++;if(s=="position"){for(r=a-1;r>=0&&o!=l;r--)u=u+t[0][r].y,t[1][o]=t[0][r],o++,t[0].splice(r,1);t[1].reverse()}else if(s=="value"||s=="percentage")for(i=0;i<t[0].length;i++)p=s=="value"?t[0][i].y:Math.round(t[0][i].y/y*100),p<l&&(u=u+t[0][i].y,t[1][o]=t[0][i],o++,t[0].splice(i,1),i=-1);else if(s=="indexes"){for(e=JSON.parse("["+f.splitValue+"]"),e=e.filter(function(n,t,i){return i.indexOf(n)==t}),e.sort(),i=0;i<t[0].length;i++)for(h=0;h<e.length;h++)i==e[h]&&(u=u+t[0][i].y,t[1][o]=t[0][i],o++);for(r=0;r<e.length;r++)w=e[r]-r,t[0].splice(w,1)}t[1].length>0&&(v[0]=u,c=f._xAxisValueType,t[0].unshift({_visibility:"visible",visible:!0,text:"Others",x:c=="string"?"Others":u,xValue:c=="string"?f.points.length:u,y:u,YValues:v,fill:this.model.colors[(f.points.length+1)%this.model.colors.length],isFill:!1,actualIndex:f.points.length}));this.isSplitted=!0;f.pieCollections=t},_calculateGapWidth:function(n){var o=0,s=0,r,u,h,c=.1*Math.min($(this.svgObject).width(),$(this.svgObject).width()),t,i,f,e;for(ej.EjSeriesRender.prototype._calculateVisiblePoints(n).visiblePoints,this._splitSeries(n),this.chartObj=this,t=0;t<2;t++)r=t==0?n.pieCoefficient:n.pieOfPieCoefficient,n._visiblePoints=n.pieCollections[t],n.collectionIndex=t,h=n.gapWidth,i=ej.EjSeriesRender.prototype.calculatingSliceAngle(n,this.chartObj),f=i.width<c?.25*r*c:.25*r*Math.min(i.width,i.height),u=this.model.circleCenterX[t],t==0?o=u+f:s=u-f;return e=s-o-h,this.model.pieGapWidth=e>0?e:0,n.pieCollections[0].length>0&&n.pieCollections[1].length>0&&n.connectorLine.width>0&&this.drawPieofPieConnectors(i,n),n},seriesRender:function(n,t){var w,vt,st,u,f;if(this.model.allPoints=[],this.model.markerRegion=[],this.model.startX=[],this.model.startY=[],this.model.centerCount=0,this.gTrendlinesGroupEle=null,this.model._seriesIndex=null,this.model._previousSeries=null,!n)for(n={_crossAxisOverlap:!1,axes:{}},u=0;u<this.model._axes.length;u++)n.axes[this.model._axes[u].name]={};$(this.svgObject).find("#"+this.svgObject.id+"_SeriesCollection").length>0&&$(this.svgObject).find("#"+this.svgObject.id+"_SeriesCollection").remove();var k=this,c=this.svgObject,gi={id:c.id+"_SeriesCollection","clip-path":"url(#"+c.id+"_ChartAreaClipRect)"},rt=this.model.enable3D,p=this.model.AreaType,d=this.model.enableCanvasRendering,nr=this.model._axes.length,h=ej.DataManager(this.model._visibleSeries,ej.Query().sortBy("_zOrder")).executeLocal(),g=h.length,u,y,v,ht,ft,l,ut,e,bt,r,i,ct,nt,si=d,o=this.svgRenderer,kt=this.model.m_AreaBounds,dt,gt,hi,et=kt.X,f,a,ci,yt,tt,b,ot,lt,li,ni,ai,vi,yi,it,pi,s,ti,wi,at,ii,pt,ri,bi,ki,ui,wt,vt,di,fi,ei,oi,tr=this.zoomed;for(this.gSeriesEle=o.createGroup(gi),u=0;u<g;u++)if(h[u].visibility=="visible")for(this.model.series[u]._enableSmartLabels=ej.util.isNullOrUndefined(this.model.series[u].enableSmartLabels)?p=="none"?!0:!1:this.model.series[u].enableSmartLabels,ej.util.isNullOrUndefined(h[u].xAxis)||(h[u].xAxis=null,h[u].yAxis=null),y=0;y<nr;y++)v=this.model._axes[y],ft=u,ht=v.orientation.toLowerCase(),v.name&&ht=="horizontal"&&v.name.toLowerCase()==h[u]._xAxisName.toLowerCase()?h[u].xAxis=v:v.name&&ht=="vertical"&&v.name.toLowerCase()==h[u]._yAxisName.toLowerCase()&&(h[u].yAxis=v),this.model.requireInvertedAxes&&(v.name&&ht=="vertical"&&v.name.toLowerCase()==h[u]._xAxisName.toLowerCase()?h[u].xAxis=v:v.name&&ht=="horizontal"&&v.name.toLowerCase()==h[u]._yAxisName.toLowerCase()&&(h[u].yAxis=v));if(g>0)if(r=h[0],ui=r.type.toLowerCase(),di=r.visibility.toLowerCase(),ui!="pieofpie"||di!="visible"||rt)for(vt=g;vt>0&&p=="none";vt--)ft=vt-1,l=h[vt-1],ut=l.visibility.toLowerCase(),e=l.type.toLowerCase(),ut!=="visible"||rt||e!="pie"&&e!="doughnut"?p!="none"||ut!=="visible"||d||ej.Ej3DChart.prototype.renderSeries(this,l,t):this._accSeriesDraw(ft,l,e);else{for(this.model._isPieOfPie=!0,r=this._calculateGapWidth(r),w=0;w<2;w++)r.collectionIndex=w,r._visiblePoints=r.pieCollections[w],this._accSeriesDraw(0,r,ui);r._visiblePoints=$.merge(r.pieCollections[0],r.pieCollections[1]);this.model.pieGapWidth=null;r.collectionIndex=0}for(st=0;st<g;st++)if(ft=st,l=h[st],ut=l.visibility.toLowerCase(),e=l.type.toLowerCase(),p!="none"||ut!=="visible"||rt||ft!==0||e!="pyramid"&&e!="funnel"){if(ut!=="visible"||rt||p=="none"?rt||p=="none"?p!="cartesianaxes"||ut!=="visible"||d||ej.Ej3DChart.prototype.renderSeries(this,l,n,t):o.append(c,this.element):(this.model._seriesIndex=ej.util.isNullOrUndefined(this.model._seriesIndex)?0:this.model._seriesIndex+1,this.renderSeries(l,n,t),p=="cartesianaxes"&&this.model.series[st].type!="boxandwhisker"&&this._renderTrendline(k,l)),!ej.util.isNullOrUndefined(l.xAxis)&&l.xAxis._valueType=="datetime")for(u=0;u<l.points.length;u++)l.points[u].xValue instanceof Date==!1&&(l.points[u].xValue=new Date(l.points[u].xValue))}else this._accSeriesDraw(ft,l,e);if(p!="none"){for(u=0;u<g;u++)if(r=this.model.series[u],ct=r._visiblePoints,r._enableSmartLabels&&this.model.AreaType=="cartesianaxes")for(nt=r.type.toLowerCase(),nt=="column"||nt=="stackingcolumn"||nt=="bar"||nt=="stackingbar"||nt=="waterfall"||nt=="stackingbar100"||nt=="stackingcolumn100"||nt=="rangecolumn"?this.cartesianColumnSmartLabels(r,ct,u):nt!="boxandwhisker"&&this.cartesianSmartLabels(r,ct,u),y=0;y<ct.length;y++)i=ct[y],i.hide=ej.util.isNullOrUndefined(i.hide)?!1:i.hide,dt=si?i.xPos-this.canvasX:i.xPos,gt=si?i.yPos-this.canvasY:i.yPos,fi=r.xAxis.visibleRange,ei=r.yAxis.visibleRange,oi=e.indexOf("100")!=-1?parseFloat(i.percentage):i.y,(dt-i.width/2<0||dt+i.width/2>kt.Width||gt+i.height/2>kt.Height||gt-i.height/2<0||tr&&(i.xValue<=fi.min||i.xValue>=fi.max)||oi<=ei.min||oi>=ei.max)&&(i.hide=r.marker.dataLabel.showEdgeLabels&&!i.hide?!1:!0);for(u=0;u<g;u++)if(r=h[u],wt=r._dataLabels?r.marker.dataLabel.visible||r._dataLabels>0:!0,r.visibility=="visible"&&wt)for(yt=r._visiblePoints.length,a=0;a<yt;a++)i=r._visiblePoints[a],ci=i.marker&&i.marker.dataLabel&&i.marker.dataLabel.visible,(r.marker.dataLabel.visible||ci)&&(!(i.connectorFlag||i.newConnectorFlag)||i.hide||i.drawText==""||r.visibility!="visible"||ej.util.isNullOrUndefined(i.textOptions)||(r.connectorLine=!0,d?(o.ctx.save(),k.model.requireInvertedAxes?o.ctx.rect(et+r.yAxis.plotOffset,r.xAxis.y,r.yAxis.width,r.xAxis.height):o.ctx.rect(et,r.yAxis.y,r.xAxis.width,r.yAxis.height),o.ctx.clip(),this.drawConnectorLines(u,a,i),o.ctx.restore()):r._enableSmartLabels&&this.drawConnectorLines(u,a,i)),i.newConnectorFlag=!1);for(u=0;u<g;u++)if(r=h[u],e=r.type.toLowerCase(),wt=r._dataLabels?r.marker.dataLabel.visible||r._dataLabels>0:!0,r.visibility=="visible"&&wt&&!this.model.enable3D)for(yt=r._visiblePoints.length,a=0;a<yt;a++)if(i=r._visiblePoints[a],hi=i.marker&&i.marker.dataLabel&&i.marker.dataLabel.visible,(r.marker.dataLabel.visible||hi)&&!i.hide&&!i.dataLabeltemplate&&r.visibility=="visible"&&!ej.util.isNullOrUndefined(i.textOptions)&&!i.hide){if(ej.util.isNullOrUndefined(i.textOptions.angle)||(i.textOptions.transform="rotate("+i.textOptions.angle+","+i.xPos+","+i.yPos+")"),d){if(i.textOptions.labelRotation=i.textOptions.angle,o.ctx.save(),k.model.requireInvertedAxes?k.svgRenderer.ctx.rect(et+r.yAxis.plotOffset,r.xAxis.y,r.yAxis.width,r.xAxis.height):o.ctx.rect(et,r.yAxis.y,r.xAxis.width,r.yAxis.height),k.svgRenderer.ctx.save(),k.svgRenderer.ctx.clip(),e.toLowerCase()=="boxandwhisker")for(r.showMedian==!0&&i.textOptionsBoxValues!=""&&(ej.util.isNullOrUndefined(i.textOptionsBoxValues[0].angle)||(i.textOptionsBoxValues[0].labelRotation=i.textOptionsBoxValues[0].angle,i.textOptionsBoxValues[0].transform="rotate("+i.textOptionsBoxValues[0].angle+","+i.textOptionsBoxValues[0].xPos+","+i.textOptionsBoxValues[0].yPos+")"),ej.EjSeriesRender.prototype.dataLabelSymbol(u,r,a,i.textOptionsBoxValues[0].xPos,i.textOptionsBoxValues[0].yPos,i.textOptionsBoxValues[0].width,i.textOptionsBoxValues[0].height,i.textOptionsBoxValues[0].symbolName,this),delete i.textOptionsBoxValues[0].angle,this.svgRenderer.drawText(i.textOptionsBoxValues[0],i.textOptionsBoxValues[0].drawText,this.gSeriesTextEle[u])),f=1;f<i.textOptionsBoxValues.length;f++)ej.util.isNullOrUndefined(i.textOptionsBoxValues[f].angle)||(i.textOptionsBoxValues[f].labelRotation=i.textOptionsBoxValues[f].angle,i.textOptionsBoxValues[f].transform="rotate("+i.textOptionsBoxValues[f].angle+","+i.textOptionsBoxValues[f].xPos+","+i.textOptionsBoxValues[f].yPos+")"),ej.EjSeriesRender.prototype.dataLabelSymbol(u,r,a,i.textOptionsBoxValues[f].xPos,i.textOptionsBoxValues[f].yPos,i.textOptionsBoxValues[f].width,i.textOptionsBoxValues[f].height,i.textOptionsBoxValues[f].symbolName,this),delete i.textOptionsBoxValues[f].angle,this.svgRenderer.drawText(i.textOptionsBoxValues[f],i.textOptionsBoxValues[f].drawText,this.gSeriesTextEle[u]);else ej.EjSeriesRender.prototype.dataLabelSymbol(u,r,a,i.xPos,i.yPos,i.width,i.height,i.symbolName,this),delete i.textOptions.angle,this.svgRenderer.drawText(i.textOptions,i.drawText,this.gSeriesTextEle);k.svgRenderer.ctx.restore()}else ej.EjSeriesRender.prototype.dataLabelSymbol(u,r,a,i.xPos,i.yPos,i.width,i.height,i.symbolName,this,this.gDataLabelEle[u]),delete i.textOptions.angle,o.drawText(i.textOptions,i.drawText,this.gSeriesTextEle[u]);if(e=="rangecolumn"||e=="rangearea"||e=="splinerangearea")i.textOptionsLow.transform="rotate("+i.textOptionsLow.angle+","+i.xPosLow+","+i.yPosLow+")",d?(i.textOptionsLow.labelRotation=i.textOptionsLow.angle,o.ctx.save(),k.model.requireInvertedAxes?o.ctx.rect(et+r.yAxis.plotOffset,r.xAxis.y,r.yAxis.width,r.xAxis.height):o.ctx.rect(et,r.yAxis.y,r.xAxis.width,r.yAxis.height),o.ctx.clip(),ej.EjSeriesRender.prototype.dataLabelSymbol(u,r,a,i.xPosLow,i.yPosLow,i.widthLow,i.heightLow,i.symbolName,this),delete i.textOptionsLow.angle,o.drawText(i.textOptionsLow,i.drawTextLow,this.gSeriesTextEle),o.ctx.restore()):(ej.EjSeriesRender.prototype.dataLabelSymbol(u,r,a,i.xPosLow,i.yPosLow,i.widthLow,i.heightLow,i.symbolName,this,this.gDataLabelEle[u]),delete i.textOptionsLow.angle,o.drawText(i.textOptionsLow,i.drawTextLow,this.gSeriesTextEle[u]));else if(e.toLowerCase()=="boxandwhisker")for(r.showMedian==!0&&i.textOptionsBoxValues!=""&&(ej.util.isNullOrUndefined(i.textOptionsBoxValues[0].angle)||(i.textOptionsBoxValues[0].transform="rotate("+i.textOptionsBoxValues[0].angle+","+i.textOptionsBoxValues[0].xPos+","+i.textOptionsBoxValues[0].yPos+")"),ej.EjSeriesRender.prototype.dataLabelSymbol(u,r,a,i.textOptionsBoxValues[0].xPos,i.textOptionsBoxValues[0].yPos,i.textOptionsBoxValues[0].width,i.textOptionsBoxValues[0].height,i.textOptionsBoxValues[0].symbolName,this),delete i.textOptionsBoxValues[0].angle,this.svgRenderer.drawText(i.textOptionsBoxValues[0],i.textOptionsBoxValues[0].drawText,this.gSeriesTextEle[u])),f=1;f<i.textOptionsBoxValues.length;f++)ej.util.isNullOrUndefined(i.textOptionsBoxValues[f].angle)||(i.textOptionsBoxValues[f].transform="rotate("+i.textOptionsBoxValues[f].angle+","+i.textOptionsBoxValues[f].xPos+","+i.textOptionsBoxValues[f].yPos+")"),ej.EjSeriesRender.prototype.dataLabelSymbol(u,r,a,i.textOptionsBoxValues[f].xPos,i.textOptionsBoxValues[f].yPos,i.textOptionsBoxValues[f].width,i.textOptionsBoxValues[f].height,i.textOptionsBoxValues[f].symbolName,this),delete i.textOptionsBoxValues[f].angle,this.svgRenderer.drawText(i.textOptionsBoxValues[f],i.textOptionsBoxValues[f].drawText,this.gSeriesTextEle[u])}if(p!="none"){for(u=0;u<g;u++)this._appendConnectorElements(u);for(b=this.model._visibleSeries.length,u=0;u<b;u++)this._appendDataLabelElement(u)}}else{for(tt=g-1;tt>=0;tt--)r=this.model._visibleSeries[tt],e=r.type.toLowerCase(),(e=="pie"||e=="doughnut")&&this.model.minhightwidth&&this._appendConnectorElements(tt);if(b=this.model._visibleSeries.length,b>0&&e=="pieofpie")this._appendDataLabelElement(0);else for(tt=g-1;tt>=0;tt--)r=this.model._visibleSeries[tt],e=r.type.toLowerCase(),(e=="pie"||e=="doughnut")&&this.model.minhightwidth&&this._appendDataLabelElement(tt)}for(b=this.model._visibleSeries.length,ot=0;ot<b;ot++)s=this.model._visibleSeries[ot],vi=s.drawType,e=s.type.toLowerCase(),s._previousType=ej.util.isNullOrUndefined(s._previousType)?s.type:s._previousType,this.vmlRendering||s.visibility!="visible"||d||rt||p=="none"||(this.renderer.append(this.gSeriesEle,this.svgObject),this.renderer.append(this.svgObject,this.element),lt=new ej.seriesTypes[s.type.toLowerCase()],lt.chartObj=k,lt.gSeriesGroupEle=vi=="scatter"?$("#"+this.svgObject.id+"_symbolGroup_"+ot)[0]:$("#"+this.svgObject.id+"_SeriesGroup_"+ot)[0],s.enableAnimation&&(!s._animatedSeries||s._previousType!=s.type)&&this.model.AreaType!="none"&&(s._animatedSeries=!0,s._previousType=s.type,li=$("#template_group_"+this._id),ni=s.marker.dataLabel,li.children().length!=0&&ni.visible&&ni.template&&lt.animateLabelTemplate(s),e=="polar"||e=="radar"?ej.ejRadarSeries.prototype.doAnimation(s,lt):this.doAnimation(s)));if(h=this.model._visibleSeries,b=h.length,!d&&!rt)for(w=0;w<b;w++)h[w].visibility.toLowerCase()=="visible"&&this.gTrendlinesGroupEle&&this.gTrendlinesGroupEle[w]&&this.gTrendlinesGroupEle[w].childElementCount!=0&&this.renderer.append(this.gTrendlinesGroupEle[w],c);for(u=0;u<b;u++)for(r=this.model._visibleSeries[u],yi=r.trendlines,ti=r.trendlines.length,wi=r.animationDuration,y=0;y<ti;y++)it=yi[y],it.visibility&&(pi=it.type.toLowerCase(),s=new ej.trendlineTypes[pi],it.visibility.toLowerCase()==="visible"&&it.points&&it.points.length>1&&r.enableAnimation&&!this.vmlRendering&&(!r._animatedTrendline||it._previousType!=it.type)&&(it._previousType=it.type,ai=$(this.svgObject).find("#"+this.svgObject.id+"_TrendGroup_"+u+"_"+y+"_ClipRect").children(),ej.EjSeriesRender.prototype._doLineAnimation(this,ai,wi),r._animatedTrendline=ti-1==u?!0:!1));for(b=this.model._visibleSeries.length,pt=c.id,u=0;u<b;u++)at=$("#"+pt+"_SeriesGroup_"+u),ri=$("#"+pt+"_SeriesGroup_waterfallLine_"+u),ii=$("#"+pt+"_symbolGroup_"+u),at.length>0&&ii.length>0&&ii.insertAfter(at),at.length>0&&ri.length>0&&ri.insertAfter(at);this.model.AnimationComplete=!0;bt=$.extend({},ej.EjSvgRender.commonChartEventArgs);bt.data={series:s};this._trigger("animationComplete",bt);d&&(o.append(c,this.element),this.panning&&$("#"+this._id+"_canvas").css({cursor:"pointer"}));rt&&!d&&(o.append(this.chart3D,c),bi={Width:$(c).width(),Height:$(c).height()},this.graphics.prepareView(this.model.perspectiveAngle,this.model.depth,this.model.rotation,this.model.tilt,bi,this),this.graphics.view(c,this),o.append(c,this.element));o.vmlNamespace&&o.append(this.gSeriesEle,c);p=="polaraxes"&&o.append(this.gPolarAxisEle,c);$(c).find("#"+c.id+"_StriplineOver").length>0&&(ki=$(c).find("#"+c.id+"_StriplineOver").detach(),ki.appendTo(c));this._renderScrollbar();this.legendRender.drawLegend(n);k.model.initSeriesRender=!0},_calculateZoomValue:function(n,t,i,r){var l=this.model,o,s,h,u,f,e=i.scrollbarSettings.range,c=i._valueType.toLowerCase();c=="datetime"?(u=Date.parse(ej.util.isNullOrUndefined(e.min)?n:new Date(e.min)),f=Date.parse(ej.util.isNullOrUndefined(e.max)?t:new Date(e.max))):(u=parseFloat(ej.util.isNullOrUndefined(e.min)?n:e.min),f=parseFloat(ej.util.isNullOrUndefined(e.max)?t:e.max));u=Math.min(u,n);f=Math.max(f,t);o=f-u;r.isRTL?(s=(f-t)/o,h=(t-n)/o):(s=(n-u)/o,h=(t-n)/o);r.scrollRange={min:u,max:f,delta:f-u};r._previousStart=n;r._previousEnd=t;r.zoomPosition=s;r.zoomFactor=h},_renderScrollbar:function(){var r=this.model,k=r.scrollerSize,ut=$("#"+this._id).offset(),nt=$(this.svgObject).offset().left-ut.left,d,e,i,a,o,v,s,h,y,tt=r._axes,ft=tt.length,g,et=r.zooming.enableScrollbar,f,ot=r.AreaType,u,c,p,it,t,l,w,rt,n,b;for(r.scrollObj=r.scrollObj?r.scrollObj:[],n=0;n<ft;n++)i=tt[n],w=i._valueType,u=i.scrollbarSettings,f=u.range,g=i.isInversed,rt=ot=="cartesianaxes"&&!r.enable3D,y=i._opposed,c=u.pointsLength,l=i.orientation.toLowerCase(),s=i.zoomFactor,p=$("#scrollbar_"+this.axisScroll[0].id+n).length,h=i.zoomPosition,rt&&(i._isScroll&&r.isLazyZooming||(s<1||h>0)&&et)?(e=i.x+(l=="vertical"?-k+(y?k:0):0)+(nt<=0?0:nt),d=i.y+(l=="horizontal"?i.height+(y?-k:0):0),a=d-(l=="horizontal"?0:i.plotOffset),o=i.plotOffset+(l=="horizontal"?i.width:i.height),t=r.scrollObj,v=f.min!=null||f.max!=null?t[n]?t[n].actualRange.min!=f.min||t[n].actualRange.max!=f.max:!1:t[n]?t[n].actualRange!=u.pointsLength:!1,this.scrollDraw=t[n]?t[n].x!=e||t[n].y!=d||t[n].width!=o:this.scrollDraw,b={orientation:i.orientation,index:n,width:o,x:e,y:a,opposed:y,isRTL:g,parent:this.axisScroll,enableResize:u.canResize},r.isLazyZooming?(p==0||this.scrollDraw||v)&&($("#scrollbar_"+this.axisScroll[0].id+n).remove(),f.min!=null||f.max!=null?(it=t[n]&&t[n].scrollRange?t[n].scrollRange:i.visibleRange,!this.scrollDraw||v?(t[n]={isVirtual:!0,valueType:w,scrollRange:it},t[n].actualRange=$.extend(t[n].actualRange,u.range),$.extend(t[n],b),w=="datetime"?(t[n].startDateTime=new Date(i.visibleRange.min),t[n].endDateTime=new Date(i.visibleRange.max)):(t[n].startValue=i.visibleRange.min,t[n].endValue=i.visibleRange.max),this._calculateZoomValue(i.visibleRange.min,i.visibleRange.max,i,this.model.scrollObj[n])):(t[n].width=o,t[n].x=e,t[n].y=a)):c>=i.maxPointLength&&(s=i.maxPointLength/c,h=g?1-i.zoomPosition:i.zoomPosition,!this.scrollDraw||v?(t[n]={isVirtual:!0,zoomPosition:h,zoomFactor:s,scrollRange:{min:0,max:c-1,delta:c-1},valueType:"double"},t[n].actualRange=u.pointsLength,$.extend(t[n],b),t[n].startValue=0,t[n].endValue=i.maxPointLength):(t[n].width=o,t[n].x=e,t[n].y=a)),this.model.scrollObj[n]&&(this.scrollbarContainer=new ej.EjSvgScrollbarRender(this.axisScroll,this.model.scrollObj[n]),this.scrollbarContainer._initializeScrollbarVariables(this.model.scrollObj[n]),this.scrollbarContainer._renderScrollbar.call(this,this.model.scrollObj[n]))):u.visible&&(t=r.scrollObj,(p==0||this.scrollDraw)&&($("#scrollbar_"+this.axisScroll[0].id+n).remove(),t[n]={zoomPosition:h,zoomFactor:s,valueType:w,scrollRange:i.actualRange,isZooming:!0},$.extend(t[n],b),t[n].valueType=="datetime"?(t[n].startDateTime=new Date(t[n].scrollRange.min),t[n].endDateTime=new Date(t[n].scrollRange.max)):(t[n].startValue=t[n].scrollRange.min,t[n].endValue=t[n].scrollRange.max),this.scrollbarContainer=new ej.EjSvgScrollbarRender(this.axisScroll,this.model.scrollObj[n]),this.scrollbarContainer._initializeScrollbarVariables(this.model.scrollObj[n]),this.scrollbarContainer._renderScrollbar.call(this,this.model.scrollObj[n])))):p>0&&$("#scrollbar_"+this.axisScroll[0].id+n).remove();this.scrollDraw=!1},_renderTrendline:function(n,t){var f=$.inArray(t,n.model.series),g=n.model.requireInvertedAxes?t.yAxis.x:t.xAxis.x,nt=n.model.requireInvertedAxes?t.xAxis.y:t.yAxis.y,tt="translate("+g+","+nt+")",it={id:n.svgObject.id+"_TrendlinesGroup_"+f,"clip-path":"url(#"+n.svgObject.id+"_TrendlinesGroup_"+f+"_ClipRect)"},p=t.trendlines,e,c,l,w,a,i,u,o,s,h,r="",rt=p.length,b,v,y,k,d;for(n.gTrendlinesGroupEle||(n.gTrendlinesGroupEle=[]),n.gTrendlinesGroupEle[f]=n.svgRenderer.createGroup(it),u=0;u<rt;u++)if(i=p[u],i.seriesIndex=f,i.isTrendLine=!0,i.trendlineIndex=u,i.visibility.toLowerCase()==="visible"&&!i.isNull&&i.points){b={id:n.svgObject.id+"_TrendGroup_"+f+"_"+u,transform:tt,"clip-path":"url(#"+n.svgObject.id+"_TrendGroup_"+f+"_"+u+"_ClipRect)"};t.gTrendGroupEle=null;t.gTrendGroupEle=n.svgRenderer.createGroup(b);v=i.type.toLowerCase();a=new ej.trendlineTypes[v];o=i.slope;s=i._intercept;switch(v){case"linear":r="y = "+o.toFixed(4)+"x + "+s.toFixed(4);break;case"exponential":r="y = "+s.toFixed(3)+"e^"+o.toFixed(4)+"x";break;case"logarithmic":r="y = "+o.toFixed(3)+"ln(x) + "+s.toFixed(4);break;case"power":r="y = "+s.toFixed(3)+"x^"+o.toFixed(4);break;case"polynomial":for(l=i.polynomialSlopes,w=l.length,r="y = ",e=w-1;e>=0;e--)h=l[e],r+=h>0?"+"+h:"-"+Math.abs(h),e!=0&&(r+="x^"+e+" ")}i.equation=r;y=$.extend({},ej.EjSvgRender.commonChartEventArgs);k=i.points[0];d=i.points[i.points.length-1];y.data={series:t,trendline:i,forwardForecastPoints:d,backwardForecastPoints:k};this._trigger("trendlineRendering",y);n.model.enableCanvasRendering?(this.svgRenderer.ctx.save(),this.svgRenderer.ctx.beginPath(),this.svgRenderer.ctx.rect(n.model.m_AreaBounds.X,t.yAxis.y,t.xAxis.width,t.yAxis.height),this.svgRenderer.ctx.clip(),this.svgRenderer.ctx.beginPath(),a.draw(i,t,n),this.svgRenderer.ctx.restore()):(a.draw(i,t,n),c=t.gTrendGroupEle,c&&ej.EjSvgRender.utils._drawAxesBoundsClipPath(c,t,this))}},_renderStripline:function(n){var u,i,r,t;for($.extend(ej.EjStripline.prototype,this),this.chartstripline=new ej.EjStripline(this),u=this.chartstripline,this.model._stripeline=!1,i=0;i<this.model._axes.length;i++)for(r=this.model._axes[i],t=0;t<r.stripLine.length;t++)r.stripLine[t].zIndex.toLowerCase()==n&&u._drawStripline(r,r.stripLine[t],i,t);n=="over"&&this.model._stripeline?this.svgRenderer.append(this.gStriplineOver,this.svgObject):this.model._stripeline&&this.svgRenderer.append(this.gStriplineBehind,this.svgObject)},renderSeries:function(n,t,i){for(var y,d,g,nt,p,o,e,w,tt,u,ut=this,l,b=n.drawType,r=$.inArray(n,this.model._visibleSeries),s=0;s<n.points.length;s++)if(typeof n.points[s].x=="string"&&n.points[s].x.indexOf("/Date(")!=-1)n.points[s].x=new Date(parseInt(n.points[s].x.substr(6)));else break;n.xAxis=n.xAxis===null||n.xAxis===undefined?this.model._axes[0]:n.xAxis;n.yAxis=n.yAxis===null||n.yAxis===undefined?this.model._axes[1]:n.yAxis;var f=n.type.toLowerCase(),it=n.drawType.toLowerCase(),k,e=null,h;if(this.model.AreaType=="cartesianaxes"?(y=ej.EjSvgRender.utils._getTransform(n.xAxis,n.yAxis,this.model.requireInvertedAxes),e="translate("+y.x+","+y.y+")",h="visible"):h=n.enableAnimation&&!n._animatedSeries?"hidden":"visible",d={id:this.svgObject.id+"_TextGroup_"+r,transform:e,visibility:h},g={id:this.svgObject.id+"_DataLabel_"+r,transform:e,visibility:h},k=f!="scatter"?{id:this.svgObject.id+"_symbolGroup_"+r,transform:e,visibility:h}:{id:this.svgObject.id+"_SeriesGroup_"+r,transform:e},nt={id:this.svgObject.id+"_ConnectorGroup_"+r,transform:e,visibility:h},this.gSymbolGroupEle||(this.gSymbolGroupEle=[]),this.gSymbolGroupEle[r]=this.svgRenderer.createGroup(k),this.gSeriesTextEle||(this.gSeriesTextEle=[]),this.gSeriesTextEle[r]=this.svgRenderer.createGroup(d),this.gConnectorEle||(this.gConnectorEle=[]),this.gConnectorEle[r]=this.svgRenderer.createGroup(nt),this.gDataLabelEle||(this.gDataLabelEle=[]),this.gDataLabelEle[r]=this.svgRenderer.createGroup(g),p=$.extend({},ej.EjSvgRender.commonChartEventArgs),p.data={series:n},this._trigger("seriesRendering",p),o=new ej.seriesTypes[f],this.model.enableCanvasRendering&&this.model.AreaType!="none"?(this.svgRenderer.ctx.save(),this.svgRenderer.ctx.beginPath(),this.model.requireInvertedAxes?(e=ej.EjSvgRender.utils._getTransform(n.xAxis,n.yAxis,this.model.requireInvertedAxes),this.canvasX=e.x,this.canvasY=e.y,this.svgRenderer.ctx.rect(n.yAxis.x,n.xAxis.y,n.yAxis.width,n.xAxis.height)):(this.canvasX=n.xAxis.x,this.canvasY=n.yAxis.y,this.svgRenderer.ctx.rect(n.xAxis.x,n.yAxis.y,n.xAxis.width,n.yAxis.height)),this.svgRenderer.ctx.clip(),o.draw(this,n,t,i),this.svgRenderer.ctx.restore()):this.model.enableCanvasRendering&&this.model.AreaType=="polaraxes"?(this.svgRenderer.ctx.save(),this.svgRenderer.ctx.beginPath(),this.svgRenderer.ctx.arc(this.model.centerX,this.model.centerY,this.model.Radius,0,2*Math.PI,!1),this.svgRenderer.ctx.clip(),this.canvasX=this.canvasY=0,o.draw(this,n,i),this.svgRenderer.ctx.restore()):(this.canvasX=this.canvasY=0,this.model.AreaType=="cartesianaxes"?o.draw(this,n,t):this.model.AreaType=="polaraxes"&&n._xAxisName==this.model._axes[0].name&&n._yAxisName==this.model._axes[1].name&&o.draw(this,n,i)),w=this.model.series[r].errorBar,tt=this.model.AreaType,w.visibility=="visible"&&tt=="cartesianaxes"&&this.model.series[r].type!="boxandwhisker"&&this.renderErrorBar(w,n),f=="splinerangearea"&&(o.gSeriesGroupEle=this.gSeriesGroupEle),u=o.gSeriesGroupEle,u&&ej.EjSvgRender.utils._drawAxesBoundsClipPath(u,n,this),!(f=="candle"||f=="hilo"||f=="hiloopenclose"||f=="boxandwhisker")){var a=this,v,c=a.model.AreaType.toLowerCase(),rt=ej.seriesTypes[f].prototype.isRegion;l=n._pointMarker?n.marker.visible||n._pointMarker:!0;f=="scatter"||!l||$.each(n._visiblePoints,function(t,i){if(i.visible!==!1&&i.x!==""&&(i.marker&&i.marker.visible||n.marker.visible)){if(v=c=="polaraxes"&&it=="column"||rt?i.symbolLocation:c!="polaraxes"?ej.EjSvgRender.utils._getPoint(i,n):ej.EjSvgRender.utils.TransformToVisible(n,i.xValue,i.y,a),c=="polaraxes")var u=n.yAxis.labelFormat?n.yAxis.labelFormat:"",e=i.text?i.text:i.y+u.substring(u.indexOf("}")+1),s=ej.EjSvgRender.utils._measureText(e,null,n.marker.dataLabel.font);(c=="polaraxes"&&n._xAxisName==a.model._axes[0].name&&n._yAxisName==a.model._axes[1].name&&(f.toLowerCase()=="polar"||f.toLowerCase()=="radar")&&b!="scatter"||c=="cartesianaxes")&&o.drawSymbol(r,n,t,v.X,v.Y)}});f!="scatter"?(n.marker.visible&&b!="scatter"&&(u=this.gSymbolGroupEle[r],ej.EjSvgRender.utils._drawAxesBoundsClipPath(u,n,this)),n.marker.dataLabel.visible&&(u=this.gSeriesTextEle[r],ej.EjSvgRender.utils._drawAxesBoundsClipPath(u,n,this),u=this.gDataLabelEle[r],ej.EjSvgRender.utils._drawAxesBoundsClipPath(u,n,this)),!ej.util.isNullOrUndefined(this.gConnectorEle)&&this.gConnectorEle.length>0&&(u=this.gConnectorEle[r],ej.EjSvgRender.utils._drawAxesBoundsClipPath(u,n,this))):(u=this.gSymbolGroupEle[r],ej.EjSvgRender.utils._drawAxesBoundsClipPath(u,n,this),this.svgRenderer.append(u,this.gSeriesEle),(n.tooltip.visible||f=="scatter")&&(this.vmlRendering?(this.cloneSeriesEle=$(this.gSeriesEle).clone(),this.cloneobj=$(this.element).clone(),this.svgclone=$(this.svgObject).clone(),$(document.body).append(this.cloneobj),this.svgRenderer.append(this.cloneSeriesEle,this.svgclone),this.svgRenderer.append(this.svgclone,this.cloneobj)):(this.svgRenderer.append(this.gSeriesEle,this.svgObject),this.svgRenderer.append(this.svgObject,this.element)),this.vmlRendering&&($(this.cloneobj).remove(),$(this.svgclone).remove())))}l=n._dataLabels?n.marker.dataLabel.visible||n._dataLabels>0:!0;(n.marker.dataLabel.visible||l)&&this.drawDisplayText(o,n,t)},renderErrorBar:function(n,t){var s=this,wi=s.model,o=t,v,u,bi,fr,y,er,or,nu,vt=o._visiblePoints,ki=vt.length,pt=s.canvasX,wt=s.canvasY,dt=$.inArray(o,wi._visibleSeries),tu=null,ft,sr=ej.EjSvgRender.utils._getTransform(o.xAxis,o.yAxis,wi.requireInvertedAxes),bt,kt,d=wi.requireInvertedAxes,hr,cr,lr,ar,vr=s.svgObject.id,hi=s.model.m_AreaBounds,tu="translate("+sr.x+","+sr.y+")",ci,yr,p,pr,li,et,h,c,di,wr,a,i,r,f,e,yt,br,kr,ai,vi,ot,st,gt,ni,w,b,gi,nr,dr,gr,ti,ii,ri,ui,fi,ei,oi,si,rt,lt,k,ut,g,nt,tr,ir,l,tt,it,at,yi,pi,ht,ct,rr,ur;for(yr={id:vr+"_ErrorBarGroup_"+dt,transform:tu,"clip-path":"url(#"+vr+"_ChartAreaClipRect)"},ej.util.isNullOrUndefined(s.gErrorBarGroupEle)&&(s.gErrorBarGroupEle=[]),ci=s.gErrorBarGroupEle[dt]=s.svgRenderer.createGroup(yr),yi=$.extend({},ej.EjSvgRender.commonChartEventArgs),yi.data={errorBar:n},this._trigger("errorBarRendering",yi),p=yi.data.errorBar,v=p.type,u=p.mode,bi=p.direction,fr=p.fill,y=p.cap,er=p.cap.fill,or=p.cap.width,nu=p.cap.length,bt=p.verticalErrorValue,kt=p.horizontalErrorValue,hr=p.verticalPositiveErrorValue,cr=p.verticalNegativeErrorValue,lr=p.horizontalPositiveErrorValue,ar=p.horizontalNegativeErrorValue,ft=0;ft<ki;ft++)if(vt[ft].isEmpty!==!0&&vt[ft].visible==!0){pr={id:s.svgObject.id+"_ErrorBarGroup_"+dt+"_Point"+ft};pi=s.svgRenderer.createGroup(pr);li=ft;et=vt[ft];h=et.YValues[0];c=et.xValue;di=vt[ft].YValues[0];wr=vt[ft].xValue;a=v.indexOf("column")||v.indexOf("bar")>-1?et.symbolLocation:et.location;ej.util.isNullOrUndefined(a)&&(a=ej.EjSvgRender.utils._getPoint(et,o));ot=a.X;st=a.Y;switch(v){case"fixedValue":g=et;(u=="vertical"||u=="both")&&(g.YValues[0]=h+bt,i=ej.EjSvgRender.utils._getPoint(g,o),g.YValues[0]=h-bt,r=ej.EjSvgRender.utils._getPoint(g,o),d?i.Y=r.Y=a.Y:i.X=r.X=a.X);(u=="horizontal"||u=="both")&&(g.YValues[0]=h,g.xValue=c,g.xValue=c+kt,f=ej.EjSvgRender.utils._getPoint(g,o),g.xValue=c-kt,e=ej.EjSvgRender.utils._getPoint(g,o));g.YValues[0]=h;g.xValue=c;break;case"percentage":nt=et;tr=bt/100*h;ir=kt/100*c;(u=="vertical"||u=="both")&&(nt.YValues[0]=h+tr,i=ej.EjSvgRender.utils._getPoint(nt,o),nt.YValues[0]=h-tr,r=ej.EjSvgRender.utils._getPoint(nt,o),d?i.Y=r.Y=a.Y:i.X=r.X=a.X);(u=="horizontal"||u=="both")&&(nt.YValues[0]=h,nt.xValue=c,nt.xValue=c+ir,f=ej.EjSvgRender.utils._getPoint(nt,o),nt.xValue=c-ir,e=ej.EjSvgRender.utils._getPoint(nt,o));nt.YValues[0]=h;nt.xValue=c;break;case"standardDeviation":l=et;yt=s.meanCalculation(u,vt);br=yt.verMean;kr=yt.horMean;ai=yt.verStandSquareRoot;vi=yt.horStandSquareRoot;(u=="vertical"||u=="both")&&(gt=bt*ai,l.YValues[0]=br,w=ej.EjSvgRender.utils._getPoint(l,o),h=l.YValues[0],l.YValues[0]=h+gt,i=ej.EjSvgRender.utils._getPoint(l,o),l.YValues[0]=h-gt,r=ej.EjSvgRender.utils._getPoint(l,o),d?w.Y=i.Y=r.Y=a.Y:w.X=i.X=r.X=a.X,w.X=w.X+pt,w.Y=w.Y+wt);(u=="horizontal"||u=="both")&&(ni=kt*vi,l.xValue=kr,b=ej.EjSvgRender.utils._getPoint(l,o),d?b.X=a.X:b.Y=a.Y,l.YValues[0]=di,c=l.xValue,l.xValue=c+ni,f=ej.EjSvgRender.utils._getPoint(l,o),l.xValue=c-ni,e=ej.EjSvgRender.utils._getPoint(l,o),b.X=b.X+pt,b.Y=b.Y+wt);l.YValues[0]=di;l.xValue=wr;break;case"standardError":tt=et;yt=s.meanCalculation(u,vt);ai=yt.verStandSquareRoot;vi=yt.horStandSquareRoot;(u=="vertical"||u=="both")&&(gt=bt*ai,gi=gt/Math.sqrt(ki),tt.YValues[0]=h+gi,i=ej.EjSvgRender.utils._getPoint(tt,o),tt.YValues[0]=h-gi,r=ej.EjSvgRender.utils._getPoint(tt,o),d?i.Y=r.Y=a.Y:i.X=r.X=a.X);(u=="horizontal"||u=="both")&&(ni=kt*vi,nr=ni/Math.sqrt(ki),tt.YValues[0]=h,tt.xValue=c,tt.xValue=c+nr,f=ej.EjSvgRender.utils._getPoint(tt,o),tt.xValue=c-nr,e=ej.EjSvgRender.utils._getPoint(tt,o));tt.YValues[0]=h;tt.xValue=c;ft=li;break;case"custom":it=et;(u=="vertical"||u=="both")&&(it.YValues[0]=h+hr,i=ej.EjSvgRender.utils._getPoint(it,o),it.YValues[0]=h-cr,r=ej.EjSvgRender.utils._getPoint(it,o),d?i.Y=r.Y=a.Y:i.X=r.X=a.X);(u=="horizontal"||u=="both")&&(it.YValues[0]=h,it.xValue=c,it.xValue=c+lr,f=ej.EjSvgRender.utils._getPoint(it,o),it.xValue=c-ar,e=ej.EjSvgRender.utils._getPoint(it,o));it.YValues[0]=h;it.xValue=c}y.visible==!0&&((u=="vertical"||u=="both")&&(dr={verHighvalue:i,verLowvalue:r}),(u=="horizontal"||u=="both")&&(gr={horHighvalue:f,horLowvalue:e}),at=s.renderCap(y,u,dr,gr,d),ti=at.verHighCapX1,ii=at.verHighCapX2,ri=at.verLowCapX1,ui=at.verLowCapX2,fi=at.horHighCapY1,ei=at.horHighCapY2,oi=at.horLowCapY1,si=at.horLowCapY2);ot=ot+pt;st=st+wt;(u=="vertical"||u=="both")&&(i.X=i.X+pt,i.Y=i.Y+wt,r.X=r.X+pt,r.Y=r.Y+wt);(u=="horizontal"||u=="both")&&(f.X=f.X+pt,f.Y=f.Y+wt,e.X=e.X+pt,e.Y=e.Y+wt);bi=="both"?((u=="vertical"||u=="both")&&(v!="standardDeviation"?rt="M "+ot+" "+st+" L "+i.X+" "+i.Y+" M "+ot+" "+st+" L "+r.X+" "+r.Y+" ":v=="standardDeviation"&&(rt="M "+w.X+" "+w.Y+" L "+i.X+" "+i.Y+" M "+w.X+" "+w.Y+" L "+r.X+" "+r.Y+" "),lt=d?y.visible?"M "+i.X+" "+i.Y+" L "+i.X+" "+ti+" M "+i.X+" "+i.Y+" L "+i.X+" "+ii+" M "+r.X+" "+r.Y+" L "+r.X+" "+ri+" M "+r.X+" "+r.Y+" L "+r.X+" "+ui+" ":"":y.visible?"M "+i.X+" "+i.Y+" L "+ti+" "+i.Y+" M "+i.X+" "+i.Y+" L "+ii+" "+i.Y+" M "+r.X+" "+r.Y+" L "+ri+" "+r.Y+" M "+r.X+" "+r.Y+" L "+ui+" "+r.Y+" ":"",ht=rt,ct=lt),(u=="horizontal"||u=="both")&&(v!="standardDeviation"?k="M "+ot+" "+st+" L "+f.X+" "+f.Y+" M "+ot+" "+st+" L "+e.X+" "+e.Y+" ":v=="standardDeviation"&&(k="M "+b.X+" "+b.Y+" L "+f.X+" "+f.Y+" M "+b.X+" "+b.Y+" L "+e.X+" "+e.Y+" "),ut=d?y.visible?"M "+f.X+" "+f.Y+" L "+fi+" "+f.Y+" M "+f.X+" "+f.Y+" L "+ei+" "+f.Y+" M "+e.X+" "+e.Y+" L "+oi+" "+e.Y+" M "+e.X+" "+e.Y+" L "+si+" "+e.Y+" ":"":y.visible?"M "+f.X+" "+f.Y+" L "+f.X+" "+fi+" M "+f.X+" "+f.Y+" L "+f.X+" "+ei+" M "+e.X+" "+e.Y+" L "+e.X+" "+oi+" M "+e.X+" "+e.Y+" L "+e.X+" "+si+" ":"",ht=k,ct=ut),u=="both"&&(k+=rt,ut+=lt,ht=k,ct=ut)):bi=="plus"?((u=="vertical"||u=="both")&&(v!="standardDeviation"?rt="M "+ot+" "+st+" L "+i.X+" "+i.Y+" ":v=="standardDeviation"&&(rt="M "+w.X+" "+w.Y+" L "+i.X+" "+i.Y+" "),lt=d?y.visible?"M "+i.X+" "+i.Y+" L "+i.X+" "+ti+" M "+i.X+" "+i.Y+" L "+i.X+" "+ii+" ":"":y.visible?"M "+i.X+" "+i.Y+" L "+ti+" "+i.Y+" M "+i.X+" "+i.Y+" L "+ii+" "+i.Y+" ":"",ht=rt,ct=lt),(u=="horizontal"||u=="both")&&(v!="standardDeviation"?k="M "+ot+" "+st+" L "+f.X+" "+f.Y+" ":v=="standardDeviation"&&(k="M "+b.X+" "+b.Y+" L "+f.X+" "+f.Y+" "),ut=d?y.visible?"M "+f.X+" "+f.Y+" L "+fi+" "+f.Y+" M "+f.X+" "+f.Y+" L "+ei+" "+f.Y+" ":"":y.visible?"M "+f.X+" "+f.Y+" L "+f.X+" "+fi+" M "+f.X+" "+f.Y+" L "+f.X+" "+ei+" ":"",ht=k,ct=ut),u=="both"&&(k+=rt,ut+=lt,ht=k,ct=ut)):((u=="vertical"||u=="both")&&(v!="standardDeviation"?rt="M "+ot+" "+st+" L "+r.X+" "+r.Y+" ":v=="standardDeviation"&&(rt="M "+w.X+" "+w.Y+" L "+r.X+" "+r.Y+" "),lt=d?y.visible?"M "+r.X+" "+r.Y+" L "+r.X+" "+ri+" M "+r.X+" "+r.Y+" L "+r.X+" "+ui+" ":"":y.visible?"M "+r.X+" "+r.Y+" L "+ri+" "+r.Y+" M "+r.X+" "+r.Y+" L "+ui+" "+r.Y+" ":"",ht=rt,ct=lt),(u=="horizontal"||u=="both")&&(v!="standardDeviation"?k="M "+ot+" "+st+" L "+e.X+" "+e.Y+" ":v=="standardDeviation"&&(k="M "+b.X+" "+b.Y+" L "+e.X+" "+e.Y+" "),ut=d?y.visible?"M "+e.X+" "+e.Y+" L "+oi+" "+e.Y+" M "+e.X+" "+e.Y+" L "+si+" "+e.Y+" ":"":y.visible?"M "+e.X+" "+e.Y+" L "+e.X+" "+oi+" M "+e.X+" "+e.Y+" L "+e.X+" "+si+" ":"",ht=k,ct=ut),u=="both"&&(k+=rt,ut+=lt,ht=k,ct=ut));rr={id:s.svgObject.id+"_ErrorBar_"+dt+"_Point"+li,d:ht,stroke:fr,"stroke-width":n.width,opacity:n.opacity};ur={id:s.svgObject.id+"_ErrorBarCap_"+dt+"_Point"+li,d:ct,stroke:er,"stroke-width":or};s.model.enableCanvasRendering?(this.svgRenderer.ctx.rect(hi.X,hi.Y,hi.Width,hi.Height),this.svgRenderer.ctx.clip(),s.svgRenderer.drawPath(rr,null),s.svgRenderer.drawPath(ur,null)):(s.svgRenderer.drawPath(rr,pi),s.svgRenderer.drawPath(ur,pi),s.svgRenderer.append(pi,ci))}s.svgRenderer.append(ci,s.gSeriesEle);ej.EjSvgRender.utils._drawAxesBoundsClipPath(ci,o,s)},meanCalculation:function(n,t){for(var r=0,u=0,e,v,y,o,s,a,h,c,l,p,w,b,k,d,g,nt,tt,it,rt,f=t.length,i=0;i<f;i++)n=="vertical"?(e=r+t[i].y,r=e):n=="horizontal"?(e=u+t[i].xValue,u=e):(v=r+t[i].y,r=v,y=u+t[i].xValue,u=y);for(o=r/f,s=u/f,a=f-1,i=0;i<f;i++)n=="vertical"?(h=t[i].y-o,c=Math.pow(h,2),l=r+c,r=l):n=="horizontal"?(h=t[i].xValue-s,c=Math.pow(h,2),l=u+c,u=l):(p=t[i].y-o,b=Math.pow(p,2),k=r+b,r=k,w=t[i].xValue-s,it=Math.pow(w,2),d=u+it,u=d);return g=r/a,tt=Math.sqrt(g),nt=u/a,rt=Math.sqrt(nt),{verStandSquareRoot:tt,horStandSquareRoot:rt,verMean:o,horMean:s}},renderCap:function(n,t,i,r,u){var e,o,f,s,h,c,l,a,v,y,p,w,b,k,d;return e=this.canvasX,o=this.canvasY,f=n.length/2,(t=="vertical"||t=="both")&&(s=i.verHighvalue,h=i.verLowvalue),(t=="horizontal"||t=="both")&&(c=r.horHighvalue,l=r.horLowvalue),(t=="vertical"||t=="both")&&(u?(a=s.Y+o+f,v=s.Y+o-f,y=h.Y+o+f,p=h.Y+o-f):(a=s.X+e-f,v=s.X+e+f,y=h.X+e-f,p=h.X+e+f)),(t=="horizontal"||t=="both")&&(u?(w=c.X+e+f,b=c.X+e-f,k=l.X+e+f,d=l.X+e-f):(w=c.Y+o-f,b=c.Y+o+f,k=l.Y+o-f,d=l.Y+o+f)),{verHighCapX1:a,verHighCapX2:v,verLowCapX1:y,verLowCapX2:p,horHighCapY1:w,horHighCapY2:b,horLowCapY1:k,horLowCapY2:d}},drawDisplayText:function(n,t,i){var r=this,u,b=t.type.toLowerCase(),l=r.model.AreaType.toLowerCase(),a=ej.seriesTypes[b].prototype.isRegion,v=t.drawType.toLowerCase(),f,y=!1,h=$.inArray(t,r.model._visibleSeries);ej.util.isNullOrUndefined(r.model.regionCount)&&(r.model.regionCount=-1);for(var e=r.model.enableCanvasRendering,p=r.model.AreaType.toLowerCase()=="polaraxes",o=0,s={},c,w=r.model.series.length;o<w;o++)s[c=r.model.series[o].stackingGroup]={length:s[c]?s[c].length+1:1,seriesIndex:o};i.stackingGroup=s;$.each(t._visiblePoints,function(o,s){var c=r.model.series[h].type.toLowerCase(),b,w;if(t._visiblePoints[o].textOptionsBoxValues=[],f=s.marker,u=l=="polaraxes"&&v=="column"||a||v=="rangecolumn"?c.toLowerCase()=="boxandwhisker"?s.dataLabelLocation:s.symbolLocation:l!="polaraxes"?ej.EjSvgRender.utils._getPoint(s,t):ej.EjSvgRender.utils.TransformToVisible(t,s.xValue,s.y,r),s.visible!==!1&&(f&&f.dataLabel&&f.dataLabel.visible||(!f||!f.dataLabel)&&t.marker.dataLabel.visible)){for(a&&r.model.regionCount++,c=r.model.series[h].type.toLowerCase(),b=0;b<r.model._axes.length;b++)if(r.model._axes[b].zoomFactor<1||r.model._axes[b].zoomPosition>0){y=!0;break}if((r.zoomed||t.xAxis._isScroll||y)&&(c=="column"||c=="stackingcolumn"||c=="stackingcolumn100"))for(b=0;b<r.model.chartRegions.length;b++)h==r.model.chartRegions[b].SeriesIndex&&o==r.model.chartRegions[b].Region.PointIndex&&(e&&r.model.AreaType=="cartesianaxes"?(r.svgRenderer.ctx.save(),r.svgRenderer.ctx.beginPath(),r.model.requireInvertedAxes?r.svgRenderer.ctx.rect(t.yAxis.x,t.xAxis.y,t.yAxis.width,t.xAxis.height):r.svgRenderer.ctx.rect(t.xAxis.x,t.yAxis.y,t.xAxis.width,t.yAxis.height),r.svgRenderer.ctx.clip(),n.drawDataLabel(t,o,s,u.X,u.Y,b,i),r.svgRenderer.ctx.restore()):n.drawDataLabel(t,o,s,u.X,u.Y,b,i));else if(e&&r.model.AreaType=="cartesianaxes"){if(r.svgRenderer.ctx.save(),r.svgRenderer.ctx.beginPath(),r.model.requireInvertedAxes?r.svgRenderer.ctx.rect(t.yAxis.x,t.xAxis.y,t.yAxis.width,t.xAxis.height):r.svgRenderer.ctx.rect(t.xAxis.x,t.yAxis.y,t.xAxis.width,t.yAxis.height),r.svgRenderer.ctx.clip(),r.model.chartRegions[r.model.regionCount]||c.indexOf("column")==-1&&c.indexOf("bar")==-1&&c.indexOf("waterfall")==-1){if(c.toLowerCase()=="boxandwhisker")for(w=0;w<u.length;w++)s.y=s.boxPlotLocation[w].YValues,n.drawDataLabel(t,o,s,u[w].X,u[w].Y,r.model.regionCount,i,u[w].outlier);else n.drawDataLabel(t,o,s,u.X,u.Y,r.model.regionCount,i);(c=="rangecolumn"||c=="rangearea"||c=="splinerangearea")&&(s.y=s.low,n.drawDataLabel(t,o,s,u.X,u.Y,r.model.regionCount,i),s.y=s.high)}r.svgRenderer.ctx.restore()}else{if(e&&p&&(r.svgRenderer.ctx.save(),r.svgRenderer.ctx.beginPath(),r.svgRenderer.ctx.arc(r.model.centerX,r.model.centerY,r.model.Radius,0,2*Math.PI,!1),r.svgRenderer.ctx.clip(),u.X-=r.canvasX,u.Y-=r.canvasY),c=="column"||c=="stackingcolumn"||c=="stackingcolumn100")r.model.chartRegions[r.model.regionCount]&&n.drawDataLabel(t,o,s,u.X,u.Y,r.model.regionCount,i);else if(c.toLowerCase()=="boxandwhisker")for(w=0;w<u.length;w++)s.y=s.boxPlotLocation[w].YValues,n.drawDataLabel(t,o,s,u[w].X,u[w].Y,r.model.regionCount,i,u[w].outlier);else n.drawDataLabel(t,o,s,u.X,u.Y,r.model.regionCount,i);(c=="rangecolumn"||c=="rangearea"||c=="splinerangearea")&&(s.y=s.low,n.drawDataLabel(t,o,s,u.X,u.Y,r.model.regionCount,i),s.y=s.high);e&&p&&r.svgRenderer.ctx.restore()}}})},cartesianSmartLabels:function(n,t){var d=t.length,g,nt,r,e,y,b,v,p,k,l,a,tt,it,i,w,rt,c,u,f,o,s,h;for(this.connectorFlag=!1,this.processCount=1,this.posObj={top:[],rightTop:[],left:[],leftTop:[],right:[],rightTop:[],rightBottom:[],leftBottom:[],bottom:[]},e=0;e<this.model.series.length;e++)if(g=this.model.series[e].marker.size.width,nt=this.model.series[e].marker.size.height,it=this.model.series[e].type.toLowerCase(),tt=ej.seriesTypes[it].prototype.isRegion,this.model.series[e].visibility!="hidden"&&this.model.series[e].marker.visible&&!tt)for(y=0;y<this.model.series[e]._visiblePoints.length;y++)i=this.model.series[e]._visiblePoints[y],b=i.location,this.model.markerRegion[this.model.markerRegion.length]={seriesIndex:e,xPos:b.X+this.canvasX,yPos:b.Y+this.canvasY,width:g,height:nt};for(rt=10,u=this.model.m_AreaBounds,w=0;w<d;w++)i=t[w],i.hide=!1,s=i.xPos,h=i.yPos,f=i.width,o=i.height,s-f/2<0&&s>-f/2&&(c=s-f/2,i.textOptions.x=i.xPos=s+Math.abs(c)+10,i.newConnectorFlag=!0),s+f/2>u.Width&&s+f/2<=u.Width+f/2&&(c=s-f/2,i.textOptions.x=i.xPos=u.Width-f/2-10,i.newConnectorFlag=!0),h+f/2>u.Height&&h+o/2<=u.Height+o/2&&(c=h+o/2-u.Height,i.yPos=h-c-10,i.textOptions.y=i.yPos+5,i.newConnectorFlag=!0),h-o/2<0&&h>-o/2&&(c=h-o/2,i.yPos=i.yPos+Math.abs(c)+10,i.textOptions.y=i.yPos+5,i.newConnectorFlag=!0);for(r=0;r<d;r++){if(ej.util.isNullOrUndefined(t[r].yPos))continue;else this.model.allPoints[this.model.allPoints.length]=t[r];this.connectorFlag=!1;this.compareDataLabels(r,t,0,this.processCount);i=t[r];i.connectorFlag=this.connectorFlag;t[r].dataLabeltemplate&&(k=$("#"+t[r].id),l=t[r].xPos,a=this.model.enableCanvasRendering?t[r].yPos+this.model.m_AreaBounds.Y:t[r].yPos,k.css("left",l).css("top",a),this.model.AreaType=="cartesianaxes"&&(u=this.model.m_AreaBounds,v=u.X+(this.model.requireInvertedAxes?n.yAxis.plotOffset:n.xAxis.plotOffset),p=n.yAxis.y,f=t[r].width,o=t[r].height,(l>v+u.Width||l+f<v||a+o<p||a+o>u.Y+u.Height||this.zoomed&&(l<v||a<p||l>v+u.Width||a>p+u.Height))&&k.remove()));this.storeDataLabelPositions(i)}},storeDataLabelPositions:function(n){var i=n.position,t=this.posObj;switch(i){case"top":t.top[this.processCount-1]=n;this.processCount=1;break;case"rightTop":t.rightTop[this.processCount-1]=n;this.processCount=1;break;case"right":t.right[this.processCount-1]=n;this.processCount=1;break;case"rightBottom":t.rightBottom[this.processCount-1]=n;this.processCount=1;break;case"bottom":t.bottom[this.processCount-1]=n;this.processCount=1;break;case"left":t.left[this.processCount-1]=n;this.processCount=1;break;case"leftBottom":t.leftBottom[this.processCount-1]=n;this.processCount=1;break;case"leftTop":t.leftTop[this.processCount-1]=n}},cartesianColumnSmartLabels:function(n,t){var tt=t.length,r,f,b,o,s,l,y,i,it,e,p,w,h,c,u,g,nt;for(this.connectorFlag=!1,this.processCount=1,this.model.outsideLabels=[],i=0;i<tt;i++){if(ej.util.isNullOrUndefined(t[i].yPos)||isNaN(t[i].yPos))continue;else this.model.allPoints[this.model.allPoints.length]=t[i];if(n._enableSmartLabels&&(this.connectorFlag=!1,this.compareColumnDataLabels(n,i,t,0,this.processCount)),it=n._visiblePoints[i],t[i].dataLabeltemplate){e=$("#"+t[i].id);e.css("left",t[i].xPos).css("top",t[i].yPos);r=t[i].xPos;f=t[i].yPos;t.height=e.outerHeight();var a=this.model.m_AreaBounds.X,v=this.model.m_AreaBounds.Y,k=this.model.m_AreaBounds.Width,d=this.model.m_AreaBounds.Height;t.width=e.outerWidth();o=e.width()/2;s=e.height();p=w=h=0;c=0;u=this.model.m_AreaBounds;l=u.X+(this.model.requireInvertedAxes?n.yAxis.plotOffset:n.xAxis.plotOffset);y=n.yAxis.y;b=r-o;n.marker.dataLabel.showEdgeLabels&&(r>l+u.Width||f+s>u.Y+u.Height||r<l||f<y||r>l+u.Width||f>y+u.Height||b>u.Width+u.X)&&(o=e.outerWidth(),r<a&&(w=a-r),d+v<f+s&&(g=f+s-(d+v),c=s-g),f<v&&(p=v-f),k+a<r+o&&(nt=r+o-(k+a),h=o-nt),h=h==0?o:h,c=c==0?s:c,document.getElementById(e[0].id).style.clip="rect("+p+"px,"+h+"px,"+c+"px,"+w+"px)")}}},compareColumnDataLabels:function(n,t,i,r){var g=this.model.allPoints.length-1,w=this.model.m_AreaBounds,b,e,a,l,k,f,v,o,u,s,d=n.marker.dataLabel.enableContrastColor,h=[],c=n.type.toLowerCase(),nt=new ej.seriesTypes[n.type.toLowerCase()],y,p;for(this.firstPoints=[],y=0;y<g;y++)if(o=this.model.allPoints[y],u=this.model.allPoints[this.model.allPoints.length-1],this.currentCollideLabel=o,s=5,a=n.marker.dataLabel,l=a.textPosition.toLowerCase(),rotation=a.angle,chartObj=this,e=this.isCollide(o,u,null,null,chartObj,rotation),e.state){if(c=="column"||c=="stackingcolumn"||c=="rangecolumn"||c=="waterfall"){if(u.textOptions.y=a.showEdgeLabels?u.yPos=u.yPos+e.height+s:l=="top"||l=="middle"?u.yPos=u.yPos+e.height+s:u.yPos=u.yPos-e.height-s,u.textOptions.y=u.textOptions.y+s+u.margin.top/2-u.margin.bottom/2,u.textOptions.y>w.Height){u.hide=!0;break}}else u.textOptions.x=l=="top"||l=="middle"?u.xPos=o.xPos-o.width/2-u.width/2-s:u.xPos=o.xPos+o.width/2+u.width/2+s;for(this.compareColumnDataLabels(n,t,i,r,this.processCount),b=this.checkOutsideLabels(this.model,u,w),f=0;f<this.model.allPoints.length;f++)f==0?this.firstPoints.push(this.model.allPoints[0]):this.firstPoints[this.firstPoints.length-1].x!=this.model.allPoints[f].x&&this.firstPoints.push(this.model.allPoints[f]);if(b||this.zoomed){for(v=0;v<=this.model.allPoints.length-1;v++)this._positionOutsideLabels(u,this.model.allPoints,v,c);this.model.outsideLabels.push(u)}if(d&&c.indexOf("stacking")>-1){for(p=this.model.chartRegions,f=0;f<this.model.chartRegions.length;f++)p[f].Region.PointIndex==t&&(e=this.isCollide(p[f],u,0,d,this)),e.state&&h.push(p[f]);if(h.length>5)break;else h.length>=1&&(k=jQuery.type(this.model.seriesColors[h[0].SeriesIndex])=="array"?this.model.seriesColors[h[0].SeriesIndex][0].color:this.model.seriesColors[h[0].SeriesIndex],u.textOptions.fill=nt._applySaturation(this,k))}}},_positionOutsideLabels:function(n,t,i,r){var e=t[i],f=5,u;if(i==0)if(u=this.isCollide(e,n),r&&(r=="column"||r=="stackingcolumn"||r=="rangecolumn"||r=="waterfall")){if(this.model.outsideLabels.length>0&&n.x==this.model.outsideLabels[this.model.outsideLabels.length-1].x)n.textOptions.y=n.yPos=this.model.outsideLabels[this.model.outsideLabels.length-1].yPos-u.height;else for(i=0;i<this.firstPoints.length;i++)n.x==this.firstPoints[i].x&&u.state?n.textOptions.y=n.yPos=this.firstPoints[i].yPos-u.height:t.length>1&&i<t.length-1&&(n.textOptions.y=n.yPos=t[i+1].yPos);n.textOptions.y=n.textOptions.y+f+n.margin.top/2-n.margin.bottom/2}else n.textOptions.x=n.xPos=this.model.outsideLabels.length>0?this.model.outsideLabels[this.model.outsideLabels.length-1].xPos:t[0].xPos+e.width/2+n.width/2+f;u=this.isCollide(e,n);u.state&&(r=="column"||r=="stackingcolumn"||r=="rangecolumn"||r=="waterfall"?(n.textOptions.y=n.yPos=n.yPos-u.height-f,n.textOptions.y=n.textOptions.y+f+n.margin.top/2-n.margin.bottom/2):n.textOptions.x=n.xPos=n.xPos+e.width/2+n.width/2+f)},compareDataLabels:function(n,t,i,r){var a=this.model.allPoints.length,h=this.model.m_AreaBounds,o,c,f,e,u,l,v,y,s=this.posObj;for(this.breakLoop=!1,c=0;c<a;c++)if(y=this.model.series[this.model.allPoints[c].seriesIndex].type.toLowerCase(),e=this.model.allPoints[c],u=this.model.allPoints[a-1],this.currentCollideLabel=e,f=10,l=this.isCollide(e,u,c),l.state||l.marker){this.connectorFlag=!0;switch(i){case 0:if(this.processCount>1&&this.resetValues(u),l.marker?(this.prevLabel=l.markerRegion,this.processCount=1):ej.util.isNullOrUndefined(this.prevLabel)?(this.prevLabel=e,this.processCount=1):(v=this.isCollide(this.prevLabel,u),v.state||(this.prevLabel=e,this.processCount=1)),this.resetValues(u),r>1&&s.right[this.processCount-2]?(e=s.right[this.processCount-2],u.textOptions.x=u.xPos=e.xPos+(e.width/2+u.width/2+f)):u.textOptions.x=u.xPos=this.prevLabel.xPos+(this.prevLabel.width/2+u.width/2+f),i+=1,u.position="right",this.breakLoop)break;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 1:if(this.resetValues(u),u.textOptions.x=u.xPos=this.prevLabel.xPos+this.prevLabel.width/2+u.width/2+f,r>1&&s.rightBottom[this.processCount-2]?(e=s.rightBottom[this.processCount-2],u.textOptions.y=u.yPos=e.yPos+this.canvasY+e.height+f):u.textOptions.y=u.yPos=u.location.Y+this.canvasY+u.height+f/2,u.textOptions.y=u.textOptions.y+f/2+u.margin.top/2-u.margin.bottom/2,u.position="rightBottom",i+=1,this.breakLoop)break;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 2:if(this.resetValues(u),u.textOptions.y=u.yPos=u.location.Y+this.canvasY+u.height+f/2,r>1&&s.bottom[this.processCount-2]?(e=s.bottom[this.processCount-2],u.textOptions.y=u.yPos=e.yPos+u.height+f):u.textOptions.y=u.yPos=u.location.Y+this.canvasY+u.height+f/2,u.textOptions.y=u.textOptions.y+f/2+u.margin.top/2-u.margin.bottom/2,u.position="bottom",i+=1,this.breakLoop)break;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 3:if(this.resetValues(u),u.textOptions.x=u.xPos=this.prevLabel.xPos-this.prevLabel.width/2-u.width/2-f,r>1&&s.leftBottom[this.processCount-2]?(e=s.leftBottom[this.processCount-2],u.textOptions.y=u.yPos=e.yPos+this.canvasY+e.height+f):u.textOptions.y=u.yPos=u.location.Y+this.canvasY+u.height+f/2,u.textOptions.y=u.textOptions.y+f/2+u.margin.top/2-u.margin.bottom/2,u.position="leftBottom",i+=1,this.breakLoop)break;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 4:if(this.resetValues(u),r>1&&s.left[this.processCount-2]?(e=s.left[this.processCount-2],u.textOptions.x=u.xPos=e.xPos-e.width/2-u.width/2-f):u.textOptions.x=u.xPos=this.prevLabel.xPos-this.prevLabel.width/2-u.width/2-f,u.position="left",i+=1,this.breakLoop)break;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 5:if(this.resetValues(u),u.textOptions.x=u.xPos=this.prevLabel.xPos-this.prevLabel.width/2-u.width/2-f,r>1&&s.leftTop[this.processCount-2]?(e=s.leftTop[this.processCount-2],u.textOptions.y=u.yPos=e.yPos-(u.height+f)):u.textOptions.y=u.yPos=this.prevLabel.yPos-u.height-f,u.textOptions.y=u.textOptions.y+f/2+u.margin.top/2-u.margin.bottom/2,u.position="leftTop",i+=1,this.breakLoop)break;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 6:if(this.resetValues(u),r>1&&s.top[r-2]?(e=s.top[r-2],u.textOptions.y=u.yPos=e.yPos-(u.height+f)):u.textOptions.y=u.yPos=this.prevLabel.yPos-this.processCount*(u.height+f),u.textOptions.y=u.textOptions.y+f/2+u.margin.top/2-u.margin.bottom/2,i+=1,u.position="top",this.breakLoop)break;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 7:if(this.resetValues(u),u.textOptions.x=u.xPos=this.prevLabel.xPos+this.prevLabel.width/2+u.width/2+f,r>1&&s.rightTop[this.processCount-2]?(e=s.rightTop[this.processCount-2],u.textOptions.y=u.yPos=e.yPos-u.height-f):u.textOptions.y=u.yPos=this.prevLabel.yPos-u.height-f,u.textOptions.y=u.textOptions.y+f/2+u.margin.top/2-u.margin.bottom/2,u.position="rightTop",i+=1,this.breakLoop)break;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 8:if(i=0,this.processCount+=1,n==this.processCount)i=9;else if(o=this.checkOutsideLabels(this.model,u,h),!o){this.compareDataLabels(n,t,i,this.processCount);break}case 9:(n==this.processCount||this.processCount>a)&&(this.processCount-=1,i=i<0||i==8?0:i-1,this.breakLoop=!0)}}},checkOutsideLabels:function(n,t,i){var f=n.enableCanvasRendering,e=t.dataLabeltemplate,o,s,r,u;if(n.series[t.seriesIndex].marker.dataLabel.showEdgeLabels&&(r=f?t.xPos-this.canvasX:t.xPos,u=f?t.yPos-this.canvasY:t.yPos,o=e?i.Height+i.Y:i.Height,s=e?i.Width+i.X:i.width,r-t.width/2<0||r+t.width/2>s||u+t.height/2>o||u-t.height/2<0))return!0},drawPieofPieConnectors:function(n,t){var d=t.enableAnimation&&!t._animatedSeries?"hidden":"visible",i,s,r,k;this.model.enableCanvasRendering||(this.gConnectorLinesGroup?this.gConnectorLinesGroup.childNodes.length>0:this.gConnectorLinesGroup=this.svgRenderer.createGroup({id:this.svgObject.id+"_connectorLineGroup",visibility:d}),$(this.gConnectorLinesGroup.childNodes).remove());var f=[],e=[],h=[],u=[],c=-.5*Math.PI,v,o;for(i=0;i<2;i++){if(o=t.pieCollections[i],v=i==0?t.pieCoefficient:t.pieOfPieCoefficient,f[i]=.25*v*Math.min(n.width,n.height),e[i]=this.model.circleCenterX[i],e[i]=i==0?e[i]+this.model.pieGapWidth/2:e[i]-this.model.pieGapWidth/2,h[i]=this.model.circleCenterY[i],o[0].start>0&&o[0].end<Math.PI&&i==0)var y=o[0].start+c,p=o[0].end+c-1e-6,l=e[i]+f[i]*Math.cos(y),a=h[i]+f[i]*Math.sin(y),w=e[i]+f[i]*Math.cos(p),b=h[i]+f[i]*Math.sin(p);else l=e[i]+f[i]*Math.cos(c),a=h[i]+f[i]*Math.sin(c),w=l,b=a+f[i]*2;u.push({X1:l,Y1:a,X2:w,Y2:b})}for(s=t.connectorLine,r=0;r<2;r++)k={id:this.svgObject.id+"_connectorLine"+r,x1:r==0?u[r].X1:u[r-1].X2,y1:r==0?u[r].Y1:u[r-1].Y2,x2:r==0?u[r+1].X1:u[r].X2,y2:r==0?u[r+1].Y1:u[r].Y2,stroke:s.color,"stroke-width":s.width,opacity:s.opacity,"stroke-dasharray":s.dashArray},this.svgRenderer.drawLine(k,this.gConnectorLinesGroup);this.svgRenderer.append(this.gConnectorLinesGroup,this.gSeriesEle)},drawConnectorLines:function(n,t,i){var c=!1,e=!0,o=i.xPos,s=i.yPos,h=this.model.m_AreaBounds,l=this.model.series[n].marker.dataLabel,u=i.location?i.location:i.symbolLocation,r;if(u.Y>i.textOptions.y?r=i.textOptions.y:(c=!0,r=i.textOptions.y-i.height/2),i.dataLabeltemplate?(r=i.yPos-this.model.m_AreaBounds.Y+i.height,i.textOptions.x=i.textOptions.x-this.model.m_AreaBounds.X+i.width/4+this.canvasX):(o>h.Width||o+i.width<0||s-i.height>h.Height||s+i.height<0)&&!l.showEdgeLabels&&(e=!1),e){var a="M "+(u.X+this.canvasX)+" "+(u.Y+this.canvasY)+" L "+i.textOptions.x+" "+r,f=this.model.series[n].marker.dataLabel.connectorLine,v=ej.util.isNullOrUndefined(f.color)?this.model.series[n].fill:f.color,y={id:this.svgObject.id+"_dataLabelConnectorLine_series"+n+"_"+t,stroke:v,"stroke-width":f.width,d:a};this.model.series[n].connectorLines=!0;this.svgRenderer.drawPath(y,this.gConnectorEle[n])}},resetValues:function(n){n.textOptions.y=n.dataLabel.textY;n.yPos=n.dataLabel.y;n.textOptions.x=n.dataLabel.textX;n.xPos=n.dataLabel.x},isCollide:function(n,t,i,r,u,f){var ut=0,ft=0,o=!1,p=!1,s,w,e,b,k,d,g,et,rt,y;if(r)s=n.Region.Bounds,w=u.model.m_AreaBounds,e={X:s.X-w.X,Y:s.Y-w.Y,Width:s.Width,Height:s.Height},t.symbolName!="None"?(b=t.xPos,k=t.xPos+t.width,d=t.yPos-t.height/2,g=t.yPos+t.height/2):(b=t.textOptions.x-t.width/2,k=t.textOptions.x+t.width/2,d=t.textOptions.y-(t.textOptions.angle==90||t.textOptions.angle==-90?t.height/2:t.height),g=t.textOptions.y+(t.textOptions.angle==90||t.textOptions.angle==-90?t.height/2:0)),o=e.X<k&&e.X+e.Width>b&&e.Y<g&&e.Y+e.Height>d;else{et=(n.seriesIndex?this.model.series[n.seriesIndex].marker.dataLabel.border.width:0)+(t.seriesIndex?this.model.series[t.seriesIndex].marker.dataLabel.border.width:0);var nt=this.model.series,h=nt[n.seriesIndex],ot=nt[t.seriesIndex],tt=n.xPos,it=n.yPos,st=t.xPos,ht=t.yPos;n.xPos+=h.xAxis.x;n.yPos+=h.yAxis.y;t.xPos+=ot.xAxis.x;t.yPos+=ot.yAxis.y;var l=n.height,c=n.width,a=t.height,v=t.width;if(f&&(rt=f>360?f-360:f<-360?f+360:f,(rt==90||rt==-90)&&(l=n.width,c=n.height,a=t.width,v=t.height)),n!=t&&(o=!(n.yPos+l<t.yPos||n.yPos>t.yPos+a||n.xPos+c/2+et<=t.xPos-v/2||n.xPos-c/2>=t.xPos+v/2),o&&(ft=n.yPos+l-t.yPos,ut=n.xPos+c-t.xPos),n.xPos=tt,n.yPos=it),!o)for(y=0;y<this.model.markerRegion.length;y++)if(n=this.model.markerRegion[y],h=nt[n.seriesIndex],tt=n.xPos,it=n.yPos,n.xPos+=h.xAxis.x,t.yPos+=h.yAxis.y,p=!(n.yPos+l<t.yPos-a/2||n.yPos>t.yPos+a||n.xPos+c<t.xPos||n.xPos>t.xPos+v),p)break;n.xPos=tt;n.yPos=it;t.xPos=st;t.yPos=ht}return{state:o,marker:p,markerRegion:n,width:ut,height:ft}},drawAccDisplayText:function(n,t,i){var e=this,c=t._visiblePoints.length,f,o,s,u,r,h;if(e.firstStartAngle=[],f=t.type.toLowerCase(),f!="pyramid"&&f!="funnel"&&f!="pieofpie"&&(t.leftsidePoints.length>0||t.rightsidePoints.length>0)){for(o=t.rightsidePoints.length,s=t.leftsidePoints.length,r=0;r<o;r++)t.rightsidePoints[r].index=r,n.drawDataLabelAcc(e,t,t.rightsidePoints[r].pointIndex,t.rightsidePoints[r],i);for(u=s-1;u>=0;u--)t.leftsidePoints[u].index=u,n.drawDataLabelAcc(e,t,t.leftsidePoints[u].pointIndex,t.leftsidePoints[u],i)}else for(r=0;r<c;r++)(t._visiblePoints[r].index=r,h=f=="pieofpie"?t._visiblePoints[r].actualIndex:r,t._visiblePoints[r].start!=t._visiblePoints[r].startAngle&&(t._visiblePoints[r].startAngle=t._visiblePoints[r].start),isNaN(t._visiblePoints[r].startAngle)&&t.type.toLowerCase()=="pie"&&t.type.toLowerCase=="pieofpie")||n.drawDataLabelAcc(e,t,h,t._visiblePoints[r],i,t.collectionIndex);(t.type.toLowerCase()=="pyramid"||t.type.toLowerCase()=="funnel")&&(this.svgRenderer.append(this.gConnectorEle,this.gSeriesEle),this.svgRenderer.append(this.gSymbolGroupEle,this.gSeriesEle),this.svgRenderer.append(this.gDataLabelEle,this.gSeriesEle),this.svgRenderer.append(this.gSeriesTextEle,this.gSeriesEle),this.svgRenderer.append(this.gSeriesEle,this.svgObject),this.vmlRendering||this.svgRenderer.append(this.svgObject,this.element))},_processOData:function(n){var t=this,i=n.type.toLowerCase(),r=n.dataSource.executeQuery(n.query);r.done(function(r){var f,e,u,o;for(t._processJsonData(r.result,n),n.visibility="visible",$(t.svgObject).empty(),$(t.legendSvgContainer).empty(),t.model.enableCanvasRendering&&(t.svgRenderer.ctx.clearRect(0,0,t.svgObject.width,t.svgObject.height),$("#canvas_trackSymbol").remove()),f=!0,e=i!="pie"||i!="doughnut"?0:t.model.series.length-1,u=e;o=i!="pie"||i!="doughnut"?u<t.model.series.length:u>=0;i!="pie"||i!="doughnut"?u++:u--)if(t.model.series[u].dataSource&&t.model.series[u].visibility=="hidden"){f=!1;break}f&&t.draw()});r.fail(function(){var r,i;for(n.visibility="visible",$(t.svgObject).empty(),$(t.legendSvgContainer).empty(),r=!0,i=0;i<t.model.series.length;i++)if(t.model.series[i].dataSource&&t.model.series[i].visibility=="hidden"){r=!1;break}r&&t.draw()})},_findDatatype:function(n,t){var u,i,r;if(n.xAxisName==null)u=t.model.primaryXAxis.valueType!=null&&t.model.primaryXAxis.valueType.toLowerCase()=="datetime"?!0:!1;else for(i=0;i<t.model._axes.length;i++)r=t.model._axes[i],u=r.name==n.xAxisName&&r.valueType!=null&&r.valueType.toLowerCase()=="datetime"?!0:!1;return u},_processJsonData:function(n,t){var r=t.xName,i=t.yName,c=t.pointColorMappingName,l=t.marker&&t.marker.dataLabel&&t.marker.dataLabel.textMappingName,e=t.type.toLowerCase(),f=!!document.createElementNS&&!!document.createElementNS("http://www.w3.org/2000/svg","svg")?n.length:n[n.length-1]===undefined?n.length-1:n.length,p=i.length,a=e=="bubble",o=!!n[0][r].indexOf||(t._hiloTypes?n[0][t.high]&&n[0][t.high].indexOf:!!(n[0][i]==0?0:n[0][i]||n[0][t.size]||0).indexOf),v=o&&n[0][r].indexOf&&n[0][r].indexOf("/Date(")!=-1,u=0,s,h,y=this.model._hiddenPointIndex;if(t.points=new Array(f),o)e!="boxandwhisker"&&this._processStringData(n,t,r,i,v,f);else while(u<f)s=n[u][r],t._hiloTypes||(h=typeof n[u][i]=="string"?parseFloat(n[u][i]):n[u][i]),t.points[u++]={x:s,xValue:s,y:h,YValues:[h]};return e=="boxandwhisker"&&this._processBoxandWhiskerData(n,t,r,i,v),(a||c.length>0||l.length>0||y.length>0)&&this._processBubbleSize(n,t,o,c,l,y,a,f),t._hiloTypes&&this._processHiLoValues(n,t,o,e,f),0},_processBoxandWhiskerData:function(n,t,i,r,u){for(var e=0,s=n.length,f,o,h=n[0][i].indexOf&&n[0][i].indexOf("/Date(")!=-1;e<s;)f=n[e][i],u&&(f=new Date(h?parseInt(f.substr(6)):f)),o=n[e][r],t.points[e++]={x:f,xValue:f,y:o,YValues:[o]}},_processStringData:function(n,t,i,r,u,f){for(var o=0,e,s,h=n[0][i].indexOf&&n[0][i].indexOf("/Date(")!=-1;o<f;)e=n[o][i],!u||e instanceof Date||(e=new Date(h?parseInt(e.substr(6)):e)),s=parseFloat(n[o][r]),t.points[o++]={x:e,xValue:e,y:s,YValues:[s]}},_processBubbleSize:function(n,t,i,r,u,f,e,o){for(var h,s=0;s<o;s++)h=t.points[s],h.YValues[0]=i?parseFloat(n[s][t.yName]):n[s][t.yName],e&&(h.size=h.YValues[1]=i?parseFloat(n[s][t.size]):n[s][t.size]),r.length>0&&(h.fill=n[s][r]),u.length>0&&(h.text=n[s][u]),f.length>0&&s==f[s]&&(h.visibility="hidden")},_processHiLoValues:function(n,t,i,r,u){for(var f,e,o=0;o<u;o++)f=t.points[o],e=n[o],f.y=f.high=f.YValues[0]=i?this.tryParseFloat(e[t.high]):e[t.high],f.low=f.YValues[1]=i?this.tryParseFloat(e[t.low]):e[t.low],r!="hilo"&&r!="rangecolumn"&&r!="waterfall"&&(f.open=f.YValues[2]=i?this.tryParseFloat(e[t.open]):e[t.open],f.close=f.YValues[3]=i?this.tryParseFloat(e[t.close]):e[t.close],t.volume&&(f.volume=f.YValues[4]=i?this.tryParseFloat(e[t.volume]):e[t.volume]))},tryParseFloat:function(n){return n&&n.length>0?parseFloat(n):n},bindTo:function(n){var r=this.model,o=r.series,h,s,u,c,f,e,i,t;for($("#"+this.svgObject.id+"_CrosshairVertical").remove(),$("#"+this.svgObject.id+"_CrosshairHorizontal").remove(),$.finish?($(".ejTooltip"+this._id).finish(),$(".tooltipDiv"+this._id).finish()):($(".ejTooltip"+this._id).stop(!0,!0),$(".tooltipDiv"+this._id).stop(!0,!0)),$(document).find('[id*="_TrackToolTip"]').remove(),$("#template_group_"+this._id).remove(),this.isChartElemId&&this.createElementsId(),r.primaryXAxis._valueType=null,r.primaryXAxis.position=null,r.primaryYAxis._valueType=null,r.primaryYAxis.position=null,r.requireInvertedAxes=!1,r._hiddenPointIndex=[],h=o.length,s=r.axes.length,i=0;i<s;i++)u=r.axes[i],u._valueType=null,u.position=null;if(r._axes)for(s=r._axes.length,f=0;f<s;f++)u=r._axes[f],u._valueType=null,u.position=null,u.zoomFactor=u._pointsLength&&u._pointsLength!=u.scrollbarSettings.pointsLength?1:u.zoomFactor;for(i=0;i<h;i++){if(t=o[i],c=["y","high","low","open","close"],!ej.isNullOrUndefined(t.points))for(f=0;f<t.points.length;f++)c.map(function(n){var i=t.points[f][n];ej.isNullOrUndefined(i)||(t.points[f][n]=typeof i=="string"?parseFloat(i):i)});t.position=null;t.fill&&this.model.seriesColors&&t.fill!=this.model.seriesColors[i]&&(o[i].isFill=!0)}if(r.AreaType&&r.AreaType=="none")for(t=o[0],i=0;t.points&&i<t.points.length;i++)e=t.points[i],e._visibility=="hidden"&&r.AreaType=="none"&&o.length==1&&(this.model._hiddenPointIndex[i]=i),e.isFill=e.fill&&r.pointColors&&e.fill!=r.pointColors[i]||e.isFill,e.fill=e.isFill?e.fill:null;if(r.enable3D&&(ej.Ej3DRender.transform=null),o){if(this.setModelProperties(n),!n)for(i=0;i<o.length;i++)t=o[i],(t.visibility==null||t.visibility==undefined)&&(t.visibility="visible"),t.type&&(t._hiloTypes=t.type.toLowerCase()=="polar"||t.type.toLowerCase()=="radar"?ej.seriesTypes[t.drawType.toLowerCase()].prototype.hiloTypes:ej.seriesTypes[t.type.toLowerCase()].prototype.hiloTypes),t.points||(t.points=[]),t.dataSource&&(t.dataSource instanceof ej.DataManager?(t.visibility="hidden",!ej.isNullOrUndefined(t.query)&&t.query instanceof ej.Query||(t.query=ej.Query()),this._processOData(t)):t.dataSource.length>0&&((typeof t.dataSource=="string"||t.dataSource.toLowerCase)&&(t.dataSource=JSON.parse(t.dataSource.replace(/'''/g,'"'))),this._processJsonData(t.dataSource,t)));$(this.svgObject).width()>0&&this.draw(n)}},_createChartId:function(){var i=!1,n=0,t=$(this.element)[0].className.split(" ")[0];do $("#"+t+"_"+n).length||($(this).attr("_id",t+"_"+n),$(this.element).attr("id",t+"_"+n),i=!0),n++;while(!i);this.isChartElemId=!0},createElementsId:function(){this.legendContainer.attr("id","legend_"+this._id);this.scrollerContainer.attr("id","legend_Scroller"+this._id);this.chartContainer.attr("id","chartContainer_"+this._id);this.axisScroll.attr("id","axisScrollbar_"+this._id);$(this.svgObject).attr("id",this._id+(this.model.enableCanvasRendering?"_canvas":"_svg"))},calculateHeight:function(n){var i=$(n.svgObject),r=n.model.size.height,u=$(n.element).height(),t=u/100*parseInt(r);return i.height(t),t},calculateWidth:function(n){var i=$(n.svgObject),r=n.model.size.width,u=$(n.element).width(),t=u/100*parseInt(r);return i.width(t),t},selectedStyle:function(n){for(var r=$("#"+n._id).find('[class*="Selection"]'),i=[],t=0;t<r.length;t++)i[t]=[],i[t].id=r[t].id,i[t].className=$("#"+i[t].id).attr("class");return $("[id $= Def ]").length>0&&(i.pattern=$("[id $= Def ]")),i},chartResize:function(){var n=this,i=$(n.svgObject),t=this.selectedStyle(n),r,u,f;this.removeMultiRect();this._chartResize=!0;this.model.enableCanvasRendering&&($("[id*="+this._id+"_Selection_]").remove(),$("#canvas_trackSymbol").remove(),r=n.svgObject.getContext("2d"),r.clearRect(0,0,this.svgRenderer.svgObj.width,this.svgRenderer.svgObj.height),typeof n.model.size.width=="string"&&n.model.size.width.indexOf("%")!=-1?(u=n.calculateWidth(n),this.svgRenderer.svgObj.width=u):this.svgRenderer.svgObj.width=$("#"+this._id).width(),typeof n.model.size.height=="string"&&n.model.size.height.indexOf("%")!=-1?(f=n.calculateHeight(n),this.svgRenderer.svgObj.height=f):this.svgRenderer.svgObj.height=ej.util.isNullOrUndefined(this.model.size.height)?"450":parseInt($(n.element).height()));this.resizeTO&&clearTimeout(this.resizeTO);this.resizeTO=setTimeout(function(){var u,r;if(!ej.util.isNullOrUndefined(n.model)&&(typeof n.model.size.width=="string"&&n.model.size.width.indexOf("%")!=-1?n.calculateWidth(n):i.width($(n.element).width()),typeof n.model.size.height=="string"&&n.model.size.height.indexOf("%")!=-1?n.calculateHeight(n):i.height(n.model.size.height),$(n.svgObject).width()>0)){for($(n.svgObject).empty(),$(n.legendSvgContainer).empty(),$("#template_group_"+n._id).remove(),$("#annotation_group_"+n._id).remove(),n.disableAnimation(),u=0;u<n.model.series.length;u++)n.model.series[u].regionAdded=!1;for(n.draw(),r=0;r<t.length;r++)$("#"+t[r].id).attr("class",t[r].className);t.pattern&&n.svgRenderer.append(t.pattern,n.svgObject);n.zoomed&&!n.vmlRendering&&n._enableZoomingButtons();n.enableAnimation()}},500)},isDevice:function(){return/mobile|tablet|android|kindle/i.test(navigator.userAgent.toLowerCase())},isWindows:function(){if(!ej.getBooleanVal($("head"),"data-ej-android")&&!ej.getBooleanVal($("head"),"data-ej-ios")&&!ej.getBooleanVal($("head"),"data-ej-ios7")&&!ej.getBooleanVal($("head"),"data-ej-flat"))return this._windows()},_windows:function(){return/trident|windows phone/i.test(navigator.userAgent.toLowerCase())||ej.getBooleanVal($("head"),"data-ej-windows",!1)===!0},bindResizeEvents:function(){if(this.model._resizeEventRegistered)return 0;ej.isTouchDevice()&&this._isOrientationSupported()?this._on($(window),"orientationchange",this.chartResize):this._on($(window),"resize",this.chartResize);this.model._resizeEventRegistered=!0},removeResizeEvents:function(){this.model._resizeEventRegistered&&(ej.isTouchDevice()&&this._isOrientationSupported()?this._off($(window),"orientationchange",this.chartResize):this._off($(window),"resize",this.chartResize),this.model._resizeEventRegistered=!1)},_isOrientationSupported:function(){return"orientation"in window&&"onorientationchange"in window},_calculatePinchZoomPosition:function(n){var i=this.model.m_AreaBounds,f,l=this.model._axes,t,a=n.originalEvent.touches&&n.originalEvent.touches.length>0?n.originalEvent.touches[0]:n.originalEvent,r=a.pageX,u=a.pageY,e=this.previousPanTouch,o,s,h,c=0,v=l.length;if(r>i.X&&r<i.X+i.Width&&u>i.Y&&u<i.Y+i.Height){if(e||(e=this.previousPanTouch={pageX:r,pageY:u}),ej.isTouchDevice()||this.model.zooming.enableDeferredZoom)return this.oPreviousCoords={x:this.previousPanTouch.pageX,y:this.previousPanTouch.pageY},this.chartMouseMove(n);for(;c<v;c++)t=l[c],s=t.orientation.toLowerCase()=="horizontal",h=s?(e.pageX-r)/t.width*t.zoomFactor:(e.pageY-u)/t.height*t.zoomFactor,f=t.zoomPosition,t.zoomPosition=this._ensureValueInMinMax(s?f+h:f-h,0,1-t.zoomFactor),o=o||f!=t.zoomPosition;this.previousPanTouch={pageX:r,pageY:u};o&&!this.chartUpdating&&(this.redraw(!0,o,n.target),this._enableZoomingButtons())}},_calculateTouchDistance:function(n,t){for(var r=[],i=0,u=t.length;i<u;i++)n[i]==null&&(n[i]=t[i]),r[i]={},i>0&&(r[i].scaleX=n[0].pageX!=n[1].pageX&&(t[0].pageX-t[1].pageX)/(n[0].pageX-n[1].pageX),r[i].scaleY=n[0].pageY!=n[1].pageY&&(t[0].pageY-t[1].pageY)/(n[0].pageY-n[1].pageY),r[i].center={x:(n[0].pageX+t[0].pageX)/2,y:(n[1].pageY+t[1].pageY)/2});return r},_ensureValueInMinMax:function(n,t,i){return n<t?t:n>i?i:n},_calculatePinchZoomFactor:function(n,t,i){var v=this.model,e=v._axes,u=!0,o,s,y,p,h,r,c,w,b=v.m_AreaBounds,l,a=1e4,f=0,k=e.length;if(t=t=="x"?"horizontal":t=="y"?"vertical":null,this.previousScale!=null){for(;f<k;f++)if(!t||e[f].orientation===t){if(r=e[f],s=r.orientation=="horizontal"?n[1].scaleX:n[1].scaleY,!s)break;l=r.orientation=="horizontal"?this.previousScale[1].scaleX:this.previousScale[1].scaleY;c=r.zoomFactor;w=r.zoomPosition;h=this._ensureValueInMinMax(1/r.zoomFactor,1,a);p=this._ensureValueInMinMax(h+h*(s-l)/l,1,a);y=r.orientation=="horizontal"?n[1].center.x/b.Width:1-n[1].center.y/b.Height;r.zoomFactor=this._ensureValueInMinMax(1/p,1/a,1);r.zoomPosition=this._ensureValueInMinMax(w+(c-r.zoomFactor)*y,0,1-r.zoomFactor);o=o||c!=r.zoomFactor;u=u&&r.zoomFactor==1}!o||u||this.chartUpdating?u&&this.zoomed&&!this.chartUpdating&&(this.redraw(!0,!0,i),this.zoomed=!1,this._removeZoomkit()):(this.zoomed=!0,this.redraw(!0,!0,i),this._enableZoomingButtons())}this.previousScale=n},_addTouchPointer:function(n,t,i,r){for(r=n.length;r--;)if(t.pointerId==n[r].pointerId)return i&&(n[r]=t),0;n.push(t)},_removeTouchPointer:function(n,t,i){for(i=n&&n.length;i--;)if(t.pointerId==n[i].pointerId)return n.splice(i,1),0},_copyTouches:function(n){for(var i=[],t=0,r=n.length;t<r;t++)i[t]={pageX:n[t].pageX,pageY:n[t].pageY};return i},_initEventParams:function(){return{touches:[],movements:[]}},_pointerPinchStart:function(n){var t=n.originalEvent,i,u=this.model,r=u.m_AreaBounds,s=$(this.element).offset(),f=this.eventParams||(this.eventParams=this._initEventParams()),e=(t.pageX||t.changedTouches[0].pageX)-s.left,o=(t.pageY||t.changedTouches[0].pageY)-s.top;this.model.selectionEnable&&(this.cancelEvent(n),t.preventDefault());!u.enable3D&&u.AreaType=="cartesianaxes"&&t.pointerType!="mouse"&&t.pointerType!=4&&u.zooming.enable&&u.zooming.enablePinching&&(t.touches||t.pointerId)?(i=n.target.id,i.indexOf("ResetZoom")!=-1?this.resetZoom(n):i.indexOf("panIcon")!=-1?this.startPan(n):i.indexOf("ZoomIcon")!=-1?this.startZoom(n):i.indexOf("ZoomOut")!=-1||i.indexOf("ZoomIn")!=-1?this.startZoomInOut(n):e>r.X&&e<r.X+r.Width&&o>r.Y&&o<r.Y+r.Height?(t.touches?f.touches=this._copyTouches(t.touches):this._addTouchPointer(f.touches,{pageX:e,pageY:o,pointerId:t.pointerId}),f.touches.length<2&&this.chartMouseDown(n)):this.chartMouseDown(n)):this.chartMouseDown(n)},_removeInteractions:function(){$("[id*=_TrackSymbol]").remove();this._removeTrackBall();this._removeHighlight();$("#"+this.svgObject.id+"_TrackToolTip").hide();$("#"+this._id+"_tooltip").remove()},_pinchGestureMove:function(n){var r=n.originalEvent.changedTouches[0],u=n.originalEvent.touches,t=this.model,f=$(this.element).offset(),i=t.m_AreaBounds,e=r.pageX-f.left,o=r.pageY-f.top;this.eventParams=this.eventParams||this._initEventParams(t,r);!t.enable3D&&t.AreaType=="cartesianaxes"&&r.pointerType!="mouse"&&r.pointerType!=4&&t.zooming.enable&&t.zooming.enablePinching&&u?e>i.X&&e<i.X+i.Width&&o>i.Y&&o<i.Y+i.Height?(this._removeInteractions(),u.length>1?this._calculatePinchZoomFactor(this._calculateTouchDistance(this.eventParams.touches,u),t.zooming.type,n.target):this.doPan||this.panning?this._calculatePinchZoomPosition(n):this.chartMouseMove(n)):this.chartMouseMove(n):this.chartMouseMove(n)},_pointerPinchMove:function(n){var u,h=0,i=n.originalEvent,c=$(this.element).offset(),e=i.pageX-c.left,o=i.pageY-c.top,f=this.model,l=this.eventParams||this._initEventParams(f,i),t=l.touches,s=this.previousPointerMove,a=t.length,r=l.movements;if(s!=null&&s.pageX==i.pagex&&s.pageY==i.pageY&&s.pointerId==n.pointerId)return!1;if(!f.enable3D&&f.AreaType=="cartesianaxes"&&i.pointerType!="mouse"&&i.pointerType!=4&&f.zooming.enable&&f.zooming.enablePinching){if(u=f.m_AreaBounds,e>u.X&&e<u.X+u.Width&&o>u.Y&&o<u.Y+u.Height)if(this._addTouchPointer(t,{pageX:e,pageY:o,pointerId:i.pointerId}),t&&t.length>1){for(;h<a;h++)this._addTouchPointer(r,t[h],!1);this._addTouchPointer(r,{pageX:e,pageY:o,pointerId:i.pointerId},!0);r[0].pageX==t[0].pageX&&r[1].pageX==t[1].pageX&&r[0].pageY==t[0].pageY&&r[1].pageY==r[1].pageY||this._calculatePinchZoomFactor(this._calculateTouchDistance(t,r),this.model.zooming.type,n.target)}else this.doPan||this.panning?this._calculatePinchZoomPosition(n):this.chartMouseMove(n);else t.length>0&&this._removeTouchPointer(t,n),r.length>0&&this._removeTouchPointer(r,n),this.chartMouseMove(n);this.previousPointerMove={pageX:e,pageY:o,pointerId:i.pointerId}}else this.chartMouseMove(n)},_pointerPinchEnd:function(n){var i=this.model,t=n.originalEvent,r=this.eventParams||(this.eventParams=this._initEventParams(i,t)),u=t.type.indexOf("leave")!=-1||t.type.indexOf("out")!=-1||t.type.indexOf("Out")!=-1;!i.enable3D&&i.AreaType=="cartesianaxes"&&t.pointerType!="mouse"&&t.pointerType!=4&&i.zooming.enable&&i.zooming.enablePinching&&(t.touches||t.pointerId)?(this.continuePinching!=null&&this.svgObject.removeChild(this.svgObject.firstChild),this.continuePinching=this.previousPanTouch=this.previousScale=null,t.touches?(this.eventParams=null,this.chartMouseUp(n),u&&this.chartMouseLeave(n)):(this._removeTouchPointer(r.touches,{pointerId:t.pointerId}),r.movements.length>0&&this._removeTouchPointer(r.movements,{pointerId:t.pointerId}),r.touches.length==0&&(this.chartMouseUp(n),u&&this.chartMouseLeave(n),this.eventParams=null))):(this.chartMouseUp(n),u&&this.chartMouseLeave(n))},_appendStyle:function(n){var i="#"+n+".e-canvas * {touch-action:none; -ms-touch-action:none}",r=document.head||document.body,t=document.createElement("style");t.type="text/css";t.appendChild(document.createTextNode(i));r.appendChild(t)},bindEvents:function(){var f=jQuery.uaMatch(navigator.userAgent),i=ej.EjSvgRender.utils.browserInfo(),t=i.isMSPointerEnabled,n=i.pointerEnabled,e=t?n?"pointerdown":"MSPointerDown":"touchstart mousedown",o=t?n?"pointerup":"MSPointerUp":"touchend mouseup",s=t?n?"pointermove":"MSPointerMove":"touchmove mousemove",h=t?n?"pointerleave":"MSPointerOut":"touchleave mouseleave",r,u;this.model.browserInfo=i;window.navigator.maxTouchPoints>1&&window.PointerEvent||window.PointerEventsPolyfill?(this._on(this.element,"pointerup pointerleave",this._pointerPinchEnd),this._on(this.element,"pointerdown",this._pointerPinchStart),this._on(this.element,"pointermove",this._pointerPinchMove),this._appendStyle(this.element[0].id)):window.TouchEvent?(this._on(this.element,"touchstart",this._pointerPinchStart),this._on(this.element,"touchmove",this._pinchGestureMove),this._on(this.element,"touchend",this._pointerPinchEnd),this._on($(this.element),"mousedown",this.chartMouseDown),this._on($(this.element),"mousemove",this.chartMouseMove),this._on(this.element,"mouseleave",this.chartMouseLeave),this._on($(document),"mouseup",this.chartMouseUp),this._appendStyle(this.element[0].id)):window.navigator.msMaxTouchPoints&&window.navigator.msPointerEnabled?(this._on(this.element,"MSPointerUp",this._pointerPinchEnd),this._on(this.element,"mouseleave",this.chartMouseLeave),this._on(this.element,"MSPointerDown",this._pointerPinchStart),this._on(this.element,"MSPointerMove",this._pointerPinchMove),this._appendStyle(this.element[0].id)):(this._on(this.element,s,this.chartMouseMove),this._on(this.element,h,this.chartMouseLeave),this._on($(document),o,this.chartMouseUp),this._on($(this.element),e,this.chartMouseDown));this._isSafari=!!navigator.userAgent.match(/Version\/[\d\.]+.*Safari/);(this.isDevice()&&this._isSafari)!=!0&&this._on($(this.element),"click",this.chartMouseClick);this._on($(this.element),"contextmenu",this.chartRightClick);this._on($(this.element),"dblclick",this.chartMouseDoubleClick);(this.model.canResize||this.model.isResponsive)&&this.bindResizeEvents();r=this.model.zooming.enable||this.model.commonSeriesOptions.dragSettings.enable?"none":"pan-y";$(this.element).css({"ms-touch-action":r,"touch-action":r,"content-zooming":"none"});$(this.element).css({"-webkit-touch-callout":"none","-webkit-user-select":"none","-moz-user-select":"none","-ms-user-select":"none","user-select":"none"});u=f.browser.toLowerCase()=="mozilla"?n?"mousewheel":"DOMMouseScroll":"mousewheel";this._on(this.element,u,this.chartMouseWheel)},calZoomFactors:function(n,t,i,r){var u,f;return n==1?(u=1,f=0):(u=ej.EjSvgRender.utils._minMax(1/n,0,1),f=r+(i-u)*t),{zoomMFactor:u,zoomMPosition:f}},doMouseWheelZoom:function(n,t,i){if(n>=1){var r=this.calZoomFactors(n,t,i.zoomFactor,i.zoomPosition);if(i.zoomPosition!=r.zoomMPosition||i.zoomFactor!=r.zoomMFactor)return this.zoomed=!0,i.zoomPosition=r.zoomMPosition,i.zoomFactor=r.zoomMPosition+r.zoomMFactor>1?1-r.zoomMPosition:r.zoomMFactor,!0}return!1},enableAnimation:function(){for(var t,n=0;n<this.model.series.length;n++)t=this.model.series[n],t.enableAnimation=this.serAnimation[n]},disableAnimation:function(){for(var t,n=this,i=0;i<n.model.series.length;i++)n.model.series[i].enableAnimation=!1;for(t=0;t<n.model.indicators.length;t++)n.model.indicators[t].enableAnimation=!1},_removeTrackBall:function(){var t="#"+this.svgObject.id,n;$("#"+this.svgObject.id+"_trackSymbol").remove();$(document).find("#measureTex").remove();this.chartCross.visible&&(n=$(this.svgObject).find(t+"_AxisCrossToolTip"),this.svgRenderer._setAttr($(n),{visibility:"hidden"}),n=$(this.svgObject).find(t+"_CrosshairVertical"),this.svgRenderer._setAttr($(n),{d:"M 0 0"}),n=$(this.svgObject).find(t+"_CrosshairHorizontal"),this.svgRenderer._setAttr($(n),{d:"M 0 0"}),n=$(this.svgObject).find(t+"_TrackAxisToolTip"),this.svgRenderer._setAttr($(n),{visibility:"hidden"}),n=$(this.svgObject).find(t+"_Tracker"),this.svgRenderer._setAttr($(n),{d:"M 0 0"}),n=$(this.svgObject).find('[id*="_TrackToolTip"]'),this.svgRenderer._setAttr($(n),{visibility:"hidden"}),n=$(this.svgObject).find('[id*="_TrackToolTip"]').children(),this.svgRenderer._setAttr($(n),{visibility:"hidden"}),$(n).css("visibility","hidden"),n=$(this.svgObject).find('[id*="_trackSymbol_"]'),this.svgRenderer._setAttr($(n),{visibility:"hidden"}),$(document).find('[id*="_TrackToolTipTemplate_"]').attr("visibility","hidden"),$(document).find('[id*="_TrackToolTipTemplate_"]').css("display","none"),$(t+"_CrosshairVertical").css("display","none"),$(t+"_CrosshairHorizontal").css("display","none"),$("#"+this._id).find('[id*="canvas_AxisToolTipRect"]').css("visibility","hidden"),$("#"+this._id).find('[id*="canvas_Tracker"]').remove(),$("#"+this._id).find('[id*="canvas_trackSymbol"]').css("visibility","hidden"),$("#"+this._id).find('[id*="_gTooltip_"]').remove(),$("#secondCanvas").remove(),$(document).find('[id*="TrackGroupToolTipTemplate"]').remove(),$(document).find('[id*="_TrackToolTipTemplate_"]').remove(),$("#"+this._id).find('[id*="_trackball_grouping_tooltip"]').remove())},enableTrackBall:function(){this.model.crosshair.visible=this.chartCross.visible;this.model.crosshair.type=this.chartCross.mArea},disableTrackBall:function(){this.model.crosshair.visible=!1;this._removeTrackBall()},_enableZoomingButtons:function(){var n=this.svgObject.id,e,u,t,f,r,i;if(this.model.AreaType!="cartesianaxes"&&($("#"+n+"_ResetZoom").remove(),$("#"+n+"_PanBtn").remove(),$("#"+n+"_ZoomBtn").remove(),$("#"+n+"_ZoomInBtn").remove(),$("#"+n+"_ZoomOutBtn").remove()),this.model.AreaType=="cartesianaxes")for(this._removeZoomkit(),e=this.model.zooming.isReversed,this.toolbarItems||(this.toolbarItems=$.extend(!0,[],this.model.zooming.toolbarItems),this.toolbarItems.reverse()),u=e?this.toolbarItems:this.model.zooming.toolbarItems,t=u.length,i=t-1;i>=0;i--){f=u[i];r=t-i;switch(f){case"reset":this.resetZoomButton(r);break;case"pan":this.panButton(r);break;case"zoom":case"zoomIn":case"zoomOut":this.zoomButton(r,f);break;default:t=t-1}}},chartMouseWheel:function(n){var i,o,u,t,h,c,e;if($("#"+this.svgObject.id+"_TrackToolTip").hide(),$(document).find('[id*="TrackGroupToolTipTemplate"]').remove(),$(document).find('[id*="_TrackToolTipTemplate_"]').remove(),$(this.svgObject).find('[id*="_trackSymbol_"]').remove(),this.model.zooming.enableMouseWheel&&this.model.AreaType=="cartesianaxes"&&!this.model.enable3D&&!this.vmlRendering&&ej.util.isNullOrUndefined(this.model.isLazyZooming)){i=this;this.zoomed=!1;var f=!1,r="#"+i.svgObject.id,e=jQuery.uaMatch(navigator.userAgent),l=!!navigator.userAgent.match(/Trident\/7\./),s=n.originalEvent.wheelDelta,a=e.browser.toLowerCase()=="mozilla"?l?s/120>0?1:-1:-n.originalEvent.detail/3>0?1:-1:s/120>0?1:-1;for(u=0;u<this.model._axes.length;u++)t=this.model._axes[u],(t.orientation.toLowerCase()=="vertical"&&(i.model.zooming.type.toLowerCase()=="y"||i.model.zooming.type.trim().toLowerCase()=="x,y")||t.orientation.toLowerCase()=="horizontal"&&(i.model.zooming.type.toLowerCase()=="x"||i.model.zooming.type.trim().toLowerCase()=="x,y"))&&(h=Math.max(1/ej.EjSvgRender.utils._minMax(t.zoomFactor,0,1),1),c=Math.max(h+.25*a,1),f=f|i.doMouseWheelZoom(c,.5,t)),t.zoomFactor!=1&&t.zoomPosition!=0&&(o=!0),this.resetZooming=t.zoomFactor==1&&t.zoomPosition==0;this._updateScroll();this.disableAnimation();this.disableTrackBall();f&&(this.model.legendCollapsed=!1,this.zoomed=!0,i.redraw(!0));this.model._chartAreaZoom=!0;this._enableZoomingButtons();this.mouseWheelCoords={x:n.originalEvent.pageX,y:n.originalEvent.pageY};o||($(r+"_ResetZoom").remove(),$(r+"_PanBtn").remove(),$(r+"_ZoomBtn").remove(),$(r+"_ZoomInBtn").remove(),$(r+"_ZoomOutBtn").remove(),this.enableAnimation(),this.panning=!1);e=jQuery.uaMatch(navigator.userAgent);n.preventDefault&&e.browser=="chrome"&&this.model.zooming.enable&&n.preventDefault();n.returnValue=!1}$(".tooltipDiv"+this._id).remove()},getAxisMultiLevelLabelsData:function(n){var f=this.calMousePosition(n),s=this.model.multiLevelLabelRegions.length,t,r,u,e,o,i;for(this.mousemoveX=f.X,this.mousemoveY=f.Y,i=0;i<s;i++)if(t=this.model.multiLevelLabelRegions[i],r=t.bounds.x,u=t.bounds.y,e=t.bounds.height,o=t.bounds.width,this.mousemoveX>=r&&this.mousemoveX<=r+o&&this.mousemoveY<=u+e&&this.mousemoveY>=u)return{location:{x:this.mousemoveX,y:this.mousemoveY},axis:this.model._axes[t.axisIndex],multiLevelLabel:t.multiLevelLabel}},getAxisLabelData:function(n){var c=this.calMousePosition(n),e=n.target.id,r,u,f,s,h,o,l,a=this.model._axes.length,t,i;if(this.mousemoveX=c.X,this.mousemoveY=c.Y,this.model.AreaType=="cartesianaxes"||this.model.AreaType=="polaraxes")if(this.model.enable3D){if(e.indexOf("horizontal")>=0||e.indexOf("vertical")>=0)for(t=0;t<a;t++)for(o=this.model._axes[t].visibleLabels.length,i=0;i<o;i++)if(e==this.svgObject.id+this.model._axes[t].orientation+i)return{location:{x:this.mousemoveX,y:this.mousemoveY},index:i,axis:this.model._axes[t],text:this.model._axes[t].visibleLabels[i].Text}}else for(t=0;t<a;t++)if(o=this.model._axes[t].visibleLabels.length,l=this.model._axes[t].visible,l)for(i=0;i<o;i++)if(r=this.model._axes[t].visibleLabels[i].region,!ej.util.isNullOrUndefined(r)&&(u=r.bounds.x,f=r.bounds.y,s=r.bounds.width,h=r.bounds.height,u=this.vmlRendering&&e.indexOf("_YLabel_")>=0?this.model._axes[t].opposedPosition?u:u+s:u,this.mousemoveX>=u&&this.mousemoveX<=u+s&&(this.vmlRendering?this.mousemoveY<=f+h&&this.mousemoveY>=f:this.mousemoveY>=f-h&&this.mousemoveY<=f)))return{location:{x:this.mousemoveX,y:this.mousemoveY},index:i,axis:this.model._axes[t],text:r.labelText}},getLegendData:function(n){var t=this.calMousePosition(n),o=this.model.legend.isReversed;t.X=o&&($("#legend_"+this._id).find('[class*="e-vscrollbar"]').length||$("#legend_"+this._id)[0].style.overflowY=="scroll")?t.X-18:t.X;t.X-=parseFloat($(this.element).css("padding-left"));t.Y-=parseFloat($(this.element).css("padding-top"));var f=this.model.legend._ejScroller,r=0,i=0;r=f?$("#legend_"+this._id).ejScroller("instance").model.scrollTop:$("#legend_"+this._id).scrollTop();i=f?$("#legend_"+this._id).ejScroller("instance").model.scrollLeft:$("#legend_"+this._id).scrollLeft();o&&f&&(i=i==0?$("#legend_"+this._id).ejScroller("instance")._rtlScrollLeftValue:$("#legend_"+this._id).ejScroller("instance").model.scrollLeft==$("#legend_"+this._id).ejScroller("instance")._rtlScrollLeftValue?0:$("#legend_"+this._id).ejScroller("instance")._rtlScrollLeftValue-$("#legend_"+this._id).ejScroller("instance").model.scrollLeft);this.scrolltop=r?r:0;this.scrollleft=i?i:0;this.mousemoveX=t.X+i;this.mousemoveY=t.Y+r;var s=n.target.id,h=this.mousemoveX,c=this.mousemoveY,e=this._id,u;return(!ej.util.isNullOrUndefined(s)&&this.svgRenderer._getAttrVal($(n.target).parents(":eq(1)"),"id")==this.svgObject.id+"_Legend"||this.model.enableCanvasRendering&&s=="legend_"+e+"_canvas"||this.vmlRendering)&&($.each(this.model.legendRegion,function(n,t){h>=t.Bounds.LegendBound.X+t.Bounds.ItemBound.X&&h<=t.Bounds.LegendBound.X+t.Bounds.ItemBound.X+t.Bounds.ItemBound._Width&&(c>=t.Bounds.LegendBound.Y+t.Bounds.ItemBound.Y-t.Bounds.ItemBound.Height/4&&c<=t.Bounds.LegendBound.Y+t.Bounds.ItemBound.Y+t.Bounds.ItemBound.Height?(u=t,$("#legend_"+e+"_canvas").css("cursor","pointer")):$("#legend_"+e+"_canvas").css("cursor","default"))}),!ej.util.isNullOrUndefined(u))?{legendItem:u,series:this.model._visibleSeries[u.LegendItem.SeriesIndex]}:!1},get3DSeriesPoint:function(n){var r=this.mousemoveX,u=this.mousemoveY,s=this.model.AreaType=="polaraxes"?0:this.model.m_AreaBounds.X,h=this.model.AreaType=="polaraxes"?0:this.model.m_AreaBounds.Y,l=this.model.AreaType=="polaraxes"?$(this.svgObject).width():this.model.m_AreaBounds.Width,a=this.model.AreaType=="polaraxes"?$(this.svgObject).height():this.model.m_AreaBounds.Height,t,f,c,e,i,o;if(r>s&&r<s+l&&u>h&&u<h+a&&(e=$(n.target)[0].nodeName,(e=="path"||e=="shape")&&$(n.target)[0].id.indexOf("Region")>1))return t=$(n.target)[0].id.match(/(\d+)/g),f=parseInt(t[t.length-1]),c=parseInt(t[t.length-2]),i={},i.Region={},i.Region.PointIndex=f,i.SeriesIndex=c,o={},o.pointIndex=f,{region:i,pointData:o,location:{x:r,y:u}}},GetSeriesPoint:function(n){for(var a,p,r,y,d,i,ft,et,u=this.mousemoveX,f=this.mousemoveY,o,it,t=this,b=t.model.indicators,k=t.model._visibleSeries,e=0;e<b.length&&b[e].segment;e++)k=k.concat(b[e].segment);if(t.model.enable3D)return this.get3DSeriesPoint(n);var rt=this.model.AreaType=="polaraxes"?0:this.model.m_AreaBounds.X,ut=this.model.AreaType=="polaraxes"?0:this.model.m_AreaBounds.Y,ot=this.model.AreaType=="polaraxes"?$(this.svgObject).width():this.model.m_AreaBounds.Width,st=this.model.AreaType=="polaraxes"?$(this.svgObject).height():this.model.m_AreaBounds.Height;if(this.model.AreaType=="cartesianaxes"||this.model.AreaType=="polaraxes"){if(u>rt&&u<rt+ot&&f>ut&&f<ut+st&&$.each(this.model.chartRegions,function(i,e){var tt,lt,at,w,d,rt,ot,ft,vt,gt,g,nt,s,h,p,y,b,et;if(ej.util.isNullOrUndefined(e.SeriesIndex)){if(r=t.model.chartRegions,gt={},!e.isStripLine){var wt=e.length,ni=t.model.requireInvertedAxes,ti=ni?t.model.series[e[wt-1].SeriesIndex]._xAxisName:t.model.series[e[wt-1].SeriesIndex]._yAxisName;for(nt=0;nt<t.model._axes.length;nt++)if(ti==t.model._axes[nt].name){g=t.model._axes[nt];break}for(s=0;s<r.length;s++)for(h=0;h<r[s].length;h++)p=[],y=r[s][h].region,y[0]&&p.push({x:y[0].X+g.x,y:y[0].Y+g.y}),y[1]&&p.push({x:y[1].X+g.x,y:y[1].Y+g.y}),y[2]&&p.push({x:y[2].X+g.x,y:y[2].Y+g.y}),y[3]&&p.push({x:y[3].X+g.x,y:y[3].Y+g.y}),b={x:u,y:f},et=t.isPointInPolygon(p,b),et&&(o=r[s][h])}}else if(tt=k[e.SeriesIndex],t.model.AreaType=="polaraxes"&&tt.drawType.toLowerCase()=="column"&&n.target||tt.drawType.toLowerCase()=="rangecolumn"){if(t.model.enableCanvasRendering){if(tt.type.toLowerCase()=="polar"){var w=e.Region.Bounds,bt=-.5*Math.PI,kt=w.innerRadius||w.DRadius,st,ht;st=u-w.CenterX;ht=f-w.CenterY;var yt=t.model._visibleSeries[e.SeriesIndex],dt=yt.startAngle,ii=yt.endAngle,ct=dt?2*Math.PI*(t.model.itemCurrentXPos<0?1+t.model.itemCurrentXPos:t.model.itemCurrentXPos):0,ut=(Math.atan2(ht,st)-bt-ct)%(2*Math.PI);ut<0&&w.PointIndex!=0&&(ut=2*Math.PI+ut);lt=parseFloat(w.StartAngle.toFixed(14));at=parseFloat(w.EndAngle.toFixed(14));lt-=ct;at-=ct;ut>=lt&&ut<=at&&(i=w.PointIndex,a=Math.sqrt(Math.pow(Math.abs(st),2)+Math.pow(Math.abs(ht),2)),a<=w.Radius&&a>kt&&(ft={Region:{PointIndex:i},SeriesIndex:e.SeriesIndex,type:e.type},o=ft))}else if(tt.type.toLowerCase()=="radar"&&(w=e.Region.Bounds,w.Line1)){y=w.Line1;c=w.Line2;l=w.Line3;v=w.Line4;var p=[{x:y.x,y:y.y},{x:c.x,y:c.y},{x:l.x,y:l.y},],b={x:u,y:f},et=!1;if(tt.drawType.toLowerCase()=="column")for(var rt=!1,s=-1,pt=p.length,h=pt-1;++s<pt;h=s)(p[s].y<=b.y&&b.y<p[h].y||p[h].y<=b.y&&b.y<p[s].y)&&b.x<(p[h].x-p[s].x)*(b.y-p[s].y)/(p[h].y-p[s].y)+p[s].x&&(rt=!rt);else for(d=[{x:y.x,y:y.y},{x:c.x,y:c.y},{x:l.x,y:l.y},{x:v.x,y:v.y}],s=0,h=2,rt=!1,ot=0;ot<d.length;ot++)(d[s].y<=b.y&&b.y<d[h].y||d[h].y<=b.y&&b.y<d[s].y)&&b.x<(d[h].x-d[s].x)*(b.y-d[s].y)/(d[h].y-d[s].y)+d[s].x&&(rt=!rt),nt=s,s=h,h=++nt,ot==2&&(h=0);et=rt;et&&(i=w.PointIndex,ft={Region:{PointIndex:i},SeriesIndex:e.SeriesIndex,type:e.type},o=ft)}}else if(vt=$(n.target)[0].nodeName,(vt=="path"||vt=="shape")&&$($(n.target).parent())[0].id==t.svgObject.id+"_SeriesGroup_"+e.SeriesIndex)return i=$(n.target)[0].id.match(/(\d+)/g),it=parseInt(i[i.length-1]),e={Region:{PointIndex:it},SeriesIndex:e.SeriesIndex,type:e.type},o=e,!1}else u>=e.Region.Bounds.X&&u<=e.Region.Bounds.X+e.Region.Bounds.Width&&f>e.Region.Bounds.Y&&f<e.Region.Bounds.Y+e.Region.Bounds.Height&&(o=e)}),o)return{region:o,location:{x:u,y:f}}}else if(t=this,y=t.model.chartRegions,y.length>0&&(y[0].Series.type.toLowerCase()=="pyramid"||y[0].Series.type.toLowerCase()=="funnel")){if(d=$(n.target)[0].nodeName,(d=="path"||d=="shape")&&$($(n.target).parent())[0].id==t.svgObject.id+"_SeriesGroup_"+y[0].SeriesIndex)return r=t.model.chartRegions[0],p=$(n.target)[0].id.match(/(\d+)/g),p=parseInt(p[p.length-1]),r.Region.PointIndex=p,i={},i.pointIndex=p,o={region:r,pointData:i,location:{x:u,y:f}};r=y[0];var s=this.pyrX,h=this.pyrY,i={},g,w,c,l,v,nt,tt;for(e=0;e<r.Region.length;e++)if(w=r.Region[e].Line1,c=r.Region[e].Line2,l=r.Region[e].Line3,v=r.Region[e].Line4,y[0].Series.type.toLowerCase()=="pyramid"?g=[{x:w.x+s,y:w.y+h},{x:c.x+s,y:c.y+h},{x:l.x+s,y:l.y+h},{x:v.x+s,y:v.y+h}]:(nt=r.Region[e].Line5,tt=r.Region[e].Line6,g=[{x:w.x+s,y:w.y+h},{x:c.x+s,y:c.y+h},{x:l.x+s,y:l.y+h},{x:v.x+s,y:v.y+h},{x:nt.x+s,y:nt.y+h},{x:tt.x+s,y:tt.y+h}]),ft={x:u,y:f},et=this.isPointInPolygon(g,ft),et)return i.pointIndex=r.Region[e].PointIndex,r.Region.PointIndex=i.pointIndex,o={region:r,pointData:i,location:{x:u,y:f}}}else return $.each(t.model.chartRegions,function(n,r){var g=-.5*Math.PI,w=r.SeriesData,c=r.Region,nt=t.model._visibleSeries[r.SeriesIndex].type.toLowerCase()=="doughnut"?w.DRadius:0,k,d,tt,p,h,v,e,s,it,rt,ut;k=u-w.CenterX;d=f-w.CenterY;var l=t.model._visibleSeries[r.SeriesIndex],b=l.startAngle,y=l.endAngle;if(b=b<0?b+360:b,y=y<0?y+360:y,tt=l.endAngle-l.startAngle,tt<0){for(y=y/360,p=y?2*Math.PI*(y<0?1+y:y):0,h=(Math.atan2(d,k)-g-p)%(2*Math.PI),h<0&&(h=2*Math.PI+h),i=[],v=0;v<c.length;v++)if(e=parseFloat(c[v].StartAngle.toFixed(14)),s=parseFloat(c[v].EndAngle.toFixed(14)),e=e<0?2*Math.PI+e:e,s=s<0?2*Math.PI+s:s,e-=p,s-=p,e=parseFloat(e.toFixed(14)),s=parseFloat(s.toFixed(14)),l.startAngle>=0&&l.endAngle<=0&&(e=e<=0?2*Math.PI+e:e,s=s<0?2*Math.PI+s:s),h<=e&&h>=s){i.push(c[v]);break}}else for(p=b?2*Math.PI*(t.model.itemCurrentXPos<0?1+t.model.itemCurrentXPos:t.model.itemCurrentXPos):0,h=(Math.atan2(d,k)-g-p)%(2*Math.PI),h<0&&(h=t.model._isPieOfPie?h:2*Math.PI+h),i=[],v=0;v<c.length;v++)if(e=parseFloat(c[v].StartAngle.toFixed(14)),s=parseFloat(c[v].EndAngle.toFixed(14)),e=e<0?t.model._isPieOfPie?e:2*Math.PI+e:e,s=s<0?2*Math.PI+s:s,e-=p,s-=p,e=parseFloat(e.toFixed(14)),s=parseFloat(s.toFixed(14)),l.startAngle<0&&(l.endAngle>-1||l.endAngle==null)&&(e=e<0?2*Math.PI+e:e,s=s<=0?2*Math.PI+s:s),h+2*Math.PI<s&&l.type=="pieofpie"&&(h=h+2*Math.PI),h>=e&&h<=s){i.push(c[v]);break}i.length>0&&(it=l.explodeAll||l.explodeIndex==i[0].PointIndex,it?(rt=u-i[0].StartX,ut=f-i[0].StartY,i.length>0&&(a=Math.sqrt(Math.pow(Math.abs(rt),2)+Math.pow(Math.abs(ut),2)),a<=w.Radius&&a>nt&&(c.PointIndex=i[0].PointIndex,c.Index=i[0].Index,c.SeriesIndex=i[0].SeriesIndex,o={region:r,pointData:i,location:{x:u,y:f}}))):(a=Math.sqrt(Math.pow(Math.abs(k),2)+Math.pow(Math.abs(d),2)),a<=w.Radius&&a>nt&&(c.PointIndex=i[0].PointIndex,c.Index=i[0].Index,c.SeriesIndex=i[0].SeriesIndex,o={region:r,pointData:i,location:{x:u,y:f}})))}),o},isPointInPolygon:function(n,t){for(var u=!1,i=-1,f=n.length,r=f-1;++i<f;r=i)(n[i].y<=t.y&&t.y<n[r].y||n[r].y<=t.y&&t.y<n[i].y)&&t.x<(n[r].x-n[i].x)*(t.y-n[i].y)/(n[r].y-n[i].y)+n[i].x&&(u=!u);return u},mousePosition:function(n){if(!ej.util.isNullOrUndefined(n.pageX)&&n.pageX>0)return{x:n.pageX,y:n.pageY};if(n.originalEvent&&!ej.util.isNullOrUndefined(n.originalEvent.pageX)&&n.originalEvent.pageX>0)return{x:n.originalEvent.pageX,y:n.originalEvent.pageY};if(n.originalEvent&&n.originalEvent.changedTouches!=undefined){if(!ej.util.isNullOrUndefined(n.originalEvent.changedTouches[0].pageX)&&n.originalEvent.changedTouches[0].pageX>0)return{x:n.originalEvent.changedTouches[0].pageX,y:n.originalEvent.changedTouches[0].pageY}}else return{x:0,y:0}},calMousePosition:function(n){var u=jQuery.uaMatch(navigator.userAgent),t=this.mousePosition(n),i,r,f;return n.pageX=t.x,n.pageY=t.y,f=u.browser.toLowerCase(),i=n.pageX-$(this.svgObject).offset().left,r=n.pageY-$(this.svgObject).offset().top,{X:i,Y:r}},calTouchPosition:function(n){var u=jQuery.uaMatch(navigator.userAgent),i,r,t;return u.browser.toLowerCase()=="mozilla"||u.browser.toLowerCase()=="webkit"?(t=n.originalEvent.touches[0],i=t.pageX-$(this.svgObject).parent().offset().left,r=t.pageY-$(this.svgObject).parent().offset().top,this.leftPadding=$(this.svgObject).offset().left,this.grabPadding=0):u.browser.toLowerCase()=="msie"?(i=n.originalEvent.pageX-$(this.svgObject).offset().left,r=n.originalEvent.pageY-$(this.svgObject).offset().top,this.leftPadding=$(this.svgObject).offset().left):(t=n.originalEvent.touches[0],i=t.pageX-$(this.svgObject).offset().left,r=t.pageY-$(this.svgObject).offset().top,this.leftPadding=$(this.svgObject).offset().left),{X:i,Y:r}},cancelEvent:function(n){n.stopPropagation();var t=jQuery.uaMatch(navigator.userAgent);return t.browser=="chrome"&&(this.model.zooming.enable||this.model.crosshair.visible)&&n.preventDefault(),this.model.enable3D&&(n.preventDefault(),n.stopPropagation()),n.returnValue=!1,n.cancelBubble=!0,!1},resetZoom:function(){var n=this,t="#"+this.svgObject.id;$(".tooltipDiv"+this._id).remove();$(".zoom"+this._id).remove();n.zoomed&&($.each(this.model._axes,function(n,t){t.zoomed=!1;t.zoomFactor=1;t.zoomPosition=0}),n.model.primaryXAxis.zoomFactor=1,n.model.primaryYAxis.zoomFactor=1,n.model.primaryXAxis.zoomPosition=0,n.model.primaryYAxis.zoomPosition=0,$("#"+n._id+"_canvas").css({cursor:"default"}),$(t+"_ResetZoom").remove(),$(t+"_PanBtn").remove(),$(t+"_ZoomBtn").remove(),$(t+"_ZoomInBtn").remove(),$(t+"_ZoomOutBtn").remove(),n.zoomed=!1,n.zooming=!1,n.panning=!1,n.model._chartAreaZoom=!1,n.resetZooming=!0,n.enableTrackBall(),n.redraw(!0),n.enableAnimation(),n.svgRenderer._setAttr($(n.svgObject).find(t+"_XAxis,"+t+"_ChartArea,"+t+"_YAxis,"+t+"_SeriesCollection"),{cursor:"default"}))},startZoomInOut:function(n){var c=n.target.id.indexOf("ZoomIn")>-1?"zoomIn":"zoomOut",e,o;this.drag=!1;this.zoomed=!0;var i=this.model.zooming.type.toLowerCase(),r=c=="zoomIn"?.2:-.2,s=!0,t,u,f,h;for(e=0;e<this.model._axes.length;e++)t=this.model._axes[e],u=t.zoomFactor,f=t.zoomPosition,t.orientation.toLowerCase()=="horizontal"?(t.zoomFactor=i!="y"?u-r:t.zoomFactor,t.zoomPosition=i!="y"?f+r:t.zoomPosition):(t.zoomFactor=i!="x"?u-r:t.zoomFactor,t.zoomPosition=i!="x"?f+r:t.zoomPosition),parseFloat(t.zoomFactor.toFixed(3))<=.001&&(t.zoomFactor=u,t.zoomPosition=f),parseFloat(t.zoomFactor.toFixed(3))>=1&&(t.zoomFactor=1,t.zoomPosition=0),s=s&&t.zoomFactor==1,this.resetZooming=t.zoomFactor==1&&t.zoomPosition==0;h=this._getZoomedData(this);o=$.extend({},ej.EjSvgRender.commonChartEventArgs);o.data={};o.data.series=h;this._trigger("zoomed",o);this._updateScroll();this.redraw(!0);s?(this._removeZoomkit(),this.resetZooming=!0,this.zoomed=this.panning=!1,this.model._chartAreaZoom=!1):this._enableZoomingButtons()},startZoom:function(){var n=this,t="#"+this.svgObject.id,i;$(".tooltipDiv"+this._id).remove();i=this.model.theme.toLowerCase().indexOf("dark")>=0?"#000000":" #FFFFFF";n.svgRenderer._setAttr($(t+"_ZoomBtn"),{selected:"true"});n.svgRenderer._setAttr($(t+"_ZoomPath"),{fill:"#14B9FF"});n.svgRenderer._setAttr($(t+"_ZoomIcon"),{fill:"#FFFFFF"});n.svgRenderer._setAttr($(t+"_PanPath"),{fill:"#B7B7B7"});n.svgRenderer._setAttr($(t+"_panIcon"),{fill:i});$(t+"_ZoomBtn").css({"border-color":"#14B9FF","background-color":"#14B9FF"});$(t+"_PanBtn").css({"border-color":"#B7B7B7","background-color":"#B7B7B7"});$("#"+n._id+"_canvas").css({cursor:"default"});this._cursorToDefault();n.panning=!1;n.enableTrackBall()},startPan:function(){var n=this,t="#"+this.svgObject.id,i;$(".tooltipDiv"+this._id).remove();i=this.model.theme.toLowerCase().indexOf("dark")>=0?"#000000":" #FFFFFF";n.svgRenderer._setAttr($(t+"_ZoomBtn"),{selected:"false"});n.svgRenderer._setAttr($(t+"_PanBtn"),{selected:"true"});n.svgRenderer._setAttr($(t+"_ZoomPath"),{fill:"#B7B7B7"});n.svgRenderer._setAttr($(t+"_ZoomIcon"),{fill:i});n.svgRenderer._setAttr($(t+"_PanPath"),{fill:"#14B9FF"});n.svgRenderer._setAttr($(t+"_panIcon"),{fill:"#FFFFFF"});$(t+"_ZoomBtn").css({"border-color":"#B7B7B7","background-color":"#B7B7B7"});$(t+"_PanBtn").css({"border-color":"#14B9FF","background-color":"#14B9FF"});$("#"+n._id+"_canvas").css({cursor:"pointer"});this._cursorToPointer();n.panning=!0;n.disableTrackBall()},zoomButton:function(n,t){var i=t=="zoom"?"_Zoom":t=="zoomIn"?"_ZoomIn":"_ZoomOut";var u=n*5+5,r={left:0,top:0},f=this.model.m_AreaBounds.X+(this.model.m_AreaBounds.Width-n*32-u),e=this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height+(this.model.elementSpacing-this.model.m_AreaBounds.Height),o=this.model.theme.toLowerCase().indexOf("dark")>=0?"#000000":" #FFFFFF",s={id:this.svgObject.id+i+"Path",d:"M32,27c0,2.75-2.25,5-5,5H5c-2.75,0-5-2.25-5-5V5c0-2.75,2.25-5,5-5h22c2.75,0,5,2.25,5,5V27z",fill:this.panning||t=="zoomIn"||t=="zoomOut"?"#b7b7b7":"#14B9FF",zoomId:this._id+i+"Btn",width:26,height:26,left:f+r.left,top:e+r.top,iconColor:o};ej.EjCanvasRender.prototype.zoomButton(s,t,this);t=="zoom"?this._on($("#"+this.svgObject.id+i+"Btn"),"touchstart click",this.startZoom):this._on($("#"+this.svgObject.id+i+"Btn"),"touchstart click",this.startZoomInOut)},panButton:function(n){var i=n*5+5,t={left:0,top:0},r=this.model.m_AreaBounds.X+(this.model.m_AreaBounds.Width-n*32-i),u=this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height+(this.model.elementSpacing-this.model.m_AreaBounds.Height),f=this.model.theme.toLowerCase().indexOf("dark")>=0?"#000000":" #FFFFFF",e={id:this.svgObject.id+"_PanPath",d:"M 32 27 c 0 2.75 -2.25 5 -5 5 H 5 c -2.75 0 -5 -2.25 -5 -5 V 5 c 0 -2.75 2.25 -5 5 -5 h 22 c 2.75 0 5 2.25 5 5 V 27 Z",fill:this.panning?"#14B9FF":"#b7b7b7",panId:this._id+"_PanBtn",width:26,height:26,left:r+t.left,top:u+t.top,iconColor:f};ej.EjCanvasRender.prototype.panButton(e,this);this._on($("#"+this.svgObject.id+"_PanBtn"),"touchstart click",this.startPan)},resetZoomButton:function(n){var r=n*5+5,t={left:0,top:0},u=this.model.m_AreaBounds.X+(this.model.m_AreaBounds.Width-(n*32+r)),f=this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height+(this.model.elementSpacing-this.model.m_AreaBounds.Height),e=this.model.theme.toLowerCase().indexOf("dark")>=0?"#000000":" #FFFFFF",o={id:this.svgObject.id+"_ResetZoomPath",d:"M 32 27 c 0 2.75 -2.25 5 -5 5 H 5 c -2.75 0 -5 -2.25 -5 -5 V 5 c 0 -2.75 2.25 -5 5 -5 h 22 c 2.75 0 5 2.25 5 5 V 27 Z",fill:"#b7b7b7",resetZoomId:this._id+"_ResetZoom",width:26,height:26,left:u+t.left,top:f+t.top,iconColor:e},i;ej.EjCanvasRender.prototype.resetZoom(o,this);i=(window.TouchEvent?"touchstart":window.PointerEvent?"pointerdown":window.MSPointerEvent?"MSPointerDown":"click")+" click";this._on($("#"+this.svgObject.id+"_ResetZoom"),i,this.resetZoom)},doZoom:function(n,t,i){var u=this,h,a,v,e,s;if(this.model._chartAreaZoom=!0,this.scrollDraw=!0,$(".tooltipDiv"+this._id).remove(),u.model.enableCanvasRendering)var c=$("#"+this.svgObject.id+"_ZoomArea")[0].getClientRects()[0],l=$("#"+this.svgObject.id)[0].getClientRects()[0],a=c.left-l.left-$(document).scrollLeft(),v=c.top-l.top-$(document).scrollTop();else a=parseFloat(u.svgRenderer._getAttrVal($(n),"x")),v=parseFloat(u.svgRenderer._getAttrVal($(n),"y"));for($("#"+this.svgObject.id+"_ZoomArea").remove(),this.drag=!1,this.zoomed=!0,e=0;e<this.model._axes.length;e++){var r=this.model._axes[e],f=r.zoomFactor,o=r.zoomPosition;r.orientation.toLowerCase()=="horizontal"?(r.zoomFactor=u.model.zooming.type.toLowerCase()!="y"?f*(t/u.model.m_AreaBounds.Width):r.zoomFactor,r.zoomPosition=u.model.zooming.type.toLowerCase()!="y"?o+Math.abs((a-u.model.m_AreaBounds.X)/u.model.m_AreaBounds.Width)*f:r.zoomPosition,parseFloat(r.zoomFactor.toFixed(3))<=.001&&(r.zoomFactor=f,r.zoomPosition=o)):(r.zoomFactor=u.model.zooming.type.toLowerCase()!="x"?f*i/u.model.m_AreaBounds.Height:r.zoomFactor,r.zoomPosition=u.model.zooming.type.toLowerCase()!="x"?o+(1-Math.abs((i+(v-u.model.m_AreaBounds.Y))/u.model.m_AreaBounds.Height))*f:r.zoomPosition,parseFloat(r.zoomFactor.toFixed(3))<=.001&&(r.zoomFactor=f,r.zoomPosition=o))}h=this._getZoomedData(u);s=$.extend({},ej.EjSvgRender.commonChartEventArgs);s.data={};s.data.series=h;this._trigger("zoomed",s);this.disableAnimation();this.model.legendCollapsed=!1;this.redraw(!0);this._enableZoomingButtons()},_getZoomedData:function(n){for(var t,u=this.model._visibleSeries,a=u.length,f=[],c=[],i=[],e,o,s,h,l,r=0;r<a;r++){if(u[r].visibility=="visible")for(i=u[r].points,l=i.length,e=u[r].type.toLowerCase(),o=new ej.axisTypes[u[r].xAxis._valueType.toLowerCase()],o._calculateVisibleRange(u[r].xAxis,n),o=new ej.axisTypes[u[r].yAxis._valueType.toLowerCase()],o._calculateVisibleRange(u[r].yAxis,n),s=u[r].xAxis.visibleRange,h=u[r].yAxis.visibleRange,t=0;t<l;t++)s.min<=i[t].xValue&&s.max>=i[t].xValue&&h.min<=i[t].y&&h.max>=i[t].y&&(u[r]._hiloTypes?e=="rangearea"||e=="rangecolumn"||e=="waterfall"||e=="hilo"?f.push({XValue:i[t].x,High:i[t].high,Low:i[t].low}):f.push({XValue:i[t].x,High:i[t].high,Low:i[t].low,Open:i[t].open,Close:i[t].close}):f.push({XValue:i[t].x,YValue:i[t].y}));f.length!=0&&c.push({selectedData:f});f=[]}return c},_cursorToDefault:function(){var n="#"+this.svgObject.id;this.svgRenderer._setAttr($(this.svgObject).find(n+"_XAxis,"+n+"_ChartArea,"+n+"_YAxis,"+n+"_SeriesCollection,"+n+"_StriplineBehind,"+n+"_StriplineOver"),{cursor:"default"})},_cursorToPointer:function(){var n="#"+this.svgObject.id;this.svgRenderer._setAttr($(this.svgObject).find(n+"_XAxis,"+n+"_ChartArea,"+n+"_YAxis,"+n+"_SeriesCollection,"+n+"_StriplineBehind,"+n+"_StriplineOver"),{cursor:"pointer"})},removeMultiRect:function(){$(this.parentgEle).empty();this.model.selectedDataCollection=[]},multiSelectDataCalculation:function(){for(var lt,at,n,ut,tt,gt=this,r=[],it=this.selectedRectIndex,vt=this.oldRectX[it],yt=this.oldRectY[it],pt=this.oldRectWidth[it],ot=this.oldRectHeight[it],d=1,ft=0,st=this.model.series,wt=st.length,rt=this.multiAxis,bt=rt.length,kt=this.multiSelectType,c,w,g,y,p,e,o,t,f,b,a,v,u,ht,ct,ni=this.model.AreaType.toLowerCase(),s,l,dt,h,et,nt,i,k=0;k<wt;k++){if(i=st[k],ht=i.xAxis.visibleRange,ct=i.yAxis.visibleRange,lt=rt.some(function(n){return n.name.toLowerCase()==i._xAxisName.toLowerCase()}),at=rt.some(function(n){return n.name.toLowerCase()==i._yAxisName.toLowerCase()}),nt=i.selectionSettings,lt&&at&&i.visibility.toLowerCase()=="visible"){for(n=0;n<bt;n++)c=rt[n],w=d,g=ft,c.orientation.toLowerCase()=="horizontal"?(this.selectFactor=nt.rangeType.toLowerCase()!="y"?w*(pt/this.multiAxis[n].width):d,this.selectPosition=nt.rangeType.toLowerCase()!="y"?g+Math.abs((vt-this.multiAxis[n].x)/this.multiAxis[n].width)*w:ft,parseFloat(d.toFixed(3))<=.001&&(this.selectFactor=w,this.selectPosition=g)):(this.selectFactor=nt.rangeType.toLowerCase()!="x"?w*ot/this.multiAxis[n].height:d,this.selectPosition=nt.rangeType.toLowerCase()!="x"?g+(1-Math.abs((ot+(yt-this.multiAxis[n].y))/this.multiAxis[n].height))*w:ft,parseFloat(d.toFixed(3))<=.001&&(this.selectFactor=w,this.selectPosition=g)),c.visibleRange=$.extend(!0,{},c.actualRange),(this.selectFactor<1||this.selectPosition>0)&&(b=c.valueType=="logarithmic"?c.visibleRange:c.actualRange,this.selectFactor=this.selectFactor>1?1:this.selectFactor<0?0:this.selectFactor,this.selectPosition=this.selectPosition<0?0:this.selectPosition>1?1:this.selectPosition,c.isInversed?(a=c.actualRange.max-this.selectPosition*c.actualRange.delta,v=a-this.selectFactor*c.actualRange.delta,dt=!0):(a=c.actualRange.min+this.selectPosition*c.actualRange.delta,v=a+this.selectFactor*c.actualRange.delta),a<b.min&&(v=v+(b.min-a),a=b.min),v>b.max&&(a=a-(v-b.max),v=b.max),c.valueType=="logarithmic"&&(a=Math.pow(10,a),v=Math.pow(10,v)),c.visibleRange.min=Math.min(a,v),c.visibleRange.max=Math.max(a,v));if(t=i._visiblePoints,f=i.type.toLowerCase(),et=i.isTransposed,y=i.xAxis.visibleRange.min,p=i.xAxis.visibleRange.max,e=i.yAxis.visibleRange.min,o=i.yAxis.visibleRange.max,ej.util.isNullOrUndefined(r)&&(r=[]),i.selectionSettings.enable)switch(kt){case"x":for(n=0;n<t.length;n++)t[n].seriesIndex=k,u=t[n].isEmpty,s=t[n].xValue,l=t[n].y,i.xAxis.isInversed||i.yAxis.isInversed?f.indexOf("bar")>=0?f.indexOf("stacking")>=0?(h=i.stackedValue.EndValues[n],!u&&o>=h&&e<=h&&r.push(t[n])):f=="waterfall"&&!u&&o>=t[n].YValues[0]&&e<=t[n].YValues[0]?r.push(t[n]):!u&&o>=l&&e<=l&&r.push(t[n]):!u&&p>=s&&y<=s&&r.push(t[n]):et&&f.indexOf("bar")>=0?!u&&y<=s&&p>=s&&r.push(t[n]):f.indexOf("bar")>=0||i.isTransposed&&!(f.indexOf("bar")>=0)?f.indexOf("stacking")>=0?(h=i.stackedValue.EndValues[n],!u&&e<=h&&o>=h&&r.push(t[n])):f=="waterfall"&&!u&&e<=t[n].YValues[0]&&o>=t[n].YValues[0]?r.push(t[n]):!u&&e<=l&&o>=l&&r.push(t[n]):!u&&Math.round(y)<=s&&p>=s&&r.push(t[n]);break;case"y":for(n=0;n<t.length;n++)t[n].seriesIndex=k,u=t[n].isEmpty,s=t[n].xValue,l=t[n].y,i.xAxis.isInversed||i.yAxis.isInversed?f.indexOf("bar")>=0?!u&&p>=s&&y<=s&&r.push(t[n]):f.indexOf("stacking")>=0?(h=i.stackedValue.EndValues[n],!u&&e<=h&&o>=h&&r.push(t[n])):f=="waterfall"&&!u&&o>=t[n].YValues[0]&&e<=t[n].YValues[0]?r.push(t[n]):!u&&o>=l&&e<=l&&r.push(t[n]):et&&f.indexOf("bar")>=0?f.indexOf("stacking")>=0?(h=i.stackedValue.EndValues[n],!u&&e<=h&&o>=h&&r.push(t[n])):f=="waterfall"&&!u&&e<=t[n].YValues[0]&&o>=t[n].YValues[0]?r.push(t[n]):!u&&e<=l&&o>=l&&r.push(t[n]):f.indexOf("bar")>=0||i.isTransposed&&!(f.indexOf("bar")>=0)?!u&&y<=s&&p>=s&&r.push(t[n]):f.indexOf("stacking")>=0?(h=i.stackedValue.EndValues[n],!u&&e<=h&&o>=h&&r.push(t[n])):f=="waterfall"&&!u&&e<=t[n].YValues[0]&&o>=t[n].YValues[0]?r.push(t[n]):!u&&e<=l&&o>=l&&r.push(t[n]);break;case"xy":for(n=0;n<t.length;n++)t[n].seriesIndex=k,u=t[n].isEmpty,s=t[n].xValue,l=t[n].y,f.indexOf("stacking")>=0?(h=i.stackedValue.EndValues[n],!u&&p>=s&&y<=s&&e<=h&&o>=h&&r.push(t[n])):f=="waterfall"&&!u&&p>=s&&y<=s&&e<=t[n].YValues[0]&&o>=t[n].YValues[0]?r.push(t[n]):!u&&p>=s&&Math.round(y)<=s&&e<=l&&o>=l&&r.push(t[n])}}i.xAxis.visibleRange=ht;i.yAxis.visibleRange=ct}ut=this.currentIndex;(ej.util.isNullOrUndefined(this.model.selectedDataCollection)||$("#"+this.svgObject.id+"_rectSelectionGroup").length==0)&&(this.model.selectedDataCollection=[]);this.removeRect?this.model.selectedDataCollection.splice(ut,1):this.rectPan||this.resize?(this.model.selectedDataCollection[ut]=0,this.model.selectedDataCollection[ut]=r):this.model.selectedDataCollection[this.model.selectedDataCollection.length]=r;tt=$.extend({},ej.EjSvgRender.commonChartEventArgs);tt.data={};tt.data.selectedData=r;tt.data.selectedDataCollection=this.model.selectedDataCollection;this._trigger("rangeSelected",tt)},multiSelectMouseUp:function(n){var a,v,y,p,w,b,k,d,s,g;if(this._isMultiSelect&&this.multiSelectMode=="range"){var h,c,l,i=this.svgObject.id,t=this.selectedRectIndex,e="#"+i+"_selectRect",r=parseInt($(e+t).attr("width")),o=parseInt($(e+t).attr("height")),u=parseInt($(e+t).attr("x")),f=parseInt($(e+t).attr("y"));if((this.multiSelectDraw||!this.removeRect||!this.resize||!this.rectPan)&&r>0&&o>0){for(a={id:i+"_resize_rightRect"+t,x:u+r-5,y:f+10,width:10,height:o-20>0?o-20:0,fill:"transparent",stroke:"transparent","stroke-width":2,cursor:"e-resize"},this.svgRenderer.drawRect(a,this.gEle),v={id:i+"_resize_bottomRect"+t,x:u,y:f+o-5,width:r-10>0?r-10:0,height:10,fill:"transparent",stroke:"transparent","stroke-width":2,cursor:"s-resize"},this.svgRenderer.drawRect(v,this.gEle),y={id:i+"_resize_leftRect"+t,x:u-5,y:f,width:10,height:o,fill:"transparent",stroke:"transparent","stroke-width":2,cursor:"w-resize"},this.svgRenderer.drawRect(y,this.gEle),p={id:i+"_resize_topRect"+t,x:u,y:f-5,width:r-10>0?r-10:0,height:10,fill:"transparent",stroke:"transparent","stroke-width":2,cursor:"n-resize"},this.svgRenderer.drawRect(p,this.gEle),w={id:i+"_resize_bottomRightCornerCircle"+t,cx:u+r,cy:f+o,r:10,fill:"transparent",stroke:"transparent","stroke-width":2,cursor:"se-resize"},this.svgRenderer.drawCircle(w,this.gEle),b={id:i+"_closeTopRightCornerCircle"+t,cx:u+r,cy:f,r:10,fill:"white",stroke:"#2988d6","stroke-width":2,cursor:"pointer"},this.svgRenderer.drawCircle(b,this.gEle),k={id:i+"_closePath"+t,x1:u+r-4,y1:f-4,x2:u+r+4,y2:f+4,stroke:"#2988d6","stroke-width":2,cursor:"pointer"},this.svgRenderer.drawLine(k,this.gEle),d={id:i+"_closePathOpposite"+t,x1:u+r+4,y1:f-4,x2:u+r-4,y2:f+4,stroke:"#2988d6","stroke-width":2,cursor:"pointer"},this.svgRenderer.drawLine(d,this.gEle),h=[16,10,4,10,4,4],c=[4,4,4,10,10,16],l=["a","b","c","d","e","f"],s=0;s<6;s++)g={id:i+"_gripCircle_"+l[s]+t,cx:u+r-h[s],cy:f+o-c[s],r:.4,stroke:"#5B5B5B","stroke-width":2},this.svgRenderer.drawCircle(g,this.gripCollection);this.gripCollection!=null&&$(this.gripCollection).appendTo(this.gEle);$("#"+i+"_gripCollection"+t).css({visibility:"hidden"})}ej.util.isNullOrUndefined(this.oldRectX)&&(this.oldRectX=[],this.oldRectY=[],this.oldRectWidth=[],this.oldRectHeight=[],this.oldReRightRectX=[],this.oldReTopRectY=[],this.oldReBottomRectY=[]);this.oldRectX[t]=parseInt($(e+t).attr("x"));this.oldRectY[t]=parseInt($(e+t).attr("y"));this.oldRectWidth[t]=parseInt($(e+t).attr("width"));this.oldRectHeight[t]=parseInt($(e+t).attr("height"));this.oldReRightRectX[t]=parseInt($("#"+i+"_resize_rightRect"+t).attr("x"));this.oldReTopRectY[t]=parseInt($("#"+i+"_resize_topRect"+t).attr("y"));this.oldReBottomRectY[t]=parseInt($("#"+i+"_resize_bottomRect"+t).attr("y"));this.oldMultiSelectType=this.multiSelectType;(this.resize||this.rectPan)&&(this.resize&&$("#"+this.svgObject.id+"_gripCollection"+t).attr({transform:""}),$("#"+i+"_closeTopRightCornerCircle"+t).css({display:"inline"}),$("#"+i+"_closePath"+t).css({display:"inline"}),$("#"+i+"_closePathOpposite"+t).css({display:"inline"}),$("#"+i+"_resize_rightRect"+t).css({cursor:"e-resize"}),$("#"+i+"_resize_leftRect"+t).css({cursor:"w-resize"}),$("#"+i+"_resize_bottomRect"+t).css({cursor:"s-resize"}),$("#"+i+"_resize_topRect"+t).css({cursor:"n-resize"}));this.drag=!1;this.removeRect&&($("#"+i+"_selectedRectGroup"+t).remove(),this.parentgEle.childNodes.length<=0&&$(this.parentgEle).remove());(this.multiSelectDraw||this.removeRect||this.resize||this.rectPan)&&r>0&&o>0&&(this.multiSelectDraw=!1,this.multiSelectDataCalculation(n));this.resize&&(this.resize=!1);this.rectPan&&(this.rectPan=!1);this.removeRect=!1;this.enableTrackBall()}},chartMouseUp:function(n){var h,t,c,r,u,p,l,b,k,i,e,o,a,v,y,s,f;if(this.isTouch(n)&&(this.model.touchCross=!1,this.chartMouseUpTouch(n)),!this.currentPageX&&this.panning&&(h=this.calMousePosition(n),this.currentPageX=h.X,this.currentPageY=h.Y),i=this,t=this.model,this.mousedownPointX=this.mousedownPointY=null,$("[id*=_PreviewSeries]").remove(),$("[id*=_Marker]").remove(),i.dragPoint){c=this.dragIndex.seriesIndex;r=t._visibleSeries[c];this.model.enableCanvasRendering||this.gPreviewSeriesGroupEle&&($(this.svgObject).find("#"+this.svgObject.id+"_PreviewSeriesGroup_"+c).remove(),this.gPreviewSeriesGroupEle.childNodes.length>0&&this.gPreviewSeriesGroupEle.removeChild(this.gPreviewSeriesGroupEle.childNodes[0]));this.dragPoint=r.dragPoint=!1;var w=this._getDraggedPoint(r,this.mousemoveX,this.mousemoveY),it=w.X,rt=w.Y;p=r.data.seriesIndex;l=r.data.pointIndex;b={X:this.commonDragEventArgs.data.oldValue.X,Y:this.commonDragEventArgs.data.oldValue.Y};k={X:it,Y:rt};u=$.extend({},this.commonDragEventArgs);u.data={series:r,seriesIndex:p,pointIndex:l,oldValue:b,newValue:k};this._trigger("dragEnd",u);i.commonDragEventArgs=u;i._changeDraggingPoints(r,l,u.data.newValue.X,u.data.newValue.Y);r.region=null;this.redraw()}if(this.multiSelectAreaType!="cartesianaxes"||t.zooming.enable||t.enableCanvasRendering||this.multiSelectMouseUp(n),i=this,t.zooming.enable&&t.AreaType=="cartesianaxes"){if(e=$("#"+this.svgObject.id+"_ZoomArea"),e[0])if(t.enableCanvasRendering)var d=e[0].getClientRects()[0],g=d.width,nt=d.height;else var tt=$(e),g=parseFloat(this.svgRenderer._getAttrVal(tt,"width")),nt=parseFloat(this.svgRenderer._getAttrVal(tt,"height"));g>0&&nt>0?i.doZoom(e,g,nt):this.drag=!1;i.panning||this.enableTrackBall()}o=this.svgObject.id;a=ej.util.isNullOrUndefined(n.target.parentNode)?"":n.target.parentNode.id;(a==o+"_ResetZoom"||a==o+"_ZoomBtn"||n.target.id==o+"_ResetZoom"||n.target.id==o+"_ZoomBtn")&&(this.panning=!1,this.model._chartAreaZoom=!1);(ej.isTouchDevice()||t.zooming.enableDeferredZoom)&&this.panning&&this.doPan&&t.AreaType=="cartesianaxes"&&(v={x:this.oPreviousCoords.x-this.currentPageX,y:this.oPreviousCoords.y-this.currentPageY},this.oPreviousCoords={x:this.currentPageX,y:this.currentPageY},$.each(t._axes,function(n,t){var r=Math.max(1/ej.EjSvgRender.utils._minMax(t.zoomFactor,0,1),1);i.translate(t,v.x,v.y,r)}),this.model.legendCollapsed=!1,s=y=$.extend({},ej.EjSvgRender.commonChartEventArgs),f=this,y.data={model:this.model},this._trigger("panStart",y),window.setTimeout(function(){f.redraw(!0,!0,n.target);f._cursorToPointer();f._enableZoomingButtons();s=$.extend({},ej.EjSvgRender.commonChartEventArgs);s.data={model:f.model};f._trigger("panEnd",s)},10));this.doPan&&(this.doPan=!1);this.rotateActivate=!1},multiSelectMouseDown:function(evt){var i,k;this.multiSelectAreaType=this.model.AreaType.toLowerCase();var model=this.model,chartX=model.m_AreaBounds.X,chartWidth=model.m_AreaBounds.Width,chartY=model.m_AreaBounds.Y,chartHeight=model.m_AreaBounds.Height,mouseDownCords=this.calMousePosition(evt);if(this.multiSelectAreaType=="cartesianaxes"&&!model.zooming.enable&&!model.enableCanvasRendering&&mouseDownCords.X>=chartX&&mouseDownCords.X<chartX+chartWidth&&mouseDownCords.Y<chartY+chartHeight&&mouseDownCords.Y>=chartY){var seriesCollection=this.model.series,seriesCollectionLength=seriesCollection.length,id,mouseDownCords,matchStr,containerSvg=this.svgObject.id,selectMode=seriesCollection.some(function(n){return n.selectionSettings.mode.toLowerCase()=="range"});for(this._isMultiSelect=seriesCollection.some(function(n){return n.selectionSettings.enable==!0&&n.selectionSettings.mode.toLowerCase()=="range"}),selectMode&&(this.multiSelectMode="range"),i=0;i<seriesCollectionLength;i++)seriesCollection[i].selectionSettings.enable==!0&&seriesCollection[i].selectionSettings.mode.toLowerCase()=="range"&&(this.multiSelectType=seriesCollection[i].selectionSettings.rangeType.toLowerCase());if(this._isMultiSelect&&this.multiSelectMode=="range"){this.disableTrackBall();mouseDownCords=this.calMousePosition(evt);this.mouseDownX=mouseDownCords.X;this.mouseDownY=mouseDownCords.Y;this.drag=!0;$(this.parentgEle).find("g").length<1?this.selectedRectIndex=0:(id=$(this.parentgEle).find("g").last().attr("id"),matchStr=containerSvg+"_gripCollection",id=parseInt(id.substr(matchStr.length)),this.selectedRectIndex=id+1);$(this.parentgEle).find("g").length==0&&(this.parentgEle=this.svgRenderer.createGroup({id:containerSvg+"_rectSelectionGroup"}));this.gEle=this.svgRenderer.createGroup({id:containerSvg+"_selectedRectGroup"+this.selectedRectIndex});$(this.gripCollection).find("g").length==0&&(this.gripCollection=this.svgRenderer.createGroup({id:containerSvg+"_gripCollection"+this.selectedRectIndex}));evt.target.id.indexOf("resize")>=0&&(id=evt.target.id.split("resize")[1].match(/\d+/)[0],this.selectedRectIndex=eval(id));evt.target.id.indexOf("close")>=0&&(id=evt.target.id.split("close")[1].match(/\d+/)[0],this.selectedRectIndex=eval(id));evt.target.id.indexOf(this.svgObject.id+"_selectRect")>=0&&(matchStr=this.svgObject.id+"_selectRect",this.selectedRectIndex=parseInt(evt.target.id.substr(matchStr.length)));this.currentIndex=$(evt.target.parentNode).index();var axes=this.model._axes,axesLength=axes.length,axis,mouseMoveCords=this.calMousePosition(evt),mouseMoveX=mouseMoveCords.X,mouseMoveY=mouseMoveCords.Y;for(this.multiAxis=[],k=0;k<axesLength;k++)axis=axes[k],mouseMoveX>axis.Location.X1&&mouseMoveX<axis.Location.X2&&this.multiAxis.push(axis),mouseMoveY<axis.Location.Y1&&mouseMoveY>axis.Location.Y2&&this.multiAxis.push(axis)}}},_grab:function(n,t,i,r,u){var f=$.extend({},ej.EjSvgRender.commonChartEventArgs);f.data={seriesIndex:i,pointIndex:r,currentPoint:u};t._trigger("dragStart",f);n.data=f.data;this.commonDragEventArgs=f;this.mousedownPointX=this.mousedownPointY=null},_enableDragging:function(n,t,i){var e=this,u,o,r=n.type.toLowerCase(),l=e.model.AreaType,a=n.visibility.toLowerCase(),h,c,s,f;if(this.mousedownPointX&&this.mousedownPointY&&l=="cartesianaxes"&&!this.model.enable3D&&a=="visible"&&(r=="line"||r=="spline"||r=="area"||r=="stepline"||r=="steparea"||r=="splinearea"||r=="column"||r=="bar"||r=="bubble"||r=="scatter")&&(h=[],c=[],u=this.getClosesPointXY(c,h,n,this.mousedownPointX,this.mousedownPointY,i),this.mousemoveX=this.mousedownPointX,this.mousemoveY=this.mousedownPointY,o=this.GetSeriesPoint(i),ej.util.isNullOrUndefined(u.point)||(this.dragPoint=n.dragPoint=!0,u.seriesIndex=t,n.pointData=u,s={xValue:u.point.xValue,yValue:u.point.YValues},e._grab(n,e,t,u.index,s),this.dragIndex={pointIndex:u.index,seriesIndex:t}),!ej.util.isNullOrUndefined(o)&&(f=o.region,t==f.SeriesIndex))){n.region=o.region;this.dragPoint=n.dragPoint=!0;var v=n._visiblePoints[f.Region.PointIndex].xValue,y=n._visiblePoints[f.Region.PointIndex].YValues,s={xValue:v,yValue:y};e._grab(n,e,f.SeriesIndex,f.Region.PointIndex,s);this.dragIndex={pointIndex:f.Region.PointIndex,seriesIndex:f.SeriesIndex}}},chartMouseDown:function(e){var model=this.model,matchStr=this._id+"_scrollbar_",parentNodeId=e.target.parentNode&&e.target.parentNode.id?e.target.parentNode.id:"",selectionIndex=parentNodeId.indexOf(matchStr)>-1?parseInt(parentNodeId.substr(matchStr.length)):NaN,isZoom=this.isZoomButtonHovered(e.target),axes=model._axes,chart=this,id,mouseDownCords=this.calMousePosition(e),browserInfo=this.model.browserInfo,timer,parent,isZoomToolkit,mousePanCords;this.mousedownPointX=mouseDownCords.X;this.mousedownPointY=mouseDownCords.Y;"which"in e?this.chartRightClick=e.which==3:"button"in e&&(this.chartRightClick=e.button==2);isNaN(selectionIndex)||ej.util.isNullOrUndefined(selectionIndex)||(axes[selectionIndex].previousRange=$.extend(!0,{},model._axes[selectionIndex].visibleRange));this.mousemoveX=this.mouseDownX=mouseDownCords.X;this.mousemoveY=this.mouseDownY=mouseDownCords.Y;this.isTouch(e)&&(this.model.event=e,this.model.touchCross=!0,$.finish?$(this.model.trackerElement).finish():$(this.model.trackerElement).stop(!0,!0),this.model.tapNum=this.model.tapNum||0,isZoom||this.doubleTap(e),chart.model.crosshair.visible&&!isZoom&&(timer=setTimeout(function(){var n=$("#"+chart.svgObject.id).find("#"+chart.svgObject.id+"_ZoomArea"),t=chart.model.elementSpacing/2,i=chart.getEvent(chart.model.event),r=i.pageX,u=i.pageY;chart.model.touchCross&&!chart.panning&&Math.abs(r-chart.model.cachedX)<t&&Math.abs(u-chart.model.cachedY)<t&&(n.length==0||parseFloat($(n).attr("width"))==0||parseFloat($(n).attr("height"))==0)&&(chart.chartInteractiveBehavior(e),chart.model.crosshairMoved=!0,chart.drag=!1)},500)));this.model.enable3D&&this.model.enableRotation&&(this.rotateActivate=!0);this.svgRenderer.vmlNamespace||(this.oPreviousCoords={},e.target.id.indexOf("resize")>=0&&(id=e.target.id.split("resize")[1].match(/\d+/)[0],this.selectedRectIndex=eval(id),this.multiSelectMouseDownId=e.target.id,this.resize=!0),e.target.id.indexOf("close")>=0&&(id=e.target.id.split("close")[1].match(/\d+/)[0],this.selectedRectIndex=eval(id),this.removeRect=!0),e.target.id.indexOf(this.svgObject.id+"_selectRect")>=0&&(matchStr=this.svgObject.id+"_selectRect",this.selectedRectIndex=parseInt(e.target.id.substr(matchStr.length))),e.target.id==this.svgObject.id+"_selectRect"+this.selectedRectIndex&&(this.rectPan=!0,this.PreviousCoords={X:e.pageX,Y:e.pageY}),this.isTouch(e)||this.multiSelectMouseDown(e),parent=this.svgRenderer._getAttrVal($(e.target).parent(),"id"),isZoomToolkit=parent!=this.svgObject.id+"_ZoomBtn"&&parent!=this.svgObject.id+"_ZoomInBtn"&&parent!=this.svgObject.id+"_ZoomOutBtn"&&parent!=this.svgObject.id+"_ResetZoom"&&parent!=this.svgObject.id+"_PanBtn",isZoomToolkit&&this.model.zooming.enable&&!this.model.isLazyZooming&&!this.panning&&this.model.AreaType=="cartesianaxes"?this.mouseDownX>=this.model.m_AreaBounds.X&&this.mouseDownX<model.m_AreaBounds.X+model.m_AreaBounds.Width&&this.mouseDownY<model.m_AreaBounds.Y+model.m_AreaBounds.Height&&this.mouseDownY>=model.m_AreaBounds.Y&&!this.isTouch(e)&&((isNaN(selectionIndex)||ej.util.isNullOrUndefined(selectionIndex))&&(this.drag=!0),this.disableTrackBall()):(isZoomToolkit&&this.panning||$(e.target)[0].className=="e-hhandle e-box")&&(mousePanCords=this.calMousePosition(e),this.mousePanX=mousePanCords.X,this.mousePanY=mousePanCords.Y,this.mousePanX>=model.m_AreaBounds.X&&this.mousePanX<model.m_AreaBounds.X+model.m_AreaBounds.Width&&this.mousePanY<model.m_AreaBounds.Y+model.m_AreaBounds.Height+18&&this.mousePanY>=model.m_AreaBounds.Y&&(this.doPan=!0)),(this.rotateActivate||this.doPan)&&(this.oPreviousCoords={x:e.pageX,y:e.pageY}))},chartMouseLeave:function(n){this.cancelEvent(n);this.isTouch(n)||($("[id*=_TrackSymbol]").remove(),this._removeHighlight(),this._removeTrackBall(),$("#"+this.svgObject.id+"_TrackToolTip").hide(),$("#"+this._id+"_tooltip").remove(),$(".tooltipDiv"+this._id).hasClass(this.svgObject.id)&&$(".tooltipDiv"+this._id).remove());var t=$.extend({},ej.EjSvgRender.commonChartEventArgs);t.data={location:{x:this.mousemoveX,y:this.mousemoveY},size:{height:this.model.svgHeight,width:this.model.svgWidth},id:n.target.id,pageX:n.pageX,pageY:n.pageY};this._trigger("chartMouseLeave",t)},_doClick:function(n){var gt,vt,h,e,o,d,tt,pt,it,c,y,f,t,wt,i,p,w,ft,u,et,nt,ot,st,bt,r;this.drag=!1;this.model.crosshairMoved||this._removeHighlight();this.model.selectedDataPointIndexes||(this.model.selectedDataPointIndexes=[]);this.model.clusterPoints=[];this.model._isStateChaged=!1;var i,u,kt,a,s,ht=this.getEvent(n),ct=ht.pageX,lt=ht.pageY,b=10,ui=n.target.id,fi=this.svgObject.id,k=this.model._visibleSeries,at=this.isZoomButtonHovered(n.target),v=n.target.id,dt;if(kt=k.length,s=this.GetSeriesPoint(n),s?(i=s.region.SeriesIndex,u=s.region.Region.PointIndex):this.model.selectionEnable&&(this.model.enable3D||n.target.id.indexOf("LegendItem")!=-1||this.model.AreaType=="none"||(h=n.target.id,e=h.match(/(\d+)/g),!e||h.indexOf("symbol")==-1&&h.indexOf("Series")==-1||h.indexOf("Text")!=-1?e&&(h.indexOf("Text")!=-1||h.indexOf("dataLabel")!=-1)&&(i=parseInt(e[0].charAt(1)),u=isNaN(parseInt(e[0].charAt(0)))?parseInt(e[0].charAt(1)):parseInt(e[0].charAt(0))):(i=parseInt(e[0]),u=isNaN(parseInt(e[1]))?0:parseInt(e[1])))),!at||this.model.enableCanvasRendering){for(f=0;f<this.model._visibleSeries.length;f++)if(a=this.model._visibleSeries[f],o=a.type.toLowerCase(),this.model.AreaType=="cartesianaxes"&&a.visibility.toLowerCase()=="visible"&&o!=="scatter"&&o!=="bubble"&&o!=="column"&&o.indexOf("bar")==-1&&o!=="stackingcolumn"&&o!=="stackingcolumn100"&&!a._hiloTypes){var yt=this.calMousePosition(n);this.mousemoveX=yt.X;this.mousemoveY=yt.Y;d=this.getClosesPointXY([],[],a,this.mousemoveX,this.mousemoveY,n);ej.util.isNullOrUndefined(d.point)||(i=f,u=d.index,tt=$.extend({},ej.EjSvgRender.commonChartEventArgs),tt.data={location:{x:this.mousemoveX,y:this.mousemoveY},region:{SeriesIndex:f,Region:{PointIndex:d.index}}},this._trigger("pointRegionClick",tt))}s&&(!at||this.model.enableCanvasRendering)&&(r=$.extend({},ej.EjSvgRender.commonChartEventArgs),r.data=s,this._trigger("pointRegionClick",r))}if(this.model.AreaType=="none"&&this.model.enable3D&&$(n.target)[0].nodeName=="path"&&(!this.isTouch(n)||Math.abs(ct-this.model.cachedX)<b&&Math.abs(lt-this.model.cachedY)<b))if(l=$(n.target)[0].id.match(/(\d+)/g),i=parseInt(l[l.length-2]),u=parseInt(l[l.length-1]),pt=this.model._visibleSeries[i].explodeIndex,it=this.model._visibleSeries[i]._visiblePoints[u].actualIndex,this.model._visibleSeries[i].explodeIndex=pt==it?null:it,this.vmlRendering||this.model.enableCanvasRendering||(c=this.selectedStyle(this)),$(this.svgObject).empty(),$(this.legendSvgContainer).empty(),this.draw(),this.model.AreaType=="none"){this.model._isStateChaged=!1;var g,ni=c.length,rt="_Region_Series_"+i+"_Point_"+u,ut=$(this.svgObject).find("[id$="+rt+"],[id*="+rt+"back],[id*="+rt+"front]"),ti=ut.length;for(y=0;y<ni;y++)for(f=0;f<ti;f++)c[y].id==ut[f].id&&(g=c[y].className,g.indexOf("SelectionStyle")<0&&g.indexOf("Selection"+dt+"Style")<0&&$("[id="+ut[f].id+"]").attr("class",g));c.pattern&&this.svgRenderer.append(c.pattern,this.svgObject)}else $("[id*="+this.svgObject.id+"_LegendItemShape],[id*=_Region_Series_]").each(function(){$(this).attr("class","")});if(t=this.getLegendData(n),t&&($("#template_group_"+this._id).remove(),r=$.extend({},ej.EjSvgRender.commonChartEventArgs),r.data=t,this._trigger("legendItemClick",r),i=t.legendItem.LegendItem.SeriesIndex,!this.model.legend.toggleSeriesVisibility&&t.series.selectionSettings.enable&&(this.model._isStateChaged=!1,this.legendSelection(this,t,n,s)),!r.cancel&&this.model.legend.toggleSeriesVisibility)){for($("[id*="+this._id+"_Selection_]").remove(),wt=this.model._visibleSeries.length,this.model.AreaType!="none"||this.model.AreaType=="none"&&o!="pieofpie"&&o!="pyramid"&&o!="funnel"&&wt>1?(i=t.legendItem.LegendItem.SeriesIndex,p=t.legendItem.LegendItem.TrendLineIndex,ej.util.isNullOrUndefined(p)?(t.series.visibility=t.series.visibility.toLowerCase()==="visible"?"hidden":"visible",this.model.series[i].visibility=t.series.visibility,this._notifyArrayChange&&this._notifyArrayChange("series["+i+"]visibility",t.series.visibility)):(w=t.series.trendlines[p].visibility.toLowerCase(),w=w==="visible"?"hidden":"visible",this.model.series[i].trendlines[p].visibility=w,this._notifyArrayChange&&this._notifyArrayChange("series["+i+"].trendlines["+p+"].visibility",w))):(this.model._isPieOfPie?(ft=this._getPieOfPiePoint(t.legendItem.LegendItem.ActualIndex,t.series,t)._visibility,u=t.legendItem.LegendItem.ActualIndex):(ft=t.series.visiblePoints[t.legendItem.LegendItem.PointIndex]._visibility,u=t.series.visiblePoints[t.legendItem.LegendItem.PointIndex].actualIndex),t.series.points[u]._visibility=ft==="visible"?"hidden":"visible"),this.model.enableCanvasRendering&&(et=document.getElementById(this._id).getClientRects()[0],this.svgRenderer.ctx.clearRect(0,0,et.width,et.height),$("#"+this._id).find('[id*="canvas_symbol"]').remove()),$(this.svgObject).empty(),$(this.legendSvgContainer).empty(),nt=0;nt<this.model.series.length;nt++)this.model.series[nt].regionAdded=!1;this.model.legendCollapsed=!0;this.disableAnimation();this.draw();this.enableAnimation();this.model.AreaType!="none"&&this.zoomed&&this._enableZoomingButtons()}if(ot=this.getAxisLabelData(n),ot&&(r=$.extend({},ej.EjSvgRender.commonChartEventArgs),r.data=ot,this._trigger("axisLabelClick",r)),st=this.getAxisMultiLevelLabelsData(n),st&&(r=$.extend({},ej.EjSvgRender.commonChartEventArgs),r.data=st,this._trigger("multiLevelLabelClick",r)),v.indexOf("annotation_")>=0){var ii=v.lastIndexOf("_"),ri=v.substr(ii+1,v.length),l=parseInt(ri),r=$.extend({},ej.EjSvgRender.commonChartEventArgs);r.data={location:{x:this.mousemoveX,y:this.mousemoveY},contentData:this.model.annotations[l],pageX:n.pageX,pageY:n.pageY};this._trigger("annotationClick",r)}bt=ej.isNullOrUndefined(i)?!1:this.model._visibleSeries[i].selectionSettings.enable;!ej.isNullOrUndefined(i)&&!t&&bt&&(!this.isTouch(n)||!this.model.crosshairMoved&&Math.abs(ct-this.model.cachedX)<b&&Math.abs(lt-this.model.cachedY)<b)&&(gt=k[i].selectionSettings.type.toLowerCase()=="multiple"?!0:!1,vt=k[i].selectionSettings.mode,vt.toLowerCase()!="range"&&this.segmentSelection(n,t,i,u,s,k));this.model.crosshairMoved=!1;r=$.extend({},ej.EjSvgRender.commonChartEventArgs);r.data={location:{x:this.mousemoveX,y:this.mousemoveY},size:{height:this.model.svgHeight,width:this.model.svgWidth},id:v,pageX:n.pageX,pageY:n.pageY};this._trigger("chartClick",r)},getTargetId:function(n,t,i){var r,u=this.model._visibleSeries[n].type.toLowerCase(),f=(u.indexOf("area")!=-1||u.indexOf("line")!=-1||u.indexOf("scatter")!=-1?!0:!1)?!0:!1;return this.model.enable3D?$("[id*=_Region_Series_"+n+"_Point_"+t+"]").each(function(){r=this.id}):i!="series"||this.model.AreaType=="none"?f?$("[id*="+this.svgObject.id+"_Series"+n+"_Point"+t+"_symbol]").each(function(){r=this.id}):$("[id$="+this.svgObject.id+"_Series"+n+"_Point"+t+"]").each(function(){r=this.id}):$("[id*="+this.svgObject.id+"_Series"+n+"]").each(function(){r=this.id}),r},findCanvasSelection:function(n,t,i){var r;return r=i=="point"?$("#"+this._id+"_Selection_series"+n+"_point_"+t+"_canvas").length:i=="series"?$("#"+this._id+"_Selection_series"+n+"_canvas").length:$("#"+this._id+"_Selection_Cluster_point_"+t+"_canvas").length,r==1?!0:!1},segmentSelection:function(n,t,i,r,u){var y=this.model._visibleSeries,k=y[i],rt,w,st,ht,b,ct,a,lt,f,at;if(ej.isNullOrUndefined(k))return 0;var d=k.selectionSettings,yt=d.enable,p=d.type.toLowerCase()=="multiple"?!0:!1,e=d.mode,ut=!1,vt=this,v,c,l,ft,h,s,u,o,g,et,nt,tt,ot,it;if(this.model.isSelected=!0,!ej.isNullOrUndefined(r)&&e=="cluster"){for(rt=[],ht=y[i]._visiblePoints[r].xValue,b=0,ct=y.length;b<ct;b++)for(w=y[b].points,st=w.length,a=0;a<st;a++)ht==w[a].xValue&&w[a].isEmpty==!1&&w[a].visible==!0&&(rt[rt.length]={seriesIndex:b,pointIndex:a});this.model.clusterPoints=rt}if(this.model.enableCanvasRendering||(v=this.getTargetId(i,r,e),v&&(c=$("#"+v)[0].parentNode.id,lt=$("#"+c)[0],lt!=null&&c&&(ft=c.indexOf(this.svgObject.id+"_TextGroup_")>=0||c.indexOf(this.svgObject.id+"_symbolGroup")>=0?!0:!1,c.indexOf(this.svgObject.id+"_TrackSymbol_")>=0&&(ft=!0,ut=!0)))),this.model.enableCanvasRendering?l=this.findCanvasSelection(i,r,e):(it=$("#"+v).attr("class")?$("#"+v).attr("class"):"",l=it.indexOf("Selection")!=-1?!0:!1,this.model.enable3D&&(it=$("[id*=_Region_Series_"+i+"_Point_"+r+"]").attr("class")?$("[id*=_Region_Series_"+i+"_Point_"+r+"]").attr("class"):"",l=it.indexOf("Selection")!=-1?!0:!1)),(l||!p||p)&&(this.removeSelection(i,r,y,e,p,t,l),u=this.model.selectedDataPointIndexes,o=u.length,o>0&&!this.model._isStateChaged))if(p){if(l)for(f=0;f<o;f++)h=u[f].seriesIndex,s=u[f].pointIndex,g=e=="series"&&h==i,nt=(e=="point"||this.model.AreaType=="none")&&h==i&&s==r,tt=e=="cluster"&&s==r,((g||tt)&&this.model.AreaType!="none"||nt)&&(u.splice(f,1),o=u.length,f=-1)}else for(f=0;f<o;f++)h=u[f].seriesIndex,s=u[f].pointIndex,g=e=="series"&&(h==i&&s==r||h!=i||s!=r),nt=(e=="point"||this.model.AreaType=="none")&&h==i&&s==r,tt=e=="cluster"&&s==r,(g||nt||tt)&&(u.splice(f,1),o=u.length,f=-1);if(!l&&(this.model.enableCanvasRendering?this.canvasSelection(this,n,k,t,i,r,u,d):this.selection(vt,n,k,ut,t,i,r,c,v,u),u=this.model.selectedDataPointIndexes,o=u.length,!this.model._isStateChaged))if(o>0)if(p)u.push({legendData:t,seriesIndex:i,pointIndex:r});else{for(f=0;f<o;f++)h=u[f].seriesIndex,s=u[f].pointIndex,ot=(e=="series"||e=="cluster"||this.model.AreaType=="none")&&(u[f].SeriesIndex!=i||u[f].PointIndex!=r),et=e=="point"&&u[f].SeriesIndex==i,(ot||et)&&(u.splice(f,1),o=this.model.selectedDataPointIndexes.length,f=-1);u.push({legendData:t,seriesIndex:i,pointIndex:r})}else u.push({legendData:t,seriesIndex:i,pointIndex:r});at={selectedData:this.model.selectedDataPointIndexes};this._trigger("seriesRegionClick",at)},legendSelection:function(n,t,i,r){var e=this.model.selectedDataPointIndexes?this.model.selectedDataPointIndexes:[],c=this.model._visibleSeries.length,u=n.model.AreaType=="none"&&c==1?t.legendItem.LegendItem.PointIndex:t.legendItem.LegendItem.SeriesIndex,o=t.legendItem.LegendItem.SeriesIndex,h=u,s=n.svgObject.id+"_LegendItemShape"+u,l=$("#"+s).attr("class")?$("#"+s).attr("class"):"",f;if($("#"+n._id+"_Selection_Legend"+u+"_canvas").length==1||l.indexOf("Selection")!=-1){for($("#"+n._id+"_Selection_Legend"+u+"_canvas").remove(),$("[id*="+n._id+"_Selection_series"+u+"]").remove(),$("#"+this._id+"_Selection_series"+o+"_point_"+h+"_canvas").remove(),$("#"+s).attr("class",""),$("[id*="+n.svgObject.id+"_Series"+o+"]").attr("class",""),$("[id*=_Region_Series_"+o+"]").attr("class",""),f=0;f<e.length;f++)if(e[f].seriesIndex==u||this.model.AreaType=="none"&&e[f].pointIndex==u){e.splice(f,1);break}}else n.segmentSelection(i,t,o,h,r)},chartMouseClick:function(n){this.cancelEvent(n);window.navigator.msPointerEnabled&&(n=n.originalEvent);this._doClick(n)},chartMouseDoubleClick:function(n){window.navigator.msPointerEnabled&&(n=n.originalEvent);var t=$.extend({},ej.EjSvgRender.commonChartEventArgs);t.data={location:{x:this.mousemoveX,y:this.mousemoveY},size:{height:this.model.svgHeight,width:this.model.svgWidth},id:n.target.id,pageX:n.pageX,pageY:n.pageY};this._trigger("chartDoubleClick",t)},drawTrackerSymbol:function(n,t,i,r,u,f,e){var h=n.type.toLowerCase(),a,v,y=new ej.seriesTypes[h],c=n.type.toLowerCase()=="boxandwhisker"?e:i,o=ej.EjSvgRender.utils._getTransform(n.xAxis,n.yAxis,this.model.requireInvertedAxes),p,s,l,w;a=n.isTransposed?n.yAxis.plotOffset:n.xAxis.plotOffset;v=n.isTransposed?n.xAxis.plotOffset:n.yAxis.plotOffset;p={id:this.svgObject.id+"_ClipRectTrack_"+t,x:-a,y:-v,width:o.width+a*2,height:o.height+v*2,fill:"white","stroke-width":1,stroke:"Gray"};this.model.AreaType!="none"&&(this.model.AreaType=="cartesianaxes"&&u.X+o.x<=o.x+o.width&&(u.X+o.x>=o.x||u.X==0)&&(u.Y+o.y>=o.y||u.Y==0)?this.model.crosshair.visible||h=="bubble"||h=="scatter"?(n.trackerRemoved||(s=this.svgObject.id+"_TrackSymbol_"+t,s=h=="boxandwhisker"?s+c:s,$("#"+this._id).find("[id*="+s+"]").remove(),s="canvas_trackSymbol_"+t,s=h=="boxandwhisker"?s+c:s,$("#"+this._id).find("[id*="+s+"]").remove()),l={"clip-path":"url(#"+this.svgObject.id+"_ClipRectTrack_"+t+")","class":"Tracker",id:this.svgObject.id+"_TrackSymbol_"+t+"_"+c,transform:"translate("+o.x+","+o.y+")"},this.gTrackerEle=this.svgRenderer.createGroup(l)):this.gTrackerEle=null:($("#"+this.svgObject.id+"_TrackSymbol_"+t+"_"+c).remove(),l={id:this.svgObject.id+"_TrackSymbol_"+t+"_"+c},this.gTrackerEle=this.svgRenderer.createGroup(l),this.model.enableCanvasRendering||(this.model.AreaType=="polaraxes"?this.gTrackerEle.setAttribute("clip-path","url(#"+this.svgObject.id+"_SeriesGroup_"+t+"_ClipRect)"):(this.gTrackerEle.setAttribute("clip-path","url(#"+this.svgObject.id+"_ClipRectTrack_"+t+")"),this.gTrackerEle.setAttribute("transform","translate("+o.x+","+o.y+")")))),$("#"+this.svgObject.id+"_CrosshairGroup").length==0&&(w={id:this.svgObject.id+"_CrosshairGroup",visibility:"visible"},this.gTrackball=this.svgRenderer.createGroup(w),this.svgRenderer.append(this.gTrackball,this.svgObject)),this.model.crosshair.marker.visible&&!n.isIndicator&&n._visiblePoints[i].visible&&(y.drawSymbol(t,n,i,u.X,u.Y,this,r,e),u.low&&y.drawSymbol(t,n,i,this.model.requireInvertedAxes?u.low:u.X,this.model.requireInvertedAxes?u.Y:u.low,this,r)),this.gTrackerEle&&$("#"+this.gTrackerEle.id).length<1&&this.svgRenderer.append(this.gTrackerEle,this.gTrackball));$(this.svgObject).find("#"+this.svgObject.id+"_ClipRectTrack_"+t).length!=0||this.vmlRendering||this.svgRenderer.drawClipPath(p,$("#"+this.svgObject.id+"_CrosshairGroup"))},getClosesPointXY:function(n,t,i,r,u,f){var b,s=ej.EjSvgRender.utils._getTransform(i.xAxis,i.yAxis,this.model.requireInvertedAxes),k,d,o,a,nt,p,v,y=10,g=this.isTouch(f),tt=i._visiblePoints?i._visiblePoints.length:0,w,e=i.marker?$.extend(!0,{},i.marker.size):{height:6,width:6},h,c,l;if(e.height=g&&e.height<y*2?e.height+y:e.height,e.width=g&&e.width<y*2?e.width+y:e.width,u<=s.y+s.height&&s.y<=u&&s.x<=r&&r<=s.x+s.width)for(h=0;h<tt;h++){if(o=i._visiblePoints[h],a=o.location,p=!1,nt=h,v=null,w=null,i.type=="boxandwhisker"&&!this.model.enable3D&&!ej.util.isNullOrUndefined(o.boxPlotLocation))for(c=0;c<o.boxPlotLocation.length;c++)l={X:o.boxPlotLocation[c].X,Y:o.boxPlotLocation[c].Y},o.boxPlotLocation[c].outlier==!0&&r>l.X+s.x-e.width&&r<l.X+s.x+e.width&&(v=o.x,ej.util.isNullOrUndefined(v)&&(p=o.visible),u>l.Y+s.y-e.height&&u<l.Y+s.y+e.height+y&&(w=o.boxPlotValues.outliers[c],k={X:l.X,Y:l.Y}),ej.util.isNullOrUndefined(k)||(b=o,d=h));a&&(r>a.X+s.x-e.width/2&&r<a.X+s.x+e.width/2&&(v=o.x,ej.util.isNullOrUndefined(v)&&(p=o.visible)),u>a.Y+s.y-e.height/2&&u<a.Y+s.y+e.height/2&&(w=o.YValues[0]),ej.util.isNullOrUndefined(v)&&!p||ej.util.isNullOrUndefined(w)||(b=o,d=h))}return{point:b,index:d,outlierPosition:k}},getClosestPointX:function(n,t,i,r){var e=[],f=ej.EjSvgRender.utils._getTransform(t.xAxis,t.yAxis,this.model.requireInvertedAxes),u;this.model.requireInvertedAxes?(i=Math.abs(r-(f.y+f.height)),r=Math.abs(i-f.x)):(i=Math.abs(i-f.x),r=Math.abs(r-(f.y+f.height)));var s=ej.EjSvgRender.utils._getValuebyPoint(i,r,t,this.model.requireInvertedAxes),h=this.model.requireInvertedAxes?s.PointX:s.PointX,o=[];return $.each(t.points,function(t,i){n.push(i.xValue)}),u=this.getClosest(n,h),ej.util.isNullOrUndefined(u)||(typeof u=="number"?$.each(t._visiblePoints,function(n,t){t.xValue==u&&(e.push(t),o.push(n))}):(u=u.getTime(),$.each(t._visiblePoints,function(n,t){(typeof t.xValue=="number"?t.xValue==u:t.xValue.getTime()==u)&&(e.push(t),o.push(n))}))),{point:e,index:o}},getClosest:function(n,t){var i=null,f,u,r;if(this._beforeMin=!1,this._afterMax=!1,f=Math.min.apply(null,n),u=Math.max.apply(null,n),t>=f-.5&&t<=u+.5){for(r=0;r<n.length;r++)(i==null||Math.abs(n[r]-t)<Math.abs(i-t))&&(i=n[r]);this._closest=null}else t>u?(i=n[n.length-1],this._closest=ej.util.isNullOrUndefined(this._closest)?i:i>this._closest?i:this._closest,this._afterMax=!0):(i=n[0],this._closest=ej.util.isNullOrUndefined(this._closest)?i:i<this._closest?i:this._closest,this._beforeMin=!0);return i},createTooltip:function(n,t,i){var p,k,tt,e,o,it,l,u,d,y,rt,a,nt,b,ft,v,et;i||(i=this.model._visibleSeries[n.SeriesIndex]);var ot=i.type=="pieofpie"?this._getPieOfPiePoint(n.Region.PointIndex,i):(i.type=="pie"||i.type=="doughnut")&&!this.model.enable3D?i._visiblePoints[n.Region.Index]:i._visiblePoints[n.Region.PointIndex],r=this.dragPoint?i.pointCollection[n.Region.PointIndex]:$.extend(!0,{},ot),s=10,st=i.tooltip.isReversed;if(r.visible!==!1){if(p=i.tooltip.format,i.type=="boxandwhisker"){if(k=this.calMousePosition(t),this.mousemoveX=k.X,this.mousemoveY=k.Y,tt=n.Region.Bounds?!0:!1,tt)if(n.Region.Bounds.Width==i.outlierSettings.size.width)for(e=0;e<r.boxPlotLocation.length;e++)r.boxPlotLocation[e].outlier==!0&&r.boxPlotLocation[e].X+i.outlierSettings.size.width/2>this.mousemoveX-i.xAxis.x&&r.boxPlotLocation[e].X-i.outlierSettings.size.width/2<this.mousemoveX-i.xAxis.x&&r.boxPlotLocation[e].Y+i.outlierSettings.size.height/2>this.mousemoveY-i.yAxis.y&&r.boxPlotLocation[e].Y-i.outlierSettings.size.height/2<this.mousemoveY-i.yAxis.y&&(o=this.getTooltipFormat(r,i,n.SeriesIndex,n.Region.PointIndex,p,r.boxPlotLocation[e]),r.x=o.data.x,r.y=o.text);else o=this.getTooltipFormat(r,i,n.SeriesIndex,n.Region.PointIndex,p,r.boxPlotLocation[0]),r.x=o.data.x,r.y=o.text}else o=this.getTooltipFormat(r,i,n.SeriesIndex,n.Region.PointIndex,p),r.x=o.data.x,r.y=o.data.y;it=null;l=$.extend({},ej.EjSvgRender.commonChartEventArgs);l.data={currentText:it,seriesIndex:n.SeriesIndex,pointIndex:n.Region.PointIndex,series:i};this._trigger("toolTipInitialize",l);u=$(".tooltipDiv"+this._id);$("#"+this.svgObject.id).find("#"+this.svgObject.id+"_TrackToolTip").attr("visibility","hidden");$("#"+this.svgObject.id+"_TrackToolTip").attr("visibility","hidden").hide();$(".tooltipDiv"+this._id).length==0?(this.tooltipFirst=!0,u=$("<div><\/div>").attr("class","tooltipDiv"+this._id).css({position:"absolute","z-index":"13000",display:"block"}),$(document.body).append(u),$(".tooltipDiv"+this._id).addClass(this.svgObject.id)):($(".tooltipDiv"+this._id).css("display","block"),this.tooltipFirst=!1);i.tooltip.template!=null?(d=$("#"+i.tooltip.template).clone(),$(".tooltipDiv"+this._id)[0].innerHTML="",$(d).css("display","block").appendTo(u),i.count=1,r.count=1,y=this.getSeriesColor(r,n.SeriesIndex,i),y?$(u).css("background-color",jQuery.type(y)=="array"?y[0].color:y):$(u).css("background-color",this.model.pointColors[n.Region.PointIndex]),rt={series:i,point:r},ej.util.isNullOrUndefined(l.data.currentText)?$(u).html($(u).html().parseTemplate(rt)):$(u).html($(d).html(l.data.currentText))):$(u).html(l.data.ToolTip);var h=this.model.m_AreaBounds,f=t.pageX+s,c=t.pageY+s,w=$(u).width(),ut=$(u).height(),g=document.getElementById(this.svgObject.id).getClientRects()[0];(f===undefined||f===null)&&(f=t.pageX+s);(c===undefined||c===null)&&(c=t.pageY+s);a=f;nt=c;f-$(this.svgObject).offset().left+w>h.X+h.Width&&(b=f-(w+2*s),a=b+$(document).scrollLeft());c-$(this.svgObject).offset().top+ut>h.Y+h.Height&&(b=c+ut-(h.Y+h.Height+g.top),nt=c-b+$(document).scrollTop());a<0&&(ft=$("#"+this._id)[0].getBoundingClientRect(),t.pageX<ft.width/2?a=f:($(u).css("width",f-2*s),a=0));$(u).css("left",a);$(u).css("top",nt);v=i.tooltip;v.enableAnimation&&$(u).css({"transition-property":"left,top","-moz-transition-property":"left,top","-webkit-transition-property":"left,top","-o-transition-property":"left,top","transition-duration":v.duration,"-moz-transition-duration":v.duration,"-webkit-transition-duration":this.tooltipFirst?"0s":v.duration,"-o-transition-duration":v.duration});et=$(u)[0].getBoundingClientRect();et.top<h.Y+g.top&&$(u).css("top",h.Y+g.top+$(document).scrollTop());st&&($(u).css("left",f-(w+s*2)),f-(w+s*2)<i.xAxis.x&&$(u).css("left",f))}},translate:function(n,t,i,r){var u=n.orientation.toLowerCase()=="horizontal"?t/n.width/r:i/n.height/r;n.zoomPosition=n.orientation.toLowerCase()=="horizontal"?ej.EjSvgRender.utils._minMax(n.zoomPosition+u,0,1-n.zoomFactor):ej.EjSvgRender.utils._minMax(n.zoomPosition-u,0,1-n.zoomFactor)},highlightFill:function(n,t,i,r,u){var e=t.model.seriesColors,h=t.model.pointColors,s=n.color,c=this.model._visibleSeries.length,o,f;return u&&t.model.AreaType=="none"&&(c==1?r=u.legendItem.LegendItem.PointIndex:i=u.legendItem.LegendItem.SeriesIndex),o=u?e[i]:r?t.model.series[i].points[r]?t.model.series[i].points[r].fill:null:null,f=s!=""?s:t.model.AreaType=="none"?h[r]:u?e[i]:o?o:e[i],Object.prototype.toString.call(f)==="[object Array]"&&(f=f[1].color),f},canvasHighlight:function(n,t,i,r){var o=i.highlightSettings,ft=i.data,h=o.color,l=o.opacity,a=o.border.color,v=o.border.width,k=o.pattern.toLowerCase(),bt=n.model.legend.visible,w=o.mode,c=i.seriesIndex,s=i.pointIndex,f=i.type.toLowerCase(),it=document.getElementById(n._id+"_canvas").getBoundingClientRect(),e=[],et=[],d=[],lt=this.model._visibleSeries.length,vt,yt,y,g=this.highlightFill(o,n,c,s,r),pt,rt,ut,nt,ot,i,tt,ht,st,b,ct,at,wt,u,p;if(n.model.AreaType!="none"||n.model.AreaType=="none"&&lt>1&&(w=="series"||r))for(u=0,p=n.model.chartRegions.length;u<p;u++)(w=="series"||r)&&c==n.model.chartRegions[u].SeriesIndex&&e.push(n.model.chartRegions[u].Region);else for(u=0,p=n.model.chartRegions.length;u<p;u++)c==n.model.chartRegions[u].SeriesIndex&&s==n.model.chartRegions[u].Region.PointIndex&&e.push(n.model._isPieOfPie?n._getPieOfPiePoint(n.model.chartRegions[u].Region.PointIndex,i):n.model.chartRegions[u].Region[s]);if(w=="cluster"&&n.model.Areatype!="none"&&typeof s!="undefined")for(pt=n.model._visibleSeries[c]._visiblePoints[s].xValue,u=0,p=n.model._visibleSeries.length;u<p;u++)for(rt=0;rt<n.model._visibleSeries[u]._visiblePoints.length;rt++)pt==n.model._visibleSeries[u]._visiblePoints[rt].xValue&&(d[d.length]={seriesIndex:u,pointIndex:rt});for(ut=0;ut<d.length;ut++)for(vt=d[ut].seriesIndex,yt=d[ut].pointIndex,nt=0;nt<n.model.chartRegions.length;nt++)vt==n.model.chartRegions[nt].SeriesIndex&&yt==n.model.chartRegions[nt].Region.PointIndex&&(w!="cluster"?e.push(n.model.chartRegions[nt].Region):e.push(n.model.chartRegions[nt]));if(ot=n.model.AreaType=="none"&&lt==1?s:c,(w=="series"||r)&&$("#"+n._id+"_Selection_series"+ot+"_canvas").length==0&&$("#"+n._id+"_Selection_Cluster_point_"+s+"_canvas").length==0&&$("#"+n._id+"_Selection_"+c+"_point_"+s+"_canvas").length==0)if(et=i._visiblePoints,y=this.createCanvasElement(n._id+"_Highlight_series"+c+"_canvas",n.svgWidth,n.svgHeight,it),h=k=="none"||k==""?g:this.canvasPattern(y,n,t,g,o),this.createRect(n,y),f.indexOf("column")!=-1||f.indexOf("waterfall")!=-1||f.indexOf("bar")!=-1)for(u=0;u<e.length;u++)st=$("#"+n._id+"_Selection_"+c+"_point_"+u+"_canvas").length==0?!0:!1,this.canvasSeriesRect(e[u],l,a,v,h,st,i);else f=="pie"||f=="doughnut"||f=="pieofpie"?(e=lt==1?e:e[0],this.canvasHighlightCircle(n,o,s,l,a,v,h,e,f,y)):f=="pyramid"||f=="funnel"?this.canvasHighlightPyramid(n,e[0],o,y,l,a,v,h,f):f=="bubble"?this.canvasBubbleHighlight(o,e,n,c,h,v,l,a):f=="scatter"&&this.canvasScatterHighlight(e,h,v,l,a);else if(w=="cluster"&&$("#"+n._id+"_Selection_Cluster_point_"+s+"_canvas").length==0&&this.model.AreaType!="none"&&$("#"+n._id+"_Selection_"+c+"_point_"+s+"_canvas").length==0&&$("#"+n._id+"_Selection_series"+c+"_canvas").length==0){for(u=0,p=this.model._visibleSeries.length;u<p;u++)i=this.model._visibleSeries[u],i.seriesIndex=u,et.push(i._visiblePoints[s]);for(tt=[],ht=[],y=this.createCanvasElement(n._id+"_Highlight__Cluster_point_"+s+"_canvas",n.svgWidth,n.svgHeight,it),this.createRect(n,y),u=0,p=this.model._visibleSeries.length;u<p;u++){for(tt=[],o=n.model._visibleSeries[u].highlightSettings,h=o.color,l=o.opacity,a=o.border.color,v=o.border.width,k=o.pattern.toLowerCase(),g=this.highlightFill(o,n,u,s,ot,r),h=k=="none"||k==""?g:this.canvasPattern(y,n,t,g,o),ht.push(h),b=0,ct=e.length;b<ct;b++)e[b].SeriesIndex==u&&tt.push(e[b].Region);if(f.indexOf("column")!=-1||f.indexOf("waterfall")!=-1||f.indexOf("bar")!=-1)for(st=$("#"+n._id+"_Selection_"+u+"_point_"+s+"_canvas").length==0?!0:!1,b=0,ct=tt.length;b<ct;b++)this.canvasSeriesRect(tt[b],l,a,v,h,st,i);else f=="bubble"?this.canvasBubbleHighlight(o,tt,n,u,h,v,l,a):f=="scatter"&&this.canvasScatterHighlight(tt,h,v,l,a)}}else(w=="cluster"&&this.model.AreaType=="none"||w=="point"&&$("#"+n._id+"_Selection_"+c+"_point_"+s+"_canvas").length==0&&$("#"+n._id+"_Selection_series"+c+"_canvas").length==0&&$("#"+n._id+"_Selection_Cluster_point_"+s+"_canvas").length==0)&&(et[0]=this.model._isPieOfPie?this._getPieOfPiePoint(s,i):i._visiblePoints[s],y=this.createCanvasElement(n._id+"_Highlight_"+c+"_point_"+s+"_canvas",n.svgWidth,n.svgHeight,it),this.createRect(n,y),h=k=="none"||k==""?g:this.canvasPattern(y,n,t,g,o),f.indexOf("column")!=-1||f.indexOf("waterfall")!=-1||f.indexOf("bar")!=-1?(e=[],e[0]=ft.region.Region,this.canvasSeriesRect(e[0],l,a,v,h,!0,i)):f=="pie"||f=="doughnut"||f=="pieofpie"?(e=[],e[0]=ft.pointData[0],this.canvasHighlightCircle(n,o,s,l,a,v,h,e,f,y)):f=="pyramid"||f=="funnel"?this.canvasHighlightPyramid(n,e[0],o,y,l,a,v,h,f):f=="bubble"?(e=[],e[0]=ft.region.Region,this.canvasBubbleHighlight(o,e,n,c,h,v,l,a)):f=="scatter"&&(e=[],e[0]=ft.region.Region,this.canvasScatterHighlight(e,h,v,l,a)));if(bt&&$("#"+n._id+"_Selection_Legend"+ot+"_canvas").length==0)if(w!="cluster"||r||this.model.AreaType=="none")this.canvasHighlightLegend(n,i,o,"Highlight",it,h);else for(u=0,p=d.length;u<p;u++)at=d[u].seriesIndex,wt=this.model._visibleSeries[at],this.canvasHighlightLegend(n,wt,o,"Highlight",it,ht[at]);i.visibility==="visible"&&i.marker.visible==!0&&this.model.AreaType!="none"&&this.canvasHighlightMarker(n,i,et,o,y,t,ht)},canvasSeriesRect:function(n,t,i,r,u,f,e){var o={opacity:t,stroke:i,"stroke-width":r,fill:u},s=e.cornerRadius,h,c;n&&(o.x=n.Bounds.X,o.y=n.Bounds.Y,o.width=n.Bounds.Width,o.height=n.Bounds.Height,f&&(typeof s!="object"&&s>0||s.topLeft>0||s.bottomLeft>0||s.topRight>0||s.bottomRight>0?(c=ej.EjSvgRender.utils._calculateroundedCorner(s,o),o.d=c,ej.EjCanvasRender.prototype.drawPath(o,h)):this.drawRect(o,h)))},canvasSelection:function(n,t,i,r,u,f,e,o){var ft,yt,st,dt,gt,et,h,ni,ti,ii,ht,ri,tt,nt,pt,ot,ui,ct,fi;i.seriesIndex=u;i.pointIndex=f;var it=this.model._visibleSeries,c=o.color,a=o.opacity,v=o.border.color,y=o.border.width,k=o.pattern.toLowerCase(),wt=n.model.legend.visible,d=o.mode,s=i.type.toLowerCase(),rt=document.getElementById(n._id+"_canvas").getBoundingClientRect(),l=[],ut=[],lt=this.model._visibleSeries.length,w=n.model.chartRegions,at=this.model.clusterPoints,oi={seriesIndex:u,series:i},ei=n.model.AreaType=="none"&&lt==1?f:u,g=this.highlightFill(o,n,u,f,r,e),vt,bt,kt,b,p;if(vt=w.length,n.model.AreaType!="none"||n.model.AreaType=="none"&&lt>1)for(h=0;h<vt;h++)((d=="series"||r)&&u==w[h].SeriesIndex||(d=="point"||r)&&u==w[h].SeriesIndex&&f==w[h].Region.PointIndex)&&(n.model.AreaType!="none"||d!="point"||r?l.push(w[h].Region):l.push(w[h].Region[f]));else if(vt>0){if(this.model._isPieOfPie){if(r)for(ft=0;ft<i.pieCollections.length;ft++)for(yt=i.pieCollections[ft],st=0;st<yt.length;st++)if(yt[st].actualIndex==r.legendItem.LegendItem.PointIndex){dt=ft;break}gt=i.data?i.data.pointData[0].PieSeriesIndex:dt;et=w[gt]}else et=w[0];for(bt=et.Region.length,h=0;h<bt;h++)f==et.Region[h].PointIndex&&l.push(et.Region[h])}if((d=="series"||r)&&(this.model.AreaType!="none"||this.model.AreaType=="none"&&lt>1))if(ut=i._visiblePoints,p=this.createCanvasElement(n._id+"_Selection_series"+ei+"_canvas",n.svgWidth,n.svgHeight,rt),c=k=="none"||k==""?g:this.canvasPattern(p,n,t,g,o),this.createRect(n,p),s.indexOf("column")!=-1||s.indexOf("waterfall")!=-1||s.indexOf("bar")!=-1)for(h=0;h<l.length;h++)this.canvasSeriesRect(l[h],a,v,y,c,!0,i);else s=="pie"||s=="doughnut"||s=="pieofpie"?this.canvasHighlightCircle(n,o,f,a,v,y,c,l[0],s,p):s=="bubble"?this.canvasBubbleHighlight(o,l,n,u,c,y,a,v):s=="scatter"&&this.canvasScatterHighlight(l,c,y,a,v);else if(d=="cluster"&&this.model.AreaType!="none"&&$("#"+n._id+"_Selection_Cluster_point_"+f+"_canvas").length==0){for(ni=at.length,tt=0;tt<ni;tt++)ti=at[tt].seriesIndex,ii=at[tt].pointIndex,ht=$.grep(w,function(n){return n.SeriesIndex==ti&&n.Region.PointIndex==ii}),ri=ht.length,ri>0?(l.push(ht[0]),ut.push(it[ht[0].SeriesIndex]._visiblePoints[f])):ut.push(it[tt]._visiblePoints[f]);for(this.selectedPoint=f,nt=[],pt=[],p=this.createCanvasElement(n._id+"_Selection_Cluster_point_"+f+"_canvas",n.svgWidth,n.svgHeight,rt),this.createRect(n,p),h=0,kt=it.length;h<kt;h++){for(nt=[],b=it[h].selectionSettings,c=b.color,a=b.opacity,v=b.border.color,y=b.border.width,k=b.pattern.toLowerCase(),g=this.highlightFill(b,n,h,f,r),c=k=="none"||k==""?g:this.canvasPattern(p,n,t,g,b),pt.push(c),ot=0,ui=l.length;ot<ui;ot++)l[ot].SeriesIndex==h&&nt.push(l[ot].Region);if(s.indexOf("column")!=-1||s.indexOf("waterfall")!=-1||s.indexOf("bar")!=-1)for(ct=0,fi=nt.length;ct<fi;ct++)this.canvasSeriesRect(nt[ct],a,v,y,c,!0,i);else s=="bubble"?this.canvasBubbleHighlight(b,nt,n,h,c,y,a,v):s=="scatter"&&this.canvasScatterHighlight(nt,c,y,a,v);!r&&this.model.AreaType!="none"&&wt&&(i=it[h],i.seriesIndex=h,this.canvasHighlightLegend(n,i,o,"Selection_Cluster",rt,c))}}else(d=="point"&&$("#"+n._id+"_Selection_"+u+"_point_"+f+"_canvas").length==0||this.model.AreaType=="none")&&(this.selectedPoint=f,ut[0]=this.model._isPieOfPie?this._getPieOfPiePoint(f,i):i._visiblePoints[f],p=this.createCanvasElement(n._id+"_Selection_series"+u+"_point_"+f+"_canvas",n.svgWidth,n.svgHeight,rt),this.createRect(n,p),c=k=="none"||k==""?g:this.canvasPattern(p,n,t,g,o),s.indexOf("column")!=-1||s.indexOf("waterfall")!=-1||s.indexOf("bar")!=-1?this.canvasSeriesRect(l[0],a,v,y,c,!0,i):s=="pie"||s=="doughnut"||s=="pieofpie"?this.canvasHighlightCircle(n,o,f,a,v,y,c,l,s,p):s=="pyramid"||s=="funnel"?this.canvasHighlightPyramid(n,l[0],o,p,a,v,y,c,s):s=="bubble"?this.canvasBubbleHighlight(o,l,n,u,c,y,a,v):s=="scatter"&&this.canvasScatterHighlight(l,c,y,a,v));wt&&(d!="cluster"||r)&&this.canvasHighlightLegend(n,i,o,"Selection",rt,c);i.marker.visible==!0&&this.model.AreaType!="none"&&this.canvasHighlightMarker(n,i,ut,o,p,t,pt)},createRect:function(n,t){n.model.AreaType!="none"&&(t.lineWidth=0,t.strokeStyle="transparent",t.rect(n.model.m_AreaBounds.X,n.model.m_AreaBounds.Y,n.model.m_AreaBounds.Width,n.model.m_AreaBounds.Height),t.clip(),t.stroke(),t.save())},canvasHighlightPyramid:function(n,t,i,r,u,f,e,o,s){var v=i.color!=""?i.color:n.model.pointColors[t.PointIndex],a=n.model.title.text?ej.EjSvgRender.utils._measureText(n.model.title.text,$(this.svgObject).width()-n.model.margin.left-n.model.margin.right,n.model.title.font):0,h=n.pyrX=(n.model.legend.position.toLowerCase()==="left"?n.model.LegendViewerBounds.Width:0)+n.model.elementSpacing+n.model.margin.left,c=n.pyrY=(n.model.legend.position.toLowerCase()==="top"?n.model.LegendViewerBounds.Height:0)+(n.model.title.text?n.model._titleLocation.Y+a.height:n.model.margin.top+n.model.elementSpacing),l={opacity:u,stroke:f,"stroke-width":e,fill:o,type:s,d:"M "+(h+t.Line1.x)+" "+(c+t.Line1.y)+" L "+(h+t.Line2.x)+" "+(c+t.Line2.y)+" L "+(h+t.Line3.x)+" "+(c+t.Line3.y)+" L "+(h+t.Line4.x)+" "+(c+t.Line4.y)+" z"};s=="funnel"&&(l.d="M "+(h+t.Line1.x)+" "+(c+t.Line1.y)+" L "+(h+t.Line2.x)+" "+(c+t.Line2.y)+" L "+(h+t.Line3.x)+" "+(c+t.Line3.y)+" L "+(h+t.Line4.x)+" "+(c+t.Line4.y)+" L "+(h+t.Line5.x)+" "+(c+t.Line5.y)+" L "+(h+t.Line6.x)+" "+(c+t.Line6.y)+" z");ej.EjCanvasRender.prototype.drawPath(l,r)},canvasScatterHighlight:function(n,t,i,r,u){for(var o,f={},s={},h,e=0;e<n.length;e++)o={startX:n[e].Bounds.X+n[e].Bounds.Height/2,startY:n[e].Bounds.Y+n[e].Bounds.Width/2},s.height=n[e].Bounds.Height,s.width=n[e].Bounds.Width,f={},f.ShapeSize=s,f.cx=o.startX,f.cy=o.startY,f.Style={},f.Style.BorderColor=u,f.Style.Color=t,f.Style.Opacity=r,f.Style.BorderWidth=i,ej.EjSvgRender.chartSymbol._drawCircle(o,f,this,h)},canvasBubbleHighlight:function(n,t,i,r,u,f,e,o){for(var h,l,c={},a,s=0;s<t.length;s++)h=t[s].Bounds.Height/2,l=n.color!=""?n.color:i.model.seriesColors[r],c={cx:t[s].Bounds.X-this.model.series[r].xAxis.x+h+this.canvasX,cy:t[s].Bounds.Y-this.model.series[r].yAxis.y+h+this.canvasY,r:h,fill:u,"stroke-width":f,opacity:e,stroke:o},ej.EjCanvasRender.prototype.drawCircle(c,a)},canvasHighlightCircle:function(n,t,i,r,u,f,e,o,s,h){for(var a,l,c=0;c<o.length;c++)a=t.color!=""?t.color:t.mode=="series"&&n.model._visibleSeries.length>1?n.model.pointColors[c]:n.model.pointColors[i],l={opacity:r,stroke:u,lineWidth:f,color:e,x:o[c].StartX,y:o[c].StartY,radius:n.model._isPieOfPie?n.model.circularRadius[o[c].PieSeriesIndex]:n.model.circularRadius[o[c].SeriesIndex],innerRadius:n.model.innerRadius[o[c].SeriesIndex],startAngle:o[c].StartAngle,endAngle:o[c].EndAngle,type:s},this.highlightSegment(h,l)},canvasHighlightMarker:function(n,t,i,r,u,f,e){var s=r,y=s.pattern.toLowerCase(),p=t.type.toLowerCase(),o={},w=s.color!=""?s.color:n.model.seriesColors[t.seriesIndex],b,h,a,c,v,l;for(b=y=="none"||y==""?w:this.canvasPattern(u,n,f,w,s),o.Style={},o.Style.BorderColor=s.border.color,o.Style.Opacity=s.opacity,o.Style.BorderWidth=s.border.width,l=0;l<i.length;l++)h=i[l].symbolLocation,h=p.indexOf("line")!=-1||p.indexOf("area")!=-1?i[l].location:i[l].symbolLocation,h&&(a=this.model.AreaType=="cartesianaxes"?{startX:h.X+this.canvasX,startY:h.Y+this.canvasY}:{startX:h.X,startY:h.Y},c=t.marker,v,$.each(n.model.symbolShape,function(n){c.shape.toLowerCase()==n.toLowerCase()&&(v=n)}),o.ShapeSize=c.size,o.r=Math.sqrt(c.size.height*c.size.height+c.size.width*c.size.width)/2,o.cx=a.startX,o.cy=a.startY,o.Style.Color=e?e[l]:b,ej.EjSvgRender.chartSymbol["_draw"+v](a,o,n,u))},canvasHighlightLegend:function(n,t,i,r,u,f){var s=this.model._visibleSeries.length,h,e,o=n.model.AreaType=="none"&&s==1?t.pointIndex:t.seriesIndex,a=n._id+"_"+r+"_Legend"+o+"_canvas";if($("#"+a).length==0&&o<t.points.length){h=this.createCanvasElement(n._id+"_"+r+"_Legend"+o+"_canvas",n.svgWidth,n.svgHeight,u);e=n.model.AreaType!="none"||n.model.AreaType=="none"&&s>1?n.model.legendRegion[t.seriesIndex]:n.model.legendRegion[t.pointIndex];var c={startX:e.Bounds.LegendBound.X+e.Location.startX,startY:e.Bounds.LegendBound.Y+e.Location.startY},v={svgRenderer:n.svgRenderer,svgObject:n.svgObject},l={SeriesIndex:o,Style:{Color:f,Opacity:i.opacity,Visibility:!0,BorderWidth:0,BorderColor:f},context:!0,ShapeSize:e.Style.ShapeSize};e.SymbolShape.toLowerCase()=="seriestype"?(n.legendItem=e.LegendItem,ej.EjSvgRender.chartSymbol["_draw"+e.SymbolShape](c,l,n)):ej.EjSvgRender.chartSymbol["_draw"+e.SymbolShape](c,l,v,h)}},createCanvasElement:function(n,t,i,r){var e,o,u=document.createElement("canvas"),s=jQuery(this.element).attr("id"),f;return u.setAttribute("id",n),u.height=i,u.width=t,u.style["touch-action"]&&(u.style["touch-action"]="none"),u.style["-ms-touch-action"]&&(u.style["-ms-touch-action"]="none"),this.svgRenderer.append(u,this.element),f=document.getElementById(n),f.style.left=r.left+$(document).scrollLeft()+"px",f.style.top=r.top+$(document).scrollTop()+"px",f.style.position="absolute",e=$("#"+this._id+"_canvas").offset(),o=$(f).offset(),e.left<o.left&&(f.style.left=r.left-Math.abs(e.left-o.left)+$(document).scrollLeft()+"px"),e.top<o.top&&(f.style.top=r.top-Math.abs(e.top-o.top)+$(document).scrollTop()+"px"),u.getContext("2d")},highlightSegment:function(n,t){n.save();n.beginPath();t.type=="pie"||t.type=="pieofpie"?(n.moveTo(t.x,t.y),n.arc(t.x,t.y,t.radius,t.startAngle-1.57,t.endAngle-1.57,!1)):(n.arc(t.x,t.y,t.radius,t.startAngle-1.57,t.endAngle-1.57,!1),n.arc(t.x,t.y,t.innerRadius,t.endAngle-1.57,t.startAngle-1.57,!0));n.fillStyle=t.color;n.globalAlpha=t.opacity;n.fill();n.lineWidth=t.lineWidth;n.strokeStyle=t.stroke;n.clip();n.stroke();n.closePath();n.restore()},canvasPattern:function(n,t,i,r,u){var c=u,a=c.name,l=c.pattern.toLowerCase(),e=r,s=c.opacity,v=c.border.color,y=c.border.width,o=document.createElement("canvas"),h=o.getContext("2d"),f=[];switch(l){case"chessboard":f[0]={x:0,y:0,width:10,height:10,fill:"white",stroke:"white",opacity:s,name:"rect"};f[1]={x:0,y:0,width:5,height:5,fill:e,opacity:s,name:"rect"};f[2]={x:5,y:5,width:5,height:5,fill:e,opacity:s,name:"rect"};o.width=10;o.height=10;this.loadPattern(t,f,"",h);break;case"pacman":f[0]={name:"rect",x:0,y:0,width:18,height:18,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 9.081 9.194 L 14.887 6.114 C 14.075000000000001 4.618 12.484 3.0620000000000007 10.596 3.0620000000000007 L 8.835 3.0620000000000007 C 6.138 3.063 3 6.151 3 8.723 L 3 10.402000000000001 C 3 12.974 6.138 16.063000000000002 8.835 16.063000000000002 L 10.596 16.063000000000002 C 12.681000000000001 16.063000000000002 14.431000000000001 14.303000000000003 15.131 12.549000000000003 L 9.081 9.194 z","stroke-width":1,stroke:e,fill:e};o.width=18;o.height=18;this.loadPattern(t,f,"",h);break;case"crosshatch":f[0]={x:0,y:0,width:8,height:8,fill:"white",stroke:r,opacity:s,name:"rect"};f[1]={d:"M 0 0 L 8 8 Z","stroke-width":1,stroke:e,name:"path"};f[2]={d:"M 8 0 L 0 8 Z","stroke-width":1,stroke:e,name:"path"};o.width=8;o.height=8;this.loadPattern(t,f,"",h);break;case"dots":f[0]={x:0,y:0,width:7,height:7,transform:"translate(0,0)",fill:"white",opacity:s,name:"rect"};f[1]={cx:3,cy:3,r:2,"stroke-width":1,fill:e,name:"circle"};o.width=7;o.height=7;this.loadPattern(t,f,"",h);break;case"diagonalforward":f[0]={x:0,y:0,width:6,height:6,fill:"white",stroke:r,opacity:s,name:"rect"};f[1]={d:"M 3 -3 L 9 3 M 6 6 L 0 0 M 3 9 L -3 3","stroke-width":2,stroke:e,name:"path"};o.width=6;o.height=6;this.loadPattern(t,f,"",h);break;case"diagonalbackward":f[0]={x:0,y:0,width:6,height:6,"stroke-width":2,fill:"white",stroke:r,opacity:s,name:"rect"};f[1]={d:"M 3 -3 L -3 3 M 0 6 L 6 0 M 9 3 L 3 9","stroke-width":2,stroke:e,name:"path"};o.width=6;o.height=6;this.loadPattern(t,f,"",h);break;case"grid":f[0]={name:"rect",x:0,y:0,width:6,height:6,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 1 3.5 L 11 3.5 M 0 3.5 L 11 3.5 M 0 7.5 L 11 7.5 M 0 11.5 L 11 11.5 M 5.5 0 L 5.5 12 M 11.5 0 L 11.5 12 Z","stroke-width":1,stroke:e};o.width=6;o.height=6;this.loadPattern(t,f,"",h);break;case"turquoise":f[0]={name:"rect",x:0,y:0,width:17,height:17,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 2.697 0.5319999999999996 C 3.8695005238907747 0.5319999999999996 4.82 1.4771268931071944 4.82 2.643 C 4.82 3.808873106892805 3.8695005238907747 4.754 2.697 4.754 C 1.5244994761092252 4.754 0.5739999999999998 3.808873106892805 0.5739999999999998 2.643 C 0.5739999999999998 1.4771268931071944 1.5244994761092252 0.5319999999999996 2.697 0.5319999999999996 Z","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e};f[2]={name:"path",d:"M 13.928 0.5319999999999996 C 15.100500523890776 0.5319999999999996 16.051000000000002 1.4771268931071944 16.051000000000002 2.643 C 16.051000000000002 3.808873106892805 15.100500523890776 4.754 13.928 4.754 C 12.755499476109225 4.754 11.805 3.808873106892805 11.805 2.643 C 11.805 1.4771268931071944 12.755499476109225 0.5319999999999996 13.928 0.5319999999999996 Z","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e};f[3]={name:"path",d:"M 8.313 0.5319999999999996 C 9.485500523890776 0.5319999999999996 10.436 1.4771268931071944 10.436 2.643 C 10.436 3.808873106892805 9.485500523890776 4.754 8.313 4.754 C 7.140499476109226 4.754 6.19 3.808873106892805 6.19 2.643 C 6.19 1.4771268931071944 7.140499476109226 0.5319999999999996 8.313 0.5319999999999996 Z","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e};f[4]={name:"path",d:"M 13.928 6.16 C 15.100500523890776 6.16 16.051000000000002 7.105126893107196 16.051000000000002 8.271 C 16.051000000000002 9.436873106892806 15.100500523890776 10.382000000000001 13.928 10.382000000000001 C 12.755499476109225 10.382000000000001 11.805 9.436873106892806 11.805 8.271 C 11.805 7.105126893107196 12.755499476109225 6.16 13.928 6.16 Z","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e};f[5]={name:"path",d:"M 8.313 6.16 C 9.485500523890776 6.16 10.436 7.105126893107196 10.436 8.271 C 10.436 9.436873106892806 9.485500523890776 10.382000000000001 8.313 10.382000000000001 C 7.140499476109226 10.382000000000001 6.19 9.436873106892806 6.19 8.271 C 6.19 7.105126893107196 7.140499476109226 6.16 8.313 6.16 Z","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e};f[6]={name:"path",d:"M 13.928 11.787999999999998 C 15.100500523890776 11.787999999999998 16.051000000000002 12.733126893107194 16.051000000000002 13.899 C 16.051000000000002 15.064873106892804 15.100500523890776 16.009999999999998 13.928 16.009999999999998 C 12.755499476109225 16.009999999999998 11.805 15.064873106892804 11.805 13.899 C 11.805 12.733126893107194 12.755499476109225 11.787999999999998 13.928 11.787999999999998 Z","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e};f[7]={name:"path",d:"M 8.313 11.787999999999998 C 9.485500523890776 11.787999999999998 10.436 12.733126893107194 10.436 13.899 C 10.436 15.064873106892804 9.485500523890776 16.009999999999998 8.313 16.009999999999998 C 7.140499476109226 16.009999999999998 6.19 15.064873106892804 6.19 13.899 C 6.19 12.733126893107194 7.140499476109226 11.787999999999998 8.313 11.787999999999998 Z","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e};o.width=17;o.height=17;this.loadPattern(t,f,"",h);break;case"star":f[0]={name:"rect",x:0,y:0,width:21,height:21,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 15.913 18.59 L 10.762 12.842 L 5.613 18.75 L 8.291 11.422 L 0.325 9.91 L 8.154 8.33 L 5.337 0.91 L 10.488 6.658 L 15.637 0.75 L 12.959 8.078 L 20.925 9.59 L 13.096 11.17 z","stroke-width":1,stroke:e,fill:e};o.width=21;o.height=21;this.loadPattern(t,f,"",h);break;case"triangle":f[0]={name:"rect",x:0,y:0,width:10,height:10,fill:"white",opacity:s};f[1]={name:"path",d:"M 4.987 0 L 7.48 4.847 L 9.974 9.694 L 4.987 9.694 L 0 9.694 L 2.493 4.847 z","stroke-width":1,stroke:e,fill:e};o.width=10;o.height=10;this.loadPattern(t,f,"",h);break;case"circle":f[0]={name:"rect",x:0,y:0,width:9,height:9,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"circle",cx:5.125,cy:3.875,r:3.625,"stroke-width":1,fill:e};o.width=9;o.height=9;this.loadPattern(t,f,"",h);break;case"tile":f[0]={name:"rect",x:0,y:0,width:18,height:18,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 0 9 L 0 0 L 9 0 z","stroke-width":1,stroke:e,fill:e};f[2]={name:"path",d:"M 9 9 L 9 0 L 18 0 z","stroke-width":1,stroke:e,fill:e};f[3]={name:"path",d:"M 0 18 L 0 9 L 9 9 z","stroke-width":1,stroke:e,fill:e};f[4]={name:"path",d:"M 9 18 L 9 9 L 18 9 z","stroke-width":1,stroke:e,fill:e};o.width=18;o.height=18;this.loadPattern(t,f,"",h);break;case"horizontaldash":f[0]={name:"rect",x:0,y:0,width:12,height:12,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 0 1.5 L 10 1.5 M 0 5.5 L 10 5.5 M 0 9.5 L 10 9.5 z","stroke-width":1,stroke:e,fill:e};o.width=12;o.height=12;this.loadPattern(t,f,"",h);break;case"verticaldash":f[0]={name:"rect",x:0,y:0,width:12,height:12,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 1.5 0 L 1.5 10 M 5.5 0 L 5.5 10 M 9.5 0 L 9.5 10 z","stroke-width":1,stroke:e,fill:e};o.width=12;o.height=12;this.loadPattern(t,f,"",h);break;case"rectangle":f[0]={x:0,y:0,name:"rect",width:12,height:12,fill:"white",opacity:s};f[1]={name:"rect",x:1,y:2,width:4,height:9,fill:e,opacity:s};f[2]={name:"rect",x:7,y:2,width:4,height:9,fill:e,opacity:s};o.width=12;o.height=12;this.loadPattern(t,f,"",h);break;case"box":f[0]={x:0,y:0,name:"rect",width:13,height:13,fill:"white",opacity:s};f[1]={name:"rect",x:1.5,y:1.5,width:10,height:9,fill:e,opacity:s};o.width=10;o.height=10;this.loadPattern(t,f,"",h);break;case"horizontalstripe":f[0]={name:"rect",x:0,y:0,width:10,height:12,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 0 0.5 L 10 0.5 M 0 4.5 L 10 4.5 M 0 8.5 L 10 8.5 z","stroke-width":1,stroke:e,fill:e};o.width=10;o.height=12;this.loadPattern(t,f,"",h);break;case"verticalstripe":f[0]={name:"rect",x:0,y:0,width:12,height:10,transform:"translate(0,0)",fill:"white",opacity:s};f[1]={name:"path",d:"M 0.5 0 L 0.5 10 M 4.5 0 L 4.5 10 M 8.5 0 L 8.5 10 z","stroke-width":1,stroke:e,fill:e};o.width=12;o.height=10;this.loadPattern(t,f,"",h);break;case"bubble":f[0]={name:"rect",x:0,y:0,width:20,height:20,transform:"translate(0,0)",fill:"#ffffff",opacity:s};f[1]={name:"circle",cx:5.217,cy:11.325,r:3.429,"stroke-width":1,fill:"#D0A6D1"};f[2]={name:"circle",cx:13.328,cy:6.24,r:4.884,"stroke-width":1,fill:e};f[3]={name:"circle",cx:13.277,cy:14.66,r:3.018,"stroke-width":1,fill:"#D0A6D1"};o.width=20;o.height=20;this.loadPattern(t,f,"",h);break;case"custom":o=document.getElementById(c.customPattern)}return n.createPattern(o,"repeat")},foundClasses:function(n){var t=[];return $("[id*="+n+"]").each(function(){var n=$(this).attr("class")?$(this).attr("class"):"";n.indexOf("Selection")>=0&&t.push(n)}),t},selection:function(n,t,i,r,u,f,e,o,s,h){var y=this.model.clusterPoints,vt=y?y.length:0,ht=this.model._visibleSeries,nt=ht.length,l=this.model.AreaType=="none"&&nt==1?e:f,a=i.selectionSettings,yt=this.model._visibleSeries[f].selectionSettings.type.toLowerCase()=="multiple"?!0:!1,c="series"+f,rt=!1,pt=$("#"+s).attr("name"),ut=a.pattern.toLowerCase(),b=a.mode,ct,ot,k,it,v,g,ft,tt,et,lt,at,w,p,st,d;if(o&&(ct=o.indexOf(this.svgObject.id+"_SeriesGroup_")>=0||o.indexOf(this.svgObject.id+"_Chart3D")>=0?!0:!1),(this.model.AreaType!="none"||this.model.AreaType=="none"&&b=="series"&&nt>1)&&$("style").each(function(){$(this).html().indexOf("."+n._id+"SelectionStyle"+c)>-1&&(rt=!0)}),!n.vmlRendering&&this.model.enable3D)(b=="series"||u)&&(this.model.AreaType!="none"||this.model.AreaType=="none"&&nt!=1)?(this.highlightSeries(n,f,e,"Selection",c,a,t,u,h),$("#"+this.svgObject.id+"_LegendItemShape"+l).attr("class","Selection"+c+"Style"+c+"1")):b=="cluster"&&n.model.AreaType!="none"?this.highlightCluster(n,f,e,"Selection",c,a,t,h):this.model.AreaType=="none"?(this.highlightPoint(n,f,e,"Selection",c+l,a,t,h),$("#"+this.svgObject.id+"_LegendItemShape"+l).attr("class","Selection"+c+l+"Style"+c+l+"1")):(this.highlightPoint(n,f,e,"Selection",c,a,t,h),$("#"+this.svgObject.id+"_LegendItemShape"+l).attr("class","Selection"+c+"Style"+c+"1"));else{if(b!="cluster"||u||n.model.AreaType=="none"){v={};v.name="2D";v.index=this.model.AreaType=="none"?l:f;v.api="Selection";v.color=a.color!=""?a.color:u?this.model.AreaType=="none"?this.model.pointColors[l]:this.model.seriesColors[l]:$("#"+s).attr("fill")!="none"?$("#"+s).attr("fill"):$("#"+s).attr("stroke");Object.prototype.toString.call(v.color)==="[object Array]"&&(v.color=v.color[1].color);var tt=ut=="none"||n.vmlRendering||ut==""?a.color:this.pattern(n,t,v,a),g=a.opacity,ft=a.border.color,et=a.border.width;rt||(this.model.AreaType=="none"&&((b=="series"||u)&&nt==1||b!="series"&&!u)?($("style").each(function(){$(this).html().indexOf(".SelectionStyle"+c+"Point"+l)>-1&&(rt=!0)}),rt||(this.createStyle(n,n._id+"Selection",c+"Point"+l,g,tt,ft,et),this.createStyle(n,n._id+"SelectionLegend",c+"Point"+l,g,tt,"transparent",0))):(this.model.AreaType=="none"&&nt>1||this.model.AreaType!="none")&&(this.createStyle(n,n._id+"Selection",c,g,tt,ft,et),this.createStyle(n,n._id+"SelectionLegend",c,g,tt,"transparent",0)))}if((b=="series"||u)&&(n.model.AreaType=="none"&&nt>1||n.model.AreaType!="none")){if(!ct)for(ot=$("#"+o).childNodes?$("#"+o).childNodes:[],k=0;k<ot.length;k++)$("#"+ot[k].id).attr("class",n._id+"SelectionStyle");$("[id*="+this.svgObject.id+"_Series"+l+"]").each(function(){if(this.parentNode.id==n.svgObject.id+"_SeriesGroup_"+l||this.parentNode.id==n.svgObject.id+"_symbolGroup_"+l){var t=$(this).attr("name")?n._id+"SelectionPathStyle"+c:n._id+"SelectionStyle"+c;$(this).attr("class",t)}});$("#"+this.svgObject.id+"_LegendItemShape"+l).attr("class",n._id+"SelectionLegendStyle"+c);r&&$("#"+o).remove()}else if(b!="cluster"||n.model.AreaType=="none"||ej.util.isNullOrUndefined(s)){if($("#"+s).attr("name")||s==n.svgObject.id+"_Series"+l||n.model.AreaType=="none")$("#"+s).attr("class",n._id+"SelectionStyle"+c+"Point"+l),$("#"+this.svgObject.id+"_LegendItemShape"+l).attr("class",n._id+"SelectionLegendStyle"+c+"Point"+l),r&&$("#"+o).remove();else{if($("#"+s).attr("class",n._id+"SelectionStyle"+c),this.model.commonSeriesOptions.columnFacet=="cylinder"||i.columnFacet=="cylinder")for(k=0;k<2;k++)$("#"+s.replace(/2$/,k)).attr("class",n._id+"SelectionStyle"+c);$("#"+this.svgObject.id+"_LegendItemShape"+l).attr("class",n._id+"SelectionLegendStyle"+c);$("#"+s+"_symbol").attr("class",n._id+"SelectionStyle"+c);r&&($("#"+s+"_symbol").attr("class",n._id+"SelectionStyle"+c),$("#"+o).remove())}d=$("#"+s).attr("name");d!=undefined&&(d=="candle"||d.indexOf("hilo")>=0)&&($("[id$="+s+"]").attr("class",n._id+"SelectionStyle"+c),$("#"+this.svgObject.id+"_LegendItemShape"+l).attr("class",n._id+"SelectionLegendStyle"+c))}else{for(it=this.svgObject.id+"_Series",y=n.model.clusterPoints,l=s.match(/(\d+)/g),e=parseInt(l[l.length-1]),s.indexOf("SeriesText")>=0&&(lt=this.GetSeriesPoint(t),e=lt.region.Region.PointIndex),p=0;p<y.length;p++){w=y[p].seriesIndex;c="ClusterSeries"+w;v={};v.index=w;v.name="2D";v.api="Selection"+c;a=ht[w].selectionSettings;v.color=a.color!=""?a.color:this.model.seriesColors[w];Object.prototype.toString.call(v.color)==="[object Array]"&&(v.color=v.color[1].color);g=a.opacity;var ft=a.border.color,et=a.border.width,tt=ut=="none"||n.vmlRendering||ut==""?v.color:this.pattern(n,t,v,a);$("style").each(function(){$(this).html().indexOf("."+n._id+"SelectionStyle"+c)>-1&&(at=!0)});at||(this.createStyle(n,n._id+"Selection",c,g,tt,ft,et),this.createStyle(n,n._id+"SelectionLegend",c,g,tt,"transparent",0));st=$("#"+it+y[p].seriesIndex+"_Point"+y[p].pointIndex).attr("name")?n._id+"SelectionPathStyle"+c:n._id+"SelectionStyle"+c;$("#"+it+y[p].seriesIndex+"_Point"+y[p].pointIndex).attr("class",st);$("#"+it+y[p].seriesIndex+"_Point"+y[p].pointIndex+"_symbol").attr("class",st);n.model._visibleSeries[w].visibility!="hidden"&&$("#"+this.svgObject.id+"_LegendItemShape"+w).not("[class*='Highlight']").attr("class",n._id+"SelectionLegendStyle"+c);d=$("#"+s).attr("name");d!=undefined&&(d=="candle"||d.indexOf("hilo")>=0)&&$("[id$="+it+y[p].seriesIndex+"_Point"+y[p].pointIndex+"]").attr("class","HighlightStyle"+c)}r&&($("#"+this.svgObject.id+"_Series"+w+"_Point"+e).attr("class",n._id+"SelectionStyle"+c),$("#"+this.svgObject.id+"_Series"+w+"_Point"+e+"_symbol").attr("class",n._id+"SelectionStyle"+c),$("#"+o).remove())}}},removeSelection:function(n,t,i,r,u,f,e){var a=i.length,h=this.model.clusterPoints,l,v=h?h.length:0,c,s,o;if((r=="series"||f)&&(this.model.AreaType!="none"||this.model.AreaType=="none"&&a>1))for(s=0;s<a;s++)c=i[s].selectionSettings,c.mode!="point"&&c.type.toLowerCase()=="single"||f&&c.type.toLowerCase()=="single"?($(this.svgObject).find("[id*="+this.svgObject.id+"_SeriesGroup_"+s+"],[id*="+this.svgObject.id+"_symbolGroup_"+s+"],[id*=_Region_Series_"+s+"_]").each(function(){$(this).find("*").attr("class","");$(this).attr("class","")}),$("#"+this._id+"_Selection_Legend"+s+"_canvas").remove(),$("#"+this._id+"_Selection_series"+s+"_canvas").remove(),$("[id*=_Region_Series_"+s+"]").attr("class",""),$("#"+this.svgObject.id+"_LegendItemShape"+s).attr("class","")):e&&c.type.toLowerCase()=="multiple"&&($("#"+this._id+"_Selection_series"+n+"_canvas").remove(),$("#"+this._id+"_Selection_Legend"+n+"_canvas").remove(),$("[id*=_Region_Series_"+n+"]").attr("class",""),$("[id*="+this.svgObject.id+"_Series"+n+"]").attr("class",""),$("#"+this.svgObject.id+"_LegendItemShape"+n).attr("class",""));if(r=="cluster"&&this.model.AreaType!="none"&&!f)if(u)if(this.model.enableCanvasRendering)$("[id*="+this._id+"_Selection_Cluster_point_"+t+"]").remove(),$("[id*="+this._id+"_Selection_Cluster]").length==0?$("[id*="+this._id+"_SelectionCluster_Legend]").remove():0;else{for(o=0;o<v;o++)$("[id*=_Region_Series_"+h[o].seriesIndex+"_Point_"+h[o].pointIndex+"]").attr("class",""),$("[id*="+this.svgObject.id+"_Series"+h[o].seriesIndex+"_Point"+h[o].pointIndex+"]").attr("class","");l=this.model.enable3D?this.foundClasses("_Region_Series_"+n):this.foundClasses(this.svgObject.id+"_Series"+n);l.length==0?$("[id*="+this.svgObject.id+"_LegendItemShape]").attr("class",""):0}else if(this.model.enableCanvasRendering)$("[id*="+this._id+"_Selection_Cluster]").remove(),$("[id*="+this._id+"_SelectionCluster_Legend]").remove(),this.selectedPoint=null;else for(o=0;o<v;o++)$("[id*=_Region_Series_"+h[o].seriesIndex+"_Point_]").attr("class",""),$("[id*="+this.svgObject.id+"_Series"+h[o].seriesIndex+"_Point]").attr("class",""),$("#"+this.svgObject.id+"_LegendItemShape"+h[o].seriesIndex).attr("class","");r!="point"||this.model.AreaType=="none"||f||(u?($("#"+this._id+"_Selection_series"+n+"_point_"+t+"_canvas").remove(),$("[id*=_Region_Series_"+n+"_Point_"+t+"]").attr("class",""),$("[id*="+this.svgObject.id+"_Series"+n+"_Point"+t+"]").attr("class",""),$("[id*="+this._id+"_Selection_series"+n+"]").length==0?$("#"+this._id+"_Selection_Legend"+n+"_canvas").remove():0,l=this.model.enable3D?this.foundClasses("_Region_Series_"+n):this.foundClasses(this.svgObject.id+"_Series"+n),l.length==0?$("#"+this.svgObject.id+"_LegendItemShape"+n).attr("class",""):0):($("[id*="+this._id+"_Selection_series"+n+"_point_]").remove(),$("[id*="+this._id+"_Selection_Legend"+n+"]").remove(),$("[id*=_Region_Series_"+n+"_Point_]").attr("class",""),$("[id*="+this.svgObject.id+"_Series"+n+"_Point]").attr("class",""),$("#"+this.svgObject.id+"_LegendItemShape"+n).attr("class","")));r!="point"&&r!="cluster"&&(r!="series"||this.model._visibleSeries.length!=1||this.model.AreaType!="none"||f)||(u?($("#"+this._id+"_Selection_series"+n+"_point_"+t+"_canvas").remove(),$("[id*=_Region_Series_"+n+"_Point_"+t+"]").attr("class",""),$("[id*="+this.svgObject.id+"_Series"+n+"_Point"+t+"]").attr("class",""),this.model._visibleSeries.length>1?$("#"+this.svgObject.id+"_LegendItemShape"+n).attr("class",""):$("#"+this.svgObject.id+"_LegendItemShape"+t).attr("class",""),this.model._visibleSeries.length>1?$("#"+this._id+"_Selection_Legend"+n+"_canvas").remove():$("#"+this._id+"_Selection_Legend"+t+"_canvas").remove()):($("[id*="+this._id+"_Selection_series]").remove(),$("[id*="+this._id+"_Selection_Legend]").remove(),$("[id*=_Region_Series_"+n+"_Point_]").attr("class",""),$("[id*="+this.svgObject.id+"_Series"+n+"_Point]").attr("class",""),this.model._visibleSeries.length>1?$("[id*="+this.svgObject.id+"_LegendItemShape"+n+"]").attr("class",""):$("[id*="+this.svgObject.id+"_LegendItemShape]").attr("class","")))},createStyle:function(n,t,i,r,u,f,e,o){var s,h,c,l;n.vmlRendering?(s=document.createElement("style"),s.id=t+"Segment",r=r*100,h="."+t+"Style"+i+" {filter: alpha(opacity="+r+");}."+t+"PathStyle"+i+"  {filter: alpha(opacity="+r+");}",s.setAttribute("type","text/css"),s.styleSheet?s.styleSheet.cssText=h:(c=document.createTextNode(h),s.appendChild(c)),l=document.getElementsByTagName("head")[0],l.appendChild(s)):($("<style id="+t+"Segment"+i+" type='text/css'> ."+t+"Style"+i+"{ fill:"+u+";opacity:"+r+";stroke:"+f+";stroke-width:"+e+";stroke-opacity:"+o+"}<\/style>").appendTo("body"),$("<style id="+t+"Path"+i+" type='text/css'> ."+t+"PathStyle"+i+"{ opacity:"+r+";stroke:"+f+";stroke-width:"+e+";stroke-opacity:"+o+"}<\/style>").appendTo("body"))},highlightPoint:function(n,t,i,r,u,f,e){for(var s,a,h,l="_Region_Series_"+t+"_Point_"+i,c=$(this.svgObject).find("[id$="+l+"],[id*="+l+"back],[id*="+l+"front]"),o=0;o<c.length;o++)s=[],s.api=r+u,s.seriesName=u,s.name=$("[id="+c[o].id+"]").attr("name"),s.index=o,a=this.highlightFill(f,n,t,i),h=$("#"+c[o].id).attr("class"),h=h?h:"",h.indexOf("Selection")<0&&$("[id="+c[o].id+"]").attr("class",this.dStyle(s,a,n,e,f))},highlightCluster:function(n,t,i,r,u,f,e){var u,y,v,h,p,c,l,w,a,b,s,o;if(n.model.AreaType!="none"){for(l=[],w=n.model._visibleSeries[t]._visiblePoints[i].x,a=0,b=n.model._visibleSeries.length;a<b;a++)for(o=0;o<n.model._visibleSeries[a]._visiblePoints.length;o++)w==n.model._visibleSeries[a]._visiblePoints[o].x&&(l[l.length]={seriesIndex:a,pointIndex:o});for(s=0;s<l.length;s++){for(u="series"+s,y="_Region_Series_"+l[s].seriesIndex+"_Point_"+l[s].pointIndex,v=$(this.svgObject).find("[id$="+y+"],[id*="+y+"back],[id*="+y+"front]"),o=0;o<v.length;o++)h=[],h.api=r+u,h.seriesName="series"+s,h.name=$("[id="+v[o].id+"]").attr("name"),h.index=o,t=s,f=r=="Highlight"?n.model._visibleSeries[s].highlightSettings:n.model._visibleSeries[s].selectionSettings,p=this.highlightFill(f,n,t,i),c=$("#"+v[o].id).attr("class"),c=c?c:"",c.indexOf("Selection"+u+"Style")<0&&c.indexOf("SelectionStyle")<0&&$("[id="+v[o].id+"]").attr("class",this.dStyle(h,p,n,e,f));r=="Highlight"?$("#"+this.svgObject.id+"_LegendItemShape"+s).not("[class*='Selection']").attr("class","Highlight"+u+"Style"+u+"1"):$("#"+this.svgObject.id+"_LegendItemShape"+s).attr("class","Selection"+u+"Style"+u+"1")}}},highlightSeries:function(n,t,i,r,u,f,e,o){var t=t,v=i,y=n.model._visibleSeries.length,p=n.model.AreaType=="none"&&y==1?"_Region_Series_"+t+"_Point_"+i:"_Region_Series_"+t+"_Point_",l=$(this.svgObject).find("[id*="+p+"]"),c,a,s=o?$("#"+this.svgObject.id+"_LegendItemShape"+i).attr("class"):e?$("#"+e.target.id).attr("class"):"",h;if(s=s?s:"",s.indexOf("SelectionStyle")<0||o)for(h=0;h<l.length;h++)c=[],c.api=r+u,c.seriesName=u,c.name=$("[id="+l[h].id+"]").attr("name"),c.index=h,a=this.highlightFill(f,n,t,v,o),s=$("#"+l[h].id).attr("class"),s=s?s:"",s.indexOf("SelectionStyle")<0&&s.indexOf("Selection"+u+"Style")<0&&$("[id="+l[h].id+"]").attr("class",this.dStyle(c,a,n,e,f))},highlight:function(n,t,i,r,u,f,e,o){var h=i.highlightSettings,ot,p=$.inArray(i,n.model._visibleSeries),w,s="series"+p,st=!1,c=p,l=e||t.target.id,bt=jQuery.uaMatch(navigator.userAgent),at,vt,v,d,g,y,tt,pt,et,b,wt,ut,a,k;!o&&this.isTouch(t)&&bt.browser=="chrome"&&(ot=t.originalEvent.changedTouches[0],l=document.elementFromPoint(ot.clientX,ot.clientY).id);f=f||t.target.parentNode.id;var kt=f.indexOf(this.svgObject.id+"_SeriesGroup_")>=0||f.indexOf(this.svgObject.id+"_Chart3D")>=0?!0:!1,dt=$("#"+l).attr("name"),ft=h.pattern.toLowerCase(),ht=n.model._visibleSeries.length;if(n.model.AreaType=="none"&&ht==1&&(n.model.enable3D?c=r?r.legendItem.LegendItem.PointIndex:u.region.Region.PointIndex:(at=r?this.svgObject.id+"_LegendItemShape":this.svgObject.id+"_Series"+p+"_Point",vt=r?this.svgObject.id+"_LegendItemShape"+r.legendItem.LegendItem.PointIndex:l,w=vt.substr(at.length),c=w)),$("style").each(function(){$(this).html().indexOf(".HighlightStyle"+s)>-1&&(st=!0)}),n.model.enable3D&&!n.vmlRendering)(h.mode=="series"||r)&&(n.model.AreaType=="none"&&ht!=1||n.model.AreaType!="none")?(this.highlightSeries(n,p,c,"Highlight",s,h,t,r),$("#"+this.svgObject.id+"_LegendItemShape"+c).not("[class*='Selection']").attr("class","Highlight"+s+"Style"+s+"1")):h.mode=="cluster"&&n.model.AreaType!="none"?this.highlightCluster(n,p,u.pointData.pointIndex,"Highlight",s,h,t):(w=u?u.pointData.pointIndex:c,this.highlightPoint(n,p,w,"Highlight",s+w,h,t),$("#"+this.svgObject.id+"_LegendItemShape"+c).not("[class*='Selection']").attr("class","Highlight"+s+w+"Style"+s+w+"1"));else{if(h.mode||this.model.AreaType=="none"){v={};v.name="2D";v.index=p;v.api="Highlight";v.color=h.color!=""?h.color:r?this.model.AreaType=="none"?this.model.pointColors[c]:this.model.seriesColors[c]:$("#"+l).attr("fill");Object.prototype.toString.call(v.color)==="[object Array]"&&(v.color=v.color[1].color);var nt=ft=="none"||n.vmlRendering||ft==""?h.color:this.pattern(n,t,v,h),rt=o?1:h.opacity,ct=o?i.type.toLowerCase().indexOf("hilo")==-1?n.model.highlightColor:nt:h.border.color,lt=o?3.5:h.border.width,yt=o&&i.type.toLowerCase().indexOf("hilo")==-1?.5:1;st||(this.createStyle(n,"Highlight",s,rt,nt,ct,lt,yt),this.createStyle(n,"HighlightLegend",s,rt,nt,"transparent",0,yt))}if(d=r?$("#"+this.svgObject.id+"_LegendItemShape"+c).attr("class"):$("#"+l).attr("class"),d=d?d:"",d.indexOf("Selection")==-1)if((h.mode=="series"&&!o||r)&&(n.model.AreaType=="none"&&ht!=1||n.model.AreaType!="none"))$("[id*="+this.svgObject.id+"_Series"+c+"]").each(function(){if(this.parentNode.id==n.svgObject.id+"_SeriesGroup_"+c||this.parentNode.id==n.svgObject.id+"_symbolGroup_"+c){var t=$(this).attr("class"),i=$(this).attr("name")?"HighlightPathStyle"+s:"HighlightStyle"+s;(t==undefined||t.indexOf("SelectionStyle")==-1)&&t!="SelectionStyle"+s&&t!="SelectionStyleClusterSeries"+p&&t!="SelectionPathStyle"+s&&f.indexOf(n.svgObject.id+"_symbolGroup_"+c)<=0&&$(this).attr("class",i)}}),$("#"+this.svgObject.id+"_LegendItemShape"+c).not("[class*='Selection']").attr("class","HighlightLegendStyle"+s);else if(h.mode!="cluster"||n.model.AreaType=="none"||o){if(!$("#"+l).attr("name")&&l!=n.svgObject.id+"_Series"+c){if(it=$("#"+l).attr("class")?$("#"+l).attr("class"):"",it.indexOf("Selection")!=0&&f.indexOf(n.svgObject.id+"_symbolGroup_"+c)<=0&&(u||r)){if(kt&&($("#"+l).attr("class","HighlightStyle"+s),this.model.commonSeriesOptions.columnFacet=="cylinder"||i.columnFacet=="cylinder"))for(b=0;b<2;b++)$("#"+l.replace(/2$/,b)).attr("class","HighlightStyle"+s);$("#"+l+"_symbol").attr("class","HighlightStyle"+s);$("#"+this.svgObject.id+"_Series"+p+"_Point"+w).not("[class*='Selection']").attr("class","HighlightStyle"+s);$("#"+this.svgObject.id+"_LegendItemShape"+c).not("[class*='Selection']").attr("class","HighlightLegendStyle"+s)}l.indexOf("symbol")>-1&&$("#"+l).attr("class","HighlightStyle"+s)}k=$("#"+l).attr("name");k!=undefined&&(k=="candle"||k.indexOf("hilo")>=0)&&($("[id$="+l+"]").attr("class","HighlightStyle"+s),$("#"+this.svgObject.id+"_LegendItemShape"+c).not("[class*='Selection']").attr("class","HighlightLegendStyle"+s))}else{if(g=this.svgObject.id+"_Series",y=[],c=l.match(/(\d+)/g),c&&l.toLowerCase().indexOf("point")>0)for(w=parseInt(c[c.length-1]),pt=n.model._visibleSeries[p]._visiblePoints[w].xValue,b=0,wt=n.model._visibleSeries.length;b<wt;b++)for(ut=0;ut<n.model._visibleSeries[b]._visiblePoints.length;ut++)et=n.model._visibleSeries[b]._visiblePoints[ut],pt==et.xValue&&et.isEmpty==!1&&et.visible==!0&&(y[y.length]={seriesIndex:b,pointIndex:ut});for(a=0;a<y.length;a++){tt=y[a].seriesIndex;s="series"+tt;v={};v.name="2D";v.api="Highlight"+s;h=n.model._visibleSeries[tt].highlightSettings;v.color=h.color!=""?h.color:this.model.seriesColors[tt];Object.prototype.toString.call(v.color)==="[object Array]"&&(v.color=v.color[1].color);rt=h.opacity;ct=h.border.color;lt=h.border.width;nt=ft=="none"||n.vmlRendering||ft==""?v.color:this.pattern(n,t,v,h);st||(this.createStyle(n,"Highlight",s,rt,nt,ct,lt),this.createStyle(n,"HighlightLegend",s,rt,nt,"transparent",0));var it=$("#"+g+y[a].seriesIndex+"_Point"+y[a].pointIndex).attr("class"),gt=$("#"+g+y[a].seriesIndex+"_Point"+y[a].pointIndex+"_symbol").attr("class"),d=$("#"+g+y[a].seriesIndex+"_Point"+y[a].pointIndex).attr("name")?"HighlightPathStyle"+s:"HighlightStyle"+s;(it==undefined||it.indexOf("SelectionStyleseries"+a)==-1)&&it!="SelectionStyleseries"+a&&it!="SelectionPathStyle"+s&&f.indexOf(n.svgObject.id+"_symbolGroup_"+a)<=0&&($("#"+g+y[a].seriesIndex+"_Point"+y[a].pointIndex).attr("class",d),$("#"+g+y[a].seriesIndex+"_Point"+y[a].pointIndex+"_symbol").attr("class",d));n.model._visibleSeries[tt].visibility!="hidden"&&$("#"+this.svgObject.id+"_LegendItemShape"+tt).not("[class*='Selection']").attr("class","HighlightLegendStyle"+s);k=$("#"+l).attr("name");k!=undefined&&(k=="candle"||k.indexOf("hilo")>=0)&&$("[id$="+g+y[a].seriesIndex+"_Point"+y[a].pointIndex+"]").attr("class","HighlightStyle"+s)}}}},dStyle:function(n,t,i,r,u){var c=ej.Ej3DRender.prototype.polygon3D.prototype,h=u,e=n.api,o=n.seriesName,l=h.opacity,s,f;return t=i.colorNameToHex(t),t=n.name=="XLight"?c.applyXLight(t,i):n.name=="ZLight"?c.applyZLight(t,i):t,s={},s.name=n.name,s.color=t,s.api=e,t=h.pattern=="none"?t:this.pattern(i,r,s,h),document.getElementById(e+"Segment"+o)?(f=document.getElementById(e+"Segment"+o),f.innerHTML=f.innerHTML+"."+e+"Style"+o+n.index+" { fill:"+t+";opacity:"+l+" }"):(f=document.createElement("style"),f.id=e+"Segment"+o,f.type="text/css",f.innerHTML="."+e+"Style"+o+n.index+" { fill:"+t+";opacity:"+l+" }",document.getElementsByTagName("head")[0].appendChild(f)),e+"Style"+o+n.index},pattern:function(n,t,i,r){var v=r,o=i.api,s=v.pattern.toLowerCase(),e=i.color,c=v.opacity!=""?v.opacity:$("#"+t.target.id).attr("opacity"),a="#ffffff",y,l,u,h,f;document.getElementById(o+"Def")?l=$("#"+o+"Def")[0]:(y={id:o+"Def"},l=n.svgRenderer.createPattern(y,"svg"),n.svgRenderer.append(l,n.svgObject));n.model.enable3D&&(a=i.name=="XLight"?"#595959":i.name=="ZLight"?"#737373":"#808080");"#"+s+"_"+o+"_"+i.name+"_"+i.index&&$("#"+s+"_"+o+"_"+i.name+"_"+i.index).remove();u=[];switch(s){case"chessboard":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",x:0,y:0,width:10,height:10},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={x:0,y:0,width:10,height:10,fill:a,opacity:c,name:"rect"},u[1]={x:0,y:0,width:5,height:5,fill:e,opacity:c,name:"rect"},u[2]={x:5,y:5,width:5,height:5,fill:e,opacity:c,name:"rect"},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"pacman":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"17.917",height:"18.384"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:17.917,height:18.384,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M9.081,9.194l5.806-3.08c-0.812-1.496-2.403-3.052-4.291-3.052H8.835C6.138,3.063,3,6.151,3,8.723v1.679   c0,2.572,3.138,5.661,5.835,5.661h1.761c2.085,0,3.835-1.76,4.535-3.514L9.081,9.194z","stroke-width":1,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"crosshatch":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"8",height:"8"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={x:0,y:0,width:8,height:8,transform:"translate(0,0)",fill:a,opacity:c,name:"rect"},u[1]={d:"M0 0L8 8ZM8 0L0 8Z","stroke-width":1,stroke:e,name:"path"},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"dots":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"6",height:"6"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={x:0,y:0,width:7,height:7,transform:"translate(0,0)",fill:a,opacity:c,name:"rect"},u[1]={cx:3,cy:3,r:2,"stroke-width":1,fill:e,name:"circle"},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"diagonalforward":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"6",height:"6"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={x:0,y:0,width:6,height:6,transform:"translate(0,0)",fill:a,opacity:c,name:"rect"},u[1]={d:"M 3 -3 L 9 3 M 6 6 L 0 0 M 3 9 L -3 3","stroke-width":2,stroke:e,name:"path"},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"diagonalbackward":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"6",height:"6"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={x:0,y:0,width:6,height:6,transform:"translate(0,0)",fill:a,opacity:c,name:"rect"},u[1]={d:"M 3 -3 L -3 3 M 0 6 L 6 0 M 9 3 L 3 9","stroke-width":2,stroke:e,name:"path"},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"grid":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"6",height:"6"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:6,height:6,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M1 3.5L11 3.5 M0 3.5L11 3.5 M0 7.5L11 7.5 M0 11.5L11 11.5 M5.5 0L5.5 12 M11.5 0L11.5 12Z","stroke-width":1,stroke:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"turquoise":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"17",height:"17"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:17,height:17,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M0.5739999999999998,2.643a2.123,2.111 0 1,0 4.246,0a2.123,2.111 0 1,0 -4.246,0","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e},u[2]={name:"path",d:"M11.805,2.643a2.123,2.111 0 1,0 4.246,0a2.123,2.111 0 1,0 -4.246,0","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e},u[3]={name:"path",d:"M6.19,2.643a2.123,2.111 0 1,0 4.246,0a2.123,2.111 0 1,0 -4.246,0","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e},u[4]={name:"path",d:"M11.805,8.217a2.123,2.111 0 1,0 4.246,0a2.123,2.111 0 1,0 -4.246,0","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e},u[5]={name:"path",d:"M6.19,8.217a2.123,2.111 0 1,0 4.246,0a2.123,2.111 0 1,0 -4.246,0","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e},u[6]={name:"path",d:"M11.805,13.899a2.123,2.111 0 1,0 4.246,0a2.123,2.111 0 1,0 -4.246,0","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e},u[7]={name:"path",d:"M6.19,13.899a2.123,2.111 0 1,0 4.246,0a2.123,2.111 0 1,0 -4.246,0","stroke-width":1,"stroke-miterlimit":10,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"star":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"21",height:"21"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:21,height:21,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M15.913,18.59L10.762 12.842 5.613 18.75 8.291 11.422 0.325 9.91 8.154 8.33 5.337 0.91 10.488 6.658 15.637 0.75 12.959 8.078 20.925 9.59 13.096 11.17 z","stroke-width":1,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"triangle":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"10",height:"10"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:10,height:10,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M4.987,0L7.48 4.847 9.974 9.694 4.987 9.694 0 9.694 2.493 4.847 z","stroke-width":1,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"circle":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"9",height:"9"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:9,height:9,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"circle",cx:5.125,cy:3.875,r:3.625,"stroke-width":1,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"tile":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"18",height:"18"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:18,height:18,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M0,9L0 0 9 0 z","stroke-width":1,stroke:e,fill:e},u[2]={name:"path",d:"M9,9L9 0 18 0 z","stroke-width":1,stroke:e,fill:e},u[3]={name:"path",d:"M0,18L0 9 9 9 z","stroke-width":1,stroke:e,fill:e},u[4]={name:"path",d:"M9,18L9 9 18 9 z","stroke-width":1,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"horizontaldash":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"12",height:"12"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:12,height:12,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M0,1.5 L10 1.5 M0,5.5 L10 5.5 M0,9.5 L10 9.5 z","stroke-width":1,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"verticaldash":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"12",height:"12"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:12,height:12,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M1.5,0 L1.5 10 M5.5,0 L5.5 10 M9.5,0 L9.5 10 z","stroke-width":1,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"rectangle":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",x:0,y:0,width:12,height:12},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",width:12,height:12,fill:a,opacity:c},u[1]={name:"rect",x:1,y:2,width:4,height:9,fill:e,opacity:c},u[2]={name:"rect",x:7,y:2,width:4,height:9,fill:e,opacity:c},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"box":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",x:0,y:0,width:10,height:10},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",width:13,height:13,fill:a,opacity:c},u[1]={name:"rect",x:1.5,y:1.5,width:10,height:9,fill:e,opacity:c},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"horizontalstripe":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"10",height:"12"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:10,height:12,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M0,0.5 L10 0.5 M0,4.5 L10 4.5 M0,8.5 L10 8.5 z","stroke-width":1,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"verticalstripe":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"12",height:"10"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:12,height:10,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"path",d:"M0.5,0 L0.5 10 M4.5,0 L4.5 10 M8.5,0 L8.5 10 z","stroke-width":1,stroke:e,fill:e},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"bubble":return h={id:s+"_"+o+"_"+i.name+"_"+i.index,patternUnits:"userSpaceOnUse",width:"20",height:"20"},f=n.svgRenderer.createPattern(h,"pattern"),u[0]={name:"rect",x:0,y:0,width:20,height:20,transform:"translate(0,0)",fill:a,opacity:c},u[1]={name:"circle",cx:5.217,cy:11.325,r:3.429,"stroke-width":1,fill:"#D0A6D1"},u[2]={name:"circle",cx:13.328,cy:6.24,r:4.884,"stroke-width":1,fill:e},u[3]={name:"circle",cx:13.277,cy:14.66,r:3.018,"stroke-width":1,fill:"#D0A6D1"},this.loadPattern(n,u,f),l.appendChild(f),"url(#"+s+"_"+o+"_"+i.name+"_"+i.index+")";case"custom":return"url(#"+v.customPattern+")"}},loadPattern:function(n,t,i,r){for(var f,u=0;u<t.length;u++)r?t[u].name=="rect"?(t[u].stroke="transparent",this.drawRect(t[u],r)):t[u].name=="path"?ej.EjCanvasRender.prototype.drawPath(t[u],r):t[u].name=="circle"&&(t[u].stroke="transparent",ej.EjCanvasRender.prototype.drawCircle(t[u],r)):(f=n.svgRenderer.createPattern(t[u],t[u].name),i.appendChild(f))},drawRect:function(n,t){t.save();t.beginPath();t.globalAlpha=n.opacity;t.lineWidth=n["stroke-width"];t.strokeStyle=n.stroke;t.rect(n.x,n.y,n.width,n.height);n.fill=="none"&&(n.fill="transparent");t.fillStyle=n.fill;n.transform&&t.translate(n.transform[0],n.transform[1]);t.rotate(n.rotate*Math.PI/180);t.fillRect(n.x,n.y,n.width,n.height);t.clip();t.stroke();t.restore()},chartRightClick:function(n){return this.chartRightClick=!0,this.isTouch(n)&&this.model.crosshair.visible?(event.preventDefault(),event.stopPropagation(),!1):void 0},chartMouseUpTouch:function(n){var t=this,r=jQuery.uaMatch(navigator.userAgent),i=this.calMousePosition(n),u=this.model.browserInfo;return this.mousemoveX=i.X,this.mousemoveY=i.Y,this.enableTrackBall(),clearTimeout(this.model.doubleTapTimer),this.drag||(this.model.doubleTapTimer=setTimeout(function(){(t.model.tapNum<2||t.model.crosshair.visible)&&t.singleTap(n);t.model.tapNum=0;t.model.cachedX=0;t.model.cachedY=0},200)),t.model.tapNum==2&&(t.model.doubleTapped=!1),!0},getEvent:function(n){return n.targetTouches&&n.targetTouches[0]?n.targetTouches[0]:n},doubleTap:function(n){var r=this.getEvent(n),u=r.pageX,f=r.pageY,o=this.model,e=200,i,t=o.m_AreaBounds,s;this.model.cachedX=this.model.cachedX||u;this.model.cachedY=this.model.cachedY||f;s=(new Date).getTime();this.mouseDownX>=t.X&&this.mouseDownX<t.X+t.Width&&this.mouseDownY<t.Y+t.Height&&this.mouseDownY>=t.Y&&Math.abs(u-this.model.cachedX)<e&&Math.abs(f-this.model.cachedY)<e&&this.model.tapNum++;this.model.tapNum==2&&(this.model.doubleTapped=!0,this.multiSelectMouseDown(n),this.drag=this.model.zooming.enable||this._isMultiSelect,i=this.model.trackerElement,i&&($(i).finish(),i=null))},singleTap:function(n){var t=this,o=n.target.id,p=this.model._visibleSeries,f,s=this.getEvent(n),v=s.pageX,y=s.pageY,h=10,r,i,c,e,u,l,a;if(!this.panning&&!this.isZoomButtonHovered(n.target)){for(this.cancelEvent(n),t.model.trackerElement&&($.finish?$(t.model.trackerElement).finish():$(t.model.trackerElement).stop(!0,!0),t.model.trackerElement=null),$(".ejTooltip"+this._id).remove(),(!t.model.crosshair.visible||t.model.AreaType!="cartesianaxes")&&Math.abs(v-t.model.cachedX)<h&&Math.abs(y-t.model.cachedY)<h?this.chartInteractiveBehavior(n):(t.model.element=$(document).find("#"+this.svgObject.id+"_CrosshairGroup"),t.model.trackerElement=$(t.model.element).children().not(".Tracker").not("defs"),$(t.model.trackerElement).length>0&&$(t.model.trackerElement).fadeOut(1e3,function(){$(t.model.element).find('[id*="trackSymbol"]').attr("visibility","hidden");t.model.trackerElement=null;t._removeHighlight()}),r=$(document).find('[id*="_trackball_grouping_tooltip"]'),$(r).length>0&&$(r).fadeOut(1e3,function(){$(r).remove()})),this.axisTooltip(n,o),this.showTitleTooltip(n,o),this.model.enableCanvasRendering&&(this._textTooltip(n,this.model.xAxisLabelRegions),this._textTooltip(n,this.model.yAxisLabelRegions)),i=0,c=this.model.series.length;i<c;i++)e=this.model.series[i],u=e.marker.dataLabel,!e._enableSmartLabels||this.model.enable3D||u.enableWrap||(l=u.template,a=u.font,this.model.AreaType=="none"&&ej.util.isNullOrUndefined(l)&&this.datalabelTooltip(n,i,a));$(".ejTooltip"+this._id).length>0&&(f=$(".ejTooltip"+this._id));$(".tooltipDiv"+this._id).length>0&&(f=$(".tooltipDiv"+this._id));window.clearTimeout(t.model.timer);t.model.trackerElement=f;t.model.timer=setTimeout(function(){var n=t.model.prevPoint,i;t.model.trackerElement?t.model.trackerElement.fadeOut(500,function(){if(n){if(t.model.AreaType!="polaraxes"){var i=ej.EjSvgRender.utils._getPoint(n.point,n.series);t.drawTrackerSymbol(n.series,n.seriesIndex,n.pointIndex,null,i)}$("#canvas_trackSymbol").remove()}$("[id*=_TrackSymbol]").remove()}):(n&&t.model.AreaType!="polaraxes"&&(i=ej.EjSvgRender.utils._getPoint(n.point,n.series),t.drawTrackerSymbol(n.series,n.seriesIndex,n.pointIndex,null,i)),t.model.crosshair.visible||($("#canvas_trackSymbol").remove(),$("[id*=_TrackSymbol]").remove()))},1200)}n.originalEvent.pointerType||this.panning||!(this.model.selectionEnable||this.isDevice()&&this._isSafari)||this._doClick(n)},_getPieOfPiePoint:function(n,t,i){for(var f,u=i?t.points:t._visiblePoints,e=u.length,r=0;r<e;r++)n==u[r].actualIndex&&(f=u[r]);return f},tooltip:function(n,t){var ft=!1,f,a,i=this.GetSeriesPoint(t),d,vt,p,yt,pt,u,g,o,st,ht,wt,bt,k,b,l,kt,rt,h,e,gt,ni,ct,c,nt,lt,s,at,ri;if($("#canvas_trackSymbol").remove(),ej.util.isNullOrUndefined(i)&&!this.dragPoint&&$("#"+n.svgObject.id+"_TrackToolTip").remove(),this.model.crosshair.visible||this.model.AreaType!="cartesianaxes")$("#"+this.svgObject.id).find("#"+this.svgObject.id+"_TrackToolTip").hide(),ej.util.isNullOrUndefined(i)&&(clearTimeout(this.removeTooltip),n.removeTooltip=setTimeout(function(){$(".tooltipDiv"+n._id).remove()},1e3));else{for(var et=this.model.indicators,v=this.model._visibleSeries,ot,y,w,ui=v.length,it=0,tt=0;tt<ui;tt++)for(w=v[tt].trendlines,y=0;y<w.length;y++)w[y].visibility.toLowerCase()!="visible"||w[y].isNull||this.model.series[0].type=="boxandwhisker"||(w[y]._visiblePoints=w[y].points,v=v.concat(w[y]));for(d=0;d<et.length&&et[d].segment;d++)ot=et[d],ot.visible&&(v=v.concat(ot.segment));for(vt=v.length,s=0;s<vt;s++)f=v[s],a=s,p=f.type.toLowerCase(),f.visibility.toLowerCase()!="visible"||p==="scatter"||p==="bubble"||p==="column"||p.indexOf("bar")!=-1||p==="stackingcolumn"||p==="stackingcolumn100"||f._hiloTypes?ej.util.isNullOrUndefined(i)&&!this.dragPoint&&$(".tooltipDiv"+this._id).hasClass(this.svgObject.id)&&(clearTimeout(this.removeTooltip),n.removeTooltip=setTimeout(function(){$(".tooltipDiv"+n._id).remove()},1e3)):($("#"+n.svgObject.id+"_TrackToolTipTemplate_"+a).remove(),$(".tooltipDiv"+this._id).hasClass(n.svgObject.id)||$(".tooltipDiv"+this._id).remove(),$("#"+n.svgObject.id).find("#"+n.svgObject.id+"_TrackSymbol_"+a).remove(),$("#"+n.svgObject.id+"_TrackSymbol_"+a).remove(),yt=[],pt=[],h=null,u=n.getClosesPointXY(pt,yt,f,n.mousemoveX,n.mousemoveY,t),ej.util.isNullOrUndefined(u.point)&&(!this.model.prevPoint||this.model.prevPoint.seriesIndex&&!this.model.series[this.model.prevPoint.seriesIndex].tooltip.visible)&&!this.dragPoint&&$(".tooltipDiv"+this._id).hasClass(this.svgObject.id)&&(clearTimeout(this.removeTooltip),n.removeTooltip=setTimeout(function(){$(".tooltipDiv"+n._id).remove()},1e3)),u.point&&(f.type.toLowerCase()=="boxandwhisker"?(it++,h=u.outlierPosition):h=ej.EjSvgRender.utils._getPoint(u.point,f),g=$.extend({},ej.EjSvgRender.commonChartEventArgs),g.data={location:{x:this.mousemoveX,y:this.mousemoveX},region:{SeriesIndex:s,Region:{PointIndex:u.index}}},n._trigger("pointRegionMouseMove",g)),o=this.model.prevPoint,o&&o.seriesIndex==s&&!u.point&&(f.type.toLowerCase()=="boxandwhisker"?(it++,st=o.outlierPosition):st=ej.EjSvgRender.utils._getPoint(o.point,o.series),n.model.enableCanvasRendering||n.drawTrackerSymbol(o.series,o.seriesIndex,o.pointIndex,null,st),this.model.prevPoint=null),f.isIndicator||f.isTrendLine||f.selectionSettings.enable||f.highlightSettings.enable||!f.marker.visible&&f.type.toLowerCase()!="boxandwhisker"||!u.point||g.cancel||(ej.util.isNullOrUndefined(u.point.marker)||ej.util.isNullOrUndefined(u.point.marker.visible)||u.point.marker&&u.point.marker.visible?n.drawTrackerSymbol(f,a,u.index,!1,h):f.type!="boxandwhisker"||u.point.marker||n.drawTrackerSymbol(f,a,u.index,!1,h),o&&u.point!=o.point&&(f.type.toLowerCase()=="boxandwhisker"?(it++,ht=o.outlierPosition):ht=ej.EjSvgRender.utils._getPoint(o.point,o.series),n.drawTrackerSymbol(o.series,o.seriesIndex,o.pointIndex,null,ht,ut,it)),(ej.util.isNullOrUndefined(u.point.marker)||ej.util.isNullOrUndefined(u.point.marker.visible)||u.point.marker&&u.point.marker.visible)&&(this.model.prevPoint={point:u.point,pointIndex:u.index,series:f,seriesIndex:a,outlierPosition:u.outlierPosition})),f.tooltip.visible&&u.point&&(!i||s>i.region.SeriesIndex&&!(f._zOrder<this.model._visibleSeries[i.region.SeriesIndex]._zOrder))&&(e=ej.EjSvgRender.utils._getTransform(f.xAxis,f.yAxis,n.model.requireInvertedAxes),h.X+e.x<=e.x+e.width&&(h.X+e.x>=e.x||h.X==0)&&Math.abs(h.Y-(e.y+e.height))<=e.y+e.height&&(Math.abs(h.Y-(e.y+e.height))>=e.y||h.Y==0)&&(g.cancel||($(n.svgObject).find("#"+n.svgObject.id+"_TrackToolTip").length==0&&(wt={id:n.svgObject.id+"_TrackToolTip",transform:"translate("+e.x+","+e.y+")"},n.gTransToolEle=n.svgRenderer.createGroup(wt)),n.svgRenderer._setAttr($(n.svgObject).find("#"+n.svgObject.id+"_TrackToolTip"),{transform:"translate("+e.x+","+e.y+")",visibility:"visible"}),ej.util.isNullOrUndefined(f.tooltip.template)?(ft=!0,$(".tooltipDiv"+this._id).remove(),n.displayShowTooltip(h,u.point,f,u.index)):(ft=!0,$("#"+n.svgObject.id).find("#"+n.svgObject.id+"_TrackToolTip").attr("visibility","hidden"),bt={SeriesIndex:a,Region:{PointIndex:u.index}},n.createTooltip(bt,t,f))))))}if($(".tooltipDiv"+this._id).hasClass(this.svgObject.id)||$(".tooltipDiv"+this._id).remove(),i&&ej.util.isNullOrUndefined(i.region.isStripLine)){if(k=this.model._visibleSeries[i.region.SeriesIndex].type.toLowerCase(),(k=="pie"||k=="pieofpie"||k=="doughnut")&&this.model._visibleSeries[i.region.SeriesIndex].explode&&(this.model._visibleSeries[i.region.SeriesIndex].enableAnimation?(this.model.AnimationComplete||this.model.enableCanvasRendering)&&this.pieExplosion(i,t):this.model.enable3D||this.pieExplosion(i,t)),i.region.isIndicator)r=this.model.indicators[i.region.SeriesIndex],l=r.segment[0]._visiblePoints[i.region.Region.PointIndex],r.fill=r.segment[0].fill;else if(r=this.model._visibleSeries[i.region.SeriesIndex],r.type!="pieofpie"||this.model.enable3D){if(r.type!="pie"&&r.type!="doughnut"||this.model.enable3D)l=this.model._visibleSeries[i.region.SeriesIndex]._visiblePoints[i.region.Region.PointIndex];else for(b=0;b<r._visiblePoints.length;b++)if(i.region.Region.length==r._visiblePoints.length){if(i.region.Region.PointIndex==r._visiblePoints[b].actualIndex){l=this.model._visibleSeries[i.region.SeriesIndex]._visiblePoints[b];break}}else if(i.region.Region.Index==b){l=this.model._visibleSeries[i.region.SeriesIndex]._visiblePoints[b];break}}else l=this._getPieOfPiePoint(i.region.Region.PointIndex,r);if(l&&this.model.AreaType=="polaraxes"){for(s=0;s<this.model._visibleSeries.length;s++)$("[id*=_TrackSymbol]").remove(),kt="canvas_trackSymbol_"+s,$("#"+this._id).find("[id*="+kt+"]").remove();if(rt=this.model.AreaType!="polaraxes"?ej.EjSvgRender.utils._getPoint(l,r):ej.EjSvgRender.utils.TransformToVisible(r,l.xValue,l.y,this),c=this.model.prevPoint,!ej.util.isNullOrUndefined(c)&&c!=i&&r.marker.visible){var r=this.model._visibleSeries[c.region.SeriesIndex],dt=this.model._visibleSeries[c.region.SeriesIndex]._visiblePoints[c.region.Region.PointIndex],fi=ej.EjSvgRender.utils.TransformToVisible(r,dt.xValue,dt.y,this);this.drawTrackerSymbol(r,c.region.SeriesIndex,c.region.Region.PointIndex,null,fi);this.model.prevPoint=null}r.marker.visible&&r.drawType!="column"&&r.drawType.toLowerCase()!="rangecolumn"&&(this.drawTrackerSymbol(r,i.region.SeriesIndex,i.region.Region.PointIndex,!0,rt),this.model.prevPoint=i)}r.tooltip.visible&&!ft&&r.visibility.toLowerCase()=="visible"&&(ej.util.isNullOrUndefined(r.tooltip.template)?(this.model.AreaType=="cartesianaxes"?(e=ej.EjSvgRender.utils._getTransform(r.xAxis,r.yAxis,this.model.requireInvertedAxes),$(this.svgObject).find("#"+this.svgObject.id+"_TrackToolTip").length==0&&(gt={id:this.svgObject.id+"_TrackToolTip",transform:"translate("+e.x+","+e.y+")"},this.gTransToolEle=this.svgRenderer.createGroup(gt)),this.svgRenderer._setAttr($(this.svgObject).find("#"+this.svgObject.id+"_TrackToolTip"),{transform:"translate("+e.x+","+e.y+")"}),$("#"+this.svgObject.id+"_TrackToolTip").attr("visibility","visible"),h={X:i.location.x-this.model.m_AreaBounds.X,Y:Math.abs(i.location.y-this.model.m_AreaBounds.Y)}):($(this.svgObject).find("#"+this.svgObject.id+"_TrackToolTip").length==0&&(ni={id:this.svgObject.id+"_TrackToolTip"},this.gTransToolEle=this.svgRenderer.createGroup(ni)),h={X:i.location.x,Y:Math.abs(i.location.y)}),$(".tooltipDiv"+this._id).remove(),this.displayShowTooltip(h,l,r,i.region.Region.PointIndex)):($("#"+n.svgObject.id).find("#"+n.svgObject.id+"_TrackToolTip").attr("visibility","hidden"),this.createTooltip(i.region,t)));ct=$.extend({},ej.EjSvgRender.commonChartEventArgs);ct.data=i;this._trigger("pointRegionMouseMove",ct)}else if(ej.util.isNullOrUndefined(this.model.prevPoint)||this.model.AreaType!="polaraxes"){if(!ej.util.isNullOrUndefined(this.model.explodeValue)){var p=this.model.series[this.model.explodeValue.SeriesIndex].type.toLowerCase(),r=this.model._visibleSeries[this.model.explodeValue.SeriesIndex],k=new ej.seriesTypes[p],ti,ut,oi=r.labelPosition.toLowerCase(),a=this.model.explodeValue.SeriesIndex,ii=this.model._isPieOfPie?this._getPieOfPiePoint(this.model.explodeValue.PointIndex,r):r._visiblePoints[this.model.explodeValue.Index],ei=k._calculateArcData(this,this.model.explodeValue.PointIndex,ii,r,a,this.model.explodeValue.PieSeriesIndex);for(this.model.enableCanvasRendering&&(this.model.series[a].explodeIndex=null,nt=document.getElementById(this.svgObject.id).getClientRects()[0],this.svgRenderer.ctx.clearRect(nt.left,nt.top,nt.width,nt.height),$("#"+this._id).ejChart("redraw")),ut=this.svgObject.id+"_SeriesGroup_"+a,ti=this.model.explodeValue.PieSeriesIndex==1?$(this.gSeriesEle).children("#"+ut)[1]:$(this.gSeriesEle).children("#"+ut)[0],lt=$(ti).children(),s=0;s<lt.length;s++)if(at=lt[s],ri=this.svgRenderer._getAttrVal($(at)[0],"data-pointIndex"),parseInt(ri)==this.model.explodeValue.PointIndex){this.svgRenderer._setAttr($(at),{d:ei.Direction});break}k.drawDataLabelAcc(this,r,this.model.explodeValue.Index,ii,a,this.model.explodeValue.PieSeriesIndex);this.model.explodeValue=null;this.model.explode=!1}}else c=this.model.prevPoint,r=this.model._visibleSeries[c.region.SeriesIndex],l=this.model._visibleSeries[c.region.SeriesIndex]._visiblePoints[c.region.Region.PointIndex],rt=ej.EjSvgRender.utils.TransformToVisible(r,l.xValue,l.y,this),this.drawTrackerSymbol(r,c.region.SeriesIndex,c.region.Region.PointIndex,null,rt),this.model.prevPoint=null},chartTrackball:function(n,t,i){var ri,yr,wt,a,pr,ui,kt,e,tr,ft,fi,ei,wr,g,k,ir,oi,d,nr,si,st,w,c,ci,s,iu,dr,gr,li,fr,f;this.crosshairLinePath=[];var y=n.model.requireInvertedAxes,er=[],or=[],o,vt,kt,r,it,ai=this.model.indicators,h=this.model._visibleSeries,vi=!1,s,yt,dt,u,sr=[],ht,nu,gt,yi,rt,pi,hr,wi,cr,lr,p,bi=0,d,ki,di,ni,b,v=[],ct=[],l=[],et=this.model.enableCanvasRendering,lt=0,at=0,ar=0,vr=$("#"+this._id).offset(),ot=[],ti=[],ii=[],ut=this.model.crosshair.trackballTooltipSettings.mode.toLowerCase(),tu=n._id+"_trackball_grouping_tooltip",pt=this.model.locale,gi=0,nr=0;if(!this.model.enable3D&&this.model.crosshair.visible&&this.model.crosshair.type.toLowerCase()=="trackball"){for($("#"+this.svgObject.id+"_CrosshairGroup").length==0?(ri={id:n.svgObject.id+"_CrosshairGroup",visibility:"visible"},et?(ri.position="absolute",n.svgRenderer.drawCrosshairLine(ri,"#chartContainer_"+this._id)):(n.gTrackball=n.svgRenderer.createGroup(ri),n.svgRenderer.append(n.gTrackball,n.svgObject))):n.model.trackerElement&&($.finish?$(n.model.trackerElement).finish():$(n.model.trackerElement).stop(!0,!0),n.model.trackerElement=null),this.model.enableCanvasRendering||($("[class*=HighlightStyle]").attr("class",""),$("[class*=HighlightLegendStyle]").attr("class",""),$("[class*=HighlightLegendPathStyle]").attr("class",""),$("[class*=HighlightPathStyle]").attr("class",""),$("[class*=Highlightseries]").attr("class",""),$("[id*="+this._id+"_Highlight_]").remove()),$("#secondCanvas").remove(),$("#"+this._id).find('[id*="_gTooltip_"]').remove(),$("#"+tu).children().remove(),$(document).find('[id*="TrackGroupToolTipTemplate"]').remove(),$(document).find('[id*="TrackToolTipTemplate"]').remove(),et&&$("#"+this._id).find('[id*="canvas_trackSymbol"]').css("visibility","hidden"),yr=h.length,wt=0;wt<ai.length&&ai[wt].segment;wt++)h=h.concat(ai[wt].segment);for(yi=h.length,f=0;f<yi;f++)if(h[f].visibility=="visible"&&h[f].enableTrackTooltip&&(s=f,yt=[],dt=y?n.mousemoveY+h[f].xAxis.plotOffset>h[f].xAxis.y&&n.mousemoveY<h[f].xAxis.y+h[f].xAxis.height+h[f].xAxis.plotOffset:n.mousemoveX+h[f].xAxis.plotOffset>h[f].xAxis.x&&n.mousemoveX<h[f].xAxis.x+h[f].xAxis.width+h[f].xAxis.plotOffset,et&&(this.canvasX=h[f].xAxis.x),u=n.getClosestPointX(yt,h[f],n.mousemoveX,n.mousemoveY),ht=h[f].xAxis.visibleRange,u.point!=""&&(ui=h[f].type.toLowerCase()=="boxandwhisker"?u.point[0].boxPlotLocation[0].YValues:u.point[0].YValues[0],u.point!=""&&(ui>=h[f].yAxis.visibleRange.min||ut=="grouping")&&u.point[0].xValue>=ht.min&&u.point[0].xValue<=ht.max&&dt)))for(e=0;e<u.point.length;e++)u.point[e].visible&&(h[f].isIndicator||lt++);for(f=0;f<yi;f++){if(s=f,r=h[f],a=[],r.visibility.toLowerCase()=="visible"&&r.enableTrackTooltip)if(yt=[],dt=y?n.mousemoveY+h[f].xAxis.plotOffset>r.xAxis.y&&n.mousemoveY<r.xAxis.y+r.xAxis.height+h[f].xAxis.plotOffset:n.mousemoveX+h[f].xAxis.plotOffset>r.xAxis.x&&n.mousemoveX<r.xAxis.x+r.xAxis.width+h[f].xAxis.plotOffset,et&&(this.canvasX=r.xAxis.x),u=n.getClosestPointX(yt,r,n.mousemoveX,n.mousemoveY),ht=r.xAxis.visibleRange,u.point!=""){if(ui=h[f].type.toLowerCase()=="boxandwhisker"?u.point[0].boxPlotValues.midvalue:u.point[0].YValues[0],(ui>=h[f].yAxis.visibleRange.min||ut=="grouping")&&u.point[0].xValue>=ht.min&&u.point[0].xValue<=ht.max)if(dt)for(kt=u.point.length,e=0;e<kt;e++)if(u.point[e].visible){if(!r.isIndicator){if(r.type=="boxandwhisker")for(gi++,tr={xValue:u.point[e].xValue,YValues:u.point[e].boxPlotLocation[0].YValues},o=ej.EjSvgRender.utils._getPoint(tr,r),o.YValues=tr.YValues,a.push(o),ft=0;ft<u.point[e].boxPlotLocation.length;ft++)u.point[e].boxPlotLocation[ft].outlier==!0&&(pr={X:u.point[e].boxPlotLocation[ft].X,Y:u.point[e].boxPlotLocation[ft].Y,YValues:u.point[e].boxPlotLocation[ft].YValues,outlier:u.point[e].boxPlotLocation[ft].outlier},a.push(pr));else o=ej.EjSvgRender.utils._getPoint(u.point[e],r);if(this.model.financial=yr==1&&kt==1&&r._hiloTypes||!1,y)if(this.model.financial?(fi=o.X>o.low?o.X:o.low,ei=o.X<o.low?o.X:o.low,it="M "+r.yAxis.x+" "+(o.Y+r.xAxis.y)+" L "+(ei+r.yAxis.x)+" "+(o.Y+r.xAxis.y)+" M "+(r.yAxis.x+fi)+" "+(o.Y+r.xAxis.y)+" L "+(r.yAxis.x+r.yAxis.width)+" "+(o.Y+r.xAxis.y)):it="M "+r.yAxis.x+" "+(o.Y+r.xAxis.y)+" L "+(r.yAxis.x+r.yAxis.width)+" "+(o.Y+r.xAxis.y),r.type=="boxandwhisker")for(c=0;c<a.length;c++)v.push({X:a[c].X,Y:a[c].Y,YValues:a[c].YValues,outlier:a[c].outlier});else v.push({X:u.point[e].location.X+r.yAxis.x,Y:u.point[e].location.Y+r.xAxis.y});else if(this.model.financial?(fi=o.Y<o.low?o.Y:o.low,ei=o.Y>o.low?o.Y:o.low,it="M "+(o.X+r.xAxis.x)+" "+n.model.m_AreaBounds.Y+" L "+(o.X+r.xAxis.x)+" "+(fi+r.yAxis.y)+" M "+(o.X+r.xAxis.x)+" "+(ei+r.yAxis.y)+" L "+(o.X+r.xAxis.x)+" "+(n.model.m_AreaBounds.Y+n.model.m_AreaBounds.Height)):it="M "+(o.X+r.xAxis.x)+" "+n.model.m_AreaBounds.Y+" L "+(o.X+r.xAxis.x)+" "+(n.model.m_AreaBounds.Y+n.model.m_AreaBounds.Height),r.type=="boxandwhisker")for(c=0;c<a.length;c++)v.push({X:a[c].X,Y:a[c].Y,YValues:a[c].YValues,outlier:a[c].outlier});else v.push({X:u.point[e].location.X+r.xAxis.x,Y:u.point[e].location.Y+r.yAxis.y});if(nu={left:vr.left,top:vr.top},gt={id:n.svgObject.id+"_Tracker",fill:"none","stroke-width":n.model.crosshair.line.width,"clip-path":"url(#"+n.svgObject.id+"_ChartAreaClipRect)",stroke:n.model.crosshair.line.color,d:it},this.crosshairLinePath.push(gt),$("#"+n.svgObject.id+"_Tracker").length==0?(et?(g=this.svgRenderer.createCrosshairCanvas(),g.ctx=g.getContext("2d")):(g=this.svgRenderer,wr=n.gTrackball),n.svgRenderer.drawPath.call(g,gt,wr),vi=!0):(vi=!0,ej.util.isNullOrUndefined(this._closest)?n.svgRenderer._setAttr($(n.svgObject).find("#"+n.svgObject.id+"_Tracker"),{d:it,visibility:"visible"}):this._beforeMin?this._closest>=u.point[e].xValue&&n.svgRenderer._setAttr($(n.svgObject).find("#"+n.svgObject.id+"_Tracker"),{d:it,visibility:"visible"}):this._afterMax&&this._closest<=u.point[e].xValue&&n.svgRenderer._setAttr($(n.svgObject).find("#"+n.svgObject.id+"_Tracker"),{d:it,visibility:"visible"}),$("#"+n.svgObject.id+"_Tracker").css({display:"block"}),et&&(g=this.svgRenderer.createCrosshairCanvas(),g.ctx=g.getContext("2d"),n.svgRenderer.drawPath.call(g,gt,n.gTrackball)),$("#"+this._id).find('[id*="canvas_Tracker"]').css("visibility","visible")),pi=ej.EjSvgRender.utils._getTransform(r.xAxis,r.yAxis,y),hr={transform:"translate("+pi.x+","+pi.y+")",id:n.svgObject.id+"_TrackToolTip_"+s},n.gTransToolEle=n.svgRenderer.createGroup(hr),wi=this.model.prePoint,ej.util.isNullOrUndefined(wi)||wi.pointIndex[0]!=u.index[0]||!$("#"+n.svgObject.id+"_trackSymbol_"+s+"_"+u.index)){if(ej.util.isNullOrUndefined(cr)&&(n.gTransToolEle&&n.gTrackerEle&&($(this.svgObject).find('[id*="_TrackSymbol_"],[id*="_TrackToolTip"]').attr("visibility","hidden"),$("#"+this._id).find('[id*="canvas_trackSymbol"]').css("visibility","hidden")),cr=u),k=r.type.toLowerCase(),ir=0,(!r._hiloTypes||k.indexOf("rangearea")>-1)&&(ut!="grouping"||ut=="grouping"&&k.indexOf("column")<0&&k.indexOf("bar")<0))if(r.type=="boxandwhisker")for(oi=0;oi<a.length;oi++)n.drawTrackerSymbol(r,s,u.index[e],!0,a[oi],null,ir),ir++;else n.drawTrackerSymbol(r,s,u.index[e],!0,o);if(r.trackerRemoved=!0,n.model.crosshair.trackballTooltipSettings.tooltipTemplate)ut==="grouping"?(u=n.getClosestPointX(yt,r,n.mousemoveX,n.mousemoveY),vt=this.getSeriesColor(u.point[e],s,r),or.push({seriesColor:vt}),kt=u.point.length,nt=this.getTooltipFormat(u.point[e],r,s,u.index[e],ur),nt.text="&nbsp"+nt.text+"&nbsp",ot.push({text:nt.text,seriesIndex:s,pointIndex:u.index[e]}),er.push({point:u.point[e]}),sr.push({series:r}),(r._hiloTypes&&k!="rangearea"||k.indexOf("column")>-1||k.indexOf("bar")>-1)&&(rt={region:{Region:{PointIndex:u.index[e]},SeriesIndex:s}},this.highlightStart(i,rt,this._id+"_svg_SeriesGroup_"+s,this._id+"_svg_Series"+s+"_Point"+u.index[e],!0)),lt===ot.length&&(ni=document.getElementById(this.svgRenderer.svgObj.id).getClientRects()[0],n.displayGroupingTemplate(ki,di,o,er,sr,s,u.index[e],ni,or))):(ki,di,ni=document.getElementById(this.svgRenderer.svgObj.id).getClientRects()[0],n.displayTemplateTooltip(ki,di,o,u.point[e],r,s,u.index[e],ni));else if(d=v.length-1,nr=a.length,ut=="grouping"){var vt=this.getSeriesColor(u.point[e],s,r),rr,ur=r.tooltip.format,nt,br,bt=[];if(r.type=="boxandwhisker")for(c=0;c<nr;c++)br=this.getTooltipFormat(u.point[e],r,s,u.index[e],ur,a[c]),bt.push(br),nt=null;else nt=this.getTooltipFormat(u.point[e],r,s,u.index[e],ur);if(si=r.tooltip.font?r.tooltip.font.color?r.tooltip.font.color:vt:vt,st=r.tooltip.font?$.extend(!1,r.font,{},r.tooltip.font):r.font,typeof si=="object"&&(si=vt[1].color),r.type=="boxandwhisker")for(w=0;w<bt.length;w++)ot.push({text:bt[w].text,seriesIndex:s,pointIndex:u.index[e]});else nt.text="&nbsp"+nt.text+"&nbsp",ot.push({text:nt.text,seriesIndex:s,pointIndex:u.index[e]});if((r._hiloTypes&&k!="rangearea"||k.indexOf("column")>-1||k.indexOf("bar")>-1)&&(rt={region:{Region:{PointIndex:u.index[e]},SeriesIndex:s}},this.highlightStart(i,rt,this._id+"_svg_SeriesGroup_"+s,this._id+"_svg_Series"+s+"_Point"+u.index[e],!0)),r.type=="boxandwhisker")for(w=0;w<bt.length;w++)ii.push(n._id+"_grouping_text_"+s+"_"+u.index[e]+w);else ii.push(n._id+"_grouping_text_"+s+"_"+u.index[e]);if(rr={color:si,"font-size":st.size,"font-family":st.fontFamily,"font-style":st.fontStyle,"font-weight":st.fontWeight},r.type=="boxandwhisker")for(w=0;w<bt.length;w++)ti.push(rr);else ti.push(rr);gi==lt&&r.type=="boxandwhisker"?n.displayTooltip(!0,{point:u.point[e],series:r,textCollection:ot,textOptionsCollection:ti,groupingTextId:ii}):lt==ot.length&&r.type!="boxandwhisker"&&n.displayTooltip(!0,{point:u.point[e],series:r,textCollection:ot,textOptionsCollection:ti,groupingTextId:ii})}else{var lr=this.getTooltipFormat(u.point[e],r,s,f,r.tooltip.format,f),kr=r.tooltip,st=kr.font?$.extend(!1,r.font,{},kr.font):r.font,p=ej.EjSvgRender.utils._measureText(lr.text,null,st),tt,ar=y?p.height:p.width,at=at>ar?at:ar,hi=Math.ceil(lr.text.toString().split("<br/>").length/2);if(this.model.tooltipPadding=Number(st.size.toString().replace(/px/i,""))/3,tt=this.model.tooltipPadding+r.tooltip.border.width*2,y)ct.push({Start:v[d].X-tt-p.width/2,End:v[d].X+tt+p.width/2}),l.push({Point:v[d],ClosestPoint:u.point[e],Series:r,ClosestPointIndex:u.index[e],Tgap:bi,StEnd:ct[d],TextArea:p,ReqInvertAxis:y});else if(r.type=="boxandwhisker")for(c=0;c<nr;c++)ct.push({Start:a[c].Y-tt*hi-p.height/2,End:a[c].Y+tt*hi+p.height/2}),l.push({Point:a[c],ClosestPoint:u.point[e],Series:r,ClosestPointIndex:u.index[e],Tgap:bi,StEnd:ct[c],TextArea:p,ReqInvertAxis:y});else ct.push({Start:v[d].Y-tt*hi-p.height/2,End:v[d].Y+tt*hi+p.height/2}),l.push({Point:v[d],ClosestPoint:u.point[e],Series:r,ClosestPointIndex:u.index[e],Tgap:bi,StEnd:ct[d],TextArea:p,ReqInvertAxis:y});if(r.type=="boxandwhisker"&&gi==lt)for(at+=2*tt,l=y?l.sort(function(n,t){return n.Point.X-t.Point.X}):l.sort(function(n,t){return n.Point.Y-t.Point.Y}),this.SmartTooltipPosition(l),ci=l.length,n.displayTooltip(!1,l,at),f=0;f<ci;f++)s=$.inArray(l[f].Series,this.model._visibleSeries),l[f].Series._hiloTypes&&(rt={region:{Region:{PointIndex:l[f].ClosestPointIndex},SeriesIndex:s}},this.highlightStart(i,rt,this._id+"_svg_SeriesGroup_"+s,this._id+"_svg_Series"+s+"_Point"+l[f].ClosestPointIndex,!0));else if(l.length==lt&&r.type!="boxandwhisker")for(at+=2*tt,l=y?l.sort(function(n,t){return n.Point.X-t.Point.X}):l.sort(function(n,t){return n.Point.Y-t.Point.Y}),this.SmartTooltipPosition(l),ci=l.length,n.displayTooltip(!1,l,at),f=0;f<ci;f++)s=$.inArray(l[f].Series,this.model._visibleSeries),l[f].Series._hiloTypes&&(rt={region:{Region:{PointIndex:l[f].ClosestPointIndex},SeriesIndex:s}},this.highlightStart(i,rt,this._id+"_svg_SeriesGroup_"+s,this._id+"_svg_Series"+s+"_Point"+l[f].ClosestPointIndex,!0))}}else b=$(this.svgObject).find('[id*="_TrackSymbol_"],[id*="_TrackToolTip"]'),this.svgRenderer._setAttr($(b),{visibility:"visible"}),$("#"+this._id).find('[id*="canvas_trackSymbol"]').css("visibility","visible"),b=$(this.svgObject).find('[id*="_TrackToolTip"]').children(),this.svgRenderer._setAttr($(b),{visibility:"visible"}),b=$(this.svgObject).find('[id*="_trackSymbol_"]'),this.svgRenderer._setAttr($(b),{visibility:"visible"}),$(n.svgObject).find('[id*="_TrackAxisToolTip"]').attr("visibility","visible"),this.model.crosshair.trackballTooltipSettings.tooltipTemplate!=null&&(ut==="grouping"?(b=$(document).find('[id*="TrackGroupToolTipTemplate"]'),this.svgRenderer._setAttr($(b),{visibility:"visible"})):(b=$(document).find('[id*="_TrackToolTipTemplate_"]'),this.svgRenderer._setAttr($(b),{visibility:"visible"})))}}else $("#"+this.svgObject.id+"_TrackSymbol_"+s).remove();else this._removeTrackBall()}else vi||$(n.svgObject).find('[id*="_Tracker"]').remove(),iu=$("#"+n.svgObject.id+"_TrackSymbol_"+f),dr=this.svgObject.id+"_TrackSymbol_"+s,$("#"+this._id).find("[id*="+dr+"]").remove(),$("#"+n._id).find("[id*=_canvas_trackSymbol_"+f+"]").css("visibility","hidden"),this.model.enableCanvasRendering||($("[class*=HighlightStyle]").attr("class",""),$("[class*=HighlightLegendStyle]").attr("class",""),$("[class*=HighlightLegendPathStyle]").attr("class",""),$("[class*=HighlightPathStyle]").attr("class",""),$("[class*=Highlightseries]").attr("class",""),$("[id*="+this._id+"_Highlight_]").remove());r.trackerRemoved=!1}if(this.model.closestPoint!=null&&(this.model.prePoint={point:u.point,pointIndex:u.index,series:r,seriesIndex:s}),$("#"+this.svgObject.id+"_TrackAxisToolTip").length==0&&this.model.crosshairLabelVisibility?(gr={id:n.svgObject.id+"_TrackAxisToolTip",visibility:"visible"},n.gTrackAxisEle=n.svgRenderer.createGroup(gr),n.svgRenderer.append(n.gTrackAxisEle,n.gTrackball)):$("#"+this.svgObject.id+"_TrackAxisToolTip").css("display","block"),o&&(li=u.point[0],et?$(n.svgObject.parentElement).find('[id*="AxisToolTipRect"]').css({visibility:"hidden",display:"none"}):$(n.svgObject).find('[id*="_TrackAxisToolTip"]').attr("visibility","visible").children().attr({display:"none"}),$.each(n.model._axes,function(i,r){var c=r.x,l=r._opposed,f,u,s;if(y){if(r.orientation.toLowerCase()=="vertical"&&r.crosshairLabel.visible&&n.mousemoveY<=r.y+r.height&&r.y<=n.mousemoveY){var f=r._valueType.toLowerCase(),e=li.xValue,h=[];f=="logarithmic"&&(e=Math.pow(r.logBase,e).toFixed(2).replace(new RegExp("\\.0{2}"),""));f=="datetime"&&(e=ej.format(new Date(Math.floor(e)),ej.util.isNullOrUndefined(r.labelFormat)?ej.EjSvgRender.utils._dateTimeLabelFormat(r._intervalType,r):r.labelFormat,pt));f=="category"&&(e=ej.EjSvgRender.utils._getLabelContent(e,r,pt));h={X:r.x,Y:o.Y+r.y};n.displayAxisTooltip(h,e,r,i,t)}}else r.orientation.toLowerCase()=="horizontal"&&r.crosshairLabel.visible&&o.X+c<=r.x+r.width&&r.x<=v[v.length-1].X&&(f=r._valueType.toLowerCase(),u=(o.X/r.width*r.visibleRange.delta+r.visibleRange.min).toFixed(2).replace(new RegExp("\\.0{2}"),""),f=="logarithmic"&&(u=Math.pow(r.logBase,u)),f=="datetime"&&(u=ej.format(new Date(Math.floor(u)),ej.util.isNullOrUndefined(r.labelFormat)?ej.EjSvgRender.utils._dateTimeLabelFormat(r._intervalType,r):r.labelFormat,pt)),(f=="category"||f=="datetimecategory")&&(typeof li.x!="object"&&(u=li.xValue),u=f!="category"&&ej.util.isNullOrUndefined(r.labelFormat)?ej.format(new Date(r.labels[Math.floor(u)]),ej.EjSvgRender.utils._dateTimeLabelFormat(r.intervalType,r),pt):ej.EjSvgRender.utils._getLabelContent(Math.floor(u),r,pt),u=u?u:"undefined"),s={X:v[v.length-1].X,Y:l?r.y+r.height-r.majorTickLines.size:r.y+r.height+r.majorTickLines.size+10},n.displayAxisTooltip(s,u,r,i,t,!0))})),ut!=="grouping"&&n.model.crosshair.trackballTooltipSettings.tooltipTemplate)for(fr=$(document).find('[id*="_TrackToolTipTemplate_"]'),f=0;f<fr.length;f++)$(fr[f]).appendTo(this.templateContainer),$(this.templateContainer).appendTo(this.chartContainer)}},chartCrossHair:function(n,t){var nt=ej.util.isNullOrUndefined(this.model.primaryYAxis.roundingPlaces)?2:this.model.primaryYAxis.roundingPlaces,s=n.model.enableCanvasRendering,o=this.model.locale,c,h,w,b,l,k,a,v,i,ut;if(!this.model.enable3D&&this.model.crosshair.visible&&this.model.crosshair.type.toLowerCase()=="crosshair"){for($("#"+this.svgObject.id+"_CrosshairGroup").length==0?(c={id:this.svgObject.id+"_CrosshairGroup",visibility:"visible"},s?(c.position="absolute",n.svgRenderer.drawCrosshairLine(c,"#chartContainer_"+this._id)):(this.gCrosshair=this.svgRenderer.createGroup(c),this.svgRenderer.append(this.gCrosshair,this.svgObject))):$("#"+this.svgObject.id+"_CrosshairGroup").css("display","block"),n.model.trackerElement&&($.finish?$(this.model.trackerElement).finish():$(this.model.trackerElement).stop(!0,!0),this.model.trackerElement=null),h=this.getScaleValues(this),w=$.extend(!0,{},t),mouseX=w.x/h.x,mouseY=w.y/h.y,v=0;v<this.model._axes.length;v++)i=this.model._axes[v],i.orientation.toLowerCase()=="vertical"?mouseY>=i.y&&mouseY<=i.y+i.height&&(i.x<mouseX?b=Math.min(b||i.x,i.x):l=Math.max(l||i.x,i.x)):mouseX>=i.x&&mouseX<=i.x+i.width&&(i.y<mouseY?k=Math.min(k||i.y,i.y):a=Math.max(a||i.y,i.y));var f=b||this.model.m_AreaBounds.X,d=l?l-f:this.model.m_AreaBounds.X+this.model.m_AreaBounds.Width-f,e=k||this.model.m_AreaBounds.Y,g=a?a-e:this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height-e;this.mousemoveX=this.mousemoveX/h.x;this.mousemoveY=this.mousemoveY/h.y;var tt="M "+this.mousemoveX+" "+e+" L "+this.mousemoveX+" "+(e+g),it="M "+f+" "+this.mousemoveY+" L "+(f+d)+" "+this.mousemoveY,y=$("#"+this._id).offset(),p=n.svgObject,r,u,rt={left:p.offsetLeft>y.left?p.offsetLeft:y.left,top:p.offsetTop>y.top?p.offsetTop:y.top};$("#"+n.svgObject.id+"_CrosshairVertical").length==0?(r={id:n.svgObject.id+"_CrosshairVertical",fill:"none","stroke-width":n.model.crosshair.line.width,stroke:n.model.crosshair.line.color,"clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)",d:tt},s?(r.width=0,r.height=g,r.top=e,r.left=f,r.position="absolute",r.style="solid",r.opacity=.5,n.svgRenderer.drawCrosshairLine(r,"#"+this.svgObject.id+"_CrosshairGroup")):n.svgRenderer.drawPath(r,n.gCrosshair)):(n.svgRenderer._setAttr($(n.svgObject).find("#"+n.svgObject.id+"_CrosshairVertical"),{d:tt}),s&&($("#secondCanvas").remove(),$("#"+n.svgObject.id+"_CrosshairVertical").css("left",this.mousemoveX).css({top:e,height:g,display:"block"})),$("#"+n.svgObject.id+"_CrosshairVertical").attr("visibility","visible").css("display","block"));$("#"+n.svgObject.id+"_CrosshairHorizontal").length==0?(u={id:n.svgObject.id+"_CrosshairHorizontal",fill:"none","stroke-width":n.model.crosshair.line.width,stroke:n.model.crosshair.line.color,"clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)",d:it},s?(u.top=e+rt.top,u.left=f+rt.left,u.width=d,u.height=0,u.position="absolute",u.style="solid",u.opacity=.5,n.svgRenderer.drawCrosshairLine(u,"#"+this.svgObject.id+"_CrosshairGroup")):n.svgRenderer.drawPath(u,n.gCrosshair)):(n.svgRenderer._setAttr($(n.svgObject).find("#"+n.svgObject.id+"_CrosshairHorizontal"),{d:it}),$("#"+n.svgObject.id+"_CrosshairHorizontal").attr("visibility","visible").css("display","block"),s&&$("#"+n.svgObject.id+"_CrosshairHorizontal").css("top",this.mousemoveY).css({left:f,width:d,display:"block"}));$("#"+n.svgObject.id+"_AxisCrossToolTip").length==0?(ut={id:n.svgObject.id+"_AxisCrossToolTip",visibility:"visible"},n.gTrackAxisEle=n.svgRenderer.createGroup(ut),n.svgRenderer.append(n.gTrackAxisEle,n.gCrosshair)):(this.svgRenderer._setAttr($(n.gTrackAxisEle),{visibility:"visible"}),$(n.gTrackAxisEle).css("display","block"));$.each(n.model._axes,function(i,r){var f=r._valueType.toLowerCase(),s,u,h,e,c;r.orientation.toLowerCase()=="horizontal"&&r.crosshairLabel.visible?n.mousemoveX<=r.x+r.width&&r.x<=n.mousemoveX?(s=r._valueType=="category"&&r.labelPlacement.toLowerCase()=="betweenticks"?.5:0,u=(Math.abs(n.mousemoveX-(r.isInversed?r.x+r.width:r.x))/r.width*r.visibleRange.delta+r.visibleRange.min+s).toFixed(2).replace(new RegExp("\\.0{2}"),""),f=="logarithmic"&&(u=Math.pow(r.logBase,u).toFixed(2).replace(new RegExp("\\.0{2}"),"")),f=="datetime"&&(u=ej.format(new Date(Math.floor(u)),ej.util.isNullOrUndefined(r.labelFormat)?ej.EjSvgRender.utils._dateTimeLabelFormat(r._intervalType,r):r.labelFormat,o)),(f=="category"||f=="datetimecategory")&&(f!="category"&&ej.util.isNullOrUndefined(r.labelFormat)?(u=u<0?0:u,u=ej.format(new Date(r.labels[Math.floor(u)]),ej.EjSvgRender.utils._dateTimeLabelFormat(r.intervalType,r),o)):u=ej.EjSvgRender.utils._getLabelContent(u,r,o)),h={X:n.mousemoveX,Y:r.y},n.displayAxisTooltip(h,u,r,i,t),$("#"+n.svgObject.id+"_AxisToolTipText_"+i).show(),$("#"+n.svgObject.id+"_AxisToolTipRect_"+i).show()):($("#"+n.svgObject.id+"_AxisToolTipText_"+i).hide(),$("#"+n.svgObject.id+"_AxisToolTipRect_"+i).hide()):r.orientation.toLowerCase()=="vertical"&&r.crosshairLabel.visible&&(n.mousemoveY<=r.y+r.height&&r.y<=n.mousemoveY?(e=(Math.abs(1-Math.abs(n.mousemoveY-(r.isInversed?r.y+r.height:r.y))/r.width/r.height)*r.visibleRange.delta+r.visibleRange.min).toFixed(nt).replace(new RegExp("\\.0{"+nt+"}"),""),f=="logarithmic"&&(e=Math.pow(r.logBase,e).toFixed(2).replace(new RegExp("\\.0{2}"),"")),f=="datetime"&&(e=ej.format(new Date(Math.floor(e)),ej.util.isNullOrUndefined(r.labelFormat)?ej.EjSvgRender.utils._dateTimeLabelFormat(r._intervalType,r):r.labelFormat,o)),(f=="category"||f=="datetimecategory")&&(e=f=="category"||ej.util.isNullOrUndefined(r.labelFormat)?ej.EjSvgRender.utils._getLabelContent(e,r,o):ej.format(new Date(r.labels[Math.floor(e)]),ej.EjSvgRender.utils._dateTimeLabelFormat(r.intervalType,r),o)),c={X:r.x,Y:n.mousemoveY},n.displayAxisTooltip(c,e,r,i,t),$("#"+n.svgObject.id+"_AxisToolTipText_"+i).show(),$("#"+n.svgObject.id+"_AxisToolTipRect_"+i).show()):($("#"+n.svgObject.id+"_AxisToolTipText_"+i).hide(),$("#"+n.svgObject.id+"_AxisToolTipRect_"+i).hide()))})}},chartTouchMove:function(n){this.cancelEvent(n);n=n.originalEvent.touches[0];this.chartInteractiveBehavior(n)},isZoomButtonHovered:function(n){if(n.parentNode!=null){var t=n.parentNode.id,i=n.id;if(i.indexOf("_ZoomInBtn ")==-1&&i.indexOf("ZoomOutBtn")==-1&&i.indexOf("_ZoomBtn")==-1&&i.indexOf("_ResetZoom")==-1&&i.indexOf("_PanBtn")==-1&&t&&t.indexOf("_ZoomInBtn")==-1&&t.indexOf("_ZoomOutBtn")==-1&&t.indexOf("_ZoomBtn")==-1&&t.indexOf("_ResetZoom")==-1&&t.indexOf("_PanBtn")==-1)return!1}return!0},showTooltipOnDrag:function(n){$("#"+n.svgObject.id).find("#"+n.svgObject.id+"_TrackToolTip").attr("visibility","visible");$("#"+n.svgObject.id+"_TrackToolTip").show();$(".tooltipDiv").css("display","block")},getScaleValues:function(n){for(var t=document.getElementById(n.element[0].id),u=1,f=1,i,e,r;;){if(t.tagName=="HTML")break;e=window.getComputedStyle(t,"");r=e.getPropertyValue("transform");r!="none"&&(i=r.replace("matrix(","").replace(")","").split(","),u=parseFloat(i[0]),f=parseFloat(i[3]));t=t.parentNode}return{x:u,y:f}},chartInteractiveBehavior:function(n){var s=this.calMousePosition(n),l,a,t,o,r,i,v;this.mousemoveX=s.X;this.mousemoveY=s.Y;var u=this.getScaleValues(this),f=$.extend(!0,{},this.model.m_AreaBounds),h=f.X*u.x,c=f.Y*u.y,y=f.Width*u.x,p=f.Height*u.y,e="#"+this.svgObject.id;this.mouseWheelCoords&&(l=Math.abs(this.mouseWheelCoords.x-n.pageX),a=Math.abs(this.mouseWheelCoords.y-n.pageY),(l>0||a>0)&&!this.panning?this.enableTrackBall():this.disableTrackBall());t=this;r=n.target.id;t.model.AreaType=="cartesianaxes"&&this.mousemoveX>=h&&this.mousemoveX<h+y&&this.mousemoveY<c+p&&this.mousemoveY>=c&&this.model.initSeriesRender?(o={x:t.mousemoveX,y:t.mousemoveY},r=t.svgRenderer._getAttrVal($(n.target).parent(),"id"),r!=undefined&&(r==t.svgRenderer._getAttrVal($(this.svgObject).find(e+"_ZoomBtn"),"id")||r==t.svgRenderer._getAttrVal($(this.svgObject).find(e+"_ResetZoom"),"id")||r==t.svgRenderer._getAttrVal($(this.svgObject).find(e+"_PanBtn"),"id"))?this.disableTrackBall():this.enableTrackBall(),this.model.crosshair.visible||this.isZoomButtonHovered(n.target)?this.dragPoint?this.showTooltipOnDrag(t,n):this.closestXyPoint||($("#"+t.svgObject.id).find("#"+t.svgObject.id+"_TrackToolTip").attr("visibility","hidden"),$("#"+t.svgObject.id+"_TrackToolTip").hide(),$(".tooltipDiv"+this._id).css("display","none")):this.tooltip(t,n),this.model.enable3D||(this.chartTrackball(t,o,n),this.chartCrossHair(t,o))):(t.model.AreaType!="none"&&t.model.AreaType!="polaraxes"||this.isZoomButtonHovered(n.target)?this.dragPoint?this.showTooltipOnDrag(t,n):this.closestXyPoint||($("#"+t.svgObject.id).find("#"+t.svgObject.id+"_TrackToolTip").attr("visibility","hidden"),$("#"+t.svgObject.id+"_TrackToolTip").hide(),$(".tooltipDiv"+this._id).css("display","none"),this._removeTrackBall(),this._removeHighlight()):this.tooltip(t,n),i=this.model.prevPoint,i&&i.point&&(this.model.enableCanvasRendering?$("#canvas_trackSymbol").remove():(v=i.series.type=="boxandwhisker"?i.outlierPosition:ej.EjSvgRender.utils._getPoint(i.point,i.series),t.drawTrackerSymbol(i.series,i.seriesIndex,i.pointIndex,null,v)),this.model.prevPoint=null))},highlightSvg:function(n,t,i,r,u,f,e){var s,o,h;t!=undefined&&(s=this.svgObject.id+"_SeriesGroup_",o=t.substr(s.length),t.indexOf(this.svgObject.id+"_symbolGroup_")>=0&&(s=this.svgObject.id+"_symbolGroup_",o=t.substr(s.length)));o=u!=undefined?u.region.SeriesIndex:o;h=this.model.series[o];i&&h&&(h.highlightSettings.enable||e)&&this.highlight(n,r,h,null,u,t,f,e)},highlightCanvas:function(n,t,i){for(var c,e,u,s,o,i,r,f=0;f<this.model._visibleSeries.length;f++)if(c=f,e=this.model._visibleSeries[f],u=e.type.toLowerCase(),this.model.AreaType=="cartesianaxes"&&e.visibility.toLowerCase()=="visible"&&u!=="scatter"&&u!=="bubble"&&u!=="column"&&u.indexOf("bar")==-1&&u!=="stackingcolumn"&&u!=="stackingcolumn100"&&!e._hiloTypes){var h=this.calMousePosition(t);this.mousemoveX=h.X;this.mousemoveY=h.Y;s=this.getClosesPointXY([],[],e,this.mousemoveX,this.mousemoveY,t);ej.util.isNullOrUndefined(s.point)||(o=$.extend({},ej.EjSvgRender.commonChartEventArgs),o.data={location:{x:this.mousemoveX,y:this.mousemoveY},region:{SeriesIndex:f,Region:{PointIndex:s.index}}})}i=o?o.data:i;i&&this.model.series[i.region.SeriesIndex].highlightSettings.enable&&(r=$.extend({},this.model.series[i.region.SeriesIndex]),r.pointIndex=i.region.Region.PointIndex,r.seriesIndex=i.region.SeriesIndex,r.data=i,$("#"+this._id+"_Selection_series"+r.seriesIndex+"_canvas").length==0&&($("[id*="+this._id+"_Highlight_]").remove(),this.findCanvasSelection(r.seriesIndex,r.pointIndex,r.selectionSettings.mode.toLowerCase())||this.canvasHighlight(this,t,r)))},resizeCursor:function(n,t,i,r,u,f,e){var o=this.selectedRectIndex;t<=r||i<=u||t>=f+r||i>=e+u?($("#"+n+"_resize_rightRect"+o).css({cursor:"default"}),$("#"+n+"_resize_leftRect"+o).css({cursor:"default"}),$("#"+n+"_resize_bottomRect"+o).css({cursor:"default"}),$("#"+n+"_resize_topRect"+o).css({cursor:"default"}),$("#"+n+"_resize_bottomRightCornerCircle"+o).css({cursor:"default"})):(t>=r||i>=u||t<=f+r||i<=e+u)&&($("#"+n+"_resize_rightRect"+o).css({cursor:"e-resize"}),$("#"+n+"_resize_leftRect"+o).css({cursor:"w-resize"}),$("#"+n+"_resize_bottomRect"+o).css({cursor:"s-resize"}),$("#"+n+"_resize_topRect"+o).css({cursor:"n-resize"}),$("#"+n+"_resize_bottomRightCornerCircle"+o).css({cursor:"se-resize"}))},multiSelectMouseMove:function(evt){var q,rectOptions,translate;if(this._isMultiSelect&&this.multiSelectMode=="range"&&!this.dragPoint){var mouseMoveCords=this.calMousePosition(evt),mouseMoveX=mouseMoveCords.X,mouseMoveY=mouseMoveCords.Y,gripMouseMoveX,gripMouseMoveY,translate,selectionSettingsType=this.multiSelectType,width,height,x,y,rectX,rectY,rectWidth,rectHeight,id,x1,x2,y1,y2,xPlotOffset,yPlotOffset,modifiedX,modifiedY,mouseDownX=this.mouseDownX,mouseDownY=this.mouseDownY,selectedRectIndex=this.selectedRectIndex,containerSvg=this.svgObject.id,chartArea="#"+containerSvg+"_ChartArea",chartAreaX=parseInt($(chartArea).attr("x")),chartAreaY=parseInt($(chartArea).attr("y")),chartAreaWidth=parseInt($(chartArea).attr("width")),chartAreaHeight=parseInt($(chartArea).attr("height")),multiSelectMouseDownId=this.multiSelectMouseDownId,selctRectId="#"+containerSvg+"_selectRect",multiAxis=this.multiAxis;for(q=0;q<multiAxis.length;q++)multiAxis[q].orientation.toLowerCase()=="horizontal"?(x1=multiAxis[q].Location.X1,x2=multiAxis[q].Location.X2,xPlotOffset=multiAxis[q].plotOffset):(y1=multiAxis[q].Location.Y1,y2=multiAxis[q].Location.Y2,yPlotOffset=multiAxis[q].plotOffset);if(this.drag&&!this.resize&&!this.rectPan&&!this.removeRect){var currentX=mouseMoveX,currentY=mouseMoveY,areaBounds=this.model.m_AreaBounds;this.multiSelectDraw=!0;mouseMoveX<areaBounds.X?currentX=areaBounds.X:mouseMoveX>areaBounds.X+areaBounds.Width&&(currentX=areaBounds.X+areaBounds.Width);currentY=mouseMoveY<areaBounds.Y?areaBounds.Y:mouseMoveY>areaBounds.Y+areaBounds.Height?areaBounds.Y+areaBounds.Height:mouseMoveY;switch(selectionSettingsType){case"x":width=Math.abs(currentX-mouseDownX);height=y1-y2+yPlotOffset+yPlotOffset;x=currentX>mouseDownX?mouseDownX:currentX;y=y2-yPlotOffset;break;case"y":width=x2-x1+xPlotOffset+xPlotOffset;height=Math.abs(currentY-mouseDownY);x=x1-xPlotOffset;y=currentY>mouseDownY?mouseDownY:currentY;break;case"xy":width=Math.abs(currentX-mouseDownX);height=Math.abs(currentY-mouseDownY);x=currentX>mouseDownX?mouseDownX:currentX;y=currentY>mouseDownY?mouseDownY:currentY}width>0&&height>0&&(rectOptions={id:this.svgObject.id+"_selectRect"+this.selectedRectIndex,x:x,y:y,width:width,height:height,fill:"rgba(41,136,214,0.2)","stroke-width":2,stroke:"rgba(41,136,214,0.5)",cursor:"pointer","clip-path":"url(#"+this.svgObject.id+"_ChartAreaClipRect)"},x>=x1+xPlotOffset&&mouseMoveX<=x2-xPlotOffset&&mouseMoveY<=y1+yPlotOffset&&y>=y2-yPlotOffset&&this.svgRenderer.drawRect(rectOptions,this.gEle),this.gEle!=null&&($(this.gEle).appendTo(this.parentgEle),this.selectedRectIndex==0&&(this.model.gCurrentEle=this.gEle),$(this.parentgEle).appendTo(this.svgObject)))}if(rectX=parseInt($(selctRectId+selectedRectIndex).attr("x")),rectY=parseInt($(selctRectId+selectedRectIndex).attr("y")),rectWidth=parseInt($(selctRectId+selectedRectIndex).attr("width")),rectHeight=parseInt($(selctRectId+selectedRectIndex).attr("height")),!this.drag&&(evt.target.id.indexOf("selectRect")>=0||evt.target.id.indexOf("resize")>=0)){evt.target.parentNode.id.indexOf("selectedRect")>=0&&(id=evt.target.parentNode.id.split("selectedRect")[1].match(/\d+/)[0],this.gripIndex=eval(id));var selectRectId="#"+containerSvg+"_selectRect",selectRectWidth=parseInt($(selectRectId+this.gripIndex).attr("width")),selectRectHeight=parseInt($(selectRectId+this.gripIndex).attr("height")),selectRectX=parseInt($(selectRectId+this.gripIndex).attr("x")),selectRectY=parseInt($(selectRectId+this.gripIndex).attr("y"));$("#"+containerSvg+"_gripCollection"+selectedRectIndex).css({visibility:"hidden"});(selectRectX+selectRectWidth-16>=selectRectX||selectRectY+selectRectHeight-16>=selectRectY)&&$("#"+this.svgObject.id+"_gripCollection"+this.gripIndex).attr({transform:""});(selectRectX+selectRectWidth-16<selectRectX||selectRectY+selectRectHeight-16<selectRectY)&&(translate="translate(15,15)",$("#"+this.svgObject.id+"_gripCollection"+this.gripIndex).attr({transform:translate}));this.oldId!=evt.target.id&&$("#"+containerSvg+"_gripCollection"+this.oldGripIndex).css({visibility:"hidden"});$("#"+containerSvg+"_gripCollection"+this.gripIndex).css({visibility:"visible"});this.oldId=evt.target.id;this.oldGripIndex=this.gripIndex}if(evt.target.id.indexOf("selectRect")<0&&evt.target.id.indexOf("resize")<0&&$("#"+containerSvg+"_gripCollection"+this.gripIndex).css({visibility:"hidden"}),this.resize){$("#"+containerSvg+"_closeTopRightCornerCircle"+selectedRectIndex).hide();$("#"+containerSvg+"_closePath"+selectedRectIndex).hide();$("#"+containerSvg+"_closePathOpposite"+selectedRectIndex).hide();$("#"+containerSvg+"_gripCollection"+selectedRectIndex).css({visibility:"hidden"});var oldRectX=this.oldRectX[selectedRectIndex],oldRectY=this.oldRectY[selectedRectIndex],oldRectHeight=this.oldRectHeight[selectedRectIndex],oldRectWidth=this.oldRectWidth[selectedRectIndex],oldReBottomRectY=this.oldReBottomRectY[selectedRectIndex],oldReRightRectX=this.oldReRightRectX[selectedRectIndex];switch(selectionSettingsType){case"x":multiSelectMouseDownId==containerSvg+"_resize_rightRect"+selectedRectIndex?(rectWidth=mouseMoveX-oldRectX,$("#"+containerSvg+"_resize_rightRect"+selectedRectIndex).attr("x",mouseMoveX-5),mouseMoveX<oldRectX?(rectX=mouseMoveX,rectWidth=oldRectX-mouseMoveX):mouseMoveX>=oldRectX&&(rectX=oldRectX)):multiSelectMouseDownId==containerSvg+"_resize_leftRect"+selectedRectIndex&&(rectX=mouseMoveX,rectWidth=oldRectWidth+oldRectX-mouseMoveX,$("#"+containerSvg+"_resize_leftRect"+selectedRectIndex).attr("x",mouseMoveX-5),mouseMoveX>oldReRightRectX+5&&(rectX=oldReRightRectX+5,rectWidth=mouseMoveX-oldRectX-oldRectWidth));this.resizeCursor(containerSvg,mouseMoveX,mouseMoveY,chartAreaX,chartAreaY,chartAreaWidth,chartAreaHeight);break;case"y":multiSelectMouseDownId==containerSvg+"_resize_topRect"+selectedRectIndex?(rectHeight=oldRectHeight+oldRectY-mouseMoveY,rectY=mouseMoveY,$("#"+containerSvg+"_resize_topRect"+selectedRectIndex).attr("y",mouseMoveY-5),mouseMoveY>oldReBottomRectY+5&&(rectY=oldReBottomRectY+5,rectHeight=mouseMoveY-oldRectY-oldRectHeight)):multiSelectMouseDownId==containerSvg+"_resize_bottomRect"+selectedRectIndex&&(rectHeight=mouseMoveY-oldRectY,$("#"+containerSvg+"_resize_bottomRect"+selectedRectIndex).attr("y",mouseMoveY-5),mouseMoveY<oldRectY?(rectY=mouseMoveY,rectHeight=oldRectY-mouseMoveY):mouseMoveY>=oldRectY&&(rectY=oldRectY));this.resizeCursor(containerSvg,mouseMoveX,mouseMoveY,chartAreaX,chartAreaY,chartAreaWidth,chartAreaHeight);break;case"xy":multiSelectMouseDownId==containerSvg+"_resize_rightRect"+selectedRectIndex?(rectWidth=mouseMoveX-oldRectX,$("#"+containerSvg+"_resize_rightRect"+selectedRectIndex).attr("x",mouseMoveX-5),mouseMoveX<oldRectX?(rectX=mouseMoveX,rectWidth=oldRectX-mouseMoveX):mouseMoveX>=oldRectX&&(rectX=oldRectX)):multiSelectMouseDownId==containerSvg+"_resize_leftRect"+selectedRectIndex?(rectX=mouseMoveX,rectWidth=oldRectWidth+oldRectX-mouseMoveX,$("#"+containerSvg+"_resize_leftRect"+selectedRectIndex).attr("x",mouseMoveX-5),mouseMoveX>oldReRightRectX+5&&(rectX=oldReRightRectX+5,rectWidth=mouseMoveX-oldRectX-oldRectWidth)):multiSelectMouseDownId==containerSvg+"_resize_topRect"+selectedRectIndex?(rectHeight=oldRectHeight+oldRectY-mouseMoveY,rectY=mouseMoveY,$("#"+containerSvg+"_resize_topRect"+selectedRectIndex).attr("y",mouseMoveY-5),mouseMoveY>oldReBottomRectY+5&&(rectY=oldReBottomRectY+5,rectHeight=mouseMoveY-oldRectY-oldRectHeight)):multiSelectMouseDownId==containerSvg+"_resize_bottomRect"+selectedRectIndex?(rectHeight=mouseMoveY-oldRectY,$("#"+containerSvg+"_resize_bottomRect"+selectedRectIndex).attr("y",mouseMoveY-5),mouseMoveY<oldRectY?(rectY=mouseMoveY,rectHeight=oldRectY-mouseMoveY):mouseMoveY>=oldRectY&&(rectY=oldRectY)):multiSelectMouseDownId==containerSvg+"_resize_bottomRightCornerCircle"+selectedRectIndex&&(rectWidth=mouseMoveX-oldRectX,rectHeight=mouseMoveY-oldRectY,$("#"+containerSvg+"_resize_bottomRightCornerCircle"+selectedRectIndex).attr({cx:mouseMoveX,cy:mouseMoveY}),mouseMoveX<oldRectX&&mouseMoveY<oldRectY?(rectX=mouseMoveX,rectY=mouseMoveY,rectWidth=oldRectX-mouseMoveX,rectHeight=oldRectY-mouseMoveY):mouseMoveX<oldRectX?(rectX=mouseMoveX,rectWidth=oldRectX-mouseMoveX):mouseMoveY<oldRectY?(rectY=mouseMoveY,rectHeight=oldRectY-mouseMoveY):mouseMoveX>=oldRectX&&mouseMoveY>=oldRectY&&(rectX=oldRectX,rectY=oldRectY));this.resizeCursor(containerSvg,mouseMoveX,mouseMoveY,chartAreaX,chartAreaY,chartAreaWidth,chartAreaHeight)}switch(selectionSettingsType){case"x":rectX>=x1-xPlotOffset&&rectWidth+rectX-x1<=x2-x1-xPlotOffset&&$(selctRectId+selectedRectIndex).attr({x:rectX,width:rectWidth});break;case"y":rectHeight+rectY-y2<=y1-y2+yPlotOffset&&rectY>=y2-yPlotOffset&&$(selctRectId+selectedRectIndex).attr({y:rectY,height:rectHeight});break;case"xy":rectX>=x1-xPlotOffset&&rectWidth+rectX-x1<=x2-x1-xPlotOffset&&rectHeight+rectY-y2<=y1-y2+yPlotOffset&&rectY>=y2-yPlotOffset&&$(selctRectId+selectedRectIndex).attr({x:rectX,y:rectY,width:rectWidth,height:rectHeight})}}if(this.rectPan){$("#"+containerSvg+"_closeTopRightCornerCircle"+selectedRectIndex).hide();$("#"+containerSvg+"_closePath"+selectedRectIndex).hide();$("#"+containerSvg+"_closePathOpposite"+selectedRectIndex).hide();$("#"+containerSvg+"_gripCollection"+selectedRectIndex).css({visibility:"hidden"});(mouseMoveX<=chartAreaX||mouseMoveY<=chartAreaY||mouseMoveX>=chartAreaX+chartAreaWidth||mouseMoveY>=chartAreaY+chartAreaHeight)&&this.multiSelectMouseUp(evt);modifiedX=this.PreviousCoords.X-evt.pageX;modifiedY=this.PreviousCoords.Y-evt.pageY;rectX=rectX-modifiedX;rectY=rectY-modifiedY;this.PreviousCoords.X=evt.pageX;this.PreviousCoords.Y=evt.pageY;switch(selectionSettingsType){case"x":rectX>=x1-xPlotOffset&&rectWidth+rectX-x1<=x2-x1-xPlotOffset&&$(selctRectId+selectedRectIndex).attr({x:rectX});break;case"y":rectHeight+rectY-y2<=y1-y2+yPlotOffset&&rectY>=y2-yPlotOffset&&$(selctRectId+selectedRectIndex).attr({y:rectY});break;case"xy":rectX>=x1-xPlotOffset&&rectWidth+rectX-x1<=x2-x1-xPlotOffset&&rectHeight+rectY-y2<=y1-y2+yPlotOffset&&rectY>=y2-yPlotOffset&&$(selctRectId+selectedRectIndex).attr({x:rectX,y:rectY})}}}},isTouch:function(n){var i=this.model.browserInfo,t=n.originalEvent?n.originalEvent:n;return t.pointerType=="touch"||t.pointerType==2||t.type.indexOf("touch")>-1?!0:!1},highlightStart:function(n,t,i,r,u){if(n.target.parentNode!=null)var i=i||n.target.parentNode.id,f=i.indexOf(this.svgObject.id+"_SeriesGroup_")>=0||i.indexOf(this.svgObject.id+"_symbolGroup_")>=0||i.indexOf(this.svgObject.id+"_TrackSymbol_")>=0||i.indexOf(this.svgObject.id+"_Chart3D")>=0?!0:!1;this.model.enableCanvasRendering?this.highlightCanvas(this,n,t):this.highlightSvg(this,i,f,n,t,r,u)},_changeDraggingPoints:function(n,t,i,r){i=n.xAxis._valueType=="datetime"?new Date(i):i;r=n.yAxis._valueType=="datetime"?new Date(r):r;var u=n.dragSettings.type.toLowerCase();(u=="x"||u=="xy")&&n.xAxis._valueType!="category"&&(this.dragPoint?(n.pointCollection[t].x=i,n.pointCollection[t].xValue=n.xAxis._valueType=="datetime"&&typeof i!="object"?new Date(i):i):(n._visiblePoints[t].x=n.points[t].x=i,n._visiblePoints[t].xValue=n.points[t].xValue=n.xAxis._valueType=="datetime"&&typeof i=="object"?Date.parse(i):i),ej.util.isNullOrUndefined(n.dataSource)||(n.dataSource[t][n.xName]=i));(u=="y"||u=="xy")&&(this.dragPoint?(n.pointCollection[t].y=r,n.pointCollection[t].YValues[0]=n.yAxis._valueType=="datetime"&&typeof r!="object"?new Date(r):r):(n._visiblePoints[t].y=n.points[t].y=r,n._visiblePoints[t].YValues[0]=n.points[t].YValues[0]=n.yAxis._valueType=="datetime"&&typeof r=="object"?Date.parse(r):r),ej.util.isNullOrUndefined(n.dataSource)||(n.dataSource[t][n.yName]=r))},_dragDelta:function(n,t,i,r,u,f){var h=this,o={X:i,Y:r},s={X:n,Y:t},e=$.extend({},this.commonDragEventArgs);e.data={seriesIndex:u,pointIndex:f,oldValue:o,newValue:s};this._trigger("dragging",e);this.commonDragEventArgs=e},_getDraggedPoint:function(n,t,i){var u,o,s,f,e,r=ej.EjSvgRender.utils._getTransform(n.xAxis,n.yAxis,this.model.requireInvertedAxes);return this.model.requireInvertedAxes?(f=r.y+r.height-i,e=t-r.x):(f=t-r.x,e=r.y+r.height-i),u=ej.EjSvgRender.utils._getValuebyPoint(f,e,n,this.model.requireInvertedAxes),o=parseFloat(u.PointX.toFixed(2)),s=parseFloat(u.PointY.toFixed(2)),{X:o,Y:s}},_pointDragandDrop:function(n,t,i){var b=n.data.seriesIndex,e,p=[],k=null,f=n.type.toLowerCase(),c={},l,w,rt,ft,r,o,u,s;for(c.axes={},l=0;l<this.model._axes.length;l++)c.axes[this.model._axes[l].name]={};$("[id*=_Marker]").remove();var d=this._getDraggedPoint(n,this.mousemoveX,this.mousemoveY),g=d.X,nt=d.Y,tt=this.commonDragEventArgs.data.currentPoint?this.commonDragEventArgs.data.currentPoint.xValue:this.commonDragEventArgs.data.oldValue.X,it=this.commonDragEventArgs.data.currentPoint?this.commonDragEventArgs.data.currentPoint.yValue[0]:this.commonDragEventArgs.data.oldValue.Y;if(n.region?(s=n.region,i._dragDelta(g,nt,tt,it,s.SeriesIndex,s.Region.PointIndex)):(w=n.pointData,i._dragDelta(g,nt,tt,it,w.seriesIndex,w.index)),this.model.enableCanvasRendering)this.canvasElement&&this.canvasElement.clearRect(0,0,i.svgWidth,i.svgHeight),$("#"+i._id+"_PreviewSeries"+b+"_canvas").length==0&&(rt=document.getElementById(i._id+"_canvas").getBoundingClientRect(),e=this.createCanvasElement(i._id+"_PreviewSeries"+b+"_canvas",i.svgWidth,i.svgHeight,rt),this.createRect(i,e),this.canvasElement=e);else{n.xAxis=n.xAxis===null||n.xAxis===undefined?this.model._axes[0]:n.xAxis;n.yAxis=n.yAxis===null||n.yAxis===undefined?this.model._axes[1]:n.yAxis;var ut=ej.EjSvgRender.utils._getTransform(n.xAxis,n.yAxis,this.model.requireInvertedAxes),k="translate("+ut.x+","+ut.y+")",ct={id:this.svgObject.id+"_PreviewSeriesGroup",transform:k,cursor:"default",visibility:"visible"};$("#"+this.svgObject.id+"_PreviewSeriesGroup").attr("transform",k);this.gPreviewSeriesGroupEle||(this.chartObj=i,this.chartObj.gPreviewSeriesGroupEle=this.gPreviewSeriesGroupEle=this.svgRenderer.createGroup(ct));this.gPreviewSeriesGroupEle.childNodes.length>0&&this.gPreviewSeriesGroupEle.removeChild(this.gPreviewSeriesGroupEle.childNodes[0])}p=$.extend(!0,{},n._visiblePoints);n.pointCollection=p;p.length=n._visiblePoints.length;var a=i.commonDragEventArgs.data,h=a.pointIndex,v=a.seriesIndex;if(i._changeDraggingPoints(n,h,a.newValue.X,a.newValue.Y),ft=new ej.seriesTypes[f],r=n.pointCollection[h],f=="bubble")u=ej.EjSvgRender.utils._getPoint(r,n),o={id:this.svgObject.id+"_PreviewSeries"+v+"_Point"+h,cx:u.X+this.canvasX,cy:u.Y+this.canvasY,r:r.radius,fill:n.fill,"stroke-width":2,visibility:"visible","stroke-dasharray":"",opacity:.6,stroke:"transparent"},this.model.enableCanvasRendering?ej.EjCanvasRender.prototype.drawCircle(o,e):this.svgRenderer.drawCircle(o,this.gPreviewSeriesGroupEle),this.svgRenderer.append(this.gPreviewSeriesGroupEle,this.gSeriesEle);else if(f=="scatter"){var u=ej.EjSvgRender.utils._getPoint(r,n),et=n.marker.shape.capitalizeFirstString(),u={startX:u.X+this.canvasX,startY:u.Y+this.canvasY},ot={ShapeSize:{width:n.marker.size.width,height:n.marker.size.height},ID:this.svgObject.id+"_PreviewSeries"+v+"_Point"+h,Style:{Color:n.fill,BorderWidth:n.marker.border.width,BorderColor:"transparent",Opacity:.6,Visibility:"visible"}};this.model.enableCanvasRendering?ej.EjSvgRender.chartSymbol["_draw"+et](u,ot,this,e):ej.EjSvgRender.chartSymbol["_draw"+et](u,ot,this,this.gPreviewSeriesGroupEle);this.svgRenderer.append(this.gPreviewSeriesGroupEle,this.gSeriesEle)}else if(f=="column"||f=="bar"){r.xValue=typeof r.xValue=="object"?Date.parse(r.xValue):r.xValue;var lt=ej.EjSeriesRender.prototype.getOrigin(i,n,c),at=n.sidebysideInfo,st=r.YValues[0],vt=lt,ht=ej.EjSeriesRender.prototype.calculateSides(r,at),yt=ht.x1,pt=ht.x2,y=ej.EjSeriesRender.prototype.getRectangle(yt,st,pt,vt,n,i);o={id:this.svgObject.id+"_PreviewSeries"+v+"_Point"+h,x:y.X+this.canvasX,y:y.Y+this.canvasY,width:y.Width,height:y.Height,cornerRadius:n.cornerRadius,fill:n.fill,"stroke-width":2,plot:st<0?"negative":"positive",opacity:.6,stroke:"transparent","stroke-dasharray":""};this.model.enableCanvasRendering?ej.EjCanvasRender.prototype.drawRect(o,e):(this.svgRenderer.drawRect(o,this.gPreviewSeriesGroupEle),this.svgRenderer.append(this.gPreviewSeriesGroupEle,this.gSeriesEle))}else(f=="spline"||f=="splinearea")&&(r.xValue=typeof r.xValue=="object"?Date.parse(r.xValue):r.xValue),ft.draw(this,n,c);u=ej.EjSvgRender.utils._getPoint(r,n);n.tooltip.visible&&(ej.util.isNullOrUndefined(n.tooltip.template)?($(".tooltipDiv"+this._id).remove(),i.displayShowTooltip(u,r,n,r.actualIndex)):($("#"+i.svgObject.id).find("#"+i.svgObject.id+"_TrackToolTip").attr("visibility","hidden"),s={SeriesIndex:v,Region:{PointIndex:r.actualIndex}},i.createTooltip(s,t,n)))},_dragPointMarker:function(n,t,i,r,u){var f=null,o,s=n.seriesIndex,h,c,e;f=ej.EjSvgRender.utils._getPoint(u.point,n);this.model.enableCanvasRendering?$("#"+this.svgObject.id+"_Marker").length==0&&(h=document.getElementById(this.svgObject.id).getBoundingClientRect(),o=this.createCanvasElement(this.svgObject.id+"_Marker",this.svgWidth,this.svgHeight,h)):(c={id:this.svgObject.id+"_markerGroup_"+s},this.gMarkerGroupEle||(this.gMarkerGroupEle=this.svgRenderer.createGroup(c)));e={id:this.svgObject.id+"_Series"+s+"_Point"+u.index+"_Marker",cx:f.X+this.model.m_AreaBounds.X,cy:f.Y+this.model.m_AreaBounds.Y,r:7,fill:n.fill,"stroke-width":3,opacity:1,stroke:"white",visibility:"visible"};this.model.enableCanvasRendering?ej.EjCanvasRender.prototype.drawCircle(e,o):(this.svgRenderer.drawCircle(e,this.gMarkerGroupEle),this.svgRenderer.append(this.gMarkerGroupEle,this.gSeriesEle))},_dragPointGripper:function(n){var i=n.region.type.toLowerCase(),h=this.model._visibleSeries[n.region.SeriesIndex],k=h._visiblePoints[n.region.Region.PointIndex],u=h.isTransposed,c,v=h.yAxis.isInversed,y,p,w,e,l,a,b,r,s,t,o,f;if(i=="column"||i=="bar"){for(this.model.enableCanvasRendering?(y=document.getElementById(this.svgObject.id).getBoundingClientRect(),c=this.createCanvasElement(this.svgObject.id+"_Marker",this.svgWidth,this.svgHeight,y),document.getElementById(c.canvas.id).style.zIndex=1):(p={id:this.svgObject.id+"_markerGroup_"+n.region.SeriesIndex},this.gMarkerGroupEle||(this.gMarkerGroupEle=this.svgRenderer.createGroup(p))),w=3,t=n.region.Region.Bounds,(u&&i=="bar"||i=="column"&&!u)&&(e=t.Width,l=t.X),(!u&&i=="bar"||i=="column"&&u)&&(e=t.Height,l=t.Y),a=e<75?e-e/3:50,b=e>75?e-75:0,r=(a-6)/6,s=b/2+l+a/6+r/2,o=1;o<=w;o++)f={id:this.svgObject.id+"_Series"+n.region.SeriesIndex+"_Point"+n.region.Region.PointIndex+"_Marker"+o,fill:"white",opacity:1,stroke:"white",visibility:"visible"},s+=o==1?r:2*r+3,f.r=Math.abs(r),(u&&i=="bar"||i=="column"&&!u)&&(f.cx=s,f.cy=v?t.Y+t.Height-r-5:t.Y+r+5),(!u&&i=="bar"||i=="column"&&u)&&(f.cx=v?t.X+r+5:t.X+t.Width-r-5,f.cy=s),this.model.enableCanvasRendering?ej.EjCanvasRender.prototype.drawCircle(f,c):this.svgRenderer.drawCircle(f,this.gMarkerGroupEle);this.svgRenderer.append(this.gMarkerGroupEle,this.gSeriesEle)}},chartMouseMove:function(n){function v(t){var i=s._id,r;$("#"+i+"_tooltip").length<=0?(r=$("<div><\/div>").attr({id:i+"_tooltip","class":"zoom"+i}),$(r).html("&nbsp"+t+"&nbsp"),$(document.body).append(r),$(r).css({left:n.pageX+10,top:n.pageY+10,display:"block",position:"absolute","z-index":"13000",cursor:"default","font-family":"Segoe UI",color:"#707070","font-size":"12px","background-color":"#FFFFFF",border:"1px solid #707070"})):$("#"+i+"_tooltip").css({left:n.pageX+10,top:n.pageY+10})}var oi=this.GetSeriesPoint(n),l=this.svgObject,t=this.model,pt=t.zooming.enable,b=t.enableCanvasRendering,ki,wt,bt,kt,ut,si,w,ft,et,s,hi,ci,nt,gt,ni,ti,ii,k,fi,h,e,c,ei,i,dt,lt,li,at,y,o,a,yt,u,f,d;if(t.event=n,clearTimeout(this.removeTooltip),this.doPan&&n.target.id.indexOf(this._id+"_scrollbar")>-1&&(this.doPan=!1),ki=n.target.classList,wt={left:0,top:0},this.multiSelectAreaType!="cartesianaxes"||pt||b||this.multiSelectMouseMove(n),this.rotateActivate&&this.oPreviousCoords){if(bt=this.oPreviousCoords.Y-this.mousemoveY,kt=this.oPreviousCoords.X-this.mousemoveX,(kt||bt)&&(t.tilt-=bt,t.rotation+=kt,this.model.isSelected&&(ut=this.selectedStyle(this)),this.isTouch(n)||$(this.chart3D).empty(),$("#template_group_"+this._id).empty(),si={Width:$(l).width(),Height:$(l).height()},this.graphics.view(l,this,t.rotation,t.tilt,si,t.perspectiveAngle,t.depth),this.svgRenderer.append(this.chart3D,l),this.model.isSelected))for(i=0;i<ut.length;i++)$("#"+ut[i].id).attr("class",ut[i].className);this.oPreviousCoords.Y=this.mousemoveY;this.oPreviousCoords.X=this.mousemoveX}var gi=n.target.id,p=l.id,di=this.isZoomButtonHovered(n.target),g=t._visibleSeries,dt=g.length;for($("[id*=_Marker]").remove(),i=dt-1;i>=0;i--)if(w=g[i],nt=w.type.toLowerCase(),w.dragSettings.enable&&!t.enable3D){if(this._enableDragging(w,i,n),this.dragPoint)break;if(rt=this.calMousePosition(n),this.mousemoveX=rt.X,this.mousemoveY=rt.Y,ft=this.GetSeriesPoint(n),!w.marker.visible&&nt!="bubble"&&nt!="scatter"&&nt!="column"&&nt!="bar"&&(et=this.getClosesPointXY(hi,ci,w,this.mousemoveX,this.mousemoveY,n),et.point)){w.seriesIndex=i;this._dragPointMarker(w,this.mousemoveX,this.mousemoveY,n,et);this.closestXyPoint=et;break}if(ft&&ft.region.SeriesIndex==i){this._dragPointGripper(ft);break}}if(s=this,this.dragPoint&&(hi=[],ci=[],$(document).keyup(function(n){n.keyCode==27&&($(".tooltipDiv"+this._id).remove(),$("#"+p+"_TrackToolTip").remove(),s.dragPoint=!1,g[s.commonDragEventArgs.data.seriesIndex].pointCollection=null,s.chartMouseUp(n))}),a=this.dragIndex.seriesIndex,s._pointDragandDrop(g[a],n,s)),this.calMousePosition(n),$("#"+this._id+"_tooltip").remove(),!this.dragPoint&&(this.drag||di||(this.isTouch(n)||t.doubleTapped)&&!t.crosshairMoved)||this.chartInteractiveBehavior(n),t.crosshair.visible&&t.AreaType=="cartesianaxes"||(b&&oi||($("[class*=HighlightStyle]").attr("class",""),$("[class*=HighlightLegendStyle]").attr("class",""),$("[class*=HighlightLegendPathStyle]").attr("class",""),$("[class*=HighlightPathStyle]").attr("class",""),$("[class*=Highlightseries]").attr("class",""),$("[id*="+this._id+"_Highlight_]").remove()),this.highlightStart(n,oi)),!this.panning&&(e="#"+p,pt&&t.AreaType=="cartesianaxes"&&!t.enable3D&&this.drag&&!this.dragPoint&&!this.chartRightClick)){this.disableTrackBall();$("#"+p+"_ZoomArea").remove();var ot,st,ht,ct,u=this.mousemoveX,f=this.mousemoveY,r=t.m_AreaBounds;this.mousemoveX<r.X?u=r.X:this.mousemoveX>r.X+r.Width&&(u=r.X+r.Width);f=this.mousemoveY<r.Y?r.Y:this.mousemoveY>r.Y+r.Height?r.Y+r.Height:this.mousemoveY;gt=t.zooming.type.toLowerCase();gt=="x"?(ot=Math.abs(u-this.mouseDownX),st=r.Height,ht=u>this.mouseDownX?this.mouseDownX:u,ct=r.Y):gt=="y"?(ot=r.Width,st=Math.abs(f-this.mouseDownY),ht=r.X,ct=f>this.mouseDownY?this.mouseDownY:f):(ot=Math.abs(u-this.mouseDownX),st=Math.abs(f-this.mouseDownY),ht=u>this.mouseDownX?this.mouseDownX:u,ct=f>this.mouseDownY?this.mouseDownY:f);$(l).css({"-moz-user-select":"-moz-none","-khtml-user-select":"none","-webkit-user-select":"none","-ms-user-select":"none","user-select":"none"});this.zooming=!0;ni={id:p+"_ZoomArea",x:ht+wt.left,y:ct+wt.top,width:ot,height:st,fill:"rgba(69,114,167,0.25)","stroke-width":1,stroke:"rgba(69,114,167,0.25)","clip-path":"url(#"+p+"_ChartAreaClipRect)"};b?this.svgRenderer.drawZoomRect(ni,this):this.svgRenderer.drawRect(ni,l)}if(ti=t.zooming.enableDeferredZoom,this.panning&&this.doPan&&t.AreaType=="cartesianaxes"&&!this.dragPoint)if(this.currentPageX=n.pageX,this.currentPageY=n.pageY,$("#secondCanvas").remove(),$("#"+this._id+"_canvas").css({cursor:"pointer"}),ej.isTouchDevice()||ti){if(ej.isTouchDevice()||ti){for(k=0;k<g.length;k++){var o=t.series[k],tt=ej.EjSvgRender.utils._getTransform(o.xAxis,o.yAxis,t.requireInvertedAxes),ri=n.pageX-this.oPreviousCoords.x+tt.x,ui=n.pageY-this.oPreviousCoords.y+tt.y,it="translate("+ri+","+ui+")";$("#"+p+"_SeriesGroup_"+k).attr("transform",it);$("#"+p+"_symbolGroup_"+k).attr("transform",it);$("#"+p+"_TextGroup_"+k).attr("transform",it)}for(a=0;a<t.indicators.length&&t.indicators[a]._points.length>0;a++)fi=t.indicators[a],tt=ej.EjSvgRender.utils._getTransform(fi.xAxis,fi.yAxis,t.requireInvertedAxes),ri=n.pageX-this.oPreviousCoords.x+tt.x,ui=n.pageY-this.oPreviousCoords.y+tt.y,it="translate("+ri+","+ui+")",$("#"+p+"_indicatorGroup_"+a).attr("transform",it)}}else ii={x:this.oPreviousCoords.x-n.pageX,y:this.oPreviousCoords.y-n.pageY},this.oPreviousCoords={x:n.pageX,y:n.pageY},$.each(t._axes,function(n,t){var i=Math.max(1/ej.EjSvgRender.utils._minMax(t.zoomFactor,0,1),1);s.translate(t,ii.x,ii.y,i)}),this._updateScroll(),this.redraw(!0,null,n.target,this.isTouch(n)),this._cursorToPointer(),this._enableZoomingButtons();if(h=n.target.id,h!=""||ej.util.isNullOrUndefined(n.target.parentNode)||(h=n.target.parentNode.id.indexOf("_XLabel_")>=0||n.target.parentNode.id.indexOf("_YLabel_")>=0?n.target.parentNode.id:h),e=this._id,c=ej.util.isNullOrUndefined(n.target.parentNode)?"":n.target.parentNode.id,pt&&(c==e+"_svg_ResetZoom"?v(this._localizedLabels.reset):c==e+"_svg_PanBtn"?v(this._localizedLabels.pan):c==e+"_svg_ZoomBtn"?v(this._localizedLabels.zoom):c==e+"_svg_ZoomInBtn"?v(this._localizedLabels.zoomIn):c==e+"_svg_ZoomOutBtn"&&v(this._localizedLabels.zoomOut)),ei=this.getAxisLabelData(n),ei&&(d=$.extend({},ej.EjSvgRender.commonChartEventArgs),d.data=ei,this._trigger("axisLabelMouseMove",d)),!this.isTouch(n))for(this.axisTooltip(n,h),t.title.enableTrim&&this.showTitleTooltip(n,h),i=0,dt=t.series.length;i<dt;i++)o=t.series[i],lt=o.marker&&o.marker.dataLabel,!o._enableSmartLabels||this.model.enable3D||lt.enableWrap||(li=lt.template,at=lt.font,t.AreaType=="none"&&ej.util.isNullOrUndefined(li)&&this.datalabelTooltip(n,i,at));if($(l).find(e+"_ResetZoom,"+e+"_PanBtn,"+e+"_ZoomBtn").length>0&&$(l).find(e+"_ResetZoom,"+e+"_PanBtn,"+e+"_ZoomBtn").appendTo(l),y=this.getLegendData(n),y){var ai=this.model.legend.isReversed,at=this.model.legend.font,vi=$.extend({},ej.EjSvgRender.commonChartEventArgs);if(vi.data=y,y.series.highlightSettings.enable&&(b?(o=$.extend({},y.series),o.seriesIndex=y.legendItem.LegendItem.SeriesIndex,o.pointIndex=y.legendItem.LegendItem.PointIndex,a=this.model.AreaType=="none"?o.pointIndex:o.seriesIndex,$("#"+s._id+"_Selection_Legend"+a+"_canvas").length==0&&($("[id*="+this._id+"_Highlight_]").remove(),this.canvasHighlight(s,n,o,y))):this.highlight(s,n,y.series,y)),this._trigger("legendItemMouseMove",vi),b){var rt=this.calMousePosition(n),yi=rt.X,pi=rt.Y,vt=t.LegendBounds;$(this.legendContainer).children().css({cursor:"pointer"});yi>=vt.X&&yi<=vt.X+t.LegendViewerBounds.Width&&pi<=vt.Y+t.LegendViewerBounds.Height&&pi>=vt.Y&&this._textTooltip(n,t.legendTextRegion,ai,at)}else this._textTooltip(n,t.legendTextRegion,ai,at)}else b&&$(this.legendContainer).children().css("cursor","default");if(b&&(h.indexOf("_ResetZoom")!=-1||c.indexOf("_ResetZoom")!=-1?v(this._localizedLabels.reset):h.indexOf("_PanBtn")!=-1||c.indexOf("_PanBtn")!=-1?v(this._localizedLabels.pan):h.indexOf("_ZoomBtn")!=-1||c.indexOf("_ZoomBtn")!=-1?v(this._localizedLabels.zoom):h.indexOf("_ZoomInBtn")!=-1||c.indexOf("_ZoomInBtn")!=-1?v(this._localizedLabels.zoomIn):(h.indexOf("_ZoomOutBtn")!=-1||c.indexOf("_ZoomOutBtn")!=-1)&&v(this._localizedLabels.zoomOut),this.isTouch(n)||(this._textTooltip(n,t.xAxisLabelRegions),this._textTooltip(n,t.yAxisLabelRegions))),yt=this,t.xAxisTitleRegion){var u=this.mousemoveX,f=this.mousemoveY,wi=this.model.primaryXAxis.title.isReversed,bi=this.model.primaryXAxis.font;$.each(t.xAxisTitleRegion,function(t,i){u>=i.Bounds.X&&u<=i.Bounds.X+i.Bounds.Width&&f>=i.Bounds.Y-i.Bounds.Height&&f<=i.Bounds.Y&&i.trimText!=i.labelText&&yt.showAxisTooltip(n.pageX,n.pageY,i.labelText,i.trimText,wi,bi)})}if(t.yAxisTitleRegion){var u=this.mousemoveX,f=this.mousemoveY,wi=this.model.primaryXAxis.title.isReversed,bi=this.model.primaryXAxis.font;$.each(t.yAxisTitleRegion,function(t,i){u>=i.Bounds.X&&u<=i.Bounds.X+i.Bounds.Width&&f>=i.Bounds.Y-i.Bounds.Height&&f<=i.Bounds.Y&&i.trimText!=i.labelText&&yt.showAxisTooltip(n.pageX,n.pageY,i.labelText,i.trimText,wi,bi)})}t.axisMultiLevelLabelRegions&&(u=this.mousemoveX,f=this.mousemoveY,$.each(t.axisMultiLevelLabelRegions,function(t,i){u>=i.Bounds.X&&u<=i.Bounds.X+i.Bounds.Width&&f>=i.Bounds.Y-i.Bounds.Height&&f<=i.Bounds.Y&&i.trimText!=i.labelText&&yt.showAxisTooltip(n.pageX,n.pageY,i.labelText)}));d=$.extend({},ej.EjSvgRender.commonChartEventArgs);d.data={location:{x:this.mousemoveX,y:this.mousemoveY},size:{height:t.svgHeight,width:t.svgWidth},id:n.target.id,pageX:n.pageX,pageY:n.pageY};this._trigger("chartMouseMove",d)},axisTooltip:function(n,t){var s=this.svgObject.id,o=this.model.hAxes,h=this.model.vAxes,i,c,u,l,a,f,r,e;if(t.indexOf("svghorizontal")>-1){var i=o[0],v=t.replace(this._id,"").replace("_svghorizontal",""),r=i.visibleLabels[parseInt(v)];r.Text=r.Text.toString();r.Text.indexOf("...")>-1&&(e=r.Text==r.originalText?"":r.originalText,this.showAxisTooltip(n.pageX,n.pageY,e))}if(t.indexOf("_YLabel_")>=0){for(u=0;u<h.length;u++)if(t.indexOf(s+"_"+h[u].name+"_YLabel_")>=0){i=h[u];break}if(i&&i.enableTrim)for(c=i.visibleLabels.length,f=0;f<c&&this.model.AreaType=="cartesianaxes";f++)if(t==s+"_"+h[u].name+"_YLabel_"+f){if(r=i.visibleLabels[f],e=r.Text==r.displayText?"":i.labelFormat?i.labelFormat.replace("{value}",r.Text):r.Text,e=="")break;i.labelPosition.toLowerCase()=="inside"&&(this._hideTooltip(),this._removeTrackBall());this.showAxisTooltip(n.pageX,n.pageY,e,r.displayText)}}if(t.indexOf("_XLabel_")>=0){for(u=0;u<o.length;u++)if(t.indexOf(s+"_"+o[u].name+"_XLabel_")>=0){i=o[u];break}if(i&&(i.enableTrim||i.labelIntersectAction.toLowerCase()=="trim"||i.labelIntersectAction.toLowerCase()=="wrapbyword"))for(c=i.visibleLabels.length,l=i.isInversed,a=i.font,f=0;f<c&&this.model.AreaType=="cartesianaxes";f++)if(t==s+"_"+o[u].name+"_XLabel_"+f){if(r=i.visibleLabels[f],e=r.Text==r.displayText?"":r.Text,e=="")break;i.labelPosition.toLowerCase()=="inside"&&(this._hideTooltip(),this._removeTrackBall());this.showAxisTooltip(n.pageX,n.pageY,e,r.displayText,l,a)}}},showTitleTooltip:function(n,t){var y=ej.EjSvgRender.utils._measureText(this.model.title.text,$(this.svgObject).width()-this.model.margin.left-this.model.margin.right,this.model.title.font),i=this.model,r=i._titleLocation,u=i._subTitleLocation,a=i.title.enableTrim,l=i.elementSpacing,e=this.mousemoveX,o=this.mousemoveY,p=i.title.textOverflow.toLowerCase(),v=i.title.subTitle.enableTrim,w=i.title.subTitle.textOverflow.toLowerCase(),h=i.title.text,c=i.title.subTitle.text,s=i.title.isReversed,f;a&&this.model.trimTooltip&&(f=ej.EjSvgRender.utils._trimText(h,i.title.maximumWidth,i.title.font),t.indexOf("ChartTitleText")>=0?this.showAxisTooltip(n.pageX,n.pageY,h,f,s,i.title.font):this.model.enableCanvasRendering&&e>=r.X-l&&e<=r.X-l+r.size.width&&o>=r.Y-r._height&&o<=r.Y+r.size.height&&this.showAxisTooltip(n.pageX,n.pageY,h,f,s,i.title.font));v&&i.subTitleTooltip&&(f=ej.EjSvgRender.utils._trimText(c,i.title.subTitle.maximumWidth,i.title.subTitle.font),t.indexOf("ChartSubTitleText")>=0?this.showAxisTooltip(n.pageX,n.pageY,c,f,s,i.title.subTitle.font):i.enableCanvasRendering&&e>=u.X&&e<=u.X+u.size.width&&o>=u.Y&&o<=u.Y+u.size.height&&this.showAxisTooltip(n.pageX,n.pageY,c,f,s,i.title.subTitle.font))},_updateScroll:function(){for(var i=this.model.scrollObj,f=i?i.length:0,r=this.model._axes,u=this.scrollbarContainer,n,t=0;t<f;t++)i[t]&&(n=i[t],(n.zoomPosition!=r[t].zoomPosition||n.zoomFactor!=r[t].zoomFactor)&&(n.zoomPosition=r[t].zoomPosition,n.zoomFactor=r[t].zoomFactor,u._initializeScrollbarVariables(n),u._scrollbarUpdate.call(this,n),u._setScrollPosition.call(this,n.startX,n.startX+n.rectWidth,n)))},_hideTooltip:function(){$("#"+this.svgObject.id).find("#"+this.svgObject.id+"_TrackToolTip").attr("visibility","hidden");$("#"+this.svgObject.id+"_TrackToolTip").attr("visibility","hidden").hide();$(".tooltipDiv"+this._id).css("display","none")},_removeHighlight:function(){var n,t;if($("[id*=HighlightSegment]").remove(),$("[id*=HighlightPath]").remove(),$("[id*=HighlightLegendSegment]").remove(),$("[id*=HighlightLegendPath]").remove(),$("[id*=HighlightDef]").remove(),$("[id*=Highlightseries]").remove(),$("[id*="+this._id+"_Highlight_]").remove(),!this.model.enableCanvasRendering&&!this.vmlRendering)if(n=this.svgObject.querySelector("[class^='Highlight']"),n!==null&&n.length==null)n.removeAttribute("class");else for(t=n&&n.length;t--;)n.removeAttribute("class")},_removeSelection:function(){$("[id*="+this._id+"_SelectionCluster_Legend]").remove();$("[id*="+this._id+"_Selection_series]").remove();$("[id*="+this._id+"_Selection_Cluster]").remove();$("[id*="+this._id+"SelectionSegment]").remove();$("[id*="+this._id+"SelectionPath]").remove();$("[id*="+this._id+"SelectionLegend]").remove();$("[id*="+this._id+"SelectionDef]").remove();$("[id*="+this._id+"Selectionseries]").remove();$("[id*="+this._id+"_Selection_]").remove()},datalabelTooltip:function(n,t,i){var p=this.calMousePosition(n);this.mousemoveX=p.X;this.mousemoveY=p.Y;var l=this._id,h=this.mousemoveX,w=this.mousemoveY,b=this.vmlRendering,u=this.model.elementSpacing,e=this,c,a,v,y,r,f,o,s;ej.util.isNullOrUndefined(this.accDataLabelRegion[t])||$.each(this.accDataLabelRegion[t],function(t,p){c=p.bounds.minX;a=p.bounds.minY;v=p.bounds.maxX;y=p.bounds.maxY;b&&(c=p.bounds.minX+p.bounds.width/2,v=p.bounds.maxX+p.bounds.width/2,a=p.bounds.minY,y=p.bounds.maxY);h>=c&&h<=v&&w>=a&&w<=y&&($("#"+l+"_tooltip").remove(),r=$("<div><\/div>").attr({id:l+"_tooltip","class":"ejTooltip"+l}),p.trimmedText!=p.text&&($("#"+e.svgObject.id+"_TrackToolTip").hide(),$(r).html(p.text),$(document.body).append(r),f=ej.EjSvgRender.utils._measureText(p.text,p.text.length,p.font).width,$(r).css({top:n.pageY+u,display:"block",position:"absolute","z-index":"13000",cursor:"default",color:"#000000","font-size":i.size,"background-color":"#FFFFFF",border:"1px solid #707070","white-space":"nowrap",padding:"5px"}),(p.type=="pyramid"||p.type=="funnel")&&(o=e.model.m_AreaBounds.Width+e.model.m_AreaBounds.X-n.pageX,o>f?$(r).css({left:n.pageX+u}):(s=n.pageX-f+2*u,$(r).css({left:s}))),(p.type=="pie"||p.type=="doughnut"||p.type=="pieofpie")&&(c>p.bounds.centerX?(o=e.svgWidth-e.model.margin.left-e.model.margin.right-h,o<f?(s=n.pageX-f,$(r).css({left:s+u})):$(r).css({left:n.pageX+u})):(o=h,o<f?$(r).css({left:n.pageX+u}):(s=n.pageX-f,$(r).css({left:s-2*u}))))))})},showAxisTooltip:function(n,t,i,r,u,f){var o=this._id,e=$("<div><\/div>").attr({id:o+"_tooltip","class":"ejTooltip"+o});if($(e).html(i),u&&!ej.util.isNullOrUndefined(f))var s=ej.EjSvgRender.utils._measureText(i,null,f).width,h=ej.EjSvgRender.utils._measureText(r,null,f).width,c=h<=s?s:h;$(document.body).append(e);$(e).css({left:u?n-c:n+10,top:t+10,display:"block",position:"absolute","padding-left":"3px","padding-right":"3px","z-index":"13000",cursor:"default","font-family":"Segoe UI",color:"#707070","font-size":"12px","background-color":"#FFFFFF",border:"1px solid #707070"})},_textTooltip:function(n,t,i,r){var w=this,s=this.calMousePosition(n),e=this.model.legend._ejScroller,u=0,h=0,a=i&&($("#legend_"+this._id).find('[class*="e-vscrollbar"]').length||$("#legend_"+this._id)[0].style.overflowY=="scroll")?s.X-18:s.X,v=s.Y,c=a,f=v,l=this._id,b=w.model,y=b.legend,k=y.enableScrollbar,d=y.textOverflow.toLowerCase(),p,o;h=e?$("#legend_"+this._id).ejScroller("instance").model.scrollTop:$("#legend_"+this._id).scrollTop();u=e?$("#legend_"+this._id).ejScroller("instance").model.scrollLeft:$("#legend_"+this._id).scrollLeft();i&&e&&(u=u==0?$("#legend_"+this._id).ejScroller("instance")._rtlScrollLeftValue:$("#legend_"+this._id).ejScroller("instance").model.scrollLeft==$("#legend_"+this._id).ejScroller("instance")._rtlScrollLeftValue?0:$("#legend_"+this._id).ejScroller("instance")._rtlScrollLeftValue-$("#legend_"+this._id).ejScroller("instance").model.scrollLeft);(k||e)&&(c=a+(u?u:0),f=v+(h?h:0));$.each(t,function(t,u){if(c>=u.bounds.x&&c<=u.bounds.x+u.bounds.width&&(f>=u.bounds.y&&f<=u.bounds.y+u.bounds.height||f>=u.bounds.y-u.bounds.height/3&&f<=u.bounds.y)&&($("#"+l+"_tooltip").remove(),o=$("<div><\/div>").attr({id:l+"_tooltip","class":"ejTooltip"+l}),p=jQuery.type(u.trimText)=="array"?u.trimText.join(" "):u.trimText,p!=u.labelText)){if($(o).html(u.labelText),i&&!ej.util.isNullOrUndefined(r))var e=ej.EjSvgRender.utils._measureText(u.labelText,null,r).width;$(document.body).append(o);$(o).css({left:i?n.pageX-e-15:n.pageX+10,top:n.pageY+10,display:"block",position:"absolute","padding-left":"3px","padding-right":"3px","z-index":"13000",cursor:"default","font-family":"Segoe UI",color:"#707070","font-size":"12px","background-color":"#FFFFFF",border:"1px solid #707070"})}})},pieExplosion:function(n){var v,l,y,f,r,e,a,o;this.model.explode=!0;var t=n,u,s,h,i=t.region.Series,p=t.region.SeriesIndex,c=new ej.seriesTypes[i.type.toLowerCase()],w=i.explodeIndex,d=i.labelPosition.toLowerCase(),k={SeriesIndex:t.pointData[0].SeriesIndex,PointIndex:t.pointData[0].Index},b=this.model._isPieOfPie?t.pointData[0].PointIndex:t.region.Series._visiblePoints[t.pointData[0].Index].actualIndex;if(w!=b&&!t.region.Series.explodeAll){if(i.explodeIndex=b,h=t.pointData[0].PieSeriesIndex,!ej.util.isNullOrUndefined(this.model.explodeValue)&&this.model.explodeValue!=k){for(this.model.explodeValue.SeriesIndex!=t.region.SeriesIndex&&(i=this.model._visibleSeries[this.model.explodeValue.SeriesIndex]),v=this.model._isPieOfPie?this._getPieOfPiePoint(this.model.explodeValue.PointIndex,i):i._visiblePoints[this.model.explodeValue.Index],l=c._calculateArcData(this,this.model.explodeValue.PointIndex,v,i,this.model.explodeValue.SeriesIndex,this.model.explodeValue.PieSeriesIndex),u=this.svgObject.id+"_SeriesGroup_"+this.model.explodeValue.SeriesIndex,s=this.model.explodeValue.PieSeriesIndex==1?$(this.gSeriesEle).children("#"+u)[1]:$(this.gSeriesEle).children("#"+u)[0],f=$(s).children(),r=0;r<f.length;r++)if(e=f[r],a=this.svgRenderer._getAttrVal($(e)[0],"data-pointIndex"),parseInt(a)==this.model.explodeValue.PointIndex){this.svgRenderer._setAttr($(e),{d:l.Direction});break}c.drawDataLabelAcc(this,i,this.model.explodeValue.Index,v,this.model.explodeValue.SeriesIndex,this.model.explodeValue.PieSeriesIndex)}for(y=this.model._isPieOfPie?this._getPieOfPiePoint(n.region.Region.PointIndex,i):i._visiblePoints[t.pointData[0].Index],l=c._calculateArcData(this,t.pointData[0].PointIndex,y,t.region.Series,p,h),u=this.svgObject.id+"_SeriesGroup_"+t.region.SeriesIndex,s=h==1?$(this.gSeriesEle).children("#"+u)[1]:$(this.gSeriesEle).children("#"+u)[0],f=$(s).children(),r=0;r<f.length;r++)if(e=f[r],a=this.svgRenderer._getAttrVal($(e)[0],"data-pointIndex"),parseInt(a)==t.pointData[0].PointIndex){this.svgRenderer._setAttr($(e),{d:l.Direction});break}this.model.enableCanvasRendering&&(o=document.getElementById(this.svgObject.id).getClientRects()[0],this.svgRenderer.ctx.clearRect(o.left,o.top,o.width,o.height),$("#"+this._id).ejChart("redraw"));c.drawDataLabelAcc(this,i,t.pointData[0].Index,y,p,h);this.model.explodeValue={SeriesIndex:t.pointData[0].SeriesIndex,PointIndex:t.pointData[0].PointIndex,Index:t.pointData[0].Index,PieSeriesIndex:t.pointData[0].PieSeriesIndex}}t.region.Series.explodeIndex=w},displayGroupingTemplate:function(n,t,i,r,u,f,e,o,s){var a=[],rt=[],ut=[],l=[],g,w,y,b,nt,k,c,d,et,v,h,ft,it,p,tt;for(rt=$.extend(!0,{},s),l=$.extend(!0,{},u),g=Object.keys(l).length,a=$.extend(!0,{},r),w=5,h=0;h<g;h++)y=l[h].series.isTransposed,a[h].point.x=a[h].point.x,l[h].series.xAxis._valueType.toLowerCase()=="datetime"&&(a[h].point.x=ej.format(new Date(a[h].point.x),ej.EjSvgRender.utils._dateTimeLabelFormat(l[h].series.xAxis.intervalType,l[h].series.xAxis))),l[h].series.xAxis._valueType.toLowerCase()=="category"&&(a[h].point.x=ej.EjSvgRender.utils._getLabelContent(e,l[h].series.xAxis)),n=ej.util.isNullOrUndefined(n)?0:n,t=ej.util.isNullOrUndefined(t)?0:t,b=this.model.m_AreaBounds.X,nt=this.model.m_AreaBounds.Y,k=y||this.model.requireInvertedAxes?l[h].series.yAxis.y:i.X+n+b+this.model.crosshair.marker.size.width+w,c=y||this.model.requireInvertedAxes?l[h].series.xAxis.x+i.Y:this.model.m_AreaBounds.Height/2+nt,d=$("#"+this.model.crosshair.trackballTooltipSettings.tooltipTemplate).clone(),$(d).css("background-color",rt[h].seriesColor),$(d).css("display","block"),a[h].point.count=1,u.count=et,ft={series:u,point:a[h].point},ut.push($(d).html($(d).html().parseTemplate(ft)));$("#"+this.svgObject.id+"_TrackGroupToolTipTemplate").length==0&&(v=$("<div id ="+this.svgObject.id+"TrackGroupToolTipTemplate style='pointer-events:none; position: absolute; z-index: 13000; display: block;'><\/div>"),$(v).appendTo(this.chartContainer));$(v).append(ut);it=this.model.crosshair.trackballTooltipSettings.border;$(v).css("border",it.width+"px solid "+it.color);p=parseFloat($(v).css("height"));tt=parseFloat($(v).css("width"));c=y||this.model.requireInvertedAxes?c:c-p/2;g!=1||y||(c=i.Y+nt+p/2);g==1&&(y||this.model.requireInvertedAxes)&&(k=i.X+n+b+this.model.crosshair.marker.size.width+w-tt/2,c=i.Y+nt-p-this.model.crosshair.marker.size.height-w);c+p<this.model.m_AreaBounds.Y?c=this.model.m_AreaBounds.Y:c+p/2>this.model.m_AreaBounds.Height&&(c-=p);k+tt>b+this.model.m_AreaBounds.Width&&!y&&(k=i.X+n+b-this.model.crosshair.marker.size.width-w-tt);$(v).css("left",k);$(v).css("top",c)},displayTemplateTooltip:function(n,t,i,r,u,f,e,o){var c=$.extend(!0,{},r),b=5,h,nt,v,a,s,tt,y,it,p,w;c.x=c.x;u.xAxis._valueType.toLowerCase()=="datetime"&&(c.x=ej.format(new Date(c.x),ej.EjSvgRender.utils._dateTimeLabelFormat(u.xAxis.intervalType,u.xAxis)));u.xAxis._valueType.toLowerCase()=="category"&&(c.x=ej.EjSvgRender.utils._getLabelContent(e,u.xAxis));n=ej.util.isNullOrUndefined(n)?0:n;t=ej.util.isNullOrUndefined(t)?0:t;var g=this.model.m_AreaBounds.X,l=this.model._axes,rt=u._xAxisName,ut=u._yAxisName,k,d;for(h=0,nt=l.length;h<nt;h++)rt==l[h].name?u._isTransposed?k=l[h].Location.Y2:d=l[h].Location.X1:ut==l[h].name&&(u._isTransposed?d=l[h].Location.X1:k=l[h].Location.Y2);v=i.X+this.model.crosshair.marker.size.width+d;a=i.Y+t+k;$("#"+this.svgObject.id+"_TrackToolTipTemplate_"+f).length==0&&(s=$("<div id="+this.svgObject.id+"_TrackToolTipTemplate_"+f+" style='pointer-events:none;position: absolute; z-index: 13000; display: block;'><\/div>"),$(document.body).append(s));this.model.crosshair.trackballTooltipSettings.tooltipTemplate!=null&&(tt=document.getElementById(this.model.crosshair.trackballTooltipSettings.tooltipTemplate).cloneNode(!0),$(tt).css("display","block").appendTo(s),u.count=1,c.count=1,y=this.getSeriesColor(c,f,u),$(s).css("background-color",jQuery.type(y)=="array"?y[0].color:y),it={series:u,point:c},$(s).html($(s).html().parseTemplate(it)));a-=parseFloat($(s).css("height"))/2;p=parseFloat($(s).css("height"));w=parseFloat($(s).css("width"));(u.isTransposed||this.model.requireInvertedAxes)&&(a=i.Y+this.model.m_AreaBounds.Y-p-b-this.model.crosshair.marker.size.height,v=i.X+g-w/2);a+p<this.model.m_AreaBounds.Y&&(u.isTransposed||this.model.requireInvertedAxes)&&(a+=p+this.model.crosshair.marker.size.height+b+o.top);v+w>g+this.model.m_AreaBounds.Width&&(v-=w+b*2+this.model.crosshair.marker.size.width);$(s).css("left",v);$(s).css("top",a)},displayAxisTooltip:function(n,t,i,r,u,f){var it,p,ut,o,v,y;i._valueType.toLowerCase()=="double"&&(it=i.labelFormat?i.labelFormat.match("{value}"):null,t=i.labelFormat?it!=null?i.labelFormat=="${value}"?i.labelFormat.replace("{value}","$"+Number(t)):i.labelFormat.replace("{value}",Number(t)):ej.format(Number(t),i.labelFormat,this.model.locale):t);var l=0,rt=i.orientation.toLowerCase(),a,g=0,nt=0,h=i._opposed,d=this.model.enableCanvasRendering,ft=h?l+10+(i.x+i.width):i.x+i.width;for(p=0;p<this.model._axes.length;p++)this.model._axes[p].majorTickLines.size>l&&(l=this.model._axes[p].majorTickLines.size);if(n.X>=0&&n.X<=ft){var s=n.X,c=n.Y,e=5,w=$.extend({},ej.EjSvgRender.commonChartEventArgs);w.data={axisIndex:r,chartAxis:i,currentTrackText:t,location:u};this._trigger("trackAxisToolTip",w);ut=w.data.currentTrackText;o=ej.EjSvgRender.utils._measureText(ut,null,i.crosshairLabel.font);rt=="horizontal"&&(s=s-o.width/2,i.labelPosition=="inside"||(h?u.y<i.y:u.y>i.y)?(h==!1&&(c=i.y-o.height+l-(i._isScroll?this.model.scrollerSize:0),a="top"),h==!0&&(c=i.y+o.height-l,a="bottom")):(h==!0&&(c=i.y-o.height/2-e-l,a="bottom"),h==!1&&(c=i.y+o.height-e+l,a="top")),g=e,c=c+(i._isScroll?i.opposedPosition?-this.model.scrollerSize:this.model.scrollerSize:0));!h&&s+o.width>this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X&&(s=this.model.m_AreaBounds.Width+this.model.m_AreaBounds.X-o.width+e+this.model.elementSpacing);rt=="vertical"&&(c=n.Y+o.height/4,i.labelPosition=="inside"||!h&&u.x<i.x?(h==!0&&(s=i.x-o.width+e-l,a="left"),h==!1&&(s=i.x+2*e+(i._isScroll?this.model.scrollerSize:0),a="right")):(h==!0&&(s=o.width+i.x>$(this.svgObject).width()-e?$(this.svgObject).width()-o.width-e:i.x+3*e,a="left"),h==!1&&(s=o.width>i.x?2*e:i.x-o.width-l,a="right")),s=s+(i._isScroll?i.opposedPosition?this.model.scrollerSize:-this.model.scrollerSize:0),nt=e);var et={id:this.svgObject.id+"_AxisToolTipText_"+r,x:s-nt,y:c+g,fill:i.crosshairLabel.font.color,"font-size":i.crosshairLabel.font.size,"font-family":i.crosshairLabel.font.fontFamily,"font-style":i.crosshairLabel.font.fontStyle,"font-weight":i.crosshairLabel.font.fontWeight,"text-anchor":"start",opacity:i.crosshairLabel.font.opacity},ct=d?e/4:0,tt=ej.EjSvgRender.utils._measureText(w.data.currentTrackText,this.model.m_AreaBounds.Width,i.crosshairLabel.font),b=i.crosshairLabel,s=s-e,c=c-tt.height,ot=tt.width+2*e,st=2*tt.height-2*e,k={x:s-nt,y:c+g,width:ot,height:st,rx:b.rx*(d?2:1),ry:b.ry*(d?2:1)},ht=ej.EjSvgRender.utils._calculateroundedCorner(null,k,!0,a,0,f);k={id:this.svgObject.id+"_AxisToolTipRect_"+r,d:ht,fill:b.fill,"stroke-width":b.border.width,stroke:b.border.color};v=this.model._axes[r];u.y<v.y+v.height&&u.y>v.y||u.x<v.x+v.width&&u.x>v.x?(this.svgRenderer._setAttr($("#"+this.svgObject.id+"_AxisToolTipRect_"+r),{display:"block"}),this.svgRenderer._setAttr($("#"+this.svgObject.id+"_AxisToolTipText_"+r),{display:"block"}),k.display="block"):(this.svgRenderer._setAttr($("#"+this.svgObject.id+"_AxisToolTipRect_"+r),{display:"none"}),this.svgRenderer._setAttr($("#"+this.svgObject.id+"_AxisToolTipText_"+r),{display:"none"}),k.display="none");d?(y=this.svgRenderer.createCrosshairCanvas(),y.ctx=y.getContext("2d")):y=this.svgRenderer;this.svgRenderer.drawPath.call(y,k,this.gTrackAxisEle);this.svgRenderer.drawText.call(y,et,w.data.currentTrackText,this.gTrackAxisEle)}},maxWdithArrayCollection:function(n,t){for(var i=0,u,r=0,e=0,o=ej.EjSvgRender.utils._measureText,f=0,s=n.length;f<s;f++)u=o(n[f],0,t),r=u.width,e+=u.height,i=i==0?r:i<r?r:i;return{maxTextWidth:i,totalHeight:e}},displayTooltip:function(n,t,i){var ri=this.model.crosshair,b=ri.trackballTooltipSettings,kt=b.rx,dt=b.ry,yt=b.border,s=this.model.m_AreaBounds,vi=this.model.crosshair.isReversed,e,bi,ki,nt,di,k,ut,nr,lr,it,et,tr,ei,vt,oi,ur,fr,bt,si;if(n){var u=t.series,hi,gt,er=document.getElementById(this._id),kr=$(er).offset(),at=u.tooltip,ct=at.font?$.extend(!1,u.font,{},at.font):u.font,ni=u.type=="boxandwhisker"?t.point.boxPlotLocation[3]:t.point.location,ui=u.marker.size.width/2+u.marker.border.width+yt.width+5,yi=u._isTransposed?u.xAxis.y+ui:u.yAxis.y,or=u._isTransposed?u.yAxis.x:u.xAxis.x+ui,r={X:or+ni.X,Y:yi+ni.Y},lt=t.textCollection,pi=t.textOptionsCollection,wi=t.groupingTextId,h,ti,rt={X:r.X,Y:r.Y},pt=document.getElementById(this._id+"_trackball_grouping_tooltip");if(this._trigger("trackToolTip",{data:{currentText:lt,location:rt}}),!ej.util.isNullOrUndefined(this.model.trackToolTip)&&this.model.trackToolTip!="")for(e=0,ut=lt.length;e<ut-1;e++)lt[e].text==""&&(lt.splice(e,1),pi.splice(e,1),wi.splice(e,1));for(ej.util.isNullOrUndefined(pt)?(pt=document.createElement("div"),h={left:rt.X,top:rt.Y,border:parseInt(yt.width?yt.width:1)+"px solid "+(yt.color?yt.color:"#000000"),background:b.fill?b.fill:"#ffffff",opacity:b.opacity,position:"absolute",height:"auto",width:"auto","border-radius":kt+"px "+dt+"px","pointer-events":"none"},pt.setAttribute("id",this._id+"_trackball_grouping_tooltip")):h={left:rt.X,top:rt.Y},e=0,ut=lt.length;e<ut;e++)ti=document.createElement("span"),ti.setAttribute("id",wi[e]),bi=lt[e].text,$(ti).html(bi+"<\/br>"),$(ti).css(pi[e]),pt.appendChild(ti);ki=lt.map(function(n){return n.text});hi=this.maxWdithArrayCollection(ki,ct);i=hi.maxTextWidth;gt=hi.totalHeight;h.top=u._isTransposed?h.top:h.top-gt*.5;h.left=u._isTransposed?h.left-i*.5:h.left;lt.length>1&&(h.top=u._isTransposed?h.top:yi+(s.Height*.5-.5*gt),h.left=u._isTransposed?s.Width/2+s.X-i*.5:h.left);u._isTransposed?gt+h.top>s.Y+s.Height&&(h.top-=gt+ui*2):h.left+i>=s.X+s.Width&&(h.left-=i+(ui+yt.width)*2);h.left=rt.X==r.X?h.left:rt.X;h.top=rt.Y==r.Y?h.top:rt.Y;$(pt).css(h);$(pt).appendTo(this.chartContainer)}else for(nt=0,di=t.length;nt<di;nt++){var r=t[nt].Point,ni=t[nt].ClosestPoint,u=t[nt].Series,fi=t[nt].ClosestPointIndex,ii=t[nt].Tgap,ft=$.inArray(u,this.model._visibleSeries),w={X1:s.X,Y1:s.Y+s.Height,X2:s.X+s.Width,Y2:s.Y},d=this.model._axes,sr=u._xAxisName,hr=u._yAxisName;for(k=0,ut=d.length;k<ut;k++)sr==d[k].name?u._isTransposed?(w.Y1=d[k].Location.Y1,w.Y2=d[k].Location.Y2):(w.X1=d[k].Location.X1,w.X2=d[k].Location.X2):hr==d[k].name&&(u._isTransposed?(w.X1=d[k].Location.X1,w.X2=d[k].Location.X2):(w.Y1=d[k].Location.Y1,w.Y2=d[k].Location.Y2));if(r.X=u.type=="boxandwhisker"?r.X+w.X1:r.X,r.Y=u.type=="boxandwhisker"?r.Y+w.Y2:r.Y,r.X>=w.X1&&r.X<=w.X2&&r.Y>=w.Y2&&r.Y<=w.Y1||n){var tt=this.model.requireInvertedAxes,e,a,v=r.X+(u.isIndicator?0:ej.util.isNullOrUndefined(u._trackMarker)?u.marker.size.width:u._trackMarker.size.width)+f+1,y=r.Y,gi=u.tooltip.format,cr=ej.util.isNullOrUndefined(u.yAxis.roundingPlaces)?2:u.yAxis.roundingPlaces;if(nr=t[nt].Series.type=="boxandwhisker"&&r.outlier?this.getTooltipFormat(ni,u,ft,fi,gi,r):this.getTooltipFormat(ni,u,ft,fi,gi,cr),lr=u.name?u.name.replace(" ",""):"series"+ft,it=$.extend({},ej.EjSvgRender.commonChartEventArgs),it.data={Location:{X:v,Y:y},Series:u,serIndex:ft,pointIndex:fi,currentText:nr.text},this._trigger("trackToolTip",it),!it.cancel){v=it.data.Location.X;y=it.data.Location.Y;var f=this.model.tooltipPadding,c=ii,at=u.tooltip,ct=at.font?$.extend(!1,u.font,{},at.font):u.font,ir=ej.EjSvgRender.utils._measureText(it.data.currentText,u.xAxis.width,ct),ci=this.getSeriesColor(ni,ft,u),li=this.getTooltipOptions(ci,u),dr=li.rectBColor,gr=li.rectFColor,nu=li.rectTextColor,l=ir.width+2*f,o=ir.height+2*f,tu=tt?l/10:o*30/100,rr=tt?u.yAxis.width:u.xAxis.width,ar=tt?ii+r.X-l/2:ii+r.Y-o/2,vr=tt?ii+r.X+l/2:ii+r.Y+o/2,yr=tt?s.X:s.Y,pr=tt?s.X+s.Width:s.Y+s.Height,g=[],wr=3+ri.marker.border.width+(tt?ri.marker.size.height:ri.marker.size.width)/2,p=this.model.financial?0:wr+5,ai=u.type.toLowerCase(),ot,wt=ai.indexOf("rangearea")==0?this.model.crosshair.marker.size.height/2:0;if(ar>=yr&&vr<=pr||this.model.financial){tt?r.Y-p-i<s.Y?(et={x:r.X-l/2+c,y:r.Y+p,width:l,height:o,rx:kt,ry:dt},g.push({X:r.X-l/2+f+c,Y:r.Y+p+o/2-f}),ot="top"):(this.model.financial?(v=r.X-l/2+c,y=r.Y+f+wt,e=v+f,a=y+2*f,ot="top"):(v=r.X-l/2+c,y=r.Y-p-o,e=r.X-l/2+f+c,a=r.Y-p-o/2-f,ot="bottom"),et={x:v,y:y,width:l,height:o,rx:kt,ry:dt},g.push({X:e,Y:a})):r.X+p+i-s.X>=rr||vi?(this.model.financial?(v=r.X-l/2,y=r.Y-o-f-wt,e=v+f,a=y+c+o,ot="bottom"):r.X-i<=this.model.m_AreaBounds.X&&vi?(v=r.X+p,y=r.Y-o/2+c,e=v+f,a=r.Y+c+o/2,ot="left"):(v=r.X-p-l,y=r.Y-o/2+c,e=v+f,a=r.Y+c+o/2,ot="right"),et={x:v,y:y,width:l,height:o,rx:kt,ry:dt},g.push({X:e,Y:a})):(this.model.financial?(v=r.X-l/2,y=r.Y-wt-o-2*f,e=v+f,a=y+c+o,ot="bottom"):(v=r.X+p,y=r.Y-o/2+c,e=v+f,a=r.Y+c+o/2,ot="left"),et={x:v,y:y,width:l,height:o,rx:kt,ry:dt},g.push({X:e,Y:a}));ei=ci;typeof ei=="object"&&(ei=ci[1].color);var st=it.data.currentText,br=st,ht=ej.EjSvgRender.utils._measureText(st,u.xAxis.width,ct).height,ut;it.data.currentText.indexOf("<br/>")>=0&&(st=it.data.currentText.split("<br/>"),br=st[0],tt?r.Y-p-i<s.Y?g.push({X:r.X-l/2+f+c,Y:r.Y+p+ht/st.length}):(this.model.financial?(e=r.X-l/2+f+c,a=r.Y+4*f+wt):(e=r.X-l/2+f+c,a=r.Y-p-o+ht/st.length),g.push({X:e,Y:a})):(vt=ai.indexOf("candle")>=0||ai.indexOf("hiloopenclose")>=0||!1,r.X+p+i-s.X>=rr?(this.model.financial?(e=r.X-l/2+f,a=r.Y+c-o-wt+(vt?0:2*f),et.y-=vt?f*3:f,et.height+=vt?f*2:f):(e=r.X-l-p+f,a=r.Y+c-o/2+ht/st.length),g.push({X:e,Y:a})):(this.model.financial?(e=r.X-l/2+f,a=r.Y+c-o-wt+(vt?0:f),et.y-=vt?f*2:f,et.height+=vt?f*2:f):(e=r.X+p+f,a=r.Y+c-o/2+ht/st.length),g.push({X:e,Y:a}))),ht=0);ut=g.length-1;ht=tt?ht:-ht;oi=u.type=="boxandwhisker"?nt:fi;ur={id:this.svgObject.id+"_ToolTipText_"+ft+"_"+oi,x:g[ut].X,y:g[ut].Y+ht/2,fill:at.font?at.font.color?at.font.color:"#ffffff":"#ffffff","font-size":ct.size,"font-family":ct.fontFamily,"font-style":ct.fontStyle,"font-weight":ct.fontWeight,"text-anchor":"start",isTrackball:!0,padding:this.model.tooltipPadding};tr=ej.EjSvgRender.utils._calculateroundedCorner(null,et,!0,ot,c);fr={id:this.svgObject.id+"_gTooltip_"+ft+"_"+oi,d:tr,fill:b.fill?b.fill:ei,"stroke-width":parseInt(b.border.width?b.border.width:0)+"px",stroke:b.border.color?b.border.color:"transparent","fill-opacity":b.opacity};this.model.enableCanvasRendering?(bt=this.svgRenderer.createCrosshairCanvas(),bt.ctx=bt.getContext("2d")):bt=this.svgRenderer;si=this.svgRenderer.createGroup({id:this.svgObject.id+"_gTooltip_"+ft+"_"+oi});this.svgRenderer.drawPath.call(bt,fr,si);this.svgRenderer.drawText.call(bt,ur,st,si,ct)}}$("#"+this.svgObject.id+"_TrackToolTip_"+ft).length==0&&this.svgRenderer.append($(si),this.gTrackball)}}},SmartTooltipPosition:function(n){for(var i=[[],[]],r=n.length,u=[],o=n[0].Series._isTransposed?this.model.m_AreaBounds.Width:this.model.m_AreaBounds.Height,f=this.model.tooltipPadding,e=-f,t=0;t<r;t++)i[0][t]=$.extend({},n[t].StEnd),i[1][t]={yAxis:n[t].Series._yAxisName,xAxis:n[t].Series._xAxisName,isTransposed:n[t].Series._isTransposed},u[t]=n[t].ReqInvertAxis?n[t].Point.X:n[t].Point.Y,e+=n[t].StEnd.End-n[t].StEnd.Start+f;for(this.ContinousOverlappingPoints(i[0],u),e<o&&this.verticalArrangeMents(i),t=0;t<r;t++)n[t].Tgap=this.model.financial?0:i[0][t].Start-n[t].StEnd.Start},verticalArrangeMents:function(n){for(var f=n[0],c=n[1],k=this.model.m_AreaBounds,w=this.model.tooltipPadding,l,s,h,a,o=this.model._axes,r,u,v,y,p=f.length,e=p-1,t=0,i=0,b=o.length;e>=0;e--){for(l=c[e].isTransposed,a=c[e].yAxis,i=0;i<b;i++)a==o[i].name&&(l?(s=o[i].Location.X2,h=o[i].Location.X1):(s=o[i].Location.Y1,h=o[i].Location.Y2));if(r=f[e],y=r.End-r.Start,s<r.End)for(r.End=s-2,r.Start=r.End-y,t=e-1;t>=0;t--)u=f[t],v=u.End-u.Start,u.End>f[t+1].Start&&f[t+1].Start>h&&f[t+1].End<s&&(u.End=f[t+1].Start-w,u.Start=u.End-v)}for(e=0;e<p;e++){for(l=c[e].isTransposed,a=c[e].yAxis,i=0;i<b;i++)a==o[i].name&&(l?(s=o[i].Location.X2,h=o[i].Location.X1):(s=o[i].Location.Y1,h=o[i].Location.Y2));if(r=f[e],y=r.End-r.Start,r.Start<h)for(r.Start=h+1,r.End=r.Start+y,t=e+1;t<=p-1;t++)u=f[t],v=u.End-u.Start,u.Start<f[t-1].End&&f[t-1].Start>h&&f[t-1].End<s&&(u.Start=f[t-1].End+w,u.End=u.Start+v)}},ContinousOverlappingPoints:function(n,t){var e=this.model.tooltipPadding,h=0,o=0,a=0,r=0,p=n.length-1,l=n[0].End-n[0].Start+e,v,y,s,c,f,i,u;for(h=n[0].Start+l,a=n[0].Start,f=0;f<p;f++)if(h>=n[f+1].Start){if(l=n[f+1].End-n[f+1].Start+e,h+=l,o++,o-1==p-1||f==p-1){for(v=(h-a)/2,y=(t[r]+t[f+1])/2,s=n[r].End-n[r].Start,n[r].Start=y-v,n[r].End=n[r].Start+s,i=r;i>0;i--)if(n[i].Start<=n[i-1].End+e)c=n[i-1].End-n[i-1].Start,n[i-1].Start=n[i].Start-c-e,n[i-1].End=n[i-1].Start+c;else break;for(u=r+1;u<=r+o;u++)s=n[u].End-n[u].Start,n[u].Start=n[u-1].End+e,n[u].End=n[u].Start+s}}else{if(o=f>0?o:0,o>0){for(v=(h-a)/2,y=(t[r]+t[f])/2,s=n[r].End-n[r].Start,n[r].Start=y-v,n[r].End=n[r].Start+s,i=r;i>0;i--)if(n[i].Start<=n[i-1].End+e)c=n[i-1].End-n[i-1].Start,n[i-1].Start=n[i].Start-c-e,n[i-1].End=n[i-1].Start+c;else break;for(u=r+1;u<=r+o;u++)s=n[u].End-n[u].Start,n[u].Start=n[u-1].End+e,n[u].End=n[u].Start+s;o=0}l=n[f+1].End-n[f+1].Start+e;h=n[f+1].Start+l;a=n[f+1].Start;r=f+1}},getTooltipOptions:function(n,t){var r,u,e,o,f,i;return this.model.theme.indexOf("gradient")>=0?(r=jQuery.type(n)=="array"?n[0].color:n,u="white",f="#333333",e=5,o=5):(i=t.type.toLowerCase(),i.indexOf("column")==-1&&i.indexOf("waterfall")==-1&&i.indexOf("bar")==-1&&i.indexOf("box")==-1&&i!="rangearea"&&this.model.AreaType!="none"?(u=jQuery.type(n)=="array"?n[0].color:n,r="transparent",f="white"):(r="#333333",u="white",f="#333333"),e=0,o=0),{rectBColor:r,rectFColor:u,rectTextColor:f,rectX:e,rectY:o}},getSeriesColor:function(n,t,i){return!i||i.isIndicator||i.isTrendLine?i.fill:n._hiloFill?n._hiloFill._gradientStop?n._hiloFill._gradientStop[0].color:n._hiloFill:n.fill?n.fill._gradientStop?n.fill._gradientStop[0].color:n.fill:i.type.toLowerCase()=="waterfall"&&i.positiveFill&&(n.y>0&&!n.showIntermediateSum&&!n.showTotalSum||n.waterfallSum>0)?i.positiveFill:this.model.seriesColors[t]},getFormat:function(n,t){if(!n.tooltip.format){var i=n.type.toLowerCase(),r=n.type!="boxandwhisker"?"null":t.outlier;return i.indexOf("range")>-1||i.indexOf("hilo")>-1&&i.indexOf("open")==-1?"#point.x# <br/> High : #point.high# <br/> Low : #point.low#":i.indexOf("candle")>-1||i.indexOf("open")>-1?"#point.x# <br/> High : #point.high# <br/> Low : #point.low# <br/> Open : #point.open# <br/> Close : #point.close#":i.indexOf("bubble")>-1?"#point.x# : #point.y# : #point.size#":i.indexOf("box")>-1&&r?"X : #boxPlotPoints.xValue#  Y : #boxPlotPoints.YValues#":i.indexOf("box")>-1?"Minimum : #boxPlotPoints.Minimum# <br/> Upper Quartile : #boxPlotPoints.UpperQuartile# <br/> Median : #boxPlotPoints.midvalue# <br/> Lower Quartile : #boxPlotPoints.LowerQuartile# <br/> Maximum : #boxPlotPoints.Maximum#  ":"#point.x# : #point.y#"}return n.tooltip.format},getTooltipFormat:function(n,t,i,r,u,f){var e=$.extend(!0,{},n),it=this.model.AreaType,h=this.model.locale,w=t.xAxis,ct=t.yAxis,g=w._valueType.toLowerCase(),ot=ej.util.isNullOrUndefined,l=w.labelFormat,o=ct.labelFormat,rt=ej.EjSvgRender.utils._dateTimeLabelFormat,at=ej.EjSvgRender.utils._decimalPlaces,p=!1,v=!1,a,k,y,ut,c,st,nt,d,ht,lt,ft=6,et=20,b,s,tt;for(t.count=1,e.count=1,u=this.getFormat(t,f);u.indexOf("ej.format(")>=0;)c=u.substring(u.indexOf("ej.format("),u.indexOf(")")+1),b=c.substring(c.indexOf("(")+1,c.indexOf(",")),b=="#point.x#"?(p=!0,a=c.substring(c.indexOf(",")+1,c.indexOf(")"))):b=="#point.y#"?(v=!0,k=c.substring(c.indexOf(",")+1,c.indexOf(")"))):(st=c.substring(c.indexOf(",")+1,c.indexOf(")")),nt=b.substring(b.indexOf("#")+1),d=nt.substring(nt.indexOf(".")+1,nt.indexOf("#")),e.hasOwnProperty(d)&&e[d]&&(e[d]=ej.format(e[d],st,h))),u=u.replace(c,b);if(it=="cartesianaxes"?g.toLowerCase()=="datetime"?(e.x=ej.format(new Date(e.xValue),ot(l)?rt(w._intervalType,w):t.xAxis.labelFormat,h),e.x=p?ej.format(new Date(e.xValue),a,h):e.x):g.toLowerCase()=="datetimecategory"?(e.x=ej.format(new Date(e.x),ot(l)?rt(w.intervalType,w):w.labelFormat,h),e.x=p?ej.format(new Date(e.x),a,h):e.x):g.toLowerCase()=="category"?e.x=this.model.primaryXAxis.isIndexed?e.x?e.x:"undefined":ej.EjSvgRender.utils._getLabelContent(e.xValue,t.xAxis,h):(e.x=p&&(a.indexOf("e")==0||a.indexOf("E")==0)?this.convertExponential(ht,ft,et,e.x,a):p?ej.format(e.x,a,h):e.x,y=l?l.match("{value}"):null,e.x=l?y!=null?l=="${value}"?l.replace("{value}","$"+e.x):l.replace("{value}",e.x):p||l.indexOf("e")==0||l.indexOf("E")==0?e.x:ej.format(Number(e.x),l,h):e.x):g=="date"&&(e.x=ej.format(new Date(e.xValue),rt("days"),h),e.x=p?ej.format(new Date(e.xValue),a,h):e.x),v&&(k.indexOf("e")==0||k.indexOf("E")==0)?e.y=this.convertExponential(lt,ft,et,e.y,k):(e.y=e.waterfallSum?e.waterfallSum:e.y,e.y=v?ej.format(e.y,k,h):e.y),y=o?o.match("{value}"):null,e.y=o?y!=null?o=="${value}"?o.replace("{value}","$"+e.y):o.replace("{value}",e.y):v||o.indexOf("e")==0||o.indexOf("E")==0?e.y:ej.format(Number(e.y),o,h):e.y,(it=="none"||it=="polaraxes")&&p&&(a.indexOf("e")==0||a.indexOf("E")==0)&&(e.x=this.convertExponential(ht,ft,et,e.x,a)),t.isStacking&&t.drawType=="area"&&(t.type=="polar"||t.type=="radar")&&(e.y=t.stackedValue.EndValues[r]-t.stackedValue.StartValues[r]),t.type.toLowerCase()=="boxandwhisker"){if(s=t._visiblePoints[r].boxPlotValues,f.outlier==!0)for(tt=0;tt<s.outliers.length;tt++)f.YValues==s.outliers[tt]&&(f.YValues=o?y!=null?o=="${value}"?o.replace("{value}","$"+f.YValues):o.replace("{value}",f.YValues):v||o.indexOf("e")==0||o.indexOf("E")==0?f.YValues:ej.format(Number(f.YValues),o,h):f.YValues);else f.YValues==s.Minimum?s.Minimum=o?y!=null?o=="${value}"?o.replace("{value}","$"+s.Minimum):o.replace("{value}",s.Minimum):v||o.indexOf("e")==0||o.indexOf("E")==0?s.Minimum:ej.format(Number(s.Minimum),o,h):s.Minimum:f.YValues==s.Maximum?s.Maximum=o?y!=null?o=="${value}"?o.replace("{value}","$"+s.Maximum):o.replace("{value}",s.Maximum):v||o.indexOf("e")==0||o.indexOf("E")==0?s.Maximum:ej.format(Number(s.Maximum),o,h):s.Maximum:f.YValues==s.UpperQuartile?s.UpperQuartile=o?y!=null?o=="${value}"?o.replace("{value}","$"+s.UpperQuartile):o.replace("{value}",s.UpperQuartile):v||o.indexOf("e")==0||o.indexOf("E")==0?s.UpperQuartile:ej.format(Number(s.UpperQuartile),o,h):s.UpperQuartile:f.YValues==s.LowerQuartile?s.LowerQuartile=o?y!=null?o=="${value}"?o.replace("{value}","$"+s.LowerQuartile):o.replace("{value}",s.LowerQuartile):v||o.indexOf("e")==0||o.indexOf("E")==0?s.LowerQuartile:ej.format(Number(s.LowerQuartile),o,h):s.LowerQuartile:f.YValues==s.midvalue&&(s.midvalue=o?y!=null?o=="${value}"?o.replace("{value}","$"+s.midvalue):o.replace("{value}",s.midvalue):v||o.indexOf("e")==0||o.indexOf("E")==0?s.midvalue:ej.format(Number(s.midvalue),o,h):s.midvalue);s.count=t.count;s.xValue=e.x;s.YValues=f.YValues;ut={boxPlotPoints:s}}else ut={series:t,point:e};return u=u.parseTemplate(ut),{data:e,text:u}},convertExponential:function(n,t,i,r,u){return n=u.match(/(\d+)/g),n=n==null?t:n>i?i:n,r.toExponential(n)},displayShowTooltip:function(n,t,i,r){var it=this.model.requireInvertedAxes,d=i.tooltip.isReversed,et,v,kt,dt,e,nt,a,vt,k,st,tt,ht,w,yt,ni,pt,ti,ii,ct;if(t.visible!==!1){$(".ejTooltip"+this._id).not("#"+this.svgObject.id+"_TrackToolTip").remove();$.finish?$(".ejTooltip"+this._id).finish():$(".ejTooltip"+this._id).stop(!0,!0);var wt,bt,b=!i.isIndicator&&!i.isTrendLine?$.inArray(i,this.model._visibleSeries):0,rt,lt,o=7,ut=15,s,h,y,at=i.tooltip.format,c=document.getElementById(this.svgObject.id).getClientRects()[0],ft=this.model.m_AreaBounds,u=i.type.toLowerCase();switch(this.model.AreaType){case"cartesianaxes":s=d?n.X-(!i.isIndicator&&!i.isTrendLine?ej.util.isNullOrUndefined(i._trackMarker)?u=="bubble"?t.radius+ut:i.marker.size.width:i._trackMarker.size.width:0)+(u=="column"||u=="bar"||u=="stackingbar"||u=="stackingcolumn"||u=="waterfall"||u=="rangecolumn"?ft.X:it?i.yAxis.x:i.xAxis.x):n.X+(!i.isIndicator&&!i.isTrendLine?ej.util.isNullOrUndefined(i._trackMarker)?u=="bubble"?t.radius+ut:i.marker.size.width:i._trackMarker.size.width:0)+(u=="column"||u=="bar"||u=="stackingbar"||u=="stackingcolumn"||u=="waterfall"||u=="rangecolumn"?ft.X:it?i.yAxis.x:i.xAxis.x);h=n.Y+(u.indexOf("column")!=-1||u.indexOf("waterfall")!=-1||u.indexOf("bar")!=-1||u.indexOf("rangearea")!=-1||u=="scatter"||u=="bubble"?this.dragPoint?it?i.xAxis.y:i.yAxis.y:ft.Y:it?i.xAxis.y:i.yAxis.y);this.dragPoint&&(s=s>i.xAxis.x?s:i.xAxis.x,h=h<i.yAxis.height+i.yAxis.y?h:i.yAxis.height+i.yAxis.y);rt=this.getSeriesColor(t,b,i);break;case"polaraxes":s=d?n.X-o+(ej.util.isNullOrUndefined(i._trackMarker)?i.marker.size.width:i._trackMarker.size.width):n.X+o+(ej.util.isNullOrUndefined(i._trackMarker)?i.marker.size.width:i._trackMarker.size.width);h=n.Y;rt=this.getSeriesColor(t,b,i);break;case"none":s=d?n.X-i.marker.size.width+o:n.X+i.marker.size.width+o;h=n.Y;rt=this.model.pointColors[r]}if(i.type.toLowerCase()=="boxandwhisker")for(et=0;et<i._visiblePoints[r].boxPlotLocation.length;et++)v=i._visiblePoints[r].boxPlotLocation[et],kt=v.outlier,kt?v.X+i.outlierSettings.size.width/2>n.X&&v.X-i.outlierSettings.size.width/2<n.X&&v.Y+i.outlierSettings.size.height/2>n.Y&&v.Y-i.outlierSettings.size.height/2<n.Y&&(y=this.getTooltipFormat(t,i,b,r,at,v),lt=ej.EjSvgRender.utils._measureText(y.text)):(y=this.getTooltipFormat(t,i,b,r,at,v),lt=ej.EjSvgRender.utils._measureText(y.text));else y=this.getTooltipFormat(t,i,b,r,at),lt=ej.EjSvgRender.utils._measureText(y.text);var g=this.getTooltipOptions(rt,i),ri=g.rectBColor,ui=g.rectFColor,fi=g.rectTextColor,ei=g.rectX,oi=g.rectY,e=i.tooltip,p,o=5;if(p=document.getElementById(this.svgObject.id+"_TrackToolTip")==null?$("<div><\/div>").attr({id:this.svgObject.id+"_TrackToolTip","class":"ejTooltip"+this._id}):$("#"+this.svgObject.id+"_TrackToolTip"),dt=!!navigator.userAgent.match(/Trident\/7\./),!ej.isTouchDevice()||dt||this.vmlRendering?this._on(p,"mousemove",this.chartTooltipHover):window.navigator.msPointerEnabled?this._on(p,"MSPointerMove",this.chartTooltipHover):this._on(p,"touchmove",this.chartTooltipHover),$("#"+this.svgObject.id+"_TrackToolTip").show(),bt=$("#"+this._id).parent()[0].style.zIndex,e={top:h+$(document).scrollTop(),left:s+$(document).scrollLeft(),"background-color":e.fill?e.fill:ui,"border-style":"solid",position:"absolute","border-color":e.border.color?e.border.color:ri,"border-width":e.border.width||e.border.width==0?e.border.width:1,opacity:e.opacity,"z-index":bt+1e6,"border-radius":(e.rx?e.rx:ei).toString()+"px "+(e.ry?e.ry:oi).toString()+"px","padding-left":"5px","padding-right":"5px","padding-top":"2px","padding-bottom":"2px"},$(p).css(e),nt=$.extend({},ej.EjSvgRender.commonChartEventArgs),nt.data={seriesIndex:b,pointIndex:r,currentText:y.text,isTrendLine:i.isTrendLine,trendlineIndex:i.trendlineIndex},this._trigger("toolTipInitialize",nt),!nt.cancel){var si=0,ot=i.tooltip,l=ot.font?$.extend(!1,i.font,{},ot.font):i.font,hi={top:h+$(document).scrollTop(),left:s+$(document).scrollLeft(),color:ot.font&&ot.font.color?l.color:fi,"font-size":l.size,"font-family":l.fontFamily,"font-style":l.fontStyle,"font-weight":l.fontWeight,"align-self":"baseline"};for($(p).css(hi),document.getElementById(this.svgObject.id+"_TrackToolTip")==null&&$(document.body).append(p[0]),a=wt=nt.data.currentText,$("#"+this.svgObject.id+"_TrackToolTip").html(a),vt=0,k=0,a=a.replace(/<br >/g,"<br/>").replace(/<br \/>/g,"<br/>").replace(/<br>/g,"<br/>"),a=a.split("<br/>"),st=0;st<a.length;st++)for(tt=a[st],tt=tt.split("<\/tr>"),ht=0;ht<tt.length;ht++)w=tt[ht],w=this.RemoveTableAttr(w),w=w.replace(/&nbsp;/g," "),vt+=ej.EjSvgRender.utils._measureText(w,null,l).height,yt=ej.EjSvgRender.utils._measureText(w,null,l).width,k<yt&&(k=yt);si=this.model.AreaType=="cartesianaxes"?ej.EjSvgRender.utils._measureText(wt,i.xAxis.width,l).height:ej.EjSvgRender.utils._measureText(a,null,l).height;var ci=this.model.AreaType=="cartesianaxes"?this.model.requireInvertedAxes?i.yAxis.width:i.xAxis.width:$(this.svgObject).width()-(this.model.legend.position.toLowerCase()=="right"?this.model.LegendViewerBounds.Width+2*this.model.elementSpacing:0),gt=this.model.AreaType=="cartesianaxes"?this.model.requireInvertedAxes?i.xAxis.height:i.yAxis.height:$(this.svgObject).height()-(this.model.legend.position.toLowerCase()=="bottom"?this.model.LegendViewerBounds.Height+this.model.elementSpacing:0),f=$("#"+this.svgObject.id+"_TrackToolTip")[0].getBoundingClientRect();$("#"+this.svgObject.id+"_TrackToolTip").css("top",$(document).scrollTop()+f.top+c.top-(vt+4)/2);$("#"+this.svgObject.id+"_TrackToolTip").css("left",$(document).scrollLeft()+f.left+c.left+(f.left-s));s+(k+o)>=ci+i.xAxis.x&&!d&&(pt=document.getElementById(this.svgObject.id).getClientRects()[0],ct=s-(k+o*2+(!i.isIndicator&&!i.isTrendLine?ej.util.isNullOrUndefined(i._trackMarker)?i.marker.visible?i.marker.size.width:u=="bubble"?t.radius+ut:0:i._trackMarker.size.width:0)+2*o),$("#"+this.svgObject.id+"_TrackToolTip").css("left",ct+pt.left-o+$(document).scrollLeft()));f=$("#"+this.svgObject.id+"_TrackToolTip")[0].getBoundingClientRect();(f.bottom>=i.yAxis.y+gt+c.top||f.bottom>=i.xAxis.y+gt+c.top)&&(ni=h-(f.bottom-f.top+(!i.isIndicator&&!i.isTrendLine?ej.util.isNullOrUndefined(i._trackMarker)?i.marker.visible?i.marker.size.height:0:i._trackMarker.size.height:0))+o+c.top,$("#"+this.svgObject.id+"_TrackToolTip").css("top",ni+$(document).scrollTop()));f=$("#"+this.svgObject.id+"_TrackToolTip")[0].getBoundingClientRect();f.left<0&&(pt=document.getElementById(this.svgObject.id).getClientRects()[0],ti=ft.Width/2,n.X<ti?$("#"+this.svgObject.id+"_TrackToolTip").css("left",s+c.left):($("#"+this.svgObject.id+"_TrackToolTip").css("width",f.right-2*o),$("#"+this.svgObject.id+"_TrackToolTip").css("left",0)));(f.top<c.top||f.top<0)&&$("#"+this.svgObject.id+"_TrackToolTip").css("top",(c.top<0?$(document).scrollTop():c.top)+"px");d&&(ii=f.right-f.left,$("#"+this.svgObject.id+"_TrackToolTip").css("left",f.x-ii),f.x<i.xAxis.x&&(ct=k+o*2+(!i.isIndicator&&!i.isTrendLine?ej.util.isNullOrUndefined(i._trackMarker)?i.marker.visible?i.marker.size.width:u=="bubble"?t.radius+ut:0:i._trackMarker.size.width:0)+2*o,$("#"+this.svgObject.id+"_TrackToolTip").css("left",f.x+ct)));$("#"+this.svgObject.id+"_TrackToolTip").show()}}},RemoveTableAttr:function(n){var t,i,r;for((n.indexOf("<table>")!=-1||n.indexOf("<\/table>")!=-1||n.indexOf("<td>")!=-1||n.indexOf("<\/td>")!=-1||n.indexOf("<tr>")!=-1)&&(n=n.replace(/\//g,"").replace(/<table>/g,"").replace(/<th>/g,"").replace(/<tr>/g,"").replace(/<td>/g,""));n.search(/<td/i)>-1;)if(n.search(/<tr/)>-1)n=n.slice(n.search(/<td/i));else if(n.search(/<td/)>-1&&n.indexOf(">")>n.search(/<td/)){for(n=n.slice(n.indexOf(">")+1),t=n.split("<td"),i=0;i<t.length;i++)r=t[i],t[i]=r.indexOf(">")>-1?r.slice(r.indexOf(">")+1):r;n=t.join("")}return n},chartTooltipHover:function(n){var t=$("#"+n.target.id)[0].getBoundingClientRect(),u=n.clientX-t.left,i=5,r;$("#"+n.target.id).css("left",t.left+u+i);t=$("#"+n.target.id)[0].getBoundingClientRect();r=document.getElementById(this.svgObject.id).getClientRects()[0];t.right>r.right+i&&$("#"+n.target.id).css("left",n.clientX-(t.right-t.left)-i)},_initializeSeriesColors:function(){var n=this,l=n.model.palette?n.model.palette:n.model.colors,y=l.length,e=n.model.AreaType,o,r,u,i,a,s,p,v,c,h,f,t;if(n.model.seriesColors=[],n.model.seriesBorderColors=[],n.model.pointColors=[],n.model.pointBorderColors=[],s=n.model._visibleSeries.length,p=n.model._visibleSeries,e!="none")o=n.model._visibleSeries,r=n.model.seriesColors,u=n.model.seriesBorderColors;else{for(h=0,t=0;t<s;t++)c=n.model._visibleSeries[t].type.toLowerCase(),n.model._visibleSeries[t].points.length>h?(h=n.model._visibleSeries[t].points.length,v=n.model._visibleSeries[t].points):n.model._visibleSeries[t].points.length==h&&c!="funnel"&&c!="pieofpie"&&c!="pyramid"&&(v=n.model._visibleSeries[t].points);o=v||[];r=n.model.pointColors;u=n.model.pointBorderColors}if(e=="none"&&s>1)for(f=0;f<s;f++)n.model.seriesColors[f]=l[f%y];for(t=0;t<o.length;t++)i=o[t],a=i.trendlines,i.isFill=i.isFill==undefined?i.fill&&i.fill!=""?!0:!1:i.isFill,i.isFill?r[t]=i.fill:(r[t]=l[t%y],i._hiloTypes||(i.fill=r[t])),e!="none"&&a.length>0&&this._initializeTrendlinesColors(a,r[t]),ej.util.isNullOrUndefined(i.border)||ej.util.isNullOrUndefined(i.border.color)||i.border.color==""?(u[t]=n.model.seriesBorderDefaultColors[t%10],e!="none"&&(i.border.color=u[t])):u[t]=i.border.color,i.dataPoint=i.points,i.trendLine=i.trendlines},_initializeTrendlinesColors:function(n,t){for(var i in n)(ej.util.isNullOrUndefined(n[i].fill)||n[i].fill=="")&&(n[i].fill=t)},_createAxisLabelAndRange:function(){for(var u,v,f,y=0,t=this.model,i=t.series,c=i.length,l,a,r,n,s=t.primaryXAxis,e=t.primaryYAxis,p,o=0;o<c;o++)a=i[o],a._isTransposed&&this.model.AreaType!="polaraxes"&&y++;for(c&&(y==c?t.requireInvertedAxes=!0:(a=i[0],a._isTransposed&&this.model.AreaType!="polaraxes"&&(t.requireInvertedAxes=!0))),t.requireInvertedAxes?(e.orientation="horizontal",s.orientation="vertical",e.labelPlacement=e.labelPlacement?e.labelPlacement:ej.datavisualization.Chart.LabelPlacement.OnTicks):(e.orientation="vertical",s.orientation="horizontal"),e.name=ej.util.isNullOrUndefined(e.name)?"SecondaryAxis":e.name,s.name=ej.util.isNullOrUndefined(s.name)?"PrimaryAxis":s.name,t._axes=[],t._axes[0]=s,t._axes[1]=e,p=t.axes.length,l=t.indicators,o=0;o<p;o++)if(n=t.axes[o],n.name){for(u=0;u<c;u++)if(v=i[u].type.toLowerCase(),i[u].xAxisName==n.name){n.orientation=v.indexOf("bar")!=-1?i[u].isTransposed?"horizontal":"vertical":i[u].isTransposed?"vertical":"horizontal";break}else if(i[u].yAxisName==n.name){n.orientation=v.indexOf("bar")!=-1?i[u].isTransposed?"vertical":"horizontal":i[u].isTransposed?"horizontal":"vertical";break}for(f=0;f<l.length;f++)if(l[f].xAxisName==n.name){n.orientation="horizontal";break}else if(l[f].yAxisName==n.name){n.orientation="vertical";break}if(!n.orientation)continue;t.axes[o]=n.orientation.toLowerCase()=="horizontal"?$.extend(!0,{},t.secondaryX,n):$.extend(!0,{},t.secondaryY,n);t._axes.push(t.axes[o])}for(f=0;f<t._axes.length;f++){var n=this.model._axes[f],h=n.scrollbarSettings,r=h.range,w=n.orientation.toLowerCase();n.visibleLabels=[];n.range=n.range.min==null&&n.range.max==null&&n.range.interval==null?null:n.range;n.setRange=n.range?ej.util.isNullOrUndefined(n.setRange)?!0:n.setRange:!1;n.setRange=n.actual_Range||n.setRange!=!1?!0:!1;n.actualRange=n.actualRange?n.actualRange:n.range==null?{}:$.extend(!0,{},n.range);n.visibleRange=n.visibleRange?n.visibleRange:n.range==null?{}:n.range;n.name=n.name?n.name:f.toString();n._isScroll=h.visible&&(h.pointsLength!=null||r.min!=null||r.max!=null)||t.zooming.enableScrollbar&&h.visible&&(n.zoomFactor<1||n.zoomPosition>0);n._pointsLength=h.pointsLength;typeof r.min=="string"&&r.min.indexOf("/Date(")!=-1&&(r.min=new Date(parseInt(r.min.substr(6))));typeof r.max=="string"&&r.max.indexOf("/Date(")!=-1&&(r.max=new Date(parseInt(r.max.substr(6))))}},_drawTitle:function(){var n=this.model.title,t=this.model.margin,o=$(this.svgObject).width(),i=ej.EjSvgRender.utils._measureText(n.text,o-t.left-t.right,n.font),u=this.model.elementSpacing,it=n.text==""||!n.visible?0:i.height+u,t=t,rt=this.model.m_AreaBounds,ut=this.model.AreaType,ft=this.model.legend.position.toLowerCase()=="left"?this.model.LegendViewerBounds.Width/2:this.model.legend.position.toLowerCase()=="right"?-this.model.LegendViewerBounds.Width/2:0,b=t.left+u+this.model.border.width,k=t.right+u+this.model.border.width,e=this.model.titleWrapTextCollection,d,et=parseInt(n.font.size),l=parseInt(n.font.size)*1.2,g=n.enableTrim,f=n.maximumWidth,ot=n.textAlignment.toLowerCase(),a=n.textOverflow.toLowerCase(),v=n.text,nt=n.isReversed,y=g&&(a=="wrap"||a=="wrapandtrim")&&e.length>1?!0:!1,c,p,w,r,s,tt,h;if(f.toString()=="auto"||f.toString()==""?(f=rt.Width*.75,this.model.titleMaxWidth=f):f=parseInt(f),c=i.width>f?!0:!1,g&&c&&a=="trim"&&(v=ej.EjSvgRender.utils._trimText(v,f,n.font),this.model.titleTrim=i=ej.EjSvgRender.utils._measureText(v,o-t.left-t.right,n.font),this.model.trimTooltip=!0),this.model.trimTooltip&&a=="wrap"&&(this.model.trimTooltip=!1),p={width:this.model.trimTooltip&&y||e.length>1?this.model.titleMaxWidth:i.width,height:i.height*(e.length>0?e.length-1:1)},n.text!=""&&n.text!=null){if(d=n.border.color=="transparent"&&n.background=="transparent"?t.top+it/2+u:t.top+l/2+u+et/4,w=(ut!="cartesianaxes"?(o-t.left-t.right)/2+(t.left+ft):b+(o-k)/2)-p.width/2,this.model.title.textAlignment.toLowerCase()=="near"?w=nt?o-k-i.width:b:this.model.title.textAlignment.toLowerCase()=="far"&&(w=nt?b:o-k-p.width),r=$.extend({},ej.EjSvgRender.commonChartEventArgs),r.data={title:v,location:{x:w,y:d},size:i},this._trigger("titleRendering",r),s={id:this.svgObject.id+"_ChartTitleText",x:r.data.location.x,y:r.data.location.y,fill:n.font.color,"font-size":n.font.size,"font-family":n.font.fontFamily,"font-style":n.font.fontStyle,"font-weight":n.font.fontWeight,opacity:n.font.opacity,"text-anchor":"start"},tt={id:this.svgObject.id+"_ChartTitleBorder",x:r.data.location.x-u,y:r.data.location.y-l+l/4,rx:n.border.cornerRadius,ry:n.border.cornerRadius,width:y&&c?this.model.titleMaxWidth+2*u:i.width+2*u,height:y&&c?i.height*e.length:l,fill:n.background,"stroke-width":n.border.width,stroke:n.border.color,opacity:n.border.opacity,"class":"e-titleborder"},this.svgRenderer.drawRect(tt,this.gTitleEle),y&&c)for(h=0;h<e.length;h++)s.id=this.svgObject.id+"_ChartTitleText_"+h,h!=0&&(s.y=s.y+i.height),this.svgRenderer.drawText(s,e[h],this.gTitleEle);else this.svgRenderer.drawText(s,r.data.title,this.gTitleEle);this.model._titleLocation={X:r.data.location.x,Y:r.data.location.y,size:p,_height:i.height};this.svgRenderer.append(this.gTitleEle,this.svgObject);n.subTitle.text!=""&&n.subTitle.text&&n.subTitle.visible&&this._drawSubTitle()}},_getLegendSize:function(n){var r=this.model.legend,t=r.itemStyle,i=ej.EjSvgRender.utils._measureText(n.Text,null,n.Font),u=t.width+10+i.width,f=Math.max(t.height,i.height);return{Width:u,Height:f}},_getYValues:function(n){for(var i=[],r=n.length,t=0;t<r;t++)i.push(n[t].y);return i},_getXValues:function(n){for(var i=[],r=n.length,t=0;t<r;t++)i.push(n[t].xValue);return i},_drawSubTitle:function(){var t=this.model.title,w=t.isReversed,n=t.subTitle,g=$(this.svgObject).width(),a=ej.EjSvgRender.utils._measureText(t.text,g-this.model.margin.left-this.model.margin.right,t.font),i=ej.EjSvgRender.utils._measureText(n.text,g-this.model.margin.left-this.model.margin.right,n.font),e="middle",it,rt=1.2,r=this.model.elementSpacing,at=parseInt(n.font.size),ut=this.model.m_AreaBounds.Width,vt=parseInt(t.font.size)*rt,s=parseInt(n.font.size)*rt,yt=n.text==""||!n.visible?0:i.height+r,ft=n.enableTrim,f=n.maximumWidth,o=t.maximumWidth,nt=n.textOverflow.toLowerCase(),kt=t.textAlignment.toLowerCase(),et=n.textAlignment.toLowerCase(),b=t.text,ot=t.enableTrim,tt=t.textOverflow.toLowerCase(),h=n.text,k,pt=ot&&(tt=="wrap"||tt=="wrapandtrim")?!0:!1,st,v=ft&&(nt=="wrap"||nt=="wrapandtrim")?!0:!1,wt,c,u,lt,l,d;if(o=o.toString()=="auto"||o.toString()==""?ut*.75:parseInt(o),f=f.toString()=="auto"||f.toString()==""?ut*.75:parseInt(f),a=ej.EjSvgRender.utils._measureText(t.text,g-this.model.margin.left-this.model.margin.right,t.font),wt=a.width>o?!0:!1,ft&&i.width>f&&nt=="trim"&&(b=ot&&tt=="trim"?ej.EjSvgRender.utils._trimText(b,o,t.font):b,h=ej.EjSvgRender.utils._trimText(h,f,n.font),a=ej.EjSvgRender.utils._measureText(b,$(this.svgObject).width()-this.model.margin.left-this.model.margin.right,t.font),i=ej.EjSvgRender.utils._measureText(h,$(this.svgObject).width()-this.model.margin.left-this.model.margin.right,n.font),this.model.subTitleTooltip=!0),st=a.width>o,h!=""&&h!=null){it=this.model.title.border.color=="transparent"&&this.model.title.background=="transparent"||this.model.title.subTitle.border.color=="transparent"&&this.model.title.subTitle.background=="transparent"?yt/2+r+this.model._titleLocation.Y+this.model._titleLocation._height*(this.model.titleWrapTextCollection?this.model.titleWrapTextCollection.length-1:0):s/2+10+r+(pt&&st?a.height*this.model.titleWrapTextCollection.length:vt)+10+at/3;c=this.model._titleLocation.X+this.model._titleLocation.size.width/2;et=="near"?(c=k=w?this.model._titleLocation.X+this.model._titleLocation.size.width:this.model._titleLocation.X,e=w?"end":"start"):et=="far"&&(c=w?this.model._titleLocation.X:this.model._titleLocation.X+this.model._titleLocation.size.width,e=w?"start":"end");u=$.extend({},ej.EjSvgRender.commonChartEventArgs);u.data={subTitle:h,location:{x:c,y:it},size:i};this._trigger("subTitleRendering",u);var bt=t.border.color=="transparent"&&t.background=="transparent"||t.subTitle.border.color=="transparent"&&t.subTitle.background=="transparent"?u.data.location.y:u.data.location.y-r/2,y={id:this.svgObject.id+"_ChartSubTitleText",x:u.data.location.x,y:bt,fill:n.font.color,"font-size":n.font.size,"font-family":n.font.fontFamily,"font-style":n.font.fontStyle,"font-weight":n.font.fontWeight,opacity:n.font.opacity,"text-anchor":e},ht,ct,p=u.data.location.x;if(ht=e=="start"?p-r:e=="end"?v?p-r-this.model.subTitleMaxWidth:p-r-i.width:v?p-r-this.model.subTitleMaxWidth/2:p-r-i.width/2,ct=t.border.color=="transparent"&&t.background=="transparent"||n.border.color=="transparent"&&n.background=="transparent"?u.data.location.y-s+s/4:u.data.location.y-s+s/4-r/2,lt={id:this.svgObject.id+"_ChartSubTitleBorder",x:ht,y:ct,rx:n.border.cornerRadius,ry:n.border.cornerRadius,width:v?this.model.subTitleMaxWidth+2*r:i.width+2*r,height:v?i.height*this.model.subTitleWrapTextCollection.length:s,fill:n.background,"stroke-width":n.border.width,stroke:n.border.color,opacity:n.border.opacity,"class":"e-subtitleborder"},this.svgRenderer.drawRect(lt,this.gSubTitleEle),v&&i.width>f)for(l=0;l<this.model.subTitleWrapTextCollection.length;l++)y.id=this.svgObject.id+"_ChartSubTitleText_"+l,l!=0&&(y.y=y.y+i.height),this.svgRenderer.drawText(y,this.model.subTitleWrapTextCollection[l],this.gSubTitleEle);else this.svgRenderer.drawText(y,u.data.subTitle,this.gSubTitleEle);d={width:this.model.subTitleTooltip?f:i.width,height:i.height*this.model.subTitleWrapTextCollection.length};e=="middle"?k=c-d.width/2:e=="end"&&(k=c-d.width);this.model._subTitleLocation={X:k,Y:u.data.location.y-i.height/2,size:d};this.svgRenderer.append(this.gSubTitleEle,this.gTitleEle)}},_calculateStackingValues:function(n,t,i){var p=this.model,c,w,h,r;p.stackedValue[t.name]=[];c=p.stackedValue[t.name];c.min=0;c.max=0;var d=p.requireInvertedAxes?p.vAxes:p.hAxes,ut=d.length,nt,tt,u,ft=n.length,g,s,v,f,l,a,k=ej.util.isNullOrUndefined;for(w=0;w<ut;w++){r=0;var s=[],v=[],y=[],b=[],o=0,e,it;for(h=0;h<n.length;h++)if(n[h]._xAxisName==d[w].name&&(n[h].type.toLowerCase().indexOf("stacking")!=-1||n[h].isStacking)){for(f={},f.StartValues=[],f.EndValues=[],u=n[h].stackingGroup,u&&n[h].type.toLowerCase()!="stackingarea"?k(s[u])&&(s[u]=[],v[u]=[],y[u]=[],b[u]=[]):(u="",k(s[u])&&(s[u]=[],v[u]=[],y[u]=[],b[u]=[])),e=n[h],o=this._getXCrossValue(e,d[w],i),typeof o!="number"&&(o=0),g=ej.EjSeriesRender.prototype._isVisiblePoints(e),tt=this._getYValues(e._visiblePoints),nt=g.length,r=0;r<nt;r++){var l=0,rt=0,a=tt[r];k(s[u][e._visiblePoints[r].xValue])&&(s[u][e._visiblePoints[r].xValue]=o);k(v[u][e._visiblePoints[r].xValue])&&(v[u][e._visiblePoints[r].xValue]=o);f.StartValues.length<=r&&(f.StartValues.push(0),f.EndValues.push(0));a>=0?(y[u][r]=y[u][r]==null,a-=y[u][r]&&o,l=e.type.toLowerCase().indexOf("stacking")!=-1||a>0?s[u][e._visiblePoints[r].xValue]:0,s[u][e._visiblePoints[r].xValue]+=a,rt=l<o?o-l:0,f.StartValues[r]=l+rt,f.EndValues[r]=a+l):(b[u][r]=b[u][r]==null,a-=b[u][r]&&o,l=v[u][e._visiblePoints[r].xValue],v[u][e._visiblePoints[r].xValue]+=a,f.StartValues[r]=l,f.EndValues[r]=a+l,o<f.EndValues[r]&&(v[u][e._visiblePoints[r].xValue]=f.StartValues[r],s[u][e._visiblePoints[r].xValue]=f.EndValues[r],y[u][r]=y[u][r]==null));it=g[r].actualIndex;e.points[it].YValues=[f.EndValues[r]]}f.stackedSeries=!0;c.push(f);c.min>Math.min.apply(0,f.StartValues)&&(c.min=Math.min.apply(0,f.StartValues));c.max<Math.max.apply(0,f.EndValues)&&(c.max=Math.max.apply(0,f.EndValues));e.stackedValue=f}}},_calculateStackingCumulativeValues:function(n,t,i){var l,st,et,f,d,e,o,y,k,u,g,nt,h,tt,it;this.model.stackedValue[t.name]=[];this.model.stackedValue[t.name].min=0;this.model.stackedValue[t.name].max=0;var b=this.model.requireInvertedAxes?this.model.vAxes:this.model.hAxes,ut=n.length,ot=b.length,rt;for(l=0;l<ot;l++){var c=[],a=[],v=[],r=" ",p=[],w=[],s=0,ft=[];for(f=0;f<ut;f++)if(st=ej.EjSeriesRender.prototype._isVisiblePoints(n[f]),r=n[f].stackingGroup,n[f].type.toLowerCase().indexOf("100")!=-1&&n[f]._xAxisName==b[l].name)for(n[f].stackingGroup&&n[f].type.toLowerCase()!=" stackingarea100 "?c[r]||(v[r]=[],c[r]=[],a[r]=[],p[r]=[],w[r]=[]):(n[f].stackingGroup="",r=n[f].stackingGroup,c[r]||(v[r]=[],c[r]=[],a[r]=[],p[r]=[],w[r]=[])),ft[r]=f,y=this._getYValues(n[f]._visiblePoints),k=y.length,u=0;u<k;u++)et=y[u],v[r][n[f].points[u].xValue]||(v[r][n[f].points[u].xValue]=0),v[r][n[f].points[u].xValue]+=Math.abs(et);for(f=0;f<ut;f++)if(r=n[f].stackingGroup,n[f].type.toLowerCase().indexOf("100")!=-1&&(d=!1,n[f]._xAxisName==b[l].name)){for(e={},e.StartValues=[],e.EndValues=[],o=n[f],s=this._getXCrossValue(o,b[l],i),typeof s!="number"&&(s=0),y=this._getYValues(o._visiblePoints),k=y.length,u=0;u<k;u++)nt=0,h=y[u],rt=h/v[r][o.points[u].xValue]*100,h=isNaN(rt)?0:rt,o.points[u].percentage=h.toFixed(2),c[r][o.points[u].xValue]||(c[r][o.points[u].xValue]=s),a[r][o.points[u].xValue]||(a[r][o.points[u].xValue]=s),e.StartValues.length<=u&&(e.StartValues.push(0),e.EndValues.push(0)),h>=0?(tt=c[r][o.points[u].xValue],p[r][u]=p[r][u]==null,h-=p[r][u]&&s,nt=tt<s?s-tt:0,g=tt,c[r][o.points[u].xValue]+=h):(it=a[r][o.points[u].xValue],w[r][u]=w[r][u]==null,h-=w[r][u]&&s,nt=it>s?s-it:0,g=it,a[r][o.points[u].xValue]+=h),e.StartValues[u]=g+nt,e.EndValues[u]=g+h,e.EndValues[u]>100&&(e.EndValues[u]=100),o.points[u].YValues=[e.EndValues[u]],d=ft[r]==f?!1||d:!0;e.stackedSeries=d;this.model.stackedValue[t.name].push(e);this.model.stackedValue[t.name].min>Math.min.apply(0,e.StartValues)&&(this.model.stackedValue[t.name].min=Math.min.apply(0,e.StartValues));this.model.stackedValue[t.name].max<Math.max.apply(0,e.EndValues)&&(this.model.stackedValue[t.name].max=Math.max.apply(0,e.EndValues));this.model.stackedValue[t.name].min>Math.min.apply(0,e.EndValues)&&(this.model.stackedValue[t.name].min=-100);o.stackedValue=e}}},_legendItemBounds:function(n,t,i){var r=this.model.legend,s,h=r.position.toLowerCase(),c=r.itemPadding,u,e,o=0,f=0;return ej.util.isNullOrUndefined(r.columnCount)&&r.rowCount?(u=r.rowCount,e=Math.ceil(n/u),o=t*e,f=i*u):ej.util.isNullOrUndefined(r.rowCount)&&r.columnCount?(u=Math.ceil(n/r.columnCount),s=r.columnCount,o=t*s,f=i*u):r.rowCount&&r.columnCount&&(r.columnCount<r.rowCount?(u=r.rowCount,e=Math.ceil(n/u),o=t*e,f=i*u):r.columnCount>r.rowCount?h==="top"||h==="bottom"||h==="custom"?(u=Math.ceil(n/r.columnCount),s=r.columnCount,o=t*s,f=i*u):(u=Math.ceil(n/r.columnCount),e=Math.ceil(n/u),o=t*e,f=i*u):h==="top"||h==="bottom"||h==="custom"?(u=Math.ceil(n/r.columnCount),s=Math.ceil(n/r.rowCount),o=t*r.columnCount,f=i*s):(u=r.rowCount,e=Math.ceil(n/u),o=t*e,f=i*u)),f+=this.model.elementSpacing,{LegendWidth:o,LegendHeight:f}},_isEjScroller:function(){var n=this,i=n.model,r=$(n.legendContainer),t=i.legend;t._ejScroller=ej.util.isNullOrUndefined($("#"+r[0].id).ejScroller)?!1:t.enableScrollbar},_rowsCalculation:function(n,t,i){for(var v=this,y=v.model,w=y.legend,r,o=[],f,l,p=n.legendItem?n.legendItem.Text.toString():n.text,s=p.split(" "),h=t,c=n.legendItem?n.legendItem.LegendStyle.Font:n.font,a=s.length,e=0,u=0;u<a;u++)if(r=s[u],f=ej.EjSvgRender.utils._measureText(r,null,c).width,f<=h){while(u<a)if(f=ej.EjSvgRender.utils._measureText(r,null,c).width,l=s[u+1]?ej.EjSvgRender.utils._measureText(s[u+1],null,c).width:0,f+l<=h&&l>0)r=r.concat(" "+s[u+1]),u++;else{e=Math.max(e,f);break}o.push(r)}else i=="wrapandtrim"?(r=ej.EjSvgRender.utils._trimText(r,h,c),o.push(r),this.model._legendMaxWidth=h,e=Math.max(e,h),n.legendItem||(this.model.trimTooltip=!0)):(o.push(r),n.legendItem?this.model._legendMaxWidth=Math.max(this.model._legendMaxWidth,f):e=Math.max(e,f));return this.model._legendMaxHeight=Math.max(this.model._legendMaxHeight,o.length),{textCollection:o,wordMax:e}},_triggerLegendEvent:function(n,t,i){var r=this,e=r.model,f=e.legend,l=e.AreaType,a=f.itemStyle,v=a.border,b=e.elementSpacing,s=f.textWidth,k=ej.EjSvgRender,d=r.svgRenderer,y=e._visibleSeries.length,g=r.svgObject,nt=e.enableCanvasRendering,b=e.elementSpacing,h=f.textOverflow.toLowerCase(),o,c,p,u,w={BorderColor:v.color,BorderWidth:v.width,Opacity:f.opacity,Color:t,Font:$.extend(!0,{},f.font)};return u=$.extend({},k.commonChartEventArgs),u.data={svgRenderer:d,svgObject:g,symbolShape:f.shape,legendItem:{Text:n,Shape:f.shape,LegendStyle:w,SeriesIndex:l=="none"&&y==1?0:i},style:{ShapeSize:a,ElementSpace:b,Style:w,ID:r.svgObject.id+"_LegendItemShape"+i,SeriesIndex:l=="none"&&y==1?0:i},gLegendItemEle:r.gLegendItemEle},nt&&(u.data.style.context=!0),r._trigger("legendItemRendering",u),o=u.data.legendItem.Text,c=u.data.legendItem.LegendStyle.Font,p=ej.EjSvgRender.utils._measureText(o,null,c).width,h=="trim"?p>s&&(o=ej.EjSvgRender.utils._trimText(o,s,c),r.model._legendMaxWidth=s):(h=="wrap"||h=="wrapandtrim")&&(o=r._rowsCalculation(u.data,s,this.model.legend.textOverflow.toLowerCase()).textCollection),{commonEventArgs:u,legendItem:o}},_calculateLegendBounds:function(){var pt,i,ft;this.model.legendCollection=[];this.model.legendTextRegion=[];this.model.legendRegion=[];this.model.svgHeight=$(this.svgObject).height();this.model.svgWidth=$(this.svgObject).width();this.model._legendMaxWidth=0;this.model._legendMaxHeight=0;var k=this,n=k.model,ii=Math,c=ii.max,li=ii.min,ht=ii.abs,t=n.legend,w=10,d=t.size.height,g=t.size.width,et=t.isReversed,e=t.itemPadding>0?t.itemPadding:0,r=t.position.toLowerCase(),l=0,a=0,wt=n.svgHeight,bt=n.svgWidth,nt=0,tt=0,o=0,p=0,ri=1,s,ai,ui,fi,vi,yi,ct={},b=[],pi,ei,ot,i,oi,tr=n.AreaType,st=n._visibleSeries,si=t.rowCount,it,hi=t.columnCount,kt=n.elementSpacing,dt,v,lt,at,vt,ci,u,wi,gt=ej.EjSvgRender.utils._measureText(t.title.text,null,t.title.font),h,bi,ki,rt=0,ut=0,di=n.border.width,yt=t.border.width,ni,f,y,gi,ti=t.textOverflow.toLowerCase(),nr=wt-(kt*4+di*2+t.border.width*2),ir=bt-(kt*4+di*2+yt*2);if(st&&t.visible&&st.length!=0){if(ni=st[0].type.toLowerCase(),tr=="none"&&st.length==1||ni=="pieofpie"||ni=="pyramid"||ni=="funnel")for(v=st[0],dt=ej.EjSeriesRender.prototype._calculateVisiblePoints(v).legendPoints,lt=dt.length,i=et&&(r=="top"||r=="bottom")?lt-1:0;et&&(r=="top"||r=="bottom")?i>=0:i<lt;et&&(r=="top"||r=="bottom")?i--:i++)at=t.fill?t.fill._gradientStop?t.fill._gradientStop:t.fill:n.pointColors[dt[i].actualIndex],it=dt[i],vt=ej.util.isNullOrUndefined(it.x)?"series"+i:it.x,ki=it.visibleOnLegend?it.visibleOnLegend:"visible",it.isEmpty||ki.toLowerCase()!="visible"||v.visibleOnLegend.toLowerCase()!="visible"||(f=this._triggerLegendEvent(vt,at,i),y=f.commonEventArgs.data.legendItem.LegendStyle,ct={Text:f.legendItem,displayText:f.commonEventArgs.data.legendItem.Text,Font:y.Font,SeriesIndex:0,PointIndex:i,ActualIndex:it.actualIndex,fill:y.Color,visibility:it.visible!==!1?"visible":"hidden",Shape:f.commonEventArgs.data.legendItem.Shape,LegendStyle:y,CommonEventArgs:{cancel:f.commonEventArgs.cancel,data:f.commonEventArgs.data}},b.push(ct));else for(lt=st.length,i=et&&(r=="top"||r=="bottom")?lt-1:0;et&&(r=="top"||r=="bottom")?i>=0:i<lt;et&&(r=="top"||r=="bottom")?i--:i++)for(at=t.fill?t.fill._gradientStop?t.fill._gradientStop:t.fill:ej.util.isNullOrUndefined(n.seriesColors[i])?n.pointColors[i]:n.seriesColors[i],v=st[i],vt=v.name?v.name:"series"+i,v.visibleOnLegend.toLowerCase()=="visible"&&(f=this._triggerLegendEvent(vt,at,i),y=f.commonEventArgs.data.legendItem.LegendStyle,ct={Text:f.legendItem,displayText:f.commonEventArgs.data.legendItem.Text,Font:y.Font,SeriesIndex:i,fill:y.Color,visibility:v.visibility,Shape:f.commonEventArgs.data.legendItem.Shape,LegendStyle:y,CommonEventArgs:{cancel:f.commonEventArgs.cancel,data:f.commonEventArgs.data}},b.push(ct)),ei=v.trendlines,pi=ei.length,pt=0;pt<pi;pt++)ot=ei[pt],at=t.fill?t.fill._gradientStop?t.fill._gradientStop:t.fill:ot.fill,vt=ot.name?ot.name:"series"+i,ot.visibility!=""&&ot.visibleOnLegend.toLowerCase()=="visible"&&(f=this._triggerLegendEvent(vt,at,i),y=f.commonEventArgs.data.legendItem.LegendStyle,ct={Text:f.legendItem,displayText:f.commonEventArgs.data.legendItem.Text,Font:y.Font,SeriesIndex:i,trendLineIndex:pt,fill:y.Color,isTrendLine:!0,visibility:v.visibility.toLowerCase()=="visible"?ot.visibility:"hidden",Shape:f.commonEventArgs.data.legendItem.Shape,LegendStyle:y,CommonEventArgs:{cancel:f.commonEventArgs.cancel,data:f.commonEventArgs.data}},b.push(ct));for(ci=b.length,i=0;i<ci;i++)s=b[i],gi=s.CommonEventArgs.data.style.ShapeSize.width,h=k._getLegendSize(s),nt=c(this.model._legendMaxWidth>0?this.model._legendMaxWidth+e+gi:h.Width,nt),tt=c(ti=="wrap"||ti=="wrapandtrim"?h.Height*this.model._legendMaxHeight:h.Height,tt);for(p=tt+kt*2,o=nt,(hi||si)&&(fi=k._legendItemBounds(b.length,nt+e,tt+e),o=fi.LegendWidth,p=fi.LegendHeight,r==="top"||r==="bottom"||r==="custom"?p=p-e+kt:o=o-e),ft=0;ft<ci;ft++)s=b[ft],ai=s.SeriesIndex,v=n.series[ai],h=k._getLegendSize(s),(ti=="wrap"||ti=="wrapandtrim")&&(h.Width=nt,h.Height=tt),si||hi||(r=="top"||r=="bottom"||r=="custom"?(l+=h.Width+e,l>ir&&ft!=0?(l-=h.Width+e,o=c(o,l),l=h.Width+e,ri++,p+=tt+e):o=c(o,l),a=c(a,tt)):(a+=h.Height+e,a>nr?(a-=h.Height+e,p=c(p,a),a=h.Height+e,o+=nt+e):p=c(p,a),l=c(l,nt))),bi=s.visibility.toLowerCase()=="visible"?k.svgRenderer.createGradientElement("legend"+ft,b[ft].fill,0,0,0,nr,k.gLegendEle):"gray",s.CommonEventArgs.data.legendItem.LegendStyle.Color=bi,ui=si||hi?{Width:nt,Height:tt}:h,ui._Width=h.Width,s.isTrendLine&&(s.TrendLineIndex=s.trendLineIndex,oi=v.trendlines[s.trendLineIndex].type.toLowerCase(),s.CommonEventArgs.data.legendItem.drawType=s.drawType=oi=="linear"||oi=="movingaverage"?"line":"spline"),b[ft].Bounds=ui,n.legendCollection.push(s);r==="top"||r==="bottom"||r==="custom"?(o=gt.width>o-e?gt.width+w*2+e:o+w*2,l+=w,a+=w*2,n.LegendBounds={Width:c(o,l)-e,Height:c(p,a),Rows:ri}):(o=gt.width>o?gt.width+w*2:o+w*2,l+=w,a+=w,n.LegendBounds={Width:c(o,l),Height:c(p,a)+w-e,Columns:ri});n.LegendViewerBounds={Width:"0",Height:"0"};d==""||d==null?(vi=r=="left"||r=="right"||r=="custom"?ht(wt):ht(wt/100*parseInt("20%")),n.LegendViewerBounds.Height=li(vi,n.LegendBounds.Height)):n.LegendViewerBounds.Height=d.indexOf("%")!=-1?ht(wt/100*parseInt(d)):parseInt(d);g==""||g==null?(yi=r=="top"||r=="bottom"||r=="custom"?ht(bt):ht(bt/100*parseInt("20%")),n.LegendViewerBounds.Width=li(yi,n.LegendBounds.Width)):n.LegendViewerBounds.Width=g.indexOf("%")!=-1?ht(bt/100*parseInt(g)):parseInt(g)}else n.LegendBounds={Width:0,Height:0},n.LegendViewerBounds={Width:0,Height:0};u=$(k.legendContainer);wi=$(k.legendSvgContainer);t.enableScrollbar?(n.LegendActualBounds=n.LegendViewerBounds,u.removeAttr("style"),u.css({visibility:"hidden",width:n.LegendViewerBounds.Width,height:n.LegendViewerBounds.Height}),wi.css({height:n.LegendBounds.Height,width:n.LegendBounds.Width}),t._ejScroller?(t._ejScroller&&et&&u.addClass("e-rtl"),$("#"+u[0].id).ejScroller({width:n.LegendViewerBounds.Width,height:n.LegendViewerBounds.Height})):(u.css({overflow:"scroll"}),u.hasClass("e-rtl")&&u.removeClass("e-rtl")),n.LegendBounds.Width>n.LegendViewerBounds.Width&&n.LegendBounds.Height>n.LegendViewerBounds.Height?t._ejScroller?(ut=$(".e-hscrollbar").height()||0,rt=$(".e-vscrollbar").width()||0):(u.css({overflow:"scroll"}),ut=u[0].offsetHeight-yt*2-u[0].clientHeight,rt=u[0].offsetWidth-yt*2-u[0].clientWidth):n.LegendBounds.Width>n.LegendViewerBounds.Width?t._ejScroller?(ut=$(".e-hscrollbar").height()||0,rt=0):(u[0].style.overflowX="scroll",u[0].style.overflowY="hidden",ut=u[0].offsetHeight-yt*2-u[0].clientHeight,rt=0):n.LegendBounds.Height>n.LegendViewerBounds.Height&&(t._ejScroller?(ut=0,rt=$(".e-vscrollbar").width()):(u[0].style.overflowY="scroll",u[0].style.overflowX="hidden",ut=0,rt=u[0].offsetWidth-yt*2-u[0].clientWidth))):(n.LegendActualBounds=n.LegendBounds,g!=""&&g!=null&&(n.LegendActualBounds.Width=parseInt(g)),d!=""&&d!=null&&(n.LegendActualBounds.Height=parseInt(d)));n.LegendActualBounds.Height+=Math.abs(ut);n.LegendActualBounds.Width+=Math.abs(rt);n.LegendActualBounds.hScrollSize=ut;n.LegendActualBounds.vScrollSize=rt},GetPointXYOrgin:function(n,t,i,r){var u=(n-i)/(this.model.axes.PrimaryXaxis.visibleRange.max-i)*this.model.m_AreaBounds.Width,f=(t-r)/(this.model.axes.PrimaryYaxis.visibleRange.max-r)*(this.model.m_AreaBounds.Height-this.GetPointXY(this.model.axes.PrimaryXaxis.visibleRange.min,Math.max(this.model.axes.PrimaryYaxis.visibleRange.min,0)).Y);return{X:u,Y:f}},_wrap:function(n,t,i,r,u,f){var s=i,a=f.width,c=[],b=[],nt=s.length,k=0,e=0,l=i.split(" "),d=l.length,g,h,p,v,o,y,w;if(r=="wrap"){if(a>t)for(h=1;h<=s.length;h++)i=s.substring(0,h),a=ej.EjSvgRender.utils._measureText(i,null,u).width,a>t&&(k=k+1,i=s.substring(0,h-1),c[e]=i,s=s.slice(h-1,nt),g=s.split(" "),s=l.indexOf(g[0])>-1?s:"-"+s,p=ej.EjSvgRender.utils._measureText(i,null,u).width,e++,h=0);c[e]=i}else if(r=="wrapandtrim")for(v=0,e=0;e<d;e++)if(o=l[e],y=ej.EjSvgRender.utils._measureText(o,null,u).width,y<t&&a>t){while(e<d)if(y=ej.EjSvgRender.utils._measureText(o,null,u).width,w=l[e+1]?ej.EjSvgRender.utils._measureText(l[e+1],null,u).width:0,y+w<=t&&w>0)o=o.concat(" "+l[e+1]),e++;else{v=Math.max(v,y);break}c.push(o)}else if(a>t)b.push(o),o=ej.EjSvgRender.utils._trimText(o,t,u),p=ej.EjSvgRender.utils._measureText(o,null,u).width,v=Math.max(v,p),c.push(o);else{c.push(i);break}return{text:c,unTrimmedText:b}},getMultiLevelLabelSize:function(n){var e=0,r,i;n._multiLevelLabelHeight=0;for(var u=[],f=[],k=[],it=n.multiLevelLabels.length,d=n.visibleRange,t,c,g,nt,l,a,o,h=10,v,w,s,y,b=n.orientation.toLowerCase(),tt=[],p=b=="vertical"?n.length:n.width?n.width:this.model.primaryYAxis.AxisMaxWidth?n.length-this.model.primaryYAxis.AxisMaxWidth:n.length,i=0;i<it;i++)t=n.multiLevelLabels[i]=u[i]=$.extend(!0,{},this.model.multiLevelLabelsDefault,n.multiLevelLabels[i]),w=t.border.type.toLowerCase(),c=t.level,!t.visible||t.text==""||ej.util.isNullOrUndefined(t.start)||ej.util.isNullOrUndefined(t.end)||(g=Math.ceil(ej.EjSvgRender.utils._getPointXY(t.start,d,n.isInversed)*p),nt=Math.ceil(ej.EjSvgRender.utils._getPointXY(t.end,d,n.isInversed)*p),l=ej.EjSvgRender.utils._measureText(t.text,null,t.font),y=t.textOverflow.toLowerCase(),a=ej.util.isNullOrUndefined(t.maximumTextWidth)?nt-g:t.maximumTextWidth,o=b=="vertical"?t.maximumTextWidth?t.maximumTextWidth:l.width:l.height,o+=2*t.border.width,l.width>a-h&&(y=="wrap"||y=="wrapandtrim")&&(v=this._wrap(n,a-h,t.text,y,t.font,l),v=v.text,o=b=="vertical"?a-h:o*v.length),f[c]=ej.util.isNullOrUndefined(f[c])?o:f[c]<o?o:f[c]);for(u.sort(function(n,t){return parseFloat(n.level)-parseFloat(t.level)}),n.multiLevelLabels.sort(function(n,t){return parseFloat(n.level)-parseFloat(t.level)}),r=0;r<u.length;r++)r==0?(n.multiLevelLabels[r]._level=u[r]._level=0,s=0):u[r].level>s+1?(n.multiLevelLabels[r]._level=u[r]._level=s+1,s=u[r]._level):(n.multiLevelLabels[r]._level=u[r]._level=u[r].level,s=u[r].level>s?u[r].level:s),w=="curlybrace"&&(tt[n.multiLevelLabels[r]._level]=!0);for(i=0;i<f.length;i++)k[i]=e,ej.util.isNullOrUndefined(f[i])?(f.splice(i,1),i--):(e=w=="brace"?e+f[i]:e+f[i]+h/2,tt[i]&&(e+=h,f[i]+=h));return n._multiLevelLabelHeight=e,n.multiLevelLabelHeight=f,n.prevHeight=k,e},_saturationColor:function(n,t){n=this.colorNameToHex(n);n=String(n).replace(/[^0-9a-f]/gi,"");n.length<6&&(n=n[0]+n[0]+n[1]+n[1]+n[2]+n[2]);t=t||0;for(var u="#",i,r=0;r<3;r++)i=parseInt(n.substr(r*2,2),16),i=Math.round(Math.min(Math.max(0,i+i*t),255)).toString(16),u+=("00"+i).substr(i.length);return u},_drawChartAreaRect:function(){var t=(this.model.background&&this.model.background._gradientStop)?"url(#"+this.svgObject.id+"_backGradient)":this.model.background,n,i,r;this.model.backGroundImageUrl&&(t="transparent");n=this.model.border;i={id:this.svgObject.id+"_SvgRect",x:n.width/2,y:n.width/2,width:$(this.svgObject).width()-2*n.width,height:$(this.svgObject).height()-2*n.width,fill:t,opacity:n.opacity,"stroke-width":n.width,stroke:n.color,"class":"e-chartborder"};this.svgRenderer.drawRect(i,this.svgObject);this.model.backGroundImageUrl&&this._drawBackImage();this.model.AreaType!="cartesianaxes"||this.model.enable3D||(r={id:this.svgObject.id+"_ChartArea",x:this.model.m_AreaBounds.X,y:this.model.m_AreaBounds.Y,width:this.model.m_AreaBounds.Width,height:this.model.m_AreaBounds.Height,fill:this.model.chartArea.background,"stroke-width":this.model.chartArea.border.width,opacity:this.model.chartArea.border.opacity,stroke:this.model.chartArea.border.color,"class":"e-chartareaborder"},this.svgRenderer.drawRect(r,this.svgObject))},axesIndexCount:function(n,t){for(var i,r=[],u=0;u<n.length;u++)i=n[u],i.orientation.toLowerCase()=="vertical"?i.rowIndex==t&&r.push(i):i.columnIndex==t&&r.push(i);return r},axesCount:function(n){var t=[],o=[],i=0,u=this.model,r,f,e;if($.each(n,function(n,r){r.orientation.toLowerCase()=="vertical"?(i=u.rowDefinitions?u.rowDefinitions.length:0,n==0?t.push({axis:r,index:r.rowIndex}):r.rowIndex!=t[t.length-1].axis.rowIndex&&t.push({axis:r,index:r.rowIndex})):(i=u.columnDefinitions?u.columnDefinitions.length:0,n==0?t.push({axis:r,index:r.columnIndex}):r.columnIndex!=t[t.length-1].axis.columnIndex&&t.push({axis:r,index:r.columnIndex}))}),r=t.length,i>r)for(r=i,f=0;f<i;f++)o.push(f);else for(e=0;e<r;e++)o.push(t[e].index);return{length:r,indexValue:o}},_calRowSize:function(){var t=0,u=[],e=0,f=this.model.m_AreaBounds.Y+this.model.m_AreaBounds.Height,i,o,n,r,s,h;if(this.model._rowDefinitions[0].rowDefinitions!=null)for(i=0,o=this.model._rowDefinitions.length;i<o;i++)n=this.model._rowDefinitions[i].rowDefinitions,n.rowHeight=Math.abs(n.rowHeight),r=0,n.unit.toLowerCase()=="percentage"?(s=this._axisRowDefinitionSize(this.model.rowDefinitions),r=Math.floor(this.model.m_AreaBounds.Height*(n.rowHeight/s))):r=n.rowHeight,i==0&&u.push(f),u.push(f-r-e),e+=r;else for(h=Math.floor(this.model.m_AreaBounds.Height/this.model._rowDefinitions.length),t=f;t>=this.model.m_AreaBounds.Y;t=t-h)u.push(t);return u},_calColumnSize:function(){var r=[],u=this.model.m_AreaBounds.X,o=this.model.m_AreaBounds.Width,s=0,f=this.model._columnDefinitions,t,h,n,e,c,l,i,a;if(f[0].columnDefinitions!=null)for(t=0,h=f.length;t<h;t++)n=f[t].columnDefinitions,n.columnWidth=Math.abs(n.columnWidth),n.unit.toLowerCase()=="percentage"?(c=this._axisColumnDefinitionSize(this.model.columnDefinitions),e=Math.floor(o*(n.columnWidth/c))):e=n.columnWidth,t==0&&r.push(u),r.push(u+e+s),s+=e;else for(l=Math.floor(o/f.length),i=u,a=u+o;i<=a;i=i+l)r.push(i);return r},_calculateAxisSize:function(n){for(var lt,at,a,o,rt,f,yt,pt,e=!0,u=!0,v=this._calColumnSize(),s=this.model._columnDefinitions,t=0,ct=s.length;t<ct;t++){var wt=v[t],g=v[t+1],y=0,p=0,nt=!0,tt=!0,w=this.model.m_AreaBounds.Y,it=w+this.model.m_AreaBounds.Height;for(f=0,lt=s[t].axis.length;f<lt;f++){var i=s[t].axis[f],h=0,b=0,c=i._opposed;if(n.axes[i.name]._validCross||(c?tt&&(u||p==0)?(h=w,tt=!1):(b=s.farSizes[p],h=w=w-b,p++):nt&&(e||y==0)?(h=it,nt=!1):(b=s.nearSizes[y],h=it=it+b,y++)),i.columnSpan){if(!(s[t].index==i.columnIndex))continue;at=ct>=t+i.columnSpan?t+i.columnSpan:t+1;g=v[at];c||y!=0||(e=nt);c&&p==0&&(u=tt)}else g=v[t+1],e=!0,u=!0;i.Location={};i.Location.X1=wt+i.plotOffset;i.Location.Y1=h;i.Location.X2=g-i.plotOffset;i.Location.Y2=h;i.x=i.Location.X1;i.y=i.Location.Y1;i.width=i.Location.X2-i.Location.X1;i.height=i.Location.Y2-i.Location.Y1}}for(e=!0,u=!0,a=this._calRowSize(),o=this.model._rowDefinitions,t=0,rt=o.length;t<rt;t++){var bt=a[t],ut=a[t+1],k=0,ft=0,et=!0,ot=!0,st=this.model.m_AreaBounds.X,vt=st,ht=st+this.model.m_AreaBounds.Width;for(f=0,yt=o[t].axis.length;f<yt;f++){var d=0,l=0,r=o[t].axis[f],c=r._opposed;if(n.axes[r.name]._validCross||(c?ot&&(u||u==0)?(l=ht,ot=!1):(d=o.farSizes[ft],l=ht=ht+d,ft++):et&&(e||k==0)?(l=st,et=!1):(d=o.nearSizes[k],l=vt=vt-d,k++)),r.rowSpan){if(!(o[t].index==r.rowIndex))continue;pt=rt>=t+r.rowSpan?t+r.rowSpan:t+1;ut=a[pt];c||k!=0||(e=et);c&&ft==0&&(u=ot)}else ut=a[t+1],e=!0,u=!0;r.Location={};r.Location.X1=l;r.Location.Y1=bt-r.plotOffset;r.Location.X2=l;r.Location.Y2=ut+r.plotOffset;r.x=r.Location.X1;r.y=r.Location.Y2;r.height=r.Location.Y1-r.Location.Y2;r.width=r.axisLine.width}}},_validateCrossing:function(n){if(n._opposedPosition=!1,n.crossesAt!=null){var t=this._getCrossAxis(this.model._axes,n.orientation.toLowerCase()=="horizontal",n.crossesInAxis);return n._crossValue=this._getCrossValue(n,t,t._valueType),((t.isInversed?!n.opposedPosition:n.opposedPosition)?n._crossValue<=t.visibleRange.min:n._crossValue>=t.visibleRange.max)&&(n._opposedPosition=!0),t.visibleRange.min<n._crossValue&&t.visibleRange.max>n._crossValue}return!1},_axisCrossing:function(n,t,i){var u=n.orientation.toLowerCase()=="horizontal",r=this._getCrossAxis(this.model._axes,u,n.crossesInAxis),f=n._crossValue,e=Math.abs((r.isInversed?r.visibleRange.max:r.visibleRange.min)-f);this._locateAxis(n,r,u,e);t||(i._crossAxisOverlap=this._avoidOverlapping(n,this.model.m_AreaBounds,u,n.opposedPosition,i)||i._crossAxisOverlap)},_locateAxis:function(n,t,i,r){var u=(i?t.height:t.width)*r/t.visibleRange.delta;i?n.y=t.y+t.height-u:n.x=t.x+u},_avoidOverlapping:function(n,t,i,r,u){var f=0,e=n.showNextToAxisLine?u.axes[n.name]._bounds:0;if(i){if(!r&&n.y+e>t.Y+t.Height)return t.Height-=f=n.y+e-t.Y-t.Height,this._recalculateSpace(n,i,r,f),!0;if(r&&n.y-e<t.Y)return t.Y+=f=e-(n.y-t.Y),t.Height-=f,this._recalculateSpace(n,i,r,f),!0}else{if(!r&&n.x-e<t.X)return t.X+=f=e-(n.x-t.X),t.Width-=f,this._recalculateSpace(n,i,r,f),!0;if(r&&n.x+e>t.X+t.Width)return t.Width-=f=n.x+e-t.X-t.Width,this._recalculateSpace(n,i,r,f),!0;if(n.labelPosition=="inside"&&n.x+e>t.X+t.Width)return t.Width-=f=n.x+e-t.X-t.Width,this._recalculateSpace(n,i,r,f,n.showNextToAxisLine),!0}},_recalculateSpace:function(n,t,i,r,u){var l,e,s,a,f,h,o,c;if(t){for(e=this.model._rowDefinitions,s=i?e.length-1:0,f=0,h=e[s].axis.length;f<h;f++)e[s].axis[f].height-=r,e[s].axis[f].Location.Y2-=r,i&&(e[s].axis[f].Location.Y1=e[s].axis[f].y+=r);for(l=n.columnIndex,e=this.model._columnDefinitions,f=0,h=e.length;f<h;f++)if(f!==l)for(o=0,c=e[f].axis.length;o<c;o++)e[f].axis[o]._opposed===i&&(e[f].axis[o].Location.Y1=e[f].axis[o].Location.Y2=e[f].axis[o].y+=(i?1:-1)*r)}else{for(e=this.model._columnDefinitions,s=i?e.length-1:0,f=0,h=e[s].axis.length;f<h;f++)e[s].axis[f].width-=r,u||(i?e[s].axis[f].Location.X2-=r:e[s].axis[f].Location.X1=e[s].axis[f].x+=r);for(a=n.rowIndex,e=this.model._rowDefinitions,f=0,h=e.length;f<h;f++)if(f!==a)for(o=0,c=e[f].axis.length;o<c;o++)e[f].axis[o]._opposed===i&&(e[f].axis[o].Location.X1=e[f].axis[o].Location.X2=e[f].axis[o].x+=(i?-1:1)*r)}},_getCrossValue:function(n,t,i){switch(i.toLowerCase()){case"category":return t.labels.indexOf(n.crossesAt)!=-1?t.labels.indexOf(n.crossesAt):n.crossesAt;case"datetime":return isNaN(Date.parse(n.crossesAt))?null:Date.parse(n.crossesAt);case"logarithmic":return Math.log(n.crossesAt)/Math.log(t.logBase)}return n.crossesAt},_getXCrossValue:function(n,t,i){var r=t.crossesInAxis,u=n._yAxisName,f=i.axes[t.name]._validCross||i.axes[t.name]._validCross==null;return f&&t.crossesAt&&(!r&&u===this.model.primaryYAxis.name||r&&this._getCrossAxis(this.model._axes,!0,r).name===u)?t.crossesAt:0},_getAxisByName:function(n,t,i){if(i)for(var r=0,u=n.length;r<u;r++)if(n[r].name===i&&(t?n[r].orientation=="vertical":n[r].orientation=="horizontal"))return n[r]},_getCrossAxis:function(n,t,i){return this._getAxisByName(n,t,i)||(this.model.requireInvertedAxes?t?this.model.primaryXAxis:this.model.primaryYAxis:t?this.model.primaryYAxis:this.model.primaryXAxis)},_arrangeAxis:function(){for(var o,i,u,a,c,v,s,r,f,y,l,p,n=this,t,e,h=0;h<this.model._axes.length;h++)t=this.model._axes[h],t.orientation.toLowerCase()=="horizontal"?(n.model.hAxes.push(t),t.columnIndex=ej.util.isNullOrUndefined(t.columnIndex)?0:t.columnIndex,n.model.hAxes[n.model.hAxes.length-1].columnIndex=t.columnIndex):t.orientation.toLowerCase()=="vertical"&&(n.model.vAxes.push(t),t.rowIndex=ej.util.isNullOrUndefined(t.rowIndex)?0:t.rowIndex,n.model.vAxes[n.model.vAxes.length-1].rowIndex=t.rowIndex,e=ej.util.isNullOrUndefined(n.model.rowDefinitions)?null:n.model.rowDefinitions[t.rowIndex],e&&(t.axisBottomLine={},t.axisBottomLine.visible=!0,t.axisBottomLine.lineWidth=e.lineWidth,t.axisBottomLine.color=e.lineColor));if(this.model.hAxes=ej.DataManager(this.model.hAxes,ej.Query().sortBy("columnIndex")).executeLocal(),this.model.vAxes=ej.DataManager(this.model.vAxes,ej.Query().sortBy("rowIndex")).executeLocal(),o=this.axesCount(n.model.vAxes),n.model._rowDefinitions=[],n.model.vAxes.length>0)for(i=0;i<o.length;i++)u=n.model.rowDefinitions,a=u?u[i]?u[i]:u[0]:null,n.model._rowDefinitions.push({axis:this.axesIndexCount(n.model.vAxes,o.indexValue[i]),index:o.indexValue[i],rowDefinitions:a});if(c=n.model._rowDefinitions,v=this._axisFilter(c,"rowSpan"),this._SpanningAxes(c,v,!0),s=this.axesCount(n.model.hAxes),n.model._columnDefinitions=[],n.model.hAxes.length>0)for(r=0;r<s.length;r++)f=n.model.columnDefinitions,y=f?f[r]?f[r]:f[0]:null,n.model._columnDefinitions.push({axis:this.axesIndexCount(n.model.hAxes,s.indexValue[r]),index:s.indexValue[r],columnDefinitions:y});l=n.model._columnDefinitions;p=this._axisFilter(l,"columnSpan");this._SpanningAxes(l,p,!1);this._axisSize()},_SpanningAxes:function(n,t,i){for(var r,c,e,o,s,u,f=0,h=t.length;f<h;f++){if(r=t[f],r==null)break;if(c=i?r.rowSpan:r.columnSpan,e=i?r.rowIndex:r.columnIndex,n[e]!=undefined)for(o=n[e].axis.indexOf(r),s=1,u=e+1;s<c&&u<n.length;s++,u++)n[u].axis.length>=o&&n[u].axis.splice(o,0,r)}},_axisFilter:function(n,t){var i=[];return n.filter(function(n){for(var u=ej.DataManager(n.axis,ej.Query().where(t,">",1)).executeLocal(),r=0,f=u.length;r<f;r++)i.push(u[r])}),i},_axisSize:function(){for(var n,t,u,i,f,s,r=this._getLegendSpace(),e=$(this.svgObject).width()-this.model.margin.left-this.model.margin.right-this.model.elementSpacing*2-r.leftLegendWidth-r.rightLegendWidth,c=Math.floor(e/this.axesCount(this.model.hAxes).length),o=$(this.svgObject).height()-this.model.margin.top-this.model.margin.bottom-this.model.elementSpacing*2-r.topLegendHeight-r.bottomLegendHeight-r.modelTitleHeight-r.modelsubTitleHeight,l=Math.floor(o/this.axesCount(this.model.vAxes).length),h=0;h<this.model._axes.length;h++)n=this.model._axes[h],n.orientation.toLowerCase()=="horizontal"?this.model.AreaType!="polaraxes"?(t=ej.util.isNullOrUndefined(this.model.columnDefinitions)?[]:this.model.columnDefinitions[n.columnIndex],u=c,t&&(t.unit=t.unit==undefined?"percentage":t.unit,t.columnWidth=t.columnWidth==undefined?100:t.columnWidth,t.unit.toLowerCase()=="percentage"?(s=this._axisColumnDefinitionSize(this.model.columnDefinitions),u=Math.floor(c*(t.columnWidth/s))):u=t.columnWidth),n.length=n.columnSpan?n.columnSpan*u:u):n.length=e>o*2?e-o:e:n.orientation.toLowerCase()=="vertical"&&(this.model.AreaType!="polaraxes"?(i=ej.util.isNullOrUndefined(this.model.rowDefinitions)?[]:this.model.rowDefinitions[n.rowIndex],f=l,i&&(i.unit=i.unit==undefined?"percentage":i.unit,i.rowHeight=i.rowHeight==undefined?100:i.rowHeight,i.unit.toLowerCase()=="percentage"?(s=this._axisRowDefinitionSize(this.model.rowDefinitions),f=Math.floor(l*(i.rowHeight/s))):f=i.rowHeight),n.length=n.rowSpan?n.rowSpan*f:f):n.length=o/2)},_axisRowDefinitionSize:function(n){var t=0,i;if(n)for(i=0;i<n.length;i++)t=t+n[i].rowHeight;return t>100?t:100},_axisColumnDefinitionSize:function(n){var t=0,i;if(n)for(i=0;i<n.length;i++)t=t+n[i].columnWidth;return t>100?t:100},_axisMeasure:function(n,t,i,r){var u=0,o=0,e=0;n.axisLine.width=n.axisLine.width<0?0:n.axisLine.width;n.majorTickLines.size=n.visible?n.majorTickLines.size<0?0:n.majorTickLines.size:0;var s=!this.model.enable3D&&n.visible&&n.axisLine.visible&&n.axisLine.width,h=ej.EjSvgRender.utils._measureText(n.title.text,t,n.title.font),f=n.visible?this.model.elementSpacing:0;return i=="vertical"?(o=n._LableMaxWidth.width,u=n.title.text==""||!n.title.visible||!n.visible?0:document.documentMode===8?h.width:h.height+2*f):(o=n._LableMaxWidth.height,u=n.title.text==""||!n.title.visible||!n.visible?0:h.height+f),u=n.title.position.toLowerCase()=="inside"?0:u,e=this.getMultiLevelLabelSize(n),n.AxisMaxWidth=r==0&&n.tickLinesPosition=="inside"&&n.labelPosition=="inside"?u+e+s+f:r==0&&n.tickLinesPosition=="inside"&&n.labelPosition!="inside"?u+e+s+f+o:r==0&&n.tickLinesPosition!="inside"&&n.labelPosition=="inside"?u+e+s+f+n.majorTickLines.size:u+e+s+f+n.majorTickLines.size+o,n.AxisMaxWidth+=n._isScroll?18:0,n.AxisMaxWidth},_arraySum:function(n){for(var i=0,t=0;t<n.length;t++)i+=parseFloat(n[t])||0;return i},_calSpace:function(n,t,i,r){for(var c,l,e,u,o=[],s=[],a,v,f,h=0;h<t.length;h++)for(c=0,l=0,e=0;e<t[h].axis.length;e++)(u=t[h].axis[e],a=r.axes[u.name]._bounds=this._axisMeasure(u,n,i,e),v=r.axes[u.name]._validCross=this._validateCrossing(u),f=v?0:a,u._opposed=u.opposedPosition?!u._opposedPosition:u._opposedPosition||u.opposedPosiiton||!1,v&&t[h].axis[e].showNextToAxisLine)||(u.showNextToAxisLine||(f=u.labelPosition=="inside"?a-u._multiLevelLabelHeight:a),u._opposed?(s.length<=l?s.push(f):s[l]<f&&(s[l]=f),l++):(o.length<=c?o.push(f):o[c]<f&&(o[c]=f),c++));return{nearSizes:o,farSizes:s}},_getLegendSpace:function(){var h=this.model,c=h.legend,a=c.position.toLowerCase(),w=h.LegendActualBounds,b=ej.EjSvgRender.utils._measureText,n=h.title,t=n.subTitle,l=h.elementSpacing,v=h.margin,y=h.svgWidth,k=c.border.width,d=0,g=0,tt=0,it=0,rt=0,ut=0,dt=n.text.split(" "),ft=n.enableTrim,e=n.maximumWidth,e=e.toString()=="auto"||e.toString()==""?y*.75:parseInt(e),r=n.textOverflow.toLowerCase(),p=n.text,vt=n.visible,o,s,i,et=ej.EjSvgRender.utils._measureText(n.text,$(this.svgObject).width()-this.model.margin.left-this.model.margin.right,n.font),gt=t.text.split(" "),ot=t.enableTrim,u=t.maximumWidth,u=u.toString()=="auto"||u.toString()==""?y*.75:parseInt(u),f=t.textOverflow.toLowerCase(),nt=t.text,yt=t.visible,st=ej.EjSvgRender.utils._measureText(t.text,$(this.svgObject).width()-this.model.margin.left-this.model.margin.right,t.font),ht=vt&&ft&&et.width>e?!0:!1,ct=yt&&ot&&st.width>u?!0:!1,pt=r=="wrap"||r=="wrapandtrim"?!0:!1,wt=f=="wrap"||f=="wrapandtrim"?!0:!1;this.model.titleWrapTextCollection=[];this.model.subTitleWrapTextCollection=[];this.model.trimTooltip=!1;this.model.subTitleTooltip=!1;c.visible&&(g=w.Width+5+l+2*k,tt=a=="left"?g:0,it=a=="right"?g:0,c.title.text&&(d=b(c.title,null,c.title.font).height),rt=a=="top"?w.Height+d+2*k:0,ut=a=="bottom"?w.Height+d+2*k:0);ht&&r=="wrap"?(i={text:p,font:n.font},o=this._rowsCalculation(i,e,r)):ht&&r=="wrapandtrim"?(i={text:p,font:n.font},o=this._rowsCalculation(i,e,r)):(r=="wrapandtrim"||r=="wrap")&&(i={text:p,font:n.font},o=this._rowsCalculation(i,ej.EjSvgRender.utils._measureText(p,null,n.font).width,r));this.model.titleWrapTextCollection=o?o.textCollection:"";this.model.titleMaxWidth=o?o.wordMax:e;ct&&f=="wrap"?(i={text:nt,font:t.font},s=this._rowsCalculation(i,u,f)):ct&&f=="wrapandtrim"?(i={text:nt,font:t.font},s=this._rowsCalculation(i,u,f),this.model.subTitleTooltip=this.model.trimTooltip):(f=="wrapandtrim"||f=="wrap")&&(i={text:nt,font:t.font},s=this._rowsCalculation(i,u,f));this.model.subTitleWrapTextCollection=s?s.textCollection:"";this.model.subTitleMaxWidth=s?s.wordMax:u;var lt=b(n.text,y-v.left-v.right,n.font).height,at=b(t.text,y-v.left-v.right,t.font).height,bt=n.text==""||!n.visible?0:ft&&pt&&et.width>e?lt*this.model.titleWrapTextCollection.length+l:lt+l,kt=t.text==""||!t.visible||!n.visible?0:ot&&wt&&st.width>u?at*this.model.subTitleWrapTextCollection.length+l:at+l;return{leftLegendWidth:tt,rightLegendWidth:it,topLegendHeight:rt,bottomLegendHeight:ut,modelTitleHeight:bt,modelsubTitleHeight:kt}},_arraySome:function(n,t){for(var r=!1,e=this.model.zooming.enableScrollbar,o=n.length,u,f,i=0;i<o;i++)u=n[i].scrollbarSettings.enableScrollbar,f=n[i].scrollbarSettings.pointsLength,r=r||(n[i]._isScroll&&n[i].maxPointLength<f||n[i].zoomFactor<1&&u&&e)&&n[i].orientation.toLowerCase()==t;return r},_calculateAreaBounds:function(n){var t=this,c=$(this.svgObject).width()-this.model.margin.left-this.model.margin.right,o=t.model.border.width,d=this.model._axes[0],g=this.model.zooming.enableScrollbar,nt=this.model.zooming.type.toLowerCase(),u,f;t.model.scrollerSize=18;this.model._yScroll=this._arraySome(this.model._axes,"vertical");this.model._xScroll=this._arraySome(this.model._axes,"horizontal");u=this._calSpace(c,t.model._rowDefinitions,"vertical",n);t.model._rowDefinitions.nearSizes=u.nearSizes;t.model._rowDefinitions.farSizes=u.farSizes;var w=this._arraySum(u.nearSizes),b=this._arraySum(u.farSizes),r=this._getLegendSpace(),s=w+r.leftLegendWidth+t.model.margin.left+o,l=b+r.rightLegendWidth+t.model.margin.right+t.model.margin.left+2*o,a=$(this.svgObject).width(),i=a-(s+l);if(i=Math.round(i)<=0?0:i,i<=0&&this.model.AreaType=="cartesianaxes")$(this.svgObject).width(a-i+1),this._calculateAreaBounds(n);else{f=this._calSpace(c,t.model._columnDefinitions,"horizontal",n);t.model._columnDefinitions.nearSizes=f.nearSizes;t.model._columnDefinitions.farSizes=f.farSizes;var v=this._arraySum(f.nearSizes),y=this._arraySum(f.farSizes),k=v||y?this.model.elementSpacing:0,h=y+this.model.margin.top+k+r.modelTitleHeight+r.modelsubTitleHeight+r.topLegendHeight+o,p=v+this.model.margin.bottom+r.bottomLegendHeight+2*o,e=Math.abs($(this.svgObject).height()-(h+p));e=e==0?1:e;this.model.m_AreaBounds={X:s,Y:h,Width:i,Height:e};this.model.m_Spacing={Left:s,Top:h,Right:l,Bottom:p};this.model.enableCanvasRendering?(this.canvasX=s,this.canvasY=h,this.canvasWidth=i,this.canvasHeight=e):this.canvasX=this.canvasY=this.canvasHeight=this.canvasWidth=0}}};jQuery.uaMatch=function(n){n=n.toLowerCase();var t=/(chrome)[ \/]([\w.]+)/.exec(n)||/(webkit)[ \/]([\w.]+)/.exec(n)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(n)||/(msie) ([\w.]+)/.exec(n)||n.indexOf("compatible")<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(n)||[];return{browser:t[1]||"",version:t[2]||"0"}}}(jQuery);ej.EjSvgScrollbarRender=function(n,t){var i,r;this.svgSupport=window.SVGSVGElement?!0:!1;i=jQuery(n).attr("id");this.scrollsvgObj=this.scrollsvgObj?this.scrollsvgObj:[];this.svgSupport?(this.svgLink="http://www.w3.org/2000/svg",this.scrollsvgObj[t.index]=document.createElementNS(this.svgLink,"svg"),this.scrollsvgObj[t.index].setAttribute("id","scrollbar_"+i+t.index)):(r=document,this.scrollsvgObj[t.index]=r.createElement("div"),this.scrollsvgObj[t.index].style.position="relative",this.scrollsvgObj[t.index].setAttribute("id","scrollbar_"+i+t.index))},function(n){ej.EjSvgScrollbarRender.prototype={_initializeScrollbarVariables:function(n){n.offsetLeftX=0;n.rectWidth=n.offsetRightX=n.oldWidth=n.width;n.startX=0;n.endX=0;n.scrollbarLoaded=!1;(n.zoomPosition||n.zoomFactor)&&(n.offsetLeftX=n.zoomPosition*n.width,n.rectWidth=n.zoomFactor*n.width)},_scrollbarUpdate:function(n){var o=parseFloat(n.width),t=15,u=44,e=o-30,f;n.offsetLeftX=n.scrollbarLoaded?n.offsetLeftX-t:n.offsetLeftX;n.offsetLeftX=n.offsetLeftX<t?0:n.offsetLeftX;var r=n.offsetLeftX/n.oldWidth*e+t,i=n.rectWidth/n.oldWidth*e,s=i<u;n._diff=s?u-i:0;i=i>u?i:u;n.oldWidth=e;f=r+i;n.rectWidth=i;n.offsetLeftX=n.startX=r;n.offsetRightX=f-t<=r?f+t:f;n.endX=n.width-n.offsetRightX;n.startX=r<t?t:r;r+i>n.width-t&&(n.offsetLeftX=n.startX=n.width-t-i,n.offsetRightX=n.width-t,n.endX=n.width-n.offsetRightX);n.scrollbarLoaded=!0},_renderScrollbar:function(t){var o,w,b,k,d,g,nt,tt,it,rt,ut,ft,et,v;this.scrollsvgObj=this.scrollsvgObj?this.scrollsvgObj:[];n(this.scrollsvgObj[t.index]).empty();this.scrollsvgObj[t.index]&&n(document).find("[id*= "+this.scrollsvgObj[t.index].id+"]").attr("height","0px");var i=this._id,e=15,s=18,c=44;this.scrollsvgObj[t.index]=this.scrollbarContainer.scrollsvgObj[t.index];var l=17,f=parseFloat(t.width),y=8,p=l/2,h=f-e*2;t.offsetLeftX=t.scrollbarLoaded?t.offsetLeftX-e:t.offsetLeftX;t.offsetLeftX=t.offsetLeftX<e?0:t.offsetLeftX;var u=t.offsetLeftX/t.oldWidth*h+e,r=t.rectWidth/t.oldWidth*h,ot=r<c;t._diff=ot?c-r:0;r=r>c?r:c;t.oldWidth=h;u=u+r>h?h-(r-e):u;o=u+r;t.rectWidth=r;t.offsetLeftX=t.startX=u;t.offsetRightX=u+r;t.endX=t.width-t.offsetRightX;t.scrollbarLoaded=!0;o=o-e<=u?o+e:o;w=this.padding||0;b=this.vmlRendering?-5:0;this.scrollbar=t.orientation=="horizontal"?this.renderer.createGroup({id:i+"_scrollbar_"+t.index,transform:"translate("+w+","+b+")"}):this.renderer.createGroup({id:i+"_scrollbar_"+t.index,transform:"translate(0,"+t.width+") rotate(270)"});var st=function(n,t,i,r,u,f){var e=" ",c="M",h="h",o="v",s="a",l="z",a=f.orientation,v=f.opposed;return a=="vertical"&&!v||v&&a!="vertical"?c+e+n+e+u+e+o+e+(r-u)+e+h+e+i+e+o+e+(u-r)+e+s+e+u+e+u+e+0+e+0+e+0+e+-u+e+-u+e+h+e+-(i-2*u)+e+s+e+u+e+u+e+0+e+0+e+0+e+-4+e+u+e+l:c+e+n+e+t+e+o+e+(r-u)+e+s+e+u+e+u+e+0+e+0+e+0+e+u+e+u+e+h+e+(i-2*u)+e+s+e+u+e+u+e+0+e+0+e+0+e+u+e+-u+e+o+e+(u-r)+e+l},ht=st(0,0,f,s,4,t),a={id:i+"_scrollbarBackRect_"+t.index,"stroke-width":1,height:s,width:f,"stroke-linejoin":"round",stroke:"#B4B4B4",fill:"#F7F7F7","class":"e-rangeScroll-backRect"};this.vmlRendering?this.renderer.drawRect(a,this.scrollbar):(a.d=ht,this.renderer.drawPath(a,this.scrollbar));k={id:i+"_scrollbarRightRect_"+t.index,"stroke-width":1,x:f-5,height:s,width:5,"stroke-linejoin":"round",stroke:"transparent",fill:"transparent"};this.renderer.drawRect(k,this.scrollbar);d={id:i+"_scrollbarLeftRect_"+t.index,"stroke-width":1,x:0,height:s,width:5,"stroke-linejoin":"round",stroke:"transparent",fill:"transparent"};this.renderer.drawRect(d,this.scrollbar);g={id:i+"_scrollbarLeftArrow_"+t.index,"stroke-width":1,stroke:"#999999",d:"M 5 9 L 10 14 L 10 "+3.5+" Z",fill:"#999999","class":"e-rangeScroll-arrow"};this.renderer.drawPath(g,this.scrollbar);nt={id:i+"_scrollbarRightArrow_"+t.index,"stroke-width":1,stroke:"#999999",d:"M "+(f-5)+" 9 L "+(f-10)+" 14 L "+(f-10)+" "+3.5+" Z",fill:"#999999","class":"e-rangeScroll-arrow"};this.renderer.drawPath(nt,this.scrollbar);tt={id:i+"_scrollbarSelect_"+t.index,x:u,y:0,width:r,rx:4,ry:4,height:l,stroke:"#999999","stroke-width":1,fill:"#CECECE","class":"e-rangeScroll-select"};this.renderer.drawRect(tt,this.scrollbar);this.centerLine=this.renderer.createGroup({id:i+"_scrollbarCenterLine_"+t.index,transform:"translate("+(u+r/2-7.5)+")"});it={id:i+"_scrollbarCenterShape_"+t.index,"stroke-width":1,stroke:"#999999",d:"M 0 "+3.5+" L 0 "+13.5+" ZM 5 "+3.5+" L 5 "+13.5+" ZM 10 "+3.5+" L 10 "+13.5+" ZM 15 "+3.5+" L 15 "+13.5+" Z",fill:"#999999","class":"e-rangeScroll-centerShape"};this.renderer.drawPath(it,this.centerLine);this.renderer.append(this.centerLine,this.scrollbar);rt={id:i+"_leftHeaderHideRect_"+t.index,x:u,y:0,width:11,height:17,fill:"transparent",opacity:0,"stroke-width":1,"class":"e-rangeScroll-leftRect"};this.renderer.drawRect(rt,this.scrollbar);ut={id:i+"_scrollbarLeftHeader_"+t.index,cx:u+y,cy:p,r:3,fill:"#999999",stroke:"#999999","stroke-width":1,"class":"e-rangeScroll-leftCircle"};this.renderer.drawCircle(ut,this.scrollbar);ft={id:i+"_rightHeaderHideRect_"+t.index,x:o-11,y:0,width:11,height:l,fill:"transparent",opacity:0,"stroke-width":1,"class":"e-rangeScroll-rightRect"};this.renderer.drawRect(ft,this.scrollbar);et={id:i+"_scrollbarRightHeader_"+t.index,fill:"#999999",cx:o-y,cy:p,r:3,stroke:"#999999","stroke-width":1,"class":"e-rangeScroll-rightCircle"};this.renderer.drawCircle(et,this.scrollbar);this.renderer.append(this.scrollbar,this.scrollsvgObj[t.index]);t.orientation=="horizontal"?(this.scrollsvgObj[t.index].setAttribute("height",s),this.scrollsvgObj[t.index].setAttribute("width",f)):(this.scrollsvgObj[t.index].setAttribute("height",f),this.scrollsvgObj[t.index].setAttribute("width",s));this.renderer.append(this.scrollsvgObj[t.index],t.parent);v=this.vmlRendering?t.y+5:t.y;this.pluginName=="ejRangeNavigator"?this.scrollsvgObj[t.index].setAttribute("style","overflow:visible;position:relative;display:block; top:"+(v-t.y)+"px;left:"+t.x+"px"):this.scrollsvgObj[t.index].setAttribute("style","overflow:visible;position:absolute;display:block; top:"+v+"px;left:"+t.x+"px");n("#"+i+"_scrollbarSelect_"+t.index).css({cursor:"pointer"});t.enableResize?(n("#"+i+"_leftHeaderHideRect_"+t.index).css({cursor:t.orientation=="horizontal"?"w-resize":"n-resize"}),n("#"+i+"_rightHeaderHideRect_"+t.index).css({cursor:t.orientation=="horizontal"?"w-resize":"n-resize"}),n("#"+i+"_scrollbarRightHeader_"+t.index).css({cursor:t.orientation=="horizontal"?"w-resize":"n-resize"}),n("#"+i+"_scrollbarLeftHeader_"+t.index).css({cursor:t.orientation=="horizontal"?"w-resize":"n-resize"})):(n("#"+i+"_leftHeaderHideRect_"+t.index).hide(),n("#"+i+"_rightHeaderHideRect_"+t.index).hide(),n("#"+i+"_scrollbarLeftHeader_"+t.index).hide(),n("#"+i+"_scrollbarRightHeader_"+t.index).hide());this.vmlRendering&&(n("#"+i+"_leftHeaderHideRect_"+t.index).css("visibility","hidden"),n("#"+i+"_rightHeaderHideRect_"+t.index).css("visibility","hidden"));this.scrollbarContainer._bindScrollEvents.call(this,t)},_bindScrollEvents:function(t){function e(t){this._on(n("#"+i+"_scrollbarLeftHeader_"+t.index),"mousedown",this.scrollbarContainer._leftScrollbarDown);this._on(n("#"+i+"_scrollbarRightHeader_"+t.index),"mousedown",this.scrollbarContainer._rightScrollbarDown);this._on(n("#"+i+"_leftHeaderHideRect_"+t.index),"mousedown",this.scrollbarContainer._leftScrollbarDown);this._on(n("#"+i+"_rightHeaderHideRect_"+t.index),"mousedown",this.scrollbarContainer._rightScrollbarDown);this._on(n("#"+i+"_scrollbarLeftArrow_"+t.index),"mousedown",this.scrollbarContainer._leftArrowDown);this._on(n("#"+i+"_scrollbarLeftArrow_"+t.index),"mouseup",this.scrollbarContainer._leftArrowUp);this._on(n("#"+i+"_scrollbarRightArrow_"+t.index),"mousedown",this.scrollbarContainer._rightArrowDown);this._on(n("#"+i+"_scrollbarRightArrow_"+t.index),"mouseup",this.scrollbarContainer._rightArrowUp);this._on(n("#"+i+"_scrollbarSelect_"+t.index),"mousedown",this.scrollbarContainer._scrollSelectRectDown);this._on(n("#"+i+"_scrollbarBackRect_"+t.index),"mousedown",this.scrollbarContainer._scrollBackRectDown);this._on(n("#"+i+"_scrollbarBackRect_"+t.index),"mouseup",this.scrollbarContainer._scrollBackRectUp);this._on(n(window),"mousemove",this.scrollbarContainer._scrollbarMove);this._on(n(window),"mouseup",this.scrollbarContainer._scrollbarUp);this._on(n(this.svgObject),"mousemove",this.scrollbarContainer._scrollbarMove);this._on(n(this.scrollsvgObj[t.index]),"mousemove",this.scrollbarContainer._scrollbarMove);this._on(n(this.scrollsvgObj[t.index]),"mouseup",this.scrollbarContainer._scrollbarUp)}function o(t){this._on(n("#"+i+"_scrollbarLeftHeader_"+t.index),"touchstart",this.scrollbarContainer._leftScrollbarDown);this._on(n("#"+i+"_scrollbarRightHeader_"+t.index),"touchstart",this.scrollbarContainer._rightScrollbarDown);this._on(n("#"+i+"_leftHeaderHideRect_"+t.index),"touchstart",this.scrollbarContainer._leftScrollbarDown);this._on(n("#"+i+"_rightHeaderHideRect_"+t.index),"touchstart",this.scrollbarContainer._rightScrollbarDown);this._on(n("#"+i+"_scrollbarLeftArrow_"+t.index),"touchstart",this.scrollbarContainer._leftArrowDown);this._on(n("#"+i+"_scrollbarLeftArrow_"+t.index),"touchend",this.scrollbarContainer._leftArrowUp);this._on(n("#"+i+"_scrollbarRightArrow_"+t.index),"touchstart",this.scrollbarContainer._rightArrowDown);this._on(n("#"+i+"_scrollbarRightArrow_"+t.index),"touchend",this.scrollbarContainer._rightArrowUp);this._on(n("#"+i+"_scrollbarSelect_"+t.index),"touchstart",this.scrollbarContainer._scrollSelectRectDown);this._on(n("#"+i+"_scrollbarBackRect_"+t.index),"touchstart",this.scrollbarContainer._scrollBackRectDown);this._on(n("#"+i+"_scrollbarBackRect_"+t.index),"touchend",this.scrollbarContainer._scrollBackRectUp);this._on(n(window),"touchmove",this.scrollbarContainer._scrollbarMove);this._on(n(window),"touchend",this.scrollbarContainer._scrollbarUp);this._on(n(this.scrollsvgObj[t.index]),"touchmove",this.scrollbarContainer._scrollbarMove);this._on(n(this.scrollsvgObj[t.index]),"touchend",this.scrollbarContainer._scrollbarUp)}var i=this._id,u=jQuery.uaMatch(navigator.userAgent),r=!!navigator.userAgent.match(/Trident\/7\./),f;if(e.call(this,t),window.PointerEvent)this._on(n("#"+i+"_scrollbarLeftHeader_"+t.index),"pointerdown",this.scrollbarContainer._leftScrollbarDown),this._on(n("#"+i+"_scrollbarRightHeader_"+t.index),"pointerdown",this.scrollbarContainer._rightScrollbarDown),this._on(n("#"+i+"_leftHeaderHideRect_"+t.index),"pointerdown",this.scrollbarContainer._leftScrollbarDown),this._on(n("#"+i+"_rightHeaderHideRect_"+t.index),"pointerdown",this.scrollbarContainer._rightScrollbarDown),this._on(n("#"+i+"_scrollbarLeftArrow_"+t.index),"pointerdown",this.scrollbarContainer._leftArrowDown),this._on(n("#"+i+"_scrollbarLeftArrow_"+t.index),"pointerup",this.scrollbarContainer._leftArrowUp),this._on(n("#"+i+"_scrollbarRightArrow_"+t.index),"pointerdown",this.scrollbarContainer._rightArrowDown),this._on(n("#"+i+"_scrollbarRightArrow_"+t.index),"pointerup",this.scrollbarContainer._rightArrowUp),this._on(n("#"+i+"_scrollbarSelect_"+t.index),"pointerdown",this.scrollbarContainer._scrollSelectRectDown),this._on(n("#"+i+"_scrollbarBackRect_"+t.index),"pointerdown",this.scrollbarContainer._scrollBackRectDown),this._on(n("#"+i+"_scrollbarBackRect_"+t.index),"pointerup",this.scrollbarContainer._scrollBackRectUp),this._on(n(window),"pointermove",this.scrollbarContainer._scrollbarMove),this._on(n(window),"pointerup",this.scrollbarContainer._scrollbarUp),this._on(n(this.scrollsvgObj[t.index]),"pointermove",this.scrollbarContainer._scrollbarMove),this._on(n(this.scrollsvgObj[t.index]),"pointerup",this.scrollbarContainer._scrollbarUp),n(this.scrollsvgObj[t.index]).css("touch-action","none");else if(window.navigator.msPointerEnabled&&!r)this._on(n("#"+i+"_scrollbarLeftHeader_"+t.index),"MSPointerDown",this.scrollbarContainer._leftScrollbarDown),this._on(n("#"+i+"_scrollbarRightHeader_"+t.index),"MSPointerDown",this.scrollbarContainer._rightScrollbarDown),this._on(n("#"+i+"_leftHeaderHideRect_"+t.index),"MSPointerDown",this.scrollbarContainer._leftScrollbarDown),this._on(n("#"+i+"_rightHeaderHideRect_"+t.index),"MSPointerDown",this.scrollbarContainer._rightScrollbarDown),this._on(n("#"+i+"_scrollbarLeftArrow_"+t.index),"MSPointerDown",this.scrollbarContainer._leftArrowDown),this._on(n("#"+i+"_scrollbarLeftArrow_"+t.index),"MSPointerUp",this.scrollbarContainer._leftArrowUp),this._on(n("#"+i+"_scrollbarRightArrow_"+t.index),"MSPointerDown",this.scrollbarContainer._rightArrowDown),this._on(n("#"+i+"_scrollbarRightArrow_"+t.index),"MSPointerUp",this.scrollbarContainer._rightArrowUp),this._on(n("#"+i+"_scrollbarSelect_"+t.index),"MSPointerDown",this.scrollbarContainer._scrollSelectRectDown),this._on(n("#"+i+"_scrollbarBackRect_"+t.index),"MSPointerDown",this.scrollbarContainer._scrollBackRectDown),this._on(n("#"+i+"_scrollbarBackRect_"+t.index),"MSPointerUp",this.scrollbarContainer._scrollBackRectUp),this._on(n(window),"MSPointerMove",this.scrollbarContainer._scrollbarMove),this._on(n(window),"MSPointerUp",this.scrollbarContainer._scrollbarUp),this._on(n(this.scrollsvgObj[t.index]),"MSPointerMove",this.scrollbarContainer._scrollbarMove),this._on(n(this.scrollsvgObj[t.index]),"MSPointerUp",this.scrollbarContainer._scrollbarUp),n(this.scrollsvgObj[t.index]).css("-ms-touch-action","none");else if(u.browser.toLowerCase()=="chrome")o.call(this,t);else if(this.isDevice()){var s=navigator.userAgent.indexOf("Safari")!=-1&&navigator.userAgent.indexOf("Chrome")==-1,h=window.location!=window.parent.location?!0:!1,c=h?window.parent.navigator.userAgent.toLowerCase():window.navigator.userAgent.toLowerCase(),l=/mobile|tablet|android|kindle/i.test(c);ej.isMobile()&&this.isWindows()||!l&&ej.isMobile()&&s?(e.call(this),n(this.scrollsvgObj[t.index]).css("-ms-touch-action","none")):o.call(this,t)}f=u.browser.toLowerCase()=="mozilla"?r?"mousewheel":"DOMMouseScroll":"mousewheel";this._on(n(this.scrollsvgObj[t.index]),f,this.scrollbarContainer._scrollMouseWheel);r&&n(this.scrollsvgObj[t.index]).css("touch-action","none")},_setScrollPosition:function(t,i,r){var f=8,u=this._id,e=t+r.rectWidth/2-7.5;n("#"+u+"_scrollbarLeftHeader_"+r.index).attr("cx",t+f);n("#"+u+"_leftHeaderHideRect_"+r.index).attr("x",t);n("#"+u+"_scrollbarRightHeader_"+r.index).attr("cx",i-f);n("#"+u+"_rightHeaderHideRect_"+r.index).attr("x",i-5);n("#"+u+"_scrollbarSelect_"+r.index).attr("x",t);n("#"+u+"_scrollbarSelect_"+r.index).attr("width",r.rectWidth);n("#"+u+"_scrollbarCenterLine_"+r.index).attr("transform","translate("+e+")");this.pluginName=="ejRangeNavigator"&&(n("#"+u+"_scrollbarLeftHeader_"+r.index).css("left",t),n("#"+u+"_leftHeaderHideRect_"+r.index).css("left",t),n("#"+u+"_scrollbarRightHeader_"+r.index).css("left",i-f),n("#"+u+"_rightHeaderHideRect_"+r.index).css("left",i-5),n("#"+u+"_scrollbarSelect_"+r.index).css("left",t),n("#"+u+"_scrollbarCenterLine_"+r.index).css("left",e))},_calculateScrollLeftMove:function(n,t){t._startX-n>15?(t.startX=t._startX-n,t.offsetLeftX=t.startX,t._offsetRightX=t.startX+t.rectWidth,t.offsetRightX=t._offsetRightX,t.endX=t.width-t.offsetRightX):(t.startX=15,t._offsetLeftX=t.offsetLeftX,t.offsetLeftX=t.startX,t._offsetRightX=t.startX+t.rectWidth,t.offsetRightX=t._offsetRightX,t.endX=t.width-t.offsetRightX)},_calculateScrollRightMove:function(n,t){t&&t._offsetRightX+Math.abs(n)<t.width-15?(t._startX=t.startX+Math.abs(n),t.offsetLeftX=t._startX,t.offsetRightX=t._offsetRightX+Math.abs(n),t.endX=t.width-t.offsetRightX):(t._ofsetRightX=t.offsetRightX,t.offsetRightX=t.width-15,t._startX=t.offsetRightX-t.rectWidth,t.offsetLeftX=t._startX,t.endX=t.width-t.offsetRightX)},_calculateRange:function(t,i,r){var o,s,e,u,f,a=30,h,c,l;return o=(t-15)/(r.width-a-r._diff),e=r.scrollRange,s=(r.rectWidth-r._diff)/(r.width-a-r._diff),r.isRTL?(f=e.max-o*e.delta,u=f-s*e.delta):(u=e.min+o*e.delta,f=u+s*e.delta),r.valueType=="datetime"?(h=r.startDateTime,c=r.endDateTime,r.startDateTime=this.startDateTime=u=new Date(u),r.endDateTime=this.endDateTime=f=new Date(f)):(h=parseInt(r.startValue),c=parseInt(r.endValue),r.startValue=this.startValue=u=Math.ceil(u),r.endValue=this.endValue=f=Math.ceil(f)),r._scrollChanged=!0,l=n.extend({},ej.EjSvgRender.commonChartEventArgs),l.data={zoomPosition:o,zoomFactor:s,oldRange:{start:h,end:c},newRange:{start:u,end:f}},r.zoomPosition=o,r.zoomFactor=s,l},_calculateScrollPosition:function(t,i){var s,h,f,r,u,e,o,y=30,a=15,c,p,w=36,l,v;if(this.leftScrollbarClicked&&i.enableResize)return t=t>=a?t:a,t=t>=a&&t<i.offsetRightX-a?t:i.offsetRightX-a,s=(t-w)/(i.width-y),h=i.rectWidth/(i.width-y),c=i.valueType.toLowerCase(),f=i.scrollRange,i.isRTL?(u=f.max-s*f.delta,u=u<f.max?u:f.max,c=="datetime"?(e=i.startDateTime,o=i.endDateTime,i.endDateTime=this.endDateTime=u=new Date(u),r=i.startDateTime):(e=parseInt(i.startValue),o=parseInt(i.endValue),i.endValue=this.endValue=u=Math.ceil(u),r=Math.ceil(i.startValue))):(r=f.min+s*f.delta,r=r>f.min?r:f.min,c=="datetime"?(e=i.startDateTime,o=i.endDateTime,i.startDateTime=this.startDateTime=r=new Date(r),u=i.endDateTime):(e=parseInt(i.startValue),o=parseInt(i.endValue),i.startValue=this.startValue=r=Math.ceil(r),u=Math.ceil(i.endValue))),l=n.extend({},ej.EjSvgRender.commonChartEventArgs),l.data={zoomPosition:s,zoomFactor:h,oldRange:{start:e,end:o},newRange:{start:r,end:u}},i._scrollChanged=!0,i.zoomPosition=s,i.zoomFactor=h,l;if(this.rightScrollbarClicked&&i.enableResize)return f=i.scrollRange,h=i.rectWidth/(i.width-y),s=i.zoomPosition,c=i.valueType.toLowerCase(),i.isRTL?(s=(t-w)/(i.width-y),r=f.max-s*f.delta,c=="datetime"?(e=i.startDateTime,o=i.endDateTime,i.startDateTime=this.startDateTime=r=new Date(r),u=i.endDateTime):(e=parseInt(i.startValue),o=parseInt(i.endValue),i.startValue=this.startValue=r=Math.floor(r),u=Math.ceil(i.endValue))):(p=f.min+s*f.delta,u=p+h*f.delta,c=="datetime"?(e=i.startDateTime,o=i.endDateTime,i.endDateTime=this.endDateTime=u=new Date(u),r=i.startDateTime):(e=parseInt(i.startValue),o=parseInt(i.endValue),i.endValue=this.endValue=u=Math.floor(u),r=Math.ceil(i.startValue))),l=n.extend({},ej.EjSvgRender.commonChartEventArgs),l.data={zoomPosition:i.zoomPosition?i.zoomPosition:0,zoomFactor:h,oldRange:{start:e,end:o},newRange:{start:r,end:u}},i._scrollChanged=!0,i.zoomFactor=h,l;if(i&&this.scrollRectClicked){if(v=this.mouseDownPos-t,v>0&&i.offsetLeftX>=0)return this.scrollbarContainer._calculateScrollLeftMove.call(this,v,i),this.scrollbarContainer._calculateRange.call(this,i.startX,i.offsetRightX,i);if(v<0)return this.scrollbarContainer._calculateScrollRightMove.call(this,v,i),this.scrollbarContainer._calculateRange.call(this,i._startX,i.offsetRightX,i)}},_scrollbarMove:function(t){var u,s;if(this.moveClientX=ej.isNullOrUndefined(t.clientX)?t.originalEvent.clientX==null?t.originalEvent.touches[0].clientX:t.originalEvent.clientX:t.clientX,this.moveClientX!=this.downClientX){var f=8,o=34,r,e,w=this.model.padding||0,b=jQuery.uaMatch(navigator.userAgent),i=this.scrollbarContainer._doScrollIndex.call(this,t);if(!i)return 0;if(this.lastIndex=i.index,r=!this.vmlRendering&&t.originalEvent.toString()!=="[object TouchEvent]"&&b.browser.toLowerCase()!="msie"||this.vmlRendering?(i.orientation=="horizontal"?this.calMousePosition(t).X-i.x:i.width-(this.calMousePosition(t).Y-i.y))-w:(i.orientation=="horizontal"?this.calTouchPosition(t).X-i.x:i.width-(this.calTouchPosition(t).Y-i.y))-w,this.mouseX=r,u=this._id,this.leftScrollbarClicked&&i.enableResize&&(i&&(r>o||r>23)&&r<i.offsetRightX-o?(i.rectWidth=i.width-(i.endX+r-f),e=r-f+i.rectWidth/2-7.5,n("#"+u+"_scrollbarLeftHeader_"+i.index).attr("cx",r),n("#"+u+"_leftHeaderHideRect_"+i.index).attr("x",r-7.5),n("#"+u+"_scrollbarSelect_"+i.index).attr("x",r-f),n("#"+u+"_scrollbarSelect_"+i.index).attr("width",i.rectWidth),n("#"+u+"_scrollbarCenterLine_"+i.index).attr("transform","translate("+e+")"),this.pluginName=="ejRangeNavigator"&&(n("#"+u+"_scrollbarLeftHeader_"+i.index).css("left",r),n("#"+u+"_leftHeaderHideRect_"+i.index).css("left",r-7.5),n("#"+u+"_scrollbarSelect_"+i.index).css("left",r),n("#"+u+"_scrollbarSelect_"+i.index).css("width",i.rectWidth),n("#"+u+"_scrollbarCenterLine_"+i.index).css("left",e)),i.offsetLeftX=i.startX=r-8,this.scrollbarContainer._scrollStartArgs.call(this,i),this.scrollbarContainer._scrollChangeArgs.call(this,i),i._diff=0):r>i.offsetRightX-o&&(this.rectWidth=42.899841017488143)),this.rightScrollbarClicked&&i.enableResize&&i&&(r<=i.width-o||r<=i.width-23)&&r>i.offsetLeftX+o&&(i.rectWidth=r-i.offsetLeftX+f,e=i.offsetLeftX+i.rectWidth/2-7.5,n("#"+u+"_scrollbarRightHeader_"+i.index).attr("cx",r),n("#"+u+"_rightHeaderHideRect_"+i.index).attr("x",r-2.5),n("#"+u+"_scrollbarSelect_"+i.index).attr("width",i.rectWidth),n("#"+u+"_scrollbarCenterLine_"+i.index).attr("transform","translate("+e+")"),this.pluginName=="ejRangeNavigator"&&(n("#"+u+"_scrollbarRightHeader_"+i.index).css("left",r),n("#"+u+"_rightHeaderHideRect_"+i.index).css("left",r-2.5),n("#"+u+"_scrollbarSelect_"+i.index).css("width",i.rectWidth),n("#"+u+"_scrollbarCenterLine_"+i.index).css("left",e)),i.offsetRightX=r+f,i.endX=i.width-r-f,this.scrollbarContainer._scrollStartArgs.call(this,i),this.scrollbarContainer._scrollChangeArgs.call(this,i),i._diff=0),this.scrollRectClicked&&(s=this.mouseDownPos-r,i._startX=ej.isNullOrUndefined(i._startX)?i.startX:i._startX,i&&s>0&&i.offsetLeftX>=0&&(this.scrollbarContainer._calculateScrollLeftMove.call(this,s,i),this.scrollbarContainer._setScrollPosition.call(this,i.startX,i.offsetRightX,i),(i.offsetLeftX>15||i.offsetLeftX!=i._offsetLeftX)&&(this.scrollbarContainer._scrollStartArgs.call(this,i),this.scrollbarContainer._scrollChangeArgs.call(this,i))),i&&s<0&&(ej.isNullOrUndefined(i._offsetRightX)&&(this.scrollbarContainer._scrollSelectRectDown.call(this,t),this.scrollbarContainer._scrollbarMove.call(this,t)),this.scrollbarContainer._calculateScrollRightMove.call(this,s,i),this.scrollbarContainer._setScrollPosition.call(this,i._startX,i._startX+i.rectWidth,i),(i.offsetRightX<i.width-15||i.offsetRightX!=i._ofsetRightX)&&(this.scrollbarContainer._scrollStartArgs.call(this,i),this.model.enableDeferredUpdate===!1||i.isZooming||this.model.scrollChanged!="")))){var h=this.scrollbarContainer._calculateRange.call(this,i._startX,i._startX+i.rectWidth,i),c=h.data.oldRange,l=h.data.newRange,a,v,y,p;i.valueType.toLowerCase()=="datetime"?(a=Date.parse(c.start),y=Date.parse(l.start),v=Date.parse(c.end),p=Date.parse(l.end)):(a=c.start,y=l.start,v=c.end,p=l.end);this.model.scrollChanged!=""&&(a!=y||v!=p)&&(h=this.scrollbarContainer._args.call(this,i,h),this._trigger("scrollChanged",h));this.model.enableDeferredUpdate||(this.scrollUpdate?this.scrollUpdate=!1:this.scrollbarContainer._appendScrollRange.call(this,i))}}this.offsetX=r},_scrollbarUp:function(t){var i=this.scrollbarContainer._doScrollIndex.call(this,t),r,s,u,f,h,c,e,o,l;n("[id^="+this._id+"_scrollbarSelect_]").attr("class","e-rangeScroll-select");this.lastIndex=null;r=this.scrollbarContainer._calculateScrollPosition.call(this,this.mouseX,i);s=this.model.enableDeferredUpdate;r&&(u=r.data.oldRange,f=r.data.newRange,i.valueType.toLowerCase()=="datetime"?(h=Date.parse(u.start),e=Date.parse(f.start),c=Date.parse(u.end),o=Date.parse(f.end)):(h=u.start,e=f.start,c=u.end,o=f.end),(h!=e||c!=o||this.scrollRectClicked&&!s||s||this.leftScrollbarClicked||this.rightScrollbarClicked)&&(l=navigator.userAgent.toLowerCase().indexOf("chrome")>-1&&navigator.vendor.toLowerCase().indexOf("google")>-1,(!l||l&&(this.leftScrollbarClicked||this.rightScrollbarClicked)&&this.downClientX!=this.moveClientX||this.scrollRectClicked||this.leftArrowClicked||this.rightArrowClicked)&&(!this.leftScrollbarClicked&&!this.rightScrollbarClicked||(this.leftScrollbarClicked||this.rightScrollbarClicked)&&Math.ceil(i.rectWidth)!=Math.ceil(this.rectOldWidth)&&(Math.abs(i.rectWidth-i.rectOldWidth)>4||!i.rectOldWidth))&&(ej.isNullOrUndefined(i._previousStart)||i._previousStart!=e||i._previousEnd!=o)&&(r=this.scrollbarContainer._args.call(this,i,r),this._trigger("scrollEnd",r),i._scrollStarted=!1,i._previousStart=e,i._previousEnd=o,i.rectOldWidth=i.rectWidth,this.scrollUpdate?this.scrollUpdate=!1:this.scrollbarContainer._appendScrollRange.call(this,i))),i.release=!0,i.clicked=!1);this._scrollEnd=!1;this.leftScrollbarClicked=!1;this.rightScrollbarClicked=!1;this.scrollRectClicked=!1;this.leftArrowClicked=!1;this.rightArrowClicked=!1;this.scrollbarBackRectClicked=!1},_leftScrollbarDown:function(n){n.preventDefault();this.leftScrollbarClicked=!0;this.downClientX=ej.isNullOrUndefined(n.clientX)?n.originalEvent.touches[0].clientX:n.clientX},_rightScrollbarDown:function(n){n.preventDefault();this.rightScrollbarClicked=!0;this.downClientX=ej.isNullOrUndefined(n.clientX)?n.originalEvent.touches[0].clientX:n.clientX},_scrollSelectRectDown:function(t){var i=this.scrollbarContainer._doScrollIndex.call(this,t),u;n("#"+this._id+"_scrollbarSelect_"+i.index).attr("class","e-rangeScroll-select e-rangeScroll-select-hover");t.preventDefault();var f=jQuery.uaMatch(navigator.userAgent),r=this.model.padding||0,i=this.scrollbarContainer._doScrollIndex.call(this,t);u=!this.vmlRendering&&t.originalEvent.toString()!=="[object TouchEvent]"&&f.browser.toLowerCase()!="msie"||this.vmlRendering?(i.orientation=="horizontal"?this.calMousePosition(t).X-i.x:i.width-(this.calMousePosition(t).Y-i.y))-r:(i.orientation=="horizontal"?this.calTouchPosition(t).X-i.x:i.width-(this.calTouchPosition(t).Y-i.y))-r;this.mouseDownPos=u;i._startX=i.startX=i.offsetLeftX;i._offsetRightX=i.offsetRightX;i.clicked=!0;i.release=!1;this.scrollRectClicked=!0},_scrollMouseWheel:function(n){n.preventDefault();var t=this.scrollbarContainer._doScrollIndex.call(this,n),r=!!navigator.userAgent.match(/Trident\/7\./),i=n.originalEvent.wheelDelta,u=jQuery.uaMatch(navigator.userAgent),f=u.browser.toLowerCase()=="mozilla"?r?i/120>0?1:-1:-n.originalEvent.detail/3>0?1:-1:i/120>0?1:-1,e=Math.max(1/ej.EjSvgRender.utils._minMax(t.zoomFactor,0,1),1),o=Math.max(e+.25*f,1);this.scrollbarContainer.doMouseWheelZoom.call(this,o,.5,t)},_scrollStartArgs:function(t){if(t._scrollStarted=!0,this.model.scrollStart!=""&&!this._scrollEnd){var i=n.extend({},ej.EjSvgRender.commonChartEventArgs);i.data=t.isZooming?{axis:this.model._axes[t.index],currentRange:this.model._axes[t.index].visibleRange}:{startRange:t.valueType=="datetime"?t.startDateTime:t.startValue,endRange:t.valueType=="datetime"?t.endDateTime:t.endValue};this._trigger("scrollStart",i);this._scrollEnd=!0}},_scrollChangeArgs:function(n){if(this.model.enableDeferredUpdate===!1||n.isZooming||this.model.scrollChanged!=""){var t=this.scrollbarContainer._calculateRange.call(this,n.offsetLeftX,n.offsetRightX,n),i=t.data.oldRange,r=t.data.newRange,u,f,e,o;n.valueType.toLowerCase()=="datetime"?(u=Date.parse(i.start),e=Date.parse(r.start),f=Date.parse(i.end),o=Date.parse(r.end)):(u=i.start,e=r.start,f=i.end,o=r.end);this.model.scrollChanged!=""&&(u!=e||f!=o)&&(t=this.scrollbarContainer._args.call(this,n,t),this._trigger("scrollChanged",t));this.model.enableDeferredUpdate||(this.scrollUpdate?this.scrollUpdate=!1:this.scrollbarContainer._appendScrollRange.call(this,n))}},_scrollEndArgs:function(n,t){var i=this.scrollbarContainer._calculateRange.call(this,n,t.offsetRightX,t),r,u,f,e,o,s;i&&t._scrollStarted&&(r=i.data.oldRange,u=i.data.newRange,t.valueType.toLowerCase()=="datetime"?(f=Date.parse(r.start),o=Date.parse(u.start),e=Date.parse(r.end),s=Date.parse(u.end)):(f=r.start,o=u.start,e=r.end,s=u.end),(f!=o||e!=s||this.leftScrollbarClicked||this.rightScrollbarClicked)&&(i=this.scrollbarContainer._args.call(this,t,i),this._trigger("scrollEnd",i)),t._scrollStarted=!1,this.scrollUpdate?this.scrollUpdate=!1:this.scrollbarContainer._appendScrollRange.call(this,t))},_args:function(n,t){if(n.isZooming){var i=this.model._axes[n.index],r=t.data;r.axis=i;r.newRange=i.visibleRange;r.oldRange=i.previousRange}return n.isVirtual&&(t.data.axis=this.model._axes[n.index],delete t.data.zoomFactor,delete t.data.zoomPosition),t},doMouseWheelZoom:function(n,t,i){if(n>=1){var r=this.scrollbarContainer.calZoomFactors(n,t,i.zoomFactor,i.zoomPosition);i.zoomPosition!=r.zoomMPosition&&r.zoomMPosition+i.zoomFactor<=1&&i.zoomPosition>=0&&(r.zoomMPosition+i.zoomFactor>=1&&(r.zoomMPosition=1-i.zoomFactor),r.zoomMPosition<0&&(r.zoomMPosition=0),i.zoomPosition=r.zoomMPosition,i.startX=i.zoomPosition*(i.width-30-i._diff)+15,i.startX=i.startX+i.rectWidth+5>i.width?i.width-i.rectWidth-15:i.startX,i.offsetLeftX=i.startX,i._offsetRightX=i.startX+i.rectWidth,i._offsetRightX>i.width-15?(i.offsetRightX=i.width-15,i.startX=i.offsetRightX-i.rectWidth,i.offsetLeftX=i.startX):i.offsetRightX=i._offsetRightX,i.endX=i.width-i.offsetRightX,this.scrollbarContainer._setScrollPosition.call(this,i.startX,i.offsetRightX,i),this.scrollbarContainer._calculateMouseWheelRange.call(this,i.startX,i.offsetRightX,i))}return!1},_calculateMouseWheelRange:function(t,i,r){var e,u,f,w=30,c,l,o,s,h,a,v,y,p;r.zoomFactor=r.rectWidth/(r.width-w);r.zoomPosition=(t-15)/(r.width-w-r._diff);e=r.scrollRange;r.isRTL?(f=e.max-r.zoomPosition*e.delta,u=f-r.zoomFactor*e.delta):(u=e.min+r.zoomPosition*e.delta,f=u+r.zoomFactor*e.delta);r.valueType=="datetime"?(c=r.startDateTime,l=r.endDateTime,r.startDateTime=this.startDateTime=u=new Date(u),r.endDateTime=this.endDateTime=f=new Date(f)):(c=parseInt(r.startValue),l=parseInt(r.endValue),r.startValue=this.startValue=u=Math.ceil(u),r.endValue=this.endValue=f=Math.ceil(f));o=n.extend({},ej.EjSvgRender.commonChartEventArgs);o.data={zoomPosition:r.zoomPosition,zoomFactor:r.zoomFactor,oldRange:{start:c,end:l},newRange:{start:u,end:f}};r._scrollChanged=!0;r._scrollStarted=!1;s=o.data.oldRange;h=o.data.newRange;r.valueType.toLowerCase()=="datetime"?(a=Date.parse(s.start),y=Date.parse(h.start),v=Date.parse(s.end),p=Date.parse(h.end)):(a=s.start,y=h.start,v=s.end,p=h.end);(a!=y||v!=p||r.isZooming)&&(this.scrollbarContainer._scrollStartArgs.call(this,r),o=this.scrollbarContainer._args.call(this,r,o),this._trigger("scrollEnd",o),this.scrollUpdate?this.scrollUpdate=!1:this.scrollbarContainer._appendScrollRange.call(this,r),this._scrollEnd=!1)},calZoomFactors:function(n,t,i,r){var u,f;return n==1?(u=1,f=0):(u=ej.EjSvgRender.utils._minMax(1/n,0,1),f=r+(i-u)*t),{zoomMFactor:u,zoomMPosition:f}},_leftArrowDown:function(n){var t,i;this.leftArrowClicked=!0;t=this.scrollbarContainer._doScrollIndex.call(this,n);t._startX=t.startX=t.offsetLeftX;t._offsetRightX=t.offsetRightX;t.leftIncrement=5;i=this;t.interval=setInterval(function(){i.scrollbarContainer.leftArrowRecursive.call(i,t)},50)},_leftArrowUp:function(n){this.leftArrowClicked=!1;var t=this.scrollbarContainer._doScrollIndex.call(this,n);this.scrollbarContainer.leftArrowRecursive.call(this,t)},leftArrowRecursive:function(n){if(this.leftArrowClicked){var t=this._id;this.scrollbarContainer._calculateScrollLeftMove.call(this,n.leftIncrement,n);n._scrollStarted=!0;n.startX>15&&this.scrollbarContainer._scrollEndArgs.call(this,n.startX,n);this.scrollbarContainer._setScrollPosition.call(this,n.startX,n.offsetRightX,n);n.leftIncrement+=5}else clearInterval(n.interval),n.leftIncrement=0},_rightArrowDown:function(n){var t,i;this.rightArrowClicked=!0;t=this.scrollbarContainer._doScrollIndex.call(this,n);t._startX=t.startX=t.offsetLeftX;t._offsetRightX=t.offsetRightX;t.rightIncrement=-5;i=this;t.interval=setInterval(function(){i.scrollbarContainer.rightArrowRecursive.call(i,t)},50)},_rightArrowUp:function(n){this.rightArrowClicked=!1;var t=this.scrollbarContainer._doScrollIndex.call(this,n);this.scrollbarContainer.rightArrowRecursive.call(this,t)},rightArrowRecursive:function(n){if(this.rightArrowClicked){var t=this._id;this.scrollbarContainer._calculateScrollRightMove.call(this,n.rightIncrement,n);n._scrollStarted=!0;n.offsetRightX<n.width-15&&this.scrollbarContainer._scrollEndArgs.call(this,n._startX,n);this.scrollbarContainer._setScrollPosition.call(this,n._startX,n.offsetRightX,n);n.rightIncrement-=5}else clearInterval(n.interval),n.rightIncrement=0},_scrollBackRectDown:function(n){var e=jQuery.uaMatch(navigator.userAgent),r=this.model.padding||0,t=this.scrollbarContainer._doScrollIndex.call(this,n),u,i,f;u=!this.vmlRendering&&n.originalEvent.toString()!=="[object TouchEvent]"&&e.browser.toLowerCase()!="msie"||this.vmlRendering?(t.orientation=="horizontal"?this.calMousePosition(n).X-t.x:t.width-(this.calMousePosition(n).Y-t.y))-r:(t.orientation=="horizontal"?this.calTouchPosition(n).X-t.x:t.width-(this.calTouchPosition(n).Y-t.y))-r;this.mouseDownPos=u;this.scrollbarBackRectClicked=!0;i=this;this.scrollbarContainer._scrollStartArgs.call(this,t);f=setInterval(function(){i.scrollbarContainer.scrollBackRectRecursive.call(i,t);this.scrollbarBackRectClicked||clearInterval(f)},50)},_scrollBackRectUp:function(n){this.scrollbarBackRectClicked=!1;var t=this.scrollbarContainer._doScrollIndex.call(this,n);this.scrollbarContainer.scrollBackRectRecursive.call(this,t)},_doScrollIndex:function(n){var i=this._id+"_scrollbar_",r=n.target.parentNode&&n.target.parentNode.id?n.target.parentNode.id:"",t=r.indexOf(i)>-1?parseInt(r.substr(i.length)):NaN;return ej.isNullOrUndefined(this.lastIndex)||isNaN(this.lastIndex)||!this.model.scrollObj[this.lastIndex].release&&this.model.scrollObj[this.lastIndex].clicked&&(t=this.lastIndex),this.lastIndex=ej.isNullOrUndefined(this.lastIndex)?t:this.lastIndex,ej.isNullOrUndefined(this.model.scrollObj[t])?this.model.scrollObj[this.lastIndex]:this.model.scrollObj[t]},scrollBackRectRecursive:function(n){if(this.scrollbarBackRectClicked){var t=10/100*(n.width-30);n._startX=n.startX=n.offsetLeftX;n._offsetRightX=n.offsetRightX;this.mouseDownPos<n.startX?(t=t<n.startX?t:n.startX-16,this.scrollbarContainer._calculateScrollLeftMove.call(this,t,n),n._scrollStarted=!0,this.scrollbarContainer._scrollEndArgs.call(this,n.startX,n),this.scrollbarContainer._setScrollPosition.call(this,n.startX,n.offsetRightX,n)):this.mouseDownPos>n.offsetRightX?(t=(t<n.endX?t:n.endX-16)*-1,this.scrollbarContainer._calculateScrollRightMove.call(this,t,n),n._scrollStarted=!0,this.scrollbarContainer._scrollEndArgs.call(this,n._startX,n),this.scrollbarContainer._setScrollPosition.call(this,n._startX,n.offsetRightX,n)):n._scrollStarted=!1}else n._scrollStarted=!1},_appendScrollRange:function(n){if(this.scrollbarUpdate=!0,this.pluginName=="ejRangeNavigator")this.renderNavigator();else{var i=n.index,t=this.model._axes[i];n.isZooming&&(t.zoomFactor!=n.zoomFactor||t.zoomPosition!=n.zoomPosition)&&(t.zoomFactor=n.zoomFactor,t.zoomPosition=n.zoomPosition,this.redraw(!0))}this.scrollbarUpdate=!1}}}(jQuery),function(n,t){t.widget("ejChart","ej.datavisualization.Chart",{element:null,model:null,validTags:["div"],defaults:{border:{color:"transparent",width:0,opacity:.3},chartArea:{border:{color:"Gray",width:.5,opacity:.3},background:"transparent"},highlightColor:null,primaryXAxis:{rotateOn:"middle",crossesAt:null,crossesInAxis:null,isIndexed:!1,multiLevelLabelsColor:null,multiLevelLabelsFontColor:null,alignment:"center",labelPlacement:"",scrollbarSettings:{visible:!0,canResize:!0,range:{min:null,max:null},pointsLength:null},range:{min:null,max:null,interval:null},labelPosition:"outside",tickLinesPosition:"outside",alternateGridBand:{odd:{fill:"transparent",opacity:1},even:{fill:"transparent",opacity:1}},enableAutoIntervalOnZooming:!0,majorGridLines:{color:null,width:1,dashArray:"",visible:!0,opacity:1},majorTickLines:{color:null,width:1,size:5,visible:!0},minorGridLines:{color:null,width:1,dashArray:"",visible:!0},minorTickLines:{color:null,width:1,size:5,visible:!0},labelBorder:{color:null,width:0},multiLevelLabels:[{visible:!1,text:"",textAlignment:"center",start:null,end:null,level:0,maximumTextWidth:null,textOverflow:"trim",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"12px",fontWeight:"Regular",opacity:1},border:{type:"rectangle",width:1}}],minorTicksPerInterval:null,columnIndex:null,columnSpan:null,labelRotation:null,valueType:null,name:null,labelFormat:null,desiredIntervals:null,intervalType:null,roundingPlaces:null,logBase:10,plotOffset:0,labels:[],stripLine:[{visible:!1,startFromAxis:!1,text:"",width:0,textAlignment:"middlecenter",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"12px",fontWeight:"Regular",color:"black",opacity:1},start:null,end:null,isRepeat:!1,repeatEvery:null,repeatUntil:null,sizeType:"auto",color:"gray",borderColor:"black",zIndex:"over"}],title:{text:"",visible:!0,enableTrim:!1,offset:0,alignment:"center",isReversed:!1,position:"outside",maximumTitleWidth:null,font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"14px",opacity:1,fontWeight:"regular",color:null}},rangePadding:"Auto",additionalPadding:[1,1],orientation:"Horizontal",maximumLabels:3,opposedPosition:!1,showNextToAxisLine:!0,axisLine:{visible:!0,width:1,dashArray:"",offset:0,color:null},labelIntersectAction:"none",maximumLabelWidth:34,enableTrim:!1,edgeLabelPlacement:"none",isInversed:!1,font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"11px",color:null,fontWeight:"regular",opacity:1},visible:!0,crosshairLabel:{rx:3,ry:3,border:{color:null,width:1},fill:null,font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:null},visible:!1},zoomFactor:1,zoomPosition:0},primaryYAxis:{rotateOn:"middle",crossesAt:null,crossesInAxis:null,showNextToAxisLine:!0,alignment:"center",startFromZero:!0,range:{min:null,max:null,interval:null},scrollbarSettings:{visible:!0,canResize:!0,range:{min:null,max:null},pointsLength:null},labelPlacement:"",labelPosition:"outside",tickLinesPosition:"outside",multiLevelLabelsColor:null,multiLevelLabelsFontColor:null,alternateGridBand:{odd:{fill:"transparent",opacity:1},even:{fill:"transparent",opacity:1}},enableAutoIntervalOnZooming:!0,majorGridLines:{color:null,width:1,dashArray:"",visible:!0,opacity:1},majorTickLines:{color:null,width:1,size:5,visible:!0},minorGridLines:{color:null,width:1,dashArray:"",visible:!0},minorTickLines:{color:null,width:1,size:5,visible:!0},labelBorder:{color:null,width:0},multiLevelLabels:[{visible:!1,text:"",textAlignment:"center",start:null,end:null,level:0,maximumTextWidth:null,textOverflow:"trim",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"12px",fontWeight:"Regular",opacity:1},border:{type:"rectangle",width:1}}],minorTicksPerInterval:null,rowIndex:null,rowSpan:null,valueType:null,name:null,labelFormat:null,desiredIntervals:null,intervalType:null,roundingPlaces:null,labels:[],title:{text:"",visible:!0,enableTrim:!1,offset:0,alignment:"center",isReversed:!1,position:"outside",maximumTitleWidth:null,font:{color:null,fontFamily:"Segoe UI",fontStyle:"Normal",opacity:1,size:"14px",fontWeight:"regular"}},rangePadding:"Auto",stripLine:[{visible:!1,startFromAxis:!1,width:0,text:"",textAlignment:"middlecenter",font:{fontFamily:"Segoe UI",fontWeight:"Regular",fontStyle:"Normal",size:"12px",color:"black",opacity:1},start:null,end:null,isRepeat:!1,repeatEvery:null,repeatUntil:null,sizeType:"auto",color:"gray",borderColor:"black",zIndex:"over"}],logBase:10,plotOffset:0,orientation:"Vertical",maximumLabels:3,labelIntersectAction:"none",maximumLabelWidth:34,enableTrim:!1,edgeLabelPlacement:"none",isInversed:!1,crosshairLabel:{rx:3,ry:3,border:{color:null,width:1},fill:null,font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:null},visible:!1},visible:!0,opposedPosition:!1,font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"11px",opacity:1,fontWeight:"regular",color:null},axisLine:{visible:!0,width:1,dashArray:"",offset:0,color:null},zoomFactor:1,zoomPosition:0},axes:[],secondaryX:{rotateOn:"middle",crossesAt:null,crossesInAxis:null,showNextToAxisLine:!0,alignment:"center",multiLevelLabelsColor:null,multiLevelLabelsFontColor:null,range:{min:null,max:null,interval:null},scrollbarSettings:{visible:!0,canResize:!0,range:{min:null,max:null},pointsLength:null},tickLinesPosition:"outside",labelPosition:"outside",majorGridLines:{color:null,width:1,dashArray:"",visible:!0},alternateGridBand:{odd:{fill:"transparent",opacity:1},even:{fill:"transparent",opacity:1}},enableAutoIntervalOnZooming:!0,majorTickLines:{color:null,width:1,size:5,visible:!0},minorGridLines:{color:null,width:1,dashArray:"",visible:!0},minorTickLines:{color:null,width:1,size:5,visible:!0},labelBorder:{color:null,width:0},multiLevelLabels:[{visible:!1,text:"",textAlignment:"center",start:null,end:null,level:0,maximumTextWidth:null,textOverflow:"trim",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"12px",fontWeight:"Regular",opacity:1},border:{type:"rectangle",width:1}}],minorTicksPerInterval:null,columnIndex:null,columnSpan:null,labelRotation:null,valueType:null,name:null,labelFormat:null,labelPlacement:"",desiredIntervals:null,intervalType:null,roundingPlaces:null,logBase:10,plotOffset:0,labels:[],stripLine:[{visible:!1,startFromAxis:!1,text:"",textAlignment:"middlecenter",font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"regular",size:"12px",color:"black",opacity:1},start:null,end:null,isRepeat:!1,repeatEvery:null,repeatUntil:null,sizeType:"auto",color:"gray",borderColor:"black",zIndex:"over"}],title:{text:"",visible:!0,enableTrim:!1,offset:0,alignment:"center",isReversed:!1,position:"outside",maximumTitleWidth:null,font:{color:null,fontFamily:"Segoe UI",fontStyle:"Normal",size:"14px",opacity:1,fontWeight:"regular"}},rangePadding:"Auto",additionalPadding:[1,1],orientation:"Horizontal",maximumLabels:3,opposedPosition:!1,axisLine:{visible:!0,width:1,dashArray:"",offset:0,color:null},labelIntersectAction:"none",edgeLabelPlacement:"none",font:{color:null,fontFamily:"Segoe UI",fontStyle:"Normal",size:"11px",fontWeight:"regular",opacity:1},visible:!0,crosshairLabel:{rx:3,ry:3,border:{color:null,width:1},fill:null,font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:null},visible:!1},zoomFactor:1,zoomPosition:0},secondaryY:{rotateOn:"middle",crossesAt:null,crossesInAxis:null,showNextToAxisLine:!0,alignment:"center",startFromZero:!0,multiLevelLabelsColor:null,multiLevelLabelsFontColor:null,range:{min:null,max:null,interval:null},scrollbarSettings:{visible:!0,canResize:!0,range:{min:null,max:null},pointsLength:null},tickLinesPosition:"outside",labelPosition:"outside",majorGridLines:{color:null,width:1,dashArray:"",visible:!0},alternateGridBand:{odd:{fill:"transparent",opacity:1},even:{fill:"transparent",opacity:1}},enableAutoIntervalOnZooming:!0,majorTickLines:{color:null,width:1,size:5,visible:!0},minorGridLines:{color:null,width:1,dashArray:"",visible:!0},minorTickLines:{color:null,width:1,size:5,visible:!0},labelBorder:{color:null,width:0},multiLevelLabels:[{visible:!1,text:"",textAlignment:"center",start:null,end:null,level:0,maximumTextWidth:null,textOverflow:"trim",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"12px",fontWeight:"Regular",opacity:1},border:{type:"rectangle",width:1}}],minorTicksPerInterval:null,rowIndex:null,rowSpan:null,valueType:null,name:null,labelFormat:null,desiredIntervals:null,intervalType:null,roundingPlaces:null,labels:[],title:{text:"",visible:!0,enableTrim:!1,offset:0,alignment:"center",isReversed:!1,position:"outside",maximumTitleWidth:null,font:{fontFamily:"Segoe UI",fontStyle:"Normal",opacity:1,size:"14px",fontWeight:"regular",color:null}},rangePadding:"Auto",stripLine:[{visible:!1,startFromAxis:!1,text:"",textAlignment:"middlecenter",font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"regular",size:"12px",color:"black",opacity:1},start:null,end:null,isRepeat:!1,repeatEvery:null,repeatUntil:null,sizeType:"auto",color:"gray",borderColor:"black",zIndex:"over"}],logBase:10,plotOffset:0,orientation:"Vertical",maximumLabels:3,labelIntersectAction:"none",labelPlacement:"",edgeLabelPlacement:"none",crosshairLabel:{rx:3,ry:3,border:{color:null,width:1},fill:null,font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"13px",fontWeight:"regular",opacity:1,color:null},visible:!1},visible:!0,opposedPosition:!1,font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"11px",opacity:1,fontWeight:"regular"},axisLine:{color:null,visible:!0,width:1,dashArray:"",offset:0},zoomFactor:1,zoomPosition:0},trendlineDefaults:{type:"linear",visibility:"",visibleOnLegend:"visible",name:"Trendline",fill:"",width:1,opacity:1,dashArray:"",forwardForecast:0,backwardForecast:0,polynomialOrder:2,period:2,intercept:null,tooltip:{visible:!1,format:null,fill:null,border:{width:1,color:null},duration:"500ms",enableAnimation:!0,opacity:.95,font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"12px",opacity:1}}},indicatorDefaults:{visible:!0,points:[],tooltip:{visible:!1,format:null,fill:null,border:{width:1,color:null},duration:"500ms",enableAnimation:!0,opacity:.95},seriesName:"",font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"12px",color:"#707070",opacity:1},type:"SMA",period:14,standardDeviations:2,kPeriod:3,dPeriod:3,periodLine:{fill:"blue",width:2},lowerLine:{fill:"#008000",width:2},upperLine:{fill:"#ff0000",width:2},macdLine:{fill:"#ff9933",width:2},histogram:{fill:"#ccccff",opacity:1,border:{color:"#9999ff",width:1}},fill:"#00008B",width:2,xAxisName:"",yAxisName:"",visibility:"visible",macdType:"line",shortPeriod:12,longPeriod:26,trigger:9,enableAnimation:!1,animationDuration:null},annotationsDefault:{visible:!1,content:"",coordinateUnit:"none",verticalAlignment:"middle",horizontalAlignment:"middle",region:"chart",x:0,y:0,opacity:1,angle:0,xAxisName:"",yAxisName:"",margin:{left:0,right:0,bottom:0,top:0}},multiLevelLabelsDefault:{visible:!1,text:"",textAlignment:"center",start:null,end:null,level:0,maximumTextWidth:null,textOverflow:"trim",font:{fontFamily:"Segoe UI",fontStyle:"Normal",size:"12px",fontWeight:"Regular",opacity:1},border:{type:"rectangle",width:1}},stripLineDefault:{visible:!1,startFromAxis:!1,width:0,text:"",textAlignment:"middlecenter",font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"12px",color:"black",opacity:1},start:null,end:null,isRepeat:!1,repeatEvery:null,repeatUntil:null,sizeType:"auto",color:"gray",borderColor:"black",zIndex:"over",borderWidth:1},rowDefinitions:null,columnDefinitions:null,title:{text:"",enableTrim:!1,visible:!0,isReversed:!1,maximumWidth:"auto",textOverflow:"trim",textAlignment:"center",background:"transparent",border:{color:"transparent",width:1,opacity:.8,cornerRadius:.8},font:{color:null,fontFamily:"Segoe UI",fontStyle:"Normal",size:"16px",opacity:1,fontWeight:"regular"},subTitle:{text:"",enableTrim:!1,visible:!0,maximumWidth:"auto",textOverflow:"trim",textAlignment:"far",background:"transparent",border:{color:"transparent",width:1,opacity:.8,cornerRadius:.8},font:{color:null,fontFamily:"Segoe UI",fontStyle:"Normal",size:"12px",opacity:1,fontWeight:"regular"}}},lineCap:{butt:"butt",round:"round",square:"square"},lineJoin:{round:"round",bevel:"bevel",miter:"miter"},legendAlignment:{near:"near",center:"center",far:"far"},legendPosition:{top:"top",bottom:"bottom",right:"right",left:"left",custom:"custom"},enableAnimation:!0,legend:{title:{text:"",textAlignment:"center",font:{color:null,size:"12px",fontFamily:"Segoe UI",fontStyle:"normal",fontWeight:"regular"}},border:{color:"transparent",width:1},visible:!0,isReversed:!1,textOverflow:"none",textWidth:34,toggleSeriesVisibility:!0,enableScrollbar:!0,itemPadding:10,shape:"None",alignment:"Center",position:"Bottom",location:{x:0,y:0},itemStyle:{height:9,width:9,border:{color:"transparent",width:1}},rowCount:null,columnCount:null,opacity:1,fill:null,background:null,font:{color:null,fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"12px"},size:{height:null,width:null}},indicators:[{points:[],tooltip:{visible:!1,format:null,fill:null,border:{width:1,color:null},duration:"500ms",enableAnimation:!0,opacity:.95},seriesName:"",animationDuration:null,type:"SMA",period:14,standardDeviations:2,kPeriod:3,dPeriod:3,periodLine:{fill:"blue",width:2},lowerLine:{fill:"#008000",width:2},upperLine:{fill:"#ff0000",width:2},macdLine:{fill:"#ff9933",width:2},histogram:{fill:"#ccccff",opacity:1,border:{color:"#9999ff",width:1}},fill:"#00008B",visible:!0,font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"12px",color:"#707070",opacity:1},width:2,xAxisName:"",yAxisName:"",macdType:"line",shortPeriod:12,longPeriod:26,trigger:9,visibility:"visible",enableAnimation:!1}],background:null,backGroundImageUrl:null,annotations:[{visible:!1,content:"",coordinateUnit:"none",verticalAlignment:"middle",horizontalAlignment:"middle",region:"chart",x:0,y:0,opacity:1,angle:0,xAxisName:"",yAxisName:"",margin:{left:0,right:0,bottom:0,top:0}}],series:[{dragSettings:{enable:!1,type:"xy"},type:"column",enableTrackTooltip:!0,splitMode:"value",splitValue:null,splineType:"natural",cardinalSplineTension:.5,gapWidth:50,pieOfPieCoefficient:.6,visibleOnLegend:"visible",enableAnimation:!1,animationDuration:null,animationType:"linear",isClosed:!0,isTransposed:!1,isStacking:!0,columnSpacing:0,columnWidth:.7,columnFacet:"rectangle",drawType:"line",doughnutCoefficient:.4,explodeOffset:25,pyramidMode:"linear",boxPlotMode:"exclusive",funnelWidth:"11.6%",funnelHeight:"32.7%",positiveFill:null,showMedian:!0,outlierSettings:{shape:"circle",size:{width:6,height:6}},cornerRadius:{topLeft:0,topRight:0,bottomLeft:0,bottomRight:0},connectorLine:{width:1,opacity:1,dashArray:null},errorBar:{visibility:"hidden",mode:"vertical",type:"fixedValue",horizontalErrorValue:1,verticalErrorValue:3,horizontalPositiveErrorValue:1,horizontalNegativeErrorValue:1,verticalPositiveErrorValue:5,verticalNegativeErrorValue:5,direction:"both",cap:{visible:!0,width:1,length:20},width:1,opacity:1},highlightSettings:{enable:!1,mode:"series",color:"",opacity:.6,border:{color:"",width:2},pattern:"none",customPattern:""},selectionSettings:{type:"Single",enable:!1,mode:"series",rangeType:"xy",color:"",opacity:.6,border:{color:"",width:2},pattern:"none",customPattern:""},emptyPointSettings:{visible:!0,style:{color:"",border:{color:"",width:1}},displayMode:"gap"},labelPosition:"inside",gapRatio:0,points:null,pieCoefficient:.8,doughnutSize:.8,dataSource:null,high:"",low:"",open:"",close:"",bullFillColor:null,bearFillColor:null,query:null,xName:"",yName:"",pointColorMappingName:"",visibility:"visible",startAngle:null,endAngle:null,xAxisName:null,yAxisName:null,explodeAll:null,explode:!1,explodeIndex:null,enableSmartLabels:null,tooltip:{visible:!1,isReversed:!1,format:null,template:null,fill:null,border:{width:1,color:null},enableAnimation:!0,duration:"500ms",opacity:.95},fill:null,opacity:1,lineCap:"butt",lineJoin:"round",dashArray:"",border:{width:1,color:"transparent",dashArray:""},width:2,marker:{shape:"circle",imageUrl:"",size:{width:6,height:6},visible:!1,opacity:1,fill:null,border:{color:"white",width:3},dataLabel:{visible:!1,isReversed:!1,angle:0,showEdgeLabels:!1,enableContrastColor:!1,textMappingName:"",verticalTextAlignment:"center",horizontalTextAlignment:"center",textPosition:"top",textAnchor:"middle",shape:"none",opacity:1,fill:null,border:{color:"white",width:.1},maximumLabelWidth:null,enableWrap:!1,connectorLine:{width:.5,type:"line",color:null},offset:{x:0,y:0},font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",color:null,size:"11px",opacity:1},margin:{left:5,top:5,bottom:5,right:5}}},bubbleOptions:{radiusMode:"minmax",minRadius:1,maxRadius:3},trendlines:[{visibility:"",visibleOnLegend:"visible",type:"linear",name:"Trendline",fill:"",width:1,opacity:1,dashArray:"",forwardForecast:0,backwardForecast:0,polynomialOrder:2,period:2,intercept:null,tooltip:{visible:!1,format:null,fill:null,border:{width:1,color:null},duration:"500ms",enableAnimation:!0,opacity:.95,font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",color:null,size:"12px",opacity:1}}}],font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"12px",color:"#707070",opacity:1},_isdesigntime:!0}],commonSeriesOptions:{dragSettings:{enable:!1,type:"xy"},type:"column",enableTrackTooltip:!0,splitMode:"value",splitValue:null,splineType:"natural",cardinalSplineTension:.5,gapWidth:50,pieOfPieCoefficient:.6,visibleOnLegend:"visible",enableAnimation:!1,animationDuration:null,animationType:"linear",isClosed:!0,isTransposed:!1,isStacking:!1,columnWidth:.7,columnSpacing:0,columnFacet:"rectangle",drawType:"line",doughnutCoefficient:.4,explodeOffset:25,pyramidMode:"linear",boxPlotMode:"exclusive",funnelWidth:"11.6%",funnelHeight:"32.7%",positiveFill:null,showMedian:!0,outlierSettings:{shape:"circle",size:{width:6,height:6}},cornerRadius:{topLeft:0,topRight:0,bottomLeft:0,bottomRight:0},connectorLine:{width:1,opacity:1,dashArray:null},errorBar:{visibility:"hidden",mode:"vertical",type:"fixedValue",horizontalErrorValue:1,verticalErrorValue:3,horizontalPositiveErrorValue:1,horizontalNegativeErrorValue:1,verticalPositiveErrorValue:5,verticalNegativeErrorValue:5,direction:"both",cap:{visible:!0,width:1,length:20},width:1,opacity:1},highlightSettings:{enable:!1,mode:"series",color:"",opacity:.6,border:{color:"",width:2},pattern:"none",customPattern:""},selectionSettings:{type:"Single",enable:!1,mode:"series",rangeType:"xy",color:"",opacity:.6,border:{color:"",width:2},pattern:"none",customPattern:""},emptyPointSettings:{visible:!0,style:{color:"",border:{color:"",width:1}},displayMode:"gap"},labelPosition:"inside",gapRatio:0,pieCoefficient:.8,doughnutSize:.8,dataSource:null,xName:"",yName:"",pointColorMappingName:"",high:"",low:"",open:"",close:"",startAngle:null,endAngle:null,xAxisName:null,yAxisName:null,explodeAll:!1,explode:!1,explodeIndex:null,enableSmartLabels:null,tooltip:{visible:!1,isReversed:!1,format:null,template:null,fill:null,border:{color:null,width:1},enableAnimation:!0,duration:"500ms",opacity:.95},fill:null,opacity:1,lineCap:"butt",lineJoin:"round",dashArray:"",border:{color:"transparent",width:1,dashArray:""},width:2,marker:{shape:"circle",imageUrl:"",size:{width:6,height:6},visible:!1,opacity:1,fill:null,border:{color:"white",width:3},dataLabel:{visible:!1,isReversed:!1,angle:0,enableContrastColor:!1,showEdgeLabels:!1,textMappingName:"",verticalTextAlignment:"center",horizontalTextAlignment:"center",textPosition:"top",textAnchor:"middle",shape:"none",maximumLabelWidth:null,enableWrap:!1,opacity:1,fill:null,border:{color:"white",width:.1},offset:{x:0,y:0},connectorLine:{width:.5,type:"line",height:null},font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"11px",color:null,opacity:1},margin:{left:5,top:5,bottom:5,right:5}}},bubbleOptions:{radiusMode:"minmax",minRadius:1,maxRadius:3},trendlines:[{visibility:"",visibleOnLegend:"visible",type:"linear",name:"Trendline",fill:"",width:1,opacity:1,dashArray:"",forwardForecast:0,backwardForecast:0,polynomialOrder:2,period:2,intercept:null,tooltip:{visible:!1,format:null,fill:null,border:{width:1,color:null},duration:"500ms",enableAnimation:!0,opacity:.95,font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",color:null,size:"12px",opacity:1}}}],font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"12px",color:"#707070",opacity:1}},crosshair:{line:{width:1},marker:{visible:!0,size:{width:10,height:10},opacity:1,border:{width:3}},visible:!1,isReversed:!1,type:"crosshair",trackballTooltipSettings:{fill:null,mode:"float",border:{width:null,color:null},rx:3,ry:3,opacity:1,tooltipTemplate:null}},pointStyle:{lineCap:"butt",lineJoin:"round",opacity:1,interior:null,borderColor:null,borderWidth:1},textStyle:{marker:{textAlignment:"center",textPosition:"top"},font:{fontFamily:"Segoe UI",fontStyle:"Normal",fontWeight:"Regular",size:"12px",color:"#707070",opacity:1}},symbolShape:{None:0,LeftArrow:1,RightArrow:2,Circle:3,Cross:4,HorizLine:5,VertLine:6,Diamond:7,Rectangle:8,Triangle:9,InvertedTriangle:10,Hexagon:11,Pentagon:12,Star:13,Ellipse:14,Wedge:15,Trapezoid:16,UpArrow:17,DownArrow:18,Image:19,SeriesType:20},initSeriesRender:!0,theme:"flatlight",canResize:!1,isResponsive:!1,enable3D:!1,enableRotation:!1,sideBySideSeriesPlacement:null,perspectiveAngle:90,rotation:0,tilt:0,wallSize:2,depth:100,enableCanvasRendering:!1,selectedDataPointIndexes:[],exportSettings:{type:"png",fileName:"Chart",orientation:"portrait",angle:0,mode:"client",action:"",multipleExport:!1},zooming:{enable:!1,isReversed:!1,enableScrollbar:!1,type:"x,y",enablePinching:!0,enableMouseWheel:!1,enableDeferredZoom:!1,toolbarItems:["zoomIn","zoomOut","zoom","pan","reset"]},type:"x,y",locale:null,xZoomFactor:1,yZoomFactor:1,xZoomPosition:0,yZoomPosition:0,load:"",axesLabelRendering:"",axesRangeCalculate:"",axesTitleRendering:"",dragStart:"",dragging:"",dragEnd:"",chartAreaBoundsCalculate:"",legendItemRendering:"",legendBoundsCalculate:"",preRender:"",seriesRendering:"",trendlineRendering:"",symbolRendering:"",titleRendering:"",subtitleRendering:"",axesLabelsInitialize:"",pointRegionClick:"",seriesRegionClick:"",annotationClick:"",axisLabelClick:"",chartClick:"",scrollStart:"",scrollEnd:"",scrollChanged:"",chartDoubleClick:"",pointRegionMouseMove:"",legendItemClick:"",axisLabelMouseMove:"",chartMouseMove:"",legendItemMouseMove:"",chartMouseLeave:"",displayTextRendering:"",toolTipInitialize:"",trackAxisToolTip:"",trackToolTip:"",animationComplete:"",zoomed:"",destroy:"",create:"",beforeResize:"",afterResize:"",rangeSelected:"",multiLevelLabelClick:"",multiLevelLabelRendering:"",margin:{left:10,right:10,top:10,bottom:10},size:{width:null,height:null},elementSpacing:10,dateStart:25568.791666666668},dataTypes:{commonSeriesOptions:{dataSource:"data"},axes:"array",series:"array",annotations:"array",indicators:"array",seriesColors:"array",palette:"array",rowDefinitions:"array",columnDefinitions:"array",seriesBorderColors:"array",pointColors:"array",pointBorderColors:"array",initSeriesRender:"boolean",theme:"enum",canResize:"boolean",isResponsive:"boolean",elementSpacing:"number",primaryXAxis:{labels:"array",multiLevelLabels:"array",stripLine:"array",orientation:"enum",rangePadding:"enum",labelPlacement:"enum",tickLinesPosition:"enum",labelPosition:"enum",opposedPosition:"boolean",zoomFactor:"number",zoomPosition:"number",showNextToAxisLine:"boolean"},primaryYAxis:{labels:"array",multiLevelLabels:"array",stripLine:"array",orientation:"enum",rangePadding:"enum",labelPlacement:"enum",opposedPosition:"boolean",zoomFactor:"number",zoomPosition:"number"},legend:{textOverflow:"enum",shape:"enum",alignment:"enum",position:"enum",itemPadding:"number"},exportSettings:{type:"string",fileName:"string",orientation:"enum",angle:"number",mode:"enum",action:"string",multipleExport:"boolean"},zooming:{enable:"boolean",type:"string",enableMouseWheel:"boolean",toolbarItems:"array",enableScrollbar:"boolean"},size:{width:"string",height:"string"}},observables:["xZoomFactor","yZoomFactor","xZoomPosition","yZoomPosition"],_tags:[{tag:"series",attr:["xAxisName","yAxisName","zOrder","endAngle","startAngle","explodeIndex","labelPosition","xName","yName","pointColorMappingName","pyramidMode","boxPlotMode","showMedian","pieCoefficient","explodeAll","explodeOffset","funnelWidth","columnFacet","funnelHeight","gapRatio","isClosed","isTransposed","enableTrackTooltip","isStacking","bearFillColor","bullFillColor","dataSource","enableAnimation","animationDuration","doughnutCoefficient","doughnutSize","enableSmartLabels","drawType","dashArray","visibleOnLegend","columnSpacing","columnWidth","drawType","positiveFill","explodeIndex","cornerRadius","lineCap","lineJoin","highlightSettings.enable","highlightSettings.mode","highlightSettings.pattern","highlightSettings.color","highlightSettings.opacity","highlightSettings.customPattern","highlightSettings.border.color","highlightSettings.border.width","selectionSettings.enable","selectionSettings.mode","selectionSettings.pattern","selectionSettings.color","selectionSettings.opacity","selectionSettings.customPattern","selectionSettings.type","selectionSettings.rangeType","selectionSettings.border.width","selectionSettings.border.color","dragSettings.enable","dragSettings.type","connectorLine.width","connectorLine.opacity","connectorLine.dashArray","cornerRadius.topLeft","cornerRadius.topRight","cornerRadius.bottomLeft","cornerRadius.bottomRight","errorBar.visibility","errorBar.mode","errorBar.type","errorBar.horizontalErrorValue","errorBar.verticalErrorValue","errorBar.horizontalPositiveErrorValue","errorBar.horizontalNegativeErrorValue","errorBar.verticalPositiveErrorValue","errorBar.verticalNegativeErrorValue","errorBar.direction","errorBar.cap.visible","errorBar.cap.width","errorBar.cap.length","errorBar.width","errorBar.opacity","emptyPointSettings.visible","emptyPointSettings.style.color","emptyPointSettings.style.border.color","emptyPointSettings.style.border.width","emptyPointSettings.displayMode","bubbleOptions.minRadius","bubbleOptions.maxRadius","bubbleOptions.radiusMode","tooltip.visible","tooltip.format","tooltip.template","tooltip.fill","tooltip.border.width","tooltip.border.color","tooltip.enableAnimation","tooltip.duration","tooltip.opacity","tooltip.font.size","tooltip.font.opacity","tooltip.font.fontFamily","tooltip.font.fontStyle","tooltip.font.fontWeight","tooltip.font.color","border.width","border.color","border.dashArray","marker.shape","marker.imageUrl","marker.size.width","marker.size.height","marker.visible","marker.opacity","marker.fill","marker.border.color","marker.border.width","marker.dataLabel.visible","marker.dataLabel.angle","marker.dataLabel.template","marker.dataLabel.textMappingName","marker.dataLabel.verticalTextAlignment","marker.dataLabel.horizontalTextAlignment","marker.dataLabel.textPosition","marker.dataLabel.textAnchor","marker.dataLabel.shape","marker.dataLabel.opacity","marker.dataLabel.fill","marker.dataLabel.border.color","marker.dataLabel.border.width","marker.dataLabel.maximumLabelWidth","marker.dataLabel.enableWrap","marker.dataLabel.connectorLine.width","marker.dataLabel.connectorLine.type","marker.dataLabel.connectorLine.color","marker.dataLabel.offset","marker.dataLabel.offset.x","marker.dataLabel.offset.y","marker.dataLabel.font.size","marker.dataLabel.font.color","marker.dataLabel.enableContrastColor","marker.dataLabel.showEdgeLabels","marker.dataLabel.font.opacity","marker.dataLabel.font.fontFamily","marker.dataLabel.font.fontStyle","marker.dataLabel.font.fontWeight","marker.dataLabel.margin","marker.dataLabel.margin.left","marker.dataLabel.margin.top","marker.dataLabel.margin.bottom","marker.dataLabel.margin.right","font.size","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","font.color","splineType","cardinalSplineTension",[{tag:"trendlines",attr:["visibility","visibilityOnLegend","dashArray","forewardForecast","backwardForecast","polynomialOrder","tooltip.visible","tooltip.format","tooltip.fill","tooltip.border.width","tooltip.border.color","tooltip.enableAnimation","tooltip.duration","tooltip.opacity","tooltip.font.size","tooltip.font.opacity","tooltip.font.fontFamily","tooltip.font.fontStyle","tooltip.font.fontWeight","tooltip.font.color",],singular:"trendline"}],[{tag:"points",attr:["x","y","text","textMappingName","isEmpty","fill","visible"],singular:"points"}]],singular:"series"},{tag:"axes",attr:["columnIndex","rowIndex","desiredIntervals","multiLevelLabelsColor","multiLevelLabelsFontColor","isIndexed","labelPlacement","edgeLabelPlacement","intervalType","labelFormat","labelPosition","labelRotation","logBase","labelIntersectAction","opposedPosition","plotOffset","rangePadding","roundingPlaces","valueType","zoomFactor","zoomPosition","orientation","crossesAt","crossesInAxis","scrollbarSettings.visible","scrollbarSettings.canResize","scrollbarSettings.range.min","scrollbarSettings.range.max","scrollbarSettings.pointsLength","range.min","range.max","range.interval","tickLinesPosition","alternateGridBand.odd.fill","alternateGridBand.odd.opacity","alternateGridBand.even.fill","alternateGridBand.even.opacity","enableAutoIntervalOnZooming","majorGridLines.width","majorGridLines.color","majorGridLines.dashArray","majorGridLines.visible","majorGridLines.opacity","majorTickLines.color","majorTickLines.width","majorTickLines.size","majorTickLines.visible","minorGridLines.width","minorGridLines.dashArray","minorGridLines.color","minorGridLines.visible","minorTickLines.color","minorTickLines.width","minorTickLines.size","minorTickLines.visible","labelBorder.color","labelBorder.width","minorTicksPerInterval","columnSpan","crosshairLabel.visible","crosshairLabel.rx","crosshairLabel.ry","crosshairLabel.border.color","crosshairLabel.border.width","crosshairLabel.fill","crosshairLabel.font.fontFamily","crosshairLabel.font.fontStyle","crosshairLabel.font.size","crosshairLabel.font.fontWeight","crosshairLabel.font.opacity","crosshairLabel.font.color","font.size","font.color","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","isInversed","enableTrim","maximumLabelWidth","axisLine.visible","axisLine.width","axisLine.color","axisLine.dashArray","axisLine.offset","maximumLabels","title.text","title.visible","title.enableTrim","title.offset","title.alignment","title.position","title.maximumTitleWidth","title.font.size","title.font.color","title.font.opacity","title.font.fontFamily","title.font.fontStyle","title.font.fontWeight","additionalPadding","showNextToAxisLine",[{tag:"stripLine",attr:["borderColor","startFromAxis","zIndex","textAlignment","font.size","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","font.color"],singular:"stripLine"}],[{tag:"multiLevelLabels",attr:["textOverflow","maximumTextWidth","textAlignment","font.size","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","border.type","border.width"],singular:"multiLevelLabel"}],],singular:"axis"},{tag:"primaryXAxis.stripLine",attr:["borderColor","startFromAxis","zIndex","textAlignment","font.size","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","font.color"],singular:"primaryXAxis.stripLine"},{tag:"primaryYAxis.stripLine",attr:["borderColor","startFromAxis","zIndex","textAlignment","font.size","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","font.color"],singular:"primaryYAxis.stripLine"},{tag:"primaryXAxis.multiLevelLabels",attr:["textOverflow","maximumTextWidth","textAlignment","font.size","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","border.type","border.width"],singular:"primaryXAxis.multiLevelLabel"},{tag:"primaryYAxis.multiLevelLabels",attr:["textOverflow","maximumTextWidth","textAlignment","font.size","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","border.type","border.width"],singular:"primaryYAxis.multiLevelLabel"},{tag:"indicators",attr:["seriesName","xName","xAxisName","macdType","shortPeriod","longPeriod","enableAnimation","animationDuration","yAxisName","standardDeviations","kPeriod","dPeriod","periodLine.fill","periodLine.width","lowerLine.fill","lowerLine.width","upperLine.fill","upperLine.width","macdLine.fill","macdLine.width","histogram.fill","histogram.opacity","histogram.border.color","histogram.border.width","font.size","font.opacity","font.fontFamily","font.fontStyle","font.fontWeight","font.color","tooltip.visible","tooltip.format","tooltip.fill","tooltip.border.width","tooltip.border.color","tooltip.enableAnimation","tooltip.duration","tooltip.opacity",[{tag:"points",attr:[]}]],singular:"indicator"},{tag:"annotations",attr:["coordinateUnit","verticalAlignment","horizontalAlignment","xAxisName","yAxisName","margin.left","margin.right","margin.top","margin.bottom"],singular:"annotation"},{tag:"rowDefinitions",attr:["rowHeight","lineColor","lineWidth","unit"],singular:"rowDefinition"},{tag:"columnDefinitions",attr:["columnWidth","lineColor","lineWidth","unit"],singular:"columnDefinition"},],_xZoomFactor:t.util.valueFunction("xZoomFactor"),_yZoomFactor:t.util.valueFunction("yZoomFactor"),_xZoomPosition:t.util.valueFunction("xZoomPosition"),_yZoomPosition:t.util.valueFunction("yZoomPosition"),_init:function(){this._renderSfChart()},_destroy:function(){n("#template_group_"+this._id).remove();n("#annotation_group_"+this._id).remove();n(this.element).removeClass("e-chart e-js").find("#"+this.svgObject.id).remove();n(this.element).removeClass("e-chart e-js").find("#legend_"+this.svgObject.id).remove()},_series:function(){this.redraw();this._trigger("refresh")},_series_points:function(){this.redraw();this._trigger("refresh")},_primaryXAxis_stripLine:function(){this.redraw();this._trigger("refresh")},_primaryYAxis_stripLine:function(){this.redraw();this._trigger("refresh")},_axes:function(){this.redraw();this._trigger("refresh")},_axes_stripLine:function(){this.redraw();this._trigger("refresh")},_ignoreOnExport:["dataSource"],_removeZoomkit:function(){this.model.zooming.enable&&(n("[id^="+this._id+"_][id$=_ResetZoom]").remove(),n("[id^="+this._id+"_][id$=_PanBtn]").remove(),n("[id^="+this._id+"_][id$=_ZoomBtn]").remove(),n("[id^="+this._id+"_][id$=_ZoomInBtn]").remove(),n("[id^="+this._id+"_][id$=_ZoomOutBtn]").remove())},getCanvasElement:function(t){var f,o=n("#"+t),i=document.createElement("canvas"),e=i.getContext("2d"),r=n("#"+t+"_canvas").width(),u=n("#"+t+"_canvas").height();return i.setAttribute("width",r),i.setAttribute("height",u),f=n("#"+t+"_canvas")[0],e.drawImage(f,0,0,r,u),{canvasContainer:i,canvasArea:e,width:r,height:u}},getSVGElement:function(t){var r=n("#"+t+"_svg").width(),u=n("#"+t+"_svg").height(),f=document.getElementById(t+"_svg"),e=n("<div>").append(n(f).clone()).html(),o=document.getElementById("legend_"+t+"_svg"),i=n("#legend_"+t).position(),h=n("#"+t+"_svg_Legend").attr("transform","translate("+i.left+","+i.top+")"),s=n("<div>").append(n(o).clone()).html();return{chartSVG:e,legendChartSVG:s,width:r,height:u}},print:function(){for(var ut,u,f,v,k,et,i,s,tt,y,d,r,t,it,e,o,c,l,a,p=[],w=[],ot,st=this.model.series.length,g,h="",ft=0,b=0;b<arguments.length;b++)if(c=n("#"+arguments[b]),t=arguments[b],c.hasClass("e-datavisualization-chart")){o=c.ejChart("instance");r="<html> <div style='position:relative; left:0px; top:"+ft+"px'>";g="";it=o.svgObject.id;ft=n("#"+it).height()+50;n("#axisScrollbar_"+t)[0]&&(g=n("#axisScrollbar_"+t)[0].innerHTML);var ht=["ResetZoom","PanBtn","ZoomBtn","ZoomOutBtn","ZoomInBtn"],rt=[],nt;for(i=0;i<5;i++)nt="#"+it+"_"+ht[i],n(nt)[0]&&(rt.push(n(nt)),n(nt).remove());if(o.model.enableCanvasRendering==!0){for(e=this.getCanvasElement(t),ot=o.model.LegendBounds,h=document.createElement("img"),h.setAttribute("src",n("#legend_"+t+"_canvas")[0].toDataURL()),n("#legend_Scroller"+t).prepend(h),r+=document.getElementById("chartContainer_"+t).outerHTML,n(h).remove(),h="",u=0;u<st;u++)if(ut=o.model.series[u].selectionSettings.mode.toLowerCase(),o.model.AreaType!="none")if(ut=="series")n(c).find("#"+t+"_Selection_series"+u+"_canvas").length>0&&(l=n("#"+t+"_Selection_series"+u+"_canvas")[0],e.canvasArea.drawImage(l,0,0,e.width,e.height)),n(c).find("#"+t+"_Selection_Legend"+u+"_canvas").length>0&&(a=n("#"+t+"_Selection_Legend"+u+"_canvas")[0],h="<img style='position:absolute;left:0px;' src='"+a.toDataURL()+"'/>");else if(ut=="point"){for(f=o.model.selectedDataPointIndexes,i=0;i<f.length;i++)f[i].seriesIndex==u&&n(c).find("#"+t+"_Selection_series"+u+"_point_"+f[i].pointIndex+"_canvas").length>0&&(l=n("#"+t+"_Selection_series"+u+"_point_"+f[i].pointIndex+"_canvas")[0],e.canvasArea.drawImage(l,0,0,e.width,e.height));n(c).find("#"+t+"_Selection_Legend"+u+"_canvas").length>0&&(a=n("#"+t+"_Selection_Legend"+u+"_canvas")[0],h="<img style='position:absolute;left:0px;' src='"+a.toDataURL()+"'/>")}else{for(f=o.model.selectedDataPointIndexes,i=0;i<f.length;i++)f[i].seriesIndex==u&&n(c).find("#"+t+"_Selection_Cluster_point_"+f[i].pointIndex+"_canvas").length>0&&(l=n("#"+t+"_Selection_Cluster_point_"+f[i].pointIndex+"_canvas")[0],e.canvasArea.drawImage(l,0,0,e.width,e.height));n(c).find("#"+t+"_SelectionCluster_Legend"+u+"_canvas").length>0&&(a=n("#"+t+"_SelectionCluster_Legend"+u+"_canvas")[0],h="<img style='position:absolute;left:0px;' src='"+a.toDataURL()+"'/>")}else for(f=o.model.selectedDataPointIndexes,i=0;i<f.length;i++)f[i].seriesIndex==u&&n("#"+t+"_Selection_series"+u+"_point_"+f[i].pointIndex+"_canvas").length>0&&(l=document.getElementById(t+"_Selection_series"+u+"_point_"+f[i].pointIndex+"_canvas"),e.canvasArea.drawImage(l,0,0,e.width,e.height),n("#"+t+"_Selection_Legend"+f[i].pointIndex+"_canvas").length>0&&(a=document.getElementById(t+"_Selection_Legend"+f[i].pointIndex+"_canvas"),h="<img style='position:absolute;left:0px;' src='"+a.toDataURL()+"'/>"));e.canvasArea.save();p.push(e.canvasContainer)}else v=this.getSVGElement(t),n("#"+t+"_svg_Legend").removeAttr("transform"),r+=n("#chartContainer_"+t)[0].outerHTML,r=this._getSelectionContentInSVG(o,t,r,"print"),o.model.backGroundImageUrl!=null&&(y=new Image,y.src=o.model.backGroundImageUrl,k=document.createElement("canvas"),et=k.getContext("2d"),k.setAttribute("width",v.width),k.setAttribute("height",v.height),et.drawImage(y,0,0,v.width,v.height),r+="<img src='"+k.toDataURL()+"'/>"),r+='<svg xmlns="http://www.w3.org/2000/svg" style="left:0px; top:0px; position:absolute;" width="'+v.width+'" height="'+v.height+'" >',r+=v.chartSVG.toString()+" <\/svg>",r+=g+"<\/div><\/html>",w.push(r);for(i=0;i<rt.length;i++)n("#chartContainer_"+t).append(rt[i])}else r="<html>",r+=document.getElementById(arguments[b]).innerHTML,r+="<\/html>",w.push(r);for(s=window.open(),tt=0;tt<w.length;tt++)s.document.write(w[tt]);if(p.length>0){for(y=new Image,d=0;d<p.length;d++)r+="<img src='"+p[d].toDataURL()+"'/>",y.src=p[d].toDataURL();r+=h;r+=g+"<\/div><\/html>";y.onload=function(){s.document.write(r);r="";s.document.close();s.focus();s.print();s.close()}}else w.length>0&&(r="",s.document.close(),s.focus(),s.print(),s.close())},redraw:function(i,r,u,f){var o,s,e;if(this.model.enableCanvasRendering)this.model.zooming.enable&&this.svgRenderer.ctx?(this.svgRenderer.ctx.clearRect(0,0,n("#"+this._id).width(),n("#"+this._id).height()),n(this.axisScroll).empty()):(n(this.svgObject).remove(),o=this.svgWidth,n("#canvas_trackSymbol").remove(),n("#"+this._id+"_canvas_Tracker").remove(),n("#secondCanvas").remove(),this.svgRenderer=new t.EjCanvasRender(this.element),this.svgRenderer.svgObj.height=t.util.isNullOrUndefined(this.model.size.height)?"450":this.model.size.height,this.svgRenderer.svgObj.width=t.util.isNullOrUndefined(this.model.size.width)?o:this.model.size.width,this.svgObject=this.svgRenderer.svgObj,s=this.svgRenderer.svgObj.getContext("2d"),n(this.scrollerContainer).remove(),n(this.legendSvgContainer).remove(),n(this.legendContainer).remove(),this.legendContainer=n("<div><\/div>").attr("id","legend_"+this._id).css("height","0px"),this.scrollerContainer=n("<div><\/div>").attr("id","legend_Scroller"+this._id).css("height","0px"),this.legendSvgContainer=this.svgRenderer.createLegendCanvas(this.element),this.svgRenderer.append(this.legendSvgContainer,this.scrollerContainer),n(this.scrollerContainer).appendTo(this.legendContainer),n(this.legendContainer).appendTo(this.chartContainer));else if(this.svgObject.id.indexOf("_canvas")!=-1)this._removeZoomkit(),n(this.svgObject).remove(),this.svgRenderer=new t.EjSvgRender(this.element),this.svgObject=this.svgRenderer.svgObj,this.canvasX=this.canvasY=0,n(this.scrollerContainer).remove(),n(this.legendSvgContainer).remove(),n(this.legendContainer).remove(),this.legendContainer=n("<div><\/div>").attr("id","legend_"+this._id).css("height","0px"),this.scrollerContainer=n("<div><\/div>").attr("id","legend_Scroller"+this._id).css("height","0px"),this.legendSvgContainer=this.svgRenderer.createLegendSvg(this.element),this.svgRenderer.append(this.legendSvgContainer,this.scrollerContainer),n(this.scrollerContainer).appendTo(this.legendContainer),n(this.legendContainer).appendTo(this.chartContainer);else if(!this.dragPoint||!r&&(!this.panning||!u||this.scrollbarUpdate||f||this.panning&&this.model.browserInfo.name!="chrome")||this.model.enable3D)n(this.svgObject).empty(),n(this.legendSvgContainer).empty(),n(this.axisScroll).empty();else{for(e=this.svgObject,this.chartUpdating=!0,!this.continuePinching&&u&&(u.id="",u.setAttribute("opacity",0),e.appendChild(u),this.continuePinching=!1);e.childNodes.length>1;)e.removeChild(e.firstChild);n(this.legendSvgContainer).empty()}this.model._chartAreaZoom&&(this.zoomed=this.model._chartAreaZoom=this.model._axes.some(function(n){return n.zoomFactor<1||n.zoomPosition>0}));this._removeZoomkit();n("#annotation_group_"+this._id).remove();i||(this.model.canResize||this.model.isResponsive?this.bindResizeEvents():this.removeResizeEvents());this.bindTo(i)},"export":function(n,i,r){var u,f=this.model.exportSettings,n=t.util.isNullOrUndefined(n)?f.type:n.toLowerCase(),i=t.util.isNullOrUndefined(i)?f.action:i.toLowerCase();return n=="xlsx"?this._getExportModel(n,i,r):u=n!="svg"&&this.model.enableCanvasRendering?this.imageExport():this.svgExport(),u},_getExpor