/*!
*  filename: ej.mediaplayer.min.js
*  version : 17.4.0.39
*  Copyright Syncfusion Inc. 2001 - 2019. All rights reserved.
*  Use of this code is subject to the terms of our license.
*  A copy of the current license can be obtained at any time by e-mailing
*  licensing@syncfusion.com. Any infringement will be prosecuted under
*  applicable laws. 
*/
(function(n){typeof define=="function"&&define.amd?define(["./../common/ej.core.min","./../common/ej.data.min","./../common/ej.draggable.min","./../common/ej.scroller.min","./../common/ej.globalize.min","./ej.button.min","./ej.listbox.min","./ej.listview.min","./ej.togglebutton.min","./ej.slider.min"],n):n()})(function(){"use strict";var n=this&&this.__extends||function(n,t){function r(){this.constructor=n}for(var i in t)t.hasOwnProperty(i)&&(n[i]=t[i]);n.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)};(function(t){var i=function(i){function r(n){return i.call(this),this.rootCSS="e-mediaplayer",this.PluginName="ejMediaPlayer",this._id="null",this._playlist=[],this._mediaIndex=0,this._mediaDiv=null,this._youtubeIns=null,this._playTimer=null,this._animateWidth=null,this._animateHeight=null,this._autoHideTime=null,this._mobIconHide=null,this._playIconHide=null,this._playlistWidth="32%",this._parentElement=null,this._youtubeMediaEle=null,this._pausedOnSeek=!1,this._dataSource=null,this._repeat=!1,this._mute=!1,this._shuffle=!1,this._subtitle=!1,this._tochStart=!1,this._mouseMoveEvt=null,this._mouseLeaveEvt=null,this._clickEvt=null,this._fullScEvt=null,this._keyDownEvt=null,this._mouseUpEvt=null,this._touchStartEvt=null,this._touchEndEvt=null,this._resizeEvt=null,this._pausedManual=!1,this._timeSliderClick=!1,this._volSliderClick=!1,this._hideBasicVol=null,this._manualMute=!1,this._hideVolume=null,this._playStarted=null,this._isWaitingPopup=null,this._sliderAnimation=100,this._animationSpeed=300,this._sliderLeft=null,this._isSettingsClick=!1,this._timeSliderSize="12px",this._touchStarted=!1,this._localizedLabels=null,this._APIKey="AIzaSyBFRrwfRNr5iTur-fBwexpBG70_P6foPPM&part",this._browserInfo=ej.browserInfo(),this._defaultPosterUrl="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAXEAAAFxCAYAAACFh5ikAAAACXBIWXMAAAsSAAALEgHS3X78AAAJ+UlEQVR42u3dsW8U2R3A8d+bmZ1dy7Kjo0MU/AEpUqdIULpUoIguSKEiRZoUVKlTpknp/AupolCQEqFISGmQIp0ipaG4FKQDAbZ3Zt9MGsZaEIQD1uuZ9ecjWcfdAce9NV//eDM7L/V9H2vqtx8AjE+OiNOIOAt39fav6e7duz959uzZ716/fv3zrutitVpZLoARSClFVVUxn8//88033/zp4cOHf4iIZURE6vs+3bt376dPnz7966tXrw7btrViACON+f7+fly5cuXPjx49+lVELMuqqq49fvz47y9evDg0fQOMW9M00ff9Dx88ePDfO3fu/KN48uTJL05OTg5zzlYHYALevHkTL1++/GVE1MVqtbreNI1VAZiInHMcHx//OCLqwnIATM9wZ6GIA0yYiAOIOAAiDoCIA4g4ACIOgIgDIOIAIg6AiAMg4gAiDoCIAyDiAIg4gIgDIOIAiDgAIg4g4gCIOAAiDiDiAIg4ACIOgIgDiDgAIg6AiAMg4gAiDoCIAyDiACIOgIgDIOIAiDiAiAMg4gCIOICIAyDiAIg4ACIOIOIAiDgAIg6AiAOIOAAiDoCIA4g4ACIOgIgDIOIAIg6AiAMg4gCIOICIAyDiAIg4gIgDIOIAiDgAIg4g4gCIOAAiDoCIA4g4ACIOgIgDiDgAIg6AiAMg4gA7p7IEcLn1fR9d10XXdWffTinFfD63OCIOjDHWQ7Bzzh/8vmVZWjARBy7C+kS9/oGIAyOSc46+788m6iHciDgwEkOY12M9/D2IOIws1u9vhYg1Ig4jjfWnLi6CiMMF+dBELdaIOIzMEGZ3giDiMPJYu7iIiMOIubiIiINYg4jDJri4iIjDBGPt4iIiDiPk4iKIOCO3PlEP4RZrEHFGHGsXF0HEmUCsXVwEEWcCuq6L5XLp4iJsgTM2ObfpGxBxAEQcQMQBEHEARBwAEQcQcQBEHAARBxBxAEQcABEHQMQBRBwAEQdAxAFEHAARB0DEARBxABEHQMQBEHEA3lFZAtgtZVlGURTR932sVisLIuLAGKWUzoI9fKSUzv59zlnERRwYy3SdUjqLdVmWFgURhzFO10Okh8m6KFy6QsRh9NP1+9shIOJgukbEAdM1Ig6maxBxMF2DiIPpGhGHqVqfqk3XiDhMYLpe3xIBEQfTNYg4mK5BxDFdg4jDGNR1fXaHCPCJQccSMNbpGxBxABEHQMQBEHEARBxAxAEQcQBEHEDEARBxAEQcABEHEHEARBwAEQdAxAFEHAARB0DEAUQcABEHQMQBEHEAEYdz/qQsfFqCiDNZKSWLACIOIOIAiDgAIg6AiAOIOAAiDoCIA4g4ACIOgIgDIOIAIg6AiAMg4gCIOICIAyDiAIg4gIgDIOIAiDgAIg4g4gCIOAAiDiDilgBAxAEQcQBEHEDEARBxAEQcABEHEHEARBwAEQcQcQBEHAARB0DEAUQcABEHQMQBEHEAEQdAxAEQcYBLqLIEMD5930fXddH3ffR9/9Hvl1KKlFIURREpJQsn4sBFyDlHzjm6rouc8xf9HEPMy7KMsiwtqogD5zlpD+FerVYb/zmHqCPiwIbj3TRN5Jz/7zbJpv5biDiwwXhvauoGEQfxRsSBj2nbNtq2ta2BiIPpG0Qczl3XdXF6emr6RsRhalarVTRNI+CIOEwx4Mvl0kKwdZ6dAgKOiMPllHMWcEQcpqjvewFHxGGq3IWCiMNEtW0bXddZCEQcpqbv+2jb1kIg4jBF7gVHxGHCU7i30zMm3uzDO4bnXA8fH9v3HU6OKYriUh0NZhsFEWdUU+VwHNhwNNjnxH5dSinKstz5oJvCEXFGEaJNHgt2WbYZtnEaD4g4H41s27axWq1GHaIxT/FuKUTEuZB4T+nZ1kUx3mvtX3oK/RQ5ZFnEGUG8h0ejYhLfpS+miPjOGx7KZP92818YRRwR51w1TeM2OL7acAspIs4Wp8TT01MX3/j6KFSyIOJsVdd1sVwuBRxTuIgzxYB7JCqbMrxpi+lw9WLChi0UATehbmyqqyq3F4o4Ar6jv1l2/I6NlFLMZjMvtIizDU3T2AM3iW/UbDYzhYs42zC8fZ7tR3xXI5dScleKiLMNTpW5+Gl1Fy0WC1O4iLMNTpW5WLt44W8+n3uHpoizDZt+fCyfb9cu/lVVZRtFxNkWAR+H2Wy2E5NrVVUxn8+9oCLONjjbcVzm8/mkt1UEXMQxhV/u3zhFMdkI1nUt4CLOtrknfHzKspxUDFNKsVgsvKFnx7iiYRLna34Dvb1bZezPb6+qKuq6dhuhSRxT+PlPi1OcyPf29kZ5sXOYvqe+h49JfNKcKDONLz57e3vRtm20bXvhr9lwK6StExHHJC7in2E2m0VVVRd2OHVKKeq63ulHBCDijHia3YWHTKWUYj6fR13XZ8+5Oc/JfFi3qqo8C1zE4eLsWoCGqbiu67N32+acNxL0oiiiLMuzD0QcWwwX/8m4w2//Xo9t3/fRdd3ZxxD19W8Pr/uwJTL82CHeIOKMbmq9LHEa/l/FmI0MeZbANsMY1HXthQYR3+EXaoe3VIaLcoCIi7gpHESc8dnVSbWuawcSgIjvvl1880ZVVd5RCCJ+eezStkNRFLZRQMQvl6qqdmLroSgKB/OCiF9OU38anYCDiF/uF2zC2xACDufwJ3RLMMEX7e2dKsvlclK/ZocSgIjzXsibphn188aHh0B5Mw+IOB8IeVEUsVwuR/nMcdM3iDifMOwzr1araJpmNNP3fD73gCcQcb5vNC/6RJnhC8rw6wBEnC+cgOu6jqZpNnYAwSc/iarKqTIg4mw65n3fR8757GNTQV9/HrazHEHEOceYD1NyRETO+Z3TZHLO3+vnGE6YGU6V8cAqEHEuwMdOkxmOC1u3fjQYIOKMfGK3nw3T5M/FACIOgIgDIOIAIg6AiAMg4gCIOICIAyDiAIg4gIgDIOIAiDgAIg4g4gCIOAAiDoCIA4g4ACIOgIgDiDgAIg6AiAMg4gAiDoCIAyDiAIg4gIgDIOIAiDiAiAMg4gCIOAAiDiDiAIg4ACIOIOIAiDgAIg6AiAOIOAAiDoCIAyDiACIOgIgDIOIAIg6AiAMg4gCIOICIAyDiAIg4ACIOIOIAiDgAIg4g4gCIOAAiDoCIA4g4ACIOgIgDIOIAIg6AiAMg4gAiDoCIAyDiAIg4gIgDMKKIF0XxsqoqKwEwESml2Nvb+zYi2uL69et/WSwWkVKyMgATsLe3F/v7+w8joimOjo7+de3atd8eHBwIOcDILRaLODw8/PbGjRt/jIg+9X0fEVHdvHnzN8+fP//9ycnJYc45cs5WC2AEUkpRVVXMZrM4ODj4261bt359//797yIihohHRKSI2L99+/bPjo+Pf9R13Q8sHcBoJvB/Xr169enR0dG/I6IZ/vn/AFDNBWDPII7OAAAAAElFTkSuQmCC",this._thumbnailUrl=" data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACsAAAAdCAYAAAAzfpVwAAAACXBIWXMAAAsSAAALEgHS3X78AAAAzUlEQVRYw+3VsW2AMBCF4d++KyzAMjXjpAp9lsh02SJrpEpDAQVYciKDUmUDI2HJN8Gnp/d0Zp7nF+q4LwXegbcnK8/z/BaRVwVY15VlWR4J7bqOaZoUwFLRNWzDNmzD3oQ1xtSDHccRVa0Dq6qEEHDO1dFZay3ee7z3RWtx68CccwzDUAc2pcRxHOUqdgfyui5ijKSUyu6hNDTnzL7v5JyLh1Acu21b+2AN27AN27CVYhUghPDb9/3PI9O0Vowx+R/7ISKfIvLkUCMQ/wAP5C8WF/A5pwAAAABJRU5ErkJggg==",this.promise=null,this._playQuality="Auto",this.defaults={width:"100%",height:"100%",toolbarHeight:"45px",source:[],volume:50,mute:!1,autoPlay:!0,autoHide:!0,shuffle:!1,repeat:!1,showPoster:!0,playSpeed:1,disableKeys:!1,showTitle:!0,cssClass:"",showPlaylist:!1,renderMode:screen.width<=480?"mobile":"basic",contentType:"video",autoHideTime:3,forwardTime:10,rewindTime:10,playlistTitle:"Playlist",locale:"en-US"},this.model=this.defaults,this.observable=["value"],this.hideWaitingPopup=function(){this._hideWaitingPopup();this._isWaitingPopup=!1},this.showWaitingPopup=function(){this._isWaitingPopup=!0;this._showWaitingPopup()},n&&(n.jquery||(n=t("#"+n)),n.length)?t(n).ejMediaPlayer().data(this.PluginName):void 0}return n(r,i),r.prototype._destroy=function(){window.clearInterval(this._playTimer);window.clearTimeout(this._autoHideTime);this._playTimer=null;this._autoHideTime=null;this._unwireCommonEvents();this._removeClass(this._mediaDiv,"e-media-player");this._removeClass(this._mediaDiv,"e-media-player");this._mediaDiv.innerHTML=""},r.prototype.setModel=function(n,t){this.setModel(n,t)},r.prototype.option=function(n,t){this.option(n,t)},r.prototype._setModel=function(n){var t,i,r,u;for(t in n){i=this._getCurrentMedia();r=this._isYoutubeElement(i);switch(t){case"width":this.model.width=n[t];this._setModelWidth();break;case"height":this.model.height=n[t];this._setModelHeight();break;case"toolbarHeight":this.model.toolbarHeight=n[t];this._updateToolbarHeight();break;case"renderMode":this.model.renderMode=n[t];this._changeRenderMode(n[t]);break;case"source":this._playlist=this.model.source=n[t];this._setMediaTypes();this._renderElementByType(this._mediaDiv,this._playlist);this._setAllMediaProperties();break;case"volume":this.model.volume=n[t];this._setModelVolume(i,n[t],r);break;case"mute":this._mute=this.model.mute=n[t];this._setModelMute(i,n[t],r);break;case"autoPlay":this.model.autoPlay=n[t];break;case"autoHide":this.model.autoHide=n[t];this._updateToolbarHeight();break;case"shuffle":this._shuffle=this.model.shuffle=n[t];break;case"repeat":this._repeat=this.model.repeat=n[t];break;case"showPoster":this.model.showPoster=n[t];break;case"playSpeed":this.model.playSpeed=n[t];this._setModelSpeed(i,n[t],r);break;case"disableKeys":this.model.disableKeys=n[t];break;case"showTitle":this.model.showTitle=n[t];break;case"cssClass":u=this._mediaDiv;this._removeClass(u,this.model.cssClass);this.model.cssClass=n[t];this._addClass(u,n[t]);break;case"showPlaylist":this.model.showPlaylist=n[t];break;case"autoHideTime":this.model.autoHideTime=n[t];break;case"forwardTime":this.model.forwardTime=n[t];break;case"rewindTime":this.model.rewindTime=n[t];break;case"locale":this.model.locale=n[t];this._localizedLabels=ej.getLocalizedConstants("ej.MediaPlayer",n[t]);this._updateLocaleTitles()}}},r.prototype._init=function(){this._browserInfo.name=="msie"&&parseInt(this._browserInfo.version)<9||ej.isNullOrUndefined(this.element)||(this._setHTMLCustomAttributes(),this._mediaDiv=this.element[0],this._localizedLabels=ej.getLocalizedConstants("ej.MediaPlayer",this.model.locale),this._setControlId(),this._initPlaylist(),this._setMediaTypes(),this._generatePlayerData())},r.prototype._getLocaleString=function(n){return this._localizedLabels[n]},r.prototype._updateLocaleTitles=function(){var n,t,i,r,u,f,e,o;n=this._mediaDiv.querySelector(".e-media-center-play");t=this._mediaDiv.querySelector(".e-media-center-pause");i=this._mediaDiv.querySelector(".e-media-prev-li");r=this._mediaDiv.querySelector(".e-media-next-li");u=this._mediaDiv.querySelector(".mob-playGroup .e-media-previous");f=this._mediaDiv.querySelector(".mob-playGroup .e-media-next");e=this._mediaDiv.querySelector(".e-media-playlist-close");o=this._mediaDiv.querySelector(".e-media-playlist-toggle");n&&(n.title=this._getLocaleString("Play"));t&&(t.title=this._getLocaleString("Pause"));i&&(i.title=this._getLocaleString("Previous"));r&&(r.title=this._getLocaleString("Next"));u&&(u.title=this._getLocaleString("Previous"));f&&(f.title=this._getLocaleString("Next"));e&&(e.title=this._getLocaleString("HidePlaylist"));o&&(o.title=this._getLocaleString("TogglePlaylist"))},r.prototype._generatePlaylistData=function(n){this._dataSource=n;this._renderMediaPlayer();this._renderToolbar();this._renderTooltip();this._renderPlaylist();this._initMediaElements();this._wireCommonEvents()},r.prototype._setControlId=function(){if(!this._mediaDiv.id){var n=document.getElementsByClassName("e-media-player");this._id="mediaPlayer"+(n.length+1)}},r.prototype._initPlaylist=function(){var n=this.model.source;this._playlist=n.slice(0,n.length)},r.prototype._setMediaTypes=function(){for(var t,n=0;n<this._playlist.length;n++)t=this._playlist[n].url,t&&t.trim()!=""&&(this._playlist[n].url=t,this._playlist[n].type=this._getTypeFromUrl(this._playlist[n].url))},r.prototype._changeRenderMode=function(n){var t=this._getCurrentMedia(),i,r;this.model.renderMode=n;this._stop(t);window.clearInterval(this._playTimer);this._playTimer=null;this._mediaDiv.querySelector(".e-media-control-container").remove();this._mediaDiv.querySelector(".e-media-settings-popup").remove();this._mediaDiv.querySelector(".e-media-time-tooltip").remove();i=this._mediaDiv.querySelector(".e-media-toolbar-ul.mob-playGroup");i&&i.remove();r=this._mediaDiv.querySelector(".e-media-prev-li.basic");r&&(r.remove(),this._mediaDiv.querySelector(".e-media-next-li.basic").remove());this._collapsePlaylist();this._renderToolbar();this._renderTooltip();this._updateToolbarHeight();this._setMediaDuration(t);this._updateTimeStamp(t);this._mediaDiv.querySelector(".e-media-playlist-container").remove();this._mediaDiv.querySelector(".e-media-playlist-toggle").remove();this._renderPlaylist();n==ej.MediaPlayer.RenderMode.Mobile?(this._removeClass(this._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-hide"),this._addClass(this._mediaDiv.querySelector(".e-media-playlist-close"),"e-hide")):(this._addClass(this._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-hide"),this._removeClass(this._mediaDiv.querySelector(".e-media-playlist-close"),"e-hide"));this._setPlaylistVisibility();this._updateSettingsSelector("Quality",ej.MediaPlayer.QualityText.Auto);this._updateSettingsSelector("Speed",ej.MediaPlayer.SpeedText.Normal);this._setQualityItemVisibility(this._isYoutubeElement(t));this._disablePrevNextIcons()},r.prototype._getTypeFromUrl=function(n){return this._isVaildYoutubeUrl(n)?ej.MediaPlayer.Types.Youtube:this._isValidVimeoUrl(n)||this._isVaildVideoUrl(n)?ej.MediaPlayer.Types.Video:this._isVaildAudioUrl(n)?ej.MediaPlayer.Types.Audio:void 0},r.prototype._isVaildVideoUrl=function(n){var t=this._getExtensionFromUrl(n);if(t=="mp4"||t=="webm"||t=="ogg"||t=="ogv")return!0},r.prototype._isVaildAudioUrl=function(n){var t=this._getExtensionFromUrl(n);if(t=="mp3"||t=="wav")return!0},r.prototype._isVaildYoutubeUrl=function(n){var t=n.match(/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/);if(t&&t[2].length==11)return!0},r.prototype._isValidVimeoUrl=function(n){var i=/^.*(vimeo\.com\/)((channels\/[A-z]+\/)|(groups\/[A-z]+\/videos\/))?([0-9]+)/,t=n.match(i);return t==null&&(i=/^.*(https?:\/\/)?(www\.)?(player\.)?vimeo\.com\/([a-z]*\/)*([0-9]{6,11})[?]?.*/,t=n.match(i)),t&&t[5].length!=null},r.prototype._getExtensionFromUrl=function(n){var t=n.split(".");return t[t.length-1]},r.prototype._initMediaElements=function(){var n;this._setModelWidth();this._setModelHeight();this._setAllMediaProperties();this.model.showPlaylist&&this._setPlaylistVisibility();this._updateToolbarHeight();this._handleAutoHide(null);this._updateSettingsSelector("Quality",ej.MediaPlayer.QualityText.Auto);this._setLowPriorityIconsVisibility();this._fadeMobileIcons();this._fadeBasicIcons();this._fadePlayIcon();this._updateAudioContent();n=this._mediaDiv.querySelector(".e-media-toolbar-playgroup");n&&(n.style.width="auto")},r.prototype._renderMediaPlayer=function(){var n=this._id,t=this._mediaDiv,u,i,f,o,r,s,h,c,e,l;this._mediaIndex=0;this._addClass(t,"e-media-player");this._addClass(t,"e-media-mouse");u=this._createElement("div",n+"_mediaEleDiv","e-media-element-div",!1);t.appendChild(u);this._mediaDiv.setAttribute("tabindex","0");i=this._createElement("div",n+"_mediaContentDiv","e-media-content-div",!1);u.appendChild(i);f=this._createElement("div",n+"_vBaner","e-media-video-baner",!1);o=this._createElement("div",n+"_vTitle","e-media-video-title",!1);f.appendChild(o);t.appendChild(f);r=this._createElement("div",n+"_aDetail","e-media-audio-detail e-hide",!1);s=this._createElement("img",n+"_poster","e-media-audio-poster",!1);r.appendChild(s);h=this._createElement("div",n+"_aTitle","e-media-audio-title",!1);r.appendChild(h);i.appendChild(r);this._addCenterPlayBtn(i);this._addCssClass();c=this._createElement("div",n+"_overlay","e-media-overlay",!1);t.querySelector(".e-media-content-div").appendChild(c);e=this._playlist;e.length>0?this._renderElementByType(t,e):this._renderVideoElement(t);l=this._createElement("div",n+"_customFullScreen","e-media-custom-fullscreen e-hide",!1);document.body.appendChild(l);t.querySelector(".e-media-content-div").style.width="100%"},r.prototype._addCssClass=function(){this._addClass(this._mediaDiv,this.model.cssClass)},r.prototype._addCenterPlayBtn=function(n){var r=this._id,t,u,i=this;t=this._createElement("div",r+"_centerPlay","e-media-toolbar-icon e-media-center-icon e-media-center-play e-icon",!1);u=this._createElement("div",r+"_cPlayAnimation","e-media-play-animation center e-hide",!1);t.appendChild(u);t.title=this._getLocaleString("Play");n.appendChild(t);t.addEventListener("click",function(n){i._preventDefault(n);i._mediaToolBarClick(n,!1)});t.addEventListener("touchend",function(n){i._allowTouchEvent(n)&&(i._preventDefault(n),i._mediaToolBarClick(n,!0))})},r.prototype._renderYTPlayer=function(n){var r=this,t,i;typeof YT=="undefined"||typeof YT.Player=="undefined"?(t=document.createElement("script"),t.src="https://www.youtube.com/iframe_api",i=document.getElementsByTagName("script")[0],i.parentNode.insertBefore(t,i),window.onYouTubeIframeAPIReady=function(){r._renderYTPlayerProgress(n)}):this._renderYTPlayerProgress(n)},r.prototype._renderYTPlayerProgress=function(n){var t=this,i=this._playlist[0],r=" ";i&&i.type==ej.MediaPlayer.Types.Youtube&&(r=this._getYTVideoIdFromUrl(i.url));t._processYoutubeAPI("destroy",null);new YT.Player(n,{videoId:r,playerVars:{controls:0,wmode:"transparent",rel:0,autohide:1,showinfo:0,enablejsapi:1,cc_load_policy:1,fs:1},events:{onReady:function(n){t._onYoutubePlayerReady(n)},onStateChange:function(n){t._onYoutubeStateChange(n)}}})},r.prototype._renderElementByType=function(n,t){for(var r=ej.MediaPlayer.Types,i=0;i<t.length;i++)t[i].type==r.Video?this._renderVideoElement(n):t[i].type==r.Audio?this._renderAudioElement(n):this._renderYoutubeElement(n)},r.prototype._renderVideoElement=function(n){var i=n.id,r=this,t,u,f;document.getElementById(i+"_video")||(t=this._createElement("video",i+"_video","e-media-element e-media-video",!1),n.querySelector(".e-media-content-div").appendChild(t),u=this._createElement("source",i+"_video_source","e-media-video-source",!1),u.setAttribute("type","video/mp4"),f=this._createElement("track",i+"_video_track","e-media-video-track",!1),t.appendChild(u),t.appendChild(f),t.setAttribute("preload","none"),t.addEventListener("playing",function(){r._playStarted=!1;r.hideWaitingPopup()},!1),t.addEventListener("waiting",function(){r.showWaitingPopup()},!1),t.addEventListener("canplaythrough",function(){r.hideWaitingPopup()},!1))},r.prototype._renderAudioElement=function(n){var t=n.id,i,r;document.getElementById(t+"_audio")||(i=this._createElement("audio",t+"_audio","e-media-element e-media-audio e-hide",!1),n.querySelector(".e-media-content-div").appendChild(i),r=this._createElement("source",t+"_audio_source","e-media-audio-source",!1),r.setAttribute("type","audio/mp3"),i.appendChild(r))},r.prototype._renderYoutubeElement=function(n){var t=n.id,i;document.getElementById(t+"_youtube")||(i=this._createElement("div",t+"_youtube","e-media-element e-media-youtube e-hide",!1),n.querySelector(".e-media-content-div").appendChild(i))},r.prototype._renderToolbar=function(){var t=this._id,i=this,n;n=this._createElement("div",t+"_controlContainer","e-media-control-container",!1);this._mediaDiv.appendChild(n);this.model.contentType==ej.MediaPlayer.ContentType.Audio?(this._renderBasicToolbar(n),this._addClass(this._mediaDiv.querySelector(".e-media-toolbar"),"audio")):this.model.renderMode==ej.MediaPlayer.RenderMode.Advanced?this._renderAdvancedToolbar(n):this.model.renderMode==ej.MediaPlayer.RenderMode.Mobile?this._renderMobileToolbar(n):this._renderBasicToolbar(n);this._renderSettingspopup()},r.prototype._getToolIconsTooltip=function(n){return this._containsClass(n,"e-media-play")?this._getLocaleString("Play"):this._containsClass(n,"e-media-pause")?this._getLocaleString("Pause"):this._containsClass(n,"e-media-forward")?this._getLocaleString("Forward"):this._containsClass(n,"e-media-backward")?this._getLocaleString("Rewind"):this._containsClass(n,"e-media-next")?this._getLocaleString("Next"):this._containsClass(n,"e-media-previous")?this._getLocaleString("Previous"):this._containsClass(n,"e-media-shuffle")?this._getLocaleString("Shuffle"):this._containsClass(n,"e-media-repeat")?this._getLocaleString("RepeatPlaylist"):this._containsClass(n,"e-media-volume")?this._containsClass(n,"media-muted")?this._getLocaleString("Unmute"):this._getLocaleString("Mute"):this._containsClass(n,"e-media-fullscreen")?this._getLocaleString("FullScreen"):this._containsClass(n,"e-media-smallscreen")?this._getLocaleString("ExitFullScreen"):this._containsClass(n,"e-media-settings")?this._getLocaleString("Settings"):this._containsClass(n,"e-media-playlist")?this._getLocaleString("Playlist"):void 0},r.prototype._renderTooltip=function(){var t,n=this,o,r,i,u,f,e;t=this._createElement("div",this._id+"_tooltip","e-media-time-tooltip e-hide");this._mediaDiv.appendChild(t);n=this;o=this._mediaDiv.querySelector(".e-media-timeslider");r=o.parentNode;r.addEventListener("mousemove",function(r){i=!1;r.movementX==0&&r.movementY==0&&(i=!0);!i&&n._containsClass(n._mediaDiv.querySelector(".e-media-settings-popup"),"e-hide")?(u=n._getHoverTime(r),t.innerHTML=n._getTimeFromSeconds(u),n._isValidTooltipTime(u)?n._setTooltipPosition(r):n._addClass(t,"e-hide")):n._addClass(t,"e-hide")});r.addEventListener("mouseleave",function(){n._addClass(t,"e-hide")});f=this._mediaDiv.querySelector(".e-media-toolbar");f.addEventListener("mousemove",function(r){e=n._getToolIconsTooltip(r.target);i=!1;r.movementX==0&&r.movementY==0&&(i=!0);!i&&e&&n._containsClass(n._mediaDiv.querySelector(".e-media-settings-popup"),"e-hide")&&(n._containsClass(r.target,"e-media-toolbar-icon")||n._closest(r.target,".e-media-toolbar-icon"))?(t.innerHTML=e,n._setTooltipPosition(r)):n._containsClass(r.target,"e-slider-wrap")||n._closest(r.target,".e-slider-wrap")||n._addClass(t,"e-hide")});f.addEventListener("mouseleave",function(){n._addClass(t,"e-hide")})},r.prototype._isValidTooltipTime=function(n){return n==0&&this._mediaDiv.querySelector(".e-media-timeslider").querySelector(".e-handle").style.left!="0%"?!1:!0},r.prototype._hideTooltip=function(){this._addClass(this._mediaDiv.querySelector(".e-media-time-tooltip"),"e-hide")},r.prototype._setTooltipPosition=function(n){var u,e,f,t,r,i;u=this._mediaDiv.querySelector(".e-media-time-tooltip");this._removeClass(u,"e-hide");e=this._mediaDiv.querySelector(".e-media-timeslider");f=this._mediaDiv.getBoundingClientRect();t=this._mediaDiv.querySelector(".e-media-control-container").getBoundingClientRect();r=u.getBoundingClientRect();i=n.clientX-t.left-r.width/2;this.model.renderMode!=ej.MediaPlayer.RenderMode.Basic||this._containsClass(this._mediaDiv.querySelector(".e-media-toolbar-volume-li"),"e-hide")||(i-=35);i+t.left>=t.left&&i+r.width<=t.width+t.left&&(Math.abs(i+r.width)>Math.abs(t.width)&&(i=t.width-r.width),u.style.left=i+"px");u.style.top=t.top-f.top-r.height-5+"px"},r.prototype._updateAudioContent=function(){this.model.contentType==ej.MediaPlayer.ContentType.Audio&&(this._addClass(this._mediaDiv.querySelector(".e-media-playlist-container"),"e-hide"),this._addClass(this._mediaDiv.querySelector(".e-media-video-baner"),"e-hide"),this._addClass(this._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-hide"),this._addClass(this._mediaDiv.querySelector(".e-media-toolbar-settings-li"),"e-hide"),this._addClass(this._mediaDiv.querySelector(".e-media-toolbar-fullscreen-li"),"e-hide"),this._mediaDiv.style.height=this.model.toolbarHeight,this._mediaDiv.querySelector(".e-media-control-container").style.width="100%")},r.prototype._updateToolbarHeight=function(){var t=this._mediaDiv,f=this.model.toolbarHeight,n,i,r,u;t.querySelector(".e-media-control-container").style.height=f;n=t.querySelector(".e-media-content-div");i=t.querySelector(".e-media-video-baner").getBoundingClientRect().height;this.model.autoHide?(n.style.top="0px",n.style.height="100%"):(u=t.querySelector(".e-media-control-container").getBoundingClientRect().height,n.style.height="calc(100% - "+(u+i)+"px)",n.style.top=i+"px");r=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-content-div"),"WaitingPopup");r&&r.setModel({appendTo:".e-media-content-div"})},r.prototype._allowTouchEvent=function(n){if(this._closest(n.target,".e-slider-wrap")){if(this._browserInfo.name=="chrome"&&this._containsClass(this._closest(n.target,".e-media-toolbar-icon"),"e-media-fullscreen"))return!1}else return!1;return!0},r.prototype._renderBasicToolbar=function(n){var r=this._id,t=this,i;i=this._createElement("div",r+"_playerToolbar","e-media-toolbar basic",!1);n.appendChild(i);this._renderBasicToolbarControls(i);i.addEventListener("click",function(n){t._closest(n.target,".e-slider-wrap")||t._preventDefault(n);t._mediaToolBarClick(n,!1)});i.addEventListener("touchend",function(n){t._allowTouchEvent(n)&&(t._closest(n.target,".e-slider-wrap")||t._preventDefault(n),t._mediaToolBarClick(n,!0))});this._renderTimeSlider(this._mediaDiv.querySelector(".e-media-timeslider"));this._renderBasicVolSlider(this._mediaDiv.querySelector(".e-media-volume-slider"))},r.prototype._renderBasicVolSlider=function(n){var t=this;this._renderEJControls(n,"Slider",{showRoundedCorner:!0,allowMouseWheel:!0,animationSpeed:t._sliderAnimation,orientation:ej.Orientation.Vertical,sliderType:ej.SliderType.MinRange,maxValue:100,value:t.model.volume||50,width:15,height:60,incrementStep:1});this._wireVolumeSliderEvts(n)},r.prototype._autoHideBasicVolSlider=function(){var t=this,n;n=parseInt(this.model.autoHideTime.toString())*1e3;window.clearTimeout(this._hideBasicVol);this._hideBasicVol=setTimeout(function(){t._hideBasicVolSlider()},n)},r.prototype._renderBasicToolbarControls=function(n){var t=this._id,i=this,r,u,p,o,w,f,b,s,k,h,d,c,g,l,nt,e,a,tt,v,it,y,rt,i=this,ut;r=this._createElement("ul",t+"_basicUl","e-media-toolbar-ul",!1);u=this._createElement("div",t+"_previousLi","e-media-toolbar-li e-media-prev-li basic",!1);p=this._createElement("div",t+"_previousIcon","e-media-toolbar-icon e-media-previous basic e-icon",!1);u.appendChild(p);u.title=this._getLocaleString("Previous");o=this._createElement("li",t+"_playLi","e-media-toolbar-li e-media-play-li",!1);w=this._createElement("div",t+"_playIcon","e-media-toolbar-icon e-media-play e-icon",!1);o.appendChild(w);f=this._createElement("div",t+"_nextLi","e-media-toolbar-li e-media-next-li basic",!1);b=this._createElement("div",t+"_nextIcon","e-media-toolbar-icon e-media-next basic e-icon",!1);f.appendChild(b);f.title=this._getLocaleString("Next");s=this._createElement("li",t+"_timeStartTextLi","e-media-toolbar-li e-media-toolbar-time-run-li",!1);k=this._createElement("div",t+"_timeStamp","e-media-time-stamp-run e-media-basic",!1);s.appendChild(k);h=this._createElement("li",t+"_timeLi","e-media-toolbar-li e-media-time-li",!1);d=this._createElement("div",t+"_timeSlider","e-media-timeslider e-media-basic",!1);h.appendChild(d);c=this._createElement("div",t+"_volumeSliderLi","e-media-toolbar-volume-li e-media-vol-slider-li e-hide",!1);g=this._createElement("div",t+"_volumeSliderIcon","e-media-volume-slider",!1);c.appendChild(g);l=this._createElement("li",t+"_timeTextLi","e-media-toolbar-li e-media-toolbar-time-icon-li",!1);nt=this._createElement("div",t+"_timeStamp","e-media-time-stamp-end e-media-basic",!1);l.appendChild(nt);e=this._createElement("li",t+"_rightLi","e-media-toolbar-li e-media-toolbar-right-li",!1);a=this._createElement("div",t+"_volumeLi","e-media-toolbar-right-div e-media-toolbar-volume-icon-li e-media-lp-icons",!1);tt=this._createElement("div",t+"_volumeIcon","e-media-toolbar-icon e-media-volume e-icon",!1);a.appendChild(tt);e.appendChild(a);v=this._createElement("div",t+"_settingsLi","e-media-toolbar-right-div e-media-toolbar-settings-li e-media-lp-icons",!1);it=this._createElement("div",t+"_settingsIcon","e-media-toolbar-icon e-media-settings e-icon",!1);v.appendChild(it);e.appendChild(v);y=this._createElement("div",t+"_fullscreenLi","e-media-toolbar-right-div e-media-toolbar-fullscreen-li",!1);rt=this._createElement("div",t+"_fullscreenIcon","e-media-toolbar-icon e-media-fullscreen e-icon",!1);y.appendChild(rt);e.appendChild(y);r.appendChild(o);this.model.contentType!=ej.MediaPlayer.Types.Audio&&(this._mediaDiv.querySelector(".e-media-content-div").appendChild(u),this._mediaDiv.querySelector(".e-media-content-div").appendChild(f));r.appendChild(h);r.appendChild(s);r.appendChild(l);r.appendChild(e);n.appendChild(r);n.appendChild(c);this._mediaDiv.querySelector(".e-media-toolbar.basic").querySelector(".e-media-volume").addEventListener("touchstart",function(n){n.preventDefault();ut=i._mediaDiv.querySelector(".e-media-vol-slider-li");i._containsClass(ut,"e-hide")?i._showBasicVolSlider():i._handleMuteBtnClick(i._getCurrentMedia(),this)});i._basicHoverIconEvents(u);i._basicHoverIconEvents(f)},r.prototype._basicHoverIconEvents=function(n){var t=this;n.addEventListener("click",function(n){t._preventDefault(n);t._mediaToolBarClick(n,!1)});n.addEventListener("touchend",function(n){t._closest(n.target,".e-slider-wrap")||t._preventDefault(n);t._mediaToolBarClick(n,!1)})},r.prototype._showBasicVolSlider=function(){var i=this._mediaDiv,n,t,r;n=i.querySelector(".e-media-toolbar.basic");n&&this._containsClass(this._mediaDiv.querySelector(".e-media-settings-popup"),"e-hide")&&(t=n.querySelector(".e-media-vol-slider-li"),this._removeClass(t,"e-hide"),r=n.querySelector(".e-media-volume").getBoundingClientRect(),t.style.left=(r.left-i.getBoundingClientRect().left).toString()+"px",this._autoHideBasicVolSlider())},r.prototype._hideBasicVolSlider=function(){var t=this._mediaDiv.querySelector(".e-media-toolbar.basic"),n;t&&(n=t.querySelector(".e-media-vol-slider-li"),this._closest(document.activeElement,".e-media-vol-slider-li")||this._containsClass(n,"e-hide")||this._addClass(n,"e-hide"))},r.prototype._renderAdvancedToolbar=function(n){var t=this._id,i=this,f,e,u,o,s,r;f=this._createElement("div",t+"_timeSliderDiv","e-media-time-li e-media-timeslider-div e-media-adv",!1);e=this._createElement("div",t+"_timeSlider","e-media-timeslider e-media-adv",!1);f.appendChild(e);u=this._createElement("div",t+"_timeStamp","e-media-time-stamp e-media-adv",!1);o=this._createElement("div",t+"_timeStamp_run","e-media-time-stamp-run e-media-adv",!1);s=this._createElement("div",t+"_timeStamp_end","e-media-time-stamp-end e-media-adv",!1);u.appendChild(o);u.appendChild(s);n.appendChild(f);n.appendChild(u);this._renderTimeSlider(e);r=this._createElement("div",t+"_playerToolbar","e-media-toolbar adv",!1);this._renderToolbarControls(r);r.addEventListener("click",function(n){i._closest(n.target,".e-slider-wrap")||i._preventDefault(n);i._mediaToolBarClick(n,!1)});r.addEventListener("touchend",function(n){i._allowTouchEvent(n)&&(i._closest(n.target,".e-slider-wrap")||i._preventDefault(n),i._mediaToolBarClick(n,!1))});n.appendChild(r);n.style.minHeight="70px";this._renderVolumeSlider(r.querySelector("#"+t+"_volumeSliderIcon"))},r.prototype._setLowPriorityIconsVisibility=function(){var u,n,i,r,f,e,t;if(u=this._mediaDiv.querySelector(".e-media-control-container"),this.model.renderMode==ej.MediaPlayer.RenderMode.Advanced?n=450:this.model.renderMode==ej.MediaPlayer.RenderMode.Basic&&(n=350),n){for(i=this._mediaDiv.querySelector(".e-media-content-div").getBoundingClientRect().width,r=u.querySelectorAll(".e-media-lp-icons"),t=0;t<r.length;t++)i<n?this._addClass(r[t],"e-hide"):this._removeClass(r[t],"e-hide");this.model.renderMode==ej.MediaPlayer.RenderMode.Basic?(f=this._mediaDiv.querySelector(".e-media-toolbar"),i<n?this._addClass(f,"fullscreen"):this._removeClass(f,"fullscreen")):(e=u.querySelector(".e-media-lp-set-icon"),i<250?this._addClass(e,"e-hide"):this._removeClass(e,"e-hide"))}},r.prototype._renderVolumeSlider=function(n){var t=this;this._renderEJControls(n,"Slider",{showRoundedCorner:!0,animationSpeed:t._sliderAnimation,sliderType:ej.SliderType.MinRange,maxValue:100,value:t.model.volume||50,height:6,incrementStep:1});this._wireVolumeSliderEvts(n)},r.prototype._wireVolumeSliderEvts=function(n){var t=this,i=this._closest(n,".e-slider-wrap");i.addEventListener("mousedown",function(){t._volSliderClick=!0});i.addEventListener("touchstart",function(){t._volSliderClick=!0});i.addEventListener("MSPointerDown",function(n){n.pointerType=="touch"&&(t._volSliderClick=!0)});i.addEventListener("touchmove",function(n){t._volSliderTouchMove(n)});i.addEventListener("MSPointerMove",function(n){n.pointerType=="touch"&&t._volSliderTouchMove(n)})},r.prototype._volSliderTouchMove=function(n){var i=this._getTouchVolume(n),t;t=this._getEJControlInstance(n.target.querySelector(".e-media-volume-slider"),"Slider");t&&i&&t.option("value",i)},r.prototype._getTouchVolume=function(n){var r=100,t,i;return t=this._closest(n.target,".e-media-timeslider")||n.target.querySelector(".e-media-timeslider"),t?(i=(n.touches[0].clientX-t.getBoundingClientRect().left)/t.getBoundingClientRect().width*parseInt(r),i>r&&(i=r),i):void 0},r.prototype._renderTimeSlider=function(n){var t=this,u=this._sliderAnimation,r,i;this._renderEJControls(n,"Slider",{showRoundedCorner:!0,animationSpeed:u,showTooltip:!1,sliderType:ej.SliderType.MinRange,maxValue:100,width:"100%",height:"20px",incrementStep:1});r=this._closest(n,".e-slider-wrap");i=r.querySelector(".e-handle");this._sliderLeft=parseFloat(i.style.marginLeft)+parseFloat(this._timeSliderSize)/2+"px";this.model.renderMode==ej.MediaPlayer.RenderMode.Basic&&(this._sliderLeft=parseFloat(this._sliderLeft)+parseFloat(this._timeSliderSize)+"px");r.addEventListener("mousedown",function(n){t._timeSliderMouseDown(n)});r.addEventListener("touchstart",function(n){t._setSliderHeaderSize(i);setTimeout(function(){t._removeClass(i,"e-hide");i.style.display="block"},t._animationSpeed);t._timeSliderMouseDown(n)});r.addEventListener("MSPointerDown",function(n){n.pointerType=="touch"&&(t._setSliderHeaderSize(i),setTimeout(function(){t._removeClass(i,"e-hide");i.style.display="block"},t._animationSpeed),t._timeSliderMouseDown(n))});r.addEventListener("touchmove",function(n){t._timeSliderTouchMove(n)});r.addEventListener("MSPointerMove",function(n){n.pointerType=="touch"&&t._timeSliderTouchMove(n)});r.addEventListener("mouseenter",function(){t._showTimeSliderHead(this)});this._browserInfo.name.toLowerCase()!="msie"&&r.addEventListener("mouseleave",function(){t._hideTimeSliderHead(this)});r.addEventListener("MSPointerLeave",function(n){n.pointerType!="touch"&&t._hideTimeSliderHead(this)});r.addEventListener("mousemove",function(){t._containsClass(i,"e-hide")&&(t._stopAnimation(i),i.style.width=i.style.height=t._timeSliderSize,i.style.top="-50%",i.style.marginLeft=t._sliderLeft,t._removeClass(i,"e-hide"))});this._addClass(i,"e-hide");this._hideTimeSliderHead(r)},r.prototype._setSliderHeaderSize=function(n){this._containsClass(n,"e-hide")&&(n.style.width=n.style.height=this._timeSliderSize,n.style.top="-50%",this._removeClass(n,"e-hide"))},r.prototype._showTimeSliderHead=function(n){var t=n.querySelector(".e-handle");this._stopAnimation(t);t.style.width=t.style.height="0px";this._removeClass(t,"e-hide");this._animate(t,{width:this._timeSliderSize,height:this._timeSliderSize,top:"-50%","margin-left":this._sliderLeft},100,null)},r.prototype._hideTimeSliderHead=function(n){var t,u=this,r,i;t=n.querySelector(".e-handle");!this._timeSliderClick&&this._containsClass(this._mediaDiv,"e-media-mouse")&&(r=parseFloat(t.style.marginLeft)+parseFloat(t.style.width)/2,i="100%",this.model.renderMode==ej.MediaPlayer.RenderMode.Basic&&(i="150%"),this._animate(t,{width:"0px",height:"0px",top:i,"margin-left":r+"px"},100,function(){u._addClass(t,"e-hide")}))},r.prototype._timeSliderTouchMove=function(n){var i=this._getTouchTime(n),t;t=this._getEJControlInstance(n.target.querySelector(".e-media-timeslider"),"Slider");t&&i&&(this._addClass(n.target.querySelector(".e-handle"),"e-media-slider-size"),t.option("value",i))},r.prototype._getTouchTime=function(n){var t,i,u,r;return t=this._getMediaDuration(this._getCurrentMedia()),i=this._closest(n.target,".e-media-timeslider")||n.target.querySelector(".e-media-timeslider"),i?(u=n.touches&&n.touches.length>0?n.touches[0].clientX:n.clientX,r=(u-i.getBoundingClientRect().left)/i.getBoundingClientRect().width*parseInt(t),r>t&&(r=t),r):void 0},r.prototype._timeSliderMouseDown=function(n){var i,t,r;this._mediaDiv.querySelector(".e-media-control-container").style.opacity!="0"&&(this._timeSliderClick=!0,i=this._closest(n.target,".e-handle"),(n.type=="touchstart"||n.pointerType=="touch")&&i&&this._addClass(i,"e-media-slider-size"),window.clearInterval(this._playTimer),t=this._getCurrentMedia(),r=this._isYoutubeElement(t),r||t.paused?r&&this._processYoutubeAPI("getPlayerState",null)=="1"&&(this._pausedManual=!0,this._processYoutubeAPI("pauseVideo",null)):(this._pausedManual=!0,this._pauseMedia(t)))},r.prototype._getHoverTime=function(n){var r=this._getMediaDuration(this._getCurrentMedia()),t,i;return t=this._closest(n.target,".e-media-timeslider")||n.target.querySelector(".e-media-timeslider"),t?(i=(n.clientX-t.getBoundingClientRect().left)/t.getBoundingClientRect().width*parseInt(r),i>r&&(i=r),i):void 0},r.prototype._renderToolbarControls=function(n){this._renderPlayerGroup(n);this._renderSettingsGroup(n)},r.prototype._renderSettingsGroup=function(n){var i=this._id,t,r,u;t=this._createElement("ul",i+"_settingsGroup","e-media-toolbar-ul e-media-toolbar-settingsgroup",!1);r=this._createElement("li",i+"_settingsIcon","e-media-toolbar-icon e-media-settings e-icon e-media-lp-set-icon",!1);u=this._createElement("li",i+"_fullscreenIcon","e-media-toolbar-icon e-media-fullscreen e-icon",!1);t.appendChild(r);t.appendChild(u);n.appendChild(t)},r.prototype._renderPlayerGroup=function(n){var t=this._id,i,e,o,s,h,c,l,r,u,a,f,v,y,p;i=this._createElement("ul",t+"_playGroup","e-media-toolbar-ul e-media-toolbar-playgroup",!1);e=this._createElement("li",t+"_playIcon","e-media-toolbar-icon e-media-play e-icon",!1);o=this._createElement("li",t+"_backwardIcon","e-media-toolbar-icon e-media-backward e-icon e-media-lp-icons",!1);h=this._createElement("li",t+"_forwardIcon","e-media-toolbar-icon e-media-forward e-icon e-media-lp-icons",!1);s=this._createElement("li",t+"_previousIcon","e-media-toolbar-icon e-media-previous e-icon",!1);c=this._createElement("li",t+"_nextIcon","e-media-toolbar-icon e-media-next e-icon",!1);l=this._createElement("li",t+"_playlistIcon","e-media-toolbar-icon e-media-playlist e-icon",!1);r=this._createElement("li",t+"_repeatIcon","e-media-toolbar-icon e-media-repeat e-icon e-media-lp-icons",!1);this.model.repeat&&this._addClass(r,"media-repeated");u=this._createElement("li",t+"_shuffleIcon","e-media-toolbar-icon e-media-shuffle e-icon e-media-lp-icons",!1);this.model.shuffle&&this._addClass(u,"media-shuffled");a=this._createElement("li",t+"_volumeIcon","e-media-toolbar-icon e-media-volume e-icon",!1);f=this._createElement("li",t+"_volumeSliderLi","e-media-toolbar-icon e-media-volume-slider-li e-media-lp-icons",!1);v=this._createElement("div",t+"_volumeSliderIcon","e-media-volume-slider",!1);f.appendChild(v);i.appendChild(e);y=this._createElement("li",t+"_splitIcon1","e-media-toolbar-split",!1);i.appendChild(y);i.appendChild(s);i.appendChild(o);i.appendChild(h);i.appendChild(c);p=this._createElement("li",t+"_splitIcon2","e-media-toolbar-split",!1);i.appendChild(p);i.appendChild(l);i.appendChild(r);i.appendChild(u);i.appendChild(a);i.appendChild(f);n.appendChild(i)},r.prototype._renderMobileToolbar=function(n){var t=this._id,i=this,f,r,e,o,u,s,a,h,v,c,y,l,p;f=this._createElement("div",t+"_mplayerToolbar","e-media-toolbar mob",!1);n.appendChild(f);r=this._createElement("ul",t+"_mobPlayUl","e-media-toolbar-ul mob-playGroup",!1);e=this._createElement("li",t+"_mpreviousIcon","e-media-toolbar-icon e-media-previous e-icon",!1);e.title=this._getLocaleString("Previous");o=this._createElement("li",t+"_mnextIcon","e-media-toolbar-icon e-media-next e-icon",!1);o.title=this._getLocaleString("Next");r.appendChild(e);r.appendChild(o);this._mediaDiv.querySelector(".e-media-content-div").appendChild(r);r.addEventListener("click",function(n){i._preventDefault(n);i._mediaToolBarClick(n,!1)});r.addEventListener("touchend",function(n){i._closest(n.target,".e-slider-wrap")||i._preventDefault(n);i._mediaToolBarClick(n,!1)});u=this._createElement("ul",t+"_mobUl","e-media-toolbar-ul toolGroup",!1);s=this._createElement("li",t+"_mtimeStartTextLi","e-media-toolbar-li e-media-toolbar-time-run-li",!1);a=this._createElement("div",t+"_mtimeStamp","e-media-time-stamp-run e-media-mob",!1);s.appendChild(a);h=this._createElement("li",t+"_mtimeLi","e-media-toolbar-li e-media-time-li",!1);v=this._createElement("div",t+"_mtimeSlider","e-media-timeslider e-media-mob",!1);h.appendChild(v);c=this._createElement("li",t+"_mtimeTextLi","e-media-toolbar-li e-media-toolbar-time-icon-li",!1);y=this._createElement("div",t+"_mtimeStamp","e-media-time-stamp-end e-media-mob",!1);c.appendChild(y);l=this._createElement("li",t+"_mfullscreenLi","e-media-toolbar-li e-media-toolbar-fullscreen-li",!1);p=this._createElement("div",t+"_mfullscreenIcon","e-media-toolbar-icon e-media-fullscreen e-icon",!1);l.appendChild(p);u.appendChild(s);u.appendChild(h);u.appendChild(c);u.appendChild(l);f.appendChild(u);f.addEventListener("click",function(n){i._closest(n.target,".e-slider-wrap")||i._preventDefault(n);i._mediaToolBarClick(n,!1)});f.addEventListener("touchend",function(n){i._allowTouchEvent(n)&&(i._closest(n.target,".e-slider-wrap")||i._preventDefault(n),i._mediaToolBarClick(n,!1))});this._renderTimeSlider(this._mediaDiv.querySelector(".e-media-timeslider"))},r.prototype._renderSettingspopup=function(){var r=this._id,t,i,n;t=this._createElement("div",r+"_settingsPopup","e-media-settings-popup e-hide",!1);i='<ul><li data-ej-text="Speed" class="e-media-settings-speed"><ul class="e-media-settings-speed-ul"><li data-ej-text="0.25"><\/li><li data-ej-text="0.5"><\/li><li data-ej-text="0.75"><\/li><li data-ej-text="Normal"><\/li><li data-ej-text="1.25"><\/li><li data-ej-text="1.5"><\/li><li data-ej-text="1.75"><\/li><li data-ej-text="2"><\/li><\/ul><\/li><li data-ej-text="Quality" class="e-media-settings-quality"><ul class="e-media-settings-quality-ul"><li data-ej-text="1080p"><\/li><li data-ej-text="720p"><\/li><li data-ej-text="480p"><\/li><li data-ej-text="360p"><\/li><li data-ej-text="240p"><\/li><li data-ej-text="Auto"><\/li><\/ul><\/li><\/ul>';t.innerHTML=i;this._mediaDiv.appendChild(t);n=this._mediaDiv.querySelector(".e-media-settings-popup");this._renderSettingsListView(n);this._addQualityHDTag(n);this._addSettingsOverlay(n)},r.prototype._addSettingsOverlay=function(){var t,n;t=this._createElement("div",this._id+"_settingsOverlay","e-media-settings-overlay e-hide",!1);n=this._getSettingsGroupByType("speed");n&&n.appendChild(t)},r.prototype._addQualityHDTag=function(n){var u,t,i,f,r,e;u=n.querySelector(".e-media-settings-quality").getAttribute("data-childid");t=n.querySelector("#"+u);t&&(i=this._createElement("span",null,"e-media-hd-tag"),i.innerHTML="HD",f=t.querySelectorAll("li")[0],f.appendChild(i),r=this._createElement("span",null,"e-media-hd-tag"),r.innerHTML="HD",e=t.querySelectorAll("li")[1],e.appendChild(r))},r.prototype._renderSubtitleButton=function(){var n=this;this._renderEJControls(this._mediaDiv.querySelector(".e-media-settings-subtitle-btn"),"Slider",{width:"25px",sliderType:ej.SliderType.MinRange,animationSpeed:100,value:1,minValue:0,maxValue:1,showRoundedCorner:!0,showTooltip:!1,incrementStep:1,change:function(t){n._handleSubtitleBtnClick(t)}})},r.prototype._renderSettingsListView=function(n){var t=this;this._renderEJControls(n,"ListView",{showHeader:!0,showHeaderBackButton:!0,headerTitle:"Settings",width:150,mouseDown:function(n){t._onSettingsPopupMouseDown(n,this);t._onSettingsPopupClick()},mouseUp:function(){t._onSettingsPopupMouseUp()}})},r.prototype._onSettingsPopupClick=function(){this._setPopupPosition(this._mediaDiv.querySelector(".e-media-settings-popup"))},r.prototype._onSettingsPopupMouseUp=function(){if(this._isSettingsClick){var n=this;setTimeout(function(){n._hideSettingsPopup(null);n._isSettingsClick=!1})}},r.prototype._onSettingsPopupMouseDown=function(n,t){var o=n.item,f,i,r,s,h,u,e,c,l=this;o&&o.length&&(f=o[0],i=this._closest(f,".subpage"),h=this._closest(f,".e-list-text")||f.querySelector(".e-list-text"),i&&h&&!this._containsClass(f,"disabled")&&(r=this._getSettingsHeaderText(i,t),u=this._getCurrentMedia(),s=this._isYoutubeElement(u),e=h.innerText,this._containsClass(i,"e-childitem")?r.toLowerCase()=="speed"?(c=e==ej.MediaPlayer.SpeedText.Normal?1:parseFloat(e),this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),speed:this.model.playSpeed,actionType:"speedChange"}),this._setPlayerSpeed(u,c,s),this._isSettingsClick=!0,this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),speed:this.model.playSpeed,actionType:"speedChange"})):r.toLowerCase()=="quality"&&(this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),quality:this._getPlayerQuality(u),actionType:"qualityChange"}),this._setMediaQuality(u,e,s),this._isSettingsClick=!0,this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),quality:this._getPlayerQuality(u),actionType:"qualityChange"})):(r=e,i=this._getSettingsGroupByType(r),setTimeout(function(){i.querySelector(".e-btn-text").innerText=r},200))))},r.prototype._getSettingsHeaderText=function(n){var t="Settings";return n.innerHTML.indexOf(ej.MediaPlayer.SpeedText.Normal)!=-1?t="Speed":n.innerHTML.indexOf(ej.MediaPlayer.QualityText.Auto)!=-1&&(t="Quality"),t},r.prototype._expandToolbar=function(n){var t;this._fadeIn(this._mediaDiv.querySelector(".e-media-control-container"));t=this._mediaDiv.querySelector(".e-media-video-baner");this.model.showPlaylist&&this.model.renderMode!=="mobile"&&this._fadeIn(this._mediaDiv.querySelector(".e-media-playlist-toggle"));this._getCurrentMedia()instanceof HTMLAudioElement==!1&&this.model.showTitle?(this._removeClass(t,"e-hide"),this._fadeIn(t)):this._addClass(t,"e-hide");this._collapseToolbar(n)},r.prototype._collapseToolbar=function(n){var t=this,i;i=parseInt(this.model.autoHideTime.toString())*1e3;window.clearTimeout(this._autoHideTime);(!n||!t._closest(n.target,".e-media-control-container")||n&&n.touches)&&(t._autoHideTime=setTimeout(function(){t._fadeOut(t._mediaDiv.querySelector(".e-media-control-container"));t._fadeOut(t._mediaDiv.querySelector(".e-media-video-baner"));t.model.showPlaylist&&t.model.renderMode!=="mobile"&&t._fadeOut(t._mediaDiv.querySelector(".e-media-playlist-toggle"))},i))},r.prototype._renderPlaylist=function(){var n=this._id,u,r,f,c,e,o,l,a,v,y,s,i,t=this,h,p,w,b;u=this.model.renderMode==ej.MediaPlayer.RenderMode.Mobile?"mobile":"desktop";r=this._createElement("div",n+"_playlistContainer","e-media-playlist-container "+u+" e-hide",!1);f=this._createElement("div",n+"_playlistHeader","e-media-playlist-header",!1);c=this._createElement("div",n+"_playlistTitle","e-media-playlist-title",!1);e=this._createElement("div",n+"_playlistNav","e-media-playlist-navigation",!1);o=this._createElement("div",n+"_playlistClose","e-media-playlist-close e-icon",!1);o.title=this._getLocaleString("HidePlaylist");f.appendChild(c);this.model.renderMode!=ej.MediaPlayer.RenderMode.Mobile&&f.appendChild(o);f.appendChild(e);l=this._createElement("label",n+"_playlistLabel","e-media-playlist-header-label",!1);a=this._createElement("span",n+"_playlistPrevious","e-media-playlist-icon e-media-playlist-header-previous e-icon",!1);a.title=this._getLocaleString("Previous");v=this._createElement("span",n+"_playlistNext","e-media-playlist-icon e-media-playlist-header-next e-icon",!1);v.title=this._getLocaleString("Next");e.appendChild(l);r.appendChild(f);y=this._createElement("div",n+"_playlist","e-media-playlist-div",!1);r.appendChild(y);s=this._createElement("div",n+"_playlist_toggle","e-media-playlist-toggle "+u+" e-media-collapse e-icon e-hide",!1);s.title=this._getLocaleString("TogglePlaylist");i=this._mediaDiv;i.appendChild(s);i.appendChild(r);h=this._playlist;i=this._mediaDiv;p=i.getBoundingClientRect();w=this.model.renderMode==ej.MediaPlayer.RenderMode.Mobile?this._playlist.length*52:parseInt(p.height.toString())-45;this._renderEJControls(i.querySelector(".e-media-playlist-div"),"ListBox",{dataSource:t._dataSource,width:"100%",itemHeight:"52px",height:w,select:function(n){t._playlistItemClick(n)},create:function(){t._updateListBoxScroller()},template:'<div class="e-media-playlist-item" title="${title}"><label class="e-media-playlist-number">${number}<\/label><div class="e-media-playlist-img-div '+u+'"><div class="e-media-playlist-img" style="background-image:url(${posterUrl})"><\/div><div class="e-media-playlist-play e-icon"><\/div><\/div><div class="e-media-playlist-title-div '+u+'"><div class="e-media-playlist-name"> ${title} <\/div><div class="e-media-playlist-author">${author}<\/div><\/div>'});h.length>0&&(this._setPlaylistHeaderText("1/"+h.length),b=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-playlist-div"),"ListBox"),b.selectItemByIndex(0));i.querySelector(".e-media-playlist-toggle").addEventListener("click",function(){t._togglePlaylist()});this.model.renderMode!=ej.MediaPlayer.RenderMode.Mobile&&i.querySelector(".e-media-playlist-close").addEventListener("click",function(){t._hidePlaylist();t._removeClass(t._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-hide");t._mediaDiv.querySelector(".e-media-playlist-container").style.display="none"});i.querySelector(".e-media-playlist-title").innerText=this.model.playlistTitle;r.addEventListener("click",function(){t.focus()});r.addEventListener("touchend",function(){t.focus()})},r.prototype._updateListBoxScroller=function(){var n=this,t;setTimeout(function(){t=n._getEJControlInstance(n._mediaDiv.querySelector(".e-media-playlist-div"),"ListBox");t._refreshScroller()},500)},r.prototype._generatePlayerData=function(){this._addPlaylistItemsAjax([],0,this._playlist.length)},r.prototype._addYoutubePlaylistData=function(n,t,i){var r;n&&n.items&&n.items[0]&&n.items[0].snippet&&(r=n.items[0].snippet,t.author=r.channelTitle,t.title=r.title,r.thumbnails&&r.thumbnails["default"]&&(t.posterUrl=r.thumbnails["default"].url),t.number=i+1)},r.prototype._addDefaultPlaylistValue=function(n,t){n.title||(n.title=this._getLocaleString("Media"));0+(t+1);n.posterUrl||(n.posterUrl="");n.author||(n.author="");n.number=t+1},r.prototype._addNextPlaylistItem=function(n,t,i){n.push(t);i=i+1;i==length?this._generatePlaylistData(n):this._addPlaylistItemsAjax(n,i,length)},r.prototype._togglePlaylist=function(){this._containsClass(this._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-media-expand")?this._collapsePlaylist():this._expandPlaylist()},r.prototype._expandPlaylist=function(){if(this.model.contentType!=ej.MediaPlayer.ContentType.Audio){var t,i,r,u,f,n=this;t=this._mediaDiv.querySelector(".e-media-playlist-container");i=this._mediaDiv.querySelector(".e-media-playlist-toggle");this._addClass(i,"e-media-expand");this._removeClass(i,"e-media-collapse");this._containsClass(t,"desktop")?(r=this._mediaDiv.querySelector(".e-media-video-baner"),u=this._mediaDiv.querySelector(".e-media-content-div"),f=this._mediaDiv.querySelector(".e-media-control-container"),n._hideWaitingPopup(),this._animate(t,{width:n._playlistWidth},null,function(){n._removeClass(t.querySelector(".e-media-playlist-header"),"e-hide");n._removeClass(t.querySelector(".e-ddl-popup"),"e-hide");n._setLowPriorityIconsVisibility();t.style.display="block";n._showWaitingPopup()}),this._animate(u,{width:100-parseFloat(n._playlistWidth.toString())+"%"},null,null),this._animate(f,{width:100-parseFloat(n._playlistWidth.toString())+"%"},null,null),this._animate(i,{right:n._playlistWidth},null,null),r&&this._animate(r,{width:100-parseFloat(n._playlistWidth.toString())+"%"},null,null),this._updateListBoxScroller()):this._animate(t.querySelector(".e-ddl-popup"),{height:t.querySelector(".e-listbox-container").getBoundingClientRect().height},null,null)}},r.prototype._collapsePlaylist=function(){if(this.model.contentType!=ej.MediaPlayer.ContentType.Audio){var n,i,r,u,f,t=this;n=this._mediaDiv.querySelector(".e-media-playlist-container");i=this._mediaDiv.querySelector(".e-media-playlist-toggle");this._removeClass(i,"e-media-expand");this._addClass(i,"e-media-collapse");this._containsClass(n,"desktop")?(r=this._mediaDiv.querySelector(".e-media-video-baner"),u=this._mediaDiv.querySelector(".e-media-content-div"),f=this._mediaDiv.querySelector(".e-media-control-container"),t._addClass(n.querySelector(".e-media-playlist-header"),"e-hide"),t._addClass(n.querySelector(".e-ddl-popup"),"e-hide"),t._hideWaitingPopup(),this._animate(n,{width:"0%"},null,function(){t._removeClass(n.querySelector(".e-media-playlist-header"),"e-hide");t._removeClass(n.querySelector(".e-ddl-popup"),"e-hide");t._setLowPriorityIconsVisibility();t._showWaitingPopup()}),this._animate(u,{width:"100%"},null,null),this._animate(f,{width:"100%"},null,null),this._animate(i,{right:"0%"},null,null),r&&this._animate(r,{width:"100%"},null,null),this._updateListBoxScroller()):this._animate(n.querySelector(".e-ddl-popup"),{height:"0px"},null,null)}},r.prototype._playlistItemClick=function(n){var i=n.index,t,r,u;t=this._getCurrentMedia();i!=this._mediaIndex?(r=this._mediaDiv.querySelector(".e-media-playlist-header-previous"),u=this._mediaDiv.querySelector(".e-media-playlist-header-next"),i==0?this._addClass(r,"disabled"):this._removeClass(r,"disabled"),i==this._playlist.length-1?this._addClass(u,"disabled"):this._removeClass(u,"disabled"),this._playVideoByIndex(t,i,!0),this._setPlaylistHeaderText(i+1+"/"+this._playlist.length)):t&&(this._seekVideo(t,0,this._isYoutubeElement(t)),this._updateTimeSlider(t,null),this._updateTimeStamp(t))},r.prototype._setPlaylistHeaderText=function(n){this._mediaDiv.querySelector(".e-media-playlist-header-label").innerText=n},r.prototype._selectPlaylistItemByType=function(n){var i,r,t;i=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-playlist-div"),"ListBox");r=i.model.selectedIndex||0;t=n=="previous"?r-1:r+1;t>=0&&t<this._playlist.length&&i.selectItemByIndex(t)},r.prototype._setPlaylistVisibility=function(){this._containsClass(this._mediaDiv.querySelector(".e-media-playlist-container"),"e-hide")?this._showPlaylist():this._hidePlaylist()},r.prototype._showPlaylist=function(){this._trigger("onTogglePlaylist",{mediaInfo:this._getCurrentMediaInfo(),visible:!1});this._removeClass(this._mediaDiv.querySelector(".e-media-playlist-container"),"e-hide");this._addClass(this._mediaDiv.querySelector(".e-media-playlist"),"e-media-playlist-visible");this.model.renderMode==ej.MediaPlayer.RenderMode.Mobile&&this._removeClass(this._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-hide");this._expandPlaylist()},r.prototype._hidePlaylist=function(){this._trigger("onTogglePlaylist",{mediaInfo:this._getCurrentMediaInfo(),visible:!0});this._collapsePlaylist();this._addClass(this._mediaDiv.querySelector(".e-media-playlist-container"),"e-hide");this._removeClass(this._mediaDiv.querySelector(".e-media-playlist"),"e-media-playlist-visible");this.model.renderMode==ej.MediaPlayer.RenderMode.Mobile&&this._addClass(this._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-hide")},r.prototype._setAllMediaProperties=function(){for(var r=this._mediaDiv.querySelector(".e-media-content-div").children,t,n,i=0;i<r.length;i++)n=r[i],this._containsClass(n,"e-media-element")&&(t=this._isYoutubeElement(n),t?(this._changeMediaSource(n),this._renderYTPlayer(n.id)):(this._setMediaSettings(n,t),this._changeMediaSource(n)));this._updateAutoPlay()},r.prototype._setMediaSettings=function(n,t){if(n){var i=this.model;this._setPlayerSpeed(n,i.playSpeed,t);this._repeat=i.repeat;this._mute=i.mute;this._shuffle=i.shuffle;this._setMute(n,i.mute,t);this._setVolume(n,i.volume,t)}},r.prototype._setMediaSource=function(n,t,i,r){if(i){if(!r||this.model.autoPlay){var u={mediaContentUrl:"https://www.youtube.com/v/"+this._getYTVideoIdFromUrl(t)+"?version=3",startSeconds:1};this._processYoutubeAPI("loadVideoByUrl",u)}}else n.setAttribute("src",t)},r.prototype._setSubtitle=function(n,t,i){i?this._setYoutubeSubtitle():n instanceof HTMLVideoElement&&this._setVideoSubtitle(n,t)},r.prototype._setYoutubeSubtitle=function(){this._subtitle?(this._processYoutubeAPI("loadModule","captions"),this._processYoutubeAPI("loadModule","cc")):(this._processYoutubeAPI("unloadModule","captions"),this._processYoutubeAPI("unloadModule","cc"))},r.prototype._setVideoSubtitle=function(n,t){if(this._subtitle){var i=n.querySelector("track");this._removeClass(i,"e-hide");t&&i.setAttribute("src",t)}else this._addClass(n.querySelector("track"),"e-hide")},r.prototype._setModelWidth=function(){this._mediaDiv.style.width=this.model.width;this._setToolbarIconSize()},r.prototype._setToolbarIconSize=function(){this._addClass(this._mediaDiv,"e-media-large-size")},r.prototype._setModelHeight=function(){this._mediaDiv.style.height=this.model.height},r.prototype._setPlayerSpeed=function(n,t,i){var r;i?this._processYoutubeAPI("setPlaybackRate",t):n.playbackRate=t;r=t==1?ej.MediaPlayer.SpeedText.Normal:t;this.model.playSpeed=t;this._updateSettingsSelector("Speed",r)},r.prototype._updateSettingsSelector=function(n,t){var e,i,f,r,u;if(e=this._mediaDiv.querySelector(".e-media-settings-popup").children,i=this._getSettingsGroupByType(n),i)for(this._removeClass(i.querySelector(".e-media-settings-selector"),"e-media-settings-selector"),f=i.querySelectorAll(".e-list-text"),u=0;u<f.length;u++)if(r=f[u],r.textContent.toLowerCase()==t.toString().toLowerCase()){this._addClass(r,"e-icon");this._addClass(r,"e-media-settings-selector");break}},r.prototype._getPlayerSpeed=function(n,t){return t?this._processYoutubeAPI("getPlaybackRate",null):n.playbackRate},r.prototype._getPlayerQuality=function(n){if(this._isYoutubeElement(n))return this._playQuality},r.prototype._setMediaQuality=function(n,t,i){if(i){var r=this._processYoutubeAPI("getVideoData",null),u;r&&(u=this._processYoutubeAPI("getCurrentTime",null),this._processYoutubeAPIMultiArgs("loadVideoById",r.video_id,u,ej.MediaPlayer.Quality[t]));this._updateSettingsSelector("Quality",t);this._playQuality=t}},r.prototype._setMute=function(n,t,i){i?t?this._processYoutubeAPI("mute",null):this._processYoutubeAPI("unMute",null):n.muted=t},r.prototype._setVolume=function(n,t,i){t>=0&&t<=100&&(i?this._processYoutubeAPI("setVolume",t):n.volume=t/100,this.model.volume=t)},r.prototype._getVolume=function(n,t){return t?this._processYoutubeAPI("getVolume",null):n.volume*100},r.prototype._setModelVolume=function(n,t,i){this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),volume:this.model.volume,actionType:"volumeChange"});this._setVolume(n,t,i);this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),volume:this.model.volume,actionType:"volumeChange"})},r.prototype._setModelMute=function(n,t,i){var r=t?"mute":"unmute";this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:r});this._setMute(n,t,i);this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:r})},r.prototype._setModelSpeed=function(n,t,i){this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),speed:this.getMediaSpeed(),actionType:"speedChange"});this._setPlayerSpeed(n,t,i);this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),speed:this.getMediaSpeed(),actionType:"speedChange"})},r.prototype._mediaToolBarClick=function(n,t){var i,u,r;this._hideSettingsPopup(n);i=this._closest(n.target,".e-media-toolbar-icon")||n.target.previousElementSibling;u=this._mediaDiv.querySelector(".e-media-control-container");i&&!this._containsClass(i,"disabled")&&u.style.opacity!="0"&&(r=this._getCurrentMedia(),this._containsClass(i,"e-media-play")||this._containsClass(i,"e-media-pause")||this._containsClass(i,"e-media-center-icon")?this._handlePlayIconClick(r):this._containsClass(i,"e-media-forward")?this._handleFwdBtnClick(r):this._containsClass(i,"e-media-backward")?this._handleBwdBtnClick(r):this._containsClass(i,"e-media-next")?this._handleNextBtnClick(r):this._containsClass(i,"e-media-previous")?this._handlePreviousBtnClick(r):this._containsClass(i,"e-media-shuffle")?this._handleShuffleBtnClick(i):this._containsClass(i,"e-media-repeat")?this._handleRepeatBtnClick(i):this._containsClass(i,"e-media-volume")?this._handleMuteBtnClick(r,i,t):this._containsClass(i,"e-media-stop")?this._handleStopBtnClick(r):this._containsClass(i,"e-media-fullscreen")||this._containsClass(i,"e-media-smallscreen")?this._handleScreenBtnClick(this._containsClass(i,"e-media-smallscreen")):this._containsClass(i,"e-media-settings")?this._showSettingsPopup(n):this._containsClass(i,"e-media-playlist")&&this._setPlaylistVisibility(),this._mediaDiv.querySelector(".e-media-time-tooltip").innerHTML=this._getToolIconsTooltip(n.target))},r.prototype._handlePlayIconClick=function(n){this._handlePlayAnimation();this._isYoutubeElement(n)?this._onClickYoutubePlay():(n instanceof HTMLVideoElement||n instanceof HTMLAudioElement)&&this._onToggleVideoPlay(n)},r.prototype._handlePlayAnimation=function(){var n,t,i=this;n=this._mediaDiv.querySelector(".e-media-play-animation.center");t=this._mediaDiv.querySelector(".e-media-center-icon");(t.style.display="none")&&this._fadePlayIcon();this._removeClass(n,"e-hide");setTimeout(function(){i._addClass(n,"e-hide")},500)},r.prototype._onClickYoutubePlay=function(){var t=this._processYoutubeAPI("getPlayerState",null),n;n=this._mediaDiv.querySelector(".e-media-center-play");n?this._playYoutubeVideo():this._pauseYoutubeVideo()},r.prototype._playYoutubeVideo=function(){var n={mediaInfo:this._getCurrentMediaInfo(),cancel:!1,actionType:"play"};this._pausedManual||this._onActionBegin(n);this._processYoutubeAPI("playVideo",null);this._addPauseClass();this._setAdvToolbarOverflow();this._pausedManual||this._onActionComplete(n)},r.prototype._pauseYoutubeVideo=function(n){var i={mediaInfo:this._getCurrentMediaInfo(),cancel:!1,actionType:"pause"},t=this;n||this._onActionBegin(i);this._processYoutubeAPI("pauseVideo",null);setTimeout(function(){t._addPlayClass();t._setAdvToolbarOverflow();n||t._onActionComplete(i)},100)},r.prototype._onToggleVideoPlay=function(n){n.paused?this._playMedia(n):this._pauseMedia(n)},r.prototype._playMedia=function(n){var t={mediaInfo:this._getCurrentMediaInfo(),cancel:!1,actionType:"play"};this._pausedManual||this._onActionBegin(t);t.cancel||(this._play(n),this._addPauseClass(),this._setAdvToolbarOverflow(),this._pausedManual||this._onActionComplete(t))},r.prototype._play=function(n){if(n){var t=this;t.promise=n.play();t.promise?t.promise.then(function(){t._playStarted=!1}):setTimeout(function(){t._playStarted=!1});t._playStarted=!0}},r.prototype._pauseMedia=function(n,t){var i={mediaInfo:this._getCurrentMediaInfo(),cancel:!1,actionType:"pause"};t||this._onActionBegin(i);i.cancel||(n.pause(),this._addPlayClass(),this._setAdvToolbarOverflow(),t||this._onActionComplete(i),window.clearInterval(this._playTimer))},r.prototype._setAdvToolbarOverflow=function(){var n=this._mediaDiv.querySelector(".e-media-toolbar-playgroup");n&&(n.style.opacity=.9,setTimeout(function(){n.style.opacity=1},0))},r.prototype._getCurrentMediaInfo=function(){var n=this._playlist;if(n.length>0)return n[this._mediaIndex]},r.prototype._seekVideo=function(n,t,i){var r=this._getMediaDuration(n);t<0?t=0:t>r&&(t=r);i?(window.clearInterval(this._playTimer),this._processYoutubeAPI("seekTo",t)):(n instanceof HTMLVideoElement||n instanceof HTMLAudioElement)&&(n.paused?(n.addEventListener("canplay",function(){n.currentTime=t}),this._updateTimeSlider(n,null),this._updateTimeStamp(n)):(this._pausedManual=!0,n.pause(),window.clearInterval(this._playTimer),n.currentTime=t-.001,this._play(n)));this._playTimer||this._updateTimeSlider(n,null);this._updateTimeStamp(n)},r.prototype._handleNextBtnClick=function(n){this._hidePlayGroup();this._playVideoByIndex(n,this._mediaIndex+1)},r.prototype._handlePreviousBtnClick=function(n){this._hidePlayGroup();this._playVideoByIndex(n,this._mediaIndex-1)},r.prototype._hidePlayGroup=function(){var n,t,i;n=this._mediaDiv.querySelector(".e-media-toolbar-ul.mob-playGroup");t=this._mediaDiv.querySelector(".e-media-prev-li.basic");i=this._mediaDiv.querySelector(".e-media-next-li.basic");n&&(n.style.display="none");t&&(t.style.display="none");i&&(i.style.display="none")},r.prototype._handleFwdBtnClick=function(n){this._forwardMedia(n,parseFloat(this.model.forwardTime.toString()))},r.prototype._handleBwdBtnClick=function(n){this._rewindMedia(n,parseFloat(this.model.rewindTime.toString()))},r.prototype._forwardMedia=function(n,t){var u=this._getMediaDuration(n),r,i,f;u||(u=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-timeslider"),"Slider").model.maxValue);this._getCurrentMediaTime(n)<u&&(this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:"forward"}),r=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-timeslider"),"Slider"),i=r.model.value+parseFloat(t),f=r.model.maxValue,i>f&&(i=f),r.option("value",i),this._seekVideo(n,i,this._isYoutubeElement(n)),this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:"forward"}))},r.prototype._rewindMedia=function(n,t){if(this._getCurrentMediaTime(n)>0){var i,r;this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:"rewind"});i=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-timeslider"),"Slider");r=i.model.value-parseFloat(t);i.option("value",r);this._seekVideo(n,r,this._isYoutubeElement(n));this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:"rewind"})}},r.prototype._handleRepeatBtnClick=function(n){var t=this._containsClass(n,"media-repeated");this._trigger("onRepeat",{mediaInfo:this._getCurrentMediaInfo(),isRepeat:t});t?(this._removeClass(n,"media-repeated"),this._repeat=!1):(this._addClass(n,"media-repeated"),this._repeat=!0);this._disablePrevNextIcons()},r.prototype._handleShuffleBtnClick=function(n){var t=this._containsClass(n,"media-shuffled");this._trigger("onShuffle",{mediaInfo:this._getCurrentMediaInfo(),isShuffle:t});t?(this._removeClass(n,"media-shuffled"),this._shuffle=!1):(this._addClass(n,"media-shuffled"),this._shuffle=!0);this._disablePrevNextIcons()},r.prototype._handleMuteBtnClick=function(n,t,i){if(!i){this._hideBasicVolSlider();var r=this._mediaDiv.querySelector(".e-media-volume-slider");this._containsClass(t,"media-muted")?(this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:"unmute"}),this._removeClass(t,"media-muted"),this._mute=!1,this._manualMute=!0,this._setMute(n,this._mute,this._isYoutubeElement(n)),this._getEJControlInstance(r,"Slider").option("value",this._getVolume(n,this._isYoutubeElement(n))),this._manualMute=!1,this._setAdvToolbarOverflow(),this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:"unmute"})):(this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:"mute"}),this._addClass(t,"media-muted"),this._mute=!0,this._manualMute=!0,this._setMute(n,this._mute,this._isYoutubeElement(n)),this._getEJControlInstance(r,"Slider").option("value",0),this._manualMute=!1,this._setAdvToolbarOverflow(),this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:"mute"}))}},r.prototype._handleSubtitleBtnClick=function(n){var t=this._getCurrentMedia();this._subtitle=n.value==1?!0:!1;this._setSubtitle(t,this._playlist[this._mediaIndex].track,this._isYoutubeElement(t))},r.prototype._handleStopBtnClick=function(n){this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:"stop"});this._stop(n);this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:"stop"})},r.prototype._stop=function(n){this._pauseCurrentMedia(n);this._addPlayClass(!0);this._isYoutubeElement(n)?this._processYoutubeAPI("stopVideo",null):this._seekVideo(n,0,this._isYoutubeElement(n));this._updateTimeSlider(n,"0");this._updateTimeStamp(n);this._hideWaitingPopup()},r.prototype._handleScreenBtnClick=function(n){n?this._exitFullScreen():this._setFullScreen();this._fullScreenChange(n)},r.prototype._onVolSliderChange=function(n){if(!this._manualMute){var t=this._getCurrentMedia();this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),volume:this.model.volume,actionType:"volumeChange"});this._setVolume(t,n,this._isYoutubeElement(t));this._setMuteOnVolChange(n,t);this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),volume:this.model.volume,actionType:"volumeChange"})}},r.prototype._setMuteOnVolChange=function(n,t){var r=this._mediaDiv.querySelector(".e-media-volume"),i;i=this._isYoutubeElement(t);n<=0&&!this._mute?(this._addClass(r,"media-muted"),this._mute=!0,this._setMute(t,this._mute,i)):n>0&&this._mute&&(this._removeClass(r,"media-muted"),this._mute=!1,this._setMute(t,this._mute,i))},r.prototype._onTimeSliderChange=function(n){var i,t;i=this._getCurrentMediaTime(this._getCurrentMedia())>n?"rewind":"forward";this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:i});t=this._getCurrentMedia();t instanceof HTMLVideoElement||t instanceof HTMLAudioElement?t.currentTime=n:this._processYoutubeAPI("seekTo",n);this._updateTimeStamp(t);this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:i})},r.prototype._showSettingsPopup=function(){var n=this._mediaDiv.querySelector(".e-media-settings-popup");this._containsClass(n,"e-hide")?(this._resetInitialView(n),this._removeClass(n,"e-hide"),this._setPopupPosition(n),this._isYoutubeElement(this._getCurrentMedia())?(this._setYoutubeSpeedVisibility(),this._setYoutubeQualityVisibility()):this._setVideoOptionVisibility(n)):this._addClass(n,"e-hide")},r.prototype._setVideoOptionVisibility=function(n){for(var i=n.querySelectorAll(".e-list.disabled"),t=0;t<i.length;t++)this._removeClass(i[t],"disabled")},r.prototype._setYoutubeSpeedVisibility=function(){var t,r,i,n;for(t=this._getSettingsGroupByType("speed").querySelectorAll(".e-list"),r=this._processYoutubeAPI("getAvailablePlaybackRates",null),n=0;n<t.length;n++)i=t[n].querySelector(".e-list-text").innerText,i==ej.MediaPlayer.SpeedText.Normal&&(i="1"),r.indexOf(parseFloat(i))==-1?this._addClass(t[n],"disabled"):this._removeClass(t[n],"disabled")},r.prototype._setYoutubeQualityVisibility=function(){var r,t,i,n;for(r=this._processYoutubeAPI("getAvailableQualityLevels",null),t=this._getSettingsGroupByType("quality").querySelectorAll(".e-list"),n=0;n<t.length;n++)i=t[n].querySelector(".e-list-text").innerText,i=ej.MediaPlayer.Quality[i.toLowerCase()],r.indexOf(i)==-1?this._addClass(t[n],"disabled"):this._removeClass(t[n],"disabled")},r.prototype._updateSettingsHeader=function(n,t){var r=this._isYoutubeElement(this._getCurrentMedia()),i;r||(i=this._getSettingsHeaderText(t.children[1],t),t.children[1].querySelector(".e-btn-text").innerText=i)},r.prototype._hideSettingsPopup=function(n){n&&(this._closest(n.target,".e-media-settings")||this._closest(n.target,".e-media-settings-popup"))||this._addClass(this._mediaDiv.querySelector(".e-media-settings-popup"),"e-hide")},r.prototype._showWaitingPopup=function(){if(this._isWaitingPopup){var n,r=this,t,i;n=this._mediaDiv.querySelector(".e-media-content-div");i=this._getEJControlInstance(n,"WaitingPopup");i?i.show():(t=this._createElement("div",null,"e-media-waiting-template"),this._mediaDiv.appendChild(t),t=this._mediaDiv.querySelector(".e-media-waiting-template"),this._renderEJControls(n,"WaitingPopup",{width:"100px",height:"100px",showOnInit:!0,appendTo:"#"+n.id,template:t}))}},r.prototype._hideWaitingPopup=function(){var t,n;t=this._mediaDiv.querySelector(".e-media-content-div");n=this._getEJControlInstance(t,"WaitingPopup");n&&n.hide()},r.prototype._resetInitialView=function(n){var u,t,f,i,r,e;u=this._isYoutubeElement(this._getCurrentMedia());t=this._getSettingsGroupByType("speed");f=this._getSettingsGroupByType("quality");f.style.display="none";i=this._mediaDiv.querySelector(".e-media-settings-overlay");r=t.querySelector(".e-btn-text");u?(this._addClass(i,"e-hide"),this._removeClass(r,"speed"),this._removeClass(t.querySelector(".e-hicon"),"e-hide"),n.children[0].style.display="block",t.style.display="none"):(this._removeClass(i,"e-hide"),this._addClass(r,"speed"),this._addClass(t.querySelector(".e-hicon"),"e-hide"),n.children[0].style.display="none",t.style.display="block",this._addClass(t,"e-slideleft"),e=this._getSettingsHeaderText(t,n),t.querySelector(".e-btn-text").innerText=e)},r.prototype._getSettingsGroupByType=function(n){var t,i,r;return t=this._mediaDiv.querySelector(".e-media-settings-popup"),n.toString().toLowerCase()=="speed"?(i=t.children[1],i.innerHTML.indexOf(ej.MediaPlayer.SpeedText.Normal)==-1&&(i=t.children[2]),i):(r=t.children[2],t.children[1].innerHTML.indexOf(ej.MediaPlayer.SpeedText.Normal)==-1&&(r=t.children[1]),r)},r.prototype._processYoutubeAPI=function(n,t){if(this._youtubeIns)return this._youtubeIns[n](t)},r.prototype._processYoutubeAPIMultiArgs=function(n,t,i,r){if(this._youtubeIns)return this._youtubeIns[n](t,i,r)},r.prototype._wireCommonEvents=function(){for(var t=this._mediaDiv.querySelector(".e-media-content-div").children,n=0;n<t.length;n++)this._containsClass(t[n],"e-media-element")&&this._wireCommonEventsProcess(t[n]);this._wireDocumentClickEvent();this._wireMouseMoveEvent();this._wireFullScreenChangeEvent();this._handleKeyBoardShortcuts();this._wireTouchEvent();this._wireSliderEvents();this._wireResizeEvents()},r.prototype._unwireCommonEvents=function(){this._mediaDiv.removeEventListener("mousemove",this._mouseMoveEvt);this._mediaDiv.removeEventListener("mouseleave",this._mouseLeaveEvt);document.removeEventListener("keydown",this._keyDownEvt);document.removeEventListener("fullscreenchange",this._fullScEvt);document.removeEventListener("webkitfullscreenchange",this._fullScEvt);document.removeEventListener("mozfullscreenchange",this._fullScEvt);document.removeEventListener("MSFullscreenChange",this._fullScEvt);document.removeEventListener("click",this._clickEvt);window.removeEventListener("mouseup",this._mouseUpEvt);window.removeEventListener("touchstart",this._touchStartEvt);window.removeEventListener("touchend",this._touchEndEvt);window.removeEventListener("resize",this._resizeEvt)},r.prototype._wireResizeEvents=function(){var n=this;this._resizeEvt=function(){n._setLowPriorityIconsVisibility();n._hideSettingsPopup(null);n._hideBasicVolSlider()};window.addEventListener("resize",this._resizeEvt)},r.prototype._wireSliderEvents=function(){var n=this;this._mouseUpEvt=function(){n._windowMouseup()};window.addEventListener("mouseup",this._mouseUpEvt);this._touchStartEvt=function(t){t.pointerType&&t.pointerType!="touch"||(n._touchStarted=!0,n._removeClass(n._mediaDiv,"e-media-mouse"))};window.addEventListener("touchstart",this._touchStartEvt);window.addEventListener("MSPointerDown",this._touchStartEvt);this._touchEndEvt=function(t){t.pointerType&&t.pointerType!="touch"||n._windowMouseup()};window.addEventListener("touchend",this._touchEndEvt);window.addEventListener("MSPointerUp",this._touchEndEvt)},r.prototype._windowMouseup=function(){var n=this,t,i,r;this._timeSliderClick&&(this._timeSliderClick=!1,t=this._mediaDiv.querySelector(".e-media-timeslider"),this._removeClass(t.querySelector(".e-handle"),"e-media-slider-size"),setTimeout(function(){n._onTimeSliderChange(n._getEJControlInstance(t,"Slider").getValue());n._pausedManual&&(i=n._getCurrentMedia(),n._isYoutubeElement(i)?n._playYoutubeVideo():n._playMedia(i),n._pausedManual=!1)},n._sliderAnimation));this._volSliderClick&&(this._volSliderClick=!1,r=this._mediaDiv.querySelector(".e-media-volume-slider"),setTimeout(function(){n._onVolSliderChange(n._getEJControlInstance(r,"Slider").getValue());n._removeClass(r.querySelector(".e-handle"),"e-focus")},n._sliderAnimation))},r.prototype._wireTouchEvent=function(){var n=this;this._mediaDiv.querySelector(".e-media-content-div").addEventListener("touchstart",function(){n._tochStart=!0});this._mediaDiv.querySelector(".e-media-content-div").addEventListener("touchend",function(){n._tochStart=!1})},r.prototype._wireFullScreenChangeEvent=function(){var n=this;this._fullScEvt=function(){n._onFullScreenChange()};document.addEventListener("fullscreenchange",this._fullScEvt);document.addEventListener("webkitfullscreenchange",this._fullScEvt);document.addEventListener("mozfullscreenchange",this._fullScEvt);document.addEventListener("MSFullscreenChange",this._fullScEvt)},r.prototype._onFullScreenChange=function(){var n=document.fullscreenElement||document.webkitFullscreenElement||document.mozFullScreenElement||document.msFullscreenElement;this._fullScreenChange(!n);n?this._hideMobilePlaylist():this._showMobilePlaylist();this._hideSettingsPopup(null);this._hideTooltip();this._addClass(this._mediaDiv.querySelector(".e-media-time-tooltip"),"e-hide");this.focus()},r.prototype._handleKeyBoardShortcuts=function(){var n=this;this._keyDownEvt=function(t){n.model&&!n.model.disableKeys&&n._onMediaKeydown(n._getCurrentMedia(),t)};document.addEventListener("keydown",this._keyDownEvt)},r.prototype._onMediaKeydown=function(n,t){if(this._closest(document.activeElement,".e-media-player")){var r,u,i,f,e,o;r=this._isYoutubeElement(n);u=this._getCurrentMediaTime(n);i=t.which||t.keyCode;f=t.ctrlKey?t.ctrlKey:i===17?!0:!1;e=t.shiftKey?t.shiftKey:i===16?!0:!1;o=t.altKey?t.altKey:i===18?!0:!1;!f||e||o?!e||f||o?!o||e||f?this._otherKeyEvents(t,i,n,u,r):this._altKeyEvents(t,i,n,u,r):this._shiftKeyEvents(t,i,n,u,r):this._controlKeyEvents(t,i,n,u,r);this._screenKeydownEvents(t);this._playVolumeEvents(t,n)}},r.prototype._playVolumeEvents=function(n,t){var i=n.which||n.keyCode;switch(i){case 32:this._preventDefault(n);this._handlePlayIconClick(t);break;case 77:this._preventDefault(n);this._handleMuteBtnClick(t,this._mediaDiv.querySelector(".e-media-volume"))}},r.prototype._screenKeydownEvents=function(n){var t=n.which||n.keyCode;this.focus();switch(t){case 27:this._preventDefault(n);this._handleScreenBtnClick(!0);break;case 122:this._preventDefault(n);this._handleScreenBtnClick(!1)}this._addClass(this._mediaDiv.querySelector(".e-media-time-tooltip"),"e-hide")},r.prototype._otherKeyEvents=function(n,t,i,r,u){var f=this._getVolume(i,u);switch(t){case 37:this._preventDefault(n);this._rewindMedia(i,3);break;case 39:this._preventDefault(n);this._forwardMedia(i,3);break;case 38:this._preventDefault(n);this._changeVolume(i,f+10,u);break;case 40:this._preventDefault(n);this._changeVolume(i,f-10,u)}},r.prototype._altKeyEvents=function(n,t,i){switch(t){case 37:this._preventDefault(n);this._rewindMedia(i,10);break;case 39:this._preventDefault(n);this._forwardMedia(i,10)}},r.prototype._shiftKeyEvents=function(n,t,i,r,u){var f=this._getVolume(i,u);switch(t){case 37:this._preventDefault(n);this._rewindMedia(i,3);break;case 39:this._preventDefault(n);this._forwardMedia(i,3);break;case 38:this._preventDefault(n);this._changeVolume(i,f+10,u);break;case 40:this._preventDefault(n);this._changeVolume(i,f-10,u)}},r.prototype._controlKeyEvents=function(n,t,i,r,u){var f=this._getVolume(i,u);switch(t){case 37:this._preventDefault(n);this._rewindMedia(i,60);break;case 38:this._preventDefault(n);this._changeVolume(i,f+10,u);break;case 39:this._preventDefault(n);this._forwardMedia(i,60);break;case 40:this._preventDefault(n);this._changeVolume(i,f-10,u)}},r.prototype._changeVolume=function(n,t,i){var r,f=this,u;this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),volume:this.model.volume,actionType:"volumeChange"});r=this._mediaDiv.querySelector(".e-media-vol-slider-li");r&&(this._showBasicVolSlider(),window.clearTimeout(this._hideVolume),this._hideVolume=setTimeout(function(){f._hideBasicVolSlider()},1e3));this._setVolume(n,t,i);u=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-volume-slider"),"Slider");u.option("value",this._getVolume(n,i));this._setMuteOnVolChange(t,n);this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),volume:this.model.volume,actionType:"volumeChange"})},r.prototype._wireMouseMoveEvent=function(){var n=this;this._mouseMoveEvt=function(t){n._handleAutoHide(t);n._touchStarted?n._touchStarted=!1:n._addClass(n._mediaDiv,"e-media-mouse");n.model.renderMode==ej.MediaPlayer.RenderMode.Basic&&(n._closest(t.target,".e-media-toolbar-volume-icon-li")||n._containsClass(t.target,"e-media-toolbar-volume-li")||n._closest(t.target,".e-media-toolbar-volume-li")?n._showBasicVolSlider():n._hideBasicVolSlider())};this._mediaDiv.addEventListener("mousemove",this._mouseMoveEvt);this._mediaDiv.addEventListener("touchmove",this._mouseMoveEvt);this._mouseLeaveEvt=function(t){n._handleAutoHide(t);n._hideBasicVolSlider();n._addClass(n._mediaDiv,"e-media-mouse")};this._mediaDiv.addEventListener("mouseleave",this._mouseLeaveEvt)},r.prototype._isAllowAutoHide=function(){if(this._containsClass(this._mediaDiv.querySelector(".e-media-settings-popup"),"e-hide"))return!0},r.prototype._handleAutoHide=function(n){this.model.autoHide&&this.model.contentType!=ej.MediaPlayer.ContentType.Audio&&this._isAllowAutoHide()&&(n&&this._closest(n.target,".e-media-content-div")?this._expandToolbar(n):this._collapseToolbar(n));n&&this._closest(n.target,".e-media-content-div")&&(this._fadeMobileIcons(),this._fadeBasicIcons(),this._fadePlayIcon())},r.prototype._fadePlayIcon=function(){var n,i,t=this;n=this._mediaDiv.querySelector(".e-media-center-icon");this._fadeIn(n);i=parseInt(this.model.autoHideTime.toString())*1e3;t=this;window.clearTimeout(this._playIconHide);t._playIconHide=setTimeout(function(){t._fadeOut(n)},i)},r.prototype._fadeMobileIcons=function(){var n,i,t=this;n=this._mediaDiv.querySelector(".mob-playGroup");n&&(this._fadeIn(n),i=parseInt(this.model.autoHideTime.toString())*1e3,t=this,window.clearTimeout(this._mobIconHide),t._mobIconHide=setTimeout(function(){t._fadeOut(n)},i))},r.prototype._fadeBasicIcons=function(){var n,i,r,t=this;n=this._mediaDiv.querySelector(".e-media-prev-li.basic");n&&(i=this._mediaDiv.querySelector(".e-media-next-li.basic"),this._fadeIn(n),this._fadeIn(i),r=parseInt(this.model.autoHideTime.toString())*1e3,t=this,window.clearTimeout(this._mobIconHide),t._mobIconHide=setTimeout(function(){t._fadeOut(n);t._fadeOut(i)},r))},r.prototype._wireDocumentClickEvent=function(){var n=this;this._clickEvt=function(t){n._mediaDiv&&(n._closest(t.target,".e-media-player")&&n._mediaDiv.focus(),n._hideSettingsPopup(t),n._handleAutoHide(null),n._closest(t.target,".e-media-vol-slider-li")||n._hideBasicVolSlider())};document.addEventListener("click",this._clickEvt)},r.prototype._wireMediaClickEvent=function(){var n=this,t;this._mediaDiv.querySelector(".e-media-content-div").addEventListener("click",function(i){t=n._mediaDiv.querySelector(".e-media-control-container");n._containsClass(i.target,"e-media-toolbar-icon")||n._containsClass(i.target,"e-media-toolbar-li")||t.style.display=="none"||t.style.opacity=="0"||(window.clearInterval(n._playTimer),n._handlePlayIconClick(n._getCurrentMedia()))})},r.prototype._wireCommonEventsProcess=function(n){var t=n.nodeName.toLowerCase();(t=="audio"||t=="video")&&this._mediaEvents(n)},r.prototype._mediaEvents=function(n){this._raisePlayEvent(n);this._raisePlayingEvent(n);this._raiseLoadEvent(n);this._raiseMediaEndEvent(n)},r.prototype._raisePlayingEvent=function(n){var t=this;n.onplaying=function(){t._onPlaying(n)}},r.prototype._raisePlayEvent=function(n){var t=this;n.onplay=function(){t._addPlayClass()}},r.prototype._raiseLoadEvent=function(n){var t=this;n.onloadeddata=function(){t._setMediaDuration(n);t._updateTimeStamp(n)}},r.prototype._raiseMediaEndEvent=function(n){var t=this;n.onended=function(){t._onEndCurrentMedia(n)}},r.prototype._onPlaying=function(n){this._trigger("onPlaying",{mediaInfo:this._getCurrentMediaInfo()});this.hideWaitingPopup();var t=this;window.clearInterval(this._playTimer);this._playTimer=window.setInterval(function(){n==t._getCurrentMedia()&&(t._updateTimeSlider(n,null),t._updateTimeStamp(n))},10);this._addPauseClass()},r.prototype._fullScreenChange=function(n){var t,i;this.model.contentType!=ej.MediaPlayer.ContentType.Audio&&(n?(i=this._mediaDiv.querySelector(".e-media-smallscreen"),i&&(this._removeClass(i,"e-media-smallscreen"),this._addClass(i,"e-media-fullscreen"),this._removeClass(this._mediaDiv,"fullscreen"))):(t=this._mediaDiv.querySelector(".e-media-fullscreen"),t&&(this._removeClass(t,"e-media-fullscreen"),this._addClass(t,"e-media-smallscreen"),this._addClass(this._mediaDiv,"fullscreen"))),this._showWaitingPopup())},r.prototype._setFullScreen=function(){if(this.model.contentType!=ej.MediaPlayer.ContentType.Audio){var n=this._mediaDiv,t,i;this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),isFullScreen:this._containsClass(this._mediaDiv,"fullscreen"),actionType:"screenChange"});this._browserInfo.name=="msie"&&parseInt(this._browserInfo.version)<11?(this._addClass(n,"fullscreen"),t=document.querySelector(".e-media-custom-fullscreen"),this._removeClass(t,"e-hide"),this._parentElement=n.parentElement,t.appendChild(n)):(i=n.requestFullScreen||n.webkitRequestFullScreen||n.mozRequestFullScreen||n.msRequestFullscreen||n.webkitEnterFullscreen,i&&i.call(n));this._setLowPriorityIconsVisibility();this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),isFullScreen:this._containsClass(this._mediaDiv,"fullscreen"),actionType:"screenChange"})}},r.prototype._exitFullScreen=function(){if(this.model.contentType!=ej.MediaPlayer.ContentType.Audio){var n,t;this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),isFullScreen:this._containsClass(this._mediaDiv,"fullscreen"),actionType:"screenChange"});this._browserInfo.name=="msie"&&parseInt(this._browserInfo.version)<11?(this._removeClass(this._mediaDiv,"fullscreen"),n=document.querySelector(".e-media-custom-fullscreen"),this._addClass(n,"e-hide"),this._parentElement.appendChild(this._mediaDiv),n.innerHTML=""):(t=document.cancelFullScreen||document.webkitCancelFullScreen||document.mozCancelFullScreen||document.msExitFullscreen||document.webkitExitFullscreen,t&&t.call(document));this._setLowPriorityIconsVisibility();this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),isFullScreen:this._containsClass(this._mediaDiv,"fullscreen"),actionType:"screenChange"})}},r.prototype._showMobilePlaylist=function(){this.model.renderMode==ej.MediaPlayer.RenderMode.Mobile&&this.model.showPlaylist&&(this._removeClass(this._mediaDiv.querySelector(".e-media-playlist-container"),"e-hide"),this._addClass(this._mediaDiv.querySelector(".e-media-playlist"),"e-media-playlist-visible"),this._removeClass(this._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-hide"),this._collapsePlaylist())},r.prototype._hideMobilePlaylist=function(){this.model.renderMode==ej.MediaPlayer.RenderMode.Mobile&&this.model.showPlaylist&&(this._addClass(this._mediaDiv.querySelector(".e-media-playlist-container"),"e-hide"),this._removeClass(this._mediaDiv.querySelector(".e-media-playlist"),"e-media-playlist-visible"),this._addClass(this._mediaDiv.querySelector(".e-media-playlist-toggle"),"e-hide"))},r.prototype._onYoutubePlayerReady=function(n){this._youtubeIns=n.target;this._setMediaSettings(this._youtubeIns,!0);this._youtubeMediaEle&&this._changeMediaSource(this._youtubeMediaEle,!0)},r.prototype._onYoutubeStateChange=function(n){var t=n.data;t==YT.PlayerState.PLAYING?(this._setMediaDuration(this._getCurrentMedia()),window.clearInterval(this._playTimer),this._onPlaying(this._getCurrentMedia())):t==YT.PlayerState.ENDED&&this._onEndCurrentMedia(this._getCurrentMedia())},r.prototype._onActionBegin=function(n){this._trigger("onActionBegin",n)},r.prototype._onActionComplete=function(n){this._trigger("onActionComplete",n)},r.prototype.play=function(){var n=this._getCurrentMedia();n&&(this._isYoutubeElement(n)?this._playYoutubeVideo():this._playMedia(n))},r.prototype.pause=function(){var n=this._getCurrentMedia();n&&(this._isYoutubeElement(n)?this._pauseYoutubeVideo():this._pauseMedia(n))},r.prototype.mute=function(){var n=this._getCurrentMedia(),t,i;n&&(t=this._mediaDiv.querySelector(".e-media-volume-slider"),this._mute=!0,this._manualMute=!0,this._setModelMute(n,!0,this._isYoutubeElement(n)),t&&this._getEJControlInstance(t,"Slider").option("value",0),i=this._mediaDiv.querySelector(".e-media-volume"),i&&this._addClass(i,"media-muted"))},r.prototype.unmute=function(){var n=this._getCurrentMedia(),t,i;n&&(t=this._mediaDiv.querySelector(".e-media-volume-slider"),this._mute=!1,this._manualMute=!0,this._setModelMute(n,!1,this._isYoutubeElement(n)),t&&this._getEJControlInstance(t,"Slider").option("value",this._getVolume(n,this._isYoutubeElement(n))),i=this._mediaDiv.querySelector(".e-media-volume"),i&&this._removeClass(i,"media-muted"))},r.prototype.stop=function(){var n=this._getCurrentMedia();n&&this._handleStopBtnClick(n)},r.prototype.next=function(){var n=this._getCurrentMedia();n&&this._handleNextBtnClick(n)},r.prototype.previous=function(){var n=this._getCurrentMedia();n&&this._handlePreviousBtnClick(n)},r.prototype.forward=function(n){var t=this._getCurrentMedia(),i;t&&(i=n||this.model.forwardTime||10,this._forwardMedia(t,i))},r.prototype.rewind=function(n){var t=this._getCurrentMedia(),i;t&&(i=n||this.model.rewindTime||10,this._rewindMedia(t,i))},r.prototype.setShuffle=function(n){this._shuffle=n==!1?!1:!0;var t=this._mediaDiv.querySelector(".e-media-shuffle");this._shuffle?this._addClass(t,"media-shuffled"):this._removeClass(t,"media-shuffled");this._disablePrevNextIcons()},r.prototype.setRepeat=function(n){this._repeat=n==!1?!1:!0;var t=this._mediaDiv.querySelector(".e-media-repeat");this._repeat?this._addClass(t,"media-repeated"):this._removeClass(t,"media-repeated");this._disablePrevNextIcons()},r.prototype.seekTo=function(n){var t=this._getCurrentMedia();t&&n&&(this._seekVideo(t,n,this._isYoutubeElement(t)),this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-timeslider"),"Slider").option("value",n))},r.prototype.getCurrentMediaType=function(){var t=this._getCurrentMedia(),n;if(t)return n=ej.MediaPlayer.Types,t instanceof HTMLVideoElement?n.Video:t instanceof HTMLAudioElement?n.Audio:n.Youtube},r.prototype.getCurrentTime=function(){var n=this._getCurrentMedia();if(n)return this._getCurrentMediaTime(n)},r.prototype.setMediaSpeed=function(n){var t=this._getCurrentMedia();t&&(this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),speed:this.getMediaSpeed(),actionType:"speedChange"}),this._setPlayerSpeed(t,n,this._isYoutubeElement(t)),this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),speed:this.getMediaSpeed(),actionType:"speedChange"}))},r.prototype.getMediaSpeed=function(){var n=this._getCurrentMedia();if(n)return this._getPlayerSpeed(n,this._isYoutubeElement(n))},r.prototype.getDuration=function(){var n=this._getCurrentMedia();if(n)return this._isYoutubeElement(n)?this._processYoutubeAPI("getDuration",null):n.duration},r.prototype.setVolume=function(n){var t=this._getCurrentMedia(),i,r;t&&(i=n||50,this._setModelVolume(t,i,this._isYoutubeElement(t)),r=this._mediaDiv.querySelector(".e-media-volume-slider"),r&&this._getEJControlInstance(r,"Slider").option("value",i))},r.prototype.getVolume=function(){var n=this._getCurrentMedia();if(n)return this._getVolume(n,this._isYoutubeElement(n))},r.prototype.getCurrentMediaIndex=function(){return this._mediaIndex},r.prototype.addMedia=function(n){var t=this._mediaDiv.querySelector(".e-listbox");this.model.source.push(n);this._playlist.push(n);t&&this._getEJControlInstance(t,"ListBox").option("dataSource",this._playlist)},r.prototype.removeMedia=function(n){var i=this._getIndexByMediaUrl(n.url),r,t;r=this._playlist[i];r&&(this._playlist.splice(i,1),t=this._mediaDiv.querySelector(".e-listbox"),t=this._mediaDiv.querySelector(".e-listbox"),t&&this._getEJControlInstance(t,"ListBox").option("dataSource",this._playlist))},r.prototype.showPlaylist=function(){this._showPlaylist()},r.prototype.hidePlaylist=function(){this._hidePlaylist()},r.prototype.makeFullScreen=function(){this._setFullScreen()},r.prototype.exitFullScreen=function(){this._exitFullScreen()},r.prototype.focus=function(){this._mediaDiv.focus()},r.prototype.switchView=function(n){n&&this._changeRenderMode(n)},r.prototype._getIndexByMediaUrl=function(n){for(var i=this._playlist,t=0;t<i.length;t++)if(i[t].url==n)return t},r.prototype._preventDefault=function(n){n.preventDefault&&n.preventDefault();n.stopPropagation&&n.stopPropagation();n.returnValue=!1},r.prototype._getPopupPosition=function(n){var t=this._mediaDiv,o,i,r,u,f,e;return o=t.querySelector(".e-media-settings").getBoundingClientRect(),i=t.querySelector(".e-media-control-container").getBoundingClientRect(),r=n.getBoundingClientRect(),u=t.querySelector(".e-media-content-div").getBoundingClientRect(),f=i.height,e=u.width-r.width,{left:e,bottom:f}},r.prototype._setPopupPosition=function(n){var t=this._getPopupPosition(n);n.style.bottom=t.bottom.toString()+"px";n.style.left=t.left.toString()+"px"},r.prototype._onEndCurrentMedia=function(n){this._trigger("onMediaComplete",{mediaInfo:this._getCurrentMediaInfo()});this._addPlayClass();this.model.autoPlay?this._playVideoByIndex(n,this._mediaIndex+1):(window.clearInterval(this._playTimer),this._playTimer=null)},r.prototype._playCurrentMediaAgain=function(n){this._seekVideo(n,0,this._isYoutubeElement(n));this._handlePlayIconClick(n)},r.prototype._setMediaDuration=function(n){var i=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-timeslider"),"Slider"),t;t=this._isYoutubeElement(n)?this._processYoutubeAPI("getDuration",null):n.duration;t&&i.setModel({maxValue:t,incrementStep:t/100})},r.prototype._getMediaDuration=function(n){return this._isYoutubeElement(n)?this._processYoutubeAPI("getDuration",null):n.duration},r.prototype._getCurrentMediaTime=function(n){return this._isYoutubeElement(n)?this._processYoutubeAPI("getCurrentTime",null):n instanceof HTMLVideoElement||n instanceof HTMLAudioElement?n.currentTime:void 0},r.prototype._playVideoByIndex=function(n,t,i){var e,r,u,f;this._repeat&&(t>=this._playlist.length?t=0:t<0&&(t=this._playlist.length-1));!i&&this._shuffle&&(t=this._getRandomNumber(0,this._playlist.length-1));window.clearInterval(this._playTimer);e=this._playlist;r=e[t];n&&r&&(this._stop(n),r.type!=ej.MediaPlayer.Types.Youtube&&this.showWaitingPopup(),u=this._mediaIndex>t?"previous":"next",this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:u}),this._mediaIndex=t,this._onActionBegin({mediaInfo:this._getCurrentMediaInfo(),actionType:"mediaChange"}),this._changeMediaSource(n),this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:"mediaChange"}),f=this._getCurrentMedia(),this._addPlayClass(),this._handlePlayIconClick(f),this._updateTimeSlider(f,null),this._onActionComplete({mediaInfo:this._getCurrentMediaInfo(),actionType:u}))},r.prototype._pauseCurrentMedia=function(n){this._isYoutubeElement(n)?this._processYoutubeAPI("pauseVideo",null):(n instanceof HTMLVideoElement||n instanceof HTMLAudioElement)&&n.pause();window.clearInterval(this._playTimer)},r.prototype._playCurrentMedia=function(n){this._isYoutubeElement(n)?this._processYoutubeAPI("playVideo",null):(n instanceof HTMLVideoElement||n instanceof HTMLAudioElement)&&this._play(n)},r.prototype._isMediaPaused=function(n){if(this._isYoutubeElement(n)){if(this._processYoutubeAPI("getPlayerState",null)!="1")return!0}else if(n instanceof HTMLVideoElement||n instanceof HTMLAudioElement)return n.paused},r.prototype._changeMediaSource=function(n,t){var e=this._playlist,r,f,i,o,u;this._disablePrevNextIcons();r=e[this._mediaIndex];r&&(window.clearInterval(this._playTimer),this._pauseCurrentMedia(n),f=r.type,this._hideAllMedia(),this._showCurrentMedia(f),i=this._getCurrentMediaFromType(f),o=e[this._mediaIndex].url,u=this._isYoutubeElement(i),u&&!this._youtubeIns?this._youtubeMediaEle=i:(this._setMediaSource(i,o,u,t),this._setSubtitle(i,r.track,u),this._setMute(i,this._mute,u),this._changePlaylistItem(),this._setVideoTitle(i,r),this._setAudioPoster(i,r),this._setAudioTitle(i,r),this._updateTimeStamp(i)),this._setQualityItemVisibility(u))},r.prototype._disablePrevNextIcons=function(){var n=this._playlist;n[this._mediaIndex-1]||this._repeat||this._shuffle?this._removeClass(this._mediaDiv.querySelector(".e-media-previous"),"disabled"):this._addClass(this._mediaDiv.querySelector(".e-media-previous"),"disabled");n[this._mediaIndex+1]||this._repeat||this._shuffle?this._removeClass(this._mediaDiv.querySelector(".e-media-next"),"disabled"):this._addClass(this._mediaDiv.querySelector(".e-media-next"),"disabled")},r.prototype._setQualityItemVisibility=function(n){var t=this._mediaDiv.querySelector(".e-media-settings-popup").querySelector(".e-media-settings-quality");n?this._removeClass(t,"e-hide"):this._addClass(t,"e-hide")},r.prototype._updateAutoPlay=function(){var n=this._getCurrentMedia(),t;n&&(t=this._isYoutubeElement(n),this.model.autoPlay?t?this._playYoutubeVideo():n.setAttribute("autoplay","autoplay"):t?this._pauseYoutubeVideo(!0):n.removeAttribute("autoplay"))},r.prototype._setVideoTitle=function(n,t){var i=this._mediaDiv.querySelector(".e-media-video-baner");n instanceof HTMLAudioElement==!1&&this.model.showTitle?(this._removeClass(i,"e-hide"),i.querySelector(".e-media-video-title").innerHTML=t.title):this._addClass(i,"e-hide")},r.prototype._setAudioPoster=function(n){var t=this._mediaDiv.querySelector(".e-media-audio-detail");n instanceof HTMLAudioElement?(this._removeClass(t,"e-hide"),this._mediaDiv.querySelector(".e-media-audio-poster").src=this._defaultPosterUrl):this._addClass(t,"e-hide")},r.prototype._setAudioTitle=function(n,t){var i=this._mediaDiv.querySelector(".e-media-audio-detail");n instanceof HTMLAudioElement?(this._removeClass(i,"e-hide"),this._mediaDiv.querySelector(".e-media-audio-title").innerHTML=t.title):this._addClass(i,"e-hide")},r.prototype._changePlaylistItem=function(){var t=this._mediaDiv.querySelector(".e-media-playlist-div"),n;n=t.querySelector(".e-select");n&&this._removeClass(n,"e-select");this._addClass(t.children[this._mediaIndex],"e-select")},r.prototype._updateTimeSlider=function(n,t){var i=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-timeslider"),"Slider");t?i.option("value",parseFloat(t)):this._isYoutubeElement(n)?i.option("value",this._processYoutubeAPI("getCurrentTime",null)):(n instanceof HTMLVideoElement||n instanceof HTMLAudioElement)&&i.option("value",n.currentTime)},r.prototype._updateTimeStamp=function(n){var i=this._mediaDiv,t,r,u,f,e;t=i.querySelector(".e-media-time-stamp-run");r=i.querySelector(".e-media-time-stamp-end");u=this._getEJControlInstance(this._mediaDiv.querySelector(".e-media-timeslider"),"Slider");f=u.model.value;e=this._getMediaDuration(n);t.innerText=this._getTimeFromSeconds(f);this._containsClass(t,"e-media-mob")||(t.innerText+=" /");r.innerText=this._getTimeFromSeconds(e)},r.prototype._addPlayClass=function(n){var i=this._mediaDiv.querySelector(".e-media-pause"),t;t=this._mediaDiv.querySelector(".e-media-center-icon");(n||this._isMediaPaused(this._getCurrentMedia()))&&!this._pausedManual&&(this._removeClass(i,"e-media-pause"),this._addClass(i,"e-media-play"),this._removeClass(t,"e-media-center-pause"),this._addClass(t,"e-media-center-play"),t.title=this._getLocaleString("Play"))},r.prototype._addPauseClass=function(n){var i=this._mediaDiv.querySelector(".e-media-play"),t;t=this._mediaDiv.querySelector(".e-media-center-icon");!n&&this._isMediaPaused(this._getCurrentMedia())||this._pausedManual||(this._removeClass(i,"e-media-play"),this._addClass(i,"e-media-pause"),this._removeClass(t,"e-media-center-play"),this._addClass(t,"e-media-center-pause"),t.title=this._getLocaleString("Pause"));this._pausedManual=!1},r.prototype._getCurrentMedia=function(){for(var t=this._mediaDiv.querySelector(".e-media-content-div").children,n=0;n<t.length;n++)if(this._containsClass(t[n],"e-media-element")&&!this._containsClass(t[n],"e-hide"))return t[n]},r.prototype._showCurrentMedia=function(n){var t=this._getCurrentMediaFromType(n);t&&this._removeClass(t,"e-hide")},r.prototype._hideAllMedia=function(){var n=this._mediaDiv,t,i,r;t=n.querySelector(".e-media-video");i=n.querySelector(".e-media-audio");r=n.querySelector(".e-media-youtube");t&&this._addClass(t,"e-hide");i&&this._addClass(i,"e-hide");r&&this._addClass(r,"e-hide")},r.prototype._getCurrentMediaFromType=function(n){var i=this._mediaDiv,t;return(t=ej.MediaPlayer.Types,n==t.Video)?i.querySelector(".e-media-video"):n==t.Audio?i.querySelector(".e-media-audio"):n==t.Youtube?i.querySelector(".e-media-youtube"):void 0},r.prototype._isYoutubeElement=function(n){if(n&&this._containsClass(n,"e-media-youtube"))return!0},r.prototype._createElement=function(n,t,i,r){var u,e,f;if(n&&n!=""){if(n=="video"?(u=document.createElement(n),r=!0):u=document.createElement(n),t&&t!=""&&(u.id=t),i&&i!="")for(e=i.split(" "),f=0;f<e.length;f++)this._addClass(u,e[f]);return u}return null},r.prototype._getYTVideoIdFromUrl=function(n){var i,t;return i=/^.*(youtu\.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/,t=n.match(i),t&&t[2].length==11?t[2]:void 0},r.prototype._getRandomNumber=function(n,t){if(t!=0){var i;return i=Math.floor(Math.random()*(t-n+1))+n,i==this._mediaIndex&&(i=this._getRandomNumber(0,t)),i}},r.prototype._getTimeFromSeconds=function(n){var u,t,i,r,f,e;return n=Number(n),u=Math.floor(n/3600),t=Math.floor(n%3600/60),i=Math.floor(n%3600%60),r,f,e,r=u>0?u+":":"",f=t>0?t<10&&r!=""?"0"+t+":":t+":":"0:",e=i>0?i<10?"0"+i:i:"00",r+f+e},r.prototype._addClass=function(n,t){n&&t&&(n.classList?n.classList.add(t):this._containsClass(n,t)||(n.className+=(n.className?" ":"")+t))},r.prototype._removeClass=function(n,t){var r,i;if(n)if(n.classList)n.classList.remove(t);else for(r=n.className.split(" "),n.className="",i=0;i<r.length;i++)r[i]!=t&&(n.className+=(n.className?" ":"")+r[i])},r.prototype._containsClass=function(n,t){var r,i;if(n){if(n.classList)return n.classList.contains(t);for(r=n.className.split(" "),i=0;i<r.length;i++)if(r[i]==t)return!0}},r.prototype._renderEJControls=function(n,i,r){var u=new ej[i](t(n),r)},r.prototype._getEJControlInstance=function(n,i){return t(n).data("ej"+i)},r.prototype._animate=function(n,i,r,u){r||(r=this._animationSpeed);t(n).animate(i,r,u)},r.prototype._stopAnimation=function(n){t(n).stop()},r.prototype._fadeIn=function(n){t(n).fadeIn("slow")},r.prototype._fadeOut=function(n){t(n).fadeOut("slow")},r.prototype._closest=function(n,i){var r=t(n).closest(i);if(r.length>0)return r[0]},r.prototype._addPlaylistItemsAjax=function(n,i){var r=this._playlist[i],u=this,f;r?r.type==ej.MediaPlayer.Types.Youtube?(f=this._getYTVideoIdFromUrl(r.url),t.ajax({url:"https://www.googleapis.com/youtube/v3/videos?id="+f+"?key="+this._APIKey+"=snippet",dataType:"jsonp",success:function(t){t&&t.items&&t.items[0]&&t.items[0].snippet?u._addYoutubePlaylistData(t,r,i):u._addDefaultPlaylistValue(r,i);u._addNextPlaylistItem(n,r,i)},error:function(){u._addDefaultPlaylistValue(r,i);u._addNextPlaylistItem(n,r,i)}})):(u._addDefaultPlaylistValue(r,i),u._addNextPlaylistItem(n,r,i)):u._generatePlaylistData(n)},r.prototype._setHTMLCustomAttributes=function(){Element.prototype.remove||(Element.prototype.remove=function(){this.parentNode&&this.parentNode.removeChild(this)})},r}(ej.WidgetBase);window.ej.widget("ejMediaPlayer","ej.MediaPlayer",new i);window.ejMediaPlayer=null})(jQuery);ej.MediaPlayer.Types={Audio:"audio",Video:"video",Youtube:"youtube"};ej.MediaPlayer.Quality={"240p":"small","360p":"medium","480p":"large","720p":"hd720","1080p":"hd1080",auto:"auto"};ej.MediaPlayer.SpeedText={Normal:"Normal"};ej.MediaPlayer.QualityText={Auto:"Auto"};ej.MediaPlayer.RenderMode={Basic:"basic",Advanced:"advanced",Mobile:"mobile"};ej.MediaPlayer.ContentType={Audio:"audio",Video:"video"};ej.MediaPlayer.Locale=ej.MediaPlayer.Locale||{};ej.MediaPlayer.Locale["default"]=ej.MediaPlayer.Locale["en-US"]={Play:"Play",Pause:"Pause",Mute:"Mute",Unmute:"Unmute",Settings:"Settings",FullScreen:"Full Screen",ExitFullScreen:"Exit Full Screen",HidePlaylist:"Hide Playlist",Previous:"Previous",Next:"Next",TogglePlaylist:"Toggle Playlist",Rewind:"Rewind",Forward:"Forward",Playlist:"Playlist",RepeatPlaylist:"Repeat Playlist",Shuffle:"Shuffle",VideoTitle:"Video",PlaylistTitle:"Playlist",PlaylistItemName:"List Item",PlaylistItemAuthor:"Author",Media:"Media"}});
