
intellisense.annotate(ej,{
Accordion:function(){
 /// <signature>
 /// <summary>Constructor of ej.Accordion</summary>
 /// </signature>
}
});
ej.Accordion=(function(){
var original=ej.Accordion
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addItem:function(header_name, content, index, isAjaxReq){
/// <signature>
/// <summary>
/// AddItem method is used to add the panel in dynamically. It receives the following parameters
/// </summary>
/// <param name="header_name"	type="string">specify the name of the header</param>
/// </signature>
/// <signature>
/// <summary>
/// AddItem method is used to add the panel in dynamically. It receives the following parameters
/// </summary>
/// <param name="content"	type="string">content of the new panel</param>
/// </signature>
/// <signature>
/// <summary>
/// AddItem method is used to add the panel in dynamically. It receives the following parameters
/// </summary>
/// <param name="index"	type="number">insertion place of the new panel</param>
/// </signature>
/// <signature>
/// <summary>
/// AddItem method is used to add the panel in dynamically. It receives the following parameters
/// </summary>
/// <param name="isAjaxReq"	type="boolean">Enable or disable the AJAX request to the added panel</param>
/// </signature>
},
collapseAll:function(){
/// <signature>
/// <summary>
/// This method used to collapse the all the expanded items in accordion at a time.
/// </summary>
},
collapsePanel:function(){
/// <signature>
/// <summary>
/// This method used to Collapses the specified items in accordion at a time.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// destroy the Accordion widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// Disables the accordion widget includes all the headers and content panels.
/// </summary>
},
disableItems:function(index){
/// <signature>
/// <summary>
/// Disable the accordion widget item based on specified header index.
/// </summary>
/// <param name="index"	type="any[]">index values to disable the panels</param>
/// </signature>
},
enable:function(){
/// <signature>
/// <summary>
/// Enable the accordion widget includes all the headers and content panels.
/// </summary>
},
enableItems:function(index){
/// <signature>
/// <summary>
/// Enable the accordion widget item based on specified header index.
/// </summary>
/// <param name="index"	type="any[]">index values to enable the panels</param>
/// </signature>
},
expandAll:function(){
/// <signature>
/// <summary>
/// To expand all the accordion widget items.
/// </summary>
},
expandPanel:function(){
/// <signature>
/// <summary>
/// This method used to Expand the specified items in accordion at a time.
/// </summary>
},
getItemsCount:function(){
/// <signature>
/// <summary>
/// Returns the total number of panels in the control.
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// Hides the visible Accordion control.
/// </summary>
},
refresh:function(){
/// <signature>
/// <summary>
/// The refresh method is used to adjust the control size based on the parent element dimension.
/// </summary>
},
removeItem:function(index){
/// <signature>
/// <summary>
/// RemoveItem method is used to remove the specified index panel.It receives the parameter as number.
/// </summary>
/// <param name="index"	type="number">specify the index value for remove the accordion panel.</param>
/// </signature>
},
show:function(){
/// <signature>
/// <summary>
/// Shows the hidden Accordion control.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejAccordion=function(){
this.data("ejAccordion",new	ej.Accordion());
return this;
};
intellisense.annotate(jQuery.fn,{
ejAccordion :function (options) {
/// <signature>
/// <summary><br/>
///The Accordion control is an interface where lists of items can be collapsed or expanded. It has several collapsible panels where only one can be expanded at a time that is useful for dashboards where space is limited. Each Accordion control has a template for its header and its content.<br/><br/>
///Specifies the ajaxSettings option to load the content to the accordion control.
///<br/>ajaxSettings-AjaxSettings	default-null
///<br/><br/>
///It specifies, whether to enable or disable asynchronous request.
///<br/>async-boolean	default-
///<br/><br/>
///It specifies the page will be cached in the web browser.
///<br/>cache-boolean	default-
///<br/><br/>
///It specifies the type of data is send in the query string.
///<br/>contentType-string	default-
///<br/><br/>
///It specifies the data as an object, will be passed in the query string.
///<br/>data-any	default-
///<br/><br/>
///It specifies the type of data that you're expecting back from the response.
///<br/>dataType-string	default-
///<br/><br/>
///It specifies the HTTP request type.
///<br/>type-string	default-
///<br/><br/>
///Accordion headers can be expanded and collapsed on keyboard action.
///<br/>allowKeyboardNavigation-boolean	default-true
///<br/><br/>
///To set the Accordion headers Collapse Speed.
///<br/>collapseSpeed-number	default-300
///<br/><br/>
///Specifies the collapsible state of accordion control.
///<br/>collapsible-boolean	default-false
///<br/><br/>
///Sets the root CSS class for Accordion theme, which is used customize.
///<br/>cssClass-string	default-
///<br/><br/>
///Allows you to set the custom header Icon. It accepts two key values â€œheaderâ€, â€selectedHeaderâ€.
///<br/>customIcon-CustomIcon	default-{ header: e-collapse, selectedHeader: e-expand }
///<br/><br/>
///This class name set to collapsing header.
///<br/>header-string	default-
///<br/><br/>
///This class name set to expanded (active) header.
///<br/>selectedHeader-string	default-
///<br/><br/>
///Disables the specified indexed items in accordion.
///<br/>disabledItems-number[]	default-[]
///<br/><br/>
///Specifies the animation behavior in accordion.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///With this enabled property, you can enable or disable the Accordion.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Used to enable the disabled items in accordion.
///<br/>enabledItems-number[]	default-[]
///<br/><br/>
///Multiple content panels to activate at a time.
///<br/>enableMultipleOpen-boolean	default-false
///<br/><br/>
///Save current model value to browser cookies for maintaining states. When refreshing the accordion control page, the model value is applied from browser cookies or HTML 5local storage.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Display headers and panel text from right-to-left.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///The events API binds the action for activating the accordion header. Users can activate the header by using mouse actions such as mouse-over, mouse-up, mouse-down, and soon.
///<br/>events-string	default-click
///<br/><br/>
///To set the Accordion headers Expand Speed.
///<br/>expandSpeed-number	default-300
///<br/><br/>
///Sets the height for Accordion items header.
///<br/>headerSize-number|string	default-
///<br/><br/>
///Specifies height of the accordion.
///<br/>height-number|string	default-null
///<br/><br/>
///Adjusts the content panel height based on the given option (content, auto, or fill). By default, the panel heights are adjusted based on the content.
///<br/>heightAdjustMode-ej.Accordion.HeightAdjustMode|string	default-content
///<br/><br/>
///It allows to define the characteristics of the Accordion control. It will helps to extend the capability of an HTML element.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///The given index header will activate (open). If collapsible is set to true, and a negative value is given, then all headers are collapsed. Otherwise, the first panel isactivated.
///<br/>selectedItemIndex-number	default-0
///<br/><br/>
///Activate the specified indexed items of the accordion
///<br/>selectedItems-number[]	default-[0]
///<br/><br/>
///Used to determines the close button visibility an each accordion items. This close button helps to remove the accordion item from the control.
///<br/>showCloseButton-boolean	default-false
///<br/><br/>
///Displays rounded corner borders on the Accordion control's panels and headers.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Specifies width of the accordion.
///<br/>width-number|string	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Autocomplete:function(){
 /// <signature>
 /// <summary>Constructor of ej.Autocomplete</summary>
 /// </signature>
}
});
ej.Autocomplete=(function(){
var original=ej.Autocomplete
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

clearText:function(){
/// <signature>
/// <summary>
/// Clears the text in the Autocomplete textbox.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroys the Autocomplete widget.
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// Disables the autocomplete widget.
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// Enables the autocomplete widget.
/// </summary>
},
getSelectedItems:function(){
/// <signature>
/// <summary>
/// Returns objects (data object) of all the selected items in the autocomplete textbox.
/// </summary>
},
getValue:function(){
/// <signature>
/// <summary>
/// Returns the current selected value from the Autocomplete textbox.
/// </summary>
},
getActiveText:function(){
/// <signature>
/// <summary>
/// Returns the current active text value in the Autocomplete suggestion list.
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// Hides the Autocomplete suggestion list.
/// </summary>
},
search:function(){
/// <signature>
/// <summary>
/// Search the entered text and show it in the suggestion list if available.
/// </summary>
},
open:function(){
/// <signature>
/// <summary>
/// Open up the autocomplete suggestion popup with all list items.
/// </summary>
},
selectValueByKey:function(Key){
/// <signature>
/// <summary>
/// Sets the value of the Autocomplete textbox based on the given key value.
/// </summary>
/// <param name="Key"	type="string">The key value of the specific suggestion item.</param>
/// </signature>
},
selectValueByText:function(Text){
/// <signature>
/// <summary>
/// Sets the value of the Autocomplete textbox based on the given input text value.
/// </summary>
/// <param name="Text"	type="string">The text (label) value of the specific suggestion item.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejAutocomplete=function(){
this.data("ejAutocomplete",new	ej.Autocomplete());
return this;
};
intellisense.annotate(jQuery.fn,{
ejAutocomplete :function (options) {
/// <signature>
/// <summary><br/>
///The AutoComplete control is a textbox control that provides a list of suggestions based on the user query.When the users enters the text in the text box, the control performs a search operation and provides a list of results in the suggestion pop up. There are several filter types available to perform the search.<br/><br/>
///Customize "Add New" text (label) to be added in the autocomplete popup list for the entered text when there are no suggestions for it.
///<br/>addNewText-string	default-Add New
///<br/><br/>
///Allows new values to be added to the autocomplete input other than the values in the suggestion list. Normally, when there are no suggestions it will display â€œNo suggestionsâ€ label in the popup.
///<br/>allowAddNew-boolean	default-false
///<br/><br/>
///Enables or disables the sorting of suggestion list item. The default sort order is ascending order. You customize sort order.
///<br/>allowSorting-boolean	default-true
///<br/><br/>
///Enables or disables selecting the animation style for the popup list. Animation types can be selected through either of the following options,
///<br/>animateType-ej.Autocomplete.Animation|string	default-slide
///<br/><br/>
///To focus the items in the suggestion list when the popup is shown. By default first item will be focused.
///<br/>autoFocus-boolean	default-false
///<br/><br/>
///Enables or disables the case sensitive search.
///<br/>caseSensitiveSearch-boolean	default-false
///<br/><br/>
///The root class for the Autocomplete textbox widget which helps in customizing its theme.
///<br/>cssClass-string	default-&#226;€&#226;€
///<br/><br/>
///The data source contains the list of data for the suggestions list. It can be a string array or JSON array or service URL that returns JSON.
///<br/>dataSource-any|Array&lt;any&gt;	default-null
///<br/><br/>
///The time delay (in milliseconds) after which the suggestion popup will be shown.
///<br/>delaySuggestionTimeout-number	default-200
///<br/><br/>
///The special character which acts as a separator for the given words for multi-mode search i.e. the text after the delimiter are considered as a separate word or query for search operation.
///<br/>delimiterChar-string	default-&#226;€™,&#226;€™
///<br/><br/>
///The text to be displayed in the popup when there are no suggestions available for the entered text.
///<br/>emptyResultText-string	default-&#226;€œNo suggestions&#226;€
///<br/><br/>
///Fills the autocomplete textbox with the first matched item from the suggestion list automatically based on the entered text when enabled.
///<br/>enableAutoFill-boolean	default-false
///<br/><br/>
///Enables or disables the Autocomplete textbox widget.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Enables or disables displaying the duplicate names present in the search result.
///<br/>enableDistinct-boolean	default-false
///<br/><br/>
///Allows the current model values to be saved in local storage or browser cookies for state maintenance when it is set to true. While refreshing the page, it retains the model value from browser cookies or local storage.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Displays the Autocomplete widgetâ€™s content from right to left when enabled.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Mapping fields for the suggestion items of the Autocomplete textbox widget.
///<br/>fields-Fields	default-null
///<br/><br/>
///Used to group the suggestion list items.
///<br/>groupBy-string	default-
///<br/><br/>
///Defines the HTML attributes such as id, class, styles for the item.
///<br/>htmlAttributes-any	default-
///<br/><br/>
///Defines the specific field name which contains unique key values for the list items.
///<br/>key-string	default-
///<br/><br/>
///Defines the specific field name in the data source to load the suggestion list with data.
///<br/>text-string	default-
///<br/><br/>
///Specifies the search filter type. There are several types of search filter available such as â€˜startswithâ€™, â€˜containsâ€™, â€˜endswithâ€™, â€˜lessthanâ€™, â€˜lessthanorequalâ€™, â€˜greaterthanâ€™, â€˜greaterthanorequalâ€™, â€˜equalâ€™, â€˜notequalâ€™.
///<br/>filterType-string	default-ej.filterType.StartsWith
///<br/><br/>
///The height of the Autocomplete textbox.
///<br/>height-string|number	default-null
///<br/><br/>
///The search text can be highlighted in the AutoComplete suggestion list when enabled.
///<br/>highlightSearch-boolean	default-false
///<br/><br/>
///Number of items to be displayed in the suggestion list.
///<br/>itemsCount-number	default-0
///<br/><br/>
///To enable or disable the diacritic characters of the Autocomplete suggestion list when filtering.
///<br/>ignoreAccent-boolean	default-false
///<br/><br/>
///Set the localization culture for Autocomplete Widget.
///<br/>locale-string	default-
///<br/><br/>
///Minimum number of character to be entered in the Autocomplete textbox to show the suggestion list.
///<br/>minCharacter-number	default-1
///<br/><br/>
///An Autocomplete column collection can be defined and customized through the multiColumnSettings property.Column's header, field, and stringFormat can be define via multiColumnSettings properties.
///<br/>multiColumnSettings-MultiColumnSettings	default-
///<br/><br/>
///Allow list of data to be displayed in several columns.
///<br/>enable-boolean	default-false
///<br/><br/>
///Allow header text to be displayed in corresponding columns.
///<br/>showHeader-boolean	default-true
///<br/><br/>
///Displayed selected value and autocomplete search based on mentioned column value specified in that format.
///<br/>stringFormat-string	default-
///<br/><br/>
///This property allows user to search text for any number of fields in the suggestion list without modifying the selected text format.
///<br/>searchColumnIndices-Array&lt;any&gt;	default-
///<br/><br/>
///Field and Header Text collections can be defined and customized through columns field.
///<br/>columns-Array&lt;any&gt;	default-
///<br/><br/>
///Get or set a value that indicates to display the columns in the autocomplete mapping with column name of the dataSource.
///<br/>field-string	default-
///<br/><br/>
///Get or set a value that indicates to display the title of that particular column.
///<br/>headerText-string	default-
///<br/><br/>
///Gets or sets a value that indicates to render the multicolumn with custom theme.
///<br/>cssClass-string	default-
///<br/><br/>
///Specifies the search data type. There are four types of data types available such as string, â€˜numberâ€™, â€˜booleanâ€™ and â€˜dateâ€™.
///<br/>type-ej.Type|string	default-ej.Type.String
///<br/><br/>
///Specifies the search filter type. There are several types of search filter available such as â€˜startswithâ€™, â€˜containsâ€™, â€˜endswithâ€™, â€˜lessthanâ€™, â€˜lessthanorequalâ€™, â€˜greaterthanâ€™, â€˜greaterthanorequalâ€™, â€˜equalâ€™, â€˜notequalâ€™.
///<br/>filterType-ej.filterType|string	default-ej.filterType.StartsWith
///<br/><br/>
///This defines the text alignment of a particular column header cell value. See headerTextAlign
///<br/>headerTextAlign-ej.TextAlign|string	default-ej.TextAlign.Left
///<br/><br/>
///Gets or sets a value that indicates to align the text within the column. See textAlign
///<br/>textAlign-ej.TextAlign|string	default-ej.TextAlign.Left
///<br/><br/>
///Enables or disables selecting multiple values from the suggestion list. Multiple values can be selected through either of the following options,
///<br/>multiSelectMode-ej.Autocomplete.MultiSelectMode|string	default-ej.MultiSelectMode.None
///<br/><br/>
///The height of the suggestion list.
///<br/>popupHeight-string	default-&#226;€œ152px&#226;€
///<br/><br/>
///The width of the suggestion list.
///<br/>popupWidth-string	default-&#226;€œauto&#226;€
///<br/><br/>
///The query to retrieve the data from the data source.
///<br/>query-ej.Query	default-null
///<br/><br/>
///Indicates that the autocomplete textbox values can only be readable.
///<br/>readOnly-boolean	default-false
///<br/><br/>
///Sets the value for the Autocomplete textbox based on the given input key value.
///<br/>selectValueByKey-number	default-
///<br/><br/>
///Enables or disables showing the message when there are no suggestions for the entered text.
///<br/>showEmptyResultText-boolean	default-true
///<br/><br/>
///Enables or disables the loading icon to intimate the searching operation. The loading icon is visible when there is a time delay to perform the search.
///<br/>showLoadingIcon-boolean	default-true
///<br/><br/>
///Enables the showPopup button in autocomplete textbox. When the showPopup button is clicked, it displays all the available data from the data source.
///<br/>showPopupButton-boolean	default-false
///<br/><br/>
///Enables or disables rounded corner.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Enables or disables reset icon to clear the textbox values.
///<br/>showResetIcon-boolean	default-false
///<br/><br/>
///Sort order specifies whether the suggestion list values has to be displayed in ascending or descending order.
///<br/>sortOrder-ej.Autocomplete.SortOrder|string	default-ej.SortOrder.Ascending
///<br/><br/>
///The template to display the suggestion list items with customized appearance.
///<br/>template-string	default-null
///<br/><br/>
///The jQuery validation error message to be displayed on form validation.
///<br/>validationMessage-any	default-null
///<br/><br/>
///The jQuery validation rules for form validation.
///<br/>validationRules-any	default-null
///<br/><br/>
///The value to be displayed in the autocomplete textbox.
///<br/>value-string	default-null
///<br/><br/>
///Enables or disables the visibility of the autocomplete textbox.
///<br/>visible-boolean	default-true
///<br/><br/>
///The text to be displayed when the value of the autocomplete textbox is empty.
///<br/>watermarkText-string	default-null
///<br/><br/>
///The width of the Autocomplete textbox.
///<br/>width-string|number	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Barcode:function(){
 /// <signature>
 /// <summary>Constructor of ej.Barcode</summary>
 /// </signature>
}
});
ej.Barcode=(function(){
var original=ej.Barcode
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

disable:function(){
/// <signature>
/// <summary>
/// To disable the barcode
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// To enable the barcode
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejBarcode=function(){
this.data("ejBarcode",new	ej.Barcode());
return this;
};
intellisense.annotate(jQuery.fn,{
ejBarcode :function (options) {
/// <signature>
/// <summary><br/>
///$(element).ejBarcode()<br/><br/>
///Specifies the distance between the barcode and text below it.
///<br/>barcodeToTextGapHeight-number	default-
///<br/><br/>
///Specifies the height of bars in the Barcode. By modifying the barHeight, the entire barcode height can be customized. Please refer to xDimension for two dimensional barcode height customization.
///<br/>barHeight-number	default-
///<br/><br/>
///Specifies the dark bar color of the Barcode. One dimensional barcode contains a series of dark and light bars which are usually colored as black and white respectively.
///<br/>darkBarColor-any	default-
///<br/><br/>
///Specifies whether the text below the barcode is visible or hidden.
///<br/>displayText-boolean	default-
///<br/><br/>
///Specifies whether the control is enabled.
///<br/>enabled-boolean	default-
///<br/><br/>
///Specifies the start and stop encode symbol in the Barcode. In one dimensional barcodes, an additional character is added as start and stop delimiters. These symbols are optional and the unique of the symbol allows the reader to determine the direction of the barcode being scanned.
///<br/>encodeStartStopSymbol-number	default-
///<br/><br/>
///Specifies the light bar color of the Barcode. One dimensional barcode contains a series of dark and light bars which are usually colored as black and white respectively.
///<br/>lightBarColor-any	default-
///<br/><br/>
///Specifies the width of the narrow bars in the barcode. The dark bars in the one dimensional barcode contains random narrow and wide bars based on the provided input which can be specified during initialization.
///<br/>narrowBarWidth-number	default-
///<br/><br/>
///Specifies the width of the quiet zone. In barcode, a quiet zone is the blank margin on either side of a barcode which informs the reader where a barcode's symbology starts and stops. The purpose of a quiet zone is to prevent the reader from picking up unrelated information.
///<br/>quietZone-QuietZone	default-
///<br/><br/>
///Specifies the quiet zone around the Barcode.
///<br/>all-number	default-
///<br/><br/>
///Specifies the bottom quiet zone of the Barcode.
///<br/>bottom-number	default-
///<br/><br/>
///Specifies the left quiet zone of the Barcode.
///<br/>left-number	default-
///<br/><br/>
///Specifies the right quiet zone of the Barcode.
///<br/>right-number	default-
///<br/><br/>
///Specifies the top quiet zone of the Barcode.
///<br/>top-number	default-
///<br/><br/>
///Specifies the type of the Barcode. See SymbologyType
///<br/>symbologyType-ej.datavisualization.Barcode.SymbologyType|string	default-
///<br/><br/>
///Specifies the text to be encoded in the barcode.
///<br/>text-string	default-
///<br/><br/>
///Specifies the color of the text/data at the bottom of the barcode.
///<br/>textColor-any	default-
///<br/><br/>
///Specifies the width of the wide bars in the barcode. One dimensional barcode usually contains random narrow and wide bars based on the provided which can be customized during initialization.
///<br/>wideBarWidth-number	default-
///<br/><br/>
///Specifies the width of the narrowest element(bar or space) in a barcode. The greater the x dimension, the more easily a barcode reader will scan.
///<br/>xDimension-number	default-
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
BulletGraph:function(){
 /// <signature>
 /// <summary>Constructor of ej.BulletGraph</summary>
 /// </signature>
}
});
ej.BulletGraph=(function(){
var original=ej.BulletGraph
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// To destroy the bullet graph
/// </summary>
},
redraw:function(){
/// <signature>
/// <summary>
/// To redraw the bullet graph
/// </summary>
},
setComparativeMeasureSymbol:function(index, measure){
/// <signature>
/// <summary>
/// To set the value for comparative measure in bullet graph.
/// </summary>
/// <param name="index"	type="number">value for the graph</param>
/// </signature>
/// <signature>
/// <summary>
/// To set the value for comparative measure in bullet graph.
/// </summary>
/// <param name="measure"	type="number">value for the graph</param>
/// </signature>
},
setFeatureMeasureBarValue:function(index, measure){
/// <signature>
/// <summary>
/// To set the value for feature measure bar.
/// </summary>
/// <param name="index"	type="number">value for the graph</param>
/// </signature>
/// <signature>
/// <summary>
/// To set the value for feature measure bar.
/// </summary>
/// <param name="measure"	type="number">value for the graph</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejBulletGraph=function(){
this.data("ejBulletGraph",new	ej.BulletGraph());
return this;
};
intellisense.annotate(jQuery.fn,{
ejBulletGraph :function (options) {
/// <signature>
/// <summary><br/>
///$(element).ejBulletGraph()<br/><br/>
///Toggles the visibility of the range stroke color of the labels.
///<br/>applyRangeStrokeToLabels-boolean	default-false
///<br/><br/>
///Toggles the visibility of the range stroke color of the ticks.
///<br/>applyRangeStrokeToTicks-boolean	default-false
///<br/><br/>
///Contains property to customize the caption in bullet graph.
///<br/>captionSettings-CaptionSettings	default-
///<br/><br/>
///Specifies whether trim the labels will be true or false.
///<br/>enableTrim-boolean	default-true
///<br/><br/>
///Contains property to customize the font of caption.
///<br/>font-any	default-
///<br/><br/>
///Specifies the color of the text in caption.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the fontFamily of caption. Caption text render with this fontFamily
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Specifies the fontStyle of caption
///<br/>fontStyle-ej.datavisualization.BulletGraph.FontStyle|string	default-Normal
///<br/><br/>
///Specifies the fontWeight of caption
///<br/>fontWeight-ej.datavisualization.BulletGraph.FontWeight|string	default-regular
///<br/><br/>
///Specifies the opacity of caption. Caption text render with this opacity.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the size of caption. Caption text render with this size
///<br/>size-string	default-12px
///<br/><br/>
///Contains property to customize the indicator.
///<br/>indicator-any	default-
///<br/><br/>
///Contains property to customize the font of indicator.
///<br/>font-any	default-
///<br/><br/>
///Specifies the color of the indicator's text.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the fontFamily of indicator. Indicator text render with this fontFamily.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Specifies the fontStyle of indicator. Indicator text render with this fontStyle. See FontStyle
///<br/>fontStyle-ej.datavisualization.BulletGraph.FontStyle|string	default-Normal
///<br/><br/>
///Specifies the fontWeight of indicator. Indicator text render with this fontWeight. See FontWeight
///<br/>fontWeight-ej.datavisualization.BulletGraph.FontWeight|string	default-regular
///<br/><br/>
///Specifies the opacity of indicator text. Indicator text render with this Opacity.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the size of indicator. Indicator text render with this size.
///<br/>size-string	default-12px
///<br/><br/>
///Contains property to customize the location of indicator.
///<br/>location-any	default-
///<br/><br/>
///Specifies the horizontal position of the indicator.
///<br/>x-number	default-10
///<br/><br/>
///Specifies the vertical position of the indicator.
///<br/>y-number	default-60
///<br/><br/>
///Specifies the padding to be applied when text position is used.
///<br/>padding-number	default-2
///<br/><br/>
///Contains property to customize the symbol of indicator.
///<br/>symbol-any	default-
///<br/><br/>
///Contains property to customize the border of indicator symbol.
///<br/>border-any	default-
///<br/><br/>
///Specifies the border color of indicator symbol.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the border width of indicator symbol.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the color of indicator symbol.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the URL of image that represents indicator symbol.
///<br/>imageURL-string	default-
///<br/><br/>
///Specifies the opacity of indicator symbol.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the shape of indicator symbol.
///<br/>shape-string	default-
///<br/><br/>
///Contains property to customize the size of indicator symbol.
///<br/>size-any	default-
///<br/><br/>
///Specifies the height of indicator symbol.
///<br/>height-number	default-10
///<br/><br/>
///Specifies the width of indicator symbol.
///<br/>width-number	default-10
///<br/><br/>
///Specifies the text to be displayed as indicator text. By default difference between current value and target will be displayed
///<br/>text-string	default-
///<br/><br/>
///Specifies the alignment of indicator with respect to scale based on text position
///<br/>textAlignment-ej.datavisualization.BulletGraph.TextAlignment|string	default-&#39;Near&#39;
///<br/><br/>
///Specifies where indicator text should be anchored when indicator overlaps with other caption group text. Text will be anchored when overlapping caption group text are at same position. Anchoring is not applicable for float position.
///<br/>textAnchor-ej.datavisualization.BulletGraph.TextAnchor|string	default-&#39;start&#39;
///<br/><br/>
///indicator text render in the specified angle.
///<br/>textAngle-number	default-0
///<br/><br/>
///Specifies where indicator should be placed
///<br/>textPosition-ej.datavisualization.BulletGraph.TextPosition|string	default-&#39;float&#39;
///<br/><br/>
///Specifies the space between indicator symbol and text.
///<br/>textSpacing-number	default-3
///<br/><br/>
///Specifies whether indicator will be visible or not.
///<br/>visible-boolean	default-false
///<br/><br/>
///Contains property to customize the location.
///<br/>location-any	default-
///<br/><br/>
///Specifies the position in horizontal direction
///<br/>x-number	default-17
///<br/><br/>
///Specifies the position in horizontal direction
///<br/>y-number	default-30
///<br/><br/>
///Specifies the padding to be applied when text position is used.
///<br/>padding-number	default-5
///<br/><br/>
///Contains property to customize the subtitle.
///<br/>subTitle-any	default-
///<br/><br/>
///Contains property to customize the font of subtitle.
///<br/>font-any	default-
///<br/><br/>
///Specifies the color of the subtitle's text.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the fontFamily of subtitle. Subtitle text render with this fontFamily.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Specifies the fontStyle of subtitle. Subtitle text render with this fontStyle. See FontStyle
///<br/>fontStyle-ej.datavisualization.BulletGraph.FontStyle|string	default-Normal
///<br/><br/>
///Specifies the fontWeight of subtitle. Subtitle text render with this fontWeight. See FontWeight
///<br/>fontWeight-ej.datavisualization.BulletGraph.FontWeight|string	default-regular
///<br/><br/>
///Specifies the opacity of subtitle. Subtitle text render with this opacity.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the size of subtitle. Subtitle text render with this size.
///<br/>size-string	default-12px
///<br/><br/>
///Contains property to customize the location of subtitle.
///<br/>location-any	default-
///<br/><br/>
///Specifies the horizontal position of the subtitle.
///<br/>x-number	default-10
///<br/><br/>
///Specifies the vertical position of the subtitle.
///<br/>y-number	default-45
///<br/><br/>
///Specifies the padding to be applied when text position is used.
///<br/>padding-number	default-5
///<br/><br/>
///Specifies the text to be displayed as subtitle.
///<br/>text-string	default-
///<br/><br/>
///Specifies the alignment of sub title text with respect to scale. Alignment will not be applied in float position.
///<br/>textAlignment-ej.datavisualization.BulletGraph.TextAlignment|string	default-&#39;Near&#39;
///<br/><br/>
///Specifies where subtitle text should be anchored when sub title text overlaps with other caption group text. Text will be anchored when overlapping caption group text are at same position. Anchoring is not applicable for float position.
///<br/>textAnchor-ej.datavisualization.BulletGraph.TextAnchor|string	default-&#39;start&#39;
///<br/><br/>
///Subtitle render in the specified angle.
///<br/>textAngle-number	default-0
///<br/><br/>
///Specifies where sub title text should be placed.
///<br/>textPosition-ej.datavisualization.BulletGraph.TextPosition|string	default-&#39;float&#39;
///<br/><br/>
///Specifies the text to be displayed on bullet graph.
///<br/>text-string	default-
///<br/><br/>
///Specifies the alignment of caption text with respect to scale. This property will not be applied when text position is float.
///<br/>textAlignment-ej.datavisualization.BulletGraph.TextAlignment|string	default-&#39;Near&#39;
///<br/><br/>
///Specifies caption text anchoring when caption text overlaps with other caption group text. Text will be anchored when overlapping caption group text are at same position. Anchoring is not applicable for float position.
///<br/>textAnchor-ej.datavisualization.BulletGraph.TextAnchor|string	default-&#39;start&#39;
///<br/><br/>
///Specifies the angel in which the caption is rendered.
///<br/>textAngle-number	default-0
///<br/><br/>
///Specifies how caption text should be placed.
///<br/>textPosition-ej.datavisualization.BulletGraph.TextPosition|string	default-&#39;float&#39;
///<br/><br/>
///Comparative measure bar in bullet graph render till the specified value.
///<br/>comparativeMeasureValue-number	default-0
///<br/><br/>
///Toggles the animation of bullet graph.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Controls whether bullet graph has to be responsive while resizing.
///<br/>enableResizing-boolean	default-true
///<br/><br/>
///Specifies the direction of flow in bullet graph. Neither it may be backward nor forward. 
///<br/>flowDirection-ej.datavisualization.BulletGraph.FlowDirection|string	default-forward
///<br/><br/>
///Specifies the height of the bullet graph.
///<br/>height-number	default-90
///<br/><br/>
///Sets a value whether to make the bullet graph responsive on resize.
///<br/>isResponsive-boolean	default-true
///<br/><br/>
///Specifies to convert the date object to string, using locale settings.
///<br/>enableGroupSeparator-boolean	default-false
///<br/><br/>
///Name of the culture based on which bulletgraph should be localized.
///<br/>locale-string	default-en-US
///<br/><br/>
///Bullet graph will render in the specified orientation.
///<br/>orientation-ej.datavisualization.BulletGraph.Orientation|string	default-horizontal
///<br/><br/>
///Contains property to customize the qualitative ranges.
///<br/>qualitativeRanges-Array&lt;QualitativeRanges&gt;	default-
///<br/><br/>
///Specifies the ending range to which the qualitative ranges will render.
///<br/>rangeEnd-number	default-3
///<br/><br/>
///Specifies the opacity for the qualitative ranges.
///<br/>rangeOpacity-number	default-1
///<br/><br/>
///Specifies the stroke for the qualitative ranges.
///<br/>rangeStroke-string	default-null
///<br/><br/>
///Size of the qualitative range depends up on the specified value.
///<br/>qualitativeRangeSize-number	default-32
///<br/><br/>
///Length of the quantitative range depends up on the specified value.
///<br/>quantitativeScaleLength-number	default-475
///<br/><br/>
///Contains all the properties to customize quantitative scale.
///<br/>quantitativeScaleSettings-QuantitativeScaleSettings	default-
///<br/><br/>
///Contains property to customize the comparative measure.
///<br/>comparativeMeasureSettings-any	default-
///<br/><br/>
///Specifies the stroke of the comparative measure.
///<br/>stroke-number	default-null
///<br/><br/>
///Specifies the width of the comparative measure.
///<br/>width-number	default-5
///<br/><br/>
///Contains property to customize the featured measure.
///<br/>featuredMeasureSettings-any	default-
///<br/><br/>
///Specifies the Stroke of the featured measure in bullet graph.
///<br/>stroke-number	default-null
///<br/><br/>
///Specifies the width of the featured measure in bullet graph.
///<br/>width-number	default-2
///<br/><br/>
///Contains property to customize the featured measure.
///<br/>featureMeasures-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the category of feature measure.
///<br/>category-string	default-null
///<br/><br/>
///Comparative measure render till the specified value.
///<br/>comparativeMeasureValue-number	default-null
///<br/><br/>
///Feature measure render till the specified value.
///<br/>value-number	default-null
///<br/><br/>
///Contains property to customize the fields.
///<br/>fields-any	default-
///<br/><br/>
///Specifies the category of the bullet graph.
///<br/>category-string	default-null
///<br/><br/>
///Comparative measure render based on the values in the specified field.
///<br/>comparativeMeasure-string	default-null
///<br/><br/>
///Specifies the dataSource for the bullet graph.
///<br/>dataSource-any	default-null
///<br/><br/>
///Feature measure render based on the values in the specified field.
///<br/>featureMeasures-string	default-null
///<br/><br/>
///Specifies the query for fetching the values form data source to render the bullet graph.
///<br/>query-string	default-null
///<br/><br/>
///Specifies the name of the table.
///<br/>tableName-string	default-null
///<br/><br/>
///Specifies the interval for the Graph.
///<br/>interval-number	default-1
///<br/><br/>
///Contains property to customize the labels.
///<br/>labelSettings-any	default-
///<br/><br/>
///Contains property to customize the font of the labels in bullet graph.
///<br/>font-any	default-
///<br/><br/>
///Specifies the fontFamily of labels in bullet graph. Labels render with this fontFamily.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Specifies the fontStyle of labels in bullet graph. Labels render with this fontStyle. See FontStyle
///<br/>fontStyle-ej.datavisualization.BulletGraph.FontStyle|string	default-Normal
///<br/><br/>
///Specifies the fontWeight of labels in bullet graph. Labels render with this fontWeight. See FontWeight
///<br/>fontWeight-ej.datavisualization.BulletGraph.FontWeight|string	default-regular
///<br/><br/>
///Specifies the opacity of labels in bullet graph. Labels render with this opacity
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the placement of labels in bullet graph scale.
///<br/>labelPlacement-ej.datavisualization.BulletGraph.LabelPlacement|string	default-outside
///<br/><br/>
///Specifies the prefix to be added with labels in bullet graph.
///<br/>labelPrefix-string	default-Empty string
///<br/><br/>
///Specifies the suffix to be added after labels in bullet graph.
///<br/>labelSuffix-string	default-Empty string
///<br/><br/>
///Specifies the horizontal/vertical padding of labels.
///<br/>offset-number	default-15
///<br/><br/>
///Specifies the position of the labels to render either above or below the graph. See 
///<br/>position-ej.datavisualization.BulletGraph.LabelPosition|string	default-below
///<br/><br/>
///Specifies the Size of the labels.
///<br/>size-number	default-12
///<br/><br/>
///Specifies the stroke color of the labels in bullet graph.
///<br/>stroke-string	default-null
///<br/><br/>
///Contains property to customize the position of the quantitative scale
///<br/>location-any	default-
///<br/><br/>
///This property specifies the x position for rendering quantitative scale.
///<br/>x-number	default-10
///<br/><br/>
///This property specifies the y position for rendering quantitative scale.
///<br/>y-number	default-10
///<br/><br/>
///Contains property to customize the major tick lines.
///<br/>majorTickSettings-any	default-
///<br/><br/>
///Specifies the size of the major ticks.
///<br/>size-number	default-13
///<br/><br/>
///Specifies the stroke color of the major tick lines.
///<br/>stroke-string	default-null
///<br/><br/>
///Specifies the width of the major tick lines.
///<br/>width-number	default-2
///<br/><br/>
///Specifies the maximum value of the Graph.
///<br/>maximum-number	default-10
///<br/><br/>
///Specifies the minimum value of the Graph.
///<br/>minimum-number	default-0
///<br/><br/>
///Contains property to customize the minor ticks.
///<br/>minorTickSettings-any	default-
///<br/><br/>
///Specifies the size of minor ticks.
///<br/>size-number	default-7
///<br/><br/>
///Specifies the stroke color of minor ticks in bullet graph.
///<br/>stroke-string	default-null
///<br/><br/>
///Specifies the width of the minor ticks in bullet graph.
///<br/>width-number	default-2
///<br/><br/>
///The specified number of minor ticks will be rendered per interval.
///<br/>minorTicksPerInterval-number	default-4
///<br/><br/>
///Specifies the placement of ticks to render either inside or outside the scale.
///<br/>tickPlacement-ej.datavisualization.BulletGraph.TickPlacement|string	default-ej.datavisualization.BulletGraph.TickPlacement.Outside
///<br/><br/>
///Specifies the position of the ticks to render either above,below or inside
///<br/>tickPosition-ej.datavisualization.BulletGraph.TickPosition|string	default-ej.datavisualization.BulletGraph.TickPosition.Far
///<br/><br/>
///By specifying this property the user can change the theme of the bullet graph.
///<br/>theme-string	default-flatlight
///<br/><br/>
///Contains all the properties to customize tooltip.
///<br/>tooltipSettings-TooltipSettings	default-
///<br/><br/>
///Specifies template for caption tooltip
///<br/>captionTemplate-string	default-null
///<br/><br/>
///Toggles the visibility of caption tooltip
///<br/>enableCaptionTooltip-boolean	default-false
///<br/><br/>
///Specifies the ID of a div, which is to be displayed as tooltip.
///<br/>template-string	default-null
///<br/><br/>
///Toggles the visibility of tooltip
///<br/>visible-boolean	default-true
///<br/><br/>
///Feature measure bar in bullet graph render till the specified value.
///<br/>value-number	default-0
///<br/><br/>
///Specifies the width of the bullet graph.
///<br/>width-number	default-595
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Button:function(){
 /// <signature>
 /// <summary>Constructor of ej.Button</summary>
 /// </signature>
}
});
ej.Button=(function(){
var original=ej.Button
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// destroy the button widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// To disable the button
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// To enable the button
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejButton=function(){
this.data("ejButton",new	ej.Button());
return this;
};
intellisense.annotate(jQuery.fn,{
ejButton :function (options) {
/// <signature>
/// <summary><br/>
///Custom Design for HTML Button control.<br/><br/>
///Specifies the contentType of the Button. See below to know available ContentType
///<br/>contentType-ej.ContentType|string	default-ej.ContentType.TextOnly
///<br/><br/>
///Sets the root CSS class for Button theme, which is used customize.
///<br/>cssClass-string	default-
///<br/><br/>
///Specifies the button control state.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Specify the Right to Left direction to button
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Specifies the height of the Button.
///<br/>height-number	default-28
///<br/><br/>
///It allows to define the characteristics of the Button control. It will helps to extend the capability of an HTML element.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Specifies the image position of the Button. This image position is applicable only with the textandimage contentType property. The images can be positioned in both imageLeft and imageRight options. See below to know about available ImagePosition
///<br/>imagePosition-ej.ImagePosition|string	default-ej.ImagePosition.ImageLeft
///<br/><br/>
///Specifies the primary icon for Button. This icon will be displayed from the left margin of the button.
///<br/>prefixIcon-string	default-null
///<br/><br/>
///Convert the button as repeat button. It raises the 'Click' event repeatedly from the it is pressed until it is released.
///<br/>repeatButton-boolean	default-false
///<br/><br/>
///Displays the Button with rounded corners.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Specifies the size of the Button. See below to know available ButtonSize
///<br/>size-ej.ButtonSize|string	default-ej.ButtonSize.Normal
///<br/><br/>
///Specifies the secondary icon for Button. This icon will be displayed from the right margin of the button.
///<br/>suffixIcon-string	default-null
///<br/><br/>
///Specifies the text content for Button.
///<br/>text-string	default-null
///<br/><br/>
///Specified the time interval between two consecutive 'click' event on the button.
///<br/>timeInterval-string	default-150
///<br/><br/>
///Specifies the Type of the Button. See below to know available ButtonType
///<br/>type-ej.ButtonType|string	default-ej.ButtonType.Submit
///<br/><br/>
///Specifies the width of the Button.
///<br/>width-string|number	default-100px
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Calculate:function(){
 /// <signature>
 /// <summary>Constructor of ej.Calculate</summary>
 /// </signature>
}
});
ej.Calculate=(function(){
var original=ej.Calculate
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addCustomFunction:function(FormulaName, FunctionName){
/// <signature>
/// <summary>
/// Add the custom formulas with function in CalcEngine library
/// </summary>
/// <param name="FormulaName"	type="string">pass the formula name</param>
/// </signature>
/// <signature>
/// <summary>
/// Add the custom formulas with function in CalcEngine library
/// </summary>
/// <param name="FunctionName"	type="string">pass the custom function name to call</param>
/// </signature>
},
addNamedRange:function(Name, cellRange){
/// <signature>
/// <summary>
/// Adds a named range to the NamedRanges collection
/// </summary>
/// <param name="Name"	type="string">pass the namedRange's name</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds a named range to the NamedRanges collection
/// </summary>
/// <param name="cellRange"	type="string">pass the cell range of NamedRange</param>
/// </signature>
},
adjustRangeArg:function(Name){
/// <signature>
/// <summary>
/// Accepts a possible parsed formula and returns the calculated value without quotes.
/// </summary>
/// <param name="Name"	type="string">pass the cell range to adjust its range</param>
/// </signature>
},
clearFormulaDependentCells:function(Cell){
/// <signature>
/// <summary>
/// When a formula cell changes, call this method to clear it from its dependent cells.
/// </summary>
/// <param name="Cell"	type="string">pass the changed cell address</param>
/// </signature>
},
clearLibraryComputationException:function(){
/// <signature>
/// <summary>
/// Call this method to clear whether an exception was raised during the computation of a library function.
/// </summary>
},
colIndex:function(Cell){
/// <signature>
/// <summary>
/// Get the column index from a cell reference passed in.
/// </summary>
/// <param name="Cell"	type="string">pass the cell address</param>
/// </signature>
},
computedValue:function(Formula){
/// <signature>
/// <summary>
/// Evaluates a parsed formula.
/// </summary>
/// <param name="Formula"	type="string">pass the parsed formula</param>
/// </signature>
},
computeFormula:function(Formula){
/// <signature>
/// <summary>
/// Evaluates a parsed formula.
/// </summary>
/// <param name="Formula"	type="string">pass the parsed formula</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejCalculate=function(){
this.data("ejCalculate",new	ej.Calculate());
return this;
};
intellisense.annotate(jQuery.fn,{
ejCalculate :function (options) {
/// <signature>
/// <summary><br/>
///Custom engine to perform calculation like excel sheet$(element).ejCalculate()Example{:.example}</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Captcha:function(){
 /// <signature>
 /// <summary>Constructor of ej.Captcha</summary>
 /// </signature>
}
});
ej.Captcha=(function(){
var original=ej.Captcha
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejCaptcha=function(){
this.data("ejCaptcha",new	ej.Captcha());
return this;
};
intellisense.annotate(jQuery.fn,{
ejCaptcha :function (options) {
/// <signature>
/// <summary><br/>
///Captcha is a popular technique that is used to prevent computer programs from sending automated requests and is used for meta-searching search engines, performing dictionary attacks in login pages, or sending spam by using mail servers. Captcha is validated at the time of form submission.<br/><br/>
///Specifies the character set of the Captcha that will be used to generate captcha text randomly.
///<br/>characterSet-string	default-
///<br/><br/>
///Specifies the error message to be displayed when the Captcha mismatch.
///<br/>customErrorMessage-string	default-
///<br/><br/>
///Set the Captcha validation automatically.
///<br/>enableAutoValidation-boolean	default-
///<br/><br/>
///Specifies the case sensitivity for the characters typed in the Captcha.
///<br/>enableCaseSensitivity-boolean	default-
///<br/><br/>
///Specifies the background patterns for the Captcha.
///<br/>enablePattern-boolean	default-
///<br/><br/>
///Sets the Captcha direction as right to left alignment.
///<br/>enableRTL-boolean	default-
///<br/><br/>
///Specifies the background appearance for the captcha.
///<br/>hatchStyle-ej.HatchStyle|string	default-
///<br/><br/>
///Specifies the height of the Captcha.
///<br/>height-number	default-
///<br/><br/>
///Specifies the method with values to be mapped in the Captcha.
///<br/>mapper-string	default-
///<br/><br/>
///Specifies the maximum number of characters used in the Captcha.
///<br/>maximumLength-number	default-
///<br/><br/>
///Specifies the minimum number of characters used in the Captcha.
///<br/>minimumLength-number	default-
///<br/><br/>
///Specifies the method to map values to Captcha.
///<br/>requestMapper-string	default-
///<br/><br/>
///Sets the Captcha with audio support, that enables to dictate the captcha text.
///<br/>showAudioButton-boolean	default-
///<br/><br/>
///Sets the Captcha with a refresh button.
///<br/>showRefreshButton-boolean	default-
///<br/><br/>
///Specifies the target button of the Captcha to validate the entered text and captcha text.
///<br/>targetButton-string	default-
///<br/><br/>
///Specifies the target input element that will verify the Captcha.
///<br/>targetInput-string	default-
///<br/><br/>
///Specifies the width of the Captcha.
///<br/>width-number	default-
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Chart:function(){
 /// <signature>
 /// <summary>Constructor of ej.Chart</summary>
 /// </signature>
}
});
ej.Chart=(function(){
var original=ej.Chart
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

animate:function(options){
/// <signature>
/// <summary>
/// Animates the series and/or indicators in Chart. When parameter is not passed to this method, then all the series and indicators present in Chart are animated.
/// </summary>
/// <param name="options"	type="any">If an array collection is passed as parameter, series and indicator objects passed in array collection are animated.ExampleIf a series or indicator object is passed to this method, then the specific series or indicator is animated.Example,</param>
/// </signature>
},
print:function(){
/// <signature>
/// <summary>
/// Prints the rendered chart.
/// </summary>
},
export:function(type, URL, exportMultipleChart){
/// <signature>
/// <summary>
/// Exports chart as an image or to an excel file. Chart can be exported as an image only when exportCanvasRendering option is set to true.
/// </summary>
/// <param name="type"	type="string">Type of the export operation to be performed. Following are the two export types that are supported now,1. 'image'2. 'excel'Example</param>
/// </signature>
/// <signature>
/// <summary>
/// Exports chart as an image or to an excel file. Chart can be exported as an image only when exportCanvasRendering option is set to true.
/// </summary>
/// <param name="URL"	type="string">URL of the service, where the chart will be exported to excel.Example,</param>
/// </signature>
/// <signature>
/// <summary>
/// Exports chart as an image or to an excel file. Chart can be exported as an image only when exportCanvasRendering option is set to true.
/// </summary>
/// <param name="exportMultipleChart"	type="boolean">When this parameter is true, all the chart objects initialized to the same document are exported to a single excel file. This is an optional parameter. By default, it is false.Example,</param>
/// </signature>
},
redraw:function(){
/// <signature>
/// <summary>
/// Redraws the entire chart. You can call this method whenever you update, add or remove points from the data source or whenever you want to refresh the UI.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejChart=function(){
this.data("ejChart",new	ej.Chart());
return this;
};
intellisense.annotate(jQuery.fn,{
ejChart :function (options) {
/// <signature>
/// <summary><br/>
///Essential chart can be easily configured to the DOM element, such as div. You can create a Chart with highly customizable look and feel.<br/><br/>
///Options for adding and customizing annotations in Chart.
///<br/>annotations-Array&lt;Annotations&gt;	default-
///<br/><br/>
///Angle to rotate the annotation in degrees.
///<br/>angle-number	default-&#39;0&#39;
///<br/><br/>
///Text content or id of a HTML element to be displayed as annotation.
///<br/>content-string	default-
///<br/><br/>
///Specifies how annotations have to be placed in Chart.
///<br/>coordinateUnit-ej.datavisualization.Chart.CoordinateUnit|string	default-none. See CoordinateUnit
///<br/><br/>
///Specifies the horizontal alignment of the annotation.
///<br/>horizontalAlignment-ej.datavisualization.Chart.HorizontalAlignment|string	default-middle. See HorizontalAlignment
///<br/><br/>
///Options to customize the margin of annotation.
///<br/>margin-any	default-
///<br/><br/>
///Annotation is placed at the specified value above its original position.
///<br/>bottom-number	default-0
///<br/><br/>
///Annotation is placed at the specified value from left side of its original position.
///<br/>left-number	default-0
///<br/><br/>
///Annotation is placed at the specified value from the right side of its original position.
///<br/>right-number	default-0
///<br/><br/>
///Annotation is placed at the specified value under its original position.
///<br/>top-number	default-0
///<br/><br/>
///Controls the opacity of the annotation.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies whether annotation has to be placed with respect to chart or series.
///<br/>region-ej.datavisualization.Chart.Region|string	default-chart. See Region
///<br/><br/>
///Specifies the vertical alignment of the annotation.
///<br/>verticalAlignment-ej.datavisualization.Chart.VerticalAlignment|string	default-middle. See VerticalAlignment
///<br/><br/>
///Controls the visibility of the annotation.
///<br/>visible-boolean	default-false
///<br/><br/>
///Represents the horizontal offset when coordinateUnit is pixels.when coordinateUnit is points, it represents the x-coordinate of axis bounded with xAxisName property or primary X axis when xAxisName is not provided.This property is not applicable when coordinateUnit is none.
///<br/>x-number	default-0
///<br/><br/>
///Name of the horizontal axis to be used for positioning the annotation. This property is applicable only when coordinateUnit is points.
///<br/>xAxisName-string	default-
///<br/><br/>
///Represents the vertical offset when coordinateUnit is pixels.When coordinateUnit is points, it represents the y-coordinate of axis bounded with yAxisName property or primary Y axis when yAxisName is not provided.This property is not applicable when coordinateUnit is none.
///<br/>y-number	default-0
///<br/><br/>
///Name of the vertical axis to be used for positioning the annotation.This property is applicable only when coordinateUnit is points.
///<br/>yAxisName-string	default-
///<br/><br/>
///Sets the background color of the  chart.
///<br/>background-string	default-transparent
///<br/><br/>
///URL of the image to be used as chart background.
///<br/>backGroundImageUrl-string	default-null
///<br/><br/>
///Options for customizing the color, opacity and width of the chart border.
///<br/>border-Border	default-
///<br/><br/>
///Border color of the chart.
///<br/>color-string	default-null
///<br/><br/>
///Opacity of the chart border.
///<br/>opacity-number	default-0.3
///<br/><br/>
///Width of the Chart border.
///<br/>width-number	default-0
///<br/><br/>
///This provides options for customizing export settings
///<br/>exportSettings-ExportSettings	default-
///<br/><br/>
///Specifies the downloading filename
///<br/>filename-string	default-chart
///<br/><br/>
///Specifies the name of the action URL
///<br/>action-string	default-
///<br/><br/>
///Specifies the angle for rotation
///<br/>angle-number	default-0
///<br/><br/>
///Specifies the format of the file to export
///<br/>type-ej.datavisualization.Chart.ExportingType|string	default-png
///<br/><br/>
///Specifies the orientation of the document
///<br/>orientation-ej.datavisualization.Chart.ExportingOrientation|string	default-portrait
///<br/><br/>
///Specifies the mode of exporting
///<br/>mode-ej.datavisualization.Chart.ExportingMode|string	default-client
///<br/><br/>
///Enable/ disable the multiple excel exporting
///<br/>multipleExport-boolean	default-false
///<br/><br/>
///Options for configuring the border and background of the plot area.
///<br/>chartArea-ChartArea	default-
///<br/><br/>
///Background color of the plot area.
///<br/>background-string	default-transparent
///<br/><br/>
///Options for customizing the border of the plot area.
///<br/>border-any	default-
///<br/><br/>
///Border color of the plot area.
///<br/>color-string	default-Gray
///<br/><br/>
///Opacity of the plot area border.
///<br/>opacity-number	default-0.3
///<br/><br/>
///Border width of the plot area.
///<br/>width-number	default-0.5
///<br/><br/>
///Options to split Chart into multiple plotting areas vertically. Each object in the collection represents a plotting area in Chart.
///<br/>columnDefinitions-Array&lt;ColumnDefinitions&gt;	default-
///<br/><br/>
///Specifies the unit to measure the width of the column in plotting area.
///<br/>unit-ej.datavisualization.Chart.Unit|string	default-&#39;pixel&#39;. See Unit
///<br/><br/>
///Width of the column in plotting area. Width is measured in either pixel or percentage based on the value of unit property.
///<br/>columnWidth-number	default-50
///<br/><br/>
///Color of the line that indicates the starting point of the column in plotting area.
///<br/>lineColor-string	default-transparent
///<br/><br/>
///Width of the line that indicates the starting point of the column in plot area.
///<br/>lineWidth-number	default-1
///<br/><br/>
///Options for configuring the properties of all the series. You can also override the options for specific series by using series collection.
///<br/>commonSeriesOptions-CommonSeriesOptions	default-
///<br/><br/>
///Specifies animation duration for series rendering
///<br/>animationDuration-string	default-null
///<br/><br/>
///Options to customize the border of all the series.
///<br/>border-any	default-
///<br/><br/>
///Border color of all series.
///<br/>color-string	default-transparent
///<br/><br/>
///DashArray for border of the series.
///<br/>dashArray-string	default-null
///<br/><br/>
///Border width of all series.
///<br/>width-number	default-1
///<br/><br/>
///To render the column and bar type series in rectangle/cylinder shape. See 
///<br/>columnFacet-ej.datavisualization.Chart.ColumnFacet|string	default-rectangle
///<br/><br/>
///Relative width of the columns in column type series. Value ranges from 0 to 1. Width also depends upon columnSpacing property.
///<br/>columnWidth-number	default-0.7
///<br/><br/>
///Spacing between columns of different series. Value ranges from 0 to 1
///<br/>columnSpacing-number	default-0
///<br/><br/>
///Enables or disables the visibility of legend item.
///<br/>visibleOnLegend-string	default-visible
///<br/><br/>
///Group of the stacking collection series.
///<br/>stackingGroup-string	default-
///<br/><br/>
///Pattern of dashes and gaps used to stroke all the line type series.
///<br/>dashArray-string	default-
///<br/><br/>
///Set the dataSource for all series. It can be an array of JSON objects or an instance of ej.DataManager.
///<br/>dataSource-any	default-null
///<br/><br/>
///Specifies spline tension value for cardinal spline type. Value ranges from 0 to 1.
///<br/>cardinalSplineTension-number	default-0.5
///<br/><br/>
///Controls the size of the hole in doughnut series. Value ranges from 0 to 1
///<br/>doughnutCoefficient-number	default-0.4
///<br/><br/>
///Controls the size of the doughnut series. Value ranges from 0 to 1.
///<br/>doughnutSize-number	default-0.8
///<br/><br/>
///Specifies the type of series to be drawn in radar or polar series. 
///<br/>drawType-ej.datavisualization.Chart.DrawType|string	default-line. See DrawType
///<br/><br/>
///Enable/disable the animation for all the series.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///To avoid overlapping of data labels smartly.
///<br/>enableSmartLabels-boolean	default-true
///<br/><br/>
///Start angle of pie/doughnut series.
///<br/>endAngle-number	default-null
///<br/><br/>
///Explodes the pie/doughnut slices on mouse move.
///<br/>explode-boolean	default-false
///<br/><br/>
///Explodes all the slice of pie/doughnut on render.
///<br/>explodeAll-boolean	default-false
///<br/><br/>
///Index of the point to be exploded from pie/doughnut/pyramid/funnel.
///<br/>explodeIndex-number	default-null
///<br/><br/>
///Specifies the distance of the slice from the center, when it is exploded.
///<br/>explodeOffset-number	default-0.4
///<br/><br/>
///Fill color for all the series.
///<br/>fill-string	default-null
///<br/><br/>
///Options for customizing the font of all the series.
///<br/>font-any	default-
///<br/><br/>
///Font color of the text in all series.
///<br/>color-string	default-#707070
///<br/><br/>
///Font Family for all the series.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Specifies the font Style for all the series.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-normal
///<br/><br/>
///Specifies the font weight for all the series.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-regular
///<br/><br/>
///Opacity for text in all the series.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size for text in all the series.
///<br/>size-string	default-12px
///<br/><br/>
///Sets the height of the funnel in funnel series. Values can be either pixel or percentage.
///<br/>funnelHeight-string	default-32.7%
///<br/><br/>
///Sets the width of the funnel in funnel series. Values can be either pixel or percentage.
///<br/>funnelWidth-string	default-11.6%
///<br/><br/>
///Gap between the slices in pyramid and funnel series.
///<br/>gapRatio-number	default-0
///<br/><br/>
///Specifies whether to join start and end point of a line/area series used in polar/radar chart to form a closed path.
///<br/>isClosed-boolean	default-true
///<br/><br/>
///Specifies whether to stack the column series in polar/radar charts.
///<br/>isStacking-boolean	default-false
///<br/><br/>
///Renders the chart vertically. This is applicable only for Cartesian type series.
///<br/>isTransposed-boolean	default-false
///<br/><br/>
///Render the x mark in the center of the box and whisker series type.x represents the average value of the box and whisker series.
///<br/>showMedian-boolean	default-true
///<br/><br/>
///Position of the data label in pie/doughnut/pyramid/funnel series. OutsideExtended position is not applicable for pyramid/funnel.
///<br/>labelPosition-ej.datavisualization.Chart.LabelPosition|string	default-inside. See LabelPosition
///<br/><br/>
///Specifies the mode for splitting the data points in pieOfPie series.
///<br/>splitMode-ej.datavisualization.Chart.SplitMode|string	default-value. See SplitMode
///<br/><br/>
///Quartile calculation has been performed in three different formulas to render the box and whisker series.
///<br/>boxPlotMode-ej.datavisualization.Chart.boxPlotMode|string	default-exclusive
///<br/><br/>
///Options for customizing the bubble options of the Bubble series
///<br/>bubbleOptions-any	default-
///<br/><br/>
///Used for the calculation of the bubble radius based on the mode selected 
///<br/>radiusMode-ej.datavisualization.Chart.RadiusMode|string	default-minMax
///<br/><br/>
///Used for the setting the minimum radius of the bubble
///<br/>minRadius-number	default-1
///<br/><br/>
///Used for setting the maximum radius of the bubble
///<br/>maxRadius-number	default-3
///<br/><br/>
///To render the spline series curve in different forms. 
///<br/>splineType-ej.datavisualization.Chart.SplineType|string	default-natural. See SplineType
///<br/><br/>
///Specifies the line cap of the series. 
///<br/>lineCap-ej.datavisualization.Chart.LineCap|string	default-butt. See LineCap
///<br/><br/>
///Specifies the type of shape to be used where two lines meet.
///<br/>lineJoin-ej.datavisualization.Chart.LineJoin|string	default-round. See LineJoin
///<br/><br/>
///Options for displaying and customizing marker for individual point in a series. Marker contains shapes and/or data labels.
///<br/>marker-any	default-
///<br/><br/>
///Options for customizing the border of the marker shape.
///<br/>border-any	default-
///<br/><br/>
///Border color of the marker shape.
///<br/>color-string	default-white
///<br/><br/>
///Border width of the marker shape.
///<br/>width-number	default-3
///<br/><br/>
///Options for displaying and customizing data labels.
///<br/>dataLabel-any	default-
///<br/><br/>
///Angle of the data label in degrees. Only the text gets rotated, whereas the background and border does not rotate.
///<br/>angle-number	default-null
///<br/><br/>
///Maximum label width of the data label.
///<br/>maximumLabelWidth-number	default-null
///<br/><br/>
///Enable the wrap option to the data label.
///<br/>enableWrap-boolean	default-false
///<br/><br/>
///Enables saturation to the data label.
///<br/>enableContrastColor-boolean	default-false
///<br/><br/>
///Displays the partially visible labels inside the chart Area
///<br/>showEdgeLabels-boolean	default-false
///<br/><br/>
///Options for customizing the border of the data label.
///<br/>border-any	default-
///<br/><br/>
///Border color of the data label.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the data label.
///<br/>width-number	default-0.1
///<br/><br/>
///Options for displaying and customizing the line that connects point and data label.
///<br/>connectorLine-any	default-
///<br/><br/>
///Specifies when the connector has to be drawn as Bezier curve or straight line. This is applicable only for Pie and Doughnut chart types.
///<br/>type-ej.datavisualization.Chart.ConnectorLineType|string	default-line. See ConnectorLineType
///<br/><br/>
///Width of the connector.
///<br/>width-number	default-0.5
///<br/><br/>
///Color of the connector line.
///<br/>color-string	default-#565656
///<br/><br/>
///Height of the connector line.
///<br/>height-string	default-null
///<br/><br/>
///Background color of the data label.
///<br/>fill-string	default-null
///<br/><br/>
///Options for customizing the data label font.
///<br/>font-any	default-
///<br/><br/>
///Font family of the data label.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the data label.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-normal. See FontStyle
///<br/><br/>
///Font weight of the data label.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-regular. See FontWeight
///<br/><br/>
///Opacity of the text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font color of the data label text.
///<br/>color-string	default-null
///<br/><br/>
///Font size of the data label.
///<br/>size-string	default-12px
///<br/><br/>
///Horizontal alignment of the data label. 
///<br/>horizontalTextAlignment-ej.datavisualization.Chart.HorizontalTextAlignment|string	default-center
///<br/><br/>
///Margin of the text to its background shape. The size of the background shape increases based on the margin applied to its text.
///<br/>margin-any	default-
///<br/><br/>
///Bottom margin of the text.
///<br/>bottom-number	default-5
///<br/><br/>
///Left margin of the text.
///<br/>left-number	default-5
///<br/><br/>
///Right margin of the text.
///<br/>right-number	default-5
///<br/><br/>
///Top margin of the text.
///<br/>top-number	default-5
///<br/><br/>
///Opacity of the data label.
///<br/>opacity-number	default-1
///<br/><br/>
///Options for customizing the datalabel positions
///<br/>offset-any|number	default-
///<br/><br/>
///X value or horizontal offset to position the labels in chart.
///<br/>x-number	default-0
///<br/><br/>
///Y value or vertical offset to position the labels.
///<br/>y-number	default-0
///<br/><br/>
///Background shape of the data label. 
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-none. See Shape
///<br/><br/>
///Custom template to format the data label content. Use â€œpoint.xâ€ and â€œpoint.yâ€ as a placeholder text to display the corresponding data pointâ€™s x and y value.
///<br/>template-string	default-
///<br/><br/>
///Name of a field in data source, where datalabel text is displayed.
///<br/>textMappingName-string	default-
///<br/><br/>
///Specifies the position of the data label. This property can be used only for the series such as column, bar, stacked column, stacked bar, 100% stacked column, 100% stacked bar, candle and OHLC.
///<br/>textPosition-ej.datavisualization.Chart.TextPosition|string	default-top. See TextPosition
///<br/><br/>
///Vertical alignment of the data label. 
///<br/>verticalTextAlignment-ej.datavisualization.Chart.VerticalTextAlignment|string	default-center
///<br/><br/>
///Controls the visibility of the data labels.
///<br/>visible-boolean	default-false
///<br/><br/>
///Color of the marker shape.
///<br/>fill-string	default-null
///<br/><br/>
///The URL for the Image to be displayed as marker. In order to display image as marker, set series.marker.shape as â€˜imageâ€™.
///<br/>imageUrl-string	default-
///<br/><br/>
///Opacity of the marker.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the shape of the marker.
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-circle. See Shape
///<br/><br/>
///Options for customizing the size of the marker shape.
///<br/>size-any	default-
///<br/><br/>
///Height of the marker.
///<br/>height-number	default-6
///<br/><br/>
///Width of the marker.
///<br/>width-number	default-6
///<br/><br/>
///Controls the visibility of the marker shape.
///<br/>visible-boolean	default-false
///<br/><br/>
///Opacity of the series.
///<br/>opacity-number	default-1
///<br/><br/>
///Options for customizing the outlier of the series.
///<br/>outlierSettings-any	default-
///<br/><br/>
///Specifies the shape of the outlier.
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-circle. See Shape
///<br/><br/>
///Options for customizing the size of the outlier shape.
///<br/>size-any	default-
///<br/><br/>
///Height of the outlier shape.
///<br/>height-number	default-6
///<br/><br/>
///Width of the outlier shape.
///<br/>width-number	default-6
///<br/><br/>
///Name of a field in data source, where the fill color for all the data points is generated.
///<br/>palette-string	default-
///<br/><br/>
///Controls the size of pie series. Value ranges from 0 to 1.
///<br/>pieCoefficient-number	default-0.8
///<br/><br/>
///Controls the size of the second pie in pieOfPie series. Value ranges from 0 to 1.
///<br/>pieOfPieCoefficient-number	default-0.6
///<br/><br/>
///Split Value of pieOfPie series.
///<br/>splitValue-string	default-null
///<br/><br/>
///Distance between the two pie's in pieOfPie series.
///<br/>gapWidth-number	default-50
///<br/><br/>
///Name of the property in the datasource that contains fill color for the series.
///<br/>pointColorMappingName-string	default-null
///<br/><br/>
///Specifies the mode of the pyramid series. 
///<br/>pyramidMode-ej.datavisualization.Chart.PyramidMode|string	default-linear. See PyramidMode
///<br/><br/>
///Start angle from where the pie/doughnut series renders. By default it starts from 0.
///<br/>startAngle-number	default-null
///<br/><br/>
///Options for customizing the corner radius. cornerRadius property also takes the numeric input and applies it for all the four corners of the column.
///<br/>cornerRadius-any	default-
///<br/><br/>
///Specifies the radius for the top left corner.
///<br/>topLeft-number	default-0
///<br/><br/>
///Specifies the radius for the top right corner.
///<br/>topRight-number	default-0
///<br/><br/>
///Specifies the radius for the bottom left corner.
///<br/>bottomLeft-number	default-0
///<br/><br/>
///Specifies the radius for the bottom right corner.
///<br/>bottomRight-number	default-0
///<br/><br/>
///Options for customizing the tooltip of chart.
///<br/>tooltip-any	default-
///<br/><br/>
///Options for customizing the border of the tooltip.
///<br/>border-any	default-
///<br/><br/>
///Border color of the tooltip.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the tooltip.
///<br/>width-number	default-1
///<br/><br/>
///Customize the corner radius of the tooltip rectangle.
///<br/>rx-number	default-0
///<br/><br/>
///Customize the corner radius of the tooltip rectangle.
///<br/>ry-number	default-0
///<br/><br/>
///Specifies the duration, the tooltip has to be displayed.
///<br/>duration-string	default-500ms
///<br/><br/>
///Enables/disables the animation of the tooltip when moving from one point to other.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Background color of the tooltip.
///<br/>fill-string	default-null
///<br/><br/>
///Format of the tooltip content.
///<br/>format-string	default-#point.x# : #point.y#
///<br/><br/>
///Opacity of the tooltip.
///<br/>opacity-number	default-0.5
///<br/><br/>
///Custom template to format the tooltip content. Use â€œpoint.xâ€ and â€œpoint.yâ€ as a placeholder text to display the corresponding data pointâ€™s x and y value.
///<br/>template-string	default-null
///<br/><br/>
///Controls the visibility of the tooltip.
///<br/>visible-boolean	default-false
///<br/><br/>
///Specifies the type of the series to render in chart. 
///<br/>type-ej.datavisualization.Chart.Type|string	default-column. See Type
///<br/><br/>
///Specifies the name of the x-axis that has to be associated with this series. Add an axis instance with this name to axes collection.
///<br/>xAxisName-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains x value for the series.
///<br/>xName-string	default-null
///<br/><br/>
///Specifies the name of the y-axis that has to be associated with this series. Add an axis instance with this name to axes collection.
///<br/>yAxisName-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains y value for the series.
///<br/>yName-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains high value for the series.
///<br/>high-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains low value for the series.
///<br/>low-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains open value for the series.
///<br/>open-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains close value for the series.
///<br/>close-string	default-null
///<br/><br/>
///Z-order of the series.
///<br/>zOrder-number	default-0
///<br/><br/>
///Name of the property in the datasource that contains the size value for the bubble series.
///<br/>size-string	default-null
///<br/><br/>
///Options for customizing the empty point in the series.
///<br/>emptyPointSettings-any	default-
///<br/><br/>
///Controls the visibility of the empty point.
///<br/>visible-boolean	default-true
///<br/><br/>
///Specifies the mode of empty point.
///<br/>displayMode-ej.datavisualization.Chart.EmptyPointMode|string	default-gap
///<br/><br/>
///Options for customizing the color and border of the empty point in the series.
///<br/>style-any	default-
///<br/><br/>
///Color of the empty point.
///<br/>color-string	default-
///<br/><br/>
///Options for customizing border of the empty point in the series.
///<br/>border-any	default-
///<br/><br/>
///Border color of the empty point.
///<br/>color-string	default-
///<br/><br/>
///Border width of the empty point.
///<br/>width-number	default-1
///<br/><br/>
///Fill color for the positive column of the waterfall.
///<br/>positiveFill-string	default-null
///<br/><br/>
///Options for customizing the waterfall connector line.
///<br/>connectorLine-any	default-
///<br/><br/>
///Width of the connector line.
///<br/>width-number	default-1
///<br/><br/>
///Color of the connector line.
///<br/>color-string	default-#565656
///<br/><br/>
///DashArray of the connector line.
///<br/>dashArray-string	default-null
///<br/><br/>
///DashArray of the connector line.
///<br/>opacity-number	default-1
///<br/><br/>
///Options to customize the drag and drop in series.
///<br/>dragSettings-any	default-
///<br/><br/>
///drag/drop the series
///<br/>enable-boolean	default-false
///<br/><br/>
///Specifies the type of drag settings.
///<br/>type-string	default-xy
///<br/><br/>
///Options to customize the error bar in series.
///<br/>errorBar-any	default-
///<br/><br/>
///Show/hides the error bar
///<br/>visibility-boolean	default-visible
///<br/><br/>
///Specifies the type of error bar.
///<br/>type-ej.datavisualization.Chart.ErrorBarType|string	default-FixedValue
///<br/><br/>
///Specifies the mode of error bar.
///<br/>mode-ej.datavisualization.Chart.ErrorBarMode|string	default-vertical
///<br/><br/>
///Specifies the direction of error bar.
///<br/>direction-ej.datavisualization.Chart.ErrorBarDirection|string	default-both
///<br/><br/>
///Value of vertical error bar.
///<br/>verticalErrorValue-number	default-3
///<br/><br/>
///Value of horizontal  error bar.
///<br/>horizontalErrorValue-number	default-1
///<br/><br/>
///Value of positive horizontal error bar.
///<br/>horizontalPositiveErrorValue-number	default-1
///<br/><br/>
///Value of negative horizontal error bar.
///<br/>horizontalNegativeErrorValue-number	default-1
///<br/><br/>
///Value of positive vertical error bar.
///<br/>verticalPositiveErrorValue-number	default-5
///<br/><br/>
///Value of negative vertical error bar.
///<br/>verticalNegativeErrorValue-number	default-5
///<br/><br/>
///Fill color of the error bar.
///<br/>fill-string	default-#000000
///<br/><br/>
///Width of the error bar.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the error bar cap.
///<br/>cap-any	default-
///<br/><br/>
///Show/Hides the error bar cap.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the error bar cap.
///<br/>width-number	default-1
///<br/><br/>
///Length of the error bar cap.
///<br/>length-number	default-1
///<br/><br/>
///Color of the error bar cap.
///<br/>fill-string	default-&#226;€œ#000000&#226;€
///<br/><br/>
///Option to add the trendlines to chart.
///<br/>trendlines-Array&lt;any&gt;	default-
///<br/><br/>
///Show/hides the trendline.
///<br/>visibility-boolean	default-
///<br/><br/>
///Show/hides the trendline legend.
///<br/>visibleOnLegend-string	default-visible
///<br/><br/>
///Specifies the type of the trendline for the series.
///<br/>type-ej.datavisualization.Chart.TrendlinesType|string	default-linear. See TrendlinesType
///<br/><br/>
///Name for the trendlines that is to be displayed in the legend text.
///<br/>name-string	default-trendline
///<br/><br/>
///Fill color of the trendlines.
///<br/>fill-string	default-#0000FF
///<br/><br/>
///Width of the trendlines.
///<br/>width-number	default-1
///<br/><br/>
///Opacity of the trendline.
///<br/>opacity-number	default-1
///<br/><br/>
///Pattern of dashes and gaps used to stroke the trendline.
///<br/>dashArray-string	default-
///<br/><br/>
///Future trends of the current series.
///<br/>forwardForecast-number	default-0
///<br/><br/>
///Past trends of the current series.
///<br/>backwardForecast-number	default-0
///<br/><br/>
///Specifies the order of the polynomial trendlines.
///<br/>polynomialOrder-number	default-0
///<br/><br/>
///Specifies the moving average starting period value.
///<br/>period-number	default-2
///<br/><br/>
///Options for customizing the tooltip of the trendlines in the chart.
///<br/>tooltip-any	default-
///<br/><br/>
///Options for customizing the border of the  trendline tooltip.
///<br/>border-any	default-
///<br/><br/>
///Border color of the trendline tooltip.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the trendline tooltip.
///<br/>width-number	default-1
///<br/><br/>
///Customize the corner radius of the trendline tooltip rectangle.
///<br/>rx-number	default-0
///<br/><br/>
///Customize the corner radius of the trendline tooltip rectangle.
///<br/>ry-number	default-0
///<br/><br/>
///Specifies the duration, the tooltip has to be displayed.
///<br/>duration-string	default-500ms
///<br/><br/>
///Enables/disables the animation of the trendline tooltip when moving from one point to other.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Background color of the trendline tooltip.
///<br/>fill-string	default-null
///<br/><br/>
///Format of the tooltip content displayed in the trendlines.
///<br/>format-string	default-#point.x# : #point.y#
///<br/><br/>
///Opacity of the trendline tooltip.
///<br/>opacity-number	default-0.5
///<br/><br/>
///Specifies the intercept value of the trendlines.
///<br/>intercept-number	default-null
///<br/><br/>
///Options for customizing the appearance of the series or data point while highlighting.
///<br/>highlightSettings-any	default-
///<br/><br/>
///Enables/disables the ability to highlight the series or data point interactively.
///<br/>enable-boolean	default-false
///<br/><br/>
///Specifies whether the series or data point has to be highlighted.
///<br/>mode-ej.datavisualization.Chart.Mode|string	default-series. See Mode
///<br/><br/>
///Color of the series/point on highlight.
///<br/>color-string	default-
///<br/><br/>
///Opacity of the series/point on highlight.
///<br/>opacity-number	default-0.6
///<br/><br/>
///Options for customizing the border of series on highlight.
///<br/>border-any	default-
///<br/><br/>
///Border color of the series/point on highlight.
///<br/>color-string	default-
///<br/><br/>
///Border width of the series/point on highlight.
///<br/>width-string	default-2
///<br/><br/>
///Specifies the pattern for the series/point on highlight.
///<br/>pattern-string	default-none. See Pattern
///<br/><br/>
///Custom pattern for the series on highlight.
///<br/>customPattern-string	default-
///<br/><br/>
///Options for customizing the appearance of the series/data point on selection.
///<br/>selectionSettings-any	default-
///<br/><br/>
///Enables/disables the ability to select a series/data point interactively.
///<br/>enable-boolean	default-false
///<br/><br/>
///Specifies the type of selection.
///<br/>type-ej.datavisualization.Chart.SelectionType|string	default-single
///<br/><br/>
///Specifies whether the series or data point has to be selected.
///<br/>mode-ej.datavisualization.Chart.Mode|string	default-series. See Mode
///<br/><br/>
///Specifies the drawn rectangle type.
///<br/>rangeType-ej.datavisualization.Chart.RangeType|string	default-xy
///<br/><br/>
///Color of the series/point on selection.
///<br/>color-string	default-
///<br/><br/>
///Opacity of the series/point on selection.
///<br/>opacity-number	default-0.6
///<br/><br/>
///Options for customizing the border of the series on selection.
///<br/>border-any	default-
///<br/><br/>
///Border color of the series/point on selection.
///<br/>color-string	default-
///<br/><br/>
///Border width of the series/point on selection.
///<br/>width-string	default-2
///<br/><br/>
///Specifies the pattern for the series/point on selection.
///<br/>pattern-string	default-none. See Pattern
///<br/><br/>
///Custom pattern for the series on selection.
///<br/>customPattern-string	default-
///<br/><br/>
///Options for displaying the chart along with selected points while loading
///<br/>selectedDataPointIndexes-Array&lt;any&gt;	default-[ ]
///<br/><br/>
///Options for displaying and customizing the crosshair.
///<br/>crosshair-Crosshair	default-
///<br/><br/>
///Options for customizing the trackball tooltip.
///<br/>trackballTooltipSettings-any	default-
///<br/><br/>
///Options for customizing the trackball tooltip border.
///<br/>border-any	default-
///<br/><br/>
///Border width of the trackball tooltip.
///<br/>width-number	default-null
///<br/><br/>
///Border color of the trackball tooltip.
///<br/>color-string	default-null
///<br/><br/>
///Background color of the trackball tooltip.
///<br/>fill-string	default-null
///<br/><br/>
///Rounded corner x value of the trackball tooltip.
///<br/>rx-number	default-3
///<br/><br/>
///Rounded corner y value of the trackball tooltip.
///<br/>ry-number	default-3
///<br/><br/>
///Opacity value of the trackball tooltip.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the mode of the trackball tooltip.
///<br/>mode-ej.datavisualization.Chart.CrosshairMode|string	default-float. See CrosshairMode
///<br/><br/>
///Options for customizing the marker in crosshair.
///<br/>marker-any	default-
///<br/><br/>
///Options for customizing the border.
///<br/>border-any	default-
///<br/><br/>
///Border width of the marker.
///<br/>width-number	default-3
///<br/><br/>
///Opacity of the marker.
///<br/>opacity-boolean	default-true
///<br/><br/>
///Options for customizing the size of the marker.
///<br/>size-any	default-
///<br/><br/>
///Height of the marker.
///<br/>height-number	default-10
///<br/><br/>
///Width of the marker.
///<br/>width-number	default-10
///<br/><br/>
///Show/hides the marker.
///<br/>visible-boolean	default-true
///<br/><br/>
///Options for customizing the crosshair line.
///<br/>line-any	default-
///<br/><br/>
///Color of the crosshair line.
///<br/>color-string	default-transparent
///<br/><br/>
///Width of the crosshair line.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the type of the crosshair. It can be trackball or crosshair
///<br/>type-ej.datavisualization.Chart.CrosshairType|string	default-crosshair. See CrosshairType
///<br/><br/>
///Show/hides the crosshair/trackball visibility.
///<br/>visible-boolean	default-false
///<br/><br/>
///Depth of the 3D Chart from front view of series to background wall. This property is applicable only for 3D view.
///<br/>depth-number	default-100
///<br/><br/>
///Controls whether 3D view has to be enabled or not. 3D view is supported only for column, bar. Stacking column, stacking bar, pie and doughnut series types.
///<br/>enable3D-boolean	default-false
///<br/><br/>
///Controls whether Chart has to be rendered as Canvas or SVG. Canvas rendering supports all functionalities in SVG rendering except 3D Charts.
///<br/>enableCanvasRendering-boolean	default-false
///<br/><br/>
///Controls whether the series has to be rendered at initial loading of chart, this will be useful in scenarios where chart is placed at the bottom of the web page and we need to render the series only when the chart is visible while scrolling to the top.
///<br/>initSeriesRender-boolean	default-true
///<br/><br/>
///Controls whether 3D view has to be rotated on dragging. This property is applicable only for 3D view.
///<br/>enableRotation-boolean	default-false
///<br/><br/>
///Options to customize the technical indicators.
///<br/>indicators-Array&lt;Indicators&gt;	default-
///<br/><br/>
///The dPeriod value for stochastic indicator.
///<br/>dPeriod-number	default-3
///<br/><br/>
///Enables/disables the animation.
///<br/>enableAnimation-boolean	default-false
///<br/><br/>
///Specifies animation duration for indicator rendering.
///<br/>animationDuration-boolean	default-null
///<br/><br/>
///Color of the technical indicator.
///<br/>fill-string	default-#00008B
///<br/><br/>
///Options to customize the histogram in MACD indicator.
///<br/>histogram-any	default-
///<br/><br/>
///Options to customize the histogram border in MACD indicator.
///<br/>border-any	default-
///<br/><br/>
///Color of the histogram border in MACD indicator.
///<br/>color-string	default-#9999ff
///<br/><br/>
///Controls the width of histogram border line in MACD indicator.
///<br/>width-number	default-1
///<br/><br/>
///Color of histogram columns in MACD indicator.
///<br/>fill-string	default-#ccccff
///<br/><br/>
///Opacity of histogram columns in MACD indicator.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the k period in stochastic indicator.
///<br/>kPeriod-number	default-3
///<br/><br/>
///Specifies the long period in MACD indicator.
///<br/>longPeriod-number	default-26
///<br/><br/>
///Options to customize the lower line in indicators.
///<br/>lowerLine-any	default-
///<br/><br/>
///Color of lower line.
///<br/>fill-string	default-#008000
///<br/><br/>
///Width of the lower line.
///<br/>width-number	default-2
///<br/><br/>
///Options to customize the MACD line.
///<br/>macdLine-any	default-
///<br/><br/>
///Color of MACD line.
///<br/>fill-string	default-#ff9933
///<br/><br/>
///Width of the MACD line.
///<br/>width-number	default-2
///<br/><br/>
///Specifies the type of the MACD indicator.
///<br/>macdType-string	default-line. See MACDType
///<br/><br/>
///Specifies period value in indicator.
///<br/>period-number	default-14
///<br/><br/>
///Options to customize the period line in indicators.
///<br/>periodLine-any	default-
///<br/><br/>
///Color of period line in indicator.
///<br/>fill-string	default-blue
///<br/><br/>
///Width of the period line in indicators.
///<br/>width-number	default-2
///<br/><br/>
///Name of the series for which indicator has to be drawn.
///<br/>seriesName-string	default-
///<br/><br/>
///Specifies the short period in MACD indicator.
///<br/>shortPeriod-number	default-13
///<br/><br/>
///Specifies the standard deviation value for Bollinger band indicator.
///<br/>standardDeviations-number	default-2
///<br/><br/>
///Options to customize the tooltip.
///<br/>tooltip-any	default-
///<br/><br/>
///Option to customize the border of indicator tooltip.
///<br/>border-any	default-
///<br/><br/>
///Border color of indicator tooltip.
///<br/>color-string	default-null
///<br/><br/>
///Border width of indicator tooltip.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the animation duration of indicator tooltip.
///<br/>duration-string	default-500ms
///<br/><br/>
///Enables/disables the tooltip animation.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Format of indicator tooltip. Use â€œpoint.xâ€ and â€œpoint.yâ€ as a placeholder text to display the corresponding data pointâ€™s x and y value.
///<br/>format-string	default-#point.x# : #point.y#
///<br/><br/>
///Background color of indicator tooltip.
///<br/>fill-string	default-null
///<br/><br/>
///Opacity of indicator tooltip.
///<br/>opacity-number	default-0.95
///<br/><br/>
///Controls the visibility of indicator tooltip.
///<br/>visible-boolean	default-false
///<br/><br/>
///Trigger value of MACD indicator.
///<br/>trigger-number	default-9
///<br/><br/>
///Specifies the visibility of indicator.
///<br/>visibility-string	default-visible
///<br/><br/>
///Specifies the type of indicator that has to be rendered.
///<br/>type-string	default-sma. See IndicatorsType
///<br/><br/>
///Options to customize the upper line in indicators
///<br/>upperLine-any	default-
///<br/><br/>
///Fill color of the upper line in indicators
///<br/>fill-string	default-#ff9933
///<br/><br/>
///Width of the upper line in indicators.
///<br/>width-number	default-2
///<br/><br/>
///Width of the indicator line.
///<br/>width-number	default-2
///<br/><br/>
///Name of the horizontal axis used for indicator. Primary X axis is used when x axis name is not specified.
///<br/>xAxisName-string	default-
///<br/><br/>
///Name of the vertical axis used for indicator. Primary Y axis is used when y axis name is not specified
///<br/>yAxisName-string	default-
///<br/><br/>
///Controls whether Chart has to be responsive while resizing.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Options to customize the legend items and legend title.
///<br/>legend-Legend	default-
///<br/><br/>
///Horizontal alignment of the legend.
///<br/>alignment-ej.datavisualization.Chart.Alignment|string	default-Center. See Alignment
///<br/><br/>
///Background for the legend. Use this property to add a background image or background color for the legend.
///<br/>background-string	default-
///<br/><br/>
///Options for customizing the legend border.
///<br/>border-any	default-
///<br/><br/>
///Border color of the legend.
///<br/>color-string	default-transparent
///<br/><br/>
///Border width of the legend.
///<br/>width-number	default-1
///<br/><br/>
///Number of columns to arrange the legend items.
///<br/>columnCount-number	default-null
///<br/><br/>
///Controls whether legend has to use scrollbar or not. When enabled, scroll bar appears depending upon size and position properties of legend.
///<br/>enableScrollbar-boolean	default-true
///<br/><br/>
///Fill color for the legend items. By using this property, it displays all legend item shapes in same color.Legend items representing invisible series is displayed in gray color.
///<br/>fill-string	default-null
///<br/><br/>
///Options to customize the font used for legend item text.
///<br/>font-any	default-
///<br/><br/>
///Font family for legend item text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style for legend item text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal. See FontStyle
///<br/><br/>
///Font weight for legend item text.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-Regular. See FontWeight
///<br/><br/>
///Font size for legend item text.
///<br/>size-string	default-12px
///<br/><br/>
///Gap or padding between the legend items.
///<br/>itemPadding-number	default-10
///<br/><br/>
///Options to customize the style of legend items.
///<br/>itemStyle-any	default-
///<br/><br/>
///Options for customizing the border of legend items.
///<br/>border-any	default-
///<br/><br/>
///Border color of the legend items.
///<br/>color-string	default-transparent
///<br/><br/>
///Border width of the legend items.
///<br/>width-number	default-1
///<br/><br/>
///Height of the shape in legend items.
///<br/>height-number	default-10
///<br/><br/>
///Width of the shape in legend items.
///<br/>width-number	default-10
///<br/><br/>
///Options to customize the location of chart legend. Legend is placed in provided location only when value of position property is custom
///<br/>location-any	default-
///<br/><br/>
///X value or horizontal offset to position the legend in chart.
///<br/>x-number	default-0
///<br/><br/>
///Y value or vertical offset to position the legend.
///<br/>y-number	default-0
///<br/><br/>
///Opacity of the legend.
///<br/>opacity-number	default-1
///<br/><br/>
///Places the legend at specified position. Legend can be placed at **left**, **right**, **top** or **bottom** of the chart area. To manually specify the location of legend, set **custom** as value to this property.
///<br/>position-ej.datavisualization.Chart.Position|string	default-Bottom. See Position
///<br/><br/>
///Number of rows to arrange the legend items.
///<br/>rowCount-number	default-null
///<br/><br/>
///Shape of the legend items. Default shape for pie and doughnut series is circle and all other series uses rectangle.
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-None. See Shape
///<br/><br/>
///Options to customize the size of the legend.
///<br/>size-any	default-
///<br/><br/>
///Height of the legend. Height can be specified in either pixel or percentage.
///<br/>height-string	default-null
///<br/><br/>
///Width of the legend. Width can be specified in either pixel or percentage.
///<br/>width-string	default-null
///<br/><br/>
///Options to customize the legend title.
///<br/>title-any	default-
///<br/><br/>
///Options to customize the font used for legend title
///<br/>font-any	default-
///<br/><br/>
///Font family for the text in legend title.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style for legend title.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-normal. See FontStyle
///<br/><br/>
///Font weight for legend title.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-normal. See FontWeight
///<br/><br/>
///Font size for legend title.
///<br/>size-string	default-12px
///<br/><br/>
///Text to be displayed in legend title.
///<br/>text-string	default-
///<br/><br/>
///Alignment of the legend title.
///<br/>textAlignment-ej.datavisualization.Chart.Alignment|string	default-center. See Alignment
///<br/><br/>
///Specifies the action taken when the legend width is more than the textWidth.
///<br/>textOverflow-ej.datavisualization.Chart.TextOverflow|string	default-none. See textOverflow
///<br/><br/>
///Text width for legend item.
///<br/>textWidth-number	default-34
///<br/><br/>
///Controls the visibility of the legend.
///<br/>visible-boolean	default-true
///<br/><br/>
///Controls the selection through the legend.
///<br/>toggleSeriesVisibility-boolean	default-true
///<br/><br/>
///Name of the culture based on which chart should be localized. Number and date time values are localized with respect to the culture name.String type properties like title text are not localized automatically. Provide localized text as value to string type properties.
///<br/>locale-string	default-en-US
///<br/><br/>
///Palette is used to store the series fill color in array and apply the color to series collection in the order of series index.
///<br/>palette-Array&lt;any&gt;	default-null
///<br/><br/>
///Options to customize the left, right, top and bottom margins of chart area.
///<br/>margin-Margin	default-
///<br/><br/>
///Spacing for the left margin of chart area. Setting positive value decreases the width of the chart area from left side.
///<br/>left-number	default-10
///<br/><br/>
///Spacing for the right margin of chart area. Setting positive value decreases the width of the chart area from right side.
///<br/>right-number	default-10
///<br/><br/>
///Spacing for the top margin of chart area. Setting positive value decreases the height of the chart area from the top.
///<br/>top-number	default-10
///<br/><br/>
///Spacing for the bottom margin of the chart area. Setting positive value decreases the height of the chart area from the bottom.
///<br/>bottom-number	default-10
///<br/><br/>
///Perspective angle of the 3D view. Chart appears closer when perspective angle is decreased, and distant when perspective angle is increased.This property is applicable only when 3D view is enabled
///<br/>perspectiveAngle-number	default-90
///<br/><br/>
///This is a horizontal axis that contains options to configure axis and it is the primary x axis for all the series in series array. To override x axis for particular series, create an axis object by providing unique name by using name property and add it to axes array. Then, assign the name to the seriesâ€™s xAxisName property to link both axis and series.
///<br/>primaryXAxis-PrimaryXAxis	default-
///<br/><br/>
///Options for customizing horizontal axis alternate grid band.
///<br/>alternateGridBand-any	default-
///<br/><br/>
///Options for customizing even grid band.
///<br/>even-any	default-
///<br/><br/>
///Fill color for the even grid bands.
///<br/>fill-string	default-transparent
///<br/><br/>
///Opacity of the even grid band.
///<br/>opacity-number	default-1
///<br/><br/>
///Options for customizing odd grid band.
///<br/>odd-any	default-
///<br/><br/>
///Fill color of the odd grid bands
///<br/>fill-string	default-transparent
///<br/><br/>
///Opacity of odd grid band
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies where horizontal axis should intersect the vertical axis or vice versa. Value should be provided in axis co-ordinates. If provided value is greater than the maximum value of crossing axis, then axis will be placed at the opposite side.
///<br/>crossesAt-number	default-null
///<br/><br/>
///Name of the axis used for crossing. Vertical axis name should be provided for horizontal axis and vice versa. If the provided name does not belongs to a valid axis, then primary X axis or primary Y axis will be used for crossing
///<br/>crossesInAxis-string	default-null
///<br/><br/>
///Category axis can also plot points based on index value of data points. Index based plotting can be enabled by setting â€˜isIndexedâ€™ property to true.
///<br/>isIndexed-boolean	default-false
///<br/><br/>
///Specifies the interval of the axis according to the zoomed data of the chart.
///<br/>enableAutoIntervalOnZooming-boolean	default-true
///<br/><br/>
///Options for customizing the axis line.
///<br/>axisLine-any	default-
///<br/><br/>
///Pattern of dashes and gaps to be applied to the axis line.
///<br/>dashArray-string	default-null
///<br/><br/>
///Padding for axis line. Normally, it is used along with plotOffset to pad the plot area.
///<br/>offset-number	default-null
///<br/><br/>
///Show/hides the axis line.
///<br/>visible-boolean	default-true
///<br/><br/>
///Default Value
///<br/>color-string	default-
///<br/><br/>
///Width of axis line.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the index of the column where the axis is associated, when the chart area is divided into multiple plot areas by using columnDefinitions.
///<br/>columnIndex-number	default-null
///<br/><br/>
///Specifies the number of columns or plot areas an axis has to span horizontally.
///<br/>columnSpan-number	default-null
///<br/><br/>
///Options to customize the crosshair label.
///<br/>crosshairLabel-any	default-
///<br/><br/>
///Show/hides the crosshair label associated with this axis.
///<br/>visible-boolean	default-false
///<br/><br/>
///With this setting, you can request axis to calculate intervals approximately equal to your desired interval.
///<br/>desiredIntervals-number	default-null
///<br/><br/>
///Specifies the placement of labels. 
///<br/>labelPlacement-ej.datavisualization.Chart.LabelPlacement|string	default-ej.datavisualization.Chart.LabelPlacement.BetweenTicks. See LabelPlacement
///<br/><br/>
///Specifies the position of labels at the edge of the axis. 
///<br/>edgeLabelPlacement-ej.datavisualization.Chart.EdgeLabelPlacement|string	default-ej.datavisualization.Chart.EdgeLabelPlacement.None. See EdgeLabelPlacement
///<br/><br/>
///Specifies whether to trim the axis label when the width of the label exceeds the maximumLabelWidth.
///<br/>enableTrim-boolean	default-false
///<br/><br/>
///Options for customizing the font of the axis Labels.
///<br/>font-any	default-
///<br/><br/>
///Font family of labels.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of labels.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-ej.datavisualization.Chart.FontStyle.Normal. See FontStyle
///<br/><br/>
///Font weight of the label.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-ej.datavisualization.Chart.FontWeight.Regular. See FontWeight
///<br/><br/>
///Opacity of the axis labels.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the axis labels.
///<br/>size-string	default-13px
///<br/><br/>
///Specifies the type of interval in date time axis.
///<br/>intervalType-ej.datavisualization.Chart.IntervalType|string	default-null. See IntervalType
///<br/><br/>
///Specifies whether to inverse the axis.
///<br/>isInversed-boolean	default-false
///<br/><br/>
///Custom formatting for axis label and supports all standard formatting type of numerical and date time values.
///<br/>labelFormat-string	default-null
///<br/><br/>
///Specifies the action to take when the axis labels are overlapping with each other. 
///<br/>labelIntersectAction-ej.datavisualization.Chart.LabelIntersectAction|string	default-ej.datavisualization.Chart.LabelIntersectAction.None. See LabelIntersectAction
///<br/><br/>
///Specifies the position of the axis labels.
///<br/>labelPosition-ej.datavisualization.Chart.LabelPosition|string	default-outside. See LabelPosition
///<br/><br/>
///Specifies the position of the axis labels.
///<br/>alignment-ej.datavisualization.Chart.LabelAlignment|string	default-center. See Alignment
///<br/><br/>
///Angle in degrees to rotate the axis labels.
///<br/>labelRotation-number	default-null
///<br/><br/>
///Logarithmic base value. This is applicable only for logarithmic axis.
///<br/>logBase-number	default-10
///<br/><br/>
///Options for customizing major gird lines.
///<br/>majorGridLines-any	default-
///<br/><br/>
///Pattern of dashes and gaps used to stroke the major grid lines.
///<br/>dashArray-string	default-null
///<br/><br/>
///Color of the major grid line.
///<br/>color-string	default-null
///<br/><br/>
///Opacity of major grid lines.
///<br/>opacity-number	default-1
///<br/><br/>
///Show/hides the major grid lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the major grid lines.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the major tick lines.
///<br/>majorTickLines-any	default-
///<br/><br/>
///Length of the major tick lines.
///<br/>size-number	default-5
///<br/><br/>
///Show/hides the major tick lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the major tick lines.
///<br/>width-number	default-1
///<br/><br/>
///Maximum number of labels to be displayed in every 100 pixels.
///<br/>maximumLabels-number	default-3
///<br/><br/>
///Maximum width of the axis label. When the label exceeds the width, the label gets trimmed when the enableTrim is set to true.
///<br/>maximumLabelWidth-number	default-34
///<br/><br/>
///Options for customizing the minor grid lines.
///<br/>minorGridLines-any	default-
///<br/><br/>
///Patterns of dashes and gaps used to stroke the minor grid lines.
///<br/>dashArray-string	default-null
///<br/><br/>
///Show/hides the minor grid lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the minorGridLines.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the minor tick lines.
///<br/>minorTickLines-any	default-
///<br/><br/>
///Length of the minor tick lines.
///<br/>size-number	default-5
///<br/><br/>
///Show/hides the minor tick lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the minor tick line.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the number of minor ticks per interval.
///<br/>minorTicksPerInterval-number	default-null
///<br/><br/>
///Unique name of the axis. To associate an axis with the series, you have to set this name to the xAxisName/yAxisName property of the series.
///<br/>name-string	default-null
///<br/><br/>
///Specifies whether to render the axis at the opposite side of its default position.
///<br/>opposedPosition-boolean	default-false
///<br/><br/>
///Specifies the orientation of the axis line
///<br/>orientation-ej.datavisualization.Chart.AxisOrientation|string	default-Horizontal
///<br/><br/>
///Specifies the padding for the plot area.
///<br/>plotOffset-number	default-10
///<br/><br/>
///Options to customize the range of the axis.
///<br/>range-any	default-
///<br/><br/>
///Minimum value of the axis range.
///<br/>min-number	default-null
///<br/><br/>
///Maximum value of the axis range.
///<br/>max-number	default-null
///<br/><br/>
///Interval of the axis range.
///<br/>interval-number	default-null
///<br/><br/>
///Specifies the padding for the axis range.
///<br/>rangePadding-ej.datavisualization.Chart.RangePadding|string	default-None. See RangePadding
///<br/><br/>
///Rounds the number to the given number of decimals.
///<br/>roundingPlaces-number	default-null
///<br/><br/>
///Options for customizing the multi level labels.
///<br/>multiLevelLabels-Array&lt;any&gt;	default-[ ]
///<br/><br/>
///Visibility of the multi level labels.
///<br/>visible-boolean	default-false
///<br/><br/>
///Text of the multi level labels.
///<br/>text-string	default-
///<br/><br/>
///Starting value of the multi level labels.
///<br/>start-any	default-null
///<br/><br/>
///Ending value of the multi level labels.
///<br/>end-any	default-null
///<br/><br/>
///Specifies the level of multi level labels.
///<br/>level-number	default-0
///<br/><br/>
///Specifies the maximum width of the text in multi level labels.
///<br/>maximumTextWidth-number	default-null
///<br/><br/>
///Specifies the alignment of the text in multi level labels.
///<br/>textAlignment-ej.datavisualization.Chart.TextAlignment|string	default-center. See TextAlignment
///<br/><br/>
///Specifies the handling of text over flow in multi level labels.
///<br/>textOverflow-ej.datavisualization.Chart.TextOverflow|string	default-center. See TextOverflow
///<br/><br/>
///Options for customizing the font of the text.
///<br/>font-any	default-
///<br/><br/>
///Font color of the multi level labels text.
///<br/>color-string	default-null
///<br/><br/>
///Font family of the multi level labels text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the multi level labels text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal
///<br/><br/>
///Font weight of the multi level label text.
///<br/>fontWeight-string	default-regular
///<br/><br/>
///Opacity of the multi level label text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the multi level label text.
///<br/>size-string	default-12px
///<br/><br/>
///Options for customizing the border of the series.
///<br/>border-any	default-
///<br/><br/>
///Border color of the multi level labels.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the multi level labels.
///<br/>width-number	default-1
///<br/><br/>
///Border type of the multi level labels.
///<br/>type-ej.datavisualization.Chart.MultiLevelLabelsBorderType|string	default-rectangle. See Type
///<br/><br/>
///Specifies whether the axis elements need to be placed nearby the axis line, while crossing.
///<br/>showNextToAxisLine-boolean	default-true
///<br/><br/>
///Options for customizing the strip lines.
///<br/>stripLine-Array&lt;any&gt;	default-[ ]
///<br/><br/>
///Border color of the strip line.
///<br/>borderColor-string	default-gray
///<br/><br/>
///Background color of the strip line.
///<br/>color-string	default-gray
///<br/><br/>
///End value of the strip line.
///<br/>end-number	default-null
///<br/><br/>
///Options for customizing the font of the text.
///<br/>font-any	default-
///<br/><br/>
///Font color of the strip line text.
///<br/>color-string	default-black
///<br/><br/>
///Font family of the strip line text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the strip line text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal
///<br/><br/>
///Font weight of the strip line text.
///<br/>fontWeight-string	default-regular
///<br/><br/>
///Opacity of the strip line text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the strip line text.
///<br/>size-string	default-12px
///<br/><br/>
///Start value of the strip line.
///<br/>start-number	default-null
///<br/><br/>
///Indicates whether to render the strip line from the minimum/start value of the axis. This property does not work when start property is set.
///<br/>startFromAxis-boolean	default-false
///<br/><br/>
///Specifies text to be displayed inside the strip line.
///<br/>text-string	default-stripLine
///<br/><br/>
///Specifies the alignment of the text inside the strip line.
///<br/>textAlignment-ej.datavisualization.Chart.TextAlignment|string	default-middlecenter. See TextAlignment
///<br/><br/>
///Show/hides the strip line.
///<br/>visible-boolean	default-false
///<br/><br/>
///Width of the strip line.
///<br/>width-number	default-0
///<br/><br/>
///Specifies the order where the strip line and the series have to be rendered. When Z-order is â€œbehindâ€, strip line is rendered under the series and when it is â€œoverâ€, it is rendered above the series.
///<br/>zIndex-ej.datavisualization.Chart.ZIndex|string	default-over. See ZIndex
///<br/><br/>
///Specifies the position of the axis tick lines.
///<br/>tickLinesPosition-ej.datavisualization.Chart.TickLinesPosition|string	default-outside. See TickLinesPosition
///<br/><br/>
///Options for customizing the border of the labels.
///<br/>labelBorder-any	default-
///<br/><br/>
///Specifies the color of the label border.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the width of the label border.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the axis title.
///<br/>title-any	default-
///<br/><br/>
///Specifies whether to trim the axis title when it exceeds the chart area or the maximum width of the title.
///<br/>enableTrim-boolean	default-false
///<br/><br/>
///Options for customizing the title font.
///<br/>font-any	default-
///<br/><br/>
///Font family of the title text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the title text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-ej.datavisualization.Chart.FontStyle.Normal
///<br/><br/>
///Font weight of the title text.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-ej.datavisualization.Chart.FontWeight.Regular. See FontWeight
///<br/><br/>
///Opacity of the axis title text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the axis title.
///<br/>size-string	default-16px
///<br/><br/>
///Maximum width of the title, when the title exceeds this width, the title gets trimmed, when enableTrim is true.
///<br/>maximumTitleWidth-number	default-34
///<br/><br/>
///Title for the axis.
///<br/>text-string	default-
///<br/><br/>
///Controls the visibility of axis title.
///<br/>visible-boolean	default-true
///<br/><br/>
///offset value for axis title.
///<br/>offset-number	default-0
///<br/><br/>
///Specifies the position of the axis title.
///<br/>position-ej.datavisualization.Chart.LabelPosition|string	default-outside. See Position
///<br/><br/>
///Specifies the position of the axis title.
///<br/>alignment-ej.datavisualization.Chart.TextAlignment|string	default-center. See Alignment
///<br/><br/>
///Specifies the type of data the axis is handling.
///<br/>valueType-ej.datavisualization.Chart.ValueType|string	default-null. See ValueType
///<br/><br/>
///Show/hides the axis.
///<br/>visible-boolean	default-true
///<br/><br/>
///The axis is scaled by this factor. When zoomFactor is 0.5, the chart is scaled by 200% along this axis. Value ranges from 0 to 1.
///<br/>zoomFactor-number	default-1
///<br/><br/>
///Position of the zoomed axis. Value ranges from 0 to 1.
///<br/>zoomPosition-number	default-0
///<br/><br/>
///Options for customizing the axis scrollbar
///<br/>scrollbarSettings-any	default-
///<br/><br/>
///Specifies to enables or disables the scroll bar.
///<br/>visible-boolean	default-false
///<br/><br/>
///Controls whether scrollbar has to be responsive in the chart.
///<br/>canResize-boolean	default-false
///<br/><br/>
///Options to customize the range for the scrollbar in the axis.
///<br/>range-any	default-
///<br/><br/>
///Minimum value of the scrollbar range.
///<br/>min-number	default-null
///<br/><br/>
///Maximum value for the scrollbar range .
///<br/>max-number	default-null
///<br/><br/>
///The maximum number of points to be displayed in the scrollbar.
///<br/>pointsLength-number	default-null
///<br/><br/>
///To override x axis for particular series, create an axis object by providing unique name by using name property and add it to axes array. Then, assign the name to the seriesâ€™s xAxisName property to link both axis and series.
///<br/>axes-Array&lt;Axes&gt;	default-
///<br/><br/>
///Options for customizing axis alternate grid band.
///<br/>alternateGridBand-any	default-
///<br/><br/>
///Options for customizing even grid band.
///<br/>even-any	default-
///<br/><br/>
///Fill color for the even grid bands.
///<br/>fill-string	default-transparent
///<br/><br/>
///Opacity of the even grid band.
///<br/>opacity-number	default-1
///<br/><br/>
///Options for customizing odd grid band.
///<br/>odd-any	default-
///<br/><br/>
///Fill color of the odd grid bands
///<br/>fill-string	default-transparent
///<br/><br/>
///Opacity of odd grid band
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies where axis should intersect the vertical axis or vice versa. Value should be provided in axis co-ordinates. If provided value is greater than the maximum value of crossing axis, then axis will be placed at the opposite side.
///<br/>crossesAt-number	default-null
///<br/><br/>
///Category axis can also plot points based on index value of data points. Index based plotting can be enabled by setting â€˜isIndexedâ€™ property to true.
///<br/>isIndexed-boolean	default-false
///<br/><br/>
///Options for customizing the axis line.
///<br/>axisLine-any	default-
///<br/><br/>
///Pattern of dashes and gaps to be applied to the axis line.
///<br/>dashArray-string	default-null
///<br/><br/>
///Padding for axis line. Normally, it is used along with plotOffset to pad the plot area.
///<br/>offset-number	default-null
///<br/><br/>
///Show/hides the axis line.
///<br/>visible-boolean	default-true
///<br/><br/>
///Color of axis line.
///<br/>color-string	default-
///<br/><br/>
///Width of axis line.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the index of the column where the axis is associated, when the chart area is divided into multiple plot areas by using columnDefinitions.
///<br/>columnIndex-number	default-null
///<br/><br/>
///Specifies the number of columns or plot areas an axis has to span horizontally.
///<br/>columnSpan-number	default-null
///<br/><br/>
///Options to customize the crosshair label.
///<br/>crosshairLabel-any	default-
///<br/><br/>
///Show/hides the crosshair label associated with this axis.
///<br/>visible-boolean	default-false
///<br/><br/>
///With this setting, you can request axis to calculate intervals approximately equal to your desired interval.
///<br/>desiredIntervals-number	default-null
///<br/><br/>
///Specifies the placement of labels.
///<br/>labelPlacement-ej.datavisualization.Chart.LabelPlacement|string	default-ej.datavisualization.Chart.LabelPlacement.BetweenTicks. See LabelPlacement
///<br/><br/>
///Specifies the position of labels at the edge of the axis.
///<br/>edgeLabelPlacement-ej.datavisualization.Chart.EdgeLabelPlacement|string	default-ej.datavisualization.Chart.EdgeLabelPlacement.None. See EdgeLabelPlacement
///<br/><br/>
///Specifies whether to trim the axis label when the width of the label exceeds the maximumLabelWidth.
///<br/>enableTrim-boolean	default-false
///<br/><br/>
///Specifies the interval of the axis according to the zoomed data of the chart.
///<br/>enableAutoIntervalOnZooming-boolean	default-true
///<br/><br/>
///Options for customizing the font of the axis Labels.
///<br/>font-any	default-
///<br/><br/>
///Font family of labels.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of labels.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-ej.datavisualization.Chart.FontStyle.Normal. See FontStyle
///<br/><br/>
///Font weight of the label.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-ej.datavisualization.Chart.FontWeight.Regular. See FontWeight
///<br/><br/>
///Opacity of the axis labels.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the axis labels.
///<br/>size-string	default-13px
///<br/><br/>
///Specifies the type of interval in date time axis.
///<br/>intervalType-ej.datavisualization.Chart.IntervalType|string	default-null. See IntervalType
///<br/><br/>
///Specifies whether to inverse the axis.
///<br/>isInversed-boolean	default-false
///<br/><br/>
///Custom formatting for axis label and supports all standard formatting type of numerical and date time values.
///<br/>labelFormat-string	default-null
///<br/><br/>
///Specifies the action to take when the axis labels are overlapping with each other.
///<br/>labelIntersectAction-ej.datavisualization.Chart.LabelIntersectAction|string	default-ej.datavisualization.Chart.LabelIntersectAction.None. See LabelIntersectAction
///<br/><br/>
///Specifies the position of the axis labels.
///<br/>labelPosition-ej.datavisualization.Chart.LabelPosition|string	default-outside. See LabelPosition
///<br/><br/>
///Specifies the position of the axis labels.
///<br/>alignment-ej.datavisualization.Chart.LabelAlignment|string	default-center. See Alignment
///<br/><br/>
///Angle in degrees to rotate the axis labels.
///<br/>labelRotation-number	default-null
///<br/><br/>
///Logarithmic base value. This is applicable only for logarithmic axis.
///<br/>logBase-number	default-10
///<br/><br/>
///Options for customizing major gird lines.
///<br/>majorGridLines-any	default-
///<br/><br/>
///Pattern of dashes and gaps used to stroke the major grid lines.
///<br/>dashArray-string	default-null
///<br/><br/>
///Color of the major grid line.
///<br/>color-string	default-null
///<br/><br/>
///Opacity of major grid lines.
///<br/>opacity-number	default-1
///<br/><br/>
///Show/hides the major grid lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the major grid lines.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the major tick lines.
///<br/>majorTickLines-any	default-
///<br/><br/>
///Length of the major tick lines.
///<br/>size-number	default-5
///<br/><br/>
///Show/hides the major tick lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the major tick lines.
///<br/>width-number	default-1
///<br/><br/>
///Maximum number of labels to be displayed in every 100 pixels.
///<br/>maximumLabels-number	default-3
///<br/><br/>
///Maximum width of the axis label. When the label exceeds the width, the label gets trimmed when the enableTrim is set to true.
///<br/>maximumLabelWidth-number	default-34
///<br/><br/>
///Options for customizing the minor grid lines.
///<br/>minorGridLines-any	default-
///<br/><br/>
///Patterns of dashes and gaps used to stroke the minor grid lines.
///<br/>dashArray-string	default-null
///<br/><br/>
///Show/hides the minor grid lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the minorGridLines.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the minor tick lines.
///<br/>minorTickLines-any	default-
///<br/><br/>
///Length of the minor tick lines.
///<br/>size-number	default-5
///<br/><br/>
///Show/hides the minor tick lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the minor tick line.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the number of minor ticks per interval.
///<br/>minorTicksPerInterval-number	default-null
///<br/><br/>
///Unique name of the axis. To associate an axis with the series, you have to set this name to the xAxisName/yAxisName property of the series.
///<br/>name-string	default-null
///<br/><br/>
///Specifies whether to render the axis at the opposite side of its default position.
///<br/>opposedPosition-boolean	default-false
///<br/><br/>
///Specifies the orientation of the axis line in the chart.
///<br/>orientation-ej.datavisualization.Chart.AxisOrientation|string	default-&#39;horizontal&#39;
///<br/><br/>
///Specifies the padding for the plot area.
///<br/>plotOffset-number	default-10
///<br/><br/>
///Options to customize the range of the axis.
///<br/>range-any	default-
///<br/><br/>
///Minimum value of the axis range.
///<br/>min-number	default-null
///<br/><br/>
///Maximum value of the axis range.
///<br/>max-number	default-null
///<br/><br/>
///Interval of the axis range.
///<br/>interval-number	default-null
///<br/><br/>
///Specifies the padding for the axis range.
///<br/>rangePadding-ej.datavisualization.Chart.RangePadding|string	default-None. See RangePadding
///<br/><br/>
///Rounds the number to the given number of decimals.
///<br/>roundingPlaces-number	default-null
///<br/><br/>
///Options for customizing the multi level labels.
///<br/>multiLevelLabels-Array&lt;any&gt;	default-[ ]
///<br/><br/>
///Visibility of the multi level labels.
///<br/>visible-boolean	default-false
///<br/><br/>
///Text of the multi level labels.
///<br/>text-string	default-
///<br/><br/>
///Starting value of the multi level labels.
///<br/>start-any	default-null
///<br/><br/>
///Ending value of the multi level labels.
///<br/>end-any	default-null
///<br/><br/>
///Specifies the level of multi level labels.
///<br/>level-number	default-0
///<br/><br/>
///Specifies the maximum width of the text in multi level labels.
///<br/>maximumTextWidth-number	default-null
///<br/><br/>
///Specifies the alignment of the text in multi level labels.
///<br/>textAlignment-ej.datavisualization.Chart.TextAlignment|string	default-center. See TextAlignment
///<br/><br/>
///Specifies the handling of text over flow in multi level labels.
///<br/>textOverflow-ej.datavisualization.Chart.TextOverflow|string	default-center. See TextOverflow
///<br/><br/>
///Options for customizing the font of the text.
///<br/>font-any	default-
///<br/><br/>
///Font color of the multi level labels text.
///<br/>color-string	default-null
///<br/><br/>
///Font family of the multi level labels text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the multi level labels text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal
///<br/><br/>
///Font weight of the multi level label text.
///<br/>fontWeight-string	default-regular
///<br/><br/>
///Opacity of the multi level label text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the multi level label text.
///<br/>size-string	default-12px
///<br/><br/>
///Options for customizing the border of the series.
///<br/>border-any	default-
///<br/><br/>
///Border color of the multi level labels.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the multi level labels.
///<br/>width-number	default-1
///<br/><br/>
///Border type of the multi level labels.
///<br/>type-ej.datavisualization.Chart.MultiLevelLabelsBorderType|string	default-rectangle. See Type
///<br/><br/>
///Specifies whether the axis elements need to be placed nearby the axis line, while crossing.
///<br/>showNextToAxisLine-boolean	default-true
///<br/><br/>
///Options for customizing the strip lines.
///<br/>stripLine-Array&lt;any&gt;	default-[ ]
///<br/><br/>
///Border color of the strip line.
///<br/>borderColor-string	default-gray
///<br/><br/>
///Background color of the strip line.
///<br/>color-string	default-gray
///<br/><br/>
///End value of the strip line.
///<br/>end-number	default-null
///<br/><br/>
///Options for customizing the font of the text.
///<br/>font-any	default-
///<br/><br/>
///Font color of the strip line text.
///<br/>color-string	default-black
///<br/><br/>
///Font family of the strip line text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the strip line text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal
///<br/><br/>
///Font weight of the strip line text.
///<br/>fontWeight-string	default-regular
///<br/><br/>
///Opacity of the strip line text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the strip line text.
///<br/>size-string	default-12px
///<br/><br/>
///Start value of the strip line.
///<br/>start-number	default-null
///<br/><br/>
///Indicates whether to render the strip line from the minimum/start value of the axis. This property does not work when start property is set.
///<br/>startFromAxis-boolean	default-false
///<br/><br/>
///Specifies text to be displayed inside the strip line.
///<br/>text-string	default-stripLine
///<br/><br/>
///Specifies the alignment of the text inside the strip line.
///<br/>textAlignment-ej.datavisualization.Chart.TextAlignment|string	default-middlecenter. See TextAlignment
///<br/><br/>
///Show/hides the strip line.
///<br/>visible-boolean	default-false
///<br/><br/>
///Width of the strip line.
///<br/>width-number	default-0
///<br/><br/>
///Specifies the order where the strip line and the series have to be rendered. When Z-order is â€œbehindâ€, strip line is rendered under the series and when it is â€œoverâ€, it is rendered above the series.
///<br/>zIndex-ej.datavisualization.Chart.ZIndex|string	default-over. See ZIndex
///<br/><br/>
///Specifies the position of the axis tick lines.
///<br/>tickLinesPosition-ej.datavisualization.Chart.TickLinesPosition|string	default-outside. See TickLinesPosition
///<br/><br/>
///Options for customizing the border of the labels.
///<br/>labelBorder-any	default-
///<br/><br/>
///Specifies the color of the label border.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the width of the label border.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the axis title.
///<br/>title-any	default-
///<br/><br/>
///Specifies whether to trim the axis title when it exceeds the chart area or the maximum width of the title.
///<br/>enableTrim-boolean	default-false
///<br/><br/>
///Options for customizing the title font.
///<br/>font-any	default-
///<br/><br/>
///Font family of the title text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the title text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-ej.datavisualization.Chart.FontStyle.Normal
///<br/><br/>
///Font weight of the title text.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-ej.datavisualization.Chart.FontWeight.Regular. See FontWeight
///<br/><br/>
///Opacity of the axis title text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the axis title.
///<br/>size-string	default-16px
///<br/><br/>
///Maximum width of the title, when the title exceeds this width, the title gets trimmed, when enableTrim is true.
///<br/>maximumTitleWidth-number	default-34
///<br/><br/>
///Title for the axis.
///<br/>text-string	default-
///<br/><br/>
///Controls the visibility of axis title.
///<br/>visible-boolean	default-true
///<br/><br/>
///offset value for axis title.
///<br/>offset-number	default-0
///<br/><br/>
///Specifies the position of the axis title.
///<br/>position-ej.datavisualization.Chart.LabelPosition|string	default-outside. See Position
///<br/><br/>
///Specifies the position of the axis title.
///<br/>alignment-ej.datavisualization.Chart.TextAlignment|string	default-center. See Alignment
///<br/><br/>
///Specifies the type of data the axis is handling.
///<br/>valueType-ej.datavisualization.Chart.ValueType|string	default-null. See ValueType
///<br/><br/>
///Show/hides the axis.
///<br/>visible-boolean	default-true
///<br/><br/>
///The axis is scaled by this factor. When zoomFactor is 0.5, the chart is scaled by 200% along this axis. Value ranges from 0 to 1.
///<br/>zoomFactor-number	default-1
///<br/><br/>
///Position of the zoomed axis. Value ranges from 0 to 1.
///<br/>zoomPosition-number	default-0
///<br/><br/>
///Options for customizing the axis scrollbar.
///<br/>scrollbarSettings-any	default-
///<br/><br/>
///Specifies to enable or disable the scrollbar.
///<br/>visible-boolean	default-false
///<br/><br/>
///Controls whether scrollbar has to be responsive in the chart.
///<br/>canResize-boolean	default-false
///<br/><br/>
///Options to customize the range for the scrollbar in the axis.
///<br/>range-any	default-
///<br/><br/>
///Minimum value of the scrollbar range.
///<br/>min-number	default-null
///<br/><br/>
///Maximum value for the scrollbar range .
///<br/>max-number	default-null
///<br/><br/>
///The maximum number of points to be displayed in the scrollbar.
///<br/>pointsLength-number	default-null
///<br/><br/>
///This is a vertical axis that contains options to configure axis. This is the primary y axis for all the series in series array. To override y axis for particular series, create an axis object by providing unique name by using name property and add it to axes array. Then, assign the name to the seriesâ€™s yAxisName property to link both axis and series.
///<br/>primaryYAxis-PrimaryYAxis	default-
///<br/><br/>
///Options for customizing vertical axis alternate grid band.
///<br/>alternateGridBand-any	default-
///<br/><br/>
///Options for customizing even grid band.
///<br/>even-any	default-
///<br/><br/>
///Fill color for the even grid bands.
///<br/>fill-string	default-transparent
///<br/><br/>
///Opacity of the even grid band.
///<br/>opacity-number	default-1
///<br/><br/>
///Options for customizing odd grid band.
///<br/>odd-any	default-
///<br/><br/>
///Fill color of the odd grid bands.
///<br/>fill-string	default-transparent
///<br/><br/>
///Opacity of odd grid band.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the interval of the axis according to the zoomed data of the chart.
///<br/>enableAutoIntervalOnZooming-boolean	default-true
///<br/><br/>
///Options for customizing the axis line.
///<br/>axisLine-any	default-
///<br/><br/>
///Pattern of dashes and gaps to be applied to the axis line.
///<br/>dashArray-string	default-null
///<br/><br/>
///Padding for axis line. Normally, it is used along with plotOffset to pad the plot area.
///<br/>offset-number	default-null
///<br/><br/>
///Show/hides the axis line.
///<br/>visible-boolean	default-true
///<br/><br/>
///Color of axis line.
///<br/>color-string	default-
///<br/><br/>
///Width of axis line.
///<br/>width-number	default-1
///<br/><br/>
///Specifies where horizontal axis should intersect the vertical axis or vice versa. Value should be provided in axis co-ordinates. If provided value is greater than the maximum value of crossing axis, then axis will be placed at the opposite side.
///<br/>crossesAt-number	default-null
///<br/><br/>
///Name of the axis used for crossing. Vertical axis name should be provided for horizontal axis and vice versa. If the provided name does not belongs to a valid axis, then primary X axis or primary Y axis will be used for crossing
///<br/>crossesInAxis-string	default-null
///<br/><br/>
///Options to customize the crosshair label.
///<br/>crosshairLabel-any	default-
///<br/><br/>
///Show/hides the crosshair label associated with this axis.
///<br/>visible-boolean	default-false
///<br/><br/>
///With this setting, you can request axis to calculate intervals approximately equal to your desired interval.
///<br/>desiredIntervals-number	default-null
///<br/><br/>
///Specifies the placement of labels.
///<br/>labelPlacement-ej.datavisualization.Chart.LabelPlacement|string	default-ej.datavisualization.Chart.LabelPlacement.BetweenTicks. See LabelPlacement
///<br/><br/>
///Specifies the position of labels at the edge of the axis.
///<br/>edgeLabelPlacement-ej.datavisualization.Chart.EdgeLabelPlacement|string	default-ej.datavisualization.Chart.EdgeLabelPlacement.None. See EdgeLabelPlacement
///<br/><br/>
///Specifies whether to trim the axis label when the width of the label exceeds the maximumLabelWidth.
///<br/>enableTrim-boolean	default-false
///<br/><br/>
///Options for customizing the font of the axis Labels.
///<br/>font-any	default-
///<br/><br/>
///Font family of labels.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of labels.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-ej.datavisualization.Chart.FontStyle.Normal. See FontStyle
///<br/><br/>
///Font weight of the label.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-ej.datavisualization.Chart.FontWeight.Regular. See FontWeight
///<br/><br/>
///Opacity of the axis labels.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the axis labels.
///<br/>size-string	default-13px
///<br/><br/>
///Specifies the type of interval in date time axis.
///<br/>intervalType-ej.datavisualization.Chart.IntervalType|string	default-null. See IntervalType
///<br/><br/>
///Specifies whether to inverse the axis.
///<br/>isInversed-boolean	default-false
///<br/><br/>
///Custom formatting for axis label and supports all standard formatting type of numerical and date time values.
///<br/>labelFormat-string	default-null
///<br/><br/>
///Specifies the action to take when the axis labels are overlapping with each other.
///<br/>labelIntersectAction-ej.datavisualization.Chart.LabelIntersectAction|string	default-ej.datavisualization.Chart.LabelIntersectAction.None
///<br/><br/>
///Specifies the position of the axis labels.
///<br/>labelPosition-ej.datavisualization.Chart.LabelPosition|string	default-outside. See LabelPosition
///<br/><br/>
///Specifies the position of the axis labels.
///<br/>alignment-ej.datavisualization.Chart.LabelAlignment|string	default-center. See Alignment
///<br/><br/>
///Logarithmic base value. This is applicable only for logarithmic axis.
///<br/>logBase-number	default-10
///<br/><br/>
///Options for customizing major gird lines.
///<br/>majorGridLines-any	default-
///<br/><br/>
///Pattern of dashes and gaps used to stroke the major grid lines.
///<br/>dashArray-string	default-null
///<br/><br/>
///Color of the major grid lines.
///<br/>color-string	default-null
///<br/><br/>
///Opacity of major grid lines.
///<br/>opacity-number	default-1
///<br/><br/>
///Show/hides the major grid lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the major grid lines.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the major tick lines.
///<br/>majorTickLines-any	default-
///<br/><br/>
///Length of the major tick lines.
///<br/>size-number	default-5
///<br/><br/>
///Show/hides the major tick lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the major tick lines.
///<br/>width-number	default-1
///<br/><br/>
///Maximum number of labels to be displayed in every 100 pixels.
///<br/>maximumLabels-number	default-3
///<br/><br/>
///Maximum width of the axis label. When the label exceeds the width, the label gets trimmed when the enableTrim is set to true.
///<br/>maximumLabelWidth-number	default-ej.datavisualization.Chart.maximumLabelWidth type {int}
///<br/><br/>
///Options for customizing the minor grid lines.
///<br/>minorGridLines-any	default-
///<br/><br/>
///Patterns of dashes and gaps used to stroke the minor grid lines.
///<br/>dashArray-string	default-null
///<br/><br/>
///Show/hides the minor grid lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the minorGridLines.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the minor tick lines.
///<br/>minorTickLines-any	default-
///<br/><br/>
///Length of the minor tick lines.
///<br/>size-number	default-5
///<br/><br/>
///Show/hides the minor tick lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the minor tick line
///<br/>width-number	default-1
///<br/><br/>
///Specifies the number of minor ticks per interval.
///<br/>minorTicksPerInterval-number	default-null
///<br/><br/>
///Unique name of the axis. To associate an axis with the series, you have to set this name to the xAxisName/yAxisName property of the series.
///<br/>name-string	default-null
///<br/><br/>
///Specifies whether to render the axis at the opposite side of its default position.
///<br/>opposedPosition-boolean	default-false
///<br/><br/>
///Specifies the orientation of the axis line in the chart.
///<br/>orientation-ej.datavisualization.Chart.AxisOrientation|string	default-Vertical
///<br/><br/>
///Specifies the padding for the plot area.
///<br/>plotOffset-number	default-10
///<br/><br/>
///Options to customize the range of the axis.
///<br/>range-any	default-
///<br/><br/>
///Minimum value of the axis range.
///<br/>min-number	default-null
///<br/><br/>
///Maximum value of the axis range.
///<br/>max-number	default-null
///<br/><br/>
///Interval for the range.
///<br/>interval-number	default-null
///<br/><br/>
///Specifies the padding for the axis range.
///<br/>rangePadding-ej.datavisualization.Chart.RangePadding|string	default-ej.datavisualization.Chart.RangePadding.None. See RangePadding
///<br/><br/>
///Rounds the number to the given number of decimals.
///<br/>roundingPlaces-number	default-null
///<br/><br/>
///Specifies the index of the row to which the axis is associated, when the chart area is divided into multiple plot areas by using rowDefinitions.
///<br/>rowIndex-number	default-null
///<br/><br/>
///Specifies the number of row or plot areas an axis has to span vertically.
///<br/>rowSpan-number	default-null
///<br/><br/>
///Options for customizing the multi level labels.
///<br/>multiLevelLabels-Array&lt;any&gt;	default-[ ]
///<br/><br/>
///Visibility of the multi level labels.
///<br/>visible-boolean	default-false
///<br/><br/>
///Text of the multi level labels.
///<br/>text-string	default-
///<br/><br/>
///Starting value of the multi level labels.
///<br/>start-number	default-null
///<br/><br/>
///Ending value of the multi level labels.
///<br/>end-number	default-null
///<br/><br/>
///Specifies the level of multi level labels.
///<br/>level-number	default-0
///<br/><br/>
///Specifies the maximum width of the text in multi level labels.
///<br/>maximumTextWidth-number	default-null
///<br/><br/>
///Specifies the alignment of the text in multi level labels.
///<br/>textAlignment-ej.datavisualization.Chart.TextAlignment|string	default-center. See TextAlignment
///<br/><br/>
///Specifies the handling of text over flow in multi level labels.
///<br/>textOverflow-ej.datavisualization.Chart.TextOverflow|string	default-center. See TextOverflow
///<br/><br/>
///Options for customizing the font of the text.
///<br/>font-any	default-
///<br/><br/>
///Font color of the multi level labels text.
///<br/>color-string	default-null
///<br/><br/>
///Font family of the multi level labels text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the multi level labels text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal
///<br/><br/>
///Font weight of the multi level label text.
///<br/>fontWeight-string	default-regular
///<br/><br/>
///Opacity of the multi level label text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the multi level label text.
///<br/>size-string	default-12px
///<br/><br/>
///Options for customizing the border of the series.
///<br/>border-any	default-
///<br/><br/>
///Border color of the multi level labels.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the multi level labels.
///<br/>width-number	default-1
///<br/><br/>
///Border type of the multi level labels.
///<br/>type-ej.datavisualization.Chart.MultiLevelLabelsBorderType|string	default-rectangle. See Type
///<br/><br/>
///Specifies whether the axis elements need to be placed nearby the axis line, while crossing.
///<br/>showNextToAxisLine-boolean	default-true
///<br/><br/>
///Options for customizing the axis scrollbar.
///<br/>scrollbarSettings-any	default-
///<br/><br/>
///Specifies to enable or disable the scrollbar.
///<br/>visible-boolean	default-false
///<br/><br/>
///Controls whether scrollbar has to be responsive in the chart.
///<br/>canResize-boolean	default-false
///<br/><br/>
///Options to customize the range for the scrollbar in the axis.
///<br/>range-any	default-
///<br/><br/>
///Minimum value of the scrollbar range.
///<br/>min-number	default-null
///<br/><br/>
///Maximum value for the scrollbar range .
///<br/>max-number	default-null
///<br/><br/>
///The maximum number of points to be displayed in the scrollbar.
///<br/>pointsLength-number	default-null
///<br/><br/>
///Options for customizing the strip lines.
///<br/>stripLine-Array&lt;any&gt;	default-[ ]
///<br/><br/>
///Border color of the strip line.
///<br/>borderColor-string	default-gray
///<br/><br/>
///Background color of the strip line.
///<br/>color-string	default-gray
///<br/><br/>
///End value of the strip line.
///<br/>end-number	default-null
///<br/><br/>
///Options for customizing the font of the text.
///<br/>font-any	default-
///<br/><br/>
///Font color of the strip line text.
///<br/>color-string	default-black
///<br/><br/>
///Font family of the strip line text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the strip line text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal
///<br/><br/>
///Font weight of the strip line text.
///<br/>fontWeight-string	default-regular
///<br/><br/>
///Opacity of the strip line text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the strip line text.
///<br/>size-string	default-12px
///<br/><br/>
///Start value of the strip line.
///<br/>start-number	default-null
///<br/><br/>
///Indicates whether to render the strip line from the minimum/start value of the axis. This property wonâ€™t work when start property is set.
///<br/>startFromAxis-boolean	default-false
///<br/><br/>
///Specifies text to be displayed inside the strip line.
///<br/>text-string	default-stripLine
///<br/><br/>
///Specifies the alignment of the text inside the strip line.
///<br/>textAlignment-ej.datavisualization.Chart.TextAlignment|string	default-middlecenter. See TextAlignment
///<br/><br/>
///Show/hides the strip line.
///<br/>visible-boolean	default-false
///<br/><br/>
///Width of the strip line.
///<br/>width-number	default-0
///<br/><br/>
///Specifies the order in which strip line and the series have to be rendered. When Z-order is â€œbehindâ€, strip line is rendered below the series and when it is â€œoverâ€, it is rendered above the series.
///<br/>zIndex-ej.datavisualization.Chart.ZIndex|string	default-over. See ZIndex
///<br/><br/>
///Specifies the position of the axis tick lines.
///<br/>tickLinesPosition-ej.datavisualization.Chart.TickLinesPosition|string	default-outside. See TickLinesPosition
///<br/><br/>
///Options for customizing the border of the labels.
///<br/>labelBorder-any	default-
///<br/><br/>
///Specifies the color of the label border.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the width of the label border.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the axis title.
///<br/>title-any	default-
///<br/><br/>
///Specifies whether to trim the axis title when it exceeds the chart area or the maximum width of the title.
///<br/>enableTrim-boolean	default-ej.datavisualization.Chart.enableTrim
///<br/><br/>
///Options for customizing the title font.
///<br/>font-any	default-
///<br/><br/>
///Font family of the title text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the title text.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-ej.datavisualization.Chart.FontStyle.Normal
///<br/><br/>
///Font weight of the title text.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-ej.datavisualization.Chart.FontWeight.Regular. See FontWeight
///<br/><br/>
///Opacity of the axis title text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the axis title.
///<br/>size-string	default-16px
///<br/><br/>
///Maximum width of the title, when the title exceeds this width, the title gets trimmed, when enableTrim is true.
///<br/>maximumTitleWidth-number	default-ej.datavisualization.Chart.maximumTitleWidth.null
///<br/><br/>
///Title for the axis.
///<br/>text-string	default-
///<br/><br/>
///Controls the visibility of axis title.
///<br/>visible-boolean	default-true
///<br/><br/>
///offset value for axis title.
///<br/>offset-number	default-0
///<br/><br/>
///Specifies the position of the axis title.
///<br/>position-ej.datavisualization.Chart.LabelPosition|string	default-outside. See Position
///<br/><br/>
///Specifies the position of the axis title.
///<br/>alignment-ej.datavisualization.Chart.TextAlignment|string	default-center. See Alignment
///<br/><br/>
///Specifies the type of data the axis is handling.
///<br/>valueType-ej.datavisualization.Chart.ValueType|string	default-null. See ValueType
///<br/><br/>
///Show/hides the axis.
///<br/>visible-boolean	default-true
///<br/><br/>
///The axis is scaled by this factor. When zoomFactor is 0.5, the chart is scaled by 200% along this axis. Values ranges from 0 to 1.
///<br/>zoomFactor-number	default-1
///<br/><br/>
///Position of the zoomed axis. Value ranges from 0 to 1
///<br/>zoomPosition-number	default-0
///<br/><br/>
///Rotation angle of the 3D view. This property is applicable only when 3D view is enabled.
///<br/>rotation-number	default-0
///<br/><br/>
///Options to split Chart into multiple plotting areas horizontally. Each object in the collection represents a plotting area in Chart.
///<br/>rowDefinitions-Array&lt;RowDefinitions&gt;	default-
///<br/><br/>
///Specifies the unit to measure the height of the row in plotting area.
///<br/>unit-ej.datavisualization.Chart.Unit|string	default-&#39;pixel&#39;. See Unit
///<br/><br/>
///Height of the row in plotting area. Height is measured in either pixel or percentage based on the value of unit property.
///<br/>rowHeight-number	default-50
///<br/><br/>
///Color of the line that indicates the starting point of the row in plotting area.
///<br/>lineColor-string	default-transparent
///<br/><br/>
///Width of the line that indicates the starting point of the row in plot area.
///<br/>lineWidth-number	default-1
///<br/><br/>
///Specifies the properties used for customizing the series.
///<br/>series-Array&lt;Series&gt;	default-
///<br/><br/>
///Color of the point, where the close is up in financial chart.
///<br/>bearFillColor-string	default-null
///<br/><br/>
///Options for customizing the border of the series.
///<br/>border-any	default-
///<br/><br/>
///Border color of the series.
///<br/>color-string	default-transparent
///<br/><br/>
///Border width of the series.
///<br/>width-number	default-1
///<br/><br/>
///DashArray for border of the series.
///<br/>dashArray-string	default-null
///<br/><br/>
///Specifies animation duration for series rendering.
///<br/>animationDuration-string	default-null
///<br/><br/>
///Color of the point, where the close is down in financial chart.
///<br/>bullFillColor-string	default-null
///<br/><br/>
///To render the column and bar type series in rectangle/cylinder shape. See ColumnFacet
///<br/>columnFacet-ej.datavisualization.Chart.ColumnFacet|string	default-rectangle
///<br/><br/>
///Relative width of the columns in column type series. Value ranges from 0 to 1. Width also depends upon columnSpacing property.
///<br/>columnWidth-number	default-0.7
///<br/><br/>
///Spacing between columns of different series. Value ranges from 0 to 1
///<br/>columnSpacing-number	default-0
///<br/><br/>
///To group the series of stacking collection.
///<br/>stackingGroup-string	default-
///<br/><br/>
///Pattern of dashes and gaps used to stroke the line type series.
///<br/>dashArray-string	default-
///<br/><br/>
///Specifies the dataSource for the series. It can be an array of JSON objects or an instance of ej.DataManager.
///<br/>dataSource-any	default-null
///<br/><br/>
///Specifies spline tension values for cardinal spline type.Value ranges from 0 to 1.
///<br/>cardinalSplineTension-number	default-0.5
///<br/><br/>
///Controls the size of the hole in doughnut series. Value ranges from 0 to 1.
///<br/>doughnutCoefficient-number	default-0.4
///<br/><br/>
///Controls the size of the doughnut series. Value ranges from 0 to 1.
///<br/>doughnutSize-number	default-0.8
///<br/><br/>
///Type of series to be drawn in radar or polar series.
///<br/>drawType-ej.datavisualization.Chart.DrawType|string	default-line. See DrawType
///<br/><br/>
///Enable/disable the animation of series.
///<br/>enableAnimation-boolean	default-false
///<br/><br/>
///To avoid overlapping of data labels smartly.
///<br/>enableSmartLabels-number	default-null
///<br/><br/>
///End angle of pie/doughnut series. For a complete circle, it has to be 360, by default.
///<br/>endAngle-number	default-null
///<br/><br/>
///Explodes the pie/doughnut slices on mouse move.
///<br/>explode-boolean	default-false
///<br/><br/>
///Explodes all the slice of pie/doughnut on render.
///<br/>explodeAll-boolean	default-null
///<br/><br/>
///Index of the point to be exploded from pie/doughnut/pyramid/funnel.
///<br/>explodeIndex-number	default-null
///<br/><br/>
///Specifies the distance of the slice from the center, when it is exploded.
///<br/>explodeOffset-number	default-25
///<br/><br/>
///Fill color of the series.
///<br/>fill-string	default-null
///<br/><br/>
///Options for customizing the series font.
///<br/>font-any	default-
///<br/><br/>
///Font color of the series text.
///<br/>color-string	default-#707070
///<br/><br/>
///Font Family of the series.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font Style of the series.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal
///<br/><br/>
///Font weight of the series.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-Regular
///<br/><br/>
///Opacity of series text.
///<br/>opacity-number	default-1
///<br/><br/>
///Size of the series text.
///<br/>size-string	default-12px
///<br/><br/>
///Specifies the height of the funnel in funnel series. Values can be in both pixel and percentage.
///<br/>funnelHeight-string	default-32.7%
///<br/><br/>
///Specifies the width of the funnel in funnel series. Values can be in both pixel and percentage.
///<br/>funnelWidth-string	default-11.6%
///<br/><br/>
///Gap between the slices of pyramid/funnel series.
///<br/>gapRatio-number	default-0
///<br/><br/>
///Specifies whether to join start and end point of a line/area series used in polar/radar chart to form a closed path.
///<br/>isClosed-boolean	default-true
///<br/><br/>
///Specifies whether to stack the column series in polar/radar charts.
///<br/>isStacking-boolean	default-true
///<br/><br/>
///Renders the chart vertically. This is applicable only for Cartesian type series.
///<br/>isTransposed-boolean	default-false
///<br/><br/>
///Render the x mark in the center of the box and whisker series type.x represents the average value of the box and whisker series.
///<br/>showMedian-boolean	default-true
///<br/><br/>
///Position of the data label in pie/doughnut/pyramid/funnel series. OutsideExtended position is not applicable for pyramid/funnel.
///<br/>labelPosition-ej.datavisualization.Chart.LabelPosition|string	default-inside. See LabelPosition
///<br/><br/>
///Specifies the mode for splitting the data points in pieOfPie series.
///<br/>splitMode-ej.datavisualization.Chart.SplitMode|string	default-value. See SplitMode
///<br/><br/>
///Quartile calculation has been performed in three different formulas to render the boxplot series .
///<br/>boxPlotMode-ej.datavisualization.Chart.LabelPosition|string	default-exclusive.See BoxPlotMode
///<br/><br/>
///Options for customizing the bubble options of the Bubble series
///<br/>bubbleOptions-any	default-
///<br/><br/>
///Used for the calculation of the bubble radius based on the mode selected
///<br/>radiusMode-ej.datavisualization.Chart.RadiusMode|string	default-minMax .See RadiusMode
///<br/><br/>
///Used for the setting the minimum radius of the bubble
///<br/>minRadius-number	default-1
///<br/><br/>
///Used for setting the maximum radius of the bubble
///<br/>maxRadius-number	default-3
///<br/><br/>
///Specifies the different types of spline curve.
///<br/>splineType-ej.datavisualization.Chart.SplineType|string	default-Natural. See SplineType
///<br/><br/>
///Specifies the line cap of the series.
///<br/>lineCap-ej.datavisualization.Chart.LineCap|string	default-Butt. See LineCap
///<br/><br/>
///Specifies the type of shape to be used where two lines meet.
///<br/>lineJoin-ej.datavisualization.Chart.LineJoin|string	default-Round. See LineJoin
///<br/><br/>
///Options for displaying and customizing marker for individual point in a series. Marker contains shapes and/or data labels.
///<br/>marker-any	default-
///<br/><br/>
///Options for customizing the border of the marker shape.
///<br/>border-any	default-
///<br/><br/>
///Border color of the marker shape.
///<br/>color-string	default-white
///<br/><br/>
///Border width of the marker shape.
///<br/>width-number	default-3
///<br/><br/>
///Options for displaying and customizing data labels.
///<br/>dataLabel-any	default-
///<br/><br/>
///Angle of the data label in degrees. Only the text gets rotated, whereas the background and border does not rotate.
///<br/>angle-number	default-null
///<br/><br/>
///Maximum label width of the data label.
///<br/>maximumLabelWidth-number	default-null
///<br/><br/>
///Enable the wrap option to the data label.
///<br/>enableWrap-boolean	default-false
///<br/><br/>
///Enables saturation to the data label.
///<br/>enableContrastColor-boolean	default-false
///<br/><br/>
///Displays the partially visible data labels inside the chart Area.
///<br/>showEdgeLabels-boolean	default-false
///<br/><br/>
///Options for customizing the border of the data label.
///<br/>border-any	default-
///<br/><br/>
///Border color of the data label.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the data label.
///<br/>width-number	default-0.1
///<br/><br/>
///Options for displaying and customizing the line that connects point and data label.
///<br/>connectorLine-any	default-
///<br/><br/>
///Specifies when the connector has to be drawn as Bezier curve or straight line. This is applicable only for Pie and Doughnut chart types.
///<br/>type-ej.datavisualization.Chart.Type|string	default-line. See ConnectorLineType
///<br/><br/>
///Width of the connector.
///<br/>width-number	default-0.5
///<br/><br/>
///Color of the connector.
///<br/>color-string	default-null
///<br/><br/>
///Height of the connector.
///<br/>height-number	default-null
///<br/><br/>
///Background color of the data label.
///<br/>fill-string	default-null
///<br/><br/>
///Options for customizing the data label font.
///<br/>font-any	default-
///<br/><br/>
///Font family of the data label.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font color of the data label text.
///<br/>color-string	default-null
///<br/><br/>
///Font style of the data label.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-normal. See FontStyle
///<br/><br/>
///Font weight of the data label.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-regular. See FontWeight
///<br/><br/>
///Opacity of the text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the data label.
///<br/>size-string	default-12px
///<br/><br/>
///Horizontal alignment of the data label.
///<br/>horizontalTextAlignment-ej.datavisualization.Chart.HorizontalTextAlignment|string	default-center
///<br/><br/>
///Margin of the text to its background shape. The size of the background shape increases based on the margin applied to its text.
///<br/>margin-any	default-
///<br/><br/>
///Bottom margin of the text.
///<br/>bottom-number	default-5
///<br/><br/>
///Left margin of the text.
///<br/>left-number	default-5
///<br/><br/>
///Right margin of the text.
///<br/>right-number	default-5
///<br/><br/>
///Top margin of the text.
///<br/>top-number	default-5
///<br/><br/>
///Opacity of the data label.
///<br/>opacity-number	default-1
///<br/><br/>
///Background shape of the data label.
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-No shape is rendered by default, so its value is &#226;€˜none&#226;€™. See Shape
///<br/><br/>
///Name of a field in data source where datalabel text is displayed.
///<br/>textMappingName-string	default-
///<br/><br/>
///Specifies the position of the data label. This property can be used only for the series such as column, bar, stacked column, stacked bar, 100% stacked column, 100% stacked bar, candle and OHLC.
///<br/>textPosition-ej.datavisualization.Chart.TextPosition|string	default-top. See TextPosition
///<br/><br/>
///Vertical alignment of the data label.
///<br/>verticalTextAlignment-ej.datavisualization.Chart.VerticalTextAlignment|string	default-&#39;center&#39;
///<br/><br/>
///Controls the visibility of the data labels.
///<br/>visible-boolean	default-false
///<br/><br/>
///Custom template to format the data label content. Use â€œpoint.xâ€ and â€œpoint.yâ€ as a placeholder text to display the corresponding data pointâ€™s x and y value.
///<br/>template-string	default-
///<br/><br/>
///Options for customizing the datalabel positions
///<br/>offset-any|number	default-
///<br/><br/>
///X value or horizontal offset to position the labels in chart.
///<br/>x-number	default-0
///<br/><br/>
///Y value or vertical offset to position the labels.
///<br/>y-number	default-0
///<br/><br/>
///Color of the marker shape.
///<br/>fill-string	default-null
///<br/><br/>
///The URL for the Image that is to be displayed as marker. In order to display image as marker, set series.marker.shape as â€˜imageâ€™.
///<br/>imageUrl-string	default-
///<br/><br/>
///Opacity of the marker.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the shape of the marker.
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-circle. See Shape
///<br/><br/>
///Options for customizing the size of the marker shape.
///<br/>size-any	default-
///<br/><br/>
///Height of the marker.
///<br/>height-number	default-6
///<br/><br/>
///Width of the marker.
///<br/>width-number	default-6
///<br/><br/>
///Controls the visibility of the marker shape.
///<br/>visible-boolean	default-false
///<br/><br/>
///Name of the series, that is to be displayed in the legend.
///<br/>name-string	default-Add a comment to this line
///<br/><br/>
///Opacity of the series.
///<br/>opacity-number	default-1
///<br/><br/>
///Options for customizing the outlier of individual series.
///<br/>outlierSettings-any	default-
///<br/><br/>
///Specifies the shape of the outlier.
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-circle. See Shape
///<br/><br/>
///Options for customizing the size of the outlier shape.
///<br/>size-any	default-
///<br/><br/>
///Height of the outlier shape.
///<br/>height-number	default-6
///<br/><br/>
///Width of the outlier shape.
///<br/>width-number	default-6
///<br/><br/>
///Name of a field in data source where fill color for all the data points is generated.
///<br/>palette-string	default-
///<br/><br/>
///Controls the size of pie series. Value ranges from 0 to 1.
///<br/>pieCoefficient-number	default-0.8
///<br/><br/>
///Controls the size of the second pie in pieOfPie series. Value ranges from 0 to 1.
///<br/>pieOfPieCoefficient-number	default-0.6
///<br/><br/>
///Split Value of pieOfPie series.
///<br/>splitValue-string	default-null
///<br/><br/>
///Distance between the two pie's in pieOfPie series.
///<br/>gapWidth-number	default-50
///<br/><br/>
///Options for customizing the empty point in the series.
///<br/>emptyPointSettings-any	default-
///<br/><br/>
///Controls the visibility of the empty point.
///<br/>visible-boolean	default-true
///<br/><br/>
///Specifies the mode of empty point.
///<br/>displayMode-ej.datavisualization.Chart.EmptyPointMode|string	default-gap
///<br/><br/>
///Options for customizing the color and border of the empty point in the series.
///<br/>style-any	default-
///<br/><br/>
///Color of the empty point.
///<br/>color-string	default-
///<br/><br/>
///Options for customizing border of the empty point in the series.
///<br/>border-any	default-
///<br/><br/>
///Border color of the empty point.
///<br/>color-string	default-
///<br/><br/>
///Border width of the empty point.
///<br/>width-number	default-1
///<br/><br/>
///Fill color for the positive column of the waterfall.
///<br/>positiveFill-string	default-null
///<br/><br/>
///Options for customizing the waterfall connector line.
///<br/>connectorLine-any	default-
///<br/><br/>
///Width of the connector line.
///<br/>width-number	default-1
///<br/><br/>
///Color of the connector line.
///<br/>color-string	default-#565656
///<br/><br/>
///DashArray of the connector line.
///<br/>dashArray-string	default-null
///<br/><br/>
///Opacity of the connector line.
///<br/>opacity-number	default-1
///<br/><br/>
///Options to customize the drag and drop in series.
///<br/>dragSettings-any	default-
///<br/><br/>
///drag/drop the series
///<br/>enable-boolean	default-false
///<br/><br/>
///Specifies the type of drag settings.
///<br/>type-string	default-xy
///<br/><br/>
///Options to customize the error bar in series.
///<br/>errorBar-any	default-
///<br/><br/>
///Show/hides the error bar
///<br/>visibility-boolean	default-visible
///<br/><br/>
///Specifies the type of error bar.
///<br/>type-ej.datavisualization.Chart.ErrorBarType|string	default-FixedValue
///<br/><br/>
///Specifies the mode of error bar.
///<br/>mode-ej.datavisualization.Chart.ErrorBarMode|string	default-vertical
///<br/><br/>
///Specifies the direction of error bar.
///<br/>direction-ej.datavisualization.Chart.ErrorBarDirection|string	default-both
///<br/><br/>
///Value of vertical error bar.
///<br/>verticalErrorValue-number	default-3
///<br/><br/>
///Value of horizontal  error bar.
///<br/>horizontalErrorValue-number	default-1
///<br/><br/>
///Value of positive horizontal error bar.
///<br/>horizontalPositiveErrorValue-number	default-1
///<br/><br/>
///Value of negative horizontal error bar.
///<br/>horizontalNegativeErrorValue-number	default-1
///<br/><br/>
///Value of positive vertical error bar.
///<br/>verticalPositiveErrorValue-number	default-5
///<br/><br/>
///Value of negative vertical error bar.
///<br/>verticalNegativeErrorValue-number	default-5
///<br/><br/>
///Fill color of the error bar.
///<br/>fill-string	default-#000000
///<br/><br/>
///Width of the error bar.
///<br/>width-number	default-1
///<br/><br/>
///Options for customizing the error bar cap.
///<br/>cap-any	default-
///<br/><br/>
///Show/Hides the error bar cap.
///<br/>visible-boolean	default-true
///<br/><br/>
///Width of the error bar cap.
///<br/>width-number	default-1
///<br/><br/>
///Length of the error bar cap.
///<br/>length-number	default-1
///<br/><br/>
///Color of the error bar cap.
///<br/>fill-string	default-#000000
///<br/><br/>
///Option to add data points; each point should have x and y property. Also, optionally, you can customize the points color, border, marker by using fill, border and marker options.
///<br/>points-Array&lt;any&gt;	default-
///<br/><br/>
///Options for customizing the border of a point. This is applicable only for column type series and accumulation type series.
///<br/>border-any	default-
///<br/><br/>
///Border color of the point.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the point.
///<br/>width-number	default-null
///<br/><br/>
///Enables or disables the visibility of legend item.
///<br/>visibleOnLegend-string	default-visible
///<br/><br/>
///To show/hide the intermediate summary from the last intermediate point.
///<br/>showIntermediateSum-boolean	default-false
///<br/><br/>
///To show/hide the total summary of the waterfall series.
///<br/>showTotalSum-boolean	default-false
///<br/><br/>
///Close value of the point. Close value is applicable only for financial type series.
///<br/>close-number	default-null
///<br/><br/>
///Size of a bubble in the bubble series. This is applicable only for the bubble series.
///<br/>size-number	default-null
///<br/><br/>
///Background color of the point. This is applicable only for column type series and accumulation type series.
///<br/>fill-string	default-null
///<br/><br/>
///High value of the point. High value is applicable only for financial type series, range area series and range column series.
///<br/>high-number	default-null
///<br/><br/>
///Low value of the point. Low value is applicable only for financial type series, range area series and range column series.
///<br/>low-number	default-null
///<br/><br/>
///Options for displaying and customizing marker for a data point. Marker contains shapes and/or data labels.
///<br/>marker-any	default-
///<br/><br/>
///Options for customizing the border of the marker shape.
///<br/>border-any	default-
///<br/><br/>
///Border color of the marker shape.
///<br/>color-string	default-white
///<br/><br/>
///Border width of the marker shape.
///<br/>width-number	default-3
///<br/><br/>
///Options for displaying and customizing data label.
///<br/>dataLabel-any	default-
///<br/><br/>
///Angle of the data label in degrees. Only the text gets rotated, whereas the background and border does not rotate.
///<br/>angle-number	default-null
///<br/><br/>
///Options for customizing the border of the data label.
///<br/>border-any	default-
///<br/><br/>
///Border color of the data label.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the data label.
///<br/>width-number	default-0.1
///<br/><br/>
///Options for displaying and customizing the line that connects point and data label.
///<br/>connectorLine-any	default-
///<br/><br/>
///Specifies when the connector has to be drawn as Bezier curve or straight line. This is applicable only for Pie and Doughnut chart types.
///<br/>type-ej.datavisualization.Chart.ConnectorLineType|string	default-line. See ConnectorLineType
///<br/><br/>
///Width of the connector.
///<br/>width-number	default-0.5
///<br/><br/>
///Background color of the data label.
///<br/>fill-string	default-null
///<br/><br/>
///Options for customizing the data label font.
///<br/>font-any	default-
///<br/><br/>
///Font family of the data label.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the data label.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-normal. See FontStyle
///<br/><br/>
///Font weight of the data label.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-regular. See FontWeight
///<br/><br/>
///Opacity of the text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size of the data label.
///<br/>size-string	default-12px
///<br/><br/>
///Horizontal alignment of the data label.
///<br/>horizontalTextAlignment-ej.datavisualization.Chart.HorizontalTextAlignment|string	default-center
///<br/><br/>
///Margin of the text to its background shape. The size of the background shape increases based on the margin applied to its text.
///<br/>margin-any	default-
///<br/><br/>
///Bottom margin of the text.
///<br/>bottom-number	default-5
///<br/><br/>
///Left margin of the text.
///<br/>left-number	default-5
///<br/><br/>
///Right margin of the text.
///<br/>right-number	default-5
///<br/><br/>
///Top margin of the text.
///<br/>top-number	default-5
///<br/><br/>
///Opacity of the data label.
///<br/>opacity-number	default-1
///<br/><br/>
///Background shape of the data label.
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-No shape is rendered by default, so its value is &#226;€˜none&#226;€™. See Shape
///<br/><br/>
///Specifies the position of the data label. This property can be used only for the series such as column, bar, stacked column, stacked bar, 100% stacked column, 100% stacked bar, candle and OHLC.
///<br/>textPosition-ej.datavisualization.Chart.TextPosition|string	default-top. See TextPosition
///<br/><br/>
///Vertical alignment of the data label.
///<br/>verticalTextAlignment-ej.datavisualization.Chart.VerticalTextAlignment|string	default-&#39;center&#39;
///<br/><br/>
///Controls the visibility of the data labels.
///<br/>visible-boolean	default-false
///<br/><br/>
///Custom template to format the data label content. Use â€œpoint.xâ€ and â€œpoint.yâ€ as a placeholder text to display the corresponding data pointâ€™s x and y value.
///<br/>template-string	default-
///<br/><br/>
///Moves the label vertically by specified offset.
///<br/>offset-number	default-0
///<br/><br/>
///Color of the marker shape.
///<br/>fill-string	default-null
///<br/><br/>
///The URL for the Image that is to be displayed as marker. In order to display image as marker, set series.marker.shape as â€˜imageâ€™.
///<br/>imageUrl-string	default-
///<br/><br/>
///Opacity of the marker.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the shape of the marker.
///<br/>shape-ej.datavisualization.Chart.Shape|string	default-circle. See Shape
///<br/><br/>
///Options for customizing the size of the marker shape.
///<br/>size-any	default-
///<br/><br/>
///Height of the marker.
///<br/>height-number	default-6
///<br/><br/>
///Width of the marker.
///<br/>width-number	default-6
///<br/><br/>
///Controls the visibility of the marker shape.
///<br/>visible-boolean	default-false
///<br/><br/>
///Open value of the point. This is applicable only for financial type series.
///<br/>open-number	default-null
///<br/><br/>
///Datalabel text for the point.
///<br/>text-string	default-null
///<br/><br/>
///X value of the point.
///<br/>x-number	default-null
///<br/><br/>
///Y value of the point.
///<br/>y-number	default-null
///<br/><br/>
///Specifies the mode of the pyramid series.
///<br/>pyramidMode-ej.datavisualization.Chart.PyramidMode|string	default-linear
///<br/><br/>
///Specifies ej.Query to select data from dataSource. This property is applicable only when the dataSource is ej.DataManager.
///<br/>query-any	default-null
///<br/><br/>
///Start angle from where the pie/doughnut series renders. It starts from 0, by default.
///<br/>startAngle-number	default-null
///<br/><br/>
///Options for customizing the corner radius. cornerRadius property also takes the numeric input and applies it for all the four corners of the column.
///<br/>cornerRadius-any	default-
///<br/><br/>
///Specifies the radius for the top left corner.
///<br/>topLeft-number	default-0
///<br/><br/>
///Specifies the radius for the top right corner.
///<br/>topRight-number	default-0
///<br/><br/>
///Specifies the radius for the bottom left corner.
///<br/>bottomLeft-number	default-0
///<br/><br/>
///Specifies the radius for the bottom right corner.
///<br/>bottomRight-number	default-0
///<br/><br/>
///Options for customizing the tooltip of chart.
///<br/>tooltip-any	default-
///<br/><br/>
///Options for customizing the border of the tooltip.
///<br/>border-any	default-
///<br/><br/>
///Border Color of the tooltip.
///<br/>color-string	default-null
///<br/><br/>
///Border Width of the tooltip.
///<br/>width-number	default-1
///<br/><br/>
///Customize the corner radius of the tooltip rectangle.
///<br/>rx-number	default-0
///<br/><br/>
///Customize the corner radius of the tooltip rectangle.
///<br/>ry-number	default-0
///<br/><br/>
///Specifies the duration, the tooltip has to be displayed.
///<br/>duration-string	default-500ms
///<br/><br/>
///Enables/disables the animation of the tooltip when moving from one point to another.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Background color of the tooltip.
///<br/>fill-string	default-null
///<br/><br/>
///Format of the tooltip content.
///<br/>format-string	default-#point.x# : #point.y#
///<br/><br/>
///Opacity of the tooltip.
///<br/>opacity-number	default-0.95
///<br/><br/>
///Custom template to format the tooltip content. Use â€œpoint.xâ€ and â€œpoint.yâ€ as a placeholder text to display the corresponding data pointâ€™s x and y value.
///<br/>template-string	default-null
///<br/><br/>
///Controls the visibility of the tooltip.
///<br/>visible-boolean	default-false
///<br/><br/>
///Specifies the type of the series to render in chart.
///<br/>type-ej.datavisualization.Chart.Type|string	default-column. see Type
///<br/><br/>
///Controls the visibility of the series.
///<br/>visibility-string	default-visible
///<br/><br/>
///Enables or disables the visibility of legend item.
///<br/>visibleOnLegend-string	default-visible
///<br/><br/>
///Specifies the name of the x-axis that has to be associated with this series. Add an axis instance with this name to axes collection.
///<br/>xAxisName-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains x value for the series.
///<br/>xName-string	default-null
///<br/><br/>
///Specifies the name of the y-axis that has to be associated with this series. Add an axis instance with this name to axes collection.
///<br/>yAxisName-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains y value for the series.
///<br/>yName-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains high value for the series.
///<br/>high-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains low value for the series.
///<br/>low-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains open value for the series.
///<br/>open-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains close value for the series.
///<br/>close-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains fill color for the series.
///<br/>pointColorMappingName-string	default-null
///<br/><br/>
///Z-order of the series.
///<br/>zOrder-number	default-0
///<br/><br/>
///Name of the property in the datasource that contains the size value for the bubble series.
///<br/>size-string	default-null
///<br/><br/>
///Option to add trendlines to chart.
///<br/>trendlines-Array&lt;any&gt;	default-
///<br/><br/>
///Show/hides the trendline.
///<br/>visibility-boolean	default-
///<br/><br/>
///Specifies the type of trendline for the series.
///<br/>type-string	default-linear. See TrendlinesType
///<br/><br/>
///Name for the trendlines that is to be displayed in legend text.
///<br/>name-string	default-Trendline
///<br/><br/>
///Fill color of the trendlines.
///<br/>fill-string	default-#0000FF
///<br/><br/>
///Width of the trendlines.
///<br/>width-number	default-1
///<br/><br/>
///Opacity of the trendline.
///<br/>opacity-number	default-1
///<br/><br/>
///Pattern of dashes and gaps used to stroke the trendline.
///<br/>dashArray-string	default-
///<br/><br/>
///Future trends of the current series.
///<br/>forwardForecast-number	default-0
///<br/><br/>
///Past trends of the current series.
///<br/>backwardForecast-number	default-0
///<br/><br/>
///Specifies the order of polynomial trendlines.
///<br/>polynomialOrder-number	default-0
///<br/><br/>
///Specifies the moving average starting period  value.
///<br/>period-number	default-2
///<br/><br/>
///Options for customizing the trendline tooltip
///<br/>tooltip-any	default-
///<br/><br/>
///Options for customizing the border of the trendline tooltip.
///<br/>border-any	default-
///<br/><br/>
///Specify the Border color of the  trendline tooltip.
///<br/>color-string	default-null
///<br/><br/>
///Border width of the trendline tooltip.
///<br/>width-number	default-1
///<br/><br/>
///Customize the corner radius of the trendline tooltip rectangle.
///<br/>rx-number	default-0
///<br/><br/>
///Customize the corner radius of the trendline tooltip rectangle.
///<br/>ry-number	default-0
///<br/><br/>
///Specifies the duration of the trendline tooltip to be displayed.
///<br/>duration-string	default-500ms
///<br/><br/>
///Enables/disables the animation of the trendline tooltip when moving from one point to other.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Background color of the trendline tooltip.
///<br/>fill-string	default-null
///<br/><br/>
///Format of the trendline tooltip content.
///<br/>format-string	default-#point.x# : #point.y#
///<br/><br/>
///Opacity of the trendline tooltip.
///<br/>opacity-number	default-0.5
///<br/><br/>
///Show/hides the trendline legend.
///<br/>visibleOnLegend-string	default-visible
///<br/><br/>
///Specifies the trendline intercept value
///<br/>intercept-number	default-null
///<br/><br/>
///Options for customizing the appearance of the series or data point while highlighting.
///<br/>highlightSettings-any	default-
///<br/><br/>
///Enables/disables the ability to highlight series or data point interactively.
///<br/>enable-boolean	default-false
///<br/><br/>
///Specifies whether series or data point has to be highlighted.
///<br/>mode-ej.datavisualization.Chart.Mode|string	default-series. See Mode
///<br/><br/>
///Color of the series/point on highlight.
///<br/>color-string	default-
///<br/><br/>
///Opacity of the series/point on highlight.
///<br/>opacity-number	default-0.6
///<br/><br/>
///Options for customizing the border of series on highlight.
///<br/>border-any	default-
///<br/><br/>
///Border color of the series/point on highlight.
///<br/>color-string	default-
///<br/><br/>
///Border width of the series/point on highlight.
///<br/>width-string	default-2
///<br/><br/>
///Specifies the pattern for the series/point on highlight.
///<br/>pattern-string	default-none. See Pattern
///<br/><br/>
///Custom pattern for the series on highlight.
///<br/>customPattern-string	default-
///<br/><br/>
///Options for customizing the appearance of the series/data point on selection.
///<br/>selectionSettings-any	default-
///<br/><br/>
///Enables/disables the ability to select a series/data point interactively.
///<br/>enable-boolean	default-false
///<br/><br/>
///Specifies whether series or data point has to be selected.
///<br/>mode-ej.datavisualization.Chart.Mode|string	default-series. See Mode
///<br/><br/>
///Specifies the type of selection.
///<br/>type-ej.datavisualization.Chart.SelectionType|string	default-single
///<br/><br/>
///Specifies the drawn rectangle type.
///<br/>rangeType-ej.datavisualization.Chart.RangeType|string	default-xy
///<br/><br/>
///Color of the series/point on selection.
///<br/>color-string	default-
///<br/><br/>
///Opacity of the series/point on selection.
///<br/>opacity-number	default-0.6
///<br/><br/>
///Options for customizing the border of series on selection.
///<br/>border-any	default-
///<br/><br/>
///Border color of the series/point on selection.
///<br/>color-string	default-
///<br/><br/>
///Border width of the series/point on selection.
///<br/>width-string	default-2
///<br/><br/>
///Specifies the pattern for the series/point on selection.
///<br/>pattern-string	default-none. See Pattern
///<br/><br/>
///Custom pattern for the series on selection.
///<br/>customPattern-string	default-
///<br/><br/>
///Controls whether data points has to be displayed side by side or along the depth of the axis.
///<br/>sideBySideSeriesPlacement-boolean	default-false
///<br/><br/>
///Options to customize the Chart size.
///<br/>size-Size	default-
///<br/><br/>
///Height of the Chart. Height can be specified in either pixel or percentage.
///<br/>height-string	default-&#39;450&#39;
///<br/><br/>
///Width of the Chart. Width can be specified in either pixel or percentage.
///<br/>width-string	default-&#39;450&#39;
///<br/><br/>
///Specifies the theme for Chart.
///<br/>theme-ej.datavisualization.Chart.Theme|string	default-Flatlight. See Theme
///<br/><br/>
///Slope angle of 3D Chart. This property is applicable only when 3D view is enabled.
///<br/>tilt-number	default-0
///<br/><br/>
///Options for customizing the title and subtitle of Chart.
///<br/>title-Title	default-
///<br/><br/>
///Background color for the chart title.
///<br/>background-string	default-transparent
///<br/><br/>
///Options to customize the border of the title.
///<br/>border-any	default-
///<br/><br/>
///Width of the title border.
///<br/>width-number	default-1
///<br/><br/>
///color of the title border.
///<br/>color-string	default-transparent
///<br/><br/>
///opacity of the title border.
///<br/>opacity-number	default-0.8
///<br/><br/>
///opacity of the title border.
///<br/>cornerRadius-number	default-0.8
///<br/><br/>
///Options for customizing the font of Chart title.
///<br/>font-any	default-
///<br/><br/>
///Font family for Chart title.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style for Chart title.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal. See FontStyle
///<br/><br/>
///Font weight for Chart title.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-Regular. See FontWeight
///<br/><br/>
///Opacity of the Chart title.
///<br/>opacity-number	default-0.5
///<br/><br/>
///Font size for Chart title.
///<br/>size-string	default-20px
///<br/><br/>
///Controls the visibility of the Chart title
///<br/>visible-boolean	default-true
///<br/><br/>
///Specifies whether to trim the Chart Title when the width of the title exceeds the maximumWidth.
///<br/>enableTrim-boolean	default-false
///<br/><br/>
///Maximum width of the title, when the title exceeds this width, the title gets trimmed, when enableTrim is true.
///<br/>maximumWidth-string	default-auto
///<br/><br/>
///Specifies the action taken when the Chart width is more than the titleWidth.
///<br/>textOverflow-ej.datavisualization.Chart.TextOverflow|string	default-trim.
///<br/><br/>
///Options to customize the sub title of Chart.
///<br/>subTitle-any	default-
///<br/><br/>
///Options for customizing the font of sub title.
///<br/>font-any	default-
///<br/><br/>
///Font family of sub title.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style for sub title.
///<br/>fontStyle-ej.datavisualization.Chart.FontStyle|string	default-Normal. See FontStyle
///<br/><br/>
///Font weight for sub title.
///<br/>fontWeight-ej.datavisualization.Chart.FontWeight|string	default-Regular. See FontWeight
///<br/><br/>
///Opacity of the sub title.
///<br/>opacity-number	default-1
///<br/><br/>
///Font size for sub title.
///<br/>size-string	default-12px
///<br/><br/>
///Background color for the chart subtitle.
///<br/>background-string	default-transparent
///<br/><br/>
///Options to customize the border of the title.
///<br/>border-any	default-
///<br/><br/>
///Width of the subtitle border.
///<br/>width-number	default-1
///<br/><br/>
///color of the subtitle border.
///<br/>color-string	default-transparent
///<br/><br/>
///opacity of the subtitle border.
///<br/>opacity-number	default-0.8
///<br/><br/>
///opacity of the subtitle border.
///<br/>cornerRadius-number	default-0.8
///<br/><br/>
///Text to be displayed in sub title.
///<br/>text-string	default-
///<br/><br/>
///Alignment of sub title text.
///<br/>textAlignment-ej.datavisualization.Chart.Alignment|string	default-far. See TextAlignment
///<br/><br/>
///Controls the visibility of the Chart SubTitle
///<br/>visible-boolean	default-true
///<br/><br/>
///Specifies whether to trim the Chart SubTitle when the width of the Subtitle exceeds the maximumWidth.
///<br/>enableTrim-boolean	default-false
///<br/><br/>
///Maximum width of the Subtitle, when the Subtitle exceeds this width, the Subtitle gets trimmed, when enableTrim is true.
///<br/>maximumWidth-string	default-auto
///<br/><br/>
///Specifies the action taken when the Chart width is more than the SubTitleWidth.
///<br/>textOverflow-ej.datavisualization.Chart.TextOverflow|string	default-trim.
///<br/><br/>
///Text to be displayed in Chart title.
///<br/>text-string	default-
///<br/><br/>
///Alignment of the title text.
///<br/>textAlignment-ej.datavisualization.Chart.Alignment|string	default-Center. See TextAlignment
///<br/><br/>
///Width of the wall used in 3D Chart. Wall is present only in Cartesian type 3D series and not in 3D pie or Doughnut series. This property is applicable only when 3D view is enabled.
///<br/>wallSize-number	default-2
///<br/><br/>
///Options for enabling zooming feature of chart.
///<br/>zooming-Zooming	default-
///<br/><br/>
///Enables or disables zooming.
///<br/>enable-boolean	default-false
///<br/><br/>
///Enables or disables pinch zooming.
///<br/>enablePinching-boolean	default-true
///<br/><br/>
///Enable or disables the differed zooming. When it is enabled, chart is updated only on mouse up action while zooming and panning.
///<br/>enableDeferredZoom-boolean	default-false
///<br/><br/>
///Enables/disables the ability to zoom the chart on moving the mouse wheel.
///<br/>enableMouseWheel-boolean	default-false
///<br/><br/>
///Specifies whether to allow zooming the chart vertically or horizontally or in both ways.
///<br/>type-string	default-&#39;x,y&#39;
///<br/><br/>
///Toggles the visibility of the scrollbar, which will be displayed while zooming.
///<br/>enableScrollbar-boolean	default-false
///<br/><br/>
///To display user specified buttons in zooming toolbar.
///<br/>toolbarItems-Array&lt;any&gt;	default-[zoomIn, zoomOut, zoom, pan, reset]
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
CheckBox:function(){
 /// <signature>
 /// <summary>Constructor of ej.CheckBox</summary>
 /// </signature>
}
});
ej.CheckBox=(function(){
var original=ej.CheckBox
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// Destroy the CheckBox widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// Disable the CheckBox to prevent all user interactions.
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// To enable the CheckBox
/// </summary>
},
isChecked:function(){
/// <signature>
/// <summary>
/// To Check the status of CheckBox
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejCheckBox=function(){
this.data("ejCheckBox",new	ej.CheckBox());
return this;
};
intellisense.annotate(jQuery.fn,{
ejCheckBox :function (options) {
/// <signature>
/// <summary><br/>
///The CheckBox control allows you to check an option to perform an action. This control allows you to select true, false or an intermediate option. These CheckBoxes are supported with themes. The HTML CheckBox control is rendered as Essential JavaScript CheckBox control.<br/><br/>
///Specifies whether CheckBox has to be in checked or not. We can also specify array of string as value for this property. If any of the value in the specified array matches the value of the textbox, then it will be considered as checked. It will be useful in MVVM binding, specify array type to identify the values of the checked CheckBoxes.
///<br/>checked-boolean|string[]	default-false
///<br/><br/>
///Specifies the State of CheckBox.See below to get available CheckState
///<br/>checkState-ej.CheckState|string	default-null
///<br/><br/>
///Sets the root CSS class for CheckBox theme, which is used customize.
///<br/>cssClass-string	default-
///<br/><br/>
///Specifies the checkbox control state.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Specifies the persist property for CheckBox while initialization. The persist API save current model value to browser cookies for state maintains. While refreshing the CheckBox control page the model value apply from browser cookies.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Specify the Right to Left direction to Checkbox
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Specifies the enable or disable Tri-State for checkbox control.
///<br/>enableTriState-boolean	default-false
///<br/><br/>
///It allows to define the characteristics of the CheckBox control. It will helps to extend the capability of an HTML element.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Specified value to be added an id attribute of the CheckBox.
///<br/>id-string	default-null
///<br/><br/>
///Specify the prefix value of id to be added before the current id of the CheckBox.
///<br/>idPrefix-string	default-ej
///<br/><br/>
///Specifies the name attribute of the CheckBox.
///<br/>name-string	default-null
///<br/><br/>
///Displays rounded corner borders to CheckBox
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Specifies the size of the CheckBox.See below to know available CheckboxSize
///<br/>size-ej.CheckboxSize|string	default-small
///<br/><br/>
///Specifies the text content to be displayed for CheckBox.
///<br/>text-string	default-
///<br/><br/>
///Set the jQuery validation error message in CheckBox.
///<br/>validationMessage-any	default-null
///<br/><br/>
///Set the jQuery validation rules in CheckBox.
///<br/>validationRules-any	default-null
///<br/><br/>
///Specifies the value attribute of the CheckBox.
///<br/>value-string	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
CircularGauge:function(){
 /// <signature>
 /// <summary>Constructor of ej.CircularGauge</summary>
 /// </signature>
}
});
ej.CircularGauge=(function(){
var original=ej.CircularGauge
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// destroy the circular gauge widget. all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
exportImage:function(fileName, fileType){
/// <signature>
/// <summary>
/// To export Image
/// </summary>
/// <param name="fileName"	type="string">fileName for the Image</param>
/// </signature>
/// <signature>
/// <summary>
/// To export Image
/// </summary>
/// <param name="fileType"	type="string">fileType for the Image</param>
/// </signature>
},
getBackNeedleLength:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get BackNeedleLength
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get BackNeedleLength
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getCustomLabelAngle:function(scaleIndex, customLabelIndex){
/// <signature>
/// <summary>
/// To get CustomLabelAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get CustomLabelAngle
/// </summary>
/// <param name="customLabelIndex"	type="number">customLabelIndex value for the Gauge</param>
/// </signature>
},
getCustomLabelValue:function(scaleIndex, customLabelIndex){
/// <signature>
/// <summary>
/// To get CustomLabelValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get CustomLabelValue
/// </summary>
/// <param name="customLabelIndex"	type="number">customLabelIndex value for the Gauge</param>
/// </signature>
},
getLabelAngle:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get LabelAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get LabelAngle
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the Gauge</param>
/// </signature>
},
getLabelDistanceFromScale:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get LabelDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get LabelDistanceFromScale
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the Gauge</param>
/// </signature>
},
getLabelPlacement:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get LabelPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get LabelPlacement
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the Gauge</param>
/// </signature>
},
getLabelStyle:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get LabelStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get LabelStyle
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the Gauge</param>
/// </signature>
},
getMajorIntervalValue:function(scaleIndex){
/// <signature>
/// <summary>
/// To get MajorIntervalValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getMarkerDistanceFromScale:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get MarkerDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get MarkerDistanceFromScale
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getMarkerStyle:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get MarkerStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get MarkerStyle
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getMaximumValue:function(scaleIndex){
/// <signature>
/// <summary>
/// To get MaximumValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getMinimumValue:function(scaleIndex){
/// <signature>
/// <summary>
/// To get MinimumValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getMinorIntervalValue:function(scaleIndex){
/// <signature>
/// <summary>
/// To get MinorIntervalValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getNeedleStyle:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get NeedleStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get NeedleStyle
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerCapBorderWidth:function(scaleIndex){
/// <signature>
/// <summary>
/// To get PointerCapBorderWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getPointerCapRadius:function(scaleIndex){
/// <signature>
/// <summary>
/// To get PointerCapRadius
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getPointerLength:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerLength
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerLength
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerNeedleType:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerNeedleType
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerNeedleType
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerPlacement:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerPlacement
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerValue:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerValue
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerWidth:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerWidth
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getRangeBorderWidth:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get RangeBorderWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get RangeBorderWidth
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeDistanceFromScale:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get RangeDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get RangeDistanceFromScale
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeEndValue:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get RangeEndValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get RangeEndValue
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangePosition:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get RangePosition
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get RangePosition
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeSize:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get RangeSize
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get RangeSize
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeStartValue:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get RangeStartValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get RangeStartValue
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getScaleBarSize:function(scaleIndex){
/// <signature>
/// <summary>
/// To get ScaleBarSize
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getScaleBorderWidth:function(scaleIndex){
/// <signature>
/// <summary>
/// To get ScaleBorderWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getScaleDirection:function(scaleIndex){
/// <signature>
/// <summary>
/// To get ScaleDirection
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getScaleRadius:function(scaleIndex){
/// <signature>
/// <summary>
/// To get ScaleRadius
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getStartAngle:function(scaleIndex){
/// <signature>
/// <summary>
/// To get StartAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getSubGaugeLocation:function(scaleIndex, GaugeIndex){
/// <signature>
/// <summary>
/// To get SubGaugeLocation
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get SubGaugeLocation
/// </summary>
/// <param name="GaugeIndex"	type="number">GaugeIndex value for the Gauge</param>
/// </signature>
},
getSweepAngle:function(scaleIndex){
/// <signature>
/// <summary>
/// To get SweepAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getTickAngle:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get TickAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get TickAngle
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the Gauge</param>
/// </signature>
},
getTickDistanceFromScale:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get TickDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get TickDistanceFromScale
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the Gauge</param>
/// </signature>
},
getTickHeight:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get TickHeight
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get TickHeight
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the Gauge</param>
/// </signature>
},
getTickPlacement:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get TickPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get TickPlacement
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the Gauge</param>
/// </signature>
},
getTickStyle:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get TickStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get TickStyle
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the Gauge</param>
/// </signature>
},
getTickWidth:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get TickWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get TickWidth
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the Gauge</param>
/// </signature>
},
includeFirstValue:function(scaleIndex, labelIndex, value){
/// <signature>
/// <summary>
/// To set includeFirstValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set includeFirstValue
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set includeFirstValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
redraw:function(value){
/// <signature>
/// <summary>
/// Switching the redraw option for the gauge
/// </summary>
/// <param name="value"	type="string">redraw value for the gauge</param>
/// </signature>
},
setBackNeedleLength:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set BackNeedleLength
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set BackNeedleLength
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set BackNeedleLength
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setCustomLabelAngle:function(scaleIndex, customLabelIndex, value){
/// <signature>
/// <summary>
/// To set CustomLabelAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set CustomLabelAngle
/// </summary>
/// <param name="customLabelIndex"	type="number">customLabelIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set CustomLabelAngle
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setCustomLabelValue:function(scaleIndex, customLabelIndex, value){
/// <signature>
/// <summary>
/// To set CustomLabelValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set CustomLabelValue
/// </summary>
/// <param name="customLabelIndex"	type="number">customLabelIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set CustomLabelValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setLabelAngle:function(scaleIndex, labelIndex, angle){
/// <signature>
/// <summary>
/// To set LabelAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set LabelAngle
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set LabelAngle
/// </summary>
/// <param name="angle"	type="number">angle value for the gauge</param>
/// </signature>
},
setLabelDistanceFromScale:function(scaleIndex, labelIndex, value){
/// <signature>
/// <summary>
/// To set LabelDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set LabelDistanceFromScale
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set LabelDistanceFromScale
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setLabelPlacement:function(scaleIndex, labelIndex, value){
/// <signature>
/// <summary>
/// To set LabelPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set LabelPlacement
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set LabelPlacement
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setLabelStyle:function(scaleIndex, labelIndex, value){
/// <signature>
/// <summary>
/// To set LabelStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set LabelStyle
/// </summary>
/// <param name="labelIndex"	type="number">labelIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set LabelStyle
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setMajorIntervalValue:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set MajorIntervalValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set MajorIntervalValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setMarkerDistanceFromScale:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set MarkerDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set MarkerDistanceFromScale
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set MarkerDistanceFromScale
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setMarkerStyle:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set MarkerStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set MarkerStyle
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set MarkerStyle
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setMaximumValue:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set MaximumValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set MaximumValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setMinimumValue:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set MinimumValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set MinimumValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setMinorIntervalValue:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set MinorIntervalValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set MinorIntervalValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setNeedleStyle:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set NeedleStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set NeedleStyle
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set NeedleStyle
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setPointerCapBorderWidth:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set PointerCapBorderWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerCapBorderWidth
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setPointerCapRadius:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set PointerCapRadius
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerCapRadius
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setPointerLength:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set PointerLength
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerLength
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerLength
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setPointerNeedleType:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set PointerNeedleType
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerNeedleType
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerNeedleType
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setPointerPlacement:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set PointerPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerPlacement
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerPlacement
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setPointerValue:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set PointerValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerValue
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setPointerWidth:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set PointerWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerWidth
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerWidth
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setRangeBorderWidth:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set RangeBorderWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeBorderWidth
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeBorderWidth
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setRangeDistanceFromScale:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set RangeDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeDistanceFromScale
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeDistanceFromScale
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setRangeEndValue:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set RangeEndValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeEndValue
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeEndValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setRangePosition:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set RangePosition
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangePosition
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangePosition
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setRangeSize:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set RangeSize
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeSize
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeSize
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setRangeStartValue:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set RangeStartValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeStartValue
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set RangeStartValue
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setScaleBarSize:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set ScaleBarSize
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set ScaleBarSize
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setScaleBorderWidth:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set ScaleBorderWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set ScaleBorderWidth
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setScaleDirection:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set ScaleDirection
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set ScaleDirection
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setScaleRadius:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set ScaleRadius
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set ScaleRadius
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setStartAngle:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set StartAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set StartAngle
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setSubGaugeLocation:function(scaleIndex, GaugeIndex, value){
/// <signature>
/// <summary>
/// To set SubGaugeLocation
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set SubGaugeLocation
/// </summary>
/// <param name="GaugeIndex"	type="number">GaugeIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set SubGaugeLocation
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setSweepAngle:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set SweepAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set SweepAngle
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setTickAngle:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set TickAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickAngle
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickAngle
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setTickDistanceFromScale:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set TickDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickDistanceFromScale
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickDistanceFromScale
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setTickHeight:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set TickHeight
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickHeight
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickHeight
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setTickPlacement:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set TickPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickPlacement
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickPlacement
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setTickStyle:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set TickStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickStyle
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickStyle
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
setTickWidth:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set TickWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickWidth
/// </summary>
/// <param name="tickIndex"	type="number">tickIndex value for the gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set TickWidth
/// </summary>
/// <param name="value"	type="number">value for the gauge</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejCircularGauge=function(){
this.data("ejCircularGauge",new	ej.CircularGauge());
return this;
};
intellisense.annotate(jQuery.fn,{
ejCircularGauge :function (options) {
/// <signature>
/// <summary><br/>
///The Circular gauge can be easily configured to the DOM element, such as div. you can create a circular gauge with a highly customizable look and feel.<br/><br/>
///Specifies animationSpeed of circular gauge
///<br/>animationSpeed-number	default-500
///<br/><br/>
///Specifies the background color of circular gauge.
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specify distanceFromCorner value of circular gauge
///<br/>distanceFromCorner-number	default-center
///<br/><br/>
///Specify range Z-order placement of circular gauge.
///<br/>rangeZOrder-ej.datavisualization.CircularGauge.RangeZOrderPlacement|string	default-Rear
///<br/><br/>
///Specify animate value of circular gauge
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Specify to convert the  date object to  string, using locale settings.
///<br/>enableGroupSeparator-boolean	default-false
///<br/><br/>
///Controls whether circular gauge has to be responsive while resizing.
///<br/>enableResize-boolean	default-false
///<br/><br/>
///This provides options for customizing export settings
///<br/>exportSettings-ExportSettings	default-
///<br/><br/>
///Specifies the downloading filename
///<br/>filename-string	default-CircularGauge
///<br/><br/>
///Specifies the format of the file to export
///<br/>type-ej.datavisualization.CircularGauge.ExportingType|string	default-png
///<br/><br/>
///Specifies the name of the action URL
///<br/>action-string	default-
///<br/><br/>
///Specifies the mode of exporting
///<br/>mode-ej.datavisualization.CircularGauge.ExportingMode|string	default-client
///<br/><br/>
///Specify the frame of circular gauge
///<br/>frame-Frame	default-Object
///<br/><br/>
///Specify the URL of the frame background image for circular gauge
///<br/>backgroundImageUrl-string	default-null
///<br/><br/>
///Specifies the frameType of circular gauge. See 
///<br/>frameType-ej.datavisualization.CircularGauge.FrameType|string	default-FullCircle
///<br/><br/>
///Specifies the end angle for the half circular frame.
///<br/>halfCircleFrameEndAngle-number	default-360
///<br/><br/>
///Specifies the start angle for the half circular frame.
///<br/>halfCircleFrameStartAngle-number	default-180
///<br/><br/>
///Specify gaugePosition value of circular gauge See GaugePosition
///<br/>gaugePosition-ej.datavisualization.CircularGauge.gaugePosition|string	default-center
///<br/><br/>
///Specifies the height of circular gauge.
///<br/>height-number	default-360
///<br/><br/>
///Specifies the interiorGradient of circular gauge.
///<br/>interiorGradient-any	default-null
///<br/><br/>
///Specify isRadialGradient value of circular gauge
///<br/>isRadialGradient-boolean	default-false
///<br/><br/>
///Specify isResponsive value of circular gauge
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Name of the culture based on which circular gauge should be localized.
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the maximum value of circular gauge.
///<br/>maximum-number	default-100
///<br/><br/>
///Specifies the minimum value of circular gauge.
///<br/>minimum-number	default-0
///<br/><br/>
///Specify outerCustomLabelPosition value of circular gauge See 
///<br/>outerCustomLabelPosition-ej.datavisualization.CircularGauge.OuterCustomLabelPosition|string	default-bottom
///<br/><br/>
///Specifies the radius of circular gauge.
///<br/>radius-number	default-180
///<br/><br/>
///Specify readonly value of circular gauge
///<br/>readOnly-boolean	default-true
///<br/><br/>
///Specify the pointers, ticks, labels, indicators, ranges of circular gauge
///<br/>scales-Array&lt;Scales&gt;	default-null
///<br/><br/>
///Specify backgroundColor for the scale of circular gauge
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specify border for scales of circular gauge
///<br/>border-any	default-Object
///<br/><br/>
///Specify border color for scales of circular gauge
///<br/>color-string	default-null
///<br/><br/>
///Specify border width of circular gauge
///<br/>width-number	default-1.5
///<br/><br/>
///Specify scale direction of circular gauge. See 
///<br/>direction-ej.datavisualization.CircularGauge.Direction|string	default-Clockwise
///<br/><br/>
///Specify the custom labels for the scales.
///<br/>customLabels-Array&lt;any&gt;	default-Array
///<br/><br/>
///Value of the custom labels.
///<br/>value-string	default-
///<br/><br/>
///Color of the custom labels.
///<br/>color-string	default-
///<br/><br/>
///Specify position of custom labels
///<br/>position-any	default-Object
///<br/><br/>
///Specify x-axis position of label
///<br/>x-number	default-0
///<br/><br/>
///Specify y-axis  position of labels.
///<br/>y-number	default-0
///<br/><br/>
///Specify angle for the rotation of the custom labels in degrees.
///<br/>textAngle-number	default-0
///<br/><br/>
///Specify font for custom labels
///<br/>font-any	default-Object
///<br/><br/>
///Specify font fontFamily for custom labels.
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Specify font Style for custom labels.
///<br/>fontStyle-string	default-Bold
///<br/><br/>
///Specify font size for custom labels.
///<br/>size-string	default-12px
///<br/><br/>
///Specifies the position of the  custom labels. See 
///<br/>positionType-ej.datavisualization.CircularGauge.CustomLabelPositionType|string	default-inner
///<br/><br/>
///Specify representing state of circular gauge
///<br/>indicators-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specify indicator height of circular gauge
///<br/>height-number	default-15
///<br/><br/>
///Specify imageUrl of circular gauge
///<br/>imageUrl-string	default-null
///<br/><br/>
///Specify position of circular gauge
///<br/>position-any	default-Object
///<br/><br/>
///Specify x-axis of position of circular gauge
///<br/>x-number	default-0
///<br/><br/>
///Specify y-axis of position of circular gauge
///<br/>y-number	default-0
///<br/><br/>
///Specify the various states of circular gauge
///<br/>stateRanges-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specify backgroundColor for indicator of circular gauge
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specify borderColor for indicator of circular gauge
///<br/>borderColor-string	default-null
///<br/><br/>
///Specify end value for each specified state of circular gauge
///<br/>endValue-number	default-0
///<br/><br/>
///Specify value of the font as the indicator when the indicator style is set with the value "text" of circular gauge
///<br/>font-any	default-null
///<br/><br/>
///Specify start value for each specified state of circular gauge
///<br/>startValue-number	default-0
///<br/><br/>
///Specify value of the text as the indicator when the indicator style is set with the value "text" of circular gauge
///<br/>text-string	default-
///<br/><br/>
///Specify value of the textColor as the indicator when the indicator style is set with the value "text" of circular gauge
///<br/>textColor-string	default-null
///<br/><br/>
///Specify indicator style of circular gauge. See 
///<br/>type-ej.datavisualization.CircularGauge.IndicatorTypes|string	default-Circle
///<br/><br/>
///Specify indicator width of circular gauge
///<br/>width-number	default-15
///<br/><br/>
///Specify the text values displayed in a meaningful manner alongside the ticks of circular gauge
///<br/>labels-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specify the angle for the labels of circular gauge
///<br/>angle-number	default-0
///<br/><br/>
///Specify labels autoAngle value of circular gauge
///<br/>autoAngle-boolean	default-false
///<br/><br/>
///Specify label color of circular gauge
///<br/>color-string	default-null
///<br/><br/>
///Specify distanceFromScale value for labels of circular gauge
///<br/>distanceFromScale-number	default-0
///<br/><br/>
///Specify font for labels of circular gauge
///<br/>font-any	default-Object
///<br/><br/>
///Specify font fontFamily for labels of circular gauge
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Specify font Style for labels of circular gauge
///<br/>fontStyle-string	default-Bold
///<br/><br/>
///Specify font size for labels of circular gauge
///<br/>size-string	default-11px
///<br/><br/>
///Specify includeFirstValue of circular gauge
///<br/>includeFirstValue-boolean	default-true
///<br/><br/>
///Specify opacity value for labels of circular gauge
///<br/>opacity-number	default-null
///<br/><br/>
///Specify label placement of circular gauge. See 
///<br/>placement-ej.datavisualization.CircularGauge.Placement|string	default-Near
///<br/><br/>
///Specify label Style of circular gauge. See 
///<br/>type-ej.datavisualization.CircularGauge.LabelType|string	default-Major
///<br/><br/>
///Specify unitText of circular gauge
///<br/>unitText-string	default-
///<br/><br/>
///Specify unitTextPosition of circular gauge. See UnitTextPosition
///<br/>unitTextPosition-ej.datavisualization.CircularGauge.UnitTextPlacement|string	default-Back
///<br/><br/>
///Specify majorIntervalValue of circular gauge
///<br/>majorIntervalValue-number	default-10
///<br/><br/>
///Specify maximum scale value of circular gauge
///<br/>maximum-number	default-null
///<br/><br/>
///Specify minimum scale value of circular gauge
///<br/>minimum-number	default-null
///<br/><br/>
///Specify minorIntervalValue of circular gauge
///<br/>minorIntervalValue-number	default-2
///<br/><br/>
///Specify opacity value of circular gauge
///<br/>opacity-number	default-1
///<br/><br/>
///Specify pointer cap of circular gauge
///<br/>pointerCap-any	default-Object
///<br/><br/>
///Specify cap backgroundColor of circular gauge
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specify cap borderColor of circular gauge
///<br/>borderColor-string	default-null
///<br/><br/>
///Specify pointerCap borderWidth value of circular gauge
///<br/>borderWidth-number	default-3
///<br/><br/>
///Specify cap interiorGradient value of circular gauge
///<br/>interiorGradient-any	default-null
///<br/><br/>
///Specify pointerCap Radius value of circular gauge
///<br/>radius-number	default-7
///<br/><br/>
///Specify pointers value of circular gauge
///<br/>pointers-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specify backgroundColor for the pointer of circular gauge
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specify backNeedleLength of circular gauge
///<br/>backNeedleLength-number	default-10
///<br/><br/>
///Specify the border for pointers of circular gauge
///<br/>border-any	default-Object
///<br/><br/>
///Specify border color for pointer of circular gauge
///<br/>color-string	default-null
///<br/><br/>
///Specify border width for pointers of circular gauge
///<br/>width-number	default-1.5
///<br/><br/>
///Specify distanceFromScale value for pointers of circular gauge
///<br/>distanceFromScale-number	default-0
///<br/><br/>
///Specify pointer gradients of circular gauge
///<br/>gradients-any	default-null
///<br/><br/>
///Specify pointer image of circular gauge.It is applicable for both marker as well as needle type pointers.
///<br/>imageUrl-string	default-NULL
///<br/><br/>
///Specify pointer length of circular gauge
///<br/>length-number	default-150
///<br/><br/>
///Specify marker Style value of circular gauge. See 
///<br/>markerType-ej.datavisualization.CircularGauge.MarkerType|string	default-Rectangle
///<br/><br/>
///Specify needle Style value of circular gauge. See 
///<br/>needleType-ej.datavisualization.CircularGauge.NeedleType|string	default-Triangle
///<br/><br/>
///Specify opacity value for pointer of circular gauge
///<br/>opacity-number	default-1
///<br/><br/>
///Specify radius value for pointer of circular gauge
///<br/>radius-number	default-null
///<br/><br/>
///Specify pointer Placement value of circular gauge. See PointerPlacement
///<br/>placement-ej.datavisualization.CircularGauge.Placement|string	default-Near
///<br/><br/>
///Specify pointer value text of circular gauge.
///<br/>pointerValueText-any	default-Object
///<br/><br/>
///Specify pointer text angle of circular gauge.
///<br/>angle-number	default-0
///<br/><br/>
///Specify pointer text auto angle of circular gauge.
///<br/>autoAngle-boolean	default-false
///<br/><br/>
///Specify pointer value text color of circular gauge.
///<br/>color-string	default-#8c8c8c
///<br/><br/>
///Specify pointer value text distance from pointer of circular gauge.
///<br/>distance-number	default-20
///<br/><br/>
///Specify pointer value text font option of circular gauge.
///<br/>font-any	default-object
///<br/><br/>
///Specify pointer value text font family of circular gauge.
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Specify pointer value text font style of circular gauge.
///<br/>fontStyle-string	default-Bold
///<br/><br/>
///Specify pointer value text size of circular gauge.
///<br/>size-string	default-11px
///<br/><br/>
///Specify pointer value text opacity of circular gauge.
///<br/>opacity-number	default-1
///<br/><br/>
///enable pointer value text visibility of circular gauge.
///<br/>showValue-boolean	default-false
///<br/><br/>
///Specify showBackNeedle value of circular gauge
///<br/>showBackNeedle-boolean	default-false
///<br/><br/>
///Specify pointer type value of circular gauge. See 
///<br/>type-ej.datavisualization.CircularGauge.PointerType|string	default-Needle
///<br/><br/>
///Specify value of the pointer of circular gauge
///<br/>value-number	default-null
///<br/><br/>
///Specify pointer width of circular gauge
///<br/>width-number	default-7
///<br/><br/>
///Specify scale radius of circular gauge
///<br/>radius-number	default-170
///<br/><br/>
///Specify ranges value of circular gauge
///<br/>ranges-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specify backgroundColor for the ranges of circular gauge
///<br/>backgroundColor-string	default-#32b3c6
///<br/><br/>
///Specify text for the ranges of circular gauge
///<br/>legendText-string	default-null
///<br/><br/>
///Specify border for ranges of circular gauge
///<br/>border-any	default-Object
///<br/><br/>
///Specify border color for ranges of circular gauge
///<br/>color-string	default-#32b3c6
///<br/><br/>
///Specify border width for ranges of circular gauge
///<br/>width-number	default-1.5
///<br/><br/>
///Specify distanceFromScale value for ranges of circular gauge
///<br/>distanceFromScale-number	default-25
///<br/><br/>
///Specify endValue for ranges of circular gauge
///<br/>endValue-number	default-null
///<br/><br/>
///Specify endWidth for ranges of circular gauge
///<br/>endWidth-number	default-10
///<br/><br/>
///Specify range gradients of circular gauge
///<br/>gradients-any	default-null
///<br/><br/>
///Specify opacity value for ranges of circular gauge
///<br/>opacity-number	default-null
///<br/><br/>
///Specify placement of circular gauge. See RangePlacement
///<br/>placement-ej.datavisualization.CircularGauge.Placement|string	default-Near
///<br/><br/>
///Specify size of the range value of circular gauge
///<br/>size-number	default-5
///<br/><br/>
///Specify startValue for ranges of circular gauge
///<br/>startValue-number	default-null
///<br/><br/>
///Specify startWidth of circular gauge
///<br/>startWidth-number	default-[Array.number] scale.ranges.startWidth = 10
///<br/><br/>
///Specify shadowOffset value of circular gauge
///<br/>shadowOffset-number	default-0
///<br/><br/>
///Specify showIndicators of circular gauge
///<br/>showIndicators-boolean	default-false
///<br/><br/>
///Specify showLabels of circular gauge
///<br/>showLabels-boolean	default-true
///<br/><br/>
///Specify showPointers of circular gauge
///<br/>showPointers-boolean	default-true
///<br/><br/>
///Specify showRanges of circular gauge
///<br/>showRanges-boolean	default-false
///<br/><br/>
///Specify showScaleBar of circular gauge
///<br/>showScaleBar-boolean	default-false
///<br/><br/>
///Specify showTicks of circular gauge
///<br/>showTicks-boolean	default-true
///<br/><br/>
///Specify scaleBar size of circular gauge
///<br/>size-number	default-6
///<br/><br/>
///Specify startAngle of circular gauge
///<br/>startAngle-number	default-115
///<br/><br/>
///Specify subGauge of circular gauge
///<br/>subGauges-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specify subGauge Height of circular gauge
///<br/>height-number	default-150
///<br/><br/>
///Specify position for sub-gauge of circular gauge
///<br/>position-any	default-Object
///<br/><br/>
///Specify x-axis position for sub-gauge of circular gauge
///<br/>x-number	default-0
///<br/><br/>
///Specify y-axis position for sub-gauge of circular gauge
///<br/>y-number	default-0
///<br/><br/>
///Specify subGauge Width of circular gauge
///<br/>width-number	default-150
///<br/><br/>
///Specify sweepAngle of circular gauge
///<br/>sweepAngle-number	default-310
///<br/><br/>
///Specify ticks of circular gauge
///<br/>ticks-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specify the angle for the ticks of circular gauge
///<br/>angle-number	default-0
///<br/><br/>
///Specify tick color of circular gauge
///<br/>color-string	default-null
///<br/><br/>
///Specify distanceFromScale value for ticks of circular gauge
///<br/>distanceFromScale-number	default-0
///<br/><br/>
///Specify tick height of circular gauge
///<br/>height-number	default-16
///<br/><br/>
///Specify tick placement of circular gauge. See TickPlacement
///<br/>placement-ej.datavisualization.CircularGauge.Placement|string	default-Near
///<br/><br/>
///Specify tick Style of circular gauge. See TickType
///<br/>type-ej.datavisualization.CircularGauge.LabelType|string	default-Major
///<br/><br/>
///Specify tick width of circular gauge
///<br/>width-number	default-3
///<br/><br/>
///Specify the theme of circular gauge.
///<br/>theme-string	default-flatlight
///<br/><br/>
///Options to customize the legend.
///<br/>legend-Legend	default-
///<br/><br/>
///Toggles the visibility of the legend.
///<br/>visible-boolean	default-false
///<br/><br/>
///Toggles the visibility of the ranges.
///<br/>toggleVisibility-boolean	default-true
///<br/><br/>
///Specifies the alignment of the legend.
///<br/>alignment-ej.datavisualization.CircularGauge.LegendAlignment|string	default-Center. See Alignment
///<br/><br/>
///Options for customizing the legend border.
///<br/>border-any	default-
///<br/><br/>
///Border color of the legend.
///<br/>color-string	default-transparent
///<br/><br/>
///Border width of the legend.
///<br/>width-number	default-1
///<br/><br/>
///Fill color for the legend items. By using this property, it displays all legend item shapes in same color.Legend items representing invisible ranges is displayed in gray color.
///<br/>fill-string	default-null
///<br/><br/>
///Gap or padding between the legend items.
///<br/>itemPadding-number	default-20
///<br/><br/>
///Options to customize the style of legend items.
///<br/>itemStyle-any	default-
///<br/><br/>
///Options for customizing the border of legend items.
///<br/>border-any	default-
///<br/><br/>
///Border color of the legend items.
///<br/>color-string	default-transparent
///<br/><br/>
///Border width of the legend items.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the height of the  legend item shapes.
///<br/>height-number	default-10
///<br/><br/>
///Specifies the width of the  legend item shapes.
///<br/>width-number	default-10
///<br/><br/>
///Opacity of the legend.
///<br/>opacity-number	default-1
///<br/><br/>
///Places the legend at specified position. Legend can be placed at **left**, **right**, **top** or **bottom** of the circular gauge.
///<br/>position-ej.datavisualization.CircularGauge.LegendPosition|string	default-Bottom. See Position
///<br/><br/>
///Shape of the legend items.
///<br/>shape-ej.datavisualization.CircularGauge.LegendShape|string	default-Circle. See Shape
///<br/><br/>
///Options to customize the size of the legend.
///<br/>size-any	default-
///<br/><br/>
///Specify the height of the legend. Height can be specified in pixel.
///<br/>height-string	default-null
///<br/><br/>
///Specify the width of the legend. Width can be specified in pixel.
///<br/>width-string	default-null
///<br/><br/>
///Options to customize the font used for legend item text.
///<br/>font-any	default-
///<br/><br/>
///Font family for legend item text.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style for legend item text.
///<br/>fontStyle-string	default-Normal
///<br/><br/>
///Font weight for legend item text.
///<br/>fontWeight-string	default-Regular
///<br/><br/>
///Font size for legend item text.
///<br/>size-string	default-12px
///<br/><br/>
///Font color of the text for legend items.
///<br/>color-string	default-null
///<br/><br/>
///Specify tooltip option of circular gauge
///<br/>tooltip-Tooltip	default-object
///<br/><br/>
///enable showCustomLabelTooltip of circular gauge
///<br/>showCustomLabelTooltip-boolean	default-false
///<br/><br/>
///enable showLabelTooltip of circular gauge
///<br/>showLabelTooltip-boolean	default-false
///<br/><br/>
///Specify tooltip templateID of circular gauge
///<br/>templateID-string	default-false
///<br/><br/>
///Specifies the value of circular gauge.
///<br/>value-number	default-0
///<br/><br/>
///Specifies the width of circular gauge.
///<br/>width-number	default-360
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
ColorPicker:function(){
 /// <signature>
 /// <summary>Constructor of ej.ColorPicker</summary>
 /// </signature>
}
});
ej.ColorPicker=(function(){
var original=ej.ColorPicker
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

disable:function(){
/// <signature>
/// <summary>
/// Disables the color picker control
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// Enable the color picker control
/// </summary>
},
getColor:function(){
/// <signature>
/// <summary>
/// Gets the selected color in RGB format
/// </summary>
},
getValue:function(){
/// <signature>
/// <summary>
/// Gets the selected color value as string
/// </summary>
},
hexCodeToRGB:function(colorCode){
/// <signature>
/// <summary>
/// To Convert color value from hexCode to RGB
/// </summary>
/// <param name="colorCode"	type="string">Specified HEX code converted to RGB</param>
/// </signature>
},
hide:function(){
/// <signature>
/// <summary>
/// Hides the ColorPicker popup, if in opened state.
/// </summary>
},
HSVToRGB:function(HSV){
/// <signature>
/// <summary>
/// Convert color value from HSV to RGB
/// </summary>
/// <param name="HSV"	type="any">Specified HSV code converted to RGB</param>
/// </signature>
},
RGBToHEX:function(RGB){
/// <signature>
/// <summary>
/// Convert color value from RGB to HEX
/// </summary>
/// <param name="RGB"	type="any">Specified RGB code converted to HEX code</param>
/// </signature>
},
RGBToHSV:function(RGB){
/// <signature>
/// <summary>
/// Convert color value from RGB to HSV
/// </summary>
/// <param name="RGB"	type="any">Specified RGB code converted to HSV code</param>
/// </signature>
},
show:function(){
/// <signature>
/// <summary>
/// Open the ColorPicker popup.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejColorPicker=function(){
this.data("ejColorPicker",new	ej.ColorPicker());
return this;
};
intellisense.annotate(jQuery.fn,{
ejColorPicker :function (options) {
/// <signature>
/// <summary><br/>
///The ColorPicker control provides you a rich visual interface for color selection. You can select the color from the professionally designed palettes or custom color. By clicking a point on the color, you can change the active color to the color that is located under the pointer.<br/><br/>
///The ColorPicker control allows to define the customized text to displayed in button elements. Using the property to achieve the customized culture values.
///<br/>buttonText-ButtonText	default-{ apply: Apply, cancel: Cancel, swatches: Swatches }
///<br/><br/>
///Sets the text for the apply button.
///<br/>apply-string	default-
///<br/><br/>
///Sets the text for the cancel button.
///<br/>cancel-string	default-
///<br/><br/>
///Sets the header text for the swatches area.
///<br/>swatches-string	default-
///<br/><br/>
///Allows to change the mode of the button. Please refer below to know available button mode
///<br/>buttonMode-ej.ButtonMode|string	default-ej.ButtonMode.Split
///<br/><br/>
///Specifies the number of columns to be displayed color palette model.
///<br/>columns-number|string	default-10
///<br/><br/>
///This property allows you to customize its appearance using user-defined CSS and custom skin options such as colors and backgrounds.
///<br/>cssClass-string	default-
///<br/><br/>
///This property allows to define the custom colors in the palette model.Custom palettes are created by passing a comma delimited string of HEX values or an array of colors.
///<br/>custom-Array&lt;any&gt;	default-empty
///<br/><br/>
///This property allows to embed the popup in the order of DOM element flow . When we set the value as true, the color picker popup is always in visible state.
///<br/>displayInline-boolean	default-false
///<br/><br/>
///This property allows to change the control in enabled or disabled state.
///<br/>enabled-boolean	default-true
///<br/><br/>
///This property allows to enable or disable the opacity slider in the color picker control
///<br/>enableOpacity-boolean	default-true
///<br/><br/>
///It allows to define the characteristics of the ColorPicker control. It will helps to extend the capability of an HTML element.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Defines the localized text values in button and tooltip.
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the model type to be rendered initially in the color picker control. See below to get available ModelType
///<br/>modelType-ej.ColorPicker.ModelType|string	default-ej.ColorPicker.ModelType.Default
///<br/><br/>
///This property allows to change the opacity value .The selected color opacity will be adjusted by using this opacity value.
///<br/>opacityValue-number|string	default-100
///<br/><br/>
///Specifies the palette type to be displayed at initial time in palette model.There two types of palette model available in ColorPicker control. See below available Palette
///<br/>palette-ej.ColorPicker.Palette|string	default-ej.ColorPicker.Palette.BasicPalette
///<br/><br/>
///This property allows to define the preset model to be rendered initially in palette type.It consists of 12 different types of presets. Each presets have 50 colors. See below available Presets
///<br/>presetType-ej.ColorPicker.Presets|string	default-ej.ColorPicker.Presets.Basic
///<br/><br/>
///Allows to show/hides the apply and cancel buttons in ColorPicker control
///<br/>showApplyCancel-boolean	default-true
///<br/><br/>
///Allows to show/hides the clear button in ColorPicker control
///<br/>showClearButton-boolean	default-true
///<br/><br/>
///This property allows to provides live preview support for current cursor selection color and selected color.
///<br/>showPreview-boolean	default-true
///<br/><br/>
///This property allows to store the color values in custom list.The ColorPicker will keep up to 11 colors in a custom list.By clicking the add button, the selected color from picker or palette will get added in the recent color list.
///<br/>showRecentColors-boolean	default-false
///<br/><br/>
///Allows to show/hides the switcher button in ColorPicker control.It helps to switch palette or picker mode in colorpicker.
///<br/>showSwitcher-boolean	default-true
///<br/><br/>
///This property allows to shows tooltip to notify the slider value in color picker control.
///<br/>showTooltip-boolean	default-false
///<br/><br/>
///Specifies the toolIcon to be displayed in dropdown control color area.
///<br/>toolIcon-string	default-null
///<br/><br/>
///This property allows to define the customized text or content to displayed when mouse over the following elements. This property also allows to use the culture values.
///<br/>tooltipText-TooltipText	default-{ switcher: Switcher, addButton: Add Color, basic: Basic, monoChrome: Mono Chrome, flatColors: Flat Color, seaWolf: Sea Wolf, webColors: Web Colors, sandy: Sandy, pinkShades: Pink Shades, misty: Misty, citrus: Citrus, vintage: Vintage, moonLight: Moon Light, candyCrush: Candy Crush, currentColor: Current Color, selectedColor: Selected Color }
///<br/><br/>
///Sets the tooltip text for the switcher button.
///<br/>switcher-string	default-
///<br/><br/>
///Sets the tooltip text for the add button.
///<br/>addButton-string	default-
///<br/><br/>
///Sets the tooltip text for the basic preset.
///<br/>basic-string	default-
///<br/><br/>
///Sets the tooltip text for the mono chrome preset.
///<br/>monoChrome-string	default-
///<br/><br/>
///Sets the tooltip text for the flat colors preset.
///<br/>flatColors-string	default-
///<br/><br/>
///Sets the tooltip text for the sea wolf preset.
///<br/>seaWolf-string	default-
///<br/><br/>
///Sets the tooltip text for the web colors preset.
///<br/>webColors-string	default-
///<br/><br/>
///Sets the tooltip text for the sandy preset.
///<br/>sandy-string	default-
///<br/><br/>
///Sets the tooltip text for the pink shades preset.
///<br/>pinkShades-string	default-
///<br/><br/>
///Sets the tooltip text for the misty preset.
///<br/>misty-string	default-
///<br/><br/>
///Sets the tooltip text for the citrus preset.
///<br/>citrus-string	default-
///<br/><br/>
///Sets the tooltip text for the vintage preset.
///<br/>vintage-string	default-
///<br/><br/>
///Sets the tooltip text for the moon light preset.
///<br/>moonLight-string	default-
///<br/><br/>
///Sets the tooltip text for the candy crush preset.
///<br/>candyCrush-string	default-
///<br/><br/>
///Sets the tooltip text for the current color area.
///<br/>currentColor-string	default-
///<br/><br/>
///Sets the tooltip text for the selected color area.
///<br/>selectedColor-string	default-
///<br/><br/>
///Specifies the color value for color picker control, the value is in hexadecimal form with prefix of "#".
///<br/>value-string	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
ComboBox:function(){
 /// <signature>
 /// <summary>Constructor of ej.ComboBox</summary>
 /// </signature>
}
});
ej.ComboBox=(function(){
var original=ej.ComboBox
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addItem:function(){
/// <signature>
/// <summary>
/// Adds a new item to the popup list. By default, new item appends to the list as the last item, but you can insert based on the index parameter.
/// </summary>
},
focusIn:function(){
/// <signature>
/// <summary>
/// Sets the focus to the component for interaction.
/// </summary>
},
focusOut:function(){
/// <signature>
/// <summary>
/// Moves the focus from the component if the component is already focused.
/// </summary>
},
getDataByValue:function(){
/// <signature>
/// <summary>
/// Gets the data object that matches the given value.
/// </summary>
},
getItems:function(){
/// <signature>
/// <summary>
/// Gets all the list items bound on this component.
/// </summary>
},
hidePopup:function(){
/// <signature>
/// <summary>
/// Hides the popup if it is in open state.
/// </summary>
},
showPopup:function(){
/// <signature>
/// <summary>
/// Opens the popup that displays the list of items.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejComboBox=function(){
this.data("ejComboBox",new	ej.ComboBox());
return this;
};
intellisense.annotate(jQuery.fn,{
ejComboBox :function (options) {
/// <signature>
/// <summary><br/>
///The ComboBox component allows the user to type a value or choose an option from the list of predefined options.<br/><br/>
///Accepts the template and assigns it to the popup list content of the component when the data fetch request from the remote server fails.
///<br/>actionFailureTemplate-string	default-The Request Failed
///<br/><br/>
///Specifies whether the component allows user defined value which does not exist in data source.
///<br/>allowCustom-boolean	default-true
///<br/><br/>
///When allowFiltering is set to true, show the filter bar (search box) of the component. The filter action retrieves matched items through the filtering event based on the characters typed in the search TextBox. If no match is found, the value of the noRecordsTemplate property will be displayed.
///<br/>allowFiltering-boolean	default-false
///<br/><br/>
///Specifies whether suggest a first matched item in input when searching. No action happens when no matches found.
///<br/>autofill-boolean	default-false
///<br/><br/>
///Sets CSS classes to the root element of the component that helps customize the UI styles.
///<br/>cssClass-string	default-null
///<br/><br/>
///Accepts the list items either through local or remote service and binds it to the component. It can be an array of JSON objects or an instance of DataManager.
///<br/>dataSource-any|Array&lt;any&gt;	default-[]
///<br/><br/>
///When set to true, enables RTL mode of the component that displays the content in the right-to-left direction.
///<br/>enableRtl-boolean	default-false
///<br/><br/>
///Specifies a value that indicates whether the component is enabled or not.
///<br/>enabled-boolean	default-true
///<br/><br/>
///The fields property maps the columns of the data table and binds the data to the component.
///<br/>fields-Fields	default-
///<br/><br/>
///Used to group the popup list items.
///<br/>groupBy-string	default-null
///<br/><br/>
///Defines class for the item.
///<br/>iconCss-string	default-null
///<br/><br/>
///Defines the specific field name which contains unique values for the list items.
///<br/>value-string	default-null
///<br/><br/>
///Defines the specific field name in the data source to load the popup list with data.
///<br/>text-string	default-null
///<br/><br/>
///Accepts the template design and assigns it to the footer container of the popup list.
///<br/>footerTemplate-string	default-null
///<br/><br/>
///Accepts the template design and assigns it to the group headers present in the popup list.
///<br/>groupTemplate-string	default-null
///<br/><br/>
///Accepts the template design and assigns it to the header container of the popup list.
///<br/>headerTemplate-string	default-null
///<br/><br/>
///Allows additional HTML attributes such as title, name, etc., and accepts n number of attributes in a key-value pair format.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Gets or sets the index of the selected item in the component.
///<br/>index-number	default-null
///<br/><br/>
///Accepts the template design and assigns it to each list item present in the popup.
///<br/>itemTemplate-string	default-null
///<br/><br/>
///Overrides the global culture and localization value for this component. Default global culture is 'en-US'.
///<br/>locale-string	default-en-US
///<br/><br/>
///Accepts the template design and assigns it to popup list of component when no data is available on the component.
///<br/>noRecordsTemplate-string	default-No Records Found
///<br/><br/>
///Accepts the value to be displayed as a watermark text on the component input.
///<br/>placeholder-string	default-null
///<br/><br/>
///Specifies the height of the popup list.
///<br/>popupHeight-string|number	default-300px
///<br/><br/>
///Specifies the width of the popup list. By default, the popup width sets based on the width of the component.
///<br/>popupWidth-string|number	default-100%
///<br/><br/>
///The query to retrieve the data from the data source.
///<br/>query-ej.Query	default-null
///<br/><br/>
///When set to true, the user interactions on the component are disabled.
///<br/>readonly-boolean	default-false
///<br/><br/>
///Specifies whether to show or hide the clear button. When the clear button is clicked, value, text, and index properties are reset to null.
///<br/>showClearButton-boolean	default-true
///<br/><br/>
///Specifies the sortOrder to sort the data source. The available type of sort orders are
///<br/>sortOrder-ej.ComboBox.SortOrder|string	default-ej.SortOrder.None
///<br/><br/>
///Gets or sets the display text of the selected item in the component.
///<br/>text-string	default-null
///<br/><br/>
///Gets or sets the value of the selected item in the component.
///<br/>value-number|string	default-null
///<br/><br/>
///Specifies the width of the component. By default, the component width sets based on the width of its parent container. You can also set the width in pixel values.
///<br/>width-number|string	default-100%
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
DataManager:function(){
 /// <signature>
 /// <summary>Constructor of ej.DataManager</summary>
 /// </signature>
}
});
ej.DataManager=(function(){
var original=ej.DataManager
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

executeLocal:function(query){
/// <signature>
/// <summary>
/// This method does not execute more than one operation at a time; it waits for one operation to complete, and then executes the next operation.
/// </summary>
/// <param name="query"	type="ej.query">Sets the default query for the data source.</param>
/// </signature>
},
executeQuery:function(query, done, fail, always){
/// <signature>
/// <summary>
/// The executeQuery property is used to process the data based on the query on URL Binding.
/// </summary>
/// <param name="query"	type="ej.query">Sets the default query for the data source.</param>
/// </signature>
/// <signature>
/// <summary>
/// The executeQuery property is used to process the data based on the query on URL Binding.
/// </summary>
/// <param name="done"	type="() =&gt; void">A function to be called if the request succeeds.</param>
/// </signature>
/// <signature>
/// <summary>
/// The executeQuery property is used to process the data based on the query on URL Binding.
/// </summary>
/// <param name="fail"	type="() =&gt; void">A function to be called if the request fails.</param>
/// </signature>
/// <signature>
/// <summary>
/// The executeQuery property is used to process the data based on the query on URL Binding.
/// </summary>
/// <param name="always"	type="() =&gt; void">A function to be called when the request finishes (after success and error callbacks are executed).</param>
/// </signature>
},
insert:function(data, tableName, query){
/// <signature>
/// <summary>
/// Inserts a data item in the data table.
/// </summary>
/// <param name="data"	type="any">JSON data or JSON array</param>
/// </signature>
/// <signature>
/// <summary>
/// Inserts a data item in the data table.
/// </summary>
/// <param name="tableName"	type="string">Name of the table</param>
/// </signature>
/// <signature>
/// <summary>
/// Inserts a data item in the data table.
/// </summary>
/// <param name="query"	type="ej.query">Sets the default query for the data source.</param>
/// </signature>
},
remove:function(keyField, value, tableName, query){
/// <signature>
/// <summary>
/// It is used to remove the data from the dataSource.
/// </summary>
/// <param name="keyField"	type="string">KeyColumn to find the data</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to remove the data from the dataSource.
/// </summary>
/// <param name="value"	type="string">Specified value for the keyField</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to remove the data from the dataSource.
/// </summary>
/// <param name="tableName"	type="string">Name of the source table</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to remove the data from the dataSource.
/// </summary>
/// <param name="query"	type="ej.query">Sets the default query for the data source.</param>
/// </signature>
},
saveChanges:function(changes, key, tableName, query){
/// <signature>
/// <summary>
/// This method is used to save the changes to the corresponding table. You can add a new record, edit an existing record, or delete a record by using this method.
/// </summary>
/// <param name="changes"	type="any">Specified values for the Data Table</param>
/// </signature>
/// <signature>
/// <summary>
/// This method is used to save the changes to the corresponding table. You can add a new record, edit an existing record, or delete a record by using this method.
/// </summary>
/// <param name="key"	type="string">KeyColumn to find the data</param>
/// </signature>
/// <signature>
/// <summary>
/// This method is used to save the changes to the corresponding table. You can add a new record, edit an existing record, or delete a record by using this method.
/// </summary>
/// <param name="tableName"	type="string">Name of the source table</param>
/// </signature>
/// <signature>
/// <summary>
/// This method is used to save the changes to the corresponding table. You can add a new record, edit an existing record, or delete a record by using this method.
/// </summary>
/// <param name="query"	type="ej.query">Sets the default query for the data source.</param>
/// </signature>
},
update:function(keyField, value, tableName, query){
/// <signature>
/// <summary>
/// Updates existing record and saves the changes to the table.
/// </summary>
/// <param name="keyField"	type="string">KeyColumn to find the data</param>
/// </signature>
/// <signature>
/// <summary>
/// Updates existing record and saves the changes to the table.
/// </summary>
/// <param name="value"	type="string">Specified value for the keyField</param>
/// </signature>
/// <signature>
/// <summary>
/// Updates existing record and saves the changes to the table.
/// </summary>
/// <param name="tableName"	type="string">Name of the source table</param>
/// </signature>
/// <signature>
/// <summary>
/// Updates existing record and saves the changes to the table.
/// </summary>
/// <param name="query"	type="ej.query">Sets the default query for the data source.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDataManager=function(){
this.data("ejDataManager",new	ej.DataManager());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDataManager :function (options) {
/// <signature>
/// <summary><br/>
///Communicates with data source and returns the desired result based on the Query provided.</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
DatePicker:function(){
 /// <signature>
 /// <summary>Constructor of ej.DatePicker</summary>
 /// </signature>
}
});
ej.DatePicker=(function(){
var original=ej.DatePicker
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

disable:function(){
/// <signature>
/// <summary>
/// Disables the DatePicker control.
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// Enable the DatePicker control, if it is in disabled state.
/// </summary>
},
getValue:function(){
/// <signature>
/// <summary>
/// Returns the current date value in the DatePicker control.
/// </summary>
},
setValue:function(){
/// <signature>
/// <summary>
/// sets the date value for the DatePicker.
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// Close the DatePicker popup, if it is in opened state.
/// </summary>
},
show:function(){
/// <signature>
/// <summary>
/// Opens the DatePicker popup.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDatePicker=function(){
this.data("ejDatePicker",new	ej.DatePicker());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDatePicker :function (options) {
/// <signature>
/// <summary><br/>
///Input field that display the DatePicker calendar as popup to select and set the date value<br/><br/>
///Used to allow or restrict the editing in DatePicker input field directly. By setting false to this API, You can only pick the date from DatePicker popup.
///<br/>allowEdit-boolean	default-true
///<br/><br/>
///allow or restrict the drill down to multiple levels of view (month/year/decade) in DatePicker calendar
///<br/>allowDrillDown-boolean	default-true
///<br/><br/>
///Disable the list of specified date value.
///<br/>blackoutDates-any	default-{}
///<br/><br/>
///Sets the specified text value to the today button in the DatePicker calendar.
///<br/>buttonText-string	default-Today
///<br/><br/>
///Sets the root CSS class for DatePicker theme, which is used customize.
///<br/>cssClass-string	default-
///<br/><br/>
///Formats the value of the DatePicker in to the specified date format. If this API is not specified, dateFormat will be set based on the current culture of DatePicker.
///<br/>dateFormat-string	default-MM/dd/yyyy
///<br/><br/>
///Specifies the header format of days in DatePicker calendar. See below to get available Headers options
///<br/>dayHeaderFormat-string | ej.DatePicker.Header	default-ej.DatePicker.Header.Short
///<br/><br/>
///Specifies the navigation depth level in DatePicker calendar. This option is not applied when start level view option is lower than depth level view. See below to know available levels in DatePicker Calendar
///<br/>depthLevel-string | ej.DatePicker.Level	default-
///<br/><br/>
///Allows to embed the DatePicker calendar in the page. Also associates DatePicker with div element instead of input.
///<br/>displayInline-boolean	default-false
///<br/><br/>
///Enables or disables the animation effect with DatePicker calendar.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Enable or disable the DatePicker control.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Sustain the entire widget model of DatePicker even after form post or browser refresh
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Displays DatePicker calendar along with DatePicker input field in Right to Left direction.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Allows to enter valid or invalid date in input textbox and indicate as error if it is invalid value, when this API value is set to true. For false value, invalid date is not allowed to input field and corrected to valid date automatically, even if invalid date is given.
///<br/>enableStrictMode-boolean	default-false
///<br/><br/>
///Used  the required fields for special Dates in DatePicker in order to customize the special dates in a calendar.
///<br/>fields-Fields	default-null
///<br/><br/>
///Specifies the specials dates
///<br/>date-string	default-
///<br/><br/>
///Specifies the icon class to special dates.
///<br/>iconClass-string	default-
///<br/><br/>
///Specifies the tooltip to special dates.
///<br/>tooltip-string	default-
///<br/><br/>
///Specifies the CSS class to customize the date.
///<br/>cssClass-string	default-
///<br/><br/>
///Specifies the header format to be displayed in the DatePicker calendar.
///<br/>headerFormat-string	default-MMMM yyyy
///<br/><br/>
///Specifies the height of the DatePicker input text.
///<br/>height-string	default-28px
///<br/><br/>
///HighlightSection is used to highlight currently selected date's month/week/workdays. See below to get available HighlightSection options
///<br/>highlightSection-string | ej.DatePicker.HighlightSection	default-none
///<br/><br/>
///Weekend  dates will be highlighted when this property is set to true.
///<br/>highlightWeekend-boolean	default-false
///<br/><br/>
///Specifies the HTML Attributes of the DatePicker.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Change the DatePicker calendar and date format based on given culture.
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the maximum date in the calendar that the user can select.
///<br/>maxDate-string|Date	default-new Date(2099, 11, 31)
///<br/><br/>
///Specifies the minimum date in the calendar that the user can select.
///<br/>minDate-string|Date	default-new Date(1900, 00, 01)
///<br/><br/>
///Allows to toggles the read only state of the DatePicker. When the widget is readOnly, it doesn't allow your input.
///<br/>readOnly-boolean	default-false
///<br/><br/>
///It allow to show/hide the disabled date ranges
///<br/>showDisabledRange-boolean	default-true
///<br/><br/>
///It allows to display footer in DatePicker calendar.
///<br/>showFooter-boolean	default-true
///<br/><br/>
///It allows to display/hides the other months days from the current month calendar in a DatePicker.
///<br/>showOtherMonths-boolean	default-true
///<br/><br/>
///Shows/hides the date icon button at right side of textbox, which is used to open or close the DatePicker calendar popup.
///<br/>showPopupButton-boolean	default-true
///<br/><br/>
///DatePicker input is displayed with rounded corner when this property is set to true.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Used to show the tooltip when hovering on the days in the DatePicker calendar.
///<br/>showTooltip-boolean	default-true
///<br/><br/>
///Specifies the special dates in DatePicker.
///<br/>specialDates-any	default-null
///<br/><br/>
///Specifies the start day of the week in DatePicker calendar.
///<br/>startDay-number	default-0
///<br/><br/>
///Specifies the start level view in DatePicker calendar. See below available Levels
///<br/>startLevel-string | ej.DatePicker.Level	default-ej.DatePicker.Level.Month
///<br/><br/>
///Specifies the number of months to be navigate for one click of next and previous button in a DatePicker Calendar.
///<br/>stepMonths-number	default-1
///<br/><br/>
///Provides option to customize the tooltip format.
///<br/>tooltipFormat-string	default-ddd MMM dd yyyy
///<br/><br/>
///Sets the jQuery validation support to DatePicker Date value. See validation
///<br/>validationMessage-any	default-null
///<br/><br/>
///Sets the jQuery validation custom rules to the DatePicker. see validation
///<br/>validationRules-any	default-null
///<br/><br/>
///sets or returns the current value of DatePicker
///<br/>value-string|Date	default-null
///<br/><br/>
///Specifies the water mark text to be displayed in input text.
///<br/>watermarkText-string	default-Select date
///<br/><br/>
///Allows to embed  a new column with the calendar in the popup, which will display the week number of every week in a calendar year.
///<br/>weekNumber-boolean	default-false
///<br/><br/>
///Specifies the width of the DatePicker input text.
///<br/>width-string	default-160px
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
DateRangePicker:function(){
 /// <signature>
 /// <summary>Constructor of ej.DateRangePicker</summary>
 /// </signature>
}
});
ej.DateRangePicker=(function(){
var original=ej.DateRangePicker
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addRanges:function(label, range){
/// <signature>
/// <summary>
/// Add the preset ranges to DateRangePicker popup.
/// </summary>
/// <param name="label"	type="string">Display name</param>
/// </signature>
/// <signature>
/// <summary>
/// Add the preset ranges to DateRangePicker popup.
/// </summary>
/// <param name="range"	type="any[]">StartDate and endDate of range.</param>
/// </signature>
},
clearRanges:function(){
/// <signature>
/// <summary>
/// Clears the all ranges selections in DateRangePicker popup
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// Disables the DateRangePicker control.
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// Enable the DateRangePicker control, if it is in disabled state.
/// </summary>
},
getSelectedRange:function(){
/// <signature>
/// <summary>
/// Returns the startDate and endDate values in the selected ranges in the DateRangePicker control.
/// </summary>
},
popupHide:function(){
/// <signature>
/// <summary>
/// Close the DateRangePicker popup, if it is in opened state.
/// </summary>
},
popupShow:function(){
/// <signature>
/// <summary>
/// Opens the DateRangePicker popup.
/// </summary>
},
setRange:function(){
/// <signature>
/// <summary>
/// set the preset ranges to DateRangePicker popup.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDateRangePicker=function(){
this.data("ejDateRangePicker",new	ej.DateRangePicker());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDateRangePicker :function (options) {
/// <signature>
/// <summary><br/>
///Input field that displays the two DatePicker type calendar in a single popup to select and set the different date ranges<br/><br/>
///Used to allow or restrict the editing in DateRangePicker input field directly. By setting false to this API, You can only pick the date ranges from DateRangePicker popup.
///<br/>allowEdit-boolean	default-true
///<br/><br/>
///Sets the specified text value to the available buttons (Reset, Cancel, Apply) in the DateRangePicker popup.
///<br/>buttonText-any	default-{ reset: Reset, cancel: Cancel, apply: Apply}
///<br/><br/>
///Sets the root CSS class for DateRangePicker theme, which is used to customize.
///<br/>cssClass-string	default-
///<br/><br/>
///Formats the date value of the DateRangePicker in to the specified date format. If this API is not specified, dateFormat will be set based on the current culture of DateRangePicker.
///<br/>dateFormat-string	default-MM/dd/yyyy
///<br/><br/>
///Allows to embed the Timepicker align with the calendars in the page, two timepicker will be render, for selecting start and end date.
///<br/>enableTimePicker-boolean	default-false
///<br/><br/>
///Enable or disable the DateRangePicker control.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Sustain the entire widget model of DateRangePicker even after form post or browser refresh
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Specifies the end date of the date ranges.
///<br/>endDate-string|Date	default-null
///<br/><br/>
///Specifies the height of the DateRangePicker input.
///<br/>height-string|number	default-28px
///<br/><br/>
///Change the DateRangePicker calendar and date format based on given culture.
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the maximum date in the calendar that the user can select as a startDate or endDate.
///<br/>maxDate-string|Date	default-new Date(2099, 11, 31)
///<br/><br/>
///Specifies the minimum date in the calendar that the user can select as a startDate or endDate.
///<br/>minDate-string|Date	default-new Date(1900, 00, 01)
///<br/><br/>
///Used to add the preset ranges. Added ranges using this, will show in popup in right side for easy selection of different preset ranges.
///<br/>ranges-any	default-null
///<br/><br/>
///Used to separate the two date strings of the value in the DateRangePicker popup.
///<br/>separator-string	default--
///<br/><br/>
///Specifies the start date of the date ranges
///<br/>startDate-string|Date	default-null
///<br/><br/>
///Shows/hides the date icon button at right side of textbox, which is used to open or close the DateRangePicker calendar popup.
///<br/>showPopupButton-boolean	default-true
///<br/><br/>
///DateRangePicker input and popup is displayed with rounded corner when this property is set to true.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Formats the date value of the DateRangePicker in to the specified time format. If this API is not specified, timeFormat will be set based on the current culture of DateRangePicker.
///<br/>timeFormat-string	default-HH:mm tt
///<br/><br/>
///Separated two date values in string format to sets the date ranges in calendars.
///<br/>value-string	default-null
///<br/><br/>
///Specifies the water mark text to be displayed in input text.
///<br/>watermarkText-string	default-Select Range
///<br/><br/>
///Specifies the width of the DateRangePicker input text.
///<br/>width-string|number	default-160px
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
DateTimePicker:function(){
 /// <signature>
 /// <summary>Constructor of ej.DateTimePicker</summary>
 /// </signature>
}
});
ej.DateTimePicker=(function(){
var original=ej.DateTimePicker
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

disable:function(){
/// <signature>
/// <summary>
/// Disables the DateTimePicker control.
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// Enables the DateTimePicker control.
/// </summary>
},
getValue:function(){
/// <signature>
/// <summary>
/// Returns the current datetime value in the DateTimePicker.
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// Hides or closes the DateTimePicker popup.
/// </summary>
},
setCurrentDateTime:function(){
/// <signature>
/// <summary>
/// Updates the current system date value and time value to the DateTimePicker.
/// </summary>
},
show:function(){
/// <signature>
/// <summary>
/// Shows or opens the DateTimePicker popup.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDateTimePicker=function(){
this.data("ejDateTimePicker",new	ej.DateTimePicker());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDateTimePicker :function (options) {
/// <signature>
/// <summary><br/>
///The DateTimePicker control is used to input the date and time with a specific format. It combines the DatePicker and TimePicker controls so that users can select the date and time with their desired format.<br/><br/>
///Used to allow or restrict the editing in DateTimePicker input field directly. By setting false to this API, You can only pick the date and time values from DateTimePicker popup.
///<br/>allowEdit-boolean	default-true
///<br/><br/>
///Displays the custom text for the buttons inside the DateTimePicker popup. when the culture value changed, we can change the buttons text based on the culture.
///<br/>buttonText-ButtonText	default-{ today: Today, timeNow: Time Now, done: Done, timeTitle: Time }
///<br/><br/>
///Sets the text for the Done button inside the datetime popup.
///<br/>done-string	default-
///<br/><br/>
///Sets the text for the Now button inside the datetime popup.
///<br/>timeNow-string	default-
///<br/><br/>
///Sets the header text for the Time dropdown.
///<br/>timeTitle-string	default-
///<br/><br/>
///Sets the text for the Today button inside the datetime popup.
///<br/>today-string	default-
///<br/><br/>
///Disable the list of specified date value.
///<br/>blackoutDates-any	default-{}
///<br/><br/>
///Set the root class for DateTimePicker theme. This cssClass API helps to use custom skinning option for DateTimePicker control.
///<br/>cssClass-string	default-
///<br/><br/>
///Defines the datetime format displayed in the DateTimePicker. The value should be a combination of date format and time format.
///<br/>dateTimeFormat-string	default-M/d/yyyy h:mm tt
///<br/><br/>
///Specifies the header format of the datepicker inside the DateTimePicker popup. See DatePicker.Header
///<br/>dayHeaderFormat-ej.DatePicker.Header|string	default-ej.DatePicker.Header.Short
///<br/><br/>
///Specifies the navigation depth level in DatePicker calendar inside DateTimePicker popup. This option is not applied when start level view option is lower than depth level view. See ej.DatePicker.Level
///<br/>depthLevel-ej.DatePicker.Level|string	default-
///<br/><br/>
///Specifies the list of time range to be disabled.
///<br/>disableTimeRanges-any	default-{}
///<br/><br/>
///Enable or disable the animation effect in DateTimePicker.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///When this property is set to false, it disables the DateTimePicker control.
///<br/>enabled-boolean	default-false
///<br/><br/>
///Enables or disables the state maintenance of DateTimePicker.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Sets the DateTimePicker direction as right to left alignment.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///When enableStrictMode true it allows the value outside of the range also but it highlights the textbox with error class, otherwise it internally changed to the correct value.
///<br/>enableStrictMode-boolean	default-false
///<br/><br/>
///Specifies the header format to be displayed in the DatePicker calendar inside the DateTimePicker popup.
///<br/>headerFormat-string	default-MMMM yyyy
///<br/><br/>
///Defines the height of the DateTimePicker textbox.
///<br/>height-string|number	default-30
///<br/><br/>
///Specifies the HTML Attributes of the ejDateTimePicker
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Sets the time interval between the two adjacent time values in the time popup.
///<br/>interval-number	default-30
///<br/><br/>
///Defines the localization culture for DateTimePicker.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the maximum value to the DateTimePicker. Beyond the maximum value an error class is added to the wrapper element when we set true to enableStrictMode.
///<br/>maxDateTime-string|Date	default-new Date(12/31/2099 11:59:59 PM)
///<br/><br/>
///Sets the minimum value to the DateTimePicker. Behind the minimum value an error class is added to the wrapper element.
///<br/>minDateTime-string|Date	default-new Date(1/1/1900 12:00:00 AM)
///<br/><br/>
///Specifies the popup position of DateTimePicker.See below to know available popup positions
///<br/>popupPosition-string | ej.popupPosition	default-ej.PopupPosition.Bottom
///<br/><br/>
///Indicates that the DateTimePicker value can only be read and canâ€™t change.
///<br/>readOnly-boolean	default-false
///<br/><br/>
///It allows showing days in other months of DatePicker calendar inside the DateTimePicker popup.
///<br/>showOtherMonths-boolean	default-true
///<br/><br/>
///Shows or hides the arrow button from the DateTimePicker textbox. When the button disabled, the DateTimePicker popup opens while focus in the textbox and hides while focus out from the textbox.
///<br/>showPopupButton-boolean	default-true
///<br/><br/>
///Changes the sharped edges into rounded corner for the DateTimePicker textbox and popup.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Specifies the special dates in DateTimePicker.
///<br/>specialDates-any	default-null
///<br/><br/>
///Specifies the start day of the week in datepicker inside the DateTimePicker popup.
///<br/>startDay-number	default-1
///<br/><br/>
///Specifies the start level view in datepicker inside the DateTimePicker popup. See DatePicker.Level
///<br/>startLevel-ej.DatePicker.Level|string	default-ej.DatePicker.Level.Month or month
///<br/><br/>
///Specifies the number of months to navigate at one click of next and previous button in datepicker inside the DateTimePicker popup.
///<br/>stepMonths-number	default-1
///<br/><br/>
///Defines the time format displayed in the time dropdown inside the DateTimePicker popup.
///<br/>timeDisplayFormat-string	default-h:mm tt
///<br/><br/>
///We can drill down up to time interval on selected date with meridian details.
///<br/>timeDrillDown-TimeDrillDown	default-{ enabled: false, interval: 5, showMeridian: false, autoClose: true }
///<br/><br/>
///This is the field to show/hide the timeDrillDown in DateTimePicker.
///<br/>enabled-boolean	default-
///<br/><br/>
///Sets the interval time of minutes on selected date.
///<br/>interval-number	default-
///<br/><br/>
///Allows the user to show or hide the meridian with time in DateTimePicker.
///<br/>showMeridian-boolean	default-
///<br/><br/>
///After choosing the time, the popup will close automatically if we set it as true, otherwise we focus out the DateTimePicker or choose timeNow button for closing the popup.
///<br/>autoClose-boolean	default-
///<br/><br/>
///Defines the width of the time dropdown inside the DateTimePicker popup.
///<br/>timePopupWidth-string|number	default-100
///<br/><br/>
///Set the jQuery validation error message in DateTimePicker.
///<br/>validationMessage-any	default-null
///<br/><br/>
///Set the jQuery validation rules in DateTimePicker.
///<br/>validationRules-any	default-null
///<br/><br/>
///Sets the DateTime value to the control.
///<br/>value-string|Date	default-
///<br/><br/>
///Specifies the water mark text to be displayed in input text.
///<br/>watermarkText-string	default-Select date and time
///<br/><br/>
///Defines the width of the DateTimePicker textbox.
///<br/>width-string|number	default-143
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Diagram:function(){
 /// <signature>
 /// <summary>Constructor of ej.Diagram</summary>
 /// </signature>
}
});
ej.Diagram=(function(){
var original=ej.Diagram
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

add:function(node){
/// <signature>
/// <summary>
/// Add nodes and connectors to diagram at runtime
/// </summary>
/// <param name="node"	type="any">a JSON to define a node/connector or an array of nodes and connector</param>
/// </signature>
},
addLabel:function(nodeName, newLabel){
/// <signature>
/// <summary>
/// Add a label to a node at runtime
/// </summary>
/// <param name="nodeName"	type="string">name of the node to which label will be added</param>
/// </signature>
/// <signature>
/// <summary>
/// Add a label to a node at runtime
/// </summary>
/// <param name="newLabel"	type="any">JSON for the new label to be added</param>
/// </signature>
},
addLane:function(lane, index){
/// <signature>
/// <summary>
/// Add dynamic Lanes to swimlane at runtime
/// </summary>
/// <param name="lane"	type="any">JSON for the new lane to be added</param>
/// </signature>
/// <signature>
/// <summary>
/// Add dynamic Lanes to swimlane at runtime
/// </summary>
/// <param name="index"	type="number">Index value to add the lane in swimlane</param>
/// </signature>
},
addPhase:function(name, options){
/// <signature>
/// <summary>
/// Add a phase to a swimlane at runtime
/// </summary>
/// <param name="name"	type="string">name of the swimlane to which the phase will be added</param>
/// </signature>
/// <signature>
/// <summary>
/// Add a phase to a swimlane at runtime
/// </summary>
/// <param name="options"	type="any">JSON object to define the phase to be added</param>
/// </signature>
},
addLayers:function(layers){
/// <signature>
/// <summary>
/// Add a collection of layers can be added to the existing diagram layer at runtime.
/// </summary>
/// <param name="layers"	type="any[]">a collection of layers to be added to the existing diagram layers.</param>
/// </signature>
},
addNodeToLayer:function(layerName, nodes){
/// <signature>
/// <summary>
/// Add a collection of diagram elements can be added to the specific diagram layer.
/// </summary>
/// <param name="layerName"	type="string">specifies the name of the layer to the nodes will be added.</param>
/// </signature>
/// <signature>
/// <summary>
/// Add a collection of diagram elements can be added to the specific diagram layer.
/// </summary>
/// <param name="nodes"	type="any[]">collection of diagram elements to be added to the specific layer.</param>
/// </signature>
},
addPorts:function(name, ports){
/// <signature>
/// <summary>
/// Add a collection of ports to the node specified by name
/// </summary>
/// <param name="name"	type="string">name of the node to which the ports have to be added</param>
/// </signature>
/// <signature>
/// <summary>
/// Add a collection of ports to the node specified by name
/// </summary>
/// <param name="ports"	type="any[]">a collection of ports to be added to the specified node</param>
/// </signature>
},
addSelection:function(node, clearSelection){
/// <signature>
/// <summary>
/// Add the specified node to selection list
/// </summary>
/// <param name="node"	type="any">the node to be selected</param>
/// </signature>
/// <signature>
/// <summary>
/// Add the specified node to selection list
/// </summary>
/// <param name="clearSelection"	type="boolean">to define whether to clear the existing selection or not</param>
/// </signature>
},
align:function(direction){
/// <signature>
/// <summary>
/// Align the selected objects based on the reference object and direction
/// </summary>
/// <param name="direction"	type="string">to specify the direction towards which the selected objects are to be aligned("left","right",top","bottom")</param>
/// </signature>
},
bringIntoView:function(rect){
/// <signature>
/// <summary>
/// Bring the specified portion of the diagram content to the diagram viewport
/// </summary>
/// <param name="rect"	type="any">the rectangular region that is to be brought into diagram viewport</param>
/// </signature>
},
bringToCenter:function(rect){
/// <signature>
/// <summary>
/// Bring the specified portion of the diagram content to the center of the diagram viewport
/// </summary>
/// <param name="rect"	type="any">the rectangular region that is to be brought to the center of diagram viewport</param>
/// </signature>
},
bringToFront:function(){
/// <signature>
/// <summary>
/// Visually move the selected object over all other intersected objects
/// </summary>
},
clear:function(){
/// <signature>
/// <summary>
/// Remove all the elements from diagram
/// </summary>
},
clearHistory:function(){
/// <signature>
/// <summary>
/// Clears the actions which is recorded to perform undo/redo operation in the diagram.
/// </summary>
},
clearSelection:function(){
/// <signature>
/// <summary>
/// Remove the current selection in diagram
/// </summary>
},
copy:function(){
/// <signature>
/// <summary>
/// Copy the selected object to internal clipboard and get the copied object
/// </summary>
},
cut:function(){
/// <signature>
/// <summary>
/// Cut the selected object from diagram to diagram internal clipboard
/// </summary>
},
exportDiagram:function(options){
/// <signature>
/// <summary>
/// Export the diagram as downloadable files or as data
/// </summary>
/// <param name="options"	type="Diagram.Options">options to export the desired region of diagram to the desired formats.</param>
/// </signature>
},
exportImage:function(image, exportImageSettings){
/// <signature>
/// <summary>
/// The exportImage method is used to export the image passed through argument with different image format and exporting options as like exportDiagram method.
/// </summary>
/// <param name="image"	type="string">pass the base64String image to be exported.</param>
/// </signature>
/// <signature>
/// <summary>
/// The exportImage method is used to export the image passed through argument with different image format and exporting options as like exportDiagram method.
/// </summary>
/// <param name="exportImageSettings"	type="Diagram.ExportImageSettings">options to export the desired region of diagram to the desired formats.</param>
/// </signature>
},
findNode:function(name){
/// <signature>
/// <summary>
/// Read a node/connector object by its name
/// </summary>
/// <param name="name"	type="string">name of the node/connector that is to be identified</param>
/// </signature>
},
fitToPage:function(mode, region, margin){
/// <signature>
/// <summary>
/// Fit the diagram content into diagram viewport
/// </summary>
/// <param name="mode"	type="ej.datavisualization.Diagram.FitMode">to set the mode of fit to command.</param>
/// </signature>
/// <signature>
/// <summary>
/// Fit the diagram content into diagram viewport
/// </summary>
/// <param name="region"	type="ej.datavisualization.Diagram.Region">to set whether the region to be fit will be based on diagram elements or page settings.</param>
/// </signature>
/// <signature>
/// <summary>
/// Fit the diagram content into diagram viewport
/// </summary>
/// <param name="margin"	type="any">to set the required margin</param>
/// </signature>
},
getDiagramContent:function(styleSheets){
/// <signature>
/// <summary>
/// Get the diagram DOM element as a string along with dependent stylesheets.
/// </summary>
/// <param name="styleSheets"	type="any[]">If its specified, will get the diagram DOM element along with specified stylesheet references. Please note that you have to define absolute path for local CSS file. If not specified, will get the diagram content along with all stylesheets loaded in the document.</param>
/// </signature>
},
getDiagramBounds:function(){
/// <signature>
/// <summary>
/// Get the bounds of the diagram.
/// </summary>
},
group:function(){
/// <signature>
/// <summary>
/// Group the selected nodes and connectors
/// </summary>
},
insertLabel:function(name, label, index){
/// <signature>
/// <summary>
/// Insert a label into a node's label collection at runtime
/// </summary>
/// <param name="name"	type="string">name of the node to which the label has to be inserted</param>
/// </signature>
/// <signature>
/// <summary>
/// Insert a label into a node's label collection at runtime
/// </summary>
/// <param name="label"	type="any">JSON to define the new label</param>
/// </signature>
/// <signature>
/// <summary>
/// Insert a label into a node's label collection at runtime
/// </summary>
/// <param name="index"	type="number">index to insert the label into the node</param>
/// </signature>
},
layout:function(){
/// <signature>
/// <summary>
/// Refresh the diagram with the specified layout
/// </summary>
},
load:function(data){
/// <signature>
/// <summary>
/// Load the diagram
/// </summary>
/// <param name="data"	type="any">JSON data to load the diagram</param>
/// </signature>
},
moveForward:function(){
/// <signature>
/// <summary>
/// Visually move the selected object over its closest intersected object
/// </summary>
},
nudge:function(direction, delta){
/// <signature>
/// <summary>
/// Move the selected objects by either one pixel or by the pixels specified through argument
/// </summary>
/// <param name="direction"	type="string">specifies the direction to move the selected objects ("left","right",top","bottom")</param>
/// </signature>
/// <signature>
/// <summary>
/// Move the selected objects by either one pixel or by the pixels specified through argument
/// </summary>
/// <param name="delta"	type="number">specifies the number of pixels by which the selected objects have to be moved</param>
/// </signature>
},
paste:function(object, rename){
/// <signature>
/// <summary>
/// Paste the selected object from internal clipboard to diagram
/// </summary>
/// <param name="object"	type="any">object to be added to diagram</param>
/// </signature>
/// <signature>
/// <summary>
/// Paste the selected object from internal clipboard to diagram
/// </summary>
/// <param name="rename"	type="boolean">to define whether the specified object is to be renamed or not</param>
/// </signature>
},
print:function(printSettings){
/// <signature>
/// <summary>
/// Print the diagram as image
/// </summary>
/// <param name="printSettings"	type="Diagram.PrintSettings">options to print the desired region of diagram and print the diagram in multiple pages.</param>
/// </signature>
},
printImage:function(image, printImageSettings){
/// <signature>
/// <summary>
/// The printImage method is used to print the image passed through argument with desired region and multiple pages as like print method.
/// </summary>
/// <param name="image"	type="string">pass the base64String image to be printed.</param>
/// </signature>
/// <signature>
/// <summary>
/// The printImage method is used to print the image passed through argument with desired region and multiple pages as like print method.
/// </summary>
/// <param name="printImageSettings"	type="Diagram.PrintImageSettings">options to export the desired region of diagram to the desired formats.</param>
/// </signature>
},
redo:function(){
/// <signature>
/// <summary>
/// Restore the last action that was reverted
/// </summary>
},
refresh:function(){
/// <signature>
/// <summary>
/// Refresh the diagram at runtime
/// </summary>
},
remove:function(node){
/// <signature>
/// <summary>
/// Remove either the given node/connector or the selected element from diagram
/// </summary>
/// <param name="node"	type="any">the node/connector to be removed from diagram</param>
/// </signature>
},
removeLayers:function(layers){
/// <signature>
/// <summary>
/// Remove the collection of layers from the diagram layers.
/// </summary>
/// <param name="layers"	type="any[]">collection of layers to be removed from diagram layer.</param>
/// </signature>
},
removeNodeToLayer:function(layerName, nodes){
/// <signature>
/// <summary>
/// Remove the collection of nodes from the specific layer.
/// </summary>
/// <param name="layerName"	type="string">Specifies the layer name to the node will be removed.</param>
/// </signature>
/// <signature>
/// <summary>
/// Remove the collection of nodes from the specific layer.
/// </summary>
/// <param name="nodes"	type="any[]">collection of diagram elements name to be removed from specific layer.</param>
/// </signature>
},
removePorts:function(name, ports){
/// <signature>
/// <summary>
/// Remove the collection of ports from the specified node.
/// </summary>
/// <param name="name"	type="string">name of the node to which the ports have to be added</param>
/// </signature>
/// <signature>
/// <summary>
/// Remove the collection of ports from the specified node.
/// </summary>
/// <param name="ports"	type="any[]">a collection of ports to be deleted from the specified node</param>
/// </signature>
},
removeLabels:function(name, labels){
/// <signature>
/// <summary>
/// Add a collection of ports to the node specified by name
/// </summary>
/// <param name="name"	type="string">name of the node to which the ports have to be added</param>
/// </signature>
/// <signature>
/// <summary>
/// Add a collection of ports to the node specified by name
/// </summary>
/// <param name="labels"	type="any[]">a collection of labels to be deleted from the specified node</param>
/// </signature>
},
removeSelection:function(node){
/// <signature>
/// <summary>
/// Remove a particular object from selection list
/// </summary>
/// <param name="node"	type="any">the node/connector to be removed from selection list</param>
/// </signature>
},
sameHeight:function(){
/// <signature>
/// <summary>
/// Scale the selected objects to the height of the first selected object
/// </summary>
},
sameSize:function(){
/// <signature>
/// <summary>
/// Scale the selected objects to the size of the first selected object
/// </summary>
},
sameWidth:function(){
/// <signature>
/// <summary>
/// Scale the selected objects to the width of the first selected object
/// </summary>
},
save:function(){
/// <signature>
/// <summary>
/// Returns the diagram as serialized JSON
/// </summary>
},
scrollToNode:function(node){
/// <signature>
/// <summary>
/// Bring the node into view
/// </summary>
/// <param name="node"	type="any">the node/connector to be brought into view</param>
/// </signature>
},
selectAll:function(){
/// <signature>
/// <summary>
/// Select all nodes and connector in diagram
/// </summary>
},
sendBackward:function(){
/// <signature>
/// <summary>
/// Visually move the selected object behind its closest intersected object
/// </summary>
},
sendToBack:function(){
/// <signature>
/// <summary>
/// Visually move the selected object behind all other intersected objects
/// </summary>
},
spaceAcross:function(){
/// <signature>
/// <summary>
/// Update the horizontal space between the selected objects as equal and within the selection boundary
/// </summary>
},
spaceDown:function(){
/// <signature>
/// <summary>
/// Update the vertical space between the selected objects as equal and within the selection boundary
/// </summary>
},
startLabelEdit:function(node, label){
/// <signature>
/// <summary>
/// Move the specified label to edit mode
/// </summary>
/// <param name="node"	type="any">node/connector that contains the label to be edited</param>
/// </signature>
/// <signature>
/// <summary>
/// Move the specified label to edit mode
/// </summary>
/// <param name="label"	type="any">to be edited</param>
/// </signature>
},
undo:function(){
/// <signature>
/// <summary>
/// Reverse the last action that was performed
/// </summary>
},
ungroup:function(){
/// <signature>
/// <summary>
/// Ungroup the selected group
/// </summary>
},
update:function(options){
/// <signature>
/// <summary>
/// Update diagram at runtime
/// </summary>
/// <param name="options"	type="any">JSON to specify the diagram properties that have to be modified</param>
/// </signature>
},
updateConnector:function(name, options){
/// <signature>
/// <summary>
/// Update Connectors at runtime
/// </summary>
/// <param name="name"	type="string">name of the connector to be updated</param>
/// </signature>
/// <signature>
/// <summary>
/// Update Connectors at runtime
/// </summary>
/// <param name="options"	type="any">JSON to specify the connector properties that have to be updated</param>
/// </signature>
},
updateLabel:function(nodeName, label, options){
/// <signature>
/// <summary>
/// Update the given label at runtime
/// </summary>
/// <param name="nodeName"	type="string">the name of node/connector which contains the label to be updated</param>
/// </signature>
/// <signature>
/// <summary>
/// Update the given label at runtime
/// </summary>
/// <param name="label"	type="any">the label to be modified</param>
/// </signature>
/// <signature>
/// <summary>
/// Update the given label at runtime
/// </summary>
/// <param name="options"	type="any">JSON to specify the label properties that have to be updated</param>
/// </signature>
},
updateLayer:function(layerName, options){
/// <signature>
/// <summary>
/// Update the given layer at run time.
/// </summary>
/// <param name="layerName"	type="string">the name of layer to be updated</param>
/// </signature>
/// <signature>
/// <summary>
/// Update the given layer at run time.
/// </summary>
/// <param name="options"	type="any">the layer object to be modified</param>
/// </signature>
},
updateNode:function(name, options){
/// <signature>
/// <summary>
/// Update nodes at runtime
/// </summary>
/// <param name="name"	type="string">name of the node that is to be updated</param>
/// </signature>
/// <signature>
/// <summary>
/// Update nodes at runtime
/// </summary>
/// <param name="options"	type="any">JSON to specify the properties of node that have to be updated</param>
/// </signature>
},
updatePort:function(nodeName, port, options){
/// <signature>
/// <summary>
/// Update a port with its modified properties at runtime
/// </summary>
/// <param name="nodeName"	type="string">the name of node which contains the port to be updated</param>
/// </signature>
/// <signature>
/// <summary>
/// Update a port with its modified properties at runtime
/// </summary>
/// <param name="port"	type="any">the port to be updated</param>
/// </signature>
/// <signature>
/// <summary>
/// Update a port with its modified properties at runtime
/// </summary>
/// <param name="options"	type="any">JSON to specify the properties of the port that have to be updated</param>
/// </signature>
},
updateSelectedObject:function(name){
/// <signature>
/// <summary>
/// Update the specified node as selected object
/// </summary>
/// <param name="name"	type="string">name of the node to be updated as selected object</param>
/// </signature>
},
updateSelection:function(showUserHandles){
/// <signature>
/// <summary>
/// Update the selection at runtime
/// </summary>
/// <param name="showUserHandles"	type="boolean">to specify whether to show the user handles or not</param>
/// </signature>
},
updateUserHandles:function(node){
/// <signature>
/// <summary>
/// Update user handles with respect to the given node
/// </summary>
/// <param name="node"	type="any">node/connector with respect to which, the user handles have to be updated</param>
/// </signature>
},
updateViewPort:function(){
/// <signature>
/// <summary>
/// Update the diagram viewport at runtime
/// </summary>
},
upgrade:function(data){
/// <signature>
/// <summary>
/// Upgrade the diagram from old version
/// </summary>
/// <param name="data"	type="any">to be upgraded</param>
/// </signature>
},
zoomTo:function(Zoom){
/// <signature>
/// <summary>
/// Used to zoomIn/zoomOut diagram
/// </summary>
/// <param name="Zoom"	type="Diagram.Zoom">options to zoom the diagram(zoom factor, zoomIn/zoomOut)                </param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDiagram=function(){
this.data("ejDiagram",new	ej.Diagram());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDiagram :function (options) {
/// <signature>
/// <summary><br/>
///The diagram control provides 2D surface to visualize the data as shapes, lines, text and images. It can be configured to DOM element such as DIV.<br/><br/>
///Defines the background color of diagram elements
///<br/>backgroundColor-string	default-transparent
///<br/><br/>
///Defines the path of the background image of diagram elements
///<br/>backgroundImage-string	default-
///<br/><br/>
///Defines how to align the background image over the diagram area.
///<br/>alignment-ej.datavisualization.Diagram.ImageAlignment |string	default-ej.datavisualization.Diagram.ImageAlignment.XMidYMid
///<br/><br/>
///Sets the direction of line bridges.
///<br/>bridgeDirection-ej.datavisualization.Diagram.BridgeDirection|string	default-ej.datavisualization.Diagram.BridgeDirection.Top
///<br/><br/>
///Defines a set of custom commands and binds them with a set of desired key gestures.
///<br/>commandManager-CommandManager	default-
///<br/><br/>
///An object that maps a set of command names with the corresponding command objects
///<br/>commands-any	default-{}
///<br/><br/>
///A method that defines whether the command is executable at the moment or not.
///<br/>canExecute-Function	default-
///<br/><br/>
///A method that defines what to be executed when the key combination is recognized.
///<br/>execute-Function	default-
///<br/><br/>
///Defines a combination of keys and key modifiers, on recognition of which the command will be executed
///<br/>gesture-any	default-
///<br/><br/>
///Sets the key value, on recognition of which the command will be executed.
///<br/>key-ej.datavisualization.Diagram.Keys|string	default-ej.datavisualization.Diagram.Keys.None
///<br/><br/>
///Sets a combination of key modifiers, on recognition of which the command will be executed.
///<br/>keyModifiers-ej.datavisualization.Diagram.KeyModifiers|string	default-ej.datavisualization.Diagram.KeyModifiers.None
///<br/><br/>
///Defines any additional parameters that are required at runtime
///<br/>parameter-any	default-null
///<br/><br/>
///A collection of JSON objects where each object represents a connector
///<br/>connectors-Array&lt;Connectors&gt;	default-[]
///<br/><br/>
///To maintain additional information about connectors
///<br/>addInfo-any	default-null
///<br/><br/>
///Defines the width of the line bridges
///<br/>bridgeSpace-number	default-10
///<br/><br/>
///Enables or disables the behaviors of connectors.
///<br/>constraints-ej.datavisualization.Diagram.ConnectorConstraints|string	default-ej.datavisualization.Diagram.ConnectorConstraints.Default
///<br/><br/>
///Defines the radius of the rounded corner
///<br/>cornerRadius-number	default-0
///<br/><br/>
///This property allows you to customize connectors appearance using user-defined CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Sets the horizontal alignment of the connector. Applicable, if the parent of the connector is a container.
///<br/>horizontalAlign-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Left
///<br/><br/>
///A collection of JSON objects where each object represents a label.
///<br/>labels-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines how the label should be aligned with respect to the segment
///<br/>alignment-ej.datavisualization.Diagram.Alignment|string	default-ej.datavisualization.Diagram.Alignment.Center
///<br/><br/>
///Enables/disables the bold style
///<br/>bold-boolean	default-false
///<br/><br/>
///Sets the border color of the label
///<br/>borderColor-string	default-transparent
///<br/><br/>
///Sets the border width of the label
///<br/>borderWidth-number	default-0
///<br/><br/>
///Defines whether the label should be aligned within the connector boundaries
///<br/>boundaryConstraints-boolean	default-true
///<br/><br/>
///Enables or disables the default behaviors of the label.
///<br/>constraints-ej.datavisualization.Diagram.LabelConstraints|string	default-ej.datavisualization.Diagram.LabelConstraints.None
///<br/><br/>
///Sets the fill color of the text area
///<br/>fillColor-string	default-transparent
///<br/><br/>
///Sets the font color of the text
///<br/>fontColor-string	default-black
///<br/><br/>
///Sets the font family of the text
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Defines the font size of the text
///<br/>fontSize-number	default-12
///<br/><br/>
///Sets the height of the label(the maximum value of label height and the connector height will be considered as label height)
///<br/>height-number	default-0
///<br/><br/>
///Sets the horizontal alignment of the label.
///<br/>horizontalAlignment-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Center
///<br/><br/>
///Sets the hyperlink for the labels in the connectors.
///<br/>hyperlink-string	default-none
///<br/><br/>
///Enables/disables the italic style
///<br/>italic-boolean	default-false
///<br/><br/>
///Gets whether the label is currently being edited or not.
///<br/>mode-ej.datavisualization.Diagram.LabelEditMode|string	default-ej.datavisualization.Diagram.LabelEditMode.Edit
///<br/><br/>
///Sets the unique identifier of the label
///<br/>name-string	default-
///<br/><br/>
///Sets the fraction/ratio(relative to connector) that defines the position of the label
///<br/>offset-any	default-ej.datavisualization.Diagram.Point(0.5, 0.5)
///<br/><br/>
///Sets the fraction/ratio(relative to connector) that defines the position of the label
///<br/>margin-any	default-ej.datavisualization.Diagram.Point(0.5, 0.5)
///<br/><br/>
///To set the margin of the label in right direction
///<br/>right-number	default-0
///<br/><br/>
///To set the margin of the label in left direction
///<br/>left-number	default-0
///<br/><br/>
///To set the margin of the label in top direction
///<br/>top-number	default-0
///<br/><br/>
///To set the margin of the label in bottom direction
///<br/>bottom-number	default-0
///<br/><br/>
///Sets the padding for connector label.
///<br/>padding-any	default-ej.datavisualization.Diagram.Point(0.5, 0.5)
///<br/><br/>
///Sets the value which is used to drag the label within certain bounds.
///<br/>dragLimit-any	default-null
///<br/><br/>
///To set the drag limit of the label in right direction
///<br/>right-number	default-10
///<br/><br/>
///To set the drag limit of the label in left direction
///<br/>left-number	default-10
///<br/><br/>
///To set the drag limit of the label in top direction
///<br/>top-number	default-10
///<br/><br/>
///To set the drag limit of the label in bottom direction
///<br/>bottom-number	default-10
///<br/><br/>
///Defines the transparency of labels
///<br/>opacity-number	default-1
///<br/><br/>
///Defines whether the label is editable or not
///<br/>readOnly-boolean	default-false
///<br/><br/>
///Defines whether the label should be positioned whether relative to segments or connector boundaries
///<br/>relativeMode-ej.datavisualization.Diagram.LabelRelativeMode|string	default-ej.datavisualization.Diagram.LabelRelativeMode.SegmentPath
///<br/><br/>
///Defines the angle to which the label needs to be rotated
///<br/>rotateAngle-number	default-0
///<br/><br/>
///Sets the position of the label with respect to the total segment length
///<br/>segmentOffset-string	default-0.5
///<br/><br/>
///Defines the label text
///<br/>text-string	default-
///<br/><br/>
///Defines how to align the text inside the label.
///<br/>textAlign-ej.datavisualization.Diagram.TextAlign|string	default-ej.datavisualization.Diagram.TextAlign.Center
///<br/><br/>
///Sets how to decorate the label text.
///<br/>textDecoration-ej.datavisualization.Diagram.TextDecorations|string	default-ej.datavisualization.Diagram.TextDecorations.None
///<br/><br/>
///Sets the vertical alignment of the label.
///<br/>verticalAlignment-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Center
///<br/><br/>
///Enables or disables the visibility of the label
///<br/>visible-boolean	default-true
///<br/><br/>
///Sets the width of the label(the maximum value of label width and the connector width will be considered as label width)
///<br/>width-number	default-50
///<br/><br/>
///Defines how the label text needs to be wrapped.
///<br/>wrapping-ej.datavisualization.Diagram.TextWrapping|string	default-ej.datavisualization.Diagram.TextWrapping.WrapWithOverflow
///<br/><br/>
///Sets the stroke color of the connector
///<br/>lineColor-string	default-black
///<br/><br/>
///Sets the pattern of dashes and gaps used to stroke the path of the connector
///<br/>lineDashArray-string	default-
///<br/><br/>
///Defines the padding value to ease the interaction with connectors
///<br/>lineHitPadding-number	default-10
///<br/><br/>
///Sets the width of the line
///<br/>lineWidth-number	default-1
///<br/><br/>
///Defines the minimum space to be left between the bottom of parent bounds and the connector. Applicable, if the parent is a container.
///<br/>marginBottom-number	default-0
///<br/><br/>
///Defines the minimum space to be left between the left of parent bounds and the connector. Applicable, if the parent is a container.
///<br/>marginLeft-number	default-0
///<br/><br/>
///Defines the minimum space to be left between the right of parent bounds and the connector. Applicable, if the parent is a container.
///<br/>marginRight-number	default-0
///<br/><br/>
///Defines the minimum space to be left between the top of parent bounds and the connector. Applicable, if the parent is a container.
///<br/>marginTop-number	default-0
///<br/><br/>
///Sets a unique name for the connector
///<br/>name-string	default-
///<br/><br/>
///Defines the transparency of the connector
///<br/>opacity-number	default-1
///<br/><br/>
///Defines the size and preview size of the node to add that to symbol palette. To explore palette item, refer Palette Item
///<br/>paletteItem-any	default-null
///<br/><br/>
///Sets the parent name of the connector.
///<br/>parent-string	default-
///<br/><br/>
///An array of JSON objects where each object represents a segment
///<br/>segments-Array&lt;any&gt;	default-[ { type:straight } ]
///<br/><br/>
///Sets the direction of orthogonal segment
///<br/>direction-string	default-
///<br/><br/>
///Describes the length of orthogonal segment
///<br/>length-number	default-undefined
///<br/><br/>
///Describes the end point of bezier/straight segment
///<br/>point-ej.datavisualization.Diagram.ConnectorsSourcePoint	default-Diagram.Point()
///<br/><br/>
///Defines the first control point of the bezier segment
///<br/>point1-ej.datavisualization.Diagram.ConnectorsSourcePoint	default-null
///<br/><br/>
///Defines the second control point of bezier segment
///<br/>point2-ej.datavisualization.Diagram.ConnectorsSourcePoint	default-null
///<br/><br/>
///Sets the type of the segment.
///<br/>type-ej.datavisualization.Diagram.Segments|string	default-ej.datavisualization.Diagram.Segments.Straight
///<br/><br/>
///Describes the length and angle between the first control point and the start point of bezier segment
///<br/>vector1-any	default-null
///<br/><br/>
///Describes the length and angle between the second control point and end point of bezier segment
///<br/>vector2-any	default-null
///<br/><br/>
///Defines the role/meaning of the connector
///<br/>shape-any	default-null
///<br/><br/>
///Sets the type of the connector
///<br/>type-ej.datavisualization.Diagram.ConnectorShapes|string	default-ej.datavisualization.Diagram.ConnectorShapes.BPMN
///<br/><br/>
///Sets the type of the flow in a BPMN Process
///<br/>flow-ej.datavisualization.Diagram.BPMNFlows|string	default-ej.datavisualization.Diagram.BPMNFlows.Sequence
///<br/><br/>
///Sets the type of the Association in a BPMN Process
///<br/>association-ej.datavisualization.Diagram.AssociationFlows|string	default-ej.datavisualization.Diagram.AssociationFlows.Default
///<br/><br/>
///Sets the type of the message flow. Applicable, if the connector is of type "BPMN"
///<br/>message-ej.datavisualization.Diagram.BPMNMessageFlows|string	default-ej.datavisualization.Diagram.BPMNMessageFlows.Default
///<br/><br/>
///Sets the type of BPMN sequence flow
///<br/>sequence-ej.datavisualization.Diagram.BPMNSequenceFlows|string	default-ej.datavisualization.Diagram.BPMNSequenceFlows.Normal
///<br/><br/>
///Defines the role of the connector in a UML Class Diagram. Applicable, if the type of the connector is "classifier".
///<br/>relationship-ej.datavisualization.Diagram.ClassifierShapes|string	default-ej.datavisualization.Diagram.ClassifierShapes.Association
///<br/><br/>
///Defines the multiplicity option of the connector
///<br/>multiplicity-any	default-null
///<br/><br/>
///Sets the type of the multiplicity. Applicable, if the connector is of type "classifier"
///<br/>type-ej.datavisualization.Diagram.Multiplicity|string	default-ej.datavisualization.Diagram.Multiplicity.OneToOne
///<br/><br/>
///Defines the source label to connector. Applicable, if the connector is of type "UML"
///<br/>source-any	default-
///<br/><br/>
///Defines the source label to connector. Applicable, if the connector is of type "UML"
///<br/>optional-boolean	default-true
///<br/><br/>
///Defines the source label to connector. Applicable, if the connector is of type "UML"
///<br/>lowerBounds-number	default-null
///<br/><br/>
///Defines the source label to connector. Applicable, if the connector is of type "UML"
///<br/>upperBounds-number	default-null
///<br/><br/>
///Defines the target label to connector. Applicable, if the connector is of type "UML"
///<br/>target-ej.datavisualization.Diagram.ConnectorsShapeMultiplicitySource	default-true
///<br/><br/>
///Defines the shape of UMLActivity to connector. Applicable, if the connector is of type UMLActivity
///<br/>ActivityFlow-ej.datavisualization.Diagram.UMLActivityFlow|string	default-ej.datavisualization.Diagram.UMLActivityFlow.Control
///<br/><br/>
///Defines the source decorator of the connector
///<br/>sourceDecorator-any	default-{ shape:arrow, width: 8, height:8, borderColor:black, fillColor:black }
///<br/><br/>
///Sets the border color of the source decorator
///<br/>borderColor-string	default-black
///<br/><br/>
///Sets the border width of the decorator
///<br/>borderWidth-number	default-1
///<br/><br/>
///This property allows you to customize sourceDecorator appearance using user-defined CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Sets the fill color of the source decorator
///<br/>fillColor-string	default-black
///<br/><br/>
///Sets the height of the source decorator
///<br/>height-number	default-8
///<br/><br/>
///Defines the custom shape of the source decorator
///<br/>pathData-string	default-
///<br/><br/>
///Defines the shape of the source decorator.
///<br/>shape-ej.datavisualization.Diagram.DecoratorShapes|string	default-ej.datavisualization.Diagram.DecoratorShapes.Arrow
///<br/><br/>
///Defines the width of the source decorator
///<br/>width-number	default-8
///<br/><br/>
///Sets the source node of the connector
///<br/>sourceNode-string	default-
///<br/><br/>
///Defines the space to be left between the source node and the source point of a connector
///<br/>sourcePadding-number	default-0
///<br/><br/>
///Describes the start point of the connector
///<br/>sourcePoint-any	default-ej.datavisualization.Diagram.Point()
///<br/><br/>
///Defines the x-coordinate of a position
///<br/>x-number	default-0
///<br/><br/>
///Defines the y-coordinate of a position
///<br/>y-number	default-0
///<br/><br/>
///Sets the source port of the connector
///<br/>sourcePort-string	default-
///<br/><br/>
///Defines the target decorator of the connector
///<br/>targetDecorator-any	default-{ shape:arrow, width: 8, height:8, borderColor:black, fillColor:black }
///<br/><br/>
///Sets the border color of the decorator
///<br/>borderColor-string	default-black
///<br/><br/>
///This property allows you to customize targetDecorator appearance using user-defined CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Sets the color with which the decorator will be filled
///<br/>fillColor-string	default-black
///<br/><br/>
///Defines the height of the target decorator
///<br/>height-number	default-8
///<br/><br/>
///Defines the custom shape of the target decorator
///<br/>pathData-string	default-
///<br/><br/>
///Defines the shape of the target decorator.
///<br/>shape-ej.datavisualization.Diagram.DecoratorShapes|string	default-ej.datavisualization.Diagram.DecoratorShapes.Arrow
///<br/><br/>
///Defines the width of the target decorator
///<br/>width-number	default-8
///<br/><br/>
///Sets the target node of the connector
///<br/>targetNode-string	default-
///<br/><br/>
///Defines the space to be left between the target node and the target point of the connector
///<br/>targetPadding-number	default-0
///<br/><br/>
///Describes the end point of the connector
///<br/>targetPoint-ej.datavisualization.Diagram.ConnectorsSourcePoint	default-ej.datavisualization.Diagram.Point()
///<br/><br/>
///Sets the targetPort of the connector
///<br/>targetPort-string	default-
///<br/><br/>
///Defines the tooltip that should be shown when the mouse hovers over connector. For tooltip properties, refer Tooltip
///<br/>tooltip-any	default-null
///<br/><br/>
///To set the vertical alignment of connector (Applicable,if the parent is group).
///<br/>verticalAlign-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Top
///<br/><br/>
///Enables or disables the visibility of connector
///<br/>visible-boolean	default-true
///<br/><br/>
///Sets the z-index of the connector
///<br/>zOrder-number	default-0
///<br/><br/>
///Binds the custom JSON data with connector properties
///<br/>connectorTemplate-any	default-null
///<br/><br/>
///Enables/Disables the default behaviors of the diagram.
///<br/>constraints-ej.datavisualization.Diagram.DiagramConstraints|string	default-ej.datavisualization.Diagram.DiagramConstraints.All
///<br/><br/>
///An object to customize the context menu of diagram
///<br/>contextMenu-ContextMenu	default-
///<br/><br/>
///Defines the collection of context menu items
///<br/>items-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the text for the collection of context menu item
///<br/>text-string	default-null
///<br/><br/>
///Defines the name for the collection of context menu items
///<br/>name-string	default-null
///<br/><br/>
///Defines the image url for the collection of context menu items
///<br/>imageUrl-string	default-null
///<br/><br/>
///Defines the CssClass for the collection of context menu items
///<br/>cssClass-string	default-null
///<br/><br/>
///Defines the collection of sub items for the context menu items
///<br/>subItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///To set whether to display the default context menu items or not
///<br/>showCustomMenuItemsOnly-boolean	default-false
///<br/><br/>
///Configures the data source that is to be bound with diagram
///<br/>dataSourceSettings-DataSourceSettings	default-
///<br/><br/>
///Defines the data source either as a collection of objects or as an instance of ej.DataManager
///<br/>dataSource-any	default-null
///<br/><br/>
///Sets the unique id of the data source items
///<br/>id-string	default-
///<br/><br/>
///Defines the parent id of the data source item
///<br/>parent-string	default-&#39;&#39;
///<br/><br/>
///Describes query to retrieve a set of data from the specified datasource
///<br/>query-string	default-null
///<br/><br/>
///Sets the unique id of the root data source item
///<br/>root-string	default-
///<br/><br/>
///Describes the name of the table on which the specified query has to be executed
///<br/>tableName-string	default-null
///<br/><br/>
///Specifies the method name which is used to get the updated data from client side to the server side
///<br/>crudAction-any	default-null
///<br/><br/>
///Specifies the create method which is used to get the nodes to be added from client side to the server side
///<br/>create-string	default-null
///<br/><br/>
///Specifies the update method which is used to get the updated data from client side to the server side
///<br/>update-string	default-null
///<br/><br/>
///Specifies the destroy method which is used to get the deleted items data from client side to the server side
///<br/>destroy-string	default-null
///<br/><br/>
///Specifies the read method to get the created nodes from client side to the server side
///<br/>read-string	default-null
///<br/><br/>
///Specifies the custom fields to get the updated data from client side to the server side
///<br/>customFields-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the data source either as a collection of objects or as an instance of ej.DataManager
///<br/>connectionDataSource-any	default-null
///<br/><br/>
///Sets the datasource for the connection datasource settings items.
///<br/>dataSource-string	default-null
///<br/><br/>
///Sets the unique id of the connection data source item
///<br/>id-string	default-null
///<br/><br/>
///Sets the source node of the connection data source item
///<br/>sourceNode-string	default-null
///<br/><br/>
///Sets the target node of the connection data source item
///<br/>targetNode-string	default-null
///<br/><br/>
///Sets the sourcePointX value of the connection data source item
///<br/>sourcePointX-string	default-null
///<br/><br/>
///Sets the sourcePointY value of the connection data source item
///<br/>sourcePointY-string	default-null
///<br/><br/>
///Sets the targetPoint-x value of the connection data source item
///<br/>targetPointX-string	default-null
///<br/><br/>
///Sets the targetPoint-y value of the connection data source item
///<br/>targetPointY-string	default-null
///<br/><br/>
///Specifies the method name which is used to get updated connectors from client side to the server side
///<br/>crudAction-any	default-null
///<br/><br/>
///Specifies the create method which is used to get the connectors to be added from client side to the server side
///<br/>create-string	default-null
///<br/><br/>
///Specifies the update method which is used to get the updated connectors from client side to the server side
///<br/>update-string	default-null
///<br/><br/>
///Specifies the destroy method which is used to get the deleted items data from client side to the server side
///<br/>destroy-string	default-null
///<br/><br/>
///Specifies the read method which is used to get the data from client side to the server side
///<br/>read-string	default-null
///<br/><br/>
///Specifies the custom fields to get the updated data from client side to the server side
///<br/>customFields-Array&lt;any&gt;	default-[]
///<br/><br/>
///Initializes the default values for nodes and connectors
///<br/>defaultSettings-DefaultSettings	default-{}
///<br/><br/>
///Initializes the default connector properties
///<br/>connector-any	default-null
///<br/><br/>
///Initializes the default properties of groups
///<br/>group-any	default-null
///<br/><br/>
///Initializes the default properties for nodes
///<br/>node-any	default-null
///<br/><br/>
///Sets the type of JSON object to be drawn through drawing tool
///<br/>drawType-any	default-{}
///<br/><br/>
///Enables or disables auto scroll in diagram
///<br/>enableAutoScroll-boolean	default-true
///<br/><br/>
///Enables or disables diagram context menu
///<br/>enableContextMenu-boolean	default-true
///<br/><br/>
///Specifies the height of the diagram
///<br/>height-string	default-null
///<br/><br/>
///Customizes the undo redo functionality
///<br/>historyManager-HistoryManager	default-
///<br/><br/>
///A method that takes a history entry as argument and returns whether the specific entry can be popped or not
///<br/>canPop-Function	default-
///<br/><br/>
///A method that ends grouping the changes
///<br/>closeGroupAction-Function	default-
///<br/><br/>
///A method that removes the history of a recent change made in diagram
///<br/>pop-Function	default-
///<br/><br/>
///A method that allows to track the custom changes made in diagram
///<br/>push-Function	default-
///<br/><br/>
///Defines what should be happened while trying to restore a custom change
///<br/>redo-Function	default-null
///<br/><br/>
///The redoStack property is used to get the number of redo actions to be stored on the history manager. Its an read-only property and the collection should not be modified.
///<br/>redoStack-Array&lt;any&gt;	default-[]
///<br/><br/>
///The stackLimit property used to restrict the undo and redo actions to a certain limit.
///<br/>stackLimit-number	default-null
///<br/><br/>
///A method that starts to group the changes to revert/restore them in a single undo or redo
///<br/>startGroupAction-Function	default-
///<br/><br/>
///Defines what should be happened while trying to revert a custom change
///<br/>undo-Function	default-
///<br/><br/>
///The undoStack property is used to get the number of undo actions to be stored on the history manager. Its an read-only property and the collection should not be modified.
///<br/>undoStack-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the type of the rendering mode of label.
///<br/>labelRenderingMode-ej.datavisualization.Diagram.LabelRenderingMode|string	default-HTML
///<br/><br/>
///Automatically arranges the nodes and connectors in a predefined manner.
///<br/>layout-Layout	default-
///<br/><br/>
///Specifies the custom bounds to arrange/align the layout
///<br/>bounds-any	default-ej.datavisualization.Diagram.Rectangle()
///<br/><br/>
///Defines the fixed node with reference to which, the layout will be arranged and fixed node will not be repositioned
///<br/>fixedNode-string	default-
///<br/><br/>
///Customizes the orientation of trees/sub trees. For orientations, see Chart Orientations. For chart types, see Chart Types
///<br/>getLayoutInfo-any	default-null
///<br/><br/>
///Defines a method to customize the segments based on source and target nodes.
///<br/>getConnectorSegments-any	default-null
///<br/><br/>
///Sets the space to be horizontally left between nodes
///<br/>horizontalSpacing-number	default-30
///<br/><br/>
///Defines the space to be left between layout bounds and layout.
///<br/>margin-any	default-ej.datavisualization.Diagram.Margin()
///<br/><br/>
///Defines how to horizontally align the layout within the layout bounds
///<br/>horizontalAlignment-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Center
///<br/><br/>
///Defines how to vertically align the layout within the layout bounds
///<br/>verticalAlignment-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Center
///<br/><br/>
///Sets the orientation/direction to arrange the diagram elements.
///<br/>orientation-ej.datavisualization.Diagram.LayoutOrientations|string	default-ej.datavisualization.Diagram.LayoutOrientations.TopToBottom
///<br/><br/>
///Sets the type of the layout based on which the elements will be arranged.
///<br/>type-ej.datavisualization.Diagram.LayoutTypes|string	default-ej.datavisualization.Diagram.LayoutTypes.None
///<br/><br/>
///Sets the space to be vertically left between nodes
///<br/>verticalSpacing-number	default-30
///<br/><br/>
///Sets the value is used to define the root node of the layout.
///<br/>root-string	default-30
///<br/><br/>
///Defines how long edges should be, ideally. This will be the resting length for the springs.
///<br/>springLength-number	default-100
///<br/><br/>
///Defines how long edges should be, ideally. This will be the resting length for the springs.
///<br/>springFactor-number	default-0.442
///<br/><br/>
///Defines how long edges should be, ideally. This will be the resting length for the springs.
///<br/>maxIteration-number	default-1000
///<br/><br/>
///Enable or disable connector's segment overlapping with each other when executing the layout with multiple parents.
///<br/>avoidSegmentOverlapping-boolean	default-false
///<br/><br/>
///Defines the current culture of diagram
///<br/>locale-string	default-en-US
///<br/><br/>
///Array of JSON objects where each object represents a node
///<br/>nodes-Array&lt;Nodes&gt;	default-[]
///<br/><br/>
///Defines the type of BPMN Activity. Applicable, if the node is a BPMN activity.
///<br/>activity-ej.datavisualization.Diagram.BPMNActivity|string	default-ej.datavisualization.Diagram.BPMNActivity.Task
///<br/><br/>
///To maintain additional information about nodes
///<br/>addInfo-any	default-{}
///<br/><br/>
///Defines the additional information of a process. It is not directly related to the message flows or sequence flows of the process.
///<br/>annotation-any	default-ej.datavisualization.Diagram.BPMNTextAnnotation()
///<br/><br/>
///Sets the angle between the BPMN shape and the annotation
///<br/>angle-number	default-0
///<br/><br/>
///Sets the direction of the text annotation
///<br/>direction-ej.datavisualization.Diagram.BPMNAnnotationDirection|string	default-ej.datavisualization.Diagram.BPMNAnnotationDirections.Left
///<br/><br/>
///Sets the height of the text annotation
///<br/>height-number	default-20
///<br/><br/>
///Sets the distance between the BPMN shape and the annotation
///<br/>length-number	default-0
///<br/><br/>
///Defines the additional information about the flow object in a BPMN Process
///<br/>text-string	default-
///<br/><br/>
///Sets the  width of the text annotation
///<br/>width-number	default-20
///<br/><br/>
///Sets the border color of node
///<br/>borderColor-string	default-black
///<br/><br/>
///Sets the pattern of dashes and gaps to stroke the border
///<br/>borderDashArray-string	default-
///<br/><br/>
///Sets the border width of the node
///<br/>borderWidth-number	default-1
///<br/><br/>
///Defines whether the group can be ungrouped or not
///<br/>canUngroup-boolean	default-true
///<br/><br/>
///Array of JSON objects where each object represents a child node/connector
///<br/>children-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the type of UML classifier. Applicable, if the node is a UML Class Diagram shape.
///<br/>classifier-ej.datavisualization.Diagram.ClassifierShapes|string	default-ej.datavisualization.Diagram.ClassifierShapes.Class
///<br/><br/>
///Defines the name, attributes and methods of a Class. Applicable, if the node is a Class.
///<br/>class-any	default-null
///<br/><br/>
///Sets the name of class.
///<br/>name-string	default-
///<br/><br/>
///Defines the collection of attributes
///<br/>attributes-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the name of the attribute
///<br/>name-string	default-
///<br/><br/>
///Sets the data type of attribute
///<br/>type-string	default-
///<br/><br/>
///Defines the visibility of the attribute
///<br/>scope-string	default-ej.datavisualization.Diagram.ScopeValueDefaults.Public
///<br/><br/>
///Defines the collection of methods of a Class.
///<br/>methods-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the visibility of the method.
///<br/>scope-string	default-ej.datavisualization.Diagram.ScopeValueDefaults.Public
///<br/><br/>
///Defines the state of the node is collapsed.
///<br/>collapseIcon-any	default-
///<br/><br/>
///Sets the border color for collapse icon of node
///<br/>borderColor-string	default-black
///<br/><br/>
///Sets the border width for collapse icon of node
///<br/>borderWidth-number	default-1
///<br/><br/>
///Sets the fill color for collapse icon of node
///<br/>fillColor-string	default-white
///<br/><br/>
///Defines the height for collapse icon of node
///<br/>height-number	default-15
///<br/><br/>
///Sets the horizontal alignment of the icon.
///<br/>horizontalAlignment-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Center
///<br/><br/>
///To set the margin for the collapse icon of node
///<br/>margin-any	default-ej.datavisualization.Diagram.Margin()
///<br/><br/>
///Sets the fraction/ratio(relative to node) that defines the position of the icon
///<br/>offset-any	default-ej.datavisualization.Diagram.Point(0.5, 1)
///<br/><br/>
///Defines the shape of the collapsed state of the node.
///<br/>shape-ej.datavisualization.Diagram.IconShapes|string	default-ej.datavisualization.Diagram.IconShapes.None
///<br/><br/>
///Sets the vertical alignment of the icon.
///<br/>verticalAlignment-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Center
///<br/><br/>
///Defines the distance to be left between a node and its connections(In coming and out going connections).
///<br/>connectorPadding-number	default-0
///<br/><br/>
///Enables or disables the default behaviors of the node.
///<br/>constraints-ej.datavisualization.Diagram.NodeConstraints|string	default-ej.datavisualization.Diagram.NodeConstraints.Default
///<br/><br/>
///Defines how the child objects need to be arranged(Either in any predefined manner or automatically). Applicable, if the node is a group.
///<br/>container-any	default-null
///<br/><br/>
///Defines the orientation of the container. Applicable, if the group is a container.
///<br/>orientation-string	default-vertical
///<br/><br/>
///Sets the type of the container. Applicable if the group is a container.
///<br/>type-ej.datavisualization.Diagram.ContainerType|string	default-ej.datavisualization.Diagram.ContainerType.Canvas
///<br/><br/>
///Defines the corner radius of rectangular shapes.
///<br/>cornerRadius-number	default-0
///<br/><br/>
///This property allows you to customize nodes appearance using user-defined CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Defines the BPMN data object
///<br/>data-any	default-
///<br/><br/>
///Sets the type of the BPMN Data object
///<br/>type-ej.datavisualization.Diagram.BPMNDataObjects|string	default-ej.datavisualization.Diagram.BPMNDataObjects.None
///<br/><br/>
///Defines whether the BPMN data object is a collection or not
///<br/>collection-boolean	default-false
///<br/><br/>
///Defines an Enumeration in a UML Class Diagram
///<br/>enumeration-any	default-null
///<br/><br/>
///Sets the name of the Enumeration
///<br/>name-string	default-
///<br/><br/>
///Defines the collection of enumeration members
///<br/>members-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the name of the enumeration member
///<br/>name-string	default-
///<br/><br/>
///Sets the type of the BPMN Events. Applicable, if the node is a BPMN event.
///<br/>event-ej.datavisualization.Diagram.BPMNEvents|string	default-ej.datavisualization.Diagram.BPMNEvents.Start
///<br/><br/>
///Defines whether the node can be automatically arranged using layout or not
///<br/>excludeFromLayout-boolean	default-false
///<br/><br/>
///Defines the state of the node is expanded or collapsed.
///<br/>expandIcon-any	default-
///<br/><br/>
///Sets the border color for expand icon of node
///<br/>borderColor-string	default-black
///<br/><br/>
///Sets the border width for expand icon of node
///<br/>borderWidth-number	default-1
///<br/><br/>
///Sets the fill color for expand icon of node
///<br/>fillColor-string	default-white
///<br/><br/>
///Defines the height for expand icon of node
///<br/>height-number	default-15
///<br/><br/>
///Sets the horizontal alignment of the icon.
///<br/>horizontalAlignment-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Center
///<br/><br/>
///To set the margin for the expand icon of node
///<br/>margin-any	default-ej.datavisualization.Diagram.Margin()
///<br/><br/>
///Sets the fraction/ratio(relative to node) that defines the position of the icon
///<br/>offset-any	default-ej.datavisualization.Diagram.Point(0.5, 1)
///<br/><br/>
///Defines the shape of the expanded state of the node.
///<br/>shape-ej.datavisualization.Diagram.IconShapes|string	default-ej.datavisualization.Diagram.IconShapes.None
///<br/><br/>
///Sets the vertical alignment of the icon.
///<br/>verticalAlignment-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Center
///<br/><br/>
///Defines the fill color of the node
///<br/>fillColor-string	default-white
///<br/><br/>
///Sets the type of the BPMN Gateway. Applicable, if the node is a BPMN gateway.
///<br/>gateway-ej.datavisualization.Diagram.BPMNGateways|string	default-ej.datavisualization.Diagram.BPMNGateways.None
///<br/><br/>
///Paints the node with a smooth transition from one color to another color
///<br/>gradient-any	default-
///<br/><br/>
///Paints the node with linear color transitions
///<br/>LinearGradient-any	default-
///<br/><br/>
///Defines the different colors and the region of color transitions
///<br/>stops-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the type of gradient
///<br/>type-string	default-linear
///<br/><br/>
///Defines the left most position(relative to node) of the rectangular region that needs to be painted
///<br/>x1-number	default-0
///<br/><br/>
///Defines the right most position(relative to node) of the rectangular region that needs to be painted
///<br/>x2-number	default-0
///<br/><br/>
///Defines the top most position(relative to node) of the rectangular region that needs to be painted
///<br/>y1-number	default-0
///<br/><br/>
///Defines the bottom most position(relative to node) of the rectangular region that needs to be painted
///<br/>y2-number	default-0
///<br/><br/>
///Paints the node with radial color transitions. A focal point defines the beginning of the gradient, and a circle defines the end point of the gradient.
///<br/>RadialGradient-any	default-
///<br/><br/>
///Defines the type of gradient
///<br/>type-string	default-radial
///<br/><br/>
///Defines the position of the outermost circle
///<br/>cx-number	default-0
///<br/><br/>
///Defines the outer most circle of the radial gradient
///<br/>cy-number	default-0
///<br/><br/>
///Defines the innermost circle of the radial gradient
///<br/>fx-number	default-0
///<br/><br/>
///Defines the innermost circle of the radial gradient
///<br/>fy-number	default-0
///<br/><br/>
///Defines the different colors and the region of color transitions.
///<br/>stops-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the color and a position where the previous color transition ends and a new color transition starts
///<br/>Stop-any	default-
///<br/><br/>
///Sets the color to be filled over the specified region
///<br/>color-string	default-
///<br/><br/>
///Sets the position where the previous color transition ends and a new color transition starts
///<br/>offset-number	default-0
///<br/><br/>
///Describes the transparency level of the region
///<br/>opacity-number	default-1
///<br/><br/>
///defines the node border with a smooth transition from one color to another color.
///<br/>borderGradient-any	default-null
///<br/><br/>
///Defines the header of a swimlane/lane
///<br/>header-any	default-{ text: Title, fontSize: 11 }
///<br/><br/>
///Defines the height of the node
///<br/>height-number	default-0
///<br/><br/>
///Sets the horizontal alignment of the node. Applicable, if the parent of the node is a container.
///<br/>horizontalAlign-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Left
///<br/><br/>
///A read only collection of the incoming connectors/edges of the node
///<br/>inEdges-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines an interface in a UML Class Diagram
///<br/>interface-any	default-null
///<br/><br/>
///Sets the name of the interface
///<br/>name-string	default-
///<br/><br/>
///Defines a collection of attributes of the interface
///<br/>attributes-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the name of the attribute
///<br/>name-string	default-
///<br/><br/>
///Sets the type of the attribute
///<br/>type-string	default-
///<br/><br/>
///Sets the visibility of the attribute
///<br/>scope-string	default-
///<br/><br/>
///Defines the collection of public methods of an interface
///<br/>methods-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the visibility of the method
///<br/>scope-string	default-
///<br/><br/>
///Defines whether the sub tree of the node is expanded or collapsed
///<br/>isExpanded-boolean	default-true
///<br/><br/>
///Sets the node as a swimlane
///<br/>isSwimlane-boolean	default-false
///<br/><br/>
///A collection of objects where each object represents a label
///<br/>labels-Array&lt;any&gt;	default-[]
///<br/><br/>
///Enables/disables the bold style
///<br/>bold-boolean	default-false
///<br/><br/>
///Sets the border color of the label
///<br/>borderColor-string	default-transparent
///<br/><br/>
///Sets the border width of the label
///<br/>borderWidth-number	default-0
///<br/><br/>
///This property allows you to customize labels appearance using user-defined CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Enables or disables the default behaviors of the label.
///<br/>constraints-ej.datavisualization.Diagram.LabelConstraints|string	default-ej.datavisualization.Diagram.LabelConstraints.None
///<br/><br/>
///Sets the fill color of the text area
///<br/>fillColor-string	default-transparent
///<br/><br/>
///Sets the font color of the text
///<br/>fontColor-string	default-black
///<br/><br/>
///Sets the font family of the text
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Defines the font size of the text
///<br/>fontSize-number	default-12
///<br/><br/>
///Sets the height of the label(the maximum value of label height and the node height will be considered as label height)
///<br/>height-number	default-0
///<br/><br/>
///Sets the horizontal alignment of the label.
///<br/>horizontalAlignment-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Center
///<br/><br/>
///Enables/disables the italic style
///<br/>italic-boolean	default-false
///<br/><br/>
///To set the margin of the label
///<br/>margin-any	default-ej.datavisualization.Diagram.Margin()
///<br/><br/>
///Gets whether the label is currently being edited or not.
///<br/>mode-ej.datavisualization.Diagram.LabelEditMode|string	default-ej.datavisualization.Diagram.LabelEditMode.Edit
///<br/><br/>
///Sets the unique identifier of the label
///<br/>name-string	default-
///<br/><br/>
///Sets the fraction/ratio(relative to node) that defines the position of the label
///<br/>offset-any	default-ej.datavisualization.Diagram.Point(0.5, 0.5)
///<br/><br/>
///Defines the transparency of the labels
///<br/>opacity-number	default-1
///<br/><br/>
///Sets the overflowType of the labels
///<br/>overflowType-ej.datavisualization.Diagram.OverflowType|string	default-ej.datavisualization.Diagram.OverflowType.Ellipsis
///<br/><br/>
///To set the padding of the node label
///<br/>padding-any	default-ej.datavisualization.Diagram.Padding()
///<br/><br/>
///Defines whether the label is editable or not
///<br/>readOnly-boolean	default-false
///<br/><br/>
///Defines the angle to which the label needs to be rotated
///<br/>rotateAngle-number	default-0
///<br/><br/>
///Sets the id of svg/html templates. Applicable, if the node's label is HTML or native.
///<br/>templateId-string	default-
///<br/><br/>
///Defines the label text
///<br/>text-string	default-
///<br/><br/>
///Defines how to align the text inside the label.
///<br/>textAlign-ej.datavisualization.Diagram.TextAlign|string	default-ej.datavisualization.Diagram.TextAlign.Center
///<br/><br/>
///Sets how to decorate the label text.
///<br/>textDecoration-ej.datavisualization.Diagram.TextDecorations|string	default-ej.datavisualization.Diagram.TextDecorations.None
///<br/><br/>
///Defines the overflowed content is displayed or not.
///<br/>textOverflow-boolean	default-false
///<br/><br/>
///Sets the vertical alignment of the label.
///<br/>verticalAlignment-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Center
///<br/><br/>
///Enables or disables the visibility of the label
///<br/>visible-boolean	default-true
///<br/><br/>
///Sets the width of the label(the maximum value of label width and the node width will be considered as label width)
///<br/>width-number	default-50
///<br/><br/>
///Defines how the label text needs to be wrapped.
///<br/>wrapping-ej.datavisualization.Diagram.TextWrapping|string	default-ej.datavisualization.Diagram.TextWrapping.WrapWithOverflow
///<br/><br/>
///An array of objects where each object represents a lane. Applicable, if the node is a swimlane.
///<br/>lanes-Array&lt;any&gt;	default-[]
///<br/><br/>
///This property allows you to customize lanes appearance using user-defined CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Defines the width of lane
///<br/>width-number	default-0
///<br/><br/>
///Defines the height of lane
///<br/>height-number	default-0
///<br/><br/>
///Defines the z-index of the lane
///<br/>zorder-number	default-0
///<br/><br/>
///Allows to maintain additional information about lane
///<br/>addInfo-any	default-{}
///<br/><br/>
///An array of objects where each object represents a child node of the lane
///<br/>children-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the fill color of the lane
///<br/>fillColor-string	default-white
///<br/><br/>
///Defines the header of the lane
///<br/>header-any	default-{ text: Function, fontSize: 11 }
///<br/><br/>
///Defines the object as a lane
///<br/>isLane-boolean	default-false
///<br/><br/>
///Sets the unique identifier of the lane
///<br/>name-string	default-
///<br/><br/>
///Sets the orientation of the lane.
///<br/>orientation-string	default-vertical
///<br/><br/>
///Defines the minimum space to be left between the bottom of parent bounds and the node. Applicable, if the parent is a container.
///<br/>marginBottom-number	default-0
///<br/><br/>
///Defines the minimum space to be left between the left of parent bounds and the node. Applicable, if the parent is a container.
///<br/>marginLeft-number	default-0
///<br/><br/>
///Defines the minimum space to be left between the right of the parent bounds and the node. Applicable, if the parent is a container.
///<br/>marginRight-number	default-0
///<br/><br/>
///Defines the minimum space to be left between the top of parent bounds and the node. Applicable, if the parent is a container.
///<br/>marginTop-number	default-0
///<br/><br/>
///Defines the maximum height limit of the node
///<br/>maxHeight-number	default-0
///<br/><br/>
///Defines the maximum width limit of the node
///<br/>maxWidth-number	default-0
///<br/><br/>
///Defines the minimum height limit of the node
///<br/>minHeight-number	default-0
///<br/><br/>
///Defines the minimum width limit of the node
///<br/>minWidth-number	default-0
///<br/><br/>
///Sets the unique identifier of the node
///<br/>name-string	default-
///<br/><br/>
///Defines the position of the node on X-Axis
///<br/>offsetX-number	default-0
///<br/><br/>
///Defines the position of the node on Y-Axis
///<br/>offsetY-number	default-0
///<br/><br/>
///Defines the opaque of the node
///<br/>opacity-number	default-1
///<br/><br/>
///Defines the orientation of nodes. Applicable, if the node is a swimlane.
///<br/>orientation-string	default-vertical
///<br/><br/>
///A read only collection of outgoing connectors/edges of the node
///<br/>outEdges-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the minimum padding value to be left between the bottom most position of a group and its children. Applicable, if the group is a container.
///<br/>paddingBottom-number	default-0
///<br/><br/>
///Defines the minimum padding value to be left between the left most position of a group and its children. Applicable, if the group is a container.
///<br/>paddingLeft-number	default-0
///<br/><br/>
///Defines the minimum padding value to be left between the right most position of a group and its children. Applicable, if the group is a container.
///<br/>paddingRight-number	default-0
///<br/><br/>
///Defines the minimum padding value to be left between the top most position of a group and its children. Applicable, if the group is a container.
///<br/>paddingTop-number	default-0
///<br/><br/>
///Defines the size and preview size of the node to add that to symbol palette
///<br/>paletteItem-any	default-null
///<br/><br/>
///Defines whether the symbol should be drawn at its actual size regardless of precedence factors or not
///<br/>enableScale-boolean	default-true
///<br/><br/>
///Defines the height of the symbol
///<br/>height-number	default-0
///<br/><br/>
///To display a name for nodes in the symbol palette
///<br/>label-string	default-null
///<br/><br/>
///Defines the margin of the symbol item
///<br/>margin-any	default-{ left: 4, right: 4, top: 4, bottom: 4 }
///<br/><br/>
///Defines the preview height of the symbol
///<br/>previewHeight-number	default-undefined
///<br/><br/>
///Defines the preview width of the symbol
///<br/>previewWidth-number	default-undefined
///<br/><br/>
///Defines the width of the symbol
///<br/>width-number	default-0
///<br/><br/>
///Sets the name of the parent group
///<br/>parent-string	default-
///<br/><br/>
///Sets the path geometry that defines the shape of a path node
///<br/>pathData-string	default-
///<br/><br/>
///An array of objects, where each object represents a smaller region(phase) of a swimlane.
///<br/>phases-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the header of the smaller regions
///<br/>label-any	default-null
///<br/><br/>
///Defines the line color of the splitter that splits adjacent phases.
///<br/>lineColor-string	default-#606060
///<br/><br/>
///Sets the dash array that used to stroke the phase splitter
///<br/>lineDashArray-string	default-3,3
///<br/><br/>
///Sets the lineWidth of the phase
///<br/>lineWidth-number	default-1
///<br/><br/>
///Sets the unique identifier of the phase
///<br/>name-string	default-
///<br/><br/>
///Sets the length of the smaller region(phase) of a swimlane
///<br/>offset-number	default-100
///<br/><br/>
///Sets the orientation of the phase
///<br/>orientation-string	default-horizontal
///<br/><br/>
///Sets the type of the object as phase
///<br/>type-string	default-phase
///<br/><br/>
///Sets the height of the phase headers
///<br/>phaseSize-number	default-0
///<br/><br/>
///Sets the ratio/ fractional value relative to node, based on which the node will be transformed(positioning, scaling and rotation)
///<br/>pivot-any	default-ej.datavisualization.Diagram.Points(0.5,0.5)
///<br/><br/>
///Defines a collection of points to draw a polygon. Applicable, if the shape is a polygon.
///<br/>points-Array&lt;any&gt;	default-[]
///<br/><br/>
///An array of objects where each object represents a port
///<br/>ports-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the border color of the port
///<br/>borderColor-string	default-#1a1a1a
///<br/><br/>
///Sets the stroke width of the port
///<br/>borderWidth-number	default-1
///<br/><br/>
///Defines the space to be left between the port bounds and its incoming and outgoing connections.
///<br/>connectorPadding-number	default-0
///<br/><br/>
///Defines whether connections can be created with the port
///<br/>constraints-ej.datavisualization.Diagram.PortConstraints|string	default-ej.datavisualization.Diagram.PortConstraints.Connect
///<br/><br/>
///This property allows you to customize ports appearance using user-defined CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Sets the fill color of the port
///<br/>fillColor-string	default-white
///<br/><br/>
///Sets the unique identifier of the port
///<br/>name-string	default-
///<br/><br/>
///Defines the position of the port as fraction/ ratio relative to node
///<br/>offset-any	default-ej.datavisualization.Diagram.Point(0, 0)
///<br/><br/>
///Defines the path data to draw the port. Applicable, if the port shape is path.
///<br/>pathData-string	default-
///<br/><br/>
///Defines the shape of the port.
///<br/>shape-ej.datavisualization.Diagram.PortShapes|string	default-ej.datavisualization.Diagram.PortShapes.Square
///<br/><br/>
///Defines the size of the port
///<br/>size-number	default-8
///<br/><br/>
///Defines when the port should be visible.
///<br/>visibility-ej.datavisualization.Diagram.PortVisibility|string	default-ej.datavisualization.Diagram.PortVisibility.Default
///<br/><br/>
///Sets the name of the node which contains this port.
///<br/>parent-string	default-
///<br/><br/>
///Sets the angle to which the node should be rotated
///<br/>rotateAngle-number	default-0
///<br/><br/>
///Defines the opacity and the position of shadow
///<br/>shadow-any	default-ej.datavisualization.Diagram.Shadow()
///<br/><br/>
///Defines the angle of the shadow relative to node
///<br/>angle-number	default-45
///<br/><br/>
///Sets the distance to move the shadow relative to node
///<br/>distance-number	default-5
///<br/><br/>
///Defines the opaque of the shadow
///<br/>opacity-number	default-0.7
///<br/><br/>
///Sets the shape of the node. It depends upon the type of node.
///<br/>shape-ej.datavisualization.Diagram.BasicShapes | ej.datavisualization.Diagram.FlowShapes | ej.datavisualization.Diagram.BPMNShapes | ej.datavisualization.Diagram.UMLActivityShapes|string	default-ej.datavisualization.Diagram.BasicShapes.Rectangle
///<br/><br/>
///Sets the source path of the image. Applicable, if the type of the node is image.
///<br/>source-string	default-
///<br/><br/>
///Defines the sub process of a BPMN Activity. Applicable, if the type of the BPMN activity is sub process.
///<br/>subProcess-any	default-ej.datavisualization.Diagram.BPMNSubProcess()
///<br/><br/>
///Defines whether the BPMN sub process is without any prescribed order or not
///<br/>adhoc-boolean	default-false
///<br/><br/>
///Sets the boundary of the BPMN process
///<br/>boundary-ej.datavisualization.Diagram.BPMNBoundary|string	default-ej.datavisualization.Diagram.BPMNBoundary.Default
///<br/><br/>
///Sets whether the BPMN subprocess is triggered as a compensation of a specific activity
///<br/>compensation-boolean	default-false
///<br/><br/>
///Sets whether the BPMN subprocess is triggered as a collapsed of a specific activity
///<br/>collapsed-boolean	default-true
///<br/><br/>
///Sets the type of the event by which the sub-process will be triggered
///<br/>event-ej.datavisualization.Diagram.BPMNEvents|string	default-ej.datavisualization.Diagram.BPMNEvents.Start
///<br/><br/>
///Defines the collection of events that need to be appended with BPMN Sub-Process
///<br/>events-Array&lt;any&gt;	default-
///<br/><br/>
///Sets the type of the event by which the sub-process will be triggered
///<br/>event-ej.datavisualization.Diagram.BPMNEvents|string	default-ej.datavisualization.Diagram.BPMNEvents.Start
///<br/><br/>
///Sets the fraction/ratio(relative to parent) that defines the position of the event shape
///<br/>offset-any	default-ej.datavisualization.Diagram.Point(0.5, 0.5)
///<br/><br/>
///Sets the name of the BPMN event shape.
///<br/>name-string	default-
///<br/><br/>
///Defines the type of the event trigger
///<br/>trigger-ej.datavisualization.Diagram.BPMNTriggers|string	default-ej.datavisualization.Diagram.BPMNTriggers.Message
///<br/><br/>
///An array of objects where each object represents a port
///<br/>ports-Array&lt;any&gt;	default-[]
///<br/><br/>
///A collection of objects where each object represents a label
///<br/>labels-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the loop type of a sub process.
///<br/>loop-ej.datavisualization.Diagram.BPMNLoops|string	default-ej.datavisualization.Diagram.BPMNLoops.None
///<br/><br/>
///Defines the children for BPMN's SubProcess
///<br/>Processes-Array&lt;any&gt;	default-[]
///<br/><br/>
///Defines the type of the event trigger
///<br/>trigger-ej.datavisualization.Diagram.BPMNTriggers|string	default-ej.datavisualization.Diagram.BPMNTriggers.Message
///<br/><br/>
///Defines the type of a sub process
///<br/>type-ej.datavisualization.Diagram.BPMNSubProcessTypes|string	default-ej.datavisualization.Diagram.BPMNSubProcessTypes.None
///<br/><br/>
///Defines the task of the BPMN activity. Applicable, if the type of activity is set as task.
///<br/>task-any	default-ej.datavisualization.Diagram.BPMNTask()
///<br/><br/>
///To set whether the task is a global task or not
///<br/>call-boolean	default-false
///<br/><br/>
///Sets whether the task is triggered as a compensation of another specific activity
///<br/>compensation-boolean	default-false
///<br/><br/>
///Sets the loop type of a BPMN task.
///<br/>loop-ej.datavisualization.Diagram.BPMNLoops|string	default-ej.datavisualization.Diagram.BPMNLoops.None
///<br/><br/>
///Sets the type of the BPMN task.
///<br/>type-ej.datavisualization.Diagram.BPMNTasks|string	default-ej.datavisualization.Diagram.BPMNTasks.None
///<br/><br/>
///Defines the collection of events that need to be appended with BPMN tasks
///<br/>events-Array&lt;any&gt;	default-
///<br/><br/>
///Sets the id of svg/html templates. Applicable, if the node is HTML or native.
///<br/>templateId-string	default-
///<br/><br/>
///Defines the textBlock of a text node
///<br/>textBlock-any	default-null
///<br/><br/>
///Defines the tooltip that should be shown when the mouse hovers over node. For tooltip properties, refer Tooltip
///<br/>tooltip-any	default-null
///<br/><br/>
///Sets the type of BPMN Event Triggers.
///<br/>trigger-ej.datavisualization.Diagram.BPMNTriggers|string	default-ej.datavisualization.Diagram.BPMNTriggers.None
///<br/><br/>
///Defines the type of the node.
///<br/>type-ej.datavisualization.Diagram.Shapes|string	default-ej.datavisualization.Diagram.Shapes.Basic
///<br/><br/>
///Sets the vertical alignment of a node. Applicable, if the parent of a node is a container.
///<br/>verticalAlign-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Top
///<br/><br/>
///Defines the visibility of the node
///<br/>visible-boolean	default-true
///<br/><br/>
///Defines the width of the node
///<br/>width-number	default-0
///<br/><br/>
///Defines the z-index of the node
///<br/>zOrder-number	default-0
///<br/><br/>
///A collection of JSON objects where each object represents a layer. Layer is a named category of diagram shapes.
///<br/>layers-Array&lt;Layers&gt;	default-[]
///<br/><br/>
///To specify the name of the diagram layer. Layer name should be unique.
///<br/>name-string	default-
///<br/><br/>
///Enable or disable diagram objects to be added to the specific layer.
///<br/>active-boolean	default-false
///<br/><br/>
///Enable or disable the specific layer objects to be visible.
///<br/>visible-boolean	default-true
///<br/><br/>
///Enable or disable the specific layer objects to be visible on printing or exporting.
///<br/>print-boolean	default-true
///<br/><br/>
///Enable or disable the interaction of the specific diagram objects.
///<br/>lock-boolean	default-false
///<br/><br/>
///To Specify the collection of the object names belongs to the layer.
///<br/>objects-Array&lt;any&gt;	default-[]
///<br/><br/>
///Binds the custom JSON data with node properties
///<br/>nodeTemplate-any	default-null
///<br/><br/>
///Defines the size and appearance of diagram page
///<br/>pageSettings-PageSettings	default-
///<br/><br/>
///Defines the maximum distance to be left between the object and the scroll bar to trigger auto scrolling
///<br/>autoScrollBorder-any	default-{ left: 15, top: 15, right: 15, bottom: 15 }
///<br/><br/>
///Sets whether multiple pages can be created to fit all nodes and connectors
///<br/>multiplePage-boolean	default-false
///<br/><br/>
///Defines the background color of diagram pages
///<br/>pageBackgroundColor-string	default-#ffffff
///<br/><br/>
///Defines the page border color
///<br/>pageBorderColor-string	default-#565656
///<br/><br/>
///Sets the border width of diagram pages
///<br/>pageBorderWidth-number	default-0
///<br/><br/>
///Defines the height of a page
///<br/>pageHeight-number	default-null
///<br/><br/>
///Defines the page margin
///<br/>pageMargin-number	default-24
///<br/><br/>
///Sets the orientation of the page.
///<br/>pageOrientation-ej.datavisualization.Diagram.PageOrientations|string	default-ej.datavisualization.Diagram.PageOrientations.Portrait
///<br/><br/>
///Defines the height of a diagram page
///<br/>pageWidth-number	default-null
///<br/><br/>
///Defines the scrollable area of diagram. Applicable, if the scroll limit is "limited".
///<br/>scrollableArea-any	default-null
///<br/><br/>
///Defines the scrollable region of diagram.
///<br/>scrollLimit-ej.datavisualization.Diagram.ScrollLimit|string	default-ej.datavisualization.Diagram.ScrollLimit.Infinite
///<br/><br/>
///Defines the draggable region of diagram elements.
///<br/>boundaryConstraints-ej.datavisualization.Diagram.BoundaryConstraints|string	default-ej.datavisualization.Diagram.BoundaryConstraints.Infinite
///<br/><br/>
///Enables or disables the page breaks
///<br/>showPageBreak-boolean	default-false
///<br/><br/>
///Defines the zoom value, zoom factor, scroll status and view port size of the diagram
///<br/>scrollSettings-ScrollSettings	default-
///<br/><br/>
///Allows to read the zoom value of diagram
///<br/>currentZoom-number	default-0
///<br/><br/>
///Sets the horizontal scroll offset
///<br/>horizontalOffset-number	default-0
///<br/><br/>
///Allows to extend the scrollable region that is based on the scroll limit
///<br/>padding-any	default-{left: 0, right: 0, top:0, bottom: 0}
///<br/><br/>
///Sets the vertical scroll offset
///<br/>verticalOffset-number	default-0
///<br/><br/>
///Allows to read the view port height of the diagram
///<br/>viewPortHeight-number	default-0
///<br/><br/>
///Allows to read the view port width of the diagram
///<br/>viewPortWidth-number	default-0
///<br/><br/>
///Defines the size and position of selected items and defines the appearance of selector
///<br/>selectedItems-SelectedItems	default-
///<br/><br/>
///A read only collection of the selected items
///<br/>children-Array&lt;any&gt;	default-[]
///<br/><br/>
///Controls the visibility of selector.
///<br/>constraints-ej.datavisualization.Diagram.SelectorConstraints|string	default-ej.datavisualization.Diagram.SelectorConstraints.All
///<br/><br/>
///Defines a method that dynamically enables/ disables the interaction with multiple selection.
///<br/>getConstraints-any	default-null
///<br/><br/>
///Sets the height of the selected items
///<br/>height-number	default-0
///<br/><br/>
///Sets the x position of the selector
///<br/>offsetX-number	default-0
///<br/><br/>
///Sets the y position of the selector
///<br/>offsetY-number	default-0
///<br/><br/>
///Sets the angle to rotate the selected items
///<br/>rotateAngle-number	default-0
///<br/><br/>
///Sets the angle to rotate the selected items. For tooltip properties, refer Tooltip
///<br/>tooltip-any	default-ej.datavisualization.Diagram.Tooltip()
///<br/><br/>
///A collection of frequently used commands that will be added around the selector
///<br/>userHandles-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the horizontal alignment of the user handle
///<br/>horizontalAlignment-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Center
///<br/><br/>
///To set the margin of the user handle
///<br/>margin-any	default-ej.datavisualization.Diagram.Margin()
///<br/><br/>
///Defines the name of the user handle
///<br/>name-string	default-
///<br/><br/>
///Defines the background color of the user handle
///<br/>backgroundColor-string	default-#2382c3
///<br/><br/>
///Sets the border color of the user handle
///<br/>borderColor-string	default-transparent
///<br/><br/>
///Defines whether the user handle should be added, when more than one element is selected
///<br/>enableMultiSelection-boolean	default-false
///<br/><br/>
///Sets the fraction/ratio(relative to node) that defines the position of the user handle
///<br/>offset-any	default-ej.datavisualization.Diagram.point(0.5, 1)
///<br/><br/>
///Sets the stroke color of the user handle
///<br/>pathColor-string	default-transparent
///<br/><br/>
///Defines the custom shape of the user handle
///<br/>pathData-string	default-
///<br/><br/>
///Defines the position of the user handle
///<br/>position-ej.datavisualization.Diagram.UserHandlePositions |string	default-ej.datavisualization.Diagram.UserHandlePositions.BottomCenter
///<br/><br/>
///Defines the size of the user handle
///<br/>size-number	default-8
///<br/><br/>
///Defines the interactive behaviors of the user handle
///<br/>tool-any	default-
///<br/><br/>
///Sets the vertical alignment of the user handle
///<br/>verticalAlignment-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Center
///<br/><br/>
///Defines the visibility of the user handle
///<br/>visible-boolean	default-true
///<br/><br/>
///Sets the width of the selected items
///<br/>width-number	default-0
///<br/><br/>
///Enables or disables tooltip of diagram
///<br/>showTooltip-boolean	default-true
///<br/><br/>
///Defines diagram serialization properties that would defines how the serialization content would be.
///<br/>serializationSettings-SerializationSettings	default-
///<br/><br/>
///defines whether the default diagram properties can be serialized or not.
///<br/>preventDefaultValues-boolean	default-false
///<br/><br/>
///Defines the properties of the both the horizontal and vertical gauge to measure the diagram area.
///<br/>rulerSettings-RulerSettings	default-
///<br/><br/>
///Enables or disables both the horizontal and vertical ruler.
///<br/>showRulers-boolean	default-false
///<br/><br/>
///Defines the appearance of horizontal ruler
///<br/>horizontalRuler-any	default-
///<br/><br/>
///Defines the number of intervals to be present on the each segment of the horizontal ruler.
///<br/>interval-number	default-5
///<br/><br/>
///Defines the textual description of the ruler segment, and the appearance of the ruler ticks of the horizontal ruler.
///<br/>segmentWidth-number	default-100
///<br/><br/>
///Defines the method which used to position and arrange the tick elements of the horizontal ruler.
///<br/>arrangeTick-any	default-null
///<br/><br/>
///Defines and sets the tick alignment of the ruler scale.
///<br/>tickAlignment-ej.datavisualization.Diagram.TickAlignment|string	default-ej.datavisualization.Diagram.TickAlignment.RightOrBottom
///<br/><br/>
///Defines the color of the horizontal marker brush.
///<br/>markerColor-string	default-red
///<br/><br/>
///Defines the width of the horizontal ruler.
///<br/>length-number	default-null
///<br/><br/>
///Defines the height of the horizontal ruler.
///<br/>thickness-number	default-25
///<br/><br/>
///Defines the appearance of vertical ruler
///<br/>verticalRuler-any	default-
///<br/><br/>
///Defines the number of intervals to be present on the each segment of the vertical ruler.
///<br/>interval-number	default-5
///<br/><br/>
///Defines the textual description of the ruler segment, and the appearance of the ruler ticks of the vertical ruler.
///<br/>segmentWidth-number	default-100
///<br/><br/>
///Defines the method which used to position and arrange the tick elements of the vertical ruler.
///<br/>arrangeTick-any	default-null
///<br/><br/>
///Defines and sets the tick alignment of the ruler scale.
///<br/>tickAlignment-ej.datavisualization.Diagram.TickAlignment|string	default-ej.datavisualization.Diagram.TickAlignment.RightOrBottom
///<br/><br/>
///Defines the color of the vertical marker brush.
///<br/>markerColor-string	default-red
///<br/><br/>
///Defines the height of the vertical ruler.
///<br/>length-number	default-null
///<br/><br/>
///Defines the width of the vertical ruler.
///<br/>thickness-number	default-25
///<br/><br/>
///Defines the gridlines and defines how and when the objects have to be snapped
///<br/>snapSettings-SnapSettings	default-
///<br/><br/>
///Enables or disables snapping nodes/connectors to objects
///<br/>enableSnapToObject-boolean	default-true
///<br/><br/>
///Defines the appearance of horizontal gridlines
///<br/>horizontalGridLines-any	default-
///<br/><br/>
///Defines the line color of horizontal grid lines
///<br/>lineColor-string	default-lightgray
///<br/><br/>
///Specifies the pattern of dashes and gaps used to stroke horizontal grid lines
///<br/>lineDashArray-string	default-
///<br/><br/>
///A pattern of lines and gaps that defines a set of horizontal gridlines
///<br/>linesInterval-Array&lt;any&gt;	default-[1.25, 18.75, 0.25, 19.75, 0.25, 19.75, 0.25, 19.75, 0.25, 19.75]
///<br/><br/>
///Specifies a set of intervals to snap the objects
///<br/>snapInterval-Array&lt;any&gt;	default-[20]
///<br/><br/>
///Defines the angle by which the object needs to be snapped
///<br/>snapAngle-number	default-5
///<br/><br/>
///Defines and sets the snapConstraints
///<br/>snapConstraints-ej.datavisualization.Diagram.SnapConstraints|string	default-
///<br/><br/>
///Defines the minimum distance between the selected object and the nearest object
///<br/>snapObjectDistance-number	default-5
///<br/><br/>
///Defines the appearance of horizontal gridlines
///<br/>verticalGridLines-any	default-
///<br/><br/>
///Defines the line color of horizontal grid lines
///<br/>lineColor-string	default-lightgray
///<br/><br/>
///Specifies the pattern of dashes and gaps used to stroke horizontal grid lines
///<br/>lineDashArray-string	default-
///<br/><br/>
///A pattern of lines and gaps that defines a set of horizontal gridlines
///<br/>linesInterval-Array&lt;any&gt;	default-[1.25, 18.75, 0.25, 19.75, 0.25, 19.75, 0.25, 19.75, 0.25, 19.75]
///<br/><br/>
///Specifies a set of intervals to snap the objects
///<br/>snapInterval-Array&lt;any&gt;	default-[20]
///<br/><br/>
///Enables/Disables the interactive behaviors of diagram.
///<br/>tool-ej.datavisualization.Diagram.Tool|string	default-ej.datavisualization.Diagram.Tool.All
///<br/><br/>
///An object that defines the description, appearance and alignments of tooltips
///<br/>tooltip-Tooltip	default-null
///<br/><br/>
///Aligns the tooltip around nodes/connectors
///<br/>alignment-any	default-
///<br/><br/>
///Defines the horizontal alignment of tooltip.
///<br/>horizontal-ej.datavisualization.Diagram.HorizontalAlignment|string	default-ej.datavisualization.Diagram.HorizontalAlignment.Center
///<br/><br/>
///Defines the vertical alignment of tooltip.
///<br/>vertical-ej.datavisualization.Diagram.VerticalAlignment|string	default-ej.datavisualization.Diagram.VerticalAlignment.Bottom
///<br/><br/>
///Sets the margin of the tooltip
///<br/>margin-any	default-{ left: 5, right: 5, top: 5, bottom: 5 }
///<br/><br/>
///Defines whether the tooltip should be shown at the mouse position or around node.
///<br/>relativeMode-ej.datavisualization.Diagram.RelativeMode|string	default-ej.datavisualization.Diagram.RelativeMode.Object
///<br/><br/>
///Sets the svg/html template to be bound with tooltip
///<br/>templateId-string	default-
///<br/><br/>
///Specifies the width of the diagram
///<br/>width-string	default-null
///<br/><br/>
///Sets the factor by which we can zoom in or zoom out
///<br/>zoomFactor-number	default-0.2
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Dialog:function(){
 /// <signature>
 /// <summary>Constructor of ej.Dialog</summary>
 /// </signature>
}
});
ej.Dialog=(function(){
var original=ej.Dialog
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

close:function(){
/// <signature>
/// <summary>
/// Closes the dialog widget dynamically.
/// </summary>
},
collapse:function(){
/// <signature>
/// <summary>
/// Collapses the content area when it is expanded.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroys the Dialog widget.
/// </summary>
},
expand:function(){
/// <signature>
/// <summary>
/// Expands the content area when it is collapsed.
/// </summary>
},
isOpen:function(){
/// <signature>
/// <summary>
/// Checks whether the Dialog widget is opened or not. This methods returns Boolean value.
/// </summary>
},
maximize:function(){
/// <signature>
/// <summary>
/// Maximizes the Dialog widget.
/// </summary>
},
minimize:function(){
/// <signature>
/// <summary>
/// Minimizes the Dialog widget.
/// </summary>
},
open:function(){
/// <signature>
/// <summary>
/// Opens the Dialog widget.
/// </summary>
},
pin:function(){
/// <signature>
/// <summary>
/// Pins the dialog in its current position.
/// </summary>
},
refresh:function(){
/// <signature>
/// <summary>
/// Refreshes the dialog content dynamically.
/// </summary>
},
restore:function(){
/// <signature>
/// <summary>
/// Restores the dialog.
/// </summary>
},
unpin:function(){
/// <signature>
/// <summary>
/// Unpins the Dialog widget.
/// </summary>
},
setTitle:function(Title){
/// <signature>
/// <summary>
/// Sets the title for the Dialog widget.
/// </summary>
/// <param name="Title"	type="string">The title for the dialog widget.</param>
/// </signature>
},
setContent:function(content){
/// <signature>
/// <summary>
/// Sets the content for the Dialog widget dynamically.
/// </summary>
/// <param name="content"	type="string">The content for the dialog widget. It accepts both string and HTML string.</param>
/// </signature>
},
focus:function(){
/// <signature>
/// <summary>
/// Sets the focus on the Dialog widget.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDialog=function(){
this.data("ejDialog",new	ej.Dialog());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDialog :function (options) {
/// <signature>
/// <summary><br/>
///The Dialog control displays a Dialog window within a web page. The Dialog enables a message to be displayed, such as supplementary content like images and text, and an interactive content like forms.<br/><br/>
///Adds action buttons like close, minimize, pin, maximize in the dialog header.
///<br/>actionButtons-string[]	default-
///<br/><br/>
///Specifies the ajaxSettings option to load the content to the Dialog control.
///<br/>ajaxSettings-AjaxSettings	default-null
///<br/><br/>
///It specifies, whether to enable or disable asynchronous request.
///<br/>async-boolean	default-
///<br/><br/>
///It specifies the page will be cached in the web browser.
///<br/>cache-boolean	default-
///<br/><br/>
///It specifies the type of data is send in the query string.
///<br/>contentType-string	default-
///<br/><br/>
///It specifies the data as an object, will be passed in the query string.
///<br/>data-any	default-
///<br/><br/>
///It specifies the type of data that you're expecting back from the response.
///<br/>dataType-string	default-
///<br/><br/>
///It specifies the HTTP request type.
///<br/>type-string	default-
///<br/><br/>
///Enables or disables draggable.
///<br/>allowDraggable-boolean	default-
///<br/><br/>
///Enables or disables keyboard interaction.
///<br/>allowKeyboardNavigation-boolean	default-
///<br/><br/>
///Customizes the Dialog widget animations. The Dialog widget can be animated while opening and closing the dialog. In order to customize animation effects, you need to set â€œenableAnimationâ€ as true. It contains the following sub properties.
///<br/>animation-any	default-
///<br/><br/>
///To Enable or disable the scrolling for background element of the modal dialog. This will work only with modal dialog.
///<br/>backgroundScroll-boolean	default-
///<br/><br/>
///Closes the dialog widget on pressing the ESC key when it is set to true.
///<br/>closeOnEscape-boolean	default-
///<br/><br/>
///The selector for the container element. If the property is set, then dialog will append to the selected element and it is restricted to move only within the specified container element.
///<br/>containment-string	default-
///<br/><br/>
///The content type to load the dialog content at run time. The possible values are null, AJAX, iframe and image. When it is null (default value), the content inside dialog element will be displayed as content and when it is not null, the content will be loaded from the URL specified in the contentUrl property.
///<br/>contentType-string	default-
///<br/><br/>
///The URL to load the dialog content (such as AJAX, image, and iframe). In order to load content from URL, you need to set contentType as â€˜ajaxâ€™ or â€˜iframeâ€™ or â€˜imageâ€™.
///<br/>contentUrl-string	default-
///<br/><br/>
///The root class for the Dialog widget to customize the existing theme.
///<br/>cssClass-string	default-
///<br/><br/>
///Enable or disables animation when the dialog is opened or closed.
///<br/>enableAnimation-boolean	default-
///<br/><br/>
///Enables or disables the Dialog widget.
///<br/>enabled-boolean	default-
///<br/><br/>
///Enable or disables modal dialog. The modal dialog acts like a child window that is displayed on top of the main window/screen and disables the main window interaction until it is closed.
///<br/>enableModal-boolean	default-
///<br/><br/>
///Allows the current model values to be saved in local storage or browser cookies for state maintenance when it is set to true.
///<br/>enablePersistence-boolean	default-
///<br/><br/>
///Allows the dialog to be resized. The dialog cannot be resized less than the minimum height, width values and greater than the maximum height and width.
///<br/>enableResize-boolean	default-
///<br/><br/>
///Displays dialog content from right to left when set to true.
///<br/>enableRTL-boolean	default-
///<br/><br/>
///The CSS class name to display the favicon in the dialog header. In order to display favicon, you need to set showHeader as true since the favicon will be displayed in the dialog header.
///<br/>faviconCSS-string	default-
///<br/><br/>
///Sets the height for the dialog widget. It accepts both string and integer values. For example, it can accepts values like â€œautoâ€, â€œ100%â€, â€œ100pxâ€ as string type and â€œ100â€, â€œ500â€ as integer type.
///<br/>height-string|number	default-
///<br/><br/>
///Specifies the HTML Attributes of the Dialog.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Enable or disables responsive behavior.
///<br/>isResponsive-boolean	default-
///<br/><br/>
///Default Value:{:.param}â€œen-USâ€
///<br/>locale-string	default-
///<br/><br/>
///Sets the maximum height for the dialog widget.
///<br/>maxHeight-string|number	default-
///<br/><br/>
///Sets the maximum width for the dialog widget.
///<br/>maxWidth-string|number	default-
///<br/><br/>
///Sets the minimum height for the dialog widget.
///<br/>minHeight-string|number	default-
///<br/><br/>
///Sets the minimum width for the dialog widget.
///<br/>minWidth-string|number	default-
///<br/><br/>
///Displays the Dialog widget at the given X and Y position.
///<br/>position-any	default-
///<br/><br/>
///Shows or hides the dialog header.
///<br/>showHeader-boolean	default-
///<br/><br/>
///The Dialog widget can be opened by default i.e. on initialization, when it is set to true.
///<br/>showOnInit-boolean	default-
///<br/><br/>
///Enables or disables the rounder corner.
///<br/>showRoundedCorner-boolean	default-
///<br/><br/>
///The selector for the container element. If this property is set, the dialog will be displayed (positioned) based on its container.
///<br/>target-string	default-
///<br/><br/>
///The title text to be displayed in the dialog header. In order to set title, you need to set showHeader as true since the title will be displayed in the dialog header.
///<br/>title-string	default-
///<br/><br/>
///Add or configure the tooltip text for actionButtons in the dialog header.
///<br/>tooltip-any	default-
///<br/><br/>
///Sets the height for the dialog widget. It accepts both string and integer values. For example, it can accepts values like â€œautoâ€, â€œ100%â€, â€œ100pxâ€ as string type and â€œ100â€, â€œ500â€ as integer type.
///<br/>width-string|number	default-
///<br/><br/>
///Sets the z-index value for the Dialog widget.
///<br/>zIndex-number	default-
///<br/><br/>
///Sets the Footer for the Dialog widget.
///<br/>showFooter-boolean	default-
///<br/><br/>
///Sets the FooterTemplate for the Dialog widget.
///<br/>footerTemplateId-string	default-
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
DigitalGauge:function(){
 /// <signature>
 /// <summary>Constructor of ej.DigitalGauge</summary>
 /// </signature>
}
});
ej.DigitalGauge=(function(){
var original=ej.DigitalGauge
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// To destroy the digital gauge
/// </summary>
},
exportImage:function(fileName, fileType){
/// <signature>
/// <summary>
/// To export Digital Gauge as Image
/// </summary>
/// <param name="fileName"	type="string">fileName for the Image</param>
/// </signature>
/// <signature>
/// <summary>
/// To export Digital Gauge as Image
/// </summary>
/// <param name="fileType"	type="string">fileType for the Image</param>
/// </signature>
},
getPosition:function(itemIndex){
/// <signature>
/// <summary>
/// Gets the location of an item that is displayed on the gauge.
/// </summary>
/// <param name="itemIndex"	type="number">Position value of an item that is displayed on the gauge.</param>
/// </signature>
},
getValue:function(itemIndex){
/// <signature>
/// <summary>
/// ClientSideMethod getValue Gets the value of an item that is displayed on the gauge
/// </summary>
/// <param name="itemIndex"	type="number">Index value of an item that displayed on the gauge</param>
/// </signature>
},
refresh:function(){
/// <signature>
/// <summary>
/// Refresh the digital gauge widget
/// </summary>
},
setPosition:function(itemIndex, value){
/// <signature>
/// <summary>
/// ClientSideMethod Set Position Sets the location of an item to be displayed in the gauge
/// </summary>
/// <param name="itemIndex"	type="number">Index value of the digital gauge item</param>
/// </signature>
/// <signature>
/// <summary>
/// ClientSideMethod Set Position Sets the location of an item to be displayed in the gauge
/// </summary>
/// <param name="value"	type="any">Location value of the digital gauge</param>
/// </signature>
},
setValue:function(itemIndex, value){
/// <signature>
/// <summary>
/// ClientSideMethod SetValue Sets the value of an item to be displayed in the gauge.
/// </summary>
/// <param name="itemIndex"	type="number">Index value of the digital gauge item</param>
/// </signature>
/// <signature>
/// <summary>
/// ClientSideMethod SetValue Sets the value of an item to be displayed in the gauge.
/// </summary>
/// <param name="value"	type="string">Text value to be displayed in the gaugeS</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDigitalGauge=function(){
this.data("ejDigitalGauge",new	ej.DigitalGauge());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDigitalGauge :function (options) {
/// <signature>
/// <summary><br/>
///The Digital gauge can be easily configured to the DOM element, such as div. you can create a digital gauge with a highly customizable look and feel.<br/><br/>
///This provides options for customizing export settings
///<br/>exportSettings-ExportSettings	default-
///<br/><br/>
///Specifies the downloading filename
///<br/>filename-string	default-DigitalGauge
///<br/><br/>
///Specifies the format of the file to export
///<br/>type-ej.datavisualization.DigitalGauge.ExportingType|string	default-png
///<br/><br/>
///Specifies the name of the action URL
///<br/>action-string	default-
///<br/><br/>
///Specifies the mode of exporting
///<br/>mode-ej.datavisualization.DigitalGauge.ExportingMode|string	default-client
///<br/><br/>
///Specifies the frame of the Digital gauge.
///<br/>frame-Frame	default-{backgroundImageUrl: null, innerWidth: 6, outerWidth: 10}
///<br/><br/>
///Specifies the URL of an image to be displayed as background of the Digital gauge.
///<br/>backgroundImageUrl-string	default-null
///<br/><br/>
///Specifies the inner width for the frame, when the background image has been set for the Digital gauge..
///<br/>innerWidth-number	default-6
///<br/><br/>
///Specifies the outer width of the frame, when the background image has been set for the Digital gauge.
///<br/>outerWidth-number	default-10
///<br/><br/>
///Specifies the height of the DigitalGauge.
///<br/>height-number	default-150
///<br/><br/>
///Specifies the resize option of the DigitalGauge.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Specifies the responsiveness of the Digital gauge
///<br/>enableResize-boolean	default-false
///<br/><br/>
///Specifies the items for the DigitalGauge.
///<br/>items-Array&lt;Items&gt;	default-null
///<br/><br/>
///Specifies the Character settings for the DigitalGauge.
///<br/>characterSettings-any	default-null
///<br/><br/>
///Specifies the CharacterCount value for the DigitalGauge.
///<br/>count-number	default-4
///<br/><br/>
///Specifies the opacity value for the DigitalGauge.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the value for spacing between the characters
///<br/>spacing-number	default-2
///<br/><br/>
///Specifies the character type for the text to be displayed.
///<br/>type-ej.datavisualization.DigitalGauge.CharacterType|string	default-ej.datavisualization.DigitalGauge.CharacterType.EightCrossEightDotMatrix
///<br/><br/>
///Enable/Disable the custom font to be applied to the text in the gauge.
///<br/>enableCustomFont-boolean	default-false
///<br/><br/>
///Set the specific font for the text, when the enableCustomFont is set to true
///<br/>font-any	default-null
///<br/><br/>
///Set the font family value
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Set the font style for the font
///<br/>fontStyle-ej.datavisualization.DigitalGauge.FontStyle|string	default-italic
///<br/><br/>
///Set the font size value
///<br/>size-string	default-11px
///<br/><br/>
///Set the location for the text, where it needs to be placed within the gauge.
///<br/>position-any	default-null
///<br/><br/>
///Set the horizontal location for the text, where it needs to be placed within the gauge.
///<br/>x-number	default-0
///<br/><br/>
///Set the vertical location for the text, where it needs to be placed within the gauge.
///<br/>y-number	default-0
///<br/><br/>
///Set the segment settings for the digital gauge.
///<br/>segmentSettings-any	default-null
///<br/><br/>
///Set the color for the text segments.
///<br/>color-string	default-null
///<br/><br/>
///Set the gradient for the text segments.
///<br/>gradient-any	default-null
///<br/><br/>
///Set the length for the text segments.
///<br/>length-number	default-2
///<br/><br/>
///Set the opacity for the text segments.
///<br/>opacity-number	default-0
///<br/><br/>
///Set the spacing for the text segments.
///<br/>spacing-number	default-1
///<br/><br/>
///Set the width for the text segments.
///<br/>width-number	default-1
///<br/><br/>
///Set the value for enabling/disabling the blurring effect for the shadows of the text
///<br/>shadowBlur-number	default-0
///<br/><br/>
///Specifies the color of the text shadow.
///<br/>shadowColor-string	default-null
///<br/><br/>
///Set the x offset value for the shadow of the text, indicating the location where it needs to be displayed.
///<br/>shadowOffsetX-number	default-1
///<br/><br/>
///Set the y offset value for the shadow of the text, indicating the location where it needs to be displayed.
///<br/>shadowOffsetY-number	default-1
///<br/><br/>
///Set the alignment of the text that is displayed within the gauge.See TextAlign
///<br/>textAlign-string	default-left
///<br/><br/>
///Specifies the color of the text.
///<br/>textColor-string	default-null
///<br/><br/>
///Specifies the text value.
///<br/>value-string	default-null
///<br/><br/>
///Specifies the matrixSegmentData for the DigitalGauge.
///<br/>matrixSegmentData-any	default-
///<br/><br/>
///Specifies the segmentData for the DigitalGauge.
///<br/>segmentData-any	default-
///<br/><br/>
///Specifies the themes for the Digital gauge. See Themes
///<br/>themes-string	default-flatlight
///<br/><br/>
///Specifies the value to the DigitalGauge.
///<br/>value-string	default-text
///<br/><br/>
///Specifies the width for the Digital gauge.
///<br/>width-number	default-400
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
DocumentEditor:function(){
 /// <signature>
 /// <summary>Constructor of ej.DocumentEditor</summary>
 /// </signature>
}
});
ej.DocumentEditor=(function(){
var original=ej.DocumentEditor
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

load:function(path){
/// <signature>
/// <summary>
/// Loads the document from specified path using web API provided by importUrl.
/// </summary>
/// <param name="path"	type="string">Specifies the file path.</param>
/// </signature>
},
getCurrentPageNumber:function(){
/// <signature>
/// <summary>
/// Gets the page number of current selection in the document.
/// </summary>
},
getPageCount:function(){
/// <signature>
/// <summary>
/// Gets the total number of pages in the document.
/// </summary>
},
getSelectedText:function(){
/// <signature>
/// <summary>
/// Gets the text of current selection in the document.
/// </summary>
},
getZoomFactor:function(){
/// <signature>
/// <summary>
/// Gets the current zoom factor value of the document editor.
/// </summary>
},
setZoomFactor:function(factor){
/// <signature>
/// <summary>
/// Scales the document editor with the specified zoom factor. The range of zoom factor should be 0.10 to 5.00 (10 - 500 %).
/// </summary>
/// <param name="factor"	type="number">Specifies the factor for zooming.</param>
/// </signature>
},
print:function(){
/// <signature>
/// <summary>
/// Prints the document content as page by page.
/// </summary>
},
find:function(text){
/// <signature>
/// <summary>
/// Finds the first occurrence of specified text from current selection and  highlights the result. If the document end is reached, find operation will occur from the document start position.
/// </summary>
/// <param name="text"	type="string">Specifies the text to search in a document.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDocumentEditor=function(){
this.data("ejDocumentEditor",new	ej.DocumentEditor());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDocumentEditor :function (options) {
/// <signature>
/// <summary><br/>
///Document Editor JS is an editor component to view and print DOCX, DOC, RTF and Text documents.<br/><br/>
///Gets or sets an object that indicates initialization of importing and exporting documents in document editor.
///<br/>importExportSettings-ImportExportSettings	default-
///<br/><br/>
///Gets or sets URL of Web API that should be used to parse the document while loading.
///<br/>importUrl-string	default-
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Draggable:function(){
 /// <signature>
 /// <summary>Constructor of ej.Draggable</summary>
 /// </signature>
}
});
ej.Draggable=(function(){
var original=ej.Draggable
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// destroy in the draggable.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDraggable=function(){
this.data("ejDraggable",new	ej.Draggable());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDraggable :function (options) {
/// <signature>
/// <summary><br/>
///Plugin to make any DOM element draggable.<br/><br/>
///If clone is specified.
///<br/>clone-boolean	default-false
///<br/><br/>
///Sets the offset of the dragging helper relative to the mouse cursor.
///<br/>cursorAt-any	default-{ top: -1, left: -2 }
///<br/><br/>
///Distance in pixels after mousedown the mouse must move before dragging should start. This option can be used to prevent unwanted drags when clicking on an element.
///<br/>distance-number	default-1
///<br/><br/>
///The drag area is used to restrict the dragging element bounds.Specify the id of the container within which the element should be dragged.
///<br/>dragArea-boolean	default-null
///<br/><br/>
///If specified, restricts drag start click to the specified element(s).
///<br/>handle-string	default-null
///<br/><br/>
///Used to group sets of draggable and droppable items, in addition to droppable's accept option. A draggable with the same scope value as a droppable will be accepted by the droppable.
///<br/>scope-string	default-&#39;default&#39;
///<br/><br/>
///Used to enable auto scroll while drag and drop the element.
///<br/>autoScroll-boolean	default-&#39;false&#39;
///<br/><br/>
///Represents when to start the scrolling inside the scroll container on dragging
///<br/>scrollSensitivity-number	default-&#39;20&#39;
///<br/><br/>
///Specifies how much distance of scroll should move on dragging once reached scroll sensitivity area.
///<br/>scrollSpeed-number	default-&#39;20&#39;
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
DropDownList:function(){
 /// <signature>
 /// <summary>Constructor of ej.DropDownList</summary>
 /// </signature>
}
});
ej.DropDownList=(function(){
var original=ej.DropDownList
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addItem:function(data){
/// <signature>
/// <summary>
/// Adding a single item or an array of items into the DropDownList allows you to specify all the field attributes such as value, template, image URL, and HTML attributes for those items.Grouping and sorting will not be supported when we add items through this method.
/// </summary>
/// <param name="data"	type="any|any[]"> this parameter should have field attributes with respect to mapped field attributes and it's corresponding values to fields</param>
/// </signature>
},
checkAll:function(){
/// <signature>
/// <summary>
/// This method is used to select all the items in the DropDownList.
/// </summary>
},
clearText:function(){
/// <signature>
/// <summary>
/// Clears the text in the DropDownList textbox.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroys the DropDownList widget.
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// This property is used to disable the DropDownList widget.
/// </summary>
},
disableItemsByIndices:function(index){
/// <signature>
/// <summary>
/// This property disables the set of items in the DropDownList.
/// </summary>
/// <param name="index"	type="string|number|any[]"> disable the given index list items</param>
/// </signature>
},
enable:function(){
/// <signature>
/// <summary>
/// This property enables the DropDownList control.
/// </summary>
},
enableItemsByIndices:function(index){
/// <signature>
/// <summary>
/// Enables an Item or set of Items that are disabled in the DropDownList
/// </summary>
/// <param name="index"	type="string|number|any[]"> enable the given index list items if it's disabled</param>
/// </signature>
},
getItemDataByValue:function(value){
/// <signature>
/// <summary>
/// This method retrieves the items using given value.
/// </summary>
/// <param name="value"	type="string|number|any"> Return the whole object of data based on given value</param>
/// </signature>
},
getListData:function(){
/// <signature>
/// <summary>
/// This method is used to retrieve the items that are bound with the DropDownList.
/// </summary>
},
getSelectedItem:function(){
/// <signature>
/// <summary>
/// This method is used to get the selected items in the DropDownList.
/// </summary>
},
getSelectedValue:function(){
/// <signature>
/// <summary>
/// This method is used to retrieve the items value that are selected in the DropDownList.
/// </summary>
},
hidePopup:function(){
/// <signature>
/// <summary>
/// This method hides the suggestion popup in the DropDownList.
/// </summary>
},
selectItemsByIndices:function(index){
/// <signature>
/// <summary>
/// This method is used to select the list of items in the DropDownList through the Index of the items.
/// </summary>
/// <param name="index"	type="string|number|any[]"> select the given index list items</param>
/// </signature>
},
selectItemByText:function(index){
/// <signature>
/// <summary>
/// This method is used to select an item in the DropDownList by using the given text value.
/// </summary>
/// <param name="index"	type="string|number|any[]"> select the list items relates to given text</param>
/// </signature>
},
selectItemByValue:function(index){
/// <signature>
/// <summary>
/// This method is used to select an item in the DropDownList by using the given value.
/// </summary>
/// <param name="index"	type="string|number|any[]"> select the list items relates to given values</param>
/// </signature>
},
showPopup:function(){
/// <signature>
/// <summary>
/// This method shows the DropDownList control with the suggestion popup.
/// </summary>
},
unCheckAll:function(){
/// <signature>
/// <summary>
/// This method is used to unselect all the items in the DropDownList.
/// </summary>
},
unselectItemsByIndices:function(index){
/// <signature>
/// <summary>
/// This method is used to unselect the list of items in the DropDownList through Index of the items.
/// </summary>
/// <param name="index"	type="string|number|any[]"> unselect the given index list items</param>
/// </signature>
},
unselectItemByText:function(index){
/// <signature>
/// <summary>
/// This method is used to unselect an item in the DropDownList by using the given text value.
/// </summary>
/// <param name="index"	type="string|number|any[]"> unselect the list items relates to given text</param>
/// </signature>
},
unselectItemByValue:function(index){
/// <signature>
/// <summary>
/// This method is used to unselect an item in the DropDownList by using the given value.
/// </summary>
/// <param name="index"	type="string|number|any[]"> unselect the list items relates to given values</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDropDownList=function(){
this.data("ejDropDownList",new	ej.DropDownList());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDropDownList :function (options) {
/// <signature>
/// <summary><br/>
///The DropDownList control provides a list of options to choose an item from the list. It can including other HTML elements such as images, textboxes, check box, radio buttons, and so on.<br/><br/>
///The Virtual Scrolling(lazy loading) feature is used to display a large amount of data that you require without buffering the entire load of a huge database records in the DropDownList, that is, when scrolling, an AJAX request is sent to fetch some amount of data from the server dynamically. To achieve this scenario with DropDownList, set the allowVirtualScrolling to true.
///<br/>allowVirtualScrolling-boolean	default-false
///<br/><br/>
///The cascading DropDownLists is a series of two or more DropDownLists in which each DropDownList is filtered according to the previous DropDownListâ€™s value.
///<br/>cascadeTo-string	default-null
///<br/><br/>
///Sets the case sensitivity of the search operation. It supports both enableFilterSearch and enableIncrementalSearch property.
///<br/>caseSensitiveSearch-boolean	default-false
///<br/><br/>
///Dropdown widget's style and appearance can be controlled based on 13 different default built-in themes.You can customize the appearance of the dropdown by using the cssClass property. You need to specify a class name in the cssClass property and the same class name is used before the class definitions wherever the custom styles are applied.
///<br/>cssClass-string	default-
///<br/><br/>
///This property is used to serve data from the data services based on the query provided. To bind the data to the dropdown widget, the dataSource property is assigned with the instance of the ej.DataManager.
///<br/>dataSource-any	default-null
///<br/><br/>
///Sets the separator when the multiSelectMode with delimiter option or checkbox is enabled with the dropdown. When you enter the delimiter value, the texts after the delimiter are considered as a separate word or query. The delimiter string is a single character and must be a symbol. Mostly, the delimiter symbol is used as comma (,) or semi-colon (;) or any other special character.
///<br/>delimiterChar-string	default-&#39;,&#39;
///<br/><br/>
///The enabled Animation property uses the easeOutQuad animation to SlideDown and SlideUp the Popup list in 200 and 100 milliseconds, respectively.
///<br/>enableAnimation-boolean	default-false
///<br/><br/>
///This property is used to indicate whether the DropDownList control responds to the user interaction or not. By default, the control is in the enabled mode and you can disable it by setting it to false.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Specifies to perform incremental search for the selection of items from the DropDownList with the help of this property. This helps in selecting the item by using the typed character.
///<br/>enableIncrementalSearch-boolean	default-true
///<br/><br/>
///This property selects the item in the DropDownList when the item is entered in the Search textbox.
///<br/>enableFilterSearch-boolean	default-false
///<br/><br/>
///The serverfiltering is to perform filter action when text is typed in the search box and filtering will be done based on the collection which contains the matched item from entire datasource. Serverfiltering will be done based on the entire items in DataSource.
///<br/>enableServerFiltering-boolean	default-false
///<br/><br/>
///Saves the current model value to the browser cookies for state maintenance. While refreshing the DropDownList control page, it retains the model value and it is applied from the browser cookies.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///This enables the resize handler to resize the popup to any size.
///<br/>enablePopupResize-boolean	default-false
///<br/><br/>
///Sets the DropDownList textbox direction from right to left align.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///This property is used to sort the Items in the DropDownList. By default, it sorts the items in an ascending order.
///<br/>enableSorting-boolean	default-false
///<br/><br/>
///The property is used to determine whether the popup list is generated dynamically.
///<br/>loadOnDemand-boolean	default-false
///<br/><br/>
///Specifies the mapping fields for the data items of the DropDownList.
///<br/>fields-Fields	default-null
///<br/><br/>
///Used to group the items.
///<br/>groupBy-string	default-
///<br/><br/>
///Defines the HTML attributes such as ID, class, and styles for the item.
///<br/>htmlAttributes-any	default-
///<br/><br/>
///Defines the ID for the tag.
///<br/>id-string	default-
///<br/><br/>
///Defines the image attributes such as height, width, styles, and so on.
///<br/>imageAttributes-string	default-
///<br/><br/>
///Defines the imageURL for the image location.
///<br/>imageUrl-string	default-
///<br/><br/>
///Defines the tag value to be selected initially.
///<br/>selected-boolean	default-
///<br/><br/>
///Defines the sprite CSS for the image tag.
///<br/>spriteCssClass-string	default-
///<br/><br/>
///Defines the table name for tag value or display text while rendering remote data.
///<br/>tableName-string	default-
///<br/><br/>
///Defines the text content for the tag.
///<br/>text-string	default-
///<br/><br/>
///Defines the tag value.
///<br/>value-string	default-
///<br/><br/>
///When the enableFilterSearch property value is set to true, the values in the DropDownList shows the items starting with or containing the key word/letter typed in the Search textbox.
///<br/>filterType-ej.FilterType|string	default-ej.FilterType.Contains
///<br/><br/>
///Used to create visualized header for dropdown items
///<br/>headerTemplate-string	default-null
///<br/><br/>
///Defines the height of the DropDownList textbox.
///<br/>height-string|number	default-null
///<br/><br/>
///It sets the given HTML attributes for the DropDownList control such as ID, name, disabled, etc.
///<br/>htmlAttributes-any	default-null
///<br/><br/>
///Data can be fetched in the DropDownList control by using the DataSource, specifying the number of items.
///<br/>itemsCount-number	default-5
///<br/><br/>
///Allows the user to set the particular country or region language for the DropDownList.
///<br/>locale-string	default-en-US
///<br/><br/>
///Defines the maximum height of the suggestion box. This property restricts the maximum height of the popup when resize is enabled.
///<br/>maxPopupHeight-string|number	default-null
///<br/><br/>
///Defines the minimum height of the suggestion box. This property restricts the minimum height of the popup when resize is enabled.
///<br/>minPopupHeight-string|number	default-null
///<br/><br/>
///Defines the maximum width of the suggestion box. This property restricts the maximum width of the popup when resize is enabled.
///<br/>maxPopupWidth-string|number	default-null
///<br/><br/>
///Defines the minimum height of the suggestion box. This property restricts the minimum height of the popup when resize is enabled.
///<br/>minPopupWidth-string|number	default-0
///<br/><br/>
///With the help of this property, you can make a single or multi selection with the DropDownList and display the text in two modes, delimiter and visual mode. In delimiter mode, you can separate the items by using the delimiter character such as comma (,) or semi-colon (;) or any other special character. In the visual mode, the items are showcased like boxes with close icon in the textbox.
///<br/>multiSelectMode-ej.MultiSelectMode|string	default-ej.MultiSelectMode.None
///<br/><br/>
///Defines the height of the suggestion popup box in the DropDownList control.
///<br/>popupHeight-string|number	default-152px
///<br/><br/>
///Defines the width of the suggestion popup box in the DropDownList control.
///<br/>popupWidth-string|number	default-auto
///<br/><br/>
///Specifies the query to retrieve the data from the DataSource.
///<br/>query-any	default-null
///<br/><br/>
///Specifies that the DropDownList textbox values should be read-only.
///<br/>readOnly-boolean	default-false
///<br/><br/>
///Specifies an item to be selected in the DropDownList.
///<br/>selectedIndex-number	default-null
///<br/><br/>
///Specifies the selectedItems for the DropDownList.
///<br/>selectedIndices-Array&lt;any&gt;	default-[]
///<br/><br/>
///Selects multiple items in the DropDownList with the help of the checkbox control. To achieve this, enable the showCheckbox option to true.
///<br/>showCheckbox-boolean	default-false
///<br/><br/>
///DropDownList control is displayed with the popup seen.
///<br/>showPopupOnLoad-boolean	default-false
///<br/><br/>
///DropDownList textbox displayed with the rounded corner style.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///When the enableSorting property value is set to true, this property helps to sort the items either in ascending or descending order
///<br/>sortOrder-ej.SortOrder|string	default-ej.SortOrder.Ascending
///<br/><br/>
///Specifies the targetID for the DropDownListâ€™s items.
///<br/>targetID-string	default-null
///<br/><br/>
///By default, you can add any text or image to the DropDownList item. To customize the item layout or to create your own visualized elements, you can use this template support.
///<br/>template-string	default-null
///<br/><br/>
///Defines the text value that is displayed in the DropDownList textbox.
///<br/>text-string	default-null
///<br/><br/>
///Sets the jQuery validation error message in the DropDownList
///<br/>validationMessage-any	default-null
///<br/><br/>
///Sets the jQuery validation rules in the Dropdownlist.
///<br/>validationRules-any	default-null
///<br/><br/>
///Specifies the value (text content) for the DropDownList control.
///<br/>value-string|number	default-null
///<br/><br/>
///Specifies a short hint that describes the expected value of the DropDownList control.
///<br/>watermarkText-string	default-null
///<br/><br/>
///Defines the width of the DropDownList textbox.
///<br/>width-string|number	default-null
///<br/><br/>
///The Virtual Scrolling feature is used to display a large amount of records in the DropDownList, that is, when scrolling, an AJAX request is sent to fetch some amount of data from the server dynamically. To achieve this scenario with DropDownList, set the allowVirtualScrolling to true. You can set the itemsCount property that represents the number of items to be fetched from the server on every AJAX request.
///<br/>virtualScrollMode-ej.VirtualScrollMode|string	default-normal
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
DropDownTree:function(){
 /// <signature>
 /// <summary>Constructor of ej.DropDownTree</summary>
 /// </signature>
}
});
ej.DropDownTree=(function(){
var original=ej.DropDownTree
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

checkAll:function(){
/// <signature>
/// <summary>
/// Checks all the nodes in the DropDownTree.
/// </summary>
},
checkNode:function(element){
/// <signature>
/// <summary>
/// Checks a node in the DropDownTree.
/// </summary>
/// <param name="element"	type="string|any|any[]"> ID of the DropDownTree node/object of the DropDownTree node/collection of the ID/object of the DropDownTree nodes.</param>
/// </signature>
},
clearText:function(){
/// <signature>
/// <summary>
/// Clears the text in the DropDownTree.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroys the DropDownTree control.
/// </summary>
},
getValue:function(){
/// <signature>
/// <summary>
/// Returns the selected value.
/// </summary>
},
hidePopup:function(){
/// <signature>
/// <summary>
/// Hides the popup in the DropDownTree.
/// </summary>
},
moveNode:function(sourceNode, destinationNode, index){
/// <signature>
/// <summary>
/// Moves the DropDownTree node within the same DropDownTree. The new position of the given DropDownTree node will be based on destination node and index position.
/// </summary>
/// <param name="sourceNode"	type="string|any">ID of the DropDownTree node/object of the DropDownTree node.</param>
/// </signature>
/// <signature>
/// <summary>
/// Moves the DropDownTree node within the same DropDownTree. The new position of the given DropDownTree node will be based on destination node and index position.
/// </summary>
/// <param name="destinationNode"	type="string|any">ID of the DropDownTree node/object of the DropDownTree node.</param>
/// </signature>
/// <signature>
/// <summary>
/// Moves the DropDownTree node within the same DropDownTree. The new position of the given DropDownTree node will be based on destination node and index position.
/// </summary>
/// <param name="index"	type="number">New index position of the given source node.</param>
/// </signature>
},
removeAll:function(){
/// <signature>
/// <summary>
/// Removes all the nodes in the DropDownTree.
/// </summary>
},
removeNode:function(element){
/// <signature>
/// <summary>
/// Removes a node in the DropDownTree.
/// </summary>
/// <param name="element"	type="string|any|any[]"> ID of the DropDownTree node/object of the DropDownTree node/collectionof the ID/object of the DropDownTree nodes.</param>
/// </signature>
},
selectAll:function(){
/// <signature>
/// <summary>
/// Selects all the DropDownTree nodes when allowMultiSelection field is enabled in the treeViewSettings property.
/// </summary>
},
selectNode:function(element){
/// <signature>
/// <summary>
/// Selects a node in the DropDownTree control. To select the collection of nodes in the DropDownTree control, enable allowMultiSelection field of the treeViewSettings property.
/// </summary>
/// <param name="element"	type="string|any|any[]"> ID of the DropDownTree node/object of the DropDownTree node/ collection of I the D/object of the DropDownTree nodes.</param>
/// </signature>
},
showPopup:function(){
/// <signature>
/// <summary>
/// Shows the DropDownTree control with the popup.
/// </summary>
},
unCheckAll:function(){
/// <signature>
/// <summary>
/// Unchecks all the nodes in the DropDownTree.
/// </summary>
},
unCheckNode:function(element){
/// <signature>
/// <summary>
/// Unchecks a node in the DropDownTree.
/// </summary>
/// <param name="element"	type="string|any|any[]">ID of the DropDownTree node/object of the DropDownTree node/collection of the ID/object of the DropDownTree nodes.</param>
/// </signature>
},
unselectAll:function(){
/// <signature>
/// <summary>
/// Unselects all the DropDownTree nodes when allowMultiSelection field of the treeViewSettings property is enabled.
/// </summary>
},
unselectNode:function(element){
/// <signature>
/// <summary>
/// Unselects a node in the DropDownTree control. To unselect the collection of nodes in the DropDownTree control, enable allowMultiSelection field of the treeViewSettings property.
/// </summary>
/// <param name="element"	type="string|any|any[]"> ID of the DropDownTree node/object of the DropDownTree node/ collection of the ID/object of the DropDownTree nodes.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDropDownTree=function(){
this.data("ejDropDownTree",new	ej.DropDownTree());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDropDownTree :function (options) {
/// <signature>
/// <summary><br/>
///The DropDownTree control provides a list of hierarchical data to choose an item from the list.It can including other HTML elements such as images, textboxes, check box, radio buttons, and so on.<br/><br/>
///Uses the keyboard for any action, including opening and closing the drop-down tree; navigating, expanding, and collapsing nodes of the dropdown tree; and more.
///<br/>allowKeyboardNavigation-boolean	default-true
///<br/><br/>
///Sets the root CSS class for DropDownTree that allows customization of appearance.
///<br/>cssClass-string	default-``
///<br/><br/>
///Sets the separator when the multiSelectMode with delimiter option or checkbox is enabled. When you enter the delimiter value, the text after the delimiter is considered as a separate word or query. The delimiter string is a single character and must be a symbol. Mostly, the delimiter symbol is used as comma (,), semi-colon (;), or any other special character.
///<br/>delimiter-string	default-,
///<br/><br/>
///Indicates whether the DropDownTree control responds to user interaction or not. By default, the control is in the enabled mode and can be disabled by setting this to false.
///<br/>enabled-boolean	default-true
///<br/><br/>
///The enabled animation property uses the easeOutQuad animation to SlideDown and SlideUp the popup wrapper in 200 and 100 milliseconds, respectively.
///<br/>enableAnimation-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to continue the DropDownTree model state in the page using applicable medium, i.e., HTML5 localStorage or cookies.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Sets the DropDownTree textbox direction from right to left alignment.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Creates footer with text or HTML elements for the dropdown items.
///<br/>footerTemplate-string	default-null
///<br/><br/>
///Serves as a patch of the entries comprising the path (that is set in the entry area) of the selected node.
///<br/>fullPathDelimiter-string	default-&#39;/&#39;
///<br/><br/>
///Creates header with text or HTML elements for the dropdown items.
///<br/>headerTemplate-string	default-null
///<br/><br/>
///Defines the height of the DropDownTree textbox.
///<br/>height-string|number	default-
///<br/><br/>
///Allows you to set a particular country or regional language for the DropDownTree.
///<br/>locale-string	default-en-US
///<br/><br/>
///Customizes the height and width of the popup wrapper.
///<br/>popupSettings-PopupSettings	default-{height: &#39;152px&#39;,width: &#39;auto&#39;,showPopupOnLoad: false}
///<br/><br/>
///Defines the height of the popup wrapper in the DropDownTree control.
///<br/>height-string|number	default-
///<br/><br/>
///Defines the width of the popup wrapper in the DropDownTree control.
///<br/>width-string|number	default-
///<br/><br/>
///The DropDownTree control is displayed with the popup.
///<br/>showPopupOnLoad-boolean	default-
///<br/><br/>
///Specifies that the DropDownTree textbox values should be read-only.
///<br/>readOnly-boolean	default-false
///<br/><br/>
///The DropDownTree's textbox is displayed with rounded corner style.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Specifies the targetID for the DropDownTree's items.
///<br/>targetID-string	default-null
///<br/><br/>
///Specifies the delimiter between nodes (indicating their hierarchy).
///<br/>textMode-ej.Textmode|string	default-ej.DropDownTree.TextMode.none
///<br/><br/>
///Sets the jQuery validation error message in the DropDownTree.
///<br/>validationMessage-any	default-null
///<br/><br/>
///Sets the jQuery validation rules in the DropDownTree.
///<br/>validationRules-any	default-null
///<br/><br/>
///Specifies the value (text content) for the DropDownTree control. For the single selection mode, the selected item's value will be returned in its data type, and for MultiSelectMode, returns the selected items values separated by delimiter in string type.
///<br/>value-string	default-null
///<br/><br/>
///Specifies a short hint that describes the expected value of the DropDownTree control.
///<br/>watermarkText-string	default-null
///<br/><br/>
///Defines the width of the DropDownTree textbox.
///<br/>width-string|number	default-100%
///<br/><br/>
///Defines the popup settings of the DropDownTree widget. You can use any property which are in treeview using this property.
///<br/>treeViewSettings-any	default-{}
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Droppable:function(){
 /// <signature>
 /// <summary>Constructor of ej.Droppable</summary>
 /// </signature>
}
});
ej.Droppable=(function(){
var original=ej.Droppable
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// destroy in the Droppable.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejDroppable=function(){
this.data("ejDroppable",new	ej.Droppable());
return this;
};
intellisense.annotate(jQuery.fn,{
ejDroppable :function (options) {
/// <signature>
/// <summary><br/>
///Plugin to make any DOM element Droppable.<br/><br/>
///Used to accept the specified draggable items.
///<br/>accept-any	default-null
///<br/><br/>
///Used to group sets of droppable items, in addition to droppable's accept option. A draggable with the same scope value as a droppable will be accepted by the droppable.
///<br/>scope-string	default-&#39;default&#39;
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
FileExplorer:function(){
 /// <signature>
 /// <summary>Constructor of ej.FileExplorer</summary>
 /// </signature>
}
});
ej.FileExplorer=(function(){
var original=ej.FileExplorer
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

adjustSize:function(){
/// <signature>
/// <summary>
/// Refresh the size of FileExplorer control.
/// </summary>
},
disableMenuItem:function(item){
/// <signature>
/// <summary>
/// Disable the particular context menu item.
/// </summary>
/// <param name="item"	type="string|HTMLElement">Id of the menu item/ Menu element to be disabled </param>
/// </signature>
},
disableToolbarItem:function(item){
/// <signature>
/// <summary>
/// Disable the particular toolbar item.
/// </summary>
/// <param name="item"	type="string|HTMLElement">Id of the toolbar item/ Tool item element to be disabled </param>
/// </signature>
},
enableMenuItem:function(item){
/// <signature>
/// <summary>
/// Enable the particular context menu item.
/// </summary>
/// <param name="item"	type="string|HTMLElement">Id of the menu item/ Menu element to be Enabled </param>
/// </signature>
},
enableToolbarItem:function(item){
/// <signature>
/// <summary>
/// Enable the particular toolbar item
/// </summary>
/// <param name="item"	type="string|HTMLElement">Id of the tool item/ Tool item element to be Enabled </param>
/// </signature>
},
refresh:function(){
/// <signature>
/// <summary>
/// Refresh the content of the selected folder in FileExplorer control.
/// </summary>
},
removeToolbarItem:function(item){
/// <signature>
/// <summary>
/// Remove the particular toolbar item.
/// </summary>
/// <param name="item"	type="string|HTMLElement">Id of the tool item/ tool item element to be removed </param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejFileExplorer=function(){
this.data("ejFileExplorer",new	ej.FileExplorer());
return this;
};
intellisense.annotate(jQuery.fn,{
ejFileExplorer :function (options) {
/// <signature>
/// <summary><br/>
///FileExplorer provides a Windows Explorer-like functionality for any web application. It allows end-users to browse, select and upload files or change the folder structure by renaming, moving and deleting files or folders. File and folder management capabilities are fully customizable and can be disabled when necessary.<br/><br/>
///Sets the URL of server side AJAX handling method that handles file operation like Read, Remove, Rename, Create, Upload, Download, Copy and Move in FileExplorer.
///<br/>ajaxAction-string	default-
///<br/><br/>
///Specifies the data type of server side AJAX handling method.
///<br/>ajaxDataType-string	default-json
///<br/><br/>
///By using ajaxSettings property, you can customize the AJAX configurations. Normally you can customize the following option in AJAX handling data, URL, type, async, contentType, dataType and success. For upload, download and getImage API, you can only customize URL.
///<br/>ajaxSettings-any	default-{ read: {}, createFolder: {}, remove: {}, rename: {}, paste: {}, getDetails: {}, download: {}, upload: {}, getImage: {}, search: {}}
///<br/><br/>
///The FileExplorer allows to move the files from one folder to another folder of FileExplorer by using drag and drop option. Also it supports to upload a file by dragging it from windows explorer to the necessary folder of ejFileExplorer.
///<br/>allowDragAndDrop-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable keyboard support for FileExplorer actions.
///<br/>allowKeyboardNavigation-boolean	default-true
///<br/><br/>
///The FileExplorer allows to select multiple files by enabling the allowMultiSelection property. You can perform multi selection by pressing the Ctrl key or Shift key.
///<br/>allowMultiSelection-boolean	default-true
///<br/><br/>
///By using the contextMenuSettings property, you can customize the ContextMenu in the FileExplorer control.
///<br/>contextMenuSettings-ContextMenuSettings	default-
///<br/><br/>
///The items property is used to configure and group the required ContextMenu items in FileExplorer control.
///<br/>items-any	default-{% highlight javascript %}{navbar: [NewFolder, Upload, |, Delete, Rename, |, Cut, Copy, Paste, |, Getinfo],cwd: [Refresh, Paste,|, SortBy, |, NewFolder, Upload, |, Getinfo],files: [Open, Download, |, Upload, |, Delete, Rename, |, Cut, Copy, Paste, |, OpenFolderLocation, Getinfo]}{% endhighlight %}
///<br/><br/>
///The customMenuFields property is used to define custom functionality for custom ContextMenu item's which are defined in items property.
///<br/>customMenuFields-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the root class for FileExplorer theme. This cssClass API allows to use custom skinning option for File Explorer control. By defining the root class by using this API, you have to include this root class in CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Specify the enablePersistence to FileExplorer to save the current model value in browser cookies for state maintains.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Enables or disables the resize support in FileExplorer control.
///<br/>enableResize-boolean	default-false
///<br/><br/>
///Enables or disables the Right to Left alignment support in FileExplorer control.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Enables or disables the thumbnail image compression option in FileExplorer control. By enabling this option, you can reduce the thumbnail image size while loading.
///<br/>enableThumbnailCompress-boolean	default-false
///<br/><br/>
///Allows specified type of files only to display in FileExplorer control.
///<br/>fileTypes-string	default-* . *
///<br/><br/>
///By using filterSettings property, you can customize the search functionality of the search bar in FileExplorer control.
///<br/>filterSettings-FilterSettings	default-
///<br/><br/>
///It allows to search the text given in search Textbox in every keyup event. When this property was set as false, searching will works only on Enter key and searchbar blur.
///<br/>allowSearchOnTyping-boolean	default-true
///<br/><br/>
///Enables or disables to perform the filter operation with case sensitive.
///<br/>caseSensitiveSearch-boolean	default-false
///<br/><br/>
///Sets the search filter type. There are several filter types available such as "startswith", "contains", "endswith". See filterType.
///<br/>filterType-ej.FilterType|string	default-ej.FileExplorer.filterType.Contains
///<br/><br/>
///By using the gridSettings property, you can customize the grid behavior in the FileExplorer control.
///<br/>gridSettings-GridSettings	default-
///<br/><br/>
///Allows to Resize the width of the columns by simply click and move the particular column header line.
///<br/>allowResizing-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable the dynamic sorting behavior on grid data. Sorting can be done through clicking on particular column header.
///<br/>allowSorting-boolean	default-true
///<br/><br/>
///Gets or sets an object that indicates to render the grid with specified columns. You can use this property same as the column property in Grid control.
///<br/>columns-Array&lt;any&gt;	default-[{ field: name, headerText: Name, width: 30% }, { field: dateModified, headerText: Date Modified, width: 30% }, { field: type, headerText: Type, width: 15% }, { field: size, headerText: Size, width: 12%, textAlign: right, headerTextAlign: left }]
///<br/><br/>
///Specifies the height of FileExplorer control.
///<br/>height-string|number	default-400
///<br/><br/>
///Enables or disables the responsive support for FileExplorer control during the window resizing time.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Sets the file view type. There are three view types available such as Grid, Tile and Large icons. See layoutType.
///<br/>layout-ej.FileExplorer.layoutType|string	default-ej.FileExplorer.layoutType.Grid
///<br/><br/>
///Sets the culture in FileExplorer.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the maximum height of FileExplorer control.
///<br/>maxHeight-string|number	default-null
///<br/><br/>
///Sets the maximum width of FileExplorer control.
///<br/>maxWidth-string|number	default-null
///<br/><br/>
///Sets the minimum height of FileExplorer control.
///<br/>minHeight-string|number	default-250px
///<br/><br/>
///Sets the minimum width of FileExplorer control.
///<br/>minWidth-string|number	default-400px
///<br/><br/>
///The property path denotes the filesystem path that are to be explored. The path for the filesystem can be physical path or relative path, but it has to be relevant to where the Web API is hosted.
///<br/>path-string	default-
///<br/><br/>
///Sets the alias name of root folder name in FileExplorer. It is used to replace the actual root folder name in FileExplorer.
///<br/>rootFolderName-string	default-
///<br/><br/>
///The selectedFolder is used to select the specified folder of FileExplorer control.
///<br/>selectedFolder-string	default-
///<br/><br/>
///The selectedItems is used to select the specified items (file, folder) of FileExplorer control.
///<br/>selectedItems-string|Array&lt;any&gt;	default-
///<br/><br/>
///Enables or disables the checkbox option in FileExplorer control.
///<br/>showCheckbox-boolean	default-true
///<br/><br/>
///Enables or disables the context menu option in FileExplorer control.
///<br/>showContextMenu-boolean	default-true
///<br/><br/>
///Enables or disables the footer in FileExplorer control. The footer element displays the details of the current selected files and folders. And also the footer having the switcher to change the layout view.
///<br/>showFooter-boolean	default-true
///<br/><br/>
///FileExplorer control is displayed with rounded corner when this property is set to true.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///FileExplorer control is rendered with thumbnail preview of images in Tile and LargeIcons layout when this property set to true.
///<br/>showThumbnail-boolean	default-true
///<br/><br/>
///Shows or disables the toolbar in FileExplorer control.
///<br/>showToolbar-boolean	default-true
///<br/><br/>
///Enables or disables the navigation pane in FileExplorer control. The navigation pane contains a tree view element that displays all the folders from the filesystem in a hierarchical manner. This is useful to a quick navigation of any folder in the filesystem.
///<br/>showNavigationPane-boolean	default-true
///<br/><br/>
///The tools property is used to configure and group required toolbar items in FileExplorer control.
///<br/>tools-any	default-{ creation: [NewFolder], navigation: [Back, Forward, Upward], addressBar: [Addressbar], editing: [Refresh, Upload, Delete, Rename, Download], copyPaste: [Cut, Copy, Paste], getProperties: [Details], searchBar: [Searchbar], layout: [Layout], sortBy: [SortBy]}
///<br/><br/>
///The toolsList property is used to arrange the toolbar items in the FileExplorer control.
///<br/>toolsList-Array&lt;any&gt;	default-[layout, creation, navigation, addressBar, editing, copyPaste, sortBy, getProperties, searchBar]
///<br/><br/>
///Gets or sets an object that indicates whether to customize the upload behavior in the FileExplorer.
///<br/>uploadSettings-UploadSettings	default-
///<br/><br/>
///Enables or disables the multiple files upload. When it is enabled, you can upload multiple files at a time and when disabled, you can upload only one file at a time.
///<br/>allowMultipleFile-boolean	default-true
///<br/><br/>
///Enables or disables the auto upload option while uploading files in FileExplorer control.
///<br/>autoUpload-boolean	default-false
///<br/><br/>
///Specifies the actions for upload dialog during initialization.
///<br/>dialogAction-any	default-{ modal:false, closeOnComplete:false, content:null, drag:true }
///<br/><br/>
///Specifies the position at which the upload dialog is displayed using X and Y values. X: Sets the left position value for dialog. Y: Sets the top position value for dialog.
///<br/>dialogPosition-any	default-null
///<br/><br/>
///Specifies the maximum file size allowed to upload. It accepts the value in bytes.
///<br/>maxFileSize-number	default-31457280
///<br/><br/>
///Specifies the file details which are to be displayed when selected for upload by setting the showFileDetails to true.
///<br/>showFileDetails-boolean	default-true
///<br/><br/>
///Specifies the virtual item count for virtual support.
///<br/>virtualItemCount-number	default-0
///<br/><br/>
///Specifies the width of FileExplorer control.
///<br/>width-string|number	default-850
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Gantt:function(){
 /// <signature>
 /// <summary>Constructor of ej.Gantt</summary>
 /// </signature>
}
});
ej.Gantt=(function(){
var original=ej.Gantt
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addRecord:function(data, rowPosition){
/// <signature>
/// <summary>
/// To add a new item in Gantt
/// </summary>
/// <param name="data"	type="any">Item to add in Gantt row.</param>
/// </signature>
/// <signature>
/// <summary>
/// To add a new item in Gantt
/// </summary>
/// <param name="rowPosition"	type="string">Defines in which position the row wants to add</param>
/// </signature>
},
cancelEdit:function(){
/// <signature>
/// <summary>
/// To cancel the edited state of an item in Gantt
/// </summary>
},
clearFilter:function(){
/// <signature>
/// <summary>
/// To clear all the filtered columns in Gantt.
/// </summary>
},
clearSorting:function(){
/// <signature>
/// <summary>
/// To clear the sorted columns in Gantt.
/// </summary>
},
collapseAllItems:function(){
/// <signature>
/// <summary>
/// To collapse all the parent items in Gantt
/// </summary>
},
deleteDependency:function(fromTaskId, toTaskId){
/// <signature>
/// <summary>
/// To delete the dependency between the two tasks.
/// </summary>
/// <param name="fromTaskId"	type="number">taskID of predecessor task</param>
/// </signature>
/// <signature>
/// <summary>
/// To delete the dependency between the two tasks.
/// </summary>
/// <param name="toTaskId"	type="number">taskID of successor task</param>
/// </signature>
},
deleteItem:function(){
/// <signature>
/// <summary>
/// To delete a selected item in Gantt
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// destroy the Gantt widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
expandAllItems:function(){
/// <signature>
/// <summary>
/// To Expand all the parent items in Gantt
/// </summary>
},
expandCollapseRecord:function(taskId){
/// <signature>
/// <summary>
/// To expand and collapse an item in Gantt using item's ID
/// </summary>
/// <param name="taskId"	type="number">Expand or Collapse a record based on task id.</param>
/// </signature>
},
export:function(action, serverEvent, multipleExport){
/// <signature>
/// <summary>
/// Export the Gantt content to excel or PDF document.
/// </summary>
/// <param name="action"	type="string">Pass the controller action name corresponding to exporting</param>
/// </signature>
/// <signature>
/// <summary>
/// Export the Gantt content to excel or PDF document.
/// </summary>
/// <param name="serverEvent"	type="string">optionalASP server event name corresponding to exporting</param>
/// </signature>
/// <signature>
/// <summary>
/// Export the Gantt content to excel or PDF document.
/// </summary>
/// <param name="multipleExport"	type="boolean">optionalPass the multiple exporting value as true/false</param>
/// </signature>
},
filterColumn:function(fieldName, filterOperator, filterValue, predicate, matchCase){
/// <signature>
/// <summary>
/// Sends filtering request to filter a column in Gantt dynamically.
/// </summary>
/// <param name="fieldName"	type="string">Pass the field name of the column.</param>
/// </signature>
/// <signature>
/// <summary>
/// Sends filtering request to filter a column in Gantt dynamically.
/// </summary>
/// <param name="filterOperator"	type="string">string/integer/date operator.</param>
/// </signature>
/// <signature>
/// <summary>
/// Sends filtering request to filter a column in Gantt dynamically.
/// </summary>
/// <param name="filterValue"	type="string">Pass the value to be filtered in a column.</param>
/// </signature>
/// <signature>
/// <summary>
/// Sends filtering request to filter a column in Gantt dynamically.
/// </summary>
/// <param name="predicate"	type="string">Optional - Pass the predicate as and/or.</param>
/// </signature>
/// <signature>
/// <summary>
/// Sends filtering request to filter a column in Gantt dynamically.
/// </summary>
/// <param name="matchCase"	type="boolean">Optional - pass the match case value as true/false.</param>
/// </signature>
},
filterContent:function(ejPredicate){
/// <signature>
/// <summary>
/// To filter multiple columns with multiple conditions dynamically in Gantt.
/// </summary>
/// <param name="ejPredicate"	type="Gantt.EjPredicate">Pass the filtering column details and conditions as ejPredicate instance. The ejPredicate object is defined as fieldName,filterOperator, filterValue and ignoreCase properties.</param>
/// </signature>
},
getColumns:function(){
/// <signature>
/// <summary>
/// To get available column collection in Gantt.
/// </summary>
},
getResourceViewEditColumns:function(){
/// <signature>
/// <summary>
/// To get the column collection which are used to edit the task by using task add/edit dialog in resource view.
/// </summary>
},
hideColumn:function(headerText){
/// <signature>
/// <summary>
/// To hide the column by using header text
/// </summary>
/// <param name="headerText"	type="string">you can pass a header text of a column to hide</param>
/// </signature>
},
indentItem:function(){
/// <signature>
/// <summary>
/// To indent a selected item in Gantt
/// </summary>
},
openAddDialog:function(){
/// <signature>
/// <summary>
/// To Open the dialog to add new task to the Gantt
/// </summary>
},
openEditDialog:function(){
/// <signature>
/// <summary>
/// To Open the dialog to edit existing task to the Gantt
/// </summary>
},
outdentItem:function(){
/// <signature>
/// <summary>
/// To outdent a selected item in Gantt
/// </summary>
},
saveEdit:function(){
/// <signature>
/// <summary>
/// To save the edited state of an item in Gantt
/// </summary>
},
searchItem:function(searchString){
/// <signature>
/// <summary>
/// To search an item with search string provided at the run time
/// </summary>
/// <param name="searchString"	type="string">you can pass a text to search in Gantt Control.</param>
/// </signature>
},
selectCells:function(Indexes, preservePreviousSelectedCell){
/// <signature>
/// <summary>
/// To select cell based on the cell and row index dynamically.
/// </summary>
/// <param name="Indexes"	type="any[]">array of cell indexes to be select</param>
/// </signature>
/// <signature>
/// <summary>
/// To select cell based on the cell and row index dynamically.
/// </summary>
/// <param name="preservePreviousSelectedCell"	type="boolean">Defines that we need to preserve the previously selected cells of not</param>
/// </signature>
},
selectMultipleRows:function(rowIndexes){
/// <signature>
/// <summary>
/// To select multiple rows dynamically.
/// </summary>
/// <param name="rowIndexes"	type="any[]">array of row indexes to select</param>
/// </signature>
},
setScrollTop:function(Top){
/// <signature>
/// <summary>
/// Method to set scroll top value for Gantt control.
/// </summary>
/// <param name="Top"	type="number">Pass a value to set top position of vertical scroll bar.</param>
/// </signature>
},
setSplitterIndex:function(index){
/// <signature>
/// <summary>
/// Positions the splitter by the specified column index.
/// </summary>
/// <param name="index"	type="number">Set the splitter position based on column index.</param>
/// </signature>
},
setSplitterPosition:function(width){
/// <signature>
/// <summary>
/// To set the grid width in Gantt
/// </summary>
/// <param name="width"	type="string">you can give either percentage or pixels value</param>
/// </signature>
},
showColumn:function(headerText){
/// <signature>
/// <summary>
/// To show the column by using header text
/// </summary>
/// <param name="headerText"	type="string">you can pass a header text of a column to show</param>
/// </signature>
},
showCriticalPath:function(isShown){
/// <signature>
/// <summary>
/// To show/hide the critical tasks in current project.
/// </summary>
/// <param name="isShown"	type="boolean">To show/hide the critical tasks</param>
/// </signature>
},
sortColumn:function(mappingName, columnSortDirection){
/// <signature>
/// <summary>
/// To sort the column in required direction
/// </summary>
/// <param name="mappingName"	type="string">Defines the column's mapping name in which sorting have to be performed</param>
/// </signature>
/// <signature>
/// <summary>
/// To sort the column in required direction
/// </summary>
/// <param name="columnSortDirection"	type="string">Defines the sort direction whether the column has to sorted in ascending/descending order. By default it is sorting in an ascending order</param>
/// </signature>
},
updateDependency:function(fromTaskId, toTaskId, predecessorType, offset){
/// <signature>
/// <summary>
/// To update the predecessor type and offset value for existing task dependency.
/// </summary>
/// <param name="fromTaskId"	type="number">taskID of predecessor task</param>
/// </signature>
/// <signature>
/// <summary>
/// To update the predecessor type and offset value for existing task dependency.
/// </summary>
/// <param name="toTaskId"	type="number">taskID of successor task</param>
/// </signature>
/// <signature>
/// <summary>
/// To update the predecessor type and offset value for existing task dependency.
/// </summary>
/// <param name="predecessorType"	type="string">Type of dependency task.</param>
/// </signature>
/// <signature>
/// <summary>
/// To update the predecessor type and offset value for existing task dependency.
/// </summary>
/// <param name="offset"	type="number">Offset value of dependency task.</param>
/// </signature>
},
updateRecordByTaskId:function(data){
/// <signature>
/// <summary>
/// To update the value of Gantt record by using it's task id value.
/// </summary>
/// <param name="data"	type="any">object with modified field values and current task id value</param>
/// </signature>
},
updateRecordByIndex:function(index, data){
/// <signature>
/// <summary>
/// To update the value of Gantt record by using row index.
/// </summary>
/// <param name="index"	type="number">index of Gantt record to be updated</param>
/// </signature>
/// <signature>
/// <summary>
/// To update the value of Gantt record by using row index.
/// </summary>
/// <param name="data"	type="any">object with modified field value</param>
/// </signature>
},
updateScheduleDates:function(startDate, endDate){
/// <signature>
/// <summary>
/// To update the schedule start date and schedule end date of project.
/// </summary>
/// <param name="startDate"	type="string">New schedule start date of project</param>
/// </signature>
/// <signature>
/// <summary>
/// To update the schedule start date and schedule end date of project.
/// </summary>
/// <param name="endDate"	type="string">New schedule end date of project</param>
/// </signature>
},
updateTaskId:function(currentId, newId){
/// <signature>
/// <summary>
/// To change an existing Gantt ID by new ID value dynamically
/// </summary>
/// <param name="currentId"	type="number">you can pass an existing ID value to be change</param>
/// </signature>
/// <signature>
/// <summary>
/// To change an existing Gantt ID by new ID value dynamically
/// </summary>
/// <param name="newId"	type="number">you can pass a new ID value to be change</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejGantt=function(){
this.data("ejGantt",new	ej.Gantt());
return this;
};
intellisense.annotate(jQuery.fn,{
ejGantt :function (options) {
/// <signature>
/// <summary><br/>
///The Essential JavaScript Gantt control is designed to visualize and edit the project schedule, and track the project progress.<br/><br/>
///Specifies the fields to be included in the add dialog in Gantt
///<br/>addDialogFields-Array&lt;AddDialogFields&gt;	default-[]
///<br/><br/>
///Specifies mapping name to include required fields in Gantt
///<br/>field-string	default-
///<br/><br/>
///Specifies editType of fields to be included in the add dialog in Gantt
///<br/>editType-string	default-
///<br/><br/>
///Specifies the custom column field was displayed in General tab of add dialog or not.
///<br/>displayInGeneralTab-boolean	default-false
///<br/><br/>
///Enables or disables the ability to resize column.
///<br/>allowColumnResize-boolean	default-false
///<br/><br/>
///Enables or disables the ability to drag and drop the row interactively to reorder the rows
///<br/>allowDragAndDrop-boolean	default-false
///<br/><br/>
///Enables or Disables Gantt chart editing in Gantt
///<br/>allowGanttChartEditing-boolean	default-true
///<br/><br/>
///Enables or Disables Keyboard navigation in Gantt
///<br/>allowKeyboardNavigation-boolean	default-true
///<br/><br/>
///Specifies enabling or disabling multiple sorting for Gantt columns
///<br/>allowMultiSorting-boolean	default-false
///<br/><br/>
///Enables or disables the option for multiple exporting
///<br/>allowMultipleExporting-boolean	default-false
///<br/><br/>
///Enables or disables the interactive selection of a row.
///<br/>allowSelection-boolean	default-true
///<br/><br/>
///Enables or disables sorting. When enabled, we can sort the column by clicking on the column.
///<br/>allowSorting-boolean	default-false
///<br/><br/>
///Enables or disables the rendering of unscheduled tasks.
///<br/>allowUnscheduledTask-boolean	default-false
///<br/><br/>
///Specifies the baseline background color in Gantt
///<br/>baselineColor-string	default-#fba41c
///<br/><br/>
///Specifies the mapping property path for baseline end date in datasource
///<br/>baselineEndDateMapping-string	default-
///<br/><br/>
///Specifies the mapping property path for baseline start date of a task in datasource
///<br/>baselineStartDateMapping-string	default-
///<br/><br/>
///Specifies the template for cell tooltip
///<br/>cellTooltipTemplate-string	default-null
///<br/><br/>
///Specifies the mapping property path for sub tasks in datasource
///<br/>childMapping-string	default-
///<br/><br/>
///To Specify the column fields to be displayed in the dialog while inserting a column using column menu.
///<br/>columnDialogFields-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the background of connector lines in Gantt
///<br/>connectorLineBackground-string	default-
///<br/><br/>
///Specifies the width of the connector lines in Gantt
///<br/>connectorlineWidth-number	default-1
///<br/><br/>
///Specify the CSS class for Gantt to achieve custom theme.
///<br/>cssClass-string	default-
///<br/><br/>
///Collection of data or hierarchical data to represent in Gantt
///<br/>dataSource-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the dateFormat for Gantt , given format is displayed in tooltip , Grid .
///<br/>dateFormat-string	default-MM/dd/yyyy
///<br/><br/>
///Specifies the customized working time for tasks in Gantt
///<br/>dayWorkingTime-Array&lt;any&gt;	default-[{ from: 08:00 AM, to: 12:00 PM , background:   }, { from: 01:00 PM, to: 05:00 PM , background:  }]
///<br/><br/>
///Option for customizing the drag tooltip while reordering the rows.
///<br/>dragTooltip-DragTooltip	default-
///<br/><br/>
///Specifies option to enable/disable tooltip while drag and drop a row.
///<br/>showTooltip-boolean	default-true
///<br/><br/>
///Specifies the data source fields to be displayed in the drag tooltip.
///<br/>tooltipItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the custom template for drag tooltip.
///<br/>tooltipTemplate-string	default-null
///<br/><br/>
///Specifies the mapping property path for duration of a task in datasource
///<br/>durationMapping-string	default-
///<br/><br/>
///Specifies the duration unit for each tasks whether days or hours or minutes
///<br/>durationUnit-ej.Gantt.DurationUnit|string	default-ej.Gantt.DurationUnit.Day
///<br/><br/>
///Specifies the mapping property path for task duration unit in datasource
///<br/>durationUnitMapping-string	default-
///<br/><br/>
///Specifies the fields to be included in the edit dialog in Gantt
///<br/>editDialogFields-Array&lt;EditDialogFields&gt;	default-[]
///<br/><br/>
///Specifies mapping name to include required fields in Gantt
///<br/>field-string	default-
///<br/><br/>
///Specifies editType of fields to be included in the edit dialog in Gantt
///<br/>editType-string	default-
///<br/><br/>
///Specifies the custom column field was displayed in General tab of edit dialog or not.
///<br/>displayInGeneralTab-boolean	default-false
///<br/><br/>
///Specifies the editSettings options in Gantt.
///<br/>editSettings-EditSettings	default-
///<br/><br/>
///Enables or disables add record icon in Gantt toolbar
///<br/>allowAdding-boolean	default-false
///<br/><br/>
///Enables or disables delete icon in Gantt toolbar
///<br/>allowDeleting-boolean	default-false
///<br/><br/>
///Specifies the option for enabling or disabling editing in Gantt grid part
///<br/>allowEditing-boolean	default-false
///<br/><br/>
///Specifies the option for enabling or disabling indent action in Gantt.
///<br/>allowIndent-boolean	default-false
///<br/><br/>
///Specifies the mouse action whether single click or double click to begin the editing
///<br/>beginEditAction-ej.Gantt.BeginEditAction|string	default-ej.Gantt.BeginEditAction.DblClick
///<br/><br/>
///Specifies the edit mode in Gantt, "normal" is for dialog editing ,"cellEditing" is for cell type editing
///<br/>editMode-string	default-normal
///<br/><br/>
///Specifies the position where the new row has to be added.
///<br/>rowPosition-ej.Gantt.RowPosition|string	default-ej.Gantt.RowPosition.BelowSelectedRow
///<br/><br/>
///Enable or disable the confirmation dialog while deleting the record.
///<br/>showDeleteConfirmDialog-boolean	default-false
///<br/><br/>
///Enables or Disables enableAltRow row effect in Gantt
///<br/>enableAltRow-boolean	default-true
///<br/><br/>
///Enables or disables the collapse all records when loading the Gantt.
///<br/>enableCollapseAll-boolean	default-false
///<br/><br/>
///Enables or disables the contextmenu for Gantt , when enabled contextmenu appears on right clicking Gantt
///<br/>enableContextMenu-boolean	default-false
///<br/><br/>
///Enable or disable predecessor validation. When it is true, all the task's start and end dates are aligned based on its predecessors start and end dates.
///<br/>enablePredecessorValidation-boolean	default-true
///<br/><br/>
///Indicates whether we can edit the progress of a task interactively in Gantt.
///<br/>enableProgressBarResizing-boolean	default-true
///<br/><br/>
///Enables or disables the option for dynamically updating the Gantt size on window resizing
///<br/>enableResize-boolean	default-false
///<br/><br/>
///Enables or disables serial number column for Gantt. When enabled, the records will be number sequenced.
///<br/>enableSerialNumber-boolean	default-false
///<br/><br/>
///Enables or disables tooltip while editing (dragging/resizing) the taskbar.
///<br/>enableTaskbarDragTooltip-boolean	default-true
///<br/><br/>
///Enables or disables tooltip for taskbar.
///<br/>enableTaskbarTooltip-boolean	default-true
///<br/><br/>
///Enables/Disables virtualization for rendering Gantt items.
///<br/>enableVirtualization-boolean	default-false
///<br/><br/>
///Enables/disables work breakdown structure column.
///<br/>enableWBS-boolean	default-false
///<br/><br/>
///Enables/disables WBS predecessor column.
///<br/>enableWBSPredecessor-boolean	default-false
///<br/><br/>
///Specifies the mapping property path for end Date of a task in datasource
///<br/>endDateMapping-string	default-
///<br/><br/>
///Specifies the mapping property path for the expand status of a record in data source.
///<br/>expandStateMapping-string	default-
///<br/><br/>
///Options for filtering and customizing filter actions.
///<br/>filterSettings-FilterSettings	default-
///<br/><br/>
///Specifies the column collection for filtering the Gantt content on initial load
///<br/>filteredColumns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the value to be filtered in Gantt.
///<br/>value-string	default-
///<br/><br/>
///Specifies the field where filtering has to be performed.
///<br/>field-string	default-
///<br/><br/>
///Specifies the predicate(and/or) value to perform filtering.
///<br/>predicate-string	default-
///<br/><br/>
///Specifies the filter condition to filtered column. See operator
///<br/>operator-string	default-
///<br/><br/>
///Specifies the data collection for grouping the resources in resource allocation view in Gantt.
///<br/>groupCollection-Array&lt;any&gt;	default-[]
///<br/><br/>
///Default Value
///<br/>groupIdMapping-string	default-
///<br/><br/>
///Default Value
///<br/>groupNameMapping-string	default-
///<br/><br/>
///Specifies whether to highlight the non working time in Gantt.
///<br/>highlightNonWorkingTime-boolean	default-false
///<br/><br/>
///Specifies whether to highlight the weekends in Gantt .
///<br/>highlightWeekends-boolean	default-true
///<br/><br/>
///Collection of holidays with date, background and label information to be displayed in Gantt.
///<br/>holidays-Array&lt;Holidays&gt;	default-[]
///<br/><br/>
///Specifies holiday date to be displayed in Gantt
///<br/>day-string	default-
///<br/><br/>
///Specifies the background color for holiday date in Gantt Schedule
///<br/>background-string	default-
///<br/><br/>
///Specifies the label to be displayed for rendered holiday in Gantt
///<br/>label-string	default-
///<br/><br/>
///Specifies whether to include weekends while calculating the duration of a task.
///<br/>includeWeekend-boolean	default-true
///<br/><br/>
///Enables or disables the responsiveness of Gantt
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Specifies the data source field name to be displayed as left task label
///<br/>leftTaskLabelMapping-string	default-
///<br/><br/>
///Specifies the template for left task label
///<br/>leftTaskLabelTemplate-string	default-
///<br/><br/>
///Specify the locale for Gantt
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the mapping property path for milestone in datasource
///<br/>milestoneMapping-string	default-
///<br/><br/>
///To Specify the JsRender script Id to customize the mile stone with our preference
///<br/>milestoneTemplate-string	default-
///<br/><br/>
///Specifies the background color for non working time in Gantt.
///<br/>nonWorkingBackground-string	default-
///<br/><br/>
///Specifies the mapping property path for the task description in datasource
///<br/>notesMapping-string	default-
///<br/><br/>
///Specifies the background of parent progressbar in Gantt
///<br/>parentProgressbarBackground-string	default-
///<br/><br/>
///Specifies the mapping property path for parent task Id in self reference datasource
///<br/>parentTaskIdMapping-string	default-
///<br/><br/>
///Specifies the background of parent taskbar in Gantt
///<br/>parentTaskbarBackground-string	default-
///<br/><br/>
///Specifies the template for parent taskbar
///<br/>parentTaskbarTemplate-string	default-
///<br/><br/>
///Specifies the mapping property path for predecessors of a task in datasource
///<br/>predecessorMapping-string	default-
///<br/><br/>
///Specifies the JsRender template id or template script for predecessor tooltip on mouse action.
///<br/>predecessorTooltipTemplate-string	default-
///<br/><br/>
///Specifies the mapping property path for progress percentage of a task in datasource
///<br/>progressMapping-string	default-
///<br/><br/>
///Specifies the background of progressbar in Gantt
///<br/>progressbarBackground-string	default-
///<br/><br/>
///Specified the height of the progressbar in taskbar
///<br/>progressbarHeight-number	default-100
///<br/><br/>
///Specifies the template for tooltip on resizing progressbar
///<br/>progressbarTooltipTemplate-string	default-null
///<br/><br/>
///Specifies the template ID for customized tooltip for progressbar editing in Gantt
///<br/>progressbarTooltipTemplateId-string	default-null
///<br/><br/>
///It receives query to retrieve data from the table (query is same as SQL).
///<br/>query-any	default-null
///<br/><br/>
///Enables or disables Gantt to read-only mode
///<br/>readOnly-boolean	default-false
///<br/><br/>
///Enables or Disables rendering baselines in Gantt , when enabled baseline is rendered in Gantt
///<br/>renderBaseline-boolean	default-false
///<br/><br/>
///Default Value
///<br/>resourceCollectionMapping-string	default-
///<br/><br/>
///Specifies the mapping property name for resource ID in resource Collection in Gantt
///<br/>resourceIdMapping-string	default-
///<br/><br/>
///Specifies the mapping property path for resources of a task in datasource
///<br/>resourceInfoMapping-string	default-
///<br/><br/>
///Specifies the mapping property path for resource name of a task in Gantt
///<br/>resourceNameMapping-string	default-
///<br/><br/>
///Specifies the mapping property path for resource's percent effort involved in a task in datasource
///<br/>resourceUnitMapping-string	default-
///<br/><br/>
///Collection of data regarding resources involved in entire project
///<br/>resources-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the data source field name to be displayed as right task label
///<br/>rightTaskLabelMapping-string	default-
///<br/><br/>
///Specifies the template for right task label
///<br/>rightTaskLabelTemplate-string	default-
///<br/><br/>
///Specifies whether rounding off the day working time edits
///<br/>roundOffDayworkingTime-boolean	default-true
///<br/><br/>
///Specifies the height of a single row in Gantt. Also, we need to set same height in the CSS style with class name e-rowcell.
///<br/>rowHeight-number	default-30
///<br/><br/>
///Specifies end date of the Gantt schedule. By default, end date will be rounded to its next Saturday.
///<br/>scheduleEndDate-string	default-null
///<br/><br/>
///Specifies the options for customizing schedule header.
///<br/>scheduleHeaderSettings-ScheduleHeaderSettings	default-
///<br/><br/>
///Specified the format for day view in schedule header
///<br/>dayHeaderFormat-string	default-
///<br/><br/>
///Specified the format for Hour view in schedule header
///<br/>hourHeaderFormat-string	default-HH
///<br/><br/>
///Specifies the number of minutes per interval
///<br/>minutesPerInterval-ej.Gantt.minutesPerInterval|string	default-ej.Gantt.minutesPerInterval.Auto
///<br/><br/>
///Specified the format for month view in schedule header
///<br/>monthHeaderFormat-string	default-MMM
///<br/><br/>
///Specifies the schedule mode
///<br/>scheduleHeaderType-ej.Gantt.ScheduleHeaderType|string	default-ej.Gantt.ScheduleHeaderType.Week
///<br/><br/>
///Specifies the round-off mode for the start date in schedule header.
///<br/>timescaleStartDateMode-ej.Gantt.TimescaleRoundMode|string	default-ej.Gantt.TimescaleRoundMode.Auto
///<br/><br/>
///Specified the background for weekends in Gantt
///<br/>weekendBackground-string	default-#F2F2F2
///<br/><br/>
///Specified the format for week view in schedule header
///<br/>weekHeaderFormat-string	default-MMM dd , yyyy
///<br/><br/>
///Specified the format for year view in schedule header
///<br/>yearHeaderFormat-string	default-yyyy
///<br/><br/>
///Specifies the size of the lowest time unit along the timescale, with minimum value as "50%" and maximum value as "500%". It is also possible to set the value in pixels.
///<br/>timescaleUnitSize-string	default-100%
///<br/><br/>
///Specifies the start day of the week in week timescale mode
///<br/>weekStartDay-number	default-0
///<br/><br/>
///Enable or disable the automatic timescale update on cell editing, dialog editing and taskbar editing.
///<br/>updateTimescaleView-boolean	default-true
///<br/><br/>
///Specifies start date of the Gantt schedule. By default, start date will be rounded to its previous Sunday.
///<br/>scheduleStartDate-string	default-null
///<br/><br/>
///Specifies the selected cell information on rendering Gantt.
///<br/>selectedCellIndexes-Array&lt;SelectedCellIndexes&gt;	default-
///<br/><br/>
///Specifies the row index of the cell to be selected Gantt control
///<br/>rowIndex-number	default--1
///<br/><br/>
///Specifies the cell index to be selected in the row.
///<br/>cellIndex-number	default--1
///<br/><br/>
///Specifies the selected row Index in Gantt , the row with given index will highlighted
///<br/>selectedRowIndex-number	default--1
///<br/><br/>
///Specifies the row selection type.
///<br/>selectionType-ej.Gantt.SelectionType|string	default-ej.Gantt.SelectionType.Single
///<br/><br/>
///Specifies the type of selection whether to select row or cell.
///<br/>selectionMode-ej.Gantt.SelectionMode|string	default-ej.Gantt.SelectionMode.Row
///<br/><br/>
///Enables or disables the column chooser.
///<br/>showColumnChooser-boolean	default-false
///<br/><br/>
///Enables/disables the options for inserting , deleting and renaming  columns.
///<br/>showColumnOptions-boolean	default-false
///<br/><br/>
///Specifies the template for cell tooltip
///<br/>showGridCellTooltip-boolean	default-true
///<br/><br/>
///Specifies whether to show grid cell tooltip over expander cell alone.
///<br/>showGridExpandCellTooltip-boolean	default-true
///<br/><br/>
///Specifies whether display task progress inside taskbar.
///<br/>showProgressStatus-boolean	default-true
///<br/><br/>
///Specifies whether to display resource names for a task beside taskbar.
///<br/>showResourceNames-boolean	default-true
///<br/><br/>
///Specifies whether to display task name beside task bar.
///<br/>showTaskNames-boolean	default-true
///<br/><br/>
///Specifies the size option of Gantt control.
///<br/>sizeSettings-SizeSettings	default-
///<br/><br/>
///Specifies the height of Gantt control
///<br/>height-string	default-
///<br/><br/>
///Specifies the width of Gantt control
///<br/>width-string	default-
///<br/><br/>
///Specifies the sorting options for Gantt.
///<br/>sortSettings-SortSettings	default-
///<br/><br/>
///Specifies the sorted columns for Gantt
///<br/>sortedColumns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the field to be sorted in Gantt
///<br/>field-string	default-
///<br/><br/>
///Specifies the sort direction in Gantt
///<br/>direction-string	default-
///<br/><br/>
///Specifies splitter position in Gantt.
///<br/>splitterPosition-string	default-null
///<br/><br/>
///Option to configure the splitter position.
///<br/>splitterSettings-SplitterSettings	default-
///<br/><br/>
///Specifies position of the splitter in Gantt , splitter can be placed either based on percentage values or pixel values.
///<br/>position-string	default-
///<br/><br/>
///Specifies the position of splitter in Gantt, based on column index in Gantt.
///<br/>index-string	default-
///<br/><br/>
///Specifies the mapping property path for start date of a task in datasource
///<br/>startDateMapping-string	default-
///<br/><br/>
///Specifies the options for striplines
///<br/>stripLines-Array&lt;StripLines&gt;	default-[]
///<br/><br/>
///Specifies date to render striplines in Gantt
///<br/>day-string	default-
///<br/><br/>
///Specifies label to be displayed for striplines in Gantt
///<br/>label-string	default-
///<br/><br/>
///Specifies line style for rendered striplines in Gantt
///<br/>lineStyle-string	default-
///<br/><br/>
///Specifies the line color for rendered striplines in Gantt
///<br/>lineColor-string	default-
///<br/><br/>
///Specifies the width of the stripline in Gantt
///<br/>lineWidth-string	default-
///<br/><br/>
///Default Value
///<br/>taskCollectionMapping-string	default-
///<br/><br/>
///Specifies the mapping property path for task Id in datasource
///<br/>taskIdMapping-string	default-
///<br/><br/>
///Specifies the mapping property path for task name in datasource
///<br/>taskNameMapping-string	default-
///<br/><br/>
///Specifies the task scheduling mode for a project and this will be set to all the tasks available in the project
///<br/>taskSchedulingMode-ej.Gantt.TaskSchedulingMode|string	default-ej.Gantt.TaskSchedulingMode.Auto
///<br/><br/>
///Specifies the mapping property path for the task scheduling mode for a task in datasource
///<br/>taskSchedulingModeMapping-string	default-auto
///<br/><br/>
///Specifies the nature of a task for calculating the work,  and it can fixed duration, fixed work and fixed resource unit
///<br/>taskType-ej.Gantt.TaskType|string	default-ej.Gantt.TaskType.FixedUnit
///<br/><br/>
///Specifies the background of the taskbar in Gantt
///<br/>taskbarBackground-string	default-
///<br/><br/>
///Specifies the template script for customized tooltip for taskbar editing in Gantt
///<br/>taskbarEditingTooltipTemplate-string	default-
///<br/><br/>
///Specifies the template Id for customized tooltip for taskbar editing in Gantt
///<br/>taskbarEditingTooltipTemplateId-string	default-
///<br/><br/>
///Specifies the height of taskBar in Gantt.
///<br/>taskbarHeight-number	default-20
///<br/><br/>
///To Specify the JsRender script Id to customize the task bar with our preference
///<br/>taskbarTemplate-string	default-
///<br/><br/>
///Specifies the template for tooltip on mouse action on taskbars
///<br/>taskbarTooltipTemplate-string	default-
///<br/><br/>
///Specifies the template id for tooltip on mouse action on taskbars
///<br/>taskbarTooltipTemplateId-string	default-
///<br/><br/>
///Specifies the toolbarSettings options.
///<br/>toolbarSettings-ToolbarSettings	default-
///<br/><br/>
///Specifies the state of enabling or disabling toolbar
///<br/>showToolbar-boolean	default-true
///<br/><br/>
///Specifies the list of toolbar items to be rendered in Gantt toolbar
///<br/>toolbarItems-array&lt;ej.Gantt.ToolbarItems|string&gt;	default-[]
///<br/><br/>
///Allows the user to insert custom toolbar items.
///<br/>customToolbarItems-Array&lt;any&gt;	default-
///<br/><br/>
///Allows the user to insert the custom icons in toolbar using CSS class name selector.
///<br/>text-string	default-
///<br/><br/>
///Allows the user to insert the custom icons in toolbar using script templates. Using this property we can bind HTML elements and other EJ controls to Gantt toolbar.
///<br/>templateID-string	default-
///<br/><br/>
///Allows the user to display custom tooltip text for Gantt custom toolbar items.
///<br/>tooltipText-string	default-
///<br/><br/>
///Specifies the tree expander column in Gantt
///<br/>treeColumnIndex-number	default-0
///<br/><br/>
///Enables or disables the schedule date validation while connecting a manually scheduled task with predecessor
///<br/>validateManualTasksOnLinking-boolean	default-false
///<br/><br/>
///Specifies the view type for a project in the Gantt.
///<br/>viewType-ej.Gantt.ViewType|string	default-ej.Gantt.ViewType.ProjectView
///<br/><br/>
///Specifies the weekendBackground color in Gantt
///<br/>weekendBackground-string	default-#F2F2F2
///<br/><br/>
///Specifies the mapping property path for the work field of a task in the data source. When it is mapped the end date and duration for a task will be calculated automatically.
///<br/>workMapping-string	default-
///<br/><br/>
///Specifies the unit for the work involved in a task and it can be day, hour or minute
///<br/>workUnit-ej.Gantt.WorkUnit|string	default-ej.Gantt.WorkUnit.Hour
///<br/><br/>
///Gets or sets the working days of a week in a project.
///<br/>workWeek-Array&lt;any&gt;	default-[Monday,Tuesday,Wednesday,Thursday,Friday]
///<br/><br/>
///Specifies the working time schedule of day
///<br/>workingTimeScale-ej.Gantt.workingTimeScale|string	default-ej.Gantt.workingTimeScale.TimeScale8Hours
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Grid:function(){
 /// <signature>
 /// <summary>Constructor of ej.Grid</summary>
 /// </signature>
}
});
ej.Grid=(function(){
var original=ej.Grid
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addIgnoreOnExport:function(propertyNames){
/// <signature>
/// <summary>
/// Adds a grid model property which is to be ignored upon exporting.
/// </summary>
/// <param name="propertyNames"	type="any[]">Pass the array of parameters which need to be ignored on exporting </param>
/// </signature>
},
addIgnoreOnToolbarServerClick:function(propertyNames){
/// <signature>
/// <summary>
/// Adds a grid model property which is to be ignored upon OnServerToolbarClick.
/// </summary>
/// <param name="propertyNames"	type="any[]">Pass the array of parameters which need to be ignored on OnServerToolbarClick </param>
/// </signature>
},
addRecord:function(data, serverChange){
/// <signature>
/// <summary>
/// Add a new record in grid control when allowAdding is set as true.Without passing parameters it will add empty row.
/// </summary>
/// <param name="data"	type="any[]">Pass the array of added Records</param>
/// </signature>
/// <signature>
/// <summary>
/// Add a new record in grid control when allowAdding is set as true.Without passing parameters it will add empty row.
/// </summary>
/// <param name="serverChange"	type="any[]">optionalIf we pass serverChange as true, send post to server side for server action.</param>
/// </signature>
},
batchCancel:function(){
/// <signature>
/// <summary>
/// Cancel the modified changes in grid control when edit mode is &quot;batch&quot;.
/// </summary>
},
batchSave:function(){
/// <signature>
/// <summary>
/// Save the modified changes to data source in grid control when edit mode is &quot;batch&quot;.
/// </summary>
},
cancelEdit:function(){
/// <signature>
/// <summary>
/// Send a cancel request in grid.
/// </summary>
},
cancelEditCell:function(){
/// <signature>
/// <summary>
/// Send a cancel request to the edited cell in grid.
/// </summary>
},
calculatePageSizeByParentHeight:function(containerHeight){
/// <signature>
/// <summary>
/// Returns the total page size need to be displayed in grid based on the given container height. This method will also work when the property allowTextWrap as true only when wrap mode is header.
/// </summary>
/// <param name="containerHeight"	type="number">When passing the container height as integer or percentage, it will returns the page size that need to be displayed for grid. </param>
/// </signature>
},
changePageSize:function(pageSize){
/// <signature>
/// <summary>
/// It is used to change the number of records displayed per page in grid based on the given page size.
/// </summary>
/// <param name="pageSize"	type="number">When passing the page size, it will change the number of records displayed per page in grid. </param>
/// </signature>
},
clearCellSelection:function(){
/// <signature>
/// <summary>
/// It is used to clear all the cell selection.
/// </summary>
},
clearCellSelection:function(rowIndex, columnIndex){
/// <signature>
/// <summary>
/// It is used to clear specified cell selection based on the rowIndex and columnIndex provided.
/// </summary>
/// <param name="rowIndex"	type="number">It is used to pass the row index of the cell</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to clear specified cell selection based on the rowIndex and columnIndex provided.
/// </summary>
/// <param name="columnIndex"	type="number">It is used to pass the column index of the cell.</param>
/// </signature>
},
clearColumnSelection:function(index){
/// <signature>
/// <summary>
/// It is used to clear all the row selection or at specific row selection based on the index provided.
/// </summary>
/// <param name="index"	type="number">optional If index of the column is specified then it will remove the selection from the particular column else it will clears all of the column selection</param>
/// </signature>
},
clearFiltering:function(field){
/// <signature>
/// <summary>
/// It is used to clear all the filtering done.
/// </summary>
/// <param name="field"	type="string"> If field of the column is specified then it will clear the  particular filtering column</param>
/// </signature>
},
clearSearching:function(){
/// <signature>
/// <summary>
/// Clear the searching from the grid
/// </summary>
},
clearSelection:function(index){
/// <signature>
/// <summary>
/// Clear all the row selection or at specific row selection based on the index provided
/// </summary>
/// <param name="index"	type="number">optional If index of the row is specified then it will remove the selection from the particular row else it will clears all of the row selection</param>
/// </signature>
},
clearSorting:function(){
/// <signature>
/// <summary>
/// Clear the sorting from columns in the grid
/// </summary>
},
collapseAll:function(){
/// <signature>
/// <summary>
/// Collapse all the group caption rows in grid
/// </summary>
},
collapseGroupDropArea:function(){
/// <signature>
/// <summary>
/// Collapse the group drop area in grid
/// </summary>
},
columns:function(columnDetails, action){
/// <signature>
/// <summary>
/// Add or remove columns in grid column collections
/// </summary>
/// <param name="columnDetails"	type="any[]|string">Pass array of columns or string of field name to add/remove the column in grid</param>
/// </signature>
/// <signature>
/// <summary>
/// Add or remove columns in grid column collections
/// </summary>
/// <param name="action"	type="string">optional Pass add/remove action to be performed. By default "add" action will perform</param>
/// </signature>
},
dataSource:function(datasource, templateRefresh){
/// <signature>
/// <summary>
/// Refresh the grid with new data source
/// </summary>
/// <param name="datasource"	type="any">Pass new data source to the grid</param>
/// </signature>
/// <signature>
/// <summary>
/// Refresh the grid with new data source
/// </summary>
/// <param name="templateRefresh"	type="boolean">optional When templateRefresh is set true, both header and contents get refreshed</param>
/// </signature>
},
deleteRecord:function(fieldName, data){
/// <signature>
/// <summary>
/// Delete a record in grid control when allowDeleting is set as true
/// </summary>
/// <param name="fieldName"	type="string">Pass the primary key field Name of the column</param>
/// </signature>
/// <signature>
/// <summary>
/// Delete a record in grid control when allowDeleting is set as true
/// </summary>
/// <param name="data"	type="any">Pass the JSON data of record need to be delete.</param>
/// </signature>
},
deleteRow:function($tr){
/// <signature>
/// <summary>
/// Delete the row based on the given tr element in grid.
/// </summary>
/// <param name="$tr"	type="JQuery">Pass the tr element in grid content to get its row index</param>
/// </signature>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroy the grid widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
editCell:function(index, fieldName){
/// <signature>
/// <summary>
/// Edit a particular cell based on the row index and field name provided in &quot;batch&quot; edit mode.
/// </summary>
/// <param name="index"	type="number">Pass row index to edit particular cell</param>
/// </signature>
/// <signature>
/// <summary>
/// Edit a particular cell based on the row index and field name provided in &quot;batch&quot; edit mode.
/// </summary>
/// <param name="fieldName"	type="string">Pass the field name of the column to perform batch edit</param>
/// </signature>
},
editFormValidate:function(){
/// <signature>
/// <summary>
/// It returns a value and if the input field values of edit form is not based on the validation rules then it will show the validation message.
/// </summary>
},
endEdit:function(){
/// <signature>
/// <summary>
/// Send a save request in grid.
/// </summary>
},
expandAll:function(){
/// <signature>
/// <summary>
/// Expand all the group caption rows in grid.
/// </summary>
},
expandCollapse:function($target){
/// <signature>
/// <summary>
/// Expand or collapse the row based on the row state in grid
/// </summary>
/// <param name="$target"	type="JQuery">Pass the target object to expand/collapse the row based on its row state</param>
/// </signature>
},
expandGroupDropArea:function(){
/// <signature>
/// <summary>
/// Expand the group drop area in grid.
/// </summary>
},
export:function(action, serverEvent, multipleExport, gridIds){
/// <signature>
/// <summary>
/// Export the grid content to excel, word or PDF document.
/// </summary>
/// <param name="action"	type="string">Pass the controller action name corresponding to exporting</param>
/// </signature>
/// <signature>
/// <summary>
/// Export the grid content to excel, word or PDF document.
/// </summary>
/// <param name="serverEvent"	type="string">optionalASP server event name corresponding to exporting</param>
/// </signature>
/// <signature>
/// <summary>
/// Export the grid content to excel, word or PDF document.
/// </summary>
/// <param name="multipleExport"	type="boolean">optionalPass the multiple exporting value as true/false</param>
/// </signature>
/// <signature>
/// <summary>
/// Export the grid content to excel, word or PDF document.
/// </summary>
/// <param name="gridIds"	type="any[]">optionalPass the array of the gridIds to be filtered</param>
/// </signature>
},
filterColumn:function(fieldName, filterOperator, filterValue, predicate, matchcase, actualFilterValue){
/// <signature>
/// <summary>
/// Send a filtering request to filter one column in grid.
/// </summary>
/// <param name="fieldName"	type="any[]|string">Pass the field name of the column</param>
/// </signature>
/// <signature>
/// <summary>
/// Send a filtering request to filter one column in grid.
/// </summary>
/// <param name="filterOperator"	type="string">string/integer/dateTime operator</param>
/// </signature>
/// <signature>
/// <summary>
/// Send a filtering request to filter one column in grid.
/// </summary>
/// <param name="filterValue"	type="string">Pass the value to be filtered in a column</param>
/// </signature>
/// <signature>
/// <summary>
/// Send a filtering request to filter one column in grid.
/// </summary>
/// <param name="predicate"	type="string">Pass the predicate as and/or</param>
/// </signature>
/// <signature>
/// <summary>
/// Send a filtering request to filter one column in grid.
/// </summary>
/// <param name="matchcase"	type="boolean">optional Pass the match case value as true/false</param>
/// </signature>
/// <signature>
/// <summary>
/// Send a filtering request to filter one column in grid.
/// </summary>
/// <param name="actualFilterValue"	type="any">optionalactualFilterValue denote the filter object of current filtered columns.Pass the value to filtered in a column</param>
/// </signature>
},
filterColumn:function(filterQueries){
/// <signature>
/// <summary>
/// Send a filtering request to filter single or multiple column in grid.
/// </summary>
/// <param name="filterQueries"	type="any[]">Pass array of filterColumn query for performing filter operation</param>
/// </signature>
},
getBatchChanges:function(){
/// <signature>
/// <summary>
/// Get the batch changes of edit, delete and add operations of grid.
/// </summary>
},
getBrowserDetails:function(){
/// <signature>
/// <summary>
/// Get the browser details
/// </summary>
},
getColumnByField:function(fieldName){
/// <signature>
/// <summary>
/// Get the column details based on the given field in grid
/// </summary>
/// <param name="fieldName"	type="string">Pass the field name of the column to get the corresponding column object</param>
/// </signature>
},
getColumnByHeaderText:function(headerText){
/// <signature>
/// <summary>
/// Get the column details based on the given header text in grid.
/// </summary>
/// <param name="headerText"	type="string">Pass the header text of the column to get the corresponding column object</param>
/// </signature>
},
getColumnByIndex:function(columnIndex){
/// <signature>
/// <summary>
/// Get the column details based on the given column index in grid
/// </summary>
/// <param name="columnIndex"	type="number">Pass the index of the column to get the corresponding column object</param>
/// </signature>
},
getColumnFieldNames:function(){
/// <signature>
/// <summary>
/// Get the list of field names from column collection in grid.
/// </summary>
},
getColumnIndexByField:function(fieldName){
/// <signature>
/// <summary>
/// Get the column index of the given field in grid.
/// </summary>
/// <param name="fieldName"	type="string">Pass the field name of the column to get the corresponding column index</param>
/// </signature>
},
getColumnIndexByHeaderText:function(headerText, field){
/// <signature>
/// <summary>
/// Get the column index of the given headerText of column in grid.
/// </summary>
/// <param name="headerText"	type="string">Pass the headerText of the column to get that column index</param>
/// </signature>
/// <signature>
/// <summary>
/// Get the column index of the given headerText of column in grid.
/// </summary>
/// <param name="field"	type="string">optionalOptional Pass the field name of the column.</param>
/// </signature>
},
getContent:function(){
/// <signature>
/// <summary>
/// Get the content div element of grid.
/// </summary>
},
getContentTable:function(){
/// <signature>
/// <summary>
/// Get the content table element of grid
/// </summary>
},
getCurrentEditCellData:function(){
/// <signature>
/// <summary>
/// Get the data of currently edited cell value in &quot;batch&quot; edit mode
/// </summary>
},
getCurrentIndex:function(){
/// <signature>
/// <summary>
/// Get the current page index in grid pager.
/// </summary>
},
getCurrentViewData:function(){
/// <signature>
/// <summary>
/// Get the current page data source of grid.
/// </summary>
},
getDataByIndex:function(){
/// <signature>
/// <summary>
/// Get the data of given row index in grid.
/// </summary>
},
getFieldNameByHeaderText:function(headerText){
/// <signature>
/// <summary>
/// Get the column field name from the given header text in grid.
/// </summary>
/// <param name="headerText"	type="string">Pass header text of the column to get its corresponding field name</param>
/// </signature>
},
getFilterBar:function(){
/// <signature>
/// <summary>
/// Get the filter bar of grid
/// </summary>
},
getFilteredRecords:function(){
/// <signature>
/// <summary>
/// Get the records filtered or searched in Grid
/// </summary>
},
getFooterContent:function(){
/// <signature>
/// <summary>
/// Get the footer content of grid.
/// </summary>
},
getFooterTable:function(){
/// <signature>
/// <summary>
/// Get the footer table element of grid.
/// </summary>
},
getHeaderContent:function(){
/// <signature>
/// <summary>
/// Get the header content div element of grid.
/// </summary>
},
getHeaderTable:function(){
/// <signature>
/// <summary>
/// Get the header table element of grid
/// </summary>
},
getHeaderTextByFieldName:function(field){
/// <signature>
/// <summary>
/// Get the column header text from the given field name in grid.
/// </summary>
/// <param name="field"	type="string">Pass field name of the column to get its corresponding header text</param>
/// </signature>
},
getHiddenColumnNames:function(){
/// <signature>
/// <summary>
/// Get the names of all the hidden column collections in grid.
/// </summary>
},
getIndexByRow:function($tr){
/// <signature>
/// <summary>
/// Get the row index based on the given tr element in grid.
/// </summary>
/// <param name="$tr"	type="JQuery">Pass the tr element in grid content to get its row index</param>
/// </signature>
},
getPager:function(){
/// <signature>
/// <summary>
/// Get the pager of grid.
/// </summary>
},
getPrimaryKeyFieldNames:function(){
/// <signature>
/// <summary>
/// Get the names of primary key columns in Grid
/// </summary>
},
getRowByIndex:function(from, to){
/// <signature>
/// <summary>
/// Get the rows(tr element) from the given from and to row index in grid
/// </summary>
/// <param name="from"	type="number">Pass the from index from which the rows to be returned</param>
/// </signature>
/// <signature>
/// <summary>
/// Get the rows(tr element) from the given from and to row index in grid
/// </summary>
/// <param name="to"	type="number">Pass the to index to which the rows to be returned</param>
/// </signature>
},
getRowHeight:function(){
/// <signature>
/// <summary>
/// Get the row height of grid.
/// </summary>
},
getRows:function(){
/// <signature>
/// <summary>
/// Get the rows(tr element)of grid which is displayed in the current page.
/// </summary>
},
getScrollObject:function(){
/// <signature>
/// <summary>
/// Get the scroller object of grid.
/// </summary>
},
getSelectedRecords:function(){
/// <signature>
/// <summary>
/// Get the selected records details in grid.
/// </summary>
},
getSelectedRows:function(){
/// <signature>
/// <summary>
/// Get the selected row element details in grid.
/// </summary>
},
getsortColumnByField:function(field){
/// <signature>
/// <summary>
/// It accepts the string value and returns the field and sorted direction of the column in grid.
/// </summary>
/// <param name="field"	type="string">Pass the field of the column to get the sorted direction of the corresponding column in Grid.</param>
/// </signature>
},
getSummaryValues:function(summaryCol, summaryData){
/// <signature>
/// <summary>
/// Get the calculated summary values of JSON data passed to it
/// </summary>
/// <param name="summaryCol"	type="any">Pass Summary Column details</param>
/// </signature>
/// <signature>
/// <summary>
/// Get the calculated summary values of JSON data passed to it
/// </summary>
/// <param name="summaryData"	type="any">Pass JSON Array for which its field values to be calculated</param>
/// </signature>
},
getVisibleColumnNames:function(){
/// <signature>
/// <summary>
/// Get the names of all the visible column collections in grid
/// </summary>
},
gotoPage:function(pageIndex){
/// <signature>
/// <summary>
/// Send a paging request to specified page in grid
/// </summary>
/// <param name="pageIndex"	type="number">Pass the page index to perform paging at specified page index</param>
/// </signature>
},
groupColumn:function(fieldName){
/// <signature>
/// <summary>
/// Send a column grouping request in grid.
/// </summary>
/// <param name="fieldName"	type="string">Pass the field Name of the column to be grouped in grid control</param>
/// </signature>
},
hideColumns:function(headerText){
/// <signature>
/// <summary>
/// Hide columns from the grid based on the header text
/// </summary>
/// <param name="headerText"	type="any[]|string">you can pass either array of header text of various columns or a header text of a column to hide</param>
/// </signature>
},
print:function(){
/// <signature>
/// <summary>
/// Print the grid control
/// </summary>
},
refreshBatchEditChanges:function(){
/// <signature>
/// <summary>
/// It is used to refresh and reset the changes made in &quot;batch&quot; edit mode
/// </summary>
},
refreshHeader:function(){
/// <signature>
/// <summary>
/// It is used to refresh the grid header.
/// </summary>
},
refreshContent:function(templateRefresh){
/// <signature>
/// <summary>
/// Refresh the grid contents. The template refreshment is based on the argument passed along with this method
/// </summary>
/// <param name="templateRefresh"	type="boolean">optional When templateRefresh is set true, template and grid contents both are refreshed in grid else only grid content is refreshed</param>
/// </signature>
},
refreshData:function(additionalParameters){
/// <signature>
/// <summary>
/// Refresh the grid contents with updated server Data, using XMLHttpRequest. Url Path should be provided in Grid datasource otherwise it refreshes with local data without XMLHttpRequest.
/// </summary>
/// <param name="additionalParameters"	type="any">optionalData to the server </param>
/// </signature>
},
refreshTemplate:function(){
/// <signature>
/// <summary>
/// Refresh the template of the grid
/// </summary>
},
refreshToolbar:function(){
/// <signature>
/// <summary>
/// Refresh the toolbar items in grid.
/// </summary>
},
removeSortedColumns:function(fieldName){
/// <signature>
/// <summary>
/// Remove a column or collection of columns from a sorted column collections in grid.
/// </summary>
/// <param name="fieldName"	type="any[]|string">Pass array of field names of the columns to remove a collection of sorted columns or pass a string of field name to remove a column from sorted column collections</param>
/// </signature>
},
render:function(){
/// <signature>
/// <summary>
/// Creates a grid control
/// </summary>
},
reorderColumns:function(fromFieldName, toFieldName){
/// <signature>
/// <summary>
/// Re-order the column in grid
/// </summary>
/// <param name="fromFieldName"	type="string">Pass the from field name of the column needs to be changed</param>
/// </signature>
/// <signature>
/// <summary>
/// Re-order the column in grid
/// </summary>
/// <param name="toFieldName"	type="string">Pass the to field name of the column needs to be changed</param>
/// </signature>
},
reorderRows:function(indexes, toIndex){
/// <signature>
/// <summary>
/// Re-order the row in grid
/// </summary>
/// <param name="indexes"	type="any[]">Pass the indexes of the rows needs to reorder.</param>
/// </signature>
/// <signature>
/// <summary>
/// Re-order the row in grid
/// </summary>
/// <param name="toIndex"	type="number">Pass the index of a row where to be reordered.</param>
/// </signature>
},
resetModelCollections:function(){
/// <signature>
/// <summary>
/// Reset the model collections like pageSettings, groupSettings, filterSettings, sortSettings and summaryRows.
/// </summary>
},
resizeColumns:function(column, width){
/// <signature>
/// <summary>
/// Resize the columns by giving column name and width for the corresponding one.
/// </summary>
/// <param name="column"	type="string">Pass the column name that needs to be changed</param>
/// </signature>
/// <signature>
/// <summary>
/// Resize the columns by giving column name and width for the corresponding one.
/// </summary>
/// <param name="width"	type="string">Pass the width to resize the particular columns</param>
/// </signature>
},
rowHeightRefresh:function(){
/// <signature>
/// <summary>
/// Resolves row height issue when unbound column is used with FrozenColumn
/// </summary>
},
saveCell:function(preventSaveEvent){
/// <signature>
/// <summary>
/// We can prevent the client side cellSave event triggering by passing the preventSaveEvent argument as true.Without argument it will save the particular edited grid cell.
/// </summary>
/// <param name="preventSaveEvent"	type="boolean">optionalIf we pass preventSaveEvent as true, it prevents the client side cellSave event triggering </param>
/// </signature>
},
setDimension:function(height, width){
/// <signature>
/// <summary>
/// Set dimension for grid with corresponding to grid parent.
/// </summary>
/// <param name="height"	type="number">Pass the height of the grid container</param>
/// </signature>
/// <signature>
/// <summary>
/// Set dimension for grid with corresponding to grid parent.
/// </summary>
/// <param name="width"	type="number">Pass the width of the grid container</param>
/// </signature>
},
setWidthToColumns:function(){
/// <signature>
/// <summary>
/// Send a request to grid to refresh the width set to columns
/// </summary>
},
search:function(searchString){
/// <signature>
/// <summary>
/// Send a search request to grid with specified string passed in it
/// </summary>
/// <param name="searchString"	type="string">Pass the string to search in Grid records</param>
/// </signature>
},
selectCells:function(rowCellIndexes){
/// <signature>
/// <summary>
/// Select cells in grid.
/// </summary>
/// <param name="rowCellIndexes"	type="any">It is used to set the starting index of row and indexes of cells for that corresponding row for selecting cells.</param>
/// </signature>
},
selectColumns:function(fromIndex){
/// <signature>
/// <summary>
/// Select columns in grid.
/// </summary>
/// <param name="fromIndex"	type="number">It is used to set the starting index of column for selecting columns.</param>
/// </signature>
},
selectColumns:function(columnIndex, toIndex){
/// <signature>
/// <summary>
/// Select the specified columns in grid based on Index provided.
/// </summary>
/// <param name="columnIndex"	type="number">It is used to set the starting index of column for selecting columns.</param>
/// </signature>
/// <signature>
/// <summary>
/// Select the specified columns in grid based on Index provided.
/// </summary>
/// <param name="toIndex"	type="number">optionalIt is used to set the ending index of column for selecting columns.</param>
/// </signature>
},
selectRows:function(fromIndex, toIndex){
/// <signature>
/// <summary>
/// Select rows in grid.
/// </summary>
/// <param name="fromIndex"	type="number">It is used to set the starting index of row for selecting rows.</param>
/// </signature>
/// <signature>
/// <summary>
/// Select rows in grid.
/// </summary>
/// <param name="toIndex"	type="number">It is used to set the ending index of row for selecting rows.</param>
/// </signature>
},
selectRows:function(from, to, target){
/// <signature>
/// <summary>
/// Select specified rows in grid based on Index provided.
/// </summary>
/// <param name="from"	type="any[]|number">It is used to set the starting index of row for selecting rows.</param>
/// </signature>
/// <signature>
/// <summary>
/// Select specified rows in grid based on Index provided.
/// </summary>
/// <param name="to"	type="number">optionalIt is used to set the ending index of row for selecting rows.</param>
/// </signature>
/// <signature>
/// <summary>
/// Select specified rows in grid based on Index provided.
/// </summary>
/// <param name="target"	type="any">optionalTarget element which is clicked.</param>
/// </signature>
},
selectRows:function(rowIndexes){
/// <signature>
/// <summary>
/// Select rows in grid.
/// </summary>
/// <param name="rowIndexes"	type="any[]">Pass array of rowIndexes for selecting rows</param>
/// </signature>
},
setCellText:function(){
/// <signature>
/// <summary>
/// Used to update a particular cell value.
/// </summary>
},
setCellValue:function(Index, fieldName, value){
/// <signature>
/// <summary>
/// Used to update a particular cell value based on specified row Index and the fieldName.
/// </summary>
/// <param name="Index"	type="number">It is used to set the index for selecting the row.</param>
/// </signature>
/// <signature>
/// <summary>
/// Used to update a particular cell value based on specified row Index and the fieldName.
/// </summary>
/// <param name="fieldName"	type="string">It is used to set the field name for selecting column.</param>
/// </signature>
/// <signature>
/// <summary>
/// Used to update a particular cell value based on specified row Index and the fieldName.
/// </summary>
/// <param name="value"	type="any">It is used to set the value for the selected cell.</param>
/// </signature>
},
setDefaultData:function(){
/// <signature>
/// <summary>
/// It sets the default data to the column in grid during adding record in batch edit mode.
/// </summary>
},
setPhoneModeMaxWidth:function(Index){
/// <signature>
/// <summary>
/// The grid rows has to be rendered as detail view in mobile mode based on given value.
/// </summary>
/// <param name="Index"	type="number">It is used to render grid rows as details view in mobile mode.</param>
/// </signature>
},
setValidation:function(){
/// <signature>
/// <summary>
/// Set validation to edit form in the grid.
/// </summary>
},
setValidationToField:function(fieldName, rules){
/// <signature>
/// <summary>
/// Set validation to a particular input field in a edit form dynamically.
/// </summary>
/// <param name="fieldName"	type="string">Specify the field name of the column to set validation rules</param>
/// </signature>
/// <signature>
/// <summary>
/// Set validation to a particular input field in a edit form dynamically.
/// </summary>
/// <param name="rules"	type="any">Specify the validation rules for the field</param>
/// </signature>
},
showColumns:function(headerText){
/// <signature>
/// <summary>
/// Show columns in the grid based on the header text
/// </summary>
/// <param name="headerText"	type="any[]|string">you can pass either array of header text of various columns or a header text of a column to show</param>
/// </signature>
},
sortColumn:function(columnName, sortingDirection){
/// <signature>
/// <summary>
/// Send a sorting request in grid.
/// </summary>
/// <param name="columnName"	type="string">Pass the field name of the column as columnName for which sorting have to be performed</param>
/// </signature>
/// <signature>
/// <summary>
/// Send a sorting request in grid.
/// </summary>
/// <param name="sortingDirection"	type="string">optional Pass the sort direction ascending/descending by which the column have to be sort. By default it is sorting in an ascending order</param>
/// </signature>
},
startEdit:function($tr){
/// <signature>
/// <summary>
/// Send an edit record request in grid
/// </summary>
/// <param name="$tr"	type="JQuery">Pass the tr- selected row element to be edited in grid</param>
/// </signature>
},
ungroupColumn:function(fieldName){
/// <signature>
/// <summary>
/// Un-group a column from grouped columns collection in grid
/// </summary>
/// <param name="fieldName"	type="string">Pass the field Name of the column to be ungrouped from grouped column collection</param>
/// </signature>
},
updateRecord:function(fieldName, data){
/// <signature>
/// <summary>
/// Update a edited record in grid control when allowEditing is set as true.
/// </summary>
/// <param name="fieldName"	type="string">Pass the primary key field Name of the column</param>
/// </signature>
/// <signature>
/// <summary>
/// Update a edited record in grid control when allowEditing is set as true.
/// </summary>
/// <param name="data"	type="any[]">Pass the edited JSON data of record need to be update.</param>
/// </signature>
},
windowonresize:function(){
/// <signature>
/// <summary>
/// It adapts grid to its parent element or to the browsers window.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejGrid=function(){
this.data("ejGrid",new	ej.Grid());
return this;
};
intellisense.annotate(jQuery.fn,{
ejGrid :function (options) {
/// <signature>
/// <summary><br/>
///The grid can be easily configured to the DOM element, such as div. you can create a grid with a highly customizable look and feel.<br/><br/>
///Gets or sets a value that indicates whether to customizing cell based on our needs.
///<br/>allowCellMerging-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable dynamic grouping behavior. Grouping can be done by drag on drop desired columns to gridâ€™s GroupDropArea. This can be further customized through â€œgroupSettingsâ€ property.
///<br/>allowGrouping-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable keyboard support for performing grid actions. selectionType â€“ Gets or sets a value that indicates whether to enable single row or multiple rows selection behavior in grid. Multiple selection can be done through by holding CTRL and clicking the grid rows
///<br/>allowKeyboardNavigation-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable dynamic filtering behavior on grid. Filtering can be used to limit the records displayed using required criteria and this can be further customized through â€œfilterSettingsâ€ property
///<br/>allowFiltering-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the dynamic sorting behavior on grid data. Sorting can be done through clicking on particular column header.
///<br/>allowSorting-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable multi columns sorting behavior in grid. Sort multiple columns by holding CTRL and click on the corresponding column header.
///<br/>allowMultiSorting-boolean	default-false
///<br/><br/>
///This specifies the grid to show the paginated data. Also enables pager control at the bottom of grid for dynamic navigation through data source. Paging can be further customized through â€œpageSettingsâ€ property.
///<br/>allowPaging-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the columns reordering behavior in the grid. Reordering can be done through by drag and drop the particular column from one index to another index within the grid.
///<br/>allowReordering-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether the column is non resizable. Column width is set automatically based on the content or header text which is large.
///<br/>allowResizeToFit-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable dynamic resizable of columns. Resize the width of the columns by simply click and move the particular column header line
///<br/>allowResizing-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the rows reordering in Grid and drag & drop rows between multiple Grid.
///<br/>allowRowDragAndDrop-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the scrollbar in the grid and view the records by scroll through the grid manually
///<br/>allowScrolling-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable dynamic searching behavior in grid. Currently search box can be enabled through â€œtoolbarSettingsâ€
///<br/>allowSearching-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether user can select rows on grid. On enabling feature, selected row will be highlighted.
///<br/>allowSelection-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether the Content will wrap to the next line if the content exceeds the boundary of the Column Cells.
///<br/>allowTextWrap-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the multiple exporting behavior on grid data.
///<br/>allowMultipleExporting-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates to define common width for all the columns in the grid.
///<br/>commonWidth-number	default-
///<br/><br/>
///Gets or sets a value that indicates to enable the visibility of the grid lines.
///<br/>gridLines-ej.Grid.GridLines|string	default-ej.Grid.GridLines.Both
///<br/><br/>
///This specifies the grid to add the grid control inside the grid row of the parent with expand/collapse options
///<br/>childGrid-any	default-null
///<br/><br/>
///Sets the clip mode for Grid cell as ellipsis or clipped content(both header and content)
///<br/>clipMode-ej.Grid.ClipMode|string	default-ej.Grid.ClipMode.Clip
///<br/><br/>
///Used to enable or disable static width settings for column. If the columnLayout is set as fixed, then column width will be static.
///<br/>columnLayout-ej.Grid.ColumnLayout|string	default-ej.Grid.ColumnLayout.Auto
///<br/><br/>
///Gets or sets an object that indicates to render the grid with specified columns
///<br/>columns-Array&lt;Columns&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to enable editing behavior for particular column.
///<br/>allowEditing-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable dynamic filtering behavior for particular column.
///<br/>allowFiltering-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable dynamic grouping behavior for particular column.
///<br/>allowGrouping-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable dynamic sorting behavior for particular column.
///<br/>allowSorting-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable dynamic resizable for particular column.
///<br/>allowResizing-boolean	default-true
///<br/><br/>
///Gets or sets an object that indicates to define a command column in the grid.
///<br/>commands-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets an object that indicates to define all the button options which are available in ejButton.
///<br/>buttonOptions-any	default-
///<br/><br/>
///Gets or sets a value that indicates to add the command column button. See unboundType
///<br/>type-ej.Grid.UnboundType|string	default-
///<br/><br/>
///Gets or sets a value that indicates to provide custom CSS for an individual column.
///<br/>cssClass-string	default-
///<br/><br/>
///Gets or sets a value that indicates the attribute values to the td element of a particular column
///<br/>customAttributes-any	default-
///<br/><br/>
///Gets or sets a value that indicates to bind the external datasource to the particular column when column editType as dropdownedit and also it is used to bind the datasource to the foreign key column while editing the grid. //Where data is array of JSON objects of text and value for the drop-down and array of JSON objects for foreign key column.
///<br/>dataSource-any	default-null
///<br/><br/>
///Gets or sets a value that indicates to display the specified default value while adding a new record to the grid
///<br/>defaultValue-string|number|boolean|Date	default-
///<br/><br/>
///Gets or sets a value that indicates to render the grid content and header with an HTML elements
///<br/>disableHtmlEncode-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates to display a column value as checkbox or string
///<br/>displayAsCheckbox-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates to customize ejNumericTextbox of an editable column. See editingType
///<br/>editParams-any	default-
///<br/><br/>
///Gets or sets a template that displays a custom editor used to edit column values. See editTemplate
///<br/>editTemplate-any	default-null
///<br/><br/>
///Gets or sets a value that indicates to render the element(based on edit type) for editing the grid record. See editingType
///<br/>editType-ej.Grid.EditingType|string	default-ej.Grid.EditingType.String
///<br/><br/>
///Gets or sets a value that indicates to groups the column based on its column format.
///<br/>enableGroupByFormat-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates to display the columns in the grid mapping with column name of the dataSource.
///<br/>field-string	default-
///<br/><br/>
///Gets or sets a template that customize the filter control from default . See filterBarTemplate
///<br/>filterBarTemplate-any	default-null
///<br/><br/>
///Gets or sets a value that indicates to render the excel or menu filter dialog to the grid columns. See filterType
///<br/>filterType-ej.Grid.FilterType|string	default-null
///<br/><br/>
///Gets or sets a value that indicates to define foreign key field name of the grid datasource.
///<br/>foreignKeyField-string	default-null
///<br/><br/>
///Gets or sets a value that indicates to bind the field which is in foreign column datasource based on the foreignKeyField
///<br/>foreignKeyValue-string	default-null
///<br/><br/>
///Gets or sets a value that indicates the format for the text applied on the column
///<br/>format-string	default-
///<br/><br/>
///Gets or sets a value that indicates to add the template within the header element of the particular column.
///<br/>headerTemplateID-string	default-null
///<br/><br/>
///Gets or sets a value that indicates to display the title of that particular column.
///<br/>headerText-string	default-
///<br/><br/>
///This defines the text alignment of a particular column header cell value. See headerTextAlign
///<br/>headerTextAlign-ej.TextAlign|string	default-null
///<br/><br/>
///It accepts the string value and shows the tooltip for the Grid column header.
///<br/>headerTooltip-string	default-null
///<br/><br/>
///You can use this property to freeze selected columns in grid at the time of scrolling.
///<br/>isFrozen-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates the column has an identity in the database.
///<br/>isIdentity-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates the column is act as a primary key(read-only) of the grid. The editing is performed based on the primary key column
///<br/>isPrimaryKey-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates the order of Column that are to be hidden or visible when Grid element is in responsive mode and could not occupy all columns.
///<br/>priority-number	default--1
///<br/><br/>
///Used to hide the particular column in column chooser by giving value as false.
///<br/>showInColumnChooser-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enables column template for a particular column.
///<br/>template-boolean|string	default-false
///<br/><br/>
///Gets or sets a value that indicates to align the text within the column. See textAlign
///<br/>textAlign-ej.TextAlign|string	default-ej.TextAlign.Left
///<br/><br/>
///Sets the template for Tooltip in Grid Columns(both header and content)
///<br/>tooltip-string	default-
///<br/><br/>
///Gets or sets a value that indicates to specify the data type of the specified columns.
///<br/>type-string	default-
///<br/><br/>
///Gets or sets a value that indicates to define constraints for saving data to the database.
///<br/>validationRules-any	default-
///<br/><br/>
///Gets or sets a value that indicates whether this column is visible in the grid.
///<br/>visible-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates to define the width for a particular column in the grid.
///<br/>width-number	default-
///<br/><br/>
///Gets or sets an object that indicates whether to customize the context menu behavior of the grid.
///<br/>contextMenuSettings-ContextMenuSettings	default-
///<br/><br/>
///Gets or sets a value that indicates whether to add the default context menu actions as a context menu items If enableContextMenu is true it will show all the items related to the target, if you want selected items from contextmenu you have to mention in the contextMenuItems
///<br/>contextMenuItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to add custom contextMenu items within the toolbar to perform any action in the grid
///<br/>customContextMenuItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to enable the context menu action in the grid.
///<br/>enableContextMenu-boolean	default-false
///<br/><br/>
///Used to get or set the subMenu to the corresponding custom context menu item.
///<br/>subContextMenu-Array&lt;any&gt;	default-
///<br/><br/>
///Used to get or set the corresponding custom context menu item to which the submenu to be appended.
///<br/>contextMenuItem-string	default-null
///<br/><br/>
///Used to get or set the sub menu items to the custom context menu item.
///<br/>subMenu-Array&lt;any&gt;	default-[]
///<br/><br/>
///Used to get or set the sub menu items to the custom context menu item using JsRender template.
///<br/>template-string	default-null
///<br/><br/>
///Gets or sets a value that indicates whether to disable the default context menu items in the grid.
///<br/>disableDefaultItems-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates to render the grid with custom theme.
///<br/>cssClass-string	default-
///<br/><br/>
///Gets or sets the data to render the grid with records
///<br/>dataSource-any	default-null
///<br/><br/>
///Default Value:
///<br/>detailsTemplate-string	default-null
///<br/><br/>
///Gets or sets an object that indicates whether to customize the editing behavior of the grid.
///<br/>editSettings-EditSettings	default-
///<br/><br/>
///Gets or sets a value that indicates whether to enable insert action in the editing mode.
///<br/>allowAdding-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the delete action in the editing mode.
///<br/>allowDeleting-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the edit action in the editing mode.
///<br/>allowEditing-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the editing action while double click on the record
///<br/>allowEditOnDblClick-boolean	default-true
///<br/><br/>
///This specifies the id of the template. This template can be used to display the data that you require to be edited using the Dialog Box
///<br/>dialogEditorTemplateID-string	default-null
///<br/><br/>
///Gets or sets a value that indicates whether to define the mode of editing See editMode
///<br/>editMode-ej.Grid.EditMode|string	default-ej.Grid.EditMode.Normal
///<br/><br/>
///This specifies the id of the template. This template can be used to display the data that you require to be edited using the External edit form
///<br/>externalFormTemplateID-string	default-null
///<br/><br/>
///This specifies to set the position of an External edit form either in the top-right or bottom-left of the grid. See formPosition
///<br/>formPosition-ej.Grid.FormPosition|string	default-ej.Grid.FormPosition.BottomLeft
///<br/><br/>
///This specifies the id of the template. This template can be used to display the data that you require to be edited using the Inline edit form
///<br/>inlineFormTemplateID-string	default-null
///<br/><br/>
///This specifies to set the position of an adding new row either in the top or bottom of the grid. See rowPosition
///<br/>rowPosition-ej.Grid.RowPosition|string	default-ej.Grid.RowPosition.Top
///<br/><br/>
///Gets or sets a value that indicates whether the confirm dialog has to be shown while saving or discarding the batch changes
///<br/>showConfirmDialog-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether the confirm dialog has to be shown while deleting record
///<br/>showDeleteConfirmDialog-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether the title for edit form is different from the primarykey column.
///<br/>titleColumn-string	default-null
///<br/><br/>
///Gets or sets a value that indicates whether to display the add new form by default in the grid.
///<br/>showAddNewRow-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the alternative rows differentiation in the grid records based on corresponding theme.
///<br/>enableAltRow-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable the save action in the grid through row selection
///<br/>enableAutoSaveOnSelectionChange-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable mouse over effect on the corresponding column header cell of the grid
///<br/>enableHeaderHover-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to persist the grid model state in page using applicable medium i.e., HTML5 localStorage or cookies
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether the grid rows has to be rendered as detail view in mobile mode
///<br/>enableResponsiveRow-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable mouse over effect on corresponding grid row.
///<br/>enableRowHover-boolean	default-true
///<br/><br/>
///Align content in the grid control from right to left by setting the property as true.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///To Disable the mouse swipe property as false.
///<br/>enableTouch-boolean	default-true
///<br/><br/>
///It sets a value that indicates whether to enable toolbar items, when allowEditing, allowAdding and allowDeleting property set as false in the grid.
///<br/>enableToolbarItems-boolean	default-false
///<br/><br/>
///Act as mapper for the excel exporting URL.
///<br/>exportToExcelAction-string	default-ExportToExcel
///<br/><br/>
///Act as mapper for the PDF exporting URL.
///<br/>exportToPdfAction-string	default-ExportToPdf
///<br/><br/>
///Act as mapper for the Word exporting URL.
///<br/>exportToWordAction-string	default-ExportToWord
///<br/><br/>
///Gets or sets an object that indicates whether to customize the filtering behavior of the grid
///<br/>filterSettings-FilterSettings	default-
///<br/><br/>
///Gets or sets a value that indicates to perform the filter operation with case sensitive in excel styled filter menu mode
///<br/>enableCaseSensitivity-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates to define the interDeterminateState of checkbox in excel filter dialog.
///<br/>enableInterDeterminateState-boolean	default-true
///<br/><br/>
///This specifies the grid to starts the filter action while typing in the filterBar or after pressing the enter key. based on the filterBarMode. See filterBarMode.
///<br/>filterBarMode-ej.Grid.FilterBarMode|string	default-ej.Grid.FilterBarMode.Immediate
///<br/><br/>
///Gets or sets a value that indicates whether to define the filtered columns details programmatically at initial load
///<br/>filteredColumns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to define the field name of the column to be filter.
///<br/>field-string	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define the matchCase of given value to be filter.
///<br/>matchCase-boolean	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define the filter condition to filtered column. See operator
///<br/>operator-ej.FilterOperators|string	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define the predicate as and/or.
///<br/>predicate-string	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define the value to be filtered in a column.
///<br/>value-string|number	default-
///<br/><br/>
///This specifies the grid to show the filterBar or filterMenu to the grid records. See filterType
///<br/>filterType-ej.Grid.FilterType|string	default-ej.Grid.FilterType.FilterBar
///<br/><br/>
///This specifies the grid to delay the filter action while typing in the filterBar.
///<br/>immediateModeDelay-number	default-1500
///<br/><br/>
///Gets or sets a value that indicates the maximum number of filter choices that can be showed in the excel styled filter menu.
///<br/>maxFilterChoices-number	default-1000
///<br/><br/>
///This specifies the grid to show the filter text within the grid pager itself.
///<br/>showFilterBarStatus-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable the predicate options in the filtering menu
///<br/>showPredicate-boolean	default-false
///<br/><br/>
///Gets or sets an object that indicates whether to customize the grouping behavior of the grid.
///<br/>groupSettings-GroupSettings	default-
///<br/><br/>
///Gets or sets a value that customize the group caption format.
///<br/>captionFormat-string	default-null
///<br/><br/>
///Gets or sets a value that indicates whether to enable animation button option in the group drop area of the grid.
///<br/>enableDropAreaAutoSizing-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to add grouped columns programmatically at initial load
///<br/>groupedColumns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to show the group drop area just above the column header. It can be used to avoid ungrouping the already grouped column using groupSettings.
///<br/>showDropArea-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to hide the grouped columns from the grid
///<br/>showGroupedColumn-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to show the group button image(toggle button)in the column header and also in the grouped column in the group drop area . It can be used to group/ungroup the columns by click on the toggle button.
///<br/>showToggleButton-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the close button in the grouped column which is in the group drop area to ungroup the grouped column
///<br/>showUngroupButton-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether the grid design has be to made responsive.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///This specifies to change the key in keyboard interaction to grid control
///<br/>keySettings-any	default-null
///<br/><br/>
///Gets or sets a value that indicates whether to customizing the user interface (UI) as locale-specific in order to display regional data i.e. in a language and culture specific to a particular country or region.
///<br/>locale-string	default-en-US
///<br/><br/>
///Gets or sets a value that indicates whether to set the minimum width of the responsive grid while isResponsive property is true and enableResponsiveRow property is set as false.
///<br/>minWidth-number	default-0
///<br/><br/>
///Gets or sets an object that indicates whether to modify the pager default configuration.
///<br/>pageSettings-PageSettings	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define which page to display currently in the grid
///<br/>currentPage-number	default-1
///<br/><br/>
///Gets or sets a value that indicates whether to pass the current page information as a query string along with the URL while navigating to other page.
///<br/>enableQueryString-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enables pager template for the grid.
///<br/>enableTemplates-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to define the number of pages displayed in the pager for navigation
///<br/>pageCount-number	default-8
///<br/><br/>
///Gets or sets a value that indicates whether to define the number of records displayed per page
///<br/>pageSize-number	default-12
///<br/><br/>
///Gets or sets different page size values to the Dropdown in Grid Pager, by which number of records in a page can be changed dynamically.
///<br/>pageSizeList-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to enables default pager for the grid.
///<br/>showDefaults-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates to add the template as a pager template for grid.
///<br/>template-string	default-null
///<br/><br/>
///Get the value of total number of pages in the grid. The totalPages value is calculated based on page size and total records of grid
///<br/>totalPages-number	default-null
///<br/><br/>
///Get the value of total number of records which is bound to the grid. The totalRecordsCount value is calculated based on dataSource bound to the grid.
///<br/>totalRecordsCount-number	default-null
///<br/><br/>
///Gets or sets a value that indicates whether to define the number of pages to print. See printMode.
///<br/>printMode-ej.Grid.PrintMode|string	default-ej.Grid.PrintMode.AllPages
///<br/><br/>
///Query the dataSource from the table for Grid.
///<br/>query-any	default-null
///<br/><br/>
///Gets or sets an object that indicates whether to modify the resizing behavior.
///<br/>resizeSettings-ResizeSettings	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define the mode of resizing.
///<br/>resizeMode-ej.Grid.ResizeMode|string	default-ej.Grid.ResizeMode.Normal
///<br/><br/>
///Gets or sets a value that indicates to render the grid with template rows. The template row must be a table row. That table row must have the JavaScript render binding format ({{:columnName}}) then the grid data source binds the data to the corresponding table row of the template.
///<br/>rowTemplate-string	default-null
///<br/><br/>
///Gets or sets an object that indicates whether to customize the drag and drop behavior of the grid rows
///<br/>rowDropSettings-RowDropSettings	default-
///<br/><br/>
///This specifies the grid to drop the grid rows only at particular target element.
///<br/>dropTargetID-any	default-null
///<br/><br/>
///This helps in mapping server-side action when rows are dragged from Grid.
///<br/>dragMapper-string	default-null
///<br/><br/>
///This helps in mapping server-side action when rows are dropped in Grid.
///<br/>dropMapper-string	default-null
///<br/><br/>
///Gets or sets a value that indicates whether move or copy a record from one grid to another or within the grid
///<br/>dragBehavior-ej.Grid.DragBehavior|string	default-ej.Grid.DragBehavior.Move
///<br/><br/>
///Gets or sets an object that indicates whether to customize the searching behavior of the grid
///<br/>searchSettings-SearchSettings	default-
///<br/><br/>
///This specify the grid to search for the value in particular columns that is mentioned in the field.
///<br/>fields-any	default-[]
///<br/><br/>
///This specifies the grid to search the particular data that is mentioned in the key.
///<br/>key-string	default-
///<br/><br/>
///It specifies the grid to search the records based on operator.
///<br/>operator-string	default-contains
///<br/><br/>
///It enables or disables case-sensitivity while searching the search key in grid.
///<br/>ignoreCase-boolean	default-true
///<br/><br/>
///Gets a value that display the array of selected records in the Grid.
///<br/>selectedRecords-Array&lt;any&gt;	default-null
///<br/><br/>
///Gets or sets a value that indicates to select the row while initializing the grid
///<br/>selectedRowIndex-number	default--1
///<br/><br/>
///Gets or sets a value that indicates the selected rows in grid
///<br/>selectedRowIndices-Array&lt;any&gt;	default-[]
///<br/><br/>
///This property is used to configure the selection behavior of the grid.
///<br/>selectionSettings-SelectionSettings	default-
///<br/><br/>
///Gets or sets a value that indicates the cell selection actions based on the cell selection mode.
///<br/>cellSelectionMode-ej.Grid.CellSelectionMode|string	default-ej.Grid.CellSelectionMode.Flow
///<br/><br/>
///Gets or sets a value that indicates whether to enable the toggle selection behavior for row, cell and column.
///<br/>enableToggle-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to select multiple rows or cells by performing dragging in Grid.
///<br/>allowDragSelection-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to add the default selection actions as a selection mode.See selectionMode
///<br/>selectionMode-Array&lt;any&gt;	default-[row]
///<br/><br/>
///The row selection behavior of grid. Accepting types are "single" and "multiple".
///<br/>selectionType-ej.Grid.SelectionType|string	default-ej.Grid.SelectionType.Single
///<br/><br/>
///Gets or sets an object that indicates whether to customize the scrolling behavior of the grid.
///<br/>scrollSettings-ScrollSettings	default-
///<br/><br/>
///This specify the grid to to view data that you require without buffering the entire load of a huge database
///<br/>allowVirtualScrolling-boolean	default-false
///<br/><br/>
///It accepts the boolean value and shows or hides the scrollbar while focus in or focus out of the Grid.
///<br/>autoHide-boolean	default-false
///<br/><br/>
///Specifies the height and width of button in the scrollbar.
///<br/>buttonSize-number	default-18
///<br/><br/>
///This specify the grid to enable/disable touch control for scrolling.
///<br/>enableTouchScroll-boolean	default-true
///<br/><br/>
///This specify the grid to freeze particular columns at the time of scrolling.
///<br/>frozenColumns-number	default-0
///<br/><br/>
///This specify the grid to freeze particular rows at the time of scrolling.
///<br/>frozenRows-number	default-0
///<br/><br/>
///This specify the grid to show the vertical scroll bar, to scroll and view the grid contents.
///<br/>height-string|number	default-0
///<br/><br/>
///It accepts the integer value and sets the width of scrollbar.
///<br/>scrollerSize-number	default-18
///<br/><br/>
///This is used to define the mode of virtual scrolling in grid. See virtualScrollMode
///<br/>virtualScrollMode-ej.Grid.VirtualScrollMode|string	default-ej.Grid.VirtualScrollMode.Normal
///<br/><br/>
///This is used to enable the enhanced virtual scrolling in Grid.
///<br/>enableVirtualization-boolean	default-false
///<br/><br/>
///This specify the grid to show the horizontal scroll bar, to scroll and view the grid contents
///<br/>width-string|number	default-250
///<br/><br/>
///This specify the scroll down pixel of mouse wheel, to scroll mouse wheel and view the grid contents.
///<br/>scrollOneStepBy-number	default-57
///<br/><br/>
///Default Value:
///<br/>showColumnChooser-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates stacked header should be shown on grid layout when the property â€œstackedHeaderRowsâ€ is set.
///<br/>showStackedHeader-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates summary rows should be shown on grid layout when the property â€œsummaryRowsâ€ is set
///<br/>showSummary-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to customize the sorting behavior of the grid.
///<br/>sortSettings-SortSettings	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define the direction and field to sort the column.
///<br/>sortedColumns-Array&lt;any&gt;	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define the direction to sort the column.
///<br/>direction-string	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define the field name of the column to be sort
///<br/>field-string	default-
///<br/><br/>
///Gets or sets an object that indicates to managing the collection of stacked header rows for the grid.
///<br/>stackedHeaderRows-Array&lt;StackedHeaderRows&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to add stacked header columns into the stacked header rows
///<br/>stackedHeaderColumns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates the header text for the particular stacked header column.
///<br/>column-any	default-null
///<br/><br/>
///Gets or sets a value that indicates class to the corresponding stackedHeaderColumn.
///<br/>cssClass-string	default-null
///<br/><br/>
///Gets or sets a value that indicates the header text for the particular stacked header column.
///<br/>headerText-string	default-null
///<br/><br/>
///Gets or sets a value that indicates the text alignment of the corresponding headerText.
///<br/>textAlign-string	default-ej.TextAlign.Left
///<br/><br/>
///Sets the template for tooltip for the Grid stackedHeaderColumns.
///<br/>tooltip-string	default-null
///<br/><br/>
///Gets or sets an object that indicates to managing the collection of summary rows for the grid.
///<br/>summaryRows-Array&lt;SummaryRows&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to show the summary value within the group caption area for the corresponding summary column while grouping the column
///<br/>showCaptionSummary-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to show the group summary value for the corresponding summary column while grouping a column
///<br/>showGroupSummary-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to show the total summary value the for the corresponding summary column. The summary row is added after the grid content.
///<br/>showTotalSummary-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to add summary columns into the summary rows.
///<br/>summaryColumns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates the text displayed in the summary column as a value
///<br/>customSummaryValue-string	default-null
///<br/><br/>
///This specifies summary column used to perform the summary calculation
///<br/>dataMember-string	default-null
///<br/><br/>
///Gets or sets a value that indicates to define the target column at which to display the summary.
///<br/>displayColumn-string	default-null
///<br/><br/>
///Gets or sets a value that indicates the format for the text applied on the column
///<br/>format-string	default-null
///<br/><br/>
///Gets or sets a value that indicates the text displayed before the summary column value
///<br/>prefix-string	default-null
///<br/><br/>
///Gets or sets a value that indicates the text displayed after the summary column value
///<br/>suffix-string	default-null
///<br/><br/>
///Gets or sets a value that indicates the type of calculations to be performed for the corresponding summary column. See summaryType.
///<br/>summaryType-ej.Grid.SummaryType|string	default-[]
///<br/><br/>
///Gets or sets a value that indicates to add the template for the summary value of dataMember given.
///<br/>template-string	default-null
///<br/><br/>
///This specifies the grid to show the title for the summary rows.
///<br/>title-string	default-
///<br/><br/>
///This specifies the grid to show the title of summary row in the specified column.
///<br/>titleColumn-string	default-null
///<br/><br/>
///Gets or sets an object that indicates whether to auto wrap the grid header or content or both
///<br/>textWrapSettings-TextWrapSettings	default-
///<br/><br/>
///This specifies the grid to apply the auto wrap for grid content or header or both.
///<br/>wrapMode-ej.Grid.WrapMode|string	default-ej.Grid.WrapMode.Both
///<br/><br/>
///Gets or sets an object that indicates whether to enable the toolbar in the grid and add toolbar items
///<br/>toolbarSettings-ToolbarSettings	default-
///<br/><br/>
///Gets or sets a value that indicates whether to add custom toolbar items within the toolbar to perform any action in the grid
///<br/>customToolbarItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates whether to add custom toolbar item as a template element.
///<br/>templateID-string	default-
///<br/><br/>
///Gets or sets a value that indicates whether to add custom toolbar item with a custom tooltip.
///<br/>tooltip-string	default-
///<br/><br/>
///Gets or sets a value that indicates whether to enable toolbar in the grid.
///<br/>showToolbar-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to add the default editing actions as a toolbar items. See toolbarItems.
///<br/>toolbarItems-array&lt;ej.Grid.ToolBarItems|string&gt;	default-[]
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
GroupButton:function(){
 /// <signature>
 /// <summary>Constructor of ej.GroupButton</summary>
 /// </signature>
}
});
ej.GroupButton=(function(){
var original=ej.GroupButton
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

deselectItem:function(element){
/// <signature>
/// <summary>
/// Remove the selection state of the specified the button element from the GroupButton
/// </summary>
/// <param name="element"	type="JQuery">Specific button element</param>
/// </signature>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroy the GroupButton widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// Disables the GroupButton control
/// </summary>
},
disableItem:function(element){
/// <signature>
/// <summary>
/// Disable the specified button element from the ejGroupButton control.
/// </summary>
/// <param name="element"	type="JQuery">Specific button element</param>
/// </signature>
},
enable:function(){
/// <signature>
/// <summary>
/// Enables the disabled ejGroupButton control.
/// </summary>
},
enableItem:function(element){
/// <signature>
/// <summary>
/// Enable the specified disabled button element from the ejGroupButton control.
/// </summary>
/// <param name="element"	type="JQuery">Specific button element</param>
/// </signature>
},
getIndex:function(element){
/// <signature>
/// <summary>
/// Returns the index value for specified button element in the GroupButton control.
/// </summary>
/// <param name="element"	type="JQuery">Specific button element</param>
/// </signature>
},
getSelectedItem:function(){
/// <signature>
/// <summary>
/// This method returns the list of active state button elements from the GroupButton control.
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// Hides the GroupButton control
/// </summary>
},
hideItem:function(element){
/// <signature>
/// <summary>
/// Hide the specified button element from the ejGroupButton control.
/// </summary>
/// <param name="element"	type="JQuery">Specific button element</param>
/// </signature>
},
isDisabled:function(){
/// <signature>
/// <summary>
/// Returns the disabled state of the specified element button element in GroupButton as Boolean.
/// </summary>
},
isSelected:function(){
/// <signature>
/// <summary>
/// Returns the state of the specified button element as Boolean.
/// </summary>
},
selectItem:function(element){
/// <signature>
/// <summary>
/// Public method used to select the specified button element from the ejGroupButton control.
/// </summary>
/// <param name="element"	type="JQuery">Specific button element</param>
/// </signature>
},
show:function(){
/// <signature>
/// <summary>
/// Shows the GroupButton control, if its hide.
/// </summary>
},
showItem:function(element){
/// <signature>
/// <summary>
/// Show the specified hidden button element from the ejGroupButton control.
/// </summary>
/// <param name="element"	type="JQuery">Specific button element</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejGroupButton=function(){
this.data("ejGroupButton",new	ej.GroupButton());
return this;
};
intellisense.annotate(jQuery.fn,{
ejGroupButton :function (options) {
/// <signature>
/// <summary><br/>
///The Essential JavaScript Group Button widget helps to display multiple buttons which are stacked together in a single line and used as a navigation component. Also it manages the checked/unchecked state for a set of buttons, since it supports radio and check button modes.<br/><br/>
///Sets the specified class to GroupButton wrapper element, which allows for custom skinning option in ejGroupButton control.
///<br/>cssClass-string	default-
///<br/><br/>
///To set the local JSON data, define a JSON array and initialize the GroupButton with dataSource property. Specify the column names in the fields property.
///<br/>dataSource-any	default-null
///<br/><br/>
///Displays the ejGroupButton in Right to Left direction.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Used to enable or disable the ejGroupButton control.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates to display the values of the data.
///<br/>fields-any	default-null
///<br/><br/>
///Sets the GroupButton behavior to works as Checkbox mode/ radio button mode based on the specified option.
///<br/>groupButtonMode-ej.GroupButtonMode | string	default-ej.GroupButtonMode.RadioButton
///<br/><br/>
///Used to sets the height of the ejGroupButton control.
///<br/>height-string|number	default-28
///<br/><br/>
///Defines the characteristics of the ejGroupButton control and extend the capability of an HTML element by adding specified attributes to element tag and by performing the related actions
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Specify the orientation of the GroupButton. See below to get available orientations
///<br/>orientation-ej.Orientation|string	default-ej.Orientation.Horizontal
///<br/><br/>
///Query the dataSource from the table for Groupbutton
///<br/>query-any	default-null
///<br/><br/>
///Sets the list of button elements to be selected. To enable this option groupButtonMode should be in â€œcheckboxâ€ mode.
///<br/>selectedItemIndex-number[]|string[]	default-[]
///<br/><br/>
///Sets the rounder corner to the GroupButton, if sets as true.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Specifies the size of the button. See available size
///<br/>size-ej.ButtonSize|string	default-ej.ButtonSize.Normal
///<br/><br/>
///Defines the width of the ejGroupButton control.
///<br/>width-string|number	default-
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
HeatMap:function(){
 /// <signature>
 /// <summary>Constructor of ej.HeatMap</summary>
 /// </signature>
}
});
ej.HeatMap=(function(){
var original=ej.HeatMap
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejHeatMap=function(){
this.data("ejHeatMap",new	ej.HeatMap());
return this;
};
intellisense.annotate(jQuery.fn,{
ejHeatMap :function (options) {
/// <signature>
/// <summary><br/>
///Essential HeatMap JS represents tabular data values as gradient colors instead of numbers,low and high values are different colors with different gradients.<br/><br/>
///Specifies the width of the heat map.
///<br/>width-any	default-null
///<br/><br/>
///Specifies the width of the heat map.
///<br/>height-any	default-null
///<br/><br/>
///Specifies the name of the heat map.
///<br/>id-number	default-null
///<br/><br/>
///Enables or disables tooltip of heatmap
///<br/>showTooltip-boolean	default-true
///<br/><br/>
///Defines the tooltip that should be shown when the mouse hovers over rows/columns.
///<br/>tooltipSettings-TooltipSettings	default-
///<br/><br/>
///Defines the tooltip that should be shown when the mouse hovers over rows/columns.
///<br/>templateId-string	default-null
///<br/><br/>
///Defines the tooltip of associate that should be shown when the mouse hovers over rows/columns.
///<br/>associate-ej.datavisualization.HeatMap.Associate|string	default-mouseFollow
///<br/><br/>
///Enables/ disables the balloon for the tooltip to be shown
///<br/>isBalloon-boolean	default-true
///<br/><br/>
///Defines various attributes of the Tooltip position
///<br/>position-any	default-
///<br/><br/>
///Sets the Tooltip position against target.
///<br/>target-any	default-
///<br/><br/>
///Sets the arrow position again popup based on horizontal(x) value
///<br/>horizontal-ej.datavisualization.HeatMap.Horizontal|string	default-center
///<br/><br/>
///Sets the arrow position again popup based on vertical(y) value
///<br/>vertical-ej.datavisualization.HeatMap.Vertical|string	default-top
///<br/><br/>
///Sets the arrow position again popup.
///<br/>stem-any	default-
///<br/><br/>
///Sets the arrow position again popup based on horizontal(x) value
///<br/>horizontal-ej.datavisualization.HeatMap.Horizontal|string	default-center
///<br/><br/>
///Sets the arrow position again popup based on vertical(y) value
///<br/>vertical-ej.datavisualization.HeatMap.Vertical|string	default-bottom
///<br/><br/>
///Defines the tooltip to be triggered.
///<br/>trigger-ej.datavisualization.HeatMap.Trigger|string	default-hover
///<br/><br/>
///Defines the animation for the tooltip that should be shown when the mouse hovers over rows/columns.
///<br/>animation-any	default-
///<br/><br/>
///Defines the animation effect for the tooltip that should be shown when the mouse hovers over rows/columns.
///<br/>effect-ej.datavisualization.HeatMap.Effect|string	default-none
///<br/><br/>
///Defines the animation speed for the tooltip that should be shown when the mouse hovers over rows/columns.
///<br/>speed-number	default-0
///<br/><br/>
///Specifies the source data of the heat map.
///<br/>itemsSource-any	default-[]
///<br/><br/>
///Specifies the property of the heat map cell.
///<br/>heatMapCell-HeatMapCell	default-Null
///<br/><br/>
///Specifies whether the cell content can be visible or not.
///<br/>showContent-ej.datavisualization.HeatMap.CellVisibility|string	default-ej.HeatMap.CellVisibility.Visible
///<br/><br/>
///Specifies whether the cell color can be visible or not.
///<br/>showColor-boolean	default-true
///<br/><br/>
///Specifies can enable responsive mode or not for heat map.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Specifies whether the virtualization can be enable or not.
///<br/>enableVirtualization-boolean	default-false
///<br/><br/>
///Specifies the default column properties for all the column style not specified in column properties.
///<br/>defaultColumnStyle-DefaultColumnStyle	default-[]
///<br/><br/>
///Specifies the alignment mode of the heat map column.
///<br/>textAlign-any	default-ej.HeatMap.TextAlign.Center
///<br/><br/>
///Specifies the template id of the heat map column header.
///<br/>headerTemplateID-string	default-
///<br/><br/>
///Specifies the template id of all individual cell data of the heat map.
///<br/>templateID-string	default-
///<br/><br/>
///Specifies the no of legends can sync with heat map.
///<br/>legendCollection-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the property and display value of the heat map column.
///<br/>itemsMapping-ItemsMapping	default-[]
///<br/><br/>
///Column settings for the individual heat map column.
///<br/>columnStyle-any	default-null
///<br/><br/>
///Specifies the width of the heat map column.
///<br/>width-number	default-0
///<br/><br/>
///Specifies the text align mode of the heat map column.
///<br/>textAlign-string	default-ej.HeatMap.TextAlign.Center
///<br/><br/>
///Specifies the template id of the column header.
///<br/>headerTemplateID-string	default-
///<br/><br/>
///Specifies the template id of all individual cell data.
///<br/>templateID-string	default-
///<br/><br/>
///Specifies the property and display value of the column.
///<br/>column-any	default-null
///<br/><br/>
///Specifies the name of the column or row.
///<br/>propertyName-string	default-
///<br/><br/>
///Specifies the value of the column or row.
///<br/>displayName-string	default-
///<br/><br/>
///Specifies the row property and display value of the heat map.
///<br/>row-any	default-null
///<br/><br/>
///Specifies the name of the column or row.
///<br/>propertyName-string	default-
///<br/><br/>
///Specifies the value of the column or row.
///<br/>displayName-string	default-
///<br/><br/>
///Specifies the property and display value of the column value.
///<br/>value-any	default-null
///<br/><br/>
///Specifies the name of the column or row.
///<br/>propertyName-string	default-
///<br/><br/>
///Specifies the value of the column or row.
///<br/>displayName-string	default-
///<br/><br/>
///Specifies the property and display value of the header.
///<br/>headerMapping-any	default-null
///<br/><br/>
///Specifies the name of the column or row.
///<br/>propertyName-string	default-
///<br/><br/>
///Specifies the value of the column or row.
///<br/>displayName-string	default-
///<br/><br/>
///Specifies the property and display value of the header.
///<br/>columnStyle-any	default-null
///<br/><br/>
///Specifies the property and display value of the collection of column.
///<br/>columnMapping-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the color values of the heat map column data.
///<br/>colorMappingCollection-Array&lt;ColorMappingCollection&gt;	default-[]
///<br/><br/>
///Specifies the color of the heat map column data.
///<br/>color-string	default-white
///<br/><br/>
///Specifies the color values of the heat map column data.
///<br/>value-number	default-0
///<br/><br/>
///Specifies the label properties of the heat map color.
///<br/>label-any	default-null
///<br/><br/>
///Enables/disables the bold style of the heat map label.
///<br/>bold-boolean	default-false
///<br/><br/>
///Enables/disables the italic style of the heat map label.
///<br/>italic-boolean	default-false
///<br/><br/>
///specifies the text value of the heat map label.
///<br/>text-string	default-
///<br/><br/>
///Specifies the text style of the heat map label.
///<br/>textDecoration-ej.datavisualization.HeatMap.TextDecoration |string	default-ej.HeatMap.TextDecoration.None
///<br/><br/>
///Specifies the font size of the heat map label.
///<br/>fontSize-number	default-10
///<br/><br/>
///Specifies the font family of the heat map label.
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Specifies the font color of the heat map label.
///<br/>fontColor-string	default-black
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
HeatMapLegend:function(){
 /// <signature>
 /// <summary>Constructor of ej.HeatMapLegend</summary>
 /// </signature>
}
});
ej.HeatMapLegend=(function(){
var original=ej.HeatMapLegend
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejHeatMapLegend=function(){
this.data("ejHeatMapLegend",new	ej.HeatMapLegend());
return this;
};
intellisense.annotate(jQuery.fn,{
ejHeatMapLegend :function (options) {
/// <signature>
/// <summary><br/>
///Legend is a control used to summarize the range of colors in HeatMap. This gives visual guideline for mapping between value and color.<br/><br/>
///Specifies the width of the heatmap legend.
///<br/>width-any	default-null
///<br/><br/>
///Specifies the height of the heatmap legend.
///<br/>height-any	default-null
///<br/><br/>
///Specifies can enable responsive mode or not for heatmap legend.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Specifies whether the cell label can be shown or not.
///<br/>showLabel-boolean	default-false
///<br/><br/>
///Specifies the color values of the column data.
///<br/>colorMappingCollection-Array&lt;ColorMappingCollection&gt;	default-[]
///<br/><br/>
///Specifies the color of the heatmap legend data.
///<br/>color-string	default-white
///<br/><br/>
///Specifies the color values of the heatmap legend column data.
///<br/>value-number	default-0
///<br/><br/>
///Specifies the label properties of the heatmap legend color.
///<br/>label-any	default-null
///<br/><br/>
///Enables/disables the bold style of the heatmap legend label.
///<br/>bold-boolean	default-false
///<br/><br/>
///Enables/disables the italic style of the heatmap legend label.
///<br/>italic-boolean	default-false
///<br/><br/>
///specifies the text value of the heatmap legend label.
///<br/>text-string	default-
///<br/><br/>
///Specifies the text style of the heatmap legend label.
///<br/>textDecoration-ej.datavisualization.HeatMap.TextDecoration|string	default-ej.HeatMap.TextDecoration.None
///<br/><br/>
///Specifies the font size of the heatmap legend label.
///<br/>fontSize-number	default-10
///<br/><br/>
///Specifies the font family of the heatmap legend label.
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Specifies the font color of the heatmap legend label.
///<br/>fontColor-string	default-black
///<br/><br/>
///Specifies the orientation of the heatmap legend
///<br/>orientation-ej.datavisualization.HeatMap.LegendOrientation|string	default-ej.HeatMap.LegendOrientation.Horizontal
///<br/><br/>
///Specifies the legend mode as gradient or list.
///<br/>legendMode-ej.datavisualization.HeatMap.LegendMode|string	default-ej.HeatMap.LegendMode.Gradient
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Kanban:function(){
 /// <signature>
 /// <summary>Constructor of ej.Kanban</summary>
 /// </signature>
}
});
ej.Kanban=(function(){
var original=ej.Kanban
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

columns:function(columndetails, keyvalue, action){
/// <signature>
/// <summary>
/// Add or remove columns in Kanban columns collections.Default action is add.
/// </summary>
/// <param name="columndetails"	type="any[]|string">Pass array of columns or string of headerText to add/remove the column in Kanban</param>
/// </signature>
/// <signature>
/// <summary>
/// Add or remove columns in Kanban columns collections.Default action is add.
/// </summary>
/// <param name="keyvalue"	type="any[]|string">Pass array of columns or string of key value to add/remove the column in Kanban</param>
/// </signature>
/// <signature>
/// <summary>
/// Add or remove columns in Kanban columns collections.Default action is add.
/// </summary>
/// <param name="action"	type="string">optional Pass add/remove action to be performed. By default "add" action will perform</param>
/// </signature>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroy the Kanban widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
dataSource:function(datasource){
/// <signature>
/// <summary>
/// Refresh the Kanban with new data source.
/// </summary>
/// <param name="datasource"	type="any[]">Pass new data source to the Kanban</param>
/// </signature>
},
toggleColumn:function(headerText){
/// <signature>
/// <summary>
/// toggleColumn based on the headerText in Kanban.
/// </summary>
/// <param name="headerText"	type="any">Pass the header text of the column to get the corresponding column object</param>
/// </signature>
},
toggleCard:function(key){
/// <signature>
/// <summary>
/// Expand or collapse the card based on the state of target &quot;div&quot;
/// </summary>
/// <param name="key"	type="string|number">Pass the id of card to be toggle </param>
/// </signature>
},
getVisibleColumnNames:function(){
/// <signature>
/// <summary>
/// Used for get the names of all the visible column name collections in Kanban.
/// </summary>
},
getScrollObject:function(){
/// <signature>
/// <summary>
/// Get the scroller object of Kanban.
/// </summary>
},
getColumnByHeaderText:function(headerText){
/// <signature>
/// <summary>
/// Get the column details based on the given header text in Kanban.
/// </summary>
/// <param name="headerText"	type="string">Pass the header text of the column to get the corresponding column object</param>
/// </signature>
},
getHeaderTable:function(){
/// <signature>
/// <summary>
/// Get the table details based on the given header table in Kanban.
/// </summary>
},
hideColumns:function(headerText){
/// <signature>
/// <summary>
/// Hide columns from the Kanban based on the header text
/// </summary>
/// <param name="headerText"	type="any[]|string">you can pass either array of header text of various columns or a header text of a column to hide</param>
/// </signature>
},
print:function(){
/// <signature>
/// <summary>
/// Print the Kanban Board
/// </summary>
},
refreshTemplate:function(){
/// <signature>
/// <summary>
/// Refresh the template of the Kanban
/// </summary>
},
refresh:function(templateRefresh){
/// <signature>
/// <summary>
/// Refresh the Kanban contents.The template refreshment is based on the argument passed along with this method
/// </summary>
/// <param name="templateRefresh"	type="boolean">optional When templateRefresh is set true, template and Kanban contents both are refreshed in Kanban else only Kanban content is refreshed</param>
/// </signature>
},
showColumns:function(headerText){
/// <signature>
/// <summary>
/// Show columns in the Kanban based on the header text.
/// </summary>
/// <param name="headerText"	type="any[]|string">You can pass either array of header text of various columns or a header text of a column to show</param>
/// </signature>
},
updateCard:function(key, data){
/// <signature>
/// <summary>
/// Update a card in Kanban control based on key and JSON data given.
/// </summary>
/// <param name="key"	type="string">Pass the key field Name of the column</param>
/// </signature>
/// <signature>
/// <summary>
/// Update a card in Kanban control based on key and JSON data given.
/// </summary>
/// <param name="data"	type="any[]">Pass the edited JSON data of card need to be update.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejKanban=function(){
this.data("ejKanban",new	ej.Kanban());
return this;
};
intellisense.annotate(jQuery.fn,{
ejKanban :function (options) {
/// <signature>
/// <summary><br/>
///The Kanban can be easily configured to the DOM element, such as div. You can create a Kanban with a highly customizable look and feel.<br/><br/>
///Gets or sets a value that indicates whether to enable allowDragAndDrop behavior on Kanban.
///<br/>allowDragAndDrop-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to enable drag and drop behavior between Kanban controls.
///<br/>allowExternalDragAndDrop-boolean	default-false
///<br/><br/>
///To enable or disable the title of the card.
///<br/>allowTitle-boolean	default-false
///<br/><br/>
///Customize the settings for swim lane.
///<br/>swimlaneSettings-SwimlaneSettings	default-Object
///<br/><br/>
///To enable or disable items count in swim lane.
///<br/>showCount-boolean	default-true
///<br/><br/>
///To enable or disable DragAndDrop across swim lane.
///<br/>allowDragAndDrop-boolean	default-false
///<br/><br/>
///To enable or disable empty swimlane on Kanban board.  It is used to shown empty swimlane when no data's present on headers key mapping value.
///<br/>showEmptySwimlane-boolean	default-false
///<br/><br/>
///Gets or sets an object that indicates to render the swimlane rows with specified swimlane headers.
///<br/>headers-Array&lt;any&gt;	default-[]
///<br/><br/>
///Gets or sets a value that indicates to render the Kanban with specified swimlane header text.
///<br/>text-string	default-null
///<br/><br/>
///Gets or sets a value that indicates to render the Kanban with specified swimlane header key.
///<br/>key-string	default-null
///<br/><br/>
///Customize the settings for unassigned category of swim lane.
///<br/>unassignedGroup-any	default-Object
///<br/><br/>
///To enable or disable unassigned category change with swim lane key values.
///<br/>enable-boolean	default-true
///<br/><br/>
///To set the user defined values which are need to categorized as unassigned category swim lane groups.
///<br/>keys-Array&lt;any&gt;	default-[null,undefined,]
///<br/><br/>
///To enable or disable the column expand /collapse.
///<br/>allowToggleColumn-boolean	default-false
///<br/><br/>
///To enable Searching operation in Kanban.
///<br/>allowSearching-boolean	default-false
///<br/><br/>
///To enable filtering behavior on Kanban.User can specify query in filterSettings collection after enabling allowFiltering.
///<br/>allowFiltering-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable allowSelection behavior on Kanban.User can select card and the selected card will be highlighted on Kanban.
///<br/>allowSelection-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to allow card hover actions.
///<br/>allowHover-boolean	default-true
///<br/><br/>
///To allow keyboard navigation actions.
///<br/>allowKeyboardNavigation-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the scrollbar in the Kanban and view the card by scroll through the Kanban manually.
///<br/>allowScrolling-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable printing option.
///<br/>allowPrinting-boolean	default-false
///<br/><br/>
///Gets or sets an object that indicates whether to customize the context menu behavior of the Kanban.
///<br/>contextMenuSettings-ContextMenuSettings	default-Object
///<br/><br/>
///To enable context menu.All default context menu will show.
///<br/>enable-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates the list of items needs to be disable from default context menu items.
///<br/>disableDefaultItems-Array&lt;any&gt;	default-Array
///<br/><br/>
///Its used to add specific default context menu items.
///<br/>menuItems-Array&lt;any&gt;	default-Array
///<br/><br/>
///Gets or sets a value that indicates whether to add custom contextMenu items.
///<br/>customMenuItems-Array&lt;any&gt;	default-Array
///<br/><br/>
///Its sets target element to custom context menu item.
///<br/>target-ej.Kanban.Target|string	default-ej.Kanban.Target.All
///<br/><br/>
///Gets the display name to custom menu item.
///<br/>text-string	default-null
///<br/><br/>
///Gets the template to render custom context menu item.
///<br/>template-string	default-null
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified columns.
///<br/>columns-Array&lt;Columns&gt;	default-Array
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified columns header text.
///<br/>headerText-string	default-null
///<br/><br/>
///To customize the totalCount properties.
///<br/>totalCount-any	default-Object
///<br/><br/>
///To customize the totalCount text properties.
///<br/>text-string	default-null
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified columns key.
///<br/>key-string|number	default-null
///<br/><br/>
///To enable/disable allowDrop for specific column wise.
///<br/>allowDrop-boolean	default-true
///<br/><br/>
///To enable/disable allowDrag for specific column wise.
///<br/>allowDrag-boolean	default-true
///<br/><br/>
///To set column collapse or expand state
///<br/>isCollapsed-boolean	default-false
///<br/><br/>
///To customize the column level constraints with minimum ,maximum limit validation.
///<br/>constraints-any	default-Object
///<br/><br/>
///It is used to specify the type of constraints as column or swimlane.
///<br/>type-string	default-null
///<br/><br/>
///It is used to specify the minimum amount of card in particular column cell or swimlane cell can hold.
///<br/>min-number	default-null
///<br/><br/>
///It is used to specify the maximum amount of card in particular column cell or swimlane cell can hold.
///<br/>max-number	default-null
///<br/><br/>
///Gets or sets a value that indicates to add the template within the header element.
///<br/>headerTemplate-string	default-null
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified columns width.
///<br/>width-string|number	default-null
///<br/><br/>
///Gets or sets an object that indicates to set specific column visibility.
///<br/>visible-boolean	default-true
///<br/><br/>
///Gets or sets an object that indicates whether to show add new button.
///<br/>showAddButton-boolean	default-false
///<br/><br/>
///Gets or sets an object that indicates whether to Customize the card settings.
///<br/>cardSettings-CardSettings	default-Object
///<br/><br/>
///Gets or sets a value that indicates to add the template for card .
///<br/>template-string	default-null
///<br/><br/>
///To customize the card border color based on assigned task. Colors and corresponding values defined here will be mapped with colorField mapped data source column.
///<br/>colorMapping-any	default-Object
///<br/><br/>
///This specifies the Kanban card to drop into particular target element.
///<br/>externalDropTarget-string	default-
///<br/><br/>
///Gets or sets a value that indicates whether to add customToolbarItems within the toolbar to perform any action in the Kanban.
///<br/>customToolbarItems-Array&lt;CustomToolbarItems&gt;	default-[]
///<br/><br/>
///Gets the template to render customToolbarItems.
///<br/>template-string	default-null
///<br/><br/>
///Gets or sets a value that indicates to render the Kanban with custom theme.
///<br/>cssClass-string	default-
///<br/><br/>
///Gets or sets the data to render the Kanban with cards.
///<br/>dataSource-any	default-null
///<br/><br/>
///To perform kanban functionalities with touch interaction.
///<br/>enableTouch-boolean	default-true
///<br/><br/>
///Align content in the Kanban control align from right to left by setting the property as true.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///To show total count of cards in each column.
///<br/>enableTotalCount-boolean	default-false
///<br/><br/>
///Get or sets an object that indicates whether to customize the editing behavior of the Kanban.
///<br/>editSettings-EditSettings	default-Object
///<br/><br/>
///Gets or sets a value that indicates whether to enable the editing action in cards of Kanban.
///<br/>allowEditing-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to enable the adding action in cards behavior on Kanban.
///<br/>allowAdding-boolean	default-false
///<br/><br/>
///This specifies the id of the template which is require to be edited using the Dialog Box.
///<br/>dialogTemplate-string	default-null
///<br/><br/>
///Get or sets an object that indicates whether to customize the editMode of the Kanban.
///<br/>editMode-ej.Kanban.EditMode|string	default-ej.Kanban.EditMode.Dialog
///<br/><br/>
///Get or sets an object that indicates whether to customize the editing fields of Kanban card.
///<br/>editItems-Array&lt;any&gt;	default-Array
///<br/><br/>
///It is used to map editing field from the data source.
///<br/>field-string	default-null
///<br/><br/>
///It is used to set the particular editType in the card for editing.
///<br/>editType-ej.Kanban.EditingType|string	default-ej.Kanban.EditingType.String
///<br/><br/>
///Gets or sets a value that indicates to define constraints for saving data to the database.
///<br/>validationRules-any	default-Object
///<br/><br/>
///It is used to set the particular editparams in the card for editing.
///<br/>editParams-any	default-Object
///<br/><br/>
///It is used to specify defaultValue for the fields while adding new card.
///<br/>defaultValue-string|number	default-null
///<br/><br/>
///This specifies the id of the template which is require to be edited using the External edit form.
///<br/>externalFormTemplate-string	default-null
///<br/><br/>
///This specifies to set the position of an External edit form either in the right or bottom of the Kanban.
///<br/>formPosition-ej.Kanban.FormPosition|string	default-ej.Kanban.FormPosition.Bottom
///<br/><br/>
///To customize field mappings for card , editing title and control key parameters
///<br/>fields-Fields	default-Object
///<br/><br/>
///The primarykey field is mapped to data source field. And this will used for Drag and drop and editing mainly.
///<br/>primaryKey-string	default-null
///<br/><br/>
///To enable swimlane grouping based on the given key field from datasource mapping.
///<br/>swimlaneKey-string	default-null
///<br/><br/>
///Priority field has been mapped data source field to maintain cards priority.
///<br/>priority-string	default-null
///<br/><br/>
///Content field has been Mapped into card text.
///<br/>content-string	default-null
///<br/><br/>
///Tag field has been Mapped into card tag.
///<br/>tag-string	default-null
///<br/><br/>
///Title field has been Mapped to field in datasource for title content. If title field specified , card expand/collapse will be enabled with header and content section.
///<br/>title-string	default-null
///<br/><br/>
///To customize the card has been Mapped into card color field.
///<br/>color-string	default-null
///<br/><br/>
///ImageUrl field has been Mapped into card image.
///<br/>imageUrl-string	default-null
///<br/><br/>
///Get or sets an object that indicates the options to map the cards to the collapsible area.
///<br/>collapsibleCards-any	default-Object
///<br/><br/>
///It is used to specify the collapsible card's field mapping.
///<br/>field-string	default-null
///<br/><br/>
///It is used to specify the collapsible card's key mapping which is available in datasource value of field mapped in collapsibleCards.field.
///<br/>key-string	default-null
///<br/><br/>
///To map datasource field for column values mapping
///<br/>keyField-string	default-null
///<br/><br/>
///When set to true, adapts the Kanban layout to fit the screen size of devices on which it renders.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to set the minimum width of the responsive Kanban while isResponsive property is true.
///<br/>minWidth-number	default-0
///<br/><br/>
///To customize the filtering behavior based on queries given.
///<br/>filterSettings-Array&lt;FilterSettings&gt;	default-Array
///<br/><br/>
///Gets or sets an object of display name to filter queries.
///<br/>text-string	default-null
///<br/><br/>
///Gets or sets an object that Queries to perform filtering
///<br/>query-any	default-Object
///<br/><br/>
///Gets or sets an object of tooltip to filter buttons.
///<br/>description-string	default-null
///<br/><br/>
///ej Query to query database of Kanban.
///<br/>query-any	default-null
///<br/><br/>
///To change the key in keyboard interaction to Kanban control.
///<br/>keySettings-any	default-null
///<br/><br/>
///Gets or sets an object that indicates whether to customize the scrolling behavior of the Kanban.
///<br/>scrollSettings-ScrollSettings	default-Object
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified scroll height.
///<br/>height-string|number	default-0
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified scroll width.
///<br/>width-string|number	default-auto
///<br/><br/>
///To allow the Kanban to freeze particular swimlane at the time of scrolling , until scroll reaches next swimlane and it continues.
///<br/>allowFreezeSwimlane-boolean	default-false
///<br/><br/>
///To customize the searching behavior of the Kanban.
///<br/>searchSettings-SearchSettings	default-Object
///<br/><br/>
///To customize the fields the searching operation can be perform.
///<br/>fields-Array&lt;any&gt;	default-Array
///<br/><br/>
///To customize the searching string.
///<br/>key-string	default-
///<br/><br/>
///To customize the operator based on searching.
///<br/>operator-string	default-contains
///<br/><br/>
///To customize the ignore case based on searching.
///<br/>ignoreCase-boolean	default-true
///<br/><br/>
///To allow customize selection type. Accepting types are "single" and "multiple".
///<br/>selectionType-ej.Kanban.SelectionType|string	default-ej.Kanban.SelectionType.Single
///<br/><br/>
///Gets or sets an object that indicates to managing the collection of stacked header rows for the Kanban.
///<br/>stackedHeaderRows-Array&lt;StackedHeaderRows&gt;	default-Array
///<br/><br/>
///Gets or sets a value that indicates whether to add stacked header columns into the stacked header rows.
///<br/>stackedHeaderColumns-Array&lt;any&gt;	default-Array
///<br/><br/>
///Gets or sets a value that indicates the headerText for the particular stacked header column.
///<br/>headerText-string	default-null
///<br/><br/>
///Gets or sets a value that indicates the column for the particular stacked header column.
///<br/>column-string	default-null
///<br/><br/>
///The tooltip allows to display card details in a tooltip while hovering on it.
///<br/>tooltipSettings-TooltipSettings	default-
///<br/><br/>
///To enable or disable the tooltip display.
///<br/>enable-boolean	default-false
///<br/><br/>
///To customize the tooltip display based on your requirements.
///<br/>template-string	default-null
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified workflows.
///<br/>workflows-Array&lt;Workflows&gt;	default-Array
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified workflows key.
///<br/>key-string|number	default-null
///<br/><br/>
///Gets or sets an object that indicates to render the Kanban with specified workflows allowed Transitions.
///<br/>allowedTransitions-string	default-null
///<br/><br/>
///Gets or sets a value that indicates whether to customizing the user interface (UI) as locale-specific in order to display regional data i.e. in a language and culture specific to a particular country or region.
///<br/>locale-string	default-en-US
///<br/><br/>
///Gets or sets a value that indicates whether to render kanban columns using without data source.
///<br/>showColumnWhenEmpty-boolean	default-false
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
LinearGauge:function(){
 /// <signature>
 /// <summary>Constructor of ej.LinearGauge</summary>
 /// </signature>
}
});
ej.LinearGauge=(function(){
var original=ej.LinearGauge
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// destroy the linear gauge all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
exportImage:function(fileName, fileType){
/// <signature>
/// <summary>
/// To export Image
/// </summary>
/// <param name="fileName"	type="number">for the Image</param>
/// </signature>
/// <signature>
/// <summary>
/// To export Image
/// </summary>
/// <param name="fileType"	type="number">for the Image</param>
/// </signature>
},
getBarDistanceFromScale:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get Bar Distance From Scale in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Bar Distance From Scale in number
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getBarPointerValue:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get Bar Pointer Value in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Bar Pointer Value in number
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getBarWidth:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get Bar Width in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Bar Width in number
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getCustomLabelAngle:function(scaleIndex, customLabelIndex){
/// <signature>
/// <summary>
/// To get CustomLabel Angle in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get CustomLabel Angle in number
/// </summary>
/// <param name="customLabelIndex"	type="number">customLabelIndex value for the Gauge</param>
/// </signature>
},
getCustomLabelValue:function(scaleIndex, customLabelIndex){
/// <signature>
/// <summary>
/// To get CustomLabel Value in string
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get CustomLabel Value in string
/// </summary>
/// <param name="customLabelIndex"	type="number">customLabelIndex value for the Gauge</param>
/// </signature>
},
getLabelAngle:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get Label Angle in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Label Angle in number
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getLabelPlacement:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get LabelPlacement in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get LabelPlacement in number
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getLabelStyle:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get LabelStyle in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get LabelStyle in number
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getLabelXDistanceFromScale:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get Label XDistance From Scale in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Label XDistance From Scale in number
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getLabelYDistanceFromScale:function(scaleIndex, labelIndex){
/// <signature>
/// <summary>
/// To get PointerValue in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerValue in number
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getMajorIntervalValue:function(scaleIndex){
/// <signature>
/// <summary>
/// To get Major Interval Value in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getMarkerStyle:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get MarkerStyle in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get MarkerStyle in number
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getMaximumValue:function(scaleIndex){
/// <signature>
/// <summary>
/// To get Maximum Value in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getMinimumValue:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerValue in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerValue in number
/// </summary>
/// <param name="pointerIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getMinorIntervalValue:function(scaleIndex){
/// <signature>
/// <summary>
/// To get Minor Interval Value in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getPointerDistanceFromScale:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get Pointer Distance From Scale in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Pointer Distance From Scale in number
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerHeight:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerHeight in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerHeight in number
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerPlacement:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get Pointer Placement in String
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Pointer Placement in String
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerValue:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerValue in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerValue in number
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getPointerWidth:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get PointerWidth in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get PointerWidth in number
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
},
getRangeBorderWidth:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get Range Border Width in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Range Border Width in number
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeDistanceFromScale:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get Range Distance From Scale in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Range Distance From Scale in number
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeEndValue:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get Range End Value in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Range End Value in number
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeEndWidth:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get Range End Width in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Range End Width in number
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangePosition:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get Range Position in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Range Position in number
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeStartValue:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get Range Start Value in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Range Start Value in number
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getRangeStartWidth:function(scaleIndex, rangeIndex){
/// <signature>
/// <summary>
/// To get Range Start Width in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Range Start Width in number
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
},
getScaleBarLength:function(scaleIndex){
/// <signature>
/// <summary>
/// To get ScaleBarLength in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getScaleBarSize:function(scaleIndex, pointerIndex){
/// <signature>
/// <summary>
/// To get Scale Bar Size in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Scale Bar Size in number
/// </summary>
/// <param name="pointerIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getScaleBorderWidth:function(scaleIndex){
/// <signature>
/// <summary>
/// To get Scale Border Width in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getScaleDirection:function(scaleIndex){
/// <signature>
/// <summary>
/// To get Scale Direction in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getScaleLocation:function(scaleIndex){
/// <signature>
/// <summary>
/// To get Scale Location in object
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getScaleStyle:function(scaleIndex){
/// <signature>
/// <summary>
/// To get Scale Style in string
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
},
getTickAngle:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get Tick Angle in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Tick Angle in number
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getTickHeight:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get Tick Height in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Tick Height in number
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getTickPlacement:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get getTickPlacement in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get getTickPlacement in number
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getTickStyle:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get Tick Style in string
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Tick Style in string
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getTickWidth:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get Tick Width in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Tick Width in number
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getTickXDistanceFromScale:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get get Tick XDistance From Scale in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get get Tick XDistance From Scale in number
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
},
getTickYDistanceFromScale:function(scaleIndex, tickIndex){
/// <signature>
/// <summary>
/// To get Tick YDistance From Scale in number
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To get Tick YDistance From Scale in number
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
},
scales:function(){
/// <signature>
/// <summary>
/// Specifies the scales.
/// </summary>
},
setBarDistanceFromScale:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set setBarDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex,value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setBarDistanceFromScale
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setBarDistanceFromScale
/// </summary>
/// <param name="value"	type="number">Bar DistanceFromScale value for Gauge</param>
/// </signature>
},
setBarPointerValue:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set setBarPointerValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setBarPointerValue
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setBarPointerValue
/// </summary>
/// <param name="value"	type="number">Bar Pointer Value for Gauge</param>
/// </signature>
},
setBarWidth:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set setBarWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setBarWidth
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setBarWidth
/// </summary>
/// <param name="value"	type="number">Bar Width for Gauge</param>
/// </signature>
},
setCustomLabelAngle:function(scaleIndex, customLabelIndex, value){
/// <signature>
/// <summary>
/// To set setCustomLabelAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setCustomLabelAngle
/// </summary>
/// <param name="customLabelIndex"	type="number">customLabelIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setCustomLabelAngle
/// </summary>
/// <param name="value"	type="number">Custom Label Angle for Gauge</param>
/// </signature>
},
setCustomLabelValue:function(scaleIndex, customLabelIndex, value){
/// <signature>
/// <summary>
/// To set setCustomLabelValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setCustomLabelValue
/// </summary>
/// <param name="customLabelIndex"	type="number">customLabelIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setCustomLabelValue
/// </summary>
/// <param name="value"	type="number">CustomLabel value for Gauge</param>
/// </signature>
},
setLabelAngle:function(scaleIndex, labelIndex, angle){
/// <signature>
/// <summary>
/// To set setLabelAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelAngle
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelAngle
/// </summary>
/// <param name="angle"	type="number">Label Angle for Gauge</param>
/// </signature>
},
setLabelPlacement:function(scaleIndex, labelIndex, value){
/// <signature>
/// <summary>
/// To set setLabelPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelPlacement
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelPlacement
/// </summary>
/// <param name="value"	type="number">Label Placement for Gauge</param>
/// </signature>
},
setLabelStyle:function(scaleIndex, labelIndex, value){
/// <signature>
/// <summary>
/// To set setLabelStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelStyle
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelStyle
/// </summary>
/// <param name="value"	type="string">Label Style for Gauge</param>
/// </signature>
},
setLabelXDistanceFromScale:function(scaleIndex, labelIndex, value){
/// <signature>
/// <summary>
/// To set setLabelXDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelXDistanceFromScale
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelXDistanceFromScale
/// </summary>
/// <param name="value"	type="number">Label XDistance From Scale for Gauge</param>
/// </signature>
},
setLabelYDistanceFromScale:function(scaleIndex, labelIndex, value){
/// <signature>
/// <summary>
/// To set setLabelYDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelYDistanceFromScale
/// </summary>
/// <param name="labelIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setLabelYDistanceFromScale
/// </summary>
/// <param name="value"	type="number">Label YDistance From Scale for Gauge</param>
/// </signature>
},
setMajorIntervalValue:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setMajorIntervalValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setMajorIntervalValue
/// </summary>
/// <param name="value"	type="number">Major Interval Value for Gauge</param>
/// </signature>
},
setMarkerStyle:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set setMarkerStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setMarkerStyle
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setMarkerStyle
/// </summary>
/// <param name="value"	type="string">marker Style for Gauge</param>
/// </signature>
},
setMaximumValue:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setMaximumValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setMaximumValue
/// </summary>
/// <param name="value"	type="number">MaximumValue for Gauge</param>
/// </signature>
},
setMinimumValue:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setMinimumValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setMinimumValue
/// </summary>
/// <param name="value"	type="number">MinimumValue for Gauge</param>
/// </signature>
},
setMinorIntervalValue:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setMinorIntervalValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setMinorIntervalValue
/// </summary>
/// <param name="value"	type="number">Minor Interval Value for Gauge</param>
/// </signature>
},
setPointerDistanceFromScale:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set setPointerDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setPointerDistanceFromScale
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setPointerDistanceFromScale
/// </summary>
/// <param name="value"	type="number">for Gauge</param>
/// </signature>
},
setPointerHeight:function(scaleIndex, pointerIndex, height){
/// <signature>
/// <summary>
/// To set PointerHeight
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerHeight
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerHeight
/// </summary>
/// <param name="height"	type="number">for Gauge</param>
/// </signature>
},
setPointerPlacement:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set setPointerPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setPointerPlacement
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setPointerPlacement
/// </summary>
/// <param name="value"	type="number">pointer placement for Gauge</param>
/// </signature>
},
setPointerValue:function(scaleIndex, pointerIndex, value){
/// <signature>
/// <summary>
/// To set PointerValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerValue
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerValue
/// </summary>
/// <param name="value"	type="number">Pointer value for Gauge</param>
/// </signature>
},
setPointerWidth:function(scaleIndex, pointerIndex, width){
/// <signature>
/// <summary>
/// To set PointerWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerWidth
/// </summary>
/// <param name="pointerIndex"	type="number">pointerIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set PointerWidth
/// </summary>
/// <param name="width"	type="number">Pointer width for Gauge</param>
/// </signature>
},
setRangeBorderWidth:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set setRangeBorderWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeBorderWidth
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeBorderWidth
/// </summary>
/// <param name="value"	type="number">Range Border Width for Gauge</param>
/// </signature>
},
setRangeDistanceFromScale:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set setRangeDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeDistanceFromScale
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeDistanceFromScale
/// </summary>
/// <param name="value"	type="number">Range Distance FromScale for Gauge</param>
/// </signature>
},
setRangeEndValue:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set setRangeEndValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeEndValue
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeEndValue
/// </summary>
/// <param name="value"	type="number">Range end value for Gauge</param>
/// </signature>
},
setRangeEndWidth:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set setRangeEndWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeEndWidth
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeEndWidth
/// </summary>
/// <param name="value"	type="number">Range End Width for Gauge</param>
/// </signature>
},
setRangePosition:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set setRangePosition
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangePosition
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangePosition
/// </summary>
/// <param name="value"	type="number">Range Position for Gauge</param>
/// </signature>
},
setRangeStartValue:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set setRangeStartValue
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeStartValue
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeStartValue
/// </summary>
/// <param name="value"	type="number">range start value for Gauge</param>
/// </signature>
},
setRangeStartWidth:function(scaleIndex, rangeIndex, value){
/// <signature>
/// <summary>
/// To set setRangeStartWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeStartWidth
/// </summary>
/// <param name="rangeIndex"	type="number">rangeIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setRangeStartWidth
/// </summary>
/// <param name="value"	type="number">Range Start Width for Gauge</param>
/// </signature>
},
setScaleBarLength:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setScaleBarLength
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setScaleBarLength
/// </summary>
/// <param name="value"	type="number">Scale Bar Length for Gauge</param>
/// </signature>
},
setScaleBarSize:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setScaleBarSize
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setScaleBarSize
/// </summary>
/// <param name="value"	type="number">ScaleBarSize for Gauge</param>
/// </signature>
},
setScaleBorderWidth:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setScaleBorderWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setScaleBorderWidth
/// </summary>
/// <param name="value"	type="number">Scale Border Width for Gauge</param>
/// </signature>
},
setScaleDirection:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setScaleDirection
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setScaleDirection
/// </summary>
/// <param name="value"	type="number">Scale Direction for Gauge</param>
/// </signature>
},
setScaleLocation:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setScaleLocation
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setScaleLocation
/// </summary>
/// <param name="value"	type="any">Scale position for Gauge</param>
/// </signature>
},
setScaleStyle:function(scaleIndex, value){
/// <signature>
/// <summary>
/// To set setScaleStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setScaleStyle
/// </summary>
/// <param name="value"	type="number">for Gauge</param>
/// </signature>
},
setTickAngle:function(scaleIndex, tickIndex, angle){
/// <signature>
/// <summary>
/// To set setTickAngle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickAngle
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickAngle
/// </summary>
/// <param name="angle"	type="number">Tick Angle for Gauge</param>
/// </signature>
},
setTickHeight:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set setTickHeight
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickHeight
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickHeight
/// </summary>
/// <param name="value"	type="number">Tick Height for Gauge</param>
/// </signature>
},
setTickPlacement:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set setTickPlacement
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickPlacement
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickPlacement
/// </summary>
/// <param name="value"	type="number">Tick Placement for Gauge</param>
/// </signature>
},
setTickStyle:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set setTickStyle
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickStyle
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickStyle
/// </summary>
/// <param name="value"	type="string">Tick Style for Gauge</param>
/// </signature>
},
setTickWidth:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set setTickWidth
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickWidth
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickWidth
/// </summary>
/// <param name="value"	type="number">Tick Width for Gauge</param>
/// </signature>
},
setTickXDistanceFromScale:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set setTickXDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickXDistanceFromScale
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickXDistanceFromScale
/// </summary>
/// <param name="value"	type="number">Tick XDistance From Scale for Gauge</param>
/// </signature>
},
setTickYDistanceFromScale:function(scaleIndex, tickIndex, value){
/// <signature>
/// <summary>
/// To set setTickYDistanceFromScale
/// </summary>
/// <param name="scaleIndex"	type="number">scaleIndex value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickYDistanceFromScale
/// </summary>
/// <param name="tickIndex"	type="number">value for the Gauge</param>
/// </signature>
/// <signature>
/// <summary>
/// To set setTickYDistanceFromScale
/// </summary>
/// <param name="value"	type="number">Tick YDistance From Scale for Gauge</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejLinearGauge=function(){
this.data("ejLinearGauge",new	ej.LinearGauge());
return this;
};
intellisense.annotate(jQuery.fn,{
ejLinearGauge :function (options) {
/// <signature>
/// <summary><br/>
///The Linear gauge can be easily configured to the DOM element, such as div. you can create a linear gauge with a highly customizable look and feel.<br/><br/>
///Specifies the animationSpeed
///<br/>animationSpeed-number	default-500
///<br/><br/>
///Specifies the backgroundColor for Linear gauge.
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specifies the borderColor for Linear gauge.
///<br/>borderColor-string	default-null
///<br/><br/>
///Specifies the animate state
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Specifies the animate state for marker pointer
///<br/>enableMarkerPointerAnimation-boolean	default-true
///<br/><br/>
///This provides options for customizing export settings
///<br/>exportSettings-ExportSettings	default-
///<br/><br/>
///Specifies the downloading filename
///<br/>filename-string	default-LinearGauge
///<br/><br/>
///Specifies the format of the file to export
///<br/>type-ej.datavisualization.LinearGauge.ExportingType|string	default-png
///<br/><br/>
///Specifies the name of the action URL
///<br/>action-string	default-
///<br/><br/>
///Specifies the mode of exporting
///<br/>mode-ej.datavisualization.LinearGauge.ExportingMode|string	default-client
///<br/><br/>
///Specifies the can resize state.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Used to Convert the date object to  string while using the  locale settings
///<br/>enableGroupSeparator-boolean	default-false
///<br/><br/>
///Responsiveness of the linear gauge is controlled
///<br/>enableResize-boolean	default-false
///<br/><br/>
///Specify frame of linear gauge
///<br/>frame-Frame	default-null
///<br/><br/>
///Specifies the frame background image URL of linear gauge
///<br/>backgroundImageUrl-string	default-null
///<br/><br/>
///Specifies the frame InnerWidth
///<br/>innerWidth-number	default-8
///<br/><br/>
///Specifies the frame OuterWidth
///<br/>outerWidth-number	default-12
///<br/><br/>
///Specifies the height of Linear gauge.
///<br/>height-number	default-400
///<br/><br/>
///Specifies the labelColor for Linear gauge.
///<br/>labelColor-string	default-null
///<br/><br/>
///Set the  localization culture  for the Linear gauge
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the maximum value of Linear gauge.
///<br/>maximum-number	default-100
///<br/><br/>
///Specifies the minimum value of Linear gauge.
///<br/>minimum-number	default-0
///<br/><br/>
///Specifies the orientation for Linear gauge.
///<br/>orientation-string	default-Vertical
///<br/><br/>
///Specify labelPosition value of Linear gauge See 
///<br/>outerCustomLabelPosition-ej.datavisualization.LinearGauge.OuterCustomLabelPosition|string	default-bottom
///<br/><br/>
///Specifies the pointerGradient1 for Linear gauge.
///<br/>pointerGradient1-any	default-null
///<br/><br/>
///Specifies the pointerGradient2 for Linear gauge.
///<br/>pointerGradient2-any	default-null
///<br/><br/>
///Specifies the read only state.
///<br/>readOnly-boolean	default-true
///<br/><br/>
///Specifies the scales
///<br/>scales-Array&lt;Scales&gt;	default-null
///<br/><br/>
///Specifies the backgroundColor of the Scale.
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specifies the scaleBar Gradient of bar pointer
///<br/>barPointers-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the backgroundColor of bar pointer
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specifies the border of bar pointer
///<br/>border-any	default-null
///<br/><br/>
///Specifies the border Color of bar pointer
///<br/>color-string	default-null
///<br/><br/>
///Specifies the border Width of bar pointer
///<br/>width-number	default-1.5
///<br/><br/>
///Specifies the distanceFromScale of bar pointer
///<br/>distanceFromScale-number	default-0
///<br/><br/>
///Specifies the scaleBar Gradient of bar pointer
///<br/>gradients-any	default-null
///<br/><br/>
///Specifies the opacity of bar pointer
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the value of bar pointer
///<br/>value-number	default-null
///<br/><br/>
///Specifies the pointer Width of bar pointer
///<br/>width-number	default-width=30
///<br/><br/>
///Specifies the border of the Scale.
///<br/>border-any	default-null
///<br/><br/>
///Specifies the border color of the Scale.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the border width of the Scale.
///<br/>width-number	default-1.5
///<br/><br/>
///Specifies the customLabel
///<br/>customLabels-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the label Color in customLabels
///<br/>color-number	default-null
///<br/><br/>
///Specifies the font in customLabels
///<br/>font-any	default-null
///<br/><br/>
///Specifies the fontFamily in customLabels
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Specifies the fontStyle in customLabels. See 
///<br/>fontStyle-ej.datavisualization.LinearGauge.FontStyle|string	default-Bold
///<br/><br/>
///Specifies the font size in customLabels
///<br/>size-string	default-11px
///<br/><br/>
///Specifies the opacity in customLabels
///<br/>opacity-string	default-0
///<br/><br/>
///Specifies the position in customLabels
///<br/>position-any	default-null
///<br/><br/>
///Specifies the position x in customLabels
///<br/>x-number	default-0
///<br/><br/>
///Specifies the y in customLabels
///<br/>y-number	default-0
///<br/><br/>
///Specifies the positionType in customLabels.See CustomLabelPositionType
///<br/>positionType-any	default-null
///<br/><br/>
///Specifies the textAngle in customLabels
///<br/>textAngle-number	default-0
///<br/><br/>
///Specifies the label Value in customLabels
///<br/>value-string	default-
///<br/><br/>
///Specifies the scale Direction of the Scale. See 
///<br/>direction-ej.datavisualization.LinearGauge.Direction|string	default-CounterClockwise
///<br/><br/>
///Specifies the indicator
///<br/>indicators-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the backgroundColor in bar indicators
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specifies the border in bar indicators
///<br/>border-number	default-null
///<br/><br/>
///Specifies the border Color in bar indicators
///<br/>color-string	default-null
///<br/><br/>
///Specifies the border Width in bar indicators
///<br/>width-number	default-1.5
///<br/><br/>
///Specifies the font of bar indicators
///<br/>font-any	default-null
///<br/><br/>
///Specifies the fontFamily of font in bar indicators
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Specifies the fontStyle of font in bar indicators. See FontStyle
///<br/>fontStyle-ej.datavisualization.LinearGauge.FontStyle|string	default-ej.datavisualization.LinearGauge.FontStyle.Bold
///<br/><br/>
///Specifies the size of font in bar indicators
///<br/>size-string	default-11px
///<br/><br/>
///Specifies the indicator Height of bar indicators
///<br/>height-number	default-30
///<br/><br/>
///Specifies the opacity in bar indicators
///<br/>opacity-number	default-null
///<br/><br/>
///Specifies the position in bar indicators
///<br/>position-any	default-null
///<br/><br/>
///Specifies the x position in bar indicators
///<br/>x-number	default-0
///<br/><br/>
///Specifies the y position in bar indicators
///<br/>y-number	default-0
///<br/><br/>
///Specifies the state ranges in bar indicators
///<br/>stateRanges-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the backgroundColor in bar indicators state ranges
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specifies the borderColor in bar indicators state ranges
///<br/>borderColor-string	default-null
///<br/><br/>
///Specifies the endValue in bar indicators state ranges
///<br/>endValue-number	default-60
///<br/><br/>
///Specifies the startValue in bar indicators state ranges
///<br/>startValue-number	default-50
///<br/><br/>
///Specifies the text in bar indicators state ranges
///<br/>text-string	default-
///<br/><br/>
///Specifies the textColor in bar indicators state ranges
///<br/>textColor-string	default-null
///<br/><br/>
///Specifies the textLocation in bar indicators
///<br/>textLocation-any	default-null
///<br/><br/>
///Specifies the textLocation position in bar indicators
///<br/>x-number	default-0
///<br/><br/>
///Specifies the Y position in bar indicators
///<br/>y-number	default-0
///<br/><br/>
///Specifies the indicator Style of font in bar indicators
///<br/>type-ej.datavisualization.LinearGauge.IndicatorTypes|string	default-ej.datavisualization.LinearGauge.IndicatorType.Rectangle
///<br/><br/>
///Specifies the indicator Width in bar indicators
///<br/>width-number	default-30
///<br/><br/>
///Specifies the labels.
///<br/>labels-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the angle of labels.
///<br/>angle-number	default-0
///<br/><br/>
///Specifies the DistanceFromScale of labels.
///<br/>distanceFromScale-any	default-null
///<br/><br/>
///Specifies the xDistanceFromScale of labels.
///<br/>x-number	default--10
///<br/><br/>
///Specifies the yDistanceFromScale of labels.
///<br/>y-number	default-0
///<br/><br/>
///Specifies the font of labels.
///<br/>font-any	default-null
///<br/><br/>
///Specifies the fontFamily of font.
///<br/>fontFamily-string	default-Arial
///<br/><br/>
///Specifies the fontStyle of font.See FontStyle
///<br/>fontStyle-ej.datavisualization.LinearGauge.FontStyle|string	default-ej.datavisualization.LinearGauge.FontStyle.Bold
///<br/><br/>
///Specifies the size of font.
///<br/>size-string	default-11px
///<br/><br/>
///need to includeFirstValue.
///<br/>includeFirstValue-boolean	default-true
///<br/><br/>
///Specifies the opacity of label.
///<br/>opacity-number	default-0
///<br/><br/>
///Specifies the label Placement of label. See 
///<br/>placement-ej.datavisualization.LinearGauge.PointerPlacement|string	default-Near
///<br/><br/>
///Specifies the textColor of font.
///<br/>textColor-string	default-null
///<br/><br/>
///Specifies the label Style of label. See 
///<br/>type-ej.datavisualization.LinearGauge.ScaleType|string	default-ej.datavisualization.LinearGauge.LabelType.Major
///<br/><br/>
///Specifies the unitText of label.
///<br/>unitText-string	default-
///<br/><br/>
///Specifies the unitText Position of label.See 
///<br/>unitTextPlacement-ej.datavisualization.LinearGauge.UnitTextPlacement|string	default-Back
///<br/><br/>
///Specifies the scaleBar Length.
///<br/>length-number	default-290
///<br/><br/>
///Specifies the majorIntervalValue of the Scale.
///<br/>majorIntervalValue-number	default-10
///<br/><br/>
///Specifies the markerPointers
///<br/>markerPointers-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the backgroundColor of marker pointer
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specifies the border of marker pointer
///<br/>border-any	default-null
///<br/><br/>
///Specifies the border color of marker pointer
///<br/>color-string	default-null
///<br/><br/>
///Specifies the border of marker pointer
///<br/>width-number	default-number
///<br/><br/>
///Specifies the distanceFromScale of marker pointer
///<br/>distanceFromScale-number	default-0
///<br/><br/>
///Specifies the pointer Gradient of marker pointer
///<br/>gradients-any	default-null
///<br/><br/>
///Specifies the pointer Length of marker pointer
///<br/>length-number	default-30
///<br/><br/>
///Specifies the opacity of marker pointer
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the pointer Placement of marker pointer See PointerPlacement
///<br/>placement-ej.datavisualization.LinearGauge.PointerPlacement|string	default-Far
///<br/><br/>
///Specifies the marker Style of marker pointerSee 
///<br/>type-ej.datavisualization.LinearGauge.MarkerType|string	default-Triangle
///<br/><br/>
///Specifies the value of marker pointer
///<br/>value-number	default-null
///<br/><br/>
///Specifies the pointer Width of marker pointer
///<br/>width-number	default-30
///<br/><br/>
///Specifies the maximum of the Scale.
///<br/>maximum-number	default-null
///<br/><br/>
///Specifies the minimum of the Scale.
///<br/>minimum-number	default-null
///<br/><br/>
///Specifies the minorIntervalValue of the Scale.
///<br/>minorIntervalValue-number	default-2
///<br/><br/>
///Specifies the opacity of the Scale.
///<br/>opacity-number	default-NaN
///<br/><br/>
///Specifies the position
///<br/>position-any	default-null
///<br/><br/>
///Specifies the Horizontal position
///<br/>x-number	default-50
///<br/><br/>
///Specifies the vertical position
///<br/>y-number	default-50
///<br/><br/>
///Specifies the ranges in the tick.
///<br/>ranges-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the backgroundColor in the ranges.
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specifies the border in the ranges.
///<br/>border-any	default-null
///<br/><br/>
///Specifies the border color in the ranges.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the border width in the ranges.
///<br/>width-number	default-1.5
///<br/><br/>
///Specifies the distanceFromScale in the ranges.
///<br/>distanceFromScale-number	default-0
///<br/><br/>
///Specifies the endValue in the ranges.
///<br/>endValue-number	default-60
///<br/><br/>
///Specifies the endWidth in the ranges.
///<br/>endWidth-number	default-10
///<br/><br/>
///Specifies the range Gradient in the ranges.
///<br/>gradients-any	default-null
///<br/><br/>
///Specifies the opacity in the ranges.
///<br/>opacity-number	default-null
///<br/><br/>
///Specifies the range Position in the ranges. See RangePlacement
///<br/>placement-ej.datavisualization.LinearGauge.PointerPlacement|string	default-Center
///<br/><br/>
///Specifies the startValue in the ranges.
///<br/>startValue-number	default-20
///<br/><br/>
///Specifies the startWidth in the ranges.
///<br/>startWidth-number	default-10
///<br/><br/>
///Specifies the shadowOffset.
///<br/>shadowOffset-number	default-0
///<br/><br/>
///Specifies the showBarPointers state.
///<br/>showBarPointers-boolean	default-true
///<br/><br/>
///Specifies the showCustomLabels state.
///<br/>showCustomLabels-boolean	default-false
///<br/><br/>
///Specifies the showIndicators state.
///<br/>showIndicators-boolean	default-false
///<br/><br/>
///Specifies the showLabels state.
///<br/>showLabels-boolean	default-true
///<br/><br/>
///Specifies the showMarkerPointers state.
///<br/>showMarkerPointers-boolean	default-true
///<br/><br/>
///Specifies the showRanges state.
///<br/>showRanges-boolean	default-false
///<br/><br/>
///Specifies the showTicks state.
///<br/>showTicks-boolean	default-true
///<br/><br/>
///Specifies the ticks in the scale.
///<br/>ticks-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the angle in the tick.
///<br/>angle-number	default-0
///<br/><br/>
///Specifies the tick Color in the tick.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the DistanceFromScale in the tick.
///<br/>distanceFromScale-any	default-null
///<br/><br/>
///Specifies the xDistanceFromScale in the tick.
///<br/>x-number	default-0
///<br/><br/>
///Specifies the yDistanceFromScale in the tick.
///<br/>y-number	default-0
///<br/><br/>
///Specifies the tick Height in the tick.
///<br/>height-number	default-10
///<br/><br/>
///Specifies the opacity in the tick.
///<br/>opacity-number	default-0
///<br/><br/>
///Specifies the tick Placement in the tick. See TickPlacement
///<br/>placement-ej.datavisualization.LinearGauge.PointerPlacement|string	default-Near
///<br/><br/>
///Specifies the tick Style in the tick. See 
///<br/>type-ej.datavisualization.LinearGauge.TicksType|string	default-MajorInterval
///<br/><br/>
///Specifies the tick Width in the tick.
///<br/>width-number	default-3
///<br/><br/>
///Specifies the scaleBar type .See 
///<br/>type-ej.datavisualization.LinearGauge.ScaleType|string	default-Rectangle
///<br/><br/>
///Specifies the scaleBar width.
///<br/>width-number	default-30
///<br/><br/>
///Specifies the theme for Linear gauge. See LinearGauge.Themes
///<br/>theme-ej.datavisualization.LinearGauge.Themes|string	default-flatlight
///<br/><br/>
///Specifies the tick Color for Linear gauge.
///<br/>tickColor-string	default-null
///<br/><br/>
///Specify tooltip options of linear gauge
///<br/>tooltip-Tooltip	default-false
///<br/><br/>
///Specify showCustomLabelTooltip value of linear gauge
///<br/>showCustomLabelTooltip-boolean	default-false
///<br/><br/>
///Specify showLabelTooltip value of linear gauge
///<br/>showLabelTooltip-boolean	default-false
///<br/><br/>
///Specify templateID value of linear gauge
///<br/>templateID-string	default-false
///<br/><br/>
///Specifies the value of the Gauge.
///<br/>value-number	default-0
///<br/><br/>
///Specifies the width of Linear gauge.
///<br/>width-number	default-150
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
ListBox:function(){
 /// <signature>
 /// <summary>Constructor of ej.ListBox</summary>
 /// </signature>
}
});
ej.ListBox=(function(){
var original=ej.ListBox
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addItem:function(listItem, index){
/// <signature>
/// <summary>
/// Adds a given list items in the ListBox widget at a specified index. It accepts two parameters.
/// </summary>
/// <param name="listItem"	type="any|string">This can be a list item object (for JSON binding) or a string (for UL and LI rendering). Also we can the specify this as an array of list item object or an array of strings to add multiple items.</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds a given list items in the ListBox widget at a specified index. It accepts two parameters.
/// </summary>
/// <param name="index"	type="number">The index value to add the given items at the specified index. If index is not specified, the given items will be added at the end of the list.</param>
/// </signature>
},
checkAll:function(){
/// <signature>
/// <summary>
/// Checks all the list items in the ListBox widget. It is dependent on showCheckbox property.
/// </summary>
},
checkItemByIndex:function(index){
/// <signature>
/// <summary>
/// Checks a list item by using its index. It is dependent on showCheckbox property.
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be checked. If index is not specified, the given items will be added at the end of the list.</param>
/// </signature>
},
checkItemsByIndices:function(indices){
/// <signature>
/// <summary>
/// Checks multiple list items by using its index values. It is dependent on showCheckbox property.
/// </summary>
/// <param name="indices"	type="number[]">Index/Indices of the listbox items to be checked. If index is not specified, the given items will be added at the end of the list.</param>
/// </signature>
},
disable:function(){
/// <signature>
/// <summary>
/// Disables the ListBox widget.
/// </summary>
},
disableItem:function(text){
/// <signature>
/// <summary>
/// Disables a list item by passing the item text as parameter.
/// </summary>
/// <param name="text"	type="string">Text of the listbox item to be disabled.</param>
/// </signature>
},
disableItemByIndex:function(index){
/// <signature>
/// <summary>
/// Disables a list Item using its index value.
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be disabled.</param>
/// </signature>
},
disableItemsByIndices:function(Indices){
/// <signature>
/// <summary>
/// Disables set of list Items using its index values.
/// </summary>
/// <param name="Indices"	type="number[]|string">Indices of the listbox items to be disabled.</param>
/// </signature>
},
enable:function(){
/// <signature>
/// <summary>
/// Enables the ListBox widget when it is disabled.
/// </summary>
},
enableItem:function(text){
/// <signature>
/// <summary>
/// Enables a list Item using its item text value.
/// </summary>
/// <param name="text"	type="string">Text of the listbox item to be enabled.</param>
/// </signature>
},
enableItemByIndex:function(index){
/// <signature>
/// <summary>
/// Enables a list item using its index value.
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be enabled.</param>
/// </signature>
},
enableItemsByIndices:function(indices){
/// <signature>
/// <summary>
/// Enables a set of list Items using its index values.
/// </summary>
/// <param name="indices"	type="number[]|string">Indices of the listbox items to be enabled.</param>
/// </signature>
},
getCheckedItems:function(){
/// <signature>
/// <summary>
/// Returns the list of checked items in the ListBox widget. It is dependent on showCheckbox property.
/// </summary>
},
getSelectedItems:function(){
/// <signature>
/// <summary>
/// Returns the list of selected items in the ListBox widget.
/// </summary>
},
getIndexByText:function(text){
/// <signature>
/// <summary>
/// Returns an itemâ€™s index based on the given text.
/// </summary>
/// <param name="text"	type="string">The list item text (label)</param>
/// </signature>
},
getIndexByValue:function(indices){
/// <signature>
/// <summary>
/// Returns an itemâ€™s index based on the value given.
/// </summary>
/// <param name="indices"	type="string">The list itemâ€™s value</param>
/// </signature>
},
getTextByIndex:function(){
/// <signature>
/// <summary>
/// Returns an itemâ€™s text (label) based on the index given.
/// </summary>
},
getItemByIndex:function(){
/// <signature>
/// <summary>
/// Returns a list itemâ€™s object using its index.
/// </summary>
},
getItemByText:function(text){
/// <signature>
/// <summary>
/// Returns a list itemâ€™s object based on the text given.
/// </summary>
/// <param name="text"	type="string">The list item text.</param>
/// </signature>
},
mergeData:function(data){
/// <signature>
/// <summary>
/// Merges the given data with the existing data items in the listbox.
/// </summary>
/// <param name="data"	type="any[]">Data to merge in listbox.</param>
/// </signature>
},
moveDown:function(){
/// <signature>
/// <summary>
/// Selects the next item based on the current selection.
/// </summary>
},
moveUp:function(){
/// <signature>
/// <summary>
/// Selects the previous item based on the current selection.
/// </summary>
},
refresh:function(refreshData){
/// <signature>
/// <summary>
/// Refreshes the ListBox widget.
/// </summary>
/// <param name="refreshData"	type="boolean">Refreshes both the datasource and the dimensions of the ListBox widget when the parameter is passed as true, otherwise only the ListBox dimensions will be refreshed.</param>
/// </signature>
},
removeAll:function(){
/// <signature>
/// <summary>
/// Removes all the list items from listbox.
/// </summary>
},
removeSelectedItems:function(){
/// <signature>
/// <summary>
/// Removes the selected list items from the listbox.
/// </summary>
},
removeItemByText:function(text){
/// <signature>
/// <summary>
/// Removes a list item by using its text.
/// </summary>
/// <param name="text"	type="string">Text of the listbox item to be removed. </param>
/// </signature>
},
removeItemByIndex:function(index){
/// <signature>
/// <summary>
/// Removes a list item by using its index value.
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be removed.</param>
/// </signature>
},
selectAll:function(){
/// <signature>
/// <summary>
/// 
/// </summary>
},
selectItemByText:function(text){
/// <signature>
/// <summary>
/// Selects the list item using its text value.
/// </summary>
/// <param name="text"	type="string">Text of the listbox item to be selected.</param>
/// </signature>
},
selectItemByValue:function(value){
/// <signature>
/// <summary>
/// Selects list item using its value property.
/// </summary>
/// <param name="value"	type="string">Value of the listbox item to be selected.</param>
/// </signature>
},
selectItemByIndex:function(index){
/// <signature>
/// <summary>
/// Selects list item using its index value.
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be selected.</param>
/// </signature>
},
selectItemsByIndices:function(Indices){
/// <signature>
/// <summary>
/// Selects a set of list items through its index values.
/// </summary>
/// <param name="Indices"	type="number|number[]">Index/Indices of the listbox item to be selected.</param>
/// </signature>
},
uncheckAll:function(){
/// <signature>
/// <summary>
/// Unchecks all the checked list items in the ListBox widget. To use this method showCheckbox property to be set as true.
/// </summary>
},
uncheckItemByIndex:function(index){
/// <signature>
/// <summary>
/// Unchecks a checked list item using its index value. To use this method showCheckbox property to be set as true.
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be unchecked.</param>
/// </signature>
},
uncheckItemsByIndices:function(indices){
/// <signature>
/// <summary>
/// Unchecks the set of checked list items using its index values. To use this method showCheckbox property must be set to true.
/// </summary>
/// <param name="indices"	type="number[]|string">Indices of the listbox item to be unchecked.</param>
/// </signature>
},
unselectAll:function(){
/// <signature>
/// <summary>
/// 
/// </summary>
},
unselectItemByIndex:function(index){
/// <signature>
/// <summary>
/// Unselects a selected list item using its index value
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be unselected.</param>
/// </signature>
},
unselectItemByText:function(text){
/// <signature>
/// <summary>
/// Unselects a selected list item using its text value.
/// </summary>
/// <param name="text"	type="string">Text of the listbox item to be unselected.</param>
/// </signature>
},
unselectItemByValue:function(value){
/// <signature>
/// <summary>
/// Unselects a selected list item using its value.
/// </summary>
/// <param name="value"	type="string">Value of the listbox item to be unselected.</param>
/// </signature>
},
unselectItemsByIndices:function(indices){
/// <signature>
/// <summary>
/// Unselects a set of list items using its index values.
/// </summary>
/// <param name="indices"	type="number[]|string">Indices of the listbox item to be unselected.</param>
/// </signature>
},
hideCheckedItems:function(){
/// <signature>
/// <summary>
/// Hides all the checked items in the listbox.
/// </summary>
},
showItemByIndices:function(indices){
/// <signature>
/// <summary>
/// Shows a set of hidden list Items using its index values.
/// </summary>
/// <param name="indices"	type="number[]|string">Indices of the listbox items to be shown.</param>
/// </signature>
},
hideItemsByIndices:function(indices){
/// <signature>
/// <summary>
/// Hides a set of list Items using its index values.
/// </summary>
/// <param name="indices"	type="number[]|string">Indices of the listbox items to be hidden.</param>
/// </signature>
},
showItemsByValues:function(values){
/// <signature>
/// <summary>
/// Shows the hidden list items using its values.
/// </summary>
/// <param name="values"	type="any[]">Values of the listbox items to be shown.</param>
/// </signature>
},
hideItemsByValues:function(values){
/// <signature>
/// <summary>
/// Hides the list item using its values.
/// </summary>
/// <param name="values"	type="any[]">Values of the listbox items to be hidden.</param>
/// </signature>
},
showItemByValue:function(value){
/// <signature>
/// <summary>
/// Shows a hidden list item using its value.
/// </summary>
/// <param name="value"	type="string">Value of the listbox item to be shown.</param>
/// </signature>
},
hideItemByValue:function(value){
/// <signature>
/// <summary>
/// Hide a list item using its value.
/// </summary>
/// <param name="value"	type="string">Value of the listbox item to be hidden.</param>
/// </signature>
},
showItemByIndex:function(index){
/// <signature>
/// <summary>
/// Shows a hidden list item using its index value.
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be shown.</param>
/// </signature>
},
hideItemByIndex:function(index){
/// <signature>
/// <summary>
/// Hides a list item using its index value.
/// </summary>
/// <param name="index"	type="number">Index of the listbox item to be hidden.</param>
/// </signature>
},
show:function(){
/// <signature>
/// <summary>
/// 
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// Hides the listbox.
/// </summary>
},
hideAllItems:function(){
/// <signature>
/// <summary>
/// Hides all the listbox items in the listbox.
/// </summary>
},
showAllItems:function(){
/// <signature>
/// <summary>
/// Shows all the listbox items in the listbox.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejListBox=function(){
this.data("ejListBox",new	ej.ListBox());
return this;
};
intellisense.annotate(jQuery.fn,{
ejListBox :function (options) {
/// <signature>
/// <summary><br/>
///The ListBox control provides a list of options for users to select from. It is capable of including other HTML elements such as images, textboxes, check box, and radio buttons and so on. It also supports data binding, template options, multi-select options, etc.<br/><br/>
///Enables/disables the dragging behavior of the items in ListBox widget.
///<br/>allowDrag-boolean	default-false
///<br/><br/>
///Accepts the items which are dropped in to it, when it is set to true.
///<br/>allowDrop-boolean	default-false
///<br/><br/>
///Enables or disables multiple selection.
///<br/>allowMultiSelection-boolean	default-false
///<br/><br/>
///Loads the list data on demand via scrolling behavior to improve the applicationâ€™s performance. There are two ways to load data which can be defined using â€œvirtualScrollModeâ€ property.
///<br/>allowVirtualScrolling-boolean	default-false
///<br/><br/>
///Enables or disables the case sensitive search for list item by typing the text (search) value.
///<br/>caseSensitiveSearch-boolean	default-false
///<br/><br/>
///Dynamically populate data of a list box while selecting an item in another list box i.e. rendering child list box based on the item selection in parent list box. This property accepts the id of the child ListBox widget to populate the data.
///<br/>cascadeTo-string	default-null
///<br/><br/>
///Set of list items to be checked by default using its index. It works only when the showCheckbox property is set to true.
///<br/>checkedIndices-Array&lt;any&gt;	default-null
///<br/><br/>
///The root class for the ListBox widget to customize the existing theme.
///<br/>cssClass-string	default-&#226;€œ&#226;€
///<br/><br/>
///Contains the list of data for generating the list items.
///<br/>dataSource-any	default-null
///<br/><br/>
///Enables or disables the ListBox widget.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Enables or disables the search behavior to find the specific list item by typing the text value.
///<br/>enableIncrementalSearch-boolean	default-false
///<br/><br/>
///Allows the current model values to be saved in local storage or browser cookies for state maintenance when it is set to true.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Displays the ListBox widgetâ€™s content from right to left when enabled.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Specifies ellipsis ("...") representation in an overflowed list item content when it is set to false.
///<br/>enableWordWrap-boolean	default-true
///<br/><br/>
///Mapping fields for the data items of the ListBox widget.
///<br/>fields-Fields	default-null
///<br/><br/>
///Defines the specific field name which contains Boolean values to specify whether the list items to be checked by default or not.
///<br/>checkBy-boolean	default-
///<br/><br/>
///The grouping in the ListBox widget can be defined using this field.
///<br/>groupBy-string	default-
///<br/><br/>
///Defines the HTML attributes such as id, class, styles for the specific ListBox item.
///<br/>htmlAttributes-any	default-
///<br/><br/>
///Defines the specific field name which contains id values for the list items.
///<br/>id-string	default-
///<br/><br/>
///Defines the imageURL for the image to be displayed in the ListBox item.
///<br/>imageUrl-string	default-
///<br/><br/>
///Defines the image attributes such as height, width, styles and so on.
///<br/>imageAttributes-string	default-
///<br/><br/>
///Defines the specific field name which contains Boolean values to specify whether the list items to be selected by default or not.
///<br/>selectBy-boolean	default-
///<br/><br/>
///Defines the sprite CSS class for the image to be displayed.
///<br/>spriteCssClass-string	default-
///<br/><br/>
///Defines the table name to get the specific set of list items to be loaded in the ListBox widget while rendering with remote data.
///<br/>tableName-string	default-
///<br/><br/>
///Defines the specific field name in the data source to load the list with data.
///<br/>text-string	default-
///<br/><br/>
///Defines the specific field name in the data source to load the list with data value property.
///<br/>value-string	default-
///<br/><br/>
///Defines the height of the ListBox widget.
///<br/>height-string	default-null
///<br/><br/>
///Defines the height for individual ListBox item.
///<br/>itemHeight-string	default-null
///<br/><br/>
///The number of list items to be shown in the ListBox widget. The remaining list items will be scrollable.
///<br/>itemsCount-number	default-null
///<br/><br/>
///The total number of list items to be rendered in the ListBox widget.
///<br/>totalItemsCount-number	default-null
///<br/><br/>
///The number of list items to be loaded in the list box while enabling virtual scrolling and when virtualScrollMode is set to continuous.
///<br/>itemRequestCount-number	default-5
///<br/><br/>
///Loads data for the listbox by default (i.e. on initialization) when it is set to true. It creates empty ListBox if it is set to false.
///<br/>loadDataOnInit-boolean	default-true
///<br/><br/>
///The query to retrieve required data from the data source.
///<br/>query-ej.Query	default-ej.Query()
///<br/><br/>
///The list item to be selected by default using its index.
///<br/>selectedIndex-number	default-null
///<br/><br/>
///The list items to be selected by default using its indices. To use this property allowMultiSelection should be enabled.
///<br/>selectedIndices-Array&lt;any&gt;	default-[]
///<br/><br/>
///Enables/Disables the multi selection option with the help of checkbox control.
///<br/>showCheckbox-boolean	default-false
///<br/><br/>
///To display the ListBox container with rounded corners.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Set to sort ListBox items either by Ascending or Descending order. By default sortOrder is set as enum type of "None".You can use only below mentioned type for sorting purpose.
///<br/>sortOrder-ej.ListBox.SortOrder|string	default-ej.SortOrder.None
///<br/><br/>
///The template to display the ListBox widget with customized appearance.
///<br/>template-string	default-null
///<br/><br/>
///Holds the selected items values and used to bind value to the list item using AngularJS and KnockoutJS.
///<br/>value-number	default-&#226;€œ&#226;€
///<br/><br/>
///Specifies the virtual scroll mode to load the list data on demand via scrolling behavior. There are two types of mode.
///<br/>virtualScrollMode-ej.VirtualScrollMode|string	default-ej.VirtualScrollMode.Normal
///<br/><br/>
///Defines the width of the ListBox widget.
///<br/>width-string	default-null
///<br/><br/>
///Specifies the targetID for the listbox items.
///<br/>targetID-string	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
ListView:function(){
 /// <signature>
 /// <summary>Constructor of ej.ListView</summary>
 /// </signature>
}
});
ej.ListView=(function(){
var original=ej.ListView
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addItem:function(item, index, groupid){
/// <signature>
/// <summary>
/// To add item in the given index. If you have enabled grouping in ListView then you need to pass the corresponding group list title to add item in it. Depending on the data bound to ListView, we need to pass either an HTML element or JSON objects in this method.
/// </summary>
/// <param name="item"	type="string|any">To pass the list item as element/ JSON object</param>
/// </signature>
/// <signature>
/// <summary>
/// To add item in the given index. If you have enabled grouping in ListView then you need to pass the corresponding group list title to add item in it. Depending on the data bound to ListView, we need to pass either an HTML element or JSON objects in this method.
/// </summary>
/// <param name="index"	type="number">Specifies the index where item to be added</param>
/// </signature>
/// <signature>
/// <summary>
/// To add item in the given index. If you have enabled grouping in ListView then you need to pass the corresponding group list title to add item in it. Depending on the data bound to ListView, we need to pass either an HTML element or JSON objects in this method.
/// </summary>
/// <param name="groupid"	type="string">optionalThis is an optional parameter. You must pass the group list title here if grouping is enabled in the ListView</param>
/// </signature>
},
checkAllItem:function(){
/// <signature>
/// <summary>
/// To check all the items.
/// </summary>
},
checkItem:function(index){
/// <signature>
/// <summary>
/// To check item in the given index.
/// </summary>
/// <param name="index"	type="number">Specifies the index of the item to be checked</param>
/// </signature>
},
clear:function(){
/// <signature>
/// <summary>
/// To clear all the list item in the control before updating with new datasource.
/// </summary>
},
deActive:function(index){
/// <signature>
/// <summary>
/// To make the item in the given index to be default state.
/// </summary>
/// <param name="index"	type="number">Specifies the index to make the item to be in default state.</param>
/// </signature>
},
disableItem:function(index){
/// <signature>
/// <summary>
/// To disable item in the given index.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to be disabled.</param>
/// </signature>
},
enableItem:function(index){
/// <signature>
/// <summary>
/// To enable item in the given index.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to be enabled.</param>
/// </signature>
},
getActiveItem:function(){
/// <signature>
/// <summary>
/// To get the active item.
/// </summary>
},
getActiveItemText:function(){
/// <signature>
/// <summary>
/// To get the text of the active item.
/// </summary>
},
getCheckedItems:function(){
/// <signature>
/// <summary>
/// To get all the checked items.
/// </summary>
},
getCheckedItemsText:function(){
/// <signature>
/// <summary>
/// To get the text of all the checked items.
/// </summary>
},
getItemsCount:function(){
/// <signature>
/// <summary>
/// To get the total item count.
/// </summary>
},
getItemText:function(index){
/// <signature>
/// <summary>
/// To get the text of the item in the given index.
/// </summary>
/// <param name="index"	type="string|number">Specifies the index value to get the text value.</param>
/// </signature>
},
hasChild:function(index){
/// <signature>
/// <summary>
/// To check whether the item in the given index has child item.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to check the item has child or not.</param>
/// </signature>
},
hide:function(){
/// <signature>
/// <summary>
/// To hide the list.
/// </summary>
},
hideItem:function(index){
/// <signature>
/// <summary>
/// To hide item in the given index.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to hide the item.</param>
/// </signature>
},
isChecked:function(){
/// <signature>
/// <summary>
/// To check whether item in the given index is checked.
/// </summary>
},
loadAjaxContent:function(item){
/// <signature>
/// <summary>
/// To load the AJAX content while selecting the item.
/// </summary>
/// <param name="item"	type="string">Specifies the item to load the AJAX content.</param>
/// </signature>
},
removeCheckMark:function(index){
/// <signature>
/// <summary>
/// To remove the check mark either for specific item in the given index or for all items.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to remove the checkbox.</param>
/// </signature>
},
removeItem:function(index){
/// <signature>
/// <summary>
/// To remove item in the given index.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to remove the item.</param>
/// </signature>
},
selectItem:function(index){
/// <signature>
/// <summary>
/// To select item in the given index.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to select the item.</param>
/// </signature>
},
setActive:function(index){
/// <signature>
/// <summary>
/// To make the item in the given index to be active state.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to make the item in active state.</param>
/// </signature>
},
show:function(){
/// <signature>
/// <summary>
/// To show the list.
/// </summary>
},
showItem:function(index){
/// <signature>
/// <summary>
/// To show item in the given index.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to show the hidden item.</param>
/// </signature>
},
unCheckAllItem:function(){
/// <signature>
/// <summary>
/// To uncheck all the items.
/// </summary>
},
unCheckItem:function(index){
/// <signature>
/// <summary>
/// To uncheck item in the given index.
/// </summary>
/// <param name="index"	type="number">Specifies the index value to uncheck the item.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejListView=function(){
this.data("ejListView",new	ej.ListView());
return this;
};
intellisense.annotate(jQuery.fn,{
ejListView :function (options) {
/// <signature>
/// <summary><br/>
///The ListView widget builds interactive ListView interface. This control allows you to select an item from a list-like interface and display a set of data items in different layouts or views. Lists are used for displaying data, data navigation, result lists, and data entry.<br/><br/>
///Specifies the ajaxSettings option to load the items to the ListView control.
///<br/>ajaxSettings-AjaxSettings	default-null
///<br/><br/>
///It specifies, whether to enable or disable asynchronous request.
///<br/>async-boolean	default-
///<br/><br/>
///It specifies the page will be cached in the web browser.
///<br/>cache-boolean	default-
///<br/><br/>
///It specifies the type of data is send in the query string.
///<br/>contentType-string	default-
///<br/><br/>
///It specifies the data as an object, will be passed in the query string.
///<br/>data-any	default-
///<br/><br/>
///It specifies the type of data that you're expecting back from the response.
///<br/>dataType-string	default-
///<br/><br/>
///It specifies the HTTP request type.
///<br/>type-string	default-
///<br/><br/>
///Set the index values to be selected on initial loading. This works only when enableCheckMark is set true.
///<br/>checkedIndices-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets the root class for ListView theme. This cssClass API helps to use custom skinning option for ListView control. By defining the root class using this API, we need to include this root class in CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Contains the list of data for generating the ListView items.
///<br/>dataSource-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies whether to load AJAX content while selecting item.
///<br/>enableAjax-boolean	default-false
///<br/><br/>
///Specifies whether to enable caching the content.
///<br/>enableCache-boolean	default-false
///<br/><br/>
///Specifies whether to enable check mark for the item.
///<br/>enableCheckMark-boolean	default-false
///<br/><br/>
///Specifies whether to enable the filtering feature to filter the item.
///<br/>enableFiltering-boolean	default-false
///<br/><br/>
///Specifies whether to group the list item.
///<br/>enableGroupList-boolean	default-false
///<br/><br/>
///Specifies to maintain the current model value to browser cookies for state maintenance. While refresh the page, the model value will get apply to the control from browser cookies.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Specifies the field settings to map the datasource.
///<br/>fieldSettings-FieldSettings	default-
///<br/><br/>
///Defines the specific field name which contains Boolean values to specify whether the list items to be checked by default or not.
///<br/>checked-boolean	default-
///<br/><br/>
///Defines the URL to be navigated while clicking the list item.
///<br/>navigateUrl-string	default-
///<br/><br/>
///Defines the HTML attributes such as id, class, styles for the specific list item.
///<br/>attributes-any	default-
///<br/><br/>
///Defines the specific field name which contains id values for the list items.
///<br/>id-string	default-
///<br/><br/>
///Defines the URL for the image to be displayed in the list item.
///<br/>imageUrl-string	default-
///<br/><br/>
///Defines the class name for image in that specific list items.
///<br/>imageClass-string	default-
///<br/><br/>
///Specifies whether to prevent the selection of the list item.
///<br/>preventSelection-boolean	default-
///<br/><br/>
///Specifies whether to retain the selection of the list item.
///<br/>persistSelection-boolean	default-
///<br/><br/>
///To define the first level of list items.
///<br/>primaryKey-string	default-
///<br/><br/>
///To define the child level of list items inside the parent items.
///<br/>parentPrimaryKey-string	default-
///<br/><br/>
///Defines the specific field name in the data source to load the list with data.
///<br/>text-string	default-
///<br/><br/>
///To trigger the mouseup event for specific list items.
///<br/>mouseUP-string	default-
///<br/><br/>
///To trigger the mousedown event for specific list items.
///<br/>mouseDown-string	default-
///<br/><br/>
///Contains the array of items to be added in ListView.
///<br/>items-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the text of the back button in the header.
///<br/>headerBackButtonText-string	default-null
///<br/><br/>
///Specifies the title of the header.
///<br/>headerTitle-string	default-Title
///<br/><br/>
///Specifies the height.
///<br/>height-string|number	default-null
///<br/><br/>
///Set the localization culture for ListView Widget.
///<br/>locale-string	default-
///<br/><br/>
///Specifies whether to retain the selection of the item.
///<br/>persistSelection-boolean	default-false
///<br/><br/>
///Specifies whether to prevent the selection of the item.
///<br/>preventSelection-boolean	default-false
///<br/><br/>
///Specifies the query to execute with the datasource.
///<br/>query-any	default-null
///<br/><br/>
///Specifies whether need to render the control with the template contents.
///<br/>renderTemplate-boolean	default-false
///<br/><br/>
///Specifies the index of item which need to be in selected state initially while loading.
///<br/>selectedItemIndex-number	default-0
///<br/><br/>
///Specifies whether to show the header.
///<br/>showHeader-boolean	default-true
///<br/><br/>
///Specifies whether to show the back button header.
///<br/>showHeaderBackButton-boolean	default-false
///<br/><br/>
///Specifies ID of the element contains template contents.
///<br/>templateId-string	default-null
///<br/><br/>
///Specifies the width.
///<br/>width-string|number	default-null
///<br/><br/>
///Specifies the number of items to be fetched on each scroll. Note: This property works only with Virtual scrolling.
///<br/>itemRequestCount-number	default-5
///<br/><br/>
///Specifies the maximum number of items to be fetched. Note: This will work only with Virtual scrolling
///<br/>totalItemsCount-number	default-5
///<br/><br/>
///Loads the list data on demand via scrolling behavior to improve the applicationâ€™s performance. There are two ways to load data which can be defined using virtualScrollMode property.
///<br/>allowVirtualScrolling-boolean	default-false
///<br/><br/>
///Specifies the virtual scroll mode to load the list data on demand via scrolling behavior. There are two types of mode.
///<br/>virtualScrollMode-ej.VirtualScrollMode|string	default-ej.VirtualScrollMode.Normal
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Map:function(){
 /// <signature>
 /// <summary>Constructor of ej.Map</summary>
 /// </signature>
}
});
ej.Map=(function(){
var original=ej.Map
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

navigateTo:function(latitude, longitude, level){
/// <signature>
/// <summary>
/// Method for navigating to specific shape based on latitude, longitude and zoom level.
/// </summary>
/// <param name="latitude"	type="number">Pass the latitude value for map</param>
/// </signature>
/// <signature>
/// <summary>
/// Method for navigating to specific shape based on latitude, longitude and zoom level.
/// </summary>
/// <param name="longitude"	type="number">Pass the longitude value for map</param>
/// </signature>
/// <signature>
/// <summary>
/// Method for navigating to specific shape based on latitude, longitude and zoom level.
/// </summary>
/// <param name="level"	type="number">Pass the zoom level for map</param>
/// </signature>
},
pan:function(direction){
/// <signature>
/// <summary>
/// Method to perform map panning
/// </summary>
/// <param name="direction"	type="string">Pass the direction in which map should be panned</param>
/// </signature>
},
refresh:function(){
/// <signature>
/// <summary>
/// Method to reload the map.
/// </summary>
},
refreshLayers:function(){
/// <signature>
/// <summary>
/// Method to reload the shapeLayers with updated values
/// </summary>
},
refreshNavigationControl:function(navigation){
/// <signature>
/// <summary>
/// Method to reload the navigation control with updated values.
/// </summary>
/// <param name="navigation"	type="any">Pass the navigation control instance</param>
/// </signature>
},
zoom:function(level, isAnimate){
/// <signature>
/// <summary>
/// Method to perform map zooming.
/// </summary>
/// <param name="level"	type="number">Pass the zoom level for map to be zoomed</param>
/// </signature>
/// <signature>
/// <summary>
/// Method to perform map zooming.
/// </summary>
/// <param name="isAnimate"	type="boolean">Pass the boolean value to enable or disable animation while zooming</param>
/// </signature>
},
refreshLayer:function(){
/// <signature>
/// <summary>
/// Method to reload the specified layer based on layer and sublayer index value.
/// </summary>
},
addMarkers:function(){
/// <signature>
/// <summary>
/// Add markers dynamically based on layer and sublayer index value.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejMap=function(){
this.data("ejMap",new	ej.Map());
return this;
};
intellisense.annotate(jQuery.fn,{
ejMap :function (options) {
/// <signature>
/// <summary><br/>
///The map can be easily configured to the DOM element, such as div and can be created with a highly customized look and feel.<br/><br/>
///Specifies the background color for map
///<br/>background-string	default-transparent
///<br/><br/>
///Specifies the index of the map to determine the shape layer to be displayed
///<br/>baseMapIndex-number	default-0
///<br/><br/>
///Specify the center position where map should be displayed
///<br/>centerPosition-any	default-[0,0]
///<br/><br/>
///Controls the selection through dragging
///<br/>draggingOnSelection-boolean	default-false
///<br/><br/>
///Enables or Disables the map animation
///<br/>enableAnimation-boolean	default-false
///<br/><br/>
///Enables or Disables right to left(RTL) support for maps.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Enables or Disables the animation for layer change in map
///<br/>enableLayerChangeAnimation-boolean	default-false
///<br/><br/>
///Enables or Disables the map panning
///<br/>enablePan-boolean	default-true
///<br/><br/>
///Determines whether map need to resize when container is resized
///<br/>enableResize-boolean	default-true
///<br/><br/>
///Determines whether map need to resize when container is resized
///<br/>isResponsive-boolean	default-true
///<br/><br/>
///Enables or Disables the Zooming for map.
///<br/>zoomSettings-ZoomSettings	default-
///<br/><br/>
///Specifies animation duration for map shapes while zooming.
///<br/>animationDuration-string	default-600
///<br/><br/>
///Enables or Disables the zooming of map
///<br/>enableZoom-boolean	default-true
///<br/><br/>
///Enables or Disables the zoom on selecting the map shape
///<br/>enableZoomOnSelection-boolean	default-false
///<br/><br/>
///Enables or Disables the zoom on mouse wheel the map.
///<br/>enableMouseWheelZoom-boolean	default-true
///<br/><br/>
///Specifies the zoom factor for map zoom value.
///<br/>factor-number	default-1
///<br/><br/>
///Specifies the zoom level value for which map to be zoomed
///<br/>level-number	default-1
///<br/><br/>
///Specifies the minimum zoomSettings level of the map
///<br/>minValue-number	default-1
///<br/><br/>
///Specifies the maximum zoom level of the map
///<br/>maxValue-number	default-100
///<br/><br/>
///Enables or Disables the navigation control for map to perform zooming and panning on map shapes.
///<br/>navigationControl-NavigationControl	default-
///<br/><br/>
///Set the absolutePosition for navigation control
///<br/>absolutePosition-any	default-{x:0,y:0}
///<br/><br/>
///Specifies the navigation control template for map
///<br/>content-string	default-null
///<br/><br/>
///Set the dockPosition value for navigation control
///<br/>dockPosition-ej.datavisualization.Map.Position|string	default-centerleft
///<br/><br/>
///Enables or Disables the Navigation for handling zooming map
///<br/>enableNavigation-boolean	default-false
///<br/><br/>
///Set the orientation value for navigation control
///<br/>orientation-ej.datavisualization.Map.LabelOrientation|string	default-vertical
///<br/><br/>
///Name of the culture based on which map should be localized. Labels are localized with respect to the culture name.String type properties like template text are not localized automatically. Provide localized text as value to string type properties.
///<br/>locale-string	default-en-US
///<br/><br/>
///Layer for holding the map shapes
///<br/>layers-Array&lt;Layers&gt;	default-
///<br/><br/>
///to get the type of bing map.
///<br/>bingMapType-ej.datavisualization.Map.BingMapType|string	default-aerial
///<br/><br/>
///Specifies the bubble settings for map
///<br/>bubbleSettings-any	default-
///<br/><br/>
///Specifies the bubble Opacity value of bubbles for shape layer in map
///<br/>bubbleOpacity-number	default-0.9
///<br/><br/>
///Specifies the mouse hover color of the shape layer in map
///<br/>color-string	default-gray
///<br/><br/>
///Specifies the colorMappings of the shape layer in map
///<br/>colorMappings-any	default-null
///<br/><br/>
///Specifies the range colorMappings in the bubble layer.
///<br/>rangeColorMapping-Array&lt;any&gt;	default-null
///<br/><br/>
///Start range colorMappings in the bubble layer.
///<br/>from-number	default-null
///<br/><br/>
///End range colorMappings in the bubble layer.
///<br/>to-number	default-null
///<br/><br/>
///GradientColors in the bubble layer of map.
///<br/>gradientColors-Array&lt;any&gt;	default-
///<br/><br/>
///Color of the bubble layer.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the bubble color valuePath of the shape layer in map
///<br/>colorValuePath-string	default-null
///<br/><br/>
///Specifies the maximum size value of bubbles for shape layer in map
///<br/>maxValue-number	default-20
///<br/><br/>
///Specifies the minimum size value of bubbles for shape layer in map
///<br/>minValue-number	default-10
///<br/><br/>
///Specifies the showBubble visibility status map
///<br/>showBubble-boolean	default-true
///<br/><br/>
///Specifies the tooltip visibility status of the shape layer in map
///<br/>showTooltip-boolean	default-false
///<br/><br/>
///Specifies the bubble tooltip template of the shape layer in map
///<br/>tooltipTemplate-string	default-null
///<br/><br/>
///Specifies the bubble valuePath of the shape layer in map
///<br/>valuePath-string	default-null
///<br/><br/>
///Specifies the datasource for the shape layer
///<br/>dataSource-any	default-
///<br/><br/>
///Specifies the data path of shape
///<br/>shapeDataPath-string	default-
///<br/><br/>
///Specifies the data path of shape
///<br/>shapePropertyPath-string	default-
///<br/><br/>
///Enables or disables the shape mouse hover
///<br/>enableMouseHover-boolean	default-false
///<br/><br/>
///Enables or disables the shape selection
///<br/>enableSelection-boolean	default-true
///<br/><br/>
///to get the key of bing map
///<br/>key-string	default-null
///<br/><br/>
///Options for enabling and configuring labelSettings labelPath, smartLabelSize, labelLength etc.,
///<br/>labelSettings-any	default-
///<br/><br/>
///enable or disable the enableSmartLabel property
///<br/>enableSmartLabel-boolean	default-false
///<br/><br/>
///set the labelLength property
///<br/>labelLength-number	default-&#39;2&#39;
///<br/><br/>
///set the labelPath property
///<br/>labelPath-string	default-null
///<br/><br/>
///The property specifies whether to show labels or not.
///<br/>showLabels-boolean	default-false
///<br/><br/>
///set the smartLabelSize property
///<br/>smartLabelSize-ej.datavisualization.Map.LabelSize|string	default-fixed
///<br/><br/>
///Options for customizing the data label font.
///<br/>font-any	default-
///<br/><br/>
///Font family of the data label.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Font style of the data label.
///<br/>fontStyle-ej.datavisualization.Map.FontStyle|string	default-normal.
///<br/><br/>
///NameType DescriptionRegularstring Specifies the font weight as regular.BoldstringSpecifies the font weight as bold.LighterstringSpecifies the font weight as lighter.  
///<br/>fontWeight-ej.datavisualization.Map.FontWeight|string	default-regular. See
///<br/><br/>
///Opacity of the text.
///<br/>opacity-number	default-1
///<br/><br/>
///Font color of the data label text.
///<br/>color-string	default-null
///<br/><br/>
///Font size of the data label.
///<br/>size-string	default-12px
///<br/><br/>
///Specifies the map view type.
///<br/>geometryType-ej.datavisualization.Map.GeometryType|string	default-&#39;geographic&#39;
///<br/><br/>
///Specifies the map type.
///<br/>layerType-ej.datavisualization.Map.LayerType|string	default-&#39;geometry&#39;
///<br/><br/>
///Options for enabling and configuring legendSettings position, height, width, mode, type etc.,
///<br/>legendSettings-any	default-
///<br/><br/>
///Determines whether the legend should be placed outside or inside the map bounds
///<br/>dockOnMap-boolean	default-false
///<br/><br/>
///Determines the legend placement and it is valid only when dockOnMap is true
///<br/>dockPosition-ej.datavisualization.Map.DockPosition|string	default-top
///<br/><br/>
///height value for legend setting
///<br/>height-number	default-0
///<br/><br/>
///to get icon value for legend setting
///<br/>icon-ej.datavisualization.Map.LegendIcons|string	default-rectangle
///<br/><br/>
///icon height value for legend setting
///<br/>iconHeight-number	default-20
///<br/><br/>
///icon Width value for legend setting
///<br/>iconWidth-number	default-20
///<br/><br/>
///set the orientation of legend labels
///<br/>labelOrientation-ej.datavisualization.Map.LabelOrientation|string	default-vertical
///<br/><br/>
///to get leftLabel value for legend setting
///<br/>leftLabel-string	default-null
///<br/><br/>
///To get the field name in the datasource for generating legend items.
///<br/>textPath-string	default-null
///<br/><br/>
///to get mode of legend setting
///<br/>mode-ej.datavisualization.Map.Mode|string	default-default
///<br/><br/>
///set the position of legend settings
///<br/>position-ej.datavisualization.Map.Position|string	default-topleft
///<br/><br/>
///x position value for legend setting
///<br/>positionX-number	default-0
///<br/><br/>
///y position value for legend setting
///<br/>positionY-number	default-0
///<br/><br/>
///to get rightLabel value for legend setting
///<br/>rightLabel-string	default-null
///<br/><br/>
///Enables or Disables the showLabels
///<br/>showLabels-boolean	default-false
///<br/><br/>
///Enables or Disables the showLegend
///<br/>showLegend-boolean	default-false
///<br/><br/>
///Toggle the visibility of the legend.
///<br/>toggleVisibility-boolean	default-false
///<br/><br/>
///to get title of legend setting
///<br/>title-string	default-null
///<br/><br/>
///to get type of legend setting
///<br/>type-ej.datavisualization.Map.LegendType|string	default-layers
///<br/><br/>
///width value for legend setting
///<br/>width-number	default-0
///<br/><br/>
///Specifies the map items template for shapes.
///<br/>mapItemsTemplate-string	default-
///<br/><br/>
///Specify markers for shape layer.
///<br/>markers-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the map marker template for map layer.
///<br/>markerTemplate-string	default-null
///<br/><br/>
///Specify selectedMapShapes for shape layer
///<br/>selectedMapShapes-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the selection mode of the map. Accepted selection mode values are Default and Multiple.
///<br/>selectionMode-ej.datavisualization.Map.SelectionMode|string	default-default
///<br/><br/>
///Specifies the shape data for the shape layer
///<br/>shapeData-any	default-
///<br/><br/>
///Specifies the shape settings of map layer
///<br/>shapeSettings-any	default-
///<br/><br/>
///Enables or Disables the auto fill colors for shape layer in map. When this property value set to true, shapes will be filled with palette colors.
///<br/>autoFill-boolean	default-false
///<br/><br/>
///Specifies the colorMappings of the shape layer in map
///<br/>colorMappings-any	default-null
///<br/><br/>
///Specifies the range colorMappings in the shape layer of map.
///<br/>rangeColorMapping-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the start range colorMappings in the shape layer of map.
///<br/>from-number	default-null
///<br/><br/>
///Specifies the to range colorMappings in the shape layer of map.
///<br/>to-number	default-null
///<br/><br/>
///Specifies the gradientColors in the shape layer of map.
///<br/>gradientColors-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the equalColorMapping in the shape layer of map.
///<br/>equalColorMapping-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the equalColorMapping value in the shape layer of map.
///<br/>value-string	default-null
///<br/><br/>
///Specifies the equalColorMapping color in the shape layer of map.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the shape color palette value of the shape layer in map. Accepted colorPalette values are palette1, palette2, palette3 and custompalette.
///<br/>colorPalette-ej.datavisualization.Map.ColorPalette|string	default-palette1
///<br/><br/>
///Specifies the shape color valuePath of the shape layer in map
///<br/>colorValuePath-string	default-null
///<br/><br/>
///Specifies the field name in the datasource that contains color values for each shapes.
///<br/>colorPath-string	default-null
///<br/><br/>
///Enables or Disables the gradient colors for map shapes.
///<br/>enableGradient-boolean	default-false
///<br/><br/>
///Specifies the shape fill color of the shape layer in map
///<br/>fill-string	default-#E5E5E5
///<br/><br/>
///Specifies the mouse over width of the shape layer in map
///<br/>highlightBorderWidth-number	default-1
///<br/><br/>
///Specifies the mouse hover color of the shape layer in map
///<br/>highlightColor-string	default-gray
///<br/><br/>
///Specifies the mouse over stroke color of the shape layer in map
///<br/>highlightStroke-string	default-#C1C1C1
///<br/><br/>
///Specifies the shape selection color of the shape layer in map
///<br/>selectionColor-string	default-gray
///<br/><br/>
///Specifies the shape selection stroke color of the shape layer in map
///<br/>selectionStroke-string	default-#C1C1C1
///<br/><br/>
///Specifies the shape selection stroke width of the shape layer in map
///<br/>selectionStrokeWidth-number	default-1
///<br/><br/>
///Specifies the shape stroke color of the shape layer in map
///<br/>stroke-string	default-#C1C1C1
///<br/><br/>
///Specifies the shape stroke thickness value of the shape layer in map
///<br/>strokeThickness-number	default-0.2
///<br/><br/>
///Specifies the shape valuePath of the shape layer in map
///<br/>valuePath-string	default-null
///<br/><br/>
///Shows or hides the map items.
///<br/>showMapItems-boolean	default-false
///<br/><br/>
///Shows or hides the tooltip for shapes
///<br/>showTooltip-boolean	default-false
///<br/><br/>
///Specifies the tooltip template for shapes.
///<br/>tooltipTemplate-string	default-
///<br/><br/>
///Specifies the URL template for the OSM type map.
///<br/>urlTemplate-string	default-&#39;http://a.tile.openstreetmap.org/level/tileX/tileY.png&#39;
///<br/><br/>
///Sublayer is the collection of shape Layer
///<br/>subLayers-Array&lt;any&gt;	default-
///<br/><br/>
///to get the type of bing map.
///<br/>bingMapType-ej.datavisualization.Map.BingMapType|string	default-aerial
///<br/><br/>
///Specifies the bubble settings for map
///<br/>bubbleSettings-any	default-
///<br/><br/>
///Specifies the bubble Opacity value of bubbles for shape layer in map
///<br/>bubbleOpacity-number	default-0.9
///<br/><br/>
///Specifies the mouse hover color of the shape layer in map
///<br/>color-string	default-gray
///<br/><br/>
///Specifies the colorMappings of the shape layer in map
///<br/>colorMappings-any	default-null
///<br/><br/>
///Specifies the range colorMappings in the bubble layer.
///<br/>rangeColorMapping-Array&lt;any&gt;	default-null
///<br/><br/>
///Start range colorMappings in the bubble layer.
///<br/>from-number	default-null
///<br/><br/>
///End range colorMappings in the bubble layer.
///<br/>to-number	default-null
///<br/><br/>
///GradientColors in the bubble layer of map.
///<br/>gradientColors-Array&lt;any&gt;	default-
///<br/><br/>
///Color of the bubble layer.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the bubble color valuePath of the shape layer in map
///<br/>colorValuePath-string	default-null
///<br/><br/>
///Specifies the field name in the datasource that contains color values for each bubbles.
///<br/>colorPath-string	default-null
///<br/><br/>
///Specifies the maximum size value of bubbles for shape layer in map
///<br/>maxValue-number	default-20
///<br/><br/>
///Specifies the minimum size value of bubbles for shape layer in map
///<br/>minValue-number	default-10
///<br/><br/>
///Specifies the showBubble visibility status map
///<br/>showBubble-boolean	default-true
///<br/><br/>
///Specifies the tooltip visibility status of the shape layer in map
///<br/>showTooltip-boolean	default-false
///<br/><br/>
///Specifies the bubble tooltip template of the shape layer in map
///<br/>tooltipTemplate-string	default-null
///<br/><br/>
///Specifies the bubble valuePath of the shape layer in map
///<br/>valuePath-string	default-null
///<br/><br/>
///Specifies the datasource for the shape layer
///<br/>dataSource-any	default-
///<br/><br/>
///Specifies the data path of shape
///<br/>shapeDataPath-string	default-
///<br/><br/>
///Specifies the data path of shape
///<br/>shapePropertyPath-string	default-
///<br/><br/>
///Enables or disables the shape mouse hover
///<br/>enableMouseHover-boolean	default-false
///<br/><br/>
///Enables or disables the shape selection
///<br/>enableSelection-boolean	default-true
///<br/><br/>
///to get the key of bing map
///<br/>key-string	default-null
///<br/><br/>
///Options for enabling and configuring labelSettings labelPath, smartLabelSize, labelLength etc.,
///<br/>labelSettings-any	default-
///<br/><br/>
///enable or disable the enableSmartLabel property
///<br/>enableSmartLabel-boolean	default-false
///<br/><br/>
///set the labelLength property
///<br/>labelLength-number	default-&#39;2&#39;
///<br/><br/>
///set the labelPath property
///<br/>labelPath-string	default-null
///<br/><br/>
///The property specifies whether to show labels or not.
///<br/>showLabels-boolean	default-false
///<br/><br/>
///set the smartLabelSize property
///<br/>smartLabelSize-ej.datavisualization.Map.LabelSize|string	default-fixed
///<br/><br/>
///Specifies the map view type.
///<br/>geometryType-ej.datavisualization.Map.GeometryType|string	default-&#39;geographic&#39;
///<br/><br/>
///Specifies the map type.
///<br/>layerType-ej.datavisualization.Map.LayerType|string	default-&#39;geometry&#39;
///<br/><br/>
///Options for enabling and configuring legendSettings position, height, width, mode, type etc.,
///<br/>legendSettings-any	default-
///<br/><br/>
///Determines whether the legend should be placed outside or inside the map bounds
///<br/>dockOnMap-boolean	default-false
///<br/><br/>
///Determines the legend placement and it is valid only when dockOnMap is true
///<br/>dockPosition-ej.datavisualization.Map.DockPosition|string	default-top
///<br/><br/>
///height value for legend setting
///<br/>height-number	default-0
///<br/><br/>
///to get icon value for legend setting
///<br/>icon-ej.datavisualization.Map.LegendIcons|string	default-rectangle
///<br/><br/>
///icon height value for legend setting
///<br/>iconHeight-number	default-20
///<br/><br/>
///icon Width value for legend setting
///<br/>iconWidth-number	default-20
///<br/><br/>
///set the orientation of legend labels
///<br/>labelOrientation-ej.datavisualization.Map.LabelOrientation|string	default-vertical
///<br/><br/>
///to get leftLabel value for legend setting
///<br/>leftLabel-string	default-null
///<br/><br/>
///To get the field name in the datasource for generating legend items.
///<br/>textPath-string	default-null
///<br/><br/>
///to get mode of legend setting
///<br/>mode-ej.datavisualization.Map.Mode|string	default-default
///<br/><br/>
///set the position of legend settings
///<br/>position-ej.datavisualization.Map.Position|string	default-topleft
///<br/><br/>
///x position value for legend setting
///<br/>positionX-number	default-0
///<br/><br/>
///y position value for legend setting
///<br/>positionY-number	default-0
///<br/><br/>
///to get rightLabel value for legend setting
///<br/>rightLabel-string	default-null
///<br/><br/>
///Enables or Disables the showLabels
///<br/>showLabels-boolean	default-false
///<br/><br/>
///Enables or Disables the showLegend
///<br/>showLegend-boolean	default-false
///<br/><br/>
///to get title of legend setting
///<br/>title-string	default-null
///<br/><br/>
///to get type of legend setting
///<br/>type-ej.datavisualization.Map.LegendType|string	default-layers
///<br/><br/>
///width value for legend setting
///<br/>width-number	default-0
///<br/><br/>
///Specifies the map items template for shapes.
///<br/>mapItemsTemplate-string	default-
///<br/><br/>
///Specify markers for shape layer.
///<br/>markers-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the map marker template for map layer.
///<br/>markerTemplate-string	default-null
///<br/><br/>
///Specify selectedMapShapes for shape layer
///<br/>selectedMapShapes-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the selection mode of the map. Accepted selection mode values are Default and Multiple.
///<br/>selectionMode-ej.datavisualization.Map.SelectionMode|string	default-default
///<br/><br/>
///Specifies the shape data for the shape layer
///<br/>shapeData-any	default-
///<br/><br/>
///Specifies the shape settings of map layer
///<br/>shapeSettings-any	default-
///<br/><br/>
///Enables or Disables the auto fill colors for shape layer in map. When this property value set to true, shapes will be filled with palette colors.
///<br/>autoFill-boolean	default-false
///<br/><br/>
///Specifies the colorMappings of the shape layer in map
///<br/>colorMappings-any	default-null
///<br/><br/>
///Specifies the range colorMappings in the shape layer of map.
///<br/>rangeColorMapping-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the start range colorMappings in the shape layer of map.
///<br/>from-number	default-null
///<br/><br/>
///Specifies the to range colorMappings in the shape layer of map.
///<br/>to-number	default-null
///<br/><br/>
///Specifies the gradientColors in the shape layer of map.
///<br/>gradientColors-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the equalColorMapping in the shape layer of map.
///<br/>equalColorMapping-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the equalColorMapping value in the shape layer of map.
///<br/>value-string	default-null
///<br/><br/>
///Specifies the equalColorMapping color in the shape layer of map.
///<br/>color-string	default-null
///<br/><br/>
///Specifies the shape color palette value of the shape layer in map. Accepted colorPalette values are palette1, palette2, palette3 and custompalette.
///<br/>colorPalette-ej.datavisualization.Map.ColorPalette|string	default-palette1
///<br/><br/>
///Specifies the shape color valuePath of the shape layer in map
///<br/>colorValuePath-string	default-null
///<br/><br/>
///Enables or Disables the gradient colors for map shapes.
///<br/>enableGradient-boolean	default-false
///<br/><br/>
///Specifies the shape fill color of the shape layer in map
///<br/>fill-string	default-#E5E5E5
///<br/><br/>
///Specifies the mouse over width of the shape layer in map
///<br/>highlightBorderWidth-number	default-1
///<br/><br/>
///Specifies the mouse hover color of the shape layer in map
///<br/>highlightColor-string	default-gray
///<br/><br/>
///Specifies the mouse over stroke color of the shape layer in map
///<br/>highlightStroke-string	default-#C1C1C1
///<br/><br/>
///Specifies the shape selection color of the shape layer in map
///<br/>selectionColor-string	default-gray
///<br/><br/>
///Specifies the shape selection stroke color of the shape layer in map
///<br/>selectionStroke-string	default-#C1C1C1
///<br/><br/>
///Specifies the shape selection stroke width of the shape layer in map
///<br/>selectionStrokeWidth-number	default-1
///<br/><br/>
///Specifies the shape stroke color of the shape layer in map
///<br/>stroke-string	default-#C1C1C1
///<br/><br/>
///Specifies the shape stroke thickness value of the shape layer in map
///<br/>strokeThickness-number	default-0.2
///<br/><br/>
///Specifies the shape valuePath of the shape layer in map
///<br/>valuePath-string	default-null
///<br/><br/>
///Shows or hides the map items.
///<br/>showMapItems-boolean	default-false
///<br/><br/>
///Shows or hides the tooltip for shapes
///<br/>showTooltip-boolean	default-false
///<br/><br/>
///Specifies the tooltip template for shapes.
///<br/>tooltipTemplate-string	default-
///<br/><br/>
///Specifies the URL template for the OSM type map.
///<br/>urlTemplate-string	default-&#39;http://a.tile.openstreetmap.org/level/tileX/tileY.png&#39;
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
MaskEdit:function(){
 /// <signature>
 /// <summary>Constructor of ej.MaskEdit</summary>
 /// </signature>
}
});
ej.MaskEdit=(function(){
var original=ej.MaskEdit
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

clear:function(){
/// <signature>
/// <summary>
/// To clear the text in mask edit textbox control.
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// To disable the mask edit textbox control.
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// To enable the mask edit textbox control.
/// </summary>
},
get_StrippedValue:function(){
/// <signature>
/// <summary>
/// To obtained the pure value of the text value, removes all the symbols in mask edit textbox control.
/// </summary>
},
get_UnstrippedValue:function(){
/// <signature>
/// <summary>
/// To obtained the textbox value as such that, Just replace all '_' to ' '(space) in mask edit textbox control.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejMaskEdit=function(){
this.data("ejMaskEdit",new	ej.MaskEdit());
return this;
};
intellisense.annotate(jQuery.fn,{
ejMaskEdit :function (options) {
/// <signature>
/// <summary><br/>
///The MaskEdit control provides an easy and reliable way of collecting user input and displaying standard data in a specific format. Some common uses of the MaskEdit control are IP address editors, phone number editors, and Social Security number editors.<br/><br/>
///Specify the cssClass to achieve custom theme.
///<br/>cssClass-string	default-null
///<br/><br/>
///Specify the custom character allowed to entered in mask edit textbox control.
///<br/>customCharacter-string	default-null
///<br/><br/>
///Specify the state of the mask edit textbox control.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Specify the enablePersistence to mask edit textbox to save current model value to browser cookies for state maintains.
///<br/>enablePersistence-boolean	default-
///<br/><br/>
///Specifies the height for the mask edit textbox control.
///<br/>height-string	default-28 px
///<br/><br/>
///Specifies whether hide the prompt characters with spaces on blur. Prompt chars will be shown again on focus the textbox.
///<br/>hidePromptOnLeave-boolean	default-false
///<br/><br/>
///Specifies the list of HTML attributes to be added to mask edit textbox.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Specify the inputMode for mask edit textbox control. See InputMode
///<br/>inputMode-ej.InputMode|string	default-ej.InputMode.Text
///<br/><br/>
///Defines the localization culture for MaskEdit.
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the input mask.
///<br/>maskFormat-string	default-null
///<br/><br/>
///Specifies the name attribute value for the mask edit textbox.
///<br/>name-string	default-null
///<br/><br/>
///Toggles the readonly state of the mask edit textbox. When the mask edit textbox is readonly, it doesn't allow your input.
///<br/>readOnly-boolean	default-false
///<br/><br/>
///Specifies whether the error will show until correct value entered in the mask edit textbox control.
///<br/>showError-boolean	default-false
///<br/><br/>
///when showPromptChar is true, the hide the prompt characters are shown in focus of the control and hides in focus out of the control.
///<br/>showPromptChar-boolean	default-true
///<br/><br/>
///MaskEdit input is displayed in rounded corner style when this property is set to true.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Specify the text alignment for mask edit textbox control.See TextAlign
///<br/>textAlign-ej.TextAlign|string	default-left
///<br/><br/>
///Sets the jQuery validation error message in mask edit. This property works when the widget is present inside the form. Include jquery.validate.min.js plugin additionally.
///<br/>validationMessage-any	default-null
///<br/><br/>
///Sets the jQuery validation rules to the MaskEdit. This property works when the widget is present inside the form. Include jquery.validate.min.js plugin additionally.
///<br/>validationRules-any	default-null
///<br/><br/>
///Specifies the value for the mask edit textbox control.
///<br/>value-string	default-null
///<br/><br/>
///Specifies the water mark text to be displayed in input text.
///<br/>watermarkText-string	default-null
///<br/><br/>
///Specifies the width for the mask edit textbox control.
///<br/>width-string	default-143pixel
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Menu:function(){
 /// <signature>
 /// <summary>Constructor of ej.Menu</summary>
 /// </signature>
}
});
ej.Menu=(function(){
var original=ej.Menu
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

disable:function(){
/// <signature>
/// <summary>
/// Disables the Menu control.
/// </summary>
},
disableItem:function(itemtext){
/// <signature>
/// <summary>
/// Specifies the Menu Item to be disabled by using the Menu Item Text.
/// </summary>
/// <param name="itemtext"	type="string">Specifies the Menu Item Text to be disabled.</param>
/// </signature>
},
disableItemByID:function(itemid){
/// <signature>
/// <summary>
/// Specifies the Menu Item to be disabled by using the Menu Item Id.
/// </summary>
/// <param name="itemid"	type="string|number">Specifies the Menu Item id to be disabled</param>
/// </signature>
},
enable:function(){
/// <signature>
/// <summary>
/// Enables the Menu control.
/// </summary>
},
enableItem:function(itemtext){
/// <signature>
/// <summary>
/// Specifies the Menu Item to be enabled by using the Menu Item Text.
/// </summary>
/// <param name="itemtext"	type="string">Specifies the Menu Item Text to be enabled.</param>
/// </signature>
},
enableItemByID:function(itemid){
/// <signature>
/// <summary>
/// Specifies the Menu Item to be enabled by using the Menu Item Id.
/// </summary>
/// <param name="itemid"	type="string|number">Specifies the Menu Item id to be enabled.</param>
/// </signature>
},
hide:function(){
/// <signature>
/// <summary>
/// Hides the Context Menu control.
/// </summary>
},
hideItems:function(itemID){
/// <signature>
/// <summary>
/// Hides the specific items in Menu control.
/// </summary>
/// <param name="itemID"	type="string|any[]">ItemID of the Menu item to be hidden</param>
/// </signature>
},
insert:function(item, target){
/// <signature>
/// <summary>
/// Insert the menu item as child of target node.
/// </summary>
/// <param name="item"	type="any">Information about Menu item.</param>
/// </signature>
/// <signature>
/// <summary>
/// Insert the menu item as child of target node.
/// </summary>
/// <param name="target"	type="string|any">Selector of target node or Object of target node.</param>
/// </signature>
},
insertAfter:function(item, target){
/// <signature>
/// <summary>
/// Insert the menu item after the target node.
/// </summary>
/// <param name="item"	type="any">Information about Menu item.</param>
/// </signature>
/// <signature>
/// <summary>
/// Insert the menu item after the target node.
/// </summary>
/// <param name="target"	type="string|any">Selector of target node or Object of target node.</param>
/// </signature>
},
insertBefore:function(item, target){
/// <signature>
/// <summary>
/// Insert the menu item before the target node.
/// </summary>
/// <param name="item"	type="any">Information about Menu item.</param>
/// </signature>
/// <signature>
/// <summary>
/// Insert the menu item before the target node.
/// </summary>
/// <param name="target"	type="string|any">Selector of target node or Object of target node.</param>
/// </signature>
},
remove:function(target){
/// <signature>
/// <summary>
/// Remove Menu item.
/// </summary>
/// <param name="target"	type="any|any[]">Selector of target node or Object of target node.</param>
/// </signature>
},
show:function(locationX, locationY, targetElement, event){
/// <signature>
/// <summary>
/// To show the Menu control.
/// </summary>
/// <param name="locationX"	type="number">x co-ordinate position of context menu.</param>
/// </signature>
/// <signature>
/// <summary>
/// To show the Menu control.
/// </summary>
/// <param name="locationY"	type="number">y co-ordinate position of context menu.</param>
/// </signature>
/// <signature>
/// <summary>
/// To show the Menu control.
/// </summary>
/// <param name="targetElement"	type="any">target element</param>
/// </signature>
/// <signature>
/// <summary>
/// To show the Menu control.
/// </summary>
/// <param name="event"	type="any">name of the event</param>
/// </signature>
},
showItems:function(itemID){
/// <signature>
/// <summary>
/// Show the specific items in Menu control.
/// </summary>
/// <param name="itemID"	type="string|any[]">ItemID of the Menu item to be shown</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejMenu=function(){
this.data("ejMenu",new	ej.Menu());
return this;
};
intellisense.annotate(jQuery.fn,{
ejMenu :function (options) {
/// <signature>
/// <summary><br/>
///The Menu control supports displaying a Menu created from list items. The Menu is based on a hierarchy of UL and LI elements where the list items are rendered as sub-menu items.<br/><br/>
///To enable or disable the Animation while hover or click an menu items.See AnimationType
///<br/>animationType-ej.AnimationType|string	default-ej.AnimationType.Default
///<br/><br/>
///Specifies the target id of context menu. On right clicking the specified contextTarget element, context menu gets shown.
///<br/>contextMenuTarget-string	default-null
///<br/><br/>
///Specifies the container element selectors for submenuâ€™s collision. The submenu gets displayed based on spacing available with respect to container element.
///<br/>container-string	default-null
///<br/><br/>
///Specify the CSS class to achieve custom theme.
///<br/>cssClass-string	default-
///<br/><br/>
///To enable or disable the Animation effect while hover or click an menu items.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Specifies the root menu items to be aligned center in horizontal menu.
///<br/>enableCenterAlign-boolean	default-false
///<br/><br/>
///Enable / Disable the Menu control.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Specifies the menu items to be displayed in right to left direction.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///When this property sets to false, the menu items is displayed without any separators.
///<br/>enableSeparator-boolean	default-true
///<br/><br/>
///Specifies the target which needs to be excluded. i.e., The context menu will not be displayed in those specified targets.
///<br/>excludeTarget-string	default-null
///<br/><br/>
///Fields used to bind the data source and it includes following field members to make data bind easier.
///<br/>fields-Fields	default-null
///<br/><br/>
///It receives the child data for the inner level.
///<br/>child-any	default-
///<br/><br/>
///It receives datasource as Essential DataManager object and JSON object.
///<br/>dataSource-any	default-
///<br/><br/>
///Specifies the HTML attributes to â€œLIâ€ item list.
///<br/>htmlAttribute-string	default-
///<br/><br/>
///Specifies the id to menu items list
///<br/>id-string	default-
///<br/><br/>
///Specifies the image attribute to â€œimgâ€ tag inside items list.
///<br/>imageAttribute-string	default-
///<br/><br/>
///Specifies the image URL to â€œimgâ€ tag inside item list.
///<br/>imageUrl-string	default-
///<br/><br/>
///Adds custom attributes like "target" to the anchor tag of the menu items.
///<br/>linkAttribute-string	default-
///<br/><br/>
///Specifies the parent id of the table.
///<br/>parentId-string	default-
///<br/><br/>
///It receives query to retrieve data from the table (query is same as SQL).
///<br/>query-any	default-
///<br/><br/>
///Specifies the sprite CSS class to â€œLIâ€ item list.
///<br/>spriteCssClass-string	default-
///<br/><br/>
///It receives table name to execute query on the corresponding table.
///<br/>tableName-string	default-
///<br/><br/>
///Specifies the text of menu items list.
///<br/>text-string	default-
///<br/><br/>
///Specifies the URL to the anchor tag in menu item list.
///<br/>url-string	default-
///<br/><br/>
///Specifies the height of the root menu.
///<br/>height-string|number	default-auto
///<br/><br/>
///Specifies the list of HTML attributes to be added to menu control.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Enables/disables responsive support for the Menu control during the window resizing time.
///<br/>isResponsive-boolean	default-true
///<br/><br/>
///Specifies the type of the menu. Essential JavaScript Menu consists of two type of menu, they are Normal Menu and Context Menu mode.See MenuType
///<br/>menuType-string|ej.MenuType	default-ej.MenuType.NormalMenu
///<br/><br/>
///Specifies the sub menu items to be show or open only on click.
///<br/>openOnClick-boolean	default-false
///<br/><br/>
///Specifies the orientation of normal menu. Normal menu can rendered in horizontal or vertical direction by using this API. See Orientation
///<br/>orientation-ej.Orientation|string	default-ej.Orientation.Horizontal
///<br/><br/>
///Specifies the main menu items arrows only to be shown if it contains child items.
///<br/>showRootLevelArrows-boolean	default-true
///<br/><br/>
///Specifies the sub menu items arrows only to be shown if it contains child items.
///<br/>showSubLevelArrows-boolean	default-true
///<br/><br/>
///Specifies position of pull down submenu that will appear on mouse over.See Direction
///<br/>subMenuDirection-string|ej.Direction	default-ej.Direction.Right
///<br/><br/>
///Specifies the title to responsive menu.
///<br/>titleText-string	default-Menu
///<br/><br/>
///Specifies the width of the main menu.
///<br/>width-string|number	default-auto
///<br/><br/>
///Specifies the popup menu height.
///<br/>overflowHeight-string|number	default-auto
///<br/><br/>
///Specifies the popup menu width.
///<br/>overflowWidth-string|number	default-auto
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
NavigationDrawer:function(){
 /// <signature>
 /// <summary>Constructor of ej.NavigationDrawer</summary>
 /// </signature>
}
});
ej.NavigationDrawer=(function(){
var original=ej.NavigationDrawer
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

close:function(){
/// <signature>
/// <summary>
/// To close the navigation drawer control
/// </summary>
},
loadContent:function(){
/// <signature>
/// <summary>
/// To load AJAX content into NavigationDrawer container.
/// </summary>
},
open:function(){
/// <signature>
/// <summary>
/// To open the navigation drawer control
/// </summary>
},
toggle:function(){
/// <signature>
/// <summary>
/// To Toggle the navigation drawer control
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejNavigationDrawer=function(){
this.data("ejNavigationDrawer",new	ej.NavigationDrawer());
return this;
};
intellisense.annotate(jQuery.fn,{
ejNavigationDrawer :function (options) {
/// <signature>
/// <summary><br/>
///The Navigation Drawer is a sliding panel that displays the list of navigation options on demand. That is, by default, it is not visible but you can display it onto the left/right side of the screen by swiping or by clicking with desired target icon.<br/><br/>
///Specifies the ajaxSettings option to load the content to the NavigationDrawer control.
///<br/>ajaxSettings-AjaxSettings	default-null
///<br/><br/>
///It specifies, whether to enable or disable asynchronous request.
///<br/>async-boolean	default-
///<br/><br/>
///It specifies the page will be cached in the web browser.
///<br/>cache-boolean	default-
///<br/><br/>
///It specifies the type of data is send in the query string.
///<br/>contentType-string	default-
///<br/><br/>
///It specifies the data as an object, will be passed in the query string.
///<br/>data-any	default-
///<br/><br/>
///It specifies the type of data that you're expecting back from the response.
///<br/>dataType-string	default-
///<br/><br/>
///It specifies the HTTP request type.
///<br/>type-string	default-
///<br/><br/>
///Specifies the contentId for navigation drawer, where the AJAX content need to updated
///<br/>contentId-string	default-null
///<br/><br/>
///Sets the root class for NavigationDrawer theme. This cssClass API helps to use custom skinning option for NavigationDrawer control. By defining the root class using this API, we need to include this root class in CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Sets the Direction for the control. See Direction
///<br/>direction-ej.Direction|string	default-left
///<br/><br/>
///Sets the listview to be enabled or not
///<br/>enableListView-boolean	default-false
///<br/><br/>
///Specifies the listview items as an array of object.
///<br/>items-Array&lt;any&gt;	default-[]
///<br/><br/>
///Sets all the properties of listview to render in navigation drawer
///<br/>listViewSettings-any	default-
///<br/><br/>
///Specifies position whether it is in fixed or relative to the page. See Position
///<br/>position-string	default-normal
///<br/><br/>
///Specifies the targetId for navigation drawer
///<br/>targetId-string	default-
///<br/><br/>
///Sets the rendering type of the control. See Type
///<br/>type-string	default-overlay
///<br/><br/>
///Specifies the width of the control
///<br/>width-number	default-auto
///<br/><br/>
///Navigation pane opened initially when isPaneOpen property is true.
///<br/>isPaneOpen-boolean	default-false
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Overview:function(){
 /// <signature>
 /// <summary>Constructor of ej.Overview</summary>
 /// </signature>
}
});
ej.Overview=(function(){
var original=ej.Overview
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejOverview=function(){
this.data("ejOverview",new	ej.Overview());
return this;
};
intellisense.annotate(jQuery.fn,{
ejOverview :function (options) {
/// <signature>
/// <summary><br/>
///Overview control allows you to see a preview or an overall view of the entire content of a Diagram. This helps you to look at the overall picture of a large Diagram and also to navigate, pan, or zoom, on a particular position of the page.<br/><br/>
///The sourceId property of overview should be set with the corresponding Diagram ID for you need the overall view.
///<br/>sourceID-string	default-null
///<br/><br/>
///Defines the height of the overview
///<br/>height-number	default-400
///<br/><br/>
///Defines the width of the overview
///<br/>width-number	default-250
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Pager:function(){
 /// <signature>
 /// <summary>Constructor of ej.Pager</summary>
 /// </signature>
}
});
ej.Pager=(function(){
var original=ej.Pager
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

gotoPage:function(pageIndex){
/// <signature>
/// <summary>
/// Send a paging request to specified page through the pager control.
/// </summary>
/// <param name="pageIndex"	type="number">Specifies the index to be navigated</param>
/// </signature>
},
goToFirstPage:function(){
/// <signature>
/// <summary>
/// goToFirstPage() helps to navigate to the first page of the pager.
/// </summary>
},
goToNextPage:function(){
/// <signature>
/// <summary>
/// goToNextPage() helps to navigate to the next page to the current page of the pager.
/// </summary>
},
goToLastPage:function(){
/// <signature>
/// <summary>
/// goToLastPage() helps to navigate to the Last page of the pager.
/// </summary>
},
goToPrevPage:function(){
/// <signature>
/// <summary>
/// goToPrevPage() helps to navigate to the previous page to the current page of the pager.
/// </summary>
},
refreshPager:function(){
/// <signature>
/// <summary>
/// refreshPager() helps to refresh the model value of pager control.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPager=function(){
this.data("ejPager",new	ej.Pager());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPager :function (options) {
/// <signature>
/// <summary><br/>
///Custom Design for HTML Pager control.<br/><br/>
///Gets or sets a value that indicates whether to display the custom text message in Pager.
///<br/>customText-string	default-
///<br/><br/>
///Gets or sets a value that indicates whether to define which page to display currently in pager.
///<br/>currentPage-number	default-1
///<br/><br/>
///Sets the root CSS class, which can be used for customization of pager control.
///<br/>cssClass-string	default-
///<br/><br/>
///Enable or disable the Pager control.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Gets or sets a value that indicates whether to display the external Message in Pager.
///<br/>enableExternalMessage-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to pass the current page information as a query string along with the URL while navigating to other page.
///<br/>enableQueryString-boolean	default-false
///<br/><br/>
///Align content in the pager control from right to left by setting the property as true.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to display the external Message in Pager.
///<br/>externalMessage-string	default-
///<br/><br/>
///Enables or disables responsive support for the Pager control items on window resize.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Gets or sets a value that indicates whether to customizing the user interface (UI) as locale-specific in order to display regional data i.e. in a language and culture specific to a particular country or region.
///<br/>locale-string	default-en-US
///<br/><br/>
///Gets or sets a value that indicates whether to define the number of pages displayed in the pager for navigation.
///<br/>pageCount-number	default-10
///<br/><br/>
///Gets or sets a value that indicates whether to define the number of records displayed per page.
///<br/>pageSize-number	default-12
///<br/><br/>
///It allows to have multiple choices of pageSize values for Pager control. The "pageSize" API value of the pager will be updated depending upon the value being selected from the dropdown.
///<br/>pageSizeList-Array&lt;any&gt;	default-null
///<br/><br/>
///Indicates the pageSizeMessage to be displayed in Pager when pageSizeList API is defined.
///<br/>pageSizeMessage-String	default-
///<br/><br/>
///Template option allows to customize UI appearance of the ejPager by defining their own page layout.
///<br/>template-string	default-null
///<br/><br/>
///Get or sets a value of total number of pages in the pager. The totalPages value is calculated based on page size and total records.
///<br/>totalPages-number	default-null
///<br/><br/>
///Get the value of total number of records which is bound to a data item.
///<br/>totalRecordsCount-number	default-null
///<br/><br/>
///Shows or hides the current page information in pager footer.
///<br/>showPageInfo-boolean	default-true
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
PdfViewer:function(){
 /// <signature>
 /// <summary>Constructor of ej.PdfViewer</summary>
 /// </signature>
}
});
ej.PdfViewer=(function(){
var original=ej.PdfViewer
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

load:function(fileName){
/// <signature>
/// <summary>
/// Loads the document with the filename and displays it in PDF viewer.
/// </summary>
/// <param name="fileName"	type="string">File name to be loaded</param>
/// </signature>
},
showToolbar:function(show){
/// <signature>
/// <summary>
/// Shows/hides the toolbar in the PDF viewer.
/// </summary>
/// <param name="show"	type="boolean">shows/hides the toolbar</param>
/// </signature>
},
print:function(){
/// <signature>
/// <summary>
/// Prints the PDF document.
/// </summary>
},
abortPrint:function(){
/// <signature>
/// <summary>
/// Abort the printing function and restores the PDF viewer.
/// </summary>
},
abortDownload:function(){
/// <signature>
/// <summary>
/// Aborts the download operation.
/// </summary>
},
showPrintTools:function(show){
/// <signature>
/// <summary>
/// Shows/hides the print icon in the toolbar.
/// </summary>
/// <param name="show"	type="boolean">shows/hides print button in the toolbar</param>
/// </signature>
},
download:function(){
/// <signature>
/// <summary>
/// Downloads the PDF document being loaded in the ejPdfViewer control.
/// </summary>
},
showDownloadTool:function(show){
/// <signature>
/// <summary>
/// Shows/hides the download tool in the toolbar.
/// </summary>
/// <param name="show"	type="boolean">shows/hides download button in the toolbar</param>
/// </signature>
},
showPageNavigationTools:function(show){
/// <signature>
/// <summary>
/// Shows/hides the page navigation tools in the toolbar
/// </summary>
/// <param name="show"	type="boolean">shows/hides navigation tools in the toolbar</param>
/// </signature>
},
showTextMarkupAnnotationTools:function(show){
/// <signature>
/// <summary>
/// Shows/hides the text markup annotation tools in the toolbar.
/// </summary>
/// <param name="show"	type="boolean">shows/hides text markup annotation tools in the toolbar</param>
/// </signature>
},
showSignatureTool:function(show){
/// <signature>
/// <summary>
/// Shows/hides the signature tool in the toolbar.
/// </summary>
/// <param name="show"	type="boolean">shows/hides signature tool in the toolbar</param>
/// </signature>
},
showSelectionTool:function(show){
/// <signature>
/// <summary>
/// Shows/hides the selection tool in the toolbar.
/// </summary>
/// <param name="show"	type="boolean">shows/hides selection tool in the toolbar</param>
/// </signature>
},
goToPage:function(pageNumber){
/// <signature>
/// <summary>
/// Navigates to the specific page in the PDF document. If the page is not available for the given pageNumber, PDF viewer retains the existing page in view.
/// </summary>
/// <param name="pageNumber"	type="number">navigates to the page number in the PDF document</param>
/// </signature>
},
goToLastPage:function(){
/// <signature>
/// <summary>
/// Navigates to the last page of the PDF document.
/// </summary>
},
goToFirstPage:function(){
/// <signature>
/// <summary>
/// Navigates to the first page of PDF document.
/// </summary>
},
goToNextPage:function(){
/// <signature>
/// <summary>
/// Navigates to the next page of the PDF document.
/// </summary>
},
goToPreviousPage:function(){
/// <signature>
/// <summary>
/// Navigates to the previous page of the PDF document.
/// </summary>
},
showMagnificationTools:function(show){
/// <signature>
/// <summary>
/// Shows/hides the zoom tools in the toolbar.
/// </summary>
/// <param name="show"	type="boolean">shows/hides zoom tools in the toolbar</param>
/// </signature>
},
showTextSearchTool:function(show){
/// <signature>
/// <summary>
/// Shows/hides the search tool in the toolbar.
/// </summary>
/// <param name="show"	type="boolean">shows/hides search tool in the toolbar</param>
/// </signature>
},
fitToPage:function(){
/// <signature>
/// <summary>
/// Scales the page to fit the page in the container in the control.
/// </summary>
},
fitToWidth:function(){
/// <signature>
/// <summary>
/// Scales the page to fit the page width to the width of the container in the control.
/// </summary>
},
zoomIn:function(){
/// <signature>
/// <summary>
/// Magnifies the page to the next value in the zoom drop down list.
/// </summary>
},
zoomOut:function(){
/// <signature>
/// <summary>
/// Shrinks the page to the previous value in the magnification in the drop down list.
/// </summary>
},
updateViewerSize:function(){
/// <signature>
/// <summary>
/// Resize the viewer based on the parent element height.
/// </summary>
},
zoomTo:function(zoomValue){
/// <signature>
/// <summary>
/// Scales the page to the specified percentage ranging from 50 to 400. If the given zoomValue is less than 50 or greater than 400; the PDF viewer scales the page to 50 and 400 respectively.
/// </summary>
/// <param name="zoomValue"	type="number">zoom value for scaling the pages in the PDF Viewer</param>
/// </signature>
},
searchText:function(targetText){
/// <signature>
/// <summary>
/// Searches the target text in the PDF document and highlights the occurrences in the pages.
/// </summary>
/// <param name="targetText"	type="string">The text to be searched in the pages in the PDF viewer.</param>
/// </signature>
},
searchNext:function(){
/// <signature>
/// <summary>
/// Searches the next occurrence of the searched text from the current occurrence in the PDF viewer control.
/// </summary>
},
searchPrevious:function(){
/// <signature>
/// <summary>
/// Searches the previous occurrence of the searched text from the current occurrence in the PDF viewer control.
/// </summary>
},
setJSONData:function(jsonData){
/// <signature>
/// <summary>
/// Set the JSON data that are formed for rendering the document content in PDF viewer.
/// </summary>
/// <param name="jsonData"	type="any">Set the JSON data that are formed for rendering the document content.</param>
/// </signature>
},
matchCase:function(enableMatchCase){
/// <signature>
/// <summary>
/// Searches the target text with its casing.
/// </summary>
/// <param name="enableMatchCase"	type="boolean">Specifies whether the text search must be performed with match case or not.</param>
/// </signature>
},
cancelSearchText:function(){
/// <signature>
/// <summary>
/// Cancels the text search and removes the highlighted occurrences from the PDF viewer.
/// </summary>
},
addAnnotation:function(annotationType){
/// <signature>
/// <summary>
/// Adds annotations to the PDF document.
/// </summary>
/// <param name="annotationType"	type="ej.PdfViewer.AnnotationType">type of the annotation to be added in the PDF document.</param>
/// </signature>
},
undo:function(){
/// <signature>
/// <summary>
/// Performs undo function for the included annotations in the PDF document.
/// </summary>
},
redo:function(){
/// <signature>
/// <summary>
/// Performs redo function for the included annotations in the PDF document.
/// </summary>
},
unload:function(){
/// <signature>
/// <summary>
/// Unloads the PDF document being displayed in the PDF viewer.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPdfViewer=function(){
this.data("ejPdfViewer",new	ej.PdfViewer());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPdfViewer :function (options) {
/// <signature>
/// <summary><br/>
///PDF viewer JS is visualization component to view PDF documents. It is powered by HTML5/JavaScript and provides various control customizations.<br/><br/>
///Specifies the locale information of the PDF viewer.
///<br/>locale-string	default-
///<br/><br/>
///Specifies the toolbar settings.
///<br/>toolbarSettings-ToolbarSettings	default-
///<br/><br/>
///Shows or hides the tooltip of the toolbar items.
///<br/>showToolTip-boolean	default-
///<br/><br/>
///Shows or hides the grouped items in the toolbar with the help of enum ej.PdfViewer.ToolbarItems
///<br/>toolbarItem-ej.PdfViewer.ToolbarItems|string	default-
///<br/><br/>
///Specifies the name of the action method in the server.
///<br/>serverActionSettings-ServerActionSettings	default-
///<br/><br/>
///Specifies the name of the action method used for loading the PDF document.
///<br/>load-string	default-
///<br/><br/>
///Specifies the name of the action method used for uploading the PDF document to the PDF viewer control.
///<br/>fileUpload-string	default-
///<br/><br/>
///Specifies the name of the action method used for printing the PDF document in the PDF viewer control.
///<br/>print-string	default-
///<br/><br/>
///Specifies the name of the action method used for downloading the PDF document from the PDF viewer control.
///<br/>download-string	default-
///<br/><br/>
///Sets the PDF Web API service URL
///<br/>serviceUrl-string	default-
///<br/><br/>
///Sets the PDF document path for initial loading.
///<br/>documentPath-string	default-
///<br/><br/>
///Enables or disables the text markup annotations.
///<br/>enableTextMarkupAnnotations-boolean	default-
///<br/><br/>
///Enables or disables the highlight annotation.
///<br/>enableHighlightAnnotation-boolean	default-
///<br/><br/>
///Enables or disables the underline annotation.
///<br/>enableUnderlineAnnotation-boolean	default-
///<br/><br/>
///Enables or disables the strikethrough annotation.
///<br/>enableStrikethroughAnnotation-boolean	default-
///<br/><br/>
///Enables or disables the adding of handwritten signature over the PDF document.
///<br/>enableSignature-boolean	default-
///<br/><br/>
///Gets/sets the settings of the strikethrough annotation.
///<br/>strikethroughSettings-StrikethroughSettings	default-
///<br/><br/>
///Gets/sets the color of the strikethrough annotation.
///<br/>color-string	default-
///<br/><br/>
///Gets/sets the author of the strikethrough annotation.
///<br/>author-string	default-
///<br/><br/>
///Gets/sets the opacity of the strikethrough annotation.
///<br/>opacity-number	default-
///<br/><br/>
///Gets/sets the subject of the strikethrough annotation.
///<br/>subject-string	default-
///<br/><br/>
///Gets/sets the modified Date of the strikethrough annotation.
///<br/>modifiedDate-string	default-
///<br/><br/>
///Gets/sets the locked property of the strikethrough annotation.
///<br/>isLocked-boolean	default-
///<br/><br/>
///Gets/sets the settings of the underline annotation.
///<br/>underlineSettings-UnderlineSettings	default-
///<br/><br/>
///Gets/sets the color of the underline annotation.
///<br/>color-string	default-
///<br/><br/>
///Gets/sets the author of the underline annotation.
///<br/>author-string	default-
///<br/><br/>
///Gets/sets the opacity of the underline annotation.
///<br/>opacity-number	default-
///<br/><br/>
///Gets/sets the subject of the underline annotation.
///<br/>subject-string	default-
///<br/><br/>
///Gets/sets the modified Date of the underline annotation.
///<br/>modifiedDate-string	default-
///<br/><br/>
///Gets/sets the locked property of the underline annotation.
///<br/>isLocked-boolean	default-
///<br/><br/>
///Gets/sets the settings of the highlight annotation.
///<br/>highlightSettings-HighlightSettings	default-
///<br/><br/>
///Gets/sets the color of the highlight  annotation.
///<br/>color-string	default-
///<br/><br/>
///Gets/sets the author of the highlight annotation.
///<br/>author-string	default-
///<br/><br/>
///Gets/sets the opacity of the highlight annotation.
///<br/>opacity-number	default-
///<br/><br/>
///Gets/sets the subject of the highlight annotation.
///<br/>subject-string	default-
///<br/><br/>
///Gets/sets the modified Date of the highlight annotation.
///<br/>modifiedDate-string	default-
///<br/><br/>
///Gets/sets the locked property of the highlight annotation.
///<br/>isLocked-boolean	default-
///<br/><br/>
///Gets/sets the settings of the handwritten signature.
///<br/>signatureSettings-SignatureSettings	default-
///<br/><br/>
///Gets/sets the color of the handwritten signature.
///<br/>color-string	default-
///<br/><br/>
///Gets/sets the opacity of the handwritten signature.
///<br/>opacity-number	default-
///<br/><br/>
///Enables/ disables the text selection context menu.
///<br/>textSelectionContextMenu-TextSelectionContextMenu	default-
///<br/><br/>
///Enables/ disables the text selection context menu.
///<br/>isEnable-boolean	default-
///<br/><br/>
///Enables/disables the copy menu in the text selection context menu.
///<br/>isCopyEnable-boolean	default-
///<br/><br/>
///Enables/disables the search menu in the text selection context menu.
///<br/>isSearchEnable-boolean	default-
///<br/><br/>
///Enables/disables the highlight annotation menu in the text selection context menu.
///<br/>isHighlightEnable-boolean	default-
///<br/><br/>
///Enables/disables the strikeout annotation menu in the text selection context menu.
///<br/>isStrikeoutEnable-boolean	default-
///<br/><br/>
///Enables/disables the annotation context menu.
///<br/>annotationContextMenu-AnnotationContextMenu	default-
///<br/><br/>
///Enables/disables the annotation context menu.
///<br/>isEnable-boolean	default-
///<br/><br/>
///Enables/disables the popup menu in the annotation context menu.
///<br/>isPopupEnable-boolean	default-
///<br/><br/>
///Enables/disables the delete menu in the annotation context menu.
///<br/>isDeleteEnable-boolean	default-
///<br/><br/>
///Enables/disables the properties menu in the annotation context menu.
///<br/>isPropertiesEnable-boolean	default-
///<br/><br/>
///Specifies the type of the annotations.
///<br/>annotationType-ej.PdfViewer.AnnotationType|string	default-
///<br/><br/>
///Gets the total number of pages in PDF document.
///<br/>pageCount-number	default-
///<br/><br/>
///Gets the number of the page being displayed in the PDF viewer.
///<br/>currentPageNumber-number	default-
///<br/><br/>
///Gets the current zoom percentage of the PDF document in viewer.
///<br/>zoomPercentage-number	default-
///<br/><br/>
///Specifies the location of the supporting PDF service
///<br/>pdfService-ej.PdfViewer.PdfService|string	default-
///<br/><br/>
///Specifies the viewer interaction mode.
///<br/>interactionMode-ej.PdfViewer.InteractionMode|string	default-
///<br/><br/>
///Gets or sets the buffering mode of the PDF viewer control when allowClientBuffering is set to true.
///<br/>bufferingMode-ej.PdfViewer.BufferingMode|string	default-
///<br/><br/>
///Specifies the open state of the hyperlink in the PDF document.
///<br/>hyperlinkOpenState-ej.PdfViewer.LinkTarget|string	default-
///<br/><br/>
///Enables or disables the hyperlinks in PDF document.
///<br/>enableHyperlink-boolean	default-
///<br/><br/>
///Enables or disables the text selection in PDF document.
///<br/>enableTextSelection-boolean	default-
///<br/><br/>
///Enables or disables the responsiveness of the PDF viewer control during the window resize.
///<br/>isResponsive-boolean	default-
///<br/><br/>
///Checks whether the PDF document is edited.
///<br/>isDocumentEdited-boolean	default-
///<br/><br/>
///Enables or disables the buffering of the PDF pages in the client side.
///<br/>allowClientBuffering-boolean	default-
///<br/><br/>
///Gets the name of the PDF document which loaded in the ejPdfViewer control for downloading.
///<br/>fileName-string	default-
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
PivotChart:function(){
 /// <signature>
 /// <summary>Constructor of ej.PivotChart</summary>
 /// </signature>
}
});
ej.PivotChart=(function(){
var original=ej.PivotChart
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

doAjaxPost:function(){
/// <signature>
/// <summary>
/// Posts an asynchronous HTTP (AJAX) request.
/// </summary>
},
doPostBack:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (FullPost) submit.
/// </summary>
},
exportPivotChart:function(){
/// <signature>
/// <summary>
/// Exports the pivot chart to the format that is specified in the parameter.
/// </summary>
},
renderChartFromJSON:function(){
/// <signature>
/// <summary>
/// This function renders the pivot chart control with the JSON formatted data source.
/// </summary>
},
renderControlSuccess:function(){
/// <signature>
/// <summary>
/// This function receives the update from the service-end, which will be utilized for rendering the widget.
/// </summary>
},
getOlapReport:function(){
/// <signature>
/// <summary>
/// Returns the OlapReport string that is maintained along with the axis elements information.
/// </summary>
},
setOlapReport:function(){
/// <signature>
/// <summary>
/// Sets the OlapReport string along with the axis information and maintains it in a property.
/// </summary>
},
getJSONRecords:function(){
/// <signature>
/// <summary>
/// Returns the JSON records that are formed to render the control.
/// </summary>
},
setJSONRecords:function(){
/// <signature>
/// <summary>
/// Sets the JSON records to render the control.
/// </summary>
},
getPivotEngine:function(){
/// <signature>
/// <summary>
/// Returns the PivotEngine that is formed to render the control.
/// </summary>
},
setPivotEngine:function(){
/// <signature>
/// <summary>
/// Sets the PivotEngine that is required to render the control.
/// </summary>
},
refreshControl:function(){
/// <signature>
/// <summary>
/// Re-renders the control with the datasource at instant.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// This function destroys the pivot chart widget associated events that are bound using &quot;this._on&quot; and brings the control to pre-init state.
/// </summary>
},
generateJSON:function(){
/// <signature>
/// <summary>
/// Renders the control with the pivot engine that is obtained from the OLAP cube.
/// </summary>
},
refreshPagedPivotChart:function(){
/// <signature>
/// <summary>
/// Navigates to the specified page number in the specified axis.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPivotChart=function(){
this.data("ejPivotChart",new	ej.PivotChart());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPivotChart :function (options) {
/// <signature>
/// <summary><br/>
///The pivot chart is a lightweight control that reads OLAP and relational information and visualizes it in a graphical format with the ability to drill up and down.<br/><br/>
///Sets the mode for the pivot chart widget to bind either the OLAP or relational datasource.
///<br/>analysisMode-ej.Pivot.AnalysisMode|string	default-ej.Pivot.AnalysisMode.Pivot
///<br/><br/>
///Specifies the CSS class to the pivot chart for achieving the custom theme.
///<br/>cssClass-string	default-&#226;€œ&#226;€
///<br/><br/>
///Options for enabling the zooming feature of the pivot chart.
///<br/>zooming-Zooming	default-{}
///<br/><br/>
///Enables or disables the horizontal scrollbar.
///<br/>enableScrollbar-boolean	default-false
///<br/><br/>
///Options available to configure the properties of entire series. You can also override the options for specific series by using the series collection.
///<br/>commonSeriesOptions-CommonSeriesOptions	default-{}
///<br/><br/>
///Allows you to set the specific chart type for the pivot chart widget.
///<br/>type-ej.PivotChart.ChartTypes|string	default-ej.PivotChart.ChartTypes.Column
///<br/><br/>
///Initializes the datasource for the pivot chart widget, when it functions completely on the client-side.
///<br/>dataSource-DataSource	default-{}
///<br/><br/>
///Contains the respective cube name from the OLAP database as string type.
///<br/>cube-string	default-&#226;€œ&#226;€
///<br/><br/>
///To set the datasource name to fetch the data from that.
///<br/>sourceInfo-string	default-&#226;€œ&#226;€
///<br/><br/>
///Sets the provider name for the pivot chart to identify whether the provider is SSAS or Mondrian.
///<br/>providerName-string	default-ssas
///<br/><br/>
///Provides the raw datasource for the pivot chart.
///<br/>data-any	default-null
///<br/><br/>
///In connection with the OLAP database, this property contains the database name as string to fetch the data from the given connection string.
///<br/>catalog-string	default-&#226;€œ&#226;€
///<br/><br/>
///Lists out the items to be displayed as series of the pivot chart.
///<br/>columns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for the item.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Allows you to indicate whether the added item is a named set or not.
///<br/>isNamedSets-boolean	default-false
///<br/><br/>
///Allows you to set the sorting order of field members.
///<br/>sortOrder-ej.PivotAnalysis.SortOrder|string	default-ej.PivotAnalysis.SortOrder.Ascending
///<br/><br/>
///Applies filter to field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items to be displayed as segments of the pivot chart.
///<br/>rows-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for the item.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Allows you to indicate whether the added item is a named set or not.
///<br/>isNamedSets-boolean	default-false
///<br/><br/>
///Allows you to set the sorting order of field members.
///<br/>sortOrder-ej.PivotAnalysis.SortOrder|string	default-ej.PivotAnalysis.SortOrder.Ascending
///<br/><br/>
///Applies filter to field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items support calculation in the pivot chart.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name for the relational datasource.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for the item of the relational datasource.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Holds the list of unique names of measures to bind them from the OLAP cube.
///<br/>measures-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the measure from the OLAP datasource by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the axis name to place the measures items.
///<br/>axis-string	default-rows
///<br/><br/>
///Indicates whether the field is a calculated field with the relational datasource or not.
///<br/>isCalculatedField-boolean	default-false
///<br/><br/>
///Allows you to set the formula to calculate the values for calculated members in the relational datasource.
///<br/>formula-string	default-
///<br/><br/>
///Lists out the items that supports filtering of values without displaying the members in UI of the pivot chart.
///<br/>filters-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Applies filter to field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Object is utilized to pass additional information between the client-end and the service-end while operating the control in the server mode.
///<br/>customObject-any	default-{}
///<br/><br/>
///Allows you to enable the 3D view of the pivot chart.
///<br/>enable3D-boolean	default-false
///<br/><br/>
///Allows you to view the pivot chart from right to left.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Allows you to render the complete pivot chart on drill operation, when expanding and collapsing members are shown in multi-level labels.
///<br/>enableMultiLevelLabels-boolean	default-false
///<br/><br/>
///Allows you to enable the responsiveness of pivot chart in the browser layout.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///You can customize the legend items and their labels.
///<br/>legend-any	default-{}
///<br/><br/>
///Allows you to set the localized language for the widget.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the mode for the pivot chart widget to bind the data source either in the server-side or client-side.
///<br/>operationalMode-ej.Pivot.OperationalMode|string	default-ej.Pivot.OperationalMode.ClientMode
///<br/><br/>
///To override x axis for particular series, create an axis object by providing unique name by using name property and add it to axes array.
///<br/>axes-Array&lt;any&gt;	default-[]
///<br/><br/>
///This is a horizontal axis that contains options to configure the axis and it is the primary x-axis for all series in the series array. To override x-axis for particular series, create an axis object by providing a unique name by using the name property and add it to the axes array. Then, assign the name to the seriesâ€™s xAxisName property to link both the axis and the series.
///<br/>primaryXAxis-any	default-{}
///<br/><br/>
///This is a vertical axis that contains options to configure the axis. This is the primary y-axis for all the series in the series array. To override y-axis for particular series, create an axis object by providing a unique name by using the name property and add it to the axes array. Then, assign the name to the seriesâ€™s yAxisName property to link both the axis and the series.
///<br/>primaryYAxis-any	default-{}
///<br/><br/>
///Allows you to rotate the angle of pivot chart in 3D view.
///<br/>rotation-number	default-0
///<br/><br/>
///Allows you to enable/disable context menu options in the pivot chart.
///<br/>enableContextMenu-boolean	default-false
///<br/><br/>
///Allows you to set the custom name for methods at service-end, when you are communicating on AJAX post.
///<br/>serviceMethodSettings-ServiceMethodSettings	default-{}
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for drilling up/down in the pivot chart.
///<br/>drillDown-string	default-DrillChart
///<br/><br/>
///Allows you to set the custom name for the service method which is responsible for exporting the pivot chart.
///<br/>exportPivotChart-string	default-Export
///<br/><br/>
///Allows you to set the custom name for the service method which is responsible for initializing the pivot chart.
///<br/>initialize-string	default-InitializeChart
///<br/><br/>
///Allows you to set the custom name for the service method which is responsible for navigating between pages in the paged pivot chart.
///<br/>paging-string	default-Paging
///<br/><br/>
///Options to customize the size of the pivot chart control.
///<br/>size-any	default-{}
///<br/><br/>
///Options for customizing the title of PivotChart.
///<br/>title-Title	default-
///<br/><br/>
///Text to be displayed in PivotChart title.
///<br/>text-string	default-
///<br/><br/>
///Connects the service by using the specified URL for any server updates while operating the control in the server mode.
///<br/>url-string	default-&#226;€œ&#226;€
///<br/><br/>
///Allows you to enable "withCredentials" property inside XMLHttpRequest object for CORS(Cross-Origin Resource Sharing) request.
///<br/>enableXHRCredentials-boolean	default-false
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
PivotClient:function(){
 /// <signature>
 /// <summary>Constructor of ej.PivotClient</summary>
 /// </signature>
}
});
ej.PivotClient=(function(){
var original=ej.PivotClient
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

doAjaxPost:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (AJAX) request.
/// </summary>
},
doPostBack:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (full post) submit.
/// </summary>
},
refreshPagedPivotClient:function(){
/// <signature>
/// <summary>
/// Navigates to a specified page in the specified axis.
/// </summary>
},
refreshPagedPivotClientSuccess:function(){
/// <signature>
/// <summary>
/// Updates the pivot client component with the JSON data that is fetched from the service while navigating between the pages.
/// </summary>
},
generateJSON:function(){
/// <signature>
/// <summary>
/// Renders the pivot chart and the pivot grid with the provided JSON data.
/// </summary>
},
refreshControl:function(){
/// <signature>
/// <summary>
/// Re-renders the control with the report at that instant.
/// </summary>
},
getActiveTab:function(){
/// <signature>
/// <summary>
/// Returns the control tab string that displays currently in the pivot client.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// This function destroys all events of the pivot client widget bound using &quot;this._on&quot; and bring the control to pre-init state.
/// </summary>
},
getOlapReport:function(){
/// <signature>
/// <summary>
/// Returns the OLAP report string that is maintained along with the axis elements information.
/// </summary>
},
setOlapReport:function(){
/// <signature>
/// <summary>
/// Sets the OLAP report string along with the axis information and maintains it in a property.
/// </summary>
},
getJSONRecords:function(){
/// <signature>
/// <summary>
/// Returns the formed JSON records to render the control.
/// </summary>
},
setJSONRecords:function(){
/// <signature>
/// <summary>
/// Sets the formed JSON records to render the control to a property.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPivotClient=function(){
this.data("ejPivotClient",new	ej.PivotClient());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPivotClient :function (options) {
/// <signature>
/// <summary><br/>
///The pivot client is an ad hoc analysis tool that can be easily bound to any OLAP and relational datasources to provide a visual presentation of the information retrieved from the database.<br/><br/>
///Sets the mode for the pivot client widget for binding the OLAP or relational data sources.
///<br/>analysisMode-ej.Pivot.AnalysisMode|string	default-ej.Pivot.AnalysisMode.Pivot
///<br/><br/>
///Allows you to set the specific chart type for the pivot chart in the pivot client widget.
///<br/>chartType-ej.PivotChart.ChartTypes|string	default-ej.PivotChart.ChartTypes.Column
///<br/><br/>
///Allows you to set the content for exporting the pivot client widget.
///<br/>clientExportMode-ej.PivotClient.ClientExportMode|string	default-ej.PivotClient.ClientExportMode.ChartAndGrid
///<br/><br/>
///Specifies the CSS class to the pivot client for achieving the custom theme.
///<br/>cssClass-string	default-&#226;€œ&#226;€
///<br/><br/>
///An object is utilized to pass the additional information between the client-end and the service-end when the control functions are present in the server-mode.
///<br/>customObject-any	default-{}
///<br/><br/>
///Initializes the data source for the pivot client widget, when it functions completely on the client-side.
///<br/>dataSource-DataSource	default-{}
///<br/><br/>
///Lists out the items to be arranged in the columns section of the pivot client.
///<br/>columns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for an item.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Allows you to filter the report by default using the advanced filtering (e.g., Microsoft Excel) option for the OLAP data source in the client-mode.
///<br/>advancedFilter-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to provide a level unique name to perform the advanced filtering.
///<br/>name-string	default-
///<br/><br/>
///Allows you to set the operator to perform label filtering.
///<br/>labelFilterOperator-string	default-none
///<br/><br/>
///Allows you to set the operator to perform value filtering.
///<br/>valueFilterOperator-string	default-none
///<br/><br/>
///Allows you to set the filtering type while performing the advanced filtering.
///<br/>advancedFilterType-string	default-
///<br/><br/>
///In value filtering, this property contains the measure name to which the filter is applied.
///<br/>measure-string	default-
///<br/><br/>
///Allows you to hold the filter operand values in the advanced filtering.
///<br/>values-Array&lt;any&gt;	default-
///<br/><br/>
///Allows you to indicate whether the added item is a named set or not.
///<br/>isNamedSets-boolean	default-false
///<br/><br/>
///Shows/hides the sub-total of the field in the pivot grid.
///<br/>showSubTotal-boolean	default-true
///<br/><br/>
///Allows to set the format for the column headers.
///<br/>format-string	default-
///<br/><br/>
///This property is set to display the formatted values with format types in the pivot grid.
///<br/>formatString-string	default-
///<br/><br/>
///Allows you to set the custom theme for the column headers.
///<br/>cssClass-string	default-
///<br/><br/>
///Allows you to set the sorting order of members of the field.
///<br/>sortOrder-ej.PivotAnalysis.SortOrder|string	default-ej.PivotAnalysis.SortOrder.Ascending
///<br/><br/>
///Contains the list of members need to be drilled down by default in the field.
///<br/>drilledItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///Applies the filter to field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items to be arranged in the rows section of the pivot client.
///<br/>rows-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for an item.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Allows you to filter the report by using the advanced filtering (e.g., Microsoft Excel) option for the OLAP data source in the client-mode.
///<br/>advancedFilter-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to provide a level unique name to perform the advanced filtering.
///<br/>name-string	default-
///<br/><br/>
///Allows you to set the operator to perform the label filtering.
///<br/>labelFilterOperator-string	default-none
///<br/><br/>
///Allows you to set the operator to perform the value filtering.
///<br/>valueFilterOperator-string	default-none
///<br/><br/>
///Allows you to set the filtering type while performing the advanced filtering.
///<br/>advancedFilterType-string	default-
///<br/><br/>
///In value filtering, this property contains the measure name to which the filter is applied.
///<br/>measure-string	default-
///<br/><br/>
///Allows you to hold the filter operand values in the advanced filtering.
///<br/>values-Array&lt;any&gt;	default-
///<br/><br/>
///Allows you to indicate whether the added item is a named set or not.
///<br/>isNamedSets-boolean	default-false
///<br/><br/>
///Shows/hides the sub-total of the field.
///<br/>showSubTotal-boolean	default-true
///<br/><br/>
///Allows to set the format for row headers.
///<br/>format-string	default-
///<br/><br/>
///This property is set to display the formatted values with format types in the pivot grid.
///<br/>formatString-string	default-
///<br/><br/>
///Allows to set the custom theme for row headers.
///<br/>cssClass-string	default-
///<br/><br/>
///Allows you to set the sorting order for the field members.
///<br/>sortOrder-ej.PivotAnalysis.SortOrder|string	default-ej.PivotAnalysis.SortOrder.Ascending
///<br/><br/>
///Contains the list of members need to be drilled down by default in the field.
///<br/>drilledItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///Applies the filter to the field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items which supports calculation in the pivot client.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name for the relational data source.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for an item for the relational data source.
///<br/>fieldCaption-string	default-
///<br/><br/>
///This holds the list of unique names of measures to bind them from the OLAP cube.
///<br/>measures-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the measure from the OLAP data source by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows to set the axis name to place the measures items.
///<br/>axis-string	default-rows
///<br/><br/>
///Indicates whether the field is a calculated field or not with the relational data source.
///<br/>isCalculatedField-boolean	default-false
///<br/><br/>
///Allows to set the type of the pivot grid summary calculation for the value field with the relational data source.
///<br/>summaryType-ej.PivotAnalysis.SummaryType|string	default-ej.PivotAnalysis.SummaryType.Sum
///<br/><br/>
///Allows to set the format of the values.
///<br/>format-string	default-
///<br/><br/>
///This property is set to display the formatted values with format types in the pivot grid.
///<br/>formatString-string	default-
///<br/><br/>
///Allows to set the custom theme for the values.
///<br/>cssClass-string	default-
///<br/><br/>
///Allows to set the formula for calculation of members values in the relational data source.
///<br/>formula-string	default-
///<br/><br/>
///Lists out the items which supports filtering of values without displaying the members in UI of the pivot client.
///<br/>filters-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display name for an item.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Applies filter to the field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Contains the respective cube name from the OLAP database as string type.
///<br/>cube-string	default-&#226;€œ&#226;€
///<br/><br/>
///Allows to set the data source name to fetch the data from that.
///<br/>sourceInfo-string	default-&#226;€œ&#226;€
///<br/><br/>
///Sets the provider name for the pivot client to identify whether the provider is SSAS or Mondrian.
///<br/>providerName-string	default-ssas
///<br/><br/>
///Provides the raw data source for the pivot client.
///<br/>data-any	default-null
///<br/><br/>
///In connection with an OLAP database, this property contains the database name as string to fetch the data from the given connection string.
///<br/>catalog-string	default-&#226;€œ&#226;€
///<br/><br/>
///Allows you to filter the members (by its name and values) through the advanced filtering (e.g., Microsoft Excel) option in the client-mode.
///<br/>enableAdvancedFilter-boolean	default-false
///<br/><br/>
///Sets a name to the report bound to the control.
///<br/>reportName-string	default-
///<br/><br/>
///Allows to set the page size and current page number for each axis on applying the paging.
///<br/>pagerOptions-any	default-{}
///<br/><br/>
///Allows to set the number of categorical columns to be displayed in each page on applying the paging.
///<br/>categoricalPageSize-number	default-0
///<br/><br/>
///Allows to set the number of series rows to be displayed in each page on applying the paging.
///<br/>seriesPageSize-number	default-0
///<br/><br/>
///Allows to set the page number in the categorical axis to be loaded by default.
///<br/>categoricalCurrentPage-number	default-1
///<br/><br/>
///Allows to set the page number in the series axis to be loaded by default.
///<br/>seriesCurrentPage-number	default-1
///<br/><br/>
///Enables the drill-through feature which retrieves the raw items that are used to create a specific cell in the pivot grid.
///<br/>enableDrillThrough-boolean	default-false
///<br/><br/>
///Allows you to customize the layout and appearance of the widget.
///<br/>displaySettings-DisplaySettings	default-{}
///<br/><br/>
///Allows you to customize the display of the pivot chart and pivot grid widgets in the tabs or tiles.
///<br/>controlPlacement-ej.PivotClient.ControlPlacement|string	default-ej.PivotClient.ControlPlacement.Tab
///<br/><br/>
///Allows you to set either the chart or grid as the start-up widget.
///<br/>defaultView-ej.PivotClient.DefaultView|string	default-ej.PivotClient.DefaultView.Grid
///<br/><br/>
///Allows you to switch to full screen view of the pivot chart and the pivot grid from default view in the pivot client.
///<br/>enableFullScreen-boolean	default-false
///<br/><br/>
///Enables an option to enhance the space for the pivot grid and pivot chart by hiding the cube browser and the axis element builder.
///<br/>enableTogglePanel-boolean	default-false
///<br/><br/>
///Sets the display mode (only chart/only grid/both) in the pivot client.
///<br/>mode-ej.PivotClient.DisplayMode|string	default-ej.PivotClient.DisplayMode.ChartAndGrid
///<br/><br/>
///Allows you to set the visibility of icons in the toolbar panel.
///<br/>toolbarIconSettings-ToolbarIconSettings	default-{}
///<br/><br/>
///Allows you to set the visibility of Add Report icon in the toolbar panel.
///<br/>enableAddReport-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of New Report icon in the toolbar panel.
///<br/>enableNewReport-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of Rename Report icon in the toolbar panel.
///<br/>enableRenameReport-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of DB Manipulation icon in the toolbar panel.
///<br/>enableDBManipulation-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of Word Export icon in the toolbar panel.
///<br/>enableWordExport-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of Excel Export icon in the toolbar panel.
///<br/>enableExcelExport-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of PDF Export icon in the toolbar panel.
///<br/>enablePdfExport-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of MDX Query icon in the toolbar panel.
///<br/>enableMDXQuery-boolean	default-true
///<br/><br/>
///Allows to set the visibility of Defer Update icon in the toolbar panel.
///<br/>enableDeferUpdate-boolean	default-false
///<br/><br/>
///Allows to set the visibility of Full Screen icon in the toolbar panel.
///<br/>enableFullScreen-boolean	default-false
///<br/><br/>
///Allows you to set the visibility of Sort/Filter Column icon in the toolbar panel.
///<br/>enableSortOrFilterColumn-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of Sort/Filter Row icon in the toolbar panel.
///<br/>enableSortOrFilterRow-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of Toggle Axis icon in the toolbar panel.
///<br/>enableToggleAxis-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of Chart Types icon in the toolbar panel.
///<br/>enableChartTypes-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of Remove Report icon in the toolbar panel.
///<br/>enableRemoveReport-boolean	default-true
///<br/><br/>
///Allows you to set the visibility of Calculated Member icon in the toolbar panel.
///<br/>enableCalculatedMember-boolean	default-false
///<br/><br/>
///Allows you to show a unique name on the pivot button.
///<br/>showUniqueNameOnPivotButton-boolean	default-false
///<br/><br/>
///Allows you to load the saved report collection from the database.
///<br/>showReportCollection-boolean	default-false
///<br/><br/>
///Enables the splitter option for resizing the elements in the control.
///<br/>enableSplitter-boolean	default-false
///<br/><br/>
///Enables the advanced filtering options such as value filtering, label filtering, and sorting for each dimensions when binding the OLAP data in the server mode.
///<br/>enableAdvancedFilter-boolean	default-false
///<br/><br/>
///Allows you to refresh the control on-demand and not during the every UI operation.
///<br/>enableDeferUpdate-boolean	default-false
///<br/><br/>
///Allows to save and load the reports in a customized way with the help of events.
///<br/>enableLocalStorage-boolean	default-false
///<br/><br/>
///Allows you to enable the paging for both the pivot chart and the pivot grid components for viewing the large data.
///<br/>enablePaging-boolean	default-false
///<br/><br/>
///Allows you to include the pivot tree map component as one of the chart types.
///<br/>enablePivotTreeMap-boolean	default-false
///<br/><br/>
///Allows you to view the layout of the pivot client from right to left.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Enables/disables the visibility of measure group selector drop-down in the cube browser.
///<br/>enableMeasureGroups-boolean	default-false
///<br/><br/>
///Allows you to get cell details in JSON format by clicking the value cell.
///<br/>enableCellClick-boolean	default-false
///<br/><br/>
///Allows you to get cell details in JSON format by double-clicking the value cell.
///<br/>enableCellDoubleClick-boolean	default-false
///<br/><br/>
///Allows you to enable the virtual scrolling for both the pivot chart and pivot grid components for viewing the large data.
///<br/>enableVirtualScrolling-boolean	default-false
///<br/><br/>
///Allows you to set the maximum number of nodes as well as child nodes to be displayed in the member editor.
///<br/>maxNodeLimitInMemberEditor-number	default-1000
///<br/><br/>
///Enables/disables paging in the member editor for viewing the large count of members in the pages.
///<br/>enableMemberEditorPaging-boolean	default-false
///<br/><br/>
///Allows you to set the number of members to be displayed in each page of the member editor on applying the paging in it.
///<br/>memberEditorPageSize-number	default-100
///<br/><br/>
///Enables/Disables sorting option in member editor dialog for the members of the respective field.
///<br/>enableMemberEditorSorting-boolean	default-false
///<br/><br/>
///Sets the summary layout for the pivot grid. Following are the ways in which the summary can be positioned: normal summary (bottom), top summary, no summary, and Microsoft Excel summary.
///<br/>gridLayout-ej.PivotGrid.Layout|string	default-ej.PivotGrid.Layout.Normal
///<br/><br/>
///Allows you to hide the cube browser and the axis element builder of the pivot client while initiating the widget.
///<br/>collapseCubeBrowserByDefault-boolean	default-false
///<br/><br/>
///Allows you to view the KPI elements in tree-view of the pivot client's cube browser.
///<br/>enableKPI-boolean	default-false
///<br/><br/>
///Allows you to enable the pivot clientâ€™s responsiveness in the browser layout.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Options to customize the size of the pivot client control.
///<br/>size-any	default-Example:
///<br/><br/>
///Allows you to set the localized language for the widget.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the mode for the pivot client widget to bind the data source in the server-side or the client-side.
///<br/>operationalMode-ej.Pivot.OperationalMode|string	default-ej.Pivot.OperationalMode.ClientMode
///<br/><br/>
///Allows you to set the custom name for methods at service-end, and it is communicated during the AJAX post.
///<br/>serviceMethodSettings-ServiceMethodSettings	default-{}
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for updating the entire report and widget, while changing the cube.
///<br/>cubeChanged-string	default-CubeChanged
///<br/><br/>
///Allows to set the custom name for the service method responsible for exporting.
///<br/>exportPivotClient-string	default-Export
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible to get the members for tree-view in the member-editor dialog.
///<br/>fetchMemberTreeNodes-string	default-FetchMemberTreeNodes
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for fetching the report names from the database.
///<br/>fetchReportList-string	default-FetchReportListFromDB
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for updating the report while filtering the members.
///<br/>filterElement-string	default-FilterElement
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for initializing the pivot client.
///<br/>initialize-string	default-InitializeClient
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for loading a report collection from the database.
///<br/>loadReport-string	default-LoadReportFromDB
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible to remove a report collection from the database.
///<br/>removeDBReport-string	default-RemoveReportFromDB
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for renaming the report collection in the database.
///<br/>renameDBReport-string	default-RenameReportInDB
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for retrieving the MDX query for the current report.
///<br/>mdxQuery-string	default-GetMDXQuery
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for updating the tree-view in the cube browser, while changing the measure group.
///<br/>measureGroupChanged-string	default-MeasureGroupChanged
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible to get the child members, on tree-view node expansion.
///<br/>memberExpand-string	default-MemberExpanded
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for updating the report while dropping a node/split button in the axis element builder.
///<br/>nodeDropped-string	default-NodeDropped
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible to update the report while removing the split button from the axis element builder.
///<br/>removeSplitButton-string	default-RemoveSplitButton
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for saving the report collection in the database.
///<br/>saveReport-string	default-SaveReportToDB
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for toggling the elements in the row and column axes.
///<br/>toggleAxis-string	default-ToggleAxis
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for all the toolbar operations.
///<br/>toolbarServices-string	default-ToolbarOperations
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for updating the report collection.
///<br/>updateReport-string	default-UpdateReport
///<br/><br/>
///Allows you to set the custom name for the service method while navigating between the pages in the paged pivot client.
///<br/>paging-string	default-Paging
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for updating the report with the calculated member.
///<br/>calculatedMember-string	default-CalculatedMember
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for performing value sorting operation in the PivotClient.
///<br/>valueSorting-string	default-ValueSorting
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for performing the drill through operation.
///<br/>drillThroughHierarchies-string	default-DrillThroughHierarchies
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for performing the drill through operation in the data table.
///<br/>drillThroughDataTable-string	default-DrillThroughDataTable
///<br/><br/>
///Holds the necessary properties for value sorting.
///<br/>valueSortSettings-ValueSortSettings	default-{}
///<br/><br/>
///Contains the header of the specific column to which value sorting is applied.
///<br/>headerText-string	default-
///<br/><br/>
///Allows you to set the string for separating column headers provided in the headerText property.
///<br/>headerDelimiters-string	default-
///<br/><br/>
///Allows you to set the sorting order of values of the field.
///<br/>sortOrder-ej.PivotAnalysis.SortOrder|string	default-ej.PivotAnalysis.SortOrder.Ascending
///<br/><br/>
///Sets the title for the pivot client widget.
///<br/>title-string	default-
///<br/><br/>
///Connects the service using the specified URL for any server updates.
///<br/>url-string	default-
///<br/><br/>
///Allows you to export entire data instead of current page data, while paging option is enabled.
///<br/>enableCompleteDataExport-boolean	default-false
///<br/><br/>
///Allows you to enable "withCredentials" property inside XMLHttpRequest object for CORS(Cross-Origin Resource Sharing) request.
///<br/>enableXHRCredentials-boolean	default-false
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
PivotGauge:function(){
 /// <signature>
 /// <summary>Constructor of ej.PivotGauge</summary>
 /// </signature>
}
});
ej.PivotGauge=(function(){
var original=ej.PivotGauge
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

doAjaxPost:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (AJAX) request.
/// </summary>
},
refresh:function(){
/// <signature>
/// <summary>
/// This function is used to refresh the PivotGauge at client-side itself.
/// </summary>
},
removeImg:function(){
/// <signature>
/// <summary>
/// This function removes the KPI related images from PivotGauge on binding OLAP datasource.
/// </summary>
},
renderControlFromJSON:function(){
/// <signature>
/// <summary>
/// This function receives the JSON formatted datasource and renders the PivotGauge control.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// This function Destroy the PivotGauge widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
getOlapReport:function(){
/// <signature>
/// <summary>
/// Returns the OlapReport string maintained along with the axis elements information.
/// </summary>
},
setOlapReport:function(){
/// <signature>
/// <summary>
/// Sets the OlapReport string along with the axis information and maintains it in a property.
/// </summary>
},
getJSONRecords:function(){
/// <signature>
/// <summary>
/// Returns the JSON records formed to render the control.
/// </summary>
},
setJSONRecords:function(){
/// <signature>
/// <summary>
/// Sets the JSON records to render the control.
/// </summary>
},
getJSONData:function(){
/// <signature>
/// <summary>
/// Returns the JSON records required to render the PivotGauge on performing any action with OLAP data source.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPivotGauge=function(){
this.data("ejPivotGauge",new	ej.PivotGauge());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPivotGauge :function (options) {
/// <signature>
/// <summary><br/>
///The PivotGauge control is ideal for highlighting business critical Key Performance Indicator (KPI) information in executive dashboards and report cards. The PivotGauge let you present values against goals in a very intuitive manner.<br/><br/>
///Sets the number of columns to arrange the Pivot Gauges.
///<br/>columnsCount-number	default-0
///<br/><br/>
///Specifies the CSS class to PivotGauge to achieve custom theme.
///<br/>cssClass-string	default-&#226;€œ&#226;€
///<br/><br/>
///Object utilized to pass additional information between client-end and service-end on operating in server mode.
///<br/>customObject-any	default-{}
///<br/><br/>
///Initializes the data source for the PivotGauge widget, when it functions completely on client-side.
///<br/>dataSource-DataSource	default-{}
///<br/><br/>
///Contains the respective cube name from OLAP database as string type.
///<br/>cube-string	default-&#226;€œ&#226;€
///<br/><br/>
///To set the data source name to fetch data from that.
///<br/>sourceInfo-string	default-&#226;€œ&#226;€
///<br/><br/>
///Set the provider name for PivotGauge to identify whether the provider is SSAS or Mondrian.
///<br/>providerName-string	default-ssas
///<br/><br/>
///Provides the raw data source for the PivotGauge.
///<br/>data-any	default-null
///<br/><br/>
///In connection with an OLAP database, this property contains the database name as string to fetch the data from the given connection string.
///<br/>catalog-string	default-&#226;€œ&#226;€
///<br/><br/>
///Lists out the items to bind in columns section.
///<br/>columns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Applies filter to the field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items to bind in rows section.
///<br/>rows-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Applies filter to the field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items supports calculation in PivotGauge.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the item by using its unique name as field name for Relational datasource.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows the user to set the display caption for an item for Relational datasource.
///<br/>fieldCaption-string	default-
///<br/><br/>
///This holds the list of unique names of measures to bind them from the OLAP cube.
///<br/>measures-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the measure from OLAP datasource by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows to set the axis name to place the measures items.
///<br/>axis-string	default-rows
///<br/><br/>
///Indicates whether the field is a calculated field or not with Relational datasource.
///<br/>isCalculatedField-boolean	default-false
///<br/><br/>
///Allows to set the formula for calculation of values for calculated members in Relational datasource.
///<br/>formula-string	default-
///<br/><br/>
///Lists out the items which supports filtering of values without displaying the members in UI in PivotGauge.
///<br/>filters-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Applies filter to the field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter whether to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Enables/disables the animation of pointer in PivotGauge.
///<br/>enableAnimation-boolean	default-false
///<br/><br/>
///Enables/disables tooltip visibility in PivotGauge.
///<br/>enableTooltip-boolean	default-false
///<br/><br/>
///Allows the user to view PivotGauge from right to left.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Specify the frame details of PivotGauge here.
///<br/>frame-Frame	default-Object
///<br/><br/>
///Specifies the frame type of PivotGauge.
///<br/>frameType-string	default-fullcircle
///<br/><br/>
///Specifies the end angle for the half circular frame.
///<br/>halfCircleFrameEndAngle-number	default-360
///<br/><br/>
///Specifies the start angle for the half circular frame.
///<br/>halfCircleFrameStartAngle-number	default-180
///<br/><br/>
///Allows the user to enable PivotGaugeâ€™s responsiveness in the browser layout.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Allows the user to change the format of the label values in PivotGauge.
///<br/>labelFormatSettings-LabelFormatSettings	default-null
///<br/><br/>
///Allows the user to change the number format of the label values in PivotGauge.
///<br/>numberFormat-ej.PivotGauge.NumberFormat|string	default-ej.PivotGauge.NumberFormat.Default
///<br/><br/>
///Allows you to set the number of digits displayed after decimal point.
///<br/>decimalPlaces-number	default-5
///<br/><br/>
///Allows you to add a text at the beginning of the label.
///<br/>prefixText-string	default-
///<br/><br/>
///Allows you to add text at the end of the label.
///<br/>suffixText-string	default-
///<br/><br/>
///Allows the user to set the localized language for the widget.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the number of rows to arrange the Pivot Gauges.
///<br/>rowsCount-number	default-0
///<br/><br/>
///Sets the scale values such as pointers, indicators, etc... for PivotGauge.
///<br/>scales-any	default-{}
///<br/><br/>
///Allows the user to set the custom name for the methods at service-end, communicated during AJAX post.
///<br/>serviceMethodSettings-ServiceMethodSettings	default-{}
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for initializing PivotGauge.
///<br/>initialize-string	default-InitializeGauge
///<br/><br/>
///Enables/disables the header labels in PivotGauge.
///<br/>showHeaderLabel-boolean	default-true
///<br/><br/>
///Connects the service using the specified URL for any server updates on server mode operation.
///<br/>url-string	default-&#226;€œ&#226;€
///<br/><br/>
///Sets the mode for the PivotGauge widget for binding either OLAP or Relational data source.
///<br/>analysisMode-ej.Pivot.AnalysisMode|string	default-ej.Pivot.AnalysisMode.Pivot
///<br/><br/>
///Sets the mode for the PivotGauge widget for binding data source either in server-side or client-side.
///<br/>operationalMode-ej.Pivot.OperationalMode|string	default-ej.Pivot.OperationalMode.ClientMode
///<br/><br/>
///Allows you to enable "withCredentials" property inside XMLHttpRequest object for CORS(Cross-Origin Resource Sharing) request.
///<br/>enableXHRCredentials-boolean	default-false
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
PivotGrid:function(){
 /// <signature>
 /// <summary>Constructor of ej.PivotGrid</summary>
 /// </signature>
}
});
ej.PivotGrid=(function(){
var original=ej.PivotGrid
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

doAjaxPost:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (AJAX) request.
/// </summary>
},
doPostBack:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (FullPost) submit.
/// </summary>
},
exportPivotGrid:function(){
/// <signature>
/// <summary>
/// Exports the PivotGrid to the specified format.
/// </summary>
},
refreshPagedPivotGrid:function(){
/// <signature>
/// <summary>
/// This function re-renders the PivotGrid when clicking the navigation buttons on the PivotPager.
/// </summary>
},
refreshPivotGrid:function(){
/// <signature>
/// <summary>
/// This function refreshes the PivotGrid with the modified data input in client-mode.
/// </summary>
},
refreshControl:function(){
/// <signature>
/// <summary>
/// This function re-renders the control with the report available at that instant.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// This function destroys the PivotGrid widget associated events that are bound using &quot;this._on&quot; and brings the control to pre-init state.
/// </summary>
},
calculateCellWidths:function(){
/// <signature>
/// <summary>
/// This function returns the height of all rows and the width of all columns.
/// </summary>
},
openConditionalFormattingDialog:function(){
/// <signature>
/// <summary>
/// This function creates the conditional formatting dialog to apply conditional formatting for the PivotGrid control.
/// </summary>
},
saveReport:function(){
/// <signature>
/// <summary>
/// This function saves the current report to the database/local storage.
/// </summary>
},
loadReport:function(){
/// <signature>
/// <summary>
/// This function loads the specified report from the database/local storage.
/// </summary>
},
excelLikeLayout:function(){
/// <signature>
/// <summary>
/// This function reconstructs the JSON data that is formed for rendering the PivotGrid in the excel-like layout format.
/// </summary>
},
getOlapReport:function(){
/// <signature>
/// <summary>
/// Returns the OlapReport string that is maintained along with the axis elements information.
/// </summary>
},
setOlapReport:function(){
/// <signature>
/// <summary>
/// Sets the OlapReport string along with the axis information.
/// </summary>
},
getJSONRecords:function(){
/// <signature>
/// <summary>
/// Returns the JSON records that are formed to render the control.
/// </summary>
},
setJSONRecords:function(){
/// <signature>
/// <summary>
/// Sets the JSON records that are formed to render the control.
/// </summary>
},
refreshFieldCaption:function(){
/// <signature>
/// <summary>
/// This function allows you to change the caption of the pivot item (name displayed in UI) on-demand for the relational datasource in client-mode.
/// </summary>
},
renderControlFromJSON:function(){
/// <signature>
/// <summary>
/// This function receives the JSON formatted datasource to render the PivotGrid control.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPivotGrid=function(){
this.data("ejPivotGrid",new	ej.PivotGrid());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPivotGrid :function (options) {
/// <signature>
/// <summary><br/>
///The PivotGrid control is easily configurable, presentation-quality business control that reads OLAP data from a Microsoft SQL Server Analysis Services database, an offline cube, XML/A, or relational datasource.<br/><br/>
///Sets the mode for the PivotGrid widget to bind either OLAP or relational data source.
///<br/>analysisMode-ej.Pivot.AnalysisMode|string	default-ej.Pivot.AnalysisMode.Pivot
///<br/><br/>
///Specifies the CSS class to the PivotGrid for achieving the custom theme.
///<br/>cssClass-string	default-&#226;€œ&#226;€
///<br/><br/>
///Connects the PivotSchemaDesigner with specified ID to the PivotGrid control.
///<br/>pivotTableFieldListID-string	default-&#226;€œ&#226;€
///<br/><br/>
///Initializes the data source for the PivotGrid widget, when it functions completely on client-side.
///<br/>dataSource-DataSource	default-{}
///<br/><br/>
///Lists out the items to be arranged in the columns section of the PivotGrid.
///<br/>columns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for an item.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Allows you to filter the report by using advanced filtering (e.g., Microsoft Excel) option for the OLAP data source in client-mode.
///<br/>advancedFilter-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to provide a level unique name to perform the advanced filtering.
///<br/>name-string	default-
///<br/><br/>
///Allows you to set the operator to perform the label filtering.
///<br/>labelFilterOperator-string	default-none
///<br/><br/>
///Allows you to set the operator to perform the value filtering.
///<br/>valueFilterOperator-string	default-none
///<br/><br/>
///Allows you to set the filtering type while performing the advanced filtering.
///<br/>advancedFilterType-string	default-
///<br/><br/>
///In value filtering, this property contains the measure name to which the filter is applied.
///<br/>measure-string	default-
///<br/><br/>
///Allows you to hold filter operand values in the advanced filtering.
///<br/>values-Array&lt;any&gt;	default-
///<br/><br/>
///Allows you to indicate whether the added item is a named set or not.
///<br/>isNamedSets-boolean	default-false
///<br/><br/>
///Shows/hides the sub-total of the field in PivotGrid.
///<br/>showSubTotal-boolean	default-true
///<br/><br/>
///Allows you to set the format for column headers.
///<br/>format-string	default-
///<br/><br/>
///This property is set to display the formatted values with format types in the PivotGrid.
///<br/>formatString-string	default-
///<br/><br/>
///Allows you to set the custom theme for column headers.
///<br/>cssClass-string	default-
///<br/><br/>
///Allows you to set the delimiter for date type format in the formatString. This is applicable for the groupByDate of row/column headers.
///<br/>delimiter-string	default-
///<br/><br/>
///Allows you to set the sorting order of members of the field.
///<br/>sortOrder-ej.PivotAnalysis.SortOrder|string	default-ej.PivotAnalysis.SortOrder.Ascending
///<br/><br/>
///Contains the list of members need to be drilled down by default in the field.
///<br/>drilledItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///Applies the filter to field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items to be arranged in the rows section of PivotGrid.
///<br/>rows-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for the item.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Allows you to filter the report by using the advanced filtering (e.g., Microsoft Excel) option for the OLAP data source in client-mode.
///<br/>advancedFilter-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to provide the level unique name to perform the advanced filtering.
///<br/>name-string	default-
///<br/><br/>
///Allows you to set the operator to perform the label filtering.
///<br/>labelFilterOperator-string	default-none
///<br/><br/>
///Allows you to set the operator to perform the value filtering.
///<br/>valueFilterOperator-string	default-none
///<br/><br/>
///Allows you to set the filtering type while performing the advanced filtering.
///<br/>advancedFilterType-string	default-
///<br/><br/>
///In value filtering, this property contains the measure name to which the filter is applied.
///<br/>measure-string	default-
///<br/><br/>
///Allows you to hold the filter operand values in the advanced filtering.
///<br/>values-Array&lt;any&gt;	default-
///<br/><br/>
///Allows you to indicate whether the added item is a named set or not.
///<br/>isNamedSets-boolean	default-false
///<br/><br/>
///Shows/hides the sub-total of the field.
///<br/>showSubTotal-boolean	default-true
///<br/><br/>
///Allows you to set the format for row headers.
///<br/>format-string	default-
///<br/><br/>
///This property is set to display the formatted values with format types in the PivotGrid.
///<br/>formatString-string	default-
///<br/><br/>
///Allows you to set the custom theme for row headers.
///<br/>cssClass-string	default-
///<br/><br/>
///Allows you to set the delimiter for date type format in the formatString. This is applicable for the groupByDate in row/column headers.
///<br/>delimiter-string	default-
///<br/><br/>
///Allows you to set the sorting order of members of the field.
///<br/>sortOrder-ej.PivotAnalysis.SortOrder|string	default-ej.PivotAnalysis.SortOrder.Ascending
///<br/><br/>
///Contains the list of members need to be drilled down by default in the field.
///<br/>drilledItems-Array&lt;any&gt;	default-[]
///<br/><br/>
///Applies the filter to field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items that support calculation in the PivotGrid.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name for the relational datasource.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display caption for the item in the relational datasource.
///<br/>fieldCaption-string	default-
///<br/><br/>
///This holds the list of unique names of measures to bind them from the OLAP cube.
///<br/>measures-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the measure from the OLAP datasource by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the axis name to place measures items.
///<br/>axis-string	default-rows
///<br/><br/>
///Indicates whether the field is a calculated field with the relational datasource or not.
///<br/>isCalculatedField-boolean	default-false
///<br/><br/>
///Allows to set the type of PivotGrid summary calculation in the value field with the relational datasource.
///<br/>summaryType-ej.PivotAnalysis.SummaryType|string	default-ej.PivotAnalysis.SummaryType.Sum
///<br/><br/>
///Allows to set the format for values.
///<br/>format-string	default-
///<br/><br/>
///This property is set to display the formatted values with format types in the PivotGrid.
///<br/>formatString-string	default-
///<br/><br/>
///Allows to set the formula for calculation of values for calculated members in the relational datasource.
///<br/>formula-string	default-
///<br/><br/>
///Allows to set the custom theme for values.
///<br/>cssClass-string	default-
///<br/><br/>
///Lists out the items which supports filtering of values without displaying the members in UI of the PivotGrid.
///<br/>filters-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows you to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows you to set the display name for the item.
///<br/>fieldCaption-string	default-
///<br/><br/>
///Applies the filter to field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Sets the type of filter to include/exclude the mentioned values.
///<br/>filterType-ej.PivotAnalysis.FilterType|string	default-ej.PivotAnalysis.FilterType.Exclude
///<br/><br/>
///Contains the collection of items to be included/excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Contains the respective cube name as string type in the OLAP database.
///<br/>cube-string	default-&#226;€œ&#226;€
///<br/><br/>
///To set the data source name to fetch the data.
///<br/>sourceInfo-string	default-&#226;€œ&#226;€
///<br/><br/>
///Sets the provider name for PivotGrid to identify whether the provider is SSAS or Mondrian.
///<br/>providerName-string	default-ssas
///<br/><br/>
///Provides the raw data source for the PivotGrid.
///<br/>data-any	default-null
///<br/><br/>
///In connection with an OLAP database, this property contains the database name as string to fetch the data from the given connection string.
///<br/>catalog-string	default-&#226;€œ&#226;€
///<br/><br/>
///Allows you to filter the members (by its name and values) through advanced filtering (e.g., Microsoft Excel) option at OLAP data source in client-mode.
///<br/>enableAdvancedFilter-boolean	default-false
///<br/><br/>
///Sets a name to the report that is bound to the control.
///<br/>reportName-string	default-
///<br/><br/>
///Allows to set the page size and current page number for each axis on applying the paging.
///<br/>pagerOptions-any	default-{}
///<br/><br/>
///Allows to set the number of categorical columns to be displayed in each page on applying the paging.
///<br/>categoricalPageSize-number	default-0
///<br/><br/>
///Allows to set the number of series rows to be displayed in each page on applying the paging.
///<br/>seriesPageSize-number	default-0
///<br/><br/>
///Allows to set the page number to be loaded in the categorical axis by default.
///<br/>categoricalCurrentPage-number	default-1
///<br/><br/>
///Allows to set the page number to be loaded in the series axis by default.
///<br/>seriesCurrentPage-number	default-1
///<br/><br/>
///Holds the necessary properties for value sorting.
///<br/>valueSortSettings-ValueSortSettings	default-{}
///<br/><br/>
///Contains the header of the specific column to which value sorting is applied.
///<br/>headerText-string	default-
///<br/><br/>
///Allows you to set the string for separating column headers provided in the headerText property.
///<br/>headerDelimiters-string	default-
///<br/><br/>
///Allows you to set the sorting order of values of the field.
///<br/>sortOrder-ej.PivotAnalysis.SortOrder|string	default-ej.PivotAnalysis.SortOrder.Ascending
///<br/><br/>
///Object that holds the settings of frozen headers.
///<br/>frozenHeaderSettings-FrozenHeaderSettings	default-{}
///<br/><br/>
///Allows you to freeze the row headers alone when scrolling the horizontal scroll bar.
///<br/>enableFrozenRowHeaders-boolean	default-false
///<br/><br/>
///Allows you to freeze the column headers alone when scrolling the vertical scroll bar.
///<br/>enableFrozenColumnHeaders-boolean	default-false
///<br/><br/>
///Allows you to freeze both row headers and column headers while scrolling.
///<br/>enableFrozenHeaders-boolean	default-false
///<br/><br/>
///Allows you to set the size of the scrollbar (horizontal and vertical) that is visible in the PivotGrid.
///<br/>scrollerSize-number	default-18
///<br/><br/>
///Allows you to display the header name in the PivotGrid control.
///<br/>headerSettings-HeaderSettings	default-{}
///<br/><br/>
///Allows you to enable/disable the row header names in the PivotGrid control.
///<br/>showRowItems-boolean	default-false
///<br/><br/>
///Allows you to enable/disable the column header names in the PivotGrid control.
///<br/>showColumnItems-boolean	default-false
///<br/><br/>
///Allows you to show the appropriate unique name in the pivot button.
///<br/>showUniqueNameOnPivotButton-boolean	default-false
///<br/><br/>
///Object is utilized to pass additional information between the client-end and the service-end while operating the control in server mode.
///<br/>customObject-any	default-null
///<br/><br/>
///Allows you to collapse specified members in each field by default.
///<br/>collapsedMembers-any	default-null
///<br/><br/>
///Allows you to access each cell by right-clicking the mouse.
///<br/>enableCellContext-boolean	default-false
///<br/><br/>
///Enables the cell selection for a specific range of value cells.
///<br/>enableCellSelection-boolean	default-false
///<br/><br/>
///Enables the Drill-Through feature which retrieves raw items that are used to create a specific cell in the PivotGrid.
///<br/>enableDrillThrough-boolean	default-false
///<br/><br/>
///Allows you to get cell details in JSON format by clicking the value cell.
///<br/>enableCellClick-boolean	default-false
///<br/><br/>
///Allows you to get cell details in JSON format by double-clicking the value cell.
///<br/>enableCellDoubleClick-boolean	default-false
///<br/><br/>
///Allows you to edit value cells for write-back support in the PivotGrid. This is applicable only for the server-mode.
///<br/>enableCellEditing-boolean	default-false
///<br/><br/>
///Collapses the pivot items along rows and columns by default. It works only for the relational data source.
///<br/>enableCollapseByDefault-boolean	default-false
///<br/><br/>
///Enables/disables the display of grand total for all columns.
///<br/>enableColumnGrandTotal-boolean	default-true
///<br/><br/>
///Allows you to format a specific set of cells based on the condition.
///<br/>enableConditionalFormatting-boolean	default-false
///<br/><br/>
///Enables the advanced filtering options such as value filtering, label filtering, and sorting for each field in the server mode.
///<br/>enableAdvancedFilter-boolean	default-false
///<br/><br/>
///Allows you to refresh the control on-demand and not during every UI operation.
///<br/>enableDeferUpdate-boolean	default-false
///<br/><br/>
///Enables the display of GroupingBar allowing you to filter, sort, and remove fields obtained from the datasource.
///<br/>enableGroupingBar-boolean	default-false
///<br/><br/>
///Allows you to set the maximum number of nodes as well as child nodes to be displayed in the member editor.
///<br/>maxNodeLimitInMemberEditor-number	default-1000
///<br/><br/>
///Enables/disables paging in the member editor for viewing the large count of members in pages.
///<br/>enableMemberEditorPaging-boolean	default-false
///<br/><br/>
///Allows you to set the number of members to be displayed in each page of member editor on applying paging in it.
///<br/>memberEditorPageSize-number	default-100
///<br/><br/>
///Enables/Disables sorting option in member editor dialog for the members of the respective field.
///<br/>enableMemberEditorSorting-boolean	default-false
///<br/><br/>
///Enables/disables the display of grand total for rows and columns.
///<br/>enableGrandTotal-boolean	default-true
///<br/><br/>
///Allows you to load the PivotGrid using the JSON data.
///<br/>enableJSONRendering-boolean	default-false
///<br/><br/>
///Enables rendering of the PivotGrid widget along with the PivotTable field list which allows UI operations.
///<br/>enablePivotFieldList-boolean	default-true
///<br/><br/>
///Enables the display of grand total for all rows.
///<br/>enableRowGrandTotal-boolean	default-true
///<br/><br/>
///Allows you to view the layout of PivotGrid from right to left.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Allows you to enable the ToolTip.
///<br/>enableToolTip-boolean	default-false
///<br/><br/>
///Allows you to enable the animation effects in the tooltip.
///<br/>enableToolTipAnimation-boolean	default-false
///<br/><br/>
///Allows you to adjust the width of columns dynamically within given widget size.
///<br/>enableColumnResizing-boolean	default-false
///<br/><br/>
///Allows you to fit the width of the column based on its maximum text width.
///<br/>resizeColumnsToFit-boolean	default-true
///<br/><br/>
///Allows you to enable/disable the context menu of pivot buttons in the PivotGrid.
///<br/>enableContextMenu-boolean	default-false
///<br/><br/>
///Allows you to view the large amount of data through virtual scrolling.
///<br/>enableVirtualScrolling-boolean	default-false
///<br/><br/>
///Allows you to view the large amount of data by applying paging.
///<br/>enablePaging-boolean	default-false
///<br/><br/>
///Allows you to configure the hyperlink settings of the PivotGrid control.
///<br/>hyperlinkSettings-HyperlinkSettings	default-{}
///<br/><br/>
///Allows you to enable/disable the hyperlink for the column header.
///<br/>enableColumnHeaderHyperlink-boolean	default-false
///<br/><br/>
///Allows you to enable/disable the hyperlink for the row header.
///<br/>enableRowHeaderHyperlink-boolean	default-false
///<br/><br/>
///Allows you to enable/disable the hyperlink for summary cells.
///<br/>enableSummaryCellHyperlink-boolean	default-false
///<br/><br/>
///Allows you to enable/disable the hyperlink for value cells.
///<br/>enableValueCellHyperlink-boolean	default-false
///<br/><br/>
///Allows you to enable PivotGridâ€™s responsiveness in the browser layout.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Contains the serialized JSON string which renders the PivotGrid.
///<br/>jsonRecords-string	default-
///<br/><br/>
///Sets the summary layout for PivotGrid.Following are the ways in which summary can be positioned: normal summary (bottom), top summary, no summary, and excel-like summary.
///<br/>layout-ej.PivotGrid.Layout|string	default-ej.PivotGrid.Layout.Normal
///<br/><br/>
///Allows the user to set the localized language for the widget.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the mode for PivotGrid widget for binding the data source either in the server-side or client-side.
///<br/>operationalMode-ej.Pivot.OperationalMode|string	default-ej.Pivot.OperationalMode.ClientMode
///<br/><br/>
///Allows you to set the custom name for the methods at service-end, communicated during AJAX post.
///<br/>serviceMethodSettings-ServiceMethodSettings	default-{}
///<br/><br/>
///Allows you to set the custom name for service method which is responsible for drill up/down operation in the PivotGrid.
///<br/>drillDown-string	default-DrillGrid
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for exporting.
///<br/>exportPivotGrid-string	default-Export
///<br/><br/>
///Allows you to set the custom name for the service method responsible for performing server-side actions based on defer update.
///<br/>deferUpdate-string	default-DeferUpdate
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for getting values of the tree-view inside filter dialog.
///<br/>fetchMembers-string	default-FetchMembers
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for filtering operation in the PivotGrid.
///<br/>filtering-string	default-Filtering
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for initializing the PivotGrid.
///<br/>initialize-string	default-InitializeGrid
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for the server-side action when dropping a node from the field list.
///<br/>nodeDropped-string	default-NodeDropped
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for server-side action when changing the checked state of a node in the field list.
///<br/>nodeStateModified-string	default-NodeStateModified
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for performing paging operation in the PivotGrid.
///<br/>paging-string	default-Paging
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for sorting operation in the PivotGrid.
///<br/>sorting-string	default-Sorting
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for expanding members in the member editor.
///<br/>memberExpand-string	default-MemberExpanded
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for editing the cells.
///<br/>cellEditing-string	default-CellEditing
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for saving the current report to the database.
///<br/>saveReport-string	default-SaveReport
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for loading a report from the database.
///<br/>loadReport-string	default-LoadReportFromDB
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for adding a calculated field to the report.
///<br/>calculatedField-string	default-CalculatedField
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for performing the drill through operation.
///<br/>drillThroughHierarchies-string	default-DrillThroughHierarchies
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for performing drill through operation in the data table.
///<br/>drillThroughDataTable-string	default-DrillThroughDataTable
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for performing value sorting operation in the PivotGrid.
///<br/>valueSorting-string	default-ValueSorting
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for removing the pivot button from the GroupingBar/field list.
///<br/>removeButton-string	default-RemoveButton
///<br/><br/>
///Allows you to set the custom name for the service method that is responsible for write-back operation in the OLAP Cube. This is applicable only in the server-side component.
///<br/>writeBack-string	default-WriteBack
///<br/><br/>
///Connects the service using the specified URL for any server updates.
///<br/>url-string	default-&#226;€œ&#226;€
///<br/><br/>
///Allows you to export entire data instead of current page data, while paging option is enabled.
///<br/>enableCompleteDataExport-boolean	default-false
///<br/><br/>
///Allows you to enable "withCredentials" property inside XMLHttpRequest object for CORS(Cross-Origin Resource Sharing) request.
///<br/>enableXHRCredentials-boolean	default-false
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
PivotPager:function(){
 /// <signature>
 /// <summary>Constructor of ej.PivotPager</summary>
 /// </signature>
}
});
ej.PivotPager=(function(){
var original=ej.PivotPager
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

initPagerProperties:function(){
/// <signature>
/// <summary>
/// This function initializes the page counts and page numbers for the PivotPager.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPivotPager=function(){
this.data("ejPivotPager",new	ej.PivotPager());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPivotPager :function (options) {
/// <signature>
/// <summary><br/>
///PivotPager is a control used to render large amount of data without any performance constraint in PivotGrid and PivotClient. The PivotPager widget is used to navigate between pages to view the paged information.<br/><br/>
///Contains the current page number in categorical axis.
///<br/>categoricalCurrentPage-number	default-1
///<br/><br/>
///Contains the total page count in categorical axis.
///<br/>categoricalPageCount-number	default-1
///<br/><br/>
///Allows the user to set the localized language for the widget.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the pager mode (Only Categorical Pager/Only Series Pager/Both) for the PivotPager.
///<br/>mode-ej.PivotPager.Mode|string	default-ej.PivotPager.Mode.Both
///<br/><br/>
///Contains the current page number in series axis.
///<br/>seriesCurrentPage-number	default-1
///<br/><br/>
///Contains the total page count in series axis.
///<br/>seriesPageCount-number	default-1
///<br/><br/>
///Contains the ID of the target element for which paging needs to be done.
///<br/>targetControlID-string	default-&#226;€œ&#226;€
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
PivotSchemaDesigner:function(){
 /// <signature>
 /// <summary>Constructor of ej.PivotSchemaDesigner</summary>
 /// </signature>
}
});
ej.PivotSchemaDesigner=(function(){
var original=ej.PivotSchemaDesigner
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

doAjaxPost:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (AJAX) request.
/// </summary>
},
refreshControl:function(){
/// <signature>
/// <summary>
/// Re-renders the control with the data source bound to the pivot control at that instant.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// This function Destroy the PivotSchemaDesigner widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPivotSchemaDesigner=function(){
this.data("ejPivotSchemaDesigner",new	ej.PivotSchemaDesigner());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPivotSchemaDesigner :function (options) {
/// <signature>
/// <summary><br/>
///PivotSchemaDesigner, also known as PivotTable Field List, is automatically populated with fields from the bound datasource and allows end user to drag fields, filter them, and create pivot views at run-time.<br/><br/>
///Specifies the CSS class to PivotSchemaDesigner to achieve custom theme.
///<br/>cssClass-string	default-&#226;€œ&#226;€
///<br/><br/>
///Object utilized to pass additional information between client-end and service-end.
///<br/>customObject-any	default-{}
///<br/><br/>
///For ASP.NET and MVC Wrapper, PivotSchemaDesigner will be initialized and rendered empty initially. Once the connected pivot control widget is rendered completely, PivotSchemaDesigner will just be populated with data source by setting this property to â€œtrueâ€.
///<br/>enableWrapper-boolean	default-false
///<br/><br/>
///Allows the user to view PivotTable Field List from right to left.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Sets the visibility of OLAP elements in PivotTable Field List. This is only applicable for OLAP datasource.
///<br/>olap-Olap	default-null
///<br/><br/>
///Allows the user to view the KPI elements in tree-view inside PivotTable Field List. This is only applicable for OLAP datasource.
///<br/>showKPI-boolean	default-false
///<br/><br/>
///Allows the user to view the named sets in tree-view inside PivotTable Field List. This is only applicable for OLAP datasource.
///<br/>showNamedSets-boolean	default-false
///<br/><br/>
///Allows the user to enable/disable drag and drop operations within the PivotTable Field List.
///<br/>enableDragDrop-boolean	default-true
///<br/><br/>
///Sets the height for PivotSchemaDesigner.
///<br/>height-string	default-&#226;€œ&#226;€
///<br/><br/>
///Allows the user to set the localized language for the widget.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the Pivot control bound with this PivotSchemaDesigner.
///<br/>pivotControl-any	default-null
///<br/><br/>
///Allows the user to set custom name for the methods at service-end, communicated during AJAX post.
///<br/>serviceMethods-any	default-{}
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for getting the values for the tree-view inside filter dialog.
///<br/>serviceMethod.fetchMembers-string	default-FetchMembers
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for filtering operation in Field List.
///<br/>serviceMethod.filtering-string	default-Filtering
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for the server-side action, on expanding members in Field List.
///<br/>serviceMethod.memberExpand-string	default-MemberExpanded
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for the server-side action, on dropping a node into Field List.
///<br/>serviceMethod.nodeDropped-string	default-NodeDropped
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for the server-side action on changing the checked state of a node in Field List.
///<br/>serviceMethod.nodeStateModified-string	default-NodeStateModified
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for button removing operation in Field List.
///<br/>serviceMethod.removeButton-string	default-RemoveButton
///<br/><br/>
///Connects the service using the specified URL for any server updates.
///<br/>url-string	default-&#226;€œ&#226;€
///<br/><br/>
///Sets the width for PivotSchemaDesigner.
///<br/>width-string	default-&#226;€œ&#226;€
///<br/><br/>
///Sets the layout for PivotSchemaDesigner.
///<br/>layout-ej.PivotSchemaDesigner.Layouts|string	default-ej.PivotSchemaDesigner.Layouts.Excel
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
PivotTreeMap:function(){
 /// <signature>
 /// <summary>Constructor of ej.PivotTreeMap</summary>
 /// </signature>
}
});
ej.PivotTreeMap=(function(){
var original=ej.PivotTreeMap
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

doAjaxPost:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (AJAX) request.
/// </summary>
},
doPostBack:function(){
/// <signature>
/// <summary>
/// Performs an asynchronous HTTP (FullPost) submit.
/// </summary>
},
getOlapReport:function(){
/// <signature>
/// <summary>
/// Returns the OlapReport string maintained along with the axis elements information.
/// </summary>
},
setOlapReport:function(){
/// <signature>
/// <summary>
/// Sets the OlapReport string along with the axis information and maintains it in a property.
/// </summary>
},
getJSONRecords:function(){
/// <signature>
/// <summary>
/// Returns the JSON records formed to render the control.
/// </summary>
},
setJSONRecords:function(){
/// <signature>
/// <summary>
/// Sets the JSON records to render the control.
/// </summary>
},
generateJSON:function(){
/// <signature>
/// <summary>
/// Renders the control with the pivot engine obtained from OLAP cube.
/// </summary>
},
renderTreeMapFromJSON:function(){
/// <signature>
/// <summary>
/// This function receives the JSON formatted datasource to render the PivotTreeMap control.
/// </summary>
},
renderControlSuccess:function(){
/// <signature>
/// <summary>
/// This function receives the update from service-end, which would be utilized for rendering the widget.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// This function Destroy the PivotTreemap widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPivotTreeMap=function(){
this.data("ejPivotTreeMap",new	ej.PivotTreeMap());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPivotTreeMap :function (options) {
/// <signature>
/// <summary><br/>
///The PivotTreemap is a lightweight control that reads OLAP information and visualizes it in graphical format with the ability to drill up and down.<br/><br/>
///Specifies the CSS class to PivotTreeMap to achieve custom theme.
///<br/>cssClass-string	default-&#226;€œ&#226;€
///<br/><br/>
///Initializes the data source for the PivotTreeMap widget, when it functions completely on client-side.
///<br/>dataSource-DataSource	default-{}
///<br/><br/>
///Provides the raw data source for the PivotTreeMap.
///<br/>data-any	default-null
///<br/><br/>
///Contains the respective cube name from OLAP database as string type.
///<br/>cube-string	default-&#226;€œ&#226;€
///<br/><br/>
///To set the data source name to fetch data from that.
///<br/>sourceInfo-string	default-&#226;€œ&#226;€
///<br/><br/>
///Set the provider name for PivotTreeMap to identify whether the provider is SSAS or Mondrian.
///<br/>providerName-string	default-ssas
///<br/><br/>
///In connection with an OLAP database, this property contains the database name as string to fetch the data from the given connection string.
///<br/>catalog-string	default-&#226;€œ&#226;€
///<br/><br/>
///Lists out the items to be displayed as series of PivotTreeMap.
///<br/>columns-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows the user to indicate whether the added item is a named set or not.
///<br/>isNamedSets-boolean	default-false
///<br/><br/>
///Applies filter to the field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Contains the collection of items to be excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items to be displayed as segments of PivotTreeMap.
///<br/>rows-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows the user to indicate whether the added item is a named set or not.
///<br/>isNamedSets-boolean	default-false
///<br/><br/>
///Applies filter to the field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Contains the collection of items to be excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Lists out the items supports calculation in PivotTreeMap.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///This holds the list of unique names of measures to bind them from the OLAP cube.
///<br/>measures-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the measure from OLAP datasource by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Allows to set the axis name to place the measures items.
///<br/>axis-string	default-rows
///<br/><br/>
///Lists out the items which supports filtering of values without displaying the members in UI in PivotTreeMap.
///<br/>filters-Array&lt;any&gt;	default-[]
///<br/><br/>
///Allows the user to bind the item by using its unique name as field name.
///<br/>fieldName-string	default-
///<br/><br/>
///Applies filter to the field members.
///<br/>filterItems-any	default-null
///<br/><br/>
///Contains the collection of items to be excluded among the field members.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Object utilized to pass additional information between client-end and service-end.
///<br/>customObject-any	default-{}
///<br/><br/>
///Allows the user to enable PivotTreeMapâ€™s responsiveness in the browser layout.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Allows the user to set the localized language for the widget.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the mode for the PivotTreeMap widget for binding data source either in server-side or client-side.
///<br/>operationalMode-ej.Pivot.OperationalMode|string	default-ej.Pivot.OperationalMode.ClientMode
///<br/><br/>
///Allows the user to set custom name for the methods at service-end, communicated on AJAX post.
///<br/>serviceMethodSettings-ServiceMethodSettings	default-{}
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for initializing PivotTreeMap.
///<br/>initialize-string	default-InitializeTreemap
///<br/><br/>
///Allows the user to set the custom name for the service method responsible for drilling up/down operation in PivotTreeMap.
///<br/>drillDown-string	default-DrillTreeMap
///<br/><br/>
///Connects the service using the specified URL for any server updates.
///<br/>url-string	default-&#226;€œ&#226;€
///<br/><br/>
///Allows you to enable "withCredentials" property inside XMLHttpRequest object for CORS(Cross-Origin Resource Sharing) request.
///<br/>enableXHRCredentials-boolean	default-false
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Print:function(){
 /// <signature>
 /// <summary>Constructor of ej.Print</summary>
 /// </signature>
}
});
ej.Print=(function(){
var original=ej.Print
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

print:function(){
/// <signature>
/// <summary>
/// Print the specific page or an element.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejPrint=function(){
this.data("ejPrint",new	ej.Print());
return this;
};
intellisense.annotate(jQuery.fn,{
ejPrint :function (options) {
/// <signature>
/// <summary><br/>
///A flexible widget that allows the user to print a complete page or a particular element in it with the required customizations.<br/><br/>
///Append the custom HTML after the selected content.
///<br/>append-string	default-null
///<br/><br/>
///A selector that specifies a particular element to be excluded from printing.
///<br/>excludeSelector-string	default-null
///<br/><br/>
///Specifies whether the URL of an external stylesheet can be included to customize and print that page.
///<br/>externalStyles-string	default-null
///<br/><br/>
///Prepend a docType to the document frame.
///<br/>docType-string	default-&amp;lt;!doctype html&amp;gt;
///<br/><br/>
///Specifies whether the global styles can be applied to the element to be printed.
///<br/>globalStyles-boolean	default-true
///<br/><br/>
///Sets the height of the print window.
///<br/>height-number	default-454
///<br/><br/>
///Prepends the custom HTML before the selected content.
///<br/>prepend-string	default-null
///<br/><br/>
///Allows printing the content in a new window.
///<br/>printInNewWindow-boolean	default-false
///<br/><br/>
///Sets the period of time to wait before printing the content.
///<br/>timeOutPeriod-number	default-1000
///<br/><br/>
///Sets the title of the print document.
///<br/>title-string	default-null
///<br/><br/>
///Defines the width of the print window.
///<br/>width-number	default-1024
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
ProgressBar:function(){
 /// <signature>
 /// <summary>Constructor of ej.ProgressBar</summary>
 /// </signature>
}
});
ej.ProgressBar=(function(){
var original=ej.ProgressBar
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// Destroy the progressbar widget
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// Disables the progressbar control
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// Enables the progressbar control
/// </summary>
},
getPercentage:function(){
/// <signature>
/// <summary>
/// Returns the current progress value in percent.
/// </summary>
},
getValue:function(){
/// <signature>
/// <summary>
/// Returns the current progress value
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejProgressBar=function(){
this.data("ejProgressBar",new	ej.ProgressBar());
return this;
};
intellisense.annotate(jQuery.fn,{
ejProgressBar :function (options) {
/// <signature>
/// <summary><br/>
///The ProgressBar control is a graphical control element used to visualize the changing status of an extended operation.<br/><br/>
///Sets the root CSS class for ProgressBar theme, which is used customize.
///<br/>cssClass-string	default-null
///<br/><br/>
///When this property sets to false, it disables the ProgressBar control
///<br/>enabled-boolean	default-true
///<br/><br/>
///Save current model value to browser cookies for state maintains. While refresh the progressBar control page retains the model value apply from browser cookies
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Sets the ProgressBar direction as right to left alignment.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Defines the height of the ProgressBar.
///<br/>height-number|string	default-null
///<br/><br/>
///It allows to define the characteristics of the progressBar control. It will helps to extend the capability of an HTML element.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Sets the maximum value of the ProgressBar.
///<br/>maxValue-number	default-100
///<br/><br/>
///Sets the minimum value of the ProgressBar.
///<br/>minValue-number	default-0
///<br/><br/>
///Sets the ProgressBar value in percentage. The value should be in between 0 to 100.
///<br/>percentage-number	default-0
///<br/><br/>
///Displays rounded corner borders on the progressBar control.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Sets the custom text for the ProgressBar. The text placed in the middle of the ProgressBar and it can be customizable using the class 'e-progress-text'.
///<br/>text-string	default-null
///<br/><br/>
///Sets the ProgressBar value. The value should be in between min and max values.
///<br/>value-number	default-0
///<br/><br/>
///Defines the width of the ProgressBar.
///<br/>width-number|string	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Query:function(){
 /// <signature>
 /// <summary>Constructor of ej.Query</summary>
 /// </signature>
}
});
ej.Query=(function(){
var original=ej.Query
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addParams:function(key, value){
/// <signature>
/// <summary>
/// Passes custom parameters to our API URL.
/// </summary>
/// <param name="key"	type="string"></param>
/// </signature>
/// <signature>
/// <summary>
/// Passes custom parameters to our API URL.
/// </summary>
/// <param name="value"	type="string"></param>
/// </signature>
},
clone:function(){
/// <signature>
/// <summary>
/// clone is used to duplicate the data.
/// </summary>
},
execute:function(dataManager){
/// <signature>
/// <summary>
/// It is used to execute the query on URL Binding
/// </summary>
/// <param name="dataManager"	type="any">JSON data or OData</param>
/// </signature>
},
executeLocal:function(dataManager){
/// <signature>
/// <summary>
/// It is used to execute the query on Local Binding
/// </summary>
/// <param name="dataManager"	type="any">JSON data</param>
/// </signature>
},
expand:function(tables){
/// <signature>
/// <summary>
/// expand is used to performs complex binding.
/// </summary>
/// <param name="tables"	type="string">name of the tables</param>
/// </signature>
},
foreignKey:function(key){
/// <signature>
/// <summary>
/// Relates two tables. A foreign key is a column or combination of columns which is used to establish and enforce a link between two tables.
/// </summary>
/// <param name="key"	type="string">primary key field name</param>
/// </signature>
},
from:function(tableName){
/// <signature>
/// <summary>
/// Specifies the name of table(s) to retrieve data.
/// </summary>
/// <param name="tableName"	type="string">name of the table</param>
/// </signature>
},
group:function(fieldName){
/// <signature>
/// <summary>
/// Groups records based on the given field name.
/// </summary>
/// <param name="fieldName"	type="string">name of the column</param>
/// </signature>
},
hierarchy:function(query){
/// <signature>
/// <summary>
/// Displays the records in hierarchical relationships. The foreign key is used to relate two tables.
/// </summary>
/// <param name="query"	type="ej.query">query the JSON data</param>
/// </signature>
},
page:function(pageIndex, pageSize){
/// <signature>
/// <summary>
/// Retrieves records based on the given page index and size.
/// </summary>
/// <param name="pageIndex"	type="number">page number</param>
/// </signature>
/// <signature>
/// <summary>
/// Retrieves records based on the given page index and size.
/// </summary>
/// <param name="pageSize"	type="number">Number of rows in the page</param>
/// </signature>
},
range:function(start, end){
/// <signature>
/// <summary>
/// The range property is used to retrieve the records based on the given start and end index.
/// </summary>
/// <param name="start"	type="number">start index of JSON data</param>
/// </signature>
/// <signature>
/// <summary>
/// The range property is used to retrieve the records based on the given start and end index.
/// </summary>
/// <param name="end"	type="number">end index of JSON data</param>
/// </signature>
},
requiresCount:function(){
/// <signature>
/// <summary>
/// Specifies that the total number of records(count) is required in the result.
/// </summary>
},
search:function(fieldName, operator, value, ignoreCase, ignoreAccent){
/// <signature>
/// <summary>
/// It is used to search the given search key value in JSON data
/// </summary>
/// <param name="fieldName"	type="string">name of the column</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to search the given search key value in JSON data
/// </summary>
/// <param name="operator"	type="string">conditional Operators</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to search the given search key value in JSON data
/// </summary>
/// <param name="value"	type="string">value to filter the field name</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to search the given search key value in JSON data
/// </summary>
/// <param name="ignoreCase"	type="boolean">on/off case sensitive.</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to search the given search key value in JSON data
/// </summary>
/// <param name="ignoreAccent"	type="boolean">Filter diacritics based on the boolean value.</param>
/// </signature>
},
select:function(fieldName){
/// <signature>
/// <summary>
/// Selects specified columns from the data source.
/// </summary>
/// <param name="fieldName"	type="string">name of the columns</param>
/// </signature>
},
skip:function(nos){
/// <signature>
/// <summary>
/// Skips the given count of records from the data source.
/// </summary>
/// <param name="nos"	type="number">number of records</param>
/// </signature>
},
sortBy:function(fieldName){
/// <signature>
/// <summary>
/// Sort items or records in an ordered sequence.
/// </summary>
/// <param name="fieldName"	type="string">name of the column</param>
/// </signature>
},
sortByDesc:function(fieldName){
/// <signature>
/// <summary>
/// Sort items or records in descending order.
/// </summary>
/// <param name="fieldName"	type="string">name of the column</param>
/// </signature>
},
take:function(nos){
/// <signature>
/// <summary>
/// Picks the given count of records from the top of the datasource.
/// </summary>
/// <param name="nos"	type="number">number of records</param>
/// </signature>
},
using:function(dataManager){
/// <signature>
/// <summary>
/// using is a method used to query the data manager.
/// </summary>
/// <param name="dataManager"	type="any">Pass new data source</param>
/// </signature>
},
where:function(fieldName, operator, value, ignoreCase, ignoreAccent){
/// <signature>
/// <summary>
/// It is used to filter records based on the filter condition.
/// </summary>
/// <param name="fieldName"	type="string">name of the column</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to filter records based on the filter condition.
/// </summary>
/// <param name="operator"	type="string">conditional Operators</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to filter records based on the filter condition.
/// </summary>
/// <param name="value"	type="string">value to filter the field name</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to filter records based on the filter condition.
/// </summary>
/// <param name="ignoreCase"	type="boolean">on/off case sensitive.</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to filter records based on the filter condition.
/// </summary>
/// <param name="ignoreAccent"	type="boolean">Filter diacritics based on the boolean value.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejQuery=function(){
this.data("ejQuery",new	ej.Query());
return this;
};
intellisense.annotate(jQuery.fn,{
ejQuery :function (options) {
/// <signature>
/// <summary><br/>
///Communicates with data source and returns the desired result based on the Query provided.</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
RadialMenu:function(){
 /// <signature>
 /// <summary>Constructor of ej.RadialMenu</summary>
 /// </signature>
}
});
ej.RadialMenu=(function(){
var original=ej.RadialMenu
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

hide:function(){
/// <signature>
/// <summary>
/// To hide the radialmenu
/// </summary>
},
hideMenu:function(){
/// <signature>
/// <summary>
/// To hide the radialmenu items
/// </summary>
},
show:function(){
/// <signature>
/// <summary>
/// To Show the radial menu
/// </summary>
},
showMenu:function(){
/// <signature>
/// <summary>
/// To show menu items
/// </summary>
},
enableItemByIndex:function(itemIndex){
/// <signature>
/// <summary>
/// To enable menu item using index
/// </summary>
/// <param name="itemIndex"	type="number">Index of the Radialmenu to be enabled.</param>
/// </signature>
},
enableItemsByIndices:function(itemIndices){
/// <signature>
/// <summary>
/// To enable menu items using indices
/// </summary>
/// <param name="itemIndices"	type="any[]">Index of the Radialmenu to be enabled.</param>
/// </signature>
},
disableItemByIndex:function(itemIndex){
/// <signature>
/// <summary>
/// To disable menu item using index
/// </summary>
/// <param name="itemIndex"	type="number">Index of the Radialmenu to be disabled.</param>
/// </signature>
},
disableItemsByIndices:function(itemIndices){
/// <signature>
/// <summary>
/// To disable menu items using indices
/// </summary>
/// <param name="itemIndices"	type="any[]">items of the Radialmenu to disable.</param>
/// </signature>
},
enableItem:function(item){
/// <signature>
/// <summary>
/// To enable menu item using item text
/// </summary>
/// <param name="item"	type="string">item of the Radialmenu item to enable.</param>
/// </signature>
},
disableItem:function(item){
/// <signature>
/// <summary>
/// To disable menu item using item text
/// </summary>
/// <param name="item"	type="string">item of the Radialmenu item to disable.</param>
/// </signature>
},
enableItems:function(items){
/// <signature>
/// <summary>
/// To enable menu items using item texts
/// </summary>
/// <param name="items"	type="any[]">items of the Radialmenu item to enable.</param>
/// </signature>
},
disableItems:function(items){
/// <signature>
/// <summary>
/// To disable menu items using item texts
/// </summary>
/// <param name="items"	type="any[]">items of the Radialmenu item to disable.</param>
/// </signature>
},
updateBadgeValue:function(index, value){
/// <signature>
/// <summary>
/// To update menu item badge value
/// </summary>
/// <param name="index"	type="number">The index value to add the given items at the specified index. If index is not specified, the given value will not be updated.</param>
/// </signature>
/// <signature>
/// <summary>
/// To update menu item badge value
/// </summary>
/// <param name="value"	type="number">The Value to be updated in the badge. It will be updated based on the given index</param>
/// </signature>
},
showBadge:function(index){
/// <signature>
/// <summary>
/// To show menu item badge
/// </summary>
/// <param name="index"	type="number">Index of the Radialmenu item to be shown badge.</param>
/// </signature>
},
hideBadge:function(index){
/// <signature>
/// <summary>
/// To hide menu item badge
/// </summary>
/// <param name="index"	type="number">Index of the Radialmenu item to hide the badge.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRadialMenu=function(){
this.data("ejRadialMenu",new	ej.RadialMenu());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRadialMenu :function (options) {
/// <signature>
/// <summary><br/>
///The RadialMenu control is a context that represents the menu items are arranged in a circular order with a centric button element in it. By default, only the center button is visible. The Radial Menu displays the root level menu item with rotational animation effects on clicking the center menu button.<br/><br/>
///To show the Radial in initial render.
///<br/>autoOpen-boolean	default-
///<br/><br/>
///Renders the back button Image for Radial using class.
///<br/>backImageClass-string	default-
///<br/><br/>
///Sets the root class for RadialMenu theme. This cssClass API helps to use custom skinning option for RadialMenu control. By defining the root class using this API, we need to include this root class in CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///To enable Animation for Radial Menu.
///<br/>enableAnimation-boolean	default-
///<br/><br/>
///Renders the Image for Radial using Class.
///<br/>imageClass-string	default-
///<br/><br/>
///Specify the items of radial menu
///<br/>items-Array&lt;Items&gt;	default-
///<br/><br/>
///Specify the URL of the frame background image for radial menu item.
///<br/>imageUrl-string	default-
///<br/><br/>
///Specifies the template property of RadialMenu for SVG icon.
///<br/>prependTo-string	default-
///<br/><br/>
///Specifies the text of RadialMenu item.
///<br/>text-string	default-
///<br/><br/>
///Specifies the enable state of RadialMenu item.
///<br/>enabled-boolean	default-
///<br/><br/>
///specify the click event to corresponding image/text for performing some specific action.
///<br/>click-string	default-
///<br/><br/>
///Specifies radialmenu item badges.
///<br/>badge-any	default-
///<br/><br/>
///Specifies whether to enable radialmenu item badge or not.
///<br/>enabled-boolean	default-
///<br/><br/>
///Specifies the value of radial menu item badge.
///<br/>value-number	default-
///<br/><br/>
///Specifies the type of nested radial menu item.
///<br/>type-string	default-
///<br/><br/>
///Specifies the sliderSettings ticks for nested radial menu items.
///<br/>sliderSettings-any	default-
///<br/><br/>
///Specifies the sliderSettings ticks values of nested radial menu items.
///<br/>ticks-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the sliderSettings stroke Width value.
///<br/>strokeWidth-number	default-
///<br/><br/>
///Specifies the value of sliderSettings labelSpace .
///<br/>labelSpace-number	default-
///<br/><br/>
///Specifies to add sub level items .
///<br/>items-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the radius of radial menu
///<br/>radius-number	default-
///<br/><br/>
///To show the Radial while clicking given target element.
///<br/>targetElementId-string	default-
///<br/><br/>
///To set radial render position.
///<br/>position-any	default-
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
RadialSlider:function(){
 /// <signature>
 /// <summary>Constructor of ej.RadialSlider</summary>
 /// </signature>
}
});
ej.RadialSlider=(function(){
var original=ej.RadialSlider
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

show:function(){
/// <signature>
/// <summary>
/// To show the radialslider
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// To hide the radialslider
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRadialSlider=function(){
this.data("ejRadialSlider",new	ej.RadialSlider());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRadialSlider :function (options) {
/// <signature>
/// <summary><br/>
///The RadialSlider provides an optimized interface for selecting a numeric value using a touch interface. Value is returned based on direct needle selection or needle move. It can also be customized as a full circle, half circle, or any portion of a circle, based on startAngle and endAngle<br/><br/>
///To show the RadialSlider in initial render.
///<br/>autoOpen-boolean	default-false
///<br/><br/>
///Sets the root class for RadialSlider theme. This cssClass API helps to use custom skinning option for RadialSlider control. By defining the root class using this API, we need to include this root class in CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///To enable Animation for Radial Slider.
///<br/>enableAnimation-boolean	default-true
///<br/><br/>
///Enable/Disable the Roundoff property of RadialSlider
///<br/>enableRoundOff-boolean	default-true
///<br/><br/>
///Specifies the endAngle value for radial slider circle.
///<br/>endAngle-number	default-360
///<br/><br/>
///Specifies the inline for label show or not on given radius.
///<br/>inline-boolean	default-false
///<br/><br/>
///Specifies innerCircleImageClass, using this property we can give images for center radial circle through CSS classes.
///<br/>innerCircleImageClass-string	default-null
///<br/><br/>
///Specifies the file name of center circle icon
///<br/>innerCircleImageUrl-string	default-null
///<br/><br/>
///Specifies the Space between the radial slider element and the label.
///<br/>labelSpace-number	default-30
///<br/><br/>
///Change the Radial Slider ticks value based on the given culture.
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the radius of radial slider
///<br/>radius-number	default-200
///<br/><br/>
///To show the RadialSlider inner circle.
///<br/>showInnerCircle-boolean	default-true
///<br/><br/>
///Specifies the endAngle value for radial slider circle.
///<br/>startAngle-number	default-0
///<br/><br/>
///Specifies the  strokeWidth for customize the needle, outer circle and inner circle.
///<br/>strokeWidth-number	default-2
///<br/><br/>
///Specifies the ticks value of radial slider
///<br/>ticks-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the value of radial slider
///<br/>value-number	default-10
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
RadioButton:function(){
 /// <signature>
 /// <summary>Constructor of ej.RadioButton</summary>
 /// </signature>
}
});
ej.RadioButton=(function(){
var original=ej.RadioButton
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

disable:function(){
/// <signature>
/// <summary>
/// To disable the RadioButton
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// To enable the RadioButton
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRadioButton=function(){
this.data("ejRadioButton",new	ej.RadioButton());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRadioButton :function (options) {
/// <signature>
/// <summary><br/>
///The RadioButton control allows you to choose an option to perform an action. This control allows you to select true/false.<br/><br/>
///Specifies the check attribute of the Radio Button.
///<br/>checked-boolean	default-false
///<br/><br/>
///Specify the CSS class to RadioButton to achieve custom theme.
///<br/>cssClass-string	default-
///<br/><br/>
///Specifies the RadioButton control state.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Specifies the enablePersistence property for RadioButton while initialization. The enablePersistence API save current model value to browser cookies for state maintains. While refreshing the radio button control page the model value apply from browser cookies.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Specify the Right to Left direction to RadioButton
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Specifies the HTML Attributes of the Checkbox
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Specifies the id attribute for the Radio Button while initialization.
///<br/>id-string	default-null
///<br/><br/>
///Specify the idPrefix value to be added before the current id of the RadioButton.
///<br/>idPrefix-string	default-ej
///<br/><br/>
///Specifies the name attribute for the Radio Button while initialization.
///<br/>name-string	default-Sets id as name if it is null
///<br/><br/>
///Specifies the size of the RadioButton.
///<br/>size-ej.RadioButtonSize|string	default-small
///<br/><br/>
///Specifies the text content for RadioButton.
///<br/>text-string	default-
///<br/><br/>
///Set the jQuery validation error message in radio button.
///<br/>validationMessage-any	default-null
///<br/><br/>
///Set the jQuery validation rules in radio button.
///<br/>validationRules-any	default-null
///<br/><br/>
///Specifies the value attribute of the Radio Button.
///<br/>value-string	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
RangeNavigator:function(){
 /// <signature>
 /// <summary>Constructor of ej.RangeNavigator</summary>
 /// </signature>
}
});
ej.RangeNavigator=(function(){
var original=ej.RangeNavigator
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

_destroy:function(){
/// <signature>
/// <summary>
/// destroy the range navigator widget
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRangeNavigator=function(){
this.data("ejRangeNavigator",new	ej.RangeNavigator());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRangeNavigator :function (options) {
/// <signature>
/// <summary><br/>
///The range navigator can be easily configured to the DOM element, such as div. You can create a range navigator with a highly customizable look and feel.<br/><br/>
///Toggles the placement of slider exactly on the place it left or on the nearest interval.
///<br/>allowSnapping-boolean	default-false
///<br/><br/>
///It allows to show the value between the particular periods (i.e) from 1st January to 31st February and so on. The default value is true. If we set the property as false, it allows to show the value between the particular periods.(i.e) from 1st January to 31st January and so on.
///<br/>allowNextValue-boolean	default-true
///<br/><br/>
///Options for customizing the color, opacity and width of the chart border.
///<br/>border-Border	default-
///<br/><br/>
///Border color of rangenavigator. When enable the scrollbar, the default color will be set as "#B4B4B4".
///<br/>color-string	default-transparent
///<br/><br/>
///Opacity of the rangeNavigator border.
///<br/>opacity-number	default-1
///<br/><br/>
///Width of the RangeNavigator border.
///<br/>width-number	default-1
///<br/><br/>
///Specifies the data source for range navigator.
///<br/>dataSource-any	default-
///<br/><br/>
///Specifies the properties used for customizing the range series.
///<br/>series-Array&lt;Series&gt;	default-
///<br/><br/>
///Name of the property in the datasource that contains x value for the series.
///<br/>xName-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains y value for the series.
///<br/>yName-string	default-null
///<br/><br/>
///Specifies the dataSource for the series. It can be an array of JSON objects or an instance of ej.DataManager.
///<br/>dataSource-any	default-null
///<br/><br/>
///Specifies the type of the series to render in chart.
///<br/>type-ej.datavisualization.RangeNavigator.Type|string	default-column. see Type
///<br/><br/>
///Enable/disable the animation of series.
///<br/>enableAnimation-boolean	default-false
///<br/><br/>
///Fill color of the series.
///<br/>fill-string	default-null
///<br/><br/>
///Specifies the  properties used for customizing all the range series.
///<br/>seriesSettings-Array&lt;SeriesSettings&gt;	default-
///<br/><br/>
///Name of the property in the datasource that contains x value for the series.
///<br/>xName-string	default-null
///<br/><br/>
///Name of the property in the datasource that contains y value for the series.
///<br/>yName-string	default-null
///<br/><br/>
///Specifies the dataSource for the series. It can be an array of JSON objects or an instance of ej.DataManager.
///<br/>dataSource-any	default-null
///<br/><br/>
///Specifies the type of the series to render in chart.
///<br/>type-ej.datavisualization.RangeNavigator.Type|string	default-column. see Type
///<br/><br/>
///Enable/disable the animation of series.
///<br/>enableAnimation-boolean	default-false
///<br/><br/>
///Fill color of the series.
///<br/>fill-string	default-null
///<br/><br/>
///Toggles the redrawing of chart on moving the sliders.
///<br/>enableDeferredUpdate-boolean	default-true
///<br/><br/>
///Enable the scrollbar option in the rangenavigator.
///<br/>enableScrollbar-boolean	default-false
///<br/><br/>
///Enable the resize option in the rangenavigator.
///<br/>enableAutoResizing-boolean	default-false
///<br/><br/>
///Toggles the direction of rendering the range navigator control.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Sets a value whether to make the range navigator responsive on resize.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Options for customizing the labels colors, font, style, size, horizontalAlignment and opacity.
///<br/>labelSettings-LabelSettings	default-
///<br/><br/>
///Options for customizing the higher level labels in range navigator.
///<br/>higherLevel-any	default-
///<br/><br/>
///Options for customizing the border of grid lines in higher level.
///<br/>border-any	default-
///<br/><br/>
///Specifies the border color of grid lines.
///<br/>color-string	default-transparent
///<br/><br/>
///Specifies the border width of grid lines.
///<br/>width-string	default-0.5
///<br/><br/>
///Specifies the fill color of higher level labels.
///<br/>fill-string	default-transparent
///<br/><br/>
///Options for customizing the grid line colors, width, dashArray, border.
///<br/>gridLineStyle-any	default-
///<br/><br/>
///Specifies the color of grid lines in higher level.
///<br/>color-string	default-#B5B5B5
///<br/><br/>
///Specifies the dashArray of grid lines in higher level.
///<br/>dashArray-string	default-20 5 0
///<br/><br/>
///Specifies the width of grid lines in higher level.
///<br/>width-string	default-#B5B5B5
///<br/><br/>
///Specifies the intervalType for higher level labels. See 
///<br/>intervalType-ej.datavisualization.RangeNavigator.IntervalType|string	default-auto
///<br/><br/>
///Specifies the position of the labels to render either inside or outside of plot area
///<br/>labelPlacement-ej.datavisualization.RangeNavigator.LabelPlacement|string	default-outside
///<br/><br/>
///Specifies to hide the labels when it intersects with each other.
///<br/>labelIntersectAction-ej.datavisualization.RangeNavigator.LabelIntersectAction|string	default-none
///<br/><br/>
///Specifies the position of the labels in higher level
///<br/>position-ej.datavisualization.RangeNavigator.Position|string	default-top
///<br/><br/>
///Options for customizing the style of higher level labels.
///<br/>style-any	default-
///<br/><br/>
///Options for customizing the font properties.
///<br/>font-any	default-
///<br/><br/>
///Specifies the label font color. Labels render with the specified font color.
///<br/>color-string	default-black
///<br/><br/>
///Specifies the label font family. Labels render with the specified font family.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Specifies the label font style. Labels render with the specified font style.
///<br/>fontStyle-string	default-Normal
///<br/><br/>
///Specifies the label font weight. Labels render with the specified font weight.
///<br/>fontWeight-string	default-regular
///<br/><br/>
///Specifies the label opacity. Labels render with the specified opacity.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the label font size. Labels render with the specified font size.
///<br/>size-string	default-12px
///<br/><br/>
///Specifies the horizontal text alignment of the text in label.
///<br/>horizontalAlignment-string	default-middle
///<br/><br/>
///Toggles the visibility of higher level labels.
///<br/>visible-boolean	default-true
///<br/><br/>
///Options for customizing the labels in lower level.
///<br/>lowerLevel-any	default-
///<br/><br/>
///Options for customizing the border of grid lines in lower level.
///<br/>border-any	default-
///<br/><br/>
///Specifies the border color of grid lines.
///<br/>color-string	default-transparent
///<br/><br/>
///Specifies the border width of grid lines.
///<br/>width-string	default-0.5
///<br/><br/>
///Specifies the fill color of labels in lower level.
///<br/>fill-string	default-transparent
///<br/><br/>
///Options for customizing the grid lines in lower level.
///<br/>gridLineStyle-any	default-
///<br/><br/>
///Specifies the color of grid lines in lower level.
///<br/>color-string	default-#B5B5B5
///<br/><br/>
///Specifies the dashArray of gridLines in lowerLevel.
///<br/>dashArray-string	default-20 5 0
///<br/><br/>
///Specifies the width of grid lines in lower level.
///<br/>width-string	default-#B5B5B5
///<br/><br/>
///Specifies the intervalType of the labels in lower level.See IntervalType
///<br/>intervalType-ej.datavisualization.RangeNavigator.IntervalType|string	default-auto
///<br/><br/>
///Specifies the position of the labels to render either inside or outside of plot area. See LabelPlacement
///<br/>labelPlacement-ej.datavisualization.RangeNavigator.LabelPlacement|string	default-outside
///<br/><br/>
///Specifies to hide the labels when it intersects with each other.
///<br/>labelIntersectAction-ej.datavisualization.RangeNavigator.LabelIntersectAction|string	default-none
///<br/><br/>
///Specifies the position of the labels in lower level.See Position
///<br/>position-ej.datavisualization.RangeNavigator.Position|string	default-bottom
///<br/><br/>
///Options for customizing the style of labels.
///<br/>style-any	default-
///<br/><br/>
///Options for customizing the font of labels.
///<br/>font-any	default-
///<br/><br/>
///Specifies the color of labels. Label text render in this specified color.
///<br/>color-string	default-black
///<br/><br/>
///Specifies the font family of labels. Label text render in this specified font family.
///<br/>fontFamily-string	default-Segoe UI
///<br/><br/>
///Specifies the font style of labels. Label text render in this specified font style.
///<br/>fontStyle-string	default-Normal
///<br/><br/>
///Specifies the font weight of labels. Label text render in this specified font weight.
///<br/>fontWeight-string	default-regular
///<br/><br/>
///Specifies the opacity of labels. Label text render in this specified opacity.
///<br/>opacity-string	default-12px
///<br/><br/>
///Specifies the size of labels. Label text render in this specified size.
///<br/>size-string	default-12px
///<br/><br/>
///Specifies the horizontal text alignment of the text in label.
///<br/>horizontalAlignment-string	default-middle
///<br/><br/>
///Toggles the visibility of labels in lower level.
///<br/>visible-boolean	default-true
///<br/><br/>
///Options for customizing the style of labels in range navigator.
///<br/>style-any	default-
///<br/><br/>
///Options for customizing the font of labels in range navigator.
///<br/>font-any	default-
///<br/><br/>
///Specifies the label color. This color is applied to the labels in range navigator.
///<br/>color-string	default-#333333
///<br/><br/>
///Specifies the label font family. Labels render with the specified font family.
///<br/>family-string	default-Segoe UI
///<br/><br/>
///Specifies the label font opacity. Labels render with the specified font opacity.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the label font size. Labels render with the specified font size.
///<br/>size-string	default-1px
///<br/><br/>
///Specifies the label font style. Labels render with the specified font style..
///<br/>style-ej.datavisualization.RangeNavigator.FontStyle|string	default-Normal
///<br/><br/>
///Specifies the label font weight
///<br/>weight-ej.datavisualization.RangeNavigator.FontWeight|string	default-regular
///<br/><br/>
///Specifies the horizontalAlignment of the label in RangeNavigator
///<br/>horizontalAlignment-ej.datavisualization.RangeNavigator.HorizontalAlignment|string	default-middle
///<br/><br/>
///This property is to specify the localization of range navigator.
///<br/>locale-string	default-en-US
///<br/><br/>
///Options for customizing the range navigator.
///<br/>navigatorStyleSettings-NavigatorStyleSettings	default-
///<br/><br/>
///Specifies the background color of range navigator.
///<br/>background-string	default-#dddddd
///<br/><br/>
///Options for customizing the border color and width of range navigator.
///<br/>border-any	default-
///<br/><br/>
///Specifies the border color of range navigator.
///<br/>color-string	default-transparent
///<br/><br/>
///Specifies the dash array of range navigator.
///<br/>dashArray-string	default-null
///<br/><br/>
///Specifies the border width of range navigator.
///<br/>width-number	default-0.5
///<br/><br/>
///Specifies the left side thumb template in range navigator we can give either div id or HTML string
///<br/>leftThumbTemplate-string	default-null
///<br/><br/>
///Options for customizing the major grid lines.
///<br/>majorGridLineStyle-any	default-
///<br/><br/>
///Specifies the color of major grid lines in range navigator.
///<br/>color-string	default-#B5B5B5
///<br/><br/>
///Toggles the visibility of major grid lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Options for customizing the minor grid lines.
///<br/>minorGridLineStyle-any	default-
///<br/><br/>
///Specifies the color of minor grid lines in range navigator.
///<br/>color-string	default-#B5B5B5
///<br/><br/>
///Toggles the visibility of minor grid lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Specifies the opacity of RangeNavigator.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the right side thumb template in range navigator we can give either div id or HTML string
///<br/>rightThumbTemplate-string	default-null
///<br/><br/>
///Specifies the color of the selected region in range navigator.
///<br/>selectedRegionColor-string	default-#EFEFEF
///<br/><br/>
///Specifies the opacity of Selected Region.
///<br/>selectedRegionOpacity-number	default-0
///<br/><br/>
///Specifies the color of the thumb in range navigator.
///<br/>thumbColor-string	default-#2382C3
///<br/><br/>
///Specifies the radius of the thumb in range navigator.
///<br/>thumbRadius-number	default-10
///<br/><br/>
///Specifies the stroke color of the thumb in range navigator.
///<br/>thumbStroke-string	default-#303030
///<br/><br/>
///Specifies the color of the unselected region in range navigator.
///<br/>unselectedRegionColor-string	default-#5EABDE
///<br/><br/>
///Specifies the opacity of Unselected Region.
///<br/>unselectedRegionOpacity-number	default-0.3
///<br/><br/>
///Contains the options for highlighting the range navigator on mouse over.
///<br/>highlightSettings-any	default-
///<br/><br/>
///Enable the highlight settings in range navigator.
///<br/>enable-boolean	default-false
///<br/><br/>
///To set the color to the highlight.
///<br/>color-string	default-null
///<br/><br/>
///To set the opacity to the highlight.
///<br/>opacity-number	default-0.5
///<br/><br/>
///Contains the border properties for highlighting rectangle.
///<br/>border-any	default-
///<br/><br/>
///To set the border color to the highlight.
///<br/>color-string	default-null
///<br/><br/>
///To set the border width to the highlight.
///<br/>width-number	default-1
///<br/><br/>
///Contains the options for selection the range navigator on mouse over.
///<br/>selectionSettings-any	default-
///<br/><br/>
///Enable the selection settings in range navigator.
///<br/>enable-boolean	default-false
///<br/><br/>
///To set the color to the selection.
///<br/>color-string	default-null
///<br/><br/>
///To set the opacity to the selection.
///<br/>opacity-number	default-0.5
///<br/><br/>
///Contains the border properties for selecting the rectangle.
///<br/>border-any	default-
///<br/><br/>
///To set the border color to the selection.
///<br/>color-string	default-null
///<br/><br/>
///To set the border width to the selection.
///<br/>width-number	default-1
///<br/><br/>
///Padding specifies the gap between the container and the range navigator.
///<br/>padding-string	default-0
///<br/><br/>
///If the range is not given explicitly, range will be calculated automatically.
///<br/>rangePadding-ej.datavisualization.RangeNavigator.RangePadding|string	default-none
///<br/><br/>
///Options for customizing the starting and ending ranges.
///<br/>rangeSettings-RangeSettings	default-
///<br/><br/>
///Specifies the ending range of range navigator.
///<br/>end-string	default-null
///<br/><br/>
///Specifies the starting range of range navigator.
///<br/>start-string	default-null
///<br/><br/>
///selectedData is for getting the data when the "rangeChanged" event trigger from client side.
///<br/>selectedData-any	default-
///<br/><br/>
///Options for customizing the start and end range values.
///<br/>selectedRangeSettings-SelectedRangeSettings	default-
///<br/><br/>
///Specifies the ending range of range navigator.
///<br/>end-string	default-null
///<br/><br/>
///Specifies the starting range of range navigator.
///<br/>start-string	default-null
///<br/><br/>
///Options for rendering scrollbar based on the start and end range values.
///<br/>scrollRangeSettings-ScrollRangeSettings	default-
///<br/><br/>
///Specifies the ending range of range navigator scrollbar and that should be greater than the rangenavigator datasource end value.
///<br/>end-string	default-null
///<br/><br/>
///Specifies the starting range of range navigator scrollbar and that should be less than the rangenavigator datasource start value.
///<br/>start-string	default-null
///<br/><br/>
///Contains property to customize the hight and width of range navigator.
///<br/>sizeSettings-SizeSettings	default-
///<br/><br/>
///Specifies height of the range navigator.
///<br/>height-string	default-null
///<br/><br/>
///Specifies width of the range navigator.
///<br/>width-string	default-null
///<br/><br/>
///By specifying this property the user can change the theme of the range navigator.
///<br/>theme-string	default-null
///<br/><br/>
///Options for customizing the tooltip in range navigator.
///<br/>tooltipSettings-TooltipSettings	default-
///<br/><br/>
///Specifies the background color of tooltip.
///<br/>backgroundColor-string	default-#303030
///<br/><br/>
///Options for customizing the font in tooltip.
///<br/>font-any	default-
///<br/><br/>
///Specifies the color of text in tooltip. Tooltip text render in the specified color.
///<br/>color-string	default-#FFFFFF
///<br/><br/>
///Specifies the font family of text in tooltip. Tooltip text render in the specified font family.
///<br/>family-string	default-Segoe UI
///<br/><br/>
///Specifies the font style of text in tooltip. Tooltip text render in the specified font style.
///<br/>fontStyle-string	default-ej.datavisualization.RangeNavigator.fontStyle.Normal
///<br/><br/>
///Specifies the opacity of text in tooltip. Tooltip text render in the specified opacity.
///<br/>opacity-number	default-1
///<br/><br/>
///Specifies the size of text in tooltip. Tooltip text render in the specified size.
///<br/>size-string	default-10px
///<br/><br/>
///Specifies the weight of text in tooltip. Tooltip text render in the specified weight.
///<br/>weight-string	default-ej.datavisualization.RangeNavigator.weight.Regular
///<br/><br/>
///Specifies the format of text to be displayed in tooltip.
///<br/>labelFormat-string	default-MM/dd/yyyy
///<br/><br/>
///Specifies the mode of displaying the tooltip. Neither to display the tooltip always nor on demand.
///<br/>tooltipDisplayMode-string	default-null
///<br/><br/>
///Toggles the visibility of tooltip.
///<br/>visible-boolean	default-true
///<br/><br/>
///Options for configuring minor grid lines, major grid lines, axis line of axis.
///<br/>valueAxisSettings-ValueAxisSettings	default-
///<br/><br/>
///Options for customizing the axis line.
///<br/>axisLine-any	default-
///<br/><br/>
///Toggles the visibility of axis line.
///<br/>visible-string	default-none
///<br/><br/>
///Options for customizing the font of the axis.
///<br/>font-any	default-
///<br/><br/>
///Text in axis render with the specified size.
///<br/>size-string	default-0px
///<br/><br/>
///Options for customizing the major grid lines.
///<br/>majorGridLines-any	default-
///<br/><br/>
///Toggles the visibility of major grid lines.
///<br/>visible-boolean	default-false
///<br/><br/>
///Options for customizing the major tick lines in axis.
///<br/>majorTickLines-any	default-
///<br/><br/>
///Specifies the size of the majorTickLines in range navigator
///<br/>size-number	default-0
///<br/><br/>
///Toggles the visibility of major tick lines.
///<br/>visible-boolean	default-true
///<br/><br/>
///Specifies width of the major tick lines.
///<br/>width-number	default-0
///<br/><br/>
///You can customize the range of the axis by setting minimum , maximum and interval.
///<br/>range-any	default-
///<br/><br/>
///Default Value
///<br/>min-number	default-null
///<br/><br/>
///Default Value
///<br/>max-number	default-null
///<br/><br/>
///Default Value
///<br/>interval-number	default-null
///<br/><br/>
///If the range is not given explicitly, range will be calculated automatically. You can customize the automatic range calculation using rangePadding.
///<br/>rangePadding-string	default-none
///<br/><br/>
///Toggles the visibility of axis in range navigator.
///<br/>visible-boolean	default-false
///<br/><br/>
///You can plot data of type date time or numeric. This property determines the type of data that this axis will handle.
///<br/>valueType-ej.datavisualization.RangeNavigator.ValueType|string	default-datetime
///<br/><br/>
///Specifies the xName for dataSource. This is used to take the x values from dataSource
///<br/>xName-any	default-
///<br/><br/>
///Specifies the yName for dataSource. This is used to take the y values from dataSource
///<br/>yName-any	default-
///<br/><br/>
///This property determines the factor by which the axis is scaled. Value must be specified between 0 and 1.
///<br/>zoomSettings.zoomFactor-string	default-1
///<br/><br/>
///This property determines the starting position of the zoomed axis. Value must be specified between 0 and 1.
///<br/>zoomSettings.zoomPosition-string	default-0
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Rating:function(){
 /// <signature>
 /// <summary>Constructor of ej.Rating</summary>
 /// </signature>
}
});
ej.Rating=(function(){
var original=ej.Rating
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// Destroy the Rating widget all events bound will be unbind automatically and bring the control to pre-init state.
/// </summary>
},
getValue:function(){
/// <signature>
/// <summary>
/// To get the current value of rating control.
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// To hide the rating control.
/// </summary>
},
refresh:function(){
/// <signature>
/// <summary>
/// User can refresh the rating control to identify changes.
/// </summary>
},
reset:function(){
/// <signature>
/// <summary>
/// To reset the rating value.
/// </summary>
},
setValue:function(value){
/// <signature>
/// <summary>
/// To set the rating value.
/// </summary>
/// <param name="value"	type="string|number">Specifies the rating value.</param>
/// </signature>
},
show:function(){
/// <signature>
/// <summary>
/// To show the rating control
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRating=function(){
this.data("ejRating",new	ej.Rating());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRating :function (options) {
/// <signature>
/// <summary><br/>
///The Rating control provides an intuitive Rating experience that enables you to select a number of stars that represent a Rating. You can configure the item size, orientation and the number of displayed items in the Rating control. You can also customize the Rating star image by using custom CSS.<br/><br/>
///Enables the rating control with reset button.It can be used to reset the rating control value.
///<br/>allowReset-boolean	default-true
///<br/><br/>
///Specify the CSS class to achieve custom theme.
///<br/>cssClass-string	default-
///<br/><br/>
///When this property is set to false, it disables the rating control.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Save current model value to browser cookies for state maintenance. While refresh the page Rating control values are retained.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Specifies the height of the Rating control wrapper.
///<br/>height-string	default-null
///<br/><br/>
///Specifies the list of HTML attributes to be added to rating control.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Specifies the value to be increased while navigating between shapes(stars) in Rating control.
///<br/>incrementStep-number	default-1
///<br/><br/>
///Allow to render the maximum number of Rating shape(star).
///<br/>maxValue-number	default-5
///<br/><br/>
///Allow to render the minimum number of Rating shape(star).
///<br/>minValue-number	default-0
///<br/><br/>
///Specifies the orientation of Rating control. See Orientation
///<br/>orientation-ej.Orientation|string	default-ej.Rating.Orientation.Horizontal
///<br/><br/>
///Helps to provide more precise ratings.Rating control supports three precision modes - full, half, and exact. See Precision
///<br/>precision-ej.Rating.Precision|string	default-full
///<br/><br/>
///Interaction with Rating control can be prevented by enabling this API.
///<br/>readOnly-boolean	default-false
///<br/><br/>
///To specify the height of each shape in Rating control.
///<br/>shapeHeight-number	default-23
///<br/><br/>
///To specify the width of each shape in Rating control.
///<br/>shapeWidth-number	default-23
///<br/><br/>
///Enables the tooltip option.Currently selected value will be displayed in tooltip.
///<br/>showTooltip-boolean	default-true
///<br/><br/>
///To specify the number of stars to be selected while rendering.
///<br/>value-number	default-1
///<br/><br/>
///Specifies the width of the Rating control wrapper.
///<br/>width-string	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
RecurrenceEditor:function(){
 /// <signature>
 /// <summary>Constructor of ej.RecurrenceEditor</summary>
 /// </signature>
}
});
ej.RecurrenceEditor=(function(){
var original=ej.RecurrenceEditor
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

getRecurrenceRule:function(){
/// <signature>
/// <summary>
/// Generates the recurrence rule with the options selected within the Recurrence Editor.
/// </summary>
},
recurrenceDateGenerator:function(recurrenceString, startDate){
/// <signature>
/// <summary>
/// Generates the collection of date, that lies within the selected recurrence start and end date for which the recurrence pattern applies.
/// </summary>
/// <param name="recurrenceString"	type="string">It refers the recurrence rule.</param>
/// </signature>
/// <signature>
/// <summary>
/// Generates the collection of date, that lies within the selected recurrence start and end date for which the recurrence pattern applies.
/// </summary>
/// <param name="startDate"	type="any">It refers the start date of the recurrence.</param>
/// </signature>
},
recurrenceRuleSplit:function(recurrenceRule, exDate){
/// <signature>
/// <summary>
/// It splits and returns the recurrence rule string into object collection.
/// </summary>
/// <param name="recurrenceRule"	type="string">It refers the recurrence rule string.</param>
/// </signature>
/// <signature>
/// <summary>
/// It splits and returns the recurrence rule string into object collection.
/// </summary>
/// <param name="exDate"	type="any">It refers the appointment dates (ExDate) to be excluded</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRecurrenceEditor=function(){
this.data("ejRecurrenceEditor",new	ej.RecurrenceEditor());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRecurrenceEditor :function (options) {
/// <signature>
/// <summary><br/>
///The Recurrence Editor includes the entire recurrence related information in a separate portable manner which can be either utilized as a separate widget or else can be embed within the appointment window of Scheduler to enable recurrence options within it. The recurrence rule can be easily generated based on the frequency selected. The customizations like changing the labels of the Recurrence Editor is also possible to achieve through its properties. The frequencies available are Never, Daily, Weekly, Monthly, Yearly and Every weekday.<br/><br/>
///Defines the collection of recurrence frequencies within Recurrence Editor such as Never, Daily, Weekly, Monthly, Yearly and Every Weekday.
///<br/>frequencies-Array&lt;any&gt;	default-[never, daily, weekly, monthly, yearly, everyweekday]
///<br/><br/>
///Sets the starting day of the week.
///<br/>firstDayOfWeek-string	default-null
///<br/><br/>
///When set to true, enables the spin button of numeric textboxes within the Recurrence Editor.
///<br/>enableSpinners-boolean	default-true
///<br/><br/>
///Sets the start date of the recurrence. The Recurrence Editor initially displays the current date as its start date.
///<br/>startDate-any	default-new Date()
///<br/><br/>
///Sets the specific culture to the Recurrence Editor.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the date format for the datepickers available within the Recurrence Editor.
///<br/>dateFormat-string	default-
///<br/><br/>
///When set to true, renders the Recurrence Editor options from Right-to-Left direction.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Sets the active/current repeat type(frequency) on Recurrence Editor based on the index value provided. For example, setting the value 1 will initially set the repeat type as Daily and display its related options.
///<br/>selectedRecurrenceType-number	default-0
///<br/><br/>
///Sets the minimum date limit to display on the datepickers defined within the Recurrence Editor. Setting minDate with specific date value disallows the datepickers within  Recurrence Editor to navigate beyond that date.
///<br/>minDate-any	default-new Date(1900, 01, 01)
///<br/><br/>
///Sets the maximum date limit to display on the datepickers used within the Recurrence Editor. Setting maxDate with specific date value disallows the datepickers within the Recurrence Editor to navigate beyond that date.
///<br/>maxDate-any	default-new Date(2099, 12, 31)
///<br/><br/>
///Accepts the custom CSS class name, that defines user-defined styles and themes to be applied on partial or complete elements of the Recurrence Editor.
///<br/>cssClass-string	default-
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
ReportDesigner:function(){
 /// <signature>
 /// <summary>Constructor of ej.ReportDesigner</summary>
 /// </signature>
}
});
ej.ReportDesigner=(function(){
var original=ej.ReportDesigner
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addDataSet:function(dataset){
/// <signature>
/// <summary>
/// Add a dataset to the report at runtime.
/// </summary>
/// <param name="dataset"	type="any">a JSON to define a connection properties for dataset.</param>
/// </signature>
},
addDataSource:function(datasource){
/// <signature>
/// <summary>
/// Add a datasource to the report at runtime.
/// </summary>
/// <param name="datasource"	type="any">a JSON to define a connection properties for datasource.</param>
/// </signature>
},
addItem:function(item){
/// <signature>
/// <summary>
/// Add a report item to the report at runtime.
/// </summary>
/// <param name="item"	type="any">JSON for the new report item to be added</param>
/// </signature>
},
bringForward:function(){
/// <signature>
/// <summary>
/// Visually move the selected report item over its closest intersected report items.
/// </summary>
},
bringToFront:function(){
/// <signature>
/// <summary>
/// Visually move the selected report item over all other intersected report items.
/// </summary>
},
canCopy:function(){
/// <signature>
/// <summary>
/// Determines whether a copy operation is possible.
/// </summary>
},
canCut:function(){
/// <signature>
/// <summary>
/// Determines whether a cut operation is possible.
/// </summary>
},
canPaste:function(){
/// <signature>
/// <summary>
/// Determines whether a paste operation is possible.
/// </summary>
},
canRedo:function(){
/// <signature>
/// <summary>
/// Returns the boolean value indicating whether the user can redo the previous action in the report.
/// </summary>
},
canRemove:function(){
/// <signature>
/// <summary>
/// Determines whether a delete operation is possible.
/// </summary>
},
canUndo:function(){
/// <signature>
/// <summary>
/// Returns a boolean value indicating whether the user can undo the previous action in the report.
/// </summary>
},
cloneDataSet:function(name){
/// <signature>
/// <summary>
/// Clone the existing dataset in the report at runtime.
/// </summary>
/// <param name="name"	type="string">Name of the existing dataset.</param>
/// </signature>
},
cloneDataSource:function(name){
/// <signature>
/// <summary>
/// Clone the existing datasource in the report at runtime.
/// </summary>
/// <param name="name"	type="string">Name of the existing datasource.</param>
/// </signature>
},
copy:function(){
/// <signature>
/// <summary>
/// Copies the selected report item from design panel to the Report Designer internal clipboard.
/// </summary>
},
cut:function(){
/// <signature>
/// <summary>
/// Cuts the selected report item from design panel to the Report Designer internal clipboard.
/// </summary>
},
hasReportChanges:function(){
/// <signature>
/// <summary>
/// Returns the boolean value that specifies whether the report has changes or not.
/// </summary>
},
isNewReport:function(){
/// <signature>
/// <summary>
/// Returns the boolean value that specifies whether the currently processing report is a new report or not.
/// </summary>
},
isNewServerReport:function(){
/// <signature>
/// <summary>
/// Returns the boolean value that specifies whether the currently processing report is a new server report or not.
/// </summary>
},
isServerReport:function(){
/// <signature>
/// <summary>
/// Returns the boolean value that specifies whether the currently processing report is obtained from the server or local.
/// </summary>
},
newReport:function(){
/// <signature>
/// <summary>
/// To create a new report.
/// </summary>
},
newServerReport:function(){
/// <signature>
/// <summary>
/// To create a new report in the server.
/// </summary>
},
openReport:function(){
/// <signature>
/// <summary>
/// This method opens the report from the server.
/// </summary>
},
openReportDefinition:function(){
/// <signature>
/// <summary>
/// This method opens the report using raw report data.
/// </summary>
},
openReportFromDevice:function(){
/// <signature>
/// <summary>
/// Opens the client browse dialog to browse the report.
/// </summary>
},
openServerReportDialog:function(){
/// <signature>
/// <summary>
/// Opens the report designer browse dialog to browse the available reports in the reportserver.
/// </summary>
},
paste:function(){
/// <signature>
/// <summary>
/// Pastes the selected report item from the Report Designer internal clipboard to design panel.
/// </summary>
},
redo:function(){
/// <signature>
/// <summary>
/// Reverses the action of the last Undo command.
/// </summary>
},
remove:function(){
/// <signature>
/// <summary>
/// Deletes the selected report item from the report.
/// </summary>
},
removeDataSet:function(dataset){
/// <signature>
/// <summary>
/// Remove a dataset from the report at runtime.
/// </summary>
/// <param name="dataset"	type="string">Name of the dataset.</param>
/// </signature>
},
removeDatasource:function(datasource){
/// <signature>
/// <summary>
/// Remove a datasource from the report at runtime.
/// </summary>
/// <param name="datasource"	type="string">Name of the datasource.</param>
/// </signature>
},
removeItem:function(itemName){
/// <signature>
/// <summary>
/// Remove the given report item from the report.
/// </summary>
/// <param name="itemName"	type="string">Name of the report item to be removed from report</param>
/// </signature>
},
saveReport:function(){
/// <signature>
/// <summary>
/// This method saves the report into the server.
/// </summary>
},
saveReportDefinition:function(){
/// <signature>
/// <summary>
/// This method returns the report in JSON or XML format.
/// </summary>
},
saveServerReportDialog:function(){
/// <signature>
/// <summary>
/// Opens the report designer browse dialog to save the report into server.
/// </summary>
},
saveToDevice:function(){
/// <signature>
/// <summary>
/// To download the designed report.
/// </summary>
},
selectItems:function(itemNames){
/// <signature>
/// <summary>
/// Update the selection to report items at runtime.
/// </summary>
/// <param name="itemNames"	type="any[]">Name of the report items as string array.</param>
/// </signature>
},
sendBackward:function(){
/// <signature>
/// <summary>
/// Visually move the selected report item behind its closest intersected report item.
/// </summary>
},
sendToBack:function(){
/// <signature>
/// <summary>
/// Visually move the selected report item behind all other intersected report items.
/// </summary>
},
showDesign:function(){
/// <signature>
/// <summary>
/// Performs switch action from viewer to designer at runtime.
/// </summary>
},
showNewReportDialog:function(){
/// <signature>
/// <summary>
/// To open the new report dialog.
/// </summary>
},
showOpenSaveReportDialog:function(){
/// <signature>
/// <summary>
/// To open the server browse dialog.
/// </summary>
},
showPreview:function(){
/// <signature>
/// <summary>
/// Performs switch action from designer to viewer at runtime.
/// </summary>
},
undo:function(){
/// <signature>
/// <summary>
/// Reverses the last action that was performed.
/// </summary>
},
updateDataset:function(datasetName, dataset){
/// <signature>
/// <summary>
/// Update the dataset in the report at runtime.
/// </summary>
/// <param name="datasetName"	type="string">Name of the existing dataset.</param>
/// </signature>
/// <signature>
/// <summary>
/// Update the dataset in the report at runtime.
/// </summary>
/// <param name="dataset"	type="any">a JSON to define a connection properties for dataset.</param>
/// </signature>
},
updateDatasource:function(datasourceName, datasource){
/// <signature>
/// <summary>
/// Update the datasource in the report at runtime.
/// </summary>
/// <param name="datasourceName"	type="string">Name of the existing datasource.</param>
/// </signature>
/// <signature>
/// <summary>
/// Update the datasource in the report at runtime.
/// </summary>
/// <param name="datasource"	type="any">a JSON to define a connection properties for datasource.</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejReportDesigner=function(){
this.data("ejReportDesigner",new	ej.ReportDesigner());
return this;
};
intellisense.annotate(jQuery.fn,{
ejReportDesigner :function (options) {
/// <signature>
/// <summary><br/>
///Report Designer allows to design the report that can be published in the server or downloaded in the local physical path.<br/><br/>
///Shows or hides the items of configuration pane in ReportDesigner control.
///<br/>configurePaneSettings-ConfigurePaneSettings	default-
///<br/><br/>
///Shows or hides the grouped items in the configuration pane with the help of enum ej.ReportDesigner.ConfigureItems
///<br/>items-ej.ReportDesigner.ConfigureItems|string	default-ej.ReportDesigner.ConfigureItems.All
///<br/><br/>
///Shows or hides the configuration pane in ReportDesigner control.
///<br/>showConfigurePane-boolean	default-true
///<br/><br/>
///Specifies the locale for report designer.
///<br/>locale-string	default-en-US
///<br/><br/>
///Shows or hides the create, edit, and delete options in data source and dataset panels.
///<br/>permissionSettings-PermissionSettings	default-ej.ReportDesigner.Permission.All
///<br/><br/>
///Shows or hides the create, edit and delete options in data source pane with the help of ej.ReportDesigner.Permission enum.
///<br/>dataSource-ej.ReportDesigner.Permission|string	default-ej.ReportDesigner.Permission.All
///<br/><br/>
///Gets or sets the list of custom data extension items.
///<br/>reportDataExtensions-Array&lt;ReportDataExtensions&gt;	default-[]
///<br/><br/>
///Gets or sets the name of the datasource type.
///<br/>name-string	default-empty
///<br/><br/>
///Gets or sets the class name of the data extension.
///<br/>className-string	default-empty
///<br/><br/>
///Gets or sets the image class name to load image in data pane tile.
///<br/>imageClass-string	default-empty
///<br/><br/>
///Gets or sets the name for data extension item to display in the data pane tile.
///<br/>displayName-string	default-empty
///<br/><br/>
///Gets or sets the list of custom report items.
///<br/>reportItemExtensions-Array&lt;ReportItemExtensions&gt;	default-[]
///<br/><br/>
///Gets or sets the name for the report item.
///<br/>name-string	default-empty
///<br/><br/>
///Gets or sets the class name of the report item.
///<br/>className-string	default-empty
///<br/><br/>
///Gets or sets the image class name to load image in widgets pane tile.
///<br/>imageClass-string	default-empty
///<br/><br/>
///Gets or sets the name for custom report item to display in the widgets pane tile.
///<br/>displayName-string	default-empty
///<br/><br/>
///Gets or sets the category name for the report item.
///<br/>category-string	default-empty
///<br/><br/>
///Gets information to provide content for custom report item tooltip.
///<br/>toolTip-any	default-null
///<br/><br/>
///Gets or sets the report path of server.
///<br/>reportPath-string	default-null
///<br/><br/>
///Gets or sets the report type.
///<br/>reportType-string	default-ej.ReportDesigner.ReportType.RDL
///<br/><br/>
///Gets or sets the reports server URL.
///<br/>reportServerUrl-string	default-null
///<br/><br/>
///Gets or sets the serviceAuthorizationToken to access the Report Server API services.
///<br/>serviceAuthorizationToken-string	default-empty
///<br/><br/>
///Gets or sets the URL of the  WebAPI service; it will be used for processing the report.
///<br/>serviceUrl-string	default-null
///<br/><br/>
///Gets or sets the tenant name of the user groups; it will be used when integrating report designer with server.
///<br/>tenantName-string	default-null
///<br/><br/>
///Defines the settings of the ReportDesigner toolbar.
///<br/>toolbarSettings-ToolbarSettings	default-
///<br/><br/>
///Shows or hides the grouped items in the toolbar with the help of enum ej.ReportDesigner.ToolbarItems.
///<br/>items-ej.ReportDesigner.ToolbarItems|string	default-ej.ReportDesigner.ToolbarItems.All
///<br/><br/>
///Shows or hides the toolbar.
///<br/>showToolbar-boolean	default-true
///<br/><br/>
///Specifies the toolbar template ID.
///<br/>templateId-string	default-empty
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
ReportViewer:function(){
 /// <signature>
 /// <summary>Constructor of ej.ReportViewer</summary>
 /// </signature>
}
});
ej.ReportViewer=(function(){
var original=ej.ReportViewer
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

exportReport:function(){
/// <signature>
/// <summary>
/// Export the report to the specified format.
/// </summary>
},
fitToPage:function(){
/// <signature>
/// <summary>
/// Fit the report page to the container.
/// </summary>
},
fitToPageHeight:function(){
/// <signature>
/// <summary>
/// Fit the report page height to the container.
/// </summary>
},
fitToPageWidth:function(){
/// <signature>
/// <summary>
/// Fit the report page width to the container.
/// </summary>
},
getDataSetNames:function(){
/// <signature>
/// <summary>
/// Get the available datasets name of the rdlc report.
/// </summary>
},
getParameters:function(){
/// <signature>
/// <summary>
/// Get the available parameters of the report.
/// </summary>
},
gotoFirstPage:function(){
/// <signature>
/// <summary>
/// Navigate to first page of report.
/// </summary>
},
gotoLastPage:function(){
/// <signature>
/// <summary>
/// Navigate to last page of the report.
/// </summary>
},
gotoNextPage:function(){
/// <signature>
/// <summary>
/// Navigate to next page from the current page.
/// </summary>
},
gotoPageIndex:function(){
/// <signature>
/// <summary>
/// Go to specific page index of the report.
/// </summary>
},
gotoPreviousPage:function(){
/// <signature>
/// <summary>
/// Navigate to previous page from the current page.
/// </summary>
},
print:function(){
/// <signature>
/// <summary>
/// Print the report.
/// </summary>
},
printLayout:function(){
/// <signature>
/// <summary>
/// Apply print layout to the report.
/// </summary>
},
refresh:function(){
/// <signature>
/// <summary>
/// Refresh the report.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejReportViewer=function(){
this.data("ejReportViewer",new	ej.ReportViewer());
return this;
};
intellisense.annotate(jQuery.fn,{
ejReportViewer :function (options) {
/// <signature>
/// <summary><br/>
///The ReportViewer is a visualization control to view Microsoft SSRS RDL/RDLC files on a web page and it is powered by HTML5/JavaScript. It has support to bind DataSources/Parameters to the Reports and also supports exporting, paging, zooming and printing the report.<br/><br/>
///Gets or sets the list of data sources for the RDLC report.
///<br/>dataSources-Array&lt;DataSources&gt;	default-[]
///<br/><br/>
///Gets or sets the name of the data source.
///<br/>name-string	default-empty
///<br/><br/>
///Gets or sets the values of data source.
///<br/>value-Array&lt;any&gt;	default-[]
///<br/><br/>
///Enables or disables the page cache of report.
///<br/>enablePageCache-boolean	default-false
///<br/><br/>
///Specifies the export settings.
///<br/>exportSettings-ExportSettings	default-
///<br/><br/>
///Specifies the export formats.
///<br/>exportOptions-ej.ReportViewer.ExportOptions|string	default-ej.ReportViewer.ExportOptions.All
///<br/><br/>
///Specifies the excel export format.
///<br/>excelFormat-ej.ReportViewer.ExcelFormats|string	default-ej.ReportViewer.ExcelFormats.Excel97to2003
///<br/><br/>
///Specifies the word export format.
///<br/>wordFormat-ej.ReportViewer.WordFormats|string	default-ej.ReportViewer.WordFormats.Doc
///<br/><br/>
///Specifies the ppt export format.
///<br/>pptFormat-ej.ReportViewer.PPTFormats|string	default-ej.ReportViewer.PPTFormats.PowerPoint97to2003
///<br/><br/>
///Add the custom icon item to the export options.
///<br/>customItems-Array&lt;any&gt;	default-empty
///<br/><br/>
///When set to true, adapts the report layout to fit the screen size of devices on which it renders.
///<br/>isResponsive-boolean	default-true
///<br/><br/>
///Specifies the locale for report viewer.
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the page settings.
///<br/>pageSettings-PageSettings	default-
///<br/><br/>
///Specifies the print layout orientation.
///<br/>orientation-ej.ReportViewer.Orientation|string	default-null
///<br/><br/>
///Specifies the paper size of print layout.
///<br/>paperSize-ej.ReportViewer.PaperSize|string	default-null
///<br/><br/>
///Gets or sets the list of parameters associated with the report.
///<br/>parameters-Array&lt;Parameters&gt;	default-[]
///<br/><br/>
///Gets or sets the parameter labels.
///<br/>labels-Array&lt;any&gt;	default-null
///<br/><br/>
///Gets or sets the name of the parameter.
///<br/>name-string	default-empty
///<br/><br/>
///Gets or sets whether the parameter allows nullable value or not.
///<br/>nullable-boolean	default-false
///<br/><br/>
///Gets or sets the prompt message associated with the specified parameter.
///<br/>prompt-string	default-empty
///<br/><br/>
///Gets or sets the parameter values.
///<br/>values-Array&lt;any&gt;	default-[]
///<br/><br/>
///Specifies the parameter settings.
///<br/>parameterSettings-ParameterSettings	default-
///<br/><br/>
///Sets the separator when the multiSelectMode with delimiter option or checkbox is enabled with the dropdown. When you enter the delimiter value, the texts after the delimiter are considered as a separate word or query. The delimiter string is a single character and must be a symbol. Mostly, the delimiter symbol is used as comma (,) or semi-colon (;) or any other special character.
///<br/>delimiterChar-string	default-,
///<br/><br/>
///Specifies the height of the combobox parameter popup list. By default, the popup height value is "152px".
///<br/>popupHeight-string	default-152px
///<br/><br/>
///Specifies the width of the combobox parameter popup list. By default, the popup width sets based on the width of the component.
///<br/>popupWidth-string	default-auto
///<br/><br/>
///Specifies the width of the parameter item. By default, the item width value is set as "185px".
///<br/>itemWidth-string	default-185px
///<br/><br/>
///Specifies the width of the parameter label. By default, the parameter label width value is set as "110px".
///<br/>labelWidth-string	default-110px
///<br/><br/>
///Enables and disables the print mode.
///<br/>printMode-boolean	default-false
///<br/><br/>
///Specifies the print option of the report.
///<br/>printOption-ej.ReportViewer.PrintOptions|string	default-ej.ReportViewer.PrintOptions.Default
///<br/><br/>
///Specifies the processing mode of the report.
///<br/>processingMode-ej.ReportViewer.ProcessingMode|string	default-ej.ReportViewer.ProcessingMode.Remote
///<br/><br/>
///Specifies the render layout.
///<br/>renderMode-ej.ReportViewer.RenderMode|string	default-ej.ReportViewer.RenderMode.Default
///<br/><br/>
///Gets or sets the path of the report file.
///<br/>reportPath-string	default-empty
///<br/><br/>
///Gets or sets the reports server URL.
///<br/>reportServerUrl-string	default-empty
///<br/><br/>
///Specifies the report Web API service URL.
///<br/>reportServiceUrl-string	default-empty
///<br/><br/>
///Specifies the toolbar settings.
///<br/>toolbarSettings-ToolbarSettings	default-
///<br/><br/>
///Fires when user click on toolbar item in the toolbar.
///<br/>click-string	default-empty
///<br/><br/>
///Specifies the toolbar items.
///<br/>items-ej.ReportViewer.ToolbarItems|string	default-ej.ReportViewer.ToolbarItems.All
///<br/><br/>
///Shows or hides the toolbar.
///<br/>showToolbar-boolean	default-true
///<br/><br/>
///Shows or hides the tooltip of toolbar items.
///<br/>showTooltip-boolean	default-true
///<br/><br/>
///Specifies the toolbar template ID.
///<br/>templateId-string	default-empty
///<br/><br/>
///Add the custom icon item to the toolbar.
///<br/>customItems-Array&lt;any&gt;	default-empty
///<br/><br/>
///Add the custom icon groups to the toolbar.
///<br/>customGroups-Array&lt;any&gt;	default-empty
///<br/><br/>
///Gets or sets the zoom factor for report viewer.
///<br/>zoomFactor-number	default-1
///<br/><br/>
///Specifies the token for authorizing reporting service url to process the reports.
///<br/>serviceAuthorizationToken-string	default-empty
///<br/><br/>
///Enables and disables the parameter block scroller.
///<br/>enableParameterBlockScroller-boolean	default-true
///<br/><br/>
///Enables and disables the data source credential block scroller.
///<br/>enableDatasourceBlockScroller-boolean	default-true
///<br/><br/>
///Render the ReportViewer height based on the report content size.
///<br/>sizeToReportContent-boolean	default-false
///<br/><br/>
///Enables and disables the rendering of Viewer when default values are specified for the parameters.
///<br/>autoRender-boolean	default-true
///<br/><br/>
///Enables and disables the Error Notification bar.
///<br/>enableNotificationBar-boolean	default-true
///<br/><br/>
///Enables and disables the drop-down parameter search.
///<br/>enableDropDownSearch-boolean	default-false
///<br/><br/>
///Enables and disables the PageVirtualization.
///<br/>enablePageVirtualization-boolean	default-false
///<br/><br/>
///Gets or sets the showExceptionsInDialog for report viewer.
///<br/>showExceptionsInDialog-boolean	default-false
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Resizable:function(){
 /// <signature>
 /// <summary>Constructor of ej.Resizable</summary>
 /// </signature>
}
});
ej.Resizable=(function(){
var original=ej.Resizable
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

destroy:function(){
/// <signature>
/// <summary>
/// destroy in the Resizable.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejResizable=function(){
this.data("ejResizable",new	ej.Resizable());
return this;
};
intellisense.annotate(jQuery.fn,{
ejResizable :function (options) {
/// <signature>
/// <summary><br/>
///Plugin to make any DOM element Resizable.<br/><br/>
///Sets the offset of the resizing helper relative to the mouse cursor.
///<br/>cursorAt-any	default-{ top: -1, left: -2 }
///<br/><br/>
///Distance in pixels after mousedown the mouse must move before resizing should start. This option can be used to prevent unwanted drags when clicking on an element.
///<br/>distance-number	default-1
///<br/><br/>
///If specified, restricts resize start click to the specified element(s).
///<br/>handle-string	default-null
///<br/><br/>
///Sets the max height till which an element has to be resized.
///<br/>maxHeight-number	default-null
///<br/><br/>
///Sets the max width till which an element has to be resized.
///<br/>maxWidth-number	default-null
///<br/><br/>
///Sets the min Height below which an element cannot be resized.
///<br/>minHeight-number	default-10
///<br/><br/>
///Sets the min Width below which an element cannot be resized.
///<br/>minWidth-number	default-10
///<br/><br/>
///Used to group sets of resizable items.
///<br/>scope-string	default-&#39;default&#39;
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Ribbon:function(){
 /// <signature>
 /// <summary>Constructor of ej.Ribbon</summary>
 /// </signature>
}
});
ej.Ribbon=(function(){
var original=ej.Ribbon
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addContextualTabs:function(contextualTabSet, index){
/// <signature>
/// <summary>
/// Adds contextual tab or contextual tab set dynamically in the ribbon control with contextual tabs object and index position. When index is null, ribbon contextual tab or contextual tab set is added at the last index.
/// </summary>
/// <param name="contextualTabSet"	type="any">contextual tab or contextual tab set object.</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds contextual tab or contextual tab set dynamically in the ribbon control with contextual tabs object and index position. When index is null, ribbon contextual tab or contextual tab set is added at the last index.
/// </summary>
/// <param name="index"	type="number">index of the contextual tab or contextual tab set, this is optional.</param>
/// </signature>
},
addBackStageItem:function(item, index){
/// <signature>
/// <summary>
/// Add new option to Backstage page.
/// </summary>
/// <param name="item"	type="any">select the object to add the backstage item</param>
/// </signature>
/// <signature>
/// <summary>
/// Add new option to Backstage page.
/// </summary>
/// <param name="index"	type="number">index to the backstage item this is optional.</param>
/// </signature>
},
addTab:function(tabText, ribbonGroups, index){
/// <signature>
/// <summary>
/// Adds tab dynamically in the ribbon control with given name, tab group array and index position. When index is null, ribbon tab is added at the last index.
/// </summary>
/// <param name="tabText"	type="string">ribbon tab display text.</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds tab dynamically in the ribbon control with given name, tab group array and index position. When index is null, ribbon tab is added at the last index.
/// </summary>
/// <param name="ribbonGroups"	type="any[]">groups to be displayed in ribbon tab .</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds tab dynamically in the ribbon control with given name, tab group array and index position. When index is null, ribbon tab is added at the last index.
/// </summary>
/// <param name="index"	type="number">index of the ribbon tab,this is optional.</param>
/// </signature>
},
addTabGroup:function(tabIndex, tabGroup, groupIndex){
/// <signature>
/// <summary>
/// Adds tab group dynamically in the ribbon control with given tab index, tab group object and group index position. When group index is null, ribbon group is added at the last index.
/// </summary>
/// <param name="tabIndex"	type="number">ribbon tab index.</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds tab group dynamically in the ribbon control with given tab index, tab group object and group index position. When group index is null, ribbon group is added at the last index.
/// </summary>
/// <param name="tabGroup"	type="any">group to be displayed in ribbon tab .</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds tab group dynamically in the ribbon control with given tab index, tab group object and group index position. When group index is null, ribbon group is added at the last index.
/// </summary>
/// <param name="groupIndex"	type="number">index of the ribbon group,this is optional.</param>
/// </signature>
},
addTabGroupContent:function(tabIndex, groupIndex, content, contentIndex, subGroupIndex){
/// <signature>
/// <summary>
/// Adds group content dynamically in the ribbon control with given tab index, group index, content, content index and sub group index position. When content index is null, content is added at the last index.
/// </summary>
/// <param name="tabIndex"	type="number">ribbon tab index.</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds group content dynamically in the ribbon control with given tab index, group index, content, content index and sub group index position. When content index is null, content is added at the last index.
/// </summary>
/// <param name="groupIndex"	type="number">ribbon group index.</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds group content dynamically in the ribbon control with given tab index, group index, content, content index and sub group index position. When content index is null, content is added at the last index.
/// </summary>
/// <param name="content"	type="any">content to be displayed in the ribbon group.</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds group content dynamically in the ribbon control with given tab index, group index, content, content index and sub group index position. When content index is null, content is added at the last index.
/// </summary>
/// <param name="contentIndex"	type="number">ribbon content index. This is optional. If the value is not given, then by default contentIndex will be considered as 0.</param>
/// </signature>
/// <signature>
/// <summary>
/// Adds group content dynamically in the ribbon control with given tab index, group index, content, content index and sub group index position. When content index is null, content is added at the last index.
/// </summary>
/// <param name="subGroupIndex"	type="number">sub group index in the ribbon group. This is optional. If the value is not given, then by default contentIndex will be considered as 0.</param>
/// </signature>
},
hideBackstage:function(){
/// <signature>
/// <summary>
/// Hides the ribbon backstage page.
/// </summary>
},
collapse:function(){
/// <signature>
/// <summary>
/// Collapses the ribbon tab content.
/// </summary>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroys the ribbon widget. All the events bound using this._on are unbound automatically and the ribbon control is moved to pre-init state.
/// </summary>
},
expand:function(){
/// <signature>
/// <summary>
/// Expands the ribbon tab content.
/// </summary>
},
getTabText:function(index){
/// <signature>
/// <summary>
/// Gets text of the given index tab in the ribbon control.
/// </summary>
/// <param name="index"	type="number">index of the tab item.</param>
/// </signature>
},
hideTab:function(text){
/// <signature>
/// <summary>
/// Hides the given text tab in the ribbon control.
/// </summary>
/// <param name="text"	type="string">text of the tab item.</param>
/// </signature>
},
isEnable:function(text){
/// <signature>
/// <summary>
/// Checks whether the given text tab in the ribbon control is enabled or not.
/// </summary>
/// <param name="text"	type="string">text of the tab item.</param>
/// </signature>
},
isVisible:function(text){
/// <signature>
/// <summary>
/// Checks whether the given text tab in the ribbon control is visible or not.
/// </summary>
/// <param name="text"	type="string">text of the tab item.</param>
/// </signature>
},
removeTab:function(index){
/// <signature>
/// <summary>
/// Removes the given index tab item from the ribbon control.
/// </summary>
/// <param name="index"	type="number">index of tab item.</param>
/// </signature>
},
setTabText:function(tabText, newText){
/// <signature>
/// <summary>
/// Sets new text to the given text tab in the ribbon control.
/// </summary>
/// <param name="tabText"	type="string">current text of the tab item.</param>
/// </signature>
/// <signature>
/// <summary>
/// Sets new text to the given text tab in the ribbon control.
/// </summary>
/// <param name="newText"	type="string">new text of the tab item.</param>
/// </signature>
},
showBackstage:function(){
/// <signature>
/// <summary>
/// Displays the ribbon backstage page.
/// </summary>
},
showTab:function(text){
/// <signature>
/// <summary>
/// Displays the given text tab in the ribbon control.
/// </summary>
/// <param name="text"	type="string">text of the tab item.</param>
/// </signature>
},
updateGroup:function(tabIndex, groupId, contentGroup){
/// <signature>
/// <summary>
/// To customize Group alone in the inside content.
/// </summary>
/// <param name="tabIndex"	type="number">ribbon tab index.</param>
/// </signature>
/// <signature>
/// <summary>
/// To customize Group alone in the inside content.
/// </summary>
/// <param name="groupId"	type="string">group id to be displayed in ribbon tab .</param>
/// </signature>
/// <signature>
/// <summary>
/// To customize Group alone in the inside content.
/// </summary>
/// <param name="contentGroup"	type="any">contentGroup is used in the object</param>
/// </signature>
},
updateBackStageItem:function(index, item){
/// <signature>
/// <summary>
/// Update option in existing Backstage.
/// </summary>
/// <param name="index"	type="number">index to the backstage item</param>
/// </signature>
/// <signature>
/// <summary>
/// Update option in existing Backstage.
/// </summary>
/// <param name="item"	type="any">select the object to add the backstage item</param>
/// </signature>
},
removeTabGroupContent:function(tabIndex, groupText, contentIndex, subGroupIndex){
/// <signature>
/// <summary>
/// To customize whole content from Tab Group.
/// </summary>
/// <param name="tabIndex"	type="number">ribbon tab index.</param>
/// </signature>
/// <signature>
/// <summary>
/// To customize whole content from Tab Group.
/// </summary>
/// <param name="groupText"	type="string">ribbon group text.</param>
/// </signature>
/// <signature>
/// <summary>
/// To customize whole content from Tab Group.
/// </summary>
/// <param name="contentIndex"	type="number">ribbon content index. This is optional. If the value is not given, all content groups will be removed.</param>
/// </signature>
/// <signature>
/// <summary>
/// To customize whole content from Tab Group.
/// </summary>
/// <param name="subGroupIndex"	type="number">sub group index in the ribbon group. This is optional. If the value is not given, all content groups will be removed.</param>
/// </signature>
},
removeBackStageItem:function(index){
/// <signature>
/// <summary>
/// Remove option from Backstage.
/// </summary>
/// <param name="index"	type="number">index to the backstage item</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRibbon=function(){
this.data("ejRibbon",new	ej.Ribbon());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRibbon :function (options) {
/// <signature>
/// <summary><br/>
///The ribbon can be easily configured to the DOM element, such as div. You can create a ribbon with a highly customizable look and feel.<br/><br/>
///Enables the ribbon resize feature.allowResizing is a deprecated property of isResponsive.
///<br/>allowResizing-boolean	default-false
///<br/><br/>
///When set to true, adapts the Ribbon layout to fit the screen size of devices on which it renders.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Specifies the height, width, enableRTL, showRoundedCorner,enabled,cssClass property to the controls in the ribbon commonly andit will work only when those properties are not defined in buttonSettings and content defaults.
///<br/>buttonDefaults-any	default-Object
///<br/><br/>
///Property to enable the ribbon quick access toolbar.
///<br/>showQAT-boolean	default-false
///<br/><br/>
///Sets the root CSS class for Ribbon which allow us to customize the appearance.
///<br/>cssClass-string	default-
///<br/><br/>
///Sets custom setting to the collapsible pin in the ribbon.
///<br/>collapsePinSettings-CollapsePinSettings	default-Object
///<br/><br/>
///Sets tooltip for the collapse pin .
///<br/>toolTip-string	default-null
///<br/><br/>
///Specifies the custom tooltip for collapse pin.Refer to ejRibbon#tabs->groups->content->groups->customToolTip for its inner properties.
///<br/>customToolTip-any	default-Object
///<br/><br/>
///Set enableOnDemand as true to load ribbon tab and backstage contents while corresponding item clicked.
///<br/>enableOnDemand-boolean	default-false
///<br/><br/>
///Set collapsible property as true to render ribbon in initially collapsed state.
///<br/>collapsible-boolean	default-false
///<br/><br/>
///Align content in the ribbon control from right to left by setting the property as true.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Sets custom setting to the expandable pin in the ribbon.
///<br/>expandPinSettings-ExpandPinSettings	default-Object
///<br/><br/>
///Sets tooltip for the expand pin.
///<br/>toolTip-string	default-null
///<br/><br/>
///Specifies the custom tooltip for expand pin.Refer to ejRibbon#tabs->groups->content->groups->customToolTip for its inner properties.
///<br/>customToolTip-any	default-Object
///<br/><br/>
///Specifies the application tab to contain application menu or backstage page in the ribbon control.
///<br/>applicationTab-ApplicationTab	default-Object
///<br/><br/>
///Specifies the ribbon backstage page items.
///<br/>backstageSettings-any	default-Object
///<br/><br/>
///Specifies the display text of application tab.
///<br/>text-string	default-null
///<br/><br/>
///Specifies the height of ribbon backstage page.
///<br/>height-string|number	default-null
///<br/><br/>
///Specifies the width of ribbon backstage page.
///<br/>width-string|number	default-null
///<br/><br/>
///Specifies the ribbon backstage page with its tab and button elements.
///<br/>pages-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the id for ribbon backstage page's tab and button elements.
///<br/>id-string	default-null
///<br/><br/>
///Specifies the text for ribbon backstage page's tab header and button elements.
///<br/>text-string	default-null
///<br/><br/>
///Specifies the type for ribbon backstage page's contents. Set "ej.Ribbon.BackStageItemType.Tab" to render the tab or "ej.Ribbon.BackStageItemType.Button" to render the button.
///<br/>itemType-ej.Ribbon.ItemType|string	default-ej.Ribbon.ItemType.Tab
///<br/><br/>
///Specifies the id of HTML elements like div,ul, etc., as ribbon backstage page's tab content.
///<br/>contentID-string	default-null
///<br/><br/>
///Specifies the separator between backstage page's tab and button elements.
///<br/>enableSeparator-boolean	default-false
///<br/><br/>
///Specifies the width of backstage page header that contains tabs and buttons.
///<br/>headerWidth-string|number	default-null
///<br/><br/>
///Specifies the ID of ul list to create application menu in the ribbon control.
///<br/>menuItemID-string	default-null
///<br/><br/>
///Specifies the menu members, events by using the menu settings for the menu in the application tab.
///<br/>menuSettings-any	default-Object
///<br/><br/>
///Specifies the application menu or backstage page. Specify the type of application tab as "ej.Ribbon.ApplicationTabType.Menu" to render the application menu or "ej.Ribbon.ApplicationTabType.Backstage" to render backstage page in the ribbon control.
///<br/>type-ej.Ribbon.ApplicationTabType|string	default-ej.Ribbon.ApplicationTabType.Menu
///<br/><br/>
///Specifies the contextual tabs and tab set to the ribbon control with the background color and border color. Refer to the tabs section for adding tabs into the contextual tab and contextual tab set.
///<br/>contextualTabs-Array&lt;ContextualTabs&gt;	default-Array
///<br/><br/>
///Specifies the backgroundColor of the contextual tabs and tab set in the ribbon control.
///<br/>backgroundColor-string	default-null
///<br/><br/>
///Specifies the borderColor of the contextual tabs and tab set in the ribbon control.
///<br/>borderColor-string	default-null
///<br/><br/>
///Specifies the tabs to present in the contextual tabs and tab set. Refer to the tabs section for adding tabs into the contextual tabs and tab set.
///<br/>tabs-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the index or indexes to disable the given index tab or indexes tabs in the ribbon control.
///<br/>disabledItemIndex-Array&lt;any&gt;	default-0
///<br/><br/>
///Specifies the index or indexes to enable the given index tab or indexes tabs in the ribbon control.
///<br/>enabledItemIndex-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the index of the ribbon tab to select the given index tab item in the ribbon control.
///<br/>selectedItemIndex-number	default-1
///<br/><br/>
///Specifies the tabs and its groups. Also specifies the control details that has to be placed in the tab area in the ribbon control.
///<br/>tabs-Array&lt;Tabs&gt;	default-Array
///<br/><br/>
///Specifies single group or multiple groups and its contents to each tab in the ribbon control.
///<br/>groups-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the alignment of controls in the groups in 'row' type or 'column' type. Value for row type is "ej.Ribbon.AlignType.Rows" and for column type is "ej.Ribbon.alignType.columns".
///<br/>alignType-ej.Ribbon.AlignType|string	default-ej.Ribbon.AlignType.Rows
///<br/><br/>
///Specifies the Syncfusion button, split button, dropdown list, toggle button, gallery, custom controls to the groups in the ribbon control.
///<br/>content-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the height, width, type, isBig property to the controls in the group commonly.
///<br/>defaults-any	default-Object
///<br/><br/>
///Specifies the controls height such as Syncfusion button,split button,dropdown list,toggle button in the subgroup of  the ribbon tab.
///<br/>height-string|number	default-null
///<br/><br/>
///Specifies the controls width such as Syncfusion button,split button,dropdown list,toggle button in the subgroup of  the ribbon tab.
///<br/>width-string|number	default-null
///<br/><br/>
///Specifies the controls type such as Syncfusion button,split button,dropdown list,toggle button in the subgroup of  the ribbon tab.
///<br/>type-string	default-ej.Ribbon.Type.Button
///<br/><br/>
///Specifies the controls size such as Syncfusion button,split button,dropdown list,toggle button in the subgroup of  the ribbon tab.
///<br/>isBig-boolean	default-false
///<br/><br/>
///Specifies the controls such as Syncfusion button, split button, dropdown list, toggle button, gallery, custom controls in the subgroup of the ribbon tab .
///<br/>groups-Array&lt;any&gt;	default-Array
///<br/><br/>
///When isMobileOnly is true,its shows in mobile toolbar.isResponsive should be true for using this property.
///<br/>isMobileOnly-boolean	default-false
///<br/><br/>
///Specifies the Syncfusion button members, events by using this buttonSettings.
///<br/>buttonSettings-any	default-Object
///<br/><br/>
///It is used to set the count of gallery contents in a row.
///<br/>columns-number	default-null
///<br/><br/>
///Specifies the custom items such as div, table, controls as custom controls with the type "ej.Ribbon.Type.Custom" in the groups.
///<br/>contentID-string	default-null
///<br/><br/>
///Specifies the CSS class property to apply styles to the button, split, dropdown controls in the groups.
///<br/>cssClass-string	default-null
///<br/><br/>
///Specifies the Syncfusion button and menu as gallery extra items.
///<br/>customGalleryItems-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the Syncfusion button members, events by using buttonSettings.
///<br/>buttonSettings-any	default-Object
///<br/><br/>
///Specifies the type as ej.Ribbon.CustomItemType.Menu or ej.Ribbon.CustomItemType.Button to render Syncfusion button and menu.
///<br/>customItemType-ej.Ribbon.CustomItemType|string	default-ej.Ribbon.CustomItemType.Button
///<br/><br/>
///Specifies the custom tooltip for gallery extra item's button. Refer to ejRibbon#tabs->groups->content->groups->customToolTip for its inner properties.
///<br/>customToolTip-any	default-Object
///<br/><br/>
///Specifies the UL list id to render menu as gallery extra item.
///<br/>menuId-string	default-null
///<br/><br/>
///Specifies the Syncfusion menu members, events by using menuSettings.
///<br/>menuSettings-any	default-Object
///<br/><br/>
///Specifies the text for gallery extra item's button.
///<br/>text-string	default-null
///<br/><br/>
///Specifies the tooltip for gallery extra item's button.
///<br/>toolTip-string	default-null
///<br/><br/>
///Provides custom tooltip for button, split button, dropdown list, toggle button, custom controls in the sub groups. Text and HTML support are also provided for title and content.
///<br/>customToolTip-any	default-Object
///<br/><br/>
///Sets content to the custom tooltip. Text and HTML support are provided for content.
///<br/>content-string	default-null
///<br/><br/>
///Sets icon to the custom tooltip content.
///<br/>prefixIcon-string	default-null
///<br/><br/>
///Sets title to the custom tooltip. Text and HTML support are provided for title and the title is in bold for text format.
///<br/>title-string	default-null
///<br/><br/>
///Specifies the Syncfusion dropdown list members, events by using this dropdownSettings.
///<br/>dropdownSettings-any	default-Object
///<br/><br/>
///Specifies the separator to the control that is in row type group. The separator separates the control from the next control in the group. Set "true" to enable the separator.
///<br/>enableSeparator-boolean	default-false
///<br/><br/>
///Sets the count of gallery contents in a row, when the gallery is in expanded state.
///<br/>expandedColumns-number	default-null
///<br/><br/>
///Defines each gallery content.
///<br/>galleryItems-Array&lt;any&gt;	default-Array
///<br/><br/>
///Specifies the Syncfusion button members, events by using buttonSettings.
///<br/>buttonSettings-any	default-Object
///<br/><br/>
///Specifies the custom tooltip for gallery content. Refer to ejRibbon#tabs->groups->content->groups->customToolTip for its inner properties.
///<br/>customToolTip-any	default-Object
///<br/><br/>
///Sets text for the gallery content.
///<br/>text-string	default-null
///<br/><br/>
///Sets tooltip for the gallery content.
///<br/>toolTip-string	default-null
///<br/><br/>
///Specifies the Id for button, split button, dropdown list, toggle button, gallery, custom controls in the sub groups.
///<br/>id-string	default-null
///<br/><br/>
///Specifies the size for button, split button controls. Set "true" for big size and "false" for small size.
///<br/>isBig-boolean	default-null
///<br/><br/>
///Sets the height of each gallery content.
///<br/>itemHeight-string|number	default-null
///<br/><br/>
///Sets the width of each gallery content.
///<br/>itemWidth-string|number	default-null
///<br/><br/>
///Specifies the Syncfusion split button members, events by using this splitButtonSettings.
///<br/>splitButtonSettings-any	default-Object
///<br/><br/>
///Specifies the text for button, split button, toggle button controls in the sub groups.
///<br/>text-string	default-null
///<br/><br/>
///Specifies the Syncfusion toggle button members, events by using toggleButtonSettings.
///<br/>toggleButtonSettings-any	default-Object
///<br/><br/>
///Specifies the tooltip for button, split button, dropdown list, toggle button, custom controls in the sub groups.
///<br/>toolTip-string	default-null
///<br/><br/>
///To add,show and hide controls in Quick Access toolbar.
///<br/>quickAccessMode-ej.Ribbon.QuickAccessMode|string	default-ej.Ribbon.QuickAccessMode.None
///<br/><br/>
///Specifies the type as "ej.Ribbon.Type.Button" or "ej.Ribbon.Type.SplitButton" or "ej.Ribbon.Type.DropDownList" or "ej.Ribbon.Type.ToggleButton" or "ej.Ribbon.Type.Custom" or "ej.Ribbon.Type.Gallery" to render button, split, dropdown, toggle button, gallery, custom controls.
///<br/>type-ej.Ribbon.Type|string	default-ej.Ribbon.Type.Button
///<br/><br/>
///Specifies the ID of custom items to be placed in the groups.
///<br/>contentID-string	default-null
///<br/><br/>
///Specifies the HTML contents to place into the groups.
///<br/>customContent-string	default-null
///<br/><br/>
///Specifies the group expander for groups in the ribbon control. Set "true" to enable the group expander.
///<br/>enableGroupExpander-boolean	default-false
///<br/><br/>
///Sets custom setting to the groups in the ribbon control.
///<br/>groupExpanderSettings-any	default-Object
///<br/><br/>
///Sets tooltip for the group expander of the group.
///<br/>toolTip-string	default-null
///<br/><br/>
///Specifies the custom tooltip for group expander.Refer to ejRibbon#tabs->groups->content->groups->customToolTip for its inner properties.
///<br/>customToolTip-any	default-Object
///<br/><br/>
///Specifies the text to the groups in the ribbon control.
///<br/>text-string	default-null
///<br/><br/>
///Specifies the custom items such as div, table, controls by using the "custom" type.
///<br/>type-string	default-null
///<br/><br/>
///Specifies the ID for each tab's content panel.
///<br/>id-string	default-null
///<br/><br/>
///Specifies the text of the tab in the ribbon control.
///<br/>text-string	default-null
///<br/><br/>
///Gets or sets a value that indicates whether to customizing the user interface (UI) as locale-specific in order to display regional data i.e. in a language and culture specific to a particular country or region and  it will need to use the user's preference.
///<br/>locale-string	default-en-US
///<br/><br/>
///Specifies the width to the ribbon control. You can set width in string or number format.
///<br/>width-string|number	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Rotator:function(){
 /// <signature>
 /// <summary>Constructor of ej.Rotator</summary>
 /// </signature>
}
});
ej.Rotator=(function(){
var original=ej.Rotator
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

disable:function(){
/// <signature>
/// <summary>
/// Disables the Rotator control.
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// Enables the Rotator control.
/// </summary>
},
getIndex:function(){
/// <signature>
/// <summary>
/// This method is used to get the current slide index.
/// </summary>
},
gotoIndex:function(index){
/// <signature>
/// <summary>
/// This method is used to move a slide to the specified index.
/// </summary>
/// <param name="index"	type="number">index of an slide</param>
/// </signature>
},
pause:function(){
/// <signature>
/// <summary>
/// This method is used to pause autoplay.
/// </summary>
},
play:function(){
/// <signature>
/// <summary>
/// This method is used to move slides continuously (or start autoplay) in the specified autoplay direction.
/// </summary>
},
slideNext:function(){
/// <signature>
/// <summary>
/// This method is used to move to the next slide from the current slide. If the current slide is the last slide, then the first slide will be treated as the next slide.
/// </summary>
},
slidePrevious:function(){
/// <signature>
/// <summary>
/// This method is used to move to the previous slide from the current slide. If the current slide is the first slide, then the last slide will be treated as the previous slide.
/// </summary>
},
updateTemplateById:function(index, id){
/// <signature>
/// <summary>
/// This method is used to update/modify the slide content of template rotator by using id based on index value.
/// </summary>
/// <param name="index"	type="number">index of an slide</param>
/// </signature>
/// <signature>
/// <summary>
/// This method is used to update/modify the slide content of template rotator by using id based on index value.
/// </summary>
/// <param name="id"	type="string">id of a new updated slide</param>
/// </signature>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRotator=function(){
this.data("ejRotator",new	ej.Rotator());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRotator :function (options) {
/// <signature>
/// <summary><br/>
///The Rotator control displays a set of slides. Each slide may contain images or images with content, or content with user-defined transition between them.<br/><br/>
///Turns on keyboard interaction with the Rotator items. You must set this property to true to access the following keyboard shortcuts:
///<br/>allowKeyboardNavigation-boolean	default-true
///<br/><br/>
///Sets the animationSpeed of slide transition.
///<br/>animationSpeed-string|number	default-600
///<br/><br/>
///Specifies the animationType type for the Rotator Item. animationType options include slide, fastSlide, slowSlide, and other custom easing animationTypes.
///<br/>animationType-string	default-slide
///<br/><br/>
///Enables the circular mode item rotation.
///<br/>circularMode-boolean	default-true
///<br/><br/>
///Specify the CSS class to Rotator to achieve custom theme.
///<br/>cssClass-string	default-
///<br/><br/>
///Specify the list of data which contains a set of data fields. Each data value is used to render an item for the Rotator.
///<br/>dataSource-any	default-null
///<br/><br/>
///Sets the delay between the Rotator Items move after the slide transition.
///<br/>delay-number	default-500
///<br/><br/>
///Specifies the number of Rotator Items to be displayed.
///<br/>displayItemsCount-string|number	default-1
///<br/><br/>
///Rotates the Rotator Items continuously without user interference.
///<br/>enableAutoPlay-boolean	default-false
///<br/><br/>
///Enables or disables the Rotator control.
///<br/>enabled-boolean	default-true
///<br/><br/>
///Specifies right to left transition of slides.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Defines mapping fields for the data items of the Rotator.
///<br/>fields-Fields	default-null
///<br/><br/>
///Specifies a link for the image.
///<br/>linkAttribute-string	default-
///<br/><br/>
///Specifies where to open a given link.
///<br/>targetAttribute-string	default-
///<br/><br/>
///Specifies a caption for the image.
///<br/>text-string	default-
///<br/><br/>
///Specifies a caption for the thumbnail image.
///<br/>thumbnailText-string	default-
///<br/><br/>
///Specifies the URL for an thumbnail image.
///<br/>thumbnailUrl-string	default-
///<br/><br/>
///Specifies the URL for an image.
///<br/>url-string	default-
///<br/><br/>
///Sets the space between the Rotator Items.
///<br/>frameSpace-string|number	default-
///<br/><br/>
///Resizes the Rotator when the browser is resized.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Specifies the number of Rotator Items to navigate on a single click (next/previous/play buttons). The navigateSteps property value must be less than or equal to the displayItemsCount property value.
///<br/>navigateSteps-string|number	default-1
///<br/><br/>
///Specifies the orientation for the Rotator control, that is, whether it must be rendered horizontally or vertically. See Orientation
///<br/>orientation-ej.Orientation|string	default-ej.Orientation.Horizontal
///<br/><br/>
///Specifies the position of the showPager in the Rotator Item. See PagerPosition
///<br/>pagerPosition-string|ej.Rotator.PagerPosition	default-outside
///<br/><br/>
///Retrieves data from remote data. This property is applicable only when a remote data source is used.
///<br/>query-string	default-null
///<br/><br/>
///If the Rotator Item is an image, you can specify a caption for the Rotator Item. The caption text for each Rotator Item must be set by using the title attribute of the respective tag. The caption cannot be displayed if multiple Rotator Items are present.
///<br/>showCaption-boolean	default-false
///<br/><br/>
///Turns on or off the slide buttons (next and previous) in the Rotator Items. Slide buttons are used to navigate the Rotator Items.
///<br/>showNavigateButton-boolean	default-true
///<br/><br/>
///Turns on or off the pager support in the Rotator control. The Pager is used to navigate the Rotator Items.
///<br/>showPager-boolean	default-true
///<br/><br/>
///Enable play / pause button on rotator.
///<br/>showPlayButton-boolean	default-false
///<br/><br/>
///Turns on or off thumbnail support in the Rotator control. Thumbnail is used to navigate between slides. Thumbnail supports only single slide transition You must specify the source for thumbnail elements through the thumbnailSourceID property.
///<br/>showThumbnail-boolean	default-false
///<br/><br/>
///Sets the height of a Rotator Item.
///<br/>slideHeight-string|number	default-
///<br/><br/>
///Sets the width of a Rotator Item.
///<br/>slideWidth-string|number	default-
///<br/><br/>
///Sets the index of the slide that must be displayed first.
///<br/>startIndex-string|number	default-0
///<br/><br/>
///Pause the auto play while hover on the rotator content.
///<br/>stopOnHover-boolean	default-false
///<br/><br/>
///The template to display the Rotator widget with customized appearance.
///<br/>template-string	default-null
///<br/><br/>
///The templateId enables to bind multiple customized template items in Rotator.
///<br/>templateId-Array&lt;any&gt;	default-null
///<br/><br/>
///Specifies the source for thumbnail elements.
///<br/>thumbnailSourceID-any	default-null
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
RTE:function(){
 /// <signature>
 /// <summary>Constructor of ej.RTE</summary>
 /// </signature>
}
});
ej.RTE=(function(){
var original=ej.RTE
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

createRange:function(){
/// <signature>
/// <summary>
/// Returns the range object.
/// </summary>
},
disable:function(){
/// <signature>
/// <summary>
/// Disables the RTE control.
/// </summary>
},
disableToolbarItem:function(){
/// <signature>
/// <summary>
/// Disables the corresponding tool in the RTE ToolBar.
/// </summary>
},
enable:function(){
/// <signature>
/// <summary>
/// Enables the RTE control.
/// </summary>
},
enableToolbarItem:function(){
/// <signature>
/// <summary>
/// Enables the corresponding tool in the toolbar when the tool is disabled.
/// </summary>
},
executeCommand:function(cmdName, args, textnodeType){
/// <signature>
/// <summary>
/// Performs the action value based on the given command.
/// </summary>
/// <param name="cmdName"	type="string">Command Name.</param>
/// </signature>
/// <signature>
/// <summary>
/// Performs the action value based on the given command.
/// </summary>
/// <param name="args"	type="any">Content to be inserted as argument.</param>
/// </signature>
/// <signature>
/// <summary>
/// Performs the action value based on the given command.
/// </summary>
/// <param name="textnodeType"	type="boolean">Boolean value to specify whether the argument is textNode or not, this is optional.</param>
/// </signature>
},
focus:function(){
/// <signature>
/// <summary>
/// Focuses the RTE control.
/// </summary>
},
getCommandStatus:function(){
/// <signature>
/// <summary>
/// Gets the command status of the selected text based on the given comment in the RTE control.
/// </summary>
},
getDocument:function(){
/// <signature>
/// <summary>
/// Gets the Document from the RTE control.
/// </summary>
},
getHtml:function(){
/// <signature>
/// <summary>
/// Gets the HTML string from the RTE control.
/// </summary>
},
getSelectedHtml:function(){
/// <signature>
/// <summary>
/// Gets the selected HTML string from the RTE control.
/// </summary>
},
getText:function(){
/// <signature>
/// <summary>
/// Gets the content as string from the RTE control.
/// </summary>
},
hide:function(){
/// <signature>
/// <summary>
/// Hides the RTE control.
/// </summary>
},
insertMenuOption:function(){
/// <signature>
/// <summary>
/// Inserts new item to the target contextmenu node.
/// </summary>
},
insertColumn:function(before, cell){
/// <signature>
/// <summary>
/// Add a table column at the right or left of the specified cell
/// </summary>
/// <param name="before"	type="boolean">If itâ€™s true, add a column at the left of the cell, otherwise add a column at the right of the cell</param>
/// </signature>
/// <signature>
/// <summary>
/// Add a table column at the right or left of the specified cell
/// </summary>
/// <param name="cell"	type="JQuery">Column will be added based on the given cell element</param>
/// </signature>
},
insertRow:function(before, cell){
/// <signature>
/// <summary>
/// To add a table row below or above the specified cell.
/// </summary>
/// <param name="before"	type="boolean">If itâ€™s true, add a row before the cell, otherwise add a row after the cell</param>
/// </signature>
/// <signature>
/// <summary>
/// To add a table row below or above the specified cell.
/// </summary>
/// <param name="cell"	type="JQuery">Row will be added based on the given cell element</param>
/// </signature>
},
pasteContent:function(html){
/// <signature>
/// <summary>
/// This method helps to insert/paste the content at the current cursor (caret) position or the selected content to be replaced with our text by passing the value as parameter to the pasteContent method in the Editor.
/// </summary>
/// <param name="html"	type="string">paste content</param>
/// </signature>
},
refresh:function(){
/// <signature>
/// <summary>
/// Refreshes the RTE control.
/// </summary>
},
removeColumn:function(cell){
/// <signature>
/// <summary>
/// Removes the specified table column.
/// </summary>
/// <param name="cell"	type="JQuery">Remove the given column element</param>
/// </signature>
},
removeRow:function(cell){
/// <signature>
/// <summary>
/// Removes the specified table row.
/// </summary>
/// <param name="cell"	type="JQuery">Remove the given row element</param>
/// </signature>
},
removeTable:function(table){
/// <signature>
/// <summary>
/// Deletes the specified table.
/// </summary>
/// <param name="table"	type="JQuery">Remove the given table</param>
/// </signature>
},
removeMenuOption:function(){
/// <signature>
/// <summary>
/// Removes the target menu item from the RTE contextmenu.
/// </summary>
},
removeToolbarItem:function(){
/// <signature>
/// <summary>
/// Removes the given tool from the RTE Toolbar.
/// </summary>
},
selectAll:function(){
/// <signature>
/// <summary>
/// Selects all the contents within the RTE.
/// </summary>
},
selectRange:function(){
/// <signature>
/// <summary>
/// Selects the contents in the given range.
/// </summary>
},
setColorPickerType:function(){
/// <signature>
/// <summary>
/// Sets the color picker model type rendered initially in the RTE control.
/// </summary>
},
setHtml:function(){
/// <signature>
/// <summary>
/// Sets the HTML string from the RTE control.
/// </summary>
},
show:function(){
/// <signature>
/// <summary>
/// Displays the RTE control.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejRTE=function(){
this.data("ejRTE",new	ej.RTE());
return this;
};
intellisense.annotate(jQuery.fn,{
ejRTE :function (options) {
/// <signature>
/// <summary><br/>
///Rich text editor is a component that help you to display or edit the content including tables, hyperlinks, paragraphs, lists, video, and images. The editor supports file and folder management using FileExplorer component.<br/><br/>
///Enables/disables the editing of the content.
///<br/>allowEditing-boolean	default-True
///<br/><br/>
///RTE control can be accessed through the keyboard shortcut keys.
///<br/>allowKeyboardNavigation-boolean	default-True
///<br/><br/>
///When the property is set to true, it focuses the RTE at the time of rendering.
///<br/>autoFocus-boolean	default-false
///<br/><br/>
///Based on the content size, its height is adjusted instead of adding the scrollbar.
///<br/>autoHeight-boolean	default-false
///<br/><br/>
///This API holds configuration setting for paste cleanup behavior.
///<br/>pasteCleanupSettings-PasteCleanupSettings	default-{ listConversion: false, cleanCSS: false,	removeStyles: false, cleanElements: false }
///<br/><br/>
///This API is used to convert the list elements pasted from word document to editor.
///<br/>listConversion-boolean	default-false
///<br/><br/>
///This API is used to clean the unwanted css in the elements pasted from word document to editor.
///<br/>cleanCSS-boolean	default-false
///<br/><br/>
///This API is used to remove all styles in the elements pasted from word document to editor.
///<br/>removeStyles-boolean	default-false
///<br/><br/>
///This API is used to clean the unwanted elements pasted from word document to editor.
///<br/>cleanElements-boolean	default-false
///<br/><br/>
///Sets the colorCode to display the color of the fontColor and backgroundColor in the font tools of the RTE.
///<br/>colorCode-any	default-[000000, FFFFFF, C4C4C4, ADADAD, 595959, 262626, 4f81bd, dbe5f1, b8cce4, 95b3d7, 366092, 244061, c0504d, f2dcdb, e5b9b7, d99694, 953734,632423, 9bbb59, ebf1dd, d7e3bc, c3d69b, 76923c, 4f6128, 8064a2, e5e0ec, ccc1d9, b2a2c7, 5f497a, 3f3151, f79646, fdeada, fbd5b5, fac08f,e36c09, 974806]
///<br/><br/>
///The number of columns given are rendered in the color palate popup.
///<br/>colorPaletteColumns-number	default-6
///<br/><br/>
///The number of rows given are rendered in the color palate popup.
///<br/>colorPaletteRows-number	default-6
///<br/><br/>
///Sets the root class for the RTE theme. This cssClass API helps the usage of custom skinning option for the RTE control by including this root class in CSS.
///<br/>cssClass-string	default-
///<br/><br/>
///Enables/disables the RTE controlâ€™s accessibility or interaction.
///<br/>enabled-boolean	default-True
///<br/><br/>
///When the property is set to true, it returns the encrypted text.
///<br/>enableHtmlEncode-boolean	default-false
///<br/><br/>
///Maintain the values of the RTE after page reload.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///Shows the resize icon and enables the resize option in the RTE.
///<br/>enableResize-boolean	default-True
///<br/><br/>
///Shows the RTE in the RTL direction.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Formats the contents based on the XHTML rules.
///<br/>enableXHTML-boolean	default-false
///<br/><br/>
///Enables the tab key action with the RichTextEditor content.
///<br/>enableTabKeyNavigation-boolean	default-True
///<br/><br/>
///This API allows to enable url and fileName for pdf export.
///<br/>exportToPdfSettings-ExportToPdfSettings	default-null
///<br/><br/>
///This API is used to receive the server-side handler for export related operations.
///<br/>url-string	default-
///<br/><br/>
///Specifies the file name for the exported pdf file.
///<br/>fileName-string	default-
///<br/><br/>
///This API allows to enable url and fileName for word export.
///<br/>exportToWordSettings-ExportToWordSettings	default-null
///<br/><br/>
///This API is used to receive the server-side handler for export related operations.
///<br/>url-string	default-
///<br/><br/>
///Specifies the file name for the exported word file.
///<br/>fileName-string	default-
///<br/><br/>
///Load the external CSS file inside Iframe.
///<br/>externalCSS-string	default-null
///<br/><br/>
///This API allows to enable the file browser support in the RTE control to browse, create, delete and upload the files in the specified current directory.
///<br/>fileBrowser-FileBrowser	default-null
///<br/><br/>
///This API is used to receive the server-side handler for file related operations.
///<br/>ajaxAction-string	default-
///<br/><br/>
///Specifies the file type extension shown in the file browser window.
///<br/>extensionAllow-string	default-
///<br/><br/>
///Specifies the directory to perform operations like create, delete and rename folder and files, and upload the selected files to the current directory.
///<br/>filePath-string	default-
///<br/><br/>
///Sets the fontName in the RTE.
///<br/>fontName-any	default-{text: Segoe UI, value: Segoe UI },{text: Arial, value: Arial,Helvetica,sans-serif },{text: Courier New, value: Courier New,Courier,Monospace },{text: Georgia, value: Georgia,serif },{text: Impact, value: Impact,Charcoal,sans-serif },{text: Lucida Console, value: Lucida Console,Monaco,Monospace },{text: Tahoma, value: Tahoma,Geneva,sans-serif },{text: Times New Roman, value: Times New Roman },{text: Trebuchet MS, value: Trebuchet MS,Helvetica,sans-serif },{text: Verdana, value: Verdana,Geneva,sans-serif}
///<br/><br/>
///Sets the fontSize in the RTE.
///<br/>fontSize-any	default-{ text: 1, value: 1 },{ text: 2 (10pt), value: 2 },{ text: 3 (12pt), value: 3 },{ text: 4 (14pt), value: 4 },{ text: 5 (18pt), value: 5 },{ text: 6 (24pt), value: 6 },{ text: 7 (36pt), value: 7 }
///<br/><br/>
///Sets the format in the RTE.
///<br/>format-string	default-{ text: Paragraph, value: &amp;lt;p&amp;gt;, spriteCssClass: e-paragraph },{ text: Quotation, value: &amp;lt;blockquote&amp;gt;, spriteCssClass: e-quotation },{ text: Heading 1, value: &amp;lt;h1&amp;gt;, spriteCssClass: e-h1 },{ text: Heading 2, value: &amp;lt;h2&amp;gt;, spriteCssClass: e-h2 },{ text: Heading 3, value: &amp;lt;h3&amp;gt;, spriteCssClass: e-h3 },{ text: Heading 4, value: &amp;lt;h4&amp;gt;, spriteCssClass: e-h4 },{ text: Heading 5, value: &amp;lt;h5&amp;gt;, spriteCssClass: e-h5 },{ text: Heading 6, value: &amp;lt;h6&amp;gt;, spriteCssClass: e-h6}
///<br/><br/>
///Defines the height of the RTE textbox.
///<br/>height-string|number	default-370
///<br/><br/>
///Specifies the HTML Attributes of the ejRTE.
///<br/>htmlAttributes-any	default-{}
///<br/><br/>
///Sets the given attributes to the iframe body element.
///<br/>iframeAttributes-any	default-{}
///<br/><br/>
///This API allows the image browser to support in the RTE control to browse, create, delete, and upload the image files to the specified current directory.
///<br/>imageBrowser-ImageBrowser	default-null
///<br/><br/>
///This API is used to receive the server-side handler for the file related operations.
///<br/>ajaxAction-string	default-
///<br/><br/>
///Specifies the file type extension shown in the image browser window.
///<br/>extensionAllow-string	default-
///<br/><br/>
///Specifies the directory to perform operations like create, delete and rename folder and files, and upload the selected images to the current directory.
///<br/>filePath-string	default-
///<br/><br/>
///This API allows to enable the url for connecting to RTE import.
///<br/>importSettings-ImportSettings	default-null
///<br/><br/>
///This API is used to receive the server-side handler for import operations.
///<br/>url-string	default-
///<br/><br/>
///Enables/disables responsive support for the RTE control toolbar items during the window resizing time.
///<br/>isResponsive-boolean	default-false
///<br/><br/>
///Sets the culture in the RTE when you set the localization values are needs to be assigned to the corresponding text as follows.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the maximum height for the RTE outer wrapper element.
///<br/>maxHeight-string|number	default-null
///<br/><br/>
///Sets the maximum length for the RTE outer wrapper element.
///<br/>maxLength-number	default-7000
///<br/><br/>
///Sets the maximum width for the RTE outer wrapper element.
///<br/>maxWidth-string|number	default-null
///<br/><br/>
///Sets the minimum height for the RTE outer wrapper element.
///<br/>minHeight-string|number	default-280
///<br/><br/>
///Sets the minimum width for the RTE outer wrapper element.
///<br/>minWidth-string|number	default-400
///<br/><br/>
///Sets the name in the RTE. When the name value is not initialized, the ID value is assigned to the name.
///<br/>name-string	default-
///<br/><br/>
///Shows ClearAll icon in the RTE footer.
///<br/>showClearAll-boolean	default-false
///<br/><br/>
///Shows the clear format in the RTE footer.
///<br/>showClearFormat-boolean	default-true
///<br/><br/>
///Shows the Custom Table in the RTE.
///<br/>showCustomTable-boolean	default-True
///<br/><br/>
///The showContextMenu property helps to enable custom context menu within editor area.
///<br/>showContextMenu-boolean	default-True
///<br/><br/>
///This API is used to set the default dimensions for the image and video. When this property is set to true, the image and video dialog displays the dimension option.
///<br/>showDimensions-boolean	default-false
///<br/><br/>
///Shows the FontOption in the RTE.
///<br/>showFontOption-boolean	default-True
///<br/><br/>
///Shows footer in the RTE. When the footer is enabled, it displays the HTML tag, word Count, character count, clear format, resize icon and clear all the content icons, by default.
///<br/>showFooter-boolean	default-false
///<br/><br/>
///Shows the HtmlSource in the RTE footer.
///<br/>showHtmlSource-boolean	default-false
///<br/><br/>
///When the cursor is placed or when the text is selected in the RTE, it displays the tag info in the footer.
///<br/>showHtmlTagInfo-boolean	default-True
///<br/><br/>
///Shows the toolbar in the RTE.
///<br/>showToolbar-boolean	default-True
///<br/><br/>
///Counts the total characters and displays it in the RTE footer.
///<br/>showCharCount-boolean	default-True
///<br/><br/>
///Enables or disables rounded corner UI look for RTE.
///<br/>showRoundedCorner-boolean	default-false
///<br/><br/>
///Counts the total words and displays it in the RTE footer.
///<br/>showWordCount-boolean	default-True
///<br/><br/>
///The given number of columns render the insert table pop.
///<br/>tableColumns-number	default-10
///<br/><br/>
///The given number of rows render the insert table pop.
///<br/>tableRows-number	default-8
///<br/><br/>
///Sets the tools in the RTE and gets the inner display order of the corresponding group element. Tools are dependent on the toolsList property.
///<br/>tools-Tools	default-formatStyle: [format],style: [bold, italic, underline, strikethrough],alignment: [justifyLeft, justifyCenter, justifyRight, justifyFull],lists: [unorderedList, orderedList],indenting: [outdent, indent],doAction: [undo, redo],links: [createLink,removeLink],images: [image],media: [video],tables: [createTable, addRowAbove, addRowBelow, addColumnLeft, addColumnRight, deleteRow, deleteColumn, deleteTable]],view:[&#226;€œfullScreen&#226;€,zoomIn,zoomOut],print:[print]
///<br/><br/>
///Specifies the alignment tools and the display order of this tool in the RTE toolbar.
///<br/>alignment-any	default-
///<br/><br/>
///Specifies the casing tools and the display order of this tool in the RTE toolbar.
///<br/>casing-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the clear tools and the display order of this tool in the RTE toolbar.
///<br/>clear-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the clipboard tools and the display order of this tool in the RTE toolbar.
///<br/>clipboard-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the edit tools and the displays tool in the RTE toolbar.
///<br/>edit-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the doAction tools and the display order of this tool in the RTE toolbar.
///<br/>doAction-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the effect of tools and the display order of this tool in RTE toolbar.
///<br/>effects-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the font tools and the display order of this tool in the RTE toolbar.
///<br/>font-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the formatStyle tools and the display order of this tool in the RTE toolbar.
///<br/>formatStyle-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the image tools and the display order of this tool in the RTE toolbar.
///<br/>images-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the indent tools and the display order of this tool in the RTE toolbar.
///<br/>indenting-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the link tools and the display order of this tool in the RTE toolbar.
///<br/>links-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the list tools and the display order of this tool in the RTE toolbar.
///<br/>lists-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the media tools and the display order of this tool in the RTE toolbar.
///<br/>media-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the style tools and the display order of this tool in the RTE toolbar.
///<br/>style-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the table tools and the display order of this tool in the RTE toolbar.
///<br/>tables-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the view tools and the display order of this tool in the RTE toolbar.
///<br/>view-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the print tools and the display order of this tool in the RTE toolbar.
///<br/>print-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the importExport tools and the display order of this tool in the RTE toolbar.
///<br/>importExport-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the customOrderedList tools and the display order of this tool in the RTE toolbar.
///<br/>customOrderedList-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the name for customOrderedList item.
///<br/>name-string	default-
///<br/><br/>
///Specifies the title for customOrderedList item.
///<br/>tooltip-string	default-
///<br/><br/>
///Specifies the styles for customOrderedList item.
///<br/>css-string	default-
///<br/><br/>
///Specifies the text for customOrderedList item.
///<br/>text-string	default-
///<br/><br/>
///Specifies the list style for customOrderedList item.
///<br/>listStyle-string	default-
///<br/><br/>
///Specifies the image for customOrderedList item.
///<br/>listImage-string	default-
///<br/><br/>
///Specifies the customUnOrderedList tools and the display order of this tool in the RTE toolbar.
///<br/>customUnorderedList-Array&lt;any&gt;	default-
///<br/><br/>
///Specifies the name for customUnorderedList item.
///<br/>name-string	default-
///<br/><br/>
///Specifies the title for customUnorderedList item.
///<br/>tooltip-string	default-
///<br/><br/>
///Specifies the styles for customUnorderedList item.
///<br/>css-string	default-
///<br/><br/>
///Specifies the text for customUnorderedList item.
///<br/>text-string	default-
///<br/><br/>
///Specifies the list style for customUnorderedList item.
///<br/>listStyle-string	default-
///<br/><br/>
///Specifies the image for customUnorderedList item.
///<br/>listImage-string	default-
///<br/><br/>
///Specifies the list of groups and order of those groups displayed in the RTE toolbar.  The toolsList property is used to get the root group order and tools property is used to get the inner order of the corresponding groups displayed. When the value is not specified, it gets its default display order and tools.
///<br/>toolsList-Array&lt;any&gt;	default-[formatStyle, font, style, effects, alignment, lists, indenting, clipboard, doAction, clear, links, images, media, tables, casing,view, customTools,print,edit]
///<br/><br/>
///Specifies the overflow mode for RTE responsive toolbar
///<br/>toolbarOverflowMode-ej.RTE.ToolbarOverflowMode|string	default-Popup
///<br/><br/>
///Display the hints for the tools in the Toolbar.
///<br/>tooltipSettings-any	default-{ associate: mouseenter, showShadow: true, position: { stem: { horizontal: left, vertical: top }  }, tip: { size: { width: 5, height: 5 }, isBalloon: false }
///<br/><br/>
///Gets the undo stack limit.
///<br/>undoStackLimit-number	default-50
///<br/><br/>
///The given string value is displayed in the editable area.
///<br/>value-string	default-null
///<br/><br/>
///Sets the jQuery validation rules to the Rich Text Editor.
///<br/>validationRules-any	default-null
///<br/><br/>
///Sets the jQuery validation error message to the Rich Text Editor.
///<br/>validationMessage-any	default-null
///<br/><br/>
///Defines the width of the RTE textbox.
///<br/>width-string|number	default-786
///<br/><br/>
///Increases and decreases the contents zoom range in percentage
///<br/>zoomStep-string|number	default-0.05
///</summary>
///<param name="options" type="Object">
///The widget configuration options
///</param>
///</signature>
}
});
intellisense.annotate(ej,{
Schedule:function(){
 /// <signature>
 /// <summary>Constructor of ej.Schedule</summary>
 /// </signature>
}
});
ej.Schedule=(function(){
var original=ej.Schedule
var wrapper=function(){
var instance = new original();
intellisense.annotate(instance, {

addResource:function(resourceObject, name, index){
/// <signature>
/// <summary>
/// It is used to add the resources dynamically in the scheduler. It renders the resource based on the index if it is available or else it renders this resource at end of all resources.
/// </summary>
/// <param name="resourceObject"	type="any">Resource object which can be defined with all the available options of resources.</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to add the resources dynamically in the scheduler. It renders the resource based on the index if it is available or else it renders this resource at end of all resources.
/// </summary>
/// <param name="name"	type="string">Defines the name of the resource collection to which this object needs to be added.</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to add the resources dynamically in the scheduler. It renders the resource based on the index if it is available or else it renders this resource at end of all resources.
/// </summary>
/// <param name="index"	type="number">It is optional. If it is available, this render the resource at the given specified index location. Else render at end of the all resources.</param>
/// </signature>
},
deleteAppointment:function(data){
/// <signature>
/// <summary>
/// This method is used to delete the appointment based on the guid value or the appointment data passed to it.
/// </summary>
/// <param name="data"	type="string|any">GUID value of an appointment element or an appointment object</param>
/// </signature>
},
destroy:function(){
/// <signature>
/// <summary>
/// Destroys the Schedule widget. All the events bound using this._on are unbound automatically and the control is moved to pre-init state.
/// </summary>
},
exportSchedule:function(action, serverEvent, id){
/// <signature>
/// <summary>
/// Exports the appointments from the Schedule control.
/// </summary>
/// <param name="action"	type="string">It refers the controller action name to redirect. (For MVC)</param>
/// </signature>
/// <signature>
/// <summary>
/// Exports the appointments from the Schedule control.
/// </summary>
/// <param name="serverEvent"	type="string">It refers the server event name.(For ASP)</param>
/// </signature>
/// <signature>
/// <summary>
/// Exports the appointments from the Schedule control.
/// </summary>
/// <param name="id"	type="string|number">Pass the id of an appointment, in case if a single appointment needs to be exported. Otherwise, it takes the null value.</param>
/// </signature>
},
exportToExcel:function(action, serverEvent, type){
/// <signature>
/// <summary>
/// Exports the appointments from the Schedule control and saves it in a Excel file.
/// </summary>
/// <param name="action"	type="string">It refers the controller action name to redirect. (For MVC)</param>
/// </signature>
/// <signature>
/// <summary>
/// Exports the appointments from the Schedule control and saves it in a Excel file.
/// </summary>
/// <param name="serverEvent"	type="string">It refers the server event name.(For ASP)</param>
/// </signature>
/// <signature>
/// <summary>
/// Exports the appointments from the Schedule control and saves it in a Excel file.
/// </summary>
/// <param name="type"	type="boolean">Indicates whether to export all the appointments including or excluding the individual occurrences of the recurrence appointments. </param>
/// </signature>
},
filterAppointments:function(filterConditions){
/// <signature>
/// <summary>
/// Searches and filters the appointments from appointment list of Schedule control.
/// </summary>
/// <param name="filterConditions"	type="any[]">Holds array of one or more conditional objects for filtering the appointments based on it.</param>
/// </signature>
},
getAppointments:function(){
/// <signature>
/// <summary>
/// Gets the complete appointment list of Schedule control.
/// </summary>
},
print:function(data){
/// <signature>
/// <summary>
/// Prints the entire Scheduler or a single appointment based on the appointment data passed as an argument to it. Simply calling the print() method, without passing any argument will print the entire Scheduler.
/// </summary>
/// <param name="data"	type="any">Either accepts no arguments at all or else accepts an appointment object.</param>
/// </signature>
},
refreshScroller:function(){
/// <signature>
/// <summary>
/// Refreshes the Scroller of Scheduler while using it within some other controls or application.
/// </summary>
},
removeResource:function(resourceId, name){
/// <signature>
/// <summary>
/// It is used to remove the resources dynamically from the scheduler. It removed the resource based on the resource id with the given resource collection name.
/// </summary>
/// <param name="resourceId"	type="string|number">Defines the Id of the resource.</param>
/// </signature>
/// <signature>
/// <summary>
/// It is used to remove the resources dynamically from the scheduler. It removed the resource based on the resource id with the given resource collection name.
/// </summary>
/// <param name="name"	type="string">Defines the name of the resource collection which this resource id belongs.</param>
/// </signature>
},
saveAppointment:function(appointmentObject){
/// <signature>
/// <summary>
/// It is used to save the appointment. The appointment object is based on the argument passed to this method.
/// </summary>
/// <param name="appointmentObject"	type="any">appointment object which includes appointment details</param>
/// </signature>
},
getRecurrenceRule:function(){
/// <signature>
/// <summary>
/// Generate the recurrence rule as a string, based on the repeat options selected.
/// </summary>
},
getSlotByElement:function(element){
/// <signature>
/// <summary>
/// Retrieves the time slot information (start/end time and resource details) of the given element. The parameter is optional - as when no element is passed to it, the currently selected cell information will be retrieved. When multiple cells are selected in the Scheduler, it is not necessary to provide the parameter.
/// </summary>
/// <param name="element"	type="any">TD element object rendered as Scheduler work cell</param>
/// </signature>
},
searchAppointments:function(searchString, field, operator, ignoreCase){
/// <signature>
/// <summary>
/// Searches the appointments from the appointment list of Schedule control based on the provided search string in its argument list.
/// </summary>
/// <param name="searchString"	type="any|string">Defines the search word or the filter condition, based on which the appointments are filtered from the list.</param>
/// </signature>
/// <signature>
/// <summary>
/// Searches the appointments from the appointment list of Schedule control based on the provided search string in its argument list.
/// </summary>
/// <param name="field"	type="string">Defines the field name on which the search is to be made.</param>
/// </signature>
/// <signature>
/// <summary>
/// Searches the appointments from the appointment list of Schedule control based on the provided search string in its argument list.
/// </summary>
/// <param name="operator"	type="ej.FilterOperators|string">Defines the filterOperator value for the search operation.</param>
/// </signature>
/// <signature>
/// <summary>
/// Searches the appointments from the appointment list of Schedule control based on the provided search string in its argument list.
/// </summary>
/// <param name="ignoreCase"	type="boolean">Defines the ignoreCase value for performing the search operation.</param>
/// </signature>
},
refresh:function(){
/// <signature>
/// <summary>
/// Refreshes the entire Schedule control.
/// </summary>
},
refreshAppointments:function(){
/// <signature>
/// <summary>
/// Refreshes only the appointment elements within the Schedule control.
/// </summary>
},
notifyChanges:function(){
/// <signature>
/// <summary>
/// Passes the server-side action and data to the client-side for rendering the modified appointment list on the Schedule control.
/// </summary>
},
});
return instance;
};
intellisense.redirectDefinition(wrapper, original);
return wrapper;
})();
jQuery.fn.ejSchedule=function(){
this.data("ejSchedule",new	ej.Schedule());
return this;
};
intellisense.annotate(jQuery.fn,{
ejSchedule :function (options) {
/// <signature>
/// <summary><br/>
///An Event calendar that manages the list of various activities like events/appointments.<br/><br/>
///When set to true, Schedule allows the appointments to be dragged and dropped at required time.
///<br/>allowDragAndDrop-boolean	default-true
///<br/><br/>
///When set to true, allows the user to create/edit appointments inline - simply through a single click made either on the Scheduler cells or on the existing appointmentâ€™s Subject text respectively. Pressing enter key after the new Subject text   typed onto the inline created text box, will save/update the appointments appropriately.
///<br/>allowInline-boolean	default-false
///<br/><br/>
///When set to false, disables the appointment delete option on the Scheduler.
///<br/>allowDelete-boolean	default-true
///<br/><br/>
///When set to true, Scheduler allows interaction through keyboard shortcut keys.
///<br/>allowKeyboardNavigation-boolean	default-true
///<br/><br/>
///It includes the dataSource option and the fields related to Schedule appointments. The appointment fields within the appointmentSettings can accept both string and object type values. To apply validation rules on the appointment window fields, then the appointment fields needs to be defined with object type values.
///<br/>appointmentSettings-AppointmentSettings	default-
///<br/><br/>
///The dataSource option accepts either JSON object collection or DataManager (ej.DataManager) instance that contains Schedule appointments.
///<br/>dataSource-any|Array&lt;any&gt;	default-[]
///<br/><br/>
///It holds either the ej.Query() object or simply the query string that retrieves the specified records from the table.
///<br/>query-string	default-null
///<br/><br/>
///Assign the table name from where the records are to be fetched for the Schedule.
///<br/>tableName-string	default-null
///<br/><br/>
///When set to false, doesn't consider the time difference offset calculation on appointment time.
///<br/>applyTimeOffset-boolean	default-true
///<br/><br/>
///When set to true, introduces a new option to edit only the future occurrences of the appointments in a recurrence series from the currently selected appointment's date.
///<br/>editFutureEventsOnly-boolean	default-false
///<br/><br/>
///Binds the id field name in dataSource to the id of Schedule appointments. It denotes the unique id assigned to appointments.
///<br/>id-string	default-null
///<br/><br/>
///Binds the name of startTime field in the dataSource with start time of the Schedule appointments. It indicates the date and Time when Schedule appointment actually starts.
///<br/>startTime-string	default-null
///<br/><br/>
///Binds the name of endTime field in dataSource with the end time of Schedule appointments. It indicates the date and time when Schedule appointment actually ends.
///<br/>endTime-string	default-null
///<br/><br/>
///Binds the name of subject field in the dataSource to appointment Subject. Indicates the Subject or title that gets displayed on Schedule appointments.
///<br/>subject-string	default-null
///<br/><br/>
///Binds the description field name in dataSource. It indicates the appointment description.
///<br/>description-string	default-null
///<br/><br/>
///Binds the name of recurrence field in dataSource. It indicates whether the appointment is a recurrence appointment or not.
///<br/>recurrence-string	default-null
///<br/><br/>
///Binds the name of recurrenceRule field in dataSource. It indicates the recurrence pattern associated with appointments.
///<br/>recurrenceRule-string	default-null
///<br/><br/>
///Binds the name of allDay field in dataSource. It indicates whether the appointment is an all-day appointment or not.
///<br/>allDay-string	default-null
///<br/><br/>
///Binds one or more fields in resource collection dataSource. It maps the resource field names with appointments denoting the resource of appointments actually belongs.
///<br/>resourceFields-string	default-null
///<br/><br/>
///Binds the name of categorize field in dataSource. It indicates the categorize value, red categorize, green, yellow and so on applied to the appointments.
///<br/>categorize-string	default-null
///<br/><br/>
///Binds the name of location field in dataSource. It indicates the appointment location.
///<br/>location-string	default-null
///<br/><br/>
///Binds the name of the priority field in dataSource. It indicates the priority, high, low, medium and none of the appointments.
///<br/>priority-string	default-null
///<br/><br/>
///Binds the name of start timezone field in dataSource. It indicates the timezone of appointment start date. When startTimeZone field is not mentioned, the appointment uses the Schedule timeZone or System timeZone.
///<br/>startTimeZone-string	default-null
///<br/><br/>
///Binds the name of end timezone field in dataSource. It indicates the timezone of appointment end date. When the endTimeZone field is not mentioned, the appointment uses the Schedule timeZone or System timeZone.
///<br/>endTimeZone-string	default-null
///<br/><br/>
///Template design that applies on the Schedule appointments. All the field names that are mapped from dataSource to the appropriate field properties within the appointmentSettings can be used within the template.
///<br/>appointmentTemplateId-string	default-null
///<br/><br/>
///Accepts the custom CSS class name that defines specific user-defined styles and themes to be applied for partial or complete elements of the Schedule.
///<br/>cssClass-string	default-
///<br/><br/>
///Sets various categorize colors to the Schedule appointments to differentiate it.
///<br/>categorizeSettings-CategorizeSettings	default-
///<br/><br/>
///When set to true, enables the multiple selection of categories to be applied for the appointments.
///<br/>allowMultiple-boolean	default-false
///<br/><br/>
///When set to true, enables the categories option to be applied for the appointments.
///<br/>enable-boolean	default-false
///<br/><br/>
///The dataSource option accepts either the JSON object collection or DataManager [ej.DataManager] instance that contains the categorize data.
///<br/>dataSource-Array&lt;any&gt;|any	default-
///<br/><br/>
///Binds id field name in the dataSource to id of category data.
///<br/>id-string	default-id
///<br/><br/>
///Binds text field name in the dataSource to category text.
///<br/>text-string	default-text
///<br/><br/>
///Binds color field name in the dataSource to category color.
///<br/>color-string	default-color
///<br/><br/>
///Binds fontColor field name in the dataSource to category font.
///<br/>fontColor-string	default-fontColor
///<br/><br/>
///Sets the height for Schedule cells.
///<br/>cellHeight-string	default-20px
///<br/><br/>
///Sets the width for Schedule cells.
///<br/>cellWidth-string	default-
///<br/><br/>
///Holds all options related to the context menu settings of Scheduler.
///<br/>contextMenuSettings-ContextMenuSettings	default-
///<br/><br/>
///When set to true, enables the context menu options available for the Schedule cells and appointments.
///<br/>enable-boolean	default-false
///<br/><br/>
///Contains all the default context menu options that are applicable for both Schedule cells and appointments. It also supports adding custom menu items to cells or appointment collection.
///<br/>menuItems-any	default-
///<br/><br/>
///All the appointment related context menu items are grouped under this appointment menu collection.
///<br/>appointment-Array&lt;any&gt;	default-
///<br/><br/>
///All the Scheduler cell related context menu items are grouped under this cells menu item collection.
///<br/>cells-Array&lt;any&gt;	default-
///<br/><br/>
///Sets current date of the Schedule. The Schedule displays initially with the date that is provided here.
///<br/>currentDate-any	default-new Date()
///<br/><br/>
///Sets current view of the Schedule. Schedule renders initially with the view that is specified here. The available views are day, week, workweek, month, agenda and custom view - from which any one of the required view can be set to the Schedule. It accepts both string or enum values. The enum values that are accepted by currentView(ej.Schedule.CurrentView) are as follows,
///<br/>currentView-string|ej.Schedule.CurrentView	default-ej.Schedule.CurrentView.Week
///<br/><br/>
///Sets the date format for Schedule.
///<br/>dateFormat-string	default-
///<br/><br/>
///When set to true, shows the previous/next appointment navigator button on the Scheduler.
///<br/>showAppointmentNavigator-boolean	default-true
///<br/><br/>
///When set to true, enables the resize behavior of appointments within the Schedule.
///<br/>enableAppointmentResize-boolean	default-true
///<br/><br/>
///When set to true, enables the loading of Schedule appointments based on your demand. With this load on demand concept, the data consumption of the Schedule can be limited.
///<br/>enableLoadOnDemand-boolean	default-false
///<br/><br/>
///Saves the current model value to browser cookies for state maintenance. When the page gets refreshed, Schedule control values are retained.
///<br/>enablePersistence-boolean	default-false
///<br/><br/>
///When set to true, the Schedule layout and behavior changes as per the common RTL conventions.
///<br/>enableRTL-boolean	default-false
///<br/><br/>
///Sets the end hour time limit to be displayed on the Schedule.
///<br/>endHour-number	default-24
///<br/><br/>
///To configure resource grouping on the Schedule.
///<br/>group-Group	default-
///<br/><br/>
///Holds the array of resource names to be grouped on the Schedule.
///<br/>resources-Array&lt;any&gt;	default-
///<br/><br/>
///When set to true, allows performing CRUD actions simultaneously on all the grouped appointments of multiple resources.
///<br/>allowGroupEditing-boolean	default-false
///<br/><br/>
///Sets the height of the Schedule. Accepts both pixel and percentage values.
///<br/>height-string	default-1120px
///<br/><br/>
///To define the work hours within the Schedule control.
///<br/>workHours-WorkHours	default-
///<br/><br/>
///When set to true, highlights the work hours of the Schedule.
///<br/>highlight-boolean	default-true
///<br/><br/>
///Sets the start time to depict the start of working or business hour in a day.
///<br/>start-number	default-9
///<br/><br/>
///Sets the end time to depict the end of working or business hour in a day.
///<br/>end-number	default-18
///<br/><br/>
///When set to true, enables the Schedule to observe Daylight Saving Time for supported timezones.
///<br/>isDST-boolean	default-false
///<br/><br/>
///When set to true, adapts the Schedule layout to fit the screen size of devices on which it renders.
///<br/>isResponsive-boolean	default-true
///<br/><br/>
///Sets the specific culture to the Schedule.
///<br/>locale-string	default-en-US
///<br/><br/>
///Sets the maximum date limit to display on the Schedule. Setting maxDate with specific date value disallows the Schedule to navigate beyond that date.
///<br/>maxDate-any	default-new Date(2099, 12, 31)
///<br/><br/>
///Sets the minimum date limit to display on the Schedule. Setting minDate with specific date value disallows the Schedule to navigate beyond that date.
///<br/>minDate-any	default-new Date(1900, 01, 01)
///<br/><br/>
///Sets the mode of Schedule rendering either in a vertical or horizontal direction. It accepts either string("vertical" or "horizontal") or enum values. The enum values that are accepted by orientation(ej.Schedule.Orientation) are as follows,
///<br/>orientation-string|ej.Schedule.Orientation	default-ej.Schedule.Orientation.Vertical
///<br/><br/>
///Holds all the options related to priority settings of the Schedule.
///<br/>prioritySettings-PrioritySettings	default-
///<br/><br/>
///When set to true, enables the priority options available for the Schedule appointments.
///<br/>enable-boolean	default-false
///<br/><br/>
///The dataSource option can accept the JSON object collection that contains the priority related data.
///<br/>dataSource-any|Array&lt;any&gt;	default-{% highlight js%}[{ text: None, value: none },{ text: High, value: high },{ text: Medium, value: medium },{ text: Low, value: low }]{% endhighlight %}
///<br/><br/>
///Binds text field name in the dataSource to prioritySettings text. These text gets listed out in priority field of the appointment window.
///<br/>text-string	default-text
///<br/><br/>
///Binds value field name in the dataSource to prioritySettings value. These field names usually accepts four priority values by default, high, low, medium and none.
///<br/>value-string	default-value
///<br/><br/>
///Allows priority field customization in the appointment window to add custom icons denoting the priority level for the appointments.
///<br/>template-string	default-null
///<br/><br/>
///When set to true, disables the interaction with the Schedule appointments, simply allowing the date and view navigation to occur.
///<br/>readOnly-boolean	default-false
///<br/><br/>
///Holds all the options related to reminder settings of the Schedule.
///<br/>reminderSettings-ReminderSettings	default-
///<br/><br/>
///When set to true, enables the reminder option available for the Schedule appointments.
///<br/>enable-boolean	default-false
///<br/><br/>
///Sets the timing, when the reminders are to be alerted for the Schedule appointments.
///<br/>alertBefore-number	default-5
///<br/><br/>
///Defines the specific start and end dates to be rendered in the Schedule control. To render such user-specified custom date ranges in the Schedule control, set the currentView property to ej.Schedule.CurrentView.CustomView.
///<br/>renderDates-RenderDates	default-null
///<br/><br/>
///Sets the start of custom date range to be rendered in the Schedule.
///<br/>start-any	default-null
///<br/><br/>
///Sets the end limit of the custom date range.
///<br/>end-any	default-null
///<br/><br/>
///Template design that applies on the Schedule resource header.
///<br/>resourceHeaderTemplateId-string	default-null
///<br/><br/>
///Holds all the options related to the resources settings of the Schedule. It is a collection of one or more resource objects, where the levels of resources are rendered on the Schedule based on the order of the resource data provided within this collection.
///<br/>resources-Array&lt;Resources&gt;	default-null
///<br/><br/>
///It holds the name of the resource field to be bound to the Schedule appointments that contains the resource Id.
///<br/>field-string	default-null
///<br/><br/>
///It holds the title name of the resource field to be displayed on the Schedule appointment window.
///<br/>title-string	default-null
///<br/><br/>
///A unique resource name that is used for differentiating various resource objects while grouping it in various levels.
///<br/>name-string	default-null
///<br/><br/>
///When set to true, allows multiple selection of resource names, thus creating multiple instances of same appointment for the selected resources.
///<br/>allowMultiple-boolean	default-false
///<br/><br/>
///It holds the field names of the resources to be bound to the Schedule and also the dataSource.
///<br/>resourceSettings-any	default-
///<br/><br/>
///The dataSource option accepts either JSON object collection or DataManager (ejDataManager) instance that contains the resources related data.
///<br/>dataSource-any|Array&lt;any&gt;	default-[]
///<br/><br/>
///Binds text field name in the dataSource to resourceSettings text. These text gets listed out in resources field of the appointment window.
///<br/>text-string	default-null
///<br/><br/>
///Binds id field name in the dataSource to resourceSettings id.
///<br/>id-string	default-null
///<br/><br/>
///Binds groupId field name in the dataSource to resourceSettings groupId.
///<br/>groupId-string	default-null
///<br/><br/>
///Binds color field name in the dataSource to resourceSettings color. The color specified here gets applied to the Schedule appointments denoting to the resource it belongs.
///<br/>color-string	default-null
///<br/><br/>
///Binds the starting work hour field name in the dataSource. It's optional, but providing it with some numeric value will set the starting work hour for specific resources.
///<br/>start-string	default-null
///<br/><br/>
///Binds the end work hour field name in the dataSource. It's optional, but providing it with some numeric value will set the end work hour for specific resources.
///<br/>end-string	default-null
///<br/><br/>
///Binds the resources working days field name in the dataSource. It's optional, and accepts the array of strings (week day names). When provided with specific collection of days (array of day names), only those days will render for the specific resources.
///<br/>workWeek-string	default-null
///<br/><br/>
///Binds appointmentClass field name in the dataSource. It applies custom CSS class name to appointments depicting to the resource it belongs.
///<br/>appointmentClass-string	default-null
///<br/><br/>
///When set to true, displays the all-day row cells on the Schedule.
///<br/>showAllDayRow-boolean	default-true
///<br/><br/>
///When set to false, hides the weekend days on all the Scheduler views.
///<br/>showWeekend-boolean	default-true
///<br/><br/>
///When set to true, displays the current time indicator on the Schedule.
///<br/>showCurrentTimeIndicator-boolean	default-true
///<br/><br/>
///When set to true, displays the header bar on the Schedule.
///<br/>showHeaderBar-boolean	default-true
///<br/><br/>
///When set to true, displays the location field additionally on Schedule appointment window.
///<br/>showLocationField-boolean	default-false
///<br/><br/>
///When set to false, doesn't render the start and end timezone fields on the Schedule appointment window.
///<br/>showTimeZoneFields-boolean	default-true
///<br/><br/>
///When set to true, displays the quick window for every single click made on the Schedule cells or appointments.
///<br/>showQuickWindow-boolean	default-true
///<br/><br/>
///Sets the start hour time range to be displayed on the Schedule.
///<br/>startHour-number	default-0
///<br/><br/>
///Sets either 12 or 24 hour time mode on the Schedule. It accepts either the string value("12" or "24") or the below mentioned enum values. The enum values that are accepted by timeMode(ej.Schedule.TimeMode) are as follows,
///<br/>timeMode-string|ej.Schedule.TimeMode	default-null
///<br/><br/>
///Sets the timezone for the Schedule.
///<br/>timeZone-string	default-null
///<br/><br/>
///Sets the collection of timezone items to be bound to the Schedule. Only the items bound to this property gets listed out in the timezone field of the appointment window.
///<br/>timeZoneCollection-TimeZoneCollection	default-
///<br/><br/>
///Sets the collection of timezone items to the dataSource that accepts either JSON object collection or DataManager (ej.DataManager) instance that contains Schedule timezones.
///<br/>dataSource-any	default-
///<br/><br/>
///Binds text field name in the dataSource to timeZoneCollection text. These text gets listed out in the timezone fields of the appointment window.
///<br/>text-string	default-text
///<br/><br/>
///Binds id field name in the dataSource to timeZoneCollection id.
///<br/>id-string	default-id
///<br/><br/>
///Binds value field name in the dataSource to timeZoneCollection value.
///<br/>value-string	default-value
///<br/><br/>
///Defines the view collection to be displayed on the Schedule. By default, it displays all the views namely, Day, Week, WorkWeek and Month.
///<br/>views-Array&lt;any&gt;	default-[Day, Week, WorkWeek, Month, Agenda]
///<br/><br/>
///Sets the width of the Schedule. Accepts both pixel and percentage values.
///<br/>width-string	default-100%
///<br/><br/>
///When set to true, Schedule allows the validation of 