/*!
*  filename: ej.web.all.d.ts
*  version : 17.4.0.39
*  Copyright Syncfusion Inc. 2001 - 2019. All rights reserved.
*  Use of this code is subject to the terms of our license.
*  A copy of the current license can be obtained at any time by e-mailing
*  licensing@syncfusion.com. Any infringement will be prosecuted under
*  applicable laws.
*/
declare namespace ej {
    const dataUtil: dataUtil;
    function isMobile(): boolean;
    function isIOS(): boolean;
    function isAndroid(): boolean;
    function isFlat(): boolean;
    function isWindows(): boolean;
    function isCssCalc(): boolean;
    function getCurrentPage(): JQuery;
    function isLowerResolution(): boolean;
    function browserInfo(): browserInfoOptions;
    function isTouchDevice(): boolean;
    function addPrefix(style: string): string;
    function animationEndEvent(): string;
    function blockDefaultActions(e: any): void;
    function buildTag(tag: string, innerHtml?: string, styles?: any, attrs?: any): JQuery;
    function cancelEvent(): string;
    function copyObject(): string;
    function createObject(nameSpace: string, value: any, initIn: any): JQuery;
    function createObject(element: any, eventEmitter: any, model: any): any;
    function setCulture(culture: string): void;
    function getObject(element: string, model: any): any;
    function getObject(nameSpace: string, fromdata?: any): any;
    function defineClass(className: string, constructor: any, proto: any, replace: boolean): any;
    function destroyWidgets(element: any): void;
    function endEvent(): string;
    function event(type: string, data: any, eventProp: any): any;
    function getAndroidVersion(): any;
    function getAttrVal(ele: any, val: string, option: any): any;
    function getBooleanVal(ele: any, val: string, option: any): any;
    function getClearString(): string;
    function getDimension(element: any, method: string): any;
    function getFontString(fontObj: any): string;
    function getFontStyle(style: string): string;
    function getMaxZindex(): number;
    function getNameSpace(className: string): string;
    function getOffset(ele: string): any;
    function getRenderMode(): string;
    function getScrollableParents(element: any): JQuery;
    function getTheme(): string;
    function getZindexPartial(element: any, popupEle: string): number;
    function hasRenderMode(element: string): void;
    function hasStyle(prop: string): boolean;
    function hasTheme(element: string): string;
    function hexFromRGB(color: string): string;
    function ieClearRemover(element: string): void;
    function isAndroidWebView(): string;
    function isDevice(): boolean;
    function isIOS7(): boolean;
    function isIOSWebView(): boolean;
    function isLowerAndroid(): boolean;
    function isNullOrUndefined(value: any): boolean;
    function isPlainObject(): JQuery;
    function isPortrait(): any;
    function isTablet(): boolean;
    function isWindowsWebView(): string;
    function listenEvents(selectors: any, eventTypes: any, handlers: any, remove?: any, pluginObj?: any, disableMouse?: boolean): void;
    function listenTouchEvent(selectors: any, eventTypes: any, handlers: any, remove?: any, pluginObj?: any, disableMouse?: boolean): void;
    function logBase(val: string, base: string): number;
    function measureText(text: string, maxwidth: number, font: string): string;
    function moveEvent(): string;
    function print(element: string, printWindow: any): void;
    function proxy(fn: any, context?: string, arg?: string): any;
    function round(value: string, div: string, up: string): any;
    function sendAjaxRequest(ajaxOptions: any): void;
    function setCaretToPos(nput: string, pos1: string, pos2: string): void;
    function setRenderMode(element: string): void;
    function setTheme(): any;
    function startEvent(): string;
    function tapEvent(): string;
    function tapHoldEvent(): string;
    function throwError(): any;
    function transitionEndEvent(): any;
    function userAgent(): boolean;
    function widget(pluginName: string, className: string, proto: any): any;
    function avg(json: any, filedName: string): any;
    function getGuid(prefix: string): number;
    function group(jsonArray: any, field: string, agg: string, level: number, groupDs: string): any;
    function isJSON(jsonData: string): string;
    function max(jsonArray: any, fieldName?: string, comparer?: string): any;
    function min(jsonArray: any, fieldName: string, comparer: string): any;
    function merge(first: string, second: string): any;
    function mergeshort(jsonArray: any, fieldName: string, comparer: string): any;
    function parseJSON(jsonText: string): string;
    function parseTable(table: number, headerOption: string, headerRowIndex: string): any;
    function select(jsonArray: any, fields: string): any;
    function setTransition(): boolean;
    function sum(json: string, fieldName: string): string;
    function swap(array: any, x: string, y: string): any;
    const cssUA: string;
    const serverTimezoneOffset: number;
    const transform: string;
    const transformOrigin: string;
    const transformStyle: string;
    const transition: string;
    const transitionDelay: string;
    const transitionDuration: string;
    const transitionProperty: string;
    const transitionTimingFunction: string;
    const template: any;
    const util: {
        valueFunction(val: string): any;
    };
    export namespace device {
        function isAndroid(): boolean;
        function isIOS(): boolean;
        function isFlat(): boolean;
        function isIOS7(): boolean;
        function isWindows(): boolean;
    }
    export namespace widget {
        const autoInit: boolean;
        const registeredInstances: any[];
        const registeredWidgets: any[];
        function register(pluginName: string, className: string, prototype: any): void;
        function destroyAll(elements: Element): void;
        function init(element: Element): void;
        function registerInstance(element: Element, pluginName: string, className: string, prototype: any): void;
    }

    interface browserInfoOptions {
        name: string;
        version: string;
        culture: any;
        isMSPointerEnabled: boolean;
    }
    class WidgetBase {
        destroy(): void;
        element: JQuery;
        setModel(options: any, forceSet?: boolean): any;
        option(prop?: any, value?: any, forceSet?: boolean): any;
        _trigger(eventName?: string, eventProp?: any): any;
        _on(element: JQuery, eventType?: string, handler?: (eventObject: JQueryEventObject) => any): any;
        _on(element: JQuery, eventType?: string, selector?: string, handler?: (eventObject: JQueryEventObject) => any): any;
        _off(element: JQuery, eventName: string, handler?: (eventObject: JQueryEventObject) => any): any;
        _off(element: JQuery, eventType?: string, selector?: string, handler?: (eventObject: JQueryEventObject) => any): any;
        persistState(): void;
        restoreState(silent: boolean): void;
    }

    class Widget extends WidgetBase {
        constructor(pluginName: string, className: string, proto: any);
        static fn: Widget;
        static extend(widget: Widget): any;
        register(pluginName: string, className: string, prototype: any): void;
        destroyAll(elements: Element): void;
        model: any;
    }


    interface BaseEvent {
        cancel: boolean;
        type: string;
    }
    class DataManager {
        constructor(dataSource?: any, query?: ej.Query, adaptor?: any);
        setDefaultQuery(query: ej.Query): void;
        executeQuery(query?: ej.Query, done?: any, fail?: any, always?: any): JQueryPromise<any>;
        executeLocal(query?: ej.Query): ej.DataManager;
        saveChanges(changes?: Changes, key?: string, tableName?: string): JQueryDeferred<any>;
        insert(data: any, tableName?: string): JQueryPromise<any>;
        remove(keyField: string, value: any, tableName?: string): any;
        update(keyField: string, value: any, tableName?: string): any;
    }

    class Query {
        constructor();
        static fn: Query;
        static extend(prototype: any): Query;
        key(field: string): ej.Query;
        using(dataManager: ej.DataManager): ej.Query;
        execute(dataManager: ej.DataManager, done: any, fail?: string, always?: string): any;
        executeLocal(dataManager: ej.DataManager): ej.DataManager;
        clone(): ej.Query;
        from(tableName: any): ej.Query;
        addParams(key: string, value: string): ej.Query;
        expand(tables: any): ej.Query;
        where(fieldName: string, operator: ej.FilterOperators, value: any, ignoreCase?: boolean, ignoreAccent?: boolean): ej.Query;
        where(predicate: ej.Predicate): ej.Query;
        search(searchKey: any, fieldNames?: any, operator?: string, ignoreCase?: boolean, ignoreAccent?: boolean): ej.Query;
        sortBy(fieldName: string, comparer?: ej.SortOrder, isFromGroup?: boolean): ej.Query;
        sortByDesc(fieldName: string): ej.Query;
        group(fieldName: string): ej.Query;
        page(pageIndex: number, pageSize: number): ej.Query;
        take(nos: number): ej.Query;
        skip(nos: number): ej.Query;
        select(fieldNames: any): ej.Query;
        hierarchy(query: ej.Query, selectorFn: any): ej.Query;
        foreignKey(key: string): ej.Query;
        requiresCount(): ej.Query;
        range(start: number, end: number): ej.Query;
    }

    class Adaptor {
        constructor(ds: any);
        pvt: any;
        type: ej.Adaptor;
        options: AdaptorOptions;
        extend(overrides: any): ej.Adaptor;
        processQuery(dm: ej.DataManager, query: ej.Query): any;
        processResponse(data: any, ds: any, query: ej.Query, xhr: JQueryXHR, request?: any, changes?: Changes): any;
        convertToQueryString(req: any, query: ej.Query, dm: ej.DataManager): JQueryParam;
    }

    interface AdaptorOptions {
        from?: string;
        requestType?: string;
        sortBy?: string;
        select?: string;
        skip?: string;
        group?: string;
        take?: string;
        search?: string;
        count?: string;
        where?: string;
        aggregates?: string;
    }

    class UrlAdaptor extends ej.Adaptor {
        constructor();
        processQuery(dm: ej.DataManager, query: ej.Query, hierarchyFilters?: any): {
            type: string; url: string; ejPvtData: any; contentType?: string; data?: any;
        };
        convertToQueryString(req: any, query: ej.Query, dm: ej.DataManager): JQueryParam;
        processResponse(data: any, ds: any, query: ej.Query, xhr: JQueryXHR, request?: any, changes?: Changes): any;
        onGroup(e: any): void;
        onAggregates(e: any): void;
        batchRequest(dm: ej.DataManager, changes: Changes, e: any): void;
        beforeSend(dm: ej.DataManager, request: any, settings?: any): void;
        insert(dm: ej.DataManager, data: any, tableName: string): { url: string; data: any };
        remove(dm: ej.DataManager, keyField: string, value: any, tableName: string): { type: string; url: string; data?: any };
        update(dm: ej.DataManager, keyField: string, value: any, tableName: string): { type: string; url: string; data: any };
        getFiltersFrom(data: any, query: ej.Query): ej.Predicate;
    }
    class WebMethodAdaptor extends ej.UrlAdaptor {
        constructor();
        processQuery(dm: ej.DataManager, query: ej.Query, hierarchyFilters?: any): {
            type: string; url: string; ejPvtData: any; contentType?: string; data?: any;
        };
    }
    class CacheAdaptor extends ej.UrlAdaptor {
        constructor();
        init(adaptor: any, timeStamp: number, pageSize: number): void;
        generateKey(url: string, query: ej.Query): string;
        processQuery(dm: ej.DataManager, query: ej.Query, hierarchyFilters?: any): any;
        processResponse(data: any, ds: any, query: ej.Query, xhr: JQueryXHR, request?: any, changes?: Changes): any;
        insert(dm: ej.DataManager, data: any, tableName: string): { url: string; data: any };
        remove(dm: ej.DataManager, keyField: string, value: any, tableName: string): { type: string; url: string; data?: any };
        update(dm: ej.DataManager, keyField: string, value: any, tableName: string): { type: string; url: string; data: any };
        batchRequest(dm: ej.DataManager, changes: Changes, e: any): { url: string; type: string; data: any; contentType: string };
    }
    class ODataAdaptor extends ej.UrlAdaptor {
        constructor();
        options: UrlAdaptorOptions;
        onEachWhere(filter: any, requiresCast: boolean): any;
        onPredicate(pred: ej.Predicate, query: ej.Query, requiresCast: boolean): string;
        onComplexPredicate(pred: ej.Predicate, requiresCast: boolean): string;
        onWhere(filters: string[]): string;
        onEachSearch(e: any): void;
        onSearch(e: any): string;
        onEachSort(e: any): string;
        onSortBy(e: any): string;
        onGroup(e: any): string;
        onSelect(e: any): string;
        onAggregates(e: any): string;
        onCount(e: any): string;
        beforeSend(dm: ej.DataManager, request: any, settings?: any): void;
        processResponse(data: any, ds: any, query: ej.Query, xhr: any, request: any, changes: Changes): {
            result: any; count: number
        };
        convertToQueryString(req: any, query: ej.Query, dm: ej.DataManager): JQueryParam;
        insert(dm: ej.DataManager, data: any, tableName: string): { url: string; data: any; };
        remove(dm: ej.DataManager, keyField: string, value: any, tableName: string): { url: string; type: string; };
        update(dm: ej.DataManager, keyField: string, value: any, tableName: string): { url: string; type: string; data: any; accept: string; };
        batchRequest(dm: ej.DataManager, changes: Changes, e: any): { url: string; type: string; data: any; contentType: string; };
        generateDeleteRequest(arr: any[], e: any): string;
        generateInsertRequest(arr: any[], e: any): string;
        generateUpdateRequest(arr: any[], e: any): string;
    }
    interface UrlAdaptorOptions {
        requestType?: string;
        accept?: string;
        multipartAccept?: string;
        sortBy?: string;
        select?: string;
        skip?: string;
        take?: string;
        count?: string;
        where?: string;
        expand?: string;
        batch?: string;
        changeSet?: string;
        batchPre?: string;
        contentId?: string;
        batchContent?: string;
        changeSetContent?: string;
        batchChangeSetContentType?: string;
    }

    class WebApiAdaptor extends ej.ODataAdaptor {
        constructor();
        insert(dm: ej.DataManager, data: any, tableName?: string): { url: string; type: string; data: any; };
        remove(dm: ej.DataManager, value: any, keyField?: string, tableName?: string): { url: string; type: string; data: any; };
        update(dm: ej.DataManager, value: any, keyField?: string, tableName?: string): { url: string; type: string; data: any; accept: string; };
        processResponse(data: any, ds: any, query: ej.Query, xhr: any, request: any, changes: Changes): {
            result: any; count: number
        };
    }

    class ODataV4Adaptor extends ej.ODataAdaptor {
        constructor();
        options: ODataAdaptorOptions;
        onCount(e: any): string;
        onEachSearch(e: any): void;
        onSearch(e: any): string;
        beforeSend(dm: ej.DataManager, request: any, settings?: any): void;
        processQuery(ds: any, query: ej.Query): {
            type: string; url: string; ejPvtData: any; contentType?: string; data?: any;
        };
        processResponse(data: any, ds: any, query: ej.Query, xhr: any, request: any, changes: Changes): {
            result: any; count: number
        };
    }
    interface ODataAdaptorOptions {
        requestType?: string;
        accept?: string;
        multipartAccept?: string;
        sortBy?: string;
        select?: string;
        skip?: string;
        take?: string;
        count?: string;
        search?: string;
        where?: string;
        expand?: string;
        batch?: string;
        changeSet?: string;
        batchPre?: string;
        contentId?: string;
        batchContent?: string;
        changeSetContent?: string;
        batchChangeSetContentType?: string;
    }

    class JsonAdaptor extends ej.Adaptor {
        constructor();
        processQuery(ds: any, query: ej.Query): string;
        batchRequest(dm: ej.DataManager, changes: Changes, e: any): Changes;
        onWhere(ds: any, e: any): any;
        onAggregates(ds: any, e: any): any;
        onSearch(ds: any, e: any): any;
        onSortBy(ds: any, e: any, query: ej.Query): any;
        onGroup(ds: any, e: any, query: ej.Query): any;
        onPage(ds: any, e: any, query: ej.Query): any;
        onRange(ds: any, e: any): any;
        onTake(ds: any, e: any): any;
        onSkip(ds: any, e: any): any;
        onSelect(ds: any, e: any): any;
        insert(dm: ej.DataManager, data: any, tableName?: string): any;
        remove(dm: ej.DataManager, keyField: string, value: any, tableName: string): any;
        update(dm: ej.DataManager, keyField: string, value: any, tableName: string): any;
    }
    class ForeignKeyAdaptor extends ej.JsonAdaptor {
        constructor(data: any, type: string);
        processQuery(ds: any, query: ej.Query): any;
        insert(dm: ej.DataManager, data: any, tableName: string): { url: string; data: any };
        update(dm: ej.DataManager, keyField: string, value: any, tableName: string): { url: string; type: string; data: any };
    }
    class remoteSaveAdaptor extends ej.UrlAdaptor {
        constructor();
        batchRequest(dm: ej.DataManager, changes: Changes, e: any): void;
        beforeSend(dm: ej.DataManager, request: any, settings?: any): void;
        insert(dm: ej.DataManager, data: any, tableName: string): { url: string; data: any };
        remove(dm: ej.DataManager, keyField: string, value: any, tableName: string): { type: string; url: string; data?: any };
        update(dm: ej.DataManager, keyField: string, value: any, tableName: string): { type: string; url: string; data: any };
    }
    class TableModel {
        constructor(name: string, jsonArray: any[], dataManager: ej.DataManager, modelComputed: any);
        on(eventName: string, handler: any): void;
        off(eventName: string, handler: any): void;
        setDataManager(dataManager: DataManager): void;
        saveChanges(): void;
        rejectChanges(): void;
        insert(json: any): void;
        update(value: any): void;
        remove(key: string): void;
        isDirty(): boolean;
        getChanges(): Changes;
        toArray(): any[];
        setDirty(dirty: any, model: any): void;
        get(index: number): void;
        length(): number;
        bindTo(element: any): void;
    }
    class Model {
        constructor(json: any, table: string, name: string);
        formElements: string[];
        computes(value: any): void;
        on(eventName: string, handler: any): void;
        off(eventName: string, handler: any): void;
        set(field: string, value: any): void;
        get(field: string): any;
        revert(suspendEvent: any): void;
        save(dm: ej.DataManager, key: string): void;
        markCommit(): void;
        markDelete(): void;
        changeState(state: boolean, args: any): void;
        properties(): any;
        bindTo(element: any): void;
        unbind(element: any): void;
    }
    interface Changes {
        changed?: any[];
        added?: any[];
        deleted?: any[];
    }
    class Predicate {
        constructor();
        constructor(field: string, operator: ej.FilterOperators, value: any, ignoreCase: boolean, ignoreAccent?: boolean);
        and(field: string, operator: any, value: any, ignoreCase: boolean, ignoreAccent?: boolean): ej.Predicate;
        or(field: string, operator: any, value: any, ignoreCase: boolean, ignoreAccent?: boolean): ej.Predicate;
        or(predicate: any[]): any;
        validate(record: any): boolean;
        toJSON(): {
            isComplex: boolean;
            field: string;
            operator: string;
            value: any;
            ignoreCase: boolean;
            condition: string;
            predicates: any;
        };
    }
    interface dataUtil {
        swap(array: any[], x: number, y: number): void;
        mergeSort(jsonArray: any[], fieldName?: string, comparer?: any): any[];
        max(jsonArray: any[], fieldName?: string, comparer?: string): any[];
        min(jsonArray: any[], fieldName: string, comparer: string): any[];
        distinct(jsonArray: any[], fieldName?: string, requiresCompleteRecord?: any): any[];
        sum(json: any, fieldName: string): number;
        avg(json: any, fieldName: string): number;
        select(jsonArray: any[], fieldName: string, fields: string): any[];
        group(jsonArray: any[], field: string, /* internal */ level: number): any[];
        parseTable(table: string, headerOption: ej.headerOption, headerRowIndex: number): any;
    }
    interface AjaxSettings {
        type?: string;
        cache: boolean;
        data?: any;
        dataType?: string;
        contentType?: any;
        async?: boolean;
    }
    enum FilterOperators {
        contains,
        endsWith,
        equal,
        greaterThan,
        greaterThanOrEqual,
        lessThan,
        lessThanOrEqual,
        notEqual,
        startsWith
    }

    enum MatrixDefaults {
        m11,
        m12,
        m21,
        m22,
        offsetX,
        offsetY,
        type
    }
    enum MatrixTypes {
        Identity,
        Scaling,
        Translation,
        Unknown
    }

    enum Orientation {
        Horizontal,
        Vertical
    }

    enum SliderType {
        Default,
        MinRange,
        Range
    }

    enum eventType {
        click,
        mouseDown,
        mouseLeave,
        mouseMove,
        mouseUp
    }
    enum headerOption {
        row,
        tHead
    }

    enum filterType {
        StartsWith,
        Contains,
        EndsWith,
        LessThan,
        GreaterThan,
        LessThanOrEqual,
        GreaterThanOrEqual,
        Equal,
        NotEqual
    }
    enum Animation {
        Fade,
        None,
        Slide
    }
    enum Type {
        Overlay,
        Slide
    }
    enum SortOrder {
        Ascending,
        Descending
    }
    class Draggable extends ej.Widget {
        static fn: Draggable;
        constructor(element: JQuery | Element, options?: Draggable.Model);
        static Locale: any;
        model: Draggable.Model;
        defaults: Draggable.Model;

        /** destroy in the draggable.
         * @returns {void}
         */
        destroy(): void;
    }
    export namespace Draggable {

        export interface Model {

            /** If clone is specified.
             * @Default {false}
             */
            clone?: boolean;

            /** Sets the offset of the dragging helper relative to the mouse cursor.
             * @Default {{ top: -1, left: -2 }}
             */
            cursorAt?: any;

            /** Distance in pixels after mousedown the mouse must move before dragging should start. This option can be used to prevent unwanted drags when clicking on an element.
             * @Default {1}
             */
            distance?: number;

            /** The drag area is used to restrict the dragging element bounds.Specify the id of the container within which the element should be dragged.
             * @Default {null}
             */
            dragArea?: boolean;

            /** If specified, restricts drag start click to the specified element(s).
             * @Default {null}
             */
            handle?: string;

            /** Used to group sets of draggable and droppable items, in addition to droppable's accept option. A draggable with the same scope value as a droppable will be accepted by the
             * droppable.
             * @Default {'default'}
             */
            scope?: string;

            /** Used to enable auto scroll while drag and drop the element.
             * @Default {'false'}
             */
            autoScroll?: boolean;

            /** Represents when to start the scrolling inside the scroll container on dragging
             * @Default {'20'}
             */
            scrollSensitivity?: number;

            /** Specifies how much distance of scroll should move on dragging once reached scroll sensitivity area.
             * @Default {'20'}
             */
            scrollSpeed?: number;

            /** This event is triggered when dragging element is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** This event is triggered when the mouse is moved during the dragging.
             */
            drag?(e: DragEventArgs): void;

            /** Supply a callback function to handle the drag start event as an init option.
             */
            dragStart?(e: DragStartEventArgs): void;

            /** This event is triggered when the mouse is moved during the dragging.
             */
            dragStop?(e: DragStopEventArgs): void;

            /** This event is triggered when dragged.
             */
            helper?(e: HelperEventArgs): void;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the autocomplete model
             */
            model?: ej.Draggable.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DragEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the draggable model
             */
            model?: ej.Draggable.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event model values
             */
            event?: any;

            /** returns the exact mouse down target element
             */
            target?: any;
        }

        export interface DragStartEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the draggable model
             */
            model?: ej.Draggable.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event model values
             */
            event?: any;

            /** returns the exact mouse down target element
             */
            target?: any;
        }

        export interface DragStopEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the draggable model
             */
            model?: ej.Draggable.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event model values
             */
            event?: any;

            /** returns the exact mouse down target element
             */
            target?: any;
        }

        export interface HelperEventArgs {

            /** returns the draggable element object
             */
            element?: any;

            /** returns the event model values
             */
            sender?: any;
        }
    }

    class Droppable extends ej.Widget {
        static fn: Droppable;
        constructor(element: JQuery | Element, options?: Droppable.Model);
        static Locale: any;
        model: Droppable.Model;
        defaults: Droppable.Model;

        /** destroy in the Droppable.
         * @returns {void}
         */
        destroy(): void;
    }
    export namespace Droppable {

        export interface Model {

            /** Used to accept the specified draggable items.
             * @Default {null}
             */
            accept?: any;

            /** Used to group sets of droppable items, in addition to droppable's accept option. A draggable with the same scope value as a droppable will be accepted by the droppable.
             * @Default {'default'}
             */
            scope?: string;

            /** This event is triggered when the mouse up is moved during the dragging.
             */
            drop?(e: DropEventArgs): void;

            /** This event is triggered when the mouse is moved out.
             */
            out?(e: OutEventArgs): void;

            /** This event is triggered when the mouse is moved over.
             */
            over?(e: OverEventArgs): void;
        }

        export interface DropEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the autocomplete model
             */
            model?: ej.Droppable.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the element which accepts the droppable element.
             */
            target?: any;
        }

        export interface OutEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the autocomplete model
             */
            model?: ej.Droppable.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mouse out over the element
             */
            target?: any;
        }

        export interface OverEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the autocomplete model
             */
            model?: ej.Droppable.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mouse over the element
             */
            target?: any;
        }
    }

    class Resizable extends ej.Widget {
        static fn: Resizable;
        constructor(element: JQuery | Element, options?: Resizable.Model);
        static Locale: any;
        model: Resizable.Model;
        defaults: Resizable.Model;

        /** destroy in the Resizable.
         * @returns {void}
         */
        destroy(): void;
    }
    export namespace Resizable {

        export interface Model {

            /** Sets the offset of the resizing helper relative to the mouse cursor.
             * @Default {{ top: -1, left: -2 }}
             */
            cursorAt?: any;

            /** Distance in pixels after mousedown the mouse must move before resizing should start. This option can be used to prevent unwanted drags when clicking on an element.
             * @Default {1}
             */
            distance?: number;

            /** If specified, restricts resize start click to the specified element(s).
             * @Default {null}
             */
            handle?: string;

            /** Sets the max height till which an element has to be resized.
             * @Default {null}
             */
            maxHeight?: number;

            /** Sets the max width till which an element has to be resized.
             * @Default {null}
             */
            maxWidth?: number;

            /** Sets the min Height below which an element cannot be resized.
             * @Default {10}
             */
            minHeight?: number;

            /** Sets the min Width below which an element cannot be resized.
             * @Default {10}
             */
            minWidth?: number;

            /** Used to group sets of resizable items.
             * @Default {'default'}
             */
            scope?: string;

            /** This event is triggered when the widget destroys.
             */
            destroy?(e: DestroyEventArgs): void;

            /** This event is triggered when resized.
             */
            helper?(e: HelperEventArgs): void;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the autocomplete model
             */
            model?: ej.Resizable.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface HelperEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the autocomplete model
             */
            model?: ej.Resizable.Model;

            /** returns the name of the event
             */
            type?: string;
        }
    }

    const globalize: globalize;
    const cultures: culture;
    function addCulture(name: string, culture?: any): void;
    function preferredCulture(culture?: string): culture;
    function format(value: any, format: string, culture?: string): string;
    function parseInt(value: string, radix?: any, culture?: string): number;
    function parseFloat(value: string, radix?: any, culture?: string): number;
    function parseDate(value: string, format: string, culture?: string): Date;
    function getLocalizedConstants(controlName: string, culture?: string): any;
	function findCulture(culture?: string): culture;

    interface globalize {
        addCulture(name: string, culture?: any): void;
        preferredCulture(culture?: string): culture;
        format(value: any, format: string, culture?: string): string;
        parseInt(value: string, radix?: any, culture?: string): number;
        parseFloat(value: string, radix?: any, culture?: string): number;
        parseDate(value: string, format: string, culture?: string): Date;
        getLocalizedConstants(controlName: string, culture?: string): any;
		findCulture(culture?: string): culture;
    }
    interface culture {
        name?: string;
        englishName?: string;
        namtiveName?: string;
        language?: string;
        isRTL: boolean;
        numberFormat?: formatSettings;
        calendars?: calendarsSettings;
    }
    interface formatSettings {
        pattern: string[];
        decimals: number;
        groupSizes: number[];
        percent: percentSettings;
        currency: currencySettings;
    }
    interface percentSettings {
        pattern: string[];
        decimals: number;
        groupSizes: number[];
        symbol: string;
    }
    interface currencySettings {
        pattern: string[];
        decimals: number;
        groupSizes: number[];
        symbol: string;
    }
    interface calendarsSettings {
        standard: standardSettings;
    }
    interface standardSettings {
        firstDay: number;
        days: daySettings;
        months: monthSettings;
        AM: string[];
        PM: string[];
        twoDigitYearMax: number;
        patterns: patternSettings;
    }
    interface daySettings {
        names: string[];
        namesAbbr: string[];
        namesShort: string[];
    }
    interface monthSettings {
        names: string[];
        namesAbbr: string[];
    }
    interface patternSettings {
        d: string;
        D: string;
        t: string;
        T: string;
        f: string;
        F: string;
        M: string;
        Y: string;
        S: string;
    }
    class Scroller extends ej.Widget {
        static fn: Scroller;
        constructor(element: JQuery | Element, options?: Scroller.Model);
        static Locale: any;
        model: Scroller.Model;
        defaults: Scroller.Model;

        /** destroy the Scroller control, unbind the all ej control related events automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** User disables the Scroller control at any time.
         * @returns {void}
         */
        disable(): void;

        /** User enables the Scroller control at any time.
         * @returns {void}
         */
        enable(): void;

        /** Returns true if horizontal scrollbar is shown, else return false.
         * @returns {boolean}
         */
        isHScroll(): boolean;

        /** Returns true if vertical scrollbar is shown, else return false.
         * @returns {boolean}
         */
        isVScroll(): boolean;

        /** User refreshes the Scroller control at any time.
         * @returns {void}
         */
        refresh(): void;

        /** Horizontal scroller moves to given pixel from its origin position. We can also specify the animation speed,in which the scroller has to move while re-positioning it.
         * @param {number|string} Horizontal scroller moves to the specified pixel.
         * @param {boolean} Specifies to enable/disable the animation.
         * @param {number} Specifies the animation speed when scrolling, if animation is enabled.
         * @returns {void}
         */
        scrollX(pixel: number|string, disableAnimation: boolean, animationSpeed: number): void;

        /** Vertical scroller moves to given pixel from its origin position. We can also specify the animation speed,in which the scroller has to move while re-positioning it.
         * @param {number|string} Vertical scroller moves to the specified pixel.
         * @param {boolean} Specifies to enable/disable the animation.
         * @param {number} Specifies the animation speed when scrolling, if animation is enabled.
         * @returns {void}
         */
        scrollY(pixel: number|string, disableAnimation: boolean, animationSpeed: number): void;
    }
    export namespace Scroller {

        export interface Model {

            /** Specifies the swipe scrolling speed(in millisecond).
             * @Default {600}
             */
            animationSpeed?: number;

            /** Set true to hides the scrollbar, when mouseout the content area.
             * @Default {false}
             */
            autoHide?: boolean;

            /** Specifies the height and width of button in the scrollbar.
             * @Default {18}
             */
            buttonSize?: number;

            /** Specifies to enable or disable the scroller
             * @Default {true}
             */
            enabled?: boolean;

            /** Save current model value to browser cookies for state maintenance. While refresh the page Rating control values are retained.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Indicates the Right to Left direction to scroller
             * @Default {undefined}
             */
            enableRTL?: boolean;

            /** Enables or Disable the touch Scroll
             * @Default {true}
             */
            enableTouchScroll?: boolean;

            /** Specifies the height of Scroll panel and scrollbars.
             * @Default {250}
             */
            height?: number|string;

            /** If the scrollbar has vertical it set as width, else it will set as height of the handler.
             * @Default {18}
             */
            scrollerSize?: number;

            /** The Scroller content and scrollbars move left with given value.
             * @Default {0}
             */
            scrollLeft?: number;

            /** While press on the arrow key the scrollbar position added to the given pixel value.
             * @Default {57}
             */
            scrollOneStepBy?: number;

            /** The Scroller content and scrollbars move to top position with specified value.
             * @Default {0}
             */
            scrollTop?: number;

            /** Indicates the target area to which scroller have to appear.
             * @Default {null}
             */
            targetPane?: string;

            /** Specifies the width of Scroll panel and scrollbars.
             * @Default {0}
             */
            width?: number|string;

            /** Fires when Scroller control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when Scroller control is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when a thumb point is moved along the touch surface.
             */
            thumbMove?(e: ThumbMoveEventArgs): void;

            /** Fires when a thumb point is placed on the touch surface.
             */
            thumbStart?(e: ThumbStartEventArgs): void;

            /** Fires when a thumb point is removed from the touch surface.
             */
            thumbEnd?(e: ThumbEndEventArgs): void;

            /** It fires whenever the mouse wheel is rotated either in upwards or downwards.
             */
            wheelMove?(e: WheelMoveEventArgs): void;

            /** It will fire when mouse trackball has been start to wheel.
             */
            wheelStart?(e: WheelStartEventArgs): void;

            /** It will fire when mouse trackball has been stop to wheel.
             */
            wheelStop?(e: WheelStopEventArgs): void;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the scroller model
             */
            model?: ej.Scroller.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** returns the scroller model
             */
            model?: ej.Scroller.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ThumbMoveEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the scroller model
             */
            model?: ej.Scroller.Model;

            /** returns the original event name and its event properties of the current event.
             */
            originalEvent?: any;

            /** returns the current data related to the event.
             */
            scrollData?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ThumbStartEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the scroller model
             */
            model?: ej.Scroller.Model;

            /** returns the original event name and its event properties of the current event.
             */
            originalEvent?: any;

            /** returns the current data related to the event.
             */
            scrollData?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ThumbEndEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the scroller model
             */
            model?: ej.Scroller.Model;

            /** returns the original event name and its event properties of the current event.
             */
            originalEvent?: any;

            /** returns the current data related to the event.
             */
            scrollData?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface WheelMoveEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the scroller model
             */
            model?: ej.Scroller.Model;

            /** returns the original event name and its event properties of the current event.
             */
            originalEvent?: any;
        }

        export interface WheelStartEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the scroller model
             */
            model?: ej.Scroller.Model;

            /** returns the original event name and its event properties of the current event.
             */
            originalEvent?: any;

            /** returns the current data related to the event.
             */
            scrollData?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface WheelStopEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the scroller model
             */
            model?: ej.Scroller.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the original event name and its event properties of the current event.
             */
            originalEvent?: any;
        }
    }

    class Accordion extends ej.Widget {
        static fn: Accordion;
        constructor(element: JQuery | Element, options?: Accordion.Model);
        static Locale: any;
        model: Accordion.Model;
        defaults: Accordion.Model;

        /** AddItem method is used to add the panel in dynamically. It receives the following parameters
         * @param {string} specify the name of the header
         * @param {string} content of the new panel
         * @param {number} insertion place of the new panel
         * @param {boolean} Enable or disable the AJAX request to the added panel
         * @returns {void}
         */
        addItem(header_name: string, content: string, index: number, isAjaxReq: boolean): void;

        /** This method used to collapse the all the expanded items in accordion at a time.
         * @returns {void}
         */
        collapseAll(): void;

        /** This method used to Collapses the specified items in accordion at a time.
         * @returns {void}
         */
        collapsePanel(): void;

        /** destroy the Accordion widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** Disables the accordion widget includes all the headers and content panels.
         * @returns {void}
         */
        disable(): void;

        /** Disable the accordion widget item based on specified header index.
         * @param {any[]} index values to disable the panels
         * @returns {void}
         */
        disableItems(index: any[]): void;

        /** Enable the accordion widget includes all the headers and content panels.
         * @returns {void}
         */
        enable(): void;

        /** Enable the accordion widget item based on specified header index.
         * @param {any[]} index values to enable the panels
         * @returns {void}
         */
        enableItems(index: any[]): void;

        /** To expand all the accordion widget items.
         * @returns {void}
         */
        expandAll(): void;

        /** This method used to Expand the specified items in accordion at a time.
         * @returns {void}
         */
        expandPanel(): void;

        /** Returns the total number of panels in the control.
         * @returns {number}
         */
        getItemsCount(): number;

        /** Hides the visible Accordion control.
         * @returns {void}
         */
        hide(): void;

        /** The refresh method is used to adjust the control size based on the parent element dimension.
         * @returns {void}
         */
        refresh(): void;

        /** RemoveItem method is used to remove the specified index panel.It receives the parameter as number.
         * @param {number} specify the index value for remove the accordion panel.
         * @returns {void}
         */
        removeItem(index: number): void;

        /** Shows the hidden Accordion control.
         * @returns {void}
         */
        show(): void;
    }
    export namespace Accordion {

        export interface Model {

            /** Specifies the ajaxSettings option to load the content to the accordion control.
             * @Default {null}
             */
            ajaxSettings?: AjaxSettings;

            /** Accordion headers can be expanded and collapsed on keyboard action.
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** To set the Accordion headers Collapse Speed.
             * @Default {300}
             */
            collapseSpeed?: number;

            /** Specifies the collapsible state of accordion control.
             * @Default {false}
             */
            collapsible?: boolean;

            /** Sets the root CSS class for Accordion theme, which is used customize.
             */
            cssClass?: string;

            /** Allows you to set the custom header Icon. It accepts two key values â€œheaderâ€, â€selectedHeaderâ€.
             * @Default {{ header: e-collapse, selectedHeader: e-expand }}
             */
            customIcon?: CustomIcon;

            /** Disables the specified indexed items in accordion.
             * @Default {[]}
             */
            disabledItems?: number[];

            /** Specifies the animation behavior in accordion.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** With this enabled property, you can enable or disable the Accordion.
             * @Default {true}
             */
            enabled?: boolean;

            /** Used to enable the disabled items in accordion.
             * @Default {[]}
             */
            enabledItems?: number[];

            /** Multiple content panels to activate at a time.
             * @Default {false}
             */
            enableMultipleOpen?: boolean;

            /** Save current model value to browser cookies for maintaining states. When refreshing the accordion control page, the model value is applied from browser cookies or HTML 5local
             * storage.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Display headers and panel text from right-to-left.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** The events API binds the action for activating the accordion header. Users can activate the header by using mouse actions such as mouse-over, mouse-up, mouse-down, and soon.
             * @Default {click}
             */
            events?: string;

            /** To set the Accordion headers Expand Speed.
             * @Default {300}
             */
            expandSpeed?: number;

            /** Sets the height for Accordion items header.
             */
            headerSize?: number|string;

            /** Specifies height of the accordion.
             * @Default {null}
             */
            height?: number|string;

            /** Adjusts the content panel height based on the given option (content, auto, or fill). By default, the panel heights are adjusted based on the content.
             * @Default {content}
             */
            heightAdjustMode?: ej.Accordion.HeightAdjustMode|string;

            /** It allows to define the characteristics of the Accordion control. It will helps to extend the capability of an HTML element.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** The given index header will activate (open). If collapsible is set to true, and a negative value is given, then all headers are collapsed. Otherwise, the first panel isactivated.
             * @Default {0}
             */
            selectedItemIndex?: number;

            /** Activate the specified indexed items of the accordion
             * @Default {[0]}
             */
            selectedItems?: number[];

            /** Used to determines the close button visibility an each accordion items. This close button helps to remove the accordion item from the control.
             * @Default {false}
             */
            showCloseButton?: boolean;

            /** Displays rounded corner borders on the Accordion control's panels and headers.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies width of the accordion.
             * @Default {null}
             */
            width?: number|string;

            /** Triggered after a Accordion item is active . Argument values are activeIndex, activeHeader, isInteraction and current model values.
             */
            activate?(e: ActivateEventArgs): void;

            /** Triggered before the AJAX content is loaded in a content panel. Arguments have location of the content (URL) and current model value.
             */
            ajaxBeforeLoad?(e: AjaxBeforeLoadEventArgs): void;

            /** Triggered after AJAX load failed action. Arguments have URL, error message, and current model value.
             */
            ajaxError?(e: AjaxErrorEventArgs): void;

            /** Triggered after the AJAX content loads. Arguments have current model values.
             */
            ajaxLoad?(e: AjaxLoadEventArgs): void;

            /** Triggered after AJAX success action. Arguments have URL, content, and current model values.
             */
            ajaxSuccess?(e: AjaxSuccessEventArgs): void;

            /** Triggered before a tab item is active. Arguments have active index and model values.
             */
            beforeActivate?(e: BeforeActivateEventArgs): void;

            /** Triggered before a Accordion item is inactive. Argument values are  inActiveIndex and  model values.
             */
            beforeInactivate?(e: BeforeInactivateEventArgs): void;

            /** Triggered after Accordion control creation.
             */
            create?(e: CreateEventArgs): void;

            /** Triggered after Accordion control destroy.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggered after a Accordion item is inactive. Argument values are  inActiveHeader, inActiveIndex ,isInteraction and current model values.
             */
            inActivate?(e: InActivateEventArgs): void;
        }

        export interface ActivateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns active index
             */
            activeIndex?: number;

            /** returns current active header
             */
            activeHeader?: any;

            /** returns true when the Accordion index activated by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface AjaxBeforeLoadEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns current AJAX content location
             */
            URL?: string;
        }

        export interface AjaxErrorEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns current AJAX content location
             */
            URL?: string;

            /** returns the failed data sent.
             */
            data?: string;
        }

        export interface AjaxLoadEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the name of the URL
             */
            URL?: string;
        }

        export interface AjaxSuccessEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns current AJAX content location
             */
            URL?: string;

            /** returns the successful data sent.
             */
            data?: string;

            /** returns the AJAX content.
             */
            content?: string;
        }

        export interface BeforeActivateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns active index
             */
            activeIndex?: number;

            /** returns true when the Accordion index activated by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface BeforeInactivateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns active index
             */
            inActiveIndex?: number;

            /** returns true when the Accordion index activated by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface InActivateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the accordion model
             */
            model?: ej.Accordion.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns active index
             */
            inActiveIndex?: number;

            /** returns in active element
             */
            inActiveHeader?: any;

            /** returns true when the Accordion index activated by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface AjaxSettings {

            /** It specifies, whether to enable or disable asynchronous request.
             */
            async?: boolean;

            /** It specifies the page will be cached in the web browser.
             */
            cache?: boolean;

            /** It specifies the type of data is send in the query string.
             */
            contentType?: string;

            /** It specifies the data as an object, will be passed in the query string.
             */
            data?: any;

            /** It specifies the type of data that you're expecting back from the response.
             */
            dataType?: string;

            /** It specifies the HTTP request type.
             */
            type?: string;
        }

        export interface CustomIcon {

            /** This class name set to collapsing header.
             */
            header?: string;

            /** This class name set to expanded (active) header.
             */
            selectedHeader?: string;
        }

        enum HeightAdjustMode {

            ///Height fit to the content in the panel
            Content,

            ///Height set to the largest content in the panel
            Auto,

            ///Height filled to the content of the panel
            Fill
        }

    }

    class Autocomplete extends ej.Widget {
        static fn: Autocomplete;
        constructor(element: JQuery | Element, options?: Autocomplete.Model);
        static Locale: any;
        model: Autocomplete.Model;
        defaults: Autocomplete.Model;

        /** Clears the text in the Autocomplete textbox.
         * @returns {void}
         */
        clearText(): void;

        /** Destroys the Autocomplete widget.
         * @returns {void}
         */
        destroy(): void;

        /** Disables the autocomplete widget.
         * @returns {void}
         */
        disable(): void;

        /** Enables the autocomplete widget.
         * @returns {void}
         */
        enable(): void;

        /** Returns objects (data object) of all the selected items in the autocomplete textbox.
         * @returns {any}
         */
        getSelectedItems(): any;

        /** Returns the current selected value from the Autocomplete textbox.
         * @returns {string}
         */
        getValue(): string;

        /** Returns the current active text value in the Autocomplete suggestion list.
         * @returns {string}
         */
        getActiveText(): string;

        /** Hides the Autocomplete suggestion list.
         * @returns {void}
         */
        hide(): void;

        /** Search the entered text and show it in the suggestion list if available.
         * @returns {void}
         */
        search(): void;

        /** Open up the autocomplete suggestion popup with all list items.
         * @returns {void}
         */
        open(): void;

        /** Sets the value of the Autocomplete textbox based on the given key value.
         * @param {string} The key value of the specific suggestion item.
         * @returns {void}
         */
        selectValueByKey(Key: string): void;

        /** Sets the value of the Autocomplete textbox based on the given input text value.
         * @param {string} The text (label) value of the specific suggestion item.
         * @returns {void}
         */
        selectValueByText(Text: string): void;
    }
    export namespace Autocomplete {

        export interface Model {

            /** Customize &quot;Add New&quot; text (label) to be added in the autocomplete popup list for the entered text when there are no suggestions for it.
             * @Default {Add New}
             */
            addNewText?: string;

            /** Allows new values to be added to the autocomplete input other than the values in the suggestion list. Normally, when there are no suggestions it will display â€œNo suggestionsâ€
             * label in the popup.
             * @Default {false}
             */
            allowAddNew?: boolean;

            /** Enables or disables the sorting of suggestion list item. The default sort order is ascending order. You customize sort order.
             * @Default {true}
             */
            allowSorting?: boolean;

            /** Enables or disables selecting the animation style for the popup list. Animation types can be selected through either of the following options,
             * @Default {slide}
             */
            animateType?: ej.Autocomplete.Animation|string;

            /** To focus the items in the suggestion list when the popup is shown. By default first item will be focused.
             * @Default {false}
             */
            autoFocus?: boolean;

            /** Enables or disables the case sensitive search.
             * @Default {false}
             */
            caseSensitiveSearch?: boolean;

            /** The root class for the Autocomplete textbox widget which helps in customizing its theme.
             * @Default {â€â€}
             */
            cssClass?: string;

            /** The data source contains the list of data for the suggestions list. It can be a string array or JSON array or service URL that returns JSON.
             * @Default {null}
             */
            dataSource?: any|any[];

            /** The time delay (in milliseconds) after which the suggestion popup will be shown.
             * @Default {200}
             */
            delaySuggestionTimeout?: number;

            /** The special character which acts as a separator for the given words for multi-mode search i.e. the text after the delimiter are considered as a separate word or query for search
             * operation.
             * @Default {â€™,â€™}
             */
            delimiterChar?: string;

            /** The text to be displayed in the popup when there are no suggestions available for the entered text.
             * @Default {â€œNo suggestionsâ€}
             */
            emptyResultText?: string;

            /** Fills the autocomplete textbox with the first matched item from the suggestion list automatically based on the entered text when enabled.
             * @Default {false}
             */
            enableAutoFill?: boolean;

            /** Enables or disables the Autocomplete textbox widget.
             * @Default {true}
             */
            enabled?: boolean;

            /** Enables or disables displaying the duplicate names present in the search result.
             * @Default {false}
             */
            enableDistinct?: boolean;

            /** Allows the current model values to be saved in local storage or browser cookies for state maintenance when it is set to true. While refreshing the page, it retains the model value
             * from browser cookies or local storage.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Displays the Autocomplete widgetâ€™s content from right to left when enabled.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Mapping fields for the suggestion items of the Autocomplete textbox widget.
             * @Default {null}
             */
            fields?: Fields;

            /** Specifies the search filter type. There are several types of search filter available such as â€˜startswithâ€™, â€˜containsâ€™, â€˜endswithâ€™, â€˜lessthanâ€™,
             * â€˜lessthanorequalâ€™, â€˜greaterthanâ€™, â€˜greaterthanorequalâ€™, â€˜equalâ€™, â€˜notequalâ€™.
             * @Default {ej.filterType.StartsWith}
             */
            filterType?: string;

            /** The height of the Autocomplete textbox.
             * @Default {null}
             */
            height?: string|number;

            /** The search text can be highlighted in the AutoComplete suggestion list when enabled.
             * @Default {false}
             */
            highlightSearch?: boolean;

            /** Number of items to be displayed in the suggestion list.
             * @Default {0}
             */
            itemsCount?: number;

            /** To enable or disable the diacritic characters of the Autocomplete suggestion list when filtering.
             * @Default {false}
             */
            ignoreAccent?: boolean;

            /** Set the localization culture for Autocomplete Widget.
             */
            locale?: string;

            /** Minimum number of character to be entered in the Autocomplete textbox to show the suggestion list.
             * @Default {1}
             */
            minCharacter?: number;

            /** An Autocomplete column collection can be defined and customized through the multiColumnSettings property.Column's header, field, and stringFormat can be define via
             * multiColumnSettings properties.
             */
            multiColumnSettings?: MultiColumnSettings;

            /** Enables or disables selecting multiple values from the suggestion list. Multiple values can be selected through either of the following options,
             * @Default {ej.MultiSelectMode.None}
             */
            multiSelectMode?: ej.Autocomplete.MultiSelectMode|string;

            /** The height of the suggestion list.
             * @Default {â€œ152pxâ€}
             */
            popupHeight?: string;

            /** The width of the suggestion list.
             * @Default {â€œautoâ€}
             */
            popupWidth?: string;

            /** The query to retrieve the data from the data source.
             * @Default {null}
             */
            query?: ej.Query;

            /** Indicates that the autocomplete textbox values can only be readable.
             * @Default {false}
             */
            readOnly?: boolean;

            /** Sets the value for the Autocomplete textbox based on the given input key value.
             */
            selectValueByKey?: number;

            /** Enables or disables showing the message when there are no suggestions for the entered text.
             * @Default {true}
             */
            showEmptyResultText?: boolean;

            /** Enables or disables the loading icon to intimate the searching operation. The loading icon is visible when there is a time delay to perform the search.
             * @Default {true}
             */
            showLoadingIcon?: boolean;

            /** Enables the showPopup button in autocomplete textbox. When the showPopup button is clicked, it displays all the available data from the data source.
             * @Default {false}
             */
            showPopupButton?: boolean;

            /** Enables or disables rounded corner.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Enables or disables reset icon to clear the textbox values.
             * @Default {false}
             */
            showResetIcon?: boolean;

            /** Sort order specifies whether the suggestion list values has to be displayed in ascending or descending order.
             * @Default {ej.SortOrder.Ascending}
             */
            sortOrder?: ej.Autocomplete.SortOrder|string;

            /** The template to display the suggestion list items with customized appearance.
             * @Default {null}
             */
            template?: string;

            /** The jQuery validation error message to be displayed on form validation.
             * @Default {null}
             */
            validationMessage?: any;

            /** The jQuery validation rules for form validation.
             * @Default {null}
             */
            validationRules?: any;

            /** The value to be displayed in the autocomplete textbox.
             * @Default {null}
             */
            value?: string;

            /** Enables or disables the visibility of the autocomplete textbox.
             * @Default {true}
             */
            visible?: boolean;

            /** The text to be displayed when the value of the autocomplete textbox is empty.
             * @Default {null}
             */
            watermarkText?: string;

            /** The width of the Autocomplete textbox.
             * @Default {null}
             */
            width?: string|number;

            /** Triggers when the AJAX requests Begins.
             */
            actionBegin?(e: ActionBeginEventArgs): void;

            /** Triggers when the data requested from AJAX will get successfully loaded in the Autocomplete widget.
             */
            actionSuccess?(e: ActionSuccessEventArgs): void;

            /** Triggers when the AJAX requests complete. The request may get failed or succeed.
             */
            actionComplete?(e: ActionCompleteEventArgs): void;

            /** Triggers when the data requested from AJAX get failed.
             */
            actionFailure?(e: ActionFailureEventArgs): void;

            /** Triggers when the text box value is changed.
             */
            change?(e: ChangeEventArgs): void;

            /** Triggers after the suggestion popup is closed.
             */
            close?(e: CloseEventArgs): void;

            /** Triggers when Autocomplete widget is created.
             */
            create?(e: CreateEventArgs): void;

            /** Triggers after the Autocomplete widget is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggers after the autocomplete textbox is focused.
             */
            focusIn?(e: FocusInEventArgs): void;

            /** Triggers after the Autocomplete textbox gets out of the focus.
             */
            focusOut?(e: FocusOutEventArgs): void;

            /** Triggers after the suggestion list is opened.
             */
            open?(e: OpenEventArgs): void;

            /** Triggers when an item has been selected from the suggestion list.
             */
            select?(e: SelectEventArgs): void;
        }

        export interface ActionBeginEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Autocomplete model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ActionSuccessEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns number of times trying to fetch the data
             */
            count?: number;

            /** returns the Autocomplete model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** Returns the query for data retrieval from the Database
             */
            request?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the number of items fetched from remote data
             */
            result?: any[];

            /** Returns the requested data
             */
            xhr?: any;
        }

        export interface ActionCompleteEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns number of times trying to fetch the data
             */
            count?: number;

            /** returns the Autocomplete model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** Returns the query for data retrieval from the Database
             */
            request?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the number of items fetched from remote data
             */
            result?: any[];

            /** Returns the requested data
             */
            xhr?: any;
        }

        export interface ActionFailureEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the error message
             */
            error?: any;

            /** returns the Autocomplete model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ChangeEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the autocomplete model object.
             */
            model?: ej.Autocomplete.Model;

            /** Name of the event.
             */
            type?: string;

            /** Value of the autocomplete textbox.
             */
            value?: string;
        }

        export interface CloseEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the autocomplete model object.
             */
            model?: ej.Autocomplete.Model;

            /** Name of the event.
             */
            type?: string;
        }

        export interface CreateEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the autocomplete model object.
             */
            model?: ej.Autocomplete.Model;

            /** Name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the autocomplete model object.
             */
            model?: ej.Autocomplete.Model;

            /** Name of the event.
             */
            type?: string;
        }

        export interface FocusInEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the autocomplete model object.
             */
            model?: ej.Autocomplete.Model;

            /** Name of the event.
             */
            type?: string;

            /** Value of the autocomplete textbox.
             */
            value?: string;
        }

        export interface FocusOutEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the autocomplete model object.
             */
            model?: ej.Autocomplete.Model;

            /** Name of the event.
             */
            type?: string;

            /** Value of the autocomplete textbox.
             */
            value?: string;
        }

        export interface OpenEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the autocomplete model object.
             */
            model?: ej.Autocomplete.Model;

            /** Name of the event.
             */
            type?: string;
        }

        export interface SelectEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the autocomplete model object.
             */
            model?: ej.Autocomplete.Model;

            /** Name of the event.
             */
            type?: string;

            /** Value of the autocomplete textbox.
             */
            value?: string;

            /** Text of the selected item.
             */
            text?: string;

            /** Key of the selected item.
             */
            key?: string;

            /** Data object of the selected item.
             */
            Item?: ej.Autocomplete.Model;
        }

        export interface Fields {

            /** Used to group the suggestion list items.
             */
            groupBy?: string;

            /** Defines the HTML attributes such as id, class, styles for the item.
             */
            htmlAttributes?: any;

            /** Defines the specific field name which contains unique key values for the list items.
             */
            key?: string;

            /** Defines the specific field name in the data source to load the suggestion list with data.
             */
            text?: string;
        }

        export interface MultiColumnSettingsColumn {

            /** Get or set a value that indicates to display the columns in the autocomplete mapping with column name of the dataSource.
             */
            field?: string;

            /** Get or set a value that indicates to display the title of that particular column.
             */
            headerText?: string;

            /** Gets or sets a value that indicates to render the multicolumn with custom theme.
             */
            cssClass?: string;

            /** Specifies the search data type. There are four types of data types available such as string, â€˜numberâ€™, â€˜booleanâ€™ and â€˜dateâ€™.
             * @Default {ej.Type.String}
             */
            type?: ej.Type|string;

            /** Specifies the search filter type. There are several types of search filter available such as â€˜startswithâ€™, â€˜containsâ€™, â€˜endswithâ€™, â€˜lessthanâ€™,
             * â€˜lessthanorequalâ€™, â€˜greaterthanâ€™, â€˜greaterthanorequalâ€™, â€˜equalâ€™, â€˜notequalâ€™.
             * @Default {ej.filterType.StartsWith}
             */
            filterType?: ej.filterType|string;

            /** This defines the text alignment of a particular column header cell value. See headerTextAlign
             * @Default {ej.TextAlign.Left}
             */
            headerTextAlign?: ej.TextAlign|string;

            /** Gets or sets a value that indicates to align the text within the column. See textAlign
             * @Default {ej.TextAlign.Left}
             */
            textAlign?: ej.TextAlign|string;
        }

        export interface MultiColumnSettings {

            /** Allow list of data to be displayed in several columns.
             * @Default {false}
             */
            enable?: boolean;

            /** Allow header text to be displayed in corresponding columns.
             * @Default {true}
             */
            showHeader?: boolean;

            /** Displayed selected value and autocomplete search based on mentioned column value specified in that format.
             */
            stringFormat?: string;

            /** This property allows user to search text for any number of fields in the suggestion list without modifying the selected text format.
             */
            searchColumnIndices?: any[];

            /** Field and Header Text collections can be defined and customized through columns field.
             */
            columns?: MultiColumnSettingsColumn[];
        }

        enum Animation {

            ///Supports to animation type with none type only.
            None,

            ///Supports to animation type with slide type only.
            Slide,

            ///Supports to animation type with fade type only.
            Fade
        }


        enum MultiSelectMode {

            ///Multiple values are separated using a given special character.
            Delimiter,

            ///Each values are displayed in separate box with close button.
            VisualMode
        }


        enum SortOrder {

            ///Items to be displayed in the suggestion list in ascending order.
            Ascending,

            ///Items to be displayed in the suggestion list in descending order.
            Descending
        }

    }

    class Button extends ej.Widget {
        static fn: Button;
        constructor(element: JQuery | Element, options?: Button.Model);
        static Locale: any;
        model: Button.Model;
        defaults: Button.Model;

        /** destroy the button widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** To disable the button
         * @returns {void}
         */
        disable(): void;

        /** To enable the button
         * @returns {void}
         */
        enable(): void;
    }
    export namespace Button {

        export interface Model {

            /** Specifies the contentType of the Button. See below to know available ContentType
             * @Default {ej.ContentType.TextOnly}
             */
            contentType?: ej.ContentType|string;

            /** Sets the root CSS class for Button theme, which is used customize.
             */
            cssClass?: string;

            /** Specifies the button control state.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specify the Right to Left direction to button
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specifies the height of the Button.
             * @Default {28}
             */
            height?: number;

            /** It allows to define the characteristics of the Button control. It will helps to extend the capability of an HTML element.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specifies the image position of the Button. This image position is applicable only with the textandimage contentType property. The images can be positioned in both imageLeft and
             * imageRight options. See below to know about available ImagePosition
             * @Default {ej.ImagePosition.ImageLeft}
             */
            imagePosition?: ej.ImagePosition|string;

            /** Specifies the primary icon for Button. This icon will be displayed from the left margin of the button.
             * @Default {null}
             */
            prefixIcon?: string;

            /** Convert the button as repeat button. It raises the 'Click' event repeatedly from the it is pressed until it is released.
             * @Default {false}
             */
            repeatButton?: boolean;

            /** Displays the Button with rounded corners.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies the size of the Button. See below to know available ButtonSize
             * @Default {ej.ButtonSize.Normal}
             */
            size?: ej.ButtonSize|string;

            /** Specifies the secondary icon for Button. This icon will be displayed from the right margin of the button.
             * @Default {null}
             */
            suffixIcon?: string;

            /** Specifies the text content for Button.
             * @Default {null}
             */
            text?: string;

            /** Specified the time interval between two consecutive 'click' event on the button.
             * @Default {150}
             */
            timeInterval?: string;

            /** Specifies the Type of the Button. See below to know available ButtonType
             * @Default {ej.ButtonType.Submit}
             */
            type?: ej.ButtonType|string;

            /** Specifies the width of the Button.
             * @Default {100px}
             */
            width?: string|number;

            /** Fires when Button control is clicked successfully.Consider the scenario to perform any validation,modification of content or any other operations click on button,we can make use
             * of this click event to achieve the scenario.
             */
            click?(e: ClickEventArgs): void;

            /** Fires after Button control is created.If the user want to perform any operation after the button control creation then the user can make use of this create event.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the button is destroyed successfully.If the user want to perform any operation after the destroy button control then the user can make use of this destroy event.
             */
            destroy?(e: DestroyEventArgs): void;
        }

        export interface ClickEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the button model
             */
            model?: ej.Button.Model;

            /** returns the name of the event
             */
            type?: string;

            /** return the button state
             */
            status?: boolean;

            /** return the event model for sever side processing.
             */
            e?: any;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the button model
             */
            model?: ej.Button.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the button model
             */
            model?: ej.Button.Model;

            /** returns the name of the event
             */
            type?: string;
        }
    }
    enum ContentType {
        //To display the text content only in button
        TextOnly,
        //To display the image only in button
        ImageOnly,
        //Supports to display  image for both ends of the button
        ImageBoth,
        //Supports to display image with the text content
        TextAndImage,
        //Supports to display  image with both ends of the text
        ImageTextImage,
    }
    enum ImagePosition {
        //support for aligning text in left and image in right
        ImageRight,
        //support for aligning text in right and image in left
        ImageLeft,
        //support for aligning text in bottom and image in top.
        ImageTop,
        //support for aligning text in top and image in bottom
        ImageBottom,
    }
    enum ButtonSize {
        //Creates button with Built-in default size height, width specified
        Normal,
        //Creates button with Built-in mini size height, width specified
        Mini,
        //Creates button with Built-in small size height, width specified
        Small,
        //Creates button with Built-in medium size height, width specified
        Medium,
        //Creates button with Built-in large size height, width specified
        Large,
    }
    enum ButtonType {
        //Creates button with Built-in button type specified
        Button,
        //Creates button with Built-in reset type specified
        Reset,
        //Creates button with Built-in submit type specified
        Submit,
    }

    class Captcha extends ej.Widget {
        static fn: Captcha;
        constructor(element: JQuery | Element, options?: Captcha.Model);
        static Locale: any;
        model: Captcha.Model;
        defaults: Captcha.Model;
    }
    export namespace Captcha {

        export interface Model {

            /** Specifies the character set of the Captcha that will be used to generate captcha text randomly.
             */
            characterSet?: string;

            /** Specifies the error message to be displayed when the Captcha mismatch.
             */
            customErrorMessage?: string;

            /** Set the Captcha validation automatically.
             */
            enableAutoValidation?: boolean;

            /** Specifies the case sensitivity for the characters typed in the Captcha.
             */
            enableCaseSensitivity?: boolean;

            /** Specifies the background patterns for the Captcha.
             */
            enablePattern?: boolean;

            /** Sets the Captcha direction as right to left alignment.
             */
            enableRTL?: boolean;

            /** Specifies the background appearance for the captcha.
             */
            hatchStyle?: ej.HatchStyle|string;

            /** Specifies the height of the Captcha.
             */
            height?: number;

            /** Specifies the method with values to be mapped in the Captcha.
             */
            mapper?: string;

            /** Specifies the maximum number of characters used in the Captcha.
             */
            maximumLength?: number;

            /** Specifies the minimum number of characters used in the Captcha.
             */
            minimumLength?: number;

            /** Specifies the method to map values to Captcha.
             */
            requestMapper?: string;

            /** Sets the Captcha with audio support, that enables to dictate the captcha text.
             */
            showAudioButton?: boolean;

            /** Sets the Captcha with a refresh button.
             */
            showRefreshButton?: boolean;

            /** Specifies the target button of the Captcha to validate the entered text and captcha text.
             */
            targetButton?: string;

            /** Specifies the target input element that will verify the Captcha.
             */
            targetInput?: string;

            /** Specifies the width of the Captcha.
             */
            width?: number;

            /** Fires when captcha refresh begins.
             */
            refreshBegin?(e: RefreshBeginEventArgs): void;

            /** Fires after captcha refresh completed.
             */
            refreshComplete?(e: RefreshCompleteEventArgs): void;

            /** Fires when captcha refresh fails to load.
             */
            refreshFailure?(e: RefreshFailureEventArgs): void;

            /** Fires after captcha refresh succeeded.
             */
            refreshSuccess?(e: RefreshSuccessEventArgs): void;
        }

        export interface RefreshBeginEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Captcha model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface RefreshCompleteEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Captcha model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface RefreshFailureEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Captcha model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface RefreshSuccessEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Captcha model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }
    }
    enum HatchStyle {
        //Set background as None to Captcha
        None,
        //Set background as BackwardDiagonal to Captcha
        BackwardDiagonal,
        //Set background as Cross to Captcha
        Cross,
        //Set background as DarkDownwardDiagonal to Captcha
        DarkDownwardDiagonal,
        //Set background as DarkHorizontal to Captcha
        DarkHorizontal,
        //Set background as DarkUpwardDiagonal to Captcha
        DarkUpwardDiagonal,
        //Set background as DarkVertical to Captcha
        DarkVertical,
        //Set background as DashedDownwardDiagonal to Captcha
        DashedDownwardDiagonal,
        //Set background as DashedHorizontal to Captcha
        DashedHorizontal,
        //Set background as DashedUpwardDiagonal to Captcha
        DashedUpwardDiagonal,
        //Set background as DashedVertical to Captcha
        DashedVertical,
        //Set background as DiagonalBrick to Captcha
        DiagonalBrick,
        //Set background as DiagonalCross to Captcha
        DiagonalCross,
        //Set background as Divot to Captcha
        Divot,
        //Set background as DottedDiamond to Captcha
        DottedDiamond,
        //Set background as DottedGrid to Captcha
        DottedGrid,
        //Set background as ForwardDiagonal to Captcha
        ForwardDiagonal,
        //Set background as Horizontal to Captcha
        Horizontal,
        //Set background as HorizontalBrick to Captcha
        HorizontalBrick,
        //Set background as LargeCheckerBoard to Captcha
        LargeCheckerBoard,
        //Set background as LargeConfetti to Captcha
        LargeConfetti,
        //Set background as LargeGrid to Captcha
        LargeGrid,
        //Set background as LightDownwardDiagonal to Captcha
        LightDownwardDiagonal,
        //Set background as LightHorizontal to Captcha
        LightHorizontal,
        //Set background as LightUpwardDiagonal to Captcha
        LightUpwardDiagonal,
        //Set background as LightVertical to Captcha
        LightVertical,
        //Set background as Max to Captcha
        Max,
        //Set background as Min to Captcha
        Min,
        //Set background as NarrowHorizontal to Captcha
        NarrowHorizontal,
        //Set background as NarrowVertical to Captcha
        NarrowVertical,
        //Set background as OutlinedDiamond to Captcha
        OutlinedDiamond,
        //Set background as Percent90 to Captcha
        Percent90,
        //Set background as Wave to Captcha
        Wave,
        //Set background as Weave to Captcha
        Weave,
        //Set background as WideDownwardDiagonal to Captcha
        WideDownwardDiagonal,
        //Set background as WideUpwardDiagonal to Captcha
        WideUpwardDiagonal,
        //Set background as ZigZag to Captcha
        ZigZag,
    }

    class ListBox extends ej.Widget {
        static fn: ListBox;
        constructor(element: JQuery | Element, options?: ListBox.Model);
        static Locale: any;
        model: ListBox.Model;
        defaults: ListBox.Model;

        /** Adds a given list items in the ListBox widget at a specified index. It accepts two parameters.
         * @param {any|string} This can be a list item object (for JSON binding) or a string (for UL and LI rendering). Also we can the specify this as an array of list item object or an
         * array of strings to add multiple items.
         * @param {number} The index value to add the given items at the specified index. If index is not specified, the given items will be added at the end of the list.
         * @returns {void}
         */
        addItem(listItem: any|string, index: number): void;

        /** Checks all the list items in the ListBox widget. It is dependent on showCheckbox property.
         * @returns {void}
         */
        checkAll(): void;

        /** Checks a list item by using its index. It is dependent on showCheckbox property.
         * @param {number} Index of the listbox item to be checked. If index is not specified, the given items will be added at the end of the list.
         * @returns {void}
         */
        checkItemByIndex(index: number): void;

        /** Checks multiple list items by using its index values. It is dependent on showCheckbox property.
         * @param {number[]} Index/Indices of the listbox items to be checked. If index is not specified, the given items will be added at the end of the list.
         * @returns {void}
         */
        checkItemsByIndices(indices: number[]): void;

        /** Disables the ListBox widget.
         * @returns {void}
         */
        disable(): void;

        /** Disables a list item by passing the item text as parameter.
         * @param {string} Text of the listbox item to be disabled.
         * @returns {void}
         */
        disableItem(text: string): void;

        /** Disables a list Item using its index value.
         * @param {number} Index of the listbox item to be disabled.
         * @returns {void}
         */
        disableItemByIndex(index: number): void;

        /** Disables set of list Items using its index values.
         * @param {number[]|string} Indices of the listbox items to be disabled.
         * @returns {void}
         */
        disableItemsByIndices(Indices: number[]|string): void;

        /** Enables the ListBox widget when it is disabled.
         * @returns {void}
         */
        enable(): void;

        /** Enables a list Item using its item text value.
         * @param {string} Text of the listbox item to be enabled.
         * @returns {void}
         */
        enableItem(text: string): void;

        /** Enables a list item using its index value.
         * @param {number} Index of the listbox item to be enabled.
         * @returns {void}
         */
        enableItemByIndex(index: number): void;

        /** Enables a set of list Items using its index values.
         * @param {number[]|string} Indices of the listbox items to be enabled.
         * @returns {void}
         */
        enableItemsByIndices(indices: number[]|string): void;

        /** Returns the list of checked items in the ListBox widget. It is dependent on showCheckbox property.
         * @returns {any}
         */
        getCheckedItems(): any;

        /** Returns the list of selected items in the ListBox widget.
         * @returns {any}
         */
        getSelectedItems(): any;

        /** Returns an itemâ€™s index based on the given text.
         * @param {string} The list item text (label)
         * @returns {number}
         */
        getIndexByText(text: string): number;

        /** Returns an itemâ€™s index based on the value given.
         * @param {string} The list itemâ€™s value
         * @returns {number}
         */
        getIndexByValue(indices: string): number;

        /** Returns an itemâ€™s text (label) based on the index given.
         * @returns {string}
         */
        getTextByIndex(): string;

        /** Returns a list itemâ€™s object using its index.
         * @returns {any}
         */
        getItemByIndex(): any;

        /** Returns a list itemâ€™s object based on the text given.
         * @param {string} The list item text.
         * @returns {any}
         */
        getItemByText(text: string): any;

        /** Merges the given data with the existing data items in the listbox.
         * @param {any[]} Data to merge in listbox.
         * @returns {void}
         */
        mergeData(data: any[]): void;

        /** Selects the next item based on the current selection.
         * @returns {void}
         */
        moveDown(): void;

        /** Selects the previous item based on the current selection.
         * @returns {void}
         */
        moveUp(): void;

        /** Refreshes the ListBox widget.
         * @param {boolean} Refreshes both the datasource and the dimensions of the ListBox widget when the parameter is passed as true, otherwise only the ListBox dimensions will be
         * refreshed.
         * @returns {void}
         */
        refresh(refreshData: boolean): void;

        /** Removes all the list items from listbox.
         * @returns {void}
         */
        removeAll(): void;

        /** Removes the selected list items from the listbox.
         * @returns {void}
         */
        removeSelectedItems(): void;

        /** Removes a list item by using its text.
         * @param {string} Text of the listbox item to be removed.
         * @returns {void}
         */
        removeItemByText(text: string): void;

        /** Removes a list item by using its index value.
         * @param {number} Index of the listbox item to be removed.
         * @returns {void}
         */
        removeItemByIndex(index: number): void;

        /**
         * @returns {void}
         */
        selectAll(): void;

        /** Selects the list item using its text value.
         * @param {string} Text of the listbox item to be selected.
         * @returns {void}
         */
        selectItemByText(text: string): void;

        /** Selects list item using its value property.
         * @param {string} Value of the listbox item to be selected.
         * @returns {void}
         */
        selectItemByValue(value: string): void;

        /** Selects list item using its index value.
         * @param {number} Index of the listbox item to be selected.
         * @returns {void}
         */
        selectItemByIndex(index: number): void;

        /** Selects a set of list items through its index values.
         * @param {number|number[]} Index/Indices of the listbox item to be selected.
         * @returns {void}
         */
        selectItemsByIndices(Indices: number|number[]): void;

        /** Unchecks all the checked list items in the ListBox widget. To use this method showCheckbox property to be set as true.
         * @returns {void}
         */
        uncheckAll(): void;

        /** Unchecks a checked list item using its index value. To use this method showCheckbox property to be set as true.
         * @param {number} Index of the listbox item to be unchecked.
         * @returns {void}
         */
        uncheckItemByIndex(index: number): void;

        /** Unchecks the set of checked list items using its index values. To use this method showCheckbox property must be set to true.
         * @param {number[]|string} Indices of the listbox item to be unchecked.
         * @returns {void}
         */
        uncheckItemsByIndices(indices: number[]|string): void;

        /**
         * @returns {void}
         */
        unselectAll(): void;

        /** Unselects a selected list item using its index value
         * @param {number} Index of the listbox item to be unselected.
         * @returns {void}
         */
        unselectItemByIndex(index: number): void;

        /** Unselects a selected list item using its text value.
         * @param {string} Text of the listbox item to be unselected.
         * @returns {void}
         */
        unselectItemByText(text: string): void;

        /** Unselects a selected list item using its value.
         * @param {string} Value of the listbox item to be unselected.
         * @returns {void}
         */
        unselectItemByValue(value: string): void;

        /** Unselects a set of list items using its index values.
         * @param {number[]|string} Indices of the listbox item to be unselected.
         * @returns {void}
         */
        unselectItemsByIndices(indices: number[]|string): void;

        /** Hides all the checked items in the listbox.
         * @returns {void}
         */
        hideCheckedItems(): void;

        /** Shows a set of hidden list Items using its index values.
         * @param {number[]|string} Indices of the listbox items to be shown.
         * @returns {void}
         */
        showItemByIndices(indices: number[]|string): void;

        /** Hides a set of list Items using its index values.
         * @param {number[]|string} Indices of the listbox items to be hidden.
         * @returns {void}
         */
        hideItemsByIndices(indices: number[]|string): void;

        /** Shows the hidden list items using its values.
         * @param {any[]} Values of the listbox items to be shown.
         * @returns {void}
         */
        showItemsByValues(values: any[]): void;

        /** Hides the list item using its values.
         * @param {any[]} Values of the listbox items to be hidden.
         * @returns {void}
         */
        hideItemsByValues(values: any[]): void;

        /** Shows a hidden list item using its value.
         * @param {string} Value of the listbox item to be shown.
         * @returns {void}
         */
        showItemByValue(value: string): void;

        /** Hide a list item using its value.
         * @param {string} Value of the listbox item to be hidden.
         * @returns {void}
         */
        hideItemByValue(value: string): void;

        /** Shows a hidden list item using its index value.
         * @param {number} Index of the listbox item to be shown.
         * @returns {void}
         */
        showItemByIndex(index: number): void;

        /** Hides a list item using its index value.
         * @param {number} Index of the listbox item to be hidden.
         * @returns {void}
         */
        hideItemByIndex(index: number): void;

        /**
         * @returns {void}
         */
        show(): void;

        /** Hides the listbox.
         * @returns {void}
         */
        hide(): void;

        /** Hides all the listbox items in the listbox.
         * @returns {void}
         */
        hideAllItems(): void;

        /** Shows all the listbox items in the listbox.
         * @returns {void}
         */
        showAllItems(): void;
    }
    export namespace ListBox {

        export interface Model {

            /** Enables/disables the dragging behavior of the items in ListBox widget.
             * @Default {false}
             */
            allowDrag?: boolean;

            /** Accepts the items which are dropped in to it, when it is set to true.
             * @Default {false}
             */
            allowDrop?: boolean;

            /** Enables or disables multiple selection.
             * @Default {false}
             */
            allowMultiSelection?: boolean;

            /** Loads the list data on demand via scrolling behavior to improve the applicationâ€™s performance. There are two ways to load data which can be defined using â€œvirtualScrollModeâ€
             * property.
             * @Default {false}
             */
            allowVirtualScrolling?: boolean;

            /** Enables or disables the case sensitive search for list item by typing the text (search) value.
             * @Default {false}
             */
            caseSensitiveSearch?: boolean;

            /** Dynamically populate data of a list box while selecting an item in another list box i.e. rendering child list box based on the item selection in parent list box. This property
             * accepts the id of the child ListBox widget to populate the data.
             * @Default {null}
             */
            cascadeTo?: string;

            /** Set of list items to be checked by default using its index. It works only when the showCheckbox property is set to true.
             * @Default {null}
             */
            checkedIndices?: any[];

            /** The root class for the ListBox widget to customize the existing theme.
             * @Default {â€œâ€}
             */
            cssClass?: string;

            /** Contains the list of data for generating the list items.
             * @Default {null}
             */
            dataSource?: any;

            /** Enables or disables the ListBox widget.
             * @Default {true}
             */
            enabled?: boolean;

            /** Enables or disables the search behavior to find the specific list item by typing the text value.
             * @Default {false}
             */
            enableIncrementalSearch?: boolean;

            /** Allows the current model values to be saved in local storage or browser cookies for state maintenance when it is set to true.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Displays the ListBox widgetâ€™s content from right to left when enabled.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specifies ellipsis (&quot;...&quot;) representation in an overflowed list item content when it is set to false.
             * @Default {true}
             */
            enableWordWrap?: boolean;

            /** Mapping fields for the data items of the ListBox widget.
             * @Default {null}
             */
            fields?: Fields;

            /** Defines the height of the ListBox widget.
             * @Default {null}
             */
            height?: string;

            /** Defines the height for individual ListBox item.
             * @Default {null}
             */
            itemHeight?: string;

            /** The number of list items to be shown in the ListBox widget. The remaining list items will be scrollable.
             * @Default {null}
             */
            itemsCount?: number;

            /** The total number of list items to be rendered in the ListBox widget.
             * @Default {null}
             */
            totalItemsCount?: number;

            /** The number of list items to be loaded in the list box while enabling virtual scrolling and when virtualScrollMode is set to continuous.
             * @Default {5}
             */
            itemRequestCount?: number;

            /** Loads data for the listbox by default (i.e. on initialization) when it is set to true. It creates empty ListBox if it is set to false.
             * @Default {true}
             */
            loadDataOnInit?: boolean;

            /** The query to retrieve required data from the data source.
             * @Default {ej.Query()}
             */
            query?: ej.Query;

            /** The list item to be selected by default using its index.
             * @Default {null}
             */
            selectedIndex?: number;

            /** The list items to be selected by default using its indices. To use this property allowMultiSelection should be enabled.
             * @Default {[]}
             */
            selectedIndices?: any[];

            /** Enables/Disables the multi selection option with the help of checkbox control.
             * @Default {false}
             */
            showCheckbox?: boolean;

            /** To display the ListBox container with rounded corners.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Set to sort ListBox items either by Ascending or Descending order. By default sortOrder is set as enum type of &quot;None&quot;.You can use only below mentioned type for sorting
             * purpose.
             * @Default {ej.SortOrder.None}
             */
            sortOrder?: ej.ListBox.SortOrder|string;

            /** The template to display the ListBox widget with customized appearance.
             * @Default {null}
             */
            template?: string;

            /** Holds the selected items values and used to bind value to the list item using AngularJS and KnockoutJS.
             * @Default {â€œâ€}
             */
            value?: number;

            /** Specifies the virtual scroll mode to load the list data on demand via scrolling behavior. There are two types of mode.
             * @Default {ej.VirtualScrollMode.Normal}
             */
            virtualScrollMode?: ej.VirtualScrollMode|string;

            /** Defines the width of the ListBox widget.
             * @Default {null}
             */
            width?: string;

            /** Specifies the targetID for the listbox items.
             * @Default {null}
             */
            targetID?: string;

            /** Triggers before the AJAX request begins to load data in the ListBox widget.
             */
            actionBegin?(e: ActionBeginEventArgs): void;

            /** Triggers after the data requested via AJAX is successfully loaded in the ListBox widget.
             */
            actionSuccess?(e: ActionSuccessEventArgs): void;

            /** Triggers when the AJAX requests complete. The request may get failed or succeed.
             */
            actionComplete?(e: ActionCompleteEventArgs): void;

            /** Triggers when the data requested from AJAX get failed.
             */
            actionFailure?(e: ActionFailureEventArgs): void;

            /** Event will be triggered before the requested data via AJAX once loaded in successfully.
             */
            actionBeforeSuccess?(e: ActionBeforeSuccessEventArgs): void;

            /** Triggers when the item selection is changed.
             */
            change?(e: ChangeEventArgs): void;

            /** Triggers when the list item is checked or unchecked.
             */
            checkChange?(e: CheckChangeEventArgs): void;

            /** Triggers when the ListBox widget is created successfully.
             */
            create?(e: CreateEventArgs): void;

            /** Triggers when the ListBox widget is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggers when focus the listbox items.
             */
            focusIn?(e: FocusInEventArgs): void;

            /** Triggers when focus out from listbox items.
             */
            focusOut?(e: FocusOutEventArgs): void;

            /** Triggers when the list item is being dragged.
             */
            itemDrag?(e: ItemDragEventArgs): void;

            /** Triggers when the list item is ready to be dragged.
             */
            itemDragStart?(e: ItemDragStartEventArgs): void;

            /** Triggers when the list item stops dragging.
             */
            itemDragStop?(e: ItemDragStopEventArgs): void;

            /** Triggers when the list item is dropped.
             */
            itemDrop?(e: ItemDropEventArgs): void;

            /** Triggers when a list item gets selected.
             */
            select?(e: SelectEventArgs): void;

            /** Triggers when a list item gets unselected.
             */
            unselect?(e: UnselectEventArgs): void;
        }

        export interface ActionBeginEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the ListBox model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ActionSuccessEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns number of times trying to fetch the data
             */
            count?: number;

            /** returns the ListBox model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** Returns the query for data retrieval from the Database
             */
            request?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the number of items fetched from remote data
             */
            result?: any[];

            /** Returns the requested data
             */
            xhr?: any;
        }

        export interface ActionCompleteEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns number of times trying to fetch the data
             */
            count?: number;

            /** returns the ListBox model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** Returns the query for data retrieval from the Database
             */
            request?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the number of items fetched from remote data
             */
            result?: any[];

            /** Returns the requested data
             */
            xhr?: any;
        }

        export interface ActionFailureEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the error message
             */
            error?: any;

            /** returns the ListBox model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ActionBeforeSuccessEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** List of actual object.
             */
            actual?: any;

            /** Object of ListBox widget which contains DataManager arguments
             */
            request?: any;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** List of array object
             */
            result?: any[];

            /** ExecuteQuery object of DataManager
             */
            xhr?: any;
        }

        export interface ChangeEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** List item object.
             */
            item?: any;

            /** The Datasource of the listbox.
             */
            data?: any;

            /** List itemâ€™s index.
             */
            index?: number;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Boolean value based on whether the list item is checked or not.
             */
            isChecked?: boolean;

            /** Boolean value based on whether the list item is selected or not.
             */
            isSelected?: boolean;

            /** Boolean value based on the list item is enabled or not.
             */
            isEnabled?: boolean;

            /** List itemâ€™s text (label).
             */
            text?: string;

            /** List itemâ€™s value.
             */
            value?: string;
        }

        export interface CheckChangeEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** List item object.
             */
            item?: any;

            /** The Datasource of the listbox.
             */
            data?: any;

            /** List itemâ€™s index.
             */
            index?: number;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Boolean value based on whether the list item is checked or not.
             */
            isChecked?: boolean;

            /** Boolean value based on whether the list item is selected or not.
             */
            isSelected?: boolean;

            /** Boolean value based on the list item is enabled or not.
             */
            isEnabled?: boolean;

            /** List itemâ€™s text (label).
             */
            text?: string;

            /** List itemâ€™s value.
             */
            value?: string;
        }

        export interface CreateEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;
        }

        export interface DestroyEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;
        }

        export interface FocusInEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;
        }

        export interface FocusOutEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;
        }

        export interface ItemDragEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** The Datasource of the listbox.
             */
            data?: any;

            /** List itemâ€™s index.
             */
            index?: number;

            /** Boolean value based on whether the list item is checked or not.
             */
            isChecked?: boolean;

            /** Boolean value based on whether the list item is selected or not.
             */
            isSelected?: boolean;

            /** Boolean value based on whether the list item is enabled or not.
             */
            isEnabled?: boolean;

            /** List itemâ€™s text (label).
             */
            text?: string;

            /** List itemâ€™s value.
             */
            value?: string;
        }

        export interface ItemDragStartEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** The Datasource of the listbox.
             */
            data?: any;

            /** List itemâ€™s index.
             */
            index?: number;

            /** Boolean value based on whether the list item is checked or not.
             */
            isChecked?: boolean;

            /** Boolean value based on whether the list item is selected or not.
             */
            isSelected?: boolean;

            /** Boolean value based on whether the list item is enabled or not.
             */
            isEnabled?: boolean;

            /** List itemâ€™s text (label).
             */
            text?: string;

            /** List itemâ€™s value.
             */
            value?: string;
        }

        export interface ItemDragStopEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** The Datasource of the listbox.
             */
            data?: any;

            /** List itemâ€™s index.
             */
            index?: number;

            /** Boolean value based on whether the list item is checked or not.
             */
            isChecked?: boolean;

            /** Boolean value based on whether the list item is selected or not.
             */
            isSelected?: boolean;

            /** Boolean value based on whether the list item is enabled or not.
             */
            isEnabled?: boolean;

            /** List itemâ€™s text (label).
             */
            text?: string;

            /** List itemâ€™s value.
             */
            value?: string;
        }

        export interface ItemDropEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** The Datasource of the listbox.
             */
            data?: any;

            /** List itemâ€™s index.
             */
            index?: number;

            /** Boolean value based on whether the list item is checked or not.
             */
            isChecked?: boolean;

            /** Boolean value based on whether the list item is selected or not.
             */
            isSelected?: boolean;

            /** Boolean value based on whether the list item is enabled or not.
             */
            isEnabled?: boolean;

            /** List itemâ€™s text (label).
             */
            text?: string;

            /** List itemâ€™s value.
             */
            value?: string;
        }

        export interface SelectEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** List item object.
             */
            item?: any;

            /** The Datasource of the listbox.
             */
            data?: any;

            /** List itemâ€™s index.
             */
            index?: number;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Boolean value based on whether the list item is checked or not.
             */
            isChecked?: boolean;

            /** Boolean value based on whether the list item is selected or not.
             */
            isSelected?: boolean;

            /** Boolean value based on the list item is enabled or not.
             */
            isEnabled?: boolean;

            /** List itemâ€™s text (label).
             */
            text?: string;

            /** List itemâ€™s value.
             */
            value?: string;
        }

        export interface UnselectEventArgs {

            /** Instance of the listbox model object.
             */
            model?: ej.ListBox.Model;

            /** Name of the event.
             */
            type?: string;

            /** List item object.
             */
            item?: any;

            /** The Datasource of the listbox.
             */
            data?: any;

            /** List itemâ€™s index.
             */
            index?: number;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Boolean value based on whether the list item is checked or not.
             */
            isChecked?: boolean;

            /** Boolean value based on whether the list item is selected or not.
             */
            isSelected?: boolean;

            /** Boolean value based on the list item is enabled or not.
             */
            isEnabled?: boolean;

            /** List itemâ€™s text (label).
             */
            text?: string;

            /** List itemâ€™s value.
             */
            value?: string;
        }

        export interface Fields {

            /** Defines the specific field name which contains Boolean values to specify whether the list items to be checked by default or not.
             */
            checkBy?: boolean;

            /** The grouping in the ListBox widget can be defined using this field.
             */
            groupBy?: string;

            /** Defines the HTML attributes such as id, class, styles for the specific ListBox item.
             */
            htmlAttributes?: any;

            /** Defines the specific field name which contains id values for the list items.
             */
            id?: string;

            /** Defines the imageURL for the image to be displayed in the ListBox item.
             */
            imageUrl?: string;

            /** Defines the image attributes such as height, width, styles and so on.
             */
            imageAttributes?: string;

            /** Defines the specific field name which contains Boolean values to specify whether the list items to be selected by default or not.
             */
            selectBy?: boolean;

            /** Defines the sprite CSS class for the image to be displayed.
             */
            spriteCssClass?: string;

            /** Defines the table name to get the specific set of list items to be loaded in the ListBox widget while rendering with remote data.
             */
            tableName?: string;

            /** Defines the specific field name in the data source to load the list with data.
             */
            text?: string;

            /** Defines the specific field name in the data source to load the list with data value property.
             */
            value?: string;
        }

        enum SortOrder {

            ///The items are not sorted.
            None,

            ///To sort items in Ascending order.
            Ascending,

            ///To sort items in Descending order.
            Descending
        }

    }

    class Calculate {
        static fn: Calculate;
        constructor(element: JQuery | Element, options?: Calculate.Model);
        static Locale: any;
        model: Calculate.Model;
        defaults: Calculate.Model;

        /** Add the custom formulas with function in CalcEngine library
         * @param {string} pass the formula name
         * @param {string} pass the custom function name to call
         * @returns {void}
         */
        addCustomFunction(FormulaName: string, FunctionName: string): void;

        /** Adds a named range to the NamedRanges collection
         * @param {string} pass the namedRange's name
         * @param {string} pass the cell range of NamedRange
         * @returns {void}
         */
        addNamedRange(Name: string, cellRange: string): void;

        /** Accepts a possible parsed formula and returns the calculated value without quotes.
         * @param {string} pass the cell range to adjust its range
         * @returns {string}
         */
        adjustRangeArg(Name: string): string;

        /** When a formula cell changes, call this method to clear it from its dependent cells.
         * @param {string} pass the changed cell address
         * @returns {void}
         */
        clearFormulaDependentCells(Cell: string): void;

        /** Call this method to clear whether an exception was raised during the computation of a library function.
         * @returns {void}
         */
        clearLibraryComputationException(): void;

        /** Get the column index from a cell reference passed in.
         * @param {string} pass the cell address
         * @returns {void}
         */
        colIndex(Cell: string): void;

        /** Evaluates a parsed formula.
         * @param {string} pass the parsed formula
         * @returns {string}
         */
        computedValue(Formula: string): string;

        /** Evaluates a parsed formula.
         * @param {string} pass the parsed formula
         * @returns {string}
         */
        computeFormula(Formula: string): string;
    }
    export namespace Calculate {

        export interface Model {
        }
    }

    class CheckBox extends ej.Widget {
        static fn: CheckBox;
        constructor(element: JQuery | Element, options?: CheckBox.Model);
        static Locale: any;
        model: CheckBox.Model;
        defaults: CheckBox.Model;

        /** Destroy the CheckBox widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** Disable the CheckBox to prevent all user interactions.
         * @returns {void}
         */
        disable(): void;

        /** To enable the CheckBox
         * @returns {void}
         */
        enable(): void;

        /** To Check the status of CheckBox
         * @returns {boolean}
         */
        isChecked(): boolean;
    }
    export namespace CheckBox {

        export interface Model {

            /** Specifies whether CheckBox has to be in checked or not. We can also specify array of string as value for this property. If any of the value in the specified array matches the
             * value of the textbox, then it will be considered as checked. It will be useful in MVVM binding, specify array type to identify the values of the checked CheckBoxes.
             * @Default {false}
             */
            checked?: boolean|string[];

            /** Specifies the State of CheckBox.See below to get available CheckState
             * @Default {null}
             */
            checkState?: ej.CheckState|string;

            /** Sets the root CSS class for CheckBox theme, which is used customize.
             */
            cssClass?: string;

            /** Specifies the checkbox control state.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specifies the persist property for CheckBox while initialization. The persist API save current model value to browser cookies for state maintains. While refreshing the CheckBox
             * control page the model value apply from browser cookies.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Specify the Right to Left direction to Checkbox
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specifies the enable or disable Tri-State for checkbox control.
             * @Default {false}
             */
            enableTriState?: boolean;

            /** It allows to define the characteristics of the CheckBox control. It will helps to extend the capability of an HTML element.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specified value to be added an id attribute of the CheckBox.
             * @Default {null}
             */
            id?: string;

            /** Specify the prefix value of id to be added before the current id of the CheckBox.
             * @Default {ej}
             */
            idPrefix?: string;

            /** Specifies the name attribute of the CheckBox.
             * @Default {null}
             */
            name?: string;

            /** Displays rounded corner borders to CheckBox
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies the size of the CheckBox.See below to know available CheckboxSize
             * @Default {small}
             */
            size?: ej.CheckboxSize|string;

            /** Specifies the text content to be displayed for CheckBox.
             */
            text?: string;

            /** Set the jQuery validation error message in CheckBox.
             * @Default {null}
             */
            validationMessage?: any;

            /** Set the jQuery validation rules in CheckBox.
             * @Default {null}
             */
            validationRules?: any;

            /** Specifies the value attribute of the CheckBox.
             * @Default {null}
             */
            value?: string;

            /** Fires before the CheckBox is going to changed its state successfully
             */
            beforeChange?(e: BeforeChangeEventArgs): void;

            /** Fires when the CheckBox state is changed successfully
             */
            change?(e: ChangeEventArgs): void;

            /** Fires when the CheckBox state is created successfully
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the CheckBox state is destroyed successfully
             */
            destroy?(e: DestroyEventArgs): void;
        }

        export interface BeforeChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the CheckBox model
             */
            model?: ej.CheckBox.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event model values
             */
            event?: any;

            /** returns the status whether the element is checked or not.
             */
            isChecked?: boolean;
        }

        export interface ChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the CheckBox model
             */
            model?: ej.CheckBox.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event arguments
             */
            event?: any;

            /** returns the status whether the element is checked or not.
             */
            isChecked?: boolean;

            /** returns the state of the checkbox
             */
            checkState?: string;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the CheckBox model
             */
            model?: ej.CheckBox.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the CheckBox model
             */
            model?: ej.CheckBox.Model;

            /** returns the name of the event
             */
            type?: string;
        }
    }
    enum CheckState {
        //string
        Uncheck,
        //string
        Check,
        //string
        Indeterminate,
    }
    enum CheckboxSize {
        //Displays the CheckBox in medium size
        Medium,
        //Displays the CheckBox in small size
        Small,
    }

    class ColorPicker extends ej.Widget {
        static fn: ColorPicker;
        constructor(element: JQuery | Element, options?: ColorPicker.Model);
        static Locale: any;
        model: ColorPicker.Model;
        defaults: ColorPicker.Model;

        /** Disables the color picker control
         * @returns {void}
         */
        disable(): void;

        /** Enable the color picker control
         * @returns {void}
         */
        enable(): void;

        /** Gets the selected color in RGB format
         * @returns {any}
         */
        getColor(): any;

        /** Gets the selected color value as string
         * @returns {string}
         */
        getValue(): string;

        /** To Convert color value from hexCode to RGB
         * @param {string} Specified HEX code converted to RGB
         * @returns {any}
         */
        hexCodeToRGB(colorCode: string): any;

        /** Hides the ColorPicker popup, if in opened state.
         * @returns {void}
         */
        hide(): void;

        /** Convert color value from HSV to RGB
         * @param {any} Specified HSV code converted to RGB
         * @returns {any}
         */
        HSVToRGB(HSV: any): any;

        /** Convert color value from RGB to HEX
         * @param {any} Specified RGB code converted to HEX code
         * @returns {string}
         */
        RGBToHEX(RGB: any): string;

        /** Convert color value from RGB to HSV
         * @param {any} Specified RGB code converted to HSV code
         * @returns {any}
         */
        RGBToHSV(RGB: any): any;

        /** Open the ColorPicker popup.
         * @returns {void}
         */
        show(): void;
    }
    export namespace ColorPicker {

        export interface Model {

            /** The ColorPicker control allows to define the customized text to displayed in button elements. Using the property to achieve the customized culture values.
             * @Default {{ apply: Apply, cancel: Cancel, swatches: Swatches }}
             */
            buttonText?: ButtonText;

            /** Allows to change the mode of the button. Please refer below to know available button mode
             * @Default {ej.ButtonMode.Split}
             */
            buttonMode?: ej.ButtonMode|string;

            /** Specifies the number of columns to be displayed color palette model.
             * @Default {10}
             */
            columns?: number|string;

            /** This property allows you to customize its appearance using user-defined CSS and custom skin options such as colors and backgrounds.
             */
            cssClass?: string;

            /** This property allows to define the custom colors in the palette model.Custom palettes are created by passing a comma delimited string of HEX values or an array of colors.
             * @Default {empty}
             */
            custom?: any[];

            /** This property allows to embed the popup in the order of DOM element flow . When we set the value as true, the color picker popup is always in visible state.
             * @Default {false}
             */
            displayInline?: boolean;

            /** This property allows to change the control in enabled or disabled state.
             * @Default {true}
             */
            enabled?: boolean;

            /** This property allows to enable or disable the opacity slider in the color picker control
             * @Default {true}
             */
            enableOpacity?: boolean;

            /** It allows to define the characteristics of the ColorPicker control. It will helps to extend the capability of an HTML element.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Defines the localized text values in button and tooltip.
             * @Default {en-US}
             */
            locale?: string;

            /** Specifies the model type to be rendered initially in the color picker control. See below to get available ModelType
             * @Default {ej.ColorPicker.ModelType.Default}
             */
            modelType?: ej.ColorPicker.ModelType|string;

            /** This property allows to change the opacity value .The selected color opacity will be adjusted by using this opacity value.
             * @Default {100}
             */
            opacityValue?: number|string;

            /** Specifies the palette type to be displayed at initial time in palette model.There two types of palette model available in ColorPicker control. See below available Palette
             * @Default {ej.ColorPicker.Palette.BasicPalette}
             */
            palette?: ej.ColorPicker.Palette|string;

            /** This property allows to define the preset model to be rendered initially in palette type.It consists of 12 different types of presets. Each presets have 50 colors. See below
             * available Presets
             * @Default {ej.ColorPicker.Presets.Basic}
             */
            presetType?: ej.ColorPicker.Presets|string;

            /** Allows to show/hides the apply and cancel buttons in ColorPicker control
             * @Default {true}
             */
            showApplyCancel?: boolean;

            /** Allows to show/hides the clear button in ColorPicker control
             * @Default {true}
             */
            showClearButton?: boolean;

            /** This property allows to provides live preview support for current cursor selection color and selected color.
             * @Default {true}
             */
            showPreview?: boolean;

            /** This property allows to store the color values in custom list.The ColorPicker will keep up to 11 colors in a custom list.By clicking the add button, the selected color from picker
             * or palette will get added in the recent color list.
             * @Default {false}
             */
            showRecentColors?: boolean;

            /** Allows to show/hides the switcher button in ColorPicker control.It helps to switch palette or picker mode in colorpicker.
             * @Default {true}
             */
            showSwitcher?: boolean;

            /** This property allows to shows tooltip to notify the slider value in color picker control.
             * @Default {false}
             */
            showTooltip?: boolean;

            /** Specifies the toolIcon to be displayed in dropdown control color area.
             * @Default {null}
             */
            toolIcon?: string;

            /** This property allows to define the customized text or content to displayed when mouse over the following elements. This property also allows to use the culture values.
             * @Default {{ switcher: Switcher, addButton: Add Color, basic: Basic, monoChrome: Mono Chrome, flatColors: Flat Color, seaWolf: Sea Wolf, webColors: Web Colors, sandy: Sandy,
             * pinkShades: Pink Shades, misty: Misty, citrus: Citrus, vintage: Vintage, moonLight: Moon Light, candyCrush: Candy Crush, currentColor: Current Color, selectedColor: Selected
             * Color }}
             */
            tooltipText?: TooltipText;

            /** Specifies the color value for color picker control, the value is in hexadecimal form with prefix of &quot;#&quot;.
             * @Default {null}
             */
            value?: string;

            /** Fires after Color value has been changed successfully.If the user want to perform any operation after the color value changed then the user can make use of this change event.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires after closing the color picker popup.
             */
            close?(e: CloseEventArgs): void;

            /** Fires after Color picker control is created. If the user want to perform any operation after the color picker control creation then the user can make use of this create event.
             */
            create?(e: CreateEventArgs): void;

            /** Fires after Color picker control is destroyed. If the user want to perform any operation after the color picker control destroyed then the user can make use of this destroy event.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires after opening the color picker popup
             */
            open?(e: OpenEventArgs): void;

            /** Fires after Color value has been selected successfully. If the user want to perform any operation after the color value selected then the user can make use of this select event.
             */
            select?(e: SelectEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** return the previous color value
             */
            changeFrom?: string;

            /** returns the name of the event
             */
            type?: string;

            /** return the changed color value
             */
            value?: string;
        }

        export interface CloseEventArgs {

            /** returns the color picker model
             */
            model?: ej.ColorPicker.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface CreateEventArgs {

            /** returns the color picker model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the color picker model
             */
            model?: ej.ColorPicker.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface OpenEventArgs {

            /** returns the color picker model
             */
            model?: ej.ColorPicker.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface SelectEventArgs {

            /** returns the color picker model
             */
            model?: ej.ColorPicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** return the selected color value
             */
            value?: string;
        }

        export interface ButtonText {

            /** Sets the text for the apply button.
             */
            apply?: string;

            /** Sets the text for the cancel button.
             */
            cancel?: string;

            /** Sets the header text for the swatches area.
             */
            swatches?: string;
        }

        export interface TooltipText {

            /** Sets the tooltip text for the switcher button.
             */
            switcher?: string;

            /** Sets the tooltip text for the add button.
             */
            addButton?: string;

            /** Sets the tooltip text for the basic preset.
             */
            basic?: string;

            /** Sets the tooltip text for the mono chrome preset.
             */
            monoChrome?: string;

            /** Sets the tooltip text for the flat colors preset.
             */
            flatColors?: string;

            /** Sets the tooltip text for the sea wolf preset.
             */
            seaWolf?: string;

            /** Sets the tooltip text for the web colors preset.
             */
            webColors?: string;

            /** Sets the tooltip text for the sandy preset.
             */
            sandy?: string;

            /** Sets the tooltip text for the pink shades preset.
             */
            pinkShades?: string;

            /** Sets the tooltip text for the misty preset.
             */
            misty?: string;

            /** Sets the tooltip text for the citrus preset.
             */
            citrus?: string;

            /** Sets the tooltip text for the vintage preset.
             */
            vintage?: string;

            /** Sets the tooltip text for the moon light preset.
             */
            moonLight?: string;

            /** Sets the tooltip text for the candy crush preset.
             */
            candyCrush?: string;

            /** Sets the tooltip text for the current color area.
             */
            currentColor?: string;

            /** Sets the tooltip text for the selected color area.
             */
            selectedColor?: string;
        }

        enum ModelType {

            ///support palette type mode in color picker.
            Palette,

            ///support palette type mode in color picker.
            Picker
        }


        enum Palette {

            ///used to show the basic palette
            BasicPalette,

            ///used to show the custompalette
            CustomPalette
        }


        enum Presets {

            ///used to show the basic presets
            Basic,

            ///used to show the CandyCrush colors presets
            CandyCrush,

            ///used to show the Citrus colors presets
            Citrus,

            ///used to show the FlatColors presets
            FlatColors,

            ///used to show the Misty presets
            Misty,

            ///used to show the MoonLight presets
            MoonLight,

            ///used to show the PinkShades presets
            PinkShades,

            ///used to show the Sandy presets
            Sandy,

            ///used to show the Seawolf presets
            SeaWolf,

            ///used to show the Vintage presets
            Vintage,

            ///used to show the WebColors presets
            WebColors
        }

    }
    enum ButtonMode {
        //Displays the button in split mode
        Split,
        //Displays the button in Dropdown mode
        Dropdown,
    }

    class FileExplorer extends ej.Widget {
        static fn: FileExplorer;
        constructor(element: JQuery | Element, options?: FileExplorer.Model);
        static Locale: any;
        model: FileExplorer.Model;
        defaults: FileExplorer.Model;

        /** Refresh the size of FileExplorer control.
         * @returns {void}
         */
        adjustSize(): void;

        /** Disable the particular context menu item.
         * @param {string|HTMLElement} Id of the menu item/ Menu element to be disabled
         * @returns {void}
         */
        disableMenuItem(item: string|HTMLElement): void;

        /** Disable the particular toolbar item.
         * @param {string|HTMLElement} Id of the toolbar item/ Tool item element to be disabled
         * @returns {void}
         */
        disableToolbarItem(item: string|HTMLElement): void;

        /** Enable the particular context menu item.
         * @param {string|HTMLElement} Id of the menu item/ Menu element to be Enabled
         * @returns {void}
         */
        enableMenuItem(item: string|HTMLElement): void;

        /** Enable the particular toolbar item
         * @param {string|HTMLElement} Id of the tool item/ Tool item element to be Enabled
         * @returns {void}
         */
        enableToolbarItem(item: string|HTMLElement): void;

        /** Refresh the content of the selected folder in FileExplorer control.
         * @returns {void}
         */
        refresh(): void;

        /** Remove the particular toolbar item.
         * @param {string|HTMLElement} Id of the tool item/ tool item element to be removed
         * @returns {void}
         */
        removeToolbarItem(item: string|HTMLElement): void;
    }
    export namespace FileExplorer {

        export interface Model {

            /** Sets the URL of server side AJAX handling method that handles file operation like Read, Remove, Rename, Create, Upload, Download, Copy and Move in FileExplorer.
             */
            ajaxAction?: string;

            /** Specifies the data type of server side AJAX handling method.
             * @Default {json}
             */
            ajaxDataType?: string;

            /** By using ajaxSettings property, you can customize the AJAX configurations. Normally you can customize the following option in AJAX handling data, URL, type, async, contentType,
             * dataType and success. For upload, download and getImage API, you can only customize URL.
             * @Default {{ read: {}, createFolder: {}, remove: {}, rename: {}, paste: {}, getDetails: {}, download: {}, upload: {}, getImage: {}, search: {}}}
             */
            ajaxSettings?: any;

            /** The FileExplorer allows to move the files from one folder to another folder of FileExplorer by using drag and drop option. Also it supports to upload a file by dragging it from
             * windows explorer to the necessary folder of ejFileExplorer.
             * @Default {true}
             */
            allowDragAndDrop?: boolean;

            /** Gets or sets a value that indicates whether to enable keyboard support for FileExplorer actions.
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** The FileExplorer allows to select multiple files by enabling the allowMultiSelection property. You can perform multi selection by pressing the Ctrl key or Shift key.
             * @Default {true}
             */
            allowMultiSelection?: boolean;

            /** By using the contextMenuSettings property, you can customize the ContextMenu in the FileExplorer control.
             */
            contextMenuSettings?: ContextMenuSettings;

            /** Sets the root class for FileExplorer theme. This cssClass API allows to use custom skinning option for File Explorer control. By defining the root class by using this API, you
             * have to include this root class in CSS.
             */
            cssClass?: string;

            /** Specify the enablePersistence to FileExplorer to save the current model value in browser cookies for state maintains.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Enables or disables the resize support in FileExplorer control.
             * @Default {false}
             */
            enableResize?: boolean;

            /** Enables or disables the Right to Left alignment support in FileExplorer control.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Enables or disables the thumbnail image compression option in FileExplorer control. By enabling this option, you can reduce the thumbnail image size while loading.
             * @Default {false}
             */
            enableThumbnailCompress?: boolean;

            /** Allows specified type of files only to display in FileExplorer control.
             * @Default {* . *}
             */
            fileTypes?: string;

            /** By using filterSettings property, you can customize the search functionality of the search bar in FileExplorer control.
             */
            filterSettings?: FilterSettings;

            /** By using the gridSettings property, you can customize the grid behavior in the FileExplorer control.
             */
            gridSettings?: GridSettings;

            /** Specifies the height of FileExplorer control.
             * @Default {400}
             */
            height?: string|number;

            /** Enables or disables the responsive support for FileExplorer control during the window resizing time.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Sets the file view type. There are three view types available such as Grid, Tile and Large icons. See layoutType.
             * @Default {ej.FileExplorer.layoutType.Grid}
             */
            layout?: ej.FileExplorer.layoutType|string;

            /** Sets the culture in FileExplorer.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the maximum height of FileExplorer control.
             * @Default {null}
             */
            maxHeight?: string|number;

            /** Sets the maximum width of FileExplorer control.
             * @Default {null}
             */
            maxWidth?: string|number;

            /** Sets the minimum height of FileExplorer control.
             * @Default {250px}
             */
            minHeight?: string|number;

            /** Sets the minimum width of FileExplorer control.
             * @Default {400px}
             */
            minWidth?: string|number;

            /** The property path denotes the filesystem path that are to be explored. The path for the filesystem can be physical path or relative path, but it has to be relevant to where the
             * Web API is hosted.
             */
            path?: string;

            /** Sets the alias name of root folder name in FileExplorer. It is used to replace the actual root folder name in FileExplorer.
             */
            rootFolderName?: string;

            /** The selectedFolder is used to select the specified folder of FileExplorer control.
             */
            selectedFolder?: string;

            /** The selectedItems is used to select the specified items (file, folder) of FileExplorer control.
             */
            selectedItems?: string|any[];

            /** Enables or disables the checkbox option in FileExplorer control.
             * @Default {true}
             */
            showCheckbox?: boolean;

            /** Enables or disables the context menu option in FileExplorer control.
             * @Default {true}
             */
            showContextMenu?: boolean;

            /** Enables or disables the footer in FileExplorer control. The footer element displays the details of the current selected files and folders. And also the footer having the switcher
             * to change the layout view.
             * @Default {true}
             */
            showFooter?: boolean;

            /** FileExplorer control is displayed with rounded corner when this property is set to true.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** FileExplorer control is rendered with thumbnail preview of images in Tile and LargeIcons layout when this property set to true.
             * @Default {true}
             */
            showThumbnail?: boolean;

            /** Shows or disables the toolbar in FileExplorer control.
             * @Default {true}
             */
            showToolbar?: boolean;

            /** Enables or disables the navigation pane in FileExplorer control. The navigation pane contains a tree view element that displays all the folders from the filesystem in a
             * hierarchical manner. This is useful to a quick navigation of any folder in the filesystem.
             * @Default {true}
             */
            showNavigationPane?: boolean;

            /** The tools property is used to configure and group required toolbar items in FileExplorer control.
             * @Default {{ creation: [NewFolder], navigation: [Back, Forward, Upward], addressBar: [Addressbar], editing: [Refresh, Upload, Delete, Rename, Download], copyPaste: [Cut, Copy,
             * Paste], getProperties: [Details], searchBar: [Searchbar], layout: [Layout], sortBy: [SortBy]}}
             */
            tools?: any;

            /** The toolsList property is used to arrange the toolbar items in the FileExplorer control.
             * @Default {[layout, creation, navigation, addressBar, editing, copyPaste, sortBy, getProperties, searchBar]}
             */
            toolsList?: any[];

            /** Gets or sets an object that indicates whether to customize the upload behavior in the FileExplorer.
             */
            uploadSettings?: UploadSettings;

            /** Specifies the virtual item count for virtual support.
             * @Default {0}
             */
            virtualItemCount?: number;

            /** Specifies the width of FileExplorer control.
             * @Default {850}
             */
            width?: string|number;

            /** Fires before the AJAX request is performed.
             */
            beforeAjaxRequest?(e: BeforeAjaxRequestEventArgs): void;

            /** Fires before downloading the files.
             */
            beforeDownload?(e: BeforeDownloadEventArgs): void;

            /** Fires before getting a requested image from server. Also this event will be triggered when you have enabled thumbnail image compression option in FileExplorer.Using this event,
             * you can customize the image compression size.
             */
            beforeGetImage?(e: BeforeGetImageEventArgs): void;

            /** Fires before files or folders open.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** Fires before uploading the files.
             */
            beforeUpload?(e: BeforeUploadEventArgs): void;

            /** Fires before opening the upload dialog.
             */
            beforeUploadDialogOpen?(e: BeforeUploadDialogOpenEventArgs): void;

            /** Event is fired before the upload progress is started.
             */
            beforeUploadSend?(e: BeforeUploadSendEventArgs): void;

            /** Fires when FileExplorer control was created
             */
            create?(e: CreateEventArgs): void;

            /** Fires when file or folder is copied successfully.
             */
            copy?(e: CopyEventArgs): void;

            /** Fires when new folder is created successfully in file system.
             */
            createFolder?(e: CreateFolderEventArgs): void;

            /** Fires when file or folder is cut successfully.
             */
            cut?(e: CutEventArgs): void;

            /** Fires when the FileExplorer is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when the files or directory has been started to drag over on the FileExplorer
             */
            dragStart?(e: DragStartEventArgs): void;

            /** Fires when the files or directory is dragging over on the FileExplorer.
             */
            drag?(e: DragEventArgs): void;

            /** Fires when the files or directory has been stopped to drag over on FileExplorer
             */
            dragStop?(e: DragStopEventArgs): void;

            /** Fires when the files or directory is dropped to the target folder of FileExplorer
             */
            drop?(e: DropEventArgs): void;

            /** Fires after loading the requested image from server. Using this event, you can get the details of loaded image.
             */
            getImage?(e: GetImageEventArgs): void;

            /** Fires when keydown in FileExplorer control.
             */
            keydown?(e: KeydownEventArgs): void;

            /** Fires when the file view type is changed.
             */
            layoutChange?(e: LayoutChangeEventArgs): void;

            /** Fires when before the ContextMenu opening.
             */
            menuBeforeOpen?(e: MenuBeforeOpenEventArgs): void;

            /** Fires when click the ContextMenu item.
             */
            menuClick?(e: MenuClickEventArgs): void;

            /** Fires when ContextMenu is successfully opened.
             */
            menuOpen?(e: MenuOpenEventArgs): void;

            /** Fires when files are successfully opened.
             */
            open?(e: OpenEventArgs): void;

            /** Fires when a file or folder is pasted successfully.
             */
            paste?(e: PasteEventArgs): void;

            /** Fires when file or folder is deleted successfully.
             */
            remove?(e: RemoveEventArgs): void;

            /** Fires when resizing is performed for FileExplorer.
             */
            resize?(e: ResizeEventArgs): void;

            /** Fires when resizing is started for FileExplorer.
             */
            resizeStart?(e: ResizeStartEventArgs): void;

            /** Fires this event when the resizing is stopped for FileExplorer.
             */
            resizeStop?(e: ResizeStopEventArgs): void;

            /** Fires when the items from grid view or tile view of FileExplorer control is selected.
             */
            select?(e: SelectEventArgs): void;

            /** Triggered when refresh the template column elements in the grid view of FileExplorer control.
             */
            templateRefresh?(e: TemplateRefreshEventArgs): void;

            /** Fires when the items from grid view or tile view or large icons view of FileExplorer control is unselected.
             */
            unselect?(e: UnselectEventArgs): void;

            /** Event is fired when the file upload progress gets completed.
             */
            uploadComplete?(e: UploadCompleteEventArgs): void;

            /** Event is fired when the file upload fails due to some error.
             */
            uploadError?(e: UploadErrorEventArgs): void;

            /** Event is fired when the file upload progress gets succeeded.
             */
            uploadSuccess?(e: UploadSuccessEventArgs): void;
        }

        export interface BeforeAjaxRequestEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the AJAX request data
             */
            data?: any;

            /** returns the FileExplorer model
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface BeforeDownloadEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the downloaded file names.
             */
            files?: string[];

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the path of currently opened item.
             */
            path?: string;

            /** returns the selected item details.
             */
            selectedItems?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface BeforeGetImageEventArgs {

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** enable or disable the image compress option.
             */
            canCompress?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the expected image size.
             */
            size?: any;

            /** returns the selected item details.
             */
            selectedItems?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface BeforeOpenEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the opened item type.
             */
            itemType?: string;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the path of currently opened item.
             */
            path?: string;

            /** returns the selected item details.
             */
            selectedItems?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface BeforeUploadEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the path of currently opened item.
             */
            path?: string;

            /** returns the selected item details.
             */
            selectedItems?: any;

            /** returns the upload item details.
             */
            uploadItemDetails?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface BeforeUploadDialogOpenEventArgs {

            /** returns Selected FileList objects
             */
            files?: any;

            /** returns the FileExplorer model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface BeforeUploadSendEventArgs {

            /** if the event is cancelled; otherwise, false
             */
            cancel?: boolean;

            /** selected FileList Object
             */
            files?: any;

            /** returns the upload model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** XHR-AJAX Object for reference
             */
            xhr?: any;
        }

        export interface CreateEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface CopyEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of copied file/folder.
             */
            name?: string[];

            /** returns the selected item details.
             */
            selectedItems?: any;

            /** returns the source path.
             */
            sourcePath?: string;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface CreateFolderEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the AJAX response data
             */
            data?: any;

            /** returns the FileExplorer model
             */
            model?: ej.FileExplorer.Model;

            /** returns the selected item details
             */
            selectedItems?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface CutEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of moved file or folder.
             */
            name?: string[];

            /** returns the selected item details.
             */
            selectedItems?: any;

            /** returns the source path.
             */
            sourcePath?: string;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DragStartEventArgs {

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the dragging element.
             */
            target?: any;

            /** returns the path of dragging element.
             */
            targetPath?: string;

            /** returns the dragging file details.
             */
            selectedItems?: any;
        }

        export interface DragEventArgs {

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the target element.
             */
            target?: any;

            /** returns the name of target element.
             */
            targetElementName?: string;

            /** returns the path of target element.
             */
            targetPath?: string;
        }

        export interface DragStopEventArgs {

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the target element.
             */
            target?: any;

            /** returns the path of target element.
             */
            targetPath?: string;

            /** returns the name of target element
             */
            targetElementName?: string;

            /** returns the action, which is performed after dropping the files (upload/ move).
             */
            dropAction?: string;

            /** returns the dragging file details
             */
            fileInfo?: any;
        }

        export interface DropEventArgs {

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the target element.
             */
            target?: any;

            /** returns the name of target folder.
             */
            targetFolder?: string;

            /** returns the path of target folder.
             */
            targetPath?: string;

            /** returns the dragging element details.
             */
            fileInfo?: any;

            /** returns the action, which is performed after dropping the files (upload/ move).
             */
            dropAction?: string;
        }

        export interface GetImageEventArgs {

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** loaded image path.
             */
            path?: string;

            /** loaded image element
             */
            element?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** original arguments of image load or error event
             */
            originalArgs?: any;

            /** returns the action type, which specifies thumbnail preview or opening image.
             */
            action?: string;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface KeydownEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the downed key keyCode value
             */
            keyCode?: number;

            /** returns altKey value.
             */
            altKey?: boolean;

            /** returns shiftKey value.
             */
            shiftKey?: boolean;

            /** returns ctrlKey value.
             */
            ctrlKey?: boolean;

            /** returns the event object.
             */
            originalArgs?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface LayoutChangeEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** return true when we change the layout via interaction, else false.
             */
            isInteraction?: boolean;

            /** returns the current view type.
             */
            layoutType?: string;

            /** returns the FileExplorer model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface MenuBeforeOpenEventArgs {

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the name of ContextMenu items group.
             */
            contextMenu?: string;

            /** returns the dataSource of ContextMenu.
             */
            dataSource?: any[];

            /** returns the element of ContextMenu.
             */
            element?: any;

            /** returns the event of ContextMenu.
             */
            events?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the target element.
             */
            target?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface MenuClickEventArgs {

            /** returns the ID of clicked ContextMenu item.
             */
            ID?: string;

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the name of ContextMenu items group.
             */
            contextMenu?: string;

            /** returns the element of clicked ContextMenu item.
             */
            element?: any;

            /** returns the event of ContextMenu.
             */
            event?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the parent element ID of clicked ContextMenu item.
             */
            parentId?: string;

            /** returns the parent element text of clicked ContextMenu item.
             */
            parentText?: string;

            /** returns the text of clicked ContextMenu item.
             */
            text?: string;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface MenuOpenEventArgs {

            /** set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the name of ContextMenu items group.
             */
            contextMenu?: string;

            /** returns the element of ContextMenu.
             */
            element?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the target element.
             */
            target?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface OpenEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the opened item type.
             */
            itemType?: string;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the path of currently opened item.
             */
            path?: string;

            /** returns the selected item details.
             */
            selectedItems?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface PasteEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of moved/copied file or folder.
             */
            name?: string[];

            /** returns the selected item details.
             */
            selectedItems?: any;

            /** returns the target folder item details.
             */
            targetFolder?: any;

            /** returns the target path.
             */
            targetPath?: string;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface RemoveEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the AJAX response data.
             */
            data?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the names of deleted items.
             */
            name?: string;

            /** returns the path of deleted item.
             */
            path?: string;

            /** returns the removed item details.
             */
            selectedItems?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ResizeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mouse move event args.
             */
            event?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ResizeStartEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the mouse down event args.
             */
            event?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ResizeStopEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the mouse leave event args.
             */
            event?: any;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface SelectEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** returns the name of selected items.
             */
            name?: string[];

            /** returns the path of selected items.
             */
            path?: string;

            /** returns the selected item details
             */
            selectedItems?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface TemplateRefreshEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** Returns the cell object.
             */
            cell?: ej.FileExplorer.Model;

            /** Returns the column object.
             */
            column?: any;

            /** Returns the current row data.
             */
            data?: any;

            /** Returns the grid model of FileExplorer.
             */
            model?: any;

            /** Returns the current row index.
             */
            rowIndex?: number;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface UnselectEventArgs {

            /** Returns the FileExplorer model.
             */
            model?: ej.FileExplorer.Model;

            /** Returns the name of unselected item.
             */
            name?: string;

            /** Returns the name of unselected items.
             */
            names?: string[];

            /** Returns the type of unselected item.
             */
            nodeType?: string;

            /** Returns the path of unselected item.
             */
            path?: string;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the unselected item details.
             */
            unselectedItem?: any;

            /** Returns the unselected items details.
             */
            unselectedItems?: any[];
        }

        export interface UploadCompleteEventArgs {

            /** AJAX event argument for reference
             */
            e?: any;

            /** details about the error information
             */
            error?: string;

            /** uploaded file list
             */
            files?: any;

            /** returns the Upload model
             */
            model?: any;

            /** response from the server
             */
            responseText?: string;

            /** successfully uploaded files list
             */
            success?: any;

            /** returns the name of the event
             */
            type?: string;

            /** XHR-AJAX Object for reference
             */
            xhr?: any;
        }

        export interface UploadErrorEventArgs {

            /** error event action details
             */
            action?: string;

            /** details about the error information
             */
            error?: string;

            /** returns the details of the uploaded files
             */
            files?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface UploadSuccessEventArgs {

            /** AJAX event argument for reference
             */
            e?: any;

            /** uploaded file list
             */
            files?: any;

            /** returns the Upload model
             */
            model?: any;

            /** response from the server
             */
            responseText?: string;

            /** returns the name of the event
             */
            type?: string;

            /** XHR-AJAX Object for reference
             */
            xhr?: any;
        }

        export interface ContextMenuSettings {

            /** The items property is used to configure and group the required ContextMenu items in FileExplorer control.
             * @Default {{% highlight javascript %}{navbar: [NewFolder, Upload, |, Delete, Rename, |, Cut, Copy, Paste, |, Getinfo],cwd: [Refresh, Paste,|, SortBy, |, NewFolder, Upload, |,
             * Getinfo],files: [Open, Download, |, Upload, |, Delete, Rename, |, Cut, Copy, Paste, |, OpenFolderLocation, Getinfo]}{% endhighlight %}}
             */
            items?: any;

            /** The customMenuFields property is used to define custom functionality for custom ContextMenu item's which are defined in items property.
             * @Default {[]}
             */
            customMenuFields?: any[];
        }

        export interface FilterSettings {

            /** It allows to search the text given in search Textbox in every keyup event. When this property was set as false, searching will works only on Enter key and searchbar blur.
             * @Default {true}
             */
            allowSearchOnTyping?: boolean;

            /** Enables or disables to perform the filter operation with case sensitive.
             * @Default {false}
             */
            caseSensitiveSearch?: boolean;

            /** Sets the search filter type. There are several filter types available such as &quot;startswith&quot;, &quot;contains&quot;, &quot;endswith&quot;. See filterType.
             * @Default {ej.FileExplorer.filterType.Contains}
             */
            filterType?: ej.FilterType|string;
        }

        export interface GridSettings {

            /** Allows to Resize the width of the columns by simply click and move the particular column header line.
             * @Default {true}
             */
            allowResizing?: boolean;

            /** Gets or sets a value that indicates whether to enable the dynamic sorting behavior on grid data. Sorting can be done through clicking on particular column header.
             * @Default {true}
             */
            allowSorting?: boolean;

            /** Gets or sets an object that indicates to render the grid with specified columns. You can use this property same as the column property in Grid control.
             * @Default {[{ field: name, headerText: Name, width: 30% }, { field: dateModified, headerText: Date Modified, width: 30% }, { field: type, headerText: Type, width: 15% }, { field:
             * size, headerText: Size, width: 12%, textAlign: right, headerTextAlign: left }]}
             */
            columns?: any[];
        }

        export interface UploadSettings {

            /** Enables or disables the multiple files upload. When it is enabled, you can upload multiple files at a time and when disabled, you can upload only one file at a time.
             * @Default {true}
             */
            allowMultipleFile?: boolean;

            /** Enables or disables the auto upload option while uploading files in FileExplorer control.
             * @Default {false}
             */
            autoUpload?: boolean;

            /** Specifies the actions for upload dialog during initialization.
             * @Default {{ modal:false, closeOnComplete:false, content:null, drag:true }}
             */
            dialogAction?: any;

            /** Specifies the position at which the upload dialog is displayed using X and Y values. X: Sets the left position value for dialog. Y: Sets the top position value for dialog.
             * @Default {null}
             */
            dialogPosition?: any;

            /** Specifies the maximum file size allowed to upload. It accepts the value in bytes.
             * @Default {31457280}
             */
            maxFileSize?: number;

            /** Specifies the file details which are to be displayed when selected for upload by setting the showFileDetails to true.
             * @Default {true}
             */
            showFileDetails?: boolean;
        }

        enum layoutType {

            ///Supports to display files in tile view
            Tile,

            ///Supports to display files in grid view
            Grid,

            ///Supports to display files as large icons
            LargeIcons
        }

    }

    class DatePicker extends ej.Widget {
        static fn: DatePicker;
        constructor(element: JQuery | Element, options?: DatePicker.Model);
        static Locale: any;
        model: DatePicker.Model;
        defaults: DatePicker.Model;

        /** Disables the DatePicker control.
         * @returns {void}
         */
        disable(): void;

        /** Enable the DatePicker control, if it is in disabled state.
         * @returns {void}
         */
        enable(): void;

        /** Returns the current date value in the DatePicker control.
         * @returns {string}
         */
        getValue(): string;

        /** sets the date value for the DatePicker.
         * @returns {string}
         */
        setValue(): string;

        /** Close the DatePicker popup, if it is in opened state.
         * @returns {void}
         */
        hide(): void;

        /** Opens the DatePicker popup.
         * @returns {void}
         */
        show(): void;
    }
    export namespace DatePicker {

        export interface Model {

            /** Used to allow or restrict the editing in DatePicker input field directly. By setting false to this API, You can only pick the date from DatePicker popup.
             * @Default {true}
             */
            allowEdit?: boolean;

            /** allow or restrict the drill down to multiple levels of view (month/year/decade) in DatePicker calendar
             * @Default {true}
             */
            allowDrillDown?: boolean;

            /** Disable the list of specified date value.
             * @Default {{}}
             */
            blackoutDates?: any;

            /** Sets the specified text value to the today button in the DatePicker calendar.
             * @Default {Today}
             */
            buttonText?: string;

            /** Sets the root CSS class for DatePicker theme, which is used customize.
             */
            cssClass?: string;

            /** Formats the value of the DatePicker in to the specified date format. If this API is not specified, dateFormat will be set based on the current culture of DatePicker.
             * @Default {MM/dd/yyyy}
             */
            dateFormat?: string;

            /** Specifies the header format of days in DatePicker calendar. See below to get available Headers options
             * @Default {ej.DatePicker.Header.Short}
             */
            dayHeaderFormat?: string|ej.DatePicker.Header;

            /** Specifies the navigation depth level in DatePicker calendar. This option is not applied when start level view option is lower than depth level view. See below to know available
             * levels in DatePicker Calendar
             */
            depthLevel?: string|ej.DatePicker.Level;

            /** Allows to embed the DatePicker calendar in the page. Also associates DatePicker with div element instead of input.
             * @Default {false}
             */
            displayInline?: boolean;

            /** Enables or disables the animation effect with DatePicker calendar.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** Enable or disable the DatePicker control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Sustain the entire widget model of DatePicker even after form post or browser refresh
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Displays DatePicker calendar along with DatePicker input field in Right to Left direction.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Allows to enter valid or invalid date in input textbox and indicate as error if it is invalid value, when this API value is set to true. For false value, invalid date is not
             * allowed to input field and corrected to valid date automatically, even if invalid date is given.
             * @Default {false}
             */
            enableStrictMode?: boolean;

            /** Used  the required fields for special Dates in DatePicker in order to customize the special dates in a calendar.
             * @Default {null}
             */
            fields?: Fields;

            /** Specifies the header format to be displayed in the DatePicker calendar.
             * @Default {MMMM yyyy}
             */
            headerFormat?: string;

            /** Specifies the height of the DatePicker input text.
             * @Default {28px}
             */
            height?: string;

            /** HighlightSection is used to highlight currently selected date's month/week/workdays. See below to get available HighlightSection options
             * @Default {none}
             */
            highlightSection?: string|ej.DatePicker.HighlightSection;

            /** Weekend  dates will be highlighted when this property is set to true.
             * @Default {false}
             */
            highlightWeekend?: boolean;

            /** Specifies the HTML Attributes of the DatePicker.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Change the DatePicker calendar and date format based on given culture.
             * @Default {en-US}
             */
            locale?: string;

            /** Specifies the maximum date in the calendar that the user can select.
             * @Default {new Date(2099, 11, 31)}
             */
            maxDate?: string|Date;

            /** Specifies the minimum date in the calendar that the user can select.
             * @Default {new Date(1900, 00, 01)}
             */
            minDate?: string|Date;

            /** Allows to toggles the read only state of the DatePicker. When the widget is readOnly, it doesn't allow your input.
             * @Default {false}
             */
            readOnly?: boolean;

            /** It allow to show/hide the disabled date ranges
             * @Default {true}
             */
            showDisabledRange?: boolean;

            /** It allows to display footer in DatePicker calendar.
             * @Default {true}
             */
            showFooter?: boolean;

            /** It allows to display/hides the other months days from the current month calendar in a DatePicker.
             * @Default {true}
             */
            showOtherMonths?: boolean;

            /** Shows/hides the date icon button at right side of textbox, which is used to open or close the DatePicker calendar popup.
             * @Default {true}
             */
            showPopupButton?: boolean;

            /** DatePicker input is displayed with rounded corner when this property is set to true.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Used to show the tooltip when hovering on the days in the DatePicker calendar.
             * @Default {true}
             */
            showTooltip?: boolean;

            /** Specifies the special dates in DatePicker.
             * @Default {null}
             */
            specialDates?: any;

            /** Specifies the start day of the week in DatePicker calendar.
             * @Default {0}
             */
            startDay?: number;

            /** Specifies the start level view in DatePicker calendar. See below available Levels
             * @Default {ej.DatePicker.Level.Month}
             */
            startLevel?: string|ej.DatePicker.Level;

            /** Specifies the number of months to be navigate for one click of next and previous button in a DatePicker Calendar.
             * @Default {1}
             */
            stepMonths?: number;

            /** Provides option to customize the tooltip format.
             * @Default {ddd MMM dd yyyy}
             */
            tooltipFormat?: string;

            /** Sets the jQuery validation support to DatePicker Date value. See validation
             * @Default {null}
             */
            validationMessage?: any;

            /** Sets the jQuery validation custom rules to the DatePicker. see validation
             * @Default {null}
             */
            validationRules?: any;

            /** sets or returns the current value of DatePicker
             * @Default {null}
             */
            value?: string|Date;

            /** Specifies the water mark text to be displayed in input text.
             * @Default {Select date}
             */
            watermarkText?: string;

            /** Allows to embed  a new column with the calendar in the popup, which will display the week number of every week in a calendar year.
             * @Default {false}
             */
            weekNumber?: boolean;

            /** Specifies the width of the DatePicker input text.
             * @Default {160px}
             */
            width?: string;

            /** Fires before closing the DatePicker popup.
             */
            beforeClose?(e: BeforeCloseEventArgs): void;

            /** Fires when each date is created in the DatePicker popup calendar.
             */
            beforeDateCreate?(e: BeforeDateCreateEventArgs): void;

            /** Fires before opening the DatePicker popup.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** Fires when the DatePicker input value is changed.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires when DatePicker popup is closed.
             */
            close?(e: CloseEventArgs): void;

            /** Fires when the DatePicker is created successfully.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the DatePicker is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when DatePicker input gets focus.
             */
            focusIn?(e: FocusInEventArgs): void;

            /** Fires when DatePicker input loses the focus.
             */
            focusOut?(e: FocusOutEventArgs): void;

            /** Fires when calender view navigates to month/year/decade/century.
             */
            navigate?(e: NavigateEventArgs): void;

            /** Fires when DatePicker popup is opened.
             */
            open?(e: OpenEventArgs): void;

            /** Fires when a date is selected from the DatePicker popup.
             */
            select?(e: SelectEventArgs): void;
        }

        export interface BeforeCloseEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the event parameters from DatePicker.
             */
            events?: any;

            /** returns the DatePicker popup.
             */
            element?: HTMLElement;
        }

        export interface BeforeDateCreateEventArgs {

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the currently created date object.
             */
            date?: any;

            /** returns the current DOM object of the date from the Calendar.
             */
            element?: HTMLElement;

            /** returns the currently created date as string type.
             */
            value?: string;
        }

        export interface BeforeOpenEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the event parameters from DatePicker.
             */
            events?: any;

            /** returns the DatePicker popup.
             */
            element?: HTMLElement;
        }

        export interface ChangeEventArgs {

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the DatePicker input value.
             */
            value?: string;

            /** returns the previously selected value.
             */
            prevDate?: string;
        }

        export interface CloseEventArgs {

            /** returns the current date object.
             */
            date?: any;

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the current date value.
             */
            value?: string;

            /** returns the previously selected value.
             */
            prevDate?: string;
        }

        export interface CreateEventArgs {

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface FocusInEventArgs {

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the currently selected date value.
             */
            value?: string;
        }

        export interface FocusOutEventArgs {

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the currently selected date value.
             */
            value?: string;

            /** returns the previously selected date value.
             */
            prevDate?: string;
        }

        export interface NavigateEventArgs {

            /** returns the current date object.
             */
            date?: any;

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the previous view state of calendar.
             */
            navigateFrom?: string;

            /** returns the current view state of calendar.
             */
            navigateTo?: string;

            /** returns the name of the event
             */
            type?: string;

            /** returns the current date value.
             */
            value?: string;
        }

        export interface OpenEventArgs {

            /** returns the current date object.
             */
            date?: any;

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the current date value.
             */
            value?: string;

            /** returns the previously selected value.
             */
            prevDate?: string;
        }

        export interface SelectEventArgs {

            /** returns the selected date object.
             */
            date?: any;

            /** returns the DatePicker model.
             */
            model?: ej.DatePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the current date value.
             */
            value?: string;

            /** returns the previously selected value.
             */
            prevDate?: string;

            /** returns whether the  currently selected date is special date or not.
             */
            isSpecialDay?: string;
        }

        export interface Fields {

            /** Specifies the specials dates
             */
            date?: string;

            /** Specifies the icon class to special dates.
             */
            iconClass?: string;

            /** Specifies the tooltip to special dates.
             */
            tooltip?: string;

            /** Specifies the CSS class to customize the date.
             */
            cssClass?: string;
        }

        enum Header {

            ///Removes day header in DatePicker
            None,

            ///sets  the short format of day name (like Sun) in header in DatePicker
            Short,

            ///sets  the Min format of day name (like su) in header format DatePicker
            Min
        }


        enum Level {

            ///allow  navigation upto year level in  DatePicker
            Year,

            ///allow  navigation upto decade level in  DatePicker
            Decade,

            ///allow  navigation upto Century level in  DatePicker
            Century
        }


        enum HighlightSection {

            ///Highlight the week of the currently  selected date in DatePicker popup calendar
            Week,

            ///Highlight the workdays in a currently  selected date's week in DatePicker popup calendar
            WorkDays,

            ///Nothing will be highlighted, remove highlights from DatePicker popup calendar if already exists
            None
        }

    }

    class DateTimePicker extends ej.Widget {
        static fn: DateTimePicker;
        constructor(element: JQuery | Element, options?: DateTimePicker.Model);
        static Locale: any;
        model: DateTimePicker.Model;
        defaults: DateTimePicker.Model;

        /** Disables the DateTimePicker control.
         * @returns {void}
         */
        disable(): void;

        /** Enables the DateTimePicker control.
         * @returns {void}
         */
        enable(): void;

        /** Returns the current datetime value in the DateTimePicker.
         * @returns {string}
         */
        getValue(): string;

        /** Hides or closes the DateTimePicker popup.
         * @returns {void}
         */
        hide(): void;

        /** Updates the current system date value and time value to the DateTimePicker.
         * @returns {void}
         */
        setCurrentDateTime(): void;

        /** Shows or opens the DateTimePicker popup.
         * @returns {void}
         */
        show(): void;
    }
    export namespace DateTimePicker {

        export interface Model {

            /** Used to allow or restrict the editing in DateTimePicker input field directly. By setting false to this API, You can only pick the date and time values from DateTimePicker popup.
             * @Default {true}
             */
            allowEdit?: boolean;

            /** Displays the custom text for the buttons inside the DateTimePicker popup. when the culture value changed, we can change the buttons text based on the culture.
             * @Default {{ today: Today, timeNow: Time Now, done: Done, timeTitle: Time }}
             */
            buttonText?: ButtonText;

            /** Disable the list of specified date value.
             * @Default {{}}
             */
            blackoutDates?: any;

            /** Set the root class for DateTimePicker theme. This cssClass API helps to use custom skinning option for DateTimePicker control.
             */
            cssClass?: string;

            /** Defines the datetime format displayed in the DateTimePicker. The value should be a combination of date format and time format.
             * @Default {M/d/yyyy h:mm tt}
             */
            dateTimeFormat?: string;

            /** Specifies the header format of the datepicker inside the DateTimePicker popup. See DatePicker.Header
             * @Default {ej.DatePicker.Header.Short}
             */
            dayHeaderFormat?: ej.DatePicker.Header|string;

            /** Specifies the navigation depth level in DatePicker calendar inside DateTimePicker popup. This option is not applied when start level view option is lower than depth level view.
             * See ej.DatePicker.Level
             */
            depthLevel?: ej.DatePicker.Level|string;

            /** Specifies the list of time range to be disabled.
             * @Default {{}}
             */
            disableTimeRanges?: any;

            /** Enable or disable the animation effect in DateTimePicker.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** When this property is set to false, it disables the DateTimePicker control.
             * @Default {false}
             */
            enabled?: boolean;

            /** Enables or disables the state maintenance of DateTimePicker.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Sets the DateTimePicker direction as right to left alignment.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** When enableStrictMode true it allows the value outside of the range also but it highlights the textbox with error class, otherwise it internally changed to the correct value.
             * @Default {false}
             */
            enableStrictMode?: boolean;

            /** Specifies the header format to be displayed in the DatePicker calendar inside the DateTimePicker popup.
             * @Default {MMMM yyyy}
             */
            headerFormat?: string;

            /** Defines the height of the DateTimePicker textbox.
             * @Default {30}
             */
            height?: string|number;

            /** Specifies the HTML Attributes of the ejDateTimePicker
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Sets the time interval between the two adjacent time values in the time popup.
             * @Default {30}
             */
            interval?: number;

            /** Defines the localization culture for DateTimePicker.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the maximum value to the DateTimePicker. Beyond the maximum value an error class is added to the wrapper element when we set true to enableStrictMode.
             * @Default {new Date(12/31/2099 11:59:59 PM)}
             */
            maxDateTime?: string|Date;

            /** Sets the minimum value to the DateTimePicker. Behind the minimum value an error class is added to the wrapper element.
             * @Default {new Date(1/1/1900 12:00:00 AM)}
             */
            minDateTime?: string|Date;

            /** Specifies the popup position of DateTimePicker.See below to know available popup positions
             * @Default {ej.PopupPosition.Bottom}
             */
            popupPosition?: string|ej.popupPosition;

            /** Indicates that the DateTimePicker value can only be read and canâ€™t change.
             * @Default {false}
             */
            readOnly?: boolean;

            /** It allows showing days in other months of DatePicker calendar inside the DateTimePicker popup.
             * @Default {true}
             */
            showOtherMonths?: boolean;

            /** Shows or hides the arrow button from the DateTimePicker textbox. When the button disabled, the DateTimePicker popup opens while focus in the textbox and hides while focus out from
             * the textbox.
             * @Default {true}
             */
            showPopupButton?: boolean;

            /** Changes the sharped edges into rounded corner for the DateTimePicker textbox and popup.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies the special dates in DateTimePicker.
             * @Default {null}
             */
            specialDates?: any;

            /** Specifies the start day of the week in datepicker inside the DateTimePicker popup.
             * @Default {1}
             */
            startDay?: number;

            /** Specifies the start level view in datepicker inside the DateTimePicker popup. See DatePicker.Level
             * @Default {ej.DatePicker.Level.Month or month}
             */
            startLevel?: ej.DatePicker.Level|string;

            /** Specifies the number of months to navigate at one click of next and previous button in datepicker inside the DateTimePicker popup.
             * @Default {1}
             */
            stepMonths?: number;

            /** Defines the time format displayed in the time dropdown inside the DateTimePicker popup.
             * @Default {h:mm tt}
             */
            timeDisplayFormat?: string;

            /** We can drill down up to time interval on selected date with meridian details.
             * @Default {{ enabled: false, interval: 5, showMeridian: false, autoClose: true }}
             */
            timeDrillDown?: TimeDrillDown;

            /** Defines the width of the time dropdown inside the DateTimePicker popup.
             * @Default {100}
             */
            timePopupWidth?: string|number;

            /** Set the jQuery validation error message in DateTimePicker.
             * @Default {null}
             */
            validationMessage?: any;

            /** Set the jQuery validation rules in DateTimePicker.
             * @Default {null}
             */
            validationRules?: any;

            /** Sets the DateTime value to the control.
             */
            value?: string|Date;

            /** Specifies the water mark text to be displayed in input text.
             * @Default {Select date and time}
             */
            watermarkText?: string;

            /** Defines the width of the DateTimePicker textbox.
             * @Default {143}
             */
            width?: string|number;

            /** Fires before the datetime popup closed in the DateTimePicker.
             */
            beforeClose?(e: BeforeCloseEventArgs): void;

            /** Fires before the datetime popup open in the DateTimePicker.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** Fires when the datetime value changed in the DateTimePicker textbox.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires when DateTimePicker popup closes.
             */
            close?(e: CloseEventArgs): void;

            /** Fires after DateTimePicker control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the DateTimePicker is destroyed successfully
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when the focus-in happens in the DateTimePicker textbox.
             */
            focusIn?(e: FocusInEventArgs): void;

            /** Fires when the focus-out happens in the DateTimePicker textbox.
             */
            focusOut?(e: FocusOutEventArgs): void;

            /** Fires when DateTimePicker popup opens.
             */
            open?(e: OpenEventArgs): void;
        }

        export interface BeforeCloseEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the DateTimePicker model.
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the event parameters from DateTimePicker.
             */
            events?: any;

            /** returns the DateTimePicker popup.
             */
            element?: HTMLElement;
        }

        export interface BeforeOpenEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the DateTimePicker model.
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the event parameters from DateTimePicker.
             */
            events?: any;

            /** returns the DateTimePicker popup.
             */
            element?: HTMLElement;
        }

        export interface ChangeEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the current value is valid or not
             */
            isValidState?: boolean;

            /** returns the modified datetime value
             */
            value?: string;

            /** returns the previously selected date time value
             */
            prevDateTime?: string;

            /** returns true if change event triggered by interaction, otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface CloseEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the modified datetime value
             */
            value?: string;

            /** returns the previously selected date time value
             */
            prevDateTime?: string;
        }

        export interface CreateEventArgs {

            /** returns the DateTimePicker model
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DateTimePicker model
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface FocusInEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the datetime value, which is in text box
             */
            value?: string;
        }

        export interface FocusOutEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the datetime value, which is in text box
             */
            value?: string;
        }

        export interface OpenEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.DateTimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the modified datetime value
             */
            value?: string;

            /** returns the previously selected date time value
             */
            prevDateTime?: string;
        }

        export interface ButtonText {

            /** Sets the text for the Done button inside the datetime popup.
             */
            done?: string;

            /** Sets the text for the Now button inside the datetime popup.
             */
            timeNow?: string;

            /** Sets the header text for the Time dropdown.
             */
            timeTitle?: string;

            /** Sets the text for the Today button inside the datetime popup.
             */
            today?: string;
        }

        export interface TimeDrillDown {

            /** This is the field to show/hide the timeDrillDown in DateTimePicker.
             */
            enabled?: boolean;

            /** Sets the interval time of minutes on selected date.
             */
            interval?: number;

            /** Allows the user to show or hide the meridian with time in DateTimePicker.
             */
            showMeridian?: boolean;

            /** After choosing the time, the popup will close automatically if we set it as true, otherwise we focus out the DateTimePicker or choose timeNow button for closing the popup.
             */
            autoClose?: boolean;
        }
    }
    enum popupPosition {
        //Opens the DateTimePicker popup below to the DateTimePicker input box
        Bottom,
        //Opens the DateTimePicker popup above to the DateTimePicker input box
        Top,
    }

    class DateRangePicker extends ej.Widget {
        static fn: DateRangePicker;
        constructor(element: JQuery | Element, options?: DateRangePicker.Model);
        static Locale: any;
        model: DateRangePicker.Model;
        defaults: DateRangePicker.Model;

        /** Add the preset ranges to DateRangePicker popup.
         * @param {string} Display name
         * @param {any[]} StartDate and endDate of range.
         * @returns {void}
         */
        addRanges(label: string, range: any[]): void;

        /** Clears the all ranges selections in DateRangePicker popup
         * @returns {void}
         */
        clearRanges(): void;

        /** Disables the DateRangePicker control.
         * @returns {void}
         */
        disable(): void;

        /** Enable the DateRangePicker control, if it is in disabled state.
         * @returns {void}
         */
        enable(): void;

        /** Returns the startDate and endDate values in the selected ranges in the DateRangePicker control.
         * @returns {any}
         */
        getSelectedRange(): any;

        /** Close the DateRangePicker popup, if it is in opened state.
         * @returns {void}
         */
        popupHide(): void;

        /** Opens the DateRangePicker popup.
         * @returns {void}
         */
        popupShow(): void;

        /** set the preset ranges to DateRangePicker popup.
         * @returns {void}
         */
        setRange(): void;
    }
    export namespace DateRangePicker {

        export interface Model {

            /** Used to allow or restrict the editing in DateRangePicker input field directly. By setting false to this API, You can only pick the date ranges from DateRangePicker popup.
             * @Default {true}
             */
            allowEdit?: boolean;

            /** Sets the specified text value to the available buttons (Reset, Cancel, Apply) in the DateRangePicker popup.
             * @Default {{ reset: Reset, cancel: Cancel, apply: Apply}}
             */
            buttonText?: any;

            /** Sets the root CSS class for DateRangePicker theme, which is used to customize.
             */
            cssClass?: string;

            /** Formats the date value of the DateRangePicker in to the specified date format. If this API is not specified, dateFormat will be set based on the current culture of DateRangePicker.
             * @Default {MM/dd/yyyy}
             */
            dateFormat?: string;

            /** Allows to embed the Timepicker align with the calendars in the page, two timepicker will be render, for selecting start and end date.
             * @Default {false}
             */
            enableTimePicker?: boolean;

            /** Enable or disable the DateRangePicker control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Sustain the entire widget model of DateRangePicker even after form post or browser refresh
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Specifies the end date of the date ranges.
             * @Default {null}
             */
            endDate?: string|Date;

            /** Specifies the height of the DateRangePicker input.
             * @Default {28px}
             */
            height?: string|number;

            /** Change the DateRangePicker calendar and date format based on given culture.
             * @Default {en-US}
             */
            locale?: string;

            /** Specifies the maximum date in the calendar that the user can select as a startDate or endDate.
             * @Default {new Date(2099, 11, 31)}
             */
            maxDate?: string|Date;

            /** Specifies the minimum date in the calendar that the user can select as a startDate or endDate.
             * @Default {new Date(1900, 00, 01)}
             */
            minDate?: string|Date;

            /** Used to add the preset ranges. Added ranges using this, will show in popup in right side for easy selection of different preset ranges.
             * @Default {null}
             */
            ranges?: any;

            /** Used to separate the two date strings of the value in the DateRangePicker popup.
             * @Default {-}
             */
            separator?: string;

            /** Specifies the start date of the date ranges
             * @Default {null}
             */
            startDate?: string|Date;

            /** Shows/hides the date icon button at right side of textbox, which is used to open or close the DateRangePicker calendar popup.
             * @Default {true}
             */
            showPopupButton?: boolean;

            /** DateRangePicker input and popup is displayed with rounded corner when this property is set to true.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Formats the date value of the DateRangePicker in to the specified time format. If this API is not specified, timeFormat will be set based on the current culture of DateRangePicker.
             * @Default {HH:mm tt}
             */
            timeFormat?: string;

            /** Separated two date values in string format to sets the date ranges in calendars.
             * @Default {null}
             */
            value?: string;

            /** Specifies the water mark text to be displayed in input text.
             * @Default {Select Range}
             */
            watermarkText?: string;

            /** Specifies the width of the DateRangePicker input text.
             * @Default {160px}
             */
            width?: string|number;

            /** Fires before closing the DateRangePicker popup.
             */
            beforeClose?(e: BeforeCloseEventArgs): void;

            /** Fires before opening the DateRangePicker popup.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** Fires when the DateRangePicker values get changed.
             */
            Change?(e: ChangeEventArgs): void;

            /** Fires when DateRangePicker popup is closed.
             */
            close?(e: CloseEventArgs): void;

            /** Fires when the DateRangePicker is created successfully.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the DateRangePicker is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when DateRangePicker popup is opened.
             */
            open?(e: OpenEventArgs): void;

            /** Fires when a date ranges is selected from the DateRangePicker popup.
             */
            select?(e: SelectEventArgs): void;
        }

        export interface BeforeCloseEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the DateRangePicker model
             */
            model?: ej.DateRangePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the event parameters from DateRangePicker.
             */
            events?: any;

            /** returns the DateRangePicker popup.
             */
            element?: HTMLElement;
        }

        export interface BeforeOpenEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the DateRangePicker model.
             */
            model?: ej.DateRangePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the event parameters from DateRangePicker.
             */
            events?: any;

            /** returns the DateRangePicker popup.
             */
            element?: HTMLElement;
        }

        export interface ChangeEventArgs {

            /** returns the DateRangePicker model.
             */
            model?: ej.DateRangePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the DateRangePicker input value.
             */
            value?: string;

            /** returns the startDate of DateRangePicker.
             */
            startDate?: any;

            /** returns the endDate of the DateRangePicker popup.
             */
            endDate?: any;
        }

        export interface CloseEventArgs {

            /** returns the current date object.
             */
            date?: any;

            /** returns the DateRangePicker model.
             */
            model?: ej.DateRangePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the DateRangePicker popup.
             */
            element?: HTMLElement;
        }

        export interface CreateEventArgs {

            /** returns the DateRangePicker model.
             */
            model?: ej.DateRangePicker.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the DateRangePicker model.
             */
            model?: ej.DateRangePicker.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface OpenEventArgs {

            /** returns the current date object.
             */
            date?: any;

            /** returns the DateRangePicker model.
             */
            model?: ej.DateRangePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the DateRangePicker popup.
             */
            element?: HTMLElement;
        }

        export interface SelectEventArgs {

            /** returns the selected date object.
             */
            startDate?: any;

            /** returns the DateRangePicker model.
             */
            model?: ej.DateRangePicker.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the current date value.
             */
            endDate?: any;
        }
    }

    class Dialog extends ej.Widget {
        static fn: Dialog;
        constructor(element: JQuery | Element, options?: Dialog.Model);
        static Locale: any;
        model: Dialog.Model;
        defaults: Dialog.Model;

        /** Closes the dialog widget dynamically.
         * @returns {any}
         */
        close(): any;

        /** Collapses the content area when it is expanded.
         * @returns {any}
         */
        collapse(): any;

        /** Destroys the Dialog widget.
         * @returns {void}
         */
        destroy(): void;

        /** Expands the content area when it is collapsed.
         * @returns {any}
         */
        expand(): any;

        /** Checks whether the Dialog widget is opened or not. This methods returns Boolean value.
         * @returns {boolean}
         */
        isOpen(): boolean;

        /** Maximizes the Dialog widget.
         * @returns {any}
         */
        maximize(): any;

        /** Minimizes the Dialog widget.
         * @returns {any}
         */
        minimize(): any;

        /** Opens the Dialog widget.
         * @returns {any}
         */
        open(): any;

        /** Pins the dialog in its current position.
         * @returns {any}
         */
        pin(): any;

        /** Refreshes the dialog content dynamically.
         * @returns {void}
         */
        refresh(): void;

        /** Restores the dialog.
         * @returns {any}
         */
        restore(): any;

        /** Unpins the Dialog widget.
         * @returns {any}
         */
        unpin(): any;

        /** Sets the title for the Dialog widget.
         * @param {string} The title for the dialog widget.
         * @returns {any}
         */
        setTitle(Title: string): any;

        /** Sets the content for the Dialog widget dynamically.
         * @param {string} The content for the dialog widget. It accepts both string and HTML string.
         * @returns {any}
         */
        setContent(content: string): any;

        /** Sets the focus on the Dialog widget.
         * @returns {any}
         */
        focus(): any;
    }
    export namespace Dialog {

        export interface Model {

            /** Adds action buttons like close, minimize, pin, maximize in the dialog header.
             */
            actionButtons?: string[];

            /** Specifies the ajaxSettings option to load the content to the Dialog control.
             * @Default {null}
             */
            ajaxSettings?: AjaxSettings;

            /** Enables or disables draggable.
             */
            allowDraggable?: boolean;

            /** Enables or disables keyboard interaction.
             */
            allowKeyboardNavigation?: boolean;

            /** Customizes the Dialog widget animations. The Dialog widget can be animated while opening and closing the dialog. In order to customize animation effects, you need to set
             * â€œenableAnimationâ€ as true. It contains the following sub properties.
             */
            animation?: any;

            /** To Enable or disable the scrolling for background element of the modal dialog. This will work only with modal dialog.
             */
            backgroundScroll?: boolean;

            /** Closes the dialog widget on pressing the ESC key when it is set to true.
             */
            closeOnEscape?: boolean;

            /** The selector for the container element. If the property is set, then dialog will append to the selected element and it is restricted to move only within the specified container
             * element.
             */
            containment?: string;

            /** The content type to load the dialog content at run time. The possible values are null, AJAX, iframe and image. When it is null (default value), the content inside dialog element
             * will be displayed as content and when it is not null, the content will be loaded from the URL specified in the contentUrl property.
             */
            contentType?: string;

            /** The URL to load the dialog content (such as AJAX, image, and iframe). In order to load content from URL, you need to set contentType as â€˜ajaxâ€™ or â€˜iframeâ€™ or â€˜imageâ€™.
             */
            contentUrl?: string;

            /** The root class for the Dialog widget to customize the existing theme.
             */
            cssClass?: string;

            /** Enable or disables animation when the dialog is opened or closed.
             */
            enableAnimation?: boolean;

            /** Enables or disables the Dialog widget.
             */
            enabled?: boolean;

            /** Enable or disables modal dialog. The modal dialog acts like a child window that is displayed on top of the main window/screen and disables the main window interaction until it is
             * closed.
             */
            enableModal?: boolean;

            /** Allows the current model values to be saved in local storage or browser cookies for state maintenance when it is set to true.
             */
            enablePersistence?: boolean;

            /** Allows the dialog to be resized. The dialog cannot be resized less than the minimum height, width values and greater than the maximum height and width.
             */
            enableResize?: boolean;

            /** Displays dialog content from right to left when set to true.
             */
            enableRTL?: boolean;

            /** The CSS class name to display the favicon in the dialog header. In order to display favicon, you need to set showHeader as true since the favicon will be displayed in the dialog
             * header.
             */
            faviconCSS?: string;

            /** Sets the height for the dialog widget. It accepts both string and integer values. For example, it can accepts values like â€œautoâ€, â€œ100%â€, â€œ100pxâ€ as string type and
             * â€œ100â€, â€œ500â€ as integer type.
             */
            height?: string|number;

            /** Specifies the HTML Attributes of the Dialog.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Enable or disables responsive behavior.
             */
            isResponsive?: boolean;

            /** Default Value:{:.param}â€œen-USâ€
             */
            locale?: string;

            /** Sets the maximum height for the dialog widget.
             */
            maxHeight?: string|number;

            /** Sets the maximum width for the dialog widget.
             */
            maxWidth?: string|number;

            /** Sets the minimum height for the dialog widget.
             */
            minHeight?: string|number;

            /** Sets the minimum width for the dialog widget.
             */
            minWidth?: string|number;

            /** Displays the Dialog widget at the given X and Y position.
             */
            position?: any;

            /** Shows or hides the dialog header.
             */
            showHeader?: boolean;

            /** The Dialog widget can be opened by default i.e. on initialization, when it is set to true.
             */
            showOnInit?: boolean;

            /** Enables or disables the rounder corner.
             */
            showRoundedCorner?: boolean;

            /** The selector for the container element. If this property is set, the dialog will be displayed (positioned) based on its container.
             */
            target?: string;

            /** The title text to be displayed in the dialog header. In order to set title, you need to set showHeader as true since the title will be displayed in the dialog header.
             */
            title?: string;

            /** Add or configure the tooltip text for actionButtons in the dialog header.
             */
            tooltip?: any;

            /** Sets the height for the dialog widget. It accepts both string and integer values. For example, it can accepts values like â€œautoâ€, â€œ100%â€, â€œ100pxâ€ as string type and
             * â€œ100â€, â€œ500â€ as integer type.
             */
            width?: string|number;

            /** Sets the z-index value for the Dialog widget.
             */
            zIndex?: number;

            /** Sets the Footer for the Dialog widget.
             */
            showFooter?: boolean;

            /** Sets the FooterTemplate for the Dialog widget.
             */
            footerTemplateId?: string;

            /** Triggered when the custom action button clicked.
             */
            actionButtonClick?(e: ActionButtonClickEventArgs): void;

            /** This event is triggered whenever the AJAX request fails to retrieve the dialog content.
             */
            ajaxError?(e: AjaxErrorEventArgs): void;

            /** This event is triggered whenever the AJAX request to retrieve the dialog content, gets succeed.
             */
            ajaxSuccess?(e: AjaxSuccessEventArgs): void;

            /** This event is triggered before the dialog widgets gets open.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** This event is triggered before the dialog widgets get closed.
             */
            beforeClose?(e: BeforeCloseEventArgs): void;

            /** This event is triggered after the dialog widget is closed.
             */
            close?(e: CloseEventArgs): void;

            /** Triggered when the dialog content is collapsed.
             */
            collapse?(e: CollapseEventArgs): void;

            /** Triggered after the dialog content is loaded in DOM.
             */
            contentLoad?(e: ContentLoadEventArgs): void;

            /** Triggered after the dialog is created successfully
             */
            create?(e: CreateEventArgs): void;

            /** Triggered after the dialog widget is destroyed successfully
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggered while the dialog is dragged.
             */
            drag?(e: DragEventArgs): void;

            /** Triggered when the user starts dragging the dialog.
             */
            dragStart?(e: DragStartEventArgs): void;

            /** Triggered when the user stops dragging the dialog.
             */
            dragStop?(e: DragStopEventArgs): void;

            /** Triggered when the dialog content is expanded.
             */
            expand?(e: ExpandEventArgs): void;

            /** Triggered after the dialog is opened.
             */
            open?(e: OpenEventArgs): void;

            /** Triggered while the dialog is resized.
             */
            resize?(e: ResizeEventArgs): void;

            /** Triggered when the user starts resizing the dialog.
             */
            resizeStart?(e: ResizeStartEventArgs): void;

            /** Triggered when the user stops resizing the dialog.
             */
            resizeStop?(e: ResizeStopEventArgs): void;
        }

        export interface ActionButtonClickEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Name of the event target attribute.
             */
            buttonID?: string;

            /** Name of the event.
             */
            type?: string;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event current target title.
             */
            currentTarget?: string;

            /** Name of the event.
             */
            event?: string;
        }

        export interface AjaxErrorEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** URL of the content.
             */
            URL?: string;

            /** Error page content.
             */
            responseText?: string;

            /** Error code.
             */
            status?: number;

            /** The corresponding error description.
             */
            statusText?: string;
        }

        export interface AjaxSuccessEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** URL of the content.
             */
            URL?: string;

            /** Response content.
             */
            data?: string;
        }

        export interface BeforeOpenEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event
             */
            type?: string;
        }

        export interface BeforeCloseEventArgs {

            /** Current event object.
             */
            event?: any;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** returns true when the dialog activated by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface CloseEventArgs {

            /** Current event object.
             */
            event?: any;

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event
             */
            type?: string;

            /** returns true when the Dialog activated by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface CollapseEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** returns true when the Dialog activated by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface ContentLoadEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** URL of the content.
             */
            URL?: string;

            /** Content type
             */
            contentType?: any;
        }

        export interface CreateEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;
        }

        export interface DragEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** Current event object.
             */
            event?: any;
        }

        export interface DragStartEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** Current event object.
             */
            event?: any;
        }

        export interface DragStopEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** Current event object.
             */
            event?: any;
        }

        export interface ExpandEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** returns true when the Dialog activated by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface OpenEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;
        }

        export interface ResizeEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event.
             */
            type?: string;

            /** Current event object.
             */
            event?: any;
        }

        export interface ResizeStartEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event
             */
            type?: string;

            /** Current event object.
             */
            event?: any;
        }

        export interface ResizeStopEventArgs {

            /** Set this option to true to cancel the event.
             */
            cancel?: boolean;

            /** Instance of the dialog model object.
             */
            model?: ej.Dialog.Model;

            /** Name of the event
             */
            type?: string;

            /** Current event object.
             */
            event?: any;
        }

        export interface AjaxSettings {

            /** It specifies, whether to enable or disable asynchronous request.
             */
            async?: boolean;

            /** It specifies the page will be cached in the web browser.
             */
            cache?: boolean;

            /** It specifies the type of data is send in the query string.
             */
            contentType?: string;

            /** It specifies the data as an object, will be passed in the query string.
             */
            data?: any;

            /** It specifies the type of data that you're expecting back from the response.
             */
            dataType?: string;

            /** It specifies the HTTP request type.
             */
            type?: string;
        }
    }

    class DropDownList extends ej.Widget {
        static fn: DropDownList;
        constructor(element: JQuery | Element, options?: DropDownList.Model);
        static Locale: any;
        model: DropDownList.Model;
        defaults: DropDownList.Model;

        /** Adding a single item or an array of items into the DropDownList allows you to specify all the field attributes such as value, template, image URL, and HTML attributes for those
         * items.Grouping and sorting will not be supported when we add items through this method.
         * @param {any|any[]}  this parameter should have field attributes with respect to mapped field attributes and it's corresponding values to fields
         * @returns {void}
         */
        addItem(data: any|any[]): void;

        /** This method is used to select all the items in the DropDownList.
         * @returns {void}
         */
        checkAll(): void;

        /** Clears the text in the DropDownList textbox.
         * @returns {void}
         */
        clearText(): void;

        /** Destroys the DropDownList widget.
         * @returns {void}
         */
        destroy(): void;

        /** This property is used to disable the DropDownList widget.
         * @returns {void}
         */
        disable(): void;

        /** This property disables the set of items in the DropDownList.
         * @param {string|number|any[]}  disable the given index list items
         * @returns {void}
         */
        disableItemsByIndices(index: string|number|any[]): void;

        /** This property enables the DropDownList control.
         * @returns {void}
         */
        enable(): void;

        /** Enables an Item or set of Items that are disabled in the DropDownList
         * @param {string|number|any[]}  enable the given index list items if it's disabled
         * @returns {void}
         */
        enableItemsByIndices(index: string|number|any[]): void;

        /** This method retrieves the items using given value.
         * @param {string|number|any}  Return the whole object of data based on given value
         * @returns {any[]}
         */
        getItemDataByValue(value: string|number|any): any[];

        /** This method is used to retrieve the items that are bound with the DropDownList.
         * @returns {any}
         */
        getListData(): any;

        /** This method is used to get the selected items in the DropDownList.
         * @returns {any[]}
         */
        getSelectedItem(): any[];

        /** This method is used to retrieve the items value that are selected in the DropDownList.
         * @returns {string}
         */
        getSelectedValue(): string;

        /** This method hides the suggestion popup in the DropDownList.
         * @returns {void}
         */
        hidePopup(): void;

        /** This method is used to select the list of items in the DropDownList through the Index of the items.
         * @param {string|number|any[]}  select the given index list items
         * @returns {void}
         */
        selectItemsByIndices(index: string|number|any[]): void;

        /** This method is used to select an item in the DropDownList by using the given text value.
         * @param {string|number|any[]}  select the list items relates to given text
         * @returns {void}
         */
        selectItemByText(index: string|number|any[]): void;

        /** This method is used to select an item in the DropDownList by using the given value.
         * @param {string|number|any[]}  select the list items relates to given values
         * @returns {void}
         */
        selectItemByValue(index: string|number|any[]): void;

        /** This method shows the DropDownList control with the suggestion popup.
         * @returns {void}
         */
        showPopup(): void;

        /** This method is used to unselect all the items in the DropDownList.
         * @returns {void}
         */
        unCheckAll(): void;

        /** This method is used to unselect the list of items in the DropDownList through Index of the items.
         * @param {string|number|any[]}  unselect the given index list items
         * @returns {void}
         */
        unselectItemsByIndices(index: string|number|any[]): void;

        /** This method is used to unselect an item in the DropDownList by using the given text value.
         * @param {string|number|any[]}  unselect the list items relates to given text
         * @returns {void}
         */
        unselectItemByText(index: string|number|any[]): void;

        /** This method is used to unselect an item in the DropDownList by using the given value.
         * @param {string|number|any[]}  unselect the list items relates to given values
         * @returns {void}
         */
        unselectItemByValue(index: string|number|any[]): void;
    }
    export namespace DropDownList {

        export interface Model {

            /** The Virtual Scrolling(lazy loading) feature is used to display a large amount of data that you require without buffering the entire load of a huge database records in the
             * DropDownList, that is, when scrolling, an AJAX request is sent to fetch some amount of data from the server dynamically. To achieve this scenario with DropDownList, set the
             * allowVirtualScrolling to true.
             * @Default {false}
             */
            allowVirtualScrolling?: boolean;

            /** The cascading DropDownLists is a series of two or more DropDownLists in which each DropDownList is filtered according to the previous DropDownListâ€™s value.
             * @Default {null}
             */
            cascadeTo?: string;

            /** Sets the case sensitivity of the search operation. It supports both enableFilterSearch and enableIncrementalSearch property.
             * @Default {false}
             */
            caseSensitiveSearch?: boolean;

            /** Dropdown widget's style and appearance can be controlled based on 13 different default built-in themes.You can customize the appearance of the dropdown by using the cssClass
             * property. You need to specify a class name in the cssClass property and the same class name is used before the class definitions wherever the custom styles are applied.
             */
            cssClass?: string;

            /** This property is used to serve data from the data services based on the query provided. To bind the data to the dropdown widget, the dataSource property is assigned with the
             * instance of the ej.DataManager.
             * @Default {null}
             */
            dataSource?: any;

            /** Sets the separator when the multiSelectMode with delimiter option or checkbox is enabled with the dropdown. When you enter the delimiter value, the texts after the delimiter are
             * considered as a separate word or query. The delimiter string is a single character and must be a symbol. Mostly, the delimiter symbol is used as comma (,) or semi-colon (;) or
             * any other special character.
             * @Default {','}
             */
            delimiterChar?: string;

            /** The enabled Animation property uses the easeOutQuad animation to SlideDown and SlideUp the Popup list in 200 and 100 milliseconds, respectively.
             * @Default {false}
             */
            enableAnimation?: boolean;

            /** This property is used to indicate whether the DropDownList control responds to the user interaction or not. By default, the control is in the enabled mode and you can disable it
             * by setting it to false.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specifies to perform incremental search for the selection of items from the DropDownList with the help of this property. This helps in selecting the item by using the typed
             * character.
             * @Default {true}
             */
            enableIncrementalSearch?: boolean;

            /** This property selects the item in the DropDownList when the item is entered in the Search textbox.
             * @Default {false}
             */
            enableFilterSearch?: boolean;

            /** The serverfiltering is to perform filter action when text is typed in the search box and filtering will be done based on the collection which contains the matched item from entire
             * datasource. Serverfiltering will be done based on the entire items in DataSource.
             * @Default {false}
             */
            enableServerFiltering?: boolean;

            /** Saves the current model value to the browser cookies for state maintenance. While refreshing the DropDownList control page, it retains the model value and it is applied from the
             * browser cookies.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** This enables the resize handler to resize the popup to any size.
             * @Default {false}
             */
            enablePopupResize?: boolean;

            /** Sets the DropDownList textbox direction from right to left align.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** This property is used to sort the Items in the DropDownList. By default, it sorts the items in an ascending order.
             * @Default {false}
             */
            enableSorting?: boolean;

            /** The property is used to determine whether the popup list is generated dynamically.
             * @Default {false}
             */
            loadOnDemand?: boolean;

            /** Specifies the mapping fields for the data items of the DropDownList.
             * @Default {null}
             */
            fields?: Fields;

            /** When the enableFilterSearch property value is set to true, the values in the DropDownList shows the items starting with or containing the key word/letter typed in the Search
             * textbox.
             * @Default {ej.FilterType.Contains}
             */
            filterType?: ej.FilterType|string;

            /** Used to create visualized header for dropdown items
             * @Default {null}
             */
            headerTemplate?: string;

            /** Defines the height of the DropDownList textbox.
             * @Default {null}
             */
            height?: string|number;

            /** It sets the given HTML attributes for the DropDownList control such as ID, name, disabled, etc.
             * @Default {null}
             */
            htmlAttributes?: any;

            /** Data can be fetched in the DropDownList control by using the DataSource, specifying the number of items.
             * @Default {5}
             */
            itemsCount?: number;

            /** Allows the user to set the particular country or region language for the DropDownList.
             * @Default {en-US}
             */
            locale?: string;

            /** Defines the maximum height of the suggestion box. This property restricts the maximum height of the popup when resize is enabled.
             * @Default {null}
             */
            maxPopupHeight?: string|number;

            /** Defines the minimum height of the suggestion box. This property restricts the minimum height of the popup when resize is enabled.
             * @Default {null}
             */
            minPopupHeight?: string|number;

            /** Defines the maximum width of the suggestion box. This property restricts the maximum width of the popup when resize is enabled.
             * @Default {null}
             */
            maxPopupWidth?: string|number;

            /** Defines the minimum height of the suggestion box. This property restricts the minimum height of the popup when resize is enabled.
             * @Default {0}
             */
            minPopupWidth?: string|number;

            /** With the help of this property, you can make a single or multi selection with the DropDownList and display the text in two modes, delimiter and visual mode. In delimiter mode, you
             * can separate the items by using the delimiter character such as comma (,) or semi-colon (;) or any other special character. In the visual mode, the items are showcased like boxes
             * with close icon in the textbox.
             * @Default {ej.MultiSelectMode.None}
             */
            multiSelectMode?: ej.MultiSelectMode|string;

            /** Defines the height of the suggestion popup box in the DropDownList control.
             * @Default {152px}
             */
            popupHeight?: string|number;

            /** Defines the width of the suggestion popup box in the DropDownList control.
             * @Default {auto}
             */
            popupWidth?: string|number;

            /** Specifies the query to retrieve the data from the DataSource.
             * @Default {null}
             */
            query?: any;

            /** Specifies that the DropDownList textbox values should be read-only.
             * @Default {false}
             */
            readOnly?: boolean;

            /** Specifies an item to be selected in the DropDownList.
             * @Default {null}
             */
            selectedIndex?: number;

            /** Specifies the selectedItems for the DropDownList.
             * @Default {[]}
             */
            selectedIndices?: any[];

            /** Selects multiple items in the DropDownList with the help of the checkbox control. To achieve this, enable the showCheckbox option to true.
             * @Default {false}
             */
            showCheckbox?: boolean;

            /** DropDownList control is displayed with the popup seen.
             * @Default {false}
             */
            showPopupOnLoad?: boolean;

            /** DropDownList textbox displayed with the rounded corner style.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** When the enableSorting property value is set to true, this property helps to sort the items either in ascending or descending order
             * @Default {ej.SortOrder.Ascending}
             */
            sortOrder?: ej.SortOrder|string;

            /** Specifies the targetID for the DropDownListâ€™s items.
             * @Default {null}
             */
            targetID?: string;

            /** By default, you can add any text or image to the DropDownList item. To customize the item layout or to create your own visualized elements, you can use this template support.
             * @Default {null}
             */
            template?: string;

            /** Defines the text value that is displayed in the DropDownList textbox.
             * @Default {null}
             */
            text?: string;

            /** Sets the jQuery validation error message in the DropDownList
             * @Default {null}
             */
            validationMessage?: any;

            /** Sets the jQuery validation rules in the Dropdownlist.
             * @Default {null}
             */
            validationRules?: any;

            /** Specifies the value (text content) for the DropDownList control.
             * @Default {null}
             */
            value?: string|number;

            /** Specifies a short hint that describes the expected value of the DropDownList control.
             * @Default {null}
             */
            watermarkText?: string;

            /** Defines the width of the DropDownList textbox.
             * @Default {null}
             */
            width?: string|number;

            /** The Virtual Scrolling feature is used to display a large amount of records in the DropDownList, that is, when scrolling, an AJAX request is sent to fetch some amount of data from
             * the server dynamically. To achieve this scenario with DropDownList, set the allowVirtualScrolling to true. You can set the itemsCount property that represents the number of items
             * to be fetched from the server on every AJAX request.
             * @Default {normal}
             */
            virtualScrollMode?: ej.VirtualScrollMode|string;

            /** Fires the action before the XHR request.
             */
            actionBegin?(e: ActionBeginEventArgs): void;

            /** Fires the action when the list of items is bound to the DropDownList by xhr post calling
             */
            actionComplete?(e: ActionCompleteEventArgs): void;

            /** Fires the action when the xhr post calling failed on remote data binding with the DropDownList control.
             */
            actionFailure?(e: ActionFailureEventArgs): void;

            /** Fires the action when the xhr post calling succeed on remote data binding with the DropDownList control
             */
            actionSuccess?(e: ActionSuccessEventArgs): void;

            /** Fires the action before the popup is ready to hide.
             */
            beforePopupHide?(e: BeforePopupHideEventArgs): void;

            /** Fires the action before the popup is ready to be displayed.
             */
            beforePopupShown?(e: BeforePopupShownEventArgs): void;

            /** Fires when the cascading happens between two DropDownList exactly after the value changes in the first dropdown and before filtering in the second Dropdown.
             */
            cascade?(e: CascadeEventArgs): void;

            /** Fires the action when the DropDownList controlâ€™s value is changed.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires the action when the list item checkbox value is changed.
             */
            checkChange?(e: CheckChangeEventArgs): void;

            /** Fires the action once the DropDownList is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires the action when the list items is bound to the DropDownList.
             */
            dataBound?(e: DataBoundEventArgs): void;

            /** Fires the action when the DropDownList is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires the action when the DropDownList is focused.
             */
            focusIn?(e: FocusInEventArgs): void;

            /** Fires the action when the DropDownList is about to lose focus.
             */
            focusOut?(e: FocusOutEventArgs): void;

            /** Fires the action, once the popup is closed
             */
            popupHide?(e: PopupHideEventArgs): void;

            /** Fires the action, when the popup is resized.
             */
            popupResize?(e: PopupResizeEventArgs): void;

            /** Fires the action, once the popup is opened.
             */
            popupShown?(e: PopupShownEventArgs): void;

            /** Fires the action, when resizing a popup starts.
             */
            popupResizeStart?(e: PopupResizeStartEventArgs): void;

            /** Fires the action, when the popup resizing is stopped.
             */
            popupResizeStop?(e: PopupResizeStopEventArgs): void;

            /** Fires the action before filtering the list items that starts in the DropDownList when the enableFilterSearch is enabled.
             */
            search?(e: SearchEventArgs): void;

            /** Fires the action, when the list of item is selected.
             */
            select?(e: SelectEventArgs): void;
        }

        export interface ActionBeginEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ActionCompleteEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns number of times trying to fetch the data
             */
            count?: number;

            /** returns the DropDownList model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** Returns the query for data retrieval from the Database
             */
            request?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the number of items fetched from remote data
             */
            result?: any[];

            /** Returns the requested data
             */
            xhr?: any;
        }

        export interface ActionFailureEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the error message
             */
            error?: any;

            /** returns the DropDownList model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ActionSuccessEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns number of times trying to fetch the data
             */
            count?: number;

            /** returns the DropDownList model
             */
            model?: any;

            /** Returns the query for data retrieval
             */
            query?: any;

            /** Returns the query for data retrieval from the Database
             */
            request?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the number of items fetched from remote data
             */
            result?: any[];

            /** Returns the requested data
             */
            xhr?: any;
        }

        export interface BeforePopupHideEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the selected text
             */
            text?: string;

            /** returns the selected value
             */
            value?: string;
        }

        export interface BeforePopupShownEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the selected text
             */
            text?: string;

            /** returns the selected value
             */
            value?: string;
        }

        export interface CascadeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the cascading dropdown model.
             */
            cascadeModel?: any;

            /** returns the current selected value in first dropdown.
             */
            cascadeValue?: string;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the default filter action for second dropdown data should happen or not.
             */
            requiresDefaultFilter?: boolean;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the selected item with checkbox checked or not.
             */
            isChecked?: boolean;

            /** Returns the selected item ID.
             */
            itemId?: string;

            /** returns the DropDownList model
             */
            model?: any;

            /** Returns the selected item text.
             */
            selectedText?: string;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the selected text.
             */
            text?: string;

            /** Returns the selected value.
             */
            value?: string;
        }

        export interface CheckChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the selected item with checkbox checked or not.
             */
            isChecked?: boolean;

            /** Returns the selected item ID.
             */
            itemId?: string;

            /** returns the DropDownList model
             */
            model?: any;

            /** Returns the selected item text.
             */
            selectedText?: string;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the selected text.
             */
            text?: string;

            /** Returns the selected value.
             */
            value?: string;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DataBoundEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the data that is bound to DropDownList
             */
            data?: any;
        }

        export interface DestroyEventArgs {

            /** its value is set as true,if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface FocusInEventArgs {

            /** its value is set as true,if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface FocusOutEventArgs {

            /** its value is set as true,if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface PopupHideEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the selected text
             */
            text?: string;

            /** returns the selected value
             */
            value?: string;
        }

        export interface PopupResizeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the data from the resizable plugin.
             */
            event?: any;
        }

        export interface PopupShownEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the selected text
             */
            text?: string;

            /** returns the selected value
             */
            value?: string;
        }

        export interface PopupResizeStartEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the data from the resizable plugin.
             */
            event?: any;
        }

        export interface PopupResizeStopEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the DropDownList model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the data from the resizable plugin.
             */
            event?: any;
        }

        export interface SearchEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the data bound to the DropDownList.
             */
            items?: any;

            /** returns the DropDownList model
             */
            model?: any;

            /** Returns the selected item text.
             */
            selectedText?: string;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the search string typed in search box.
             */
            searchString?: string;
        }

        export interface SelectEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the selected item with checkbox checked or not.
             */
            isChecked?: boolean;

            /** Returns the selected item ID.
             */
            itemId?: string;

            /** returns the DropDownList model
             */
            model?: any;

            /** Returns the selected item text.
             */
            selectedText?: string;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the selected text.
             */
            text?: string;

            /** Returns the selected value.
             */
            value?: string;
        }

        export interface Fields {

            /** Used to group the items.
             */
            groupBy?: string;

            /** Defines the HTML attributes such as ID, class, and styles for the item.
             */
            htmlAttributes?: any;

            /** Defines the ID for the tag.
             */
            id?: string;

            /** Defines the image attributes such as height, width, styles, and so on.
             */
            imageAttributes?: string;

            /** Defines the imageURL for the image location.
             */
            imageUrl?: string;

            /** Defines the tag value to be selected initially.
             */
            selected?: boolean;

            /** Defines the sprite CSS for the image tag.
             */
            spriteCssClass?: string;

            /** Defines the table name for tag value or display text while rendering remote data.
             */
            tableName?: string;

            /** Defines the text content for the tag.
             */
            text?: string;

            /** Defines the tag value.
             */
            value?: string;
        }
    }
    enum FilterType {
        //filter the data wherever contains search key
        Contains,
        //filter the data based on search key present at start position
        StartsWith,
    }
    enum MultiSelectMode {
        //can select only single item in DropDownList
        None,
        //can select multiple items and it's separated by delimiterChar
        Delimiter,
        //can select multiple items and it's show's like visual box in textbox
        VisualMode,
    }
    enum VirtualScrollMode {
        //The data is loaded only to the corresponding page (display items). When scrolling some other position, it enables the load on demand with the DropDownList.
        Normal,
        //The data items are loaded from the remote when scroll handle reaches the end of the scrollbar like infinity scrolling.
        Continuous,
    }

    class DropDownTree extends ej.Widget {
        static fn: DropDownTree;
        constructor(element: JQuery | Element, options?: DropDownTree.Model);
        static Locale: any;
        model: DropDownTree.Model;
        defaults: DropDownTree.Model;

        /** Checks all the nodes in the DropDownTree.
         * @returns {void}
         */
        checkAll(): void;

        /** Checks a node in the DropDownTree.
         * @param {string|any|any[]}  ID of the DropDownTree node/object of the DropDownTree node/collection of the ID/object of the DropDownTree nodes.
         * @returns {void}
         */
        checkNode(element: string|any|any[]): void;

        /** Clears the text in the DropDownTree.
         * @returns {void}
         */
        clearText(): void;

        /** Destroys the DropDownTree control.
         * @returns {void}
         */
        destroy(): void;

        /** Returns the selected value.
         * @returns {void}
         */
        getValue(): void;

        /** Hides the popup in the DropDownTree.
         * @returns {void}
         */
        hidePopup(): void;

        /** Moves the DropDownTree node within the same DropDownTree. The new position of the given DropDownTree node will be based on destination node and index position.
         * @param {string|any} ID of the DropDownTree node/object of the DropDownTree node.
         * @param {string|any} ID of the DropDownTree node/object of the DropDownTree node.
         * @param {number} New index position of the given source node.
         * @returns {void}
         */
        moveNode(sourceNode: string|any, destinationNode: string|any, index: number): void;

        /** Removes all the nodes in the DropDownTree.
         * @returns {void}
         */
        removeAll(): void;

        /** Removes a node in the DropDownTree.
         * @param {string|any|any[]}  ID of the DropDownTree node/object of the DropDownTree node/collectionof the ID/object of the DropDownTree nodes.
         * @returns {void}
         */
        removeNode(element: string|any|any[]): void;

        /** Selects all the DropDownTree nodes when allowMultiSelection field is enabled in the treeViewSettings property.
         * @returns {void}
         */
        selectAll(): void;

        /** Selects a node in the DropDownTree control. To select the collection of nodes in the DropDownTree control, enable allowMultiSelection field of the treeViewSettings property.
         * @param {string|any|any[]}  ID of the DropDownTree node/object of the DropDownTree node/ collection of I the D/object of the DropDownTree nodes.
         * @returns {void}
         */
        selectNode(element: string|any|any[]): void;

        /** Shows the DropDownTree control with the popup.
         * @returns {void}
         */
        showPopup(): void;

        /** Unchecks all the nodes in the DropDownTree.
         * @returns {void}
         */
        unCheckAll(): void;

        /** Unchecks a node in the DropDownTree.
         * @param {string|any|any[]} ID of the DropDownTree node/object of the DropDownTree node/collection of the ID/object of the DropDownTree nodes.
         * @returns {void}
         */
        unCheckNode(element: string|any|any[]): void;

        /** Unselects all the DropDownTree nodes when allowMultiSelection field of the treeViewSettings property is enabled.
         * @returns {void}
         */
        unselectAll(): void;

        /** Unselects a node in the DropDownTree control. To unselect the collection of nodes in the DropDownTree control, enable allowMultiSelection field of the treeViewSettings property.
         * @param {string|any|any[]}  ID of the DropDownTree node/object of the DropDownTree node/ collection of the ID/object of the DropDownTree nodes.
         * @returns {void}
         */
        unselectNode(element: string|any|any[]): void;
    }
    export namespace DropDownTree {

        export interface Model {

            /** Uses the keyboard for any action, including opening and closing the drop-down tree; navigating, expanding, and collapsing nodes of the dropdown tree; and more.
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** Sets the root CSS class for DropDownTree that allows customization of appearance.
             * @Default {``}
             */
            cssClass?: string;

            /** Sets the separator when the multiSelectMode with delimiter option or checkbox is enabled. When you enter the delimiter value, the text after the delimiter is considered as a
             * separate word or query. The delimiter string is a single character and must be a symbol. Mostly, the delimiter symbol is used as comma (,), semi-colon (;), or any other special
             * character.
             * @Default {,}
             */
            delimiter?: string;

            /** Indicates whether the DropDownTree control responds to user interaction or not. By default, the control is in the enabled mode and can be disabled by setting this to false.
             * @Default {true}
             */
            enabled?: boolean;

            /** The enabled animation property uses the easeOutQuad animation to SlideDown and SlideUp the popup wrapper in 200 and 100 milliseconds, respectively.
             * @Default {false}
             */
            enableAnimation?: boolean;

            /** Gets or sets a value that indicates whether to continue the DropDownTree model state in the page using applicable medium, i.e., HTML5 localStorage or cookies.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Sets the DropDownTree textbox direction from right to left alignment.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Creates footer with text or HTML elements for the dropdown items.
             * @Default {null}
             */
            footerTemplate?: string;

            /** Serves as a patch of the entries comprising the path (that is set in the entry area) of the selected node.
             * @Default {'/'}
             */
            fullPathDelimiter?: string;

            /** Creates header with text or HTML elements for the dropdown items.
             * @Default {null}
             */
            headerTemplate?: string;

            /** Defines the height of the DropDownTree textbox.
             */
            height?: string|number;

            /** Allows you to set a particular country or regional language for the DropDownTree.
             * @Default {en-US}
             */
            locale?: string;

            /** Customizes the height and width of the popup wrapper.
             * @Default {{height: '152px',width: 'auto',showPopupOnLoad: false}}
             */
            popupSettings?: PopupSettings;

            /** Specifies that the DropDownTree textbox values should be read-only.
             * @Default {false}
             */
            readOnly?: boolean;

            /** The DropDownTree's textbox is displayed with rounded corner style.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies the targetID for the DropDownTree's items.
             * @Default {null}
             */
            targetID?: string;

            /** Specifies the delimiter between nodes (indicating their hierarchy).
             * @Default {ej.DropDownTree.TextMode.none}
             */
            textMode?: ej.Textmode|string;

            /** Sets the jQuery validation error message in the DropDownTree.
             * @Default {null}
             */
            validationMessage?: any;

            /** Sets the jQuery validation rules in the DropDownTree.
             * @Default {null}
             */
            validationRules?: any;

            /** Specifies the value (text content) for the DropDownTree control. For the single selection mode, the selected item's value will be returned in its data type, and for
             * MultiSelectMode, returns the selected items values separated by delimiter in string type.
             * @Default {null}
             */
            value?: string;

            /** Specifies a short hint that describes the expected value of the DropDownTree control.
             * @Default {null}
             */
            watermarkText?: string;

            /** Defines the width of the DropDownTree textbox.
             * @Default {100%}
             */
            width?: string|number;

            /** Defines the popup settings of the DropDownTree widget. You can use any property which are in treeview using this property.
             * @Default {{}}
             */
            treeViewSettings?: any;

            /** Fires the action when the DropDownTree is about to lose focus.
             */
            blur?(e: BlurEventArgs): void;

            /** Fires the action when the DropDownTree control's value is changed.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires the action when the list item checkbox value is changed.
             */
            checkChange?(e: CheckChangeEventArgs): void;

            /** Fires the action once the popup is closed.
             */
            close?(e: CloseEventArgs): void;

            /** Fires the action once the DropDownTree is created.
             */
            Create?(e: CreateEventArgs): void;

            /** Fires the action when DropDownTree is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** When the enableFilterSearch is enabled, the filtering action is fired as soon as you start typing in the DropDownTree.
             */
            filtering?(e: FilteringEventArgs): void;

            /** Fires the action when the DropDownTree is focused.
             */
            focus?(e: FocusEventArgs): void;

            /** Fires the action once the popup is opened.
             */
            open?(e: OpenEventArgs): void;

            /** Fires the action when the list of nodes in the DropDownTree is selected.
             */
            select?(e: SelectEventArgs): void;
        }

        export interface BlurEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;
        }

        export interface ChangeEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;

            /** Selected item's text.
             */
            selectedText?: string;

            /** Selected item's text.
             */
            text?: string;

            /** Selected item's value.
             */
            value?: string;

            /** Selected item's ID.
             */
            itemId?: string;

            /** Returns the selected item with checkbox checked or not.
             */
            isChecked?: boolean;
        }

        export interface CheckChangeEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;

            /** Selected item's text.
             */
            text?: string;

            /** Selected item's value.
             */
            value?: string;

            /** Selected item's ID.
             */
            itemId?: string;

            /** Returns the selected item with checkbox checked or not.
             */
            isChecked?: boolean;
        }

        export interface CloseEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;

            /** Selected item's text.
             */
            text?: string;

            /** Selected item's value.
             */
            value?: string;
        }

        export interface CreateEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;
        }

        export interface DestroyEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;
        }

        export interface FilteringEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;

            /** Selected item's text.
             */
            selectedText?: string;

            /** Returns the search string typed in the search box.
             */
            searchString?: string;

            /** Returns the data items of theDropDownTreeView.
             */
            items?: any;
        }

        export interface FocusEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;
        }

        export interface OpenEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;

            /** Selected item's text.
             */
            text?: string;

            /** Selected item's value.
             */
            value?: string;
        }

        export interface SelectEventArgs {

            /** If the event has to be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Event name
             */
            type?: string;

            /** DropDownTreeView model.
             */
            model?: any;

            /** Selected item's text.
             */
            text?: string;

            /** Selected item's value.
             */
            value?: string;

            /** Selected item's ID.
             */
            itemId?: string;

            /** Returns the selected item with checkbox checked or not.
             */
            isChecked?: boolean;
        }

        export interface PopupSettings {

            /** Defines the height of the popup wrapper in the DropDownTree control.
             */
            height?: string|number;

            /** Defines the width of the popup wrapper in the DropDownTree control.
             */
            width?: string|number;

            /** The DropDownTree control is displayed with the popup.
             */
            showPopupOnLoad?: boolean;
        }
    }
    enum Textmode {
        //When TextMode property is set to none, only selected/checked node's text is presented.
        None,
        //When FullPath option is selected, the full path of the selected node is shown in the control.
        FullPath,
    }

    class Tooltip extends ej.Widget {
        static fn: Tooltip;
        constructor(element: JQuery | Element, options?: Tooltip.Model);
        static Locale: any;
        model: Tooltip.Model;
        defaults: Tooltip.Model;

        /** Destroys the Tooltip control.
         * @returns {void}
         */
        destroy(): void;

        /** Disables the Tooltip control.
         * @returns {void}
         */
        disable(): void;

        /** Enables the Tooltip control.
         * @returns {void}
         */
        enable(): void;

        /** Hide the Tooltip popup.
         * @param {string}  optional Determines the type of effect that takes place when hiding the tooltip.
         * @param {() => void}  optional custom effect takes place when hiding the tooltip.
         * @returns {void}
         */
        hide(effect?: string, func?: () => void): void;

        /** Shows the Tooltip popup for the given target element with the specified effect.
         * @param {string} optional Determines the type of effect that takes place when showing the tooltip.
         * @param {() => void} optional custom effect takes place when showing the tooltip.
         * @param {JQuery} optional Tooltip will be shown for the given element
         * @returns {void}
         */
        show(effect?: string, func?: () => void, target?: JQuery): void;
    }
    export namespace Tooltip {

        export interface Model {

            /** Tooltip control can be accessed through the keyboard shortcut keys.
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** Specifies the animation behavior in  Tooltip. It contains the following sub properties.
             */
            animation?: Animation;

            /** Sets the position related to target element, window, mouse or (x,y) co-ordinates.
             * @Default {ej.Tooltip.Associate.Target}
             */
            associate?: ej.Tooltip.Associate|string;

            /** Specified the delay to hide Tooltip when closeMode is auto.
             * @Default {4000}
             */
            autoCloseTimeout?: number;

            /** Specifies the closing behavior of Tooltip popup.
             * @Default {ej.Tooltip.CloseMode.None}
             */
            closeMode?: ej.Tooltip.CloseMode|string;

            /** Sets the Tooltip in alternate position when collision occurs.
             * @Default {ej.Tooltip.Collision.FlipFit}
             */
            collision?: ej.Tooltip.Collision|string;

            /** Specified the selector for the container element.
             * @Default {body}
             */
            containment?: string;

            /** Specifies the text for Tooltip.
             * @Default {null}
             */
            content?: string;

            /** Sets the root CSS class for Tooltip for the customization.
             * @Default {null}
             */
            cssClass?: string;

            /** Enables or disables the Tooltip.
             * @Default {true}
             */
            enabled?: boolean;

            /** Sets the Tooltip direction from right to left.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Defines the height of the Tooltip popup.
             * @Default {auto}
             */
            height?: string|number;

            /** Enables the arrow in Tooltip.
             * @Default {true}
             */
            isBalloon?: boolean;

            /** defines various attributes of the Tooltip position
             */
            position?: Position;

            /** Enables or disables rounded corner.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Enables or disables shadow effect.
             * @Default {false}
             */
            showShadow?: boolean;

            /** Specified a selector for elements, within the container.
             * @Default {null}
             */
            target?: string;

            /** defines Tooltip size and gap between tooltip against the target element.
             */
            tip?: Tip;

            /** The title text to be displayed in the Tooltip header.
             * @Default {null}
             */
            title?: string;

            /** Specified the event action to show case the Tooltip.
             * @Default {ej.Tooltip.Trigger.Hover}
             */
            trigger?: ej.Tooltip.Trigger|string;

            /** Defines the width of the Tooltip popup.
             * @Default {auto}
             */
            width?: string|number;

            /** This event is triggered before the Tooltip widget get closed.
             */
            beforeClose?(e: BeforeCloseEventArgs): void;

            /** This event is triggered before the Tooltip widget gets open.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** Fires on clicking to the target element.
             */
            click?(e: ClickEventArgs): void;

            /** This event is triggered after the Tooltip widget is closed.
             */
            close?(e: CloseEventArgs): void;

            /** This event is triggered after the Tooltip is created successfully.
             */
            create?(e: CreateEventArgs): void;

            /** This event is triggered after the Tooltip widget is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** This event is triggered while hovering the target element, when tooltip positioning relates to target element.
             */
            hover?(e: HoverEventArgs): void;

            /** This event is triggered after the Tooltip is opened.
             */
            open?(e: OpenEventArgs): void;

            /** This event is triggered while hover the target element, when the tooltip positioning is relates to the mouse.
             */
            tracking?(e: TrackingEventArgs): void;
        }

        export interface BeforeCloseEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the Tooltip's content
             */
            content?: string;
        }

        export interface BeforeOpenEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the Tooltip's content
             */
            content?: string;
        }

        export interface ClickEventArgs {

            /** its value is set as true,if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;
        }

        export interface CloseEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the Tooltip's content
             */
            content?: string;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** its value is set as true,if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface HoverEventArgs {

            /** its value is set as true,if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;
        }

        export interface OpenEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the Tooltip's content
             */
            content?: string;
        }

        export interface TrackingEventArgs {

            /** its value is set as true,if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Tooltip model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;
        }

        export interface Animation {

            /** Determines the type of effect.
             * @Default {ej.Tooltip.Effect.None}
             */
            effect?: ej.Tooltip.effect|string;

            /** Sets the animation speed in milliseconds.
             * @Default {4000}
             */
            speed?: number;
        }

        export interface PositionTarget {

            /** Sets the Tooltip position against target based on horizontal(x) value.
             * @Default {center}
             */
            horizontal?: string|number;

            /** Sets the Tooltip position against target based on vertical(y) value.
             * @Default {top}
             */
            vertical?: string|number;
        }

        export interface PositionStem {

            /** Sets the arrow position again popup based on horizontal(x) value
             * @Default {center}
             */
            horizontal?: string;

            /** Sets the arrow position again popup based on vertical(y) value
             * @Default {bottom}
             */
            vertical?: string;
        }

        export interface Position {

            /** Sets the Tooltip position against target.
             */
            target?: PositionTarget;

            /** Sets the arrow position again popup.
             */
            stem?: PositionStem;
        }

        export interface TipSize {

            /** Sets the Tooltip width.
             * @Default {20}
             */
            width?: number;

            /** Sets the Tooltip height.
             * @Default {10}
             */
            height?: number;
        }

        export interface TipAdjust {

            /** Sets horizontal gap between Tooltip and target element.
             * @Default {0}
             */
            xValue?: number;

            /** Sets vertical gap between Tooltip and target element.
             * @Default {0}
             */
            yValue?: number;
        }

        export interface Tip {

            /** Sets the Tooltip size.
             */
            size?: TipSize;

            /** Sets gap between tooltip against the target element.
             */
            adjust?: TipAdjust;
        }

        enum effect {

            ///No animation takes place when showing/hiding the Tooltip
            None,

            ///Sliding effect takes place when showing/hiding the Tooltip
            Slide,

            ///Fade the Tooltip in and out of visibility.
            Fade
        }


        enum Associate {

            ///Sets the position related to target element.
            Target,

            ///Sets the position related to mouse.
            MouseFollow,

            ///Sets the position related to mouse, first entry to the target element.
            MouseEnter,

            ///Sets the position related to (x,y) co-ordinates.
            Axis,

            ///Sets the position related to browser window.
            Window
        }


        enum CloseMode {

            ///Enables close button in Tooltip.
            Sticky,

            ///Sets the delay for Tooltip close
            Auto,

            ///The Tooltip will be display normally.
            None
        }


        enum Collision {

            ///Flips the Tooltip to the opposite side of the target, if collision is occurs.
            Flip,

            ///Shift the Tooltip popup away from the edge of the window(collision side) that means adjacent position.
            Fit,

            ///Ensure as much of the element is visible as possible to showcase.
            FlipFit,

            ///No collision detection is take place
            None
        }


        enum Trigger {

            ///The Tooltip to be shown when the target element is clicked.
            Click,

            ///Enables the Tooltip when hover on the target element.
            Hover,

            ///Enables the Tooltip when focus is set to target element.
            Focus
        }

    }

    class Editor extends ej.Widget {
        static fn: Editor;
        constructor(element: JQuery | Element, options?: Editor.Model);
        static Locale: any;
        model: Editor.Model;
        defaults: Editor.Model;

        /** destroy the editor widgets all events are unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** To disable the corresponding Editors
         * @returns {void}
         */
        disable(): void;

        /** To enable the corresponding Editors
         * @returns {void}
         */
        enable(): void;

        /** To get value from corresponding Editors
         * @returns {number}
         */
        getValue(): number;
    }

    class NumericTextbox extends Editor {
    }

    class CurrencyTextbox extends Editor {
    }

    class PercentageTextbox extends Editor {
    }
    export namespace Editor {

        export interface Model {

            /** Specifies the currency symbol of currency textbox, used when the user wants to overwrite the currency symbol commonly instead of the current culture symbol.
             * @Default {Based on the culture}
             */
            currencySymbol?: string;

            /** Sets the root CSS class for Editors which allow us to customize the appearance.
             */
            cssClass?: string;

            /** Specifies the number of digits that is allowed after the decimal point. When the decimalPlaces is set to â€œ-1â€, it allows the decimals without any limit in the Textboxes.
             * @Default {0}
             */
            decimalPlaces?: number;

            /** Specifies the editor control state.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specify the enablePersistence to editor to save current editor control value to browser cookies for state maintenance.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Specifies the Right to Left Direction to editor.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** When enableStrictMode true it allows the value outside of the range also but it highlights the textbox with error class,otherwise it internally changed to the correct value.
             * @Default {false}
             */
            enableStrictMode?: boolean;

            /** Specifies the number of digits in each group to the editor.
             * @Default {Based on the culture.}
             */
            groupSize?: string;

            /** It provides the options to get the customized character to separate the digits. If not set, the separator defined by the current culture.
             * @Default {Based on the culture}
             */
            groupSeparator?: string;

            /** Specifies the height of the editor.
             * @Default {30}
             */
            height?: string;

            /** It allows to define the characteristics of the Editors control. It will helps to extend the capability of an HTML element.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** The Editor value increment or decrement based an incrementStep value.
             * @Default {1}
             */
            incrementStep?: number;

            /** Defines the localization culture for editor.
             * @Default {en-US}
             */
            locale?: string;

            /** Specifies the maximum value of the editor.
             * @Default {Number.MAX_VALUE}
             */
            maxValue?: number;

            /** Specifies the minimum value of the editor.
             * @Default {-(Number.MAX_VALUE) and 0 for Currency Textbox.}
             */
            minValue?: number;

            /** Specifies the name of the editor.
             * @Default {Sets id as name if it is null.}
             */
            name?: string;

            /** Specifies the pattern for formatting positive values in editor.We have maintained some standard to define the negative pattern. you have to specify 'n' to place the digit in your
             * pattern.ejTextbox allows you to define a currency or percent symbol where you want to place it.
             * @Default {Based on the culture}
             */
            negativePattern?: string;

            /** Specifies the pattern for formatting positive values in editor.We have maintained some standard to define the positive pattern. you have to specify 'n' to place the digit in your
             * pattern.ejTextbox allows you to define a currency or percent symbol where you want to place it.
             * @Default {Based on the culture}
             */
            positivePattern?: string;

            /** Toggles the readonly state of the editor. When the Editor is readonly it doesn't allow user interactions.
             * @Default {false}
             */
            readOnly?: boolean;

            /** Specifies to Change the sharped edges into rounded corner for the Editor.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies whether the up and down spin buttons should be displayed in editor.
             * @Default {true}
             */
            showSpinButton?: boolean;

            /** Enables decimal separator position validation on type .
             * @Default {false}
             */
            validateOnType?: boolean;

            /** Set the jQuery validation error message in editor.
             * @Default {null}
             */
            validationMessage?: any;

            /** Set the jQuery validation rules to the editor.
             * @Default {null}
             */
            validationRules?: any;

            /** Specifies the value of the editor.
             * @Default {null}
             */
            value?: number|string;

            /** Specifies the watermark text to editor.
             * @Default {Based on the culture.}
             */
            watermarkText?: string;

            /** Specifies the width of the editor.
             * @Default {143}
             */
            width?: string;

            /** Fires after Editor control value is changed.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires after Editor control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the Editor is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires after Editor control is focused.
             */
            focusIn?(e: FocusInEventArgs): void;

            /** Fires after Editor control is loss the focus.
             */
            focusOut?(e: FocusOutEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the corresponding editor model.
             */
            model?: ej.Editor.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the corresponding editor control value.
             */
            value?: number;

            /** returns true when the value changed by user interaction otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the editor model
             */
            model?: ej.Editor.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the editor model
             */
            model?: ej.Editor.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface FocusInEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the corresponding editor model.
             */
            model?: ej.Editor.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the corresponding editor control value.
             */
            value?: number;
        }

        export interface FocusOutEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the corresponding editor model.
             */
            model?: ej.Editor.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the corresponding editor control value.
             */
            value?: number;
        }
    }

    class ListView extends ej.Widget {
        static fn: ListView;
        constructor(element: JQuery | Element, options?: ListView.Model);
        static Locale: any;
        model: ListView.Model;
        defaults: ListView.Model;

        /** To add item in the given index. If you have enabled grouping in ListView then you need to pass the corresponding group list title to add item in it. Depending on the data bound to
         * ListView, we need to pass either an HTML element or JSON objects in this method.
         * @param {string|any} To pass the list item as element/ JSON object
         * @param {number} Specifies the index where item to be added
         * @param {string} optionalThis is an optional parameter. You must pass the group list title here if grouping is enabled in the ListView
         * @returns {void}
         */
        addItem(item: string|any, index: number, groupid: string): void;

        /** To check all the items.
         * @returns {void}
         */
        checkAllItem(): void;

        /** To check item in the given index.
         * @param {number} Specifies the index of the item to be checked
         * @returns {void}
         */
        checkItem(index: number): void;

        /** To clear all the list item in the control before updating with new datasource.
         * @returns {void}
         */
        clear(): void;

        /** To make the item in the given index to be default state.
         * @param {number} Specifies the index to make the item to be in default state.
         * @returns {void}
         */
        deActive(index: number): void;

        /** To disable item in the given index.
         * @param {number} Specifies the index value to be disabled.
         * @returns {void}
         */
        disableItem(index: number): void;

        /** To enable item in the given index.
         * @param {number} Specifies the index value to be enabled.
         * @returns {void}
         */
        enableItem(index: number): void;

        /** To get the active item.
         * @returns {HTMLElement}
         */
        getActiveItem(): HTMLElement;

        /** To get the text of the active item.
         * @returns {string}
         */
        getActiveItemText(): string;

        /** To get all the checked items.
         * @returns {any[]}
         */
        getCheckedItems(): any[];

        /** To get the text of all the checked items.
         * @returns {any[]}
         */
        getCheckedItemsText(): any[];

        /** To get the total item count.
         * @returns {number}
         */
        getItemsCount(): number;

        /** To get the text of the item in the given index.
         * @param {string|number} Specifies the index value to get the text value.
         * @returns {string}
         */
        getItemText(index: string|number): string;

        /** To check whether the item in the given index has child item.
         * @param {number} Specifies the index value to check the item has child or not.
         * @returns {boolean}
         */
        hasChild(index: number): boolean;

        /** To hide the list.
         * @returns {void}
         */
        hide(): void;

        /** To hide item in the given index.
         * @param {number} Specifies the index value to hide the item.
         * @returns {void}
         */
        hideItem(index: number): void;

        /** To check whether item in the given index is checked.
         * @returns {boolean}
         */
        isChecked(): boolean;

        /** To load the AJAX content while selecting the item.
         * @param {string} Specifies the item to load the AJAX content.
         * @returns {void}
         */
        loadAjaxContent(item: string): void;

        /** To remove the check mark either for specific item in the given index or for all items.
         * @param {number} Specifies the index value to remove the checkbox.
         * @returns {void}
         */
        removeCheckMark(index: number): void;

        /** To remove item in the given index.
         * @param {number} Specifies the index value to remove the item.
         * @returns {void}
         */
        removeItem(index: number): void;

        /** To select item in the given index.
         * @param {number} Specifies the index value to select the item.
         * @returns {void}
         */
        selectItem(index: number): void;

        /** To make the item in the given index to be active state.
         * @param {number} Specifies the index value to make the item in active state.
         * @returns {void}
         */
        setActive(index: number): void;

        /** To show the list.
         * @returns {void}
         */
        show(): void;

        /** To show item in the given index.
         * @param {number} Specifies the index value to show the hidden item.
         * @returns {void}
         */
        showItem(index: number): void;

        /** To uncheck all the items.
         * @returns {void}
         */
        unCheckAllItem(): void;

        /** To uncheck item in the given index.
         * @param {number} Specifies the index value to uncheck the item.
         * @returns {void}
         */
        unCheckItem(index: number): void;
    }
    export namespace ListView {

        export interface Model {

            /** Specifies the ajaxSettings option to load the items to the ListView control.
             * @Default {null}
             */
            ajaxSettings?: AjaxSettings;

            /** Set the index values to be selected on initial loading. This works only when enableCheckMark is set true.
             * @Default {[]}
             */
            checkedIndices?: any[];

            /** Sets the root class for ListView theme. This cssClass API helps to use custom skinning option for ListView control. By defining the root class using this API, we need to include
             * this root class in CSS.
             */
            cssClass?: string;

            /** Contains the list of data for generating the ListView items.
             * @Default {[]}
             */
            dataSource?: any[];

            /** Specifies whether to load AJAX content while selecting item.
             * @Default {false}
             */
            enableAjax?: boolean;

            /** Specifies whether to enable caching the content.
             * @Default {false}
             */
            enableCache?: boolean;

            /** Specifies whether to enable check mark for the item.
             * @Default {false}
             */
            enableCheckMark?: boolean;

            /** Specifies whether to enable the filtering feature to filter the item.
             * @Default {false}
             */
            enableFiltering?: boolean;

            /** Specifies whether to group the list item.
             * @Default {false}
             */
            enableGroupList?: boolean;

            /** Specifies to maintain the current model value to browser cookies for state maintenance. While refresh the page, the model value will get apply to the control from browser cookies.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Specifies the field settings to map the datasource.
             */
            fieldSettings?: FieldSettings;

            /** Contains the array of items to be added in ListView.
             * @Default {[]}
             */
            items?: any[];

            /** Specifies the text of the back button in the header.
             * @Default {null}
             */
            headerBackButtonText?: string;

            /** Specifies the title of the header.
             * @Default {Title}
             */
            headerTitle?: string;

            /** Specifies the height.
             * @Default {null}
             */
            height?: string|number;

            /** Set the localization culture for ListView Widget.
             */
            locale?: string;

            /** Specifies whether to retain the selection of the item.
             * @Default {false}
             */
            persistSelection?: boolean;

            /** Specifies whether to prevent the selection of the item.
             * @Default {false}
             */
            preventSelection?: boolean;

            /** Specifies the query to execute with the datasource.
             * @Default {null}
             */
            query?: any;

            /** Specifies whether need to render the control with the template contents.
             * @Default {false}
             */
            renderTemplate?: boolean;

            /** Specifies the index of item which need to be in selected state initially while loading.
             * @Default {0}
             */
            selectedItemIndex?: number;

            /** Specifies whether to show the header.
             * @Default {true}
             */
            showHeader?: boolean;

            /** Specifies whether to show the back button header.
             * @Default {false}
             */
            showHeaderBackButton?: boolean;

            /** Specifies ID of the element contains template contents.
             * @Default {null}
             */
            templateId?: string;

            /** Specifies the width.
             * @Default {null}
             */
            width?: string|number;

            /** Specifies the number of items to be fetched on each scroll. Note: This property works only with Virtual scrolling.
             * @Default {5}
             */
            itemRequestCount?: number;

            /** Specifies the maximum number of items to be fetched. Note: This will work only with Virtual scrolling
             * @Default {5}
             */
            totalItemsCount?: number;

            /** Loads the list data on demand via scrolling behavior to improve the applicationâ€™s performance. There are two ways to load data which can be defined using virtualScrollMode
             * property.
             * @Default {false}
             */
            allowVirtualScrolling?: boolean;

            /** Specifies the virtual scroll mode to load the list data on demand via scrolling behavior. There are two types of mode.
             * @Default {ej.VirtualScrollMode.Normal}
             */
            virtualScrollMode?: ej.VirtualScrollMode|string;

            /** Event triggers before the AJAX request happens.
             */
            ajaxBeforeLoad?(e: AjaxBeforeLoadEventArgs): void;

            /** Event triggers after the AJAX content loaded completely.
             */
            ajaxComplete?(e: AjaxCompleteEventArgs): void;

            /** Event triggers when the AJAX request failed.
             */
            ajaxError?(e: AjaxErrorEventArgs): void;

            /** Event triggers after the AJAX content loaded successfully.
             */
            ajaxSuccess?(e: AjaxSuccessEventArgs): void;

            /** Event triggers before the items loaded.
             */
            load?(e: LoadEventArgs): void;

            /** Event triggers after the items loaded.
             */
            loadComplete?(e: LoadCompleteEventArgs): void;

            /** Event triggers when mouse down happens on the item.
             */
            mouseDown?(e: MouseDownEventArgs): void;

            /** Event triggers when mouse up happens on the item.
             */
            mouseUp?(e: MouseUpEventArgs): void;
        }

        export interface AjaxBeforeLoadEventArgs {

            /** returns true if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the model value of the control.
             */
            model?: ej.ListView.Model;

            /** returns the AJAX settings.
             */
            ajaxData?: any;
        }

        export interface AjaxCompleteEventArgs {

            /** returns true if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the model value of the control.
             */
            model?: ej.ListView.Model;
        }

        export interface AjaxErrorEventArgs {

            /** returns true if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the model value of the control.
             */
            model?: ej.ListView.Model;

            /** returns the error thrown in the AJAX post.
             */
            errorThrown?: any;

            /** returns the status.
             */
            textStatus?: any;

            /** returns the current list item.
             */
            item?: any;

            /** returns the current item text.
             */
            text?: string;

            /** returns the current item index.
             */
            index?: number;
        }

        export interface AjaxSuccessEventArgs {

            /** returns true if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the model value of the control.
             */
            model?: ej.ListView.Model;

            /** returns the AJAX current content.
             */
            content?: string;

            /** returns the current list item.
             */
            item?: any;

            /** returns the current item text.
             */
            text?: string;

            /** returns the current item index.
             */
            index?: number;

            /** returns the current URL of the AJAX post.
             */
            URL?: string;
        }

        export interface LoadEventArgs {

            /** returns true if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the model value of the control.
             */
            model?: ej.ListView.Model;
        }

        export interface LoadCompleteEventArgs {

            /** returns true if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the model value of the control.
             */
            model?: ej.ListView.Model;
        }

        export interface MouseDownEventArgs {

            /** returns true if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the model value of the control.
             */
            model?: ej.ListView.Model;

            /** If the child element exist return true; otherwise, false.
             */
            hasChild?: boolean;

            /** returns the current list item.
             */
            item?: string;

            /** returns the current text of item.
             */
            text?: string;

            /** returns the current Index of the item.
             */
            index?: number;

            /** If checked return true; otherwise, false.
             */
            isChecked?: boolean;

            /** returns the list of checked items.
             */
            checkedItems?: number;

            /** returns the current checked item text.
             */
            checkedItemsText?: string;
        }

        export interface MouseUpEventArgs {

            /** returns true if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the model value of the control.
             */
            model?: ej.ListView.Model;

            /** If the child element exist return true; otherwise, false.
             */
            hasChild?: boolean;

            /** returns the current list item.
             */
            item?: string;

            /** returns the current text of item.
             */
            text?: string;

            /** returns the current Index of the item.
             */
            index?: number;

            /** If checked return true; otherwise, false.
             */
            isChecked?: boolean;

            /** returns the list of checked items.
             */
            checkedItems?: number;

            /** returns the current checked item text.
             */
            checkedItemsText?: string;
        }

        export interface AjaxSettings {

            /** It specifies, whether to enable or disable asynchronous request.
             */
            async?: boolean;

            /** It specifies the page will be cached in the web browser.
             */
            cache?: boolean;

            /** It specifies the type of data is send in the query string.
             */
            contentType?: string;

            /** It specifies the data as an object, will be passed in the query string.
             */
            data?: any;

            /** It specifies the type of data that you're expecting back from the response.
             */
            dataType?: string;

            /** It specifies the HTTP request type.
             */
            type?: string;
        }

        export interface FieldSettings {

            /** Defines the specific field name which contains Boolean values to specify whether the list items to be checked by default or not.
             */
            checked?: boolean;

            /** Defines the URL to be navigated while clicking the list item.
             */
            navigateUrl?: string;

            /** Defines the HTML attributes such as id, class, styles for the specific list item.
             */
            attributes?: any;

            /** Defines the specific field name which contains id values for the list items.
             */
            id?: string;

            /** Defines the URL for the image to be displayed in the list item.
             */
            imageUrl?: string;

            /** Defines the class name for image in that specific list items.
             */
            imageClass?: string;

            /** Specifies whether to prevent the selection of the list item.
             */
            preventSelection?: boolean;

            /** Specifies whether to retain the selection of the list item.
             */
            persistSelection?: boolean;

            /** To define the first level of list items.
             */
            primaryKey?: string;

            /** To define the child level of list items inside the parent items.
             */
            parentPrimaryKey?: string;

            /** Defines the specific field name in the data source to load the list with data.
             */
            text?: string;

            /** To trigger the mouseup event for specific list items.
             */
            mouseUP?: string;

            /** To trigger the mousedown event for specific list items.
             */
            mouseDown?: string;
        }
    }

    class MaskEdit extends ej.Widget {
        static fn: MaskEdit;
        constructor(element: JQuery | Element, options?: MaskEdit.Model);
        static Locale: any;
        model: MaskEdit.Model;
        defaults: MaskEdit.Model;

        /** To clear the text in mask edit textbox control.
         * @returns {void}
         */
        clear(): void;

        /** To disable the mask edit textbox control.
         * @returns {void}
         */
        disable(): void;

        /** To enable the mask edit textbox control.
         * @returns {void}
         */
        enable(): void;

        /** To obtained the pure value of the text value, removes all the symbols in mask edit textbox control.
         * @returns {string}
         */
        get_StrippedValue(): string;

        /** To obtained the textbox value as such that, Just replace all '_' to ' '(space) in mask edit textbox control.
         * @returns {string}
         */
        get_UnstrippedValue(): string;
    }
    export namespace MaskEdit {

        export interface Model {

            /** Specify the cssClass to achieve custom theme.
             * @Default {null}
             */
            cssClass?: string;

            /** Specify the custom character allowed to entered in mask edit textbox control.
             * @Default {null}
             */
            customCharacter?: string;

            /** Specify the state of the mask edit textbox control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specify the enablePersistence to mask edit textbox to save current model value to browser cookies for state maintains.
             */
            enablePersistence?: boolean;

            /** Specifies the height for the mask edit textbox control.
             * @Default {28 px}
             */
            height?: string;

            /** Specifies whether hide the prompt characters with spaces on blur. Prompt chars will be shown again on focus the textbox.
             * @Default {false}
             */
            hidePromptOnLeave?: boolean;

            /** Specifies the list of HTML attributes to be added to mask edit textbox.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specify the inputMode for mask edit textbox control. See InputMode
             * @Default {ej.InputMode.Text}
             */
            inputMode?: ej.InputMode|string;

            /** Defines the localization culture for MaskEdit.
             * @Default {en-US}
             */
            locale?: string;

            /** Specifies the input mask.
             * @Default {null}
             */
            maskFormat?: string;

            /** Specifies the name attribute value for the mask edit textbox.
             * @Default {null}
             */
            name?: string;

            /** Toggles the readonly state of the mask edit textbox. When the mask edit textbox is readonly, it doesn't allow your input.
             * @Default {false}
             */
            readOnly?: boolean;

            /** Specifies whether the error will show until correct value entered in the mask edit textbox control.
             * @Default {false}
             */
            showError?: boolean;

            /** when showPromptChar is true, the hide the prompt characters are shown in focus of the control and hides in focus out of the control.
             * @Default {true}
             */
            showPromptChar?: boolean;

            /** MaskEdit input is displayed in rounded corner style when this property is set to true.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specify the text alignment for mask edit textbox control.See TextAlign
             * @Default {left}
             */
            textAlign?: ej.TextAlign|string;

            /** Sets the jQuery validation error message in mask edit. This property works when the widget is present inside the form. Include jquery.validate.min.js plugin additionally.
             * @Default {null}
             */
            validationMessage?: any;

            /** Sets the jQuery validation rules to the MaskEdit. This property works when the widget is present inside the form. Include jquery.validate.min.js plugin additionally.
             * @Default {null}
             */
            validationRules?: any;

            /** Specifies the value for the mask edit textbox control.
             * @Default {null}
             */
            value?: string;

            /** Specifies the water mark text to be displayed in input text.
             * @Default {null}
             */
            watermarkText?: string;

            /** Specifies the width for the mask edit textbox control.
             * @Default {143pixel}
             */
            width?: string;

            /** Fires when value changed in mask edit textbox control.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires after MaskEdit control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the MaskEdit is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when focused in mask edit textbox control.
             */
            focusIn?(e: FocusInEventArgs): void;

            /** Fires when focused out in mask edit textbox control.
             */
            focusOut?(e: FocusOutEventArgs): void;

            /** Fires when keydown in mask edit textbox control.
             */
            onKeyDown?(e: OnKeyDownEventArgs): void;

            /** Fires when key press in mask edit textbox control.
             */
            keyPress?(e: KeyPressEventArgs): void;

            /** Fires when keyup in mask edit textbox control.
             */
            keyUp?(e: KeyUpEventArgs): void;

            /** Fires when mouse out in mask edit textbox control.
             */
            mouseOut?(e: MouseOutEventArgs): void;

            /** Fires when mouse over in mask edit textbox control.
             */
            mouseOver?(e: MouseOverEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mask edit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mask edit value
             */
            value?: number;

            /** returns unstripped value in mask edit textbox control.
             */
            unmaskedValue?: string;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the MaskEdit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the MaskEdit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface FocusInEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mask edit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mask edit value
             */
            value?: number;

            /** returns unstripped value in mask edit textbox control.
             */
            unmaskedValue?: string;
        }

        export interface FocusOutEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mask edit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mask edit value
             */
            value?: number;

            /** returns unstripped value in mask edit textbox control.
             */
            unmaskedValue?: string;
        }

        export interface OnKeyDownEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mask edit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mask edit value
             */
            value?: number;

            /** returns unstripped value in mask edit textbox control.
             */
            unmaskedValue?: string;
        }

        export interface KeyPressEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mask edit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mask edit value
             */
            value?: number;

            /** returns unstripped value in mask edit textbox control.
             */
            unmaskedValue?: string;
        }

        export interface KeyUpEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mask edit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mask edit value
             */
            value?: number;

            /** returns unstripped value in mask edit textbox control.
             */
            unmaskedValue?: string;
        }

        export interface MouseOutEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mask edit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mask edit value
             */
            value?: number;

            /** returns unstripped value in mask edit textbox control.
             */
            unmaskedValue?: string;
        }

        export interface MouseOverEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the mask edit model
             */
            model?: ej.MaskEdit.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mask edit value
             */
            value?: number;

            /** returns unstripped value in mask edit textbox control.
             */
            unmaskedValue?: string;
        }
    }
    enum InputMode {
        //string
        Password,
        //string
        Text,
    }
    enum TextAlign {
        //string
        Center,
        //string
        Justify,
        //string
        Left,
        //string
        Right,
    }

    class Menu extends ej.Widget {
        static fn: Menu;
        constructor(element: JQuery | Element, options?: Menu.Model);
        static Locale: any;
        model: Menu.Model;
        defaults: Menu.Model;

        /** Disables the Menu control.
         * @returns {void}
         */
        disable(): void;

        /** Specifies the Menu Item to be disabled by using the Menu Item Text.
         * @param {string} Specifies the Menu Item Text to be disabled.
         * @returns {void}
         */
        disableItem(itemtext: string): void;

        /** Specifies the Menu Item to be disabled by using the Menu Item Id.
         * @param {string|number} Specifies the Menu Item id to be disabled
         * @returns {void}
         */
        disableItemByID(itemid: string|number): void;

        /** Enables the Menu control.
         * @returns {void}
         */
        enable(): void;

        /** Specifies the Menu Item to be enabled by using the Menu Item Text.
         * @param {string} Specifies the Menu Item Text to be enabled.
         * @returns {void}
         */
        enableItem(itemtext: string): void;

        /** Specifies the Menu Item to be enabled by using the Menu Item Id.
         * @param {string|number} Specifies the Menu Item id to be enabled.
         * @returns {void}
         */
        enableItemByID(itemid: string|number): void;

        /** Hides the Context Menu control.
         * @returns {void}
         */
        hide(): void;

        /** Hides the specific items in Menu control.
         * @param {string|any[]} ItemID of the Menu item to be hidden
         * @returns {void}
         */
        hideItems(itemID: string|any[]): void;

        /** Insert the menu item as child of target node.
         * @param {any} Information about Menu item.
         * @param {string|any} Selector of target node or Object of target node.
         * @returns {void}
         */
        insert(item: any, target: string|any): void;

        /** Insert the menu item after the target node.
         * @param {any} Information about Menu item.
         * @param {string|any} Selector of target node or Object of target node.
         * @returns {void}
         */
        insertAfter(item: any, target: string|any): void;

        /** Insert the menu item before the target node.
         * @param {any} Information about Menu item.
         * @param {string|any} Selector of target node or Object of target node.
         * @returns {void}
         */
        insertBefore(item: any, target: string|any): void;

        /** Remove Menu item.
         * @param {any|any[]} Selector of target node or Object of target node.
         * @returns {void}
         */
        remove(target: any|any[]): void;

        /** To show the Menu control.
         * @param {number} x co-ordinate position of context menu.
         * @param {number} y co-ordinate position of context menu.
         * @param {any} target element
         * @param {any} name of the event
         * @returns {void}
         */
        show(locationX: number, locationY: number, targetElement: any, event: any): void;

        /** Show the specific items in Menu control.
         * @param {string|any[]} ItemID of the Menu item to be shown
         * @returns {void}
         */
        showItems(itemID: string|any[]): void;
    }
    export namespace Menu {

        export interface Model {

            /** To enable or disable the Animation while hover or click an menu items.See AnimationType
             * @Default {ej.AnimationType.Default}
             */
            animationType?: ej.AnimationType|string;

            /** Specifies the target id of context menu. On right clicking the specified contextTarget element, context menu gets shown.
             * @Default {null}
             */
            contextMenuTarget?: string;

            /** Specifies the container element selectors for submenuâ€™s collision. The submenu gets displayed based on spacing available with respect to container element.
             * @Default {null}
             */
            container?: string;

            /** Specify the CSS class to achieve custom theme.
             */
            cssClass?: string;

            /** To enable or disable the Animation effect while hover or click an menu items.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** Specifies the root menu items to be aligned center in horizontal menu.
             * @Default {false}
             */
            enableCenterAlign?: boolean;

            /** Enable / Disable the Menu control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specifies the menu items to be displayed in right to left direction.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** When this property sets to false, the menu items is displayed without any separators.
             * @Default {true}
             */
            enableSeparator?: boolean;

            /** Specifies the target which needs to be excluded. i.e., The context menu will not be displayed in those specified targets.
             * @Default {null}
             */
            excludeTarget?: string;

            /** Fields used to bind the data source and it includes following field members to make data bind easier.
             * @Default {null}
             */
            fields?: Fields;

            /** Specifies the height of the root menu.
             * @Default {auto}
             */
            height?: string|number;

            /** Specifies the list of HTML attributes to be added to menu control.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Enables/disables responsive support for the Menu control during the window resizing time.
             * @Default {true}
             */
            isResponsive?: boolean;

            /** Specifies the type of the menu. Essential JavaScript Menu consists of two type of menu, they are Normal Menu and Context Menu mode.See MenuType
             * @Default {ej.MenuType.NormalMenu}
             */
            menuType?: string|ej.MenuType;

            /** Specifies the sub menu items to be show or open only on click.
             * @Default {false}
             */
            openOnClick?: boolean;

            /** Specifies the orientation of normal menu. Normal menu can rendered in horizontal or vertical direction by using this API. See Orientation
             * @Default {ej.Orientation.Horizontal}
             */
            orientation?: ej.Orientation|string;

            /** Specifies the main menu items arrows only to be shown if it contains child items.
             * @Default {true}
             */
            showRootLevelArrows?: boolean;

            /** Specifies the sub menu items arrows only to be shown if it contains child items.
             * @Default {true}
             */
            showSubLevelArrows?: boolean;

            /** Specifies position of pull down submenu that will appear on mouse over.See Direction
             * @Default {ej.Direction.Right}
             */
            subMenuDirection?: string|ej.Direction;

            /** Specifies the title to responsive menu.
             * @Default {Menu}
             */
            titleText?: string;

            /** Specifies the width of the main menu.
             * @Default {auto}
             */
            width?: string|number;

            /** Specifies the popup menu height.
             * @Default {auto}
             */
            overflowHeight?: string|number;

            /** Specifies the popup menu width.
             * @Default {auto}
             */
            overflowWidth?: string|number;

            /** Fires before context menu gets open.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** Fires when mouse click on menu items.
             */
            click?(e: ClickEventArgs): void;

            /** Fire when context menu on close.
             */
            close?(e: CloseEventArgs): void;

            /** Fires when context menu on open.
             */
            open?(e: OpenEventArgs): void;

            /** Fires to create menu items.
             */
            create?(e: CreateEventArgs): void;

            /** Fires to destroy menu items.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when key down on menu items.
             */
            keydown?(e: KeydownEventArgs): void;

            /** Fires when mouse out from menu items.
             */
            mouseout?(e: MouseoutEventArgs): void;

            /** Fires when mouse over the Menu items.
             */
            mouseover?(e: MouseoverEventArgs): void;

            /** Fires when overflow popup menu opens.
             */
            overflowOpen?(e: OverflowOpenEventArgs): void;

            /** Fires when overflow popup menu closes.
             */
            overflowClose?(e: OverflowCloseEventArgs): void;
        }

        export interface BeforeOpenEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the target element
             */
            target?: any;
        }

        export interface ClickEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns clicked menu item text
             */
            text?: string;

            /** returns clicked menu item element
             */
            element?: any;

            /** returns the event
             */
            event?: any;

            /** returns the selected item
             */
            selectedItem?: number;
        }

        export interface CloseEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the target element
             */
            target?: any;
        }

        export interface OpenEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the target element
             */
            target?: any;
        }

        export interface CreateEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface KeydownEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns clicked menu item text
             */
            menuText?: string;

            /** returns clicked menu item element
             */
            element?: any;

            /** returns the event
             */
            event?: any;
        }

        export interface MouseoutEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns clicked menu item text
             */
            text?: string;

            /** returns clicked menu item element
             */
            element?: any;

            /** returns the event
             */
            event?: any;
        }

        export interface MouseoverEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns clicked menu item text
             */
            text?: string;

            /** returns clicked menu item element
             */
            element?: any;

            /** returns the event
             */
            event?: any;
        }

        export interface OverflowOpenEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            e?: any;

            /** if the event should be cancelled ; otherwise ,false
             */
            cancel?: boolean;
        }

        export interface OverflowCloseEventArgs {

            /** returns the menu model
             */
            model?: ej.Menu.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            e?: any;

            /** if the event should be cancelled ; otherwise ,false
             */
            cancel?: boolean;
        }

        export interface Fields {

            /** It receives the child data for the inner level.
             */
            child?: any;

            /** It receives datasource as Essential DataManager object and JSON object.
             */
            dataSource?: any;

            /** Specifies the HTML attributes to â€œLIâ€ item list.
             */
            htmlAttribute?: string;

            /** Specifies the id to menu items list
             */
            id?: string;

            /** Specifies the image attribute to â€œimgâ€ tag inside items list.
             */
            imageAttribute?: string;

            /** Specifies the image URL to â€œimgâ€ tag inside item list.
             */
            imageUrl?: string;

            /** Adds custom attributes like &quot;target&quot; to the anchor tag of the menu items.
             */
            linkAttribute?: string;

            /** Specifies the parent id of the table.
             */
            parentId?: string;

            /** It receives query to retrieve data from the table (query is same as SQL).
             */
            query?: any;

            /** Specifies the sprite CSS class to â€œLIâ€ item list.
             */
            spriteCssClass?: string;

            /** It receives table name to execute query on the corresponding table.
             */
            tableName?: string;

            /** Specifies the text of menu items list.
             */
            text?: string;

            /** Specifies the URL to the anchor tag in menu item list.
             */
            url?: string;
        }
    }
    enum AnimationType {
        //string
        Default,
        //string
        None,
    }
    enum MenuType {
        //string
        ContextMenu,
        //string
        NormalMenu,
    }
    enum Direction {
        //string
        Left,
        //string
        None,
        //string
        Right,
    }

    class Pager extends ej.Widget {
        static fn: Pager;
        constructor(element: JQuery | Element, options?: Pager.Model);
        static Locale: any;
        model: Pager.Model;
        defaults: Pager.Model;

        /** Send a paging request to specified page through the pager control.
         * @param {number} Specifies the index to be navigated
         * @returns {void}
         */
        gotoPage(pageIndex: number): void;

        /** goToFirstPage() helps to navigate to the first page of the pager.
         * @returns {void}
         */
        goToFirstPage(): void;

        /** goToNextPage() helps to navigate to the next page to the current page of the pager.
         * @returns {void}
         */
        goToNextPage(): void;

        /** goToLastPage() helps to navigate to the Last page of the pager.
         * @returns {void}
         */
        goToLastPage(): void;

        /** goToPrevPage() helps to navigate to the previous page to the current page of the pager.
         * @returns {void}
         */
        goToPrevPage(): void;

        /** refreshPager() helps to refresh the model value of pager control.
         * @returns {void}
         */
        refreshPager(): void;
    }
    export namespace Pager {

        export interface Model {

            /** Gets or sets a value that indicates whether to display the custom text message in Pager.
             */
            customText?: string;

            /** Gets or sets a value that indicates whether to define which page to display currently in pager.
             * @Default {1}
             */
            currentPage?: number;

            /** Sets the root CSS class, which can be used for customization of pager control.
             */
            cssClass?: string;

            /** Enable or disable the Pager control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Gets or sets a value that indicates whether to display the external Message in Pager.
             * @Default {false}
             */
            enableExternalMessage?: boolean;

            /** Gets or sets a value that indicates whether to pass the current page information as a query string along with the URL while navigating to other page.
             * @Default {false}
             */
            enableQueryString?: boolean;

            /** Align content in the pager control from right to left by setting the property as true.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Gets or sets a value that indicates whether to display the external Message in Pager.
             */
            externalMessage?: string;

            /** Enables or disables responsive support for the Pager control items on window resize.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Gets or sets a value that indicates whether to customizing the user interface (UI) as locale-specific in order to display regional data i.e. in a language and culture specific to
             * a particular country or region.
             * @Default {en-US}
             */
            locale?: string;

            /** Gets or sets a value that indicates whether to define the number of pages displayed in the pager for navigation.
             * @Default {10}
             */
            pageCount?: number;

            /** Gets or sets a value that indicates whether to define the number of records displayed per page.
             * @Default {12}
             */
            pageSize?: number;

            /** It allows to have multiple choices of pageSize values for Pager control. The &quot;pageSize&quot; API value of the pager will be updated depending upon the value being selected
             * from the dropdown.
             * @Default {null}
             */
            pageSizeList?: any[];

            /** Indicates the pageSizeMessage to be displayed in Pager when pageSizeList API is defined.
             */
            pageSizeMessage?: String;

            /** Template option allows to customize UI appearance of the ejPager by defining their own page layout.
             * @Default {null}
             */
            template?: string;

            /** Get or sets a value of total number of pages in the pager. The totalPages value is calculated based on page size and total records.
             * @Default {null}
             */
            totalPages?: number;

            /** Get the value of total number of records which is bound to a data item.
             * @Default {null}
             */
            totalRecordsCount?: number;

            /** Shows or hides the current page information in pager footer.
             * @Default {true}
             */
            showPageInfo?: boolean;

            /** Triggered when pager numeric item is clicked in pager control.
             */
            click?(e: ClickEventArgs): void;

            /** Triggers when the current page value of the Pager control is changed.
             */
            change?(e: ChangeEventArgs): void;

            /** Triggered when Pager control is successfully created.
             */
            create?(e: CreateEventArgs): void;

            /** Triggered when Pager control is successfully destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggered when a value is selected in the pageSizeList dropdown.
             */
            pageSizeSelected?(e: PageSizeSelectedEventArgs): void;
        }

        export interface ClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the current page index.
             */
            currentPage?: number;

            /** Returns the pager model.
             */
            model?: any;

            /** Returns the name of event
             */
            type?: string;

            /** Returns current action event type and its target.
             */
            event?: any;
        }

        export interface ChangeEventArgs {

            /** Returns the current page index.
             */
            currentPage?: number;

            /** Returns the pager model.
             */
            model?: any;

            /** Returns the name of event
             */
            type?: string;

            /** Returns current action event type and its target.
             */
            event?: any;
        }

        export interface CreateEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the pager model.
             */
            model?: any;

            /** Returns the name of event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the pager model.
             */
            model?: any;

            /** Returns the name of event
             */
            type?: string;
        }

        export interface PageSizeSelectedEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the pager model.
             */
            model?: any;

            /** Returns the name of event
             */
            type?: string;
        }
    }

    class Print extends ej.Widget {
        static fn: Print;
        constructor(element: JQuery | Element, options?: Print.Model);
        static Locale: any;
        model: Print.Model;
        defaults: Print.Model;

        /** Print the specific page or an element.
         * @returns {void}
         */
        print(): void;
    }
    export namespace Print {

        export interface Model {

            /** Append the custom HTML after the selected content.
             * @Default {null}
             */
            append?: string;

            /** A selector that specifies a particular element to be excluded from printing.
             * @Default {null}
             */
            excludeSelector?: string;

            /** Specifies whether the URL of an external stylesheet can be included to customize and print that page.
             * @Default {null}
             */
            externalStyles?: string;

            /** Prepend a docType to the document frame.
             * @Default {&lt;!doctype html&gt;}
             */
            docType?: string;

            /** Specifies whether the global styles can be applied to the element to be printed.
             * @Default {true}
             */
            globalStyles?: boolean;

            /** Sets the height of the print window.
             * @Default {454}
             */
            height?: number;

            /** Prepends the custom HTML before the selected content.
             * @Default {null}
             */
            prepend?: string;

            /** Allows printing the content in a new window.
             * @Default {false}
             */
            printInNewWindow?: boolean;

            /** Sets the period of time to wait before printing the content.
             * @Default {1000}
             */
            timeOutPeriod?: number;

            /** Sets the title of the print document.
             * @Default {null}
             */
            title?: string;

            /** Defines the width of the print window.
             * @Default {1024}
             */
            width?: number;

            /** Event triggers before the document page or an element in it gets printed.
             */
            beforeStart?(e: BeforeStartEventArgs): void;
        }

        export interface BeforeStartEventArgs {

            /** Set this option as true to cancel the event.
             */
            cancel?: boolean;

            /** Returns the Print model
             */
            model?: ej.Print.Model;

            /** Returns the name of an event
             */
            type?: string;

            /** Returns the printed element
             */
            content?: any;
        }
    }

    class ProgressBar extends ej.Widget {
        static fn: ProgressBar;
        constructor(element: JQuery | Element, options?: ProgressBar.Model);
        static Locale: any;
        model: ProgressBar.Model;
        defaults: ProgressBar.Model;

        /** Destroy the progressbar widget
         * @returns {void}
         */
        destroy(): void;

        /** Disables the progressbar control
         * @returns {void}
         */
        disable(): void;

        /** Enables the progressbar control
         * @returns {void}
         */
        enable(): void;

        /** Returns the current progress value in percent.
         * @returns {number}
         */
        getPercentage(): number;

        /** Returns the current progress value
         * @returns {number}
         */
        getValue(): number;
    }
    export namespace ProgressBar {

        export interface Model {

            /** Sets the root CSS class for ProgressBar theme, which is used customize.
             * @Default {null}
             */
            cssClass?: string;

            /** When this property sets to false, it disables the ProgressBar control
             * @Default {true}
             */
            enabled?: boolean;

            /** Save current model value to browser cookies for state maintains. While refresh the progressBar control page retains the model value apply from browser cookies
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Sets the ProgressBar direction as right to left alignment.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Defines the height of the ProgressBar.
             * @Default {null}
             */
            height?: number|string;

            /** It allows to define the characteristics of the progressBar control. It will helps to extend the capability of an HTML element.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Sets the maximum value of the ProgressBar.
             * @Default {100}
             */
            maxValue?: number;

            /** Sets the minimum value of the ProgressBar.
             * @Default {0}
             */
            minValue?: number;

            /** Sets the ProgressBar value in percentage. The value should be in between 0 to 100.
             * @Default {0}
             */
            percentage?: number;

            /** Displays rounded corner borders on the progressBar control.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Sets the custom text for the ProgressBar. The text placed in the middle of the ProgressBar and it can be customizable using the class 'e-progress-text'.
             * @Default {null}
             */
            text?: string;

            /** Sets the ProgressBar value. The value should be in between min and max values.
             * @Default {0}
             */
            value?: number;

            /** Defines the width of the ProgressBar.
             * @Default {null}
             */
            width?: number|string;

            /** Event triggers when the progress value changed
             */
            change?(e: ChangeEventArgs): void;

            /** Event triggers when the process completes (at 100%)
             */
            complete?(e: CompleteEventArgs): void;

            /** Event triggers when the progressbar are created
             */
            create?(e: CreateEventArgs): void;

            /** Event triggers when the progressbar are destroyed
             */
            destroy?(e: DestroyEventArgs): void;

            /** Event triggers when the process starts (from 0%)
             */
            start?(e: StartEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the ProgressBar model
             */
            model?: ej.ProgressBar.Model;

            /** returns the current progress percentage
             */
            percentage?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the current progress value
             */
            value?: string;
        }

        export interface CompleteEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the ProgressBar model
             */
            model?: ej.ProgressBar.Model;

            /** returns the current progress percentage
             */
            percentage?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the current progress value
             */
            value?: string;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the progressbar model
             */
            model?: ej.ProgressBar.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the progressbar model
             */
            model?: ej.ProgressBar.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface StartEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the ProgressBar model
             */
            model?: ej.ProgressBar.Model;

            /** returns the current progress percentage
             */
            percentage?: any;

            /** returns the name of the event
             */
            type?: string;

            /** returns the current progress value
             */
            value?: string;
        }
    }

    class RadioButton extends ej.Widget {
        static fn: RadioButton;
        constructor(element: JQuery | Element, options?: RadioButton.Model);
        static Locale: any;
        model: RadioButton.Model;
        defaults: RadioButton.Model;

        /** To disable the RadioButton
         * @returns {void}
         */
        disable(): void;

        /** To enable the RadioButton
         * @returns {void}
         */
        enable(): void;
    }
    export namespace RadioButton {

        export interface Model {

            /** Specifies the check attribute of the Radio Button.
             * @Default {false}
             */
            checked?: boolean;

            /** Specify the CSS class to RadioButton to achieve custom theme.
             */
            cssClass?: string;

            /** Specifies the RadioButton control state.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specifies the enablePersistence property for RadioButton while initialization. The enablePersistence API save current model value to browser cookies for state maintains. While
             * refreshing the radio button control page the model value apply from browser cookies.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Specify the Right to Left direction to RadioButton
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specifies the HTML Attributes of the Checkbox
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specifies the id attribute for the Radio Button while initialization.
             * @Default {null}
             */
            id?: string;

            /** Specify the idPrefix value to be added before the current id of the RadioButton.
             * @Default {ej}
             */
            idPrefix?: string;

            /** Specifies the name attribute for the Radio Button while initialization.
             * @Default {Sets id as name if it is null}
             */
            name?: string;

            /** Specifies the size of the RadioButton.
             * @Default {small}
             */
            size?: ej.RadioButtonSize|string;

            /** Specifies the text content for RadioButton.
             */
            text?: string;

            /** Set the jQuery validation error message in radio button.
             * @Default {null}
             */
            validationMessage?: any;

            /** Set the jQuery validation rules in radio button.
             * @Default {null}
             */
            validationRules?: any;

            /** Specifies the value attribute of the Radio Button.
             * @Default {null}
             */
            value?: string;

            /** Fires before the RadioButton is going to changed its state successfully
             */
            beforeChange?(e: BeforeChangeEventArgs): void;

            /** Fires when the RadioButton state is changed successfully
             */
            change?(e: ChangeEventArgs): void;

            /** Fires when the RadioButton created successfully
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the RadioButton destroyed successfully
             */
            destroy?(e: DestroyEventArgs): void;
        }

        export interface BeforeChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the RadioButton model
             */
            model?: ej.RadioButton.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns true if element is checked, otherwise returns false
             */
            isChecked?: boolean;

            /** returns true if change event triggered by interaction, otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface ChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the RadioButton model
             */
            model?: ej.RadioButton.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns true if element is checked, otherwise returns false
             */
            isChecked?: boolean;

            /** returns true if change event triggered by interaction, otherwise returns false
             */
            isInteraction?: boolean;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the RadioButton model
             */
            model?: ej.RadioButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the RadioButton model
             */
            model?: ej.RadioButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }
    }
    enum RadioButtonSize {
        //Shows small size radio button
        Small,
        //Shows medium size radio button
        Medium,
    }

    class Rating extends ej.Widget {
        static fn: Rating;
        constructor(element: JQuery | Element, options?: Rating.Model);
        static Locale: any;
        model: Rating.Model;
        defaults: Rating.Model;

        /** Destroy the Rating widget all events bound will be unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** To get the current value of rating control.
         * @returns {number}
         */
        getValue(): number;

        /** To hide the rating control.
         * @returns {void}
         */
        hide(): void;

        /** User can refresh the rating control to identify changes.
         * @returns {void}
         */
        refresh(): void;

        /** To reset the rating value.
         * @returns {void}
         */
        reset(): void;

        /** To set the rating value.
         * @param {string|number} Specifies the rating value.
         * @returns {void}
         */
        setValue(value: string|number): void;

        /** To show the rating control
         * @returns {void}
         */
        show(): void;
    }
    export namespace Rating {

        export interface Model {

            /** Enables the rating control with reset button.It can be used to reset the rating control value.
             * @Default {true}
             */
            allowReset?: boolean;

            /** Specify the CSS class to achieve custom theme.
             */
            cssClass?: string;

            /** When this property is set to false, it disables the rating control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Save current model value to browser cookies for state maintenance. While refresh the page Rating control values are retained.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Specifies the height of the Rating control wrapper.
             * @Default {null}
             */
            height?: string;

            /** Specifies the list of HTML attributes to be added to rating control.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specifies the value to be increased while navigating between shapes(stars) in Rating control.
             * @Default {1}
             */
            incrementStep?: number;

            /** Allow to render the maximum number of Rating shape(star).
             * @Default {5}
             */
            maxValue?: number;

            /** Allow to render the minimum number of Rating shape(star).
             * @Default {0}
             */
            minValue?: number;

            /** Specifies the orientation of Rating control. See Orientation
             * @Default {ej.Rating.Orientation.Horizontal}
             */
            orientation?: ej.Orientation|string;

            /** Helps to provide more precise ratings.Rating control supports three precision modes - full, half, and exact. See Precision
             * @Default {full}
             */
            precision?: ej.Rating.Precision|string;

            /** Interaction with Rating control can be prevented by enabling this API.
             * @Default {false}
             */
            readOnly?: boolean;

            /** To specify the height of each shape in Rating control.
             * @Default {23}
             */
            shapeHeight?: number;

            /** To specify the width of each shape in Rating control.
             * @Default {23}
             */
            shapeWidth?: number;

            /** Enables the tooltip option.Currently selected value will be displayed in tooltip.
             * @Default {true}
             */
            showTooltip?: boolean;

            /** To specify the number of stars to be selected while rendering.
             * @Default {1}
             */
            value?: number;

            /** Specifies the width of the Rating control wrapper.
             * @Default {null}
             */
            width?: string;

            /** Fires when Rating value changes.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires when Rating control is clicked successfully.
             */
            click?(e: ClickEventArgs): void;

            /** Fires when Rating control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when Rating control is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when mouse hover is removed from Rating control.
             */
            mouseout?(e: MouseoutEventArgs): void;

            /** Fires when mouse move is moving the Rating control.
             */
            mousemove?(e: MousemoveEventArgs): void;

            /** Fires when mouse hovered over the Rating control.
             */
            mouseover?(e: MouseoverEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** returns the current value.
             */
            value?: number;

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rating model
             */
            model?: ej.Rating.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mouse click event args values.
             */
            event?: any;
        }

        export interface ClickEventArgs {

            /** returns the current value.
             */
            value?: number;

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rating model
             */
            model?: ej.Rating.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mouse click event args values.
             */
            event?: any;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rating model
             */
            model?: ej.Rating.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rating model
             */
            model?: ej.Rating.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface MouseoutEventArgs {

            /** returns the current value.
             */
            value?: number;

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rating model
             */
            model?: ej.Rating.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mouse click event args values.
             */
            event?: any;
        }

        export interface MousemoveEventArgs {

            /** returns the current value.
             */
            value?: number;

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rating model
             */
            model?: ej.Rating.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mouse click event args values.
             */
            event?: any;
        }

        export interface MouseoverEventArgs {

            /** returns the current value.
             */
            value?: number;

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rating model
             */
            model?: ej.Rating.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the mouse click event args values.
             */
            event?: any;

            /** returns the current index value.
             */
            index?: any;
        }

        enum Precision {

            ///string
            Exact,

            ///string
            Full,

            ///string
            Half
        }

    }

    class Ribbon extends ej.Widget {
        static fn: Ribbon;
        constructor(element: JQuery | Element, options?: Ribbon.Model);
        static Locale: any;
        model: Ribbon.Model;
        defaults: Ribbon.Model;

        /** Adds contextual tab or contextual tab set dynamically in the ribbon control with contextual tabs object and index position. When index is null, ribbon contextual tab or contextual
         * tab set is added at the last index.
         * @param {any} contextual tab or contextual tab set object.
         * @param {number} index of the contextual tab or contextual tab set, this is optional.
         * @returns {void}
         */
        addContextualTabs(contextualTabSet: any, index?: number): void;

        /** Add new option to Backstage page.
         * @param {any} select the object to add the backstage item
         * @param {number} index to the backstage item this is optional.
         * @returns {void}
         */
        addBackStageItem(item: any, index?: number): void;

        /** Adds tab dynamically in the ribbon control with given name, tab group array and index position. When index is null, ribbon tab is added at the last index.
         * @param {string} ribbon tab display text.
         * @param {any[]} groups to be displayed in ribbon tab .
         * @param {number} index of the ribbon tab,this is optional.
         * @returns {void}
         */
        addTab(tabText: string, ribbonGroups: any[], index?: number): void;

        /** Adds tab group dynamically in the ribbon control with given tab index, tab group object and group index position. When group index is null, ribbon group is added at the last index.
         * @param {number} ribbon tab index.
         * @param {any} group to be displayed in ribbon tab .
         * @param {number} index of the ribbon group,this is optional.
         * @returns {void}
         */
        addTabGroup(tabIndex: number, tabGroup: any, groupIndex?: number): void;

        /** Adds group content dynamically in the ribbon control with given tab index, group index, content, content index and sub group index position. When content index is null, content is
         * added at the last index.
         * @param {number} ribbon tab index.
         * @param {number} ribbon group index.
         * @param {any} content to be displayed in the ribbon group.
         * @param {number} ribbon content index. This is optional. If the value is not given, then by default contentIndex will be considered as 0.
         * @param {number} sub group index in the ribbon group. This is optional. If the value is not given, then by default contentIndex will be considered as 0.
         * @returns {void}
         */
        addTabGroupContent(tabIndex: number, groupIndex: number, content: any, contentIndex?: number, subGroupIndex?: number): void;

        /** Hides the ribbon backstage page.
         * @returns {void}
         */
        hideBackstage(): void;

        /** Collapses the ribbon tab content.
         * @returns {void}
         */
        collapse(): void;

        /** Destroys the ribbon widget. All the events bound using this._on are unbound automatically and the ribbon control is moved to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** Expands the ribbon tab content.
         * @returns {void}
         */
        expand(): void;

        /** Gets text of the given index tab in the ribbon control.
         * @param {number} index of the tab item.
         * @returns {string}
         */
        getTabText(index: number): string;

        /** Hides the given text tab in the ribbon control.
         * @param {string} text of the tab item.
         * @returns {void}
         */
        hideTab(text: string): void;

        /** Checks whether the given text tab in the ribbon control is enabled or not.
         * @param {string} text of the tab item.
         * @returns {boolean}
         */
        isEnable(text: string): boolean;

        /** Checks whether the given text tab in the ribbon control is visible or not.
         * @param {string} text of the tab item.
         * @returns {boolean}
         */
        isVisible(text: string): boolean;

        /** Removes the given index tab item from the ribbon control.
         * @param {number} index of tab item.
         * @returns {void}
         */
        removeTab(index: number): void;

        /** Sets new text to the given text tab in the ribbon control.
         * @param {string} current text of the tab item.
         * @param {string} new text of the tab item.
         * @returns {void}
         */
        setTabText(tabText: string, newText: string): void;

        /** Displays the ribbon backstage page.
         * @returns {void}
         */
        showBackstage(): void;

        /** Displays the given text tab in the ribbon control.
         * @param {string} text of the tab item.
         * @returns {void}
         */
        showTab(text: string): void;

        /** To customize Group alone in the inside content.
         * @param {number} ribbon tab index.
         * @param {string} group id to be displayed in ribbon tab .
         * @param {any} contentGroup is used in the object
         * @returns {void}
         */
        updateGroup(tabIndex: number, groupId: string, contentGroup?: any): void;

        /** Update option in existing Backstage.
         * @param {number} index to the backstage item
         * @param {any} select the object to add the backstage item
         * @returns {void}
         */
        updateBackStageItem(index: number, item?: any): void;

        /** To customize whole content from Tab Group.
         * @param {number} ribbon tab index.
         * @param {string} ribbon group text.
         * @param {number} ribbon content index. This is optional. If the value is not given, all content groups will be removed.
         * @param {number} sub group index in the ribbon group. This is optional. If the value is not given, all content groups will be removed.
         * @returns {void}
         */
        removeTabGroupContent(tabIndex: number, groupText: string, contentIndex?: number, subGroupIndex?: number): void;

        /** Remove option from Backstage.
         * @param {number} index to the backstage item
         * @returns {void}
         */
        removeBackStageItem(index: number): void;
    }
    export namespace Ribbon {

        export interface Model {

            /** Enables the ribbon resize feature.allowResizing is a deprecated property of isResponsive.
             * @Default {false}
             */
            allowResizing?: boolean;

            /** When set to true, adapts the Ribbon layout to fit the screen size of devices on which it renders.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Specifies the height, width, enableRTL, showRoundedCorner,enabled,cssClass property to the controls in the ribbon commonly andit will work only when those properties are not
             * defined in buttonSettings and content defaults.
             * @Default {Object}
             */
            buttonDefaults?: any;

            /** Property to enable the ribbon quick access toolbar.
             * @Default {false}
             */
            showQAT?: boolean;

            /** Sets the root CSS class for Ribbon which allow us to customize the appearance.
             */
            cssClass?: string;

            /** Sets custom setting to the collapsible pin in the ribbon.
             * @Default {Object}
             */
            collapsePinSettings?: CollapsePinSettings;

            /** Set enableOnDemand as true to load ribbon tab and backstage contents while corresponding item clicked.
             * @Default {false}
             */
            enableOnDemand?: boolean;

            /** Set collapsible property as true to render ribbon in initially collapsed state.
             * @Default {false}
             */
            collapsible?: boolean;

            /** Align content in the ribbon control from right to left by setting the property as true.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Sets custom setting to the expandable pin in the ribbon.
             * @Default {Object}
             */
            expandPinSettings?: ExpandPinSettings;

            /** Specifies the application tab to contain application menu or backstage page in the ribbon control.
             * @Default {Object}
             */
            applicationTab?: ApplicationTab;

            /** Specifies the contextual tabs and tab set to the ribbon control with the background color and border color. Refer to the tabs section for adding tabs into the contextual tab and
             * contextual tab set.
             * @Default {Array}
             */
            contextualTabs?: ContextualTab[];

            /** Specifies the index or indexes to disable the given index tab or indexes tabs in the ribbon control.
             * @Default {0}
             */
            disabledItemIndex?: any[];

            /** Specifies the index or indexes to enable the given index tab or indexes tabs in the ribbon control.
             * @Default {null}
             */
            enabledItemIndex?: any[];

            /** Specifies the index of the ribbon tab to select the given index tab item in the ribbon control.
             * @Default {1}
             */
            selectedItemIndex?: number;

            /** Specifies the tabs and its groups. Also specifies the control details that has to be placed in the tab area in the ribbon control.
             * @Default {Array}
             */
            tabs?: Tab[];

            /** Gets or sets a value that indicates whether to customizing the user interface (UI) as locale-specific in order to display regional data i.e. in a language and culture specific to
             * a particular country or region and  it will need to use the user's preference.
             * @Default {en-US}
             */
            locale?: string;

            /** Specifies the width to the ribbon control. You can set width in string or number format.
             * @Default {null}
             */
            width?: string|number;

            /** Triggered before the ribbon tab item is removed.
             */
            beforeTabRemove?(e: BeforeTabRemoveEventArgs): void;

            /** Triggered before the ribbon control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Triggered before the ribbon control is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggered when the control in the group is clicked successfully.
             */
            groupClick?(e: GroupClickEventArgs): void;

            /** Triggered when the group expander in the group is clicked successfully.
             */
            groupExpand?(e: GroupExpandEventArgs): void;

            /** Triggered when an item in the Gallery control is clicked successfully.
             */
            galleryItemClick?(e: GalleryItemClickEventArgs): void;

            /** Triggered when a tab or button in the backstage page is clicked successfully.
             */
            backstageItemClick?(e: BackstageItemClickEventArgs): void;

            /** Triggered when the ribbon control is collapsed.
             */
            collapse?(e: CollapseEventArgs): void;

            /** Triggered when the ribbon control is expanded.
             */
            expand?(e: ExpandEventArgs): void;

            /** Triggered before the ribbon control is load.
             */
            load?(e: LoadEventArgs): void;

            /** Triggered after adding the new ribbon tab item.
             */
            tabAdd?(e: TabAddEventArgs): void;

            /** Triggered when tab is clicked successfully in the ribbon control.
             */
            tabClick?(e: TabClickEventArgs): void;

            /** Triggered before the ribbon tab is created.
             */
            tabCreate?(e: TabCreateEventArgs): void;

            /** Triggered after the tab item is removed from the ribbon control.
             */
            tabRemove?(e: TabRemoveEventArgs): void;

            /** Triggered after the ribbon tab item is selected in the ribbon control.
             */
            tabSelect?(e: TabSelectEventArgs): void;

            /** Triggered when the expand/collapse button is clicked successfully .
             */
            toggleButtonClick?(e: ToggleButtonClickEventArgs): void;

            /** Triggered when the QAT menu item is clicked successfully .
             */
            qatMenuItemClick?(e: QatMenuItemClickEventArgs): void;
        }

        export interface BeforeTabRemoveEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns current tab item index in the ribbon control.
             */
            index?: number;
        }

        export interface CreateEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns current ribbon tab item index
             */
            deleteIndex?: number;
        }

        export interface GroupClickEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the control clicked in the group.
             */
            target?: number;
        }

        export interface GroupExpandEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the clicked group expander.
             */
            target?: number;
        }

        export interface GalleryItemClickEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the gallery model.
             */
            galleryModel?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the item clicked in the gallery.
             */
            target?: number;
        }

        export interface BackstageItemClickEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the item clicked in the gallery.
             */
            target?: number;

            /** returns the id of the target item.
             */
            id?: string;

            /** returns the text of the target item.
             */
            text?: string;
        }

        export interface CollapseEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ExpandEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface LoadEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface TabAddEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns new added tab header.
             */
            tabHeader?: any;

            /** returns new added tab content panel.
             */
            tabContent?: any;
        }

        export interface TabClickEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns previous active tab header.
             */
            prevActiveHeader?: any;

            /** returns previous active index.
             */
            prevActiveIndex?: number;

            /** returns current active tab header .
             */
            activeHeader?: any;

            /** returns current active index.
             */
            activeIndex?: number;
        }

        export interface TabCreateEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns current ribbon tab item index
             */
            deleteIndex?: number;
        }

        export interface TabRemoveEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the removed index.
             */
            removedIndex?: number;
        }

        export interface TabSelectEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns previous active tab header.
             */
            prevActiveHeader?: any;

            /** returns previous active index.
             */
            prevActiveIndex?: number;

            /** returns current active tab header .
             */
            activeHeader?: any;

            /** returns current active index.
             */
            activeIndex?: number;
        }

        export interface ToggleButtonClickEventArgs {

            /** Set to true when the event has to be canceled, else false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the expand/collapse button.
             */
            target?: number;
        }

        export interface QatMenuItemClickEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the ribbon model.
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the clicked menu item text.
             */
            text?: string;
        }

        export interface CollapsePinSettings {

            /** Sets tooltip for the collapse pin .
             * @Default {null}
             */
            toolTip?: string;

            /** Specifies the custom tooltip for collapse pin.Refer to ejRibbon#tabs-&gt;groups-&gt;content-&gt;groups-&gt;customToolTip for its inner properties.
             * @Default {Object}
             */
            customToolTip?: any;
        }

        export interface ExpandPinSettings {

            /** Sets tooltip for the expand pin.
             * @Default {null}
             */
            toolTip?: string;

            /** Specifies the custom tooltip for expand pin.Refer to ejRibbon#tabs-&gt;groups-&gt;content-&gt;groups-&gt;customToolTip for its inner properties.
             * @Default {Object}
             */
            customToolTip?: any;
        }

        export interface ApplicationTabBackstageSettingsPage {

            /** Specifies the id for ribbon backstage page's tab and button elements.
             * @Default {null}
             */
            id?: string;

            /** Specifies the text for ribbon backstage page's tab header and button elements.
             * @Default {null}
             */
            text?: string;

            /** Specifies the type for ribbon backstage page's contents. Set &quot;ej.Ribbon.BackStageItemType.Tab&quot; to render the tab or &quot;ej.Ribbon.BackStageItemType.Button&quot; to
             * render the button.
             * @Default {ej.Ribbon.ItemType.Tab}
             */
            itemType?: ej.Ribbon.ItemType|string;

            /** Specifies the id of HTML elements like div,ul, etc., as ribbon backstage page's tab content.
             * @Default {null}
             */
            contentID?: string;

            /** Specifies the separator between backstage page's tab and button elements.
             * @Default {false}
             */
            enableSeparator?: boolean;
        }

        export interface ApplicationTabBackstageSettings {

            /** Specifies the display text of application tab.
             * @Default {null}
             */
            text?: string;

            /** Specifies the height of ribbon backstage page.
             * @Default {null}
             */
            height?: string|number;

            /** Specifies the width of ribbon backstage page.
             * @Default {null}
             */
            width?: string|number;

            /** Specifies the ribbon backstage page with its tab and button elements.
             * @Default {Array}
             */
            pages?: ApplicationTabBackstageSettingsPage[];

            /** Specifies the width of backstage page header that contains tabs and buttons.
             * @Default {null}
             */
            headerWidth?: string|number;
        }

        export interface ApplicationTab {

            /** Specifies the ribbon backstage page items.
             * @Default {Object}
             */
            backstageSettings?: ApplicationTabBackstageSettings;

            /** Specifies the ID of ul list to create application menu in the ribbon control.
             * @Default {null}
             */
            menuItemID?: string;

            /** Specifies the menu members, events by using the menu settings for the menu in the application tab.
             * @Default {Object}
             */
            menuSettings?: any;

            /** Specifies the application menu or backstage page. Specify the type of application tab as &quot;ej.Ribbon.ApplicationTabType.Menu&quot; to render the application menu or
             * &quot;ej.Ribbon.ApplicationTabType.Backstage&quot; to render backstage page in the ribbon control.
             * @Default {ej.Ribbon.ApplicationTabType.Menu}
             */
            type?: ej.Ribbon.ApplicationTabType|string;
        }

        export interface ContextualTab {

            /** Specifies the backgroundColor of the contextual tabs and tab set in the ribbon control.
             * @Default {null}
             */
            backgroundColor?: string;

            /** Specifies the borderColor of the contextual tabs and tab set in the ribbon control.
             * @Default {null}
             */
            borderColor?: string;

            /** Specifies the tabs to present in the contextual tabs and tab set. Refer to the tabs section for adding tabs into the contextual tabs and tab set.
             * @Default {Array}
             */
            tabs?: any[];
        }

        export interface TabsGroupsContentDefaults {

            /** Specifies the controls height such as Syncfusion button,split button,dropdown list,toggle button in the subgroup of  the ribbon tab.
             * @Default {null}
             */
            height?: string|number;

            /** Specifies the controls width such as Syncfusion button,split button,dropdown list,toggle button in the subgroup of  the ribbon tab.
             * @Default {null}
             */
            width?: string|number;

            /** Specifies the controls type such as Syncfusion button,split button,dropdown list,toggle button in the subgroup of  the ribbon tab.
             * @Default {ej.Ribbon.Type.Button}
             */
            type?: string;

            /** Specifies the controls size such as Syncfusion button,split button,dropdown list,toggle button in the subgroup of  the ribbon tab.
             * @Default {false}
             */
            isBig?: boolean;
        }

        export interface TabsGroupsContentGroupsCustomGalleryItem {

            /** Specifies the Syncfusion button members, events by using buttonSettings.
             * @Default {Object}
             */
            buttonSettings?: any;

            /** Specifies the type as ej.Ribbon.CustomItemType.Menu or ej.Ribbon.CustomItemType.Button to render Syncfusion button and menu.
             * @Default {ej.Ribbon.CustomItemType.Button}
             */
            customItemType?: ej.Ribbon.CustomItemType|string;

            /** Specifies the custom tooltip for gallery extra item's button. Refer to ejRibbon#tabs-&gt;groups-&gt;content-&gt;groups-&gt;customToolTip for its inner properties.
             * @Default {Object}
             */
            customToolTip?: any;

            /** Specifies the UL list id to render menu as gallery extra item.
             * @Default {null}
             */
            menuId?: string;

            /** Specifies the Syncfusion menu members, events by using menuSettings.
             * @Default {Object}
             */
            menuSettings?: any;

            /** Specifies the text for gallery extra item's button.
             * @Default {null}
             */
            text?: string;

            /** Specifies the tooltip for gallery extra item's button.
             * @Default {null}
             */
            toolTip?: string;
        }

        export interface TabsGroupsContentGroupsCustomToolTip {

            /** Sets content to the custom tooltip. Text and HTML support are provided for content.
             * @Default {null}
             */
            content?: string;

            /** Sets icon to the custom tooltip content.
             * @Default {null}
             */
            prefixIcon?: string;

            /** Sets title to the custom tooltip. Text and HTML support are provided for title and the title is in bold for text format.
             * @Default {null}
             */
            title?: string;
        }

        export interface TabsGroupsContentGroupsGalleryItem {

            /** Specifies the Syncfusion button members, events by using buttonSettings.
             * @Default {Object}
             */
            buttonSettings?: any;

            /** Specifies the custom tooltip for gallery content. Refer to ejRibbon#tabs-&gt;groups-&gt;content-&gt;groups-&gt;customToolTip for its inner properties.
             * @Default {Object}
             */
            customToolTip?: any;

            /** Sets text for the gallery content.
             * @Default {null}
             */
            text?: string;

            /** Sets tooltip for the gallery content.
             * @Default {null}
             */
            toolTip?: string;
        }

        export interface TabsGroupsContentGroup {

            /** When isMobileOnly is true,its shows in mobile toolbar.isResponsive should be true for using this property.
             * @Default {false}
             */
            isMobileOnly?: boolean;

            /** Specifies the Syncfusion button members, events by using this buttonSettings.
             * @Default {Object}
             */
            buttonSettings?: any;

            /** It is used to set the count of gallery contents in a row.
             * @Default {null}
             */
            columns?: number;

            /** Specifies the custom items such as div, table, controls as custom controls with the type &quot;ej.Ribbon.Type.Custom&quot; in the groups.
             * @Default {null}
             */
            contentID?: string;

            /** Specifies the CSS class property to apply styles to the button, split, dropdown controls in the groups.
             * @Default {null}
             */
            cssClass?: string;

            /** Specifies the Syncfusion button and menu as gallery extra items.
             * @Default {Array}
             */
            customGalleryItems?: TabsGroupsContentGroupsCustomGalleryItem[];

            /** Provides custom tooltip for button, split button, dropdown list, toggle button, custom controls in the sub groups. Text and HTML support are also provided for title and content.
             * @Default {Object}
             */
            customToolTip?: TabsGroupsContentGroupsCustomToolTip;

            /** Specifies the Syncfusion dropdown list members, events by using this dropdownSettings.
             * @Default {Object}
             */
            dropdownSettings?: any;

            /** Specifies the separator to the control that is in row type group. The separator separates the control from the next control in the group. Set &quot;true&quot; to enable the
             * separator.
             * @Default {false}
             */
            enableSeparator?: boolean;

            /** Sets the count of gallery contents in a row, when the gallery is in expanded state.
             * @Default {null}
             */
            expandedColumns?: number;

            /** Defines each gallery content.
             * @Default {Array}
             */
            galleryItems?: TabsGroupsContentGroupsGalleryItem[];

            /** Specifies the Id for button, split button, dropdown list, toggle button, gallery, custom controls in the sub groups.
             * @Default {null}
             */
            id?: string;

            /** Specifies the size for button, split button controls. Set &quot;true&quot; for big size and &quot;false&quot; for small size.
             * @Default {null}
             */
            isBig?: boolean;

            /** Sets the height of each gallery content.
             * @Default {null}
             */
            itemHeight?: string|number;

            /** Sets the width of each gallery content.
             * @Default {null}
             */
            itemWidth?: string|number;

            /** Specifies the Syncfusion split button members, events by using this splitButtonSettings.
             * @Default {Object}
             */
            splitButtonSettings?: any;

            /** Specifies the text for button, split button, toggle button controls in the sub groups.
             * @Default {null}
             */
            text?: string;

            /** Specifies the Syncfusion toggle button members, events by using toggleButtonSettings.
             * @Default {Object}
             */
            toggleButtonSettings?: any;

            /** Specifies the tooltip for button, split button, dropdown list, toggle button, custom controls in the sub groups.
             * @Default {null}
             */
            toolTip?: string;

            /** To add,show and hide controls in Quick Access toolbar.
             * @Default {ej.Ribbon.QuickAccessMode.None}
             */
            quickAccessMode?: ej.Ribbon.QuickAccessMode|string;

            /** Specifies the type as &quot;ej.Ribbon.Type.Button&quot; or &quot;ej.Ribbon.Type.SplitButton&quot; or &quot;ej.Ribbon.Type.DropDownList&quot; or
             * &quot;ej.Ribbon.Type.ToggleButton&quot; or &quot;ej.Ribbon.Type.Custom&quot; or &quot;ej.Ribbon.Type.Gallery&quot; to render button, split, dropdown, toggle button, gallery,
             * custom controls.
             * @Default {ej.Ribbon.Type.Button}
             */
            type?: ej.Ribbon.Type|string;
        }

        export interface TabsGroupsContent {

            /** Specifies the height, width, type, isBig property to the controls in the group commonly.
             * @Default {Object}
             */
            defaults?: TabsGroupsContentDefaults;

            /** Specifies the controls such as Syncfusion button, split button, dropdown list, toggle button, gallery, custom controls in the subgroup of the ribbon tab .
             * @Default {Array}
             */
            groups?: TabsGroupsContentGroup[];
        }

        export interface TabsGroupsGroupExpanderSettings {

            /** Sets tooltip for the group expander of the group.
             * @Default {null}
             */
            toolTip?: string;

            /** Specifies the custom tooltip for group expander.Refer to ejRibbon#tabs-&gt;groups-&gt;content-&gt;groups-&gt;customToolTip for its inner properties.
             * @Default {Object}
             */
            customToolTip?: any;
        }

        export interface TabsGroup {

            /** Specifies the alignment of controls in the groups in 'row' type or 'column' type. Value for row type is &quot;ej.Ribbon.AlignType.Rows&quot; and for column type is
             * &quot;ej.Ribbon.alignType.columns&quot;.
             * @Default {ej.Ribbon.AlignType.Rows}
             */
            alignType?: ej.Ribbon.AlignType|string;

            /** Specifies the Syncfusion button, split button, dropdown list, toggle button, gallery, custom controls to the groups in the ribbon control.
             * @Default {Array}
             */
            content?: TabsGroupsContent[];

            /** Specifies the ID of custom items to be placed in the groups.
             * @Default {null}
             */
            contentID?: string;

            /** Specifies the HTML contents to place into the groups.
             * @Default {null}
             */
            customContent?: string;

            /** Specifies the group expander for groups in the ribbon control. Set &quot;true&quot; to enable the group expander.
             * @Default {false}
             */
            enableGroupExpander?: boolean;

            /** Sets custom setting to the groups in the ribbon control.
             * @Default {Object}
             */
            groupExpanderSettings?: TabsGroupsGroupExpanderSettings;

            /** Specifies the text to the groups in the ribbon control.
             * @Default {null}
             */
            text?: string;

            /** Specifies the custom items such as div, table, controls by using the &quot;custom&quot; type.
             * @Default {null}
             */
            type?: string;
        }

        export interface Tab {

            /** Specifies single group or multiple groups and its contents to each tab in the ribbon control.
             * @Default {Array}
             */
            groups?: TabsGroup[];

            /** Specifies the ID for each tab's content panel.
             * @Default {null}
             */
            id?: string;

            /** Specifies the text of the tab in the ribbon control.
             * @Default {null}
             */
            text?: string;
        }

        enum ItemType {

            ///To render the button for ribbon backstage pageâ€™s contents
            Button,

            ///To render the tab for ribbon backstage pageâ€™s contents
            Tab
        }


        enum ApplicationTabType {

            ///applicationTab display as menu
            Menu,

            ///applicationTab display as backstage
            Backstage
        }


        enum AlignType {

            ///To align the group content's in row
            Rows,

            ///To align group content's in columns
            Columns
        }


        enum CustomItemType {

            ///Specifies the button type in customGalleryItems
            Button,

            ///Specifies the menu type in customGalleryItems
            Menu
        }


        enum QuickAccessMode {

            ///Controls are hidden in Quick Access toolbar
            None,

            ///Add controls in toolBar
            ToolBar,

            ///Add controls in menu
            Menu
        }


        enum Type {

            ///Specifies the button control
            Button,

            ///Specifies the split button
            SplitButton,

            ///Specifies the dropDown
            DropDownList,

            ///To append external element's
            Custom,

            ///Specifies the toggle button
            ToggleButton,

            ///Specifies the ribbon gallery
            Gallery
        }

    }

    class Kanban extends ej.Widget {
        static fn: Kanban;
        constructor(element: JQuery | Element, options?: Kanban.Model);
        static Locale: any;
        model: Kanban.Model;
        defaults: Kanban.Model;

        /** Add or remove columns in Kanban columns collections.Default action is add.
         * @param {any[]|string} Pass array of columns or string of headerText to add/remove the column in Kanban
         * @param {any[]|string} Pass array of columns or string of key value to add/remove the column in Kanban
         * @param {string} optional Pass add/remove action to be performed. By default "add" action will perform
         * @returns {void}
         */
        columns(columndetails: any[]|string, keyvalue: any[]|string, action?: string): void;

        /** Destroy the Kanban widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** Refresh the Kanban with new data source.
         * @param {any[]} Pass new data source to the Kanban
         * @returns {void}
         */
        dataSource(datasource: any[]): void;

        /** toggleColumn based on the headerText in Kanban.
         * @param {any} Pass the header text of the column to get the corresponding column object
         * @returns {void}
         */
        toggleColumn(headerText: any): void;

        /** Expand or collapse the card based on the state of target &quot;div&quot;
         * @param {string|number} Pass the id of card to be toggle
         * @returns {void}
         */
        toggleCard(key: string|number): void;

        /** Used for get the names of all the visible column name collections in Kanban.
         * @returns {any[]}
         */
        getVisibleColumnNames(): any[];

        /** Get the scroller object of Kanban.
         * @returns {ej.Scroller}
         */
        getScrollObject(): ej.Scroller;

        /** Get the column details based on the given header text in Kanban.
         * @param {string} Pass the header text of the column to get the corresponding column object
         * @returns {string}
         */
        getColumnByHeaderText(headerText: string): string;

        /** Get the table details based on the given header table in Kanban.
         * @returns {string}
         */
        getHeaderTable(): string;

        /** Hide columns from the Kanban based on the header text
         * @param {any[]|string} you can pass either array of header text of various columns or a header text of a column to hide
         * @returns {void}
         */
        hideColumns(headerText: any[]|string): void;

        /** Print the Kanban Board
         * @returns {void}
         */
        print(): void;

        /** Refresh the template of the Kanban
         * @returns {void}
         */
        refreshTemplate(): void;

        /** Refresh the Kanban contents.The template refreshment is based on the argument passed along with this method
         * @param {boolean} optional When templateRefresh is set true, template and Kanban contents both are refreshed in Kanban else only Kanban content is refreshed
         * @returns {void}
         */
        refresh(templateRefresh?: boolean): void;

        /** Show columns in the Kanban based on the header text.
         * @param {any[]|string} You can pass either array of header text of various columns or a header text of a column to show
         * @returns {void}
         */
        showColumns(headerText: any[]|string): void;

        /** Update a card in Kanban control based on key and JSON data given.
         * @param {string} Pass the key field Name of the column
         * @param {any[]} Pass the edited JSON data of card need to be update.
         * @returns {void}
         */
        updateCard(key: string, data: any[]): void;

        KanbanSelection: Kanban.KanbanSelection;

        KanbanSwimlane: Kanban.KanbanSwimlane;

        KanbanFilter: Kanban.KanbanFilter;

        KanbanEdit: Kanban.KanbanEdit;
    }
    export namespace Kanban {

        export interface KanbanSelection {

            /** It is used to clear all the card selection.
             * @returns {void}
             */
            clear(): void;
        }

        export interface KanbanSwimlane {

            /** Expand all the swimlane rows in Kanban.
             * @returns {void}
             */
            expandAll(): void;

            /** Collapse all the swimlane rows in Kanban.
             * @returns {void}
             */
            collapseAll(): void;

            /** Expand or collapse the swimlane row based on the state of target &quot;div&quot;
             * @param {any} Pass the div object to toggleSwimlane row based on its row state
             * @returns {void}
             */
            toggle($div: any): void;
        }

        export interface KanbanFilter {

            /** Method used for send a clear search request to Kanban.
             * @returns {void}
             */
            clearSearch(): void;

            /** Send a search request to Kanban with specified string passed in it.
             * @param {string} Pass the string to search in Kanban card
             * @returns {void}
             */
            searchCards(searchString: string): void;

            /** Send a clear request to filter cards in the kanban.
             * @returns {void}
             */
            clearFilter(): void;

            /** Send a filtering request to cards in the kanban.
             * @returns {void}
             */
            filterCards(): void;
        }

        export interface KanbanEdit {

            /** Add a new card in Kanban control when allowAdding is set as true. If parameters are not given default dialog will be open.
             * @param {string} Pass the primary key field Name of the column
             * @param {any[]} Pass the edited JSON data of card need to be add.
             * @returns {void}
             */
            addCard(primaryKey: string, card: any[]): void;

            /** Send a cancel request of add/edit card in Kanban when allowEditing/allowAdding is set as true.
             * @returns {void}
             */
            cancelEdit(): void;

            /** Delete a card in Kanban control when allowAdding/allowEditing is set as true.
             * @param {string|number} Pass the key of card to be delete
             * @returns {void}
             */
            deleteCard(Key: string|number): void;

            /** Send a save request in Kanban when any card is in edit/new add card state and allowEditing/allowAdding is set as true.
             * @returns {void}
             */
            endEdit(): void;

            /** Send an edit card request in Kanban when allowEditing is set as true. Parameter will be HTML element or primary key
             * @param {any} Pass the div selected row element to be edited in Kanban
             * @returns {void}
             */
            startEdit($div: any): void;

            /** Method used for set validation to a field during editing.
             * @param {string} Specify the name of the column to set validation rules
             * @param {any} Specify the validation rules for the field
             * @returns {void}
             */
            setValidationToField(name: string, rules: any): void;
        }

        export interface Model {

            /** Gets or sets a value that indicates whether to enable allowDragAndDrop behavior on Kanban.
             * @Default {true}
             */
            allowDragAndDrop?: boolean;

            /** Gets or sets a value that indicates whether to enable drag and drop behavior between Kanban controls.
             * @Default {false}
             */
            allowExternalDragAndDrop?: boolean;

            /** To enable or disable the title of the card.
             * @Default {false}
             */
            allowTitle?: boolean;

            /** Customize the settings for swim lane.
             * @Default {Object}
             */
            swimlaneSettings?: SwimlaneSettings;

            /** To enable or disable the column expand /collapse.
             * @Default {false}
             */
            allowToggleColumn?: boolean;

            /** To enable Searching operation in Kanban.
             * @Default {false}
             */
            allowSearching?: boolean;

            /** To enable filtering behavior on Kanban.User can specify query in filterSettings collection after enabling allowFiltering.
             * @Default {false}
             */
            allowFiltering?: boolean;

            /** Gets or sets a value that indicates whether to enable allowSelection behavior on Kanban.User can select card and the selected card will be highlighted on Kanban.
             * @Default {true}
             */
            allowSelection?: boolean;

            /** Gets or sets a value that indicates whether to allow card hover actions.
             * @Default {true}
             */
            allowHover?: boolean;

            /** To allow keyboard navigation actions.
             * @Default {false}
             */
            allowKeyboardNavigation?: boolean;

            /** Gets or sets a value that indicates whether to enable the scrollbar in the Kanban and view the card by scroll through the Kanban manually.
             * @Default {false}
             */
            allowScrolling?: boolean;

            /** Gets or sets a value that indicates whether to enable printing option.
             * @Default {false}
             */
            allowPrinting?: boolean;

            /** Gets or sets an object that indicates whether to customize the context menu behavior of the Kanban.
             * @Default {Object}
             */
            contextMenuSettings?: ContextMenuSettings;

            /** Gets or sets an object that indicates to render the Kanban with specified columns.
             * @Default {Array}
             */
            columns?: Column[];

            /** Gets or sets an object that indicates whether to Customize the card settings.
             * @Default {Object}
             */
            cardSettings?: CardSettings;

            /** Gets or sets a value that indicates whether to add customToolbarItems within the toolbar to perform any action in the Kanban.
             * @Default {[]}
             */
            customToolbarItems?: CustomToolbarItem[];

            /** Gets or sets a value that indicates to render the Kanban with custom theme.
             */
            cssClass?: string;

            /** Gets or sets the data to render the Kanban with cards.
             * @Default {null}
             */
            dataSource?: any;

            /** To perform kanban functionalities with touch interaction.
             * @Default {true}
             */
            enableTouch?: boolean;

            /** Align content in the Kanban control align from right to left by setting the property as true.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** To show total count of cards in each column.
             * @Default {false}
             */
            enableTotalCount?: boolean;

            /** Get or sets an object that indicates whether to customize the editing behavior of the Kanban.
             * @Default {Object}
             */
            editSettings?: EditSettings;

            /** To customize field mappings for card , editing title and control key parameters
             * @Default {Object}
             */
            fields?: Fields;

            /** To map datasource field for column values mapping
             * @Default {null}
             */
            keyField?: string;

            /** When set to true, adapts the Kanban layout to fit the screen size of devices on which it renders.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Gets or sets a value that indicates whether to set the minimum width of the responsive Kanban while isResponsive property is true.
             * @Default {0}
             */
            minWidth?: number;

            /** To customize the filtering behavior based on queries given.
             * @Default {Array}
             */
            filterSettings?: FilterSetting[];

            /** ej Query to query database of Kanban.
             * @Default {null}
             */
            query?: any;

            /** To change the key in keyboard interaction to Kanban control.
             * @Default {null}
             */
            keySettings?: any;

            /** Gets or sets an object that indicates whether to customize the scrolling behavior of the Kanban.
             * @Default {Object}
             */
            scrollSettings?: ScrollSettings;

            /** To customize the searching behavior of the Kanban.
             * @Default {Object}
             */
            searchSettings?: SearchSettings;

            /** To allow customize selection type. Accepting types are &quot;single&quot; and &quot;multiple&quot;.
             * @Default {ej.Kanban.SelectionType.Single}
             */
            selectionType?: ej.Kanban.SelectionType|string;

            /** Gets or sets an object that indicates to managing the collection of stacked header rows for the Kanban.
             * @Default {Array}
             */
            stackedHeaderRows?: StackedHeaderRow[];

            /** The tooltip allows to display card details in a tooltip while hovering on it.
             */
            tooltipSettings?: TooltipSettings;

            /** Gets or sets an object that indicates to render the Kanban with specified workflows.
             * @Default {Array}
             */
            workflows?: Workflow[];

            /** Gets or sets a value that indicates whether to customizing the user interface (UI) as locale-specific in order to display regional data i.e. in a language and culture specific to
             * a particular country or region.
             * @Default {en-US}
             */
            locale?: string;

            /** Gets or sets a value that indicates whether to render kanban columns using without data source.
             * @Default {false}
             */
            showColumnWhenEmpty?: boolean;

            /** Triggered for every Kanban action before its starts.
             */
            actionBegin?(e: ActionBeginEventArgs): void;

            /** Triggered for every Kanban action success event.
             */
            actionComplete?(e: ActionCompleteEventArgs): void;

            /** Triggered for every Kanban action server failure event.
             */
            actionFailure?(e: ActionFailureEventArgs): void;

            /** Triggered before the task is going to be edited.
             */
            beginEdit?(e: BeginEditEventArgs): void;

            /** Triggered before the card is selected.
             */
            beforeCardSelect?(e: BeforeCardSelectEventArgs): void;

            /** Trigger after the card is clicked.
             */
            cardClick?(e: CardClickEventArgs): void;

            /** Triggered when the card is being dragged.
             */
            cardDrag?(e: CardDragEventArgs): void;

            /** Triggered when card dragging start.
             */
            cardDragStart?(e: CardDragStartEventArgs): void;

            /** Triggered when card dragging stops.
             */
            cardDragStop?(e: CardDragStopEventArgs): void;

            /** Triggered when the card is Dropped.
             */
            cardDrop?(e: CardDropEventArgs): void;

            /** Triggered after the card is selected.
             */
            cardSelect?(e: CardSelectEventArgs): void;

            /** Triggered when card is double clicked.
             */
            cardDoubleClick?(e: CardDoubleClickEventArgs): void;

            /** Triggered before the card is selected.
             */
            cardSelecting?(e: CardSelectingEventArgs): void;

            /** Triggered when the Kanban is rendered completely
             */
            create?(e: CreateEventArgs): void;

            /** Triggers after the cell is clicked.
             */
            cellClick?(e: CellClickEventArgs): void;

            /** Triggered before the context menu is opened.
             */
            contextOpen?(e: ContextOpenEventArgs): void;

            /** Triggered when context menu item is clicked in Kanban
             */
            contextClick?(e: ContextClickEventArgs): void;

            /** Triggered the Kanban is bound with data during initial rendering.
             */
            dataBound?(e: DataBoundEventArgs): void;

            /** Triggered when Kanban going to destroy.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggered after the card is deleted.
             */
            endDelete?(e: EndDeleteEventArgs): void;

            /** Triggered after the card is edited.
             */
            endEdit?(e: EndEditEventArgs): void;

            /** Triggers after the header is clicked.
             */
            headerClick?(e: HeaderClickEventArgs): void;

            /** Triggered initial load.
             */
            load?(e: LoadEventArgs): void;

            /** Triggers before swim lane expand or collapse icon is clicked.
             */
            swimlaneClick?(e: SwimlaneClickEventArgs): void;

            /** Triggered every time a single card rendered request is made to access particular card information.
             */
            queryCellInfo?(e: QueryCellInfoEventArgs): void;

            /** Triggered when toolbar item is clicked in Kanban.
             */
            toolbarClick?(e: ToolbarClickEventArgs): void;
        }

        export interface ActionBeginEventArgs {

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the current action event type.
             */
            originalEventType?: string;

            /** Returns primary key value.
             */
            primaryKeyValue?: string;

            /** Returns request type.
             */
            requestType?: string;

            /** Returns the edited row index.
             */
            rowIndex?: number;

            /** Returns the card object (JSON).
             */
            data?: any;

            /** Returns current filtering object field name.
             */
            currentFilteringobject?: any;

            /** Returns filter details.
             */
            filterCollection?: any;
        }

        export interface ActionCompleteEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns request type.
             */
            requestType?: string;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns current action event type.
             */
            originalEventType?: string;

            /** Returns primary key.
             */
            primaryKey?: string;

            /** Returns primary key value.
             */
            primaryKeyValue?: string;

            /** Returns Kanban element.
             */
            target?: any;

            /** Returns the card object (JSON).
             */
            data?: any;

            /** Returns the selectedRow index.
             */
            selectedRow?: number;

            /** Returns current filtering column field name.
             */
            currentFilteringColumn?: string;

            /** Returns filter details.
             */
            filterCollection?: any;
        }

        export interface ActionFailureEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns request type.
             */
            requestType?: string;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the error return by server.
             */
            error?: any;

            /** Returns current action event type.
             */
            originalEventType?: string;

            /** Returns primary key value.
             */
            primaryKeyValue?: string;

            /** Returns Kanban element.
             */
            target?: any;

            /** Returns the card object (JSON).
             */
            data?: any;

            /** Returns current filtering column field name.
             */
            currentFilteringColumn?: string;

            /** Returns filter details.
             */
            filterCollection?: any;
        }

        export interface BeginEditEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns primary key value.
             */
            primaryKeyValue?: string;

            /** Returns begin edit data.
             */
            data?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface BeforeCardSelectEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the select cell index value.
             */
            cellIndex?: number;

            /** Returns the select card index value.
             */
            cardIndex?: number;

            /** Returns the select cell element
             */
            currentCell?: any;

            /** Returns the previously select the card element
             */
            previousCard?: any;

            /** Returns the previously select card indexes
             */
            previousRowcellindex?: any[];

            /** Returns the Target item.
             */
            Target?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns select card data.
             */
            data?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CardClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns the current card to the Kanban.
             */
            currentCard?: string;

            /** Returns Kanban element.
             */
            target?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the Header text of the column corresponding to the selected card.
             */
            columnName?: string;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CardDragEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns drag data.
             */
            data?: any;

            /** Returns drag start element.
             */
            dragtarget?: any;

            /** Returns dragged element.
             */
            draggedElement?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CardDragStartEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns card drag start data.
             */
            data?: any;

            /** Returns dragged element.
             */
            draggedElement?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns drag start element.
             */
            dragtarget?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CardDragStopEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns dragged element.
             */
            draggedElement?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns drag stop element.
             */
            droptarget?: any;

            /** Returns drag stop data.
             */
            data?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CardDropEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns dragged element.
             */
            draggedElement?: any;

            /** Returns previous parent of dragged element
             */
            draggedParent?: any;

            /** Returns dragged data.
             */
            data?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns drop element.
             */
            target?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CardSelectEventArgs {

            /** Returns the select cell index value.
             */
            cellIndex?: number;

            /** Returns the select card index value.
             */
            cardIndex?: number;

            /** Returns the select cell element
             */
            currentCell?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the previously select the card element
             */
            previousCard?: any;

            /** Returns the previously select card indexes
             */
            previousRowcellindex?: any[];

            /** Returns the current item.
             */
            currentTarget?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns select card data.
             */
            data?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CardDoubleClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current card object (JSON).
             */
            data?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CardSelectingEventArgs {

            /** Returns the selecting cell index value.
             */
            cellIndex?: number;

            /** Returns the selecting card index value.
             */
            cardIndex?: number;

            /** Returns the selecting cell element
             */
            currentCell?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the previously selecting the card element
             */
            previousCard?: any;

            /** Returns the previously rowcell is selecting card indexes
             */
            previousRowcellindex?: any[];

            /** Returns the current item.
             */
            currentTarget?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns added data.
             */
            data?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CreateEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CellClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the select cell index value.
             */
            cellIndex?: number;

            /** Returns the edited row index.
             */
            rowIndex?: number;
        }

        export interface ContextOpenEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the current item.
             */
            currentTarget?: any;

            /** Returns the status of contextmenu item which denotes its enabled state.
             */
            status?: boolean;

            /** Returns the target item.
             */
            target?: any;
        }

        export interface ContextClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the current item.
             */
            currentTarget?: any;

            /** Returns the status of contextmenu item which denotes its enabled state.
             */
            status?: boolean;

            /** Returns the target item.
             */
            target?: any;
        }

        export interface DataBoundEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Returns the kanban model.
             */
            model?: any;

            /** Returns deleted data.
             */
            data?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface EndDeleteEventArgs {

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns request type.
             */
            requestType?: string;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns deleted  data.
             */
            data?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Current action name
             */
            action?: string;
        }

        export interface EndEditEventArgs {

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns request type.
             */
            requestType?: string;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns modified data.
             */
            data?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Current Action name
             */
            action?: string;
        }

        export interface HeaderClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the select cell index value.
             */
            cellIndex?: number;

            /** Returns the column object.
             */
            columnData?: any;
        }

        export interface LoadEventArgs {

            /** Returns the kanban model.
             */
            model?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface SwimlaneClickEventArgs {

            /** Current Action name while swim lane clicked. Actions are "expand" or "collapse"
             */
            action?: string;

            /** Returns the kanban model.
             */
            model?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the swim lane group data's.
             */
            data?: any;

            /** Returns current swim lane row index.
             */
            rowIndex?: number;

            /** Returns current target element.
             */
            target?: any;
        }

        export interface QueryCellInfoEventArgs {

            /** Returns Kanban card.
             */
            card?: any;

            /** Returns Kanban card.
             */
            cell?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current row record object (JSON).
             */
            data?: any;

            /** Returns the column object.
             */
            column?: any;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ToolbarClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the current item.
             */
            currentTarget?: any;

            /** Returns the item id of that current element.
             */
            itemId?: string;

            /** Returns the item index of that current element.
             */
            itemIndex?: number;

            /** Returns the item name of that current element.
             */
            itemName?: string;

            /** Returns the item text of that current element.
             */
            itemText?: string;

            /** Returns the Kanban model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the toolbar object of the Kanban.
             */
            toolbarData?: any;
        }

        export interface SwimlaneSettingsHeader {

            /** Gets or sets a value that indicates to render the Kanban with specified swimlane header text.
             * @Default {null}
             */
            text?: string;

            /** Gets or sets a value that indicates to render the Kanban with specified swimlane header key.
             * @Default {null}
             */
            key?: string;
        }

        export interface SwimlaneSettingsUnassignedGroup {

            /** To enable or disable unassigned category change with swim lane key values.
             * @Default {true}
             */
            enable?: boolean;

            /** To set the user defined values which are need to categorized as unassigned category swim lane groups.
             * @Default {[null,undefined,]}
             */
            keys?: any[];
        }

        export interface SwimlaneSettings {

            /** To enable or disable items count in swim lane.
             * @Default {true}
             */
            showCount?: boolean;

            /** To enable or disable DragAndDrop across swim lane.
             * @Default {false}
             */
            allowDragAndDrop?: boolean;

            /** To enable or disable empty swimlane on Kanban board.  It is used to shown empty swimlane when no data's present on headers key mapping value.
             * @Default {false}
             */
            showEmptySwimlane?: boolean;

            /** Gets or sets an object that indicates to render the swimlane rows with specified swimlane headers.
             * @Default {[]}
             */
            headers?: SwimlaneSettingsHeader[];

            /** Customize the settings for unassigned category of swim lane.
             * @Default {Object}
             */
            unassignedGroup?: SwimlaneSettingsUnassignedGroup;
        }

        export interface ContextMenuSettingsCustomMenuItem {

            /** Its sets target element to custom context menu item.
             * @Default {ej.Kanban.Target.All}
             */
            target?: ej.Kanban.Target|string;

            /** Gets the display name to custom menu item.
             * @Default {null}
             */
            text?: string;

            /** Gets the template to render custom context menu item.
             * @Default {null}
             */
            template?: string;
        }

        export interface ContextMenuSettings {

            /** To enable context menu.All default context menu will show.
             * @Default {false}
             */
            enable?: boolean;

            /** Gets or sets a value that indicates the list of items needs to be disable from default context menu items.
             * @Default {Array}
             */
            disableDefaultItems?: any[];

            /** Its used to add specific default context menu items.
             * @Default {Array}
             */
            menuItems?: any[];

            /** Gets or sets a value that indicates whether to add custom contextMenu items.
             * @Default {Array}
             */
            customMenuItems?: ContextMenuSettingsCustomMenuItem[];
        }

        export interface ColumnsTotalCount {

            /** To customize the totalCount text properties.
             * @Default {null}
             */
            text?: string;
        }

        export interface ColumnsConstraints {

            /** It is used to specify the type of constraints as column or swimlane.
             * @Default {null}
             */
            type?: string;

            /** It is used to specify the minimum amount of card in particular column cell or swimlane cell can hold.
             * @Default {null}
             */
            min?: number;

            /** It is used to specify the maximum amount of card in particular column cell or swimlane cell can hold.
             * @Default {null}
             */
            max?: number;
        }

        export interface Column {

            /** Gets or sets an object that indicates to render the Kanban with specified columns header text.
             * @Default {null}
             */
            headerText?: string;

            /** To customize the totalCount properties.
             * @Default {Object}
             */
            totalCount?: ColumnsTotalCount;

            /** Gets or sets an object that indicates to render the Kanban with specified columns key.
             * @Default {null}
             */
            key?: string|number;

            /** To enable/disable allowDrop for specific column wise.
             * @Default {true}
             */
            allowDrop?: boolean;

            /** To enable/disable allowDrag for specific column wise.
             * @Default {true}
             */
            allowDrag?: boolean;

            /** To set column collapse or expand state
             * @Default {false}
             */
            isCollapsed?: boolean;

            /** To customize the column level constraints with minimum ,maximum limit validation.
             * @Default {Object}
             */
            constraints?: ColumnsConstraints;

            /** Gets or sets a value that indicates to add the template within the header element.
             * @Default {null}
             */
            headerTemplate?: string;

            /** Gets or sets an object that indicates to render the Kanban with specified columns width.
             * @Default {null}
             */
            width?: string|number;

            /** Gets or sets an object that indicates to set specific column visibility.
             * @Default {true}
             */
            visible?: boolean;

            /** Gets or sets an object that indicates whether to show add new button.
             * @Default {false}
             */
            showAddButton?: boolean;
        }

        export interface CardSettings {

            /** Gets or sets a value that indicates to add the template for card .
             * @Default {null}
             */
            template?: string;

            /** To customize the card border color based on assigned task. Colors and corresponding values defined here will be mapped with colorField mapped data source column.
             * @Default {Object}
             */
            colorMapping?: any;

            /** This specifies the Kanban card to drop into particular target element.
             */
            externalDropTarget?: string;
        }

        export interface CustomToolbarItem {

            /** Gets the template to render customToolbarItems.
             * @Default {null}
             */
            template?: string;
        }

        export interface EditSettingsEditItem {

            /** It is used to map editing field from the data source.
             * @Default {null}
             */
            field?: string;

            /** It is used to set the particular editType in the card for editing.
             * @Default {ej.Kanban.EditingType.String}
             */
            editType?: ej.Kanban.EditingType|string;

            /** Gets or sets a value that indicates to define constraints for saving data to the database.
             * @Default {Object}
             */
            validationRules?: any;

            /** It is used to set the particular editparams in the card for editing.
             * @Default {Object}
             */
            editParams?: any;

            /** It is used to specify defaultValue for the fields while adding new card.
             * @Default {null}
             */
            defaultValue?: string|number;
        }

        export interface EditSettings {

            /** Gets or sets a value that indicates whether to enable the editing action in cards of Kanban.
             * @Default {false}
             */
            allowEditing?: boolean;

            /** Gets or sets a value that indicates whether to enable the adding action in cards behavior on Kanban.
             * @Default {false}
             */
            allowAdding?: boolean;

            /** This specifies the id of the template which is require to be edited using the Dialog Box.
             * @Default {null}
             */
            dialogTemplate?: string;

            /** Get or sets an object that indicates whether to customize the editMode of the Kanban.
             * @Default {ej.Kanban.EditMode.Dialog}
             */
            editMode?: ej.Kanban.EditMode|string;

            /** Get or sets an object that indicates whether to customize the editing fields of Kanban card.
             * @Default {Array}
             */
            editItems?: EditSettingsEditItem[];

            /** This specifies the id of the template which is require to be edited using the External edit form.
             * @Default {null}
             */
            externalFormTemplate?: string;

            /** This specifies to set the position of an External edit form either in the right or bottom of the Kanban.
             * @Default {ej.Kanban.FormPosition.Bottom}
             */
            formPosition?: ej.Kanban.FormPosition|string;
        }

        export interface FieldsCollapsibleCards {

            /** It is used to specify the collapsible card's field mapping.
             * @Default {null}
             */
            field?: string;

            /** It is used to specify the collapsible card's key mapping which is available in datasource value of field mapped in collapsibleCards.field.
             * @Default {null}
             */
            key?: string;
        }

        export interface Fields {

            /** The primarykey field is mapped to data source field. And this will used for Drag and drop and editing mainly.
             * @Default {null}
             */
            primaryKey?: string;

            /** To enable swimlane grouping based on the given key field from datasource mapping.
             * @Default {null}
             */
            swimlaneKey?: string;

            /** Priority field has been mapped data source field to maintain cards priority.
             * @Default {null}
             */
            priority?: string;

            /** Content field has been Mapped into card text.
             * @Default {null}
             */
            content?: string;

            /** Tag field has been Mapped into card tag.
             * @Default {null}
             */
            tag?: string;

            /** Title field has been Mapped to field in datasource for title content. If title field specified , card expand/collapse will be enabled with header and content section.
             * @Default {null}
             */
            title?: string;

            /** To customize the card has been Mapped into card color field.
             * @Default {null}
             */
            color?: string;

            /** ImageUrl field has been Mapped into card image.
             * @Default {null}
             */
            imageUrl?: string;

            /** Get or sets an object that indicates the options to map the cards to the collapsible area.
             * @Default {Object}
             */
            collapsibleCards?: FieldsCollapsibleCards;
        }

        export interface FilterSetting {

            /** Gets or sets an object of display name to filter queries.
             * @Default {null}
             */
            text?: string;

            /** Gets or sets an object that Queries to perform filtering
             * @Default {Object}
             */
            query?: any;

            /** Gets or sets an object of tooltip to filter buttons.
             * @Default {null}
             */
            description?: string;
        }

        export interface ScrollSettings {

            /** Gets or sets an object that indicates to render the Kanban with specified scroll height.
             * @Default {0}
             */
            height?: string|number;

            /** Gets or sets an object that indicates to render the Kanban with specified scroll width.
             * @Default {auto}
             */
            width?: string|number;

            /** To allow the Kanban to freeze particular swimlane at the time of scrolling , until scroll reaches next swimlane and it continues.
             * @Default {false}
             */
            allowFreezeSwimlane?: boolean;
        }

        export interface SearchSettings {

            /** To customize the fields the searching operation can be perform.
             * @Default {Array}
             */
            fields?: any[];

            /** To customize the searching string.
             */
            key?: string;

            /** To customize the operator based on searching.
             * @Default {contains}
             */
            operator?: string;

            /** To customize the ignore case based on searching.
             * @Default {true}
             */
            ignoreCase?: boolean;
        }

        export interface StackedHeaderRowsStackedHeaderColumn {

            /** Gets or sets a value that indicates the headerText for the particular stacked header column.
             * @Default {null}
             */
            headerText?: string;

            /** Gets or sets a value that indicates the column for the particular stacked header column.
             * @Default {null}
             */
            column?: string;
        }

        export interface StackedHeaderRow {

            /** Gets or sets a value that indicates whether to add stacked header columns into the stacked header rows.
             * @Default {Array}
             */
            stackedHeaderColumns?: StackedHeaderRowsStackedHeaderColumn[];
        }

        export interface TooltipSettings {

            /** To enable or disable the tooltip display.
             * @Default {false}
             */
            enable?: boolean;

            /** To customize the tooltip display based on your requirements.
             * @Default {null}
             */
            template?: string;
        }

        export interface Workflow {

            /** Gets or sets an object that indicates to render the Kanban with specified workflows key.
             * @Default {null}
             */
            key?: string|number;

            /** Gets or sets an object that indicates to render the Kanban with specified workflows allowed Transitions.
             * @Default {null}
             */
            allowedTransitions?: string;
        }

        enum Target {

            ///Sets context menu to Kanban header
            Header,

            ///Sets context menu to Kanban content
            Content,

            ///Sets context menu to Kanban card
            Card,

            ///Sets context menu to Kanban
            All
        }


        enum EditMode {

            ///Creates Kanban with editMode as Dialog
            Dialog,

            ///Creates Kanban with editMode as DialogTemplate
            DialogTemplate,

            ///Creates Kanban with editMode as ExternalForm
            ExternalForm,

            ///Creates Kanban with editMode as ExternalFormTemplate
            ExternalFormTemplate
        }


        enum EditingType {

            ///Allows to set edit type as string edit type
            String,

            ///Allows to set edit type as numeric edit type
            Numeric,

            ///Allows to set edit type as drop down edit type
            Dropdown,

            ///Allows to set edit type as date picker edit type
            DatePicker,

            ///Allows to set edit type as date time picker edit type
            DateTimePicker,

            ///Allows to set edit type as text area edit type
            TextArea,

            ///Allows to set edit type as RTE edit type
            RTE
        }


        enum FormPosition {

            ///Form position is bottom.
            Bottom,

            ///Form position is right.
            Right
        }


        enum SelectionType {

            ///Support for Single selection in Kanban
            Single,

            ///Support for multiple selections in Kanban
            Multiple
        }

    }

    class Rotator extends ej.Widget {
        static fn: Rotator;
        constructor(element: JQuery | Element, options?: Rotator.Model);
        static Locale: any;
        model: Rotator.Model;
        defaults: Rotator.Model;

        /** Disables the Rotator control.
         * @returns {void}
         */
        disable(): void;

        /** Enables the Rotator control.
         * @returns {void}
         */
        enable(): void;

        /** This method is used to get the current slide index.
         * @returns {number}
         */
        getIndex(): number;

        /** This method is used to move a slide to the specified index.
         * @param {number} index of an slide
         * @returns {void}
         */
        gotoIndex(index: number): void;

        /** This method is used to pause autoplay.
         * @returns {void}
         */
        pause(): void;

        /** This method is used to move slides continuously (or start autoplay) in the specified autoplay direction.
         * @returns {void}
         */
        play(): void;

        /** This method is used to move to the next slide from the current slide. If the current slide is the last slide, then the first slide will be treated as the next slide.
         * @returns {void}
         */
        slideNext(): void;

        /** This method is used to move to the previous slide from the current slide. If the current slide is the first slide, then the last slide will be treated as the previous slide.
         * @returns {void}
         */
        slidePrevious(): void;

        /** This method is used to update/modify the slide content of template rotator by using id based on index value.
         * @param {number} index of an slide
         * @param {string} id of a new updated slide
         * @returns {void}
         */
        updateTemplateById(index: number, id: string): void;
    }
    export namespace Rotator {

        export interface Model {

            /** Turns on keyboard interaction with the Rotator items. You must set this property to true to access the following keyboard shortcuts:
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** Sets the animationSpeed of slide transition.
             * @Default {600}
             */
            animationSpeed?: string|number;

            /** Specifies the animationType type for the Rotator Item. animationType options include slide, fastSlide, slowSlide, and other custom easing animationTypes.
             * @Default {slide}
             */
            animationType?: string;

            /** Enables the circular mode item rotation.
             * @Default {true}
             */
            circularMode?: boolean;

            /** Specify the CSS class to Rotator to achieve custom theme.
             */
            cssClass?: string;

            /** Specify the list of data which contains a set of data fields. Each data value is used to render an item for the Rotator.
             * @Default {null}
             */
            dataSource?: any;

            /** Sets the delay between the Rotator Items move after the slide transition.
             * @Default {500}
             */
            delay?: number;

            /** Specifies the number of Rotator Items to be displayed.
             * @Default {1}
             */
            displayItemsCount?: string|number;

            /** Rotates the Rotator Items continuously without user interference.
             * @Default {false}
             */
            enableAutoPlay?: boolean;

            /** Enables or disables the Rotator control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specifies right to left transition of slides.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Defines mapping fields for the data items of the Rotator.
             * @Default {null}
             */
            fields?: Fields;

            /** Sets the space between the Rotator Items.
             */
            frameSpace?: string|number;

            /** Resizes the Rotator when the browser is resized.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Specifies the number of Rotator Items to navigate on a single click (next/previous/play buttons). The navigateSteps property value must be less than or equal to the
             * displayItemsCount property value.
             * @Default {1}
             */
            navigateSteps?: string|number;

            /** Specifies the orientation for the Rotator control, that is, whether it must be rendered horizontally or vertically. See Orientation
             * @Default {ej.Orientation.Horizontal}
             */
            orientation?: ej.Orientation|string;

            /** Specifies the position of the showPager in the Rotator Item. See PagerPosition
             * @Default {outside}
             */
            pagerPosition?: string|ej.Rotator.PagerPosition;

            /** Retrieves data from remote data. This property is applicable only when a remote data source is used.
             * @Default {null}
             */
            query?: string;

            /** If the Rotator Item is an image, you can specify a caption for the Rotator Item. The caption text for each Rotator Item must be set by using the title attribute of the respective
             * tag. The caption cannot be displayed if multiple Rotator Items are present.
             * @Default {false}
             */
            showCaption?: boolean;

            /** Turns on or off the slide buttons (next and previous) in the Rotator Items. Slide buttons are used to navigate the Rotator Items.
             * @Default {true}
             */
            showNavigateButton?: boolean;

            /** Turns on or off the pager support in the Rotator control. The Pager is used to navigate the Rotator Items.
             * @Default {true}
             */
            showPager?: boolean;

            /** Enable play / pause button on rotator.
             * @Default {false}
             */
            showPlayButton?: boolean;

            /** Turns on or off thumbnail support in the Rotator control. Thumbnail is used to navigate between slides. Thumbnail supports only single slide transition You must specify the source
             * for thumbnail elements through the thumbnailSourceID property.
             * @Default {false}
             */
            showThumbnail?: boolean;

            /** Sets the height of a Rotator Item.
             */
            slideHeight?: string|number;

            /** Sets the width of a Rotator Item.
             */
            slideWidth?: string|number;

            /** Sets the index of the slide that must be displayed first.
             * @Default {0}
             */
            startIndex?: string|number;

            /** Pause the auto play while hover on the rotator content.
             * @Default {false}
             */
            stopOnHover?: boolean;

            /** The template to display the Rotator widget with customized appearance.
             * @Default {null}
             */
            template?: string;

            /** The templateId enables to bind multiple customized template items in Rotator.
             * @Default {null}
             */
            templateId?: any[];

            /** Specifies the source for thumbnail elements.
             * @Default {null}
             */
            thumbnailSourceID?: any;

            /** This event is fired when the Rotator slides are changed.
             */
            change?(e: ChangeEventArgs): void;

            /** This event is fired when the Rotator control is initialized.
             */
            create?(e: CreateEventArgs): void;

            /** This event is fired when the Rotator control is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** This event is fired when a pager is clicked.
             */
            pagerClick?(e: PagerClickEventArgs): void;

            /** This event is fired when enableAutoPlay is started.
             */
            start?(e: StartEventArgs): void;

            /** This event is fired when autoplay is stopped or paused.
             */
            stop?(e: StopEventArgs): void;

            /** This event is fired when a thumbnail pager is clicked.
             */
            thumbItemClick?(e: ThumbItemClickEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rotator model
             */
            model?: ej.Rotator.Model;

            /** returns the name of the event
             */
            type?: string;

            /** the current rotator id.
             */
            itemId?: string;

            /** returns the current slide index.
             */
            activeItemIndex?: number;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rotator model
             */
            model?: ej.Rotator.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rotator model
             */
            model?: ej.Rotator.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface PagerClickEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rotator model
             */
            model?: ej.Rotator.Model;

            /** returns the name of the event
             */
            type?: string;

            /** the current rotator id.
             */
            itemId?: string;

            /** returns the current slide index.
             */
            activeItemIndex?: number;
        }

        export interface StartEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rotator model
             */
            model?: ej.Rotator.Model;

            /** returns the name of the event
             */
            type?: string;

            /** the current rotator id.
             */
            itemId?: string;

            /** returns the current slide index.
             */
            activeItemIndex?: number;
        }

        export interface StopEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rotator model
             */
            model?: ej.Rotator.Model;

            /** returns the name of the event
             */
            type?: string;

            /** the current rotator id.
             */
            itemId?: string;

            /** returns the current slide index.
             */
            activeItemIndex?: number;
        }

        export interface ThumbItemClickEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the rotator model
             */
            model?: ej.Rotator.Model;

            /** returns the name of the event
             */
            type?: string;

            /** the current rotator id.
             */
            itemId?: string;

            /** returns the current slide index.
             */
            activeItemIndex?: number;
        }

        export interface Fields {

            /** Specifies a link for the image.
             */
            linkAttribute?: string;

            /** Specifies where to open a given link.
             */
            targetAttribute?: string;

            /** Specifies a caption for the image.
             */
            text?: string;

            /** Specifies a caption for the thumbnail image.
             */
            thumbnailText?: string;

            /** Specifies the URL for an thumbnail image.
             */
            thumbnailUrl?: string;

            /** Specifies the URL for an image.
             */
            url?: string;
        }

        enum PagerPosition {

            ///string
            BottomLeft,

            ///string
            BottomRight,

            ///string
            Outside,

            ///string
            TopCenter,

            ///string
            TopLeft,

            ///string
            TopRight
        }

    }

    class RTE extends ej.Widget {
        static fn: RTE;
        constructor(element: JQuery | Element, options?: RTE.Model);
        static Locale: any;
        model: RTE.Model;
        defaults: RTE.Model;

        /** Returns the range object.
         * @returns {any}
         */
        createRange(): any;

        /** Disables the RTE control.
         * @returns {void}
         */
        disable(): void;

        /** Disables the corresponding tool in the RTE ToolBar.
         * @returns {void}
         */
        disableToolbarItem(): void;

        /** Enables the RTE control.
         * @returns {void}
         */
        enable(): void;

        /** Enables the corresponding tool in the toolbar when the tool is disabled.
         * @returns {void}
         */
        enableToolbarItem(): void;

        /** Performs the action value based on the given command.
         * @param {string} Command Name.
         * @param {any} Content to be inserted as argument.
         * @param {boolean} Boolean value to specify whether the argument is textNode or not, this is optional.
         * @returns {void}
         */
        executeCommand(cmdName: string, args: any, textnodeType?: boolean): void;

        /** Focuses the RTE control.
         * @returns {void}
         */
        focus(): void;

        /** Gets the command status of the selected text based on the given comment in the RTE control.
         * @returns {boolean}
         */
        getCommandStatus(): boolean;

        /** Gets the Document from the RTE control.
         * @returns {Document}
         */
        getDocument(): Document;

        /** Gets the HTML string from the RTE control.
         * @returns {HTMLElement}
         */
        getHtml(): HTMLElement;

        /** Gets the selected HTML string from the RTE control.
         * @returns {HTMLElement}
         */
        getSelectedHtml(): HTMLElement;

        /** Gets the content as string from the RTE control.
         * @returns {string}
         */
        getText(): string;

        /** Hides the RTE control.
         * @returns {void}
         */
        hide(): void;

        /** Inserts new item to the target contextmenu node.
         * @returns {void}
         */
        insertMenuOption(): void;

        /** Add a table column at the right or left of the specified cell
         * @param {boolean} If itâ€™s true, add a column at the left of the cell, otherwise add a column at the right of the cell
         * @param {JQuery} Column will be added based on the given cell element
         * @returns {HTMLElement}
         */
        insertColumn(before?: boolean, cell?: JQuery): HTMLElement;

        /** To add a table row below or above the specified cell.
         * @param {boolean} If itâ€™s true, add a row before the cell, otherwise add a row after the cell
         * @param {JQuery} Row will be added based on the given cell element
         * @returns {HTMLElement}
         */
        insertRow(before?: boolean, cell?: JQuery): HTMLElement;

        /** This method helps to insert/paste the content at the current cursor (caret) position or the selected content to be replaced with our text by passing the value as parameter to the
         * pasteContent method in the Editor.
         * @param {string} paste content
         * @returns {void}
         */
        pasteContent(html: string): void;

        /** Refreshes the RTE control.
         * @returns {void}
         */
        refresh(): void;

        /** Removes the specified table column.
         * @param {JQuery} Remove the given column element
         * @returns {void}
         */
        removeColumn(cell?: JQuery): void;

        /** Removes the specified table row.
         * @param {JQuery} Remove the given row element
         * @returns {void}
         */
        removeRow(cell?: JQuery): void;

        /** Deletes the specified table.
         * @param {JQuery} Remove the given table
         * @returns {void}
         */
        removeTable(table?: JQuery): void;

        /** Removes the target menu item from the RTE contextmenu.
         * @returns {void}
         */
        removeMenuOption(): void;

        /** Removes the given tool from the RTE Toolbar.
         * @returns {void}
         */
        removeToolbarItem(): void;

        /** Selects all the contents within the RTE.
         * @returns {void}
         */
        selectAll(): void;

        /** Selects the contents in the given range.
         * @returns {void}
         */
        selectRange(): void;

        /** Sets the color picker model type rendered initially in the RTE control.
         * @returns {void}
         */
        setColorPickerType(): void;

        /** Sets the HTML string from the RTE control.
         * @returns {void}
         */
        setHtml(): void;

        /** Displays the RTE control.
         * @returns {void}
         */
        show(): void;
    }
    export namespace RTE {

        export interface Model {

            /** Enables/disables the editing of the content.
             * @Default {True}
             */
            allowEditing?: boolean;

            /** RTE control can be accessed through the keyboard shortcut keys.
             * @Default {True}
             */
            allowKeyboardNavigation?: boolean;

            /** When the property is set to true, it focuses the RTE at the time of rendering.
             * @Default {false}
             */
            autoFocus?: boolean;

            /** Based on the content size, its height is adjusted instead of adding the scrollbar.
             * @Default {false}
             */
            autoHeight?: boolean;

            /** This API holds configuration setting for paste cleanup behavior.
             * @Default {{ listConversion: false, cleanCSS: false,	removeStyles: false, cleanElements: false }}
             */
            pasteCleanupSettings?: PasteCleanupSettings;

            /** Sets the colorCode to display the color of the fontColor and backgroundColor in the font tools of the RTE.
             * @Default {[000000, FFFFFF, C4C4C4, ADADAD, 595959, 262626, 4f81bd, dbe5f1, b8cce4, 95b3d7, 366092, 244061, c0504d, f2dcdb, e5b9b7, d99694, 953734,632423, 9bbb59, ebf1dd, d7e3bc,
             * c3d69b, 76923c, 4f6128, 8064a2, e5e0ec, ccc1d9, b2a2c7, 5f497a, 3f3151, f79646, fdeada, fbd5b5, fac08f,e36c09, 974806]}
             */
            colorCode?: any;

            /** The number of columns given are rendered in the color palate popup.
             * @Default {6}
             */
            colorPaletteColumns?: number;

            /** The number of rows given are rendered in the color palate popup.
             * @Default {6}
             */
            colorPaletteRows?: number;

            /** Sets the root class for the RTE theme. This cssClass API helps the usage of custom skinning option for the RTE control by including this root class in CSS.
             */
            cssClass?: string;

            /** Enables/disables the RTE controlâ€™s accessibility or interaction.
             * @Default {True}
             */
            enabled?: boolean;

            /** When the property is set to true, it returns the encrypted text.
             * @Default {false}
             */
            enableHtmlEncode?: boolean;

            /** Maintain the values of the RTE after page reload.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Shows the resize icon and enables the resize option in the RTE.
             * @Default {True}
             */
            enableResize?: boolean;

            /** Shows the RTE in the RTL direction.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Formats the contents based on the XHTML rules.
             * @Default {false}
             */
            enableXHTML?: boolean;

            /** Enables the tab key action with the RichTextEditor content.
             * @Default {True}
             */
            enableTabKeyNavigation?: boolean;

            /** This API allows to enable url and fileName for pdf export.
             * @Default {null}
             */
            exportToPdfSettings?: ExportToPdfSettings;

            /** This API allows to enable url and fileName for word export.
             * @Default {null}
             */
            exportToWordSettings?: ExportToWordSettings;

            /** Load the external CSS file inside Iframe.
             * @Default {null}
             */
            externalCSS?: string;

            /** This API allows to enable the file browser support in the RTE control to browse, create, delete and upload the files in the specified current directory.
             * @Default {null}
             */
            fileBrowser?: FileBrowser;

            /** Sets the fontName in the RTE.
             * @Default {{text: Segoe UI, value: Segoe UI },{text: Arial, value: Arial,Helvetica,sans-serif },{text: Courier New, value: Courier New,Courier,Monospace },{text: Georgia, value:
             * Georgia,serif },{text: Impact, value: Impact,Charcoal,sans-serif },{text: Lucida Console, value: Lucida Console,Monaco,Monospace },{text: Tahoma, value: Tahoma,Geneva,sans-serif
             * },{text: Times New Roman, value: Times New Roman },{text: Trebuchet MS, value: Trebuchet MS,Helvetica,sans-serif },{text: Verdana, value: Verdana,Geneva,sans-serif}}
             */
            fontName?: any;

            /** Sets the fontSize in the RTE.
             * @Default {{ text: 1, value: 1 },{ text: 2 (10pt), value: 2 },{ text: 3 (12pt), value: 3 },{ text: 4 (14pt), value: 4 },{ text: 5 (18pt), value: 5 },{ text: 6 (24pt), value: 6 },{
             * text: 7 (36pt), value: 7 }}
             */
            fontSize?: any;

            /** Sets the format in the RTE.
             * @Default {{ text: Paragraph, value: &lt;p&gt;, spriteCssClass: e-paragraph },{ text: Quotation, value: &lt;blockquote&gt;, spriteCssClass: e-quotation },{ text: Heading 1, value:
             * &lt;h1&gt;, spriteCssClass: e-h1 },{ text: Heading 2, value: &lt;h2&gt;, spriteCssClass: e-h2 },{ text: Heading 3, value: &lt;h3&gt;, spriteCssClass: e-h3 },{ text: Heading 4,
             * value: &lt;h4&gt;, spriteCssClass: e-h4 },{ text: Heading 5, value: &lt;h5&gt;, spriteCssClass: e-h5 },{ text: Heading 6, value: &lt;h6&gt;, spriteCssClass: e-h6}}
             */
            format?: string;

            /** Defines the height of the RTE textbox.
             * @Default {370}
             */
            height?: string|number;

            /** Specifies the HTML Attributes of the ejRTE.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Sets the given attributes to the iframe body element.
             * @Default {{}}
             */
            iframeAttributes?: any;

            /** This API allows the image browser to support in the RTE control to browse, create, delete, and upload the image files to the specified current directory.
             * @Default {null}
             */
            imageBrowser?: ImageBrowser;

            /** This API allows to enable the url for connecting to RTE import.
             * @Default {null}
             */
            importSettings?: ImportSettings;

            /** Enables/disables responsive support for the RTE control toolbar items during the window resizing time.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Sets the culture in the RTE when you set the localization values are needs to be assigned to the corresponding text as follows.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the maximum height for the RTE outer wrapper element.
             * @Default {null}
             */
            maxHeight?: string|number;

            /** Sets the maximum length for the RTE outer wrapper element.
             * @Default {7000}
             */
            maxLength?: number;

            /** Sets the maximum width for the RTE outer wrapper element.
             * @Default {null}
             */
            maxWidth?: string|number;

            /** Sets the minimum height for the RTE outer wrapper element.
             * @Default {280}
             */
            minHeight?: string|number;

            /** Sets the minimum width for the RTE outer wrapper element.
             * @Default {400}
             */
            minWidth?: string|number;

            /** Sets the name in the RTE. When the name value is not initialized, the ID value is assigned to the name.
             */
            name?: string;

            /** Shows ClearAll icon in the RTE footer.
             * @Default {false}
             */
            showClearAll?: boolean;

            /** Shows the clear format in the RTE footer.
             * @Default {true}
             */
            showClearFormat?: boolean;

            /** Shows the Custom Table in the RTE.
             * @Default {True}
             */
            showCustomTable?: boolean;

            /** The showContextMenu property helps to enable custom context menu within editor area.
             * @Default {True}
             */
            showContextMenu?: boolean;

            /** This API is used to set the default dimensions for the image and video. When this property is set to true, the image and video dialog displays the dimension option.
             * @Default {false}
             */
            showDimensions?: boolean;

            /** Shows the FontOption in the RTE.
             * @Default {True}
             */
            showFontOption?: boolean;

            /** Shows footer in the RTE. When the footer is enabled, it displays the HTML tag, word Count, character count, clear format, resize icon and clear all the content icons, by default.
             * @Default {false}
             */
            showFooter?: boolean;

            /** Shows the HtmlSource in the RTE footer.
             * @Default {false}
             */
            showHtmlSource?: boolean;

            /** When the cursor is placed or when the text is selected in the RTE, it displays the tag info in the footer.
             * @Default {True}
             */
            showHtmlTagInfo?: boolean;

            /** Shows the toolbar in the RTE.
             * @Default {True}
             */
            showToolbar?: boolean;

            /** Counts the total characters and displays it in the RTE footer.
             * @Default {True}
             */
            showCharCount?: boolean;

            /** Enables or disables rounded corner UI look for RTE.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Counts the total words and displays it in the RTE footer.
             * @Default {True}
             */
            showWordCount?: boolean;

            /** The given number of columns render the insert table pop.
             * @Default {10}
             */
            tableColumns?: number;

            /** The given number of rows render the insert table pop.
             * @Default {8}
             */
            tableRows?: number;

            /** Sets the tools in the RTE and gets the inner display order of the corresponding group element. Tools are dependent on the toolsList property.
             * @Default {formatStyle: [format],style: [bold, italic, underline, strikethrough],alignment: [justifyLeft, justifyCenter, justifyRight, justifyFull],lists: [unorderedList,
             * orderedList],indenting: [outdent, indent],doAction: [undo, redo],links: [createLink,removeLink],images: [image],media: [video],tables: [createTable, addRowAbove, addRowBelow,
             * addColumnLeft, addColumnRight, deleteRow, deleteColumn, deleteTable]],view:[â€œfullScreenâ€,zoomIn,zoomOut],print:[print]}
             */
            tools?: Tools;

            /** Specifies the list of groups and order of those groups displayed in the RTE toolbar.  The toolsList property is used to get the root group order and tools property is used to get
             * the inner order of the corresponding groups displayed. When the value is not specified, it gets its default display order and tools.
             * @Default {[formatStyle, font, style, effects, alignment, lists, indenting, clipboard, doAction, clear, links, images, media, tables, casing,view, customTools,print,edit]}
             */
            toolsList?: any[];

            /** Specifies the overflow mode for RTE responsive toolbar
             * @Default {Popup}
             */
            toolbarOverflowMode?: ej.RTE.ToolbarOverflowMode|string;

            /** Display the hints for the tools in the Toolbar.
             * @Default {{ associate: mouseenter, showShadow: true, position: { stem: { horizontal: left, vertical: top }  }, tip: { size: { width: 5, height: 5 }, isBalloon: false }}
             */
            tooltipSettings?: any;

            /** Gets the undo stack limit.
             * @Default {50}
             */
            undoStackLimit?: number;

            /** The given string value is displayed in the editable area.
             * @Default {null}
             */
            value?: string;

            /** Sets the jQuery validation rules to the Rich Text Editor.
             * @Default {null}
             */
            validationRules?: any;

            /** Sets the jQuery validation error message to the Rich Text Editor.
             * @Default {null}
             */
            validationMessage?: any;

            /** Defines the width of the RTE textbox.
             * @Default {786}
             */
            width?: string|number;

            /** Increases and decreases the contents zoom range in percentage
             * @Default {0.05}
             */
            zoomStep?: string|number;

            /** Fires when changed successfully.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires when the RTE is created successfully
             */
            create?(e: CreateEventArgs): void;

            /** Fires when mouse click on menu items.
             */
            contextMenuClick?(e: ContextMenuClickEventArgs): void;

            /** Fires before the RTE is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when the commands are executed successfully.
             */
            execute?(e: ExecuteEventArgs): void;

            /** Fires when the keydown action is successful.
             */
            keydown?(e: KeydownEventArgs): void;

            /** Fires when the keyup action is successful.
             */
            keyup?(e: KeyupEventArgs): void;

            /** Fires before the RTE Edit area is rendered and after the toolbar is rendered.
             */
            preRender?(e: PreRenderEventArgs): void;

            /** Fires when the text is selected in the text area
             */
            select?(e: SelectEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** When the event is canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the RTE model
             */
            model?: any;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface CreateEventArgs {

            /** When the event is canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the RTE model
             */
            model?: any;

            /** Returns the name of the event
             */
            type?: string;
        }

        export interface ContextMenuClickEventArgs {

            /** returns clicked menu item text.
             */
            text?: string;

            /** returns clicked menu item element.
             */
            element?: any;

            /** returns the selected item.
             */
            selectedItem?: number;
        }

        export interface DestroyEventArgs {

            /** When the event is canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the RTE model
             */
            model?: any;

            /** Returns the name of the event
             */
            type?: string;
        }

        export interface ExecuteEventArgs {

            /** When the event is canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the RTE model
             */
            model?: any;

            /** Returns the name of the event
             */
            type?: string;
        }

        export interface KeydownEventArgs {

            /** When the event is canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the RTE model
             */
            model?: any;

            /** Returns the name of the event
             */
            type?: string;
        }

        export interface KeyupEventArgs {

            /** When the event is canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the RTE model
             */
            model?: any;

            /** Returns the name of the event
             */
            type?: string;
        }

        export interface PreRenderEventArgs {

            /** When the event is canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the RTE model
             */
            model?: any;

            /** Returns the name of the event
             */
            type?: string;
        }

        export interface SelectEventArgs {

            /** When the event is canceled; otherwise, false.
             */
            cancel?: boolean;

            /** Returns the RTE model
             */
            model?: any;

            /** Returns the name of the event
             */
            type?: string;

            /** Returns the event object
             */
            event?: any;
        }

        export interface PasteCleanupSettings {

            /** This API is used to convert the list elements pasted from word document to editor.
             * @Default {false}
             */
            listConversion?: boolean;

            /** This API is used to clean the unwanted css in the elements pasted from word document to editor.
             * @Default {false}
             */
            cleanCSS?: boolean;

            /** This API is used to remove all styles in the elements pasted from word document to editor.
             * @Default {false}
             */
            removeStyles?: boolean;

            /** This API is used to clean the unwanted elements pasted from word document to editor.
             * @Default {false}
             */
            cleanElements?: boolean;
        }

        export interface ExportToPdfSettings {

            /** This API is used to receive the server-side handler for export related operations.
             */
            url?: string;

            /** Specifies the file name for the exported pdf file.
             */
            fileName?: string;
        }

        export interface ExportToWordSettings {

            /** This API is used to receive the server-side handler for export related operations.
             */
            url?: string;

            /** Specifies the file name for the exported word file.
             */
            fileName?: string;
        }

        export interface FileBrowser {

            /** This API is used to receive the server-side handler for file related operations.
             */
            ajaxAction?: string;

            /** Specifies the file type extension shown in the file browser window.
             */
            extensionAllow?: string;

            /** Specifies the directory to perform operations like create, delete and rename folder and files, and upload the selected files to the current directory.
             */
            filePath?: string;
        }

        export interface ImageBrowser {

            /** This API is used to receive the server-side handler for the file related operations.
             */
            ajaxAction?: string;

            /** Specifies the file type extension shown in the image browser window.
             */
            extensionAllow?: string;

            /** Specifies the directory to perform operations like create, delete and rename folder and files, and upload the selected images to the current directory.
             */
            filePath?: string;
        }

        export interface ImportSettings {

            /** This API is used to receive the server-side handler for import operations.
             */
            url?: string;
        }

        export interface ToolsCustomOrderedList {

            /** Specifies the name for customOrderedList item.
             */
            name?: string;

            /** Specifies the title for customOrderedList item.
             */
            tooltip?: string;

            /** Specifies the styles for customOrderedList item.
             */
            css?: string;

            /** Specifies the text for customOrderedList item.
             */
            text?: string;

            /** Specifies the list style for customOrderedList item.
             */
            listStyle?: string;

            /** Specifies the image for customOrderedList item.
             */
            listImage?: string;
        }

        export interface ToolsCustomUnorderedList {

            /** Specifies the name for customUnorderedList item.
             */
            name?: string;

            /** Specifies the title for customUnorderedList item.
             */
            tooltip?: string;

            /** Specifies the styles for customUnorderedList item.
             */
            css?: string;

            /** Specifies the text for customUnorderedList item.
             */
            text?: string;

            /** Specifies the list style for customUnorderedList item.
             */
            listStyle?: string;

            /** Specifies the image for customUnorderedList item.
             */
            listImage?: string;
        }

        export interface Tools {

            /** Specifies the alignment tools and the display order of this tool in the RTE toolbar.
             */
            alignment?: any;

            /** Specifies the casing tools and the display order of this tool in the RTE toolbar.
             */
            casing?: any[];

            /** Specifies the clear tools and the display order of this tool in the RTE toolbar.
             */
            clear?: any[];

            /** Specifies the clipboard tools and the display order of this tool in the RTE toolbar.
             */
            clipboard?: any[];

            /** Specifies the edit tools and the displays tool in the RTE toolbar.
             */
            edit?: any[];

            /** Specifies the doAction tools and the display order of this tool in the RTE toolbar.
             */
            doAction?: any[];

            /** Specifies the effect of tools and the display order of this tool in RTE toolbar.
             */
            effects?: any[];

            /** Specifies the font tools and the display order of this tool in the RTE toolbar.
             */
            font?: any[];

            /** Specifies the formatStyle tools and the display order of this tool in the RTE toolbar.
             */
            formatStyle?: any[];

            /** Specifies the image tools and the display order of this tool in the RTE toolbar.
             */
            images?: any[];

            /** Specifies the indent tools and the display order of this tool in the RTE toolbar.
             */
            indenting?: any[];

            /** Specifies the link tools and the display order of this tool in the RTE toolbar.
             */
            links?: any[];

            /** Specifies the list tools and the display order of this tool in the RTE toolbar.
             */
            lists?: any[];

            /** Specifies the media tools and the display order of this tool in the RTE toolbar.
             */
            media?: any[];

            /** Specifies the style tools and the display order of this tool in the RTE toolbar.
             */
            style?: any[];

            /** Specifies the table tools and the display order of this tool in the RTE toolbar.
             */
            tables?: any[];

            /** Specifies the view tools and the display order of this tool in the RTE toolbar.
             */
            view?: any[];

            /** Specifies the print tools and the display order of this tool in the RTE toolbar.
             */
            print?: any[];

            /** Specifies the importExport tools and the display order of this tool in the RTE toolbar.
             */
            importExport?: any[];

            /** Specifies the customOrderedList tools and the display order of this tool in the RTE toolbar.
             */
            customOrderedList?: ToolsCustomOrderedList[];

            /** Specifies the customUnOrderedList tools and the display order of this tool in the RTE toolbar.
             */
            customUnorderedList?: ToolsCustomUnorderedList[];
        }

        enum ToolbarOverflowMode {

            ///To display the RTE toolbar overflow items as popup
            Popup,

            ///To display the RTE toolbar overflow items as inline toolbar
            Inline
        }

    }

    class Slider extends ej.Widget {
        static fn: Slider;
        constructor(element: JQuery | Element, options?: Slider.Model);
        static Locale: any;
        model: Slider.Model;
        defaults: Slider.Model;

        /** To disable the slider
         * @returns {void}
         */
        disable(): void;

        /** To enable the slider
         * @returns {void}
         */
        enable(): void;

        /** To get value from slider handle
         * @returns {number}
         */
        getValue(): number;

        /** To set value to slider handle.By default animation is false while set the value. If you want to enable the animation, pass the enableAnimation as true to this method.
         * @returns {void}
         */
        setValue(): void;
    }
    export namespace Slider {

        export interface Model {

            /** Specifies the allowMouseWheel of the slider.
             * @Default {false}
             */
            allowMouseWheel?: boolean;

            /** Specifies the animationSpeed of the slider.
             * @Default {500}
             */
            animationSpeed?: number;

            /** Specify the CSS class to slider to achieve custom theme.
             */
            cssClass?: string;

            /** Specifies the animation behavior of the slider.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** Specifies the state of the slider.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specify the enablePersistence to slider to save current model value to browser cookies for state maintains
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Specifies the Right to Left Direction of the slider.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specifies the height of the slider.
             * @Default {14}
             */
            height?: string;

            /** Specifies the HTML Attributes of the ejSlider.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specifies the incremental step value of the slider.
             * @Default {1}
             */
            incrementStep?: number;

            /** Specifies the distance between two major (large) ticks from the scale of the slider.
             * @Default {10}
             */
            largeStep?: number;

            /** Specifies the ending value of the slider.
             * @Default {100}
             */
            maxValue?: number;

            /** Specifies the starting value of the slider.
             * @Default {0}
             */
            minValue?: number;

            /** Specifies the orientation of the slider.
             * @Default {ej.orientation.Horizontal}
             */
            orientation?: ej.Orientation|string;

            /** Specifies the readOnly of the slider.
             * @Default {false}
             */
            readOnly?: boolean;

            /** Shows/Hides the increment and decrement buttons of the slider.
             * @Default {false}
             */
            showButtons?: boolean;

            /** Specifies the rounded corner behavior for slider.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Shows/Hide the major (large) and minor (small) ticks in the scale of the slider.
             * @Default {false}
             */
            showScale?: boolean;

            /** Specifies the small ticks from the scale of the slider.
             * @Default {true}
             */
            showSmallTicks?: boolean;

            /** Specifies the showTooltip to shows the current Slider value, while moving the Slider handle or clicking on the slider handle of the slider.
             * @Default {true}
             */
            showTooltip?: boolean;

            /** Specifies the sliderType of the slider.
             * @Default {ej.SliderType.Default}
             */
            sliderType?: ej.slider.sliderType|string;

            /** Specifies the distance between two minor (small) ticks from the scale of the slider.
             * @Default {1}
             */
            smallStep?: number;

            /** Specifies the value of the slider. But it's not applicable for range slider. To range slider we can use values property.
             * @Default {0}
             */
            value?: number;

            /** Specifies the values of the range slider. But it's not applicable for default and minRange sliders. we can use value property for default and minRange sliders.
             * @Default {[minValue,maxValue]}
             */
            values?: any[];

            /** Specifies the width of the slider.
             * @Default {100%}
             */
            width?: string;

            /** Fires once Slider control value is changed successfully.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires once Slider control has been created successfully.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when Slider control has been destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires before creating each slider scale tick. You can use this event to add custom text in tick values.
             */
            renderingTicks?(e: RenderingTicksEventArgs): void;

            /** Fires once Slider control is sliding successfully.
             */
            slide?(e: SlideEventArgs): void;

            /** Fires once Slider control is started successfully.
             */
            start?(e: StartEventArgs): void;

            /** Fires when Slider control is stopped successfully.
             */
            stop?(e: StopEventArgs): void;

            /** Fires when display the custom tooltip.
             */
            tooltipChange?(e: TooltipChangeEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns current handle number or index
             */
            sliderIndex?: number;

            /** returns slider id.
             */
            id?: string;

            /** returns the slider model.
             */
            model?: ej.Slider.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the slider value.
             */
            value?: number;

            /** returns true if event triggered by interaction else returns false.
             */
            isInteraction?: boolean;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the slider model
             */
            model?: ej.Slider.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the slider model
             */
            model?: ej.Slider.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface RenderingTicksEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns slider tick value
             */
            value?: number;

            /** returns the value type either tooltip or label value
             */
            valueType?: string;

            /** returns the current Li element
             */
            tick?: any;
        }

        export interface SlideEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns current handle number or index
             */
            sliderIndex?: number;

            /** returns slider id
             */
            id?: string;

            /** returns the slider model
             */
            model?: ej.Slider.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the slider value
             */
            value?: number;
        }

        export interface StartEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns current handle number or index
             */
            sliderIndex?: number;

            /** returns slider id
             */
            id?: string;

            /** returns the slider model
             */
            model?: ej.Slider.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the slider value
             */
            value?: number;
        }

        export interface StopEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns current handle number or index
             */
            sliderIndex?: number;

            /** returns slider id
             */
            id?: string;

            /** returns the slider model
             */
            model?: ej.Slider.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the slider value
             */
            value?: number;
        }

        export interface TooltipChangeEventArgs {

            /** returns the cancel option value.
             */
            cancel?: boolean;

            /** returns slider id.
             */
            id?: string;

            /** returns true if event triggered by interaction else returns false.
             */
            isInteraction?: boolean;

            /** returns the slider model.
             */
            model?: ej.Slider.Model;

            /** returns current handle number or index
             */
            sliderIndex?: number;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the slider value.
             */
            value?: number;
        }
    }
    namespace slider {
        enum sliderType {
            //Shows default slider
            Default,
            //Shows minRange slider
            MinRange,
            //Shows Range slider
            Range,
        }
    }

    class SplitButton extends ej.Widget {
        static fn: SplitButton;
        constructor(element: JQuery | Element, options?: SplitButton.Model);
        static Locale: any;
        model: SplitButton.Model;
        defaults: SplitButton.Model;

        /** Destroy the split button widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** To disable the split button
         * @returns {void}
         */
        disable(): void;

        /** To Enable the split button
         * @returns {void}
         */
        enable(): void;

        /** To hide the list content of the split button.
         * @returns {void}
         */
        hide(): void;

        /** To show the list content of the split button.
         * @returns {void}
         */
        show(): void;
    }
    export namespace SplitButton {

        export interface Model {

            /** Specifies the arrowPosition of the Split or Dropdown Button.See arrowPosition
             * @Default {ej.ArrowPosition.Right}
             */
            arrowPosition?: string|ej.ArrowPosition;

            /** Specifies the buttonMode like Split or Dropdown Button.See ButtonMode
             * @Default {ej.ButtonMode.Split}
             */
            buttonMode?: string|ej.ButtonMode;

            /** Specifies the contentType of the Split Button.See ContentType
             * @Default {ej.ContentType.TextOnly}
             */
            contentType?: string|ej.ContentType;

            /** Set the root class for Split Button control theme
             */
            cssClass?: string;

            /** Specifies the disabling of Split Button if enabled is set to false.
             * @Default {true}
             */
            enabled?: boolean;

            /** Specifies the enableRTL property for Split Button while initialization.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specifies the height of the Split Button.
             * @Default {â€œâ€}
             */
            height?: string|number;

            /** Specifies the HTML Attributes of the Split Button.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specifies the imagePosition of the Split Button.See imagePositions
             * @Default {ej.ImagePosition.ImageRight}
             */
            imagePosition?: string|ej.ImagePosition;

            /** Specifies the image content for Split Button while initialization.
             */
            prefixIcon?: string;

            /** Specifies the showRoundedCorner property for Split Button while initialization.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies the size of the Button. See ButtonSize
             * @Default {ej.ButtonSize.Normal}
             */
            size?: string|ej.ButtonSize;

            /** Specifies the image content for Split Button while initialization.
             */
            suffixIcon?: string;

            /** Specifies the list content for Split Button while initialization
             */
            targetID?: string;

            /** Specifies the target of splitbutton menu while initialization with ID or class as a selector.
             */
            target?: string;

            /** Specifies the text content for Split Button while initialization.
             */
            text?: string;

            /** Specifies the width of the Split Button.
             * @Default {â€œâ€}
             */
            width?: string|number;

            /** Fires before menu of the split button control is opened.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** Fires when Button control is clicked successfully
             */
            click?(e: ClickEventArgs): void;

            /** Fires before the list content of Button control is closed
             */
            close?(e: CloseEventArgs): void;

            /** Fires after Split Button control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the Split Button is destroyed successfully
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when a menu item is Hovered out successfully
             */
            itemMouseOut?(e: ItemMouseOutEventArgs): void;

            /** Fires when a menu item is Hovered in successfully
             */
            itemMouseOver?(e: ItemMouseOverEventArgs): void;

            /** Fires when a menu item is clicked successfully
             */
            itemSelected?(e: ItemSelectedEventArgs): void;

            /** Fires before the list content of Button control is opened
             */
            open?(e: OpenEventArgs): void;
        }

        export interface BeforeOpenEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ClickEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the target of the current object.
             */
            target?: any;

            /** return the button state
             */
            status?: boolean;
        }

        export interface CloseEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface CreateEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ItemMouseOutEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the clicked menu item element
             */
            element?: any;

            /** return the menu item id
             */
            ID?: string;

            /** return the clicked menu item text
             */
            Text?: string;
        }

        export interface ItemMouseOverEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the clicked menu item element
             */
            element?: any;

            /** return the menu item id
             */
            ID?: string;

            /** return the clicked menu item text
             */
            Text?: string;
        }

        export interface ItemSelectedEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the clicked menu item element
             */
            element?: any;

            /** returns the selected item
             */
            selectedItem?: any;

            /** return the menu id
             */
            menuId?: string;

            /** return the clicked menu item text
             */
            menuText?: string;
        }

        export interface OpenEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the split button model
             */
            model?: ej.SplitButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }
    }
    enum ArrowPosition {
        //To set Left arrowPosition of the split button
        Left,
        //To set Right arrowPosition of the split button
        Right,
        //To set Top arrowPosition of the split button
        Top,
        //To set Bottom arrowPosition of the split button
        Bottom,
    }

    class Splitter extends ej.Widget {
        static fn: Splitter;
        constructor(element: JQuery | Element, options?: Splitter.Model);
        static Locale: any;
        model: Splitter.Model;
        defaults: Splitter.Model;

        /** To add a new pane to splitter control.
         * @param {string} content of pane.
         * @param {any} pane properties.
         * @param {number} index of pane.
         * @returns {HTMLElement}
         */
        addItem(content: string, property: any, index: number): HTMLElement;

        /** To collapse the splitter control pane.
         * @param {number} index number of pane.
         * @returns {void}
         */
        collapse(paneIndex: number): void;

        /** To expand the splitter control pane.
         * @param {number} index number of pane.
         * @returns {void}
         */
        expand(paneIndex: number): void;

        /** To refresh the splitter control pane resizing.
         * @returns {void}
         */
        refresh(): void;

        /** To remove a specified pane from the splitter control.
         * @param {number} index of pane.
         * @returns {void}
         */
        removeItem(index: number): void;
    }
    export namespace Splitter {

        export interface Model {

            /** Turns on keyboard interaction with the Splitter panes. You must set this property to true to access the keyboard shortcuts of ejSplitter.
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** Specify animation speed for the Splitter pane movement, while collapsing and expanding.
             * @Default {300}
             */
            animationSpeed?: number;

            /** Specify the CSS class to splitter control to achieve custom theme.
             * @Default {â€œâ€}
             */
            cssClass?: string;

            /** Specifies the animation behavior of the splitter.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** Specifies the splitter control to be displayed in right to left direction.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specifies HTML element string to replace the existing expand/collapse icons.
             * @Default {null}
             */
            expanderTemplate?: string;

            /** Specify height for splitter control.
             * @Default {null}
             */
            height?: string;

            /** Specifies the HTML Attributes of the Splitter.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specify window resizing behavior for splitter control.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Specify the orientation for splitter control. See orientation
             * @Default {ej.orientation.Horizontal or â€œhorizontalâ€}
             */
            orientation?: ej.Orientation|string;

            /** Specify properties for each pane like paneSize, minSize, maxSize, collapsible, expandable, resizable.
             * @Default {[]}
             */
            properties?: any[];

            /** Specify width for splitter control.
             * @Default {null}
             */
            width?: string;

            /** Fires before expanding / collapsing the split pane of splitter control.
             */
            beforeExpandCollapse?(e: BeforeExpandCollapseEventArgs): void;

            /** Triggered when we click on the template icon. (Note: This will work only when expanderTemplate is defined.)
             */
            clickOnExpander?(e: ClickOnExpanderEventArgs): void;

            /** Fires when splitter control pane has been created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when splitter control pane has been destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when expand / collapse operation in splitter control pane has been performed successfully.
             */
            expandCollapse?(e: ExpandCollapseEventArgs): void;

            /** Fires when resize in splitter control pane.
             */
            resize?(e: ResizeEventArgs): void;
        }

        export interface BeforeExpandCollapseEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns collapsed pane details.
             */
            collapsed?: any;

            /** returns expanded pane details.
             */
            expanded?: any;

            /** returns the splitter model.
             */
            model?: ej.Splitter.Model;

            /** returns the current split bar index.
             */
            splitbarIndex?: number;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ClickOnExpanderEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the splitter model.
             */
            model?: ej.Splitter.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the target element from which click action is triggered.
             */
            targetElement?: any;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the splitter model.
             */
            model?: ej.Splitter.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the splitter model.
             */
            model?: ej.Splitter.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ExpandCollapseEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns collapsed pane details.
             */
            collapsed?: any;

            /** returns expanded pane details.
             */
            expanded?: any;

            /** returns the splitter model.
             */
            model?: ej.Splitter.Model;

            /** returns the current split bar index.
             */
            splitbarIndex?: number;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ResizeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns previous pane details.
             */
            prevPane?: any;

            /** returns next pane details.
             */
            nextPane?: any;

            /** returns the splitter model.
             */
            model?: ej.Splitter.Model;

            /** returns the current split bar index.
             */
            splitbarIndex?: number;

            /** returns the name of the event.
             */
            type?: string;
        }
    }

    class Tab extends ej.Widget {
        static fn: Tab;
        constructor(element: JQuery | Element, options?: Tab.Model);
        static Locale: any;
        model: Tab.Model;
        defaults: Tab.Model;

        /** Add new tab items with given name, URL and given index position, if index null itâ€™s add last item.
         * @param {string} URL name / tab id.
         * @param {string} Tab Display name.
         * @param {number} Index position to placed , this is optional.
         * @param {string} specifies cssClass, this is optional.
         * @param {string} specifies id of tab, this is optional.
         * @returns {void}
         */
        addItem(URL: string, displayLabel: string, index: number, cssClass: string, id: string): void;

        /** To disable the tab control.
         * @returns {void}
         */
        disable(): void;

        /** To enable the tab control.
         * @returns {void}
         */
        enable(): void;

        /** This function get the number of tab rendered
         * @returns {number}
         */
        getItemsCount(): number;

        /** This function hides the tab control.
         * @returns {void}
         */
        hide(): void;

        /** This function hides the specified item tab in tab control.
         * @param {number} index of tab item.
         * @returns {void}
         */
        hideItem(index: number): void;

        /** Remove the given index tab item.
         * @param {number} index of tab item.
         * @returns {void}
         */
        removeItem(index: number): void;

        /** This function is to show the tab control.
         * @returns {void}
         */
        show(): void;

        /** This function helps to show the specified hidden tab item in tab control.
         * @param {number} index of tab item.
         * @returns {void}
         */
        showItem(index: number): void;
    }
    export namespace Tab {

        export interface Model {

            /** Specifies the ajaxSettings option to load the content to the Tab control.
             */
            ajaxSettings?: AjaxSettings;

            /** Tab items interaction with keyboard keys, like headers active navigation.
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** Allow to collapsing the active item, while click on the active header.
             * @Default {false}
             */
            collapsible?: boolean;

            /** Set the root class for Tab theme. This cssClass API helps to use custom skinning option for Tab control.
             */
            cssClass?: string;

            /** Disables the given tab headers and content panels.
             * @Default {[]}
             */
            disabledItemIndex?: number[];

            /** Specifies the animation behavior of the tab.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** When this property is set to false, it disables the tab control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Enables the given tab headers and content panels.
             * @Default {[]}
             */
            enabledItemIndex?: number[];

            /** Save current model value to browser cookies for state maintains. While refresh the Tab control page the model value apply from browser cookies.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Display Right to Left direction for headers and panels text of tab.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specify to enable scrolling for Tab header.
             * @Default {false}
             */
            enableTabScroll?: boolean;

            /** The event API to bind the action for active the tab items.
             * @Default {click}
             */
            events?: string;

            /** Specifies the position of Tab header as top, bottom, left or right. See below to get available Position
             * @Default {top}
             */
            headerPosition?: string|ej.Tab.Position;

            /** Set the height of the tab header element. Default this property value is null, so height take content height.
             * @Default {null}
             */
            headerSize?: string|number;

            /** Height set the outer panel element. Default this property value is null, so height take content height.
             * @Default {null}
             */
            height?: string|number;

            /** Adjust the content panel height for given option (content, auto and fill), by default panels height adjust based on the content.See below to get available HeightAdjustMode
             * @Default {content}
             */
            heightAdjustMode?: string|ej.Tab.HeightAdjustMode;

            /** Specifies to hide a pane of Tab control.
             * @Default {[]}
             */
            hiddenItemIndex?: any[];

            /** Specifies the HTML Attributes of the Tab.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** The idPrefix property appends the given string on the added tab item idâ€™s in runtime.
             * @Default {ej-tab-}
             */
            idPrefix?: string;

            /** Specifies the Tab header in active for given index value.
             * @Default {0}
             */
            selectedItemIndex?: number;

            /** Display the close button for each tab items. While clicking on the close icon, particular tab item will be removed.
             * @Default {false}
             */
            showCloseButton?: boolean;

            /** Display the Reload button for each tab items.
             * @Default {false}
             */
            showReloadIcon?: boolean;

            /** Tab panels and headers to be displayed in rounded corner style.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Set the width for outer panel element, if not itâ€™s take parent width.
             * @Default {null}
             */
            width?: string|number;

            /** Triggered after a tab item activated.
             */
            itemActive?(e: ItemActiveEventArgs): void;

            /** Triggered before AJAX content has been loaded.
             */
            ajaxBeforeLoad?(e: AjaxBeforeLoadEventArgs): void;

            /** Triggered if error occurs in AJAX request.
             */
            ajaxError?(e: AjaxErrorEventArgs): void;

            /** Triggered after AJAX content load action.
             */
            ajaxLoad?(e: AjaxLoadEventArgs): void;

            /** Triggered after a tab item activated.
             */
            ajaxSuccess?(e: AjaxSuccessEventArgs): void;

            /** Triggered before a tab item activated.
             */
            beforeActive?(e: BeforeActiveEventArgs): void;

            /** Triggered before a tab item remove.
             */
            beforeItemRemove?(e: BeforeItemRemoveEventArgs): void;

            /** Triggered before a tab item Create.
             */
            create?(e: CreateEventArgs): void;

            /** Triggered before a tab item destroy.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggered after new tab item add
             */
            itemAdd?(e: ItemAddEventArgs): void;

            /** Triggered after tab item removed.
             */
            itemRemove?(e: ItemRemoveEventArgs): void;
        }

        export interface ItemActiveEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns previous active tab header.
             */
            prevActiveHeader?: HTMLElement;

            /** returns previous active index.
             */
            prevActiveIndex?: number;

            /** returns current active tab header .
             */
            activeHeader?: HTMLElement;

            /** returns current active index.
             */
            activeIndex?: number;

            /** returns, is it triggered by interaction or not.
             */
            isInteraction?: boolean;
        }

        export interface AjaxBeforeLoadEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns previous active tab header.
             */
            prevActiveHeader?: HTMLElement;

            /** returns previous active index.
             */
            prevActiveIndex?: number;

            /** returns current active tab header .
             */
            activeHeader?: HTMLElement;

            /** returns current active index.
             */
            activeIndex?: number;

            /** returns the URL of AJAX request
             */
            URL?: string;

            /** returns, is it triggered by interaction or not.
             */
            isInteraction?: boolean;
        }

        export interface AjaxErrorEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns AJAX data details.
             */
            data?: any;

            /** returns the URL of AJAX request.
             */
            URL?: string;
        }

        export interface AjaxLoadEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns previous active tab header.
             */
            prevActiveHeader?: HTMLElement;

            /** returns previous active index.
             */
            prevActiveIndex?: number;

            /** returns current active tab header .
             */
            activeHeader?: HTMLElement;

            /** returns current active index.
             */
            activeIndex?: number;

            /** returns the URL of AJAX request
             */
            URL?: string;

            /** returns, is it triggered by interaction or not.
             */
            isInteraction?: boolean;
        }

        export interface AjaxSuccessEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** return AJAX data.
             */
            data?: any;

            /** returns AJAX URL
             */
            URL?: string;

            /** returns content of AJAX request.
             */
            content?: any;
        }

        export interface BeforeActiveEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns previous active tab header.
             */
            prevActiveHeader?: HTMLElement;

            /** returns previous active index.
             */
            prevActiveIndex?: number;

            /** returns current active tab header .
             */
            activeHeader?: HTMLElement;

            /** returns current active index.
             */
            activeIndex?: number;

            /** returns, is it triggered by interaction or not.
             */
            isInteraction?: boolean;
        }

        export interface BeforeItemRemoveEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns current tab item index
             */
            index?: number;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ItemAddEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns new added tab header.
             */
            tabHeader?: HTMLElement;

            /** returns new added tab content panel.
             */
            tabContent?: any;
        }

        export interface ItemRemoveEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the tab model.
             */
            model?: ej.Tab.Model;

            /** returns the name of the event.
             */
            type?: string;

            /** returns removed tab header.
             */
            removedTab?: HTMLElement;
        }

        export interface AjaxSettings {

            /** It specifies, whether to enable or disable asynchronous request.
             * @Default {true}
             */
            async?: boolean;

            /** It specifies the page will be cached in the web browser.
             * @Default {false}
             */
            cache?: boolean;

            /** It specifies the type of data is send in the query string.
             * @Default {html}
             */
            contentType?: string;

            /** It specifies the data as an object, will be passed in the query string.
             * @Default {{}}
             */
            data?: any;

            /** It specifies the type of data that you're expecting back from the response.
             * @Default {html}
             */
            dataType?: string;

            /** It specifies the HTTP request type.
             * @Default {get}
             */
            type?: string;
        }

        enum Position {

            ///Tab headers display to top position
            Top,

            ///Tab headers display to bottom position
            Bottom,

            ///Tab headers display to left position.
            Left,

            ///Tab headers display to right position.
            Right
        }


        enum HeightAdjustMode {

            ///string
            None,

            ///string
            Content,

            ///string
            Auto,

            ///string
            Fill
        }

    }

    class TagCloud extends ej.Widget {
        static fn: TagCloud;
        constructor(element: JQuery | Element, options?: TagCloud.Model);
        static Locale: any;
        model: TagCloud.Model;
        defaults: TagCloud.Model;

        /** Inserts a new item into the TagCloud
         * @param {string} Insert new item into the TagCloud
         * @returns {void}
         */
        insert(name: string): void;

        /** Inserts a new item into the TagCloud at a particular position.
         * @param {string} Inserts a new item into the TagCloud
         * @param {number} Inserts a new item into the TagCloud with the specified position
         * @returns {void}
         */
        insertAt(name: string, position: number): void;

        /** Removes the item from the TagCloud based on the name. It removes all the tags which have the corresponding name
         * @param {string} name of the tag.
         * @returns {void}
         */
        remove(name: string): void;

        /** Removes the item from the TagCloud based on the position. It removes the tags from the the corresponding position only.
         * @param {number} position of tag item.
         * @returns {void}
         */
        removeAt(position: number): void;
    }
    export namespace TagCloud {

        export interface Model {

            /** Specify the CSS class to button to achieve custom theme.
             */
            cssClass?: string;

            /** The dataSource contains the list of data to display in a cloud format. Each data contains a link URL, frequency to categorize the font size and a display text.
             * @Default {null}
             */
            dataSource?: any;

            /** Sets the TagCloud and tag items direction as right to left alignment.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Defines the mapping fields for the data items of the TagCloud.
             * @Default {null}
             */
            fields?: Fields;

            /** Specifies the list of HTML attributes to be added to TagCloud control.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Defines the format for the TagCloud to display the tag items.See Format
             * @Default {ej.Format.Cloud}
             */
            format?: string|ej.Format;

            /** Sets the maximum font size value for the tag items. The font size for the tag items will be generated in between the minimum and maximum font size values.
             * @Default {40px}
             */
            maxFontSize?: string|number;

            /** Sets the minimum font size value for the tag items. The font size for the tag items will be generated in between the minimum and maximum font size values.
             * @Default {10px}
             */
            minFontSize?: string|number;

            /** Define the query to retrieve the data from online server. The query is used only when the online dataSource is used.
             * @Default {null}
             */
            query?: any;

            /** Shows or hides the TagCloud title. When this set to false, it hides the TagCloud header.
             * @Default {true}
             */
            showTitle?: boolean;

            /** Sets the title image for the TagCloud. To show the title image, the showTitle property should be enabled.
             * @Default {null}
             */
            titleImage?: string;

            /** Sets the title text for the TagCloud. To show the title text, the showTitle property should be enabled.
             * @Default {Title}
             */
            titleText?: string;

            /** Event triggers when the TagCloud items are clicked
             */
            click?(e: ClickEventArgs): void;

            /** Event triggers when the TagCloud are created
             */
            create?(e: CreateEventArgs): void;

            /** Event triggers when the TagCloud are destroyed
             */
            destroy?(e: DestroyEventArgs): void;

            /** Event triggers when the cursor leaves out from a tag item
             */
            mouseout?(e: MouseoutEventArgs): void;

            /** Event triggers when the cursor hovers on a tag item
             */
            mouseover?(e: MouseoverEventArgs): void;
        }

        export interface ClickEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TagCloud model
             */
            model?: ej.TagCloud.Model;

            /** returns the name of the event
             */
            type?: string;

            /** return current tag name
             */
            text?: string;

            /** return current URL link
             */
            URL?: string;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TagCloud model
             */
            model?: ej.TagCloud.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TagCloud model
             */
            model?: ej.TagCloud.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface MouseoutEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TagCloud model
             */
            model?: ej.TagCloud.Model;

            /** returns the name of the event
             */
            type?: string;

            /** return current tag name
             */
            text?: string;

            /** return current URL link
             */
            URL?: string;
        }

        export interface MouseoverEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TagCloud model
             */
            model?: ej.TagCloud.Model;

            /** returns the name of the event
             */
            type?: string;

            /** return current tag name
             */
            text?: string;

            /** return current URL link
             */
            URL?: string;
        }

        export interface Fields {

            /** Defines the frequency column number to categorize the font size.
             */
            frequency?: string;

            /** Defines the HTML attributes column for the anchor elements inside the each tag items.
             */
            htmlAttributes?: string;

            /** Defines the tag value or display text.
             */
            text?: string;

            /** Defines the URL link to navigate while click the tag.
             */
            url?: string;
        }
    }
    enum Format {
        //To render the TagCloud items in cloud format
        Cloud,
        //To render the TagCloud items in list format
        List,
    }

    class TimePicker extends ej.Widget {
        static fn: TimePicker;
        constructor(element: JQuery | Element, options?: TimePicker.Model);
        static Locale: any;
        model: TimePicker.Model;
        defaults: TimePicker.Model;

        /** Allows you to disable the TimePicker.
         * @returns {void}
         */
        disable(): void;

        /** Allows you to enable the TimePicker.
         * @returns {void}
         */
        enable(): void;

        /** It returns the current time value.
         * @returns {string}
         */
        getValue(): string;

        /** This method will hide the TimePicker control popup.
         * @returns {void}
         */
        hide(): void;

        /** Updates the current system time in TimePicker.
         * @returns {void}
         */
        setCurrentTime(): void;

        /** This method will show the TimePicker control popup.
         * @returns {void}
         */
        show(): void;
    }
    export namespace TimePicker {

        export interface Model {

            /** Sets the root CSS class for the TimePicker theme, which is used to customize.
             */
            cssClass?: string;

            /** Specifies the list of time range to be disabled.
             * @Default {{}}
             */
            disableTimeRanges?: any;

            /** Specifies the animation behavior in TimePicker.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** When this property is set to false, it disables the TimePicker control.
             * @Default {true}
             */
            enabled?: boolean;

            /** Save current model value to browser cookies for maintaining states. When refreshing the TimePicker control page, the model value is applied from browser cookies or HTML 5local
             * storage.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Displays the TimePicker as right to left alignment.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** When the enableStrictMode is set as true it allows the value outside of the range and also indicate with red color border, otherwise it internally changed to the min or max range
             * value based an input value.
             * @Default {false}
             */
            enableStrictMode?: boolean;

            /** Defines the height of the TimePicker textbox.
             */
            height?: string|number;

            /** Sets the step value for increment an hour value through arrow keys or mouse scroll.
             * @Default {1}
             */
            hourInterval?: number;

            /** It allows to define the characteristics of the TimePicker control. It will helps to extend the capability of an HTML element.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Sets the time interval between the two adjacent time values in the popup.
             * @Default {30}
             */
            interval?: number;

            /** Defines the localization info used by the TimePicker.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the maximum time value to the TimePicker.
             * @Default {11:59:59 PM}
             */
            maxTime?: string;

            /** Sets the minimum time value to the TimePicker.
             * @Default {12:00:00 AM}
             */
            minTime?: string;

            /** Sets the step value for increment the minute value through arrow keys or mouse scroll.
             * @Default {1}
             */
            minutesInterval?: number;

            /** Defines the height of the TimePicker popup.
             * @Default {191px}
             */
            popupHeight?: string|number;

            /** Defines the width of the TimePicker popup.
             * @Default {auto}
             */
            popupWidth?: string|number;

            /** Toggles the readonly state of the TimePicker. When the widget is readOnly, it doesnâ€™t allow your input.
             * @Default {false}
             */
            readOnly?: boolean;

            /** Sets the step value for increment the seconds value through arrow keys or mouse scroll.
             * @Default {1}
             */
            secondsInterval?: number;

            /** shows or hides the drop down button in TimePicker.
             * @Default {true}
             */
            showPopupButton?: boolean;

            /** TimePicker is displayed with rounded corner when this property is set to true.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Defines the time format displayed in the TimePicker.
             * @Default {h:mm tt}
             */
            timeFormat?: string;

            /** Set the jQuery validation error message in TimePicker.
             * @Default {null}
             */
            validationMessages?: any;

            /** Set the jQuery validation rules in TimePicker.
             * @Default {null}
             */
            validationRules?: any;

            /** Sets a specified time value on the TimePicker.
             * @Default {null}
             */
            value?: string|Date;

            /** Specifies the water mark text to be displayed in input text.
             * @Default {select a time}
             */
            watermarkText?: string;

            /** Defines the width of the TimePicker textbox.
             */
            width?: string|number;

            /** Fires when the time value changed in the TimePicker.
             */
            beforeChange?(e: BeforeChangeEventArgs): void;

            /** Fires when the TimePicker popup before opened.
             */
            beforeOpen?(e: BeforeOpenEventArgs): void;

            /** Fires when the time value changed in the TimePicker.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires when the TimePicker popup closed.
             */
            close?(e: CloseEventArgs): void;

            /** Fires when create TimePicker successfully.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the TimePicker is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when the TimePicker control gets focus.
             */
            focusIn?(e: FocusInEventArgs): void;

            /** Fires when the TimePicker control get lost focus.
             */
            focusOut?(e: FocusOutEventArgs): void;

            /** Fires when the TimePicker popup opened.
             */
            open?(e: OpenEventArgs): void;

            /** Fires when the value is selected from the TimePicker dropdown list.
             */
            select?(e: SelectEventArgs): void;
        }

        export interface BeforeChangeEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the previously selected time value
             */
            prevTime?: string;

            /** returns the modified time value
             */
            value?: string;
        }

        export interface BeforeOpenEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the previously selected time value
             */
            prevTime?: string;

            /** returns the time value
             */
            value?: string;
        }

        export interface ChangeEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns true when the value changed by user interaction otherwise returns false
             */
            isInteraction?: boolean;

            /** returns the previously selected time value
             */
            prevTime?: string;

            /** returns the modified time value
             */
            value?: string;
        }

        export interface CloseEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the previously selected time value
             */
            prevTime?: string;

            /** returns the time value
             */
            value?: string;
        }

        export interface CreateEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface FocusInEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the previously selected time value
             */
            prevTime?: string;

            /** returns the current time value
             */
            value?: string;
        }

        export interface FocusOutEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the previously selected time value
             */
            prevTime?: string;

            /** returns the current time value
             */
            value?: string;
        }

        export interface OpenEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the time value
             */
            value?: string;
        }

        export interface SelectEventArgs {

            /** returns the TimePicker model
             */
            model?: ej.TimePicker.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the previously selected time value
             */
            prevTime?: string;

            /** returns the selected time value
             */
            value?: string;
        }
    }

    class ToggleButton extends ej.Widget {
        static fn: ToggleButton;
        constructor(element: JQuery | Element, options?: ToggleButton.Model);
        static Locale: any;
        model: ToggleButton.Model;
        defaults: ToggleButton.Model;

        /** Allows you to destroy the ToggleButton widget.
         * @returns {void}
         */
        destroy(): void;

        /** To disable the ToggleButton to prevent all user interactions.
         * @returns {void}
         */
        disable(): void;

        /** To enable the ToggleButton.
         * @returns {void}
         */
        enable(): void;
    }
    export namespace ToggleButton {

        export interface Model {

            /** Specify the icon in active state to the toggle button and it will be aligned from left margin of the button.
             */
            activePrefixIcon?: string;

            /** Specify the icon in active state to the toggle button and it will be aligned from right margin of the button.
             */
            activeSuffixIcon?: string;

            /** Sets the text when ToggleButton is in active state i.e.,checked state.
             * @Default {null}
             */
            activeText?: string;

            /** Specifies the contentType of the ToggleButton. See ContentType as below
             * @Default {ej.ContentType.TextOnly}
             */
            contentType?: ej.ContentType|string;

            /** Specify the CSS class to the ToggleButton to achieve custom theme.
             */
            cssClass?: string;

            /** Specify the icon in default state to the toggle button and it will be aligned from left margin of the button.
             */
            defaultPrefixIcon?: string;

            /** Specify the icon in default state to the toggle button and it will be aligned from right margin of the button.
             */
            defaultSuffixIcon?: string;

            /** Specifies the text of the ToggleButton, when the control is a default state. i.e., unChecked state.
             * @Default {null}
             */
            defaultText?: string;

            /** Specifies the state of the ToggleButton.
             * @Default {true}
             */
            enabled?: boolean;

            /** Save current model value to browser cookies for maintaining states. When refreshing the ToggleButton control page, the model value is applied from browser cookies or HTML 5local
             * storage.
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Specify the Right to Left direction of the ToggleButton.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Specifies the height of the ToggleButton.
             * @Default {28pixel}
             */
            height?: number|string;

            /** It allows to define the characteristics of the ToggleButton control. It will helps to extend the capability of an HTML element.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specifies the image position of the ToggleButton.
             * @Default {ej.ImagePosition.ImageLeft}
             */
            imagePosition?: ej.ImagePosition|string;

            /** Allows to prevents the control switched to checked (active) state.
             * @Default {false}
             */
            preventToggle?: boolean;

            /** Displays the ToggleButton with rounded corners.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies the size of the ToggleButton. See ButtonSize as below
             * @Default {ej.ButtonSize.Normal}
             */
            size?: ej.ButtonSize|string;

            /** It allows to define the ToggleButton state to checked(Active) or unchecked(Default) at initial time.
             * @Default {false}
             */
            toggleState?: boolean;

            /** Specifies the type of the ToggleButton. See ButtonType as below
             * @Default {ej.ButtonType.Button}
             */
            type?: ej.ButtonType|string;

            /** Specifies the width of the ToggleButton.
             * @Default {100pixel}
             */
            width?: number|string;

            /** Fires when ToggleButton control state is changed successfully.
             */
            change?(e: ChangeEventArgs): void;

            /** Fires when ToggleButton control is clicked successfully.
             */
            click?(e: ClickEventArgs): void;

            /** Fires when ToggleButton control is created successfully.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when ToggleButton control is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;
        }

        export interface ChangeEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** return the toggle button checked state
             */
            isChecked?: boolean;

            /** returns the toggle button model
             */
            model?: ej.ToggleButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ClickEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** return the toggle button checked state
             */
            isChecked?: boolean;

            /** returns the toggle button model
             */
            model?: ej.ToggleButton.Model;

            /** return the toggle button state
             */
            status?: boolean;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the toggle button model
             */
            model?: ej.ToggleButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the toggle button model
             */
            model?: ej.ToggleButton.Model;

            /** returns the name of the event
             */
            type?: string;
        }
    }

    class Toolbar extends ej.Widget {
        static fn: Toolbar;
        constructor(element: JQuery | Element, options?: Toolbar.Model);
        static Locale: any;
        model: Toolbar.Model;
        defaults: Toolbar.Model;

        /** Deselect the specified Toolbar item.
         * @param {any} The element need to be deselected
         * @returns {void}
         */
        deselectItem(element: any): void;

        /** Deselect the Toolbar item based on specified id.
         * @param {string} The ID of the element need to be deselected
         * @returns {void}
         */
        deselectItemByID(ID: string): void;

        /** Allows you to destroy the Toolbar widget.
         * @returns {void}
         */
        destroy(): void;

        /** To disable all items in the Toolbar control.
         * @returns {void}
         */
        disable(): void;

        /** Disable the specified Toolbar item.
         * @param {any} The element need to be disabled
         * @returns {void}
         */
        disableItem(element: any): void;

        /** Disable the Toolbar item based on specified item id in the Toolbar.
         * @param {string} The ID of the element need to be disabled
         * @returns {void}
         */
        disableItemByID(ID: string): void;

        /** Enable the Toolbar if it is in disabled state.
         * @returns {void}
         */
        enable(): void;

        /** Enable the Toolbar item based on specified item.
         * @param {any} The element need to be enabled
         * @returns {void}
         */
        enableItem(element: any): void;

        /** Enable the Toolbar item based on specified item id in the Toolbar.
         * @param {string} The ID of the element need to be enabled
         * @returns {void}
         */
        enableItemByID(ID: string): void;

        /** To hide the Toolbar
         * @returns {void}
         */
        hide(): void;

        /** Remove the item from toolbar, based on specified item.
         * @param {any} The element need to be removed
         * @returns {void}
         */
        removeItem(element: any): void;

        /** Remove the item from toolbar, based on specified item id in the Toolbar.
         * @param {string} The ID of the element need to be removed
         * @returns {void}
         */
        removeItemByID(ID: string): void;

        /** Selects the item from toolbar, based on specified item.
         * @param {any} The element need to be selected
         * @returns {void}
         */
        selectItem(element: any): void;

        /** Selects the item from toolbar, based on specified item id in the Toolbar.
         * @param {string} The ID of the element need to be selected
         * @returns {void}
         */
        selectItemByID(ID: string): void;

        /** To show the Toolbar.
         * @returns {void}
         */
        show(): void;
    }
    export namespace Toolbar {

        export interface Model {

            /** Sets the root CSS class for Toolbar control to achieve the custom theme.
             */
            cssClass?: string;

            /** Specifies dataSource value for the Toolbar control during initialization.
             * @Default {null}
             */
            dataSource?: any;

            /** Disables an Item or set of Items that are enabled in the Toolbar
             * @Default {[]}
             */
            disabledItemIndices?: any[];

            /** Specifies the Toolbar control state.
             * @Default {true}
             */
            enabled?: boolean;

            /** Enables an Item or set of Items that are disabled in the Toolbar
             * @Default {[]}
             */
            enabledItemIndices?: any[];

            /** Specifies enableRTL property to align the Toolbar control from right to left direction.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Allows to separate the each UL items in the Toolbar control.
             * @Default {false}
             */
            enableSeparator?: boolean;

            /** Specifies the mapping fields for the data items of the Toolbar
             * @Default {null}
             */
            fields?: string;

            /** Specifies the height of the Toolbar.
             * @Default {28}
             */
            height?: number|string;

            /** Specifies the list of HTML attributes to be added to toolbar control.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specifies whether the Toolbar control is need to be show or hide.
             * @Default {false}
             */
            hide?: boolean;

            /** Enables/Disables the responsive support for Toolbar items during the window resizing time.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Specifies the items of  Toolbar
             * @Default {null}
             */
            Items?: Items;

            /** Specifies the Toolbar orientation. See orientation
             * @Default {Horizontal}
             */
            orientation?: ej.Orientation|string;

            /** Specifies the query to retrieve the data from the online server. The query is used only when the online dataSource is used.
             * @Default {null}
             */
            query?: any;

            /** Specifies the Toolbar responsive type.
             * @Default {Popup}
             */
            responsiveType?: ej.Toolbar.ResponsiveType|string;

            /** Displays the Toolbar with rounded corners.
             * @Default {false}
             */
            showRoundedCorner?: boolean;

            /** Specifies the width of the Toolbar.
             */
            width?: number|string;

            /** Fires after Toolbar control is clicked.
             */
            click?(e: ClickEventArgs): void;

            /** Fires after Toolbar control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires after Toolbar control is focused.
             */
            focusOut?(e: FocusOutEventArgs): void;

            /** Fires when the Toolbar is destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires after Toolbar control item is hovered.
             */
            itemHover?(e: ItemHoverEventArgs): void;

            /** Fires after mouse leave from Toolbar control item.
             */
            itemLeave?(e: ItemLeaveEventArgs): void;

            /** Fires when the overflow popup of toolbar is opened.
             */
            overflowOpen?(e: OverflowOpenEventArgs): void;

            /** Fires when the overflow popup of toolbar is closed.
             */
            overflowClose?(e: OverflowCloseEventArgs): void;
        }

        export interface ClickEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Toolbar model
             */
            model?: ej.Toolbar.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the target of the current object.
             */
            target?: any;

            /** returns the target of the current object.
             */
            currentTarget?: any;

            /** return the Toolbar state
             */
            status?: boolean;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Toolbar model
             */
            model?: ej.Toolbar.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface FocusOutEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Toolbar model
             */
            model?: ej.Toolbar.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Toolbar model
             */
            model?: ej.Toolbar.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface ItemHoverEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Toolbar model
             */
            model?: ej.Toolbar.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the target of the current object.
             */
            target?: any;

            /** returns the target of the current object.
             */
            currentTarget?: any;

            /** return the Toolbar state
             */
            status?: boolean;
        }

        export interface ItemLeaveEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Toolbar model
             */
            model?: ej.Toolbar.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the target of the current object.
             */
            target?: any;

            /** returns the target of the current object.
             */
            currentTarget?: any;

            /** return the Toolbar state
             */
            status?: boolean;
        }

        export interface OverflowOpenEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Toolbar model
             */
            model?: ej.Toolbar.Model;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the current  X position of the target .
             */
            clientX?: number;

            /** Returns the current  Y position of the target .
             */
            clientY?: number;

            /** returns the target of the current object.
             */
            currentTarget?: any;
        }

        export interface OverflowCloseEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Toolbar model
             */
            model?: ej.Toolbar.Model;

            /** returns the name of the event
             */
            type?: string;

            /** Returns the current  X position of the target .
             */
            clientX?: number;

            /** Returns the current  Y position of the target .
             */
            clientY?: number;

            /** returns the target of the current object.
             */
            currentTarget?: any;
        }

        export interface Fields {

            /** Defines the group name for the item.
             */
            group?: string;

            /** Defines the HTML attributes such as id, class, styles for the item to extend the capability.
             */
            htmlAttributes?: any;

            /** Defines id for the tag.
             */
            id?: string;

            /** Defines the image attributes such as height, width, styles and so on.
             */
            imageAttributes?: string;

            /** Defines the imageURL for the image location.
             */
            imageUrl?: string;

            /** Defines the sprite CSS for the image tag.
             */
            spriteCssClass?: string;

            /** Defines the text content for the tag.
             */
            text?: string;

            /** Defines the tooltip text for the tag.
             */
            tooltipText?: string;

            /** Allows you to add  template as toolbar item
             */
            template?: string;
        }

        export interface Items {

            /** Defines the group name for the item.
             */
            group?: string;

            /** Defines the HTML attributes such as id, class, styles for the item .
             */
            htmlAttributes?: any;

            /** Defines id for the tag.
             */
            id?: string;

            /** Defines the image attributes such as height, width, styles and so on.
             */
            imageAttributes?: string;

            /** Defines the imageURL for the image location.
             */
            imageUrl?: string;

            /** Defines the sprite CSS for the image tag.
             */
            spriteCssClass?: string;

            /** Defines the text content for the tag.
             */
            text?: string;

            /** Defines the tooltip text for the tag.
             */
            tooltipText?: string;

            /** Allows to add template as toolbar item.
             */
            template?: string;
        }

        enum ResponsiveType {

            ///To display the toolbar overflow items as popup
            Popup,

            ///To display the toolbar overflow items as inline toolbar
            Inline
        }

    }

    class TreeView extends ej.Widget {
        static fn: TreeView;
        constructor(element: JQuery | Element, options?: TreeView.Model);
        static Locale: any;
        model: TreeView.Model;
        defaults: TreeView.Model;

        /** To add a Node or collection of nodes in TreeView. If target tree node is specified, then the given nodes are added as child of target tree node, otherwise nodes are added in
         * TreeView.
         * @param {string|any} New node text or JSON object
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @param {boolean} Parent node will be prevented from auto expanding
         * @returns {void}
         */
        addNode(newNodeText: string|any, target: string|any, preventTargetExpand: boolean): void;

        /** To add a collection of nodes in TreeView. If target tree node is specified, then the given nodes are added as child of target tree node, otherwise nodes are added in TreeView.
         * @param {any|any[]} New node details in JSON object
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @param {boolean} Parent node will be prevented from auto expanding
         * @returns {void}
         */
        addNodes(collection: any|any[], target: string|any, preventTargetExpand: boolean): void;

        /** To check all the nodes in TreeView.
         * @returns {void}
         */
        checkAll(): void;

        /** To check a node in TreeView.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        checkNode(element: string|any|any[]): void;

        /** This method is used to collapse all nodes in TreeView control. If you want to collapse all nodes up to the specific level in TreeView control then we need to pass levelUntil as
         * argument to this method.
         * @param {number} TreeView nodes will collapse until the given level
         * @param {boolean} Weather exclude the hidden nodes of TreeView while collapse all nodes
         * @returns {void}
         */
        collapseAll(levelUntil?: number, excludeHiddenNodes?: boolean): void;

        /** To collapse a particular node in TreeView.
         * @param {string|any|any[]} ID of TreeView node|object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        collapseNode(element: string|any|any[]): void;

        /** To disable the node in the TreeView.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        disableNode(element: string|any|any[]): void;

        /** To enable the node in the TreeView.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        enableNode(element: string|any|any[]): void;

        /** To ensure that the TreeView node is visible in the TreeView. This method is useful if we need select a TreeView node dynamically.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        ensureVisible(element: string|any): boolean;

        /** This method is used to expand all nodes in TreeView control. If you want to expand all nodes up to the specific level in TreeView control then we need to pass levelUntil as
         * argument to this method.
         * @param {number} TreeView nodes will expand until the given level
         * @param {boolean} Weather exclude the hidden nodes of TreeView while expand all nodes
         * @returns {void}
         */
        expandAll(levelUntil?: number, excludeHiddenNodes?: boolean): void;

        /** To expandNode particular node in TreeView.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        expandNode(element: string|any|any[]): void;

        /** To get currently checked nodes in TreeView.
         * @returns {any}
         */
        getCheckedNodes(): any;

        /** To get currently checked nodes indexes in TreeView.
         * @returns {any[]}
         */
        getCheckedNodesIndex(): any[];

        /** This method is used to get immediate child nodes of a node in TreeView control. If you want to get the all child nodes include nested child nodes then we need to pass
         * includeNestedChild as true along with element arguments to this method.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @param {boolean} Weather include nested child nodes of TreeView node
         * @returns {any[]}
         */
        getChildren(element: string|any, includeNestedChild?: boolean): any[];

        /** To get number of nodes in TreeView.
         * @returns {number}
         */
        getNodeCount(): number;

        /** To get currently expanded nodes in TreeView.
         * @returns {any}
         */
        getExpandedNodes(): any;

        /** To get currently expanded nodes indexes in TreeView.
         * @returns {any[]}
         */
        getExpandedNodesIndex(): any[];

        /** To get TreeView node by using index position in TreeView.
         * @param {number} Index position of TreeView node
         * @returns {any}
         */
        getNodeByIndex(index: number): any;

        /** To get TreeView node data such as id, text, parentId, selected, checked, expanded, level, childes and index.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {any}
         */
        getNode(element: string|any): any;

        /** To get current index position of TreeView node.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {number}
         */
        getNodeIndex(element: string|any): number;

        /** To get immediate parent TreeView node of particular TreeView node.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {any}
         */
        getParent(element: string|any): any;

        /** To get the currently selected node in TreeView.
         * @returns {any}
         */
        getSelectedNode(): any;

        /** To get the currently selected nodes in TreeView.
         * @returns {any[]}
         */
        getSelectedNodes(): any[];

        /** To get the index position of currently selected node in TreeView.
         * @returns {number}
         */
        getSelectedNodeIndex(): number;

        /** To get the index positions of currently selected nodes in TreeView.
         * @returns {any[]}
         */
        getSelectedNodesIndex(): any[];

        /** To get the text of a node in TreeView.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {string}
         */
        getText(element: string|any): string;

        /** To get the updated datasource of TreeView after performing some operation like drag and drop, node editing, adding and removing node.
         * @param {string|number} ID of TreeView node
         * @returns {any[]}
         */
        getTreeData(id?: string|number): any[];

        /** To get currently visible nodes in TreeView.
         * @returns {any}
         */
        getVisibleNodes(): any;

        /** To check a node having child or not.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        hasChildNode(element: string|any): boolean;

        /** To show nodes in TreeView.
         * @returns {void}
         */
        hide(): void;

        /** To hide particular node in TreeView.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        hideNode(element: string|any|any[]): void;

        /** To add a Node or collection of nodes after the particular TreeView node.
         * @param {string|any} New node text or JSON object
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {void}
         */
        insertAfter(newNodeText: string|any, target: string|any): void;

        /** To add a Node or collection of nodes before the particular TreeView node.
         * @param {string|any} New node text or JSON object
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {void}
         */
        insertBefore(newNodeText: string|any, target: string|any): void;

        /** To check the given TreeView node is checked or unchecked.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        isNodeChecked(element: string|any): boolean;

        /** To check whether the child nodes are loaded of the given TreeView node.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        isChildLoaded(element: string|any): boolean;

        /** To check the given TreeView node is disabled or enabled.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        isDisabled(element: string|any): boolean;

        /** To check the given node is exist in TreeView.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        isExist(element: string|any): boolean;

        /** To get the expand status of the given TreeView node.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        isExpanded(element: string|any): boolean;

        /** To get the select status of the given TreeView node.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        isSelected(element: string|any): boolean;

        /** To get the visibility status of the given TreeView node.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {boolean}
         */
        isVisible(element: string|any): boolean;

        /** To load the TreeView nodes from the particular URL. If target tree node is specified, then the given nodes are added as child of target tree node, otherwise nodes are added in
         * TreeView.
         * @param {string} URL location, the data returned from the URL will be loaded in TreeView
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @returns {void}
         */
        loadData(URL: string, target: string|any): void;

        /** To move the TreeView node with in same TreeView. The new position of given TreeView node will be based on destination node and index position.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @param {number} New index position of given source node
         * @returns {void}
         */
        moveNode(sourceNode: string|any, destinationNode: string|any, index: number): void;

        /** To refresh the TreeView
         * @returns {void}
         */
        refresh(): void;

        /** To remove all the nodes in TreeView.
         * @returns {void}
         */
        removeAll(): void;

        /** To remove a node in TreeView.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        removeNode(element: string|any|any[]): void;

        /** To select all the TreeView nodes when enable allowMultiSelection property.
         * @returns {void}
         */
        selectAll(): void;

        /** This method is used to select a node in TreeView control. If you want to select the collection of nodes in TreeView control then we need to enable allowMultiSelection property.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/ collection of ID/object of TreeView nodes
         * @returns {void}
         */
        selectNode(element: string|any|any[]): void;

        /** To show nodes in TreeView.
         * @returns {void}
         */
        show(): void;

        /** To show a node in TreeView.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        showNode(element: string|any|any[]): void;

        /** To uncheck all the nodes in TreeView.
         * @returns {void}
         */
        unCheckAll(): void;

        /** To uncheck a node in TreeView.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/collection of ID/object of TreeView nodes
         * @returns {void}
         */
        uncheckNode(element: string|any|any[]): void;

        /** To unselect all the TreeView nodes when enable allowMultiSelection property.
         * @returns {void}
         */
        unselectAll(): void;

        /** This method is used to unselect a node in TreeView control. If you want to unselect the collection of nodes in TreeView control then we need to enable allowMultiSelection property.
         * @param {string|any|any[]} ID of TreeView node/object of TreeView node/ collection of ID/object of TreeView nodes
         * @returns {void}
         */
        unselectNode(element: string|any|any[]): void;

        /** To edit or update the text of the TreeView node.
         * @param {string|any} ID of TreeView node/object of TreeView node
         * @param {string} New text
         * @returns {void}
         */
        updateText(target: string|any, newText: string): void;
    }
    export namespace TreeView {

        export interface Model {

            /** Gets or sets a value that indicates whether to enable drag and drop a node within the same tree.
             * @Default {false}
             */
            allowDragAndDrop?: boolean;

            /** Gets or sets a value that indicates whether to enable drag and drop a node in inter ej.TreeView.
             * @Default {true}
             */
            allowDragAndDropAcrossControl?: boolean;

            /** Gets or sets a value that indicates whether to drop a node to a sibling of particular node.
             * @Default {true}
             */
            allowDropSibling?: boolean;

            /** Gets or sets a value that indicates whether to drop a node to a child of particular node.
             * @Default {true}
             */
            allowDropChild?: boolean;

            /** Gets or sets a value that indicates whether to enable node editing support for TreeView.
             * @Default {false}
             */
            allowEditing?: boolean;

            /** Gets or sets a value that indicates whether to enable keyboard support for TreeView actions like nodeSelection, nodeEditing, nodeExpand, nodeCollapse, nodeCut and Paste.
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** Gets or sets a value that indicates whether to enable multi selection support for TreeView.
             * @Default {false}
             */
            allowMultiSelection?: boolean;

            /** Allow us to specify the parent and child nodes to get auto check while we check or uncheck a node.
             * @Default {true}
             */
            autoCheck?: boolean;

            /** Allow us to specify the parent node to be retain in checked or unchecked state instead of going for indeterminate state.
             * @Default {false}
             */
            autoCheckParentNode?: boolean;

            /** Gets or sets a value that indicates the checkedNodes index collection as an array. The given array index position denotes the nodes, that are checked while rendering TreeView.
             * @Default {[]}
             */
            checkedNodes?: any[];

            /** Sets the root CSS class for TreeView which allow us to customize the appearance.
             */
            cssClass?: string;

            /** Gets or sets a value that indicates whether to enable or disable the animation effect while expanding or collapsing a node.
             * @Default {true}
             */
            enableAnimation?: boolean;

            /** Gets or sets a value that indicates whether a TreeView can be enabled or disabled. No actions can be performed while this property is set as false
             * @Default {true}
             */
            enabled?: boolean;

            /** Allow us to prevent multiple nodes to be in expanded state. If it set to false, previously expanded node will be collapsed automatically, while we expand a node.
             * @Default {true}
             */
            enableMultipleExpand?: boolean;

            /** Sets a value that indicates whether to persist the TreeView model state in page using applicable medium i.e., HTML5 localStorage or cookies
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Gets or sets a value that indicates to align content in the TreeView control from right to left by setting the property as true.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Gets or sets a array of value that indicates the expandedNodes index collection as an array. The given array index position denotes the nodes, that are expanded while rendering
             * TreeView.
             * @Default {[]}
             */
            expandedNodes?: any[];

            /** Gets or sets a value that indicates the TreeView node can be expand or collapse by using the specified action.
             * @Default {dblclick}
             */
            expandOn?: string;

            /** Gets or sets a fields object that allow us to map the data members with field properties in order to make the data binding easier.
             * @Default {null}
             */
            fields?: Fields;

            /** Gets or sets a value that indicates whether to enable full row selection support for TreeView.
             * @Default {false}
             */
            fullRowSelect?: boolean;

            /** Defines the height of the TreeView.
             * @Default {Null}
             */
            height?: string|number;

            /** Specifies the HTML Attributes for the TreeView. Using this API we can add custom attributes in TreeView control.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Specifies the child nodes to be loaded on demand
             * @Default {false}
             */
            loadOnDemand?: boolean;

            /** Gets or Sets a value that indicates the index position of a tree node. The particular index tree node will be selected while rendering the TreeView.
             * @Default {-1}
             */
            selectedNode?: number;

            /** Gets or sets a value that indicates the selectedNodes index collection as an array. The given array index position denotes the nodes, that are selected while rendering TreeView.
             * @Default {[]}
             */
            selectedNodes?: any[];

            /** Gets or sets a value that indicates whether to display or hide checkbox for all TreeView nodes.
             * @Default {false}
             */
            showCheckbox?: boolean;

            /** By using sortSettings property, you can customize the sorting option in TreeView control.
             */
            sortSettings?: SortSettings;

            /** Allow us to use custom template in order to create TreeView.
             * @Default {null}
             */
            template?: string;

            /** Defines the width of the TreeView.
             * @Default {Null}
             */
            width?: string|number;

            /** Fires before adding node to TreeView.
             */
            beforeAdd?(e: BeforeAddEventArgs): void;

            /** Fires before collapse a node.
             */
            beforeCollapse?(e: BeforeCollapseEventArgs): void;

            /** Fires before cut node in TreeView.
             */
            beforeCut?(e: BeforeCutEventArgs): void;

            /** Fires before deleting node in TreeView.
             */
            beforeDelete?(e: BeforeDeleteEventArgs): void;

            /** Fires before editing the node in TreeView.
             */
            beforeEdit?(e: BeforeEditEventArgs): void;

            /** Fires before expanding the node.
             */
            beforeExpand?(e: BeforeExpandEventArgs): void;

            /** Fires before loading nodes to TreeView.
             */
            beforeLoad?(e: BeforeLoadEventArgs): void;

            /** Fires before paste node in TreeView.
             */
            beforePaste?(e: BeforePasteEventArgs): void;

            /** Fires before selecting node in TreeView.
             */
            beforeSelect?(e: BeforeSelectEventArgs): void;

            /** Fires when TreeView created successfully.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when TreeView destroyed successfully.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires before nodeEdit Successful.
             */
            inlineEditValidation?(e: InlineEditValidationEventArgs): void;

            /** Fires when key pressed successfully.
             */
            keyPress?(e: KeyPressEventArgs): void;

            /** Fires when data load fails.
             */
            loadError?(e: LoadErrorEventArgs): void;

            /** Fires when data loaded successfully.
             */
            loadSuccess?(e: LoadSuccessEventArgs): void;

            /** Fires once node added successfully.
             */
            nodeAdd?(e: NodeAddEventArgs): void;

            /** Fires once node checked successfully.
             */
            nodeCheck?(e: NodeCheckEventArgs): void;

            /** Fires when node clicked successfully.
             */
            nodeClick?(e: NodeClickEventArgs): void;

            /** Fires when node collapsed successfully.
             */
            nodeCollapse?(e: NodeCollapseEventArgs): void;

            /** Fires when node cut successfully.
             */
            nodeCut?(e: NodeCutEventArgs): void;

            /** Fires when node deleted successfully.
             */
            nodeDelete?(e: NodeDeleteEventArgs): void;

            /** Fires when node dragging.
             */
            nodeDrag?(e: NodeDragEventArgs): void;

            /** Fires once node drag start successfully.
             */
            nodeDragStart?(e: NodeDragStartEventArgs): void;

            /** Fires before the dragged node to be dropped.
             */
            nodeDragStop?(e: NodeDragStopEventArgs): void;

            /** Fires once node dropped successfully.
             */
            nodeDropped?(e: NodeDroppedEventArgs): void;

            /** Fires once node edited successfully.
             */
            nodeEdit?(e: NodeEditEventArgs): void;

            /** Fires once node expanded successfully.
             */
            nodeExpand?(e: NodeExpandEventArgs): void;

            /** Fires once node pasted successfully.
             */
            nodePaste?(e: NodePasteEventArgs): void;

            /** Fires when node selected successfully.
             */
            nodeSelect?(e: NodeSelectEventArgs): void;

            /** Fires once node unchecked successfully.
             */
            nodeUncheck?(e: NodeUncheckEventArgs): void;

            /** Fires once node unselected successfully.
             */
            nodeUnselect?(e: NodeUnselectEventArgs): void;

            /** Fires when TreeView nodes are loaded successfully
             */
            ready?(e: ReadyEventArgs): void;
        }

        export interface BeforeAddEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the given new node data
             */
            data?: string|any;

            /** returns the parent element, the given new nodes to be appended to the given parent element
             */
            targetParent?: any;

            /** returns the given parent node details
             */
            parentDetails?: any;
        }

        export interface BeforeCollapseEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the value of the node
             */
            value?: string;

            /** returns the current element of the node clicked
             */
            currentElement?: any;

            /** returns the child nodes are loaded or not
             */
            isChildLoaded?: boolean;

            /** returns the id of currently clicked node
             */
            id?: string;

            /** returns the parent id of currently clicked node
             */
            parentId?: string;

            /** returns the format asynchronous or synchronous
             */
            async?: boolean;
        }

        export interface BeforeCutEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the target element, the given node to be cut
             */
            target?: any;

            /** returns the given target node values
             */
            nodeDetails?: any;

            /** returns the key pressed key code value
             */
            keyCode?: number;
        }

        export interface BeforeDeleteEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the target element, the given node to be deleted
             */
            target?: any;

            /** returns the given target node values
             */
            nodeDetails?: any;

            /** returns the current parent element of the target node
             */
            parentElement?: any;

            /** returns the parent node values
             */
            parentDetails?: any;

            /** returns the currently removed nodes
             */
            removedNodes?: any[];
        }

        export interface BeforeEditEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the current element of the node clicked
             */
            currentElement?: any;
        }

        export interface BeforeExpandEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the value of the node
             */
            value?: string;

            /** if the child node is ready to expanded state; otherwise, false.
             */
            isChildLoaded?: boolean;

            /** returns the current element of the node clicked
             */
            currentElement?: any;

            /** returns the id of currently clicked node
             */
            id?: string;

            /** returns the parent id of currently clicked node
             */
            parentId?: string;

            /** returns the format asynchronous or synchronous
             */
            async?: boolean;
        }

        export interface BeforeLoadEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the AJAX settings object
             */
            AjaxOptions?: any;
        }

        export interface BeforePasteEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the target element, the given node to be pasted
             */
            target?: any;

            /** returns the given target node values
             */
            nodeDetails?: any;

            /** returns the key pressed key code value
             */
            keyCode?: number;
        }

        export interface BeforeSelectEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the target element, the given node to be selected
             */
            target?: any;

            /** returns the given target node values
             */
            nodeDetails?: any;
        }

        export interface CreateEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface InlineEditValidationEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the new entered text for the node
             */
            newText?: string;

            /** returns the current node element id
             */
            id?: any;

            /** returns the old node text
             */
            oldText?: string;
        }

        export interface KeyPressEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the current element of the node clicked
             */
            currentElement?: any;

            /** returns the value of the node
             */
            value?: string;

            /** returns node path from root element
             */
            path?: string;

            /** returns the key pressed key code value
             */
            keyCode?: number;

            /** it returns when the current node is in expanded state; otherwise, false.
             */
            isExpanded?: boolean;

            /** returns the id of current TreeView node
             */
            id?: string;

            /** returns the parentId of current TreeView node
             */
            parentId?: string;
        }

        export interface LoadErrorEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the AJAX error object
             */
            error?: any;
        }

        export interface LoadSuccessEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the success data from the URL
             */
            data?: any;

            /** returns the target parent element, the data returned from the URL to be appended to the given parent element, else in TreeView
             */
            targetParent?: any;

            /** returns the given parent node details
             */
            parentDetails?: any;
        }

        export interface NodeAddEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the added data, that are given initially
             */
            data?: any;

            /** returns the newly added elements
             */
            nodes?: any;

            /** returns the target parent element of the added element
             */
            parentElement?: any;

            /** returns the given parent node details
             */
            parentDetails?: any;
        }

        export interface NodeCheckEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the value of the node
             */
            value?: string;

            /** returns the id of the current element of the node clicked
             */
            id?: string;

            /** returns the id of the parent element of current element of the node clicked
             */
            parentId?: string;

            /** returns the current element of the node clicked
             */
            currentElement?: any;

            /** it returns true when the node checkbox is checked; otherwise, false.
             */
            isChecked?: boolean;

            /** it returns the currently checked node name
             */
            currentNode?: any[];

            /** it returns the currently checked and its child node details
             */
            currentCheckedNodes?: any[];
        }

        export interface NodeClickEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the current element of the node clicked
             */
            currentElement?: any;

            /** returns the id of currently clicked TreeView node
             */
            id?: string;

            /** returns the parentId of currently clicked TreeView node
             */
            parentId?: string;
        }

        export interface NodeCollapseEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the id of the current element of the node clicked
             */
            id?: string;

            /** returns the name of the event
             */
            type?: string;

            /** returns the id of the parent element of current element of the node clicked
             */
            parentId?: string;

            /** returns the value of the node
             */
            value?: string;

            /** returns the current element of the node clicked
             */
            currentElement?: any;

            /** returns the child nodes are loaded or not
             */
            isChildLoaded?: boolean;

            /** returns the format asynchronous or synchronous
             */
            async?: boolean;
        }

        export interface NodeCutEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the current parent element of the cut node
             */
            parentElement?: any;

            /** returns the given parent node details
             */
            parentDetails?: any;

            /** returns the key pressed key code value
             */
            keyCode?: number;
        }

        export interface NodeDeleteEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the current parent element of the deleted node
             */
            parentElement?: any;

            /** returns the given parent node details
             */
            parentDetails?: any;

            /** returns the currently removed nodes
             */
            removedNodes?: any[];
        }

        export interface NodeDragEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the original drag target
             */
            dragTarget?: any;

            /** returns the current target TreeView node
             */
            target?: any;

            /** returns the current target details
             */
            targetElementData?: any;

            /** returns the current parent element of the target node
             */
            draggedElement?: any;

            /** returns the given parent node details
             */
            draggedElementData?: any;

            /** returns the event object
             */
            event?: any;
        }

        export interface NodeDragStartEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the original drag target
             */
            dragTarget?: any;

            /** returns the current dragging parent TreeView node
             */
            parentElement?: any;

            /** returns the current dragging parent TreeView node details
             */
            parentElementData?: any;

            /** returns the current parent element of the dragging node
             */
            target?: any;

            /** returns the given parent node details
             */
            targetElementData?: any;

            /** returns the event object
             */
            event?: any;
        }

        export interface NodeDragStopEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the original drop target
             */
            dropTarget?: any;

            /** returns the current dragged TreeView node
             */
            draggedElement?: any;

            /** returns the current dragged TreeView node details
             */
            draggedElementData?: any;

            /** returns the current parent element of the dragged node
             */
            target?: any;

            /** returns the given parent node details
             */
            targetElementData?: any;

            /** returns the drop position such as before, after or over
             */
            position?: string;

            /** if it is true, the parent node will be prevented from auto expanding; otherwise, it work's usually
             */
            preventTargetExpand?: boolean;

            /** returns the event object
             */
            event?: any;
        }

        export interface NodeDroppedEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the original drop target
             */
            dropTarget?: any;

            /** returns the current dropped TreeView node
             */
            droppedElement?: any;

            /** returns the current dropped TreeView node details
             */
            droppedElementData?: any;

            /** returns the current parent element of the dropped node
             */
            target?: any;

            /** returns the given parent node details
             */
            targetElementData?: any;

            /** returns the drop position such as before, after or over
             */
            position?: string;

            /** returns the event object
             */
            event?: any;
        }

        export interface NodeEditEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the id of the element
             */
            id?: string;

            /** returns the oldText of the element
             */
            oldText?: string;

            /** returns the newText of the element
             */
            newText?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the target element, the given node to be cut
             */
            target?: any;

            /** returns the given target node values
             */
            nodeDetails?: any;
        }

        export interface NodeExpandEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the value of the node
             */
            value?: string;

            /** if the child node is ready to expanded state; otherwise, false.
             */
            isChildLoaded?: boolean;

            /** returns the current element of the node clicked
             */
            currentElement?: any;

            /** returns the id of currently clicked node
             */
            id?: string;

            /** returns the parent id of currently clicked node
             */
            parentId?: string;

            /** returns the format asynchronous or synchronous
             */
            async?: boolean;
        }

        export interface NodePasteEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the pasted element
             */
            target?: any;

            /** returns the given target node values
             */
            nodeDetails?: any;

            /** returns the key pressed key code value
             */
            keyCode?: number;
        }

        export interface NodeSelectEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the id of the current element of the node clicked
             */
            id?: any;

            /** returns the id of the parent element of current element of the node clicked
             */
            parentId?: any;

            /** returns the current selected nodes index of TreeView
             */
            selectedNodes?: any[];

            /** returns the value of the node
             */
            value?: string;

            /** returns the current element of the node clicked
             */
            currentElement?: any;
        }

        export interface NodeUncheckEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;

            /** returns the event object
             */
            event?: any;

            /** returns the id of the current element of the node clicked
             */
            id?: any;

            /** returns the id of the parent element of current element of the node clicked
             */
            parentId?: any;

            /** returns the value of the node
             */
            value?: string;

            /** returns the current element of the node clicked
             */
            currentElement?: any;

            /** it returns true when the node checkbox is checked; otherwise, false.
             */
            isChecked?: boolean;

            /** it returns currently unchecked node name
             */
            currentNode?: string;

            /** it returns currently unchecked node and its child node details.
             */
            currentUncheckedNodes?: any[];
        }

        export interface NodeUnselectEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the current element of the node unselected
             */
            currentElement?: any;

            /** returns the id of the current element of the node unselected
             */
            id?: string;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the id of the parent element of current element of the node unselected
             */
            parentId?: string;

            /** returns the current selected nodes index of TreeView
             */
            selectedNodes?: any[];

            /** returns the name of the event
             */
            type?: string;

            /** returns the value of the node
             */
            value?: string;
        }

        export interface ReadyEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the TreeView model
             */
            model?: ej.TreeView.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface Fields {

            /** It receives the child level or inner level data source such as Essential DataManager object and JSON object.
             */
            child?: any;

            /** It receives Essential DataManager object and JSON object.
             */
            dataSource?: any;

            /** Specifies the node to be in expanded state.
             */
            expanded?: string;

            /** Its allow us to indicate whether the node has child or not in load on demand
             */
            hasChild?: string;

            /** Specifies the HTML Attributes to &quot;li&quot; item list.
             */
            htmlAttribute?: any;

            /** Specifies the id to TreeView node items list.
             */
            id?: string;

            /** Specifies the image attribute to â€œimgâ€ tag inside items list
             */
            imageAttribute?: any;

            /** Specifies the HTML Attributes to &quot;li&quot; item list.
             */
            imageUrl?: string;

            /** If its true Checkbox node will be checked when rendered with checkbox.
             */
            isChecked?: string;

            /** Specifies the link attribute to â€œaâ€ tag in item list.
             */
            linkAttribute?: any;

            /** Specifies the parent id of the node. The nodes are listed as child nodes of the specified parent node by using its parent id.
             */
            parentId?: string;

            /** It receives query to retrieve data from the table (query is same as SQL).
             */
            query?: any;

            /** Allow us to specify the node to be in selected state
             */
            selected?: string;

            /** Specifies the sprite CSS class to &quot;li&quot; item list.
             */
            spriteCssClass?: string;

            /** It receives the table name to execute query on the corresponding table.
             */
            tableName?: string;

            /** Specifies the text of TreeView node items list.
             */
            text?: string;
        }

        export interface SortSettings {

            /** Enables or disables the sorting option in TreeView control
             * @Default {false}
             */
            allowSorting?: boolean;

            /** Sets the sorting order type. There are two sorting types available, such as &quot;ascending&quot;, &quot;descending&quot;.
             * @Default {ej.sortOrder.Ascending}
             */
            sortOrder?: ej.sortOrder|string;
        }
    }
    enum sortOrder {
        //Enum for Ascending sort order
        Ascending,
        //Enum for Descending sort order
        Descending,
    }

    class Uploadbox extends ej.Widget {
        static fn: Uploadbox;
        constructor(element: JQuery | Element, options?: Uploadbox.Model);
        static Locale: any;
        model: Uploadbox.Model;
        defaults: Uploadbox.Model;

        /** The destroy method destroys the control and brings the control to a pre-init state. All the events of the Upload control is bound by using this._on unbinds automatically.
         * @returns {void}
         */
        destroy(): void;

        /** Disables the Uploadbox control
         * @returns {void}
         */
        disable(): void;

        /** Enables the Uploadbox control
         * @returns {void}
         */
        enable(): void;

        /** Refresh the Uploadbox control
         * @returns {void}
         */
        refresh(): void;

        /** Upload the selected files.
         * @returns {void}
         */
        upload(): void;
    }
    export namespace Uploadbox {

        export interface Model {

            /** Enables the file drag and drop support to the Uploadbox control.
             * @Default {false}
             */
            allowDragAndDrop?: boolean;

            /** Uploadbox supports both synchronous and asynchronous upload. This can be achieved by using the asyncUpload property.
             * @Default {true}
             */
            asyncUpload?: boolean;

            /** Uploadbox supports auto uploading of files after the file selection is done.
             * @Default {false}
             */
            autoUpload?: boolean;

            /** Sets the text for each action button.
             * @Default {{browse: Browse, upload: Upload, cancel: Cancel, close: Close}}
             */
            buttonText?: ButtonText;

            /** Sets the root class for the Uploadbox control theme. This cssClass API helps to use custom skinning option for the Uploadbox button and dialog content.
             */
            cssClass?: string;

            /** Specifies the custom file details in the dialog popup on initialization.
             * @Default {{ title:true, name:true, size:true, status:true, action:true}}
             */
            customFileDetails?: CustomFileDetails;

            /** Specifies the actions for dialog popup while initialization.
             * @Default {{ modal:false, closeOnComplete:false, content:null, drag:true}}
             */
            dialogAction?: DialogAction;

            /** Displays the Uploadbox dialog at the given X and Y positions. X: Dialog sets the left position value. Y: Dialog sets the top position value.
             * @Default {null}
             */
            dialogPosition?: any;

            /** Property for applying the text to the Dialog title and content headers.
             * @Default {{ title: Upload Box, name: Name, size: Size, status: Status}}
             */
            dialogText?: DialogText;

            /** The dropAreaText is displayed when the drag and drop support is enabled in the Uploadbox control.
             * @Default {Drop files or click to upload}
             */
            dropAreaText?: string;

            /** Specifies the dropAreaHeight when the drag and drop support is enabled in the Uploadbox control.
             * @Default {100%}
             */
            dropAreaHeight?: number|string;

            /** Specifies the dropAreaWidth when the drag and drop support is enabled in the Uploadbox control.
             * @Default {100%}
             */
            dropAreaWidth?: number|string;

            /** Based on the property value, Uploadbox is enabled or disabled.
             * @Default {true}
             */
            enabled?: boolean;

            /** Sets the right-to-left direction property for the Uploadbox control.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Only the files with the specified extension is allowed to upload. This is mentioned in the string format.
             */
            extensionsAllow?: string;

            /** Only the files with the specified extension is denied for upload. This is mentioned in the string format.
             */
            extensionsDeny?: string;

            /** Sets the maximum size limit for uploading the file. This is mentioned in the number format.
             * @Default {31457280}
             */
            fileSize?: number;

            /** Sets the height of the browse button.
             * @Default {35px}
             */
            height?: string;

            /** Specifies the list of HTML attributes to be added to uploadbox control.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Configures the culture data and sets the culture to the Uploadbox.
             * @Default {en-US}
             */
            locale?: string;

            /** Enables multiple file selection for upload.
             * @Default {true}
             */
            multipleFilesSelection?: boolean;

            /** You can push the file to the Uploadbox in the client-side of the XHR supported browsers alone.
             * @Default {null}
             */
            pushFile?: any;

            /** Specifies the remove action to be performed after the file uploading is completed. Here, mention the server address for removal.
             */
            removeUrl?: string;

            /** Specifies the save action to be performed after the file is pushed for uploading. Here, mention the server address to be saved.
             */
            saveUrl?: string;

            /** Enables the browse button support to the Uploadbox control.
             * @Default {true}
             */
            showBrowseButton?: boolean;

            /** Specifies the file details to be displayed when selected for uploading. This can be done when the showFileDetails is set to true.
             * @Default {true}
             */
            showFileDetails?: boolean;

            /** Specifies the file details to be displayed when selected for uploading. This can be done when the showFileDetails is set to true.
             * @Default {true}
             */
            showRoundedCorner?: boolean;

            /** Sets the name for the Uploadbox control. This API helps to Map the action in code behind to retrieve the files.
             */
            uploadName?: string;

            /** Sets the width of the browse button.
             * @Default {100px}
             */
            width?: string;

            /** Fires when the upload progress beforeSend.
             */
            beforeSend?(e: BeforeSendEventArgs): void;

            /** Fires when the upload progress begins.
             */
            begin?(e: BeginEventArgs): void;

            /** Fires when the upload progress is cancelled.
             */
            cancel?(e: CancelEventArgs): void;

            /** Fires when the file upload progress is completed.
             */
            complete?(e: CompleteEventArgs): void;

            /** Fires when the file upload progress is succeeded.
             */
            success?(e: SuccessEventArgs): void;

            /** Fires when the Uploadbox control is created.
             */
            create?(e: CreateEventArgs): void;

            /** Fires when the Uploadbox control is destroyed.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Fires when the Upload process ends in Error.
             */
            error?(e: ErrorEventArgs): void;

            /** Fires when the file is selected for upload successfully.
             */
            fileSelect?(e: FileSelectEventArgs): void;

            /** Fires when the file is uploading.
             */
            inProgress?(e: InProgressEventArgs): void;

            /** Fires when the uploaded file is removed successfully.
             */
            remove?(e: RemoveEventArgs): void;
        }

        export interface BeforeSendEventArgs {

            /** Selected FileList Object.
             */
            files?: any;

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Uploadbox model
             */
            model?: any;

            /** XHR-AJAX Object for reference.
             */
            xhr?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface BeginEventArgs {

            /** To pass additional information to the server.
             */
            data?: any;

            /** Selected FileList Object.
             */
            files?: any;

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface CancelEventArgs {

            /** Canceled FileList Object.
             */
            fileStatus?: any;

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface CompleteEventArgs {

            /** AJAX event argument for reference.
             */
            e?: any;

            /** Uploaded file list.
             */
            files?: any;

            /** response from the server.
             */
            responseText?: string;

            /** XHR-AJAX Object for reference.
             */
            xhr?: any;

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface SuccessEventArgs {

            /** response from the server.
             */
            responseText?: string;

            /** AJAX event argument for reference.
             */
            e?: any;

            /** successfully uploaded files list.
             */
            success?: any;

            /** Uploaded file list.
             */
            files?: any;

            /** XHR-AJAX Object for reference.
             */
            xhr?: any;

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface CreateEventArgs {

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface ErrorEventArgs {

            /** details about the error information.
             */
            error?: string;

            /** returns the name of the event.
             */
            type?: string;

            /** error event action details.
             */
            action?: string;

            /** returns the file details of the file uploaded
             */
            files?: any;
        }

        export interface FileSelectEventArgs {

            /** returns Selected FileList objects
             */
            files?: any;

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface InProgressEventArgs {

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** AJAX event argument for reference.
             */
            e?: any;

            /** returns Selected FileList objects
             */
            files?: any;

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the current progress percentage.
             */
            percentage?: any;

            /** returns the name of the event.
             */
            type?: string;
        }

        export interface RemoveEventArgs {

            /** returns the Uploadbox model
             */
            model?: any;

            /** returns the name of the event.
             */
            type?: string;

            /** returns the file details of the file object
             */
            fileStatus?: any;
        }

        export interface ButtonText {

            /** Sets the text for the browse button.
             */
            browse?: string;

            /** Sets the text for the cancel button.
             */
            cancel?: string;

            /** Sets the text for the close button.
             */
            Close?: string;

            /** Sets the text for the Upload button inside the dialog popup.
             */
            upload?: string;
        }

        export interface CustomFileDetails {

            /** Enables the file upload interactions like remove/cancel in File details of the dialog popup.
             */
            action?: boolean;

            /** Enables the name in the File details of the dialog popup.
             */
            name?: boolean;

            /** Enables or disables the File size details of the dialog popup.
             */
            size?: boolean;

            /** Enables or disables the file uploading status visibility in the dialog file details content.
             */
            status?: boolean;

            /** Enables the title in File details for the dialog popup.
             */
            title?: boolean;
        }

        export interface DialogAction {

            /** Once uploaded successfully, the dialog popup closes immediately.
             */
            closeOnComplete?: boolean;

            /** Sets the content container option to the Uploadbox dialog popup.
             */
            content?: string;

            /** Enables the drag option to the dialog popup.
             */
            drag?: boolean;

            /** Enables or disables the Uploadbox dialogâ€™s modal property to the dialog popup.
             */
            modal?: boolean;
        }

        export interface DialogText {

            /** Sets the uploaded fileâ€™s Name (header text) to the Dialog popup.
             */
            name?: string;

            /** Sets the upload file Size (header text) to the dialog popup.
             */
            size?: string;

            /** Sets the upload file Status (header text) to the dialog popup.
             */
            status?: string;

            /** Sets the title text of the dialog popup.
             */
            title?: string;
        }
    }

    class WaitingPopup extends ej.Widget {
        static fn: WaitingPopup;
        constructor(element: JQuery | Element, options?: WaitingPopup.Model);
        static Locale: any;
        model: WaitingPopup.Model;
        defaults: WaitingPopup.Model;

        /** To hide the waiting popup
         * @returns {void}
         */
        hide(): void;

        /** Refreshes the WaitingPopup control by resetting the pop-up panel position and content position
         * @returns {void}
         */
        refresh(): void;

        /** To show the waiting popup
         * @returns {void}
         */
        show(): void;
    }
    export namespace WaitingPopup {

        export interface Model {

            /** Sets the root class for the WaitingPopup control theme
             * @Default {null}
             */
            cssClass?: string;

            /** Specifies the list of HTML attributes to be added to waitingpopup control.
             * @Default {{}}
             */
            htmlAttributes?: any;

            /** Enables or disables the default loading icon.
             * @Default {true}
             */
            showImage?: boolean;

            /** Enables the visibility of the WaitingPopup control
             * @Default {false}
             */
            showOnInit?: boolean;

            /** Specified a selector for elements, within the container.
             * @Default {null}
             */
            target?: string;

            /** Waitingpopup element append to given container element.
             * @Default {null}
             */
            appendTo?: string;

            /** Loads HTML content inside the popup panel instead of the default icon
             * @Default {null}
             */
            template?: any;

            /** Sets the custom text in the pop-up panel to notify the waiting process
             * @Default {null}
             */
            text?: string;

            /** Fires after Create WaitingPopup successfully
             */
            create?(e: CreateEventArgs): void;

            /** Fires after Destroy WaitingPopup successfully
             */
            destroy?(e: DestroyEventArgs): void;
        }

        export interface CreateEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the WaitingPopup model
             */
            model?: ej.WaitingPopup.Model;

            /** returns the name of the event
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** returns the cancel option value
             */
            cancel?: boolean;

            /** returns the WaitingPopup model
             */
            model?: ej.WaitingPopup.Model;

            /** returns the name of the event
             */
            type?: string;
        }
    }

    class Grid extends ej.Widget {
        static fn: Grid;
        constructor(element: JQuery | Element, options?: Grid.Model);
        static Locale: any;
        model: Grid.Model;
        defaults: Grid.Model;

        /** Adds a grid model property which is to be ignored upon exporting.
         * @param {any[]} Pass the array of parameters which need to be ignored on exporting
         * @returns {void}
         */
        addIgnoreOnExport(propertyNames: any[]): void;

        /** Adds a grid model property which is to be ignored upon OnServerToolbarClick.
         * @param {any[]} Pass the array of parameters which need to be ignored on OnServerToolbarClick
         * @returns {void}
         */
        addIgnoreOnToolbarServerClick(propertyNames: any[]): void;

        /** Add a new record in grid control when allowAdding is set as true.Without passing parameters it will add empty row.
         * @param {any[]} Pass the array of added Records
         * @param {any[]} optionalIf we pass serverChange as true, send post to server side for server action.
         * @returns {void}
         */
        addRecord(data?: any[], serverChange?: any[]): void;

        /** Cancel the modified changes in grid control when edit mode is &quot;batch&quot;.
         * @returns {void}
         */
        batchCancel(): void;

        /** Save the modified changes to data source in grid control when edit mode is &quot;batch&quot;.
         * @returns {void}
         */
        batchSave(): void;

        /** Send a cancel request in grid.
         * @returns {void}
         */
        cancelEdit(): void;

        /** Send a cancel request to the edited cell in grid.
         * @returns {void}
         */
        cancelEditCell(): void;

        /** Returns the total page size need to be displayed in grid based on the given container height. This method will also work when the property allowTextWrap as true only when wrap
         * mode is header.
         * @param {number} When passing the container height as integer or percentage, it will returns the page size that need to be displayed for grid.
         * @returns {number}
         */
        calculatePageSizeByParentHeight(containerHeight: number): number;

        /** It is used to change the number of records displayed per page in grid based on the given page size.
         * @param {number} When passing the page size, it will change the number of records displayed per page in grid.
         * @returns {void}
         */
        changePageSize(pageSize: number): void;

        /** It is used to clear all the cell selection.
         * @returns {boolean}
         */
        clearCellSelection(): boolean;

        /** It is used to clear specified cell selection based on the rowIndex and columnIndex provided.
         * @param {number} It is used to pass the row index of the cell
         * @param {number} It is used to pass the column index of the cell.
         * @returns {boolean}
         */
        clearCellSelection(rowIndex: number, columnIndex: number): boolean;

        /** It is used to clear all the row selection or at specific row selection based on the index provided.
         * @param {number} optional If index of the column is specified then it will remove the selection from the particular column else it will clears all of the column selection
         * @returns {boolean}
         */
        clearColumnSelection(index?: number): boolean;

        /** It is used to clear all the filtering done.
         * @param {string}  If field of the column is specified then it will clear the  particular filtering column
         * @returns {void}
         */
        clearFiltering(field: string): void;

        /** Clear the searching from the grid
         * @returns {void}
         */
        clearSearching(): void;

        /** Clear all the row selection or at specific row selection based on the index provided
         * @param {number} optional If index of the row is specified then it will remove the selection from the particular row else it will clears all of the row selection
         * @returns {boolean}
         */
        clearSelection(index?: number): boolean;

        /** Clear the sorting from columns in the grid
         * @returns {void}
         */
        clearSorting(): void;

        /** Collapse all the group caption rows in grid
         * @returns {void}
         */
        collapseAll(): void;

        /** Collapse the group drop area in grid
         * @returns {void}
         */
        collapseGroupDropArea(): void;

        /** Add or remove columns in grid column collections
         * @param {any[]|string} Pass array of columns or string of field name to add/remove the column in grid
         * @param {string} optional Pass add/remove action to be performed. By default "add" action will perform
         * @returns {void}
         */
        columns(columnDetails: any[]|string, action?: string): void;

        /** Refresh the grid with new data source
         * @param {any} Pass new data source to the grid
         * @param {boolean} optional When templateRefresh is set true, both header and contents get refreshed
         * @returns {void}
         */
        dataSource(datasource: any, templateRefresh?: boolean): void;

        /** Delete a record in grid control when allowDeleting is set as true
         * @param {string} Pass the primary key field Name of the column
         * @param {any} Pass the JSON data of record need to be delete.
         * @returns {void}
         */
        deleteRecord(fieldName: string, data: any): void;

        /** Delete the row based on the given tr element in grid.
         * @param {JQuery} Pass the tr element in grid content to get its row index
         * @returns {HTMLElement}
         */
        deleteRow($tr: JQuery): HTMLElement;

        /** Destroy the grid widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** Edit a particular cell based on the row index and field name provided in &quot;batch&quot; edit mode.
         * @param {number} Pass row index to edit particular cell
         * @param {string} Pass the field name of the column to perform batch edit
         * @returns {void}
         */
        editCell(index: number, fieldName: string): void;

        /** It returns a value and if the input field values of edit form is not based on the validation rules then it will show the validation message.
         * @returns {boolean}
         */
        editFormValidate(): boolean;

        /** Send a save request in grid.
         * @returns {void}
         */
        endEdit(): void;

        /** Expand all the group caption rows in grid.
         * @returns {void}
         */
        expandAll(): void;

        /** Expand or collapse the row based on the row state in grid
         * @param {JQuery} Pass the target object to expand/collapse the row based on its row state
         * @returns {void}
         */
        expandCollapse($target: JQuery): void;

        /** Expand the group drop area in grid.
         * @returns {void}
         */
        expandGroupDropArea(): void;

        /** Export the grid content to excel, word or PDF document.
         * @param {string} Pass the controller action name corresponding to exporting
         * @param {string} optionalASP server event name corresponding to exporting
         * @param {boolean} optionalPass the multiple exporting value as true/false
         * @param {any[]} optionalPass the array of the gridIds to be filtered
         * @returns {void}
         */
        export(action?: string, serverEvent?: string, multipleExport?: boolean, gridIds?: any[]): void;

        /** Send a filtering request to filter one column in grid.
         * @param {any[]|string} Pass the field name of the column
         * @param {string} string/integer/dateTime operator
         * @param {string} Pass the value to be filtered in a column
         * @param {string} Pass the predicate as and/or
         * @param {boolean} optional Pass the match case value as true/false
         * @param {any} optionalactualFilterValue denote the filter object of current filtered columns.Pass the value to filtered in a column
         * @returns {void}
         */
        filterColumn(fieldName: any[]|string, filterOperator: string, filterValue: string, predicate: string, matchcase?: boolean, actualFilterValue?: any): void;

        /** Send a filtering request to filter single or multiple column in grid.
         * @param {any[]} Pass array of filterColumn query for performing filter operation
         * @returns {void}
         */
        filterColumn(filterQueries: any[]): void;

        /** Get the batch changes of edit, delete and add operations of grid.
         * @returns {any}
         */
        getBatchChanges(): any;

        /** Get the browser details
         * @returns {any}
         */
        getBrowserDetails(): any;

        /** Get the column details based on the given field in grid
         * @param {string} Pass the field name of the column to get the corresponding column object
         * @returns {any}
         */
        getColumnByField(fieldName: string): any;

        /** Get the column details based on the given header text in grid.
         * @param {string} Pass the header text of the column to get the corresponding column object
         * @returns {any}
         */
        getColumnByHeaderText(headerText: string): any;

        /** Get the column details based on the given column index in grid
         * @param {number} Pass the index of the column to get the corresponding column object
         * @returns {any}
         */
        getColumnByIndex(columnIndex: number): any;

        /** Get the list of field names from column collection in grid.
         * @returns {any[]}
         */
        getColumnFieldNames(): any[];

        /** Get the column index of the given field in grid.
         * @param {string} Pass the field name of the column to get the corresponding column index
         * @returns {number}
         */
        getColumnIndexByField(fieldName: string): number;

        /** Get the column index of the given headerText of column in grid.
         * @param {string} Pass the headerText of the column to get that column index
         * @param {string} optionalOptional Pass the field name of the column.
         * @returns {number}
         */
        getColumnIndexByHeaderText(headerText: string, field?: string): number;

        /** Get the content div element of grid.
         * @returns {HTMLElement}
         */
        getContent(): HTMLElement;

        /** Get the content table element of grid
         * @returns {HTMLTableElement[]}
         */
        getContentTable(): HTMLTableElement[];

        /** Get the data of currently edited cell value in &quot;batch&quot; edit mode
         * @returns {any}
         */
        getCurrentEditCellData(): any;

        /** Get the current page index in grid pager.
         * @returns {number}
         */
        getCurrentIndex(): number;

        /** Get the current page data source of grid.
         * @returns {any[]}
         */
        getCurrentViewData(): any[];

        /** Get the data of given row index in grid.
         * @returns {any}
         */
        getDataByIndex(): any;

        /** Get the column field name from the given header text in grid.
         * @param {string} Pass header text of the column to get its corresponding field name
         * @returns {string}
         */
        getFieldNameByHeaderText(headerText: string): string;

        /** Get the filter bar of grid
         * @returns {HTMLElement}
         */
        getFilterBar(): HTMLElement;

        /** Get the records filtered or searched in Grid
         * @returns {any[]}
         */
        getFilteredRecords(): any[];

        /** Get the footer content of grid.
         * @returns {HTMLElement}
         */
        getFooterContent(): HTMLElement;

        /** Get the footer table element of grid.
         * @returns {HTMLElement}
         */
        getFooterTable(): HTMLElement;

        /** Get the header content div element of grid.
         * @returns {HTMLElement}
         */
        getHeaderContent(): HTMLElement;

        /** Get the header table element of grid
         * @returns {HTMLElement}
         */
        getHeaderTable(): HTMLElement;

        /** Get the column header text from the given field name in grid.
         * @param {string} Pass field name of the column to get its corresponding header text
         * @returns {string}
         */
        getHeaderTextByFieldName(field: string): string;

        /** Get the names of all the hidden column collections in grid.
         * @returns {any[]}
         */
        getHiddenColumnNames(): any[];

        /** Get the row index based on the given tr element in grid.
         * @param {JQuery} Pass the tr element in grid content to get its row index
         * @returns {number}
         */
        getIndexByRow($tr: JQuery): number;

        /** Get the pager of grid.
         * @returns {HTMLElement}
         */
        getPager(): HTMLElement;

        /** Get the names of primary key columns in Grid
         * @returns {any[]}
         */
        getPrimaryKeyFieldNames(): any[];

        /** Get the rows(tr element) from the given from and to row index in grid
         * @param {number} Pass the from index from which the rows to be returned
         * @param {number} Pass the to index to which the rows to be returned
         * @returns {HTMLElement}
         */
        getRowByIndex(from: number, to: number): HTMLElement;

        /** Get the row height of grid.
         * @returns {number}
         */
        getRowHeight(): number;

        /** Get the rows(tr element)of grid which is displayed in the current page.
         * @returns {HTMLElement}
         */
        getRows(): HTMLElement;

        /** Get the scroller object of grid.
         * @returns {ej.Scroller}
         */
        getScrollObject(): ej.Scroller;

        /** Get the selected records details in grid.
         * @returns {any[]}
         */
        getSelectedRecords(): any[];

        /** Get the selected row element details in grid.
         * @returns {any[]}
         */
        getSelectedRows(): any[];

        /** It accepts the string value and returns the field and sorted direction of the column in grid.
         * @param {string} Pass the field of the column to get the sorted direction of the corresponding column in Grid.
         * @returns {number}
         */
        getsortColumnByField(field: string): number;

        /** Get the calculated summary values of JSON data passed to it
         * @param {any} Pass Summary Column details
         * @param {any} Pass JSON Array for which its field values to be calculated
         * @returns {number}
         */
        getSummaryValues(summaryCol: any, summaryData: any): number;

        /** Get the names of all the visible column collections in grid
         * @returns {any[]}
         */
        getVisibleColumnNames(): any[];

        /** Send a paging request to specified page in grid
         * @param {number} Pass the page index to perform paging at specified page index
         * @returns {void}
         */
        gotoPage(pageIndex: number): void;

        /** Send a column grouping request in grid.
         * @param {string} Pass the field Name of the column to be grouped in grid control
         * @returns {void}
         */
        groupColumn(fieldName: string): void;

        /** Hide columns from the grid based on the header text
         * @param {any[]|string} you can pass either array of header text of various columns or a header text of a column to hide
         * @returns {void}
         */
        hideColumns(headerText: any[]|string): void;

        /** Print the grid control
         * @returns {void}
         */
        print(): void;

        /** It is used to refresh and reset the changes made in &quot;batch&quot; edit mode
         * @returns {void}
         */
        refreshBatchEditChanges(): void;

        /** It is used to refresh the grid header.
         * @returns {void}
         */
        refreshHeader(): void;

        /** Refresh the grid contents. The template refreshment is based on the argument passed along with this method
         * @param {boolean} optional When templateRefresh is set true, template and grid contents both are refreshed in grid else only grid content is refreshed
         * @returns {void}
         */
        refreshContent(templateRefresh?: boolean): void;

        /** Refresh the grid contents with updated server Data, using XMLHttpRequest. Url Path should be provided in Grid datasource otherwise it refreshes with local data without
         * XMLHttpRequest.
         * @param {any} optionalData to the server
         * @returns {void}
         */
        refreshData(additionalParameters?: any): void;

        /** Refresh the template of the grid
         * @returns {void}
         */
        refreshTemplate(): void;

        /** Refresh the toolbar items in grid.
         * @returns {void}
         */
        refreshToolbar(): void;

        /** Remove a column or collection of columns from a sorted column collections in grid.
         * @param {any[]|string} Pass array of field names of the columns to remove a collection of sorted columns or pass a string of field name to remove a column from sorted column
         * collections
         * @returns {void}
         */
        removeSortedColumns(fieldName: any[]|string): void;

        /** Creates a grid control
         * @returns {void}
         */
        render(): void;

        /** Re-order the column in grid
         * @param {string} Pass the from field name of the column needs to be changed
         * @param {string} Pass the to field name of the column needs to be changed
         * @returns {void}
         */
        reorderColumns(fromFieldName: string, toFieldName: string): void;

        /** Re-order the row in grid
         * @param {any[]} Pass the indexes of the rows needs to reorder.
         * @param {number} Pass the index of a row where to be reordered.
         * @returns {void}
         */
        reorderRows(indexes: any[], toIndex: number): void;

        /** Reset the model collections like pageSettings, groupSettings, filterSettings, sortSettings and summaryRows.
         * @returns {void}
         */
        resetModelCollections(): void;

        /** Resize the columns by giving column name and width for the corresponding one.
         * @param {string} Pass the column name that needs to be changed
         * @param {string} Pass the width to resize the particular columns
         * @returns {void}
         */
        resizeColumns(column: string, width: string): void;

        /** Resolves row height issue when unbound column is used with FrozenColumn
         * @returns {void}
         */
        rowHeightRefresh(): void;

        /** We can prevent the client side cellSave event triggering by passing the preventSaveEvent argument as true.Without argument it will save the particular edited grid cell.
         * @param {boolean} optionalIf we pass preventSaveEvent as true, it prevents the client side cellSave event triggering
         * @returns {void}
         */
        saveCell(preventSaveEvent?: boolean): void;

        /** Set dimension for grid with corresponding to grid parent.
         * @param {number} Pass the height of the grid container
         * @param {number} Pass the width of the grid container
         * @returns {void}
         */
        setDimension(height: number, width: number): void;

        /** Send a request to grid to refresh the width set to columns
         * @returns {void}
         */
        setWidthToColumns(): void;

        /** Send a search request to grid with specified string passed in it
         * @param {string} Pass the string to search in Grid records
         * @returns {void}
         */
        search(searchString: string): void;

        /** Select cells in grid.
         * @param {any} It is used to set the starting index of row and indexes of cells for that corresponding row for selecting cells.
         * @returns {void}
         */
        selectCells(rowCellIndexes: any): void;

        /** Select columns in grid.
         * @param {number} It is used to set the starting index of column for selecting columns.
         * @returns {void}
         */
        selectColumns(fromIndex: number): void;

        /** Select the specified columns in grid based on Index provided.
         * @param {number} It is used to set the starting index of column for selecting columns.
         * @param {number} optionalIt is used to set the ending index of column for selecting columns.
         * @returns {boolean}
         */
        selectColumns(columnIndex: number, toIndex?: number): boolean;

        /** Select rows in grid.
         * @param {number} It is used to set the starting index of row for selecting rows.
         * @param {number} It is used to set the ending index of row for selecting rows.
         * @returns {void}
         */
        selectRows(fromIndex: number, toIndex: number): void;

        /** Select specified rows in grid based on Index provided.
         * @param {any[]|number} It is used to set the starting index of row for selecting rows.
         * @param {number} optionalIt is used to set the ending index of row for selecting rows.
         * @param {any} optionalTarget element which is clicked.
         * @returns {void}
         */
        selectRows(from: any[]|number, to: number, target?: any): void;

        /** Select rows in grid.
         * @param {any[]} Pass array of rowIndexes for selecting rows
         * @returns {void}
         */
        selectRows(rowIndexes: any[]): void;

        /** Used to update a particular cell value.
         * @returns {void}
         */
        setCellText(): void;

        /** Used to update a particular cell value based on specified row Index and the fieldName.
         * @param {number} It is used to set the index for selecting the row.
         * @param {string} It is used to set the field name for selecting column.
         * @param {any} It is used to set the value for the selected cell.
         * @returns {void}
         */
        setCellValue(Index: number, fieldName: string, value: any): void;

        /** It sets the default data to the column in grid during adding record in batch edit mode.
         * @returns {void}
         */
        setDefaultData(): void;

        /** The grid rows has to be rendered as detail view in mobile mode based on given value.
         * @param {number} It is used to render grid rows as details view in mobile mode.
         * @returns {void}
         */
        setPhoneModeMaxWidth(Index: number): void;

        /** Set validation to edit form in the grid.
         * @returns {void}
         */
        setValidation(): void;

        /** Set validation to a particular input field in a edit form dynamically.
         * @param {string} Specify the field name of the column to set validation rules
         * @param {any} Specify the validation rules for the field
         * @returns {void}
         */
        setValidationToField(fieldName: string, rules: any): void;

        /** Show columns in the grid based on the header text
         * @param {any[]|string} you can pass either array of header text of various columns or a header text of a column to show
         * @returns {void}
         */
        showColumns(headerText: any[]|string): void;

        /** Send a sorting request in grid.
         * @param {string} Pass the field name of the column as columnName for which sorting have to be performed
         * @param {string} optional Pass the sort direction ascending/descending by which the column have to be sort. By default it is sorting in an ascending order
         * @returns {void}
         */
        sortColumn(columnName: string, sortingDirection?: string): void;

        /** Send an edit record request in grid
         * @param {JQuery} Pass the tr- selected row element to be edited in grid
         * @returns {void}
         */
        startEdit($tr: JQuery): void;

        /** Un-group a column from grouped columns collection in grid
         * @param {string} Pass the field Name of the column to be ungrouped from grouped column collection
         * @returns {void}
         */
        ungroupColumn(fieldName: string): void;

        /** Update a edited record in grid control when allowEditing is set as true.
         * @param {string} Pass the primary key field Name of the column
         * @param {any[]} Pass the edited JSON data of record need to be update.
         * @returns {void}
         */
        updateRecord(fieldName: string, data: any[]): void;

        /** It adapts grid to its parent element or to the browsers window.
         * @returns {void}
         */
        windowonresize(): void;
    }
    export namespace Grid {

        export interface Model {

            /** Gets or sets a value that indicates whether to customizing cell based on our needs.
             * @Default {false}
             */
            allowCellMerging?: boolean;

            /** Gets or sets a value that indicates whether to enable dynamic grouping behavior. Grouping can be done by drag on drop desired columns to gridâ€™s GroupDropArea. This can be
             * further customized through â€œgroupSettingsâ€ property.
             * @Default {false}
             */
            allowGrouping?: boolean;

            /** Gets or sets a value that indicates whether to enable keyboard support for performing grid actions. selectionType â€“ Gets or sets a value that indicates whether to enable single
             * row or multiple rows selection behavior in grid. Multiple selection can be done through by holding CTRL and clicking the grid rows
             * @Default {true}
             */
            allowKeyboardNavigation?: boolean;

            /** Gets or sets a value that indicates whether to enable dynamic filtering behavior on grid. Filtering can be used to limit the records displayed using required criteria and this can
             * be further customized through â€œfilterSettingsâ€ property
             * @Default {false}
             */
            allowFiltering?: boolean;

            /** Gets or sets a value that indicates whether to enable the dynamic sorting behavior on grid data. Sorting can be done through clicking on particular column header.
             * @Default {false}
             */
            allowSorting?: boolean;

            /** Gets or sets a value that indicates whether to enable multi columns sorting behavior in grid. Sort multiple columns by holding CTRL and click on the corresponding column header.
             * @Default {false}
             */
            allowMultiSorting?: boolean;

            /** This specifies the grid to show the paginated data. Also enables pager control at the bottom of grid for dynamic navigation through data source. Paging can be further customized
             * through â€œpageSettingsâ€ property.
             * @Default {false}
             */
            allowPaging?: boolean;

            /** Gets or sets a value that indicates whether to enable the columns reordering behavior in the grid. Reordering can be done through by drag and drop the particular column from one
             * index to another index within the grid.
             * @Default {false}
             */
            allowReordering?: boolean;

            /** Gets or sets a value that indicates whether the column is non resizable. Column width is set automatically based on the content or header text which is large.
             * @Default {false}
             */
            allowResizeToFit?: boolean;

            /** Gets or sets a value that indicates whether to enable dynamic resizable of columns. Resize the width of the columns by simply click and move the particular column header line
             * @Default {false}
             */
            allowResizing?: boolean;

            /** Gets or sets a value that indicates whether to enable the rows reordering in Grid and drag &amp; drop rows between multiple Grid.
             * @Default {false}
             */
            allowRowDragAndDrop?: boolean;

            /** Gets or sets a value that indicates whether to enable the scrollbar in the grid and view the records by scroll through the grid manually
             * @Default {false}
             */
            allowScrolling?: boolean;

            /** Gets or sets a value that indicates whether to enable dynamic searching behavior in grid. Currently search box can be enabled through â€œtoolbarSettingsâ€
             * @Default {false}
             */
            allowSearching?: boolean;

            /** Gets or sets a value that indicates whether user can select rows on grid. On enabling feature, selected row will be highlighted.
             * @Default {true}
             */
            allowSelection?: boolean;

            /** Gets or sets a value that indicates whether the Content will wrap to the next line if the content exceeds the boundary of the Column Cells.
             * @Default {false}
             */
            allowTextWrap?: boolean;

            /** Gets or sets a value that indicates whether to enable the multiple exporting behavior on grid data.
             * @Default {false}
             */
            allowMultipleExporting?: boolean;

            /** Gets or sets a value that indicates to define common width for all the columns in the grid.
             */
            commonWidth?: number;

            /** Gets or sets a value that indicates to enable the visibility of the grid lines.
             * @Default {ej.Grid.GridLines.Both}
             */
            gridLines?: ej.Grid.GridLines|string;

            /** This specifies the grid to add the grid control inside the grid row of the parent with expand/collapse options
             * @Default {null}
             */
            childGrid?: any;

            /** Used to enable or disable static width settings for column. If the columnLayout is set as fixed, then column width will be static.
             * @Default {ej.Grid.ColumnLayout.Auto}
             */
            columnLayout?: ej.Grid.ColumnLayout|string;

            /** Gets or sets an object that indicates to render the grid with specified columns
             * @Default {[]}
             */
            columns?: Column[];

            /** Gets or sets an object that indicates whether to customize the context menu behavior of the grid.
             */
            contextMenuSettings?: ContextMenuSettings;

            /** Gets or sets a value that indicates to render the grid with custom theme.
             */
            cssClass?: string;

            /** Gets or sets the data to render the grid with records
             * @Default {null}
             */
            dataSource?: any;

            /** Default Value:
             * @Default {null}
             */
            detailsTemplate?: string;

            /** Gets or sets an object that indicates whether to customize the editing behavior of the grid.
             */
            editSettings?: EditSettings;

            /** Gets or sets a value that indicates whether to enable the alternative rows differentiation in the grid records based on corresponding theme.
             * @Default {true}
             */
            enableAltRow?: boolean;

            /** Gets or sets a value that indicates whether to enable the save action in the grid through row selection
             * @Default {true}
             */
            enableAutoSaveOnSelectionChange?: boolean;

            /** Gets or sets a value that indicates whether to enable mouse over effect on the corresponding column header cell of the grid
             * @Default {false}
             */
            enableHeaderHover?: boolean;

            /** Gets or sets a value that indicates whether to persist the grid model state in page using applicable medium i.e., HTML5 localStorage or cookies
             * @Default {false}
             */
            enablePersistence?: boolean;

            /** Gets or sets a value that indicates whether the grid rows has to be rendered as detail view in mobile mode
             * @Default {false}
             */
            enableResponsiveRow?: boolean;

            /** Gets or sets a value that indicates whether to enable mouse over effect on corresponding grid row.
             * @Default {true}
             */
            enableRowHover?: boolean;

            /** Align content in the grid control from right to left by setting the property as true.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** To Disable the mouse swipe property as false.
             * @Default {true}
             */
            enableTouch?: boolean;

            /** It sets a value that indicates whether to enable toolbar items, when allowEditing, allowAdding and allowDeleting property set as false in the grid.
             * @Default {false}
             */
            enableToolbarItems?: boolean;

            /** Act as mapper for the excel exporting URL.
             * @Default {ExportToExcel}
             */
            exportToExcelAction?: string;

            /** Act as mapper for the PDF exporting URL.
             * @Default {ExportToPdf}
             */
            exportToPdfAction?: string;

            /** Act as mapper for the Word exporting URL.
             * @Default {ExportToWord}
             */
            exportToWordAction?: string;

            /** Gets or sets an object that indicates whether to customize the filtering behavior of the grid
             */
            filterSettings?: FilterSettings;

            /** Gets or sets an object that indicates whether to customize the grouping behavior of the grid.
             */
            groupSettings?: GroupSettings;

            /** Gets or sets a value that indicates whether the grid design has be to made responsive.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** This specifies to change the key in keyboard interaction to grid control
             * @Default {null}
             */
            keySettings?: any;

            /** Gets or sets a value that indicates whether to customizing the user interface (UI) as locale-specific in order to display regional data i.e. in a language and culture specific to
             * a particular country or region.
             * @Default {en-US}
             */
            locale?: string;

            /** Gets or sets a value that indicates whether to set the minimum width of the responsive grid while isResponsive property is true and enableResponsiveRow property is set as false.
             * @Default {0}
             */
            minWidth?: number;

            /** Gets or sets an object that indicates whether to modify the pager default configuration.
             */
            pageSettings?: PageSettings;

            /** Query the dataSource from the table for Grid.
             * @Default {null}
             */
            query?: any;

            /** Gets or sets an object that indicates whether to modify the resizing behavior.
             */
            resizeSettings?: ResizeSettings;

            /** Gets or sets a value that indicates to render the grid with template rows. The template row must be a table row. That table row must have the JavaScript render binding format
             * ({{:columnName}}) then the grid data source binds the data to the corresponding table row of the template.
             * @Default {null}
             */
            rowTemplate?: string;

            /** Gets or sets an object that indicates whether to customize the drag and drop behavior of the grid rows
             */
            rowDropSettings?: RowDropSettings;

            /** Gets or sets an object that indicates whether to customize the searching behavior of the grid
             */
            searchSettings?: SearchSettings;

            /** Gets a value that display the array of selected records in the Grid.
             * @Default {null}
             */
            selectedRecords?: any[];

            /** Gets or sets a value that indicates to select the row while initializing the grid
             * @Default {-1}
             */
            selectedRowIndex?: number;

            /** Gets or sets a value that indicates the selected rows in grid
             * @Default {[]}
             */
            selectedRowIndices?: any[];

            /** This property is used to configure the selection behavior of the grid.
             */
            selectionSettings?: SelectionSettings;

            /** The row selection behavior of grid. Accepting types are &quot;single&quot; and &quot;multiple&quot;.
             * @Default {ej.Grid.SelectionType.Single}
             */
            selectionType?: ej.Grid.SelectionType|string;

            /** Gets or sets an object that indicates whether to customize the scrolling behavior of the grid.
             */
            scrollSettings?: ScrollSettings;

            /** Default Value:
             * @Default {false}
             */
            showColumnChooser?: boolean;

            /** Gets or sets a value that indicates stacked header should be shown on grid layout when the property â€œstackedHeaderRowsâ€ is set.
             * @Default {false}
             */
            showStackedHeader?: boolean;

            /** Gets or sets a value that indicates summary rows should be shown on grid layout when the property â€œsummaryRowsâ€ is set
             * @Default {false}
             */
            showSummary?: boolean;

            /** Gets or sets a value that indicates whether to customize the sorting behavior of the grid.
             */
            sortSettings?: SortSettings;

            /** Gets or sets an object that indicates to managing the collection of stacked header rows for the grid.
             * @Default {[]}
             */
            stackedHeaderRows?: StackedHeaderRow[];

            /** Gets or sets an object that indicates to managing the collection of summary rows for the grid.
             * @Default {[]}
             */
            summaryRows?: SummaryRow[];

            /** Gets or sets an object that indicates whether to auto wrap the grid header or content or both
             */
            textWrapSettings?: TextWrapSettings;

            /** Gets or sets an object that indicates whether to enable the toolbar in the grid and add toolbar items
             */
            toolbarSettings?: ToolbarSettings;

            /** Triggered for every grid action before its starts.
             */
            actionBegin?(e: ActionBeginEventArgs): void;

            /** Triggered for every grid action success event.
             */
            actionComplete?(e: ActionCompleteEventArgs): void;

            /** Triggered for every grid action server failure event.
             */
            actionFailure?(e: ActionFailureEventArgs): void;

            /** Triggered when record batch add.
             */
            batchAdd?(e: BatchAddEventArgs): void;

            /** Triggered when record batch delete.
             */
            batchDelete?(e: BatchDeleteEventArgs): void;

            /** Triggered before the batch add.
             */
            beforeBatchAdd?(e: BeforeBatchAddEventArgs): void;

            /** Triggered before the batch delete.
             */
            beforeBatchDelete?(e: BeforeBatchDeleteEventArgs): void;

            /** Triggered before the batch save.
             */
            beforeBatchSave?(e: BeforeBatchSaveEventArgs): void;

            /** Triggered before the print.
             */
            beforePrint?(e: BeforePrintEventArgs): void;

            /** Triggered before row drop in the grid
             */
            beforeRowDrop?(e: BeforeRowDropEventArgs): void;

            /** Triggered before the record is going to be edited.
             */
            beginEdit?(e: BeginEditEventArgs): void;

            /** Triggered when record cell edit.
             */
            cellEdit?(e: CellEditEventArgs): void;

            /** Triggered when record cell save.
             */
            cellSave?(e: CellSaveEventArgs): void;

            /** Triggered after the cell is selected.
             */
            cellSelected?(e: CellSelectedEventArgs): void;

            /** Triggered before the cell is going to be selected.
             */
            cellSelecting?(e: CellSelectingEventArgs): void;

            /** Triggered after the cell is deselected.
             */
            cellDeselected?(e: CellDeselectedEventArgs): void;

            /** Triggered before the cell is going to be deselected.
             */
            cellDeselecting?(e: CellDeselectingEventArgs): void;

            /** Triggered when the column is being dragged.
             */
            columnDrag?(e: ColumnDragEventArgs): void;

            /** Triggered when column dragging begins.
             */
            columnDragStart?(e: ColumnDragStartEventArgs): void;

            /** Triggered when the column is dropped.
             */
            columnDrop?(e: ColumnDropEventArgs): void;

            /** Triggered after the column is selected.
             */
            columnSelected?(e: ColumnSelectedEventArgs): void;

            /** Triggered before the column is going to be selected.
             */
            columnSelecting?(e: ColumnSelectingEventArgs): void;

            /** Triggered after the column is deselected.
             */
            columnDeselected?(e: ColumnDeselectedEventArgs): void;

            /** Triggered before the column is going to be deselected.
             */
            columnDeselecting?(e: ColumnDeselectingEventArgs): void;

            /** Triggered when context menu item is clicked
             */
            contextClick?(e: ContextClickEventArgs): void;

            /** Triggered before the context menu is opened.
             */
            contextOpen?(e: ContextOpenEventArgs): void;

            /** Triggered when the grid is rendered completely.
             */
            create?(e: CreateEventArgs): void;

            /** Triggered when the grid is bound with data during initial rendering.
             */
            dataBound?(e: DataBoundEventArgs): void;

            /** Triggered when grid going to destroy.
             */
            destroy?(e: DestroyEventArgs): void;

            /** Triggered when detail template row is clicked to collapse.
             */
            detailsCollapse?(e: DetailsCollapseEventArgs): void;

            /** Triggered detail template row is initialized.
             */
            detailsDataBound?(e: DetailsDataBoundEventArgs): void;

            /** Triggered when detail template row is clicked to expand.
             */
            detailsExpand?(e: DetailsExpandEventArgs): void;

            /** Triggered after the record is added.
             */
            endAdd?(e: EndAddEventArgs): void;

            /** Triggered after the record is deleted.
             */
            endDelete?(e: EndDeleteEventArgs): void;

            /** Triggered after the record is edited.
             */
            endEdit?(e: EndEditEventArgs): void;

            /** Triggered initial load.
             */
            load?(e: LoadEventArgs): void;

            /** Triggered every time a request is made to access particular header cell information, element and data.
             */
            mergeHeaderCellInfo?(e: MergeHeaderCellInfoEventArgs): void;

            /** Triggered every time a request is made to access particular cell information, element and data.
             */
            mergeCellInfo?(e: MergeCellInfoEventArgs): void;

            /** Triggered every time a request is made to access particular cell information, element and data.
             */
            queryCellInfo?(e: QueryCellInfoEventArgs): void;

            /** Triggered when record is clicked.
             */
            recordClick?(e: RecordClickEventArgs): void;

            /** Triggered when record is double clicked.
             */
            recordDoubleClick?(e: RecordDoubleClickEventArgs): void;

            /** Triggered after column resized.
             */
            resized?(e: ResizedEventArgs): void;

            /** Triggered when column resize end.
             */
            resizeEnd?(e: ResizeEndEventArgs): void;

            /** Triggered when column resize start.
             */
            resizeStart?(e: ResizeStartEventArgs): void;

            /** Triggered when right clicked on grid element.
             */
            rightClick?(e: RightClickEventArgs): void;

            /** Triggered every time a request is made to access row information, element and data.
             */
            rowDataBound?(e: RowDataBoundEventArgs): void;

            /** Triggered after the row is selected.
             */
            rowSelected?(e: RowSelectedEventArgs): void;

            /** Triggered before the row is going to be selected.
             */
            rowSelecting?(e: RowSelectingEventArgs): void;

            /** Triggered after the row is deselected.
             */
            rowDeselected?(e: RowDeselectedEventArgs): void;

            /** Triggered before the row is going to be deselected.
             */
            rowDeselecting?(e: RowDeselectingEventArgs): void;

            /** Triggered when the row is being dragged.
             */
            rowDrag?(e: RowDragEventArgs): void;

            /** Triggered when row dragging begins.
             */
            rowDragStart?(e: RowDragStartEventArgs): void;

            /** Triggered when the row is dropped.
             */
            rowDrop?(e: RowDropEventArgs): void;

            /** Triggered while hover the grid row.
             */
            rowHover?(e: RowHoverEventArgs): void;

            /** Triggered when refresh the template column elements in the Grid.
             */
            templateRefresh?(e: TemplateRefreshEventArgs): void;

            /** Triggered when toolbar item is clicked in grid.
             */
            toolbarClick?(e: ToolbarClickEventArgs): void;
        }

        export interface ActionBeginEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the current selected page number.
             */
            currentPage?: number;

            /** Returns the previous selected page number.
             */
            previousPage?: number;

            /** Returns the end row index of that current page.
             */
            endIndex?: number;

            /** Returns request type.
             */
            requestType?: string;

            /** Returns the start row index of that current page.
             */
            startIndex?: number;

            /** Returns the current grouped column field name.
             */
            columnName?: string;

            /** Returns the column sort direction.
             */
            columnSortDirection?: string;

            /** Returns current edited row.
             */
            row?: any;

            /** Returns the current action event type.
             */
            originalEventType?: string;

            /** Returns primary key.
             */
            primaryKey?: string;

            /** Returns primary key value.
             */
            primaryKeyValue?: string;

            /** Returns the edited row index.
             */
            rowIndex?: number;

            /** Returns the record object (JSON).
             */
            data?: any;

            /** Returns the record object (JSON).
             */
            rowData?: any;

            /** Returns the foreign key record object (JSON).
             */
            foreignKeyData?: any;

            /** Returns the selected row index.
             */
            selectedRow?: number;

            /** Returns selected row for delete.
             */
            tr?: any;

            /** Returns current filtering column field name.
             */
            currentFilteringColumn?: any;

            /** Returns current filtering object.
             */
            currentFilterObject?: any;

            /** Returns filter details.
             */
            filterCollection?: any;

            /** Returns type of the column like number, string and so on.
             */
            columnType?: string;

            /** Returns the excel filter model.
             */
            filtermodel?: any;

            /** Returns the dataSource.
             */
            dataSource?: any;

            /** Returns the query manager.
             */
            query?: any;

            /** Returns the customfilter option value.
             */
            isCustomFilter?: boolean;
        }

        export interface ActionCompleteEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns request type.
             */
            requestType?: string;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the current selected page number.
             */
            currentPage?: number;

            /** Returns the previous selected page number.
             */
            previousPage?: number;

            /** Returns the end row index of that current page.
             */
            endIndex?: number;

            /** Returns current action event type.
             */
            originalEventType?: string;

            /** Returns the start row index of the current page.
             */
            startIndex?: number;

            /** Returns grid element.
             */
            target?: any;

            /** Returns the current sorted column field name.
             */
            columnName?: string;

            /** Returns the column sort direction.
             */
            columnSortDirection?: string;

            /** Returns current edited row.
             */
            row?: any;

            /** Returns primary key.
             */
            primaryKey?: string;

            /** Returns primary key value.
             */
            primaryKeyValue?: string;

            /** Returns the edited row index.
             */
            rowIndex?: number;

            /** Returns the record object (JSON).
             */
            data?: any;

            /** Returns the record object (JSON).
             */
            rowData?: any;

            /** Returns the selectedRow index.
             */
            selectedRow?: number;

            /** Returns the foreign key record object (JSON).
             */
            foreignKeyData?: any;

            /** Returns selected row for delete.
             */
            tr?: any;

            /** Returns current filtering column field name.
             */
            currentFilteringColumn?: string;

            /** Returns current filtering object.
             */
            currentFilterObject?: any;

            /** Returns filter details.
             */
            filterCollection?: any;

            /** Returns the dataSource.
             */
            dataSource?: any;

            /** Returns the excel filter model.
             */
            filtermodel?: any;

            /** Returns type of the column like number, string and so on.
             */
            columnType?: string;

            /** Returns the customfilter option value.
             */
            isCustomFilter?: boolean;
        }

        export interface ActionFailureEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns request type.
             */
            requestType?: string;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the error return by server.
             */
            error?: any;

            /** Returns the current selected page number.
             */
            currentPage?: number;

            /** Returns the previous selected page number.
             */
            previousPage?: number;

            /** Returns the end row index of that current page.
             */
            endIndex?: number;

            /** Returns current action event type.
             */
            originalEventType?: string;

            /** Returns the start row index of the current page.
             */
            startIndex?: number;

            /** Returns grid element.
             */
            target?: any;

            /** Returns the current sorted column field name.
             */
            columnName?: string;

            /** Returns the column sort direction.
             */
            columnSortDirection?: string;

            /** Returns current edited row.
             */
            row?: any;

            /** Returns primary key.
             */
            primaryKey?: string;

            /** Returns primary key value.
             */
            primaryKeyValue?: string;

            /** Returns the edited row index.
             */
            rowIndex?: number;

            /** Returns the record object (JSON).
             */
            data?: any;

            /** Returns the record object (JSON).
             */
            rowData?: any;

            /** Returns the selectedRow index.
             */
            selectedRow?: number;

            /** Returns the foreign key record object (JSON).
             */
            foreignKeyData?: any;

            /** Returns selected row for delete.
             */
            tr?: any;

            /** Returns current filtering column field name.
             */
            currentFilteringColumn?: string;

            /** Returns current filtering object.
             */
            currentFilterObject?: any;

            /** Returns filter details.
             */
            filterCollection?: any;
        }

        export interface BatchAddEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns deleted data.
             */
            defaultData?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the column object.
             */
            columnObject?: any;

            /** Returns the column index.
             */
            columnIndex?: number;

            /** Returns the row element.
             */
            row?: any;

            /** Returns the primaryKey.
             */
            primaryKey?: any;

            /** Returns the cell object.
             */
            cell?: any;
        }

        export interface BatchDeleteEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns deleted data.
             */
            rowData?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the primary key.
             */
            primaryKey?: any;

            /** Returns the row Index.
             */
            rowIndex?: number;
        }

        export interface BeforeBatchAddEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the default data object.
             */
            defaultData?: any;

            /** Returns the primaryKey.
             */
            primaryKey?: any;
        }

        export interface BeforeBatchDeleteEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns deleted data.
             */
            rowData?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the primaryKey.
             */
            primaryKey?: any;

            /** Returns the row index.
             */
            rowIndex?: number;

            /** Returns the row element.
             */
            row?: any;
        }

        export interface BeforeBatchSaveEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the changed record object.
             */
            batchChanges?: any;
        }

        export interface BeforePrintEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the Grid element.
             */
            element?: any;

            /** Returns the selected records.
             */
            selectedRows?: any;
        }

        export interface BeforeRowDropEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the targeted row.
             */
            target?: any;

            /** Returns the targeted row index.
             */
            targetIndex?: any;

            /** Returns the dragged record details
             */
            draggedRecords?: any;

            /** Returns the drop details
             */
            dropDetails?: any;
        }

        export interface BeginEditEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the current edited row.
             */
            row?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the primary key.
             */
            primaryKey?: any;

            /** Returns the primary key value.
             */
            primaryKeyValue?: any;

            /** Returns the edited row index.
             */
            rowIndex?: number;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CellEditEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the validation rules.
             */
            validationRules?: any;

            /** Returns the column name.
             */
            columnName?: string;

            /** Returns the cell value.
             */
            value?: string;

            /** Returns the row data object.
             */
            rowData?: any;

            /** Returns the previous value of the cell.
             */
            previousValue?: string;

            /** Returns the column object.
             */
            columnObject?: any;

            /** Returns the cell object.
             */
            cell?: any;

            /** Returns isForeignKey option value.
             */
            isForeignKey?: boolean;
        }

        export interface CellSaveEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the column name.
             */
            columnName?: string;

            /** Returns the cell value.
             */
            value?: string;

            /** Returns the row data object.
             */
            rowData?: any;

            /** Returns the previous value of the cell.
             */
            previousValue?: string;

            /** Returns the column object.
             */
            columnObject?: any;

            /** Returns the cell object.
             */
            cell?: any;

            /** Returns isForeignKey option value.
             */
            isForeignKey?: boolean;
        }

        export interface CellSelectedEventArgs {

            /** Returns the selected cell index value.
             */
            cellIndex?: number;

            /** Returns the previous selected cell index value.
             */
            previousRowCellIndex?: number;

            /** Returns the selected cell element.
             */
            currentCell?: any;

            /** Returns the previous selected cell element.
             */
            previousRowCell?: any;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            selectedData?: any;

            /** Returns the selected row cell index values.
             */
            selectedRowCellIndex?: any[];

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CellSelectingEventArgs {

            /** Returns the selected cell index value.
             */
            cellIndex?: number;

            /** Returns the previous selected cell index value.
             */
            previousRowCellIndex?: number;

            /** Returns the selected cell element.
             */
            currentCell?: any;

            /** Returns the previous selected cell element.
             */
            previousRowCell?: any;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            selectedData?: any;

            /** Returns whether the ctrl key is pressed while selecting cell
             */
            isCtrlKeyPressed?: boolean;

            /** Returns whether the shift key is pressed while selecting cell
             */
            isShiftKeyPressed?: boolean;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CellDeselectedEventArgs {

            /** Returns the deselected cell index value.
             */
            cellIndex?: number;

            /** Returns the deselected cell element.
             */
            currentCell?: any;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            selectedData?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CellDeselectingEventArgs {

            /** Returns the deselecting cell index value.
             */
            cellIndex?: number;

            /** Returns the deselecting cell element.
             */
            currentCell?: any;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            selectedData?: any;

            /** Returns whether the ctrl key is pressed while deselecting cell
             */
            isCtrlKeyPressed?: boolean;

            /** Returns whether the shift key is pressed while deselecting cell
             */
            isShiftKeyPressed?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ColumnDragEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns draggable element type.
             */
            draggableType?: any;

            /** Returns the draggable column object.
             */
            column?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns target elements based on mouse move position.
             */
            target?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ColumnDragStartEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns draggable element type.
             */
            draggableType?: any;

            /** Returns the draggable column object.
             */
            column?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns drag start element.
             */
            target?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ColumnDropEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns draggable element type.
             */
            draggableType?: string;

            /** Returns the draggable column object.
             */
            column?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns dropped dragged element.
             */
            target?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ColumnSelectedEventArgs {

            /** Returns the selected cell index value.
             */
            columnIndex?: number;

            /** Returns the previous selected column index value.
             */
            previousColumnIndex?: number;

            /** Returns the selected header cell element.
             */
            headerCell?: any;

            /** Returns the previous selected header cell element.
             */
            prevColumnHeaderCell?: any;

            /** Returns corresponding column object (JSON).
             */
            column?: any;

            /** Returns the selected columns values.
             */
            selectedColumnsIndex?: any[];

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ColumnSelectingEventArgs {

            /** Returns the selected column index value.
             */
            columnIndex?: number;

            /** Returns the previous selected column index value.
             */
            previousColumnIndex?: number;

            /** Returns the selected header cell element.
             */
            headerCell?: any;

            /** Returns the previous selected header cell element.
             */
            prevColumnHeaderCell?: any;

            /** Returns corresponding column object (JSON).
             */
            column?: any;

            /** Returns whether the ctrl key is pressed while selecting cell
             */
            isCtrlKeyPressed?: boolean;

            /** Returns whether the shift key is pressed while selecting cell
             */
            isShiftKeyPressed?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ColumnDeselectedEventArgs {

            /** Returns the Deselected column index value.
             */
            columnIndex?: number;

            /** Returns the Deselected column header element.
             */
            headerCell?: any;

            /** Returns corresponding column object (JSON).
             */
            column?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ColumnDeselectingEventArgs {

            /** Returns the deselecting column index value.
             */
            columnIndex?: number;

            /** Returns the deselecting column header element.
             */
            headerCell?: any;

            /** Returns corresponding column object (JSON).
             */
            column?: any;

            /** Returns whether the ctrl key is pressed while deselecting column
             */
            isCtrlKeyPressed?: boolean;

            /** Returns whether the shift key is pressed while deselecting column
             */
            isShiftKeyPressed?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ContextClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the current item.
             */
            currentTarget?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the status of contextmenu item which denotes its enabled state
             */
            status?: boolean;

            /** Returns the target item.
             */
            target?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ContextOpenEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the current item.
             */
            currentTarget?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the status of contextmenu item which denotes its enabled state
             */
            status?: boolean;

            /** Returns the target item.
             */
            target?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface CreateEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface DataBoundEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface DestroyEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface DetailsCollapseEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns detail row element.
             */
            detailsRow?: any;

            /** Returns master row of detail row record object (JSON).
             */
            masterData?: any;

            /** Returns the foreign key record object (JSON).
             */
            foreignKeyData?: any;

            /** Returns master row element.
             */
            masterRow?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface DetailsDataBoundEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns details row element.
             */
            detailsElement?: any;

            /** Returns the details row data.
             */
            data?: any;

            /** Returns the details row data.
             */
            rowData?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface DetailsExpandEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns detail row element.
             */
            detailsRow?: any;

            /** Returns master row of detail row record object (JSON).
             */
            masterData?: any;

            /** Returns the foreign key record object (JSON).
             */
            foreignKeyData?: any;

            /** Returns master row element.
             */
            masterRow?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface EndAddEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns added data.
             */
            data?: any;

            /** Returns added data.
             */
            rowData?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface EndDeleteEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns deleted data.
             */
            data?: any;

            /** Returns deleted data.
             */
            rowData?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface EndEditEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns modified data.
             */
            data?: any;

            /** Returns modified data.
             */
            rowData?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface LoadEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface MergeHeaderCellInfoEventArgs {

            /** Method to merge the header cells.
             */
            headerCellMerge?(startIndex:number,count:number): void

            /** Returns the column headers.
             */
            columnHeaders?: any;

            /** Returns the grid model.
             */
            model?: any;
        }

        export interface MergeCellInfoEventArgs {

            /** Returns grid cell.
             */
            cell?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current row record object (JSON).
             */
            data?: any;

            /** Returns current row record object (JSON).
             */
            rowData?: any;

            /** Returns the text value in the cell.
             */
            text?: string;

            /** Returns the column object.
             */
            column?: any;

            /** Method to merge Grid rows.
             */
            rowMerge?(): void;

            /** Method to merge Grid columns.
             */
            colMerge?(): void;

            /** Method to merge Grid rows and columns.
             */
            merge?(): void;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface QueryCellInfoEventArgs {

            /** Returns grid cell.
             */
            cell?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current row record object (JSON).
             */
            data?: any;

            /** Returns current row record object (JSON).
             */
            rowData?: any;

            /** Returns the text value in the cell.
             */
            text?: string;

            /** Returns the column object.
             */
            column?: any;

            /** Returns the foreign key record object (JSON).
             */
            foreignKeyData?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface RecordClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            rowData?: any;

            /** Returns the row index of the selected row.
             */
            rowIndex?: number;

            /** Returns the jQuery object of the current selected row.
             */
            row?: any;

            /** Returns the current selected cell.
             */
            cell?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the cell index value.
             */
            cellIndex?: number;

            /** Returns the corresponding cell value.
             */
            cellValue?: string;

            /** Returns the Header text of the column corresponding to the selected cell.
             */
            columnName?: string;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface RecordDoubleClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            rowData?: any;

            /** Returns the row index of the selected row.
             */
            rowIndex?: number;

            /** Returns the jQuery object of the current selected row.
             */
            row?: any;

            /** Returns the current selected cell.
             */
            cell?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the selected cell index value.
             */
            cellIndex?: number;

            /** Returns the corresponding cell value.
             */
            cellValue?: string;

            /** Returns the Header text of the column corresponding to the selected cell.
             */
            columnName?: string;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ResizedEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the column index.
             */
            columnIndex?: number;

            /** Returns the column object.
             */
            column?: any;

            /** Returns the grid object.
             */
            target?: any;

            /** Returns the old width value.
             */
            oldWidth?: number;

            /** Returns the new width value.
             */
            newWidth?: number;
        }

        export interface ResizeEndEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the column index.
             */
            columnIndex?: number;

            /** Returns the column object.
             */
            column?: any;

            /** Returns the grid object.
             */
            target?: any;

            /** Returns the old width value.
             */
            oldWidth?: number;

            /** Returns the new width value.
             */
            newWidth?: number;

            /** Returns the extra width value.
             */
            extra?: number;
        }

        export interface ResizeStartEventArgs {

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the column index.
             */
            columnIndex?: number;

            /** Returns the column object.
             */
            column?: any;

            /** Returns the grid object.
             */
            target?: any;

            /** Returns the old width value.
             */
            oldWidth?: number;
        }

        export interface RightClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current record object (JSON).
             */
            currentData?: any;

            /** Returns the row index of the selected row.
             */
            rowIndex?: number;

            /** Returns the current selected row.
             */
            row?: any;

            /** Returns the selected row data object.
             */
            data?: any;

            /** Returns the selected row data object.
             */
            rowData?: any;

            /** Returns the cell index of the selected cell.
             */
            cellIndex?: number;

            /** Returns the cell value.
             */
            cellValue?: string;

            /** Returns the cell object.
             */
            cell?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface RowDataBoundEventArgs {

            /** Returns grid row.
             */
            row?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current row record object (JSON).
             */
            data?: any;

            /** Returns current row record object (JSON).
             */
            rowData?: any;

            /** Returns the foreign key record object (JSON).
             */
            foreignKeyData?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface RowSelectedEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            selectedData?: any;

            /** Returns the foreign key record object (JSON).
             */
            foreignKeyData?: any;

            /** Returns the row index of the selected row.
             */
            rowIndex?: number;

            /** Returns the current selected row.
             */
            row?: any;

            /** Returns the previous selected row element.
             */
            prevRow?: any;

            /** Returns the previous selected row index.
             */
            prevRowIndex?: number;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface RowSelectingEventArgs {

            /** Returns the selected row index value.
             */
            rowIndex?: number;

            /** Returns the selected row element.
             */
            row?: any;

            /** Returns the previous selected row element.
             */
            prevRow?: any;

            /** Returns the previous selected row index.
             */
            prevRowIndex?: number;

            /** Returns current record object (JSON).
             */
            selectedData?: any;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface RowDeselectedEventArgs {

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            selectedData?: any;

            /** Returns the row index of the deselected row.
             */
            rowIndex?: number;

            /** Returns the current deselected row element.
             */
            row?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface RowDeselectingEventArgs {

            /** Returns the deselecting row index value.
             */
            rowIndex?: number;

            /** Returns the deselecting row element.
             */
            row?: any;

            /** Returns current record object (JSON).
             */
            data?: any;

            /** Returns current record object (JSON).
             */
            selectedData?: any;

            /** Returns whether the ctrl key is pressed while deselecting row
             */
            isCtrlKeyPressed?: boolean;

            /** Returns whether the shift key is pressed while deselecting row
             */
            isShiftKeyPressed?: boolean;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface RowDragEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns draggable element type.
             */
            draggableType?: any;

            /** Returns the draggable row object.
             */
            target?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns target elements based on mouse move position.
             */
            currentTarget?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns JSON data of dragged rows.
             */
            data?: any;

            /** Returns JSON data of dragged rows.
             */
            draggedRecords?: any;
        }

        export interface RowDragStartEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns draggable element type.
             */
            draggableType?: any;

            /** Returns the draggable row object.
             */
            target?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns drag start element cell.
             */
            currentTarget?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the JSON data of dragged rows.
             */
            data?: any;

            /** Returns the JSON data of dragged rows.
             */
            draggedRecords?: any;
        }

        export interface RowDropEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns draggable element type.
             */
            draggableType?: string;

            /** Returns the draggable row object.
             */
            rows?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the current mouse position cell element.
             */
            target?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the JSON data of dragged rows.
             */
            data?: any;

            /** Returns the JSON data of dragged rows.
             */
            droppedRecords?: any;
        }

        export interface RowHoverEventArgs {

            /** Returns the hovered row.
             */
            row?: any;

            /** Returns the hovered row index.
             */
            rowIndex?: any;

            /** Returns the hovered record details
             */
            rowData?: any;

            /** Returns the hovered row cell
             */
            cell?: any;
        }

        export interface TemplateRefreshEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the cell object.
             */
            cell?: any;

            /** Returns the column object.
             */
            column?: any;

            /** Returns the current row data.
             */
            data?: any;

            /** Returns the current row data.
             */
            rowData?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the current row index.
             */
            rowIndex?: number;

            /** Returns the name of the event.
             */
            type?: string;
        }

        export interface ToolbarClickEventArgs {

            /** Returns the cancel option value.
             */
            cancel?: boolean;

            /** Returns the current item.
             */
            currentTarget?: any;

            /** Returns the grid model.
             */
            model?: any;

            /** Returns the status of toolbar item which denotes its enabled state
             */
            status?: boolean;

            /** Returns the target item.
             */
            target?: any;

            /** Returns the name of the event.
             */
            type?: string;

            /** Returns the grid model.
             */
            gridModel?: any;

            /** Returns the toolbar object of the selected toolbar element.
             */
            toolbarData?: any;

            /** Returns the Id of the current toolbar element.
             */
            itemId?: string;

            /** Returns the index of the current toolbar element.
             */
            itemIndex?: number;

            /** Returns the name of the current toolbar element.
             */
            itemName?: string;
        }

        export interface ColumnsCommand {

            /** Gets or sets an object that indicates to define all the button options which are available in ejButton.
             */
            buttonOptions?: any;

            /** Gets or sets a value that indicates to add the command column button. See unboundType
             */
            type?: ej.Grid.UnboundType|string;
        }

        export interface Column {

            /** Sets the clip mode for Grid cell as ellipsis or clipped content(both header and content)
             * @Default {ej.Grid.ClipMode.Clip}
             */
            clipMode?: ej.Grid.ClipMode|string;

            /** Gets or sets a value that indicates whether to enable editing behavior for particular column.
             * @Default {true}
             */
            allowEditing?: boolean;

            /** Gets or sets a value that indicates whether to enable dynamic filtering behavior for particular column.
             * @Default {true}
             */
            allowFiltering?: boolean;

            /** Gets or sets a value that indicates whether to enable dynamic grouping behavior for particular column.
             * @Default {true}
             */
            allowGrouping?: boolean;

            /** Gets or sets a value that indicates whether to enable dynamic sorting behavior for particular column.
             * @Default {true}
             */
            allowSorting?: boolean;

            /** Gets or sets a value that indicates whether to enable dynamic resizable for particular column.
             * @Default {true}
             */
            allowResizing?: boolean;

            /** Gets or sets an object that indicates to define a command column in the grid.
             * @Default {[]}
             */
            commands?: ColumnsCommand[];

            /** Gets or sets a value that indicates to provide custom CSS for an individual column.
             */
            cssClass?: string;

            /** Gets or sets a value that indicates the attribute values to the td element of a particular column
             */
            customAttributes?: any;

            /** Gets or sets a value that indicates to bind the external datasource to the particular column when column editType as dropdownedit and also it is used to bind the datasource to the
             * foreign key column while editing the grid. //Where data is array of JSON objects of text and value for the drop-down and array of JSON objects for foreign key column.
             * @Default {null}
             */
            dataSource?: any;

            /** Gets or sets a value that indicates to display the specified default value while adding a new record to the grid
             */
            defaultValue?: string|number|boolean|Date;

            /** Gets or sets a value that indicates to render the grid content and header with an HTML elements
             * @Default {false}
             */
            disableHtmlEncode?: boolean;

            /** Gets or sets a value that indicates to display a column value as checkbox or string
             * @Default {true}
             */
            displayAsCheckbox?: boolean;

            /** Gets or sets a value that indicates to customize ejNumericTextbox of an editable column. See editingType
             */
            editParams?: any;

            /** Gets or sets a template that displays a custom editor used to edit column values. See editTemplate
             * @Default {null}
             */
            editTemplate?: any;

            /** Gets or sets a value that indicates to render the element(based on edit type) for editing the grid record. See editingType
             * @Default {ej.Grid.EditingType.String}
             */
            editType?: ej.Grid.EditingType|string;

            /** Gets or sets a value that indicates to groups the column based on its column format.
             * @Default {false}
             */
            enableGroupByFormat?: boolean;

            /** Gets or sets a value that indicates to display the columns in the grid mapping with column name of the dataSource.
             */
            field?: string;

            /** Gets or sets a template that customize the filter control from default . See filterBarTemplate
             * @Default {null}
             */
            filterBarTemplate?: any;

            /** Gets or sets a value that indicates to render the excel or menu filter dialog to the grid columns. See filterType
             * @Default {null}
             */
            filterType?: ej.Grid.FilterType|string;

            /** Gets or sets a value that indicates to define foreign key field name of the grid datasource.
             * @Default {null}
             */
            foreignKeyField?: string;

            /** Gets or sets a value that indicates to bind the field which is in foreign column datasource based on the foreignKeyField
             * @Default {null}
             */
            foreignKeyValue?: string;

            /** Gets or sets a value that indicates the format for the text applied on the column
             */
            format?: string;

            /** Gets or sets a value that indicates to add the template within the header element of the particular column.
             * @Default {null}
             */
            headerTemplateID?: string;

            /** Gets or sets a value that indicates to display the title of that particular column.
             */
            headerText?: string;

            /** This defines the text alignment of a particular column header cell value. See headerTextAlign
             * @Default {null}
             */
            headerTextAlign?: ej.TextAlign|string;

            /** It accepts the string value and shows the tooltip for the Grid column header.
             * @Default {null}
             */
            headerTooltip?: string;

            /** You can use this property to freeze selected columns in grid at the time of scrolling.
             * @Default {false}
             */
            isFrozen?: boolean;

            /** Gets or sets a value that indicates the column has an identity in the database.
             * @Default {false}
             */
            isIdentity?: boolean;

            /** Gets or sets a value that indicates the column is act as a primary key(read-only) of the grid. The editing is performed based on the primary key column
             * @Default {false}
             */
            isPrimaryKey?: boolean;

            /** Gets or sets a value that indicates the order of Column that are to be hidden or visible when Grid element is in responsive mode and could not occupy all columns.
             * @Default {-1}
             */
            priority?: number;

            /** Used to hide the particular column in column chooser by giving value as false.
             * @Default {true}
             */
            showInColumnChooser?: boolean;

            /** Gets or sets a value that indicates whether to enables column template for a particular column.
             * @Default {false}
             */
            template?: boolean|string;

            /** Gets or sets a value that indicates to align the text within the column. See textAlign
             * @Default {ej.TextAlign.Left}
             */
            textAlign?: ej.TextAlign|string;

            /** Sets the template for Tooltip in Grid Columns(both header and content)
             */
            tooltip?: string;

            /** Gets or sets a value that indicates to specify the data type of the specified columns.
             */
            type?: string;

            /** Gets or sets a value that indicates to define constraints for saving data to the database.
             */
            validationRules?: any;

            /** Gets or sets a value that indicates whether this column is visible in the grid.
             * @Default {true}
             */
            visible?: boolean;

            /** Gets or sets a value that indicates to define the width for a particular column in the grid.
             */
            width?: number;
        }

        export interface ContextMenuSettingsSubContextMenu {

            /** Used to get or set the corresponding custom context menu item to which the submenu to be appended.
             * @Default {null}
             */
            contextMenuItem?: string;

            /** Used to get or set the sub menu items to the custom context menu item.
             * @Default {[]}
             */
            subMenu?: any[];

            /** Used to get or set the sub menu items to the custom context menu item using JsRender template.
             * @Default {null}
             */
            template?: string;
        }

        export interface ContextMenuSettings {

            /** Gets or sets a value that indicates whether to add the default context menu actions as a context menu items If enableContextMenu is true it will show all the items related to the
             * target, if you want selected items from contextmenu you have to mention in the contextMenuItems
             * @Default {[]}
             */
            contextMenuItems?: any[];

            /** Gets or sets a value that indicates whether to add custom contextMenu items within the toolbar to perform any action in the grid
             * @Default {[]}
             */
            customContextMenuItems?: any[];

            /** Gets or sets a value that indicates whether to enable the context menu action in the grid.
             * @Default {false}
             */
            enableContextMenu?: boolean;

            /** Used to get or set the subMenu to the corresponding custom context menu item.
             */
            subContextMenu?: ContextMenuSettingsSubContextMenu[];

            /** Gets or sets a value that indicates whether to disable the default context menu items in the grid.
             * @Default {false}
             */
            disableDefaultItems?: boolean;
        }

        export interface EditSettings {

            /** Gets or sets a value that indicates whether to enable insert action in the editing mode.
             * @Default {false}
             */
            allowAdding?: boolean;

            /** Gets or sets a value that indicates whether to enable the delete action in the editing mode.
             * @Default {false}
             */
            allowDeleting?: boolean;

            /** Gets or sets a value that indicates whether to enable the edit action in the editing mode.
             * @Default {false}
             */
            allowEditing?: boolean;

            /** Gets or sets a value that indicates whether to enable the editing action while double click on the record
             * @Default {true}
             */
            allowEditOnDblClick?: boolean;

            /** This specifies the id of the template. This template can be used to display the data that you require to be edited using the Dialog Box
             * @Default {null}
             */
            dialogEditorTemplateID?: string;

            /** Gets or sets a value that indicates whether to define the mode of editing See editMode
             * @Default {ej.Grid.EditMode.Normal}
             */
            editMode?: ej.Grid.EditMode|string;

            /** This specifies the id of the template. This template can be used to display the data that you require to be edited using the External edit form
             * @Default {null}
             */
            externalFormTemplateID?: string;

            /** This specifies to set the position of an External edit form either in the top-right or bottom-left of the grid. See formPosition
             * @Default {ej.Grid.FormPosition.BottomLeft}
             */
            formPosition?: ej.Grid.FormPosition|string;

            /** This specifies the id of the template. This template can be used to display the data that you require to be edited using the Inline edit form
             * @Default {null}
             */
            inlineFormTemplateID?: string;

            /** This specifies to set the position of an adding new row either in the top or bottom of the grid. See rowPosition
             * @Default {ej.Grid.RowPosition.Top}
             */
            rowPosition?: ej.Grid.RowPosition|string;

            /** Gets or sets a value that indicates whether the confirm dialog has to be shown while saving or discarding the batch changes
             * @Default {true}
             */
            showConfirmDialog?: boolean;

            /** Gets or sets a value that indicates whether the confirm dialog has to be shown while deleting record
             * @Default {false}
             */
            showDeleteConfirmDialog?: boolean;

            /** Gets or sets a value that indicates whether the title for edit form is different from the primarykey column.
             * @Default {null}
             */
            titleColumn?: string;

            /** Gets or sets a value that indicates whether to display the add new form by default in the grid.
             * @Default {false}
             */
            showAddNewRow?: boolean;
        }

        export interface FilterSettingsFilteredColumn {

            /** Gets or sets a value that indicates whether to define the field name of the column to be filter.
             */
            field?: string;

            /** Gets or sets a value that indicates whether to define the matchCase of given value to be filter.
             */
            matchCase?: boolean;

            /** Gets or sets a value that indicates whether to define the filter condition to filtered column. See operator
             */
            operator?: ej.FilterOperators|string;

            /** Gets or sets a value that indicates whether to define the predicate as and/or.
             */
            predicate?: string;

            /** Gets or sets a value that indicates whether to define the value to be filtered in a column.
             */
            value?: string|number;
        }

        export interface FilterSettings {

            /** Gets or sets a value that indicates to perform the filter operation with case sensitive in excel styled filter menu mode
             * @Default {false}
             */
            enableCaseSensitivity?: boolean;

            /** Gets or sets a value that indicates to define the interDeterminateState of checkbox in excel filter dialog.
             * @Default {true}
             */
            enableInterDeterminateState?: boolean;

            /** This specifies the grid to starts the filter action while typing in the filterBar or after pressing the enter key. based on the filterBarMode. See filterBarMode.
             * @Default {ej.Grid.FilterBarMode.Immediate}
             */
            filterBarMode?: ej.Grid.FilterBarMode|string;

            /** Gets or sets a value that indicates whether to define the filtered columns details programmatically at initial load
             * @Default {[]}
             */
            filteredColumns?: FilterSettingsFilteredColumn[];

            /** This specifies the grid to show the filterBar or filterMenu to the grid records. See filterType
             * @Default {ej.Grid.FilterType.FilterBar}
             */
            filterType?: ej.Grid.FilterType|string;

            /** This specifies the grid to delay the filter action while typing in the filterBar.
             * @Default {1500}
             */
            immediateModeDelay?: number;

            /** Gets or sets a value that indicates the maximum number of filter choices that can be showed in the excel styled filter menu.
             * @Default {1000}
             */
            maxFilterChoices?: number;

            /** This specifies the grid to show the filter text within the grid pager itself.
             * @Default {true}
             */
            showFilterBarStatus?: boolean;

            /** Gets or sets a value that indicates whether to enable the predicate options in the filtering menu
             * @Default {false}
             */
            showPredicate?: boolean;
        }

        export interface GroupSettings {

            /** Gets or sets a value that customize the group caption format.
             * @Default {null}
             */
            captionFormat?: string;

            /** Gets or sets a value that indicates whether to enable animation button option in the group drop area of the grid.
             * @Default {false}
             */
            enableDropAreaAutoSizing?: boolean;

            /** Gets or sets a value that indicates whether to add grouped columns programmatically at initial load
             * @Default {[]}
             */
            groupedColumns?: any[];

            /** Gets or sets a value that indicates whether to show the group drop area just above the column header. It can be used to avoid ungrouping the already grouped column using
             * groupSettings.
             * @Default {true}
             */
            showDropArea?: boolean;

            /** Gets or sets a value that indicates whether to hide the grouped columns from the grid
             * @Default {false}
             */
            showGroupedColumn?: boolean;

            /** Gets or sets a value that indicates whether to show the group button image(toggle button)in the column header and also in the grouped column in the group drop area . It can be
             * used to group/ungroup the columns by click on the toggle button.
             * @Default {false}
             */
            showToggleButton?: boolean;

            /** Gets or sets a value that indicates whether to enable the close button in the grouped column which is in the group drop area to ungroup the grouped column
             * @Default {false}
             */
            showUngroupButton?: boolean;
        }

        export interface PageSettings {

            /** Gets or sets a value that indicates whether to define which page to display currently in the grid
             * @Default {1}
             */
            currentPage?: number;

            /** Gets or sets a value that indicates whether to pass the current page information as a query string along with the URL while navigating to other page.
             * @Default {false}
             */
            enableQueryString?: boolean;

            /** Gets or sets a value that indicates whether to enables pager template for the grid.
             * @Default {false}
             */
            enableTemplates?: boolean;

            /** Gets or sets a value that indicates whether to define the number of pages displayed in the pager for navigation
             * @Default {8}
             */
            pageCount?: number;

            /** Gets or sets a value that indicates whether to define the number of records displayed per page
             * @Default {12}
             */
            pageSize?: number;

            /** Gets or sets different page size values to the Dropdown in Grid Pager, by which number of records in a page can be changed dynamically.
             * @Default {[]}
             */
            pageSizeList?: any[];

            /** Gets or sets a value that indicates whether to enables default pager for the grid.
             * @Default {false}
             */
            showDefaults?: boolean;

            /** Gets or sets a value that indicates to add the template as a pager template for grid.
             * @Default {null}
             */
            template?: string;

            /** Get the value of total number of pages in the grid. The totalPages value is calculated based on page size and total records of grid
             * @Default {null}
             */
            totalPages?: number;

            /** Get the value of total number of records which is bound to the grid. The totalRecordsCount value is calculated based on dataSource bound to the grid.
             * @Default {null}
             */
            totalRecordsCount?: number;

            /** Gets or sets a value that indicates whether to define the number of pages to print. See printMode.
             * @Default {ej.Grid.PrintMode.AllPages}
             */
            printMode?: ej.Grid.PrintMode|string;
        }

        export interface ResizeSettings {

            /** Gets or sets a value that indicates whether to define the mode of resizing.
             * @Default {ej.Grid.ResizeMode.Normal}
             */
            resizeMode?: ej.Grid.ResizeMode|string;
        }

        export interface RowDropSettings {

            /** This specifies the grid to drop the grid rows only at particular target element.
             * @Default {null}
             */
            dropTargetID?: any;

            /** This helps in mapping server-side action when rows are dragged from Grid.
             * @Default {null}
             */
            dragMapper?: string;

            /** This helps in mapping server-side action when rows are dropped in Grid.
             * @Default {null}
             */
            dropMapper?: string;

            /** Gets or sets a value that indicates whether move or copy a record from one grid to another or within the grid
             * @Default {ej.Grid.DragBehavior.Move}
             */
            dragBehavior?: ej.Grid.DragBehavior|string;
        }

        export interface SearchSettings {

            /** This specify the grid to search for the value in particular columns that is mentioned in the field.
             * @Default {[]}
             */
            fields?: any;

            /** This specifies the grid to search the particular data that is mentioned in the key.
             */
            key?: string;

            /** It specifies the grid to search the records based on operator.
             * @Default {contains}
             */
            operator?: string;

            /** It enables or disables case-sensitivity while searching the search key in grid.
             * @Default {true}
             */
            ignoreCase?: boolean;
        }

        export interface SelectionSettings {

            /** Gets or sets a value that indicates the cell selection actions based on the cell selection mode.
             * @Default {ej.Grid.CellSelectionMode.Flow}
             */
            cellSelectionMode?: ej.Grid.CellSelectionMode|string;

            /** Gets or sets a value that indicates whether to enable the toggle selection behavior for row, cell and column.
             * @Default {false}
             */
            enableToggle?: boolean;

            /** Gets or sets a value that indicates whether to select multiple rows or cells by performing dragging in Grid.
             * @Default {false}
             */
            allowDragSelection?: boolean;

            /** Gets or sets a value that indicates whether to add the default selection actions as a selection mode.See selectionMode
             * @Default {[row]}
             */
            selectionMode?: any[];
        }

        export interface ScrollSettings {

            /** This specify the grid to to view data that you require without buffering the entire load of a huge database
             * @Default {false}
             */
            allowVirtualScrolling?: boolean;

            /** It accepts the boolean value and shows or hides the scrollbar while focus in or focus out of the Grid.
             * @Default {false}
             */
            autoHide?: boolean;

            /** Specifies the height and width of button in the scrollbar.
             * @Default {18}
             */
            buttonSize?: number;

            /** This specify the grid to enable/disable touch control for scrolling.
             * @Default {true}
             */
            enableTouchScroll?: boolean;

            /** This specify the grid to freeze particular columns at the time of scrolling.
             * @Default {0}
             */
            frozenColumns?: number;

            /** This specify the grid to freeze particular rows at the time of scrolling.
             * @Default {0}
             */
            frozenRows?: number;

            /** This specify the grid to show the vertical scroll bar, to scroll and view the grid contents.
             * @Default {0}
             */
            height?: string|number;

            /** It accepts the integer value and sets the width of scrollbar.
             * @Default {18}
             */
            scrollerSize?: number;

            /** This is used to define the mode of virtual scrolling in grid. See virtualScrollMode
             * @Default {ej.Grid.VirtualScrollMode.Normal}
             */
            virtualScrollMode?: ej.Grid.VirtualScrollMode|string;

            /** This is used to enable the enhanced virtual scrolling in Grid.
             * @Default {false}
             */
            enableVirtualization?: boolean;

            /** This specify the grid to show the horizontal scroll bar, to scroll and view the grid contents
             * @Default {250}
             */
            width?: string|number;

            /** This specify the scroll down pixel of mouse wheel, to scroll mouse wheel and view the grid contents.
             * @Default {57}
             */
            scrollOneStepBy?: number;
        }

        export interface SortSettingsSortedColumn {

            /** Gets or sets a value that indicates whether to define the direction to sort the column.
             */
            direction?: string;

            /** Gets or sets a value that indicates whether to define the field name of the column to be sort
             */
            field?: string;
        }

        export interface SortSettings {

            /** Gets or sets a value that indicates whether to define the direction and field to sort the column.
             */
            sortedColumns?: SortSettingsSortedColumn[];
        }

        export interface StackedHeaderRowsStackedHeaderColumn {

            /** Gets or sets a value that indicates the header text for the particular stacked header column.
             * @Default {null}
             */
            column?: any;

            /** Gets or sets a value that indicates class to the corresponding stackedHeaderColumn.
             * @Default {null}
             */
            cssClass?: string;

            /** Gets or sets a value that indicates the header text for the particular stacked header column.
             * @Default {null}
             */
            headerText?: string;

            /** Gets or sets a value that indicates the text alignment of the corresponding headerText.
             * @Default {ej.TextAlign.Left}
             */
            textAlign?: string;

            /** Sets the template for tooltip for the Grid stackedHeaderColumns.
             * @Default {null}
             */
            tooltip?: string;
        }

        export interface StackedHeaderRow {

            /** Gets or sets a value that indicates whether to add stacked header columns into the stacked header rows
             * @Default {[]}
             */
            stackedHeaderColumns?: StackedHeaderRowsStackedHeaderColumn[];
        }

        export interface SummaryRowsSummaryColumn {

            /** Gets or sets a value that indicates the text displayed in the summary column as a value
             * @Default {null}
             */
            customSummaryValue?: string;

            /** This specifies summary column used to perform the summary calculation
             * @Default {null}
             */
            dataMember?: string;

            /** Gets or sets a value that indicates to define the target column at which to display the summary.
             * @Default {null}
             */
            displayColumn?: string;

            /** Gets or sets a value that indicates the format for the text applied on the column
             * @Default {null}
             */
            format?: string;

            /** Gets or sets a value that indicates the text displayed before the summary column value
             * @Default {null}
             */
            prefix?: string;

            /** Gets or sets a value that indicates the text displayed after the summary column value
             * @Default {null}
             */
            suffix?: string;

            /** Gets or sets a value that indicates the type of calculations to be performed for the corresponding summary column. See summaryType.
             * @Default {[]}
             */
            summaryType?: ej.Grid.SummaryType|string;

            /** Gets or sets a value that indicates to add the template for the summary value of dataMember given.
             * @Default {null}
             */
            template?: string;
        }

        export interface SummaryRow {

            /** Gets or sets a value that indicates whether to show the summary value within the group caption area for the corresponding summary column while grouping the column
             * @Default {false}
             */
            showCaptionSummary?: boolean;

            /** Gets or sets a value that indicates whether to show the group summary value for the corresponding summary column while grouping a column
             * @Default {false}
             */
            showGroupSummary?: boolean;

            /** Gets or sets a value that indicates whether to show the total summary value the for the corresponding summary column. The summary row is added after the grid content.
             * @Default {true}
             */
            showTotalSummary?: boolean;

            /** Gets or sets a value that indicates whether to add summary columns into the summary rows.
             * @Default {[]}
             */
            summaryColumns?: SummaryRowsSummaryColumn[];

            /** This specifies the grid to show the title for the summary rows.
             */
            title?: string;

            /** This specifies the grid to show the title of summary row in the specified column.
             * @Default {null}
             */
            titleColumn?: string;
        }

        export interface TextWrapSettings {

            /** This specifies the grid to apply the auto wrap for grid content or header or both.
             * @Default {ej.Grid.WrapMode.Both}
             */
            wrapMode?: ej.Grid.WrapMode|string;
        }

        export interface ToolbarSettingsCustomToolbarItem {

            /** Gets or sets a value that indicates whether to add custom toolbar item as a template element.
             */
            templateID?: string;

            /** Gets or sets a value that indicates whether to add custom toolbar item with a custom tooltip.
             */
            tooltip?: string;
        }

        export interface ToolbarSettings {

            /** Gets or sets a value that indicates whether to add custom toolbar items within the toolbar to perform any action in the grid
             * @Default {[]}
             */
            customToolbarItems?: ToolbarSettingsCustomToolbarItem[];

            /** Gets or sets a value that indicates whether to enable toolbar in the grid.
             * @Default {false}
             */
            showToolbar?: boolean;

            /** Gets or sets a value that indicates whether to add the default editing actions as a toolbar items. See toolbarItems.
             * @Default {[]}
             */
            toolbarItems?: Array<ej.Grid.ToolBarItems|string>;
        }

        enum GridLines {

            ///Displays both the horizontal and vertical grid lines.
            Both,

            ///Displays the horizontal grid lines only.
            Horizontal,

            ///Displays the vertical grid lines only.
            Vertical,

            ///No grid lines are displayed.
            None
        }


        enum ClipMode {

            ///Shows ellipsis for the overflown cell.
            Ellipsis,

            ///Truncate the text in the cell
            Clip,

            ///Shows ellipsis and tooltip for the overflown cell.
            EllipsisWithTooltip
        }


        enum ColumnLayout {

            ///Column layout is auto(based on width).
            Auto,

            ///Column layout is fixed(based on width).
            Fixed
        }


        enum UnboundType {

            ///Unbound type is edit.
            Edit,

            ///Unbound type is save.
            Save,

            ///Unbound type is delete.
            Delete,

            ///Unbound type is cancel.
            Cancel
        }


        enum EditingType {

            ///Specifies editing type as string edit.
            String,

            ///Specifies editing type as boolean edit.
            Boolean,

            ///Specifies editing type as numeric edit.
            Numeric,

            ///Specifies editing type as dropdown edit.
            Dropdown,

            ///Specifies editing type as datepicker.
            DatePicker,

            ///Specifies editing type as datetime picker.
            DateTimePicker
        }


        enum FilterType {

            ///Specifies the filter type as menu.
            Menu,

            ///Specifies the filter type as excel.
            Excel
        }


        enum EditMode {

            ///Edit mode is normal.
            Normal,

            ///Edit mode is dialog.
            Dialog,

            ///Edit mode is dialog template.
            DialogTemplate,

            ///Edit mode is batch.
            Batch,

            ///Edit mode is inline form.
            InlineForm,

            ///Edit mode is inline template form.
            InlineTemplateForm,

            ///Edit mode is external form.
            ExternalForm,

            ///Edit mode is external form template.
            ExternalFormTemplate
        }


        enum FormPosition {

            ///Form position is bottomleft.
            BottomLeft,

            ///Form position is topright.
            TopRight
        }


        enum RowPosition {

            ///Specifies position of add new row as top.
            Top,

            ///Specifies position of add new row as bottom.
            Bottom
        }


        enum FilterBarMode {

            ///Initiate filter operation on typing the filter query.
            Immediate,

            ///Initiate filter operation after Enter key is pressed.
            OnEnter
        }


        enum PrintMode {

            ///Prints all pages.
            AllPages,

            ///Prints current page.
            CurrentPage
        }


        enum ResizeMode {

            ///New column size will be adjusted by all other Columns
            Normal,

            ///New column Size will be adjusted using next column.
            NextColumn,

            ///New column Size will be adjusted using entire control
            Control
        }


        enum DragBehavior {

            ///Allows to move a record from one grid to another or within the grid.
            Move,

            ///Allows to copy a record from one grid to another or within the grid.
            Copy
        }


        enum CellSelectionMode {

            ///It selects cells continuously from the start cell to end cell.
            Flow,

            ///It selects range of cells as a block from start cell to the end cell.
            Box
        }


        enum SelectionType {

            ///Specifies the selection type as single.
            Single,

            ///Specifies the selection type as multiple.
            Multiple
        }


        enum VirtualScrollMode {

            ///virtual scroll mode is normal.
            Normal,

            ///virtual scroll mode is continuous.
            Continuous
        }


        enum SummaryType {

            ///Summary type is average.
            Average,

            ///Summary type is minimum.
            Minimum,

            ///Summary type is maximum.
            Maximum,

            ///Summary type is count.
            Count,

            ///Summary type is sum.
            Sum,

            ///Summary type is custom.
            Custom,

            ///Summary type is true count.
            TrueCount,

            ///Summary type is false count.
            FalseCount
        }


        enum WrapMode {

            ///Auto wrap is applied for both content and header.
            Both,

            ///Auto wrap is applied only for content.
            Content,

            ///Auto wrap is applied only for header.
            Header
        }


        enum ToolBarItems {

            ///Toolbar item is add.
            Add,

            ///Toolbar item is edit.
            Edit,

            ///Toolbar item is delete.
            Delete,

            ///Toolbar item is update.
            Update,

            ///Toolbar item is cancel.
            Cancel,

            ///Toolbar item is search.
            Search,

            ///Toolbar item is pdfExport.
            PdfExport,

            ///Toolbar item is printGrid.
            PrintGrid,

            ///Toolbar item is wordExport.
            WordExport
        }

    }

    class Sparkline extends ej.Widget {
        static fn: Sparkline;
        constructor(element: JQuery | Element, options?: Sparkline.Model);
        static Locale: any;
        model: Sparkline.Model;
        defaults: Sparkline.Model;

        /** Redraws the entire sparkline. You can call this method whenever you update, add or remove points from the data source or whenever you want to refresh the UI.
         * @returns {void}
         */
        redraw(): void;
    }
    export namespace Sparkline {

        export interface Model {

            /** Background color of the plot area.
             * @Default {transparent}
             */
            background?: string;

            /** Fill color for the sparkline series.
             * @Default {#33ccff}
             */
            fill?: string;

            /** Border color of the series.
             * @Default {null}
             */
            stroke?: string;

            /** Options for customizing the color, opacity and width of the sparkline border.
             */
            border?: Border;

            /** Border width of the series.
             * @Default {1}
             */
            width?: number;

            /** Opacity of the series.
             * @Default {1}
             */
            opacity?: number;

            /** Color for series high point.
             * @Default {null}
             */
            highPointColor?: string;

            /** Color for series low point.
             * @Default {null}
             */
            lowPointColor?: string;

            /** Color for series start point.
             * @Default {null}
             */
            startPointColor?: string;

            /** Color for series end point.
             * @Default {null}
             */
            endPointColor?: string;

            /** Color for series negative point.
             * @Default {null}
             */
            negativePointColor?: string;

            /** Options for customizing the color, opacity of the sparkline start and end range.
             */
            rangeBandSettings?: RangeBandSettings;

            /** Name of the culture based on which sparkline should be localized.
             * @Default {en-US}
             */
            locale?: string;

            /** Name of a field in data source, where the fill color for all the data points is generated.
             */
            palette?: string;

            /** Controls whether sparkline has to be responsive or not.
             * @Default {true}
             */
            isResponsive?: boolean;

            /** Controls whether Sparkline has to be rendered as Canvas or SVG.Canvas rendering supports all functionalities in SVG rendering.
             * @Default {false}
             */
            enableCanvasRendering?: boolean;

            /** Specify to convert the date object to string, using locale settings.
             * @Default {false}
             */
            enableGroupSeparator?: boolean;

            /** Specifies the dataSource for the series. It can be an array of JSON objects or an instance of ej.DataManager.
             * @Default {null}
             */
            dataSource?: any;

            /** Name of the property in the datasource that contains x value for the series.
             * @Default {null}
             */
            xName?: string;

            /** Name of the property in the datasource that contains y value for the series.
             * @Default {null}
             */
            yName?: string;

            /** Gap or padding for sparkline.
             * @Default {8}
             */
            padding?: number;

            /** Specifies the type of the series to render in sparkline.
             * @Default {line. See Type}
             */
            type?: ej.datavisualization.Sparkline.Type|string;

            /** Specifies the theme for Sparkline.
             * @Default {Flatlight. See Theme}
             */
            theme?: ej.datavisualization.Sparkline.Theme|string;

            /** Options to customize the tooltip.
             */
            tooltip?: Tooltip;

            /** Options for displaying and customizing marker for a data point.
             */
            markerSettings?: MarkerSettings;

            /** Options to customize the Sparkline size.
             */
            size?: Size;

            /** Options for customizing the color,dashArray and width of the axisLine.
             */
            axisLineSettings?: AxisLineSettings;

            /** Fires before loading the sparkline.
             */
            load?(e: LoadEventArgs): void;

            /** Fires after loaded the sparkline.
             */
            loaded?(e: LoadedEventArgs): void;

            /** Fires before rendering trackball tooltip. You can use this event to customize the text displayed in trackball tooltip.
             */
            tooltipInitialize?(e: TooltipInitializeEventArgs): void;

            /** Fires before rendering a series. This event is fired for each series in Sparkline.
             */
            seriesRendering?(e: SeriesRenderingEventArgs): void;

            /** Fires when mouse is moved over a point.
             */
            pointRegionMouseMove?(e: PointRegionMouseMoveEventArgs): void;

            /** Fires on clicking a point in sparkline. You can use this event to handle clicks made on points.
             */
            pointRegionMouseClick?(e: PointRegionMouseClickEventArgs): void;

            /** Fires on moving mouse over the sparkline.
             */
            sparklineMouseMove?(e: SparklineMouseMoveEventArgs): void;

            /** Fires on moving mouse outside the sparkline.
             */
            sparklineMouseLeave?(e: SparklineMouseLeaveEventArgs): void;

            /** Fires, on clicking the sparkline.
             */
            Click?(e: ClickEventArgs): void;

            /** Fires, on double clicking the sparkline.
             */
            doubleClick?(e: DoubleClickEventArgs): void;

            /** Fires, on right clicking the sparkline.
             */
            rightClick?(e: RightClickEventArgs): void;
        }

        export interface LoadEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface LoadedEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface TooltipInitializeEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;

            /** X Location of the trackball tooltip in pixels
             */
            locationX?: any;

            /** Y Location of the trackball tooltip in pixels
             */
            locationY?: any;

            /** Index of the point for which trackball tooltip is displayed
             */
            pointIndex?: number;

            /** Text to be displayed in trackball tooltip. Use this option to add custom text in trackball tooltip
             */
            currentText?: string;
        }

        export interface SeriesRenderingEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;

            /** Minimum x value of the data point
             */
            minX?: any;

            /** Minimum y value of the data point
             */
            minY?: any;

            /** Maximum x value of the data point
             */
            maxX?: any;

            /** Maximum y value of the data point
             */
            maxY?: any;
        }

        export interface PointRegionMouseMoveEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;

            /** X-coordinate of point in pixel
             */
            locationX?: number;

            /** Y-coordinate of point in pixel
             */
            locationY?: number;

            /** Index of the point in series
             */
            pointIndex?: number;

            /** Type of the series
             */
            seriesType?: string;
        }

        export interface PointRegionMouseClickEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;

            /** X-coordinate of point in pixel
             */
            locationX?: number;

            /** Y-coordinate of point in pixel
             */
            locationY?: number;

            /** Index of the point in series
             */
            pointIndex?: number;

            /** Type of the series
             */
            seriesType?: string;
        }

        export interface SparklineMouseMoveEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface SparklineMouseLeaveEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface ClickEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface DoubleClickEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface RightClickEventArgs {

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sparkline model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface Border {

            /** Border color of the sparkline.
             * @Default {transparent}
             */
            color?: string;

            /** Width of the Sparkline border.
             * @Default {1}
             */
            width?: number;
        }

        export interface RangeBandSettings {

            /** Start value of the range band.
             * @Default {null}
             */
            startRange?: number;

            /** End value of the range band.
             * @Default {null}
             */
            endRange?: number;

            /** Range band opacity of the series.
             * @Default {1}
             */
            opacity?: number;

            /** Range band color of the series.
             * @Default {transparent}
             */
            color?: string;
        }

        export interface TooltipBorder {

            /** Border color of the tooltip.
             * @Default {transparent}
             */
            color?: string;

            /** Border width of the tooltip.
             * @Default {1}
             */
            width?: number;
        }

        export interface TooltipFont {

            /** Font color of the text in the tooltip.
             * @Default {#111111}
             */
            color?: string;

            /** Font Family for the tooltip.
             * @Default {Segoe UI}
             */
            fontFamily?: string;

            /** Specifies the font Style for the tooltip.
             * @Default {Normal}
             */
            fontStyle?: ej.datavisualization.Sparkline.FontStyle|string;

            /** Specifies the font weight for the tooltip.
             * @Default {Regular}
             */
            fontWeight?: ej.datavisualization.Sparkline.FontWeight|string;

            /** Opacity for text in the tooltip.
             * @Default {1}
             */
            opacity?: number;

            /** Font size for text in the tooltip.
             * @Default {8px}
             */
            size?: string;
        }

        export interface Tooltip {

            /** Show/hides the tooltip visibility.
             * @Default {false}
             */
            visible?: boolean;

            /** Fill color for the sparkline tooltip.
             * @Default {white}
             */
            fill?: string;

            /** Custom template to the tooltip.
             */
            template?: string;

            /** Options for customizing the border of the tooltip.
             */
            border?: TooltipBorder;

            /** Options for customizing the font of the tooltip.
             */
            font?: TooltipFont;
        }

        export interface MarkerSettingsBorder {

            /** Border color of the marker shape.
             * @Default {transparent}
             */
            color?: string;

            /** Controls the opacity of the marker border.
             * @Default {1}
             */
            opacity?: number;

            /** Border width of the marker shape.
             * @Default {null}
             */
            width?: number;
        }

        export interface MarkerSettings {

            /** Controls the opacity of the marker.
             * @Default {1}
             */
            opacity?: number;

            /** Controls the visibility of the marker shape.
             * @Default {false}
             */
            visible?: boolean;

            /** width of the marker shape.
             * @Default {2}
             */
            width?: number;

            /** Color of the marker shape.
             * @Default {white}
             */
            fill?: string;

            /** Options for customizing the border of the marker shape.
             */
            border?: MarkerSettingsBorder;
        }

        export interface Size {

            /** Height of the Sparkline. Height can be specified in either pixel or percentage.
             * @Default {''}
             */
            height?: string;

            /** Width of the Sparkline. Width can be specified in either pixel or percentage.
             * @Default {''}
             */
            width?: string;
        }

        export interface AxisLineSettings {

            /** Controls the visibility of the axis.
             * @Default {false}
             */
            visible?: boolean;

            /** Color of the axis line.
             * @Default {'#111111'}
             */
            color?: string;

            /** Width of the axis line.
             * @Default {1}
             */
            width?: number;

            /** Dash array of the axis line.
             * @Default {1}
             */
            dashArray?: number;
        }
    }
    namespace Sparkline {
        enum Type {
            //string
            Area,
            //string
            Line,
            //string
            Column,
            //string
            Pie,
            //string
            WinLoss,
        }
    }
    namespace Sparkline {
        enum Theme {
            //string
            Azure,
            //string
            FlatLight,
            //string
            FlatDark,
            //string
            Azuredark,
            //string
            Lime,
            //string
            LimeDark,
            //string
            Saffron,
            //string
            SaffronDark,
            //string
            GradientLight,
            //string
            GradientDark,
        }
    }
    namespace Sparkline {
        enum FontStyle {
            //string
            Normal,
            //string
            Italic,
        }
    }
    namespace Sparkline {
        enum FontWeight {
            //string
            Regular,
            //string
            Bold,
            //string
            Lighter,
        }
    }

    class SunburstChart extends ej.Widget {
        static fn: SunburstChart;
        constructor(element: JQuery | Element, options?: SunburstChart.Model);
        static Locale: any;
        model: SunburstChart.Model;
        defaults: SunburstChart.Model;

        /** Redraws the entire sunburst. You can call this method whenever you update, add or remove points from the data source or whenever you want to refresh the UI.
         * @returns {void}
         */
        redraw(): void;

        /** destroy the sunburst
         * @returns {void}
         */
        destroy(): void;
    }
    export namespace SunburstChart {

        export interface Model {

            /** Background color of the plot area.
             * @Default {null}
             */
            background?: string;

            /** Bind the data field from the data source.
             * @Default {null}
             */
            valueMemberPath?: string;

            /** Options for customizing the sunburst border.
             */
            border?: Border;

            /** Options for customizing the sunburst segment border.
             */
            segmentBorder?: SegmentBorder;

            /** Specifies the dataSource to the sunburst.
             * @Default {null}
             */
            dataSource?: any;

            /** Palette color for the data points.
             * @Default {null}
             */
            palette?: string;

            /** Parent node of the data points.
             * @Default {null}
             */
            parentNode?: string;

            /** Name of the property in the datasource that contains x values.
             * @Default {null}
             */
            xName?: string;

            /** Name of the property in the datasource that contains y values.
             * @Default {null}
             */
            yName?: string;

            /** Controls whether sunburst has to be responsive or not.
             * @Default {true}
             */
            isResponsive?: boolean;

            /** Options to customize the Sunburst size.
             */
            size?: Size;

            /** Controls the visibility of sunburst.
             * @Default {true}
             */
            visible?: boolean;

            /** Options to customize the Sunburst tooltip.
             */
            tooltip?: Tooltip;

            /** Options for customizing sunburst points.
             */
            points?: Points;

            /** Sunburst rendering will start from the specified value
             * @Default {null}
             */
            startAngle?: number;

            /** Sunburst rendering will end at the specified value
             * @Default {null}
             */
            endAngle?: number;

            /** Sunburst outer radius value
             * @Default {1}
             */
            radius?: number;

            /** Sunburst inner radius value
             * @Default {0.4}
             */
            innerRadius?: number;

            /** Options to customize the Sunburst dataLabel.
             */
            dataLabelSettings?: DataLabelSettings;

            /** Options for customizing the title and subtitle of sunburst.
             */
            title?: Title;

            /** Options for customizing the appearance of the levels or point while highlighting.
             */
            highlightSettings?: HighlightSettings;

            /** Options for customizing the appearance of the levels or data point while selection.
             */
            selectionSettings?: SelectionSettings;

            /** Specify levels of sunburst for grouped visualization of data
             * @Default {[]}
             */
            levels?: Level[];

            /** Options to customize the legend items and legend title.
             */
            legend?: Legend;

            /** Specifies the theme for Sunburst.
             * @Default {Flatlight. See Theme}
             */
            theme?: ej.datavisualization.Sunburst.SunburstTheme|string;

            /** Options to customize the left, right, top and bottom margins of sunburst area.
             */
            margin?: Margin;

            /** Enable/disable the animation for all the levels.
             * @Default {false}
             */
            enableAnimation?: boolean;

            /** Opacity of the levels.
             * @Default {1}
             */
            opacity?: number;

            /** Options for enable zooming feature of chart.
             */
            zoomSettings?: ZoomSettings;

            /** Animation type of sunburst
             * @Default {rotation. See Alignment}
             */
            animationType?: ej.datavisualization.Sunburst.Animation|string;

            /** Fires before loading.
             */
            load?(e: LoadEventArgs): void;

            /** Fires before rendering sunburst.
             */
            preRender?(e: PreRenderEventArgs): void;

            /** Fires after rendering sunburst.
             */
            loaded?(e: LoadedEventArgs): void;

            /** Fires before rendering the datalabel
             */
            dataLabelRendering?(e: DataLabelRenderingEventArgs): void;

            /** Fires before rendering each segment
             */
            segmentRendering?(e: SegmentRenderingEventArgs): void;

            /** Fires before rendering sunburst title.
             */
            titleRendering?(e: TitleRenderingEventArgs): void;

            /** Fires during initialization of tooltip.
             */
            tooltipInitialize?(e: TooltipInitializeEventArgs): void;

            /** Fires after clicking the point in sunburst
             */
            pointRegionClick?(e: PointRegionClickEventArgs): void;

            /** Fires while moving the mouse over sunburst points
             */
            pointRegionMouseMove?(e: PointRegionMouseMoveEventArgs): void;

            /** Fires when clicking the point to perform drilldown.
             */
            drillDownClick?(e: DrillDownClickEventArgs): void;

            /** Fires when resetting drilldown points.
             */
            drillDownBack?(e: DrillDownBackEventArgs): void;

            /** Fires after resetting the sunburst points
             */
            drillDownReset?(e: DrillDownResetEventArgs): void;

            /** Fires, on clicking the sunburst chart.
             */
            Click?(e: ClickEventArgs): void;

            /** Fires, on double clicking the sunburst chart.
             */
            doubleClick?(e: DoubleClickEventArgs): void;

            /** Fires, on right clicking the sunburst chart
             */
            rightClick?(e: RightClickEventArgs): void;
        }

        export interface LoadEventArgs {

            /** Load event data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface PreRenderEventArgs {

            /** PreRender event data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface LoadedEventArgs {

            /** Loaded event data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface DataLabelRenderingEventArgs {

            /** Sunburst datalabel data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface SegmentRenderingEventArgs {

            /** Sunburst datalabel data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface TitleRenderingEventArgs {

            /** Sunburst title data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface TooltipInitializeEventArgs {

            /** Sunburst tooltip data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface PointRegionClickEventArgs {

            /** Includes clicked points region data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface PointRegionMouseMoveEventArgs {

            /** Includes data of mouse moved region
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface DrillDownClickEventArgs {

            /** Clicked point data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface DrillDownBackEventArgs {

            /** Drill down data of points
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface DrillDownResetEventArgs {

            /** Drill down reset data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface ClickEventArgs {

            /** Includes clicked region data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface DoubleClickEventArgs {

            /** Includes double clicked region data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface RightClickEventArgs {

            /** Includes right clicked region data
             */
            data?: string;

            /** Set this option to true to cancel the event
             */
            cancel?: boolean;

            /** Instance of the sunburst model object
             */
            model?: any;

            /** Name of the event
             */
            type?: string;
        }

        export interface Border {

            /** Border color of the sunburst.
             * @Default {null}
             */
            color?: string;

            /** Width of the Sunburst border.
             * @Default {2}
             */
            width?: number;
        }

        export interface SegmentBorder {

            /** Segment Border color of the sunburst.
             * @Default {null}
             */
            color?: string;

            /** Width of the Sunburst segment border.
             * @Default {2}
             */
            width?: number;
        }

        export interface Size {

            /** Height of the Sunburst.
             * @Default {''}
             */
            height?: string;

            /** Width of the Sunburst.
             * @Default {''}
             */
            width?: string;
        }

        export interface TooltipBorder {

            /** Border color of the tooltip.
             * @Default {null}
             */
            color?: string;

            /** Border width of the tooltip.
             * @Default {5}
             */
            width?: number;
        }

        export interface TooltipFont {

            /** Font color of the text in the tooltip.
             * @Default {null}
             */
            color?: string;

            /** Font Family for the tooltip.
             * @Default {Segoe UI}
             */
            fontFamily?: string;

            /** Specifies the font Style for the tooltip.
             * @Default {Normal}
             */
            fontStyle?: ej.datavisualization.Sunburst.FontStyle|string;

            /** Specifies the font weight for the tooltip.
             * @Default {Regular}
             */
            fontWeight?: ej.datavisualization.Sunburst.FontWeight|string;

            /** Opacity for text in the tooltip.
             * @Default {1}
             */
            opacity?: number;

            /** Font size for text in the tooltip.
             * @Default {12px}
             */
            size?: string;
        }

        export interface Tooltip {

            /** tooltip visibility of the Sunburst.
             * @Default {true}
             */
            visible?: boolean;

            /** Options for customizing the border of the sunburst tooltip.
             */
            border?: TooltipBorder;

            /** Fill color for the sunburst tooltip.
             * @Default {null}
             */
            fill?: string;

            /** Options for customizing the font of the tooltip.
             */
            font?: TooltipFont;

            /** Custom template to the tooltip.
             * @Default {null}
             */
            template?: string;

            /** Setting the format for the data displayed in the tooltip
             * @Default {#point.x# : #point.y#}
             */
            format?: string;

            /** Sets the opacity of the displayed tooltip
             * @Default {0.95}
             */
            opacity?: number;
        }

        export interface Points {

            /** Points x value of the sunburst.
             * @Default {null}
             */
            x?: string;

            /** Points y value of the sunburst.
             * @Default {null}
             */
            y?: number;

            /** Points text of the sunburst.
             * @Default {null}
             */
            text?: string;

            /** Points fill color of the sunburst.
             * @Default {null}
             */
            fill?: string;
        }

        export interface DataLabelSettingsFont {

            /** Font family of the data label.
             * @Default {Segoe UI}
             */
            fontFamily?: string;

            /** Font style of the data label.
             * @Default {normal. See FontStyle}
             */
            fontStyle?: ej.datavisualization.Sunburst.FontStyle|string;

            /** Font weight of the data label.
             * @Default {regular. See FontWeight}
             */
            fontWeight?: ej.datavisualization.Sunburst.FontWeight|string;

            /** Opacity of the text.
             * @Default {1}
             */
            opacity?: number;

            /** Font color of the data label text.
             * @Default {null}
             */
            color?: string;

            /** Font size of the data label.
             * @Default {12px}
             */
            size?: string;
        }

        export interface DataLabelSettings {

            /** Datalabel visibility of the Sunburst.
             * @Default {false}
             */
            visible?: boolean;

            /** Alignment of sunburst datalabel
             * @Default {Angle. See DatalabelAlignment}
             */
            labelRotationMode?: ej.datavisualization.Sunburst.SunburstLabelRotationMode|string;

            /** Options for customizing the data label font.
             */
            font?: DataLabelSettingsFont;

            /** Custom template for datalabel
             * @Default {null}
             */
            template?: string;

            /** Fill color for the datalabel
             * @Default {null}
             */
            fill?: string;

            /** Datalabel overflow mode
             * @Default {Trim. See LabelOverflowMode}
             */
            labelOverflowMode?: ej.datavisualization.Sunburst.SunburstLabelOverflowMode|string;
        }

        export interface TitleFont {

            /** Font family for Sunburst title.
             * @Default {Segoe UI}
             */
            fontFamily?: string;

            /** Font style for Sunburst title.
             * @Default {Normal. See FontStyle}
             */
            fontStyle?: ej.datavisualization.Sunburst.FontStyle|string;

            /** Font weight for Sunburst title.
             * @Default {Regular. See FontWeight}
             */
            fontWeight?: ej.datavisualization.Sunburst.FontWeight|string;

            /** Opacity of the Sunburst title.
             * @Default {1}
             */
            opacity?: number;

            /** Font size for Sunburst title.
             * @Default {20px}
             */
            size?: string;
        }

        export interface TitleSubtitleFont {

            /** Font family of sub title.
             * @Default {Segoe UI}
             */
            fontFamily?: string;

            /** Font style for sub title.
             * @Default {Normal. See FontStyle}
             */
            fontStyle?: ej.datavisualization.Sunburst.FontStyle|string;

            /** Font weight for sub title.
             * @Default {Regular. See FontWeight}
             */
            fontWeight?: ej.datavisualization.Sunburst.FontWeight|string;

            /** Opacity of the sub title.
             * @Default {1}
             */
            opacity?: number;

            /** Font size for sub title.
             * @Default {12px}
             */
            size?: string;
        }

        export interface TitleSubtitle {

            /** Subtitle text for sunburst
             */
            text?: string;

            /** Sub title text visibility for sunburst
             * @Default {true}
             */
            visible?: string;

            /** Sub title text alignment
             * @Default {far. See TextAlignment}
             */
            textAlignment?: ej.datavisualization.Sunburst.SunburstAlignment|string;

            /** Options for customizing the font of sub title.
             */
            font?: TitleSubtitleFont;
        }

        export interface Title {

            /** Title text for sunburst
             */
            text?: string;

            /** Title text visibility for sunburst
             * @Default {true}
             */
            visible?: string;

            /** Title text alignment
             * @Default {center. See TextAlignment}
             */
            textAlignment?: ej.datavisualization.Sunburst.SunburstAlignment|string;

            /** Options for customizing the font of sunburst title.
             */
            font?: TitleFont;

            /** Options to customize the sub title of Sunburst.
             */
            subtitle?: TitleSubtitle;
        }

        export interface HighlightSettings {

            /** Enables/disables the ability to highlight the levels or point interactively.
             * @Default {false}
             */
            enable?: boolean;

            /** Specifies whether the levels or point has to be highlighted.
             * @Default {point. See Mode}
             */
            mode?: ej.datavisualization.Sunburst.SunburstHighlightMode|string;

            /** Color of the levels/point on highlight.
             * @Default {red}
             */
            color?: string;

            /** Opacity of the levels/point on highlight.
             * @Default {0.5}
             */
            opacity?: number;

            /** Specifies whether the levels or data point has to be highlighted.
             * @Default {opacity. See Mode}
             */
            type?: ej.datavisualization.Sunburst.SunburstHighlightType|string;
        }

        export interface SelectionSettings {

            /** Enables/disables the ability to select the levels or data point interactively.
             * @Default {false}
             */
            enable?: boolean;

            /** Specifies whether the levels or data point has to be selected.
             * @Default {point. See Mode}
             */
            mode?: ej.datavisualization.Sunburst.SunburstHighlightMode|string;

            /** Color of the levels/point on selection.
             * @Default {green}
             */
            color?: string;

            /** Opacity of the levels/point on selection.
             * @Default {0.5}
             */
            opacity?: number;

            /** Specifies whether the levels or data point has to be selected.
             * @Default {opacity. See Mode}
             */
            type?: ej.datavisualization.Sunburst.SunburstHighlightType|string;
        }

        export interface Level {

            /** Specifies the group member path
             * @Default {null}
             */
            groupMemberPath?: string;
        }

        export interface LegendBorder {

            /** Border color of the legend.
             * @Default {null}
             */
            color?: string;

            /** Border width of the legend.
             * @Default {1}
             */
            width?: number;
        }

        export interface LegendFont {

            /** Font family for legend item text.
             * @Default {Segoe UI}
             */
            fontFamily?: string;

            /** Font style for legend item text.
             * @Default {Normal. See FontStyle}
             */
            fontStyle?: ej.datavisualization.Sunburst.FontStyle|string;

            /** Font weight for legend item text.
             * @Default {Regular. See FontWeight}
             */
            fontWeight?: ej.datavisualization.Sunburst.FontWeight|string;

            /** Font size for legend item text.
             * @Default {12px}
             */
            size?: string;
        }

        export interface LegendItemStyle {

            /** Height of the shape in legend items.
             * @Default {10}
             */
            height?: number;

            /** Width of the shape in legend items.
             * @Default {10}
             */
            width?: number;
        }

        export interface LegendLocation {

            /** X value or horizontal offset to position the legend in chart.
             * @Default {0}
             */
            x?: number;

            /** Y value or vertical offset to position the legend.
             * @Default {0}
             */
            y?: number;
        }

        export interface LegendSize {

            /** Height of the legend. Height can be specified in either pixel or percentage.
             * @Default {null}
             */
            height?: string;

            /** Width of the legend. Width can be specified in either pixel or percentage.
             * @Default {null}
             */
            width?: string;
        }

        export interface LegendTitleFont {

            /** Font family for the text in legend title.
             * @Default {Segoe UI}
             */
            fontFamily?: string;

            /** Font style for legend title.
             * @Default {normal. See FontStyle}
             */
            fontStyle?: ej.datavisualization.Sunburst.FontStyle|string;

            /** Font weight for legend title.
             * @Default {normal. See FontWeight}
             */
            fontWeight?: ej.datavisualization.Sunburst.FontWeight|string;

            /** Font size for legend title.
             * @Default {12px}
             */
            size?: string;
        }

        export interface LegendTitle {

            /** Options to customize the font used for legend title
             */
            font?: LegendTitleFont;

            /** Enables or disables the legend title.
             * @Default {true}
             */
            visible?: string;

            /** Text to be displayed in legend title.
             */
            text?: string;

            /** Alignment of the legend title.
             * @Default {center. See Alignment}
             */
            textAlignment?: ej.datavisualization.Sunburst.SunburstAlignment|string;
        }

        export interface Legend {

            /** Visibility of the legend.
             * @Default {false}
             */
            visible?: boolean;

            /** Interactive action of legend items.
             * @Default {toggleSegmentVisibility. See Alignment}
             */
            clickAction?: ej.datavisualization.Sunburst.SunburstClickAction|string;

            /** Horizontal alignment of the legend.
             * @Default {Center. See Alignment}
             */
            alignment?: ej.datavisualization.Sunburst.SunburstAlignment|string;

            /** Options for customizing the legend border.
             */
            border?: LegendBorder;

            /** Number of columns to arrange the legend items.
             * @Default {null}
             */
            columnCount?: number;

            /** Number of rows to arrange the legend items.
             * @Default {null}
             */
            rowCount?: number;

            /** Options to customize the font used for legend item text.
             */
            font?: LegendFont;

            /** Gap or padding between the legend items.
             * @Default {10}
             */
            itemPadding?: number;

            /** Options to customize the style of legend items.
             */
            itemStyle?: LegendItemStyle;

            /** Options to customize the location of sunburst legend. Legend is placed in provided location only when value of position property is custom
             */
            location?: LegendLocation;

            /** Places the legend at specified position. Legend can be placed at **left**, **right**, **top** or **bottom** of the chart area. To manually specify the location of legend, set
             * **custom** as value to this property.
             * @Default {Bottom. See Position}
             */
            position?: ej.datavisualization.Sunburst.SunburstLegendPosition|string;

            /** Shape of the legend items.
             * @Default {None. See Shape}
             */
            shape?: ej.datavisualization.Sunburst.SunburstLegendShape|string;

            /** Options to customize the size of the legend.
             */
            size?: LegendSize;

            /** Options to customize the legend title.
             */
            title?: LegendTitle;
        }

        export interface Margin {

            /** Spacing for the left margin of chart area. Setting positive value decreases the width of the chart area from left side.
             * @Default {10}
             */
            left?: number;

            /** Spacing for the right margin of chart area. Setting positive value decreases the width of the chart area from right side.
             * @Default {10}
             */
            right?: number;

            /** Spacing for the top margin of chart area. Setting positive value decreases the height of the chart area from the top.
             * @Default {10}
             */
            top?: number;

            /** Spacing for the bottom margin of the chart area. Setting positive value decreases the height of the chart area from the bottom.
             * @Default {10}
             */
            bottom?: number;
        }

        export interface ZoomSettings {

            /** Enables or disables zooming.
             * @Default {false}
             */
            enable?: boolean;

            /** Toolbar horizontal alignment
             * @Default {right. See Alignment}
             */
            toolbarHorizontalAlignment?: ej.datavisualization.Sunburst.SunburstHorizontalAlignment|string;

            /** Toolbar vertical alignment
             * @Default {top. See Alignment}
             */
            toolbarVerticalAlignment?: ej.datavisualization.Sunburst.SunburstVerticalAlignment|string;
        }
    }
    namespace Sunburst {
        enum FontStyle {
            //string
            Normal,
            //string
            Italic,
        }
    }
    namespace Sunburst {
        enum FontWeight {
            //string
            Regular,
            //string
            Bold,
            //string
            Lighter,
        }
    }
    namespace Sunburst {
        enum SunburstLabelRotationMode {
            //string
            Angle,
            //string
            Normal,
        }
    }
    namespace Sunburst {
        enum SunburstLabelOverflowMode {
            //string
            Trim,
            //string
            Hide,
            //string
            None,
        }
    }
    namespace Sunburst {
        enum SunburstAlignment {
            //string
            Center,
            //string
            Near,
            //string
            Far,
        }
    }
    namespace Sunburst {
        enum SunburstHighlightMode {
            //string
            Point,
            //string
            Parent,
            //string
            Child,
            //string
            All,
        }
    }
    namespace Sunburst {
        enum SunburstHighlightType {
            //string
            Opacity,
            //string
            Color,
        }
    }
    namespace Sunburst {
        enum SunburstClickAction {
            //string
            None,
            //string
            ToggleSegmentVisibility,
            //string
            ToggleSegmentSelection,
        }
    }
    namespace Sunburst {
        enum SunburstLegendPosition {
            //string
            Left,
            //string
            Right,
            //string
            Top,
            //string
            Bottom,
        }
    }
    namespace Sunburst {
        enum SunburstLegendShape {
            //string
            Diamond,
            //string
            Pentagon,
            //string
            Rectangle,
            //string
            Circle,
            //string
            Cross,
            //string
            Triangle,
        }
    }
    namespace Sunburst {
        enum SunburstTheme {
            //string
            FlatLight,
            //string
            FlatDark,
        }
    }
    namespace Sunburst {
        enum SunburstHorizontalAlignment {
            //string
            Center,
            //string
            Left,
            //string
            Right,
        }
    }
    namespace Sunburst {
        enum SunburstVerticalAlignment {
            //string
            Top,
            //string
            Bottom,
            //string
            Middle,
        }
    }
    namespace Sunburst {
        enum Animation {
            //string
            Rotation,
            //string
            FadeIn,
        }
    }

    class PivotGrid extends ej.Widget {
        static fn: PivotGrid;
        constructor(element: JQuery | Element, options?: PivotGrid.Model);
        static Locale: any;
        model: PivotGrid.Model;
        defaults: PivotGrid.Model;

        /** Performs an asynchronous HTTP (AJAX) request.
         * @returns {void}
         */
        doAjaxPost(): void;

        /** Performs an asynchronous HTTP (FullPost) submit.
         * @returns {void}
         */
        doPostBack(): void;

        /** Exports the PivotGrid to the specified format.
         * @returns {void}
         */
        exportPivotGrid(): void;

        /** This function re-renders the PivotGrid when clicking the navigation buttons on the PivotPager.
         * @returns {void}
         */
        refreshPagedPivotGrid(): void;

        /** This function refreshes the PivotGrid with the modified data input in client-mode.
         * @returns {void}
         */
        refreshPivotGrid(): void;

        /** This function re-renders the control with the report available at that instant.
         * @returns {void}
         */
        refreshControl(): void;

        /** This function destroys the PivotGrid widget associated events that are bound using &quot;this._on&quot; and brings the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** This function returns the height of all rows and the width of all columns.
         * @returns {any}
         */
        calculateCellWidths(): any;

        /** This function creates the conditional formatting dialog to apply conditional formatting for the PivotGrid control.
         * @returns {void}
         */
        openConditionalFormattingDialog(): void;

        /** This function saves the current report to the database/local storage.
         * @returns {void}
         */
        saveReport(): void;

        /** This function loads the specified report from the database/local storage.
         * @returns {void}
         */
        loadReport(): void;

        /** This function reconstructs the JSON data that is formed for rendering the PivotGrid in the excel-like layout format.
         * @returns {void}
         */
        excelLikeLayout(): void;

        /** Returns the OlapReport string that is maintained along with the axis elements information.
         * @returns {string}
         */
        getOlapReport(): string;

        /** Sets the OlapReport string along with the axis information.
         * @returns {void}
         */
        setOlapReport(): void;

        /** Returns the JSON records that are formed to render the control.
         * @returns {any[]}
         */
        getJSONRecords(): any[];

        /** Sets the JSON records that are formed to render the control.
         * @returns {void}
         */
        setJSONRecords(): void;

        /** This function allows you to change the caption of the pivot item (name displayed in UI) on-demand for the relational datasource in client-mode.
         * @returns {void}
         */
        refreshFieldCaption(): void;

        /** This function receives the JSON formatted datasource to render the PivotGrid control.
         * @returns {void}
         */
        renderControlFromJSON(): void;
    }
    export namespace PivotGrid {

        export interface Model {

            /** Sets the mode for the PivotGrid widget to bind either OLAP or relational data source.
             * @Default {ej.Pivot.AnalysisMode.Pivot}
             */
            analysisMode?: ej.Pivot.AnalysisMode|string;

            /** Specifies the CSS class to the PivotGrid for achieving the custom theme.
             * @Default {â€œâ€}
             */
            cssClass?: string;

            /** Connects the PivotSchemaDesigner with specified ID to the PivotGrid control.
             * @Default {â€œâ€}
             */
            pivotTableFieldListID?: string;

            /** Initializes the data source for the PivotGrid widget, when it functions completely on client-side.
             * @Default {{}}
             */
            dataSource?: DataSource;

            /** Holds the necessary properties for value sorting.
             * @Default {{}}
             */
            valueSortSettings?: ValueSortSettings;

            /** Object that holds the settings of frozen headers.
             * @Default {{}}
             */
            frozenHeaderSettings?: FrozenHeaderSettings;

            /** Allows you to display the header name in the PivotGrid control.
             * @Default {{}}
             */
            headerSettings?: HeaderSettings;

            /** Allows you to show the appropriate unique name in the pivot button.
             * @Default {false}
             */
            showUniqueNameOnPivotButton?: boolean;

            /** Object is utilized to pass additional information between the client-end and the service-end while operating the control in server mode.
             * @Default {null}
             */
            customObject?: any;

            /** Allows you to collapse specified members in each field by default.
             * @Default {null}
             */
            collapsedMembers?: any;

            /** Allows you to access each cell by right-clicking the mouse.
             * @Default {false}
             */
            enableCellContext?: boolean;

            /** Enables the cell selection for a specific range of value cells.
             * @Default {false}
             */
            enableCellSelection?: boolean;

            /** Enables the Drill-Through feature which retrieves raw items that are used to create a specific cell in the PivotGrid.
             * @Default {false}
             */
            enableDrillThrough?: boolean;

            /** Allows you to get cell details in JSON format by clicking the value cell.
             * @Default {false}
             */
            enableCellClick?: boolean;

            /** Allows you to get cell details in JSON format by double-clicking the value cell.
             * @Default {false}
             */
            enableCellDoubleClick?: boolean;

            /** Allows you to edit value cells for write-back support in the PivotGrid. This is applicable only for the server-mode.
             * @Default {false}
             */
            enableCellEditing?: boolean;

            /** Collapses the pivot items along rows and columns by default. It works only for the relational data source.
             * @Default {false}
             */
            enableCollapseByDefault?: boolean;

            /** Enables/disables the display of grand total for all columns.
             * @Default {true}
             */
            enableColumnGrandTotal?: boolean;

            /** Allows you to format a specific set of cells based on the condition.
             * @Default {false}
             */
            enableConditionalFormatting?: boolean;

            /** Enables the advanced filtering options such as value filtering, label filtering, and sorting for each field in the server mode.
             * @Default {false}
             */
            enableAdvancedFilter?: boolean;

            /** Allows you to refresh the control on-demand and not during every UI operation.
             * @Default {false}
             */
            enableDeferUpdate?: boolean;

            /** Enables the display of GroupingBar allowing you to filter, sort, and remove fields obtained from the datasource.
             * @Default {false}
             */
            enableGroupingBar?: boolean;

            /** Allows you to set the maximum number of nodes as well as child nodes to be displayed in the member editor.
             * @Default {1000}
             */
            maxNodeLimitInMemberEditor?: number;

            /** Enables/disables paging in the member editor for viewing the large count of members in pages.
             * @Default {false}
             */
            enableMemberEditorPaging?: boolean;

            /** Allows you to set the number of members to be displayed in each page of member editor on applying paging in it.
             * @Default {100}
             */
            memberEditorPageSize?: number;

            /** Enables/Disables sorting option in member editor dialog for the members of the respective field.
             * @Default {false}
             */
            enableMemberEditorSorting?: boolean;

            /** Enables/disables the display of grand total for rows and columns.
             * @Default {true}
             */
            enableGrandTotal?: boolean;

            /** Allows you to load the PivotGrid using the JSON data.
             * @Default {false}
             */
            enableJSONRendering?: boolean;

            /** Enables rendering of the PivotGrid widget along with the PivotTable field list which allows UI operations.
             * @Default {true}
             */
            enablePivotFieldList?: boolean;

            /** Enables the display of grand total for all rows.
             * @Default {true}
             */
            enableRowGrandTotal?: boolean;

            /** Allows you to view the layout of PivotGrid from right to left.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Allows you to enable the ToolTip.
             * @Default {false}
             */
            enableToolTip?: boolean;

            /** Allows you to enable the animation effects in the tooltip.
             * @Default {false}
             */
            enableToolTipAnimation?: boolean;

            /** Allows you to adjust the width of columns dynamically within given widget size.
             * @Default {false}
             */
            enableColumnResizing?: boolean;

            /** Allows you to fit the width of the column based on its maximum text width.
             * @Default {true}
             */
            resizeColumnsToFit?: boolean;

            /** Allows you to enable/disable the context menu of pivot buttons in the PivotGrid.
             * @Default {false}
             */
            enableContextMenu?: boolean;

            /** Allows you to view the large amount of data through virtual scrolling.
             * @Default {false}
             */
            enableVirtualScrolling?: boolean;

            /** Allows you to view the large amount of data by applying paging.
             * @Default {false}
             */
            enablePaging?: boolean;

            /** Allows you to configure the hyperlink settings of the PivotGrid control.
             * @Default {{}}
             */
            hyperlinkSettings?: HyperlinkSettings;

            /** Allows you to enable PivotGridâ€™s responsiveness in the browser layout.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Contains the serialized JSON string which renders the PivotGrid.
             */
            jsonRecords?: string;

            /** Sets the summary layout for PivotGrid.Following are the ways in which summary can be positioned: normal summary (bottom), top summary, no summary, and excel-like summary.
             * @Default {ej.PivotGrid.Layout.Normal}
             */
            layout?: ej.PivotGrid.Layout|string;

            /** Allows the user to set the localized language for the widget.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the mode for PivotGrid widget for binding the data source either in the server-side or client-side.
             * @Default {ej.Pivot.OperationalMode.ClientMode}
             */
            operationalMode?: ej.Pivot.OperationalMode|string;

            /** Allows you to set the custom name for the methods at service-end, communicated during AJAX post.
             * @Default {{}}
             */
            serviceMethodSettings?: ServiceMethodSettings;

            /** Connects the service using the specified URL for any server updates.
             * @Default {â€œâ€}
             */
            url?: string;

            /** Allows you to export entire data instead of current page data, while paging option is enabled.
             * @Default {false}
             */
            enableCompleteDataExport?: boolean;

            /** Allows you to enable &quot;withCredentials&quot; property inside XMLHttpRequest object for CORS(Cross-Origin Resource Sharing) request.
             * @Default {false}
             */
            enableXHRCredentials?: boolean;

            /** Triggers when it reaches client-side after the AJAX request.
             */
            afterServiceInvoke?(e: AfterServiceInvokeEventArgs): void;

            /** Triggers before any AJAX request is passed from the PivotGrid to service methods.
             */
            beforeServiceInvoke?(e: BeforeServiceInvokeEventArgs): void;

            /** Triggers before the pivot engine starts to populate.
             */
            beforePivotEnginePopulate?(e: BeforePivotEnginePopulateEventArgs): void;

            /** Triggers when click action is performed over a value cell.
             */
            cellClick?(e: CellClickEventArgs): void;

            /** Triggers when double-click action is performed over a value cell.
             */
            cellDoubleClick?(e: CellDoubleClickEventArgs): void;

            /** Triggers when right-click action is performed on a cell.
             */
            cellContext?(e: CellContextEventArgs): void;

            /** Triggers when a specific range of value cells is selected.
             */
            cellSelection?(e: CellSelectionEventArgs): void;

            /** Triggers when the hyperlink of column header is clicked.
             */
            columnHeaderHyperlinkClick?(e: ColumnHeaderHyperlinkClickEventArgs): void;

            /** Triggers after performing drill operation in the PivotGrid.
             */
            drillSuccess?(e: DrillSuccessEventArgs): void;

            /** Triggers while clicking &quot;OK&quot; in the drill-through dialog.
             */
            drillThrough?(e: DrillThroughEventArgs): void;

            /** Triggers when the PivotGrid loading is initiated.
             */
            load?(e: LoadEventArgs): void;

            /** Triggers when PivotGrid widget completes all operations at client-side after any AJAX request.
             */
            renderComplete?(e: RenderCompleteEventArgs): void;

            /** Triggers when any error occurred during the AJAX request.
             */
            renderFailure?(e: RenderFailureEventArgs): void;

            /** Triggers when the PivotGrid successfully reaches the client-side after any AJAX request.
             */
            renderSuccess?(e: RenderSuccessEventArgs): void;

            /** Triggers when the hyperlink of row header is clicked.
             */
            rowHeaderHyperlinkClick?(e: RowHeaderHyperlinkClickEventArgs): void;

            /** Triggers when the hyperlink of summary cell is clicked.
             */
            summaryCellHyperlinkClick?(e: SummaryCellHyperlinkClickEventArgs): void;

            /** Triggers when the hyperlink of value cell is clicked.
             */
            valueCellHyperlinkClick?(e: ValueCellHyperlinkClickEventArgs): void;

            /** Triggers before saving the current report to the database.
             */
            saveReport?(e: SaveReportEventArgs): void;

            /** Triggers before loading a report from the database.
             */
            loadReport?(e: LoadReportEventArgs): void;

            /** Triggers before performing exporting in the pivot grid.
             */
            beforeExport?(e: BeforeExportEventArgs): void;

            /** Triggers before editing the cells.
             */
            cellEdit?(e: CellEditEventArgs): void;
        }

        export interface AfterServiceInvokeEventArgs {

            /** returns the current action of PivotGrid control.
             */
            action?: string;

            /** returns the custom object bound with PivotGrid control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface BeforeServiceInvokeEventArgs {

            /** returns the current action of PivotGrid control.
             */
            action?: string;

            /** returns the custom object bound with PivotGrid control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface BeforePivotEnginePopulateEventArgs {

            /** returns the PivotGrid object
             */
            pivotGridObject?: any;
        }

        export interface CellClickEventArgs {

            /** returns the JSON details of the respective on cell.
             */
            selectedData?: any[];

            /** returns the custom object bound with PivotGrid control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface CellDoubleClickEventArgs {

            /** returns the JSON details of the double respective on cell.
             */
            selectedData?: any[];

            /** returns the custom object bound with PivotGrid control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface CellContextEventArgs {

            /** returns the cell position (row index and column index) in table.
             */
            cellPosition?: string;

            /** returns the type of the cell.
             */
            cellType?: string;

            /** returns the content of the cell.
             */
            cellValue?: string;

            /** returns the unique name of levels/members.
             */
            uniqueName?: string;

            /** returns the role of the cell in PivotGrid.
             */
            role?: string;

            /** returns JSON record corresponding to the selected cell.
             */
            rawdata?: any;

            /** returns the original event object.
             */
            args?: any;
        }

        export interface CellSelectionEventArgs {

            /** returns the JSON records of the selected range of cells.
             */
            JSONRecords?: any;

            /** Returns the row headers corresponding to the selected value cells.
             */
            rowheader?: any;

            /** Returns the column headers corresponding to the selected value cells.
             */
            columnheader?: any;

            /** Returns the information about the measure associated with the selected cell.
             */
            measureCount?: string;
        }

        export interface ColumnHeaderHyperlinkClickEventArgs {

            /** returns the information about the clicked cell
             */
            args?: any;

            /** returns the HTML element of the control.
             */
            element?: any;

            /** returns the custom object bound to the control.
             */
            customObject?: any;
        }

        export interface DrillSuccessEventArgs {

            /** returns the HTML element of the control.
             */
            args?: any;
        }

        export interface DrillThroughEventArgs {

            /** return the JSON records of the generated cells on drill-through operation.
             */
            data?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface LoadEventArgs {

            /** returns the custom object bound with the control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface RenderCompleteEventArgs {

            /** returns the current action of PivotGrid control.
             */
            action?: string;

            /** returns the custom object bound with the control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface RenderFailureEventArgs {

            /** returns the current action of PivotGrid control.
             */
            action?: string;

            /** returns the custom object bound with the control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;

            /** returns the error message with error code.
             */
            message?: string;
        }

        export interface RenderSuccessEventArgs {

            /** returns the current action of PivotGrid control.
             */
            action?: string;

            /** returns the custom object bound with the control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface RowHeaderHyperlinkClickEventArgs {

            /** returns the information about the clicked cell
             */
            args?: any;

            /** returns the HTML element of the control.
             */
            element?: any;

            /** returns the custom object bound to the control.
             */
            customObject?: any;
        }

        export interface SummaryCellHyperlinkClickEventArgs {

            /** returns the information about the clicked cell
             */
            args?: any;

            /** returns the HTML element of the control.
             */
            element?: any;

            /** returns the custom object bound to the control.
             */
            customObject?: any;
        }

        export interface ValueCellHyperlinkClickEventArgs {

            /** returns the information about the clicked cell
             */
            args?: any;

            /** returns the HTML element of the control.
             */
            element?: any;

            /** returns the custom object bound to the control.
             */
            customObject?: any;
        }

        export interface SaveReportEventArgs {

            /** returns the report to be stored in database.
             */
            report?: any;
        }

        export interface LoadReportEventArgs {

            /** returns the PivotGrid object.
             */
            targetControl?: any;

            /** returns whether the control is bound with OLAP or Relational data source.
             */
            dataModel?: string;
        }

        export interface BeforeExportEventArgs {

            /** contains the url of the service responsible for exporting.
             */
            url?: string;

            /** contains the name of the exporting file.
             */
            fileName?: string;
        }

        export interface CellEditEventArgs {

            /** contains the array of cells selected for editing.
             */
            editCellsInfo?: any[];
        }

        export interface DataSourceColumnsAdvancedFilter {

            /** Allows you to provide a level unique name to perform the advanced filtering.
             */
            name?: string;

            /** Allows you to set the operator to perform the label filtering.
             * @Default {none}
             */
            labelFilterOperator?: string;

            /** Allows you to set the operator to perform the value filtering.
             * @Default {none}
             */
            valueFilterOperator?: string;

            /** Allows you to set the filtering type while performing the advanced filtering.
             */
            advancedFilterType?: string;

            /** In value filtering, this property contains the measure name to which the filter is applied.
             */
            measure?: string;

            /** Allows you to hold filter operand values in the advanced filtering.
             */
            values?: any[];
        }

        export interface DataSourceColumnsFilterItems {

            /** Sets the type of filter to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceColumn {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Allows you to set the display caption for an item.
             */
            fieldCaption?: string;

            /** Allows you to filter the report by using advanced filtering (e.g., Microsoft Excel) option for the OLAP data source in client-mode.
             * @Default {[]}
             */
            advancedFilter?: DataSourceColumnsAdvancedFilter[];

            /** Allows you to indicate whether the added item is a named set or not.
             * @Default {false}
             */
            isNamedSets?: boolean;

            /** Shows/hides the sub-total of the field in PivotGrid.
             * @Default {true}
             */
            showSubTotal?: boolean;

            /** Allows you to set the format for column headers.
             */
            format?: string;

            /** This property is set to display the formatted values with format types in the PivotGrid.
             */
            formatString?: string;

            /** Allows you to set the custom theme for column headers.
             */
            cssClass?: string;

            /** Allows you to set the delimiter for date type format in the formatString. This is applicable for the groupByDate of row/column headers.
             */
            delimiter?: string;

            /** Allows you to set the sorting order of members of the field.
             * @Default {ej.PivotAnalysis.SortOrder.Ascending}
             */
            sortOrder?: ej.PivotAnalysis.SortOrder|string;

            /** Contains the list of members need to be drilled down by default in the field.
             * @Default {[]}
             */
            drilledItems?: any[];

            /** Applies the filter to field members.
             * @Default {null}
             */
            filterItems?: DataSourceColumnsFilterItems;
        }

        export interface DataSourceRowsAdvancedFilter {

            /** Allows you to provide the level unique name to perform the advanced filtering.
             */
            name?: string;

            /** Allows you to set the operator to perform the label filtering.
             * @Default {none}
             */
            labelFilterOperator?: string;

            /** Allows you to set the operator to perform the value filtering.
             * @Default {none}
             */
            valueFilterOperator?: string;

            /** Allows you to set the filtering type while performing the advanced filtering.
             */
            advancedFilterType?: string;

            /** In value filtering, this property contains the measure name to which the filter is applied.
             */
            measure?: string;

            /** Allows you to hold the filter operand values in the advanced filtering.
             */
            values?: any[];
        }

        export interface DataSourceRowsFilterItems {

            /** Sets the type of filter to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceRow {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Allows you to set the display caption for the item.
             */
            fieldCaption?: string;

            /** Allows you to filter the report by using the advanced filtering (e.g., Microsoft Excel) option for the OLAP data source in client-mode.
             * @Default {[]}
             */
            advancedFilter?: DataSourceRowsAdvancedFilter[];

            /** Allows you to indicate whether the added item is a named set or not.
             * @Default {false}
             */
            isNamedSets?: boolean;

            /** Shows/hides the sub-total of the field.
             * @Default {true}
             */
            showSubTotal?: boolean;

            /** Allows you to set the format for row headers.
             */
            format?: string;

            /** This property is set to display the formatted values with format types in the PivotGrid.
             */
            formatString?: string;

            /** Allows you to set the custom theme for row headers.
             */
            cssClass?: string;

            /** Allows you to set the delimiter for date type format in the formatString. This is applicable for the groupByDate in row/column headers.
             */
            delimiter?: string;

            /** Allows you to set the sorting order of members of the field.
             * @Default {ej.PivotAnalysis.SortOrder.Ascending}
             */
            sortOrder?: ej.PivotAnalysis.SortOrder|string;

            /** Contains the list of members need to be drilled down by default in the field.
             * @Default {[]}
             */
            drilledItems?: any[];

            /** Applies the filter to field members.
             * @Default {null}
             */
            filterItems?: DataSourceRowsFilterItems;
        }

        export interface DataSourceValuesMeasure {

            /** Allows you to bind the measure from the OLAP datasource by using its unique name as field name.
             */
            fieldName?: string;
        }

        export interface DataSourceValue {

            /** Allows you to bind the item by using its unique name as field name for the relational datasource.
             */
            fieldName?: string;

            /** Allows you to set the display caption for the item in the relational datasource.
             */
            fieldCaption?: string;

            /** This holds the list of unique names of measures to bind them from the OLAP cube.
             * @Default {[]}
             */
            measures?: DataSourceValuesMeasure[];

            /** Allows you to set the axis name to place measures items.
             * @Default {rows}
             */
            axis?: string;

            /** Indicates whether the field is a calculated field with the relational datasource or not.
             * @Default {false}
             */
            isCalculatedField?: boolean;

            /** Allows to set the type of PivotGrid summary calculation in the value field with the relational datasource.
             * @Default {ej.PivotAnalysis.SummaryType.Sum}
             */
            summaryType?: ej.PivotAnalysis.SummaryType|string;

            /** Allows to set the format for values.
             */
            format?: string;

            /** This property is set to display the formatted values with format types in the PivotGrid.
             */
            formatString?: string;

            /** Allows to set the formula for calculation of values for calculated members in the relational datasource.
             */
            formula?: string;

            /** Allows to set the custom theme for values.
             */
            cssClass?: string;
        }

        export interface DataSourceFiltersFilterItems {

            /** Sets the type of filter to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceFilter {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Allows you to set the display name for the item.
             */
            fieldCaption?: string;

            /** Applies the filter to field members.
             * @Default {null}
             */
            filterItems?: DataSourceFiltersFilterItems;
        }

        export interface DataSourcePagerOptions {

            /** Allows to set the number of categorical columns to be displayed in each page on applying the paging.
             * @Default {0}
             */
            categoricalPageSize?: number;

            /** Allows to set the number of series rows to be displayed in each page on applying the paging.
             * @Default {0}
             */
            seriesPageSize?: number;

            /** Allows to set the page number to be loaded in the categorical axis by default.
             * @Default {1}
             */
            categoricalCurrentPage?: number;

            /** Allows to set the page number to be loaded in the series axis by default.
             * @Default {1}
             */
            seriesCurrentPage?: number;
        }

        export interface DataSource {

            /** Lists out the items to be arranged in the columns section of the PivotGrid.
             * @Default {[]}
             */
            columns?: DataSourceColumn[];

            /** Lists out the items to be arranged in the rows section of PivotGrid.
             * @Default {[]}
             */
            rows?: DataSourceRow[];

            /** Lists out the items that support calculation in the PivotGrid.
             * @Default {[]}
             */
            values?: DataSourceValue[];

            /** Lists out the items which supports filtering of values without displaying the members in UI of the PivotGrid.
             * @Default {[]}
             */
            filters?: DataSourceFilter[];

            /** Contains the respective cube name as string type in the OLAP database.
             * @Default {â€œâ€}
             */
            cube?: string;

            /** To set the data source name to fetch the data.
             * @Default {â€œâ€}
             */
            sourceInfo?: string;

            /** Sets the provider name for PivotGrid to identify whether the provider is SSAS or Mondrian.
             * @Default {ssas}
             */
            providerName?: string;

            /** Provides the raw data source for the PivotGrid.
             * @Default {null}
             */
            data?: any;

            /** In connection with an OLAP database, this property contains the database name as string to fetch the data from the given connection string.
             * @Default {â€œâ€}
             */
            catalog?: string;

            /** Allows you to filter the members (by its name and values) through advanced filtering (e.g., Microsoft Excel) option at OLAP data source in client-mode.
             * @Default {false}
             */
            enableAdvancedFilter?: boolean;

            /** Sets a name to the report that is bound to the control.
             */
            reportName?: string;

            /** Allows to set the page size and current page number for each axis on applying the paging.
             * @Default {{}}
             */
            pagerOptions?: DataSourcePagerOptions;
        }

        export interface ValueSortSettings {

            /** Contains the header of the specific column to which value sorting is applied.
             */
            headerText?: string;

            /** Allows you to set the string for separating column headers provided in the headerText property.
             */
            headerDelimiters?: string;

            /** Allows you to set the sorting order of values of the field.
             * @Default {ej.PivotAnalysis.SortOrder.Ascending}
             */
            sortOrder?: ej.PivotAnalysis.SortOrder|string;
        }

        export interface FrozenHeaderSettings {

            /** Allows you to freeze the row headers alone when scrolling the horizontal scroll bar.
             * @Default {false}
             */
            enableFrozenRowHeaders?: boolean;

            /** Allows you to freeze the column headers alone when scrolling the vertical scroll bar.
             * @Default {false}
             */
            enableFrozenColumnHeaders?: boolean;

            /** Allows you to freeze both row headers and column headers while scrolling.
             * @Default {false}
             */
            enableFrozenHeaders?: boolean;

            /** Allows you to set the size of the scrollbar (horizontal and vertical) that is visible in the PivotGrid.
             * @Default {18}
             */
            scrollerSize?: number;
        }

        export interface HeaderSettings {

            /** Allows you to enable/disable the row header names in the PivotGrid control.
             * @Default {false}
             */
            showRowItems?: boolean;

            /** Allows you to enable/disable the column header names in the PivotGrid control.
             * @Default {false}
             */
            showColumnItems?: boolean;
        }

        export interface HyperlinkSettings {

            /** Allows you to enable/disable the hyperlink for the column header.
             * @Default {false}
             */
            enableColumnHeaderHyperlink?: boolean;

            /** Allows you to enable/disable the hyperlink for the row header.
             * @Default {false}
             */
            enableRowHeaderHyperlink?: boolean;

            /** Allows you to enable/disable the hyperlink for summary cells.
             * @Default {false}
             */
            enableSummaryCellHyperlink?: boolean;

            /** Allows you to enable/disable the hyperlink for value cells.
             * @Default {false}
             */
            enableValueCellHyperlink?: boolean;
        }

        export interface ServiceMethodSettings {

            /** Allows you to set the custom name for service method which is responsible for drill up/down operation in the PivotGrid.
             * @Default {DrillGrid}
             */
            drillDown?: string;

            /** Allows you to set the custom name for the service method that is responsible for exporting.
             * @Default {Export}
             */
            exportPivotGrid?: string;

            /** Allows you to set the custom name for the service method responsible for performing server-side actions based on defer update.
             * @Default {DeferUpdate}
             */
            deferUpdate?: string;

            /** Allows you to set the custom name for the service method that is responsible for getting values of the tree-view inside filter dialog.
             * @Default {FetchMembers}
             */
            fetchMembers?: string;

            /** Allows you to set the custom name for the service method that is responsible for filtering operation in the PivotGrid.
             * @Default {Filtering}
             */
            filtering?: string;

            /** Allows you to set the custom name for the service method that is responsible for initializing the PivotGrid.
             * @Default {InitializeGrid}
             */
            initialize?: string;

            /** Allows you to set the custom name for the service method that is responsible for the server-side action when dropping a node from the field list.
             * @Default {NodeDropped}
             */
            nodeDropped?: string;

            /** Allows you to set the custom name for the service method that is responsible for server-side action when changing the checked state of a node in the field list.
             * @Default {NodeStateModified}
             */
            nodeStateModified?: string;

            /** Allows you to set the custom name for the service method that is responsible for performing paging operation in the PivotGrid.
             * @Default {Paging}
             */
            paging?: string;

            /** Allows you to set the custom name for the service method that is responsible for sorting operation in the PivotGrid.
             * @Default {Sorting}
             */
            sorting?: string;

            /** Allows you to set the custom name for the service method that is responsible for expanding members in the member editor.
             * @Default {MemberExpanded}
             */
            memberExpand?: string;

            /** Allows you to set the custom name for the service method that is responsible for editing the cells.
             * @Default {CellEditing}
             */
            cellEditing?: string;

            /** Allows you to set the custom name for the service method that is responsible for saving the current report to the database.
             * @Default {SaveReport}
             */
            saveReport?: string;

            /** Allows you to set the custom name for the service method that is responsible for loading a report from the database.
             * @Default {LoadReportFromDB}
             */
            loadReport?: string;

            /** Allows you to set the custom name for the service method that is responsible for adding a calculated field to the report.
             * @Default {CalculatedField}
             */
            calculatedField?: string;

            /** Allows you to set the custom name for the service method that is responsible for performing the drill through operation.
             * @Default {DrillThroughHierarchies}
             */
            drillThroughHierarchies?: string;

            /** Allows you to set the custom name for the service method that is responsible for performing drill through operation in the data table.
             * @Default {DrillThroughDataTable}
             */
            drillThroughDataTable?: string;

            /** Allows you to set the custom name for the service method that is responsible for performing value sorting operation in the PivotGrid.
             * @Default {ValueSorting}
             */
            valueSorting?: string;

            /** Allows you to set the custom name for the service method that is responsible for removing the pivot button from the GroupingBar/field list.
             * @Default {RemoveButton}
             */
            removeButton?: string;

            /** Allows you to set the custom name for the service method that is responsible for write-back operation in the OLAP Cube. This is applicable only in the server-side component.
             * @Default {WriteBack}
             */
            writeBack?: string;
        }

        enum Layout {

            ///To set normal summary layout in PivotGrid.
            Normal,

            ///To set layout with summaries at the top in PivotGrid.
            NormalTopSummary,

            ///To set layout without summaries in PivotGrid.
            NoSummaries,

            ///To set excel-like layout in PivotGrid.
            ExcelLikeLayout
        }

    }
    namespace Pivot {
        enum AnalysisMode {
            //To bind an OLAP data source to PivotGrid.
            OLAP,
            //To bind a relational data source to PivotGrid.
            Pivot,
        }
    }
    namespace PivotAnalysis {
        enum SortOrder {
            //Sorts the members of the field in ascending order.
            Ascending,
            //Sorts the members of the field in descending order.
            Descending,
            //Displays the members without sorting in default order.
            None,
        }
    }
    namespace PivotAnalysis {
        enum FilterType {
            //Excludes the specified values among the members of the field.
            Exclude,
            //Includes the specified values alone among the members of the field.
            Include,
        }
    }
    namespace PivotAnalysis {
        enum SummaryType {
            //Calculates the summary as the total of all values.
            Sum,
            //Displays the average of all values as the summaries.
            Average,
            //Displays the count of items in summaries.
            Count,
            //Displays the minimum value of all the items in the summary.
            Min,
            //Displays the maximum value of all the items in the summary.
            Max,
        }
    }
    namespace Pivot {
        enum OperationalMode {
            //To bind data source completely from client-side.
            ClientMode,
            //To bind data source completely from server-side.
            ServerMode,
        }
    }

    class PivotSchemaDesigner extends ej.Widget {
        static fn: PivotSchemaDesigner;
        constructor(element: JQuery | Element, options?: PivotSchemaDesigner.Model);
        static Locale: any;
        model: PivotSchemaDesigner.Model;
        defaults: PivotSchemaDesigner.Model;

        /** Performs an asynchronous HTTP (AJAX) request.
         * @returns {void}
         */
        doAjaxPost(): void;

        /** Re-renders the control with the data source bound to the pivot control at that instant.
         * @returns {void}
         */
        refreshControl(): void;

        /** This function Destroy the PivotSchemaDesigner widget all events bound using this._on will be unbind automatically and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;
    }
    export namespace PivotSchemaDesigner {

        export interface Model {

            /** Specifies the CSS class to PivotSchemaDesigner to achieve custom theme.
             * @Default {â€œâ€}
             */
            cssClass?: string;

            /** Object utilized to pass additional information between client-end and service-end.
             * @Default {{}}
             */
            customObject?: any;

            /** For ASP.NET and MVC Wrapper, PivotSchemaDesigner will be initialized and rendered empty initially. Once the connected pivot control widget is rendered completely,
             * PivotSchemaDesigner will just be populated with data source by setting this property to â€œtrueâ€.
             * @Default {false}
             */
            enableWrapper?: boolean;

            /** Allows the user to view PivotTable Field List from right to left.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Sets the visibility of OLAP elements in PivotTable Field List. This is only applicable for OLAP datasource.
             * @Default {null}
             */
            olap?: Olap;

            /** Allows the user to enable/disable drag and drop operations within the PivotTable Field List.
             * @Default {true}
             */
            enableDragDrop?: boolean;

            /** Sets the height for PivotSchemaDesigner.
             * @Default {â€œâ€}
             */
            height?: string;

            /** Allows the user to set the localized language for the widget.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the Pivot control bound with this PivotSchemaDesigner.
             * @Default {null}
             */
            pivotControl?: any;

            /** Allows the user to set custom name for the methods at service-end, communicated during AJAX post.
             * @Default {{}}
             */
            serviceMethods?: any;

            /** Connects the service using the specified URL for any server updates.
             * @Default {â€œâ€}
             */
            url?: string;

            /** Sets the width for PivotSchemaDesigner.
             * @Default {â€œâ€}
             */
            width?: string;

            /** Sets the layout for PivotSchemaDesigner.
             * @Default {ej.PivotSchemaDesigner.Layouts.Excel}
             */
            layout?: ej.PivotSchemaDesigner.Layouts|string;

            /** Triggers when PivotSchemaDesigner loading is initiated.
             */
            load?(e: LoadEventArgs): void;

            /** Triggers when it reaches client-side after any AJAX request.
             */
            afterServiceInvoke?(e: AfterServiceInvokeEventArgs): void;

            /** Triggers before any AJAX request is passed from PivotSchemaDesigner to service methods.
             */
            beforeServiceInvoke?(e: BeforeServiceInvokeEventArgs): void;

            /** Triggers when we start dragging any field from PivotSchemaDesigner.
             */
            dragMove?(e: DragMoveEventArgs): void;
        }

        export interface LoadEventArgs {

            /** returns the HTML element of PivotSchemaDesigner control.
             */
            element?: any;
        }

        export interface AfterServiceInvokeEventArgs {

            /** returns the current action of PivotSchemaDesigner control.
             */
            action?: string;

            /** returns the custom object bound with PivotSchemaDesigner control.
             */
            customObject?: any;

            /** returns the HTML element of PivotSchemaDesigner control.
             */
            element?: any;
        }

        export interface BeforeServiceInvokeEventArgs {

            /** returns the current action of PivotSchemaDesigner control.
             */
            action?: string;

            /** returns the custom object bound with PivotSchemaDesigner control.
             */
            customObject?: any;

            /** returns the HTML element of PivotSchemaDesigner control.
             */
            element?: any;
        }

        export interface DragMoveEventArgs {

            /** returns the HTML element of the dragged field from PivotSchemaDesigner.
             */
            dragTarget?: any;

            /** return the JSON details of the dragged field.
             */
            draggedElementData?: any;

            /** if the event should be canceled; otherwise, false.
             */
            cancel?: boolean;

            /** returns the PivotSchemaDesigner model
             */
            model?: any;
        }

        export interface Olap {

            /** Allows the user to view the KPI elements in tree-view inside PivotTable Field List. This is only applicable for OLAP datasource.
             * @Default {false}
             */
            showKPI?: boolean;

            /** Allows the user to view the named sets in tree-view inside PivotTable Field List. This is only applicable for OLAP datasource.
             * @Default {false}
             */
            showNamedSets?: boolean;
        }

        enum Layouts {

            ///To set the layout as same in the Excel.
            Excel,

            ///To set normal layout for Field List.
            Normal,

            ///To set layout with the axes one above the other.
            OneByOne
        }

    }

    class PivotPager extends ej.Widget {
        static fn: PivotPager;
        constructor(element: JQuery | Element, options?: PivotPager.Model);
        static Locale: any;
        model: PivotPager.Model;
        defaults: PivotPager.Model;

        /** This function initializes the page counts and page numbers for the PivotPager.
         * @returns {void}
         */
        initPagerProperties(): void;
    }
    export namespace PivotPager {

        export interface Model {

            /** Contains the current page number in categorical axis.
             * @Default {1}
             */
            categoricalCurrentPage?: number;

            /** Contains the total page count in categorical axis.
             * @Default {1}
             */
            categoricalPageCount?: number;

            /** Allows the user to set the localized language for the widget.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the pager mode (Only Categorical Pager/Only Series Pager/Both) for the PivotPager.
             * @Default {ej.PivotPager.Mode.Both}
             */
            mode?: ej.PivotPager.Mode|string;

            /** Contains the current page number in series axis.
             * @Default {1}
             */
            seriesCurrentPage?: number;

            /** Contains the total page count in series axis.
             * @Default {1}
             */
            seriesPageCount?: number;

            /** Contains the ID of the target element for which paging needs to be done.
             * @Default {â€œâ€}
             */
            targetControlID?: string;
        }

        enum Mode {

            ///To set both categorical and series pager for paging.
            Both,

            ///To set only categorical pager for paging.
            Categorical,

            ///To set only series pager for paging.
            Series
        }

    }

    class PivotChart extends ej.Widget {
        static fn: PivotChart;
        constructor(element: JQuery | Element, options?: PivotChart.Model);
        static Locale: any;
        model: PivotChart.Model;
        defaults: PivotChart.Model;

        /** Posts an asynchronous HTTP (AJAX) request.
         * @returns {void}
         */
        doAjaxPost(): void;

        /** Performs an asynchronous HTTP (FullPost) submit.
         * @returns {void}
         */
        doPostBack(): void;

        /** Exports the pivot chart to the format that is specified in the parameter.
         * @returns {void}
         */
        exportPivotChart(): void;

        /** This function renders the pivot chart control with the JSON formatted data source.
         * @returns {void}
         */
        renderChartFromJSON(): void;

        /** This function receives the update from the service-end, which will be utilized for rendering the widget.
         * @returns {void}
         */
        renderControlSuccess(): void;

        /** Returns the OlapReport string that is maintained along with the axis elements information.
         * @returns {string}
         */
        getOlapReport(): string;

        /** Sets the OlapReport string along with the axis information and maintains it in a property.
         * @returns {void}
         */
        setOlapReport(): void;

        /** Returns the JSON records that are formed to render the control.
         * @returns {any[]}
         */
        getJSONRecords(): any[];

        /** Sets the JSON records to render the control.
         * @returns {void}
         */
        setJSONRecords(): void;

        /** Returns the PivotEngine that is formed to render the control.
         * @returns {any[]}
         */
        getPivotEngine(): any[];

        /** Sets the PivotEngine that is required to render the control.
         * @returns {void}
         */
        setPivotEngine(): void;

        /** Re-renders the control with the datasource at instant.
         * @returns {void}
         */
        refreshControl(): void;

        /** This function destroys the pivot chart widget associated events that are bound using &quot;this._on&quot; and brings the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** Renders the control with the pivot engine that is obtained from the OLAP cube.
         * @returns {void}
         */
        generateJSON(): void;

        /** Navigates to the specified page number in the specified axis.
         * @returns {void}
         */
        refreshPagedPivotChart(): void;
    }
    export namespace PivotChart {

        export interface Model {

            /** Sets the mode for the pivot chart widget to bind either the OLAP or relational datasource.
             * @Default {ej.Pivot.AnalysisMode.Pivot}
             */
            analysisMode?: ej.Pivot.AnalysisMode|string;

            /** Specifies the CSS class to the pivot chart for achieving the custom theme.
             * @Default {â€œâ€}
             */
            cssClass?: string;

            /** Options for enabling the zooming feature of the pivot chart.
             * @Default {{}}
             */
            zooming?: Zooming;

            /** Options available to configure the properties of entire series. You can also override the options for specific series by using the series collection.
             * @Default {{}}
             */
            commonSeriesOptions?: CommonSeriesOptions;

            /** Initializes the datasource for the pivot chart widget, when it functions completely on the client-side.
             * @Default {{}}
             */
            dataSource?: DataSource;

            /** Object is utilized to pass additional information between the client-end and the service-end while operating the control in the server mode.
             * @Default {{}}
             */
            customObject?: any;

            /** Allows you to enable the 3D view of the pivot chart.
             * @Default {false}
             */
            enable3D?: boolean;

            /** Allows you to view the pivot chart from right to left.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Allows you to render the complete pivot chart on drill operation, when expanding and collapsing members are shown in multi-level labels.
             * @Default {false}
             */
            enableMultiLevelLabels?: boolean;

            /** Allows you to enable the responsiveness of pivot chart in the browser layout.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** You can customize the legend items and their labels.
             * @Default {{}}
             */
            legend?: any;

            /** Allows you to set the localized language for the widget.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the mode for the pivot chart widget to bind the data source either in the server-side or client-side.
             * @Default {ej.Pivot.OperationalMode.ClientMode}
             */
            operationalMode?: ej.Pivot.OperationalMode|string;

            /** To override x axis for particular series, create an axis object by providing unique name by using name property and add it to axes array.
             * @Default {[]}
             */
            axes?: any[];

            /** This is a horizontal axis that contains options to configure the axis and it is the primary x-axis for all series in the series array. To override x-axis for particular series,
             * create an axis object by providing a unique name by using the name property and add it to the axes array. Then, assign the name to the seriesâ€™s xAxisName property to link both
             * the axis and the series.
             * @Default {{}}
             */
            primaryXAxis?: any;

            /** This is a vertical axis that contains options to configure the axis. This is the primary y-axis for all the series in the series array. To override y-axis for particular series,
             * create an axis object by providing a unique name by using the name property and add it to the axes array. Then, assign the name to the seriesâ€™s yAxisName property to link both
             * the axis and the series.
             * @Default {{}}
             */
            primaryYAxis?: any;

            /** Allows you to rotate the angle of pivot chart in 3D view.
             * @Default {0}
             */
            rotation?: number;

            /** Allows you to enable/disable context menu options in the pivot chart.
             * @Default {false}
             */
            enableContextMenu?: boolean;

            /** Allows you to set the custom name for methods at service-end, when you are communicating on AJAX post.
             * @Default {{}}
             */
            serviceMethodSettings?: ServiceMethodSettings;

            /** Options to customize the size of the pivot chart control.
             * @Default {{}}
             */
            size?: any;

            /** Options for customizing the title of PivotChart.
             */
            title?: Title;

            /** Connects the service by using the specified URL for any server updates while operating the control in the server mode.
             * @Default {â€œâ€}
             */
            url?: string;

            /** Allows you to enable &quot;withCredentials&quot; property inside XMLHttpRequest object for CORS(Cross-Origin Resource Sharing) request.
             * @Default {false}
             */
            enableXHRCredentials?: boolean;

            /** Triggers when the pivot chart starts to render.
             */
            load?(e: LoadEventArgs): void;

            /** Triggers when it reaches the client-side after any AJAX request.
             */
            afterServiceInvoke?(e: AfterServiceInvokeEventArgs): void;

            /** Triggers before any AJAX request is passed from the pivot chart to service methods.
             */
            beforeServiceInvoke?(e: BeforeServiceInvokeEventArgs): void;

            /** Triggers before rendering multiple series with multiple axes.
             */
            beforeSeriesRender?(e: BeforeSeriesRenderEventArgs): void;

            /** Triggers when performing drill up/down operation in the pivot chart control.
             */
            drillSuccess?(e: DrillSuccessEventArgs): void;

            /** Triggers when the pivot chart widget completes all operations at client-side after the AJAX request.
             */
            renderComplete?(e: RenderCompleteEventArgs): void;

            /** Triggers when the error occurs on the AJAX request.
             */
            renderFailure?(e: RenderFailureEventArgs): void;

            /** Triggers when the pivot chart successfully reaches the client-side after the AJAX request.
             */
            renderSuccess?(e: RenderSuccessEventArgs): void;

            /** Triggers before performing export operation in the pivot chart.
             */
            beforeExport?(e: BeforeExportEventArgs): void;
        }

        export interface LoadEventArgs {

            /** returns the current action of PivotChart control.
             */
            action?: string;

            /** returns the custom object bound with PivotChart control.
             */
            customObject?: any;

            /** returns the HTML element of PivotChart control.
             */
            element?: any;
        }

        export interface AfterServiceInvokeEventArgs {

            /** returns the current action of PivotChart control.
             */
            action?: string;

            /** returns the custom object bound with PivotChart control.
             */
            customObject?: any;

            /** returns the HTML element of PivotChart control.
             */
            element?: any;
        }

        export interface BeforeServiceInvokeEventArgs {

            /** returns the current action of PivotChart control.
             */
            action?: string;

            /** returns the custom object bound with PivotChart control.
             */
            customObject?: any;

            /** returns the HTML element of PivotChart control.
             */
            element?: any;
        }

        export interface BeforeSeriesRenderEventArgs {

            /** series - Instance of the series which is about to get rendered
             */
            data?: any;
        }

        export interface DrillSuccessEventArgs {

            /** returns the current instance of PivotChart.
             */
            chartObj?: any;

            /** returns the drill action of PivotChart.
             */
            drillAction?: string;

            /** contains the name of the member drilled.
             */
            drilledMember?: string;

            /** returns the event object.
             */
            event?: any;
        }

        export interface RenderCompleteEventArgs {

            /** returns the current action of PivotChart control.
             */
            action?: string;

            /** returns the custom object bound with PivotChart control.
             */
            customObject?: any;

            /** returns the HTML element of PivotChart control.
             */
            element?: any;
        }

        export interface RenderFailureEventArgs {

            /** returns the current action of PivotChart control.
             */
            action?: string;

            /** returns the custom object bound with PivotChart control.
             */
            customObject?: any;

            /** returns the HTML element of PivotChart control.
             */
            element?: any;

            /** returns the error stack trace of the original exception.
             */
            message?: string;
        }

        export interface RenderSuccessEventArgs {

            /** returns the current instance of PivotChart.
             */
            args?: any;
        }

        export interface BeforeExportEventArgs {

            /** contains the url of the service responsible for exporting.
             */
            url?: string;

            /** contains the name of the exporting file.
             */
            fileName?: string;
        }

        export interface Zooming {

            /** Enables or disables the horizontal scrollbar.
             * @Default {false}
             */
            enableScrollbar?: boolean;
        }

        export interface CommonSeriesOptions {

            /** Allows you to set the specific chart type for the pivot chart widget.
             * @Default {ej.PivotChart.ChartTypes.Column}
             */
            type?: ej.PivotChart.ChartTypes|string;
        }

        export interface DataSourceColumnsFilterItems {

            /** Sets the type of filter whether to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceColumn {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Allows you to set the display caption for the item.
             */
            fieldCaption?: string;

            /** Allows you to indicate whether the added item is a named set or not.
             * @Default {false}
             */
            isNamedSets?: boolean;

            /** Allows you to set the sorting order of field members.
             * @Default {ej.PivotAnalysis.SortOrder.Ascending}
             */
            sortOrder?: ej.PivotAnalysis.SortOrder|string;

            /** Applies filter to field members.
             * @Default {null}
             */
            filterItems?: DataSourceColumnsFilterItems;
        }

        export interface DataSourceRowsFilterItems {

            /** Sets the type of filter whether to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceRow {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Allows you to set the display caption for the item.
             */
            fieldCaption?: string;

            /** Allows you to indicate whether the added item is a named set or not.
             * @Default {false}
             */
            isNamedSets?: boolean;

            /** Allows you to set the sorting order of field members.
             * @Default {ej.PivotAnalysis.SortOrder.Ascending}
             */
            sortOrder?: ej.PivotAnalysis.SortOrder|string;

            /** Applies filter to field members.
             * @Default {null}
             */
            filterItems?: DataSourceRowsFilterItems;
        }

        export interface DataSourceValuesMeasure {

            /** Allows you to bind the measure from the OLAP datasource by using its unique name as field name.
             */
            fieldName?: string;
        }

        export interface DataSourceValue {

            /** Allows you to bind the item by using its unique name as field name for the relational datasource.
             */
            fieldName?: string;

            /** Allows you to set the display caption for the item of the relational datasource.
             */
            fieldCaption?: string;

            /** Holds the list of unique names of measures to bind them from the OLAP cube.
             * @Default {[]}
             */
            measures?: DataSourceValuesMeasure[];

            /** Allows you to set the axis name to place the measures items.
             * @Default {rows}
             */
            axis?: string;

            /** Indicates whether the field is a calculated field with the relational datasource or not.
             * @Default {false}
             */
            isCalculatedField?: boolean;

            /** Allows you to set the formula to calculate the values for calculated members in the relational datasource.
             */
            formula?: string;
        }

        export interface DataSourceFiltersFilterItems {

            /** Sets the type of filter whether to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceFilter {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Applies filter to field members.
             * @Default {null}
             */
            filterItems?: DataSourceFiltersFilterItems;
        }

        export interface DataSource {

            /** Contains the respective cube name from the OLAP database as string type.
             * @Default {â€œâ€}
             */
            cube?: string;

            /** To set the datasource name to fetch the data from that.
             * @Default {â€œâ€}
             */
            sourceInfo?: string;

            /** Sets the provider name for the pivot chart to identify whether the provider is SSAS or Mondrian.
             * @Default {ssas}
             */
            providerName?: string;

            /** Provides the raw datasource for the pivot chart.
             * @Default {null}
             */
            data?: any;

            /** In connection with the OLAP database, this property contains the database name as string to fetch the data from the given connection string.
             * @Default {â€œâ€}
             */
            catalog?: string;

            /** Lists out the items to be displayed as series of the pivot chart.
             * @Default {[]}
             */
            columns?: DataSourceColumn[];

            /** Lists out the items to be displayed as segments of the pivot chart.
             * @Default {[]}
             */
            rows?: DataSourceRow[];

            /** Lists out the items support calculation in the pivot chart.
             * @Default {[]}
             */
            values?: DataSourceValue[];

            /** Lists out the items that supports filtering of values without displaying the members in UI of the pivot chart.
             * @Default {[]}
             */
            filters?: DataSourceFilter[];
        }

        export interface ServiceMethodSettings {

            /** Allows you to set the custom name for the service method that is responsible for drilling up/down in the pivot chart.
             * @Default {DrillChart}
             */
            drillDown?: string;

            /** Allows you to set the custom name for the service method which is responsible for exporting the pivot chart.
             * @Default {Export}
             */
            exportPivotChart?: string;

            /** Allows you to set the custom name for the service method which is responsible for initializing the pivot chart.
             * @Default {InitializeChart}
             */
            initialize?: string;

            /** Allows you to set the custom name for the service method which is responsible for navigating between pages in the paged pivot chart.
             * @Default {Paging}
             */
            paging?: string;
        }

        export interface Title {

            /** Text to be displayed in PivotChart title.
             */
            text?: string;
        }

        enum ChartTypes {

            ///To render a Line type PivotChart.
            Line,

            ///To render a Spline type PivotChart.
            Spline,

            ///To render a Column type PivotChart.
            Column,

            ///To render an Area type PivotChart.
            Area,

            ///To render a SplineArea type PivotChart.
            SplineArea,

            ///To render a StepLine type PivotChart.
            StepLine,

            ///To render a StepArea type PivotChart.
            StepArea,

            ///To render a Pie type PivotChart.
            Pie,

            ///To render a Bar type PivotChart.
            Bar,

            ///To render a StackingArea type PivotChart.
            StackingArea,

            ///To render a StackingColumn type PivotChart.
            StackingColumn,

            ///To render a StackingBar type PivotChart.
            StackingBar,

            ///To render a Pyramid type PivotChart.
            Pyramid,

            ///To render a Funnel type PivotChart.
            Funnel,

            ///To render a Doughnut type PivotChart.
            Doughnut,

            ///To render a Scatter type PivotChart.
            Scatter,

            ///To render a Bubble type PivotChart.
            Bubble
        }

    }

    class PivotClient extends ej.Widget {
        static fn: PivotClient;
        constructor(element: JQuery | Element, options?: PivotClient.Model);
        static Locale: any;
        model: PivotClient.Model;
        defaults: PivotClient.Model;

        /** Performs an asynchronous HTTP (AJAX) request.
         * @returns {void}
         */
        doAjaxPost(): void;

        /** Performs an asynchronous HTTP (full post) submit.
         * @returns {void}
         */
        doPostBack(): void;

        /** Navigates to a specified page in the specified axis.
         * @returns {void}
         */
        refreshPagedPivotClient(): void;

        /** Updates the pivot client component with the JSON data that is fetched from the service while navigating between the pages.
         * @returns {void}
         */
        refreshPagedPivotClientSuccess(): void;

        /** Renders the pivot chart and the pivot grid with the provided JSON data.
         * @returns {void}
         */
        generateJSON(): void;

        /** Re-renders the control with the report at that instant.
         * @returns {void}
         */
        refreshControl(): void;

        /** Returns the control tab string that displays currently in the pivot client.
         * @returns {void}
         */
        getActiveTab(): void;

        /** This function destroys all events of the pivot client widget bound using &quot;this._on&quot; and bring the control to pre-init state.
         * @returns {void}
         */
        destroy(): void;

        /** Returns the OLAP report string that is maintained along with the axis elements information.
         * @returns {string}
         */
        getOlapReport(): string;

        /** Sets the OLAP report string along with the axis information and maintains it in a property.
         * @returns {void}
         */
        setOlapReport(): void;

        /** Returns the formed JSON records to render the control.
         * @returns {any[]}
         */
        getJSONRecords(): any[];

        /** Sets the formed JSON records to render the control to a property.
         * @returns {void}
         */
        setJSONRecords(): void;
    }
    export namespace PivotClient {

        export interface Model {

            /** Sets the mode for the pivot client widget for binding the OLAP or relational data sources.
             * @Default {ej.Pivot.AnalysisMode.Pivot}
             */
            analysisMode?: ej.Pivot.AnalysisMode|string;

            /** Allows you to set the specific chart type for the pivot chart in the pivot client widget.
             * @Default {ej.PivotChart.ChartTypes.Column}
             */
            chartType?: ej.PivotChart.ChartTypes|string;

            /** Allows you to set the content for exporting the pivot client widget.
             * @Default {ej.PivotClient.ClientExportMode.ChartAndGrid}
             */
            clientExportMode?: ej.PivotClient.ClientExportMode|string;

            /** Specifies the CSS class to the pivot client for achieving the custom theme.
             * @Default {â€œâ€}
             */
            cssClass?: string;

            /** An object is utilized to pass the additional information between the client-end and the service-end when the control functions are present in the server-mode.
             * @Default {{}}
             */
            customObject?: any;

            /** Initializes the data source for the pivot client widget, when it functions completely on the client-side.
             * @Default {{}}
             */
            dataSource?: DataSource;

            /** Enables the drill-through feature which retrieves the raw items that are used to create a specific cell in the pivot grid.
             * @Default {false}
             */
            enableDrillThrough?: boolean;

            /** Allows you to customize the layout and appearance of the widget.
             * @Default {{}}
             */
            displaySettings?: DisplaySettings;

            /** Allows you to set the visibility of icons in the toolbar panel.
             * @Default {{}}
             */
            toolbarIconSettings?: ToolbarIconSettings;

            /** Allows you to show a unique name on the pivot button.
             * @Default {false}
             */
            showUniqueNameOnPivotButton?: boolean;

            /** Allows you to load the saved report collection from the database.
             * @Default {false}
             */
            showReportCollection?: boolean;

            /** Enables the splitter option for resizing the elements in the control.
             * @Default {false}
             */
            enableSplitter?: boolean;

            /** Enables the advanced filtering options such as value filtering, label filtering, and sorting for each dimensions when binding the OLAP data in the server mode.
             * @Default {false}
             */
            enableAdvancedFilter?: boolean;

            /** Allows you to refresh the control on-demand and not during the every UI operation.
             * @Default {false}
             */
            enableDeferUpdate?: boolean;

            /** Allows to save and load the reports in a customized way with the help of events.
             * @Default {false}
             */
            enableLocalStorage?: boolean;

            /** Allows you to enable the paging for both the pivot chart and the pivot grid components for viewing the large data.
             * @Default {false}
             */
            enablePaging?: boolean;

            /** Allows you to include the pivot tree map component as one of the chart types.
             * @Default {false}
             */
            enablePivotTreeMap?: boolean;

            /** Allows you to view the layout of the pivot client from right to left.
             * @Default {false}
             */
            enableRTL?: boolean;

            /** Enables/disables the visibility of measure group selector drop-down in the cube browser.
             * @Default {false}
             */
            enableMeasureGroups?: boolean;

            /** Allows you to get cell details in JSON format by clicking the value cell.
             * @Default {false}
             */
            enableCellClick?: boolean;

            /** Allows you to get cell details in JSON format by double-clicking the value cell.
             * @Default {false}
             */
            enableCellDoubleClick?: boolean;

            /** Allows you to enable the virtual scrolling for both the pivot chart and pivot grid components for viewing the large data.
             * @Default {false}
             */
            enableVirtualScrolling?: boolean;

            /** Allows you to set the maximum number of nodes as well as child nodes to be displayed in the member editor.
             * @Default {1000}
             */
            maxNodeLimitInMemberEditor?: number;

            /** Enables/disables paging in the member editor for viewing the large count of members in the pages.
             * @Default {false}
             */
            enableMemberEditorPaging?: boolean;

            /** Allows you to set the number of members to be displayed in each page of the member editor on applying the paging in it.
             * @Default {100}
             */
            memberEditorPageSize?: number;

            /** Enables/Disables sorting option in member editor dialog for the members of the respective field.
             * @Default {false}
             */
            enableMemberEditorSorting?: boolean;

            /** Sets the summary layout for the pivot grid. Following are the ways in which the summary can be positioned: normal summary (bottom), top summary, no summary, and Microsoft Excel
             * summary.
             * @Default {ej.PivotGrid.Layout.Normal}
             */
            gridLayout?: ej.PivotGrid.Layout|string;

            /** Allows you to hide the cube browser and the axis element builder of the pivot client while initiating the widget.
             * @Default {false}
             */
            collapseCubeBrowserByDefault?: boolean;

            /** Allows you to view the KPI elements in tree-view of the pivot client's cube browser.
             * @Default {false}
             */
            enableKPI?: boolean;

            /** Allows you to enable the pivot clientâ€™s responsiveness in the browser layout.
             * @Default {false}
             */
            isResponsive?: boolean;

            /** Options to customize the size of the pivot client control.
             * @Default {Example:}
             */
            size?: any;

            /** Allows you to set the localized language for the widget.
             * @Default {en-US}
             */
            locale?: string;

            /** Sets the mode for the pivot client widget to bind the data source in the server-side or the client-side.
             * @Default {ej.Pivot.OperationalMode.ClientMode}
             */
            operationalMode?: ej.Pivot.OperationalMode|string;

            /** Allows you to set the custom name for methods at service-end, and it is communicated during the AJAX post.
             * @Default {{}}
             */
            serviceMethodSettings?: ServiceMethodSettings;

            /** Holds the necessary properties for value sorting.
             * @Default {{}}
             */
            valueSortSettings?: ValueSortSettings;

            /** Sets the title for the pivot client widget.
             */
            title?: string;

            /** Connects the service using the specified URL for any server updates.
             */
            url?: string;

            /** Allows you to export entire data instead of current page data, while paging option is enabled.
             * @Default {false}
             */
            enableCompleteDataExport?: boolean;

            /** Allows you to enable &quot;withCredentials&quot; property inside XMLHttpRequest object for CORS(Cross-Origin Resource Sharing) request.
             * @Default {false}
             */
            enableXHRCredentials?: boolean;

            /** Triggers when it reaches the client-side after any AJAX request.
             */
            afterServiceInvoke?(e: AfterServiceInvokeEventArgs): void;

            /** Triggers before any AJAX request is passed from the client-side to the service methods.
             */
            beforeServiceInvoke?(e: BeforeServiceInvokeEventArgs): void;

            /** Triggers before saving the current collection of reports.
             */
            saveReport?(e: SaveReportEventArgs): void;

            /** Triggers before loading the saved collection of reports.
             */
            loadReport?(e: LoadReportEventArgs): void;

            /** Triggers before fetching the report collection from the storage.
             */
            fetchReport?(e: FetchReportEventArgs): void;

            /** Triggers before exporting the control.
             */
            beforeExport?(e: BeforeExportEventArgs): void;

            /** Triggers before rendering the pivot chart.
             */
            chartLoad?(e: ChartLoadEventArgs): void;

            /** Triggers before rendering the pivot schema designer.
             */
            schemaLoad?(e: SchemaLoadEventArgs): void;

            /** Triggers before rendering the pivot tree map.
             */
            treeMapLoad?(e: TreeMapLoadEventArgs): void;

            /** Triggers when clicking any value cell in the pivot grid.
             */
            valueCellHyperlinkClick?(e: ValueCellHyperlinkClickEventArgs): void;

            /** Triggers when click action is performed over a grid value cell.
             */
            cellClick?(e: CellClickEventArgs): void;

            /** Triggers when clicking on any chart series points in the pivot chart.
             */
            pointRegionClick?(e: PointRegionClickEventArgs): void;

            /** Triggers before the chart label is rendered in the pivot chart.
             */
            axesLabelRendering?(e: AxesLabelRenderingEventArgs): void;

            /** Triggers while clicking the value cells in the pivot grid.
             */
            drillThrough?(e: DrillThroughEventArgs): void;

            /** Triggers while initiating the loading of the widget.
             */
            load?(e: LoadEventArgs): void;

            /** Triggers when the pivot client widget completes all operations at client-end after any AJAX request.
             */
            renderComplete?(e: RenderCompleteEventArgs): void;

            /** Triggers when any error is occurred during the AJAX request.
             */
            renderFailure?(e: RenderFailureEventArgs): void;

            /** Triggers when the pivot client is completely rendered.
             */
            renderSuccess?(e: RenderSuccessEventArgs): void;
        }

        export interface AfterServiceInvokeEventArgs {

            /** returns the current action of PivotClient control.
             */
            action?: string;

            /** returns the custom object bounds with PivotClient control.
             */
            customObject?: any;

            /** returns the HTML element of PivotClient control.
             */
            element?: any;
        }

        export interface BeforeServiceInvokeEventArgs {

            /** returns the current action of PivotClient control.
             */
            action?: string;

            /** returns the custom object bounds with PivotClient control.
             */
            customObject?: any;

            /** returns the HTML element of PivotClient control.
             */
            element?: any;
        }

        export interface SaveReportEventArgs {

            /** returns the current instance of PivotClient control.
             */
            targetControl?: any;

            /** returns the object which holds the necessary parameters required for saving the report collection.
             */
            saveReportSetting?: any;
        }

        export interface LoadReportEventArgs {

            /** returns the current instance of PivotClient control.
             */
            targetControl?: any;

            /** returns the object which holds the necessary parameters required for loading a report collection from database.
             */
            loadReportSetting?: any;
        }

        export interface FetchReportEventArgs {

            /** returns the current instance of PivotClient control.
             */
            targetControl?: any;

            /** returns the object which holds the necessary parameters required for fetching the report names stored in database.
             */
            fetchReportSetting?: any;
        }

        export interface BeforeExportEventArgs {

            /** holds the url of the service method responsible for exporting the PivotClient control.
             */
            url?: string;

            /** holds the name of the file to be exported.
             */
            fileName?: string;
        }

        export interface ChartLoadEventArgs {

            /** returns the current action of PivotChart control.
             */
            action?: string;

            /** returns the custom object bound with PivotChart control.
             */
            customObject?: any;

            /** returns the HTML element of PivotChart control.
             */
            element?: any;
        }

        export interface SchemaLoadEventArgs {

            /** returns the current action of PivotSchemaDesigner control.
             */
            action?: string;
        }

        export interface TreeMapLoadEventArgs {

            /** returns the current action of PivotTreeMap control.
             */
            action?: string;

            /** returns the custom object bound with PivotTreeMap control.
             */
            customObject?: any;

            /** returns the HTML element of PivotTreeMap control.
             */
            element?: any;
        }

        export interface ValueCellHyperlinkClickEventArgs {

            /** returns the current action of PivotClient control.
             */
            type?: string;

            /** returns the clicked cell information.
             */
            args?: any;

            /** returns the custom object bounds with PivotClient control.
             */
            customerObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;

            /** returns the model object bound with PivotClient control.
             */
            model?: any;
        }

        export interface CellClickEventArgs {

            /** returns the JSON details of the respective on cell.
             */
            selectedData?: any[];

            /** returns the custom object bound with PivotClient control.
             */
            customObject?: any;

            /** returns the HTML element of PivotGrid control.
             */
            element?: any;
        }

        export interface PointRegionClickEventArgs {

            /** returns the current action of PivotClient control.
             */
            type?: string;

            /** returns the clicked Chart series points information.
             */
            data?: any;

            /** returns the model object bound with PivotClient control.
             */
            model?: any;
        }

        export interface AxesLabelRenderingEventArgs {

            /** returns the current action of PivotClient control.
             */
            type?: string;

            /** returns the Chart label information.
             */
            data?: any;

            /** returns the model object bound with PivotClient control.
             */
            model?: any;
        }

        export interface DrillThroughEventArgs {

            /** return the JSON records of the generated cells on drill-through operation.
             */
            data?: any;

            /** returns the HTML element of PivotClient.
             */
            element?: any;
        }

        export interface LoadEventArgs {

            /** returns the HTML element of PivotClient component.
             */
            element?: any;

            /** returns the custom object bound with PivotTreeMap control.
             */
            customObject?: any;
        }

        export interface RenderCompleteEventArgs {

            /** returns the HTML element of PivotClient component.
             */
            element?: any;

            /** returns the custom object bound with PivotTreeMap control.
             */
            customObject?: any;
        }

        export interface RenderFailureEventArgs {

            /** returns the custom object bound with the control.
             */
            customObject?: any;

            /** returns the HTML element of PivotClient control.
             */
            element?: any;

            /** returns the error message with error code.
             */
            message?: string;
        }

        export interface RenderSuccessEventArgs {

            /** returns the object of PivotClient control at that instant.
             */
            args?: any;
        }

        export interface DataSourceColumnsAdvancedFilter {

            /** Allows you to provide a level unique name to perform the advanced filtering.
             */
            name?: string;

            /** Allows you to set the operator to perform label filtering.
             * @Default {none}
             */
            labelFilterOperator?: string;

            /** Allows you to set the operator to perform value filtering.
             * @Default {none}
             */
            valueFilterOperator?: string;

            /** Allows you to set the filtering type while performing the advanced filtering.
             */
            advancedFilterType?: string;

            /** In value filtering, this property contains the measure name to which the filter is applied.
             */
            measure?: string;

            /** Allows you to hold the filter operand values in the advanced filtering.
             */
            values?: any[];
        }

        export interface DataSourceColumnsFilterItems {

            /** Sets the type of filter whether to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceColumn {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Allows you to set the display caption for an item.
             */
            fieldCaption?: string;

            /** Allows you to filter the report by default using the advanced filtering (e.g., Microsoft Excel) option for the OLAP data source in the client-mode.
             * @Default {[]}
             */
            advancedFilter?: DataSourceColumnsAdvancedFilter[];

            /** Allows you to indicate whether the added item is a named set or not.
             * @Default {false}
             */
            isNamedSets?: boolean;

            /** Shows/hides the sub-total of the field in the pivot grid.
             * @Default {true}
             */
            showSubTotal?: boolean;

            /** Allows to set the format for the column headers.
             */
            format?: string;

            /** This property is set to display the formatted values with format types in the pivot grid.
             */
            formatString?: string;

            /** Allows you to set the custom theme for the column headers.
             */
            cssClass?: string;

            /** Allows you to set the sorting order of members of the field.
             * @Default {ej.PivotAnalysis.SortOrder.Ascending}
             */
            sortOrder?: ej.PivotAnalysis.SortOrder|string;

            /** Contains the list of members need to be drilled down by default in the field.
             * @Default {[]}
             */
            drilledItems?: any[];

            /** Applies the filter to field members.
             * @Default {null}
             */
            filterItems?: DataSourceColumnsFilterItems;
        }

        export interface DataSourceRowsAdvancedFilter {

            /** Allows you to provide a level unique name to perform the advanced filtering.
             */
            name?: string;

            /** Allows you to set the operator to perform the label filtering.
             * @Default {none}
             */
            labelFilterOperator?: string;

            /** Allows you to set the operator to perform the value filtering.
             * @Default {none}
             */
            valueFilterOperator?: string;

            /** Allows you to set the filtering type while performing the advanced filtering.
             */
            advancedFilterType?: string;

            /** In value filtering, this property contains the measure name to which the filter is applied.
             */
            measure?: string;

            /** Allows you to hold the filter operand values in the advanced filtering.
             */
            values?: any[];
        }

        export interface DataSourceRowsFilterItems {

            /** Sets the type of filter whether to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceRow {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Allows you to set the display caption for an item.
             */
            fieldCaption?: string;

            /** Allows you to filter the report by using the advanced filtering (e.g., Microsoft Excel) option for the OLAP data source in the client-mode.
             * @Default {[]}
             */
            advancedFilter?: DataSourceRowsAdvancedFilter[];

            /** Allows you to indicate whether the added item is a named set or not.
             * @Default {false}
             */
            isNamedSets?: boolean;

            /** Shows/hides the sub-total of the field.
             * @Default {true}
             */
            showSubTotal?: boolean;

            /** Allows to set the format for row headers.
             */
            format?: string;

            /** This property is set to display the formatted values with format types in the pivot grid.
             */
            formatString?: string;

            /** Allows to set the custom theme for row headers.
             */
            cssClass?: string;

            /** Allows you to set the sorting order for the field members.
             * @Default {ej.PivotAnalysis.SortOrder.Ascending}
             */
            sortOrder?: ej.PivotAnalysis.SortOrder|string;

            /** Contains the list of members need to be drilled down by default in the field.
             * @Default {[]}
             */
            drilledItems?: any[];

            /** Applies the filter to the field members.
             * @Default {null}
             */
            filterItems?: DataSourceRowsFilterItems;
        }

        export interface DataSourceValuesMeasure {

            /** Allows you to bind the measure from the OLAP data source by using its unique name as field name.
             */
            fieldName?: string;
        }

        export interface DataSourceValue {

            /** Allows you to bind the item by using its unique name as field name for the relational data source.
             */
            fieldName?: string;

            /** Allows you to set the display caption for an item for the relational data source.
             */
            fieldCaption?: string;

            /** This holds the list of unique names of measures to bind them from the OLAP cube.
             * @Default {[]}
             */
            measures?: DataSourceValuesMeasure[];

            /** Allows to set the axis name to place the measures items.
             * @Default {rows}
             */
            axis?: string;

            /** Indicates whether the field is a calculated field or not with the relational data source.
             * @Default {false}
             */
            isCalculatedField?: boolean;

            /** Allows to set the type of the pivot grid summary calculation for the value field with the relational data source.
             * @Default {ej.PivotAnalysis.SummaryType.Sum}
             */
            summaryType?: ej.PivotAnalysis.SummaryType|string;

            /** Allows to set the format of the values.
             */
            format?: string;

            /** This property is set to display the formatted values with format types in the pivot grid.
             */
            formatString?: string;

            /** Allows to set the custom theme for the values.
             */
            cssClass?: string;

            /** Allows to set the formula for calculation of members values in the relational data source.
             */
            formula?: string;
        }

        export interface DataSourceFiltersFilterItems {

            /** Sets the type of filter whether to include/exclude the mentioned values.
             * @Default {ej.PivotAnalysis.FilterType.Exclude}
             */
            filterType?: ej.PivotAnalysis.FilterType|string;

            /** Contains the collection of items to be included/excluded among the field members.
             * @Default {[]}
             */
            values?: any[];
        }

        export interface DataSourceFilter {

            /** Allows you to bind the item by using its unique name as field name.
             */
            fieldName?: string;

            /** Allows you to set the display name for an item.
             */
            fieldCaption?: string;

            /** Applies filter to the field members.
             * @Default {null}
             */
            filterItems?: DataSourceFiltersFilterItems;
        }

        export interface DataSourcePagerOptions {

            /** Allows to set the number of categorical columns to be displayed in each page on applying the paging.
             * @Default {0}
             */
            categoricalPageSize?: number;

            /** Allows to set the number of series rows to be displayed in each page on applying the paging.
             * @Default {0}
             */
            seriesPageSize?: number;

            /** Allows to set the page number in the categorical axis to be loaded by default.
             * @Default {1}
             */
            categoricalCurrentPage?: number;

            /** Allows to set the page number in the series axis to be loaded by default.
             * @Default {1}
             */
            seriesCurrentPage?: number;
        }

        export interface DataSource {

            /** Lists out the items to be arranged in the columns section of the pivot client.
             * @Default {[]}
             */
            columns?: DataSourceColumn[];

            /** Lists out the items to be arranged in the rows section of the pivot client.
             * @Default {[]}
             */
            rows?: DataSourceRow[];

            /** Lists out the items which supports calculation in the pivot client.
             * @Default {[]}
             */
            values?: DataSourceValue[];

            /** Lists out the items which supports filtering of values without displaying the members in UI of the pivot client.
             * @Default {[]}
             */
            filters?: DataSourceFilter[];

            /** Contains the respective cube name from the OLAP database as string type.
             * @Default {â€œâ€}
             */
            cube?: string;

            /** Allows to set the data source name to fetch the data from that.
             * @Default {â€œâ€}
             */
            sourceInfo?: string;

            /** Sets the provider name for the pivot client to identify whether the provider is SSAS or Mondrian.
             * @Default {ssas}
             */
            providerName?: string;

            /** Provides the raw data source for the pivot client.
             * @Default {null}
             */
            data?: any;

            /** In connection with an OLAP database, this property contains the database name as string to fetch the data from the given connection string.
             * @Default {â€œâ€}
             */
            catalog?: string;

            /** Allows you to filter the members (by its name and values) through the advanced filtering (e.g., Microsoft Excel) option in the client-mode.
             * @Default {false}
             */
            enableAdvancedFilter?: boolean;

            /** Sets a name to the report bound to the control.
             */
            reportName?: string;

            /** Allows to set the page size and current page number for each axis on applying the paging.
             * @Default {{}}
             */
            pagerOptions?: DataSourcePagerOptions;
        }

        export interface DisplaySettings {

            /** Allows you to customize the display of the pivot chart and pivot grid widgets in the tabs or tiles.
             * @Default {ej.PivotClient.ControlPlacement.Tab}
             */
            controlPlacement?: ej.PivotClient.ControlPlacement|string;

            /** Allows you to set either the chart or grid as the start-up widget.
             * @Default {ej.PivotClient.DefaultView.Grid}
             */
            defaultView?: ej.PivotClient.DefaultView|string;

            /** Allows you to switch to full screen view of the pivot chart and the pivot grid from default view in the pivot client.
             * @Default {false}
             */
            enableFullScreen?: boolean;

            /** Enables an option to enhance the space for the pivot grid and pivot chart by hiding the cube browser and the axis element builder.
             * @Default {false}
             */
            enableTogglePanel?: boolean;

            /** Sets the display mode (only chart/only grid/both) in the pivot client.
             * @Default {ej.PivotClient.DisplayMode.ChartAndGrid}
             */
            mode?: ej.PivotClient.DisplayMode|string;
        }

        export interface ToolbarIconSettings {

            /** Allows you to set the visibility of Add Report icon in the toolbar panel.
             * @Default {true}
             */
            enableAddReport?: boolean;

            /** Allows you to set the visibility of New Report icon in the toolbar panel.
             * @Default {true}
             */
            enableNewReport?: boolean;

            /** Allows you to set the visibility of Rename Report icon in the toolbar panel.
             * @Default {true}
             */
            enableRenameReport?: boolean;

            /** Allows you to set the visibility of DB Manipulation icon in the toolbar panel.
             * @Default {true}
             */
            enableDBManipulation?: boolean;

            /** Allows you to set the visibility of Word Export icon in the toolbar panel.
             * @Default {true}
             */
            enableWordExport?: boolean;

            /** Allows you to set the visibility of Excel Export icon in the toolbar panel.
             * @Default {true}
             */
            enableExcelExport?: boolean;

            /** Allows you to set the visibility of PDF Export icon in the toolbar panel.
             * @Default {true}
             */
            enablePdfExport?: boolean;

            /** Allows you to set the visibility of MDX Query icon in the toolbar panel.
             * @Default {true}
             */
            enableMDXQuery?: boolean;

            /** Allows to set the visibility of Defer Update icon in the toolbar panel.
             * @Default {false}
             */
            enableDeferUpdate?: boolean;

            /** Allows to set the visibility of Full Screen icon in the toolbar panel.
             * @Default {false}
             */
            enableFullScreen?: boolean;

            /** Allows you to set the visibility of Sort/Filter Column icon in the toolbar panel.
             * @Default {true}
             */
            enableSortOrFilterColumn?: boolean;

            /** Allows you to set the visibility of Sort/Filter Row icon in the toolbar panel.
             * @Default {true}
             */
            enableSortOrFilterRow?: boolean;

            /** Allows you to set the visibility of Toggle Axis icon in the toolbar panel.
             * @Default {true}
             */
            enableToggleAxis?: boolean;

            /** Allows you to set the visibility of Chart Types icon in the toolbar panel.
             * @Default {true}
             */
            enableChartTypes?: boolean;

            /** Allows you to set the visibility of Remove Report icon in the toolbar panel.
             * @Default {true}
             */
            enableRemoveReport?: boolean;

            /** Allows you to set the visibility of Calculated Member icon in the toolbar panel.
             * @Default {false}
             */
            enableCalculatedMember?: boolean;
        }

        export interface ServiceMethodSettings {

            /** Allows you to set the custom name for the service method that is responsible for updating the entire report and widget, while changing the cube.
             * @Default {CubeChanged}
             */
            cubeChanged?: string;

            /** Allows to set the custom name for the service method responsible for exporting.
             * @Default {Export}
             */
            exportPivotClient?: string;

            /** Allows you to set the custom name for the service method that is responsible to get the members for tree-view in the member-editor dialog.
             * @Default {FetchMemberTreeNodes}
             */
            fetchMemberTreeNodes?: string;

            /** Allows you to set the custom name for the service method that is responsible for fetching the report names from the database.
             * @Default {FetchReportListFromDB}
             */
            fetchReportList?: string;

            /** Allows you to set the custom name for the service method that is responsible for updating the report while filtering the members.
             * @Default {FilterElement}
             */
            filterElement?: string;

            /** Allows you to set the custom name for the service method that is responsible for initializing the pivot client.
             * @Default {InitializeClient}
             */
            initialize?: string;

            /** Allows you to set the custom name for the service method that is responsible for loading a report collection from the database.
             * @Default {LoadReportFromDB}
             */
            loadReport?: string;

            /** Allows you to set the custom name for the service method that is responsible to remove a report collection from the database.
             * @Default {RemoveReportFromDB}
             */
            removeDBReport?: string;

            /** Allows you to set the custom name for the service method that is responsible for renaming the report collection in the database.
             * @Default {RenameReportInDB}
             */
            renameDBReport?: string;

            /** Allows you to set the custom name for the service method that is responsible for retrieving the MDX query for the current report.
             * @Default {GetMDXQuery}
             */
            mdxQuery?: string;

            /** Allows you to set the custom name for the service method that is responsible for updating the tree-view in the cube browser, while changing the measure group.
             * @Default {MeasureGroupChanged}
             */
            measureGroupChanged?: string;

            /** Allows you to set the custom name for the service method that is responsible to get the child members, on tree-view node expansion.
             * @Default {MemberExpanded}
             */
            memberExpand?: string;

            /** Allows you to set the custom name for the service method that is responsible for updating the report while dropping a node/split button in the axis element builder.
             * @Default {NodeDropped}
             */
            nodeDropped?: string;

            /** Allows you to set the custom name for the service method that is responsible to update the report while removing the split button from the axis element builder.
             * @Default {RemoveSplitButton}
             */
            removeSplitButton?: string;

            /** Allows you to set the custom name for the