﻿:Namespace API
⍝ === VARIABLES ===

LogicTable←24 4⍴(,'M') (,'⊢') 'set' (,'B') (,'M') (,'~') 'complement' 'not B' (,'M') (,'0') 'none' 'none' (,'M') (,'1') 'all' 'all' (,'D') (,'∧') 'and' 'A and B' (,'D') (,'∨') 'or' 'A or B' (,'D') (,'|') 'conditional' 'A given B' (,'D') (,'⊢') 'right' 'marginal B' (,'D') (,'⊣') 'left' 'marginal A' (,'D') (,'≠') 'exclusive or' 'A xor B' (,'D') (,'=') 'iff' 'A if and only if B' (,'D') (,'⍲') 'nand' 'not(A and B)' (,'D') (,'⍱') 'nor' 'not(A or B)' (,'D') (,'<') 'relative complement' 'B and not A' (,'D') (,'>') 'without' 'A and not B' (,'D') (,'≤') 'implies' 'B or not A' (,'D') (,'≥') 'if' 'A or not B' (,'D') '~⊣' 'not left' 'not A' (,'D') '~⊢' 'not right' 'not B' (,'D') (,'∩') 'intersection' 'A and B' (,'D') (,'∪') 'union' 'A or B' (,'D') (,'~') 'without' 'A without B' (,'D') (,'0') 'none' 'none' (,'D') (,'1') 'all' 'all'


⍝ === End of variables definition ===

(⎕IO ⎕ML ⎕WX)←1 1 3

∇ Z←BayesAPI NS;⎕IO;⎕ML;D;x;y;q
               ⍝∇ ns-based API for Bayes
               ⍝∊ Written by Steve Mansour
               ⍝⍵ nsIn Namespace containing the following variables
               ⍝   EventList:     Character Vector of Vectors
               ⍝   Prior:         Numeric Vector or probabilities {0≤⍵≤1}  {1=+/⍵}
               ⍝   Conditional:   {0≤⍵≤1}
               ⍝← nsOut Namespace contain nsIn plus the following:
               ⍝   Joint:         ⍵>0  (If proportion 0<⍵<1)
               ⍝   Marginal:      Numeric Scalar     {0≤⍵≤1}
               ⍝   Posterior:     Numeric Vector     {0≤⍵≤1}  {1=+/⍵}
 ⎕IO←0 ⋄ ⎕ML←3
 NS.ReturnCode←0 ⋄ NS.ErrorMessage←''
 :If NS.Event≡'Run'
     D←NS.Events bayes,y←NS.(Prior Conditional)
     NS.Joint←D[;3]
     NS.Marginal←+/NS.Joint
     NS.Posterior←D[;4]
     x←{⍺,',',⍵}/NS.Events
     q←''''
     x←(q ⎕R(2/q))↑x
     x←q,x,q,' bayes show '
     x,←↓{'(',⍵,')'}⊃y
     NS.Expr←⍕x
 :Else
     NS.ReturnCode←1 ⋄ NS.ErrorMessage←'Illegal Event'
 :EndIf
 Z←NS
∇

 DistAPI←{
          ⍝∇ Run distribution function
          ⍝∊   Written by Steve Mansour
          ⍝⍵:  Namespace containing the following:
          ⍝     DistFn, Operator, Field3, Value, Parameters
          ⍝←    Expression, Result, ReturnCode, Message, ChartSpecs
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ns←⍵
     ns.Field3←{6::'0' ⋄ ⍵.Field3}ns
     fc←{op←⍵.Operator ⋄ f←⍎⍵.DistFn ⋄ p←⍺
         op≡'randomVariable':{ns←histogram ⍵.Result
             ns.Curve←⍵.Value 1×⍤1⊢ns.YX ⋄ ns}⍵
         g←⍎⍵.Field3
         (⊂op)∊'prob' 'probability':p f coords g ⍵.Value
         op≡'criticalValue':p f{b←2 ⍵⍵ 1 3            ⍝ Test relation
             ∧/0 1∊b:⍺ ⍺⍺ coords(~⍵⍵)⍵                ⍝ If <, ≤, ≥, >, flip the logic
             ∧/b:⍺ ⍺⍺ coords outside ⍵                ⍝ If ≠ shade tails
             ⍺ ⍺⍺ coords between ⍵}g ⍵.Result         ⍝ Else shade middle
         (⊂⍵.Field3)∊'mean' 'median' 'mode':{c←⍵.DistType≡'Continuous'
             c:p f coords≤⍵.Result
             p f coords=⍵.Result}⍵
         ⍵.Field3≡'skewness':{L←p f theoretical mean 0
             L,←p f theoretical median 0
             p f coords between sort L}⍵
         ⍵.Field3≡'kurtosis':p f coords outside p f critVal outside 0.95
         ⍵.Field3≡'iqr':p f coords include{p f theoretical quartile ⍵}¨1 3
         ~(⊂⍵.Field3)∊'sdev' 'variance':''            ⍝ Anything else, get out
         m←p f theoretical mean 0
                 ⍝  p f coords between+\m ⍵.Result}
         p f coords between+\m,⍵.Result*0.5*⍵.Field3≡'variance'}
     b←⍵.DistFn≡'multinomial'
     pf←⍕b{⍺∧0=↑0⍴↑⍵:,'(',(⍉⍵[;0 1]),')'              ⍝ Multinomial and numeric
         ⍺:(1⌽'''''',1↓∊',',¨⍵[;0])('(',⍵[;1],')')    ⍝ Multinomial and character
         ⍵[;1]}⍵.Parameters                           ⍝ Other
     str←pf,⍵.(DistFn Operator Field3 Value)          ⍝ Collect Inputs
     p←{0=≢pf:0 1 ⋄ ⍎⍵}pf
     ⍵.Expression←deleteExcessBlanks,⍕str             ⍝ Build Distribution Expression
     ⍵.Result←{0::0 ⋄ ⍎⍵.Expression}⍵
     ⍵.Message←''
     ⍵.DistType←⍎'0 ',⍵.DistFn,'''Type'''
     ⍵.ChartSpecs←p fc ⍵
     ⍵.ReturnCode←0
     ⍵
 }

 StatTableAPI←{
           ⍝∊ Written by Steve Mansour 2018
          ⍝∇ Create Namespace to generate stat table as per GitHub Issue #37
          ⍝⍺⍺ Distribution function expression
          ⍝⍺ Left argument (defaults to right argument): rows of table
          ⍝⍵ Namespace with the following variables:
          ⍝⍵ Dist       - Distribution Name
          ⍝⍵ Operator   - Operator name
          ⍝⍵ Relation   -  e.g. >, ≥, <
          ⍝⍵ Rows
          ⍝⍵ Cols
          ⍝← Expression
          ⍝← RowTitles
          ⍝← ColTitles
          ⍝← Table
          ⍝← ChartSpecs
     ⎕IO←0 ⋄ ⎕ML←3                              ⍝ Set System Variables
     DistFn Operator Field3 row col←⍵.(Dist Operator Relation Rows Columns)           ⍝ Unpack right argument
     fb←{(dist op rel row col)←⍵.(Dist Operator Relation Rows Columns)                ⍝ Binomial setup
         ex←'{⍺ ⍵ binomial prob ',rel,'⍳ ⍺+1}'  ⍝   Generate expression
         ex←'⍉⊃,⌿(',row,')∘.',ex,col            ⍝   Create simple matrix
         r←{⍵,[0.5]⍳⍵+1}¨⍎row                   ⍝   Generate row titles
         r←↓'P<n=>I4,<, >,P<x=>LI4'⎕FMT↑⍪/r     ⍝   n and x
         c←⍕¨⍎col                               ⍝   Col Titles p
         ex r c}                                ⍝   Data, rows, cols
     fx←{(dist op rel row col)←⍵.(Dist Operator Relation Rows Columns)                ⍝ General Distribution setup
         b←1=≢⍎⍕col                             ⍝   Are columns prob?
         row←'(',row,')'                        ⍝   Group row expression
         fn←dist op rel                         ⍝   Create function expression
         fn←fn,(dist≡'normal')/'+'              ⍝   If normal, add + to expression
         s2←(⊂,rel)∊,¨'between' 'outside','=≠'  ⍝   Two-sided
         fn←fn,⍨(s2∧op≡'criticalValue')/'⌈/'    ⍝     and critical Value?
         fn←b{dist≢'fDist':'(',⍵,')'            ⍝   If not F-dist group function expression
             ⍺:⍕'{⍵ ⍺ '⍵ col'}'                 ⍝   Else if prob, use d.f. for both num and den
             ⍕'{⍵ ⍺ '⍵ 0.05 '}'}fn              ⍝   Else use p=0.05 and unique d.f. for num/den
         r c←⍕¨¨⍎¨(⍵.(Rows Columns))[0,1-b]     ⍝   Get row, column names
                 ⍝  b:r c,⍨⊂⍕'∘.'fn'⍨'row                 ⍝   Build expression for fDist
         b:r c,⍨⊂⍕fn'table'row                ⍝
                 ⍝  ex←⍕row'∘.'fn col                      ⍝   Build general expression
         ex←⍕row fn'table'col                ⍝   Build general expression
         ex r c}                                ⍝   Data, rows, cols
     (Expression RowTitles ColTitles)←fb{       ⍝ Determine whether to use binomial
         'binomial'≡⍵.Dist:⍺⍺ ⍵ ⋄ ⍵⍵ ⍵}fx ⍵     ⍝   or general setup
     i←'normal' 'tDist' 'chiSquare' 'fDist' 'poisson' 'binomial'⍳⊂DistFn
     Parameters←0,⍪i⊃,¨(0 1)5 5(5 9)5(5 0.2)    ⍝ Parameter lists for graphic display
     Value←i⊃1 0.1 0.1 0.1 2 2                  ⍝ Values for graphic display
     g←⎕NS''                                    ⍝ Create namespace for graphics
     _←'g'⎕NS'DistFn' 'Operator' 'Field3' 'Value' 'Parameters' ⍝ Population with inputs
     Table←⍎Expression                          ⍝ Calculate values for table
     ChartSpecs←{⍵.ChartSpecs}DistAPI g         ⍝ Create chart specifications
     NS←⎕NS''                                   ⍝ Output namespace
     _←'NS'⎕NS'Expression' 'RowTitles' 'ColTitles' 'Table' 'ChartSpecs'  ⍝ Populate output ns
     NS}

∇ Z←anovaAPI NS;A;B;C;D;FF;G;H;R;N;V;f;Prev;FLD;⎕IO;⎕ML
               ⍝∇ ns-based API for Anova - Last updated 6/25
               ⍝⍵ nsIn Namespace containing the following variables
               ⍝⍵   Event 'Init'
               ⍝⍵   Event 'Select'  : Select parameter, Sample or Sample2
               ⍝← nsOut  Namespace containing  DataStat Report
               ⍝← Output Results Expr
               ⍝   Parameter:   mean, proportion, sdev, var
               ⍝   Data:  1 or 2-item nested vector:    Expression or stats
               ⍝   Values:  1×3 or 2×3 numeric matrix
               ⍝   UserSpace:   Ref or
               ⍝⍵    Parameter Levels Var GroupBy Var2
               ⍝← nsOut Namespace contain nsIn plus the following:
               ⍝←    Labels  2-item nested vector
               ⍝←    Values  1x3 or 2x3 numeric matrix
               ⍝←     Protect 2×3 boolean matrix 1=protect, 0=editable
 ⎕IO←0 ⋄ ⎕ML←3
 :Select NS.Event
 :Case 'Init'
     NS←anovaGrid NS
     A←⎕NS''                    ⍝ Build grid
     A.Type←'D' ⋄ A.Items←'F' ⋄ A.TopItem←'stats'
     NS.Grid.Attributes←'Var'NS.changeAttributes A
     A←⎕NS''
     A.Type←'Q' ⋄ A.Decimals←3
     NS.Grid.Attributes←'Sig'NS.changeAttributes A
     A←⎕NS''
     A.Type←'D' ⋄ A.Items←'oneWay' 'blocked' 'factor' 'latinSquare' 'factorial2k' 'nested'
     NS.Grid.Attributes←'Design'NS.changeAttributes A
     NS.Table←⊃{(,⍵)5,2⍴0}¨'ABC'
     NS.CellTypes←3 4⍴'ANXF'
     NS.UserSpace←#
     NS.ColTitles2←'Group' 'N' 'Mean' 'Std Dev'
     NS.ReturnCode←0
 :Case 'Select'
     FF←'Factor1' 'Factor2'
     R C←NS.get FF
     :Select NS.EventArg
     :Case 'Design'
         :Select NS.get'Design'
         :Case 'oneWay' ⋄ oneWayAPI NS
         :Case 'blocked' ⋄ blockedAPI NS
         :CaseList 'factor' 'nested' ⋄ factorAPI NS
         :Case 'latinSquare' ⋄ latinSquareAPI NS
         :Case 'factorial2k' ⋄ factorial2kAPI NS
         :EndSelect
     :Case 'Var'
         :If 'stats'≡NS.get'Var'
             NS.Grid.Attributes←FF NS.changeAttributes'N'
             NS.Grid.Values←FF NS.put 3 ''
             NS.Grid.Values←('Lb'∘,¨FF)NS.put'Treatments' 'Blocks(Optional)'
         :Else
             A←⎕NS''
             A.Type←'D' ⋄ A.Items←'A'
             NS.Grid.Attributes←FF NS.changeAttributes A
             NS.Grid.Values←FF NS.put⊂''
             NS.Grid.Values←('Lb'∘,¨FF)NS.put FF,¨'' '(Optional)'
         :EndIf
     :Case 'Factor1'
         :If 0=↑0⍴R
                      ⍝:If C∧.=' ' ⋄ :OrIf (⊂C)∊0 1     ⍝ One way Anova
             :Select D←NS.get'Design'
             :Case 'oneWay'
                 NS.Table←R resizeTable NS.Table
                 NS.CellTypes←R 4⍴'ANXF'
             :Case 'latinSquare'
                 NS.Table←R D resizeTable NS.Table
                 NS.CellTypes←(⍴NS.Table)⍴'AX'
             :Case 'factorial2k'
                 NS.Table←R C D resizeTable NS.Table
                 NS.CellTypes←(⍴NS.Table)⍴1 C/'AX'
             :Else                           ⍝ Two Way Anova
                           ⍝H←⍕¨1+⍳R
                 H←'A',¨⍕¨1+⍳R
                 NS.Table←NS.Table[0;]⍪H,R↑1 1↓NS.Table
                 NS.CellTypes←'A','A'⍪R C⍴'X'
             :EndSelect
         :Else
             V←NS.get'Var'
             G←(NS.UserSpace⍎R){⍺,(count,mean,sdev)⍵}⌸NS.UserSpace⍎V
             NS.Table←G
             NS.CellTypes←(⍴NS.Table)⍴'T'
         :EndIf
     :Case 'Factor2'
         Prev←0≠↑0⍴↑NS.Table[0;1]     ⍝ Previous state 0=1-factor, 1=2-factor
                 ⍝ ⍝ :If C∧.=' ' ⋄ :OrIf (⊂C)∊0 1         ⍝ One Way Anova
         :Select D←NS.get'Design'
         :Case 'oneWay'
             NS.Table←⊃{(,⍵)5 0 1}¨⎕A[⍳R]
             NS.CellTypes←3 4⍴'ANXF'
             NS.ColTitles2←'Group' 'N' 'Mean' 'Std Dev'
         :Case 'factorial2k'
             NS.Table←R C D resizeTable NS.Table
                    ⍝   NS.CellTypes←R(C+1)⍴1(C+1)/'AF'
             NS.CellTypes←(2*R)(C+1)⍴1 C/'AF'  ⍝ Fix bug in factorial2k
         :Else                            ⍝ Two Way Anova
             :If 0=↑0⍴R
                 :If Prev ⋄ NS.Table←R C resizeTable NS.Table
                 :Else ⋄ H←,¨'*',⎕A[⍳C]
                     NS.Table←H⍪(1+⍳R),R C⍴⎕NULL
                 :EndIf
                         ⍝  NS.CellTypes←'T','T'⍪R C⍴'X'
                 NS.CellTypes←'A','A'⍪R C⍴'X'
                 NS.ColTitles2←' '
             :Else
                 NS.CellTypes←(⍴NS.Table)⍴'T'
                 NS.ColTitles2←' '
             :EndIf
         :EndSelect
     :Case 'LbFactor1'
         :If 'Factor 1'≡NS.get'LbFactor1'
             NS.Grid.Values←'LbFactor2'NS.put'Factor 2'
             B←'stats'≡NS.get'Var'
                     ⍝  NS.Grid.Values←'Factor2'NS.put B⊃'[Select]' 3
             NS.Grid.Values←'Factor2'NS.put B⊃'' 3
         :Else
             NS.Grid.Values←'LbFactor2'NS.put' '
         :EndIf
     :EndSelect
 :Case 'Run'
     NS←runAnova NS
 :Case ''   ⍝ If empty,no-op
     
 :EndSelect
     
 Z←NS
∇

 anovaAttr←{
           ⍝ Assign attributes to hypothesis fields
     NS←⍵
     A←⎕NS''
     NS.LbFactor1List←'Treatments' 'Factor 1'
     NS.LbFactor2List←'Blocks' 'Factor 2'
     NS.VarList←⊂'summary'
     NS.Table←⊃{(,⍵)5 0 1}¨'ABC'
     NS.Table←⊃{(,⍵)5,2/⎕NULL}¨'ABC'
     NS.CellTypes←'TNXF'
     NS.UserSpace←#
     NS.ColTitles2←'Group' 'N' 'Mean' 'Std Dev'
     NS.ReturnCode←0
     NS.FactorList←'Treatment' 'Factor 1'
     NS.Factor2List←' ' 'Factor2'
     A.Items←'normal' 'multinomial' 'uniform'
     NS.Grid.Attributes←'Dist'NS.changeAttributes A
     A.Items←'goodnessOfFit' 'independent'
     NS.Grid.Attributes←'Op'NS.changeAttributes A
     A←⎕NS'' ⋄ A.Items←'F'              ⍝ Numeric field (Floating Point)
     NS.Grid.Attributes←'Var'NS.changeAttributes A
     A←⎕NS'' ⋄ A.validate←{(⍵=⌊⍵)∧⍵>0}
     A.ErrorMsg←'Must be a postive integer'
     A.FormatString←'I6'
     NS.Grid.Attributes←'Cols'NS.changeAttributes A
     NS}

 anovaGrid←{
               ⍝∊ Written by Steve Mansour 2019
               ⍝∇ Build a Grid Object for Anova wizard
               ⍝⍵ Empty Namespace
               ⍝← Namespace containing the following:
               ⍝←  Grid.Names:   Cell name, e.g. 'Parameter' 'SampSize'
               ⍝←  Grid.Values:  Cell vallue, e.g. 'mean' 30
               ⍝←  Grid.Types:   Cell type, e.g. 'Txt'  'Int'
               ⍝←  'mean' ← NS.get 'Parameter'
               ⍝←  GridValues ← 'SampSize' NS.put 30
     ⎕IO←0 ⋄ ⎕ML←3
     f←⊂∘toNestedVector
     ⍵.Grid←⎕NS''
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Values ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'Significance,0.050'
     G,←f'     ,'
     G,←f'Design,oneWay'
     G,←f'Operation,anova'
     G,←f'Variable,stats'
     G,←f'Treatments,3'
     G,←f' , '
     G,←f' , '
     I←⍸{↑↑⎕VFI ⍵}¨⊃G         ⍝ Find indices of numeric cells
     ⍵.Grid.Values←⍎¨@I⊃G     ⍝ Replace text with numerical values
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Names ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'LbSig,Sig'
     G,←f'LbLeftArg,LeftArg'
     G,←f'LBDesign,Design'
     G,←f'LbOp,Op'
     G,←f'LbVar,Var'
     G,←f'LbFactor1,Factor1'
     G,←f'LbFactor2,Factor2'
     G,←f'LbFactor3,Factor3'
     ⍵.Grid.Names←⊃G
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Types ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
              ⍝ G←⊃'TQ' 'TT' 'TD' 'TN' 'TN'
     G←⊃'TQ' 'TT' 'TD' 'TT' 'TD' 'TN' 'TT' 'TT'
     ⍵.Grid.Attributes←⎕NS¨8 2⍴⊂''
     ⍵.Grid.Attributes.Type←⊃G
                ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Events ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.get←{1<≡⍵:∇¨⍵ ⋄ (⍸Grid.Names∊⊂⍵)⊃Grid.Values}
     ⍵.put←{w←⊆⍣(80=⎕DR ⍵)⊢⍵ ⋄ (w@(⍸Grid.Names∊⊆⍺))Grid.Values}
     ⍵.changeAttributes←changeAttributes
     ⍵}

∇ Z←aovAPI NS;A;B;C;D;FF;G;H;R;N;V;f;Prev;⎕IO;⎕ML
               ⍝∇ ns-based API for Anova - Last updated 6/25
               ⍝⍵ nsIn Namespace containing the following variables
               ⍝⍵   Event 'Init'
               ⍝⍵   Event 'Select'  : Select parameter, Sample or Sample2
               ⍝← nsOut  Namespace containing  DataStat Report
               ⍝← Output Results Expr
               ⍝   Parameter:   mean, proportion, sdev, var
               ⍝   Data:  1 or 2-item nested vector:    Expression or stats
               ⍝   Values:  1×3 or 2×3 numeric matrix
               ⍝   UserSpace:   Ref or
               ⍝⍵    Parameter Levels Var GroupBy Var2
               ⍝← nsOut Namespace contain nsIn plus the following:
               ⍝←    Labels  2-item nested vector
               ⍝←    Values  1x3 or 2x3 numeric matrix
               ⍝←    Protect 2×3 boolean matrix 1=protect, 0=editable
 ⎕IO←0 ⋄ ⎕ML←3
 :Select NS.Event
 :Case 'Init'
     NS←aovGrid NS
     A←⎕NS''                    ⍝ Build grid
     A.Type←'D' ⋄ A.Items←'F' ⋄ A.TopItem←'stats'
     NS.Grid.Attributes←'Var'NS.changeAttributes A
     A←⎕NS''
     A.Type←'Q' ⋄ A.Decimals←3
     NS.Grid.Attributes←'Sig'NS.changeAttributes A
     NS.Table←⊃{(,⍵)5,2⍴⎕NULL}¨'ABC'
     NS.CellTypes←3 4⍴'ANXF'
     NS.UserSpace←#
     NS.ColTitles2←'Group' 'N' 'Mean' 'Std Dev'
     NS.ReturnCode←0
 :Case 'Select'
     FF←'Factor1' 'Factor2'
     R C←NS.get FF
     :Select NS.EventArg
     :Case 'Var'
         :If 'stats'≡NS.get'Var'
             NS.Grid.Attributes←FF NS.changeAttributes'N'
             NS.Grid.Values←FF NS.put 3 ''
             NS.Grid.Values←('Lb'∘,¨FF)NS.put'Treatments' 'Blocks(Optional)'
         :Else
             A←⎕NS''
             A.Type←'D' ⋄ A.Items←'A'
             NS.Grid.Attributes←FF NS.changeAttributes A
             NS.Grid.Values←FF NS.put⊂''
             NS.Grid.Values←('Lb'∘,¨FF)NS.put FF,¨'' '(Optional)'
         :EndIf
     :Case 'Factor1'
         :If 0=↑0⍴R
             :If C∧.=' ' ⋄ :OrIf (⊂C)∊0 1     ⍝ One way Anova
                 NS.Table←R resizeTable NS.Table
                 NS.CellTypes←R 4⍴'ANXF'
             :Else                           ⍝ Two Way Anova
                 H←⍕¨1+⍳R
                 NS.Table←NS.Table[0;]⍪H,R↑1 1↓NS.Table
                 NS.CellTypes←'A','A'⍪R C⍴'X'
             :EndIf
         :Else
             V←NS.get'Var'
             G←(NS.UserSpace⍎R){⍺,(count,mean,sdev)⍵}⌸NS.UserSpace⍎V
             NS.Table←G
             NS.CellTypes←'T'
         :EndIf
     :Case 'Factor2'
         Prev←0≠↑0⍴↑NS.Table[0;1]     ⍝ Previous state 0=1-factor, 1=2-factor
         :If C∧.=' ' ⋄ :OrIf (⊂C)∊0 1         ⍝ One Way Anova
             NS.Table←⊃{(,⍵)5 0 1}¨⎕A[⍳R]
             NS.CellTypes←3 4⍴'ANXF'
             NS.ColTitles2←'Group' 'N' 'Mean' 'Std Dev'
         :Else                            ⍝ Two Way Anova
             :If 0=↑0⍴R
                 :If Prev ⋄ NS.Table←R C resizeTable NS.Table
                 :Else ⋄ H←,¨'*',⎕A[⍳C]
                     NS.Table←H⍪(1+⍳R),R C⍴⎕NULL
                 :EndIf
                         ⍝  NS.CellTypes←'T','T'⍪R C⍴'X'
                 NS.CellTypes←'A','A'⍪R C⍴'X'
                 NS.ColTitles2←' '
             :Else
                 NS.CellTypes←'T'
                 NS.ColTitles2←' '
             :EndIf
         :EndIf
     :Case 'LbFactor1'
         :If 'Factor 1'≡NS.get'LbFactor1'
             NS.Grid.Values←'LbFactor2'NS.put'Factor 2'
             B←'stats'≡NS.get'Var'
                     ⍝  NS.Grid.Values←'Factor2'NS.put B⊃'[Select]' 3
             NS.Grid.Values←'Factor2'NS.put B⊃'' 3
         :Else
             NS.Grid.Values←'LbFactor2'NS.put' '
         :EndIf
     :EndSelect
 :Case 'Run'
     NS←runAov NS
 :Case ''   ⍝ If empty,no-op
     
 :EndSelect
     
 Z←NS
∇

 aovGrid←{
               ⍝∊ Written by Steve Mansour 2019
               ⍝∇ Build a Grid Object for Hypothesis wizard
               ⍝⍵ Empty Namespace
               ⍝← Namespace containing the following:
               ⍝←  Grid.Names:   Cell name, e.g. 'Parameter' 'SampSize'
               ⍝←  Grid.Values:  Cell vallue, e.g. 'mean' 30
               ⍝←  Grid.Types:   Cell type, e.g. 'Txt'  'Int'
               ⍝←  'mean' ← NS.get 'Parameter'
               ⍝←  GridValues ← 'SampSize' NS.put 30
     ⎕IO←0 ⋄ ⎕ML←3
     f←⊂∘toNestedVector
     ⍵.Grid←⎕NS''
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Values ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'Significance,0.050'
     G,←f'Factors,1'
     G,←f'Design,oneWay'
     G,←f'Operation,anova'
     G,←f'Variable,stats'
     G,←f'Treatments,3'
     G,←f'Blocks(Optional), '
     I←⍸{↑↑⎕VFI ⍵}¨⊃G        ⍝ Find indices of numeric cells
     ⍵.Grid.Values←⍎¨@I⊃G     ⍝ Replace text with numerical values
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Names ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'LbSig,Sig'
     G,←f'LbOp,Op'
     G,←f'LbVar,Var'
     G,←f'LbFactor1,Factor1'
     G,←f'LbFactor2,Factor2'
     ⍵.Grid.Names←⊃G
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Types ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←⊃'TQ' 'TT' 'TD' 'TN' 'TN'
     ⍵.Grid.Attributes←⎕NS¨5 2⍴⊂''
     ⍵.Grid.Attributes.Type←⊃G
                ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Events ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.get←{1<≡⍵:∇¨⍵ ⋄ (⍸Grid.Names∊⊂⍵)⊃Grid.Values}
     ⍵.put←{w←⊆⍣(80=⎕DR ⍵)⊢⍵ ⋄ (w@(⍸Grid.Names∊⊆⍺))Grid.Values}
     ⍵.changeAttributes←changeAttributes
     ⍵}

∇ blockedAPI NS;FLD;⎕IO;⎕ML
 ⎕IO←0 ⋄ ⎕ML←3                     ⍝ Build grid
     
 FLD←'LeftArg' 'Factor3'
 NS.Grid.Attributes←FLD NS.changeAttributes'T'
 NS.Grid.Values←(FLD,'Lb',¨FLD)NS.put' '
 FLD←'Factor1' 'Factor2'
 NS.Grid.Attributes←FLD NS.changeAttributes'N'
 NS.Grid.Values←FLD NS.put 3
 NS.Grid.Values←('Lb'∘,¨FLD)NS.put'Treatments' 'Blocks'
 NS.Table←4 4⍴'*' 'A1' 'A2' 'A3','B1' 'B2' 'B3'⍪3 3⍴0
 NS.CellTypes←'A','A'⍪3 3⍴'X'
∇

 changeAttributes←{
           ⍝⍺ Name or list of Names
           ⍝⍵ Scalar, Vector of Types, Namespace or  Vector of Namespaces
           ⍝← Modified Matrix of Attributes
     ⎕IO←0 ⋄ ⎕ML←3
     f←{A←⎕NS'' ⋄ A.Type←⍵
         ⍵='F':{⍵.validate←{⍵≥0}
             ⍵.ErrorMsg←'Cannot be negative'
             ⍵.FormatString←'F10.5' ⋄ ⍵}A
         ⍵='P':{⍵.validate←{1≠×/×⍵-0 1}
             ⍵.ErrorMsg←'Must be between 0 and 1 inclusive'
             ⍵.Decimals←4 ⋄ ⍵}A
         ⍵='Q':{⍵.validate←{0=+/×⍵-0 1}
             ⍵.ErrorMsg←'Must be between 0 and 1 exclusive'
             ⍵.Decimals←4 ⋄ ⍵}A
         ⍵='N':{⍵.validate←{(⍵>0)∧⍵=⌊⍵}
             ⍵.ErrorMsg←'Must be positive integer'
             ⍵.FormatString←'I6' ⋄ ⍵}A
         ⍵='I':{⍵.validate←{(⍵≥0)∧⍵=⌊⍵}
             ⍵.ErrorMsg←'Must be integer'
             ⍵.FormatString←'I6' ⋄ ⍵}A
         ⍵='E':{⍵.validate←{0::0 ⋄ ↑⍴⍴⍴UserSpace⍎⍵}
             ⍵.ErrorMsg←'Syntax Error' ⋄
             ⍵.Items←(⊂'stats'),1 variables UserSpace ⋄ ⍵}A
         ⍵='D':{⍵.validate←{1}
             ⍵.ErrorMsg←'Syntax Error' ⋄
             ⍵.Items←1 variables UserSpace ⋄ ⍵}A
         ⍵='T':{⍵.validate←{1} ⋄ ⍵}A
         {⍵.validate←{1}
             ⍵.FormatString←'M<->F12.5' ⋄ ⍵}A}
     i←⍸Grid.Names∊⊆⍺                       ⍝ Get index of left argument
     2=⎕NC'⍵':((f¨⍵)@i)Grid.Attributes      ⍝ If right arg
     2=≡⍺:↑⍺ ∇¨⍵ ⋄ a←(↑i)⌷Grid.Attributes
     _←'a'⎕NS ⍵ ⋄ Grid.Attributes}

∇ Z←chiSquareAPI NS;A;B;C;D;H;I;R;V;W;N;X;TY;f;⎕IO;⎕ML
               ⍝∇ ns-based API for ChiSquareTests - Last updated 6/25
               ⍝⍵ nsIn Namespace containing the following variables
               ⍝⍵   Event 'Init'
               ⍝⍵   Event 'Select'  : Select parameter, Sample or Sample2
               ⍝⍵   Event 'Update'  : Update Events, Proportion, Variance or Standard Deviation
               ⍝⍵   Event 'Run'  Signficance Data Parameter Relational HypothesizedValue
               ⍝← nsOut  Namespace containing  DataStat Report
               ⍝← Output Results Expr
               ⍝   Parameter:   mean, proportion, sdev, var
               ⍝   Data:  1 or 2-item nested vector:    Expression or stats
               ⍝   Values:  1×3 or 2×3 numeric matrix
               ⍝   UserSpace:   Ref or
               ⍝⍵    Parameter Levels Var GroupBy Var2
               ⍝← nsOut Namespace contain nsIn plus the following:
               ⍝←    Labels  2-item nested vector
               ⍝←    Values  1x3 or 2x3 numeric matrix
               ⍝←    Protect 2×3 boolean matrix 1=protect, 0=editable
 ⎕IO←0 ⋄ ⎕ML←3
 :Select NS.Event
 :Case 'Init'
     NS←chiSquareGrid NS                             ⍝ Build grid
     NS←chiSquareAttr NS
              ⍝ NS.Table←⊃{(,⍵)0 0.25}¨'ABCD'
     NS.Table←⊃{(,⍵)⍬ 0.25}¨'ABCD'
     NS.UserSpace←#
     NS.ColTitles2←'Group' 'Observed' 'Proportion/Expected'
     NS.ColTypes←'ANT'
     NS.CellTypes←4 3⍴'ANT'
     NS.ReturnCode←0
 :Case 'Select'
     :Select NS.EventArg
     :Case 'Op'
         :If 'goodnessOfFit'≡NS.get'Op'
             A←⎕NS'' ⋄ A.Type←'D'
                    ⍝   A.Items←'normal' 'multinomial' 'uniform' 'poisson'
             A.Items←'multinomial' 'uniform' 'poisson'
             NS.Grid.Attributes←'Dist'NS.changeAttributes A
             NS.Grid.Values←'LbDist' 'Dist'NS.put'Distribution' 'uniform'
             NS.Grid.Values←'LbRows' 'LbRowType' 'Rows' 'RowType'NS.put⊂''
             NS.Grid.Attributes.Type←'Rows' 'RowType'NS.changeType'T'
             NS.Grid.Values←'LbVar' 'Cols' 'VarType'NS.put'Variable' 4 'Char'
             NS.Grid.Values←'Var'NS.put'frequency'
             NS.Grid.Attributes.Type←'Dist'NS.changeType'D'
                      ⍝ NS.Table←⊃{(,⍵)0 0.25}¨'ABCD'
             NS.Table←⊃{(,⍵)⍬ ⍬}¨'ABCD'
             NS.ColTitles2←'Group' 'Observed' 'Proportion/Expected'
                      ⍝ NS.ColTypes←'ANT'
             NS.CellTypes←4 3⍴'ANT'
         :Else                            ⍝ independent
             NS.Grid.Values←'LbRows'NS.put'Categories'
             NS.Grid.Values←'LbDist'NS.put'Variable 1'
             NS.Grid.Values←'Dist' 'Rows' 'RowType'NS.put'frequency' 2 'Char'
             A←⎕NS''
             A.Type←'E' ⋄ A.Items←'A' ⋄ A.TopItem←'frequency'
             NS.Grid.Attributes←'Dist'NS.changeAttributes A
             NS.Grid.Attributes←'Var'NS.changeAttributes A
             NS.Grid.Values←'LbVar'NS.put'Variable 2'
             NS.Grid.Values←'Var' 'Cols' 'VarType'NS.put'frequency' 2 'Char'
             NS.Grid.Attributes.Type←'Rows' 'RowType' 'Cols' 'VarType'NS.changeType'NTNT'
                       ⍝ NS.Table←(,¨'*','A1' 'A2'),(,¨'B1' 'B2')⍪2 2⍴⎕NULL
                     ⍝  NS.Table←(,¨'*','A1' 'A2'),(,¨'B1' 'B2')⍪2 2⍴0
             NS.Table←(,¨'*' 'A1' 'A2'),('B1' 'B2')⍪2 2⍴⊂⍬
             NS.ColTitles2←''
             NS.CellTypes←'A','A'⍪(⍴NS.Table)⍴'I'
                      ⍝ NS.CellTypes←'A','A'⍪(⍴NS.Table)⍴'N'
         :EndIf
     :Case 'Dist'
         :If 'goodnessOfFit'≡NS.get'Op'
             NS.Grid.Attributes.Type←'VarType'NS.changeType'D'
             C←NS.get'Cols'
             NS←C populateData NS
             :Select NS.get'Dist'
             :Case 'uniform' ⋄ NS.CellTypes←'ANT' ⋄ NS.ColTypes←'ANT'
             :Case 'multinomial' ⋄ NS.CellTypes←'ANQ'
             :Case 'normal' ⋄ NS.CellTypes←'XNT'
                 NS.Grid.Values←'VarType'NS.put'Num'
                 NS.Grid.Attributes.Type←'VarType'NS.changeType'T'
             :EndSelect
             NS.CellTypes←(⍴NS.Table)⍴NS.CellTypes
         :Else
             TY←('frequency'≡NS.get'Dist')⊃'TN'
             NS.Grid.Attributes.Type←'Rows'NS.changeType TY
             NS.CellTypes←'A','A'⍪(¯1+⍴NS.Table)⍴'I'
             C←('Char'≢NS.get'RowType')×NS.get'Rows'   ⍝  Fix bug
             NS←C populateData NS                      ⍝
         :EndIf
     :Case 'Rows'
         NS.Table←(NS.get'Rows')0 resizeTable NS.Table
         NS.CellTypes←'A','A'⍪(¯1+⍴NS.Table)⍴'I'
     :Case 'Cols'                                        ⍝
         :If 'goodnessOfFit'≡NS.get'Op'
             R←≢NS.Table
             :If 0≢↑0⍴↑NS.Table ⋄ R←⎕A[,R] ⋄ :EndIf
             NS.Table←(NS.get'Cols')resizeTable NS.Table
             V←NS.get'Dist' 'Var' 'VarType'
             :If ∧/V≢¨'multinomial' 'frequency' 'Char'
                 X←⍎NS.UserSpace exErr 1⊃V               ⍝ Get data set
                         ⍝  W←(range X)÷¯1+N←NS.get'Cols'
                 W←NS.get'Cols'
                 D←W frequency X
                 :If 'normal'≡↑V
                     NS.Table←D,NS.normProbs≢D           ⍝ Get normal probabilties
                     NS.CellTypes←'XNT'
                 :Else ⋄ NS.Table←D,÷≢D ⋄ :EndIf         ⍝ Get uniform probabilities
             :Else
                 D←≢NS.Table
                 :If 'normal'≢↑V ⋄ NS.Table[;2]←÷D ⋄ :Else  ⍝ If uniform
                     NS.Table[;2]←NS.normProbs D ⋄
                     NS.CellTypes←'XNT'
                 :EndIf
             :EndIf
             NS.CellTypes←(⍴NS.Table)⍴NS.CellTypes
         :Else
             NS.Table←0(NS.get'Cols')resizeTable NS.Table
             NS.CellTypes←'A','A'⍪(¯1+⍴NS.Table)⍴'I'
         :EndIf
     :CaseList 'VarType' 'RowType'
         f←{=/⍺:⍵ ⋄ </⍺:(≢⍵)↑⎕A ⋄ ⍳⍴⍵}                   ⍝ Convert numeric/char headings
         :If 'goodnessOfFit'≡NS.get'Op'
             C←' '≡↑↑0⍴NS.Table[;0]                      ⍝ Old Var Type
             C,←'Char'≡NS.get'VarType'                   ⍝ New Var Type
             NS.Table[;0]←C f NS.Table[;0]
             NS.CellTypes[;0]←C[1]⊃'XA'                  ⍝ Change 1st col type?
         :Else
             (R C)←NS.get'RowType' 'VarType'
             B←R C↑1 1↓NS.Table
             NS.Table[;0]←'*',⍕¨1+⍳R
             NS.Table[0;]←'*',C↑⎕A
         :EndIf
     :Case 'Var'
         C←('Char'≢NS.get'VarType')×NS.get'Cols'
         NS←C populateData NS
     :EndSelect
 :Case 'Run'
     NS←runChiSqTest NS
 :Case ''                                           ⍝ If empty,no-op
 :Else
              ⍝ NS.Grid.Values←NS.rectifyStats NS.Event
 :EndSelect
 Z←NS
∇

 chiSquareAttr←{
           ⍝ Assign attributes to hypothesis fields
     NS←⍵
     A←⎕NS''
             ⍝  A.Items←'normal' 'multinomial' 'uniform' 'poisson'
     A.Items←'multinomial' 'uniform' 'poisson'
     NS.Grid.Attributes←'Dist'NS.changeAttributes A
     A.Items←'goodnessOfFit' 'independent'
     NS.Grid.Attributes←'Op'NS.changeAttributes A
     A.Items←'Char' 'Num'
     NS.Grid.Attributes←'VarType'NS.changeAttributes A
     A←⎕NS'' ⋄ A.Items←'A' ⋄ A.TopItem←'frequency'
     NS.Grid.Attributes←'Var'NS.changeAttributes A
     A←⎕NS'' ⋄ A.validate←{(⍵=⌊⍵)∧⍵>0}
     A.ErrorMsg←'Must be a postive integer'
     A.FormatString←'I6'
     NS.Grid.Attributes←'Cols'NS.changeAttributes A
     A←⎕NS'' ⋄ A.Decimals←3    ⍝ Force 3 decimal places
     NS.Grid.Attributes←'Sig'NS.changeAttributes A
     NS}

 chiSquareGrid←{
               ⍝∊ Written by Steve Mansour 2019
               ⍝∇ Build a Grid Object for ChiSquare wizard
               ⍝⍵ Empty Namespace
               ⍝← Namespace containing the following:
               ⍝←  Grid.Names:   Cell name, e.g. 'Parameter' 'SampSize'
               ⍝←  Grid.Values:  Cell vallue, e.g. 'mean' 30
               ⍝←  Grid.Types:   Cell type, e.g. 'Txt'  'Int'
               ⍝←  'mean' ← NS.get 'Parameter'
               ⍝←  Grid.Values ← 'SampSize' NS.put 30
     ⎕IO←0 ⋄ ⎕ML←3
     ⍵.Grid←⎕NS''
     f←⊂∘toNestedVector
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Values ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'Significance,0.05,Categories,Type'
     G,←f'Distribution,uniform, , '
     G,←f'Operator,goodnessOfFit,Categories,Type'
     G,←f'Variable,frequency,4,Char'
     I←⍸{↑↑⎕VFI ⍵}¨⊃G        ⍝ Find indices of numeric cells
     ⍵.Grid.Values←⍎¨@I⊃G     ⍝ Replace text with numerical values
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Names ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'LbSig,Sig,LbRows,LbVarType'
     G,←f'LbDist,Dist,Rows,RowType'
     G,←f'LbOp,Op, '
     G,←f'LbVar,Var,Cols,VarType'
     ⍵.Grid.Names←⊃G
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Types ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.Grid.Attributes←⎕NS¨4 4⍴⊂''
     G←⊃'TQTT' 'TDTT' 'TDTT' 'TEND'
     ⍵.Grid.Attributes.Type←⊃G
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Events ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.get←{1<≡⍵:∇¨⍵ ⋄ ⍺←Grid.Values ⋄ (⍸Grid.Names∊⊂⍵)⊃⍺}
     ⍵.put←{w←⊆⍣(80=⎕DR ⍵)⊢⍵ ⋄ (w@(⍸Grid.Names∊⊆⍺))Grid.Values}
     ⍵.changeType←{(⍵@(⍸Grid.Names∊⊆⍺))Grid.Attributes.Type}
     ⍵.normProbs←{P←(⊂0.5 0.25×⍵-1)normal prob between¨2,/¯0.5+⍳⍵+1
         P+(1⌽1 1↑⍨≢P)×0.5×1-+/P}
     ⍵.changeAttributes←changeAttributes
     ⍵}

∇ Z←confIntAPI NS;pop;⎕IO;⎕ML;V;XP;SH;I;X;S1;S2;H;LB;LN;SN;PA;TY;LV;L2;A
               ⍝∇ ns-based API for ConfInt
               ⍝∊ Written by Steve Mansour     updated 7/7/2019
               ⍝⍵ nsIn Namespace containing the following variables
               ⍝   Event:  Init, Stat, Data, Proportion, Events, Var, Sdev, Size
               ⍝   Parameter:   mean, proportion, sdev, var
               ⍝   Data:  1 or 2-item nested vector:    Expression or stats
               ⍝   Values:  1×3 or 2×3 numeric matrix
               ⍝   UserSpace:   Ref or
               ⍝⍵  Parameter Levels Var GroupBy Var2
               ⍝← nsOut Namespace contain nsIn plus the following:
               ⍝←    Labels  2-item nested vector
               ⍝←    Values  1x3 or 2x3 numeric matrix
               ⍝←    Protect 2×3 boolean matrix 1=protect, 0=editable
 ⎕IO←0 ⋄ ⎕ML←3
 NS.ReturnCode←0 ⋄ NS.ErrorMessage←'' ⋄ NS.⎕ML←3 ⋄ NS.⎕IO←0
 LV←toNestedVector'Level1,Level2,Level3,Level4'
 :Select NS.Event
 :Case 'Init'
     NS←confIntGrid NS                         ⍝ Build grid
     NS←confIntAttr NS    ⍝ Assign attributes
     NS.ReturnCode←0
 :Case 'Select'
     NS←confIntChange NS
 :Case 'Run'
     NS.Grid.Values←LV NS.put 4↑NS.Levels
     NS←getConfGrid NS
 :Else
     NS.Grid.Values←NS.rectifyStats NS.Event
 :EndSelect
 Z←NS
∇

 confIntAttr←{
     NS←⍵
     A←⎕NS''
     A.Items←'' 'Method' 'Population Size'
     NS.Grid.Attributes←'LbMethod'NS.changeAttributes A
     A.Items←'UnknownSigma' 'KnownSigma'
     NS.Grid.Attributes←('Method'∘,¨'1234')NS.changeAttributes A
     A.Items←'mean' 'proportion' 'var' 'sdev' 'median' 'sum' 'percentile' 'quartile'
     NS.Grid.Attributes←'Parameter'NS.changeAttributes A
     A.Items←'--' ' - Sample2' 'splitBy' 'groupBy'
     NS.Grid.Attributes←'LbSample2'NS.changeAttributes A
     A.Items←'F' ⋄ A.TopItem←'stats' ⍝ Numeric field (Floating Point)
         ⍝ A.Items←'f' ⋄ A.TopItem←'stats' ⍝ Numeric field (Floating Point)
     NS.Grid.Attributes←'Sample'NS.changeAttributes A
     A←⎕NS''
     A.validate←{(⍵=⌊⍵)∧⍵>0}
     A.ErrorMsg←'Must be a postive integer'
     A.FormatString←'I6'
     NS.Grid.Attributes←'SampSize' 'SampSize2'NS.changeAttributes A
     A.validate←{⍵≥0}
     A.ErrorMsg←'Negative values not permitted.'
     A.FormatString←'F9.5'
     A.Decimals←0
     NS.Grid.Attributes←'Sdev' 'Sdev2'NS.changeAttributes A
     A.validate←{1}
     A.FormatString←'F12.5'
     NS.Grid.Attributes←'Mean' 'Mean2'NS.changeAttributes A
     A←⎕NS''
     A.Decimals←2
     A.FormatString←'F5.2'
     NS.Grid.Attributes←'Level1' 'Level2' 'Level3' 'Level4'NS.changeAttributes A
     NS
 }

∇ Z←confIntChange NS;A;I;IT;LB;LN;SN;L2;LN;S1;S2;TY;LV;J;MT;PARM;METH;NMS;⎕IO;⎕ML
 ⎕IO←0 ⋄ ⎕ML←3
 LV←toNestedVector'Level1,Level2,Level3,Level4'
 NS.Grid.Values←LV NS.put 4↑NS.Levels
 LB←'Sample Size' 'Mean' 'Std Dev'            ⍝ Label Values
 LN←'Lb'∘,¨SN←'SampSize' 'Mean' 'Sdev'
 L2 PARM METH←NS.get'LbSample2' 'Parameter' 'LbMethod'
 S1 S2←(NS.get¨'Sample' 'Sample2')∊⊂'stats'   ⍝ stats selected?
 A←⎕NS'' ⋄ MT←''
 :Select PARM
 :Case 'mean'
     :Select L2
     :CaseList '--' 'groupBy'
         MT←'Unknown σ' 'Known σ'
     :CaseList ' - Sample2' 'splitBy'
         MT←'Unequal Variance' 'Equal Variance' 'Paired Difference' 'Known σ'
     :EndSelect
 :Case 'proportion'
     :Select L2
     :CaseList '--' 'groupBy'
         MT←'Normal' 'Binomial' 'Wilson Score' 'Continuity Correction'
     :CaseList ' - Sample2' 'splitBy'
         MT←''
     :EndSelect
 :Else ⋄ MT←''
 :EndSelect
 J←⍸NS.Grid.Names∊NMS←'Method1' 'Method2' 'Method3' 'Method4'     ⍝ Change Method Options?
 :If METH≡'Method'
        ⍝  (J⌷¨⊂NS.Grid.Attributes).Type←'TD'[1<≢MT]                ⍝
     A←⎕NS'' ⋄ A.Type←'TD'[1<≢MT]
             ⍝ (J⌷¨⊂NS.Grid.Attributes).Items←⊂MT
     :If ×≢MT ⋄ A.Items←MT ⋄ :EndIf
     NS.Grid.Attributes←NMS NS.changeAttributes A
 :Else
          ⍝(J⌷¨⊂NS.Grid.Attributes).Type←'FTTT'
     NS.Grid.Attributes←NMS NS.changeAttributes'FTTT'
 :EndIf
 :If (⊂NS.EventArg)∊'lbMethod' 'Parameter' 'LbSample2'
     NS.Grid.Values←('Method'∘,¨'1234')NS.put 4↑1↑MT
 :EndIf
 :Select NS.EventArg
 :Case 'Parameter'
     NS.Grid.Values←'LbMethod1'NS.put'Method'
        ⍝  NS.Grid.Attributes←'Method1' NS.changeAttributes 'D'
     :Select PARM
     :Case 'mean' ⋄ TY←'NFF' ⋄ IT←'F'                         ⍝ mean, proportion or variance?
     :Case 'sum' ⋄ TY←'NFF' ⋄ IT←'F'
         NS.Grid.Values←'LbMethod' 'Method1'NS.put'Sample Size' 100
         NS.Grid.Attributes←'Method1'NS.changeAttributes'N'
     :Case 'median' ⋄ TY←'NNN' ⋄ IT←'F'
         LB[1 2]←'Below' 'Above'
     :Case 'proportion' ⋄
         LB[1 2]←'Proportion' 'Events'
         TY←'NPN' ⋄ IT←'b'
     :CaseList 'var' 'variance' 'sdev'                        ⍝ Relabel to appropriate parameter
         LB[1]←⊂'Variance' ⋄ TY←'NFF' ⋄ IT←'F'
     :CaseList 'percentile' 'quartile'
         TY←'TTT' ⋄ IT←'f'
         NS.Grid.Values←'LbMethod'NS.put'--'
         NS.Grid.Values←'Method1'NS.put 1×25*PARM≡'percentile'
         NS.Grid.Attributes←'Method1'NS.changeAttributes'F'
     :EndSelect
     
     I←⍸NS.Grid.Names∊SN
     NS.Grid.Values←LN NS.put LB                              ⍝ Display labels for Sample1?
     NS.Grid.Attributes←SN NS.changeAttributes TY             ⍝ Change cell types for Sample1 statistics
     NS.Grid.Attributes←(SN,¨'2')NS.changeAttributes TY       ⍝ Change cell types for sample2 statistics
     A←⎕NS'' ⋄ A.Type←'E' ⋄ A.Items←IT ⋄ A.TopItem←'stats'    ⍝ Changes items
     NS.Grid.Attributes←'Sample'NS.changeAttributes A
     NS.Grid.Values←NS.rectifyStats'Sample'
     (I⌷¨⊂NS.Grid.Attributes).ReadOnly←0
 :Case 'LbMethod'
     :Select NS.get'LbMethod'
     :Case 'Method'
             ⍝ A.(Type Items)←'D' MT
         NS.Grid.Attributes←('Method'∘,¨'1234')NS.changeAttributes'DDDD'
         (J⌷¨⊂NS.Grid.Attributes).Items←⊂MT
     :CaseList '--' 'Population Size'
         NS.Grid.Attributes←('Method'∘,¨'1234')NS.changeAttributes'FTTT'
         NS.Grid.Values←'Method1'NS.put 100
         (J⌷¨⊂NS.Grid.Attributes).Items←⊂''
     :EndSelect
 :Case 'LbSample2'
     NS.Grid.Values←'LbSample'NS.put'Sample',(L2≡'Sample 2')/' 1' ⍝ Sample or Sample 1?
      ⋄ I←⍸NS.Grid.Names∊SN,¨'2'
     :Select L2
     :Case '--'
         NS.Grid.Values←(SN,¨'2')NS.put ⍬ ⍬ ⍬
         NS.Grid.Attributes←(SN,¨'2')NS.changeAttributes'T'   ⍝
         NS.Grid.Attributes←'Sample2'NS.changeAttributes'T'
         NS.Grid.Values←'Sample2'NS.put''
         (I⌷¨⊂NS.Grid.Attributes).ReadOnly←1
     :Case ' - Sample2'
         NS.Grid.Values←'LbSample'NS.put'Sample1'
         NS.Grid.Values←NS.rectifyStats'Sample2'
         TY←('proportion'≡NS.get'Parameter')⊃'NFF' 'NPN'
         NS.Grid.Attributes←(SN,¨'2')NS.changeAttributes TY
                  ⍝ A.Items←(⊂'stats'),1 variables NS.UserSpace
         NS.Grid.Values←'Sample2'NS.put'stats'
         (I⌷¨⊂NS.Grid.Attributes).ReadOnly←0
         A.Items←'fp'⊃⍨'proportion'≡NS.get'Parameter'
         A.Type←'E' ⋄ A.TopItem←'stats'
         NS.Grid.Attributes←'Sample2'NS.changeAttributes A
     :CaseList 'splitBy' 'groupBy'
         :If S2 ⋄ NS.GridValues←'Sample2'NS.put' ' ⋄ :EndIf
         NS.Grid.Values←'LbSample'NS.put'Sample'
             ⍝A.Type←'E' ⋄ A.Items←'bC'[L2≡'groupBy'] ⋄ A.TopItem←''
         A.Type←'E' ⋄ A.Items←'bA'[L2≡'groupBy'] ⋄ A.TopItem←''
         (I⌷¨⊂NS.Grid.Attributes).ReadOnly←1
         NS.Grid.Attributes←'Sample2'NS.changeAttributes A
         NS.Grid.Values←NS{'Sample'⍺.put('stats'≢⍵)/⍵}NS.get'Sample'
         A.Items←'f'
         NS.Grid.Attributes←'Sample'NS.changeAttributes A
         NS.Grid.Attributes←(SN,¨'2')NS.changeAttributes'T'
         NS.Grid.Values←(SN,¨'2')NS.put ⍬ ⍬ ⍬
     :EndSelect
 :Case 'Method1'
          ⍝:If 0=≢NS.get 'LbMethod'
     :If (⊂PARM)∊'percentile' 'quartile'
         NS.Grid.Values←'LbMethod'NS.put'--'
         NS.Grid.Attributes←'Method1'NS.changeAttributes'F'
     :EndIf
 :Else
     NS.Grid.Values←NS.rectifyStats NS.EventArg
     I←⍸NS.Grid.Names∊SN
     (I⌷¨⊂NS.Grid.Attributes).ReadOnly←~S1
     I←⍸NS.Grid.Names∊SN,¨'2'
     (I⌷¨⊂NS.Grid.Attributes).ReadOnly←~S2
 :EndSelect
      ⍝:IF PARM≡'percentile' ⋄ 2+ ⋄ :EndIf
 Z←NS
∇

 confIntGrid←{
               ⍝∊ Written by Steve Mansour 2019
               ⍝∇ Build a Grid Object for Hypothesis wizard
               ⍝⍵ Empty Namespace
               ⍝← Namespace containing the following:
               ⍝←  GridNames:   Cell name, e.g. 'Parameter' 'SampSize'
               ⍝←  GridValues:  Cell vallue, e.g. 'mean' 30
               ⍝←  GridTypes:   Cell type, e.g. 'Txt'  'Int'
               ⍝←  'mean' ← NS.get 'Parameter'
               ⍝←  GridValues ← 'SampSize' NS.put 30
     ⎕IO←0 ⋄ ⎕ML←3
     f←⊂∘toNestedVector
     ⍵.Grid←⎕NS''
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Values ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'ConfLevel,.80,.90,.95,.99'
     G,←f'Method,UnknownSigma, , , ,'
     G,←f'Parameter,mean, , , ,'
     G,←f'Operator,confInt,Sample Size,Mean,Std Dev'
     G,←f'Sample,stats,30,0,0'
     G,←f'--, , , , '
     I←⍸{↑↑⎕VFI ⍵}¨⊃G       ⍝ Find indices of numeric cells
     ⍵.Grid.Values←⍎¨@I⊃G    ⍝ Replace text with numerical values
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Names ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'       ,Level1,Level2,Level3,Level4'
     G,←f'LbMethod,Method1,Method2,Method3,Method4'
     G,←f'         ,Parameter'
     G,←f'        ,Operator,LbSampSize,LbMean,LbSdev'
     G,←f'LbSample,Sample,SampSize,Mean,Sdev'
     G,←f'LbSample2,Sample2,SampSize2  ,Mean2 ,Sdev2'
     ⍵.Grid.Names←⊃G
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Types ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
         ⍝ ⍵.Grid.Attributes←⎕NS¨5 5⍴⊂''
     ⍝     ⍵.Grid.Attributes.Type←⊃'TPPPP' 'TDTTT' 'TTTTT' 'TENFF' 'DTTTT'
     ⍵.Grid.Attributes←⎕NS¨6 5⍴⊂''
     ⍵.Grid.Attributes.Type←⊃'TPPPP' 'DDDDD' 'TDTTT' 'TTTTT' 'TENFF' 'DTTTT'
                ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Events ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.get←{1<≡⍵:∇¨⍵ ⋄ ⍺←Grid.Values ⋄ (⍸Grid.Names∊⊂⍵)⊃⍺}
     ⍵.put←{w←⊆⍣(80=⎕DR ⍵)⊢⍵ ⋄ (w@(⍸Grid.Names∊⊆⍺))Grid.Values}
     ⍵.rectifyStats←rectifyStats
               ⍝⍵.changeType←{(⍵@(⍸GridNames∊⊆⍺))GridTypes}
     ⍵.changeAttributes←changeAttributes
     ⍵}

 coordVenn←{
           ⍝∇ Coordinates for circles for Venn Diagram
           ⍝⍵ 0
           ⍝← S0 (Sample Space - Box around circles)
           ⍝← SA (Left crescent without AB)
           ⍝← SB (right crescent without AB)
           ⍝← SAB (intersection)
     ⎕ML←3 ⋄ ⎕IO←0                    ⍝ Set system variables
     T←(⍳361)×○÷180                   ⍝ Length of arc along circle
     A←1 2∘.○¯60↓60↓T
     B←⌽A ⋄ B[1;]←1-B[1;]
     C←1 2∘.○⌽120↑¯60⌽T
     D←⌽C ⋄ D[1;]←1-D[1;]
     close←{⍵⍪⍵[0;]}
     SA←close 225+200×⍉A,D
     SAB←close 225+200×241 2⍴⍉C,D
     SB←close 225+200×⍉B,C
     S0←close⍉(225+200×A),⍉(225+210×4 2⍴¯1 0.5 ¯1 ¯1 1 ¯1 1 0.5)
     S1←close⍉(225+200×B),⍉(225+210×4 2⍴1 0.5 1 2 ¯1 2 ¯1 0.5)
     (S0 S1)SA SB SAB
 }

∇ factorAPI NS;FLD;FF;⎕IO;⎕ML
 ⎕IO←0 ⋄ ⎕ML←3
 FLD←'LeftArg' 'Factor2' 'Factor3'
          ⍝ NS.Grid.Attributes←'Var'NS.changeAttributes
 NS.Grid.Attributes←FLD NS.changeAttributes'N'
 NS.Grid.Values←(FLD,'Lb'∘,¨FLD)NS.put' '
 FF←'Factor'∘,¨'123'
 NS.Grid.Values←('Lb'∘,¨FF)NS.put FF
 NS.Grid.Values←'LeftArg'NS.put 2
 NS.Grid.Values←FF NS.put' '
 NS.Table←⊃0 0⍴0
∇

∇ factorial2kAPI NS;FLD;FF;⎕IO;⎕ML
 ⎕IO←0 ⋄ ⎕ML←3
 FLD←'LeftArg' 'Factor3' 'Var'
 NS.ColTitles2←' '
 NS.Grid.Attributes←FLD NS.changeAttributes'ATT'
 NS.Grid.Values←(FLD,'Lb'∘,¨FLD)NS.put' '
 NS.Grid.Values←'LbLeftArg'NS.put'Alias (Optional)'
 NS.Grid.Values←'Var'NS.put'stats'
          ⍝ NS.Grid.Values←'LeftArg'NS.put'I'
 NS.Grid.Values←'LeftArg'NS.put''
 FF←'Factor1' 'Factor2'
 NS.Grid.Attributes←FF NS.changeAttributes'N'
 NS.Grid.Values←('Lb'∘,¨FF)NS.put'Factors (K)' 'Replicates'
 NS.Grid.Values←FF NS.put 3 1
 NS.Table←(⍪standardOrder'abc'),0
 NS.CellTypes←(⍴NS.Table)⍴'AX'
∇

∇ Z←getConfGrid NS;Sample;Sample2;⎕IO;⎕ML;US;RA;XEQ;LV;XP;H;K;Parm;METH;V
           ⍝∊ Written by Steve Mansour  2019
           ⍝⍵ Get expression from Hypothesis Grid
           ⍝⍵ Namespace with grid
 ⎕IO←0 ⋄ ⎕ML←3
 Parm←NS.get'Parameter'
 V←(⊂Parm)∊'var' 'variance' 'sdev'
 :If 'stats'≡NS.get'Sample'
     Sample←1⌽')(',1 1(Parm≢'proportion')1/NS.get'Sample' 'SampSize' 'Mean' 'Sdev'
     Sample[V/3]←0   ⍝ Placeholder for mean
 :Else
     Sample←1⌽')(',NS.get'Sample'
 :EndIf
 :If 'stats'≡NS.get'Sample2'
     Sample2←1⌽')(',1 1(Parm≢'proportion')1/NS.get'Sample2' 'SampSize2' 'Mean2' 'Sdev2'
     Sample2[V/3]←0
 :Else
     Sample2←{⍵∧.=' ':⍵ ⋄ 1⌽')(',⍵}NS.get'Sample2'
 :EndIf
 :Select NS.get'LbSample2'
 :Case ' - Sample2'
     RA←Sample Sample2
 :Case 'GroupBy'
     RA←Sample'groupBy'Sample2
 :Case 'splitBy'
     RA←Sample'splitBy'Sample2
 :Case 'groupBy'
     RA←Sample'groupBy'Sample2         ⍝ smm 3/29/2025
 :Else
     RA←Sample
 :EndSelect
 US←{2=⎕NC'⍵':⍎⍵ ⋄ ⍵}NS.UserSpace
 LV←NS.get'Level1' 'Level2' 'Level3' 'Level4'
 METH←{U←(⍵∨.≠¨' ')/⍵
     0=≢U:'' ⋄ 2>≡U:↑U
     (,1)≡↑X←⎕VFI⍕U:1⊃X     ⍝ smm 4/22/2025
     Q←''''
     1⌽Q,Q,↑{⍺,',',⍵}/U}NS.get'Method'∘,¨'1234'
     
     ⍝ K←US⍎⍕(0J1,LV~0)Parm'confInt'RA       ⍝ Generate NS output
 K←US⍎⍕(0J1,(-~×≢METH)↓(LV~0)METH)Parm'confInt'RA       ⍝ Generate NS output
 NS.ResultsLabels←¯1↓↓(1+K.Output[0;]⍳')')↑[1]K.Output
 'NS'⎕NS'K.Output' 'K.PointEstimate' 'K.Results'  ⍝ Copy results
     ⍝ XEQ←(LV~0)Parm'confInt show'RA
 XEQ←(LV~0)METH Parm'confInt show'RA
 NS.Expr←deleteExcessBlanks⍕XEQ        ⍝ Construct expression
 NS.ReturnCode←0
 Z←NS
∇

∇ Z←getHypoGrid NS;Sample;Sample2;⎕IO;⎕ML;US;xeq;H;Parm;P;V
           ⍝∊ Written by Steve Mansour  2019
           ⍝⍵ Get expression from Hypothesis Grid
           ⍝⍵ Namespace with grid
 ⎕IO←0 ⋄ ⎕ML←3
 Parm←NS.get'Parameter'
 V←(⊂Parm)∊'var' 'variance' 'sdev'
 :If 'stats'≡NS.get'Sample'
     Sample←1⌽')(',(-Parm≡'proportion')↓NS.get'Sample' 'SampSize' 'Mean' 'Sdev'
     Sample[V/3]←0  ⍝ Placeholder for mean
 :Else
     Sample←1⌽')(',NS.get'Sample'
 :EndIf
 :If 'stats'≡NS.get'Sample2'
     Sample2←(-Parm≡'proportion')↓NS.get'Sample2' 'SampSize2' 'Mean2' 'Sdev2'
     Sample2[V/2]←0  ⍝ Placeholder for mean
 :ElseIf 'splitBy'≡NS.get'LbSample2'
     Sample2←Sample,NS.get'LbSample2' 'Sample2'
     Sample←' '
 :Else
     Sample2←NS.get'Sample2'
 :EndIf
 xeq←Sample Parm'hypothesis'(NS.get'Relation')Sample2
          ⍝ :If 'mean eqVar'≡1⊃xeq ⋄ xeq[1 3]←'mean'('/',⍨3⊃xeq) ⋄ :EndIf
 :If 'mean eqVar'≡1⊃xeq ⋄ xeq←'mean'(xeq[2 3 0]),'(',xeq[4]')' ⋄ :EndIf
 US←{2=⎕NC'⍵':⍎⍵ ⋄ ⍵}NS.UserSpace
 NS.Expr←deleteExcessBlanks⍕(NS.get'Significance')'report'xeq
 NS.ReturnCode←1
 H←US{0::0 ⋄ ⍺⍎⍵}⍕xeq
 :If 2=⎕NC'H' ⋄ NS.Output←'Error' ⋄ :Else
     NS.Output←US⍎NS.Expr ⋄ :EndIf
 'NS'⎕NS↓'H','.',H.⎕NL 2
 NS.SampleSize←NS.get'SampSize'
 NS.ReturnCode←0
 NS.(Conclusion←P<get'Significance')
 Z←NS
∇

∇ Z←hypothesisAPI NS;V;I;LB;S1;S2;PA;LB;LN;SN;H;H0;TY;L2;_;⎕IO;⎕ML;Items;FMT;A
               ⍝∇ ns-based API for Hypothesis - Last updated 6/25
               ⍝⍵ NS Namespace containing the following variables
               ⍝⍵  NS.Event   'Init' 'Select' or 'Run'
               ⍝⍵  NS.UserSpace
               ⍝←  NS.Grid  Contains Names, Values and Attributes
               ⍝←  NS.Output  Character Matrix
 ⎕IO←0 ⋄ ⎕ML←3
 :Select NS.Event
 :Case 'Init'
     NS.⎕ML←3 ⋄ NS.⎕IO←0     ⍝ Initialize settings
     NS←hypothesisGrid NS    ⍝ Build grid
     NS←hypothesisAttr NS    ⍝ Assign attributes
     NS.ReturnCode←0
 :Case 'Select'
     NS←hypothesisChange NS  ⍝ Change a cell in the grid (Uses NS.EventArg)
 :Case 'Run'
     NS←getHypoGrid NS       ⍝ Run hypothesis operator and display output
 :Case ''                    ⍝ If empty,no-op
 :Else
     NS.Grid.Values←NS.rectifyStats NS.Event
 :EndSelect
 Z←NS
∇

 hypothesisAttr←{
           ⍝ Assign attributes to hypothesis fields
     NS←⍵
     A←⎕NS''
               ⍝A.Items←'mean' 'proportion' 'var' 'sdev' 'median'
     A.Items←'mean' 'proportion' 'var' 'sdev' 'median' 'mean paired' 'mean eqVar' 'median paired'
     NS.Grid.Attributes←'Parameter'NS.changeAttributes A
     A.Items←'Hypothesized Value' 'Sample 2' 'splitBy'
     NS.Grid.Attributes←'LbSample2'NS.changeAttributes A
     A.Items←'F' ⋄ A.TopItem←'stats' ⍝ Numeric field (Floating Point)
     NS.Grid.Attributes←'Sample'NS.changeAttributes A
     A.Items←,¨'<≤=≠≥>' ⋄ A.TopItem←''
     NS.Grid.Attributes←'Relation'NS.changeAttributes A
     A←⎕NS''
     A.validate←{(⍵=⌊⍵)∧⍵>0}
     A.ErrorMsg←'Must be a postive integer'
     A.FormatString←'I6'
     NS.Grid.Attributes←'SampSize' 'SampSize2'NS.changeAttributes A
     A.validate←{⍵≥0}
     A.ErrorMsg←'Negative values not permitted.'
     A.FormatString←'F9.5'     ⍝ Set format String
     A.Decimals←5              ⍝ Free format
     NS.Grid.Attributes←'Sdev' 'Sdev2'NS.changeAttributes A
     A.validate←{1}
     A.FormatString←'F12.5'
     NS.Grid.Attributes←'Mean' 'Mean2'NS.changeAttributes A
     A.validate←{0=+/×⍵-0 1}  ⍝ Boolean
     A.ErrorMsg←'Must be between 0 and 100%'
     A.Decimals←2
     NS.Grid.Attributes←'Significance'NS.changeAttributes A
     NS
 }

∇ Z←hypothesisChange NS;H;I;LB;LN;A;SN;PA;P;H0;TY;S1;S2;L2;FMT;U
           ⍝ Change to hypothesis Grid
 PA←NS.get'Parameter'                         ⍝ Get parameter
 H0←0.5×PA≡'proportion'                       ⍝ Get null hypothesis
 L2←NS.get'LbSample2'                         ⍝ Get Label2
 LN←'Lb'∘,¨SN←'SampSize' 'Mean' 'Sdev'
 :If ('Sample 2'≡L2)∧0=↑0⍴NS.get'Sample2'
     NS.Grid.Values←'Sample2'NS.put'stats' ⋄ :EndIf
 S1 S2←(NS.get¨'Sample' 'Sample2')∊⊂'stats'   ⍝ stats selected?
 :If L2≡'splitBy'
             ⍝  NS.Grid.Attributes←'Sample2'NS.changeAttributes'D' ⍝
     A←⎕NS'' ⋄ A.Type←'E' ⋄ A.Items←'b' ⋄ A.TopItem←''
     NS.Grid.Attributes←'Sample2'NS.changeAttributes A
 :EndIf
 A←⎕NS''
 :Select NS.EventArg
 :Case 'Parameter'
     LB←'Sample Size' 'Mean' 'Std Dev'                 ⍝ Label Values
     LN←'Lb'∘,¨SN←'SampSize' 'Mean' 'Sdev'             ⍝ Label Names
     :Select PA←NS.get'Parameter'
     :CaseList 'mean' 'mean paired' 'mean eqVar' ⋄ TY←'NFF'
         FMT←'I6' 'M<->F10.3' 'F7.3'
         A.Type←'E' ⋄ A.Items←'F'
     :Case 'proportion' ⋄
         LB[1 2]←'Proportion' 'Events'
         TY←'NPN'
         FMT←'I6' 'Q<%>K2F9.3' 'I6'
         A.Type←'E' ⋄ A.Items←'b'
     :CaseList 'var' 'variance' 'sdev'                      ⍝ Relabel to appropriate parameter
         LB[1]←⊂'Variance' ⋄ TY←'NFF'
         FMT←'I6' 'F9.3' 'F9.3'
         A.Type←'E' ⋄ A.Items←'F'
     :CaseList 'median' 'median paired'
         LB[1 2]←'Below' 'Above'
         FMT←'I6' 'I6' 'I6'
         TY←'NNN'
         A.Type←'E' ⋄ A.Items←'F'
     :EndSelect
     NS.Grid.Values←LN NS.put LB                            ⍝ Display labels for Sample1?
     NS.Grid.Values←(LN,¨'2')NS.put(L2≡'Sample 2')/¨LB      ⍝ Display labels for Sample2?
     NS.Grid.Attributes←SN NS.changeAttributes TY           ⍝ Change cell types for Sample1 statitics
     NS.Grid.Attributes←(SN,¨'2')NS.changeAttributes TY     ⍝ Change cell types for sample2 statistics
     NS.Grid.Values←NS.rectifyStats'Sample'
     NS.Grid.Attributes←'Sample'NS.changeAttributes A
     :If L2≡'Sample 2'
         NS.Grid.Attributes←'Sample2'NS.changeAttributes A
     :EndIf
 :Case 'LbSample2'
     NS.Grid.Values←'LbSample'NS.put'Sample',(L2≡'Sample 2')/' 1' ⍝ Sample or Sample 1?
     A←⎕NS'' ⋄ I←⍸NS.Grid.Names∊SN,¨'2'
     :Select L2
     :Case 'Hypothesized Value'
         :If 0≠↑0⍴NS.get'Sample2'
             NS.Grid.Values←'Sample2'NS.put H0 ⋄ :EndIf
                  ⍝ NS.Grid.Attributes←(SN,¨'2')NS.changeAttributes'T'
         (I⌷¨⊂NS.Grid.Attributes).ReadOnly←1
         NS.Grid.Values←(SN,¨'2')NS.put ⍬ ⍬ ⍬
         A.Type←'F'
         NS.Grid.Values←('Lb'∘,¨SN,¨'2')NS.put' '
     :Case 'Sample 2'
         NS.Grid.Values←NS.rectifyStats'Sample2'
         P←PA≡'proportion'
         TY←P⊃'NFF' 'NPN'
         NS.Grid.Attributes←(SN,¨'2')NS.changeAttributes TY
         NS.Grid.Values←'Sample2'NS.put'stats'
         NS.Grid.Values←('Lb'∘,¨SN,¨'2')NS.put NS.get'Lb'∘,¨SN
         (I⌷¨⊂NS.Grid.Attributes).ReadOnly←0
         A.Type←'E' ⋄ A.Items←P⊃'Fb' ⋄ A.TopItem←'stats'
         NS.Grid.Attributes←'Sample'NS.changeAttributes A
     :Case 'splitBy'
         A.Type←'E' ⋄ A.Items←'b' ⋄ A.TopItem←''
         NS.Grid.Attributes←(SN,¨'2')NS.changeAttributes'T'
         (I⌷¨⊂NS.Grid.Attributes).ReadOnly←1
         NS.Grid.Values←(SN,¨'2')NS.put ⍬ ⍬ ⍬
         NS.Grid.Values←'Sample2'NS.put''
     :EndSelect
     NS.Grid.Attributes←'Sample2'NS.changeAttributes A
 :Else          ⍝ 'SampleSize' 'Mean' 'Stdev'
     NS.Grid.Values←NS.rectifyStats NS.EventArg
     I←⍸NS.Grid.Names∊SN
     (I⌷¨⊂NS.Grid.Attributes).ReadOnly←~S1
     I←⍸NS.Grid.Names∊SN,¨'2'
     (I⌷¨⊂NS.Grid.Attributes).ReadOnly←~S2
 :EndSelect
 Z←NS
∇

 hypothesisGrid←{
               ⍝∊ Written by Steve Mansour 2019
               ⍝∇ Build a Grid Object for Hypothesis wizard
               ⍝⍵ Empty Namespace
               ⍝← Namespace containing the following:
               ⍝←  Grid.Names:   Cell name, e.g. 'Parameter' 'SampSize'
               ⍝←  Grid.Values:  Cell vallue, e.g. 'mean' 30
               ⍝←  Grid.Attributes:   Cell type, e.g. 'Txt'  'Int'
               ⍝←  'mean' ← NS.get 'Parameter'
               ⍝←  GridValues ← 'SampSize' NS.put 30
     ⎕IO←0 ⋄ ⎕ML←3
     f←⊂∘toNestedVector
     ⍵.Grid←⎕NS''
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Values ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'Significance,0.05,SampleSize,Mean,Std Dev'
     G,←f'Sample         ,stats,30,0,0'
     G,←f'Summary Function,mean, ,hypothesis, '
     G,←f'Relation,=, , , '
     G,←f'Hypothesized Value,0, , , '
     I←⍸{↑↑⎕VFI ⍵}¨⊃G        ⍝ Find indices of numeric cells
     ⍵.Grid.Values←⍎¨@I⊃G     ⍝ Replace text with numerical values
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Names ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'          ,Significance,LbSampSize ,LbMean,LbSdev'
     G,←f'LbSample ,Sample      ,SampSize   ,Mean  ,Sdev'
     G,←f'         ,Parameter,   Modifier   ,Operator'
     G,←f'         ,Relation    ,LbSampSize2,LbMean2,LbSdev2'
     G,←f'LbSample2,Sample2     ,SampSize2  ,Mean2 ,Sdev2'
     ⍵.Grid.Names←⊃G
                ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Attributes ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.Grid.Attributes←⎕NS¨5 5⍴⊂''
     ⍵.Grid.Attributes.Type←⊃'TPTTT' 'TENFF' 'TDTTT' 'TDTTT' 'DFTTT'
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Events ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.get←{1<≡⍵:∇¨⍵ ⋄ ⍺←Grid.Values ⋄ (⍸Grid.Names∊⊂⍵)⊃⍺}
     ⍵.put←{w←⊆⍣(80=⎕DR ⍵)⊢⍵ ⋄ (w@(⍸Grid.Names∊⊆⍺))Grid.Values}
     ⍵.rectifyStats←rectifyStats
     ⍵.changeAttributes←changeAttributes
     ⍵}

∇ latinSquareAPI NS;FLD;P;⎕ML;⎕IO
 ⎕ML←3 ⋄ ⎕IO←0
 FLD←'LeftArg' 'Factor2' 'Factor3'
 NS.Grid.Attributes←FLD NS.changeAttributes'T'
 NS.Grid.Values←(FLD,'Lb'∘,¨FLD)NS.put' '
 FLD←'Factor1'
 NS.Grid.Attributes←FLD NS.changeAttributes'N'
 NS.Grid.Values←FLD NS.put P←3
 NS.Grid.Values←'LbFactor1'NS.put'Treatments'
          ⍝ NS.Table←,[1 2]⍉⊃((⍳P)⌽P P⍴P↑⎕A)(⊂⍬)
 NS.Table←,[1 2]⍉⊃((⍳P)⌽P P⍴P↑⎕A)0
 NS.CellTypes←(⍴NS.Table)⍴'AX'
∇

∇ Z←NA makeVenn NS;fL;BB;Conj;AB;ME;TXT;LT;Mon;I;YX;PCT;⎕ML;⎕IO
           ⍝⍟ Copyright (C) 2020 by Stephen M. Mansour
           ⍝∇ Build Venn Diagram for Probability Wizard
 ⎕ML←3 ⋄ ⎕IO←0                                   ⍝ Set system variables
 fL←⍎{∧/⍵∊'01':'{',⍵,'}¨' ⋄ I←'∩∪~|'⍳↑⍵          ⍝ Logical function
     (I>3)∨2=≢⍵:⍵ ⋄ '∧∨>∧'[I]}Conj←,NS.get'Conj'
 BB←0 1 0 1 fL 0 0 1 1   ⍝ 0, A, B, AB           ⍝ Apply
 :If '|'=↑Conj ⋄ BB←¯1 ¯1 0 1 ⋄ :EndIf           ⍝ Conditional Prob
 AB←NS.get'SetA' 'SetB'                          ⍝ Get Sets
 :If 'independent'≡NS.get'RtOp' ⋄ AB←'AB' ⋄ ME←0
           ⍝:ElseIf 0=≢(↑AB)~' ' ⋄ ME←0
 :ElseIf '[None]'≡↑AB ⋄ ME←0
 :Else
     ME←{0∊⍵:1 ⋄ 0=⍵⌷NS.Table}+⌿⊃⍸NS.Table∊,¨AB  ⍝ Mutually Exclusive?
     BB[3]>←ME ⋄ :EndIf                          ⍝ Grey out A∩B?
 :If 0=↑↑0⍴AB ⋄ AB←,¨'AB' ⋄ :EndIf
 TXT←ME{⍺:'  X  ' ⋄ Z←↑{⍺,'∩',⍵}/⍵ ⋄ 6>≢Z:Z
     ⊃'⌹'(≠⊂⊢)('∩'⎕R'⌹ ∩ ⌹')Z}AB
 NS.Venn←BB,⍪' ',AB,⊂TXT
 LT←LogicTable
 Mon←NA≡NS.get'SetA'
 I←↑LT[;⍳2](⍳⍥↓),¨(Mon⊃'DM')Conj
 :If I≥≢LT ⋄ I←LT[;1]⍳⊂,Conj ⋄ :EndIf
 TXT←⊂⍕LT[I;1 2]
 TXT,←⊂('∆'⎕R(⍕0⊃AB))('B'⎕R(⍕1⊃AB))('A'⎕R'∆')↑LT[I;3]
 TXT,←⊂'Complement'
 TXT←(⌈/≢¨TXT)↑¨TXT                              ⍝ Make widths the same
 YX←coordVenn 0                                  ⍝ Generate circle coordinates
 :If Mon                                         ⍝ If Monadic, suppress SetA
     NS.Venn←(2 2⊤'0⊢~1'⍳↑Conj),⍪' ',AB[1]
     NS.Venn,←((↑YX),YX[1])(2↓YX)                ⍝ Append to Venn
 :Else ⋄ NS.Venn,←YX ⋄ :EndIf
 AB←AB[0],',',AB[1]
 :If ME ⋄ TXT,←⊂⍕AB,' Mutually Exclusive'
 :ElseIf 'independent'≡NS.get'RtOp'
     TXT,←⊂⍕AB,' Independent' ⋄ :EndIf
 PCT←↓{'K2Q<%>F10.2'⎕FMT ⍵,1-⍵}NS.Result
 NS.VennText←TXT,¨(⍴TXT)↑' ',PCT
 :If '|'≡↑NS.get'Conj'                           ⍝ Blank out coordinates for sample
     NS.Venn[0;2]←⊂2⍴⊂1 2⍴0                      ⍝ space if conditional
 :EndIf
 :If 5<⌈/{↑⍴⍉⍵}¨NS.Venn[;1] ⋄ :AndIf 4≤≢NS.Venn  ⍝ If long names
     NS.VennText,←'A: ' 'B: ',¨NS.Venn[1 2;1]    ⍝ Remove from graph and put
     NS.Venn[1 2 3;1]←'A' 'B',ME⌷'A∩B' ' X '     ⍝ into supporting text.
 :EndIf
 Z←NS
∇

∇ oneWayAPI NS;FLD;⎕IO;⎕ML;A
 ⎕IO←0 ⋄ ⎕ML←3
 FLD←'LeftArg' 'Factor2' 'Factor3'
 NS.ColTitles2←'Group' 'N' 'Mean' 'Std Dev'
 NS.Grid.Attributes←FLD NS.changeAttributes'T'
 NS.Grid.Values←(FLD,'Lb'∘,¨FLD)NS.put' '
 NS.Grid.Values←'LbFactor1' 'Factor1'NS.put'Treatments' 3
 NS.Table←⊃{(,⍵)5,2⍴0}¨'ABC'
 NS.CellTypes←3 4⍴'ANXF'
∇

∇ Z←{C}populateData NS;B;DD;D;K;P;V;⎕IO;⎕ML;A;normProbs
           ⍝Written by Steve Mansour 7/25/2019
           ⍝ Populate field  C is number of bins
 ⎕IO←0 ⋄ ⎕ML←3
 :If 'goodnessOfFit'≡NS.get'Op'
     V←NS.get'Var'
     :If 'frequency'≢V    ⍝ Not frequency
         D←NS.UserSpace⍎V
         DD←C frequency D
         B←0=↑0⍴↑DD       ⍝ Numeric dataset?
         K←≢DD
         :Select NS.get'Dist'
         :Case 'uniform'
             P←K/÷K
             NS.ColTypes←'TTT'
         :Case 'multinomial'
                      ⍝ P←K↑NS.Table[;2]
             P←K/÷K
             NS.ColTypes←'TTQ'
         :Case 'normal'
             P←NS.normProbs K
             NS.ColTypes←'TTT'
         :Case 'poisson'
             P←5 poisson⍳K
         :EndSelect
         NS.Table←DD,P
         NS.Grid.Values←'Cols'NS.put K
         NS.Grid.Values←'VarType'NS.put B⊃'Char' 'Num'
         NS.Grid.Attributes.Type←'Cols' 'VarType'NS.changeType B⊃'T' 'NT'
     :Else                             ⍝Frequency
         NS.Grid.Attributes.Type←'Cols'NS.changeType'N'
         A←⎕NS'' ⋄ A.Type←'D' ⋄ A.Items←'Char' 'Num'
         NS.Grid.Attributes←'VarType'NS.changeAttributes A
         K←≢NS.Table
         :Select NS.get'Dist'
         :Case 'uniform' ⋄ P←K/÷K ⋄⍝ NS.ColTypes←'ANT'
         :Case 'multinomial' ⋄ P←NS.Table[;2] ⋄ ⍝ NS.ColTypes←'ANQ'
         :Case 'normal' ⋄ P←NS.normProbs K ⋄ NS.ColTypes←'XNT' ⋄ NS.Table[;0]←⍳≢NS.Table
         :Case 'poisson' ⋄ P←5 poisson⍳K ⋄ NS.ColTypes←'XNT' ⋄ NS.Table[;0]←⍳≢NS.Table
         :EndSelect
         NS.Table[;2]←P
     :EndIf
 :Else     ⍝ independent
     NS.Grid.Values←'VarType'NS.put'Char'
     NS.Grid.Attributes.Type←'VarType'NS.changeType'T'
     B←2⊥(⊂'frequency')≡¨NS.get'Dist' 'Var'
     :Select B
     :Case 0  ⍝ Two Variables
         NS.Grid.Attributes.Type←'Rows' 'Cols'NS.changeType'T'
         NS.Table←frequency NS.UserSpace⍎⍕NS.get'Dist' 'Var'
         NS.Grid.Values←'Rows' 'Cols'NS.put ¯1+⍴NS.Table
         NS.CellTypes←(⍴NS.Table)⍴'T'
     :Case 1
         NS.Grid.Values←'Rows'NS.put{¯1+≢⍵}⍴NS.Table
         K←≢frequency NS.UserSpace⍎⍕NS.get'Dist'
         NS.Grid.Values←'Rows'NS.put K
     :Case 2
         NS.Grid.Attributes.Type←'Cols'NS.changeType'T'
         K←≢frequency NS.UserSpace⍎⍕NS.get'Var'
         NS.Grid.Values←'Cols'NS.put K
     :Case 3
         NS.Grid.Attributes.Type←'Rows' 'Cols'NS.changeType'N'
         NS.CellTypes←'A','A'⍪(¯1+⍴NS.Table)⍴'I'
     :EndSelect
     NS.CellTypes←'A','A'⍪(¯1+⍴NS.Table)⍴'I'
 :EndIf
 Z←NS
∇

∇ Z←probabilityAPI NS;A;B;C;D;H;I;J;K;R;V;W;N;X;TY;RO;NA;f;Expr;LT;P;q;Sets;Conj;⎕IO;⎕ML
               ⍝∇ ns-based API for Probabiltiy - Last updated 9/22/2020
               ⍝⍵ NS Namespace containing the following variables
               ⍝⍵   Event 'Init'
               ⍝⍵   Event 'Select'  : Select parameter, Sample or Sample2
               ⍝⍵   Event 'Run'  Signficance Data Parameter Relational HypothesizedValue
               ⍝← Z  Namespace containing modifications
 ⎕IO←0 ⋄ ⎕ML←3 ⋄ NA←'[None]'
 :Select NS.Event
 :Case 'Init'                               ⍝ Initialize
     NS←probabilityGrid NS                  ⍝ Build grid
     NS←NA probabilityAttr NS                  ⍝ Set attributes
     NS.Table←('*','A',¨'12'),('B',¨'123')⍪2 3⍴0     ⍝ Default table
     NS.UserSpace←#
     NS.CellTypes←'TAA','A'⍪2 3⍴'X'
     NS.ReturnCode←0
 :Case 'Select'
     :Select NS.EventArg
     :Case 'Rows'
         NS.Table←(NS.get'Rows')0 resizeTable NS.Table
         NS.CellTypes←'A','A'⍪(¯1+⍴NS.Table)⍴'I'
     :Case 'Cols'                           ⍝
         NS.Table←0(NS.get'Cols')resizeTable NS.Table
         NS.CellTypes←'A','A'⍪(¯1+⍴NS.Table)⍴'I'
     :CaseList 'RowVar' 'ColVar' 'Var'
         V←(NS.get'RowVar' 'ColVar')~⊂'frequency'  ⍝ Get Row/Col Vars
         :If 0≠≢V ⋄ NS.Table←frequency NS.UserSpace⍎⍕V
             NS.Table[;0]←⍕¨NS.Table[;0]
             NS.CellTypes←(⍴NS.Table)⍴'T'
             NS.Grid.Attributes←'Rows' 'Cols'NS.changeAttributes'T'
     
             :If '*'≡↑↑NS.Table
                 NS.Table[0;]←⍕¨NS.Table[0;]
                 NS.(Grid.Values←'Rows' 'Cols'put ¯1+⍴Table)
             :Else ⋄ NS.(Grid.Values←'Rows'put≢Table) ⋄ :EndIf
         :Else ⋄
             :If NS.EventArg≢'Var'   ⍝ Reset?
                 NS.Table←('*','A',¨'12'),('B',¨'123')⍪2 3⍴0     ⍝ Default table
                 NS.CellTypes←'A','A'⍪(¯1+⍴NS.Table)⍴'N'
                 NS.(Grid.Values←'Rows' 'Cols'put 2 3)
                 NS.Grid.Attributes←'Rows' 'Cols'NS.changeAttributes'N'
             :EndIf
         :EndIf
         A←NS.(Grid.Attributes∘get¨'SetA' 'SetB')
         :If '*'≡↑↑NS.Table
             NS.Grid.Values←'SetA' 'SetB'NS.put NS.Table[(1 0)(0 1)]
             A.Items←⊂NS.Table[;0],⍥(1∘↓)NS.Table[0;]
         :Else
                      ⍝ NS.(Grid.Values←'SetA' 'SetB'put' ',⊂↑Table)
             NS.Grid.Values←'SetA' 'SetB'NS.put' ',⊂↑NS.Table
             A.Items←⊂NS.Table[;0]
         :EndIf
         NS.Grid.Attributes←'SetA'NS.changeAttributes↑A
         NS.Grid.Attributes←'SetB'NS.changeAttributes 1⊃A
     :CaseList 'Conj' 'DescConj'
         J←'Conj'≢NS.EventArg
         Conj←NS.(get EventArg)
         V←,(NA≡NS.get'SetA')⊃'DM'    ⍝ Valence
         K←,V{1=≢⍵:⍵                             ⍝ Look up in conjunction
             (⍵[;0]∊⊂,⍺)⌿⍵}(LogicTable[;J+1]∊⊂,Conj)⌿LogicTable   ⍝ Database
         NS.Grid.Values←'Conj' 'DescConj'NS.put K[1 2]
         :If ∧/('D'=↑K),NA≡NS.get'SetA'
             NS.Grid.Values←'SetA'NS.put↑NS.Table[1;0] ⋄ :EndIf
     :CaseList 'SetA' 'SetB'
         A←⎕NS''
         :If '*'≡↑↑NS.Table
             A.Items←⍕¨↑,/{1↓,1↑⍵}¨(⍉{⍺ ⍵}⊢)NS.Table
         :Else
             A.Items←⍕¨NS.Table[;0]
         :EndIf
         NS.Grid.Attributes←NS.EventArg NS.changeAttributes A
         A←⎕NS''
         LT←NS{⍵⌿⍨⍵[;0]∊⊂,(NA≡⍺.get'SetA')⊃'DM'}LogicTable
         A.Items←LT[;1]
         NS.Grid.Attributes←'Conj'NS.changeAttributes A
         A.Items←LT[;2]
         NS.Grid.Attributes←'DescConj'NS.changeAttributes A
         :If ~(,NS.get'Conj')∊LT[;1]
             NS.Grid.Values←'Conj' 'DescConj'NS.put LT[0;1 2]
         :EndIf
     :Case 'RtOp'
         TY←('independent'≡NS.get'RtOp')⊃'DP'
         NS.Grid.Attributes←'SetA' 'SetB'NS.changeAttributes TY
         NS.Grid.Values←'SetA'NS.put(TY='D')⊃0.5,⊂'A'
         NS.Grid.Values←'SetB'NS.put(TY='D')⊃0.5,⊂'B'
         A←⎕NS''
         :If TY='P'
             NS.Grid.Values←'Rows' 'Cols'NS.put 2
             NS.Table←3 3⍴'*' 'B' '~B' 'A' 0.25 0.25 '~A' 0.25 0.25
         :Else
             A←⎕NS''
             A.Items←,¨'AB','~A' '~B'
             NS.Grid.Values←'SetA' 'SetB'NS.put,¨'AB'
             NS.Grid.Attributes←'SetB'NS.changeAttributes A
             A.Items←' ',A.Items
             NS.Grid.Attributes←'SetA'NS.changeAttributes A
         :EndIf
     :EndSelect
 :Case 'Run'
     q←{(0=↑0⍴⍵)∨⍵∧.=' ':⍵ ⋄ '''',(⍕⍵),''''}
     Sets←NS.get'SetA' 'SetB'
     Conj←{2=≢⍵:1⌽')(',⍵ ⋄ ⍵}NS.get'Conj'
     RO←q{D←⍵.get'RtOp' ⋄ D≢'Table':D
         RC←⍵.get'RowVar' 'ColVar'
         B←~RC∊⊂'frequency'
         ∨/B:⍕B/RC
         1⌽')(',⍕(⍴⍵.Table)'⍴',,⍺⍺¨⍵.Table}NS
               ⍝:If RO≢'independent'
          ⍝         Sets←quoteSets¨Sets
          ⍝     :EndIf
     Sets←RO∘(NS quoteSets)¨Sets
              ⍝Expr←⍕(q 0⊃Sets),'(',Conj,' probability ',RO,')',q 1⊃Sets
     Expr←⍕({⍵/⍨⍵≢NA}0⊃Sets),'(',Conj,' probability ',RO,')',1⊃Sets
     P←NS.UserSpace⍎Expr
     NS.Expr←Expr
     NS.Result←P
     :If 'independent'≡NS.get'RtOp'
         NS.Table[1 2;1 2]←↑{⍺(1-⍺)∘.×⍵,1-⍵}/Sets
     :EndIf
     NS.Table←,¨@{0=80|⎕DR¨⍵}NS.Table
     NS←NA makeVenn NS ⍝ Venn Diagram Events, Labels, Text
 :Case ''           ⍝ If empty,no-op
 :Else
 :EndSelect
 Z←NS
∇

 probabilityAttr←{
           ⍝ Assign attributes to hypothesis fields
           ⍝⍺ Left argument is [None]
           ⍝⍵ Namespace
     NS←⍵
     A←⎕NS''
     LT←{⍵⌿⍨⍵[;0]∊⊂,'D'}LogicTable
     A.Items←LT[;1]
     NS.Grid.Attributes←'Conj'NS.changeAttributes A
     A←⎕NS''
     A.Items←LT[;2]
     NS.Grid.Attributes←'DescConj'NS.changeAttributes A
     A←⎕NS'' ⋄ A.Items←'A' ⋄ A.TopItem←'frequency'
     NS.Grid.Attributes←'RowVar'NS.changeAttributes A
     A←⎕NS'' ⋄ A.Items←'A' ⋄ A.TopItem←'frequency'
     NS.Grid.Attributes←'ColVar'NS.changeAttributes A
     A←⎕NS'' ⋄ A.Items←'A1' 'A2' 'B1' 'B2' 'B3'
     NS.Grid.Attributes←'SetB'NS.changeAttributes A
     A.TopItem←⍺
     NS.Grid.Attributes←'SetA'NS.changeAttributes A
     A←⎕NS'' ⋄ A.validate←{(⍵=⌊⍵)∧⍵>0}
     A.ErrorMsg←'Must be a postive integer'
     A.FormatString←'I6'
     NS.Grid.Attributes←'Rows'NS.changeAttributes A
     A.ErrorMsg←'Must be a postive integer'
     A.FormatString←'I6'
     NS.Grid.Attributes←'Cols'NS.changeAttributes A
     A←⎕NS''
     A.Items←'Table' 'independent'
     NS.Grid.Attributes←'RtOp'NS.changeAttributes A
     NS}

 probabilityGrid←{
               ⍝∊ Written by Steve Mansour 2020
               ⍝∇ Build a Grid Object for Probability wizard
               ⍝⍵ Empty Namespace
               ⍝← Namespace containing the following:
               ⍝←  Grid.Names:   Cell name, e.g. 'Parameter' 'SampSize'
               ⍝←  Grid.Values:  Cell vallue, e.g. 'mean' 30
               ⍝←  Grid.Types:   Cell type, e.g. 'Txt'  'Int'
               ⍝←  'mean' ← NS.get 'Parameter'
               ⍝←  Grid.Values ← 'SampSize' NS.put 30
     ⎕IO←0 ⋄ ⎕ML←3
     ⍵.Grid←⎕NS''
     f←⊂∘toNestedVector
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Values ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'Rows,frequency,2'
     G,←f'Columns,frequency,3'
     G,←f'Set A,A1,(Optional)'
     G,←f'Conjunction,∧,and'
     G,←f'Operator,probability'
     G,←f'Right Operand,Table'
     G,←f'Set B,B1'
     I←⍸{↑↑⎕VFI ⍵}¨⊃G         ⍝ Find indices of numeric cells
     ⍵.Grid.Values←⍎¨@I⊃G     ⍝ Replace text with numerical values
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Names ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'LbRows,RowVar,Rows'
     G,←f'LbCols,ColVar,Cols'
     G,←f'LbSetA,SetA,DescA'
     G,←f'LbConj,Conj,DescConj'
     G,←f'LbOp,Op,DescOp'
     G,←f'LbRtOp,RtOp,DescRtOp'
     G,←f'LbSetB,SetB,DescB'
     ⍵.Grid.Names←⊃G
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Types ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.Grid.Attributes←⎕NS¨7 3⍴⊂''
     G←'TEN' 'TEN' 'TDT' 'TDD' 'TTT' 'TDT' 'TDT'
     ⍵.Grid.Attributes.Type←⊃G
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Events ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.get←{1<≡⍵:∇¨⍵ ⋄ ⍺←Grid.Values ⋄ (⍸Grid.Names∊⊂⍵)⊃⍺}
     ⍵.put←{w←⊆⍣(0=80|⎕DR ⍵)⊢⍵ ⋄ (w@(⍸Grid.Names∊⊆⍺))Grid.Values}
     ⍵.changeType←{(⍵@(⍸Grid.Names∊⊆⍺))Grid.Attributes.Type}
     ⍵.changeAttributes←changeAttributes
     ⍵}

 rectifyStats←{
           ⍝∊ Written by Steve Mansour 2020
           ⍝∇ Rectify Statistics by synching up
           ⍝     Proportion and Events with SampleSize
           ⍝     or Variance with Sdev
           ⍝⍺ Value
           ⍝⍵ Variable Name:   'Sample' 'Mean' 'Var' 'Sdev' 'Sample2' 'Mean2' 'Var2' 'Sdev2'
           ⍝← GridValues updated
           ⍝  Grid.Values ←  45  NS.rectifyStats 'Mean'
           ⍝  Grid.Values ←  'D.Height' NS.rectifyStats 'Sample'
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⎕DIV←1                     ⍝
     ⍺←get ⍵                                    ⍝ If not specified,   use value in grid
     S←('2'=↑⌽⍵)/'2'                            ⍝ Append 2 if Sample 2
     (⍵≡'Sample2')∧~∨/'Sample'⍷get'LbSample2':Grid.Values ⍝If 2nd item is not Sample 2, get out
              ⍝N Q X←↑∘get¨C←'SampSize' 'Mean' 'Sdev',¨⊂S   ⍝ Get Statistics
     C←'SampSize' 'Mean' 'Sdev',¨⊂S             ⍝ Get Statistics
     N Q X←{0::0 ⋄ ⍎⍕get ⍵}¨C
     f←{0::30/0 ⋄ K←UserSpace⍎⍵ ⋄ 0≡↑0⍴K:K ⋄ 30/0} ⍝
          ⍝⍝⍝ Mean ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
               ⍝M←'mean'≡P←get'Parameter'                  ⍝
     M←∨/'mean'⍷P←get'Parameter'                  ⍝
     M∧⍵≡'Sample',S:C put(count,mean,sdev)f ⍺    ⍝ If Sample put in all 3 stats
     M:Grid.Values                               ⍝ If mean don't need to rectify
           ⍝⍝⍝ Proportion ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     B←P≡'proportion'                           ⍝ Proportion
     B∧(⍵≡'Sample',S):C put(count,mean,sum)f ⍺  ⍝ If sample put in all 3 stats
     B∧(⍵≡'Mean',S)∨X=0:('Sdev',S)put⌊0.5+N×Q   ⍝ Update Events
     B:('Mean',S)put X÷N                        ⍝ Update proportion
           ⍝⍝⍝ Median ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
             ⍝  M←'median'≡P                               ⍝ If median
     M←∨/'median'⍷P←get'Parameter'
     M0←get'Sample2'
     M0←⍺{0::0 ⋄ 0=↑0⍴⍺:⍵ ⋄ median #⍎get'Sample'}M0
     g←M0∘{+/¯1 1∘.=×⍺-⍵}
     M∧⍵≡'Sample',S:C put(count,g)f ⍺           ⍝ If Sample put in - and +
     M:Grid.Values
           ⍝⍝⍝ Variance  or Std Dev ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵≡'Sample',S:C put(count,var,sdev)f ⍺      ⍝ If sample, put in all 3 stats
     ⍵≡'Mean',S:('Sdev',S)put Q*÷2              ⍝ Update Std Dev
     ⍵≡'Sdev',S:('Mean',S)put X*2               ⍝ Update Variance
     Grid.Values
 }

∇ Z←regressAPI NS;V;I;LB;S1;S2;PA;LB;L;LN;SN;H;H0;YX;TY;L2;_;⎕IO;⎕ML;Items;FMT;A
               ⍝∇ ns-based API for Regression - Last updated 6/27/2024
               ⍝⍵ NS Namespace containing the following variables
               ⍝⍵  NS.Event   'Init' 'Select' or 'Run'
               ⍝⍵  NS.UserSpace
               ⍝←  NS.Grid  Contains Names, Values and Attributes
               ⍝←  NS.Output  Character Matrix
 ⎕IO←0 ⋄ ⎕ML←3
 :Select NS.Event
 :Case 'Init'
     NS.⎕ML←3 ⋄ NS.⎕IO←0     ⍝ Initialize settings
     NS.UserSpace←#
     NS←regressGrid NS    ⍝ Build grid
     NS←regressAttr NS    ⍝ Assign attributes
     NS.ReturnCode←0
 :Case 'Select'
     :If NS.EventArg≡'Tx'
         A←⎕NS''
         :Select NS.get'Tx'
         :Case 'cubic'
             A.Type←'A'
             NS.Grid.Attributes←'Knots'NS.changeAttributes A
             NS.Grid.Values←'LbKnots'NS.put'Knots (Optional)'
         :CaseList 'logit' '≠'
             A.Type←'A'
             NS.Grid.Attributes←'Knots'NS.changeAttributes A
             NS.Grid.Values←'LbKnots'NS.put'Guess (Int,Slope)'
         :Else
             NS.Grid.Values←'LbKnots' 'Knots'NS.put' '
             A.Type←'T'
             NS.Grid.Attributes←'Knots'NS.changeAttributes A
     
         :EndSelect
     :EndIf
 :Case 'Run'
     V←NS.Grid.Values[;1]                              ⍝
     V[¯1+≢V]←{2>≢⍵:⍵ ⋄ 1⌽')(',⍵}¨(//⎕VFI(','⎕R' ')('-'⎕R'¯')⍕↑⌽V)   ⍝ Parenthesize Knots
     V[2]←⊂{' '∊⍵:'(',⍵,')' ⋄ ⍵}2⊃V
     NS.Expr←deleteExcessBlanks⍕V[0],('report ⊢ ',1⊃V),'←',2↓V~⊂'[None]'
     NS.Output←NS.UserSpace⍎NS.Expr      ⍝ Run hypothesis operator and display output
         ⍝NS.YX←NS.UserSpace⍎(NS.get,'Y'),',⍪',NS.get,'X'
     NS.YX←NS.UserSpace⍎(2⊃V),',⍪',NS.get,'X'
     NS.MODEL←NS.UserSpace⍎NS.get'Model'
     L←0=NS.MODEL.⎕NC'g'          ⍝ Linear?
     NS.XHat←L{LU←(⌊/,⌈/)⍵ ⋄ ⍝⍺:LU
         LU[0]to LU[1],0.01×|-/LU}NS.YX[;1]
     NS.YHat←L{⍺:⍵.(MODEL.f XHat) ⋄ ⍵.(MODEL.g XHat)}NS
     
     NS.CB←L{C←1-⍵.get'Sig'
         ⍺:C ⍵.MODEL.f confInt ⍵.XHat    ⍝ Confidence Intervals
         ⍺:C ⍵.MODEL.f confInt⊃{⍺ to ⍵,0.01×|-/⍵}/⍵.XHat
         C ⍵.MODEL.g confInt ⍵.XHat}NS
     
     
     
          ⍝NS.YHAT←NS.MODEL.g NS.YX[;1]
     ⍝     NS.CB←(NS.get 'Sig') NS.MODEL.g confInt NS.YX[;1]
              ⍝ YX←NS.UserSpace⍎⍕',⍪' pairwise NS.get∘,¨ 'YX'
             ⍝  NS.Plot←YX regressPlot NS.UserSpace⍎NS.get 'Model'
 :Case ''                    ⍝ If empty,no-op
      ⍝:Else
     ⍝     NS.Grid.Values←NS.rectifyStats NS.Event
 :EndSelect
 Z←NS
∇

 regressAttr←{
     ⎕IO←0 ⋄ ⎕ML←3
     NS←⍵
     A←⎕NS''
     A.Items←'[None]' 'quadratic' 'cubic' 'sqrt' 'ln' '÷' '×' 'logit'
     NS.Grid.Attributes←'Tx'NS.changeAttributes A
     A←⎕NS''
     A.FormatString←'F5.3'
     NS.Grid.Attributes←'Sig'NS.changeAttributes A
     A←⎕NS''
     A.Items←'F'              ⍝ Numeric field (Floating Point)
     NS.Grid.Attributes←(,'X')NS.changeAttributes A
     NS.Grid.Attributes←(,'Y')NS.changeAttributes A
     A←⎕NS''
     A.callBack←{⎕IO←0 ⋄ A←⎕NS'' ⋄ A.Type←'TA'['cubic'≡⍵.get'Tx'] ⋄ ⍵.Grid.Attributes←'Knots'⍵.changeAttributes A}
     NS.Grid.Attributes←'Tx'NS.changeAttributes A
     NS}

 regressGrid←{
               ⍝∊ Written by Steve Mansour 2024
               ⍝∇ Build a Grid Object for simple regression wizard
               ⍝⍵ Empty Namespace
               ⍝← Namespace containing the following:
               ⍝←  Grid.Names:   Cell name, e.g. 'Parameter' 'SampSize'
               ⍝←  Grid.Values:  Cell vallue, e.g. 'mean' 30
               ⍝←  Grid.Types:   Cell type, e.g. 'Txt'  'Int'
               ⍝←  'mean' ← NS.get 'Parameter'
               ⍝←  GridValues ← 'SampSize' NS.put 30
     ⎕IO←0 ⋄ ⎕ML←3
     f←⊂∘toNestedVector
     ⍵.Grid←⎕NS''
          ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Values ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'Significance,0.050'
     G,←f'Model Name,MODEL'
     G,←f'Response Variable, '
     G,←f'Transformation,[None]'
     G,←f'Operation,regress'
     G,←f'Predictor Variable, '
     G,←f' , '
     I←⍸{↑↑⎕VFI ⍵}¨⊃G         ⍝ Find indices of numeric cells
     ⍵.Grid.Values←⍎¨@I⊃G     ⍝ Replace text with numerical values
          ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Names ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'LbSig,Sig'
     G,←f'LbModel,Model'
     G,←f'LbY,Y'
     G,←f'LbTx,Tx'
     G,←f'LbOp,Op'
     G,←f'LbX,X'
     G,←f'LbKnots,Knots'
     ⍵.Grid.Names←⊃G
           ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Types ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←⊃'TQ' 'TA' 'TE' 'TD' 'TT' 'TE' 'TT'
     ⍵.Grid.Attributes←⎕NS¨7 2⍴⊂''
     ⍵.Grid.Attributes.Type←⊃G
          ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Events ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.get←{1<≡⍵:∇¨⍵ ⋄ (⍸Grid.Names∊⊂⍵)⊃Grid.Values}
     ⍵.put←{w←⊆⍣(80=⎕DR ⍵)⊢⍵ ⋄ (w@(⍸Grid.Names∊⊆⍺))Grid.Values}
     ⍵.changeAttributes←changeAttributes
     ⍵}

 resizeTable←{
          ⍝∇ Resize a table with row and/or column headers
          ⍝⍺ Number of rows
          ⍝⍺ [Number of columns]
          ⍝⍺ Design
          ⍝⍵ Original 3-column table [Category Observed Proportion]
          ⍝  or Contingency table with row and column headings
          ⍝  or Latin Square Table
          ⍝    *   DEM IND REP
          ⍝    M    80 24  19
          ⍝    F    16 17  52
     ⎕IO←0 ⋄ ⎕ML←3
              ⍝ Fill←⊂⍬
     Fill←0
     D←↑⌽⍺                                      ⍝ Design?
     f←{,[1 2]⍉⊃((⍳⍺)⌽⍺ ⍺⍴⍺↑⎕A)⍵}               ⍝ Latin Square
     g←{a←standardOrder ⍺↑⎕UCS 32+⎕UCS ⎕A
         a,(2*⍺)⍵⍴0}
     D≡'latinSquare':(↑⍺)f Fill
     D≡'factorial2k':↑g/2↑⍺
     1=≢⍺:⍺↑{⍵⍪⎕A[≢⍵],(¯1+↑⌽⍴⍵)⍴Fill}⍣(0⌈⍺-≢⍵)⊢⍵   ⍝ Increment
     A←⍺+(⍺=0)×¯1+⍴⍵
     r c←0⌈1+A-⍴⍵                               ⍝ Rows, columns to add
     w←{((⊂'A',⍕≢⍵)@(⊂0,⍨≢⍵))⍵⍪Fill}⍣r⊢⍵        ⍝ Row headings     'An'
     w←{((⊂'B',⍕≢⍉⍵)@(⊂0,1⊃⍴⍵))⍵,Fill}⍣c⊢w      ⍝ Column headings  'Bn'
     (A+1)↑w
 }

∇ Z←runAnova NS;C;D;Exp;alpha;q;K;M;LS;X;V;∆;MODEL;⎕PP;fn;TwoWay;Alias
 ⎕IO←0 ⋄ ⎕ML←3 ⋄ q←'''' ⋄ ⎕PP←5
           ⍝:Trap 0
 alpha←NS.get'Sig'
 :If 'stats'≡NS.get'Var'      ⍝  Stats or data
     C←NS.get'Factor2'
     :Select D←NS.get'Design'
              ⍝ :If ''≡C ⋄ :OrIf C<2     ⍝ One-way Anova
     :Case 'oneWay'
         Exp←{z←'('q,(↑⍵),q
             z,←'stats'(1↓⍵)')' ⋄ z}¨↓NS.Table
                      ⍝Exp←⍕alpha'report anova'Exp
         Exp←⍕alpha'report oneWay anova'Exp
         NS.Expr←deleteExcessBlanks Exp
         NS←alpha buildAnovaConfInt NS
         NS.Output←NS.UserSpace exErr NS.Expr
     :Case 'blocked'
         NS.Output←alpha report blocked anova 1 1↓NS.Table
         M←{80=⎕DR ⍵:q,⍵,q ⋄ ⍕⍵}¨1 1↓NS.Table
         Exp←alpha'report blocked anova'(⍴M)'⍴'(,M)
         NS.Expr←deleteExcessBlanks Exp
     :Case 'latinSquare'
         K←≢NS.Table
                  ⍝LS X←⊂[0 1](2 1/K 2)⍴NS.Table
         LS X←⊂[0 1](2 1/K 2)⍴↑¨NS.Table
         NS.Output←alpha report LS latinSquare anova X
         LS X←K{⍺ ⍺'⍴',Q,(,⍵),Q←q/⍨80=⎕DR ⍵}¨LS X
         Exp←alpha'report (',LS,') latinSquare anova'X
         NS.Expr←deleteExcessBlanks Exp
     :Case 'factorial2k'
         X←⍎∘⍕¨0 1↓NS.Table
         Alias←{∧/⍵∊⎕A:⍵ ⋄ (⍵∊⎕A)⊂⍵}NS.get'LeftArg'
         NS.Output←alpha report Alias factorial2k anova X
         Exp←alpha'report'(q,Alias,q)'factorial2k anova'(⍴X)'⍴',,X
         NS.Expr←deleteExcessBlanks⍕Exp
     :Else
                  ⍝ NS.Output←alpha report anova NS.Table
                 ⍝  NS.Output←alpha report 2 factor anova 1 1↓NS.Table
         NS.Output←alpha report blocked anova 1 1↓NS.Table
         M←{80=⎕DR ⍵:q,⍵,q ⋄ ⍕⍵}¨1 1↓NS.Table
         Exp←alpha'report blocked anova'(⍴M)'⍴'(,M)
         NS.Expr←deleteExcessBlanks Exp
     :EndSelect
 :Else
     V←NS.get'Var' 'Factor1' 'Factor2' ⍝ Get Variable Names
              ⍝ TwoWay←×≢' '~⍨2⊃V
     TwoWay←'oneWay'≢NS.get'Design'
              ⍝ fn←TwoWay⊃'oneWay' '2 factor'
     fn←NS.get'LeftArg' 'Design'
     :If '.'∊↑V
         (∆ V)←↓⍉⊃{(⍵≠'.')⊂⍵}¨V            ⍝ Strip NameSpace
         ∆←{0=≢⍵~' ':'#' ⋄ ⍵}↑∆
                     ⍝ Exp←'anova'∆ q V q
         Exp←fn'anova'∆ q V q
     :Else
         Exp←fn'anova'V
     :EndIf
     :If ~TwoWay     ⍝ One-way Anova
         NS←alpha buildAnovaConfInt NS
     :EndIf
     NS.Expr←deleteExcessBlanks⍕alpha'report'Exp
     MODEL←NS.UserSpace⍎⍕Exp
               ⍝:If 9=⎕NC'MODEL'
     :Trap 0
         NS.Means←MODEL.Means
     :Else ⋄ NS.Means←NS.Table
     :EndTrap
     NS.Output←NS.UserSpace⍎NS.Expr
     :If ~TwoWay                    ⍝ One-Way Anova
         NS.Table←⍕¨1↓NS.Means
         NS.ColTitles2←NS.Means[0;]
         NS.CellTypes←(⍴NS.Table)⍴'T'
     :Else
         NS.Table←⍕¨NS.Means
         NS.ColTitles2←' '
         NS.CellTypes←(⍴NS.Means)⍴'T'
     :EndIf
 :EndIf
           ⍝:Else
          ⍝     NS.Output←'Error'
          ⍝ :EndTrap
 Z←NS
∇

∇ Z←runAov NS;C;Exp;alpha;q;M;V;∆;MODEL;⎕PP;fn;TwoWay
 ⎕IO←0 ⋄ ⎕ML←3 ⋄ q←'''' ⋄ ⎕PP←5
           ⍝:Trap 0
 alpha←NS.get'Sig'
 :If 'stats'≡NS.get'Var'      ⍝  Stats or data
     C←NS.get'Factor2'
     :If ''≡C ⋄ :OrIf C<2     ⍝ One-way Anova
         Exp←{z←'('q,(↑⍵),q
             z,←'stats'(1↓⍵)')' ⋄ z}¨↓NS.Table
                      ⍝Exp←⍕alpha'report anova'Exp
         Exp←⍕alpha'report oneWay anova'Exp
         NS.Expr←deleteExcessBlanks Exp
         NS←alpha buildAnovaConfInt NS
         NS.Output←NS.UserSpace exErr NS.Expr
     :Else
                  ⍝ NS.Output←alpha report anova NS.Table
         NS.Output←alpha report 2 factor anova 1 1↓NS.Table
         M←{80=⎕DR ⍵:q,⍵,q ⋄ ⍕⍵}¨1 1↓NS.Table
                  ⍝ Exp←alpha'report anova'(⍴M)'⍴'(,M)
         Exp←alpha'report 2 factor anova'(⍴M)'⍴'(,M)
         NS.Expr←deleteExcessBlanks Exp
     :EndIf
 :Else
     V←NS.get'Var' 'Factor1' 'Factor2' ⍝ Get Variable Names
     TwoWay←×≢' '~⍨2⊃V
     fn←TwoWay⊃'oneWay' '2 factor'
     :If '.'∊↑V
         (∆ V)←↓⍉⊃{(⍵≠'.')⊂⍵}¨V            ⍝ Strip NameSpace
         ∆←{0=≢⍵~' ':'#' ⋄ ⍵}↑∆
                     ⍝ Exp←'anova'∆ q V q
         Exp←fn'anova'∆ q V q
     :Else
         Exp←fn'anova'V
     :EndIf
     :If ~TwoWay     ⍝ One-way Anova
         NS←alpha buildAnovaConfInt NS
     :EndIf
     NS.Expr←deleteExcessBlanks⍕alpha'report'Exp
     MODEL←NS.UserSpace⍎⍕Exp
     
               ⍝:If 9=⎕NC'MODEL'
     :Trap 0
         NS.Means←MODEL.Means
     :Else ⋄ NS.Means←NS.Table
     :EndTrap
     NS.Output←NS.UserSpace⍎NS.Expr
     :If ~TwoWay                    ⍝ One-Way Anova
         NS.Table←⍕¨1↓NS.Means
         NS.ColTitles2←NS.Means[0;]
         NS.CellTypes←(⍴NS.Table)⍴'T'
     :Else
         NS.Table←⍕¨NS.Means
         NS.ColTitles2←' '
         NS.CellTypes←(⍴NS.Means)⍴'T'
     :EndIf
 :EndIf
           ⍝:Else
          ⍝     NS.Output←'Error'
          ⍝ :EndTrap
 Z←NS
∇

∇ Z←runChiSqTest NS;Sample;Sample2;⎕IO;⎕ML;V;P;q;m;ex;PR;US;RA;XEQ;LV;XP;H;GP;M;T;R;C;addParen;RepopulateTable
           ⍝∊ Written by Steve Mansour  7/25/2019
           ⍝⍵ Get expression from Hypothesis Grid
           ⍝⍵ Namespace with grid
 ⎕IO←0 ⋄ ⎕ML←3 ⋄ RepopulateTable←0               ⍝
 q←{'''',⍵,''''}                                 ⍝
 :Select NS.get'Op'                              ⍝
 :Case 'goodnessOfFit'                           ⍝
     V←NS.get'Sig' 'Dist' 'Op' 'Var'             ⍝
     (2⊃V),←'='
     :If 'frequency'≢3⊃V                         ⍝
     :AndIf V[1]∊'normal' 'poisson'              ⍝
         ex←deleteExcessBlanks⍕1↓V               ⍝
         RepopulateTable←1
     :Else
         P←NS.Table
         P[;0]←,¨⍣(0≠↑0⍴↑P)⊣P[;0]                ⍝ Separate one-character vectors
         addParen←{str←deleteExcessBlanks ⍵
             ' '∊str:'(',str,')' ⋄ ⍵}
         V[1 3]←addParen¨V[1 3]
                  ⍝ V[3]←P{('frequency'≢↑⍵)∧⍺[;1]∧.=0:⊂(-NS get'Cols')'frequency',⍵   ⍝ Use frequency data when explicit
         V[3]←P{OBS←↑¨⍺[;1]
             ('frequency'≢↑⍵)∧0∧.=OBS:⊂(-NS get'Cols')'frequency',⍵   ⍝ Use frequency data when explicit
                     ⍝  0=↑0⍴↑⍺:⊂⍕,'(',⍺[;0],')(',⍺[;1],')' ⍝ Numeric data?
             0=↑0⍴↑⍺:⊂⍕,'(',⍺[;0],')(',OBS,')' ⍝ Numeric data?
             GP←toDelimitedList ⍺[;0]
                      ⍝ ⊂⍕(q GP)' (',⍺[;1],')'}V[3]
             ⊂⍕(q GP)' (',OBS,')'}V[3]
         :If 'multinomial'≡1⊃V                   ⍝ Multinomial goodness of fit?
             GP←toDelimitedList P[;0]            ⍝
             ex←(q,GP),∊,/1⌽')(',⊂⍉P[;1 2]
             ex←deleteExcessBlanks⍕V[1 2]ex
         :Else
             ex←deleteExcessBlanks⍕1↓V           ⍝
         :EndIf ⋄
     :EndIf
 :Case 'independent'
              ⍝ V←NS.Grid.Values[;1]
     V←NS.get'Sig' 'Dist' 'Op' 'Var'
     :If 'frequency'eq NS.get'Var'
         R C←1+NS.get'Rows' 'Cols'               ⍝ Get shape
         T←q¨@{80=⎕DR¨⍵}NS.Table                 ⍝ Put quotes around headers
         (1 1↓T)←↑¨1 1↓T                         ⍝ Change empties to 0's
         ex←'independent'R C'⍴',,T
     :Else
                  ⍝ ex←V[0]'report',1↓V                    ⍝
         ex←1↓V                                  ⍝
     :EndIf
     ex←deleteExcessBlanks⍕ex
 :EndSelect
 NS.Expr←⍕V[0]'report'ex
 M←NS.UserSpace exErr ex
 :If 9=⎕NC'M'
     NS.Output←V[0]report M
     NS.Conclusion←M.P<NS.get'Sig'
     :If RepopulateTable
         NS.Table←1↓¯1↓M.Table[;0 1 4]
     :EndIf
 :Else ⋄ NS.Output←M
 :EndIf
 Z←NS
∇

 sampSizeAttr←{
     NS←⍵
     A←⎕NS''
     A.Items←'mean' 'proportion' 'variance' 'sdev' 'sum'
     NS.Grid.Attributes←'Parameter'NS.changeAttributes A
     A.Items←'F'              ⍝ Numeric field (Floating Point)
     NS.Grid.Attributes←'Sample'NS.changeAttributes A
     A←⎕NS''
     A.validate←{(⍵=⌊⍵)∧⍵>0}
     A.ErrorMsg←'Must be a postive integer'
     A.FormatString←'I6'
     A.ReadOnly←1
     NS.Grid.Attributes←'SampleSize'NS.changeAttributes A
     A.ReadOnly←0
     NS.Grid.Attributes←'PopSize'NS.changeAttributes A
     A.validate←{0=+/×⍵-0 1}  ⍝
     A.ErrorMsg←'Negative values not permitted.'
     A.FormatString←'F9.5'
     A.ReadOnly←0
     NS.Grid.Attributes←'MOE'NS.changeAttributes A
     A.validate←{0=+/×⍵-0 1}
     A.ErrorMsg←'Must be between 0 and 1.'
     A.FormatString←'F9.5'
     NS.Grid.Attributes←'Sdev'NS.changeAttributes A
     A.validate←{0=+/×⍵-0 1}  ⍝
     A.ErrorMsg←'Must be between 0 and 1'
     A.FormatString←'F7.2'
     A.Decimals←2
     NS.Grid.Attributes←'Conf'NS.changeAttributes A
     NS
 }

∇ Z←sampleSizeAPI NS;⎕IO;⎕ML;I;L;P;X;A
            ⍝∇ ns-based API for SampleSize
            ⍝∊ Written by Steve Mansour
            ⍝⍵ nsIn Namespace containing the following variables
            ⍝   Parameter:   mean, proportion, sdev, var
            ⍝   Confidence:    0<⍵<1 (Default .95)
            ⍝   MarginOfError: ⍵>0
            ⍝   Estimate:      ⍵>0  (If proportion 0<⍵<1)
            ⍝   UserSpace:     Default #
            ⍝   Expression:    Character Vector
            ⍝⍵    Parameter Levels Var GroupBy Var2
            ⍝← nsOut Namespace contain nsIn plus the following:
            ⍝←  SampleSize:
 ⎕IO←0 ⋄ ⎕ML←3
 NS.ReturnCode←0 ⋄ NS.ErrorMessage←''
 :Select NS.Event
 :Case 'Init'
     NS←sampleSizeGrid NS
     NS←sampSizeAttr NS    ⍝ Assign attributes
 :Case 'Select'
     P←NS.get'Parameter'
     I←'mean' 'proportion' 'sdev' 'variance' 'var' 'sum'⍳⊂P
     L←'Estimated ',I⊃'Std Dev' 'Proportion' 'Std Dev' 'Variance' 'Variance' 'Variance'
     NS.Grid.Values←'LbSdev'NS.put L
     A←⎕NS''
     :If I=1 ⋄ ⍝ NS.Grid.Values←'MOE' 'Sdev'NS.put 0.03 0.5
         A.Type←'P' ⋄ A.validate←{0=+/×⍵-0 1}
         A.ReadOnly←0
         A.ErrorMsg←'Must be between 0 and 1'
     :Else ⋄
         A.Type←'F' ⋄ A.validate←{⍵>0}
         A.ReadOnly←0
         A.ErrorMsg←'Must be greater than 0'
     :EndIf
     NS.Grid.Attributes←'MOE' 'Sdev'NS.changeAttributes A
 :Case 'Run'
     X←NS.get'Conf' 'Parameter' 'Op' 'MOE' 'Sdev' 'PopSize'
     NS.Expr←deleteExcessBlanks⍕X
     NS.SampleSize←NS.UserSpace⍎NS.Expr
     NS.Grid.Values←'SampleSize'NS.put NS.SampleSize
 :Else
     NS.ReturnCode←1 ⋄ NS.ErrorMessage←'Illegal Event'
 :EndSelect
 Z←NS
∇

 sampleSizeGrid←{
               ⍝∊ Written by Steve Mansour 2019
               ⍝∇ Build a Grid Object for Hypothesis wizard
               ⍝⍵ Empty Namespace
               ⍝← Namespace containing the following:
               ⍝←  GridNames:   Cell name, e.g. 'Parameter' 'SampSize'
               ⍝←  GridValues:  Cell vallue, e.g. 'mean' 30
               ⍝←  GridTypes:   Cell type, e.g. 'Txt'  'Int'
               ⍝←  'mean' ← NS.get 'Parameter'
               ⍝←  GridValues ← 'SampSize' NS.put 30
     ⎕IO←0 ⋄ ⎕ML←3
     f←⊂∘toNestedVector
     ⍵.Grid←⎕NS''
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Values ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'Confidence,0.95'
     G,←f'Parameter,proportion'
     G,←f'Operator,sampleSize'
     G,←f'Margin of Error,0.03'
     G,←f'Estimated Proportion,0.5'
     G,←f'Population Size(0=Infinite),'
     G,←f'Sample Size,1068'
     I←⍸{↑↑⎕VFI ⍵}¨⊃G        ⍝ Find indices of numeric cells
     ⍵.Grid.Values←⍎¨@I⊃G     ⍝ Replace text with numerical values
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Names ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     G←f'LbConf,Conf'
     G,←f'LbParameter,Parameter'
     G,←f'LbOp,Op'
     G,←f'LbMOE,MOE'
     G,←f'LbSdev,Sdev'
     G,←f'LbPopSize,PopSize'
     G,←f'LbSampleSize,SampleSize'
     ⍵.Grid.Names←⊃G
              ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Attributes ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.Grid.Attributes←⎕NS¨7 2⍴⊂''
     G←⊃'TP' 'TD' 'TT' 'TP' 'TP' 'TN' 'TN'
     ⍵.Grid.Attributes.Type←⊃G
               ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝ Grid Events ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍵.get←{1<≡⍵:∇¨⍵ ⋄ ⍺←Grid.Values ⋄ (⍸Grid.Names∊⊂⍵)⊃⍺}
     ⍵.put←{w←⊆⍣(80=⎕DR ⍵)⊢⍵ ⋄ (w@(⍸Grid.Names∊⊆⍺))Grid.Values}
     ⍵.changeAttributes←changeAttributes
     ⍵}

 setProbs←{
     ⎕IO←0 ⋄ ⎕ML←3
     normProbs←{(⊂0.5 0.25×⍵-1)normal prob between¨2,/¯0.5+⍳⍵+1}
     p←⍺{⍺≡'uniform':⍴∘÷⍨≢⍵
         ⍺≡'normal':normProbs≢⍵
         (≢⍵)↑⍵[;2]}⍵
     ⍉(p@2)⍉⍵
 }

 quoteSets←{
 ⍝⍺ Right Operand
 ⍝⍵ Sets
     ⎕IO←0 ⋄ ⎕ML←3
    ⍝ ⍺≡'independent':⍵       ⍝If independent, exit
     ⍺≡'independent':⍎⍕⍵      ⍝ Independent, ensure numeric, then exit
     q←{'''',⍵,''''}
     ch←{80 160 320∨.=⎕DR∊⍵}
     num←{↑↑⎕VFI ⍵}
     ~num ⍵:q ⍵               ⍝If char, quote
     RO←⍺⍺.UserSpace⍎⍺        ⍝Evaluate right arg
     H←⎕DR∊{2≠⍴⍴⍵:⍵           ⍝Get headings
         ⍺[;0],⍥(1∘↓)⍺[0;]}RO ⍝
     ch H:q ⍵ ⋄ ⍵             ⍝If all char, quote
 }


:EndNamespace 
