﻿:Namespace Graph
(⎕IO ⎕ML ⎕WX)←1 1 3

∇ Z←GraphOutput
     ⍝← Text:      Character Matrix
     ⍝← SharpPlot: APL Graphics
     ⍝← Dimple:    External Graphics
 Z←'SharpPlot'
∇

∇ Outliers
∇

 Scale←{
     ⍝⍺ Scale (Integer)
     ⍝⍵ Data
     ⎕ML←3 ⋄ ⎕IO←0
     r←1.1×(⌈/-⌊/)⍵                 ⍝ Data range
     k←(⍺>50)⊃5 10                  ⍝
     c m←10*0 1⊤10⍟r÷⍺              ⍝ Characteristic, Mantissa
     u←c×(5⌊¯1+⌈m)⊃1 2 2.5 4 5 10   ⍝ Unit
     t←u×k                          ⍝ Tick Size
     lb←(0≠⌊/⍵)×t×⌊(u-⍨⌊/⍵)÷t       ⍝ Lower Bound
     x←⌊0.5+(⍵-lb)÷u                ⍝ Data
     t lb x
 }

 _crossTab←{
     ⎕IO←0 ⋄ ⎕ML←3
     a←{0J1∊⍵:↑⌽⍵ ⋄ ⍵}⍺
     XY←toNestedVector¨a ⍵
     X Y←{{⍵[⍋⊃⍵]}∪⍵}¨XY
     U←X∘.{⍺ ⍵}Y
     T←{⍺,≢⍵}⌸↓⍉⊃XY
     N←(T⍪0)[T[;0]⍳U;1]
     ('*',X),Y⍪N
 }

 _freq←{
          ⍝ Written by Steve Mansour
          ⍝⍺ Bin width
          ⍝⍵ Raw data
          ⍝← 2 column matrix
     ⎕ML←3 ⋄ ⎕IO←0
     d←toNestedVector ⍵               ⍝ If character, make nested
     n←+/d∊⎕NULL,⊂,⎕NULL              ⍝ Count nulls
     d←{⍵[⍋⊃⍵]}d~⎕NULL                ⍝ Remove nulls and sort
     c←2=≡d                           ⍝ Character?
     f←{⍺,≢⍵}⌸                        ⍝ Grouping function
     g←{(⍺=0)∨⍺≥≢⍵:⍵ ⋄ K←⍺-1          ⍝ Unique Groups
         W←⍵[⍒⍵[;1];]                 ⍝ Sort by frequency
         ⍺<2:W                        ⍝ ⍺ = 1 or ¯1 done
         N←+/(K-≢W)↑W[;1]             ⍝ Frequency of "Other"
         (K↑W)⍪'Other'N}
     z←⍺ f{
         (⍺≤0)∨2=≡⍵:⍺⍺ ⍵              ⍝ If chacter or
         ⍺=1:⍺⍺ ⍵                     ⍝ If bin width =1 done
         ⍺⍺(⍺÷2)+⍺×⌊⍵÷⍺}d             ⍝  If numeric, range the data
     z←z[⍋⊃z[;0];]                    ⍝ Sort result
     c:⍺ g(-n=0)↓z⍪⎕NULL n            ⍝ Done if nominal
     i←round(¯2-/z[;0])÷⍺+⍺=0         ⍝ Missing bins?
         ⍝ z←((∊i↑¨1),1)⍀z                 ⍝ Pad with 0's
     z←i{5::⍵ ⋄ ((∊⍺↑¨1),1)⍀⍵}z       ⍝ Pad with 0's?
     z[;0]←(↑z)+(⍺+⍺=0)×⍳≢z           ⍝ Insert correct midpoints
     (-n=0)↓z⍪⎕NULL n
 }

 _showCrossTab←{
     ⎕IO←0 ⋄ ⎕ML←3
     ⍺←⍳4 ⋄ a←10 ⋄ W←⍕a              ⍝ Default Width is 10
     NMS←⍕¨¨0 1{1↓0⌷[⍺]⍵}¨⊂⍵            ⍝ Get Row, Column Names
     NMS←(a×¯1 1){⍺↑¨⍵,⊂'Total'}¨NMS ⍝ Include Totals
     D←↑{⍵,[⍺]+/[⍺]⍵}/0 1,⊂1 1↓⍵     ⍝ Append Row, Column Totals
     C R←{D÷[~⍵]0⌷[⍵]⌽[⍵]D}¨0 1      ⍝ Calc Row, Column Percents
     T←D÷(¯1+⍴D)⌷D                   ⍝ Calc Total Percents
     B←(⍳4)∊⍺                        ⍝
     FS←B/1 3/('I',W)('Q<%>K2F',W,'.2')
     Z←FS ⎕FMT¨B/D R C T             ⍝
     H←a↑¨B/'Count' 'Row %' 'Column %' 'Total %'
     ,[⍳0]H{X←(⊃1⊃NMS),'|',⍵         ⍝
         H←⍺,'|',∊0⊃NMS              ⍝
         Z←' '⍪H⍪'-'⍪(¯1↓X)⍪'-'⍪¯1↑X ⍝
         Z[1↓⍳0⊃⍴Z;¯9+1⊃⍴Z]←'|' ⋄ Z  ⍝ Row total separator
     }¨Z
 }

 _showFreq←{
                  ⍝ u←'[Null]'≡⍕↑⊖⍵                 ⍝ Are there any nulls?
     ⎕ML←3 ⋄ ⎕IO←0
     u←⎕NULL≡↑⊖⍵
     r d←{0≢↑0⍴↑⍵:⍵ 0                 ⍝ If text exit
         (⍵-↑⍵)≡⍳≢⍵:(↓'I5'⎕FMT ⍵)0    ⍝ If discrete, make text
         r←{⍵∘.+0.5 ¯0.5×↑2-/⍵}⍵      ⍝ Range
         d←{10+0.1×0⌈10-⍵+5}⌈/⌈10⍟|(,r)~0 ⍝ Decimal places
         r[;1]-←10*-10×1|d            ⍝
         r d}(-u)↓⍵[;0]               ⍝
     r←(u+≢r)↑r
     c←+⍀⍵[;1]                        ⍝ Cumulative
     p←{⍵÷+⌿⍵}⍵[;1]                   ⍝ Proportion
     cp←c÷↑⌽c                         ⍝ cum proportion
     x←r,⍵[;1],c,p,[0.5]cp            ⍝ Assemble columns
     L←≢x                             ⍝ Last row
     x←(L+1)↑x                        ⍝ Append
     b←5=1⊃⍴x                         ⍝ 5 or 6 columns?
     x[L;2 3 4 5-b]←2/(+/¯1↓x[;2-b])1 ⍝ Totals
     data←x                           ⍝ remember "raw" values
     x←b{⍺:(' ',9↑[1]⊃⍵[;0]),0 1↓⍵ ⋄ ⍵}x
     FMT←b{⍺:'10A1'                   ⍝ 1st column character?
         ('2M<->','FI'[⍵=⌊⍵]),⍕⍵}d
     data←b{⍺:⍵ ⋄ ⍎⍤1⊢FMT ⎕FMT ⍵}data ⍝ From/To 5 sig digits
     FMT,←',2I10,2Q<%>K2F10.2'        ⍝ Format string
     Z←FMT ⎕FMT x                     ⍝ Format data
     Z[;(~b)/11]←'-'                  ⍝ Dashes for ranged data
     W←10+10×~b
     Z[L;⍳W]←W↑'   Total'             ⍝ Label for total
     Z[u/L-1;⍳20]←u⌿⍉⍪¯20↑'[Null]'
     D←(60-10×b)⍴1 9/' -'             ⍝ Align dashes
     Z←D⍪Z[⍳L;]⍪D⍪Z[,L;]              ⍝
     H←b⊃('From' 'To')(⊂'Category')   ⍝
     H,←'Frequency' 'Cum Freq' 'Percent' 'Cum Pct'
     Z←Z⍪⍨∊¯10↑¨H                       ⍝ Affix header
         ⍝ 9=⎕NC'##.Graph':Z                ⍝ If Desktop version, exit
     0=#.⎕NC'Boot':Z                   ⍝ If Desktop version, exit
     a←⎕NS''
     ns←⎕NS''
     ns.data←H⍪data
     ns.Type←'Table'
     ns.Style←'Smart'
     a.ExtOut←ns
     a.Type←'ExtOut'
     a
 }

 barChart←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Generate Bar Chart
      ⍝∊ Graphics
      ⍝⍺ Bins Is Bins=1: don't range data; Bins>1: number of bins; Bins<0: bin with
      ⍝⍵ Data1 Cv Character Vector or Matrix
      ⍝⍵ Data2 Cv Character Vector or Matrix
      ⍝← Graphic W Bar Chart Graph
      ⍝⍕ Graphic←[Bins|_0] barChart Data1 [Data2]
      ⍝⍎ barChart State                       ⍝ Simple bar chart
      ⍝⍎ 6 barChart Height                    ⍝ Range data (6 bins)
      ⍝⍎ barChart Party State                 ⍝ Grouped bar chart
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←0                 ⍝ Set system variables
     Bins←(↑⍺~0J1)                       ⍝ Bins
     f1←{G N←↓⍉⍵                         ⍝ Categories, Names for simple bar chart
         U X←0 1↓¨1 0 1/100 Scale 0,N    ⍝ Scale the counts
         C←' ─'[X∘.>⍳101]                ⍝ Generate top bars
         B←(3×≢X)⍴1 0 1                  ⍝ Expansion vector
         C←B⍀2⌿C                         ⍝ Expand bars
         C←((≢C)⍴'├│├'),(-3/X)⌽2↓[1]((3/X)⌽C),(3×≢X)⍴'┐│┘'
         C[;¯1+1⊃⍴C]←' '                 ⍝ Insert blanks
         S←101⍴1 9/'┬─'                  ⍝ Horizontal Scale
         T←U×1+⍳10                       ⍝ Tick marks
         FS←'10I10'                      ⍝ Format string
         S←S⍪' ',FS ⎕FMT,[¯0.5]T         ⍝ Scale
         S[;0]←'├0'                      ⍝ Zero count marker
         W←1+10×1+⌈0.1×5+⌈/X             ⍝ Width
         PRE←(~B,1 1)⍀⊃{2=≡⍵:⍵ ⋄ ⍕¨⍵}G   ⍝ Prefix - use names
         PRE,W↑[1]C⍪S}                   ⍝ Assmble graph
     f2←{                                ⍝ Multiple Bar Chart
         R←1↓⍵[;0]                       ⍝ Row names
         C←1↓⍵[0;]                       ⍝ Column names
         N←1 1↓⍵                         ⍝ Counts
         U X←0 1↓¨1 0 1/100 Scale 0,,N   ⍝ Scale the counts
         X←(⍴N)⍴X                        ⍝
         D←' ▉░▒%⌹⎕'[(X∘.>⍳101)×[1]1+⍳≢C]⍝ Shade the bars
         Z←((⍴N)⍴C),D                    ⍝
         Z←⍕(⊃(≢C)↑∘⊂¨R),[2]Z            ⍝
         S←101⍴1 9/'┬─'                  ⍝
         T←U×1+⍳10                       ⍝
         FS←'10I10'                      ⍝
         S←S⍪' ',FS ⎕FMT,[¯0.5]T         ⍝ Scale
         I←⌊/Z⍳⍤1⊢'▉'                    ⍝
         2 1⍴Z((I⍴' '),⍤1⊣0 1↓S)         ⍝
         C⍪S}                            ⍝
     T←{2=⍴⍴⍵:⍵                          ⍝ Raw data or
         2=≢⍵:Bins frequency ⍵
         1=≢⍵:Bins frequency↑⍵                ⍝ Summary?
         Bins frequency ⍵}⍵
        ⍝  2=1⊃⍴T:f1 T ⋄ f2 T                  ⍝ 2-cols is freq
     S←2=↑⌽⍴T                             ⍝ Simple bar?
     Output←S{0::'Error!' ⋄ ⍺:f1 ⍵ ⋄ f2 ⍵}T     ⍝ 2-cols is freq
     Type←'Graph'                         ⍝ Generate namespace for
     Style←'Bar' ⋄ Freq←T                 ⍝  SharpPlot
     ns←⎕NS'Type' 'Style' 'Freq' 'Output'
     0J1∊⍺:ns.Output
     ns}

 boxPlot←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Generate Box Plot
      ⍝∊ Graphics
      ⍝⍺ Starting Point (Default 0)
      ⍝⍵ Xv: Numeric Vector
      ⍝← Cm Character Matrrix
      ⍝⍕ [Ys] histogram Xv
      ⍝⍎ boxPlot D.Height                     ⍝ Single box plot
      ⍝⍎ 50 boxPlot D.Height                  ⍝ Start at 50 inches
      ⍝⍎ 50 boxPlot D.Height D.Sex            ⍝ Comparison box plot
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←0                 ⍝ Set system variables
     Start←↑⍺~0J1                        ⍝ Starting point
     NL W←{1=≡⍵:''⍵ ⋄ ↓⍉↑{⍺,⊂⍵}⌸/⌽⍵}⍵    ⍝ Name list, Variables
     a←2↑Start,10*⌈10⍟⌈/∊W               ⍝ Scale
     R←-/⌽a                              ⍝ Range
     S←101⍴1 9/'+-'                      ⍝ Tick marks
     T←(A←↑Start)+0.1×(1+⍳10)×R          ⍝ Tick Marks
     FS←{⍵≥10:'I10' ⋄ 'F10.',⍕1+⌈0.1⍟⍵}R ⍝ Format String
     S←S⍪' ',('10',FS)⎕FMT,[¯0.5]T       ⍝ Scale
     S[,1;⍳5]←('L',('10'⎕R'5')FS)⎕FMT↑a  ⍝ Format tick values
     f←{Q←(⍳5)quartile ⍵                 ⍝ Five number summary
         F←Q[1 3]+¯1 1×1.5×-/Q[3 1]      ⍝ Fence
         OUT←(1=×/×⍵∘.-F)/⍵              ⍝ Outliers
             ⍝ Q[0]⌈←F[0] ⋄ Q[4]⌊←F[1]        ⍝ Whisker bounds
         Q[0 4]←(⌊/,⌈/)⍵~OUT             ⍝ Whisker bounds
         D←⍳101                          ⍝
         QS←⌊0.5+100×(Q-A)÷R             ⍝ Scale quartiles
         OUT←⌊0.5+100×(OUT-A)÷R          ⍝ Scale outliers
         C←(D between QS[1 3])           ⍝ Box boundaries
         C←C,[¯0.5]D∊QS[1 2 3]           ⍝ Mark Q1, Median, Q3
         CB←CT←' ─'[D between QS[1 3]]   ⍝ Character Bottom
         CT[QS[1 2 3]]←'┌┬┐'             ⍝ Corner top
         CB[QS[1 2 3]]←'└┴┘'             ⍝ Corner bottom
         CM←' ─'[∨/D between QS[2 2⍴0 1 3 4]] ⍝ Character middle
         CM[QS]←'├┤│├┤'                  ⍝ Box whisker boundaries
         CM[OUT]←'*'                     ⍝ Outliers
         ((⍴⍺)↑CM)←⍺                     ⍝ Label item
         Z←⊃CT CM CB                     ⍝ Assemble top, middle, bottom
         Q[0]⌈←F[0] ⋄ Q[4]⌊←F[1]         ⍝ Replace min,max with fence?
         Z Q OUT}                        ⍝ Output, 5-no summary, outliers
     NL W←NL{2>≡⍵:,∘⊂¨⍺ ⍵ ⋄ ⍺ ⍵}W        ⍝ Enclose if one group
     Z Q OUT←↓⍉⊃NL f¨W                   ⍝ Apply the function to each group
     Output←↑⍪/Z,⊂S                      ⍝ Character matrix
     FiveNumberSummary←⊃Q                ⍝ (Min Q1, Median, Q3, Max)
     Outliers←OUT                        ⍝ Values outside the fence
     Groups←NL                           ⍝ Group Names
     Type←'Graph'
     Style←'Box'
     NS←⎕NS'Output' 'FiveNumberSummary' 'Outliers' 'Groups' 'Type' 'Style'
     0J1∊⍺:NS.Output ⋄ NS}

 cumulative←{
      ⍝∇ Convert frequency to cumulative frequency
      ⍝⍵ Frequency or Percent Frequency Distribution
      ⍝← Cumulative or Percent Cumulative Ditribution
     ⎕ML←3 ⋄ ⎕IO←0     ⍝ Set system variables
     z←⍵               ⍝ Copy distribution
     z[;1]←+\z[;1]     ⍝ Replace 2nd column with cumulative values
     z}

 dotPlot←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Generate Dot Plot
      ⍝∊ Graphics
      ⍝⍺ [Width←1] Ns Width
      ⍝⍵ Data Xv Numeric Vector
      ⍝← Graphic W Dot Plot
      ⍝⍕ Graphic←[Width] dotPlot Xv
      ⍝⍎ dotPlot Height
      ⍝⍎ 10 dotPlot Weight
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←1     ⍝ Set system variables
     a←↑(⍺,1)~0J1            ⍝ Show variable option
     i n←↓⍉a frequency ⍵     ⍝ Get frequenciews
     b←(⌽⍳⌈/n)∘.<n           ⍝ Create boolean matrix
     z←⍕(' *'[b])⍪i          ⍝ Build dot plot
     (¯1↓z)⍪'-'⍪¯1↑z         ⍝ Insert line for scale
 }

 frequency←{
         ⍝∇  Obtain frequencies from a variable
         ⍝⍟  Copyright 2018 by Stephen Mansour
         ⍝∊  Graphical Function
         ⍝⍺  Bins Is Bins=1: don't range data; Bins>1: number of bins; Bins<0: bin with
         ⍝⍵  Data Xv Simple Vector
         ⍝←  Table    Em Two-column matrix [Values, Frequencies] or Contingency Table
         ⍝⍕  Table←[Bins] frequency Vector
         ⍝⍎  1 frequency 2 1 2 3 4 2 3             ⍝ Frequency Table with numeric data
         ⍝⍎  5 frequency Height                    ⍝ Frequency Table with 5 bins
         ⍝⍎  ¯20 frequency Weight                  ⍝ Bin width = 20 lbs
         ⍝⍎  frequency 'Joe,Bob,Joe,Steve,Bob,Joe' ⍝ Frequency table with character data
         ⍝⍎  frequency Sex Party                   ⍝ Contingency Table
     ⎕ML←3 ⋄ ⎕IO←0                            ⍝ Set system variables
     (2=⍴⍴⍵)∧80≠⎕DR ⍵:⍵                       ⍝ If already frequency, done
     (9=⎕NC'⍵'):{b←0≠⍵.⎕NC'events'            ⍝ If namespace
         b:0 1,⍪⍵.(events,⍨count-events)      ⍝ If binary, create matrix
         x←⍵.(mean sdev)normal randVar ⍵.count⍝ Generate random data
         frequency x}⍵                        ⍝ Create frequency
     w←{(⎕DR ⍵)∊80 160:toNestedVector ⍵       ⍝ Convert right argument
         (2≠≢⍵)∨~(⎕DR 1⊃⍵)∊83 163 323:⍵       ⍝
         (1∨.>1⊃⍵):⍵                          ⍝
         (toNestedVector↑⍵),[0.5]1⊃⍵}⍵        ⍝
     def←{(⎕DR ⍵)∊11 80 160 320 326:0         ⍝ Default no range
         (83=⎕DR ⍵~⎕NULL)∧20>range ⍵:≢∪⍵      ⍝ Small integer, range=1
         bins←5+⍳10                           ⍝ Number of bins
         i←1⌈15+.<(count ⍵)÷bins              ⍝ Put at least 10 in each group
         bins[i-1]}                           ⍝ Interval width
     ⍺←def w                                  ⍝ Default number of bins
     rnd←{⍺≤0:⍵ ⋄ 11::⍵ ⋄ ⍺×⌊0.5+⍵÷⍺}¨        ⍝ Range the data?
     V2←(2=≢⍵)∧1<≡⍵                           ⍝ One or two variables?
     s←0J1≡↑⍺                                 ⍝ If no left argument?
     R←(w~⎕NULL)def{0=≢⍵:⍺⍺ ⍺ ⋄ ↑⍵}⍺~0 0J1    ⍝ Number of bins?
         ⍝ a←w{⍵=≢∪⍺:0
     a←w{V2:⍵
         ⍵=≢∪⍺:0
         (1<↑⍵)∧326≠⎕DR ⍺~⎕NULL:⍵{(10*¯1+⌊10⍟⍵)round ⍵÷⍺-1}range ⍺ ⍝ Remove nulls and
         |⍵}R                                 ⍝ Get bin width
     V2∧s:a _showCrossTab↑_crossTab/⍵         ⍝ Enhanced Contingency table
     V2:⍺{z←↑_crossTab/⍺ rnd ⍵                ⍝ Simple contingency table
         a=0:z                                ⍝
         (1 1↓z)←a{⍺=1:⍵÷[0]+/⍵               ⍝ Rows total 1
             ⍺=2:⍵÷[1]+⌿⍵                     ⍝ Columns total 1
             ⍵÷+/,⍵}1 1↓z ⋄ z}⍵               ⍝ Table totals 1
     s:_showFreq a _freq w                    ⍝ Enhanced frequency table
     a _freq w                                ⍝ Simple frequency table
 }

 histogram←{⎕ML←3 ⋄ ⎕IO←0
      ⍝⍟ Copyright (C) 2018  by Stephen M. Mansour
      ⍝∇ Generate Histogram
      ⍝∊ Graphics
      ⍝⍺ Bins Is Number of bins, 0=Let system decide, 1=don't range data
      ⍝⍵ Data Xv Numeric Vector
      ⍝← Graphic W Histogram Graphic
      ⍝⍕ Graphic←[Bins] histogram Xv
      ⍝⍎ histogram Weight                      ⍝ Simple Histogram
      ⍝⍎ 5 histogram Height                    ⍝ Display 5 bins
      ⍝⍎ ¯20 histogram Weight                  ⍝ Bin Width = 20
     ⍺←0 ⋄ ⎕IO←0 ⋄ ⎕ML←3                  ⍝ Set system variables
     a←↑⍺~0J1
     G N←a{⍺=0:↓⍉frequency⍣(1=↑⍴⍴⍵)⊣⍵     ⍝ Midpoints, Frequencies
         ↓⍉⍺∘frequency⍣(1=↑⍴⍴⍵)⊣⍵}⍵       ⍝
     Output←{0::'Error!'                  ⍝
         T X←0 1↓¨1 0 1/20 Scale 0,N      ⍝ Scale
         Y←2⌈/,X[0],X,¯1↑X                ⍝ Heights of vertical bars
         C←(⍳20)∘.<Y                      ⍝ Boolean image of bars
         D←⌈10⍟⌈/G                        ⍝ Digits
         W←5⌈2+D                          ⍝ Bar Width
         B←1,⍨(W×≢N)⍴W↑1                  ⍝ Expand boolean image of bars
         C1←⊖(B\C)∨∨/(⍳20)∘.={⍵,[0.5]1⌽⍵}0,W/X ⍝
         C1←0⍪(0,C1,0)⍪0                  ⍝ Pad graph with spaces
         M←1⌽C1⍷⍨3 1⍴1                    ⍝ │
         M⌈←2×1⊖C1⍷⍨1 3⍴1                 ⍝ ─
         M⌈←3×1⌽1⊖C1⍷⍨2 2⍴1 1 1 0         ⍝ ┌
         M⌈←4×1⊖C1⍷⍨2 2⍴1 1 0 1           ⍝ ┐
         M⌈←5×1⌽C1⍷⍨3 2⍴1 0 1 1 1 0       ⍝ ├
         M⌈←6×C1⍷⍨3 2⍴0 1 1 1 0 1         ⍝ ┤
         M⌈←7×1⊖C1⍷⍨2 3⍴1 1 1 0 1 0       ⍝ ┬
         M[19;]←2 8[B,0 0]                ⍝ Base row
         Z←21↑' │─┌┐├┤┬┴'[¯1⌽¯1⊖M]        ⍝ Replace numbers with edges
         P←0⌈-⌊10⍟|-/2↑G                  ⍝ Decimal Places for X-Values
             ⍝Z⍪←(1⊃⍴Z)↑(¯1+⌊0.5×W-D)↓W 0⍕G   ⍝ Base line scale
         Z⍪←(1⊃⍴Z)↑(' '/⍨×P),W P⍕G   ⍝ Base line scale
         L←(22⍴1 4/1 0)⍀'I5'⎕FMT T×⌽⍳5    ⍝ Build left hand scale
         L,←,[⍬](20⍴1 4/'┤│')⍪'└ '        ⍝ Include tick marks
         L,Z}⍬                            ⍝ Append to histogram
     Type←'Graph'                         ⍝ Generate namespace for
     Style←'Histogram' ⋄ YX←N,⍪G          ⍝  SharpPlot
     Width←|-/2↑G                         ⍝ Force scalar for SharpPlot
     Data←⍵
     ns←⎕NS'Type' 'Style' 'YX' 'Output' 'Width' 'Data'
     0J1∊⍺:ns.Output
     ns}

∇ i
∇

 intervalPlot←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Generate interval Plot
      ⍝∊ Graphics
      ⍝⍺ 3-item boolean:   Point, Conf, Pred Int
      ⍝⍵ Y-Values: 3-N or 5-N Numeric Vector
      ⍝← Character Matrrix
      ⍝⍎ intervalPlot 68 66 72                   ⍝ Interval with only conf interval
      ⍝⍎ intervalPlot 68 66 72 62 75             ⍝ Point estimate and conf and pred intsw
      ⍝⍎ 1 0 0 intervalPlot  68 66 72 62 75      ⍝ Point estimate only
      ⍝⍎ 1 0 1 intervalPlot  68 66 72 62 75      ⍝ Point estimate and prediction interval
      ⍝⍎ 1 1 0 intervalPlot  68 66 72 62 75      ⍝ Point estimate and confidence interval
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←1                    ⍝ Default is all values
     w←(¯2↑1,⍴⍵)⍴⍵                          ⍝ Force matrix
     (A S)←XAxis,w                          ⍝ Build axis
     I←↓⌊0.5+100×(A[0]-w)÷-/A               ⍝ Find relative positions
     B←(⍳W←1⊃⍴S)∘between¨¯2↑¨I                ⍝ Include values between limits
     C←↑⌽⍴w                                 ⍝ Number of columns
     K←'Key:' '* Point Estimate' '() Confidence Interval' '[] Prediction Interval'
     J←⊃B{B←⍺ ⋄ B[⍵]←C↑2+⍳6                 ⍝ Insert brackets and parens
         B}¨I⌊¯1+≢¨B                        ⍝ Find position on axis
     Z←' -*()[]'[J]                         ⍝ Create intervals
     ⍺∧.=1:Z⍪S⍪W↑⍕K,¨⊂'     '               ⍝ Default, show point and all intervals
     Z←('\*'⎕R'-')⍤1⍣(~↑⍺)⊢' ',Z,' '        ⍝ Eliminate point estimate?
     Z←('\)'⎕R'-')∘('\('⎕R'-')⍤1⍣(~↑⌽2↑⍺)⊢Z ⍝ Eliminate confidence interval?
     Z←('\]'⎕R'-')∘('\['⎕R'-')⍤1⍣(~↑⌽3↑⍺)⊢Z ⍝ Eliminate prediction interval?
     Z←('- '⎕R'  ')∘(' -'⎕R'  ')⍤1⍣≡Z       ⍝ Eliminate outside dashes
     Z←0 1↓0 ¯1↓Z                           ⍝ Drop 1st, last columns
     Z⍪S⍪W↑⍕(1,3↑⍺)/K,¨⊂'     '             ⍝ Append scale and key
 }

 normProbPlot←{
      ⍝⍟ Copyright (C) 2022 by Stephen M. Mansour
      ⍝∇ Generate Normal Probability Plot
      ⍝∊ Graphics
      ⍝⍺ [Symbols] Cv Symbols
      ⍝⍵ Data Xv Data Values
      ⍝← Graphic W ScatterPlot  Character Matrix or Namespace
      ⍝⍕ Graphic←[Symbols] normProbPlot Data
      ⍝⍎ normProbPlot show Height      ⍝ Simple Normal probability Plot
      ⍝⍎ Sex normProbPlot show Height  ⍝ Differentiate by Sex
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←'*'
     X←⍵[⍋⍵]  ⍝ Sort the data
     N←≢X     ⍝
     F←((1 to N)-0.375)÷N+0.25
     Z←normal critVal≥F
     ⍺≡'*':Z scatterPlot X
     ⍺≡,0J1:0J1 scatterPlot Z X
         ⍝ NS←⍺[⍋⍵]scatterPlot Z X
     A←(~0J1∊⍺)↓0J1,(⍺~0J1)[⍋⍵]
     A scatterPlot Z X
        ⍝  NS.Style←'NormProbPlot'
        ⍝  NS
 }

 pieChart←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Generate Bar Chart
      ⍝∊ Graphics
      ⍝⍵ Data  Cv Character Vector or Matrix
      ⍝⍕ Graphic←[Style] barChart Data
      ⍝⍎ Graphic←pieChart State                          ⍝ Simple pie chart
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←0                             ⍝ Set System variables
     FR←(↑⍺~0J1){1=⍴⍴⍵:⍺ frequency ⍵ ⋄ ⍵}⍵                     ⍝ Get frequency from raw data
     Output←{0::'Error!'
         Scale←{⌊0.5+1 2×[0]10+10×⍵}                 ⍝ Scale
         CP←+\{⍵÷+/⍵}FR[;1]                          ⍝ Cumulative proportion
         X←21 42⍴' '                                 ⍝
         A←360                                       ⍝
         J←⊂[0]Scale(1 2∘.○○2×¯90⌽(⍳A)÷A)∘.×0.05×⍳20 ⍝
         L←' %:@.$~&,X*'
         X←0{⍺=≢J:⍵
             X←⍵
             X[J[⍺;]]←L[⍺+.>A×CP]
             (⍺+1)∇ X}X
         C←Scale 1 2∘.○○2×(⍳62)÷62
         X[↓⍉C]←'*'
         X[J[359;]]←'|'
         Y←tablebox⊂⍕((≢FR)↑L),FR
         ⍕X(2 1⍴'Legend'Y)}⍬
     Type←'Graph'                                     ⍝ Generate namespace for
     Style←'Pie' ⋄ Freq←FR                            ⍝   SharpPlot
     ns←⎕NS'Type' 'Style' 'Freq' 'Output'
     0J1∊⍺:ns.Output
     ns
 }

 regressionPlot←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Generate Regression plot (ScatterPlot with regression Line)
      ⍝∊ Graphics
      ⍝⍵ Regression Model Namespace
      ⍝← W Namespace containing YX values, slope and intercept
      ⍝⍕ W←regressionPlot NS
     ⎕IO←0 ⋄ ⎕ML←3                                ⍝ Set System Variables
     VarNames←'YX' 'Slope' 'Intercept' 'Caption'  ⍝ Variable Names
     VarNames,←'XAxis' 'YAxis' 'Type' 'Style'     ⍝    "       "
     Type←'Graph' ⋄ Style←'Regress'               ⍝ Scatterplot
     Simple←{                                     ⍝ Simple regression
         YX←⍵.YX                                  ⍝ Plot X vs Y
         (Intercept Slope)←⍵.B                    ⍝ Regression line
         Caption←'Regression Plot'                ⍝
         (YAxis XAxis)←⍵.VariableNames            ⍝ Label Axes
         ⎕NS VarNames}                            ⍝ Create namespace
     Multi←{                                      ⍝ Multiple regression
         YX←⍵.(E,⍪YHAT)                           ⍝ Plot residuals
         Slope←Intercept←0                        ⍝ Horizontal line at 0.
         Caption←'Residual Plot'                  ⍝
         XAxis←'Fitted Values'                    ⍝ Label Axes
         YAxis←'Residuals'                        ⍝   "     "
         ⎕NS VarNames}                            ⍝ Create namespace
     0::Multi ⍵
     2<≢⍵.B:Multi ⍵                               ⍝ Multiple or simple?
     Simple ⍵}

 relative←{⎕ML←3 ⋄ ⎕IO←0
     z←⍵
     z[;1]←z[;1]÷+/z[;1]
     z}

 scatterPlot←{
      ⍝⍟ Copyright (C) 2018, 2023 by Stephen M. Mansour
      ⍝∇ Generate Scatterplot
      ⍝∊ Graphics
      ⍝⍺ [Symbols] Cv Symbols
      ⍝⍵ YValues   Yv Response Values
      ⍝⍵ XValues   Xv Predictor Values
      ⍝← Graphic W Scatter Plot
      ⍝⍕ [Symbols] scatterPlot [YValues] Xvalues
      ⍝⍎ scatterPlot show Height ShoeSize
      ⍝⍎ Sex scatterPlot show Height ShoeSize
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←'*'                       ⍝ Set System Variables
     0J1∊⍺:(⍺~0J1)∇ ⍵
          ⍝G←25 75⍴' '                                 ⍝ Initialize Graph
     G←26 76⍴' '
     A←(0=≢⍺)⊃⍺'*'
     A W←A{
         2=⍴⍴⍵:⍺ ∇(↓⍉⍵)                          ⍝ If matrix, make vv
         ⍺∧⍥{(1=≡⍵)∧2|⎕DR ⍵}⍵:'*'(⍺ ⍵)           ⍝ Both args numeric vectors
         1=≡⍵:⍺((1+⍳⍴⍵)⍵)                          ⍝ Simple Numeric vector on right
         2<≢⍵:⍺{W←((↑⍵){(⍺⍴⍨⍴⍵)⍵}∊1↓⍵)
             1=≢⍺:⍺ W ⋄ (⍺/⍨⍴↑⍵)W}⍵             ⍝ More than two numeric vectors on right
         ⍺ ⍵}⍵
     
     B←↑=⍥{⎕NULL≠⍵}/W ⋄ GP←(B⍴⍨≢A)/A             ⍝ Remove Nulls
     YX←B∘/¨W
     Output←GP{⍝0::'Error!'
         M←⊃(¯5 ¯10+⍴G)Scale¨⍵~¨⎕NULL            ⍝ Scale
         I←↓⍉⊃M[;2]
         EU←⊃I≥⊂⍴G                                ⍝ Check for Index Error
         EL←⊃I<0
         I←0⌈I⌊⊂¯1+⍴G                             ⍝ Keep indices within bounds
         A←(≢EU)⍴⍺ ⋄ (EU[;0]/A)←'∧' ⋄ (EU[;1]/A)←'>'
         (EL[;0]/A)←'∨' ⋄ (EL[;1]/A)←'<'
         G[I]←↑¨A
         K←2=≢¨A
         G[(⊂0 1)+K/I]←↑∘⌽¨K/A
         T←M[;0]                                 ⍝ Tick Size
         FS←{⍵≥1:'I10'                           ⍝ Format string
             'F10.',⍕-⌊10⍟⍵}¨T
         LB←M[;1]                                ⍝ Lower bounds
         S←LB+T×⍳¨5 8                            ⍝ Scale
         B←25⍴1 4/1 0                            ⍝ Expand
         YI←(B⍀(0⊃FS)⎕FMT 0⊃S),'│┤'[B]           ⍝ Build Y-axis
         XI←(1 81⍴1 9/'┬─')⍪' ',,(1⊃FS)⎕FMT 1⊃S  ⍝ Build X-axis
         XI[0;⍳10]←¯10↑'└'                        ⍝ Insert tick marks
         (⊖G,⍨YI⍪' ')⍪87↑⍤1⊢' ',XI              ⍝ Assemble plot
     }YX
     Type←'Graph'
     Style←'ScatterPlot'
     NS←⎕NS'Output' 'Type' 'Style' 'YX'
     0J1∊⍺:NS.Output
     NS
 }

 stemAndLeaf←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Generate StemAndLeaf Plot
      ⍝∊ Graphics
      ⍝⍺ [StemSize←10] Ns Stem Size
      ⍝⍵ Data Xv Numeric Vector
      ⍝← Graphic W Stem and Leaf Plot
      ⍝⍕ Graphic←[StemSize] stemAndLeaf Data
      ⍝⍎ stemAndLeaf Weight
      ⍝⍎ 5 stemAndLeaf Height
     ⍺←10 ⋄ ⎕IO←0 ⋄ ⎕ML←3                 ⍝ Stem Size must be
     a←↑(⍺,10)~0J1                        ⍝ Stem Size
     ~5 1∊⍨10*1|10⍟a:'Domain Error'       ⍝    1 or 5 x 10^N
     2=≡⍵:{k←≢s←{⍵[⍋⍵]}↑∪/ss←{⍵[;0]}¨⍵    ⍝ If 2 samples
         i←(ss⍷¨⊂s)⍳¨1 ⋄ z←'|',s,[0.5]'|' ⍝ Create a double
         d←i{k↑(⍺⍴⊂⍬),⍵[;2],k⍴⊂⍬}¨⍵       ⍝   stemAndLeaf
         ¯1⌽z,⌽⍉⊃d}⍺ ∇¨⍵                  ⍝   plot
     d←0.1×⌊0.5+⍵[⍋⍵]÷u←10*¯1+⌈10⍟a       ⍝ Data
     Stem←d{⍵:⌊⍺ ⋄ 0.5×⌊⍺×2}0=1|10⍟a      ⍝ Generate stems
     Leaf←⌊0.5+10×1|d                     ⍝ Generate leaves
     z←Stem{(⌊⍺)'|'(⍵[⍋⍵])}⌸Leaf          ⍝ Group leaves by stems
     z←{1∧.=i←¯2-/z[;0]:⍵                 ⍝ Missing bins?
         i≡(⍴i)⍴(1=↑i)⌽0 1:⍵              ⍝ Alternating bins?
         ~0∊i:i{u←∊⍵[;0]+⍳¨⍺,1                ⍝
             z←(b←(∊i↑¨1),1)⍀⍵                ⍝ Pad with 0's
             z[;0]←u                          ⍝
             z[;1]←'|'                        ⍝
             z[(~b)⌿⍳⍴b;2]←⊂⍬ ⋄ z}⍵           ⍝
         'Nonce Error'
     }z
     Stem←z[;0] ⋄ Leaf←z[;2]
     Output←⍕z
     LeafUnit←u
     ns←⎕NS'Output' 'Stem' 'Leaf' 'LeafUnit'
     0J1∊⍺:ns.Output ⋄ ns
 }

 xfrequency←{
         ⍝∇  Obtain frequencies from a variable
         ⍝⍟  Copyright 2018 by Stephen Mansour
         ⍝∊  Graphical Function
         ⍝⍺  Range (numeric integer) - Bin size if ⍺>0,
         ⍝⍺  If ⍺ < 0, then |⍺| = number of bins
         ⍝⍺  If ⍺ = 0 or not specified, no grouping
         ⍝⍵  Simple Vector
         ⍝⍵  [Grouping Vector] (optional)
         ⍝←  Two-column matrix [Values, Frequencies]
         ⍝←  or Contingency Table
         ⍝⍎  frequency 2 1 2 3 4 2 3
         ⍝⍎  frequency 'Joe,Bob,Joe,Steve,Bob,Joe'
         ⍝⍎  frequency SEX PARTY
     ⎕ML←3 ⋄ ⎕IO←0
     (2=⍴⍴⍵)∧80≠⎕DR ⍵:⍺{⍺=¯1:⍵[⍒⍵[;1];] ⋄ ⍵}⍵
     w←{(⎕DR ⍵)∊80 160:toNestedVector ⍵   ⍝ Convert right argument
         (2≠≢⍵)∨~(⎕DR 1⊃⍵)∊83 163 323:⍵
         (1∨.>1⊃⍵):⍵ ⋄ (toNestedVector↑⍵),[0.5]1⊃⍵}⍵
     def←{(⎕DR ⍵)∊11 80 160 320 326:0     ⍝ Default no range
         (83=⎕DR ⍵)∧20>range ⍵:1          ⍝ Small integer, range=1
         bins←5+⍳10                       ⍝ Number of bins
         i←1⌈15+.<(count ⍵)÷bins          ⍝ Put at least 10 in each group
              ⍝⌈(range ⍵)÷bins[i-1]}           ⍝ Interval width
         ⌈(range ⍵)÷5⌈bins[i-1]}          ⍝ Interval width
     ⍺←def ⍵                              ⍝ Default
     R←⍺
     freq←{
         d←toNestedVector ⍵               ⍝ If character, make nested
         n←+/d∊⎕NULL,⊂,⎕NULL              ⍝ Count nulls
         d←{⍵[⍋⊃⍵]}d~⎕NULL                ⍝ Remove nulls and sort
         f←{⍺,≢⍵}⌸                        ⍝ Grouping function
            ⍝  z←⍺{⍺≤0:f ⍵ ⋄ f ⍺×⌊0.5+⍵÷⍺}d     ⍝ If numeric, range the data
         z←⍺ f{(⍺≤0)∨2=≡⍵:⍺⍺ ⍵ ⋄
             ⍺⍺ ⍺×⌊0.5+⍵÷⍺}d                ⍝  If numeric, range the data
         z←z[⍋⊃z[;0];]                    ⍝ Sort result
         z←{⍵[⍒⍵[;1];]}⍣(⍺=¯1)⊣z          ⍝ Pareto if ¯1
              ⍝0≢↑0⍴↑z:(-n=0)↓z⍪⎕null n         ⍝ Done if nominal
         0≢↑0⍴↑z:⍺{{⍵[⍒⍵[;1];]}⍣(⍺=¯1)⊣⍵}(-n=0)↓z⍪⎕NULL n         ⍝ Done if nominal
             ⍝ i←(¯2-/z[;0])÷⍺+⍺=0              ⍝ Missing bins?
         i←round(¯2-/z[;0])÷⍺+⍺=0              ⍝ Missing bins?
         z←((∊i↑¨1),1)⍀z                  ⍝ Pad with 0's
         z[;0]←(↑z)+(⍺+⍺=0)×⍳≢z           ⍝ Insert correct midpoints
         (-n=0)↓z⍪⎕NULL n
     }
     showFreq←{
             ⍝ u←'[Null]'≡⍕↑⊖⍵                 ⍝ Are there any nulls?
         u←⎕NULL≡↑⊖⍵
         r d←{0≢↑0⍴↑⍵:⍵ 0                 ⍝ If text exit
             (⍵-↑⍵)≡⍳≢⍵:(↓'I5'⎕FMT ⍵)0    ⍝ If discrete, make text
             r←{⍵∘.+0.5 ¯0.5×↑2-/⍵}⍵      ⍝ Range
             d←{10+0.1×0⌈10-⍵+5}⌈/⌈10⍟|,r ⍝ Decimal places
             r[;1]-←10*-10×1|d            ⍝
             r d}(-u)↓⍵[;0]               ⍝
         r←(u+≢r)↑r
         c←+⍀⍵[;1]                        ⍝ Cumulative
         p←{⍵÷+⌿⍵}⍵[;1]                   ⍝ Proportion
         cp←c÷↑⌽c                         ⍝ cum proportion
         x←r,⍵[;1],c,p,[0.5]cp            ⍝ Assemble columns
         L←≢x                             ⍝ Last row
         x←(L+1)↑x                        ⍝ Append
         b←5=1⊃⍴x                         ⍝ 5 or 6 columns?
         x[L;2 3 4 5-b]←2/(+/¯1↓x[;2-b])1 ⍝ Totals
         x←b{⍺:(' ',9↑[1]⊃⍵[;0]),0 1↓⍵ ⋄ ⍵}x
         FMT←b{⍺:'10A1'                   ⍝ 1st column character?
             ('2M<->','FI'[⍵=⌊⍵]),⍕⍵}d
         FMT,←',2I10,2Q<%>K2F10.2'        ⍝ Format string
         Z←FMT ⎕FMT x                     ⍝ Format data
         Z[;(~b)/11]←'-'                  ⍝ Dashes for ranged data
         W←10+10×~b
         Z[L;⍳W]←W↑'   Total'             ⍝ Label for total
         Z[u/L-1;⍳20]←u⌿⍉⍪¯20↑'[Null]'
         D←(60-10×b)⍴1 9/' -'             ⍝ Align dashes
         Z←D⍪Z[⍳L;]⍪D⍪Z[,L;]              ⍝
         H←b⊃('From' 'To')(⊂'Category')   ⍝
         H,←'Frequency' 'Cum Freq' 'Percent' 'Cum Pct'
         Z⍪⍨∊¯10↑¨H                       ⍝ Affix header
     }
     crossTab←{
         a←{0J1∊⍵:↑⌽⍵ ⋄ ⍵}⍺
         XY←toNestedVector¨a ⍵
         X Y←{{⍵[⍋⊃⍵]}∪⍵}¨XY
         U←X∘.{⍺ ⍵}Y
         T←{⍺,≢⍵}⌸↓⍉⊃XY
         N←(T⍪0)[T[;0]⍳U;1]
         ('*',X),Y⍪N
     }
     showCrossTab←{⍺←⍳4 ⋄ a←10 ⋄ W←⍕a    ⍝ Default Width is 10
         NMS←⍕¨¨0 1{1↓0⌷[⍺]⍵}¨⊂⍵            ⍝ Get Row, Column Names
         NMS←(a×¯1 1){⍺↑¨⍵,⊂'Total'}¨NMS ⍝ Include Totals
         D←↑{⍵,[⍺]+/[⍺]⍵}/0 1,⊂1 1↓⍵     ⍝ Append Row, Column Totals
         C R←{D÷[~⍵]0⌷[⍵]⌽[⍵]D}¨0 1      ⍝ Calc Row, Column Percents
         T←D÷(¯1+⍴D)⌷D                   ⍝ Calc Total Percents
         B←(⍳4)∊⍺                        ⍝
         FS←B/1 3/('I',W)('Q<%>K2F',W,'.2')
         Z←FS ⎕FMT¨B/D R C T             ⍝
         H←a↑¨B/'Count' 'Row %' 'Column %' 'Total %'
         ,[⍳0]H{X←(⊃1⊃NMS),'|',⍵         ⍝
             H←⍺,'|',∊0⊃NMS              ⍝
             Z←' '⍪H⍪'-'⍪(¯1↓X)⍪'-'⍪¯1↑X ⍝
             Z[1↓⍳0⊃⍴Z;¯9+1⊃⍴Z]←'|' ⋄ Z  ⍝ Row total separator
         }¨Z
     }
     rnd←{⍺≤0:⍵ ⋄ ⍺×⌊0.5+⍵÷⍺}¨         ⍝ Range the data?
     V2←(2=≢⍵)∧1<≡⍵                      ⍝ One or two variables?
     s←0J1≡↑⍺                            ⍝
         ⍝ a←⍵{⍵<¯1:(range ⍺)÷-⍵+1 ⋄ ⍵}⍺~0J1
     a←⍵{¯1>↑⍵:(range ⍺)÷-⍵+1 ⋄ ⍵}⍺~0J1
        ⍝  a←⍵{⍵≡0:def ⍺ ⋄ ⍵}↑⍺~0J1            ⍝
     a←⍵{⍵≡0:def ⍺ ⋄ ⍵}↑a                ⍝
     V2∧s:a showCrossTab↑crossTab/⍵      ⍝
     V2:↑crossTab/⍺ rnd ⍵
     s:showFreq a freq ⍵                 ⍝
     a freq ⍵                            ⍝
 }

 xscatterPlot←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Generate Scatterplot
      ⍝∊ Graphics
      ⍝⍺  Response Variable  Y coordinate
      ⍝⍵  Predictor Variable X coordinate
      ⍝← CmL Character Matrix or Namespace
      ⍝⍕ [Yv] scatterPlot  Xv
      ⍝⍕ [  ] scatterPlot Yv Xv
      ⍝⍎ D.Height scatterPlot D.ShoeSize
     
     ⎕IO←0 ⋄ ⎕ML←3                               ⍝ Set System Variables
     G←25 75⍴' ' ⋄ ⍺←0                           ⍝ Initialize Graph
     (2≤≡⍵)>80∧.=⎕DR¨,⍵:⍺ ∇{ns←⍺⍺/⍵ ⋄            ⍝ If args on right
         0J1∊⍺:ns.Output ⋄ ns}⍵                  ⍝ If nested, apply
     
     A←⍺~⍥,0J1                                   ⍝
         ⍝(1=≡⍵)∧(⊂A)∊⍬(,0):⍵ ∇⍳⍴⍵                    ⍝ If no left argument, time series plot
     (1=≡⍵)∧(⊂A)∊⍬(,0):⍵ ∇⍳↑⌽⍴⍵                  ⍝ If no left argument, time series plot
     2=⍴⍴⍵:((⍴⍵)⍴A)∇⍥,⍵                          ⍝ If right matrix, expand left
     2=⍴⍴⍺:A ∇(⍴A)⍴⍵                             ⍝ If left matrix, expand right
     YX←A{⍺≡0:⍵~⎕NULL ⋄
         b←∧/⎕NULL≠⍺,⍪⍵
         y x←b∘/¨⍺ ⍵},⍵                          ⍝ Merge x,y variables
     Output←{⍝0::'Error!'
         M←⊃(¯5 ¯10+⍴G)Scale¨⍵                   ⍝ Scale
     
         G[↓⍉⊃M[;2]]←'*'                         ⍝ Insert * for each pair
            ⍝  QQ←⍉⊃M[;2]
            ⍝  P←QQ[;1]{⎕ML←1 ⋄ ⍵⊂⍨1,2>/⍺}⍉QQ
            ⍝  _←'*⍟○∘×+'{I←↓⍉⍵ ⋄ G[I]←⍺ ⋄ 0}¨P
         T←M[;0]                                 ⍝ Tick Size
         FS←{⍵≥1:'I10'                           ⍝ Format string
             ⍝ FS←{⍵>2:'I10'
             'F10.',⍕-⌊10⍟⍵}¨T
         LB←M[;1]                                ⍝ Lower bounds
         S←LB+T×⍳¨5 8                            ⍝ Scale
         B←25⍴1 4/1 0                            ⍝ Expand
         YI←(B⍀(0⊃FS)⎕FMT 0⊃S),'│┤'[B]           ⍝ Build Y-axis
         XI←(1 81⍴1 9/'┬─')⍪' ',,(1⊃FS)⎕FMT 1⊃S  ⍝ Build X-axis
         XI[0;⍳11]←YI[0;⍳10],'┼'                 ⍝ Insert tick marks
         (⊖1↓YI,G,' ')⍪87↑⍤1⊢XI                  ⍝ Assemble plot
     }YX
     Type←'Graph'
     Style←'ScatterPlot'
     NS←⎕NS'Output' 'Type' 'Style' 'YX'
     0J1∊⍺:NS.Output
     NS
 }

 SharpPlot←{GraphOutput←'SharpPlot'
     ⍺←0
     ⍺ ⍺⍺ ⍵}


 graph←{
     2+
     ⎕ML←3 ⋄ ⎕IO←1
     ⍺←0 1
     _←'F'⎕WC'Form'
     ⍝lb←⍺ ⍺⍺ criticalValue>⍵
     ⍝ub←⍺ ⍺⍺ criticalValue<⍵
     lb ub←⍵
     r←-/ub lb                               ⍝ Get range
     x←lb+r×0.01×⍳101
     X←100×{⍵-⌊/⍵}x÷r
     Y←5+{95×1-⍵÷⌈/⍵}⍺ ⍺⍺ x
     X←0,X,100                              ⍝ Use entire width of window
     Y←100,Y,100                               ⍝ Leave vertical space for TrackBar, Values
     F.YX←⍉⊃Y X                              ⍝ X, Y coordinates for poly
     F.Bounds←lb,ub                          ⍝ Set bounds
     _←'F.SF'⎕WC'SubForm' ''(0 0)(80 100)
     _←'F.SF.L1'⎕WC'Poly'(2 2⍴100 100)           ⍝ Lower tail of distribution
     F.SF.L1.FStyle←0                           ⍝   is shaded
     _←'F.SF.L2'⎕WC'Poly'F.YX                   ⍝ Upper tail of distribution
     F.SF.L2.FStyle←-1                          ⍝   is unshaded
     G←⍺⍺ GetValue                          ⍝ Call back to retrieve value
     Rc←⍺⍺ Recalculate
     Sa←⍺⍺ ShadeArea
     ⍝ _←'F.TB'⎕WC'TrackBar'(80 0)(90 100)('TickAlign' 'Top')('Limits' 4 100)('TickSpacing' 1)('Attach' 'Bottom' 'None' 'Bottom' 'None')
     _←'F.TB'⎕WC'TrackBar'(80 0)(10 100)('TickAlign' 'Top')('Limits' 0 100)('TickSpacing' 1)('Attach' 'Bottom' 'None' 'Bottom' 'None')

     F.TB.onThumbDrag←'G'⍺
     Items←,¨'<≤=≥>≠'
     _←'F.Pr'⎕WC'Button' 'Prob'(90 20)(5 7)('Attach' 'Bottom' 'None' 'Bottom' 'None')
     F.Pr.onSelect←'Rc'⍺
     _←'F.C'⎕WC'Combo'Items'≤'(90 30)(5 7)('Attach' 'Bottom' 'None' 'Bottom' 'None')
     F.C.SelItems←0 1 0 0 0 0
     F.C.onSelect←'Sa'⍺
     _←'F.X'⎕WC'Edit'(⍕lb)(90 40)(5 20)('Attach' 'Bottom' 'None' 'Bottom' 'None')('FieldType' 'Numeric')('FormatString' 'M<->F12.5')
     F.X.onChange←'Rc'⍺
     _←'F.lb'⎕WC'Button' '=:'(90 70)(5 5)('Attach' 'Bottom' 'None' 'Bottom' 'None')
     F.lb.onSelect←'Rc'⍺
     _←'F.P'⎕WC' Edit' ''(90 80)(5 15)('Attach' 'Bottom' 'None' 'Bottom' 'None')('FieldType' 'Numeric')('FormatString' 'Q<%>K2F7 0.2 ')

     F.P.onChange←'Rc'⍺
     _←⎕DQ'.'
     0




 }


:EndNamespace 
