﻿:Namespace Koko
(⎕IO ⎕ML ⎕WX)←1 0 3

∇ {NS}←{FactorNames}Anova args;Trim;nfact;nrep;levels;comb;ncells;ndata;average;delta;ave;sostotal;doftotal;array;cells;cell_ave;deltas;sos_err;ms_err;i_effects;c_effects;n_effects;inl;ca;sos;dof;ms;frat;hi;df;i;outs;ins;nave;mult;crot;crave;corr;wcorr;mserrd;alfa;dof_err;got;tit;equ;ans;doferrd;err;tot;min;eql;data;n_levels;norm;nrows;rave;⎕ML;⎕IO;tns;residuals;aves;nl;tags
     
          ⍝∇  Create and ANalysis Of VAriance table given:
          ⍝∇     data: a vector of the data with replicates going the fastest
          ⍝∇           (last logical subscript), and the first factor (A)
          ⍝∇           going the slowest (first logical subscript).
          ⍝∇           If the data is a logical multimentional array:
          ⍝∇                data ← ,ARRAY[A;B;C;......;Reps]
          ⍝∇     n_levels:  number of levels of each factor
          ⍝∇              e.g.: for  ARRAY←3 5 4 7 2 ⍴ data
          ⍝∇                      n_levels←3 5 4 7 2
          ⍝∇                      factors←4 :: factor levels = 3 5 4 7
          ⍝∇                      number of replicates = 2
          ⍝∇                      factor D has 7 levels
          ⍝∇              no factor should have just 0 or 1 level; but there
          ⍝∇              can be just 1 replicate
          ⍝∇     norm:  if =1 the table will be put in "normal" order: A  B AB  C AC BC ABC   D AD .....
     
 ⎕ML←1 ⋄ ⎕IO←1
 Trim←{{⍎(25 10⍕⍵)~'_'}¨⍵}
 NS←⎕NS''
     
 data n_levels norm←3↑args,0
 NS.ANOVA_Data←data
 nl←¯1+≢n_levels
 :If 0=⎕NC'FactorNames'
     tags←FactorNames←(nl↑⎕A),⊂'Rep'
 :Else
     tags←FactorNames
 :EndIf
     
 nfact←¯1+≢n_levels
 nrep←⊃⌽n_levels
 levels←¯1↓n_levels
 :If ∨/levels<2 ⋄ 'Can not have 0 or 1 as a number of items in a factor.' ⋄ :Return ⋄ :EndIf
     
 comb←Dutils.CompleteComb nfact             ⍝  let the term effect refer to: main effects (A, B, ..) and the interactions (AB, ... ACD, ...)
 ncells←×/levels
     
 ndata←×/n_levels
 :If ndata≢≢data ⋄ 'data length '(≢data)' does not match levels '(ndata) ⋄ :Return ⋄ :EndIf
     
 ave←(Dutils.SumByTwos data[ndata?ndata])÷ndata            ⍝  add up the data in random order as carefully as possible
 average←ave+ndata÷⍨Dutils.SumByTwos data-ave              ⍝  refine the average as the average + the average of the residuals (which should be close to zero)
 deltas←data-average
     
          ⍝   start collecting info
 sostotal←+/deltas*2
 doftotal←ndata-1
          ⍝   make an array
 cells←n_levels⍴deltas
 cell_ave←(+/cells)÷nrep             ⍝ average across the replicates foe each cell
 residuals←deltas-,cell_ave∘.×nrep⍴1
 sos_err←+/residuals*2               ⍝ this should be zero if there are just 1 replicates
 dof_err←ncells×nrep-1
 ms_err←sos_err÷{⍵+⍵=0}dof_err       ⍝ is this 0 if there is but 1 replicate
     
          ⍝ generate the anova items (single effects, plus interactions
 i_effects←,[1.5]Dutils.CompleteComb nfact   ⍝  column matrix of factor indexes
 c_effects←tags∘{⍺[⍵]}¨i_effects        ⍝  character representation of the effects;  A B ... ABD ...
 n_effects←≢i_effects                 ⍝  how many rows in the anova table
 inl←⍳nfact                           ⍝  1 2 ... no-of-factors
     
 ca←(⍴i_effects)⍴0                    ⍝  m 2  matrix
 sos←dof←ms←frat←n_effects⍴0          ⍝  start them out as zeros
     
 hi←n_effects                         ⍝ table row-index of the highest interaction
 ca[hi;1]←⊂cell_ave+average
 sos[hi]←+/,cell_ave*2
 dof[hi]←×/levels-1
 ms[hi]←sos[hi]÷dof[hi]
     
          ⍝  process all of the effects
 :For i :In ¯1↓⍳n_effects             ⍝  highest interaction has no insis a special case
     outs←i⊃i_effects[;1]            ⍝  axes that will have their sums calculated
     ins←inl~outs                    ⍝  sum over all of these axes
     dof[i]←df←×/n_levels[outs]-1
     nave←×/n_levels[ins]
     mult←nrep××/n_levels[ins]
     
     crot←Trim(⊃,/n_levels[outs],nave)⍴(⍋,⊃,/(outs,ins))⍉cell_ave  ⍝
     crave←Trim(+/crot)÷nave
     ca[i;1]←⊂crave+average
     corr←wcorr←0
     
     :If i>1
         wcorr←~∨⌿ins∘.∊(i-1)↑,i_effects        ⍝  which previous effects contain a current "in"
         corr←Trim+/wcorr/sos[⍳i-1]
     :EndIf
     sos[i]←Trim(mult×+/,(crave)*2)-corr
     ms[i]←Trim sos[i]÷df
     :If i>nfact
     
     :EndIf
 :EndFor
     
 i←n_effects
 ca[i;1]←⊂cell_ave+average
 sos[i]←Trim 0⌈(nrep×+/,cell_ave*2)-+/sos[⍳i-1]
 ms[i]←Trim 0⌈sos[i]÷dof[i]
     
 mserrd←ms_err
 doferrd←dof_err
 :If dof_err=0
     mserrd←0⌈ms[n_effects]
     doferrd←dof[n_effects]
     ms_err←0
 :EndIf
 mserrd←Trim mserrd
 doferrd←{⍵+⍵=0}doferrd
 frat←ms÷{⍵+⍵=0}mserrd
 alfa←{{⍎15 3⍕⍵}¨⍵}Distrib.Fratio_A¨frat,¨dof,¨doferrd
     
 frat←{{⍎25 3⍕⍵}¨⍵}frat
 got←8 Dutils.RndF sos,sos_err,sostotal
 sos←n_effects↑got
 sos_err sostotal←¯2↑got
     
 got←8 Dutils.RndF ms,ms_err
 ms←n_effects↑got
 ms_err←¯1↑got
     
 tit←(⊂'  Factor  '),(⊂'  Sum Sq. '),(⊂'     DOF  '),(⊂'  Mean Sq.'),(⊂'   F-ratio'),(⊂'  ⍺ signif.')
 equ←(⊂'========  '),5⍴⊂'  ========='
 ans←c_effects,sos,dof,ms,frat,[1.5]alfa
     
          ⍝ some like the table in a different order:  A B AB C AC BC ABC D AD ...
 :If norm ⋄ ans←Dutils.NormalTableOrder ans ⋄ :EndIf
     
     
 err←(⊂10↑'error'),sos_err,dof_err,ms_err,(⊂'  '),(⊂'  ')
 tot←(⊂10↑'total'),sostotal,doftotal,(⊂'  '),(⊂'  '),(⊂'  ')
 min←(⊂'--------  '),5⍴⊂'  --------'
 eql←(⊂'========  '),(3⍴⊂'  ========'),(⊂'  '),(⊂'  ')
     
     
 tns←tit,[1]equ,[1]ans,[1]min,[1]err,[1]eql,[0.5]tot
     
 NS.ANOVA_Table←tns
     
          ⍝ some like the table in a different order:  A B AB C AC BC ABC D AD ...
 :If norm ⋄ ca←Dutils.NormalTableOrder ca ⋄ :EndIf
     
 nrows←(≢residuals)÷nrep
 rave←4 Dutils.RndS¨(Dutils.SumByTwos¨↓[1]nrows nrep⍴residuals)÷nrows
     
     
 aves←(ans[;1],ca)⍪'reps'rave
 NS.ANOVA_Averages←↑↑((⊂¨↓aves),¨⊂,' '),¨⊂,' '
     
 NS.ANOVA_Residuals←residuals
∇

∇ {ns}←NS AnovaPool abt_mss_fr_il_al_si;⎕ML;⎕IO;IsNumb;To;ns;abt;mss;il;al;select;list;kn;AT;head;colnames;kerr;ktop;kbot;fac;sos;cms;aph;errsos;errdof;errms;mask;ms;io;kpool;dof;newsos;newdof;newms;newesos;newedof;newems;nr;at;ker;ka;js;jd;jm;jf;ja;maskms;maskil;maskal;fr;fra;si
     
          ⍝∇   Pick up that last Anova and recalculate the Anova table
          ⍝∇    combining insignificant factors into error.
     
          ⍝∇  Examples:
          ⍝∇      AnovaPool abt {⍬ ⍬ ⍬ ⍬ ⍬}    ⍝ pool All But The "n" biggest mean squares
          ⍝∇      AnovaPool ⍬ mms {⍬ ⍬ ⍬ ⍬}    ⍝ pool factors with MS < Minimum Mean Square
          ⍝∇      AnovaPool ⍬ ⍬ fr {⍬ ⍬ ⍬}     ⍝ pool all Fratios smaller than fr
          ⍝∇      AnovaPool ⍬ ⍬ ⍬ il {⍬ ⍬}     ⍝ pool all Interaction Levels  il and higher
          ⍝∇      AnovaPool ⍬ ⍬ ⍬ ⍬ al {⍬}     ⍝ pool factors with an alpha ≥ than al
          ⍝∇      AnovaPool ⍬ ⍬ ⍬ ⍬ ⍬ si       ⍝ pool factors lthat include these letters
     
 ⎕ML←⎕IO←1
 IsNumb←{1=2|⎕DR¨⍵}
 To←{(×⍺-⍵)+⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 ns←⎕NS''
     
 abt mss fr il al si←6↑abt_mss_fr_il_al_si,⍬ ⍬ ⍬ ⍬ ⍬
 select←⊃⍸abt mss fr il al si≢¨⊂⍬
     
 list←NS.⎕NL ¯2
 ⎕SHADOW list
 ⍎(⍕list),'←NS.(',(⍕list),')'
     
 AT←ANOVA_Table
 head←Dutils.RemoveExcessBlanks¨AT[1;]
 colnames←Dutils.RemoveExcessBlanks¨AT[;1]
 kerr←colnames⍳⊂'error'
 ktop←3
 kbot←kerr-2
 mask←(⍳≢AT)∊ktop To kbot
     
 fac←mask/,AT Dutils.GetNamedColumns'Factor'
 sos←mask/,AT Dutils.GetNamedColumns'Sum Sq.'
 dof←mask/,AT Dutils.GetNamedColumns'DOF'
 cms←mask/,AT Dutils.GetNamedColumns'Mean Sq.'
 fra←mask/,AT Dutils.GetNamedColumns'F-ratio'
 aph←mask/,AT Dutils.GetNamedColumns'⍺ signif.'
     
 errsos errdof errms←AT[kerr;2 3 4]
 :Select select
 :Case 1          ⍝  all but n biggest MSs
     io←⍒cms
     kpool←abt↓io
     
 :Case 2          ⍝  MS ≤ given value
     maskms←cms≤mss
     kpool←maskms/⍳≢cms
     
 :Case 3          ⍝  Fratio  ≤ value
     maskal←fra≤fr
     kpool←maskal/⍳≢fra
     
 :Case 4          ⍝  interaction levels:  3≡≡ABC CDE .. ABCD ... ABCDE ...
     maskil←(≢¨fac)≥il
     kpool←maskil/⍳≢fac
     
 :Case 5          ⍝  alphas ≤ value
     maskal←aph≥al
     kpool←maskal/⍳≢aph
     
 :Case 6          ⍝  factors w/ lthese letters
     maskal←∨/¨fac∊¨⊂si
     kpool←maskal/⍳≢fac
     
 :Else
     'Nothing specified for Apool.  Nothing done'
     :Return
     
 :EndSelect
     
          ⍝  pool into error and select out the resultand table
 newesos←errsos++/sos[kpool]
 newedof←2 Dutils.RndDP errdof++/dof[kpool]
 newems←4 Dutils.RndS newesos÷newedof
     
 nr←(⍳≢AT)~2+kpool
 at←AT[nr;]
 colnames←colnames[nr]
 ker←colnames⍳⊂'error'
 at[ker;2 3 4]←newesos newedof newems
     
          ⍝  now recalc F and ⍺
 ka←2↓¯4↓(⍳≢at)
 js jd jm jf ja←head⍳'Sum Sq.' 'DOF' 'Mean Sq.' 'F-ratio' '⍺ signif.'
 at[ka;jf]←2 Dutils.RndDP at[ka;jm]÷newems
 at[ka;ja]←3 Dutils.RndDP Distrib.Fratio_A¨at[ka;jf],¨at[ka;jd],¨newedof
     
 ns.Pooled_ANOVA_Table←at
∇

∇ {ac}←AutoCorr x;y;i;⎕ML;⎕IO
     
          ⍝∇ The autocorrelation of x (end held still) and x (front held still)
          ⍝∇ Gives the correlation over time of recent history
     
 ⎕ML←⎕IO←1
 y←x
 ac←⍬
 :For i :In ¯3↓⍳≢x
     
     ac,←Dutils.Corr x y
     x←1↓x ⋄ y←¯1↓y
 :EndFor
     
 :Return
∇

 CorrelMatrix←{
     ⍝ The correlation matrix between the input vector of vectors, or Matrix input
     ⍝ ⍺ ←→ Optional variable names, 1st row if Matrix input
     2=⍴⍴⍵:(,1↑⍵)∇↓⍉1↓⍵
     ⍺←'X',∘⍕¨⍳≢⍵
     avex←Dutils.Average¨⍵
     delt←⍵-avex
     sosq←Dutils.SumByTwos¨delt×delt
     srsos←sosq*0.5
     mdelt←↓↑delt
     sxy←Dutils.SumByTwos¨mdelt∘.×mdelt
     cros←srsos∘.×srsos
     cm←3 Dutils.RndDP¨sxy÷cros
     (' ',⍺),⍺⍪cm
 }

∇ {cc}←CrossCorr(x y);i;⎕ML;⎕IO
     
          ⍝∇ The autocorrelation of x (end  held still, leading values are dropped) and
          ⍝∇                        y (moving forward, trailing values are dropped)
          ⍝∇ Gives the correlation over time of recent history
     
 ⎕ML←⎕IO←1
 cc←⍬
 :For i :In ¯3↓⍳≢x
     
     cc,←Dutils.Corr x y
     x←1↓x ⋄ y←¯1↓y
 :EndFor
     
 :Return
∇

∇ {ns}←CrossTabs(v w);⎕ML;⎕IO;uv;uw;C;c;rt;ct;gt;e;er;chq;op;tp;rp;cp;tpf;tpb;tpt;rpf;rpb;rpt;cpf;cpb;ccf;ccb;cct;tc;dof;dcf;dcb;dct;dc;re;cer
     
          ⍝∇   Do a cross-tabs or chi-square analysis: for catagorical data
          ⍝∇   It is best to have the data coded into a small (<10) number of
          ⍝∇   levels.
          ⍝∇   99 is interpreted to mean missing data.  If both are 99 the
          ⍝∇      data are eliminated.
          ⍝∇   ¯1 is interpreted to mean that the respondent didn't answer
          ⍝∇      the question, i.e., no response.  But obviously you can
          ⍝∇      code responses to be interpreted any way you wish.
     
 ⎕ML←⎕IO←1
 ns←⎕NS''
     
          ⍝  remove the 99s and makes sure they are integers
 v w←⌊(⊂(v≠99)∧(w≠99))/¨v w
     
 uv uw←{⍵[⍋⍵]}¨∪¨v w     ⍝ the levels of each variable
     
          ⍝  The counted matrix.   Levels of v are rows; levels of w are the columns
 c←(uv∘.=v)(+.×)(w∘.=uw)
 rt←+/c ⋄ ct←+⌿c ⋄ gt←+/rt
     
 e←(rt∘.×ct)÷gt          ⍝ what one would expect in each cell if all bets were equal
 er←c-e                  ⍝ deviation from the expected distribution
 cer←(¯1∊uv)↓(¯1∊uw)↓[2]er
 chq←+/,cer*2             ⍝ the ChiSquare statistic
 dof←¯1+×/⍴cer
     
          ⍝  get percentages
     
 tpf←('overall %' '---------',uv,'---------' 'Column %'),[1.5]('  ',((≢c)⍴'|'),'  ')
 tpb←(uw⍪(⊂'----')⍪(0 Dutils.RndDP 100×c÷gt))⍪(⊂'----'),[0.5](0 Dutils.RndDP 100×ct÷gt)
 tpt←('  ',((≢c)⍴'|'),' |'),[1.5](('Row %')('-----'),(0 Dutils.RndDP 100×rt÷gt),'----' '100')
 tp←⍕tpf,tpb,tpt
     
 rpf←('% per Row' '---------',uv),[1.5]('  ',((≢c)⍴'|'))
 rpb←(uw⍪(⊂'----')⍪(0 Dutils.RndDP 100×c÷rt∘.×(⍴ct)⍴1))
 rpt←('  ',((≢c)⍴'|')),[1.5](('Row %')('-----'),(0 Dutils.RndDP 100×rt÷gt))
 rp←⍕rpf,rpb,rpt
     
 cpf←('% per Col' '---------',uv,'---------' 'Column %'),[1.5]('  ',((≢c)⍴'|'),'  ')
 cpb←(uw⍪(⊂'----')⍪(0 Dutils.RndDP 100×c÷↑(≢c)⍴⊂ct))⍪(⊂'----'),[0.5](0 Dutils.RndDP 100×ct÷gt)
 cp←⍕cpf,cpb
     
 ccf←('Counts  ' '-----------',uv,'-----------' 'Col. Totals'),[1.5]('  ',((≢c)⍴'|'),'  ')
 ccb←(uw⍪(⊂'----')⍪c⍪(⊂'----'))⍪ct
 cct←(('  '),((≢uv)⍴⊂'|'),' |'),[1.5](('Row Totals')('----------'),rt,'----------'gt)
 tc←ccf,ccb,cct
     
 re←⍎¨(⊂15 2)⍕¨cer
 dcf←('Deltas  ' '-----------',(uv~¯1),'-----------' 'Col. Totals'),[1.5]('  ',((≢cer)⍴'|'),'  ')
 dcb←((uw~¯1)⍪(⊂'----')⍪re⍪(⊂'----'))⍪(+⌿|re)
 dct←(('  '),((≢(uv~¯1))⍴⊂'|'),' |'),[1.5]('Row Totals')('----------'),(+/|re),'----------'(+/,|re)
 dc←dcf,dcb,dct
     
 ns.CT_ChiSquare_DOF←chq dof
 ns.CT_Alpha←Distrib.ChiSq_A chq dof
 ns.CT_Cell_Counts←tc
 ns.CT_OverallPercents←tp
 ns.CT_RowPercents←rp
 ns.CT_ColumnPercents←cp
 ns.CT_Deltas←dc
 :Return
∇

∇ (vec ns)←DFT x;N;n;I;k;dft;mat;mzero;vec;⎕ML;⎕IO
          ⍝∇  discrete fourier transform by its definiton:  slow for big vectors: >10000
          ⍝∇  x can be of any length; not necessarily 2*n
          ⍝∇
          ⍝∇  Input:    a vector (usually a time series)
          ⍝∇  Output:   dft: the transform as a complex vector
          ⍝∇            ns:  a namespace with:  dft_as_matrix, real, imaginary, complex_vector, power and phase
     
 ⎕ML←⎕IO←1
 N←≢x ⋄ I←0J1
 dft←⍬
     
 :For k :In ¯1+⍳N
     dft,←+/(x)×*-(○2)×I×k×(¯1+⍳N)÷N
 :EndFor
     
 mat←(9○dft),[1.5](11○dft)
      ⍝  get rid of near zeros  1E-9
 mzero←1E¯9>|,mat
 (mzero/,mat)←0
     
 ns←⎕NS''
 ns.R_I_Matrix←mat
 ns.Real←mat[;1]
 ns.Imag←mat[;2]
 ns.ComplexVector←vec←{⍎(⍕⊃⍵),'j',(⍕2⊃⍵)}¨↓mat
 ns.Power←10○vec
 ns.Phase←12○vec
∇

∇ (vector ns)←FFT X;x;d;n;m;r;p;z;k;q;t;s;fft;vector;matrix;mzero;⎕ML;⎕IO
     
          ⍝∇  Calculate the fast fourier transform of x
          ⍝∇
          ⍝∇  Fast Fourier Transform
          ⍝∇  x should best be of lenght 2*n; it not it is padded to the next higher power of 2 with zeros
          ⍝∇
          ⍝∇  Input:    a vector (usually a time series)
          ⍝∇  Output:   dft: the transform as a complex vector
          ⍝∇            ns:  a namespace with:  fft_as_matrix, real, imaginary, complex_vector, power and phase
     
 ⎕ML←⎕IO←1
 p←⌈2⍟≢X
 n←2*p
 x←n↑X
 x←(2,r←(m←⌊2⍟n←≢x)⍴2)⍴x←(1,d[2]↑1)/((d←2↑(⍴x),1)⍴x),0
 z←r⍴⍉2 1∘.○○(1-⍳p)÷p←n÷2
 q←⍳p←m-1
 t←m
     
 :For k :In ⍳m-1
     x←(+⌿x),[1+¯0.5+s←m-k](-/z×-⌿x),[1+p-0.5]+/z×⌽-⌿x
     z←(((-k)⌽q),t)⍉r⍴((1+p↑(s-1)⍴1),2)↑z
 :EndFor
     
 fft←(n,2)⍴((+⌿x),[0.5]-⌿x)
     
          ⍝  get rid of near zeros  1E-9
 mzero←1E¯9>|,fft
 (mzero/,fft)←0
     
 vector←{⍎(⍕⊃⍵),'j',(⍕2⊃⍵)}¨↓fft
     
 ns←⎕NS''
 ns.ComplexVector←vector
 ns.R_I_Matrix←fft
 ns.Real←fft[;1]
 ns.Imag←fft[;2]
 ns.Power←10○vector
 ns.Phase←12○vector
∇

∇ (real ns)←IDFT cx;N;n;I;k;dft;rn;idft;mat;mzero;vec;⎕ML;⎕IO
          ⍝∇  Inverse Discrete Fourier Transform by its definition :  slow for big vectors: >10000
          ⍝∇  x can be of any length; not necessarily 2*n
          ⍝∇
          ⍝∇ Input:    a vector of complex numbers that is the ouput of DFT of x
          ⍝∇ Output:   x the input to the DFT
          ⍝∇           a namespace with: idft_as_matrix, real, imaginary, complex_vector, power and phase
     
 ⎕ML←⎕IO←1
 N←≢cx ⋄ I←0J1 ⋄ rn←÷N
 idft←⍬
     
 :For k :In ¯1+⍳N
     idft,←rn×+/(cx)×*(○2)×I×k×(¯1+⍳N)÷N
 :EndFor
     
 mat←(9○idft),[1.5](11○idft)
      ⍝  get rid of near zeros  1E-9
 mzero←1E¯9>|,mat
 (mzero/,mat)←0
     
 ns←⎕NS''
 ns.R_I_Matrix←mat
 ns.Real←real←mat[;1]
 ns.Imag←mat[;2]
 ns.ComplexVector←vec←{⍎(⍕⊃⍵),'j',(⍕2⊃⍵)}¨↓mat
 ns.Power←10○vec
 ns.Phase←12○vec
∇

∇ (vec ns)←IFFT X;N;R;M;L;P;Q;S;T;Z;mzero;vec;⎕ML;⎕IO
     
          ⍝∇ Inverse Fast Fourier Transform
          ⍝∇ Input:    the result of an FFT
          ⍝∇ Output:   (the real part of the IFFT: the input to the FFT)
          ⍝∇            a namespace with: ifft as matrix, real, imaginary, complex, power and phase
     
 ⎕ML←⎕IO←1
     
 :If 1=⍴⍴X
          ⍝  turn it into a matrix
     X←(9○X),[1.5](11○X)
 :EndIf
     
 X←(2,R←(M←⌊2⍟N←1↑⍴X)⍴2)⍴X
 Z←R⍴⍉2 1∘.○○(-⎕IO-⍳P)÷P←N÷2
 Q←⍳P←M-1+L←0
 T←M-~⎕IO
     
 :For L :In ⍳M-1
     X←(+⌿X),[⎕IO+¯0.5+S←M-L](-/Z×-⌿X),[⎕IO+P-0.5]+/Z×⌽-⌿X
     Z←(((-L)⌽Q),T)⍉R⍴((1+P↑(S-1)⍴1),2)↑Z
 :EndFor
     
 Z←((N,2)⍴(+⌿X),[⎕IO-0.5]-⌿X)÷N
     
      ⍝  get rid of near zeros  1E-9
 mzero←1E¯9>|,Z
 (mzero/,Z)←0
     
 ns←⎕NS''
 ns.R_I_Matrix←Z
 ns.Real←Z[;1]
 ns.Imaj←Z[;2]
 ns.ComplexVector←vec←{⍎(⍕⊃⍵),'j',(⍕2⊃⍵)}¨↓Z
 ns.Power←10○vec
 ns.Phase←12○vec
∇

∇ vov_data←LeadLag args;nv;nu;nf;nx;i;m;f;fl;⎕ML;⎕IO
     
          ⍝∇   There are times when data are a function of time, that you need
          ⍝∇   to "line stuff up".   Rainfall and river level for example.  The
          ⍝∇   river sizes at a later time than when the rain fell.   What you
          ⍝∇   order actually arrives later.  Some materials need to be ordered
          ⍝∇   before others to have everyting ready for the construction job.
          ⍝∇   Early decision college offers might be accepted earlier than
          ⍝∇   regular offers.
     
          ⍝∇   Input:   related set (vector) of variables, (all the same length)
          ⍝∇            an equal size vector of how much each variable should be
          ⍝∇                 lifted (+) or pushed down (-) or left alone (0)
          ⍝∇            what the "fill" value should be: "L" last value before
          ⍝∇                 the fill or "Z" zero fill or "B" for blank (character
          ⍝∇                 data) or a number (which could be 0)
          ⍝∇            should the bottom of all variables be lopped off below the
          ⍝∇                 bottom of the biggest "lifted" variable (1) or not (0)
          ⍝∇            should the top of all variables be lopped off down to the
          ⍝∇                 top of the biggest "pushed down" variable (1) or not (0)
     
 ⎕ML←⎕IO←1
 vov_data updown fill cut_bottom cut_top←5↑args,0 1 1
 nv←≢vov_data
 nu←≢updown
 :If nv≠nu ⋄ 'up/down needs one value for each x:  try again' ⋄ :Return ⋄ :EndIf
     
 nf←≢,fill
 :If nf=1 ⋄ fill←nv⍴fill ⋄ :EndIf
 nx←≢⊃vov_data
     
 :For i :In ⍳nv
     m←i⊃updown
     fl←i⊃fill
     :If fl∊'Zz' ⋄ f←0 ⋄ :EndIf
     :If fl∊'Bb' ⋄ f←⊂,' ' ⋄ :EndIf
     :If Dutils.IsNumb fl ⋄ f←fl ⋄ :EndIf
     
     :If m=0 ⋄ :Continue ⋄ :EndIf
     :If m>0
         :If fl∊'Ll' ⋄ f←⊃¯1↑i⊃vov_data ⋄ :EndIf
         (i⊃vov_data)←(m↓i⊃vov_data),m⍴f
     :Else
         :If fl∊'Ll' ⋄ f←⊃i⊃vov_data ⋄ :EndIf
         (i⊃vov_data)←((-m)⍴f),m↓i⊃vov_data
     :EndIf
 :EndFor
     
 :If cut_bottom
     vov_data←(-⌈/updown)↓¨vov_data
 :EndIf
     
     
 :If cut_top
     vov_data←(-⌊/updown)↓¨vov_data
 :EndIf
     
     
 :Return
∇

∇ M←ModelChebyshev(nd order);a;x;cheb_x;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
 cheb_x←Dutils.MakeChebyshevPolynomialX 0 nd
 M←1↓↓[1]Dutils.MakeChebyshevPolys cheb_x order
∇

∇ {(model names)}←ModelQuadratic vov;n;m;cross;c;cr;⎕ML;⎕IO
     
          ⍝∇   Create:  w x y z ... w*2 x*2 y*2 z*2 ... wx wy wz xy xz ...
     
 ⎕ML←⎕IO←1
     
 model←vov,(vov*2)
 n←⍳≢vov
 m←,n∘.<0,n
 cross←m/,(vov∘.×1,vov)
 model,←cross
     
 c←(≢vov)↑⎕A
 names←(,¨c),(c,¨c)
 cr←m/,c∘.,1,c
 names,←cr
     
 :Return
     
 w x y z←(2 1 2 1)(⍳4)(5 4 3 2)(88 66 44 22)
 m←,(⍳5)∘.≤⍳5
 two←m/,(1,(w x y z))∘.×(1,(w x y z))
∇

∇ {NS}←PrincipleComponents odata;corm;eigen;ans;data;a;d;e;z;zr;ea;tv;cv;v;n;row;b;co;r;Vup;bl;ul;nplaces;indexed_factors;ortho_factors;sorted_ortho_factors;ofactors;sofactors;tofactors;tsofactors;⎕ML;⎕IO;cumpct;pct;tab;factors;sfactors;fcm;mfcm
     
          ⍝∇  Preform principal-component analysis on a vector of vectors.
          ⍝∇    If data ia a matrix, it must have variables as columns.
     
 ⎕ML←1 ⋄ ⎕IO←1
 NS←⎕NS''
     
 nplaces←3
 data←Dutils.Standardize odata
 :If 2=≡data ⋄ data←↑[0.5]data ⋄ :EndIf      ⍝  make a vov into a matrix
     
 corm←(⍉data)+.×data   ⍝  the correlation matrix
 NS.PCOMP_DataCorrelationMatrix←corm÷⊃corm
     
 a d e z←1 Dutils.SymetricEigen corm
 NS.PCOMP_Components←1↓z
 NS.PCOMP_EigenValues←eigen←z[1;]
 zr←nplaces Dutils.RndDP¨z
 ea←nplaces Dutils.RndDP¨z[1;]
 tv←nplaces Dutils.RndDP+/z[1;]
 cumpct←cv←nplaces Dutils.RndDP¨(100×+\ea)÷tv
 pct←v←nplaces Dutils.RndDP¨100×z[1;]÷+/z[1;]
 n←2⊃⍴data
 bl←n⍴⊂' '
 ul←n⍴⊂' ====='
 NS.PCOMP_Percent←v
 NS.PCOMP_CumulativePercent←cv
     
 tab←⍉(⍳n),ul,ea,bl,v,cv,bl,(⍉1↓zr)
 row←↑20↑¨(⊂'  Factor no.       >'),(⊂21⍴'='),(⊂'  Eigen Values'),(⊂' '),(⊂'   % Variance'),(⊂'Cum. % Variance'),(⊂' '),(⊂'weight on var: V',⍕1),((⊂((15⍴' '),'V')),¨⍕¨1↓⍳n)
 tab←↑('¯'⎕R'-')¨↓⍕row,tab
 NS.PCOMP_Table←tab
     
 b←1↓z
 NS.PCOMP_Factors←co←data+.×b              ⍝ ↑('¯'⎕R'-')¨↓⍕
 fcm←(⍉co)+.×co
 mfcm←(|,fcm)<1E¯12
 (mfcm/,fcm)←0
 NS.PCOMP_FactorCovarianceMatrix←fcm
 r←≢data
 factors←co
 Vup←{i←⍒⍵ ⋄ ⍵[i],[1.5]i}
          ⍝ ortho_factors←4 Dutils.RndDP¨((r-1)*0.5)×co
 sfactors←Vup¨↓[1]factors                 ⍝  ortho_
     
          ⍝ NS.PCOMP_OrthogonalFactors←tofactors←ortho_factors     ⍝  ('¯'⎕R'-')¨⍕¨
 NS.PCOMP_FactorsSorted←tsofactors←nplaces Dutils.RndDP¨↑⊃,/sfactors     ⍝  ('¯'⎕R'-')¨↓(⍕((r,1)⍴⍳r),       )
     
          ⍝ NS.PCOMP_Diagonal←d
          ⍝ NS.PCOMP_Evector←e
          ⍝ NS.PCOMP_Amatrix←a
     
 :Return
∇

∇ {ns}←{vnames}RegressChebyshev(y x order);xm;⎕ML;⎕IO;To;io;nd;xM;cl;cheb_x;hr;sx;xsf;nsf;fp;fx;fbc;i;xhw;xc;cx;cp;cb;cy;chp;chc;cyhat;cxo;nsoc;nsoo;nsos;xtx;inv;xty;X;Y;XTX;XTY;res;cop;coyhat;fb;digl;cr
     
          ⍝∇  Given:   y -- dependent (response) variable
          ⍝∇           x -- independent vector
          ⍝∇           order -- the highest power in the Cheb. polynomials
          ⍝∇           vnames -- optional names for y and x (will default to Y X)
          ⍝∇  Result:  Chebyshev polynomial coefficients of the regression.
          ⍝∇           The advantage of Chebyshev polynomials is that they are
          ⍝∇           independent and orthogonal AND the coefficients are
          ⍝∇           interpretable: intercept, slope, curve, cubic wiggle, etc.
     
          ⍝ because the CPs are defined on particular points on the x axis, they won't
          ⍝ match the given x's.  So, get a Forsythe ortogonal regression first (based
          ⍝ on the x's), do regressions of the forsythe polynomials to find out what
          ⍝ they are, (couldn't find any closed, recursive formula), and then get
          ⍝ Forsythe y's at the Chebyshev x's and do the regression.
     
 ⎕ML←⎕IO←1
     
 To←{(×⍺-⍵)+⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 ns←⎕NS''
 :If 0=⎕NC'vnames' ⋄ vnames←'Y' 'X' ⋄ :EndIf
     
 io←⍋x
 x←x[io]     ⍝ make sure x is monotonic
 y←y[io]
 nd←≢y
 xM←⌈/x ⋄ xm←⌊/x
 hr←0.5×xM-xm     ⍝ range
 cl←0.5×xM+xm     ⍝ center
     
 cheb_x←Dutils.MakeChebyshevPolynomialX 0 nd
 hr÷←¯1↑cheb_x
 sx←(cl,1)÷hr
 xsf←(x-cl)÷hr
     
 nsf←vnames RegressForsythe(y x order)
 ns.Forsythe_ns←nsf
 fp←nsf.ForsythePolynomialsOnX
 fx←fp[;2]
 fbc←,⊂(0 1)             ⍝  "x" is centered.
           ⍝  get regressions for fp[;i]
 :For i :In 3 To order+1
     :Trap 0
         fbc,←⊂fp[;i]⌹fx∘.*¯1+⍳i
     :Else
         X←fx∘.*¯1+⍳i ⋄ Y←fp[;i]
         XTX←(⍉X)+.×X ⋄ XTY←Y+.×X
         res digl←2↑XTY Dutils.SolveSLAE XTX
         fbc,←⊂res
     :EndTrap
 :EndFor
          ⍝ Scale the cheb_x locations to span fx:  cheb_x spans ¯1 to 1
 xM←⌈/fx ⋄ xm←⌊/fx
 xhw←0.5×xM-xm     ⍝ range
 xc←0.5×xM+xm     ⍝ center
     
 cx←xc+xhw×cheb_x
     
          ⍝ Use the fbs to get cp
 cp←1,[1.5]cx
 :For i :In 2 To order
     cp,←(cx∘.*0,⍳i)+.×i⊃fbc
 :EndFor
     
          ⍝ Use the fbs to get cp
 fb←1,[1.5]fx
 :For i :In 2 To order
     fb,←(fx∘.*0,⍳i)+.×i⊃fbc
 :EndFor
     
 cy←cp+.×nsf.Coefficients
          ⍝  we now have an x and y to use:  cheb_x and cy
          ⍝  make the Chebyshev Polynmomials
 chp←Dutils.MakeChebyshevPolys cheb_x order
 chc←cy⌹chp
 cyhat←chp+.×chc
 cop←Dutils.MakeChebyshevPolys fx order
 coyhat←cop+.×chc
 cxo←cx+xhw+⊃x    ⍝  this corresponds to x
 xtx←+⌿chp*2
 xty←cy+.×cxo
 inv←÷{⍵+0.000001000001×⍵=0}xtx
     
     
          ⍝  The plots of x:y x:Yhat and cxo:cyhat  should make sense
          ⍝ 'a3'∆PADD'FP'(4.28 30)
          ⍝ 'a3'∆QP x y
          ⍝ 'a3'∆QP x nsf.Yhat
          ⍝ 'a3'∆QP cxo cyhat
          ⍝ 'a3'∆QT'X' 'y Yhat cyhat' 'Check on Forsythe and Cehbychev Regressions'
     
 ns.C_Yhat←cyhat
 ns.F_Yhat←nsf.Yhat
 ns.C_Coefficients←chc
 ns.ChebyshevPolyNomials←chp
 ns.Y←y
 ns.X←x
 ns.C_X←cxo
 ns.C_Y←cy
 cr←cy-cyhat
 ns.C_Residuals←cr
 ns.F_Residuals←nsf.Residuals
 ns.F_DigitsLost←nsf.DL
 ns.C_DigitsLost←0
     
          ⍝  Statistics need to come from the Forsythe regression.
          ⍝  The Chebylchev regression just copies the Forsythe.
     
 ns.(F_AnovaTable F_Results F_ResidualsTable F_Statistics F_Yhat F_Residuals)←nsf.(AnovaTable Results ResidualsTable Statistics Yhat Residuals)
∇

∇ {ns}←{vnames}RegressForsythe(y x order);⎕ML;⎕IO;n;nb;one;i;ib;xbar;fp;co;xtx;xty;b;ybar;xto;aone;dl;nsoc;inv;yhat;nsoo;nsos;in;tr;bp;bod;FPolyCoeffs;FPC
     
          ⍝∇ do an orthjogonal Forsythe Polynomial Regression      #.MOST.FORSY
                                                       ⍝ #.MOST.MOST∆M∆FORS_REGR
 ⎕ML←⎕IO←1                                   ⍝ #.MOST.MOST∆M∆FORSYTHE ≡ Dutils.ForsytheX
 ns←⎕NS''
     
 n←≢y
 :If 0=⎕NC'vnames' ⋄ vnames←'Y' 'Const',('X',¨⍕¨⍳¯1+≢x) ⋄ :EndIf
     
 nb←order+1
 one←n⍴1
     
 i←n n⍴1,n⍴0
 ib←nb nb⍴1,nb⍴0
     
 xbar←Dutils.Average x
 fp co←Dutils.MakeForsythePolys x order
 xtx←+⌿fp*2             ⍝  all off diagonal elements are 0 except for round-off
 xty←y+.×fp
 b←xty÷xtx              ⍝  therefore, don't need  ⌹
 yhat←fp+.×b
 ybar←⊃b
 xto←one+.×fp
 aone←xto÷xtx
 inv←÷{⍵+0.000001000001×⍵=0}xtx
     
 dl←0
 :Trap 0
     in←⌹(⍉fp)+.×fp
     tr←1 1⍉in
     bp←⌈/|tr
     in÷←bp
     (1 1⍉in)←0
     bod←⌈/,|in
     dl←2 Dutils.RndDP 0⌈17+10⍟|bod
 :EndTrap
     
 nsoc←Dutils.OrthoCalc(x y fp b xty xtx inv xbar ybar vnames)
 nsoo←Dutils.OrthoOut nsoc
 nsos←Dutils.OrthoStats nsoc
     
 ns.(AnovaTable Results ResidualsTable Statistics Yhat Residuals X Y DL Coefficients ForsythePolynomialsOnX)←nsoo.(AnovaT Result),nsos.(ResidTable Stats),nsoc.(yhat errs),x y dl b fp
 FPC←Dutils.ForsythePolynomialCoeficients ns
 ns.ForsythePolyCoeffs←FPC
∇

∇ {ns}←{vnames}RegressFourier(y x order);⎕ML;⎕IO;To;nd;nsf;fx;fyhat;xmin;xmax;xse;xs;ys;xtx;xty;xbar;ybar;ao;a;yhat;DL;ad;i;s;t;d;as;c;ac;inv;X;nsoc;nsoo;nsos;errs;error;yps
     
          ⍝∇  Given:   y -- dependent (response) variable
          ⍝∇           order -- the number of sine/cosine x vectors
          ⍝∇           vnames -- optional names for y and x (will default to Y X)
          ⍝∇  The sine/cosine indepenent vectors are based off of ⍳n, so I don't know
          ⍝∇    how y needs to be sampled, but using a yhat from a Forsythe regression to
          ⍝∇    re-express the original data, perhaps that would work for this as well.
     
 ⎕ML←⎕IO←1
     
 To←{(×⍺-⍵)+⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 ns←⎕NS''
 :If 0=⎕NC'vnames' ⋄ vnames←'Y' 'X' ⋄ :EndIf
 ns.Names←vnames
     
 nd←≢y
     
          ⍝  find  ys  values at the fourier  xs  interpolated into  x and y
           ⍝ to interpolate yhat we need nd points evenly spaced from xmin to xmax
 xmin←⌊/x ⋄ xmax←⌈/x
 xse←xmin+(¯1+⍳nd)×(xmax-xmin)÷nd-1
     
 xs←○2×(0,⍳nd-1)÷nd-1                                        ⍝ zero to 2×pi; uniformly spaced
 ys←Dutils.LagrangeInterpolation x y xse 8  ⍝ use a point interpolation
     
          ⍝  we now have a Fourier xs and ys
          ⍝                     because the sines and cosines are orthogonal over
          ⍝                     even spacings in x, the coefficients can be
          ⍝                     computed one at a time.  There generally isn't
          ⍝                     enough room to do the ∘.× game.  Order can be and
          ⍝                     usually is equal to nd, the no. of data values.
          ⍝
 order←1+2×⌈0.5×order                                    ⍝ but order must be odd.
     
 xtx←nd
 xty←+/ys
 xbar←Dutils.Average xs
 ybar←Dutils.Average ys
 ao←ybar   ⍝xty÷nd
 a←,ao
     
 yhat←nd⍴ao
 DL←0
 X←,[1.5]nd⍴1      ⍝0   ⍝¯0.3181266476387562   ⍝ turns out we need the full X matrix to calculate Cook statistics
     
 :For i :In ⍳0.5×order-1
     s←1○xs×i
     X,←s
     t←+/s×ys
     d←+/s*2
     as←t÷d
     yhat+←s×as
     xtx,←d
     xty←xty,t
     a,←as
 :EndFor
     
 :For i :In ⍳0.5×order-1
     c←2○xs×i
     X,←c
     t←+/c×ys
     d←+/c*2
     ac←t÷d
     yhat+←c×ac
     xtx,←d
     xty,←t
     a,←ac
 :EndFor
     
 error←y-yhat
 ns.Residuals←error
 ns.Yhat←yhat
          ⍝ ns.a←a
     
 yps←(X)+.×(a)
          ⍝ ns.psyhat←yps
          ⍝ ns.pserror←ys-yps
     
 inv←÷{⍵+0.000001000001×⍵=0}xtx
     
 nsoc←Dutils.OrthoCalc(x y X a xty xtx inv xbar ybar vnames)
 nsoc.yhat←yhat
 nsoo←Dutils.OrthoOut nsoc
 nsos←Dutils.OrthoStats nsoc
     
 ns.Coefficients←a
 ns.FourierXmatrix←X
 ns.Y←y
 ns.X←x
 ns.DigitsLost←0
 ns.(AnovaTable Results ResidualsTable Statistics)←nsoo.(AnovaT Result),nsos.(ResidTable Stats)
∇

∇ {NS}←{vnames}RegressMultipleLinear(y x);⎕ML;⎕IO;nd;X;ybar;xbar;nv;c;idof;cdof;tdof;edof;rdof;I;Ib;dl;as;a;CN;XTY;XTX;Yhat;ai;check;ns;nsc;nsr;nss;coeffs;const
     
          ⍝∇ Given:   y -- the response variable
          ⍝∇          x -- a nested vector of independent x variables
          ⍝∇               N.B. if the first x is a vector of 1s, its
          ⍝∇               coefficient is the "intercept".
          ⍝∇               If not the solution is "forced thru the origin".
          ⍝∇          vnames:  optional names for the y and x variables
          ⍝∇             e.g.:  'ProductQuality' 'Intercept' 'Volume' 'Time' 'Weight' 'Conc_1'  'Conc_2'
          ⍝∇ Result:  the coefficients of the regression
          ⍝∇          other results are saved in the namespace:  Regress_NS
          ⍝∇          this will include:  Anova for the analysis, various
          ⍝∇          statistics, predictions, residuals, etc.
     
 ⎕ML←⎕IO←1
 NS←⎕NS''
 const←∧/(⊃x)=1
 nd←≢y
 x←(⊂nd⍴1),⍣(~const)⊢x ⍝ For now, force intercept
 const←1
     
 :If 0=⎕NC'vnames'
     vnames←'Y'
     vnames,←const/⊂'Const'
     vnames,←('X',¨⍕¨⍳¯1+≢x)
 :EndIf
     
 X←↑[0.5]x
 ybar←Dutils.Average y
 xbar←⊃¨Dutils.Average¨x
 nv←≢x
     
          ⍝  although  c←y⌹X  does the job - because regression is particularly
          ⍝  suseptible to degenerate cases (correlated x's), I prefer
          ⍝  to solve the equations myself and monitor the pivots to estimate
          ⍝  singularity (matrix condition).
     
 :Trap 0
     NS.Coefs_byQuadDivide←c←y⌹↑[0.5]x
 :EndTrap
     
          ⍝  is the first variable a vector of 1s
 idof←∧/1=⊃x
 cdof←nv-idof
 tdof←nd
 edof←tdof-nv
 rdof←nd-idof
     
 I←nd nd⍴1,nd⍴0
 Ib←nv nv⍴1,nv⍴0
     
 XTX←(⍉X)+.×X
 XTY←(⍉X)+.×y
     
 coeffs dl ai a check CN←XTY Dutils.SolveSLAE XTX
     
 NS.Coefficients←coeffs
 NS.ConditionNumber←CN
 NS.DigitsLost←dl
     
     
 NS.Y←y
 NS.Xmatrix←X
 NS.Yhat←Yhat←X+.×coeffs
 NS.Residuals←y-Yhat
 NS.Y_name←⊃vnames
 NS.X_names←1↓vnames
     
 nsc←Dutils.RegressCalc X y coeffs XTY XTX ai xbar ybar Ib vnames
 nsr←Dutils.RegressResults nsc
 nss←dl Dutils.RegressStats nsc
     
 NS.X_CorrelationMatrix←(1↓vnames)CorrelMatrix↓[1]X
 NS.Max_Covariance←nsc.max_cov
     
 NS.(Results AnovaTable)←nsr.(Result AnovaR)
 NS.(Statistics ResidualsTable)←nss.(Stats ResidTable)
     
 :Return
∇

∇ {ns}←{vnames}RegressPolynomial(y x order);⎕ML;⎕IO;nd;nv;xbar;ybar;X;idof;cdof;tdof;edof;rdof;I;Ib;XTX;XTY;coeffs;dl;ai;a;check;CN;Yhat;nsc;nsr;nss
     
          ⍝∇ do a regular y←a+bx+cx^2+dx^3... regression
     
 ⎕ML←⎕IO←1
 ns←⎕NS''
     
 nd←≢y
 nv←order+1
     
 :If 0=⎕NC'vnames' ⋄ vnames←'Y' 'Const',('X',¨⍕¨⍳nv-1) ⋄ :EndIf
     
 xbar←Dutils.Average x
 ybar←Dutils.Average y
     
 X←x∘.*0,⍳order
     
           ⍝   the first variable is a vector of 1s
 idof←1
 cdof←nv-idof
 tdof←nd
 edof←tdof-nv
 rdof←nd-idof
     
 I←nd nd⍴1,nd⍴0
 Ib←nv nv⍴1,nv⍴0
     
 XTX←(⍉X)+.×X
 XTY←(⍉X)+.×y
     
 coeffs dl ai a check CN←XTY Dutils.SolveSLAE XTX
     
 ns.Coefficients←coeffs
 ns.ConditionNumber←CN
 ns.DigitsLost←dl
     
     
 ns.Y←y
 ns.X←x
 ns.Xmatrix←X
 ns.Yhat←Yhat←X+.×coeffs
 ns.Residuals←y-Yhat
 ns.X_CorrelationMatrix←(1↓vnames)CorrelMatrix X
     
 nsc←Dutils.RegressCalc X y coeffs XTY XTX ai xbar ybar Ib vnames
 nsr←Dutils.RegressResults nsc
 nss←dl Dutils.RegressStats nsc
 ns.MaxCovariance←nsc.max_cov
     
 ns.(Results AnovaTable)←nsr.(Result AnovaR)
 ns.(Statistics ResidualsTable)←nss.(Stats ResidTable)
 ns.Coefs_byQuadDivide←y⌹X
     
 ns.Y_name←⊃vnames
 ns.X_names←1↓vnames
∇

∇ {(xans dl)}←SimutaneousEquations(A R);ai;a;check;CN;⎕ML;⎕IO
     
          ⍝∇   Solve a set of simultaneous eqns:
          ⍝∇        aw + bx + cy + dz = r1        a b c d
          ⍝∇        ew + fx + gy + hz = r2   A ≡≡ e f g h   R ≡≡ r1 r2 r3 r4  Ans ≡≡ w x y z
          ⍝∇        iw + jx + ky + lz = r3        i j k l
          ⍝∇        mw + nx + oy + pz = r4        m n o p
     
 ⎕ML←⎕IO←1
     
 xans dl ai a check CN←R Dutils.SolveSLAE A
     
 :Return
∇

∇ ns←{names}Statistics vov;⎕ML;⎕IO;data;n;r;sum;sos;sum_of_squares;average;std_dev;sigma;diff;skew;kurtosis;max;min;coefficient_of_variation;pct_zero;pct_near_zero;std_error;table;statistics;stats;under;w;title;statistics_table;headr;bn;count
     
          ⍝∇ Calculate general statistics for a vector-of-vectors of data
 ⎕ML←⎕IO←1
 ns←⎕NS''
     
 data←vov                 ⍝ keep original data just in case
 n←≢data
 r←≢¨data
     
 sum←Dutils.SumByTwos¨data
 sos←sum_of_squares←Dutils.SumByTwos¨data×data
 average←Dutils.Average¨data
 std_dev←(|(sos-(sum*2)÷r)÷r-1)*0.5
 sigma←(|(sos-(sum*2)÷r)÷r)*0.5
     
 diff←data-¨average
 skew←Dutils.Moment¨(⊂¨diff),¨sigma,¨3
 kurtosis←Dutils.Moment¨(⊂¨diff),¨sigma,¨4
 count←≢¨data
 max←⌈/¨data
 min←⌊/¨data
     
 coefficient_of_variation←¯9999.99⌈9999.99⌊100×(std_dev÷average+average=0)×average≠0
 ((average≤0.000001×std_dev)/coefficient_of_variation)←¯1
 pct_zero←1 Dutils.RndDP 100×(+/¨data=0)÷r
 pct_near_zero←1 Dutils.RndDP 100×(+/¨0.000001>|data)÷r
 std_error←std_dev÷r*0.5
     
 statistics←{(⍳≢⍵),⍵}⍉↑count average min max std_dev skew kurtosis coefficient_of_variation pct_zero pct_near_zero
     
 stats←{(↑(⊂4 0)⍕¨⍳≢⍵),⍵}(11 0 13 4 13 4 13 4 13 4 8 2 8 2 10 2 6 1 6 1){⍺⍕⍵}⍉↑count average min max std_dev skew kurtosis coefficient_of_variation pct_zero pct_near_zero
     
 headr←'  V#  # of data    Average      Minimum      Maximum     Std. Dev.    Skew    Kurt.  Coef.Var   %0    %~0  '
 under←' ===  =========  ===========  ===========  ===========  ===========  ======  ======  ========  ====  ====  '
 w←≢headr
 title←w↑((⌊0.5×w-16)↑' '),'Basic Statistics'
 statistics_table←title⍪headr⍪under⍪w↑[2]stats
 :If 0=⎕NC'names' ⋄ names←(⊂'Var_'),¨⍕¨⍳n ⋄ :EndIf
 bn←2+5⌈⌈/≢¨names
 statistics_table,←' '⍪(bn↑'  Names')⍪('  ',2↓bn⍴'=')⍪(↑bn↑¨(⊂'  '),¨(bn)↑¨names)
     
 ns.(count average min max std_dev skew kurtosis coefficient_of_variation pct_zero pct_near_zero names)←count average min max std_dev skew kurtosis coefficient_of_variation pct_zero pct_near_zero names
 ns.(StatisticsTable Data_vov DataMatrix Statistics_numerical)←statistics_table data(⍉↑data)statistics
 ns.CorrelationMatrix←names CorrelMatrix vov
     
 :Return
∇

 StatsDoc←{
     _←⍬
     _,←⊂' generated by Dutils.MakeDoc  using   Dutils.Documentation     '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂'           Quickie Stats Summary                                               '
     _,←⊂79⍴' '
     _,←⊂'          {ns} ← Anova          v  levels  norm                                '
     _,←⊂'          {ns} ← AnovaPool      abt_mms_fr_il_al_si  (6 ⍬s with 1 substitution)'
     _,←⊂79⍴' '
     _,←⊂'          {ns} ← {vnames} RegressMultipleLinear  yv  xvov                      '
     _,←⊂'          {ns} ← {vnames} StepWiseAll            yv  xvov  Fr  Fa  (istart)    '
     _,←⊂'          {ns} ← {vnames} StepWiseOne            yv  xvov  Fr  Fa  (istart)    '
     _,←⊂'          {ns} ← {vnames} RegressPolynmomial     yv  xv    order               '
     _,←⊂'          {ns} ← {vnames} RegressFosythe         yv  xv    order               '
     _,←⊂'          {ns} ← {vnames} RegressChebyshev       yv  xv    order               '
     _,←⊂'          {ns} ← {vnames} RegressFourier         yv  xv    order               '
     _,←⊂'  {qvov names} ← ModelQuadratic                  vov                           '
     _,←⊂'         {vov} ← ModelChebyshev                  ndata order                   '
     _,←⊂79⍴' '
     _,←⊂'          {ns} ← PrincipleComponents    vov                                    '
     _,←⊂79⍴' '
     _,←⊂'          {ns} ← {vnames} Statistics    vov                                    '
     _,←⊂'          {cm} ← {vnames} CorrelMatrix  vov                                    '
     _,←⊂'          {ac} ← AutoCorr               v                                      '
     _,←⊂'          {cc} ← CrossCorr              v_stationary   v_losing_front          '
     _,←⊂'          {ns) ← CrossTabs              v1  v2                                 '
     _,←⊂79⍴' '
     _,←⊂'     {Xans DL} ← SimutaneousEquations   Amat RHSvector                         '
     _,←⊂79⍴' '
     _,←⊂'          {ft} ← DFT                    v                                      '
     _,←⊂'          {ft} ← FFT                    v                                      '
     _,←⊂'          {ns} ← IDFT                  fft                                     '
     _,←⊂'          {ns} ← IFFT                  fft                                     '
     _,←⊂'          {wv} ← {ww} TukeyWindow       v                                      '
     _,←⊂79⍴' '
     _,←⊂'         {vov} ← LeadLag                vov vup¯dn vfill cut_bot cut_top       '
     _,←⊂79⍴' '
     _,←⊂79⍴' '
     _,←⊂79⍴'-'
     _,←⊂'                       in    Stats.Distrib.                                    '
     _,←⊂'             x ← Normal_Xa    ⍺      returns the x for that distributio tail   '
     _,←⊂'             ⍺ ← Normal_Ax    x      returns the ⍺ for that x (distance from 0)'
     _,←⊂'             t ← Student_Tad  ⍺ dof  return critical student_t value           '
     _,←⊂'             ⍺ ← Student_Atd  t dof  return ⍺                                  '
     _,←⊂'             c ← ChiSq_Cad    ⍺ dof  return critical ChiSquare                 '
     _,←⊂'             a ← ChiSq_Acd    c dof  return alpha; given a ChiSquare and DOF   '
     _,←⊂'             f ← Fratio_Fand  ⍺ n d  return critical Fratio;  alpha dof_N dof_D'
     _,←⊂'             ⍺ ← Fratio_Afnd  F n d  return ⍺                                  '
     _,←⊂'             d ← Fratio_Dfan  F ⍺ n  return denominator degrees of freedom     '
     _,←⊂'                    and all of the other logical possibilities                 '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴'='
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' Anova:   n-way Analysis of Variance                                           '
     _,←⊂'              ns  ←  {FactorNames)  Anova  d  f  {p}                           '
     _,←⊂'  Arguments:                                                                   '
     _,←⊂'    d:  vector of data: logically partitioned with the first factor (A) going  '
     _,←⊂'                        the slowest (all values of the first level of A, then  '
     _,←⊂'                        all values for the second levcl of A, etc.) and the    '
     _,←⊂'                        replicates for each cell bunched together:             '
     _,←⊂'       A1 .........................................................    A2 .... '
     _,←⊂'       B1                             B2                  B3 ......    B1      '
     _,←⊂'       C1        C2        ......     C1         C2 ...   C1 C2 ...    C1  C2 .'
     _,←⊂'       D   all levels of D for A1,B1,C1; then all levels of D for A1,B1,C2; ...'
     _,←⊂'       R   (replicates of (A1,B1,C1,D1) R1 R2 ...) then                        '
     _,←⊂'           (replicates of (A1,B1,C1,D2)) R1 R2 ) ... etc.                      '
     _,←⊂79⍴' '
     _,←⊂'    f: the list of factor levels:  If A has 3 levels, B has 4 levels, C has 2  '
     _,←⊂'                          levels, D has 7 levels, and there are 5 replicates   '
     _,←⊂'                          for each case:  f ≡  3 4 2 7 5                       '
     _,←⊂'                          that means:  (≢d) ≡ 840                              '
     _,←⊂'    p: optional:  default=0 ≡ present in the order:  A  B  C ... AB AC ...     '
     _,←⊂'                          1 ≡ present as:  A B AB C AC BC ABC D AD ....        '
     _,←⊂79⍴' '
     _,←⊂'       There can be up to 15 factors with replicates.   The pattern must be    '
     _,←⊂'       complete: every level of A must have every level of each of the other   '
     _,←⊂'       factors, and every case must have the same number of replicates.        '
     _,←⊂'       The vector of numbers is logically the ravel of an n-dimensional matrix '
     _,←⊂'       that is A by B by C by ... by R. (d ≡ ,f ⍴ d)                           '
     _,←⊂79⍴' '
     _,←⊂'  Resultant output:  ns: A (shy) namespace containing the variables:           '
     _,←⊂'              ANOVA_Table   ANOVA_Averages   ANOVA_Residluals  and  ANOVA_Data '
     _,←⊂79⍴' '
     _,←⊂'   Try:  ns ← Anova (⍳64) (2 2 2 2 4)    {You can add error to the data:       '
     _,←⊂'                          ((⍳64)+(64 random numbers))(2 2 2 2 4)               '
     _,←⊂'                          At least Factor A (level 1 values: 1-32)(level 2     '
     _,←⊂'                          values: 33-64) will turn out to be significant for   '
     _,←⊂'                          reasonable sized error.  E.g.:  ((⍳64)+ (.1×64?64)   '
     _,←⊂79⍴' '
     _,←⊂'   If all experiments have replicate 1 first, then replicate 2, then 3, etc.   '
     _,←⊂'   i.e. replicate levelss are going the slowest not the fastest, they can be   '
     _,←⊂'   reordered using the transpose:     r_fast ← .... ⍉  r_slow                  '
     _,←⊂'   If the ≢d ≡ 60 and there are 5 replicates of 12 exeriments where factor a   '
     _,←⊂'   has 3 levels; b has 4 levels -- the logical rho of d is 5 3 4.  It needs to '
     _,←⊂'   be 3 4 5.  So:   d_good ← ,3 1 2 ⍉  5 3 4 ⍴ d_bad                           '
     _,←⊂79⍴' '
     _,←⊂'   My experience has shown that if there are missing data, just fill out the   '
     _,←⊂'   cell with the average (or expected average), and you will get the "big      '
     _,←⊂'   picture".  One way to test this is analyze some the replicates separately.  '
     _,←⊂'   The results should pretty much compare.  Truly significant factors should   '
     _,←⊂'   remain significant.                                                         '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' AnovaPool:   it sometimes helps to bunch some of the factors or interactions  '
     _,←⊂'              that have small F-ratios (large ⍺) into the error pool.          '
     _,←⊂'                  pns ← ns   AnovaPool   number_or_letters                     '
     _,←⊂79⍴' '
     _,←⊂'   Arguments:                                                                  '
     _,←⊂' R      a vector of 6 nulls with one of the nulls replaced (trailing nulls can '
     _,←⊂'        be ignored).                                                           '
     _,←⊂' L      the namespace from the full Anova.                                     '
     _,←⊂79⍴' '
     _,←⊂'   Result is a namespace with the variable:    Pooled_Anova_TAble              '
     _,←⊂79⍴' '
     _,←⊂'   Right argument meanings:                                                    '
     _,←⊂'        pns ← ns AnovaPool ABB {⍬ ⍬ ⍬ ⍬ ⍬}    ⍝ pool All But the "n" Biggest   '
     _,←⊂'                                                     mean squares              '
     _,←⊂'        pns ← ns AnovaPool ⍬ MMS {⍬ ⍬ ⍬ ⍬}    ⍝ pool factors/interactions with '
     _,←⊂'                                                     a mean square < Minimum   '
     _,←⊂'                                                     Mean Square               '
     _,←⊂'        pns ← ns AnovaPool ⍬ ⍬ FR {⍬ ⍬ ⍬}     ⍝ pool F_ratios smaller than FR  '
     _,←⊂'        pns ← ns AnovaPool ⍬ ⍬ ⍬ IL {⍬ ⍬}     ⍝ pool Interaction Levels IL and '
     _,←⊂'                                                     higher.  ABD ≡ 3rd level  '
     _,←⊂'                                                     interaction.              '
     _,←⊂'        pns ← ns AnovaPool ⍬ ⍬ ⍬ ⍬ AL {⍬}     ⍝ pool factors with an alpha ≥ AL'
     _,←⊂'        pns ← ns AnovaPool ⍬ ⍬ ⍬ ⍬ ⍬ SI       ⍝ pool factors that include these'
     _,←⊂'                                                     letters.  if SI ≡ BD then '
     _,←⊂79⍴' '
     _,←⊂'   for example:  pns ← ns AnovaPool 6             would pool all but the 6     '
     _,←⊂'                                                  biggest mean squares.        '
     _,←⊂'                 pns ← ns AnovaPool ⍬ ⍬ 2.3       would pool all F-ratios less '
     _,←⊂'                                                  than 2.3                     '
     _,←⊂'                 pns ← ns AnovaPool ⍬ ⍬ ⍬ 4       would pool all 4, 5, 6...-way'
     _,←⊂'                                                  interactions                 '
     _,←⊂'                 pns ← ns AnovaPool ⍬ ⍬ ⍬ ⍬ ⍬ BD  5 way Anova:  BD would pool  '
     _,←⊂'                                                  B D                          '
     _,←⊂'                                                  AB AD BC BD BE CD DE ABC ABD '
     _,←⊂'                                                  ABE ACD ADE BCD BCE BDE CDE  '
     _,←⊂'                                                  ABCD ABCE ABDE ACDE BCDE     '
     _,←⊂'                                                  ABCDE                        '
     _,←⊂'                                                  In a 5-way Anova (with       '
     _,←⊂'                                                  replicates) there are 31     '
     _,←⊂'                                                  interactions: +/5 10 10 5 1  '
     _,←⊂79⍴' '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' AutoCorr       find cyclical behavior                                         '
     _,←⊂'                   ac ← AutoCorr x                                             '
     _,←⊂79⍴' '
     _,←⊂'   Argument:     x:      a vector of numbers.                                  '
     _,←⊂'   Result:      ac:      a string of correllation coefficients of the x vector '
     _,←⊂'                         with itself shifted over one step at a time.          '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' CorrelationMatrix    the Pearson Correlation between all variables            '
     _,←⊂'                   cm ← CorrelationMatrix   vov                                '
     _,←⊂79⍴' '
     _,←⊂'   Argument:   vov:  a  vector_○f_data_vectors all of the same length          '
     _,←⊂'   Result:     cm:   a matrix of the correlation coefficient between each pair '
     _,←⊂'                     of variables.  The matrix is symetrical about the diagonal'
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' CrossCorr      determine a "time" shift between two variables                 '
     _,←⊂'                   cc ← CrossCorr  x y                                         '
     _,←⊂79⍴' '
     _,←⊂'   Arguments:  x y:   two vectors of equal length.                             '
     _,←⊂'   Result:     cc:    a string of correlation coefficients between the x vector'
     _,←⊂'                      and the y vector where succeeding values are dropped from'
     _,←⊂'                      the end of x and the beginning of y.  A "bump" would     '
     _,←⊂'                      indicate a correlation shifted in "time" where y lags x. '
     _,←⊂'                      Switching x and y would indicate x lagging y.            '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' CrossTabs      Chi-Square analysis of two "catagorical" vectors.              '
     _,←⊂'                    ns ← CrossTabs  v w                                        '
     _,←⊂79⍴' '
     _,←⊂'   Arguments:  v w:  two vectors of the same length of "categorical" data.     '
     _,←⊂'                     The variables a usualy coded to match the responses to    '
     _,←⊂'                     questionaires or otherwise counted data.                  '
     _,←⊂'                     v could be political party and w could be religion asked  '
     _,←⊂'                     of a group of people.  v might be coded: 1=Jewish,        '
     _,←⊂'                     2=Catholic, 3=Muslim, 4=Morman, etc.  w might be coded:   '
     _,←⊂'                     1=Democratic, 2=Republican, 3=Independent, 4=Communist....'
     _,←⊂'                     A matrix is formed that would have the count for each     '
     _,←⊂'                     pair of options.  The rows will be religion; the columns  '
     _,←⊂'                     will be party.                                            '
     _,←⊂'                     99 is interpreted as Missing and the data are uncounted.  '
     _,←⊂'                     ¯1 is interpreted as deliberately unanswered and excluded '
     _,←⊂'                     from the Chi-Square calculation.                          '
     _,←⊂'                     The question would then be: is the distribution of party  '
     _,←⊂'                     the same for all religions.  Row and column totals and    '
     _,←⊂'                     the grand total of the cells are calculated.  Each cell   '
     _,←⊂'                     value, if everything is "as expected", would be its row   '
     _,←⊂'                     total times its column total divided by the grand total.  '
     _,←⊂'                     The square of the sum of the deviations of cell values    '
     _,←⊂'                     from their expected values is a Chi-Square statistic with '
     _,←⊂'                     degrees-of-freedom being one less than the number of      '
     _,←⊂'                     active cells.  Chi-Square =1 : totally expected pattern   '
     _,←⊂'                                               =0 : unlikely pattern           '
     _,←⊂79⍴' '
     _,←⊂'   Result:   a namespace with the variables:                                   '
     _,←⊂'                     CT_ChiSquare_DOF  CT_Alpha  CT_Cell_Counts  CT_Deltas     '
     _,←⊂'                     CT_RowPercents  CT_ColumnPercents  CT_Overall_Percents    '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' Descrete Fourier Transforms                                                   '
     _,←⊂'       there are four functions: DFT FFT IDFT and IFFT                         '
     _,←⊂'       They all take a vector as an argument and all deliver two things:       '
     _,←⊂'             the expected output:  for DFT and FFT -- a complex vector         '
     _,←⊂'                                   for IDFT and IFFT -- a realvector           '
     _,←⊂'                                   a name space with: ComplexVector  Real Imag '
     _,←⊂'                                     Power  Phase and R_I_Matrix               '
     _,←⊂'                                     where the real and imaginary values <1E¯9 '
     _,←⊂'                                     have been forced to zero (usually created '
     _,←⊂'                                     by round-off error.                       '
     _,←⊂79⍴' '
     _,←⊂'      cvector ns  ←  DFT  x       (x is a real vector, usually a time series)  '
     _,←⊂'              The DFT is by the raw definition of a discrete transform and is  '
     _,←⊂'              of order n-squared.   That means slow for long x vectors >4000.  '
     _,←⊂'              The x vector can be of any length (an advantage).                '
     _,←⊂79⍴' '
     _,←⊂'      cvector ns  ←  FFT  x  (x is a real vector, usually a time series)       '
     _,←⊂'              The Fast Forier Transform is of order n log n.  Much faster.     '
     _,←⊂'              The length of the x vector should be a power of 2.  If it isn"t, '
     _,←⊂'              it is padded to the next power with zeros.                       '
     _,←⊂79⍴' '
     _,←⊂'      rvector ns  ← IDFT  c  (c: a complex vector, usually the output of a DFT)'
     _,←⊂'              The IDFT is by the raw definition of a inverse discrete transform'
     _,←⊂'               and is of order n-squared.   That means slow for long x vectors:'
     _,←⊂'               >4000.  The c vector can be of any length (an advantage).       '
     _,←⊂79⍴' '
     _,←⊂'      rvector ns  ← IFFT  c  (c: a complex vector, usually the output of a FFT)'
     _,←⊂'              The Fast Inverse Transform is of order n log n.  Much faster.    '
     _,←⊂'              The length of the x vector should be a power of 2.  If it isn"t, '
     _,←⊂'              it is padded to the next power with zeros.                       '
     _,←⊂79⍴' '
     _,←⊂'       You should expect  (⊃ IDFT ⊂ DFT x) to equal x to within round-off      '
     _,←⊂'                     and  (⊃ IFFT ⊂ FFT x) to equal x to within round-off      '
     _,←⊂79⍴' '
     _,←⊂'       If the padding is almost equal to the length of the data, the salient   '
     _,←⊂'       features of the power spectrum are pretty much the same when the actual '
     _,←⊂'       number of frequencies in x are few.                                     '
     _,←⊂'       Random noise of 100% of the "pure" signal leaves the bigger frequency   '
     _,←⊂'       bins recognizable!                                                      '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' LeadLag       line up the positions of sequelnced data                        '
     _,←⊂'              vov  ←  LeadLag  vov updown {fill {cut_bottom {cut_top}}}        '
     _,←⊂79⍴' '
     _,←⊂'   There are times when data are a function of time, that you need             '
     _,←⊂'   to "line stuff up".   Rainfall and river level for example.  The            '
     _,←⊂'   river sizes at a later time than when the rain fell.   What you             '
     _,←⊂'   order actually arrives later.  Some materials need to be ordered            '
     _,←⊂'   before others to have everyting ready for the construction job.             '
     _,←⊂'   Early decision college offers might be accepted earlier than                '
     _,←⊂'   regular offers.                                                             '
     _,←⊂79⍴' '
     _,←⊂'   Input:   related set (vector) of variables, (all the same length)           '
     _,←⊂'            an equal size vector of how much each variable should be           '
     _,←⊂'                 lifted (+) or pushed down (-) or left alone (0)               '
     _,←⊂'            what the "fill" value should be: "L" last value before             '
     _,←⊂'                 the fill or "Z" zero fill or "B" for blank (character         '
     _,←⊂'                 data) or a number (which could be 0).  Default=0.             '
     _,←⊂'            should the bottom of all variables be lopped off below the         '
     _,←⊂'                 bottom of the biggest "lifted" variable (1) or not (0)        '
     _,←⊂'                 Defaulted to 1.                                               '
     _,←⊂'            should the top of all variables be lopped off down to the          '
     _,←⊂'                 top of the biggest "pushed down" variable (1) or not (0)      '
     _,←⊂'                 Defaulted to 1.                                               '
     _,←⊂'   OutPut:  the shifted input data                                             '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' ModelChebyshev    make a series of Chebyshev polynomials                      '
     _,←⊂'             vop  ←  ModelChebyshev  nd order                                  '
     _,←⊂79⍴' '
     _,←⊂'   Input:      nd:  the number of data points for each polynomial              '
     _,←⊂'            order:  how many polynomials                                       '
     _,←⊂'   OutPut:  a vecctor of polynomials of increasing order                       '
     _,←⊂79⍴' '
     _,←⊂'       the advantage of these polynomials is that they are scaled ¯1 to 1 and  '
     _,←⊂'       most significantly they are orthogonal. I.e., their correlation matrix  '
     _,←⊂'       is the identity matrix.  Thus they can be used to do regressions safely '
     _,←⊂'       and the coefficients can be interpreted as slope, bend, wiggle, etc.    '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' ModelQuadratic    make every order 2 (squares and cross-products) out of vov  '
     _,←⊂'             qvov names  ←  ModelQuadratic vov                                 '
     _,←⊂79⍴' '
     _,←⊂'   Input:     vov:  a vector of data vectors                                   '
     _,←⊂'   Output:   qvov:  a vector of the squares and cross-products of the input.   '
     _,←⊂'            names:  identifiers for the qvov:  A B C D...AA BB...AB AC...BC....'
     _,←⊂'       qvov ≡  the original vectors, followed by their squares, followed by    '
     _,←⊂'               all of the unique cross prodlucts, in logical order             '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' PrincipalComponents      one orthogonalization of data                        '
     _,←⊂'             ns  ←  PrincipleComponents  data                                  '
     _,←⊂79⍴' '
     _,←⊂'   Input:  data:  a vector of vectors (padded with zeros to be of equal length)'
     _,←⊂'            or    a matrix with variables as columns                           '
     _,←⊂'   Output:   ns:  a namespace with:                                            '
     _,←⊂'        PCOMP_Table -- the entire picture of the analysis as text              '
     _,←⊂'     parts of that table  but as numbers                                       '
     _,←⊂'        PCOMP_Components -- columns in order of explained variance (numerical) '
     _,←⊂'                            indicating the "importance" of each data variable  '
     _,←⊂'                            in that component                                  '
     _,←⊂'        PCOMP_Percent -- variance explained by each component                  '
     _,←⊂'        PCOMP_CumulativePercent -- cum.% variance explained by each component  '
     _,←⊂'        PCOMP_EigenValues -- pivots generating the component matrix ("impact") '
     _,←⊂'     and                                                                       '
     _,←⊂'        PCOMP_factors -- the data expressed as "factors".  The "regression" of '
     _,←⊂'                         each data vector with the Components as coefficients  '
     _,←⊂'                         or weightings.                                        '
     _,←⊂'        PCOMP_FactorsSorted --Each factor sorted.  Indicates which data        '
     _,←⊂'                                  observations had the greatest impact.        '
     _,←⊂'        PCOMP_FactorCovarianceMatrix -- cross-product of the factors           '
     _,←⊂'        PCOMP_DataCorrelationMatrix -- correlations of the data                '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' RegressChebyshev         regression using orthogonal Chebyshev variables      '
     _,←⊂'            ns ← {var_names} RegressChebyshev y x order                        '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:  right:     y:  the dependent (response) variable (Y)               '
     _,←⊂'                       x:  the independent (X) variable                        '
     _,←⊂'                   order:  the highest power Chebyshev polynomial              '
     _,←⊂'            left:  variable names for Y and X.  Defaults to "Y" and "X".       '
     _,←⊂'   Output:  a namespace with the Forsythe regression namespace, and the results'
     _,←⊂'            of the Chebyshev regression                                        '
     _,←⊂79⍴' '
     _,←⊂'      Because a Chebyshev regression requires the X values to be at particuarly'
     _,←⊂'      located positions, The data are first regressed with Forlsythe Orthogonal'
     _,←⊂'      polynomials (orthogonality insures that the regression will not fail).   '
     _,←⊂'      That regression is then used to calculate Y values at the Chebyshev X    '
     _,←⊂'      values.  Then the C_Y and C_polynomials (based on C_X) can be computed.  '
     _,←⊂'      The underlying statistics and Anova are those of the Forsythye regression'
     _,←⊂'      The reason for doing the Chebyshev regression is that the coefficients   '
     _,←⊂'      are interpretable. The first C_coefficient is the average of C_Y (not Y).'
     _,←⊂'      The second coefficient is the tilt or slope of the data.  The third is   '
     _,←⊂'      the parabolic bend to the data.  The fourth is the "cubic" wiggle.  etc. '
     _,←⊂'      Given that Chebyshev polynomials have maximum amplitudes of +-1, you get '
     _,←⊂'      a glimpse of the "shape" of your Y data.  Thus it is easy to compare sets'
     _,←⊂'      of Y data.                                                               '
     _,←⊂79⍴' '
     _,←⊂'      Things contained in the output namespace:                                '
     _,←⊂'          Results of the Fourier Regression:  its output namespace: Fourier_ns '
     _,←⊂'            as well as some extracted info:                                    '
     _,←⊂'              F_Yhat  F_Statistics  F_Residuals  F_ResultTable  F_AnovaTAble   '
     _,←⊂'              F_ResidualsTable F_DigitsLost (due to regression: usually 0)     '
     _,←⊂'          Results of the Chebyshev regression:                                 '
     _,←⊂'              C_Coefficients  C_X  C_Y  C_Yhat  C_Residuals  C_DigitsLost      '
     _,←⊂'              and the ChebyshevPolynomials                                     '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' RegressForsythe     an orthogonal regression                                  '
     _,←⊂'            ns ← {var_names} RegressForsythev y x order                        '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:  right:                                                             '
     _,←⊂'                       y:  the dependent (response) variable (Y)               '
     _,←⊂'                       x:  the independent (X) variable                        '
     _,←⊂'                   order:  the highest power Chebyshev polynomial              '
     _,←⊂'            left:                                                              '
     _,←⊂'                   variable names for Y and X.  Defaults to "Y" and "X".       '
     _,←⊂'   Output:  a namespace with Forsythe regression results:                      '
     _,←⊂79⍴' '
     _,←⊂'      Because the Forsythe polynomials are orthogonal, there is no loss of     '
     _,←⊂'      accuracy in the solution due to inter-correlation of the "X" variables as'
     _,←⊂'      there is with a straight polynomial regression.                          '
     _,←⊂79⍴' '
     _,←⊂'      The name space includes:                                                 '
     _,←⊂'           X  Y  Yhat  Coefficients  Results  AnovaTable  Statistics           '
     _,←⊂'           Residuals  ResidualsTable                                           '
     _,←⊂'           ForsythePolynomialsOnX  ForsytheCoeffs                              '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' RegressFourier      a regression using sines and cosines                      '
     _,←⊂'            ns ← {var_names} RegressFourier y x order                          '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:  right:     y:  the dependent (response) variable (Y)               '
     _,←⊂'                       x:  the independent (X) variable                        '
     _,←⊂'                   order:  the number of (sine and cosine) terms               '
     _,←⊂'            left:  names for Y and X.  Defaults to "Y" and "X".                '
     _,←⊂79⍴' '
     _,←⊂'   Output:  a namespace with Fourier regression results:                       '
     _,←⊂'              Names X  Y  Yhat  Residuals  ResidualsTable                      '
     _,←⊂'              AnovaTable  Results  Statistics  DigitsLost                      '
     _,←⊂'              FourierXmatrix:  columns:  1  Sine Cosine S C S C ...            '
     _,←⊂'              Coefficients:    constant sine cos sin cos ...                   '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' RegressMultipleLinear      standard regression (not done as y⌹x)              '
     _,←⊂'            ns  ←  (var_names) RegressMultipleLinear y vov                     '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:  right:     y:  the dependent (response) variable (Y)               '
     _,←⊂'                     vov:  the independent (X) variables (vectors)             '
     _,←⊂'            left:  names for Y and Xs.  Defaults to "Y" and "X1" "X2" "X3" ... '
     _,←⊂79⍴' '
     _,←⊂'   Output:  a namespace with regression results:                               '
     _,←⊂'              Xmatrix  Y  Yhat  Residuals  ResidualsTable                      '
     _,←⊂'              AnovaTable  Results  Statistics  DigitsLost  ConditionNumber     '
     _,←⊂'              Coefficients  Coefs_byQuadDivide  X_names  Y_name                '
     _,←⊂'              Max_Covariance  X_CorrelationMatrix                              '
     _,←⊂79⍴' '
     _,←⊂'         If you are working on a 16 digit platform, 16-DigitsLost is about how '
     _,←⊂'         many reliable digits there are in the coefficients.  If that is less  '
     _,←⊂'         3, I wouldn"t trust the results (due to correlation between the Xs).  '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' RegressPolynomial      standard regression on powers of x (not done as y⌹x)   '
     _,←⊂'            ns  ←  (var_names) RegressPolynomial y x                           '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:  right:     y:  the dependent (response) variable (Y)               '
     _,←⊂'                       x:  the independent (X) variable                        '
     _,←⊂'            left:  names for Y and Xs.  Defaults to "Y" and "X1" "X2" "X3" ... '
     _,←⊂79⍴' '
     _,←⊂'   Output:  a namespace with regression results:                               '
     _,←⊂'              Xmatrix  X  Y  Yhat  Residuals  ResidualsTable                   '
     _,←⊂'              AnovaTable  Results  Statistics  DigitsLost  ConditionNumber     '
     _,←⊂'              Coefficients  Coefs_byQuadDivide  X_names  Y_name                '
     _,←⊂'              Max_Covariance  X_CorrelationMatrix                              '
     _,←⊂79⍴' '
     _,←⊂'         If you are working on a 16 digit platform, 16-DigitsLost is about how '
     _,←⊂'         many reliable digits there are in the coefficients.  If that is less  '
     _,←⊂'         3, I wouldn"t trust the results (due to correlation between the Xs).  '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' SimultaneousEquations        solve a set of linear algebraic equations        '
     _,←⊂'                 soln_vector  digits_lost  ←  SimultaneousEquations Amat Rhs   '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:  Amat -- the coefficients matrix                                    '
     _,←⊂'             Rhs -- the right hand side                                        '
     _,←⊂79⍴' '
     _,←⊂'   The solutions is not done by:  Rhs ⌹ Amat , but rather in a manner that     '
     _,←⊂'   checks the pivots to estimate digit_lost.   When working on a 16 digit      '
     _,←⊂'   platform, 16-digits_lost is about how many reliable digits there are in the '
     _,←⊂'   solution.  If this falls below 3, I wouldn"t trust the results at all.      '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' Statistics           get means, std.dev, etc for a set of x vectors           '
     _,←⊂'               ns  ←  {names}  Statistics  vov                                 '
     _,←⊂79⍴' '
     _,←⊂'   Input:      vov:  a vector of variable vectors.                             '
     _,←⊂'             names:  optional names for the variables                          '
     _,←⊂'   Output:   ns:  a namespace containing:                                      '
     _,←⊂'                  StatisticsTable  Data_vov                                    '
     _,←⊂'                  DataMatrix (padded with zeros if necessary)                  '
     _,←⊂'                  CorrelationMatrix (of DataMatrix)                            '
     _,←⊂'                  and all of the measures in the table individually numerical  '
     _,←⊂'                      vectors, just in case you want to use them.              '
     _,←⊂79⍴' '
     _,←⊂'                  Statistics table lists for each variable:                    '
     _,←⊂'                      IndesCount  Average  Min  Max  Std_dev  Skew  Kurtosis   '
     _,←⊂'                      Coefficient_of_variation  %_=_0  %_near_0  {name}        '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' StepWiseAll       multiple linear regression all allowable variables per step '
     _,←⊂'            ns  ←  {yxnames}  StepWiseAll  y  vox  fi  fo (starting_indecies)  '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:      y:  the dependent variable to be fitted with x                 '
     _,←⊂'              vox:  a vector of the independent variables                      '
     _,←⊂'               fi:  the lower limit of Fratio among the "out" variables that   '
     _,←⊂'                    will determine it they are allowed "in".                   '
     _,←⊂'               fo:  the Fratio limit below which an "in" variable will be      '
     _,←⊂'                    kicked out.                                                '
     _,←⊂'               si:  The indecies of x variables that are initially "in" the    '
     _,←⊂'                    regression.  This can include any legitimate index,        '
     _,←⊂'                    including ⍬ and all of them.                               '
     _,←⊂'          yxnames:  a vector of optional variable names starting with the Y    '
     _,←⊂'                    variable.  It must have 1+#_of_X_variables text names.     '
     _,←⊂79⍴' '
     _,←⊂'   Output:  ns:  a namespace containing for the final regression:              '
     _,←⊂'                     AnovaTable            distribution of sums_of_squares     '
     _,←⊂'                     Coefficients          not done by y⌹x                     '
     _,←⊂'                     Results               stats for each variable             '
     _,←⊂'                     Coefs_byQuadDivide                                        '
     _,←⊂'                     DigitsLost            on a 16 digit platform 16-DL <3 or 4'
     _,←⊂'                                           is worrisome                        '
     _,←⊂'                     ConditionNumber                                           '
     _,←⊂'                     In_Indecies  Out_Indecies                                 '
     _,←⊂'                     In_Names  Out_Names                                       '
     _,←⊂'                     Y_name     X_names                                        '
     _,←⊂'                     Max_Covariance                                            '
     _,←⊂'                     Statistics            including residuals analyses        '
     _,←⊂'                     Xmatrix  Y  Yhat                                          '
     _,←⊂'                     Residuals             (Y-Yhat)                            '
     _,←⊂'                     ResidualTable                                             '
     _,←⊂'                     X_CorrelationMatrix   of the "in"s                        '
     _,←⊂'                 and for the process:                                          '
     _,←⊂'                     InOut_path            what happened at each step          '
     _,←⊂'                     In_Table              statistics for each step regression '
     _,←⊂'                     Out_Table             statistics for each step regression '
     _,←⊂'                     progress              the Fratios along the way           '
     _,←⊂'                     NsIn   NsOut          the last step"s regression info     '
     _,←⊂79⍴' '
     _,←⊂'      If you believe that the regression should include a constant, one of the '
     _,←⊂'      x variables (usually the first) should be all ones.                      '
     _,←⊂79⍴' '
     _,←⊂'      This regression process is iterative.  At each pass a regression is done '
     _,←⊂'      on the "in" variables and on the "out" variables.  This provides Fratios '
     _,←⊂'      that determine if any "in"s should be removed and if any "outs" should be'
     _,←⊂'      added to the "in"s.  Although most of the time this is done in one pass, '
     _,←⊂'      that is not necessarilly so.  The steps taken are itemized in the output '
     _,←⊂'      namespace as the variable:  InOut_path.                                  '
     _,←⊂79⍴' '
     _,←⊂'      All regressions are done by row reduction in order to watch the pivots   '
     _,←⊂'      to measure the degree of singularity of the  process.  This is           '
     _,←⊂'      particularly relevant in regressons involving correlated xs.  On a 16    '
     _,←⊂'      digit platform, losing 7 or 8 digits leaves answers good to 9 or 8       '
     _,←⊂'      digits.  Losing more than 13 means that you probably can"t believe the   '
     _,←⊂'      results at all.                                                          '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' StepWiseOne       multiple linear regression only one variable at a time      '
     _,←⊂'            ns  ←  {yxnames}  StepWiseOne  y  vox  fi  fo (starting_indecies)  '
     _,←⊂79⍴' '
     _,←⊂79⍴' '
     _,←⊂' StepWiseAll       multiple linear regression allowable steps at a time        '
     _,←⊂'            ns  ←  {yxnames}  StepWiseAll  y  vox  fi  fo (starting_indecies)  '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:      y:  the dependent variable to be fitted with x                 '
     _,←⊂'              vox:  a vector of the independent variables                      '
     _,←⊂'               fi:  the lower limit of Fratio among the "out" variables that   '
     _,←⊂'                    will determine it they are allowed "in".                   '
     _,←⊂'               fo:  the Fratio limit below which an "in" variable will be      '
     _,←⊂'                    kicked out.                                                '
     _,←⊂'               si:  The indecies of x variables that are initially "in" the    '
     _,←⊂'                    regression.  This can include any legitimate index,        '
     _,←⊂'                    including ⍬ and all of them.                               '
     _,←⊂'          yxnames:  a vector of optional variable names starting with the Y    '
     _,←⊂'                    variable.  It must have 1+#_of_X_variables text names.     '
     _,←⊂79⍴' '
     _,←⊂'   Output:  ns:  a namespace containing for the final regression:              '
     _,←⊂'                     AnovaTable            distribution of sums_of_squares     '
     _,←⊂'                     Coefficients          not done by y⌹x                     '
     _,←⊂'                     Results               stats for each variable             '
     _,←⊂'                     Coefs_byQuadDivide                                        '
     _,←⊂'                     DigitsLost            on a 16 digit platform 16-DL <3 or 4'
     _,←⊂'                                           is worrisome                        '
     _,←⊂'                     ConditionNumber                                           '
     _,←⊂'                     In_Indecies  Out_Indecies                                 '
     _,←⊂'                     In_Names  Out_Names                                       '
     _,←⊂'                     Y_name     X_names                                        '
     _,←⊂'                     Max_Covariance                                            '
     _,←⊂'                     Statistics            including residuals analyses        '
     _,←⊂'                     Xmatrix  Y  Yhat                                          '
     _,←⊂'                     Residuals             (Y-Yhat)                            '
     _,←⊂'                     ResidualTable                                             '
     _,←⊂'                     X_CorrelationMatrix   of the "in"s                        '
     _,←⊂'                 and for the process:                                          '
     _,←⊂'                     InOut_path            what happened at each step          '
     _,←⊂'                     In_Table              statistics for each step regression '
     _,←⊂'                     Out_Table             statistics for each step regression '
     _,←⊂'                     progress              the Fratios along the way           '
     _,←⊂'                     NsIn   NsOut          the last step"s regression info     '
     _,←⊂79⍴' '
     _,←⊂'      If you believe that the regression should include a constant, one of the '
     _,←⊂'      x variables (usually the first) should be all ones.                      '
     _,←⊂79⍴' '
     _,←⊂'      This regression process is iterative.  At each pass a regression is done '
     _,←⊂'      on the "in" variables and on the "out" variables.  This provides Fratios '
     _,←⊂'      that determine if any "in"s should be removed and if any "outs" should be'
     _,←⊂'      added to the "in"s.  First one out→in variable will be chosen if one is  '
     _,←⊂'      available.  When all "out"s can"t get in, one "in" variable is selected  '
     _,←⊂'      if available.  When no variable can move the process stops.  The steps   '
     _,←⊂'       taken are itemized in the output namespace as the variable:  InOut_path '
     _,←⊂79⍴' '
     _,←⊂'      All regressions are done by row reduction in order to watch the pivots   '
     _,←⊂'      to measure the degree of singularity of the  process.  This is           '
     _,←⊂'      particularly relevant in regressons involving correlated xs.  On a 16    '
     _,←⊂'      digit platform, losing 7 or 8 digits leaves answers good to 9 or 8       '
     _,←⊂'      digits.  Losing more than 13 means that you probably can"t believe the   '
     _,←⊂'      results at all.                                                          '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' TukeyWindow      "round off" the ends of a vector                             '
     _,←⊂'                  wv  ←  {window_width}  TukeyWindow  v                        '
     _,←⊂79⍴' '
     _,←⊂'   Inputs:       v:  a reasonably long vector                                  '
     _,←⊂'               w_w:  optionally the fraction of the data effected at each end. '
     _,←⊂'                     Defaults to .25; affecting a quarter of the input vector  '
     _,←⊂'                     on each end.                                              '
     _,←⊂'   Output:      wv:  the windowed vector.                                      '
     _,←⊂79⍴' '
     _,←⊂'          v is usually a sound signal: music, speech, an accustic event or     '
     _,←⊂'          noise recording                                                      '
     _,←⊂'.                                                                              '
     _,←⊂'          Apply the original Tukey-Interim-Window.  This is "cosine" rounding  '
     _,←⊂'          at each end of a time string to improve the apparent power spectrum  '
     _,←⊂'          and Fourier Transform (DFT and FFT).  Sharp "edges" cause spurious   '
     _,←⊂'          harmonics in the FFT, and this is supposed to reduce that problem.   '
     _,←⊂79⍴' '
     _,←⊂'     cosine: goes 1 to ¯1  <::>  1-cos  goes 0 to 2  <::>  ÷ by 2  goes 0 to 1 '
     _,←⊂79⍴' '
     _,←⊂'                                 *---.....---*                                 '
     _,←⊂'                              *                 *                              '
     _,←⊂'                           *                       *                           '
     _,←⊂'                          *                         *                          '
     _,←⊂'                         *                           *                         '
     _,←⊂'                      *                                 *                      '
     _,←⊂'                ****                                       ****                '
     _,←⊂79⍴' '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴'='
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' Distrib      a namespace with functions that calculate various distributions. '
     _,←⊂79⍴' '
     _,←⊂'             P p :: the cumulative probability (integral from the left (1-⍺)   '
     _,←⊂'             A ⍺ :: the tail probability (integral to the right)      (1-p)    '
     _,←⊂'             C c :: critical ChiSquare                                         '
     _,←⊂'             D d :: degrees of freedom:   DOF  (for F_ratio: denominator DOF)  '
     _,←⊂'             N n :: degrees of freedom:   numerator DOF for F_ratio            '
     _,←⊂'             F f :: critical F_ratio                                           '
     _,←⊂'          big letter ≡ return  ⋄  little letters ≡ RighttHandArg               '
     _,←⊂79⍴' '
     _,←⊂79⍴' '
     _,←⊂79⍴'-'
     _,←⊂' Normal:    ⍺ ← Normal_A     x      you give it x, it returns ⍺ (tail beyond x)'
     _,←⊂'            p ← Normal_P     x      returns integral up to x                   '
     _,←⊂'            y ← Normal_y     x      the ordinate of the normal curve at x      '
     _,←⊂'            x ← Normal_Xa    ⍺      returns the x for that ⍺                   '
     _,←⊂'            x ← Normal_Xp    p      returns the x for that cumulative dist.    '
     _,←⊂79⍴' '
     _,←⊂79⍴' '
     _,←⊂79⍴'-'
     _,←⊂' student t: ⍺ ← Student_A    t dof  return ⍺ for a given t and deg_of_freedom  '
     _,←⊂'            p ← Student_P    t dof  return p   the most common usage           '
     _,←⊂'            ⍺ ← Student_Atd  t dof  return ⍺   same as Student_A but consistant'
     _,←⊂'            p ← Student_Ptd  t dof  return p                                   '
     _,←⊂79⍴' '
     _,←⊂'            t ← Student_Tad  ⍺ dof  return t                                   '
     _,←⊂'            t ← Student_Tpd  p dof  return t                                   '
     _,←⊂'            d ← Student_Dta  t ⍺    return Degrees_Of_Freedom  (DOF)           '
     _,←⊂'            d ← Student_Dtp  t p    return DOF                                 '
     _,←⊂79⍴' '
     _,←⊂79⍴' '
     _,←⊂79⍴'-'
     _,←⊂' ChiSquare: ⍺ ← ChiSq_A      c dof  given ChiSq and DOF return alpha           '
     _,←⊂'            p ← ChiSq_P      c dof  given ChiSq and DOF return p (cum. dist.)  '
     _,←⊂'            ⍺ ← ChiSq_Acd    c dof  given ChiSq and DOF return alpha           '
     _,←⊂'            p ← ChiSq_Pcd    c p    given ChiSq and DOF return p               '
     _,←⊂79⍴' '
     _,←⊂'            c ← ChiSq_Cad    ⍺ dof  given ⍺ and dof return critical ChiSquare  '
     _,←⊂'            c ← ChiSq_Cpd    p dof  given cum.dist. return critical ChiSquare  '
     _,←⊂'            d ← ChiSq_Dca    c ⍺    given ChiSq and ⍺ return DOF               '
     _,←⊂'            d ← ChiSq_Dcp    c p    given ChiSq and p return DOF               '
     _,←⊂79⍴' '
     _,←⊂'            ? ← ChiSq_CAD    c ⍺ d  substitute one of inputs with ⍬, get that  '
     _,←⊂'                                    c ← ChiSq_CAD ⍬ ⍺ d                        '
     _,←⊂'                                    ⍺ ← ChiSq_CAD c ⍬ d                        '
     _,←⊂'                                    d ← ChiSq_CAD c ⍺     or C ⍺ ⍬             '
     _,←⊂'            ? ← ChiSq_CPD    c p d  substitute one of inputs with ⍬, get that  '
     _,←⊂79⍴' '
     _,←⊂79⍴'-'
     _,←⊂' F_ratio    ⍺ ← Fratio_A     F n d  return ⍺    the most common usage          '
     _,←⊂'            p ← Fratio_P     F n d  return p    "                              '
     _,←⊂'            ⍺ ← Fratio_Afnd  F n d  return ⍺    same as Fratio_A but consistant'
     _,←⊂'            p ← Fratio_Pfnd  F n d  return p                                   '
     _,←⊂79⍴' '
     _,←⊂'            f ← Fratio_Fand  ⍺ n d  return critical F_ratio                    '
     _,←⊂'            f ← Fratio_Fpnd  p n d  return critical F_ratio                    '
     _,←⊂'            n ← Fratio_Nfad  f ⍺ d  return critical F_ratio                    '
     _,←⊂'            n ← Fratio_Nfpd  f p d  return critical F_ratio                    '
     _,←⊂'            d ← Fratio_Dfan  f ⍺ d  return critical F_ratio                    '
     _,←⊂'            d ← Fratio_Dfpn  f p n  return critical F_ratio                    '
     _,←⊂79⍴' '
     _,←⊂'            ? ← Fratio_FAND  f ⍺ n d  subst. 1 arg. with ⍬, get that one       '
     _,←⊂'            ? ← Fratio_FPND  f p n d  subst. 1 arg. with ⍬, get that one       '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     _,←⊂79⍴'='
     _,←⊂79⍴'='
     _,←⊂79⍴' '
     _,←⊂' Dutils    a namespace with functions used by the statistical and distributio  '
     _,←⊂'           functions.  Not particularly for general use (but not worthless).   '
     _,←⊂79⍴' '
     _,←⊂79⍴'='
     ↑_
 }

∇ NS←{yx_names}StepWiseAll(y vox fic foc i_in);r;i_x;i_out;x;headr;under;table;phead;pundr;progress;ok;ns_in;ns_out;cr;ca;mo;ma;rem;add;i;io;NO;Xnames;Yname;InTable;OutTable;NI;mout;min;out;in;coef;nr;list;in_collection;fo;Y_name;X_names;⎕ML;⎕IO
 ''
 ''
          ⍝∇ Given a y and several x's (include 1 to get a constant), Fin Fout vin_start_indexes
     
          ⍝     do a regression of  "ins"
          ⍝     do a regression of  "outs"
          ⍝     find if there are variables to add or variables to remove
          ⍝     move the selected variables
          ⍝     repeat
     
 ⎕ML←⎕IO←1
 NS←⎕NS''                   ⍝  this will get filled with results
 i_in←,i_in
     
     
 :If (0≠⎕NC'yx_names')
     Y_name←⊃yx_names
     X_names←1↓yx_names
 :Else
     X_names←(⊂'Var_'),¨⍕¨⍳≢xs
     Y_name←'Y'
 :EndIf
 NS.X_names←X_names
 NS.Y_name←Y_name
     
 x←↑[0.5]vox
 r←≢y
 i_x←⍳≢vox
 i_out←i_x~i_in
     
          ⍝ if starting empty, pick up the highest F for all
 :If ⍬≡⍴i_in
     NO←Dutils.DoStepRegression y(x)
     fo←NO.F_ix ⋄ i_in←,fo⍳⌈/fo ⋄ i_out~←i_in
 :EndIf
     
 progress←1 7⍴' i ' 'lose' 'gain' 'F_lose' 'F_gain' 'F_in' 'F_out'
 InTable←1 7⍴' i ' 'F_ratio' 'unexp. var.' ' Durb-W' '   big res ' ' dig lost' 'In vars'
 OutTable←1 7⍴' i ' 'F_ratio' 'unexp. var.' ' Durb-W' '   big res ' ' dig lost' 'Out vars'
 io←1 5⍴' i' '# in' '# out' 'Indices In' 'Indices Out'
 io⍪←0(≢i_in)(≢i_out)i_in i_out
     
          ⍝  Loop until done
 ok←1 ⋄ i←0 ⋄ in_collection←⊂i_in
 :While ok
     i+←1
          ⍝  regress    "in"   and   "out"
     NI←Dutils.DoStepRegression y(x[;i_in])
     InTable⍪←i,NI.(F_ratio sos_err DurbinWatson big_e DL),⊂i_in
     NO←Dutils.DoStepRegression NI.errs(x[;i_out])
     OutTable⍪←i,NO.(F_ratio sos_err DurbinWatson big_e DL),⊂i_out
     
     mout←NI.F_ix<foc ⋄ out←mout⌿i_in
     min←NO.F_ix≥fic ⋄ in←min⌿i_out
     
     :If (in≡⍬)∧(out≡⍬) ⋄ :Leave ⋄ :EndIf
     
     i_in←{⍵[⍋⍵]}(i_in,in)~out
     i_out←i_x~i_in
     
     io⍪←i(≢i_in)(≢i_out)i_in i_out
     progress⍪←i(⊂out)(⊂in)(⊂mout/NI.F_ix)(⊂min/NO.F_ix)NI.F_ratio NO.F_ratio
     
     :If (⊂i_in)∊in_collection ⋄ :Leave ⋄ :EndIf
     in_collection,←⊂i_in
 :EndWhile
     
            ⍝  final clean-up
 coef←NI.coeff ⋄ ok←(|coef)>1E¯8
 i_out←{⍵[⍋⍵]}i_out,(~ok)/i_in
 i_in←ok/i_in
     
 nr←((⊂Y_name),X_names[i_in])RegressMultipleLinear y(vox[i_in])
 list←⍕(nr.⎕NL-2)~'X_names' 'Y_name'
     
          ⍝  pack up NS
 NS.(progress In_Table Out_Table In_Names In_Indecies Out_Names Out_Indies NsIn NsOut InOut_path)←progress InTable OutTable(X_names[i_in])i_in(X_names[i_out])i_out NI NO io
 ⍎'NS.(',list,')←nr.(',list,')'
     
 :Return
∇

∇ NS←{yx_names}StepWiseOne(y vox fic foc i_in);r;i_x;i_out;x;headr;under;table;phead;pundr;progress;ok;ns_in;ns_out;cr;ca;mo;ma;rem;add;i;io;inext;in_collection;NI;NO;fi;fo;fri;fro;max_fo;nii;min_fi;nio;nr;list;coef;OutTable;InTable;Xnames;Yname;X_names;Y_name
 ''
 ''
     
          ⍝∇ Given a y and several x's (include 1 to get a constant), Fin Fout vin_start_indexes
     
          ⍝     do a regression of  "ins"
          ⍝     do a regression of  "outs"
          ⍝     decide if there is a variable to remove or, if not, a variable to remove
          ⍝     move the selected variable
          ⍝     repeat
     
 ⎕ML←⎕IO←1
 NS←⎕NS''                   ⍝  this will get filled with results
 i_in←,i_in
     
 :If (0≠⎕NC'yx_names')
     Y_name←⊃yx_names
     X_names←1↓yx_names
 :Else
     X_names←(⊂'Var_'),¨⍕¨⍳≢vox
     Y_name←'Y'
 :EndIf
 NS.X_names←X_names
 NS.Y_name←Y_name
     
 x←↑[0.5]vox
 r←≢y
 i_x←⍳≢vox
 i_out←i_x~i_in
     
          ⍝ if starting empty, pick up the highest F for all
 :If ⍬≡⍴i_in
     NO←Dutils.DoStepRegression y(x)
     fo←NO.F_ix ⋄ i_in←,fo⍳⌈/fo ⋄ i_out~←i_in
 :EndIf
     
 progress←1 7⍴' i ' 'lose' 'gain' 'F_lose' 'F_gain' 'F_in' 'F_out'
 InTable←1 7⍴' i ' 'F_ratio' 'unexp. var.' ' Durb-W' '   big res ' ' dig lost' 'In variables'
 OutTable←1 7⍴' i ' 'F_ratio' 'unexp. var.' ' Durb-W' '   big res ' ' dig lost' 'Out varariables'
 io←1 5⍴' i' '# in' '#out' 'in' 'out'
 io⍪←0(≡i_in)(≡i_out)i_in i_out
     
          ⍝  Loop until done
 ok←1 ⋄ i←0 ⋄ in_collection←⊂i_in
 :While ok
     i+←1
          ⍝  regress    "in"   and   "out"
     NI←Dutils.DoStepRegression y(x[;,i_in])
     InTable⍪←i,NI.(F_ratio sos_err DurbinWatson big_e DL),⊂i_in
     NO←Dutils.DoStepRegression NI.errs(x[;i_out])
     OutTable⍪←i,NO.(F_ratio sos_err DurbinWatson big_e DL),⊂i_out
     
     fi←,NI.F_ix ⋄ fo←,NO.F_ix ⋄ fri←,NI.F_ratio ⋄ fro←,NO.F_ratio
     max_fo←⌈/fo
     min_fi←⌊/fi
     
     :If max_fo≥foc
         nii←(fo⍳max_fo)⊃i_out
         rem←0 ⋄ add←nii
         i_out~←nii ⋄ i_in←{⍵[⍋⍵]}i_in,nii
     :ElseIf min_fi<fic
         nio←(fi⍳min_fi)⊃i_in
         rem←nio ⋄ add←0
         i_out←{⍵[⍋⍵]}i_out,nio ⋄ i_in~←nio
     :Else
         ok←0
         :Leave
     :EndIf
     io⍪←i(≢i_in)(≢i_out)i_in i_out
     progress⍪←i(rem)(add)(min_fi)(max_fo)fri fro
     
     :If (⊂i_in)∊in_collection ⋄ :Leave ⋄ :EndIf
     in_collection,←⊂i_in
 :EndWhile
     
          ⍝  final clean-up
 coef←NI.coeff ⋄ ok←(|coef)>1E¯8
 i_out←{⍵[⍋⍵]}i_out,(~ok)/i_in
 i_in←ok/i_in
     
 nr←((⊂Y_name),X_names[i_in])RegressMultipleLinear y(vox[i_in])
 list←⍕(nr.⎕NL-2)~'yname' 'xname' 'X_names'
     
          ⍝  pack up NS
 NS.(progress In_Table Out_Table In_Names In_Indecies Out_Names Out_Indies NsIn NsOut InOut_path)←progress InTable OutTable(X_names[i_in])i_in(X_names[i_out])i_out NI NO io
 ⍎'NS.(',list,')←nr.(',list,')'
     
 :Return
∇

 TukeyWindow←{
      ⍝   ⍺ ←→ Optional Window width
      ⍝   provide the original Tukey-Interim-Window.  This is "cosine"
      ⍝   rounding at each end of a time string to improve the apparent
      ⍝   power spectrum and FFT.  Sharp "edges" cause spurious
      ⍝   harmonics, and this is supposed to reduce that problem.
      ⍝   width is the fraction of the data to be effected at each end.
      ⍝   0 to pi
      ⍝   cosine  goes 1 to ¯1  <::>  1-cos  goes 0 to 2  <::>  ÷ by 2  goes 0 to 1
      ⍝
      ⍝        ******
      ⍝       *      *
      ⍝      *        *
      ⍝    **          **
     n←≢v←⍵
     ⍺←0.25
     ww←⌈⍺×n
     s←⍳ww
     w←○(s-1)÷ww-1               ⍝ the range of cosine: 0 to pi
     w←0.5×1-2○w                 ⍝ the scaled cosine:  the "window"  edge
     w←w,((n-2×ww)⍴1),⌽w         ⍝ the full window
     w×v
 }

:Namespace Distrib
(⎕IO ⎕ML ⎕WX)←1 1 3

∇ Q←ChiSq_A(Xs dof);ker;hd;mult;int;To;⎕ML;⎕IO
     
          ⍝∇  the right tail area for a critical ChiSq and dof
     
 ⎕ML←⎕IO←1
     
 :If Xs<0.01
     Q←1-ChiSq_P Xs dof
     :Return
 :EndIf
     
          ⍝∇ 26.4.2
 To←{(×⍺-⍵)×⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 ker←{(⍵*hd-1)×*-⍵÷2}
 hd←dof÷2
 mult←÷(2*hd)×!hd-1
     
 int←(ker ##.Dutils.∆GQ)##.Dutils.∆QUAD Xs 1000 50
 Q←mult×int
     
 :Return
∇

∇ Q←ChiSq_Acd(Xs dof);ker;hd;mult;int;To;⎕ML;⎕IO
     
          ⍝∇  the right tail area for a critical ChiSq and dof
     
 ⎕ML←⎕IO←1
     
 :If Xs<0.01
     Q←1-ChiSq_P Xs dof
     :Return
 :EndIf
     
          ⍝∇ 26.4.2
 To←{(×⍺-⍵)×⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 ker←{(⍵*hd-1)×*-⍵÷2}
 hd←dof÷2
 mult←÷(2*hd)×!hd-1
     
 int←(ker ##.Dutils.∆GQ)##.Dutils.∆QUAD Xs 1000 50
 Q←mult×int
     
 :Return
∇

∇ res←ChiSq_CAD xad;k;X;alpha;dof;⎕ML;⎕IO
     
           ⍝∇ return the missing element given the other 2 out of: ChiSq  alpha  dof
     
 ⎕ML←1 ⋄ ⎕IO←1
 k←⊃⍸xad≡¨⊂⍬
 X alpha dof←xad
     
 :Select k
 :Case 1                               ⍝  get X == ChiSquare
     res←ChiSq_Xa alpha dof
 :Case 2                                ⍝  get alpha
     res←ChiSq_Q X dof
 :Case 3                                ⍝  get degrees-of-freedom
     res←ChiSq_Da X alpha
 :EndSelect
∇

∇ res←ChiSq_CPD xad;k;X;dof;⎕ML;⎕IO;cumdf
     
           ⍝∇ return the missing element given the other 2 out of: ChiSq  cumdf  dof
     
 ⎕ML←1 ⋄ ⎕IO←1
 k←⊃⍸xad≡¨⊂⍬
 X cumdf dof←xad
     
 :Select k
 :Case 1                               ⍝  get X == ChiSquare
     res←ChiSq_Xp cumdf dof
 :Case 2                                ⍝  get alpha
     res←ChiSq_Q X dof
 :Case 3                                ⍝  get degrees-of-freedom
     res←ChiSq_Dp X cumdf
 :EndSelect
∇

∇ xs←ChiSq_Cad_DUP(alpha dof);Funx;⎕ML;⎕IO;y130;y140;y150;c
                   ⍝ duplicate file, recreate proj w casecode
          ⍝∇ Given:   alpha (right-hand tail) and degress of freedom
          ⍝∇ Return:  the critical value of ChiSquare
          ⍝∇ Based on alpha  A&S 26.4.2
     
 ⎕ML←1 ⋄ ⎕IO←1
          ⍝ dof⌊←150
 :If dof≤150
     :If (dof=1)∧(alpha>0.9999) ⋄ xs←0 ⋄ :Return ⋄ :EndIf              ⍝  at .9999 xs~1E¯7  and I can't compute anything higher
     Funx←{alpha-ChiSq_Q ⍵ dof}
     :If (dof=1)∧(alpha>0.75)
         Funx←{(1-alpha)-ChiSq_P ⍵ dof}                ⍝  P is more accurate than Q for dof=1  at very low P or big Q (alpha)
     :EndIf
          ⍝ alpha,Funx¨1E¯9 300
     xs←Funx ##.Dutils.HalfStep 1E¯9 250 30
 :Else
          ⍝  for large dof, A&S 26.4.16  didn't work as I coded it.  Maybe I misunderstood something.
          ⍝  but quadratically extapolating in log log space the values for dof = 130 140 and 150
          ⍝  seems to have modest error for dof<600.  Sensible answers up to 100,000;  a million isn't so good!!!
          ⍝  I used two sanity checks:  as you go down in alpha, the ChiSq should be close to dof at ⍺=.5; and
          ⍝  the ChiSq should monotonically increase.  Over 700 they hold except for very wee ⍺s: .0005 and .0001
     y130←ChiSq_Xa alpha 130
     y140←ChiSq_Xa alpha 140
     y150←ChiSq_Xa alpha 150
     c←(10⍟y130 y140 y150)⌹(10⍟130 140 150)∘.*0 1 2
     xs←10*c+.×(10⍟dof)∘.*0 1 2
 :EndIf
∇

∇ xs←ChiSq_Cpd_DUP(cumdf dof);Funx;⎕ML;⎕IO;y130;y140;y150;c
     
          ⍝∇ Given:   cumdf (left-hand tail) and degress of freedom
          ⍝∇ Return:  the critical value of ChiSquare
          ⍝∇ Based on alpha  A&S 26.4.2
     
 ⎕ML←1 ⋄ ⎕IO←1
          ⍝ dof⌊←150
 :If dof≤150
     :If (dof=1)∧(cumdf<0.0001) ⋄ xs←0 ⋄ :Return ⋄ :EndIf              ⍝  at .9999 xs~1E¯7  and I can't compute anything higher
     Funx←{cumdf-ChiSq_P ⍵ dof}
     :If (dof=1)∧(cumdf<0.25)
         Funx←{(1-cumdf)-ChiSq_Q ⍵ dof}                ⍝  P is more accurate than Q for dof=1  at very low P or big Q (alpha)
     :EndIf
          ⍝ alpha,Funx¨1E¯9 300
     xs←Funx ##.Dutils.HalfStep 1E¯9 250 30
 :Else
          ⍝  for large dof, A&S 26.4.16  didn't work as I coded it.  Maybe I misunderstood something.
          ⍝  but quadratically extapolating in log log space the values for dof = 130 140 and 150
          ⍝  seems to have modest error for dof<600.  Sensible answers up to 100,000;  a million isn't so good!!!
          ⍝  I used two sanity checks:  as you go down in alpha, the ChiSq should be close to dof at ⍺=.5; and
          ⍝  the ChiSq should monotonically increase.  Over 700 they hold except for very wee ⍺s: .0005 and .0001
     y130←ChiSq_Xa alpha 130
     y140←ChiSq_Xa alpha 140
     y150←ChiSq_Xa alpha 150
     c←(10⍟y130 y140 y150)⌹(10⍟130 140 150)∘.*0 1 2
     xs←10*c+.×(10⍟dof)∘.*0 1 2
 :EndIf
∇

∇ N←ChiSq_Dca(ChiSq alpha);Fun;⎕ML;⎕IO
     
          ⍝∇  s ← ChiSq_Da ChiSq Alpha -- Critical degrees-of-freedom for ChiSquare
          ⍝∇                    alpha is the right "tail" area  cumdf ≡ p = 1-alpha
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{alpha-ChiSq_Q ChiSq ⍵}
 N←⌈Fun ##.Dutils.HalfStepI 1 170 24
 N←N⌊1000000
     
 :Return
∇

∇ N←ChiSq_Dcp(ChiSq cumdf);Fun;⎕ML;⎕IO
     
          ⍝∇  s ← ChiSq_Da ChiSq p -- Critical degrees-of-freedom for ChiSquare
          ⍝∇                      cumdf ≡ p = 1-alpha
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{cumdf-ChiSq_P ChiSq ⍵}
 N←⌈Fun ##.Dutils.HalfStepI 1 170 24
 N←N⌊1000000
     
 :Return
∇

∇ Q←ChiSq_P(Xs dof);ker;hd;mult;int;To;NOP;⎕ML;⎕IO
     
          ⍝∇  Given:   Critical ChiSquare and degrees of freedom
          ⍝∇  Return:  the cumulative probability (integral from the left).
          ⍝∇     A&S 26.4.2
     
 ⎕ML←⎕IO←1
     
 dof⌊←300
 To←{(×⍺-⍵)×⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 ker←{(⍵*hd-1)×*-⍵÷2}
 hd←dof÷2
 mult←÷(2*hd)×!hd-1
 NOP←50                                      ⍝ adequate no. of panels for most computations
 :If (dof=1)∧(Xs<0.4) ⋄ NOP←500 ⋄ :EndIf      ⍝ tighten up :: silly part of the chi-square space
 :If (dof=1)∧(Xs<0.01) ⋄ NOP←5000 ⋄ :EndIf
     
 int←(ker ##.Dutils.∆GQ)##.Dutils.∆QUAD 0 Xs NOP
 Q←mult×int
     
 :Return
∇

∇ Q←ChiSq_Pcd(Xs dof);ker;hd;mult;int;To;NOP;⎕ML;⎕IO
     
          ⍝∇  Given:   Critical ChiSquare and degrees of freedom
          ⍝∇  Return:  the cumulative probability (integral from the left).
          ⍝∇     A&S 26.4.2
     
 ⎕ML←⎕IO←1
     
 dof⌊←300
 To←{(×⍺-⍵)×⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 ker←{(⍵*hd-1)×*-⍵÷2}
 hd←dof÷2
 mult←÷(2*hd)×!hd-1
 NOP←50                                      ⍝ adequate no. of panels for most computations
 :If (dof=1)∧(Xs<0.4) ⋄ NOP←500 ⋄ :EndIf      ⍝ tighten up :: silly part of the chi-square space
 :If (dof=1)∧(Xs<0.01) ⋄ NOP←5000 ⋄ :EndIf
     
 int←(ker ##.Dutils.∆GQ)##.Dutils.∆QUAD 0 Xs NOP
 Q←mult×int
     
 :Return
∇

∇ Q←ChiSq_Q(Xs dof);ker;hd;mult;int;To
     
     ⍝∇ the right tail area for a critical ChiSq and dof
     
 :If Xs<0.01
     Q←1-ChiSq_P Xs dof
     :Return
 :EndIf
     
     ⍝∇ 26.4.2
 dof⌊←300
 To←{(×⍺-⍵)×⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 ker←{(⍵*hd-1)×*-⍵÷2}
 hd←dof÷2
 mult←÷(2*hd)×!hd-1
     
 int←(ker ##.Dutils.∆GQ)##.Dutils.∆QUAD Xs 250 50
 Q←mult×int
∇

∇ xs←ChiSq_Xa(alpha dof);Funx;⎕ML;⎕IO;y130;y140;y150;c
     
          ⍝∇ Given:   alpha (right-hand tail) and degress of freedom
          ⍝∇ Return:  the critical value of ChiSquare
          ⍝∇ Based on alpha  A&S 26.4.2
     
 ⎕ML←1 ⋄ ⎕IO←1
          ⍝ dof⌊←150
 :If dof≤150
     :If (dof=1)∧(alpha>0.9999) ⋄ xs←0 ⋄ :Return ⋄ :EndIf              ⍝  at .9999 xs~1E¯7  and I can't compute anything higher
     Funx←{alpha-##.Distrib.ChiSq_Q ⍵ dof}
     :If (dof=1)∧(alpha>0.75)
         Funx←{(1-alpha)-##.Distrib.ChiSq_P ⍵ dof}                ⍝  P is more accurate than Q for dof=1  at very low P or big Q (alpha)
     :EndIf
          ⍝ alpha,Funx¨1E¯9 300
     xs←Funx ##.Dutils.HalfStep 1E¯9 250 30
 :Else
          ⍝  for large dof, A&S 26.4.16  didn't work as I coded it.  Maybe I misunderstood something.
          ⍝  but quadratically extapolating in log log space the values for dof = 130 140 and 150
          ⍝  seems to have modest error for dof<600.  Sensible answers up to 100,000;  a million isn't so good!!!
          ⍝  I used two sanity checks:  as you go down in alpha, the ChiSq should be close to dof at ⍺=.5; and
          ⍝  the ChiSq should monotonically increase.  Over 700 they hold except for very wee ⍺s: .0005 and .0001
     y130←ChiSq_Xa alpha 130
     y140←ChiSq_Xa alpha 140
     y150←ChiSq_Xa alpha 150
     c←(10⍟y130 y140 y150)⌹(10⍟130 140 150)∘.*0 1 2
     xs←10*c+.×(10⍟dof)∘.*0 1 2
 :EndIf
∇

∇ p←Fratio_A(F dn dd);x;⎕ML;⎕IO
     
          ⍝∇   Given:   a Critical_Fratio value, the numerator and denominator degress of freedom
          ⍝∇   Return:  the tail area - alpha
          ⍝∇
          ⍝∇   A&S  26.6.2  p946     :: in A&S this is "Q"  (1-P)
     
 ⎕ML←1 ⋄ ⎕IO←1
 x←dd÷dd+F×dn
 p←##.Dutils.IncBetaI x,0.5×dd dn    ⍝  integrals for dofd 1 and 2 take a while
                                          ⍝  and as written only good to 2 or 3 digits
∇

∇ N←Fratio_Dfan(F alpha dofn);Fun;⎕ML;⎕IO
     
          ⍝∇  Return: Critical denominator-degrees-of-freedom for the F-ratio cumlulative distribution
          ⍝∇  Given:  Critical Fratio value, alpha (tail probability), and   numerator-degrees-of-freedom.
          ⍝∇
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulatlive
          ⍝∇                    distribution)
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{alpha-Fratio_alpha F dofn ⍵}
 N←⌈Fun ##.Dutils.HalfStepI 1 100000 24
 N←N⌊1000000
     
 :Return
∇

∇ N←Fratio_Dfpn(F cumdf dofn);Fun;⎕ML;⎕IO;alpha
     
          ⍝∇  Return: Critical denominator-degrees-of-freedom for the F-ratio cumlulative distribution
          ⍝∇  Given:  Critical Fratio value, alpha (tail probability), and   numerator-degrees-of-freedom.
          ⍝∇
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulatlive
          ⍝∇                    distribution)
     
 ⎕ML←1 ⋄ ⎕IO←1
 alpha←1-cumdf
 Fun←{alpha-Fratio_alpha F dofn ⍵}
 N←⌈Fun ##.Dutils.HalfStepI 1 100000 24
 N←N⌊1000000
     
 :Return
∇

∇ res←Fratio_FAND fand;k;F;alpha;dofn;dofd;⎕ML;⎕IO
     
           ⍝∇ return the missing element given the other 3 out of: F  alpha  dofn  dofd
       ⍝ Problematic : look into missing fn calls
 ⎕ML←1 ⋄ ⎕IO←1
 k←⍸fand≡¨⊂⍬
 F alpha dofn dofd←fand
     
 :Select k
 :Case 1                               ⍝  get F
     res←Fratio_Fa alpha dofn dofd
 :Case 2                                ⍝  get alpha
     res←Fratio_A F dofn dofd
 :Case 3                                ⍝  get numerator-degrees-of-freedom
     res←Fratio_Na F alpha dofd
 :Case 4                                ⍝  get denominator-degrees-of-freedom
     res←Fratio_Da F alpha dofn
 :EndSelect
∇

∇ res←Fratio_FPND fand;k;F;cumdf;dofn;dofd;⎕ML;⎕IO
     
           ⍝∇ return the missing element given the other 3 out of: F  cumdf  dofn  dofd
     
 ⎕ML←1 ⋄ ⎕IO←1
 k←⍸fand≡¨⊂⍬
 F cumdf dofn dofd←fand
     
 :Select k
 :Case 1                               ⍝  get F
     res←Fratio_Fp cumdf dofn dofd
 :Case 2                                ⍝  get alpha
     res←Fratio_P F dofn dofd
 :Case 3                                ⍝  get numerator-degrees-of-freedom
     res←Fratio_Np F cumdf dofd
 :Case 4                                ⍝  get denominator-degrees-of-freedom
     res←Fratio_Dp F cumdf dofn
 :EndSelect
∇

∇ F←Fratio_Fa and;alpha;dofn;dofd;Funx;⎕ML;⎕IO
     
          ⍝∇ deliver the critical F-ratio for given alpha and numerator and
          ⍝∇         denominator degrees of freedom.
          ⍝∇  accurate for dofd=1 to just 2-3 digits (takes way toooo long
          ⍝∇     to get more accuracy:  change the NON in IncBetaI to 100000
     
 ⎕ML←1 ⋄ ⎕IO←1
 alpha dofn dofd←3↑and,1,1
          ⍝  search for the F delivers the given alpha
          ⍝  create the search function
          ⍝ Funx←{alpha-Fratio_alpha ⍵ dofn dofd}
 Funx←{alpha-Fratio_Q ⍵ dofn dofd}
     
 F←Funx ##.Dutils.HalfStep 0.1(1+2*20)50
 F←10000000000⌊F
∇

∇ F←Fratio_Fand_DUP and;cumdf;alpha;dofn;dofd;Funx;⎕ML;⎕IO
     
          ⍝∇ deliver the critical F-ratio for given alpha and numerator and
          ⍝∇         denominator degrees of freedom.
          ⍝∇  accurate for dofd=1 to just 2-3 digits (takes way toooo long
          ⍝∇     to get more accuracy:  change the NON in IncBetaI to 100000
     
 ⎕ML←1 ⋄ ⎕IO←1
 alpha dofn dofd←3↑and,1,1
          ⍝  search for the F delivers the given alpha
          ⍝  create the search function
 Funx←{alpha-Fratio_alpha ⍵ dofn dofd}
     
 F←Funx ##.Dutils.HalfStep 0.1(1+2*20)50
 F←10000000000⌊F
∇

∇ F←Fratio_Fpnd_DUP pnd;cumdf;alpha;dofn;dofd;Funx;⎕ML;⎕IO
     
          ⍝∇ deliver the critical F-ratio for given p and numerator and
          ⍝∇         denominator degrees of freedom.
          ⍝∇  accurate for dofd=1 to just 2-3 digits (takes way toooo long
          ⍝∇     to get more accuracy:  change the NON in IncBetaI to 100000
     
 ⎕ML←1 ⋄ ⎕IO←1
 cumdf dofn dofd←3↑pnd,1,1
 alpha←1-cumdf
          ⍝  search for the F delivers the given alpha
          ⍝  create the search function
 Funx←{alpha-Fratio_alpha ⍵ dofn dofd}
     
 F←Funx ##.Dutils.HalfStep 0.1(1+2*20)50
 F←10000000000⌊F
∇

∇ N←Fratio_Nfad(F alpha dofd);Fun;⎕ML;⎕IO
     
          ⍝∇  Return: Critical numerator-degrees-of-freedom for the F-ratio cumlulative distribution
          ⍝∇  Given:  Critical Fratio value, alpha (tail integral), and denominator-degrees-of-freedom.
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulatlive
          ⍝∇                    distribution)
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{alpha-Fratio_Q F ⍵ dofd}
 N←⌈Fun ##.Dutils.HalfStepI 1 1000 24
 N←N⌊1000000
     
 :Return
∇

∇ N←Fratio_Nfpd(F cumdf dofd);Fun;⎕ML;⎕IO;alpha
     
          ⍝∇  Return: Critical numerator-degrees-of-freedom for the F-ratio cumlulative distribution
          ⍝∇  Given:  Critical Fratio value, cumdf (left integral), and denominator-degrees-of-freedom.
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulatlive
          ⍝∇                    distribution)
     
 ⎕ML←1 ⋄ ⎕IO←1
 alpha←1-cumdf
 Fun←{alpha-Fratio_Q F ⍵ dofd}
 N←⌈Fun ##.Dutils.HalfStepI 1 1000 24
 N←N⌊1000000
     
 :Return
∇

∇ P←Fratio_P(F dn dd);x;⎕ML;⎕IO
     
          ⍝∇   Given:   a Critical_Fratio value, the numerator and denominator degress of freedom
          ⍝∇   Return:  cumulative probability (area from -infinity to F)
          ⍝∇   A&S  26.6.2  p946
     
 ⎕ML←1 ⋄ ⎕IO←1
 x←dd÷dd+F×dn
 P←1-##.Dutils.IncBetaI x,0.5×dd dn
     
 :Return
∇

∇ p←Fratio_Q(F dn dd);x;⎕ML;⎕IO
     
          ⍝∇   Given:   a Critical_Fratio value, the numerator and denominator degress of freedom
          ⍝∇   Return:  the tail area - alpha
          ⍝∇
          ⍝∇   A&S  26.6.2  p946     :: in A&S this is "Q"  (1-P)
     
 ⎕ML←1 ⋄ ⎕IO←1
 x←dd÷dd+F×dn
 p←##.Dutils.IncBetaI x,0.5×dd dn    ⍝  integrals for dofd 1 and 2 take a while
∇

∇ z←Normal_A x;ker;f;⎕ML;⎕IO
     
          ⍝∇  z ← Normal x --  the statisticians error fcn:  cum. normal prob. dist.
     
 ⎕ML←1 ⋄ ⎕IO←1
 ker←{*-0.5×⍵*2}
 f←÷0.5*⍨○2
     
 :If x≤¯4.06
     z←1-f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD ¯50 x 100
 :ElseIf x<0
     z←0.5+f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD 0(|x)100
 :ElseIf x≤4.06
     z←0.5-f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD 0 x 100
 :Else
     z←f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD x 50 100
 :EndIf
     
     
 :Return
∇

∇ z←Normal_Ax x;ker;f;⎕ML;⎕IO
     
          ⍝∇  z ← Normal x --  the statisticians error fcn:  cum. normal prob. dist.
     
 ⎕ML←1 ⋄ ⎕IO←1
 ker←{*-0.5×⍵*2}
 f←÷0.5*⍨○2
     
 :If x≤¯4.06
     z←1-f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD ¯50 x 100
 :ElseIf x<0
     z←0.5+f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD 0(|x)100
 :ElseIf x≤4.06
     z←0.5-f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD 0 x 100
 :Else
     z←f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD x 50 100
 :EndIf
     
     
 :Return
∇

∇ z←Normal_P x;ker;f;⎕ML;⎕IO
     
          ⍝∇  z ← Normal x --  the statisticians error fcn:  cum. normal prob. dist.
          ⍝∇                   the integral from the left:  i.e.:   -infinity to x
     
 ⎕ML←1 ⋄ ⎕IO←1
 ker←{*-0.5×⍵*2}
 f←÷0.5*⍨○2
     
 :If x≤¯4.06
     z←f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD ¯50 x 100
 :ElseIf x<0
     z←0.5-f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD 0(|x)100
 :ElseIf x≤4.06
     z←0.5+f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD 0 x 100
 :Else
     z←1-f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD x 50 100
 :EndIf
     
     
 :Return
∇

∇ z←Normal_Px x;ker;f;⎕ML;⎕IO
     
          ⍝∇  z ← Normal x --  the statisticians error fcn:  cum. normal prob. dist.
          ⍝∇                   the integral from the left:  i.e.:   -infinity to x
     
 ⎕ML←1 ⋄ ⎕IO←1
 ker←{*-0.5×⍵*2}
 f←÷0.5*⍨○2
     
 :If x≤¯4.06
     z←f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD ¯50 x 100
 :ElseIf x<0
     z←0.5-f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD 0(|x)100
 :ElseIf x≤4.06
     z←0.5+f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD 0 x 100
 :Else
     z←1-f×ker ##.Dutils.∆GQ ##.Dutils.∆QUAD x 50 100
 :EndIf
     
     
 :Return
∇

∇ x←Normal_Xa alpha;ker;⎕ML;⎕IO
     
           ⍝∇ find x that satisfies the tail of the cumulative normal distribution - alpha
     
 ⎕ML←⎕IO←1
     
 ker←{alpha-Normal_Q ⍵}
 x←ker ##.Dutils.HalfStep ¯50 50 60
     
 :Return
∇

∇ x←Normal_Xp cumdf;ker;⎕ML;⎕IO
     
           ⍝∇ find x that satisfies the tail of the cumulative normal distribution - alpha
     
 ⎕ML←⎕IO←1
     
 ker←{cumdf-Normal_P ⍵}
 x←ker ##.Dutils.HalfStep ¯50 50 60
     
 :Return
∇

∇ z←Normal_y x;⎕ML;⎕IO
     
          ⍝∇  z ← Normal x --  ordinate of the normal distribution
     
 ⎕ML←1 ⋄ ⎕IO←1
 z←(*-0.5×x*2)÷0.5*⍨○2
     
 :Return
∇

∇ a←Student_A(t dof);mult;ker;int;a;b;⎕ML;⎕IO
 ⎕ML←⎕IO←1
 a←1-Student_P(t dof)
 :Return
∇

∇ a←Student_Atd(t dof);mult;ker;int;a;b;⎕ML;⎕IO
 ⎕ML←⎕IO←1
 a←1-Student_P(t dof)
 :Return
∇

∇ dof←Student_Dta(t alpha);Fun;⎕ML;⎕IO
     
          ⍝∇  dof ← Student_D (t alpha)  -- degrees needed to get a t at the given alpha
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulatlive
          ⍝∇                    distribution )
     
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{(1-alpha)-Student_P t ⍵}
 dof←⌈Fun ##.Dutils.HalfStepI 1 250 24
     
 :Return
∇

∇ dof←Student_Dtp(t p);Fun;⎕ML;⎕IO
     
          ⍝∇  dof ← Student_D (t alpha)  -- degrees needed to get a t at the given alpha
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulatlive
          ⍝∇                    distribution )
     
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{p-Student_P t ⍵}
 dof←⌈Fun ##.Dutils.HalfStepI 1 250 24
     
 :Return
∇

∇ p←Student_P(t dof);mult;ker;int;a;b;⎕ML;⎕IO;th;sum;k;i;n;d;z
     
          ⍝∇   the left integral (leaving only the right tail) for the Student t
     
 ⎕ML←1 ⋄ ⎕IO←1
           ⍝∇ for big t and small dof
 :If (t>20)∧(dof=1)    ⍝  A&S  26.7.7  p949
     a b←dof⊃(0.3183 0)(0.4991 0.0518)(1.1094 ¯0.046)(3.0941 ¯2.756)(9.948 ¯14.05)
     p←1-+/a b÷t*dof dof+0 1
     :Return
 :EndIf
     
 th←¯3○t÷dof*0.5
     
          ⍝∇      A&S  26.7.3 (odd dof)  p948
 :If dof=1 ⋄ p←1-0.5×1-2×th÷○1 ⋄ :Return ⋄ :EndIf
 :If 2|dof
     sum←2○th
     k←1↓{(2|⍵)/⍵}⍳dof-2
     :For i :In k
         n←2×⍳⌊i÷2
         d←1+n
         sum+←z←(×/n÷d)×((2○th)*i)
          ⍝           'odd'##.Dutils.Watcher dof i n d z sum
     :EndFor
     p←(2÷○1)×th+sum×(1○th)
     p←1-0.5×1-p
 :Else
          ⍝∇      A&S  26.7.4 (even dof)   p948
     sum←1
     k←{(~2|⍵)/⍵}⍳dof-2
     :For i :In k
         d←2×⍳i÷2
         n←¯1+d
         sum+←z←(×/n÷d)×((2○th)*i)
          ⍝           'even'##.Dutils.Watcher dof i n d z sum
     :EndFor
     p←sum×1○th
     p←1-0.5×1-p
 :EndIf
     
 :Return
     
          ⍝  the following code is much much slower
     
     
          ⍝∇  A&S  26.7.1  p948
     
 mult←÷(dof*0.5)×##.Dutils.Beta 1 dof÷2
 ker←{(1+dof÷⍨⍵*2)*-0.5×dof+1}
 int←ker ##.Dutils.∆GQ ##.Dutils.∆QUAD(-t)t 5000
 p←mult×int
 p←1-0.5×1-p
 :Return
∇

∇ p←Student_Ptd(t dof);mult;ker;int;a;b;⎕ML;⎕IO;th;sum;k;i;n;d;z
     
          ⍝∇   the left integral (leaving only the right tail) for the Student t
     
 ⎕ML←1 ⋄ ⎕IO←1
           ⍝∇ for big t and small dof
 :If (t>20)∧(dof=1)    ⍝  A&S  26.7.7  p949
     a b←dof⊃(0.3183 0)(0.4991 0.0518)(1.1094 ¯0.046)(3.0941 ¯2.756)(9.948 ¯14.05)
     p←1-+/a b÷t*dof dof+0 1
     :Return
 :EndIf
     
 th←¯3○t÷dof*0.5
     
          ⍝∇      A&S  26.7.3 (odd dof)  p948
 :If dof=1 ⋄ p←1-0.5×1-2×th÷○1 ⋄ :Return ⋄ :EndIf
 :If 2|dof
     sum←2○th
     k←1↓{(2|⍵)/⍵}⍳dof-2
     :For i :In k
         n←2×⍳⌊i÷2
         d←1+n
         sum+←z←(×/n÷d)×((2○th)*i)
          ⍝           'odd'##.Dutils.Watcher dof i n d z sum
     :EndFor
     p←(2÷○1)×th+sum×(1○th)
     p←1-0.5×1-p
 :Else
          ⍝∇      A&S  26.7.4 (even dof)   p948
     sum←1
     k←{(~2|⍵)/⍵}⍳dof-2
     :For i :In k
         d←2×⍳i÷2
         n←¯1+d
         sum+←z←(×/n÷d)×((2○th)*i)
          ⍝           'even'##.Dutils.Watcher dof i n d z sum
     :EndFor
     p←sum×1○th
     p←1-0.5×1-p
 :EndIf
     
 :Return
     
          ⍝  the following code is much much slower
     
     
          ⍝∇  A&S  26.7.1  p948
     
 mult←÷(dof*0.5)×##.Dutils.Beta 1 dof÷2
 ker←{(1+dof÷⍨⍵*2)*-0.5×dof+1}
 int←ker ##.Dutils.∆GQ ##.Dutils.∆QUAD(-t)t 5000
 p←mult×int
 p←1-0.5×1-p
 :Return
∇

∇ t←Student_Tad(alpha dof);Fun;⎕ML;⎕IO
     
          ⍝∇  dof ← Student_T (alpha dof)  -- critical t given alpha and degrees-of-freedom
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulatlive
          ⍝∇                    distribution )
     
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{(1-alpha)-Student_P ⍵ dof}
 t←Fun ##.Dutils.HalfStep 0 100000 40
     
 :Return
∇

∇ t←Student_Tp(p dof);Fun;⎕ML;⎕IO
     
          ⍝∇  dof ← Student_T (p dof)  -- critical t given p and degrees-of-freedom
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulative
          ⍝∇                    distribution )
     
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{p-##.Distrib.Student_P ⍵ dof}
 t←Fun ##.Dutils.HalfStep 0 100000 40
     
 :Return
∇

∇ t←Student_Tpd(p dof);Fun;⎕ML;⎕IO
     
          ⍝∇  dof ← Student_T (p dof)  -- critical t given p and degrees-of-freedom
          ⍝∇                    alpha is the "tail" area  alpha = 1-p (the cumulative
          ⍝∇                    distribution )
     
     
 ⎕ML←1 ⋄ ⎕IO←1
 Fun←{p-Student_P ⍵ dof}
 t←Fun ##.Dutils.HalfStep 0 100000 40
     
 :Return
∇

:Namespace quadVars
(⎕IO ⎕ML ⎕WX)←1 0 3

:EndNamespace 
:EndNamespace 
:Namespace Dutils
(⎕IO ⎕ML ⎕WX)←1 1 3

 Atan2←{((¯3○⍺÷⍵+⍵=0)×(⍵≠0))+((○⍵<0)××⍺)+○0.5×(⍵=0)××⍺}

∇ a←Average v
     
 a←(SumByTwos v)÷≢v
 :Return
∇

∇ b←{nop}Beta(a b);ker;⎕ML;⎕IO
     
 ⎕ML←1 ⋄ ⎕IO←1
 :If 0=⎕NC'nop' ⋄ nop←200 ⋄ :EndIf
 :If 980<a+b ⋄ b←0 ⋄ :EndIf
 ker←{((1○⍵)*¯1+2×a)×((2○⍵)*¯1+2×b)}
 b←2×ker ∆GQ ∆QUAD 0(○0.5)200
 :Return
∇

∇ cerf←Cerf x;kernel;f;⎕ML;⎕IO
          ⍝  Complimentary error function: good to at least 12 and usually more digits
     
 ⎕ML←1 ⋄ ⎕IO←1
 kernel←{*-⍵*2}
 f←(2÷(○1)*0.5)
     
 :If x≤4.06
     cerf←1-f×kernel Romberg_Trap 0 x
 :Else
     cerf←f×kernel Romberg_Trap x 50
 :EndIf
     
 :Return
∇

∇ cerf←Cerf_alt x;kernel;f;⎕ML;⎕IO
          ⍝  Complimentary error function: good to at least 12 and usually more digits
     
 ⎕ML←1 ⋄ ⎕IO←1
 kernel←{*-⍵*2}
 f←2÷0.5*⍨○1
     
 :If x≤4.06
     cerf←1-f×kernel ∆GQ ∆QUAD 0 x 100
 :Else
     cerf←f×kernel ∆GQ ∆QUAD x 50 100
 :EndIf
     
 :Return
∇

 Comb←{⎕ML←2                             ⍝ ⍺-combination matrix of ⍳⍵.
     ↑↑(⊂⊂1 0⍴0){                        ⍝ base-case: [0 ⍵].
         ¯1↓↑{                           ⍝ removing base case from,
             (⍪/⌽{⎕IO,⍵}\1+⍺(↑⍵)),⍵      ⍝ accumulation of,
         }/⍵,⍺⍺                          ⍝ sub- (⍺ ⍵-1) combinations,
     }/(⍳0⌈⍵-⍺),⊂(⍺≤⍵){⍺ ⍵⍴⍳⍵}¨⌽+\⍺⍴1    ⍝ with base cases [⍺ 0].
      ⍝ Taken from dfns.dyalog.com
 }

∇ cc←CompleteComb n;l;⎕ML;⎕IO
     
          ⍝∇   this produces all combinations if all lengths out of ⍳n
     
 ⎕ML←1 ⋄ ⎕IO←1
 cc←⊃,/↓¨(⍳n)Comb¨n
 :Return
∇

∇ c←Corr(x y);ax;ay;dx;dy;sosx;sosy;soxy;srx;sry;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
     
 ax ay←(SumByTwos¨x y)÷≢x
 dx dy←x y-ax ay
 sosx sosy←SumByTwos¨(dx*2)(dy*2)
 srx sry←sosx sosy*0.5
 soxy←SumByTwos dx×dy
 c←soxy÷srx×sry
     
 :Return
∇

 Crack←{⍺(≠⊆⊢)⍵}

∇ DEFINE_QW
 ⍎,' ',(V2F_LABEL+1)1↓⎕CR'DEFINE_QW'
 →0
          ⍝ Warning: Do NOT add comments below V2F_LABEL.
          ⍝          All text below V2F_LABEL will be treated as data.
V2F_LABEL:
          ⍝ QW←
          ⍝ 0.01761400713915398 0.04060142980038305 0.06267204833410894 0.08327674157670416 0.10193011981724036 0.11819453196151901 0.13168863844917705 0.1420961093183821 0.1491729864726038 0.152753387130726 0.152753387130726 0.1491729864726038 0.1420961093183821 0.13168863844917705 0.11819453196151901 0.10193011981724036 0.08327674157670416 0.06267204833410894 0.04060142980038305 0.01761400713915398
∇

∇ DEFINE_QZ
 ⍎,' ',(V2F_LABEL+1)1↓⎕CR'DEFINE_QZ'
 →0
          ⍝ Warning: Do NOT add comments below V2F_LABEL.
          ⍝          All text below V2F_LABEL will be treated as data.
V2F_LABEL:
          ⍝ QZ←
          ⍝ ¯0.9931285991850949 ¯0.9639719272779139 ¯0.912234428251326 ¯0.8391169718222189 ¯0.7463319064601508 ¯0.6360536807265149 ¯0.510867001950827 ¯0.37370608871541955 ¯0.22778585114164507 ¯0.07652652113349734 0.07652652113349734 0.22778585114164507 0.37370608871541955 0.510867001950827 0.6360536807265149 0.7463319064601508 0.8391169718222189 0.912234428251326 0.9639719272779139 0.9931285991850949
∇

 Divide←{({⍵+⍵=0}⍺)÷{⍵+0.000001000001×⍵=0}⍵}

∇ ns←DoStepRegression(y xm);⎕ML;⎕IO;n;xbar;ybar;nb;one;yesbo;dfbo;dfb;dft;dftc;dfe;I;Ib;xtx;xty;dl;ai;a;check;xa;coeffs;b;btxty;y11y;yty;yhat;errs;sosbo;sosdr;sosar;sostc;sost;msbo;msdr;msar;sesq;serr;f_ratio;t_stat;mrcsq;mrc;seob;trc;denom;req;covr;bigcv;max_cov;st_t;f_remove;big_e;sort;durb;dig_l;out
     
          ⍝∇  solve the current set of equations and get its statistics
     
 ⎕ML←⎕IO←1
 ns←⎕NS''
 n←≢y
 :If (1≡≡xm)∧((⍴y)≡(⍴xm))
     xm←n 1⍴xm
 :EndIf
 :If 0=2⊃⍴xm
     ns.(coeff F_ratio F_ix sos_err big_e DurbinWatson DL errs yhat)←⍬ 0 0 9999.9(⌈/y)0 18 y(n⍴0)
     :Return
 :EndIf
 xbar←Average¨↓[1]xm
 ybar←Average y
 nb←≢xbar
 one←n⍴1
 yesbo←one≡xm[;1]
 dfbo←yesbo           ⍝ degress of freedom for constant
 dfb←nb-yesbo         ⍝ degress of freedom for the x's
 dft←n                ⍝ total dof
 dftc←n-yesbo         ⍝ dof other than constant
 dfe←dft-nb           ⍝ error dof
     
 I←n n⍴0 ⋄ (1 1⍉I)←1  ⍝ identity matrix   n n⍴1,n⍴0
 Ib←nb nb⍴0 ⋄ (1 1⍉Ib)←1
     
 xtx←(⍉xm)+.×xm
 xty←(⍉xm)+.×y
     
 b dl ai a check CN←xty SolveSLAE xtx   ⍝ b ≡≡ anwers    dl ≡≡ digits_lost
                                                                ⍝ ai ≡≡ inverse  a ≡≡ what is left in the original A matrix ≡≡? Identity
                                                                ⍝ check ≡≡ ?     CN ≡≡ condition number
 btxty←b+.×xty
 y11y←((+/y)*2)Divide≢y
 yty←y+.×y
     
 yhat←xm+.×b
 errs←y-yhat
     
 sosbo←y11y
 sosdr←+/(yhat-ybar)*2
 sosar←+/errs*2
 sostc←+/(y-ybar)*2
 sost←yty
     
 msbo←sosbo
 msdr←sosdr Divide dfb
 msar←sosar Divide dfe
 sesq←msar
 serr←sesq*0.5
 f_ratio←2 RndDP 999999⌊(msdr Divide msar)
     
 t_stat←serr×(|ai)*0.5
 mrcsq←sosdr Divide sostc
 mrc←4 RndDP(mrcsq*0.5)
 seob←1 1⍉t_stat
     
     
 trc←1000000000000000⌊¯1000000000000000⌈1 1⍉ai
 denom←trc∘.×trc
 denom←(denom=0)+(denom×(denom≠0))
 req←ai Divide(|denom)*0.5
 Ib←(⍴req)↑Ib
 covr←4 RndDP(req-Ib)
 bigcv←⌈/|covr
 max_cov←⌈/|bigcv
 st_t←2 RndDP(b Divide seob)
     
 f_remove←st_t*2
     
 big_e←⊃⌈/|errs
     
 sort←errs[⍋y]
 durb←2 RndDP(+/((¯1↓sort)-(1↓sort))*2)Divide+/sort*2
     
 dig_l←2 RndDP dl
     
 ns.(coeff F_ratio F_ix sos_err big_e DurbinWatson DL errs yhat)←b f_ratio f_remove(sosar÷n)big_e durb dig_l errs yhat
     
 :Return
∇

∇ Documentation
          ⍝===============================================================================
          ⍝
          ⍝           Quickie Stats Summary
          ⍝
          ⍝          {ns} ← Anova          v  levels  norm
          ⍝          {ns} ← AnovaPool      abt_mms_fr_il_al_si  (6 ⍬s with 1 substitution)
          ⍝
          ⍝          {ns} ← {vnames} RegressMultipleLinear  yv  xvov
          ⍝          {ns} ← {vnames} StepWiseAll            yv  xvov  Fr  Fa  (istart)
          ⍝          {ns} ← {vnames} StepWiseOne            yv  xvov  Fr  Fa  (istart)
          ⍝          {ns} ← {vnames} RegressPolynmomial     yv  xv    order
          ⍝          {ns} ← {vnames} RegressFosythe         yv  xv    order
          ⍝          {ns} ← {vnames} RegressChebyshev       yv  xv    order
          ⍝          {ns} ← {vnames} RegressFourier         yv  xv    order
          ⍝  {qvov names} ← ModelQuadratic                  vov
          ⍝         {vov} ← ModelChebyshev                  ndata order
          ⍝
          ⍝          {ns} ← PrincipleComponents    vov
          ⍝
          ⍝          {ns} ← {vnames} Statistics    vov
          ⍝          {cm} ← {vnames} CorrelMatrix  vov
          ⍝          {ac} ← AutoCorr               v
          ⍝          {cc} ← CrossCorr              v_stationary   v_losing_front
          ⍝          {ns) ← CrossTabs              v1  v2
          ⍝
          ⍝     {Xans DL} ← SimutaneousEquations   Amat RHSvector
          ⍝
          ⍝          {ft} ← DFT                    v
          ⍝          {ft} ← FFT                    v
          ⍝          {ns} ← IDFT                  fft
          ⍝          {ns} ← IFFT                  fft
          ⍝          {wv} ← {ww} TukeyWindow       v
          ⍝
          ⍝         {vov} ← LeadLag                vov vup¯dn vfill cut_bot cut_top
          ⍝
          ⍝
          ⍝-------------------------------------------------------------------------------
          ⍝                       in    Stats.Distrib.
          ⍝             x ← Normal_Xa    ⍺      returns the x for that distributio tail
          ⍝             ⍺ ← Normal_Ax    x      returns the ⍺ for that x (distance from 0)
          ⍝             t ← Student_Tad  ⍺ dof  return critical student_t value
          ⍝             ⍺ ← Student_Atd  t dof  return ⍺
          ⍝             c ← ChiSq_Cad    ⍺ dof  return critical ChiSquare
          ⍝             a ← ChiSq_Acd    c dof  return alpha; given a ChiSquare and DOF
          ⍝             f ← Fratio_Fand  ⍺ n d  return critical Fratio;  alpha dof_N dof_D
          ⍝             ⍺ ← Fratio_Afnd  F n d  return ⍺
          ⍝             d ← Fratio_Dfan  F ⍺ n  return denominator degrees of freedom
          ⍝                    and all of the other logical possibilities
          ⍝
          ⍝===============================================================================
          ⍝===============================================================================
          ⍝===============================================================================
          ⍝
          ⍝ Anova:   n-way Analysis of Variance
          ⍝              ns  ←  {FactorNames)  Anova  d  f  {p}
          ⍝  Arguments:
          ⍝    d:  vector of data: logically partitioned with the first factor (A) going
          ⍝                        the slowest (all values of the first level of A, then
          ⍝                        all values for the second levcl of A, etc.) and the
          ⍝                        replicates for each cell bunched together:
          ⍝       A1 .........................................................    A2 ....
          ⍝       B1                             B2                  B3 ......    B1
          ⍝       C1        C2        ......     C1         C2 ...   C1 C2 ...    C1  C2 .
          ⍝       D   all levels of D for A1,B1,C1; then all levels of D for A1,B1,C2; ...
          ⍝       R   (replicates of (A1,B1,C1,D1) R1 R2 ...) then
          ⍝           (replicates of (A1,B1,C1,D2)) R1 R2 ) ... etc.
          ⍝
          ⍝    f: the list of factor levels:  If A has 3 levels, B has 4 levels, C has 2
          ⍝                          levels, D has 7 levels, and there are 5 replicates
          ⍝                          for each case:  f ≡  3 4 2 7 5
          ⍝                          that means:  (≢d) ≡ 840
          ⍝    p: optional:  default=0 ≡ present in the order:  A  B  C ... AB AC ...
          ⍝                          1 ≡ present as:  A B AB C AC BC ABC D AD ....
          ⍝
          ⍝       There can be up to 15 factors with replicates.   The pattern must be
          ⍝       complete: every level of A must have every level of each of the other
          ⍝       factors, and every case must have the same number of replicates.
          ⍝       The vector of numbers is logically the ravel of an n-dimensional matrix
          ⍝       that is A by B by C by ... by R. (d ≡ ,f ⍴ d)
          ⍝
          ⍝  Resultant output:  ns: A (shy) namespace containing the variables:
          ⍝              ANOVA_Table   ANOVA_Averages   ANOVA_Residluals  and  ANOVA_Data
          ⍝
          ⍝   Try:  ns ← Anova (⍳64) (2 2 2 2 4)    {You can add error to the data:
          ⍝                          ((⍳64)+(64 random numbers))(2 2 2 2 4)
          ⍝                          At least Factor A (level 1 values: 1-32)(level 2
          ⍝                          values: 33-64) will turn out to be significant for
          ⍝                          reasonable sized error.  E.g.:  ((⍳64)+ (.1×64?64)
          ⍝
          ⍝   If all experiments have replicate 1 first, then replicate 2, then 3, etc.
          ⍝   i.e. replicate levelss are going the slowest not the fastest, they can be
          ⍝   reordered using the transpose:     r_fast ← .... ⍉  r_slow
          ⍝   If the ≢d ≡ 60 and there are 5 replicates of 12 exeriments where factor a
          ⍝   has 3 levels; b has 4 levels -- the logical rho of d is 5 3 4.  It needs to
          ⍝   be 3 4 5.  So:   d_good ← ,3 1 2 ⍉  5 3 4 ⍴ d_bad
          ⍝
          ⍝   My experience has shown that if there are missing data, just fill out the
          ⍝   cell with the average (or expected average), and you will get the "big
          ⍝   picture".  One way to test this is analyze some the replicates separately.
          ⍝   The results should pretty much compare.  Truly significant factors should
          ⍝   remain significant.
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ AnovaPool:   it sometimes helps to bunch some of the factors or interactions
          ⍝              that have small F-ratios (large ⍺) into the error pool.
          ⍝                  pns ← ns   AnovaPool   number_or_letters
          ⍝
          ⍝   Arguments:
          ⍝ R      a vector of 6 nulls with one of the nulls replaced (trailing nulls can
          ⍝        be ignored).
          ⍝ L      the namespace from the full Anova.
          ⍝
          ⍝   Result is a namespace with the variable:    Pooled_Anova_TAble
          ⍝
          ⍝   Right argument meanings:
          ⍝        pns ← ns AnovaPool ABB {⍬ ⍬ ⍬ ⍬ ⍬}    ⍝ pool All But the "n" Biggest
          ⍝                                                     mean squares
          ⍝        pns ← ns AnovaPool ⍬ MMS {⍬ ⍬ ⍬ ⍬}    ⍝ pool factors/interactions with
          ⍝                                                     a mean square < Minimum
          ⍝                                                     Mean Square
          ⍝        pns ← ns AnovaPool ⍬ ⍬ FR {⍬ ⍬ ⍬}     ⍝ pool F_ratios smaller than FR
          ⍝        pns ← ns AnovaPool ⍬ ⍬ ⍬ IL {⍬ ⍬}     ⍝ pool Interaction Levels IL and
          ⍝                                                     higher.  ABD ≡ 3rd level
          ⍝                                                     interaction.
          ⍝        pns ← ns AnovaPool ⍬ ⍬ ⍬ ⍬ AL {⍬}     ⍝ pool factors with an alpha ≥ AL
          ⍝        pns ← ns AnovaPool ⍬ ⍬ ⍬ ⍬ ⍬ SI       ⍝ pool factors that include these
          ⍝                                                     letters.  if SI ≡ BD then
          ⍝
          ⍝   for example:  pns ← ns AnovaPool 6             would pool all but the 6
          ⍝                                                  biggest mean squares.
          ⍝                 pns ← ns AnovaPool ⍬ ⍬ 2.3       would pool all F-ratios less
          ⍝                                                  than 2.3
          ⍝                 pns ← ns AnovaPool ⍬ ⍬ ⍬ 4       would pool all 4, 5, 6...-way
          ⍝                                                  interactions
          ⍝                 pns ← ns AnovaPool ⍬ ⍬ ⍬ ⍬ ⍬ BD  5 way Anova:  BD would pool
          ⍝                                                  B D
          ⍝                                                  AB AD BC BD BE CD DE ABC ABD
          ⍝                                                  ABE ACD ADE BCD BCE BDE CDE
          ⍝                                                  ABCD ABCE ABDE ACDE BCDE
          ⍝                                                  ABCDE
          ⍝                                                  In a 5-way Anova (with
          ⍝                                                  replicates) there are 31
          ⍝                                                  interactions: +/5 10 10 5 1
          ⍝
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ AutoCorr       find cyclical behavior
          ⍝                   ac ← AutoCorr x
          ⍝
          ⍝   Argument:     x:      a vector of numbers.
          ⍝   Result:      ac:      a string of correllation coefficients of the x vector
          ⍝                         with itself shifted over one step at a time.
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ CorrelationMatrix    the Pearson Correlation between all variables
          ⍝                   cm ← CorrelationMatrix   vov
          ⍝
          ⍝   Argument:   vov:  a  vector_○f_data_vectors all of the same length
          ⍝   Result:     cm:   a matrix of the correlation coefficient between each pair
          ⍝                     of variables.  The matrix is symetrical about the diagonal
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ CrossCorr      determine a "time" shift between two variables
          ⍝                   cc ← CrossCorr  x y
          ⍝
          ⍝   Arguments:  x y:   two vectors of equal length.
          ⍝   Result:     cc:    a string of correlation coefficients between the x vector
          ⍝                      and the y vector where succeeding values are dropped from
          ⍝                      the end of x and the beginning of y.  A "bump" would
          ⍝                      indicate a correlation shifted in "time" where y lags x.
          ⍝                      Switching x and y would indicate x lagging y.
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ CrossTabs      Chi-Square analysis of two "catagorical" vectors.
          ⍝                    ns ← CrossTabs  v w
          ⍝
          ⍝   Arguments:  v w:  two vectors of the same length of "categorical" data.
          ⍝                     The variables a usualy coded to match the responses to
          ⍝                     questionaires or otherwise counted data.
          ⍝                     v could be political party and w could be religion asked
          ⍝                     of a group of people.  v might be coded: 1=Jewish,
          ⍝                     2=Catholic, 3=Muslim, 4=Morman, etc.  w might be coded:
          ⍝                     1=Democratic, 2=Republican, 3=Independent, 4=Communist....
          ⍝                     A matrix is formed that would have the count for each
          ⍝                     pair of options.  The rows will be religion; the columns
          ⍝                     will be party.
          ⍝                     99 is interpreted as Missing and the data are uncounted.
          ⍝                     ¯1 is interpreted as deliberately unanswered and excluded
          ⍝                     from the Chi-Square calculation.
          ⍝                     The question would then be: is the distribution of party
          ⍝                     the same for all religions.  Row and column totals and
          ⍝                     the grand total of the cells are calculated.  Each cell
          ⍝                     value, if everything is "as expected", would be its row
          ⍝                     total times its column total divided by the grand total.
          ⍝                     The square of the sum of the deviations of cell values
          ⍝                     from their expected values is a Chi-Square statistic with
          ⍝                     degrees-of-freedom being one less than the number of
          ⍝                     active cells.  Chi-Square =1 : totally expected pattern
          ⍝                                               =0 : unlikely pattern
          ⍝
          ⍝   Result:   a namespace with the variables:
          ⍝                     CT_ChiSquare_DOF  CT_Alpha  CT_Cell_Counts  CT_Deltas
          ⍝                     CT_RowPercents  CT_ColumnPercents  CT_Overall_Percents
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ Descrete Fourier Transforms
          ⍝       there are four functions: DFT FFT IDFT and IFFT
          ⍝       They all take a vector as an argument and all deliver two things:
          ⍝             the expected output:  for DFT and FFT -- a complex vector
          ⍝                                   for IDFT and IFFT -- a realvector
          ⍝                                   a name space with: ComplexVector  Real Imag
          ⍝                                     Power  Phase and R_I_Matrix
          ⍝                                     where the real and imaginary values <1E¯9
          ⍝                                     have been forced to zero (usually created
          ⍝                                     by round-off error.
          ⍝
          ⍝      cvector ns  ←  DFT  x       (x is a real vector, usually a time series)
          ⍝              The DFT is by the raw definition of a discrete transform and is
          ⍝              of order n-squared.   That means slow for long x vectors >4000.
          ⍝              The x vector can be of any length (an advantage).
          ⍝
          ⍝      cvector ns  ←  FFT  x  (x is a real vector, usually a time series)
          ⍝              The Fast Forier Transform is of order n log n.  Much faster.
          ⍝              The length of the x vector should be a power of 2.  If it isn"t,
          ⍝              it is padded to the next power with zeros.
          ⍝
          ⍝      rvector ns  ← IDFT  c  (c: a complex vector, usually the output of a DFT)
          ⍝              The IDFT is by the raw definition of a inverse discrete transform
          ⍝               and is of order n-squared.   That means slow for long x vectors:
          ⍝               >4000.  The c vector can be of any length (an advantage).
          ⍝
          ⍝      rvector ns  ← IFFT  c  (c: a complex vector, usually the output of a FFT)
          ⍝              The Fast Inverse Transform is of order n log n.  Much faster.
          ⍝              The length of the x vector should be a power of 2.  If it isn"t,
          ⍝              it is padded to the next power with zeros.
          ⍝
          ⍝       You should expect  (⊃ IDFT ⊂ DFT x) to equal x to within round-off
          ⍝                     and  (⊃ IFFT ⊂ FFT x) to equal x to within round-off
          ⍝
          ⍝       If the padding is almost equal to the length of the data, the salient
          ⍝       features of the power spectrum are pretty much the same when the actual
          ⍝       number of frequencies in x are few.
          ⍝       Random noise of 100% of the "pure" signal leaves the bigger frequency
          ⍝       bins recognizable!
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ LeadLag       line up the positions of sequelnced data
          ⍝              vov  ←  LeadLag  vov updown {fill {cut_bottom {cut_top}}}
          ⍝
          ⍝   There are times when data are a function of time, that you need
          ⍝   to "line stuff up".   Rainfall and river level for example.  The
          ⍝   river sizes at a later time than when the rain fell.   What you
          ⍝   order actually arrives later.  Some materials need to be ordered
          ⍝   before others to have everyting ready for the construction job.
          ⍝   Early decision college offers might be accepted earlier than
          ⍝   regular offers.
          ⍝
          ⍝   Input:   related set (vector) of variables, (all the same length)
          ⍝            an equal size vector of how much each variable should be
          ⍝                 lifted (+) or pushed down (-) or left alone (0)
          ⍝            what the "fill" value should be: "L" last value before
          ⍝                 the fill or "Z" zero fill or "B" for blank (character
          ⍝                 data) or a number (which could be 0).  Default=0.
          ⍝            should the bottom of all variables be lopped off below the
          ⍝                 bottom of the biggest "lifted" variable (1) or not (0)
          ⍝                 Defaulted to 1.
          ⍝            should the top of all variables be lopped off down to the
          ⍝                 top of the biggest "pushed down" variable (1) or not (0)
          ⍝                 Defaulted to 1.
          ⍝   OutPut:  the shifted input data
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ ModelChebyshev    make a series of Chebyshev polynomials
          ⍝             vop  ←  ModelChebyshev  nd order
          ⍝
          ⍝   Input:      nd:  the number of data points for each polynomial
          ⍝            order:  how many polynomials
          ⍝   OutPut:  a vecctor of polynomials of increasing order
          ⍝
          ⍝       the advantage of these polynomials is that they are scaled ¯1 to 1 and
          ⍝       most significantly they are orthogonal. I.e., their correlation matrix
          ⍝       is the identity matrix.  Thus they can be used to do regressions safely
          ⍝       and the coefficients can be interpreted as slope, bend, wiggle, etc.
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ ModelQuadratic    make every order 2 (squares and cross-products) out of vov
          ⍝             qvov names  ←  ModelQuadratic vov
          ⍝
          ⍝   Input:     vov:  a vector of data vectors
          ⍝   Output:   qvov:  a vector of the squares and cross-products of the input.
          ⍝            names:  identifiers for the qvov:  A B C D...AA BB...AB AC...BC....
          ⍝       qvov ≡  the original vectors, followed by their squares, followed by
          ⍝               all of the unique cross prodlucts, in logical order
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ PrincipalComponents      one orthogonalization of data
          ⍝             ns  ←  PrincipleComponents  data
          ⍝
          ⍝   Input:  data:  a vector of vectors (padded with zeros to be of equal length)
          ⍝            or    a matrix with variables as columns
          ⍝   Output:   ns:  a namespace with:
          ⍝        PCOMP_Table -- the entire picture of the analysis as text
          ⍝     parts of that table  but as numbers
          ⍝        PCOMP_Components -- columns in order of explained variance (numerical)
          ⍝                            indicating the "importance" of each data variable
          ⍝                            in that component
          ⍝        PCOMP_Percent -- variance explained by each component
          ⍝        PCOMP_CumulativePercent -- cum.% variance explained by each component
          ⍝        PCOMP_EigenValues -- pivots generating the component matrix ("impact")
          ⍝     and
          ⍝        PCOMP_factors -- the data expressed as "factors".  The "regression" of
          ⍝                         each data vector with the Components as coefficients
          ⍝                         or weightings.
          ⍝        PCOMP_FactorsSorted --Each factor sorted.  Indicates which data
          ⍝                                  observations had the greatest impact.
          ⍝        PCOMP_FactorCovarianceMatrix -- cross-product of the factors
          ⍝        PCOMP_DataCorrelationMatrix -- correlations of the data
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ RegressChebyshev         regression using orthogonal Chebyshev variables
          ⍝            ns ← {var_names} RegressChebyshev y x order
          ⍝
          ⍝   Inputs:  right:     y:  the dependent (response) variable (Y)
          ⍝                       x:  the independent (X) variable
          ⍝                   order:  the highest power Chebyshev polynomial
          ⍝            left:  variable names for Y and X.  Defaults to "Y" and "X".
          ⍝   Output:  a namespace with the Forsythe regression namespace, and the results
          ⍝            of the Chebyshev regression
          ⍝
          ⍝      Because a Chebyshev regression requires the X values to be at particuarly
          ⍝      located positions, The data are first regressed with Forlsythe Orthogonal
          ⍝      polynomials (orthogonality insures that the regression will not fail).
          ⍝      That regression is then used to calculate Y values at the Chebyshev X
          ⍝      values.  Then the C_Y and C_polynomials (based on C_X) can be computed.
          ⍝      The underlying statistics and Anova are those of the Forsythye regression
          ⍝      The reason for doing the Chebyshev regression is that the coefficients
          ⍝      are interpretable. The first C_coefficient is the average of C_Y (not Y).
          ⍝      The second coefficient is the tilt or slope of the data.  The third is
          ⍝      the parabolic bend to the data.  The fourth is the "cubic" wiggle.  etc.
          ⍝      Given that Chebyshev polynomials have maximum amplitudes of +-1, you get
          ⍝      a glimpse of the "shape" of your Y data.  Thus it is easy to compare sets
          ⍝      of Y data.
          ⍝
          ⍝      Things contained in the output namespace:
          ⍝          Results of the Fourier Regression:  its output namespace: Fourier_ns
          ⍝            as well as some extracted info:
          ⍝              F_Yhat  F_Statistics  F_Residuals  F_ResultTable  F_AnovaTAble
          ⍝              F_ResidualsTable F_DigitsLost (due to regression: usually 0)
          ⍝          Results of the Chebyshev regression:
          ⍝              C_Coefficients  C_X  C_Y  C_Yhat  C_Residuals  C_DigitsLost
          ⍝              and the ChebyshevPolynomials
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ RegressForsythe     an orthogonal regression
          ⍝            ns ← {var_names} RegressForsythev y x order
          ⍝
          ⍝   Inputs:  right:
          ⍝                       y:  the dependent (response) variable (Y)
          ⍝                       x:  the independent (X) variable
          ⍝                   order:  the highest power Chebyshev polynomial
          ⍝            left:
          ⍝                   variable names for Y and X.  Defaults to "Y" and "X".
          ⍝   Output:  a namespace with Forsythe regression results:
          ⍝
          ⍝      Because the Forsythe polynomials are orthogonal, there is no loss of
          ⍝      accuracy in the solution due to inter-correlation of the "X" variables as
          ⍝      there is with a straight polynomial regression.
          ⍝
          ⍝      The name space includes:
          ⍝           X  Y  Yhat  Coefficients  Results  AnovaTable  Statistics
          ⍝           Residuals  ResidualsTable
          ⍝           ForsythePolynomialsOnX  ForsytheCoeffs
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ RegressFourier      a regression using sines and cosines
          ⍝            ns ← {var_names} RegressFourier y x order
          ⍝
          ⍝   Inputs:  right:     y:  the dependent (response) variable (Y)
          ⍝                       x:  the independent (X) variable
          ⍝                   order:  the number of (sine and cosine) terms
          ⍝            left:  names for Y and X.  Defaults to "Y" and "X".
          ⍝
          ⍝   Output:  a namespace with Fourier regression results:
          ⍝              Names X  Y  Yhat  Residuals  ResidualsTable
          ⍝              AnovaTable  Results  Statistics  DigitsLost
          ⍝              FourierXmatrix:  columns:  1  Sine Cosine S C S C ...
          ⍝              Coefficients:    constant sine cos sin cos ...
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ RegressMultipleLinear      standard regression (not done as y⌹x)
          ⍝            ns  ←  (var_names) RegressMultipleLinear y vov
          ⍝
          ⍝   Inputs:  right:     y:  the dependent (response) variable (Y)
          ⍝                     vov:  the independent (X) variables (vectors)
          ⍝            left:  names for Y and Xs.  Defaults to "Y" and "X1" "X2" "X3" ...
          ⍝
          ⍝   Output:  a namespace with regression results:
          ⍝              Xmatrix  Y  Yhat  Residuals  ResidualsTable
          ⍝              AnovaTable  Results  Statistics  DigitsLost  ConditionNumber
          ⍝              Coefficients  Coefs_byQuadDivide  X_names  Y_name
          ⍝              Max_Covariance  X_CorrelationMatrix
          ⍝
          ⍝         If you are working on a 16 digit platform, 16-DigitsLost is about how
          ⍝         many reliable digits there are in the coefficients.  If that is less
          ⍝         3, I wouldn"t trust the results (due to correlation between the Xs).
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ RegressPolynomial      standard regression on powers of x (not done as y⌹x)
          ⍝            ns  ←  (var_names) RegressPolynomial y x
          ⍝
          ⍝   Inputs:  right:     y:  the dependent (response) variable (Y)
          ⍝                       x:  the independent (X) variable
          ⍝            left:  names for Y and Xs.  Defaults to "Y" and "X1" "X2" "X3" ...
          ⍝
          ⍝   Output:  a namespace with regression results:
          ⍝              Xmatrix  X  Y  Yhat  Residuals  ResidualsTable
          ⍝              AnovaTable  Results  Statistics  DigitsLost  ConditionNumber
          ⍝              Coefficients  Coefs_byQuadDivide  X_names  Y_name
          ⍝              Max_Covariance  X_CorrelationMatrix
          ⍝
          ⍝         If you are working on a 16 digit platform, 16-DigitsLost is about how
          ⍝         many reliable digits there are in the coefficients.  If that is less
          ⍝         3, I wouldn"t trust the results (due to correlation between the Xs).
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ SimultaneousEquations        solve a set of linear algebraic equations
          ⍝                 soln_vector  digits_lost  ←  SimultaneousEquations Amat Rhs
          ⍝
          ⍝   Inputs:  Amat -- the coefficients matrix
          ⍝             Rhs -- the right hand side
          ⍝
          ⍝   The solutions is not done by:  Rhs ⌹ Amat , but rather in a manner that
          ⍝   checks the pivots to estimate digit_lost.   When working on a 16 digit
          ⍝   platform, 16-digits_lost is about how many reliable digits there are in the
          ⍝   solution.  If this falls below 3, I wouldn"t trust the results at all.
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ Statistics           get means, std.dev, etc for a set of x vectors
          ⍝               ns  ←  {names}  Statistics  vov
          ⍝
          ⍝   Input:      vov:  a vector of variable vectors.
          ⍝             names:  optional names for the variables
          ⍝   Output:   ns:  a namespace containing:
          ⍝                  StatisticsTable  Data_vov
          ⍝                  DataMatrix (padded with zeros if necessary)
          ⍝                  CorrelationMatrix (of DataMatrix)
          ⍝                  and all of the measures in the table individually numerical
          ⍝                      vectors, just in case you want to use them.
          ⍝
          ⍝                  Statistics table lists for each variable:
          ⍝                      IndesCount  Average  Min  Max  Std_dev  Skew  Kurtosis
          ⍝                      Coefficient_of_variation  %_=_0  %_near_0  {name}
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ StepWiseAll       multiple linear regression all allowable variables per step
          ⍝            ns  ←  {yxnames}  StepWiseAll  y  vox  fi  fo (starting_indecies)
          ⍝
          ⍝   Inputs:      y:  the dependent variable to be fitted with x
          ⍝              vox:  a vector of the independent variables
          ⍝               fi:  the lower limit of Fratio among the "out" variables that
          ⍝                    will determine it they are allowed "in".
          ⍝               fo:  the Fratio limit below which an "in" variable will be
          ⍝                    kicked out.
          ⍝               si:  The indecies of x variables that are initially "in" the
          ⍝                    regression.  This can include any legitimate index,
          ⍝                    including ⍬ and all of them.
          ⍝          yxnames:  a vector of optional variable names starting with the Y
          ⍝                    variable.  It must have 1+#_of_X_variables text names.
          ⍝
          ⍝   Output:  ns:  a namespace containing for the final regression:
          ⍝                     AnovaTable            distribution of sums_of_squares
          ⍝                     Coefficients          not done by y⌹x
          ⍝                     Results               stats for each variable
          ⍝                     Coefs_byQuadDivide
          ⍝                     DigitsLost            on a 16 digit platform 16-DL <3 or 4
          ⍝                                           is worrisome
          ⍝                     ConditionNumber
          ⍝                     In_Indecies  Out_Indecies
          ⍝                     In_Names  Out_Names
          ⍝                     Y_name     X_names
          ⍝                     Max_Covariance
          ⍝                     Statistics            including residuals analyses
          ⍝                     Xmatrix  Y  Yhat
          ⍝                     Residuals             (Y-Yhat)
          ⍝                     ResidualTable
          ⍝                     X_CorrelationMatrix   of the "in"s
          ⍝                 and for the process:
          ⍝                     InOut_path            what happened at each step
          ⍝                     In_Table              statistics for each step regression
          ⍝                     Out_Table             statistics for each step regression
          ⍝                     progress              the Fratios along the way
          ⍝                     NsIn   NsOut          the last step"s regression info
          ⍝
          ⍝      If you believe that the regression should include a constant, one of the
          ⍝      x variables (usually the first) should be all ones.
          ⍝
          ⍝      This regression process is iterative.  At each pass a regression is done
          ⍝      on the "in" variables and on the "out" variables.  This provides Fratios
          ⍝      that determine if any "in"s should be removed and if any "outs" should be
          ⍝      added to the "in"s.  Although most of the time this is done in one pass,
          ⍝      that is not necessarilly so.  The steps taken are itemized in the output
          ⍝      namespace as the variable:  InOut_path.
          ⍝
          ⍝      All regressions are done by row reduction in order to watch the pivots
          ⍝      to measure the degree of singularity of the  process.  This is
          ⍝      particularly relevant in regressons involving correlated xs.  On a 16
          ⍝      digit platform, losing 7 or 8 digits leaves answers good to 9 or 8
          ⍝      digits.  Losing more than 13 means that you probably can"t believe the
          ⍝      results at all.
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ StepWiseOne       multiple linear regression only one variable at a time
          ⍝            ns  ←  {yxnames}  StepWiseOne  y  vox  fi  fo (starting_indecies)
          ⍝
          ⍝
          ⍝ StepWiseAll       multiple linear regression allowable steps at a time
          ⍝            ns  ←  {yxnames}  StepWiseAll  y  vox  fi  fo (starting_indecies)
          ⍝
          ⍝   Inputs:      y:  the dependent variable to be fitted with x
          ⍝              vox:  a vector of the independent variables
          ⍝               fi:  the lower limit of Fratio among the "out" variables that
          ⍝                    will determine it they are allowed "in".
          ⍝               fo:  the Fratio limit below which an "in" variable will be
          ⍝                    kicked out.
          ⍝               si:  The indecies of x variables that are initially "in" the
          ⍝                    regression.  This can include any legitimate index,
          ⍝                    including ⍬ and all of them.
          ⍝          yxnames:  a vector of optional variable names starting with the Y
          ⍝                    variable.  It must have 1+#_of_X_variables text names.
          ⍝
          ⍝   Output:  ns:  a namespace containing for the final regression:
          ⍝                     AnovaTable            distribution of sums_of_squares
          ⍝                     Coefficients          not done by y⌹x
          ⍝                     Results               stats for each variable
          ⍝                     Coefs_byQuadDivide
          ⍝                     DigitsLost            on a 16 digit platform 16-DL <3 or 4
          ⍝                                           is worrisome
          ⍝                     ConditionNumber
          ⍝                     In_Indecies  Out_Indecies
          ⍝                     In_Names  Out_Names
          ⍝                     Y_name     X_names
          ⍝                     Max_Covariance
          ⍝                     Statistics            including residuals analyses
          ⍝                     Xmatrix  Y  Yhat
          ⍝                     Residuals             (Y-Yhat)
          ⍝                     ResidualTable
          ⍝                     X_CorrelationMatrix   of the "in"s
          ⍝                 and for the process:
          ⍝                     InOut_path            what happened at each step
          ⍝                     In_Table              statistics for each step regression
          ⍝                     Out_Table             statistics for each step regression
          ⍝                     progress              the Fratios along the way
          ⍝                     NsIn   NsOut          the last step"s regression info
          ⍝
          ⍝      If you believe that the regression should include a constant, one of the
          ⍝      x variables (usually the first) should be all ones.
          ⍝
          ⍝      This regression process is iterative.  At each pass a regression is done
          ⍝      on the "in" variables and on the "out" variables.  This provides Fratios
          ⍝      that determine if any "in"s should be removed and if any "outs" should be
          ⍝      added to the "in"s.  First one out→in variable will be chosen if one is
          ⍝      available.  When all "out"s can"t get in, one "in" variable is selected
          ⍝      if available.  When no variable can move the process stops.  The steps
          ⍝       taken are itemized in the output namespace as the variable:  InOut_path
          ⍝
          ⍝      All regressions are done by row reduction in order to watch the pivots
          ⍝      to measure the degree of singularity of the  process.  This is
          ⍝      particularly relevant in regressons involving correlated xs.  On a 16
          ⍝      digit platform, losing 7 or 8 digits leaves answers good to 9 or 8
          ⍝      digits.  Losing more than 13 means that you probably can"t believe the
          ⍝      results at all.
          ⍝
          ⍝===============================================================================
          ⍝
          ⍝ TukeyWindow      "round off" the ends of a vector
          ⍝                  wv  ←  {window_width}  TukeyWindow  v
          ⍝
          ⍝   Inputs:       v:  a reasonably long vector
          ⍝               w_w:  optionally the fraction of the data effected at each end.
          ⍝                     Defaults to .25; affecting a quarter of the input vector
          ⍝                     on each end.
          ⍝   Output:      wv:  the windowed vector.
          ⍝
          ⍝          v is usually a sound signal: music, speech, an accustic event or
          ⍝          noise recording
          ⍝.
          ⍝          Apply the original Tukey-Interim-Window.  This is "cosine" rounding
          ⍝          at each end of a time string to improve the apparent power spectrum
          ⍝          and Fourier Transform (DFT and FFT).  Sharp "edges" cause spurious
          ⍝          harmonics in the FFT, and this is supposed to reduce that problem.
          ⍝
          ⍝     cosine: goes 1 to ¯1  <::>  1-cos  goes 0 to 2  <::>  ÷ by 2  goes 0 to 1
          ⍝
          ⍝                                 *---.....---*
          ⍝                              *                 *
          ⍝                           *                       *
          ⍝                          *                         *
          ⍝                         *                           *
          ⍝                      *                                 *
          ⍝                ****                                       ****
          ⍝
          ⍝
          ⍝===============================================================================
          ⍝===============================================================================
          ⍝===============================================================================
          ⍝
          ⍝ Distrib      a namespace with functions that calculate various distributions.
          ⍝
          ⍝             P p :: the cumulative probability (integral from the left (1-⍺)
          ⍝             A ⍺ :: the tail probability (integral to the right)      (1-p)
          ⍝             C c :: critical ChiSquare
          ⍝             D d :: degrees of freedom:   DOF  (for F_ratio: denominator DOF)
          ⍝             N n :: degrees of freedom:   numerator DOF for F_ratio
          ⍝             F f :: critical F_ratio
          ⍝          big letter ≡ return  ⋄  little letters ≡ RighttHandArg
          ⍝
          ⍝
          ⍝-------------------------------------------------------------------------------
          ⍝ Normal:    ⍺ ← Normal_A     x      you give it x, it returns ⍺ (tail beyond x)
          ⍝            p ← Normal_P     x      returns integral up to x
          ⍝            y ← Normal_y     x      the ordinate of the normal curve at x
          ⍝            x ← Normal_Xa    ⍺      returns the x for that ⍺
          ⍝            x ← Normal_Xp    p      returns the x for that cumulative dist.
          ⍝
          ⍝
          ⍝-------------------------------------------------------------------------------
          ⍝ student t: ⍺ ← Student_A    t dof  return ⍺ for a given t and deg_of_freedom
          ⍝            p ← Student_P    t dof  return p   the most common usage
          ⍝            ⍺ ← Student_Atd  t dof  return ⍺   same as Student_A but consistant
          ⍝            p ← Student_Ptd  t dof  return p
          ⍝
          ⍝            t ← Student_Tad  ⍺ dof  return t
          ⍝            t ← Student_Tpd  p dof  return t
          ⍝            d ← Student_Dta  t ⍺    return Degrees_Of_Freedom  (DOF)
          ⍝            d ← Student_Dtp  t p    return DOF
          ⍝
     
          ⍝-------------------------------------------------------------------------------
          ⍝ ChiSquare: ⍺ ← ChiSq_A      c dof  given ChiSq and DOF return alpha
          ⍝            p ← ChiSq_P      c dof  given ChiSq and DOF return p (cum. dist.)
          ⍝            ⍺ ← ChiSq_Acd    c dof  given ChiSq and DOF return alpha
          ⍝            p ← ChiSq_Pcd    c p    given ChiSq and DOF return p
     
          ⍝            c ← ChiSq_Cad    ⍺ dof  given ⍺ and dof return critical ChiSquare
          ⍝            c ← ChiSq_Cpd    p dof  given cum.dist. return critical ChiSquare
          ⍝            d ← ChiSq_Dca    c ⍺    given ChiSq and ⍺ return DOF
          ⍝            d ← ChiSq_Dcp    c p    given ChiSq and p return DOF
     
          ⍝            ? ← ChiSq_CAD    c ⍺ d  substitute one of inputs with ⍬, get that
          ⍝                                    c ← ChiSq_CAD ⍬ ⍺ d
          ⍝                                    ⍺ ← ChiSq_CAD c ⍬ d
          ⍝                                    d ← ChiSq_CAD c ⍺     or C ⍺ ⍬
          ⍝            ? ← ChiSq_CPD    c p d  substitute one of inputs with ⍬, get that
          ⍝
          ⍝-------------------------------------------------------------------------------
          ⍝ F_ratio    ⍺ ← Fratio_A     F n d  return ⍺    the most common usage
          ⍝            p ← Fratio_P     F n d  return p    "
          ⍝            ⍺ ← Fratio_Afnd  F n d  return ⍺    same as Fratio_A but consistant
          ⍝            p ← Fratio_Pfnd  F n d  return p
          ⍝
          ⍝            f ← Fratio_Fand  ⍺ n d  return critical F_ratio
          ⍝            f ← Fratio_Fpnd  p n d  return critical F_ratio
          ⍝            n ← Fratio_Nfad  f ⍺ d  return critical F_ratio
          ⍝            n ← Fratio_Nfpd  f p d  return critical F_ratio
          ⍝            d ← Fratio_Dfan  f ⍺ d  return critical F_ratio
          ⍝            d ← Fratio_Dfpn  f p n  return critical F_ratio
          ⍝
          ⍝            ? ← Fratio_FAND  f ⍺ n d  subst. 1 arg. with ⍬, get that one
          ⍝            ? ← Fratio_FPND  f p n d  subst. 1 arg. with ⍬, get that one
          ⍝
          ⍝===============================================================================
          ⍝===============================================================================
          ⍝===============================================================================
          ⍝
          ⍝ Dutils    a namespace with functions used by the statistical and distributio
          ⍝           functions.  Not particularly for general use (but not worthless).
          ⍝
          ⍝===============================================================================
∇

∇ erf←Erf x;kernel;f;⎕ML;⎕IO
          ⍝  this is good to at least 12 and usually more digits
     
 ⎕ML←1 ⋄ ⎕IO←1
 kernel←{*-⍵*2}
 f←(2÷(○1)*0.5)
     
 :If x≤4.06
     erf←f×kernel Romberg_Trap 0 x
 :Else
     erf←1-f×kernel Romberg_Trap x 50
 :EndIf
     
 :Return
∇

∇ erf←Erf_alt x;kernel;f;⎕ML;⎕IO
          ⍝  this is good to at least 12 and usually more digits
     
 ⎕ML←1 ⋄ ⎕IO←1
 kernel←{*-⍵*2}
 f←(2÷(○1)*0.5)
     
 :If x≤4.06
     erf←f×kernel ∆GQ ∆QUAD 0 x 100
 :Else
     erf←1-f×kernel ∆GQ ∆QUAD x 50 100
 :EndIf
     
 :Return
∇

∇ e←EulerConstant
 e←⍎'.577215664901532860606512'
∇

∇ fbc←ForsythePolynomialCoeficients nsf;fp;fx;orderp;X;Y;XTX;XTY;res;digl;⎕ML;⎕IO
     
          ⍝∇ Extract the current polyunomials and regress each of them.
     
 ⎕ML←⎕IO←1
     
 fp←nsf.ForsythePolynomialsOnX
 orderp←2⊃⍴fp
 fx←fp[;2]
 fbc←,⊂(0 1)             ⍝  "x" is centered.
           ⍝  get regressions for fp[;i]
 :For i :In 3 To orderp
     :Trap 0
         fbc,←⊂fp[;i]⌹fx∘.*¯1+⍳i
     :Else
         X←fx∘.*¯1+⍳i ⋄ Y←fp[;i]
         XTX←(⍉X)+.×X ⋄ XTY←Y+.×X
         res digl←2↑XTY SolveSLAE XTX
         fbc,←⊂res
     :EndTrap
 :EndFor
     
 :Return
∇

∇ cols←matrix GetNamedColumns names;head;k;⎕ML;⎕IO
     
          ⍝∇  As a documentation help:  get column information from a matrix
          ⍝∇    by using names in the header (top row) of the matrix
          ⍝∇    names that don't exist will simply be loaded a ⍬
 ⎕ML←⎕IO←1
     
 head←RemoveExcessBlanks¨matrix[1;]
 :If 1=≡names ⋄ names←,⊂names ⋄ :EndIf
 k←head⍳names
     
 cols←(matrix,⊂⍬)[;k]
 cols[1;]←names
     
 :Return
∇

∇ (a d e z)←ImplicitQL(v a d e n);l;j;m;p;eps;g;r;s;c;i;f;b;ia;To;⎕ML;⎕IO
     
          ⍝∇      A←QL where Q is orthagonal and L is lower triangular
          ⍝∇      plinked from GLIB:EIGPAK
          ⍝∆      FROM NUMERISCHE MATHEMATIK 12, 337-383 (1968)
     
 ⎕ML←⎕IO←1
     
 To←{(×⍺-⍵)+⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 eps←16*¯13
 e←1⌽e
 ia←⍳n
 j←0
 :For l :In ⍳n-1
TryAgain:
     m←(l-1)↓⍳n-1
     m←(l-1)+((|e[m])≤eps×((|d[m])+|d[m+1]))⍳1
     p←d[l]
     :If m=l ⋄ j←0 ⋄ :Continue ⋄ :EndIf
     j+←1
     :If 30<j ⋄ 'Routine has failed.  Returns Eigenvalues found so far.' ⋄ l-←2 ⋄ :Leave ⋄ :EndIf
     r←4○g←(d[l+1]-p)÷2×e[l]
     g←d[m]+(e[l]÷g+r×1-2×g<0)-p
     s←c←1
     p←d[m]
     i←m
     :For i :In (m-1)To l
         f←s×e[i]
         b←c×e[i]
         :If </|f g
             e[i+1]←g×r←4○c←f÷g
             s←c÷r
             c←÷r
          ⍝                'gb'Watcher i l j g s c f b(e[i+1])
     
         :Else
             e[i+1]←f×r←4○c←g÷f
             c←c×s←÷r
          ⍝                'gs'Watcher i l j g s c f b(e[i+1])
     
         :EndIf
         r←d[i]+p
         p←(c×f←(c×d[i])-s×b)-s×g←(c×b)-s×p
         g←(s×f)+c×g
         d[i+1]←r-p
         :If v
             a[ia;i+0 1]←a[ia;i+0 1]+.×2 2⍴c,s,(-s),c
         :EndIf
          ⍝           'el'Watcher i l j g s c f b r p(e[i])(d[i+1])
     
     :EndFor  ⍝ on i
     d[l]←p
     e[l]←g
     e[m]←0
     :GoTo TryAgain
 :EndFor
     
 z←(l+1)↑d
 a←((l+1),n)↑a
     
 :Return
∇

∇ ix←IncBetaI(x nu1 nu2);ker;NON;⎕ML;⎕IO
     
           ⍝∇ Incomplete Beta Function  A&S p944  26.5.1
           ⍝∇ Given:    the abscissa, and two degrees of freedom
     
     
 ⎕ML←1 ⋄ ⎕IO←1
 ker←{⍵=0:0 ⋄ (⍵*nu1-1)×(1-⍵)*nu2-1}
 NON←100
 :If (nu2≤4)∧(nu1≤1) ⋄ NON←1000 ⋄ :EndIf
          ⍝ :If (nu2<2)∧(nu1<1) ⋄ NON←200000 ⋄ :EndIf
     
 ix←(÷Beta nu1 nu2)×(ker ∆GQ)∆QUAD 0 x NON
     
 :Return
∇

∇ ib←IncBeta_Integers(x nu1 nu2);omx;mult;sum;To;⎕ML;⎕IO
     
          ⍝∇ A&S 26.5.7  p944
     
 ⎕ML←1 ⋄ ⎕IO←1
 To←{(×⍺-⍵)×⍺+(×⍵-⍺)×⍳1+|⍵-⍺}
 omx←1-x
 mult←(omx*nu1+nu2-1)
 sum←+/{(⍵!nu1+nu2-1)×(x÷omx)*⍵}¨0 To nu1-1
     
 ib←1-mult×sum
 :Return
∇

 IsChar←{(10|⎕DR ⍵)∊0 2
          ⍝ in v12+
 }

 IsNumb←{1=2|⎕DR ⍵
          ⍝ in v12+
 }

∇ {ys}←LagrangeInterpolation(x y xs np);Select;io;n;i;iu;xu;yu;num;den;⎕ML;⎕IO
     
          ⍝∇ Given:   xy data and a number of points (np):  This assumes a monotonic x
          ⍝∇ Return:  interpolated ys values at xs using n datapoints  from xy
     
 ⎕ML←⎕IO←1
     
 Select←{(¯1+((≢x)-⍺-1)⌊1⌈(+/⍵≥x)+1-⍺÷2)+⍳⍺}
 np←2×⌈np÷2
 xs←,xs
     
          ⍝  make sure x is monotonic:   just in case
 io←⍋x ⋄ x←x[io] ⋄ y←y[io]
 n←≢x
 ys←⍬
 :For i :In ⍳≢xs
     iu←np Select i⊃xs
     xu←x[iu] ⋄ yu←y[iu]
     num←(np⍴i⊃xs)∘.-xu
     (1 1⍉num)←1
     den←xu∘.-xu
     (1 1⍉den)←1
     ys,←+/yu××/num÷den
 :EndFor
∇

∇ cp←MakeChebyshevPolynomialX(order nd);⎕ML;⎕IO
     
          ⍝∇ Create a chebyshev polynomial "x" vector
          ⍝∇ order defaults to nd if order=0
     
 ⎕ML←⎕IO←1
     
 order←(|order×order≠0)+(nd×order=0)
 cp←nd⍴⌽2○((○1)×¯1+2×⍳order)÷order×2
∇

∇ cp←MakeChebyshevPolys(x order);i;⎕ML;⎕IO
     
          ⍝∇   Create a bunch of chebyshev polylnomials recursively; given x and order
          ⍝∇   The first two columns are 1 and x;  therefore, there will be order+1 columns
     
 ⎕ML←⎕IO←1
     
 cp←1,[1.5]x
 :For i :In 2↓⍳order+1
     cp,←(2×x×cp[;i-1])-cp[;i-2]
 :EndFor
∇

∇ MakeDoc;rn;rm;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
     
 rn←↓1 1↓⎕CR'Documentation'
 rn←Rtb¨rn
 rm←(⊂'rm,←⊂'''),¨rn,¨''''
 rm←'{rm}←Stats_Documentation' '  '('rm←''''')('rm,←⊂'' generated by MakeDoc  using   Documentation'''),rm
 rm,←⊂'rm←↑rm'
 ⎕CS'#'
 ⎕FX rm
     
 :Return
∇

∇ (fx co)←MakeForsythePolys(x order);⎕ML;⎕IO;on;n;zo;ave;zi;zossum;zissum;gam;del;zn
     
           ⍝∇ make forsythe polynomials (recursively) based on X and of hightest power: order
           ⍝∇    that will be order+1 columns as the firat column will be 1s.
     
 ⎕ML←⎕IO←1
 on←1+order
 n←≢x
     
          ⍝                   f  will be the model with order+1 variables (columns)
          ⍝                   f1 will be ones
          ⍝                   f2 will be the 1st Forsythe Polynomial:  x-xave
          ⍝                   fn will be the (n-1)th order Forsythe polynomial
     
 zo←n⍴1
 ave←Average x
 zi←x-ave
     
 fx←zo,[1.5]zi
 co←1 2⍴ave 0
 :For i :In 2↓⍳on
     zossum←SumByTwos zo*2
     zissum←SumByTwos zi*2
     gam←(SumByTwos x×zi*2)÷zissum
     del←(SumByTwos x×zi×zo)÷zossum
     zn←(zi×x-gam)-del×zo
     zo←zi
     zi←zn
     fx,←zn
     co⍪←gam del
 :EndFor
     
 :Return
∇

∇ MakeReadMe;rn;rm
     
 rn←↓1 1↓⎕CR'Notes'
 rn←Rtb¨rn
 rm←(⊂'rm,←⊂'''),¨rn,¨''''
 rm←'{rm}←ReadMe' '  '('rm←''''')('rm,←⊂''      generated by MakeReadMe    using   Notes'''),rm
 ⎕CS'#'
 ⎕FX rm
     
 :Return
∇

∇ n←MatNormFrob m;⎕ML;⎕IO
 ⎕ML←⎕IO←1
     
 n←(SumByTwos,m*2)*0.5
 :Return
∇

∇ n←MatNormInf m;⎕ML;⎕IO
 ⎕ML←⎕IO←1
     
 n←⊃⌈/SumByTwos¨↓m
 :Return
∇

∇ n←MatNormOne m;⎕ML;⎕IO
 ⎕ML←⎕IO←1
 n←⊃⌈/SumByTwos¨↓[1]m
 :Return
∇

 Moment←{
      ⍝ Calculate the moment of a vector of differences, wrt. sigma,
      ⍝ at some  power
     diff sigma power←⍵
     r←≢diff
     (r÷⍨+/diff*power)÷{⍵+⍵=0}sigma*power
 }

∇ (mr ma in io rem add)←MoveRegVars(cr ca i_in i_out);⎕ML;⎕IO
     
          ⍝∇ the regression variables are either "in" "or "out" and the
          ⍝∇ idea is to get the right variables into the right catagory.
          ⍝∇ One way is to use the Fratios from regressions.  cr (remove)
          ⍝∇ and  ca (add) can be used to move the indexes for the in and
          ⍝∇ out variables.
          ⍝∇ Currently this function moves everything possible.
     
 ⎕ML←⎕IO←1
 mr←cr>0             ⍝  mask of which can come out
 ma←ca>0             ⍝  mask of which can be added
 rem←mr/i_in
 add←ma/i_out
 in←(~mr)/i_in       ⍝  take out the "removable" indexes from "in"
 io←(~ma)/i_out      ⍝  take out the "addable" ndexes from "out"
 in,←ma/i_out        ⍝  put them the other pile
 io,←mr/i_in
 in←{⍵[⍋⍵]}in        ⍝  sort them, just because
 io←{⍵[⍋⍵]}io
     
 :Return
∇

∇ (mr ma i_in i_out rem add)←MoveRegVarsOne(cr ca i_in i_out);maxr;maxa;ir;ic;ia;⎕ML;⎕IO
     
          ⍝∇ the regression variables are either "in" "or "out" and the
          ⍝∇ idea is to get the right variables into the right catagory.
          ⍝∇ One way is to use the Fratios from regressions.  cr (remove)
          ⍝∇ and  ca (add) can be used to move the indexes for the in and
          ⍝∇ out variables.
          ⍝∇ Currently this function moves everything possible.
     
 ⎕ML←⎕IO←1
 mr←cr>0
 ma←ca>0
 maxr←⌈/cr,0
 maxa←⌈/ca,0
     
 :If maxr>maxa
          ⍝ remove one variable
     ir←cr⍳maxr
     ic←ir⊃i_in
     i_in~←ic
     i_out,←ic
     rem←ic
     add←0
 :Else
          ⍝ add one variable
     ia←ca⍳maxa
     ic←ia⊃i_out
     i_in,←ic
     i_out~←ic
     rem←0
     add←ic
 :EndIf
     
 i_in←{⍵[⍋⍵]}i_in        ⍝  sort them, just because
 i_out←{⍵[⍋⍵]}i_out
     
 :Return
∇

∇ z←Normal x;⎕ML;⎕IO
     
          ⍝∇  z ← Normal x --  ordinate of the normal distribution
     
 ⎕ML←⎕IO←1
 z←(*-0.5×x*2)÷(○2)*0.5
     
 :Return
∇

∇ ntab←NormalTableOrder tab;⎕IO;r;c;n;w;m;k;⎕ML
     
          ⍝∇     put the output anova table into normal format:
          ⍝∇         A B AB   C AC BC ABC  D AD .....
          ⍝∇     instead of the straight format it was created in:
          ⍝∇         A B C D ....  AB AC AD..BC BD ....  ABC ABD .....
     
 ⎕IO←1 ⋄ ⎕ML←1
     
 r c←⍴tab
 n←⌊2⍟(1.5+r)
     
 w←CompleteComb n
 m←⍴w
 k←⍋↑(⌈/⍴¨w)↑¨⌽¨w
     
          ⍝   SHOW 'X' X
          ⍝   SHOW 'M' M
          ⍝   SHOW 'W' W
          ⍝   SHOW 'R C N' R C N
          ⍝   SHOW 'Y' Y
     
 ntab←tab[k;]
     
 :Return
∇

∇ NS←OrthoCalc(x y fp b xty xtx inv xbar ybar names);Divide;yname;xname;bxty;y11y;yty;yhat;errs;sosbo;sosdr;sostc;sost;dofbo;dofb;doft;ybo;doftc;dofe;msbo;msdr;msar;sesq;serr;fratio;tstat;mrcsq;mrc;seob;max_cov;st_t;pvalues;alpha;list;yhatbar;soser;⎕ML;⎕IO
     
          ⍝∇   x and y are  the raw data;  b are the regression coefficients
          ⍝∇   inv is the inverse of the xtx matrix and the ..bar are averages
     
 ⎕ML←⎕IO←1
 Divide←{({⍵+⍵=0}⍺)÷{⍵+0.000001000001×⍵=0}⍵}
 yname xname←2↑names
     
 bxty←b+.×xty
 y11y←((+/y)*2)Divide≢y
 yty←y+.×y
     
 yhat←fp+.×b
 yhatbar←Average yhat
 errs←y-yhat
     
 sosbo←y11y                         ⍝ constant sos
 soser←+/errs*2                     ⍝ error sos
 sostc←+/(y-ybar)*2                 ⍝ sos to be explained
 sost←yty                           ⍝ total y sos
 sosdr←sostc-soser                  ⍝ sos that was explained
     
 ybo←1         ⍝  is there to be an intercept
 dofbo←ybo
 dofb←(≢b)-ybo
 doft←(≢y)
 doftc←(≢y)-ybo
 dofe←1⌈doft-(≢b)
     
 msbo←sosbo
 msdr←sosdr Divide dofb
 msar←soser Divide dofe
 sesq←msar
 serr←(|sesq)*0.5
 fratio←3 RndDP 999999⌊(msdr Divide msar)
 tstat←serr×(|inv)*0.5
     
 mrcsq←sosdr Divide sostc
 mrc←4 RndDP((|mrcsq)*0.5)
 seob←tstat
     
 max_cov←0
 st_t←3 RndD b Divide seob
 pvalues←3 RndD ##.Distrib.Fratio_A¨(|st_t*2),¨⊂doftc 1
 alpha←3 RndD ##.Distrib.Fratio_A fratio dofb dofe
     
 NS←⎕NS''
 list←' '(≠⊆⊢)'x y fp b xty xtx inv xbar ybar yname xname bxty y11y yty yhat errs sosbo sosdr soser sostc sost dofbo dofb dofe doft doftc msbo msdr msar sesq serr fratio tstat mrcsq mrc seob  max_cov st_t pvalues alpha'
 ⍎'NS.(',(⍕list),')←',⍕list
∇

∇ nso←OrthoOut nsc;b;seob;st_t;nb;Result;u;v;e;s;AnovaT;⎕ML;⎕IO
     
          ⍝∇ make the anova and tabulation tables
     
 ⎕ML←⎕IO←1
 nso←⎕NS''
     
 b seob st_t←nsc.(b seob st_t)
 nb←≢b
 Result←((nb+2),6)⍴0
 Result[;1]←' i ' '---',(¯1+⍳nb)
 Result[;2]←'         B      ' '  --------------',b
 Result[;3]←'    std. err.   ' '  --------------',seob
 Result[;4]←'  stud_t' '  ------',st_t
 Result[;5]←' F to keep' ' --------',(2 RndDP 99999⌊st_t*2)
 Result[;6]←' Alpha' ' ------',(3 RndDP nsc.pvalues)
     
 u←'   Sum of Squares ' ' DOF' '    Mean Square  ' '   F ratio ' '   Alpha '
 v←'  ----------------' ' ---' '  ---------------' '  ---------' '  -------'
 e←'  ================' ' ===' '  ===============' '  =========' '  ======='
 s←'        Source  ' ' -----------------' ' constant ' ' due to reg.' ' error   ' ' ==================' ' explained: reg+err ' ' total '
     
     
 AnovaT←8 5⍴⊂'  '
 AnovaT[1;]←u
 AnovaT[2;]←v
 AnovaT[3;]←(5 RndDP nsc.(sosbo dofbo msbo)),'  ' '  '
 AnovaT[4;]←(5 RndDP nsc.(sosdr dofb msdr fratio alpha))
 AnovaT[5;]←(7 RndDP nsc.(soser dofe msar)),'  ' '  '
 AnovaT[6;]←e
 AnovaT[7;]←(5 RndDP nsc.(sostc doftc)),'  ' '  ' '  '
 AnovaT[8;]←(5 RndDP nsc.(sost doft)),'  ' '  ' '  '
 AnovaT←s,AnovaT
     
 nso.(Result AnovaT)←Result AnovaT
     
 :Return
∇

∇ nss←OrthoStats nsc;Divide;Rnd;list;N;NT;NB;BIG_E;WB_E;PC_E;BIGPC_E;WB_PCE;INDIV_Z;GIZ;WHICH_BIG;SORT;DURB;EQUAL_VAR;ERR_CORR;ERR_PATRN;NO_RUNS;NO_ABOVE;NO_BELOW;SIGN_RAT;SIGN_MU;SIGN_SIG;SIGN_Z;WHICH_INFL;R_TABLE;R_T;DIGITS_LOST;PERC_EXP;Stats;COOK;WI_C;AP_Q;WI_Q;AP_FIRST;AP_SECOND;AP_STAT;WI_1;WI_2;WI_S;R;SW;in;tr;bp;bod;TU;TT;⎕ML;⎕IO
     
          ⍝∇  collect results on the data points
     
 ⎕ML←⎕IO←1
 Divide←{({⍵+⍵=0}⍺)÷{⍵+0.000001000001×⍵=0}⍵}
 Rnd←{⍎30 ⍺⍕⍵}
 nss←⎕NS''
     
          ⍝  this makes the notation for what is in nsc easier
 list←nsc.⎕NL ¯2
 ⎕SHADOW list
 ⍎(⍕list),'←nsc.(',(⍕list),')'
     
 N←≢y
 NT←6⌊N
 NB←≢b
     
 BIG_E←⌈/|errs
 WB_E←NT↑⍒|errs
 PC_E←3 Rnd 100×¯1⌈1⌊errs Divide(|yhat)
 BIGPC_E←⌈/|PC_E
 WB_PCE←NT↑⍒|PC_E
 INDIV_Z←3 RndD(errs Divide serr)
 GIZ←⍋|INDIV_Z
 WHICH_BIG←(2.5<|INDIV_Z[GIZ])/(⍳N)[GIZ]
     
 SORT←errs[⍋yhat]
 DURB←2 Rnd(+/((1↓SORT)-(¯1↓SORT))*2)Divide+/SORT*2
     
 EQUAL_VAR←4 Rnd((¯10000000000⌈10000000000⌊errs)*2)+.×(¯10000000000⌈10000000000⌊yhat)
 ERR_CORR←4 Rnd(errs+.×yhat)
 ERR_PATRN←4 Rnd(errs+.×yhat*2)
 NO_RUNS←4 Rnd(1++/(¯1↓errs<0)≠(1↓errs<0))
 NO_ABOVE←+/errs>0
 NO_BELOW←+/errs<0
 SIGN_RAT←3 Rnd(NO_ABOVE Divide NO_BELOW+NO_BELOW=0)
 SIGN_MU←1+(2×NO_ABOVE×NO_BELOW)Divide(NO_ABOVE+NO_BELOW)
 SIGN_SIG←(2×NO_ABOVE×NO_BELOW)×((2×NO_ABOVE×NO_BELOW)-(NO_ABOVE+NO_BELOW))Divide(((NO_ABOVE+NO_BELOW)*2)×(NO_ABOVE+NO_BELOW-1))
 SIGN_Z←2 Rnd(NO_RUNS+0.5-SIGN_MU)Divide SIGN_SIG*0.5
 R←1 1⍉fp+.×⍉(inv)×[2]fp
 COOK←100×((errs Divide serr×(|1E¯20+1-R)*0.5)*2)×(R Divide(1E¯20+1-R))Divide NB
 WI_C←NT↑⍒|COOK
 COOK←0 RndD(100×COOK)
 AP_Q←10×(1E¯10⌈|(1 Divide(1E¯20+1-R))×errs*2)Divide msar
 WI_Q←NT↑⍒|AP_Q
 AP_FIRST←1-(¯10000000000⌈10000000000⌊AP_Q)Divide(1E¯10⌈soser)
 AP_SECOND←1-R
 AP_STAT←AP_FIRST×AP_SECOND
 AP_Q←0 RndD AP_Q
 AP_FIRST←0 RndD(100×1-AP_FIRST)
 WI_1←NT↑⍒|AP_FIRST
 AP_SECOND←0 RndD(100×1-AP_SECOND)
 WI_2←NT↑⍒|AP_SECOND
 AP_STAT←0 RndD(100×1-AP_STAT)
 WI_S←NT↑⍒|AP_STAT
     
 WHICH_INFL←(1↑WB_E)(1↑WB_PCE)(1↑WI_C)(1↑WI_Q)(1↑WI_1)(1↑WI_2)(1↑WI_S)
     
 R_T←(⍳N),x,y,(⍎¨3⍕¨yhat),(⍎¨3⍕¨errs),(⍎¨1⍕¨PC_E),(⍎¨3⍕¨INDIV_Z),(COOK),(AP_Q),(AP_FIRST),(AP_SECOND),[1.5](AP_STAT)
 TU←'---' '------' '------' '------' '------' '------' '------' '------' '----' '----' '----' '----'
 TT←' i ' '    x ' '    y ' ' y_hat' ' resid' ' % err' ' res_z' ' Cook ' 'AP q' 'AP 1' 'AP 2' ' AP '
 R_T←TT⍪TU⍪R_T
     
 ERR_CORR←4 Rnd(ERR_CORR×0.000001<|ERR_CORR)
 PERC_EXP←2 Rnd(100×mrcsq)
     
 DIGITS_LOST←0
 :Trap 0
     in←⌹(⍉fp)+.×fp
     tr←1 1⍉in
     bp←⌈/|tr
     in÷←bp
     (1 1⍉in)←0
     bod←⌈/,|in
     DIGITS_LOST←0⌈17+10⍟|bod
 :EndTrap
     
 SW←110
 Stats←27 SW⍴' '
 Stats[1;]←SW↑'equal var. stat.       ',⍕EQUAL_VAR
 Stats[2;]←SW↑'correl. error stat.    ',⍕ERR_CORR
 Stats[3;]←SW↑'patterned err. stat.   ',⍕ERR_PATRN
 Stats[4;]←SW↑'no. positive errors    ',⍕NO_ABOVE
 Stats[5;]←SW↑'no. negative errors    ',⍕NO_BELOW
 Stats[6;]←SW↑'error sign ratio       ',⍕SIGN_RAT
 Stats[7;]←SW↑'sign pattern z         ',⍕SIGN_Z
 Stats[8;]←SW↑'               influential residuals: most→less '
 Stats[9;]←SW↑'largest residuals      ',6 0⍕WB_E
 Stats[10;]←SW↑'largest % residuals    ',6 0⍕WB_PCE
 Stats[11;]←SW↑'   (outliers)  Q       ',6 0⍕WI_Q
 Stats[12;]←SW↑'   (outliers)  AP 1    ',6 0⍕WI_1
 Stats[13;]←SW↑'   (remote)    AP 2    ',6 0⍕WI_2
 Stats[14;]←SW↑'   (AP1×AP2)   AP      ',6 0⍕WI_S
 Stats[15;]←SW↑'   (coeffnts.) Cook    ',6 0⍕WI_C
 Stats[16;]←SW↑'biggest covariance     ',⍕max_cov
 Stats[17;]←SW↑' '
 Stats[18;]←SW↑'big err. : index       ',(⍕BIG_E),' : ',4 0⍕1↑WB_E
 Stats[19;]←SW↑'big % err. : index     ',(⍕BIGPC_E),' : ',4 0⍕1↑WB_PCE
 Stats[20;]←SW↑'errors having z>2.5    ',6 0⍕WHICH_BIG
 Stats[21;]←SW↑'Durbin Watson stat.    ',⍕DURB
 Stats[22;]←SW↑'digits lost            ',⍕DIGITS_LOST
 Stats[23;]←SW↑'multpl. reg. coeff.    ',⍕mrc
 Stats[24;]←SW↑'% var. explained       ',⍕PERC_EXP
 Stats[25;]←SW↑'std. err. (sigma)      ',⍕serr
 Stats[26;]←SW↑'total variance in y    ',⍕sostc÷N
 Stats[27;]←SW↑'unexplained var.       ',⍕soser÷N
     
 nss.Stats←Stats
 nss.ResidTable←R_T
 nss.DL←DIGITS_LOST
          ⍝ EOR
∇

∇ p←yor ParrCorr xio;xi;xo;yo;yr;nx;pr;fe;m;i;res;ans;b;f;f_r;uv;br;dw;dl;⎕ML;⎕IO
     
          ⍝∇  something
     
 ⎕ML←⎕IO←1
 xi xo←xio
 yo yr←yor
     
 nx←⊃⌽⍴xo
 :If nx=0 ⋄ p←⍬ ⋄ :Return ⋄ :EndIf
 pr←nx⍴0
 fe←nx⍴0
 m←×/⍴xi
     
 :For i :In ⍳nx
     res←xo[;i]
     :If m≠0
         ans←xo[;i]StepRegressionSAE xi
         b f f_r uv br dw dl res←ans
     :EndIf
     
     pr[i]←yr Corr MOST∆M∆CORR res
     
     ans←yo StepRegressionSAE xi,xo[;,i]MOST∆M∆STEPD_REG(XI),XO[;,I]
     b f f_r uv br dw dl res←ans
     fe[i]←¯1↑f_r
 :EndFor
     
 p←pr fe
∇

∇ R←QW
 R←0.01761400713915398 0.04060142980038305 0.06267204833410894 0.08327674157670416 0.10193011981724036 0.11819453196151901 0.13168863844917705 0.1420961093183821 0.1491729864726038 0.152753387130726 0.152753387130726 0.1491729864726038 0.1420961093183821 0.13168863844917705 0.11819453196151901 0.10193011981724036 0.08327674157670416 0.06267204833410894 0.04060142980038305 0.01761400713915398
∇

∇ R←QZ
 R←¯0.9931285991850949 ¯0.9639719272779139 ¯0.912234428251326 ¯0.8391169718222189 ¯0.7463319064601508 ¯0.6360536807265149 ¯0.510867001950827 ¯0.37370608871541955 ¯0.22778585114164507 ¯0.07652652113349734 0.07652652113349734 0.22778585114164507 0.37370608871541955 0.510867001950827 0.6360536807265149 0.7463319064601508 0.8391169718222189 0.912234428251326 0.9639719272779139 0.9931285991850949
∇

∇ T←RandNorm N;⎕ML;⎕IO
     
          ⍝∇ t ← ∆RANDN n  --  deliver n normally distributed random numbers:
          ⍝∇     ──────           mean=0, std=1
     
 ⎕ML←1 ⋄ ⎕IO←1
 T←(2○○2×?N⍴0)×0.5*⍨-2×⍟?N⍴0
 :Return
     
     
          ⍝===============================================================
          ⍝    three times slower on a million numbers
 T←N⍴0
 :For I :In ⍳12
     T+←?N⍴0
 :EndFor
 T←T-6
     
     
          ⍝    five times slower yet than that on a million numbers:  15x slower
 T←N⍴0
 :For I :In ⍳N
     T[I]←¯6++/?12⍴0
 :EndFor
 T←T-6
     
          ⍝    untimed: (but it takes up a lot of space!!!)
 T←6-+/N 12⍴?(12×N)⍴0
∇

∇ NS←RegressCalc(x y b xty xtx inv xbar ybar ib names);Divide;yname;xnames;bxty;y11y;yty;yhat;errs;sosbo;sosdr;sosar;sostc;sost;dofbo;dofb;dofe;doft;doftc;msbo;msdr;msar;sesq;serr;fratio;tstat;mrcsq;mrc;seob;trc;denom;req;covr;bigcv;max_cov;st_t;list;pvalues;alpha;r;const;m;ic;k;⎕ML;⎕IO
     
          ⍝∇   x and y are  the raw data;  b are the regression coefficients
          ⍝∇   inv is the inverse of the xtx matrix and the ..bar are averages
     
 ⎕ML←⎕IO←1
     
 Divide←{({⍵+⍵=0}⍺)÷{⍵+0.000001000001×⍵=0}⍵}
 yname←⊃names
 xnames←1↓names
 const←∨/m←∧⌿1=x
 :If const
     ic←m⍳1
     k←⍳2⊃⍴x
     x←x[;ic,k~ic]
     names←names[1(ic+1)],(1↓names)[k~ic]
 :EndIf
 bxty←b+.×xty
 :If const
     y11y←((+/y)*2)Divide≢y
 :Else
     y11y←0
 :EndIf
 yty←y+.×y
     
 yhat←x+.×b
 errs←y-yhat
     
 sosbo←y11y
 sosdr←+/(yhat-const×ybar)*2
 sosar←+/errs*2
 sostc←+/(y-const×ybar)*2
 sost←yty
     
 dofbo←∧/x[;1]=1
 dofb←(≢b)-dofbo
 dofe←(≢y)-≢b
 doft←≢y
 doftc←doft-dofbo
     
 msbo←sosbo
 msdr←sosdr Divide dofb
 msar←sosar Divide dofe
 sesq←msar
 serr←(|sesq)*0.5
 fratio←3 RndDP 999999⌊(msdr Divide msar)
 tstat←serr×(|inv)*0.5
 mrcsq←sosdr Divide sostc
 mrc←3 RndDP((|mrcsq)*0.5)
 seob←1 1⍉tstat
     
 trc←1000000000000000⌊¯1000000000000000⌈1 1⍉inv
 denom←trc∘.×trc
 denom←(denom=0)+(denom×denom≠0)
 req←inv Divide(|denom)*0.5
 covr←4 RndDP¨(req-ib)
 bigcv←⌈/|covr
 max_cov←⌈/|bigcv
 st_t←⍎¨3⍕¨(b Divide 1E¯9⌈seob)
 pvalues←##.Distrib.Student_A¨(|st_t),¨doftc
 alpha←##.Distrib.Fratio_A fratio dofb dofe
     
 NS←⎕NS''
 list←' '(≠⊆⊢)'x y b xty xtx inv xbar ybar ib yname xnames bxty y11y yty yhat errs sosbo sosdr sosar sostc sost dofbo dofb dofe doft doftc msbo msdr msar sesq serr fratio tstat mrcsq mrc seob trc denom req covr bigcv max_cov st_t pvalues alpha'
 ⍎'NS.(',(⍕list),')←',⍕list
     
 :Return
∇

∇ NSR←RegressResults NSC;pvalues;nb;nd;T;U;E;S;Result;AnovaR;yvn;xvns;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
 NSR←⎕NS''
     
 nb←≢NSC.b ⋄ nd←≢NSC.y
 Result←((nb+2),8)⍴0
 Result[;1]←' variables ' '----------',(NSC.xnames)
 Result[;2]←'         B      ' '  -------------',7 RndS¨NSC.b
 Result[;3]←'    std. err.   ' '  -------------',8 RndDP¨NSC.seob
 Result[;4]←'  stud_t' '  ------',2 RndDP|NSC.st_t
 Result[;5]←' alpha P' '  ------',3 RndDP NSC.pvalues
 Result[;6]←' max.cov.' ' --------',NSC.bigcv
 Result[;7]←' F-remove' ' --------',3 RndDP 99999⌊(NSC.st_t*2)
 Result[;8]←' Alpha' ' --------',3 RndDP ##.Distrib.Fratio_A¨(|NSC.st_t*2),¨⊂1 NSC.dofe
     
     
 T←'          Sum of Squares' '  DOF' '           Mean Square  ' '   F ratio ' '   Alpha '
 U←' -----------------------' ' ----' ' -----------------------' '  ---------' '  -------'
 E←' =======================' ' ====' ' =======================' '  =========' '   '
 S←'    Source  ' '  ----------' ' constant ' ' due to reg.' ' error   ' ' ===========' ' total corr.' ' uncorrected'
 AnovaR←8 5⍴⊂'  '
 AnovaR[1;]←T
 AnovaR[2;]←U
 AnovaR[3;]←(3 RndDP NSC.sosbo),NSC.dofbo,(3 RndDP NSC.msbo),'  ' '  '
 AnovaR[4;]←(3 RndDP NSC.sosdr),NSC.dofb,(3 RndDP NSC.msdr),(NSC.fratio),(4 RndDP NSC.alpha)
 AnovaR[5;]←(3 RndDP NSC.sosar),NSC.dofe,(3 RndDP NSC.msar),'  ' '  '
 AnovaR[6;]←E
 AnovaR[7;]←(3 RndDP NSC.sostc),NSC.doftc,'  ' '  ' '  '
 AnovaR[8;]←(3 RndDP NSC.sost),NSC.doft,'  ' '  ' '  '
 AnovaR←S,AnovaR
     
 NSR.Result←Result
 NSR.AnovaR←AnovaR
∇

∇ NSS←dl RegressStats NSC;Divide;Rnd;list;N;NT;NB;BIG_E;WB_E;PC_E;BIGPC_E;WB_PCE;INDIV_Z;GIZ;WHICH_BIG;SORT;DURB;EQUAL_VAR;ERR_CORR;ERR_PATRN;NO_RUNS;NO_ABOVE;NO_BELOW;SIGN_RAT;SIGN_MU;SIGN_SIG;SIGN_Z;TRACE;COOK;WI_C;AP_Q;WI_Q;AP_FIRST;AP_SECOND;AP_STAT;WI_1;WI_2;WI_S;WHICH_INFL;R_TABLE;R_T;DIGITS_LOST;PERC_EXP;SW;Stats;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
 Divide←{(⍺)÷{⍵+0.000001000001×⍵=0}⍵}
 Rnd←{⍎30 ⍺⍕⍵}
 NSS←⎕NS''
     
 list←NSC.⎕NL ¯2
 ⎕SHADOW list
 ⍎(⍕list),'←NSC.(',(⍕list),')'
     
 N←≢y
 NT←20⌊N
 NB←≢b
 BIG_E←⌈/|errs
 WB_E←NT↑⍒|errs
 PC_E←100×errs Divide|yhat
 PC_E←3 RndD PC_E
 BIGPC_E←⌈/|PC_E
 WB_PCE←NT↑⍒|PC_E
 INDIV_Z←3 RndD(errs Divide serr)
 GIZ←⍒|INDIV_Z
 WHICH_BIG←(2.5<|INDIV_Z[GIZ])/(⍳N)[GIZ]
 :If NB>1 ⋄ SORT←errs[⍋x[;2]] ⋄ :EndIf
 :If NB≤1 ⋄ SORT←errs[⍋yhat] ⋄ :EndIf
 DURB←2 RndD(+/((1↓SORT)-(¯1↓SORT))*2)Divide+/SORT*2
 EQUAL_VAR←4 RndD((¯10000000000⌈10000000000⌊errs)*2)+.×(¯10000000000⌈10000000000⌊yhat)
 ERR_CORR←4 RndD(errs+.×yhat)
 ERR_PATRN←4 RndD(errs+.×yhat*2)
 NO_RUNS←4 RndD(1++/(¯1↓SORT<0)≠(1↓SORT<0))
 NO_ABOVE←+/errs>0
 NO_BELOW←+/errs<0
 SIGN_RAT←3 RndD(NO_ABOVE Divide{⍵+⍵=0}NO_BELOW)
 SIGN_MU←1+(2×NO_ABOVE×NO_BELOW)Divide(NO_ABOVE+NO_BELOW)
 SIGN_SIG←(2×NO_ABOVE×NO_BELOW)×((2×NO_ABOVE×NO_BELOW)-(NO_ABOVE+NO_BELOW))Divide(((NO_ABOVE+NO_BELOW)*2)×(NO_ABOVE+NO_BELOW-1))
 SIGN_Z←2 RndD(NO_RUNS+0.5-SIGN_MU)Divide SIGN_SIG*0.5
     
 TRACE←1 1⍉x+.×(inv)+.×⍉x
     
 COOK←100×((errs Divide serr×(|1E¯20+1-TRACE)*0.5)*2)×(TRACE Divide(1E¯20+1-TRACE))Divide NB
 WI_C←NT↑⍒|COOK
 AP_Q←10×(1E¯10⌈|(1 Divide(1E¯20+1-TRACE))×errs*2)Divide msar
 WI_Q←NT↑⍒|AP_Q
 AP_FIRST←1-(¯10000000000⌈10000000000⌊AP_Q)Divide(1E¯10⌈sosar)
 AP_SECOND←1-TRACE
 AP_STAT←AP_FIRST×AP_SECOND
 COOK←0 RndD(100×COOK)
 AP_Q←0 RndD AP_Q
 AP_FIRST←0 RndD(100×1-AP_FIRST)
 WI_1←NT↑⍒|AP_FIRST
 AP_SECOND←0 RndD(100×1-AP_SECOND)
 WI_2←NT↑⍒|AP_SECOND
 AP_STAT←0 RndD(100×1-AP_STAT)
 WI_S←NT↑⍒|AP_STAT
     
 WHICH_INFL←(1↑WB_E)(1↑WB_PCE)(1↑WI_C)(1↑WI_Q)(1↑WI_1)(1↑WI_2)(1↑WI_S)
     
     
 R_TABLE←(⍳N),⌽AP_STAT,AP_SECOND,AP_FIRST,AP_Q,COOK,INDIV_Z,PC_E,errs,yhat,y,x[;,2⌊NB]
     
 R_T←2 RndD¨R_TABLE
 R_T←(⍳12),[1](⍳12),[1]R_T
 R_T[1;]←' i ' '    x ' '    y ' ' y_hat' ' resid' ' % err' ' res_z' ' Cook ' 'AP q' 'AP 1' 'AP 2' ' AP '
 R_T[2;]←'---' '------' '------' '------' '------' '------' '------' '------' '----' '----' '----' '----'
     
 ERR_CORR←4 RndD(ERR_CORR×0.000001<|ERR_CORR)
 DIGITS_LOST←2 RndD dl
 PERC_EXP←2 RndD(100×mrcsq)
     
 SW←110
 Stats←27 SW⍴' '
 Stats[1;]←SW↑'equal var. stat.       ',⍕EQUAL_VAR
 Stats[2;]←SW↑'correl. error stat.    ',⍕ERR_CORR
 Stats[3;]←SW↑'patterned err. stat.   ',⍕ERR_PATRN
 Stats[4;]←SW↑'no. positive errors    ',⍕NO_ABOVE
 Stats[5;]←SW↑'no. negative errors    ',⍕NO_BELOW
 Stats[6;]←SW↑'error sign ratio       ',⍕SIGN_RAT
 Stats[7;]←SW↑'sign pattern z         ',⍕SIGN_Z
 Stats[8;]←SW↑'               influential residuals: most→less '
 Stats[9;]←SW↑'largest residuals      ',6 0⍕WB_E
 Stats[10;]←SW↑'largest % residuals    ',6 0⍕WB_PCE
 Stats[11;]←SW↑'   (outliers)  Q       ',6 0⍕WI_Q
 Stats[12;]←SW↑'   (outliers)  AP 1    ',6 0⍕WI_1
 Stats[13;]←SW↑'   (remote)    AP 2    ',6 0⍕WI_2
 Stats[14;]←SW↑'   (AP1×AP2)   AP      ',6 0⍕WI_S
 Stats[15;]←SW↑'   (coeffnts.) Cook    ',6 0⍕WI_C
 Stats[16;]←SW↑'biggest covariance     ',⍕max_cov
 Stats[17;]←SW↑' '
 Stats[18;]←SW↑'big err. : index       ',(⍕BIG_E),' : ',4 0⍕1↑WB_E
 Stats[19;]←SW↑'big % err. : index     ',(⍕BIGPC_E),' : ',4 0⍕1↑WB_PCE
 Stats[20;]←SW↑'errors having z>2.5    ',6 0⍕WHICH_BIG
 Stats[21;]←SW↑'Durbin Watson stat.    ',⍕DURB
 Stats[22;]←SW↑'digits lost            ',⍕DIGITS_LOST
 Stats[23;]←SW↑'multpl. reg. coeff.    ',⍕mrc
 Stats[24;]←SW↑'% var. explained       ',⍕PERC_EXP
 Stats[25;]←SW↑'std. err. (sigma)      ',⍕serr
 Stats[26;]←SW↑'total variance in y    ',⍕sostc÷N
 Stats[27;]←SW↑'unexplained var.       ',⍕sosar÷N
     
 NSS.Stats←Stats
 NSS.ResidTable←R_T
∇

∇ clean←{what}RemoveExcessBlanks vector;Rem;⎕ML;⎕IO
     
          ⍝∇  remove extraneous blanks/w:  i    am => i am
          ⍝∇        'MISISIPPI' ← 'S' RemoveExcessBlanks 'MISSISSIPPI'
          ⍝∇          3 0 4 0 5 ← RemoveExcessBlanks 0 0 3 0 0 0 0 4 0 0 0 5 0 0 0 0
          ⍝∇    'this is clean' ← RemoveExcessBlanks '   this  is clean    '
     
 ⎕ML←⎕IO←1
 :If 0=⎕NC'what' ⋄ what←⊃1↑0⍴,vector ⋄ :EndIf ⍝  either ' '  or 0
     
 Rem←{1↓⍺{{⍵∨1⌽⍵}⍵≠⍺}⍺,⍵}
 clean←(what Rem vector)/vector
          ⍝ pull of all leading what's
 clean←(~1↓∧\(what,clean)∊what)/clean
     
 :Return
∇

∇ z←d RndD v;⎕IO;f;⎕ML
     
          ⍝∇ round to a number of decimal places:  12.235  ←  3 RndD 12.2345678
     
 ⎕ML←⎕IO←1
 :If (v≡⍬) ⋄ z←v ⋄ :Return ⋄ :EndIf
 :If 2≤⍴⍴v ⋄ z←(⍴v)⍴d RndD,v ⋄ :Return ⋄ :EndIf
     
 f←10*d
 z←(⌊0.5+f×v)÷f
     
 :Return
∇

∇ z←n RndDP v;⎕ML;⎕IO
     
          ⍝∇  round to a given no. of decimal places by formatting:  23.35  ←  2 RndDP  23.34567
 z←n RndD v ⍝ Not a good method for large numbers -- just default to RndD
 →0
     
 ⎕ML←⎕IO←1
 :If 2≤⍴⍴v ⋄ z←(⍴v)⍴n RndDP,v ⋄ :Return ⋄ :EndIf
     
 :Trap 0
     z←⍎30 n⍕v
 :Else
     z←⍬
 :EndTrap
∇

∇ z←n RndF v;b;d;⎕ML;⎕IO
     
          ⍝∇  round the vector to match the largest value's decimal to n decimal places
     
 ⎕ML←⎕IO←1
 b←⌈/|,v
 d←n-⌈10⍟(b+b=0)
 z←d RndD v
     
 :Return
∇

∇ z←p RndP v;⎕ML;⎕IO
     
          ⍝∇  round to a given decimal places pattern:   23.35  ←  .01 RndP  23.34567
     
 ⎕ML←⎕IO←1
 z←(×v)×p×⌊0.5+|v÷p
∇

∇ r←n RndS v;k;⎕ML;⎕IO
     
          ⍝∇ round to n significant digits:  1235000  ← 4 RndS 1234567.89
     
 ⎕ML←⎕IO←1
 k←10*1-n-⌊10⍟|v+v=0
 r←(v≠0)×k×⌊0.5+v÷k
     
 :Return
∇

∇ z←n Rndp_DUP z;m;⎕ML;⎕IO
     
          ⍝∇  round to a number of decimal places:
 ⎕ML←⎕IO←1
 m←10*n
 z←(⌊0.5+m×z)÷m
∇

∇ r←deg RotateDegrees pointmat;rmat;rad;⎕ML;⎕IO
     
          ⍝∇   Rotate either a vetor or a 2 column matrix of points an angle in deg(rees)
          ⍝∇     If deg is positive the rotation is clockwise
 ⎕ML←⎕IO←1
 rad←360÷⍨deg×○2
 rmat←2 2⍴1 ¯1 1 1×2 1 1 2○rad
 r←pointmat+.×rmat
     
 :Return
∇

 RotateRadians←{
      ⍝ Rotate either a vector or a 2 column matrix of points
      ⍝ If rad is positive the rotation is clockwise
     rad←⍺ ⋄ pointmat←⍵
     rmat←2 2⍴1 ¯1 1 1×2 1 1 2○rad
     pointmat+.×rmat
 }

∇ t←{w}Rtb v;n;⎕ML;⎕IO
     
          ⍝∇ t ← {w} Rtb v -- remove trailing zeros/blanks/w (if present)
          ⍝∇         ────     0 0 3 0 0 4 0 0 0 5 ← ∆RTB 0 0 3 0 0 4 0 0 5 0 0 0
     
 ⎕ML←⎕IO←1
     
 :If (0=⎕NC'w') ⋄ w←1↑0⍴v ⋄ :EndIf
 w←⊃w
 :If 1<⍴⍴v ⋄ t←↑w Rtb¨↓v ⋄ :Return ⋄ :EndIf
 t←(-+/∧\⌽w≡¨v)↓v
     
 :Return
∇

∇ ys←SampleOrthoRegressedData(y x xs order);nsf;fbc;fp;fx;xM;xm;xhw;xc;yhat;⎕ML;⎕IO
     
          ⍝∇   Given:    x y data pairs and an x-vector where you would like to get
          ⍝∇             values from the fitted xy curve  and an order to do the
          ⍝∇             xy Forsythe regression.
          ⍝∇   Deliver:  y values at xs
     
          ⍝ fit the data
 ⎕ML←⎕IO←1
     
 nsf←RegressForsythe(y x order)
 fbc←ForsythePolynomialCoeficients nsf
     
          ⍝  Put xs on the same range basis as the x vector
 fp←nsf.ForsythePolynomialsOnX
 fx←fp[;2]
 xM←⌈/fx ⋄ xm←⌊/fx
 xhw←0.5×xM-xm     ⍝ range
 xc←0.5×xM+xm     ⍝ center
 yhat←nsf.Yhat
           ⍝  Interpolate xs into x,[1.5]yhat
 ys←LagrangeInterpolation x yhat xs 6
     
 :Return
∇

∇ ts←Seconds
 ts←0.001×24 60 60 1000⊥¯4↑⎕TS
 :Return
∇

∇ {(x dl ai a check CN)}←y SolveSLAE A;⎕ML;⎕IO;nr;inr;B;ibc;pbig;psmall;i;km;pivot;kr;w;j;r;big
     
          ⍝∇   Solve Simultaneous-Linear-Algebraic-Equations by Gauss
          ⍝∇   elimination, watching the pivots to monitor singularity.
          ⍝∇   xty can have more than one column (more than one right-
          ⍝∇   hand side.
          ⍝∇   xtx,xty  in regression analysis is equivalent to solving
          ⍝∇   Ax=y   where the x's are the solution.
     
 ⎕ML←⎕IO←1
     
          ⍝ try scaling A and y
 big←⌈/|,A
          ⍝ A÷←big
          ⍝ y÷←big
     
 x←dl←ai←a←check←CN←⍬ 17 ⍬ ⍬ ⍬ ⍬    ⍝ incase of perfect singularity
 nr←≢y
 inr←⍳nr
 B←A,y,(nr nr⍴1,nr⍴0),nr⍴1          ⍝  an augmented matrix that will
                                              ⍝  collect the inverse of A
 B←B÷⍉(⌽⍴B)⍴⌈/|A                    ⍝  scale the entire matrix  (the identity matrix part as well?)
 ibc←⍳2⊃⍴B
 pbig←1
 psmall←1⌈⊃B
     
 :For i :In ⍳nr                     ⍝  process each row
     km←⊃(i-1)+1↑⍒|(i-1)↓B[;i]     ⍝  index of biggest value on or below the pivot
     B[i km;]←B[km i;]             ⍝  swap biggest into the pivot row  , i
     pivot←B[i;i]
     :If pivot=0 ⋄ :Return ⋄ :EndIf
     B[i;]÷←pivot                  ⍝  normalize the pivot row
     pbig⌈←|pivot                  ⍝  keep track of big and small pivots
     psmall⌊←|pivot
          ⍝      'pivoting'Watcher i pbig psmall
     :If i=nr ⋄ :Leave ⋄ :EndIf    ⍝  we are at the bottom
          ⍝  for all the rows below the pivot, subtract off the pivot row
     kr←i↓inr
     w←B[kr;i]                     ⍝  the weights for each row
     B[kr;i]←0                     ⍝  by definition
     B[kr;i↓ibc]-←↑w×⊂B[i;i↓ibc]   ⍝  subtract the pivot row
 :EndFor
 dl←2 RndDP 10⍟pbig÷{⍵+⍵=0}psmall
     
          ⍝   Back out the soln.
 :For j :In 1↓⌽⍳nr
     x←B[j+1;nr+1]
     kr←⍳j
     w←B[kr;j+1]
     B[kr;]-←↑w×⊂B[j+1;]
 :EndFor
 x←B[;nr+1]
 a←B[⍳nr;⍳nr]
 ai←B[⍳nr;nr+1+⍳nr]
     
 check←(A)+.×ai
 CN←(MatNormFrob A)×(MatNormFrob ai)   ⍝ condition number
∇

∇ stdata←Standardize data;sdata;n;a;s;⎕ML;⎕IO
     
          ⍝∇   Give the data a mean of zero and a sdt.dev. of 1
          ⍝∇   data is either a vector or a vector of vectors
          ⍝∇   if data is a matrix, assume columns are variables, split it.
          ⍝∇   and return it as a matrix
     
 ⎕ML←⎕IO←1
 sdata←data
 :If 2=⍴⍴data
     sdata←↓[1]sdata
 :EndIf
     
 :If 1=≡sdata
     n←≢sdata
     a←(+/data)÷n
     s←sdata-a
     stdata←s÷((+/s*2)÷n-1)*0.5
     :Return
 :Else
     stdata←Standardize¨sdata
 :EndIf
     
     
 :If 2=⍴⍴data
     stdata←↑[0.5]stdata
 :EndIf
∇

∇ p←yor StepPartCorr xio;xi;xo;yo;yr;n;pr;fe;m;res;ans;b;f;f_r;uv;br;dw;dl;i;⎕ML;⎕IO
     
          ⍝∇    not sure why
     
 ⎕ML←⎕IO←1
 xi xo←xio
 yo yr←yor
 n←⊃⌽⍴xo
 p←⍬
 :If n=0 ⋄ :Return ⋄ :EndIf
 pr←fe←n⍴0
 m←2⊃⍴xi
     
 :For i :In ⍳n
     res←xo[;i]
     :If m≠0
         ans←res StepRegressionSAE xi
         b f f_r uv br dw dl res←ans
     :EndIf
     pr[i]←Corr yr res
     ans←yo StepRegressionSAE xi,xo[;,i]
     b f f_r uv br dw dl res←ans
     fe[i]←¯1↑f_r
 :EndFor
     
 p←pr fe
∇

∇ out←y StepRegressionSAE x;⎕ML;⎕IO;n;xbar;ybar;nb;one;yesbo;dfbo;dfb;dft;dftc;dfe;I;Ib;xtx;xty;dl;ai;a;check;xa;coeffs;b;btxty;y11y;yty;yhat;errs;sosbo;sosdr;sosar;sostc;sost;msbo;msdr;msar;sesq;serr;f_ratio;t_stat;mrcsq;mrc;seob;trc;denom;req;covr;bigcv;max_cov;st_t;f_remove;big_e;sort;durb;dig_l;out
     
          ⍝∇  solve the current set of equations and get its statistics
     
 ⎕ML←⎕IO←1
     
 n←≢y
 xbar←Average¨↓[1]x
 ybar←Average y
 nb←≢xbar
 one←n⍴1
 yesbo←one≡x[;1]
 dfbo←yesbo           ⍝ degress of freedom for constant
 dfb←nb-yesbo         ⍝ degress of freedom for the x's
 dft←n                ⍝ total dof
 dftc←n-yesbo         ⍝ dof other than constant
 dfe←dft-nb           ⍝ error dof
     
 I←n n⍴0 ⋄ (1 1⍉I)←1  ⍝ identity matrix   n n⍴1,n⍴0
 Ib←nb nb⍴0 ⋄ (1 1⍉Ib)←1
     
 xtx←(⍉x)+.×x
 xty←(⍉x)+.×y
     
 b dl ai a check CN←xty SolveSLAE xtx   ⍝ b ≡≡ anwers    dl ≡≡ digits_lost
                                                                ⍝ ai ≡≡ inverse  a ≡≡ what is left in the original A matrix ≡≡? Identity
                                                                ⍝ check ≡≡ ?     CN ≡≡ condition number
 btxty←b+.×xty
 y11y←((+/y)*2)Divide≢y
 yty←y+.×y
     
 yhat←x+.×b
 errs←y-yhat
     
 sosbo←y11y
 sosdr←+/(yhat-ybar)*2
 sosar←+/errs*2
 sostc←+/(y-ybar)*2
 sost←yty
     
 msbo←sosbo
 msdr←sosdr Divide dfb
 msar←sosar Divide dfe
 sesq←msar
 serr←sesq*0.5
 f_ratio←2 RndDP 999999⌊(msdr Divide msar)
     
 t_stat←serr×(|ai)*0.5
 mrcsq←sosdr Divide sostc
 mrc←4 RndDP(mrcsq*0.5)
 seob←1 1⍉t_stat
     
     
 trc←1000000000000000⌊¯1000000000000000⌈1 1⍉ai
 denom←trc∘.×trc
 denom←(denom=0)+(denom×(denom≠0))
 req←ai Divide(|denom)*0.5
 Ib←(⍴req)↑Ib
 covr←4 RndDP(req-Ib)
 bigcv←⌈/|covr
 max_cov←⌈/|bigcv
 st_t←2 RndDP(b Divide seob)
     
 f_remove←99999⌊st_t*2
     
 big_e←⊃⌈/|errs
     
 sort←errs[⍋y]
 durb←2 RndDP(+/((¯1↓sort)-(1↓sort))*2)Divide+/sort*2
     
 dig_l←2 RndDP dl
     
 out←(b)(f_ratio)(f_remove)(sosar÷n)(big_e)(durb)(dig_l)(errs)
     
 :Return
∇

∇ v←SumByTwos v;n;⎕ML;⎕IO
     
          ⍝∇  straight summation can be subject to roundoff error, particularly
          ⍝∇  if the items are monatonically decreasing.  Randomize the data and
          ⍝∇  then add the front half to the back half; repeatedly.
     
 ⎕ML←1 ⋄ ⎕IO←1
 :If 0=⎕NC'rand' ⋄ n←≢v ⋄ v←v[n?n] ⋄ rand←1 ⋄ :EndIf
 :If 1=≢v ⋄ ⎕EX'rand' ⋄ :Return ⋄ :EndIf
 :If 2|≢v ⋄ v,←0 ⋄ :EndIf
 n←0.5×≢v
 v←(n↑v)+(n↓v)
 v←⊃SumByTwos v
∇

∇ (a d e z)←v SymetricEigen a;n;d;e;z;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
 n←≢a
 a d e←Trired v a n
 a d e z←ImplicitQL v a d e n
     
 z←z⍪a
 z←z[;⍒z[1;]]
∇

 To←{(×⍺-⍵)+⍺+(×⍵-⍺)×⍳1+|⍵-⍺}

∇ (a d e)←Trired(v a n);i;l;f;g;h;j;hh;⎕ML;⎕IO
     
          ⍝∇    Triangular reduction
          ⍝∇    plinked from GLIB:EIGPAK
          ⍝∇    FROM NUMERISCHE MATHEMATIK 11, 181-195 (1968)
     
          ⍝ Watcher_right
 ⎕ML←⎕IO←1
     
 d←e←n⍴0
 l i j←¯1
 :For i :In (⌽1↓⍳n)
     l←i-2
     h←(g←+/a[i;⍳l]*2)+(f←a[i;i-1])*2
          ⍝      'lijhgf'Watcher l i j h g f
     :If g<1E¯38
         e[i]←f
         d[i]←h←0
          ⍝           'lijhgf'Watcher l i j h g f
          ⍝           'eee'Watcher e
          ⍝           'ddd'Watcher d
          ⍝           'ouch'l i h g f
     :Else
     
         l+←1
         h←h-f×g←e[i]←(h*0.5)×1-2×f≥0
         a[i;i-1]←f-g
         f←0
          ⍝           'lijhgf'Watcher l i j h g f
          ⍝           'eee'Watcher e
          ⍝           'ddd'Watcher d
         :For j :In ⍳l
             a[j;i]←a[i;j]÷h
             e[j]←(g←(a[j;⍳j]+.×a[i;⍳j])+(a[j+⍳l-j;j]+.×a[i;j+⍳l-j]))÷h
             f←f+g×a[j;i]
          ⍝                'lijhgf'Watcher l i j h g f
          ⍝                'eee'Watcher e
          ⍝                'ddd'Watcher d
         :EndFor
         hh←f÷h+h
     
         :For j :In ⍳l
             g←e[j]←e[j]-hh×f←a[i;j]
             a[j;⍳j]←a[j;⍳j]-(f×e[⍳j])+g×a[i;⍳j]
          ⍝                'lihgf'Watcher l i h g f
          ⍝                'eee'Watcher e
          ⍝                'ddd'Watcher d
         :EndFor
         d[i]←h
     :EndIf
          ⍝      'lijhgf'Watcher l i j h g f
          ⍝      'eee'Watcher e
          ⍝      'ddd'Watcher d
     
 :EndFor
     
 :If 1≠v
     d←1 1⍉a
     :Return
 :Else
     :For i :In ⍳n
         l←i-1
         :If 0≠d[i]
             a[⍳l;⍳l]←a[⍳l;⍳l]-a[⍳l;i]∘.×a[i;⍳l]+.×a[⍳l;⍳l]
         :EndIf
         d[i]←a[i;i]
         a[i;i]←1
         a[i;⍳l]←a[⍳l;i]←0
          ⍝           'lihgf'Watcher l i h g f
          ⍝           'eee'Watcher e
          ⍝           'ddd'Watcher d
     :EndFor
 :EndIf
     
          ⍝ Watcher_middle
          ⍝ 'zlihgf'Watcher l i h g f
          ⍝ 'zeee'Watcher e
          ⍝ 'zddd'Watcher d
∇

∇ UnWatcher
     
          ⍝∇  ∆UNWATCHER -- remove all trace objects made by ∆WATCHER
          ⍝∇  ──────────
     
 ⎕EX'X∆WATCHER'
∇

∇ {f}←n Watcher v;e;po;p;∆p;s;ov;no;k;⎕ML;⎕IO
          ⍝ f←1
          ⍝ :Return
     
          ⍝∇  form_name ← name_tag ∆WATCHER value -- put up a form with the current value
          ⍝∇                       ────────
          ⍝∇    fn←'index' ∆WATCHER i     ⍝  inside of loop
 ⎕ML←⎕IO←1
     
 :If 0=⎕NC'X∆WATCHER' ⋄ 'X∆WATCHER'⎕NS'' ⋄ :EndIf
 f←'X∆WATCHER.f',n
 :If 0=⎕NC f
          ⍝   build the form
          ⍝      po←p←90.3 60 ⋄ ∆p←¯8.8 0 ⋄ s←4.7 38.75 ⋄ ov←0 ¯25 ⋄ no←14
     po←p←3.3 71 ⋄ ∆p←8.8 0 ⋄ s←4.7 28.75 ⋄ ov←0 ¯25 ⋄ no←14
     po-←∆p
     k←1+⊃⍴X∆WATCHER.⎕NL 9
     p←po+ov×⌊(k-1)÷no
     p+←∆p×1+no|k-1
     f ⎕WC'Form'n('Posn'p)('Size's)('BCol' 255 255 255)('Event' 'Close' 0)('Coord' 'User')
             ⍝   f ⎕WG'XRange' 'YRange'
     e←f,'.e'
     e ⎕WC'Edit'('Posn' 0 0)('Size' 100 100)('Style' 'Multi')
 :EndIf
     
 (f,'.e')⎕WS'Text'(⍕v)
 ⎕DL 0.000001                   ⍝ allows WINDOWS to display
∇

∇ {f}←n Watcher_base v;e;po;p;∆p;s;ov;no;k;⎕ML;⎕IO
          ⍝ f←1
          ⍝ :Return
     
          ⍝∇  form_name ← name_tag ∆WATCHER value -- put up a form with the current value
          ⍝∇                       ────────
          ⍝∇    fn←'index' ∆WATCHER i     ⍝  inside of loop
 ⎕ML←⎕IO←1
     
 :If 0=⎕NC'X∆WATCHER' ⋄ 'X∆WATCHER'⎕NS'' ⋄ :EndIf
 f←'X∆WATCHER.f',n
 :If 0=⎕NC f
          ⍝   build the form
          ⍝      po←p←90.3 60 ⋄ ∆p←¯8.8 0 ⋄ s←4.7 38.75 ⋄ ov←0 ¯25 ⋄ no←14
     po←p←down over ⋄ ∆p←8.8 0 ⋄ s←4.7 28.75 ⋄ ov←0 ¯25 ⋄ no←14
     po-←∆p
     k←1+⊃⍴X∆WATCHER.⎕NL 9
     p←po+ov×⌊(k-1)÷no
     p+←∆p×1+no|k-1
     f ⎕WC'Form'n('Posn'p)('Size's)('BCol' 255 255 255)('Event' 'Close' 0)('Coord' 'User')
             ⍝   f ⎕WG'XRange' 'YRange'
     e←f,'.e'
     e ⎕WC'Edit'('Posn' 0 0)('Size' 100 100)('Style' 'Multi')
 :EndIf
     
 (f,'.e')⎕WS'Text'(⍕v)
 ⎕DL 0.000001                   ⍝ allows WINDOWS to display
∇

∇ Watcher_bottom;w;⎕ML;⎕IO
 ⎕ML←⎕IO←1
     
 w←⎕VR'Watcher_base'
 w←'down over' '94 ¯5'∆REPLACE_STRING w
 w←'5.8 0' '0 17'∆REPLACE_STRING w
 w←'28.75' '16'∆REPLACE_STRING w
 w←'Watcher_base' 'Watcher '∆REPLACE_STRING w
 ⎕FX w
∇

∇ Watcher_bottom_2fe;w;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
 w←⎕VR'Watcher_base'
 w←'down over' '94 68'∆REPLACE_STRING w
 w←'5.8 0' '0 11'∆REPLACE_STRING w
 w←'28.75' '10'∆REPLACE_STRING w
 w←'Watcher_base' 'Watcher'∆REPLACE_STRING w
 ⎕FX w
 :Return
∇

∇ Watcher_left;w;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
 w←⎕VR'Watcher'
 w←'down left' '3.3 .2'∆REPLACE_STRING w
 w←'Watcher_base' 'Watcher '∆REPLACE_STRING w
 ⎕FX w
 :Return
∇

∇ Watcher_middle;w;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
 w←⎕VR'Watcher_base'
 w←'down over' '3.3 33'∆REPLACE_STRING w
 w←'Watcher_base' 'Watcher '∆REPLACE_STRING w
 ⎕FX w
 :Return
∇

∇ Watcher_right;w;⎕ML;⎕IO
     
 ⎕ML←⎕IO←1
 w←⎕VR'Watcher_base'
 w←'down over' '3.3 71'∆REPLACE_STRING w
 w←'Watcher_base' 'Watcher '∆REPLACE_STRING w
 ⎕FX w
 :Return
∇

∇ fixed←old_new ∆REPLACE_STRING string;old;new;j;⎕ML;⎕IO
     
          ⍝∇ fixed←'old' 'new' ∆REPLACE_STRING cvec -- replace occurances of 'old' in cvec
          ⍝∇                   ───────────────         with new
          ⍝∇
          ⍝∇    cvec must be a character vector
          ⍝∇    old and new must be scalars or vectors of characters
     
 ⎕ML←⎕IO←1
     
 old new←,¨2↑old_new
     
 j←old⍷string
 fixed←(⍴new)↓⊃,/((⍴string)⍴⊂new),¨(⍴old)↓¨string←(((⍴old)↑1),j)⊂old,string
∇

∇ z←(FunX HalfStep)ABN;a;b;n;ya;yb;yz;i;⎕ML;⎕IO

⍝∇ trial and error by half_stepping:  if you start correctly bracketed
⍝∇ it will always converge
⍝∇    argument:  two values of X that with have a funtion result of
⍝∇               opposite sign and the max number of steps (20 will
⍝∇               reduce the uncertainty to one-millionth of the A-B
⍝∇               gap.  default to 53 == 16 digits).

 ⎕ML←1 ⋄ ⎕IO←1
 a b n←3↑ABN,53

 z←a
 ya←FunX z
 :If ya=0 ⋄ :Return ⋄ :EndIf
 z←b
 yb←FunX z
 :If yb=0 ⋄ :Return ⋄ :EndIf

⍝  Check for bracketing
 z←1
 :If 0<ya×yb ⋄ :Return ⋄ :EndIf

 ⍝  start halving
 :For i :In ⍳n
     z←0.5×a+b
     yz←FunX z
⍝      'half'#.Stats.Dutils.Watcher i':'ya yz yb':'a z b
     :If yz=0 ⋄ :Return ⋄ :EndIf  ⍝  may as well quit with an exact root
     :If 0<yz×ya    ⍝  yz is on the same side as ya
         a ya←z yz
     :Else
         b yb←z yz
     :EndIf
 :EndFor

 ⍝  accept z
∇

∇ z←(FunX HalfStepI)ABN;a;b;n;ya;yb;yz;i;⎕ML;⎕IO

⍝∇ trial and error by half_stepping:  if you start correctly bracketed
⍝∇ it will always converge
⍝∇    argument:  two values of X that with have a funtion result of
⍝∇               opposite sign and the max number of steps (20 will
⍝∇               reduce the uncertainty to one-millionth of the A-B
⍝∇               gap.  default to 53 == 16 digits).

 ⎕ML←1 ⋄ ⎕IO←1
 a b n←3↑ABN,53

 z←a
 ya←FunX z
 :If ya=0 ⋄ :Return ⋄ :EndIf
 z←b
 yb←FunX z
 :If yb=0 ⋄ :Return ⋄ :EndIf

⍝  Check for bracketing
 z←⍬
 :If 0<ya×yb ⋄ :Return ⋄ :EndIf

 ⍝  start halving
 :For i :In ⍳n
     z←⌈0.5×a+b
     yz←FunX z
     :If yz=0 ⋄ :Return ⋄ :EndIf  ⍝  may as well quit with an exact root
     :If 0<yz×ya    ⍝  yz is on the same side as ya
         a ya←z yz
     :Else
         b yb←z yz
     :EndIf
     :If 1=|a-b ⋄ :Leave ⋄ :EndIf
 :EndFor


 ⍝  accept the better of ya yb
 z←a
 :If </|yb ya ⋄ z←b ⋄ :EndIf
∇

∇ Z←(F Romberg_Trap)(low_lim high_lim);Improve;x;sum;∆x;nx;xn;A;B;C;D;n;⎕ML;⎕IO

⍝∇   Apply Romberg technique to integration based on trapazoidal quadrature:
⍝∇      if an integrator has an order n with a step size of h, and two areas
⍝∇      are computed at 2h and h (Ab As) then an improved value can be had:
⍝∇      Ai ← (2*n)As - Ab ÷ (2*n - 1)

⍝  the trapazoidal integration is A1 ← .5 × (B-A)× +/F¨ A B  for one step
⍝  but at more steps it is   sum←+/.5 1 1 1 ... 1 1 1 .5 × F¨x  and A←∆x×sum
⍝  at the next interval halving ∆x←.5×∆x and  sum←sum+F¨x at the mid-points
⍝  therefore: keep track of x, sum, ∆x
⍝  experiments indicate that C is far enough

 ⎕ML←1 ⋄ ⎕IO←1
 Improve←{((d×2⊃⍵)-⊃⍵)÷¯1+d←2*⍺}
 x←low_lim high_lim
 sum←0.5×+/F¨x
 ∆x←high_lim-low_lim
 n←1
 A←∆x×sum
 B←C←D←⍬

 :Repeat
     n×←2
     ∆x←0.5×∆x
     nx←¯1+≢x
     xn←low_lim+(2×∆x×⍳nx)-∆x
     sum+←SumByTwos F¨xn
     x←low_lim+∆x×0,⍳2×nx
     A,←∆x×sum
     B,←2 Improve ¯2↑A
     :If 2≤≢B ⋄ C,←4 Improve ¯2↑B ⋄ :EndIf
⍝      :If 2≤≢C ⋄ D,←8 Improve ¯2↑C ⋄ :EndIf
 :Until n>1000000
 :OrIf (=/¯2↑B)∧(2≤≢B)
 :OrIf (=/¯2↑C)∧(2≤≢C)
 Z←⊃⌽C
∇

∇ AREA←(F ∆GQ)CH;C;H;⎕ML;⎕IO

⍝∇ Gauss Quadrature
⍝∇ area ← f ∆GQ c h -- do one panel integration using GLOBALS: QZ QW
⍝∇          ───        a panel is defined by its center and halfwidth
 ⎕ML←⎕IO←1
 C H←CH
 :If 0=⎕NC'QW' ⋄ DEFINE_QW ⋄ DEFINE_QZ ⋄ :EndIf
 AREA←H×+/QW×F¨C+QZ×H
∇

∇ AREA←(FQ ∆QUAD)ABN;A;B;N;C;H;⎕ML;⎕IO

⍝∇ area ←((f qmethod) ∆QUAD) a b no_of_panels -- do a whole integral of f
⍝∇                     ─────                     from a to b using the
⍝∇                                               supplied quadrature algo.

 ⎕ML←⎕IO←1
 A B N←ABN
 H←(B-A)÷N×2
 C←(A-H)+2×H×⍳N

 AREA←+/FQ¨C,¨H
∇

:Namespace quadVars
(⎕IO ⎕ML ⎕WX)←1 0 3

:EndNamespace 
:EndNamespace 
:Namespace quadVars
(⎕IO ⎕ML ⎕WX)←1 1 3

:EndNamespace 
:EndNamespace 
