﻿:Namespace NonParametric
⍝ === VARIABLES ===

A14←29 7⍴({⎕io←0⋄0 0 0.8 0.85 0.9 0.95 0.99 4 0 0.303 0.32 0.344 0.374 0.414 5 0 0.29 0.302 0.319 0.344 0.398 6 0 0.268 0.283 0.295 0.321 0.371 7 0 0.252 0.264 0.28 0.304 0.353 8 0 0.239 0.251 0.266 0.29 0.333 9 0 0.227 0.239 0.253 0.275 0.319 10 0 0.217 0.228 0.241 0.262 0.303 11 0 0.209 0.219 0.232 0.252 0.291 12 0 0.201 0.21 0.223 0.243 0.281 13 0 0.193 0.203 0.215 0.233 0.27 14 0 0.187 0.196 0.209 0.227 0.264 15 0 0.181 0.19 0.202 0.219 0.256 16 0 0.176 0.184 0.195 0.212 0.248 17 0 0.17 0.179 0.19 0.207 0.241 18 0 0.166 0.174 0.185 0.201 0.234 19 0 0.162 0.171 0.181 0.197 0.23 20 0 0.159 0.167 0.177 0.192 0.223 21 0 0.155 0.163 0.173 0.188 0.219 22 0 0.152 0.16 0.17 0.185 0.214 23 0 0.149 0.156 0.165 0.181 0.21 24 0 0.145 0.153 0.162 0.177 0.205 25 0 0.144 0.151 0.159 0.173 0.202 26 0 0.141 0.147 0.156 0.17 0.198 27 0 0.138 0.145 0.153 0.166 0.193 28 0 0.136 0.142 0.151 0.165 0.191 29 0 0.134 0.14 0.149 0.162 0.188 30 0 0.132 0.138 0.146 0.159 0.183 31 0 0.741 0.775 0.819 0.895 1.035⊣⎕fr←⍵}1287)

A15←29 13⍴({⎕io←0⋄0 0 0.05 0.1 0.2 0.3 0.5 0.7 0.8 0.9 0.95 0.99 0.995 2 0 0.3127 0.32 0.3337 0.3617 0.4337 0.5034 0.5507 0.5934 0.6133 0.6284 0.6317 3 0 0.2299 0.2544 0.2899 0.3166 0.3645 0.4122 0.4508 0.5111 0.5508 0.6003 0.6296 4 0 0.2072 0.2281 0.2545 0.2766 0.3163 0.3685 0.4007 0.4442 0.4844 0.5574 0.6215 5 0 0.1884 0.2052 0.229 0.2483 0.2877 0.3317 0.3603 0.4045 0.442 0.5128 0.5814 6 0 0.1726 0.1882 0.2102 0.229 0.2645 0.3045 0.332 0.3732 0.4085 0.4748 0.5497 7 0 0.1604 0.175 0.1961 0.2136 0.2458 0.2838 0.3098 0.3481 0.3811 0.4459 0.5191 8 0 0.1506 0.1646 0.1845 0.2006 0.2309 0.2671 0.2914 0.3274 0.359 0.4208 0.4913 9 0 0.1426 0.1561 0.1746 0.1897 0.2186 0.2529 0.2758 0.3201 0.3404 0.3995 0.4679 10 0 0.1359 0.1486 0.1661 0.1805 0.2082 0.2407 0.2626 0.2955 0.3244 0.3813 0.4473 12 0 0.1249 0.1364 0.1524 0.1657 0.1912 0.2209 0.2411 0.2714 0.2981 0.3511 0.4132 14 0 0.1162 0.1268 0.1418 0.1542 0.1778 0.2054 0.2242 0.2525 0.2774 0.3272 0.3858 16 0 0.1091 0.1191 0.1332 0.1448 0.1669 0.1929 0.2105 0.2371 0.2606 0.3076 0.3632 18 0 0.1032 0.1127 0.126 0.1369 0.1578 0.1824 0.199 0.2242 0.2465 0.2911 0.3441 20 0 0.0982 0.1073 0.1199 0.1303 0.1501 0.1735 0.1893 0.2132 0.2345 0.2271 0.3277 22 0 0.0939 0.1025 0.1146 0.1245 0.1434 0.1657 0.1809 0.2038 0.2241 0.2649 0.3135 24 0 0.0901 0.0984 0.1099 0.1195 0.1376 0.159 0.1735 0.1954 0.215 0.2542 0.301 26 0 0.0868 0.0973 0.1058 0.115 0.1324 0.153 0.167 0.1881 0.2069 0.2447 0.2899 28 0 0.0838 0.0947 0.1021 0.111 0.1278 0.1477 0.1611 0.1815 0.1997 0.2362 0.2799 30 0 0.0811 0.0914 0.0988 0.1074 0.1236 0.1428 0.1559 0.1756 0.1932 0.2286 0.2709 35 0 0.0754 0.0885 0.0918 0.0997 0.1148 0.1326 0.1447 0.163 0.1793 0.2123 0.2517 40 0 0.0707 0.0822 0.0861 0.0935 0.1077 0.1243 0.1356 0.1528 0.1681 0.199 0.2361 45 0 0.0668 0.0771 0.0814 0.0884 0.1017 0.1174 0.1281 0.1443 0.1588 0.188 0.2231 50 0 0.0636 0.0729 0.0774 0.084 0.0966 0.1116 0.1217 0.1371 0.1509 0.1787 0.2121 60 0 0.0582 0.0635 0.0708 0.0769 0.0885 0.1021 0.1114 0.1255 0.1381 0.1635 0.1943 70 0 0.0541 0.0589 0.0658 0.0714 0.0821 0.0946 0.1033 0.1164 0.1281 0.1517 0.18 80 0 0.0507 0.0553 0.0616 0.0669 0.0769 0.0887 0.0968 0.109 0.12 0.1421 0.17 90 0 0.0479 0.0522 0.0582 0.0632 0.0726 0.0838 0.0914 0.1029 0.1132 0.1341 0.16 100 0 0.0455 0.04959 0.0553 0.06 0.06898 0.07957 0.08678 0.09773 0.10753 0.12743 0.15⊣⎕fr←⍵}1287)

A19←40 6⍴({⎕io←0⋄0 0.9 0.95 0.975 0.99 0.995 3 2 2,(3/3),4 3 3,(3/4),5 3 3,(3/4),6 3 4 4 5 5 7 4 4,(3/5),8 4 4 5 5 6 9 4 5 5 6 6 10 4 5 6 6 7 11 5 5 6 7 7 12 5 5 6 7 7 13 5 6 6 7 8 14 5 6 7 7 8 15 5 6 7 8 8 16 6 6 7 8 9 17 6 7 7 8 9 18 6 7 8 9 9 19 6 7 8 9 9 20,(6+⍳5),21,(6+⍳5),22 7 8 8 10 10 23 7 8 9 10 10 24,(7+⍳5),25,(7+⍳5),26,(7+⍳5),27 7 8 9 11 11 28,(8+⍳5),29,(8+⍳5),30,(8+⍳5),31,(8+⍳5),32 8 9 10 12 12 33 8 9 11 12 13 34 8,(10+⍳4),35 8,(10+⍳4),36,(9+⍳5),37 9 10 11 13 13 38 9 10 11 13 14 39 9 10 11 13 14 40 9 10 12 13 14 41 1.52 1.73 1.92 2.15 2.3⊣⎕fr←⍵}1287)

A20←18 6⍴0 0.9 0.95 0.975 0.99 0.995 (2 3) 2.5 3 3 3 3 (2 4) 3 4 4 4 4 (2 5) 4 4 5 5 5 (2 6) 5 5 6 6 6 (2 7) 5 6 7 7 7 (2 8) 3 7 7 8 8 (2 9) 7 8 8 9 9 (2 10) 7 8 9 10 10 (3 4) 3 3 4 4 4 (3 5) 2 4 4 5 5 (3 6) 4 4 5 6 6 (3 7) 4 5 6 6 7 (3 8) 5 6 6 7 8 (3 9) 6 6 7 8 8 (3 10) 6 7 8 9 9 (3 12) 7 8 9 10 11 9 10 0 0 0 0

TablEj←27 7⍴({⎕io←0⋄0 0 0.005 0.01 0.025 0.05 1 5,(4/¯1),1 16 6,(3/¯1),1 2 22 7 ¯1 ¯1 0 2 4 29 8 ¯1 0 2 4 6 37 9 ¯1 2 3 6 8 46 10 ¯1 3 5 8 11 56 11 ¯1 5 7 11 14 67 12 ¯1 7 10 14 17 79 13 ¯1 10 13 17 21 92 14 ¯1 13 16 21 26 106 15 ¯1 16 20 25 30 121 16 ¯1 19 24 30 36 137 17 ¯1 23 28 35 41 154 18 ¯1 28 33 40 47 172 19 ¯1 32 38 46 54 191 20 ¯1 37 43 52 60 211 21 ¯1 43 49 59 68 232 22 ¯1 49 56 66 75 254 23 ¯1 55 62 73 83 277 24 ¯1 61 69 81 92 301 25 ¯1 68 77 90 101 326 26 ¯1 76 85 98 110 352 27 ¯1 84 93 107 120 379 28 ¯1 92 102 117 130 407 29 ¯1 100 111 127 141 436 30 ¯1 109 120 137 152 466⊣⎕fr←⍵}1287)


⍝ === End of variables definition ===

(⎕IO ⎕ML ⎕WX)←1 1 3

 kruskalWallis←{
     ⎕IO←0 ⋄ ⎕ML←3
     NT←+/N←≢¨⍵
     R←+/¨(∊N⍴¨1+⍳≢N)⊂rank∊⍵
     H←(-3×NT+1)+(12÷NT×NT+1)×(R*2)+.÷N
     DF←¯1+≢N
     M←median¨⍵
     P←DF chiSquare prob>H
     NS←⎕NS''
        ⍝ NS.(Estimate SampleSize)←M NT
     NS.(Estimate SampleSize)←M N
     NS.(TestStatistic P DegreesOfFreedom)←H P DF
     NS.dist←chiSquare
     NS._Populations←≢N
     NS._HypothesizedValue←0
     NS._Parameter←'η'
     NS._Relation←'≠'
     NS._Claim←1
     NS.Type←'Non-Parametric'
     NS
 }

 kruskalWallisC←{
     ⍝⍵ matrix
     T←+/⍵                ⍝ Row Totals
     NI←+⌿⍵               ⍝ Column totals
     RBAR←(0,¯1↓+\T)+0.5×T+1
     RJ←RBAR+.×⍵
     N←+/NI
     S2←(÷N-1)×(T+.×RBAR*2)-N×0.25×(N+1)*2
     (÷S2)×((RJ*2)+.÷NI)-N×0.25×(N+1)*2
     
     
 }

 medianTest←{
     ⍝⍺ (Optional) grouping vector
     ⍝⍵ matrix simple numeric vector or vector of vectors,
     ⍝← TestStatistic
     ⍝  [Av] medianTest Xv|CXv|Im
     ⍝⍎ 17.543 ← medianTest 2 4⍴6 3 7 0 3 7 0 8
     ⍝⍎ medianTest Y1 Y2 Y3 Y4
     ⍝⍎ (9 10 7 8/1 2 3 4) medianTest Y
     ⎕IO←0 ⋄ ⎕ML←3
     ⍺←⍬
     X←⍺{1=≡⍵:,0 1↓⍵ groupBy toNestedVector ⍺ ⋄ ⍵}⍵
     CT←{2=⍴⍴⍵:⍵
         GM←median∊⍵  ⍝ Grand Median
         B←⍵>GM
         ⍉sum each B,⍪~B}X
     N←+/,CT
     a b←+/CT
     n←+⌿CT
     T←((N*2)÷a×b)×(CT[0;]*2)+.÷n
     T-N×a÷b}

 npgofReport←{
       ⍝ Non-Parametric GoodnessOfFit Report
     
     ⎕IO←0 ⋄ ⎕ML←3
     NN←+/N←⍵.SampleSize
     J←1+{Q⍳⍤1 0⊢⌈/Q←⍉1↓¯2↑[1]⍵}⍵.Table         ⍝ Find maximum values
     T←⍵.Table,' *'[J∊⍨⍳1+NN]                  ⍝ Flag T+ and T-
     I←NN{⍺<15:⍳⍺+1 ⋄ sort 0,(1+⍳5),⍵,(⍺-⍳5)}J
     T←T,⍨'i',1+⍳NN                              ⍝ Append sample index
     T←{⎕PP←5 ⋄ '-'@('¯'∘=)⍕⍵}T[I;]             ⍝ Format 5 decimal places, replace hi-minus
     T←NN{⍺<15:⍵ ⋄ (6↑⍵)⍪'.'⍪⍵[6;]⍪'.'⍪⍵[7;]⍪'.'⍪¯5↑⍵}T
     R←⌊/|-\⌽7,2⊥(⊢⍵.rel⌽)1+⍳3                   ⍝ (>,1),(=,2),(<,3)
        ⍝  PA←⍕{6::' ' ⋄ ' ',[-0.5](≢⍵.Parameters)↑'Mean:' 'Standard Deviation:',¨2↑⍵.Parameters}⍵
     PA←{6::' ' ⋄ (≢⍵.Parameters)↑'Mean:' 'Standard Deviation:',¨2↑⍵.Parameters}⍵
         ⍝ PA←' ',[¯0.5]⍕PA('Sample Size:  N ='N)
     PA←' ',[¯0.5]⍕{1≡≢⍵:PA('Sample Size: N = '⍵)
         'Sample Size: N = ',⍵[0],'M =',⍵[1]}N
     tb←⊃'Test Statistic: '('T=',⍕⍵.TestStatistic)
     tb←tb(⊃'P-Value: '('p'fmtP ⍵.P))
     A←⍺÷2*R=2            ⍝ If two-sided, divde significance by 2
     x←A{f←{⍵<5.5:1 ⋄ ⍵-0.01-0.83÷⍵}∘sqrt
         ⍵≡'normal':(f N)÷⍨(31⌊N)(A14 tableLookup)1-⍺
         ⍵≡'exponential':(1⌈0.1×sqrt N)÷⍨(100⌊N)(A15 tableLookup)1-⍺
         ⍵≡'kolmogorov':N kolmogorov critVal<⍺
         =/N:(N[0]*0.5*N[0]≥41)÷⍨(41⌊N[0])(A19 tableLookup)1-⍺
         sqrt(-⍟⍺)×0.5×(+÷×)/N
     }⍵._Distribution
     cv←' '~⍨,'<T(α)=>,F10.3'⎕FMT x
     tb←tb,(⊃'Critical Value:'cv)(⊃'Significance Level:'('α=',⍕⍺))
     h←'H₀:' 'H₁:',¨(R-1){R0←⍺⊃'≤=≥' ⋄ R1←⍺⊃'>≠<'
         ⍵≡'kolmogorov':{'F(x)',⍵,'F*(x)'}¨R0 R1
         ⍵≡'smirnov':{'F(x)',⍵,'G(x)'}¨R0 R1
         ⍵('not ',⍵)}⍵._Distribution
     tb←tablebox 2 2⍴tb
     C←(⍵.P<⍺)⊃'Fail to reject H₀' 'Reject H₀'
     TITLE←{(⊂⍵)∊'exponential' 'normal':'Lillefors' ⋄ ⍵}⍵._Distribution
     ⍕,[⍬](TITLE,' Test')T PA' 'h tb('Conclusion:'C)
     
     
 }

 MethodA←{
 ⍝ Copyright 2022 by  Steve Mansour
 ⍝∇ Estimate sample size for Tolerance Limits
 ⍝  Ref:  Conover  "Practical Nonparametric Stats" page 151
 ⍝⍺      Confidence Level
 ⍝⍵ q    Proportion of population
 ⍝⍺⍺ r+m Number of tails (usually 1 or 2)
     x←(2×⍺⍺)chiSquare critVal<1-⍺
     ⌊0.5+(0.25×x∘.×(1+⍵)÷1-⍵)+0.5×⍺⍺-1
 }


 MethodB←{
 ⍝(c) 2022 by Steve Mansour
 ⍝∇ Estimate population proportion for Tolerance Limits
 ⍝  Ref:  Conover  "Practical Nonparametric Stats" page 151
 ⍝⍺      Confidence Level
 ⍝⍵      Sample Size
 ⍝⍺⍺ r+m Number of tails (usually 1 or 2)
     x←(2×⍺⍺)chiSquare critVal<1-⍺
     ÷/x(-,+)⍨(4×⍵)-2×⍺⍺-1
 }


 kolmogorovGOF←{
⍝∇ Kolmogorov Goodness of Fit Test
⍝⍺ Parameters
⍝⍺⍺ Distribution
⍝⍵⍵ Relation
⍝⍵  Data
⍝⍎  4 8 rectangular kolmogorovGOF = 6.3 4.2 4.7 6 5.7
     ⍺←0 1 ⋄ ⎕IO←1 ⋄ ⎕ML←1
   ⍝  NS←⎕NS''
     X←⍵[⍋⍵]
  ⍝  F←⍺ ⍺⍺ prob≤X           ⍝ Theoretical Distribution
     F←⍺ ⍺⍺{11::⍺⍺ ⍵ ⋄ ⍺ ⍺⍺ prob≤⍵}X
     N←≢⍵                    ⍝ Sample Size
     R←⌊/|-\⌽7,2⊥(⊢⍵⍵⌽)⍳3    ⍝ (>,1),(=,2),(<,3)
     S←(+/X∘.≥X)÷N           ⍝ Empirical Distribution
     Tplus←⌈/U←F-S-÷N
     Tminus←⌈/V←S-F
     T←R⊃Tplus(Tplus⌈Tminus)Tminus
     P←(2*R=2)×N kolmogorov prob>T
     TBL←'Value' 'S(x)' 'F(x)' 'T+' 'T-'
     TBL⍪←X,S,F,U,⍪V
    ⍝ NS.rel←⍵⍵
⍝     NS.TestStatistic←T
⍝     NS.P←P
⍝     NS.Parameters←N
⍝     NS.distribution←kolmogorov
     ⍝NS
     D←'kolmogorov'
     D(mean ⍵)P T ⍬ TBL
 }


 lilleforsGOF←{
⍝∇ Lillefors Goodness of Fit Test
⍝⍺⍺ Distribution - normal or exponential
⍝⍵⍵ Relation
⍝⍵  Data
⍝⍎  NS←normal lilleforsGOF X
⍝⍎  NS←exponential lilleforsGOF ¯2-/0 6 8 16 22 23 34 44 47 51 57
     ⎕IO←1 ⋄ ⎕ML←1
     fnorm←{
         Z←zScore,X←sort ⍵
         F←normal prob≤Z
         N←count ⍵
         S←(⍳N)÷N    ⍝  S←(+/Z∘.≥Z)÷N
         TPlus←⌈/U←F-S-÷N
         TMinus←⌈/V←S-F
         T1←TPlus⌈TMinus
         P←1-N{⍺ between 3 31:⍺(A14 tableInverse)⍵
             D←⍺,⍺{⍵÷{⍵-0.01-0.083÷⍵}sqrt ⍺}1↓A14[≢A14;]
             N((A14⍪D)tableInverse)⍵}T1
         TBL←'Xi' 'Zi' 'S(Zi)' 'F(Zi)' 'T+' 'T-'
         TBL⍪←X,Z,S,F,U,⍪V
         MS←(mean,sdev)⍵
         'normal'MS P T1 ⍬ TBL}
     fexp←{⍝NS←⎕NS''
         X←sort ⍵
         Z←X÷mean X
         N←count ⍵
         F←1 exponential prob≤Z
         S←(⍳N)÷N                   ⍝ S←(+/Z∘.≥Z)÷N
         TPlus←⌈/U←F-S-÷N
         TMinus←⌈/V←S-F
         T2←TPlus⌈TMinus
         P←1-N{⍺≤100:⍺(A15 tableInverse)⍵   ⍝  P←A15 lookup N'*'T1
             D←A15⍪N,1↓A15[≢A15;]÷sqrt ⍺
             ⍺(D tableInverse)⍵}T2
         TBL←'Xi' 'Zi' 'S(Zi)' 'F(Zi)' 'T+' 'T-'
         TBL⍪←X,Z,S,F,U,⍪V
         'exponential'(mean ⍵)P T2 ⍬ TBL}
    ⍝ ×0 1 ⍺⍺ 1:fnorm ⍵ ⋄ fexp ⍵}
     ×⊃0 1 ⍺⍺ 1:fnorm ⍵ ⋄ fexp ⍵}


 mannWhitney←{
⍝∇ Mann-Whitney (Wilcoxon) Rank-Sum Test
⍝⍺ -  Smaller Sample
⍝⍺⍺ - relation (<≤=≥>≠)
⍝⍵ -  Larger Sample
⍝← T - TestStatistic
⍝⍎ A← 93 100 75 92 55 98 85 84 82 90
⍝⍎ B← 99 84 76 93 87 95 77 79 61 86
⍝⍎ A = mannWhitney  B
     ⎕IO←0 ⋄ ⎕ML←3
     R←⍺⍺{3=⎕NC'⍺⍺':2⊥0 0 1 ⍺⍺ 0 1 0 ⍝ Determine relation
         ⍺⍺+(⍺⍺<1)×4+⍺⍺}0    ⍝ if ¯1 0 1 adjust
     N←≢¨⍺ ⍵                        ⍝ Sample Sizes
     M←median¨⍺ ⍵                   ⍝ Estimate median
     ns←⎕NS''
     ns.Estimate←M
     ns.SampleSize←N
     ns.StandardDeviation←⍬
     ns.DegreesOfFreedom←⍬
     W←+/¨(1 ¯1×≢¨⍺ ⍵)↑¨⊂rank ⍺,⍵   ⍝ Rank sums
   ⍝  T←W[R⊃0,{⍵,⌽⍵}(?∘≢,>/,</)N]    ⍝ Small sample Test Statistic
     U←⌊/W-0.5×N×N+1                   ⍝ U statistic
     ns.TestStatistic←U
     ns.StandardError←⍬
     P←(10⌊N)mannWhitneyU prob≤U
     ns.P←1⌊P×2*R∊3 4
     ns.dist←mannWhitneyU
     ns.ParameterList←N
     ns._Parameter←'η'
     ns._Relation←R⊃' ><≠≠<>'
     ns._Claim←R∊1 2 3
     ns._HypothesizedValue←0
     ns._Populations←2
     ns._Paired←0
     ns.Type←'Hypothesis'
     10≥⌊/N:ns
     Z←(U-×/0.5,N)÷sqrt(×/N,+/1,N)÷12 ⍝ Z statistic
     ns.TestStatistic←|Z
     P←normal prob<Z
     ns.P←1⌊P×2*R∊3 4
     ns.dist←normal
     ns.ParameterList←0 1
     ns}


 npgof←{
⍝∇ Non-Parametric Goodness of Fit
⍝⍺ Parameter List or ⍬
⍝⍺⍺ Distribution
⍝⍵⍵ Relation
⍝⍵  Data
     ⎕IO←1 ⋄ ⎕ML←1
     ⍺←⍬                            ⍝If left operand is
     2=⎕NC'⍺⍺':⍺⍺ smirnovGOF ⍵⍵ ⍵   ⍝ Vector, test two independent samples
     ⍬≡⍺:⍺⍺ lilleforsGOF ⍵          ⍝ If no parameters, normalize data
     ⍺ ⍺⍺ kolmogorovGOF ⍵⍵ ⍵        ⍝ If parameters, check largest difference
 }


 rankSumTest←{
     ⎕IO←0 ⋄ ⎕ML←3
     b←2⊥1 0 1 ⍺⍺ 0 1 1
     X C←⍺{∧/(∪⍺)∊0 1:⍺ ⍵
         S←≢¨⍺ ⍵ ⋄ (⍺,⍵)(S/0 1)}⍵
     I←⍋X ⋄ X←X[I] ⋄ C←C[I]          ⍝ Sort
     R←1+(+/X∘.>X)+0.5×¯1++/X∘.=X    ⍝ Rank
     N←(+/C),+/~C
     W←(+/N){⍵,⍵-⍨0.5×⍺×⍺+1}C+.×R ⍝ Rank sums
   ⍝  P←N uDist prob≤↑W
     P←N mannWhitneyU prob≤↑W
     P←N mannWHitneyU prob>
     P←P×2*b∊1 6
     P,↑W

    ⍝ ⌊/W-0.5×N×N+1





 }


 signedRank←{
⍝  Wilcoxon Signed-Rank Test
     R←1+0.5×¯1++/1+×∘.-⍨⍵  ⍝ Rank
     S←R××⍵                 ⍝ Signed Rank
     T←S+.×(S>0),⍪-S<0      ⍝ Rank sums
     B←2 ⍺⍺ 1 3 2
     ↑B/T,+/T
 }


 smirnovGOF←{
⍝∇ Smirnov Goodness of Fit Test
⍝⍺⍺ Data from Distribution 1
⍝⍵⍵ Relation
⍝⍵  Data from Distribution 2
⍝⍎ X←7.6 8.4 8.6 8.7 9.3 9.9 10.1 10.6 11.2
⍝⍎ Y←5.2 5.7 5.9 6.5 6.8 8.2 9.1 9.8 10.8 11.3 11.5 12.3 12.5 13.4 14.6
⍝⍎  NS← X smirnovGOF = Y
     ⎕IO←1 ⋄ ⎕ML←1
     NS←⎕NS''
     B←(X←sort ⍺⍺,⍵)∊⍺⍺        ⍝ Get positions of X variables
     SS←(+\÷+/)¨B(~B)        ⍝ Empirical Distributions
     R←⌊/|-\⌽7,2⊥(⊢⍵⍵⌽)⍳3    ⍝ (>,1),(=,2),(<,3)
     M←≢⍺⍺ ⋄ N←≢⍵
     T1←⌈/U←|⍣(R=2)⊃-/(R=3)⌽SS ⍝ Test Statistic
   ⍝  P←1-A19 lookup N'*'(T1×N)
     P←{M=N:÷/(N+⍵×N 0)!2×N
         *-2×(⍵*2)×M(×÷+)N}T1
     P×←2*R=2
     D←'smirnov'
     f←{⍵\⍵/⍺}
     TBL←'X' 'Y' 'S1' 'S2' 'S1-S2'
     TBL⍪←⍉↑(X f B)(X f~B),SS,⊂U
     D(M N)P T1 ⍬ TBL
 }


 wilcoxon←{
 ⍝∇ Wilcoxon Signed-RankTest
 ⍝⍺
 ⍝⍵
 ⍝←
     ⎕ML←3 ⋄ ⎕IO←0
     rel←⍺⍺{2=⎕NC'⍺⍺':⍺⍺                ⍝ Determine relation
         2⊥0 0 1 ⍺⍺ 0 1 0}0
     N←count ⍵~0                        ⍝ Sample Size
     R←(×/×,∘⍪rank∘|)⍵~0                ⍝ Get ranks
     T←|R+.×¯1 1∘.=⍨×R                  ⍝ T+ T-
     f←{N rel←⍺
         T←rel⊃0,(⌽⍵),(2/⌊/⍵),⍵            ⍝ Small sample case
         NS←⎕NS''
         NS.P←(2*rel∊3 4)×N wilcoxonT prob≤T  ⍝
         NS.TestStatistic←T
         NS.dist←wilcoxonT
         NS.ParameterList←N
         NS}
     g←{n rel←⍺                          ⍝ Large sample case
         T←⌊/⍵
         M←N wilcoxonT theoretical mean 0
         S←N wilcoxonT theoretical sdev 0
         Z←|(T-M)÷S
         P←(2*rel∊3 4)×normal prob≥Z
         TestStatistic←Z
         dist←normal
         ⊢NS←⎕NS'TestStatistic' 'P' 'dist'}
     NS←N rel{25≥↑⍺:⍺ f ⍵ ⋄ ⍺ g ⍵}T
     NS.DegreesOfFreedom←⍬
     NS.StandardError←⍬
     NS.StandardDeviation←0
     NS.Type←'Hypothesis'
     NS._Relation←rel⊃' ><≠≠<>'
     NS._HypothesizedValue←0
     NS._Parameter←'η'
     NS._Populations←1
     NS._Claim←1
     NS.SampleSize←count ⍵
     NS.Estimate←median ⍵
     NS._Paired←1
     NS}


:EndNamespace 
