﻿:namespace Overrides
⍝ this namespace has the overrides which are treated differently by MiServer and HRServer
⍝ these fns are called directly by HRServer, whereas the MiServer-methods are stores in the Server-class
⍝ and overridden by fns that call these fns as.

    ∇ onServerStart;⎕USING;tie;file;toc;i
      ⎕←'Overrides.',1⊃⎕SI
      :Trap 0
          :If ⎕NEXISTS file←#.Boot.AppRoot,'Code/nsvars.dcf'
              tie←file ⎕ftIE 0
              :For i :In ⍳≢toc←⎕FREAD tie,1
              :trap 0
                  ⍎(i⊃toc),'←⎕fread tie,i+1'
                  :else 
                  ⎕←'Problem restoring #',(⍕1+i),' as ',i⊃toc
                  :endtrap
              :EndFor
              ⎕FUNTIE tie
          :EndIf
          '#.Models'⎕NS''
          '#.Datasets'⎕NS''
          ⎕PATH←'#.TamStat'  ⍝ otherwise "eq" and other utils may crash
          path←#.Boot.AppRoot,'Data/'
          {}#.tsConsoleCommands.loadCSV¨{⍵ #.Datasets}¨{(~∨/¨(⊂'.meta')⍷¨⍵)/⍵}⊃(⎕NINFO⍠1)path,'*.csv'   ⍝ load all *.CSVs...
          sources←#.Anova #.Arithmetic #.Distribution #.Graph #.Help #.Logical #.NonParametric #.Operators #.Regression #.Relational #.Summary #.Util
          '#.TamStat'⎕NS⊃,/{((⍕⍵),'.')∘,¨(⍵.⎕NL-⍳9)~⊂'SALT_Data'}¨sources
          #.TamStat.(⎕IO ⎕ML)←0 3
          #.TamStat.R_Available←0
          #.TamStat.API←#.API  ⍝ re-create #.TamStat.API from SM (now as a ref to #.API)
          #.R_Available←0
          #.Safe.ValidTokens,←(,'#')'⎕THIS'   ⍝ allow these in TamStat (essential for internal ops)
          #.Datatypes←⎕JSON 1⊃⎕NGET #.Boot.AppRoot,'assets/datatypes.json'
     
⍝ collect info about the environment
          '#.Env'⎕NS''
          :If ⎕NEXISTS file←#.Boot.AppRoot,'version.json'
              #.Env.(tsVersion tsDate tsId)←(⎕JSON 1⊃⎕NGET file).(tag created_at id)
          :Else
              #.Env.(tsVersion tsDate tsId)←⊂'N/A'
          :EndIf
          :If ⎕NEXISTS file←({6::⍵.WC2Root ⋄ ⍵.MSRoot}#.Boot),'version.json'  ⍝ use #.Boot.MSRoot or WC2Root
              #.Env.(msVersion msDate msId)←(⎕JSON 1⊃⎕NGET file).(tag created_at id)
          :Else
              #.Env.(msVersion msDate msId)←⊂'N/A'
          :EndIf
          ⎕USING←'System'
          #.Env.dataFolder←path
          #.Env.dotnetVersion←4⊃#.tsSiteTools.GetDOTNETVersion
          #.Env.serial←2 ⎕NQ'.' 'GetEnvironment' 'DYALOG_SERIAL'
          #.Env.os←3↑1⊃'.'⎕WG'APLVersion'  ⍝ reports current operating systems (abbreviated to 3 letters):    Win | Mac | Lin | AIX | Sol
          #.Env.dyaVersion←2⊃'.'⎕WG'APLVersion'
          #.Env.lic←0 ⍝ 0=unreg, 1=personal, 2=commercial
          :If 6=+/#.Env.serial∊⎕D
              #.Env.lic←1+500000>#.Strings.tonum #.Env.serial
          :Else
              #.Env.serial←'(unregistred)'
          :EndIf
          #.Env.tsMode←{6::2 ⋄ 'HRServer'≡⍎⍵}'#.Boot.ms.Framework'         ⍝ 1=running locally, 2=remote, 0=???
          #.Env.temp←{⍵,(~¯1↑⍵∊'\/')/'/'}739⌶0   ⍝ temporary (local) directory with a trailing backslash
          #.Env.maxws←2 ⎕NQ'.' 'GetEnvironment' 'maxws'
      :Else
          ⎕←(⎕JSON⍠'Compact' 0)⎕DMX
      :EndTrap
    ∇



    ∇ onSessionStart req
      ⎕←'Overrides.',1⊃⎕SI
      :If {6::0 ⋄ 'HRServer'≡⍎⍵}'#.Boot.ms.Framework'
      ⍝:AndIf #.Prefs.closeAPLonExit
          #.Boot.ms._Renderers.onClose←⊂'#.Pages.tsPage.OFF0'  ⍝ this is more onServerStart-type, but isn't possible then...
      :EndIf
    ⍝ Process a new session
    ⍝   ⎕←'*** ',1⊃⎕SI
      ⍝ req.Session.Prefs←#.Prefs←⎕JSON #.Files.ReadText #.Boot.AppRoot,'preferences.json'
      ⍝ req.Session.(⍙⍙trap⍙⍙←Prefs.Session.TrapErrors≡⊂'true')
      ⍝ req.Session._tsLog←req.Session._tsLog←,#.tsSiteTools.mns('type' 5)('in' 'Welcome to TamStat')
    ∇


    ∇ onHandleMSP req
      ⎕←'Overrides.',1⊃⎕SI
      i←req.Session.Pages._PageName⍳⊂req.Page
      inst←i⊃req.Session.Pages
      inst #.tsSiteTools.InitDS req
      :If {6::1 ⋄ 0×≢⍕⍵.userNS.⎕NL ¯2}inst
      :OrIf {6::1 ⋄ ~(⊂⍵.currDS)∊⍵.userNS.DATA.⎕NL-9}inst
          inst.(userNS currDS)←req.Session.(userNS currDS)
      :EndIf
      inst.currDS←req.Session.currDS   ⍝ importans to keep it across page changes!
      inst.ref←inst.userNS.DATA⍎inst.currDS
      :If req.isAPLJax
          :Select 2⊃⎕NPARTS #.Strings.lc req.Page
          :CaseList 'distwiz' 'regwiz' 'chartwiz'  ⍝ this will be revised by using a proper ⍺ for Get in the relevant .mipages
              :If 0≠inst.⎕NC⊂'msAutoConvertToNumber_Fields'
                  test←↓req.Data
                  i←⍸req.Data[;1]∊inst.msAutoConvertToNumber_Fields
                  req.Data[i;2]←{(0<≢⍵)∧∧/⍵∊⎕D,'.-':#.Strings.tonum ⍵ ⋄ ⍵}¨req.Data[i;2]
                ⍝   ⎕←'=== onHandleMSP === changed:' ⋄ ⎕SE.Dyalog.Utils.disp(∊test≢¨↓req.Data)⌿req.Data,⎕DR¨req.Data
                  test←↓req.Data
                  req.Data[;2]←{(0<≢⍵)∧∧/⍵∊⎕D,'.-':#.Strings.tonum ⍵ ⋄ ⍵}¨req.Data[;2]
                ⍝   ⎕←'=== onHandleMS∆ === found more numbers:' ⋄ ⎕SE.Dyalog.Utils.disp(∊test≢¨↓req.Data)⌿req.Data,⎕DR¨req.Data
              :EndIf
          :EndSelect
      :Else
     
      :EndIf
      #.tsSiteTools.ReadSessionPrefs req
      inst.Prefs←req.Session.Prefs
    ∇

    ∇ Cleanup
      ⎕←'Overrides.',1⊃⎕SI
      :If #.Env.tsMode=1
      :AndIf {6::⍵ ⋄ #.Prefs.closeAPLonExit}0
          ⎕OFF
      :EndIf
    ∇



:endnamespace
