﻿:Class tsBase  : MiPage
⍝ This is a template that adds a consistent header to all pages based on it

    :field Public EditExpression←0
    :field Public ShowExpression←1 1 0 ⍝ Show the expression input[1] and the toggle for the result [2] or a scalar result [3] (¯1 for this field means: include the field, but do not yet show it)
    :field public Prefs
    :field public _tsLog
    :field public wpProc
    :field public userNS
    :field public currDS
    :field public ref
    :field public UseWaitingPopup←0
    :field public isWizard←1


    ∇ {req}LogEntry x;app;e;in;out;logPos
      :Access public
⍝ x=(Type)(in)[out]
⍝          in may also be a ns with following variables:
⍝          in = expression
⍝          Message = out
⍝          [_logPos] = determine logPos of entry (used with loadLog)
⍝     Type=42 is special - its "out" is a vector containng (Type)(out)-pairs
⍝             (i.e. to bundle report and chart created by one command - does not include 4=coment)
⍝------------------------------------------------------------------------------------------
      →(0=≢x)/0
      :If 9=⎕NC'req'
          _tsLog←req.Session._tsLog
      :EndIf
      logPos←1+≢_tsLog
      :If 4=1⊃x  ⍝ comment
          :If 4=¯1↑_tsLog.type          ⍝ if last entry is comment, too
              e←(≢_tsLog)⊃_tsLog
              e.out←e.out{0∊≢¨⍺ ⍵:⍺,'<br />&nbsp;' ⋄ ((-6×'<br />&nbsp;'≡¯12↑⍺)↓⍺),(∨\⍵≠' ')/⍵}2⊃x  ⍝ empty entry = line-break (remove leading blanks)
              logPos←≢_tsLog
          :Else
              e←#.tsSiteTools.mns('type'(1⊃x))('in'(2⊃x))('out' '') ⍝ first line of a new comment goes into in
          :EndIf
      :ElseIf 2=≢x
          in←2⊃x ⋄ out←''
          :If 9=⎕NC'in'
              out←in.Message
              :If 2=in.⎕NC'_logPos' ⋄ logPos←in._logPos ⋄ :EndIf
              in←in.in
          :EndIf
          e←#.tsSiteTools.mns('type'(1⊃x))('in'in)('out'out)
      :Else
          in←2⊃x ⋄ out←3⊃x
          :If 42=1⊃x
              out←2↓x
              out←#.tsSiteTools.mns¨{('type'(1⊃⍵)){a←⊂⍺ ⋄ 1=⍴⍴2⊃⍵:a,⊂('out'(2⊃⍵)) ⋄ a,('out'(↓2⊃⍵))('split' 1)}⍵}¨out
              e←#.tsSiteTools.mns('type'(1⊃x))('in'in)('out'out)('multiple' 1)
          :Else
              out←3⊃x ⋄ app←⍳0
              :If 2=⍴⍴out
                  out←↓out ⋄ app←'split' 1
              :EndIf
              :If 0<≢app
                  e←#.tsSiteTools.mns('type'(1⊃x))('in'(2⊃x))('out'out)app
              :Else
                  e←#.tsSiteTools.mns('type'(1⊃x))('in'(2⊃x))('out'out)
              :EndIf
          :EndIf
      :EndIf
      e._id←1+⌈/1,_tsLog._id
      :If logPos=0
      :OrIf logPos>≢_tsLog
          _tsLog,←e
      :Else
          :If logPos≠⌊logPos ⋄ _tsLog←(1+_tsLog._id=⌊logPos)/_tsLog ⋄ :EndIf
          _tsLog[1+_tsLog._id⍳⌊logPos]←e
      :EndIf
      :If 9=⎕NC'req'
          req.Session._tsLog←_tsLog    ⍝ update log in session
      :EndIf
 ⍝     ⎕←'Logged x',⎕json x
 ⍝     ⎕←⎕json _tsLog
    ∇

    ∇ E←{opts}FormatLogEntry id;_value;result;e;toggle;Result;R;js;loop;InOutStyle;inputStyle;suffix;out;decs;res;bin;h;j;p
      :Access public
⍝ return namespace with data for outpt using JS.SessionLog
⍝ (ns with vars out, id)
⍝ opts: name/value list or namespace with optional params:
⍝  only: numvec to filter types
⍝  CopyButton 0/1 - optionally do not generate copy-btn
⍝  DeleteButton 0/1 - optionally do not generate copy-btn
⍝ id=0: last one (
    ⍝ ⎕←'FormatLogEntry ',id ⋄ ⎕←'Called from ',(2⊃⎕si),'[',(⍕2⊃⎕lc),'], ', (3⊃⎕si),'[',(⍕3⊃⎕lc),'], ', (4⊃⎕si),'[',(⍕4⊃⎕lc),']'
      :If {6::1 ⋄ 0×≢⍎⍵}'tsLog'
          _tsLog←_Request.Session._tsLog
      :EndIf
      getOpt←{2=opts.⎕NC ⍵:opts⍎⍵ ⋄ ⍺}
     
      :If id=0 ⋄ id←(≢_tsLog)⊃_tsLog._id ⋄ :EndIf
      :If 0=⎕NC'opts' ⋄ opts←⎕NS''
      :ElseIf 9≠⎕NC'opts' ⋄ opts←#.tsSiteTools.mns{2<|≡⍵:⍵ ⋄ ,⊂⍵}opts ⋄ :EndIf
     
      E←(_tsLog._id⍳id)⊃_tsLog ⋄ s_id←⍕id
    ⍝  ⎕←'E=',⎕json E
      R←'' ⋄ js←''
      _value←E.in
      :If 2=E.⎕NC'multiple'
      :AndIf E.multiple
          E←E.out
      :EndIf
      loop←0
      Result←⎕NEW _.div ⍝ just to be safe - should not happen...
     
     
      :For loop :In ⍳≢E
          e←loop⊃,E
          InOutStyle←' .InOut' ⋄ inputStyle←'input'
          :If 2=opts.⎕NC'only'
          :AndIf ~e.type∊opts.only
              :Continue
          :EndIf
          suffix←'%c%',loop⊃(⊂''),⎕A
          :Select e.type
     
          :CaseList 1 4 7         ⍝ 1= regular, 4=comment, 7=warning-msg
              result←e.out
              :If 2=e.⎕NC'split' ⋄ :AndIf e.split ⋄ result←↑result ⋄ :EndIf
              :If e.type=4 ⋄ InOutStyle←' .InOut .Comment' ⋄ inputStyle←''
              :EndIf
              :If 326=⎕DR result ⍝ got a nested "thing"...
                  result←⍕result  ⍝ format that thing!
              :EndIf
     
              :If 1=⍴⍴result ⋄ result←,[0.5]result ⋄ :EndIf ⍝ display vectors as single-row matrices
              :If 1<⍴⍴result ⍝⍝ Return in the form of a table if the output is a matrix
                  :If isChar result
                      :If e.type=7
                          out←('.output .Comment .bg-danger .text-light .output',suffix)New _.div(4↓∊(⊂'<br>'),¨⊆e.in)
                          opts.(CopyButton DeleteButton)←0
                      :ElseIf ~∨/'Comment'⍷InOutStyle
                          out←('.output .output',suffix)New _.pre(4↓∊(⊂'<br>'),result)
                      :Else
                          out←('.Comment .output .output',suffix)New _.div(⍕result)
                      :EndIf
                  :Else
                      out←('.output .output',suffix)New _.div
                      decs←Prefs.(Session.decimals,decimalsO)[1+isWizard]×(⎕DR∊result)∊645 1287 1289   ⍝ numbers are always displayed with session-decs. We could go extreme here and addd "context-info" (or "decimals" to the log-entry to distinguish the source the number came from - it it becomes relevant...)
                      res←decs #.tsSiteTools.fmtX result
                      '.table-ts-striped .table-sm .text-right'out.Add _.Table res
                  :EndIf
              :Else
                  decs←Prefs.(Session.decimals,decimalsO)[1+isWizard]×(⎕DR∊result)∊645 1287 1289
                  res←decs #.tsSiteTools.fmtX result
                  out←('.output .output',suffix)New _.p res
              :EndIf
     
          :Case 2  ⍝ SVG Chart (or ExtOut from frequency)
              result←e.out
              p←'.output-svg'
              :If '<div '≡5↑result
              :OrIf '<pre'≡4↑result
                  result←result[⍳4],' id=output',suffix,4↓result ⍝ inject ID into SVG
                  p←('<pre'≢4↑result)/p  ⍝ remove output-svg if it's a pre-tag!
              :ElseIf '<table'≡6↑result
                  result←'<div id=output',suffix,'>',result,'</div>' ⍝ deal with a table
                  p←0/p  ⍝ remove output-svg if it's a pre-tag!
              :Else
                  ⎕←'result object does not match expectations!'
                  ∘∘∘ ⍝
              :EndIf
              out←('.output ',p,'.output',s_id,' .output',suffix)New _.div result
     
          :Case 3  ⍝ Error
              out←('.output .output',suffix)New _.div
              out.Add _.div(∊(⊆e.out),¨⊂'<br />')
              inputStyle,←' bg-warning'
          :Case 5 ⍝ System-Msg ⍝ does not get copy/delete-buttons
              out←New #.HtmlElement ⍝ no content...
              inputStyle←'input .System'
          :Case 6  ⍝ preformatted HTML
              out←('.output .output',suffix)New _.div e.out
          :Case 62  ⍝ preformatted HTML - logged w/o output tags...
              out←('.output',suffix)New _.div e.out   ⍝ output#n is needed to allow collapsing of text
          :Case 8 ⍝ ExtOut
              (h j)←#.ExtOut.FormatExtOut e.out.ExtOut
              out←('.ExtOut .output',suffix)New _.div h
              js,←j
          :Else
              dbgShow'Unknown value for e.type!'
              dbgShow ⎕JSON e
              ∘∘∘
          :EndSelect
     
          :If loop=1 ⍝ header, also in case of 42/multiple entries!
              :If e.type=7
                  n←⍕(¯1+_tsLog._id⍳id)⊃_tsLog._id  ⍝ a little "hacky": append it below output using same class-name
                  Result←New #.HtmlElement  ⍝ and create a minimal canvas for it...
              :Else
                  Result←('#InOut',∊{0:'' ⋄ ⍕⍎⍵}¨'id' 'InOutStyle')New _.div
                  p←('#inp',⍕s_id)Result.Add _.p
                  toggle←((e.type=42)∨0<≢out)/'<span data-expression-counter="%c%" onclick="ToggleResult(this);"><i class="fas fa-caret-down fa-fw"></i></span>'
                  :If 0<≢toggle ⋄ p.Add toggle ⋄ :EndIf
                  ('.',inputStyle,' ondblclick="ToExpr(%c%);" id="input%c%"')p.Add _.span _value
              :EndIf
              :If e.type≠5
                  :If 1 getOpt'CopyButton'
                      :If e.type=4
                          (('#clpcpy%c% class="btn-xs float-right cursorHand clpbrd%c%" data-clipboard-target=#InOut%c%')p.Add _.span).Add _.i'' '.far .fa-copy'
                          js,←'AddClpCopy(',s_id,',0);' ⍝ add handler for clipcopy without menu
     
                      :ElseIf e.type=2 ⍝ chart
                         ⍝ can't copy charts yet
                         ⍝ ('#clpcpy%c%  class="btn-xs float-right cursorHand" onclick=CopySVG("#InOut%c%")'p.Add _.span).Add _.i''('.fa','rs'[1+0<≢out],' .fa-copy')
                         ⍝ js,←'AddClpCopy(',(⍕id),',',(⍕0<≢out),');' ⍝ add handler for clipcopy with menu-options
     
                      :Else ⍝ everything else
                          (('#clpcpy%c% class="btn-xs float-right cursorHand clpbrd%c%" data-clipboard-target=#input%c%')p.Add _.span).Add _.i''('.fa','rs'[1+0<≢out],' .fa-copy')
                          js,←'AddClpCopy(',s_id,',',(⍕0<≢out),');' ⍝ add handler for clipcopy with menu-options
                      :EndIf
                  :EndIf
                  :If 1 getOpt'DeleteButton'
                      :If e.type=4
                          (bin←('#bin_%c% .btn-xs .float-right .cursorHand data-jbox-content="Remove this comment from log"')p.Add _.span).Add _.i'' '.fas .fa-trash-can'
                      :Else
                          (bin←('#bin_%c% .btn-xs .float-right .cursorHand data-jbox-content="Remove this command and its output from log"')p.Add _.span).Add _.i'' '.fas .fa-trash-alt'
                      :EndIf
                      bin.On'click' 'DeleteEntry'
                  :EndIf
              :EndIf
          :ElseIf 0<≢out.Content
              :If e.type≠2
                  (('#clpcpy',suffix,' class="btn-xs float-right cursorHand clpbrd%c%" data-clipboard-target=.output',suffix)out.Add _.div).Add _.i'' '.far .fa-copy'
                  js,←'AddClpCopy("',suffix,'",0);' ⍝ add handler for clipcopy with menu-options
              :Else
                 ⍝ can't copy charts yet
                 ⍝ (('#clpcpy',suffix,' class="btn-xs float-right cursorHand clpbrd%c%" onclick=CopySVG(".output',suffix,'");')out.Add _.div).Add _.i'' '.far .fa-copy'
              :EndIf
          :EndIf
          :If 9=⎕NC'out'
          :AndIf 0<≢h←out.Render
              Result.Add h
          :EndIf
      :EndFor
      (h j)←getHTMLjs Result.Render
      R,←('%c%'s_id)Subst h
      js←('%c%'s_id)Subst j,js
     
      E←#.tsSiteTools.mns('out'R)('nr's_id)('js'js)
     
    ∇

    ∇ R←DeleteEntry;_tsLog;nr
      :Access public
      nr←#.Strings.tonum 2⊃'_'#.Strings.split _currentTarget
      _tsLog←SessionGet'_tsLog'
     ⍝ ⎕←'Got tslog!' ⋄ ⎕←⎕json _tsLog
      _tsLog←(nr≠_tsLog._id)/_tsLog
      _Request.Session._tsLog←_tsLog
     ⍝ ⎕←'Removed entry #',(nr),' and put it back into Session as:'⋄⎕←⎕json _tsLog
      R←Execute'$("#InOut',(⍕nr),'").remove();'
    ∇


    ∇ {r}←Wrap;lang;header;home;menu;nul;nav;d
      :Access Public
⍝Use'Bootstrap4'
      Use'⍎/assets/Bootstrap-4.1.1/popper.min.js'
      :If 0=Prefs.⎕NC'theme'
      :OrIf Prefs.theme≡''
      :OrIf Prefs.theme≡'none'
          Use'⍕/assets/Bootstrap-4.1.1/bootstrap.min.css'
      :Else
          Use'⍕/assets/Bootstrap-4.1.1/bootstrap-',Prefs.theme,'.min.css'
      :EndIf
      Use'⍎/assets/Bootstrap-4.1.1/bootstrap.min.js'
      Use'jquery-ui-contextmenu'
      Use'⍕/hopscotch/css/hopscotch.min.css'
      Use'⍎/hopscotch/js/hopscotch.min.js'
      Use'faIcons5svg'
      Use'⍎/assets/tamstat.js'
     
⍝ set the tab/window title to the name of the application defined in Config/Server.xml
      Add _.title _Request.Server.Config.Name
     
⍝ add a link to our CSS stylesheet
      _CssOverride←'/Styles/style.css'
      :If UseWaitingPopup
          wpProc←'#wpProc style=display:none;'Add _.div
          d←'#wpdiv align=center'wpProc.Add _.div
          '#wptitle'd.Add _.p'PLEASE WAIT'
          d.Add _.img'src="/assets/TamStat_Spinner.gif"'
          '#wpText'(d.Add _.p).Add _.span'Processing your request'
     
          Add _.style ScriptFollows
      ⍝ #wpProc {
      ⍝     display: block; 
      ⍝     width: 100%; 
      ⍝     height: 100%; 
      ⍝     position: fixed; 
      ⍝     left: 0; 
      ⍝     top: 0; 
      ⍝     z-index: 10001;
      ⍝     display: flex;
      ⍝     justify-content: center;
      ⍝     align-items: center;
      ⍝ }
      ⍝ #wpdiv {
      ⍝     visibility: visible; 
      ⍝     display: block; 
      ⍝     width: 220px;
      ⍝     margin-top: 10em;
      ⍝     color: black;
      ⍝     background-color: white;
      ⍝     padding: 5px;
      ⍝     border-radius: 10px;
      ⍝     cursor: progress;
      ⍝     box-shadow: 0 10px 30px 0 black;
      ⍝     margin: 0 auto;
      ⍝     z-index: 2000;
      ⍝     opacity: 1;
      ⍝     position: absolute;
      ⍝     top: 30%;
      ⍝     left: calc(50% - .5 * 220px);
      ⍝ }
      ⍝
      ⍝ #wptitle {
      ⍝     margin-top: 0;
      ⍝     padding: 5px;
      ⍝     color: rgba(255,255,255,.5);
      ⍝     background-color: #343a40;
      ⍝     border-radius: 5px;
      ⍝     font-size: larger;
      ⍝     font-weight: bold;
      ⍝ }
     
        ⍝   mydiv←'wpdiv'Add _.div
        ⍝   'align'mydiv.Set'center'
        ⍝   'wptitle'mydiv.Add _.p'PLEASE WAIT'
        ⍝   'src=Syncfusion/assets/css/web/gradient-saffron/images/waitingpopup.gif'mydiv.Add _.img
        ⍝   p←mydiv.Add _.p
        ⍝   '#wpText'p.Add _.span'Processing your request'
⍝'template'wpProc.Set'#wpdiv'
⍝ call the base class Wrap function
⍝          Add _.Script'$("#wpProc").ejWaitingPopup({showOnInit:false});'
      :EndIf
      r←⎕BASE.Wrap
    ∇

    ∇ R←Handle_ddSelectEnd
      :Access public
      R←''

      :If UseWaitingPopup
        R←Execute'$("#wpProc").hide();'

      :EndIf
    ∇



    ∇ R←id ReplaceAndExecute html;h;j
      :Access public
⍝ separate html and script-portion, replace the content of "id" and execute
⍝ scripted stuff...
      :If 9=⎕NC'html' ⋄ html←html.Render ⋄ :EndIf
      (h j)←getHTMLjs html
      R←id Replace h
      R,←Execute j
    ∇

    ∇ R←id AppendAndExecute html;h;j
      :Access public
⍝ separate html and script-portion, replace the content of "id" and execute
⍝ scripted stuff...
      (h j)←getHTMLjs html
      R←id Append h
      R,←Execute j
    ∇


    ∇ R←sel ReplaceValue val
      :Access public
⍝ builds JS to update the value of if (useful to update input-controls)
⍝ R is the complete Execute '...'-thing, so RV can be used in the same way as simple Replace is used
      R←Execute'$("',sel,'").val("',val,'");'
    ∇


    ∇ (h j)←getHTMLjs html;sc
      :Access  public shared
      :If 9=⎕NC'html' ⋄ html←html.Render ⋄ :EndIf
      h←('<script>(.*)</script>'⎕R''⍠('DotAll' 1)('Mode' 'M')('Greedy' 0))html
     
      :If (⊂'')≢sc←⊆('<script>(.*)</script>'⎕S'\1'⍠('DotAll' 1)('Mode' 'M')('Greedy' 0))html
          j←∊sc
      :Else ⋄ j←''
      :EndIf
    ∇

    ∇ dbgShow msg;z
      :Access public
      z←{6::⍵ ⋄ _Request.Session.⍙⍙trap⍙⍙}1
      →z↓0 ⍝ show nothing unless we're running w/o error-trapping
      :If 1<|≡msg
          ⎕SE.Dyalog.Utils.disp msg
      :Else
          ⎕←msg
      :EndIf
    ∇


    ∇ z←isDefined _varname
      :Access public
      z←(1⊃⎕RSI).{0::0 ⋄ ⍎⍵}_varname
    ∇


    ∇ js←type Alert msg;opts;tit
      :Access Public
⍝ type=1: Error
⍝      2: Warning
⍝      3: Info
      opts←⎕NS''
      tit←(('.text-',type⊃'danger' 'warning' 'info')New _.Icon('fas-',(type⊃'times' 'info' 'check'),'-circle')),⊂New _.b' ',type⊃'Error' 'Warning' 'Info'
      tit←renderIt tit
      opts.title←tit
      js←opts #._.jBox.Modal msg
     
    ∇

    ∇ R←{opts}Notice(type content);options;jb;color;icon
      :Access public
⍝ get JS to display a notice
⍝ type   = 1 (info), 2=success, 3=error
⍝ content= message
⍝ opts   = an options namespace
      color←type⊃'blue' 'green' 'yellow'
      icon←#.HtmlElement.New _.Icon(type⊃'fa-info-circle' 'fa-check' 'fa-exclamation-triangle')
      options←⎕NS''
      :If 2=⎕NC'opts'
          options.(autoClose closeButton color)←opts defaultArgs 10000 _true color
      :ElseIf 9=⎕NC'opts'
          options←opts
      :EndIf
      jb←New #._.jBox'Notice'(icon,'&nbsp;',content)
      jb.Options←options
      jb.ScriptOptions←0 0 0
      'color'jb.SetIfNotSet color
      'attributes.x'jb.SetIfNotSet'right'
      'attributes.y'jb.SetIfNotSet'bottom'
      'offset.x'jb.SetIfNotSet 30
      'offset.y'jb.SetIfNotSet 10
      'autoClose'jb.SetIfNotSet 10000
      'closeOnClick'jb.SetIfNotSet _false
      'closeButton'jb.SetIfNotSet _true
      'width'jb.SetIfNotSet 550
      R←jb.Render
    ∇

:EndClass
