﻿:Class tsPage  : tsBase
    :field public ⍙⍙SESSION⍙⍙←42
    :field public UseLanguageBar←0  ⍝ does the page need language-bar in Help-Menu?
    :field public hasLB←0    ⍝ set to 1 if LB gets enabled
    :field public api_ns
    :field public hasRecalc←0
       ⍝ hasRecalc=0: no Recalc
       ⍝ else: sum of bit-flags:
       ⍝           1: attach click-event to Recalc-Btn
       ⍝           2: add Button (otherwise page may do it, like SumWiz, for example)
       ⍝           4: F9 triggers recalc
       ⍝ combine bits as neccessary
    getBits←{⍺←¯1 ⋄ z←⌽((⍺⌈⌈⍵*.5)⍴2)⊤⍵ ⋄ ⍺<0:z⋄⍺⊃z}  ⍝ get bits from a flag
    :field public selist←↑('at the top' '1')('at the bottom' '2')   ⍝ used in Preferences-dialogue

    ⍝ This is a template that adds a consistent header to all pages based on it
    ⎕ml←⎕io←1




    ∇ {r}←Wrap;lang;header;home;menu;nul;nav;ll;dd;ud1;ctl;ud;ul;tabs;mh;mc;td;lic;ser;p;licType;os;version;dsNames
      :Access Public
      Use'jBox'
      Use'awesomplete'
      Use'⍎/assets/tamstat.js'
      Use'⍕/jBox/themes/TooltipDark.css'
      Use'clipboard.js' ⍝ because we may have a log
      Head.Insert _.script'var timerStart=Date.now();'
      UseWaitingPopup←1 ⍝ is needed when we change dataset
     
      ('#currDS type=hidden value=',currDS)Add _.Input
     
⍝ continue PostConf
      td←'#uploader .modal role=dialog data-backdrop=true data-keyboard=true data-focus=false data-show=false tabindex=-1'Add _.div
      mc←('.modal-dialog .modal-dialog-centered .modal-dialog-scrollable'td.Add _.div).Add _.div'' '.modal-content'
      mh←mc.Add _.div'' '.modal-header'
      '.modal-title'mh.Add _.h3'File Upload'
     
      ud←('.modal-body'mc.Add _.div).Add _.div
      f←'#uploadForm'ud.Add _.Form   ⍝ add a form specific for upload
     ⍝ ('name="uploadFile"',Multiple/' multiple')f.Add _.Input'file' ⍝ add an input type="file"
      f.Add _.button'Upload!'  ⍝ <button> by default will do a submit
      f.Add _.script ScriptFollows
⍝ var form = document.getElementById('uploadForm');
⍝ form.onsubmit = function() {
⍝ var formData = new FormData(form);
⍝ formData.append("_callback","UploadCallback") // callback-fn
⍝  var xhr = new XMLHttpRequest();
⍝  xhr.open('POST', form.getAttribute('action'), true);
⍝  xhr.setRequestHeader("isAPLJax",true); // fake an APLJax-Call!
⍝  xhr.send(formData);
⍝  return false; // To avoid actual submission of the form
⍝}
      ud←('.modal-footer')mc.Add _.div
      '.btn .btn-primary onclick=$("#about").modal("hide");'ud.Add _.Button'Ok'
     
     
⍝ Downloader asks for a filename
      td←'#downloader .modal role=dialog data-backdrop=true data-keyboard=true data-focus=false data-show=false tabindex=-1'Add _.div
      mc←('.modal-dialog .modal-lg .modal-dialog-centered .modal-dialog-scrollable'td.Add _.div).Add _.div'' '.modal-content'
      mh←mc.Add _.div'' '.modal-header'
      '#filesave_title .modal-title'mh.Add _.h3'Save file'
      ud←('.modal-body'mc.Add _.div).Add _.div
      r1←'.form onsubmit="return false;"'ud.Add _.form
      '#filesave_content type=hidden'r1.Add _.Input   ⍝ potentially unneccessary waste of space... - not sure if we need this
      '#filesave_info type=hidden'r1.Add _.Input
      '#filesave_opts type=hidden'r1.Add _.Input ⍝ might be used on commandline (although we do not have any options yet)
     ⍝#filesave_info
     ⍝[1]=what?
     ⍝  1: Current Dataset to csv (no content needed)
     ⍝following "/ns/": namespace (instead of ref)
      ⍝ TODO: should differentiate between download and saving locally - future extension (postconf)
      '#filesave_prompt'r1.Add _.p
      r2←r1.Add _.div
      fs←('#filesave_name .form-control type=text  onkeyup=onEnterClick(event,"filesave_button") value=""')r2.Add _.Input
      t←'.custom-control .custom-checkbox .d-none #filesaveOverwritePrompt'r2.Add _.div
      '.custom-control-input type=checkbox id=filesave_overwrite  onkeyup=onEnterClick(event,"filesave_button")'t.Add _.Input
      t.Add _.label'<i class="fas fa-exclamation-triangle text-warning"></i> Confirm overwrite of existing file' '.custom-control-label for=filesave_overwrite .font-weight-bold style=padding-top:.5em;'
      fs.On'change' 'Check_filesave_name'
      ud←('.modal-footer')mc.Add _.div
      ('.btn .btn-primary type=button .ml-6  #filesave_button'ud.Add _.Button'Save').On'click' 'HandleDownloadOrSave'
     
     
⍝ Settings.Dialog...
      td←'#settings .modal role=dialog data-backdrop=true data-keyboard=true data-focus=false data-show=false tabindex=-1'Add _.div
      mc←('.modal-dialog .modal-dialog-centered .modal-dialog-scrollable'td.Add _.div).Add _.div'' '.modal-content'
      mh←mc.Add _.div'' '.modal-header'
      '.modal-title'mh.Add _.h3'Settings'
     
      ud←('.modal-body'mc.Add _.div).Add _.div
      ul←'.nav .nav-tabs role=tablist'ud.Add _.ul
      'general'{('.nav-item'ul.Add _.li).Add _.a ⍵('.nav-link .active data-toggle=tab href=#',⍺,' role=tab aria-controls=',⍺)}'General'
      'session'{('.nav-item'ul.Add _.li).Add _.a ⍵('.nav-link  data-toggle=tab href=#',⍺,' role=tab aria-controls=',⍺)}'Session'
      'sumwiz'{('.nav-item'ul.Add _.li).Add _.a ⍵('.nav-link  data-toggle=tab href=#',⍺,' role=tab aria-controls=',⍺)}'Summary Wizard'
     
      tabs←'.tab-content'ud.Add _.form
     
     ⍝------------- General ----------------------------------------------
      ud←'.tab-pane .fade .show .active #general role=tabpanel aria-labelledby=general-tab'tabs.Add _.div
      ud1←'.form-inline'ud.Add _.div
      'for="decp" .col-9 .text-right .justify-content-start'ud1.Add _.label'Decimals for Percentages'
      ('.col-3 #decp type="text" .text-right data-decimal-places=0 .autoNumeric data-min-value=0 data-max-value=10 .form-control value=',⍕#.Prefs.decimalsP)ud1.Add _.Input
      ud1←'.form-inline'ud.Add _.div
      'for="decg" .col-9 .text-right .justify-content-start'ud1.Add _.label'Decimals for other numbers'
      ('.col-3 #decg type="text" .text-right data-decimal-places=0 .autoNumeric data-min-value=0 data-max-value=10 .form-control value=',⍕#.Prefs.decimalsO)ud1.Add _.Input
     
      ud1←'.form-inline .w-100'ud.Add _.div
      'for=appearance .col-9  .justify-content-start'ud1.Add _.label'Appearance'
      styles←'Web' 'Desktop'
      ctl←'#appearance .form-control .col-3'ud1.Add _.Select styles
      ctl.Selected←styles⍳#.Strings.nocase⊂#.Prefs.menuStyle
     
      ud1←'.form-inline .w-100'ud.Add _.div
      'for=theme .col-9  .justify-content-start'ud1.Add _.label'Theme'
      styles←(⊂'none'),('bootstrap-([a-zA-Z]*)\.min\.css'⎕S'\1')⊃0(⎕NINFO⍠'Wildcard' 1)(#.Boot.ms.Config.((Virtual.alias⍳⊂'tsBootstrap4')⊃Virtual.path)),'bootstrap-*.min.css'
      ctl←'#theme .form-control .col-3'ud1.Add _.Select styles
      ctl.Selected←styles⍳⊂#.Prefs.theme
     
      ud1←'.form-check .form-check-inline .w-100'ud.Add _.div
      ud1.Add _.label'Enable R-Interface' '.form-check-label for=enableR .col-9  .justify-content-start'
      ('.form-check-input type=checkbox id=enableR name=enableR .col-3',(_true≡#.Prefs.enableR)/' checked=checked')ud1.Add _.input
     
     ⍝---------- Session --------------------------------
      ud←'.tab-pane .fade #session role=tabpanel aria-labelledby=session-tab'tabs.Add _.div
      ud1←'.form-inline'ud.Add _.div
      'for=setd .col-6  .justify-content-start'ud1.Add _.label'New log-entries are added'
      ctl←'#setd .form-control .col-6'ud1.Add _.Select selist
      ctl.Selected←1+_true≡#.Prefs.Session.topdown
     
      :If 'Dev'≡3↑4⊃# ⎕WG'APLVersion'  ⍝ disabling trapping only supported with "real" interpreter
          ud1←'.form-check .form-check-inline .w-100'ud.Add _.div
          ud1.Add _.label'Trap Errors' '.form-check-label for=enableR .col-6  .justify-content-start'
          ('.form-check-input type=checkbox id=trap name=trap .col-6',(_true≡#.Prefs.Session.TrapErrors)/' checked=checked')ud1.Add _.input
      :EndIf
     
      ud1←'.form-inline'ud.Add _.div
      'for="decse" .col-9 .text-right .justify-content-start'ud1.Add _.label'Decimals to use in the session'
      ('.col-3 #decse type="text" .text-right data-decimal-places=0 .autoNumeric data-min-value=0 data-max-value=10 .form-control value=',⍕#.Prefs.Session.decimals)ud1.Add _.Input
     
     ⍝------------ SumWiz -----------------------------
      ud←'.tab-pane .fade #sumwiz role=tabpanel aria-labelledby=sumwiz-tab'tabs.Add _.div
      ud1←'.form-check .form-check-inline .w-100'ud.Add _.div
      ud1.Add _.label'Column width (CSS)' '.form-check-label for=swcw .col-9  .justify-content-start'
      ('.form-check-input type=text .text-right id=swcw name=swcw .col-3 value=',#.Prefs.SumWiz.defColWidth_dt)ud1.Add _.input
      ud1←'.form-check .form-check-inline .w-100'ud.Add _.div
      'for="cols" .col-9 .justify-content-start'ud1.Add _.label'How many columns to show'
      ('.col-3 #cols type="text" .text-right data-decimal-places=0 .autoNumeric data-min-value=0 data-max-value=10 .form-control value=',⍕#.Prefs.SumWiz.showNrOfCols)ud1.Add _.Input
     
     
      ud←('.modal-footer')mc.Add _.div
      '.btn .btn-secondary onclick=$("#settings").modal("hide");'ud.Add _.Button'Cancel'
      ('.btn .btn-primary'ud.Add _.Button'Save changes').On'click' 'SaveSettings'
     
⍝ About.Dialog...
      td←'#about .modal role=dialog data-backdrop=true data-keyboard=true data-focus=false data-show=false tabindex=-1'Add _.div
      mc←('.modal-dialog .modal-dialog-centered .modal-dialog-scrollable'td.Add _.div).Add _.div'' '.modal-content'
      mh←mc.Add _.div'' '.modal-header'
      '.modal-title'mh.Add _.h3'About TamStat'
     
      ud←('.modal-body'mc.Add _.div).Add _.div
      ul←'.nav .nav-tabs role=tablist'ud.Add _.ul
      'Copyright'{('.nav-item'ul.Add _.li).Add _.a ⍵('.nav-link .active data-toggle=tab href=#',⍺,' role=tab aria-controls=',⍺)}'Copyright'
      'Environment'{('.nav-item'ul.Add _.li).Add _.a ⍵('.nav-link  data-toggle=tab href=#',⍺,' role=tab aria-controls=',⍺)}'Environment'
     
      tabs←'.tab-content'ud.Add _.div
     
     ⍝------------- (c) ----------------------------------------------
      ud←'.tab-pane .fade .show .active #Copyright role=tabpanel aria-labelledby=general-tab'tabs.Add _.div
      p←'<div class="text-center"><img src=/Styles/Images/LionTamer.png height=204 width=196>'
      p,←'<br /><b>TamStat ',#.Env.tsVersion,' &copy; 2024 by <a href="https://www.dyalog.com" target="_blank"  rel="noopener">Dyalog Ltd.</a> and Stephen Mansour.</b></div>'
      ud.Add #._.p p
     
      :If #.Env.lic=0
          ud.Add WrapFollowing'p'
      ⍝ Included Dyalog APL is licenced for non-commercial use only.
      ⍝
      ⍝ See <a href="shttp://www.dyalog.com" target=_new"  rel="noopener">www.dyalog.com</a> for more information.
      :EndIf
     
     
     ⍝------------- Environment ----------------------------------------------
      ud←'.tab-pane .fade  #Environment role=tabpanel aria-labelledby=general-tab'tabs.Add _.div
      t←'.table .table-small .table-striped  #InOutEnv'ud.Add _.table
      tr←t.Add #._.tr ⋄ tr.Add #._.td'OS' ⋄ tr.Add #._.td #.Env.os
      tr←t.Add #._.tr ⋄ tr.Add #._.td'Serial' ⋄ tr.Add #._.td #.Env.serial
      tr←t.Add #._.tr ⋄ tr.Add #._.td'Dyalog Version' ⋄ tr.Add #._.td #.Env.dyaVersion
      tr←t.Add #._.tr ⋄ tr.Add #._.td'.Net Version' ⋄ tr.Add #._.td #.Env.dotnetVersion
      tr←t.Add #._.tr ⋄ tr.Add #._.td'TS: Date' ⋄ tr.Add #._.td #.Env.tsDate
      tr←t.Add #._.tr ⋄ tr.Add #._.td'TS: Version' ⋄ tr.Add #._.td #.Env.tsVersion
      tr←t.Add #._.tr ⋄ tr.Add #._.td'TS: Data Folder' ⋄ tr.Add #._.td #.Env.dataFolder
      tr←t.Add #._.tr ⋄ tr.Add #._.td'DUI: Date' ⋄ tr.Add #._.td #.Env.msDate
      tr←t.Add #._.tr ⋄ tr.Add #._.td'DUI: Version' ⋄ tr.Add #._.td #.Env.msVersion
      tr←t.Add #._.tr ⋄ tr.Add #._.td'Commandline' ⋄ tr.Add #._.td(2 ⎕NQ'.' 'GetCommandLine')
      tr←t.Add #._.tr ⋄ tr.Add #._.td'WSID' ⋄ tr.Add #._.td ⎕WSID
      tr←t.Add #._.tr ⋄ tr.Add #._.td'maxws' ⋄ tr.Add #._.td #.Env.maxws
      tr←t.Add #._.tr ⋄ tr.Add #._.td'Server' ⋄ tr.Add #._.td{6::'N/A' ⋄ #.Boot.ms.Framework}⍬
      tr←t.Add #._.tr ⋄ tr.Add #._.td'tsMode' ⋄ tr.Add #._.td(((0 1 2)⍳#.Env.tsMode)⊃'?LW')   ⍝ unknown / local / web
      tr←t.Add #._.tr ⋄ tr.Add #._.td'AppRoot' ⋄ tr.Add #._.td #.Boot.AppRoot
      tr←t.Add #._.tr ⋄ tr.Add #._.td'Config.Debug' ⋄ tr.Add #._.td(⍕#.Boot.ms.Config.Debug)
      tr←t.Add #._.tr ⋄ tr.Add #._.td'Config.Production' ⋄ tr.Add #._.td(⍕#.Boot.ms.Config.Production)
      tr←t.Add #._.tr ⋄ tr.Add #._.td'Config.TrapErrors' ⋄ tr.Add #._.td(⍕#.Boot.ms.Config.TrapErrors)
      ll←'N/A'
      :Trap 0
          ll←⍕(SessionGet'Prefs').Session.TrapErrors
      :EndTrap
      tr←t.Add #._.tr ⋄ {tr.Add #._.td ⍵}¨'Prefs.TrapErrors'll
     
     
      ('#clpcpyEnv class="btn-xs float-right cursorHand clpbrdEnv" data-clipboard-target=#InOutEnv data-jbox-content="Copy table to clipboard"')ud.Add _.Button(#.HtmlElement.New #._.i'' '.far .fa-copy')
      OnLoad,←'AddClpCopy("Env",0);'
      ud←('.modal-footer')mc.Add _.div
      '.btn .btn-primary onclick=$("#about").modal("hide");'ud.Add _.Button'Ok'
     
      :If 1⊃,ShowExpression
          ll←ScriptFollows
        ⍝ <div class="input-group mb-3 w-100" id="divExpr">
        ⍝  <div class="input-group-prepend">
        ⍝   <span class="input-group-text" id="lblExpr">Expression</span>
        ⍝  </div>
        ⍝  <input type="text" class="form-control" id="ipExpr" name="ipExpr" onkeyup="onKeyupExpr(event);" ondblclick="$('#ipExpr').trigger('calc');"/>
     
     
          list←(userNS.DATA⍎currDS).⎕NL-2
        ⍝ build autocomplete-list
          list,←{(∊~(1↑¨⍵)∊⎕A)/⍵}#.TamStat.⎕NL-3  ⍝ only functions with lowercase-name (until we find a better mechanism to select candidates)
          list,←#.tsConsoleCommands.⎕NL-3
          list←list,¨','
          OnLoad,←' awesomepleteList = "',(¯1↓∊list),'"; awesomepleteOnIpExpr(); '
          :If 2 getBits hasRecalc
              ll,←ScriptFollows
        ⍝   <button data-jbox-content="Recalc. Keyboard-Shortcut: <key>F9</key>" class="btn btn-primary" id="btnRecalc"><i class="far fa-play-circle"></i></button>
          :EndIf
          :If 1 getBits hasRecalc
              Body.Add _.Handler'#btnRecalc' 'click' 'cbRecalc'
          :EndIf
          Body.Add _.Handler'body' 'onToggleLB' 'onToggleLB'
     
     
          :If |ShowExpression[3]
              ll,←ScriptFollows
            ⍝  <div class="input-group-append input-group-text border bg-info text-light" id="cntRes">
            ⍝  <span id="lbExpr" class="ml-3 mr-3">Result:</span><span id="resExpr"></span>
            ⍝  </div>
              :If ShowExpression[3]<0 ⋄ OnLoad,←'$("#cntRes").hide();' ⋄ :EndIf
          :EndIf
          :If ShowExpression[2]
              ll,←ScriptFollows
            ⍝  <div class="input-group-append input-group-text">
            ⍝   <input type="checkbox" aria-label="Show output" disabled="disabled" id="cb_output"/>&nbsp;&nbsp;Show Output
            ⍝  </div>
          :EndIf
          ll,←'</div>'
     
          :If ~EditExpression
              ll←ll #.Strings.subst'name="ipExpr"' 'name="ipExpr" readonly=readonly'
          :Else
              Add _.Handler'#ipExpr' 'calc' 'OnCalcExpression'
          :EndIf
          Insert ll
      :EndIf
      Insert topnav
      OnLoad,←'jBoxTooltip=new jBox("Tooltip",{theme: "TooltipDark",id:"jBoxTooltip",getTitle: "data-jbox-title", getContent: "data-jbox-content",attach: "[data-jbox-content]",reload:"strict"}).attach();'
      :If hasLB
      :AndIf UseLanguageBar
          OnLoad,←'toggleAPLlb();'
          hasLB←~hasLB  ⍝ because it will be inverted again when the event is signalled...
      :EndIf
⍝ performance-testing:
⍝Body.Add _.script ScriptFollows
⍝ $(document).ready(function(){var diff=Date.now()-timerStart; $("#contentblock").append("<br>doc.ready after: "+diff+"</br>");});
⍝ $(window).load(function(){var diff=Date.now()-timerStart; $("#contentblock").append("win.load after: "+diff);});
     
      :If 3 getBits hasRecalc
          OnLoad,←1 SetCalcButton 1
      :ElseIf hasRecalc=0
          OnLoad,←1 SetCalcButton 0
      :EndIf
     
     
    ⍝ wrap the content of the body element in two divs
      '#contentblock .container-fluid'Body.Push _.div
     
    ⍝ call the base class Wrap function
      r←⎕BASE.Wrap
    ∇

    ∇ R←onToggleLB
      :Access public
      R←''
      hasLB←~hasLB
      ⎕←'onToggeleLB: hasLB=',hasLB
    ∇


    ∇ R←lid SetSubNav rarg;c;i;tit;url;li;id;list;atts1;atts2;ctl;items;deflt;cap;defaults
      :Access public
    ⍝ matrix with r x 3 cols:
    ⍝ [;1] title (or: tit id)
    ⍝ [;2] atts for _.li
    ⍝ [;3] atts for _.a (incl. href=..!)
    ⍝ [;4] tag (to avoid the li's...)
    ⍝ R: JS to update submenu
     
     
      (items deflt cap)←3↑({2=|≡⍵:⊂⍵ ⋄ ⊆⍵}rarg),(⊂''),⊂'Dataset',(Prefs.menuStyle≡'web')/':'
      c←1 ⍝ Counter
      R←⎕NEW #.HtmlElement
      list←''
      defaults←'' '.nav-item' '.nav-link'_.a
      :If lid≡'ddMenu'
          :If Prefs.menuStyle≡'web'
              defaults[4]←_.option
              defaults[3]←⊂''
          :Else
              defaults[4]←_.a
              defaults[3]←⊂'.dropdown-item href=#'
          :EndIf
          deflt←,SessionGet'currDS'
          :If ~(⊂deflt)∊{1⊃,⊆⍵}¨items[;1]
              deflt←1⊃⊆items[;1]
          :EndIf
          items←↓items
          :If 'Dataset'≡cap
          ⍝:andif
              items,←⊂''⎕NULL'.dropdown-divider'_.div
              items,←⊂'Edit current dataset'⎕NULL'#mnEditDataset .dropdown-item href=/EditDataset'
          :EndIf
      :Else
          items←↓items
      :EndIf
      :For i :In items
          (tit atts1 atts2 ctl)←i defaultArgs defaults ⋄ c+←1
          (tit id)←2↑(⊆tit),⊂('subnav',⍕c)
          :If atts1≡⎕NULL ⋄ li←⎕NEW #.HtmlElement ⋄ :Else ⋄ li←('#',id,' ',atts1)New _.li ⋄ :EndIf
          :If Prefs.menuStyle≡#.Strings.nocase'desktop'
              :If lid≡'men2'
                  atts2,←' .pt-0 .pb-0'
              :ElseIf lid≡'ddMenu'
                  :If deflt≡tit ⋄ atts2,←' .active' ⋄ :EndIf
                  :If ~'#'∊{(~0,¯1↓'=#'⍷⍵)/⍵}∊atts2 ⍝ if we haven't assigned an id yet (dfn used to avoid counting href=# as an id!)
                      atts2,←' #',tit               ⍝ name of dataset is used as id (in desktop-mode) so that _what is same as in web-mode
                  :EndIf
              :EndIf
          :EndIf
          :If lid≡'ddMenu'
          :AndIf ~∨/'onclick'⍷atts2
              atts2,←' onclick="$(\"#wpProc\").show();return false;"'
          :EndIf
          atts2 li.Add ctl tit
          R.Add li
      :EndFor
     
    ⍝ replace inner html of ul with list
      R←'$("#',lid,'").html( ''',(R.Render~⎕UCS 10 13),''');'
      :If lid≡'ddMenu'
          :If Prefs.menuStyle≡'web'  ⍝ disappears on desktop after selecting an item...
              R,←'$("#ddTopLeft").collapse("show");'
          :EndIf
          :If 0<≢∊cap
              R,←'$("#ddTitle").text("',cap,'");'
          :EndIf
          :If 0<≢∊deflt
              :If Prefs.menuStyle≡'web'
                  R,←'$("#ddMenu").val("',(∊deflt),'");'
              :Else
              :EndIf
          :EndIf
      :EndIf
    ∇

    ∇ R←SetExpression ex
      :Access public
      :If ex≡'' ⋄ ex←'' '' ⋄ :EndIf
      R←Execute'#ipExpr'_JSS.Val ex
    ∇

    ∇ {R}←{root}EvalExpression ex;⍙⍙R⍙⍙;⍙⍙msg⍙⍙;⍙⍙err⍙⍙;⍙⍙trap⍙⍙;⍙⍙SESSION⍙⍙;REQ;ref∆;ex∆;∆P;⎕IO;⎕ML
    ⍝ RR[1]: error-code 0 (no error,otherwise errorcode)
    ⍝ RR[2]: message (error-msg etc.)
    ⍝ RR[3]: result (if [1]=0)
    ⍝ take care of #. , ⎕ etc.!
    ⍝ root:
    ⍝   1=execute in userNS
    ⍝   2=execute API-Call, ex=Event OR api_ns!
    ⍝  ¯2=same as before, but ⎕SIGNAL Errors and do not bother to return anything
    ⍝   otherwise in currDS
    ⍝
      :Access public
      :If 2=⎕NC'root'
          :If root≡1
              ref∆←userNS.DATA
          :ElseIf 2≡|root
              :If 326=⎕DR ex       ⍝ if ex looks like a ref
              :AndIf 2≠⎕NC'ex'   ⍝ and if it's not a nested var
                  api_ns←ex
              :Else
⍝                  °°°
                  :If {6::1 ⋄ 0⊣⍎⍵}'api_ns'
                      api_ns←⎕NS''
                     ⍝ ⎕←'EvalExpression assigned value to api_ns'
                  :EndIf
                  api_ns.Event←1⊃ex
                  :If 'Init'≡1⊃ex
                      api_ns.api_fn←2⊃ex
                      api_ns.currDS←currDS
                  :EndIf
                  api_ns.UserSpace←userNS.DATA⍎currDS
              :EndIf
              #.ref∆←ref∆←api_ns  ⍝ #.ref∆ needed so that the cpde has a chance to execute within SafeExecute...
              ⍝ ex←'#.TamStat.ConfIntAPI ⎕this'
              ex←api_ns.api_fn,' #.ref∆'
          :ElseIf 326=⎕DR root
              ref∆←root
          :Else
              ref∆←userNS.DATA⍎currDS
          :EndIf
      :Else ⋄ ref∆←userNS.DATA⍎currDS ⋄ root←999
      :EndIf
      ⍙⍙SESSION⍙⍙←_Request.Session ⋄ REQ←_Request
      ⍙⍙trap⍙⍙←⍙⍙SESSION⍙⍙.⍙⍙trap⍙⍙
      ref∆.⍙⍙SESSION⍙⍙←_Request.Session
     
      :If 'Use'≢3↑#.Strings.deb ex ⍝ only be smart if we're not dealing with a Use-cmd
      :AndIf ~root∊¯2 2  ⍝ and're not dealing with the API
          :Repeat ⋄ ex←('##\.##\.'⎕R'##.')ex∆←ex ⋄ :Until ex≡ex∆  ⍝ handle sillyness
          :Repeat ⋄ ex←('#\.#\.'⎕R'#.')ex∆←ex ⋄ :Until ex≡ex∆  ⍝ handle sillyness
          :If ref∆≡userNS.DATA ⍝ we're in root...
              ex←('##.'⎕R'')ex ⍝ no need to go into parent-space
              ex←('#.'⎕R'')ex  ⍝ and no need for absolute adresses
          :Else  ⍝ we're one level down into a dataset...so # or ## can both be translated
              ex←('##\.'⎕R'#∆.')ex  ⍝ protect "##.xx" against replacement of just "#."
              ex←('#\.'⎕R'##.')ex
              ex←('#∆\.'⎕R'##.')ex
          :EndIf
      :EndIf
      ex←('⍝.*'⎕R'')ex ⍝ avoid issues created by stuff in comments (either valid &-codes or hacks! ;-)
      :If 'DETRAP'≡6↑#.Strings.deb ex
          R←0 '' 'Error trapping disabled temporarily, use RETRAP to enable it again.'
          →_Request.Session.⍙⍙trap⍙⍙←0
      :ElseIf 'RETRAP'≡6↑#.Strings.deb ex
          R←0 '' 'Error trapping enabled temporarily, use DETRAP to disable it again.'
          →~_Request.Session.⍙⍙trap⍙⍙←1
      :EndIf
      ref∆.(⎕IO ⎕ML)←1
      ∆P←⎕PATH
      :If ⍙⍙trap⍙⍙
      ⍝ What can go wrong?
      ⍝ 1. Error in User-Statement (Typo etc.);                     → show the message
      ⍝ 2. Filtering throws an error (Illegal code etc. detected)   → show the message
      ⍝ 3. APL-Error in the executed code                           → create a DrA-File and show info about that
          R←ref∆{
              ⎕PATH←'#.ExtOut #.TamStat  #.tsConsoleCommands' ⍝ assumption: whosoever does something in userNS will take care of ⎕path, too. (index.mipage will be interesting!)
              0::1({⍵.Message≡'':⍵.EM ⋄ ⍵.Message}⎕DMX)⍬
              85::0 ''⍬
              11::0 ''(1 ⍺.(85⌶)⍵)
              0''(0 ⍺.(85⌶)⍵)
          }ex
      :Else
      ⍝i600←600⌶1
          R←ref∆{
              ⎕PATH←'#.ExtOut #.TamStat  #.tsConsoleCommands' ⍝ assumption: whosoever does something in userNS will take care of ⎕path, too. (index.mipage will be interesting!)
              85::0 ''⍬
              0''(0 ⍺.(85⌶)⍵)
          }ex
         ⍝ {}600⌶i600
      :EndIf
      ⎕PATH←∆P
     
     
      ref∆.⎕EX'⍙⍙SESSION⍙⍙'
      :If root≡¯2
      :AndIf R[1]=0
          R←⍳0
      :ElseIf root≡¯2
                    ⍝ error!
          ⎕DMX
          R
⍝          600⌶1
⍝          ∘∘∘
⍝          600⌶0
          (∊(2⊃R),¨⎕UCS 13)⎕SIGNAL 137  ⍝ errno may need adjustment
      :EndIf
    ∇

    ∇ R←Handle_ddSelect;oldDS
      :Access public
    ⍝ _value = new dataset
    ⍝ currDS = old dataset
      :If 'EditDataset'≡2↓_what ⋄ R←Execute'window.location.href="',(_Request.GetHeader'origin'),'/EditDataset";'
      :ElseIf 'SaveDataset'≡2↓_what ⋄ R←Execute'SaveDataset("',(userNS.DATA⍎currDS)._meta._Filename,'");'
      :Else
          oldDS←currDS
          :If _value≡''
          :AndIf (⊂_what)∊userNS.DATA.⎕NL ¯9
              _value←_what
          :EndIf
          currDS←_value
          ref←userNS.DATA⍎currDS
          _Request.Session.(userNS currDS)←userNS currDS
          ⍝⎕←'Handle_ddSelect, ref points to currDS=',currDS
          R←⍳0
          :If Prefs.menuStyle≡#.Strings.nocase'desktop'
              R,←Execute('#',oldDS)_JSS.RemoveClass'active'
              R,←Execute('#',_value)_JSS.AddClass'active'
          :EndIf
          R,←Handle_ddSelectEnd
      :EndIf
    ∇



    ∇ nav←topnav;fl;i;lcol;d2;h;ul;ll;dd;menRight;btn;r
      menRight←0
      :Select #.Strings.lc Prefs.menuStyle
      :Case 'web'
          menRight←1
          'style'Body.Set'padding-top: 135px;' ⍝ for sticky nav!
  ⍝ === Web-style navigation
          nav←'#topnav .navbar .navbar-expand-md .navbar-dark .bg-dark .align-items-stretch .w-100 .fixed-top'New _.div
          i←d1←'.d-flex .align-items-stretch'nav.Add _.div
     
          :If _Request.Page≢'/index.mipage'
              i←'href="/"  title="Home (Commandline)"'d1.Add _.a
          :EndIf
          i.Add _.img'src=/Styles/Images/LionTamer.png width=102 height=98 #logo .nav-brand'
          lcol←'.flex-column .align-top .ml-2'nav.Add _.div
          lcol.Add _.span'TamStat' '.navbar-text .navbar-flex .pt-0 .pb-0 .tstext #tsTitle'
          dd←'.flex-column .align-items-start .collapse #ddTopLeft'lcol.Add _.div
          '#ddTitle .text-light'dd.Add _.span'Dataset:'
          '#ddMenu .form-control .bg-dark .text-light'dd.Add _.select
          d2←'#navbarCollapse .collapse .navbar-collapse .flex-column .align-items-end .ml-lg-2'nav.Add _.div
          h←nav.Add _.Handler'#ddMenu' 'change' 'Handle_ddSelect'
          ul←'.navbar-nav #men1'd2.Add _.ul
          '.navbar-nav #men2 .mt-auto .mb-0'd2.Add _.ul
⍝      ll←'Files'{ll←('.nav-item .dropdown',(∨/⍵⍷#.Strings.lc _Request.Page)/' .active')ul.Add _.li ⋄ nul←'.nav-link .pt-0 .dropdown-toggle data-toggle=dropdown id=filemenu role=button aria-haspopup=true aria-expanded=false'll.Add _.a ⍺('href=#') ⋄ ll}'files'
⍝      dd←'.dropdown-menu aria-labelledby=filemenu'll.Add _.div
⍝      dd.Add _.a'Load' '.dropdown-item href=# onclick="DoPost(''/files'',{action: ''load''});"'
⍝      '.dropdown-divider'dd.Add _.div
⍝      dd.Add _.a'Exit'('.dropdown-item href=# onclick="alert(',ScriptFollows,');"')
    ⍝ '*** Work in progress! ***\n\n Unfortunately Windows cannot be closed in Browser (JS can only closes popups it created), but events should enable us to detect environment and act accordingly!'
    ⍝ 1) if executed in Browser: do not even show that option!
    ⍝ 2) if running in WC2: trigger event or ask for specific URL to close! (sort out with BB)
     
     
     
      :Case 'desktop'
          'style'Body.Set'padding-top: 4em;' ⍝ for sticky nav! (was 55pc, but I guess em will be more responsive)
     ⍝ === Desktop-menu
          nav←'#topnav .navbar .navbar-expand-md .navbar-dark .bg-dark .align-items-stretch .w-100 .fixed-top .py-0'New _.nav
          ⍝nav.Add _.span'TamStat' '.navbar-text .navbar-flex .pt-0 .pb-0 .tstext #tsTitle style=margin-top:-6px;margin-bottom:-6px;padding-right:2em;'
        ⍝   nav.Add _.span'TamStat' '.navbar-text .navbar-flex .tstext #tsTitle'
          nav.Add _.a'TamStat' '.navbar-text .navbar-flex .tstext #tsTitle href=/ title=Home'
          btn←'.navbar-toggler type=button data-toggle=collapse data-target="#m1nv"'nav.Add _.button
          '.navbar-toggler-icon'btn.Add _.span
          ul←'.navbar-nav #men1'('.collapse .navbar-collapse #m1nv'nav.Add _.div).Add _.ul
          ⍝ul←'.navbar-nav #men1'nav.Add _.ul
          r←'.nav-item .dropdown #ddTopLeft 'ul.Add _.li
          '.nav-link .dropdown-toggle data-toggle=dropdown href=# .pt-0 .pb-0 #ddTitle'r.Add _.a'Dataset'
          '#ddMenu .dropdown-menu aria-labelledby=ddTopLeft'r.Add _.div
          h←nav.Add _.Handler'#ddMenu' 'click' 'Handle_ddSelect'
          '.navbar-nav #men2 .ml-auto .mt-auto .pb-2'nav.Add _.ul
      :EndSelect
     
      ll←'File'{r←('.nav-item .dropdown')ul.Insert _.li ⋄ nul←'.nav-link .pt-0 .dropdown-toggle data-toggle=dropdown id=men-file role=button aria-haspopup=true aria-expanded=false'r.Add _.a ⍺('href=#') ⋄ r}''
      dd←'.dropdown-menu .dropdown-menu aria-labelledby=men-file'll.Add _.div
      :If 2=(userNS.DATA⍎currDS)._meta.⎕NC'_Filename'
          '#mnSaveDataset'dd.Add _.a'Save dataset'(' .dropdown-item href=# onclick="SaveDataset(''',(userNS.DATA⍎currDS)._meta._Filename,''');"')
      :EndIf
      :If {6::0 ⋄ 'HRServer'≡⍎⍵}'#.Boot.ms.Framework' ⍝ if we're running with DUI
          '.dropdown-divider'dd.Add _.div
          (dd.Add _.a'Open Data Folder' '.dropdown-item').On'click' 'OpenDataFolder'
          (dd.Add _.a'Exit' '.dropdown-item onclick=off()').On'click' 'OFF'
      :EndIf
     
     
      ll←'Data'{r←('.nav-item .dropdown')ul.Add _.li ⋄ nul←'.nav-link .pt-0 .dropdown-toggle data-toggle=dropdown id=men-data role=button aria-haspopup=true aria-expanded=false'r.Add _.a ⍺('href=#') ⋄ r}''
      dd←'.dropdown-menu .dropdown-menu aria-labelledby=men-data'll.Add _.div
      '#index'dd.Add _.a'Session' '.dropdown-item href=/index'
      '#Select'dd.Add _.a'Select' '.dropdown-item href=/Select'
     
      ll←'Descriptive'{r←('.nav-item .dropdown')ul.Add _.li ⋄ nul←'.nav-link .pt-0 .dropdown-toggle data-toggle=dropdown id=men-desc role=button aria-haspopup=true aria-expanded=false'r.Add _.a ⍺('href=#') ⋄ r}''
      dd←'.dropdown-menu .dropdown-menu aria-labelledby=men-desc'll.Add _.div
      '#ChartWiz'dd.Add _.a'Graphics' '.dropdown-item href=/ChartWiz'
      '#SumWiz'dd.Add _.a'Summary Wizard' '.dropdown-item href=/SumWiz'
     
      ll←'Probability'{r←('.nav-item .dropdown')ul.Add _.li ⋄ nul←'.nav-link .pt-0 .dropdown-toggle data-toggle=dropdown id=men-prob role=button aria-haspopup=true aria-expanded=false'r.Add _.a ⍺('href=#') ⋄ r}''
      dd←'.dropdown-menu .dropdown-menu aria-labelledby=men-prob'll.Add _.div
      '#ProbWiz'dd.Add _.a'Probability Wizard' '.dropdown-item href=/ProbWiz'
      '#Bayes'dd.Add _.a'Bayesian Statistics' '.dropdown-item href=/Bayes'
      '#DistWiz'dd.Add _.a'Distribution Wizard' '.dropdown-item href=/DistWiz'
      '#DistWiz_Tables'dd.Add _.a'Distribution Tables' '.dropdown-item href=/DistWiz?tab=Tables'
     
     
      ll←'Inference'{r←('.nav-item .dropdown')ul.Add _.li ⋄ nul←'.nav-link .pt-0 .dropdown-toggle data-toggle=dropdown id=men-inf role=button aria-haspopup=true aria-expanded=false'r.Add _.a ⍺('href=#') ⋄ r}''
      dd←'.dropdown-menu .dropdown-menu-left aria-labelledby=men-inf'll.Add _.div
      '#ConfIntWiz'dd.Add _.a'Confidence Intervals' '.dropdown-item href=/ConfIntWiz'
      '#HypoWiz'dd.Add _.a'Hypothesis Test' '.dropdown-item href=/HypoWiz'
      '#SampleSizeWiz'dd.Add _.a'Sample Size' '.dropdown-item href=/SampleSizeWiz'
     
     
      ll←'Advanced'{r←('.nav-item .dropdown')ul.Add _.li ⋄ nul←'.nav-link .pt-0 .dropdown-toggle data-toggle=dropdown id=men-adv role=button aria-haspopup=true aria-expanded=false'r.Add _.a ⍺('href=#') ⋄ r}''
      dd←('.dropdown-menu',(menRight/' .dropdown-menu-right '),'.dropdown-menu aria-labelledby=men-adv')ll.Add _.div
      '#RegWiz_uv'dd.Add _.a'Univariate Regression' '.dropdown-item href=/RegWiz_uv'
      '#RegWiz_mv'dd.Add _.a'Multivariate Regression' '.dropdown-item href=/RegWiz_mv'
      '#ChiSquareWiz'dd.Add _.a'Chi Square Tests' '.dropdown-item href=/ChiSquareWiz'
      '#AnovaWiz'dd.Add _.a'Anova' '.dropdown-item href=/AnovaWiz'
      '.dropdown-divider'dd.Add _.div
      '#mn_settings'dd.Add _.a'Settings' '.dropdown-item onclick=$("#settings").modal("show");'
     
     
      ll←'Help'{r←('.nav-item .dropdown')ul.Add _.li ⋄ nul←'.nav-link .pt-0  .pb-0 .dropdown-toggle data-toggle=dropdown id=helpmenu role=button aria-haspopup=true aria-expanded=false'r.Add _.a ⍺('href=#') ⋄ r}''
      dd←('.dropdown-menu',(menRight/' .dropdown-menu-right'),' aria-labelledby=helpmenu')ll.Add _.div
      :If 0<≢2 ⎕NQ'.' 'GetEnvironment' 'TamStat_DEV'
      :AndIf #.Env.tsMode=1
          ('#ShowDevToola'dd.Add _.a'Show DevTools' '.dropdown-item onlick="return false;"').On'click' 'ShowDevTools'
      :EndIf
      :If ⎕NEXISTS #.Boot.AppRoot,1↓fl←'/assets/',(2⊃⎕NPARTS _Request.Page),'.help.js'
          Add _.Script''fl
          '#tsHelp'dd.Add _.a'Feature-Help' '.dropdown-item href=# onclick=tsHelp();'
      :EndIf
      :If ⎕NEXISTS #.Boot.AppRoot,'Documentation/TamStatUserGuide.pdf'
          :If 9=#.Boot.ms.Config.⎕NC'HRServer'   ⍝ running under DUI - so probably a local install
              ('#tsDoc'dd.Add _.a'<i class="fa-solid fa-file-pdf"></i>&nbsp;Help' '.dropdown-item onclick="return false;"').On'click' 'OpenHelp'
          :Else
              '#tsDoc'dd.Add _.a'<i class="fa-solid fa-file-pdf"></i>&nbsp;Help' '.dropdown-item target=_blank href=/Documentation/TamStatUserGuide.pdf'
          :EndIf
      :EndIf
    ⍝   :if {0::1 ⋄ 0=≢⍵._Renderer.⎕NL-⍳9}#.Boot.ms  ⍝ only offer web-link if opened in browser - currently do not have methods in DUI to deal with multiple renderers...
      '#website'dd.Add _.a'Website' '.dropdown-item href=https://tamstat.dyalog.com target=_blank rel=noopener'
    ⍝   :endif
      :If UseLanguageBar
          '.dropdown-divider'dd.Add _.div
          '#mentoggleLB data-lb=0 .dropdown-item href=# onclick=toggleAPLlb();'dd.Add _.a'Show APL Language Bar'
      :EndIf
      '#about_ts'dd.Add _.a'About TamStat' '.dropdown-item href=# onclick=$("#about").modal("show");'
     
    ∇


    ∇ R←ShowDevTools
      :Access public
      ⍝ should be a but smarter...
      (1⊃#.Boot.ms._Renderers).ShowDevTools 1
      R←''
    ∇

    ∇ R←OpenHelp
      :Access public
    ⍝ open the help file
      ⎕SE.UCMD'Open "',#.Boot.AppRoot,'Documentation/TamStatUserGuide.pdf"'
      R←''
    ∇


    ∇ R←tit BuildTooltip txt;safeText
      :Access public
      safeText←{w←#.HtmlUtils.HtmlSafeText ⍵ ⋄ ((w='''')/w)←⊂'&#39;' ⋄ ∊w} ⍝ temporary workaround until MiServer has new HtmlSafeText
      R←'&nbsp;<span data-jbox-title=''',(safeText tit),''' data-jbox-content=''',(safeText txt),'''><i class=''fas fa-info-circle text-primary''></i></span>'
    ∇

    ∇ R←EnableR;∆r
      :Access public
      :If 9≠#.TamStat.⎕NC'RCONNECT'
     ⍝ Only do this if RCONNECT doesn't already exist
          'RCONNECT'#.TamStat.⎕NS''        ⍝ Create the namespace
          :With #.TamStat.RCONNECT
              ⎕CY'RCONNECT'      ⍝ Copy dyalog's RCONNECT into our new namespace
          :EndWith
     ⍝ Anticipate absolute paths in RCONNECT
          #.Renvr←#.TamStat.RCONNECT.Renvr
          #.Rcall←#.TamStat.RCONNECT.Rcall
          #.Robject←#.TamStat.RCONNECT.Robject
          #.Rexpr←#.TamStat.RCONNECT.Rexpr
          #.Rfunc←#.TamStat.RCONNECT.Rfunc
          #.Rdataframe←#.TamStat.RCONNECT.Rdataframe
          #.TamStat.∆r←⎕NEW #.TamStat.RCONNECT.R     ⍝ Create R Connection
          #.∆r←#.TamStat.∆r                          ⍝ TamStat addresses it using ##
      :EndIf
      :If #.TamStat.R_Available  ⍝ disable it (and remove all traces)
          #.TamStat.R_Available←0
          #.R_Available←0
          #.⎕EX'Renvr Rcall Robject Rexpr Rfunc Rdataframe'
          #.TamStat.⎕EX'RCONNECT ∆r'
      :Else
          :Trap 0
              #.TamStat.∆r.init
              #.TamStat.R_Available←1      ⍝ Set availability
              #.R_Available←1              ⍝ #.TamStat.rAv check ##...
              R←Execute'#RConnect'_JSS.AddClass'active'
     
          :Else
              #.TamStat.R_Available←0
              #.R_Available←0
              R←Execute'red'#._.jBox.Notice'Could not activate R-Connect!'
          :EndTrap
      :EndIf
    ∇

    ∇ R←larg SetCalcButton mode
      :Access public
⍝ mode=0: Hide (and disable keybinding...)
⍝      1: adds F9-Handler
⍝      2: Disable button and keybinding
⍝ larg=0: Return Execute
⍝      1: Plain JS
⍝-----------------------------------------------------
     
      R←'$("#btnRecalc").',((1+mode)⊃'hide' 'show' 'show'),'();'
      :Select mode
      :Case 0 ⋄ R,←'$("body").off("keyup");'
      :Case 1 ⋄ R,←'$("body").on("keyup", function(){if (event.key == "F9" && (!event.ctrlKey) && (!event.shiftKey))$("#btnRecalc").trigger("click");});'
      :Case 2 ⋄ R,←'$("#btnRecalc").attr("disabled","disabled");$("body").off("keyup");'
      :EndSelect
      :If larg=0 ⋄ R←Execute R ⋄ :EndIf
    ∇


    ∇ R←SaveSettings;Prefs;Prefs∆
      :Access Public
      R←''
      Prefs∆←⎕JSON ⎕JSON #.Prefs
      #.Prefs.decimalsP←0 Get'decp'
      #.Prefs.decimalsO←0 Get'decg'
      #.Prefs.menuStyle←Get'appearance'
      #.Prefs.theme←Get'theme'
      #.Prefs.Session.decimals←0 Get'decse'
      #.Prefs.Session.topdown←(2-selist[1;1]≡⊂Get'setd')⊃_false _true
      #.Prefs.Session.TrapErrors←(1+'on'≡Get'trap')⊃#.HtmlElement.(_false _true)
      #.Prefs.SumWiz.defColWidth_dt←Get'swcw'
      #.Prefs.SumWiz.showNrOfCols←Get'cols'
      #.Prefs.enableR←(1+'on'≡Get'enableR')⊃_false _true
      ((⎕JSON⍠'Compact' 0)#.Prefs)⎕NPUT(#.Boot.AppRoot,'/preferences.json')1
      :If #.Prefs.enableR≢Prefs∆.enableR
      :AndIf #.Prefs.enableR≡_true
          R,←EnableR
      :EndIf
      R,←Execute'$("#settings").modal("hide");'
    ∇

    ∇ R←HandleDownloadOrSave;filename;data;i;keys;z;nl2;ref∆;info;possibleSpace;opts;log
      :Access Public
      :If 0<≢R←Check_filesave_name
          →0
      :EndIf
      filename←∊2↑1 ⎕NPARTS Get'filesave_name'
      :Select ⍬⍴info←''Get'filesave_info'   ⍝ what should we do?
      :Case '1'  ⍝ save current dataset
          :If 0<≢ref∆←{2>≢⍵:'' ⋄ 2⊃⍵}'/'#.Strings.split,info
              :For possibleSpace :In userNS.DATA #.Datasets
                  :If 9=possibleSpace.⎕NC ref∆ ⋄ :Leave ⋄ :EndIf
              :EndFor
              :If 9≠possibleSpace.⎕NC ref∆ ⋄ R←Execute 1 Alert'Could not find Dataset "',(⍕ref∆),'" anywhere!' ⋄ →0 ⋄ :EndIf
          :Else
              ref∆←ref
          :EndIf
          opts←''Get'filesave_opts'
          :If opts≡'' ⋄ opts←⎕NS''
          :Else ⋄ opts←⎕JSON opts
          :EndIf
          :If 'on'≡''Get'filesave_overwrite' ⋄ opts.Replace←1 ⋄ :EndIf
          ⍝⎕←⎕JSON opts ⋄ ∘∘∘
          :If 0=≢opts.⎕NL-2
              log←#.tsConsoleCommands.saveCSV filename ref
          :Else
              log←opts #.tsConsoleCommands.saveCSV filename ref
          :EndIf
          R,←Execute Notice 2(∊log)
          R,←Execute'$("#downloader").modal("hide");'
      :Else
          ⎕←'No branch for filesave_info=',Get'filesave_info'
          ∘∘∘
      :EndSelect
     
    ∇

    ∇ R←Check_filesave_name;dir;filename
      :Access Public
      ⍝ check if file exists...
      R←''
      :If ⎕NEXISTS filename←Get'filesave_name'
      :AndIf 'on'≢Get'filesave_overwrite'
          R←Execute'$("#filesaveOverwritePrompt").removeClass("d-none");'
          →0
      :Else
          dir←1⊃1 ⎕NPARTS filename
          :If ~⎕NEXISTS dir
              R←Execute 3 Alert'Directory ',dir,' does not exist!'
              →0
          :EndIf
      :EndIf
    ∇

    ∇ R←OFF0 rarg
      :Access Public Shared
      R←''
      :If {6::0 ⋄ 'HRServer'≡⍎⍵}'#.Boot.ms.Framework' ⍝ if we running with DUI
          #.Boot.ms.Config.HRServer.(Posn Size)←(⊃#.Boot.ms._Renderers).(Posn Size)
          (⊂(⎕JSON⍠'Compact' 0)#.Boot.ms.Config.HRServer)⎕NPUT(#.Boot.AppRoot,'Config/HRServer.json')1
          1 ⎕NDELETE #.Boot.AppRoot,'Config/HRServer.xml'   ⍝ be sure tthere's no .xml file left (which would take priority reading config)
          :If {6::⍵ ⋄ #.Prefs.closeAPLonExit}1
              ⎕OFF 0
          :Else
              {}⎕NQ #.Boot.ms._Renderer'Close'
              ⎕←'*** Closed HTMLRenderer, APL not closed. To do so, please set "closeAPLonExit":1 in preferences.json'
          :EndIf
      :EndIf
    ∇
    ∇ R←OFF
      :Access Public Shared
      R←OFF0 0
    ∇


    ∇ R←OpenDataFolder;r
      :Access public shared
      r←#.Env.dataFolder
      :Select 3↑⊃⎕SE.SALTUtils.APLV
      :Case 'Win'
          r←r WinOpenWith 0
      :Case 'Mac'
          r XOpenWith'open'
      :Case 'Lin'
          r XOpenWith'xdg-open' 0
      :Else
          r←'** This command is not supported on ',⊃⎕SE.SALTUtils.APLV
      :EndSelect
    ∇


⍝ ↓↓↓ taken from AB's ]OPEN

    Layout←{↑∘⎕SE.Dyalog.Utils.layoutText⍣(~##.RIU)⊢⍵}
    Fmt←' '⎕R'\%20'
    If←/⍨

      HelpUrl←{
          url←'https://help.dyalog.com/',1↓∊2↑'.'(,⊂⍨⊣=,)2⊃⎕SE.SALTUtils.APLV
          0=≢⍵:url,'/index.htm'
          (terms pages)←⎕CSV⍠2⍠'Separator'(⎕UCS 9)⊢'/spice/help.csv',⍨⎕SE.SALTUtils.getEnvir'SALT'
          terms←,∘⎕UCS∘⍎¨@(∧/¨∊∘⎕D¨)⍣⎕SE.SALTUtils.UNICODE⊢terms ⍝ convert numbers to characters if Unicode
          term←⊂¯1 ⎕C ⍵
          term∊terms:Fmt url,'/Content',pages⊃⍨terms⍳term   ⍝ built-ins
          ⍺←1
          (']'=⊃⍵)∨(term∊##.##.List[;2]):']',(⍵~']-?'),' -',⍺⍴'?' ⍝ user commands
          ens←⍸~(⊃∘⌽¨⎕EM⍳1010)∊⎕D,' '
          en←⊃⊃⌽⎕VFI⊃term
          en∊ens:Fmt url,'/Content/Language/Errors/','.htm',⍨' ?- ?' 'S/T'⎕R' ' 'S T'⎕EM en ⍝ error numbers
          em←1 ⎕C term
          em∊⎕EM ens:Fmt url,'/Content/Language/Errors/','.htm',⍨⊃em ⍝ error messages
          Fmt url,'/#search-',⍵∩' .',⎕D,⎕A,⎕C ⎕A         ⍝ general search
      }

    ∇ name XOpenWith cmd ⍝ for non-Win
      cmd,←' "'
      cmd,←'file://'If~∨/'://'⍷name    ⍝ add protocol if absent
      cmd,←(~∨/'/\'∊name)/⊃1 ⎕NPARTS'' ⍝ add path if absent
      cmd,←name,'"'
      {}⎕SH cmd
    ∇

    ∇ r←{name}WinOpenWith cmd;⍙USING;ext;sel;⎕USING;fd;folder;isfile;path;Dext;SU;dir;cmd;iRetVal
      r←name
     
      :If 0≢cmd ⍝ Use .Net if we need to specify with what
          iRetVal←(⍎⎕NA'P shell32|ShellExecute* P P <0T P P I4')0 0 name 0 0 5 ⍝ Try non-.Net if we can
      :OrIf 1=0 33⍸iRetVal
     
          ⍙USING←cmd
          ext←cmd←r←⍬
          SU←⎕SE.SALTUtils
          sel←1
          Dext←SU.SALTEXT
     ⍝ If this is a relative path we search in the list of SALT working directories
          :If SU.isRelPath path←name
              :For folder :In {⎕ML←3 ⋄ (⍵≠'∘')⊂⍵}⎕SE.UCMD'settings workdir'
                  isfile←~SU.isDir path←folder SU.ClassFolder name
                  ext←Dext If(⍙USING≡0)∧isfile∧sel⍱'.'∊name ⍝ add extension if none supplied
                  →run If 1=⍴dir←⎕IO⊃'a'SU.Dir path,ext
              :EndFor
              'File not found'⎕SIGNAL 922
          :Else
              :If ~dir←SU.isDir name
                  ext←Dext If(⍙USING≡0)∧sel⍱'.'∊name
              :EndIf
          :EndIf  ⍝ otherwise we use it directly
     run: r←dir RunCmd path,ext ⍝ full path name case
      :EndIf
    ∇

    ∇ r←{dir}RunCmd path;⎕USING ⍝ this is only used by <Open>
      ⎕USING←'System.Diagnostics,system.dll'
      r←⍙USING{6::(⍺≡0)/⍵ ⋄ 90::⎕EXCEPTION.Message ⋄ ⍵⊣Process.Start(0≡⍺)↓⍺ ⍵}path
      r ⎕SIGNAL 922 If path≢r
    ∇


:EndClass
