﻿:Namespace Util
(⎕IO ⎕ML ⎕WX)←1 1 3

 BuildRExpr←{
     ⎕IO←0 ⋄ ⎕ML←3
     CompileProb←{
         XXX←(⍵≠' ')⊂⍵
         i←XXX⍳⊂'prob'
         j←'normal' 'tDist' 'fDist' 'chiSquare'⍳XXX[i-1]
         dist←j⊃'norm' 't' 'f' 'chisq'
         rel←XXX[i+1]
         parms←(i-1)↑XXX
         values←(i+2)↓XXX
         values←{1<⍴⍵:'c(',(1↓∊',',¨⍵),')' ⋄ ↑⍵}values
         xpr←∊'p',dist,'(',values,',',¨parms
         rel∊,¨'≤' 'le':xpr,',lower.tail = TRUE)'
         rel∊,¨'>' 'gt':xpr,',lower.tail = FALSE)'
     
     }
     ∨/'prob'⍷⍵:CompileProb ⍵
     ∨/'criticalValue'⍷⍵:CompileCV ⍵
     ∨/'randomVariable'⍷:Random ⍵
 }

 FInterp←{
     ⎕ML←3 ⋄ ⎕IO←0
     b←×-/⌽⍺                         ⍝ Identify larger value
     df←2 3⍴0,v←60 40                ⍝ Assemble df
     (b↑df)←↑b↑⍺                     ⍝ Replace with smaller value
          ⍝y←(↓⍉df)fDist criticalValue<¨⍵ ⍝ Get F Values
     y←(↓⍉df)fDist criticalValue>¨⍵  ⍝ Get F Values
     x←0,÷v
     (⊃x y)interpolate÷⌈/⍺
 }

∇ Z←HideHo OB;F
 ⎕IO←0 ⋄ ⎕ML←3
 mi←(↑OB)    ⍝ Menu Item
 :If mi≡mi.##.Hide
     ##.∆r←⎕NEW ##.RCONNECT.R     ⍝ Create R Connection
        ⍝  msg←##.∆r.init               ⍝ Initialize R
     ##.Ho_Available←0            ⍝ Set availability
     mi.##.(Hide Unhide).Checked←1 0
 :Else
     ##.Ho_Available←1
     mi.##.(Hide Unhide).Checked←0 1
 :EndIf
∇

∇ Z←HypothesisAPI NS;V
          ⍝∇ ns-based API for Hypothesis - Last updated 6/6
          ⍝⍵ nsIn Namespace containing the following variables
          ⍝⍵   Event  'Init'
          ⍝⍵   Event 'SelectStat'
          ⍝      Labels
          ⍝    Event 'Run'  Signficance Data Parameter Relational HypothesizedValue
          ⍝← nsOut  Namespace containing  DataStat Report
          ⍝← Output Results Expr
          ⍝   Parameter:   mean, proportion, sdev, var
          ⍝   Data:  1 or 2-item nested vector:    Expression or stats
          ⍝   Values:  1×3 or 2×3 numeric matrix
          ⍝   UserSpace:   Ref or
          ⍝⍵    Parameter Levels Var GroupBy Var2
          ⍝← nsOut Namespace contain nsIn plus the following:
          ⍝←    Labels  2-item nested vector
          ⍝←    Values  1x3 or 2x3 numeric matrix
          ⍝←    Protect 2×3 boolean matrix 1=protect, 0=editable
 ⎕IO←0 ⋄ ⎕ML←3
 :Select NS.Event
 :Case 'Init'
     NS.ParameterList←'mean' 'proportion' 'var' 'sdev'
     NS.Parameter←'mean'
     NS.Labels←'Sample Size' 'Mean' 'Std Dev'
     NS.Data←'stats'
     NS.Values←1 3⍴30 0 0
     NS.HypothesizedValue←0
     NS.Relation←,'='
     NS.RelationList←,¨'<≤=≠≥>'
     NS.RelationListKeys←'lt' 'le' 'eq' 'ne' 'ge' 'gt'
     NS.Significance←5
     NS.Samples←1
     NS.SplitBy←0
     NS.ReturnCode←0
 :Case 'SelectStat'
     :Select NS.Parameter
     :Case 'mean' ⋄ NS.Labels←'Sample Size' 'Mean' 'Std Dev'
         :If NS.Data≢'stats' ⋄ V←exErr'(count,mean,sdev)',NS.Data ⋄ :EndIf
     :Case 'proportion' ⋄ NS.Labels←'Sample Size' 'Events' 'Proportion'
         :If NS.Data≢'stats' ⋄ V←exErr'(count,sum,proportion)',NS.Data ⋄ :EndIf
     :CaseList 'var' 'variance' 'sdev' ⋄ NS.Labels←'Sample Size' 'Variance' 'Std Dev'
         :If NS.Data≢'stats' ⋄ V←exErr'(count,var,sdev)',NS.Data ⋄ :EndIf
        ⍝  :Case 'sdev' ⋄ NS.Labels←'Sample Size' 'Mean' 'Std Dev'
     :EndSelect
     :Trap 0 ⋄ NS.Values[0;]←⍎V ⋄ :EndTrap
     
 :Case 'Run'
     :If 0=⎕NC'NS.SplitBy' ⋄ NS.SplitBy←0 ⋄ :EndIf
     Z←{xeq←⍵.(SplitBy↓Data Parameter)
         xeq,←'hypothesis'⍵.Relation
         xeq,←(2×~⍵.SplitBy)↓⍵.Data'splitBy'⍵.Value
         US←{2=⎕NC'⍵':⍎⍵ ⋄ ⍵}⍵.UserSpace
         ns←⍵
         Expr←deleteExcessBlanks⍕(⍵.Significance÷100)'report',xeq
         ns.ReturnCode←1
         H←US{0::0 ⋄ ⍺⍎⍵}⍕xeq
         2=⎕NC'H':{⍵.Expr←Expr ⋄ ⍵.Output←'Error' ⋄ ⍵}ns
         Output←US⍎Expr
         _←'ns'⎕NS'Expr' 'Output',↓'H','.',H.⎕NL 2
         ns.ReturnCode←0
         ns.(Conclusion←P<Significance÷100)
         ns}NS
 :Else
     NS.Values←NS.Event NS.rectifyStats NS.Event
 :EndSelect
 Z←NS
∇

∇ Z←Init
 ⎕IO←0
 ⎕ML←3
 2+
 :If 0
     P←'Operators Util Distribution Summary Relational Arithmetic Graph Regression UserInterface GUI'
     P←⍕'##.'∘,¨(P≠' ')⊂P
     ⎕PATH←P
 :EndIf
 Z←0
∇

 Path←{
     ⎕IO←0 ⋄ ⎕ML←3
      ⍝P←'Operators Util Distribution Summary Relational Arithmetic Graph Regression UserInterface GUI'
     P←'Operators Util Distribution Summary Relational Regression'
     P←'##.'∘,¨(P≠' ')⊂P
      ⍝⍕'# #.TamStat ',P
     ⍕P}

 RCompile←{
     ⍝⍺:  RConnect Expression
     ⍝⍵:  Variable inputs
     ⎕IO←0 ⋄ ⎕ML←3
     MakeRVar←{1=≢⍵:⍵
         txt←⍕⍵               ⍝ Format
         ((txt=' ')/txt)←','  ⍝ Insert commas
         'c(',txt,')'         ⍝ Enclose in parens
     }
     v←MakeRVar¨⍵
     i←{⍵/⍳⍴⍵}⍺='⍵'      ⍝ Get positions of ⍵'s
     xpr←⍺
     xpr[i]←v
     (⍕xpr)~' '
 }

∇ Z←RInterface OB;F;⎕IO;⎕ML
 ⎕IO←0 ⋄ ⎕ML←3
 mi←(↑OB)    ⍝ Menu Item
 :If mi≡mi.##.Yes
     ##.∆r←⎕NEW ##.RCONNECT.R     ⍝ Create R Connection
     msg←##.∆r.init               ⍝ Initialize R
     ##.R_Available←1             ⍝ Set availability
     mi.##.(Yes No).Checked←1 0
 :Else
     ##.R_Available←0
     mi.##.(Yes No).Checked←0 1
 :EndIf
∇

∇ {I}RUNPF2 LOG;I;J;K
 ⎕ML←3 ⋄ ⎕IO←0
 ⎕SE.⎕WX←1
 ⎕ML←3 ⋄ ⎕IO←0
     ⍝ ⎕SE.FontObj←'Dyalog Std' 22 1 0 0 700 0
 LOG←(-+/∧\⌽' '∧.=LOG)↓[1]LOG ⍝ Remove trailing blanks
 :If 0=⎕NC'I' ⋄ I←1 ⋄ :EndIf
 K←'→⎕LC+1'⎕PFKEY 3
 :While I<↑⍴LOG
     K←LOG[I;]⎕PFKEY 2
     ⍞←5⍴' '
     J←⍞
     I←I+K≡5↓J
     ⍎J
 :End
 'End Demo'
      ⍝ ⎕SE.FontObj←'Dyalog Std' 16 1 0 0 400 0
∇

 ScaleDist←{
      ⍝∊ Written by Steve Mansour  2020
     ⍝⍺ Scale (Integer)
     ⍝⍵ Data  (lower Bound, Upper Bound)
     ⍝← Starting Point
     ⍝← Ending Point
     ⍝⍎ 0 50 ← 5 ScaleDist 10 32
     ⎕IO←0 ⋄ ⎕ML←3
     ⍺←8
     lb ub←⍵
     lb←0⌊lb
     r←ub-lb
     c m←10*0 1⊤10⍟r÷⍺
     bw←c×m{⍵[⍺+.≥⍵]}1 2 2.5 4 5 10     ⍝ Bin width
     st←bw×⌊lb÷bw                       ⍝ starting point
     st+0,bw×⍺
 }

∇ Z←SelectFont OB;F;c;fo;v;mi;props;b
 ⎕IO←0 ⋄ ⎕ML←3
 mi←(↑OB)    ⍝ Menu Item
 F←getform OB
 fo←{↑⌽('.'≠⍵)⊂⍵}⍕mi
      ⍝fo←('_'⎕R' ')c
 props←1 0 0 700
 'APL385_Unicode'⎕WC'Font' 'APL385 Unicode' 24,props
 'Courier_New'⎕WC'Font' 'Courier New' 24,props
 'Lucida_Console'⎕WC'Font' 'Lucida Console' 24,props
 'APL_Large'⎕WC'Font' 'APL385 Unicode' 48,props
 'Courier_New_Large'⎕WC'Font' 'Courier New' 48,props
 'Lucida_Large'⎕WC'Font' 'Lucida Console' 48,props
     ⍝ v←toNestedVector F.mb.mst.mf.⎕NL 9
 v←toNestedVector(↑OB).##.⎕NL 9
 b←v∊⊂fo
     ⍝ F.mb.mf.(APL385_Unicode APL_Large Courier_New Courier_New_Large Lucida_Console Lucida_Large).Checked←b
 (↑OB).##.(APL385_Unicode APL_Large Courier_New Courier_New_Large Lucida_Console Lucida_Large).Checked←b
 F.in.FontObj←(2×⌊0.5×b/⍳≢b)⊃v
 F.g.out.FontObj←fo
∇

∇ Z←Standard OB;F
 ⎕IO←0 ⋄ ⎕ML←3
 mi←↑OB
 b←mi.Caption≡'Standard'
 mi.##.(Standard APL).Checked←b=1 0
∇

∇ Z←TestLog;COLORS;PROPORTION;DATA;B;V;VV;BALANCE;NS;RATE;GROUPA;GROUPB;BEFORE;AFTER
 ⎕ML←3 ⋄ ⎕IO←0
 3 0.25 binomial 2
 3 0.25 binomial 0 1 2
 3 0.25(binomial probability=)2
 3 0.25 binomial probability=2
 3 0.25 binomial probability≤2
 +/3 0.25 binomial 0 1 2
 3 0.25 binomial probability≠2
 3 0.25 binomial probability>2
 10 0.25 binomial probability between 3 6
 10 0.25 binomial probability∊4 5
 COLORS←'Brown,Yellow,Red,Blue,Orange,Green'
 PROPORTION←0.14 0.13 0.2 0.24 0.16 0.13
 COLORS PROPORTION multinomial probability='Red'
 COLORS PROPORTION multinomial probability≠'Green'
 0.1 0.5 0.4 multinomial probability=1
 0.1 0.5 0.4 multinomial probability<2
 normal ¯2 ¯1 0 1 2          ⍝ Standard Normal density
 8 3 normal 4 6 8 10 12      ⍝ mean=8, std deviation=3
 normal probability≤2 ⍝ Cumulative probability
 normal probability<2 ⍝ Strict inequality doesn’t matter
 normal probability=2 ⍝ Probability of exact value is zero.
 normal probability between ¯1.96 1.96 ⍝ Interval probability
 8 2 normal probability>5 ⍝ Non-standard upper-tail normal probability
 normal criticalValue>0.05 ⍝ Right tail value
 normal criticalValue<0.05 ⍝ Left tail value
 normal criticalValue≠0.05 ⍝ Two-tail value
 0.5 exponential probability≤2
 0.5 exponential criticalValue≤0.63212
 normal randomVariable 5     ⍝ Generate 5 standard normal r.v.’s
 3 poisson randomVariable 10 ⍝ Generate 10 poisson r.v.’s (mean=3)
 DATA←25 30 10 22 23 29 29 28 ⍝ sample mean
 mean DATA
 mean confInt DATA      ⍝ confidence interval (95%)
 0.99 mean confInt DATA   ⍝ 99% confidence interval
 B←binomial randomVariable 1000       ⍝ sample proportion (p0=0.5)
 proportion B
 proportion confInt B ⍝ 95% confidence interval contains 0.5
 V←variance DATA                 ⍝ sample variance
 V*÷2                            ⍝ sample standard deviation
 VV←0.99 variance confInt DATA  ⍝99% confidence int for variance
 VV*÷2                           ⍝ confidence interval for std dev
 BALANCE←72000 20000 normal randomVariable 30
 mean BALANCE
 NS←BALANCE mean hypothesis=70000
 NS.pValue
 NS.TestStatistic
 report NS
 RATE←3 4 8 triangular randomVariable 30
 report RATE mean hypothesis≤5
 0.01 report(RATE>6)proportion hypothesis≥0.15
 GROUPA←2 5 3 8 1
 GROUPB←4 3 2 2
 report GROUPA mean hypothesis=GROUPB
 mean confInt GROUPA GROUPB
 BEFORE←2 5 3 8 1
 AFTER←4 3 2 5 2
 report(AFTER-BEFORE)mean hypothesis=0
 mean confInt AFTER-BEFORE
 report GROUPA variance hypothesis=GROUPB
 DATA←2 1 2 7 4 1⌿toMatrix COLORS
 uniform goodnessOfFit DATA
 report COLORS PROPORTION multinomial goodnessOfFit DATA
 report normal goodnessOfFit?100⍴100
 report normal goodnessOfFit BALANCE
 8 0.3 binomial theoretical mean''
 8 0.3 binomial theoretical var''
 Z←'Test Successful'
∇

 XAxis←{
     ⍝ XAxis for data set
     ⍝⍵ Data Set or summary
     ⍝← Bounds
     ⍝← Scale (Rule)
     ⎕IO←0 ⋄ ⎕ML←3
     R←{⍵+⍵=0}(⌈/-⌊/)⍵                     ⍝ Range
     C←10*⌊10⍟R                            ⍝ Scale    (Characteristic)
     L←C×⌊(⌊/⍵)÷C                          ⍝ Lower bound
     M←(5 2 1+.>C÷⍨L-⍨⌈/⍵)⊃1 2 5 10        ⍝ Find Scaling Factor
     T←L+(C÷M)×1+⍳10                       ⍝ Rescale to size
     TW←10                                 ⍝ Tick Width
     S←101⍴1(TW-1)/'+-'                    ⍝ Scale
     FS←TW{⍵≥10:'I',⍕⍺                     ⍝ Format String
         'F',(⍕⍺),'.',⍕1+⌈0.1⍟⍵}R          ⍝
     S←S⍪' ',('10M<->',FS)⎕FMT,[¯0.5]T     ⍝ Scale
     (L,↑⌽T)S}

 XAxis1←{
     ⍝ XAxis for data set
     ⍝⍵ Data Set
     ⍝← Bounds
     ⍝← Scale (Rule)
     ⎕IO←0 ⋄ ⎕ML←3
     R←(⌈/-⌊/)⍵                             ⍝ Range
     C←10*⌊10⍟⌈/|R                          ⍝ Scale    (Characteristic)
     L←C×⌊(⌊/⍵)÷C                           ⍝ Lower bound
           ⍝ T←L+C×1+⍳10                           ⍝ Ticks
     ⍝     T←T{⍺[1]>⍵:L+(C÷5)×1+⍳10              ⍝ If highest value < 2nd tick, rescale to size
     ⍝         ⍺[4]>⍵:L+(C÷2)×1+⍳10              ⍝ If highest value < 5th tick, rescale to size
     ⍝         ⋄ ⍺}⌈/⍵
        ⍝ M←(5 2 1+.>((⌈/⍵)-L)÷C)⊃1 2 5         ⍝ Rescale to size
     M←(5 2 1+.>C÷⍨L-⍨⌈/⍵)⊃1 2 5           ⍝ Find Scaling Factor
     T←L+(C÷M)×1+⍳10                       ⍝ Rescale to size
     TW←10
     S←101⍴1(TW-1)/'+-'                    ⍝ Scale
     FS←TW{⍵≥10:'I',⍕⍺                     ⍝ Format String
         'F',(⍕⍺),'.',⍕1+⌈0.1⍟⍵}R          ⍝
     S←S⍪' ',('10M<->',FS)⎕FMT,[¯0.5]T     ⍝ Scale
     (L,↑⌽T)S}

∇ buildArithmetic
 :Namespace Arithmetic1
     sin←1∘○
     cos←2∘○
     tan←3∘○
     exp←*
     ln←⍟
     sqrt←*∘0.5
     arcsin←¯1∘○
     arccos←¯2∘○
     arctan←¯3∘○
     transpose←⍉
     poly←⊥
 :EndNamespace
∇

 buildComparisonTable←{
          ⍝⍺: RandomVariables
          ⍝⍵: Property Space Object
          ⍝←: Table object
          ⍝p←4 rd ⍵.Value
     ⎕IO←0 ⋄ ⎕ML←3
     N←'TestStatistic,P_Value,CriticalValue,Significance'
     C←2 2⍴(','≠N)⊂N
     ps←⍵
     df←ps.DegreesOfFreedom.Value
     df←{' '~⍨1↓,'<,>,G<ZZZZZZZ>'⎕FMT ⍵}df
     D←ps.Distribution.Value
     x←2 2⍴⍎'ps.(',N,').Value'   ⍝ Statistics
     d←1⌈5-⌈10⍟⌈⌿0.00001⍪|x      ⍝ Decimal Places
     V←↓2 2 10⍴(∊10,¨d)⍕x
     b←'≠'∊ps.H1.Value
     cv←1⌽')',D,'(⍺',(b/'/2'),('Z'≠↑D)/';df=',df
     W←25
     V←V{(-W)↑' '~⍨⍵,'=',⍺}¨2 2⍴D'p'cv'⍺'
     V←C{⊃(⍺,':')⍵}¨V
     T←tableBox V
     T
 }

 buildPropertySpace←{
     r←⎕NS''
     r.(count mean variance)←⍵
     r
 }

 check←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ Check
      ⍝∊ Utility Function
      ⍝⍺ Y: Checking Parameters
      ⍝⍵ X: Value
      ⍝← 1 = Valid    0 = not valid
      ⍝⍕ 1 ← 'I' check 3
      ⍝    0::0 ⋄
     ⎕IO←0 ⋄ ⎕ML←3                  ⍝ Set variables
     ≡⍺:⍺ ∇¨{L←(⍺∊⎕D)/⍺                ⍝ Length parameters
         2>≢L:∧/⍺ ⍺⍺⊂⍵                ⍝ Multiple checks
         ∧/(∨/L ⍺⍺⊂⍵),(⍺~L)⍺⍺⊂⍵}⍵   ⍝ If multiple lengths, or them together
      ⍝    ≡⍺:∧/⍺ ∇¨⊂⍵
     'A'=⍺:(⎕DR ⍵)∊80 160           ⍝ Character
     'W'=⍺:9=⎕NC'⍵'                 ⍝ Namespace
     'v'=⍺:1=↑⍴⍴⍵                   ⍝ Vector
     'm'=⍺:2=↑⍴⍴⍵                   ⍝ Matrix
     (⎕DR ⍵)∊80 160 326 1289:0      ⍝ Check for numeric
     'X'=⍺:1                        ⍝
     'B'=⍺:11=⎕DR ⍵                 ⍝ Boolean
     'I'=⍺:⍵≡⌊⍵                     ⍝ Integer
     'P'=⍺:∧/(,⍵)between 0 1        ⍝ Probability/Proportion
     'Q'=⍺:∧/(,⍵)include 0 1        ⍝ Include 0 and 1
     'S'=⍺:0∧.<,⍵                   ⍝ Postive
     'U'=⍺:0∧.≤,⍵                   ⍝ Non-negative
     ⍺∊⎕D:(≢⍵)=⍎⍺                  ⍝ Check length
     'O'=⍺:⍵∊0 1 ¯1 ¯2 ¯3           ⍝ Operator
 }

∇ Z←checkOperator;op
 ⎕ML←3 ⋄ ⎕IO←0
      ⍝ Check operator
 op←↑↑2↓⎕SI             ⍝ Get operator name
 Z←↑(op='pcr')/1 ¯1 ¯2  ⍝ Use 1st char
∇

 chiSquare_report←{
     ⎕IO←0 ⋄ ⎕ML←3
     i←'Normal' 'Uniform' 'Multinomial' 'Independent'⍳⊂⍵._Distribution
     T←⍵.Type{⍺≡'Independent':makeContingency ⍵ ⋄ ⍵}⍵.Table
     T←{⎕PP←5 ⋄ '-'@('¯'∘=)⍕⍵}T   ⍝ Format 5 decimal places, replace hi-minus
     P←⍕{6::' ' ⋄ ' ',[-0.5](≢⍵.Parameters)↑'Mean:' 'Standard Deviation:',¨2↑⍵.Parameters}⍵
     tb←⊃'Test Statistic: '('χ²=',⍕⍵.TestStatistic)
     tb←tb(⊃'P-Value: '('p'fmtP ⍵.P))
     x2←⍵.DegreesOfFreedom chiSquare criticalValue<⍺
     cv←' '~⍨,'<χ²(α;df=>,LI3,<)=>,LF9.3'⎕FMT 1 2⍴⍵.DegreesOfFreedom,x2
     tb←tb,(⊃'Critical Value:'cv)(⊃'Significance Level:'('α=',⍕⍺))
     h←'H₀: ' 'H₁: not ',¨⊂⍵._Distribution
     tb←tablebox 2 2⍴tb
     C←(⍵.P<⍺)⊃'Fail to reject H₀' 'Reject H₀'
     ⍕,[⍬]T P' 'h tb('Conclusion:'C)}

 cmat←{⎕ML←2 ⋄ ⎕IO←1                     ⍝ ⍺-combination matrix of ⍳⍵.
     ↑↑(⊂⊂1 0⍴0){                        ⍝ base-case: [0 ⍵].
         ¯1↓↑{                           ⍝ removing base case from,
             (⍪/⌽{⎕IO,⍵}\1+⍺(↑⍵)),⍵      ⍝ accumulation of,
         }/⍵,⍺⍺                          ⍝ sub- (⍺ ⍵-1) combinations,
     }/(⍳0⌈⍵-⍺),⊂(⍺≤⍵){⍺ ⍵⍴⍳⍵}¨⌽+\⍺⍴1    ⍝ with base cases [⍺ 0].
 }

 combinePartitions←{
     ⍝∇ Combine small groups for goodnessOfFit tests
     ⍝∊ Written by Steve Mansour
     ⍝⍺ Minimum partition Size (Default 5)
     ⍝⍵ Numeric frequency distribution (3-column matrix)  Values, Obs, Exp
     ⍝← Numeric frequency distribution  ≢Result ≤ ≢Right Argument
     ⍝⍎ 5 combinePartitions 5 3⍴0 2 3.92 1 9 7.56 2 8 7.56 3 5 5.04 4 4 3.92
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←5           ⍝ Set system variables
     v n←↓⍉1 0 1/⍵                 ⍝ Values, Expected
     i←(n<⍺)⍳1                     ⍝ Small expected values
     i≥≢⍵:⍵                        ⍝ If no small values, done
     b←{(>/⍵)⌽⍵}i+0,¯1*(i+1)=≢⍵    ⍝ Indices of adjoining values to combine
     v[b]←,/v[b]                   ⍝ Combine key adjoining values
     ⍺ ∇ v{⍺,+⌿⍵}⌸1↓[1]⍵           ⍝ Combine observed, expected values
 }

 conform←{
          ⍝∊ Written by Steve Mansour
          ⍝∇ Check to see if 2 or more arguments conform
          ⍝⍺ Any Array
          ⍝⍵ Any Array
          ⍝←  1 = Conformable; 0=not conformable
          ⍝⍎  1 ← 2 3 4 conform 5 6 7     ⍝ Conformable
          ⍝⍎  0 ← 2 3 conform 5 6 7       ⍝ Not conformable
          ⍝⍎  1 ← conform (2 3 4)(5 6 7)8 ⍝ Conformable
          ⍝⍎  0 ← conform (2 3 4)6(5 7)   ⍝ Not conformable
         ⍝ 4 5::0             ⍝ Check for rank/length errors
     0::⎕EN
     0=⎕NC'⍺':⌈/,∘.∇⍨,⍵ ⍝ Monadic, check each item wiht the others
     ~≢⍴⍴⍺+⍵             ⍝ Dyadic, test with scalar function
 }

∇ Z←copyright
 Z←'      Copyright (c) 2022 by Stephen Mansour'                 ⍝ Caption
∇

 craps←{
     f←{N←6-|⍵-7
         ⍵∊7 11:N
         ⍵∊2 3 2:-N
         D←⍺
             ⍝ 1-.2×⍵∊5 9
         N×(N-6)÷N+6}
     
     5×(f¨1↓1+⍳12)÷36
 }

 deleteExcessBlanks←{w←⍕⍵~0J1
     v←(~'  '⍷w)/w                 ⍝ Remove excess blanks
     v←(+/∧\v=' ')↓v               ⍝ Remove leading blanks
     (+/∨\⌽v≠' ')↑v                ⍝ Remove trailing blanks
 }

 drop←{
     ⎕ML←1 ⋄ ⍺↓⍵}

 enclose←{⊂⍵}

 exErr←{
     ⍝ Execute user expression; trap user error   7/25
     ⍝⍵: Executable user expression
     ⍝←: Result or error message
     0::⎕DMX.(EM,'    ',Message)
     ⍺←#
     ∆←1↓('<>'⎕R'≠')('<='⎕R'≤')('>='⎕R'≥')('<-'⎕R'←')' ',⍵
     b←{0::⍵ ⋄ #.TamStat.UserInterface.SessionForm.mb.mst.msy.Standard.Checked}0
     ∆←b{⍺=0:⍵
         ∆←('\x{5E}'⎕R'*')('/'⎕R'÷')('\x{2A}'⎕R'×')⍵
         ('([\s,\,])-([\d,\.])'⎕R'\1¯\2')∆}∆
        ⍝  ∆←⍎'#.(',∆,')'
     ∆←⍺⍎∆
     9≠⎕NC'∆':⍕∆ ⋄ ∆}

 export←{
     ⍝⍵  Path/Filename of CSV file or ''
     ⍝←  Namespace containing values
     ⎕ML←3 ⋄ ⎕IO←0
     ob←↑⍵
     9=⎕NC'ob':{f←getform ⍵ ⋄ f.in.Text←'D<-export ''''' ⋄ 1}ob
     ⍺.(N←⎕NL 2)
     M←⍉⊃⍺.(⍎⍤1⊢N)
     M1←⍕0 1↓,[1 2]',',[1.5]M
     
     FN←{{('\'≠↑⌽⍵)∧0<⍴⍵}w←⍵~' ':⍵,(~∨/s⍷⍵)/s←'.csv'
         d←{0=⍴⍵:'C:\' ⋄ ⍵}w
         _←'F1'⎕WC'FileBox' 'Pick File to Read'd
         _←⎕DQ'F1'
         F1.Directory,F1.File}⍵
     ⎕NCREATE
     
     
     
     TN←FN ⎕NTIE ¯1
     D←⎕NREAD TN 82(⎕NSIZE ¯1)0
     D←(~D∊⎕TC)⊂D
     Parse←{⍝0::0
         f←{((',#',⍺,',')⎕R',0j1,')⍵}⍣≡
         E←'DIV/0!' 'N/A!' 'NAME?' 'NULL!' 'NUM!' 'REF!' 'VALUE!'
         w←↑f/E,⊂',',⍵,','
         w←(',,'⎕R',0j1,')⍣≡w
         z←(','≠w)⊂w
         k←⎕VFI∘('-'⎕R'¯')∘{⍵~'+'}¨z
         b←{(↑⍵)≡,1}¨k
         (b/z)←1 0∘⊃¨b/k
         z}
     D←Parse¨D                       ⍝ Parse each row
     H←↑D                            ⍝ Header is 1st row
     D←⊂[0]⊃1↓(~B←D∊0)/D             ⍝ Remove bad records
     c←1<≡¨D                         ⍝ Character data?
     (c/D)←deleteExcessBlanks¨¨c/D   ⍝ Delete excess blanks
     _←⍎⍕H('←↑D'~(1<≢H)/'↑')         ⍝ Create variables
     NS←⎕NS H                        ⍝ Move to namespace
     _←⎕EX¨H                         ⍝ Erase in #.Util
     _←⎕NUNTIE TN                    ⍝ Release .csv file
     NS}

 first←{
     ⎕ML←1 ⋄ ⊃⍵}

 fmtP←{⍝∇ Format p-Value
      ⍝⍺ Optional prefix
      ⍝⍵ p-value
      ⍝⍎ ' 0.00200' ← fmtP .002
      ⍝⍎ '<0.00001' ← fmtP 1e¯7
      ⍝⍎ 'p=0.00200' ← 'p' fmtP .002
      ⍝⍎ 'p<0.00001' ← 'p' fmtP 1e¯7
     ⎕IO←0 ⋄ ⎕ML←3
     ⍺←'' ⋄ r←'= '[⍺∧.=' '],'<'
     ⍺,0.00001(>{r[⍺],7 5⍕⍵}⌈)⍵}

 getNames←{
     ⍝∇ Get all names from an expression
     ⍝⍵ Character String
     ⍝← Nested vector of names
     ⎕IO←0 ⋄ ⎕ML←3
     w←(~≠\⍵='''')/⍵ ⍝ Remove quoted strings
     B←w∊∊iotag¨'Zz9' ⍝ Get legal characters
     z←B⊂w
     ((↑¨z)∊⎕A)/z}

 getParameters←{
     ⍝∇ Extract parameters and operator for a distribution
     ⍝⍵ Parameters
     ⍝← List of Parameters
     ⍝← Operator
     op←⍬⍴¯1↑⍵
     ~op∊'dpqr':⍵'d'
     2=≢⍵:⍵
     (¯1↓⍵)op
 }

 getPathOfContainingFolder←{
     a←⎕WSID       ⍝ WSID
     b←(⌽'\'⍷a)⍳1  ⍝ Look for the last '\' in the path
     (-b)↓a        ⍝ Folder path
 }

 gof←{⎕IO←0 ⋄ ⎕ML←3
     v o e←⍵                         ⍝ Uniform goodness of fit
     r←o-e                           ⍝ Error
     x2←+/e2←(r*2)÷e                 ⍝ Calc chiSquare test stat
     tbl←v,o,e,r,[0.5]e2             ⍝ Build explanatory table
     tbl⍪←(-1⊃⍴tbl)↑' ' 'Total',{⍵×1E¯10<|⍵}+⌿¯4↑[1]tbl
     ⍺←¯1+≢o ⋄ df←⍺                  ⍝ Degrees of freedom
     p←df chiSquare probability>x2   ⍝ P-value
     p x2 df tbl}

∇ {Z}←help NAME;⎕IO;⎕ML;NS;B;I;D;path;DUI;ns
 :If DUI←9=#.⎕NC'Boot.ms'
     ns←⎕THIS
     ⎕SHADOW'Help'   ⍝ avoid pollution by leaving behind a global name
     Help←#.Help
 :Else
     ns←##
 :EndIf
 Z←⎕NS''
 :With ns
     ⎕IO←0 ⋄ ⎕ML←3
     NS←' '~⍨¨↓⎕NL 9           ⍝ Get all namespaces
     B←NAME∘{
         FN←⍎⍵,'.⎕NL 3 4'
         (⊂⍺)∊toNestedVector FN
     }¨NS
     path←↑B/NS
     D←1 Help.DOCFN path,'.',NAME
 :EndWith
 :If DUI
     Z.data←D
     Z.Type←'Html'
     Z.popup←1
 :EndIf
∇

 import←{
      ⍝⍟ Copyright (c) 2018, by Stephen Mansour
      ⍝∇ import data from a .csv file
      ⍝∊ Utility Function
      ⍝⍺ Data type of result  9=Namespace(Default)  2=Numeric Matrix
      ⍝⍵ File:  Character vector Path and filename
      ⍝← Namespace containing values or matrix
      ⍝⍕ NS ← import '\[Path]\FileName[.csv]'
      ⍝⍎ D ← import 'C:\TamStat\StudentData.csv'
     ⎕ML←3 ⋄ ⎕IO←0 ⋄ ⍺←9                 ⍝ Set system variables
     ob←↑⍵                               ⍝ If called from menu
     9=⎕NC'ob':{f←getform ⍵ ⋄ f.in.Text←'D<-import ''''' ⋄ 1}ob
     FN←{{('\'≠↑⌽⍵)∧0<⍴⍵}w←⍵~' ':⍵,(~∨/s⍷⍵)/s←'.csv'
         d←{0=⍴⍵:'C:\' ⋄ ⍵}w             ⍝
         _←'F1'⎕WC'FileBox' 'Pick File to Read'd
         F1.Filters←⊂('*.csv' 'Comma Separated variable  (*.csv)')
         _←⎕DQ'F1'                       ⍝
         F1.Directory,F1.File}⍵          ⍝ Get directory and file names
     ⍺=2:⎕CSV FN'' 3 0                   ⍝
     D H←(⎕CSV⍠'Invert' 2)FN'' 4 1       ⍝ Get names, values from .csv
     D←{b←(d←⍵)∊⊂'' ⋄ (b/d)←⎕NULL ⋄ d}¨D ⍝ Replace empties with ⎕null
     H←H~¨⊂' .#$&%'                      ⍝ Remove extraneous characters
        ⍝  H←1 ⎕C¨H                            ⍝ Convert to upper case
        ⍝  H←(1 ⎕C ↑¨H),¨1↓¨H
     H←{(1 ⎕C↑⍵),1↓⍵}¨H
     _←⍎⍕H'←D'                           ⍝ Assign values to names
     NS←⎕NS H                            ⍝ Move to namespace
     _←⎕EX¨H                             ⍝ Erase in names #.Util
     NS}

 indexOf←{⍺⍳⍵}

 interpolate←{
         ⍝ Written by Steve Mansour
         ⍝ Interpolate
         ⍝⍺ matrix of x's and y's
         ⍝⍵ Value of x
     ⎕ML←3 ⋄ ⎕IO←0
     1<⍴,⍵:⍺∘∇¨⍵             ⍝ Apply to array on right
     x y←↓⍺
     f←{↑×/(⊂⍺)-(1↓⍳⍴⍵)⌽¨⊂⍵}
     y+.×(⍵ f x)÷x f x
 }

∇ (bins R1)←{iw}intoBins R0;i
 ⎕IO←0 ⋄ ⎕ML←3
 :If 0=⎕NC'iw'
     bins←5+⍳10 ⍝ Number of bins
     i←1⌈5+.<(count R0)÷bins ⍝ Put at least 5 in each group
     iw←⌈(range R0)÷bins[i-1] ⍝ Interval width
 :EndIf
 R1←iw×⌊R0÷iw
 bins←iw{'[',(⍕⍵),';',(⍕⍵+⍺),')'},[⎕IO+0.1]R1
∇

 iotag←{⎕ML←3 ⋄ ⎕IO←0                ⍝ Generalized ⍳.
     AlphaInterval←{⍵=' ':''         ⍝ ⍳' ' is empty vector.
         a←⎕AV⍳'a0AÁ'                ⍝ Indices of a0AÁ.
         k←⎕IO+a+.<i←1+⎕AV⍳⍵         ⍝ Find starting point.
         ⍺←⎕AV[a[k-1]]               ⍝ Default left argument.
         ≤/i,j←⎕AV⍳⍺:⌽⍵ ∇ ⍺          ⍝ If ⍵ before ⍺, reverse.
         (j-⎕IO)↓(i-⎕IO)↑⎕AV         ⍝ Truncate ⎕AV.
     }
         ⍝Interval←{⍺+0,+\(|d)⍴×d←⍵-⍺}    ⍝ Interval Function.
     Interval←{s←×/1↓⍵,(⍺>↑⍵)/¯1     ⍝ Calculate step size
         ⍺-s×⎕IO-⍳⌊1-(⍺-↑⍵)÷s}       ⍝ Generate Interval
     IndexOf←{i←1↓⍳⍴⍴⍺               ⍝ Enclose left arg axis.
         j←(1-⍴⍴⍺)↑⍳⍴⍴⍵              ⍝ Enclose right arg axis.
         m←(⍴⍺)[i]⌈(⍴⍵)[j]           ⍝ Pad both arguments.
         (⊂[i]m↑[i]⍺)⍳⊂[j]m↑[j]⍵     ⍝ Get index.
     }
     m←0=⎕NC'⍺'                      ⍝ Monadic?
     m∧1=⍴⍴⍵:↑∘.,/∇¨⍵                ⍝ Vector right argument
     m∧80=⎕DR ⍵:AlphaInterval ⍵      ⍝ Alpha Monadic.
     m:(×⍵)×⍳|⍵                      ⍝ Integer Monadic.
     s←0=⍴⍴⍺                         ⍝ Scalar Left Argument?
     s∧80=⎕DR ⍵:⍺ AlphaInterval ⍵    ⍝ Alpha Interval.
     s:⍺ Interval ⍵                  ⍝ Numeric Interval.
     ⍺ IndexOf ⍵                     ⍝ Dyadic.
 }

 isFrequency←{
     ⎕IO←0 ⋄ ⎕ML←3
     2∨.≠(⍴,↑∘⌽)⍴⍵:0   ⍝ Must be 2-column matrix
     1≠≡FR←⍵[;1]:0     ⍝ Can't be nested
     0∨.>FR:0          ⍝ Can't be negative
     FR≡⌊FR:1          ⍝ If integers, ok
     1=+/FR            ⍝ If sums to 1, ok
 }

 isNamespace←{9=⎕NC'⍵'}

 load←{
       ⍝⍺ Directory (optional)
       ⍝⍵ List of Namespaces, '' = All
     ⍺←'E:\TamStat\TamStatScript\'  ⍝ Default directory
     x←{0≠≢⍵~' ':⍵
         'Operators,Distribution,Graph,Summary,Relational,Regression,Util,Arithmetic,UserInterface'}⍵
     ⊃⍺∘{str←'#.TamStat.',⍵,' ',⍺,⍵
         ⎕SE.SALT.Load ⍺,⍵'-target=#.TamStat'}¨toNestedVector x
 }

∇ {DIR}loadSALT NS;STR
     
       ⍝⍺ Directory (optional)
       ⍝⍵ List of Namespaces, '' = All
 ⎕IO←0 ⋄ ⎕ML←3
 :If 0=⎕NC'DIR'
     DIR←'E:\TamStat\TamStatScript\'  ⍝ Default directory
 :EndIf
 :If 0=⍴NS~' '
     NS←'Operators,Distribution,Graph,Summary,Relational,Regression,Util,Arithmetic,API,GUI,Help'
 :EndIf
 NS←toNestedVector NS
 STR←{DIR,⍵,' -target=#.TamStat.',⍵}¨NS
 ⎕SE.SALT.Load¨STR
∇

∇ z←lockFunctions ns
      ⍝∇ Convert all dfns in namespace to trad fns and lock them
      ⍝⍵ Namespace
      ⍝⍎ lockFunctions #.TamStat.Distributions
 ⎕IO←0 ⋄ ⎕ML←3
 :With ns
          ⍝{c←⎕CR ⍵
     {c←⎕CR nm←⍵~' '
         b←∨/∘,∘∊¨'⍺' '⍺⍺' '⍵⍵' '⍵'⍷¨⊂c
         h←⊂'z←',{⍵=9:'∆ x'
             ⍵=8:'(f ∆)x'
             ⍵=11:'y(f ∆)x'
             ⍵=14:'(f ∆ g)x'
             ⍵=13:'y ∆ x'
             ⍵=15:'y(f ∆ g)x'
             ''}2⊥b
         2=⍴↑h:0
         h0←('∆'⎕R ⍵)¨h
         h1←((⍵,'←')⎕R'∆←')c[0;]
         _←⎕FX h0 h1,(1↓↓c),h
         3 ⎕LOCK ⍵
     }¨↓⎕NL 3 4
     
 :EndWith
∇

 makeContingency←{
     ⍝ Make contingency table
     ⍝ ⍵:  Namespace
     ⍝ ←:  Contingency Table
     ⎕IO←0 ⋄ ⎕ML←3
     F1 F2 O E D X2←↓⍉¯1↓1↓⍵  ⍝ Strip off 1st,last rows
     H←∪¨F1 F2                ⍝ Get headers
     SH←≢¨H                   ⍝ Get shape
     O E←SH∘⍴¨O E
     RT←+/E
     CT←+⌿E
     OE←O{⍪⍺,⍵,' '}¨E
     T←(OE,RT)⍪CT,+/CT
     H←{⍵,[¯0.5]¨' '}¨H,¨⊂⊂'Total'
     T←⍕('*',0⊃H),(1⊃H)⍪T
     ⍕2 1⍴T(⊃'Key: Observed' '     Expected')
     
     
     
     
     
     
 }

 makeContingencyTable←{
     ⍝∇ Create a contingency table
     ⍝⍺ RowNames;ColumnNames
     ⍝⍵ Data
     ⍝← Contingency Table
     ⍝⍕ 'RowName1,..,RowNameM;ColName1,...ColNameN' makeContigencyTable X
     RN CN←toNestedVector¨';'toNestedVector ⍺
     Body←(≢¨RN CN)⍴⍵
     ('*',CN)⍪RN,Body
 }

 matrize←{2=⍴⍴⍵:⍵
        ⍝  toNestedVector ⍺
     ⎕IO←0 ⋄ ⎕ML←3
     ⍉⊃toNestedVector¨⍵}

 mgof←{⍝ Multinomial/Uniform goodness of fit test
     ⎕IO←0 ⋄ ⎕ML←3
        ⍝  w p←{'*'≡↑⍵:{(⍵[;0 1])(↓⍉⍵[;0 2])}(1↓⍵) ⋄ ⍵ ⍬}↑⍵
     w p←{'*'≡↑⍵:{(⍵[;0 1])(↓⍉⍵[;0 2])}(1↓⍵)
         3≠≢⍉⍵:⍵ ⍬
         2=⍴⍴⍵:(⍵[;0 1])(↓⍉⍵[;0 2])
         (⍉⊃toNestedVector¨2↑⍵)(1 0 1/⍵)}↑⍵
     d←⊂⍵[1]⊃'Multinomial' 'Uniform' ⍝ Multinomial or uniform?
     v obs←↓⍉{(2=⍴⍴⍵)∧~(⎕DR ⍵)∊80 82 160 320:⍵   ⍝ Non character matrix
         (2=≢⍵)∧1<≡⍵:(toNestedVector↑⍵),[0.5]1⊃⍵ ⍝ 2-item vector, make into matrix
         frequency ⍵}w               ⍝ make frequency
     n←+/obs                         ⍝ Sample size
     k←≢v                            ⍝ Number of categories
     exp←k/n÷k                       ⍝ Expected values
     p←(⍺≡⍬)⊃⍺ p                     ⍝
     p←⍵[1]⊃p ⍺                      ⍝ Get proportions
     ⍵[1]∨p≡⍬:d ⍬,gof v obs exp      ⍝ Uniform output
     p←{2=⍴⍴⍵:↓⍉⍵ ⋄ ⍵}p              ⍝
     i←v⍳v1←toNestedVector↑p         ⍝
     exp←n×{⍵÷+/⍵}1⊃p                ⍝ Expected Values
     obs←(obs,0)[i]                  ⍝ Observed Values
     d ⍬,gof v1 obs exp}

 minimax←{
     ⍝⍵ is a payoff table
     ⍝← is the index of the decision
     ⎕ML←3 ⋄ ⎕IO←0
     {⍵⍳⌊/⍵}⌈/⍵}

 nameSpace←{⎕NS ⍵}

 ngof←{
      ⍝∊ Written by Steve Mansour
      ⍝∇ Normal goodness Of Fit
      ⍝⍵ Numeric Vector or 2-column Vector
      ⍝← Parameters
      ⍝← Degrees of freedom
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←⍬                      ⍝ Initialize everything
     W←{2=≢⍵:⍉⊃⍵ ⋄ ⍵}⍵                        ⍝ Normal goodness of fit
     (M S N)←(mean,sdev,count)W               ⍝ Get mean, sdeV, count
     f←{(V OBS)←↓⍉⍵                           ⍝ Frequency
         INT←2+/V÷2                           ⍝ InterVals
         P←M S∘(normal prob between)¨2,/INT   ⍝ middle probabilities
         P←¯1⌽P,|1 0-M S normal prob≤¯2↑1⌽INT ⍝ lower and upper prOBS
         EXP←P×N                              ⍝ Expected values
         ↓⍉5 combinePartitions V,OBS,[0.5]EXP}⍝ Combine groups of < 5
     g←{⍺←5⌈20⌊⌊N÷10                          ⍝ Set bins or use default
         P←(1↓⍳⍺)÷⍺                           ⍝ Get cumulative probs
         Z←M S normal criticalValue>P         ⍝ Find boundary points
         OBS←{⍺,≢⍵}⌸Z⍸W                       ⍝ Put into values into buckets
         OBS←⍺{(⍵⍪0)[⍵[;0]⍳¯1+⍳⍺;1]}OBS       ⍝ Sort in ascending order
         Z←Z round⍨10*5-⍨⌈/⌈10⍟|Z~0           ⍝ Round to 5 decimal places
         V←(1⌽⍺↑1)⌽¨2,/'<',Z,'>'              ⍝ Include <,> for tails
         V←{⍺,(⍺∊'<>')↓'-'⍵}/¨V              ⍝ Insert dashes
         EXP←N×⍺⍴÷⍺                           ⍝ Expected values
         V OBS EXP}                           ⍝ Result
     (V OBS EXP)←⍺{B←2⊥(1=⍴⍴⍵),⍺≢⍬            ⍝ Determine which function
         B=0:f ⍵ ⋄ B=2:g ⍵ ⋄ ⍺ g ⍵}W          ⍝ to use
     DF←¯3+≢V                                 ⍝ Degrees of Freedom
     'Normal'(M S),DF gof V OBS EXP}

 nonParametricReport←{
     ⎕IO←0 ⋄ ⎕ML←3
     SS←⎕UCS 8321+⍳≢⍵.Estimate                ⍝ Subscripts
     D←↓('X',⍪SS),'=',⍕⍪⍵.Estimate
     D←⍕D,[¯0.5]↓('n',⍪SS),'=',⍕⍪⍵.SampleSize
     h0←'H₀: ',1↓,'=','η',⍪SS                  ⍝ One-sample test; null statement
         ⍝ D←D,[¯0.5]⍨(D='X')\'~'
     D←⊃('~'\⍨D[0;]='X')⍪D
     h1←'H₁: At least one median is different.'         ⍝ Alternative statement
     C←⊂'Test Statistic:'('χ²=',⍕⍵.TestStatistic)
     C,←⊂'P-Value:'('p'fmtP ⍵.P)
     X2←⍵.DegreesOfFreedom chiSquare criticalValue<⍺
     C,←⊂'Critical Value:'(' '~⍨'χ²(⍺;df=',(⍕⍵.DegreesOfFreedom),')=',8 3⍕X2)
     C,←⊂'Significance Level:'('α=',⍕⍺)
     Z←(⍵.P<⍺)⊃'Fail to reject H₀' 'Reject H₀'
     Z←##.Ho_Available/'Conclusion:  ',Z
     ⍕⍪'Kruskal-Wallis Test'D' 'h0 h1(tablebox 2 2⍴⊃¨C)Z
     
     
     
 }

 outliers←{
     ⍝∇   Find outliers in a sample
     ⍝⍺   Method Bs 0=Quartile method, 1=Chauvernet's criterion
     ⍝⍵   Sample Xv Sample Data
     ⍝←   List   Xv List of outliers
     ⍝⍕   List←[Method|_0] outliers Sample
     ⍝⍎   50 ← outliers 9 10 10 10 11 50
     ⍝⍎   50 ← 1 outliers 9 10 10 10 11 50
     ⎕IO←0 ⋄ ⎕ML←3
     ⍺←0
     ⍺=1:⍵~{m s←(mean,sdev)⍵            ⍝ Get mean, sdev
         d←normal criticalValue<÷4×≢⍵   ⍝ Find Dmax
         (d≥(⍵-m)÷s)/⍵}⍣≡⍵              ⍝ Remove outliers and recalculate
     ⍺=2:'*'
     b←{⍵+1.5×1 ¯1×-/⍵}1 3 quartile ⍵   ⍝ Create lower and upper fence values
     (⍵ outside b)/⍵                    ⍝ Select values outside the fence
 }

 package←{
       ⍝⍺ Directory (optional)
       ⍝⍵ List of Namespaces, '' = All
     ⎕IO←0 ⋄ ⎕ML←3
     ⍺←'F:\TamStat\TamStatScript\'  ⍝ Default directory
     x←{0≠≢⍵~' ':⍵
         'Operators,Anova,NonParametric,Arithmetic,Distribution,Graph,Summary,Relational,Regression,Util,UserInterface,KokoStats,API,GUI'}⍵
            ⍝ ⎕SE.SALT.Save'#.TamStat.Operators G:/TamStat/Operators'
     ⊃⍺∘{str←'#.TamStat.',⍵,' ',⍺,⍵
         ⎕SE.SALT.Save str}¨toNestedVector x
 }

 pgof←{⎕IO←0 ⋄ ⎕ML←3
         ⍝⍝ Poisson goodness of fit
     w←{2=≢⍵:⍉⊃⍵ ⋄ ⍵}⍵                ⍝ Poisson goodness of Fit ⍝⍝⍝⍝⍝⍝
     (L N)←(mean,count)w              ⍝ Mean, count
     v obs←↓⍉1 frequency w            ⍝ Get frequencies
     exp←N×L poisson prob≥vv←1+↑⌽v    ⍝ Upper tail probability
     exp,⍨←N×L poisson v              ⍝ Poisson probabilities
     d←(v,vv),(obs,0),⍪exp            ⍝ Values,Observed,Expected
     d←5 combinePartitions⍣(3≤≢d)⊢d   ⍝ Combine groups of < 5
         ⍝ d←{(b⊃'≥≤'),↑(b←0∊⍵)⌽⍵}¨@(1=≡¨)d ⍝ Use ≤ and ≥ for groups
     d[0;0]←⊂{1=≢⍵:⍵ ⋄ '≤',⌈/⍵}↑d[0;0] ⍝ First items(s)
     k←¯1+≢d                           ⍝ Number of categories
     d[k;0]←⊂'≥',⌊/↑d[k;0]             ⍝ Last items(s)
     'Poisson'L,(k-1)gof↓⍉d}

 pick←{⍝ select from a nested array
     ⍺⊃⍵}

∇ z←rAv
 :Trap 0
     z←##.R_Available
 :Else
     z←0
 :EndTrap
∇

 randmatstat←{
      ⍝∊ Written by Steve Mansour
      ⍝⍵ Positive scalar integer
      ⍝← 2-item floating-point vector
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ n←5
     vw←⊃{X←normal randomVariable 4 n n ⍝ Generate random data in TamStat
         (a b c d)←⊂[1 2]X              ⍝ Create four random 5x5 matrices
         P←a,b,c,d                      ⍝ 5 × 20 matrix
         Q←(a,b)⍪c,d                    ⍝ 10 x 10 matrix
         v←+/0 0⍉4*⍨(⍉P)+.×P            ⍝
         w←+/0 0⍉4*⍨(⍉Q)+.×Q            ⍝
         v,w}¨⍳⍵                        ⍝
     (sdev÷mean)¨↓⍉vw                   ⍝
 }

 randomGivenMean←{
     ⍝∇: Generate a random variable with a specified min, max and mean
     ⍝∊: Written by Steve Mansour
     ⍝⍺: Lower Bound
     ⍝⍺: Upper Bound
     ⍝⍵: Mean
     ⍝⍵: Sample Size
     ⍝←: Random Variable with min > L, max < U and mean = M
     ⍝⍎: X←2 10 randomGiven mean 5 100
     ⍝⍎: 2.3246 7.52 4.82←(⌊/,⌈/,+/÷≢)X ⍝ (min,max,mean)X
     L U←⍺ ⋄ M N←⍵                 ⍝ Unpack left/right args
     P←(2-/U M L)(16808⌶)'Beta'N   ⍝ Generate random Variable
     U+P×L-U                       ⍝ Scale result
 }

 randomStat←{
     ⍝⍵ = scalar integer
     ⎕IO←0 ⋄ ⎕ML←3
     n←5
     v←1 ⍵⍴0
     w←1 ⍵⍴0
     vw←⊃{a b c d←normal randomVariable¨⊂n n
         P←a,b,c,d
         Q←(a,b)⍪c,d
         v←+/0 0⍉4*⍨(⍉P)+.×P
         w←+/0 0⍉4*⍨(⍉Q)+.×Q
         v,w}¨⍳⍵
     (sdev÷mean)¨↓⍉vw
 }

 rank←{
     ⍝ Rank any array taking ties into account
     ⍝⍵ Any array
     ⍝← Numeric vector
     ⍝⍎7 8 4 5.5 2.5 5.5 2.5 1←rank 5 6 3 4 2 4 2 1
     1+(+/⍵∘.>⍵)+0.5×¯1++/⍵∘.=⍵
     
 }

 remove←{
     ⍝⍺  DataSet
     ⍝⍵  List of values or Boolean mask
     ⍝⍵  Subset of ⍺
     ⎕IO←0 ⋄ ⎕ML←3
     a w←toNestedVector¨⍺ ⍵
     b←11=⎕DR¨⍺ ⍵      ⍝ Boolean?
     e←=/≢¨a w         ⍝ Equal lengths?
     ∧/b,e:'Ambiguous' ⍝ If both, ambiguous
     ~e:a~w            ⍝ If not equal, use without
     b[1]:(~w)/a       ⍝ If r.a. boolean mask
     a~⍵               ⍝ Else use without
 }

 removeNulls←{
     ⍝ Remove Nulls from left and right arguments and adjust sizes for all vectors
     ⍝ ⍺ Vector or vector of vectors
     ⍝ ⍵ Vector or vector of vectors
     ⍺←⎕NULL ⋄ ⎕IO←0 ⋄ ⎕ML←1    ⍝ Default left arg
     9=⎕NC'⍵':⍺ ∇ ⍵⍎¨↓⎕NL 2     ⍝ If namespace extract variables
     NULL←(0=≡⍺)⊃⎕NULL ⍺        ⍝ User may specify item
     f←NULL∘{(∧/⍺≠⍵)/¨⍵}        ⍝ Test and remove nulls and corresponding items
     0=≡⍺:⊆⍣¯1⊢f⊆,⍵             ⍝ Monadic form; unnest if simple
     A W←⊆¨⍺ ⍵                  ⍝ Enclose if necessary
     A W←(1 ¯1×A,⍥≢W)↑¨⊂f A,W   ⍝ Remove nulls
     ⍺ ⍵{⊃⍣(1=≡⍺)⊢⍵}¨A W        ⍝ Unnest if necessary
 }

 replicate←{⍺/⍵}

 report←{⍺←0.05 ⋄ ⎕ML←3 ⋄ ⎕IO←0
          ⍝⍟ Copyright (c) 2024 by Stephen Mansour
          ⍝∇ Generate a report from a namespace
          ⍝∊ Utility Function
          ⍝⍺ [Significance] Ps Signficance Level - Default = 0.05
          ⍝⍵ NameSpace     W   Contains results of statistical test
          ⍝← Result        Cm  Readable Report
          ⍝⍕ Result←[Significance|_0.05] report NameSpace
          ⍝⍎ report Height regress ShoeSize          ⍝ Regression Report (⍺=0.05)
          ⍝⍎ report oneWay anova Height Party        ⍝ ANOVA Report      (⍺=0.05)
          ⍝⍎ report 0.1 Height mean hypothesis = 68  ⍝ Hypothesis report (⍺=0.01)
           ⍝  0::⍵                                       ⍝ If Error just get out with error message
     2=⎕NC'⍵':{
         r d←{0≢↑0⍴↑⍵:⍵ 0                          ⍝ IF text
             r←{⍵∘.+0.5 ¯0.5×↑2-/⍵}⍵               ⍝ Range
             d←{10+0.1×0⌈10-⍵+5}⌈/⌈10⍟|,r              ⍝ Decimal places
             r[;1]-←10*-10×1|d
             r d}⍵[;0]
         c←+⍀⍵[;1]             ⍝ Cumulative
         p←{⍵÷+⌿⍵}⍵[;1]        ⍝ Proportion
         cp←c÷↑⌽c              ⍝ cum proportion
         x←r,⍵[;1],c,p,[0.5]cp ⍝ Assemble columns
         L←≢x                  ⍝ Last row
         x←(L+1)↑x             ⍝ Append
         b←5=1⊃⍴x              ⍝ 5 or 6 columns?
         x[L;2 3 4 5-b]←2/(+/¯1↓x[;2-b])1 ⍝ Totals
         x←b{⍺:(' ',9↑[1]⊃⍵[;0]),0 1↓⍵ ⋄ ⍵}x
         FMT←b{⍺:'10A1'        ⍝ 1st column character?
             ('2M<->','FI'[⍵=⌊⍵]),⍕⍵}d
         FMT,←',2I10,2Q<%>K2F10.2'⍝ Format string
         Z←FMT ⎕FMT x          ⍝ Format data
         Z[;(~b)/11]←'-'       ⍝ Dashes for ranged data
         W←10+10×~b
         Z[L;⍳W]←W↑'   Total'⍝ Label for total
         D←(60-10×b)⍴1 9/' -'  ⍝ Align dashes
         Z←D⍪Z[⍳L;]⍪D⍪Z[,L;]   ⍝
         H←b⊃('From' 'To')(⊂'Category') ⍝
         H,←'Frequency' 'Cum Freq' 'Percent' 'Cum Pct'
         Z⍪⍨∊¯10↑¨H            ⍝ Affix header
     }⍵
     dd←⍕⍺{
         ⍵.Type≡'Regress':⍵._Report
         ⍵.Type≡'Non-Parametric':⍺ nonParametricReport ⍵
         ⍵.Type≡'ANOVA':⍺ anova_report ⍵
         (⍵.Type≡'GoodnessOfFit')∧0=≢⍵.DegreesOfFreedom:⍺ npgofReport ⍵
         (⊂⍵.Type)∊'GoodnessOfFit' 'Independent':⍺ chiSquare_report ⍵
         ra←⍵._Relation
         ro←('<≠>'⍳ra)⊃'≥=≤'                   ⍝ Null must contain equality
         x←⍵._HypothesizedValue                ⍝ One or two samples?
         p←⍵._Parameter,⍵._Paired/'d'
         f1←{h0←'H₀: ',p,ro,⍵                  ⍝ One-sample test; null statement
             h1←'H₁: ',p,ra,⍵ ⋄ h0 h1}         ⍝ Alternative statement
         f2←{p1 p2←{(↑p),⍵,1↓p}¨'₁₂'           ⍝ Two-sample test
             h0←'H₀: ',p1,ro,p2                ⍝ Null Statement
             h1←'H₁: ',p1,ra,p2 ⋄ h0 h1}       ⍝ Alternative statement
         h←x{1=⍵._Populations:f1⍕⍺ ⋄ f2 ⍺}⍵    ⍝ For hypothesized value, use one-sample test
         (⍵._Claim⊃h),←' (Claim)'              ⍝ Indicate claim
         d←⍵.(_Populations SampleSize){
             P N←⍺
                  ⍝∧/⍵∊'µ⍴':'t'
             ∨/⍵∊'µ⍴β':'t'
             ⍵≡'p':'Z' ⋄
             (⍵≡'η')∧(P=1)∧25≥↑N:'X'
             (⍵≡'η')∧(P=2)∧10≥↑N:'U'
             ⍵≡'η':'Z'
             P=1:'χ²'
             'F'}⍵._Parameter
         d←d{⍵∧⍺≡'X':'T' ⋄ ⍺}⍵._Paired
         tb←⊃'Test Statistic: '(d,'=',⍕⍵.TestStatistic)
         tb←tb(⊃'P-Value: '('p'fmtP ⍵.P))
         cv←'(α',((⍵._Relation='≠')/'/2'),{(0<≢⍵)/';df=',⍕⍵}⍵.DegreesOfFreedom
         cv1←⍺ d{sig d←⍺ ⋄ p←sig÷1+⍵._Relation='≠'
             df←⍵.DegreesOfFreedom
             't'=↑d:df tDist criticalValue<p
             'Z'=↑d:normal criticalValue<p
             'U'=↑d:⍵.SampleSize mannWhitneyU criticalValue>p
             'χ²'≡d:df chiSquare criticalValue<p
             'X'≡d:¯1+(df,0.5)binomial criticalValue≥p
             'T'≡d:¯1+(⍵.SampleSize,0.5)binomial criticalValue≥p
             'F'=↑d:df fDist criticalValue<p
         }⍵
         cv←d,cv,')=',,⍕cv1
         cv←(';df='⎕R';N=')⍣('X'≡d)⊢cv
         tb←tb,(⊃'Critical Value:'cv)(⊃'Significance Level:'('α=',⍕⍺))
         tb←tablebox 2 2⍴tb
         wi←1⊃⍴tb
         tb←(wi↑⍕(⌊wi÷2)↑¨h)⍪tb
         C←(⍵.P<⍺)⊃'Fail to reject H₀' 'Reject H₀'
         tb←tb⍪wi↑' Conclusion: ',C
         d←{⍝i←('µpση⍴',⊂'σ²' )⍳⊂⍵._Parameter
             i←'µpση⍴β'⍳↑⍵._Parameter
                 ⍝st←i{⍺≠0:⍺⊃'XpsXr',⊂'s²' ⋄ ⍵⊃'Xd'}⍵._Paired
             st←i{⍺≠0:⍺⊃'XpsXrb' ⋄ ⍵⊃'Xd'}⍵._Paired
             st,←1↓⍵._Parameter
             cat←{⍕2 1⍴⍺ ⍵}
             fc←{d←((2=≢⍵)⊃' ' '₁₂'),[0.5],⍵
                 fs←(⍵≡⌊⍵)⊃'LF15.5' 'LI15'
                 ↓(d[;0]⎕FMT⍨'<',⍺,'>,A1,<=>'),fs ⎕FMT d[;1]}
             d←st fc ⍵.Estimate
             d←⍕(i⊃'_^ ~  '){⊃⍺ ⍵' '}¨d
             d←d{0::⍺ ⋄ ⍺ cat('s','d'/⍨st≡'d')fc ⍵.StandardDeviation}⍵
             d←d cat'n'fc ⍵.SampleSize
             d←d cat'<Standard Error: >,LF15.5'⎕FMT ⍵.StandardError
             me←⍵.StandardError×cv1
             {(+/∧\⍵=' ')⌽⍵}(d∨.≠' ')⌿d}⍵
         ⍕,[⍳0]d' ' 'Hypothesis Test' ' 'tb}⍵
     dd←'─'⍪dd⍪'─'
     6::dd
     ##.Ho_Available:dd
     (~∨/'Conclusion:'⍷dd)⌿dd
 }

 reverse←{⍝ reverse a vector
     ⌽⍵}

 round←{⍺←1 ⋄ ⍺×⌊0.5+⍵÷⍺}

∇ Z←save Y∆;FN∆;tn;nms;b;v;⎕ML;⎕IO;i;ob;_
     ⍝⍵  Path/Filename of dcf file or ''
     ⍝←  Namespace containing values
 ⎕IO←0 ⋄ ⎕ML←3
 ob←↑Y∆
 :If 9=⎕NC'ob'
     {f←getform ⍵ ⋄ f.in.Text←'save '''''}ob
 :Else
     ⎕EX'ob'
     :With #
         ⎕ML←3 ⋄ ⎕IO←0
         nms←(variables #)~⊂'Y∆'
         FN∆←'Session.dcf'
         {22::0
             tn←⍵ ⎕FTIE 0
             ⍝ ob←'Msg'⎕WC'Msgbox' 'File Warning' 'Replace existing File?' 'Warn'
             ⍵ ⎕FERASE tn                ⍝ Erase current file
         }FN∆
         tn←FN∆ ⎕FCREATE 0                 ⍝ Create component file
         v←0↑I←1⍳⍨b←'['∊¨nms              ⍝ Namespaces
         :If 0∊b ⋄ v,←⍎¨I↑nms ⋄ :EndIf
         :If 1∊b
             v,←⎕OR¨('#.'∘,¨I↓nms)~¨⊂'[]'
         :EndIf
         nms ⎕FAPPEND tn                ⍝ Create Index into component file
         v ⎕FAPPEND¨tn                  ⍝ Write variable names to component file
         ⎕FUNTIE tn
     :EndWith
     Z←nms
 :EndIf
∇

 selectFrom←{
     ⍝⍟ Copyright (c) 2024 by Stephen Mansour
     ⍝∇ Select columns from a database
     ⍝∊ Database Function
     ⍝⍺ NameList Cv comma-delimited list of variable/column names
     ⍝⍵ Database W  Namespace containing Variables
     ⍝← Variable Nv If NameList refers to a single column in the Database
     ⍝← NewDatabase W If NameList refers to multiple columns in the Database
     ⍝⍕ NewDatabase←[NameList] selectFrom Database
     ⍝⍎ selectFrom D where D.State eq 'PA'
     ⍝⍎ 'Height,Party' selectFrom D where D.State in 'PA,NJ'
     ⎕IO←0 ⋄ ⎕ML←3
     0=⎕NC'⍺':⍵             ⍝ If no left argument, exit
     nms←(' '⎕R',')⍺      ⍝ Replace blanks with commas
     nms←toNestedVector nms ⍝ Convert to nested vector
     xpr←⍕nms'←⍵.('nms')'   ⍝ Build expression
     d←⍎xpr                 ⍝ Execute it
     1=≢nms:d               ⍝ If one item, create vector
     ns←⎕NS nms             ⍝ Else create namespace
     ns
 }

 showCov←{
     ⎕IO←0 ⋄ ⎕ML←3
     ⍺←0
     showFreq←{xd←(⍵[;0]-mean ⍵)∘.*1 2
         fr←1≠n←+/⍵[;1]                ⍝ Is this a frequency or a distribution?
         m s p←fr⊃'µσp' 'xsn'              ⍝ Parameter or statistic?
             ⍝ x←⍵÷⍤1⊢1,n*b
         g←≢⍵                           ⍝ Number of bins
         z←⍵,(×/⍵),xd,xd[;,1]×⍵[;,1]   ⍝ Differences
         z⍪←+⌿z
              ⍝z⍪←z[g;]÷n-0 0 0 0 0 1 1 1
         z←0.001 round z
             ⍝ z[g;0 3 4]←'Total' ' ' 'Var'
         z[g;0 1 3 4]←' '(m,' = ')' '(s,'² = ')
         z⍪←'    ',(s,' = ')(z[g;5]*÷2)
             ⍝ z⍪←'    ','Sdev'(z[g;5]*÷2)
             ⍝ z←'x' 'p' 'xp' 'x-x' '(x-x)²' '(x-x)²p'⍪z
         d2←'(x-',m,')²'
         z←'x'p('x',p)(1↓¯2↓d2)d2(d2,p)⍪z
         z←z⍪⍨fr⊃' ',⊂' ' ' ' '  ' '  _' '   _  ' '   _   '
         z}
     
     showRaw←{⍺∧.=0:(∇⍨⍵)[;0 1 3 6]
         n←≢⍵
         xd yd←⍺ ⍵-mean¨⍺ ⍵
         z←(1+⍳n),⍺,⍵,xd,yd,(xd×yd),⍉⊃xd yd*2
         z⍪←+⌿z
         z⍪←z[n;]÷n-0 0 0 0 0 1 1 1
         z←0.0001 round z
         z[n+0 1;0]←'Total' 'Mean'
         z[n+1;4]←⊂'Cov'
         z⍪←¯8↑' ' 'Corr',z[n+1;5]{⍵,⍨⍺÷×/⍵}sqrt z[n+1;6 7]
         z←'n' 'x' 'y' 'x-x' 'y-y' '(x-x)(y-y)' '(x-x)²' '(y-y)²'⍪z
         z←' ' ' ' ' ' '  _' '  _' '   _    _ ' '   _  ' '   _  '⍪z
         z}
        ⍝  b←⍺≡0
     
     z←⍺{2=⍴⍴⍵:showFreq ⍵ ⋄ ⍺ showRaw ⍵}⍵
     b←⍺∧.=0
     b←2≠⍴⍴⍵
     z[b/3 4+≢⍵;2]←b/'Var' 'Sdev'
     ⍵{n←≢⍺
         ⍵[0 1;]⍪'-'⍪⍵[2+⍳n;]⍪'-'⍪(2+n)↓⍵}⍕z
 }

 sort←{
     ⎕ML←3 ⋄ ⎕IO←0
     0=↑∊0⍴⍵:⍵[⍋⍵]
     d←toMatrix ⍵
     m←d[⍋⊃d;]
     2=⍴⍴⍵:m
     2=≡⍵:toNestedVector m
     toDelimitedList m}

 splitBy←{
      ⍝⍟ Copyright (c) 2018, by Stephen Mansour
      ⍝∊ Selection Function
      ⍝∇ Split a variable into two groups.
      ⍝⍺ Variable Xv Any Vector or vector representation
      ⍝⍵ BinaryVector    Bv Any Vector or vector representation whose length is the same as ⍺
      ⍝⍵ SelectionVector Ev If ⍵ is not Boolean, create Boolean in relation to first element
      ⍝← Result Ev 2-item vector
      ⍝⍕ Result←Vector splitBy BinaryVector|SelectionVector
      ⍝⍎  Male Female ← Height splitBy Sex eq 'M'
      ⍝⍎  Female Male ← Height splitBy Sex eq 'F'
      ⍝⍎  X Y ← Height splitBy Sex
     ⎕IO←0 ⋄ ⎕ML←3
     a←toNestedVector ⍺           ⍝ Convert left argument to vector
     ∧/,⍵∊0 1:/∘a¨⍵(~⍵)           ⍝ If right arg boolean, divide into two groups
     w←{⍵∊⍵[0]}toNestedVector ⍵   ⍝ Else make first element of ⍵ is "success"
     /∘a¨w(~w)                    ⍝ Then divide into two groups
 }

 standardOrder←{
     ⍝ Put the right argument into standard order
     ⍝        standard order 'ab'
     ⍝  ⍬ 'a' 'b' 'ab'
     ⍝        standard order 'abc'
     ⍝  ⍬ 'a' 'b' 'ab' 'c' 'ac' 'ab' 'abc'
     ⍝  ⍵ Character string
     ⎕IO←0 ⋄ ⎕ML←1
     Z←(⊂''){⍺←
         0=≢⍵:⍺
         (⍺,⍺,¨⊃⍵)∇ 1↓⍵}⍵
     3=I←'Aa'⍳⊃⍵:Z
     (I⌷'I',⊂'(1)')@0⊢Z
 }

 tablebox←{
     ⎕ML←3 ⋄ ⎕IO←0
     s←{¯2↑1 1,⍴⍵}¨⍵               ⍝ Header, Footer
     w←s⍴¨⍵
     ch←⌈/↑¨s                     ⍝ Max row width
     rw←⌈⌿↑∘⌽¨s                   ⍝ Max col height
     d←(ch∘.,rw)↑¨w                   ⍝ Dimensions
     tl tr bl br vt hz←'┌┐└┘│─'   ⍝ Top left, top right, ..
     cl c cr tc bc←'├┼┤┬┴'
     dd←{z←(⍵,vt)⍪hz
         ((¯1+⍴z)⌷z)←c
         z}¨d
     z←hz⍪vt,↑⍪/,/dd
     f←{1↓¯1↓⍵/⍳⍴⍵}
     cb←f z[1;]=vt
     rb←f z[;1]=hz
     i j←¯1+⍴z
     z[0;cb]←tc ⋄ z[i;cb]←bc
     z[rb;0]←cl ⋄ z[rb;j]←cr
     cr←0,¨¯1+⍴z
     (cr⌷z)←2 2⍴tl tr bl br
     z
 }

 take←{
     ⎕ML←1 ⋄ ⍺↑⍵}

 to←{⍝
        ⍝⍺ Start
        ⍝⍵ End[Step]
        ⍝← Start ... End
     ⎕IO←0
     ⍺←1
     end step←2↑⍵,1
     n←⌈1+(end-⍺)÷step
     ⍺+step×⍳n}

 toDelimitedList←{
     ⎕ML←3 ⋄ ⎕IO←0
     ⍺←','
     ⍝     (1=≡⍵)∧2>⍴⍴⍵:,⍵                   ⍝ Already list or numeric
     
         ⍝ 2=≡⍵:1↓∊⍺,¨deleteExcessBlanks¨⍵   ⍝ Vector of vectors
     (80≠⎕DR ⍵)∨2=≡⍵:1↓∊⍺,¨deleteExcessBlanks¨⍵   ⍝ Vector of vectors
     2=⍴⍴⍵:1↓∊⍺,¨deleteExcessBlanks¨↓⍵ ⍝ Matrix
     ,⍵
 }

 toMatrix←{⎕ML←3 ⋄ ⎕IO←0
     ⍺←','
     2=⍴⍴⍵:⍵                            ⍝ Already matrix
     2=≡⍵:⊃deleteExcessBlanks¨⍵         ⍝ Vector of vectors
     ⊃deleteExcessBlanks¨(⍺≠⍵)⊂,⍵       ⍝ Delimited list
 }

 toNestedVector←{⎕ML←3 ⋄ ⎕IO←0
      ⍝⍟ Copyright 2025 by Stephen M. Mansour
      ⍝∇ Convert an object to a nested vector
      ⍝∊ Summary Function (Dyadic); Measure of Association
      ⍝⍺ [Y]          Ys  Delimiter or Number of items
      ⍝⍵ X            Xv  Raw Data
      ⍝← NV           Zv  Nested Vector
      ⍝⍕ Zv ← Y slope X
      ⍝⍎ toNestedVector 'John,Paul,George,Ringo'
      ⍝⍎ (2 4 8)(3 6 2) ← 2 toNestedVector 2 4 8 3 6 2
     ⍺←','                              ⍝ Default delimiter
     2=⍺:{2=≡⍵:⍵                        ⍝ slope Y X
         2=⍴⍴⍵:↓⍉⍣{2≠≢⍵}⍵               ⍝ slope Y,⍪X
         (0.5×≢⍵)(↑{⍺ ⍵}↓)⍵}⍵           ⍝ slope(Y,X)
     0=↑0⍴∊⍵:⍵                          ⍝ If numeric, leave alone
     2=≡⍵:deleteExcessBlanks¨,⍵         ⍝ Already nested vector
     2=⍴⍴⍵:deleteExcessBlanks¨↓⍵        ⍝ Matrix                                                         ←
     ⍺∊⍵:deleteExcessBlanks¨(⍺≠⍵)⊆⍵     ⍝ Delimited list
     ⊂deleteExcessBlanks ⍵              ⍝ Else make a scalar
 }

 transpose←{⍝ transpose a matrix
     ⍉⍵}

 twoSample←{
     ⍝∊ Written by Stephen Mansour
     ⍝∇ Identify two-sample data
     ⍝← 1 = two Samples, 0 = otherwise
     ⎕ML←1
     2≠≢⍵:0              ⍝ Does it contain exactly two items?
     1≠⍴⍴⍵:0             ⍝ Is it a vector?
     326≠⎕DR ⍵:0         ⍝ Is it simple?
     ⍵≡⍥(0∘⍴¨)'  ':0     ⍝ Two character vectors
     1}

 variables←{
      ⍝⍟ Copyright (C) 2018 by Stephen M. Mansour
      ⍝∇ List variables in a namespace
      ⍝∊ Utility Function
      ⍝⍺ B:  0=List top level variables, 1=list all variables, 2=Numeric Variables, 3=Character Variables
      ⍝⍵ NS:  Namespace
      ⍝← C:  List of variable names
      ⍝⍕ C ←  variables [#|NS]            ⍝ All variables in root
      ⍝⍎ A B [C] ← variables #            ⍝ Root has 2 vars and 1 NS
      ⍝⍎ A B C.U C.V C.W ← 1 variables #  ⍝ 3 addt'l vars in C
      ⍝⍎ U V W ← 1 variables C            ⍝ List only vars in C
      ⍝⍎ variables D                      ⍝
       ⍝   0::'Domain Error'              ⍝
     ⍺←0 ⋄ ⎕IO←0 ⋄ ⎕ML←3             ⍝ Default is top-level
     NS←{''≡⍵~' ':# ⋄ 2=⎕NC'⍵':⍎⍵ ⋄ ⍵}⍵ ⍝ Get namespace
     V DB←toNestedVector∘NS.⎕NL¨2 9  ⍝ Find vars, ns
     V←('_'≠↑¨V)/V                   ⍝ remove meta-variables
     ⍺=2:V/⍨{0=↑0⍴∊NS⍎⍵}¨V           ⍝ List only Numeric Variables
     ⍺=3:V/⍨{0≠↑0⍴∊NS⍎⍵}¨V           ⍝ List only Character Variables
     DB←DB~'TamStat' '_meta'         ⍝ Exclude TamStat namespace
     (⍺=0)∨0=≢DB:V,{'[',⍵,']'}¨DB    ⍝ If 0 or no ns, list vars
         ⍝ VV←∇∘⍎¨'⍵.'∘,¨DB                ⍝ Else apply to each namespace
     VV←∇∘⍎¨'NS.'∘,¨DB                ⍝ Else apply to each namespace
     V,↑,/DB{⍺∘,¨'.',¨⍵}¨VV          ⍝ Append to list
 }

 weightBy←{⎕ML←3 ⋄ ⎕IO←0 ⋄ ⍺,[0.5]⍵}

 where←{
     ⍝⍟ Copyright (c) 2024 by Stephen Mansour
     ⍝∇ Select rows from a database.  See also "selectFrom".
     ⍝∊ Database Function
     ⍝⍺ Database     W  Namespace containing Variables
     ⍝⍺ Column       Xv Single Variable in a Database
     ⍝⍵ Condition    Bv 1=Include row; 0=Don't include row
     ⍝← IncludedRows Xv If NameList refers to a single column in the Database
     ⍝⍕ IncludedRows←where Condition
     ⍝⍎ D.Height where D.Sex eq 'M'
     ⍝⍎ D.State D.Party where D.Age between 25 40
     ⍝⍎ D where D.State in 'PA,NY,NJ'
     ⎕IO←0 ⋄ ⎕ML←3
     9=⎕NC'⍺':⍺{v←↓⍺.⎕NL 2  ⍝ Variables
         _←⍎⍕v'←⍺.(⍵∘/¨'v')'
         ns←⎕NS v
         ↑ns}⍵
     d←≡⍺      ⍝ Check depth of left argument
     d≤1:⍵/⍺   ⍝ Single numeric
     d=3:(⍵/toNestedVector)¨⍺ ⍝ Nested character
     2=≡↑⍵:⍵/toNestedVector ⍺
     ⍵∘/¨⍺
 }

∇ z←(FunX HalfStep)ABN;a;b;n;ya;yb;yz;i
⍝∊ Written by Bill Koko
⍝∇ trial and error by half_stepping:  if you start correctly bracketed
⍝∇ it will always converge
⍝∇    argument:  two values of X that with have a funtion result of
⍝∇               opposite sign and the max number of steps (20 will
⍝∇               reduce the uncertainty to one-millionth of the A-B
⍝∇               gap.  default to 53 == 16 digits).

 a b n←3↑ABN,53

 z←a
 ya←FunX z
 :If ya=0 ⋄ :Return ⋄ :EndIf
 z←b
 yb←FunX z
 :If yb=0 ⋄ :Return ⋄ :EndIf

⍝  Check for bracketing
 z←⍬
 :If 0<ya×yb ⋄ :Return ⋄ :EndIf

 ⍝  start halving
 :For i :In ⍳n
     z←0.5×a+b
     yz←FunX z
     :If yz=0 ⋄ 'out' ⋄ :Return ⋄ :EndIf  ⍝  may as well quit with an exact root
     :If 0<yz×ya    ⍝  yz is on the same side as ya
         a ya←z yz
     :Else
         b yb←z yz
     :EndIf
 :EndFor

 ⍝  accept z

 :Return
∇

 SecAlg←{⍝Secant Algorithm      ⍝
     ⍺←100 ⋄ (P0 P1 Q0 Q1)←⍵    ⍝ Unpack
     11::P1                     ⍝ Exit with P1
     TOL←⎕CT×⌈/(|P0)⌈|P1        ⍝ Set tolerance
     P←P1-Q1×(P1-P0)÷Q1-Q0      ⍝ Apply algorithm
     P0←P1 ⋄ Q0←Q1 ⋄ Q1←⍺⍺ P1←P ⍝ Reassign variables
     (TOL∧.>|P-P0)∨⍺≤1:P1       ⍝ Check tolerance
     (⍺-1)∇ P0 P1 Q0 Q1         ⍝ Continue
 }


 coords←{
 ⍝⍟ Copyright (c) 2018 by Stephen M. Mansour
 ⍝∇ Calculate coordinates for distribution graphs
 ⍝∊ User Interface
 ⍝⍺ [Parameters]:   Distribution parameters (default 0 1)
 ⍝⍺⍺ fD:  Distribution function                                                                       `
 ⍝⍵⍵ fR:  Relational function, e.g.   eq, ne, gt, lt, ge, le, in, between                        `
 ⍝⍵  X:    Value(s)
 ⍝←  W:  Namespace containing coordinates and shading indicators
 ⍝←  Bounds, Shading, Thumb, Label, XY coordinates
 ⍝⍕ W ←  [Parms|0 1] fD coords fR X
 ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     ⍺←0 1 ⋄ ⎕ML←3 ⋄ ⎕IO←0                        ⍝ Default parameters (0,1)
     VarNames←'Bounds' 'Shading' 'Type' 'Thumb' 'Label' 'YX' 'Style'
     ⍝(⍺ ⍺⍺'Type')≡'Discrete':⍺ ⍺⍺ coordsD ⍵⍵ ⍵   ⍝ Is distribution discrete?
     0≠↑0⍴∊⍵:⍺ ⍺⍺{X←toNestedVector ⍵              ⍝ If value is character, assume multinomial
         Y←toNestedVector↑⍺
         Y←0 5 10 20 25 50{⍺[1+⍺⍸≢⍵]↑⍵}Y
         Bounds←1,1+N←⍴Y
         Shading←(Y∊X)=1 ⍵⍵ 1
         K←⌊0.5+100÷N
         Label←∊K↑¨Y
         Type←'Graph'
         Style←'Histogram'
         ⍝YX←(1⊃⍺),⍪1+⍳N
         YX←⍉⊃(1⊃⍺)(1+⍳N)
         Thumb←↑Y⍳X
         ⎕NS VarNames}⍵⍵ ⍵
     (⍺ ⍺⍺'Type')≡'Discrete':⍺ ⍺⍺{
         P←⍺ ⍺⍺⍳50                                ⍝ get probabilities
         P←((≢P)-(⌽P>0.001)⍳1)↑P                  ⍝ Translate probabilites to coordinates
         P←0,P,0                                  ⍝ Surround with zero probabilities
         P←P{⍺↑⍨↑(⍵≥≢⍺)/⍵}5 10 20 25 50           ⍝ Number of discrete values
         Bounds←¯1,¯2+N←≢P                        ⍝ Limits for TrackBar
        ⍝b←2 5∊⍨2⊥0 1 0 ⍵⍵ 0 0 1                  ⍝ ≤ or > ?
         b←2 5∊⍨2⊥,0 1 0 ⍵⍵ 0 0 1                 ⍝ ≤ or > ?
         Thumb←b⊃(⌈,⌊)Bounds[1]⌊⍵                 ⍝ Set thumb
         Shading←(¯1+⍳N)⍵⍵ ⍵                      ⍝ 1=Shade, 0=Clear
         FS←'I',⍕⌊0.5+100÷N                       ⍝ Format String
         Label←,FS ⎕FMT⍳⍴1↓P                      ⍝ X-Axis Labels
         Type←'Graph'                             ⍝
         Style←'Histogram'
         YX←P,⍪¯1+⍳N                              ⍝
         ⎕NS VarNames                             ⍝ Put into namespace
     }⍵⍵ ⍵    ⍝ Is distribution discrete?
     rel←∨/1 0 1 ⍵⍵ 0 1 1                         ⍝ Test relation
    ⍝w←rel{⍺:⍵ ⋄ ¯2↑(-⍵),⍵}⍎⍕⍵                  ⍝ Append negative for outside?
     w←rel{⍺≡1:⍵ ⋄ ¯2↑(-⍵),⍵}⍎⍕⍵                  ⍝ Append negative for outside?
     inf←1                                        ⍝
     lb ub←⍺ ⍺⍺ criticalValue>|0 1-0.001×inf      ⍝
     lb ub←(↑,↑∘⌽)L←ScaleDist lb ub               ⍝ Update lower and upper bounds
     lb←0⌊lb ⋄ Bounds←lb ub                       ⍝ Start lower bound at 0?
     r←ub-lb                                      ⍝ Get range
     x←lb+r×0.01×⍳101                             ⍝ Density domain
     y←⍺ ⍺⍺ x                                     ⍝ Density range
     y[0]←y[10<↑y]                                ⍝ If infinite, use y[1]
     YX←y,⍪x                                      ⍝ Merge the two
     Shading←¯2 0 2 ⍵⍵ 1                          ⍝ Shade area of interest
     Thumb←w                                      ⍝ Thump position
     ⎕PP←5                                        ⍝ 5 significant digits
    ⍝Label←1↓,¯12↑[1]⍕⍪{⍵×1E¯9<|⍵}lb+(ub-lb)×0.125×⍳9 ⍝ Tick marks
     Label←⍺{2>≡⍺:1↓,¯12↑[1]⍕⍪{⍵×1E¯9<|⍵}lb+(ub-lb)×0.125×⍳9  ⍝ Tick marks
         ¯12↑[1]⍕⍺[;,1]}⍵

     Type←'Graph' ⋄ Style←'Curve'                 ⍝ Continuous
     ⎕NS VarNames                                 ⍝ Put into namespace
 }


 coordsD←{
 ⍝⍟ Copyright (c) 2018 by Stephen M. Mansour
 ⍝∇ Calculate coordinates for discrete distribution
 ⍝∊ User Interface
 ⍝⍺ [Parameters]:   Distribution parameters (default 0 1)
 ⍝⍺⍺ fD:  Distribution function
 ⍝⍵⍵ fR:  Relational function, e.g.   eq, ne, gt, lt, ge, le, in, between
 ⍝⍵  X:    Value(s)
 ⍝← P:   Coordinates and shading indicators
 ⍝⍕ P ←  [Parms|0 1] fD coords fR X
     ⎕ML←3 ⋄ ⎕IO←0                      ⍝ Set system variables
     P←⍺ ⍺⍺⍳50                          ⍝ get probabilities
     P←((≢P)-(⌽P>0.001)⍳1)↑P            ⍝ Translate probabilites to coordinates
     P←0,P,0                            ⍝ Surround with zero probabilities
     P←P{⍺↑⍨↑(⍵≥≢⍺)/⍵}5 10 20 25 50     ⍝ Number of discrete values
     M←90×P÷⌈/P                         ⍝ Get relative heights
     Width←W←100÷N←≢P                   ⍝ Widths
     Rect←((90-M)((W÷4)+W×⍳≢M))(M(W÷2)) ⍝ Rectangle coordinates
     Bounds←¯1,¯2+N                     ⍝ Limits for TrackBar
     b←2 5∊⍨2⊥0 1 0 ⍵⍵ 0 0 1            ⍝ ≤ or > ?
     Thumb←b⊃(⌈,⌊)Bounds[1]⌊⍵           ⍝ Set thumb
     Shading←(¯1+⍳≢M)⍵⍵ ⍵              ⍝ 1=Shade, 0=Clear
     FS←'I',⍕⌊0.5+100÷N                 ⍝ Format String
     Label←,FS ⎕FMT⍳⍴1↓P                ⍝ X-Axis Labels
     ⎕NS'Rect' 'Bounds' 'Thumb' 'Shading' 'Label' 'Width' 'N'
 }


 evpi←{
⍝ ⍺ vector of probabilities
⍝ ⍺⍺ max or min
⍝ ⍵ payoff table
     ev←⍺⍺/⍵+.×⍺
     evwpi←(⍺⍺⌿⍵)+.×⍺
     |ev-evwpi}


 excluding←{
⍝⍺⍺  DataSet
⍝⍵⍵  Relation
⍝⍵   Value
⍝⍎   X excluding > 10
     ⎕IO←0 ⋄ ⎕ML←3
     2=⎕NC'⍵⍵':⍺⍺~⍵⍵,⍵   ⍝ X excluding 2,3
     '*'≡2 ⍵⍵ ⍵:⍺⍺~⍵⍵,⍵  ⍝ X excluding outliers X
     (~⍺⍺ ⍵⍵ ⍵)/⍺⍺       ⍝ X excluding > 1000

 }


 formatConfInt←{⍝cl←⍺,(0=≢⍺)/0.95        ⍝ If show operator,
 ⍝⍺ Confidence Level
 ⍝⍺ NameList
 ⍝⍵ Data
     ⎕IO←0 ⋄ ⎕ML←3
     NS←⎕NS''                            ⍝ Create namespace for output
     cl M NL←⍺ ⋄ G←1<≢NL                 ⍝ Level, Method, Name List
     cl,←(0=≢cl)/0.95                    ⍝ Default level to 95%
     cb←⊃,⍺⍺{C←cl∘.,⊂¨M                  ⍝ Various cases
         b←(twoSample ⍵)∧1=≢NL          ⍝ In two-sample case
         b:C ⍺⍺ confInt¨⊂⍵              ⍝ Apply to difference
         C∘.(⍺⍺{⍺ ⍺⍺ confInt ⍵})⍵}⍵     ⍝ Else apply individually
     pe←{G:⍺⍺¨⍵ ⋄ i←⍺⍺ 1 ¯1             ⍝ If not sdev or vari
         i∊¯1 0 3:-/⍺⍺¨⍵                ⍝ Use difference; else
         2≢≢¨⍵:÷/⍺⍺¨⍵                   ⍝ Two vectors or two frequencies
         ÷/↑⍺⍺¨¨⍵}                      ⍝ Else Two namespaces
     pt←M ⍺⍺{b←⍺⍺'Type'                 ⍝ If measure of position
         b≡'Quantity':⍺×mean ⍵           ⍝
         b≡'Position':⍺∘⍺⍺ pe ⍵
         ⍺⍺ pe ⍵}⍵                       ⍝ Point estimate
     M←{0≠↑↑0⍴⍵:⍵ ⋄                      ⍝ Blank out zeroes
         ⊂' '~⍨,'BG<N=ZZZZZZZ9>'⎕FMT ⍵}M ⍝ Format Population Size
     A S←XAxis,cb                        ⍝ Build axis
     I←↓⌊0.5+100×(A[0]-cb,(≢cb)⍴pt)÷-/A  ⍝ Find relative positons
     B←(⍳1⊃⍴S)∘between¨2↑¨I              ⍝ Include values between limits
     J←⊃B{B←⍺ ⋄ B[⍵]←2 3 4 ⋄ B}¨I⌊¯1+≢¨B ⍝ Find position on axis
     H←↓'K2Q<%>LI4 '⎕FMT cl              ⍝ Format conf level
     H←,{B←1<≢¨⍵ M NL
         ∨/B:↑∘.,/B/⍵ M(' ',¨NL)
         ⍵∘.,M∘.,' ',¨NL}H               ⍝ Append to group names
     FS←'<,>,M<->F10.',⍕0⌈5-⌈10⍟⌈/|A     ⍝ Build format string
     X←'(',(0 1↓FS ⎕FMT cb),')'          ⍝ Format limits
     X←(' '∨.≠X)/X                       ⍝ Remove blanks
     Z←(⊃H),X,' -()*'[J]                 ⍝ Assemble all values
     Z←Z⍪(2,-↑⌽⍴Z)↑S
     NS.Output←Z
     NS.Results←cb
     NS.PointEstimate←pt
     NS}


 pairwise←{
 ⍝⍟  Copyright (c) 2024 by Stephen M. Mansour
 ⍝∇  Apply dyadic function to each pair from vector on right
 ⍝∊  Operator
 ⍝⍺⍺  Delimeter  Cs Any Character scalar or empty vector ''
 ⍝⍺⍺  dyadicFn    f Any dyadic (preferably commutative) function
 ⍝⍵   Cv Cv Any character vector whose elements are in the domain of dyadFn
 ⍝⍵   Xv  Xv Any numric vector whose elements are in the domain of dyadFn
 ⍝←   Result    A vector of shape 2!≢⍵
 ⍝⍕   Cs|f pairwise Cv|Xv
 ⍝⍎   AB  AC  BC  AD  BD  CD ←  ,pairwise 'ABCD'
 ⍝⍎   2 3 6 4 8 12 5 10 15 20 ←  ×pairwise 1 2 3 4 5
 ⍝⍎   A,B  A,C  B,C   A,D   B,D   C,D ←   ',' pairwise 'ABCD'
 ⍝⍎ ('Bob' 'Joe')('Bob' 'Steve')('Joe' 'Steve')←''  pairwise 'Bob' 'Joe 'Steve'
     ⎕IO←0 ⋄ ⎕ML←3
     1≥≢⍵:0⍴⊂⍺⍺⍨↑⍵
     d←⍵ ⋄ op←⍺⍺ ⋄ ⍺←⍬ ⋄ a←⍺
     2=⎕NC'op':{0=≢op:⍺ ⍵ ⋄ ⍺ op ⍵}∇∇ ⍵
     0<≢a:{⍺,a,⍵}∇∇ ⍵
     op{⍺←0↑d
         z←⍺,(⍵↑d)⍺⍺¨⍵⌷d
         ⍵≥¯1+≢d:z
         z ∇ ⍵+1}1
 }


 pervasive←{1≥≡⍵:⍺⍺ ⍵ ⋄ ∇¨⍵}


 runR←{
⍝∇   Run TamStat function using R
⍝⍎   mean runR X
⍝⍎   normal prob > runR 2
⍝⍎   X cov runR Y
     ⍺←⎕NULL
     ∆←⍺⍺{⍺≡⎕NULL:⍺⍺ ⍵ ⋄ ⍺ ⍺⍺ ⍵}
     0::⍺{##.R_Available←0
         ⎕←'R not available for this function'
         ⍺ ∆ ⍵}⍵
     ##.R_Available←1 ⋄ Z←⍺ ∆ ⍵
     ##.R_Available←0 ⋄ Z}


 show←{⍺←⍬ ⋄
     Z←(0J1,⍺)⍺⍺ ⍵
     9≠⎕NC'Z':Z
     9=Z.⎕NC'ExtOut':Z   ⍝ Michael Baas - Extended output
     ⍕Z.Output}


 table←{
⍝⍟   Copyright (c) 2024 by Stephen Mansour
⍝∇   Create a function table
⍝⍺   RowValues      Xv  Parameters or left argument to function (optional)
⍝⍺⍺  fn             f   Dyadic Function or Distribution expression, e.g (normal prob <=)
⍝⍵   ColValues      Xv  Right argument to function
⍝←   DataTable      Xm  Matrix (Rows from left argument; columns from right argument)
⍝⍕   DataTable←[RowValues] fn table ColValues
⍝⍎    ×table 10     ⍝ Multiplication Table
⍝⍎    20 (.1 × ⍳ 10) binomial prob = table  ⍳ 20 ⍝ Binomial Table
⍝⍎    normal prob < 0 1 2 3 +table .1×¯1+⍳10     ⍝ Normal table
⍝⍎    (⍳3) tDist criticalValue < table  .05  .025 .1 ⍝ Student-t Table
⍝⍎    (⍳5) chiSquare criticalValue  < table .01 .025 .05 .1 .9 .95 .975  ⍝ ChiSquare Table
     ⎕IO←0 ⋄ ⎕ML←3
     la←×⎕NC'⍺'                        ⍝ Check for left argument
     x←⍵
     la<(2=⍴⍴⍵):⍺⍺ x
     ⍺←⍬
     (1∧.<≢¨⍺ ⍵)∧1∧.=≡¨⍺ ⍵:⍺∘.⍺⍺ ⍵     ⍝ If left and right vectors make table
     (1<≢⍺)∧2=≡⍺:⊃(↑∘.,/⍺)⍺⍺¨⊂x        ⍝ If scalar right argument, vary the parameters
     ⍝⍝⍝⍝⍝⍝⍝⍝⍝ New Code ⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝⍝
     b←(1 1 1≡×,≢,⊢=⌊)⍵                ⍝ If positive integer scalar
    ⍝w←b{⍺:1+⍳⍵ ⋄ ⍵}⍵                  ⍝ Make index generator
     w←(1+⍳)⍣b⊢⍵                       ⍝ Make index generator?
     ⍺≡⍬:∘.⍺⍺⍨w                        ⍝ If no left argument, generate a selfie
 }


 tableInverse←{
⍝∇ Table Inverse with interpolation
⍝⍟ (c) 2022 by Stephen Mansour
⍝⍺ Row Index
⍝⍵ Critical Value
⍝⍺⍺ Table
⍝← Probability from column headings (1st row)
⍝← If index is between row and/or column, interpolate
     ⎕IO←0 ⋄ ⎕ML←3
     1<⍺⌈⍥≢⍵:⍺ ∇¨⍵
     int←{(|⍺-⍵)÷-/⍵}                 ⍝ Interpolate function
     f0←{I←⍺⍺[;0]⍳⍺ ⋄ J←1+(1↓⍺⍺[I;])⍳⍵
         ⍺⍺[0;J]}
     f1←{RT←⍺⍺[;0] ⋄ CT←⍺⍺[0;]         ⍝ Row, Column Titles
         I←RT⍳⍺ ⋄ J←1+(1↓⍺⍺[I;])⍸⍵
      ⍝   X←⍺⍺[I;J+0 1]
⍝         Y←⍺⍺[0;J+0 1]
         X Y←↓⍺⍺{I J←⍵
             J<¯1+↑⌽⍴⍺:⍺[I 0;J+0 1]
             +\-\⍺[I 0;J-0 1]}I J
         Y[0]+(⍵-↑X)×Y÷⍥(-/)X
     }
     f2←{RT←⍺⍺[;0] ⋄ J←RT⍸⍺
         CT←⍺⍺[J+0 1;]+.×⍨⍺ int RT[J+1 0]          ⍝ Interpolate row
         J←1+(1↓CT)⍸⍵                            ⍝ Column Index
         J<¯1+≢CT:⍺⍺[0;J+0 1]+.×⍵ int CT[J+1 0]    ⍝ Interpolate column
         X Y←↓+\-\(⍉⍺⍺[0;],⍪CT)[;J-0 1]
         Y[0]+(⍵-↑X)×Y÷⍥(-/)X
     }
     (⍺∊⍺⍺[;0])∧⍵∊⍺⍺[(¯1+≢⍺⍺)⌊⍺⍺[;0]⍳⍺;]:⍺(⍺⍺ f0)⍵
     ⍺∊⍺⍺[;0]:⍺(⍺⍺ f1)⍵
     ⍺(⍺⍺ f2)⍵
 }


 tableLookup←{
⍝∇ Table lookup with interpolation
⍝⍟ (c) 2021 by Stephen Mansour
⍝⍺ Row Index
⍝⍵ Column Index
⍝⍺⍺ Table
⍝← Item corresponding to row and column
⍝← If index is between row and/or column, interpolate
     ⎕IO←0 ⋄ ⎕ML←3
     1<⍺⌈⍥≢⍵:⍺ ∇¨⍵
     f0←{RT←⍺⍺[;0] ⋄ CT←⍺⍺[0;]
         I←RT⍳⍺ ⋄ J←1⌈CT⍳⍵
         ⍺⍺[I;J]}
     f1←{RT←⍺⍺[;0] ⋄ CT←⍺⍺[0;]         ⍝ Row, Column Titles
         I←RT⍳⍺ ⋄ J←CT⍸⍵
         ⍝Y←⍺⍺[I;J+0 1]
⍝         X←⍺⍺[0;J+0 1]
         Y X←↓⍺⍺{I J←⍵
             J<¯1+↑⌽⍴⍺:⍺[I 0;J+0 1]
             +\-\⍺[I 0;J-0 1]}I J             ⍝  Project outward
       ⍝   ⌊Y[0]+(⍵-↑X)×Y÷⍥(-/)X
         Y[0]+(⍵-↑X)×Y÷⍥(-/)X
     }
     f2←{RT←⍺⍺[;0] ⋄ CT←⍺⍺[0;]         ⍝ Row, Column Titles
         I J←0 1∘+¨RT CT⍸¨⍺ ⍵          ⍝ Row, Column Indices
         Z←⍺⍺[I;J]                     ⍝ Extract data
         X←RT[I] ⋄ Y←CT[J]
         XY←X[0 0 1 1],⍪Y[0 1 0 1]
         A←(,Z)⌹1,XY,×/XY
         A+.×1 ⍺ ⍵,⍺×⍵}
     (⍺∊⍺⍺[;0])∧⍵∊⍺⍺[0;]:⍺(⍺⍺ f0)⍵
     ⍺∊⍺⍺[;0]:⍺(⍺⍺ f1)⍵
     ⍺(⍺⍺ f2)⍵
 }


 tolerant←{
     ⎕IO←0 ⋄ ⎕ML←3
     mon←{b←⍵≠⎕NULL       ⍝ Monadic Case
         z←⍺⍺ b/⍵         ⍝ Remove nulls
         1=≢⍺⍺ 1 2 3 4:z  ⍝ If summary function, done
         z←b\z            ⍝ Expand result
         ((~b)/z)←⎕NULL   ⍝ Fill with nulls
         (⍴⍵)⍴z}          ⍝ Done
     dya←{1=≢1 ⍺⍺ 1 1:⍺ ⍺⍺ ⍵~⎕NULL ⍝ Summary Function?
         x←⍺,[0.5]⍵        ⍝ Dyadic case
         b←x∧.≠⎕NULL
         x←b⌿x
         z←x[;0]⍺⍺ x[;1]
         1=≢⍺⍺⍨1 2 3:z
         z←b\z
         ((~b)/z)←⎕NULL
         z}
     ⍺←⎕NULL
     ⍺≡⎕NULL:⍺⍺ mon ⍵
     ⍺ ⍺⍺ dya ⍵}


 variant←{
⍝ Equivalent to variant operator
⍝ Allowed on user-defined functions
     ∆∆←⍵⍵                     ⍝ ∆∆ is passed globally to ⍺⍺
     0=⎕NC'⍺' ⋄ ⍺⍺ ⍵
     ⍺ ⍺⍺ ⍵}


 x2gof←{
 ⍝∊ Written by Steve Mansour
 ⍝∇ ChiSquare goodness Of Fit for continuous distributions
 ⍝⍺ Parameters (optional)
 ⍝⍺⍺ Distribution
 ⍝⍵ Numeric Vector or 2-column Vector
 ⍝← Parameters
 ⍝← Degrees of freedom
     ⎕IO←0 ⋄ ⎕ML←3 ⋄ ⍺←⍬                      ⍝ Initialize everything
     L←⍺ ⍺⍺{⍺≡⍬:⍺⍺ parameters ⍵ ⋄ ⍺}⍵            ⍝ Get parameters
     X←⍵[;0]+0.5×-/2↑⍵[;0]                  ⍝ Convert midpoints to lower bounds
     P←¯2-/1⌽1 0,L ⍺⍺ prob≤1↓X                ⍝ Get interval probabilities
     OBS←⍵[;1] ⋄ EXP←P×+/⍵[;1]                ⍝ Observed, Expected Values
     Z←L ⍺⍺ critVal>¯1↓+\P
     Z←Z round⍨10*5-⍨⌈/⌈10⍟|Z~0           ⍝ Round to 5 decimal places
     A←≢⍵
     V←(1⌽A↑1)⌽¨2,/'<',Z,'>'              ⍝ Include <,> for tails
     V←{⍺,(⍺∊'<>')↓'-'⍵}/¨V              ⍝ Insert dashes
     'Dist'L,(¯3+≢V)gof V OBS EXP}


:EndNamespace 
