﻿:Namespace tsCharts

    isWin←'Win'≡3↑1⊃#.⎕WG'APLVersion'
    _show←0 ⍝ set to 1 to show svg in HTMLRenderer for debugging

    ∇ showSvg svg;hr
      :Trap 0
          :If _show
              hr←⎕NEW'HTMLRenderer'(('HTML'svg)('Size'(75 75)))
              hr.Wait
          :EndIf
      :EndTrap
    ∇

    ∇ BuildDistSvg ns;⎕USING;data;⎕IO;⎕ML;splits;∆sharpplot;shading;drawingFn;System;Causeway;svgSize;colors;plotdata
      :Access public
      ⎕ML←⎕IO←1
     
    ⍝   :If isWin ⋄ ⎕USING←',sharpplot.dll' ',system.drawing.dll'
    ⍝   :Else
    ⍝       :If 0=#.⎕NC'Causeway' ⋄ 'Causeway'#.⎕NS''⋄Causeway.⎕CY'sharpplot' ⋄ :EndIf
    ⍝       System.Drawing←System←Causeway←Causeway
    ⍝   :EndIf
     
      :If 0=#.⎕NC'InitCauseway' ⋄ 'InitCauseway'#.⎕CY'sharpplot' ⋄ :EndIf
      #.InitCauseway ⍬
     
      :If 0=ns.⎕NC'svgColors' ⋄ ns.svgColors←'Gainsboro' 'Green ' 'Blue' 'Red' ⋄ :EndIf ⍝ was navy
      :If 0=ns.⎕NC'svgSize' ⋄ ns.svgSize←500 250 ⋄ :EndIf
     
      data←ns.YX
     
      ∆sharpplot←⎕NEW Causeway.SharpPlot
      ∆sharpplot.Reset ns.svgSize
      ⍝∆sharpplot.Gutter←0
      :If 2=ns.⎕NC'Margins'
          ∆sharpplot.SetMargins ns.Margins  ⍝ allow margin-control
      :EndIf
      ∆sharpplot.KeyStyle←Causeway.KeyStyles.NoKey
      ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.GridLines
     
      :Select ns.Style
      :Case 'Curve'
          splits←+/∧\ns.Thumb∘.≥data[;2] ⍝ can't use ⍸ because of ⎕CT
          data⌿⍨←(2@splits)(≢data)⍴1
          shading←(⍳1+≢splits)/⍨(≢data){(⍵,⍺)-0,⍵}splits+¯1+⍳≢splits
          drawingFn←∆sharpplot.DrawLineGraph
          ∆sharpplot.SetColors⊂System.Drawing.Color⍎¨3⍴(⊃ns.Shading)⌽2⍴⊆ns.svgColors
          ∆sharpplot.LineGraphStyle←Causeway.LineGraphStyles.SurfaceShading
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.GridLines
          ∆sharpplot.SplitBy shading ⍬
          data←↓[1]data
     
      :Case 'Histogram'
     
          drawingFn←∆sharpplot.DrawXBarChart
     
          ∆sharpplot.SetColors⊂System.Drawing.Color⍎¨,⊆ns.svgColors
          ∆sharpplot.BarLimit←10000
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.GridLines
          ∆sharpplot.XBarChartStyle←Causeway.XBarChartStyles.ExplodeAxes
          ∆sharpplot.SetXLabels⊂data[;2]
          ∆sharpplot.SetXTickMarks,⊂data[;2]
          ∆sharpplot.XTickStyle←Causeway.XTickStyles.MinorTicks
          ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.GridLines
          shading←{6::1 ⋄ ⍵.Shading}ns  ⍝ some paths in TamStat don't provide shading
          data←(⊂shading{⍵∘×¨(~⍺)⍺}data[;1]),⊂data[;2]
     
      :Else ⋄ ∘∘∘ ⍝ unknown graph type??
      :EndSelect
     
      drawingFn data
      showSvg ns.svg←PatchSVG ∆sharpplot.RenderSvg Causeway.SvgMode.FixedAspect
    ∇

    ∇ svg←labels BuildPredictSvg data;⎕ML;⎕IO;⎕USING;Causeway;System;∆sharpplot;range;min;max;group;points;lines
      ⎕ML←⎕IO←1
     
      :If 0=#.⎕NC'InitCauseway' ⋄ 'InitCauseway'#.⎕CY'sharpplot' ⋄ :EndIf
      #.InitCauseway ⍬
     
     
      lines←≢data
      (data labels)←⊖¨data labels ⍝ order graphs the same as data table
      ∆sharpplot←⎕NEW Causeway.SharpPlot
      ∆sharpplot.Reset 500,80+20×lines ⍝ base height of plot on number of lines
      ∆sharpplot.SetMargins 10 40 50 10
      ∆sharpplot.SetBarWidths⊂,0.5
      ∆sharpplot.SetColors⊂System.Drawing.Color.(Navy Lime Black)
      ∆sharpplot.KeyStyle←Causeway.KeyStyles.(CenterAlign+BottomAlign)
      ∆sharpplot.SetKeyText⊂'Prediction Interval' 'Confidence Interval' 'Point Estimate'
      ∆sharpplot.SplitBy(,(⍴data)⍴1 2 3 2 1)(⍬)
      (max min)←(⌈/,⌊/),data
      range←max-min
      ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.(Clipped+ExactFit+GridLines)
      ∆sharpplot.SetXRange⌊0.5+min max+¯0.1 0.1×range
      ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.(ForceZero+GridLines)
      ∆sharpplot.SetYLabels⊂2↓¨∊¨↓', '∘,¨⍕¨labels
      ∆sharpplot.SetYTickMarks,⊂⍳≢data
      group←(¯1↑⍴data)/⍳≢data
      points←((∊{⊂⍵+¯1 1×0.001×range}@3)∘(⊂∘⍋⌷⊢)⍤1)data
      ∆sharpplot.DrawGanttChart group(,0 ¯1↓points)(,0 1↓points)
      showSvg svg←PatchSVG ∆sharpplot.RenderSvg Causeway.SvgMode.FixedAspect
    ∇

    ∇ svg←labels BuildConfIntSvg data;⎕ML;⎕IO;⎕USING;Causeway;System;∆sharpplot;range;min;max;group;points;lines;suf1;suf2;colors;suf;kt
      ⎕ML←⎕IO←1
     
      :If 0=#.⎕NC'InitCauseway' ⋄ 'InitCauseway'#.⎕CY'sharpplot' ⋄ :EndIf
      #.InitCauseway ⍬
     
      (data labels)←⊖¨data labels ⍝ order graphs the same as data table
      lines←≢data
      ∆sharpplot←⎕NEW Causeway.SharpPlot
      :If 2=⍴⍴data
          ∆sharpplot.Reset 500,80+20×lines ⍝ base height of plot on number of lines
          ∆sharpplot.DefineFont('AS' 'Arial')
          ∆sharpplot.SetMargins 10 40 120 10
          ∆sharpplot.SetKeyFont('AS')(8)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetLabelFont('AS')(8)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetCaptionFont('AS')(8)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetValueFont('AS')(8)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetBarWidths⊂,0.5
          ∆sharpplot.SetColors⊂System.Drawing.Color.(Green Navy)
          ∆sharpplot.KeyStyle←Causeway.KeyStyles.(CenterAlign+BottomAlign)
          ∆sharpplot.SetKeyText⊂'Confidence Interval' 'Point Estimate'
          ∆sharpplot.SplitBy(,(⍴data)⍴1 2 1)(⍬)
          (max min)←(⌈/,⌊/),data
          range←max-min
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.(Clipped+ExactFit+GridLines)
⍝          ∆sharpplot.SetXRange⌊0.5+min max+¯0.1 0.1×range
⍝          ∆sharpplot.SetXRange{(⌊¯0.5⍵[1]),⌈.5+⍵[2]}min max+¯0.1 0.1×range
          ∆sharpplot.SetXRange min max+¯0.1 0.1×range
          ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.(ForceZero+GridLines)
          ∆sharpplot.SetYLabels⊂#.Strings.deb¨labels
          ∆sharpplot.SetYTickMarks,⊂⍳≢data
          group←(¯1↑⍴data)/⍳≢data
      ⍝points←((∊{⊂⍵+¯1 1×0.001×range}@3)∘(⊂∘⍋⌷⊢)⍤1)data
          points←data[;1 3 3 2]+[2]0 ¯0.0015 0.0015 0×range
          ∆sharpplot.DrawGanttChart group(,0 ¯1↓points)(,0 1↓points)
      :Else
          lines←×/1↓⍴data
          ∆sharpplot.Reset 500,80+20×lines ⍝ base height of plot on number of lines
          ∆sharpplot.DefineFont('AS' 'Arial')
          ∆sharpplot.SetKeyFont('AS')(8)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetLabelFont('AS')(8)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetCaptionFont('AS')(8)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetValueFont('AS')(8)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetMargins 10 40 50 10
          ∆sharpplot.SetBarWidths⊂,0.5
          colors←System.Drawing.((Color.(Green Lime),ColorTranslator.FromHtml¨⊂¨'#CD5C5C' '#1E90FF' '#DAA520' '#FF1493' '#00CED1' '#ADD8E6'),[1.5]Color.Navy)
          ∆sharpplot.SetColors⊂,colors
          ∆sharpplot.KeyStyle←Causeway.KeyStyles.(CenterAlign+BottomAlign)
          ∆sharpplot.SplitBy(,(⍴data)⍴1 2 1)(⍬)
          (max min)←(⌈/,⌊/),data
          range←max-min
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.(Clipped+ExactFit+GridLines)
⍝          ∆sharpplot.SetXRange⌊0.5+min max+¯0.1 0.1×range
          ∆sharpplot.SetXRange min max+¯0.1 0.1×range
          ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.(ForceZero+GridLines)
          ∆sharpplot.SetYLabels⊂#.Strings.deb¨,⌽labels⍝,' '
          ∆sharpplot.SetYTickMarks,⊂⍳×/⍴labels
          ⍝kt←⍬
          ⍝⎕←'group=',group←3/2×⍳≢data
          ⍝points←((∊{⊂⍵+¯1 1×0.001×range}@3)∘(⊂∘⍋⌷⊢)⍤1)data
          :For i :In ¯1+⍳¯1↑⍴labels
              points←data[;i+1;1 3 3 2]+[2]range×0 ¯0.0015 0.0015 0
              group←3/((¯1↑⍴labels)×⍳≢data)-i
              ∆sharpplot.DrawGanttChart(group)(,0 ¯1↓points[;⍳4])(,0 1↓points[;⍳4])
             ⍝ ⎕SE.Dyalog.Utils.disp(group)(,0 ¯1↓points[;⍳4])(,0 1↓points[;⍳4])
              suf←{(⌽∧\⌽⍵≠' ')/⍵}⊃labels[1;i+1]
⍝              kt,←('Confidence Interval' 'Point Estimate'),¨⊂' ',suf
          :EndFor
          ⍝∆sharpplot.SetKeyText⊂kt
          ∆sharpplot.SetKeyText⊂'Confidence Intervals (colors may vary)' 'Point Estimate'
      :EndIf
      showSvg svg←PatchSVG ∆sharpplot.RenderSvg Causeway.SvgMode.FixedAspect
    ∇


    ∇ BuildRegressionSvg ns;⎕ML;⎕IO;⎕USING;Causeway;System;∆sharpplot;data;mask;cats
      :Access public
      ⎕ML←⎕IO←1
     
      :If 0=#.⎕NC'InitCauseway' ⋄ 'InitCauseway'#.⎕CY'sharpplot' ⋄ :EndIf
      #.InitCauseway ⍬
     
     
      :If 0=ns.⎕NC'svgColors' ⋄ ns.svgColors←'Lime' 'Navy' 'Maroon' 'Green' 'OrangeRed' 'Teal' 'DarkOrchid' 'DimGray' 'Cyan' 'Black' ⋄ :EndIf
      :If 0=ns.⎕NC'svgSize' ⋄ ns.svgSize←480 270 ⋄ :EndIf
     
      ∆sharpplot←⎕NEW Causeway.SharpPlot
     
      ∆sharpplot.NewPage⊂0
      ∆sharpplot.NewFrame(0)(0)(432)(324)
      ∆sharpplot.SetMargins 30 40 40 30
      ∆sharpplot.SetCaptionFont'Times New Roman' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.Teal
      ∆sharpplot.EquationStyle←Causeway.EquationStyles.(Left+Below)
      ∆sharpplot.SetSubheadingFont'Times New Roman' 12 System.Drawing.FontStyle.Regular System.Drawing.Color.Navy
      ∆sharpplot.SetGridLineStyle System.Drawing.Color.(FromArgb 166 0 0 0)Causeway.LineStyle.Solid 0.18
      ∆sharpplot.SetLabelFont'Times New Roman' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.Black
      ∆sharpplot.ScatterPlotStyle←+/('Regression'≢10↑ns.Caption)↓Causeway.ScatterPlotStyles.(AnnotateModel,ModelFit,ExplodeAxes,Risers)
      ∆sharpplot.Subheading←ns.Caption
      ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.(GridLines+CenteredCaption)
      ∆sharpplot.XCaption←ns.XAxis
      ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.(GridLines+CenteredCaption)
      ∆sharpplot.YCaption←ns.YAxis
      ∆sharpplot.DrawScatterPlot↓[1]ns.YX
      showSvg ns.svg←PatchSVG ∆sharpplot.RenderSvg Causeway.SvgMode.FixedAspect
     
    ∇

    ∇ BuildRegression_uv_SVG ns
      ⎕ML←⎕IO←1
     
      :If 0=#.⎕NC'InitCauseway' ⋄ 'InitCauseway'#.⎕CY'sharpplot' ⋄ :EndIf
      #.InitCauseway ⍬
     
      :If 0=ns.⎕NC'svgColors' ⋄ ns.svgColors←'Lime' 'Navy' 'Maroon' 'Green' 'OrangeRed' 'Teal' 'DarkOrchid' 'DimGray' 'Cyan' 'Black' ⋄ :EndIf
      :If 0=ns.⎕NC'svgSize' ⋄ ns.svgSize←480 270 ⋄ :EndIf
     
      ∆sharpplot←⎕NEW Causeway.SharpPlot
     
      ∆sharpplot.NewPage⊂0
      ∆sharpplot.NewFrame(0)(0)(432)(324)
      ∆sharpplot.SetMargins 30 40 40 30
      ∆sharpplot.SetCaptionFont'Times New Roman' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.Teal
  ⍝∆sharpplot.EquationStyle←Causeway.EquationStyles.(Left+Below)
      ∆sharpplot.SetSubheadingFont'Times New Roman' 12 System.Drawing.FontStyle.Regular System.Drawing.Color.Navy
      ∆sharpplot.SetGridLineStyle System.Drawing.Color.(FromArgb 166 0 0 0)Causeway.LineStyle.Solid 0.18
      ∆sharpplot.SetLabelFont'Times New Roman' 8 System.Drawing.FontStyle.Regular System.Drawing.Color.Black
      ∆sharpplot.Heading←'ScatterPlot'
  ⍝∆sharpplot.ScatterPlotStyle←+/('Regression'≢10↑ns.Caption)↓Causeway.ScatterPlotStyles.(AnnotateModel,ModelFit,ExplodeAxes,Risers)
   ∆sharpplot.ScatterPlotStyle←Causeway.ScatterPlotStyles.ExplodeAxes
  ⍝∆sharpplot.Subheading←ns.Caption
      ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.CenteredCaption
      ∆sharpplot.XCaption←2⊃ns.Grid.Values[6;]
      ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.AtEndCaption  ⍝ AtEndCaption="The caption is written horizontally above the top of the axis" according to doc!
      ∆sharpplot.YCaption←2⊃ns.Grid.Values[3;]
      ∆sharpplot.DrawScatterPlot↓[1]ns.YX
     
      ∆sharpplot.LineGraphStyle←Causeway.LineGraphStyles.(XYPlot+Curves)
      ∆sharpplot.SetLineStyles⊂Causeway.LineStyle.Solid
      ∆sharpplot.SetPenWidths 1
      ⍝ SM had a VALUE ERROR using the SharpPlot Variables, so I'm trying constants instead ↓↓↓
      coltab←3 1⍴'red' 'green' 'blue'           ⍝ supports html colours
      coltab,←4294901760 4278222848 4278190335  ⍝ see https://www.perplexity.ai/search/red-is-4294901760-and-green-is-wg_qvBC8R8C.D5wdMLraLQ   ;)
      colsel←0 0
      :For i :In ⍳2
          coord←⊃⍸ns.Grid.Names≡¨⊂i⊃'colCB' 'colYH'
        ⍝   :If coord≢0 0
        ⍝       coord←coord×ns.Grid.Values[coord]∊coltab[;1]   ⍝ validate color
        ⍝   :EndIf
        ⍝   :If coord≢0 0
          colsel[i]←ns.Grid.Values[⊂coord]
        ⍝   :Else
        ⍝       colsel[i]←coltab[i;1]
        ⍝   :EndIf
      :EndFor
      ∆sharpplot.SetColors coltab[coltab[;1]⍳colsel;2]    ⍝ Causeway.Color.(Red Green Red)
       ∆sharpplot.DrawLineGraph↓[1]ns.(CB[;,1],XHat)
      ∆sharpplot.DrawLineGraph↓[1]ns.(YHat,[1.5]XHat)
      ∆sharpplot.DrawLineGraph↓[1]ns.(CB[;,2],XHat)
      showSvg ns.svg←PatchSVG ∆sharpplot.RenderSvg Causeway.SvgMode.FixedAspect
    ∇


    ∇ BuildProbWizSvg ns;sz;s;mp;c1;c2;text
      :Access instance
      ⎕ML←⎕IO←1
    ⍝   ⎕se.Dyalog.Utils.display  ns.(Venn[;1 2]  VennText)
    ⍝   ⎕SE.Dyalog.Utils.display{1=⍴⍴⍵:∊∇¨⍵ ⋄ ⌊⌿⍵}¨ns.Venn[;3]
    ⍝   ⎕SE.Dyalog.Utils.display{1=⍴⍴⍵:∊∇¨⍵ ⋄ ⌈⌿⍵}¨ns.Venn[;3]
     
      sz←2000 500
      s←({'width=',(1⊃⍵),' height=',2⊃⍵}⍕¨sz)#.HtmlElement.New #._.svg
     
      s.Add #.HtmlElement.ScriptFollows
    ⍝ <pattern id="dots-2" patternUnits="userSpaceOnUse" width="10" height="10"> <image xlink:href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIHdpZHRoPScxMCcgaGVpZ2h0PScxMCc+CiAgPHJlY3Qgd2lkdGg9JzEwJyBoZWlnaHQ9JzEwJyBmaWxsPSd3aGl0ZScgLz4KICA8cmVjdCB4PScwJyB5PScwJyB3aWR0aD0nMicgaGVpZ2h0PScyJyBmaWxsPSdibGFjaycgLz4KPC9zdmc+" x="0" y="0" width="10" height="10"> </image> </pattern>
    ⍝ <pattern id="lightstripe" patternUnits="userSpaceOnUse" width="5" height="5"> <image xlink:href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIHdpZHRoPSc1JyBoZWlnaHQ9JzUnPgogIDxyZWN0IHdpZHRoPSc1JyBoZWlnaHQ9JzUnIGZpbGw9J3doaXRlJy8+CiAgPHBhdGggZD0nTTAgNUw1IDBaTTYgNEw0IDZaTS0xIDFMMSAtMVonIHN0cm9rZT0nIzg4OCcgc3Ryb2tlLXdpZHRoPScxJy8+Cjwvc3ZnPg==" x="0" y="0" width="5" height="5"> </image> </pattern>
     
     
    ⍝ These are not used:
    ⍝ <pattern id="diagonal-stripe-1" patternUnits="userSpaceOnUse" width="10" height="10"> <image xlink:href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIHdpZHRoPScxMCcgaGVpZ2h0PScxMCc+CiAgPHJlY3Qgd2lkdGg9JzEwJyBoZWlnaHQ9JzEwJyBmaWxsPSd3aGl0ZScvPgogIDxwYXRoIGQ9J00tMSwxIGwyLC0yCiAgICAgICAgICAgTTAsMTAgbDEwLC0xMAogICAgICAgICAgIE05LDExIGwyLC0yJyBzdHJva2U9J2JsYWNrJyBzdHJva2Utd2lkdGg9JzEnLz4KPC9zdmc+Cg==" x="0" y="0" width="10" height="10"> </image> </pattern>
    ⍝ <pattern id="horizontal-stripe-1" patternUnits="userSpaceOnUse" width="10" height="10"> <image xlink:href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIHdpZHRoPScxMCcgaGVpZ2h0PScxMCc+CiAgPHJlY3Qgd2lkdGg9JzEwJyBoZWlnaHQ9JzEwJyBmaWxsPSd3aGl0ZScgLz4KICA8cmVjdCB4PScwJyB5PScwJyB3aWR0aD0nMTAnIGhlaWdodD0nMScgZmlsbD0nYmxhY2snIC8+Cjwvc3ZnPg==" x="0" y="0" width="10" height="10"> </image> </pattern>
    ⍝ <pattern id="vertical-stripe-1" patternUnits="userSpaceOnUse" width="10" height="10"> <image xlink:href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIHdpZHRoPScxMCcgaGVpZ2h0PScxMCc+CiAgPHJlY3Qgd2lkdGg9JzEwJyBoZWlnaHQ9JzEwJyBmaWxsPSd3aGl0ZScgLz4KICA8cmVjdCB4PScwJyB5PScwJyB3aWR0aD0nMScgaGVpZ2h0PScxMCcgZmlsbD0nYmxhY2snIC8+Cjwvc3ZnPg==" x="0" y="0" width="10" height="10"> </image> </pattern>
    ⍝ <pattern id="simple-dots" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse"><circle fill="#aaa" cx="10" cy="10" r="4" /></pattern>
     
      mp←{
          1=⍴⍴⍵:∊(⊂1 ⍺)∇¨⍵
          ⍝#.HtmlElement.New #._.polyline('style="fill:',({1≠≡⍵:(2⊃⍵),';stroke:',2⊃⍵ ⋄ ⍵,';stroke:black;'}⍺),';stroke-width:1;" points="',(∊{(⍕2⊃⍵),',',(⍕1⊃⍵),' '}¨↓⍵),'"')
⍝     ('<polyline style="',({1≠≡⍵:((1≠≡⍵)/'fill:'),(2⊃⍵),((0=≢2⊃⍵)/'white'),';','stroke:',((0=≢2⊃⍵)/'black'),2⊃⍵ ⋄ (((0<≢⍵)/'fill:'),⍵,(0<≢⍵)⍴';'),'stroke:black'}⍺),';stroke-width:1;" points="',(∊{(⍕2⊃⍵),',',(⍕1⊃⍵),' '}¨↓⍵),'" />')
          ('<polyline style="fill:',({1≠≡⍵:(2⊃⍵),((0=≢2⊃⍵)/'white'),';','stroke:',((0=≢2⊃⍵)/'black'),2⊃⍵ ⋄ (((0=≢⍵)/'white'),⍵),';stroke:black'}⍺),';stroke-width:1;" points="',(∊{(⍕2⊃⍵),',',(⍕1⊃⍵),' '}¨↓⍵),'" />')
      }
     
⍝ change colour or grey patterns by moving lines around!
      c1←'url(#dots-2) #aaa' ⋄ c2←'url(#lightstripe) #aaa'  ⍝ GREY PATTERN
      c2←'green' ⋄ c1←'lightgrey'                           ⍝ COLOURED CHARTS
⍝↑↑↑↑ last line should contain the mode you want to use for ProbWiz-Charts ↑↑↑↑↑
     
      text←{s.Add'<text ',⍺,'>',(,⍵,(1<⍴⍴⍵)/(⌽1,1⌈1↑⍴⍵)⍴⎕UCS 10),'</text>'}
      ⍝text←{⍺ s.Add #._.text ⍵}  ⍝ awaiting DUI-Patch
      ⍝s.Add¨((('' 'lightgrey' 'green')[ns.Venn[;1]+2])mp¨ns.Venn[;3])
      s.Add¨(((''c1 c2)[ns.Venn[;1]+2])mp¨ns.Venn[;3])
      ⍝ s.Add¨((ns.Venn[;1]≥0)/('' 'lightgrey' 'green')[ns.Venn[;1]+2])mp¨ns.((Venn[;1]≥0)/Venn[;3])
      ('x=700 y=130 width=30 height=30 style=stroke:black;stroke-width:.1;fill:',c2,';')s.Add #._.rect
      ('x=700 y=180 width=30 height=30 style=stroke:black;stroke-width:.1;fill:',c1,';')s.Add #._.rect
     
      :If 4=≢ns.Venn
          'x=150  y=230 style=font-size:1.5em;font-weight:800;text-anchor:middle;alignment-baseline:middle;'text(2⊃ns.Venn[2;])
          'x=460   y=230 style=font-size:1.5em;font-weight:800;text-anchor:middle;alignment-baseline:middle;'text(2⊃ns.Venn[3;])
          'x=310  y=230 style=font-size:1.5em;font-weight:800;text-anchor:middle;alignment-baseline:middle;'text(2⊃ns.Venn[4;])
      :Else
          'x=460  y=230 style=font-size:1.5em;font-weight:800;text-anchor: middle;alignment-baseline:middle;'text(2⊃ns.Venn[2;])
      :EndIf
     
      'x=700  y=50 style=font-size:1.5em;font-weight:800;'text(1⊃ns.VennText)
      'x=750 y=150 style=font-size:1.5em;font-weight:800;'text(2⊃ns.VennText)
      'x=750 y=200 style=font-size:1.5em;font-weight:800;'text(3⊃ns.VennText)
      :If 3<≢ns.VennText
          'x=700 y=300 style=font-size:1.5em;font-weight:800;'text(4⊃ns.VennText)
      :EndIf
      ns.svg←PatchSVG s.Render
     
    ∇

    ∇ BuildChartSvg ns;⎕ML;⎕IO;⎕USING;Causeway;System;∆sharpplot;data;mask;cats;key;i;gv;width
      :Access public
      ⎕ML←⎕IO←1
     
      :If 0=#.⎕NC'InitCauseway' ⋄ 'InitCauseway'#.⎕CY'sharpplot' ⋄ :EndIf
      #.InitCauseway ⍬
     
     
      :If 0=ns.⎕NC'svgColors' ⋄ ns.svgColors←'Lime' 'Navy' 'Maroon' 'Green' 'OrangeRed' 'Teal' 'DarkOrchid' 'DimGray' 'Cyan' 'Black' ⋄ :EndIf
      :If 0=ns.⎕NC'svgSize' ⋄ ns.svgSize←800 600 ⋄ :EndIf
     
      ∆sharpplot←⎕NEW Causeway.SharpPlot
      ∆sharpplot.Reset ns.svgSize
      ∆sharpplot.SetColors⊂System.Drawing.Color⍎¨ns.svgColors
      ∆sharpplot.(MarginLeft MarginRight)←40
     
 ⍝BPB!!! temporary until change to Steve's code in integrated
      :If 0=ns.⎕NC'Style'
          :If 0≠ns.⎕NC'FiveNumberSummary'
              ns.Style←'Box'
          :EndIf
      :EndIf
     
      :Select ns.Style
     
      :Case 'Pie'
          data←ns.Freq
          ∆sharpplot.SetKeyFont('APL385 Unicode')(14)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Navy)
          ∆sharpplot.KeyStyle←Causeway.KeyStyles.(Vertical+Boxed+Rounded+RightAlign+MiddleAlign)
          ∆sharpplot.SetKeyText⊂⍕¨↓data
          ∆sharpplot.DrawPieChart(data[;2])(⍬)
     
      :Case 'Bar'
          data←ns.Freq
          ∆sharpplot.BarChartStyle←Causeway.BarChartStyles.(TicksBetween+ValueTags)
          ∆sharpplot.BarLimit←10000
          ∆sharpplot.ValueTagStyle←Causeway.ValueTagStyles.Normal
          ∆sharpplot.SetValueTags⊂⍬
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.(GridLines+MiddleLabels)
          ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.(ForceZero+GridLines)
          ∆sharpplot.SetGridLineStyle System.Drawing.Color.Black Causeway.LineStyle.Solid 0.18
          ∆sharpplot.SetLabelFont'Arial' 16 System.Drawing.FontStyle.Regular System.Drawing.Color.Black
          ∆sharpplot.SetValueFont'Arial' 14 System.Drawing.FontStyle.Regular System.Drawing.Color.Green
          ∆sharpplot.SetValueTags⊂⍬
          :If 2=⊢/⍴data
              ∆sharpplot.SetXLabels⊂data[;1]
              data←data[;2]
          :Else
              ∆sharpplot.Gap←0.2
              ∆sharpplot.GroupGap←1.2
              ∆sharpplot.SetKeyFont'Arial' 12 System.Drawing.FontStyle.Regular System.Drawing.Color.Navy
              ∆sharpplot.SetKeyText⊂1↓data[;1]
              ∆sharpplot.SetXLabels⊂1↓data[1;]
              data←↓1 1↓data
          :EndIf
          ∆sharpplot.DrawBarChart⊂data
     
      :Case 'Dot'
          data←ns.YX
          ∆sharpplot.BarChartStyle←Causeway.BarChartStyles.(TicksBetween+ValueTags)
          ∆sharpplot.BarLimit←10000
          ∆sharpplot.SetLabelFont('Arial')(17)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetValueFont('Arial')(14)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Green)
          ∆sharpplot.SetValueTags⊂⍬
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.(MiddleLabels+ExactFit)
          ∆sharpplot.XTickStyle←Causeway.XTickStyles.NoTicks
          ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.(ForceZero+GridLines)
          ∆sharpplot.SetXLabels⊂⍕¨data[;2]
          ∆sharpplot.DrawBarChart⊂,⊂data[;1]
     
      :Case 'Box'
          data←,ns.FiveNumberSummary
          ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.(GridLines+InvisibleAxis+MiddleLabels)
          ∆sharpplot.SetLabelFont('Arial')(17)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.BoxPlotStyle←Causeway.BoxPlotStyles.(ExplodeAxes+TicksBetween+Horizontal)
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.GridLines
          ∆sharpplot.YTickStyle←Causeway.YTickStyles.NoTicks
          cats←5/(⍕¨ns.Groups),¨(0∘∊∘⍴¨ns.Outliers)↓¨'*'
          ∆sharpplot.DrawBoxPlot data cats
     
      :Case 'Histogram'
          width←ns.Width+ns.Width=0
          ∆sharpplot.ClassInterval←width
          ∆sharpplot.SetXTickMarks width
          ∆sharpplot.HistogramStyle←Causeway.HistogramStyles.(SurfaceShading+ValueTags+ExplodeAxes)
          ∆sharpplot.SetValueFont('Arial')(14)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Green)
          ∆sharpplot.SetLabelFont('Arial')(14)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.SetValueTags⊂⍬
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.(GridLines+MiddleLabels)
          ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.(ForceZero+GridLines)
          ∆sharpplot.DrawHistogram⊂{1=⍴⍴⍵:⍵ ⋄ ⍵[;2]/⍵[;1]}ns.Data
     
      :Case 'ScatterPlot'
          ∆sharpplot.SetMarkerScales⊂,2
          ∆sharpplot.MarginLeft←60
          ∆sharpplot.SetColors⊂System.Drawing.Color.Navy
          ∆sharpplot.SetMarkers⊂Causeway.Marker.(Lozenge Plus Circle Diamond Bullet)
          ∆sharpplot.SetLabelFont('Arial')(14)(System.Drawing.FontStyle.Regular)(System.Drawing.Color.Black)
          ∆sharpplot.ScatterPlotStyle←Causeway.ScatterPlotStyles.ExplodeAxes
          ∆sharpplot.XAxisStyle←Causeway.XAxisStyles.GridLines
          ∆sharpplot.YAxisStyle←Causeway.YAxisStyles.GridLines
          data←ns.YX
     
          :For i :In 1 2
              :If 0∧.=2|⎕DR¨key←∪i⊃data
                  data[i]←⊂key⍳i⊃data
                  :If i=1
                      ∆sharpplot.SetYLabels⊂,¨key
                  :Else
                      ∆sharpplot.SetXLabels⊂,¨key
                  :EndIf
              :EndIf
          :EndFor
     
          ∆sharpplot.DrawScatterPlot data
     
      :Else ⋄ ∘∘∘ ⍝ unknown or unimplemented chart type
      :EndSelect
     
      showSvg ns.svg←PatchSVG ∆sharpplot.RenderSvg Causeway.SvgMode.FixedAspect
    ∇

    ∇ svg←PatchSVG svg
     ⍝ inject a class-attr into the svg-tag (we assume there is none)
      ⍝ svg←('<svg '⎕R'<svg ondblclick="blowUpSVG(this);" ')svg
      ⍝ package the svg into a div (svg does not honour dblclick in some browsers)
      svg←'<div class="w-100 h-100" ondblclick="blowUpSVG(this);">',svg,'</div>'
    ∇


:EndNamespace
