﻿:namespace tsConsoleCommands




    ∇ Use ns;cs;us
      cs←(1⊃⎕RSI).⍙⍙SESSION⍙⍙.currDS
      us←(1⊃⎕RSI).⍙⍙SESSION⍙⍙.userNS
      ⍝:If (⊂ns)∊'#' '##'
        ⍝  R←'⎕this' ⍝ stay in userNS
      ⍝:ElseIf 9=us.⎕NC ns
      :If 9=us.⎕NC ns
          R←ns
      :ElseIf 9=⎕NC('#.'⎕R⍕us)('##.'⎕R'#.')ns
          R←('#.'⎕R⍕us)('##.'⎕R'#.')ns
      :Else
          ('ERROR: Can''t use namespace ',ns)⎕SIGNAL 6
      :EndIf
      (1⊃⎕RSI).⍙⍙SESSION⍙⍙.currDS←R
    ∇

    ∇ R←{opts}saveCSV file_ns;file;ns;nsdesc;fmtOpts;path;filename;suffprompt;nl2;z;keys;z1;i;data
⍝ save ns to CSV
⍝ we also accept '' which means save current ns, ask for filename
⍝ opts currenty not supported - need to sort out how to make survive #filesave-handling...
R←''
      :If ¯2=≡file_ns
          (file ns)←file_ns
          nsdesc←'Dataset "',(⍕ns),'" '
      :Else
          (file ns)←file_ns(1⊃⎕RSI).ref
          nsdesc←'Current dataset\"',(⍕ns),'\"'
      :EndIf
      :If 0=⎕NC'opts'
           opts←⎕NS'' ⋄ fmtOpts←''
      :Else
          :If 2=≡opts ⋄ opts←,⊂opts ⋄ :EndIf
          ⍝ turn NV-Pairs into namespace:
          :If 9≠⎕NC'opts' ⋄ opts←#.tsSiteTools.mns opts ⋄ :EndIf
          fmtOpts←∊opts{val←⍺⍎⍵ ⋄ '(''',⍵,''' ',({#.HtmlElement.isChar ⍵:'''',⍵,'''' ⋄ ⍕⍵}val),')'}¨opts.⎕NL-2
      :EndIf
      :If file≡''  ⍝ browse for file...
        ⍝ build payload to call the uploader (that will callback this fn with the appropriate args)
          ⍝t←fmtOpts #.Strings.subst¨⊂' ' '&#x20;'
          R←⎕NS'' ⋄ R.js←''
          R.Type←'Execute'
          R.js,←'$("#filesave_overwrite").val(',(1=opts{6::0 ⋄ ⍺.⍵}'Replace'),');'
          R.js,←'$("#filesave_info").val("1/',(⍕ns),'/");$("#filesave_title").text("Save dataset");$("#filesave_name").val("',ns._meta._Filename,'");'
          R.js,←'$("#filesave_prompt").text("',nsdesc,' will be saved to local disk. Please enter path and filename (without extension) below:");$("#filesave_opts").val("',(⎕JSON opts),'");$("#downloader").modal("show");'
          →0
      :EndIf
     
      path←1⊃⎕NPARTS file
      :If 0=≢path ⋄ path←#.Boot.AppRoot,'Data/' ⋄ :EndIf
      filename←2⊃⎕NPARTS file
      file←path,filename,'.csv'  ⍝ re-assign the normalized path
      :If ~⎕NEXISTS path         ⍝ if the specified dir does not exist
      :OrIf (⎕NEXISTS file)∧1≠opts{6::0 ⋄ ⍺⍎⍵}'Replace'
          R←⎕NS''
          R.js←''
          :If ~⎕NEXISTS path  ⍝ if the specified dir does not exist
              suffprompt←'Please verify path and filename (without extension) below:'
          :Else    ⍝ the file exists - let user confirm the overwrite
              suffprompt←'Please confirm path and filename (without extension) below:'
              R.js,←'$("#filesaveOverwritePrompt").removeClass("d-none");'
          :EndIf
          R.Type←'Execute'
          R.js,←'$("#filesave_info").val("1/',(⍕ns),'/");$("#filesave_title").text("Save dataset");$("#filesave_prompt").text("',nsdesc,' will be saved to local disk. ',suffprompt,'");$("#filesave_name").val("',file,'");'
          R.js,←'$("#filesave_opts").val("',fmtOpts,'");$("#downloader").modal("show");'
          →0
      :EndIf
     
      ⎕EX'#.tempNS' ⋄ {}'#.tempNS'⎕NS''
      ns.('#.tempNS'⎕NS{(∊(,'_')≠1↑¨⍵)/⍵}⎕NL-2)  ⍝ exclude variable names starting with "_" (internal flags)
      nl2←#.tempNS.⎕NL-2
      z←(6↑¨ns._meta.⎕NL-2)≡¨⊂'Scale_'
      keys←⍳0
      :If ∨/z
          :If ∨/z1←(⊂'Key')≡¨ns._meta⍎¨z/ns._meta.⎕NL-2  ⍝ make sure the key-field is in first column
              keys←nl2⍳6↓¨z1/z/ns._meta.⎕NL-2
          :EndIf
      :EndIf
      i←nl2{⍵,(⍳⍴⍺)~⍵}keys ⋄ nl2←nl2[i]
      data←((#.tempNS⍎¨nl2)(nl2))⎕CSV'' 'S'
      (⊂data)⎕NPUT(file)1
     
      data←((ns._meta._info[;⍳2])('Code' 'Value'))⎕CSV'' 'S'
      (⊂data)⎕NPUT(path,filename,'.meta.csv')1
     
      R,←(⎕UCS 13),⊂'Saved Dataset "',(⍕ns),'" in file "',path,filename,'.csv"'
     
    ∇

    ∇ {R}←{opts}loadCSV file_targetNS;targetNS;cnt;z;log;name;ns;file;fmtOpts;path
    ⍝ load CSV-File. "opts" as in tsSiteTools.LoadCSV
    ⍝ R = tet-vec with processing-log
    ⍝  OR a namespace (if we browsed for a file)
      :If ¯2=≡file_targetNS
          (file targetNS)←file_targetNS
      :Else
          file←file_targetNS ⋄ targetNS←''
      :EndIf
      :If targetNS≡''
          targetNS←(1⊃⎕RSI)._Request.Session.userNS.DATA
      :EndIf
      :If 0=⎕NC'opts'
          R←⊂'Log of "Load ',file,'"' ⋄ opts←⍬ ⋄ fmtOpts←''
      :Else
          :If 2=≡opts ⋄ opts←,⊂opts ⋄ :EndIf
          fmtOpts←∊{'(''',(1⊃⍵),''' ',({#.HtmlElement.isChar ⍵:'''',⍵,'''' ⋄ ⍕⍵}2⊃⍵),')'}¨opts
          R←⊂'Log of "',fmtOpts,'Load ',file,'"'
      :EndIf
      :If file≡''  ⍝ browse for file...
        ⍝ build payload to call the uploader (that will callback this fn with the appropriate args)
          ⍝t←fmtOpts #.Strings.subst¨⊂' ' '&#x20;'
          R←⎕NS''
          R.Type←'Execute'
          R.js←'$("#pCSV").removeClass("d-none");$("pOther").addClass("d-none");$("#upload").modal("show");$("#opts").val("',fmtOpts,'");$("#continue").val("loadCSV");'
          →0
      :EndIf
      :If ''≡1⊃⎕NPARTS file
          file←(path←#.Boot.AppRoot,'Data/'),file
          R,←⊂'No path provided, loading from ',path
      :EndIf
      :If ''≡3⊃⎕NPARTS file
          file,←'.csv'
          R,←⊂'Using default-extension ".csv"'
      :EndIf
      :If ~⎕NEXISTS file
          R,←⊂'FILE NOT FOUND ERROR attempting to load ',file
      :Else
          (z log name ns)←opts #.tsSiteTools.LoadCSV file
          :If z=0
              cnt←''
              :While 0≠targetNS.⎕NC name,cnt
                  cnt←⍕1+2⊃⎕VFI'0',cnt
              :EndWhile
              name←name,cnt
              R,←⊂'File loaded successfully into ',name
              :If cnt≢''
                  R[≢R]←⊂(R⊃⍨≢R),' (changed name to avoid overridding existing data!)'
              :EndIf
              R,←⊂'Log: ',log,¨⎕UCS 13
              name targetNS.⎕NS ns
          :Else
              R,←'Import ended with errors:',∊log,¨⎕UCS 13
          :EndIf
      :EndIf
      R←∊R,¨⎕UCS 13
    ∇


    ∇ R←saveLog filename;data;bytes;upd;Message
      :Access public
      data←(1⊃⎕RSI)._Request.Session._tsLog
      :If (1⊃1 ⎕NPARTS'foo.bar')≡1⊃1 ⎕NPARTS filename  ⍝ no directory specified
          filename←#.Boot.AppRoot,'Data/',filename
      :EndIf
      :If 0=≢3⊃⎕NPARTS filename ⋄ filename,←'.json' ⋄ :EndIf
      (⊂⎕JSON data)⎕NPUT filename
      Message←'Saved log with ',(≢data),' entries in ',filename
      R←#.tsSiteTools.mns('Type' 'tsInternal')('Message'Message)
    ∇

    ∇ R←{fromReplay}loadLog filename;data;bytes;upd;Message
    ⍝ fromReplay is an internal flag to indicate whether this fn was called by "replayLog" or not
      :Access public
      :If 0=⎕NC'fromReplay' ⋄ fromReplay←0 ⋄ :EndIf
      :If (1⊃1 ⎕NPARTS'foo.bar')≡1⊃1 ⎕NPARTS filename  ⍝ no directory specified
          filename←#.Boot.AppRoot,'Data/',filename
      :EndIf
      :If 0=≢3⊃⎕NPARTS filename ⋄ filename,←'.json' ⋄ :EndIf
      :If ⎕NEXISTS filename
          data← 1⊃⎕NGET filename
          data←⎕json data
          data←(⍳≢data){6::⍵⊣⍵._id←⍺ ⋄ ⍵⊣⍵.id}¨data  ⍝ ensure we have _id 
          data←data[⍋data._id]  ⍝ sort by id!
          ((1+fromReplay)⊃⎕RSI)._Request.Session._tsLog←data
          (bytes upd)←2 3 ⎕NINFO filename
          bytes←#.tsSiteTools.fmtX bytes
          upd←#.tsSiteTools.fmtDate upd
      ⍝                           ↓↓ do not count welcome-message...
          Message←'Loaded log with ',(⍕¯1+≢data),' entries from ',filename,' (',bytes,' bytes, last update: ',upd,')'
          R←#.tsSiteTools.mns('Type' 'tsInternal')('Message'Message)('js'('#output'#._JSS.Trigger'PostLoadLog'))('_logPos' 1.5)
      :Else
          ⎕SIGNAL 22
      :EndIf
    ∇


    ∇ R←replayLog filename
      :Access public
    ⍝ no filename given=current log!
      R←''
      :If 0<≢filename
          R←1 loadLog filename
          R.js←'#output'#._JSS.Trigger'PostLoadLogReplay' ⍝ trigger PostLoadLogReplay-event - everything else will be done there!
      :Else
          R←Execute'#output'#._JSS.Trigger'PostLoadLogReplay'
      :EndIf
    ∇

:endnamespace
