﻿:namespace tsSiteTools
    getCellContent←{('<t([dh])[^>]*>(.*)</t\1>'⎕S'\2')⍵}   ⍝ get content of th or td-Cell...

    ∇ {inst}InitDS req;sess;d
      sess←req.Session
      :If ~sess isDefined'userNS'
          'userNS'sess.⎕NS''
          :For d :In #.Datasets.⎕NL ¯9
              'DATA'sess.userNS.⎕NS'#.Datasets.',d
          :EndFor
          ⍝ sess.userNS.DATA.⎕DF'#'
      :EndIf
      :If 0=#.⎕NC'Prefs'
          #.Prefs←⎕JSON #.Files.ReadText #.Boot.AppRoot,'preferences.json'
          #.Prefs.Session.decimals←10 #.Prefs.{0::⍺ ⋄ ⍎⍵}'Session.decimals'
      :EndIf
      :If ~sess isDefined'Prefs'
          ReadSessionPrefs req
      :EndIf
      :If ~sess isDefined'currDS'
          :If (⊂sess.Prefs.defaultDataset)∊sess.userNS.DATA.⎕NL ¯9
              sess.currDS←sess.Prefs.defaultDataset
          :Else
              sess.currDS←1⊃sess.userNS.DATA.⎕NL ¯9  ⍝ make SD the default
          :EndIf
          sess._MODELS←⎕NS''  ⍝ make sure its in place
          :If {6::0 ⋄ 1⊣⍎⍵}'inst'
              inst.(currDS userNS)←sess.(currDS userNS)
              inst.(ref←userNS.DATA⍎currDS)
          :EndIf
      :EndIf
    ∇

    ∇ ReadSessionPrefs req;sess
      :Access public
      sess←req.Session
      sess.Prefs←⎕JSON #.Files.ReadText #.Boot.AppRoot,'preferences.json'  ⍝ make sess.Prefs independend (do not link it to #.Prefs - might cause trouble if we ever do multi-user...)
     
      :If sess.Prefs.Session.TrapErrors≡#.HtmlElement._true    ⍝ IF user wants to trap error
      :AndIf #.Boot.ms.Config.Production∨#.Boot.ms.Config.TrapErrors=0  ⍝ but we're in production mode OR server's trapping is enabled...
          sess.Prefs.Session.TrapErrors←#.HtmlElement._true   ⍝ then we disable our own trapping...
      :Else
          sess.Prefs.Session.TrapErrors←#.HtmlElement._false
      :EndIf
      sess.(⍙⍙trap⍙⍙←Prefs.Session.TrapErrors≡#.HtmlElement._true)
      sess.Prefs.Session.decimals←10 sess.Prefs.{0::⍺ ⋄ ⍎⍵}'Session.decimals'
      :If 0=sess.⎕NC'_tsLog'
      :OrIf 0=≢sess._tsLog
          sess._tsLog←req.Session._tsLog←,#.tsSiteTools.mns('type' 5)('in' 'Welcome to TamStat')('_id' 1)
      :EndIf
    ∇

    ∇ {(R log name ns)}←{opts}LoadCSV file;data;data∆;Error;Opts;seps;imp;meta;tally;info;i;val;c;d1
      ns←⎕NS''
      Error←{0=≢⍵:⍬ ⋄ log←log,⊂⍺ ⋄ R←⍵ ⋄ ERROR} ⍝ if 0<≢⍵ we have an error, log it and return value of label ERROR
      R←0 ⍝ success (0=yes, otherwise error-code)
      name←2⊃⎕NPARTS file
      Opts←('Invert' 2)('Fill'(⌈/⍳0))
      data←1⊃1⊃⎕NGET file 1 ⋄ seps←',;',⎕UCS 9
      Opts,←⊂'Separator'(({⍵⍳⌈/⍵}+⌿data∘.=seps)⊃seps) ⍝ determine separator
      :If 2=⎕NC'opts' ⋄ :AndIf 0<≢opts ⋄ Opts←(⊆opts)∪⊆Opts ⋄ :EndIf
      log←⊂'Processing data-file ',file
      ns←''
     ⍝ data←(⎕CSV⍠Opts)file'' 4 1  ⍝ expect header-row and process all data as text initially (look at conversion later...)
      :If 0
          :Trap 0
              data←(⎕CSV⍠Opts)file'' 4 1  ⍝ expect header-row and process all data as text initially (look at conversion later...)
          :Else
              R←1 ⋄ log←⎕DMX.Message
          :EndTrap
          d1←1⊃data
     
          (((⌈/⍬)=∊d1)/∊d1)←⎕NULL  ⍝ handle missing data
          :For c :In ⍳≢d1
              val←c⊃d1  ⍝ get column c
              ⍎'ns.',(c⊃2⊃data),'←val'
          :EndFor
      :Else
          :Trap 0
              imp←#.Util.import file  ⍝ use TamStat-Import
              ns←imp
              data←{(⍵⍎¨⍵.⎕NL ¯2)(⍵.⎕NL ¯2)}ns
          :Else
              R←1 ⍝ indicate error
              log←'Error while processing the file: ',⎕DMX.Message
          :EndTrap
⍝    :for n :in imp.⎕nl¯2
⍝        v←imp⍎n
      ⍝  ((v≡¨⎕null)/v)←⊂'null'
⍝        ⍎'ns.',n,'←v'
⍝    :endfor
 ⍝ keep content for few checks
      :EndIf
     
     
      :If ⎕NEXISTS meta←(∊2↑⎕NPARTS file),'.meta.csv'
          data∆←(⎕CSV⍠(Opts,⊂'Ragged' 1))meta''(1 1 1)1  ⍝ we once had 3 columns...
          log,←⊂'Meta-File: ',meta
      :Else
          data∆←(2 0⍴⍬)(⍬)
          log,←⊂'No Meta-File found!'
      :EndIf
      →'FORMAT ERROR: no. of records per field is not unique!'Error(1<≢tally←∊∪⍴¨1⊃data)/101
      meta←tally InitMetadata ns
      meta._Filename←file
      :If 0<≢info←⍉↑1⊃data∆
          meta.⍎¨∊¨↓meta.{w←⍵ ⋄ w[;1]←('\.'⎕R'_')w[;1] ⋄ w[;1]←w[;1],¨⊂'←' ⋄ w,¨←'''' ⋄ w ⋄ w}info[;⍳2]  ⍝ assign to variables (with "." in names replaced by "_")
      :EndIf
      meta._info←info
      :If (≢info)≥i←info[;1]⍳⊂'FileInfo.Acronym'
          name←2⊃info[i;]
      :EndIf
      log,←⊂'Name of Dataset: ',name
     
⍝      ⍎'#.Datasets.',name,'← ⎕json ⎕json ns'
⍝ 180911, MBaas: only return ns, do not copy anywhere...
⍝      name{#.Datasets.(⍺ ⎕NS ⍵)}ns
⍝      ns←⍎'#.Datasets.',name
      ns._meta←meta
      ns.⎕DF name
      →0
     ERROR:
      ⎕←'Error!'
      log
      ∘∘∘
    ∇

    ∇ meta←{tally}InitMetadata ns
      meta←⎕NS''
      :If 0=⎕NC'tally'
          tally←≢ns⍎1⊃{('_'≠∊1↑¨⍵)/⍵}1⊃ns.⎕NL ¯2 ⍝ use first variable as measure
      :EndIf
      meta._tally←tally
      meta._dirty←0
      meta._info←0 2⍴''
    ⍝ create a list of variables (to avoid repeating potentially costly ⎕NLs)
      meta._allVars←ns.⎕NL ¯2
      meta._charVars←(⊂'')~⍨ns.({w←(⍎⍵)~⊂⎕NULL ⋄ #.HtmlElement.isChar∊w:⍵ ⋄ ''}¨⎕NL ¯2)
      meta._boolVars←(⊂'')~⍨ns.({w←(⍎⍵)~⎕NULL ⋄ 11=⎕DR∊w:⍵ ⋄ ''}¨⎕NL ¯2)
      meta._intVars←(⊂'')~⍨ns.({w←(⍎⍵)~⎕NULL ⋄ (⎕DR∊w)∊83 163 323:⍵ ⋄ ''}¨⎕NL ¯2)
      meta._floatVars←(⊂'')~⍨ns.({w←(⍎⍵)~⎕NULL ⋄ 645=⎕DR∊w:⍵ ⋄ ''}¨⎕NL ¯2)
      meta.(_numVars←_allVars~_charVars)
     
      meta.Get←{0=≢⍺:'' ⋄ 2⊃(⍺⍪' ')[⍺[;1]⍳#.Strings.nocase⊆⍵;]}  ⍝ provide a dfn for easy access to info, ie: _meta.(info Get 'FileInfo.Author' etc.)
      meta.Put←{tab←⍺ ⋄ ~⍵[1]∊tab[;1]:tab⍪(≢⍉tab)↑⍵ ⋄ tab[tab[;1]⍳#.Strings.nocase ⍵[1];2]←⍵[2] ⋄ tab}  ⍝ provide a dfn for easy access to info, ie: _meta.(info Get 'FileInfo.Author' etc.)
    ∇


⍝ from dfns: (slightly modified to allow type=2 as default (if omitted))
      mns←{                                         ⍝ Make NS from association list ⍵.
          ⍺←⎕NS''                                   ⍝ default new space.
          0=≢⍵:⍺                                    ⍝ list exhausted: finished.
          w←{2=|≡⍵:,⊂⍵ ⋄ ,⍵}⍵                       ⍝ ensure proper format
          name class value←{(1↑⍵),¯2↑2,1↓⍵}⎕IO⊃w    ⍝ first triple.
          class=2:⍺ ∇ 1↓w⊣name ⍺.{⍎⍺,'←⍵'}value     ⍝ var: assign.
          class∊3 4:⍺ ∇ 1↓⍵⊣⍺.⎕FX value             ⍝ fn or op: fix.
          class=9:⍺ ∇ 1↓w⊣name ∇ ⍺.{                ⍝ space: recursively process,
              (⍎⍺,'←⎕NS ⍬')⍺⍺ ⍵                     ⍝   in new sub-space,
          }value                                    ⍝   the sub-list.
          'Eh?'⎕SIGNAL 11                           ⍝ unrecognised class: abort.
      }

⍝ from dfns (unmodified): compare 2 namespaces
      refmatch←{⎕ML←1                             ⍝ Space reference match.
          ⍺ ⍵{                                    ⍝ ⍺: vectors of visited refs
              =/⍵:1                               ⍝ identical refs: yes
              ≢/⍵.(⎕NL 2 3 4 9):0                 ⍝ content lists differ: no
              ≢/⍵.(⍎¨'0',↓⎕NL 2):0                ⍝ variables differ: no
              ≢/⍵.⍎⊂'⎕ct⎕div⎕io⎕ml⎕pp⎕rl⎕rtl':0   ⍝ sys vars differ: no
              ≢/⍵.(⎕CR¨↓⎕NL 3 4):0                ⍝ function source differs: no
              ⍬ ⍬≡refs←⍵.(1↓⍎¨'0',↓⎕NL 9):1       ⍝ subspaces per ref else stop
              ∨/⍺∊∊refs:1                         ⍝ cycle: ignore and stop
              ∧/(⍺,∊refs)∘∇¨↓⍉↑refs               ⍝ compare subspaces
          }⍺ ⍵                                    ⍝ ⍵: pair of refs to be searched
      }


    ∇ str←{opts}fmtDate ts;days;months;idn
   ⍝ format a date in ⎕TS-Format as a string.
   ⍝ Format currently fixed as DDD, MMM dd yyyy hh:mm
   ⍝ opts not used - might be extended later...
      days←'Mon' 'Tue' 'Wed' 'Thu' 'Fri' 'Sat' 'Sun'
      months←'Jan' 'Feb' 'Mar' 'Apr' 'May' 'Jun' 'Jul' 'Aug' 'Sep' 'Oct' 'Nov' 'Dec'
      idn←+2 ⎕NQ'.' 'IDNToDate'(2 ⎕NQ'.' 'DateToIDN'ts)
      str←(1+4⊃idn)⊃days
      str,←', ',(idn[2]⊃months),' ',(,'ZI2'⎕FMT 3⊃idn),' ',(⍕1⊃idn),(5≤≢ts)/' ',¯1↓,'ZI2,<:>'⎕FMT ¯2↑5↑ts
    ∇

    ∇ str←{opts}fmtX nr;r1;r2;fmt;l;temp;⎕IO;⎕ML;defaults
 ⍝ Extended numeric formatting. Total length of result may vary (no spaces),
 ⍝ will indicate where numbers are smaller than visible digits would allow,
 ⍝ ⍳0 shown as "N/A".
 ⍝ nr: num scalar or vec (text will be return unmodified)
 ⍝ being lazy about vectors - challenge would be to handle that better
 ⍝ opts: optional name/value-pairs as follows (or num-scalar → dec)
 ⍝ dec    - scalar: number of decimals (dflt 4 - unless nr is integer)
 ⍝ negInf - charvec for ⌈/⍳0
 ⍝ Inf    - charvec for ⌊/⍳0
 ⍝ empty  - if we have a nested vector with ⍬ in a cell
 ⍝ blankZero (deflt: 0) - show blank instead of zero
 ⍝
 ⍝ str: char-vec, nr formatted according to specs
 ⍝ samples:
 ⍝  2 fmtX  0.000000001 ¯0.000000001 (⌈/⍬)  (⌊/⍬)     3.14
      :If (⎕DR nr)∊(⎕DR' '),⎕DR'⍳' ⋄ str←nr ⋄ →0 ⋄ :EndIf
      defaults←mns('dec'#.Prefs.decimalsO)('negInf' '-INF')('Inf' 'INF')('empty' 'N/A')('blankZero' 0)
      :If ~(⎕DR nr)∊645 1287 1289 ⋄ defaults.dec←0 ⋄ :EndIf
      :If 0=⎕NC'opts' ⋄ opts←defaults
      :ElseIf 2=⎕NC'opts' ⍝ otherwise its a ns and then we don't need to do anything
          :If 83=⎕DR opts ⋄ opts←'dec'opts ⋄ :EndIf
          :If 3>|≡opts ⋄ opts←⊂opts ⋄ :EndIf
          opts←mns,opts
          ('temp'⎕NS ⍬)∘⎕NS¨defaults opts
          opts←temp
      :EndIf
     
      ⎕IO←⎕ML←1
      :If 0=≢nr ⋄ str←opts.empty
      :ElseIf 1<≢,nr ⋄ str←opts fmtX¨nr
      :ElseIf nr=⌈/⍬ ⋄ str←opts.negInf
      :ElseIf nr=⌊/⍬ ⋄ str←opts.Inf
     
      :Else
     
          :Trap 0
              l←1+2⌈{⍵+⌊⍵÷3}1+⌊10⍟⌈/|,nr  ⍝ how many characters do we need for integer part? (includes space needed for decorations and also counts groups of 3digits which get an extra separator between them)
          :Else ⋄ l←20 ⋄ :EndTrap  ⍝ very pragmatic fix, should rethink with a bit more time...
     
          fmt←'C',(opts.blankZero/'B'),'M⎕-⎕'   ⍝ negative prefix
          r1←10*-opts.dec
          r2←r1-10*-opts.dec+1 ⍝ replacement value
          nr←(×nr)×(|nr)⌈r2
          fmt,←'O',(⍕r2),'⎕<',(⍕r1),'⎕'
          fmt,←'O',(⍕-r2),'⎕>-',(⍕r1),'⎕'
     
          fmt,←(1+opts.dec>0)⊃'IF'
          fmt,←(⍕l+opts.dec+opts.dec>0)
          fmt,←(opts.dec>0)/'.',⍕opts.dec
          str←,fmt ⎕FMT nr
          ⍝⎕←'fmt=',fmt
          str←{(∨\⍵≠' ')/⍵}str
          str←{(-'.'=⊢/⍵)↓⍵}{(⌽∨\⌽(⍵≠'0')∨~'.'∊⍵)/⍵}str   ⍝ #177: no trailing zeros
      :EndIf
    ∇

    alphKey←{r←⌈⍵÷26 ⋄ ⎕A[1+(r⍴26)⊤⍵-1]}
    isDefined←{6::0 ⋄ ⍺←⎕this ⋄ 1⊣⍺⍎⍵}

    :section MultiPageSubroutines
⍝ TODO: #158 Grid.based wizards need to respond to change of dataset
    ∇ (js t)←BuildGrid ns;body;typ;atts;val;cid;js∆;postCol;append;cell;style;c;tr;r;type;tb;w;preCell;trHasContent;nr;items;ctl;ig;i;ctl_var;params;dflt;h;j;gridVers;Atts;isValid;dec;types;validateCell;name;errorMsg;errFlag;icon;eval;t∆;ts;cd;home;pct;v;hasTypeIndicator;gridValid;⎕TRAP;topitem
    ⍝ ns=namespace
    ⍝ ns.BuildGridMode≡Init|Update (in which case we only return JS!)
    ⍝ R=JavaScript (plain JS!)
    ⍝ t=collection of controls that will be added to container (or better: table-control...)
      js←js∆←''  ⍝ js is "JS-Collector" for table, js∆ for cell (must make sure to append it after content has been added...if mode≡'Update'!)
      :If 0=ns.⎕NC'EventArg' ⋄ ns.EventArg←'' ⋄ :EndIf  ⍝ make sure it is defined...
      (1⊃⎕RSI).Use'⍎/assets/eComboBox/jquery.eComboBox.js'
      (1⊃⎕RSI).Use'⍎/AutoNumeric/autoNumeric.min.js'
    ⍝   ⎕←'── Name───────────────────┬─Type ─────────────┬─ Values────────────────────────────────────────────────────────'
    ⍝   :If 9=ns.⎕NC'Grid' ⋄ ⎕←ns.Grid.(Names,'│',Attributes.Type,' ','│',' ','│',' ',⍕¨Values)
    ⍝   :Else ⋄ ⎕←ns.(GridTypes,' ','│',' ',GridNames,' ','│',' ',(⍕¨GridValues)) ⋄ :EndIf
    ⍝    ⍝⎕json¨ns.Grid.Attributes
      gridVers←1  ⍝ default
      gridValid←1  ⍝ init with 0  ⍝ changed 250223 to assume initial correctness
    ⍝   ⎕←'BuildGrid(a):',ns.UserSpace
     
      ⍝:If (⊂ns.Type)∊types←'hypothesisAPI.Grid' 'Hypothesis' 'confIntAPI.Grid' 'anovaAPI' 'sampleSizeAPI.Grid' 'chiSquareAPI.Grid' ⍝ the "new" grids (Aug 2019)
      :If (⊂ns.Type)∊types←'hypothesisAPI.Grid' 'Hypothesis' 'confIntAPI.Grid' 'sampleSizeAPI.Grid' 'chiSquareAPI.Grid' 'anovaAPI' 'probabilityAPI.Grid' 'regressAPI.Grid' ⍝ the "new" grids (Aug 2019)
          gridVers←2  ⍝ new grids with ns.Grid.(Values Names Attributes)
        ⍝   t←'.table .table-sm .table-borderless style=table-layout:fixed; .col-lg-8'#.HtmlElement.New #._.table
          :If 0=ns.⎕NC'btCols' ⋄ ns.btCols←'.col-lg-8' ⋄ :EndIf
          t←(ns.btCols,' .table .table-sm .table-borderless style=table-layout:fixed;')#.HtmlElement.New #._.table
          ⍝t←#.HtmlElement.New #.sC  (#.tsSiteTools.mns('_Tag' 'table')('_Attributes' '.table .table-sm .table-borderless style=table-layout:fixed; .col-lg-8'))
          tb←t.Add #._.thead
        ⍝   :if ∨/'regressAPI'⍷∊⎕si
        ⍝   ⎕←ns.Grid.Names
        ⍝   ⎕TRAP←0'S' ⋄ (⎕lc[1]+1)⎕stop 1⊃⎕xsi
        ⍝   :endif
          ⍝⎕se.Dyalog.Utils.display  api_ns.Grid(Names Values)
          :For r :In ⍳≢ns.Grid.Names
              tr←#.HtmlElement.New #._.tr ⋄ trHasContent←0
              :For c :In ⍳2⊃⍴ns.Grid.Names
                  name←c⊃ns.Grid.Names[r;]
                  
                  topitem←⍬
                  style←'padding:12px 0 12px 0!important;'
                  Atts←ns.Grid.Attributes[r;c]
                  :If 2=Atts.⎕NC'Digits'  ⍝ quick&dirty hack until I know if Digits is supposed to be "Decimals" or if other functionality is expected...
                  :AndIf 0=Atts.⎕NC'Decimals'
                      Atts.(Decimals←Digits)
                  :EndIf
                  validateCell←name≡ns.EventArg  ⍝ only validate cell if it was changed! (causes confusing msgs otherwise with F-Fields that have an illegal default of 0)
                  :If r=1 ⍝ ensure fixed width for all columns
                      w←100÷≢⍉ns.Grid.Names
                      style,←'width: ',(⍕⌊w),'%;max-width: ',(⍕⌈w),'%;'
                  :EndIf
                  ⍝:If c=2 ⋄ style,←'padding-right:0!important;' ⋄ :EndIf
                  cell←('#c',(⍕r),(⍕c))tr.Add(1+r>1)⊃#._.th #._.td
     
                  append←⍬
                  js∆←atts←''
                 ⍝ :If 0<≢(⍕c⊃ns.Grid.Values[r;])~' '
                ⍝   :if  ×2=c
                ⍝     ⎕←'───────────────────────── ',(⍕r),' / ',(⍕c),' ─────────────────────────'
                ⍝     ⎕←'Name : ',ns.Grid.Names[r;c]
                ⍝     ⎕←'Value: ',ns.Grid.Values[r;c]
                ⍝     ⎕←'Attributes:' ⋄ ⎕SE.Dyalog.Utils.display #.JSON.fromAPL ns.Grid.Attributes[r;c]
                ⍝   :endif
                  :If {6::1 ⋄ ns.Grid.currDS∆≢⍵}ns.currDS
                  :OrIf ns.BuildGridMode≡#.Strings.nocase'INIT'
                  :OrIf ns.Grid.Names[r;c]≢ns.Grid.Names∆[r;c]
                  :OrIf ns.Grid.Values[r;c]≢ns.Grid.Values∆[r;c]
                  :OrIf ~ns.Grid.Attributes∆[r;c]refmatch ⎕NS ns.Grid.Attributes[r;c]
                      :If (ns.BuildGridMode≢#.Strings.nocase'INIT')
                        ⍝   ⎕←'[',r,';',c,'] ∘ bool=',(ns.Grid.Names[r;c]≢ns.Grid.Names∆[r;c]),(ns.Grid.Values[r;c]≢ns.Grid.Values∆[r;c]),(~ns.Grid.Attributes∆[r;c]refmatch ns.Grid.Attributes[r;c])
⍝                          ∘∘∘
                      :EndIf
                      cid←'cnt',(⍕r),⍕c  ⍝ Content-ID (could be used for inputs within the cell)
                      trHasContent←1
                      val←c⊃ns.Grid.Values[r;]
                      atts←(r=1)/'.font-weight-normal'
                      typ←Atts.Type
                      isValid←1
                      errorMsg←Atts{6::'' ⋄ ⍺⍎⍵}'ErrorMsg'
                      pct←0
                      :If typ∊'INFX' ⋄ val←#.Strings.tonum val   ⍝ make sure we validate a number for these fields
                      :ElseIf typ∊'PQ' ⋄ val←(0.01*pct)×#.Strings.tonum(-pct←'%'=⊃⌽val)↓val ⋄ :EndIf
                      :If 0<Atts.⎕NC'validate'
                      :AndIf validateCell
                          :Trap 0
                              :If ~isValid←(,1)≡,Atts.validate val
                                  atts,←' .is-invalid'
                              :EndIf
                          :Else
                              ⎕←'Error validating field "',(c⊃ns.Grid.Names[r;]),'", [',(⍕r),';',(⍕c),']: ',((⎕VR'Atts.validate')~'∇',⎕UCS 13),' ',val,' | Type=',typ
                              isValid←0
                          :EndTrap
                      :EndIf
                    ⍝   ⎕←'Atts=',#.JSON.fromAPL Atts
                      :If 2=Atts.⎕NC'ReadOnly'
                      :AndIf Atts.ReadOnly
                          atts,←' readonly=readonly'
                      :EndIf
                      :Select typ
                      :CaseList 'AT'
                          atts,←' .input-group-text'
                          :Select Atts{6::'L' ⋄ ⍺⍎⍵}'Align'
                          :Case 'C' ⋄ atts,←' .text-center'
                          :Case 'R' ⋄ atts,←' .text-right'
                          :EndSelect
                          :If typ='T' ⋄ atts,←' readonly' ⋄ :EndIf
                          :If #.HtmlElement.isNum val
                            ⍝   ⎕←'Found number in a T-Cell!'
                            ⍝   ⎕←'Atts contains:' ⋄ ⎕←Atts.⎕NL-⍳9
                              :If Atts{6::0 ⋄ 1⊣⍺⍎⍵}'FormatString'
                                  val←,Atts.FormatString ⎕FMT val
                                  atts,←' .text-right'
                              :Else
                                  dec←Atts{6::#.Prefs.decimalsO ⋄ ⍺⍎⍵}'Decimals'
                                  val←dec #.tsSiteTools.fmtX val
                                  atts,←' .text-right'
                              :EndIf
                          :EndIf
⍝                              ⎕←'val="',val,'", ctl="',ctl.Render
                          :If 0=≢val~' ' ⋄ val←'&nbsp;' ⋄ :EndIf
                          :If typ='T'                               ⍝ T = text (readonly)
                          :OrIf Atts{2=⍺.⎕NC ⍵:⍺⍎⍵ ⋄ 0}'ReadOnly'     ⍝ or if ReadOnly is set
                              ctl←atts cell.Add #._.span val
                          :Else         ⍝ A=alphanumeric input
                        ⍝ctl←atts cell.Add #._.input val
                              :If val≡'&nbsp;'
                                  val←''
                              :EndIf
                              ctl←(atts,' .form-control #',cid,' type=text value="',(⍕val),'"')cell.Add #._.Input
                          :EndIf
                      :Case 'N'
                            ⍝   ctl←(atts,' .form-control #',cid,' .text-right type=number min=1 value="',(⍕val),'" onkeydown="OnlyArrowKeys(event);"')cell.Add #._.Input
                          ctl←(atts,' onkeyup=HandleANkeys(event) .autoNumeric .form-control #',cid,' .text-right type=text data-decimal-places=0 value=',(⍕val))cell.Add #._.Input
                      :Case 'I'
                          ctl←(atts,' onkeyup=HandleANkeys(event) .autoNumeric .form-control #',cid,' .text-right type=text data-decimal-places=0 value=',(⍕val))cell.Add #._.Input
                          :If (,'N')≡,typ
                          :AndIf (,val)≡,0
                              atts,←' .is-invalid'
                              errorMsg←'0 is not an accepted value for this field!'
                          :EndIf
                      :Case 'F'
⍝                          ⎕←'[',r,';',c,']:',name ⋄ ∘∘∘
                          :If Atts{6::0 ⋄ 1⊣⍺⍎⍵}'ReadOnly'
                          :AndIf Atts{6::0 ⋄ 1⊣⍺⍎⍵}'FormatString'
                              ctl←(atts,' #',cid,' .form-control type=text .text-right value="',(,Atts.FormatString ⎕FMT val),'"')cell.Add #._.Input
                          :Else
                              dec←{6::⍕#.Prefs.decimalsO ⋄ 2=⍵.⎕NC'Decimals':⍕⍵.Decimals ⋄ ∊('\.(\d*)'⎕S'\1')⍵.FormatString}Atts
                              ctl←(atts,' onkeyup=HandleANkeys(event)  .form-control #',cid,' .text-right type=text data-format-on-page-load=false data-minimum-value=',(⍕10*-(#.Prefs.decimalsO×dec=0)⌈⍎dec),((dec=0)/' .autoNumeric data-decimal-places=',dec),' value="',(⍕val),'"')cell.Add #._.Input
                          :EndIf
                      :CaseList 'PQ' ⋄
                          ⍝val←val×100*val≤1
                          ig←'.input-group'cell.Add #._.div
                          :If Atts{6::0 ⋄ 1⊣⍺⍎⍵}'ReadOnly'
                          :AndIf Atts{6::0 ⋄ 1⊣⍺⍎⍵}'FormatString'
                              Atts.Decimals←Atts{6::2⊃⎕VFI⊃('\d*\.(\d*)'⎕S'\1')⍵ ⋄ ⍺.Decimals}Atts.FormatString  ⍝ get Decimals from FormatString (avoid overwriting it, if defined)
                          :EndIf
                          dec←Atts.{6::1 ⋄ ⍺⍎⍵}'Decimals' ⍝ get Atts.Decimals or 1 (actual value not used, needs to be >0)
                          pct←Atts{6::0 ⋄ ⍺⍎⍵}'EnteredPercent'
                        ⍝   ctl←(atts,' onkeyup=HandleANkeys(event)  .form-control #',cid,' .text-right .d-inline type=text',((dec=0)/' .autoNumeric data-decimal-places=',{6::⍕#.Prefs.decimalsP ⋄ 2=⍵.⎕NC'Decimals':⍕⍵.Decimals ⋄ ∊('\.(\d*)'⎕S'\1')⍵.FormatString}Atts),' data-mimimum-value=0 data-maximum-value=100 value=',(⍕pct{~⍺:⍕⍵ ⋄ (⍕100×⍵),'%'}val))ig.Add #._.Input
                          ctl←(atts,' onkeyup=HandleANkeys(event)  .form-control #',cid,' .text-right .d-inline type=text',(' .autoNumeric data-decimal-places=',{6::⍕#.Prefs.decimalsP ⋄ 2=⍵.⎕NC'Decimals':⍕⍵.Decimals ⋄ ∊('\.(\d*)'⎕S'\1')⍵.FormatString}Atts),' data-mimimum-value=0 data-maximum-value=100 value=',(⍕pct{~⍺:⍕⍵ ⋄ (⍕100×⍵),'%'}val))ig.Add #._.Input
                          ⍝'.input-group-append'ig.Add #._.div('.input-group-text'#.HtmlElement.New #._.span'%')
                          :If (,'Q')≡,typ
                          :AndIf val∊0 1 100
                              atts,←' .is-invalid'
                              errorMsg←(⍕val),' is not an accepted value for this field!'
                          :EndIf
                      :Case 'X' ⋄ ctl←(atts,' onkeyup=HandleANkeys(event) .autoNumeric .form-control #',cid,' .text-right type=text data-decimal-places=',({6::⍕#.Prefs.decimalsO ⋄ 2=⍵.⎕NC'Decimals':⍕⍵.Decimals ⋄ ∊('\.(\d*)'⎕S'\1')⍵.FormatString}Atts),' value=',(⍕val))cell.Add #._.Input
                      :CaseList 'DEde' ⍝ uppercase includes stats, lowercase does not (only if List is a single character)
                          hasTypeIndicator←0
                          items←Atts.Items
                          :If 0 1∧.=(≡,≢)items  ⍝ if Items is a single character...
                              hasTypeIndicator←1  ⍝ if its a var or expression, it gets a type indicator
                              :Select items
                              :Case 'F' ⋄ items←ns.UserSpace._meta._numVars
                              :CaseList 'B' ⋄ items←ns.UserSpace._meta._boolVars
                              :Case 'A' ⋄ items←ns.UserSpace._meta._allVars
                              :Else
                                  :If items∊#.Strings.lc ⎕A ⍝ its a lowercase character: suggest ALL vars - and only validate datatype after select...
                                      items←ns.UserSpace._meta._allVars
                                  :Else
                                      ⎕←'********* Error: can not determine items! name=',name
                                      ⎕←#.JSON.fromAPL Atts
                                  :EndIf
                              :EndSelect
                              :If 2=Atts.⎕NC'TopItem'
                                  items←(topitem←⊆Atts.TopItem)∪items  ⍝ intersect, just to be very sure we don't get "stats" twice
                              :EndIf
                          :EndIf
                          nr←1+(,'2')≡¯1↑ns.Grid.Names[r;]
                          :If typ='E'
                              items←(items∪,⊂,val)
                              js∆,←'$("#',cid,'").eComboBox({"allowNewElements" : true,"editableElements" : true    });'
                          :EndIf
                          icon←''
                          :If hasTypeIndicator
                              errFlag←0
                              v←⍕1+'2'=¯1↑name
                              :Select typ
                              :Case 'D' ⋄ t∆←'This selection should return'
                              :Case 'E' ⋄ t∆←'This expression should return'
                              :EndSelect
                              :Select Atts.Items
                              :Case 'Ff' ⋄ t∆,←' a numeric variable'
                              :Case 'Bb' ⋄ t∆,←' a boolean (Yes/No) variable'
                              :Case 'Aa' ⋄ t∆←'Any datatype permitted here'
                              :Else
                              :EndSelect
                              :If (⊂val)∊ref←ns.UserSpace._meta._allVars ⋄ t∆,←', the selected variable from the dataset is '
                              :Else ⋄ t∆,←', the current expression returns '
                              :EndIf
                              :If typ∊'DE'
                              :AndIf (⊂val)∊topitem
                                  eval←,0
                                  icon←'fas fa-cog fa-fw bg-success text-light'
                                  t∆←'You may define the statistical params of the dataset w/o requiring actual data at all!'
                              :ElseIf ~(⊂val)∊topitem
                                  eval←(1⊃⎕RSI).EvalExpression(⍕val)
                              :Else
                                  icon←'fas fa-cog fa-fw text-danger bg-white'
                                  errFlag←~isValid←0
                                  t∆←'Use of "stats" not allow for this field!'
                              :EndIf
                              :If 0=1⊃eval
                                  :If ~(⊂val)∊topitem
                                      :Select ⎕DR∊3⊃eval
                                      :Case 11 ⋄ icon←'bg-success text-light ',(#.Datatypes.name⍳⊂'Boolean')⊃#.Datatypes.icon ⍝ '.fas .fa-check-square .fa-fw .text-primary'
                                          t∆,←'a boolean (Yes/No) value.'
                                      :CaseList 80 82 160
                                          :If Atts.Items∊'FB'
                                              icon←'fas fa-exclamation-triangle fa-fw text-danger bg-white'
                                              t∆,←' a text-value (which is not permitted as Sample).'
                                              errFlag←~isValid←0
                                          :Else
                                              :If 2=ref←ns.UserSpace._meta.⎕NC'Scale_',⍕val
                                                  icon←'bg-success text-light ',{(#.Datatypes.name⍳⊂⍵)⊃#.Datatypes.icon}sc←ref←ns.UserSpace._meta⍎'Scale_',val
                                                  t∆,←'a value of scale ',sc
                                              :Else
                                                  icon←'bg-success text-light ',(#.Datatypes.name⍳⊂'Nominal')⊃#.Datatypes.icon ⍝ '.fas .fa-check-square .fa-fw .text-primary'
                                                  t∆,←' a nominal value'
                                              :EndIf
                                              errFlag←~isValid←1
                                          :EndIf
                                      :Else
                                          :If 2=ref←ns.UserSpace._meta.⎕NC'Scale_',⍕val
                                              icon←'bg-success text-light ',{(#.Datatypes.name⍳⊂⍵)⊃#.Datatypes.icon}sc←ref←ns.UserSpace._meta⍎'Scale_',val
                                              t∆,←'a numeric value with ',(#.Strings.lc sc),' scale'
                                          :Else
                                              icon←'fas fa-minus-square fa-fw text-light bg-success'
                                              t∆,←'a numeric value.'
                                          :EndIf
                                      :EndSelect
                                  :EndIf
                              :Else
                                  t∆←'an error! Pls. correct it - calculations will not be done with invalid input!'
                                  icon←'fas fa-exclamation-triangle fa-fw bg-white text-danger'
                                  errFlag←1
                                  isValid←0
                              :EndIf
                              :If 0<≢icon
⍝                                  ∘∘∘
                              :EndIf
                              :If 0<≢icon
                              :AndIf 0<≢t∆
                              :AndIf ~errFlag
                                      ⍝js∆,←'$("#typeIcon',v,'").jBox("Tooltip",{theme: "TooltipDark", content: "',t∆,'"});'
                                      ⍝js∆,←'$("#typeIcon',v,'").attr("data-jbox-content","',t∆,'");'
                                  js∆,←'$("#typ',(⍕r),(⍕c),'").attr("data-jbox-content","',t∆,'");'
                              :ElseIf errFlag
                                  errorMsg←t∆
                              :EndIf
                          :EndIf
                          ts←cell
                          :If val≢'stats'
                              ts←'.input-group'cell.Add #._.div
                          :EndIf
                          ctl←('#',cid,' .form-control',atts,(validateCell∧~isValid)/' .is-invalid')ts.Add #._.Select(⊂items,[1.5]{0=≢⍵~' ':'noSelection' ⋄ 2↓#.HTTPRequest.URLEncode'x'⍵}¨items)
                          :If val≢'stats'
                          :AndIf hasTypeIndicator
                              ts←('.input-group-append'ts.Add #._.div).Add #._.span''('.input-group-text #typ',3↓cid)
                              ('#typeIcon',(⍕r),(⍕c),(0<≢icon)/' class="fa-lg ',icon,'"')ts.Add #._.i  ⍝ 'style=position:absolute;right:.75em;top:.325em'
                          :EndIf
                       ⍝   :Else
                       ⍝       ctl←('#',cid,' .form-control',atts,(validateCell∧~isValid)/' .is-invalid')cell.Add #._.Select(items,[1.5]{2↓#.HTTPRequest.URLEncode'x'⍵}¨items)
                       ⍝   :EndIf
                          ctl.Selected←items⍳⊂,val
                          items←('\'''⎕R'\&quot;')items
                      :EndSelect
     
                      :If (⊂ctl.Tag)∊'input' 'select'
                          append,←('#if-',cid,' .invalid-feedback',(validateCell∧~isValid)/' .d-block')#.HtmlElement.New #._.div errorMsg                     ⍝ append div for validation-message
                          append,←#.HtmlElement.New #._.Handler('#',cid)'change' 'ChangeHandler'
                      :Else
⍝                          ⎕←'Diagnostic info [',(⍕r),';',(⍕c),']: tag will not get onChange-event: ',ctl.Tag,' as using in' ⋄ ⎕←ctl.Render
                      :EndIf
                      :If append≢⍬ ⋄ cell.Add append ⋄ :EndIf
                      :If ns.BuildGridMode≡#.Strings.nocase'UPDATE'
                          (h j)←#.Pages.tsPage.getHTMLjs getCellContent cell.Render
                          ⍝js,←('#c',(⍕r),⍕c)#.MiPage.Replace h
                          ⍝js←js,#.MiPage.Execute j,js∆
                          js,←'$("#c',((⍕r),⍕c),'").html("',(('"'⎕R'\\"')(∊h)),'");',j,js∆
                          :If isValid
                              js,←'$("btnRecalc").removeAttr("disabled");'
                          :Else
                              js,←'$("btnRecalc").attr("disabled","disabled");'
                          :EndIf
                          gridValid∧←isValid
                      :Else
                          js,←js∆
                      :End
                  :Else
⍝                      ⎕←'[',r,';',c,'] is empty'
                      :If (ns.BuildGridMode≢#.Strings.nocase'INIT')
                        ⍝   ⎕←'[',r,';',c,'] ∘ bool=',(ns.Grid.Names[r;c]≢ns.Grid.Names∆[r;c]),(ns.Grid.Values[r;c]≢ns.Grid.Values∆[r;c]),(~ns.Grid.Attributes∆[r;c]refmatch ns.Grid.Attributes[r;c])
⍝                          ∘∘∘
                      :EndIf
     
                  :EndIf
                  :If 0<≢style ⋄ 'style'cell.Set style ⋄ :EndIf
                ⍝   ⎕←r,';',c,', style=',style
     
              :EndFor
              :If trHasContent ⋄ tb.Add tr ⋄ :EndIf
              :If r=1 ⋄ tb←t.Add #._.tbody ⋄ :EndIf
          :EndFor
          ns.Grid.(Values∆ Names∆ Attributes∆←Values Names(⎕NS¨Attributes))
          ns.Grid.currDS∆←ns.currDS
          :If ns.BuildGridMode≡#.Strings.nocase'INIT'
              js,←'new AutoNumeric.multiple(".autoNumeric");'
          :Else
              js,←'refreshTooltip();'  ⍝ doing it after all the other manipulations in the hope it would pick up
          :EndIf
          ns.Grid.isValid←gridValid
      :EndIf
    ∇



    ∇ js←NStoJSrecords ns;tally;vars;mat;v;val
      vars←ns.⎕NL-2
      :If 9=ns.⎕NC'_meta'
      :AndIf 2=ns._meta.⎕NC'_tally'
          tally←ns._meta._tally
      :Else
          tally←≢ns⍎1⊃vars
      :EndIf
      vars←(tally=∊ns.{≢⍎⍵}¨vars)/vars
      js←'['
      mat←(tally,≢vars)⍴''
      :For v :In ⍳≢vars
          val←ns⍎v⊃vars
          :If vars[v]∊ns._meta._charVars
              val←{w←⍕⍵ ⋄ ((w='"')/w)←⊂'\"' ⋄ '"',(∊w),'"'}¨val
              val←('"\[Null\]"'⎕R'null')val
          :ElseIf vars[v]∊ns._meta._boolVars
              val←⊃¨(#.HtmlElement.(_false _true),⊂'null')[{83=⎕DR ⍵:⍵+1 ⋄ 3}¨val]
          :Else
              val←#.Strings.fmtNum¨val
              val←('\[Null\]'⎕R'null')val
          :EndIf
          val←(⊂'"',(v⊃vars),'":'),¨val
          ⍝val←(⊂(v⊃vars),':'),¨val
          mat[;v]←val,¨⊂(v<≢vars)/','
      :EndFor
      mat←'{',mat,⊂'},'
      js,←¯1↓∊∊¨↓mat
      js,←']'
    ∇

    ∇ ns←meta JSRecordsToNS js;v;FixBool;var
      :Access Public
      ns←⎕NS''
      ns{w←⍵ ⋄ (⊂⍺)⍎(1⊃⍵),'←⍵[2]'}¨↓(js[1].⎕NL-2),[1.5]js[1]⍎¨js[1].⎕NL-2
      :While 1<≢js
          js←1↓js
          ns{w←⍵ ⋄ (⊂⍺)⍎(1⊃⍵),',←⍵[2]'}¨↓(js[1].⎕NL-2),[1.5]{⍵≡⊂'null':⎕NULL ⋄ ⍵}¨js[1]⍎¨js[1].⎕NL-2
      :EndWhile
      FixBool←{r←1@{⍵∊¨(⊂(⊂'true'),⊂⊂'true')}⍵ ⋄ 0@{⍵∊¨(⊂(⊂'false'),⊂⊂'false')}r}
      :For v :In meta._boolVars
          var←FixBool ns⍎v
          ⍎'ns.',v,'←var'
      :EndFor
    ∇

    ∇ R←GetDOTNETVersion;vers;⎕IO;⎕USING
⍝ R[1] = 0/1/2: 0=nothing, 1=.net Framework, 2=NET CORE
⍝ R[2] = Version (text-vector)
⍝ R[3] = Version (identifiable x.y within [2] in numerical form)
⍝ R[4] = Textual description of the framework
      ⎕IO←1
      R←0 '' 0 ''
      :Trap 0
          ⎕USING←'System' ''
          vers←System.Environment.Version
          R[2]←⊂⍕vers
          R[3]←vers.(Major+0.1×Minor)
          :If 4=⌊R[3]   ⍝ a 4 indicates .net Framework!
              R[1]←1
              :If (⍕vers)≡'4.0.30319.42000'   ⍝ .NET 4.6 and higher!
                  R[4]←⊂Runtime.InteropServices.RuntimeInformation.FrameworkDescription
              :ElseIf (10↑⍕vers)≡'4.0.30319.' ⍝ .NET 4, 4.5, 4.5.1, 4.5.2
                  R[4]←⊂'.NET Framework ',2⊃R  ⍝ JD: good enough?  Otherwise I may need to dig into the registry according to https://docs.microsoft.com/de-de/dotnet/framework/migration-guide/how-to-determine-which-versions-are-installed?view=netframework-4.8
              :EndIf
          :ElseIf 3.1=R[3]  ⍝ .NET CORE
          :OrIf 4<R[3]
              R[1]←2
              ⎕USING←'System,System.Runtime.InteropServices.RuntimeInformation'
              R[4]←⊂Runtime.InteropServices.RuntimeInformation.FrameworkDescription
          :EndIf
      :Else
      ⍝ bad luck, go with the defaults
      :EndTrap
    ∇

    :endsection MultiPageSubroutines
:endnamespace
