/**
 * jQuery eComboBox - An editable Combo Box Plugin - http://www.reckdesign.de/eComboBox
 * 
 * @author  Recep Karadas
 * @version 1.0
 *
 * jQuery eComboBox generates editable Combo Boxes.
 *
 * Licensed under The MIT License
 *
 * @version			1.0
 * @since			22.05.2011
 * @author			Recep Karadas
 * @documentation	http://www.reckdesign.de/eComboBox
 * @license			http://opensource.org/licenses/mit-license.php
 *
 * Usage with default values:
 * ---------------------------------------------------------------------------------
 * $('#eComboBox').eComboBox();
 *
 * <select id="eComboBox">
 * 	<option>Value 1</option>
 * 	<option>Value 2</option>
 * 	<option>Value 3</option>
 * 	<option>Value 4</option>
 * </select>
 *
 */

(function($) {

    var methods = {
        init: function(options) {

            var settings = {
                'allowNewElements': true,
                'editableElements': true,
                'textBoxFocusColor': '#F1F1F1'
            };


            return this.each(function() {

                var wrapperElement = null;
                var selectElement = null;
                selectElement = $(this);
                var selected = "";
                // If options exist, lets merge them
                // with our default settings
                if (options) {
                    $.extend(settings, options);
                }

                $(this).data("settings", settings);

                if (settings.allowNewElements) {
                    selectElement.prepend('<option>{NEW ELEMENT}</option>');
                }
                // Create Input Element
                var inputEl = document.createElement('input');
                var inputElement = jQuery(inputEl).addClass("form-control");

                if (1 == selectElement.parent('.input-group').length) {
                    wrapperElement = selectElement.parent(".input-group");
                    // console.log("wrapper", wrapperElement);
                    // put input and select element in wrapper element
                    // console.log("wrapper before prepend", wrapperElement.html());
                    wrapperElement.prepend(selectElement).prepend(inputElement);
                    // console.log("wrapper after prepend", wrapperElement.html());
                } else {
                    // Create Wrapper Element 
                    var wrapperEl = document.createElement('span');
                    wrapperElement = jQuery(wrapperEl);
                    selectElement.before(wrapperElement);
                    // put input and select element in wrapper element
                    // console.log("wrapper before append", wrapperElement.html());
                    wrapperElement.append(inputElement).append(selectElement);
                    // console.log("wrapper after append", wrapperElement.html());
                }




                inputElement.css({
                    "background": settings.textBoxFocusColor,
                    "position": "absolute",
                    "display": "none"
                });


                resizeElements();

                selectElement.keydown(function(e) {
                    //alert(e.keyCode);
                    if (e.keyCode >= 37 && e.keyCode <= 40 || e.keyCode == 13) // arrow buttons or enter button
                        return;

                    selected = $(this).val();

                    if (e.keyCode == "46") { // del-key
                        if (selected != "{NEW ELEMENT}") {
                            $(this).children("option:selected").remove();
                        }
                        return;
                    }

                    if (selected == "{NEW ELEMENT}" || settings['editableElements']) {
                        inputElement.css({ "display": "inline" });
                        resizeElements();
                        selectElement.hide();
                        if (selected == "{NEW ELEMENT}") {
                            inputElement.val("").focus();
                        } else if (settings['editableElements']) {
                            inputElement.val($(this).val()).focus();
                        }
                    }
                });

                selectElement.change(function(e) {
                    if ($(this).val() == "{NEW ELEMENT}") {
                        selected = $(this).val();
                        inputElement.css({ "display": "inline" });
                        inputElement.val("").focus();
                        $(this).hide();
                    }
                });



                inputElement.keyup(function(e) {
                    var arg;
                    selected = $(this).val();
                    if (e.keyCode == 13) { //enter
                        var daList = $.map($("#" + $(selectElement).attr("id") + " option"), function(option) { return option.value; });
                        arg = escape(selected);
                        if (!daList.includes(selected)) {
                            if (selected != "") {
                                selectElement.append('<option value="' + arg + '">' + escape(selected) + '</option>');
                                selectElement.val(arg);
                            }
                        } else {
                            if (selected == "") {
                                selectElement.children('option:selected').remove();
                            } else {
                                //selectElement.children('option:selected').text($(this).val());
                                selectElement.children('option:selected').text(selected).val(selected); //MBaas: also assign the txt using val!
                            }
                        }
                        $(this).hide();
                        selectElement.show();
                        selectElement.focus();
                        arg = escape(selected);
                        selectElement.trigger("change", arg); //MBaas: trigger change-events
                        console.log("triggered change-event with arg=", arg);
                    } else if (e.keyCode == 27) { //MBaas: Esc
                        $(this).hide();
                        selectElement.show();
                        selectElement.focus();
                    }
                    /* resizeElements(); */
                });


                function resizeElements() {
                    //  wrapperElement.css({
                    //      "width": selectElement.outerWidth()
                    //  });
                    //console.log(new Error().stack)
                    //console.log("resizeElements1", inputElement.outerWidth());
                    var mnus = 0;
                    //    if (1 == inputElement.parent().siblings('.input-group-append').length) { mnus = inputElement.parent().siblings('.input-group-append').outerWidth(); }
                    inputElement.css({
                        "width": selectElement.outerWidth() - mnus
                    });
                    //console.log("resizeElements2", inputElement.outerWidth());
                }


            }); // END RETURN 
        },
        destroy: function() {
            $(this).parent().remove();
        },
        disableAddingNewElements: function() {
            var fChild = $(this).children().first();
            if (fChild.text() == "{NEW ELEMENT}") {
                fChild.remove();
            }
        },
        enableAddingNewElements: function() {
            var fChild = $(this).children().first();
            if (fChild.text() != "{NEW ELEMENT}") {
                $(this).prepend('<option>{NEW ELEMENT}</option>');
            }
        },
        disableEditingElements: function() {
            $(this).data('settings').editableElements = false;
        },
        enableEditingElements: function() {
            $(this).data('settings').editableElements = true;
        }
    };


    $.fn.eComboBox = function(method) {

        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist on jQuery.eComboBox');
        }

    };

})(jQuery);