function toggleFn(e, fn) {
    // callback when the toggle for a fn is clicked in the detailed list of fns (to toggle the status)
    var lbl = $("#lbl_" + fn);
    var resGridObj = $("#resGrid").data("ejGrid");
    var desc = lbl.text();
    var t = $("#chosenFn_" + fn).length;
    $("#toggle_" + fn).prop('checked', !t);
    if (t) { // fn has been selected (it has the active-class assigned
        resGridObj.hideColumns(fn);
        $("#chosenFn_" + fn).remove();

    } else { // fn has not been active
        // add it to the list of fns (and reorder the list!)
        resGridObj.showColumns(fn);
        $("#selFn").append("<li id='chosenFn_" + fn + "' class='search-choice' data-sortkey='" + fn + "'>" + desc + "<a class='search-choice-close' data-fn='" + fn + "' onclick='removeFn(this);'></a></li>");
        var fnsUl = $("#selFn");
        var fns = fnsUl.children("li");
        fns.sort(function(a, b) {
            var an = a.getAttribute('data-sortkey'),
                bn = b.getAttribute('data-sortkey');

            if (an > bn) {
                return 1;
            }

            if (an < bn) {
                return -1;
            }

            return 0;
        });

        fns.detach().appendTo(fnsUl);

    }

    return true;
}


function removeFn(arg) {
    // this is called when user clicks the Close-Button on a fn-name in the results-list to remove that fn
    var id = $(arg).data('fn');
    var resGridObj = $("#resGrid").data("ejGrid");
    $('#chosenFn_' + id).remove();
    var desc = $(arg).parent().text();
    resGridObj.hideColumns(id);
    $("#toggle_" + id).prop('checked', false);
}

function onContextMenuClick(obj, args) {
    console.log(obj);
    console.log(args);
}