var awesomepleteList;
var awesomepleteControl
var jBoxTooltip; /* tooltip-object */


function refreshTooltip() {
    jBoxTooltip.attach("");
}

function toggleAPLlb() {
    // weakness: should also respond to resize-event
    var mi = $("#mentoggleLB"); // menuitem

    if (1 == $(mi).data("lb")) {
        // *** hide lb
        $("#languageBar").remove();
        $("#topnav").css("margin-top", 0);
        $("#mentoggleLB").text("Show APL Language Bar");
        $(mi).data("lb", 0);
        $("body").css("margin-top", "0px"); // somehow not reset by lb's upd

    } else {
        // *** show lb
        APLanguageBar();
        $("#mentoggleLB").text("Hide APL Language Bar");
        $(mi).data("lb", 1);
    }
    $("body").trigger("onToggleLB");
}
document.addEventListener("ngn_resize", function (e) {
    $("#topnav").css("margin-top", $(".ngn_lb").height());

    if (0 >= $(".ngn_lb").height()) {
        toggleAPLlb();
    }
});


function toggleRecord(rowid) {
    var cell = dtObj.cell("#r" + rowid, 0);
    var c1 = $(cell.node()).children();
    var cells = $(dtObj.cells("#r" + rowid, ":gt(1)").nodes()); // all but the first cell (those that will need to receive the class)

    if (cell.data()) { // if cell is currently enabled
        c1.html($("#dtexcl").html());
        cells.addClass("excludeRow");
        cell.data(false);

    } else {
        c1.html($("#dtincl").html());
        cells.removeClass("excludeRow");
        cell.data(true);
    }

    var dtData = dtObj.rows({
        search: 'applied',
        selected: true
    }).data().toArray();
    $("#dtdata").val(JSON.stringify(dtData));
}




var lastKey = 0;

function onKeyupExpr(event) {
    // console.log(event);
    if (event.keyCode == 27) {
        if (lastKey == 27) {
            $("#ipExpr").val("");

        } else {
            var x = new jBox('Tooltip', {
                content: "Press Escape again to clear the input-field!",
                title: "Info...",
                onInit: function () {
                    this.open({
                        target: $('#ipExpr'),
                        position: "left",
                        animation: "tada",
                        theme: 'TooltipDark'
                    });
                }

            });
        }

    } else
    if (event.keyCode == 13) {
        //var ac = $("#ipExpr").attr("aria-owns"); // find the awesomplete-list 
        //if (0 == $("#" + ac + ":visible").length); // check if it is visible
        {
            $("#ipExpr").trigger("calc");
        } // only fire calc if it isn't (otherwise Enter was meant to select something)
    }

    lastKey = event.keyCode;
}


function swnav(idx) {
    /* Switch subnav to specified page. Assumes there are 2 pages only! */
    var tc = $("#tabcontent").children("div");
    $("#activeSubnav").val(idx);
    if (!$("#" + tc[idx - 1].id + "-men").hasClass("disabled")) {
        $("#" + tc[idx - 1].id + "-men").parent().addClass("active");
        $("#" + tc[idx - 1].id).collapse("show");

        $("#" + tc[2 - idx].id + "-men").parent().removeClass("active");
        $("#" + tc[2 - idx].id).collapse("hide");

        $("#" + tc[idx - 1].id).trigger("Activate");
    }
}


function DoPost(path, params) {

    // The rest of this code assumes you are not using a library.
    // It can be made less wordy if you use one.
    var newWin = window.open("", "TheWindow", "width=600,height=400");
    var form = document.createElement("form");
    form.setAttribute("method", "post");
    form.setAttribute("action", path);
    form.setAttribute("target", "TheWindow");

    for (var key in params) {
        if (params.hasOwnProperty(key)) {
            var hiddenField = newWin.document.createElement("input");
            hiddenField.setAttribute("type", "hidden");
            hiddenField.setAttribute("name", key);
            hiddenField.setAttribute("value", params[key]);

            form.appendChild(hiddenField);
        }
    }

    document.body.appendChild(form);
    form.submit();
}


function tsCallout(target, pos, coTit, coTxt) {
    var calloutMgr = hopscotch.getCalloutManager();
    calloutMgr.createCallout({
        id: 'tsCallout',
        target: target,
        placement: pos,
        title: coTit,
        showCTAButton: true,
        ctaLabel: "Cancel",
        onCTA: calloutMgr.removeCallout("tsCallout"),
        content: coTxt
    });
}

function ToggleResult(obj) {
    var c = $(obj).data("expression-counter");
    $(".output" + c).toggle();
    $(obj)
        .find('[data-icon]')
        .toggleClass('fa-caret-down')
        .toggleClass('fa-caret-right');
}


var copied = ""; // remember id of last copy...
function AddClpCopy(nr, addMenu) {
    // adds a "copy to clipboard"-handler for object "id"
    var This = $("#clpcpy" + nr);
    var clpbrd;

    if (clpbrd) {
        clpbrd.destroy();
    }

    clpbrd = new ClipboardJS(".clpbrd" + nr);
    clpbrd.on('success', function (e) {
        console.log("success!");
        if (e.trigger.id !== copied) {
            new jBox('Notice', {
                content: 'Copied',
                color: 'black',
                attributes: {
                    x: 'right',
                    y: 'bottom'
                }
            });
            e.clearSelection();
            copied = e.trigger.id;
        }
    });


    //clpbrd.on('error', function (e) {});
    clpbrd.on('error', function(e) {
        console.error('Action:', e.action);
        console.error('Trigger:', e.trigger);
    });

    console.info("clpbrd" + nr, addMenu);

    if (addMenu) {

        var m = '<ul id="ctxt' + nr + '" class="ui-helper-hidden">';
        m += '<li class="clpbrd' + nr + '" data-clipboard-target=".output' + nr + '"><div><a href="#"><i class="far fa-copy"></i> Copy output</a></div></li>';
        m += '<li class="clpbrd' + nr + '" data-clipboard-target="#InOut' + nr + '"><div><a href="#"><i class="far fa-copy"></i> Copy input+output</a></div></li>';
        m += '</ul>';
        $(m).appendTo('body');
        $("#inp" + nr).contextmenu({
            delegate: "#clpcpy" + nr,
            menu: "#ctxt" + nr,
            position: {
                my: "right top"
            }
        });
    }

}

function DeleteInOut(id) {
    $("#InOut" + id).remove();
    $("#output").trigger("DeleteEntry", id);
}

function ToExpr(id) {
    $("#ipExpr").val($("#input" + id).text());
}

function scrollSmoothToBottom(id) {
    var div = document.getElementById(id);
    $('#' + id).animate({
        scrollTop: div.scrollHeight - div.clientHeight
    }, 500);
}

function SessionLog(obj) {
    if (0 < $("#InOut" + obj.nr).length) {
        $("#InOut" + obj.nr).replaceWith(obj.out);
        if (obj.mode == "A") {
            setTimeout(function () {
                scrollSmoothToBottom("output");
            }, 0); // "ugly as hell, but works"  https://stackoverflow.com/questions/6068955/jquery-function-after-append
        }
    } else {
        if (obj.mode == "A") {
            $("#output").append(obj.out);
            setTimeout(function () {
                scrollSmoothToBottom("output");
            }, 0);
        } else {
            $("#output").prepend(obj.out);
        }
    }

    if (obj.js) {
        eval(obj.js);
    }
}

function blowUpSVG(obj) {
    var layer = '<div id="canvas">';
    layer += '<i id="closeCanvas" class="fas fa-window-close" onclick="closeCanvas();"></i>';
    layer += $(obj).html() + '</div>';
    $(document.body).append(layer);
    $(document.body).keydown(function () {
        closeCanvas();
    });
}

function closeCanvas() {
    $("#canvas").remove();
    $(document.body).off("keydown");
}

function NoSubmitOnEnter() {
    $('form input').keydown(function (e) {
        if (e.keyCode == 13) {
            var inputs = $(this).parents("form").eq(0).find(":input");
            if (inputs[inputs.index(this) + 1] !== null) {
                inputs[inputs.index(this) + 1].focus();
            }
            e.preventDefault();
            return false;
        }
    });
}

// following code deals with copying SVG to clipboard - Clipboard.js did not do that...
// copied from https://stackoverflow.com/questions/33175909/copy-image-to-clipboard
// and slightly modified for usage in TS
// unfortunately it does not work - so the functionality will not be offered and this
// will never be called. I keep it here as a reminder to address the issue again -
// maybe browser technology will evolve to allow that...

function SelectText(element) {
    var doc = document;
    // console.log("element", element);
    if (doc.body.createTextRange) {
        var range = document.body.createTextRange();
        range.moveToElementText(element);
        range.select();
    } else if (window.getSelection) {
        var selection = window.getSelection();
        var range = document.createRange();
        range.selectNodeContents(element);
        selection.removeAllRanges();
        selection.addRange(range);
    }
}

function CopySVG(sel) {
    //Make the container Div contenteditable
    var obj = $(sel);
    // console.log(sel, obj.get(0));
    $(obj).attr("contenteditable", true);
    //Select the image
    SelectText($(obj).get(0));
    //Execute copy Command
    //Note: This will ONLY work directly inside a click listener
    document.execCommand('copy');
    //Unselect the content
    window.getSelection().removeAllRanges();
    //Make the container Div uneditable again
    $(this).removeAttr("contenteditable");
    new jBox('Notice', {
        content: 'Copied',
        color: 'black',
        attributes: {
            x: 'right',
            y: 'bottom'
        }
    });

}
String.prototype.textWidth = function () {
    var o = $('<div>' + this + '</div>')
        .css({
            'position': 'absolute',
            'float': 'left',
            'white-space': 'nowrap',
            'visibility': 'hidden'
        })
        .addClass('ui-widget')
        .appendTo($('body'));
    w = o.width();
    o.remove();
    return w;
}

function HandleANkeys(e) {
    var bhdt = false;
    var cid = e.target.id;
    var dp = $("#" + cid).data("decimal-places");
    if (e.key === "ArrowLeft" && e.ctrlKey) {
        $("#" + cid).data("decimal-places", dp + 1);
        bhdt = true;
    } else if (e.key === "ArrowRight" && e.ctrlKey) {
        $("#" + cid).data("decimal-places", Math.max(dp - 1, 0));
        bhdt = true;
    }
    if (bhdt) {
        var an = AutoNumeric.getAutoNumericElement("#" + cid);
        an.update({
            decimalPlaces: dp
        });
        event.preventDefault;
        return false;
    }
}


var delay = 0; // delay between calls (onResize is called continously when resizing....) (initially set to 250 but that causes some lag in the process, so I tokk it out to see how it behaves w/o throttling)
var throttled = false;

// window.resize event listener
$(window).resize(function () {
    if (!throttled) { // only if not throttled
        setHeightToMax();
        throttled = true; // slow down...

        setTimeout(function () { // Timeout
            throttled = false;
        }, delay);
    }
});

function setHeightToMax() {
    var d = $(".SetHeightToMax");
    var wh = window.innerHeight; // max height
    var oh = 0; // Object Height

    wh = wh - getBrowserScrollSize().height; // subtract size of an optional horizontal scrollbar */
    // This is not precise - we actually could use 4 pixels more - but I have no idea how to justify that (other than trial & error) - but I feel uncomfortable with it...
    d.each(function () {
        oh = wh - $(this).offset().top; // subtract starting position
        $(this).height(oh);
        // console.log("id", $(this).attr("id"), "wh", wh, "oh", oh);
    });
}

function getBrowserScrollSize() {

    var css = {
        "border": "none",
        "height": "200px",
        "margin": "0",
        "padding": "0",
        "width": "200px"
    };

    var inner = $("<div>").css($.extend({}, css));
    var outer = $("<div>").css($.extend({
            "left": "-1000px",
            "overflow": "scroll",
            "position": "absolute",
            "top": "-1000px"
        }, css)).append(inner).appendTo("body")
        .scrollLeft(1000)
        .scrollTop(1000);

    var scrollSize = {
        "height": (outer.offset().top - inner.offset().top) || 0,
        "width": (outer.offset().left - inner.offset().left) || 0
    };

    outer.remove();
    return scrollSize;
}

function onEnterClick(event, rarg) {
    if (event.keyCode === 13) {
        // console.log("clicking " + rarg);
        $("#" + rarg).trigger("click");
        event.preventDefault();
    }
    event.stopImmediatePropagation(); // disable regular keyup-handler
    return false;
}

function awesomepleteOnIpExpr() {
    awesomepleteControl = new Awesomplete(document.querySelector("#ipExpr"), {
        list: awesomepleteList,
        minChars: 1,
        filter: function (text, input) {
            return Awesomplete.FILTER_STARTSWITH(text, input.match(/[^\x20]*$/)[0]);
            /* return Awesomplete.FILTER_CONTAINS(text, input.match(/[^\x20]*$/)[0]); */
        },
        container: function (input) {
            input.parentNode.className = input.parentNode.className + " awesomplete";
            return input.parentNode;
            /* input.parentNode.style.display = "block"; */
        },
        item: function (text, input) {
            return Awesomplete.ITEM(text, input.match(/[^\x20]*$/)[0]);
        },
        tabSelect: true,
        replace: function (text) {
            var before = this.input.value.match(/^.+\x20\s*|/)[0];
            this.input.value = before + text + " ";
        }
    });
}

function UpdateFilename(event) { // used for the upload-modal during loadCSV etc.
    // console.log("UpdateFilename", event);
    // the change event gives us the input it occurred in 
    var input = event.srcElement;

    var fileInput = document.getElementById('theFile');
    var files = fileInput.files;
    var nms = "";
    for (var i = 0, file; file = files[i]; ++i) {
        nms = nms + (0 < nms.length ? " + " : "") + file.name;
    }
    $("#filename").text(nms);
    $("#action").val("processUpload");
}

function SaveDataset(FileName) {
    $("#filesave_title").text("Save dataset");
    $("#filesave_prompt").text('Current dataset "' + $("#currDS").val() + '" will be saved to local disk. Please enter path and filename (without extension) below:');
    $("#filesave_info").val("1");
    $("#filesave_name").val(FileName);
    $("#downloader").modal("show");

}

function onEnterClick(event, rarg) {
    if (event.keyCode === 13) {
        event.preventDefault();
        $("#" + rarg).trigger("click");
    }
    event.stopImmediatePropagation(); // disable regular keyup-handler
    return false;
}

function off() {
    new jBox('Notice', {
        content: 'Shutting down - please wait',
        color: 'yellow',
        attributes: {
            x: 'top',
            y: 'left'
        }
    });

}

function OnlyArrowKeys(e) {
    var cursorKey = e.keyCode === 38 || e.keyCode === 40;
    if (!cursorKey) {
        new jBox('Notice', {
            content: 'Please use CursorUp/Down to modify these values!',
            color: 'yellow',
            attributes: {
                x: 'bottom',
                y: 'right'
            }
        });
    
    }
    // return !cursorKey && e.preventDefault();
    var res = !cursorKey && e.preventDefault();
    // console.log(e);
    // e.stopImmediatePropagation();
    return res;
}